      subroutine read_psuedorest
c
c---This routine reads external restraints and adds them to 
c---the bond file. 
      implicit none
      include 'atom_com.fh'
      include 'restr_files.fh'
c
c---  locals
c
c---  Things for psuedo restraints
      integer ierr
      integer ia1,ia2,i1,i2,i3,i4,ibtype
      integer isym_out(4)
      real rs_vidl,rs_sigma
      character psuedorest_file*512
      logical ires_defined(2),chain_defined(2),ins_defined(2)
      logical atom_defined(2),alt_defined(2)
      logical dist_defined,sigma_defined,type_defined,prob_defined
      integer ires_in(2)
      character ins_in(2)*1,atom_in(2)*4,alt_in(2)*1,chain_in(2)*4
      real dist_value,sigma_value,prob_in
      integer ia_first_atom,ia_last_atom
c
c---  Things for parser
      integer maxtok,ntok,itk
      parameter (maxtok = 500)
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*600,key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer iend_r,lend_f
c
c---  loops and others
      integer   ifile,lps,nfile
      integer   i,j,k,l,ich,ires,ia,ir_first,ir_last,ia_first,ia_last
      integer   jrs
      character alt_code*1,ins_code*1,type_in*10
      character asmgrp*4,symm_in*1
      integer   ipsuedo,ibond,iscrk,file_in
      integer   nbonds
c
c--externals
      integer lenstr
      external lenstr
c
c---- Body
c
c---  Instruction may come from two sources. 1) External psuedorestraint file
c---  and 2) usual keyword file. Usual keyword would be sufficient. 
c---  Unfortunately psuedorestraint file has already been declared and out on 
c---  the web
      call ugtenv('PSRESTIN',psuedorest_file)
      lps = lenstr(psuedorest_file)
      if(lps.gt.0) then
         call open_form_file(ipsuedo,psuedorest_file,ierr)
         if(ierr.ne.0) then
            write(*,*)'Problem with psuedo restraint file'
         endif
      endif

      call open_form_file(iscrk,keywords_file,ierr)
      if(ierr.ne.0) then
         write(*,*)'Problem with keywords file'
         call errwrt(1,'Can not continue')
      endif
      call open_unform_file(ibond,bond_file,ierr)
      if(ierr.ne.0) then

      endif

C
c--read till the end
      nbonds = 0
      do while(.TRUE.)
         read(ibond,end=5) ia1,ia2,rs_vidl,rs_sigma,i1,i2,i3,i4,ibtype
         nbonds = nbonds +1
      enddo

 5    continue
      backspace ibond

      lend = .TRUE.
      key = ' '
      ierr = 0
      lend_f = 0
c
c---  If psuedo restraint file is present then use this file first
c---  Instructions from the keywords file have higher priority
      nfile = 1
      if(lps.le.0) nfile = 2
      do ifile=nfile,2
         if(ifile.eq.1) then
            file_in = ipsuedo
         else
            file_in = iscrk
         endif
         lend_f = 0
         key    = ' '
         do while(lend_f.eq.0.and.key(1:3).ne.'END'.and.ierr.eq.0)
            ires_defined(1) = .FALSE.
            ires_defined(2) = .FALSE.
            chain_defined(1) = .FALSE.
            chain_defined(2) = .FALSE.
            ins_defined(1) = .FALSE.
            ins_defined(2) = .FALSE.
            atom_defined(1) = .FALSE.
            atom_defined(2) = .FALSE.
            alt_defined(1) = .FALSE.
            alt_defined(2) = .FALSE.
            dist_defined = .FALSE.
            sigma_defined = .FALSE.
            type_defined  = .FALSE.
            prob_defined = .FALSE.
            lprint = .FALSE.
            line = ' '
            key = ' '
            symm_in ='N'
            do while(line.eq.' '.and.lend_f.eq.0)
               read(file_in,'(a)',iostat=lend_f)line
            enddo
            if(lend_f.lt.0) goto 888
            
            ntok = maxtok
            call parser(key,line,ibeg,iend,itype,fvalue,cvalue,idec,
     &           ntok,lend,lprint)
            call ccpupc(key)
            do  itk=2,ntok
               call ccpupc(cvalue(itk))
            enddo
            if(key.eq.'EXTE') then
               itk = 2
               if(cvalue(itk).ne.'DIST') ierr = 4
               if(cvalue(itk).eq.'DIST') then
                  itk = itk+1
 10               continue
                  if(cvalue(itk).eq.'FIRS') then
                     itk = itk + 1
 15                  continue
                     if(cvalue(itk).eq.'SECO'.OR.
     &                    cvalue(itk).eq.'FIRS'.OR.
     &                    cvalue(itk).eq.'VALU'.OR.
     &                    cvalue(itk).eq.'SIGM') goto 10
                     if(cvalue(itk).eq.'CHAI') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        chain_in(1) = line(ibeg(itk):iend(itk))
                        chain_defined(1) = .TRUE.
                        itk = itk +1.
                     else if(cvalue(itk).eq.'RESI') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)ires_in(1)
c     ires_in(1) = nint(fvalue(itk))
                        ires_defined(1) = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'INSE') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        ins_in(1) = line(ibeg(itk):iend(itk))
                        ins_defined(1) = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'ATOM') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        atom_in(1) = line(ibeg(itk):iend(itk))
                        atom_defined(1) = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'ALTE') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        alt_in(1) = line(ibeg(itk):iend(itk))
                        alt_defined(1) = .TRUE.
                        itk = itk + 1
                     endif
                     goto 15
                  else if(cvalue(itk).eq.'SECO') then
                     itk = itk + 1
 25                  continue
                     if(cvalue(itk).eq.'SECO'.OR.
     &                    cvalue(itk).eq.'FIRS'.OR.
     &                    cvalue(itk).eq.'VALU'.OR.
     &                    cvalue(itk).eq.'SIGM') goto 10
                     if(cvalue(itk).eq.'CHAI') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        chain_in(2) = line(ibeg(itk):iend(itk))
                        chain_defined(2) = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'RESI') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)ires_in(2)
c     ires_in(2) = nint(fvalue(itk))
                        ires_defined(2) = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'INSE') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        ins_in(2) = line(ibeg(itk):iend(itk))
                        ins_defined(2) = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'ATOM') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        atom_in(2) = line(ibeg(itk):iend(itk))
                        atom_defined(2) = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'ALTE') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        alt_in(2) = line(ibeg(itk):iend(itk))
                        alt_defined(2) = .TRUE.
                        itk = itk + 1
                     endif
                     goto 25
                  else if(cvalue(itk).eq.'VALU') then
                     itk = itk+1
                     if(itk.gt.NTOK) then
                        ierr = 1
                        goto 999
                     endif
                     if(itype(itk).ne.2) then
                        ierr = 2
                        goto 999
                     endif
                     read(line(ibeg(itk):iend(itk)),*)dist_value
c     dist_value = fvalue(itk)
                     dist_defined = .TRUE.
                     itk = itk + 1
                  else if(cvalue(itk).eq.'SIGM') then
                     itk = itk + 1
                     if(itk.gt.NTOK) then
                        ierr = 1
                        goto 999
                     endif
                     if(itype(itk).ne.2) then
                        ierr = 2
                        goto 999
                     endif
                     read(line(ibeg(itk):iend(itk)),*)sigma_value
c     sigma_value = fvalue(itk)
                     sigma_defined = .TRUE.
                     itk = itk + 1
                  else if(cvalue(itk).eq.'TYPE') then
                     itk = itk + 1
                     type_in = line(ibeg(itk):iend(itk))
                     type_defined = .TRUE.
                     itk = itk + 1
                  else if(cvalue(itk).eq.'PROB') then
                     itk = itk+1
                     if(itk.gt.NTOK) then
                        ierr = 1
                        goto 999
                     endif
                     if(itype(itk).ne.2) then
                        ierr = 2
                        goto 999
                     endif
                     read(line(ibeg(itk):iend(itk)),*)prob_in
c     prob_in = fvalue(itk)
                     prob_defined = .TRUE.
                     itk=itk+1
                  else if(cvalue(itk).eq.'SYMM') then
                     itk = itk + 1
                     if(itk.gt.ntok) then
                        ierr = 1
                        goto 999
                     endif
                     if(cvalue(itk)(1:1).eq.'Y') then
                        symm_in = 'Y'
                        itk = itk + 1
                     endif
                  endif
                  if(itk.lt.ntok) goto 10
               endif
c     
c---  Now check if everything is o.k. I.e. we have all necessary information
               if(.not.dist_defined) then
                  call errwrt(-1,'Value for the distance'//
     &                 ' must be defined')
                  ierr = 1
                  goto 999
               endif
               if(.not.sigma_defined) sigma_value = 0.02
               if(.not.ires_defined(1)) then
                  call errwrt(-1,
     &                 'Residue number for the first'//
     &                 ' atom has not been defined')
                  ierr = 1
                  goto 999
               endif
               if(.not.ires_defined(2)) then
                  call errwrt(-1,
     &                 'Residue number for the second'//
     &                 ' atom has not been defined')
                  ierr = 1
                  goto 999
               endif
               if(.not.chain_defined(1)) then
                  call errwrt(-1,
     &                 'Chain name for the first atom'//
     &                 ' has not been defined')       
               endif
               if(.not.chain_defined(2)) then
                  call errwrt(-1,
     &                 'Chain name for the second'//
     &                 ' atom has not been defined') 
               endif
               if(.not.atom_defined(1)) then
                  call errwrt(-1,
     &                 'Atom name for the first atom'//
     &                 ' has not been defined')
                  ierr = 1
                  goto 999
               endif
               if(.not.atom_defined(2)) then
                  call errwrt(-1,
     &                 'Atom name for the second atom'//
     &                 ' has not been defined')
                  ierr = 1
                  goto 999
               endif
               if(.not.ins_defined(1)) ins_in(1) = ' '
               if(.not.ins_defined(2)) ins_in(2) = ' '
               if(.not.alt_defined(1)) alt_in(1) = '.'
               if(.not.alt_defined(2)) alt_in(2) = '.'
               if(.not.type_defined) type_in = 'External'
c     
C---  Now find atomic numbers and write to a file
               do  ich=1,n_group
                  call get_asm_group_id(asmgrp,ich)
                  if(chain_in(1).eq.asmgrp) then
                     ir_first = ires_first(ich)
                     ir_last  = ir_first + nres_chain(ich)-1
                     do ires=ir_first,ir_last
                        read(res_num_pdb(ires)(3:6),*)jrs
                        ins_code = res_num_pdb(ires)(7:7)
                        if(ires_in(1).eq.jrs.and.
     &                       ins_code.eq.ins_in(1)) then
                           ia_first = iratm_first(ires)
                           ia_last  = ia_first+natm_res(ires)-1
                           do  ia=ia_first,ia_last
                              if(atom_in(1).eq.atm_name(ia).and.
     &                             alt_in(1).eq.id_alt(ia)) then
                                 ia_first_atom = ia
                                 goto 200
                              endif
                           enddo
                        endif
                     enddo
                  endif
               enddo
               ierr = 3
               goto 999
 200           continue
               do  ich=1,n_group
                  call get_asm_group_id(asmgrp,ich)
                  if(chain_in(2).eq.asmgrp) then
                     ir_first = ires_first(ich)
                     ir_last  = ir_first + nres_chain(ich)-1
                     do ires=ir_first,ir_last
                        read(res_num_pdb(ires)(3:6),*)jrs
                        ins_code = res_num_pdb(ires)(7:7)
                        if(ires_in(2).eq.jrs.and.
     &                       ins_code.eq.ins_in(2)) then
                           ia_first = iratm_first(ires)
                           ia_last  = ia_first+natm_res(ires)-1
                           do  ia=ia_first,ia_last
                              if(atom_in(2).eq.atm_name(ia).and.
     &                             alt_in(2).eq.id_alt(ia)) then
                                 ia_last_atom = ia
                                 goto 300
                              endif
                           enddo
                        endif
                     enddo
                  endif
               enddo
               ierr = 3
               goto 999
 300           continue
c
c---  Find out if these atoms are related (if symm defined by symmetry or) 
c---  directly
               isym_out(1) = 1
               isym_out(2:4) = 0
               if(symm_in.eq.'Y') then
                  call find_symm_contact(ia_first_atom,ia_last_atom,
     &                 isym_out)
               endif
c     
c---  Add this info into the file
               write(ibond)ia_first_atom,ia_last_atom,dist_value,
     &              sigma_value,(isym_out(i),i=1,4),2
               nbonds = nbonds + 1
            endif
         enddo
 888     continue
      enddo
 999  continue
      if(psuedorest_file(1:1).ne.' ') close(ipsuedo)
      close(iscrk)
      close(ibond)
c
c--   It needs to be read and sorted to remove duplicated restraints

c---  Read and remove redundant pairs.

      if(ierr.eq.0) return
c
c---Read, sort and remove duplicated bonds
c         call remove_duplicate_dists(bond_file)
c         return
c      endif
c
c---  Process errors
      if(ierr.eq.1) write(*,*)'Incomplete instruction for restrtaint'
      if(ierr.eq.2) write(*,*)'Wrong data type for distance/sigma'
      if(ierr.eq.3) write(*,*)'Specified atoms(s) could not be found'
      if(ierr.eq.4) write(*,*)'Wrong instruction'
      write(*,*)'Example of instructions:'
      write(*,*)'extr dist first residue <number> chain <name> atom'
     &//' <name> second residue <number> chain <name> atom <name>'
     &//' value <number> sigma <number>'
      write(*,*)'If alternative or insertion code are aslo present then'
     &//' they can be added using subkeywords alte or inse'
      call errwrt(1,'Cannot continue. Quitting now')
      return
      end
c
      subroutine find_symm_contact(ia1,ia2,isym_out)
      implicit none
      include 'atom_com.fh'
c
c---inputs
      integer ia1,ia2
c
c---outputs
      integer isym_out(4)
c
c---locals
      integer is,itx(3)
      real d_p,d_l
      real xyz_1(3),xyz_2(3),xyz_frac2(3),xyz_frac1(3),xyz_sym(3)
      real xyz_d(3),axyz(3),axyz_o(3)
      logical error
c
c---body
      xyz_1(1:3) = xyz_crd(1:3,ia1)
      xyz_2(1:3) = xyz_crd(1:3,ia2)
      call mat2vec(3,3,cs_ort_to_frac,xyz_2,xyz_frac2,error)
      call mat2vec(3,3,cs_ort_to_frac,xyz_1,xyz_frac1,error)
      d_p = 1.0e32
      isym_out(1) = 1
      isym_out(2:4) = 0
      do  is=1,cs_nsym
         call mat2vec(3,3,cs_m_cs(1,1,is),xyz_frac2,xyz_sym,error)
         xyz_sym(1:3) = xyz_sym(1:3) + cs_v_cs(1:3,is)
         call find_closest_xyz(xyz_frac1,xyz_sym,itx)
         axyz(1:3) = xyz_frac1(1:3) - (xyz_sym+itx(1:3))

c         xyz_d(1:3) = xyz_frac1(1:3) - xyz_sym(1:3)
c         call amod_r(xyz_d(1),1.0,itx(1),axyz(1))
c         axyz(1) = axyz(1)
c         call amod_r(xyz_d(2),1.0,itx(2),axyz(2))
c         axyz(2) = axyz(2)
c         call amod_r(xyz_d(3),1.0,itx(3),axyz(3))
c         axyz(3) = axyz(3)

         call mat2vec(3,3,cs_frac_to_ort,axyz,axyz_o,error)
         d_l = axyz_o(1)**2+axyz_o(2)**2+axyz_o(3)**2
         if(d_p.gt.d_l) then
            isym_out(1) = is
            isym_out(2:4) = itx(1:3)
            d_p = d_l
         endif
      enddo
      return
      end
c
      subroutine find_closest_xyz(xyz1,xyz2,itx)
      implicit none
c
c--Find itx(1:3) that would bring close xyz2 to xyz1
      real xyz1(3),xyz2(3)
      integer itx(3)
c
c---locals
      integer i
      real    t,t1
      real    xyz_l(3)
c
c---body
      itx(1:3) = 0
      xyz_l(1:3) = xyz2(1:3)

      do i=1,3
         do while (xyz_l(i).ge.xyz1(i))
            itx(i) = itx(i) - 1
            xyz_l(i) = xyz_l(i)-1.0
         enddo
         do while(xyz_l(i).le.xyz1(i))
            itx(i) = itx(i) + 1
            xyz_l(i) = xyz_l(i) + 1
         enddo
      
c
c--Now test two options xyz_l(i) + 1 and xyz_l(i)

         t  = abs(xyz_l(i) - xyz1(i))
         t1 = abs(xyz_l(i) - 1.0 - xyz1(i))
         if(t1.lt.t) itx(i) = itx(i) - 1
      enddo

      return
      end
c
      subroutine remove_duplicate_dists(bond_file)
c
c---  Read distance restraints and remove duplicates
c---  It may happen when automatic as well as external restraints are defined
      character bond_file*(*)
c
c---  locals
      include 'atom_com.fh'
      integer  ipos,it1,ifirst
      integer  ibond,ll,ifail
      integer  ibold(6)
      integer  nbonds
      integer, allocatable :: idist_atoms(:,:)
      integer, allocatable :: bond_type(:)
      integer, allocatable :: index_atoms(:)
      real,    allocatable :: bond_idl(:,:)
c
      integer iiden0,isym1(4),isym_out,itx_out(3),itx_in(3)
      integer lenstr
      external lenstr
c
c---  body
      if(lenstr(bond_file).le.0) return
      ibond = 0
      ll    = 0
      ifail = -1
      call ccpdpn(ibond,bond_file,'UNKNOWN','U',ll,ifail)
c
c--read till the end
      nbonds = 0
      do while(.TRUE.)
         read(ibond,end=5) ia1,ia2,rs_vidl,rs_sigma,i1,i2,i3,i4,ibtype
         nbonds = nbonds + 1
      enddo
 5    continue
      rewind ibond
      allocate(idist_atoms(6,nbonds))
      allocate(bond_idl(2,nbonds))
      allocate(bond_type(nbonds))
      allocate(index_atoms(nbonds))
      do ib=1,nbonds
         index_atoms(ib) = ib
      enddo
      iiden0      = 1
      ifirst      = 0
      do  ib=1,nbonds
         read(ibond,end=10)idist_atoms(1:2,ib),bond_idl(1:2,ib),
     &        idist_atoms(3:6,ib),bond_type(ib)
c
c---  Make sure that the index of first atom is smaller than that of the second
         if(idist_atoms(1,ib).gt.idist_atoms(2,ib)) then
            it1 = idist_atoms(2,ib)
            idist_atoms(2,ib) = idist_atoms(1,ib)
            idist_atoms(1,ib) = it1
            ibold(1:6) = idist_atoms(1:6,ib)
            itx_in(1:3) = -ibold(4:6)
            call sym_find_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,ibold(3),
     &           iiden0,itx_in,isym_out,itx_out,ifirst)
            ibold(3) = isym_out
            ibold(4:6) = itx_out(1:3)
            idist_atoms(1:6,ib) = ibold(1:6)
         endif
      enddo
 10   continue
      call iheap_sort_r(nbonds,6,idist_atoms,index_atoms)
c
c---  remove redundant bonds. Leave the last one
      rewind ibond
      ibold(1:6) = idist_atoms(1:6,1)
      ipos = index_atoms(1)
      do  ib=2,nbonds
         if(maxval(abs(ibold(1:6)-idist_atoms(1:6,ib))).ne.0) then
            write(ibond)ibold(1:2),bond_idl(1:2,ipos),ibold(3:6),
     &           bond_type(ipos)
            ipos = index_atoms(ib)
            ibold(1:6) = idist_atoms(1:6,ib)
         else
            ipos = index_atoms(ib)
         endif
      enddo
      write(ibond)ibold(1:2),bond_idl(1:2,ipos),ibold(3:6),
     &           bond_type(ipos)
      close(ibond)
      deallocate(idist_atoms)
      deallocate(bond_idl)
      deallocate(bond_type)
      deallocate(index_atoms)
c
      return
      end
