C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
C
      SUBROUTINE RIGID_BODY
      IMPLICIT NONE
C
C---Refienement by rigid body
      INCLUDE 'atom_com.fh'
      INCLUDE 'const.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'rigid_body.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'agreem.fh'

      INTEGER MCOLS
      PARAMETER (MCOLS = 200)
      REAL XORT0,ROT_RIGID,RIGID_TRANS,RIGID_ALPHA,TGRAV
      INTEGER IGROUP
      INTEGER ND_REMAIN
      PARAMETER (ND_REMAIN = QQM+2*QQV - (4*MAXATOM+18*MAXDOMAIN))
      REAL      WORK_D
      COMMON /LSQMTX/ XORT0(3,MAXATOM),IGROUP(MAXATOM),
     +                ROT_RIGID(3,3,MAXDOMAIN),RIGID_TRANS(3,MAXDOMAIN),
     +                RIGID_ALPHA(3,MAXDOMAIN),TGRAV(3,MAXDOMAIN),
     &                WORK_D(ND_REMAIN)

      INTEGER LOOKUP(MCOLS)
      INTEGER NLPRGI,NLPRGO
      COMMON /MTZRD/NLPRGI,NLPRGO,LOOKUP
      COMMON /REF_SPG/ GX,GU1,GQ
      REAL  GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
      INTEGER LREMAIN
      PARAMETER 
     +    (LREMAIN = QQDEN-(2*MAXDOMAIN6+MAXDOMAIN6*MAXDOMAIN6+18))
      REAL GX_RIGID,HX_RIGID,SHFT_RIGID,DXDDOMAIN,WORKSPACE
      COMMON /R_SCRATCH/ GX_RIGID(MAXDOMAIN6),
     +                   HX_RIGID(MAXDOMAIN6,MAXDOMAIN6),
     +                   SHFT_RIGID(MAXDOMAIN6),
     +                   DXDDOMAIN(3,6),WORKSPACE(LREMAIN)

      REAL SHFT_RIGID1(MAXDOMAIN6),TOLER
C---Local variables
      INTEGER ICYCL,IDOM,IWRITE_FIRST,IANALYSE_REST,NDOMAIN6
      integer jj,i1,i2
      INTEGER I,J,LWORK,IERROR
      REAL ALPHA,FXRAY_OLD,DELTA_SHIFTS,EPS_RIGID_CONVERGED
      LOGICAL LREFIN_SAVE,ALL_SCALE_SAVE,ERROR
      LOGICAL GAMMA_FLAG,STEP_FLAG
      REAL GAMMA,STEP
      CHARACTER MON_STYLE_SAVE*4,LINE*256
C
C---Convert atoms into orthogonal system
      HCALC_DIAG = .TRUE.
C
C---Define rigid body domains
      TOLER = 1.0E-7
      EPS_RIGID_CONVERGED = 1.0E-3
      CALL DEFINE_DOMAINS
      CALL FINDCGRAV

C
c----Initialise
      DO IDOM=1,NDOMAIN
         I1    = 6*(IDOM-1)
         SHFT_RIGID1(I1+1) = TRANS_INIT_RIGID(1,IDOM)
         SHFT_RIGID1(I1+2) = TRANS_INIT_RIGID(2,IDOM)
         SHFT_RIGID1(I1+3) = TRANS_INIT_RIGID(3,IDOM)
         SHFT_RIGID1(I1+4) = EULER_INIT_RIGID(1,IDOM)
         SHFT_RIGID1(I1+5) = EULER_INIT_RIGID(2,IDOM) 
         SHFT_RIGID1(I1+6) = EULER_INIT_RIGID(3,IDOM)
      ENDDO
      CALL APPLY_SHIFTS_RIGID(SHFT_RIGID1,DELTA_SHIFTS)

C---These should go
      NDOMAIN6 = NDOMAIN*6
      LWORK = LREMAIN - 5*NDOMAIN6
      MON_STYLE_SAVE = MON_STYLE
      DO    ICYCL=1,NRIGID_CYCLE
         WRITE(LINE,'(5x,A,I6)')'Rigid body cycle = ',ICYCL
         CALL ERRWRT(-1,' ')
         CALL ERRWRT(-1,LINE)
         CALL ERRWRT(-1,' ')
         ALPHA         = 1.0
         IWRITE_FIRST  = 1
         IANALYSE_REST = 0
         CALL ANALYSE_VDW(ALPHA,IWRITE_FIRST,IANALYSE_REST)
         IF(ICYCL.GT.1.AND.ICYCL.LT.NRIGID_CYCLE) THEN
            IF(MON_STYLE.EQ.'MEDI') MON_STYLE = 'FEW'
         ELSEIF(ICYCL.EQ.NRIGID_CYCLE) THEN
            MON_STYLE = MON_STYLE_SAVE
         ENDIF          
C
C---  Calculate derivatives wrt individual atomic parameters
         CALL REFALL
         CALL REPORT_XRAY_STATS
         FXRAY_OLD = FXRAY
C
C---  Precondition rigid body params
         CALL PRECOND_RBODY
C
C---  Calculate derivatives wrt rigid body parameters using chain rule
         CALL DERIVS_OF_RBODY
C     
C---  Solve linear equations using eigenvalue filtering
C     
C---  Predondition ????
         do jj=1,ndomain
            i1 = (jj-1)*6+1
            i2 = i1+5
            call eigen_filter_r(toler,hx_rigid(i1:i2,i1:i2),6,6,
     &           gx_rigid(i1:i2),shft_rigid1(i1:i2),workspace,lremain)
         enddo
c         CALL  EIGEN_FILTER_R(TOLER,HX_RIGID,NDOMAIN6,MAXDOMAIN6,
c     &        GX_RIGID,SHFT_RIGID1,WORKSPACE,LREMAIN)
         CALL APPLY_SHIFTS_RIGID(SHFT_RIGID1,DELTA_SHIFTS)
         WRITE(*,*)'Maximum shift =',DELTA_SHIFTS
cd         IF(DELTA_SHIFTS.LE.EPS_RIGID_CONVERGED) GOTO 100
         IF(MON_STYLE.EQ.'MANY'.OR.(MON_STYLE.NE.'NONE'.AND.
     +      ICYCL.EQ.NRIGID_CYCLE)) CALL PRINT_RIGIDPARS
      ENDDO
C
C---Write new mtz
 100  CONTINUE
      IF(NLPRGO.NE.0) THEN
        LREFIN_SAVE = LREFIN
        LREFIN    = .FALSE.
        CALL REFALL
        CALL REPORT_XRAY_STATS
        LREFIN = LREFIN_SAVE
      ENDIF
C
      RETURN
      END
C
      SUBROUTINE PRECOND_RBODY
C
C---Preconditioning rigid body.
      RETURN
      END
         
      SUBROUTINE DERIVS_OF_RBODY
      IMPLICIT NONE
C
C---Calculates derivatives of minimised function wrt domain parameters.
C---using chain rule. Neglects contribution of first derivative of function 
C---wrt (x,y,z) to second derviatives of fucntion wrt domain parameters.
C---Only diagonal terms of second derivative of function wrt (x,y,z) are
C---used
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'rigid_body.fh'
      INCLUDE 'restr_files.fh'
      INCLUDE 'refi_flags.fh'
      REAL XORT0,ROT_RIGID,RIGID_TRANS,RIGID_ALPHA,TGRAV
      INTEGER IGROUP
      INTEGER ND_REMAIN
      PARAMETER (ND_REMAIN = QQM+2*QQV - (4*MAXATOM+18*MAXDOMAIN))
      REAL      WORK_D
      COMMON /LSQMTX/ XORT0(3,MAXATOM),IGROUP(MAXATOM),
     +                ROT_RIGID(3,3,MAXDOMAIN),RIGID_TRANS(3,MAXDOMAIN),
     +                RIGID_ALPHA(3,MAXDOMAIN),TGRAV(3,MAXDOMAIN),
     &                WORK_D(ND_REMAIN)


      COMMON /REF_SPG/ GX,GU1,GQ
      REAL  GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
      INTEGER LREMAIN
      PARAMETER 
     +    (LREMAIN = QQDEN-(2*MAXDOMAIN6+MAXDOMAIN6*MAXDOMAIN6+18))
      REAL GX_RIGID,HX_RIGID,SHFT_RIGID,DXDDOMAIN,WORKSPACE
      COMMON /R_SCRATCH/ GX_RIGID(MAXDOMAIN6),
     +                   HX_RIGID(MAXDOMAIN6,MAXDOMAIN6),
     +                   SHFT_RIGID(MAXDOMAIN6),
     +                   DXDDOMAIN(3,6),WORKSPACE(LREMAIN)
C
      INTEGER IA,IA1,IA2,NS_DIST(4),IVDW_TYPE,ISCRV,IFAIL,LL
      INTEGER IRIG1,IRIG2,IGR1,IGR2,IPAR,IPAR1,IPAR0,IPAR10,IDOMAIN
      INTEGER IA11,IA12,IA21,IA22
      INTEGER IM,IV
      REAL WEIGHT
      REAL RS_VIDL,RS_SDI
      REAL DRDR1(3,6),DRDR2(3,6)
      REAL H_XXD,H_UUD(3),HQQD,H_UQD,H_QQD,X2DR(3)
      REAL H_XX(3,3),H_UU(6,6),H_QQ,H_XB(3),H_XU(3,6),H_XQ(3),H_QX(3),
     &     H_BQ,H_QB,H_UQ(6),H_QU(6)
      REAL CC,TMP,HX2DR(3)
      LOGICAL ERROR
      INTEGER LENSTR,I_USED
      REAL DOT1_R
      EXTERNAL LENSTR,DOT1_R
C
C---Initialise
      DO    IPAR=1,MAXDOMAIN6
        GX_RIGID(IPAR) = 0.0
        DO    IPAR1=1,MAXDOMAIN6
          HX_RIGID(IPAR,IPAR1) = 0.0
        ENDDO
      ENDDO
C
C---Calculate derivatives of minimised function wrt domain
C---parameters using chain rule. 
      IV = 0
      IM = 0
      DO   IA=1,N_ATOM
        IF(ATOM_REF_FLAG(IA).GT.0) THEN
          IRIG1 = IGROUP(IA)
          IA11 = ATOM_REF_FLAG(IA)/10
          IA12 = ATOM_REF_FLAG(IA)-IA11*10
          IF(IRIG1.GT.0.AND.IA12.GT.2) THEN
            CALL DERIVS_WRT_EULER1(XYZ_CRD(1,IA),TGRAV(1,IRIG1),DRDR1)   
            WEIGHT = 1.0
            IF(WEIGHT_DOMAIN(IRIG1).EQ.'MCHA') THEN
              IF(ATM_NAME(IA).EQ.'CA  '.OR.
     +           ATM_NAME(IA).EQ.'N   '.OR.
     +           ATM_NAME(IA).EQ.'C   '.OR.
     +           ATM_NAME(IA).EQ.'O   ')
     +               WEIGHT = WEIGHT_DOMAIN_VALUE(IRIG1)
            ELSEIF(WEIGHT_DOMAIN(IRIG1).EQ.'SCHA') THEN
              IF(ATM_NAME(IA).NE.'CA  '.AND.
     +           ATM_NAME(IA).NE.'N   '.AND.
     +           ATM_NAME(IA).NE.'C   '.AND.
     +           ATM_NAME(IA).NE.'O   ')
     +                 WEIGHT = WEIGHT_DOMAIN_VALUE(IRIG1)
            ENDIF
            CALL FAST_HESSIAN_DIAGONAL(IA,H_XXD,H_UUD,H_UQD,H_QQD)  
            IPAR0   = 6*IRIG1-6
            DO   IPAR = 1,6
              IPAR0 = IPAR0 + 1
              GX_RIGID(IPAR0) = GX_RIGID(IPAR0)+
     +                         (GX(IV+1)*DRDR1(1,IPAR)+
     +                          GX(IV+2)*DRDR1(2,IPAR)+
     +                          GX(IV+3)*DRDR1(3,IPAR))*WEIGHT
              IPAR10 = 6*IRIG1-6
              DO   IPAR1 = 1,6
                IPAR10 = IPAR10 + 1
                HX_RIGID(IPAR0,IPAR10) = HX_RIGID(IPAR0,IPAR10) + 
     +          H_XXD*DOT1_R(3,3,DRDR1(1,IPAR),DRDR1(1,IPAR1))
     +                                               *WEIGHT**2
              ENDDO
            ENDDO
            IM = IM + 6
            IV = IV + 3
          ENDIF
        ENDIF
      ENDDO
C
C---Add distance block. Read from the file.
cd      RETURN
      IF(.NOT.XNONDIAG_FLAG) RETURN
      IF(VDW_FILE_0(1:1).EQ.' ') RETURN
      ISCRV          = 0
      IFAIL          = -1
      CALL CCPDPN(ISCRV,VDW_FILE_0(1:LENSTR(VDW_FILE_0)),'UNKNOWN','U',
     &              LL,IFAIL)
 10   CONTINUE
C
c---If both atoms are in the list of rigid groups
      READ(ISCRV,END=999)IA1,IA2,RS_VIDL,RS_SDI,NS_DIST(1),NS_DIST(2),
     &                   NS_DIST(3),NS_DIST(4),IVDW_TYPE
      IA11 = ATOM_REF_FLAG(IA1)/10
      IA12 = ATOM_REF_FLAG(IA1) - 10*IA11
      IA21 = ATOM_REF_FLAG(IA2)/10
      IA22 = ATOM_REF_FLAG(IA2) - 10*IA21
      IF(IGROUP(IA1).GT.0.AND.IGROUP(IA2).GT.0.AND.OCCUP(IA1).GT.0.0
     &  .AND.OCCUP(IA2).GT.0.0.AND.IA12.GT.2.AND.IA22.GT.2)      THEN
        IGR1 = IGROUP(IA1)
        IGR2 = IGROUP(IA2)
        CALL DERIVS_WRT_EULER1(XYZ_CRD(1,IA1),TGRAV(1,IGR1),DRDR1)      
        CALL DERIVS_WRT_EULER1(XYZ_CRD(1,IA2),TGRAV(1,IGR2),DRDR2)
        CALL FAST_HESSIAN_NONDIAGONAL(IA1,IA2,NS_DIST,
     &    H_XX,H_UU,H_QQ,H_XB,H_XU,H_XQ,H_QX,H_BQ,H_QB,H_UQ,H_QU)

        DO   IRIG1=1,6
          IPAR0 = 6*(IGR1-1) + IRIG1
          CALL MAT2VEC(3,3,H_XX,DRDR1(1,IRIG1),HX2DR,ERROR)
          DO   IRIG2=1,6
            IPAR10 = 6*(IGR2-1) + IRIG2
            TMP    = DOT1_R(3,3,HX2DR,DRDR2(1,IRIG2))
            IF(IGR1.NE.IGR2) THEN
              HX_RIGID(IPAR0,IPAR10) = HX_RIGID(IPAR0,IPAR10) + TMP 
              HX_RIGID(IPAR10,IPAR0) = HX_RIGID(IPAR10,IPAR0) + TMP
            ELSE IF(IA1.NE.IA2) THEN
cd            ELSE
              HX_RIGID(IPAR10,IPAR0) = HX_RIGID(IPAR10,IPAR0) + TMP
              HX_RIGID(IPAR0,IPAR10) = HX_RIGID(IPAR0,IPAR10) + TMP

            ENDIF
          ENDDO
        ENDDO
      ENDIF
      GOTO 10
 999  CONTINUE
      CLOSE(ISCRV)
      RETURN
      END
C
      SUBROUTINE APPLY_SHIFTS_RIGID(SHFT_RIGID,DELTA_SHIFTS)
C
C---Applies translation and rotation (in euler angles) to get new 
C---coordinates.
      INCLUDE 'atom_com.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'rigid_body.fh'

      REAL SHFT_RIGID(*)
      INTEGER ND_REMAIN

      PARAMETER (ND_REMAIN = QQM+2*QQV - (4*MAXATOM+18*MAXDOMAIN))
      REAL      WORK_D
      COMMON /LSQMTX/ XORT0(3,MAXATOM),IGROUP(MAXATOM),
     +                ROT_RIGID(3,3,MAXDOMAIN),RIGID_TRANS(3,MAXDOMAIN),
     +                RIGID_ALPHA(3,MAXDOMAIN),TGRAV(3,MAXDOMAIN),
     &                WORK_D(ND_REMAIN)

      INTEGER IDOMAIN,I1,IA,IX
      REAL ROT_SHIFT(3,3),ROT_NEW(3,3),ROT_OLD(3,3),XYZ_1(3)
      REAL DELTA_SHIFTS
      REAL XYZ_OLD(3)
      LOGICAL ERROR
C
C---Convert Euler angles to rotation matrix
      DELTA_SHIFTS = 0.0
      DO   IDOMAIN=1,NDOMAIN
        ID1 = 6*(IDOMAIN-1)
        DO   I=1,3
          I1 = ID1 + I
          TGRAV(I,IDOMAIN) = TGRAV(I,IDOMAIN) + SHFT_RIGID(I1)
          RIGID_TRANS(I,IDOMAIN) = RIGID_TRANS(I,IDOMAIN) + 
     &                SHFT_RIGID(I1)
        ENDDO
        CALL EUL2MATR(SHFT_RIGID(ID1+4),SHFT_RIGID(ID1+5),
     &   SHFT_RIGID(ID1+6),ROT_SHIFT)
        DO   IA = 1,N_ATOM
          IF(IGROUP(IA).EQ.IDOMAIN) THEN
            N_REFINED_RIGID = N_REFINED_RIGID + 1
            DO   IX = 1,3
             XYZ_OLD(IX) = XYZ_CRD(IX,IA)
             I1 = ID1 + IX
             XYZ_CRD(IX,IA) = XYZ_CRD(IX,IA) + SHFT_RIGID(I1)
             XYZ_1(IX) = XYZ_CRD(IX,IA) - TGRAV(IX,IDOMAIN)
            ENDDO
            CALL MAT2VEC(3,3,ROT_SHIFT,XYZ_1,XYZ_CRD(1,IA),ERROR)
            DO   IX = 1,3
              XYZ_CRD(IX,IA) = XYZ_CRD(IX,IA) + TGRAV(IX,IDOMAIN)
              DELTA_SHIFTS = AMAX1(DELTA_SHIFTS,
     &                  ABS(XYZ_CRD(IX,IA)-XYZ_OLD(IX)))
            ENDDO
          ENDIF
        ENDDO
C
c---Now accumulate angular part
        CALL EUL2MATR(RIGID_ALPHA(1,IDOMAIN),RIGID_ALPHA(2,IDOMAIN),
     &         RIGID_ALPHA(3,IDOMAIN),ROT_OLD)
        CALL MAT2MAT(3,3,ROT_SHIFT,ROT_OLD,ROT_NEW,ERROR)
        CALL MATR2EUL_UNSAFE(ROT_NEW,RIGID_ALPHA(1,IDOMAIN),
     &      RIGID_ALPHA(2,IDOMAIN),RIGID_ALPHA(3,IDOMAIN))
       
      ENDDO
      RETURN
      END
C
C---Subroutines independent on include files

      SUBROUTINE  EUL2MATR(ALPHA1,ALPHA2,ALPHA3,ROT_TEMP)
C
C---Converts euler angles to rotation matrix
      REAL ROT_TEMP(3,3),ALPHA1,ALPHA2,ALPHA3
C
C---Local variables
      REAL SIN1,COS1,SIN2,COS2,SIN3,COS3

      SIN1 = SIN(ALPHA1)
      SIN2 = SIN(ALPHA2)
      SIN3 = SIN(ALPHA3)

      COS1 = COS(ALPHA1)
      COS2 = COS(ALPHA2)
      COS3 = COS(ALPHA3)
      ROT_TEMP(1,1) =  COS1*COS2*COS3 - SIN1*SIN3 
      ROT_TEMP(1,2) = -COS1*COS2*SIN3 - SIN1*COS3 
      ROT_TEMP(1,3) =  COS1*SIN2
      ROT_TEMP(2,1) =  SIN1*COS2*COS3 + COS1*SIN3  
      ROT_TEMP(2,2) = -SIN1*COS2*SIN3 + COS1*COS3 
      ROT_TEMP(2,3) =  SIN1*SIN2 
      ROT_TEMP(3,1) = -SIN2*COS3 
      ROT_TEMP(3,2) =  SIN2*SIN3 
      ROT_TEMP(3,3) =  COS2

      RETURN
      END
C
      SUBROUTINE DERIVS_WRT_EULER1(XYZ_CUR,XYZ_CENT,DXDDOMAIN)
      IMPLICIT NONE
C
C--Derivatives of the current atom wrt rigid body parameters.
C---Initial angles are assumed to be 0
C
      REAL XYZ_CUR(3),XYZ_CENT(3),DXDDOMAIN(3,6)
C
c----local variables
      REAL XYZ(3)
C
C---Derivatives wrt translational parameters      

      DXDDOMAIN(1,1) = 1.0
      DXDDOMAIN(2,1) = 0.0
      DXDDOMAIN(3,1) = 0.0
      DXDDOMAIN(1,2) = 0.0
      DXDDOMAIN(2,2) = 1.0
      DXDDOMAIN(3,2) = 0.0
      DXDDOMAIN(1,3) = 0.0
      DXDDOMAIN(2,3) = 0.0
      DXDDOMAIN(3,3) = 1.0
C
C---Derivatives of atomic positional parameters wrt rotational angles
      XYZ(1) = XYZ_CUR(1)-XYZ_CENT(1)
      XYZ(2) = XYZ_CUR(2)-XYZ_CENT(2)
      XYZ(3) = XYZ_CUR(3)-XYZ_CENT(3)

      DXDDOMAIN(1,4) = -XYZ(2)
      DXDDOMAIN(2,4) =  XYZ(1)
      DXDDOMAIN(3,4) =  0.0

      DXDDOMAIN(1,5) =  XYZ(3)
      DXDDOMAIN(2,5) =  0.0
      DXDDOMAIN(3,5) = -XYZ(1)

      DXDDOMAIN(1,6) = -XYZ(2)
      DXDDOMAIN(2,6) =  XYZ(1)
      DXDDOMAIN(3,6) =  0.0

      RETURN
      END
C
      SUBROUTINE DEFINE_DOMAINS
      implicit none
C
C--Defines groups according to read parameters
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'rigid_body.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'refi_flags.fh'
c
      INTEGER ND_REMAIN
      PARAMETER (ND_REMAIN = QQM+2*QQV - (4*MAXATOM+18*MAXDOMAIN))
      REAL      XORT0,ROT_RIGID,RIGID_TRANS,RIGID_ALPHA,TGRAV,WORK_D
      integer igroup
      COMMON /LSQMTX/ XORT0(3,MAXATOM),IGROUP(MAXATOM),
     +                ROT_RIGID(3,3,MAXDOMAIN),RIGID_TRANS(3,MAXDOMAIN),
     +                RIGID_ALPHA(3,MAXDOMAIN),TGRAV(3,MAXDOMAIN),
     &                WORK_D(ND_REMAIN)

C     
C---Local variables
      integer idom,ipiece,ia,ia1,ip1,jrs
      CHARACTER CHNNMP*4
c
c---body
      IF(NDOMAIN.GT.0) THEN
        DO   IA = 1,N_ATOM
          IGROUP(IA) = 0
          DO     IDOM=1,NDOMAIN
            IF(IDOMAIN_PIECES(IDOM).GT.0) THEN
              IPIECE = IDOMAIN_PIECES(IDOM)
              DO IP1 = 1,IPIECE
C
C---Add checking
                 call get_chain_namepdb(chnnmp,i_resid(ia))
c                IF(REFID.EQ.'UNRE') THEN
c                  CHNNMP = RES_NUM_PDB(I_RESID(IA))(1:1)
c                ELSE
c                  CHNNMP = ASM_GROUP_ID(I_CHAIN(I_RESID(IA)))(1:1)
c                ENDIF
                READ(RES_NUM_PDB(I_RESID(IA))(3:6),*)JRS
                IF(CHNNMP.EQ.IDOMAIN_CHN(IP1,IDOM).AND.
     +                  JRS.GE.IDOMAIN_FROM(IP1,IDOM).AND.
     +                  JRS.LE.IDOMAIN_TO(IP1,IDOM)) THEN
                    IGROUP(IA) = IDOM
                    GOTO 10
                ENDIF
              ENDDO
            ENDIF
          ENDDO
 10       CONTINUE
        ENDDO
      ELSE
        DO   IA=1,N_ATOM
          IGROUP(IA) = 1
          NDOMAIN    = 1
        ENDDO
      ENDIF
C
C---Main chain or side chain atoms may not be included in refinement
C---but they will be rotated
      IA1 = 0
      DO    IA=1,N_ATOM
        ATOM_REF_FLAG(IA) = 1
        IDOM = IGROUP(IA)
        IF(OCCUP(IA).EQ.0.0) THEN
          ATOM_REF_FLAG(IA) = 0
        ELSEIF(IDOM.GT.0) THEN
          IF(EXCLUDE_DOMAIN(IDOM).EQ.'SCHA') THEN
            IF(ATM_NAME(IA).NE.'CA  '.AND.ATM_NAME(IA).NE.'N   '
     +        .AND.ATM_NAME(IA).NE.'C   '.AND.ATM_NAME(IA).NE.'O   ')
     +             ATOM_REF_FLAG(IA) = 0
          ELSEIF(EXCLUDE_DOMAIN(IDOM).EQ.'MCHA') THEN
            IF(ATM_NAME(IA).EQ.'CA'.OR.ATM_NAME(IA).EQ.'N   '
     +        .OR.ATM_NAME(IA).EQ.'C   '.OR.ATM_NAME(IA).EQ.'O   ')
     +              ATOM_REF_FLAG(IA) = 0
          ENDIF
        ENDIF
        IF(ATOM_REF_FLAG(IA).NE.0) THEN
          IA1 = IA1 + 1
          IF(CS_ELEMENT(ID_SF(IA)).EQ.'H   '.OR.
     &                         CS_ELEMENT(ID_SF(IA)).EQ.'H-1 ') THEN
            ATOM_REF_FLAG(IA) = IA1*10 + 2
          ELSE
            ATOM_REF_FLAG(IA) = IA1*10 + 4
          ENDIF
        ENDIF
      ENDDO       
      RETURN
      END
       
      SUBROUTINE   FINDCGRAV
C
C---Finds center of gravity of atoms and makes this point as center 
C---of given atoms
      INCLUDE 'atom_com.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'rigid_body.fh'

      INTEGER ND_REMAIN
      PARAMETER (ND_REMAIN = QQM+2*QQV - (4*MAXATOM+18*MAXDOMAIN))
      REAL      WORK_D
      COMMON /LSQMTX/ XORT0(3,MAXATOM),IGROUP(MAXATOM),
     +                ROT_RIGID(3,3,MAXDOMAIN),RIGID_TRANS(3,MAXDOMAIN),
     +                RIGID_ALPHA(3,MAXDOMAIN),TGRAV(3,MAXDOMAIN),
     &                WORK_D(ND_REMAIN)

      REAL QATOM(MAXDOMAIN)
c
      DO    IDOMAIN = 1,NDOMAIN
          DO   IX=1,3
             TGRAV(IX,IDOMAIN) = 0.0
          ENDDO
          QATOM(IDOMAIN) = 0.0
      ENDDO

      DO    IA=1,N_ATOM
        IF(ATOM_REF_FLAG(IA).GT.0) THEN
          IDOMAIN  = IGROUP(IA)
          IF(IDOMAIN.GT.0) THEN
            DO    IX=1,3
              TGRAV(IX,IDOMAIN) = TGRAV(IX,IDOMAIN)+
     +            XYZ_CRD(IX,IA)*OCCUP(IA)
            ENDDO
            QATOM(IDOMAIN) = QATOM(IDOMAIN) + OCCUP(IA)
          ENDIF
        ENDIF
      ENDDO

      DO    IDOMAIN = 1,NDOMAIN
        DO   IX=1,3
          IF(QATOM(IDOMAIN).GT.0.0) THEN
            TGRAV(IX,IDOMAIN) = TGRAV(IX,IDOMAIN)/QATOM(IDOMAIN)
          ENDIF
        ENDDO
      ENDDO
      RETURN
      END

      SUBROUTINE PRINT_RIGIDPARS
C
C---Prints parameters of rigid body like euler angles translation
C---matrices
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'const.fh'
      INCLUDE 'rigid_body.fh'

      INTEGER ND_REMAIN
      PARAMETER (ND_REMAIN = QQM+2*QQV - (4*MAXATOM+18*MAXDOMAIN))
      REAL      WORK_D
      COMMON /LSQMTX/ XORT0(3,MAXATOM),IGROUP(MAXATOM),
     +                ROT_RIGID(3,3,MAXDOMAIN),RIGID_TRANS(3,MAXDOMAIN),
     +                RIGID_ALPHA(3,MAXDOMAIN),TGRAV(3,MAXDOMAIN),
     &                WORK_D(ND_REMAIN)

      REAL TRANS(3),ALPHA0(3),ROT_TEMP(3,3)
      CHARACTER LINE*120
C
C---
      CALL ERRWRT(-1,
     +     '----------------------------------------------------------') 
      CALL ERRWRT(-1,
     +     '  Rigid body parameters will be applied to coordinates')
      CALL ERRWRT(-1,'  as following')
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,' Xnew = Rot*Xold - Rot*Tg + Tg +deltaTg')
      CALL ERRWRT(-1,'Where')
      CALL ERRWRT(-1,
     +   ' Xnew and Xold are new and old coordinates of atoms in')
      CALL ERRWRT(-1,'              this domain')
      CALL ERRWRT(-1,
     +' Rot           is rotation matrix derived from Euler angles')
      CALL ERRWRT(-1,' Tg            is centre of mass of this domain')
      CALL ERRWRT(-1,' deltaTg       is shift of centre of mass')
      CALL ERRWRT(-1,
     +     '----------------------------------------------------------') 
      DO    IDOM=1,NDOMAIN
        WRITE(LINE,'(A,I5)')'Domain ',IDOM
        CALL ERRWRT(-1,LINE)
        CALL EUL2MATR(RIGID_ALPHA(1,IDOM),RIGID_ALPHA(2,IDOM),
     &           RIGID_ALPHA(3,IDOM),ROT_RIGID(1,1,IDOM))
        DO    IX=1,3
          ALPHA0(IX) = RIGID_ALPHA(IX,IDOM)
          TRANS(IX)  = RIGID_TRANS(IX,IDOM)
        ENDDO
C
C--Print Euler angles and translations

        WRITE(LINE,'(A,3F10.3)')'Centre of mass: ',
     +    TGRAV(1,IDOM),TGRAV(2,IDOM),TGRAV(3,IDOM)
        CALL ERRWRT(-1,LINE)
        IF(EULER_PRINT_RIGID) THEN
           ALPHA1 = ALPHA0(1)*RTODEG
           ALPHA2 = ALPHA0(2)*RTODEG
           ALPHA3 = ALPHA0(3)*RTODEG
           WRITE(LINE,'(A,3x,6F9.2)')' Euler angles and deltaTg: ',
     +           ALPHA1,ALPHA2,ALPHA3, TRANS(1),TRANS(2),TRANS(3)
           CALL ERRWRT(-1,LINE)
           CALL ERRWRT(-1,' ')
        ENDIF
        IF(MATRIX_PRINT_RIGID) THEN
C
C--Print rotation matrix and translations
          LINE = ' '
          CALL ERRWRT(-1,' Matrix and deltaTg')
          WRITE(LINE,'(3X,3F10.3)')
     +       ROT_RIGID(1,1,IDOM),ROT_RIGID(1,2,IDOM),ROT_RIGID(1,3,IDOM)
          CALL ERRWRT(-1,LINE) 
          WRITE(LINE,'(3X,3F10.3)')
     +       ROT_RIGID(2,1,IDOM),ROT_RIGID(2,2,IDOM),ROT_RIGID(2,3,IDOM)
          CALL ERRWRT(-1,LINE) 
          WRITE(LINE,'(3X,3F10.3)')
     +       ROT_RIGID(3,1,IDOM),ROT_RIGID(3,2,IDOM),ROT_RIGID(3,3,IDOM)
          CALL ERRWRT(-1,LINE) 
          WRITE(LINE,'(3X,3F10.3)')
     +              TRANS(1),TRANS(2),TRANS(3)
          CALL ERRWRT(-1,LINE) 
          CALL ERRWRT(-1,' ') 
        ENDIF
        IF(POLAR_PRINT_RIGID) THEN
          DO   IX=1,3
            DO   IY=1,3
              ROT_TEMP(IX,IY) = ROT_RIGID(IX,IY,IDOM)
            ENDDO
          ENDDO
          CALL POLAR(ROT_TEMP,PSI,PHI,CHI)               
          WRITE(LINE,'(3X,A,6F9.2)')
     +   'Polar angles: PHI, PSI(or Omega), CHI(or Kappa), deltaTg: ',
     +            PHI,PSI,CHI, TRANS(1),TRANS(2),TRANS(3)
          CALL ERRWRT(-1,LINE) 
          CALL ERRWRT(-1,' ') 
        ENDIF
      ENDDO
      RETURN
      END

      SUBROUTINE AMOD1(A,B)
C
      B1 = ABS(B)/2.0
      B2 = ABS(B)
10    CONTINUE 
      IF(A.GT.B1) THEN
        A = A-B2
        GOTO 10
      ENDIF
20    CONTINUE
      IF(A.LT.-B1) THEN
        A = A + B2
        GOTO 20
      ENDIF
      RETURN
      END
