C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
      SUBROUTINE AMOD_R(A,B,IAMOD,AREMAIN)
      IMPLICIT NONE
C
C---This subroutine calculates mod(a,|b|) and int(a/|b|)
C
C----|B| = 0 must be satisfied
C
C---Real scalar parameters
      REAL A,B,AREMAIN,B1
C
C---Intrinsic functions
      INTEGER INT
      INTRINSIC INT
      REAL ABS
      INTRINSIC ABS
      REAL FLOAT
      INTRINSIC FLOAT
C
C---Integer scalar parameters
      INTEGER IAMOD
C
      IF(B.EQ.1.0) THEN
        IAMOD = INT(ABS(A))
        IF(A.LT.0.0) IAMOD = -IAMOD - 1
        AREMAIN = A - FLOAT(IAMOD)
        RETURN
      ENDIF
C
      B1 = ABS(B)
      IF(B1.GT.0.0) THEN
        IAMOD = INT(ABS(A)/B1)
        IF(A.LT.0.0) IAMOD = -IAMOD-1
        AREMAIN = A - FLOAT(IAMOD)*B1
      ELSE
        IAMOD = 0
        AREMAIN = -A
      ENDIF
      RETURN
      END
C
      SUBROUTINE GET_ORT2FRAC_COEFS(CELL,FRAC_XYZ)
      IMPLICIT NONE
      REAL CELL(6),FRAC_XYZ(3)
C
c---Real local arrays
      REAL ALPHA,BETA,GAMMA,COSA,SINA,COSB,SINB,COSG,SING,
     +     VOLUME
C
C---Cell dimensions are assumed to be in radians
      ALPHA = CELL(4)
      BETA  = CELL(5)
      GAMMA = CELL(6)

      COSA = COS(ALPHA)
      SINA = SIN(ALPHA)
      COSB = COS(BETA)
      SINB = SIN(BETA)
      COSG = COS(GAMMA)
      SING = SIN(GAMMA)
      VOLUME = SQRT(1.-COSA*COSA-COSB*COSB-COSG*COSG+2*COSA*COSB*COSG)
C
C----Output brick size
      FRAC_XYZ(1) = SINA/VOLUME
      FRAC_XYZ(2) = SINB/VOLUME
      FRAC_XYZ(3) = SING/VOLUME
C
      RETURN
      END
C
      SUBROUTINE BRICK_LIMITS(D_BRICK,CELL,D_BRICK_OUT)
      IMPLICIT NONE
C
C---Finds brick limits for a given space group, if cell 
C---dimensions have been specified. 

C
C---Real arrays
      REAL CELL(6),D_BRICK(3),D_BRICK_OUT(6)
C
c---Real local arrays
      REAL ALPHA,BETA,GAMMA,COSA,SINA,COSB,SINB,COSG,SING,
     +     VOLUME
C
C---Intrinsic functions
      REAL SQRT,SIN,COS
      INTRINSIC SQRT,SIN,COS
C
C---Data Block
C
C---Cell dimensions are assumed to be in radians
      ALPHA = CELL(4)
      BETA  = CELL(5)
      GAMMA = CELL(6)

      COSA = COS(ALPHA)
      SINA = SIN(ALPHA)
      COSB = COS(BETA)
      SINB = SIN(BETA)
      COSG = COS(GAMMA)
      SING = SIN(GAMMA)
      VOLUME = SQRT(1.-COSA*COSA-COSB*COSB-COSG*COSG+2*COSA*COSB*COSG)
C
C----Output brick size
      D_BRICK_OUT(1) = D_BRICK(1)*SINA/VOLUME
      D_BRICK_OUT(2) = D_BRICK(2)*SINB/VOLUME
      D_BRICK_OUT(3) = D_BRICK(3)*SING/VOLUME
C
      RETURN
      END
C
      SUBROUTINE FIND_CONTACT_LIST(MAXVDW,NVDW,NVDW_TARGET,NVDW_OBJECT,
     +           NVDW_SYM,WORKSPACE,MAX_WORKSPACE,N_USED_MEM)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'weights.fh'
C
C---This routine finds list of potential contacts. It uses all 
C---symmetry. Workspace is used for intermediate arrays.
C---This routine uses bricking of extended asymmetric unit similar
C---to hash table technique
C
C---Real parameters

      REAL WORKSPACE(*)
C
C---Integer parameters
      INTEGER NVDW_TARGET(*),NVDW_OBJECT(*),NVDW_SYM(4,*)
      INTEGER MAXVDW,NVDW,N_USED_MEM
C
C---Real arrays
      REAL DVDW_CUT
      REAL D_BRICK(3),D_BRICK_OUT(3),CELL_ASYM(3)
C
C---Integer variables
      INTEGER IPXYZ(3),N_BRICKS(3),NMFOUR,I_BRICK,I
C
C---Addresses
      INTEGER XYZS_SIZE,XYZS_ADDRESS,SYMM_ADDRESS,
     +        FIRST_ATOM_ADDRESS,
     +        N_SYMM_ATOMS_ADDRESS,
     +        ATOMS_IN_BRICKS,
     +        ATOMS_IN_THIS_BRICK,
     +        REFER_TO_ATOM_ADDRESS
      INTEGER IA,N_MAX_BRICK,MAX_WORKSPACE
      INTEGER LENSTR
      EXTERNAL LENSTR
      CHARACTER LINE*256
C    
C---Define brick sizes
      DVDW_CUT = -1.0
      DO    IA = 1,N_ATOM
        DVDW_CUT = AMAX1(DVDW_CUT,VDW_RAD(IA))
      ENDDO
      DVDW_CUT = AMAX1(DVDW_CUT,DVDW_CUT_MIN)
      DVDW_CUT = 2.0*DVDW_CUT
      DO   I_BRICK = 1,3
        D_BRICK(I_BRICK) = DVDW_CUT
      ENDDO
C
C---Adjust brick sizes according to cell angless
      CALL BRICK_LIMITS(D_BRICK,CS_CELL,D_BRICK_OUT)
C
C---Find asymmetric unit limits (that is minimum rectangle inside which 
C---asymmetric unit is situated)
C
C----Asymmetric unit is inside rectangle 0 < X < CELL_ASYM where 0, X and 
C----CELL_ASYM are 3 dimensional vectors
      CALL ASYLIM(CS_NSPGR,IPXYZ(1),IPXYZ(2),IPXYZ(3),NMFOUR)
      DO    I=1,3
        CELL_ASYM(I) = CS_CELL(I)/FLOAT(IPXYZ(I))
      ENDDO      
C
C---Find number of bricks
      DO   I=1,3
        N_BRICKS(I) = INT(CELL_ASYM(I)/D_BRICK_OUT(I)) + 5
      ENDDO
C
C----Assign memory for intermadiate arrays
      CALL GET_XYZS_NUMBER(D_BRICK_OUT,XYZS_SIZE)
      XYZS_SIZE = XYZS_SIZE + 1
      XYZS_ADDRESS = 1
      REFER_TO_ATOM_ADDRESS =  XYZS_ADDRESS         + 3*XYZS_SIZE
      SYMM_ADDRESS          = REFER_TO_ATOM_ADDRESS + XYZS_SIZE
      FIRST_ATOM_ADDRESS    = SYMM_ADDRESS          + 4*XYZS_SIZE
      N_SYMM_ATOMS_ADDRESS  = FIRST_ATOM_ADDRESS    + N_ATOM
      ATOMS_IN_BRICKS       = N_SYMM_ATOMS_ADDRESS  + N_ATOM
      ATOMS_IN_THIS_BRICK   = ATOMS_IN_BRICKS +
     &                       80*N_BRICKS(1)*N_BRICKS(2)*N_BRICKS(3)
      N_MAX_BRICK = 80
      IF(ATOMS_IN_THIS_BRICK + 
     &    N_BRICKS(1)*N_BRICKS(2)*N_BRICKS(3).GT.MAX_WORKSPACE) THEN
        CALL ERRWRT(-1,'Memory is not enough for vdw contacts')
        WRITE(LINE,'(A,I10,A,I10)')'Maximum allowed = ',
     &                QQDEN,' Current required = ',
     &                        N_USED_MEM + ATOMS_IN_THIS_BRICK + 
     &                           N_BRICKS(1)*N_BRICKS(2)*N_BRICKS(3)
        CALL ERRWRT(-1,LINE)
        CALL ERRWRT(1,'Problem with scratch size QQDEN in pls_incl.fh')
      ENDIF
      CALL FIND_CONTACTS_WITH_BRICKING(MAXVDW,NVDW,NVDW_TARGET,
     +             NVDW_OBJECT, NVDW_SYM,D_BRICK_OUT,
     +             XYZS_SIZE,WORKSPACE(XYZS_ADDRESS),
     +             WORKSPACE(SYMM_ADDRESS),
     +             WORKSPACE(FIRST_ATOM_ADDRESS),
     +             WORKSPACE(N_SYMM_ATOMS_ADDRESS),
     +             WORKSPACE( REFER_TO_ATOM_ADDRESS),
     +             N_BRICKS(1),N_BRICKS(2),N_BRICKS(3),
     +             N_MAX_BRICK,WORKSPACE(ATOMS_IN_BRICKS),
     +             WORKSPACE(ATOMS_IN_THIS_BRICK))
      RETURN
      END
C
      SUBROUTINE GET_XYZS_NUMBER(D_BRICKS,XYZ_SIZE)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'weights.fh'
      REAL D_BRICKS(3)
      INTEGER XYZ_SIZE
C
      INTEGER IPXYZ(3)
      INTEGER NMFOUR,I,IA,IMODX,IMODY,IMODZ,IX,IY,IZ,IS,NXYZS
      REAL CELL_ASYM_MIN(3),CELL_ASYM_MAX(3),EXT_ASYM_MAX(3),
     &     XYZ_FRAC1(3),XYZS_FRAC(3),XYZS_CELL(3),EXT_ASYM_MIN(3),
     &     CELL_ASYM_MIN_FRAC(3),CELL_ASYM_MAX_FRAC(3),FRAC_XYZ(3),
     &     D_VDW2_FRAC(3)
      REAL ONE,XYZS_TRANSX,XYZS_TRANSY,XYZS_TRANSZ,D_VDW2,DVDW_MAX
      REAL DVDW_MAX2
      REAL SMALL_EPS
      LOGICAL ERROR
      DATA ONE/1.0/,SMALL_EPS/1.0E-6/
C
      NXYZS = 0
      CALL ASYLIM(CS_NSPGR,IPXYZ(1),IPXYZ(2),IPXYZ(3),NMFOUR)
      CELL_ASYM_MIN(1) = 0.0
      CELL_ASYM_MIN(2) = 0.0
      CELL_ASYM_MIN(3) = 0.0
      CELL_ASYM_MAX(1) = CS_CELL(1)*(1.0+SMALL_EPS)/FLOAT(IPXYZ(1))
      CELL_ASYM_MAX(2) = CS_CELL(2)*(1.0+SMALL_EPS)/FLOAT(IPXYZ(2))
      CELL_ASYM_MAX(3) = CS_CELL(3)*(1.0+SMALL_EPS)/FLOAT(IPXYZ(3))
      DO   I=1,3
        CELL_ASYM_MIN_FRAC(I) = CELL_ASYM_MIN(I)/CS_CELL(I)
        CELL_ASYM_MAX_FRAC(I) = CELL_ASYM_MAX(I)/CS_CELL(I)
      ENDDO
      DO    IA = 1,N_ATOM
        DVDW_MAX = AMAX1(DVDW_MAX,VDW_RAD(IA))
      ENDDO
      DVDW_MAX2 = 2.0*AMAX1(DVDW_MAX,DVDW_CUT_MIN)
      CALL GET_ORT2FRAC_COEFS(CS_CELL,FRAC_XYZ)
      DO    IA=1,N_ATOM
         IF(ATOM_REF_FLAG(IA).GT.0) THEN
           D_VDW2 = DVDW_MAX2
           D_VDW2_FRAC(1) = D_VDW2*FRAC_XYZ(1)/CS_CELL(1)
           D_VDW2_FRAC(2) = D_VDW2*FRAC_XYZ(2)/CS_CELL(2)
           D_VDW2_FRAC(3) = D_VDW2*FRAC_XYZ(3)/CS_CELL(3)
           DO    I=1,3
             EXT_ASYM_MAX(I) = CELL_ASYM_MAX_FRAC(I) + D_VDW2_FRAC(I)
             EXT_ASYM_MIN(I) = CELL_ASYM_MIN_FRAC(I) - D_VDW2_FRAC(I)
           ENDDO
         CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ_FRAC1,ERROR)
C
C---Now find all symmetry related atoms which are inside extended asymmetric 
C----unit
         DO    IS=1,NumSymmetry
           DO    I =1,3
             XYZS_FRAC(I) = RealSymmMatrx(I,1,IS)*XYZ_FRAC1(1) +
     +                      RealSymmMatrx(I,2,IS)*XYZ_FRAC1(2) +
     +                      RealSymmMatrx(I,3,IS)*XYZ_FRAC1(3) +
     +                      RealSymmMatrx(I,4,IS)
           ENDDO
C
C---Find translation by which this atom comes to asymmetic unit
           
           CALL AMOD_R(XYZS_FRAC(1),ONE,IMODX,XYZS_CELL(1))
           CALL AMOD_R(XYZS_FRAC(2),ONE,IMODY,XYZS_CELL(2))
           CALL AMOD_R(XYZS_FRAC(3),ONE,IMODZ,XYZS_CELL(3))
           DO    IZ = -1,1
             XYZS_TRANSZ = XYZS_CELL(3) + FLOAT(IZ)
             IF(XYZS_TRANSZ.LE.EXT_ASYM_MAX(3).AND.
     +          XYZS_TRANSZ.GE.EXT_ASYM_MIN(3)) THEN
               DO   IY = -1,1
                 XYZS_TRANSY = XYZS_CELL(2) + FLOAT(IY)
                 IF(XYZS_TRANSY.LE.EXT_ASYM_MAX(2).AND.
     +              XYZS_TRANSY.GE.EXT_ASYM_MIN(2)) THEN
                   DO    IX=-1,1
                     XYZS_TRANSX = XYZS_CELL(1) + FLOAT(IX)
                     IF(XYZS_TRANSX.LE.EXT_ASYM_MAX(1).AND.
     +                  XYZS_TRANSX.GE.EXT_ASYM_MIN(1)) THEN
                       NXYZS           = NXYZS + 1
                     ENDIF
                   ENDDO
                 ENDIF
               ENDDO
             ENDIF
           ENDDO
         ENDDO
         ENDIF
      ENDDO
      XYZ_SIZE = NXYZS
      RETURN
      END

      SUBROUTINE FIND_CONTACTS_WITH_BRICKING(MAX_VDW,NVDW,
     &             NVDW_TARGET,
     +             NVDW_OBJECT,NVDW_SYMM,D_BRICKS,XYZS_SIZE,XYZS,
     +             SYMM_REFER,FIRST_ATOM,N_SYM_ATOMS,REFER_TO_ATOM,
     +             N_BRICK1,N_BRICK2,N_BRICK3,N_MAX_BRICK,
     +             ATOMS_IN_BRICK,ATOMS_IN_THIS_BRICK)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'weights.fh'
C
C----This routine finds contact list using bricking technique which is similar
C----to hash table technique. First atoms extended so that to cover extended
C----asymmetric unit. Extension of asymmeric unit is equal to brick size.
C----After that list of atoms and pointers to atoms for each brick is assigned
C----Having this for each atom which is unique (in a sence that it is first
C----symmetry related atom which is entirely in asymmeteric unit) 27 neibouring
C----bricks are searched for possible contacts. Having find contact symmetries
C----are assigned symply by look up to the tabel R1^-1 * R2 (beacues symmetry
C----is group result of this operation should be member of the group)
C

C----Array arguments. Reals first
C
      REAL DVDW_CUT
      REAL D_BRICKS(3),XYZS(3,*)
      REAL XYZ_FRAC(3),XYZ_FRAC1(3)
C
C---Integer scalars
      INTEGER N_MAX_BRICK,XYZS_SIZE,MAX_VDW,N_BRICK1,N_BRICK2,N_BRICK3
C
C----Integer arrays
      INTEGER NVDW_TARGET(*),NVDW_OBJECT(*),NVDW_SYMM(4,*),
     +        SYMM_REFER(4,*),FIRST_ATOM(*),N_SYM_ATOMS(*),
     +        ATOMS_IN_BRICK(N_MAX_BRICK,N_BRICK1,N_BRICK2,N_BRICK3),
     +        ATOMS_IN_THIS_BRICK(N_BRICK1,N_BRICK2,N_BRICK3),
     +        REFER_TO_ATOM(*),NVDW
      INTEGER IPXYZ(3),ITX1(3),ITX_CUR(3)
      REAL    D1_IA,D2_IA,D1_CUT2
      REAL    CELL_ASYM_MIN(3),CELL_ASYM_MAX(3),EXT_ASYM_MIN(3),
     +        EXT_ASYM_MAX(3),XYZS_FRAC(3),XYZS_CELL(3),
     +        CELL_ASYM_MIN_FRAC(3),CELL_ASYM_MAX_FRAC(3),
     +        D_BRICKS_FRAC(3),D_VDW2_FRAC(3),FRAC_XYZ(3)
      CHARACTER CMAXCONT*6,AT_FULL*24
      CHARACTER AT_FULL1*24,AT_FULL2*24
C
      INTEGER MAX_CONTACT,FIRST,NMFOUR,I,IA,IA_REFER,NXYZS,IS,
     &        IMODX,IMODY,IMODZ,IX,IY,IZ,I_ADDRESS,N_FIRST_ATOM,
     &        IT,N_CONTACT,IX_THIS,IY_THIS,IZ_THIS,
     &        IA_BOX,ISYM1,ISYM2,ISYM_CUR,I_MULT,IERROR
      REAL ONE,XYZS_TRANSX,XYZS_TRANSY,XYZS_TRANSZ,T,DX,DXY,DSQ,
     &     DVDW_MAX,D_VDW2
      REAL DVDW_MAX2

      INTEGER LENSTR
      EXTERNAL LENSTR
      LOGICAL ERROR
      REAL SMALL_EPS
      DATA ONE/1.0/,MAX_CONTACT/190/,SMALL_EPS/1.0E-6/
C---First extend atom list to cover extended asymmetric unit
      WRITE(CMAXCONT,'(I4)')MAX_CONTACT
C
c---Convert all atoms to fractional coordinates
      NXYZS = 0
      CALL ASYLIM(CS_NSPGR,IPXYZ(1),IPXYZ(2),IPXYZ(3),NMFOUR)
      CELL_ASYM_MIN(1) = 0.0
      CELL_ASYM_MIN(2) = 0.0
      CELL_ASYM_MIN(3) = 0.0
      CELL_ASYM_MAX(1) = CS_CELL(1)*(1.0+SMALL_EPS)/FLOAT(IPXYZ(1))
      CELL_ASYM_MAX(2) = CS_CELL(2)*(1.0+SMALL_EPS)/FLOAT(IPXYZ(2))
      CELL_ASYM_MAX(3) = CS_CELL(3)*(1.0+SMALL_EPS)/FLOAT(IPXYZ(3))
      DO   I=1,3
        CELL_ASYM_MIN_FRAC(I) = CELL_ASYM_MIN(I)/CS_CELL(I)
        CELL_ASYM_MAX_FRAC(I) = CELL_ASYM_MAX(I)/CS_CELL(I)
      ENDDO
      DVDW_MAX = 0.0
      DO    IA = 1,N_ATOM
        DVDW_MAX = AMAX1(DVDW_MAX,VDW_RAD(IA))
      ENDDO
      DVDW_MAX = AMAX1(DVDW_MAX,DVDW_CUT_MIN)
      DVDW_MAX2 = 2.0*DVDW_MAX
      CALL GET_ORT2FRAC_COEFS(CS_CELL,FRAC_XYZ)
      D_VDW2         = DVDW_MAX2
      D_VDW2_FRAC(1) = D_VDW2*FRAC_XYZ(1)/CS_CELL(1)
      D_VDW2_FRAC(2) = D_VDW2*FRAC_XYZ(2)/CS_CELL(2)
      D_VDW2_FRAC(3) = D_VDW2*FRAC_XYZ(3)/CS_CELL(3)
      DO    I=1,3
        EXT_ASYM_MAX(I) = CELL_ASYM_MAX_FRAC(I) + D_VDW2_FRAC(I)
        EXT_ASYM_MIN(I) = CELL_ASYM_MIN_FRAC(I) - D_VDW2_FRAC(I)
      ENDDO
      DO    IA=1,N_ATOM
         IF(ATOM_REF_FLAG(IA).GT.0) THEN
         N_SYM_ATOMS(IA) = 0
         CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ_FRAC1,ERROR)
C
C---Now find all symmetry related atoms which are inside extended asymmetric 
C----unit
         DO    IS=1,NumSymmetry
           DO    I =1,3
             XYZS_FRAC(I) = RealSymmMatrx(I,1,IS)*XYZ_FRAC1(1) +
     +                      RealSymmMatrx(I,2,IS)*XYZ_FRAC1(2) +
     +                      RealSymmMatrx(I,3,IS)*XYZ_FRAC1(3) +
     +                      RealSymmMatrx(I,4,IS)
           ENDDO
C
C---Find translation by which this atom comes to asymmetic unit
           
           CALL AMOD_R(XYZS_FRAC(1),ONE,IMODX,XYZS_CELL(1))
           CALL AMOD_R(XYZS_FRAC(2),ONE,IMODY,XYZS_CELL(2))
           CALL AMOD_R(XYZS_FRAC(3),ONE,IMODZ,XYZS_CELL(3))
           DO    IZ = -1,1
             XYZS_TRANSZ = XYZS_CELL(3) + FLOAT(IZ)
             IF(XYZS_TRANSZ.LE.EXT_ASYM_MAX(3).AND.
     +          XYZS_TRANSZ.GE.EXT_ASYM_MIN(3)) THEN
               DO   IY = -1,1
                 XYZS_TRANSY = XYZS_CELL(2) + FLOAT(IY)
                 IF(XYZS_TRANSY.LE.EXT_ASYM_MAX(2).AND.
     +              XYZS_TRANSY.GE.EXT_ASYM_MIN(2)) THEN
                   DO    IX=-1,1
                     XYZS_TRANSX = XYZS_CELL(1) + FLOAT(IX)
                     IF(XYZS_TRANSX.LE.EXT_ASYM_MAX(1).AND.
     +                  XYZS_TRANSX.GE.EXT_ASYM_MIN(1)) THEN

C
C----Add this position to list of atoms in asymmetric unit. Make sure to 
C----remember reference to symmetry. Increase number of symmetry related atomns
C----for this particular atom.
                       N_SYM_ATOMS(IA) = N_SYM_ATOMS(IA) + 1
                       NXYZS           = NXYZS + 1
                       IF(NXYZS.GT.XYZS_SIZE) THEN
                         CALL ERRWRT(-1,
     +                        'Too many symmetry related atoms')
                         CALL ERRWRT(-1,'Check symmetry and cell'
     +                        //' dimensions')
                         CALL ERRWRT(1,'FIND_CONTACT_WITH_BRICKING'
     +                        //' failed')
                       ENDIF
                       XYZS(1,NXYZS)   = XYZS_TRANSX
                       XYZS(2,NXYZS)   = XYZS_TRANSY
                       XYZS(3,NXYZS)   = XYZS_TRANSZ
                       SYMM_REFER(1,NXYZS)  = IS
                       SYMM_REFER(2,NXYZS)  = -IMODX + IX
                       SYMM_REFER(3,NXYZS)  = -IMODY + IY
                       SYMM_REFER(4,NXYZS)  = -IMODZ + IZ
                       REFER_TO_ATOM(NXYZS) = IA
                     ENDIF
                   ENDDO
                 ENDIF
               ENDDO
             ENDIF
           ENDDO
         ENDDO

c---Find first atom inside entirely in asymmetric unit and remember its address
         FIRST_ATOM(IA) = 0
          DO    IS = 1,N_SYM_ATOMS(IA)
            I_ADDRESS = NXYZS - IS + 1  

            IF(XYZS(1,I_ADDRESS).LE.CELL_ASYM_MAX_FRAC(1).AND.
     +         XYZS(1,I_ADDRESS).GE.CELL_ASYM_MIN_FRAC(1).AND.
     +         XYZS(2,I_ADDRESS).LE.CELL_ASYM_MAX_FRAC(2).AND.
     +         XYZS(2,I_ADDRESS).GE.CELL_ASYM_MIN_FRAC(2).AND.
     +         XYZS(3,I_ADDRESS).LE.CELL_ASYM_MAX_FRAC(3).AND.
     +         XYZS(3,I_ADDRESS).GE.CELL_ASYM_MIN_FRAC(3)) 
     &                                                   THEN
C
c---This atom is entirely in "asymmetric unit"
C---Promote this atom to first in the list of symmetry related atoms for this 
C---particular atom
              N_FIRST_ATOM = NXYZS - N_SYM_ATOMS(IA) + 1
              DO   I=1,3
                T                          = XYZS(I,I_ADDRESS)
                XYZS(I,I_ADDRESS)          = XYZS(I,N_FIRST_ATOM)  
                XYZS(I,N_FIRST_ATOM)       = T
                IT                         = SYMM_REFER(I,I_ADDRESS)
                SYMM_REFER(I,I_ADDRESS)    = SYMM_REFER(I,N_FIRST_ATOM)
                SYMM_REFER(I,N_FIRST_ATOM) = IT
              ENDDO
              IT                         = SYMM_REFER(4,I_ADDRESS)
              SYMM_REFER(4,I_ADDRESS)    = SYMM_REFER(4,N_FIRST_ATOM)
              SYMM_REFER(4,N_FIRST_ATOM) = IT
              FIRST_ATOM(IA)             = N_FIRST_ATOM
        
              GOTO 100
            ENDIF
          ENDDO
 100      CONTINUE
       ENDIF
       ENDDO
C
C---Now we have list of symmetry related atoms and references to first atoms
C---in "asymmetric unit". Create net. I.e. For each box find references to the
C---atoms in asymmetric unit
       DO   I=1,3
          D_BRICKS_FRAC(I) = D_BRICKS(I)/CS_CELL(I)
       ENDDO
c       write(*,*)n_atom,nxyzs
c       write(*,*)n_brick1,n_brick2,n_brick3
       CALL CREATE_NET(NXYZS,XYZS,N_BRICK1,N_BRICK2,
     +                   N_BRICK3,N_MAX_BRICK,ATOMS_IN_THIS_BRICK,
     +                   ATOMS_IN_BRICK,EXT_ASYM_MIN,D_BRICKS_FRAC)
C     
C---Convert all atoms to orthogonal coordinates
       FIRST = 0
       DO   IA=1,NXYZS
         CALL MAT2VEC(3,3,CS_FRAC_TO_ORT,XYZS(1,IA),XYZ_FRAC,ERROR)
         DO    IX=1,3
           XYZS(IX,IA) = XYZ_FRAC(IX)
         ENDDO
       ENDDO
C
      NVDW      = 0
      DO    I=1,3
        EXT_ASYM_MAX(I) = CELL_ASYM_MAX_FRAC(I) + D_BRICKS(I)/CS_CELL(I)
        EXT_ASYM_MIN(I) = CELL_ASYM_MIN_FRAC(I) - D_BRICKS(I)/CS_CELL(I)
      ENDDO
C
C---Loop over first atoms in asymmetric unit
      DO   IA=1,N_ATOM
        I_MULT = 1
        IF(ATOM_REF_FLAG(IA).GT.0) THEN
          N_FIRST_ATOM = FIRST_ATOM(IA)
          IF(N_FIRST_ATOM.LE.0) THEN
            write(*,*)IA,XYZ_CRD(1,IA),XYZ_CRD(2,IA),XYZ_CRD(3,IA)
            write(*,*)'Disaster with machine precision. Ask Garib'
            CALL ERRWRT(1,'Disaster, Disaster!!!!!')
          endif
          CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZS(1,N_FIRST_ATOM),
     +              XYZ_FRAC,ERROR)
          N_CONTACT = 0
          D1_IA = DVDW_MAX
C
C---Find  brick where this atom belongs
          IX_THIS = 
     +        INT((XYZ_FRAC(1)-EXT_ASYM_MIN(1))/D_BRICKS_FRAC(1))+1
          IY_THIS = 
     +        INT((XYZ_FRAC(2)-EXT_ASYM_MIN(2))/D_BRICKS_FRAC(2))+1
          IZ_THIS = 
     +        INT((XYZ_FRAC(3)-EXT_ASYM_MIN(3))/D_BRICKS_FRAC(3))+1
C
C---loop over 27 bricks
           DO   IX=IX_THIS-1,IX_THIS+1
             DO   IY=IY_THIS-1,IY_THIS+1
               DO   IZ=IZ_THIS-1,IZ_THIS+1
C
C---loop over atoms in this box
                 DO    IA_BOX=1,ATOMS_IN_THIS_BRICK(IX,IY,IZ)
C
c---Take address of atom in the brick
                    I_ADDRESS = ATOMS_IN_BRICK(IA_BOX,IX,IY,IZ)
C
                    IA_REFER = REFER_TO_ATOM(I_ADDRESS)
                    D2_IA = DVDW_MAX
                    D1_CUT2 = (D1_IA + D2_IA)**2
                    IF(IA_REFER.GE.IA.AND.
     +                 I_ADDRESS.NE.N_FIRST_ATOM) THEN
C
C---Check this atom
                     DX = (XYZS(1,I_ADDRESS)-XYZS(1,N_FIRST_ATOM))**2
                     IF(DX.LT.D1_CUT2) THEN
                       DXY = DX + 
     +                     (XYZS(2,I_ADDRESS)-XYZS(2,N_FIRST_ATOM))**2
                       IF(DXY.LT.D1_CUT2) THEN
                         DSQ = DXY + 
     +                      (XYZS(3,I_ADDRESS)-XYZS(3,N_FIRST_ATOM))**2
                         IF(DSQ.LT.D1_CUT2) THEN
                           CALL FULL_ATOM_NAME(IA,AT_FULL1,IERROR)
                           CALL FULL_ATOM_NAME(REFER_TO_ATOM(I_ADDRESS),
     &                              AT_FULL2,IERROR)
cd                           IF(DSQ.LT.0.25.AND.
cd     &                         IA.EQ.REFER_TO_ATOM(I_ADDRESS)) THEN
cd                            WRITE(*,*)'Atoms are too close ',SQRT(DSQ),
cd     &                        IA,REFER_TO_ATOM(I_ADDRESS),
cd     &                   AT_FULL1(1:LENSTR(AT_FULL1)),
cd     &                   AT_FULL2(1:LENSTR(AT_FULL2))
cd                            ENDIF
                           IF(DSQ.LT.0.25.AND.
     &                         IA.EQ.REFER_TO_ATOM(I_ADDRESS)) THEN
                              I_MULT = I_MULT + 1
                           ENDIF
                             
C
C---Distance is too small
C
C                          IF(DSQ.LT.EPS_ALLOW) THE
C
C--What to do
C
C--Atoms are same and related with symmetry.
C                           N_MULT_THIS = N_MULT_THIS + 1
C                          ELSE
C
C--Atoms are different 
C                          ENDIF
C
                           NVDW = NVDW + 1
                           IF(NVDW.GT.MAX_VDW) THEN
                             WRITE(*,*)NVDW,IA,MAX_VDW,MAXATOM,N_ATOM,
     &                           NXYZS
                             CALL ERRWRT(-1,'Too many vdw contacts')
                             CALL ERRWRT(-1,'Check symmetry, cell and'
     +                           //' molecular replacement solution')
                             CALL ERRWRT(1,'FIND_CONTACT_WITH_BRICKING'
     +                        //' failed')
                           ENDIF
                           NVDW_TARGET(NVDW) = IA
                           NVDW_OBJECT(NVDW) = REFER_TO_ATOM(I_ADDRESS)
                           IF(NVDW_OBJECT(NVDW).LE.0.OR.IA.LE.0) THEN
                              WRITE(*,*)NVDW,NVDW_OBJECT(NVDW)
                              STOP
                           ENDIF
                           ISYM1 = SYMM_REFER(1,N_FIRST_ATOM)
                           ISYM2 = SYMM_REFER(1,I_ADDRESS)
                           DO    IS=1,3
                             ITX1(IS) = SYMM_REFER(IS+1,I_ADDRESS)-
     +                                  SYMM_REFER(IS+1,N_FIRST_ATOM)
                           ENDDO
                           CALL SYM_FIND(MAXSYM,NumSymmetry,
     +                              RealSymmMatrx,ISYM1,ISYM2,ITX1,
     +                              ISYM_CUR,ITX_CUR,FIRST)
                           NVDW_SYMM(1,NVDW) = ISYM_CUR
                           NVDW_SYMM(2,NVDW) = ITX_CUR(1)
                           NVDW_SYMM(3,NVDW) = ITX_CUR(2)
                           NVDW_SYMM(4,NVDW) = ITX_CUR(3)
                           N_CONTACT         = N_CONTACT + 1
                           IF(N_CONTACT.GT.MAX_CONTACT) THEN
                             CALL ERRWRT(-1,'Too many contacts for one '
     +                        //' atom. Check symmetry and molecule')
                             CALL ERRWRT(-1,'Maximum number of allowed'
     +                        //' contact per atom is '//CMAXCONT)
                             CALL ERRWRT(1,'Find list bricking failed')
                           ENDIF
                         ENDIF
                       ENDIF
                    ENDIF
                  ENDIF
                ENDDO
              ENDDO
            ENDDO
          ENDDO
        ENDIF
C
c---Testing
        IF(I_MULT.GT.1) THEN
          IF(OCCUP(IA)*REAL(I_MULT).GT.1.0001) THEN
             CALL FULL_ATOM_NAME(IA,AT_FULL,IERROR)
             CALL ERRWRT(-1,'Atom ('//AT_FULL(1:LENSTR(AT_FULL))//
     &          ')"s total occupancy (Occ*multipl) > 1.0. Changing it')
             OCCUP(IA) = 1.0/REAL(I_MULT)
          ENDIF
        ENDIF
      ENDDO
C
C---time to return. Analysis of the list of contacts will be done outside 
C---this routine

      RETURN
      END
C
      SUBROUTINE CREATE_NET(NXYZS,XYZS,NX,NY,NZ,
     +                     N_MAX_IN_BRICK,ATOMS_IN_THIS,ATOMS_IN_BRICKS,
     +                     BOX_MIN,D_BRICKS)
      IMPLICIT NONE
cd      INCLUDE 'atom_com.fh'
C
c---This routine creates net. I.e. for each brick list of atoms belonging
C---to this brick is stored. Make sure that large box contains all atoms.
C---
      REAL    XYZS(3,*),BOX_MIN(3),D_BRICKS(3)
       INTEGER NXYZS,NX,NY,NZ,N_MAX_IN_BRICK,ATOMS_IN_THIS(NX,NY,NZ),
     +        ATOMS_IN_BRICKS(N_MAX_IN_BRICK,NX,NY,NZ)

C
C---Local variables
      INTEGER IX,IY,IZ,IA
      CHARACTER LINE*128
C
c---Intrinsic functions
      INTEGER INT
      INTRINSIC INT
C
      DO   IZ=1,NZ
        DO   IY=1,NY
          DO   IX=1,NX
            ATOMS_IN_THIS(IX,IY,IZ) = 0
          ENDDO
        ENDDO
      ENDDO
      DO   IA=1,NXYZS
        IX = INT((XYZS(1,IA)-BOX_MIN(1))/D_BRICKS(1)) + 1
        IY = INT((XYZS(2,IA)-BOX_MIN(2))/D_BRICKS(2)) + 1
        IZ = INT((XYZS(3,IA)-BOX_MIN(3))/D_BRICKS(3)) + 1
        ix = max(1,min(nx,ix))
        iy = max(1,min(ny,iy))
        iz = max(1,min(nz,iz))
        IF(IX.GT.NX.OR.IY.GT.NY.OR.IZ.GT.NZ) THEN
          CALL ERRWRT(-1,'Number of bricks exceeds the the number '//
     +                    'allowed by the calling routine')
          CALL ERRWRT(-1,'It is a programming error. '
     &                 //'Check with the programmer')
          CALL ERRWRT(1,'CREATE_NET failed')
        ENDIF
        ATOMS_IN_THIS(IX,IY,IZ) = ATOMS_IN_THIS(IX,IY,IZ) + 1
        IF(ATOMS_IN_THIS(IX,IY,IZ).GT.N_MAX_IN_BRICK) THEN
          CALL ERRWRT(-1,'Too many atoms in one brick.')
          WRITE(LINE,'(A,I10)')'Maximum allowed in one brick = ',
     +                                N_MAX_IN_BRICK
          CALL ERRWRT(-1,LINE)
          CALL ERRWRT(-1,'Check symmetry, cell dimensions')
          CALL ERRWRT(1,'CREATE_NET failed')
        ENDIF
        ATOMS_IN_BRICKS(ATOMS_IN_THIS(IX,IY,IZ),IX,IY,IZ) = IA
      ENDDO
c      write(*,*)maxval(atoms_in_this(1:nx,1:ny,1:nz))
c      stop
      RETURN
      END
C
      SUBROUTINE SYM_FIND(MAXSYM_IN,NumSymmetry,RealSymmMatrx,ISYM1,
     +                   ISYM2,ITX1,ISYM_OUT,ITX_OUT,FIRST)
C
      IMPLICIT NONE
cd      INCLUDE 'celsym.fh'
Cc
c----This routine prepares table for inversion and multiplaction of
C----symmetry matrices. Idea is that symmetry is group. So inversion
C----and multiplicaion of two elements should belong to that group also.
C----complication arises when translation is involved. In this case
C----I don't know how to tabulate (yet). At the moment routine could be used
C----for multiplication of inversion of one symmetry operator with 
C----another symmetry operator. It could easily be extended to finding
C----inversion or multiplication of symmetry operators also.
C
C----If symmetry is (R1,T1) then its inversion is (R2,T2) Where R2 is
C----symmetry operator and T2 is -R1^(-1) T2. In last operation translational
C----part of symmetry has been removed
c
c----If R1,T1 and R2,T2 are symmetry operators then multiplication of them
C----is R3,T3, Where R3 is one of symmetry operators and T3 = R1 T2 + T1
C----In all cases care should be taken in cases of screw axis
C
c----Integer arguments
      INTEGER MAXSYM_IN,NumSymmetry
      REAL    RealSymmMatrx(4,4,MAXSYM_IN)

      INTEGER MAXSYM
      PARAMETER (MAXSYM = 192)
      INTEGER ISYM1,ISYM2,ITX1(3),ISYM_OUT,ITX_OUT(3)

      INTEGER ISYM_INV(MAXSYM),ITRANS_INV(3,MAXSYM),
     +        SYMM_MULT(MAXSYM,MAXSYM),SYMM_MULT_TRANS(3,MAXSYM,MAXSYM),
     +        IS_TRANS(3),IS_TRANS2(3)
      REAL SYMM_LOCAL(3,3,MAXSYM),TRANS_LOCAL(3,MAXSYM),
     +     SYMM_INVERS(3,3,MAXSYM),SYMM_OUT(3,3),TRANS_OUT(3),TR_OUT(3)
      REAL EPS_LOCAL

      LOGICAL ERROR
      INTEGER FIRST,I,J,ISYM_INV_OUT,IS,IS1,IS2,ITTX,ITTY,ITTZ
      REAL    TTX,TTY,TTZ,DELTA,DELTA1
      COMMON /SYMM_INV/ SYMM_INVERS,ITRANS_INV,SYMM_MULT,
     &                   SYMM_MULT_TRANS,ISYM_INV
      DATA EPS_LOCAL/1.0E-3/
      SAVE   /SYMM_INV/


      IF(FIRST.EQ.0) THEN
        FIRST = 1
        DO   IS=1,NumSymmetry
          DO   J=1,3
            DO   I=1,3
              SYMM_LOCAL(I,J,IS) = RealSymmMatrx(I,J,IS)
            ENDDO
            TRANS_LOCAL(J,IS) = RealSymmMatrx(J,4,IS)
          ENDDO
        ENDDO
        DO    IS=1,NumSymmetry
           CALL MATINV3_R(SYMM_LOCAL(1,1,IS),SYMM_INVERS(1,1,IS))
           CALL MAT2VEC(3,3,SYMM_INVERS(1,1,IS),TRANS_LOCAL(1,IS),
     +                  TRANS_OUT,ERROR)
          DO   I=1,3
             TRANS_OUT(I) = -TRANS_OUT(I)
          ENDDO
          
          IF(ERROR) 
     +       CALL ERRWRT(1,'In SYM_FIND after calling MATINV3')
          DO   IS1=1,NumSymmetry
            DELTA = 0.0
            DO   J=1,3
              DO   I=1,3
                DELTA = DELTA + 
     +              ABS(SYMM_INVERS(I,J,IS)-SYMM_LOCAL(I,J,IS1))
              ENDDO
            ENDDO
            IF(DELTA.LT.EPS_LOCAL) THEN
              DELTA1 = 0.0
              TTX     = TRANS_OUT(1)-TRANS_LOCAL(1,IS1)
              ITTX    = NINT(TTX)
              DELTA1  = ABS(TTX-FLOAT(ITTX))
              TTY     = TRANS_OUT(2)-TRANS_LOCAL(2,IS1)
              ITTY    = NINT(TTY)
              DELTA1  = DELTA1 + ABS(TTY-FLOAT(ITTY))
              TTZ     = TRANS_OUT(3)-TRANS_LOCAL(3,IS1)
              ITTZ    = NINT(TTZ)
              DELTA1  = DELTA1 + ABS(TTZ-FLOAT(ITTZ))
              IF(DELTA1.LT.EPS_LOCAL) THEN
                ISYM_INV(IS)     = IS1
                ITRANS_INV(1,IS) = ITTX
                ITRANS_INV(2,IS) = ITTY
                ITRANS_INV(3,IS) = ITTZ
                GOTO 10
              ENDIF
            ENDIF
          ENDDO
 10       CONTINUE
          DO   IS1=1,NumSymmetry
            CALL MAT2MAT(3,3,SYMM_LOCAL(1,1,IS),SYMM_LOCAL(1,1,IS1),
     +           SYMM_OUT,ERROR)
            CALL MAT2VEC(3,3,SYMM_LOCAL(1,1,IS),TRANS_LOCAL(1,IS1),
     +           TRANS_OUT,ERROR)
            DO   I=1,3
              TRANS_OUT(I) = TRANS_OUT(I) + TRANS_LOCAL(I,IS)
            ENDDO
            DO   IS2=1,NumSymmetry
              DELTA = 0.0
              DO   J=1,3
                DO   I=1,3
                  DELTA = DELTA + ABS(SYMM_OUT(I,J)-SYMM_LOCAL(I,J,IS2))
                ENDDO
              ENDDO
              IF(DELTA.LT.EPS_LOCAL) THEN
                DELTA1 = 0.0
                TTX     = TRANS_OUT(1)-TRANS_LOCAL(1,IS2)
                ITTX    = NINT(TTX)
                DELTA1  = ABS(TTX-FLOAT(ITTX))
                TTY     = TRANS_OUT(2)-TRANS_LOCAL(2,IS2)
                ITTY    = NINT(TTY)
                DELTA1  = DELTA1 + ABS(TTY-FLOAT(ITTY))
                TTZ     = TRANS_OUT(3)-TRANS_LOCAL(3,IS2)
                ITTZ    = NINT(TTZ)
                DELTA1  = DELTA1 + ABS(TTZ-FLOAT(ITTZ))
                IF(DELTA1.LT.EPS_LOCAL) THEN
                  SYMM_MULT(IS,IS1)         = IS2
                  SYMM_MULT_TRANS(1,IS,IS1) = ITTX
                  SYMM_MULT_TRANS(2,IS,IS1) = ITTY
                  SYMM_MULT_TRANS(3,IS,IS1) = ITTZ
                  GOTO 20
                ENDIF
              ENDIF     
            ENDDO
 20         CONTINUE
          ENDDO
        ENDDO
      ENDIF
C
C---find multiplicatation of inverse of symmetry with symmetry.
C---If symmetr is (R,T) then (R1,T1)^1 (R2,T2) = (R3,T3). 
C---Where T3 = R1^1(T2-T1)
C
C---First find Inversion matrix
      IF(ISYM1.EQ.ISYM2.AND.ITX1(1).EQ.0.AND.
     +                      ITX1(2).EQ.0.AND.
     +                      ITX1(3).EQ.0) THEN
         ISYM_OUT   = SYMM_MULT(ISYM_INV(ISYM1),ISYM2)
         ITX_OUT(1) = 0
         ITX_OUT(2) = 0
         ITX_OUT(3) = 0
         RETURN
      ENDIF
      ISYM_INV_OUT = ISYM_INV(ISYM1)

      DO    I = 1,3
        IS_TRANS(I) = ITRANS_INV(I,ISYM1)
      ENDDO
C
c---Inverse of symmetry sym1 is ISYM_INV_OUT and corresponding translation
C---is IS_TRANS
c
c---Multiply ISYM_INV_OUT to ISYM2
      ISYM_OUT = SYMM_MULT(ISYM_INV_OUT,ISYM2)
      DO    I=1,3
        IS_TRANS2(I) = SYMM_MULT_TRANS(I,ISYM_INV_OUT,ISYM2)
      ENDDO
C
c---Now find translations
      DO   I=1,3
        TR_OUT(I) = FLOAT(IS_TRANS(I) + IS_TRANS2(I))
        DO   J=1,3
           TR_OUT(I) = TR_OUT(I) + RealSymmMatrx(I,J,ISYM_INV_OUT)*
     +         FLOAT(ITX1(J)) 
         ENDDO
         ITX_OUT(I) = NINT(TR_OUT(I))
         IF(ABS(FLOAT(ITX_OUT(I))-TR_OUT(I)).GT.EPS_LOCAL) THEN
           WRITE(*,*)'ISYM1',ISYM1,ISYM2,ISYM_OUT
           WRITE(*,*)ITX1
           WRITE(*,*)TR_OUT  
           CALL ERRWRT(1,'Problems in SYMM_FIND')
         ENDIF
      ENDDO
      RETURN
      END
C
      SUBROUTINE SYM_FIND_r(MAXSYM_in,nsym,rot,tr,ISYM1,
     +                   ISYM2,ITX1,ISYM_OUT,ITX_OUT,FIRST)
C
      IMPLICIT NONE
cd      INCLUDE 'celsym.fh'
Cc
c----This routine prepares table for inversion and multiplaction of
C----symmetry matrices. Idea is that symmetry is group. So inversion
C----and multiplicaion of two elements should belong to that group also.
C----complication arises when translation is involved. In this case
C----I don't know how to tabulate (yet). At the moment routine could be used
C----for multiplication of inversion of one symmetry operator with 
C----another symmetry operator. It could easily be extended to finding
C----inversion or multiplication of symmetry operators also.
C
C----If symmetry is (R1,T1) then its inversion is (R2,T2) Where R2 is
C----symmetry operator and T2 is -R1^(-1) T2. In last operation translational
C----part of symmetry has been removed
c
c----If R1,T1 and R2,T2 are symmetry operators then multiplication of them
C----is R3,T3, Where R3 is one of symmetry operators and T3 = R1 T2 + T1
C----In all cases care should be taken in cases of screw axis
C
c----Integer arguments
      INTEGER maxsym_in,nsym
      REAL    rot(3,3,maxsym_in),tr(3,maxsym_in)

      INTEGER MAXSYM
      PARAMETER (MAXSYM = 192)
      INTEGER ISYM1,ISYM2,ITX1(3),ISYM_OUT,ITX_OUT(3)

      INTEGER ISYM_INV(MAXSYM),ITRANS_INV(3,MAXSYM),
     +        SYMM_MULT(MAXSYM,MAXSYM),SYMM_MULT_TRANS(3,MAXSYM,MAXSYM),
     +        IS_TRANS(3),IS_TRANS2(3)
      REAL SYMM_INVERS(3,3,MAXSYM),SYMM_OUT(3,3),TRANS_OUT(3),TR_OUT(3)
      REAL EPS_LOCAL

      LOGICAL ERROR
      INTEGER FIRST,I,J,ISYM_INV_OUT,IS,IS1,IS2,ITTX,ITTY,ITTZ
      REAL    TTX,TTY,TTZ,DELTA,DELTA1
      COMMON /SYMM_INV/ SYMM_INVERS,ITRANS_INV,SYMM_MULT,
     &                   SYMM_MULT_TRANS,ISYM_INV
      DATA EPS_LOCAL/1.0E-3/
      SAVE   /SYMM_INV/


      IF(FIRST.EQ.0) THEN
        FIRST = 1
        DO    IS=1,nsym
           CALL MATINV3_R(rot(1,1,IS),SYMM_INVERS(1,1,IS))
           CALL MAT2VEC(3,3,SYMM_INVERS(1,1,IS),tr(1,IS),
     +                  TRANS_OUT,ERROR)
          DO   I=1,3
             TRANS_OUT(I) = -TRANS_OUT(I)
          ENDDO
          
          IF(ERROR) 
     +       CALL ERRWRT(1,'In SYM_FIND after calling MATINV3')
          DO   IS1=1,nsym
            DELTA = 0.0
            DO   J=1,3
              DO   I=1,3
                DELTA = DELTA + 
     +              ABS(SYMM_INVERS(I,J,IS)-rot(I,J,IS1))
              ENDDO
            ENDDO
            IF(DELTA.LT.EPS_LOCAL) THEN
              DELTA1 = 0.0
              TTX     = TRANS_OUT(1)-TR(1,IS1)
              ITTX    = NINT(TTX)
              DELTA1  = ABS(TTX-FLOAT(ITTX))
              TTY     = TRANS_OUT(2)-TR(2,IS1)
              ITTY    = NINT(TTY)
              DELTA1  = DELTA1 + ABS(TTY-FLOAT(ITTY))
              TTZ     = TRANS_OUT(3)-TR(3,IS1)
              ITTZ    = NINT(TTZ)
              DELTA1  = DELTA1 + ABS(TTZ-FLOAT(ITTZ))
              IF(DELTA1.LT.EPS_LOCAL) THEN
                ISYM_INV(IS)     = IS1
                ITRANS_INV(1,IS) = ITTX
                ITRANS_INV(2,IS) = ITTY
                ITRANS_INV(3,IS) = ITTZ
                GOTO 10
              ENDIF
            ENDIF
          ENDDO
 10       CONTINUE
          DO   IS1=1,nsym
            CALL MAT2MAT(3,3,rot(1,1,IS),rot(1,1,IS1),
     +           SYMM_OUT,ERROR)
            CALL MAT2VEC(3,3,ROT(1,1,IS),TR(1,IS1),
     +           TRANS_OUT,ERROR)
            DO   I=1,3
              TRANS_OUT(I) = TRANS_OUT(I) + TR(I,IS)
            ENDDO
            DO   IS2=1,nsym
              DELTA = 0.0
              DO   J=1,3
                DO   I=1,3
                  DELTA = DELTA + ABS(SYMM_OUT(I,J)-ROT(I,J,IS2))
                ENDDO
              ENDDO
              IF(DELTA.LT.EPS_LOCAL) THEN
                DELTA1 = 0.0
                TTX     = TRANS_OUT(1)-TR(1,IS2)
                ITTX    = NINT(TTX)
                DELTA1  = ABS(TTX-FLOAT(ITTX))
                TTY     = TRANS_OUT(2)-TR(2,IS2)
                ITTY    = NINT(TTY)
                DELTA1  = DELTA1 + ABS(TTY-FLOAT(ITTY))
                TTZ     = TRANS_OUT(3)-TR(3,IS2)
                ITTZ    = NINT(TTZ)
                DELTA1  = DELTA1 + ABS(TTZ-FLOAT(ITTZ))
                IF(DELTA1.LT.EPS_LOCAL) THEN
                  SYMM_MULT(IS,IS1)         = IS2
                  SYMM_MULT_TRANS(1,IS,IS1) = ITTX
                  SYMM_MULT_TRANS(2,IS,IS1) = ITTY
                  SYMM_MULT_TRANS(3,IS,IS1) = ITTZ
                  GOTO 20
                ENDIF
              ENDIF     
            ENDDO
 20         CONTINUE
          ENDDO
        ENDDO
      ENDIF
C
C---find multiplicatation of inverse of symmetry with symmetry.
C---If symmetr is (R,T) then (R1,T1)^1 (R2,T2) = (R3,T3). 
C---Where T3 = R1^1(T2-T1)
C
C---First find Inversion matrix
      IF(ISYM1.EQ.ISYM2.AND.ITX1(1).EQ.0.AND.
     +                      ITX1(2).EQ.0.AND.
     +                      ITX1(3).EQ.0) THEN
         ISYM_OUT   = SYMM_MULT(ISYM_INV(ISYM1),ISYM2)
         ITX_OUT(1) = 0
         ITX_OUT(2) = 0
         ITX_OUT(3) = 0
         RETURN
      ENDIF
      ISYM_INV_OUT = ISYM_INV(ISYM1)

      DO    I = 1,3
        IS_TRANS(I) = ITRANS_INV(I,ISYM1)
      ENDDO
C
c---Inverse of symmetry sym1 is ISYM_INV_OUT and corresponding translation
C---is IS_TRANS
c
c---Multiply ISYM_INV_OUT to ISYM2
      ISYM_OUT = SYMM_MULT(ISYM_INV_OUT,ISYM2)
      DO    I=1,3
        IS_TRANS2(I) = SYMM_MULT_TRANS(I,ISYM_INV_OUT,ISYM2)
      ENDDO
C
c---Now find translations
      DO   I=1,3
        TR_OUT(I) = FLOAT(IS_TRANS(I) + IS_TRANS2(I))
        DO   J=1,3
           TR_OUT(I) = TR_OUT(I) + rot(I,J,ISYM_INV_OUT)*
     +         FLOAT(ITX1(J)) 
         ENDDO
         ITX_OUT(I) = NINT(TR_OUT(I))
         IF(ABS(FLOAT(ITX_OUT(I))-TR_OUT(I)).GT.EPS_LOCAL) THEN
           WRITE(*,*)'ISYM1',ISYM1,ISYM2,ISYM_OUT
           WRITE(*,*)ITX1
           WRITE(*,*)TR_OUT  
           CALL ERRWRT(1,'Problems in SYMM_FIND')
         ENDIF
      ENDDO
      RETURN
      END
C
      SUBROUTINE ANALYSE_VDW(ALPHA,IWRITE_FIRST,IANALYSE_REST)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INTEGER IWRITE_FIRST,IANALYSE_REST
      REAL ALPHA
C
      INTEGER TARG_ADDRESS,OBJE_ADDRESS,NSYMM_ADDRESS,NR_PER_AT_ADDRESS,
     &        REST_PER_AT_ADDRESS,NREM_ADDRESS,
     &        NREMAIN_SIZE,MAXVDW,N_USED_MEM
      REAL WORKSP(QQDEN)
      COMMON /R_SCRATCH/WORKSP
C
C---Decide size of memory.
C
      MAXVDW              = 80*N_ATOM
      TARG_ADDRESS        = 1
      OBJE_ADDRESS        = TARG_ADDRESS + MAXVDW
      NSYMM_ADDRESS       = OBJE_ADDRESS + MAXVDW
      NR_PER_AT_ADDRESS   = NSYMM_ADDRESS + 4*MAXVDW
      REST_PER_AT_ADDRESS = NR_PER_AT_ADDRESS + N_ATOM
      NREM_ADDRESS        = REST_PER_AT_ADDRESS + 80*N_ATOM
      NREMAIN_SIZE        = QQDEN - (6*MAXVDW + 81*N_ATOM)
C
      N_USED_MEM = 6*MAXVDW + 61*N_ATOM
      IF(NREMAIN_SIZE.LT.0) THEN
        CALL ERRWRT(-1,'Memory is not enough for vdw contacts')
        CALL ERRWRT(-1,'QQDEN in pls_incl.fh should be increased'//
     &                 ' at least twice')
        CALL ERRWRT(1,'Error in ANALYSE_VDW')
      ENDIF
C
      CALL ANALYSE_VDW_REAL(ALPHA,MAXVDW,IWRITE_FIRST,IANALYSE_REST,
     &                            WORKSP(TARG_ADDRESS),
     &                            WORKSP(OBJE_ADDRESS),
     &                            WORKSP(NSYMM_ADDRESS),
     &                            WORKSP(NR_PER_AT_ADDRESS),
     &                            WORKSP(REST_PER_AT_ADDRESS),
     &                            WORKSP(NREM_ADDRESS),
     &                            NREMAIN_SIZE,N_USED_MEM)
C
      RETURN
      END
C
      SUBROUTINE ANALYSE_VDW_REAL(ALPHA,MAXVDW,IWRITE_FIRST,
     &                          IANALYSE_REST,NVDW_TARGET,NVDW_OBJECT,
     &                          NVDW_SYMM,NREST_PER_ATOM,REST_PER_ATOM,
     &                          WORKSPACE,N_REMAIN_ARRAY,
     &                          N_USED_MEM)
      IMPLICIT NONE
C
      INTEGER IWRITE_FIRST,IANALYSE_REST
      REAL ALPHA
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'restr_files.fh'
      INCLUDE 'vitals.fh'
      INTEGER MAXVDW,NVDW_L,N_USED_MEM
      INTEGER NVDW_TARGET(MAXVDW),NVDW_OBJECT(MAXVDW),
     &        NVDW_SYMM(4,MAXVDW),NREST_PER_ATOM(N_ATOM),
     &        REST_PER_ATOM(80*N_ATOM)
      INTEGER N_TARGET,N_OBJECT,NW_UVAL,NSYM_DIST(4,QQD)
      COMMON /DISTNS/ N_OBJECT( QQD),N_TARGET( QQD),NW_UVAL( QQD),
     &        NSYM_DIST

      REAL WORKSPACE(*)
      REAL RAD1,RAD2,DVDW_IDEAL,VDW_SDI
      INTEGER I,N_REMAIN_ARRAY,ISCRV,IFAIL,LL,IV1,IV2,ID,IVDW_TYPE
      CHARACTER SCRATCH_FILE*256
      INTEGER LENSTR
      EXTERNAL LENSTR
C
C---This routine is to analyse vdw contact list. It check if atoms are 
c---than possible vdw contact distance. And some other checks
      CALL FIND_CONTACT_LIST(MAXVDW,NVDW_L,NVDW_TARGET,NVDW_OBJECT,
     +           NVDW_SYMM,WORKSPACE,N_REMAIN_ARRAY,N_USED_MEM) 
C
C---first check if atoms are close to each other
      IF(IWRITE_FIRST.EQ.1) THEN
C
C---Write current distances to a file
        ISCRV = 0
        IFAIL = -1
        CALL UGTENV('TEMP1',SCRATCH_FILE)
        IF(SCRATCH_FILE(1:1).NE.' ') THEN
          VDW_FILE_0 = SCRATCH_FILE(1:LENSTR(SCRATCH_FILE))//'_VDW_R_0'
        ELSE
          VDW_FILE_0 = '_VDW_R_0'
        ENDIF
        CALL CCPDPN(ISCRV,VDW_FILE_0(1:LENSTR(VDW_FILE_0)),'UNKNOWN',
     &      'U',LL,IFAIL)
        DO   ID=1,NVDW_L
          IV1        = NVDW_TARGET(ID)
          IV2        = NVDW_OBJECT(ID)
          RAD1       = VDW_RAD(IV1)
          RAD2       = VDW_RAD(IV2)
          DVDW_IDEAL = RAD1+RAD2
          VDW_SDI    = VDW_SDI_VDW
          IVDW_TYPE  = 1
          WRITE(ISCRV)NVDW_TARGET(ID),NVDW_OBJECT(ID),DVDW_IDEAL,
     &          VDW_SDI,(NVDW_SYMM(I,ID),I=1,4),IVDW_TYPE
        ENDDO
        CLOSE(ISCRV)
      ENDIF
      NDIS = NVDW_L
C
c---Now read restraints and analyse if pair of atoms should have vdw
C---restraints. Do it if it is necessary.
      IF(IANALYSE_REST.EQ.1) THEN
        IF(N_REMAIN_ARRAY.LE.0) THEN
           CALL ERRWRT(1,'Not enough memory in ANALYSE_VDW')
        ENDIF
        CALl ANALYSE_VDW_2(MAXVDW,NVDW_L,MAXVDW,NVDW_TARGET,
     &                   NVDW_OBJECT,NVDW_SYMM,ALPHA,NREST_PER_ATOM,
     &                   REST_PER_ATOM,
     &                   N_TARGET,
     &                   N_OBJECT,
     &                   WORKSPACE,
     &                   N_REMAIN_ARRAY,N_USED_MEM)
      ENDIF
C
C----Now assign "ideal" value for "vdw". analyse
C
      RETURN
      END
C
      SUBROUTINE ANALYSE_VDW_2(MAXVDW,NVDW,MAX_DIST,NVDW_TARGET,
     &                   NVDW_OBJECT,NVDW_SYMM,ALPHA,NREST_PER_ATOM,
     &                   REST_PER_ATOM,N_TARGET,N_OBJECT,
     &                   WORKSPACE,
     &                   N_REMAIN_ARRAY,N_USED_MEM)
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'restr_files.fh'
      INCLUDE 'weights.fh'
      REAL    ALPHA
      INTEGER MAXVDW,NVDW,MAX_DIST,N_REMAIN_ARRAY,N_USED_MEM
      INTEGER NVDW_TARGET(*),NVDW_OBJECT(*),NVDW_SYMM(4,*),
     &        N_OBJECT(*),N_TARGET(*)
      INTEGER NREST_PER_ATOM(*),REST_PER_ATOM(N_ATOM,*)
      REAL    WORKSPACE(*)
C
      INTEGER IA(100),ISYM1,ITX(3)
      INTEGER ISCRB,NDIST,IDIST,IAA,IDD,IFAIL,LL,ISCRP,IVDW,NBONDS_VDW,
     &        IV1,IV2,ISYM,I,J,IVDW_TYPE,NVDW1,IS,NPLANE,IPL,IMODE,
     &        N_PLANES,NREST_IV1,IREST,N_BONDS,NDISTA,NDISTT,IV1R,IV1O,
     &        ISCRV,IR1,IEL1,IEL2
      integer ityp
      REAL RS_VIDL,RS_SDI,DINC_CURRENT,RAD1,RAD2,XYZ_TMP(3),XYZ_TMP1(3)
      REAL VDW_SDI,RS_BOND,RS_SDI_B,DIST_CUR,DVDW_IDEAL,DVDW_MAX,
     &     RS_ANGLE,RS_SDI_A,DINC_CURR1,DINC_CURR2
      CHARACTER SCRATCH_FILE*256
      INTEGER  LENSTR
      EXTERNAL LENSTR
      LOGICAL ERROR
C
      NDIST = 0
      DO   IAA = 1,N_ATOM
        NREST_PER_ATOM(IAA) = 0
      ENDDO
C
C------------------
C
C---First remove by VDW criteria
cd      CALL REMOVE_BY_VDW
cd      CALL WRITE_AS_BONDS
      NBONDS_VDW = 0
      DO  IVDW=1,NVDW
        IVDW_TYPE = 1
        IV1    = NVDW_TARGET(IVDW)
        IV2    = NVDW_OBJECT(IVDW)
        ISYM   = NVDW_SYMM(1,IVDW)
        ITX(1) = NVDW_SYMM(2,IVDW)
        ITX(2) = NVDW_SYMM(3,IVDW)
        ITX(3) = NVDW_SYMM(4,IVDW)
        IF(OCCUP(IV1)+OCCUP(IV2).LE.1.0001) THEN
C
C---Check if atoms are from the same residue (including symmetry) with same 
C alt code. If they are same then these atoms can coexist
          IF(.NOT.(ID_ALT(IV1).EQ.ID_ALT(IV2).AND.
     &       I_RESID(IV1).EQ.I_RESID(IV2).AND.
     &        NVDW_SYMM(1,IVDW).EQ.1.AND.
     &       NVDW_SYMM(2,IVDW).EQ.0.AND.
     &       NVDW_SYMM(3,IVDW).EQ.0.AND.
     &       NVDW_SYMM(4,IVDW).EQ.0)) THEN
cd.AND.

cd     &       .NOT.(ID_ALT(IV1).NE.ID_ALT(IV2).AND.

cd     &        I_RESID(IV1).EQ.I_RESID(IV2).AND.

cd     &       (NVDW_SYMM(1,IVDW).NE.1.OR.

cd     &       NVDW_SYMM(2,IVDW).NE.0.OR.

cd     &       NVDW_SYMM(3,IVDW).NE.0.OR.

cd     &       NVDW_SYMM(4,IVDW).NE.0)))THEN
               NVDW_SYMM(1,IVDW) = -1
              GOTO 30
          ENDIF
        ENDIF
        CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IV2),XYZ_TMP,ERROR)
        DO   I=1,3
          XYZ_TMP1(I) = RealSymmMatrx(I,1,ISYM)*XYZ_TMP(1) +
     +                  RealSymmMatrx(I,2,ISYM)*XYZ_TMP(2) +
     +                  RealSymmMatrx(I,3,ISYM)*XYZ_TMP(3) +
     +                  RealSymmMatrx(I,4,ISYM) + FLOAT(ITX(I))
        ENDDO
        CALL MAT2VEC(3,3,CS_FRAC_TO_ORT,XYZ_TMP1,XYZ_TMP,ERROR)
        DIST_CUR = SQRT((XYZ_TMP(1)-XYZ_CRD(1,IV1))**2 + 
     +                  (XYZ_TMP(2)-XYZ_CRD(2,IV1))**2 +  
     +                  (XYZ_TMP(3)-XYZ_CRD(3,IV1))**2) 
        RAD1       = VDW_RAD(IV1)
        RAD2       = VDW_RAD(IV2)
        DVDW_IDEAL = RAD1+RAD2
        IF(DIST_CUR.GT.DVDW_IDEAL) NVDW_SYMM(1,IVDW) = -1
 30   CONTINUE
      ENDDO
      NVDW1 = 0
      DO   IVDW=1,NVDW
        IF(NVDW_SYMM(1,IVDW).GT.0) THEN
          NVDW1 = NVDW1 + 1
          NVDW_TARGET(NVDW1) = NVDW_TARGET(IVDW)
          NVDW_OBJECT(NVDW1) = NVDW_OBJECT(IVDW)
          DO    IS=1,4
            NVDW_SYMM(IS,NVDW1) = NVDW_SYMM(IS,IVDW)
          ENDDO
        ENDIF
      ENDDO
      NVDW = NVDW1
C
C----Read planes and find restraint pairs
C
C--Remove vdw corresponding to the restraints
cd      NDIST = 0
cd      ISCRP = 0
cd      IFAIL = -1
cd      IF(PLANE_FILE(1:1).NE.' ') THEN
cd      CALL CCPDPN(ISCRP,PLANE_FILE(1:LENSTR(PLANE_FILE)),'UNKNOWN',
cd     &             'U',LL,IFAIL)
cd 50   CONTINUE
cd      READ(ISCRP,END=59)NPLANE,RS_VIDL,RS_SDI,
cd     &         (IA(IPL),IPL=1,NPLANE)
cd      IF(RS_SDI.LE.0.0) GOTO 50
cd      DO   I=1,NPLANE-1
cd        IF(ATOM_REF_FLAG(IA(I)).GT.0) THEN
cd          DO   J=I+1,NPLANE
cd            IF(ATOM_REF_FLAG(IA(J)).GT.0) THEN
cd              CALL  FIND1_RESTRAINT(MAX_DIST,NDIST,IDIST,IA(I),IA(J),
cd     &           N_ATOM,NREST_PER_ATOM,REST_PER_ATOM,N_TARGET,N_OBJECT,
cd     &           IMODE)
cd              N_3_TORS_ONLY(IDIST) = 0
cd            ENDIF
cd          ENDDO
cd        ENDIF
cd      ENDDO
cd      GOTO 50
cd 59   CONTINUE
cd      ENDIF
cd      N_PLANES = NDIST
cd      CLOSE(UNIT=ISCRP)
cd      ISCRP = 0
C
c---Remove if atoms belong to the same plane
C
C---Remove planes
cd      DO   IVDW=1,NVDW
cd        IVDW_TYPE = 1
cd        IV1    = NVDW_TARGET(IVDW)
cd        IV2    = NVDW_OBJECT(IVDW)
cd        ISYM   = NVDW_SYMM(1,IVDW)
cd        ITX(1) = NVDW_SYMM(2,IVDW)
cd        ITX(2) = NVDW_SYMM(3,IVDW)
cd        ITX(3) = NVDW_SYMM(4,IVDW)
cd        IF(ISYM.EQ.1.AND.
cd     &       ITX(1).EQ.0.AND.ITX(2).EQ.0.AND.ITX(3).EQ.0) THEN
cd          IF(NREST_PER_ATOM(IV1).GT.0.AND.NREST_PER_ATOM(IV2).GT.0) THEN
cd            NREST_IV1 = NREST_PER_ATOM(IV1)
cd            DO   IREST = 1,NREST_IV1
cd              IR1 = REST_PER_ATOM(IV1,IREST)
cd              IF(N_TARGET(IR1).EQ.IV2.OR.N_OBJECT(IR1).EQ.IV2) THEN
C
C---Pair is in the list of restraints. 
cd                NVDW_SYMM(1,IVDW) = -1
cd                GOTO 9
cd              ENDIF
cd            ENDDO
cd          ENDIF
cd        ENDIF
cd 9      CONTINUE
cd      ENDDO
C
cd      NVDW1 = 0
cd      DO   IVDW=1,NVDW
cd        IF(NVDW_SYMM(1,IVDW).GT.0) THEN
cd          NVDW1 = NVDW1 + 1
cd          NVDW_TARGET(NVDW1) = NVDW_TARGET(IVDW)
cd          NVDW_OBJECT(NVDW1) = NVDW_OBJECT(IVDW)
cd          DO    IS=1,4
cd            NVDW_SYMM(IS,NVDW1) = NVDW_SYMM(IS,IVDW)
cd          ENDDO
cd        ENDIF
cd      ENDDO
cd      NVDW = NVDW1
C
      NDIST = 0
      DO   IAA = 1,N_ATOM
        NREST_PER_ATOM(IAA) = 0
      ENDDO
cd      DO   IDD = 1,MAX_DIST
cd         N_3_TORS_ONLY(IDD) = 0
cd      ENDDO
C
      ISCRB = 0
      IFAIL = -1
      NDIST = 0
      IF(BOND_FILE(1:1).NE.' ') THEN
      CALL CCPDPN(ISCRB,BOND_FILE(1:LENSTR(BOND_FILE)),'UNKNOWN',
     &       'U',LL,IFAIL)
 10   CONTINUE
      READ(ISCRB,END=19)IA(1),IA(2),RS_VIDL,RS_SDI,ISYM1,ITX(1),ITX(2),
     &                    ITX(3),ityp     
      IF(RS_SDI.LE.0.0) GOTO 10
      IF(IA(1).LE.0.OR.IA(2).LE.0) GOTO 10
cd      IF(ISYM1.NE.1.OR.
cd     &   ITX(1).NE.0.OR.ITX(2).NE.0.OR.ITX(3).NE.0) GOTO 18
      IF(ATOM_REF_FLAG(IA(1)).LE.0.OR.ATOM_REF_FLAG(IA(2)).LE.0) GOTO 10
      IF(IA(1).NE.IA(2)) THEN
      CALL  FIND1_RESTRAINT(MAX_DIST,NDIST,IDIST,IA(1),IA(2),N_ATOM,
     &          NREST_PER_ATOM,REST_PER_ATOM,N_TARGET,N_OBJECT,IMODE)
      ENDIF
C
C---Make seperate list for symmetry related bonds
      GOTO 10
 18   CONTINUE
 19   CONTINUE
      ENDIF

      N_BONDS = NDIST
      CLOSE (UNIT=ISCRB)
      ISCRB = 0
C
C---Find all bonds angles and torsion angle

      CALL ADD_ANGLES_TORSIONS(MAX_DIST,NDIST,NDISTA,NDISTT,MAXATOM,
     &                         N_ATOM,
     &                         NREST_PER_ATOM,
     &                         REST_PER_ATOM,N_TARGET,N_OBJECT)
C
C---And angles and torsion for symmetry related related bonds
C
c---Remove if atoms are involved in covalent bond or they are attached
C---to each other through angle
      RS_ANGLE = 2.28
      RS_SDI_A = 0.2
      DO   IVDW=1,NVDW
        IVDW_TYPE = 1
        IV1    = NVDW_TARGET(IVDW)
        IV2    = NVDW_OBJECT(IVDW)
        ISYM   = NVDW_SYMM(1,IVDW)
        ITX(1) = NVDW_SYMM(2,IVDW)
        ITX(2) = NVDW_SYMM(3,IVDW)
        ITX(3) = NVDW_SYMM(4,IVDW)
C---Take care cases when bond is through symmetry. Perhaps seperate list 
C---for them
        IF(NREST_PER_ATOM(IV1).GT.0.AND.NREST_PER_ATOM(IV2).GT.0) THEN
          NREST_IV1 = NREST_PER_ATOM(IV1)
          DO   IREST = 1,NREST_IV1
            IR1 = REST_PER_ATOM(IV1,IREST)
            IF(IR1.LE.NDISTA) THEN
              IV1R = N_TARGET(IR1)
              IV1O = N_OBJECT(IR1)
              IF(IV1R.EQ.IV2.OR.IV1O.EQ.IV2) THEN
C
C---Pair is in the list of restraints. Check if it is angle add to the list.
C---It should be an option and values should be defined before or should
C---be extracted from the atomic types.
C
C---Check if atoms this vdw is through symmetry and one of the atoms have
C---less than 1 occupancy then no contacts.
c                IF(ISYM.EQ.1.AND.
c     &             ITX(1).EQ.0.AND.ITX(2).EQ.0.AND.ITX(3).EQ.0) THEN
c     &            (.NOT.(ISYM.EQ.1.AND.
c     &             ITX(1).EQ.0.AND.ITX(2).EQ.0.AND.ITX(3).EQ.0).AND.
c     &           (OCCUP(IV1).LE.0.50001.OR.OCCUP(IV2).LE.0.50001)
                   NVDW_SYMM(1,IVDW) = -1
                  GOTO 119
c                ENDIF
              ENDIF
            ENDIF
          ENDDO
        ENDIF
 119    CONTINUE
      ENDDO
C
      NVDW1 = 0
      DO   IVDW=1,NVDW
        IF(NVDW_SYMM(1,IVDW).GT.0) THEN
          NVDW1 = NVDW1 + 1
          NVDW_TARGET(NVDW1) = NVDW_TARGET(IVDW)
          NVDW_OBJECT(NVDW1) = NVDW_OBJECT(IVDW)
          DO    IS=1,4
            NVDW_SYMM(IS,NVDW1) = NVDW_SYMM(IS,IVDW)
          ENDDO
        ENDIF
      ENDDO
      NVDW = NVDW1

C
C----Remove bonds and associated angles through symmetry also

C
C---Now check if pair should be treated as potential vdw pair
      ISCRV = 0
      IFAIL = -1
      CALL UGTENV('TEMP1',SCRATCH_FILE)
      IF(SCRATCH_FILE(1:1).NE.' ') THEN
        VDW_FILE = SCRATCH_FILE(1:LENSTR(SCRATCH_FILE))//'_VDW_R'
      ELSE
        VDW_FILE = '_VDW_R'
      ENDIF
      CALL CCPDPN(ISCRV,VDW_FILE(1:LENSTR(VDW_FILE)),'UNKNOWN',
     &    'U',LL,IFAIL)
      NVDW1 = 0
C
c----Loop over possible VDWs.
      DO    IVDW = 1,NVDW
        IVDW_TYPE    = 1
        DINC_CURRENT = 0.0
        IV1    = NVDW_TARGET(IVDW)
        IV2    = NVDW_OBJECT(IVDW)
        ISYM   = NVDW_SYMM(1,IVDW)
        ITX(1) = NVDW_SYMM(2,IVDW)
        ITX(2) = NVDW_SYMM(3,IVDW)
        ITX(3) = NVDW_SYMM(4,IVDW)
        CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IV2),XYZ_TMP,ERROR)
        DO   I=1,3
          XYZ_TMP1(I) = RealSymmMatrx(I,1,ISYM)*XYZ_TMP(1) +
     +                  RealSymmMatrx(I,2,ISYM)*XYZ_TMP(2) +
     +                  RealSymmMatrx(I,3,ISYM)*XYZ_TMP(3) +
     +                  RealSymmMatrx(I,4,ISYM) + FLOAT(ITX(I))
        ENDDO
        CALL MAT2VEC(3,3,CS_FRAC_TO_ORT,XYZ_TMP1,XYZ_TMP,ERROR)
        DIST_CUR = SQRT((XYZ_TMP(1)-XYZ_CRD(1,IV1))**2 + 
     +                  (XYZ_TMP(2)-XYZ_CRD(2,IV1))**2 +  
     +                  (XYZ_TMP(3)-XYZ_CRD(3,IV1))**2) 
        RAD1       = VDW_RAD(IV1)
        RAD2       = VDW_RAD(IV2)
        DVDW_IDEAL = RAD1+RAD2
        IF(DIST_CUR.GT.DVDW_IDEAL) GOTO 999
C
C---Check if these atoms should be considered by calculating distance
C---between them and checking if they are less than maximum allowed 
C---vdw for 2 atoms. If hydrogens are present this part should be skipped
        VDW_SDI = VDW_SDI_VDW
        IF(NREST_PER_ATOM(IV1).GT.1.AND.NREST_PER_ATOM(IV2).GT.1) THEN
          NREST_IV1 = NREST_PER_ATOM(IV1)
          DO   IREST = 1,NREST_IV1
            IR1 = REST_PER_ATOM(IV1,IREST)
            IF(IR1.GT.NDISTA.AND.IR1.LE.NDISTT.AND.ISYM.EQ.1.AND.
     &         ITX(1).EQ.0.AND.ITX(2).EQ.0.AND.ITX(3).EQ.0) THEN
              IF(N_TARGET(IR1).EQ.IV2.OR.N_OBJECT(IR1).EQ.IV2) THEN
C
C---Pair is in the list of restraints. 
cd                DINC_CURRENT = -0.3
                DINC_CURRENT = 2.0*DINC_TORSION_ALL
                VDW_SDI      = VDW_SDI_TORSION
                IEL1 = ID_SF(IV1)
                IEL2 = ID_SF(IV2)
                IF(CS_ELEMENT(IEL1).EQ.'O   ') THEN
                  DINC_CURR1 = DINC_TORSION_O
                ELSE IF(CS_ELEMENT(IEL1).EQ.'N   ') THEN
                  DINC_CURR1 = DINC_TORSION_N
                ELSE IF(CS_ELEMENT(IEL1).EQ.'C   ') THEN
                  DINC_CURR1 = DINC_TORSION_C
                ELSE
                  DINC_CURR1 = DINC_TORSION_ALL
                ENDIF
                IF(CS_ELEMENT(IEL2).EQ.'O   ') THEN
                  DINC_CURR2 = DINC_TORSION_O
                ELSE IF(CS_ELEMENT(IEL2).EQ.'N   ') THEN
                  DINC_CURR2 = DINC_TORSION_N
                ELSE IF(CS_ELEMENT(IEL2).EQ.'C   ') THEN
                  DINC_CURR2 = DINC_TORSION_C
                ELSE
                  DINC_CURR2 = DINC_TORSION_ALL
                ENDIF
                DINC_CURRENT = DINC_CURR1 + DINC_CURR2
                IVDW_TYPE    = 2
                GOTO 70
              ENDIF
            ENDIF
          ENDDO
        ENDIF
 70     CONTINUE
C
C---Pair is not in the list of restraints or atoms are related by torsion
C---angles with period 3. Calculate ideal value.
C
C---Case 1. They can form hydrogen bond
        RAD1      = VDW_RAD(IV1)
        RAD2      = VDW_RAD(IV2)
        DVDW_IDEAL= RAD1 + RAD2 + DINC_CURRENT
cd        VDW_SDI   = 0.3
        DVDW_MAX  = DVDW_IDEAL
        IF(IVDW_TYPE.EQ.1) 
     &  CALL HBOND_CHECK(IV1,IV2,IVDW_TYPE,DVDW_IDEAL,DVDW_MAX,VDW_SDI)
        IF(IVDW_TYPE.EQ.1) 
     &  CALL IBOND_CHECK(IV1,IV2,IVDW_TYPE,DVDW_IDEAL,DVDW_MAX,VDW_SDI)
        IF(IVDW_TYPE.EQ.1) 
     &  CALL MBOND_CHECK(IV1,IV2,IVDW_TYPE,DIST_CUR,DVDW_IDEAL,
     &        DVDW_MAX,VDW_SDI)
        IF(IVDW_TYPE.EQ.1) 
     &  CALL DUMMY_CHECK(IV1,IV2,IVDW_TYPE,DIST_CUR,DVDW_IDEAL,
     &        DVDW_MAX,VDW_SDI)
C
c---Case 3. They are simple vdw
cd        DVW_IDEAL = DVDW_IDEAL + DINC_CURRENT
cd        DVDW_MAX  = DVDW_IDEAL
        NVDW1   = NVDW1 + 1
        IF(DIST_CUR.GT.DVDW_MAX) GOTO 999
          IF(NVDW_SYMM(1,IVDW).GT.1.OR.
     &       NVDW_SYMM(2,IVDW).NE.0.OR.
     &       NVDW_SYMM(3,IVDW).NE.0.OR.
     &       NVDW_SYMM(4,IVDW).NE.0) IVDW_TYPE = IVDW_TYPE+4
          WRITE(ISCRV)NVDW_TARGET(IVDW),NVDW_OBJECT(IVDW),DVDW_IDEAL,
     &          VDW_SDI,(NVDW_SYMM(I,IVDW),I=1,4),IVDW_TYPE
 999    CONTINUE
      ENDDO
      CLOSE(UNIT=ISCRV)
      ISCRV = 0
      RETURN
      END
C
      SUBROUTINE HBOND_CHECK(IV1,IV2,IVDW_TYPE,DVDW_IDEAL,DVDW_MAX,
     &                   VDW_SDI)
C
c---Checks if two atoms can make hydrogen bonds. At the moment simple check
C---is perforfmed. If one of atoms is acceptor and another one is donor
C---then they can make hydrogen bonds. This subroutine should be improved
C---considerably.
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'weights.fh'
C
      INTEGER IV1,IV2,IVDW_TYPE
      REAL DVDW_IDEAL,DVDW_MAX,VDW_SDI
C
      IF(HB_TYPE(IV1).EQ.'A') THEN
C
C---Check second atom should be either donor or donor/acceptor or hydrogen
C---from hyrogen bond capable atom
        IF(HB_TYPE(IV2).EQ.'D'.OR.HB_TYPE(IV2).EQ.'B') THEN
C
C---These two atoms can make hydrogen bond
          DVDW_IDEAL = VDW_RAD(IV1)+VDW_RAD(IV2)+
     &                   HBOND_DINC_AD
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE  = 3
          VDW_SDI    = VDW_SDI_HBOND
        ELSEIF(HB_TYPE(IV2).EQ.'H') THEN
C
c---Second atom is hydrogen from hydrogen bond capable atom
           DVDW_IDEAL = VDW_RAD(IV1) + HBOND_DINC_AH
           DVDW_MAX   = DVDW_IDEAL
           IVDW_TYPE  = 3
           VDW_SDI    = VDW_SDI_HBOND
        ENDIF
      ENDIF
      IF(HB_TYPE(IV1).EQ.'D')THEN
C
c---First atom is donor.Second atom should be acceptor only
        IF(HB_TYPE(IV2).EQ.'A'.OR.HB_TYPE(IV2).EQ.'B') THEN
          DVDW_IDEAL = VDW_RAD(IV1)+VDW_RAD(IV2)+
     &                    HBOND_DINC_AD 
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE  = 3
          VDW_SDI    = VDW_SDI_HBOND      
        ENDIF
      ENDIF
C
      IF(HB_TYPE(IV1).EQ.'B') THEN
C
C---Firts atom can be donor or acceptor
        IF(HB_TYPE(IV2).EQ.'A'.OR.HB_TYPE(IV2).EQ.'D'.OR.
     &     HB_TYPE(IV2).EQ.'B') THEN
C
          DVDW_IDEAL = VDW_RAD(IV1)+VDW_RAD(IV2)+
     &                   HBOND_DINC_AD
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE = 3
          VDW_SDI    = VDW_SDI_HBOND
        ELSEIF(HB_TYPE(IV2).EQ.'H') THEN
C
          DVDW_IDEAL = VDW_RAD(IV1)+HBOND_DINC_AH
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE  = 3 
          VDW_SDI    = VDW_SDI_HBOND
        ENDIF
      ENDIF
C
      IF(HB_TYPE(IV1).EQ.'H') THEN
C
c---First atom is hydrogen from hydrogen bond capable atom
        IF(HB_TYPE(IV2).EQ.'A'.OR.HB_TYPE(IV2).EQ.'B') THEN
          DVDW_IDEAL = VDW_RAD(IV2) + HBOND_DINC_AH
          DVDW_MAX   = DVDW_IDEAL
          IVDW_TYPE  = 3
          VDW_SDI    = VDW_SDI_HBOND
        ENDIF
      ENDIF
C
      RETURN
      END
C
      SUBROUTINE IBOND_CHECK(IV1,IV2,IVDW_TYPE,DVDW_IDEAL,
     &               DVDW_MAX,VDW_SDI)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'weights.fh'
C
      INTEGER IV1,IV2,IVDW_TYPE
      REAL DVDW_IDEAL,DVDW_MAX,VDW_SDI
C
C----No idea what to do
      RETURN
      END
C
      SUBROUTINE  MBOND_CHECK(IV1,IV2,IVDW_TYPE,DST,DVDW_IDEAL,DVDW_MAX,
     &             VDW_SDI)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'weights.fh'
C
      INTEGER MAX_METAL
      PARAMETER (MAX_METAL = 83)
      CHARACTER METAL(MAX_METAL)*2

      INTEGER IV1,IV2,IVDW_TYPE
      REAL DVDW_IDEAL,DVDW_MAX,VDW_SDI,DST
C
      REAL RAD1,RAD2
      INTEGER IM
      LOGICAL METAL_FLAG

      DATA METAL/'AG','AL','AU','CA','CD','CE','CO','CR','CS','CU','EU',
     &           'FE','HG','HO','K ','LA','LI','MG','MN','MO','NA','PT',
     &           'TA','ZN','BE','SC','TI','V ','NI','RB','SR','Y ','ZR',
     &           'NB','TC','RU','RH','PD','IN','SN','TE','I ','BA','LA',
     &           'CE','PR','ND','PM','SM','GD','TB','DY','ER','TM','YB',
     &           'LU','HF','W ','RE','OS','IR','TL','PB','BI','PO','AT',
     &           'FR','RA','AC','TH','PA','U ','NP','PU','AM','CM','BK',
     &           'CF','ES','FM','MD','NO','LR'/
c---If one of atoms is metal and second one is capable of coordinating this
C---metal. At the moment no idea how to deal with it.
      METAL_FLAG = .FALSE.
      DO    IM = 1,MAX_METAL
        IF(CS_ELEMENT(ID_SF(IV1))(1:2).EQ.METAL(IM)) THEN
          METAL_FLAG = .TRUE.
          GOTO 100
        ENDIF
      ENDDO
      DO   IM=1,MAX_METAL
        IF(CS_ELEMENT(ID_SF(IV2))(1:2).EQ.METAL(IM)) THEN
          METAL_FLAG = .TRUE.
          GOTO 100
        ENDIF
      ENDDO
      RETURN
 100  CONTINUE
C
C---One of the atoms is metal. Use ionic radii of atoms. 
C---Consider putting restraints on them

      IF(ION_RAD(IV1).GT.0.0.AND.ION_RAD(IV2).GT.0.0) THEN
        RAD1 = ION_RAD(IV1)
        RAD2 = ION_RAD(IV2)
        DVDW_IDEAL = RAD1 + RAD2
        DVDW_MAX   = DVDW_IDEAL
        VDW_SDI    = VDW_SDI_METAL 
        IVDW_TYPE  = 4
      ENDIF
      RETURN
      END
C
      SUBROUTINE  DUMMY_CHECK(IV1,IV2,IVDW_TYPE,DST,DVDW_IDEAL,DVDW_MAX,
     &             VDW_SDI)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'weights.fh'
C
      INTEGER IV1,IV2,IVDW_TYPE
      REAL DVDW_IDEAL,DVDW_MAX,VDW_SDI,DST
C
      REAL RAD1,RAD2
C

      RAD1 = VDW_RAD(IV1)
      RAD2 = VDW_RAD(IV2)
C
      IF((ATM_NAME(IV1).EQ.'DUM'.AND.ATM_NAME(IV2).NE.'DUM').OR.
     &   (ATM_NAME(IV1).NE.'DUM'.AND.ATM_NAME(IV2).EQ.'DUM')) THEN
        DVDW_IDEAL = AMAX1(0.7,RAD1 + RAD2 + DINC_DUMMY)
        DVDW_MAX   = DVDW_IDEAL
        VDW_SDI    = VDW_SDI_DUMMY
      ENDIF
      IF(ATM_NAME(IV1).EQ.'DUM'.AND.ATM_NAME(IV2).EQ.'DUM') THEN
       DVDW_IDEAL = RAD1 + RAD2
       DVDW_MAX   = DVDW_IDEAL
       VDW_SDI    = VDW_SDI_DUMMY
      ENDIF

      RETURN
      END
C
      SUBROUTINE ADD_ANGLES_TORSIONS(MAXDIST,NDIST,NDIST1,NDIST2,
     &               MAXATOM,N_ATOM,
     &               NREST_PER_ATOM,REST_PER_ATOM,N_TARGET,N_OBJECT)
      IMPLICIT NONE
C
C----This routine analyses list of bonds and adds angles and torsions to
C----the list. Torsion angles are added with negative bond number.
      INTEGER MAXDIST,NDIST,MAXATOM,N_ATOM
      INTEGER NREST_PER_ATOM(*),REST_PER_ATOM(N_ATOM,*),N_TARGET(*),
     &        N_OBJECT(*)
C
      INTEGER IA,IREST1,IREST2,IREST3,NDIST1,NDIST2,IR1,IR2,IR3,
     &        IR11,IR22,IR33,IR3T,IR3O,IR1B,IR2B,MAX_REST
C
      NDIST1 = NDIST
      DO   IA=1,N_ATOM
        IF(NREST_PER_ATOM(IA).GT.1) THEN
C
c---this atom can be corner for an angle
          IREST1 = NREST_PER_ATOM(IA)
          DO    IR1 = 1,IREST1-1
             IR11 = REST_PER_ATOM(IA,IR1)
             IF(IR11.LE.0) CALL ERRWRT(1,' 1 ')
             IF(IR11.LE.NDIST) THEN
C
C---This pair corresbonds to bond
               IR1B = N_TARGET(IR11)
               IF(IR1B.EQ.IA) IR1B = N_OBJECT(IR11)
               DO   IR2 = IR1+1,IREST1
                 IR22 = REST_PER_ATOM(IA,IR2)
                 IF(IR22.LE.NDIST) THEN
C
C---this pair corresbonds to bond
                   IR2B = N_TARGET(IR22)
                   IF(IR2B.EQ.IA) IR2B = N_OBJECT(IR22)
C
C----Check to avoid repeat.
                   IREST2 = NREST_PER_ATOM(IR2B)
                   IF(IREST2.GT.1) THEN
                     DO   IR3=1,IREST2
                        IR33 = REST_PER_ATOM(IR2B,IR3)
                        IR3T = N_TARGET(IR33)
                        IR3O = N_OBJECT(IR33)
                        IF((IR3T.EQ.IR2B.AND.IR3O.EQ.IR1B).OR.
     &                     (IR3T.EQ.IR1B.AND.IR3O.EQ.IR2B)) GOTO 10
C
C----this pair is in the list
                     ENDDO
                   ENDIF
C
c---Pair is not in the list
                   CALL ADD_PAIRS(MAXDIST,NDIST1,MAXATOM,N_ATOM,
     &                    N_TARGET,N_OBJECT,NREST_PER_ATOM,
     &                    REST_PER_ATOM,IR1B,IR2B)
                ENDIF
 10             CONTINUE
              ENDDO
            ENDIF
          ENDDO
        ENDIF
      ENDDO
C
c---Now check for torsions. 
      NDIST2 = NDIST1
cd      GOTO 900
      DO   IA=1,N_ATOM
        IF(NREST_PER_ATOM(IA).GT.0) THEN
C
c---this atom can be corner for an angle
          IREST1 = NREST_PER_ATOM(IA)
          DO    IR1 = 1,IREST1
            IR11 = REST_PER_ATOM(IA,IR1)
            IF(IR11.LE.NDIST) THEN
C
C---It is  a bond
              IR1B = N_TARGET(IR11)
              IF(IR1B.EQ.IA) IR1B = N_OBJECT(IR11)
              IREST2 = NREST_PER_ATOM(IR1B)
              IF(IREST2.GT.1) THEN
                DO    IR2 = 1,IREST2
                  IR22 = REST_PER_ATOM(IR1B,IR2)
                  IF(IR22.GT.NDIST.AND.IR22.LE.NDIST1) THEN
C
C---It is an angle
                    IR2B = N_TARGET(IR22)
                    IF(IR2B.EQ.IR1B) IR2B = N_OBJECT(IR22)
                    IREST3 = NREST_PER_ATOM(IR2B)
                    DO   IR3=1,IREST3
                      IR33 = REST_PER_ATOM(IR2B,IR3)
                      IR3T = N_TARGET(IR33)
                      IR3O = N_OBJECT(IR33)
                      IF(IR3T.EQ.IA.OR.IR3O.EQ.IA) GOTO 20
                    ENDDO
                    CALL ADD_PAIRS(MAXDIST,NDIST2,MAXATOM,N_ATOM,
     &                    N_TARGET,N_OBJECT,NREST_PER_ATOM,
     &                    REST_PER_ATOM,IA,IR2B)
                  ENDIF
 20               CONTINUE
                ENDDO
              ENDIF
            ENDIF
          ENDDO
        ENDIF
      ENDDO

C
 900  CONTINUE
      MAX_REST = -10000
      DO   IA=1,N_ATOM
        IF(MAX_REST.LT.NREST_PER_ATOM(IA))MAX_REST = NREST_PER_ATOM(IA)
      ENDDO

      RETURN
      END
C
      SUBROUTINE ADD_PAIRS(MAXDIST,NDIST1,MAXATOM,N_ATOM,
     &                     N_TARGET,N_OBJECT,NREST_PER_ATOM,
     &                     REST_PER_ATOM,IA1,IA2)
      IMPLICIT NONE
C
c----This subroutine adds pair of atoms to the list of defined pairs.
C----It does not check existence of pairs in the list. It should be
C----checked before calling this routine
      INTEGER MAXDIST,NDIST1,MAXATOM,N_ATOM,IA1,IA2
      INTEGER NREST_PER_ATOM(*),REST_PER_ATOM(N_ATOM,*),N_TARGET(*),
     &        N_OBJECT(*)


      NDIST1 = NDIST1 + 1
      IF(NDIST1.GT.MAXDIST) THEN
        CALL ERRWRT(1,'In find restraints number of pairs exceeds'//
     &       ' maximum allowed restraint pairs')
      ENDIF
      NREST_PER_ATOM(IA1) = NREST_PER_ATOM(IA1) + 1
      NREST_PER_ATOM(IA2) = NREST_PER_ATOM(IA2) + 1
      IF(NREST_PER_ATOM(IA1).GT.80.OR.NREST_PER_ATOM(IA2).GT.80) THEN
         CALL ERRWRT(-1,'Too many restraints per atom')
         CALL ERRWRT(-1,'In add pairs')
         WRITE(*,*)NREST_PER_ATOM(IA1),NREST_PER_ATOM(IA2),IA1,IA2
         CALL ERRWRT(1,'Stopping now')
      ENDIF
      REST_PER_ATOM(IA1,NREST_PER_ATOM(IA1)) = NDIST1
      REST_PER_ATOM(IA2,NREST_PER_ATOM(IA2)) = NDIST1
      N_TARGET(NDIST1) = IA1
      N_OBJECT(NDIST1) = IA2

      RETURN
      END
