      subroutine write_dist_exit
      implicit none
      include 'atom_com.fh'
      include 'pls_incl.fh'
      include 'restr_files.fh'
C
      real workspace(QQDEN)
      common /r_scratch/workspace
C
      character file_out1*512,file_out2*512
      character file_temp*512
C
      integer l,ia,ia1,ia2,i,ityp
      integer iscrb,ibndout,ifail,ll
      integer isym,itx1,itx2,itx3
      real rs_vidl,rs_sdi
      integer iel1,iel2
      real biso1,biso2
      integer lenstr
      external lenstr
C
C---If output distance file has been defined then write distances and exit
C---otherwise return
C
      call set_hkon_flags
      file_temp = ' '
      call ugtenv('DISTANCE',file_temp)
      if(lenstr(file_temp).le.0) return
      l = lenstr(file_temp)
      file_out1 = file_temp(1:l)//'.bnd'
      file_out2 = file_temp(1:l)//'.vdw'
      ibndout = 0
      ifail   = -1
      call ccpdpn(ibndout,file_out1(1:(l+4)),'UNKNOWN','F',ll,ifail)
C
      iscrb = 0
      ifail = -1
      call ccpdpn(iscrb,bond_file(1:lenstr(bond_file)),'UNKNOWN','U',
     &          ll,ifail)
 1    continue
      read(iscrb,end=99) ia1,ia2,rs_vidl,rs_sdi,isym,itx1,itx2,itx3,
     &     ityp
      if(isym.eq.1.and.itx1.eq.0.and.itx2.eq.0.and.itx3.eq.0) then
        iel1 = id_sf(ia1)
        iel2 = id_sf(ia2)
        if(u_aniso(2,ia1).le.0.0) then
          biso1 = u_aniso(1,ia1)
        else
          biso1 = (u_aniso(1,ia1)+u_aniso(2,ia1)+u_aniso(3,ia1))/3.0
        endif
        if(u_aniso(2,ia2).le.0.0) then
          biso2 = u_aniso(1,ia2)
        else
          biso2 = (u_aniso(1,ia2)+u_aniso(2,ia2)+u_aniso(3,ia2))/3.0
        endif
        write(ibndout,'(a4,1x,a4,2(3(1x,F8.3),F10.5))')
     &   cs_element(iel1),cs_element(iel2),(xyz_crd(i,ia1),i=1,3),
     &    biso1,(xyz_crd(i,ia2),i=1,3),biso2
        
      endif
      goto 1
 99   continue
      close(iscrb)
C
c---Now all possible bonds and non-bonds
C
      call write_vdw_list(workspace,QQDEN,file_out2)
      call ccperr(0,'Output bond files have succesfully been written')

      return
      end
C
      subroutine write_vdw_list(workspace,nworkspace,file_out2)
      implicit none
      include 'atom_com.fh'

      character file_out2*(*)
      integer nworkspace
      real workspace(nworkspace)
C
      integer maxvdw,targ_address,obje_address,nsymm_address
      integer nr_per_at_address,rest_per_at_address
      integer nrem_address,nremain_size,n_used_mem
C
      integer lenstr
      external lenstr
C

      maxvdw = 30*n_atom
      targ_address        = 1
      obje_address        = targ_address + maxvdw
      nsymm_address       = obje_address + maxvdw

      nrem_address        = nsymm_address + 4*maxvdw
      nremain_size        = nworkspace - nrem_address -1
      n_used_mem          = nrem_address

      call write_vdw_list1(maxvdw,workspace(targ_address),
     &                                     workspace(obje_address),
     &                                     workspace(nsymm_address),
     &                                     workspace(nrem_address),
     &                                     nremain_size,n_used_mem,
     &                                     file_out2)


      return
      end
C
      subroutine write_vdw_list1(maxvdw,target,
     &                                  object,
     &                                  symmetry,
     &                                  work_remain,
     &                                  nremain_size,n_used_mem,
     &                                  file_out2)
      implicit none
      include 'atom_com.fh'
      include 'weights.fh'

C
      character file_out2*(*)
      integer maxvdw,nremain_size,n_used_mem
      integer target(maxvdw),object(maxvdw)
      integer symmetry(4,n_atom)
      real    work_remain(nremain_size)
C
      real    dist
      integer l
      integer nvdw_l
      integer i,j,k,ia1,ia2,iel1,iel2
      integer iwat
      integer ibndout,ifail,ll

      real biso1,biso2
      integer lenstr
      external lenstr
C
      dvdw_cut_min = 3.0
      call find_contact_list(maxvdw,nvdw_l,
     &                                  target,
     &                                  object,
     &                                  symmetry,
     &                                  work_remain,
     &                                  nremain_size,n_used_mem)
C
      ibndout = 0
      ifail   = -1
      l = lenstr(file_out2)
      call ccpdpn(ibndout,file_out2(1:l),'UNKNOWN','F',ll,ifail)
C
      k    = 0
      iwat = 0
      do   i=1,nvdw_l
        if(symmetry(1,i).eq.1.and.symmetry(2,i).eq.0.and.
     &     symmetry(3,i).eq.0.and.symmetry(4,i).eq.0) then

           ia1 = target(i)
           ia2 = object(i)
           if(res_name_pdb(i_resid(ia1)).ne.'HOH'.and.
     &        res_name_pdb(i_resid(ia2)).ne.'HOH') then
        iel1 = id_sf(ia1)
        iel2 = id_sf(ia2)
        if(u_aniso(2,ia1).le.0.0) then
          biso1 = u_aniso(1,ia1)
        else
          biso1 = (u_aniso(1,ia1)+u_aniso(2,ia1)+u_aniso(3,ia1))/3.0
        endif
        if(u_aniso(2,ia2).le.0.0) then
          biso2 = u_aniso(1,ia2)
        else
          biso2 = (u_aniso(1,ia2)+u_aniso(2,ia2)+u_aniso(3,ia2))/3.0
        endif
        dist = sqrt((xyz_crd(1,ia1)-xyz_crd(1,ia2))**2+
     &              (xyz_crd(2,ia1)-xyz_crd(2,ia2))**2+
     &              (xyz_crd(3,ia1)-xyz_crd(3,ia2))**2)
       if(dist.gt.2.7) then
        write(ibndout,'(a4,1x,a4,2(3(1x,F8.3),F10.5))')
     &   cs_element(iel1),cs_element(iel2),(xyz_crd(j,ia1),j=1,3),
     &    biso1,(xyz_crd(j,ia2),j=1,3),biso2
        else
           iwat = iwat + 1
        endif
        else
          k = k + 1
        endif
        endif
      enddo
      write(*,*)'Number of vdw contacts              = ',nvdw_l
      write(*,*)'Number of symmetry related contacts = ',k
      write(*,*)'Number of water related contacts    =',iwat
      close(ibndout)
C
      return
      end
