      subroutine number_of_defined_bonds(ndefined,l1b_nbond,l1b_type)
      implicit none
      integer l1b_nbond
      integer ndefined
      character(len=*), dimension(:) :: l1b_type
c
      integer ib
c
c---  body
      if(l1b_nbond.le.0) return

      do ib=1,l1b_nbond
         call ccplwc(l1b_type(ib))
         if(l1b_type(ib)(1:4).ne.'sing'.and.
     &        l1b_type(ib)(1:4).ne.'doub'.and.
     &        l1b_type(ib)(1:4).ne.'trip'.and.
     &        l1b_type(ib)(1:4).ne.'delo'.and.
     &        l1b_type(ib)(1:4).ne.'arom'.and.
     &        l1b_type(ib)(1:4).ne.'meta') l1b_type(ib) = '.'
      enddo
      ndefined = 0
      do ib=1,l1b_nbond
         if(l1b_type(ib).ne.'.') ndefined=ndefined+1
      enddo

      return
      end
c
      subroutine define_obvious_bonds(l1b_nbond,l1a_natom,l1a_symb,
     &     l1a_ndist,l1a_ref2bond,l1a_sorted,l1b_type)
      implicit none
c
c---  Define obvious bonds. It can be used before all hydrogens are known
      integer l1b_nbond,l1a_natom
      character(len=*), dimension(:) :: l1a_symb
      character(len=*), dimension(:) :: l1b_type
      integer, dimension(:) :: l1a_ndist
      integer, dimension(:,:) :: l1a_ref2bond
      logical, dimension(:) :: l1a_sorted
c
      integer ia1,ib1,ib
c
c---  body
      if(l1a_natom.le.0.or.l1b_nbond.le.0) return
c
      do ia1=1,l1a_natom
         if(.not.l1a_sorted(ia1)) then
            if(l1a_symb(ia1)(1:2).eq.'H '.or.
     &           l1a_symb(ia1)(1:2).eq.'D '.or.
     &           l1a_symb(ia1)(1:2).eq.'B '.or.
     &           l1a_symb(ia1)(1:2).eq.'F '.or.
     &           l1a_symb(ia1)(1:2).eq.'I '.or.
     &           l1a_symb(ia1)(1:2).eq.'CL'.or.
     &           l1a_symb(ia1)(1:2).eq.'BR') then
               if(l1a_ndist(ia1).gt.0) then
                  do ib1 = 1,l1a_ndist(ia1)
                     ib = l1a_ref2bond(ib1,ia1)
                     l1b_type(ib) = 'single'
                  enddo
               endif
               l1a_sorted(ia1) = .TRUE.
            elseif(l1a_symb(ia1)(1:2).eq.'O ') then
               call sort_out_oxygen(ia1,l1a_natom,l1b_nbond,l1a_ndist,
     &              l1a_ref2bond,l1a_conn,l1a_charg,l1a_symb,l1b_type,
     &              l1b_rtype,l1a_sorted,ierr)
            elseif(l1a_symb(ia1)(1:2).eq.'C ') then
               call sort_out_carbon(ia1,l1a_natom,l1b_nbond,l1a_ndist,
     &              l1a_ref2bond,l1a_conn,l1a_charg,l1a_symb,l1b_type,
     &              l1b_rtype,l1a_sorted,ierr)
            elseif(l1a_symb(ia1)(1:2).eq.'N ') then
               call sort_out_nitrogen(ia1,l1a_natom,l1b_nbond,l1a_ndist,
     &              l1a_ref2bond,l1a_conn,l1a_charg,l1a_symb,l1b_type,
     &              l1b_rtype,l1a_sorted,ierr)
            elseif(l1a_symb(ia1)(1:2).eq.'S ') then
               call sort_out_sulphur(ia1,l1a_natom,l1b_nbond,l1a_ndist,
     &              l1a_ref2bond,l1a_conn,l1a_charg,l1a_symb,l1b_type,
     &              l1b_rtype,l1a_sorted,ierr)
            elseif(l1a_symb(ia1)(1:2).eq.'P ') then
               call sort_out_phosphor(ia1,l1a_natom,l1b_nbond,l1a_ndist,
     &              l1a_ref2bond,l1a_conn,l1a_charg,l1a_symb,l1b_type,
     &              l1b_rtype,l1a_sorted,ierr)
            elseif(l1q_symb(ia1)(1:2).eq.'SE') then
c            call sort_out_selenium
         endif
      enddo
      
      return
      end
c
      subroutine bond_orders_from_elib(l1a_natom,l1b_nbond,l1a_symb,
     &     l1a_chem,l1b_type,l1b_1atm,l1b_2atm,l1b_i1atm,l1b_i2atm,
     &     l1b_val,
     &     leb_nbond,leb_1atm,leb_2atm,
     &     leb_i1atm,leb_i2atm,lea_ename,leb_type,leb_length)
      implicit none
      integer l1a_natom,l1b_nbond
      character(len=*), dimension(:) :: l1a_symb
      character(len=*), dimension(:) :: l1a_chem
      character(len=*), dimension(:) :: l1b_1atm
      character(len=*), dimension(:) :: l1b_2atm
      character(len=*), dimension(:) :: l1b_type
      integer, dimension(:) :: l1b_i1atm
      integer, dimension(:) :: l1b_i2atm
      real, dimension(:) :: l1b_val
c
c---  library values
      integer leb_nbond
      character(len=*), dimension(:) :: leb_1atm
      character(len=*), dimension(:) :: leb_2atm      
      character(len=*), dimension(:) :: leb_type
      character(len=*), dimension(:) :: lea_ename
      integer, dimension(:) :: leb_i1atm
      integer, dimension(:) :: leb_i2atm
      real, dimension(:) :: leb_length
c
      integer ierr
c
c---  locals
      integer ib,ib1,ib2,ia1,ia2,ieb1,ieb2,il1,il2,ilb
      character chem1*2,chem2*2,echem1*2,echem2*2,asymb1*4,asymb2*4
      character bond_order*6,bond_order1*6
      real dist_bond,diff_prev,diff_dist,dist
      
      do ib=1,l1b_nbond
c
c---  Tentative chemical types must be defined before this routine
         if(l1b_type(ib)(1:1).eq.'.') then
            ia1 = l1b_i1atm(ib)
            ia2 = l1b_i2atm(ib)

            chem1 = l1a_chem(ia1)
            chem2 = l1a_chem(ia2)
            bond_order = '.'
            dist = l1b_val(ib)
            diff_prev = 1.e32
            do ilb=1,leb_nbond
               ib1 = leb_i1atm(ilb)
               ib2 = leb_i2atm(ilb)
               echem1 = leb_1atm(ilb)
               echem2 = leb_2atm(ilb)
               if(lea_ename(ib1).eq.'H ') echem1 = 'H '
               if(lea_ename(ib2).eq.'H ') echem2 = 'H '

               if(chem1.eq.echem1.and.chem2.eq.echem2.or.
     &              chem2.eq.echem1.and.chem1.eq.echem2) then
                  if(diff_dist.lt.diff_prev) then
                     diff_prev = diff_dist
                     bond_order = leb_type(ilb)
                  endif
               endif
            enddo
c
c---  Still not defined
            bond_order1 = '.'
            if(bond_order(1:1).eq.'.') then
               do ieb1=1,leb_nbond
                  if(leb_2atm(ieb1)(1:1).eq.'.') then
                     il1 = leb_i1atm(ieb1)
                     if(asymb1(1:2).eq.lea_ename(il1)(1:2)) then
                        bond_order1 = leb_type(ieb1)
                        do ieb2=1,leb_nbond
                           if(leb_2atm(ieb2)(1:1).eq.'.') then
                              if(bond_order1(1:4).eq.
     &                             leb_type(ieb2)(1:4)) then
                                 il2 = leb_i1atm(ieb2)
                                 if(asymb2(1:2).eq.
     &                                lea_ename(il2)(1:2)) then
                                    dist_bond = 
     &                                   (leb_length(ieb1)+
     &                                   leb_length(ieb2))/2.0
                                    diff_dist = abs(dist_bond-dist)
                                    if(diff_dist.lt.diff_prev) then
                                       diff_prev = diff_dist
                                       bond_order = '.'
                                    endif
                                 endif
                              endif
                           endif
                        enddo
                     endif
                  endif
               enddo
            endif
c
c--   Still not defined. Are we dealing with metals
            
c
c---  Still not defined. It is an error
            if(bond_order.eq.'.') then
               ierr= 1
            endif
            l1b_type = bond_order
         endif
      enddo
c
      return
      end
c
      subroutine define_metal_bond_orders
      implicit none

      return
      end
c
      subroutine correct_bond_orders(l1a_natom,l1a_symb,l1a_sorted)
      implicit none
      integer l1a_natom
      logical, dimension(:) :: l1a_sorted
      character, dimension(:) :: l1a_symb
c
      real, allocatable :: l1b_rtype(:)

      integer ia,ia1,ia2,ib,ib1,ib2,ib3
      integer ndeloc,ndeloc1
      real eps_bond,rbond_order,rbond_order1,bcorrect
      logical things_to_do
c
c---  correct bond orders. Hydrogens may not be present
c---  do not deal with obvios cases
      eps_bond = 1.0e-2
      if(1lb_nbond.le.0.or.l1a_natom.le.0) return
      things_to_do = .FALSE.
      do ia=1,l1b_natom
         if(.not.l1a_sorted(ia)) things_to_do=.TRUE.
      enddo
      if(.not.things_to_do) return

      allocate(l1b_rtype(l1b_nbond))
      call atypes_2_numbers(l1a_nbond,l1b_type,l1b_rtype)
c
c---  obvious bonds
      call define_obvious_bonds(l1b_nbond,l1a_natom,l1a_symb,
     &        l1a_ndist,l1a_ref2bond,l1a_sorted,l1b_type)
c
c--Needs to be written. 
      call add_hydrogens
c
c---  
      call atypes_2_numbers(l1a_nbond,l1b_type,l1b_rtype)
c
      call define_sorted_atoms(l1a_natom,l1a_ndist,l1a_ref2bond,
     &     l1a_charg,l1a_valency,l1a_sorted,l1b_nbond,l1b_rtype)
      call define_obvious_bonds(l1b_nbond,l1a_natom,l1a_symb,
     &        l1a_ndist,l1a_ref2bond,l1a_sorted,l1b_type)
      call define_sorted_atoms(l1a_natom,l1a_ndist,l1a_ref2bond,
     &     l1a_charg,l1a_valency,l1a_sorted,l1b_nbond,l1b_rtype)
c
c---  hydrogens sould be added

c
c---  detailed corrections
      things_to_do = .FALSE.
      nsorted = 0
      do ia1=1,l1a_natom
            if(l1a_sorted(ia1)) nsorted = nsorted + 1
         enddo
      enddo
      if(nsorted.lt.l1a_natom) things_to_do=.TRUE.
      do while(things_to_do)
         call define_obvious_bonds(l1b_nbond,l1a_natom,l1a_symb,
     &        l1a_ndist,l1a_ref2bond,l1a_sorted,l1b_type)

         call define_sorted_atoms(l1a_natom,l1a_ndist,l1a_ref2bond,
     &        l1a_charg,l1a_valency,l1a_sorted,l1b_nbond,l1b_rtype)
         nsorted = 0
         do ia1=1,l1a_natom
            if(l1a_sorted(ia1)) nsorted = nsorted + 1
         enddo
         if(nsorted.le.nsorted_previous) things_to_do = .TRUE.
      enddo
      deallocate(l1b_rtype)
      enddo
      return
      end
c
      subroutine atypes_2_numbers(l1b_nbond,l1b_type,l1b_rtype)
      implicit none
      integer l1a_nbond
      character(len=*), dimension(:) :: l1b_type
      real, dimension(:) :: l1b_rtype
c
      integer ib
c
c
      do ib=1,l1b_nbond
         if(l1b_type(ib).eq.'sing') then
            l1b_rtype(ib) = 1.0
         elseif(l1b_type(ib)(1:4).eq.'delo'.or.
     &           l1b_type(ib)(1:4).eq.'arom') hen
            l1b_rtype(ib) = 1.5
         elseif(l1b_type(ib)(1:4).eq.'doub') then
            l1b_rtype(ib) = 2.0
         elseif(l1b_tyype(ib)(1:4).eq.'trip') then
            l1b_rtype(ib) = 3.0
         endif
      enddo
c
      return
      end
c
      subroutine sort_out_oxygens(ia1,l1a_natom,l1b_nbond,l1a_ndist,
     &     l1a_ref2bond,l1a_conn,l1a_charg,l1a_symb,l1b_type,
     &     l1b_rtype,l1a_sorted,ierr)
      implicit none
      integer ia1
      integer l1a_natom
      integer, dimension(:) :: l1a_ndist
      integer, dimension(:,:) :: l1a_ref2bond
      integer, dimension(:,:) :: l1a_conn
      logical, dimension(:) :: l1a_sorted
      character(len=*), dimension(:) :: l1a_symb
      real, dimension(:) :: l1a_charg

      integer l1b_nbond
      real, dimension(:) :: l1b_rtype
      character(len=*), dimension(:) :: l1b_type

      integer ierr
c
c---  locals
      integer ia2,ia3,ib,ib1,ib2,ib3
      integer noxsingle
c
      if(l1a_ndist(ia1).gt.2) then
         write(*,*)'Problems. Too many bonds on oxygen'
         ierr = 1
         return
      endif
      if(l1a_sorted(ia1))return

      if(l1a_ndist(ia1).eq.2) then
         do ib1=1,l1a_ndist(ia1)
            ib = l1a_ref2bond(ib1,ia1)
            l1b_type(ib) = 'single'
            l1b_rtype(ib) = 1.0
         enddo
      elseif(l1a_ndist(ia1).eq.1) then
         ib = l1a_ref2bond(1,ia1)
         if(l1b_rtype(ib).eq.2.0.or.
     &        l1b_rtype(ib).eq.1.5) then
            ia2 = l1a_conn(1,ia1)
            if(l1a_symb(ia2)(1:2).eq.'C ') then
               if(l1a_ndist(ia2).eq.3) then
                  noxsingle = 0
                  do ib2=1,l1a_ndist(ia2)
                     ia3 = l1a_conn(ib2,ia2)
                     if(l1a_symb(ia3)(1:2).eq.'O ') then
                        if(l1a_ndist(ia3).eq.1) then
                           noxsingle = noxsingle + 1
                        endif
                     endif
                  enddo
                  if(noxsingle.eq.2) then
                     do ib2=1,l1a_ndist(ia2)
                        ib3 = l1a_ref2bond(ia3,ia2)
                        ia3 = l1a_conn(ib2,ia2)
                        if(l1a_symb(ia3)(1:2).eq.'O ') then
                           l1b_type(ib3) = 'deloc'
                           l1b_rtype(ib3) = 1.5
                           l1a_charg(ia3) = -0.5
                        endif
                     enddo
                  endif
               elseif(l1a_ndist(ia2).eq.4) then
                  l1b_type(ib)='single'
                  l1b_rtype(ib) = 2.0
               elseif(l1a_ndist(ia2).eq.2) then
                  l1b_type(ib) = 'double'
                  l1b_rtype(ib) = 2.0
               elseif(l1a_ndist(ia2).eq.1) then
                  l1b_type(ib) = 'double'
                  l1b_rtype(ib) = 2.0
               endif
            elseif(l1a_symb(ia2)(1:2).eq.'S ') then
               if(l1a_ndist(ia2).eq.1) then
                  l1b_type(ib) = 'double'
                  l1b_rtype(ib) = 2.0
               elseif(l1a_ndist(ia2).eq.2) then
c
c--   SO2 cases should not be considered?
               elseif(l1a_ndist(ia2).eq.3) then
c
c--   Sum of bond orders should be 4
               elseif(l1a_ndist(ia2).eq.4) then
                  noxsingle = 0
                  do ib2=1,l1a_ndist(ia2)
                     ia3=l1a_conn(ib2,ia2)
                     if(l1a_symb(ia3)(1:2).eq.'O ') then
                        if(l1a_ndist(ia3).eq.1) then
                           noxsingle =noxsingle + 1
                        endif
                     endif
                  enddo
c     
c--   Do we need SO4?
                  if(noxsingle.eq.3) then
                     do ib2=1,l1a_ndist(ia2)
                        ia3 = l1a_conn(ib2,ia2)
                        ib3 = l1a_ref2bond(ib2,ia2)
                        if(l1a_symb(ia3)(1:2).eq.'O ') then
                           if(l1a_ndist(ia3).eq.1) then
                              l1b_type(ib3) = 'deloc'
                              l1b_rtype(ib3) = 1.5
                              l1a_charg(ia3) = -0.33
                           endif
                        endif
                     enddo
                  elseif(noxsingle.le.2) then
                     do ib2=1,l1a_ndist(ia2)
                        ia3 = l1a_conn(ib2,ia2)
                        ib3 = l1a_ref2bond(ib2,ia2)
                        if(l1a_symb(ia3)(1:2).eq.'O ') then
                           if(l1a_ndist(ia3).eq.1) then
                              l1b_type(ib3) = 'double'
                              l1b_rtype(ib3) = 2.0
                              l1a_charg(ia3) = 0.0
                           endif
                        endif
                     enddo
                  endif
               endif 
            elseif(l1a_symb(ia2)(1:2).eq.'P ') then
               if(l1a_ndist(ia2).eq.1) then
                  l1b_type(ib) = 'double'
                  l1b_rtype(ib) = 2.0
               elseif(l1a_ndist(ia2).eq.2) then
c     
c--   PO2 cases should not be considered?
               elseif(l1a_ndist(ia2).eq.3) then
c     
c--   Sum of bond orders should be 5
               elseif(l1a_ndist(ia2).eq.4) then
                  noxsingle = 0
                  do ib2=1,l1a_ndist(ia2)
                     ia3=l1a_conn(ib2,ia2)
                     if(l1a_symb(ia3)(1:2).eq.'O ') then
                        if(l1a_ndist(ia3).eq.1) then
                           noxsingle =noxsingle + 1
                        endif
                     endif
                  enddo
c     
c--   Do we need PO4?
                  if(noxsingle.eq.3) then
                     do ib2=1,l1a_ndist(ia2)
                        ia3 = l1a_conn(ib2,ia2)
                        ib3 = l1a_ref2bond(ib2,ia2)
                        if(l1a_symb(ia3)(1:2).eq.'O ') then
                           if(l1a_ndist(ia3).eq.1) then
                              l1b_type(ib3) = 'deloc'
                              l1b_rtype(ib3) = 1.5
                              l1a_charg(ia3) = -0.66
                           endif
                        endif
                     enddo
                  elseif(noxsingle.eq.2) then
                     do ib2=1,l1a_ndist(ia2)
                        ia3 = l1a_conn(ib2,ia2)
                        ib3 = l1a_ref2bond(ib2,ia2)
                        if(l1a_symb(ia3)(1:2).eq.'O ') then
                           if(l1a_ndist(ia3).eq.1) then
                              l1b_type(ib3) = 'deloc'
                              l1b_rtype(ib3) = 1.5
                              l1a_charg(ia3) = -0.5
                           endif
                        endif
                     enddo
                  elseif(noxsingle.eq.1) then
                     do ib2=1,l1a_ndist(ia2)
                        ia3 = l1a_conn(ib2,ia2)
                        ib3 = l1a_ref2bond(ib2,ia2)
                        if(l1a_symb(ia3)(1:2).eq.'O ') then
                           if(l1a_ndist(ia3).eq.1) then
                              l1b_type(ib3) = 'double'
                              l1b_rtype(ib3) = 2.0
                              l1a_charg(ia3) = 0.0
                           endif
                        endif
                     enddo
                  endif
               endif 
            elseif(l1a_symb(ia2)(1:2).eq.'N ') then
               if(l1a_ndist(ia2).eq.3) then
                  noxsingle = 0
                  do ib2=1,l1a_ndist(ia2)
                     ia3=l1a_conn(ib2,ia2)
                     if(l1a_symb(ia3)(1:2).eq.'O ') then
                        if(l1a_ndist(ia3).eq.1) then
                           noxsingle =noxsingle + 1
                        endif
                     endif
                  enddo
                  if(noxsingle.eq.2) then
                     do ib2=1,l1a_ndist(ia2)
                        ia3 = l1a_conn(ib2,ia2)
                        ib3 = l1a_ref2bond(ib2,ia2)
                        if(l1a_symb(ia3)(1:2).eq.'O ') then
                           if(l1a_ndist(ia3).eq.1) then
                              l1b_type(ib3) = 'deloc'
                              l1b_rtype(ib3) = 1.5
                              l1a_charg(ia3) = -0.5
                              l1a_charg(ia2) = 1.0
                           endif
                        endif
                     enddo                                 
                  endif
               endif
            endif
         endif
      endif

         
      return
      end
c
      subroutine sort_out_nitrogens(ia1,l1a_natom,l1b_nbond,l1a_ndist,
     &     l1a_ref2bond,l1a_conn,l1a_charg,l1a_symb,l1b_type,
     &     l1b_rtype,l1a_sorted,ierr)
      implicit none
      integer ia1
      integer l1a_natom
      integer, dimension(:) :: l1a_ndist
      integer, dimension(:,:) :: l1a_ref2bond
      integer, dimension(:,:) :: l1a_conn
      logical, dimension(:) :: l1a_sorted
      character(len=*), dimension(:) :: l1a_symb
      real, dimension(:) :: l1a_charg

      integer l1b_nbond
      real, dimension(:) :: l1b_rtype
      character(len=*), dimension(:) :: l1b_type
      integer ierr
c
c---  locals
      integer ib,ib1,ia2,ia3
      integer nsingle,ndeloc,ndouble,ntriple
c
      if(l1a_sorted(ia1)) return
      if(l1a_ndist(ia1).gt.4) then

      endif
c
      if(l1a_symb(ia1)(1:2).eq.'N ') then
         if(l1a_ndist(ia1).eq.1) then
c     
c---  Protonated cases. It is a problematic case?
            ib=l1a_ref2bond(1,ia1)
            ia2 = l1a_conn(1,ia1)
            if(l1a_symb(ia2)(1:2).eq.'C '.and.
     &           l1b_rtype(ib).eq.1.0) then
               l1a_charg(ia1) = 1.0
            endif
            if(l1b_rtype(ib).gt.1.1.and.l1a_charg(ia1).le.0.4) then
c
c--Arg NC(N)N case
               ib = l1a_ref2bond(1,ia1)
               ia2 = l1a_conn(1,ia1)
               if(l1a_symb(ia2)(1:2).eq.'C ') then
                  if(l1a_ndist(ia2).eq.3) then
                     do ib2=1,l1a_ndist(ia2)
                        ib3 = l1a_ref2bond(ib2,ia2)
                        ia3 = l1a_conn(ib2,ia2)
                        if(l1a_symb(ia3)(1:2).eq.'N '.and.
     &                       l1a_charg(ia3).le.0.4.and.
     &                       l1a_ndist(ia3).eq.1) then
                           l1b_type(ib) = 'deloc'
                           l1b_rtype(ib) = 1.5
                           l1b_type(ib3) = 'deloc'
                           l1b_rtype(ib3) = 1.5
                           l1a_charg(ia1) = 0.5
                           l1a_charg(ia3) = 0.5
                        endif
                     enddo
                  endif
               endif

            endif
         elseif(l1a_ndist(ia1).eq.2) then
            
         elseif(l1a_ndist(ia1).eq.3) then
            if(l1a_charg(ia1).le.0.4) then
               do ib1=1,l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  l1b_type(ib) = 'single'
               enddo
               l1a_charg(ia1) = 0.0
               l1a_sorted(ia1) = .TRUE.
c
c---case ARG's NC(N)N positively charged.
               nhydr = 0
               ncarb = 0
               do ib1=1,l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  ia2 = l1a_conn(ib1,ia1)
                  if(l1a_symb(ia2)(1:2).eq.'H ') then
                     nhydr = nhydr + 1
                  elseif(l1a_symb(ia2)(1:2).eq.'C ') then
                     ncarb = ncarb + 1
                     bond_order = l1b_rtype(ib)
                  endif
               enddo
               if(nhydr.eq.2.and.ncarb.eq.1.and.
     &              bond_order.gt.1.1) then
                  do ib1=1,l1a_ndist(ia1)
                     ib = l1b_ref2bond(ib1,ia1)
                     ia2 = l1a_conn(ib1,ia1)
                     if(l1a_symb(ia2).eq.'C ') then
                        if(l1a_ndist(ia2).eq.3) then
                           do ib2=1,l1a_ndist(ia2)
                              ib3 = l1a_ref2bond(ib2,ia2)
                              ia3 = l1a_conn(ib2,ia2)
                              if(l1a_symb(ia3)(1:2).eq.'N ') then
                                 if(l1a_ndist(ia3).eq.3) then
                                    do ia4=1,l1a_ndist(ia3)
                                       ia5=l1a_conn(ia4,ia3)
                                       if(l1a_symb(ia5)(1:2).eq.'H ') 
     &                                              then
                                          nhydr1 = nhydr1+1
                                       endif
                                    enddo
                                    if(nhydr1.eq.2) then
                                       l1b_type(ib) = 'deloc'
                                       l1b_type(ib3) = 'deloc'
                                       l1b_rtype(ib) = 1.5
                                       l1b_rtype(ib3) = 1.5
                                       l1a_charg(ia1) = 0.5
                                       l1a_charg(ia3) = 0.5
                                    endif
                                 endif
                              endif
                           enddo
                        endif
                     endif
                  enddo
               endif

            elseif(l1a_charg(ia1).gt.0.6) then
               l1a_charg(ia1) = 1.0
c
c--Case with carbon three bonds?
c
c---If two singles and one deloc then promote it to double
               nsingle = 0
               ndeloc = 0
               ndouble = 0
               do ib1=1,l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  if(l1b_rtype(ib).eq.1.0) then
                     nsingle = nsingle + 1
                  elseif(l1b_rtype(ib).eq.1.5) then
                     ndeloc = ndeloc + 1
                  elseif(l1b_rtype(ib).eq.2) then
                     ndouble = ndouble + 1
                  endif
               enddo
c     
c--   two singles and one deloc. promote to double
               if(nsingle.eq.2.and.ndeloc.eq.1) then
                  do ib1=1,l1a_ndist(ia1)
                     ib = l1a_ref2bond(ib1,ia1)
                     if(l1b_rtype(ia1).eq.1.5) then
                        l1b_type(ia1) = 'double'
                        l1b_rtype(ia1) = 2.0
                     endif
                  enddo
c     
c---  one single two doubles. Demote them to deloc
               elseif(nsingle.eq.1.and.ndouble.eq.2) then
                  do ib1=1,l1a_ndist(ia1)
                     ib = l1a_ref2bond(ib1,ia1)
                     if(l1b_rtype(ib1).eq.2.0) then
                        l1b_type(ib) = 'deloc'
                        l1b_rtype(ib) = 1.5
                     endif
                  enddo
               endif
            endif
         elseif(l1a_ndist(ia1).eq.4) then
            do ib1=1,l1a_ndist(ia1)
               ib=l1a_ref2bond(ib1,ia1)
               l1b_type(ib) = 'single'
            enddo
            l1a_charg(ia1) = 1.0
            l1a_sorted(ia1) = .TRUE.
         endif
      endif
      
      return
      end
c
      subroutine sort_out_carbons(ia1,l1a_natom,l1b_nbond,l1a_ndist,
     &     l1a_ref2bond,l1a_conn,l1a_charg,l1a_symb,l1b_type,
     &     l1b_rtype,l1a_sorted,ierr)
      implicit none
      integer ia1
      integer l1a_natom
      integer, dimension(:) :: l1a_ndist
      integer, dimension(:,:) :: l1a_ref2bond
      integer, dimension(:,:) :: l1a_conn
      logical, dimension(:) :: l1a_sorted
      character(len=*), dimension(:) :: l1a_symb
      real, dimension(:) :: l1a_charg

      integer l1b_nbond
      real, dimension(:) :: l1b_rtype
      character(len=*), dimension(:) :: l1b_type

      integer ierr
c
c---  locals
      integer ib,ib1,ia2,ia3
      integer nsingle,ndeloc,ndouble,ntriple
c
      if(l1a_sorted(ia1)) return
      if(l1a_ndist(ia1).gt.4) then
         write(*,*)'too man bonds on carbons'
         ierr = 1
         return
      endif
c
      if(l1a_symb(ia1)(1:2).eq.'C ') then
c
c--Case with four bonds. Sorted before.
         if(l1a_ndist(ia1).eq.4) then
            do ib=1,l1a_ndist(ia1)
               ib1 = l1a_ref2bond(ib,ia1)
               l1b_type(ib1) = 'single'
               l1b_rtype(ib1) = 1.0
            enddo
         elseif(l1a_ndist(ia1).eq.3) then
c
c---If two singles and one deloc then promote it to double
c
c---CO3 should also be sorted out
            nsingle = 0
            ndeloc = 0
            ndouble = 0
            do ib1=1,l1a_ndist(ia1)
               ib = l1a_ref2bond(ib1,ia1)
               if(l1b_rtype(ib).eq.1.0) then
                  nsingle = nsingle + 1
               elseif(l1b_rtype(ib).eq.1.5) then
                  ndeloc = ndeloc + 1
               elseif(l1b_rtype(ib).eq.2) then
                  ndouble = ndouble + 1
               endif
            enddo
c     
c--   two singles and one deloc. promote to double
            if(nsingle.eq.2.and.ndeloc.eq.1) then
               do ib1=1,l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  if(l1b_rtype(ia1).eq.1.5) then
                     l1b_type(ia1) = 'double'
                     l1b_rtype(ia1) = 2.0
                  endif
               enddo
c     
c---  one single two doubles. Demote them to deloc
            elseif(nsingle.eq.1.and.ndouble.eq.2) then
               do ib1=1,l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  if(l1b_rtype(ib1).eq.2.0) then
                     l1b_type(ib) = 'deloc'
                     l1b_rtype(ib) = 1.5
                  endif
               enddo
c     
c---  three doubles. A problem. No idea how to sort this out
            elseif(ndouble.eq.3) then
               do ib1=1,l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  l1b_type(ib) = 'deloc'
                  l1b_rtype(ib) = 1.5
               enddo
            endif
         elseif(l1a_ndist(ia1).eq.2) then
            do ib1=1,l1a_ndist(ia1)
               ib = l1a_ref2bond(ib1,ia1)
               if(l1b_rtype(ib).eq.3.0) then
                  ntriple = ntriple + 1
               elseif(l1b_rtype(ib).eq.2.0) then
                  ndouble = ndouble + 1
               elseif(l1b_rtype(ib).eq.1.0) then
                  nsingle=nsingle+1
               elseif(l1b_rtype(ib).eq.1.5) then
                  ndeloc=ndeloc+1
               endif
            enddo
            if(ntriple.eq.2) then
c---  Problem
            elseif(ntriple.eq.1) then
c
c---These type of cases should be chacked. Angles and so on
               do ib1=1,l1a_ndist(ia1)
                  ib=l1a_ref2bond(ib1,ia1)
                  l1b_type(ib) = 'single'
                  l1b_rtype(ib) = 1.0
               enddo
            endif
         elseif(l1a_ndist(ia1).eq.1) then

         endif
      endif
      return
      end
c


      subroutine sort_out_sulphur(ia1,l1a_natom,l1b_nbond,l1a_ndist,
     &     l1a_ref2bond,l1a_conn,l1a_charg,l1a_symb,l1b_type,
     &     l1b_rtype,l1a_sorted,ierr)
      implicit none
      integer ia1
      integer l1a_natom
      integer, dimension(:) :: l1a_ndist
      integer, dimension(:,:) :: l1a_ref2bond
      integer, dimension(:,:) :: l1a_conn
      logical, dimension(:) :: l1a_sorted
      character(len=*), dimension(:) :: l1a_symb
      real, dimension(:) :: l1a_charg

      integer l1b_nbond
      real, dimension(:) :: l1b_rtype
      character(len=*), dimension(:) :: l1b_type

      integer ierr

      if(l1a_sorted(ia1)) return
      if(l1a_ndist(ia1).le.0) return

      if(l1a_symb(ia1)(1:2).eq.'S ') then
         if(l1a_ndist(ia1).eq.4) then
            nox = 0
            ndeloc = 0
            ndouble = 0
            nsingle = 0
            do ib1=1,l1a_ndist(ia1)
               ia2 = l1a_conn(ib1,ia1)
               if(l1a_symb(ia2)(1:2).eq.'O '.and.
     &              l1a_ndist(ia2).eq.1) then
                  nox = nox + 1
               endif
               if(l1a_rtype(ib).eq.1.0) then
                  nsingle = nsingle + 1
               elseif(l1a_rtype(ib).eq.1.5) then
                  ndeloc = ndeloc + 1
               elseif(l1a_rtype(ib).eq.2.0) then
                  ndouble = ndouble + 1
               endif
            enddo
            if(nox.eq.4) then
               do ib1=1,l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  ia2 = l1a_conn(ib1,ia1)
                  l1b_type(ib) = 'deloc'
                  l1b_rtype(ib) = 1.5
                  l1a_charg(ia2) = -0.5
               enddo
            elseif(nox.eq.3) then
               do ib1=l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  ia2 = l1a_conn(ib1,ia1)
                  if(l1a_symb(ia2)(1:2).eq.'O '.and.
     &                 l1a_ndist(ia2).eq.1) then
                     l1b_type(ib) = 'deloc'
                     l1b_rtype(ib) = 1.5
                     l1a_charg(ia2) = -0.33
                  else
                     l1b_type(ib) = 'single'
                     l1b_rtype(ib) = 1.0
                     l1a_charg(ia2) = 0.0
                  endif
               enddo
            elseif(nox.eq.2) then
               do ib1=1,l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  ia2 = l1a_conn(ib1,ia1)
                  if(l1a_symb(ia2)(1:2).eq.'O '.and
     &                 l1a_ndist(ia2).eq.1) then
                     l1b_type(ib) = 'double'
                     l1b_rtype(ib) = 2.0
                     l1a_charg(ia2) = 0.0
                  else
                     l1b_type(ib) = 'single'
                     l1b_rtype(ib) = 1.0
                     l1a_charg(ia2) = 0.0
                  endif
               enddo
            elseif(nox.eq.1) then
c
c---  Cannot sort it out. It should be defined before. Leave as it is.

            endif
         elseif(l1a_ndist(ia1).eq.3) then
c
c---  Sulphur valency 4
c
c--Are we dealing with sulphoxide or similar
            nox = 0
            ndeloc = 0
            ndouble = 0
            nsingle = 0
            do ib1=1,l1a_ndist(ia1)
               ia2 = l1a_conn(ib1,ia1)
               if(l1a_symb(ia2)(1:2).eq.'O '.and.
     &              l1a_ndist(ia2).eq.1) then
                  nox = nox + 1
               endif
               if(l1a_rtype(ib).eq.1.0) then
                  nsingle = nsingle + 1
               elseif(l1a_rtype(ib).eq.1.5) then
                  ndeloc = ndeloc + 1
               elseif(l1a_rtype(ib).eq.2.0) then
                  ndouble = ndouble + 1
               endif
            enddo
            if(nox.eq.3) then
               do ib1=l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  ia2 = l1a_conn(ib1,ia1)
                  l1b_type(ib) = 'deloc'
                  l1b_rtype(ib) = 1.5
                  l1a_charg(ia2) = -0.66
               enddo
            elseif(nox.eq.2) then
               do ib1=1,l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  ia2 = l1a_conn(ib1,ia1)
                  if(l1a_symb(ia2)(1:2).eq.'O '.and
     &                 l1a_ndist(ia2).eq.1) then
                     l1b_type(ib) = 'deloc'
                     l1b_rtype(ib) = 1.5
                     l1a_charg(ia2) = -0.5
                  else
                     l1b_type(ib) = 'single'
                     l1b_rtype(ib) = 1.0
                     l1a_charg(ia2) = 0.0
                  endif
               enddo
            elseif(nox.eq.1) then
               do ib1=1,l1a_ndist(ia1)
                  ib =l1a_ref2bond(ib1,ia1)
                  ia2 = l1a_conn(ib1,ia1)
                  if(l1a_symb(ia2)(1:2).eq.'O '.and.
     &                 l1a_ndist(ia2).eq.1) then
                     l1b_type(ib) = 'double'
                     l1b_rtype(ib) = 2.0
                     l1a_charg(ia2) = 0.0
                  else
                     l1b_type(ib) = 'single'
                     l1b_rtype(ib) = 1.0
                     l1a_charg(ia2) = 0.0
                  endif
               enddo
c
c---  More tests for cases when deloc, single,single; double double,deloc,
c---  double,double,single and others
            endif
         elseif(l1a_ndist(ia1).eq.2) then
            do ib1=1,l1a_ndist(ia1)
               ib = l1a_ref2bond(ib1,ia1)
               l1b_type(ib) = 'single'
               l1b_rtype(ib) = 1.0
            enddo
         endif
      endif
c
      return
      end
c
      subroutine sort_out_phosphor(ia1,l1a_natom,l1b_nbond,l1a_ndist,
     &     l1a_ref2bond,l1a_conn,l1a_charg,l1a_symb,l1b_type,
     &     l1b_rtype,l1a_sorted,ierr)
      implicit none
      integer ia1
      integer l1a_natom
      integer, dimension(:) :: l1a_ndist
      integer, dimension(:,:) :: l1a_ref2bond
      integer, dimension(:,:) :: l1a_conn
      logical, dimension(:) :: l1a_sorted
      character(len=*), dimension(:) :: l1a_symb
      real, dimension(:) :: l1a_charg

      integer l1b_nbond
      real, dimension(:) :: l1b_rtype
      character(len=*), dimension(:) :: l1b_type

      integer ierr

      if(l1a_sorted(ia1)) return
      if(l1a_ndist(ia1).le.0) return

      if(l1a_symb(ia1)(1:2).eq.'P ') then
         if(l1a_ndist(ia1).eq.4) then
            nox = 0
            ndeloc = 0
            ndouble = 0
            nsingle = 0
            do ib1=1,l1a_ndist(ia1)
               ia2 = l1a_conn(ib1,ia1)
               if(l1a_symb(ia2)(1:2).eq.'O '.and.
     &              l1a_ndist(ia2).eq.1) then
                  nox = nox + 1
               endif
               if(l1a_rtype(ib).eq.1.0) then
                  nsingle = nsingle + 1
               elseif(l1a_rtype(ib).eq.1.5) then
                  ndeloc = ndeloc + 1
               elseif(l1a_rtype(ib).eq.2.0) then
                  ndouble = ndouble + 1
               endif
            enddo
            if(nox.eq.4) then
               do ib1=1,l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  ia2 = l1a_conn(ib1,ia1)
                  l1b_type(ib) = 'deloc'
                  l1b_rtype(ib) = 1.5
                  l1a_charg(ia2) = -0.75
               enddo
            elseif(nox.eq.3) then
               do ib1=l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  ia2 = l1a_conn(ib1,ia1)
                  if(l1a_symb(ia2)(1:2).eq.'O '.and.
     &                 l1a_ndist(ia2).eq.1) then
                     l1b_type(ib) = 'deloc'
                     l1b_rtype(ib) = 1.5
                     l1a_charg(ia2) = -0.66
                  else
                     l1b_type(ib) = 'single'
                     l1b_rtype(ib) = 1.0
                     l1a_charg(ia2) = 0.0
                  endif
               enddo
            elseif(nox.eq.2) then
               do ib1=1,l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  ia2 = l1a_conn(ib1,ia1)
                  if(l1a_symb(ia2)(1:2).eq.'O '.and
     &                 l1a_ndist(ia2).eq.1) then
                     l1b_type(ib) = 'deloc'
                     l1b_rtype(ib) = 1.5
                     l1a_charg(ia2) = 0.0
                  else
                     l1b_type(ib) = 'single'
                     l1b_rtype(ib) = 1.0
                     l1a_charg(ia2) = 0.0
                  endif
               enddo
            elseif(nox.eq.1) then
               do ib1=1,l1a_ndist(ia1)
                  ib = l1a_ref2bond(ib1,ia1)
                  ia2 = l1a_conn(ib1,ia1)
                  if(l1a_symb(ia2)(1:2).eq.'O '.and
     &                 l1a_ndist(ia2).eq.1) then
                     l1b_type(ib) = 'double'
                     l1b_rtype(ib) = 2.0
                     l1a_charg(ia2) = 0.0
                  else
                     l1b_type(ib) = 'single'
                     l1b_rtype(ib) = 1.0
                     l1a_charg(ia2) = 0.0
                  endif
               enddo
            endif
         elseif(l1a_ndist(ia1).eq.3) then
c
c---  Phosphor valency 3
            do ib1=1,l1a_ndist(ia1)
               ib = l1a_ref2bond(ib1,ia1)
               l1b_type(ib) = 'single'
               l1b_rtype(ib) = 1.0
            enddo
         elseif(l1a_ndist(ia1).eq.2) then
c
c--Cannot sort out
         endif

      endif
c
      return
      end
c
      subroutine sort_out_selenium
      implicit none

      return
      end
c
      subroutine sort_out_metals
      implicit none

      return
      end
c
      subroutine define_sorted_atoms(l1a_natom,l1a_ndist,l1a_ref2bond,
     &     l1a_charg,l1a_valency,l1a_sorted,l1b_nbond,l1b_rtype)
      implicit none
      integer l1a_natom
      integer, dimension(:) :: l1a_ndist
      integer, dimension(:,:) :: l1a_ref2bond
      integer, dimension(:) :: l1a_valency
      real, dimension(:) :: l1a_charg
      
      logical, dimension(:) :: l1a_sorted
      integer l1b_naton
      real, dimension(:) :: l1b_rtype
c
      integer ia2,ia1,ib,ib2,ib3
      integer ndeloc,ndeloc1
      real rbond_order,rbond_order1
      real eps_bond
c
c---  body
      eps_bond = 1.0e-2

c---  It should be a subroutine
      l1a_sorted(1:l1a_natom) = .FALSE.
      do ia1=1,l1a_natom
         if(l1a_ndist(ia1).gt.0) then
            rbond_order = 0.0
            ndeloc = 0
            do ib1 = 1,l1a_ndist(ia1)
               ib = l1a_ref2bond(ib1,ia1)
               ia2 = l1a_conn(ib1,ia1)
               rbond_order = robond_order + l1b_rtype(ib)
               bcorrect = 0.0
               if(l1b_rtype(ib).eq.1.5) then
                  ndeloc1 = 0
                  rbond_order1 = 0.0
                  do ib2=1,l1a_ndist(ia2)
                     ib3=l1a_ref2bond(ib2,ia2)
                     rbond_order1 = rbond_order1 + l1b_rtype(ib3)
                     if(l1b_rtype(ib3).eq.1.5) then
                        ndeloc1 = ndeloc1+1
                     enddo
                  enddo
                  bcorrect=l1a_valency(ia2)-rbond_order1+l1a_charg(ia2)
                  bcorrect=bcorrect/ndeloc1
               endif
               rbond_order = rbond_order+bcorrect
            enddo
            rbond_order = rbond_order-l1a_charg(ia1)
            if(abs(rbond_order-l1a_valency(ia1)).le.eps_bond) then
               l1a_sorted(ia1) = .TRUE.
            endif
         endif
      enddo

      return
      end
c
      subroutine assign_valencies(l1a_natom,l1a_chem,l1a_ndist,
     &     l1a_valency,
     &     leb_natom,leb_chem,leb_valency)
      implicit none
      integer l1a_natom
      character(len=*), dimension(:) :: l1a_chem
      integer, dimension(:) :: l1a_valency
      integer, dimension(:) :: l1a_ndist
      integer leb_natom
      character(len=*), dimension(:) :: leb_chem
      integer, dimension(:) :: leb_valency

      integer ia,ie
c
      if(l1a_natom.le.0.or.leb_natom.le.0) return
      do ia=1,l1a_natom
         if(l1a_symb(ia)(1:2).eq.'O ') then
            l1a_valency(ia) = 2
         elseif(l1a_symb(ia)(1:2).eq.'C') then
            l1a_valency(ia) = 4
         elseif(l1a_symb(ia)(1:2).eq.'N ') then
            l1a_valency(ia) = 3
         elseif(l1a_symb(ia)(1:2).eq.'S ') then
            if(l1a_ndist(ia).le.2) then
               l1a_valency(ia) = 2
            elseif(l1a_ndist(ia).eq.3) then
               l1a_valency(ia) = 4
            else
               l1a_valency(ia) = 6
            endif
         elseif(l1a_symb(ia)(1:2).eq.'P ') then
            l1a_valency(ia) = 3
            if(l1a_ndist(ia).eq.4) l1a_valency(ia) = 5
         elseif(l1a_symb(ia)(1:2).eq.'SE') then
            if(l1a_ndist(ia).le.2) then
               l1a_valency(ia) = 2
            elseif(l1a_ndist(ia).eq.3) then
               l1a_valency(ia) = 4
            else
               l1a_valency(ia) =6
            endif
         else
c
c---All others from library. By element name
            do ie=1,leb_natom
               if(l1a_symb(ia)(1:2).eq.leb_ename(ie)(1:2)) then
                  l1a_valency(ia) = leb_valency(ie)
               endif
            enddo
         endif
      enddo

      return
      end
c
      subroutine add_hydrogens
      implicit none

      return
      end
c
      subroutine coords_2_lib
      implicit none


      if(l1a_natom.le.1) return
c
c---  Define potential bonds. take care there might be wrong bonds also
      allocata(l1a_radius(l1a_natom))
      do ia=1,l1a_natom
         do ie=1,leb_natom
            if(l1a_symb(ia)(1:3).eq.leb_ename(ie)(1:2)) then
               l1a_radius(ia) = max(l1a_radius,l1a_coval(ie)/2.0)
            endif
         enddo
      enddo
      l1a_radius(1:l1a_natom) = l1a_radius(1:l1a_natom)
               
      nbond = 0
      factor = 1.3
      do ia=1,l1a_natom
         do ia1=ia+1,n_atom
            dist = sqrt(sumxyz_crd(1:3,ia)-xyz_crd(1:3,ia1)**2)
            if(dist.le.factor*(l1a_radius(ia)+l1a_radius(ia1))) then
               nbond = nbond + 1
            endif
         enddo
      enddo
c
c---  Do we have one fragment. If more than one fragment then increment factor
c---  and do everything again

c
c---Remove bonds if you can. 
      call problem_atoms()
      do while(no_problem)
         do ia=1,l1a_natom
            if(problem_atom(ia)) then
               do ib1=1,l1b_ndist(ia)
                  ib=l1b_ref2bond(ib1,ia)
                  if(bond_max.le.l1b_val(ib)) then
                     ipr = ib
                  endif
               enddo
               l1b_val(ib) = -1.0
            endif
         enddo
         ib0=1
         do ib=1,l1b_nbond
            

c
c---  Define obvious bond orders

c
c---  define bond orders using

c
c---  correct bond orders. No hydrogens yet

c
c---  add hydrogens

c
c---  correct bond orders. Hydrogens are know. 
c---  Should we correct the number of hydrogens also?

      return
      end
