C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
      SUBROUTINE GETLIB(MMDOC,LIST,NODIST,NUMB_LIB
     *            ,LIBM_PATH,LIBE_PATH,LIBS_PATH
     *            ,LIBM_NAME,LIBE_NAME,LIBS_NAME
     *            ,LIBM_EXT ,LIBE_EXT ,LIBS_EXT
     *            ,LIB2_NAME,LIB_IND  ,FILE_LIB_OUT ,IERR)
C -------------------------------------------------------
C ---
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------
      INTEGER MMDOC
      CHARACTER LIBM_PATH*(*)    ,LIBE_PATH*(*),LIBS_PATH*(*)
      CHARACTER LIBM_NAME(20)*256,LIBE_NAME*(*),LIBS_NAME*(*)
      CHARACTER LIBM_EXT*(*)     ,LIBE_EXT*(*) ,LIBS_EXT*(*)
      CHARACTER LIB2_NAME*(*)    ,LIB_IND*(*)  ,FILE_LIB_OUT*(*)
      INTEGER*4 MDOC,MMM,IS,IERR,NUMB_LIB
      CHARACTER MOD*1,CHAR1*1,LIST*1,NODIST*1
C ----------------------------------------------
      IERR = 0
      MDOC = MMDOC
      MMM  = MDOC
      IF(LIST.EQ.'S') THEN
        MDOC = 999
        MMM  = MDOC
      ELSE IF(LIST.EQ.'M') THEN
        MMM = 999
      ENDIF
C ---
C
      CALL INITLIB(MMM,NODIST,NUMB_LIB
     *            ,LIBM_PATH,LIBE_PATH,LIBS_PATH
     *            ,LIBM_NAME,LIBE_NAME,LIBS_NAME
     *            ,LIBM_EXT ,LIBE_EXT ,LIBS_EXT
     *            ,LIB2_NAME,LIB_IND  ,FILE_LIB_OUT ,IERR)
      IF(IERR.NE.0) RETURN
C ---
C     read list of all monomers in the library. 

      LB_TFLAG = 'N'
      CALL GET_LLIST(MDOC,IERR)    
      IF(IERR.NE.0) RETURN
      CALL GET_INDEX(MDOC,IERR)
      IF(IERR.NE.0) RETURN
      MOD   = 'N'
      CHAR1 = 'N'
      CALL SSET_FUSE(MOD,CHAR1)
C  ---
C     read ener_lib.cif
      CALL MSGDOC(MDOC,' I am reading libraries. Please wait.')
      CALL MSGDOC(MDOC,'     - energy parameters')
      MOD = 'E'
      CALL READ_LIB(MDOC,MOD,NODIST,LIST,IERR)
      IF(IERR.NE.0) RETURN
C     read mon_lib.cif (links & mod )
      CALL MSGDOC(MDOC,'     - monomer"s description (links & mod )')
      MOD = 'N'
      CALL READ_LIB(MDOC,MOD,NODIST,LIST,IERR)
      IF(IERR.NE.0) RETURN
C ---
C     initialization COM_CONN_INF
      CALL INIT_CONN_INF(MDOC,IERR)     
C ---
      RETURN
      END

      SUBROUTINE INITLIB(MDOC,NODIST,NUMB_LIB
     *            ,LIBM_PATH,LIBE_PATH,LIBS_PATH
     *            ,LIBM_NAME,LIBE_NAME,LIBS_NAME
     *            ,LIBM_EXT ,LIBE_EXT ,LIBS_EXT
     *            ,LIB2_NAME,LIB_IND  ,FILE_LIB_OUT ,IERR)
C -------------------------------------------------------
C -P- INITLIB - initialization of common blocks of library.
C -S-
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,NUMB_LIB
      CHARACTER LIBM_PATH*(*)    ,LIBE_PATH*(*),LIBS_PATH*(*)
      CHARACTER LIBM_NAME(20)*256,LIBE_NAME*(*),LIBS_NAME*(*)
      CHARACTER LIBM_EXT *(*)    ,LIBE_EXT *(*),LIBS_EXT *(*)
      CHARACTER LIB2_NAME*(*)    ,LIB_IND  *(*),FILE_LIB_OUT*(*)
      CHARACTER NODIST*1
C ******
      CHARACTER LINE*256
      INTEGER*4 IL,I,LEN
C -----------------------------------
      IERR=0
C -----------------------------------
      IS = LMB_TOTAL * 4
      WRITE(LINE,'('' Size of lib_com.fh(bytes) :'',I10)') IS
      CALL MSGDOC(MDOC,LINE)
C -----------------------------------
      DO I=1,20
       LIBM_NAME(I) = ' '
      ENDDO

      IF(NODIST.NE.'Y') THEN
        NUMB_LIB     = 1
C ---
        LIBM_NAME( 1) = 'list/mon_lib_list'
c        LIBM_NAME( 2) = 'mon_lib_prot'
c        LIBM_NAME( 3) = 'mon_lib_na'
c        LIBM_NAME( 4) = 'mon_lib_sug'
c        LIBM_NAME( 5) = 'mon_lib_met'
c        LIBM_NAME( 6) = 'mon_lib_1'
c        LIBM_NAME( 7) = 'mon_lib_2'
c        LIBM_NAME( 8) = 'mon_lib_3'
c        LIBM_NAME( 9) = 'mon_lib_4'
c        LIBM_NAME(10) = 'mon_lib_5'
c        LIBM_NAME(11) = 'mon_lib_6'
c        LIBM_NAME(12) = 'mon_lib_7'
c        LIBM_NAME(13) = 'mon_lib_8'
c        LIBM_NAME(14) = 'mon_lib_9'
c        LIBM_NAME(15) = 'mon_lib_10'
c        LIBM_NAME(16) = 'mon_lib_11'
c        LIBM_NAME(17) = 'mon_lib_12'
c        LIBM_NAME(18) = 'mon_lib_13'
c        LIBM_NAME(19) = ' '
c        LIBM_NAME(20) = ' '
C ---
        LIBM_EXT     = 'cif'
        LIB_IND      = 'mon_lib_ind'
      ELSE
        NUMB_LIB          = 1
        LIBM_NAME(1)      = ' '
        CALL LENSTR_BL(LIB2_NAME,LEN)
        IF(LEN.GT.0.AND.LIB2_NAME(1:1).NE.','.AND.
     *                  LIB2_NAME(1:1).NE.' ') THEN
          NUMB_LIB     = 1
          LIBM_NAME(1) = LIB2_NAME
          LIBM_PATH    = ' '
          LIBM_EXT     = ' '
        ENDIF
        LIB2_NAME    = ' '
        LIB_IND      = ' '
      ENDIF
C --
      LIBE_NAME    = 'ener_lib'
      LIBE_EXT     = 'cif'
C ---
      LMI_FILE(1) = ' '
      LMI_PATH    = ' '
      LMI_EXT     = ' '
      IL          = 0

      DO I=1,NUMB_LIB
        LINE = LIBM_NAME(I)
        CALL LENSTR_BL(LINE,LEN)
        IF(LEN.GT.0.AND.LINE(1:1).NE.','.AND.
     *                LINE(1:1).NE.' ') THEN
          IL = IL +1
          IF(IL.GT.MAXLIB) THEN
            WRITE(LINE,'(A,I5,A)')
     * ' ERROR: number of dictionaries >',MAXLIB,' /lib. limit/ '
            CALL MSGERR(MDOC,LINE)
            IERR=1
            RETURN
          ENDIF
          LB_NUMB_LIB  = IL
          LMI_FILE(IL) = LINE
          LMI_PATH     = LIBM_PATH
          LMI_EXT      = LIBM_EXT
        ENDIF
      ENDDO

      IF(NUMB_LIB.EQ.1) THEN
        LMI_FILE(2) = NODIST
      ENDIF

      LEI_FILE = ' '
      LEI_PATH = ' '
      LEI_EXT  = ' '
      CALL LENSTR_BL(LIBE_NAME,LEN)
      IF(LEN.GT.0.AND.LIBE_NAME(1:1).NE.','.AND.
     *                LIBE_NAME(1:1).NE.' ') THEN
        LEI_FILE = LIBE_NAME
        LEI_PATH = LIBE_PATH
        LEI_EXT  = LIBE_EXT
      ENDIF

      LMI2_FILE = ' '
      LMI2_PATH = ' '
      LMI2_EXT  = ' '
      CALL LENSTR_BL(LIB2_NAME,LEN)
      IF(LEN.GT.0.AND.LIB2_NAME(1:1).NE.','.AND.
     *                LIB2_NAME(1:1).NE.' ') THEN
        LMI2_FILE=LIB2_NAME
      ENDIF
      LIN_FILE = ' '
      LIN_PATH = ' '
      LIN_EXT  = ' '
      CALL LENSTR_BL(LIB_IND,LEN)
      IF(LEN.GT.0.AND.LIB_IND(1:1).NE.','.AND.
     *                LIB_IND(1:1).NE.' ') THEN
        LIN_FILE = LIB_IND
        LIN_PATH = LIBM_PATH
        LIN_EXT  = LIBM_EXT
      ENDIF

      CALL LENSTR_BL(FILE_LIB_OUT,LEN)
      IF(LEN.GT.0.AND.FILE_LIB_OUT(1:1).NE.','.AND.
     *                FILE_LIB_OUT(1:1).NE.' ') THEN
        LMO_FILE = FILE_LIB_OUT
        LMO_PATH = ' '
        LMO_EXT  = ' '
      ELSE
        LMO_FILE = 'new.lib' 
        FILE_LIB_OUT = LMO_FILE
        LMO_PATH = ' '
        LMO_EXT  = ' '
      ENDIF
      LEO_FILE = 'new_ener_lib'
      LEO_PATH = ' '
      LEO_EXT  = 'cif'
      LMI_IUN  = 0
      LMI2_IUN = 0
      LMO_IUN  = 0
      LEI_IUN  = 0
      LEO_IUN  = 0
      LSI_IUN  = 0
      LSI_PATH = ' '
      LSI_FILE = ' '
      LSI_EXT  = ' '
      CALL LENSTR_BL(LIBS_NAME,LEN)
      IF(LEN.GT.0.AND.LIBS_NAME(1:1).NE.','.AND.
     *                LIBS_NAME(1:1).NE.' ') THEN
        LSI_PATH = LIBS_PATH
        LSI_FILE = LIBS_NAME
        LSI_EXT  = LIBS_EXT
      ENDIF
      IERR=0
C -----------------------------------
C     initialization counters of library
      LB_NAME     = '?'
      LB_VERS     = '?'
      LB_DATE     = '?'
      LB2_NAME    = '?'
      LB2_VERS    = '?'
      LB2_DATE    = '?'
      LB_PASS     = 0
      LML_NMON    = 0
      LML_NPRSNT  = 0
      LML_IMON    = 0
      LMX_NMON    = 0
      LMS_NSYN    = 0
      LMS_NEW     = 0
      LMS_ISYN    = 0
      LDR_NDER    = 0
      LDR_IDER    = 0
      LMR_NREC    = 0
      LB_HFLAG    = 'N'
      LB_TFLAG    = 'N'
      LSO_NSYM    = 1
      LSO_SYMOP(1)= 'X,Y,Z'
      LSF_NASYMB  = 0
      DO   I=1,MAXMLIST
        LML_ISYN (I) = 0
        LML_IDER (I) = 0
        LML_IMMON(I) = 0
        LML_ILMON(I) = 0
      ENDDO
      DO   I=1,MAXMLIST
        LML_PASS (I) = 0
        LML_NATM (I) = 0
        LML_NHATM(I) = 0
        LML_MNAME(I) = '?'
        LML_MNAME2(I)= '?'
        LML_NAME (I) = '?'
        LML_FORM (I) = '?'
        LML_CODE1(I) = '?'
        LML_TYPE (I) = '?'
        LML_MODE (I) = '?'
        LML_FUSE (I) = 'N'
        LML_PRSNT(I) = 'N'
      ENDDO
      LLL_NLINK = 0
      LLL_ILINK = 0
      DO   I=1,MAXLLNK
        LLL_LNAME  (I) = '?'
        LLL_DETAIL (I) = '?'
        LLL_CODE1  (I) = '?'
        LLL_MOD1   (I) = '?'
        LLL_MON1   (I) = '?'
        LLL_FLAG1  (I) = 0
        LLL_TYPE1  (I) = '?'
        LLL_MOD2   (I) = '?'
        LLL_MON2   (I) = '?'
        LLL_FLAG2  (I) = 0
        LLL_TYPE2  (I) = '?'
        LLL_FUSE   (I) = 'N'
      ENDDO
      LDL_NMOD  = 0
      LDL_IMOD  = 0
      DO   I=1,MAXDMDF
        LDL_MNAME  (I) = '?'
        LDL_DETAIL (I) = '?'
        LDL_COMP   (I) = '?'
        LDL_TYPE   (I) = '?'
        LDL_ORDER  (I) = 0
        LDL_FUSE   (I) = 'N'
      ENDDO
      CALL INIT_CNT
C ----------------------------------
      RETURN
      END     
 
      SUBROUTINE INIT_CONN_INF(MDOC,IERR)     
C -----------------------------------------------
C      DATA N_STOR /8/
C
C      DATA ATOM_STOR /
C     * 'N   ','C   ','C1  ','O3* ','O3  ','O4  ','O6  ','P   ','    '
C     *,'    '/
C        1      2      3      4      5      6      7      8      9
C -----------------------------------
C      1    2    3   4    5      6       7       8       9     10
C      -  TRANS CIS  P FOR_C-N FOR_C-C ACE_C-N DFO_C-N NME_N-C  gap
C      DATA ICONN_ATOM_IND/
C     *0,0, 2,1, 2,1,4,8, 2,1,  2,2,    2,1,    2,1,   2,1,     0,0,
C     *0,0, 5,3, 6,3,7,3, 0,0,  0,0,    0,0,    0,0,   0,0,     0,0/ 
C          B1-3 B1-4 B1-6
C      1    2    3   4    5      6       7       8       9     20
C ------------------------------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER ATOM1*4,ATOM2*4
C     CHARACTER LINE*256
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------------------------
      IERR   = 0
      N_STOR = 0

      ATOM_STOR( 1) = 'CA  '
      ATOM_STOR( 2) = 'C   '
      ATOM_STOR( 3) = 'N   '
      ATOM_STOR( 4) = 'OXT '
      ATOM_STOR( 5) = 'O1P '
      ATOM_STOR( 6) = 'O2P '
      ATOM_STOR( 7) = 'P   '
      ATOM_STOR( 8) = 'O3* '
      ATOM_STOR( 9) = 'O5* '
      ATOM_STOR(10) = 'O2* '
      ATOM_STOR(11) = 'OT  '
      ATOM_STOR(12) = 'O5T '
      ATOM_STOR(13) = 'O3T '

      N_STOR = 13

      IF(LLL_NLINK.GT.0) THEN

        DO L=1,LLL_NLINK

          ICONN_ATOM_IND(1,L) = 0
          ICONN_ATOM_IND(2,L) = 0

          IF(LLB_NBOND.GT.0.AND.LLL_IBOND(L).GT.0) THEN
            DO IB = LLL_IBOND(L),LLB_NBOND
              IF(LLL_LNAME(L).EQ.LLB_LNAME(IB)) THEN

                ATOM1 = LLB_1ATM(IB)
                ATOM2 = LLB_2ATM(IB)
          
                IF(ATOM1.NE.'.'.AND.ATOM2.NE.'.'.AND.
     *             ATOM1.NE.' '.AND.ATOM2.NE.' ') THEN

                  IF(N_STOR.GT.0) THEN
                    DO IA = 1,N_STOR
                      IF(ATOM1.EQ.ATOM_STOR(IA)) GO TO 100
                    ENDDO
                  ENDIF
                  IF(N_STOR.GE.NSTOR_PAR) THEN
                    RETURN
                  ENDIF
                  N_STOR        = N_STOR + 1
                  IA            = N_STOR
                  ATOM_STOR(IA) = ATOM1

  100             CONTINUE
                  IA1 = IA

                  IF(N_STOR.GT.0) THEN
                    DO IA = 1,N_STOR
                      IF(ATOM2.EQ.ATOM_STOR(IA)) GO TO 200
                    ENDDO
                  ENDIF
                  IF(N_STOR.GE.NSTOR_PAR) THEN
                    RETURN
                  ENDIF
                  N_STOR        = N_STOR + 1
                  IA            = N_STOR
                  ATOM_STOR(IA) = ATOM2

  200             CONTINUE
                  IA2 = IA

                  ICONN_ATOM_IND(1,L) = IA1
                  ICONN_ATOM_IND(2,L) = IA2
                  BOND_IDL(L)         = LLB_VAL(IB)
                ENDIF

              ENDIF
            ENDDO
        
          ENDIF

        ENDDO
      ENDIF

      RETURN
      END


C ******
      SUBROUTINE GET_INDEX(MDOC,IERR)
C -----------------------------------------------
C
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'crd_com.fh'
C ---
C -----------------------------------
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
      CHARACTER LINE*256,MON*8,CH2*2,FORM*1,FILE*256
C -----------------------------------
      IERR     = 0
      M        = 99
C --------------------
      LMX_NMON = 0

      CALL LENSTR_BL(LIN_FILE,LEN)
      IF(LEN.GT.0.AND.LIN_FILE(1:1).NE.' '.AND.
     *  LIN_FILE(1:1).NE.',') THEN
        IUN   = CRO_IUN
        CALL OPENFR(IUN,M,LIN_PATH,LIN_FILE,LIN_EXT,IERR)
        CRO_IUN = IUN
        IF(IERR.NE.0) THEN
          CALL LENSTR_BL(LIN_FILE,L)
          LINE = ' ERROR: can"t open (index) '//LIN_FILE(1:L)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ELSE
        RETURN
      ENDIF

      LMX_NMON = 0

 100  CONTINUE

      READ(IUN,'(A)',ERR=200,END=200) LINE

      READ(LINE,'(I4,1X,A2,1X,A8,1X,I4,1X,A30,1X,A24)')
     *    L,CH2,MON,N,C_CONTENT,C_INDEX

C       write(*,
C    * '(I4,'' '',A2,'' '',I4,'';'',A3,'';'',A30,'';'',A24,'';'')')
C    *  L,CH2,N,MON,C_CONTENT,C_INDEX

      READ(IUN,'(A)',ERR=200,END=200) LINE

      READ(LINE,'(17X,A24)') C_PAIR

      LMX_NMON              = LMX_NMON + 1
      LMX_NATOM  (LMX_NMON) = N 
      LMX_MNAME  (LMX_NMON) = MON
      LMX_INDEX  (LMX_NMON) = C_INDEX
      LMX_CONTENT(LMX_NMON) = C_CONTENT
      LMX_PAIR   (LMX_NMON) = C_PAIR
      GO TO 100
C ---
 200  CONTINUE
      CLOSE(IUN,ERR=300)
 300  CONTINUE
C  ----------------------
      CALL LENSTR_BL(LIN_FILE,LEN)
      IF(LEN.GT.0.AND.LIN_FILE(1:1).NE.' '.AND.
     *  LIN_FILE(1:1).NE.',') THEN
        IUN   = CRO_IUN
        FILE  = LIN_FILE(1:LEN)//'2'
        CALL OPENFR(IUN,M,LIN_PATH,FILE,LIN_EXT,IERR)
        CRO_IUN = IUN
        IF(IERR.NE.0) THEN
          CALL LENSTR_BL(FILE,L)
          LINE = ' ERROR: can"t open (index2) '//FILE(1:L)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ELSE
        RETURN
      ENDIF

      FORM = 'F'

      CALL LIB_READ_INDEX2(MDOC,IUN,FORM,IERR)
      CLOSE(IUN)

C  ----------------------
      RETURN
      END

      SUBROUTINE LIB_READ_INDEX2(MDOC,IUN,FORM,IERR)
C -------------------------------------------
      INTEGER MAXMPONTER
      PARAMETER (MAXMPONTER = 3500)
      INTEGER MAXMPOOL
      PARAMETER (MAXMPOOL = 1600 000)
      INTEGER   MATCH_POINTER(MAXMPONTER)
      INTEGER*2 MATCH_POOL   (MAXMPOOL)
      COMMON /COM_MATCH_POOL/ MEM_TOT,MATCH_NMON
     *                       ,MATCH_POINTER,MATCH_POOL
C ------------------------------------------
C     IP = MATCH_POINTER(I) 
C       MATCH_POOL(IP  ) = IMON 
C       MATCH_POOL(IP+1) = NATOM  
C       MATCH_POOL(IP+2) = NBOND
C
C       IPC = IP+2
C       MATCH_POOL(IPC+1)  = ICONTENT(1) 
C       . . . . . 
C       MATCH_POOL(IPC+15) = ICONTENT(15) 
C 'C ','N ','O ','S ','P ','CO','MG','CA','ZN','CU','FE','CL','MN','MO','  '
C  1    2    3    4    5    6    7    8    9    10   11   12   13   14   15
C  
C       IPA = IP + 17
C       MATCH_POOL(IPA+1) = IATOM
C       MATCH_POOL(IPA+2) = IATYPE
C
C       IPB = IP + 17 + 2*NATOM
C       MATCH_POOL(IPA+1) = IATOM1
C       MATCH_POOL(IPA+1) = IATOM2
C       MATCH_POOL(IPA+1) = IBTYPE
C
C       0-dumm,1-sing,2-doub,3-trip,4-arom,5-delo,6-meta,7-cova
C
C ---------------------------------------------------------------
      INTEGER  MDOC,IERR,IUN
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER MON*8,FORM*1,LINE*256
C ---------------------------------------------------------------------
      IF(FORM.EQ.'U') THEN
        READ(IUN) MATCH_NMON,MEM_TOT
      ELSE
        READ(IUN,'(I5,I12)') MATCH_NMON,MEM_TOT
      ENDIF

      IF(MEM_TOT.LE.0.OR.MATCH_NMON.LE.0) THEN
        MATCH_NMON = 0
        IERR = 1
        RETURN      
      ENDIF

      IF(MEM_TOT.GT.MAXMPOOL) THEN
        WRITE(LINE,'(A)')
     *  ' ERROR: in LIB_CREATE_INDEX2: Insufficient memory:'
        CALL MSGERR(MDOC,LINE)         
        MATCH_NMON = 0
        IERR = 1
        RETURN
      ENDIF    

      IF(FORM.EQ.'U') THEN
        READ(IUN) (MATCH_POINTER(IM),IM=1,MATCH_NMON)
      ELSE
        READ(IUN,'(10I8)') (MATCH_POINTER(IM),IM=1,MATCH_NMON)
      ENDIF


      IF(FORM.EQ.'U') THEN
        READ(IUN) (MATCH_POOL(IM),IM=1,MEM_TOT)
      ELSE
        READ(IUN,'(20I4)') (MATCH_POOL(IM),IM=1,MEM_TOT)
      ENDIF

C ---------------------
      RETURN
      END

C ******
      SUBROUTINE GET_LLIST(MDOC,IERR)
C -----------------------------------------------
C -P- GET_LLIST - reads  only title and list_information of monomer's from 
C -P-             the library_file. 
C                 If LB_TFLAG = 'N' read all monomers,
C                 if = 'Y' read accoding list of monomers which was prepared
C                 before.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,IEND
C ---
      INCLUDE 'lib_com.fh'
C ---
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---
      COMMON/COM_CRD_CIF/ IEND_CIF      
      INTEGER*4 IEND_CIF
C ---
C -----------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,IUN,M,IFIRST,I,NM
      INTEGER*4 LCMP,LSN,LDR,LMD,LNK,LCMPA,LMDA,LNKB
      CHARACTER DATA*80,ITEM*80,LINE*256,CH1*1,LIB*256
C -----------------------------------
      INCLUDE 'crd_com.fh'
C ----------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------

      LML_NMON   = 0
      LML_NPRSNT = 0
      LLL_NLINK  = 0
      LDL_NMOD   = 0
      LML_IMON   = 0
      LB_PASS    = 0
C ---
      CALL INIT_CNT
C ------
 100  CONTINUE
      LB_PASS = LB_PASS + 1
      IFIRST  = 0
      IERR    = 0
      IEND    = 0
C ------
C     open file of mon_library
C     IUN = 10
      IUN = CRI_IUN
      M   = 99
      IF(LB_PASS.LE.LB_NUMB_LIB) THEN
        LIB = LMI_FILE(LB_PASS)
        CALL LENSTR_BL(LIB,LEN)
        IF(LEN.LE.0) GO TO 410
        CALL OPENFR(IUN,M,LMI_PATH,LIB,LMI_EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL LENSTR_BL(LIB,LEN) 
          IF(LEN.GT.60) LEN=60
          WRITE(LINE,*) ' ERROR: can"t open (lib) ',LIB(1:LEN)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ELSE
        CALL OPENFR(IUN,M,LMI2_PATH,LMI2_FILE,LMI2_EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL LENSTR_BL(LMI2_FILE,LEN) 
          IF(LEN.GT.60) LEN=60
          WRITE(LINE,*) ' ERROR: can"t open (lib2) ',LMI2_FILE(1:LEN)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ENDIF
      LMI_IUN = IUN
      IEND    = -1
C -------
      IF(IEND.EQ.-1) THEN
        REWIND IUN
        IEND_CIF = -1
        IEND     = 0
      ENDIF

  300 CONTINUE   
      CALL GETCIF_INFO(IUN,MDOC,IERR,IEND_CIF)
      IF(IERR.NE.0.OR.(IEND_CIF.NE.0.AND.IEND_CIF.NE.-2)) THEN
C        CLOSE(IUN)
C        LMI_IUN=0
        IEND=1
        GO TO 400
C       RETURN
      ENDIF

      IF(IEND_CIF.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment
C   
        GO TO 300
      ENDIF

      IF(N_CIF.LE.0) GO TO 300
      DO I=1,N_CIF

        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IF(LENB.LE.0.OR.LENB.GT.60) THEN
          BLK_CIF = ' '
          LENB    = 1
        ENDIF 
        IDATA = IDT_CIF(I)
        FDATA = FDT_CIF(I)


        CALL LENSTR_BL(ITL_CMP  ,LCMP )
        CALL LENSTR_BL(ITL_SNM  ,LSN  )
        CALL LENSTR_BL(ITL_SNMA ,LSNA )
        CALL LENSTR_BL(ITL_DER  ,LDR  )
        CALL LENSTR_BL(ITL_MOD  ,LMD  )
        CALL LENSTR_BL(ITL_LNK  ,LNK  )
        CALL LENSTR_BL(ITL_CMPA ,LCMPA)
        CALL LENSTR_BL(ITL_MODA ,LMDA )
        CALL LENSTR_BL(ITL_LNKB ,LNKB )

        CALL LENSTR_BL(ITL_GLOBAL,L)

        IF(BLK_CIF(1:LENB).EQ.ITL_GLOBAL(1:L)) THEN
          CALL LENSTR_BL(ITL_LIB_NAME,L)
          IF(ITEM(1:LENI).EQ.ITL_LIB_NAME(1:L)) THEN
            LB_NAME=DATA(1:LEND)
            CALL MSGDOC(MDOC,' ------------------------------')
            CALL MSGDOC(MDOC,' ---  LIBRARY OF MONOMERS   ---')
            LL = LEND
            IF(LL.GT.60) LL=60
            WRITE(LINE,'(A,6X,A)') ITEM(1:12),LB_NAME(1:LL)
            CALL MSGDOC(MDOC,LINE)
          ENDIF
          CALL LENSTR_BL(ITL_LIB_VER,L)
          IF(ITEM(1:LENI).EQ.ITL_LIB_VER(1:L)) THEN
            LB_VERS=DATA(1:LEND)
            LL = LEND
            IF(LL.GT.60) LL=60
            WRITE(LINE,'(A,6X,A)') ITEM(1:12),LB_VERS(1:LL)
            CALL MSGDOC(MDOC,LINE)
          ENDIF
          CALL LENSTR_BL(ITL_LIB_UPD,L)
          IF(ITEM(1:LENI).EQ.ITL_LIB_UPD(1:L)) THEN
            LB_DATE=DATA(1:LEND)
            LL = LEND
            IF(LL.GT.60) LL=60
            WRITE(LINE,'(A,6X,A)') ITEM(1:12),LB_DATE(1:LL)
            CALL MSGDOC(MDOC,LINE)
            CALL MSGDOC(MDOC,' ------------------------------')
          ENDIF
        ELSE IF(ITEM(1:LCMP).EQ.ITL_CMP(1:LCMP)) THEN
          IFIRST=1
          CALL PT_MLIST(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
          IF(IERR.NE.0) THEN
            CLOSE(IUN,ERR=420)
 420        CONTINUE
            LMI_IUN=0
            RETURN
          ENDIF

        ELSE IF(ITEM(1:LSN).EQ.ITL_SNM(1:LSN)) THEN
          CALL PT_MSYN(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ELSE IF(ITEM(1:LSNA).EQ.ITL_SNMA(1:LSNA)) THEN
          CALL PT_MSYN(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ELSE IF(ITEM(1:LDR).EQ.ITL_DER(1:LDR)) THEN
          CALL PT_MDER(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ELSE IF(ITEM(1:LMD).EQ.ITL_MOD(1:LMD)) THEN
          CALL PT_MDLIST(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ELSE IF(ITEM(1:LNK).EQ.ITL_LNK(1:LNK)) THEN
           CALL PT_LNLIST(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
C
C -- this is old
c        ELSE IF(ITEM(1:17).EQ.'_lib_mod_mon_list') THEN
c           CALL PT_MDMON(MDOC,I,BLK_CIF,LENB,ITEM,LENI
c     *    ,DATA,IDATA,FDATA,LEND,IERR)
c        ELSE IF(ITEM(1:18).EQ.'_lib_link_mon_list') THEN
c           CALL PT_LNMON(MDOC,I,BLK_CIF,LENB,ITEM,LENI
c     *    ,DATA,IDATA,FDATA,LEND,IERR)
C
        ELSE IF(ITEM(1:LCMPA).EQ.ITL_CMPA(1:LCMPA)) THEN
          GO TO 400
        ELSE IF(ITEM(1:LMDA).EQ.ITL_MODA(1:LMDA)) THEN
          GO TO 400
        ELSE IF(ITEM(1:LNKB).EQ.ITL_LNKB(1:LNKB)) THEN
          GO TO 400
        ELSE
c          IF(IFIRST.EQ.1) GO TO 400
        ENDIF
      ENDDO
      GO TO 300

  400 CONTINUE
      CLOSE(IUN,ERR=410)
 410  CONTINUE
      LMI_IUN=0
      
      IF(LB_PASS.EQ.LB_NUMB_LIB) THEN
        CALL LENSTR_BL(LMI2_FILE,LEN)
        IF(LEN.GT.0.AND.LMI2_FILE(1:1).NE.','.AND.
     *    LMI2_FILE(1:1).NE.' ') THEN
          GO TO 100
        ENDIF
      ELSE IF(LB_PASS.LT.LB_NUMB_LIB) THEN
        GO TO 100
      ENDIF
C -----------------------------------------------------------
      LML_NPRSNT = 0
      NM         = 0
      IF(LML_NMON.GT.0) THEN
        DO I=1,LML_NMON
          CH1 = LML_PRSNT(I)
          IF(CH1.EQ.'.'.OR.CH1.EQ.'C') 
     *    LML_NPRSNT = LML_NPRSNT + 1
          IF(LML_MNAME(I)(1:3).NE.'???') NM = NM + 1
        ENDDO
      ENDIF
C -----------------
      CALL SET_LIB_RES_TYPE_TAB(MDOC,IERR)
C -----------------
      LB_PASS = 0
      WRITE(LINE,
     *'('' NUMBER OF MONOMERS IN THE LIBRARY          :'',I6)') NM
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,
     *'(''               with complete description    :'',I6)')
     * LML_NPRSNT
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,
     *'('' NUMBER OF MODIFICATIONS                    :'',I6)') 
     * LDL_NMOD
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,
     *'('' NUMBER OF LINKS                            :'',I6)') 
     * LLL_NLINK
      CALL MSGDOC(MDOC,LINE)

      RETURN
C -----------------------------------
      END     

      SUBROUTINE SET_LIB_RES_TYPE_TAB(MDOC,IERR)
C ------------------------------------------------------
      INTEGER   MDOC,IERR
      CHARACTER MON*8,MONN*8,TYPE*16
C ---
      INCLUDE 'lib_com.fh'
C ---
C ------------------------------------------------------
      INTEGER    NRNAME_PAR,NRNAMEP_PAR,NRNAMED_PAR,NRNAMES_PAR

      PARAMETER ( NRNAME_PAR  = 400 )
      PARAMETER ( NRNAMEP_PAR = 200 )
      PARAMETER ( NRNAMED_PAR = 200 )
      PARAMETER ( NRNAMES_PAR = 200 )

      COMMON/COM_RES_TYPE/  NRNAME_T,NRNAMEP_T,NRNAMED_T,NRNAMES_T
     *                     ,RNAME_T,RNAMEP_T,RNAMED_T,RNAMES_T
      INTEGER   NRNAME_T,NRNAMEP_T,NRNAMED_T,NRNAMES_T
      CHARACTER RNAME_T (NRNAME_PAR )*8
      CHARACTER RNAMEP_T(NRNAMEP_PAR)*8
      CHARACTER RNAMED_T(NRNAMED_PAR)*8
      CHARACTER RNAMES_T(NRNAMES_PAR)*8
C==================================================================
      IERR  = 0
C L-peptide 
C D-peptide 
C peptide
C
C polymer 
C
C DNA
C RNA
C DNA/RNA
C 
C L-pyranose
C D-pyranose
C pyranose
C
C non-polymer
C
C solvent 
C
      NRNAME_T  = 0
      NRNAMEP_T = 0
      NRNAMED_T = 0
      NRNAMES_T = 0

      IF(LML_NMON.GT.0) THEN
        DO IM=1,LML_NMON
          MONN  = LML_MNAME(IM)
          TYPE  = LML_TYPE(IM)
          MON   = MONN
          TYPE  = LML_TYPE(IM)
          IF(TYPE(1:4).EQ.'L-pe'.OR.TYPE(1:4).EQ.'D-pe'.OR.
     *       TYPE(1:4).EQ.'pept') THEN
            IF(NRNAME_T.GT.0) THEN
              DO I=1,NRNAME_T
                IF(RNAME_T(I).EQ.MON) GO TO 100
              ENDDO
            ENDIF
            NRNAME_T = NRNAME_T + 1
            RNAME_T(NRNAME_T) = MON       
          ELSE IF(TYPE(1:4).EQ.'poly') THEN
            IF(NRNAMEP_T.GT.0) THEN
              DO I=1,NRNAMEP_T
                IF(RNAMEP_T(I).EQ.MON) GO TO 100
              ENDDO
            ENDIF
            NRNAMEP_T = NRNAMEP_T + 1
            RNAMEP_T(NRNAMEP_T) = MON 
          ELSE IF(TYPE(1:3).EQ.'DNA'.OR.TYPE(1:3).EQ.'RNA') THEN
            IF(NRNAMED_T.GT.0) THEN
              DO I=1,NRNAMED_T
               IF(RNAMED_T(I).EQ.MON) GO TO 100
              ENDDO
            ENDIF
            NRNAMED_T = NRNAMED_T + 1
            RNAMED_T(NRNAMED_T) = MON 
          ELSE IF(TYPE(1:4).EQ.'L-py'.OR.TYPE(1:4).EQ.'D-py'.OR.
     *       TYPE(1:4).EQ.'pyra') THEN
            IF(NRNAMES_T.GT.0) THEN
              DO I=1,NRNAMES_T
                IF(RNAMES_T(I).EQ.MON) GO TO 100
              ENDDO
            ENDIF
            NRNAMES_T = NRNAMES_T + 1
            RNAMES_T(NRNAMES_T) = MON 
          ENDIF
 100      CONTINUE
        ENDDO
      ENDIF
C ----
      IF(LDR_NDER.GT.0) THEN
        DO IM=1,LDR_NDER
          MONN  = LDR_MNAME(IM)
          MON   = MONN
          TYPE  = LDR_TYPE(IM)
          IF(TYPE(1:4).EQ.'L-pe'.OR.TYPE(1:4).EQ.'D-pe'.OR.
     *       TYPE(1:4).EQ.'pept') THEN
            IF(NRNAME_T.GT.0) THEN
              DO I=1,NRNAME_T
                IF(RNAME_T(I).EQ.MON) GO TO 200
              ENDDO
            ENDIF      
            NRNAME_T = NRNAME_T + 1
            RNAME_T(NRNAME_T) = MON 
          ELSE IF(TYPE(1:4).EQ.'poly') THEN
            IF(NRNAMEP_T.GT.0) THEN
              DO I=1,NRNAMEP_T
                IF(RNAMEP_T(I).EQ.MON) GO TO 200
              ENDDO
            ENDIF      
            NRNAMEP_T = NRNAMEP_T + 1
            RNAMEP_T(NRNAMEP_T) = MON 
          ELSE IF(TYPE(1:3).EQ.'DNA'.OR.TYPE(1:3).EQ.'RNA') THEN
            IF(NRNAMED_T.GT.0) THEN
              DO I=1,NRNAMED_T
                IF(RNAMED_T(I).EQ.MON) GO TO 200
              ENDDO
            ENDIF      
            NRNAMED_T = NRNAMED_T + 1
            RNAMED_T(NRNAMED_T) = MON 
          ELSE IF(TYPE(1:4).EQ.'L-py'.OR.TYPE(1:4).EQ.'D-py'.OR.
     *       TYPE(1:4).EQ.'pyra') THEN
            IF(NRNAMES_T.GT.0) THEN
              DO I=1,NRNAMES_T
                IF(RNAMES_T(I).EQ.MON) GO TO 200
              ENDDO
            ENDIF      
            NRNAMES_T = NRNAMES_T + 1
            RNAMES_T(NRNAMES_T) = MON 
          ENDIF
 200      CONTINUE
        ENDDO
      ENDIF
C ----
      RETURN
      END

C ******
      SUBROUTINE SSET_FUSE(CH1,CH2)
C -----------------------------------------
C -P- SET_FUSE - set use_flag = CH1 / "Y" or "N" /
C -S-            set            CH2   
C -----------------------------------------
      CHARACTER CH1*1,CH2*(*)
C ******
      INTEGER*4 L
C -----------------------------------------
      INCLUDE 'lib_com.fh'
C --------------------------------
      IF(LML_NMON.LE.0) RETURN
      DO L=1,LML_NMON
        IF(CH1.EQ.'N') THEN
          LMA_NATOM = 0
          LMN_NCONN = 0
          LMB_NBOND = 0
          LMG_NANGL = 0
          LMT_NTORS = 0
          LMC_NCHIR = 0
          LMP_NPLAN = 0
          DO   I=1,MAXMLIST
            LML_IATOM(I) = 0
            LML_ICONN(I) = 0
            LML_IBOND(I) = 0
            LML_ITHET(I) = 0
            LML_ITORS(I) = 0
            LML_IPLAN(I) = 0
            LML_ICHIR(I) = 0
          ENDDO
        ELSE
          IF(CH1.NE.' ') LML_FUSE (L)   = CH1
        ENDIF
      ENDDO

      RETURN
      END     

C ******
      SUBROUTINE READ_LIB(MDOC,MOD,NODIST,LIST,IERR)
C -------------------------------------------------------
C -P- READ_LIB - reads libraries of monomers and energy parameters.
C -S-
C                MOD - 'A' - all    
C                      'M' - only monomers
C                      'N' - only MOD and LINK
C                      'E' - only ener_lib
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MOD*1,NODIST*1,LIST*1

C ******
C -----------------------------------------------
      INTEGER*4 IEND
      CHARACTER MODE*4
C -----------------------------------------------
      IERR=0
      IEND=0      
C ---
      IF(MOD.EQ.'A'.OR.MOD.EQ.'N') THEN
        CALL RD_MD_LINK_LIB(MDOC,IERR,IEND)
        IF(IERR.NE.0) RETURN
      ENDIF

      IF(MOD.EQ.'A'.OR.MOD.EQ.'M') THEN

        CALL CHECK_FUSE_R(MDOC,IERR)
        CALL RD_MONLIB(MDOC,NODIST,LIST,IERR,IEND)
        IF(IERR.NE.0) RETURN

        CALL SET_FUSE_Y(MDOC,IERR)

      ENDIF
C ---
C     creat list of chemical type of atoms from mon_library 
c      CALL GET_CLIST(MDOC,IERR)    
c      IF(IERR.NE.0) RETURN
C ---
      IF(MOD.EQ.'A'.OR.MOD.EQ.'E') THEN
c       MODE = 'H   '
        MODE = 'ALL '
        IF(MODE.NE.'ALL ') THEN
          CALL GET_CLIST(MDOC,IERR)    
          IF(IERR.NE.0) RETURN
        ENDIF
        CALL RD_ENRLIB(MDOC,MODE,IERR)
        IF(IERR.NE.0) RETURN

        CALL SET_ENER_POINTER_TO_ATOM(MDOC,IERR)
        IF(IERR.NE.0) RETURN
        
      ENDIF

C -----------------------------------
      RETURN
      END     

      SUBROUTINE SET_ENER_POINTER_TO_ATOM(MDOC,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ------
C      REAL      LEA_WEIGHT (MAXETYP)
C      REAL      LEA_RADIUS (MAXETYP)
C      REAL      LEA_HRADIUS(MAXETYP)
C      REAL      LEA_IRADIUS(MAXETYP)
C      REAL      LEA_POLAR  (MAXETYP)
C      REAL      LEA_HPOLAR (MAXETYP)
C      INTEGER*4 LEA_VALENCY(MAXETYP)
C      INTEGER*4 LEA_NATOM,LEA_IATOM
C
C      CHARACTER LEA_ANAME (MAXETYP)*4
C      CHARACTER LEA_ENAME (MAXETYP)*4
C      CHARACTER LEA_HTYPE (MAXETYP)*1
C      CHARACTER LEA_TYPE  (MAXETYP)*1
C
C      REAL      LEB_CONST   (MAXBTYP)
C      REAL      LEB_LENGTH  (MAXBTYP)
C      INTEGER*4 LEB_NBOND,LEB_IBOND
C      INTEGER*4 LEB_I1ATM   (MAXBTYP)
C      INTEGER*4 LEB_I2ATM   (MAXBTYP)
C      CHARACTER LEB_1ATM  (MAXBTYP)*4
C      CHARACTER LEB_2ATM  (MAXBTYP)*4
C      CHARACTER LEB_TYPE  (MAXBTYP)*8
C
C      REAL      LEG_CONST (MAXATYP)
C      REAL      LEG_ANGLE (MAXATYP)
C      INTEGER*4 LEG_NANGL,LEG_IANGL 
C      INTEGER*4 LEG_I1ATM (MAXTTYP)
C      INTEGER*4 LEG_I2ATM (MAXTTYP)
C      INTEGER*4 LEG_I3ATM (MAXTTYP)
C      CHARACTER LEG_1ATM  (MAXATYP)*4
C      CHARACTER LEG_2ATM  (MAXATYP)*4
C      CHARACTER LEG_3ATM  (MAXATYP)*4
C ------------------------------------------------
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4
      CHARACTER LINE*256
C --------------------------------------------------------
      IERR = 0
      IF(LEA_NATOM.LE.0) RETURN

      IF(LEB_NBOND.GT.0) THEN
        DO IB=1,LEB_NBOND
          ATOM1 = LEB_1ATM(IB) 
          DO IA=1,LEA_NATOM
            IF(ATOM1.EQ.LEA_ANAME(IA)) THEN
              LEB_I1ATM(IB) = IA
              GO TO 100  
            ENDIF
          ENDDO
          IERR = 1
          LINE = 'ERROR: ener_lib(bond): atom type:'//ATOM1//
     *    ' not found in the list'
          CALL MSGERR(MDOC,line)
 100      CONTINUE
          ATOM2 = LEB_2ATM(IB)
          DO IA=1,LEA_NATOM
            IF(ATOM2.EQ.LEA_ANAME(IA)) THEN
              LEB_I2ATM(IB) = IA
              GO TO 200  
            ENDIF
          ENDDO
          IERR = 1
          LINE = 'ERROR: ener_lib(bond): atom type:'//ATOM2//
     *    ' not found in the list'
          CALL MSGERR(MDOC,LINE)
 200      CONTINUE
        ENDDO
      ENDIF

      IF(LEG_NANGL.GT.0) THEN
        DO IG=1,LEG_NANGL
          ATOM1 = LEG_1ATM(IG) 
          DO IA=1,LEA_NATOM
            IF(ATOM1.EQ.LEA_ANAME(IA)) THEN
              LEG_I1ATM(IG) = IA
              GO TO 300  
            ENDIF
          ENDDO
          IERR = 1
          LINE = 'ERROR: ener_lib(angle): atom type:'//ATOM1//
     *    ' not found in the list'
          CALL MSGERR(MDOC,LINE)
 300      CONTINUE
          ATOM2 = LEG_2ATM(IG)
          DO IA=1,LEA_NATOM
            IF(ATOM2.EQ.LEA_ANAME(IA)) THEN
              LEG_I2ATM(IG) = IA
              GO TO 400  
            ENDIF
          ENDDO
          IERR = 1
          LINE = 'ERROR: ener_lib(angle): atom type:'//ATOM2//
     *    ' not found in the list'
          CALL MSGERR(MDOC,LINE)
 400      CONTINUE
          ATOM3 = LEG_3ATM(IG)
          DO IA=1,LEA_NATOM
            IF(ATOM3.EQ.LEA_ANAME(IA)) THEN
              LEG_I3ATM(IG) = IA
              GO TO 500  
            ENDIF
          ENDDO
          IERR = 1
          LINE = 'ERROR: ener_lib(angle): atom type:'//ATOM3//
     *    ' not found in the list'
          CALL MSGERR(MDOC,LINE)
 500      CONTINUE
        ENDDO
      ENDIF

      RETURN
      END


C ******
      SUBROUTINE RD_MONLIB(MDOC,NODIST,LIST,IERR,IEND)
C -------------------------------------------------------
C -P- RD_MONLIB - reads library of monomers
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,IEND
      CHARACTER NODIST*1
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---
      COMMON/COM_CRD_CIF/ IEND_CIF      
C ---
C -----------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,IUN,M,IFLAG_MON,IFLAG_MOD,IFLAG_LINK,I,IM
      INTEGER*4 NLIB_LIM
      CHARACTER DATA*80,ITEM*80,BLOCK*8,BLOCK_OLD*8,LIST*1,NODIST_FLAG*1
      CHARACTER LINE*256
      CHARACTER MOD*1,LIB*256,MON*8,CHAR1*1,NAME*256,CH8*8
C ---
      INCLUDE 'crd_com.fh'
C ----------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------
C
C     CALL INIT_CNT
C
      MOD      = 'M'
      LB_PASS  = 0
      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of monomers in library = 0.')
        IERR=1
        RETURN
      ENDIF

      NLIB_LIM = LB_NUMB_LIB

 200  CONTINUE

      LB_PASS    = LB_PASS + 1

      IM = 0
      DO I=1,LML_NMON
        IF(LML_FUSE(I).EQ.'R'.AND.LML_PASS(I).EQ.LB_PASS) IM = IM + 1
      ENDDO

      IF(IM.LE.0) GO TO 410 

      IERR       = 0
      IEND       = 0
      IFLAG_MON  = 0
      IFLAG_MOD  = 0
      IFLAG_LINK = 0
C ------
C     open file of mon_library
C     IUN = 10

      IUN = CRI_IUN
      M   = 99

      IF(LB_PASS.LE.1) THEN

        DO I=1,LML_NMON

          IF(LML_FUSE(I).EQ.'R'.AND.LML_PASS(I).EQ.LB_PASS) THEN

C            IF(LIST.EQ.'T') THEN
C              WRITE(*,*) '-RD:',I,LML_MNAME(I),LML_FUSE(I),LML_PASS(I)
C              WRITE(*,*) '-RD:',lb_pass,';',nodist,';',LMI_FILE(LB_PASS)
C              WRITE(*,*) '-RD:',LMI_FILE(1),';',NLIB_LIM
C            ENDIF

            MON = LML_MNAME(I)
C            CALL LENSTR_BL(LIB,LEN) 

            CHAR1 = MON(1:1)
            IMODE = -1
            CALL CHECK_LINE(IMODE,CHAR1) 
            NAME = LMI_FILE(LB_PASS)
            CALL LENSTR_BL(NAME,LN)
 
            CALL LENSTR_BL(LMI_FILE(2),LLN) 

            NODIST_FLAG = 'N'
            IF(NLIB_LIM.EQ.1.AND.LLN.EQ.1) THEN
              IF(LMI_FILE(2)(1:1).EQ.'Y') NODIST_FLAG = 'Y'
            ENDIF

            IF(NODIST.NE.'Y'.AND.NODIST_FLAG.NE.'Y') THEN
              CH8 = MON
              IF(CH8.EQ.'CD') CH8 ='CD_EL' 
              IF(CH8.EQ.'CR') CH8 ='CR_EL' 
              IF(CH8.EQ.'GD') CH8 ='GD_EL' 
              IF(CH8.EQ.'AR') CH8 ='AR_EL' 
              IF(CH8.EQ.'IR') CH8 ='IR_EL' 
              IF(CH8.EQ.'COM') CH8 ='COM_COM' 
              IMODE = 1
c             convert symbols to upper case
              CALL CHECK_LINE(IMODE,CH8) 
              LIB = CHAR1//'/'//CH8 
            ELSE
              LIB = NAME
            ENDIF

            CALL OPENFR(IUN,M,LMI_PATH,LIB,LMI_EXT,IERR)
            IF(IERR.NE.0) THEN
              CALL LENSTR_BL(LIB,LEN) 
              IF(LEN.GT.50) LEN=50
              IF(LEN.LE.0) THEN
                LEN = 1
                LIB(1:1) = '?'
              ENDIF
              WRITE(LINE,*) ' ERROR: can"t open (lib.):',LIB(1:LEN)
              CALL MSGERR(MDOC,LINE)
              RETURN
            ENDIF

            CALL RD_MONLIB_ONE(MDOC,MOD,IUN,NODIST,LIST,IERR,IEND)
            IF(IERR.NE.0) RETURN

          ENDIF

        ENDDO

        GO TO 410

      ELSE IF(LB_PASS.LE.NLIB_LIM) THEN
        LIB = LMI_FILE(LB_PASS) 
        CALL OPENFR(IUN,M,LMI_PATH,LIB,LMI_EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL LENSTR_BL(LIB,LEN) 
          IF(LEN.GT.50) LEN=50
          IF(LEN.LE.0) THEN
            LEN = 1
            LIB(1:1) = '?'
          ENDIF
          WRITE(LINE,*) ' ERROR: can"t open (lib..)',LIB(1:LEN)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ELSE
        CALL OPENFR(IUN,M,LMI2_PATH,LMI2_FILE,LMI2_EXT,IERR)
        IF(IERR.NE.0) THEN
          LIB = LMI2_FILE
          CALL LENSTR_BL(LMI2_FILE,LEN) 
          IF(LEN.GT.50) LEN=50
          IF(LEN.LE.0) THEN
            LIB = '?'
            LEN = 1
          ENDIF
          WRITE(LINE,*) ' ERROR: can"t open (lib2.)',LIB(1:LEN)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ENDIF

C      CALL OPENFR(IUN,M,LMI_PATH,LMI_FILE,LMI_EXT,IERR)
C      IF(IERR.NE.0) THEN
C        CALL MSGERR(MDOC,' ERROR: can''t open "mon_lib.cif" .')
C        RETURN
C      ENDIF

      CALL RD_MONLIB_ONE(MDOC,MOD,IUN,NODIST,LIST,IERR,IEND)
      IF(IERR.NE.0) RETURN

 410  CONTINUE

      LMI_IUN = 0

      IF(LB_PASS.EQ.NLIB_LIM) THEN
        CALL LENSTR_BL(LMI2_FILE,LEN)
        IF(LEN.GT.0.AND.LMI2_FILE(1:1).NE.','.AND.
     *    LMI2_FILE(1:1).NE.' ') THEN
          GO TO 200
        ENDIF
      ELSE IF(LB_PASS.LT.NLIB_LIM) THEN
        GO TO 200
      ENDIF
C ----
      LB_PASS = 0
      RETURN
      END     

      SUBROUTINE RD_MONLIB_ONE(MDOC,MOD,IUN,NODIST,LIST,IERR,IEND)
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,IEND
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---
      COMMON/COM_CRD_CIF/ IEND_CIF      
C ---
C -----------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,IUN,M,IFLAG_MON,IFLAG_MOD,IFLAG_LINK,I,IM
      INTEGER*4 NLIB_LIM
      CHARACTER DATA*80,ITEM*80,BLOCK*8,BLOCK_OLD*8
      CHARACTER LINE*256,MOD*1,LIB*256,LIST*1,NODIST*1
C ---
      INCLUDE 'crd_com.fh'
C ----------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------
c      LIST = 'N'
C ----
      IERR       = 0
      IEND       = 0
      IFLAG_MON  = 0
      IFLAG_MOD  = 0
      IFLAG_LINK = 0

      LMI_IUN   = IUN
      IEND      = -1
      BLOCK_OLD = '   '
      L_OLD     = -1
      L         = 0
C -------
      IF(IEND.EQ.-1) THEN
        REWIND IUN
        IEND_CIF = -1
        IEND     = 0
      ENDIF

  300 CONTINUE   
      
      CALL GETCIF_INFO(IUN,MDOC,IERR,IEND_CIF)

      IF(IERR.NE.0.OR.(IEND_CIF.NE.0.AND.IEND_CIF.NE.-2)) THEN

        IEND=1
        GO TO 400
C        CLOSE(IUN)
C        LMI_IUN=0
C        RETURN
      ENDIF

      IF(IEND_CIF.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment
C   
        CALL LENSTR_BL(DT_CIF(1),LEND) 
        DATA = DT_CIF(1)(1:LEND)
        GO TO 300
      ENDIF
      
      CALL LENSTR_BL(BLK_CIF,LENB)
      CALL LENSTR_BL(ITL_DCMP,LDCMP)
c     DATA ITL_DCMP      /'data_comp_                              '/

C -- !!  BLK_CIF(1:10) = 'data_comp_XXX

c      IF(LIST.EQ.'T') THEN
c        WRITE(*,*) 'BLK_CIF:',BLK_CIF(1:LDCM)
c      ENDIF

C      LBB = 10
C      LS  = LBB+1
C      LF  = LBB+3

      LS  = LDCMP + 1 
      LF  = LENB

      CALL LENSTR_BL(DT_CIF(1),LEND) 
      DATA = DT_CIF(1)(1:LEND)

      IF(N_CIF.EQ.0) THEN

        CALL LENSTR_BL(ITL_DCMP,LDCM) 

C        IF(LENB.GE.LS.AND.LENB.LE.LF.AND.
C     *            BLK_CIF(1:LBB).EQ.'data_comp_') THEN

        IF(BLK_CIF(1:LDCM).EQ.ITL_DCMP(1:LDCM)) THEN

          LB = LENB
C         IF(LB.GT.13) LB = 13
          BLOCK = BLK_CIF(LS:LB)
c          IF(LB.LT.LF    ) BLOCK(3:3) = ' '
c          IF(LB.LT.(LF-1)) BLOCK(2:2) = ' '

          IF(BLOCK.NE.BLOCK_OLD) THEN
            IF(LML_NMON.LE.0) THEN
              CALL MSGERR(MDOC
     *        ,' ERROR: number of monomers in library = 0')
              IERR = 1
              CLOSE(IUN,ERR=440)
 440          CONTINUE
              LMI_IUN = 0
              RETURN
            ENDIF
            DO L=1,LML_NMON
              IF(BLOCK.EQ.LML_MNAME(L)) THEN
                BLK_FLAG = LML_FUSE(L)
                BLK_FLAG = 'Y'
                LML_IMON = L

                IF(LIST.EQ.'T') THEN
                  WRITE(*,*) 'RM_ONE:',L,LML_MNAME(L),LML_FUSE(L),L_OLD
                ENDIF

                IF(L_OLD.GT.0) THEN
                  IF(LML_FUSE(L_OLD).EQ.'R') THEN
                    CALL CHECK_RLIB_TREE(MDOC,LIST,L_OLD,IERR)
                  ENDIF
                ENDIF

                L_OLD = L
                GO TO 100
              ENDIF
            ENDDO
            BLK_FLAG = 'N'

  100       CONTINUE
            BLOCK_OLD = BLOCK
          ENDIF
        ENDIF
        GO TO 300
      ENDIF

      CALL LENSTR_BL(DT_CIF(1),LEND) 
      DATA = DT_CIF(1)(1:LEND)


      DO I=1,N_CIF

        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM  = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA  = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IDATA = IDT_CIF(I)
        FDATA = FDT_CIF(I)

c       IF(ITEM(1:16).EQ.'_chem_comp_atom.') IFLAG_MON = 1
c       IF(ITEM(1:15).EQ.'_chem_mod_atom.')  IFLAG_MOD = 1
c       IF(ITEM(1:16).EQ.'_chem_link_bond.') IFLAG_LINK = 1

        CALL LENSTR_BL(ITL_CMPA,LCMA)
        CALL LENSTR_BL(ITL_MODA,LMDA)
        CALL LENSTR_BL(ITL_LNKB,LLNB)
        IF(ITEM(1:LCMA).EQ.ITL_CMPA(1:LCMA)) IFLAG_MON  = 1
        IF(ITEM(1:LMDA).EQ.ITL_MODA(1:LMDA)) IFLAG_MOD  = 1
        IF(ITEM(1:LLNB).EQ.ITL_LNKB(1:LLNB)) IFLAG_LINK = 1


C       DATA ITL_CMP       /'_chem_comp.                             '/
C       DATA ITL_MOD       /'_chem_mod.                              '/
C       DATA ITL_LNK       /'_chem_link.                             '/

        CALL LENSTR_BL(ITL_CMP,LCM)
        CALL LENSTR_BL(ITL_MOD,LMD)
        CALL LENSTR_BL(ITL_LNK,LLN)

        IF(BLK_CIF(1:7) .EQ.'global_') THEN         

        ELSE IF(ITEM(1:LCM-1).EQ.ITL_CMP(1:LCM-1).AND.
     *            BLK_CIF(1:LENB).NE.'data_comp_list') THEN

          IF(MOD.NE.'N') THEN

c            IF(LIST.EQ.'T') THEN
c              WRITE(*,*) 'RM_ONE::',I,L
c              WRITE(*,*) 'RM_ONE::',I,L,LML_FUSE(L)
c            ENDIF

            IF(LML_FUSE(L).EQ.'R') THEN

            CALL PUT_MNLIB(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *      ,DATA,IDATA,FDATA,LEND,IERR)
            IF(IERR.NE.0) THEN
              CLOSE(IUN)
              LMI_IUN = 0
              RETURN
            ENDIF

            ENDIF

          ENDIF 

        ELSE IF(ITEM(1:LMD-1).EQ.ITL_MOD(1:LMD-1)) THEN

C          IF(MOD.EQ.'M'.AND.IFLAG_MON.EQ.1) GO TO 400 

        ELSE IF(ITEM(1:LLN-1).EQ.ITL_LNK(1:LLN-1)) THEN

C          IF(MOD.EQ.'M'.AND.IFLAG_MON.EQ.1) GO TO 400 

        ENDIF

      ENDDO
      GO TO 300
C -----------------------------------
 400  CONTINUE

c      IF(LIST.EQ.'T') THEN
c        WRITE(*,*) 'RM_ONE-:',L_OLD
c        WRITE(*,*) 'LML_PASS:',LML_PASS(L_OLD),LML_FUSE(L_OLD)
c      ENDIF

      IF(L_OLD.GT.0) THEN
      IF(L_OLD.GT.1.OR.LML_PASS(L_OLD).GT.1.OR.NODIST.EQ.'Y') THEN
        IF(LML_FUSE(L_OLD).EQ.'R') THEN
          CALL CHECK_RLIB_TREE(MDOC,LIST,L_OLD,IERR)
        ENDIF
      ENDIF
      ENDIF

      CLOSE(IUN,ERR=410)
 410  CONTINUE
      RETURN
      END

      SUBROUTINE CHECK_RLIB_TREE(MDOC,LIST,L,IERR)                 
C ----------------------------------------
C     L =< 0 from L1 (not cp_mlib) ; l = 0 cpl_mlib with  L1L_FUSE = 'C'
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER ASYMB*4,CTYPE*4,MON*8,LIST*1,TREE*1,PNUM*12
      CHARACTER MODE*4,LINE*256
C ----------------------------------------

      IF(L.GT.0) THEN
        MON = LML_MNAME(L)
        IF(LIST.EQ.'T') THEN
          write(line,*) '--check_rlib:',l,LML_NMON,mon
          CALL MSGDOC(MDOC,LINE)
          write(line,*) '---fused,pass:',LML_FUSE(l),LML_PASS(l)
          CALL MSGDOC(MDOC,LINE)
        ENDIF

        IA        = LML_IATOM(L)
        CALL COUNT_NATOM_LIB(MDOC,MON,IA,NATOM,NHATOM,IERR)
        IF(IERR.NE.0) RETURN

        IF(LIST.EQ.'T') THEN
          write(line,*) '--ia,na,nha:',ia,NATOM,NHATOM
          CALL MSGDOC(MDOC,LINE)
        ENDIF

        LML_NATM  (L) = NATOM
        LML_NHATM (L) = NHATOM

        LML_FUSE(L) = 'Y'
        CALL CP_MLIB(MDOC,MON,IERR)
        IF(IERR.NE.0) THEN
          IF(LIST.EQ.'T') THEN
            write(line,*) '--cp_mlib:',ierr
            CALL MSGDOC(MDOC,LINE)
          ENDIF
          RETURN
        ENDIF
C ---
        IF(L1B_NBOND.GE.2.AND.L1G_NANGL.LE.0) THEN
          L1L_PRSNT    = 'M'
          LML_PRSNT(L) = 'M' 
        ENDIF
C ---
      ELSE
        MON = L1L_MNAME
        IF(LIST.EQ.'T') THEN
          write(line,*) '--check_rlib:',l,mon,L1A_NATOM
          CALL MSGDOC(MDOC,LINE)
        ENDIF
      ENDIF

      NA   = L1A_NATOM
      IF(NA.LE.1) RETURN

      TREE = 'N'
      DO I=1,NA
        IF(L1A_BACK(I).NE.'.') TREE = 'Y'
      ENDDO
      IF(L.GT.0) THEN
        IF(LML_PASS(L).GT.1) TREE = 'N'
      ENDIF

      CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITYPE_RES,IERR)

      IF(LIST.EQ.'T') THEN
c        call WRITE_LIB_RES_TYPE_TAB(MDOC,IERR)
        write(*,*) '-- ini_res_type:',mon,itype_res
      ENDIF               

      CALL PRECHECK_L1_MON_DESCRIPTION(MDOC,LIST,IERR)
      IF(IERR.NE.0) THEN
        IF(IERR.LT.100) TREE = 'N'
        IERR = 0
      ENDIF
      L1A_ISTART  = 0
      L1A_IFINISH = 0
      DO I=1,NA
        L1A_INEW (I) = I 
        L1A_IOLD (I) = I
        L1A_ICHEM(I) = 0              
        L1A_ICR  (I) = 0
        L1A_NDIST(I) = 0
        L1A_IBACK(I) = 0
        L1A_IFORW(I) = 0
C        L1A_BACK (I) = '.'
C        L1A_TYPE (I) = '.' 
C        L1A_FORW (I) = '.'
        DO  J=1,MAX1BRN 
          L1A_CONN   (J,I) = 0
          L1A_LENCON (J,I) = 0
        ENDDO
        DO  J=1,MAX1EXT 
          L1A_TEXTR (J,I) = 0
          L1A_IEXTR (J,I) = 0
        ENDDO
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *     ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *     ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
          CTYPE='C   '
        ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
          CTYPE='H   '
          L1A_NHATOM   = L1A_NHATOM + 1
        ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
          CTYPE='P   '
        ELSE
          CTYPE='$   '
        ENDIF
        L1A_ATYPE(I)=CTYPE(1:1)
      ENDDO
C --
      MODE=' '
      CALL LIB_CONN(MDOC,MODE,IERR)
C --
      IF(LIST.EQ.'T') THEN
        NA   = L1A_NATOM
        write(line,*) '-- before ring -- prsnt,tree:'
     *   ,L1L_PRSNT,':',TREE,':'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     * '(i2,1x,a,1x,2i4,1x,i3,1x,1x,i3,1x,'';'',6i3,'';'',6i3,A)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_icr(Ia),L1A_ichem(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5),L1A_CHEM(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF

  
      IF(L1L_PRSNT.NE.'M') THEN

        IF(TREE.EQ.'Y') THEN
          PNUM = '       '
          CALL SET_NUM_MOD(MDOC,MON,PNUM,IERR)

          IF(LIST.EQ.'T') THEN
            NA   = L1A_NATOM
            write(line,*) '-- after SET_NUM_MOD  --',mon
            CALL MSGDOC(MDOC,LINE)
            write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
            CALL MSGDOC(MDOC,LINE)
            DO    IA=1,NA
              write(line,
     * '(i2,1x,a,1x,2i4,1x,i3,1x,1x,i3,1x,'';'',6i3,'';'',6i3,A)') 
     *        ia,l1a_aname(ia)
     *        ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_icr(Ia),L1A_ichem(Ia)
     *        ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *        ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5),L1A_CHEM(IA)
              CALL MSGDOC(MDOC,LINE)
            ENDDO
          ENDIF

c         CALL CHECK_RES_TYPE(MDOC,ITYPE_RES,IERR)
c          CALL CHECK_RES_TYPE_BY_ATOM_AND_BOND
c     *                                  (MDOC,ITYPE_RES,IERR)
          IF(LIST.EQ.'T') THEN
            write(*,*) '-- itype_res:',itype_res
          ENDIF               

          IF(IERR.EQ.0) THEN
            CALL CHECK_TREE_DIRECTION(MDOC,LIST,ITYPE_RES,IERR)
            IF(IERR.NE.0) THEN
              TREE = 'N'
              IERR = 0
            ENDIF
          ENDIF
        ENDIF

        IF(LIST.EQ.'T') THEN
          WRITE(LINE,*) '== before ring: tree,ierr:',TREE,';',IERR
          call msgdoc(mdoc,line)
        endif

        IF(TREE.EQ.'N') THEN
C ---
C         define rings
          IPRSNT = 1
          CALL RING(MDOC,LIST,NRING,IPRSNT,IERR)
C ---
C         create tree like structure
          IF(LIST.EQ.'T') THEN
            WRITE(LINE,*) '== create tree: tree,ierr',TREE,';',IERR
            call msgdoc(mdoc,line)
          ENDIF

          CALL CREATE_TREE_NEW(MDOC,LIST,IERR)
          IF(LIST.EQ.'T') THEN
             WRITE(LINE,*) '== set_num_mod:',TREE,';',IERR
           call msgdoc(mdoc,line)
          ENDIF
          PNUM = '       '
          CALL SET_NUM_MOD(MDOC,MON,PNUM,IERR)
          IF(IERR.EQ.0) THEN

c           CALL CHECK_RES_TYPE(MDOC,ITYPE_RES,IERR)
c            CALL CHECK_RES_TYPE_BY_ATOM_AND_BOND
c     *                                  (MDOC,ITYPE_RES,IERR)

            CALL CHECK_TREE_DIRECTION(MDOC,LIST,ITYPE_RES,IERR)
C ---
            IF(IERR.EQ.0) TREE = 'C'
          ENDIF
C          IERR = 0
        ENDIF

      ENDIF
C ---------
      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '== before end:',TREE,';',IERR
        call msgdoc(mdoc,line)
        NA     = L1A_NATOM
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
C ---
      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '-- end check_rlib, tree,ierr:',TREE,';',IERR
        call msgdoc(mdoc,line)
      ENDIF


      IF(IERR.NE.0) RETURN

      IF(TREE.EQ.'C'.OR.L.EQ.0) THEN
        L1L_FUSE = 'Y'
        IF(L.LE.1) L1L_FUSE   = 'C'
        CALL CPL_MLIB(MDOC,IERR)
      ENDIF
C ----------------------------------------
      RETURN
      END

      SUBROUTINE CHECK_TREE_DIRECTION(MDOC,LIST,ITYPE_RES,IERR)
C -----------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256
      CHARACTER ATOMS*4,ATOMF*4,ATOM*4,MON*8,TREE*1,LIST*1
C -----------------------------

      IERR = 0
      MON  = L1L_MNAME
      NA   = L1A_NATOM
      IF(NA.LE.2) RETURN
C      CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITYPE_RES,IERR)

      IF(ITYPE_RES.EQ.5.OR.ITYPE_RES.EQ.6.OR.ITYPE_RES.EQ.7.OR.
     *   ITYPE_RES.EQ.8.OR.ITYPE_RES.EQ.3.OR.ITYPE_RES.EQ.4.OR.
     *                                      ITYPE_RES.EQ.10) THEN

        IF(ITYPE_RES.EQ.5.OR.ITYPE_RES.EQ.6) THEN
C         P -> O5* - C5*  - C4* = C3* -> O3*
          ATOMS = 'O5* '
          DO I=1,NA
            ATOM = L1A_ANAME(I)
            IF(ATOM.EQ.'O3T ') ATOMS = 'O3T '
            IF(ATOM.EQ.'P   '.AND.ATOMS.NE.'O3T ') ATOMS = 'P   '
          ENDDO
          ATOMF = 'O3* '
        ELSE IF(ITYPE_RES.EQ. 7.OR.ITYPE_RES.EQ.8) THEN
C         C1 -> C2 -> C3 -> C4 -> C5 -> O5
          ATOMS = 'C1  '
          ATOMF = 'O5  '
        ELSE IF(ITYPE_RES.EQ.3.OR.ITYPE_RES.EQ.4.OR.
     *                                      ITYPE_RES.EQ.10) THEN
C         N -> CA -> C
          ATOMS = 'N   '
          ATOMF = 'C   '
        ENDIF
C         
        ISTART  = 0
        IFINISH = 0
        DO I=1,NA
          ATOM = L1A_ANAME(I)
          IF(ATOM.EQ.ATOMS) ISTART  = I
          IF(ATOM.EQ.ATOMF) IFINISH = I
        ENDDO

        TREE = 'Y'

        IF(LIST.EQ.'T') THEN
        write(*,*) 'corr sl,fl:',l1a_istart,l1a_ifinish
        write(*,*) '     is,if:',istart,ifinish
        write(*,*) '   itype_r:',itype_res
        NA     = L1A_NATOM
        LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF

        IF(TREE.EQ.'Y'.AND.
     *    ((ISTART .NE.0.AND.ISTART .NE.L1A_ISTART ).OR.
     *     (IFINISH.NE.0.AND.IFINISH.NE.L1A_IFINISH)    )) THEN
          IF(ISTART.EQ.L1A_IFINISH.AND.ISTART.GT.0) THEN
            ITYPE = 0
            CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)

            IF(LIST.EQ.'T') THEN
            write(*,*) '  it:',itype,l1a_istart,l1a_ifinish,IERR
             NA     = L1A_NATOM
            LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
            CALL MSGDOC(MDOC,LINE)
            DO    IA=1,NA
            write(line,
     *      '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *      ia,l1a_aname(ia)
     *      ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *      ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *      ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
            CALL MSGDOC(MDOC,LINE)
            ENDDO
            ENDIF

            IF(IERR.NE.0) THEN
              TREE = 'N'
              IERR = 0
              GO TO 200
            ENDIF
          ENDIF
          IF(ISTART.NE.L1A_ISTART.AND.ISTART.GT.0) THEN
            ITYPE = 1
            CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)

            IF(LIST.EQ.'T') THEN
            write(*,*) '  it:',itype,l1a_istart,l1a_ifinish,IERR
            NA     = L1A_NATOM
            LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
            CALL MSGDOC(MDOC,LINE)
            DO    IA=1,NA
            write(line,
     *    '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *      ia,l1a_aname(ia)
     *      ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *      ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *      ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
            CALL MSGDOC(MDOC,LINE)
            ENDDO
            ENDIF

            IF(IERR.NE.0) THEN
              TREE = 'N'
              IERR = 0
              GO TO 200
            ENDIF
          ENDIF
          IF(IFINISH.NE.L1A_IFINISH.AND.IFINISH.GT.0) THEN
            ITYPE = 2
            CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)

            IF(LIST.EQ.'T') THEN
            write(*,*) '  it:',itype,l1a_istart,l1a_ifinish,IERR
            NA     = L1A_NATOM
            LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
            CALL MSGDOC(MDOC,LINE)
            DO    IA=1,NA
            write(line,
     *    '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *      ia,l1a_aname(ia)
     *      ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *      ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *      ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
            CALL MSGDOC(MDOC,LINE)
            ENDDO
            ENDIF

            IF(IERR.NE.0) THEN
              TREE = 'N'
              IERR = 0
              GO TO 200
            ENDIF
          ENDIF
        ENDIF
 200    CONTINUE
        IF(TREE.EQ.'N') IERR = 1

        IF(LIST.EQ.'T') THEN
        write(*,*) '  NEW:',l1a_istart,l1a_ifinish,IERR
        NA     = L1A_NATOM
        LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF

      ENDIF
C ----
      RETURN
      END



      SUBROUTINE CREATE_TREE_NEW(MDOC,LIST,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256,ASYMB*4,ATOM1*4,ATOM2*4
      CHARACTER MON*8,LIST*1
C --------------------------------
      IERR = 0
C     M    =-ABS(MDOC)-1
C ---
C      LIST = 'N'
C      LIST = 'T'

      NA     = L1A_NATOM
      MON    = L1L_MNAME        

      IF(NA.LE.0) THEN
        IERR=1
        RETURN
      ENDIF

      CALL PRECHECK_RES_TYPE(MDOC,ITYPE_RES,IERR)


C     store : L1A_LENCON(1,IA) in  L1A_IOLD(IA) 
C     copy L1A_CONN(J,IA) to L1A_LENCON(J,IA)
      DO IA=1,NA
        L1A_IOLD(IA)=L1A_LENCON(1,IA)
        IF(L1A_NDIST(IA).GT.0) THEN
          DO J=1,L1A_NDIST(IA)
C            L1A_LENCON(J,IA)= L1A_CONN(J,IA)
c ---  7.07.03         
            L1A_LENCON(J,IA)= ABS(L1A_CONN(J,IA))
C ---
          ENDDO
        ENDIF
      ENDDO

C -----
C     NC - total number of connect.
C     L1A_NEXTR(I) - number of connect. for Ith atom.
C
      NC=0
      DO I=1,NA
        L1A_NEXTR(I)=0
        IF(L1A_NDIST(I).GT.0) THEN
          DO J=1,L1A_NDIST(I)
            IF(L1A_LENCON(J,I).GT.0) THEN
              NC=NC+1
              L1A_NEXTR(I)=L1A_NEXTR(I)+1
            ENDIF
          ENDDO
        ENDIF

        L1A_BACK (I) = '.'
        L1A_IBACK(I) = 0
        L1A_FORW (I) = '.'
        L1A_IFORW(I) = 0

        IF(L1B_NBOND.EQ.0) THEN
C         no bonds
          IF(I.EQ.NA) THEN
            L1A_FORW(I)= 'END'
            I_LAST     = I
          ENDIF
          IF(I.EQ.1) THEN
            L1A_BACK(I)  = '.'
            L1A_IBACK(I) = 0
            I_FIRST      = I
          ENDIF
          IF(I.GT.1) THEN
            L1A_BACK (I) = L1A_ANAME(I-1)
            L1A_IBACK(I) = I-1
            L1A_TYPE (I) = 'DUMMY' 
          ENDIF
          IF(I.LT.NA) THEN
            L1A_FORW (I) = L1A_ANAME(I+1)
            L1A_IFORW(I) = I+1
          ENDIF
        ENDIF

      ENDDO

      IF(L1B_NBOND.EQ.0) GO TO 300

C
C ---- definition back's atoms and last atom
C

      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        LINE='1:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF



      IFIRST    = 0
      IFIRST_NH = 0
      IFIRST_NR = 0
      ICYCLE    = 0
      I_LAST    = 0
      I_LAST_NH = 0
      I_LAST_NR = 0
      NH_NR     = 1000
      NH_NH     = 1000
      NL_NR     = 1000
      NL_NH     = 1000

      DO WHILE ( NC .GT. 1 )    

        NC_OLD = NC
        DO I=NA,1,-1

          NDI = L1A_NDIST(I)
          NCN = L1A_NEXTR(I)

          IF(NDI.GT.0.AND.NCN.EQ.1) THEN
C           now only 1 connect. for Ith atom (NCN=1)             
            DO IC=1,NDI
              IP = L1A_LENCON(IC,I)
              IF(IP.GT.0) THEN
C               remove this connect. and set back atom IP
C                                          IP --> I
                NC           = NC-1
                L1A_NEXTR(I) = 0
                L1A_BACK (I) = L1A_ANAME(IP)
                L1A_IBACK(I) = IP

                IF(IFIRST.EQ.0) THEN
C                 last atom
                  I_LAST = I
                  IFIRST = 1
                ENDIF
           
                IF(IFIRST_NH.EQ.0.AND.ICYCLE.LT.1) THEN
C                 first no H atom   
                  ASYMB = L1A_SYMB(I)
                  IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ')THEN
                    NH = L1A_IOLD(I)
                    NL = L1A_NDIST(I)-NH
C                   NL number of noH atoms, keep atom with min NL 
                    IF(NL.EQ.NL_NH) THEN
C                     with min number of H atoms
                      IF(NH.LT.NH_NH) THEN
                        I_LAST_NH = I
c                       IFIRST_NH = 1
                        NH_NH = NH
                      ENDIF
                    ELSE IF(NL.LT.NL_NH) THEN
                      I_LAST_NH = I
c                     IFIRST_NH = 1
                      NH_NH     = NH
                      NL_NH     = NL
                    ENDIF
                  ENDIF
                ENDIF
           
                IF(IFIRST_NR.EQ.0.AND.ICYCLE.LT.1) THEN
C                 first no H atom and not in the ring     
                  ASYMB = L1A_SYMB(I)
                  IF((ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ')
     *               .AND.L1A_NRING(I).LE.0) THEN
                    NH = L1A_IOLD(I)
                    NL = L1A_NDIST(I)-NH
C                   NL number of noH and no RING atoms, keep atom with min NL 
                    IF(NL.EQ.NL_NR) THEN
C                     with min number of H atoms
                      IF(NH.LT.NH_NR) THEN
                        I_LAST_NR = I
c                       IFIRST_NR = 1
                        NH_NR=NH
                      ENDIF
                    ELSE IF(NL.LT.NL_NR) THEN
                      I_LAST_NR = I
c                     IFIRST_NR = 1
                      NH_NR     = NH
                      NL_NR     = NL
                    ENDIF
                  ENDIF
                ENDIF

C               correction for back atom of Ith atom after removing 
C               current connection IP --> I
                NDIP  = L1A_NDIST(IP)
                NCNIP = L1A_NEXTR(IP)
                IF(NDIP.GT.0.AND.NCNIP.GT.0) THEN
                  ITEMP = 0
                  DO IPC=1,NDIP
                    IPP = L1A_LENCON(IPC,IP)
                    IF(IPP.GT.0.AND.IPP.EQ.I) THEN
                      ITEMP = 1
                      GO TO 100
                    ENDIF
                  ENDDO

 100              CONTINUE
                  IF(ITEMP.EQ.1) THEN
                    NC = NC-1                 
                    IF(L1A_FORW(IP).EQ.'.') THEN
                      L1A_FORW(IP)  = L1A_ANAME(I)
                      L1A_IFORW(IP) = I
                    ENDIF
                    L1A_NEXTR(IP)      = L1A_NEXTR(IP)-1
                    L1A_LENCON(IPC,IP) = 0
                  ENDIF
                ENDIF

              ENDIF
            ENDDO
          ENDIF
        ENDDO

        ICYCLE = ICYCLE + 1

            IF(LIST.EQ.'T') THEN
            WRITE(*,*) '->ICYCLE,NC:',ICYCLE,NC            
            ENDIF

      IF(ICYCLE.EQ.1) THEN 
      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        LINE='ic=1:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
      ENDIF

        IF(NC_OLD.EQ.NC) THEN
C         was not removing in this cycle 
C         it is ring. remove 1 connection 

          ITEMP=0


          IF(ITYPE_RES.EQ.5.OR.ITYPE_RES.EQ.6.OR.ITYPE_RES.EQ.7.OR.
     *       ITYPE_RES.EQ.8.OR.ITYPE_RES.EQ.3.OR.ITYPE_RES.EQ.4.OR.
     *                                      ITYPE_RES.EQ.10) THEN

          IF(LIST.EQ.'T') THEN
            WRITE(*,*) 'ITYPE_RES:',ITYPE_RES            
          ENDIF
 
C         remove if not backbone 
          DO I=1,NA
            ATOM1 = L1A_ANAME(I)
            NDI = L1A_NDIST(I)
            NCN = L1A_NEXTR(I)
            IF(NDI.GT.0.AND.NCN.EQ.2) THEN
C             Ith atom has 2 connections
C             remove one , it would be extra connection             
              DO II=1,L1A_NDIST(I)
                IF(L1A_LENCON(II,I).GT.0) THEN
                  J                = L1A_LENCON(II,I)
                  ATOM2 = L1A_ANAME(J)

                  IF(ITYPE_RES.EQ. 5.OR.ITYPE_RES.EQ.6) THEN
C                   P -> O5* - C5*  - C4* = C3* -> O3*

                    IF((ATOM1.EQ.'C4* '.AND.ATOM2.EQ.'C3* ').OR.
     *                 (ATOM2.EQ.'C4* '.AND.ATOM1.EQ.'C3* ')) GO TO 400

                  ELSE IF(ITYPE_RES.EQ. 7.OR.ITYPE_RES.EQ.8) THEN
C                   C1 -> C2 -> C3 -> C4 -> C5 -> O5

                    IF((ATOM1.EQ.'C1  '.AND.ATOM2.EQ.'C2  ').OR.
     *                 (ATOM2.EQ.'C1  '.AND.ATOM1.EQ.'C2  ')) GO TO 400
                    IF((ATOM1.EQ.'C2  '.AND.ATOM2.EQ.'C3  ').OR.
     *                 (ATOM2.EQ.'C2  '.AND.ATOM1.EQ.'C3  ')) GO TO 400
                    IF((ATOM1.EQ.'C3  '.AND.ATOM2.EQ.'C4  ').OR.
     *                 (ATOM2.EQ.'C3  '.AND.ATOM1.EQ.'C4  ')) GO TO 400
                    IF((ATOM1.EQ.'C4  '.AND.ATOM2.EQ.'C5  ').OR.
     *                 (ATOM2.EQ.'C4  '.AND.ATOM1.EQ.'C5  ')) GO TO 400
                    IF((ATOM1.EQ.'C5  '.AND.ATOM2.EQ.'O5  ').OR.
     *                 (ATOM2.EQ.'C5  '.AND.ATOM1.EQ.'O5  ')) GO TO 400

                  ELSE IF(ITYPE_RES.EQ.3.OR.ITYPE_RES.EQ.4.OR.
     *                                      ITYPE_RES.EQ.10) THEN
C                   N -> CA -> C
                    IF((ATOM1.EQ.'N   '.AND.ATOM2.EQ.'CA  ').OR.
     *                 (ATOM2.EQ.'N   '.AND.ATOM1.EQ.'CA  ')) GO TO 400

                  ENDIF

c                  L1A_LENCON(II,I) = - L1A_LENCON(II,I)
c                  L1A_NEXTR(I)     =  L1A_NEXTR(I) - 1
                  DO IJ=1,L1A_NDIST(J)
                    IF(L1A_LENCON(IJ,J).GT.0.AND.
     *                 L1A_LENCON(IJ,J).EQ.I     ) THEN
                      CALL CHECK_RING_FOR_TREE(NA,IRING,I,J,L1A_NDIST
     *                  ,L1A_NEXTR,L1A_LENCON,L2A_ICR,L2A_IBACK
     *                  ,L2B_I1ATM,L2B_I2ATM,MAX1BRN,MAX1ATM,MAX1BND)  
                      IF(IRING.GT.0) THEN
                        L1A_LENCON(II,I) = - L1A_LENCON(II,I)
                        L1A_NEXTR(I)     =  L1A_NEXTR(I) - 1
                        JJ               = L1A_LENCON(IJ,J)
                        L1A_LENCON(IJ,J) = - L1A_LENCON(IJ,J)
                        L1A_NEXTR(J)     = L1A_NEXTR(J)-1
                        ITEMP = 4
                        NC    = NC-2

                        IF(LIST.EQ.'T') THEN
                          WRITE(*,*) 'ITEMP_b,I,J:',ITEMP,I,J,NC            
                        ENDIF

                        GO TO 200
                      ENDIF
                    ENDIF
                  ENDDO

                ENDIF
 400            CONTINUE
              ENDDO                 
            ENDIF
          ENDDO
          ENDIF
C  
          DO I=1,NA
            NDI = L1A_NDIST(I)
            NCN = L1A_NEXTR(I)
            IF(NDI.GT.0.AND.NCN.EQ.2) THEN
C             Ith atom has 2 connections
C             remove one , it would be extra connection             
              DO II=1,L1A_NDIST(I)
                IF(L1A_LENCON(II,I).GT.0) THEN
                  J                = L1A_LENCON(II,I)
c                  L1A_LENCON(II,I) = - L1A_LENCON(II,I)
c                  L1A_NEXTR(I)     =  L1A_NEXTR(I) - 1
                  DO IJ=1,L1A_NDIST(J)
                    IF(L1A_LENCON(IJ,J).GT.0.AND.
     *                 L1A_LENCON(IJ,J).EQ.I     ) THEN
                      CALL CHECK_RING_FOR_TREE(NA,IRING,I,J,L1A_NDIST
     *                  ,L1A_NEXTR,L1A_LENCON,L2A_ICR,L2A_IBACK
     *                  ,L2B_I1ATM,L2B_I2ATM,MAX1BRN,MAX1ATM,MAX1BND)  
                      IF(IRING.GT.0) THEN
                        L1A_LENCON(II,I) = - L1A_LENCON(II,I)
                        L1A_NEXTR(I)     =  L1A_NEXTR(I) - 1
                        JJ               = L1A_LENCON(IJ,J)
                        L1A_LENCON(IJ,J) = - L1A_LENCON(IJ,J)
                        L1A_NEXTR(J)     = L1A_NEXTR(J)-1
                        ITEMP = 3
                        NC    = NC-2

                        IF(LIST.EQ.'T') THEN
                          WRITE(*,*) 'ITEMP_r,I,J:',ITEMP,I,J,NC
                        ENDIF

                        GO TO 200
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF
              ENDDO                 
            ENDIF
          ENDDO
C        
          DO I=1,NA
            NDI = L1A_NDIST(I)
            NCN = L1A_NEXTR(I)
            IF(NDI.GT.0.AND.NCN.EQ.2) THEN
              DO II=1,L1A_NDIST(I)
                IF(L1A_LENCON(II,I).GT.0) THEN
                  J                = L1A_LENCON(II,I)
c                  L1A_LENCON(II,I) = - L1A_LENCON(II,I)
c                  L1A_NEXTR(I)     =  L1A_NEXTR(I)- 1
                  DO IJ=1,L1A_NDIST(J)
                    IF(L1A_LENCON(IJ,J).GT.0.AND.
     *                 L1A_LENCON(IJ,J).EQ.I     ) THEN
                      L1A_LENCON(II,I) = - L1A_LENCON(II,I)
                      L1A_NEXTR(I)     =  L1A_NEXTR(I)- 1
                      JJ               = L1A_LENCON(IJ,J)
                      L1A_LENCON(IJ,J) =-L1A_LENCON(IJ,J)
                      L1A_NEXTR(J)     = L1A_NEXTR(J)-1
                      ITEMP = 2
                      NC    = NC-2

                      IF(LIST.EQ.'T') THEN
                        WRITE(*,*) 'ITEMP1,I,J:',ITEMP,I,J,NC            
                      ENDIF

                      GO TO 200
                    ENDIF
                  ENDDO
                ENDIF
              ENDDO
            ENDIF
          ENDDO                     
C        
          DO I=1,NA
            NDI = L1A_NDIST(I)
            NCN = L1A_NEXTR(I)
            IF(NDI.GT.0.AND.NCN.GT.2) THEN
              DO II=1,L1A_NDIST(I)
                IF(L1A_LENCON(II,I).GT.0) THEN
                  J                = L1A_LENCON(II,I)
c                  L1A_LENCON(II,I) = - L1A_LENCON(II,I)
c                  L1A_NEXTR(I)     = L1A_NEXTR(I) - 1
                  DO IJ=1,L1A_NDIST(J)
                    IF(L1A_LENCON(IJ,J).GT.0.AND.
     *                 L1A_LENCON(IJ,J).EQ.I     ) THEN
                      L1A_LENCON(II,I) = - L1A_LENCON(II,I)
                      L1A_NEXTR(I)     = L1A_NEXTR(I) - 1
                      JJ               = L1A_LENCON(IJ,J)
                      L1A_LENCON(IJ,J) =-L1A_LENCON(IJ,J)
                      L1A_NEXTR(J)     = L1A_NEXTR(J)-1
                      ITEMP = 1
                      NC    = NC-2

                      IF(LIST.EQ.'T') THEN
                        WRITE(*,*) 'ITEMP1,I,J:',ITEMP,I,J,NC            
                      ENDIF

                      GO TO 200
                    ENDIF
                  ENDDO
                ENDIF
              ENDDO
            ENDIF
          ENDDO                     

 200      CONTINUE

C         if ITEMP=0 not any removing, ???   

          IF(LIST.EQ.'T') THEN
            IF(ITEMP.LE.0) THEN
              WRITE(*,*) '>ITEMP NC:',ITEMP,NC            

        NA     = L1A_NATOM
        LINE='ic=1:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO

            ENDIF
          ENDIF

          IF(ITEMP.LE.0) THEN
            CALL MSGERR(MDOC,' ERROR: can not create tree structure')
            IERR = 1
            RETURN
          ENDIF
 
        ENDIF

      ENDDO


      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        LINE='2:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF




C
C ---- end definition back's atoms and last atom
C
      
      IF(LIST.EQ.'T') THEN
      write(LINE,*) ' last:',i_last,i_last_nh,i_last_nr,nh_nh,nh_nr
      CALL MSGDOC(MDOC,LINE)
      ENDIF
                       
      IF(I_LAST_NR.GT.0) THEN
C       last atom is no RING and no H atom
        I_LAST = I_LAST_NR
      ELSE IF(I_LAST_NH.GT.0) THEN
C       last atom is no H atom
        I_LAST = I_LAST_NH
      ENDIF

      L1A_FORW(I_LAST)   = 'END'
      L1A_IFORW(I_LAST)  = 0

      IF(NA.GT.1) THEN

C       define first atom and forward's atoms
        I       = I_LAST
        I_FIRST = I

        DO WHILE ( I.GT.0 )
          IB = L1A_IBACK(I)
          IF(IB.GT.0) THEN
            L1A_FORW(IB)  = L1A_ANAME(I)
            L1A_IFORW(IB) = I
            I_FIRST       = IB
          ENDIF
          I = IB
        ENDDO

        L1A_IBACK(I_FIRST) = 0
        L1A_BACK(I_FIRST)  = '.'

C       change direction fist --> last to first <-- last
        I       = I_LAST
        I_LAST  = I_FIRST
        I_FIRST = I

        DO WHILE ( I.GT.0 )
          IB = L1A_IBACK(I)

          ASYMB        = L1A_FORW(I) 
          L1A_FORW(I)  = L1A_BACK(I) 
          L1A_BACK(I)  = ASYMB
          IT           = L1A_IFORW(I) 
          L1A_IFORW(I) = L1A_IBACK(I) 
          L1A_IBACK(I) = IT

          IF(I.EQ.I_FIRST) THEN
            L1A_IBACK(I) = 0
            L1A_BACK(I)  = '.'
          ENDIF
          IF(I.EQ.I_LAST) THEN
            L1A_IFORW(I) = 0
            L1A_FORW(I)  = 'END'
          ENDIF

          I = IB

        ENDDO

C       define first atom again


        I       = I_LAST
        I_FIRST = I

        DO WHILE ( I.GT.0 )
          IB = L1A_IBACK(I)
          IF(IB.GT.0) THEN
            I_FIRST       = IB
          ENDIF
          I = IB
        ENDDO

        L1A_IBACK(I_FIRST) = 0
        L1A_BACK (I_FIRST) = '.'

C       define last atom again

        IMAX = 0
        LMAX = 0

        DO IA=1,NA
          
          IF(IA.NE.I_FIRST) THEN
            LEN = 0  
            I   = IA
            DO WHILE ( I.GT.0 )
              IB = L1A_IBACK(I)
              IF(IB.GT.0) THEN
                LEN = LEN+1
              ENDIF
              I = IB
            ENDDO

            IF(LEN.GE.LMAX.AND.LEN.GT.0) THEN
              IF(LEN.EQ.LMAX) THEN
                ASYMB = L1A_SYMB(IA)
                IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ')THEN
                  IMAX = IA
                ENDIF
              ELSE
                IMAX = IA
                LMAX = LEN
              ENDIF
            ENDIF

          ENDIF

        ENDDO

        I_LAST = IMAX

C       define forward's atoms again

        DO I=1,NA
          L1A_FORW (I) = '.'
          L1A_IFORW(I) = 0
        ENDDO

        L1A_FORW(I_LAST)   = 'END'
        L1A_IFORW(I_LAST)  = 0

C       main way

        I       = I_LAST
        DO WHILE ( I.GT.0 )
          IB = L1A_IBACK(I)
          IF(IB.GT.0) THEN
            L1A_FORW(IB)  = L1A_ANAME(I)
            L1A_IFORW(IB) = I
          ENDIF
          I = IB
        ENDDO

C       side way for noH-atoms

        DO IA=1,NA
          IF(IA.NE.I_FIRST) THEN
            ASYMB = L1A_SYMB(IA)
            IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ')THEN
              I = IA
              DO WHILE ( I.GT.0 )
                IB = L1A_IBACK(I)
                IF(IB.GT.0) THEN
                IF(L1A_IFORW(IB).EQ.0) THEN
                  L1A_FORW(IB)  = L1A_ANAME(I)
                  L1A_IFORW(IB) = I
                  IF(IB.EQ.I_LAST) THEN
                    I_LAST             = I
                    L1A_FORW(I_LAST)   = 'END'
                    L1A_IFORW(I_LAST)  = 0
                  ENDIF
                ENDIF
                ENDIF
                I = IB
              ENDDO
            ENDIF
          ENDIF
        ENDDO

C       side way for H-atoms

        DO IA=1,NA
          IF(IA.NE.I_FIRST) THEN
            ASYMB = L1A_SYMB(IA)
            IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ')THEN
              I = IA
              DO WHILE ( I.GT.0 )
                IB = L1A_IBACK(I)
                IF(IB.GT.0.AND.IB.NE.I_LAST) THEN
                IF(L1A_IFORW(IB).EQ.0) THEN
                  L1A_FORW(IB)  = L1A_ANAME(I)
                  L1A_IFORW(IB) = I
C                  IF(IB.EQ.I_LAST) THEN
C                    I_LAST             = I
C                    L1A_FORW(I_LAST)   = 'END'
C                    L1A_IFORW(I_LAST)  = 0
C                  ENDIF
                ENDIF
                ENDIF
                I = IB
              ENDDO
            ENDIF
          ENDIF
        ENDDO

      ELSE

        I_FIRST            = I_LAST
        L1A_IBACK(I_FIRST) = 0
        L1A_BACK(I_FIRST)  = '.'

      ENDIF

      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        LINE='3:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF



C     check and correct new first atom

      N = L1A_NDIST(I_FIRST)
      IF(N.GT.0) THEN
        DO I=1,N
          J = L1A_LENCON(I,I_FIRST)
          IF(J.GT.0) THEN
          IF(L1A_IBACK(J).NE.I_FIRST) THEN
            IF(L1A_IFORW(J).LE.0) THEN
              L1A_IFORW(J) = L1A_IBACK(J)
              L1A_FORW(J)  = L1A_BACK(J)
            ENDIF
            IF(L1A_IFORW(J).EQ.I_FIRST) THEN
              L1A_IFORW(J) = 0
              L1A_FORW(J)  = '.'
            ENDIF
            L1A_IBACK(J) = I_FIRST
            L1A_BACK(J)  = L1A_ANAME(I_FIRST)
          ENDIF
          ENDIF
        ENDDO
      ENDIF

      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        LINE='4:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF


C     create list of  extra connections ( i.e L1A_LENCON(J,I) < 0 )

      L1N_NCONN = 0  
      DO I=1,NA
        IF(L1A_NDIST(I).GT.0) THEN
          DO J=1,L1A_NDIST(I)
            JJ = L1A_LENCON(J,I)
            IF(JJ.LT.0) THEN
            IF(ABS(JJ).GT.I) THEN
              IF(L1N_NCONN.GE.MAX1CONN) THEN
                WRITE(LINE,'(3A,I6)')
     *      ' ERROR: number of extra connections of new monomer'
     *          ,L1L_MNAME,' >',MAX1CONN
                CALL MSGERR(MDOC,LINE)
                CALL MSGERR(MDOC,
     *  '          Change parameter MAX1CONN in "lib_com.fh"')
                IERR=1
                RETURN
              ENDIF
              L1N_NCONN            = L1N_NCONN + 1  
              L1N_1ATM (L1N_NCONN) = L1A_ANAME(I)
              L1N_2ATM (L1N_NCONN) = L1A_ANAME(-JJ)
              L1N_I1ATM(L1N_NCONN) = I
              L1N_I2ATM(L1N_NCONN) =-JJ
              L1N_TYPE (L1N_NCONN) = '.'
            ENDIF
            ENDIF
          ENDDO
        ENDIF
      ENDDO       

C     set "dummy" connection with last atom for all atoms without
C     any connection

      J = I_LAST
      IFIRST = 0
      DO I=1,NA
        IF(L1A_IBACK(I).EQ.0.AND.L1A_IFORW(I).EQ.0.AND.I.NE.J) THEN
          L1A_IBACK(I) = J
          L1A_TYPE (I) = 'DUMMY'
          L1A_BACK (I) = L1A_ANAME(J)
          IF(IFIRST.EQ.0) THEN
            L1A_IFORW(I) = 0
            L1A_FORW (I) = '.'
            IFIRST = 1 
          ELSE
            L1A_IFORW(J) = I
            L1A_FORW (J) = L1A_ANAME(I)
            L1A_IFORW(I) = 0
            L1A_FORW (I) = '.'
          ENDIF
          J            = I
        ENDIF
      ENDDO


C     set back atom for atom which has not it ( ? )

      DO I=1,NA
        IF(L1A_IBACK(I).EQ.0.AND.I.NE.I_FIRST) THEN
          L1A_IBACK(I)= I_FIRST
          L1A_BACK(I) = L1A_ANAME(I_FIRST)
          L1A_TYPE(I) = 'DUMMY'
        ENDIF
      ENDDO

 300  CONTINUE

      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        LINE='5:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF

      L1A_ISTART  = I_FIRST
      L1A_IFINISH = I_LAST
C ---     
C     restore L1A_LENCON(1,IA)

      DO IA=1,NA
        L1A_LENCON(1,IA) = L1A_IOLD(IA)
        L1A_IOLD(IA)     = 0
      ENDDO

      RETURN
      END

      SUBROUTINE CHECK_RING_FOR_TREE(NA,IRING,LA1,LA2,NDIST,NEXTR
     *              ,LENCON,IAC,IPN,I1,I2,MAX1BRN,MAX1ATM,MAX1BND)
C ------------------------------------------------------------------
      INTEGER NA,LA1,LA2,IRING,MAX1BRN,MAX1ATM,MAX1BND
      INTEGER NDIST(*),NEXTR(*),LENCON(MAX1BRN,MAX1ATM)
      INTEGER IAC(*),IPN(*),I1(*),I2(*)
C ------------------------------------------------------------------
      IRING = 0
      N     = 0
      DO I=1,NA  
        IF(NDIST(I).GT.0.AND.NEXTR(I).GT.0) THEN
          N      = N + 1
          IAC(N) = N 
          IPN(N) = I 
        ENDIF
      ENDDO
      IF(N.LE.4) RETURN
      NBOND = 0
      DO I=1,N
        DO J=1,NDIST(IPN(I)) 
          JJ = LENCON(J,IPN(I))
          IF(JJ.GT.0) THEN
            DO K=1,N
              IF((IPN(I).NE.LA1.AND.IPN(I).NE.LA2).OR.
     *           (JJ    .NE.LA1.AND.JJ    .NE.LA2)    ) THEN
                IF(IPN(K).EQ.JJ.AND.IPN(K).GT.I) THEN
                  NBOND = NBOND + 1
                  I1(NBOND) = I
                  I2(NBOND) = K
                ENDIF
              ENDIF
            ENDDO
          ENDIF
        ENDDO  
      ENDDO
      IF(NBOND.LE.2) RETURN
C -----
      DO IA=1,N
        DO JA=1,N
          J = IAC(JA) 
          DO IB=1,NBOND
            IK = 0
            IF(I1(IB).EQ.J.AND.I2(IB).NE.J) THEN
              IK = I2(IB)
            ELSE IF(I2(IB).EQ.J.AND.I1(IB).NE.J) THEN
              IK = I1(IB)
            ENDIF
            IF(IK.GT.0) THEN
              DO KA=1,N
                IF(IAC(KA).EQ.IK) IAC(KA) = J  
              ENDDO
              DO JB=1,NBOND
                IF(I1(JB).EQ.IK) I1(JB) = J
                IF(I2(JB).EQ.IK) I2(JB) = J
              ENDDO
            ENDIF    
          ENDDO
        ENDDO
C --
        NPIECE = 1
        DO J=2,N
          DO K=1,J-1
            IF(IAC(J).EQ.IAC(K)) GO TO 300
          ENDDO
          NPIECE = NPIECE + 1 
 300      CONTINUE
        ENDDO

        IF(NPIECE.LE.1) THEN
          IRING = 1
          GO TO 200
        ENDIF
C -- 
      ENDDO
 200  CONTINUE
C -------
      RETURN
      END

