C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
C
C----siganscale_block
C
      SUBROUTINE  ML_SCALING(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
      implicit none
      include 'weights.fh'
      integer NREF
      integer NIND(*)
      real FO(*),SIGO(*),FC(*),PHASE(*),FREER(*)
      real fwt(*)
c
      integer nworkspace
      real, allocatable :: workspace(:)
c
c---  body
      nworkspace = 10000
      allocate(workspace(nworkspace))

      if(SIGMA_REFINE_STYLE.EQ.'BINS') THEN
        CALL ML_SCALING_BINS(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER,
     &        WORKSPACE,NWORKSPACE)
      else
        CALL ML_SCALING_EXPS(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER,
     &        WORKSPACE,NWORKSPACE)
C
C---Analyse. If exps is unstable switch to bins.
C
      endif
C
      deallocate(workspace)
      RETURN
      END

      SUBROUTINE  ML_SCALING_BINS(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER,
     &                 WORKSPACE,NWORKSPACE)
C
C---Find parameters of likelihood
C
      IMPLICIT NONE
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
C
      INTEGER NREF,NWORKSPACE
      INTEGER NIND(*)
      REAL FO(*),SIGO(*),FC(*),PHASE(*),FREER(*)
      real WORKSPACE(*)
      real fwt(*)
C
      INTEGER NMAXPART1
      PARAMETER (NMAXPART1 = NMAXPART + 2)
      REAL DF(NMAXPART1,MAXBIN),DFF(NMAXPART1,NMAXPART1,MAXBIN),
     &     SHIFTS(NMAXPART1,MAXBIN),A_CALCS(NMAXPART),B_CALCS(NMAXPART)

      integer iwei
      INTEGER I,J,IBIN,NPART1,NPART2,ICENT,NCYCS,IR,IHH(3),NR_C,
     &        ISYSAB,IBIN0
      REAL RSQ,STL_C,A_ALL,B_ALL,SIGMA_IN,SIGMA,DFDA,DFDB,DFDAA,
     &     DFDBB,DFDAB,FOM,FVALUE,YO,WT1,EPSI,FVAL_ALL,
     &     F_VALUE_OLD,SCALE_NOW,FOMOVER1,DFDSIG,DFDSIG2,DFDSIGA,
     &     DFDSIGB,SCAL_SIG
      REAL TOLER
      REAL SIM
      LOGICAL FREERCHK
      EXTERNAL UNPACK,SIM
      DATA TOLER/1.0E-6/
C
C---Some initialisation.

      NPART1 = NPART + 1
      NPART2 = NPART + 2
      DO   I=1,NBIN_ML
         NREF_ML(I) = 0
         DO   J=1,NPART2
            SHIFTS(J,I) = 0.0
         ENDDO
      ENDDO
      SCAL_SIG = 1.0E4
C
C---First calculate "normalised" structure factors. This "normalisation"
C---is different from normal one. Here we use "differences" for 
C---nomralisation. In effect it is normalisation using differences.
C---We use this normalisation to avoid possible overflow in estimation
C---stage
C--------------------------------------------------------------------
C---Now estimate new ml parameters
      F_VALUE_OLD = 1.0E32
      CALL DMLINIT_R1(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
      NCYCS = 0
 10   CONTINUE
      FVAL_ALL = 0.0
      DO   IBIN = 1,NBIN_ML
        DO    I=1,NPART2
          DF(I,IBIN) = 0.0
          DO  J=1,NPART2
            DFF(J,I,IBIN) = 0.0
          ENDDO
        ENDDO
      ENDDO
      NR_C = 0
      DO    I=1,NBIN_ML
        NREF_ML(I) = 0
      ENDDO
      FOMOVER1 = 0.0
      DO   IR=1,NREF
         iwei = nint(fwt(ir))
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN 
          IF((.NOT.LSUSEWORK)  .AND.
     +    (ABS(FREER(IR)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       LSUSEWORK   .AND. 
     +    (ABS(FREER(IR)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IR).GT.0.0
     &       .and.fwt(ir).gt.0.0) THEN
          CALL INDTORS(NIND(IR),RSQ)
          STL_C = SQRT(RSQ)
          CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
          CALL CENTR(IHH,ICENT)
          CALL EPSLON(IHH,EPSI,ISYSAB)
          IBIN0 = 0
          DO   IBIN=1,NBIN_ML
            IBIN0 = IBIN0 + 1
            IF(STL_C.LE.SMAXB_ML(IBIN).AND.STL_C.GT.SMINB_ML(IBIN)) THEN
              NR_C = NR_C + 1
              CALL EXTRACT_ABS(IR,FC,PHASE,A_CALCS,B_CALCS)
              A_ALL = 0.0
              B_ALL = 0.0
              DO  I=1,NPART1
                SCALE_NOW = SCALE_ML(IBIN0,I) - SHIFTS(I,IBIN0)
                SCALE_NOW = AMIN1(5.0,AMAX1(0.01,SCALE_NOW))
                A_ALL = A_ALL + A_CALCS(I)*SCALE_NOW
                B_ALL = B_ALL + B_CALCS(I)*SCALE_NOW
              ENDDO
C
c---Add epsilon centricity here here
              WT1      = REAL(1+ICENT)*EPSI
              SIGMA_IN = SIGMA_ML(IBIN0)*WT1
              CALL SIGCALC_ML(ICENT,SIGO(IR),SIGMA_IN,SIGMA)
              YO  = FO(IR)
              CALL DFUNCDAB_ML(ICENT,SIGMA,YO,A_ALL,B_ALL,IR,PHASE,
     &                        DFDA,
     &                     DFDB,DFDAA,DFDAB,DFDBB,FVALUE,FOM)
              FVAL_ALL      = FVAL_ALL + iwei*FVALUE
              FOMOVER1      = FOMOVER1 + iwei*FOM
              NREF_ML(IBIN0) = NREF_ML(IBIN0) + iwei
C
C----Calculate derivatives wrt sigma and sigma,A and sigma,B
              DO    I=1,NPART1            
                DF(I,IBIN0) = DF(I,IBIN0) + 
     &                iwei*(DFDA*A_CALCS(I)+DFDB*B_CALCS(I))
                DO   J=1,NPART1
                  DFF(I,J,IBIN0) = DFF(I,J,IBIN0) + 
     &                  iwei*(DFDAA* A_CALCS(I)*A_CALCS(J) +
     &                           DFDAB*(A_CALCS(I)*B_CALCS(J) +
     &                                  A_CALCS(J)*B_CALCS(I))+ 
     &                           DFDBB* B_CALCS(I)*B_CALCS(J))
                ENDDO
              ENDDO
              GOTO 100
            ENDIF
          ENDDO
        ENDIF
 100    CONTINUE
      ENDDO
      IF(FVAL_ALL.GT.F_VALUE_OLD) GOTO 500
      F_VALUE_OLD = FVAL_ALL
      DO   IBIN=1,NBIN_ML
C     
C---Apply shift. If have changed parameters then different application
C---will be needed
        DO   I=1,NPART1
          SCALE_ML(IBIN,I) = SCALE_ML(IBIN,I)-SHIFTS(I,IBIN)
          SCALE_ML(IBIN,I) = AMIN1(5.0,AMAX1(0.01,SCALE_ML(IBIN,I)))
        ENDDO
C
c---Change variables? P = exp(T) ? It will make sure that 
C---Parameters will remain positive. Might have some other problems?
C---
         CALL  EIGEN_FILTER_R(TOLER,DFF(1,1,IBIN),NPART1,NMAXPART1,
     &            DF(1,IBIN),SHIFTS(1,IBIN),WORKSPACE,NWORKSPACE)
      ENDDO

      CALL DMLINIT_R1(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
C
C---Check convergence
      NCYCS = NCYCS + 1

      IF(NCYCS.LT.20 ) GOTO 10
 500  CONTINUE

      NBIN_ML1 = NBIN_ML + 1
      DO  J=1,NPART+1
         SCALE_ML(NBIN_ML1,J) = SCALE_ML(NBIN_ML,J)
      ENDDO
      SIGMA_ML(NBIN_ML1) = SIGMA_ML(NBIN_ML)
cd      stop
      RETURN
      END
C
      SUBROUTINE  ML_SCALING_EXPS(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER,
     &                WORKSPACE,NWORKSPACE)
C
C---Find parameters of likelihood
C
      IMPLICIT NONE
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'rharvest.fh'
C
      INTEGER NREF,NWORKSPACE
      INTEGER NIND(*)
      REAL FO(*),SIGO(*),FC(*),PHASE(*),FREER(*)
      real fwt(*)
      REAL WORKSPACE(*)
C
      INTEGER NMAXPART1
      PARAMETER (NMAXPART1 = 2*NMAXPART + 2)
      REAL DF(NMAXPART1),DFF(NMAXPART1,NMAXPART1),SHIFTS(NMAXPART1)
      REAL A_CALCS(NMAXPART),B_CALCS(NMAXPART)

      INTEGER I,J,IBIN,NPART1,NPART2,ICENT,NCYCS,IR,IHH(3),NR_C
      INTEGER ISYSAB,IBIN0,NPARAM,I_INTER,ICONVERGED
      REAL    ALPHA
      REAL    RSQ42,RSQ43
      REAL RSQ,STL_C,A_ALL,B_ALL,SIGMA_IN,SIGMA,DFDA,DFDB,DFDAA,
     &     DFDBB,DFDAB,FOM,FVALUE,YO,WT1,EPSI,FVAL_ALL,
     &     F_VALUE_OLD,SCALE_NOW,FOMOVER1,DFDSIG,DFDSIG2,DFDSIGA,
     &     DFDSIGB,SCAL_SIG
      REAL DADPAR(NMAXPART1),DBDPAR(NMAXPART1)
      REAL TOLER
C
C---Tchebyshev polynoms
cd      INTEGER N_COEFS
cd      REAL SMIN_TCH,SMAX_TCH
      REAL SCURRENT
cd      REAL TCH_COEFS(40)
      real delta
      REAL SIM
      LOGICAL FREERCHK
      EXTERNAL UNPACK,SIM
      DATA TOLER/1.0E-6/
C
C---Some initialisation.
cd      NBIN_ML = 1

      NPART1 = NPART + 1
      NPART2 = NPART + 2

      SCAL_SIG = 1.0E4
C
C---First calculate "normalised" structure factors. This "normalisation"
C---is different from normal one. Here we use "differences" for 
C---nomralisation. In effect it is normalisation using differences.
C---We use this normalisation to avoid possible overflow in estimation
C---stage
C--------------------------------------------------------------------
C---Now estimate new ml parameters
      F_VALUE_OLD = 1.0E32
cd      IF(NCYCLE_OVERALL.LE.0) THEN
      CALL DMLINIT_R2(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
      CALL APPROX_SIGMA_ML
      SIGMA_ML_B1_OVER      = 0.0
      SIGMA_ML_B2_OVER      = 0.0
C
C---Initialise Tchebyshev coefficient for ML SIGMA. Refine Tchebyshev
C---coefficients only for given cycles
C
C---Refine remainder as B value and scale
C
      CALL APPROX_SIGMA_ML2(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
C
      NCYCS = 0
      CALL FIND_NPARAM_MLGAUSS(NPARAM)
cd      write(*,*)nparam
 10   CONTINUE
      FVAL_ALL = 0.0
      DO    I=1,NPARAM
        DF(I) = 0.0E0
        SHIFTS(I) = 0.0E0
        DO  J=1,NPARAM
          DFF(J,I) = 0.0E0
        ENDDO
      ENDDO
      NR_C = 0
      FOMOVER1 = 0.0
      I_INTER  = -1
      DO   IR=1,NREF
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN 
          IF((.NOT.LSUSEWORK)  .AND.
     +    (ABS(FREER(IR)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       LSUSEWORK   .AND. 
     +    (ABS(FREER(IR)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IR).GT.0.0
     &       .and.fwt(ir).gt.0.0) THEN
          CALL INDTORS(NIND(IR),RSQ)
          STL_C = SQRT(RSQ)
          CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
          CALL CENTR(IHH,ICENT)
          CALL EPSLON(IHH,EPSI,ISYSAB)
          CALL EXTRACT_ABS(IR,FC,PHASE,A_CALCS,B_CALCS)
          CALL CALC_ASANDBS_MLGAUSS(RSQ,A_ALL,B_ALL,A_CALCS(NPART1),
     &                  B_CALCS(NPART1),A_CALCS,B_CALCS)
C
c---Add epsilon centricity here here
          WT1      = REAL(1+ICENT)*EPSI
          SIGMA_IN = 0.0
          RSQ42    = (RSQ/4.0)**2
          RSQ43    = RSQ42*RSQ/4.0
          SIGMA_IN = SIGMA_IN + SIGMA_ML_SCALE_OVER - 
     &                                SIGMA_ML_B_OVER*RSQ/4.0
     &                              + SIGMA_ML_B1_OVER*RSQ42
     &                              + SIGMA_ML_B2_OVER*RSQ43
          SIGMA_IN  = EXP(AMAX1(-30.0,AMIN1(59.0,SIGMA_IN)))*WT1
          CALL SIGCALC_ML(ICENT,SIGO(IR),SIGMA_IN,SIGMA)
          YO  = FO(IR)
          CALL DFUNCDAB_ML(ICENT,SIGMA,YO,A_ALL,B_ALL,IR,PHASE,
     &                DFDA,DFDB,DFDAA,DFDAB,DFDBB,FVALUE,FOM)
          FVAL_ALL      = FVAL_ALL + fwt(ir)*FVALUE
          FOMOVER1      = FOMOVER1 + fwt(ir)*FOM
          CALL DABDPAR_ML(RSQ,A_CALCS(NPART1),B_CALCS(NPART1),
     &           A_CALCS,B_CALCS,DADPAR,DBDPAR)
C
C----Calculate derivatives wrt ML scale parameters (D values)
          DO    I=1,NPARAM
            DF(I) = DF(I) + DFDA*DADPAR(I) + fwt(ir)*DFDB*DBDPAR(I)
            DO   J=1,NPARAM
              DFF(I,J) = DFF(I,J) + 
     &              fwt(ir)*(DFDAA* DADPAR(I)*DADPAR(J)+
     &                       DFDAB*(DBDPAR(I)*DADPAR(J)+
     &                               DBDPAR(J)*DADPAR(I))+
     &                        DFDBB* DBDPAR(I)*DBDPAR(J))
            ENDDO
          ENDDO
        ENDIF
 100    CONTINUE
      ENDDO
cd      write(*,*)'fvalue ',fval_all
C
c---Change variables? P = exp(T) ? It will make sure that 
C---Parameters will remain positive. Might have some other problems?
C---
      CALL  EIGEN_FILTER_R(TOLER,DFF,NPARAM,NMAXPART1,
     &            DF,SHIFTS,WORKSPACE,NWORKSPACE)
cd      write(*,*)(shifts(i),i=1,nparam)
      DO  I=1,NPARAM
        SHIFTS(I) = -SHIFTS(I)
      ENDDO
cd      CALL PRINT_ML_SCALE

      CALL LINMIN_MLGAUSS(ALPHA,FVAL_ALL,ICONVERGED,SHIFTS,
     &          NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
cd      write(*,*)iconverged
      IF(ICONVERGED.EQ.1) THEN
C
        alpha = 1.0
        CALL APPLY_SHIFTS_ML_SCALE_PARAMS(ALPHA,SHIFTS)
C
C---Recalculate Sigmas
        CALL APPROX_SIGMA_ML2(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
C
C---Check convergence
        NCYCS = NCYCS + 1
        IF(NCYCS.LT.10) GOTO 10
      ENDIF
 500  CONTINUE
cd      call print_ml_scale
cd      stop
cd      CALL APPROX_SIGMA_ML

C
cd        CALL CALC_SIGMA_ML1(NREF,NIND,FO,SIGO,FC,PHASE,FREER)

cd      CALL PRINT_LS_SCALE
cd      CALL PRINT_ML_SCALE
cd      WRITE(*,*)'APPROX SIGMA ',SIGMA_ML_SCALE_OVER,SIGMA_ML_B_OVER
cd      SIGMA_ML_B_OVER = SIGMA_ML_B_OVER/1.4
cd      STOP
C
C
C---Now estimate Tchebyshev coefficients for sigma1 (E(mFo-DFc)^2).
C---It is going to be useful for map calculation and second derivative
C---calculations.
C
cd      CALL APPROX_SIGMA_TCHEB_SIGMA1(NREF,NIND,FO,SIGO,FC,PHASE,FREER)
      stl_c = sminb_ml(1)
      delta = (smaxb_ml(nbin_ml)-sminb_ml(1))/1000
cd      call print_ml_scale
cd      write(*,*)sigma_ml_scale_over,sigma_ml_b_over,
cd     &          sigma_ml_b1_over,sigma_ml_b2_over
cd      stop
cd      do   i=1,1001
cd        rsq = stl_c**2
cd        RSQ42    = (RSQ/4.0)**2
cd        RSQ43    = RSQ42*RSQ/4.0
cd        sigma =   SIGMA_ML_SCALE_OVER - 
cd     &            SIGMA_ML_B_OVER*RSQ/4.0
cd     &          + SIGMA_ML_B1_OVER*RSQ42
cd     &           + SIGMA_ML_B2_OVER*RSQ43
cd        stl_c = stl_c + delta
cd        write(55,*)stl_c,sigma
cd      enddo
cd      stop
      RETURN
      END
C
      SUBROUTINE APPROX_SIGMA_ML
      IMPLICIT NONE
C
      INCLUDE 'weights.fh'
      INTEGER I
      REAL A(2,2),B(2)
      REAL SS2
      LOGICAL ERROR

      B(1) = 0.0
      B(2) = 0.0
      A(1,1) = 0.0
      A(1,2) = 0.0
      A(2,1) = 0.0
      A(2,2) = 0.0
      DO   I=1,NBIN_ML
        A(1,1) = A(1,1) + 1
        SS2    = SMEANB_ML(I)**2/4.0
        A(1,2) = A(1,2) - SS2
        A(2,2) = A(2,2) + SS2*SS2
        B(1)   = B(1)   + ALOG(SIGMA_ML(I))
        B(2)   = B(2)   - SS2*ALOG(SIGMA_ML(I))
      ENDDO
      A(2,1) = A(1,2)

      CALL GAUSSJ(A,2,2,B,1,1,ERROR)
      SIGMA_ML_SCALE_OVER = B(1)
      SIGMA_ML_B_OVER     = B(2)
cd      WRITE(*,*)'APPROX SIGMA ',SIGMA_ML_SCALE_OVER,SIGMA_ML_B_OVER
cd      DO   I=1,NBIN_ML

cd         WRITE(*,*)SIGMA_ML(I),EXP(B(1)-B(2)*SMEANB_ML(I)**2/4.0)
cd      ENDDO
cd      WRITE(*,*)B
cd      STOP



      RETURN
      END
C
      SUBROUTINE APPROX_SIGMA_ML2(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
      IMPLICIT NONE
C
C---Find initial values for Sigmas of likelihood function.
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
C
      INTEGER NREF
      INTEGER NIND(*)
      REAL FO(*),FC(*),SIGO(*),PHASE(*),FREER(*)
      real fwt(*)
C
      INTEGER ITRY,ISH
      INTEGER I,IREF,ICENT,ISYSAB,IBIN,IHH(3),NC,IBIN_S
      REAL WT1,WT2,STL_C,EPSI,RSQ,XX,FOM
      REAL SCURRENT
      REAL A_CALCS(NMAXPART),B_CALCS(NMAXPART),Y_C,A_ALL,B_ALL
      REAL SIGMA_ML0(MAXBIN)
      REAL SIGMA1,SIGMA,SIGMA_IN

      REAL SS22,SS23
      REAL SS1,SS2,X1,X2
      REAL FVALUE,F_ALL,F_OLD
      REAL TOLER
      REAL A(4,4),B(4),SHIFTS(4)
      INTEGER NWORKSPACE
      REAL WORKSPACE(100)
      LOGICAL FREERCHK
      LOGICAL ERROR
      REAL EPS_LOC
      INTEGER NPART1
      INTEGER j
      REAL SIM
      EXTERNAL SIM
      EXTERNAL UNPACK,INDTORS,CENTR,EPSLON
      DATA EPS_LOC/1.0E-5/,TOLER/1.0E-6/
C
      NWORKSPACE = 100
      NC  = 0
      NPART1 = NPART + 1
 1    CONTINUE
      DO   I=1,NBIN_ML
        NREF_ML(I) = 0
        SIGMA_ML0(I) = 0.0
        SIGMA_ML1(I) = 0.0
      ENDDO
cd      SIGMA_ML_SCALE_OVER = 1.0
cd      SIGMA_ML_B_OVER     = 0.0
      F_OLD = 1.0E32
      DO   I=1,5
      FVALUE = 0.0
      A(1,1) = 0.0E0
      A(1,2) = 0.0E0
      A(2,1) = 0.0E0
      A(2,2) = 0.0E0
      A(1,3) = 0.0E0
      A(2,3) = 0.0E0
      A(3,3) = 0.0E0
      A(1,4) = 0.0E0
      A(2,4) = 0.0E0
      A(3,4) = 0.0E0
      A(4,4) = 0.0E0
      B(1)   = 0.0E0
      B(2)   = 0.0E0
      B(3)   = 0.0E0
      B(4)   = 0.0E0
cd      OPEN(12)
cd      CALL PRINT_ML_SCALE
      F_ALL = 0.0
      DO     IREF = 1,NREF
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN
          IF((.NOT.MLUSEWORK)  .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       MLUSEWORK   .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IREF).GT.0.0
     &       .and.fwt(iref).gt.0.0) THEN
            CALL INDTORS(NIND(IREF),RSQ)
            CALL UNPACK(NIND(IREF),IHH(1),IHH(2),IHH(3))
            CALL CENTR(IHH,ICENT)
            CALL EPSLON(IHH,EPSI,ISYSAB)
            WT1   = (1.0+REAL(ICENT))*EPSI
            STL_C = SQRT(RSQ)
            CALL EXTRACT_ABS(IREF,FC,PHASE,A_CALCS,B_CALCS)
            CALL CALC_ASANDBS_MLGAUSS(RSQ,A_ALL,B_ALL,A_CALCS(NPART1),
     &             B_CALCS(NPART1),A_CALCS,B_CALCS)
            Y_C = SQRT(A_ALL**2 + B_ALL**2)
            SS2    = RSQ/4.0
            SS22   = SS2*SS2
            SS23   = SS22*SS2
            SIGMA_IN = 0.0
            SIGMA_IN = SIGMA_IN + SIGMA_ML_SCALE_OVER-
     &                  SIGMA_ML_B_OVER*SS2
            SIGMA_IN = SIGMA_IN + SIGMA_ML_B1_OVER*SS22
            SIGMA_IN = SIGMA_IN + SIGMA_ML_B2_OVER*SS23
            SIGMA_IN = EXP(AMAX1(-30.0,AMIN1(SIGMA_IN,59.0)))*WT1
            CALL SIGCALC_ML(ICENT,SIGO(IREF),SIGMA_IN,SIGMA)
            XX  = 2.0*FO(IREF)*Y_C/SIGMA
            IF(ICENT.EQ.0) THEN
              FOM = SIM(XX)
              CALL BESSI0(XX,X1,X2)
            ELSE
              FOM = TANH(XX)
              IF(XX.GT.60.0) THEN
                 X2 = XX
                 X1 = 0.5
              ELSE
                 X1 = COSH(XX)
                 X2 = 0.0
              ENDIF
            ENDIF
            SS1 = (FO(IREF)**2 + Y_C**2 - 2.0*FOM*FO(IREF)*Y_C)
            FVALUE = (FO(IREF)**2+Y_C**2)/SIGMA-ALOG(X1) - X2
     &                       + ALOG(SIGMA)/REAL(1+ICENT) 
            F_ALL = F_ALL + fwt(iref)*FVALUE
            WT2    = 1.0/REAL(1+ICENT)
            A(1,1) = A(1,1) + fwt(iref)*WT2
            A(1,2) = A(1,2) - fwt(iref)*SS2*WT2
            A(2,2) = A(2,2) + fwt(iref)*SS2*SS2*WT2
            A(1,3) = A(1,3) + fwt(iref)*SS22*WT2
            A(2,3) = A(2,3) - fwt(iref)*SS22*SS2*WT2
            A(3,3) = A(3,3) + fwt(iref)*SS22*SS22*WT2
            A(1,4) = A(1,4) + fwt(iref)*SS23*WT2
            A(2,4) = A(2,4) - fwt(iref)*SS23*SS2*WT2
            A(3,4) = A(3,4) + fwt(iref)*SS23*SS22*WT2
            A(4,4) = A(4,4) + fwt(iref)*SS23*SS23*WT2
            B(1)   = B(1)   + fwt(iref)*SS1/SIGMA-WT2
            B(2)   = B(2)   - fwt(iref)*SS2*(SS1/SIGMA-WT2)
            B(3)   = B(3)   + fwt(iref)*SS22*(SS1/SIGMA-WT2)
            B(4)   = B(4)   + fwt(iref)*SS23*(SS1/SIGMA-WT2)
        ENDIF
 100    CONTINUE
      ENDDO
cd      WRITE(*,*)FVALUE
      A(2,1) = A(1,2)
      A(3,1) = A(1,3)
      A(3,2) = A(2,3)
      A(4,1) = A(1,4)
      A(4,2) = A(2,4)
      A(4,3) = A(3,4)
      CALL  EIGEN_FILTER_R(TOLER,A,4,4,
     &            B,SHIFTS,WORKSPACE,NWORKSPACE)
      SIGMA_ML_SCALE_OVER = SIGMA_ML_SCALE_OVER + SHIFTS(1)
      SIGMA_ML_B_OVER     = SIGMA_ML_B_OVER     + SHIFTS(2)
      SIGMA_ML_B1_OVER    = SIGMA_ML_B1_OVER    + SHIFTS(3)
      SIGMA_ML_B2_OVER    = SIGMA_ML_B2_OVER    + SHIFTS(4)

      F_OLD = F_ALL
C
C--Calculate value
      ITRY = 0
 50   CONTINUE
      F_ALL = 0.0
      DO     IREF = 1,NREF
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN
          IF((.NOT.MLUSEWORK)  .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       MLUSEWORK   .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IREF).GT.0.0
     &       .and.fwt(iref).gt.0.0) THEN
            CALL INDTORS(NIND(IREF),RSQ)
            CALL UNPACK(NIND(IREF),IHH(1),IHH(2),IHH(3))
            CALL CENTR(IHH,ICENT)
            CALL EPSLON(IHH,EPSI,ISYSAB)
            WT1   = (1.0+REAL(ICENT))*EPSI
            STL_C = SQRT(RSQ)
            CALL EXTRACT_ABS(IREF,FC,PHASE,A_CALCS,B_CALCS)
            CALL CALC_ASANDBS_MLGAUSS(RSQ,A_ALL,B_ALL,A_CALCS(NPART1),
     &             B_CALCS(NPART1),A_CALCS,B_CALCS)
            Y_C = SQRT(A_ALL**2 + B_ALL**2)

            SS2    = RSQ/4.0
            SS22   = SS2*SS2
            SS23   = SS22*SS2
            SIGMA_IN = 0.0
            SIGMA_IN = SIGMA_IN + SIGMA_ML_SCALE_OVER-
     &                  SIGMA_ML_B_OVER*SS2
            SIGMA_IN = SIGMA_IN + SIGMA_ML_B1_OVER*SS22
            SIGMA_IN = SIGMA_IN + SIGMA_ML_B2_OVER*SS23

            SIGMA_IN = EXP(AMAX1(-30.0,AMIN1(SIGMA_IN,59.0)))*WT1

            CALL SIGCALC_ML(ICENT,SIGO(IREF),SIGMA_IN,SIGMA)
            XX  = 2.0*FO(IREF)*Y_C/SIGMA
            IF(ICENT.EQ.0) THEN
              FOM = SIM(XX)
              CALL BESSI0(XX,X1,X2)
            ELSE
              FOM = TANH(XX)
              IF(XX.GT.60.0) THEN
                 X2 = XX
                 X1 = 0.5
              ELSE
                 X1 = COSH(XX)
                 X2 = 0.0
              ENDIF
            ENDIF
            SS1 = (FO(IREF)**2 + Y_C**2 - 2.0*FOM*FO(IREF)*Y_C)
            FVALUE = (FO(IREF)**2+Y_C**2)/SIGMA-ALOG(X1) - X2
     &                       + ALOG(SIGMA)/REAL(1+ICENT) 
            F_ALL = F_ALL + fwt(iref)*FVALUE
        ENDIF
      ENDDO
      IF(F_ALL.GT.F_OLD) THEN
         ITRY = ITRY + 1
         DO  ISH=1,4
           SHIFTS(ISH) = SHIFTS(ISH)/2.0
         ENDDO
        SIGMA_ML_SCALE_OVER = SIGMA_ML_SCALE_OVER - SHIFTS(1)
        SIGMA_ML_B_OVER     = SIGMA_ML_B_OVER     - SHIFTS(2)
        SIGMA_ML_B1_OVER    = SIGMA_ML_B1_OVER    - SHIFTS(3)
        SIGMA_ML_B2_OVER    = SIGMA_ML_B2_OVER    - SHIFTS(4)

        IF(ITRY.LE.6) THEN
           GOTO 50
        ELSE
          SIGMA_ML_SCALE_OVER = SIGMA_ML_SCALE_OVER - SHIFTS(1)
          SIGMA_ML_B_OVER     = SIGMA_ML_B_OVER     - SHIFTS(2)
          SIGMA_ML_B1_OVER    = SIGMA_ML_B1_OVER    - SHIFTS(3)
          SIGMA_ML_B2_OVER    = SIGMA_ML_B2_OVER    - SHIFTS(4)
          GOTO 200
        ENDIF
      ENDIF
cd      STOP

cd      IF(F_ALL.GT.F_OLD) GOTO 200
cd      WRITE(*,*)F_ALL,F_OLD
      F_OLD = F_ALL

      ENDDO
 200  CONTINUE
cd      WRITE(*,*)SIGMA_ML_SCALE_OVER,SIGMA_ML_B_OVER,SIGMA_ML_B1_OVER,
cd     &          SIGMA_ML_B2_OVER
cd      STOP
C
      RETURN
      END
C
      SUBROUTINE SIGCALC_ML(ICENT,SIGMA_OBS,SIGMA_IN,SIGMA)
C
C---Calculate sigma of current reflection
      IMPLICIT NONE
      INCLUDE 'agreem.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'const.fh'
C
      INTEGER ICENT
      REAL SIGMA_IN,SIGMA,SIGMA_OBS
C
      REAL SIGMES
      SIGMES = 0.0
      IF(LEXPUSE)SIGMES = SIGMA_OBS
C
C---Epsilon and centricty have already been added.
      SIGMA = 2.0*SIGMES + SIGMA_IN
Cejd - Check for ridiculously small or negative SIGMA
      IF( SIGMA.LT.ZEPS)  SIGMA = ZEPS
      RETURN
      END
C
      SUBROUTINE CALC_SCALE_P(RSQ,SCALE_P)
      IMPLICIT NONE
C
      INCLUDE 'weights.fh'
C
      REAL RSQ,SCALE_P
C
      REAL RSQ1
C
      RSQ1 = RSQ/4.0

      SCALE_P = (1.0-D_ML_SCALE_BBULK*EXP(-RSQ1*D_ML_B_BBULK))*
     &           D_ML_SCALE_OVER*EXP(-RSQ1*D_ML_B_OVER)

      RETURN
      END
C
      SUBROUTINE CALC_ASANDBS_MLGAUSS(RSQI,A_ALL,B_ALL,A_PROT,B_PROT,
     &                  A_PART,B_PART)
C
      IMPLICIT NONE
C
C---Applies scale factor for calculated with ML to A and B.
C
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
C
      REAL A_PART(*),B_PART(*)
      REAL A_PROT,B_PROT,RSQI,A_ALL,B_ALL
C
      INTEGER I
      REAL BBULK,DEXPP,P_AND_BULK,SCALE1,RSQ
C
      RSQ   = RSQI/4.0
      A_ALL = 0.0
      B_ALL = 0.0
C
C--Babinet's bulk if avilable
      BBULK = 1.0 - D_ML_SCALE_BBULK*EXP(-RSQ*D_ML_B_BBULK)
      DEXPP = D_ML_SCALE_OVER*EXP(-RSQ*D_ML_B_OVER)
      P_AND_BULK = DEXPP*BBULK
      A_ALL = A_PROT
      B_ALL = B_PROT
C
C---Partial structure (such as solvent) if available
      IF(NPART.GT.0) THEN
        DO   I=1,NPART
          SCALE1 = D_ML_SCALE_PART(I)*EXP(-RSQ*D_ML_B_PART(I))
          A_ALL  = A_ALL + A_PART(I)*SCALE1
          B_ALL  = B_ALL + B_PART(I)*SCALE1
        ENDDO
      ENDIF
      A_ALL = A_ALL*P_AND_BULK
      B_ALL = B_ALL*P_AND_BULK
cd      WRITE(*,*)D_ML_SCALE_OVER,D_ML_B_OVER
cd      WRITE(*,*)'In asandbs',A_ALL,B_ALL,P_AND_BULK,A_PROT,B_PROT,NPART,
cd     &           BBULK,
cd     &          DEXPP,SCALE1
      RETURN
      END
C
      SUBROUTINE FIND_NPARAM_MLGAUSS(NPARAM)
      IMPLICIT NONE
C
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INTEGER NPARAM
C
      INTEGER I
C
      NPARAM = 2
      IF(ML_BULK_REFINE_FLAG) NPARAM = NPARAM + 2
      DO   I=1,NPART
        IF(ML_PART_REFINE_FLAG(I)) NPARAM = NPARAM + 2
      ENDDO
      RETURN
      END
C
      SUBROUTINE DABDPAR_ML(RSQI,A_PROT,B_PROT,A_PART,B_PART,
     &           DADPAR,DBDPAR)
      IMPLICIT NONE
C
      REAL RSQI,A_PROT,B_PROT
      REAL A_PART(*),B_PART(*)
      REAL DADPAR(*),DBDPAR(*)
C
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
C
      INTEGER I,J
      REAL A_ALL,B_ALL,AC1,BC1,RSQ
      REAL EXPBULK,DEXPBULK,BBULK,EXPP,DEXPP,P_AND_BULK,EXPPART
      REAL DEXPPART
C
      RSQ     = RSQI/4.0
      EXPBULK = EXP(-RSQ*D_ML_B_BBULK)
      DEXPBULK = D_ML_SCALE_BBULK*EXPBULK
      BBULK    = 1.0 - DEXPBULK
C
      EXPP     = EXP(-RSQ*D_ML_B_OVER)
      DEXPP    = D_ML_SCALE_OVER*EXPP
      P_AND_BULK = BBULK*DEXPP
      A_ALL    = A_PROT
      B_ALL    = B_PROT
C
      J = 0
      IF(NPART.GT.0) THEN
        DO   I=1,NPART
          EXPPART  = EXP(-RSQ*D_ML_SCALE_PART(I))
          DEXPPART = D_ML_SCALE_PART(I)*EXPPART
C
          AC1           =      DEXPPART*A_PART(I)
          BC1           =      DEXPPART*B_PART(I)
          IF(ML_PART_REFINE_FLAG(I)) THEN
            DADPAR(J+1) =     EXPPART*P_AND_BULK*A_PART(I)
            DADPAR(J+2) =    -RSQ*P_AND_BULK*AC1
            DBDPAR(J+1) =     EXPPART*P_AND_BULK*B_PART(I)
            DBDPAR(J+2) =    -RSQ*P_AND_BULK*BC1
            J           =    J+2
          ENDIF
          A_ALL         = A_ALL + AC1
          B_ALL         = B_ALL + BC1
        ENDDO
      ENDIF
C
C---Protein part
      DADPAR(J+1)    = A_ALL*BBULK*EXPP
      DADPAR(J+2)    = -RSQ*A_ALL*P_AND_BULK
      DBDPAR(J+1)    = B_ALL*BBULK*EXPP
      DBDPAR(J+2)    = -RSQ*B_ALL*P_AND_BULK
      J              = J + 2
      IF(ML_BULK_REFINE_FLAG) THEN
        DADPAR(J+1) = -A_ALL*EXPBULK*DEXPP
        DADPAR(J+2) = RSQ*A_ALL*DEXPBULK*DEXPP
        DBDPAR(J+1) = -B_ALL*EXPBULK*DEXPP
        DBDPAR(J+2) = RSQ*B_ALL*DEXPBULK*DEXPP
      ENDIF
      RETURN
      END
C
      SUBROUTINE LINMIN_MLGAUSS(ALPHA,F_VALUE0,ICONVERGED,SHIFTS,
     &          NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
      IMPLICIT NONE
C
C---Simple line minimisation for ML parameters estimation. 
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INTEGER NREF,ICONVERGED
      INTEGER NIND(*)
      REAL FO(*),SIGO(*),FC(*),PHASE(*),FREER(*)
      real fwt(*)
      REAL ALPHA,F_VALUE0
      REAL SHIFTS(*)
C
      REAL  F2,F3,F_VALUE,F_VALUE2,F_VALUE3,ALPHA2,ALPHA3,ALPHAT
      REAL  A,B
      REAL SAVE_PARAMS_ARRAY(2*NMAXPART + 4)
      INTEGER NWORK,N_TRY

      NWORK =  2*NMAXPART + 4
      ALPHA = 1.0
      CALL SAVE_ML_PARAMS(NWORK,SAVE_PARAMS_ARRAY)
      CALL APPLY_SHIFTS_ML_SCALE_PARAMS(ALPHA,SHIFTS)
C
      ALPHA3 = 1
      ALPHA2 = ALPHA
      CALL CALC_FVALUE_ML_ALL(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER,
     &                F_VALUE)
      IF(F_VALUE.LT.F_VALUE0) THEN
        ALPHA      = ALPHA3
        ICONVERGED = 1
        CALL RESTORE_ML_PARAMS(NWORK,SAVE_PARAMS_ARRAY)
        RETURN
      ELSE
        F_VALUE3 = F_VALUE
        N_TRY = 0
 10     CONTINUE
        ALPHA2 = ALPHA2/2.0
        N_TRY = N_TRY + 1
       
        CALL RESTORE_ML_PARAMS(NWORK,SAVE_PARAMS_ARRAY)
        CALL APPLY_SHIFTS_ML_SCALE_PARAMS(ALPHA2,SHIFTS)
        CALL CALC_FVALUE_ML_ALL(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER,
     &                F_VALUE2)
        IF(F_VALUE2.LT.F_VALUE0) THEN
          ALPHA = ALPHA2
C
C--Find quadratic approximation (parabolic fit). If it is in the interval 
C--use it. Otherwise use this value.
          F2 = F_VALUE2 - F_VALUE0
          F3 = F_VALUE3 - F_VALUE0
          A  = 2.0*(F3*ALPHA2**2 - F2*ALPHA3**2)
          B  =      F2*ALPHA3    - F3*ALPHA2
          IF(A.NE.0.0) THEN
            ALPHAT = -B/A
          ELSE 
            ALPHAT = -1.0
          ENDIF
          ICONVERGED = 1
          CALL RESTORE_ML_PARAMS(NWORK,SAVE_PARAMS_ARRAY)
          RETURN
        ENDIF
        ALPHA3 = ALPHA2
        IF(N_TRY.LE.3) GOTO 10
      ENDIF
      CALL RESTORE_ML_PARAMS(NWORK,SAVE_PARAMS_ARRAY)
      ICONVERGED = 0
      RETURN
      END
C
      SUBROUTINE  CALC_FVALUE_ML_ALL(NREF,NIND,FO,SIGO,fwt,FC,
     &     PHASE,FREER,F_VALUE)
C
C---Calculate value of the likelihood
      IMPLICIT NONE
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
C
      INTEGER NREF,NWORKSPACE
      INTEGER NIND(*)
      REAL F_VALUE
      REAL FO(*),SIGO(*),FC(*),PHASE(*),FREER(*)
      real fwt(*)
C
      INTEGER NMAXPART1
      PARAMETER (NMAXPART1 = NMAXPART + 2)
      REAL   A_CALCS(NMAXPART),B_CALCS(NMAXPART)

      INTEGER I,J,NPART1,ICENT,IR,IHH(3),NR_C,ISYSAB,I_INTER
      REAL RSQ,STL_C,A_ALL,B_ALL,SIGMA_IN,SIGMA
      REAL SCURRENT
      REAL EPSI,WT1
      REAL FVALUE_S
      REAL TOLER
      REAL SIM
      LOGICAL FREERCHK
      EXTERNAL UNPACK,SIM
C
C---Calculate value of the function
      NPART1 = NPART+1
      F_VALUE = 0.0
      DO   IR=1,NREF
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN 
          IF((.NOT.LSUSEWORK)  .AND.
     +    (ABS(FREER(IR)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       LSUSEWORK   .AND. 
     +    (ABS(FREER(IR)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IR).GT.0.0
     &       .and.fwt(ir).gt.0.0) THEN
          CALL INDTORS(NIND(IR),RSQ)
          STL_C = SQRT(RSQ)
          CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
          CALL CENTR(IHH,ICENT)
          CALL EPSLON(IHH,EPSI,ISYSAB)
          CALL EXTRACT_ABS(IR,FC,PHASE,A_CALCS,B_CALCS)
          CALL CALC_ASANDBS_MLGAUSS(RSQ,A_ALL,B_ALL,A_CALCS(NPART1),
     &                  B_CALCS(NPART1),A_CALCS,B_CALCS)
C
c---Add epsilon centricity here here
          WT1      = REAL(1+ICENT)*EPSI
          SIGMA_IN = 0.0
          SIGMA_IN = SIGMA_IN + SIGMA_ML_SCALE_OVER - 
     &                                SIGMA_ML_B_OVER*RSQ/4.0
          SIGMA_IN = SIGMA_IN + SIGMA_ML_B1_OVER*(RSQ/4.0)**2
          SIGMA_IN = SIGMA_IN + SIGMA_ML_B2_OVER*(RSQ/4.0)**3
          SIGMA_IN  = EXP(AMAX1(-30.0,AMIN1(59.0,SIGMA_IN)))*WT1
          CALL SIGCALC_ML(ICENT,SIGO(IR),SIGMA_IN,SIGMA)
          CALL CALC_FVALUE_ML(ICENT,SIGMA,FO(IR),A_ALL,B_ALL,IR,PHASE,
     &                         FVALUE_S)
          F_VALUE      = F_VALUE + fwt(ir)*FVALUE_S

        ENDIF
 100    CONTINUE
      ENDDO
C
      RETURN
      END
C
      SUBROUTINE CALC_FVALUE_ML(ICENT,SIGMA,YO,AC,BC,IR,PHASE,FVALUE)
C
C---Subroutine to calculate partial derivatives of functional w.r.t. 
C---real and imagenary parts of structure factors (A,B). This subroutine
C---should be modified for intensity based likelihood
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'const.fh'
      REAL PHASE(*)
C
C---Local common blocks
      REAL COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINCS
      COMMON /HKL_COMM/ COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINC2
      REAL HLA,HLB,HLC,HLD,HLA1,HLB1
C
      COSC = 1.0
      SINC = 0.0
      YC   = SQRT(AC*AC+BC*BC)
      IF(YC.GT.0.0) THEN
        COSC = AC/YC
        SINC = BC/YC
      ENDIF

      APROB = 1.0
cd        YOS2  = 4.0/SIGMA**2
cd        YOS2  = 4.0*(YC**2+SIGMA)/SIGMA**2
cd        YOS2  = 4.0*(YO**2/3.0 + 2.0*YC**2/3.0)/SIGMA**2
C
C---Likelihood function. In general form of one of diagonal approximation of
C---   -loglikelihood 
C
C                         (|Fo|^2+|Fc|^2)/SIGMA - 
C   log(int(0,2pi){p(phi)exp(2.0|FO||Fc|cos(phi-phic)/sigma)|dphi+log(sigma) 
C
C                           (|Fo|^2+|Fc|^2)/SIGMA - 
C   log(sum(1,2){p(phi)exp(2.0|FO||Fc|cos(phi-phic)/sigma)|dphi+1/2 log(sigma) 
C
C----acentric and centric reflections respectively.
C----In above equations constants were ignored
      IF(YO.GT.0.0) THEN
        XX   = 2.0*YO*YC/SIGMA
        HLA   = 0.0
        HLB   = 0.0
        HLC   = 0.0
        HLD   = 0.0
        IF(MIR_FLAG) THEN
          IPOS = (NPART+1)*NOBS + IR
          HLA  = PHASE(IPOS)
          IPOS = IPOS+NOBS
          HLB  = PHASE(IPOS)
          IPOS = IPOS+NOBS
          HLC  = PHASE(IPOS)
          IPOS = IPOS+NOBS
          HLD  = PHASE(IPOS)
        ENDIF
        HLAB = SQRT(HLA*HLA+HLB*HLB)
        HLCD = SQRT(HLC*HLC+HLD*HLD)
        IF(.NOT.MIR_FLAG.OR.
     +       ((HLAB+HLCD).LT.0.00001)) THEN
C
C----No MIR/MAD or uniform distribution of phases. Use Rice distribution
C-----------------------------------------------------------------
          CALL PH_PROB_RICE_0(ICENT,XX,APROB,XC)

          IF(ICENT.EQ.0) THEN
            APROB = 2.0*APROB
          ELSE
            APROB = 2.0*APROB/SQRT(PI)
          ENDIF
C-----------------------------------------------------------------
        ELSEIF((HLAB.GT.80.00)
     +                .AND.(HLCD.LT.0.0001)) THEN
C
C---Exact phases. Use complex SFs (i.e. |Fc-Fo|^2/Sigma)
C-----------------------------------------------------------------
          COSAA   = HLA/HLAB
          SINAA   = HLB/HLAB
          XC      =  2.0*YO*YC*(COSC*COSAA - SINC*SINAA)/SIGMA
          IF(ICENT.EQ.0) THEN
            APROB   = 1.0/PI
          ELSE
            APROB   = SQRT(1.0/PI)
          ENDIF
C-----------------------------------------------------------------
        ELSEIF(HLCD.LT.0.0001) THEN
C
C---HLC = HLD = 0.0
           HLA1 = HLA + COSC*XX
           HLB1 = HLB + SINC*XX
           XX1  = SQRT(HLA1**2+HLB1**2)
           PHI_COMB  = 0.0
           COS_COMB = 1.0
           SIN_COMB = 0.0
           IF(XX1.GT.0.0) THEN
             COS_COMB = HLA1/XX1
             SIN_COMB = HLB1/XX1
           ENDIF
           CALL PH_PROB_RICE_0(ICENT,XX1,APROB,XC)
           IF(ICENT.EQ.0) THEN
             APROB = APROB*(2.0)
           ELSE
             APROB = 2.0*APROB/SQRT(PI)
          ENDIF
        ELSE
C---------------------------------------
C
C---Some phase distribution. All HLA HLB,HLC,HLD are non zero
C-----------------------------------------------------------------
C
           HLA1 = HLA + COSC*XX
           HLB1 = HLB + SINC*XX
           CALL PHASE_PROB_0(ICENT,HLA1,HLB1,HLC,HLD,APROB,XC)
           COSSQA = (1.0+COS2A)/2.0
           SINSQA = (1.0-COS2A)/2.0
           SINCOSA= SIN2A/2.0
           IF(ICENT.EQ.0) THEN
             APROB = APROB/PI
           ELSE
             APROB = APROB/SQRT(TWOPI)
           ENDIF
C-----------------------------------------------------------------
        ENDIF   
C
C----Value of functional
        FVALUE = (YO*YO+YC*YC)/SIGMA - (ALOG(APROB) + XC) + 
     &                  ALOG(SIGMA)/(REAL(ICENT)+1.0)
        IF(ICENT.EQ.0.AND.YO.GT.0.0) FVALUE = FVALUE - ALOG(YO)
      ELSE
        FVLALUE = 0.0
      ENDIF
      RETURN
      END
C
      SUBROUTINE RESTORE_ML_PARAMS(N_SAVE_ARRAY,SAVE_PARAMS_ARRAY)
      IMPLICIT NONE
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
C
      INTEGER N_SAVE_ARRAY
      REAL SAVE_PARAMS_ARRAY(*)
C
      INTEGER I,J
C
      IF(N_SAVE_ARRAY.LT.2*NPART+4) THEN
        CALL ERRWRT(1,'Size mismatch in SAVE_ML_PARAMS')
      ENDIF

      D_ML_SCALE_OVER = SAVE_PARAMS_ARRAY(1)
      D_ML_B_OVER     = SAVE_PARAMS_ARRAY(2)
      J = 2
      DO   I=1,NPART
        D_ML_SCALE_PART(I) = SAVE_PARAMS_ARRAY(J+1)
        D_ML_B_PART(I)     = SAVE_PARAMS_ARRAY(J+2)
        J = J + 2
      ENDDO
      D_ML_SCALE_BBULK = SAVE_PARAMS_ARRAY(J+1)
      D_ML_B_BBULK     = SAVE_PARAMS_ARRAY(J+2)
      RETURN
      END
C
      SUBROUTINE APPLY_SHIFTS_ML_SCALE_PARAMS(CC,DSHIFTS)
      IMPLICIT NONE
C
C---This subroutine appies shifts to ML scale parameters. Shifts are 
C---multiplied by CC
C
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
C
      REAL CC
      REAL DSHIFTS(*)
C
      INTEGER I,J
C
      J  = 0
      DO  I=1,NPART
        IF(ML_PART_REFINE_FLAG(I)) THEN
          D_ML_SCALE_PART(I) = AMAX1(0.001,D_ML_SCALE_PART(I)+
     &                             REAL(DSHIFTS(J+1))*CC)
          D_ML_B_PART(I)     = AMIN1(150.0,
     &     AMAX1(-10.0,D_ML_B_PART(I)+CC*REAL(DSHIFTS(J+2))))
          J = J + 2
        ENDIF
      ENDDO
      D_ML_SCALE_OVER = AMAX1(0.1,D_ML_SCALE_OVER + 
     &                                 REAL(DSHIFTS(J+1))*CC)
      D_ML_B_OVER     = AMIN1(150.0,
     &         AMAX1(-20.0,D_ML_B_OVER     + REAL(DSHIFTS(J+2))*CC))
cd      D_ML_B_OVER     =  D_ML_B_OVER     + DSHIFTS(J+2)*CC

      J = J + 2
      IF(ML_BULK_REFINE_FLAG) THEN
        D_ML_SCALE_BBULK = AMIN1(0.99,AMAX1(0.0,
     &                      D_ML_SCALE_BBULK + REAL(DSHIFTS(J+1))*CC))
        D_ML_B_BBULK     = AMIN1(150.0,
     &        AMAX1(-10.0,D_ML_B_BBULK    + REAL(DSHIFTS(J+2))*CC))
      ENDIF

      RETURN
      END
C
      SUBROUTINE SAVE_ML_PARAMS(N_SAVE_ARRAY,SAVE_PARAMS_ARRAY)
      IMPLICIT NONE
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
C
      INTEGER N_SAVE_ARRAY
      REAL SAVE_PARAMS_ARRAY(*)
C
      INTEGER I,J
C
      IF(N_SAVE_ARRAY.LT.2*NPART+4) THEN
        CALL ERRWRT(1,'Size mismatch in SAVE_ML_PARAMS')
      ENDIF


      SAVE_PARAMS_ARRAY(1) = D_ML_SCALE_OVER
      SAVE_PARAMS_ARRAY(2) = D_ML_B_OVER
      J = 2
      DO   I=1,NPART
        SAVE_PARAMS_ARRAY(J+1) = D_ML_SCALE_PART(I)
        SAVE_PARAMS_ARRAY(J+2) = D_ML_B_PART(I)
        J = J + 2
      ENDDO
      SAVE_PARAMS_ARRAY(J+1) = D_ML_SCALE_BBULK
      SAVE_PARAMS_ARRAY(J+2) = D_ML_B_BBULK
      RETURN
      END
C
      SUBROUTINE 
     +  DFUNCDAB_ML(ICENT,SIGMA,YO,AC,BC,IR,PHASE,DFDA,DFDB,
     +                    DFDAA,DFDAB,DFDBB,FVALUE,FOM)
C
C---Subroutine to calculate partial derivatives of functional w.r.t. 
C---real and imagenary parts of structure factors (A,B). This subroutine
C---should be modified for intensity based likelihood
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'const.fh'
      REAL PHASE(*)
C
C---Local common blocks
      COMMON /HKL_COMM/ COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINC2
      REAL HLA,HLB,HLC,HLD,HLA1,HLB1
C
      COSC = 1.0
      SINC = 0.0
      YC   = SQRT(AC*AC+BC*BC)
      IF(YC.GT.0.0) THEN
        COSC = AC/YC
        SINC = BC/YC
      ENDIF

      APROB = 1.0
cd        YOS2  = 4.0/SIGMA**2
cd        YOS2  = 4.0*(YC**2+SIGMA)/SIGMA**2
cd        YOS2  = 4.0*(YO**2/3.0 + 2.0*YC**2/3.0)/SIGMA**2
C
C---Likelihood function. In general form of one of diagonal approximation of
C---   -loglikelihood 
C
C                         (|Fo|^2+|Fc|^2)/SIGMA - 
C   log(int(0,2pi){p(phi)exp(2.0|FO||Fc|cos(phi-phic)/sigma)|dphi+log(sigma) 
C
C                           (|Fo|^2+|Fc|^2)/SIGMA - 
C   log(sum(1,2){p(phi)exp(2.0|FO||Fc|cos(phi-phic)/sigma)|dphi+1/2 log(sigma) 
C
C----acentric and centric reflections respectively.
C----In above equations constants were ignored
      IF(YO.GT.0.0) THEN
      COSC2 = COSC*COSC
      SINC2 = SINC*SINC
      XX   = 2.0*YO*YC/SIGMA
      YOS2 = 4.0*YO*YO/(SIGMA*SIGMA)
      HLA   = 0.0
      HLB   = 0.0
      HLC   = 0.0
      HLD   = 0.0
      IF(MIR_FLAG) THEN
        IPOS = (NPART+1)*NOBS + IR
        HLA  = PHASE(IPOS)
        IPOS = IPOS+NOBS
        HLB  = PHASE(IPOS)
        IPOS = IPOS+NOBS
        HLC  = PHASE(IPOS)
        IPOS = IPOS+NOBS
        HLD  = PHASE(IPOS)
      ENDIF
      HLAB = SQRT(HLA*HLA+HLB*HLB)
      HLCD = SQRT(HLC*HLC+HLD*HLD)
      IF(.NOT.MIR_FLAG.OR.
     +     ((HLAB+HLCD).LT.0.00001)) THEN
C
C----No MIR/MAD or uniform distribution of phases. Use Rice distribution
C-----------------------------------------------------------------
        CALL PH_PROB_RICE(ICENT,XX,COSC,SINC,COSAA,SINAA,
     +                                   COS2A,SIN2A,APROB,XC)
        COSSQA = (1.0+COS2A)/2.0
        SINSQA = (1.0-COS2A)/2.0
        SINCOSA = SIN2A/2.0
        IF(ICENT.EQ.0) THEN
          APROB = APROB*(2.0)
        ELSE
          APROB = 2.0*APROB/SQRT(PI)
        ENDIF
C-----------------------------------------------------------------
      ELSEIF((HLAB.GT.80.00)
     +              .AND.(HLCD.LT.0.0001)) THEN
C
C---Exact phases. Use complex SFs (i.e. |Fc-Fo|^2/Sigma)
C-----------------------------------------------------------------
        COSAA   = HLA/HLAB
        SINAA   = HLB/HLAB
        COSSQA  = COSAA*COSAA
        SINSQA  = SINAA*SINAA
        SINCOSA = COSAA*SINAA
        XC      =  2.0*YO*YC*(COSC*COSAA - SINC*SINAA)/SIGMA
        IF(ICENT.EQ.0) THEN
          APROB   = 1.0/PI
        ELSE
          APROB   = SQRT(1.0/PI)
        ENDIF
C-----------------------------------------------------------------
      ELSEIF(HLCD.LT.0.0001) THEN
C
C---HLC = HLD = 0.0
         HLA1 = HLA + COSC*XX
         HLB1 = HLB + SINC*XX
         XX1  = SQRT(HLA1**2+HLB1**2)
         PHI_COMB  = 0.0
         COS_COMB = 1.0
         SIN_COMB = 0.0
         IF(XX1.GT.0.0) THEN
           COS_COMB = HLA1/XX1
           SIN_COMB = HLB1/XX1
         ENDIF
         CALL PH_PROB_RICE(ICENT,XX1,COS_COMB,SIN_COMB,COSAA,
     +                  SINAA,COS2A,SIN2A,APROB,XC)
         COSSQA = (1.0+COS2A)/2.0
         SINSQA = (1.0-COS2A)/2.0
         SINCOSA = SIN2A/2.0
         IF(ICENT.EQ.0) THEN
           APROB = APROB*(2.0)
         ELSE
           APROB = 2.0*APROB/SQRT(PI)
        ENDIF
      ELSE
C---------------------------------------
C
C---Some phase distribution. All HLA HLB,HLC,HLD are non zero
C-----------------------------------------------------------------
C
         HLA1 = HLA + COSC*XX
         HLB1 = HLB + SINC*XX
         CALL PHASE_PROB(ICENT,HLA1,HLB1,HLC,HLD,COSC,SINC,COSAA,
     +              SINAA,COS2A,SIN2A,APROB,XC)
         COSSQA = (1.0+COS2A)/2.0
         SINSQA = (1.0-COS2A)/2.0
         SINCOSA= SIN2A/2.0
         IF(ICENT.EQ.0) THEN
           APROB = APROB/PI
         ELSE
           APROB = APROB/SQRT(TWOPI)
         ENDIF
C-----------------------------------------------------------------
      ENDIF   
C
C----Value of functional
      FVALUE = (YO*YO+YC*YC)/SIGMA - (ALOG(APROB) + XC) + 
     +                  ALOG(SIGMA)/(REAL(ICENT)+1.0)
      IF(ICENT.EQ.0.AND.YO.GT.0.0) FVALUE = FVALUE - ALOG(YO)

      FOM = SQRT(COSAA*COSAA+SINAA*SINAA)
C
C--First and second derivatives
C-----------------------------------------------------------------
      DFDA = 2.0*(AC - YO*COSAA)/SIGMA
      DFDB = 2.0*(BC - YO*SINAA)/SIGMA
      DFDAA = 2.0/SIGMA - YOS2*(COSSQA -COSAA*COSAA)
      DFDBB = 2.0/SIGMA - YOS2*(SINSQA -SINAA*SINAA)
      DFDAB =  0.0      - YOS2*(SINCOSA-SINAA*COSAA)
cd        IF(DFDAA + DFDBB.LT.0.0) THEN
cd          DFDAA = 2.0/SIGMA
cd          DFDAB = 0.0
cd          DFDBB = 2.0/SIGMA
cd        ENDIF

      ELSE
        D2FDA = 2.0*AC
        D2FDB = 2.0*BC
        DFDAA = 2.0/SIGMA
        DFDBB = 2.0/SIGMA
        DFDAB = 0.0
      ENDIF
      RETURN
      END
C    
      SUBROUTINE DFUNCDSIGAB_ML(ICENT,SIGMA,YO,A_ALL,B_ALL,
     &     DFDS,D2FDS2,DFDAS,DFDBS)
      IMPLICIT NONE
C
      INTEGER ICENT
      REAL    SIGMA,YO,A_ALL,B_ALL,DFDS,D2FDS2,DFDAS,DFDBS
C
C---Consider case with no external phase info
C
C---Derivatives of functional w.r.t. sigma's
      INCLUDE 'const.fh'
C
C---Local common
      REAL COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINC2
      COMMON /HKL_COMM/ COSC,SINC,COSAA,SINAA,COS2A,SIN2A,COSC2,SINC2
C
      REAL   XX,SIGMA2,SIGMA3,YC,YO2,YC2,YOC,COSCMA
      XX      = 2.0*YO*YC/SIGMA
      SIGMA2  = SIGMA*SIGMA
      SIGMA3  = SIGMA2*SIGMA
      YC      = SQRT(A_ALL*A_ALL + B_ALL*B_ALL)
cd      COSC    = 0.0
cd      SINC    = 0.0
cd      IF(YC.GT.EPS_LOC) THEN
cd        COSC    = A_ALL/YC
cd        SINC    = B_ALL/BC
cd      ENDIF
      YO2     = YO*YO
      YC2     = YC*YC
      YOC     = YO*YC
      COSCMA  = COSC*COSAA+SINC*SINAA
      IF(ICENT.EQ.0) THEN
C
C----acentric case
        DFDS = 1.0/SIGMA -
     +           (YO2+YC2-2.0*YO*YC*COSCMA)/SIGMA2
        D2FDS2=
     +       -1.0/SIGMA2+
     +     2.0*(YO2+YC2-2.0*YO*YC*COSCMA)/SIGMA3
        DFDAS = -2.0*(YC*COSC-YO*COSAA)/SIGMA2+
     +          XX**2*(COSC*COSC*((1.0+COS2A)/2.0-COSAA*COSAA)+
     +                COSC*SINC*(SIN2A/2.0-SINAA*COSAA))/SIGMA
        DFDBS = -2.0*(YC*SINC-YO*SINAA)/SIGMA2+
     +          XX**2*(SINC*SINC*((1.0-COS2A)/2.0-SINAA*SINAA)+
     +                COSC*SINC*(SIN2A/2.0-SINAA*COSAA))/SIGMA
      ELSE
C
C---Centric case
        DFDS   =  1.0/SIGMA  - 2.0*(YO2+YC2-2.0*YOC*COSCMA)/SIGMA2
        D2FDS2 = -2.0/SIGMA2 + 8.0*(YO2+YC2-2.0*YO*YC*COSCMA)/SIGMA3
        DFDAS = -4.0*(YC*COSC-YO*COSAA)/SIGMA2
     +          +2.0*XX**2*(COSC*COSC*((1.0+COS2A)/2.0-COSAA*COSAA)+
     +                COSC*SINC*(SIN2A/2.0-SINAA*COSAA))/SIGMA
        DFDBS = -4.0*(YC*SINC-YO*SINAA)/SIGMA2
     +          +2.0*XX**2*(SINC*SINC*((1.0-COS2A)/2.0-SINAA*SINAA)+
     +                COSC*SINC*(SIN2A/2.0-SINAA*COSAA))/SIGMA
      ENDIF
C
C---Other type of functionals (for example likelihood with phases)
C---could be added here

      RETURN
      END

      SUBROUTINE EXTRACT_ABS(IR,FC,PHASE,A_CALCS,B_CALCS)
C
C---Sum partial structures to get summed ones. Assuming all 
C---parameters are involved as gaussians
      IMPLICIT NONE
      INCLUDE 'agreem.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
C
      INTEGER IR
      REAL A_CALCS(*),B_CALCS(*)
      REAL FC(*),PHASE(*)
C
      INTEGER IP,IPOS
C
      DO    IP = 1,NPART+1
        IPOS   = IR+(IP-1)*NOBS
        A_CALCS(IP) = FC(IPOS)*COS(PHASE(IPOS))
        B_CALCS(IP) = FC(IPOS)*SIN(PHASE(IPOS))
      ENDDO
      RETURN
      END
C
      SUBROUTINE DMLINIT_R(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
      IMPLICIT NONE
C
C---Find initial values for maximum likelihood refinement
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'rharvest.fh'
C
      INTEGER NREF
      INTEGER NIND(*)
      REAL FO(*),FC(*),SIGO(*),PHASE(*),FREER(*)
      real fwt(*)
C
      INTEGER I,J,IREF,ICENT,ISYSAB,IHH(3)
      REAL YOS,YC_ALL,PHI_ALL,SIGOS,WT1,DY,STL_C,EPSI,RSQ,FOM
      EXTERNAL UNPACK,INDTORS,CENTR,EPSLON
C
      DO   I=1,NBIN_ML
        NREF_ML(I)     = 0
        SIGMA_ML(I)    = 1.0
        DO   J=1,NPART+1
          SCALE_ML(I,J)  = 1.0
        ENDDO
      ENDDO
C
C--If stage of refinement is early then sigma refinement is best done in bins
C
      IF(FREER_FLAG.AND.RFACTOR_FREE.GE.0.50) THEN
c         SIGMA_REFINE_STYLE = 'BINS'
      ELSE IF(RFACTOR_WORK.GE.0.50) THEN
c         SIGMA_REFINE_STYLE = 'BINS'
      ENDIF

      RETURN
      END
C
      SUBROUTINE DMLINIT_R1(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
      IMPLICIT NONE
C
C---Find initial values for maximum likelihood refinement.
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
C
      INTEGER NREF
      INTEGER NIND(*)
      REAL FO(*),FC(*),SIGO(*),PHASE(*),FREER(*)
      real fwt(*)
C
      integer iwei
      INTEGER I,IREF,ICENT,ISYSAB,IBIN,IHH(3),NC,IBIN_S
      REAL WT1,STL_C,EPSI,RSQ,XX,FOM
      REAL A_CALCS(NMAXPART),B_CALCS(NMAXPART),Y_C,A_ALL,B_ALL
      REAL SIGMA_ML0(MAXBIN)
      LOGICAL FREERCHK
      REAL SIM
      EXTERNAL SIM
      EXTERNAL UNPACK,INDTORS,CENTR,EPSLON
C
      NC  = 0
 1    CONTINUE
      DO   I=1,NBIN_ML
        NREF_ML(I) = 0
        SIGMA_ML0(I) = 0.0
      ENDDO

      IBIN_S = 1
      DO     IREF = 1,NREF
         iwei = nint(fwt(iref))
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN 
          IF((.NOT.MLUSEWORK)  .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       MLUSEWORK   .AND. 
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IREF).GT.0.0
     &       .and.fwt(iref).gt.0.0) THEN
            CALL INDTORS(NIND(IREF),RSQ)
            CALL UNPACK(NIND(IREF),IHH(1),IHH(2),IHH(3))
            CALL CENTR(IHH,ICENT)
            CALL EPSLON(IHH,EPSI,ISYSAB)
            WT1   = 2.0-REAL(ICENT)
            STL_C = SQRT(RSQ)
            IF(.NOT.(STL_C.GT.SMINB_ML(IBIN_S).AND.
     &               STL_C.LE.SMAXB_ML(IBIN_S))) THEN
              DO   IBIN=1,NBIN_ML
                IF(STL_C.GT.SMINB_ML(IBIN).AND.STL_C.LE.SMAXB_ML(IBIN)) 
     &                                           THEN
                  IBIN_S = IBIN
                  GOTO 50
                ENDIF
              ENDDO
              GOTO 100
            ENDIF
 50         CONTINUE
            CALL EXTRACT_ABS(IREF,FC,PHASE,A_CALCS,B_CALCS)
            A_ALL = 0.0
            B_ALL = 0.0
            DO   I=1,NPART+1
              A_ALL = A_ALL + A_CALCS(I)*SCALE_ML(IBIN_S,I)
              B_ALL = B_ALL + B_CALCS(I)*SCALE_ML(IBIN_S,I)
            ENDDO
            Y_C = SQRT(A_ALL**2 + B_ALL**2)
            XX  = FO(IREF)*Y_C/(EPSI*SIGMA_ML(IBIN_S))
            IF(ICENT.EQ.0) THEN
              FOM = SIM(2.0*XX)
            ELSE
              FOM = TANH(XX)
            ENDIF
            NREF_ML(IBIN_S) = NREF_ML(IBIN_S) + 
     &           iwei*(2-ICENT)
            SIGMA_ML0(IBIN_S) = SIGMA_ML0(IBIN_S) + 
     &           iwei*WT1*(FO(IREF)**2+Y_C**2- 
     &                          2.0*FOM*FO(IREF)*Y_C)/EPSI
        ENDIF
 100    CONTINUE
      ENDDO
      DO   I=1,NBIN_ML
        IF(NREF_ML(I).GT.0) THEN
          SIGMA_ML(I) = AMAX1(SIGMA_ML0(I)/FLOAT(NREF_ML(I)),1.0)
        ELSE
          CALL ERRWRT(1,'No reflections in resolution bin ???????')
        ENDIF
      ENDDO
      NC = NC + 1
      IF(NC.LT.20) GOTO 1
C
      RETURN
      END
C
      SUBROUTINE DMLINIT_R2(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
      IMPLICIT NONE
C
C---Find initial values for maximum likelihood refinement.
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
C
      INTEGER NREF
      INTEGER NIND(*)
      REAL FO(*),FC(*),SIGO(*),PHASE(*),FREER(*)
      real fwt(*)
C
      INTEGER I,IREF,ICENT,ISYSAB,IBIN,IHH(3),NC,IBIN_S
      REAL WT1,STL_C,EPSI,RSQ,XX,FOM
      REAL A_CALCS(NMAXPART),B_CALCS(NMAXPART),Y_C,A_ALL,B_ALL
      REAL SIGMA_ML0(MAXBIN)
      LOGICAL FREERCHK
      REAL SIM
      EXTERNAL SIM
      EXTERNAL UNPACK,INDTORS,CENTR,EPSLON
C
      NC  = 0
 1    CONTINUE
      DO   I=1,NBIN_ML
        NREF_ML(I) = 0
        SIGMA_ML0(I) = 0.0
        SIGMA_ML1(I) = 0.0
      ENDDO
 
      IBIN_S = 1
      DO     IREF = 1,NREF
        FREERCHK = .FALSE.
        IF(FREER_FLAG )THEN
          IF((.NOT.MLUSEWORK)  .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
          IF(       MLUSEWORK   .AND.
     +    (ABS(FREER(IREF)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
        END IF
        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IREF).GT.0.0
     &       .and.fwt(iref).gt.0.0) THEN
            CALL INDTORS(NIND(IREF),RSQ)
            CALL UNPACK(NIND(IREF),IHH(1),IHH(2),IHH(3))
            CALL CENTR(IHH,ICENT)
            CALL EPSLON(IHH,EPSI,ISYSAB)
            WT1   = 2.0-REAL(ICENT)
            STL_C = SQRT(RSQ)
            IF(.NOT.(STL_C.GT.SMINB_ML(IBIN_S).AND.
     &               STL_C.LE.SMAXB_ML(IBIN_S))) THEN
              DO   IBIN=1,NBIN_ML
                IF(STL_C.GT.SMINB_ML(IBIN).AND.STL_C.LE.SMAXB_ML(IBIN))
     &                                           THEN
                  IBIN_S = IBIN
                  GOTO 50
                ENDIF
              ENDDO
              GOTO 100
            ENDIF
 50         CONTINUE
            CALL EXTRACT_ABS(IREF,FC,PHASE,A_CALCS,B_CALCS)
            A_ALL = 0.0
            B_ALL = 0.0
            DO   I=1,NPART+1
              A_ALL = A_ALL + A_CALCS(I)*SCALE_ML(IBIN_S,I)
              B_ALL = B_ALL + B_CALCS(I)*SCALE_ML(IBIN_S,I)
            ENDDO
            Y_C = SQRT(A_ALL**2 + B_ALL**2)
            XX  = FO(IREF)*Y_C/(EPSI*SIGMA_ML(IBIN_S))
            IF(ICENT.EQ.0) THEN
              FOM = SIM(2.0*XX)
            ELSE
              FOM = TANH(XX)
            ENDIF
            NREF_ML(IBIN_S) = NREF_ML(IBIN_S) + 
     &           nint(fwt(iref))*(2-ICENT)
            SIGMA_ML0(IBIN_S) = SIGMA_ML0(IBIN_S) +
     &        fwt(iref)*WT1*(FO(IREF)**2+Y_C**2- 
     &                       2.0*FOM*FO(IREF)*Y_C)/EPSI
            SIGMA_ML1(IBIN_S) = SIGMA_ML1(IBIN_S)+
     &           fwt(iref)*WT1*(FOM*FO(IREF)-Y_C)**2/EPSI
        ENDIF
 100    CONTINUE
      ENDDO
      DO   I=1,NBIN_ML
        IF(NREF_ML(I).GT.0) THEN
          SIGMA_ML(I)  = SIGMA_ML0(I)/REAL(NREF_ML(I))
          SIGMA_ML1(I) = SIGMA_ML1(I)/REAL(NREF_ML(I))
        ELSE
          CALL ERRWRT(1,'No reflections in resolution bin ???????')
        ENDIF
      ENDDO
      NC = NC + 1
      IF(NC.LT.10) GOTO 1
C
      RETURN
      END
C
      SUBROUTINE PH_PROB_RICE(ICENT,XX,COSC,SINC,COSAA,SINAA,
     +            COS2A,SIN2A,APROB,XC)
C
C---Calculate expected values of cosphi and sinphi assuming that 
C---distribution is Rice distribution
      INCLUDE 'const.fh'

      REAL SIM
      EXTERNAL SIM
C
      IF(ICENT.EQ.0) THEN
        FOM = SIM(XX)
      ELSE
        FOM = TANH(XX)
      ENDIF
      COSAA = COSC*FOM
      SINAA = SINC*FOM
      IF(ICENT.EQ.0) THEN
        IF(ABS(XX).GT.0.0) THEN
          CALL BESSI0(XX,APROB,XC)
          COS2A = (1.0 - 2.0*FOM/XX)*(COSC*COSC-SINC*SINC)
          SIN2A = (1.0 - 2.0*FOM/XX)*2.0*COSC*SINC
        ELSE
          XC    = 0.0
          COS2A = 0.0
          SIN2A = 0.0
        ENDIF
      ELSE
        IF(XX.LT.30.0) THEN
           APROB = COSH(XX)
           XC    = 0.0
        ELSE
           APROB = 1.0/2.0
           XC    = XX 
        ENDIF
        COS2A = COSC*COSC - SINC*SINC
        SIN2A = 2.0*SINC*COSC
      ENDIF

      RETURN
      END
C
      SUBROUTINE PH_PROB_RICE_0(ICENT,XX,APROB,XC)
C
C---Calculate expected values of cosphi and sinphi assuming that 
C---distribution is Rice distribution
      INCLUDE 'const.fh'

      REAL SIM
      EXTERNAL SIM
C
      IF(ICENT.EQ.0) THEN
        IF(ABS(XX).GT.0.0) THEN
          CALL BESSI0(XX,APROB,XC)
        ELSE
          XC    = 0.0
          APROB = 1.0
        ENDIF
      ELSE
        IF(XX.LT.60.0) THEN
           APROB = COSH(XX)
           XC    = 0.0
        ELSE
           APROB = 1.0/2.0
           XC    = XX 
        ENDIF
      ENDIF

      RETURN
      END
C
      SUBROUTINE PHASE_PROB(ICENT,HLA,HLB,HLC,HLD,COSC,SINC,COSAA,
     +             SINAA,COS2A,SIN2A,ANORM,XC)
C
      REAL HLA,HLB,HLC,HLD
C
      IF(ICENT.EQ.0) THEN
        CALL PHPROB(HLA,HLB,HLC,HLD,COSAA,SINAA,COS2A,SIN2A,ANORM,XC)
      ELSE
        CALL PHPROB_CENTR(HLA,HLB,COSAA,SINAA,ANORM,XC)
        COS2A = 2.0*COSC*COSC - 1.0
        SIN2A = 2.0*COSC*SINC 
      ENDIF
      RETURN
      END
C
      SUBROUTINE PHASE_PROB_0(ICENT,HLA,HLB,HLC,HLD,COSAA,SINAA)
C
C---Calculates weighted cos and sin from given HL A,B,C,D
      REAL HLA,HLB,HLC,HLD,COSAA,SINAA
C
      IF(ICENT.EQ.0) THEN
        CALL PHPROB_0(HLA,HLB,HLC,HLD,COSAA,SINAA)
      ELSE
        CALL PHPROB_CENTR_0(HLA,HLB,COSAA,SINAA)
      ENDIF
      RETURN
      END
C
      SUBROUTINE PHPROB(HLA,HLB,HLC,HLD,COSAA,SINAA,COS2A,SIN2A,
     +           ANORM,XC)
C
C----This subroutine calculates expected value of cos, sin, cos2, sin2
C----for acentric reflections
C----
C     Parameters 
C
C    HLA,HLB,HLC,HLD   - Hendrickson-Lattman coefficients of phase 
C                        probability distribution
C
C    COSA  = <COS(alpha)>
C    SINA  = <SIN(alpha)>
C    COS2A = <COS(2alpha)>
C    SIN2A = <SIN(2alpha)>
C
C    ANORM - normalisation coefficient of probability distribution
C
C    XC    - Value subtracted from exponentila to make it good behaved
      INCLUDE 'expcost.fh'
      INCLUDE 'const.fh'
      REAL HLA,HLB,HLC,HLD
cd      DOUBLE PRECISION EXPARGD,COSAA1,SINAA1,COS2A1,SIN2A1,ANORM1
      REAL EXPARGD,COSAA1,SINAA1,COS2A1,SIN2A1,ANORM1

C
C---First find maximum value of argument. If it is larger than
C---largest possible value of argumenent then calculate correction 
C---to subtract from exponentional argument
      INTEGER I,IND
      REAL XC,ARGHI,HLC1,HLD1,COSP1,SINP1,COS2P1,SIN2P1,ARGC
      REAL ARG(NMAXTRIG)
      ARGHI = -1.0E32
      COSP1 = 1.0
      SINP1 = 0.0
      XX0   = SQRT(HLA*HLA + HLB*HLB)
      IF(XX0.GT.0.0) THEN
        COSP1 = HLA/XX0
        SINP1 = HLB/XX0
        COS2P1 = COSP1*COSP1 - SINP1*SINP1
        SIN2P1 = 2.0*COSP1*SINP1
      ENDIF
      HLC1 =  HLC*COS2P1 + HLD*SIN2P1
      HLD1 = -HLC*SIN2P1 + HLD*COS2P1
      DO     I=1,NMAXTRIG,NTRIGINC
        ARG(I) = XX0*COS1_TAB(I) +COS2_TAB(I)*HLC1 + 
     +                    SIN2_TAB(I)*HLD1
        IF(ARGHI.LE.ARG(I)) ARGHI = ARG(I)
      ENDDO
      XC = 0.0
      IF(ARGHI.GT.ARGMAX) XC = ARGHI - ARGMAX + 0.01
C
C---Calculate integrals
      COSAA1 = 0.0
      SINAA1 = 0.0
      COS2A1 = 0.0
      SIN2A1 = 0.0
      ANORM1 = 0.0
C
C---Calculate expected values of cos(alpha),sin(alpha),cos(2alpha),sin(2alpha)
C---and normalisation coefficients. 
      DO     I=1,NMAXTRIG,NTRIGINC
        ARGC = ARG(I)-XC
        IND = INT(ABS(ARGC)/ARGSTEP+1.5)
        IF(IND.LT.1) IND = 1
        IF(IND.GT.NMAXEXP+1) IND = NMAXEXP+1
        IF(ARGC.GE.0.0) THEN
           EXPARGD = ETAB(IND)
        ELSE IF(ARGC.LT.0.0.AND.ARGC.GT.-ARGMAX) THEN 
           EXPARGD = 1.0/ETAB(IND)
        ELSE 
          EXPARGD = 0.0
        ENDIF
        ANORM1  = ANORM1 + EXPARGD
        COSAA1  = COSAA1 + COS1_TAB(I)*EXPARGD
        SINAA1  = SINAA1 + SIN1_TAB(I)*EXPARGD
        COS2A1  = COS2A1 + COS2_TAB(I)*EXPARGD
        SIN2A1  = SIN2A1 + SIN2_TAB(I)*EXPARGD
      ENDDO
      COSAA  = (COSP1*COSAA1 - SINP1*SINAA1)/ANORM1
      SINAA  = (SINP1*COSAA1 + COSP1*SINAA1)/ANORM1
      COS2A  = (COS2P1*COS2A1 - SIN2P1*SIN2A1)/ANORM1
      SIN2A  = (SIN2P1*COS2A1 + COS2P1*SIN2A1)/ANORM1
      ANORM  = ANORM1/TWOPI*WIDTH
      RETURN
      END
C
      SUBROUTINE PHPROB_0(HLA,HLB,HLC,HLD,COSAA,SINAA)
C
C----This subroutine calculates expected value of cos, sin
C----
C     Parameters 
C
C    HLA,HLB,HLC,HLD   - Hendrickson-Lattman coefficients of phase 
C                        probability distribution
C
C    COSA  = <COS(alpha)>
C    SINA  = <SIN(alpha)>
C
      INCLUDE 'expcost.fh'
      INCLUDE 'const.fh'
      REAL HLA,HLB,HLC,HLD
cd      DOUBLE PRECISION EXPARGD,COSAA1,SINAA1,COS2A1,SIN2A1,ANORM1
      REAL EXPARGD,COSAA1,SINAA1,ANORM1

C
C---First find maximum value of argument. If it is larger than
C---largest possible value of argumenent then calculate correction 
C---to subtract from exponentional argument
      INTEGER I,IND
      REAL XC,ARGHI,HLC1,HLD1,COSP1,SINP1,COS2P1,SIN2P1,ARGC
      REAL ARG(NMAXTRIG)
C
      ARGHI = -1.0E32
      COSP1 = 1.0
      SINP1 = 0.0
      XX0   = SQRT(HLA*HLA + HLB*HLB)
      IF(XX0.GT.0.0) THEN
        COSP1 = HLA/XX0
        SINP1 = HLB/XX0
        COS2P1 = COSP1*COSP1 - SINP1*SINP1
        SIN2P1 = 2.0*COSP1*SINP1
      ENDIF
      HLC1 =  HLC*COS2P1 + HLD*SIN2P1
      HLD1 = -HLC*SIN2P1 + HLD*COS2P1
      DO     I=1,NMAXTRIG,NTRIGINC
        ARG(I) = XX0*COS1_TAB(I) +COS2_TAB(I)*HLC1 + 
     +                    SIN2_TAB(I)*HLD1
        IF(ARGHI.LE.ARG(I)) ARGHI = ARG(I)
      ENDDO
      XC = 0.0
      IF(ARGHI.GT.ARGMAX) XC = ARGHI - ARGMAX + 0.01
C
C---Calculate integrals
      COSAA1 = 0.0
      SINAA1 = 0.0
      ANORM1 = 0.0
C
C---Calculate expected values of cos(alpha),sin(alpha)
C---and the normalisation coefficient. 
      DO     I=1,NMAXTRIG,NTRIGINC
        ARGC = ARG(I)-XC
        IND = INT(ABS(ARGC)/ARGSTEP+1.5)
        IF(IND.LT.1) IND = 1
        IF(IND.GT.NMAXEXP+1) IND = NMAXEXP+1
        IF(ARGC.GE.0.0) THEN
           EXPARGD = ETAB(IND)
        ELSE IF(ARGC.LT.0.0.AND.ARGC.GT.-ARGMAX) THEN 
           EXPARGD = 1.0/ETAB(IND)
        ELSE 
          EXPARGD = 0.0
        ENDIF
        ANORM1  = ANORM1 + EXPARGD
        COSAA1  = COSAA1 + COS1_TAB(I)*EXPARGD
        SINAA1  = SINAA1 + SIN1_TAB(I)*EXPARGD
      ENDDO
      COSAA  = (COSP1*COSAA1 - SINP1*SINAA1)/ANORM1
      SINAA  = (SINP1*COSAA1 + COSP1*SINAA1)/ANORM1
      RETURN
      END
C
      SUBROUTINE PHPROB_2(HLA,HLB,HLC,HLD,COSAA,SINAA,ANORM,XC)
C
C---same as phrpob_0 except it returns value of function also.
C
C----This subroutine calculates expected value of cos, sin
C----
C     Parameters
C
C    HLA,HLB,HLC,HLD   - Hendrickson-Lattman coefficients of phase
C                        probability distribution
C
C    COSA  = <COS(alpha)>
C    SINA  = <SIN(alpha)>
C
      INCLUDE 'expcost.fh'
      INCLUDE 'const.fh'
      REAL HLA,HLB,HLC,HLD
cd      DOUBLE PRECISION EXPARGD,COSAA1,SINAA1,COS2A1,SIN2A1,ANORM1
      REAL EXPARGD,COSAA1,SINAA1,ANORM1

C
C---First find maximum value of argument. If it is larger than
C---largest possible value of argumenent then calculate correction
C---to subtract from exponentional argument
      INTEGER I,IND
      REAL XC,ARGHI,HLC1,HLD1,COSP1,SINP1,COS2P1,SIN2P1,ARGC
      REAL ARG(NMAXTRIG)
C
      ARGHI = -1.0E32
      COSP1 = 1.0
      SINP1 = 0.0
      XX0   = SQRT(HLA*HLA + HLB*HLB)
      IF(XX0.GT.0.0) THEN
        COSP1 = HLA/XX0
        SINP1 = HLB/XX0
        COS2P1 = COSP1*COSP1 - SINP1*SINP1
        SIN2P1 = 2.0*COSP1*SINP1
      ENDIF
      HLC1 =  HLC*COS2P1 + HLD*SIN2P1
      HLD1 = -HLC*SIN2P1 + HLD*COS2P1
      DO     I=1,NMAXTRIG,NTRIGINC
        ARG(I) = XX0*COS1_TAB(I) +COS2_TAB(I)*HLC1 +
     +                    SIN2_TAB(I)*HLD1
        IF(ARGHI.LE.ARG(I)) ARGHI = ARG(I)
      ENDDO
      XC = 0.0
      IF(ARGHI.GT.ARGMAX) XC = ARGHI - ARGMAX + 0.01
C
C---Calculate integrals
      COSAA1 = 0.0
      SINAA1 = 0.0
      ANORM1 = 0.0
C
C---Calculate expected values of cos(alpha),sin(alpha)
C---and the normalisation coefficient.
      DO     I=1,NMAXTRIG,NTRIGINC
        ARGC = ARG(I)-XC
        IND = INT(ABS(ARGC)/ARGSTEP+1.5)
        IF(IND.LT.1) IND = 1
        IF(IND.GT.NMAXEXP+1) IND = NMAXEXP+1
        IF(ARGC.GE.0.0) THEN
           EXPARGD = ETAB(IND)
        ELSE IF(ARGC.LT.0.0.AND.ARGC.GT.-ARGMAX) THEN
           EXPARGD = 1.0/ETAB(IND)
        ELSE
          EXPARGD = 0.0
        ENDIF
        ANORM1  = ANORM1 + EXPARGD
        COSAA1  = COSAA1 + COS1_TAB(I)*EXPARGD
        SINAA1  = SINAA1 + SIN1_TAB(I)*EXPARGD
      ENDDO
      COSAA  = (COSP1*COSAA1 - SINP1*SINAA1)/ANORM1
      SINAA  = (SINP1*COSAA1 + COSP1*SINAA1)/ANORM1
      ANORM  = ANORM1/TWOPI*WIDTH
      RETURN
      END
C

      SUBROUTINE PHPROB_CENTR(HLA,HLB,COSAA,SINAA,ANORM,XC)
C
C---Calculate expected values of cos(alpha),sin(alpha) for centric reflections
C---HLA and HLB  Hendrickson and Konnert coefficients
C---PH0  one of two possible values of centric phases
C---SINAA COSAA expected values of sina and cosa
      IMPLICIT NONE
      INCLUDE 'expcost.fh'
      REAL HLA,HLB,SINAA,COSAA,ANORM,XC
      REAL FOMM,XX
C
      XX    = SQRT(HLA**2+HLB**2)
      COSAA = 1.0
      SINAA = 0.0
      FOMM  = TANH(XX)
      IF(XX.GT.0.0) THEN
        COSAA = FOMM*HLA/XX
        SINAA = FOMM*HLB/XX
      ENDIF
      XC  = 0.0
      IF(XX.GT.30.0) THEN
         XC    = XX
         ANORM = 1.0/2.0
      ELSE
         XC    = 0.0
         ANORM = COSH(XX)
      ENDIF
      RETURN
      END
C
      SUBROUTINE PHPROB_CENTR_0(HLA,HLB,COSAA,SINAA)
C
C---Calculate expected values of cos(alpha),sin(alpha) for centric reflections
C---HLA and HLB  Hendrickson and Konnert coefficients
C---PH0  one of two possible values of centric phases
C---SINAA COSAA expected values of sina and cosa
      INCLUDE 'expcost.fh'
      REAL HLA,HLB
C
      XX    = SQRT(HLA**2+HLB**2)
      FOMM  = TANH(XX)
      COSAA = 1.0
      SINAA = 0.0
      IF(XX.GT.0.0) THEN
        COSAA = FOMM*HLA/XX
        SINAA = FOMM*HLB/XX
      ENDIF
      RETURN
      END
C
       SUBROUTINE APPLYSCALES(NREF,NIND,IP1,NPART1,FO,SIGO,FC)
C
C---Applies scale factors to amplitudes of structure factors
C---If IP1 = 0 then it will apply 1/scale(NPART1) to FO-s
C---If APPLY_SCALE_TO is equal to 'OBSE' then scale B-value of 
C---(NPART+1)-th partial structure will be applied to observed 
C---structure factors. Babinet's bulk solvent correction is not applied here.
C
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
C
      INTEGER NIND(*)
      REAL FO(*),FC(*),SIGO(*)
      REAL S1,S2,S3,S11,S22,S33,S12,S13,S23,RSQ
      INTEGER IP
      EXTERNAL UNPACK
C
       DO     IREF = 1,NREF
         CALL INDTORS(NIND(IREF),RSQ)
         RSQ = RSQ/4.0
         CALL UNPACK(NIND(IREF),IHH,IKK,ILL)
         EXPAN = 1.0
         IF(B_LS_ANISO_OVER_FLAG) THEN
           S1 = FLOAT(IHH)*RCELL(1)
           S2 = FLOAT(IKK)*RCELL(2)
           S3 = FLOAT(ILL)*RCELL(3)
           S11 = S1*S1
           S22 = S2*S2
           S33 = S3*S3
           S12 = 2.0*S1*S2
           S13 = 2.0*S1*S3
           S23 = 2.0*S2*S3
           SBS = B_LS_ANISO_OVER(1)*S11 + B_LS_ANISO_OVER(2)*S22 + 
     &           B_LS_ANISO_OVER(3)*S33 + B_LS_ANISO_OVER(4)*S12 +
     &           B_LS_ANISO_OVER(5)*S13 + B_LS_ANISO_OVER(6)*S23
           EXPAN = EXP(-SBS)
         ENDIF
C
C---Assume. Isotropic equavalent of aniso B already has been 
C---applied to coordinates
         IPOS = IREF+NPART*NOBS
         FC(IPOS)   = FC(IPOS)*EXP(-RSQ*B_LS_OVER)
         FO(IREF)   = FO(IREF)/(SCALE_LS_OVER*EXPAN)
         SIGO(IREF) = SIGO(IREF)/(SCALE_LS_OVER*EXPAN)
         DO    IP=1,NPART
           IPOS     = IREF + (IP-1)*NOBS
           FC(IPOS) = FC(IPOS)*SCALE_LS_PART(IP)*
     &                 EXP(-RSQ*(B_LS_PART(IP)+B_LS_OVER))
         ENDDO
       ENDDO
       RETURN
       END
c
       SUBROUTINE APPLYSCALES_map(NREF,NIND,FO,SIGO)
C
C---Applies scale factors to amplitudes of structure factors
C---If IP1 = 0 then it will apply 1/scale(NPART1) to FO-s
C---If APPLY_SCALE_TO is equal to 'OBSE' then scale B-value of 
C---(NPART+1)-th partial structure will be applied to observed 
C---structure factors. Babinet's bulk solvent correction is not applied here.
C
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
C
      INTEGER NIND(*)
      REAL FO(*),SIGO(*)
      REAL S1,S2,S3,S11,S22,S33,S12,S13,S23,RSQ
      INTEGER IP
      EXTERNAL UNPACK
C
       DO     IREF = 1,NREF
         CALL INDTORS(NIND(IREF),RSQ)
         RSQ = RSQ/4.0
         CALL UNPACK(NIND(IREF),IHH,IKK,ILL)
         EXPAN = 1.0
         IF(B_LS_ANISO_OVER_FLAG) THEN
           S1 = FLOAT(IHH)*RCELL(1)
           S2 = FLOAT(IKK)*RCELL(2)
           S3 = FLOAT(ILL)*RCELL(3)
           S11 = S1*S1
           S22 = S2*S2
           S33 = S3*S3
           S12 = 2.0*S1*S2
           S13 = 2.0*S1*S3
           S23 = 2.0*S2*S3
           SBS = B_LS_ANISO_OVER(1)*S11 + B_LS_ANISO_OVER(2)*S22 + 
     &           B_LS_ANISO_OVER(3)*S33 + B_LS_ANISO_OVER(4)*S12 +
     &           B_LS_ANISO_OVER(5)*S13 + B_LS_ANISO_OVER(6)*S23
           EXPAN = EXP(-SBS)
         ENDIF
C
C---Assume. Isotropic equavalent of aniso B already has been 
C---applied to coordinates
         FO(IREF)   = FO(IREF)/(SCALE_LS_OVER*EXPAN)
         SIGO(IREF) = SIGO(IREF)/(SCALE_LS_OVER*EXPAN)
       ENDDO
       RETURN
       END
