      subroutine read_psuedorest
c
c---This routine reads external restraints and adds them to 
c---the bond file. 
      implicit none
      include 'atom_com.fh'
      include 'restr_files.fh'
c
c---  locals
c
c---  Things for psuedo restraints
      integer ierr
      integer ia1,ia2,i1,i2,i3,i4,ibtype
      character psuedorest_file*512
      character symm_in*1
      integer   maxatom_in_rest
      parameter (maxatom_in_rest = 50)
      integer   iatom_number(maxatom_in_rest)
      integer isym_out(4,maxatom_in_rest)
      logical dist_defined,sigma_defined,type_defined,prob_defined
      integer ires_in(maxatom_in_rest)
      character ins_in(maxatom_in_rest)*1
      character atom_in(maxatom_in_rest)*4
      character alt_in(maxatom_in_rest)*1
      character chain_in(maxatom_in_rest)*4
      character symm_in1(maxatom_in_rest)*1
      integer   iat,nrest_now
      real dist_value,sigma_value,prob_in
      integer ia_first_atom,ia_last_atom
c
c---  Things for parser
      integer maxtok,ntok,itk,itk_in,itk_out
      parameter (maxtok = 500)
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*600,key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer iend_r,lend_f
c
c---  loops and others
      integer   ifile,lps,nfile
      integer   i,j,k,l,ich,ires,ia,ir_first,ir_last,ia_first,ia_last
      integer   jrs
      character alt_code*1,ins_code*1,type_in*10
      character asmgrp*4
      integer   ipsuedo,ibond,iscrk,file_in
      integer   nbonds
      integer   nplans,nmaxatom_in_plane,npl,np1,ip
      integer   iplan
      integer   nchir,nch1,ic
      integer   ichir
c
      character rest_type*4
      logical   rest_flag
c
c---For atom reader
      integer nkeywords
      character EndKeywords(100)*4
      character symm1*1
      character chain1*4,ins1*1,alt1*1,atom1*4
      integer   ires1
c
c---temporary small arrays to read files
      integer ia1_t(200)
      integer is_t(4,200)
      real    rs_vidl_t(2)
c
c----allocatables
      integer iend_b
      integer nb1,ib
      integer, allocatable :: ia1_b(:,:)
      integer, allocatable :: is_bond(:,:)
      integer, allocatable :: ibond_type(:)
      real,    allocatable :: rs_vidl_b(:,:)
c
c---  chiral
      integer iangle,nangles,nan1
      integer, allocatable :: ia1_a(:,:)
      integer, allocatable :: is_a(:,:,:)
      real,    allocatable :: rs_vidl_a(:,:)
c
c---  chiral
      integer ichir_sign1
      integer, allocatable :: ia1_c(:,:)
      integer, allocatable :: ichir_sign(:)
      integer, allocatable :: is_c(:,:,:)
      real,    allocatable :: rs_vidl_c(:,:)    
c
c---  planes
      integer, allocatable :: ia1_p(:,:)
      integer, allocatable :: nplane(:)
      integer, allocatable :: is_p(:,:,:)
      real,    allocatable :: rs_vidl_p(:,:)
c
c---  torsions
      integer itors,ntors,nt1,itor_fl
      integer it,it_period
      character    tors_l1*8
      character*8, allocatable :: tors_labels(:)
      integer,     allocatable :: ia1_tors(:,:)
      integer,     allocatable :: is_tors(:,:,:)
      integer,     allocatable :: tors_flag(:)
      integer,     allocatable :: tors_period(:)
      real,        allocatable :: rs_vidl_tors(:,:)
c
c---  interval
      integer iint,nint
      real dmin,dmax
      logical dmin_defined,dmax_defined
      integer nint1
      integer, allocatable :: ia1_int(:,:)
      integer, allocatable :: is_int(:,:)
      real,    allocatable :: rs_vidl_int(:,:)
c
c--externals
      integer lenstr
      external lenstr
c
c---- Body
c
c---  Instruction may come from two sources. 1) External psuedorestraint file
c---  and 2) usual keyword file. Usual keyword would be sufficient. 
c---  Unfortunately psuedorestraint file has already been declared and out on 
c---  the web
      call ugtenv('PSRESTIN',psuedorest_file)
      lps = lenstr(psuedorest_file)
      if(lps.gt.0) then
         call open_form_file(ipsuedo,psuedorest_file,ierr)
         if(ierr.ne.0) then
            write(*,*)'Problem with psuedo restraint file'
         endif
      endif

      write(*,*)'We are here'
      call open_form_file(iscrk,keywords_file,ierr)
      if(ierr.ne.0) then
         write(*,*)'Problem with keywords file'
         call errwrt(1,'Can not continue')
      endif
c
c---bonds
      call open_unform_file(ibond,bond_file,ierr)
      if(ierr.ne.0) then
         call errwrt(1,'In read_psuedorest. Opening bond file')
      endif
c--read till the end
      nbonds = 0
      read(ibond,iostat=iend_b)nbonds
      do while(iend_b.eq.0)
         read(ibond,iostat=iend_b) ia1_t(1:2),rs_vidl_t(1:2),
     &        i1,i2,i3,i4,ibtype
      enddo
c
c----angles
      call open_unform_file(iangle,angle_file,ierr)
      if(ierr.ne.0) then
         call errwrt(1,'In read_psuedorest. Opening bond file')
      endif
c--read till the end
      nangles = 0
      read(iangle,iostat=iend_b)nangles
      do while(iend_b.eq.0)
         read(iangle,iostat=iend_b) ia1_t(1:3),is_t(1:4,1:3),
     &        rs_vidl_t(1:2)
      enddo
c
c---planes
      call open_unform_file(iplan,plane_file,ierr)
      if(ierr.ne.0) then
         call errwrt(1,'In read_psuedorest. Opening plane file')
      endif
      nplans = 0
      read(iplan,iostat=iend_b)nplans,nmaxatom_in_plane
      do while(iend_b.eq.0)
         read(iplan,iostat=iend_b)npl,rs_vidl_t(1:2),ia1_t(1:npl),
     &        is_t(1:4,1:npl)
      enddo
c
      call open_unform_file(ichir,chir_file,ierr)
      if(ierr.ne.0) then
         call errwrt(1,'In read_psuedorest. Opening chirality file')
      endif
      nchir = 0
      read(ichir,iostat=iend_b)nchir
      do while(iend_b.eq.0) 
         read(ichir,iostat=iend_b)ia1_t(1:4),is_t(1:4,1:4),
     &        rs_vidl_t(1:2),ichir_sign1
      enddo
c
c---Torsion angles
      call open_unform_file(itors,tors_file,ierr)
      if(ierr.ne.0) then
         call errwrt(1,'In read_psuedorest. Opening chirality file')
      endif
      ntors = 0
      read(itors,iostat=iend_b)ntors
      do while(iend_b.eq.0) 
         read(itors,iostat=iend_b)tors_l1,ia1_t(1:4),is_t(1:4,1:4),
     &        it_period,
     &        rs_vidl_t(1:2),itor_fl
      enddo
c
c---  angles? Why I do not know

c
c---  NMR NOE restraints
      if(interval_file(1:1).eq.' ') then
         call find_unique_file_name(interval_file,'_INT_R')
      endif
      call open_unform_file(iint,interval_file,ierr)
      if(ierr.gt.0) then
         call errwrt(1,'In read_psuedorest. Opening interval file')
      endif
      nint = 0
      read(iint,iostat=iend_b) nint
      if(iend_b.eq.0) then
         do  while(iend_b.eq.0)
            read(iint,iostat=iend_b)ia1_t(1:2),is_t(1:4,1),
     &           dmin,dmax,rs_vidl_t(1)
         enddo
      else
         nint = 0
      endif
      nint1 = nint
c
c--Do we need harmonic restraints?

c
c---Now read to read external restraints and add to files.

C
      lend = .TRUE.
      key  = ' '
      ierr = 0
      lend_f = 0
c
c---  If psuedo restraint file is present then use this file first
c---  Instructions from the keywords file have higher priority
      nfile = 1
      if(lps.le.0) nfile = 2
      do ifile=nfile,2
         if(ifile.eq.1) then
            file_in = ipsuedo
         else
            file_in = iscrk
         endif
         lend_f = 0
         key    = ' '
         do while(lend_f.eq.0.and.key(1:3).ne.'END') 
c.and.ierr.eq.0)
            dist_defined = .FALSE.
            sigma_defined = .FALSE.
            type_defined  = .FALSE.
            prob_defined = .FALSE.
            dmin_defined = .FALSE.
            dmax_defined = .FALSE.
            lprint = .FALSE.
            line = ' '
            key = ' '
            symm_in ='N'
            do while(line.eq.' '.and.lend_f.eq.0)
               read(file_in,'(a)',iostat=lend_f)line
            enddo
            if(lend_f.lt.0) goto 888
            
            ntok = maxtok
            call parser(key,line,ibeg,iend,itype,fvalue,cvalue,idec,
     &           ntok,lend,lprint)
            call ccpupc(key)
            do  itk=2,ntok
               call ccpupc(cvalue(itk))
            enddo
            iat=0
            nkeywords = 11
            EndKeywords(1) = 'FIRS'
            EndKeywords(2) = 'SECO'
            EndKeywords(3) = 'ATRE'
            EndKeywords(4) = 'ATIN'
            EndKeywords(5) = 'VALU'
            EndKeywords(6) = 'SIGM'
            EndKeywords(7) = 'TYPE'
            EndKeywords(8) = 'PROB'
            EndKeywords(9) = 'DMIN'
            EndKeywords(10) = 'DMAX'
            EndKeywords(11) = 'NEXT'

            if(key.eq.'EXTE') then
               itk = 2
               rest_type = cvalue(itk)
               rest_flag = .FALSE.
               if(cvalue(itk).eq.'DIST'.or.cvalue(itk).eq.'PLAN'.or.
     &            cvalue(itk).eq.'CHIR'.or.
     &            cvalue(itk).eq.'ANGL'.or.cvalue(itk).eq.'INTE'.or.
     &            cvalue(itk).eq.'TORS') then
                  rest_flag = .TRUE.
               endif
               if(rest_flag) then
                  itk = itk+1
                  do while(itk.le.ntok)
                     if(cvalue(itk).eq.'FIRS'.or.
     &                    cvalue(itk).eq.'SECO'.or.
     &                    cvalue(itk).eq.'NEXT'.or.
     &                    cvalue(itk).eq.'ATRE'.or.
     &                    cvalue(itk).eq.'ATIN') then
                        itk = itk + 1
                        call read_external_atom_info(ntok,nkeywords,
     &                       itk,itk_out,
     &                       ibeg,iend,ires1,ierr,cvalue,line,
     &                       chain1,ins1,atom1,alt1,symm1,
     &                       EndKeywords)
                        if(ierr.gt.0) then
                           ierr = 5
                           write(*,*)
     &                       'Problem while reading external restraints'
                           goto 999
                        endif
                        itk = itk_out
                        iat = iat + 1
                        if(iat.gt.maxatom_in_rest) then
                           write(*,*) 'Too many atoms in one restraint'
                           write(*,*)'Maximum allowed = ',
     &                          maxatom_in_rest
                           ierr = 6
                           goto 999
                        endif
c     
                        chain_in(iat) = chain1
                        ires_in(iat)  = ires1
                        ins_in(iat)   = ins1
                        atom_in(iat)  = atom1
                        alt_in(iat)   = alt1
                        symm_in1(iat) = symm1
                     else if(cvalue(itk).eq.'VALU') then
                        itk = itk+1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)dist_value
c     dist_value = fvalue(itk)
                        dist_defined = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'DMIN') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).eq.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)dmin
                        dmin_defined = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'DMAX') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).eq.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)dmax
                        dmax_defined = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'SIGM') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)sigma_value
c     sigma_value = fvalue(itk)
                        sigma_defined = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'TYPE') then
                        itk = itk + 1
                        type_in = line(ibeg(itk):iend(itk))
                        type_defined = .TRUE.
                        itk = itk + 1
                     else if(cvalue(itk).eq.'PROB') then
                        itk = itk+1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)prob_in
c     prob_in = fvalue(itk)
                        prob_defined = .TRUE.
                        itk=itk+1
                     else if(cvalue(itk).eq.'SYMM') then
                        itk = itk + 1
                        if(itk.gt.ntok) then
                           ierr = 1
                           goto 999
                        endif
                        if(cvalue(itk)(1:1).eq.'Y') then
                           symm_in = 'Y'
                           itk = itk + 1
                        endif
                     else
                        itk = itk + 1
                     endif
                  enddo
               endif
c     
c---  Now check if everything is o.k. I.e. we have all necessary information
               if(.not.dist_defined.and.rest_type.ne.'PLAN'.and.
     &              rest_type.eq.'INTE') then
                  call errwrt(-1,'The ideal value for this restraint'//
     &                 ' must be defined')
                  ierr = 1
                  goto 999
               endif
               nrest_now = iat
               if(.not.sigma_defined) sigma_value = 0.02

               if(.not.type_defined) type_in = 'External'
c     
C---  Now find atomic numbers and write to a file
               do i=1,nrest_now
                  do  ich=1,n_group
                     call get_asm_group_id(asmgrp,ich)
                     if(chain_in(i).eq.asmgrp) then
                        ir_first = ires_first(ich)
                        ir_last  = ir_first + nres_chain(ich)-1
                        do ires=ir_first,ir_last
                           read(res_num_pdb(ires)(3:6),*)jrs
                           ins_code = res_num_pdb(ires)(7:7)
                           if(ires_in(i).eq.jrs.and.
     &                          ins_in(i).eq.ins_code) then
                              ia_first = iratm_first(ires)
                              ia_last  = ia_first+natm_res(ires)-1
                              do  ia=ia_first,ia_last
                                 if(atom_in(i).eq.atm_name(ia).and.
     &                                alt_in(i).eq.id_alt(ia)) then
                                    iatom_number(i) = ia
                                    goto 200
                                 endif
                              enddo
                           endif
                        enddo
                     endif
                  enddo
                  ierr = 3
c
c--   write something that it is not in the list
c                  goto 999
 200              continue
               enddo
               if(ierr.eq.3) then
                  write(*,*)'Error: At least one of the atoms from '//
     &                 'the restraints could not be found:'
                  write(*,*)'==> ',trim(line)
               else
c
c---  Find out if these atoms are related (if symm defined by symmetry or) 
c---  directly. It works only for bond restraints For others bookkeeping 
c---  for symmetry related atoms is too complicated
                  isym_out(1,1:nrest_now)   = 1
                  isym_out(2:4,1:nrest_now) = 0
c               if(symm_in.eq.'Y') then
c     
c--   Are we here?
                  do i=2,nrest_now
                     if(symm_in1(i).eq.'Y') then
                        call find_symm_contact(iatom_number(1),
     &                       iatom_number(i),isym_out(1:4,i))
                     endif
                  enddo
                  if(nrest_now.eq.2.and.symm_in1(2).eq.'N'.and.
     &                 symm_in.eq.'Y') then
                     call find_symm_contact(iatom_number(1),
     &                    iatom_number(2),isym_out(1:4,2))
                  endif
c
c---  Add this info into the file
                  if(rest_type.eq.'DIST') then
                     write(ibond)iatom_number(1:2),dist_value,
     &                    sigma_value,isym_out(1:4,2),2
                     nbonds = nbonds + 1
                  else if(rest_type.eq.'CHIR') then
                     if(nrest_now.eq.4) then
                        ichir_sign1 = 0
                        if(dist_value.gt.0.0) then
                           ichir_sign1 = 1
                        else if(dist_value.lt.0.0) then
                           dist_value = -dist_value
                           ichir_sign1 = -1
                        endif
                        write(ichir)iatom_number(1:4),
     &                       (isym_out(1:4,i),i=1,4),
     &                       dist_value,sigma_value,ichir_sign1
                        nchir = nchir + 1
                     endif
                  else if(rest_type.eq.'PLAN') then
                     if(nrest_now.gt.3) then
                        write(iplan)nrest_now,dist_value,sigma_value,
     &                       iatom_number(1:nrest_now),
     &                       (isym_out(1:4,i),i=1,nrest_now)
                        nplans = nplans + 1
                     endif
                  else if(rest_type.eq.'HARM') then

                  else if(rest_type.eq.'TORS') then
                     if(nrest_now.eq.4.and.dist_defined) then
                        tors_l1 = 'user'
                        it_period = 1
                        itor_fl   = 1
                        write(itors)tors_l1,iatom_number(1:4),
     &                       (isym_out(1:4,i),i=1,4),
     &                       it_period,
     &                       dist_value,sigma_value,itor_fl
                        ntors = ntors + 1
                     endif
                  else if(rest_type.eq.'ANGL') then
                     if(nrest_now.eq.3) then
                        write(iangle,iostat=iend_b) iatom_number(1:3),
     &                       (isym_out(1:4,i),i=1,3),dist_value,
     &                       sigma_value
                        nangles = nangles + 1
                     endif
                  else if(rest_type.eq.'INTE') then
                     if(nrest_now.eq.2.and.dmin_defined.and.
     &                    dmax_defined) then
                        nint = nint + 1
                        write(iint)iatom_number(1:2),isym_out(1:4,2),
     &                       dmin,dmax,sigma_value
                     endif
                  endif
               endif
            endif
         enddo
 888     continue
      enddo
 999  continue
      if(psuedorest_file(1:1).ne.' ') close(ipsuedo)
      close(iscrk)
c
c---  Read and write bonds
      allocate(ia1_b(2,nbonds))
      allocate(rs_vidl_b(2,nbonds))
      allocate(is_bond(4,nbonds))
      allocate(ibond_type(nbonds))
      rewind(ibond)
      read(ibond)nb1
      write(*,*)'Bonds before and after',nb1,nbonds
      do ib=1,nbonds
         read(ibond)ia1_b(1:2,ib),rs_vidl_b(1:2,ib),is_bond(1:4,ib),
     &        ibond_type(ib)
      enddo
      rewind(ibond)
      write(ibond)nbonds
      do ib=1,nbonds
         write(ibond)ia1_b(1:2,ib),rs_vidl_b(1:2,ib),is_bond(1:4,ib),
     &        ibond_type(ib)
      enddo

      deallocate(ia1_b)
      deallocate(is_bond)
      deallocate(ibond_type)
      deallocate(rs_vidl_b)
      close(ibond)
c
c---angles
      if(nangles.gt.0) then
         allocate(ia1_a(4,nangles))
         allocate(rs_vidl_a(2,nangles))
         allocate(is_a(4,3,nangles))
         rewind(iangle)
         read(iangle)nan1
         write(*,*)'Angles before and after',nan1,nangles

         do ic=1,nangles
            read(iangle)ia1_a(1:3,ic),(is_a(1:4,i,ic),i=1,3),
     &           rs_vidl_a(1:2,ic)
         enddo
         rewind(iangle)
         write(iangle)nangles
         do ic=1,nangles
            write(iangle)ia1_a(1:3,ic),(is_a(1:4,i,ic),i=1,3),
     &           rs_vidl_a(1:2,ic)
         enddo
         deallocate(ia1_a)
         deallocate(rs_vidl_a)
         deallocate(is_a)
      endif
      close(iangle)
c      stop
c
c---  Chirals
      if(nchir.gt.0) then
         allocate(ia1_c(4,nchir))
         allocate(rs_vidl_c(2,nchir))
         allocate(ichir_sign(nchir))
         allocate(is_c(4,4,nchir))
         rewind(ichir)
         read(ichir)nch1
         write(*,*)'Chirals before and after',nch1,nchir

         do ic=1,nchir
            read(ichir)ia1_c(1:4,ic),(is_c(1:4,i,ic),i=1,4),
     &           rs_vidl_c(1:2,ic),ichir_sign(ic)
         enddo
         rewind(ichir)
         write(ichir)nchir
         do ic=1,nchir
            write(ichir)ia1_c(1:4,ic),(is_c(1:4,i,ic),i=1,4),
     &           rs_vidl_c(1:2,ic),ichir_sign(ic)
         enddo
         deallocate(ia1_c)
         deallocate(rs_vidl_c)
         deallocate(ichir_sign)
         deallocate(is_c)
      endif
      close(ichir)
c
c---  Planes
      if(nplans.gt.0) then
         allocate(ia1_p(100,nplans))
         allocate(rs_vidl_p(2,nplans))
         allocate(nplane(nplans))
         allocate(is_p(4,100,nplans))
         
         rewind(iplan)
         read(iplan)np1,nmaxatom_in_plane
         write(*,*)'planes before and after',np1,nplans

         do ip=1,nplans
            read(iplan)nplane(ip),rs_vidl_p(1:2,ip),
     &           ia1_p(1:nplane(ip),ip),(is_p(1:4,i,ip),i=1,nplane(ip))
            nmaxatom_in_plane = max(nmaxatom_in_plane,nplane(ip))
         enddo
         rewind(iplan)
         write(iplan)nplans,nmaxatom_in_plane
         do ip=1,nplans
            write(iplan)nplane(ip),rs_vidl_p(1:2,ip),
     &           ia1_p(1:nplane(ip),ip),(is_p(1:4,i,ip),i=1,nplane(ip))
         enddo
         deallocate(ia1_p)
         deallocate(rs_vidl_p)
         deallocate(nplane)
         deallocate(is_p)
      endif
      close(iplan)
c
c---  torsion
      if(ntors.gt.0) then
         allocate(tors_labels(ntors))
         allocate(ia1_tors(4,ntors))
         allocate(is_tors(4,4,ntors))
         allocate(tors_flag(ntors))
         allocate(tors_period(ntors))
         allocate(rs_vidl_tors(2,ntors))
         rewind(itors)
         read(itors,iostat=iend_b)nt1
         write(*,*)'Torsions before and after',nt1,ntors

         do it=1,ntors
            read(itors)tors_labels(it),ia1_tors(1:4,it),
     &           (is_tors(1:4,i,it),i=1,4),
     &           tors_period(it),
     &           rs_vidl_tors(1:2,it),tors_flag(it)
         enddo
         rewind(itors)
         write(itors)ntors
         do it=1,ntors
            write(itors)tors_labels(it),ia1_tors(1:4,it),
     &           (is_tors(1:4,i,it),i=1,4),
     &           tors_period(it),
     &           rs_vidl_tors(1:2,it),tors_flag(it)
         enddo
         deallocate(tors_labels)
         deallocate(ia1_tors)
         deallocate(is_tors)
         deallocate(tors_flag)
         deallocate(tors_period)
         deallocate(rs_vidl_tors)
      endif
      close(itors)
c
c---  hamronics???

c
c---  Intervals
      if(nint.gt.0) then
         allocate(ia1_int(2,nint))
         allocate(is_int(4,nint))
         allocate(rs_vidl_int(3,nint))
         rewind(iint)
         read(iint)nt1
         write(*,*)'Intervals before and after',nint1,nint

         do it=1,nint
            read(iint)ia1_int(2,nint),is_int(4,nint),rs_vidl_int(3,nint)
         enddo
         write(iint)nint
         do it=1,nint
            write(iint)ia1_int(2,nint),is_int(4,nint),
     &           rs_vidl_int(3,nint)
         enddo
         deallocate(ia1_int)
         deallocate(is_int)
         deallocate(rs_vidl_int)
      endif
      close(iint)
c
c--   It needs to be read and sorted to remove duplicated restraints

c---  Read and remove redundant pairs.

      if(ierr.eq.0) return
c
c---Read, sort and remove duplicated bonds
c         call remove_duplicate_dists(bond_file)
c         return
c      endif
c
c---  Process errors
      if(ierr.eq.1) write(*,*)'Incomplete instruction for restrtaint'
      if(ierr.eq.2) write(*,*)'Wrong data type for distance/sigma'
      if(ierr.eq.3) write(*,*)'Specified atoms(s) could not be found'
      if(ierr.eq.4) write(*,*)'Wrong instruction'
      if(ierr.eq.5) write(*,*)'Problem in reading atom record'
      if(ierr.eq.6) write(*,*)'Too many atoms per restraint'
      write(*,*)'Example of instructions:'
      write(*,*)'extr dist first residue <number> chain <name> atom'
     &//' <name> second residue <number> chain <name> atom <name>'
     &//' value <number> sigma <number>'
      write(*,*)'If alternative or insertion code are aslo present then'
     &//' they can be added using subkeywords alte or inse'
      call errwrt(1,'Cannot continue. Quitting now')
      return
      end
c
      subroutine find_symm_contact(ia1,ia2,isym_out)
      implicit none
      include 'atom_com.fh'
c
c---inputs
      integer ia1,ia2
c
c---outputs
      integer isym_out(4)
c
c---locals
      integer is,itx(3)
      real d_p,d_l
      real xyz_1(3),xyz_2(3),xyz_frac2(3),xyz_frac1(3),xyz_sym(3)
      real xyz_d(3),axyz(3),axyz_o(3)
      logical error
c
c---body
      xyz_1(1:3) = xyz_crd(1:3,ia1)
      xyz_2(1:3) = xyz_crd(1:3,ia2)
      call mat2vec(3,3,cs_ort_to_frac,xyz_2,xyz_frac2,error)
      call mat2vec(3,3,cs_ort_to_frac,xyz_1,xyz_frac1,error)
      d_p = 1.0e32
      isym_out(1) = 1
      isym_out(2:4) = 0
      do  is=1,cs_nsym
         call mat2vec(3,3,cs_m_cs(1,1,is),xyz_frac2,xyz_sym,error)
         xyz_sym(1:3) = xyz_sym(1:3) + cs_v_cs(1:3,is)
         call find_closest_xyz(xyz_frac1,xyz_sym,itx)
         axyz(1:3) = xyz_frac1(1:3) - (xyz_sym+itx(1:3))

c         xyz_d(1:3) = xyz_frac1(1:3) - xyz_sym(1:3)
c         call amod_r(xyz_d(1),1.0,itx(1),axyz(1))
c         axyz(1) = axyz(1)
c         call amod_r(xyz_d(2),1.0,itx(2),axyz(2))
c         axyz(2) = axyz(2)
c         call amod_r(xyz_d(3),1.0,itx(3),axyz(3))
c         axyz(3) = axyz(3)

         call mat2vec(3,3,cs_frac_to_ort,axyz,axyz_o,error)
         d_l = axyz_o(1)**2+axyz_o(2)**2+axyz_o(3)**2
         if(d_p.gt.d_l) then
            isym_out(1) = is
            isym_out(2:4) = itx(1:3)
            d_p = d_l
         endif
      enddo
      return
      end
c
      subroutine find_closest_xyz(xyz1,xyz2,itx)
      implicit none
c
c--Find itx(1:3) that would bring close xyz2 to xyz1
      real xyz1(3),xyz2(3)
      integer itx(3)
c
c---locals
      integer i
      real    t,t1
      real    xyz_l(3)
c
c---body
      itx(1:3) = 0
      xyz_l(1:3) = xyz2(1:3)

      do i=1,3
         do while (xyz_l(i).ge.xyz1(i))
            itx(i) = itx(i) - 1
            xyz_l(i) = xyz_l(i)-1.0
         enddo
         do while(xyz_l(i).le.xyz1(i))
            itx(i) = itx(i) + 1
            xyz_l(i) = xyz_l(i) + 1
         enddo
      
c
c--Now test two options xyz_l(i) + 1 and xyz_l(i)

         t  = abs(xyz_l(i) - xyz1(i))
         t1 = abs(xyz_l(i) - 1.0 - xyz1(i))
         if(t1.lt.t) itx(i) = itx(i) - 1
      enddo

      return
      end
c
      subroutine remove_duplicate_dists(bond_file)
c
c---  Read distance restraints and remove duplicates
c---  It may happen when automatic as well as external restraints are defined
      character bond_file*(*)
c
c---  locals
      include 'atom_com.fh'
      integer  ipos,it1,ifirst
      integer  ibond,ll,ifail
      integer  ibold(6)
      integer  nbonds
      integer, allocatable :: idist_atoms(:,:)
      integer, allocatable :: bond_type(:)
      integer, allocatable :: index_atoms(:)
      real,    allocatable :: bond_idl(:,:)
c
      integer iiden0,isym1(4),isym_out,itx_out(3),itx_in(3)
c
c---  body
      if(len_trim(bond_file).le.0) return
      call open_unform_file(ibond,bond_file,ifail)
c
c--read till the end
      nbonds = 0
      do while(.TRUE.)
         read(ibond,end=5) ia1,ia2,rs_vidl,rs_sigma,i1,i2,i3,i4,ibtype
         nbonds = nbonds + 1
      enddo
 5    continue
      rewind ibond
      allocate(idist_atoms(6,nbonds))
      allocate(bond_idl(2,nbonds))
      allocate(bond_type(nbonds))
      allocate(index_atoms(nbonds))
      do ib=1,nbonds
         index_atoms(ib) = ib
      enddo
      iiden0      = 1
      ifirst      = 0
      do  ib=1,nbonds
         read(ibond,end=10)idist_atoms(1:2,ib),bond_idl(1:2,ib),
     &        idist_atoms(3:6,ib),bond_type(ib)
c
c---  Make sure that the index of first atom is smaller than that of the second
         if(idist_atoms(1,ib).gt.idist_atoms(2,ib)) then
            it1 = idist_atoms(2,ib)
            idist_atoms(2,ib) = idist_atoms(1,ib)
            idist_atoms(1,ib) = it1
            ibold(1:6) = idist_atoms(1:6,ib)
            itx_in(1:3) = -ibold(4:6)
            call sym_find_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,ibold(3),
     &           iiden0,itx_in,isym_out,itx_out,ifirst)
            ibold(3) = isym_out
            ibold(4:6) = itx_out(1:3)
            idist_atoms(1:6,ib) = ibold(1:6)
         endif
      enddo
 10   continue
      call iheap_sort_r(nbonds,6,idist_atoms,index_atoms)
c
c---  remove redundant bonds. Leave the last one
      rewind ibond
      ibold(1:6) = idist_atoms(1:6,1)
      ipos = index_atoms(1)
      do  ib=2,nbonds
         if(maxval(abs(ibold(1:6)-idist_atoms(1:6,ib))).ne.0) then
            write(ibond)ibold(1:2),bond_idl(1:2,ipos),ibold(3:6),
     &           bond_type(ipos)
            ipos = index_atoms(ib)
            ibold(1:6) = idist_atoms(1:6,ib)
         else
            ipos = index_atoms(ib)
         endif
      enddo
      write(ibond)ibold(1:2),bond_idl(1:2,ipos),ibold(3:6),
     &           bond_type(ipos)
      close(ibond)
      deallocate(idist_atoms)
      deallocate(bond_idl)
      deallocate(bond_type)
      deallocate(index_atoms)
c
      return
      end
c

      subroutine read_external_atom_info(ntok,nkeywords,
     &                    itk_in,itk_out,
     &                    ibeg,iend,ires1,ierr,cvalue,line,
     &                    chain1,ins1,atom1,alt1,symm1,
     &                    EndKeywords)

      implicit none
c
      integer   nkeywords,ntok,itk_in,itk_out
      integer   ierr
      integer   ibeg(*),iend(*)
      integer   ires1
      character cvalue(*)*4
      character line*(*)
      character chain1*(*)
      character atom1*(*)
      character ins1*(*)
      character alt1*(*)
      character symm1*(*)
      character EndKeywords(*)*4
c
c--locals
      integer i
      integer itk
c
c---  body
      i=0
      ierr = 0
      itk    = itk_in
      atom1  = '.'
      chain1 = '.'
      alt1   = '.'
      ins1   = ' '
      ires1 = -320000
      symm1 = 'N'
      do while(itk.le.ntok-1)
         do i=1,nkeywords
            if(cvalue(itk).eq.EndKeywords(i)) goto 100
         enddo
         if(cvalue(itk).eq.'CHAI') then
            itk = itk + 1
            chain1 = line(ibeg(itk):iend(itk))
         else if(cvalue(itk).eq.'RESI') then
            itk = itk + 1
            read(line(ibeg(itk):iend(itk)),*)ires1
c     ires_in(2) = nint(fvalue(itk))
         else if(cvalue(itk).eq.'INSE') then
            itk = itk + 1
            ins1 = line(ibeg(itk):iend(itk))
         else if(cvalue(itk).eq.'ATOM') then
            itk = itk + 1
            atom1 = line(ibeg(itk):iend(itk))
         else if(cvalue(itk).eq.'ALTE') then
            itk = itk + 1
            alt1 = line(ibeg(itk):iend(itk))
         else if(cvalue(itk).eq.'SYMM') then
            itk = itk + 1
            if(cvalue(itk)(1:1).eq.'Y') symm1 = 'Y'
         else
            write(*,*)'Wrong keyword or value in atrecord'
         endif
         itk = itk + 1
      enddo
c
 100  continue
      itk_out = itk
c
      if(ires1.ne.-320000.and.atom1.ne.'.'.and.chain1.ne.'.') then
c
c---  success
         ierr = 0

      else
c---- failure
         write(*,*)'Problem in readin atom info'
         write(*,*)'Either chain or atom or residue number '// 
     &        'has not beend defined'
         ierr = 1
      endif
      return
      end
c
      subroutine read_harm_et_al
      implicit none
      include 'atom_com.fh'
      include 'restr_files.fh'
c
c---locals
      integer lps,iscrk,ipsuedo,file_in
      integer ifile,nfile
      character psuedorest_file*512

      integer iharm,ierr,iend_b
      integer nharms

      integer, allocatable :: ia1_h(:)
      real,    allocatable :: sigma_h(:)
      integer, allocatable :: rest_type(:)
c
      integer ia1_t
      real    sigma_t
c
c---  Things for parser
      integer maxtok,ntok,itk,itk_in,itk_out
      parameter (maxtok = 500)
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*600,key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer iend_r,lend_f
      character rectype*4

      integer nkeywords
      character EndKeywords(200)*4
c
      integer i,irest_type
      integer ich,ir,ia,jrs
      integer ifirst,ilast
      integer ir_first,ir_last,ia_first,ia_last
      integer ires1
      character ins_code*1
      character asmgrp*4
      character chain1*4,ins1*1,alt1*1,atom1*4,symm_in*1,symm1*1
c
c---  body
      call ugtenv('PSRESTIN',psuedorest_file)
      lps = len_trim(psuedorest_file)
      if(lps.gt.0) then
         call open_form_file(ipsuedo,psuedorest_file,ierr)
         if(ierr.ne.0) then
            write(*,*)'Problem with psuedo restraint file'
         endif
      endif

      call open_form_file(iscrk,keywords_file,ierr)
      if(ierr.ne.0) then
         write(*,*)'Problem with keywords file'
         call errwrt(1,'Can not continue')
      endif
c
      if(harmonic_file(1:1).eq.' ') then
         call find_unique_file_name(harmonic_file,'_HARM_R')
      endif
      call open_unform_file(iharm,harmonic_file,ierr)
      if(ierr.gt.0) then
         call errwrt(1,'In read_psuedorest. Opening interval file')
      endif
      nharms = 0
      read(iharm,iostat=iend_b) nharms
      if(iend_b.eq.0) then
         do  while(iend_b.eq.0)
            read(iharm,iostat=iend_b)ia1_t,sigma_t,irest_type
         enddo
      else
         nharms = 0
      endif
c
      lend = .TRUE.
c
c---  If psuedo restraint file is present then use this file first
c---  Instructions from the keywords file have higher priority
      nfile = 1
      if(lps.le.0) nfile = 2
      nkeywords = 1
      EndKeywords(1) = 'SIGM'
      do ifile=nfile,2
         if(ifile.eq.1) then
            file_in = ipsuedo
         else
            file_in = iscrk
         endif
         lend_f = 0
         key    = ' '
c
        do while(lend_f.eq.0.and.key(1:3).ne.'END'.and.ierr.eq.0)
            lprint = .FALSE.
            line = ' '
            key = ' '
            symm_in ='N'
            do while(line.eq.' '.and.lend_f.eq.0)
               read(file_in,'(a)',iostat=lend_f)line
            enddo
            if(lend_f.lt.0) goto 888
            
            ntok = maxtok
            call parser(key,line,ibeg,iend,itype,fvalue,cvalue,idec,
     &           ntok,lend,lprint)
            call ccpupc(key)
            do  itk=2,ntok
               call ccpupc(cvalue(itk))
            enddo
            itk = 1
            if(key.eq.'EXTE') then
               sigma_t = 0.01
               itk = itk + 1
               if(itk.ge.NTOK) then
                  ierr = 2
                  goto 900
               endif
               if(cvalue(itk).eq.'HARM'.or.cvalue(itk).eq.'SPEC') then
                  if(cvalue(itk).eq.'HARM') then
                     irest_type = 1
                  else
                     irest_type = 2
                  endif
                  itk = itk + 1
                  do while(itk.le.ntok)
                     if(cvalue(itk).eq.'ATIN') then
                        itk = itk + 1
                        if(itk.ge.NTOK) then
                           ierr = 2
                           goto 900
                        endif
                        rectype = 'ATOM'
                        call read_external_atom_info(ntok,nkeywords,
     &                       itk,itk_out,
     &                       ibeg,iend,ires1,ierr,cvalue,line,
     &                       chain1,ins1,atom1,alt1,symm1,
     &                       EndKeywords)
                        itk = itk_out
                     else if (cvalue(itk).eq.'RESI') then
                        itk = itk + 1
                        rectype = 'RESI'
                        call read_fromto1(NTOK,ITK,CVALUE,line,ibeg,
     &                       iend,
     &                       itype,fvalue,ifirst,ilast,chain1,ierr)
                     else if(cvalue(itk).eq.'SIGM') then
                        itk = itk + 1
                        sigma_t = 0.01
                        if(itk.le.ntok) then
                           if(itype(itk).eq.2) then
                              read(line(ibeg(itk):iend(itk)),*)sigma_t
                              itk = itk + 1
                           endif
                        endif
                     else
                        itk = itk + 1
                     endif
                  enddo
               endif
               if(rectype.eq.'ATOM') then
                  do  ich=1,n_group
                     call get_asm_group_id(asmgrp,ich)
                     if(chain1.eq.asmgrp) then
                        ir_first = ires_first(ich)
                        ir_last  = ir_first + nres_chain(ich)-1
                        do ir=ir_first,ir_last
                           read(res_num_pdb(ir)(3:6),*)jrs
                           ins_code = res_num_pdb(ir)(7:7)
                           if(ires1.eq.jrs.and.
     &                          ins1.eq.ins_code) then
                              ia_first = iratm_first(ir)
                              ia_last  = ia_first+natm_res(ir)-1
                              do  ia=ia_first,ia_last
                                 if(atom1.eq.atm_name(ia).and.
     &                                alt1.eq.id_alt(ia)) then
                                    write(iharm)ia,sigma_t,irest_type
                                    nharms = nharms + 1
                                    goto 200
                                 endif
                              enddo
                           endif
                        enddo
                     endif
                  enddo
               else if(rectype.eq.'RESI') then
                  do  ich=1,n_group
                     call get_asm_group_id(asmgrp,ich)
                     if(chain1.eq.asmgrp) then
                        ir_first = ires_first(ich)
                        ir_last  = ir_first + nres_chain(ich)-1
                        do ir=ir_first,ir_last
                           read(res_num_pdb(ir)(3:6),*)jrs
                           if(jrs.ge.ifirst.and.jrs.le.ilast) then
                              ia_first = iratm_first(ir)
                              ia_last  = ia_first+natm_res(ir)-1
                              do ia=ia_first,ia_last
                                 write(iharm)ia,sigma_t,irest_type
                                 nharms = nharms + 1
                              enddo
                           endif
                        enddo
                        goto 200
                     endif
                  enddo
               endif
 200           continue
            endif
         enddo
 888     continue
      enddo
c
 900  continue
      if(nharms.gt.0) then
         allocate(ia1_h(nharms))
         allocate(sigma_h(nharms))
         allocate(rest_type(nharms))
         rewind(iharm)
         do i=1,nharms
            read(iharm)ia1_h(i),sigma_h(i),rest_type(i)
         enddo
         rewind(iharm)
         write(iharm)nharms
         do i=1,nharms
            write(iharm)ia1_h(i),sigma_h(i),rest_type(i)
         enddo
         deallocate(ia1_h)
         deallocate(sigma_h)
         deallocate(rest_type)
         close(iharm)
      else
         close(iharm,status='DELETE')
         harmonic_file = ' '
      endif
      if(ierr.gt.0) then
         write(*,*)'Wrong instructions for External harmonic restraints'
         write(*,*)'Example of correct instruction:'

      endif
      if(lps.gt.0.and.ipsuedo.gt.0) close(ipsuedo)
      close(iscrk)
      return
      end
c
      subroutine read_vdw_ion_external
      implicit none
      include 'atom_com.fh'
      include 'atom_com_str.fh'
      include 'restr_files.fh'
c
c---  Read instructions for vdw and ion radii of specified atoms
c
c---  locals
      integer lps,ipsuedo,iscrk,ierr
      integer file_in,nfile,ifile
      character psuedorest_file*512
c
c---  Things for parser
      integer maxtok,ntok,itk,itk_in,itk_out
      parameter (maxtok = 500)
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*600,key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer iend_r,lend_f
c
c---  Interpretation
      integer nkeywords,iatom_number
      character EndKeywords(100)*4
      logical vdw_defined,ion_defined
      integer ires_in
      character ins_in*1,atom_in*4,alt_in*1,chain_in*4,symm_in*1
      real      vdw_loc,ion_loc
c
c---  body
      ierr = 0
c
c---  Instruction may come from two sources. 1) External psuedorestraint file
c---  and 2) usual keyword file. Usual keyword would be sufficient. 
c---  Unfortunately psuedorestraint file has already been declared and out on 
c---  the web
      call ugtenv('PSRESTIN',psuedorest_file)
      lps = len_trim(psuedorest_file)
      if(lps.gt.0) then
         call open_form_file(ipsuedo,psuedorest_file,ierr)
         if(ierr.ne.0) then
            write(*,*)'Problem with psuedo restraint file'
         endif
      endif

      call open_form_file(iscrk,keywords_file,ierr)
      if(ierr.ne.0) then
         write(*,*)'Problem with keywords file'
         call errwrt(1,'Can not continue')
      endif
c
c---  If psuedo restraint file is present then use this file first
c---  Instructions from the keywords file have higher priority
      nfile = 1
      if(lps.le.0) nfile = 2
      nkeywords = 1
      EndKeywords(1) = 'SIGM'
      do ifile=nfile,2
         if(ifile.eq.1) then
            file_in = ipsuedo
         else
            file_in = iscrk
         endif
         lend_f = 0
         key    = ' '
c
         do while(lend_f.eq.0.and.key(1:3).ne.'END'.and.ierr.eq.0)
            lprint = .FALSE.
            line = ' '
            key = ' '
            symm_in ='N'
            do while(line.eq.' '.and.lend_f.eq.0)
               read(file_in,'(a)',iostat=lend_f)line
            enddo
            if(lend_f.lt.0) goto 888
            ntok = maxtok
            call parser(key,line,ibeg,iend,itype,fvalue,cvalue,idec,
     &           ntok,lend,lprint)
            call ccpupc(key)
            do  itk=2,ntok
               call ccpupc(cvalue(itk))
            enddo
            nkeywords = 2
            EndKeywords(1) = 'VDWR'
            ENDKeywords(2) = 'IONR'
            if(key.eq.'EXTE') then
               itk = 2
               if(cvalue(itk).eq.'NONB') then
                  vdw_defined = .FALSE.
                  ion_defined = .FALSE.
                  vdw_loc     = -1.0
                  ion_loc     = -1.0
                  itk = itk +1
                  do while(itk.le.ntok)
                     if(  cvalue(itk).eq.'ATRE'.or.
     &                    cvalue(itk).eq.'ATIN') then
                        itk = itk + 1
                        call read_external_atom_info(ntok,nkeywords,
     &                       itk,itk_out,
     &                       ibeg,iend,ires_in,ierr,cvalue,line,
     &                       chain_in,ins_in,atom_in,alt_in,symm_in,
     &                       EndKeywords)
                        itk = itk_out
                     elseif(cvalue(itk).eq.'VDWR') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)vdw_loc
                        vdw_defined = .TRUE.
                        itk = itk + 1
                     elseif(cvalue(itk).eq.'IONR') then
                        itk = itk + 1
                        if(itk.gt.NTOK) then
                           ierr = 1
                           goto 999
                        endif
                        if(itype(itk).ne.2) then
                           ierr = 2
                           goto 999
                        endif
                        read(line(ibeg(itk):iend(itk)),*)vdw_loc
                        ion_defined = .TRUE.
                        itk = itk + 1
                     endif
                  enddo
c
c--   Find the atom and change vdw and ionic radii
                  if(vdw_defined.or.ion_defined) then
                     call find_atom_number(chain_in,ins_in,ires_in,
     &                    atom_in,alt_in,iatom_number,ierr)
                     if(ierr.gt.0.or.iatom_number.le.0) then
                        write(*,*)'ERROR ==> Input atom could not be'
     &                       //' found in the list of atoms'
                        write(*,*)trim(line)
                     else
                        if(vdw_defined) then
                           vdw_rad(iatom_number) = vdw_loc
                        endif
                        if(ion_defined) then
                           ion_rad(iatom_number) = ion_loc
                        endif
                     endif
                  endif
               endif
            endif
         enddo
 888     continue
      enddo
c
 999  continue
      if(lps.gt.0.and.ipsuedo.gt.0) close(ipsuedo)
      close(iscrk)
c
      if(ierr.eq.0) return

      return
      end
c
      subroutine find_atom_number(chain_in,ins_in,ires_in,
     &     atom_in,alt_in,iatom_number,ierr)
      implicit none
      include 'atom_com.fh'
c
      integer iatom_number
      integer ires_in,ierr
      character chain_in*4,atom_in*4,ins_in*1,alt_in*1
c
c---  locals
      integer jrs,ich,ir_first,ir_last,ires,ia,ia_first,ia_last
      character ins_code*1,asmgrp*4
c
c---  body
      ierr = 0
      iatom_number = -9999
      do  ich=1,n_group
         call get_asm_group_id(asmgrp,ich)
         if(chain_in.eq.asmgrp) then
            ir_first = ires_first(ich)
            ir_last  = ir_first + nres_chain(ich)-1
            do ires=ir_first,ir_last
               read(res_num_pdb(ires)(3:6),*)jrs
               ins_code = res_num_pdb(ires)(7:7)
               if(ires_in.eq.jrs.and.
     &              ins_in.eq.ins_code) then
                  ia_first = iratm_first(ires)
                  ia_last  = ia_first+natm_res(ires)-1
                  do  ia=ia_first,ia_last
                     if(atom_in.eq.atm_name(ia).and.
     &                    alt_in.eq.id_alt(ia)) then
                        iatom_number = ia
                        goto 200
                     endif
                  enddo
               endif
            enddo
         endif
      enddo
      ierr = 1
c
c--   write something that it is not in the list
 200  continue
      return
      end
