C
C     REFMAC refinement program
C     Copyright (C) 2000-2007 Garib Murshudov
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Darsesbury Laboratory, Warrington WA4 4AD, UK.
C
cd      PROGRAM refmac
C------------------------------------------------------------------------
C----Remarks on program organization
C     Program for refinement macromolecular structures. Current 
C     ersion of program works as Hendickson-Konnert restrained refinement
c     with or without restraints and with FFT
C
C     Rigid body refinement
c    
c----CCPFYP
c----MTZINI        subroutines makes possible to work with CCP4
c
c
c----DEFLTS        defines default values of parameters
c
c----RCARD         reads necessary parametrs for refinement
c
c----HKREF         refines macromolecular structures using output from
c----              PROTIN. This subroutine works as HK + Agarwal program
c
C------------------------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'cif_incl.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'expcost.fh'
      INCLUDE 'const.fh'
      INCLUDE 'makecif_version.fh'
C
      integer ierr
c
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
C
C----Initialize ccp4 like file organization
      CALL CCP4_PROG_VERSION(R_VERSNO,0)
      CALL CCPFYP
      CALL MTZINI
      CALL DEFLTS
c-----------------------------------------------------
c
c----Open system input and output
c
c----------------------------------------------------
      CALL CCPRCS(ISYSW,'Refmac_'//R_VERSNO,
     & '$Date: '//R_VERSDATE//' $')
      write (isysw,11)
 11   format (
     +     ' $TEXT:Reference1: $$ comment $$ '/2x,
     +     ' "Refinement of Macromolecular Structures by the ',
     +     ' Maximum-Likelihood Method:"'/2x,
     +     ' G.N. Murshudov, A.A.Vagin and E.J.Dodson,(1997)'/2x,
     +     ' Acta Crystallogr. D53, 240-255'/2x,
     +     ' EU  Validation contract: BIO2CT-92-0524',//,' $$',/,
     +     ' $SUMMARY :Reference1:  $$ Refmac: $$'/
     +     ' :TEXT:Reference1: $$'/)
C
c----Initialise for harvesting and read cards and instructions
      CALL rharvest(0)
      CALL RCARD
c---------------------------------------------------
c----Read coordinate and reflection files if necessary
c---------------------------------------------------
      IF(MODE.EQ.'RIGI') REFID = 'UNRE'
      IF(CRDUSE) CALL OPPRO
      IF(REFUSE) CALL REFPRE
C---------------------------------------------------
C---General preperation. 
C---Calc orth. deorth matrices and so on
C--------------------------------------------------
      CALL GENPRE
C
C---If all atoms should be anisotropic then convert those which are not 
C---anisotropic yet
c      call write_dist_exit

      NANISO_ATOMS = 0
      DO   IA=1,N_ATOM
         IF(U_ANISO(2,IA).NE.0.0) NANISO_ATOMS = NANISO_ATOMS + 1
      ENDDO
      if(itemp.eq.1.or.itemp.eq.0) call allanisous2b
      IF(ITEMP.EQ.2) CALL ALLBS2ANISOU
      CALL CHECK_U_VALUES
c
C---Begin actions
      IFLAGB = 0
      IFLAGE = 1
      CALL CCPTIM(IFLAGE,CPU,ELAPS)
      CALL CCPTIM(IFLAGB,CPU,ELAPS)
 6018 FORMAT ('  Time in seconds: CPU = ',F12.2,/,
     +        '             Elapsed =   ',F12.2)
C
      IF(MODE.EQ.'HKRF') THEN
        CALL refine_individual
      ELSEIF(MODE.EQ.'CELR') THEN
cd        CALL CELLREF(NAME)
      ELSEIF(MODE.EQ.'RIGI') THEN
        CALL RIGID_BODY
      ELSEIF(MODE.EQ.'TLSR') THEN
        CALL TLS_REFINE
      ELSEIF(MODE.EQ.'NEWE') THEN
        CALL NEWENTRY_IDEALISE
      elseif(mode.eq.'OCCU'.OR.REFID.EQ.'OCCU') then
         call occup_only_refine
cd      ELSEIF(MODE.EQ.'INTE') THEN
cd        CALL INTERNAL_REFINE
c
c     ELSEIF(MODE.EQ.'CONS') THEN
C        CALL  CONSTR
C     ELSEIF(MODE.EQ.'FULL') THEN
C        CALL FULLM
C     ELSEIF(MODE.EQ.'OMT1') THEN
C        CALL OMIT1
C     ELSEIF(MODE.EQ.'OMT2') THEN
C        CALL OMIT2
C     ELSEIF(MODE.EQ.'BLCK') THEN
C        CALL BLOCKR
C     ELSEIF(MODE.EQ.'SFCL') THEN
C        CALL SFCALC
C     ELSEIF(MODE.EQ.'MAPC') THEN
C        CALL MAPCALC
C     ELSEIF(MODE.EQ.'AUTO') THEN
C        CALL AUTOREF
      ELSE
        CALL ERRWRT(1,' Other modes are not active')
      ENDIF
C
C---Another action?
C     IF(ICONTINUE.EQ.1) GOTO 1
C                ************************
      CALL WRITE_ATOMS_REFMAC
c
c---Add occupancy only refinement if it is for tests

      if(refmac_tests.eq.'DBAS') then
         mode = 'OCCU'
         refid = 'UNRE'
         call occup_only_refine
      endif
c

C
C---Write harvesting data
      CALL WRITE_VS_CYCLE
      CALL rharvest(1)
      ierr = 0
      call write_xml(ierr,'normal termination')

      CALL REFMAC_CLEAN_UP_FILES
      IFLAGB = 0
      IFLAGE = 1
      CALL CCPTIM(IFLAGE,CPU,ELAPS)
      WRITE (ISYSW,FMT=6018) CPU,ELAPS
      CALL CCPTIM(IFLAGB,CPU,ELAPS)
      call flush(6)
      CALL CCPERR(0,'End of Refmac_'//R_VERSNO)
      END

      SUBROUTINE REFMAC_CLEAN_UP_FILES
      IMPLICIT NONE
C
C---Removes intermadiate files used
      INCLUDE 'restr_files.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'makecif.fh'
      LOGICAL LEXISTS
      INTEGER IFAIL,IUNIT,ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,
     &        NEWFIL,INXYZ,IOUTX,MTZIN,LL
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
C
      INTEGER LENSTR
      EXTERNAL LENSTR
C
      IF(STRUCT_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=STRUCT_FILE(1:LENSTR(STRUCT_FILE)),EXIST=LEXISTS)
      IF(LEXISTS) THEN
         call open_unform_file(iunit,struct_file,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
C
      IF(RESTRAINT_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=RESTRAINT_FILE(1:LENSTR(RESTRAINT_FILE)),
     &           EXIST=LEXISTS)
      IF(LEXISTS.AND.RESTRAINT_FILE(1:1).NE.' ') THEN
         call open_unform_file(iunit,restraint_file,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
C
      IF(COORD_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=COORD_FILE(1:LENSTR(RESTRAINT_FILE)),
     &           EXIST=LEXISTS)
      IF(LEXISTS.AND.COORD_FILE(1:1).NE.' ') THEN
         call open_unform_file(iunit,coord_file,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
C
      IF(BOND_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=BOND_FILE(1:LENSTR(BOND_FILE)),EXIST=LEXISTS)
      IF(LEXISTS.AND.BOND_FILE(1:1).NE.' ') THEN
         call open_unform_file(iunit,bond_file,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
      IF(LENSTR(BOND_FILE_EXTRA).GT.0) THEN
      INQUIRE (FILE=BOND_FILE_EXTRA(1:LENSTR(BOND_FILE_EXTRA)),
     &            EXIST=LEXISTS)
      IF(LEXISTS.AND.BOND_FILE_EXTRA(1:1).NE.' ') THEN
         call open_unform_file(iunit,bond_file_extra,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
      
      IF(LENSTR(ANGLE_FILE).GT.0) THEN
      INQUIRE (FILE=ANGLE_FILE(1:LENSTR(ANGLE_FILE)),EXIST=LEXISTS)
      IF(LEXISTS.AND.ANGLE_FILE(1:1).NE.' ') THEN
         call open_unform_file(iunit,angle_file,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
      IF(LENSTR(ANGLE_FILE_EXTRA).GT.0) THEN
      INQUIRE (FILE=ANGLE_FILE_EXTRA(1:LENSTR(ANGLE_FILE_EXTRA)),
     &               EXIST=LEXISTS)
      IF(LEXISTS.AND.ANGLE_FILE_EXTRA(1:1).NE.' ') THEN
         call open_unform_file(iunit,angle_file_extra,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF      
      IF(VDW_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=VDW_FILE(1:LENSTR(VDW_FILE)),EXIST=LEXISTS)
      IF(LEXISTS.AND.VDW_FILE(1:1).NE.' ') THEN
         call open_unform_file(iunit,vdw_file,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
      IF(VDW_FILE_0(1:1).NE.' '.AND.LENSTR(VDW_FILE_0).GT.0) THEN
      INQUIRE (FILE=VDW_FILE_0(1:LENSTR(VDW_FILE_0)),EXIST=LEXISTS)
      IF(LEXISTS.AND.VDW_FILE_0(1:1).NE.' ') THEN
         call open_unform_file(iunit,vdw_file_0,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
      IF(CHIR_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=CHIR_FILE(1:LENSTR(CHIR_FILE)),EXIST=LEXISTS)
      IF(LEXISTS.AND.CHIR_FILE(1:1).NE.' ') THEN
         call open_unform_file(iunit,chir_file,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF      
      ENDIF

      IF(TORS_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=TORS_FILE(1:LENSTR(TORS_FILE)),EXIST=LEXISTS)
      IF(LEXISTS.AND.TORS_FILE(1:1).NE.' ') THEN
         call open_unform_file(iunit,tors_file,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
 
      IF(NCSR_FILE_NAME(1:1).NE.' ') THEN
      INQUIRE (FILE=NCSR_FILE_NAME(1:LENSTR(NCSR_FILE_NAME)),
     &      EXIST=LEXISTS)
      IF(LEXISTS.AND.NCSR_FILE_NAME(1:1).NE.' ') THEN
         call open_unform_file(iunit,ncsr_file_name,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
C
      IF(NCSC_FILE_NAME(1:1).NE.' ') THEN
      INQUIRE (FILE=NCSC_FILE_NAME(1:LENSTR(NCSC_FILE_NAME)),
     &      EXIST=LEXISTS)
      IF(LEXISTS.AND.NCSC_FILE_NAME(1:1).NE.' ') THEN
         call open_unform_file(iunit,ncsc_file_name,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
C
      IF(PLANE_FILE(1:1).NE.' ') THEN
      INQUIRE (FILE=PLANE_FILE(1:LENSTR(PLANE_FILE)),EXIST=LEXISTS)
      IF(LEXISTS.AND.PLANE_FILE(1:1).NE.' ') THEN
         call open_unform_file(iunit,plane_file,ifail)
        CLOSE(IUNIT,STATUS='DELETE')
      ENDIF
      ENDIF
      if(keywords_file(1:1).ne.' ') then
         INQUIRE (FILE=keywords_file(1:LENSTR(keywords_file)),
     &        EXIST=LEXISTS)
         IF(LEXISTS.AND.keywords_file(1:1).NE.' ') THEN
            call open_form_file(iunit,keywords_file,ifail)
            CLOSE(IUNIT,STATUS='DELETE')
         ENDIF
      ENDIF 
      if(fomap_file(1:1).ne.' ') then
         inquire(file=fomap_file,exist=lexists)
         if(lexists) then
            call open_unform_file(iunit,fomap_file,ifail)
            close(iunit,status='delete')
         endif
      endif
C
      if(interval_file(1:1).ne.' ') then
         inquire(file=interval_file,exist=lexists)
         if(lexists) then
            call open_unform_file(iunit,interval_file,ifail)
            close(iunit,status='delete')
         endif
      endif
      if(harmonic_file(1:1).ne.' ') then
         inquire(file=harmonic_file,exist=lexists)
         if(lexists) then
            call open_unform_file(iunit,harmonic_file,ifail)
            close(iunit,status='delete')
         endif
      endif
      IF(ISCRF.GT.0) CLOSE(ISCRF,STATUS='DELETE')
      IF(ISCRF0.GT.0) CLOSE(ISCRF0,STATUS='DELETE')
      IF(IFSCR_SAVE.GT.0) CLOSE(IFSCR_SAVE,STATUS='DELETE')

      RETURN
      END
C
      SUBROUTINE WRITE_VS_CYCLE
C
C---This routine writes some info vs cycle into ouput log file
C---things like R factor free etc
      IMPLICIT NONE
      INCLUDE 'rharvest.fh'
C
      INTEGER ICC
      CHARACTER LINE*94
C
        CALL HEADER('Things for loggraph, R factor and others vs cycle')
        CALL ERRWRT(-1,' ')
        CALL ERRWRT(-1,
     &     '$TABLE: Rfactor analysis, stats vs cycle  :')
        CALL ERRWRT(-1,'$GRAPHS:<Rfactor> vs cycle :N:1,2,3:')
        CALL ERRWRT(-1,':FOM vs cycle :N:1,4:')
C>IJT
        CALL ERRWRT(-1,':-LL vs cycle :N:1,5:')
        CALL ERRWRT(-1,':-LLfree vs cycle :N:1,6:')
        CALL ERRWRT(-1,':Geometry vs cycle:N:1,7,8,9,10,11:')
C<IJT
        CALL ERRWRT(-1,'$$')
        CALL ERRWRT(-1,
C>IJT
     &  '    Ncyc    Rfact    Rfree     FOM      -LL     -LLfree'//
     &  '  rmsBOND  zBOND rmsANGL  zANGL rmsCHIRAL $$')
C<IJT
        CALL ERRWRT(-1,'$$')
C
      DO    ICC = 1,NCYCLE_OVERALL
        LINE = ' '
C>IJT
        WRITE(LINE(:8),'(I8)')ICC-1
        IF(RFACTOR_VS_CYCLE(ICC).GT.0.0) THEN
          WRITE(LINE(9:17),'(1X,F8.4)')RFACTOR_VS_CYCLE(ICC)
        ELSE
          LINE(9:17) = '   0.0'
        ENDIF
        IF(RFREE_VS_CYCLE(ICC).GT.0.0) THEN
          WRITE(LINE(18:26),'(1X,F8.4)')RFREE_VS_CYCLE(ICC)
        ELSE
          LINE(18:26) = '   0.0'
        ENDIF
        IF(FOM_VS_CYCLE(ICC).GT.0.0) THEN
          WRITE(LINE(27:34),'(1X,F7.3)')FOM_VS_CYCLE(ICC)
        ELSE
          LINE(27:34) = '   0.0'
        ENDIF
        WRITE(LINE(35:45),'(1X,F10.0)')LLG_VS_CYCLE(ICC)
        WRITE(LINE(46:55),'(1X,F9.1)')LLGFREE_VS_CYCLE(ICC)
        IF(BOND_VS_CYCLE(ICC).GT.0.0) THEN
          WRITE(LINE(56:64),'(1X,F8.4)')BOND_VS_CYCLE(ICC)
          WRITE(LINE(65:71),'(1X,F6.3)')ZBOND_VS_CYCLE(ICC)
        ELSE
          LINE(56:71) = '   0.0      0.0'
        ENDIF
        IF(ANGLE_VS_CYCLE(ICC).GT.0.0) THEN
          WRITE(LINE(72:79),'(1X,F7.3)')ANGLE_VS_CYCLE(ICC)
          WRITE(LINE(80:86),'(1X,F6.3)')ZANGLE_VS_CYCLE(ICC)
        ELSE
          LINE(72:86) = '   0.0     0.0'
        ENDIF
        IF(CHIR_VS_CYCLE(ICC).GT.0.0) THEN
          WRITE(LINE(87:),'(1X,F7.3)')CHIR_VS_CYCLE(ICC)
        ELSE
          LINE(87:) = '   0.0'
C<IJT
       endif

        CALL ERRWRT(-1,LINE)
      ENDDO
      CALL ERRWRT(-1,' $$ ')

      RETURN
      END
c
      subroutine  calc_bvalue_stats(nch_this,number_gr,bstats_gr)       
      implicit none
      include 'atom_com.fh'
      include 'rharvest.fh'
      include 'refi_flags.fh'
c
      integer nch_this
      integer number_gr(3,nch_this)
      real bstats_gr(3,2,nch_this)
c
c---Calculate overall B values for all atoms, main and side chains      
      integer ich
      integer i,j,k,l,ir,nside,nmain,nall
      real occ,occ2
      real bloc,bloc2,pi,eightpisq
      character side_or_main*1
c
      do i=1,3
         do l=1,n_group+1
            number_gr(i,l) = 0
            do k=1,2
               bstats_gr(i,k,l) = 0.0
            enddo
         enddo
      enddo
c
      pi = 4.0*atan2(1.0,1.0)
      eightpisq = 8.0*pi**2
      do i=1,n_atom
         ir = i_resid(i)
         ich = i_chain(ir)
         if(occup(i).gt.0.0) then
            if(atom_ref_flag(i).gt.0) then
               if(u_aniso(2,i).le.0.0) then
                  bloc = u_aniso(1,i)
               else
                  bloc = sum(u_aniso(1:3,i))/3.0
               endif
               bloc = eightpisq*bloc
               bloc2 = bloc**2
               call check_side_or_main(atm_name(i),side_or_main)
               ir = i_resid(i)
               if(res_type(ires_type(ir))(1:5).eq.'L-pep'.or.
     &            res_type(ires_type(ir))(1:5).eq.'D-pep') then
                  if(side_or_main.eq.'S') then
                     number_gr(3,1)       = number_gr(3,1) + 1
                     number_gr(3,ich+1)   = number_gr(3,ich+1) + 1
                     bstats_gr(3,1,1)     = bstats_gr(3,1,1) + bloc
                     bstats_gr(3,1,ich+1) = bstats_gr(3,1,ich+1) + bloc
                     bstats_gr(3,2,1)     = bstats_gr(3,2,1) + bloc2
                     bstats_gr(3,2,ich+1) = bstats_gr(3,2,ich+1) + bloc2
                  else
                     number_gr(2,1)       = number_gr(2,1) + 1
                     number_gr(2,ich+1)   = number_gr(2,ich+1) + 1
                     bstats_gr(2,1,1)     = bstats_gr(2,1,1) + bloc
                     bstats_gr(2,1,ich+1) = bstats_gr(2,1,ich+1) + bloc
                     bstats_gr(2,2,1)     = bstats_gr(2,2,1) + bloc2
                     bstats_gr(2,2,ich+1) = bstats_gr(2,2,ich+1) + bloc2
                  endif
               endif
               number_gr(1,1)       = number_gr(1,1) + 1
               number_gr(1,ich+1)   = number_gr(1,ich+1) + 1
               bstats_gr(1,1,1)     = bstats_gr(1,1,1) + bloc
               bstats_gr(1,1,ich+1) = bstats_gr(1,1,ich+1) + bloc
               bstats_gr(1,2,1)     = bstats_gr(1,2,1) + bloc2
               bstats_gr(1,2,ich+1) = bstats_gr(1,2,ich+1) + bloc2
            endif
         endif
      enddo
c
      do i=1,3
         do l=1,n_group+1
            if(number_gr(i,l).gt.0) then
               bstats_gr(i,1,l) = bstats_gr(i,1,l)/number_gr(i,l)
               bstats_gr(i,2,l) = 
     &              sqrt(max(0.0,bstats_gr(i,2,l)/number_gr(i,l)-
     &                    bstats_gr(i,1,l)**2))
            endif
         enddo
      enddo
c
      return
      end
c
      subroutine  calc_occup_stats(nch_this,number_gr,ostats_gr)       
      implicit none
      include 'atom_com.fh'
      include 'rharvest.fh'
      include 'refi_flags.fh'
c
      integer nch_this
      integer number_gr(3,nch_this)
      real ostats_gr(3,2,nch_this)
c
c---Calculate overall B values for all atoms, main and side chains      
      integer ich
      integer i,j,k,l,ir,nside,nmain,nall
      real occ,occ2
      character side_or_main*1
c
      do i=1,3
         do l=1,nch_this
            number_gr(i,l) = 0
            do k=1,2
               ostats_gr(i,k,l) = 0.0
            enddo
         enddo
      enddo
c
      do i=1,n_atom
         ir = i_resid(i)
         ich = i_chain(ir)
         if(occup(i).gt.0.0) then
            if(atom_ref_flag(i).gt.0) then
               occ   = occup(i)
               occ2  = occ**2
               call check_side_or_main(atm_name(i),side_or_main)
               ir = i_resid(i)
               if(res_type(ires_type(ir))(1:5).eq.'L-pep'.or.
     &            res_type(ires_type(ir))(1:5).eq.'D-pep') then
                  if(side_or_main.eq.'S') then
                     number_gr(3,1)       = number_gr(3,1) + 1
                     number_gr(3,ich+1)   = number_gr(3,ich+1) + 1
                     ostats_gr(3,1,1)     = ostats_gr(3,1,1) + occ
                     ostats_gr(3,1,ich+1) = ostats_gr(3,1,ich+1) + occ
                     ostats_gr(3,2,1)     = ostats_gr(3,2,1) + occ2
                     ostats_gr(3,2,ich+1) = ostats_gr(3,2,ich+1) + occ2
                  else
                     number_gr(2,1)       = number_gr(2,1) + 1
                     number_gr(2,ich+1)   = number_gr(2,ich+1) + 1
                     ostats_gr(2,1,1)     = ostats_gr(2,1,1) + occ
                     ostats_gr(2,1,ich+1) = ostats_gr(2,1,ich+1) + occ
                     ostats_gr(2,2,1)     = ostats_gr(2,2,1) + occ2
                     ostats_gr(2,2,ich+1) = ostats_gr(2,2,ich+1) + occ2
                  endif
               endif
               number_gr(1,1)       = number_gr(1,1) + 1
               number_gr(1,ich+1)   = number_gr(1,ich+1) + 1
               ostats_gr(1,1,1)     = ostats_gr(1,1,1) + occ
               ostats_gr(1,1,ich+1) = ostats_gr(1,1,ich+1) + occ
               ostats_gr(1,2,1)     = ostats_gr(1,2,1) + occ2
               ostats_gr(1,2,ich+1) = ostats_gr(1,2,ich+1) + occ2
            endif
         endif
      enddo
c
      do i=1,3
         do l=1,n_group+1
            if(number_gr(i,l).gt.0) then
               ostats_gr(i,1,l) = ostats_gr(i,1,l)/number_gr(i,l)
               ostats_gr(i,2,l) = 
     &              sqrt(max(0.0,ostats_gr(i,2,l)/number_gr(i,l)-
     &                    ostats_gr(i,1,l)**2))
            endif
         enddo
      enddo
c
      return
      end
c
      subroutine write_xml(ierr,message)
      implicit none
      include 'atom_com.fh'
      include 'rharvest.fh'
      include 'refi_flags.fh'
c
      character message*(*)
      integer ierr
c
      character local_file*512
      character file_pdb*512,file_mtz*512
      integer l

      character xinfo*128,xtag*32,xattr*32
      character xtag_a(6)*32,xtag_a1(3)*32
      character xtag_glob*32,xtag_g0*32,xtag_g1*32,xtag_g2*32
      character xtag_g3*32,xtag_g4*32
      character xval*512,xattr_val*512
c
c---
      integer ierr_l
      character line_xml*512
      integer i,j,k,nfirst_geom
      integer ich
      integer in,ifail,ll
c
c---For stats
      integer nch_this
      integer, allocatable :: number_gr(:,:)
      real,    allocatable :: bstats_gr(:,:,:)
      real,    allocatable :: ostats_gr(:,:,:)
c
c---  body
      call ugtenv('XMLOUT',local_file)
      if(local_file.eq.' ') return
      call open_form_file(in,local_file,ierr_l)
      if(ierr_l.gt.0) then
         write(*,*)'Error in opening xml file'
         return
      endif
c
c--write all necessary info
      l = len_trim(message)
      call xml_version(in)
      call xml_comment(in,'refmac output')
      xinfo = ' '
      xtag_glob = 'REFMAC'
      xattr = ' '
      xattr_val = ' '
      call xml_opentag(in,xinfo,xtag_glob,xattr,xattr_val)
      xinfo = 'Error'
      xtag = 'err_level'
      write(xval,'(i10)')ierr
      call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)
      xinfo = 'Message'
      xtag = 'err_message'
      xval = message
      call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)
      xinfo = 'Job'
      xtag = 'job'
      xval = 'refmac'
      call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)
      if(ierr.gt.0) then
         call xml_closetag(in,xtag_glob)
         close(in)
         return
      endif
c
      xinfo = ' '
      xtag_g0 = 'Overall_stats'
      call xml_opentag(in,xinfo,xtag_g0,xattr,xattr_val)
         
      xtag  = 'n_cycle'
      write(xval,'(i6)')ncycle_overall
      xattr_val = ' '
      call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)
      xinfo = ' '
      xtag  = 'ml_esu'
      write(xval,'(f10.4)')hesu_ml
      call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)

      xtag = 'n_reflections_all'
      write(xval,'(i12)')nhrefl_free+nhrefl_work
      call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)

      xtag = 'n_reflections_free'
      write(xval,'(i12)')nhrefl_free
      call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)

      xtag = 'data_completeness'
      write(xval,'(f10.3)')hperc_shell_refl(hnshell+1)
      call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)

      xtag = 'resolution_low'
      write(xval,'(f10.3)')hd_low
      call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)

      xtag = 'resolution_high'
      write(xval,'(f10.3)')hd_high
      call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)

      xinfo = ' '
      xtag_g1 = 'stats_vs_cycle'
      call xml_opentag(in,xinfo,xtag_g1,xattr,xattr_val)

      line_xml = ' '
      do i=1,ncycle_overall
         xinfo = ' '
         xtag_g2 = 'new_cycle'
         call xml_opentag(in,xinfo,xtag_g2,xattr,xattr_val)
         xtag  = 'cycle'
         write(xval,'(i7)')i
         call xml_additem(in,line_xml,xinfo,xtag,xval,xattr,xattr_val)
         xtag  = 'r_factor'
         write(xval,'(f10.3)')rfactor_vs_cycle(i)
         call xml_additem(in,line_xml,xinfo,xtag,xval,xattr,xattr_val)
         xtag = 'r_free'
         write(xval,'(f10.3)')rfree_vs_cycle(i)
         call xml_additem(in,line_xml,xinfo,xtag,xval,xattr,xattr_val)
         xtag  = 'rmsBOND'         
         write(xval,'(f10.4)')bond_vs_cycle(i)
         call xml_additem(in,line_xml,xinfo,xtag,xval,xattr,xattr_val)
         xtag = 'rmsANGLE'
         write(xval,'(f10.3)')angle_vs_cycle(i)
         call xml_additem(in,line_xml,xinfo,xtag,xval,xattr,xattr_val)
         xtag  = 'rmsCHIRAL'
         write(xval,'(f10.3)')chir_vs_cycle(i)
         call xml_additem(in,line_xml,xinfo,xtag,xval,xattr,xattr_val)
         
         call xml_dump(in,line_xml)
         call xml_closetag(in,xtag_g2)
      enddo
      call xml_closetag(in,xtag_g1)
c---
c---  Careful here. Case TLS should be considered
      
c
c---Add some info about geometry also

c
c---  B values
      xtag_a1(1) = 'all'
      xtag_a1(2) = 'main_chain'
      xtag_a1(3) = 'side_chain'
      if(bref_type.ne.'OVER') then
         xtag_g1 = 'bvalue_stats'
         call xml_opentag(in,xinfo,xtag_g1,xattr,xattr_val)
c
c---  Calculate statistics
         allocate(number_gr(3,n_group+1))
         allocate(bstats_gr(3,2,n_group+1))
         nch_this = n_group+1
         call calc_bvalue_stats(nch_this,number_gr,bstats_gr)         
         
         xtag_g2 = 'overall'
         call xml_opentag(in,xinfo,xtag_g2,xattr,xattr_val)

         line_xml = ' '
         do i=1,3
            xtag_g4 = xtag_a1(i)
            call xml_opentag(in,xinfo,xtag_g4,xattr,xattr_val)
            xtag = 'number'
            write(xval,'(i10)')number_gr(i,1)
            call xml_additem(in,line_xml,xinfo,xtag,xval,
     &           xattr,xattr_val)
            xtag = 'average'
            write(xval,'(f10.4)')bstats_gr(i,1,1)
            call xml_additem(in,line_xml,xinfo,xtag,xval,
     &           xattr,xattr_val)
            xtag = 'sigma'
            write(xval,'(f10.4)')bstats_gr(i,2,1)
            call xml_additem(in,line_xml,xinfo,xtag,xval,
     &           xattr,xattr_val)
            call xml_dump(in,line_xml)
            call xml_closetag(in,xtag_g4)
         enddo
         call xml_closetag(in,xtag_g2)

         if(n_group.gt.0) then
            xtag_g2 = 'chain_by_chain'
            call xml_opentag(in,xinfo,xtag_g2,xattr,xattr_val)
            xinfo = ' '
            do l=1,n_group
               xtag_g3 = 'new_chain'
               call xml_opentag(in,xinfo,xtag_g3,xattr,xattr_val)
               xtag = 'chain_name'
               xval = group_id(l)
               call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)
               do i=1,3
                  xtag_g4 = xtag_a1(i)
                  call xml_opentag(in,xinfo,xtag_g4,xattr,xattr_val)
                  xtag = 'number'
                  write(xval,'(i10)')number_gr(i,l+1)
                  call xml_additem(in,line_xml,xinfo,xtag,xval,
     &                 xattr,xattr_val)
                  xtag = 'average'
                  write(xval,'(f10.4)')bstats_gr(i,1,l+1)
                  call xml_additem(in,line_xml,xinfo,xtag,xval,
     &                 xattr,xattr_val)
                  xtag = 'sigma'
                  write(xval,'(f10.4)')bstats_gr(i,2,l+1)
                  call xml_additem(in,line_xml,xinfo,xtag,xval,
     &                 xattr,xattr_val)
                  call xml_dump(in,line_xml)
                  call xml_closetag(in,xtag_g4)
               enddo
               call xml_closetag(in,xtag_g3)
            enddo
            call xml_closetag(in,xtag_g2)
         endif
         call xml_closetag(in,xtag_g1)
         deallocate(number_gr)
         deallocate(bstats_gr)
      endif
c
c--   Ae we refining occupancies

      if(mode.eq.'OCCU') then
c
c---  Calculate statistics
         xtag_g1 = 'occupancy_stats'
         call xml_opentag(in,xinfo,xtag_g1,xattr,xattr_val)

         allocate(number_gr(3,n_group+1))
         allocate(ostats_gr(3,2,n_group+1))
         nch_this = n_group+1
         call calc_occup_stats(nch_this,number_gr,ostats_gr)         
         xtag_g2 = 'overall'
         call xml_opentag(in,xinfo,xtag_g2,xattr,xattr_val)

         line_xml = ' '
         do i=1,3
            xtag_g4 = xtag_a1(i)
            call xml_opentag(in,xinfo,xtag_g4,xattr,xattr_val)
            xtag = 'number'
            write(xval,'(i10)')number_gr(i,1)
            call xml_additem(in,line_xml,xinfo,xtag,xval,
     &           xattr,xattr_val)
            xtag = 'average'
            write(xval,'(f10.4)')ostats_gr(i,1,1)
            call xml_additem(in,line_xml,xinfo,xtag,xval,
     &           xattr,xattr_val)
            xtag = 'sigma'
            write(xval,'(f10.4)')ostats_gr(i,2,1)
            call xml_additem(in,line_xml,xinfo,xtag,xval,
     &           xattr,xattr_val)
            call xml_dump(in,line_xml)
            call xml_closetag(in,xtag_g4)
         enddo
         call xml_closetag(in,xtag_g2)

         if(n_group.gt.0) then
            xinfo = 'Chain bvalue stats'
            xtag_g2 = 'chain_by_chain'
            call xml_opentag(in,xinfo,xtag_g2,xattr,xattr_val)
            xinfo = ' '
            do l=1,n_group
               xtag_g3 = 'new_chain'
               call xml_opentag(in,xinfo,xtag_g3,xattr,xattr_val)
               xtag = 'chain_name'
               xval = group_id(l)
               call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)
               do i=1,3
                  xtag_g4 = xtag_a1(i)
                  call xml_opentag(in,xinfo,xtag_g4,xattr,xattr_val)
                  xtag = 'number'
                  write(xval,'(i10)')number_gr(i,l+1)
                  call xml_additem(in,line_xml,xinfo,xtag,xval,
     &                 xattr,xattr_val)
                  xtag = 'average'
                  write(xval,'(f10.4)')ostats_gr(i,1,l+1)
                  call xml_additem(in,line_xml,xinfo,xtag,xval,
     &                 xattr,xattr_val)
                  xtag = 'sigma'
                  write(xval,'(f10.4)')ostats_gr(i,2,l+1)
                  call xml_additem(in,line_xml,xinfo,xtag,xval,
     &                 xattr,xattr_val)
                  call xml_dump(in,line_xml)
                  call xml_closetag(in,xtag_g4)
               enddo
               call xml_closetag(in,xtag_g3)
            enddo
            call xml_closetag(in,xtag_g2)
         endif
         call xml_closetag(in,xtag_g1)

         deallocate(number_gr)
         deallocate(ostats_gr)
      endif
      call xml_closetag(in,xtag_g0)
c
c---Any other info

      xinfo = ' '
      xval  = ' '
      call ugtenv('XYZOUT',file_pdb)
      if(file_pdb.eq.' ') file_pdb = 'XYZOUT'
      xinfo = ' '
      xtag = 'solution_file'
      xattr = ' '
      xval = file_pdb
      call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)

      call ugtenv('HKLOUT',file_mtz)
      if(file_mtz.eq.' ') file_mtz = 'HKLOUT'
      xtag = 'mtz_file'
      xattr = ' '
      xval = file_mtz
      call xml_oneliner(in,xinfo,xtag,xval,xattr,xattr_val)

      call xml_closetag(in,xtag_glob)
      close(in)

      return
      end
c
      subroutine check_end
      implicit none
c     

      return
      end
