C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
      SUBROUTINE SOLVENT
C-----------------------------------------------------------------------
C     THIS ROUTINE DESIGNED TO EMULATE SIMILAR ROUTINES FROM THE AGARWAL
C     FFT UNCONSTRAINED REFINEMENT PACKAGE.   IT DRIVES THE SEQUENCE OF
C     FOURIER AND GRADIENT ROUTINES FOR THE CALCULATION OF LEAST-SQUARES
C     MATRIX ELEMENTS FOR PROLSQ. MODIFIED FOR ALL SPACE GROUPS
C         *********SPACE GROUP GENERAL**********
C      G.N.M. 16.09.91
C-----------------------------------------------------------------------
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'monitor.fh'

      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
      COMMON /HKLLIM/ HMAX, KMAX, LMAX

      INTEGER   HMAX, KMAX, LMAX
      INTEGER   FC_ADDR,PHASE_ADDR,DEN_ADDR,IND_ADDR,POOL_ADDR
      REAL FSHANN_L
      INTEGER   SIZE
      CHARACTER LINE*128

C -----------------------------------------------------
C
C---Find minimum accetable grid spacing for ffts
C      ACC_AREA_ADDRESS = 1
C      N_WORK_ADDRESS = N_WORK_ADDRES  + N_ATOM
C      CALL SOLV_ACCESS(N_ATOM,XYZ_CRD,VAL(ACC_AREA_ADDRESS),
      NX = 0
      NY = 0
      NZ = 0
cd      FSHANN = 2.0
cd      FSHANN_L = 1.3
      FSHANN_L = FSHANN
      CALL GET_GRID_SPACING(FSHANN_L,NGX,NGY,NGZ,HMAX,KMAX,LMAX)
C   
      CALL ASYLIM_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,IPX,IPY,IPZ,NMFOUR)

c      CALL ASYLIM(CS_NSPGR,IPX,IPY,IPZ,NMFOUR)
      ASYMLIM1 = 1.0/IPX
      ASYMLIM2 = 1.0/IPY
      ASYMLIM3 = 1.0/IPZ
      IF(MON_STYLE.EQ.'MANY') THEN
        WRITE(LINE,'(A,3F5.2)')' Limits of asymmetric unit      :',
     +               ASYMLIM1,ASYMLIM2,ASYMLIM3
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(A,3I5)')  ' Grid spacing to be used        : ',
     +             NX,NY,NZ
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(A,3I5)')  ' Maximuum H,K,L                 : ',
     +             HMAX,KMAX,LMAX
        CALL ERRWRT(-1,LINE)
        WRITE(LINE,'(A,3I5)')  ' Minimum acceptable grid spacing: ',
     +             NGX,NGY,NGZ
        CALL ERRWRT(-1,LINE)
      ENDIF
c
      IF(MOD(NX,NMFOUR).NE.0.OR.MOD(NY,NMFOUR).NE.0
     +  .OR.MOD(NZ,NMFOUR).NE.0) THEN 
           CALL ERRWRT(1,' Change grid spacings ')
      ENDIF
C
C----Now allocate memory for S.F. Den and so on
      N1   = NX
      N2   = NY
      N3   = NZ/IPZ
      IF(IPZ.GT.1) N3 = N3 + 1
      SIZE = N1*N2*N3+1
      NXY  = (NX+1)*(NY+1)

C
C     ALLOCATE MEMORY FOR FO,SIGO and IND
      IND_ADDR  = 1
C
C---If we are going to use PHI FCi or other informations they could be added
C---here
C     ALLOCATE MEMORY FOR FC
      FC_ADDR     = IND_ADDR   + NOBS + 1
      PHASE_ADDR  = FC_ADDR    + NOBS + 1
      DEN_ADDR    = PHASE_ADDR + NOBS + 1 
      POOL_ADDR   = DEN_ADDR   + SIZE + 1
C
      CALL REF_ALL_SOLV(NREF,NOBS)

      NX = 0
      NY = 0
      NZ = 0
      RETURN
      END

C-----------------------------------------------------------------------
      SUBROUTINE REF_ALL_SOLV(NREF,SZ)
      IMPLICIT NONE
C
C     THIS ROUTINE FROM THE AGARWAL FFT UNCONSTRAINED REFINEMENT
C     PACKAGE. MODIFIED FOR ALL SPACE GROUPS.
C
C----This subroutine uses semi FFT
C
C          ********SPACE GROUP GENERAL***********
C       G.N.M.  16.09.91
C-----------------------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'solvent.fh'
      INCLUDE 'rharvest.fh'
      INTEGER   SZ,NREF

C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C
      real, allocatable :: fc(:)
      real, allocatable :: phase(:)
      real, allocatable :: den(:,:,:)
      real, allocatable :: pool(:)
      integer, allocatable :: nind(:)

      integer i
      integer ia,iexcl
      integer ires_num_loc
      character chnid_loc*4
      REAL ZERO
      INTEGER IZERO
      real,   allocatable :: occupancy_save(:)
C----Initialise
      allocate(fc(nobs))
      allocate(phase(nobs))
      allocate(den(n1,n2,n3))
      allocate(nind(nobs))

      ZERO  = 0.0
      IZERO = 0
      CALL INIT_VEC(SZ,FC,ZERO)
      CALL INIT_VEC(SZ,PHASE,ZERO)
      CALL INIT_VECN(SZ,NIND,IZERO)
C
C     GENERATE SOLVENT DENSITY MAP
      CALL MASK_INIT(DEN)
C     
C      CALL SOLVENT_ACC(ACC)
C     
C---the  atoms excluded from the refinement will be included in the mask 
c---caluclations
c
c---  allocate and store occupancies. Promote occupancy of the selected atoms
c---  to one
      allocate(occupancy_save(n_atom))
      occupancy_save(1:n_atom) = occup(1:n_atom)
      if(excl_refi_num.gt.0) then
         do   ia=1,n_atom
            call get_chain_namepdb(chnid_loc,i_resid(ia))
            read(res_num_pdb(i_resid(ia))(3:6),*)ires_num_loc 
            do   iexcl=1,excl_refi_num
               if(excl_refi_begin(iexcl).le.ires_num_loc.and.
     &              excl_refi_end(iexcl).ge.ires_num_loc.and.
     &              excl_refi_chn(iexcl).eq.chnid_loc) then
                  occup(ia) = 1.0
               endif
            enddo
         enddo
      endif
      call set_hkon_flags
      CALL SOLVENT_MASK(DEN)
      CALL PROT_SHRINK(DEN)
c
c---Store and deallocate
      occup(1:n_atom) = occupancy_save(1:n_atom)
      deallocate(occupancy_save)
      call set_hkon_flags
c
      CALL WRITE_SOLVENT_MASK(DEN)
      CALL READ_INDICES(NREF,NIND)
      CALL REDALLI(N1,N2,N3,NX,NY,NZ,ROTR,TRR,NonCubSym,DEN)
      allocate(pool(4*nx*ny))
      CALL RFFT(NREF,DEN,pool,FC,PHASE,NIND)
      deallocate(pool)
      CALL PROCESS_SOLVENT(NREF,NIND,FC,PHASE)
      CALL ADD_PARTIAL(NREF,FC,PHASE)
C
C---Adjust scale parameters
C
C---if first time then do it
      IF(NCYCLE_OVERALL.LE.0) THEN
        SCALE_LS_PART_REFINE_FLAG(NPART) = SCALE_LS_SOLVENT_MASK_FLAG
        B_LS_PART_REFINE_FLAG(NPART)     = B_LS_SOLVENT_MASK_FLAG
        SCALE_LS_PART(NPART)             = SCALE_LS_SOL_M
        B_LS_PART(NPART)                 = B_LS_SOL_M
      ENDIF
      deallocate(fc)
      deallocate(phase)
      deallocate(den)
      deallocate(nind)
      RETURN
      END
C
      SUBROUTINE MASK_INIT(DEN)
C
      IMPLICIT NONE
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
C
      INTEGER IX,IY,IZ
      REAL D22,SX,SY,SZ
      REAL DEN(N1,N2,N3)
C
C
      SX     = CS_CELL(1)/NX
      SY     = CS_CELL(2)/NY
      SZ     = CS_CELL(3)/NZ
      COSAST = (COSA-COSB*COSG)/(SING*SING)

C ---mask initialised to D22 
      D22 = SX*SY*SZ*COSZ*SING
      DO IZ = 1,N3
        DO IY = 1,N2
          DO IX = 1,N1
            DEN(IX,IY,IZ) = D22
          ENDDO
        ENDDO
      ENDDO
C
      RETURN
      END
C
C
C
      SUBROUTINE SOLVENT_MASK(DEN)
C-----------------------------------------------------------------
C---------           SPACE GROUP GENERAL
C---This subroutine calculates electron density from atoms and fills
C---"asymmetric" unit of crystals. Displacement parameters are as U
C---values
C-------------------------------------------------------------------
      INCLUDE 'atom_com.fh'
      include 'atom_com_str.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
C
      REAL   DEN(N1,N2,N3)
C
C---Local variables
      REAL    XA_LIST(3,500)
      INTEGER INDSYM_LIST(500)
      REAL    XYZ(3)
      LOGICAL ERROR


C-----D1 is going to be occupancy dependent

      D1 = -1.0E32
      DO   IA=1,N_ATOM
         CALL GET_RADIUS_FOR_THIS_ATOM(IA,RD1)
         D1 = AMAX1(D1,RD1)
      ENDDO

C----Find extension limits for asymmetric unit
      D_SOLV_LIM = D1**2
      CALL ASYMLIM_FRAC(D_SOLV_LIM,XLOW,YLOW,ZLOW,XUPPER,YUPPER,ZUPPER)
      SX     = CS_CELL(1)/NX
      SY     = CS_CELL(2)/NY
      SZ     = CS_CELL(3)/NZ
      COSAST = (COSA-COSB*COSG)/(SING*SING)
      DLIMIT = DDLIM
      CSA2        = 2.0*COSA
      CSB2        = 2.0*COSB
      CSG2        = 2.0*COSG
C ---
      D22 = SX*SY*SZ*COSZ*SING
C
C----Loop over all atoms
      NX50 = 50*NX
      NY50 = 50*NY
      NZ50 = 50*NZ
      DO     IA=1,N_ATOM
      
C---If atom has isotropic U values
        CALL GET_RADIUS_FOR_THIS_ATOM(IA,D0)
c        write(*,*)ia,d0
        D1 = D0**2
C
C---Add NCS here
       IF(OCCUP(IA).LE.0.0.OR.CS_ELEMENT(ID_SF(IA)).EQ.'H   '.OR.
     &    CS_ELEMENT(ID_SF(IA)).EQ.'H-1 '.OR.ATOM_REF_FLAG(IA).LE.2) 
     &        GOTO 500
C
C---List of all atoms contributing to asymmetric unit
        CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ,ERROR)
        CALL ATLIST1(XYZ,XA_list,XLOW,YLOW,ZLOW,XUPPER,YUPPER,
     +           ZUPPER,INDSYM_LIST,NATOM_LIST)
C
C----Loop over list of atoms which contribute to "asymmetric" unit
        DO    ILIST=1,NATOM_LIST
          X1 = XA_list(1,ILIST)*CS_CELL(1)
          Y1 = XA_list(2,ILIST)*CS_CELL(2)
          Z1 = XA_list(3,ILIST)*CS_CELL(3)
          XC = X1/SX
          YC = Y1/SY
          ZC = Z1/SZ
C
          RADZ = SQRT(D1)/(SZ*COSZ)
          SZL  = ZC - RADZ
          SZU  = ZC + RADZ
          ISZL = INT(SZL+501.0)
          ISZU = INT(SZU+500.0)
          DO      IZ1 = ISZL,ISZU
             IZ  = IZ1 - 500
             IZ2 = MOD(IZ+NZ50,NZ) + 1
             IF(IZ2.GT.N3)GO TO 300
             DZ  = IZ*SZ - Z1
             DZO = DZ*RO_UNIT(3,3)
             DZO2= DZO*DZO
             D2  = DZ*DZ
             D7  = D1 - DZO2
             IF (D7.LT.0.0)GO TO 300
             RADY   = SQRT(D7)/(SY*SING)
             ZCOSA  = DZ*COSAST/SY
             SYL    = YC - RADY - ZCOSA
             SYU    = YC + RADY - ZCOSA
             ISYL   = INT(SYL+501.0)
             ISYU   = INT(SYU+500.0)
             DZCSA2 = DZ*CSA2
             DZROX  = DZ*RO_UNIT(1,3)
             DZROY  = RO_UNIT(2,3)*DZ
             DZCSB  = DZ*COSB
             DO     IY1 = ISYL,ISYU
               IY  = IY1-500
               IY2 = MOD(IY+NY50,NY)+1
C---CHECK FOR IY2 WITHIN ASYMMETRIC UNIT
               IF(IY2.GT.N2)GO TO 290
               DY     = IY*SY-Y1
               DYO    = DY*RO_UNIT(2,2) + DZROY
               DYO2   = DYO*DYO
               DYZ    = D2+(DZCSA2+DY)*DY
               DXMIN  =-DY*COSG-DZCSB
               DSQMIN = DYZ - DXMIN**2
               D4     = D1 - DSQMIN
               IF(D4.LT.0.0) GOTO 290
               RADX     = SQRT(D4)/(SX*SING)
               XDELTA   = DXMIN/SX
               SXL      = XC - RADX + XDELTA
               SXU      = XC + RADX + XDELTA
               ISXL     = INT(SXL+501.0)
               ISXU     = INT(SXU+500.0)
               DYZROX   = DY*RO_UNIT(1,2) + DZROX
               DXO2PYO2 = DYO2 + DZO2
               
               DO      IX1 = ISXL,ISXU
                 IX   = IX1 - 500
                 IX2  = MOD(IX+NX50,NX)+1
C---CHECK FOR IX2 WITHIN ASYMMETRIC UNIT
                 IF(IX2.GT.N1)GO TO 280
                 DX   = IX*SX-X1
                 DXO  = DX*RO_UNIT(1,1) + DYZROX
                 DXO2 = DXO*DXO
                 DSQ  = DXO2 + DXO2PYO2
                 IF(DSQ.GT.D1)GO TO 280
                 DEN(IX2,IY2,IZ2)=0.0
 280             CONTINUE
              ENDDO
 290          CONTINUE
            ENDDO
 300        CONTINUE
          ENDDO
        ENDDO
 500    CONTINUE
      ENDDO
c      STOP
      RETURN
      END
C
      SUBROUTINE GET_RADIUS_FOR_THIS_ATOM(IA,D1)
      IMPLICIT NONE
      
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'solvent.fh'
      INTEGER IA
      REAL  D1
C
      REAL ALPHA,ALPHA1
C
      ALPHA  = PROB_VDW
      ALPHA1 = PROB_ION
C-----
C       IF (ACC(IA).EQ.0.0) THEN
       D1 = VDW_RAD(IA) + ALPHA
       IF(ION_RAD(IA).GT.0.0) 
     &      D1 = ION_RAD(IA) + ALPHA1
       IF(ATM_NAME(IA)(1:3).EQ.'DUM') D1 = 1.8 + ALPHA
cd       WRITE(*,*)CS_ELEMENT(ID_SF(IA)),CHEM_TYPE(IA),VDW_RAD(IA),
cd     & ION_RAD(IA)
C      ELSE
C       D1 = ATOM_TYPE_ION(I_ATOM_TYPE)
C      ENDIF
C-----
c       write(*,*)cs_element(id_sf(ia)),d1,alpha
c       stop
      RETURN
      END
C
      
C
      SUBROUTINE WRITE_SOLVENT_MASK(DEN)
C
C---This routine writes mask in a ccp4 map format
      IMPLICIT NONE
C
      INCLUDE 'celsym.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'const.fh'
C
      REAL DEN(N1,N2,N3)
C
      INTEGER IUN_MAP,NSEC,NW1,NU1,NU2,NV1,NV2,LSPGRP,LMODE,MU,MV,IZ
      INTEGER IU1,IU2,IV1,IV2,I
      INTEGER IUVW(3),MXYZ(3)
      REAL   CELL_LOCAL(6)
      CHARACTER TITLE*80,file_local*512
      integer lenstr
      external lenstr
     
C
C--SEt up parameters for map header
      IUVW(1) = 1
      IUVW(2) = 2
      IUVW(3) = 3
      MXYZ(1) = NX
      MXYZ(2) = NY
      MXYZ(3) = NZ
      NW1     = 0
      NU1     = 0
      NU2     = N1-1
      NV1     = 0
      NV2     = N2-1
      DO    I=1,6
        CELL_LOCAL(I) = CS_CELL(I)
      ENDDO
C
C--Make sure that cell angles are in degrees
      IF(CELL_LOCAL(4).LE.5.0.AND.CELL_LOCAL(5).LE.5.0.AND.
     &   CELL_LOCAL(6).LE.5.0) THEN
        CELL_LOCAL(4) = CELL_LOCAL(4)*RTODEG
        CELL_LOCAL(5) = CELL_LOCAL(5)*RTODEG
        CELL_LOCAL(6) = CELL_LOCAL(6)*RTODEG
      ENDIF
      LSPGRP  = ISPNO
      LMODE   = 2
      NSEC    = N3
      IUN_MAP = 0
      TITLE   = 'Mask from refmac'
      call ugtenv('MSKOUT',file_local)
      if(lenstr(file_local).le.0) return
      CALL MWRHDL(IUN_MAP,'MSKOUT',TITLE,NSEC,IUVW,MXYZ,
     &      NW1,NU1,NU2,NV1,NV2,CELL_LOCAL,LSPGRP,LMODE)
      call msyput(0,lspgrp,iun_map)
C
      MU = N1
      MV = N2
      IU1 = 0
      IU2 = N1-1
      IV1 = 0
      IV2 = N2-1
C
C---Loop over z sections to write map
      DO    IZ = 1,N3
         CALL MWRSEC(IUN_MAP,DEN(1,1,IZ),MU,MV,IU1,IU2,IV1,IV2)
      ENDDO
      CALL MWCLOSE(IUN_MAP)
      RETURN
      END
C
      SUBROUTINE PROCESS_SOLVENT(NREF,NIND,FC,PHASE)
C
      IMPLICIT NONE
C
      INCLUDE 'atom_com.fh'
C
      REAL     FC(*),PHASE(*),RSQ
      REAL     FWAT0,AVWAT,FWAT,INTR1,B_WAT
C-----Find this value in literature
      PARAMETER (AVWAT = 1.0)
C
      INTEGER  NREF,I,II,OX
      INTEGER  NIND(*)
C
      B_WAT = 0.0
      OX = 1
      DO II = 1,CS_NSFATM
       IF (CS_ELEMENT(II).EQ.'O   ') THEN
         OX = II
         GOTO 11
       ENDIF
      ENDDO
C
 11   CONTINUE
      FWAT0 = CS_A(1,OX) + CS_A(2,OX) + CS_A(3,OX) 
     &          + CS_A(4,OX) + CS_A(5,OX)
C
      DO II = 1, NREF
         CALL INDTORS(NIND(II),RSQ)
         RSQ = RSQ/4.0
         INTR1 = 0.0
C
         DO I=1,4
            INTR1 = INTR1 + CS_A(I,OX)*EXP(-CS_B(I,OX)*RSQ)
         ENDDO
         FWAT = CS_A(5,OX) + INTR1
C------8.0 IS FWAT FOR S=0
         FWAT   = 1.0
         FWAT0  = 1.0
         FC(II) = (FWAT/FWAT0)*AVWAT*FC(II)*EXP(-RSQ*B_WAT)
      ENDDO
C
      RETURN
      END
C
      SUBROUTINE PROT_SHRINK(DEN)
C-----------------------------------------------------------------
C---------           SPACE GROUP GENERAL
C---This subroutine calculates electron density from atoms and fills
C---"asymmetric" unit of crystals. Displacement parameters are as U
C---values
C-------------------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'solvent.fh'
C
      REAL   DEN(N1,N2,N3)
C
C---Local variables
      REAL D22,D221,D222,D22EPS
      INTEGER IS,N1_L,N2_L,N3_L
      REAL    XA_LIST(3,500)
      INTEGER INDSYM_LIST(500)
      INTEGER IROT_L(3,3,192),ITR_L(3,192)
      INTEGER NX_L(3)
      REAL    XYZ(3)
      REAL DENS_NEIB(3,3,3)
C
C-----This is the shrink radius
C
      NX_L(1) = NX
      NX_L(2) = NY
      NX_L(3) = NZ
      DO   IS=1,NumSymmetry
         DO  I=1,3
           DO  K=1,3
             IROT_L(K,I,IS) = NINT(ROT(K,I,IS))
           ENDDO
           ITR_L(I,IS) = NINT(TR(I,IS)*NX_L(I))
         ENDDO
cd         DO  I=1,3
cd           WRITE(*,*)(IROT_L(K,I,IS),K=1,3),ITR_L(I,IS)
cd         ENDDO
      ENDDO
C
      D1 = RADII_SHRINK

C----Find extension limits for asymmetric unit
      D_SOLV_LIM = D1**2
      CALL ASYMLIM_FRAC(D_SOLV_LIM,XLOW,YLOW,ZLOW,XUPPER,YUPPER,ZUPPER)
      SX     = CS_CELL(1)/NX
      SY     = CS_CELL(2)/NY
      SZ     = CS_CELL(3)/NZ
      COSAST = (COSA-COSB*COSG)/(SING*SING)
      CSA2        = 2.0*COSA
      CSB2        = 2.0*COSB
      CSG2        = 2.0*COSG
C ---
      D22 = SX*SY*SZ*COSZ*SING
      D221 = D22*0.1
      D222 = D22*0.2
      D22EPS = D22*1.0E-3
      SXS = SX*SING
C
C----Loop over all atoms
      NX50 = 50*NX
      NY50 = 50*NY
      NZ50 = 50*NZ
      D1 = D1**2
      NMASK_INIT = 0
      NMASK_ADD  = 0
      N1_L = N1-1
      N2_L = N2-1
      N3_L = N3-1
      DO   IZ10=1,N3
        DO   IY10=1,N2
          DO   IX10=1,N1
            IF(DEN(IX10,IY10,IZ10).LT.D222) GOTO 500
cd            NMASK_INIT = NMASK_INIT + 1
            IX11 = IX10 - 1 
            IY11 = IY10 - 1
            IZ11 = IZ10 - 1
            CALL GET_NEIBOURS_MASK(IX11,IY11,IZ11,NX,NY,NZ,
     &           N1,N2,N3,
     &           NumSymmetry,IROT_L,ITR_L,DEN,DENS_NEIB)
            DO  I=1,3
              DO  J=1,3
                DO   K=1,3
                  IF(DENS_NEIB(K,J,I).LT.D222) GOTO 100
                ENDDO
              ENDDO
            ENDDO
            GOTO 500
 100        CONTINUE
            XYZ(1) = FLOAT(IX11)/FLOAT(NX)
            XYZ(2) = FLOAT(IY11)/FLOAT(NY)
            XYZ(3) = FLOAT(IZ11)/FLOAT(NZ)
C
C---List of all atoms contributing to asymmetric unit
            CALL ATLIST1(XYZ,XA_list,XLOW,YLOW,ZLOW,XUPPER,YUPPER,
     +                ZUPPER,INDSYM_LIST,NATOM_LIST)
C
C----Loop over list of atoms which contribute to "asymmetric" unit
            DO    ILIST=1,NATOM_LIST
              X1 = XA_list(1,ILIST)*CS_CELL(1)
              Y1 = XA_list(2,ILIST)*CS_CELL(2)
              Z1 = XA_list(3,ILIST)*CS_CELL(3)
              XC = X1/SX
              YC = Y1/SY
              ZC = Z1/SZ
C
              RADZ = SQRT(D1)/(SZ*COSZ)
              SZL  = ZC - RADZ
              SZU  = ZC + RADZ
              ISZL = INT(SZL+501.0)
              ISZU = INT(SZU+500.0)
              DO      IZ1 = ISZL,ISZU
                IZ  = IZ1 - 500
                IZ2 = MOD(IZ+NZ50,NZ) + 1
                IF(IZ2.GT.N3)GO TO 300
                DZ  = IZ*SZ - Z1
                DZO = DZ*RO_UNIT(3,3)
                DZO2= DZO*DZO
                D2  = DZ*DZ
                D7  = D1 - DZO2
                IF (D7.LT.0.0)GO TO 300
                RADY   = SQRT(D7)/(SY*SING)
                ZCOSA  = DZ*COSAST/SY
                SYL    = YC - RADY - ZCOSA
                SYU    = YC + RADY - ZCOSA
                ISYL   = INT(SYL+501.0)
                ISYU   = INT(SYU+500.0)
                DZCSA2 = DZ*CSA2
                DZROX  = DZ*RO_UNIT(1,3)
                DZROY  = RO_UNIT(2,3)*DZ
                DZCSB  = DZ*COSB
                DO     IY1 = ISYL,ISYU
                  IY  = IY1-500
                  IY2 = MOD(IY+NY50,NY)+1
C---CHECK FOR IY2 WITHIN ASYMMETRIC UNIT
                  IF(IY2.GT.N2)GO TO 290
                  DY     = IY*SY-Y1
                  DYO    = DY*RO_UNIT(2,2) + DZROY
                  DYO2   = DYO*DYO
                  DYZ    = D2+(DZCSA2+DY)*DY
                  DXMIN  =-DY*COSG-DZCSB
                  DSQMIN = DYZ - DXMIN**2
                  D4     = D1 - DSQMIN
                  IF(D4.LT.0.0) GOTO 290
                  RADX     = SQRT(D4)/SXS
                  XDELTA   = DXMIN/SX
                  XC1      = XC + XDELTA
                  SXL      = XC1 - RADX
                  SXU      = XC1 + RADX
                  ISXL     = INT(SXL+501.0)
                  ISXU     = INT(SXU+500.0)
                  DYZROX   = DY*RO_UNIT(1,2) + DZROX
                  DXO2PYO2 = DYO2 + DZO2
               
                  DO      IX1 = ISXL,ISXU
                    IX   = IX1 - 500
                    IX2  = MOD(IX+NX50,NX)+1
C---CHECK FOR IX2 WITHIN ASYMMETRIC UNIT
                    IF(IX2.GT.N1)GO TO 280
                    DX   = IX*SX-X1
                    DXO  = DX*RO_UNIT(1,1) + DYZROX
                    DXO2 = DXO*DXO
                    DSQ  = DXO2 + DXO2PYO2
                    IF(DSQ.GT.D1)GO TO 280

                    IF(DEN(IX2,IY2,IZ2).LE.D22EPS) THEN
                      DEN(IX2,IY2,IZ2) = D221
cd                      NMASK_ADD = NMASK_ADD + 1
cd                      GOTO 500
                    ENDIF
C
 280                CONTINUE
                  ENDDO
 290              CONTINUE
                ENDDO
 300            CONTINUE
              ENDDO
 600          CONTINUE
            ENDDO
 500        CONTINUE
          ENDDO
        ENDDO
      ENDDO
cd      WRITE(*,*)NMASK_INIT,NMASK_ADD
cd      STOP
      DO    IZ=1,N3
        DO    IY=1,N2
          DO    IX=1,N1
            IF(DEN(IX,IY,IZ).NE.0.0) DEN(IX,IY,IZ) = D22
          ENDDO
        ENDDO
      ENDDO
      RETURN
      END
C
      SUBROUTINE GET_NEIBOURS_MASK(IX,IY,IZ,NX,NY,NZ,N1,N2,N3,
     &           NumSymmetry,IROT_L,ITR_L,DENS,DENS_NEIB)
C
      IMPLICIT NONE
      INTEGER IX,IY,IZ,NX,NY,NZ,N1,N2,N3
      INTEGER NumSymmetry
      INTEGER IROT_L(3,3,*),ITR_L(3,*)
      REAL DENS(N1,N2,N3)
      REAL DENS_NEIB(3,3,3)
C
      INTEGER IX1,IY1,IZ1,IXO,IYO,IZO,IXO1,IYO1,IZO1
      INTEGER IX2,IY2,IZ2
      INTEGER I,J,K
      LOGICAL FLAG_CALL
C
C---Centre value is definitely is inside "asymmetric unit"
C
      IX2 = IX-2
      IY2 = IY-2
      IZ2 = IZ-2
      DO K=1,3
         IZ1 = IZ2+K
         IF(IZ1.LT.0) THEN
           IZ1 = IZ1 + NZ
         ELSE IF(IZ1.GE.NZ) THEN
           IZ1 = IZ1 - NZ
         ENDIF
         FLAG_CALL = IZ1.GE.N3
         IZO1 = IZ1 + 1
         DO  J=1,3
           IY1 = IY2+J
           IF(IY1.LT.0) THEN
             IY1 = IY1 + NY
           ELSEIF(IY1.GE.NY) THEN
             IY1 = IY1 - NY
           ENDIF
           FLAG_CALL = FLAG_CALL.OR.IY1.GE.N2
           IYO1 = IY1 + 1
           DO I = 1,3
             IX1 = IX2+I
             IF(IX1.LT.0) THEN
                IX1 = IX1 + NX
             ELSE IF(IX1.GE.NX) THEN
               IX1 = IX1 - NX
             ENDIF
             FLAG_CALL = FLAG_CALL.OR.IX1.GE.N1
             IXO1 = IX1 + 1
             IF(FLAG_CALL) THEN
              CALL FIND_POSITION_IN_ASYM(IX1,IY1,IZ1,NX,NY,NZ,N1,N2,N3,
     &             NumSymmetry,IROT_L,ITR_L,IXO,IYO,IZO)
                         IXO1 = IXO + 1
                         IYO1 = IYO + 1
                         IZO1 = IZO + 1
             ENDIF
             DENS_NEIB(K,J,I) = DENS(IXO1,IYO1,IZO1)
           ENDDO
         ENDDO
      ENDDO
C
      RETURN
      END
C
      SUBROUTINE FIND_POSITION_IN_ASYM(IX1,IY1,IZ1,NX,NY,NZ,N1,N2,N3,
     &             NumSymmetry,IROT_L,ITR_L,IXO,IYO,IZO)
      IMPLICIT NONE
C
C---  Finds position of the given point in the "asymmetric" unit.
      INTEGER IXO,IYO,IZO
      INTEGER IX1,IY1,IZ1,NX,NY,NZ,N1,N2,N3
      INTEGER NumSymmetry
      INTEGER IROT_L(3,3,*),ITR_L(3,*)
C
C
      INTEGER IS
      INTEGER IX11,IY11,IZ11,IX1N,IY1N,IZ1N
C
C---If point is in the "asymmetric" unit do nothing.

cd      IF(IX1.LT.0) GOTO 10
cd      IF(IX1.GE.N1) GOTO 10
cd      IF(IY1.LT.0) GOTO 10
cd      IF(IY1.GE.N2) GOTO 10
cd      IF(IZ1.LT.0) GOTO 10
cd      IF(IZ1.GE.N3) GOTO 10
cd     &   IY1.GE.0.AND.IY1.LE.N2.AND.
cd     &   IZ1.GE.0.AND.IZ1.LE.N3) THEN
cd        IXO = IX1
cd        IYO = IY1
cd        IZO = IZ1
cd        RETURN
cd 10     CONTINUE
C
cd      IX11 = MOD(IX1 + NX,NX)
cd      IY11 = MOD(IY1 + NY,NY)
cd      IZ11 = MOD(IZ1 + NZ,NZ)

cd      IF(IX11.GE.0.AND.IX11.LT.N1.AND.
cd     &   IY11.GE.0.AND.IY11.LT.N2.AND.
cd     &   IZ11.GE.0.AND.IZ11.LT.N3) THEN
cd        IXO = IX11
cd        IYO = IY11
cd        IZO = IZ11
cd        RETURN
cd      ENDIF
C
C--It assumes that first operator is identity.
      DO   IS = 2,NumSymmetry
        IX1N = IROT_L(1,1,IS)*IX1 + 
     &         IROT_L(1,2,IS)*IY1 + 
     &         IROT_L(1,3,IS)*IZ1 + ITR_L(1,IS)
cd        if(IX1N.LT.0) THEN
cd          IX1N = IX1N + NX
cd        ELSE IF(IX1N.GT.NX) THEN
cd          IX1N = IX1N - NX
cd        ENDIF
        IX1N = MOD(IX1N + NX,NX)
        IF(IX1N.GE.N1) GOTO 100
        IY1N = IROT_L(2,1,IS)*IX1 + 
     &         IROT_L(2,2,IS)*IY1 + 
     &         IROT_L(2,3,IS)*IZ1 + ITR_L(2,IS)
        IY1N = MOD(IY1N + NY,NY)
        IF(IY1N.GE.N2) GOTO 100
        IZ1N = IROT_L(3,1,IS)*IX1 + 
     &         IROT_L(3,2,IS)*IY1 + 
     &         IROT_L(3,3,IS)*IZ1 + ITR_L(3,IS)        
        IZ1N = MOD(IZ1N + NZ,NZ)
        IF(IZ1N.GE.N3) GOTO 100
        IXO = IX1N
        IYO = IY1N
        IZO = IZ1N
        RETURN
 100    CONTINUE
      ENDDO
C
C--If we have not returned yet then there is an error. Report it
      WRITE(*,*)N1,N2,N3,NX,NY,NZ
      WRITE(*,*)NumSymmetry,IX1,IY1,IZ1
      CALL errwrt(1,'in FIND_POSITION_IN_ASYM.')
      END
