C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
C
C  Subroutines to perform fast calculation of density, graident and
C  second derivatives (or elements of normal matrix)
C
C-----------------------------------------------------------------
      SUBROUTINE PROPI(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
c-----------------------------------------------------------------
C     ROUTINE TO CALL Subroutines which scales SFs and calculates
C     coefficients for fourie transformation to calculate gradients (and
C     hessian ) and agreement factors.
C -----------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
c-------------------------
      REAL    FC(*),PHASE(*),FO(*),SIGO(*),FREER(*)
      real    fwt(*)
      INTEGER NREF
      INTEGER NIND(*)
      LOGICAL MIR_SAVE,LEXP_SAVE
C-----------------------------------
      INTEGER N_ATOM1,IP,IA,NPART1
      LOGICAL SCALE_LS_PART_REFINE_FLAG_SAVE(NMAXPART),
     &        B_LS_PART_REFINE_FLAG_SAVE(NMAXPART)
      REAL B_LS_PART_SAVE(NMAXPART),SCALE_LS_PART_SAVE(NMAXPART),
     &       BOVER_ATOM,UISO_EQUAV,BOVER1,BAVER_CURRENT
      integer i
C
C---Some initialisations. If necessary
C
C---Here add some check if partial structure B etc should be refined
C---or fixed.
      BOVER_ATOM = 0.0
      IF(.NOT.LINIT) THEN
C
c--Use log scaling
        CALL LOG_SCALING(NREF,NIND,FO,SIGO,fwt,FC(1+NPART*NOBS),FREER)
C
C---Find initial values for LS scale factors. Here it is based on log
C---scaling or whatever comes from LOG_SCALING
        LINIT = .TRUE.
        B_LS_OVER0 = 0.0
        DO  IP=1,NPART
          B_LS_PART_REFINE_FLAG_SAVE(IP) = B_LS_PART_REFINE_FLAG(IP)
          B_LS_PART_REFINE_FLAG(IP) = .FALSE.
          SCALE_LS_PART_REFINE_FLAG_SAVE(IP) =  
     &           SCALE_LS_PART_REFINE_FLAG(IP)
C???? Check it again.
          SCALE_LS_PART_REFINE_FLAG(IP) = .FALSE.
          SCALE_LS_PART_SAVE(IP) = SCALE_LS_PART(IP)
          SCALE_LS_PART(IP) = 0.0
          B_LS_PART_SAVE(IP) = B_LS_PART(IP)
          B_LS_PART(IP) = 0.0
        ENDDO

        CALL LS_SCALING(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)

        DO   IP=1,NPART
          B_LS_PART_REFINE_FLAG(IP) = B_LS_PART_REFINE_FLAG_SAVE(IP)
          SCALE_LS_PART_REFINE_FLAG(IP) = 
     &              SCALE_LS_PART_REFINE_FLAG_SAVE(IP)
          SCALE_LS_PART(IP) = SCALE_LS_PART_SAVE(IP)
          B_LS_PART(IP) = B_LS_PART_SAVE(IP)
        ENDDO
       B_LS_ANISO_OVER_REFINE_FLAG = .FALSE.

      ELSE
        B_LS_OVER = 0.0
      ENDIF

      IF(ALL_SCALES_FLAG.AND.LS_SCALE_FLAG) 
     & CALL LS_SCALING(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)

      UOVER_ATOM = B_LS_OVER/PISQ8
c

      CALL LSQ_COEF(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
      IF(REFS.EQ.'LSQF')GOTO 500
      CALL APPLYSCALES(NREF,NIND,0,NPART1,FO,SIGO,FC)


C
      IF(REFS.EQ.'LSQI') THEN
C
C--Coefficietns for intensity based LSQ refinement
      ELSEIF(REFS.EQ.'MLKF') THEN
        IF(.NOT.MLINIT) THEN
          CALL DMLINIT_R(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
          MLINIT = .TRUE.
        ENDIF
        MIR_SAVE = MIR_FLAG
        USEWORK   = MLUSEWORK
        LEXP_SAVE = LEXPUSE
        LEXPUSE   = MLEXPUSE
        LEXPUSE   = .FALSE.
        IF(.NOT.PHASE_SIGMAA_FLAG)MIR_FLAG=.FALSE.
        IF(ALL_SCALES_FLAG.AND.ML_SCALE_FLAG) 
     &    CALL ML_SCALING(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
        NRESIOPT = 1 
        MIR_FLAG=MIR_SAVE
        LEXPUSE = LEXP_SAVE
        CALL ML1CF(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
      ENDIF
 500  CONTINUE
      LEXPUSE = LEXP_SAVE
      RETURN
      END
C
      SUBROUTINE PRINT_LS_SCALE
C
C---Prints parameters of scale factors.
      IMPLICIT NONE
C
      INCLUDE 'agreem.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INTEGER IP
      CHARACTER LINE*128
C
      IF(MON_STYLE.EQ.'NONE') RETURN
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
      WRITE(LINE,'(A,2(A,F8.3))')  'Overall               :'
     &          ,' scale = ',SCALE_LS_OVER,', B  =',B_LS_OVER
      CALL ERRWRT(-1,LINE)
      IF(BULK_LS_FLAG) THEN
        WRITE(LINE,'(A,2(A,F8.3))')'Babinet"s bulk solvent:'
     &          ,' scale = ',SCALE_LS_BULK,', B  =',B_LS_BULK
        CALL ERRWRT(-1,LINE)
      ENDIF
      DO   IP=1,NPART
        WRITE(LINE,'(A,I3,2(A,F8.3))')'Partial structure  ',IP,
     &        ': scale = ',SCALE_LS_PART(IP),', B  =', B_LS_PART(IP)
        CALL ERRWRT(-1,LINE)
      ENDDO
      IF(B_LS_ANISO_OVER_FLAG) THEN
        CALl ERRWRT(-1,'Overall anisotropic scale factors')
        WRITE(LINE,'(2X,6(A,F6.2))')' B11 =',B_LS_ANISO_OVER(1),
     &                             ' B22 =',B_LS_ANISO_OVER(2),
     &                             ' B33 =',B_LS_ANISO_OVER(3),
     &                             ' B12 =',B_LS_ANISO_OVER(4),
     &                             ' B13 =',B_LS_ANISO_OVER(5),
     &                             ' B23 =',B_LS_ANISO_OVER(6)
        CALL ERRWRT(-1,LINE)
      ENDIF
      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
      RETURN
      END
C
      SUBROUTINE PRINT_ML_SCALE
C
C---Prints parameters of scale factors.
      IMPLICIT NONE
C
      INCLUDE 'agreem.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INTEGER IP
      CHARACTER LINE*128
C
      IF(MON_STYLE.EQ.'NONE') RETURN
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,'----ML scale parameters---')
      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
      WRITE(LINE,'(A,2(A,F8.3))')  'Overall               :'
     &          ,' scale = ',D_ML_SCALE_OVER,', B  =',D_ML_B_OVER
      CALL ERRWRT(-1,LINE)
      IF(BULK_LS_FLAG) THEN
        WRITE(LINE,'(A,2(A,F8.3))')'Babinet"s bulk solvent:'
     &          ,' scale = ',D_ML_SCALE_BBULK,', B  =',D_ML_B_BBULK
        CALL ERRWRT(-1,LINE)
      ENDIF
      DO   IP=1,NPART
        WRITE(LINE,'(A,I3,2(A,F8.3))')'Partial structure  ',IP,
     &        ': scale = ',D_ML_SCALE_PART(IP),', B  =', D_ML_B_PART(IP)
        CALL ERRWRT(-1,LINE)
      ENDDO

      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
      RETURN
      END
C
      SUBROUTINE REPORT_XRAY_STATS
C
      IMPLICIT NONE
      INCLUDE 'rharvest.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
C
      INTEGER I,NB1,NREFT,IREST
      REAL Smean,ssss
      CHARACTER LINE*128,NC_LOC*30
      INTEGER LENSTR
      EXTERNAL LENSTR
C
      NB1 = NBIN+1
      IF(MON_STYLE.EQ.'NONE') RETURN
C
      CALL PRINT_LS_SCALE
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
C
      IF(NCYCLE_OVERALL.LT.NMAX_CYCLE) 
     &             NCYCLE_OVERALL = NCYCLE_OVERALL + 1
      WRITE(NC_LOC,'(A,I4)')'Cycle ',NCYCLE_OVERALL
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY') THEN
C
C---Stats over resolution. For loggraph
        CALL HEADER('Things for loggraph, R factor and others')
        CALL ERRWRT(-1,' ')
        IF(FREER_FLAG) THEN
        CALL ERRWRT(-1,
     &     '$TABLE: '//NC_LOC(1:LENSTR(NC_LOC))//
     &           '. Rfactor analysis, F distribution v resln  :')
        CALL ERRWRT(-1,'$GRAPHS:'//NC_LOC(1:LENSTR(NC_LOC))//
     &                  '. <Rfactor> v. resln :N:1,6,7,11,12:')
        CALL ERRWRT(-1,':'//NC_LOC(1:LENSTR(NC_LOC))//
     &             '. <Fobs> and <Fc> v. resln :N:1,4,5,9,10:')
        CALL ERRWRT(-1,':'//NC_LOC(1:LENSTR(NC_LOC))//
     &              '. % observed v. resln :N:1,3:')
        CALL ERRWRT(-1,'$$')
        CALL ERRWRT(-1,
     &'M(4SSQ/LL) NR_used %_obs M(Fo_used) M(Fc_used) Rf_used'//
     &' WR_used')
        CALL ERRWRT(-1,
     & 'NR_free M(Fo_free) M(Fc_free) Rf_free   WR_free $$')
        CALL ERRWRT(-1,'$$')
        DO    I=1,NBIN
          Smean =  2.0*(SMINB(I)**2 + SMAXB(I)**2)
          IF(HPERC_SHELL_REFL(I).GT.0.0) THEN
          WRITE(LINE,'(F6.3,I8,F7.2,2F8.1,2F6.2,I8,2F8.1,2F6.2)')
     &  Smean,HNREF_SHELL_WORK(I),HPERC_SHELL_REFL(I),AFO(1,I),AFC(1,I),
     &  HRFAC_SHELL_WORK(I),HWRFAC_SHELL_WORK(I),HNREF_SHELL_FREE(I),
     &  AFO(2,I),AFC(2,I),HRFAC_SHELL_FREE(I),HWRFAC_SHELL_FREE(I)
          CALL ERRWRT(-1,LINE)
          ENDIF
        ENDDO
        ELSE
        CALL ERRWRT(-1,
     &     '$TABLE: '//NC_LOC(1:LENSTR(NC_LOC))//
     &              '. Rfactor analysis, F distribution v resln  :')
        CALL ERRWRT(-1,'$GRAPHS:'//NC_LOC(1:LENSTR(NC_LOC))//
     &              '. M(Rfactor) v. resln :N:1,6,7:')
        CALL ERRWRT(-1,':'//NC_LOC(1:LENSTR(NC_LOC))//
     &              '. M(Fobs) and M(Fc) v. resln :N:1,4,5:')
        CALL ERRWRT(-1,':'//NC_LOC(1:LENSTR(NC_LOC))//
     &               '. % observed v. resln :N:1,3:')
        CALL ERRWRT(-1,'$$')
        CALL ERRWRT(-1,
     &'M(4SSQ/LL) NR_used %_obs M(Fo_used) M(Fc_used) Rf_used'//
     &' WR_used $$')
        CALL ERRWRT(-1,'$$')
        DO    I=1,NBIN
          Smean =  2.0*(SMINB(I)**2 + SMAXB(I)**2)
          IF(HPERC_SHELL_REFL(I).GT.0.0) THEN
          WRITE(LINE,'(F6.3,I8,F7.2,2F8.1,2F6.2)')
     &  Smean,HNREF_SHELL_WORK(I),HPERC_SHELL_REFL(I),AFO(1,I),AFC(1,I),
     &  HRFAC_SHELL_WORK(I),HWRFAC_SHELL_WORK(I)
          CALL ERRWRT(-1,LINE)
          ENDIF
        ENDDO
        ENDIF
C
        CALl ERRWRT(-1,'$$')
C
        CALL HEADER('Fom and SigmaA vs resolution')
        CALL ERRWRT(-1,
     +' $TABLE: '//NC_LOC(1:LENSTR(NC_LOC))//
     &   '. Fom(<cos(DelPhi)>-acentric, centric, overall v resln:')
        CALL ERRWRT(-1,' $GRAPHS:'//NC_LOC(1:LENSTR(NC_LOC))//
     &          '. M(Fom) v. resln :N:1,3,5,7,8:')
        CALL ERRWRT(-1,' $$')
        CALL ERRWRT(-1,
     +' <4SSQ/LL> NREFa  FOMa  NREFc FOMc NREFall FOMall  '//
     + 'SigmaA_Fc1 $$')
        CALL ERRWRT(-1,' $$')
c
        DO    I=1,NBIN
          Smean =  2.0*(SMINB(I)**2 + SMAXB(I)**2)
         IF(NSCOPT.EQ.1 .AND. NDPAR.GE.4)
     $  ssss = (1.0 + DMLPAR(NDPAR -1) * EXP(-DMLPAR(NDPAR)*Smean /4.0))
     $  * DMLPAR(NDPAR -3)*EXP(-DMLPAR(NDPAR -2)*Smean /4.0)
         IF(NSCOPT.EQ.0 .AND. NDPAR.GE.2)
     $   ssss =  DMLPAR(NDPAR -1) * EXP(-DMLPAR(NDPAR)*Smean /4.0)
          NREFT = NREFA(1,I)+NREFC(1,I)
         IF(NREFT.GT.0) THEN
           FOMAVT(1,I) = (FOMAVA(1,I)*NREFA(1,I)+
     +                           FOMAVC(1,I)*NREFC(1,I))/NREFT
         WRITE(LINE,'(f8.4,I6,F8.3,I6,F8.3,I6,F8.3,F7.3)')
     +    Smean,NREFA(1,I),FOMAVA(1,I),NREFC(1,I),FOMAVC(1,I),
     +      NREFT,FOMAVT(1,I),D_ML(1,I)
         CALL ERRWRT(-1,LINE)
         ENDIF
        ENDDO
        CALL ERRWRT(-1,' $$ ')

      ENDIF

C
C---Overall stats
      WRITE(LINE,'(A,2F10.3)')'Resolution limits                    = ',
     &                   HD_LOW,HD_HIGH
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,I10)')   'Number of used reflections           = ',
     &           HNREF_SHELL_WORK(NB1)
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Percentage observed                  = ',
     &   HPERC_SHELL_REFL(NB1)
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Percentage of free reflections       = ',
     &     PERC_FREE
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Overall R factor                     = ',
     &  RFACTOR_WORK
      CALL ERRWRT(-1,LINE)
      RFACTOR_VS_CYCLE(NCYCLE_OVERALL) = RFACTOR_WORK
cd      IF(LREFIN) THEN
      LLG_VS_CYCLE(NCYCLE_OVERALL)     = FXRAY
      LLGFREE_VS_CYCLE(NCYCLE_OVERALL)     = FXFREE

cd      ELSE
cd        IF(NCYCLE_OVERALL.GE.2) THEN
cd          LLG_VS_CYCLE(NCYCLE_OVERALL) = LLG_VS_CYCLE(NCYCLE_OVERALL-1)
cd        ELSE
cd          LLG_VS_CYCLE(NCYCLE_OVERALL) = 0.0
cd        ENDIF
cd      ENDIF
      WRITE(LINE,'(A,F10.4)') 'Free R factor                        = ',
     &  RFACTOR_FREE
      IF(RFACTOR_FREE.GT.0.0) THEN
        CALL ERRWRT(-1,LINE)
        RFREE_VS_CYCLE(NCYCLE_OVERALL) = RFACTOR_FREE
      ENDIF
      
      WRITE(LINE,'(A,F10.4)') 'Overall weighted R factor            = ',
     &   RWFACTOR_WORK
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Free weighted R factor               = ',
     &   RWFACTOR_FREE
      IF((MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY').AND.
     &      RWFACTOR_FREE.GT.0.0) CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Overall correlation coefficient      = ',
     &   HCORR_FOFC
      IF(MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Free correlation coefficient         = ',
     &   HCORR_FOFC_FREE
      IF((MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY').AND.
     &    HCORR_FOFC_FREE.GT.-1.0)CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'Cruickshanks DPI for coordinate error= ',
     &   HESU_CRUIC
      IF((MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY').AND.
     &    HESU_CRUIC.GT.0.0) CALL ERRWRT(-1,LINE)
      WRITE(LINE,'(A,F10.4)') 'DPI based on free R factor           = ',
     &   HESU_FREE
      IF((MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY').AND.
     &      HESU_FREE.GT.0.0)CALL ERRWRT(-1,LINE)
      IF(REFS.EQ.'MLKF') THEN
      WRITE(LINE,'(A,F10.4)') 'Overall figure of merit              = ',
     &     FOMOVERT(1)
      CALL ERRWRT(-1,LINE)
      FOM_VS_CYCLE(NCYCLE_OVERALL) = FOMOVERT(1)
C
      IF((MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY').AND.
     &  HESU_ML.GT.0.0) THEN
      WRITE(LINE,'(A,F10.4)') 'ML based su of positional parameters = ',
     &     HESU_ML
      CALL ERRWRT(-1,LINE)
      ENDIF
      IF((MON_STYLE.EQ.'MEDI'.OR.MON_STYLE.EQ.'MANY').AND.
     &  HESU_ML_B.GT.0.0) THEN
      WRITE(LINE,'(A,F10.4)') 'ML based su of thermal parameters    = ',
     &     HESU_ML_B
        CALL ERRWRT(-1,LINE)
      ENDIF

      ENDIF
      CALL ERRWRT(-1,
     &'--------------------------------------------------------------'
     &//'---------------')
C
C---Add geometry if there is any.
      IF(HNRESTR.GT.0) THEN
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Bond distances: refined atoms')THEN
      BOND_VS_CYCLE(NCYCLE_OVERALL) = HRESTR_DEV(IREST)
      ZBOND_VS_CYCLE(NCYCLE_OVERALL) = HRESTR_Z(IREST)

      ENDIF
      ENDDO
C
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Bond angles  : refined atoms')THEN
        ANGLE_VS_CYCLE(NCYCLE_OVERALL) = HRESTR_DEV(IREST)
        ZANGLE_VS_CYCLE(NCYCLE_OVERALL) = HRESTR_Z(IREST)

      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Chiral centres: refined atoms')THEN
       CHIR_VS_CYCLE(NCYCLE_OVERALL) = HRESTR_DEV(IREST)
      ENDIF
      ENDDO    
      ENDIF
      
      RETURN
      END
C
      
      SUBROUTINE ADD_PARTIAL(NREF,FC,PHASE)
C-----------------------------------------------------------
C    SUBROUTINE adds partial structure factor to previous list.
C-----------------------------------------------------------
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'const.fh'
      INCLUDE 'solvent.fh'
      REAL FC(*),PHASE(*)
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
      REAL HLA,HLB,HLC,HLD
c---------------------------------------------------------
      REAL FPP(NMAXPART),APP(NMAXPART)
      CHARACTER SCRATCH_FILE*256,REFSCR_1*256
      LOGICAL LEXISTS
      INTEGER LENSTR
      EXTERNAL LENSTR
      EXTERNAL PACK
C---------------------------------------------------------
      IREF=1
      NFRR=0
C---------------------------------------------------------
      I = 0
      NPARTALL   = NPARTALL_SAVE
      NPART      = NPART_SAVE
      FPART_FLAG = FPART_FLAG_SAVE
      DO    IP=1,NPARTALL
        ILSCALTYP(IP) = ILSCALTYP_SAVE(IP)
        ISCPART(IP)   = ISCPART_SAVE(IP)       
      ENDDO
      ISCRF = IFSCR_SAVE
      REWIND ISCRF
      call find_unique_file_name(refscr_1,'_REFSCR_1')
      inquire(file=refscr_1,exist=lexists)
      if(lexists) close(unit=iscrf0,status='DELETE')
      call open_unform_file(iscrf0,refscr_1,ifail)

100   CONTINUE 
      FPP(NPARTALL+1) = FC(iREF)
      APP(NPARTALL+1) = PHASE(iREF)*RTODEG
      IF(FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL+1)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL+1),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL+1)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL+1),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(FREER_FLAG.AND..NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL+1)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +           ,HLA,HLB,HLC,HLD
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +           (FPP(IP),APP(IP),IP=1,NPARTALL+1),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL+1)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +          ,HLA,HLB,HLC,HLD
         WRITE(ISCRF0,ERR=499)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +           (FPP(IP),APP(IP),IP=1,NPARTALL+1),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(iREF.GE.NOBS) 
     +  CALL ERRWRT(1,'RDIND: Number of reflections more than expected')
      iREF = iREF+1
      GOTO 100
499   CONTINUE
      CALL REFMAC_CLEAN_UP_FILES 
      CALL errwrt(1,'READ Scratch file of reflections')
500   CONTINUE
c
      ISCRF      = ISCRF0
      FPART_FLAG = .TRUE.
      NPARTALL   = NPARTALL + 1
      NPART      = NPART  + 1
      ISCPART(NPARTALL) = 1
      ILSCALTYP(NPART+1) = ILSCALTYP(NPART)
c---  SOLVENT_FLAG = .FALSE.
c---  B_LS_BULK = 400.0
c---  B_LS_BULK_REFINE_FLAG = .FALSE.
      RETURN
      END
C
      SUBROUTINE READ_INDICES(NREF,NIND)
C-----------------------------------------------------------
C    SUBROUTINE READS INDEXES H,K,L AND SAVES PACKED INDEXES IN
C                      NIND ARRAY
C    Added:  Reads saves Fo and SIGF also (GNM)
C-----------------------------------------------------------
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INTEGER NIND(*)
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN

      REAL HLA,HLB,HLC,HLD
c---------------------------------------------------------
      REAL FPP(NMAXPART),APP(NMAXPART)
      EXTERNAL PACK
C---------------------------------------------------------
      NREF=0
      NFRR=0
C---------------------------------------------------------
      I = 0
      REWIND ISCRF
100   CONTINUE 

      IF(FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(FREER_FLAG.AND..NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +           ,HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +          ,HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      NREF=NREF+1
      IF(NREF.GE.NOBS) 
     +  CALL ERRWRT(1,'RDIND: Number of reflections more than expected')
      CALL PACK(IND,IH,IK,IL)
      NIND(NREF) = IND
      GOTO 100
499   CONTINUE
      CALL REFMAC_CLEAN_UP_FILES 
      CALL errwrt(1,'READ Scratch file of reflections')
500   CONTINUE
c
      RETURN
      END
C
      SUBROUTINE RDIND(NREF,FO,SIGO,FREER,NIND)
C-----------------------------------------------------------
C    SUBROUTINE READS INDEXES H,K,L AND SAVES PACKED INDEXES IN
C                      NIND ARRAY
C    Added:  Reads saves Fo and SIGF also (GNM)
C-----------------------------------------------------------
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INTEGER NIND(*)
      REAL FO(*),SIGO(*),FREER(*)
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN

      REAL HLA,HLB,HLC,HLD
c---------------------------------------------------------
      REAL FPP(NMAXPART),APP(NMAXPART)
      EXTERNAL PACK
C---------------------------------------------------------
      NREF=0
      NFRR=0
C---------------------------------------------------------
      I = 0
      REWIND ISCRF
100   CONTINUE 

      IF(FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(FREER_FLAG.AND..NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +           ,HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +          ,HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      NREF=NREF+1
      IF(NREF.GE.NOBS) 
     +  CALL ERRWRT(1,'RDIND: Number of reflections more than expected')
      CALL PACK(IND,IH,IK,IL)
      NIND(NREF) = IND
      FO(NREF)   = YO
      SIGO(NREF) = SIGYOA
      IF(FREER_FLAG)FREER(NREF) = FRR
      IF(FREER_FLAG )THEN 
        IF( ABS(FREER(NREF) - LFreeRexcludeVal) .LT.0.01)NFRR = NFRR + 1
      END IF
      GOTO 100
499   CONTINUE
      CALL REFMAC_CLEAN_UP_FILES 
      CALL errwrt(1,'READ Scratch file of reflections')
500   CONTINUE
c
      RETURN
      END
C
      SUBROUTINE RDIND1(NREF,FO,SIGO,FREER,FC,PHASE,NIND)
C-----------------------------------------------------------
C    SUBROUTINE READS INDEXES H,K,L AND SAVES PACKED INDEXES IN
C                      NIND ARRAY
C    Added:  Reads saves Fo and SIGF also (GNM)
C-----------------------------------------------------------
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'const.fh'
      INTEGER NIND(*)
      REAL    FO(*),SIGO(*),FREER(*),FC(*),PHASE(*)
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
      REAL HLA,HLB,HLC,HLD
      REAL FPP(NMAXPART),APP(NMAXPART)
      EXTERNAL PACK
C
C---First change position of phases
      IF(NREF.GT.NOBS) 
     +  CALL ERRWRT(1,'RDIN1: Number of reflections more than expected')
      DO    IR=1,NREF
        IPOS        = IR+NPART*NOBS
        FCC         = FC(IR)
        PHICC       = PHASE(IR)
        FC(IPOS)    = FCC*COS(PHICC)
        PHASE(IPOS) = FCC*SIN(PHICC)
      ENDDO
C 
      IREF = 0
      NFRR=0
      REWIND ISCRF
100   CONTINUE 

      IF(FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +           ,HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +          ,HLA,HLB,HLC,HLD
        ENDIF
      ENDIF
      IREF=IREF+1
      IF(IREF.GT.NOBS) 
     +  CALL ERRWRT(1,'RDIN1: Number of reflections more than expected')
      CALL PACK(IND,IH,IK,IL)
      NIND(IREF) = IND
      FO(IREF)   = YO
      SIGO(IREF) = SIGYOA
      IF(FREER_FLAG)FREER(IREF) = FRR
      ICPOS = IREF + NPART*NOBS
      IF(FPART_FLAG) THEN
         IP1 = 0
         DO   IP=1,NPARTALL
           IF(ISCPART(IP).EQ.0) THEN
             FC(ICPOS)    = FC(ICPOS)   +FPP(IP)*COS(APP(IP)*DEGTOR)
             PHASE(ICPOS) = PHASE(ICPOS)+FPP(IP)*SIN(APP(IP)*DEGTOR)
           ELSE

             IP1          = IP1 + 1
             IPOS         = IREF+(IP1-1)*NOBS
             FC(IPOS)     = FPP(IP)
             PHASE(IPOS)  = APP(IP)*DEGTOR

           ENDIF
         ENDDO
      ENDIF
      IF(MIR_FLAG) THEN
        IPOS         = (NPART+1)*NOBS + IREF
        PHASE(IPOS)  = HLA
        IPOS         = IPOS + NOBS
        PHASE(IPOS)  = HLB
        IPOS         = IPOS + NOBS
        PHASE(IPOS)  = HLC
        IPOS         = IPOS + NOBS
        PHASE(IPOS)  = HLD
      ENDIF

      Ftemp = SQRT(ABS(FC(ICPOS)**2+PHASE(ICPOS)**2))
      Ptemp = 0.0
      IF(Ftemp.NE.0.0) Ptemp = ATAN2(PHASE(ICPOS),FC(ICPOS))
      FC(ICPOS)    = Ftemp
      PHASE(ICPOS) = Ptemp
      IF(FREER_FLAG )THEN 
        IF( ABS(FREER(IREF) - LFreeRexcludeVal) .LT.0.01)NFRR = NFRR + 1
      END IF
      GOTO 100
499   CALL ERRWRT(1,'READ Scratch file of reflections')
500   CONTINUE
      RETURN
      END

      SUBROUTINE RDSORT(LIND)
C-----------------------------------------------------------
C    SUBROUTINE READS INDEXES H,K,L AND SAVES PACKED INDEXES IN
C                      NIND ARRAY
C    Added:  Reads old sorting order (GNM)
C-----------------------------------------------------------
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INTEGER LIND(*)
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN

      REAL HLA,HLB,HLC,HLD
c---------------------------------------------------------
      REAL FPP(NMAXPART),APP(NMAXPART)
C---------------------------------------------------------
      NREF=0
C---------------------------------------------------------
      I = 0
      REWIND ISCRF

100   CONTINUE 

      IF(FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL)
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL,
     +   (FPP(IP),APP(IP),IP=1,NPARTALL),HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,FRR,LL
     +           ,HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      IF(.NOT.FREER_FLAG.AND. .NOT.FPART_FLAG) THEN
        IF(.NOT.MIR_FLAG) THEN
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
        ELSE
         READ(ISCRF,ERR=499,END=500)IH,IK,IL,STHOL,YO,SIGYOA,LL
     +          ,HLA,HLB,HLC,HLD
        ENDIF
      ENDIF

      NREF=NREF+1
      LL1 = IABS(LL)
      LIND(LL1) = NREF
      IF(LL.LE.0) LIND(LL1) = -NREF
      GOTO 100
499   CONTINUE
      CALL REFMAC_CLEAN_UP_FILES 
      CALL errwrt(1,'READ Scratch file of reflections')
500   CONTINUE
      RETURN
      END
C
      subroutine read_foweights(nref,fo_map,sigo_map,fwt)
      implicit none
      include 'restr_files.fh'
      integer nref
      real fo_map(nref),sigo_map(nref),fwt(nref)

      integer i
      integer ifail,ll,iunit
c

      if(fomap_file(1:1).eq.' ') then
         do i=1,nref
            fwt(i) = 1.0
         enddo
         return
      endif
      call open_unform_file(iunit,fomap_file,ifail)
      do i=1,nref
         read(iunit)fo_map(i),sigo_map(i),fwt(i)
      enddo
      close(iunit)
      return
      end
c
      SUBROUTINE LOG_SCALING(NREF,NIND,FO,SIGO,fwt,FC,FREER)
c
c------Program for log scaling observed and calculated structure
c------factors. Scale factor will be applied to observed and 
c------temperature factor to calculated structure factors
C------
      IMPLICIT NONE
      INCLUDE 'celsym.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'const.fh'
      REAL FO(*),SIGO(*),FC(*),FREER(*)
      real fwt(*)
      INTEGER NREF
      INTEGER NIND(*)

C-----------------------------------------------------------
c
c----Local variables
      INTEGER  I,IH1,IH2,IH3
      REAL     RSQ,RHO,DF(2),DF2(2,2),SHIFTS(2),WORKSPACE(25)
      LOGICAL  TESTFREE1,TESTFREE2
      REAL     LSTLSQ,YC,TOLER
      EXTERNAL LSTLSQ,UNPACK
C
C----SCFOFC - TO MINIMIZE SUM(S*FO-exp(-Bc*rs^2)FC)**2
C
C----Log scaling
      TOLER    = 1.0E-8
      DF(1)    = 0.0
      DF(2)    = 0.0
      DF2(1,1) = 0.0
      DF2(1,2) = 0.0
      DF2(2,1) = 0.0
      DF2(2,2) = 0.0
C
C--Initial scale
      DO     I=1,NREF
        TESTFREE1 = .FALSE.
        TESTFREE2 = .TRUE.
        IF(SIGO(I).GT.0.0 .AND.FO(I).GT.0.0 .AND.FC(I).GT.0.00) 
     +        TESTFREE1 = .TRUE.
        IF(FREER_FLAG) THEN
          IF (ABS(FREER(I) - LFreeRexcludeVal) .LT.0.1 )
     +           TESTFREE2 = .FALSE.
        END IF
        IF(TESTFREE1  .AND. TESTFREE2 .and. fwt(i).gt.0.0 ) THEN
          CALL UNPACK(NIND(I),IH1,IH2,IH3)
          RSQ =  LSTLSQ(1,IH1,IH2,IH3)
          RHO = SQRT(RSQ)
          IF(RHO.GE.SMINS.AND.RHO.LE.SMAXS) THEN
            YC       = FC(I)
            DF(1)    = DF(1)    - fwt(i)*(LOG(FO(I)) - LOG(FC(I)))
            DF(2)    = DF(2)    + fwt(i)*(LOG(FO(I)) - LOG(FC(I)))*RSQ 
            DF2(1,1) = DF2(1,1) + fwt(i)
            DF2(1,2) = DF2(1,2) - fwt(i)*RSQ
            DF2(2,2) = DF2(2,2) + fwt(i)*RSQ*RSQ
          ENDIF
        ENDIF
      ENDDO
      DF2(2,1) = DF2(1,2)
      CALL EIGEN_FILTER_R(TOLER,DF2,2,2,DF,SHIFTS,WORKSPACE,25)
      SCALE_LS_OVER = EXP(-SHIFTS(1))
      B_LS_OVER     = -SHIFTS(2)
C
      RETURN
      END
C
      SUBROUTINE REDALLI(N1,N2,N3,NX,NY,NZ,ROTIN,TRIN,NSYMIN,DEN)
C-------------------------------------------------
C--This routine reduces electron density to the asymmetric unit 
C--   *******  SPACE GROUP GENERAL  *******
C--------------------------------------------------
      IMPLICIT NONE
      INTEGER N1,N2,N3,NX,NY,NZ,NSYMIN
      REAL    DEN(N1,N2,N3)
      REAL ROTIN(3,3,*),TRIN(3,*)
c
c----192 is maximum number of possible symmetries.
      INTEGER IX,IY,IZ,IX1,IY1,IZ1,IXN,IYN,IZN,I,J,IS,N31,N21,N11,NMULT
      INTEGER NX22,NY22,NZ22
      INTEGER IROT(3,3,192),ITR(3,192)
      INTEGER IXN1(192),IYN1(192),IZN1(192),
     +        IXN2(192),IYN2(192),IZN2(192)

C----------------------------------------------------------
      DO     IS = 1,NSYMIN
         DO   I=1,3
         DO   J=1,3
            IROT(I,J,IS) = NINT(ROTIN(I,J,IS))
         ENDDO
         ENDDO
         ITR(1,IS) = NINT(TRIN(1,IS)*NX)
         ITR(2,IS) = NINT(TRIN(2,IS)*NY)
         ITR(3,IS) = NINT(TRIN(3,IS)*NZ)
      ENDDO
C
      N31=N3-1
      N21=N2-1
      N11=N1-1
      NX22 = NX*2
      NY22 = NY*2
      NZ22 = NZ*2
      DO     IZ=0,N31
        IZ1 = IZ + 1
        DO     I=2,NSYMIN
          IXN1(I) = IROT(1,3,I)*IZ+ITR(1,I)
          IYN1(I) = IROT(2,3,I)*IZ+ITR(2,I)
          IZN1(I) = IROT(3,3,I)*IZ+ITR(3,I)
        ENDDO 
        DO     IY=0,N21
          IY1 = IY + 1
          DO     I=2,NSYMIN
            IXN2(I) = IROT(1,2,I)*IY+IXN1(I)
            IYN2(I) = IROT(2,2,I)*IY+IYN1(I)
            IZN2(I) = IROT(3,2,I)*IY+IZN1(I)
          ENDDO 
          DO     IX=0,N11
            IX1   = IX + 1
            IF(DEN(IX1,IY1,IZ1).EQ.0.0) GOTO 201
            NMULT = 1
            DO     I=2,NSYMIN
C---------------------------------------------------------------------
              IZN = IROT(3,1,I)*IX+IZN2(I)
              IF(IZN.LT.0) THEN 
                IZN = IZN + NZ
              ELSE IF(IZN.GE.NZ) THEN
                IZN = IZN - NZ
              ENDIF
              
cd              IZN = MOD(IZN,NZ)
              IF(IZN.GT.N31) GOTO 160
              IF(IZN.LT.IZ) GOTO 140
              IF(IZN.GT.IZ) GOTO 160

              IYN = IROT(2,1,I)*IX+IYN2(I)
              IF(IYN.LT.0) THEN
                IYN = IYN + NY
              ELSE IF(IYN.GE.NY) THEN
                IYN = IYN - NY
              ENDIF
cd              IYN = MOD(IYN,NY)
              IF(IYN.GT.N21) GOTO 160 
              IF(IYN.LT.IY) GOTO 140
              IF(IYN.GT.IY) GOTO 160

              IXN = IROT(1,1,I)*IX+IXN2(I)
              IF(IXN.LT.0) THEN
                IXN = IXN + NX
              ELSE IF(IXN.GE.NY) THEN
                IXN = IXN - NX
              ENDIF
cd              IXN = MOD(IXN,NX)
              IF(IXN.GT.N11) GOTO 160
              IF(IXN.LT.IX) GOTO 140
              IF(IXN.GT.IX) THEN
                GOTO 160
              ELSE
                NMULT = NMULT + 1
                GOTO 160
              ENDIF
C
 140          CONTINUE
              DEN(IX1,IY1,IZ1) = 0.0
              GOTO 200
160           CONTINUE
            ENDDO
200         CONTINUE
            DEN(IX1,IY1,IZ1) = DEN(IX1,IY1,IZ1)/NMULT
 201        CONTINUE
          ENDDO
        ENDDO
      ENDDO
C----------------------------------------------------
      END
C
C-----------------------------------------------------------------
C
C---Subroutines for modelling electron density from atomic model,
C---gradient and diagonal terms of second deivative matrix using 
C---electron density
C
      SUBROUTINE DENSTY(DEN)
C
C---This subroutine call ELDEN to add to electron density distribution
C---contribution from atoms with isotropic B-values and ELDEN_ANISO 
C---to add contribution of ansiotropic atoms
C
      INCLUDE 'celsym.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'atom_com.fh'
      REAL DEN(N1,N2,N3)

C
      DO  I3=1,N3
        DO  I2=1,N2
          DO  I1=1,N1
            DEN(I1,I2,I3)=0.0
          ENDDO
        ENDDO
      ENDDO
C
C---Add contributions of isotropic atoms
C

      CALL ELDEN(DEN)
C
C---Anisotropic contribution should be added here
        CALL ELDEN_ANISO(DEN)
C
c      DO  I3=1,N3
c        DO  I2=1,N2
c          DO  I1=1,N1
c            write(*,*)DEN(I1,I2,I3)
c          ENDDO
c        ENDDO
c      ENDDO
c      stop
      RETURN
      END
C
      SUBROUTINE ELDEN(DEN)
C-----------------------------------------------------------------
C---------           SPACE GROUP GENERAL
C---This subroutine calculates electron density from atoms and fills
C---"asymmetric" unit of crystals. Displacement parameters are as U
C---values
C-------------------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
C
      REAL   DEN(N1,N2,N3)
C
C---Local variables
      REAL*8   GAUSS(10001)
      REAL    XA_LIST(3,500)
      INTEGER INDSYM_LIST(500)
      REAL*8    CL1(5),BL1(5)
      real XYZ(3)
      real*8 fac
      LOGICAL ERROR
C
C----Find extension limits for asymmetric unit
      CALL ASYMLIM_FRAC(DDLIM,XLOW,YLOW,ZLOW,XUPPER,YUPPER,ZUPPER)
      SX     = CS_CELL(1)/NX
      SY     = CS_CELL(2)/NY
      SZ     = CS_CELL(3)/NZ
      COSAST = (COSA-COSB*COSG)/(SING*SING)
      DLIMIT = DDLIM
C
C---Perhaps it should be calculated only once
      DO  I=1,5000
        GAUSS(I) = EXP(-.002d0*I+.002d0)
      ENDDO
      GAUSS(5001) = 0.0d0
      CSA2        = 2.0*COSA
      CSB2        = 2.0*COSB
      CSG2        = 2.0*COSG
C ---
      D22 = SX*SY*SZ*COSZ*SING/(TWOPI)**1.5
C
C----Loop over all atoms
      NX50 = 50*NX
      NY50 = 50*NY
      NZ50 = 50*NZ
      DO     IA=1,N_ATOM
        IA1 = ATOM_REF_FLAG(IA)/10
        IA11 = ATOM_REF_FLAG(IA)-IA1*10
        IF(IA11.LE.1)   GOTO 500
        IF(U_ANISO(2,IA).NE.0.0) goto 500
c.OR.OCCUP(IA).LE.0.0)  GOTO 500
C
C---If atom has isotropic U values

C
C---Add NCS here
        IL   = ID_SF(IA)
        D238 = OCCUP(IA)*D22
        IL1  = CS_NELEC(IL)
        U11  = 2.0*U_ANISO(1,IA)
        IF(IL1.GT.16)U11=AMAX1(U11,0.38)
        UL   = 0.70+U11
cd        IF(IL1.EQ.1)UL = 0.38+U11
        DLIM1= DLIMIT 
        D1   = DLIM1*UL
        U11  = U_ANISO(1,IA)
        DO    IG=1,5
           FBANDU  = CS_B(IG,IL)/PISQ8 + U11
           BL1(IG) = 250.0/FBANDU
           CL1(IG) = D238*CS_A(IG,IL)*FBANDU**(-1.5)
        ENDDO
C
C---List of all atoms contributing to asymmetric unit
        CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ,ERROR)
        CALL ATLIST1(XYZ,XA_list,XLOW,YLOW,ZLOW,XUPPER,YUPPER,
     +       ZUPPER,INDSYM_LIST,NATOM_LIST)
C
C----Loop over list of atoms which contribute to "asymmetric" unit
        DO    ILIST=1,NATOM_LIST
          X1 = XA_list(1,ILIST)*CS_CELL(1)
          Y1 = XA_list(2,ILIST)*CS_CELL(2)
          Z1 = XA_list(3,ILIST)*CS_CELL(3)
          XC = X1/SX
          YC = Y1/SY
          ZC = Z1/SZ
C
          RADZ = SQRT(D1)/(SZ*COSZ)
          SZL  = ZC - RADZ
          SZU  = ZC + RADZ
          ISZL = INT(SZL+501.0)
          ISZU = INT(SZU+500.0)
          DO      IZ1 = ISZL,ISZU
             IZ  = IZ1 - 500
             IZ2 = MOD(IZ+NZ50,NZ) + 1
             IF(IZ2.GT.N3)GO TO 300
             DZ  = IZ*SZ - Z1
             DZO = DZ*RO_UNIT(3,3)
             DZO2= DZO*DZO
             D2  = DZ*DZ
             D7  = D1 - DZO2
             IF (D7.LT.0.0)GO TO 300
             RADY   = SQRT(D7)/(SY*SING)
             ZCOSA  = DZ*COSAST/SY
             SYL    = YC - RADY - ZCOSA
             SYU    = YC + RADY - ZCOSA
             ISYL   = INT(SYL+501.0)
             ISYU   = INT(SYU+500.0)
             DZCSA2 = DZ*CSA2
             DZROX  = DZ*RO_UNIT(1,3)
             DZROY  = RO_UNIT(2,3)*DZ
             DZCSB  = DZ*COSB
             DO     IY1 = ISYL,ISYU
               IY  = IY1-500
               IY2 = MOD(IY+NY50,NY)+1
C---CHECK FOR IY2 WITHIN ASYMMETRIC UNIT
               IF(IY2.GT.N2)GO TO 290
               DY     = IY*SY-Y1
               DYO    = DY*RO_UNIT(2,2) + DZROY
               DYO2   = DYO*DYO
               DYZ    = D2+(DZCSA2+DY)*DY
               DXMIN  =-DY*COSG-DZCSB
               DSQMIN = DYZ - DXMIN**2
               D4     = D1 - DSQMIN
               IF(D4.LT.0.0) GOTO 290
               RADX     = SQRT(D4)/(SX*SING)
               XDELTA   = DXMIN/SX
               SXL      = XC - RADX + XDELTA
               SXU      = XC + RADX + XDELTA
               ISXL     = INT(SXL+501.0)
               ISXU     = INT(SXU+500.0)
               DYZROX   = DY*RO_UNIT(1,2) + DZROX
               DXO2PYO2 = DYO2 + DZO2
               
               DO      IX1 = ISXL,ISXU
                 IX   = IX1 - 500
                 IX2  = MOD(IX+NX50,NX)+1
C---CHECK FOR IX2 WITHIN ASYMMETRIC UNIT
                 IF(IX2.GT.N1)GO TO 280
                 DX   = IX*SX-X1
                 DXO  = DX*RO_UNIT(1,1) + DYZROX
                 DXO2 = DXO*DXO
                 DSQ  = DXO2 + DXO2PYO2
                 IF(DSQ.GT.D1)GO TO 280
                 FAC  = 0.0D0
                 DO   IG=1,NGAUS
                   DSQ1 = DSQ*BL1(IG)+1.0
                   ID31 = MIN1(DSQ1,5001.1)
                   FAC  = FAC + CL1(IG)*GAUSS(ID31)
                 ENDDO
                 DEN(IX2,IY2,IZ2)=DEN(IX2,IY2,IZ2)+FAC
 280             CONTINUE
              ENDDO
 290          CONTINUE
            ENDDO
 300        CONTINUE
          ENDDO
        ENDDO
 500    CONTINUE
      ENDDO
      RETURN
      END
C
      SUBROUTINE ATLIST1(XFRAC_input,XA_list,XLOW,YLOW,ZLOW,
     +                   XUPPER,YUPPER,ZUPPER,INDSYM_list,NATOM_list)
      INCLUDE 'celsym.fh'
      INCLUDE 'vitals.fh'
C
C----Finds list of atoms which has something to do with enlarged 
C----asymmetric unit after application of symmetry operations.
C----Could be used for atoms with isotropic B-values
C
      REAL    XFRAC_input(3)
      REAL    XA_list(3,*)
      INTEGER INDSYM_list(*)
C----------------------------------------------------------------
C-----Input 
C-----
C----- XFRAC_input,
C----- YFRAC_input,
C----- ZFRAC_input  positional paramters of atoms in fractional 
C-----              coordinates
C----- XLOW,
C----- YLOW,
C----- ZLOW,
C----- XUPPER,
C----- YUPPER,
C----- ZUPPER       lower and upper limits of asymmetric unit for 
C-----              enlarging (in fractional coordiates)
C-----
C-----Output
C-----
C----- Xa_list      list of coordinates 
C----- INDSYM_list  corresponding symmetry operation
C----- NATOM_list   number of atoms in the list 
C-----
C---------------------------------------------------------------
      NATOM_list = 0
      DO    ISYM=1,NumSymmetry
        XT = RealSymmMatrx(1,1,ISYM)*XFRAC_input(1) + 
     +       RealSymmMatrx(1,2,ISYM)*XFRAC_input(2) +
     +       RealSymmMatrx(1,3,ISYM)*XFRAC_input(3) + 
     +       RealSymmMatrx(1,4,ISYM)

        YT = RealSymmMatrx(2,1,ISYM)*XFRAC_input(1) + 
     +       RealSymmMatrx(2,2,ISYM)*XFRAC_input(2) +
     +       RealSymmMatrx(2,3,ISYM)*XFRAC_input(3) + 
     +       RealSymmMatrx(2,4,ISYM)

        ZT = RealSymmMatrx(3,1,ISYM)*XFRAC_input(1) + 
     +       RealSymmMatrx(3,2,ISYM)*XFRAC_input(2) +
     +       RealSymmMatrx(3,3,ISYM)*XFRAC_input(3) +  
     +       RealSymmMatrx(3,4,ISYM)
C
C---Check if atom is inside enlarged asymmetric unit
20      IF(XT.LT.XLOW)GO TO 21
        XT = XT - 1.0
        GO TO 20
21      XT = XT + 1.0
        IF(XT.LT.XLOW) GO TO 21
30      IF(YT.LT.YLOW) GO TO 31
        YT = YT - 1.0
        GO TO 30
31      YT = YT + 1.0
        IF(YT.LT.YLOW)GO TO 31
40      IF(ZT.LT.ZLOW)GO TO 41
        ZT = ZT - 1.0
        GO TO 40
41      ZT = ZT + 1.0
        IF(ZT.LT.ZLOW)GO TO 41
        IF(XT.GT.XUPPER)GO TO 90
        IF(YT.GT.YUPPER)GO TO 90
        IF(ZT.GT.ZUPPER)GO TO 90
C
C---Atom is inside enlarged asymmetric unit. Store its coordinates and
C---symmetry operation by which this atom came into asymmetric unit
        NATOM_list              = NATOM_list + 1
        XA_list(1,NATOM_list)   = XT
        XA_list(2,NATOM_list)   = YT
        XA_list(3,NATOM_list)   = ZT
        INDSYM_list(NATOM_list) = ISYM
90      CONTINUE
      ENDDO
      RETURN
      END

      SUBROUTINE ASYMLIM_FRAC(DLIM,XLOWER_F,YLOWER_F,ZLOWER_F,XUPPER_F,
     +                         YUPPER_F,ZUPPER_F)
C
C---Gives limits for enlarging of asymetric unit by given DLIM defined
C---in angstroms. Takes into account cell angles
      INCLUDE 'atom_com.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
C
C----Limit of asymmetric unit. (In fact it is not asymmetric unit in all
C----cases. It is minimum box containing asymmetric unit)
      XMIN = 0.0
      YMIN = 0.0
      ZMIN = 0.0
      XMAX = CS_CELL(1)/IPX
      YMAX = CS_CELL(2)/IPY
      ZMAX = CS_CELL(3)/IPZ

      DLM    = SQRT(DLIM*60.0)/TWOPI
C
C---Limits of enlarged asymmetric unit in angstroms
      V        = SQRT(1.-COSA*COSA-COSB*COSB-COSG*COSG+2*COSA*COSB*COSG)
      XLOWER_A = XMIN-DLM*SINA/V
      YLOWER_A = YMIN-DLM*SINB/V
      ZLOWER_A = ZMIN-DLM*SING/V
      XUPPER_A = XMAX+DLM*SINA/V
      YUPPER_A = YMAX+DLM*SINB/V
      ZUPPER_A = ZMAX+DLM*SING/V
C
C---Limits of enlarged asymmetric unit in fractional coordinates
      XLOWER_F = XLOWER_A/CS_CELL(1)
      XUPPER_F = XUPPER_A/CS_CELL(1)
      YLOWER_F = YLOWER_A/CS_CELL(2)
      YUPPER_F = YUPPER_A/CS_CELL(2)
      ZLOWER_F = ZLOWER_A/CS_CELL(3)
      ZUPPER_F = ZUPPER_A/CS_CELL(3)

      RETURN
      END
C
C-----Block for gardient calculation
C
      SUBROUTINE GRAD_ALL(DEN,GX,GU1,GQ)
C
C----This subroutine calls GRAD and GRAD_ANISO to calculate gradients
C----for isotropic and anisotropic atoms
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'vitals.fh'
      REAL DEN(N1,N2,N3),GX(*),GU1(*),GQ(*)
      DATA ZERO/0.0/
C
C----Initialise. Perhaps it should be done before this routine
      CALL INIT_VEC(3*N_ATOM,GX,ZERO)
      CALL INIT_VEC(6*N_ATOM,GU1,ZERO)
      CALL INIT_VEC(N_ATOM,GQ,ZERO)
 
      CALL GRAD(DEN,GX,GU1,GQ)
C
C-----Gradients for anisotropic atoms
      CALL GRAD_ANISO(DEN,GX,GU1,GQ)
C
      RETURN
      END
C
      SUBROUTINE GRAD(DEN,GX,GU,GQ)
C-----------------------------------------------------------------
C--------         SPACE GROUP GENEREAL              ------------------
C---Calculates gradients on asymmetric unit
C--------------------------------------------------------------------
C
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
C
      REAL   GX(*),GU(*),GQ(*)
      REAL   DEN(N1,N2,N3)
      REAL*8   GAUSS(5001)
C
C---Local variables
      REAL    XA_LIST(3,500)
      INTEGER INDSYM_LIST(500)
      REAL    BL1(5),BL11(5),BB1(5),CL1(5),XYZ_FRAC(3),GXP(3),
     +        GXP1(3),GXP2(3)
      real*8 cc1(5)
      real*8 gxx,gyy,gzz,guu,gqq
      LOGICAL ERROR
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
C-    THERE ARE REDUNDANT POINTS ON  THE ASYMMETRIC UNIT.  THE
C-    DENSITY AT THESE POINTS IS SET EQUAL TO ZERO.
C- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
      CALL REDALLI(N1,N2,N3,NX,NY,NZ,ROT,TR,NumSymmetry,DEN)
C
C----Find extension limits for asymmetric unit
      CALL ASYMLIM_FRAC(DGLIM,XLOW,YLOW,ZLOW,XUPPER,YUPPER,ZUPPER)
      SX     = CS_CELL(1)/NX
      SY     = CS_CELL(2)/NY
      SZ     = CS_CELL(3)/NZ
      COSAST = (COSA-COSB*COSG)/(SING*SING)
      DO    I=1,5000
         GAUSS(I) = EXP(-.002d0*I+.002d0)
      ENDDO
      GAUSS(5001) = 0.0d0
      NX50        = 50*NX
      NY50        = 50*NY
      NZ50        = 50*NZ
      CSA2        = 2.0*COSA
C-------------------------------------------------------------------
      D22 = CS_CELL(1)*CS_CELL(2)*CS_CELL(3)*COSZ*SING/(TWOPI)**1.5
      IT  = 1
      IXT = 1
      IQ  = 1
      DO    IA=1,N_ATOM
C----Case 1. Atom is dummy. Do not calculate gradients. And there is no
C----chance that there will be any contribution for this atom even from
C----for example geometry
        IA1 = ATOM_REF_FLAG(IA)/10
        IA11 = ATOM_REF_FLAG(IA)-IA1*10
        IF(IA1.LE.0) GOTO 500
C
C----Case 2. Atom will not have contribution from x-ray. But it might have
C----contribution from some other sources for example geometry.
        IF(IA11.LE.2.OR.U_ANISO(2,IA).NE.0.0) GOTO 498
C
C---Add NCS here
        D238 = D22*OCCUP(IA)
        IL   = ID_SF(IA)
        IL1  = CS_NELEC(IL)
        DLIM = DGLIM
        IF(IL1.EQ.1)DLIM=3.5
        U11 = 2.0*U_ANISO(1,IA)
        IF(IL1.GT.16) U11 = AMAX1(U11,0.6)
        RADSQ = DLIM*(U11+0.70)
        RAD   = SQRT(RADSQ)
        U11   = U_ANISO(1,IA)
        DO    IG=1,5
          FBANDU   = CS_B(IG,IL)/PISQ8 + U11
          BL1(IG)  =               1.0/FBANDU
          BL11(IG) =               0.5/FBANDU**2
          BB1(IG)  =               1.5/FBANDU
          CL1(IG)  =   D238*CS_A(IG,IL)*FBANDU**(-1.5)
          CC1(IG)  =    D22*CS_A(IG,IL)*FBANDU**(-1.5)
        ENDDO
          RADZ    = RAD/(COSZ)
C
C---Find all symmetry related atoms which might contribute to gradient
cd        CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ_FRAC,ERROR)
        CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,IA),XYZ_FRAC,ERROR)
        CALL ATLIST1(XYZ_FRAC,XA_list,XLOW,YLOW,ZLOW,XUPPER,YUPPER,
     +              ZUPPER,INDSYM_LIST,NATOM_LIST)

        DO   ILIST=1,NATOM_LIST
C
C----Loop over all symmetry related atoms which contribute to gradient
          GXX = 0.0d0
          GYY = 0.0d0
          GZZ = 0.0d0
          guu = 0.0d0
          gqq = 0.0d0
          ISYM    = INDSYM_LIST(ILIST)
          X1      = XA_list(1,ILIST)*CS_CELL(1)
          Y1      = XA_list(2,ILIST)*CS_CELL(2)
          Z1      = XA_list(3,ILIST)*CS_CELL(3)
          ZL      = Z1 - RADZ
          ZU      = Z1 + RADZ
          IZL     = INT(ZL/SZ + 501.)
          IZU     = INT(ZU/SZ + 500.)
          NPOINTS = 0
          DO 300 IZ1=IZL,IZU
            IZ  = IZ1 - 500
            IZ2 = MOD(IZ+NZ50,NZ)+1
            IF(IZ2.GT.N3)GO TO 300
            DZ   = IZ*SZ - Z1
            DZO  = DZ*RO_UNIT(3,3)
            DZO2 = DZO*DZO
            DZZ  = DZ*DZ
            D7   = RADSQ - DZO2
            IF (D7.LT.0.0)GO TO 300
            RADY   = SQRT(D7)/SING
            Y1P    = Y1  - DZ*COSAST
            YL     = Y1P - RADY
            YU     = Y1P + RADY
            IYL    = INT(YL/SY+501.)
            IYU    = INT(YU/SY+500.)
            IF(IYU.LT.IYL)GO TO 300
            DZROX  = DZ*RO_UNIT(1,3)
            DZROY  = DZ*RO_UNIT(2,3)
            DZCSA2 = DZ*CSA2
            DZCSB  = DZ*COSB
            DO 290 IY1=IYL,IYU
              IY  = IY1-500
              IY2 = MOD(IY+NY50,NY)+1
C---CHECK FOR IY2 WITHIN ASYMMETRIC UNIT
              IF(IY2.GT.N2)GO TO 290
              DY    = IY*SY-Y1
              DXMIN =-DY*COSG-DZCSB
              DYZ1  = DZZ + DY*(DZCSA2 + DY)
              D4    = RADSQ - DYZ1 + DXMIN**2
              IF (D4.LT.0.0)GO TO 290
              RADX   = SQRT(D4)/SING
              X1P    = X1  + DXMIN
              XL     = X1P - RADX
              XU     = X1P + RADX
              IXL    = INT(XL/SX+501.)
              IXU    = INT(XU/SX+500.)
              IF(IXU.LT.IXL)GO TO 290
              DYO   = DY*RO_UNIT(2,2) + DZROY
              DYO2  = DYO*DYO
              DYZROX   = DY*RO_UNIT(1,2) + DZROX
              DYO2PZO2 = DYO2 + DZO2
              DO 280 IX1=IXL,IXU
                IX  = IX1-500
C---CHECK FOR IX2 WITHIN ASYMMETRIC UNIT
                IX2 = MOD(IX+NX50,NX)+1
                IF(IX2.GT.N1)GO TO 280
                DD  = DEN(IX2,IY2,IZ2)
                IF(DD.EQ.0.0) GOTO 280
C--------------------------------------
                DX   = IX*SX-X1
                DXO  = DX*RO_UNIT(1,1) + DYZROX
                DXO2 = DXO*DXO
                DSQ  = DXO2 + DYO2PZO2
                IF(DSQ.GT.RADSQ)GO TO 280
                DSQ1 = DSQ*250.0
                D44  = 0.0
                D55  = 0.0
                DCC  = 0.0
                NPNT = 0
                DO   IG=1,5
                  DSQ2=DSQ1*BL1(IG)+1.0
                  ID31=MIN1(DSQ2,5001.1)
                  IF(ID31.LT.5001) THEN
                    D31 = CL1(IG)*GAUSS(ID31)
                    D44 = D44 + D31*BL1(IG)
                    D55 = D55 + D31*(BL11(IG)*DSQ-BB1(IG))
                    DCC = DCC + CC1(IG)*GAUSS(ID31)
                    NPNT = NPNT + 1
                  ENDIF
                ENDDO
                IF(NPNT.GT.0) THEN
                  D44    = D44*DD
                  GXX    = GXX    + DXO*D44
                  GYY    = GYY    + DYO*D44
                  GZZ    = GZZ    + DZO*D44
                  guu    = guu + d55*dd
                  gqq    = gqq + dcc*dd
c                  GU(IT) = GU(IT) + D55*DD
c                  GQ(IQ) = GQ(IQ) + DCC*DD
                ENDIF
                NPOINTS = NPOINTS + NPNT
280           CONTINUE
290         CONTINUE
300       CONTINUE
          IF(NPOINTS.GT.0) THEN
            GXP(1) = GXX 
            GXP(2) = GYY
            GXP(3) = GZZ
            IF(ISYM.GT.1) THEN
              CALL MAT2VECT(3,3,CS_FRAC_TO_ORT,GXP,GXP1,ERROR)
              CALL MAT2VECT(3,3,ROT(1,1,ISYM),GXP1,GXP2,ERROR)
              CALL MAT2VECT(3,3,CS_ORT_TO_FRAC,GXP2,GXP,ERROR)
            ENDIF
            GX(IXT  ) = GX(IXT  ) + GXP(1)
            GX(IXT+1) = GX(IXT+1) + GXP(2)
            GX(IXT+2) = GX(IXT+2) + GXP(3)
            gu(it)    = gu(it) + guu
            gq(iq)    = gq(iq) + gqq
          ENDIF
        ENDDO
 498    CONTINUE
        IF(U_ANISO(2,IA).EQ.0.0) THEN
          IT  = IT  + 1
        ELSE
          IT  = IT + 6
        ENDIF
        IXT = IXT + 3
        IQ  = IQ + 1
 500    CONTINUE
      ENDDO
      RETURN
      END
C
      SUBROUTINE HDIAG_R(NREF,NIND,FO,HXX,HUU,HQQ,HQU)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
      INCLUDE 'rharvest.fh'
C
      INTEGER NREF
      INTEGER NIND(*)
      REAL FO(*),HXX(*),HUU(*),HQQ(*),HQU(*)
C
      INTEGER I,IG,IA,N_SAMPLE,IXT,IQ,IU,IA1,IA11,I_INTER,IM,IU_CUR,
     &        ISYSAB,IHH(3),IREF,ICENT,N_REFINED,IQU
      real stl_c
      REAL U_MAX,U_MIN,U_CUR,DELTA_U,ZERO,HUU1,HQQ1,HXX1,
     &     HQU1,CC0,CC2,CC4,CC5,
     &     DGAUS,C1111,C1212,C1122,EPSI,RSQ,HDC_S0,HDC_S2,U_CUR1,
     &     HDC_S4,HUU1111,HUU1122,HUU1212,FOURPISQ,YO,OCCUP2
      REAL GAUSS(20001),HD_S0(1000),HD_S2(1000),HD_S4(1000),
     &     U_SAMPLE(1000)
      real*8 d2df_weight
      REAL LSTLSQ,DPIML1,DPIML2,CONST_LOC
      EXTERNAL LSTLSQ,UNPACK
C
C--Initialisation
      i_inter = -1
      DPIML1 = 0.0
      DPIML2 = 0.0
      ZERO = 0.0
      CALL INIT_VEC(6*N_ATOM,HXX,ZERO)
      CALL INIT_VEC(21*N_ATOM,HUU,ZERO)
      CALL INIT_VEC(N_ATOM,HQQ,ZERO)
      CALL INIT_VEC(6*N_ATOM,HQU,ZERO)
C
C---Find minimum and maximum U including formfactor Us
      U_MAX = -1.0E32
      U_MIN =  1.0E32
      DO   IA=1,N_ATOM
        IA1 = ATOM_REF_FLAG(IA)/10
        IA11 = ATOM_REF_FLAG(IA)-IA1*10
        IM   = ID_SF(IA)
        IF(IA11.GT.2) THEN
          IF(U_ANISO(2,IA).EQ.0.0) THEN
            U_CUR = U_ANISO(1,IA)
          ELSE
            U_CUR = (U_ANISO(1,IA)+U_ANISO(2,IA)+U_ANISO(3,IA))/3.0
          ENDIF
          DO   IG=1,NGAUS
            U_CUR1 = U_CUR + CS_B(IG,IM)/PISQ8
            U_MAX = AMAX1(U_MAX,U_CUR1)
            U_MIN = AMIN1(U_MIN,U_CUR1)
          ENDDO
        ENDIF
      ENDDO
C
C---Multiply by 4*PI**2
      FOURPISQ = 16.0*PI*PI
      U_MIN    = U_MIN*FOURPISQ - 0.001
      U_MAX    = U_MAX*FOURPISQ + 0.001

C
C---Tabulate exponential values. It should be done once. This part
C---is used very often so should be done in the beginning of the program
C--
      DO   I = 1,20000
        GAUSS(I) = EXP(-0.001*I+0.001)
      ENDDO
      GAUSS(20001) = 0.0
C
C----Find sample points for U values. 
      DELTA_U = AMAX1(1.0,(U_MAX-U_MIN)/500.0)
      U_SAMPLE(1) = U_MIN
      N_SAMPLE = 601
      DO   I=2,601
        U_SAMPLE(I) = U_SAMPLE(I-1) + DELTA_U
        IF(U_SAMPLE(I).GT.U_MAX) THEN
          N_SAMPLE = I
          GOTO 10
        ENDIF
      ENDDO
 10   CONTINUE
      CALL INIT_VEC(N_SAMPLE,HD_S0,ZERO)
      CALL INIT_VEC(N_SAMPLE,HD_S2,ZERO)
      CALL INIT_VEC(N_SAMPLE,HD_S4,ZERO)
C
c---Loop over all reflections to calculate values at the sample points
      DO    IREF=1,NREF
        CALL UNPACK(NIND(IREF),IHH(1),IHH(2),IHH(3))
        RSQ  =  LSTLSQ(1,IHH(1),IHH(2),IHH(3))
        CALL EPSLON(IHH,EPSI,ISYSAB)
        CALL CENTR(IHH,ICENT)
C
        STL_C = 2.0*SQRT(RSQ)
cd        YO = D2DF_WEIGHT(STL_C,I_INTER)/(EPSI*REAL(ICENT+1))
        YO  = FO(IREF)*(EPSI*REAL(ICENT+1))/float(nsmult)
cd        YO  = 2.0*FO(IREF)**2*(FLOAT(ICENT+1)*EPSI)
cd        yo = yo/nsmult
        CC0 = YO
        CC2 = 4.0*YO*RSQ
        CC4 = 4.0*CC2*RSQ
C
C---For each sample points calculate contributors for
C---derivatives wrt occupancy, xyz and u values.
        DO   I=1,N_SAMPLE
          IU_CUR   = MIN(INT(U_SAMPLE(I)*RSQ*1000.0),20000)
          DGAUS    = GAUSS(IU_CUR+1)
          HD_S0(I) = HD_S0(I) + CC0*DGAUS
          HD_S2(I) = HD_S2(I) + CC2*DGAUS
          HD_S4(I) = HD_S4(I) + CC4*DGAUS
        ENDDO
      ENDDO
c
C---Now we have second deriv approximation at the sample points.
C---Approximate diagonal elements for second derivatives
C
C--first calculate necessary constants
      CC0      = 2.0*REAL(NumSymmetry)
cd*NSMULT)
      CC2      = CC0*TWOPI**2/3.0
      CC4      = CC0*4.0*PI**4
      CC5      = CC0*2.0*PI**2
C     CC6      = CC0

C     C1111    = 13.0/60.0
      C1111    = 1.0/5.0
      C1212    = 4.0/15.0
C     C1212    = 7.0/30.0
C     C1122    = 7.0/120.0
      C1122    = 4.0/60.0

cd      DO   I=1,N_SAMPLE
cd        WRITE(*,*)U_SAMPLE(I)/2.0,1.0/(8.0*SQRT(CC2*HD_S2(I)))*PISQ8
cd      ENDDO
cd      STOP
cd      C1122 = 0.0
C
C---Loop over atoms
      IQ  = 1
      IXT = 1
      IU  = 1
      IQU = 1
      N_REFINED = 0
      I_INTER = -1
      DO   IA=1,N_ATOM
        IA1  = ATOM_REF_FLAG(IA)/10
        IA11 = ATOM_REF_FLAG(IA)-IA1*10
        IF(IA11.GE.1) THEN
          IF(IA11.LE.2) THEN
            IF(U_ANISO(2,IA).EQ.0.0) THEN
             IU  = IU  + 1
            ELSE
             IU  = IU + 21
            ENDIF
            IXT = IXT + 6
            IQ  = IQ  + 1
          ELSE
            N_REFINED = N_REFINED + 1
            IM     = ID_SF(IA)
            OCCUP2 = OCCUP(IA)*OCCUP(IA)
            IF(U_ANISO(2,IA).EQ.0.0) THEN
              U_CUR = U_ANISO(1,IA)
            ELSE
              U_CUR = (U_ANISO(1,IA)+U_ANISO(2,IA)+U_ANISO(3,IA))/3.0
            ENDIF
            U_CUR = U_CUR*FOURPISQ
            HUU1 = 0.0
            HXX1 = 0.0
            HQQ1 = 0.0
            DO   IG=1,NGAUS2
              U_CUR1 = U_CUR+CS_BB(IG,IM)       
C
C--Find values for HD_S0 and so on
              CALL  LINTER_VALUE2(N_SAMPLE,U_SAMPLE,HD_S0,U_CUR1,
     &                              I_INTER,HDC_S0)
              CALL  LINTER_VALUE2(N_SAMPLE,U_SAMPLE,HD_S2,U_CUR1,
     &                              I_INTER,HDC_S2)
              CALL  LINTER_VALUE2(N_SAMPLE,U_SAMPLE,HD_S4,U_CUR1,
     &                              I_INTER,HDC_S4)
              HXX1 = HXX1 + CS_AA(IG,IM)*HDC_S2
              HQQ1 = HQQ1 + CS_AA(IG,IM)*HDC_S0
              HUU1 = HUU1 + CS_AA(IG,IM)*HDC_S4
            ENDDO
            HQQ(IQ)    = HQQ1*CC0
            HQU1       = OCCUP(IA)*HXX1*CC5
            HXX1       = OCCUP2*HXX1*CC2
            HUU1       = OCCUP2*HUU1*CC4
            HXX(IXT  ) = HXX1
            HXX(IXT+1) = HXX1
            HXX(IXT+2) = HXX1
            DPIML1     = DPIML1 + HXX1
            DPIML2     = DPIML2 + HUU1
            IF(U_ANISO(2,IA).EQ.0.0) THEN
              HUU(IU)  = HUU1
              IU       = IU + 1
C
             HQU(IQU)  = HQU1
             IQU       = IQU + 1
            ELSE
              HUU1111    = HUU1*C1111
              HUU1212    = HUU1*C1212
              HUU1122    = HUU1*C1122
              HUU(IU  )  = HUU1111
              HUU(IU+1)  = HUU1111
              HUU(IU+2)  = HUU1111

              HUU(IU+3)  = HUU1212
              HUU(IU+4)  = HUU1212
              HUU(IU+5)  = HUU1212

              HUU(IU+6)  = HUU1122
              HUU(IU+7)  = HUU1122
              HUU(IU+11) = HUU1122
              IU         = IU + 21
C
              HQU(IQU)   = HQU1/3.0
              HQU(IQU+1) = HQU(IQU) 
              HQU(IQU+2) = HQU(IQU) 
              IQU        = IQU + 6
            ENDIF
            IXT = IXT + 6
            IQ  = IQ  + 1
          ENDIF
        ENDIF 
      ENDDO
cd      DO   IQ = 1,10
cd         WRITE(*,*)HQQ(IQ)
cd      ENDDO
cd      STOP
      CONST_LOC = REAL(2.0*N_REFINED)
      HESU_ML   = SQRT(CONST_LOC/DPIML1)
      HESU_ML_B = PISQ8*SQRT(CONST_LOC/DPIML2)
      
      RETURN
      END
C
      SUBROUTINE XGEOMADD(FX,FG,FT,WX,WG,qqm,qqv,AM_G,V_G,GX,GU,GQ,
     +                    IERROR)
      IMPLICIT NONE
C
C---Subroutine to add X-ray and geom part of gradients and hessians
C---We assume that geometric part is in AM and V
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'tls.fh'
      
      INTEGER LWORK,IERROR,IA,N_TARGET,N_OBJECT,NW_UVAL,I1,I2,ID,
     &        NSYM_DIST(4,QQD)
      REAL FX,FG,FT,WX,WG
      integer qqm,qqv
      REAL   AM_G(qqm),V_G(qqv),GX(*),GU(*),GQ(*)
      REAL   H_XXD,H_UUD(3),H_UQD,H_QQD
      REAL H_XX(3,3),H_UU(6,6),H_QQ,H_XB(3),H_XU(3,6),H_XQ(3),H_QX(3),  
     &     H_BQ,H_QB,H_UQ(6),H_QU(6)
      CHARACTER LINE*128 
      COMMON /DISTNS/ N_OBJECT( QQD),N_TARGET( QQD),NW_UVAL( QQD),
     &                NSYM_DIST
      INTEGER NMAXU,IMX,IMX1,IMG,IA1,IA11,LM,LXG,LXM,LXMX,IPOSX,IPOSU,
     &        NMMAXU,I,IA2,IA12,IA21,IA22
      INTEGER COUNT_UP,J
      REAL XNX,XNB,GNX,GNB,GEOMDIAG,XRAYDIAG,RXTOGEOM,XTOGX,COSANGL,
     &     BTOGB,FX1,SCXR1
      INTEGER IAN
      REAL USAVE1(6),USAVE2(6),TEMP
C
cd      REAL HXX(6*MAXATOM),HUU(21*MAXATOM),HQQ(MAXATOM),HQU(6*MAXATOM)
cd      COMMON /REF_SEC/HXX,HUU,HQQ,HQU
C
      REAL DOT_R
      EXTERNAL DOT_R
c
      integer, allocatable :: u_hist(:)
C
C----Positional paramaters
      allocate(u_hist(n_atom))
      IF(.NOT.HCALC) GOTO 100
      SCALXRAY = 1.0
      xnx = 0.0
      IF(X_RAY_FLAG) THEN
        IF(NVPOS.GT.0)
     +           XNX = SQRT(ABS(DOT_R(NVPOS,QQV,GX,GX))/REAL(NVPOS))
c
c---ADPs
        IF(ITEMP.NE.0) THEN
          IF(NVTMP.GT.0) THEN
             NMAXU = QQV-NVPOS
             XNB = SQRT(ABS(DOT_R(NVTMP,NMAXU,GU,GU))/FLOAT(NVTMP))
          ENDIF
c
c---Occupancies
        ENDIF
      ENDIF
      gnx = 0.0
      IF(GEOM_FLAG) THEN
        GNX = SQRT(ABS(DOT_R(NVPOS,QQV,V_G(1),V_G(1)))/FLOAT(NVPOS))
        IF(ITEMP.NE.0) THEN
          NMAXU = QQV-NVPOS
          GNB = SQRT(ABS(DOT_R(NVTMP,NMAXU,V_G(NVPOS+1),
     +                                   V_G(NVPOS+1)))/FLOAT(NVTMP))
        ENDIF
      ENDIF
      SCALXRAY = 1.0
C
C---Find relative weights using trace of second derivative matrix

      IF((WEIGHT.EQ.'MATR'.OR.WEIGHT.EQ.'AUTO').AND.REFID.EQ.'REST')THEN
        GEOMDIAG = 0.0
        XRAYDIAG = 0.0
        IMX      = 0
        IMX1     = 0
        IMG = 0
C
c---Find traces of x-ray and geomtric second derivatives
        DO    IA=1,N_ATOM
          IA1 = ATOM_REF_FLAG(IA)/10
          IA11 = ATOM_REF_FLAG(IA)-IA1*10
          IF(IA11.GT.2) THEN
c            CALL CALC_DIAG(XYZ_CRD(1,IA),HX_CALC,,,,)
            GEOMDIAG = GEOMDIAG+AM_G(IMX+1)+AM_G(IMX+2)+AM_G(IMX+3)
            CALL FAST_HESSIAN_DIAGONAL(IA,H_XXD,H_UUD,H_UQD,H_QQD)
            XRAYDIAG = XRAYDIAG+3*H_XXD
cd            XRAYDIAG = XRAYDIAG + HXX(IMX1+1)+HXX(IMX1+2)+HXX(IMX1+3)
            IMX      = IMX + 6
            IMX1     = IMX1 + 6
            IMG      = IMG + 3
          ELSEIF(IA11.GT.0) THEN
             IMX  = IMX + 6
             IMX1 = IMX1 + 6
             IMG  = IMG + 3
          ENDIF
        ENDDO
        RXTOGEOM = 0.0
        IF(XRAYDIAG.NE.0.0)  RXTOGEOM = GEOMDIAG/XRAYDIAG
        IF(WEIGHT.EQ.'MATR') THEN
          SCALXRAY = RXTOGEOM*WEIGHTXMAT
        ELSEIF(WEIGHT.EQ.'AUTO') THEN
          SCALXRAY =  WEIGHTAUTO
        ENDIF
        IF(SCALXRAY.LT.0.0) SCALXRAY = 0.0
        if(geomdiag.le.0) then
           write(*,*)'weight matrix ',0.0
        else
           write(*,*)'weigth matrix ',xraydiag/geomdiag*scalxray
        endif

c       SCALXRAY = 10.0
      ELSEIF(WEIGHT.EQ.'GRAD'.AND.REFID.EQ.'REST') THEN
C
C---Weight using gradient.
C>IJT
        IF(XNX.LE.0.0) THEN
          RXTOGEOM = 10./WEIGHTXMAT
        ELSE
          RXTOGEOM = GNX/XNX
        ENDIF
        SCALXRAY = RXTOGEOM*WEIGHTXMAT
C<IJT
      ENDIF
 100  CONTINUE
C
C---Monitor norm of gradients and so on
      FT = SCALXRAY*FX + FG
      IF(MON_STYLE.NE.'NONE') THEN
        IF(X_RAY_FLAG) THEN
          XNX = XNX*SCALXRAY
          WRITE(LINE,'(A,G15.3)')
     +              'Norm of X_ray positional gradient         ',XNX
          IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
        ENDIF
        IF(GEOM_FLAG) THEN
          WRITE(LINE,'(A,G15.3)')
     +              'Norm of Geom. positional gradient         ',GNX
          IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
        ENDIF
        IF(ITEMP.NE.0) THEN 
          IF(X_RAY_FLAG) THEN
            XNB = XNB*SCALXRAY
            WRITE(LINE,'(A,G15.3)')
     +              'Norm of X_ray B-factor gradient           ',XNB
            IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
          ENDIF
          IF(GEOM_FLAG) THEN
            WRITE(LINE,'(A,G15.3)')
     +              'Norm of Geom. B-factor gradient           ',GNB
            IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
          ENDIF
        ENDIF
        IF(GEOM_FLAG.AND.X_RAY_FLAG) THEN
          XTOGX = SCALXRAY*DOT_R(NVPOS,QQV,GX,V_G(1))
          COSANGL = 0.0
          IF(ABS(GNX).NE.0.0.AND.ABS(XNX).NE.0.0) 
     +                COSANGL = XTOGX/(GNX*XNX*FLOAT(NVPOS))
          WRITE(LINE, '(A,G15.3)')
     +              'Product of X_ray and Geom posit. gradients',XTOGX
          IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)   
          WRITE(LINE, '(A,F15.3)')
     +              ' Cosine of angle between them             ',COSANGL
          IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
          IF(ITEMP.NE.0) THEN
            BTOGB   =  SCALXRAY*DOT_R(NVTMP,QQV,GU,V_G(NVPOS+1))
            COSANGL = 0.0
            IF(ABS(GNB).NE.0.0.AND.ABS(XNB).NE.0.0)
     +        COSANGL = BTOGB/(GNB*XNB*NVTMP)
            WRITE(LINE, '(A,G15.3)')
     +              'Product of X_ray and Geom B-fact gradients',BTOGB
            IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
            WRITE(LINE, '(A,F15.3)')
     +              ' Cosine of angle between them             ',COSANGL
            IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
          ENDIF
          CALL ERRWRT(-1,' ')
          CALL ERRWRT(-1,' ')
          IF(GEOM_FLAG.AND.X_RAY_FLAG) THEN
            FX1 = SCALXRAY*FX
            WRITE(LINE,'(A,G15.4,A,G15.4,A,G15.4)')
     +       'Residuals: XRAY=',FX1,' GEOM=',FG,' TOTAL=',FT
          ELSEIF(.NOT.GEOM_FLAG .AND. X_RAY_FLAG) THEN
            WRITE(LINE,'(A,G15.4,A,G15.4,A,G15.4)')
     +           'Residuals: XRAY=',FX
          ELSEIF(GEOM_FLAG .AND. .NOT.X_RAY_FLAG) THEN
            WRITE(LINE,'(A,G15.4,A,G15.4,A,G15.4)')
     +           'Residuals: GEOM=',FG
          ENDIF
          IF(MON_STYLE.EQ.'MANY')CALL ERRWRT(-1,LINE)
        ENDIF
      ENDIF
      IF(.NOT.X_RAY_FLAG) RETURN
C
C---These things should be precalculated
      LM    = NMPOS + 9*NDIS + 1
      LXG   = 1
      LXM   = 1
      LXMX  = 1
      SCXR1 = 0.0
      IF(GEOM_FLAG) SCXR1 = SCALXRAY
cd      scalxray = 0.0
*
      CALL ADD_TLS2DERIVS(GX,GU)
*
C
      CALL AVECPVEC_R(NVPOS,QQV,SCALXRAY,GX(1),V_G(1),V_G(1),IERROR)
c
      IPOSX = 0
      IPOSU = LM-1
      DO   IA=1,N_ATOM
        IF(ATOM_REF_FLAG(IA).GT.0) THEN
C
C---Add hessian elements if atoms are to be refined against X-ray also.
          IA1  = ATOM_REF_FLAG(IA)/10
          IA11 = ATOM_REF_FLAG(IA)-IA1*10
          IF(IA11.GE.3) THEN
C---------save
            DO  IAN=1,6
              USAVE1(IAN) = U_ANISO(IAN,IA)
            ENDDO
            IF(U_ANISO(2,IA).GT.0.0.AND.UANISO_OLD(2,IA).LE.0.0) THEN
              TEMP = (U_ANISO(1,IA)+U_ANISO(2,IA) + U_ANISO(3,IA))/3.0
              DO  IAN=1,6
                U_ANISO(IAN,IA) = 0.0
              ENDDO
              U_ANISO(1,IA) = TEMP
            ENDIF
c----------end of save
            CALL FAST_HESSIAN_DIAGONAL(IA,H_XXD,H_UUD,H_UQD,H_QQD)

            AM_G(IPOSX+1) = AM_G(IPOSX+1) + SCALXRAY*H_XXD
            AM_G(IPOSX+2) = AM_G(IPOSX+2) + SCALXRAY*H_XXD
            AM_G(IPOSX+3) = AM_G(IPOSX+3) + SCALXRAY*H_XXD
            IPOSX = IPOSX + 6
            IF(ITEMP.NE.0) THEN
              IF(U_ANISO(2,IA).LE.0.0) THEN
C-------------isotropic
                AM_G(IPOSU+1) = AM_G(IPOSU+1) + SCALXRAY*H_UUD(1)
                IPOSU = IPOSU + 1
              ELSE
C-------------anisotropic
C
                AM_G(IPOSU+1)  = AM_G(IPOSU+1)  + SCALXRAY*H_UUD(1)
                AM_G(IPOSU+2)  = AM_G(IPOSU+2)  + SCALXRAY*H_UUD(1)
                AM_G(IPOSU+3)  = AM_G(IPOSU+3)  + SCALXRAY*H_UUD(1)
                AM_G(IPOSU+4)  = AM_G(IPOSU+4)  + SCALXRAY*H_UUD(3)
                AM_G(IPOSU+5)  = AM_G(IPOSU+5)  + SCALXRAY*H_UUD(3)
                AM_G(IPOSU+6)  = AM_G(IPOSU+6)  + SCALXRAY*H_UUD(3)
                AM_G(IPOSU+7)  = AM_G(IPOSU+7 ) + SCALXRAY*H_UUD(2)
                AM_G(IPOSU+8)  = AM_G(IPOSU+8 ) + SCALXRAY*H_UUD(2)
                AM_G(IPOSU+12) = AM_G(IPOSU+12) + SCALXRAY*H_UUD(2)
                IPOSU = IPOSU + 21
              ENDIF
            ENDIF
C---------restore
            DO  IAN = 1,6
               U_ANISO(IAN,IA) = USAVE1(IAN)
            ENDDO
c---------end of restore
          ELSE
            IPOSX = IPOSX + 6
            IF(UANISO_OLD(2,IA).LE.0.0) IPOSU = IPOSU + 1
            IF(UANISO_OLD(2,IA).GT.0.0) IPOSU = IPOSU + 21
          ENDIF
        ENDIF
      ENDDO
      IF(XNONDIAG_FLAG) THEN
C
C---Find positions of U values in the diagonal of hessian
        COUNT_UP = NMPOS + 9*NDIS
        IA1 = 0
        DO   IA=1,N_ATOM
          IF(ATOM_REF_FLAG(IA).GT.0) THEN
            IA1 = IA1 + 1
            U_HIST(IA1) = COUNT_UP
            IF(UANISO_OLD(2,IA).LE.0.0) THEN
              COUNT_UP = COUNT_UP + 1
            ELSE
              COUNT_UP = COUNT_UP + 21
            ENDIF
          ENDIF
        ENDDO
        IPOSX = NMPOS
        IPOSU = LM + NMTMP - 1
        DO  ID=1,NDIS
          I1 = N_TARGET(ID)
          I2 = N_OBJECT(ID)
          IA1 = ATOM_REF_FLAG(I1)
          IA2 = ATOM_REF_FLAG(I2)
          IA11 = IA1/10
          IA21 = IA2/10
          IA12 = IA1 - IA11*10
          IA22 = IA2 - IA21*10
          NW_UVAL(ID) = 1
          IF(IA12.GT.2.AND.IA22.GT.2) THEN
C---Consider case when pair of IAs are equal.
C---------save
            DO   IAN = 1,6
              USAVE1(IAN) = U_ANISO(IAN,I1)
              USAVE2(IAN) = U_ANISO(IAN,I2)
            ENDDO
            IF(U_ANISO(2,I1).GT.0.0.AND.UANISO_OLD(2,I1).LE.0.0) THEN
              TEMP = (U_ANISO(1,I1)+U_ANISO(2,I1) + U_ANISO(3,I1))/3.0
              DO  IAN=1,6
                U_ANISO(IAN,I1) = 0.0
              ENDDO
              U_ANISO(1,I1) = TEMP
            ENDIF
            IF(U_ANISO(2,I2).GT.0.0.AND.UANISO_OLD(2,I2).LE.0.0) THEN
              TEMP = (U_ANISO(1,I2)+U_ANISO(2,I2) + U_ANISO(3,I2))/3.0
              DO  IAN=1,6
                U_ANISO(IAN,I2) = 0.0
              ENDDO
              U_ANISO(1,I2) = TEMP
            ENDIF
c----------end of save
            CALL FAST_HESSIAN_NONDIAGONAL(I1,I2,NSYM_DIST(1,ID),
     &      H_XX,H_UU,H_QQ,H_XB,H_XU,H_XQ,H_QX,H_BQ,H_QB,H_UQ,H_QU)
C---Take care of symmetry and atoms in the special positions.
C
cd            IF(I1.LE.10) THEN
cd               WRITE(*,*)H_XX
cd            ENDIF
            IF (I1.NE.I2) THEN
              CALL ADD_NONDIAG_X(IPOSX,SCALXRAY,AM_G,H_XX)
              IF (ITEMP.NE.0) THEN
                CALL ADD_NONDIAG_U(IPOSU,SCALXRAY,U_ANISO(1,I1),
     &                               U_ANISO(1,I2),AM_G,H_UU)
              ENDIF
            ELSE
              CALL FAST_HESSIAN_DIAGONAL(I1,H_XXD,H_UUD,H_UQD,H_QQD)
               CALL ADD_DIAG_X(IA11,SCALXRAY,AM_G,H_XX)
               IF (ITEMP.NE.0) THEN
                  CALL ADD_DIAG_U(U_HIST(IA11),SCALXRAY,U_ANISO(1,I1),
     &                            AM_G,H_UU)
               ENDIF
               I = U_HIST(IA11)
               IPOSX = IPOSX + 9
               IF (U_ANISO(2,I1).LE.0.0) THEN
                  IPOSU = IPOSU + 1
               ELSE
                  IPOSU = IPOSU + 36
               ENDIF
            ENDIF
c----------restore
            DO   IAN=1,6
              U_ANISO(IAN,I1) = USAVE1(IAN)
              U_ANISO(IAN,I2) = USAVE2(IAN)
            ENDDO
C----------end of restore
          ELSE
            IPOSX = IPOSX + 9
            IF(UANISO_OLD(2,I1).LE.0.0.AND.UANISO_OLD(2,I2).LE.0.) THEN
              IPOSU = IPOSU + 1
            ELSE IF(UANISO_OLD(2,I1).GT.0.0.AND.
     &              UANISO_OLD(2,I2).LE.0.0.OR.
     &              UANISO_OLD(2,I1).LE.0.0.AND.
     &              UANISO_OLD(2,I2).GT.0.0) THEN
              IPOSU = IPOSU + 6
            ELSE
              IPOSU = IPOSU + 36
            ENDIF
          ENDIF
        ENDDO
      ENDIF
cd      STOP
      NBIS = NDIS
C
      IF(ITEMP.NE.0) THEN
        NMAXU   = QQV-NVPOS
        NMMAXU  = QQM-NMPOS
        CALL AVECPVEC_R(NVTMP,NMAXU,SCALXRAY,GU(1),V_G(NVPOS+1),
     +                         V_G(NVPOS+1),IERROR)
      ENDIF
      deallocate(u_hist)
      RETURN
      END
C
      SUBROUTINE ADD_NONDIAG_X(IPOSX,SCALEXRAY,AM,H_XX)
      IMPLICIT NONE
C
c--Comment
      INTEGER IPOSX
      REAL AM(*),SCALEXRAY,H_XX(3,3)
C
      AM(IPOSX + 1) = AM(IPOSX+1) + SCALEXRAY*H_XX(1,1)
      AM(IPOSX + 2) = AM(IPOSX+2) + SCALEXRAY*H_XX(1,2)
      AM(IPOSX + 3) = AM(IPOSX+3) + SCALEXRAY*H_XX(1,3)
      AM(IPOSX + 4) = AM(IPOSX+4) + SCALEXRAY*H_XX(2,1)
      AM(IPOSX + 5) = AM(IPOSX+5) + SCALEXRAY*H_XX(2,2)
      AM(IPOSX + 6) = AM(IPOSX+6) + SCALEXRAY*H_XX(2,3)
      AM(IPOSX + 7) = AM(IPOSX+7) + SCALEXRAY*H_XX(3,1)
      AM(IPOSX + 8) = AM(IPOSX+8) + SCALEXRAY*H_XX(3,2)
      AM(IPOSX + 9) = AM(IPOSX+9) + SCALEXRAY*H_XX(3,3)
      IPOSX = IPOSX + 9
      RETURN
      END
c
      SUBROUTINE ADD_DIAG_X(IP,SCALEXRAY,AM,H_XX)
      IMPLICIT NONE
C
c--Comment
      INTEGER IP,IPOS
      REAL AM(*),SCALEXRAY,H_XX(3,3)
C
      IPOS = (IP-1)*6
      AM(IPOS + 1) = AM(IPOS+1) + SCALEXRAY*H_XX(1,1)
      AM(IPOS + 2) = AM(IPOS+2) + SCALEXRAY*H_XX(2,2)
      AM(IPOS + 3) = AM(IPOS+3) + SCALEXRAY*H_XX(3,3)
      AM(IPOS + 4) = AM(IPOS+4) + SCALEXRAY*H_XX(1,2)
      AM(IPOS + 5) = AM(IPOS+5) + SCALEXRAY*H_XX(1,3)
      AM(IPOS + 6) = AM(IPOS+6) + SCALEXRAY*H_XX(2,3)
      RETURN
      END
C
      SUBROUTINE ADD_NONDIAG_U(IPOSU,SCALEXRAY,U1,U2,AM,H_UU)
      IMPLICIT NONE
C
c--Comment
      INTEGER IPOSU,IANISO,IANISO1
      REAL SCALEXRAY
      REAL U1(6),U2(6),AM(*),H_UU(6,6)
C
C-----both atoms isotropic
      IF (U1(2).le.0.0.and.U2(2).le.0.0) THEN
        AM(IPOSU+1) = AM(IPOSU + 1) + SCALEXRAY* H_UU(1,1)
        IPOSU = IPOSU + 1
      ELSEIF (U1(2).gt.0.0.and.U2(2).gt.0.0) THEN
C---------both atoms anisotropic
        DO IANISO=1,6
          DO IANISO1=1,6
            AM(IPOSU+1) = AM(IPOSU+1) + SCALEXRAY*H_UU(IANISO1,IANISO)
            IPOSU       = IPOSU + 1
          ENDDO
        ENDDO
C---On of them is isotropic, another anisotropic
      ELSE
        DO IANISO=1,6
          AM(IPOSU+1) = AM(IPOSU+1) + SCALEXRAY*H_UU(IANISO,1)
          IPOSU       = IPOSU + 1
        ENDDO
      ENDIF
      RETURN
      END
c
      SUBROUTINE ADD_DIAG_U(IPOSU,SCALXRAY,U1,AM_G,H_UU)
      IMPLICIT NONE
C
c--Comment
      INTEGER IPOSU,IANISO,IANISO1
      REAL SCALXRAY
      REAL U1(6),AM_G(*),H_UU(6,6)
C
C----- isotropic
      IF (U1(2).le.0.0) THEN
        AM_G(IPOSU+1) = AM_G(IPOSU + 1) + SCALXRAY*H_UU(1,1)
      ELSE
        AM_G(IPOSU+1)  = AM_G(IPOSU+1)  + SCALXRAY*H_UU(1,1)
        AM_G(IPOSU+2)  = AM_G(IPOSU+2)  + SCALXRAY*H_UU(2,2)
        AM_G(IPOSU+3)  = AM_G(IPOSU+3)  + SCALXRAY*H_UU(3,3)
        AM_G(IPOSU+4)  = AM_G(IPOSU+4)  + SCALXRAY*H_UU(4,4)
        AM_G(IPOSU+5)  = AM_G(IPOSU+5)  + SCALXRAY*H_UU(5,5)
        AM_G(IPOSU+6)  = AM_G(IPOSU+6)  + SCALXRAY*H_UU(6,6)
        AM_G(IPOSU+7)  = AM_G(IPOSU+7 ) + SCALXRAY*H_UU(1,2)
        AM_G(IPOSU+8)  = AM_G(IPOSU+8 ) + SCALXRAY*H_UU(1,3)
        AM_G(IPOSU+9)  = AM_G(IPOSU+9 ) + SCALXRAY*H_UU(1,4)
        AM_G(IPOSU+10) = AM_G(IPOSU+10) + SCALXRAY*H_UU(1,5)
        AM_G(IPOSU+11) = AM_G(IPOSU+11) + SCALXRAY*H_UU(1,6)
        AM_G(IPOSU+12) = AM_G(IPOSU+12) + SCALXRAY*H_UU(2,3)
        AM_G(IPOSU+13) = AM_G(IPOSU+13) + SCALXRAY*H_UU(2,4)
        AM_G(IPOSU+14) = AM_G(IPOSU+14) + SCALXRAY*H_UU(2,5)
        AM_G(IPOSU+15) = AM_G(IPOSU+15) + SCALXRAY*H_UU(2,6)
        AM_G(IPOSU+16) = AM_G(IPOSU+16) + SCALXRAY*H_UU(3,4)
        AM_G(IPOSU+17) = AM_G(IPOSU+17) + SCALXRAY*H_UU(3,5)
        AM_G(IPOSU+18) = AM_G(IPOSU+18) + SCALXRAY*H_UU(3,6)
        AM_G(IPOSU+19) = AM_G(IPOSU+19) + SCALXRAY*H_UU(4,5)
        AM_G(IPOSU+20) = AM_G(IPOSU+20) + SCALXRAY*H_UU(4,6)
        AM_G(IPOSU+21) = AM_G(IPOSU+21) + SCALXRAY*H_UU(5,6)
      ENDIF
      RETURN
      END
