C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
C
      SUBROUTINE LSQ_COEF(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
c
c----Subroutine to calculate coefficients for fourie transformation
c----for gradient calculation for minimisation function
c-----                       sum(w(fo-fc)**2)
C-----  FC and PHASE will contain coefficients for FFT for gradient calc
C-----  FO           will contain coefficients for FFT for Hessian calc
C-----  SIGO         will be 0
c
      IMPLICIT NONE
      INTEGER NREF
      REAL FO(*),SIGO(*),FC(*),PHASE(*),FREER(*)
      real fwt(*)
      INTEGER NIND(*)
c
c----Values inbins for agreements
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'rharvest.fh'
C
      REAL DFA(NMAXPART),DFB(NMAXPART),D2FDA2(NMAXPART),D2FDB2(NMAXPART)

      INTEGER I,J,JMN,IFREE,NB1,IMODE,NREFMNPAR 
      INTEGER IHH(3),N_REFINED_ATOMS
      REAL    SO,SIGEXPER,SIGAPP,YO,SQRTW,RSQ,RHO,YOS,YC_ALL,
     &        PHASE_ALL,SIGOS,DY,WDY,DENOM1,COMPL,F_VALUE_C
      REAL LSTLSQ
      EXTERNAL LSTLSQ,UNPACK
C
C----Initialize
      HNSHELL = NBIN
      NB1 = NBIN+1
      DO    I=1,NB1
        DO   IFREE = 1,2
          AFOMFC(IFREE,I) = 0.0
          NREFM(IFREE,I)  = 0
          NREFA(IFREE,I)  = 0
          ASIG(IFREE,I)   = 0.0
          WFOMFC(IFREE,I) = 0.0
          AFOFO(IFREE,I)  = 0.0
          AFCFC(IFREE,I)  = 0.0
          AFOFC(IFREE,I)  = 0.0
          AFC(IFREE,I)    = 0.0
          AFO(IFREE,I)    = 0.0
          WFO(IFREE,I)    = 0.0
          WFOFO(IFREE,I)  = 0.0
        ENDDO
      ENDDO
      FXRAY  = 0.0
      FXFREE = 0.0
c
c---Loop over reflections
      IMODE = 0
      IF(LREFIN.AND.REFS.EQ.'LSQF') IMODE = 2
      CALL FIND_NREFINED_ATOMS(N_REFINED_ATOMS)
      DO     I=1,NREF
        YO  = FO(I)
        SO  = SIGO(I)
        JMN = 0
        IF(SO.LE.0.0)  JMN = 1

        IFREE  = 1
        IF(FREER_FLAG )THEN
          IF( ABS(FREER(I) - LFreeRexcludeVal) .LT.0.01)  IFREE = 2
        END IF
        CALL UNPACK(NIND(I),IHH(1),IHH(2),IHH(3))
        RSQ   = LSTLSQ(1,IHH(1),IHH(2),IHH(3))
        RHO   = SQRT(RSQ)
        IF(SO.GT.0.0)CALL SUMSFS_LS_DERIV(I,NREF,NIND,FO,SIGO,FC,PHASE,
     &           YOS,YC_ALL,PHASE_ALL,SIGOS,DFA,DFB,D2FDA2,D2FDB2,
     &           F_VALUE_C,IMODE)
        DY    = 0.0
        IF(SO.GT.0.0) THEN
          SIGEXPER = SIGOS
          IF(.NOT.LEXPUSE) SIGEXPER = 1.0
          SIGAPP = SIGEXPER
          SQRTW  = 1.0/SIGAPP
          DY     = YOS-YC_ALL
          WDY    = SQRTW*DY
        ENDIF
C
C---  Resolution ranges:
        DO     J=1,NBIN
          IF(RHO.GE.SMINB(J).AND.RHO.LE.SMAXB(J)) THEN
            NREFM(IFREE,J)  = NREFM(IFREE,J) + JMN
            IF(SO.LE.0.0)  GO TO 100
            AFOMFC(IFREE,J) = AFOMFC(IFREE,J) + ABS(DY)
            AFOFO(IFREE,J)  = AFOFO(IFREE,J)  + YOS*YOS
            AFOFC(IFREE,J)  = AFOFC(IFREE,J)  + YOS*YC_ALL
            AFCFC(IFREE,J)  = AFCFC(IFREE,J)  + YC_ALL*YC_ALL
            AFC(IFREE,J)    = AFC(IFREE,J)    + YC_ALL
            AFO(IFREE,J)    = AFO(IFREE,J)    + YOS
            NREFA(IFREE,J)  = NREFA(IFREE,J)  + 1
            ASIG(IFREE,J)   = ASIG(IFREE,J)   + SIGOS
            WFOMFC(IFREE,J) = WFOMFC(IFREE,J) + ABS(WDY)
            WFO(IFREE,J)    = WFO(IFREE,J)    + SQRTW*YOS
            WFOFO(IFREE,J)  = WFOFO(IFREE,J)  + SQRTW**2*YOS**2
            GOTO 100
          ENDIF
        ENDDO
        GOTO 101
100     CONTINUE
        NREFM(IFREE,NB1) = NREFM(IFREE,NB1) + JMN
        IF(SO.LE.0.0) GOTO 101
C
C---  Totals
        AFOMFC(IFREE,NB1) = AFOMFC(IFREE,NB1) + ABS(DY)
        AFOFO(IFREE,NB1)  = AFOFO(IFREE,NB1)  + YOS*YOS
        AFOFC(IFREE,NB1)  = AFOFC(IFREE,NB1)  + YOS*YC_ALL
        AFCFC(IFREE,NB1)  = AFCFC(IFREE,NB1)  + YC_ALL*YC_ALL
        AFC(IFREE,NB1)    = AFC(IFREE,NB1)    + YC_ALL
        AFO(IFREE,NB1)    = AFO(IFREE,NB1)    + YOS
        NREFA(IFREE,NB1)  = NREFA(IFREE,NB1)  + 1
        ASIG(IFREE,NB1)   = ASIG(IFREE,NB1)   + SIGOS
C
C---  Calculate agreement factors
        WFOMFC(IFREE,NB1) = WFOMFC(IFREE,NB1) + ABS(WDY) 
        WFO(IFREE,NB1)    = WFO(IFREE,NB1)    + SQRTW*YOS
        WFOFO(IFREE,NB1)  = WFOFO(IFREE,NB1)  + SQRTW*2*YOS**2
C
C---  Coefficients for gradient and second derivative calculation
        IF(IFREE.EQ.1) THEN
          FXRAY = FXRAY + WDY**2
        ELSE
          FXFREE = FXFREE + WDY**2
        ENDIF
C
        IF(IMODE.EQ.2) THEN
          IF(IFREE.EQ.1) THEN
            FC(I)    = -WDY
            PHASE(I) = 0.0
            IF(ABS(FC(I)).NE.0.0)PHASE(I)=PHASE_ALL
            FO(I)  =
     +        (D2FDA2(NPART+1)+D2FDB2(NPART+1))/2.0*NSMULT*IFACTOR_CC
            SIGO(I)  = 0.0
          ELSE
            FC(I)    = 0.0
            PHASE(I) = 0.0
            SIGO(I)  = 0.0
            FO(I)    = 0.0
          ENDIF
        ENDIF
 101    CONTINUE
      ENDDO

C
c---Compile statistic
      DO     I=1,NB1
        HD_SHELL_HIGH(I) = 0.5/SMAXB(I)
        HD_SHELL_LOW(I)  = 0.5/SMINB(I)
        HNREF_SHELL_WORK(I) = NREFA(1,I)
        HNREF_SHELL_FREE(I) = NREFA(2,I)
        HNREF_SHELL_OBS(I)  = NREFA(1,I) + NREFA(2,I)
        HNREF_SHELL_ALL(I)  = NREFM(1,I) + NREFM(2,I) + 
     &                           HNREF_SHELL_OBS(I)
        HPERC_SHELL_REFL(I) = 100.0
        IF(HNREF_SHELL_ALL(I).GT.0) 
     &     HPERC_SHELL_REFL(I) = FLOAT(HNREF_SHELL_OBS(I))/
     &                           FLOAT(HNREF_SHELL_ALL(I))*100.0

C
        IF(NREFA(1,I).GT.0) THEN
          HRFAC_SHELL_WORK(I)  = AFOMFC(1,I)/AFO(1,I)
          HRFAC_SHELL_ALL(I)   = (AFOMFC(1,I) + AFOMFC(2,I))/
     &                           (AFO(1,I)+AFO(2,I))
          HRFAC_SHELL_OBS(I)   = HRFAC_SHELL_ALL(I)
          HWRFAC_SHELL_WORK(I)  = WFOMFC(1,I)/WFO(1,I)
          HWRFAC_SHELL_ALL(I)   = (WFOMFC(1,I) + WFOMFC(2,I))/
     &                            (WFO(1,I)+WFO(2,I))
          HWRFAC_SHELL_OBS(I)   = HWRFAC_SHELL_ALL(I)
          AFC(1,I)   = AFC(1,I)/NREFA(1,I)
          AFO(1,I)   = AFO(1,I)/NREFA(1,I)
          AFOFO(1,I) = AFOFO(1,I)/NREFA(1,I)
          AFOFC(1,I) = AFOFC(1,I)/NREFA(1,I)
          AFCFC(1,I) = AFCFC(1,I)/NREFA(1,I)
          ASIG(1,I)  = ASIG(1,I)/NREFA(1,I)
        END IF
        IF(NREFA(2,I).GT.0) THEN
          HRFAC_SHELL_FREE(I)  = AFOMFC(2,I)/AFO(2,I)
          HWRFAC_SHELL_FREE(I)  = WFOMFC(2,I)/WFO(2,I)
          AFC(2,I)   = AFC(2,I)/NREFA(2,I)
          AFO(2,I)   = AFO(2,I)/NREFA(2,I)
          AFOFO(2,I) = AFOFO(2,I)/NREFA(2,I)
          AFOFC(2,I) = AFOFC(2,I)/NREFA(2,I)
          AFCFC(2,I) = AFCFC(2,I)/NREFA(2,I)
          ASIG(2,I)  = ASIG(2,I)/NREFA(2,I)
        END IF
      ENDDO
C
      HD_HIGH = 0.5/SMAXB(NBIN)
      HD_LOW  = 0.5/SMINB(1)
      NREFMNPAR = NREFA(1,NB1) - NREF_PARS
      COMPL     = FLOAT(NREFA(1,NB1))/FLOAT((NREFA(1,NB1)+
     +            NREFM(1,NB1)+NREFA(2,NB1)+NREFM(2,NB1)))
C
      HESU_CRUIC = 0.0
      IF(NREFMNPAR.GT.0) THEN
        HESU_CRUIC = SQRT(FLOAT(N_REFINED_ATOMS)/FLOAT(NREFMNPAR))*
     +              COMPL**(-0.333333)*HD_HIGH*HRFAC_SHELL_WORK(NB1)
      ENDIF
C
      IF(FREER_FLAG.AND.NREFA(2,NBIN+1).GT.0) THEN
        HESU_FREE = SQRT(FLOAT(N_REFINED_ATOMS)/FLOAT(NREFA(1,NB1)))*
     +        COMPL**(-0.333333)*HD_HIGH*HRFAC_SHELL_FREE(NB1)
      ENDIF
C
      HCORR_FOFC  = 0.0
      DENOM1       = (AFOFO(1,NB1) - AFO(1,NB1)*AFO(1,NB1))*
     &              (AFCFC(1,NB1) - AFC(1,NB1)*AFC(1,NB1))
      IF(DENOM1.GT.0.0)
     &           HCORR_FOFC=(AFOFC(1,NB1)-AFO(1,NB1)*AFC(1,NB1))/
     &                      SQRT(DENOM1)
      IF(FREER_FLAG) THEN
        DENOM1 =     (AFOFO(2,NB1) - AFO(2,NB1)*AFO(2,NB1))*
     &              (AFCFC(2,NB1) - AFC(2,NB1)*AFC(2,NB1))
        IF(DENOM1.GT.0.0)HCORR_FOFC_FREE = 
     &           (AFOFC(2,NB1)-AFO(2,NB1)*AFC(2,NB1))/
     &           SQRT(DENOM1)
      ENDIF
C
C---Save for harvesting. It could be used for monitoring statistics
C---outside this routine
      NHREFL_WORK       = NREFA(1,NB1)
      RFACTOR_WORK      = HRFAC_SHELL_WORK(NB1)
      RWFACTOR_WORK     = HWRFAC_SHELL_WORK(NB1)
      PERC_FREE         = 0.0
      IF(FREER_FLAG.AND.NREFA(2,NB1).GT.0) THEN
         NHREFL_FREE     = NREFA(2,NB1)
         RFACTOR_FREE    = HRFAC_SHELL_FREE(NB1)
         RWFACTOR_FREE   = HWRFAC_SHELL_FREE(NB1)
         IF(NHREFL_WORK+NHREFL_FREE.GT.0)
     &        PERC_FREE       = 
     &        FLOAT(NHREFL_FREE)/FLOAT(NHREFL_WORK+NHREFL_FREE)*100.0
      ENDIF
C
C-----
      RETURN
      END
C
      SUBROUTINE ML1CF(NREF,NIND,FO,SIGO,fwt,FC,PHASE,FREER)
C
C----Subroutine to calculate coefficients for fourie transformation
C----for gradient calculation for Maximization likelihood without
C----phase information
C----
C----In the absence of phase information likelihood function becomes 
C----very simple (see Theory.doc and references from there
C
C-----  FC and PHASE will contain coefficients for FFT for gradient calc
C-----  FO           will contain coefficients for FFT for Hessian calc
C-----  SIGO         will be 0
C-----  FREER        flag for free_R calculation
C
C
      IMPLICIT NONE
      REAL FO(*),SIGO(*),FC(*),PHASE(*),FREER(*)
      real fwt(*)
      INTEGER NIND(*)
C
C----Values inbins for agreements
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'const.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'weights.fh'
C
      INTEGER NREF
      INTEGER IHH(3),IBBB,NFREE,IFREE,I,IR,ICENT,ISYSAB,IBIN,IB,I_INTER,
     &        NPART1
      integer nref_used
      real w_h
      real rsq1
      REAL    HH(3),RSQ,RHO,EPSI,EXPAN,SBS,YO,YC,PHCC,
     &        SIGMA,DFDA,DFDB,DFDAA,SCALE_P,SCALE_NOW,A_ALL,B_ALL,
     &        DFDBB,FVALUE,FOM,SIGMAA,DFDA1,DFDB1,DFDAB,WT1,SIGMA_IN,
     &        STL_C
      REAL A_CALCS(NMAXPART),B_CALCS(NMAXPART)
      REAL LSTLSQ
      EXTERNAL LSTLSQ
      EXTERNAL UNPACK
cd      SAVE /BINS_NUM/
C
C----Initialize
      NPART1 = NPART + 1
      NBIN_ML1 = NBIN_ML + 1
      NFREE = 1
      IF(FREER_FLAG) NFREE = 2
      FXRAY = 0.0
      FXFREE = 0.0
C
C---Initialize 
      DO   I=1,NBIN
        DO   IFREE = 1,NFREE
C
C---Acentric reflections
          NREFA(IFREE,I)   = 0
          FOMAVA(IFREE,I)  = 0.0
C
C----Centric reflections
          NREFC(IFREE,I)   = 0
          FOMAVC(IFREE,I)  = 0.0
          D_ML(IFREE,I)   = 0.0
        ENDDO
      ENDDO

C
      w_ave = 0.0
      nref_used = 0
      I_INTER = -1
      DO    IR=1,NREF
        IF(SIGO(IR)*fwt(ir).LE.0.0.AND.LREFIN) THEN
           FO(IR)    = 0.0
           FC(IR)    = 0.0
           SIGO(IR)  = 0.0
           PHASE(IR) = 0.0
           GOTO 120
        ENDIF
        if(sigo(ir).le.0.0 .and..NOT.LREFIN) GOTO 120
        if(fwt(ir).le.0.0.and. .not.LREFIN) goto 120
        IFREE = 1
        IF(FREER_FLAG)THEN 
          IF((ABS(FREER(IR)-LFreeRexcludeVal).LT.0.01)) IFREE = 2
        END IF
        CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
        RSQ =  LSTLSQ(1,IHH(1),IHH(2),IHH(3))
        RHO = SQRT(RSQ)
        STL_C = 2.0*RHO
        CALL CENTR(IHH,ICENT)
        CALL EPSLON(IHH,EPSI,ISYSAB)
        EXPAN = EXP(-RSQ*B_LS_OVER) 
C
C---Find bin number
        IBIN = 0
        DO  IBBB=1,NBIN
          IF(RHO.GE.SMINB(IBBB).AND.RHO.LE.SMAXB(IBBB)) 
     &             IBIN = IBBB
        ENDDO
        IF(LREFIN.AND.IBIN.LE.0.OR.
     &     STL_C.LT.SMINB_ML(1).OR.STL_C.GT.SMAXB_ML(NBIN_ML)) THEN
          FC(IR)     = 0.0
          PHASE(IR)  = 0.0
          SIGO(IR)   = 0.0
          FO(IR)     = 0.0
          GOTO 120
        ENDIF
20      CONTINUE
C
        YO    = FO(IR)
        CALL EXTRACT_ABS(IR,FC,PHASE,A_CALCS,B_CALCS)
        WT1   = REAL(1+ICENT)*EPSI
        IF(SIGMA_REFINE_STYLE.EQ.'BINS') THEN
          A_ALL = 0.0
          B_ALL = 0.0
          IF(NPART.GT.0) THEN
            DO  I=1,NPART
              CALL LINTER_VALUE2(NBIN_ML,SMEANB_ML,SCALE_ML(1,I),STL_C,
     &                              I_INTER,SCALE_NOW)
              A_ALL = A_ALL + A_CALCS(I)*SCALE_NOW
              B_ALL = B_ALL + B_CALCS(I)*SCALE_NOW
            ENDDO
          ENDIF
          CALL LINTER_VALUE2(NBIN_ML,SMEANB_ML,SCALE_ML(1,NPART1),STL_C,
     &                              I_INTER,SCALE_P)
          A_ALL = A_ALL + A_CALCS(NPART1)*SCALE_P
          B_ALL = B_ALL + B_CALCS(NPART1)*SCALE_P
          CALL  LINTER_VALUE2(NBIN_ML,SMEANB_ML,SIGMA_ML,STL_C,
     &                              I_INTER,SIGMA_IN)
        ELSE
          rsq1 = 4.0*rsq
          CALL CALC_ASANDBS_MLGAUSS(RSQ1,A_ALL,B_ALL,A_CALCS(NPART1),
     &                  B_CALCS(NPART1),A_CALCS,B_CALCS)
          CALL CALC_SCALE_P(RSQ1,SCALE_P)

          SIGMA_IN  = 0.0
          SIGMA_IN  = SIGMA_IN + SIGMA_ML_SCALE_OVER-
     &                                 SIGMA_ML_B_OVER*RSQ
     &                               + SIGMA_ML_B1_OVER*RSQ*RSQ
          SIGMA_IN = SIGMA_IN        + SIGMA_ML_B2_OVER*RSQ*RSQ*RSQ
          SIGMA_IN  = EXP(AMAX1(-30.0,AMIN1(59.0,SIGMA_IN)))
        ENDIF
        SIGMA_IN = SIGMA_IN*WT1
        CALL SIGCALC_ML(ICENT,SIGO(IR),SIGMA_IN,SIGMA)
        CALL DFUNCDAB_ML(ICENT,SIGMA,YO,A_ALL,B_ALL,IR,PHASE,DFDA,
     &                     DFDB,DFDAA,DFDAB,DFDBB,FVALUE,FOM)
C
        yc = sqrt(a_all**2+b_all**2)
        CALL INTEGRATE_INFO(icent,sigma,yo,a_all,b_all,ir,phase,w_h)
        IF(LREFIN) THEN
          IF(IFREE.EQ.1) THEN
            DFDA      = DFDA*SCALE_P
            DFDB      = DFDB*SCALE_P
            FC(IR)    = fwt(ir)*(-SQRT(DFDA**2+DFDB**2)/(2.0)*EXPAN)
            PHASE(IR) = 0.0
            IF(ABS(FC(IR)).NE.0.0) PHASE(IR) = ATAN2(DFDB,DFDA)
            w_ave = w_ave + fwt(ir)*w_h
            nref_used = nref_used + nint(fwt(ir)*(1+icent))
            FO(IR)   =  fwt(ir)*(1.0/sigma*SCALE_P**2*
     &                 real(NSMULT)*IFACTOR_CC*EXPAN**2)
          ELSE
            FC(IR)    = 0.0
            PHASE(IR) = 0.0
            SIGO(IR)  = 0.0
            FO(IR)    = 0.0
          ENDIF
        ENDIF
        IF (IFREE.EQ.1) THEN
          FXRAY = FXRAY + FVALUE
        ELSE
          FXFREE = FXFREE + FVALUE
        ENDIF
C
C---Some statistics. This part should be removed
        if(ibin.gt.0) then
         IF(ICENT.EQ.0) THEN
           FOMAVA(IFREE,IBIN)  = FOMAVA(IFREE,IBIN) + fwt(ir)*FOM
           NREFA(IFREE,IBIN)   = NREFA(IFREE,IBIN)  + nint(fwt(ir))
         ELSE
           FOMAVC(IFREE,IBIN)  = FOMAVC(IFREE,IBIN) + fwt(ir)*FOM
           NREFC(IFREE,IBIN)   = NREFC(IFREE,IBIN)  + nint(fwt(ir))
         ENDIF
         D_ML(IFREE,IBIN) = D_ML(IFREE,IBIN) + fwt(ir)*SCALE_P
      endif
120      CONTINUE

      ENDDO
      if(LREFIN) THEN
         w_ave = w_ave/float(nref_used)
         do   ir=1,nref
            fo(ir) = 2.0*w_ave*fo(ir)
         enddo
      endif
C
C---Report statistics
      DO   IFREE = 1,NFREE
         NREFOVERA(IFREE) = 0
         NREFOVERC(IFREE) = 0
         NREFOVERT(IFREE) = 0
         FOMOVERA(IFREE)  = 0.0
         FOMOVERC(IFREE)  = 0.0
         FOMOVERT(IFREE)  = 0.0
      ENDDO 
      DO    IB=1,NBIN
C
C---Statistics for acentric reflection
        DO    IFREE=1,NFREE
          IF(NREFA(IFREE,IB).GT.0) THEN
            FOMOVERA(IFREE)   = FOMOVERA(IFREE)+FOMAVA(IFREE,IB)
            FOMAVA(IFREE,IB)  = FOMAVA(IFREE,IB)/REAL(NREFA(IFREE,IB))
            NREFOVERA(IFREE) = NREFOVERA(IFREE)+NREFA(IFREE,IB)
          ENDIF
C
C---Centric reflections
          IF(NREFC(IFREE,IB).GT.0) THEN
            FOMOVERC(IFREE)   = FOMOVERC(IFREE)+FOMAVC(IFREE,IB)
            FOMAVC(IFREE,IB)  = FOMAVC(IFREE,IB)/REAL(NREFC(IFREE,IB))
            NREFOVERC(IFREE) = NREFOVERC(IFREE)+NREFC(IFREE,IB)
          ENDIF
          IF(NREFA(IFREE,IB)+NREFC(IFREE,IB).GT.0) THEN
            D_ML(IFREE,IB) = D_ML(IFREE,IB)/
     &        REAL(NREFA(IFREE,IB)+NREFC(IFREE,IB))
          ENDIF
        ENDDO
      ENDDO
      DO    IFREE = 1,NFREE
        NREFOVERT(IFREE) = NREFOVERA(IFREE)+NREFOVERC(IFREE)
        IF(NREFOVERT(IFREE).GT.0) THEN
           FOMOVERT(IFREE) = (FOMOVERA(IFREE)+FOMOVERC(IFREE))/
     +                        REAL(NREFOVERT(IFREE))
        ENDIF
        IF(NREFOVERA(IFREE).GT.0) THEN
          FOMOVERA(IFREE) = FOMOVERA(IFREE)/REAL(NREFOVERA(IFREE))
        ENDIF
        IF(NREFOVERC(IFREE).GT.0) THEN
          FOMOVERC(IFREE) = FOMOVERC(IFREE)/REAL(NREFOVERC(IFREE))
        ENDIF
      ENDDO
C
      RETURN
      END
C
      subroutine integrate_info(icent,sigma,yo,a_all,b_all,ir,phase,
     &        w_h)
      implicit none
      include 'refi_flags.fh'
      integer icent,ir
      real sigma,yo,a_all,b_all,w_h
      real phase(*)
C
      integer i
      integer ipos
      integer npoint_int
      real yo1,yc,yc1,yc2,sigma1
      real alpha
      real ha,hb,hc,hd
      real sqrt2
      real small_value
      real x_1,xx,xx1,xx2,xx3,t1
      real fom
      real w_h1
      real sum1,cosa0,sina0
      real w_n(64),x_n(64)
      real x_n0,y_cs,y_cc,x_m1,x_m2,x_m12,arg_subtr,w_n0,expp
      real arg_max
      real exp_r
      external exp_r
      data arg_max/50.0/,small_value/1.0E-7/
C
      yc = sqrt(a_all*a_all+b_all*b_all)
C
c---  Do normalisation. Epsilon has already been applied. centrosymmeticity
C---  also has been added to sigma.
C
      sigma1 = sqrt(sigma)
      yo1 = yo/sigma1
      yc1 = yc/sigma1
      yc2 = yc1
C
C--if yc is very small then take small value
C
      if(yc1.le.0.0001)then
        w_h  = small_value
        return
      endif
      if(yc1.gt.20.0) then
        if(icent.eq.0) then
          w_h = 0.5
        else
          w_h = 1.0
        endif
      endif
C
C---calculate phases if we need them
      if(MIR_FLAG) THEN
        alpha = 0.0
        if(yc.gt.0.0) alpha = atan2(b_all,a_all)
        ipos = (NPART +1)*NOBS + ir
        ha   = phase(ipos)
        ipos = ipos + nobs
        hb   = phase(ipos)
        ipos = ipos + nobs
        hc   = phase(ipos)
        ipos = ipos + nobs
        hd   = phase(ipos)
      else
        ha = 0.0
        hb = 0.0
        hc = 0.0
        hd = 0.0
      endif

C
C---start integration
      w_h = 0.0
      w_h1 = 0.0
      sum1 = 0.0
      sqrt2 = sqrt(2.0)
      call get_integr_points(npoint_int,yc1*sqrt2,w_n,x_n)
cd      npoint_int = 4
cd      call GAUSS_COEF_TAB_A2INF(npoint_int,yc1*sqrt2,
cd     &        x_n,w_n)
cd      do i=1,npoint_int
cd        x_n(i) = x_n(i)/sqrt2
cd        w_n(i) = w_n(i)*sqrt2
cd      enddo
cd      write(*,*)yc1,icent
cd      do i=1,npoint_int
cd         write(*,*)w_n(i),x_n(i)
cd      enddo
      cosa0 = cos(alpha)
      sina0 = sin(alpha)

      arg_subtr = 0.0
      if(icent.eq.0) then
        do  i=1,npoint_int
          x_n(i) = x_n(i)/sqrt2
          w_n0 = alog(w_n(i)*sqrt2)
          x_1 = yc1 + x_n(i)
          xx = 2.0*x_1*yc1
C
C---  We need fom and value of I0 or corresponding function from
C---  phased distribution
C
          call calc_fom_acent(cosa0,sina0,ha,hb,hc,hd,fom,xx,xx1,xx2)
          xx3 = xx2 - xx + w_n0 + log(xx1)
C
C---Stabilise by rescaling
C
          if(i.eq.1) then
            if(abs(xx3).gt.arg_max) then
              arg_subtr = xx3
              xx3 = 0.0
              t1 = x_1
            else
              arg_subtr = 0.0

              t1 = x_1*exp(xx3)
cd              write(*,*)xx3,exp_r(xx3)
            endif
            sum1 = t1
            w_h = (fom*x_1-yc1)**2*t1
          else
            xx3 = xx3 - arg_subtr
            if(xx3.gt.arg_max) then
              arg_subtr = xx3 - arg_max
              xx3 = xx3 - arg_subtr
              if(arg_subtr.gt.arg_max) then
                sum1 = 0.0
                w_h  = 0.0
              else
                expp = exp(-arg_subtr)
                sum1 = sum1*expp
                w_h  = w_h*expp
              endif
            endif
            t1   = x_1*exp(xx3)
            sum1 = sum1 + t1
            w_h = w_h + (fom*x_1-yc1)**2*t1
          endif
cd          w_h1 = w_h1 + (1.0-x_1**2*(1.0-fom**2))*t1
        enddo
        w_h = amin1(0.5,w_h/sum1)

      else
        yc2 = yc1*sqrt2
        do   i=1,npoint_int
cd          x_n(i) = x_n(i)
          w_n0 = alog(w_n(i))
          x_1 = yc2 + x_n(i)
          xx = x_1*yc2
C
C---  We need fom and value of I0 or corresponding function from
C---  phased distribution
C
          call calc_fom_cent(cosa0,sina0,ha,hb,hc,hd,fom,xx,xx1,xx2)
cd          write(*,*)fom,xx,xx1,xx2
          xx3 = xx2 - xx + w_n0 + log(xx1)

C
C---Stabilise by rescaling
C
          if(i.eq.1) then
            if(abs(xx3).gt.arg_max) then
              arg_subtr = xx3
              xx3 = 0.0
              t1 = 1.0
             else
               t1 = exp(xx3)
            endif
            sum1 = t1
            w_h = (fom*x_1-yc2)**2*t1
          else
            xx3 = xx3 - arg_subtr
            if(xx3.gt.arg_max) then
              arg_subtr = xx3 - arg_max
              xx3 = xx3 - arg_subtr
              if(arg_subtr.gt.arg_max) then
                sum1 = 0.0
                w_h  = 0.0
              else
                expp = exp(-arg_subtr)
                sum1 = sum1*expp
                w_h  = w_h*expp
              endif
            endif
            t1   = exp(xx3)
            sum1 = sum1 + t1
            w_h = w_h + (fom*x_1-yc2)**2*t1
          endif
cd          xx3 = xx2 - xx
cd          t1  = xx1*exp(xx3)
cd          sum1 = sum1 + t1
cd          w_h  = w_h  + (fom*x_1-yc2)**2*t1

        enddo
        w_h = amin1(1.0,w_h/sum1)
      endif
cd      if(w_h.gt.1.0) then
cd         write(*,*)w_h,icent,arg_subtr,yo1,yc1
cd         stop
cd      endif
cd      w_h1 = w_h1/sum1
cd      if(icent.eq.0) then
cd        write(*,*)w_h,w_h1,sum1
cd        stop
cd      endif
C
cd      write(51,*)icent,w_h,sum1,yo1,yc1,ha,hb,hc,hd
      return
      end
C
      subroutine get_integr_points(npoint,yc2,w_n,x_n)
      implicit none
      include 'gaussian.fh'
      integer npoint
      real yc2
      real w_n(*),x_n(*)
C
      integer i,i_access
C
      i_access = max(1,min(ntab_integr,
     &         int((yc2-x_0_integr)/delta_integr)+1))
      npoint = npoint_int
      do   i=1,npoint
        x_n(i) = x_points_int(i,i_access)
        w_n(i) = w_points_int(i,i_access)
      enddo

      return
      end
C
      subroutine calc_fom_acent(cosa0,sina0,ha,hb,hc,hd,fom,xx,xx1,xx2)
      implicit none
      include 'refi_flags.fh'
      real cosa0,sina0,ha,hb,hc,hd,fom,xx,xx1,xx2

      real ha1,hb1,cosaa,sinaa
      real sim
      external sim

      if(MIR_FLAG) THEN
C
C--we have phases. Do numerical integration
        ha1 = ha + cosa0*xx
        hb1 = hb + sina0*xx
        call phprob_2(ha1,hb1,hc,hd,cosaa,sinaa,xx1,xx2)
        fom = sqrt(cosaa*cosaa+sinaa*sinaa)
        
      else
        fom = sim(xx)
        call bessi0(xx,xx1,xx2)
      endif
      return
      end
C
      subroutine calc_fom_cent(cosa0,sina0,ha,hb,hc,hd,fom,xx,xx1,xx2)
      implicit none
      include 'refi_flags.fh'
      real cosa0,sina0,ha,hb,hc,hd,fom,xx,xx1,xx2
C
      real ha1,hb1
      real xx0

      if(MIR_FLAG) THEN
C
C--we have phases. Use them
C
         ha1 = ha + cosa0*xx
         hb1 = hb + sina0*xx
         xx0 = sqrt(ha1*ha1+hb1*hb1)
         if(xx0.gt.50.0) then
           fom = 1.0
           xx1 = 0.5
           xx2 = xx0
         else
           fom = tanh(xx0)
           xx1 = cosh(xx0)
           xx2 = 0.0
         endif
cd         write(52,*)xx,xx0,xx1,fom,ha,hb,ha1,hb1
      else
        if(xx.gt.50.0) then
          fom = 1.0
          xx1 = 0.5
          xx2 = xx
        else
          fom = tanh(xx)
          xx1 = cosh(xx)
          xx2 = 0.0
        endif
      endif
      return
      end
C
      SUBROUTINE INDTORS(IND,RSQ)
      REAL LSTLSQ
      EXTERNAL  LSTLSQ
      EXTERNAL UNPACK
      CALL UNPACK(IND,IH,IK,IL)
      RSQ =  4.0 * LSTLSQ(1,IH,IK,IL)
      RETURN
      END

