C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
      SUBROUTINE INIT_HESSIAN
      IMPLICIT NONE 
      INCLUDE 'hessian_impl.fh'
      INTEGER l,b
      DO l = 1,MdimD
         DO b = 1,MdimB
            PP1(l,b) = 0.0
            PP2(l,b) = 0.0
            BB(l,b)  = 0.0
            UU1(l,b) = 0.0
            UU2(l,b) = 0.0
            UU3(l,b) = 0.0
            UU4(l,b) = 0.0
            OO(l,b)  = 0.0
            PB(l,b)  = 0.0
            PU1(l,b) = 0.0
            PU2(l,b) = 0.0
            PO(l,b)  = 0.0
            BU1(l,b) = 0.0
            BU2(l,b) = 0.0
            BO(l,b)  = 0.0
            UO1(l,b) = 0.0
            UO2(l,b) = 0.0
         ENDDO
      ENDDO
      RETURN
      END

      SUBROUTINE FAST_HESSIAN_TABULATION(MIN,MAX)
      IMPLICIT NONE
      INCLUDE 'weights.fh'
      INCLUDE 'hessian_impl.fh'
      integer i,l,b,i_inter,ierror,m      
      real s,min,max,strip,stri3,incD,incB
      real*8 al,alsq,alcub,alfour,alfive
      real*8 sinal,cosal,sinal_al,sinal_alsq,sinal_alcub,sinal_alfour,
     & sinal_alfive,cosal_al,cosal_alsq,cosal_alcub,cosal_alfour
      real*8 D2DF_WEIGHT
      real*8 w_c,ft_c,w_c_ft_c

      real*8 totPP1,tot1PP1,totPP2,tot1PP2
      real*8 totBB, tot1BB
      real*8 totUU1,totUU2,totUU3,totUU4
      real*8 tot1UU1,tot1UU2,tot1UU3,tot1UU4
      real*8 totOO, tot1OO
      real*8 totPB, tot1PB
      real*8 totPU1, totPU2, tot1PU1, tot1PU2 
      real*8 totPO, tot1PO
      real*8 totBU1,totBU2,tot1BU1,tot1BU2
      real*8 totBO, tot1BO
      real*8 totUO1,totUO2,tot1UO1,tot1UO2
        
      real*8 sumPP1,sumPP2
      real*8 sumBB
      real*8 sumUU1,sumUU2,sumUU3,sumUU4
      real*8 sumOO
      real*8 sumPB
      real*8 sumPU1, sumPU2
      real*8 sumPO
      real*8 sumBU1, sumBU2
      real*8 sumBO
      real*8 sumUO1,sumUO2
        
      real*8 cPP, cBB, cUU1, cUUrest, cOO, cPB, cPU, cPO, cBU, cBO, cUO
      real*8 rPP, rBB, rUU, rOO, rPB, rPU, rPO, rBU, rBO, rUO

      real*8 aPP1, aPP2, aPB, aPU1, aPU2, aPO 
      real*8 aBB, aBU1, aBU2, aBO
      real*8 aUU1, aUU2, aUU3, aUU4, aUO1, aUO2
      real*8 aOO

      real*8 fPP1(0:size),fPP2(0:size) 
      real*8 fBB(0:size)
      real*8 fUU1(0:size),fUU2(0:size),fUU3(0:size),fUU4(0:size)   
      real*8 fOO(0:size)
      real*8 fPB(0:size)
      real*8 fPU1(0:size),fPU2(0:size)
      real*8 fPO(0:size)
      real*8 fBU1(0:size),fBU2(0:size)
      real*8 fBO(0:size)
      real*8 fUO1(0:size),fUO2(0:size)  
C
      real*8 cPP1,cUUrest1,cPU1,cBU1,cUO1
c
      real pi,twopi
      parameter (pi = 3.141592653589)
      parameter (twopi = 3.141592653589*2.0)

      strip = (max-min)/size
      stri3 = strip/3.0
c
      Dmax = 2.0*DVDW_CUT_MIN_X
c
      stripD = (1.0/(20.0*MAX))
      stripB = 5.0
      IF (stripD.gt.Dmax/10.0) stripD = Dmax/10.0
c
      dimD = INT((Dmax-Dmin)/stripD) + 1
      IF (MOD(dimD,2).eq.0) dimD = dimD + 1
      IF (dimD.gt.MdimD) THEN
         write(*,*) 'DISTANCE ARRAY FOR HESSIAN TABULATION TOO BIG'
         write(*,*) 'VALUE RESET TO MAXIMUM'
         dimD = MdimD
      ENDIF 
      IF (Dmax.lt.0.01) dimD = 21
      stripD = (Dmax-Dmin)/(real(dimD-1))
c
      CALL FIND_BEXTREME
      dimB = INT((B_MAX-B_MIN)/stripB) + 1
cd      stop
      IF (MOD(dimB,2).eq.0) dimB = dimB + 1
      IF (dimB.gt.MdimB) THEN
         write(*,*) 'B ARRAY FOR HESSIAN TABULATION TOO BIG'
         write(*,*) 'VALUE RESET TO MAXIMUM'
         dimB = MdimB
      ENDIF 
      stripB = (B_MAX-B_MIN)/(dimB-1)
      print*, '          GRID VALUES: '
      print*,  stripD, ' Angstrom   for D'
      print*,  stripB, ' Angstrom^2 for B'

c-----moltiplicative coeffs for the various elements
c      cPP = 4.*pi*pi*pi
       cPP = 124.02511597 
c      cBB = twopi/32.
       cBB = 0.19634955
c      cUU1 = 12.0*(pi**5.0)
       cUU1 = 3672.23657227
c      cUUrest= 4.0*(pi**5.0)
       cUUrest= 1224.07885742
c      cOO = twopi/2.
       cOO = 3.14159274
c      cPB = (pi*pi)/2.
       cPB = 4.93480253
c      cPU = 4.*pi*pi*pi*pi
       cPU = 389.63641357
c      cPO = twopi*twopi
       cPO = 39.47842026
c      cBU = (pi*pi*pi)/2.
       cBU = 15.50313950
c      cBO = pi/4.0
       cBO = 0.78539819
c      cUO = pi*pi*twopi
       cUO = 62.01255798
c
c-----tabulation over distance
      incD = Dmin - stripD
      do l = 1,dimD
         incD = incD + stripD
cd         incD = (Dmin+(l-1)*stripD)
c--------tabulation over B
         incB = B_MIN - stripB
         do b = 1,dimB
            incB = incB + stripB            
cd            incB = (B_MIN+(b-1)*stripB)
            i_inter = -1
c-----------integration over resolution (Simpson's method)
            s = min - strip
            do i = 0,size
               s = s + strip
cd               s = min+(strip*i)
               w_c = D2DF_WEIGHT(s,i_inter)
               ft_c = dexp(-(dble(s)**2.0*dble(incB))/4.0D0)
               w_c_ft_c = w_c*ft_c
c
               al = dble(twopi*s*incD)
               if (al.ge.1.0D-2) THEN
                 alsq = al**2
                 alcub = al**3
                 alfour = alsq*alsq
                 alfive = alsq*alcub
                 sinal = dsin(al)
                 cosal = dcos(al)
                 sinal_al = sinal/al
                 sinal_alsq = sinal/alsq
                 sinal_alcub = sinal/alcub
                 sinal_alfour = sinal/alfour
                 sinal_alfive = sinal/alfive
                 cosal_al = cosal/al
                 cosal_alsq = cosal/alsq
                 cosal_alcub = cosal/alcub
                 cosal_alfour = cosal/alfour
               endif
c--------------resolution dependencies of the various elements
               rOO = dble(s)**2
               rPO = dble(s)**3
               rPB = rOO*rPO
               rPP = rOO*rOO
               rBB = rPO*rPO
               rUU = rBB
               rPU = rPB      
               rBU = rBB  
               rBO = rPP
               rUO = rPP
c  
               if (al.lt.1.0D-2) then 
                 aPP1  = 1.0/3.0 
                 aPP2  = aPP1
                 aBB   = 1.0
                 aUU1  = 1.0/15.0
                 aUU2  = 1.0/5.0
                 aUU3  = aUU1
                 aUU4  = -aUU1
                 aOO   = 1.0
                 aPB   = 0.0
                 aPU1  = 0.0
                 aPU2  = aPU1
                 aPO   = 0.0
                 aBU1  = aPP1
                 aBU2  = aBU1
                 aBO   = 1.0
                 aUO1  = aPP1
                 aUO2  = aUO1
               else
                  aPP1 = sinal_alcub - cosal_alsq
cd                print*, aPP1
cd                aPP1 = (sinal-al*cosal)/alcub
cd                print*, aPP1
cd                stop
                  aPP2 = (alsq-2.0D0)*sinal_alcub + 2.0D0*cosal_alsq
                  aBB  = sinal_al
                  aUU1 = (3.0D0-alsq)*sinal_alfive - 3.0D0*cosal_alfour
                  aUU2 = (24.0D0-12.0D0*alsq+alfour)*sinal_alfive
     &                 + 4.0D0*(alsq-6.0D0)*cosal_alfour
                  aUU3 = aUU1
                  aUU4 = (12.0D0-5.0D0*alsq)*sinal_alfive
     &                 + (alsq-12.0D0)*cosal_alfour
                  aOO  = aBB
                  aPB  = sinal_alsq - cosal_al
                  aPO  = aPB
                  aPU1 = (3.0D0-alsq)*sinal_alfour - 3.0D0*cosal_alcub
                  aPU2 = 3.0D0*(alsq-2.0D0)*sinal_alfour
     &                +  (6.0D0-alsq)*cosal_alcub
                  aBU1 = sinal_alcub - cosal_alsq
                  aBU2 = (alsq-2.0D0)*sinal_alcub + 2.0D0*cosal_alsq
                  aBO  = aBB
                  aUO1 = aPP1
                  aUO2 = aBU2
               endif
C
               cPP1     = cPP     * rPP * w_c_ft_c
               cUUrest1 = cUUrest * rUU * w_c_ft_c
               cPU1     = cPU     * rPU * w_c_ft_c
               cBU1     = cBU     * rBU * w_c_ft_c
               cUO1     = cUO     * rUO * w_c_ft_c
 
               fPP1(i) = cPP1     * aPP1 
               fPP2(i) = cPP1     * aPP2
               fBB(i)  = cBB     * rBB * aBB  * w_c_ft_c
               fUU1(i) = cUU1    * rUU * aUU1 * w_c_ft_c
               fUU2(i) = cUUrest1 * aUU2 
               fUU3(i) = cUUrest1 * aUU3
               fUU4(i) =-cUUrest1 * aUU4
               fOO(i)  = cOO     * rOO * aOO  * w_c_ft_c
               fPB(i)  = cPB     * rPB * aPB  * w_c_ft_c
               fPU1(i) = cPU1     * aPU1
               fPU2(i) = cPU1     * aPU2
               fPO(i)  = cPO     * rPO * aPO  * w_c_ft_c
               fBU1(i) = cBU1     * aBU1
               fBU2(i) = cBU1     * aBU2
               fBO(i)  = cBO     * rBO * aBO  * w_c_ft_c
               fUO1(i) = cUO1     * aUO1
               fUO2(i) = cUO1     * aUO2
            enddo

            totPP1  = 0.0
            tot1PP1 = 0.0
            totPP2  = 0.0
            tot1PP2 = 0.0
            totBB   = 0.0
            tot1BB  = 0.0
            totUU1  = 0.0
            tot1UU1 = 0.0
            totUU2  = 0.0
            tot1UU2 = 0.0
            totUU3  = 0.0
            tot1UU3 = 0.0
            totUU4  = 0.0
            tot1UU4 = 0.0
            totOO   = 0.0
            tot1OO  = 0.0
            totPB   = 0.0
            tot1PB  = 0.0
            totPU1  = 0.0
            tot1PU1 = 0.0
            totPU2  = 0.0
            tot1PU2 = 0.0
            totPO   = 0.0
            tot1PO  = 0.0
            totBU1  = 0.0
            tot1BU1 = 0.0
            totBU2  = 0.0
            tot1BU2 = 0.0
            totBO   = 0.0
            tot1BO  = 0.0
            totUO1  = 0.0
            tot1UO1 = 0.0
            totUO2  = 0.0
            tot1UO2 = 0.0
            
            do i = 1,size-1,2
              sumPP1 = fPP1(i)
              sumPP2 = fPP2(i)
              sumBB  = fBB(i)
              sumUU1 = fUU1(i)
              sumUU2 = fUU2(i)
              sumUU3 = fUU3(i)
              sumUU4 = fUU4(i)
              sumOO  = fOO(i)
              sumPB  = fPB(i)
              sumPU1 = fPU1(i)
              sumPU2 = fPU2(i) 
              sumPO  = fPO(i) 
              sumBU1 = fBU1(i)
              sumBU2 = fBU2(i) 
              sumBO  = fBO(i)
              sumUO1 = fUO1(i)
              sumUO2 = fUO2(i) 

              
               totPP1 = totPP1 + sumPP1
               totPP2 = totPP2 + sumPP2
               totBB  = totBB  + sumBB
               totUU1 = totUU1 + sumUU1
               totUU2 = totUU2 + sumUU2
               totUU3 = totUU3 + sumUU3
               totUU4 = totUU4 + sumUU4
               totOO  = totOO  + sumOO
               totPB  = totPB  + sumPB
               totPU1 = totPU1 + sumPU1
               totPU2 = totPU2 + sumPU2
               totPO  = totPO  + sumPO 
               totBU1 = totBU1 + sumBU1 
               totBU2 = totBU2 + sumBU2
               totBO  = totBO  + sumBO
               totUO1 = totUO1 + sumUO1
               totUO2 = totUO2 + sumUO2  
            enddo
c
            do i = 2,size-2,2
               sumPP1 = fPP1(i)
               sumPP2 = fPP2(i)
               sumBB  = fBB(i)
               sumUU1 = fUU1(i)
               sumUU2 = fUU2(i)
               sumUU3 = fUU3(i)
               sumUU4 = fUU4(i)
               sumOO  = fOO(i)
               sumPB  = fPB(i)
               sumPU1 = fPU1(i)
               sumPU2 = fPU2(i) 
               sumPO  = fPO(i) 
               sumBU1 = fBU1(i)
               sumBU2 = fBU2(i) 
               sumBO  = fBO(i)
               sumUO1 = fUO1(i)
               sumUO2 = fUO2(i) 

              
               tot1PP1 = tot1PP1 + sumPP1
               tot1PP2 = tot1PP2 + sumPP2
               tot1BB  = tot1BB  + sumBB
               tot1UU1 = tot1UU1 + sumUU1
               tot1UU2 = tot1UU2 + sumUU2
               tot1UU3 = tot1UU3 + sumUU3
               tot1UU4 = tot1UU4 + sumUU4
               tot1OO  = tot1OO  + sumOO
               tot1PB  = tot1PB  + sumPB
               tot1PU1 = tot1PU1 + sumPU1
               tot1PU2 = tot1PU2 + sumPU2
               tot1PO  = tot1PO  + sumPO 
               tot1BU1 = tot1BU1 + sumBU1 
               tot1BU2 = tot1BU2 + sumBU2
               tot1BO  = tot1BO  + sumBO
               tot1UO1 = tot1UO1 + sumUO1
               tot1UO2 = tot1UO2 + sumUO2  
            enddo
C
            PP1(l,b)=(fPP1(0)+fPP1(size)+4.0*totPP1+2.0*tot1PP1)*stri3
            PP2(l,b)=(fPP2(0)+fPP2(size)+4.0*totPP2+2.0*tot1PP2)*stri3
            BB(l,b) =(fBB(0) +fBB(size) +4.0*totBB +2.0*tot1BB) *stri3
            UU1(l,b)=(fUU1(0)+fUU1(size)+4.0*totUU1+2.0*tot1UU1)*stri3
            UU2(l,b)=(fUU2(0)+fUU2(size)+4.0*totUU2+2.0*tot1UU2)*stri3
            UU3(l,b)=(fUU3(0)+fUU3(size)+4.0*totUU3+2.0*tot1UU3)*stri3
            UU4(l,b)=(fUU4(0)+fUU4(size)+4.0*totUU4+2.0*tot1UU4)*stri3
            OO(l,b) =(fOO(0) +fOO(size) +4.0*totOO +2.0*tot1OO) *stri3
            PB(l,b) =(fPB(0) +fPB(size) +4.0*totPB +2.0*tot1PB) *stri3
            PU1(l,b)=(fPU1(0)+fPU1(size)+4.0*totPU1+2.0*tot1PU1)*stri3
            PU2(l,b)=(fPU2(0)+fPU2(size)+4.0*totPU2+2.0*tot1PU2)*stri3
            PO(l,b) =(fPO(0) +fPO(size) +4.0*totPO +2.0*tot1PO) *stri3
            BU1(l,b)=(fBU1(0)+fBU1(size)+4.0*totBU1+2.0*tot1BU1)*stri3
            BU2(l,b)=(fBU2(0)+fBU2(size)+4.0*totBU2+2.0*tot1BU2)*stri3
            BO(l,b) =(fBO(0) +fBO(size) +4.0*totBO +2.0*tot1BO) *stri3
            UO1(l,b)=(fUO1(0)+fUO1(size)+4.0*totUO1+2.0*tot1UO1)*stri3
            UO2(l,b)=(fUO2(0)+fUO2(size)+4.0*totUO2+2.0*tot1UO2)*stri3
         enddo
      enddo
      return
      end   
c
      SUBROUTINE FAST_HESSIAN_DIAGONAL(ATOM_IND,H_XX,H_UU,H_UQ,H_QQ)
c-----this subroutine reads in the atom index stored in atom_com.fh 
c     and gives back:
c     H_XX 1 element (H_XX=X_YY=X_ZZ, H_XY=H_XZ=H_YZ=0.0)
c     H_UU 1 element if U is isotropic (in units of B)
c          3 elements if U is anisotropic (H_U11U11=H_U22U22=H_U33U33,
c          H_U11U22=H_U11U33=H_U22U33, H_U12U12=H_U13U13=H_U23U23=H_U11U22*4
c     H_UU(1) is H_U11U11, H_UU(2) is H_U11U22 and H_UU(3) is H_U12U12
c     H_UQ 1 element (in units of B if U is isotropic); if U is anisotropic
c          H_U11Q=H_U22Q=H_U33Q, all the others are zero
c     H_QQ 1 element 
            
      IMPLICIT NONE 
      INCLUDE 'atom_com.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'hessian_impl.fh'
c
c-----general variables
      INTEGER ATOM_IND
      REAL H_XX,H_UU(3),H_UQ,H_QQ
c-----local variables
      INTEGER i,I_INTER
      REAL B_POINT(dimB),PP_D(dimB),BB_D(dimB),UU1_D(dimB),
     &     UU3_D(dimB),OO_D(dimB),BO_D(dimB),UO_D(dimB),
     &     VOLUME,PP_D_INT,BB_D_INT,UU1_D_INT,UU3_D_INT,OO_D_INT,
     &     BO_D_INT,UO_D_INT,B_ISO,B_CURR,PP_CURR,VAL_PP,BB_CURR,
     &     VAL_BB,BO_CURR,VAL_BO,UU1_CURR,VAL_UU1,UU3_CURR,VAL_UU3,
     &     UO_CURR,VAL_UO,OO_CURR,VAL_OO,pi,eightpisq,VOLUME4
      EXTERNAL LINTER_VALUE2
c-----initialisation
      H_XX = 0.0
      DO i = 1,3
         H_UU(i) = 0.0
      ENDDO
      H_UQ = 0.0
      H_QQ = 0.0  
      PP_D_INT  = 0.0
      BB_D_INT  = 0.0
      UU1_D_INT = 0.0
      UU3_D_INT = 0.0
      OO_D_INT  = 0.0
      BO_D_INT  = 0.0
      UO_D_INT  = 0.0
c-----useful values
      pi = 3.1415926535
      eightpisq = 8.0*pi*pi
      VOLUME = CS_CELL(1) * CS_CELL(2) * CS_CELL(3) *
     &         (1 - COS(CS_CELL(4))**2 - COS(CS_CELL(5))**2 - 
     &         COS(CS_CELL(6))**2 +
     &         (2 * COS(CS_CELL(4)) * COS(CS_CELL(5)) * 
     &         COS(CS_CELL(6))))**0.5
      VOLUME4 = VOLUME * 4
c-----the relevant tabulated elements for intertomic distance = 0 are
c     put into a 1-dimensional array and the grid points for B are defined
      DO i = 1,dimB
         B_POINT(i) = B_MIN+(i-1)*stripB
         PP_D(i)    = PP1(1,i) 
         BB_D(i)    = BB(1,i)
         UU1_D(i)   = UU1(1,i)
         UU3_D(i)   = UU3(1,i)
         OO_D(i)    = OO(1,i)
         BO_D(i)    = BO(1,i)
         UO_D(i)    = UO1(1,i)
      ENDDO
c-----initialisation for subroutine LINTER_VALUE2
      I_INTER = -1
c-----calculation of isotropic B values
      IF (U_ANISO(2,ATOM_IND).le.0.0) THEN 
          B_ISO = eightpisq*U_ANISO(1,ATOM_IND)
      ELSE
          B_ISO = ((U_ANISO(1,ATOM_IND)+U_ANISO(2,ATOM_IND)+
     &              U_ANISO(3,ATOM_IND))/3.0)*eightpisq
      ENDIF
c-----loop over the number of gaussians
      DO i = 1,NGAUS2
         B_CURR = 2.0*B_ISO+CS_BB(i,(ID_SF(ATOM_IND)))
c--------positional
         CALL LINTER_VALUE2(dimB,B_point,PP_D,B_CURR,I_INTER,
     &                      PP_CURR)
         VAL_PP = CS_AA(i,(ID_SF(ATOM_IND)))*PP_CURR
         PP_D_INT = PP_D_INT + VAL_PP
c--------ISO BB and BQ
         IF (U_ANISO(2,ATOM_IND).LE.0.0) THEN
            CALL LINTER_VALUE2(dimB,B_point,BB_D,B_CURR,I_INTER,
     &                      BB_CURR)
            VAL_BB = CS_AA(i,(ID_SF(ATOM_IND)))*BB_CURR
            BB_D_INT = BB_D_INT + VAL_BB
            CALL LINTER_VALUE2(dimB,B_point,BO_D,B_CURR,I_INTER,
     &                      BO_CURR)
            VAL_BO = CS_AA(i,(ID_SF(ATOM_IND)))*BO_CURR
            BO_D_INT = BO_D_INT + VAL_BO
c--------ANISO UU and UQ
         ELSE
            CALL LINTER_VALUE2(dimB,B_point,UU1_D,B_CURR,I_INTER,
     &                         UU1_CURR)
            CALL LINTER_VALUE2(dimB,B_point,UU3_D,B_CURR,I_INTER,
     &                         UU3_CURR)
            VAL_UU1 = CS_AA(i,(ID_SF(ATOM_IND)))*UU1_CURR
            VAL_UU3 = CS_AA(i,(ID_SF(ATOM_IND)))*UU3_CURR
            UU1_D_INT = UU1_D_INT + VAL_UU1
            UU3_D_INT = UU3_D_INT + VAL_UU3
            CALL LINTER_VALUE2(dimB,B_point,UO_D,B_CURR,I_INTER,
     &                         UO_CURR)
            VAL_UO = CS_AA(i,(ID_SF(ATOM_IND)))*UO_CURR
            UO_D_INT = UO_D_INT + VAL_UO
         ENDIF
c--------occupancy
         CALL LINTER_VALUE2(dimB,B_point,OO_D,B_CURR,I_INTER,
     &                      OO_CURR) 
         VAL_OO = CS_AA(i,(ID_SF(ATOM_IND)))*OO_CURR
         OO_D_INT = OO_D_INT + VAL_OO            
      ENDDO
c--------calculation of final values
         H_XX = OCCUP(ATOM_IND)**2 * PP_D_INT * VOLUME4
 
         IF (U_ANISO(2,ATOM_IND).LE.0.0) THEN
            H_UU(1) = OCCUP(ATOM_IND)**2 * BB_D_INT * VOLUME4 
     &        *eightpisq**2.
            H_UQ = OCCUP(ATOM_IND) * BO_D_INT * VOLUME4
c     &                  * eightpisq
         ELSE
            H_UU(1) = OCCUP(ATOM_IND)**2.0*UU1_D_INT * VOLUME4
             
            H_UU(2) = OCCUP(ATOM_IND)**2.0 * (UU1_D_INT+UU3_D_INT) *
     &                      VOLUME
            H_UU(3) = H_UU(2)*4.0
           
            H_UQ = OCCUP(ATOM_IND) * UO_D_INT * VOLUME4
         ENDIF
c  
         H_QQ = OO_D_INT * VOLUME4
c
      RETURN
      END
c
      SUBROUTINE FAST_HESSIAN_NONDIAGONAL(ATOM_IND1,ATOM_IND2,NSYM_D,
     &  H_XX,H_UU,H_QQ,H_XB,H_XU,H_XQ,H_QX,H_BQ,H_QB,H_UQ,H_QU)
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'weights.fh'
      include 'hessian_impl.fh'
c-----general variables
      INTEGER ATOM_IND1,ATOM_IND2
      INTEGER NSYM_D(4),iii,jjj
      REAL H_XX(3,3),H_UU(6,6),H_QQ,H_XB(3),H_XU(3,6),H_XQ(3),H_QX(3),  
     &     H_BQ,H_QB,H_UQ(6),H_QU(6),H_UU1(6,6),H_UU2(6,6),H_UU_SP(6,6),
     &     H_UU_SP1(6,6),H_XXTR(3,3),H_UUTR(6,6)
      REAL HXX,HUU(3),HUQ,HQQ,H_XX_SP(3,3),R_TEMP(3,3),RT(3,3),
     &     RT_T(3,3),R_INTERM(3,3),HXXSP(3,3),H_XXT(3,3)
c-----local variables
      integer i,j,n,m,IL,IB,T,U,ierror,ii,jj
      real a11,a12,a13,a21,a22,a23,a31,a32,a33
      real t11,t12,t13,t21,t22,t23,t31,t32,t33
      real DIFF(3),ANG(3),phi,theta,psi,sth
      real L_CURR,BP,LP,B_CURR,D_point(dimD),B_point(dimB)
      real B_ISO1,B_ISO2
      REAL XYZ_TMP(3),XYZ_TMP1(3)
      real VPP1,VPP2,VBB,VUU1,VUU2,VUU3,VUU4,VOO,VPB,VPU1,VPU2,VPO,
     &     VBU1,VBU2,VBO,VUO1,VUO2
      REAL HXXT(3,3),IH_XX(3,3),HUUT(6,6),HQQT,HXBT(3),HXUT(3,6),
     &     HXQT(3),HBQT,HUQT(6)
      real eightpisq,VOLUME4,GA
      real SMALL_BOND/0.001/,EPS_LOC/0.0001/
      LOGICAL ERROR
      character*15, atm_name_1,atm_name_2
      external LINBID,LINBID_FIX,MAT2VEC,MATT2MAT,MATTRANS,MAT2MAT,
     &         MAT2MATT
c
c-----initialisation
      DO i = 1,3
         DO j = 1,3
            H_XX(i,j) = 0.0
            H_XX_SP(i,j) = 0.0
            H_XB(j)   = 0.0
            H_XQ(j)   = 0.0
            H_QX(j)   = 0.0
         ENDDO
      ENDDO
      DO i = 1,6
         DO j = 1,6
            H_UU(i,j) = 0.0
            H_UU_SP(i,j) = 0.0
         ENDDO
      ENDDO      
      DO i = 1,3
         DO j = 1,6
            H_XU(i,j) = 0.0
            H_UQ(j)   = 0.0
            H_QU(j)   = 0.0
         ENDDO
      ENDDO
      H_QQ   = 0.0
      H_BQ   = 0.0
      H_QB   = 0.0
c-----useful constants
      eightpisq = 78.956835
      Dmax = 2*DVDW_CUT_MIN_X
      VOLUME = CS_CELL(1) * CS_CELL(2) * CS_CELL(3) *
     &        (1 - COS(CS_CELL(4))**2 - COS(CS_CELL(5))**2 - 
     &         COS(CS_CELL(6))**2 +
     &        (2 * COS(CS_CELL(4)) * COS(CS_CELL(5)) * 
     &         COS(CS_CELL(6))))**0.5
      VOLUME4 = VOLUME*4
c-----grid points distance and B
      do i = 1,dimD
         D_point(i) = (Dmin+(i-1)*stripD)
      enddo
      do i = 1,dimB
         B_point(i) = (B_MIN+(i-1)*stripB)
      enddo
c
      if (U_ANISO(2,ATOM_IND1).le.0.0) then 
          B_ISO1 = eightpisq*U_ANISO(1,ATOM_IND1)
      else
          B_ISO1 = ((U_ANISO(1,ATOM_IND1)+U_ANISO(2,ATOM_IND1)+
     &             U_ANISO(3,ATOM_IND1))/3.0)*eightpisq
      endif
c
      if (U_ANISO(2,ATOM_IND2).le.0.0) then 
          B_ISO2 = eightpisq*U_ANISO(1,ATOM_IND2)
      else
          B_ISO2 = ((U_ANISO(1,ATOM_IND2)+U_ANISO(2,ATOM_IND2)+
     &               U_ANISO(3,ATOM_IND2))/3.0)*eightpisq
      endif

c-----symmetry is applied to the second atom if reqired -POSITION
      IF(NSYM_D(1).LE.0) NSYM_D(1) = 1
      IF(NSYM_D(1).NE.1.OR.NSYM_D(2).NE.0.OR.NSYM_D(3).NE.0.OR.
     &   NSYM_D(4).NE.0) THEN
c--------first fractionalise
         CALL MAT2VEC(3,3,CS_ORT_TO_FRAC,XYZ_CRD(1,ATOM_IND2),XYZ_TMP,
     &             ERROR)
c--------then apply symmetry
         DO i = 1,3
            XYZ_TMP1(i) = RealSymmMatrx(i,1,NSYM_D(1))*XYZ_TMP(1) +
     &                    RealSymmMatrx(i,2,NSYM_D(1))*XYZ_TMP(2) +
     &                    RealSymmMatrx(i,3,NSYM_D(1))*XYZ_TMP(3) +
     &                 RealSymmMatrx(i,4,NSYM_D(1)) + REAL(NSYM_D(i+1))
         ENDDO 
c--------and finally orthogonalise back
         CALL MAT2VEC(3,3,CS_FRAC_TO_ORT,XYZ_TMP1,XYZ_TMP,ERROR)

c------take care of atoms in special positions
         IF (ATOM_IND1.EQ.ATOM_IND2) THEN
            CALL FAST_HESSIAN_DIAGONAL(ATOM_IND1,HXX,HUU,HUQ,HQQ) 
            DO i = 1,3
               DO j = 1,3
                  IF (i.EQ.j) THEN
                    H_XX_SP(i,j) = HXX
                  ELSE
                    H_XX_SP(i,j) = 0.0
                  ENDIF
               ENDDO
            ENDDO 
            IF (U_ANISO(2,ATOM_IND1).GT.0.0) THEN
               DO   i=1,6
                 DO  j=1,6
                   H_UU_SP(i,j) = 0.0
                 ENDDO
               ENDDO
                H_UU_SP(1,1) = HUU(1)
                H_UU_SP(2,2) = HUU(1)
                H_UU_SP(3,3) = HUU(1)
                H_UU_SP(4,4) = HUU(3)
                H_UU_SP(5,5) = HUU(3)
                H_UU_SP(6,6) = HUU(3)
                H_UU_SP(1,2) = HUU(2)
                H_UU_SP(1,3) = HUU(2)
                H_UU_SP(2,3) = HUU(2)
                H_UU_SP(2,1) = HUU(2)
                H_UU_SP(3,1) = HUU(2)
                H_UU_SP(3,2) = HUU(2)
            ELSE
               H_UU_SP(1,1) = HUU(1)
            ENDIF       
c
c            call full_atom_name(ATOM_IND1,atm_name_1,ierror)
c            call full_atom_name(ATOM_IND2,atm_name_2,ierror)
c            WRITE(*,*) atm_name_1,atm_name_2 
c            WRITE(*,*) ATOM_IND1,ATOM_IND2,L_CURR
         ENDIF   
      ELSE
         XYZ_TMP(1) = XYZ_CRD(1,ATOM_IND2)
         XYZ_TMP(2) = XYZ_CRD(2,ATOM_IND2)
         XYZ_TMP(3) = XYZ_CRD(3,ATOM_IND2)
      ENDIF
      do i = 1,3
         DIFF(i) =  xyz_crd(i,ATOM_IND1)- XYZ_TMP(i)
      enddo
      L_CURR = sqrt(DIFF(1)**2+DIFF(2)**2+DIFF(3)**2)
      IF(ATOM_IND1.EQ.ATOM_IND2) 
     &  print*, 'special position -----------', L_CURR
      if(L_CURR.le.SMALL_BOND) L_CURR = SMALL_BOND
      IF(L_CURR.GT.dmax) return
      do i = 1,3
         ANG(i) = acos(DIFF(i)/L_CURR)  
      enddo
      theta = ANG(3)
      sth   = sin(theta)
      if (sth.eq.0.0) then
         theta = 0.0
         phi = 0.0
         psi =0.0  
         a11=1.0
         a22=1.0
         a33=1.0
         a12=0.0
         a13=0.0
         a21=0.0
         a23=0.0
         a31=0.0
         a32=0.0
         goto 50
      else
        phi = cos(ANG(2))/sin(theta)
        if (phi.gt.1.0) phi = 1.0
        if (phi.lt.-1.0) phi = -1.0
        phi = asin(phi) 
        if (DIFF(1).lt.0.0) then
           theta = -theta
           phi = -phi
        endif
        psi = 0.0
       
c-------rotation matrix Z(phi)Y'(theta)X''(psi)
        a11 =  cos(psi)*cos(theta)*cos(phi)-sin(psi)*sin(phi)
        a12 =  cos(psi)*cos(theta)*sin(phi)+sin(psi)*cos(phi)
        a13 = -cos(psi)*sin(theta)
        a21 = -sin(psi)*cos(theta)*cos(phi)-cos(psi)*sin(phi) 
        a22 = -sin(psi)*cos(theta)*sin(phi)+cos(psi)*cos(phi) 
        a23 =  sin(psi)*sin(theta)
        a31 =  sin(theta)*cos(phi)
        a32 =  sin(theta)*sin(phi)
        a33 =  cos(theta)
      endif
50    continue
      
c-------transpose of rotation matrix Z(phi)Y'(theta)X''(psi)
c-------this brings us back to the orthogonal crystal system
      t11 = a11
      t12 = a21
      t13 = a31
      t21 = a12
      t22 = a22
      t23 = a32
      t31 = a13
      t32 = a23
      t33 = a33

      DO n = 1,ngaus
         DO m = 1,ngaus
            B_CURR = B_ISO1+B_ISO2+
     &               CS_B(n,ID_SF(ATOM_IND1))+CS_B(m,ID_SF(ATOM_IND2))
            GA = CS_A(n,ID_SF(ATOM_IND1))*CS_A(m,ID_SF(ATOM_IND2))
c
            CALL LINBID(MdimD,MdimB,dimD,dimB,D_point,B_point,PP1,
     &                  L_CURR,B_CURR,VPP1,IL,IB,T,U)
            CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,PP2,IL,IB,T,U,VPP2)
            CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,OO,IL,IB,T,U,VOO)
            CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,PO,IL,IB,T,U,VPO)
            IF (U_ANISO(2,ATOM_IND1).le.0.0.and.
     &          U_ANISO(2,ATOM_IND2).le.0.0) THEN
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,BB,IL,IB,T,U,VBB) 
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,BO,IL,IB,T,U,VBO)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,PB,IL,IB,T,U,VPB)
            ELSEIF (U_ANISO(2,ATOM_IND1).gt.0.0.and.
     &           U_ANISO(2,ATOM_IND2).gt.0.0) THEN
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          UU1,IL,IB,T,U,VUU1)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          UU2,IL,IB,T,U,VUU2)  
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          UU3,IL,IB,T,U,VUU3)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          UU4,IL,IB,T,U,VUU4)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          UO1,IL,IB,T,U,VUO1)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          UO2,IL,IB,T,U,VUO2)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          PU1,IL,IB,T,U,VPU1)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          PU2,IL,IB,T,U,VPU2)
            ELSE
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          BU1,IL,IB,T,U,VBU1)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          BU2,IL,IB,T,U,VBU2)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          BO,IL,IB,T,U,VBO)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          PB,IL,IB,T,U,VPB)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          UO1,IL,IB,T,U,VUO1)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          UO2,IL,IB,T,U,VUO2)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          PU1,IL,IB,T,U,VPU1)
                CALL LINBID_FIX(MdimD,MdimB,dimD,dimB,
     &                          PU2,IL,IB,T,U,VPU2)
            ENDIF
c-------------positional
            HXXT(1,1) = (t11**2+t12**2)*VPP1+(t13**2)*VPP2
            HXXT(1,2) = (t11*t21 + t12*t22)*VPP1+(t13*t23)*VPP2
            HXXT(1,3) = (t11*t31 + t12*t32)*VPP1+(t13*t33)*VPP2
            HXXT(2,1) =  HXXT(1,2)
            HXXT(2,2) = (t21**2+t22**2)*VPP1+(t23**2)*VPP2
            HXXT(2,3) = (t21*t31 + t22*t32)*VPP1+(t23*t33)*VPP2
            HXXT(3,1) =  HXXT(1,3)
            HXXT(3,2) =  HXXT(2,3)
            HXXT(3,3) = (t31**2+t32**2)*VPP1+(t33**2)*VPP2
            DO i = 1,3
               DO j = 1,3
                  HXXT(i,j) = GA*HXXT(i,j)
                  H_XX(i,j) = H_XX(i,j)+HXXT(i,j)
               ENDDO
            ENDDO
            
c------------occupancy
            HQQT = GA*VOO
            H_QQ = H_QQ+HQQT
c------------position-occupancy
            HXQT(1) = t13*VPO
            HXQT(2) = t23*VPO
            HXQT(3) = t33*VPO
            DO i = 1,3
               HXQT(i) = GA*HXQT(i)
               H_XQ(i) = H_XQ(i)+HXQT(i)
            ENDDO
            IF (U_ANISO(2,ATOM_IND1).le.0.0.and.
     &         U_ANISO(2,ATOM_IND2).le.0.0) THEN
c--------------BB
               HUUT(1,1) = GA*VBB
               H_UU(1,1) = H_UU(1,1)+HUUT(1,1)
c---------------B-occupancy
               HBQT = GA*VBO
               H_BQ = H_BQ+HBQT
c---------------position-B
               HXBT(1) = t13*VPB
               HXBT(2) = t23*VPB
               HXBT(3) = t33*VPB
               DO i = 1,3
                  HXBT(i) = GA*HXBT(i)
                  H_XB(i) = H_XB(i)+HXBT(i)
               ENDDO
            ELSEIF (U_ANISO(2,ATOM_IND1).gt.0.0.and.
     &         U_ANISO(2,ATOM_IND2).gt.0.0) THEN
               HUUT(1,1) = (t11**4+t12**4)*VUU1 +
     &                    t13**4*VUU2 +
     &                    6*t11**2*t12**2*VUU3 + 
     &              6*t13**2*(t11**2+t12**2)*VUU4
               HUUT(1,2) = ((t11**2*t21**2+t12**2*t22**2)*VUU1+
     &                    t13**2*t23**2*VUU2 +
     &          ((t11*t22+t12*t21)**2 + 2*t11*t21*t12*t22)*VUU3 + 
     &            ((t11*t23+t13*t21)**2 + 2*t11*t21*t13*t23 +
     &            (t12*t23+t13*t22)**2 + 2*t12*t22*t13*t23)*VUU4)
               HUUT(1,3) = ((t11**2*t31**2+t12**2*t32**2)*VUU1+
     &                    t13**2*t33**2*VUU2 +
     &          ((t11*t32+t12*t31)**2 + 2*t11*t31*t12*t32)*VUU3 + 
     &             ((t11*t33+t13*t31)**2 + 2*t11*t31*t13*t33 +
     &            (t12*t33+t13*t32)**2 + 2*t12*t32*t13*t33)*VUU4)
               HUUT(1,4) =2*((t11**2*t11*t21+t12**2*t12*t22)*VUU1+
     &                         t13**2*t13*t23*VUU2 +
     &                      (2*t11*t12*(t11*t22+t12*t21)+
     &                      t11**2*t12*t22+t12**2*t11*t21)*VUU3 + 
     &                      (2*t11*t13*(t11*t23+t13*t21)+
     &                      t11**2*t13*t23+t13**2*t11*t21 +
     &                       2*t12*t13*(t12*t23+t13*t22)+
     &                      t12**2*t13*t23+t13**2*t12*t22)*VUU4)
               HUUT(1,5) =2*((t11**2*t11*t31+t12**2*t12*t32)*VUU1+
     &                         t13**2*t13*t33*VUU2 +
     &                      (2*t11*t12*(t11*t32+t12*t31)+
     &                      t11**2*t12*t32+t12**2*t11*t31)*VUU3 + 
     &                      (2*t11*t13*(t11*t33+t13*t31)+
     &                      t11**2*t13*t33+t13**2*t11*t31 +
     &                       2*t12*t13*(t12*t33+t13*t32)+
     &                      t12**2*t13*t33+t13**2*t12*t32)*VUU4)
               HUUT(1,6) =2*((t11**2*t21*t31+t12**2*t22*t32)*VUU1+
     &                         t13**2*t23*t33*VUU2 +
     &                      (2*t11*t12*(t21*t32+t22*t31)+
     &                      t11**2*t22*t32+t12**2*t21*t31)*VUU3 + 
     &                      (2*t11*t13*(t21*t33+t23*t31)+
     &                      t11**2*t23*t33+t13**2*t21*t31 +
     &                       2*t12*t13*(t22*t33+t23*t32)+
     &                      t12**2*t23*t33+t13**2*t22*t32)*VUU4)
               HUUT(2,1) = HUUT(1,2)
               HUUT(2,2) = (t21**4+t22**4)*VUU1 +
     &                    t23**4*VUU2 +
     &                    6.0*t21**2*t22**2*VUU3 + 
     &              6.0*t23**2*(t21**2+t22**2)*VUU4
               HUUT(2,3) = ((t21**2*t31**2+t22**2*t32**2)*VUU1+
     &                    t23**2*t33**2*VUU2 +
     &          ((t21*t32+t22*t31)**2 + 2*t21*t31*t22*t32)*VUU3 + 
     &             ((t21*t33+t23*t31)**2 + 2*t21*t31*t23*t33 +
     &            (t22*t33+t23*t32)**2 + 2*t22*t32*t23*t33)*VUU4)
               HUUT(2,4) =2*((t21**2*t11*t21+t22**2*t12*t22)*VUU1+
     &                         t23**2*t13*t23*VUU2 +
     &                      (2*t21*t22*(t11*t22+t12*t21)+
     &                      t21**2*t12*t22+t22**2*t11*t21)*VUU3 + 
     &                      (2*t21*t23*(t11*t23+t13*t21)+
     &                      t21**2*t13*t23+t23**2*t11*t21 +
     &                       2*t22*t23*(t12*t23+t13*t22)+
     &                      t22**2*t13*t23+t23**2*t12*t22)*VUU4)
               HUUT(2,5) =2*((t21**2*t11*t31+t22**2*t12*t32)*VUU1+
     &                         t23**2*t13*t33*VUU2 +
     &                      (2*t21*t22*(t11*t32+t12*t31)+
     &                      t21**2*t12*t32+t22**2*t11*t31)*VUU3 + 
     &                      (2*t21*t23*(t11*t33+t13*t31)+
     &                      t21**2*t13*t33+t23**2*t11*t31 +
     &                       2*t22*t23*(t12*t33+t13*t32)+
     &                      t22**2.*t13*t33+t23**2*t12*t32)*VUU4)
               HUUT(2,6) =2*((t21**2*t21*t31+t22**2*t22*t32)*VUU1+
     &                         t23**2*t23*t33*VUU2 +
     &                      (2*t21*t22*(t21*t32+t22*t31)+
     &                      t21**2*t22*t32+t22**2*t21*t31)*VUU3 + 
     &                      (2.*t21*t23*(t21*t33+t23*t31)+
     &                      t21**2*t23*t33+t23**2*t21*t31 +
     &                       2*t22*t23*(t22*t33+t23*t32)+
     &                      t22**2*t23*t33+t23**2*t22*t32)*VUU4)
               HUUT(3,1) = HUUT(1,3)
               HUUT(3,2) = HUUT(2,3)
               HUUT(3,3) = (t31**4+t32**4)*VUU1 +
     &                    t33**4*VUU2 +
     &                    6.0*t31**2*t32**2*VUU3 + 
     &              6.0*t33**2*(t31**2+t32**2)*VUU4
               HUUT(3,4) =2*((t31**2*t11*t21+t32**2*t12*t22)*VUU1+
     &                         t33**2*t13*t23*VUU2 +
     &                      (2.*t31*t32*(t11*t22+t12*t21)+
     &                      t31**2.*t12*t22+t32**2.*t11*t21)*VUU3 + 
     &                      (2.*t31*t33*(t11*t23+t13*t21)+
     &                      t31**2.*t13*t23+t33**2.*t11*t21 +
     &                       2.*t32*t33*(t12*t23+t13*t22)+
     &                      t32**2.*t13*t23+t33**2.*t12*t22)*VUU4)
               HUUT(3,5) =2*((t31**2*t11*t31+t32**2*t12*t32)*VUU1+
     &                         t33**2*t13*t33*VUU2 +
     &                      (2.*t31*t32*(t11*t32+t12*t31)+
     &                      t31**2.*t12*t32+t32**2.*t11*t31)*VUU3 + 
     &                      (2.*t31*t33*(t11*t33+t13*t31)+
     &                      t31**2.*t13*t33+t33**2.*t11*t31 +
     &                       2.*t32*t33*(t12*t33+t13*t32)+
     &                      t32**2.*t13*t33+t33**2.*t12*t32)*VUU4)
               HUUT(3,6) =2*((t31**2*t21*t31+t32**2*t22*t32)*VUU1+
     &                         t33**2*t23*t33*VUU2 +
     &                      (2.*t31*t32*(t21*t32+t22*t31)+
     &                      t31**2.*t22*t32+t32**2.*t21*t31)*VUU3 + 
     &                      (2.*t31*t33*(t21*t33+t23*t31)+
     &                      t31**2.*t23*t33+t33**2.*t21*t31 +
     &                       2.*t32*t33*(t22*t33+t23*t32)+
     &                      t32**2.*t23*t33+t33**2.*t22*t32)*VUU4)
               HUUT(4,1) = HUUT(1,4)
               HUUT(4,2) = HUUT(2,4)
               HUUT(4,3) = HUUT(3,4)
               HUUT(4,4) = 4*HUUT(1,2)
               HUUT(4,5) = HUUT(1,6)*2 
               HUUT(4,6) = HUUT(2,5)*2
               HUUT(5,1) = HUUT(1,5)
               HUUT(5,2) = HUUT(2,5)
               HUUT(5,3) = HUUT(3,5)
               HUUT(5,4) = HUUT(4,5)   
               HUUT(5,5) = 4*HUUT(1,3)
               HUUT(5,6) = HUUT(3,4)*2
               HUUT(6,1) = HUUT(1,6)
               HUUT(6,2) = HUUT(2,6)
               HUUT(6,3) = HUUT(3,6)
               HUUT(6,4) = HUUT(4,6)
               HUUT(6,5) = HUUT(5,6)
               HUUT(6,6) = 4*HUUT(2,3)
               DO i = 1,6
                  DO j = 1,6
                     HUUT(i,j) = GA*HUUT(i,j)
                     H_UU(i,j) = H_UU(i,j)+HUUT(i,j)
                  ENDDO
               ENDDO
c-------------U-occupancy
               HUQT(1)=(t11**2+t12**2)*VUO1 + t13**2*VUO2
               HUQT(2)=(t21**2+t22**2)*VUO1 + t23**2*VUO2
               HUQT(3)=(t31**2+t32**2)*VUO1  + t33**2*VUO2
               HUQT(4)=2.*((t11*t21+t12*t22)*VUO1 + t13*t23*VUO2)
               HUQT(5)=2.*((t11*t31+t12*t32)*VUO1 + t13*t33*VUO2) 
               HUQT(6)=2.*((t21*t31+t22*t32)*VUO1 + t23*t33*VUO2)
               DO i = 1,6
                  HUQT(i) = GA*HUQT(i)
                  H_UQ(i) = H_UQ(i)+HUQT(i)
               ENDDO
c-------------U-position
               HXUT(1,1) = 3*(t11**2*t13+t12**2*t13)*VPU1+ 
     &                          t13**3*VPU2
               HXUT(1,2) = (2*t11*t21*t23+2*t12*t22*t23+
     &                          t13*(t21**2+t22**2))*VPU1 + 
     &                           t13*t23**2*VPU2
               HXUT(1,3) = (2*t11*t31*t33+2*t12*t32*t33+
     &                          t13*(t31**2+t32**2))*VPU1 + 
     &                          t13*t33**2*VPU2
               HXUT(1,4) = 2*((2*t21*t11*t13+2*t22*t12*t13+
     &                          t23*(t11**2+t12**2))*VPU1 + 
     &                          t23*t13**2*VPU2) 
               HXUT(1,5) = 2*((2*t31*t11*t13+2*t32*t12*t13+
     &                          t33*(t11**2+t12**2))*VPU1 + 
     &                          t33*t13**2*VPU2) 
               HXUT(1,6) = 2*((t11*(t21*t33+t23*t31)+t12*
     &                    (t22*t33+t23*t32)+t13*(t21*t31+t22*t32))*VPU1+ 
     &                    t13*t23*t33*VPU2)
               HXUT(2,1) = HXUT(1,4)/2  
               HXUT(2,2) = 3*(t21**2*t23+t22**2*t23)*VPU1+ 
     &                          t23**3*VPU2
               HXUT(2,3) = (2*t21*t31*t33+2*t22*t32*t33+
     &                          t23*(t31**2+t32**2))*VPU1 + 
     &                          t23*t33**2*VPU2
               HXUT(2,4) = 2*HXUT(1,2)
               HXUT(2,5) = HXUT(1,6)
               HXUT(2,6) = 2*((2*t31*t21*t23+2*t32*t22*t23+
     &                          t33*(t21**2+t22**2))*VPU1 + 
     &                          t33*t23**2*VPU2)
               HXUT(3,1) = HXUT(1,5)/2
               HXUT(3,2) = HXUT(2,6)/2
               HXUT(3,3) = 3*(t31**2*t33+t32**2*t33)*VPU1 + 
     &                          t33**3*VPU2  
               HXUT(3,4) = HXUT(1,6)
               HXUT(3,5) = 2*HXUT(1,3)
               HXUT(3,6) = 2*HXUT(2,3)
               DO i = 1,3
                  DO j = 1,6
                     HXUT(i,j) = GA*HXUT(i,j)
                     H_XU(i,j) = H_XU(i,j)+HXUT(i,j)
                  ENDDO
               ENDDO
            ELSE
c---------------B-U elements
               HUUT(1,1) = (t11**2+t12**2)*VBU1 + t13**2*VBU2
               HUUT(2,1) = (t21**2+t22**2)*VBU1 + t23**2*VBU2
               HUUT(3,1) = (t31**2+t32**2)*VBU1 + t33**2.0*VBU2 
               HUUT(4,1) = 2*((t11*t21+t12*t22)*VBU1 + t13*t23*VBU2)
               HUUT(5,1) = 2*((t11*t31+t12*t32)*VBU1 + t13*t33*VBU2) 
               HUUT(6,1) = 2*((t21*t31+t22*t32)*VBU1 + t23*t33*VBU2) 
               DO i = 1,6
                  HUUT(i,1) = GA*HUUT(i,1)
                  H_UU(i,1) = H_UU(i,1)+HUUT(i,1)
               ENDDO
c---------------B-occupancy
               HBQT = GA*VBO
               H_BQ = H_BQ+HBQT
c---------------position-B
               HXBT(1) = t13*VPB
               HXBT(2) = t23*VPB
               HXBT(3) = t33*VPB
               DO i = 1,3
                  HXBT(i) = GA*HXBT(i)
                  H_XB(i) = H_XB(i)+HXBT(i)
               ENDDO
c---------------U-occupancy
               HUQT(1)=(t11**2+t12**2)*VUO1 + t13**2*VUO2
               HUQT(2)=(t21**2+t22**2)*VUO1 + t23**2*VUO2
               HUQT(3)=(t31**2+t32**2)*VUO1  + t33**2*VUO2
               HUQT(4)=2.*((t11*t21+t12*t22)*VUO1 + t13*t23*VUO2)
               HUQT(5)=2.*((t11*t31+t12*t32)*VUO1 + t13*t33*VUO2) 
               HUQT(6)=2.*((t21*t31+t22*t32)*VUO1 + t23*t33*VUO2)
               DO i = 1,6
                  HUQT(i) = GA*HUQT(i)
                  H_UQ(i) = H_UQ(i)+HUQT(i)
               ENDDO
c---------------U-position
               HXUT(1,1) = 3*(t11**2*t13+t12**2*t13)*VPU1+ 
     &                          t13**3*VPU2
               HXUT(1,2) = (2*t11*t21*t23+2*t12*t22*t23+
     &                          t13*(t21**2+t22**2))*VPU1 + 
     &                           t13*t23**2*VPU2
               HXUT(1,3) = (2*t11*t31*t33+2*t12*t32*t33+
     &                          t13*(t31**2+t32**2))*VPU1 + 
     &                          t13*t33**2*VPU2
               HXUT(1,4) = 2*((2*t21*t11*t13+2*t22*t12*t13+
     &                          t23*(t11**2+t12**2))*VPU1 + 
     &                          t23*t13**2*VPU2) 
               HXUT(1,5) = 2*((2*t31*t11*t13+2*t32*t12*t13+
     &                          t33*(t11**2+t12**2))*VPU1 + 
     &                          t33*t13**2*VPU2) 
               HXUT(1,6) = 2*((t11*(t21*t33+t23*t31)+t12*
     &                    (t22*t33+t23*t32)+t13*(t21*t31+t22*t32))*VPU1+ 
     &                    t13*t23*t33*VPU2)
               HXUT(2,1) = HXUT(1,4)/2  
               HXUT(2,2) = 3*(t21**2*t23+t22**2*t23)*VPU1+ 
     &                          t23**3*VPU2
               HXUT(2,3) = (2*t21*t31*t33+2*t22*t32*t33+
     &                          t23*(t31**2+t32**2))*VPU1 + 
     &                          t23*t33**2*VPU2
               HXUT(2,4) = 2*HXUT(1,2)
               HXUT(2,5) = HXUT(1,6)
               HXUT(2,6) = 2*((2*t31*t21*t23+2*t32*t22*t23+
     &                          t33*(t21**2+t22**2))*VPU1 + 
     &                          t33*t23**2*VPU2)
               HXUT(3,1) = HXUT(1,5)/2
               HXUT(3,2) = HXUT(2,6)/2
               HXUT(3,3) = 3*(t31**2*t33+t32**2*t33)*VPU1 + 
     &                          t33**3*VPU2  
               HXUT(3,4) = HXUT(1,6)
               HXUT(3,5) = 2*HXUT(1,3)
               HXUT(3,6) = 2*HXUT(2,3)
            
               DO i = 1,3
                  DO j = 1,6
                     HXUT(i,j) = GA*HXUT(i,j)
                     H_XU(i,j) = H_XU(i,j)+HXUT(i,j)
                  ENDDO
               ENDDO
            ENDIF
         ENDDO       
      ENDDO
c------FINAL CALCULATIONS
c------XX
c------modification for if symmetry is present
      IF (NSYM_D(1).GT.1) THEN
         CALL MATT2MAT(3,3,CS_FRAC_TO_ORT,H_XX,HXXT,ERROR)
         DO i = 1,3
            DO j = 1,3
               IH_XX(i,j) = RealSymmMatrx(1,i,NSYM_D(1))*HXXT(1,j) +
     &                      RealSymmMatrx(2,i,NSYM_D(1))*HXXT(2,j) +
     &                      RealSymmMatrx(3,i,NSYM_D(1))*HXXT(3,j)  
            ENDDO
         ENDDO
         CALL MATT2MAT(3,3,CS_ORT_TO_FRAC,IH_XX,H_XX,ERROR)   
      ENDIF
c------occup and other and special positions
      IF (ATOM_IND1.NE.ATOM_IND2) THEN
         DO i = 1,3
            DO j = 1,3
               H_XX(i,j) = OCCUP(ATOM_IND1)*OCCUP(ATOM_IND2)*
     &                     H_XX(i,j)*VOLUME4
            ENDDO
         ENDDO
      ELSE
         CALL MATTRANS(3,3,H_XX,H_XXTR,ERROR)
c
         CALL MATT2MAT(3,3,CS_FRAC_TO_ORT,H_XX_SP,R_INTERM,ERROR)
         CALL MAT2MAT(3,3,R_INTERM,CS_FRAC_TO_ORT,H_XX_SP,ERROR)
         DO   I=1,3
           DO   J=1,3
             R_INTERM(I,J) = RealSymmMatrx(1,I,NSYM_D(1))*H_XX_SP(1,J)+
     &                       RealSymmMatrx(2,I,NSYM_D(1))*H_XX_SP(2,J)+
     &                       RealSymmMatrx(3,I,NSYM_D(1))*H_XX_SP(3,J)
           ENDDO
         ENDDO
C
         DO   I=1,3
           DO   J=1,3
             H_XX_SP(I,J) = 
     &                 R_INTERM(I,1)*RealSymmMatrx(1,J,NSYM_D(1))+
     &                 R_INTERM(I,2)*RealSymmMatrx(2,J,NSYM_D(1))+
     &                 R_INTERM(I,3)*RealSymmMatrx(3,J,NSYM_D(1))
           ENDDO
         ENDDO

         CALL MATT2MAT(3,3,CS_ORT_TO_FRAC,H_XX_SP,R_INTERM,ERROR)
         CALL MAT2MAT(3,3,R_INTERM,CS_ORT_TO_FRAC,H_XX_SP,ERROR)

cd         CALL MAT2MAT(3,3,RealSymmMatrx(1,1,NSYM_D(1)),
cd     &                CS_ORT_TO_FRAC,R_TEMP,ERROR)
cd         CALL MAT2MAT(3,3,CS_FRAC_TO_ORT,R_TEMP,RT,ERROR)
cd         CALL MATTRANS(3,3,RT,RT_T,ERROR)
cd         CALL MAT2MAT(3,3,H_XX_SP,RT,R_INTERM,ERROR)
cd         CALL MAT2MAT(3,3,RT_T,R_INTERM,H_XX_SP,ERROR)
c
         DO i = 1,3
            DO j = 1,3
               H_XX(i,j) = H_XX(i,j) + H_XXTR(i,j)
               H_XX(i,j) = OCCUP(ATOM_IND1)*OCCUP(ATOM_IND2)*
     &                     H_XX(i,j)*VOLUME4 + H_XX_SP(i,j)
            ENDDO
         ENDDO
      ENDIF
c-----QQ
      H_QQ = H_QQ*VOLUME4
c-----XQ and QX
      DO i = 1,3
         H_XQ(i) = OCCUP(ATOM_IND1)*H_XQ(i)*VOLUME4
         IF (OCCUP(ATOM_IND1).NE.OCCUP(ATOM_IND2)) THEN
            H_QX(i) = (H_XQ(i)/OCCUP(ATOM_IND1))*OCCUP(ATOM_IND2)
         ELSE
            H_QX(i) = H_XQ(i)
         ENDIF
      ENDDO
c-----different possibilities for ISOT,ANISO or MIXED
c-----ISOT  
      IF (U_ANISO(2,ATOM_IND1).le.0.0.and.U_ANISO(2,ATOM_IND2).le.0.0) 
     &                                                           THEN
c----------BB
         IF (ATOM_IND1.NE.ATOM_IND2) THEN   
            H_UU(1,1) = OCCUP(ATOM_IND1)*OCCUP(ATOM_IND2)*
     &                  H_UU(1,1)*VOLUME4
     &                  *(eightpisq)**2.0
            
         ELSE
            H_UU(1,1) = 2.0*H_UU(1,1)
            H_UU(1,1) = (OCCUP(ATOM_IND1)**2.0)*
     &                  H_UU(1,1)*VOLUME4
     &                  *((eightpisq)**2.0) + H_UU_SP(1,1)
         ENDIF         
c----------BQ and QB
         H_BQ = OCCUP(ATOM_IND1)*H_BQ*VOLUME4
c    &             *eightpisq
         IF (OCCUP(ATOM_IND1).NE.OCCUP(ATOM_IND2)) THEN
            H_QB = (H_BQ/OCCUP(ATOM_IND1))*OCCUP(ATOM_IND2)
         ELSE
            H_QB = H_BQ
         ENDIF
c--------PB
         DO i = 1,3
            H_XB(i) = OCCUP(ATOM_IND1)*OCCUP(ATOM_IND2)*
     &                H_XB(i)*VOLUME4
c    &                 *eightpisq
         ENDDO
      ELSEIF (U_ANISO(2,ATOM_IND1).gt.0.0.and.
     &  U_ANISO(2,ATOM_IND2).gt.0.0) THEN
c-------UU
         IF (NSYM_D(1).GT.1) THEN
            CALL MAT2MAT(6,6,UUCELL2ORTH,H_UU,H_UU1,ERROR)
            CALL MAT2MAT(6,6,RealSymm_Aniso(1,1,NSYM_D(1)),H_UU1,
     &                   H_UU2,ERROR)
            CALL MAT2MAT(6,6,UUORTH2CELL,H_UU2,H_UU,ERROR)
         ENDIF
         IF (ATOM_IND1.NE.ATOM_IND2) THEN
            DO i = 1,6
               DO j = 1,6
                  H_UU(i,j) = OCCUP(ATOM_IND1)*OCCUP(ATOM_IND2)*
     &                     H_UU(i,j)*VOLUME4
               ENDDO
            ENDDO
         ELSE
            CALL MATTRANS(6,6,H_UU,H_UUTR,ERROR)
c
            CALL MAT2MAT(6,6,UUCELL2ORTH,H_UU_SP,H_UU_SP1,ERROR)
            CALL MAT2MATT(6,6,H_UU_SP1,UUCELL2ORTH,H_UU_SP,ERROR)
            CALL MAT2MAT(6,6,RealSymm_Aniso(1,1,NSYM_D(1)),H_UU_SP,
     &                   H_UU_SP1,ERROR)
            CALL MAT2MATT(6,6,H_UU_SP1,RealSymm_Aniso(1,1,NSYM_D(1)),
     &                   H_UU_SP,ERROR)
            CALL MAT2MAT(6,6,UUORTH2CELL,H_UU_SP,H_UU_SP1,ERROR)
            CALL MAT2MATT(6,6,H_UU_SP1,UUORTH2CELL,H_UU_SP,ERROR)
c
            DO i = 1,6
               DO j = 1,6
                  H_UU(i,j) = H_UU(i,j) + H_UUTR(i,j) 
                  H_UU(i,j) = (OCCUP(ATOM_IND1)**2.0)*
     &                        H_UU(i,j)*VOLUME4 + H_UU_SP(i,j)    
               ENDDO
            ENDDO
cd            DO  I=1,6
cd              WRITE(*,*)(H_UU(I,J),J=1,6)
cd              WRITE(*,*)
cd     &           (H_UUTR(i,j)*(OCCUP(ATOM_IND1)**2.0)*VOLUME4,j=1,6)
cd              WRITE(*,*)(H_UU_SP(i,j),j=1,6)
cd              WRITE(*,*)
cd            ENDDO
          ENDIF
c----------UQ and QU
         DO i = 1,6
            H_UQ(i) = OCCUP(ATOM_IND1)*H_UQ(i)*VOLUME4
            IF (OCCUP(ATOM_IND1).NE.OCCUP(ATOM_IND2)) THEN
               H_QU(i) = (H_UQ(i)/OCCUP(ATOM_IND1))*OCCUP(ATOM_IND2)
            ELSE
               H_QU(i) = H_UQ(i)
            ENDIF
         ENDDO
c--------XU
         DO i = 1,3
            DO j = 1,6
               H_XU(i,j) = OCCUP(ATOM_IND1)*OCCUP(ATOM_IND2)*
     &                     H_XU(i,j)*VOLUME4
            ENDDO
         ENDDO
      ELSE
c--------BU
         DO i = 1,6
            H_UU(i,1) = OCCUP(ATOM_IND1)*OCCUP(ATOM_IND2)*
     &                H_UU(i,1)*VOLUME4
c    &                *eightpisq
         ENDDO
         DO i = 1,3
            H_XB(i) = OCCUP(ATOM_IND1)*OCCUP(ATOM_IND2)*
     &                H_XB(i)*VOLUME4
c    &                 *eightpisq
         ENDDO
         DO i = 1,3
            DO j = 1,6
               H_XU(i,j) = OCCUP(ATOM_IND1)*OCCUP(ATOM_IND2)*
     &                     H_XU(i,j)*VOLUME4
            ENDDO
         ENDDO
         IF (U_ANISO(2,ATOM_IND1).le.0.0) THEN
c--------------BQ
            H_BQ = OCCUP(ATOM_IND1)*H_BQ*VOLUME4
c    &                  *eightpisq
c--------------QU
            DO i = 1,6
               H_QU(i) = OCCUP(ATOM_IND2)*H_UQ(i)*VOLUME4
            ENDDO
         ELSE
c--------------QB
            H_QB = OCCUP(ATOM_IND2)*H_BQ*VOLUME4
c    &            *eightpisq
c--------------UQ
            DO i = 1,6
               H_UQ(i) = OCCUP(ATOM_IND1)*H_UQ(i)*VOLUME4
            ENDDO
         ENDIF   
      ENDIF     
      RETURN
      END
c
      SUBROUTINE FIND_BEXTREME
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'hessian_impl.fh'
      INTEGER IA,NATOM,IA1,IA11,IM,IG
      REAL BCUR,eightpisq,GBMAX,BMAX,BMIN
c
      BMAX = -99999.0
      GBMAX = -1.0E32
      BMIN =  99999.0
      eightpisq = 78.95683521
      DO   IA=1,N_ATOM
        IF(ATOM_REF_FLAG(IA).GT.0) THEN
        IA1 = ATOM_REF_FLAG(IA)/10
        IA11 = ATOM_REF_FLAG(IA)-IA1*10
        IM   = ID_SF(IA)
        BCUR = 0.0
        IF(IA11.GT.2) THEN
          IF(U_ANISO(2,IA).LE.0.0) THEN
            BCUR = U_ANISO(1,IA)*eightpisq
          ELSE
            BCUR = ((U_ANISO(1,IA)+U_ANISO(2,IA)+U_ANISO(3,IA))/3.0)
     &            * eightpisq
          ENDIF
          if(bcur.le.0.0) then
             write(*,*)'oops'
           endif
        ENDIF
        DO   IG=1,NGAUS
          BMAX = AMAX1(BMAX,BCUR+CS_B(IG,IM))
          BMIN = AMIN1(BMIN,BCUR+CS_B(IG,IM))
        ENDDO
        DO IG = 1,NGAUS
            GBMAX = AMAX1(GBMAX,CS_B(IG,IM))
        ENDDO
        ENDIF
      ENDDO 
cd      BMAX = 2.0*BMAX+2.0*GBMAX
      BMAX = 2.0*BMAX
      BMIN = 2.0*BMIN
cd      print*, BMIN,BMAX,GBMAX
      B_MAX = ANINT(BMAX)+1.0
      B_MIN = ANINT(BMIN)-1.0
c      print*, B_MIN,B_MAX 
      END      

