C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
      SUBROUTINE LS_SCALING(NREF,NIND,FO,SIGO,FC,PHC,FREER,WORKSPACE,
     &    NWORKSPACE)
C
C---This routine refines ls scale factors. Functional used is
C---sum(S_0 Fo-exp(-s B_a sT)(1-S_b exp(-B_b s^2)|sum(s_i exp(-B_i s^2)Fci|)))^2
C---
C---where s_0 overall scale factor
C---B_a overall anisotropic B-values. 
C---S_b, B_b scale factors for bulk solvent
C---S_i, B_i scale factors for i-th partial structure. S_1=1
C---
C---Bulk solvent and anisotropic scale factors are refined if flags set to do it
C---Anisotropic B-values are refined along eignevectors calculated before this
C---subrotuine. These eignevectors correspond to direction were anisotropic B
C---could vary. (Because of symmetry not all anisotropic B-value parameters
C---are independent.)
C---------------------------------------------------------------------------
      IMPLICIT NONE
      INCLUDE 'agreem.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'const.fh'
C
      INTEGER NREF,NWORKSPACE
      REAL FO(*),SIGO(*),FC(*),PHC(*),FREER(*)
      REAL WORKSPACE(*)
      INTEGER NIND(*)
C----------------------------------------------------------
      INTEGER ICYCL,NPARAM
      REAL DFDP(NMAXPAR),D2FDP2(NMAXPAR,NMAXPAR),SHIFTS(NMAXPAR)
      INTEGER IMODE,I
      REAL ALPHA,RHO_IN,SIGMA_IN,F_THRES,F_VALUE0,F_VALUE,DEL
C
      REAL  TOLER
      REAL    EPSLON_LS_SCALE
C
C----Some initialisations
      EPSLON_LS_SCALE = 1.0E-7
      RHO_IN          = 0.25
      SIGMA_IN        = 0.5
      F_THRES         = 0.0
      TOLER           = 0.5E-8
C
C---Find number of parameters.
      CALL FIND_NPARAM_LS_SCALE(NPARAM)
C
C---Initial derivatives
      IMODE = 2

      CALL DERIVS_LS_SCALE(NPARAM,NREF,NIND,FREER,FO,SIGO,FC,
     &     PHC,DFDP,D2FDP2,WORKSPACE,NWORKSPACE,F_VALUE0,IMODE)
C
      F_VALUE = F_VALUE0
      
      DO   ICYCL = 1,NLSCYCL
C
C---Solve equation to find shifts. Here we use eigen value filtering.
C---We could of course use singular value deocomsingular value decomposition
C---We could use psude inversion or eigenvalue filtering. It should be 
C---done in the routine SVSOLV or routine which is going to replace it.
         CALL  EIGEN_FILTER_R(TOLER,D2FDP2,NPARAM,NMAXPAR,
     &            DFDP,SHIFTS,WORKSPACE,NWORKSPACE)

cd        CALL SVSOLV(D2FDP2,NPARAM,NPARAM,NMAXPAR,NMAXPAR,DFDP,SHIFTS)
C        
        DO   I=1,NPARAM
          SHIFTS(I) = -SHIFTS(I)
        ENDDO
        ALPHA  = 1.0
        F_VALUE0 = F_VALUE
       
        CALL LINMIN_LS_SCALE(NMAXPAR,NPARAM,NREF,FO,SIGO,FREER,FC,PHC,
     &           NIND,RHO_IN,SIGMA_IN,F_THRES,
     &           ALPHA,SHIFTS,DFDP,D2FDP2,WORKSPACE,NWORKSPACE,F_VALUE)
cd        ALPHA = 0.9
        CALL APPLY_LS_SCALE_SHIFTS(ALPHA,SHIFTS)
        DEL = F_VALUE0-F_VALUE
        IF(B_LS_BULK.LT.20.0) THEN
           B_LS_BULK = 20.0
        ELSEIF(B_LS_BULK.GT.300.0) THEN
           B_LS_BULK = 300.0
           B_LS_BULK_REFINE_FLAG = .FALSE.
           CALL FIND_NPARAM_LS_SCALE(NPARAM)
        ELSE
cd        CALL PRINT_LS_SCALE
          IF(F_VALUE0.LT.F_VALUE) GOTO 300
          IF(ABS(DEL)/ABS(F_VALUE0).LE.EPSLON_LS_SCALE) GOTO 300
        ENDIF
C
C---Option with second derivative could be added here
         F_VALUE0 = F_VALUE
        CALL DERIVS_LS_SCALE(NPARAM,NREF,NIND,FREER,FO,SIGO,FC,
     &     PHC,DFDP,D2FDP2,WORKSPACE,NWORKSPACE,F_VALUE,IMODE)
      ENDDO
C
C---Convergence achieved
 300  CONTINUE
      RETURN
      END
C
      SUBROUTINE FIND_NPARAM_LS_SCALE(NPARAM)
C
C---Finds number of refinable parmaters for ls scaling.
      IMPLICIT NONE
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INTEGER NPARAM
C
      INTEGER IP
C
      NPARAM = 1
      IF(B_LS_OVER_FLAG.AND.B_LS_OVER_REFINE_FLAG) NPARAM = NPARAM + 1
      IF(B_LS_ANISO_OVER_FLAG.AND.
     &   B_LS_ANISO_OVER_REFINE_FLAG) NPARAM = NPARAM + N_EIGEN_ANISO
      IF(BULK_LS_FLAG.AND.B_LS_BULK_REFINE_FLAG) NPARAM = NPARAM + 1
      IF(BULK_LS_FLAG.AND.SCALE_LS_BULK_REFINE_FLAG) NPARAM = NPARAM + 1
      DO    IP=1,NPART
        IF(B_LS_PART_REFINE_FLAG(IP))NPARAM = NPARAM + 1
        IF(SCALE_LS_PART_REFINE_FLAG(IP)) NPARAM = NPARAM + 1
      ENDDO
C
      RETURN
      END
C

      SUBROUTINE DERIVS_LS_SCALE(NPAR,NREF,NIND,FREER,FO,SIGO,
     &       FC,PHC,DFDP,D2FDP2,DF,NWORKSPACE,F_VALUE,IMODE)
      IMPLICIT NONE
C
c---Calculates least-square residual and derivatives of this residual wrt
C---ls scale paameters like overall scale, overall B, overall aniso B
C---bulk solvent,partial structure scale parameters
C
c---IMODE 0  - calculate function value only
C---      1  -           function value and derivative
C
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'celsym.fh'
      INTEGER NPAR,NREF,NWORKSPACE,IMODE
      INTEGER NIND(*)
      REAL F_VALUE
      REAL FO(*),SIGO(*),FC(*),PHC(*),FREER(*)
      REAL DF(*),DFDP(NMAXPAR),D2FDP2(NMAXPAR,NMAXPAR)
C
      INTEGER IP,IPP,IPOS,NPARAM,IR
      INTEGER IHH(3)
      REAL FC_P(NMAXPART),PHI_P(NMAXPART),DF_ANISO(6)
      REAL FC_PS,YC0,YC_ALL0,YC_ALL,PHI0,AC_ALL,BC_ALL,DELTA,
     &     EXPB_P,PHI_ALL,COS_PHI0,COS_PHI1,YC_P1
      REAL    RSQ,RHO,S1,S2,S3,S11,S22,S33,S12,S13,S23,SBS,EXPAN,YO,YOS,
     &        DBULK,EXPAN_BULK,EXP_BULK,EXP_BULKS,EXP_PROT,
     &        EXP_PROT_SCALE,EXPAN_BULK_SCALE
C
      REAL     LSTLSQ
      EXTERNAL LSTLSQ,UNPACK
      LOGICAL  FREERCHK
C
C---Initialise
      IF(IMODE.GT.0) THEN
        DO   IP=1,NPAR
          DFDP(IP) = 0.0E0
          DO   IPP=1,NPAR
            D2FDP2(IPP,IP) = 0.0E0
          ENDDO
        ENDDO
      ENDIF
      F_VALUE = 0.0
C
      DO    IR = 1,NREF
cd        FREERCHK = .FALSE.
cd        IF(FREER_FLAG )THEN
cd          IF((.NOT.LSUSEWORK)  .AND.
cd     +     (ABS(FREER(IR)-LFreeRexcludeVal).LT.0.1))FREERCHK = .TRUE.
cd          IF(       LSUSEWORK   .AND.
cd     +     (ABS(FREER(IR)-LFreeRexcludeVal).GT.0.1))FREERCHK = .TRUE.
cd        END IF
cd        IF(((.NOT.FREER_FLAG).OR.FREERCHK).AND.SIGO(IR).GT.0.0) THEN
        IF(SIGO(IR).GT.0.0) THEN

         CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
          RSQ = LSTLSQ(1,IHH(1),IHH(2),IHH(3))
          RHO = SQRT(RSQ)
          IF(RHO.GE.SMINS.AND.RHO.LE.SMAXS) THEN
            YO    = FO(IR)
            YOS   = YO
            EXPAN = 1.0
            IF(B_LS_ANISO_OVER_FLAG) THEN
              S1  = FLOAT(IHH(1))*RCELL(1)
              S2  = FLOAT(IHH(2))*RCELL(2)
              S3  = FLOAT(IHH(3))*RCELL(3)
              S11 = S1*S1
              S22 = S2*S2
              S33 = S3*S3
              S12 = 2.0*S1*S2
              S13 = 2.0*S1*S3
              S23 = 2.0*S2*S3
              SBS = B_LS_ANISO_OVER(1)*S11 + B_LS_ANISO_OVER(2)*S22 + 
     &              B_LS_ANISO_OVER(3)*S33 + B_LS_ANISO_OVER(4)*S12 +
     &              B_LS_ANISO_OVER(5)*S13 + B_LS_ANISO_OVER(6)*S23
              IF(SBS.GT.59.0) THEN
                 EXPAN = 0.0
              ELSE
               EXPAN = EXP(-SBS)
             ENDIF
            ENDIF
            DBULK = 1.0
            IF(BULK_LS_FLAG) THEN
              IF(B_LS_BULK*RSQ.GT.50) THEN
                EXP_BULK = 0.0
cd              ELSE IF(B_LS_BULK*RSQ.LE.-60.0) THEN
              ELSE
                EXP_BULK  = EXP(-B_LS_BULK*RSQ)
              ENDIF
              EXP_BULKS = SCALE_LS_BULK*EXP_BULK
              DBULK     = 1.0 - EXP_BULKS
              DBULK     = AMAX1(0.000001,AMIN1(1.0,DBULK))
            ENDIF
            EXPAN_BULK       = EXPAN*DBULK
            EXP_PROT = 1.0
            IF(B_LS_OVER_FLAG) THEN
              IF(B_LS_OVER*RSQ.GT.59.0) THEN
                EXP_PROT = 0.0
              ELSE
                EXP_PROT = EXP(-B_LS_OVER*RSQ)
              ENDIF
            ENDIF
            EXP_PROT_SCALE   = EXP_PROT*SCALE_LS_OVER
            EXPAN_BULK_SCALE = EXPAN_BULK*EXP_PROT_SCALE
            IPOS       = IR + NPART*NOBS
            YC0        = FC(IPOS)
            YC_ALL0 = YC0
            PHI0    = PHC(IPOS)
            AC_ALL  = YC_ALL0*COS(PHI0)
            BC_ALL  = YC_ALL0*SIN(PHI0)
            IF(NPART.GT.0) THEN
              IPOS   = IR
              DO   IP=1,NPART
                 PHI_P(IP)  = PHC(IPOS)
                 IF(RSQ*B_LS_PART(IP).GT.59.0) THEN
                   EXPB_P     = 0.0
                 ELSE
                   EXPB_P     = EXP(-RSQ*B_LS_PART(IP))
                 ENDIF
                 FC_P(IP)   = FC(IPOS)*EXPB_P
                 FC_PS      = FC_P(IP)*SCALE_LS_PART(IP)
                 AC_ALL     = AC_ALL + FC_PS*COS(PHI_P(IP))
                 BC_ALL     = BC_ALL + FC_PS*SIN(PHI_P(IP))
                 IPOS       = IPOS + NOBS
              ENDDO
              PHI_ALL = 0.0
              YC_ALL0 = SQRT(AC_ALL**2+BC_ALL**2)
              IF(YC_ALL0.GT.0.0) PHI_ALL = ATAN2(BC_ALL,AC_ALL)
            ENDIF
            YC_ALL = YC_ALL0*EXPAN_BULK_SCALE
            DELTA  = YOS - YC_ALL
C
c---Weight???
            F_VALUE = F_VALUE + DELTA**2
            IF(IMODE.GT.0) THEN
C
c----Calculate derivatives
C----
C----Overall scale values are always their
              DF(1)  = -DBULK*EXPAN*EXP_PROT*YC_ALL0
              NPARAM = 1
C
c---Overall isotropic b-value
              IF(B_LS_OVER_FLAG.AND.B_LS_OVER_REFINE_FLAG) THEN
                NPARAM   = NPARAM + 1
                DF(NPARAM) = YC_ALL*RSQ
              ENDIF
C
c---Effect of bulk solvent
              IF(BULK_LS_FLAG.AND.B_LS_BULK_REFINE_FLAG) THEN
                NPARAM     = NPARAM + 1
                DF(NPARAM) = -EXPAN*EXP_BULKS*EXP_PROT_SCALE*RSQ*YC_ALL0
              ENDIF
              IF(BULK_LS_FLAG.AND.SCALE_LS_BULK_REFINE_FLAG) THEN
                NPARAM     = NPARAM + 1
                DF(NPARAM) = EXPAN*EXP_BULK*EXP_PROT_SCALE*YC_ALL0
              ENDIF
C
c---Anisotropic B-value
              IF(B_LS_ANISO_OVER_FLAG.AND.
     &           B_LS_ANISO_OVER_REFINE_FLAG) THEN
                DF_ANISO(1) = S11*YC_ALL
                DF_ANISO(2) = S22*YC_ALL
                DF_ANISO(3) = S33*YC_ALL
                DF_ANISO(4) = S12*YC_ALL
                DF_ANISO(5) = S13*YC_ALL
                DF_ANISO(6) = S23*YC_ALL
                DO   IP=1,N_EIGEN_ANISO
                  NPARAM     = NPARAM + 1
                  DF(NPARAM) = DF_ANISO(1)*EIGEN_ANISO(IP,1)+
     &                         DF_ANISO(2)*EIGEN_ANISO(IP,2)+
     &                         DF_ANISO(3)*EIGEN_ANISO(IP,3)+
     &                         DF_ANISO(4)*EIGEN_ANISO(IP,4)+
     &                         DF_ANISO(5)*EIGEN_ANISO(IP,5)+
     &                         DF_ANISO(6)*EIGEN_ANISO(IP,6)  
                ENDDO
              ENDIF
C
c---If we have partial structure they will have to be taken into account
              DO   IP=1,NPART
                IF(B_LS_PART_REFINE_FLAG(IP).OR.
     &             SCALE_LS_PART_REFINE_FLAG(IP)) 
     &                                             THEN
                  COS_PHI1 = COS(PHI_ALL-PHI_P(IP))
                  YC_P1    = FC_P(IP)*COS_PHI1
                ENDIF
                IF(B_LS_PART_REFINE_FLAG(IP)) THEN
                  NPARAM     = NPARAM + 1
                  DF(NPARAM) = EXPAN_BULK_SCALE*RSQ*
     &                         SCALE_LS_PART(IP)*YC_P1
                ENDIF

                IF(SCALE_LS_PART_REFINE_FLAG(IP)) THEN
                  NPARAM     = NPARAM + 1
                  DF(NPARAM) = -EXPAN_BULK_SCALE*YC_P1
                ENDIF
              ENDDO
C
c---Compile derivatives
              DO   IP = 1,NPARAM
                DFDP(IP) = DFDP(IP) + DELTA*DF(IP)
                DO   IPP=1,IP
                  D2FDP2(IPP,IP) = D2FDP2(IPP,IP) + DF(IP)*DF(IPP)
                ENDDO
              ENDDO

            ENDIF
          ENDIF
        ENDIF
      ENDDO
      DO    IP=1,NPARAM-1
        DO    IPP=IP+1,NPARAM
          D2FDP2(IPP,IP) = D2FDP2(IP,IPP)
        ENDDO
      ENDDO
C
      RETURN
      END
C
C
      SUBROUTINE SUMSFS_LS_DERIV(IR,NREF,NIND,FO,SIGO,FC,PHC,YOS,
     &      YC_ALL,PHI_ALL,SIGOS,DFA,DFB,D2FDA2,D2FDB2,F_VALUE_C,IMODE)
      IMPLICIT NONE
C
c---Calculates least-square residual and derivatives of this residual wrt
C---real and imagenary parts of the structure factors
C
c---IMODE 0  - calculate function value only
C---      1  -           function value and derivative
C
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'celsym.fh'
      INTEGER IR,IMODE,NREF
      INTEGER NIND(*)
      REAL F_VALUE_C,YOS,SIGOS,YC_ALL,PHI_ALL

      REAL FO(*),SIGO(*),FC(*),PHC(*)
      REAL DFA(*),DFB(*),D2FDA2(*),D2FDB2(*)
C

      INTEGER IP,IPOS
      INTEGER IHH(3)
      REAL FC_P(NMAXPART),PHI_P(NMAXPART)
      REAL FC_PS,YC0,YC_ALL0,PHI0,AC_ALL,BC_ALL,DELTA,EXPB_P
      REAL    RSQ,RHO,S1,S2,S3,S11,S22,S33,S12,S13,S23,SBS,EXPAN,YO,
     &        DBULK,EXPAN_BULK,EXP_BULK,EXP_BULKS,EXPB_LS_OVER,
     &        SCALE_LS_0_A,SCALE_LS_0_B,SCALE_IP,SCALE_IP_A,SCALE_IP_B,
     &        EXP_PROT,EXPAN_BULK_SCALE
C
      REAL     LSTLSQ
      EXTERNAL LSTLSQ,UNPACK
C
      CALL UNPACK(NIND(IR),IHH(1),IHH(2),IHH(3))
      RSQ   = LSTLSQ(1,IHH(1),IHH(2),IHH(3))
      RHO   = SQRT(RSQ)
      YO    = FO(IR)
      YOS   = YO/SCALE_LS_OVER
      SIGOS = SIGO(IR)/SCALE_LS_OVER
      EXPAN = 1.0
      IF(B_LS_ANISO_OVER_FLAG) THEN
        S1  = FLOAT(IHH(1))*RCELL(1)
        S2  = FLOAT(IHH(2))*RCELL(2)
        S3  = FLOAT(IHH(3))*RCELL(3)
        S11 = S1*S1
        S22 = S2*S2
        S33 = S3*S3
        S12 = 2.0*S1*S2
        S13 = 2.0*S1*S3
        S23 = 2.0*S2*S3
        SBS = B_LS_ANISO_OVER(1)*S11 + B_LS_ANISO_OVER(2)*S22 + 
     &        B_LS_ANISO_OVER(3)*S33 + B_LS_ANISO_OVER(4)*S12 +
     &        B_LS_ANISO_OVER(5)*S13 + B_LS_ANISO_OVER(6)*S23
        IF(SBS.GT.50) THEN
          EXPAN = 0.0
        ELSE
          EXPAN = EXP(-SBS)
        ENDIF
      ENDIF
      DBULK = 1.0
      IF(BULK_LS_FLAG) THEN
        IF(B_LS_BULK*RSQ.GT.59.0) THEN
          EXP_BULK = 0.0
        ELSE
          EXP_BULK  = EXP(-B_LS_BULK*RSQ)
        ENDIF
        EXP_BULKS = SCALE_LS_BULK*EXP_BULK
        DBULK     = 1.0 - EXP_BULKS
        DBULK     = AMAX1(0.0001,AMIN1(1.0,DBULK))
      ENDIF
      EXPAN_BULK = EXPAN*DBULK
      IF(B_LS_OVER*RSQ.GT.59.0) THEN
        EXP_PROT = 0.0
      ELSE
        EXP_PROT   = EXP(-B_LS_OVER*RSQ)
      ENDIF
      EXPAN_BULK_SCALE = EXPAN_BULK*EXP_PROT
      IPOS       = IR + NPART*NOBS
      YC0        = FC(IPOS)
      YC_ALL0    = YC0
      PHI0       = PHC(IPOS)
      PHI_ALL    = PHI0
      AC_ALL     = YC_ALL0*COS(PHI0)
      BC_ALL     = YC_ALL0*SIN(PHI0)
      IF(NPART.GT.0) THEN
        DO   IP=1,NPART
          IPOS       = IR + (IP-1)*NOBS
          PHI_P(IP)  = PHC(IPOS)
          IF(RSQ*B_LS_PART(IP).GT.59.0) THEN
            EXPB_P = 0.0
          ELSE
            EXPB_P     = EXP(-RSQ*B_LS_PART(IP))
          ENDIF
          FC_P(IP)   = FC(IPOS)*EXPB_P
          FC_PS      = FC_P(IP)*SCALE_LS_PART(IP)
          AC_ALL     = AC_ALL + FC_PS*COS(PHI_P(IP))
          BC_ALL     = BC_ALL + FC_PS*SIN(PHI_P(IP))
        ENDDO
        PHI_ALL = 0.0
        YC_ALL0 = SQRT(AC_ALL**2+BC_ALL**2)
        IF(YC_ALL0.GT.0.0) PHI_ALL = ATAN2(BC_ALL,AC_ALL)
      ENDIF
      YC_ALL = YC_ALL0*EXPAN_BULK_SCALE
      DELTA  = YOS - YC_ALL
C
c---Weight???
      F_VALUE_C = DELTA**2

      IF(IMODE.GT.0) THEN
C
c----Calculate derivatives
C----
        SCALE_LS_0_A = EXPAN_BULK_SCALE*COS(PHI0)
        SCALE_LS_0_B = EXPAN_BULK_SCALE*SIN(PHI0)

        DFA(NPART+1)    = DELTA*SCALE_LS_0_A
        DFB(NPART+1)    = DELTA*SCALE_LS_0_B
        D2FDA2(NPART+1) = (SCALE_LS_0_A)**2
        D2FDB2(NPART+1) = (SCALE_LS_0_B)**2

        DO    IP=1,NPART
          IF(B_LS_PART(IP)*RSQ.GT.59.0) THEN
            SCALE_IP = 0.0
          ELSE
            SCALE_IP = SCALE_LS_PART(IP)*
     &           EXP(-B_LS_PART(IP)*RSQ)
          ENDIF
          SCALE_IP = SCALE_IP*EXPAN_BULK_SCALE
          SCALE_IP_A = SCALE_IP*COS(PHI_P(IP))
          SCALE_IP_B = SCALE_IP*SIN(PHI_P(IP))
          DFA(IP)    = DELTA*SCALE_IP_A
          DFB(IP)    = DELTA*SCALE_IP_B
          D2FDA2(IP) = SCALE_IP_A**2
          D2FDB2(IP) = SCALE_IP_B**2
        ENDDO
      ENDIF
C
      RETURN
      END
C
      SUBROUTINE LINMIN_LS_SCALE(NMAXPAR,NPAR,NREF,FO,SIGO,FREER,FC,PHC,
     &           NIND,RHO_IN0,SIGMA_IN0,F_THRES,ALPHA,
     &           SHIFTS,DFDP,D2FDP2,WORKSPACE,NWORKSPACE,F_VALUE)
C
C---Line minimisation for ls scaling. This line minimiser returns
C---function value and derivatives at the minimum also
      IMPLICIT NONE
      INTEGER NREF,NMAXPAR,NPAR,NWORKSPACE
      INTEGER NIND(*)
C
      REAL RHO_IN0,SIGMA_IN0,F_THRES,F_VALUE,ALPHA
      REAL FO(*),SIGO(*),FC(*),PHC(*),FREER(*),WORKSPACE(*)
      REAL SHIFTS(NMAXPAR),DFDP(NMAXPAR),D2FDP2(NMAXPAR,NMAXPAR)

      REAL F_VALUE0,AMYU,TAO_1,TAO_2,TAO_3,SIGMA_IN,RHO_IN,ALPHA_0,DF_0,
     &     DF_00,F_VALUE00,DF_1,A_1,B_1,F_A,F_B,DF_A,DF_B,AA_1,AA_2,AA
      INTEGER IMODE,NUSED_SPACE,NWORK1,I
      REAL DOT1_R,ALPHA_1,EPSI_LOCAL
      REAL EPS_LOCAL1
      EXTERNAL DOT1_R
C
C---Some initialisation
      SIGMA_IN = 0.5
      IF(SIGMA_IN0.GT.0.0) SIGMA_IN = SIGMA_IN0
      RHO_IN    = 0.25
      IF(RHO_IN0.GT.0.0) RHO_IN = AMIN1(0.9*SIGMA_IN,RHO_IN0)
      TAO_1     = 2.0
      TAO_2     = AMIN1(0.1,0.9*SIGMA_IN)
      TAO_3     = 0.2
      EPSI_LOCAL = 1.0E-8
      EPS_LOCAL1 = 1.0E-7
C
      ALPHA_0   = 0.0 
      F_VALUE0  = F_VALUE
      DF_0 = 0.0
      DO    I=1,NPAR
        DF_0 = DF_0 + SHIFTS(I)*DFDP(I)
      ENDDO
cd      DF_0      = DOT1_R(NPAR,NMAXPAR,SHIFTS,DFDP)
      DF_00     = DF_0
      IMODE     = 2
      AMYU      = (F_THRES-F_VALUE0)/(RHO_IN*DF_0)
      F_VALUE00 = F_VALUE0
C
C---Bracketing stage 
      CALL SAVE_LS_PARAMS(WORKSPACE,NWORKSPACE,NUSED_SPACE)
      NWORK1 = NWORKSPACE - NUSED_SPACE
 10   CONTINUE
      CALL APPLY_LS_SCALE_SHIFTS_MODIFY(ALPHA,WORKSPACE,SHIFTS,
     &                                         NWORKSPACE)
      
      CALL DERIVS_LS_SCALE(NPAR,NREF,NIND,FREER,FO,SIGO,FC,PHC,
     &       DFDP,D2FDP2,WORKSPACE(NUSED_SPACE+1),NWORK1,F_VALUE,IMODE)
      DF_1 = 0.0
      DO    I=1,NPAR
        DF_1 = DF_0 + SHIFTS(I)*DFDP(I)
      ENDDO
cd      DF_1 = DOT1_R(NPAR,NMAXPAR,SHIFTS,DFDP)
C
C--We have required minimiser.
      IF(F_VALUE.LE.F_VALUE00) GOTO 500
      IF(F_VALUE.LE.F_THRES) THEN
        GOTO 500
      ENDIF
C
C---We have bracket
      IF(F_VALUE.GT.F_VALUE00*1.0E8) THEN
C
C---Function value becomes too big. Reduce alpha and try again
        ALPHA = ALPHA/2.0
        IF(ALPHA.LE.10.0*EPSI_LOCAL) THEN
          ALPHA = 0.0
          RETURN
        ENDIF
        GOTO 10
      ENDIF
      IF(F_VALUE.GT.F_VALUE00+ALPHA*DF_00.OR.
     &   F_VALUE.GT.F_VALUE0)                     THEN
        A_1  = ALPHA_0
        B_1  = ALPHA
        F_A  = F_VALUE0
        F_B  = F_VALUE
        DF_A = DF_0
        DF_B = DF_1
        GOTO 100
      ENDIF
C
C---We have minimiser

      IF(ABS(DF_1).LE.-SIGMA_IN*DF_00) THEN
cd        CALL ERRWRT(-1,'Second condition')
        GOTO 500
      ENDIF
      IF(DF_1.GE.0.0) THEN
        A_1  = ALPHA
        B_1  = ALPHA_0
        F_A  = F_VALUE
        F_B  = F_VALUE0
        DF_A = DF_1
        DF_B = DF_0
        GOTO 100
      ENDIF
C
C---No success with bracketing yet
      AA_1 = 2.0*ALPHA-ALPHA_0
      IF(AMYU .LE. AA_1) THEN
        ALPHA_0  = ALPHA
        F_VALUE0 = F_VALUE
        DF_0     = DF_1
        ALPHA    = AMYU
      ELSE
C
C---Use minimiser of cubic polynom as a next trial point
        AA_2 = ALPHA + TAO_1*(ALPHA-ALPHA_0)
        AA_2 = AMIN1(AA_2,AMYU)
        CALL MIN_CUBE_INTER(ALPHA_0,ALPHA,F_VALUE0,F_VALUE,DF_0,DF_1,
     &       AA_1,AA_2,AA)
        ALPHA_0  = ALPHA
        F_VALUE0 = F_VALUE
        DF_0     = DF_1
        ALPHA = AA
        alpha = alpha/2.0
      ENDIF
      GOTO 10
C
C--Sectioning stage

 100  CONTINUE

      AA_1  = A_1 + TAO_2*(B_1-A_1)
      AA_2  = B_1 - TAO_3*(B_1-A_1)
C
C---Choose minimiser of cubic polynom as a next trial point
      CALL MIN_CUBE_INTER(A_1,B_1,F_A,F_B,DF_A,DF_B,
     &     AA_1,AA_2,ALPHA_1)
      IF(ABS(ALPHA-ALPHA_1).LE.EPS_LOCAL1) GOTO 500
      ALPHA = ALPHA_1
C
C---Shifts must be applied to original parameters
      CALL APPLY_LS_SCALE_SHIFTS_MODIFY(ALPHA,WORKSPACE,SHIFTS,
     &                NWORKSPACE)
      CALL DERIVS_LS_SCALE(NPAR,NREF,NIND,FREER,FO,SIGO,FC,PHC,
     &       DFDP,D2FDP2,WORKSPACE(NUSED_SPACE+1),NWORK1,F_VALUE,IMODE)
      DF_1 = 0.0
      DO    I=1,NPAR
        DF_1 = DF_1 + SHIFTS(I)*DFDP(I)
      ENDDO
cd      DF_1 = DOT1_R(NPAR,NMAXPAR,SHIFTS,DFDP)
cd      STOP
C
C---We have minimiser
      IF(F_VALUE.LE.F_THRES.OR.F_VALUE.LE.F_VALUE00) THEN
cd        CALL ERRWRT(-1,'Third condition')
        GOTO 500 
      ENDIF
C
C---Change interval
      IF(ABS((A_1-ALPHA)*DF_1).LE.EPSI_LOCAL*F_VALUE) THEN
cd        CALL ERRWRT(-1,'Third and half')
cd        ALPHA = 0.0
        GOTO 500
      ENDIF
      IF(F_VALUE.GT.F_VALUE00+RHO_IN*ALPHA*DF_00.OR.
     &   F_VALUE.GT.F_A) THEN
        B_1  = ALPHA
        F_B  = F_VALUE
        DF_B = DF_1
      ELSE
        IF(ABS(DF_1).LE.-SIGMA_IN*DF_00) THEN
cd          CALL ERRWRT(-1,'Fourth condition')
          GOTO 500
        ENDIF
        IF((B_1-A_1)*DF_1.GE.0.0) THEN
          B_1  = A_1
          F_B  = F_A
          DF_B = DF_A
        ENDIF
        A_1  = ALPHA
        F_A  = F_VALUE
        DF_A = DF_1
      ENDIF
      GOTO 100
 500  CONTINUE
      CALL RESTORE_LS_PARAMS(WORKSPACE,NWORKSPACE)
      RETURN
      END
C
      SUBROUTINE APPLY_LS_SCALE_SHIFTS(ALPHA,SHIFT)
C
C---Applies shifts to ls scale parameters. Only those parameters
C---which are refined are updated
      IMPLICIT NONE
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      REAL ALPHA
      REAL SHIFT(*)
C
      INTEGER IP,NPARAM,IANISO
C
      SCALE_LS_OVER = SCALE_LS_OVER + ALPHA*SHIFT(1)
      NPARAM = 1
      IF(B_LS_OVER_FLAG.AND.B_LS_OVER_REFINE_FLAG) THEN
        NPARAM = NPARAM + 1
        B_LS_OVER = B_LS_OVER + ALPHA*(SHIFT(NPARAM))
        B_LS_OVER = AMAX1(B_LS_OVER,-50.0)
      ENDIF
      IF(BULK_LS_FLAG.AND.B_LS_BULK_REFINE_FLAG) THEN
        NPARAM = NPARAM + 1
        B_LS_BULK = B_LS_BULK + ALPHA*SHIFT(NPARAM)
        IF(B_LS_BULK.LT.20.0) B_LS_BULK = 20.0
        IF(B_LS_BULK.GT.300.0) B_LS_BULK = 300
      ENDIF
      IF(BULK_LS_FLAG.AND.SCALE_LS_BULK_REFINE_FLAG) THEN
        NPARAM = NPARAM + 1
        SCALE_LS_BULK = SCALE_LS_BULK + ALPHA*SHIFT(NPARAM)
        IF(SCALE_LS_BULK.LE.0.000001) SCALE_LS_BULK = 0.000001
        IF(SCALE_LS_BULK.GT.0.999) SCALE_LS_BULK = 0.999
      ENDIF
      IF(B_LS_ANISO_OVER_FLAG.AND.B_LS_ANISO_OVER_REFINE_FLAG) THEN
        DO  IANISO = 1,6
          DO   IP=1,N_EIGEN_ANISO
            B_LS_ANISO_OVER(IANISO) = B_LS_ANISO_OVER(IANISO) + 
     &                  ALPHA*SHIFT(NPARAM+IP)*EIGEN_ANISO(IP,IANISO)
          ENDDO
        ENDDO
        NPARAM = NPARAM + N_EIGEN_ANISO
      ENDIF
      IF(NPART.GT.0) THEN
        DO   IP=1,NPART
          IF(B_LS_PART_REFINE_FLAG(IP)) THEN
            NPARAM = NPARAM + 1
            B_LS_PART(IP) = B_LS_PART(IP) + ALPHA*SHIFT(NPARAM)
            B_LS_PART(IP) = AMAX1(-10.0,B_LS_PART(IP))
          ENDIF
          IF(SCALE_LS_PART_REFINE_FLAG(IP)) THEN
            NPARAM = NPARAM + 1
            SCALE_LS_PART(IP) = SCALE_LS_PART(IP) + ALPHA*SHIFT(NPARAM)
          ENDIF
        ENDDO
      ENDIF
      RETURN
      END
C
      SUBROUTINE SAVE_LS_PARAMS(SAVE_LS_SCALE,NWORKSPACE,NUSED_SPACE)
C
C---Saves parameters of ls scaling. These saved parameters will be incremented
C---at each cycle of linmin.
      IMPLICIT NONE
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INTEGER NWORKSPACE,NUSED_SPACE
      REAL SAVE_LS_SCALE(*)
C
      INTEGER NPARAM
C
      INTEGER IP
C
      SAVE_LS_SCALE(1) = SCALE_LS_OVER
      NPARAM = 1
      IF(NPARAM.GT.NWORKSPACE) 
     &       CALL ERRWRT(1,'Not enough memory in SAVE_LS_PARAMS')
      IF(B_LS_OVER_FLAG) THEN
        NPARAM = NPARAM + 1
        IF(NPARAM.GT.NWORKSPACE) 
     &       CALL ERRWRT(1,'Not enough memory in SAVE_LS_PARAMS')
        SAVE_LS_SCALE(NPARAM) = B_LS_OVER
      ENDIF

      IF(BULK_LS_FLAG) THEN
        IF(NPARAM+2.GT.NWORKSPACE) 
     &       CALL ERRWRT(1,'Not enough memory in SAVE_LS_PARAMS')
        SAVE_LS_SCALE(NPARAM + 1) = B_LS_BULK
        SAVE_LS_SCALE(NPARAM + 2) = SCALE_LS_BULK
        NPARAM = NPARAM + 2
      ENDIF

      IF(B_LS_ANISO_OVER_FLAG) THEN
        IF(NPARAM+6.GT.NWORKSPACE) 
     &       CALL ERRWRT(1,'Not enough memory in SAVE_LS_PARAMS')
        SAVE_LS_SCALE(NPARAM+1) = B_LS_ANISO_OVER(1)
        SAVE_LS_SCALE(NPARAM+2) = B_LS_ANISO_OVER(2)
        SAVE_LS_SCALE(NPARAM+3) = B_LS_ANISO_OVER(3)
        SAVE_LS_SCALE(NPARAM+4) = B_LS_ANISO_OVER(4)
        SAVE_LS_SCALE(NPARAM+5) = B_LS_ANISO_OVER(5)
        SAVE_LS_SCALE(NPARAM+6) = B_LS_ANISO_OVER(6)
        NPARAM = NPARAM + 6
      ENDIF
        
      DO    IP=1,NPART
        IF(NPARAM+2.GT.NWORKSPACE) 
     &       CALL ERRWRT(1,'Not enough memory in SAVE_LS_PARAMS')
        SAVE_LS_SCALE(NPARAM + 1) = B_LS_PART(IP)
        SAVE_LS_SCALE(NPARAM + 2) = SCALE_LS_PART(IP)
        NPARAM = NPARAM + 2
      ENDDO
C
      NUSED_SPACE = NPARAM
      RETURN
      END
C
      SUBROUTINE APPLY_LS_SCALE_SHIFTS_MODIFY(ALPHA,SAVE_LS_PARAM,SHIFT,
     &          NWORKSPACE)
C
c---Applies shifts to ls scale parameters. It is used in linmin. Shifts
C---are not applied to parameters directly. They are applied to parameters
C---saved by SAVE_LS_PARAMS
C
      IMPLICIT NONE
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INTEGER NWORKSPACE
      REAL ALPHA
      REAL SHIFT(*)
      REAL SAVE_LS_PARAM(*)
C
      INTEGER IP,NPARAM,NPARAM1,IANISO
C
      SCALE_LS_OVER = SAVE_LS_PARAM(1) + ALPHA*SHIFT(1)
      NPARAM  = 1
      NPARAM1 = 1
      IF(B_LS_OVER_FLAG) THEN
        NPARAM = NPARAM + 1
        IF(B_LS_OVER_REFINE_FLAG) THEN
          NPARAM1 = NPARAM1 + 1
          B_LS_OVER = SAVE_LS_PARAM(NPARAM) + ALPHA*SHIFT(NPARAM1)
          B_LS_OVER = AMAX1(-50.0,B_LS_OVER)
        ENDIF
      ENDIF
      IF(BULK_LS_FLAG) THEN
        NPARAM = NPARAM + 1
        IF(B_LS_BULK_REFINE_FLAG) THEN
          NPARAM1 = NPARAM1 + 1
          B_LS_BULK = SAVE_LS_PARAM(NPARAM) + ALPHA*SHIFT(NPARAM1)
          IF(B_LS_BULK.LT.20.0) B_LS_BULK = 20.0
          IF(B_LS_BULK.GT.300.0) B_LS_BULK = 300.0
        ENDIF
        NPARAM = NPARAM +1
        IF(SCALE_LS_BULK_REFINE_FLAG) THEN
          NPARAM1 = NPARAM1 + 1
          SCALE_LS_BULK = SAVE_LS_PARAM(NPARAM) + ALPHA*SHIFT(NPARAM1)
          IF(SCALE_LS_BULK.LE.0.001) SCALE_LS_BULK = 0.001
          IF(SCALE_LS_BULK.GT.0.999) SCALE_LS_BULK = 0.999
        ENDIF
      ENDIF
      IF(B_LS_ANISO_OVER_FLAG) THEN
        IF(B_LS_ANISO_OVER_REFINE_FLAG) THEN
          DO  IANISO = 1,6
            DO   IP=1,N_EIGEN_ANISO
              B_LS_ANISO_OVER(IANISO) = SAVE_LS_PARAM(NPARAM + IANISO) + 
     &                  ALPHA*SHIFT(NPARAM1+IP)*EIGEN_ANISO(IP,IANISO)
            ENDDO
          ENDDO
          NPARAM1 = NPARAM1 + N_EIGEN_ANISO
        ENDIF
        NPARAM = NPARAM + 6
      ENDIF
      IF(NPART.GT.0) THEN
        DO   IP=1,NPART
          NPARAM = NPARAM + 1
          IF(B_LS_PART_REFINE_FLAG(IP)) THEN
            NPARAM1 = NPARAM1 + 1
            B_LS_PART(IP) = SAVE_LS_PARAM(NPARAM) + ALPHA*SHIFT(NPARAM1)
            B_LS_PART(IP) = AMAX1(-10.0,B_LS_PART(IP))
          ENDIF
          NPARAM = NPARAM + 1
          IF(SCALE_LS_PART_REFINE_FLAG(IP)) THEN
            NPARAM1 = NPARAM1 + 1
            SCALE_LS_PART(IP) = SAVE_LS_PARAM(NPARAM) + 
     &                        ALPHA*SHIFT(NPARAM1)
          ENDIF
        ENDDO
      ENDIF
      RETURN
      END
C
      SUBROUTINE RESTORE_LS_PARAMS(SAVE_LS_PARAMS,NWORKSPACE)
C
C---Restores ls scaling parameters saved previously by SCALE_LS_PARAMS in
C---the array SAVE_LS_PARAMS
      IMPLICIT NONE
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'
      INTEGER NWORKSPACE
      REAL SAVE_LS_PARAMS(*)
C
      INTEGER NPARAM
C
      INTEGER IP
C
      SCALE_LS_OVER = SAVE_LS_PARAMS(1)
      NPARAM = 1

      IF(B_LS_OVER_FLAG) THEN
        NPARAM = NPARAM + 1
        B_LS_OVER = SAVE_LS_PARAMS(NPARAM)
      ENDIF


      IF(BULK_LS_FLAG) THEN
        B_LS_BULK     = SAVE_LS_PARAMS(NPARAM + 1)
        SCALE_LS_BULK = SAVE_LS_PARAMS(NPARAM + 2)
        NPARAM = NPARAM + 2
      ENDIF

      IF(B_LS_ANISO_OVER_FLAG) THEN
        B_LS_ANISO_OVER(1) = SAVE_LS_PARAMS(NPARAM+1)
        B_LS_ANISO_OVER(2) = SAVE_LS_PARAMS(NPARAM+2)
        B_LS_ANISO_OVER(3) = SAVE_LS_PARAMS(NPARAM+3)
        B_LS_ANISO_OVER(4) = SAVE_LS_PARAMS(NPARAM+4)
        B_LS_ANISO_OVER(5) = SAVE_LS_PARAMS(NPARAM+5)
        B_LS_ANISO_OVER(6) = SAVE_LS_PARAMS(NPARAM+6)
        NPARAM = NPARAM + 6
      ENDIF     
   
      DO    IP=1,NPART
        B_LS_PART(IP)     = SAVE_LS_PARAMS(NPARAM + 1) 
        SCALE_LS_PART(IP) = SAVE_LS_PARAMS(NPARAM + 2)
        NPARAM = NPARAM + 2
      ENDDO
C
      RETURN
      END
C
