C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C -I-
      SUBROUTINE READ_ATOMS(MDOC,PATHC,NAMEC,EXTC
     *                     ,NOSPGR_INPUT,CELL_INPUT,IERR)
C --------------------------------------------------------------
C -P- READ_ATOMS - 
C
C    MDOC   - mode of writting messages to DOC-file
C             0 - only terminal , < - 0 only file, 0 < < 99 - both
C             >= 99 - don't write  
C    NAMEC  - name of input file
C    PATHC  - path
C    EXTC   - extention
C    IERR   - output signal of error / = 1 -error , = 0 - OK / 
C -I-
C ---------------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C ---------------------------------------------------------------
      INTEGER     MDOC,IERR
      CHARACTER   NAMEC*(*),PATHC*(*),EXTC*(*)
      INTEGER     NOSPGR_INPUT
      REAL        CELL_INPUT(6)
C ----------------------------------------------------------------
      INTEGER     M,MD,IN,IEND,MODE
      INTEGER     CR_IRES_OLD,CR_IGROUP_OLD
      INTEGER     ISG_FLAG,ICELL_FLAG
      CHARACTER   CR_RES_OLD*5,CR_GROUP_OLD*4
      CHARACTER   LINE*256
C ----------------------------------------------------------------
      IERR_COPY = IERR
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C -------------------------------------------------
C --- initialization --
C     
      IF(IERR_COPY.NE.1) THEN
        CALL INIT_RES_TYPE_TAB
      ENDIF
      IERR = 0
      CALL INIT_ATM_INF(MDOC,IERR)
      ISG_FLAG   = 0
      ICELL_FLAG = 0
C -------------------------------------------------
C --- open input CIFile and read titles
C
C     IN  = 10
      IN  = CRI_IUN
      CALL OPEN_CRDCIF(MD,IN,PATHC,NAMEC,EXTC
     * ,NOSPGR_INPUT,CELL_INPUT,ISG_FLAG,ICELL_FLAG,IERR)
      CRI_IUN = IN
      IF(IERR.EQ.1) THEN
        CALL MSGERR(MDOC,' ERROR: open input file')
        RETURN
      ELSE IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: reading title of input file')
        CLOSE(IN)
        IERR = 2
        RETURN
      ENDIF
C -------------------------------------------------
      N_GROUP      = 0
      N_RESIDUE    = 0
      N_ATOM       = 0
C
      ICSD         = 0
      OUT_CIF_CORR = 1 
      OUT_CIF_INS  = 1 
      OUT_CIF_MULT = 1
 
      IF(CR_TITLE(1:9).EQ.'code_CSD:') ICSD = 1

C
C     previous residue and chain number
C
      CR_RES_OLD    = '?????' 
      CR_IRES_OLD   = -100 
      CR_IGROUP_OLD = -100
      CR_GROUP_OLD  = '????'
C
C     for first call of RDCRD_CIF iend = -1
C
      IEND          = -1
C --------------------------------
C     start atom's loop 
C 

 200  CONTINUE

C
C     read atom's information from file and put to commons: ....
C 
      IF(ICSD.EQ.0) THEN
        CALL RDCRD_CIF(M,IN,MODE,IEND,IERR)
      ELSE
        CALL RDCRD_CSD(M,IN,MODE,IEND,IERR)
      ENDIF
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: read input file')
        CLOSE(CRI_IUN)
        IERR = 3
        RETURN
      ENDIF
C
C     IEND.NE.0 - end of file
C     
      IF(IEND.NE.0) THEN
        GO TO 300
      ENDIF
      IF(MODE.EQ.0) THEN
C
C       coordinates of atom       
C        
        IF(CR_IATOLD.LE.0) GO TO 200
C
C       keep info into commons: ....
C
        CALL SET_ATOM(MDOC,CR_RES_OLD,CR_GROUP_OLD
     *   ,CR_IRES_OLD,CR_IGROUP_OLD,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERROR: read input file')
          CLOSE(CRI_IUN)
          IERR = 4
          RETURN
        ENDIF

        IF(CR_CORR.NE.' '     .AND.CR_CORR.NE.'.'     ) OUT_CIF_CORR=0 
C       IF(CR_PNUM(7:7).NE.' '.AND.CR_PNUM(7:7).NE.'.') OUT_CIF_INS =0 
        IF(CR_MULT_FACTOR.NE.1.AND.CR_MULT_FACTOR.NE.0) OUT_CIF_MULT=0 

        CR_RES_OLD    = CR_PNUM(3:7)
        CR_IRES_OLD   = CR_IRES
        CR_IGROUP_OLD = CR_IGROUP 
        CR_GROUP_OLD  = CR_GROUP 

      ELSE
C
C       comments
C
C       CR_LINE - string of comments 

      ENDIF      
C ----
      GO TO 200
C
C     end of atom's loop
C --------------------------------------
 300  CONTINUE

      CALL COPY_ENTITY_TREE(MDOC,IERR)

C --------------------------------------
      WRITE(LINE,'('' Number of chains     :'',I8)') N_GROUP
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of monomers   :'',I8)') N_RESIDUE
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of atoms      :'',I8)') N_ATOM
      CALL MSGDOC(MDOC,LINE)
C --------------------------------------
      IF(ISG_FLAG.EQ.0.AND.ICELL_FLAG.EQ.0) THEN
        IERR = 9
      ELSE IF(ISG_FLAG.EQ.0) THEN
        IERR = 8
      ELSE IF(ICELL_FLAG.EQ.0) THEN
        IERR = 7
      ENDIF

      RETURN
      END

      SUBROUTINE SET_ATOM(MDOC,CR_RES_OLD,CR_GROUP_OLD
     *  ,CR_IRES_OLD,CR_IGROUP_OLD,IERR)
C ---------------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C ---------------------------------------------------------------
      REAL      X(3),Y(3)
      INTEGER   CR_IRES_OLD,CR_IGROUP_OLD
      CHARACTER LINE*256,CHAR2*2,CHAR4*4,RNUMS*5,MON_N*8
      CHARACTER CR_RES_OLD*5,RNUM*5,CHAR5*5,CR_GROUP_OLD*4,MON*8
      CHARACTER TYPE*1,ELEMENT*4
C     CHARACTER CHAR8*8,CHAR6*6
C ---------------------------------------------------------------  
      IERR  = 0      
      PI    = 4.0*ATAN(1.0)
      CONST = 8.0*PI*PI
C     IF(CR_IGROUP_OLD.NE.CR_IGROUP) THEN
      IF(CR_GROUP_OLD.NE.CR_GROUP) THEN

C ---   NEW CHAIN

        N_GROUP = N_GROUP+1
        IF(N_GROUP.GT.MAXCHAIN) THEN
          CALL MSGERR(MDOC
     *    ,' ERROR: number of chains in asym. part > limit ')
          CALL MSGERR(MDOC
     *    ,'        change parameter MAXCHAIN in atom_com.fh')
          IERR=1
          RETURN
        ENDIF   

        NRES_CHAIN  (N_GROUP) = 0
        IRES_FIRST  (N_GROUP) = N_RESIDUE+1
        NATM_CHAIN  (N_GROUP) = 0
        ICHAIN_GRP  (N_GROUP) = N_GROUP
        ICH_TYPE    (N_GROUP) = 1
        MULT_FLAG   (N_GROUP) = 1
        NCS_FLAG    (N_GROUP) = '.'
        I_NCS       (N_GROUP) = 1
        ITERM_S_TYPE(N_GROUP) = 1
        ITERM_F_TYPE(N_GROUP) = 1

        IF(N_GRP_ASM.GT.0) THEN
          DO IASM=1,N_GRP_ASM
            IF(ASM_GROUP_ID(IASM).EQ.CR_GROUP) THEN
              IF(ASM_CHAIN_POINTER(IASM).GT.0) THEN

                GROUP_ID  (N_GROUP)     = CR_GROUP
                IPNT                    = ASM_CHAIN_POINTER(IASM)
                CHAIN_ID  (N_GROUP)     = ENT_CHAIN_ID(IPNT)
                IGROUP_ASM(N_GROUP)     = IASM
                ASM_GROUP_POINTER(IASM) = N_GROUP
                ICH_TYPE  (N_GROUP)     = ENT_ICHAIN_TYPE(IPNT)

                GO TO 200
              ENDIF
            ENDIF
          ENDDO
        ENDIF

        GROUP_ID    (N_GROUP) = CR_GROUP
        CHAIN_ID    (N_GROUP) = CR_GROUP
        IGROUP_ASM  (N_GROUP) = 0

 200    CONTINUE

        IATOM_FIRST (N_GROUP) = N_ATOM+1   
        CR_IRES_OLD           = -100
        CR_RES_OLD            = '?????' 

      ENDIF

      RNUM = CR_PNUM(3:7)

C      IF(CR_IRES_OLD.NE.CR_IRES) THEN

      IF(CR_RES_OLD.NE.RNUM) THEN
C
C ---   NEW RESIDUE /MONOMER/
C       
        N_RESIDUE = N_RESIDUE + 1   
        IF(N_RESIDUE.GT.MAXRESID) THEN
          CALL MSGERR(MDOC
     *    ,' ERROR: number of monomers > limit.')
          CALL MSGERR(MDOC
     *    ,'        change parameter MAXRESID in atom_com.fh')
          IERR=1
          RETURN
        ENDIF

        IRES_FORW(N_RESIDUE) = 0 
        IF(NRES_CHAIN(N_GROUP).EQ.0) THEN
          IRES_BACK(N_RESIDUE)     = -1   
          IRES_START_TREE(N_GROUP) = N_RESIDUE 
        ELSE
          IRES_BACK(N_RESIDUE  ) = N_RESIDUE-1 
          IRES_FORW(N_RESIDUE-1) = N_RESIDUE 
        ENDIF
        IRES_END_TREE(N_GROUP)  = N_RESIDUE 
   
        NRES_CHAIN  (N_GROUP)   = NRES_CHAIN(N_GROUP)+1
        NATM_RES    (N_RESIDUE) = 0
        IRES_SERIAL (N_RESIDUE) = CR_IRES    
        IRATM_FIRST (N_RESIDUE) = N_ATOM + 1
        I_CHAIN     (N_RESIDUE) = N_GROUP
        RES_NAME    (N_RESIDUE) = CR_RNAME
        LINK_FLAG   (N_RESIDUE) = 'N'
        MOD_FLAG    (N_RESIDUE) = 'N'

C ----
        WRITE(RNUMS,'(I5)') CR_IRES

        IF(RNUMS(2:5).NE.RNUM(1:4)) OUT_CIF_INS =0


        RNUMS = CR_PNUM(3:7)


        CHAR2(1:2)              = GROUP_ID(N_GROUP)(1:2)
        RES_NUM_PDB (N_RESIDUE) = CHAR2//CR_PNUM(3:7)//
     *                            GROUP_ID(N_GROUP)//' '


C        CALL SET_INI_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
        CALL GET_INI_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
        IRES_TYPE  (N_RESIDUE) = ITYPE

        IF(NRES_CHAIN(N_GROUP).LE.1) THEN
          ICH_TYPE    (N_GROUP) = 2
          ICONN_TYPE(N_RESIDUE) = 1
        ELSE
          ICH_TYPE    (N_GROUP) = 10
          IF(ITYPE.EQ.3) THEN
            ICONN_TYPE(N_RESIDUE) = 2
            IF(RES_NAME(N_RESIDUE).EQ.'PRO'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'5HP'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'DPR'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'PCA'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'PRO-D'.OR.
     *         RES_NAME(N_RESIDUE).EQ.'5HP-D'.OR.
     *         RES_NAME(N_RESIDUE).EQ.'HYP-D'.OR.
     *         RES_NAME(N_RESIDUE).EQ.'HYP'      ) 
     *         ICONN_TYPE(N_RESIDUE) = 36
            IF(RES_NAME(N_RESIDUE).EQ.'BMT'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'SAR'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'MLE'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'MVA'      ) 
     *         ICONN_TYPE(N_RESIDUE) = 38
            ICH_TYPE    (N_GROUP) = 3
          ELSE IF(ITYPE.EQ.5) THEN
            ICONN_TYPE(N_RESIDUE) = 4
            ICH_TYPE    (N_GROUP) = 5
          ELSE IF(ITYPE.EQ.7) THEN
            ICONN_TYPE(N_RESIDUE) = 10
            ICH_TYPE    (N_GROUP) = 7
          ENDIF
          IF(NRES_CHAIN(N_GROUP).EQ.1) ICONN_TYPE(N_RESIDUE) = 1
        ENDIF

        IF(CR_RNAME.EQ.'HOH'.OR.CR_RNAME.EQ.'DUM') THEN
          ICH_TYPE(N_GROUP)     = 9
          ICONN_TYPE(N_RESIDUE) = 1
        ENDIF

        CHAR4 = GROUP_ID(N_GROUP)
        IF(LN_N.GT.0) THEN
          DO IL=1,LN_N
            IF(LN_1CHN(IL).EQ.CHAR4) THEN
              CHAR5 = LN_SEQ1(IL)
              IF(CHAR5.EQ.RNUMS) THEN
                LN_1IRES (IL) = N_RESIDUE
                LN_1ICHN (IL) = N_GROUP
                LN_1RNAM (IL) = CR_RNAME
                LINK_FLAG(N_RESIDUE) = 'Y'
              ENDIF
            ENDIF
            IF(LN_2CHN(IL).EQ.CHAR4) THEN
              CHAR5 = LN_SEQ2(IL)
              IF(CHAR5.EQ.RNUMS) THEN
                LN_2IRES (IL) = N_RESIDUE
                LN_2ICHN (IL) = N_GROUP
                LN_2RNAM (IL) = CR_RNAME
                CALL SET_ICONN(LN_ID(IL),ICONN)
                IF(ICONN.GT.1.AND.ICONN.LE.N_CONN_TYPE) THEN
                  LINK_FLAG(N_RESIDUE) = 'Y'
C                 IF(LN_ID(IL).EQ.'CIS' ) ICONN_TYPE(N_RESIDUE) = 3
C                 IF(LN_ID(IL).EQ.'PCIS') ICONN_TYPE(N_RESIDUE) = 37
C                 IF(LN_ID(IL).EQ.'gap' ) ICONN_TYPE(N_RESIDUE) = 10
                  ICONN_TYPE(N_RESIDUE) = ICONN
                ENDIF
              ENDIF
            ENDIF
          ENDDO
        ENDIF

        IF(MOD_N.GT.0) THEN
          DO IM=1,MOD_N
            IF(MOD_CHN(IM).EQ.CHAR4) THEN
                CHAR5 = MOD_SEQ(IM)
                IF(CHAR5.EQ.RNUMS) THEN
                  MOD_IRES (IM) = N_RESIDUE
                  MOD_ICHN (IM) = N_GROUP
                  MOD_FLAG(N_RESIDUE) = 'Y'

                  MON           = MOD_RNAM    (IM)
                  MON_N         = MOD_RNAM_NEW(IM)

                  IF(MON_N.NE.MON.AND.MON(1:1).NE.'.'.AND.
     *                                MON(1:1).NE.' '     ) THEN 
C                    CALL SET_INI_RES_TYPE(MDOC,LINE,MON,ITYPE,IERR)
                    CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITYPE,IERR)
                    IRES_TYPE(N_RESIDUE) = ITYPE
                  ENDIF
                ENDIF
            ENDIF
          ENDDO
        ENDIF

      ENDIF

      N_ATOM = N_ATOM + 1   
      IF(N_ATOM.GT.MAXATOM) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of atoms > limit.')
        CALL MSGERR(MDOC
     *  ,'        change parameter MAXATOM in atom_com.fh')
        IERR=1
        RETURN
      ENDIF   
C
C      I_ATOM   (N_ATOM)    = N_ATOM
C
      NATM_CHAIN(N_GROUP)   = NATM_CHAIN(N_GROUP)   + 1
      NATM_RES  (N_RESIDUE) = NATM_RES  (N_RESIDUE) + 1
      I_RESID   (N_ATOM)    = N_RESIDUE
      I_ATOLD   (N_ATOM)    = CR_IATOLD

      B_FLAG    (N_ATOM)    = 0

      IF(CR_BTYPE.EQ.'a'.OR.CR_BTYPE.EQ.'A') THEN
        N_ANISO = N_ANISO + 1   
        B_FLAG   (N_ATOM)    = N_ATOM
        DO IAN=1,6
          U_ANISO  (IAN,N_ATOM ) = CR_ANIS(IAN)  
        ENDDO
      ELSE
C
C      B_ISO    (N_ATOM)    = CR_BISO
C
        U_ANISO(1,N_ATOM) = CR_BISO/CONST
        U_ANISO(2,N_ATOM) = 0.0
        U_ANISO(3,N_ATOM) = 0.0
        U_ANISO(4,N_ATOM) = 0.0
        U_ANISO(5,N_ATOM) = 0.0
        U_ANISO(6,N_ATOM) = 0.0
      ENDIF 

      ATM_NAME (N_ATOM)    = CR_ANAME  
      IF(CR_ANAME_INP(1:1).NE.'.'.AND.CR_ANAME_INP(1:1).NE.' ') THEN
        ATM_NAME_INP(N_ATOM) = CR_ANAME_INP
      ELSE
        ATM_NAME_INP(N_ATOM) = CR_ANAME
      ENDIF

      ATM_CHEM(N_ATOM) = ST_CHEM

      INSF = 0          
      IF(CR_ASYMB(1:1).EQ.'?') GO TO 100

      ELEMENT = CR_ASYMB

      CALL CHKSMB(CR_ASYMB(2:2),TYPE)
      IF(TYPE.EQ.'D'.OR.TYPE.EQ.'S') CR_ASYMB(2:2) = ' '
      CR_ASYMB(3:3) = ' '
      CR_ASYMB(4:4) = ' '

      IF(CS_NSFATM.GT.0) THEN

        DO ISF=1,CS_NSFATM
          IF(ELEMENT.EQ.CS_ELEMENT(ISF)) THEN
            INSF = ISF
            GO TO 100
          ENDIF
        ENDDO

      ENDIF

      IF(CS_NSFATM.GE.MAXNSF) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of atomic scattering types > limit.')
        CALL MSGERR(MDOC
     *  ,'        change parameter MAXNSF in atom_com.fh')
        IERR=1
        RETURN
      ENDIF

      CS_NSFATM            = CS_NSFATM + 1
      INSF                 = CS_NSFATM
      CS_ATYPE  (INSF)     = CR_ASYMB 
      CS_ELEMENT(INSF)     = ELEMENT 

 100  CONTINUE

      ID_SF    (N_ATOM)    = INSF
      ATM_TYPE (N_ATOM)    = CR_ATYPE
      ID_ALT   (N_ATOM)    = CR_ALT
      ID_CORR  (N_ATOM)    = CR_CORR

      CALL NB_MVMULT(CS_SCALE,CR_XYZ,Y)
      Y(1) = Y(1) + CS_U(1)
      Y(2) = Y(2) + CS_U(2)
      Y(3) = Y(3) + CS_U(3)
      CALL NB_MVMULT(CS_FRAC_TO_ORT,Y,X)

      XYZ_CRD  (1,N_ATOM)  = X(1)  
      XYZ_CRD  (2,N_ATOM)  = X(2)  
      XYZ_CRD  (3,N_ATOM)  = X(3)  

      OCCUP    (N_ATOM)    = CR_OCC
      MULT_FACTOR(N_ATOM)  = CR_MULT_FACTOR

      ITYPE = IRES_TYPE(N_RESIDUE) 

      IF(ITYPE.EQ.5.AND.CR_ANAME.EQ.'O2* )'.AND.
     *                     CR_RNAME(1:1).NE.'U') THEN
        IRES_TYPE  (N_RESIDUE) = 6
      ENDIF

      IF((ITYPE.EQ.5.OR.ITYPE.EQ.5).AND.CR_ANAME.EQ.'O3T ') THEN
        ITERM_S_TYPE(N_GROUP) = 4
      ELSE IF((ITYPE.EQ.3.OR.ITYPE.EQ.4).AND.CR_ANAME.EQ.'OXT ') THEN
        ITERM_F_TYPE(N_GROUP) = 2
      ENDIF

      RETURN
      END


      SUBROUTINE OPEN_CRDCIF(MDOC,IN,PATH,NAME,EXT
     * ,NOSPGR_INPUT,CELL_INPUT,ISG_FLAG,ICELL_FLAG,IERR)
C -----------------------------------------------------------
      INTEGER   ISG_FLAG,ICELL_FLAG
      INTEGER   MDOC,IN,IERR
      INTEGER   NOSPGR_INPUT
      REAL      CELL_INPUT(6)
      CHARACTER NAME*(*),EXT*(*),PATH*(*)
C -----------------------------------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C -----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C -----------------------------------------------------------
      INTEGER   IDATA
      REAL      FDATA
      CHARACTER DATA*80,ITEM*80
      INTEGER   NOSPGR,ISETT
      CHARACTER SGNAME*24
C ---
      INTEGER   IGRP,ILN,IMD
      CHARACTER LINK*8,MOD*8,RES1*8,RES2*8
      CHARACTER LINE*256
      CHARACTER CH10*10,RES_NEW*8,RNUM1*5,RNUM2*5,CH5*5
      CHARACTER ATOM1*5,ATOM2*5,SYMM1*8,SYMM2*8,CHN1*4,CHN2*4
      CHARACTER ALT1*1,ALT2*1,CHAR8*8,TYPE16*16,ENT_CHN_OLD*4
      CHARACTER LINK_ID*80
C ==
      CHARACTER GROUP*4,CHAIN*4,TYPE*1,RNUM1A*5,RNUM2A*5
C ==
c     CHARACTER NCSF*1,GID*4,CH2*2
c     INTEGER   INC,MLT
C -----------------------------------------------------------
      INCLUDE 'CIF_items_crd.fh'
C ------------------------------------------------------------
      PI    = 4.0*ATAN(1.0)
      PI180 = PI/180.0
      IERR  = 0
      M     = 99
C ----------------------------------------------------------
C  --- initialization --
C     
      CALL INIT_CRD_INF(MDOC,IERR)
C ----------------------------------------------------------
C     open file
C
c      CRI_FILE = NAME
c      CRI_PATH = PATH
c      CRI_EXT  = EXT      
C ---
      CRI_IUN = IN
      CALL OPENFR(IN,M,PATH,NAME,EXT,IERR)
      CRI_IUN = IN
      IF(IERR.NE.0) THEN
        IERR=1
        CALL MSGERR(MDOC,' ERROR: open input file')
        RETURN
      ENDIF
C ---------------------
      PROG_NAME_CRD = '.'
      CS_NSYMOP     = 0
      ICSD          = 0
      ISCALE        = 0
      IGRP          = 0
      ILN           = 0
      IMD           = 0
      ICHN          = 0
      CR_SOFT       = '.'
      N_CHN_ENT     = 0
      ENT_NRESIDUE  = 0
      ENT_LN_N      = 0
      ENT_CHN_OLD   = '?'
      IRES_SER      = 0
      N_GRP_ASM     = 0
      ISG_FLAG      = 0
      ICELL_FLAG    = 0
C     for fist call iend = -1
      IEND = -1
C -------------------------------------------------------
  300 CONTINUE   
      CALL GETCIF_INFO(IN,MDOC,IERR,IEND)
      IF(IERR.NE.0) THEN
        IERR=3
        RETURN
      ENDIF
      IF(IEND.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment string
C   
        GO TO 300
      ELSE IF(IEND.NE.0) THEN
        IERR=2
        RETURN
      ENDIF
      IF(N_CIF.LE.0) GO TO 300

      DO I=1,N_CIF

        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM  = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA  = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IDATA = IDT_CIF(I)
        FDATA = FDT_CIF(I)

C       ---_software.name 
        CALL LENSTR_BL(ICS_SOFT_NAME,L)
        IF(ITEM(1:LENI).EQ.ICS_SOFT_NAME(1:L)) THEN
          PROG_NAME_CRD = '.'
          IF(DATA(1:5).EQ.'blanc') THEN
            CR_SOFT       = 'B' 
            PROG_NAME_CRD = 'B'
          ENDIF
        ENDIF

        CALL LENSTR_BL(ICS_ENTRY_ID,L)
        CALL LENSTR_BL(ICS_CAT_PDB ,LC)
        IF((ITEM(1:18).EQ.'_database_PDB_code'  ).OR.
     *     (ITEM(1:18).EQ.'_database_PDB.code'  ).OR.
     *     (ITEM(1:LC).EQ.ICS_CAT_PDB(1:LC)     ).OR.
     *     (ITEM(1:18).EQ.'_database.code_PDB'  ).OR.
     *     (ITEM(1:L ).EQ.ICS_ENTRY_ID(1:L)     )) THEN
C ---     _entry.id ---
       
          CR_CD_PDB = '    '
          IF(LEND.GT.4) LEND = 4
          IF(LEND.GT.0) CR_CD_PDB = DATA(1:LEND)
          IF(LEND.LT.4) THEN
            DO II=LEND+1,4
              CR_CD_PDB(II:II) = ' '
            ENDDO
          ENDIF

          GO TO 410
        ENDIF

        IF((ITEM(1:20).EQ.'_database_2.code_NDB').OR.
     *     (ITEM(1:18).EQ.'_database.code_NDB'  )) THEN         
C ---     _database.code_NDB ---

          CR_CD_NDB = '?'
          IF(LEND.GT.8) LEND = 8
          CR_CD_NDB = DATA(1:LEND)
          IF(LEND.LT.8) THEN
            DO II=LEND+1,8
              CR_CD_NDB = ' '
            ENDDO
          ENDIF
          CR_INFO_FLAG = 'N'

          GO TO 410
        ENDIF

        CALL LENSTR_BL(ICS_KEYWORD_1,L1)
        CALL LENSTR_BL(ICS_KEYWORD_2,L2)
        IF((ITEM(1:18).EQ.'_database_PDB_name').OR.
     *     (ITEM(1:L1).EQ.ICS_KEYWORD_1(1:L1) ).OR.
     *     (ITEM(1:L2).EQ.ICS_KEYWORD_2(1:L2) )) THEN
C ---     __struct.keywords ---

          CR_NAME_PDB = '?'
          IF(LEND.GT.80) LEND = 80
          CR_NAME_PDB = DATA(1:LEND)
          IF(LEND.LT.80) THEN
            DO II=LEND+1,80
              CR_NAME_PDB(II:II) = ' '
            ENDDO
          ENDIF
          CR_NAME_NDB = CR_NAME_PDB

          GO TO 410
        ENDIF

        IF(ITEM(1:18).EQ.'_database_code_CSD') THEN
          ICSD = 1
          CR_TITLE = 'code_CSD:'//DATA(1:LEND)
        ENDIF

        CALL LENSTR_BL(ICS_DATE_PDB,L)
        IF((ITEM(1:18).EQ.'_database_PDB_date').OR.
     *     (ITEM(1:18).EQ.'_database_PDB.date').OR.
     *     (ITEM(1:L ).EQ.ICS_DATE_PDB(1:L)   )) THEN         
C ---     _audit.creation_date ---

          CR_DATE_PDB = '?        '
          IF(LEND.GT.10) LEND = 10
          CH10 = DATA(1:LEND)
          IF(CH10(5:5).EQ.'-') THEN
            CALL CHNG_DATE_BACK(CH10,CR_DATE_PDB)         
          ELSE
            CR_DATE_PDB = CH10(1:9)
          ENDIF

          GO TO 410
        ENDIF

        IF((ITEM(1:31).EQ.'_database_PDB_rev.date_original').OR.        
     *     (ITEM(1:31).EQ.'_database_NDB_rev.date_original')) THEN         
C ---     _database_NDB_rev.date_original --  

          CR_DATE_PDB = '         '
          IF(LEND.GT.10) LEND = 10
          CH10 = DATA(1:LEND)
          IF(CH10(5:5).EQ.'-') THEN
            CALL CHNG_DATE_BACK(CH10,CR_DATE_PDB)         
          ENDIF

          IF(CR_INFO_FLAG.EQ.'N') THEN
            CR_DATE_NDB = CH10
          ENDIF

          GO TO 410
        ENDIF

        CALL LENSTR_BL(ICS_TITLE,L)
        IF((ITEM(1:13).EQ.'_struct_title').OR.
     *     (ITEM(1:L ).EQ.ICS_TITLE(1:L) )) THEN     
C ---     _struct.title ---

          IF(LEND.GT.80) LEND = 80
          CR_TITLE = DATA(1:LEND)
          IF(LEND.LT.80) THEN
            DO II=LEND+1,80
              CR_TITLE(II:II) = ' '
            ENDDO
          ENDIF
          IF(CR_INFO_FLAG.EQ.'N') THEN
            CR_NDB_TITLE = CR_TITLE(1:LEND)
          ENDIF


          GO TO 410
        ENDIF

        IF(ITEM(1:19).EQ.'_file_creation_date') THEN
C ---      _file_creation_date ----
         
          IF(LEND.GT.20) LEND = 20
          CR_TIME = DATA(1:LEND)

          GO TO 410
        ENDIF

        IF((ITEM(1:19).EQ.'_database_PDB_model').OR.
     *     (ITEM(1:19).EQ.'_database_PDB.model')) THEN
C ---     _database_PDB.model ---

          CR_MODEL_PDB = IDATA

          GO TO 410
        ENDIF

        IF((ITEM(1:31).EQ.'_database_PDB_remark_resolution').OR.
     *     (ITEM(1:31).EQ.'_database_PDB.remark_resolution')) 
     *       THEN
C ---     _database_PDB.remark_resolution ---

          CR_RESL_PDB = DATA(1:LEND)              

          GO TO 410
        ENDIF

        IF((ITEM(1:29).EQ.'_database_PDB_remark_R_factor').OR.
     *     (ITEM(1:29).EQ.'_database_PDB.remark_R_factor')) THEN
C ---     _database_PDB.remark_R_factor

          CR_RFAC_PDB = DATA(1:LEND)

          GO TO 410
        ENDIF

        IF(ITEM(1:20).EQ.'_diffrn.ambient_temp') THEN
C ---     _diffrn.ambient_temp ---
C         The mean temperature in kelvins at which the intensities were
C         measured.
C

C          IF(LEND.GT.5) LEND=5
C            TEMPER = DATA(1:LEND)
C          IF(LEND.LT.5) THEN
C            DO II=LEND+1,5
C              TEMPER(II:II)=' '
C            ENDDO
C          ENDIF
          CR_TEMPER = FDATA

          GO TO 410
        ENDIF

        IF((ITEM(1:28).EQ.'_diffrn_radiation.wavelength'.AND.
     *           LENI.EQ.28).OR.
     *     (ITEM(1:32).EQ.'_diffrn_radiation_wavelength.wav'))THEN 
C ---    _diffrn_radiation_wavelength.wavelength            1.54
C
C          IF(LEND.GT.5) LEND=5
C     ???     WAVE = DATA(1:LEND)
C          IF(LEND.LT.5) THEN
C            DO II=LEND+1,5
C              WAVE(II:II)=' '
C            ENDDO
C          ENDIF
          CR_WAVEL=FDATA

          GO TO 410
        ENDIF

        IF(ITEM(1:20).EQ.'_refine.ls_d_res_low') THEN
C ---     _refine.ls_d_res_low ---

          IF(CR_RES_RMIN.LE.0.0) CR_RES_RMIN = FDATA

          GO TO 410
        ENDIF

        IF(ITEM(1:21).EQ.'_refine.ls_d_res_high') THEN
C ---     _refine.ls_d_res_high ---

          IF(CR_RES_RMAX.LE.0.0) CR_RES_RMAX = FDATA

          GO TO 410
        ENDIF

        IF(ITEM(1:25).EQ.'_reflns.d_resolution_high') THEN
C ---     _reflns.d_resolution_high ---
C         The highest resolution for the interplanar spacings in
C         the reflection data. This is the smallest d value.

          IF(CR_RES_MAX.LE.0.0) CR_RES_MAX = FDATA

          GO TO 410
        ENDIF

        IF(ITEM(1:24).EQ.'_reflns.d_resolution_low') THEN
C ---     _reflns.d_resolution_low ---
C         The lowest resolution for the interplanar spacings in the
C         reflection data. This is the largest d value.

          IF(CR_RES_MIN.LE.0.0) CR_RES_MIN = FDATA

          GO TO 410
        ENDIF

        IF(ITEM(1:23).EQ.'_refine.ls_R_factor_all') THEN
C ---     _refine.ls_R_factor_all ---
C         Residual factor R for all reflections that satisfy the resolution
C         limits established by _refine.ls_d_res_high and _refine.ls_d_res_low

          IF(DATA(1:1).NE.'?'.AND.DATA(1:1).NE.'.') THEN
            IF(CR_RFAC_ALL.LE.0.0) CR_RFAC_ALL = FDATA
          ENDIF

          GO TO 410
        ENDIF

        IF(ITEM(1:23).EQ.'_refine.ls_R_factor_obs') THEN
C         save__refine.ls_R_factor_obs
C         Residual factor R for reflections that satify the resolution
C         limits established by _refine.ls_d_res_high and 
C         _refine.ls_d_res_low and the observation limit established by
C         _reflns.observed_criterion.

          IF(DATA(1:1).NE.'?'.AND.DATA(1:1).NE.'.') THEN
            IF(CR_RFAC_OBS.LE.0.0) CR_RFAC_OBS = FDATA
            IF(CR_RFAC_CUT.LE.0.0) CR_RFAC_CUT = FDATA
          ENDIF

          GO TO 410
        ENDIF

        IF(ITEM(1:26).EQ.'_refine.ls_R_factor_R_free') THEN
C ---     _refine.ls_R_factor_R_free ---
C         Residual factor R for reflections that satisfy the resolution
C         limits established by _refine.ls_d_res_high and
C         _refine.ls_d_res_low and the observation limit established by
C         _reflns.observed_criterion, and that were used as the test
C         (i.e., excluded from refinement) reflections when refinement
C         included calculation of a "free" R-factor. Details of how
C         reflections were assigned to the working and test sets are
C         given in _reflns.R_free_details.

          IF(DATA(1:1).NE.'?'.AND.DATA(1:1).NE.'.') THEN
            IF(CR_RFREE_CUT.LE.0.0) CR_RFREE_CUT = FDATA
          ENDIF
         
          GO TO 410
        ENDIF

        IF(ITEM(1:34).EQ.'_reflns.observed_criterion_sigma_F') THEN
C ---     _reflns.observed_criterion_sigma_F ---
C         The criterion used to classify a reflection as 'observed',
C         expressed as a multiple of the value of sigma(F).

          IF(DATA(1:1).NE.'?'.AND.DATA(1:1).NE.'.') THEN
            IF(CR_SIGMA_F.LE.0.0) CR_SIGMA_F = FDATA
          ENDIF
        
          GO TO 410
        ENDIF

        IF(ITEM(1:22).EQ.'_refine.ndb_ls_sigma_F') THEN
C ---     _refine.ndb_ls_sigma_F ---  
          IF(DATA(1:1).NE.'?'.AND.DATA(1:1).NE.'.') THEN
            IF(CR_SIGMAR_F.LE.0.0) CR_SIGMAR_F = FDATA
          ENDIF

          GO TO 410
        ENDIF

        IF(ITEM(1:34).EQ.'_reflns.observed_criterion_sigma_I') THEN
C ---     _reflns.observed_criterion_sigma_I ---
C         The criterion used to classify a reflection as 'observed',
C         expressed as a multiple of the value of sigma(I).  

          IF(DATA(1:1).NE.'?'.AND.DATA(1:1).NE.'.') THEN
            IF(CR_SIGMA_I.LE.0.0) CR_SIGMA_I    = FDATA
          ENDIF

          GO TO 410
        ENDIF

        IF(ITEM(1:22).EQ.'_refine.ndb_ls_sigma_I') THEN

          IF(DATA(1:1).NE.'?'.AND.DATA(1:1).NE.'.') THEN
            IF(CR_SIGMAR_I.LE.0.0) CR_SIGMAR_I = FDATA
          ENDIF

          GO TO 410
        ENDIF

        IF(ITEM(1:20).EQ.'_reflns.Rmerge_F_all') THEN
C ---     _reflns.Rmerge_F_all ---
C         Residual factor Rmerge for all reflections that satify the
C         resolution limits established by _reflns.d_resolution_high 
C         and _reflns.d_resolution_low.

          IF(CR_RMERG_ALL.LE.0.0) CR_RMERG_ALL = FDATA

          GO TO 410
        ENDIF

        IF(ITEM(1:20).EQ.'_reflns.Rmerge_F_obs') THEN
C ---     _reflns.Rmerge_F_obs ---
C         Residual factor Rmerge for reflections that satify the
C         resolution limits established by _reflns.d_resolution_high
C         and _reflns.d_resolution_low and the observation limit
C         established by _reflns.observed_criterion.

          IF(CR_RMERG_OBS.LE.0.0) CR_RMERG_OBS = FDATA

          GO TO 410
        ENDIF

        IF(ITEM(1:20).EQ.'_reflns.Rmerge_I_obs') THEN
C ---     _reflns.Rmerge_F_obs ---
C         Residual factor Rmerge for reflections that satify the
C         resolution limits established by _reflns.d_resolution_high
C         and _reflns.d_resolution_low.

          IF(CR_RMERG_IOBS.LE.0.0) CR_RMERG_IOBS = FDATA

          GO TO 410
        ENDIF

        IF(ITEM(1:31).EQ.'_computing.structure_refinement') THEN
C ---     _computing.structure_refinement ---

          CR_PROGRAM = DATA(1:LEND)

          GO TO 410
        ENDIF

        CALL LENSTR_BL(ICS_CELL_CAT,LC)
        IF((ITEM(1:LC) .EQ.ICS_CELL_CAT(1:LC)).OR.         
     *     (ITEM(1:6) .EQ.'_cell_'           )) THEN         
C ---     _cell.length   _cell.angle_ ---

          LC1 = LC + 1
          CALL LENSTR_BL(ICS_CELL1,L1)
          CALL LENSTR_BL(ICS_CELL2,L2)
          CALL LENSTR_BL(ICS_CELL3,L3)
          CALL LENSTR_BL(ICS_CELL4,L4)
          CALL LENSTR_BL(ICS_CELL5,L5)
          CALL LENSTR_BL(ICS_CELL6,L6)

          IF(ITEM(LC1:L1).EQ.ICS_CELL1(LC1:L1)) THEN
            IF(ICSD.LE.0) THEN
              CR_CELL(1) = FDATA
            ELSE
              CALL CLEAN_DATA_CSD(DATA)
              CALL LENSTR_BL(DATA,L)
              READ(DATA(1:L),*) CR_CELL(1)
            ENDIF
            ICELL_FLAG = ICELL_FLAG + 1
          ELSE IF(ITEM(LC1:L2).EQ.ICS_CELL2(LC1:L2)) THEN
            IF(ICSD.LE.0) THEN
              CR_CELL(2) = FDATA
            ELSE
              CALL CLEAN_DATA_CSD(DATA)
              CALL LENSTR_BL(DATA,L)
              READ(DATA(1:L),*) CR_CELL(2)
            ENDIF
            ICELL_FLAG = ICELL_FLAG + 1
          ELSE IF(ITEM(LC1:L3).EQ.ICS_CELL3(LC1:L3)) THEN
            IF(ICSD.LE.0) THEN
              CR_CELL(3) = FDATA
            ELSE
              CALL CLEAN_DATA_CSD(DATA)
              CALL LENSTR_BL(DATA,L)
              READ(DATA(1:L),*) CR_CELL(3)
            ENDIF
            ICELL_FLAG = ICELL_FLAG + 1
          ELSE IF(ITEM(LC1:L4).EQ.ICS_CELL4(LC1:L4)) THEN
            IF(ICSD.LE.0) THEN
              CR_CELL(4) = FDATA
              ICELL_FLAG = ICELL_FLAG + 1
            ELSE
              CALL CLEAN_DATA_CSD(DATA)
              CALL LENSTR_BL(DATA,L)
              READ(DATA(1:L),*) CR_CELL(4)
            ENDIF
            CR_CELL(4) = CR_CELL(4)*PI180
            ICELL_FLAG = ICELL_FLAG + 1
          ELSE IF(ITEM(LC1:L5).EQ.ICS_CELL5(LC1:L5)) THEN
            IF(ICSD.LE.0) THEN
              CR_CELL(5) = FDATA
            ELSE
              CALL CLEAN_DATA_CSD(DATA)
              CALL LENSTR_BL(DATA,L)
              READ(DATA(1:L),*) CR_CELL(5)
            ENDIF
            CR_CELL(5) = CR_CELL(5)*PI180
            ICELL_FLAG = ICELL_FLAG + 1
          ELSE IF(ITEM(LC1:L6).EQ.ICS_CELL6(LC1:L6)) THEN
            IF(ICSD.LE.0) THEN
              CR_CELL(6) = FDATA
            ELSE
              CALL CLEAN_DATA_CSD(DATA)
              CALL LENSTR_BL(DATA,L)
              READ(DATA(1:L),*) CR_CELL(6)
            ENDIF
            CR_CELL(6) = CR_CELL(6)*PI180
            ICELL_FLAG = ICELL_FLAG + 1
          ENDIF
          GO TO 410
        ENDIF
C ---     scale & vector U
        CALL LENSTR_BL(ICS_SCALE_CAT,LC)
        IF(ITEM(1:LC).EQ.ICS_SCALE_CAT(1:LC)) THEN

          CALL LENSTR_BL(ICS_SCALE11,LS11)
          CALL LENSTR_BL(ICS_SCALE12,LS12)
          CALL LENSTR_BL(ICS_SCALE13,LS13)
          CALL LENSTR_BL(ICS_SCALE21,LS21)
          CALL LENSTR_BL(ICS_SCALE22,LS22)
          CALL LENSTR_BL(ICS_SCALE23,LS23)
          CALL LENSTR_BL(ICS_SCALE31,LS31)
          CALL LENSTR_BL(ICS_SCALE32,LS32)
          CALL LENSTR_BL(ICS_SCALE33,LS33)
          CALL LENSTR_BL(ICS_U11    ,LU1 )
          CALL LENSTR_BL(ICS_U22    ,LU2 )
          CALL LENSTR_BL(ICS_U33    ,LU3 )

          LC1 = LC + 1

          IF(ITEM(LC1:LS11).EQ.ICS_SCALE11(LC1:LS11)) THEN
            CR_SCALE(1,1) = FDATA
            ISCALE = ISCALE + 1
          ELSE IF(ITEM(LC1:LS12).EQ.ICS_SCALE12(LC1:LS12)) THEN
            CR_SCALE(1,2) = FDATA
            ISCALE = ISCALE + 1
          ELSE IF(ITEM(LC1:LS13).EQ.ICS_SCALE13(LC1:LS13)) THEN
            CR_SCALE(1,3) = FDATA
            ISCALE = ISCALE + 1
          ELSE IF(ITEM(LC1:LS21).EQ.ICS_SCALE21(LC1:LS21)) THEN
            CR_SCALE(2,1) = FDATA
            ISCALE = ISCALE + 1
          ELSE IF(ITEM(LC1:LS22).EQ.ICS_SCALE22(LC1:LS22)) THEN
            CR_SCALE(2,2) = FDATA
            ISCALE = ISCALE + 1
          ELSE IF(ITEM(LC1:LS23).EQ.ICS_SCALE23(LC1:LS23)) THEN
            CR_SCALE(2,3) = FDATA
            ISCALE = ISCALE + 1
          ELSE IF(ITEM(LC1:LS31).EQ.ICS_SCALE31(LC1:LS31)) THEN
            CR_SCALE(3,1) = FDATA
            ISCALE = ISCALE + 1
          ELSE IF(ITEM(LC1:LS32).EQ.ICS_SCALE32(LC1:LS32)) THEN
            CR_SCALE(3,2) = FDATA
            ISCALE = ISCALE + 1
          ELSE IF(ITEM(LC1:LS33).EQ.ICS_SCALE33(LC1:LS33)) THEN
            CR_SCALE(3,3) = FDATA
            ISCALE = ISCALE + 1
          ELSE IF(ITEM(LC1:LU1).EQ.ICS_U11(LC1:LU1)) THEN
            CR_U(1)       = FDATA
            ISCALE = ISCALE + 1
          ELSE IF(ITEM(LC1:LU2).EQ.ICS_U22(LC1:LU2)) THEN
            CR_U(2)       = FDATA
            ISCALE = ISCALE + 1
          ELSE IF(ITEM(LC1:LU3).EQ.ICS_U33(LC1:LU3)) THEN
            CR_U(3)       = FDATA
            ISCALE = ISCALE + 1
          ENDIF

        ENDIF
        CALL LENSTR_BL(ICS_SYMM_CAT,LC)
        IF(ITEM(1:LC).EQ.ICS_SYMM_CAT(1:LC)) THEN
C ---     _symmetry.

          CALL LENSTR_BL(ICS_SYMM_SPGR,LG)
          CALL LENSTR_BL(ICS_SYMM_NSPGR,LN)
          CALL LENSTR_BL(ICS_SYMM_SETT,LS) 
          CALL LENSTR_BL(ICS_SYMM_SYMOP,LO)

          LC1 = LC + 1
          IF(ITEM(LC1:LG).EQ.ICS_SYMM_SPGR(LC1:LG)) THEN
            IF(LEND.GT.24) LEND = 24
            CR_SPGR = DATA(1:LEND)
            IF(LEND.LT.24) THEN
              DO II=LEND+1,24
                CR_SPGR(II:II) = ' '
              ENDDO
            ENDIF
            ISG_FLAG = 1
          ELSE IF(ITEM(LC1:LN).EQ.ICS_SYMM_NSPGR(LC1:LN)) THEN
            CR_NSPGR = IDATA
            ISG_FLAG = 1
          ELSE IF(ITEM(LC1:LS).EQ.ICS_SYMM_SETT (LC1:LS)) THEN
            CR_SETT = IDATA
          ENDIF

          GO TO 410
        ENDIF

C       CALL LENSTR_BL(ICS_SYMM_SYMOP,L)
C       IF(ITEM(1:L).EQ.ICS_SYMM_SYMOP(1:L) THEN
C ---     _symmetry_equiv. --

C         IF(I.EQ.1) LINE=DATA(1:LEND)
C         IF(I.EQ.N_CIF) THEN
C           ISOP=ISOP+1
C
C           CR_NSYM=ISOP
C         ENDIF

C         GO TO 410
C       ENDIF

        IF(ITEM(1:12).EQ.'_nc_symmetry') THEN
C ---    _nc_symmetry

C          IF(ITEM(14:18).EQ.'alpha') THEN
C            ALPHA=FDATA
C          ELSE IF(ITEM(14:17).EQ.'beta') THEN
C            BETA =FDATA
C          ELSE IF(ITEM(14:18).EQ.'gamma') THEN
C            GAMMA=FDATA
C          ELSE IF(ITEM(14:21).EQ.'vector_1') THEN
C            TR(1)=FDATA
C          ELSE IF(ITEM(14:21).EQ.'vector_2') THEN
C            TR(2)=FDATA
C          ELSE IF(ITEM(14:21).EQ.'vector_3') THEN
C            TR(3)=FDATA
C          ENDIF
C          IF(I.EQ.N_CIF) THEN
C            INCS=INCS+1
C            ALPHA=ALPHA*PI180
C            BETA =BETA *PI180
C            GAMMA=GAMMA*PI180
C            CALL EULERM(ALPHA,BETA,GAMMA,AMR)
C            CALL SET_NCS(MDOC,NCMAX,INCS,AMR,TR,IERR)
C            IF(IERR.NE.0) RETURN
C            II=0
C            CALL GET_NCS(MDOC,NCMAX,II,AMR,TR,IERR)
C            IF(IERR.NE.0) RETURN
C          ENDIF

          GO TO 410
        ENDIF

        CALL LENSTR_BL(ICS_ASYM_CAT,L)
        IF(ITEM(1:L).EQ.ICS_ASYM_CAT(1:L).AND.CR_SOFT.EQ.'B') THEN
C ---     _struct_asym ---
 
          IF(I.EQ.1) THEN
            GROUP   = '.   '
            CHAIN   = '.   '
          ENDIF

          CALL LENSTR_BL(ICS_ASYM_ID  ,LD)
          CALL LENSTR_BL(ICS_ASYM_ENT ,LE)

          IF(ITEM(1:LD).EQ.ICS_ASYM_ID(1:LD)) THEN
            GROUP   = DATA
          ELSE IF(ITEM(1:LE).EQ.ICS_ASYM_ENT(1:LE)) THEN
            CHAIN   = DATA
          ENDIF

          IF(I.EQ.N_CIF) THEN

            IF(N_GRP_ASM.GE.MAXCHAIN) THEN
              CALL MSGERR(MDOC
     *        ,' WARNING: number of chains > limit.')
              CALL MSGERR(MDOC
     *        ,'        change parameter MAXCHAIN in atom_com.fh')
              GO TO 410
            ENDIF

            N_GRP_ASM                    = N_GRP_ASM + 1
            ASM_GROUP_ID     (N_GRP_ASM) = GROUP
            ASM_CHAIN_ID     (N_GRP_ASM) = CHAIN
            ASM_CHAIN_POINTER(N_GRP_ASM) = 0
            ASM_GROUP_POINTER(N_GRP_ASM) = 0


          ENDIF

          GO TO 410
        ENDIF

        CALL LENSTR_BL(ICS_ENT_CAT,L)
        IF(ITEM(1:L).EQ.ICS_ENT_CAT(1:L).AND.CR_SOFT.EQ.'B') THEN
C ---     _entity ---

          IF(I.EQ.1) THEN
            ITYPE   = 1
            CHAIN   = '.   '
          ENDIF

          CALL LENSTR_BL(ICS_ENT_ID  ,LD)
          CALL LENSTR_BL(ICS_ENT_TYP ,LT)

          IF(ITEM(1:LD).EQ.ICS_ENT_ID(1:LD)) THEN
            CHAIN  = DATA
          ELSE IF(ITEM(1:LT).EQ.ICS_ENT_TYP(1:LT)) THEN
            TYPE16 = DATA             
            ITYPE  = 1
            IF(DATA(1:8).EQ.'polypept') THEN
              ITYPE = 3
            ELSE IF(DATA(1:8).EQ.'polysacc') THEN
              ITYPE = 7
            ELSE IF(DATA(1:7).EQ.'DNA/RNA') THEN
              ITYPE = 5
            ELSE IF(DATA(1:7).EQ.'polymer') THEN
              ITYPE = 10
            ELSE IF(DATA(1:5).EQ.'water') THEN
              ITYPE = 9
            ELSE IF(DATA(1:5).EQ.'non-p') THEN
              ITYPE = 2
            ENDIF
          ENDIF

          IF(I.EQ.N_CIF) THEN

            IF(N_CHN_ENT.GE.MAXCHAIN) THEN
              CALL MSGERR(MDOC
     *        ,' WARNING: number of chains > limit.')
              CALL MSGERR(MDOC
     *        ,'        change parameter MAXCHAIN in atom_com.fh')
              GO TO 410
            ENDIF

            N_CHN_ENT = N_CHN_ENT + 1

            ENT_CHAIN_TYPE      (N_CHN_ENT) = TYPE16
            ENT_ICHAIN_TYPE     (N_CHN_ENT) = ITYPE 
            ENT_CHAIN_ID        (N_CHN_ENT) = CHAIN
            ENT_IGROUP_FIRST    (N_CHN_ENT) = 0  
            ENT_IRES_FIRST      (N_CHN_ENT) = 0  
            ENT_NRES_CHAIN      (N_CHN_ENT) = 0  
            ENT_IRES_START_TREE (N_CHN_ENT) = 0  
            ENT_IRES_END_TREE   (N_CHN_ENT) = 0 
            ENT_ITERM_S_TYPE    (N_CHN_ENT) = 1
            ENT_ITERM_F_TYPE    (N_CHN_ENT) = 1
            ENT_RES_START_TREE  (N_CHN_ENT) = '.'  
            ENT_RES_END_TREE    (N_CHN_ENT) = '.'
            ENT_TERM_S_TYPE     (N_CHN_ENT) = '.'
            ENT_TERM_F_TYPE     (N_CHN_ENT) = '.'

          ENDIF

          GO TO 410
        ENDIF

        CALL LENSTR_BL(ICS_ENTP_CAT,L)
        IF(ITEM(1:L).EQ.ICS_ENTP_CAT(1:L).AND.CR_SOFT.EQ.'B') THEN
C ---     _entity_poly_seq ---

          IF(I.EQ.1) THEN
            LINK    = '.'
            CHAIN   = '.   '
            MOD     = '.'
            RES1    = '.'
            CHAR8   = '.'
            LINK    = '.'
            LINK_ID = '.'
            IRES1   = 0
            IRES2   = 0
            RNUM1   = '.    '
            RNUM2   = '.    '
          ENDIF

          CALL LENSTR_BL(ICS_ENTP_ID  ,LD)
          CALL LENSTR_BL(ICS_ENTP_MON ,LN)
          CALL LENSTR_BL(ICS_ENTP_SEQ ,LS)
          CALL LENSTR_BL(ICS_ENTP_FSEQ,LF)
          CALL LENSTR_BL(ICS_ENTP_BSEQ,LB)
          CALL LENSTR_BL(ICS_ENTP_TYPE,LT)
          CALL LENSTR_BL(ICS_ENTP_MOD ,LM)

          IF(ITEM(1:LD).EQ.ICS_ENTP_ID(1:LD)) THEN
            CHAIN = DATA
          ELSE IF(ITEM(1:LT).EQ.ICS_ENTP_TYPE(1:LT)) THEN
            LINK  = DATA        
          ELSE IF(ITEM(1:LN).EQ.ICS_ENTP_MON (1:LN)) THEN
            RES1 = DATA            
          ELSE IF(ITEM(1:LS).EQ.ICS_ENTP_SEQ (1:LS)) THEN
            IF(LEND.GT.0) THEN
              CH5 = '     '
              J   = 5
              DO K = 5,1,-1
                IF(DATA(K:K).NE.' ') THEN
                  CH5(J:J) = DATA(K:K) 
                  J = J - 1
                ENDIF
              ENDDO

              CALL CHKSMB(CH5(5:5),TYPE)              
              IF(TYPE.EQ.'D') THEN
                DO K=2,5
                  CH5(K-1:K-1) = CH5(K:K)
                ENDDO 
                CH5(5:5) = ' '
              ENDIF

            ENDIF

            RNUM2 = CH5
            IRES2 = 0
           
          ELSE IF(ITEM(1:LF).EQ.ICS_ENTP_FSEQ(1:LF)) THEN
            CHAR8 = DATA            
          ELSE IF(ITEM(1:LB).EQ.ICS_ENTP_BSEQ(1:LB)) THEN
            IF(LEND.GT.0) THEN
              IF(DATA(1:3).EQ.'n/a') THEN
                RNUM1 = DATA
              ELSE
                CH5 = '     '
                J   = 5
                DO K = 5,1,-1
                  IF(DATA(K:K).NE.' ') THEN
                    CH5(J:J) = DATA(K:K) 
                    J = J -1
                  ENDIF
                ENDDO

                CALL CHKSMB(CH5(5:5),TYPE)              
                IF(TYPE.EQ.'D') THEN
                  DO K=2,5
                    CH5(K-1:K-1) = CH5(K:K)
                  ENDDO 
                  CH5(5:5) = ' '
                ENDIF

                RNUM1 = CH5

              ENDIF

            ENDIF

            IRES1 = 0
            
          ELSE IF(ITEM(1:LM).EQ.ICS_ENTP_MOD (1:LM)) THEN
            MOD = DATA
          ENDIF

          IF(I.EQ.N_CIF) THEN

            IF(N_CHN_ENT.LE.0) THEN
              GO TO 410
            ENDIF

            DO ICH=1,N_CHN_ENT
              IF(ENT_CHAIN_ID(ICH).EQ.CHAIN) THEN          

                IF(RNUM1(1:3).EQ.'n/a') THEN
                  ENT_RES_START_TREE(ICH) = RNUM2   
                  ENT_TERM_S_TYPE   (ICH) = MOD
                  CALL SET_TERM_S_TYPE(MOD,ITYPE)    
                  ENT_ITERM_S_TYPE   (ICH) = ITYPE
C                ENDIF
                ELSE IF(MOD.NE.'.') THEN                
                  ENT_RES_END_TREE  (ICH) = RNUM2 
                  ENT_TERM_F_TYPE   (ICH) = MOD
                  CALL SET_TERM_F_TYPE(MOD,ITYPE)    
                  ENT_ITERM_F_TYPE   (ICH) = ITYPE
                ENDIF

C                IF(CHAR8(1:3).EQ.'n/a') THEN
C                  ENT_RES_END_TREE  (ICH) = RNUM2 
C                  ENT_TERM_F_TYPE   (ICH) = MOD
C                  CALL SET_TERM_F_TYPE(MOD,ITYPE)    
C                  ENT_ITERM_F_TYPE   (ICH) = ITYPE
C                ENDIF
 
                ICONN = 1
                IF(LINK.NE.'.'.AND.LINK.NE.'?') THEN
                  CALL SET_ICONN(LINK,ICONN)
                  IF(ICONN.GE.3.AND.ICONN.LE.N_CONN_TYPE.AND.
     *               ICONN.NE.4) THEN
c     *               ICONN.NE.4.AND.ICONN.NE.36) THEN

                    IF(ENT_LN_N.GE.MAXLINK) THEN
                      GO TO 410
                    ENDIF

                    ENT_LN_N                   = ENT_LN_N + 1
                    ENT_LN_ID       (ENT_LN_N) = LINK
                    ENT_LN_ICHAIN   (ENT_LN_N) = ICH
                    ENT_LN_AUTH_NUM1(ENT_LN_N) = RNUM1
                    ENT_LN_1IRES    (ENT_LN_N) = IRES1
                    ENT_LN_AUTH_NUM2(ENT_LN_N) = RNUM2
                    ENT_LN_2IRES    (ENT_LN_N) = IRES2
                    ENT_LN_1RNAM    (ENT_LN_N) = '.'
                    ENT_LN_2RNAM    (ENT_LN_N) = '.'
                    ENT_LN_ATOM1    (ENT_LN_N) = '.'
                    ENT_LN_ATOM2    (ENT_LN_N) = '.'
                    ENT_LN_DIST     (ENT_LN_N) = 0.0

                    ENT_LN_USED(ENT_LN_N) = 'E'

                  ENDIF  
                ENDIF  

                IF(ENT_CHN_OLD.NE.CHAIN) THEN
                  ENT_IRES_FIRST(ICH) = ENT_NRESIDUE + 1 
                  IRES_SER            = 0
                ENDIF

                ENT_CHN_OLD = CHAIN

                ENT_NRESIDUE          = ENT_NRESIDUE + 1
                IR                    = ENT_NRESIDUE
                IRES_SER              = IRES_SER + 1 
                ENT_NRES_CHAIN   (ICH)= ENT_NRES_CHAIN(ICH) + 1  
                ENT_RES_AUTH_NUM (IR) = RNUM2
                ENT_IRES_SERIAL  (IR) = IRES_SER
                ENT_IRES_BACK    (IR) = 0
                ENT_IRES_FORW    (IR) = 0
                ENT_ICHAIN       (IR) = ICH
                ENT_IRES_TYPE    (IR) = 0
                ENT_ICONN_TYPE   (IR) = ICONN
                ENT_RES_NAME     (IR) = RES1
                ENT_MOD_ID       (IR) = MOD  
                ENT_RES_AUTH_BNUM(IR) = RNUM1
                ENT_RES_AUTH_FNUM(IR) = '.'
              
C                IF(RNUM1.EQ.ENT_RES_START_TREE(ICH)) 
C     *                      ENT_IRES_START_TREE(ICH) = IR
C                IF(RNUM1.EQ.ENT_RES_END_TREE(ICH)) 
C     *                      ENT_IRES_END_TREE(ICH) = IR

                GO TO 520

              ENDIF

            ENDDO
             
            LINE = ' WARNING: entity_poly_seq: ENTITY:'//CHAIN//
     *                 ' not found in entity_list'
            CALL MSGDOC(MDOC,LINE)

 520        CONTINUE

          ENDIF

          GO TO 410
        ENDIF

        CALL LENSTR_BL(ICS_LINK_CAT,LC)
        IF(ITEM(1:LC).EQ.ICS_LINK_CAT(1:LC)) THEN
C ---     _entity_link ---

          IF(I.EQ.1) THEN
            LINK    = '.'
            ICHAIN  = 0
            IRES1   = 0
            IRES2   = 0
            RES1    = '.'
            RES2    = '.'
            IRES2   = 0
            RNUM1   = '.    '
            RNUM2   = '.    '
            ATOM1   = '.    '
            ATOM2   = '.    '
            DIST    = 0.0
          ENDIF

          CALL LENSTR_BL(ICS_LINK_ID  ,LI )
          CALL LENSTR_BL(ICS_LINK_NUM1,LN1)
          CALL LENSTR_BL(ICS_LINK_MON1,LM1)
          CALL LENSTR_BL(ICS_LINK_NUM2,LN2)
          CALL LENSTR_BL(ICS_LINK_MON2,LM2)
          CALL LENSTR_BL(ICS_LINK_ENT ,LE )
          CALL LENSTR_BL(ICS_LINK_ATM1,LA1)
          CALL LENSTR_BL(ICS_LINK_ATM2,LA2)
          CALL LENSTR_BL(ICS_LINK_DIST,LDS)

          IF(ITEM(1:LI).EQ.ICS_LINK_ID(1:LI)) THEN
            LINK  = DATA
          ELSE IF(ITEM(1:LN1).EQ.ICS_LINK_NUM1(1:LN1)) THEN

            IF(LEND.GT.0) THEN
              CH5 = '     '
              J   = 5
              DO K = 5,1,-1
                IF(DATA(K:K).NE.' ') THEN
                  CH5(J:J) = DATA(K:K) 
                  J = J -1
                ENDIF
              ENDDO

              CALL CHKSMB(CH5(5:5),TYPE)              
              IF(TYPE.EQ.'D') THEN
                DO K=2,5
                  CH5(K-1:K-1) = CH5(K:K)
                ENDDO 
                CH5(5:5) = ' '
              ENDIF

            ENDIF

            RNUM1 = CH5

            IRES1 = 0

          ELSE IF(ITEM(1:LM1).EQ.ICS_LINK_MON1(1:LM1)) THEN
            RES1  = DATA
          ELSE IF(ITEM(1:LE).EQ.ICS_LINK_ENT(1:LE)) THEN
            ICH = 0
            CHAIN = DATA
            IF(N_CHN_ENT.GT.0) THEN
              DO IC=1,N_CHN_ENT
                IF(ENT_CHAIN_ID(IC).EQ.CHAIN) THEN          
                  ICH = IC
                  GO TO 510 
               ENDIF
              ENDDO
            ENDIF
 510        CONTINUE
          ELSE IF(ITEM(1:LN2).EQ.ICS_LINK_NUM2(1:LN2)) THEN

            IF(LEND.GT.0) THEN
              CH5 = '     '
              J   = 5
              DO K = 5,1,-1
                IF(DATA(K:K).NE.' ') THEN
                  CH5(J:J) = DATA(K:K) 
                  J = J - 1
                ENDIF
              ENDDO

              CALL CHKSMB(CH5(5:5),TYPE)              
              IF(TYPE.EQ.'D') THEN
                DO K=2,5
                  CH5(K-1:K-1) = CH5(K:K)
                ENDDO 
                CH5(5:5) = ' '
              ENDIF

            ENDIF

            RNUM2 = CH5

            IRES2 = 0

          ELSE IF(ITEM(1:LM2).EQ.ICS_LINK_MON2(1:LM2)) THEN
            RES2  = DATA
          ELSE IF(ITEM(1:LA1).EQ.ICS_LINK_ATM1(1:LA1)) THEN
            ATOM1  = DATA
          ELSE IF(ITEM(1:LA2).EQ.ICS_LINK_ATM2(1:LA2)) THEN
            ATOM2  = DATA
          ELSE IF(ITEM(1:LDS).EQ.ICS_LINK_DIST(1:LDS)) THEN
            DIST  = FDATA
          ENDIF

          IF(I.EQ.N_CIF) THEN

            IF(ENT_LN_N.GE.MAXLINK) THEN
              CALL MSGERR(MDOC
     *        ,' WARNING: number of links > limit.')
              CALL MSGERR(MDOC
     *        ,'        change parameter MAXLINK in atom_com.fh')
              GO TO 410
            ENDIF

            ENT_LN_N                   = ENT_LN_N + 1
            ENT_LN_ID       (ENT_LN_N) = LINK
            ENT_LN_ICHAIN   (ENT_LN_N) = ICH
            ENT_LN_AUTH_NUM1(ENT_LN_N) = RNUM1
            ENT_LN_1IRES    (ENT_LN_N) = IRES1
            ENT_LN_AUTH_NUM2(ENT_LN_N) = RNUM2
            ENT_LN_2IRES    (ENT_LN_N) = IRES2
            ENT_LN_1RNAM    (ENT_LN_N) = RES1
            ENT_LN_2RNAM    (ENT_LN_N) = RES2

            ENT_LN_ATOM1    (ENT_LN_N) = ATOM1
            ENT_LN_ATOM2    (ENT_LN_N) = ATOM2

            ENT_LN_USED     (ENT_LN_N) = 'L'
            ENT_LN_DIST     (ENT_LN_N) = DIST

          ENDIF

          GO TO 410

        ENDIF

        CALL LENSTR_BL(ICS_CONN_CAT,LC)
        IF(ITEM(1:LC).EQ.ICS_CONN_CAT(1:LC)) THEN
C ---    _struct_conn.   ---

C _struct_conn.id                       
C _struct_conn.conn_type_id                       
C _struct_conn.ptnr1_label_atom_id 
C _struct_conn.ptnr1_label_alt_id 
C _struct_conn.ptnr1_auth_seq_id
C _struct_conn.ptnr1_label_comp_id
C _struct_conn.ptnr1_label_asym_id
C _struct_conn.ptnr1_symmetry
C _struct_conn.ptnr2_label_atom_id 
C _struct_conn.ptnr2_label_alt_id 
C _struct_conn.ptnr2_auth_seq_id
C _struct_conn.ptnr2_label_comp_id
C _struct_conn.ptnr2_label_asym_id
C _struct_conn.ptnr2_symmetry
C _struct_conn.dist

          IF(I.EQ.1) THEN
            LINK    = '.'
            LINK_ID = '.'
            ICH1    = 0
            RES1    = '.'
            IRES1   = 0
            ICH2    = 0
            RES2    = '.'
            IRES2   = 0
            RES_NEW = '.'
            RNUM1   = '.    '
            RNUM2   = '.    '
            ATOM1   = '.    '
            ATOM2   = '.    '
            SYMM1   = '.'
            SYMM2   = '.'
            CHN1    = '.   '
            CHN2    = '.   '
            ALT1    = '.'
            ALT2    = '.'
            DIST    = 0.0
          ENDIF

          CALL LENSTR_BL(ICS_CONN_ID  ,LI)
          CALL LENSTR_BL(ICS_CONN_TYPE,LT)
          CALL LENSTR_BL(ICS_CONN_ATM1,LA1)
          CALL LENSTR_BL(ICS_CONN_ALT1,LL1)
          CALL LENSTR_BL(ICS_CONN_NUM1,LN1)
          CALL LENSTR_BL(ICS_CONN_MON1,LM1)
          CALL LENSTR_BL(ICS_CONN_ENT1,LE1)
          CALL LENSTR_BL(ICS_CONN_SYM1,LS1)
          CALL LENSTR_BL(ICS_CONN_ATM2,LA2)
          CALL LENSTR_BL(ICS_CONN_ALT2,LL2)
          CALL LENSTR_BL(ICS_CONN_NUM2,LN2)
          CALL LENSTR_BL(ICS_CONN_MON2,LM2)
          CALL LENSTR_BL(ICS_CONN_ENT2,LE2)
          CALL LENSTR_BL(ICS_CONN_SYM2,LS2)
          CALL LENSTR_BL(ICS_CONN_DIST,LDS)

          LC1 = LC + 1
          IF(ITEM(LC1:LI).EQ.ICS_CONN_ID(LC1:LI)) THEN
            LINK_ID = DATA
          ELSE IF(ITEM(LC1:LT).EQ.ICS_CONN_TYPE(LC1:LT)) THEN
            LINK    = DATA
          ELSE IF(ITEM(LC1:LN1).EQ.ICS_CONN_NUM1(LC1:LN1)) THEN

            IF(LEND.GT.0) THEN
              CH5 = '     '
              J   = 5
              DO K = 5,1,-1
                IF(DATA(K:K).NE.' ') THEN
                  CH5(J:J) = DATA(K:K) 
                  J = J -1
                ENDIF
              ENDDO

              CALL CHKSMB(CH5(5:5),TYPE)              
              IF(TYPE.EQ.'D') THEN
                DO K=2,5
                  CH5(K-1:K-1) = CH5(K:K)
                ENDDO 
                CH5(5:5) = ' '
              ENDIF

            ENDIF

            RNUM1 = CH5

            IRES1 = 0
C           IRES1 = IDATA

          ELSE IF(ITEM(LC1:LM1).EQ.ICS_CONN_MON1(LC1:LM1)) THEN
            RES1  = DATA
          ELSE IF(ITEM(LC1:LE1).EQ.ICS_CONN_ENT1(LC1:LE1)) THEN            
C            ICH1  = IDATA
            CHN1  = DATA
          ELSE IF(ITEM(LC1:LS1).EQ.ICS_CONN_SYM1(LC1:LS1)) THEN
            SYMM1  = DATA
          ELSE IF(ITEM(LC1:LA1).EQ.ICS_CONN_ATM1(LC1:LA1)) THEN
            ATOM1  = DATA
          ELSE IF(ITEM(LC1:LL1).EQ.ICS_CONN_ALT1(LC1:LL1)) THEN
            ALT1  = DATA
          ELSE IF(ITEM(LC1:LN2).EQ.ICS_CONN_NUM2(LC1:LN2)) THEN

            IF(LEND.GT.0) THEN
              CH5 = '     '
              J   = 5
              DO K = 5,1,-1
                IF(DATA(K:K).NE.' ') THEN
                  CH5(J:J) = DATA(K:K) 
                  J = J - 1
                ENDIF
              ENDDO

              CALL CHKSMB(CH5(5:5),TYPE)              
              IF(TYPE.EQ.'D') THEN
                DO K=2,5
                  CH5(K-1:K-1) = CH5(K:K)
                ENDDO 
                CH5(5:5) = ' '
              ENDIF

            ENDIF

            RNUM2 = CH5

            IRES2 = 0
C           IRES2 = IDATA

          ELSE IF(ITEM(LC1:LM2).EQ.ICS_CONN_MON2(LC1:LM2)) THEN
            RES2  = DATA
          ELSE IF(ITEM(LC1:LE2).EQ.ICS_CONN_ENT2(LC1:LE2)) THEN
c            ICH2  = IDATA
            CHN2  = DATA
          ELSE IF(ITEM(LC1:LA2).EQ.ICS_CONN_ATM2(LC1:LA2)) THEN
            ATOM2 = DATA
          ELSE IF(ITEM(LC1:LL2).EQ.ICS_CONN_ALT2(LC1:LL2)) THEN
            ALT2  = DATA
          ELSE IF(ITEM(LC1:LS2).EQ.ICS_CONN_SYM2(LC1:LS2)) THEN
            SYMM2 = DATA
          ELSE IF(ITEM(LC1:LDS).EQ.ICS_CONN_DIST(LC1:LDS)) THEN
            DIST  = FDATA
         ENDIF

          IF(I.EQ.N_CIF) THEN

            IF(LN_N.GE.MAXLINK) THEN
              CALL MSGERR(MDOC
     *        ,' WARNING: number of links > limit.')
              CALL MSGERR(MDOC
     *        ,'        change parameter MAXLINK in atom_com.fh')
              GO TO 410
            ENDIF

            ILN             = ILN + 1
            LN_N            = ILN
            LN_ID    (LN_N) = LINK
            LN_1ICHN (LN_N) = ICH1
            LN_1CHN  (LN_N) = CHN1
            LN_1RNAM (LN_N) = RES1
            LN_1IRES (LN_N) = IRES1
            LN_SEQ1  (LN_N) = RNUM1
            LN_2ICHN (LN_N) = ICH2
            LN_2CHN  (LN_N) = CHN2
            LN_2RNAM (LN_N) = RES2
            LN_2IRES (LN_N) = IRES2
            LN_SEQ2  (LN_N) = RNUM2
            LN_ATOM1 (LN_N) = ATOM1
            LN_ATOM2 (LN_N) = ATOM2
            LN_ALT1  (LN_N) = ALT1
            LN_ALT2  (LN_N) = ALT2
            LN_SYMM1 (LN_N) = SYMM1
            LN_SYMM2 (LN_N) = SYMM2
C
C           LN_ENT    E - form ent_poly_seq (not trans 2 , ptrans 36 , p 4)
C                     L - form ent_link
C                     C - from conn
C
            LN_ENT   (LN_N) = 'C'
            LN_USED  (LN_N) = 'U'
            IF(LN_ALT1(LN_N).NE.'.'.OR.LN_ALT2(LN_N).NE.'.')
     *        LN_USED(ILN) = 'S'
c           LN_USED  (LN_N) = '.'
C ??????
            LN_DIST  (LN_N) = DIST

          ENDIF

          GO TO 410

        ENDIF

        CALL LENSTR_BL(ICS_MOD_CAT,LC)
        IF(ITEM(1:LC).EQ.ICS_MOD_CAT(1:LC)) THEN

C ---     _entity_mod ---
C _ccp4_struct_asym_mod      old:  _entity_mod 
C _entity_mod.label_asym_id        #    <-- NEW

          IF(I.EQ.1) THEN
            MOD     = '.'
            ICH1    = 0
            RES1    = '.'
            IRES1   = 0
            RNUM1   = '.    '
            RES_NEW = '.'
            CHN1    = '.   '
          ENDIF

          CALL LENSTR_BL(ICS_MOD_ID ,LI)
          CALL LENSTR_BL(ICS_MOD_NUM,LN)
          CALL LENSTR_BL(ICS_MOD_MON,LM)
          CALL LENSTR_BL(ICS_MOD_ENT,LE)
          CALL LENSTR_BL(ICS_MOD_NEW,LW)
          CALL LENSTR_BL(ICS_MOD_ASM,LA)

          LC1 = LC + 1
          IF(ITEM(LC1:LI).EQ.ICS_MOD_ID(LC1:LI)) THEN
            MOD     = DATA
          ELSE IF(ITEM(LC1:LN).EQ.ICS_MOD_NUM(LC1:LN)) THEN

            IF(LEND.GT.0) THEN
              CH5 = '     '
              J   = 5
              DO K = 5,1,-1
                IF(DATA(K:K).NE.' ') THEN
                  CH5(J:J) = DATA(K:K) 
                  J = J -1
                ENDIF
              ENDDO

              CALL CHKSMB(CH5(5:5),TYPE)              
              IF(TYPE.EQ.'D') THEN
                DO K=2,5
                  CH5(K-1:K-1) = CH5(K:K)
                ENDDO 
                CH5(5:5) = ' '
              ENDIF

            ENDIF

            RNUM1 = CH5

            IRES1 = 0
C           IRES1   = IDATA

          ELSE IF(ITEM(LC1:LM).EQ.ICS_MOD_MON(LC1:LM)) THEN
            RES1    = DATA
          ELSE IF(ITEM(LC1:LW).EQ.ICS_MOD_NEW(LC1:LW)) THEN
            RES_NEW = DATA
          ELSE IF(ITEM(LC1:LE).EQ.ICS_MOD_ENT(LC1:LE)) THEN
c            ICH1    = IDATA
            CHN1    = DATA
          ELSE IF(ITEM(LC1:LA).EQ.ICS_MOD_ASM(LC1:LA)) THEN
C            ICH1    = IDATA
            CHN1    = DATA
          ENDIF
          IF(I.EQ.N_CIF) THEN

            IF(MOD_N.GE.MAXMODIF) THEN
              CALL MSGERR(MDOC
     *        ,' WARNING: number of modifications > limit.')
              CALL MSGERR(MDOC
     *        ,'        change parameter MAXMODIF in atom_com.fh')
              GO TO 410
            ENDIF

            IMD                 = IMD + 1
            MOD_N               = IMD
            MOD_ID   (MOD_N)    = MOD
            MOD_ICHN (MOD_N)    = ICH1
            MOD_CHN  (MOD_N)    = CHN1
            MOD_RNAM (MOD_N)    = RES1
            MOD_RNAM_NEW(MOD_N) = RES_NEW
            MOD_IRES (MOD_N)    = IRES1
            MOD_SEQ  (MOD_N)    = RNUM1
            MOD_USED (MOD_N)    = 'U'

          ENDIF

          GO TO 410
        ENDIF

        CALL LENSTR_BL(ITA_ATOM_CAT,L)
        IF((ITEM(1:12).EQ.'_derivative_').OR.
     *     (ITEM(1:12).EQ.'_derivative.')) THEN
C ---     _derivative. ---
 
          IF((ITEM(1:18).EQ.'_derivative_scale1').OR.
     *       (ITEM(1:18).EQ.'_derivative.scale1')) THEN
C ---       _derivative.scale1 ---
  
c            CR_FLAG_HA = 'Y'
            CR_CF1     = FDATA

          ELSE IF((ITEM(1:18).EQ.'_derivative_scale2').OR.
     *            (ITEM(1:18).EQ.'_derivative.scale2')) THEN
C ---       _derivative.scale1 ---
  
c            CR_FLAG_HA = 'Y'
            CR_CF2     = FDATA

          ELSE IF((ITEM(1:20).EQ.'_derivative_Toverall').OR.
     *            (ITEM(1:20).EQ.'_derivative.Toverall')) THEN
C ---       _derivative.Toverall ---
  
c            CR_FLAG_HA = 'Y'
            CR_TOV     = FDATA

          ENDIF

          GO TO 410
        ENDIF

        CALL LENSTR_BL(ICS_ATYPE_CAT,LC)
        IF(ICSD.LE.0) THEN
        IF((ITEM(1:11).EQ.'_atom_type_').OR.
     *     (ITEM(1:LC).EQ.ICS_ATYPE_CAT(1:LC))) THEN
C ---     _atom_type. ---

          IF(CS_NSFATM.GE.MAXNSF) THEN
              CALL MSGERR(MDOC
     *        ,' WARNING: number of atom types > limit.')
              CALL MSGERR(MDOC
     *        ,'        change parameter MAXNSF in atom_com.fh')
            GO TO 410
          ENDIF

          IF(I.EQ.1) THEN
            CS_RADIUS (CS_NSFATM+1) = 0.0
            CS_NELEC  (CS_NSFATM+1) = 0
            CS_ATYPE  (CS_NSFATM+1) = '.   '
            CS_ELEMENT(CS_NSFATM+1) = '.   '
            CS_FI     (CS_NSFATM+1) = 0.0
            CS_FII    (CS_NSFATM+1) = 0.0
          ENDIF

          CALL LENSTR_BL(ICS_ASYMB,LAS)
          CALL LENSTR_BL(ICS_A1,LA1)
          CALL LENSTR_BL(ICS_A2,LA2)
          CALL LENSTR_BL(ICS_A3,LA3)
          CALL LENSTR_BL(ICS_A4,LA4)
          CALL LENSTR_BL(ICS_B1,LB1)
          CALL LENSTR_BL(ICS_B2,LB2)
          CALL LENSTR_BL(ICS_B3,LB3)
          CALL LENSTR_BL(ICS_B4,LB4)
          CALL LENSTR_BL(ICS_C ,LC0)
          CALL LENSTR_BL(ICS_FI,LFI)
          CALL LENSTR_BL(ICS_FII,LFII)
          CALL LENSTR_BL(ICS_RADIUS,LR)
          CALL LENSTR_BL(ICS_NELEC,LN)


          LC1 = LC + 1
          IF(ITEM(LC1:LAS).EQ.ICS_ASYMB(LC1:LAS)) THEN

            CS_ELEMENT(CS_NSFATM+1) = DATA(1:4)

            CALL CHKSMB(DATA(2:2),TYPE)

            IF(TYPE.EQ.'D'.OR.TYPE.EQ.'S') DATA(2:2) = ' '
            DATA(3:3) = ' '
            DATA(4:4) = ' '

            CS_ATYPE  (CS_NSFATM+1) = DATA(1:4)

          ELSE IF(ITEM(LC1:LA1).EQ.ICS_A1(LC1:LA1)) THEN
            CS_A(1,CS_NSFATM+1) = FDATA
          ELSE IF(ITEM(LC1:LA2).EQ.ICS_A2(LC1:LA2)) THEN
            CS_A(2,CS_NSFATM+1) = FDATA
          ELSE IF(ITEM(LC1:LA3).EQ.ICS_A3(LC1:LA3)) THEN
            CS_A(3,CS_NSFATM+1) = FDATA
          ELSE IF(ITEM(LC1:LA4).EQ.ICS_A4(LC1:LA4)) THEN
            CS_A(4,CS_NSFATM+1) = FDATA
          ELSE IF(ITEM(LC1:LB1).EQ.ICS_B1(LC1:LB1)) THEN
            CS_B(1,CS_NSFATM+1) = FDATA
          ELSE IF(ITEM(LC1:LB2).EQ.ICS_B2(LC1:LB2)) THEN
            CS_B(2,CS_NSFATM+1) = FDATA
          ELSE IF(ITEM(LC1:LB3).EQ.ICS_B3(LC1:LB3)) THEN
            CS_B(3,CS_NSFATM+1) = FDATA
          ELSE IF(ITEM(LC1:LB4).EQ.ICS_B4(LC1:LB4)) THEN
            CS_B(4,CS_NSFATM+1) = FDATA
          ELSE IF(ITEM(LC1:LC0).EQ.ICS_C(LC1:LC0)) THEN
            CS_C(CS_NSFATM+1)   = FDATA
          ELSE IF(ITEM(LC1:LFI) .EQ.ICS_FI(LC1:LFI)) THEN
            CS_FI(CS_NSFATM+1)  = FDATA
          ELSE IF(ITEM(LC1:LFII).EQ.ICS_FII(LC1:LFII)) THEN
            CS_FII(CS_NSFATM+1) = FDATA
          ELSE IF(ITEM(LC1:LR).EQ.ICS_RADIUS(LC1:LR)) THEN
            CS_RADIUS(CS_NSFATM+1) = FDATA
          ELSE IF(ITEM(LC1:LN).EQ.ICS_NELEC(LC1:LN)) THEN
            CS_NELEC(CS_NSFATM+1)  = IDATA
          ENDIF
          IF(I.EQ.N_CIF) THEN
            CS_NSFATM   = CS_NSFATM + 1
          ENDIF

          GO TO 410
        ENDIF
        ENDIF

        CALL LENSTR_BL(ITA_ATOM_CAT,L)
        IF((ITEM(1:11).EQ.'_atom_site_'     ).OR.
     *     (ITEM(1:16).EQ.'_ccdc_atom_site_').OR.
     *     (ITEM(1:L ).EQ.ITA_ATOM_CAT(1:L) )    ) THEN
C ---     _atom_site ---

          GO TO 400
        ENDIF

 410    CONTINUE
      ENDDO
      GO TO 300
C ----------------------------------------------------
 400  CONTINUE

      IF(ICSD.GT.0) THEN
        CR_SPGR  = 'P 1'
        CR_NSPGR = 1
        CR_SETT  = 1
      ENDIF

C ---
      IF(CELL_INPUT(1).GT.1.0) THEN
C       new cell 
        DO I=1,6
          CR_CELL(I) = CELL_INPUT(I)
        ENDDO
        CR_CELL(4) = CR_CELL(4)*PI180
        CR_CELL(5) = CR_CELL(5)*PI180
        CR_CELL(6) = CR_CELL(6)*PI180
        ICELL_FLAG = 1
        ISCALE     = 0
      ELSE IF(ICELL_FLAG.LT.6) THEN
C       cell missing
        CALL MSGDOC(MDOC,
     *' WARNING: CELL parameters are missing, default : 100,100,100,90,9
     *0,90')
        ICELL_FLAG = 0
        ISCALE     = 0
        DO I=1,3
          CR_CELL(I) = 100.0
        ENDDO
        CR_CELL(4) = PI/2.0
        CR_CELL(5) = PI/2.0
        CR_CELL(6) = PI/2.0
        ICELL_FLAG = 1
      ELSE
        ICELL_FLAG = 1
      ENDIF
C     sp group missing  
      IF(ISG_FLAG.EQ.0.AND.NOSPGR_INPUT.EQ.0) THEN
        CALL MSGDOC(MDOC,
     *' WARNING: space group number and name are missing, default : P1')
        CR_SPGR  = 'P 1'
        CR_NSPGR = 1
        CR_SETT  = 1
      ENDIF
C ---
      CALL COPY_CR_CS

C ---
      CALL NB_FRORTH(CS_CELL(1),CS_CELL(2),CS_CELL(3)
     *              ,CS_CELL(4),CS_CELL(5),CS_CELL(6)
     *              ,CS_FRAC_TO_ORT,CS_ORT_TO_FRAC,IERR)

      IF(ISCALE.LT.12) THEN
        CALL NB_MCOPY(CS_ORT_TO_FRAC,CR_SCALE)      
        CALL NB_MCOPY(CS_ORT_TO_FRAC,CS_SCALE)      
        CR_U(1) = 0.0
        CR_U(2) = 0.0
        CR_U(3) = 0.0
        CS_U(1) = 0.0
        CS_U(2) = 0.0
        CS_U(3) = 0.0
      ENDIF

C ---
      NOSPGR = CS_NSPGR
      ISETT  = CS_SETT  
      SGNAME = CS_SPGR 
      IF(NOSPGR_INPUT.NE.0) THEN
        NOSPGR   = NOSPGR_INPUT
        ISETT    = 1
        SGNAME   = ' '
        ISG_FLAG = 1
      ENDIF

C      CALL GET_SYMM_NB_NEW(MDOC,CS_NSPGR,CS_SETT,CS_SPGR,CS_NSYM
C    *                  ,CS_M_CS,CS_V_CS,CS_SYMOP,MAXNSO,IERR)

      CALL GET_SYMM_NB_NEW(MDOC,NOSPGR,ISETT,SGNAME
     *                  ,CS_NSYM,CS_M_CS,CS_V_CS,MAXNSO,IERR)

CC     CR_NSYM = CS_NSYM

      CR_NSYM  = CS_NSYM
      CR_NSPGR = NOSPGR
      CS_NSPGR = CR_NSPGR
      CR_SETT  = ISETT  
      CS_SETT  = CR_SETT
      CALL LENSTR_BL(SGNAME,LENR)
      CR_SPGR  = SGNAME(1:LENR)
      CS_SPGR  = SGNAME(1:LENR)
C ------------------------------------------
C /////
      IF(ENT_LN_N.GT.1) THEN
        DO IL=2,ENT_LN_N
          LINK  = ENT_LN_ID       (IL) 
          ICH1  = ENT_LN_ICHAIN   (IL)
          CHN1  = ENT_CHAIN_ID    (ICH1)
          RNUM1 = ENT_LN_AUTH_NUM1(IL) 
          RNUM2 = ENT_LN_AUTH_NUM2(IL) 
          CALL SET_ICONN(LINK,ICONN)
          IF(ENT_LN_USED(IL).EQ.'L'.AND.
     *       ICONN.GT.2.AND.ICONN.LE.N_CONN_TYPE) THEN
            DO ILL=1,IL-1
              ICH    = ENT_LN_ICHAIN   (ILL) 
              RNUM1A = ENT_LN_AUTH_NUM1(ILL) 
              RNUM2A = ENT_LN_AUTH_NUM2(ILL) 
              IF(ICH1.EQ.ICH.AND.ENT_LN_USED(ILL).EQ.'E'.AND.
     *           ((RNUM1.EQ.RNUM1A.AND.RNUM2.EQ.RNUM2A).OR. 
     *            (RNUM1.EQ.RNUM2A.AND.RNUM2.EQ.RNUM1A))   ) THEN 
                ENT_LN_USED(ILL) = 'e'
                ENT_LN_ID(IL)    = '?'
                GO TO 700
              ENDIF
            ENDDO
          ENDIF
 700      CONTINUE      
        ENDDO
      ENDIF
C ////
C ------------------------------------------
      IF(ENT_LN_N.GT.0) THEN

        LINK    = '.'
        LINK_ID = '.'
        ICH1    = 0
        RES1    = '.'
        IRES1   = 0
        ICH2    = 0
        RES2    = '.'
        IRES2   = 0
        RES_NEW = '.'
        RNUM1   = '.    '
        RNUM2   = '.    '
        ATOM1   = '.    '
        ATOM2   = '.    '
        SYMM1   = '.'
        SYMM2   = '.'
        CHN1    = '.   '
        CHN2    = '.   '
        ALT1    = '.'
        ALT2    = '.'
        DIST    = 0.0

        DO IL=1,ENT_LN_N

          IF(LN_N.GE.MAXLINK) THEN
              CALL MSGERR(MDOC
     *        ,' WARNING: number of links > limit.')
              CALL MSGERR(MDOC
     *        ,'        change parameter MAXLINK in atom_com.fh')
            GO TO 500
          ENDIF

          LINK  = ENT_LN_ID       (IL) 
          IF(LINK(1:1).NE.'?') THEN
          ICH1  = ENT_LN_ICHAIN   (IL)
          ICH2  = ICH1
          CHN1  = ENT_CHAIN_ID    (ICH1)
          CHN2  = CHN1
          RNUM1 = ENT_LN_AUTH_NUM1(IL) 
          IRES1 = ENT_LN_1IRES    (IL) 
          RNUM2 = ENT_LN_AUTH_NUM2(IL) 
          IRES2 = ENT_LN_2IRES    (IL) 
          RES1  = ENT_LN_1RNAM    (IL) 
          RES2  = ENT_LN_2RNAM    (IL) 
          ATOM1 = ENT_LN_ATOM1    (IL) 
          ATOM2 = ENT_LN_ATOM2    (IL) 
          DIST  = ENT_LN_DIST     (IL) 

          LN_N            = LN_N + 1
          LN_ID    (LN_N) = LINK
          LN_1ICHN (LN_N) = ICH1
          LN_1CHN  (LN_N) = CHN1
          LN_1RNAM (LN_N) = RES1
          LN_1IRES (LN_N) = IRES1
          LN_SEQ1  (LN_N) = RNUM1
          LN_2ICHN (LN_N) = ICH2
          LN_2CHN  (LN_N) = CHN2
          LN_2RNAM (LN_N) = RES2
          LN_2IRES (LN_N) = IRES2
          LN_SEQ2  (LN_N) = RNUM2
          LN_ATOM1 (LN_N) = ATOM1
          LN_ATOM2 (LN_N) = ATOM2
          LN_ALT1  (LN_N) = ALT1
          LN_ALT2  (LN_N) = ALT2
          LN_SYMM1 (LN_N) = SYMM1
          LN_SYMM2 (LN_N) = SYMM2
C
C           LN_ENT    E - form ent_poly_seq (not trans 2 , ptrans 36 , p 4)
C                     L - form ent_link
C                     C - from conn
C
          LN_USED  (LN_N) = '.'
C???
          IF(ENT_LN_USED(IL).EQ.'L') LN_USED(LN_N) = 'U'
c         IF(ENT_LN_USED(IL).EQ.'E') LN_USED(LN_N) = 'U'
          IF(ENT_LN_USED(IL).EQ.'e') LN_USED(LN_N) = 'u'
          LN_ENT   (LN_N) = ENT_LN_USED(IL)

          LN_DIST  (LN_N) = DIST
          ENDIF
        ENDDO
      ENDIF

 500  CONTINUE
      
c       write(*,*) N_CHN_ENT,N_GRP_ASM,ENT_NRESIDUE,ENT_LN_N,ln_n
c
c           IF(ENT_LN_N.GT.0) THEN
c             DO LN=1,ENT_LN_N
c                write(*,*) 'ENT_link:', 
c     *      ENT_LN_ID(LN),ENT_LN_ICHAIN(LN)
c     *   ,ENT_LN_AUTH_NUM1(LN),ENT_LN_AUTH_NUM2(LN),ENT_LN_USED(LN)
c             enddo
c           endif
c
c           IF(LN_N.GT.0) THEN
c             DO LN=1,LN_N
c                write(*,*) 'link:', 
c     *      LN_ID(LN),LN_1CHN(LN),LN_2CHN(LN),LN_ENT(LN)
c             enddo
c           endif

      IF(N_GRP_ASM.GT.0.AND.N_CHN_ENT.GT.0) THEN     

        DO KE = 1,N_CHN_ENT

          IFIRST = 0

          DO KA = 1,N_GRP_ASM

            GROUP  = ASM_GROUP_ID(KA)    
            CHAIN  = ASM_CHAIN_ID(KA)   

            IF(CHAIN.EQ.ENT_CHAIN_ID(KE)) THEN
              
              ASM_CHAIN_POINTER(KA) = KE
              IF(IFIRST.EQ.0) ENT_IGROUP_FIRST(KE) = KA
 
              IFIRST                = IFIRST + 1
             
              IF(LN_N.GT.0) THEN
                LNN = LN_N
                DO LN=1,LNN

                  IF(LN_1CHN(LN).EQ.CHAIN.AND.LN_ID(LN)(1:1).NE.'?'
     *               .AND.(LN_ENT(LN).EQ.'E'.OR.LN_ENT(LN).EQ.'e'.OR.
     *               LN_ENT(LN).EQ.'L')) THEN

                    IF(IFIRST.EQ.1) THEN
                      LN_1CHN  (LN) = GROUP
                      LN_2CHN  (LN) = GROUP
                    ELSE

                      IF(LN_N.GE.MAXLINK) THEN
              CALL MSGERR(MDOC
     *        ,' WARNING: number of links > limit.')
              CALL MSGERR(MDOC
     *        ,'        change parameter MAXLINK in atom_com.fh')
                        GO TO 200
                      ENDIF

                      LN_N            = LN_N + 1
                      LN_ID    (LN_N) = LN_ID    (LN)
                      LN_1ICHN (LN_N) = LN_1ICHN (LN)
                      LN_1CHN  (LN_N) = GROUP
                      LN_1RNAM (LN_N) = LN_1RNAM (LN)
                      LN_1IRES (LN_N) = LN_1IRES (LN)
                      LN_SEQ1  (LN_N) = LN_SEQ1  (LN)
                      LN_2ICHN (LN_N) = LN_2ICHN (LN)
                      LN_2CHN  (LN_N) = GROUP
                      LN_2RNAM (LN_N) = LN_2RNAM (LN)
                      LN_2IRES (LN_N) = LN_2IRES (LN)
                      LN_SEQ2  (LN_N) = LN_SEQ2  (LN)
                      LN_ATOM1 (LN_N) = LN_ATOM1 (LN)
                      LN_ATOM2 (LN_N) = LN_ATOM2 (LN)
                      LN_ALT1  (LN_N) = LN_ALT1  (LN)
                      LN_ALT2  (LN_N) = LN_ALT2  (LN)
                      LN_SYMM1 (LN_N) = LN_SYMM1 (LN)
                      LN_SYMM2 (LN_N) = LN_SYMM2 (LN)
                      LN_USED  (LN_N) = LN_USED  (LN)
                      LN_ENT   (LN_N) = LN_ENT   (LN)
                      LN_DIST  (LN_N) = LN_DIST  (LN)

                    ENDIF
                  ENDIF
  200             CONTINUE
                ENDDO
              ENDIF
c              GO TO 200
            ENDIF
          ENDDO
c 200      CONTINUE
        ENDDO
      ENDIF

c           IF(LN_N.GT.0) THEN
c             DO LN=1,LN_N
c                write(*,*) 'ln:',LN_ID(LN), 
c     * LN_SEQ1(ln),LN_1CHN(LN),LN_SEQ2(ln),LN_2CHN(LN),LN_ENT(LN)
c             enddo
c           endif
C -------------------------------------------
      IF(IERR.LT.0) THEN
        IERR=0
        RETURN
      ELSE IF(IERR.GT.0) THEN
        IERR=4
        RETURN
      ENDIF
      RETURN
      END

      SUBROUTINE CLEAN_DATA_CSD(DATA)
C -------------------------------------------
      CHARACTER DATA*(*),LINE*256
C -------------------------------------------
      CALL LENSTR_BL(DATA,L)
      LINE = DATA
      DATA = ' '
      IF(L.GT.0) THEN
        K = 0
        DO I=1,L
          IF(LINE(I:I).EQ.'(') GO TO 100
          K         = K +1
          DATA(K:K) = LINE(I:I)
        ENDDO
 100    CONTINUE
      ENDIF
      RETURN
      END

C ******
      SUBROUTINE RDCRD_CIF(MDOC,IN,MODE,IEND,IERR)
C
C -P- RDCRD_CIF - reads coordinates 
C
      INTEGER IN,MDOC,IERR,IEND,MODE
C ******
C ------------------------------------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---------------------------------------------------------------
      INCLUDE 'crd_com.fh'
C ---------------------------------------------------------------
      COMMON/COM_CRD_CIF/ IEND_CIF      
C
      COMMON/COM_CRD_CIF_SAVE/ LC,LI,LA,LS,LN,LNA,LSM,LAL,LR,LCL,LM,LBF
     *                        ,L11,L22,L33,L12,L13,L23,LCR,LX1,LX2,LX3
     *                        ,LS1,LS2,LS3,LO,LSO,LB,LSB,LAA,LAC
C ---------------------------------------------------------------
      INTEGER   IDATA
      REAL      FDATA
      CHARACTER DATA*80,ITEM*80
C --
      CHARACTER LINE*256
      CHARACTER BFLAG*1,MULT*2,ASYMB*4,CH5*5,TYPE*4,ENT*4
      CHARACTER TYPE1*1
C --------------------------------------------------------------
      INCLUDE 'CIF_items_crd.fh'
C ------------------------------------------------------------
      IERR = 0
      M    = 99      
      IF(IEND.EQ.-1) THEN
C       first call
        REWIND IN
        IEND_CIF = -1
        CR_IATOM =  0
        IEND     =  0

C????   LAC store
        CALL LENSTR_BL(ITA_ATOM_CAT ,LC ) 
        CALL LENSTR_BL(ITA_IATOM    ,LI ) 
        CALL LENSTR_BL(ITA_ATOM     ,LA ) 
        CALL LENSTR_BL(ITA_ATOM_CHEM,LAC) 
        CALL LENSTR_BL(ITA_ATOM_AUTH,LAA) 
        CALL LENSTR_BL(ITA_SYMB     ,LS ) 
        CALL LENSTR_BL(ITA_ISEQ     ,LN ) 
        CALL LENSTR_BL(ITA_SEQ_AUTH ,LNA) 
        CALL LENSTR_BL(ITA_ASYM     ,LSM) 
        CALL LENSTR_BL(ITA_ALT      ,LAL) 
        CALL LENSTR_BL(ITA_RES      ,LR ) 
        CALL LENSTR_BL(ITA_CALC     ,LCL) 
        CALL LENSTR_BL(ITA_MULT     ,LM ) 
        CALL LENSTR_BL(ITA_B_FLAG   ,LBF) 
        CALL LENSTR_BL(ITA_ANISO_U11,L11) 
        CALL LENSTR_BL(ITA_ANISO_U22,L22) 
        CALL LENSTR_BL(ITA_ANISO_U33,L33) 
        CALL LENSTR_BL(ITA_ANISO_U12,L12) 
        CALL LENSTR_BL(ITA_ANISO_U13,L13) 
        CALL LENSTR_BL(ITA_ANISO_U23,L23) 
        CALL LENSTR_BL(ITA_ID_CORR  ,LCR) 
        CALL LENSTR_BL(ITA_XYZ_CRD1 ,LX1) 
        CALL LENSTR_BL(ITA_XYZ_CRD2 ,LX2) 
        CALL LENSTR_BL(ITA_XYZ_CRD3 ,LX3) 
        CALL LENSTR_BL(ITA_SD_CRD1  ,LS1) 
        CALL LENSTR_BL(ITA_SD_CRD2  ,LS2) 
        CALL LENSTR_BL(ITA_SD_CRD3  ,LS3) 
        CALL LENSTR_BL(ITA_OCCUP    ,LO ) 
        CALL LENSTR_BL(ITA_SD_OCC   ,LSO) 
        CALL LENSTR_BL(ITA_B_ISO    ,LB ) 
        CALL LENSTR_BL(ITA_SD_ISO   ,LSB) 
      ENDIF

  300 CONTINUE   

      CALL GETCIF_INFO(IN,MDOC,IERR,IEND_CIF)
      IF(IERR.NE.0) THEN
        GO TO 1200
      ENDIF

      IF(IEND_CIF.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment
C   
        LINE=DT_CIF (NWORDSMAX)
        CALL LENSTR_BL(LINE,LEN)
        IF(LEN.LE.0.OR.LINE(1:1).EQ.'#'.OR.LINE(1:1).EQ.'C'.OR.
     *     LINE(1:1).EQ.'d'.OR.LINE(1:1).EQ.'c'.OR.
     *     LINE(1:1).EQ.'_') THEN
          MODE = 1
          IF(LEN.LE.0) THEN
            LEN       = 1
            LINE(1:1) = '#'
          ENDIF
          CR_LINE = LINE(1:LEN)
          GO TO 500
        ENDIF
        GO TO 300 
      ELSE IF(IEND_CIF.NE.0) THEN
C       end of file
C ? close
        GO TO 1300
      ENDIF

      IF(N_CIF.LE.0) GO TO 300

C      CALL LENSTR_BL(ITA_ATOM_CAT,LC) 

      IF((ITM_CIF(1)(1:11).NE.'_atom_site_'     ).AND.
     *   (ITM_CIF(1)(1:LC).NE.ITA_ATOM_CAT(1:LC)))  GO TO 300
C --- _atom_site ---

      CR_ANAME     = '.   '
      CR_ANAME_INP = '.   '
      ST_CHEM      = '.   '
      CR_ASYMB     = '.   '
      CR_RNAME     = '.  '
      CR_PNUM      = '            '       
      CR_BTYPE     = '.'
      CR_ALT       = '.'
      CR_CORR      = '.'
      CR_IATOLD    = 0
      CR_IGROUP    = 0
      CR_SF_ID     = 0
      CR_GROUP     = '.   '
      CR_MULT_FLAG = 1
      CR_IRES      = 0
      IFLAG        = 0
      IFLAG_AUTH   = 0
      IFLAG_ISEQ   = 0
      IFLAG_IASM   = 0
      IFLAG_IENT   = 0
      IFLAG_NDB    = 0
      ENT          = '.'      

      DO I=1,N_CIF

        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM  = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA  = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IDATA = IDT_CIF(I)
        FDATA = FDT_CIF(I)

        LC1 = LC + 1
 
        IF((ITEM(LC1:LC+11).EQ.'atom_number'  ).OR.
     *     (ITEM(LC1:LI+LC).EQ.ITA_IATOM(1:LI))) THEN
          CR_IATOLD=IDATA
        ELSE IF(ITEM(LC1:LA+LC).EQ.ITA_ATOM(1:LA)) THEN

          CR_ANAME(1:LEND) = DATA(1:LEND)
          CALL CHKSMB(DATA(1:1),TYPE1)              
          IF(TYPE1.EQ.'D'.AND.LEND.GT.1) THEN
            L = LEND
            IF(L.GT.4) L = 4
            DO K=1,L-1
              CR_ANAME(K:K) = DATA(K+1:K+1) 
            ENDDO
            CR_ANAME(L:L) = DATA(1:1)
          ENDIF

        ELSE IF(ITEM(LC1:LAA+LC).EQ.ITA_ATOM_AUTH(1:LAA)) THEN

          CR_ANAME_INP(1:LEND) = DATA(1:LEND)
c          CALL CHKSMB(DATA(1:1),TYPE1)              
c          IF(TYPE1.EQ.'D'.AND.LEND.GT.1) THEN
c            L = LEND
c            IF(L.GT.4) L = 4
c            DO K=1,L-1
c              CR_ANAME_INP(K:K) = DATA(K+1:K+1) 
c            ENDDO
c            CR_ANAME_INP(L:L) = DATA(1:1)
c          ENDIF

        ELSE IF(ITEM(LC1:LAC+LC).EQ.ITA_ATOM_CHEM(1:LAC)) THEN
          ST_CHEM(1:LEND) = DATA(1:LEND)
        ELSE IF(ITEM(LC1:LS+LC).EQ.ITA_SYMB(1:LS)) THEN
          CR_ASYMB(1:LEND) = DATA(1:LEND)
          IT = 1
C
C         IT = 1  convert symbols to upper case.
C                   
          CALL CHECK_LINE(IT,CR_ASYMB)

        ELSE IF((ITEM(LC1:20 ).EQ.'atom_type'       ).OR.
     *          (ITEM(LC1:LCL+LC).EQ.ITA_CALC(1:LCL))) THEN
          CR_ATYPE=DATA(1:1)
        ELSE IF(ITEM(LC1:LAL+LC).EQ.ITA_ALT(1:LAL)) THEN
          IF(DATA(1:1).NE.'?') CR_ALT = DATA(1:1)
        ELSE IF((ITEM(LC1:24 ).EQ.'label_corr_id'       ).OR.
     *          (ITEM(LC1:LCR+LC).EQ. ITA_ID_CORR(1:LCR))) THEN

          IF(CR_SOFT.EQ.'B') CR_CORR = DATA(1:1)

        ELSE IF((ITEM(LC1:23).EQ.'label_res_id'  ).OR.
     *          (ITEM(LC1:LR+LC).EQ.ITA_RES(1:LR))) THEN
C                                 label_comp_id            
          CR_RNAME(1:LEND)=DATA(1:LEND)
        ELSE IF(ITEM(LC1:LN+LC).EQ.ITA_ISEQ(1:LN)) THEN

          IF(LEND.GT.0.AND.DATA(1:1).NE.'?') THEN
            CR_IRES    = IDATA
            IFLAG_ISEQ = 1
          ENDIF

        ELSE IF(ITEM(LC1:LN+LC).EQ.ITA_SEQ_AUTH(1:LNA)) THEN
C
C    _atom_site.auth_seq_id

          IF(LEND.GT.0.AND.DATA(1:1).NE.'?') THEN
            CH5 = '     '
            J   = 5
            DO K = 5,1,-1
              IF(DATA(K:K).NE.' ') THEN
                CH5(J:J) = DATA(K:K) 
                J = J -1
              ENDIF
            ENDDO
            CALL CHKSMB(CH5(5:5),TYPE1)              
            IF(TYPE1.EQ.'D') THEN
              DO K=2,5
                CH5(K-1:K-1) = CH5(K:K)
              ENDDO 
              CH5(5:5) = ' '
            ENDIF
            CR_PNUM(3:7) = CH5
            IFLAG_AUTH   = 1
          ENDIF

C        ELSE IF((ITEM(LC1:24 ).EQ.'label_asym_id'   ).OR. 
C     *          (ITEM(LC1:LSM+LC).EQ.ITA_ASYM(1:LSM))) THEN
C          CR_GROUP = DATA(1:LEND)
        ELSE IF(ITEM(LC1:26 ).EQ.'label_entity_id' ) THEN
          IF(LEND.GT.0.AND.DATA(1:1).NE.'?') THEN
            IFLAG_IENT = 1
            ENT        = DATA(1:LEND) 
          ENDIF
        ELSE IF(ITEM(LC1:LSM+LC).EQ.ITA_ASYM(1:LSM)) THEN
C                                    label_asym_id'   
          IF(LEND.GT.0.AND.DATA(1:1).NE.'?') THEN
            IFLAG_IASM = 1
            CR_GROUP   = DATA(1:LEND)
          ENDIF
        ELSE IF((ITEM(LC1:LENI).EQ.ITA_XYZ_CRD1(1:LX1)).OR.
     *          (ITEM(LC1:LENI).EQ.ITA_XYZ_CRD4(1:LX1))    ) THEN
          CR_XYZ(1)=FDATA
        ELSE IF((ITEM(LC1:LENI).EQ.ITA_XYZ_CRD2(1:LX2)).OR.
     *          (ITEM(LC1:LENI).EQ.ITA_XYZ_CRD5(1:LX1))    ) THEN
          CR_XYZ(2)=FDATA
        ELSE IF((ITEM(LC1:LENI).EQ.ITA_XYZ_CRD3(1:LX3)).OR.
     *          (ITEM(LC1:LENI).EQ.ITA_XYZ_CRD6(1:LX1))    ) THEN
          CR_XYZ(3)=FDATA
        ELSE IF(ITEM(LC1:LENI).EQ.ITA_OCCUP(1:LO)) THEN
          CR_OCC=FDATA
        ELSE IF(ITEM(LC1:LENI).EQ.ITA_B_ISO(1:LB)) THEN
          CR_BISO=FDATA
        ELSE IF(ITEM(LC1:LBF+LC).EQ.ITA_B_FLAG(1:LBF)) THEN
          CR_BTYPE = '.' 
          IF(DATA(1:4).EQ.'Uani'.OR.DATA(1:1).EQ.'A'
     *                          .OR.DATA(1:1).EQ.'a') CR_BTYPE = 'A'
        ELSE IF(ITEM(LC1:LM+LC).EQ.ITA_MULT(1:LM)) THEN
          IF(DATA(1:1).EQ.'.') THEN
            CR_MULT_FACTOR=1
          ELSE
            CR_MULT_FACTOR=IDATA
          ENDIF
        ELSE IF(ITEM(LC1:L11+LC).EQ.ITA_ANISO_U11(1:L11)) THEN
          IF(DATA.NE.'.') THEN
            CR_BTYPE     = 'A'
            CR_FLAG_USER = 'A'
          ENDIF
          CR_ANIS(1)   = FDATA
        ELSE IF(ITEM(LC1:L22+LC).EQ.ITA_ANISO_U22(1:L22)) THEN
          IF(DATA.NE.'.') THEN
            CR_BTYPE     = 'A'
            CR_FLAG_USER = 'A'
          ENDIF
          CR_ANIS(2)   = FDATA
        ELSE IF(ITEM(LC1:L33+LC).EQ.ITA_ANISO_U33(1:L33)) THEN
          IF(DATA.NE.'.') THEN
            CR_BTYPE     = 'A'
            CR_FLAG_USER = 'A'
          ENDIF
          CR_ANIS(3)   = FDATA
        ELSE IF(ITEM(LC1:L12+LC).EQ.ITA_ANISO_U12(1:L12)) THEN
          IF(DATA.NE.'.') THEN
            CR_BTYPE     = 'A'
            CR_FLAG_USER = 'A'
          ENDIF
          CR_ANIS(4)   = FDATA
        ELSE IF(ITEM(LC1:L13+LC).EQ.ITA_ANISO_U13(1:L13)) THEN
          IF(DATA.NE.'.') THEN
            CR_BTYPE     = 'A'
            CR_FLAG_USER = 'A'
          ENDIF
          CR_ANIS(5)   = FDATA
        ELSE IF(ITEM(LC1:L23+LC).EQ.ITA_ANISO_U23(1:L23)) THEN
          IF(DATA.NE.'.') THEN
            CR_BTYPE     = 'A'
            CR_FLAG_USER = 'A'
          ENDIF
          CR_ANIS(6)   = FDATA
        ENDIF

      ENDDO

      MODE = 0

      IF(CR_IATOLD.LE.0) GO TO 300

      CR_IATOM  = CR_IATOM+1

      IF(IFLAG_AUTH.EQ.0) THEN
        WRITE(CR_PNUM(3:6),'(I4)') CR_IRES       
        CR_PNUM(7:7) = ' '
      ENDIF

C????  CR_PNUM 
      IF(IFLAG_ISEQ.EQ.0) THEN
        READ(CR_PNUM(3:6),'(I4)') CR_IRES       
      ENDIF

      IF(IFLAG_IASM.LE.0) THEN
        CR_GROUP = ENT
      ENDIF

      CALL LENSTR_BL(CR_GROUP,L)
      IF(L.LE.1) CR_GROUP(2:2) = CR_GROUP(1:1)
              
      CR_PNUM(1:2) = CR_GROUP(1:2)
      CR_PNUM(8:11) = CR_GROUP
C ---
C     print 
C
      BFLAG='.'
      IF(CR_BTYPE.EQ.'A') BFLAG='A'

      IF(CR_MULT_FACTOR.GT.1) THEN
        I = CR_MULT_FACTOR
        IF(I.GT.99) I = 99
        IF(I.LT.0 ) I = 0
        WRITE(MULT,'(I2)') I
      ELSE
        MULT = '. '
      ENDIF

      IF(CR_SOFT.NE.'B') THEN
        CALL CORR_NAME(CR_ANAME,CR_RNAME,ASYMB,CH5)        
      ENDIF

      IF(CR_ASYMB(1:1).EQ.'.'.OR.CR_ASYMB(1:1).EQ.'?') THEN
C       --- ?
        ASYMB    = CR_ANAME
        CR_ASYMB = '    '
        CALL LENSTR_BL(ASYMB,L)
        IF(L.GT.2.AND.(ASYMB(1:2).EQ.'HG'.OR.ASYMB(1:2).EQ.'HO')) THEN
          CR_ASYMB = 'H   ' 
        ELSE IF(ASYMB(1:2).EQ.'CA'.OR.ASYMB(1:2).EQ.'CD') THEN
C          CALL SET_INI_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
          CALL GET_INI_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
          IF(ITYPE.EQ.3.OR.ITYPE.EQ.4) THEN
            CR_ASYMB = 'C   ' 
          ELSE
            CR_ASYMB(1:2) = CR_ANAME(1:2) 
          ENDIF
        ELSE
          ASYMB(3:4) = '  '
          CALL SET_CTYPE(ASYMB,TYPE)
          IF(TYPE(1:1).EQ.'$') THEN
            CR_ASYMB(1:2) = CR_ANAME(1:2) 
          ELSE
            CR_ASYMB(1:1) = CR_ANAME(1:1)
          ENDIF
        ENDIF

      ENDIF

      IF(CR_SOFT.NE.'B') THEN
C        CALL SET_INI_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
        CALL GET_INI_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
        IF(ITYPE.EQ.6.OR.ITYPE.EQ.5) THEN
          IF(CR_ANAME.EQ.'OXT ') THEN
            CR_ANAME = 'O3T '
            CALL MSGDOC(MDOC,
     *      ' WARNING : for DNA/RNA atom "OXT " --> "O3T " (default)')
          ENDIF
          IF(CR_ANAME.EQ.'O3P ') THEN
            CR_ANAME = 'O3T '
            CALL MSGDOC(MDOC,
     *      ' WARNING : for DNA/RNA atom "O3P " --> "O3T " (default)')
          ENDIF
          IF(CR_ANAME.EQ.'O3G ') THEN
            CR_ANAME = 'O3T '
            CALL MSGDOC(MDOC,
     *      ' WARNING : for DNA/RNA atom "O3G " --> "O3T " (default)')
          ENDIF
        ENDIF
      ENDIF

      ASYMB      = CR_ASYMB

      WRITE(LINE,100)
     *    CR_IATOLD,CR_ANAME,ASYMB,CR_ATYPE
     *   ,CR_ALT,CR_CORR
     *   ,CR_RNAME(1:3),CR_IRES,CR_GROUP(1:2)
     *   ,CR_XYZ(1),CR_XYZ(2),CR_XYZ(3)
     *   ,CR_OCC,CR_BISO,BFLAG,MULT

  100     FORMAT(I5,1X,A4,1X,A4,1X,A1,1X,A1,1X,A1,1X,A3,1X 
     *    ,I4,1X,A,1X,F8.3,1X,F8.3,1X,F8.3,1X,F6.2,1X,F6.2
     *    ,1X,A1,1X,A2)
      CR_LINE=LINE

C ---   
 500  CONTINUE
      CALL MSGDOC(M,LINE)
C ---
      RETURN
C -----------------------------
1200  CONTINUE 
      CALL MSGERR(MDOC,' ERROR: read input file')
      CLOSE(CRI_IUN)
      IERR=1
      RETURN

1300  CONTINUE 
C     end of file    
      CLOSE(CRI_IUN)
      IEND=1
      RETURN

      END

      SUBROUTINE GET_SF_ID(MDOC,ELEMENT,INSF,IERR)
C -----------------------------------------------
C -P- CHKASYM -
C -S-
      INCLUDE 'atom_com.fh'
C --
      INTEGER*4 MDOC,IERR
      CHARACTER ELEMENT*4
C ******
C     CHARACTER LINE*256
C ---------------------------------------
      IERR    = 0
      INSF    = 0

      IF(CS_NSFATM.GT.0) THEN

        DO ISF=1,CS_NSFATM
          IF(ELEMENT.EQ.CS_ELEMENT(ISF)) THEN
            INSF    = ISF
            RETURN
          ENDIF
        ENDDO
      ENDIF

      IERR = 1
      RETURN
      END

C -I-
      SUBROUTINE WRITE_ATOMS(MDOC,PATH,NAMEC,EXT,IERR)
C ----------------------------------------------------------
C -P- WRITE_ATOMS - 
C
C    MDOC   - mode of writting messages to DOC-file
C             0 - only terminal , < - 0 only file, 0 < < 99 - both
C             >= 99 - don't write  
C    NAMEC  - name of input file
C    IERR   - output signal of error / = 1 -error , = 0 - OK / 
C -I-
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C --------------
      INTEGER     MDOC,IERR
      CHARACTER   NAMEC*(*),PATH*(*),EXT*(*)
C ----------------------------------------------------------------
C     REAL      AM(3,3),TR(3)
C     CHARACTER GID*4,NCSF*1,CH4*4
      CHARACTER ASYMB*4,TYPE*4
      CHARACTER LINE*256
C==================================================================
      IERR  = 0
      PI    = 4.0*ATAN(1.0)
      CONST = 8.0*PI*PI
      MD    = -ABS(MDOC)-1
      M     = 99
C --------
C     open output file
C
C     IN       = 11
      IN       = CRO_IUN
C ---
c      CRO_FILE = NAMEC
c      CRO_PATH = PATH
c      CRO_EXT  = EXT
C ---
      CALL OWCRD_CIF(MD,IN,PATH,NAMEC,EXT,IERR)
      CRO_IUN = IN
      IF(IERR.EQ.1) THEN
        CALL MSGERR(MDOC,' ERROR: open output file')
        RETURN
      ELSE IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: writing titles of output file')
        RETURN
      ENDIF
C --------
      NATOM =  0
      IEND  = -1
C --------
      IF(N_ATOM.LE.0) THEN 
        CALL MSGERR(MDOC,' ERROR: number of atoms = 0 /write_atoms/')
        IERR=2
        RETURN
      ENDIF

C -- tree --

      DO IG=1,N_GROUP

C -- tree --
      NR       = NRES_CHAIN     (IG)
      IRS_TREE = IRES_START_TREE(IG)
      IRF_TREE = IRES_END_TREE  (IG)
      IRS      = IRES_FIRST     (IG)

      IF(NR.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR: N-residues = 0 /write_atoms/')
        IERR = 1
        RETURN
      ENDIF
      IF(IRS.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR: Ires_first = 0 /write_atoms/')
        IERR = 1
        RETURN
      ENDIF
      IF(IRS_TREE.LE.0.OR.IRF_TREE.LE.0) THEN
        CALL MSGERR(MDOC,
     *  ' ERROR: wrong tree structure .../write_atoms/')
        IERR = 1
        RETURN
      ENDIF

      IRF  = IRS + NR - 1
      IRES = IRS_TREE         

 800  CONTINUE
  
      IAS = IRATM_FIRST(IRES)
      NA  = NATM_RES   (IRES)     

      IF(NA.LE.0.OR.IAS.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR: N-atoms = 0 /write_atoms/')
        IERR=1
        RETURN
      ENDIF

      IAF = IAS+NA-1

      DO I=IAS,IAF      
C -- tree --

C     DO I=1,N_ATOM   

        CR_IATOLD = I_ATOLD(I)    

C        IRES      = I_RESID    (I)
        CR_RNAME  = RES_NAME   (IRES)
        CR_IRES   = IRES_SERIAL(IRES)
C        IG        = I_CHAIN    (IRES) 
        CR_IGROUP = IG 
        IB        = B_FLAG     (I)
        CR_PNUM   = RES_NUM_PDB(IRES)
        CR_GROUP  = GROUP_ID   (IG)

C        CH4 = CR_PNUM(3:6)
C        READ(CH4,'(I4)') CR_IRES

        CR_BTYPE  = '.'
        IF(N_ANISO.GT.0) CR_BTYPE  = 'A' 

        IF(IB.EQ.0) THEN
          CR_B_FLAG = 0
          DO IAN=1,6
            CR_ANIS(IAN) = 0.0
          ENDDO
          CR_BISO   = U_ANISO(1,I)*CONST
        ELSE
          CR_B_FLAG = 1
          DO IAN=1,6
            CR_ANIS(IAN) = U_ANISO(IAN,I)
          ENDDO
          CALL CALC_B_EQUIV(U_ANISO(1,I),CR_BISO)
        ENDIF     

        CR_ANAME  = ATM_NAME (I)     
        CR_ANAME_INP= ATM_NAME_INP(I)     
        ST_CHEM   = ATM_CHEM (I)     
        INSF      = ID_SF    (I)
C       CR_ASYMB  = CS_ATYPE (INSF) 
        ITYPE     = IRES_TYPE(IRES)    

        IF(INSF.GT.0) THEN
          CR_ASYMB  = CS_ELEMENT(INSF)      
          IF(CR_ASYMB.EQ.'?') THEN
            CR_ASYMB  = CS_ATYPE (INSF)
          ENDIF   
        ELSE
C       --- ?
          CR_ASYMB  = '?'
          ASYMB    = CR_ANAME
          CALL LENSTR_BL(ASYMB,L)
          IF(L.GT.2.AND.
     *       (ASYMB(1:2).EQ.'HG'.OR.ASYMB(1:2).EQ.'HO')) THEN
            CR_ASYMB = 'H   ' 
          ELSE IF(ASYMB(1:2).EQ.'CA'.OR.ASYMB(1:2).EQ.'CD') THEN
            IF(ITYPE.EQ.3.OR.ITYPE.EQ.4) THEN
              CR_ASYMB = 'C   ' 
            ELSE
              CR_ASYMB(1:2) = CR_ANAME(1:2) 
            ENDIF
          ELSE
            ASYMB(3:4) = '  '
            CALL SET_CTYPE(ASYMB,TYPE)
            IF(TYPE(1:1).EQ.'$') THEN
              CR_ASYMB(1:2) = CR_ANAME(1:2) 
            ELSE
              CR_ASYMB(1:1) = CR_ANAME(1:1)
            ENDIF
          ENDIF
        ENDIF

        CR_SF_ID  = INSF
        CR_ATYPE  = ATM_TYPE (I)    
        CR_ALT    = ID_ALT   (I)    
        CR_CORR   = ID_CORR  (I)    
        CR_XYZ(1) = XYZ_CRD  (1,I) 
        CR_XYZ(2) = XYZ_CRD  (2,I)  
        CR_XYZ(3) = XYZ_CRD  (3,I)
        CR_OCC    = OCCUP    (I)
        CR_MULT_FACTOR = MULT_FACTOR(I)
        NATOM     = NATOM + 1
C ----
        MODE = 0
        CALL WRCRD_CIF(M,IN,MODE,IEND,IERR)
        IF(IERR.NE.0) THEN
          RETURN
        ENDIF
C ----
      ENDDO
C --- tree --
      IF(IRES.NE.IRF_TREE) THEN
        IRES = IRES_FORW(IRES)
        IF(IRES.LE.0.OR.IRES.LT.IRS.OR.IRES.GT.IRF) THEN
          CALL MSGERR(MDOC,
     *    ' ERROR: wrong tree structure ...../write_atoms/')
          IERR = 1
          RETURN
        ENDIF
        GO TO 800
      ENDIF
C --- tree --
      ENDDO
C --- tree --
C --------------------------------------
C
C     close output file
C
      IENDW = 1
      MODE  = 0     
      CALL WRCRD_CIF(MDOC,IN,MODE,IENDW,IERR)

      WRITE(LINE,'('' Number of atoms to write :'',I8)') NATOM
      CALL MSGDOC(MDOC,LINE)
C --------------------------------------
      RETURN
      END

      SUBROUTINE OWCRD_CIF(MDOC,IUN,PATH,NAMEO,EXT,IERR)
C -P- 
C ----------------------------------------------------------------------------
      INTEGER   MDOC,IUN,IERR
      CHARACTER NAMEO*(*),EXT*(*),PATH*(*)
C ----------------------------------
      CHARACTER LINE*256,STR*256
      CHARACTER CODE*8,TEMPER*5,WAVE*5
      CHARACTER TITLE*80,CH10*10,CODE_NDB*8,CHAIN*4
      CHARACTER CH1*1,CH2*2,CH3*3
C     CHARACTER NCSF_FLAG*1,CH2M*2,CID*4,TYPE*16
      INTEGER   LEN
C ------------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
      INCLUDE 'CIF_items_crd.fh'
C ------------------------------------------------------------
      M     = 99
      IERR  = 0
      PI    = 4.0*ATAN(1.0)
      PI180 = PI/180.0
C ------------------------------------------------------------
C     open
C
      CALL LENSTR_BL(NAMEO,LEN)
      IF(LEN.GT.0.AND.NAMEO(1:1).NE.','.AND.NAMEO(1:1).NE.' ') THEN 
C       IUN=11
        IUN=CRO_IUN
        CALL OPENFW(IUN,M,PATH,NAMEO,EXT,IERR)
        CRO_IUN = IUN
        IF(IERR.NE.0) THEN
          IERR=1  
          CALL MSGERR(MDOC,' ERROR: OPEN OUTPUT_FILE ')
          RETURN
        ENDIF
      ELSE
        IERR=1  
        CALL MSGERR(MDOC,' ERROR: WRONG NAME OF OUTPUT_FILE')
        RETURN
      ENDIF
C -------------------------------------------------------
      CH1=''''
      CALL LENSTR_BL(CS_TITLE,LEN)
      IF(LEN.LE.0) THEN 
        TITLE = '?'
      ELSE
        TITLE = CS_TITLE
      ENDIF
      WAVE   = '?'
      TEMPER = '?'

      CALL LENSTR_BL(CS_CD_PDB,LEN)
      IF(LEN.LE.0) THEN
        CODE         = 'XXXX    '
        CODE_NDB     = '?'
        CS_CD_PDB    = '-'
        LEN          = 1
      ELSE
        CODE         = CS_CD_PDB(1:LEN)
        CODE_NDB     = CODE
      ENDIF

      IF(CODE_NDB(1:4).EQ.CS_CD_PDB(1:4).AND.CODE_NDB(5:8).EQ.'    ')
     *  CODE_NDB = '?'

      IF(CODE(1:1).EQ.'?'.OR.CODE(1:1).EQ.' '.OR.CODE(1:1).EQ.'.'.OR.
     *   CODE(1:4).EQ.'XXXX') THEN
        CODE     = CS_CD_PDB(1:LEN)//'    '    
        CODE_NDB = '?'
      ENDIF
C --------------------------------------------
      CALL LENSTR_BL(CODE,LENCD)
      WRITE(LINE,'(''data_structure_'',A)') CODE(1:LENCD)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
C ---_entry.id
      CALL LENSTR_BL(ICS_ENTRY_ID,L)
      WRITE(LINE,'(A,2X,A)')
     *ICS_ENTRY_ID(1:L),CODE(1:LENCD)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---------------------------------------------
C      WRITE(LINE,'(
C     *''_database_2.database_id'',2X,A)') CODE(1:LENCD)
C      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---------------------------------------------
C ---_database_2.code_PDB
      CALL LENSTR_BL(ICS_CAT_PDB,L)
      CALL LENSTR_BL(CS_CD_PDB,LEN)
      WRITE(LINE,'(A,2X,A)')
     *ICS_CAT_PDB(1:L),CS_CD_PDB(1:LEN)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---------------------------------------------
C ---_database_2.code_NDB
      IF(CODE_NDB(1:1).NE.'?') THEN
        WRITE(LINE,'(A,2X,A)')
     *  '_database_2.code_NDB   ',CODE(1:LENCD)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) THEN
          IERR=4
          GO TO 1000
        ENDIF
      ENDIF
C -----------------------------------------------
C     WRITE(LINE,'(''_struct_keywords.entry_id'',2X,A)') CODE(1:LENCD)
C     CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ------------------------------------------------
C --- _struct_keywords.text
      CALL LENSTR_BL(CS_NAME_PDB,LEN)
      IF(LEN.LE.0) THEN
        CS_NAME_PDB='?'
        LEN=1
      ENDIF
      I=LEN+L+4
      IF(I.GT.78) LEN=78-L-4
      CALL LENSTR_BL(ICS_KEYWORD_1,L)
      WRITE(LINE,'(A,2X,A,A,A)')
     * ICS_KEYWORD_1(1:L),CH1,CS_NAME_PDB(1:LEN),CH1
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
C -------------------------------------------------
C     WRITE(LINE,'(''_struct.entry_id'',2X,A)') CODE(1:LENCD)
C     CALL WRTSTR(IUN,MDOC,LINE,IERR)
C -------------------------------------------------
C --- _struct.title
      CALL LENSTR_BL(CS_TITLE,LEN)
      CALL LENSTR_BL(ICS_TITLE,L)
      I = LEN+L+4      
      IF(I.GT.78) LEN = 78-L-4
      WRITE(LINE,'(A,2X,A,A,A)')
     * ICS_TITLE(1:L),CH1,CS_TITLE(1:LEN),CH1
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
C ---------------------------------------------------
C     WRITE(LINE,'(''_database_PDB_rev.num 1'')') 
C     CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---------------------------------------------------
C     _database_PDB_rev.date_origina
C --- _audit.creation_date
      CALL CHNG_DATE(CS_DATE_PDB,CH10)
      CALL LENSTR_BL(ICS_DATE_PDB,L)
      WRITE(LINE,'(A,2X,A)') ICS_DATE_PDB(1:L),CH10(1:10)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
C ----------------------------------------------------  
C     _software.name
      CALL LENSTR_BL(ICS_SOFT_NAME,L)
      LINE = ICS_SOFT_NAME(1:L)//'  blanc'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ----------------------------------------------------  
C     _file_creation_date   
c        CALL CHCLOCK(CHAR20)
c        WRITE(LINE,200) CHAR20
c  200   FORMAT(       '_file_creation_date ',2X,'''',A,'''')
C -----------------------------------------------------

C ------------------------------------------
C ---     _entity. ---
c      DATA ICS_ENT_CAT   /'_entity.                                '/
c      DATA ICS_ENT_ID    /'_entity.id                              '/
c      DATA ICS_ENT_TYP   /'_entity.type                            '/
C ------------------------------------------
C --- _entity.

      IF(N_CHN_ENT.GT.0) THEN
        LINE='############'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        LINE='## ENTITY ##'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        LINE='############'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        WRITE(LINE,'(''loop_'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C       _entity.id
        CALL LENSTR_BL(ICS_ENT_ID,L)
        WRITE(LINE,'(A)') ICS_ENT_ID(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C       _entity.type
        CALL LENSTR_BL(ICS_ENT_TYP,L)
        WRITE(LINE,'(A)') ICS_ENT_TYP(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        DO  I=1,N_CHN_ENT
          WRITE(LINE,'(A,2X,A)') ENT_CHAIN_ID(I),ENT_CHAIN_TYPE(I)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          IF(IERR.NE.0) THEN
            IERR=4
            GO TO 1000
          ENDIF
        ENDDO
      ENDIF
C --------------------------------------------
C     entity_poly
C

      IFIRST = 0
      CALL WRT_ENTITY_POLY(MDOC,IUN,IFIRST,IERR)
      IF(IERR.NE.0) THEN
        IERR=3
        GO TO 1000
      ENDIF
C --------------------------------------------
C     entity_link
C

      IFIRST = 0
      CALL WRT_ENTITY_LINK(MDOC,IUN,IFIRST,IERR)
      IF(IERR.NE.0) THEN
        IERR=3
        GO TO 1000
      ENDIF
C --------------------------------------------
C --- _cell.
C
      LINE='##########'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE='## CELL ##'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE='##########'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)


      CALL LENSTR_BL(ICS_CELL_ENT,L)
      WRITE(LINE,'(A,2X,A)')
     *ICS_CELL_ENT(1:L),CODE(1:LENCD)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ICS_CELL1,L)
      WRITE(LINE,'(A,5X,F8.3)') 
     * ICS_CELL1(1:L),CS_CELL(1)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
      CALL LENSTR_BL(ICS_CELL2,L)
      WRITE(LINE,'(A,5X,F8.3)') 
     * ICS_CELL2(1:L),CS_CELL(2)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
      CALL LENSTR_BL(ICS_CELL1,L)
      WRITE(LINE,'(A,5X,F8.3)')
     * ICS_CELL3(1:L),CS_CELL(3)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      T=CS_CELL(4)/PI180
      CALL LENSTR_BL(ICS_CELL4,L)
      WRITE(LINE,'(A,2X,F8.3)')
     * ICS_CELL4(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
      CALL LENSTR_BL(ICS_CELL5,L)
      T=CS_CELL(5)/PI180
      WRITE(LINE,'(A,3X,F8.3)')
     * ICS_CELL5(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
      T=CS_CELL(6)/PI180
      CALL LENSTR_BL(ICS_CELL6,L)
      WRITE(LINE,'(A,2X,F8.3)')
     * ICS_CELL6(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
C ------------------
C     scale matrix
      LINE='##############################'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE='## FRACTIONALISATION MATRIX ##'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE='##############################'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ICS_SCALE11,L)
      WRITE(LINE,'(A,2X,F10.6)')
     * ICS_SCALE11(1:L),CS_SCALE(1,1)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
      CALL LENSTR_BL(ICS_SCALE12,L)
      WRITE(LINE,'(A,2X,F10.6)')
     * ICS_SCALE12(1:L),CS_SCALE(1,2)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
      CALL LENSTR_BL(ICS_SCALE13,L)
      WRITE(LINE,'(A,2X,F10.6)')
     * ICS_SCALE13(1:L),CS_SCALE(1,3)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
      CALL LENSTR_BL(ICS_SCALE21,L)
      WRITE(LINE,'(A,2X,F10.6)')
     * ICS_SCALE21(1:L),CS_SCALE(2,1)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
      CALL LENSTR_BL(ICS_SCALE22,L)
      WRITE(LINE,'(A,2X,F10.6)')
     * ICS_SCALE22(1:L),CS_SCALE(2,2)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
      CALL LENSTR_BL(ICS_SCALE23,L)
      WRITE(LINE,'(A,2X,F10.6)')
     * ICS_SCALE23(1:L),CS_SCALE(2,3)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
      CALL LENSTR_BL(ICS_SCALE31,L)
      WRITE(LINE,'(A,2X,F10.6)')
     * ICS_SCALE31(1:L),CS_SCALE(3,1)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
      CALL LENSTR_BL(ICS_SCALE32,L)
      WRITE(LINE,'(A,2X,F10.6)')
     * ICS_SCALE32(1:L),CS_SCALE(3,2)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
      CALL LENSTR_BL(ICS_SCALE33,L)
      WRITE(LINE,'(A,2X,F10.6)')
     * ICS_SCALE33(1:L),CS_SCALE(3,3)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
C     U - vector
      CALL LENSTR_BL(ICS_U11,L)
      WRITE(LINE,'(A,2X,F10.6)')
     * ICS_U11(1:L),CS_U(1)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF

      CALL LENSTR_BL(ICS_U22,L)
      WRITE(LINE,'(A,2X,F10.6)')
     * ICS_U22(1:L),CS_U(2)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF

      CALL LENSTR_BL(ICS_U33,L)
      WRITE(LINE,'(A,2X,F10.6)')
     * ICS_U33(1:L),CS_U(3)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF

C ------------------
C --- _symmetry.
      LINE='##############'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE='## SYMMETRY ##'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE='##############'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)


      CALL LENSTR_BL(ICS_SYMM_ID,L)
      WRITE(LINE,'(A,2X,A)') ICS_SYMM_ID(1:L),CODE(1:LENCD) 
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C --- _symmetry.space_group_name_H-M
      CALL LENSTR_BL(CS_SPGR,LEN)
      CALL LENSTR_BL(ICS_SYMM_SPGR,L)
      WRITE(LINE,'(A,2X,A,A,A)') 
     * ICS_SYMM_SPGR(1:L),CH1,CS_SPGR(1:LEN),CH1
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
C --- _symmetry.Int_Tables_number
      CALL LENSTR_BL(ICS_SYMM_NSPGR,L)
      WRITE(LINE,'(A,2X,I5)')
     * ICS_SYMM_NSPGR(1:L),CS_NSPGR
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF
C --- _symmetry.cell_setting_number
C      CALL LENSTR_BL(ICS_SYMM_SETT,L)
C      IF(CS_SETT.EQ.2) THEN
C        WRITE(LINE,'(A,2X,I5)') 
C     *  ICS_SYMM_SETT(1:L),CS_SETT
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        IF(IERR.NE.0) THEN
C          IERR=4
C          GO TO 1000
C        ENDIF
C      ENDIF
C ---
      IF(CS_NSYM.GT.0) THEN
        WRITE(LINE,'(''loop_'')') 
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) THEN
          IERR=4
          GO TO 1000
        ENDIF
C ---   _symmetry_equiv.id
        CALL LENSTR_BL(ICS_SYMM_EID,L)
        WRITE(LINE,'(A)') 
     *  ICS_SYMM_EID(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) THEN
          IERR=4
          GO TO 1000
        ENDIF
C ---   _symmetry_equiv.pos_as_xyz
        CALL LENSTR_BL(ICS_SYMM_SYMOP,L)
        WRITE(LINE,'(A)')
     *  ICS_SYMM_SYMOP(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) THEN
          IERR=4
          GO TO 1000
        ENDIF
C ?????
        DO  I=1,CS_NSYM

c         write(*,*) CS_M_CS(1,1,I),CS_M_CS(1,2,I),CS_M_CS(1,3,I)
c         write(*,*) CS_M_CS(2,1,I),CS_M_CS(2,2,I),CS_M_CS(2,3,I)
c         write(*,*) CS_M_CS(3,1,I),CS_M_CS(3,2,I),CS_M_CS(3,3,I)

          LINE = ' '
          L    = 0
          DO J=1,3

            TR = CS_V_CS(J,I)

            IF(ABS(TR).LT.0.00001) THEN
              NEG = 0
              TR  = 0
            ELSE IF(TR.LT.0.0) THEN
              L         = L+1
              LINE(L:L) = '-'
              NEG       = 1
            ELSE
              NEG = 0
            ENDIF
            TR = ABS(TR)
            IF(TR.GT.0.49.AND.TR.LT.0.51) THEN
              L           = L+1
              LINE(L:L+2) = '1/2'
              L           = L+2
            ELSE IF(TR.GT.0.24.AND.TR.LT.0.26) THEN
              L           = L+1
              LINE(L:L+2) = '1/4'
              L           = L+2
            ELSE IF(TR.GT.0.32.AND.TR.LT.0.34) THEN
              L           = L+1
              LINE(L:L+2) = '1/3'
              L           = L+2
            ELSE IF(TR.GT.0.74.AND.TR.LT.0.76) THEN
              L           = L+1
              LINE(L:L+2) = '3/4'
              L           = L+2
            ELSE IF(TR.GT.0.165.AND.TR.LT.0.167) THEN
              L           = L+1
              LINE(L:L+2) = '1/6'
              L           = L+2
            ELSE IF(TR.GT.0.66.AND.TR.LT.0.67) THEN
              L           = L+1
              LINE(L:L+2) = '2/3'
              L           = L+2
            ELSE IF(TR.GT.0.833.AND.TR.LT.0.835) THEN
              L           = L+1
              LINE(L:L+2) = '5/6'
              L           = L+2
            ELSE
              IF(NEG.GT.0) L = L-1
            ENDIF
            DO  K=1,3
 
              T = CS_M_CS(J,K,I)

              IF(ABS(T).LT.0.00001) T = 0.0

              IF(T.GT.0) THEN
                IDG = T + 0.0001
              ELSE
                IDG = T - 0.0001
              ENDIF

c              write(*,*) j,k,t,idg,l

              IF(IDG.LT.0) THEN
                L         = L+1
                LINE(L:L) = '-'
              ELSE IF(IDG.GT.0) THEN
                L         = L+1
                LINE(L:L) = '+'
              ENDIF
              IDG = ABS(IDG)
              IF(IDG.GT.1.AND.IDG.LT.10) THEN
                WRITE(CH1,'(I1)') IDG
                L           = L+1
                LINE(L:L)   = CH1
              ELSE IF(IDG.GT.9.AND.IDG.LT.100) THEN
                WRITE(CH2,'(I2)') IDG
                L           = L+1
                LINE(L:L+1) = CH2
                L           = L+1
              ELSE IF(IDG.GT.99.AND.IDG.LT.1000) THEN
                WRITE(CH3,'(I3)') IDG
                L           = L+1
                LINE(L:L+2) = CH3
                L           = L+2
              ENDIF
              IF(IDG.NE.0) THEN
                L = L+1
                IF(K.EQ.1) THEN
                  LINE(L:L) = 'X'
                ELSE IF(K.EQ.2) THEN
                  LINE(L:L) = 'Y'
                ELSE
                  LINE(L:L) = 'Z'
                ENDIF
              ENDIF
            ENDDO
            LINE(L+1:L+3) = ' , '
            L             = L+3
          ENDDO
          CALL LENSTR_BL(LINE,LEN)

c         write(*,*) line(1:len)

          JL = 0
          DO IL=1,LEN
            IF(LINE(IL:IL).NE.' ') THEN
              JL          = JL+1
              LINE(JL:JL) = LINE(IL:IL)
            ENDIF
          ENDDO
          LEN = JL
          STR = LINE(1:LEN)

          WRITE(STR,'(I3,2X,A)')  I,LINE(1:LEN)

C         WRITE(LINE,'(I3,2X,A)')  I,CS_SYMOP(I)

          CALL WRTSTR(IUN,MDOC,STR,IERR)
          IF(IERR.NE.0) THEN
            IERR=4
            GO TO 1000
          ENDIF
        ENDDO
      ENDIF
C ?????

C ------------------------------------------
C --- _struct_asym.

      IF(N_GROUP.GT.0  ) THEN
        LINE='#################'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        LINE='## STRUCT_ASYM ##'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        LINE='#################'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        WRITE(LINE,'(''loop_'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) THEN
          IERR=4
          GO TO 1000
        ENDIF
C       _struct_asym.id
        CALL LENSTR_BL(ICS_ASYM_ID,L)
        WRITE(LINE,'(A)') ICS_ASYM_ID(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) THEN
          IERR=4
          GO TO 1000
        ENDIF
C       _struct_asym.entity_id
        CALL LENSTR_BL(ICS_ASYM_ENT,L)
        WRITE(LINE,'(A)') ICS_ASYM_ENT(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) THEN
          IERR=4
          GO TO 1000
        ENDIF
C _struct_asym.nc_symmetry_id    
C        CALL LENSTR_BL(ICS_ASYM_NCS,L)
C        WRITE(LINE,'(A)') ICS_ASYM_NCS(1:L)
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        IF(IERR.NE.0) THEN
C          IERR=4
C          GO TO 1000
C        ENDIF
C _struct_asym.nc_symmetry_flag
C        CALL LENSTR_BL(ICS_ASYM_FLAG,L)
C        WRITE(LINE,'(A)') ICS_ASYM_FLAG(1:L)
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        IF(IERR.NE.0) THEN
C          IERR=4
C          GO TO 1000
C        ENDIF
C _struct_asym.multiplicity
C        CALL LENSTR_BL(ICS_ASYM_MULT,L)
C        WRITE(LINE,'(A)') ICS_ASYM_MULT(1:L)
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        IF(IERR.NE.0) THEN
C          IERR=4
C          GO TO 1000
C        ENDIF
C_struct_asym.PDB_chain_label
C        CALL LENSTR_BL(ICS_ASYM_PDB,L)
C        WRITE(LINE,'(A)') ICS_ASYM_PDB(1:L)
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        IF(IERR.NE.0) THEN
C          IERR=4
C          GO TO 1000
C        ENDIF
C ----------
C        DO IG=1,N_GROUP
C
C          IF(I_NCS(IG).LE.0) THEN
C            CH2='. '
C          ELSE
C            I = I_NCS(IG)
C            IF(I.GT.99) I = 99
C            IF(I.LT.0)  I = 0
C            WRITE(CH2,'(I2)') I
C          ENDIF
C
C          IF(NCS_FLAG(IG).EQ.' '.OR.NCS_FLAG(IG).EQ.'Y') 
C     *    NCS_FLAG(IG)='.'
C
C          IF(MULT_FLAG(IG).LE.1) THEN
C            CH2M = '. '
C          ELSE
C            WRITE(CH2M,'(I2)') MULT_FLAG(IG)
C          ENDIF
C
C          IF(CH2M(1:1).EQ.' ') THEN
C            CH2M(1:1) = CH2M(2:2)
C            CH2M(2:2) = ' '
C          ENDIF
C
C          CID = GROUP_ID(IG)
C          IF(CID(1:2).EQ.'  ') CID(1:2) = '. '
C
C          ICH = ICHAIN_GRP(IG)
C  
C          WRITE(LINE,800) IG,ICH,CH2,NCS_FLAG(IG),CH2M,CID(1:2)
C  800     FORMAT(2X,I4,2X,I4,2X,A2,2X,A1,2X,A2,2X,A2)
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          IF(IERR.NE.0) THEN
C            IERR=4
C            GO TO 1000
C          ENDIF
C
C        ENDDO
C      ENDIF

        DO IG=1,N_GROUP
          IASM = IGROUP_ASM(IG) 
          IF(IASM.GT.0.AND.IASM.LE.N_GRP_ASM) THEN
            CHAIN = ASM_CHAIN_ID(IASM)
          ELSE
            CHAIN = GROUP_ID(IG)
          ENDIF
          WRITE(LINE,'(A,2X,A)') GROUP_ID(IG),CHAIN
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          IF(IERR.NE.0) THEN
            IERR=4
            GO TO 1000
          ENDIF
        ENDDO

      ENDIF
C ------------------------------------------
      IFIRST=0
      CALL WRT_LINK(MDOC,IUN,IFIRST,IERR)
      IF(IERR.NE.0) THEN
        IERR=2
        GO TO 1000
      ENDIF
      IFIRST=0
      CALL WRT_MOD (MDOC,IUN,IFIRST,IERR)
      IF(IERR.NE.0) THEN
        IERR=3
        GO TO 1000
      ENDIF
C ------------------------------------------
C -- _atom_site.
      LINE='###############'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE='## ATOM_SITE ##'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      LINE='###############'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ITA_ATOM_CAT,LC)
      WRITE(LINE,'(''loop_'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ITA_IATOM,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_IATOM(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ITA_ATOM,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ATOM(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ITA_ALT,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ALT(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL( ITA_RES,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_RES(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ITA_ASYM,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ASYM(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

c      CALL LENSTR_BL(ITA_ISEQ,L)
c      WRITE(LINE,'(A,A)')
c     * ITA_ATOM_CAT(1:LC),ITA_ISEQ(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ITA_SEQ_AUTH,L)
      WRITE(LINE,'(A,A)')
     *ITA_ATOM_CAT(1:LC),ITA_SEQ_AUTH(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ITA_XYZ_CRD1,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_XYZ_CRD1(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ITA_XYZ_CRD2,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_XYZ_CRD2(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ITA_XYZ_CRD3,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_XYZ_CRD3(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ITA_OCCUP,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_OCCUP(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ITA_B_ISO,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_B_ISO(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C      CALL LENSTR_BL(ITA_B_FLAG,L)
C      WRITE(LINE,'(A,A)')
C     * ITA_ATOM_CAT(1:LC),ITA_B_FLAG(1:L)
C      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ITA_SYMB,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_SYMB(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C      CALL LENSTR_BL(ITA_MULT,L)
C      WRITE(LINE,'(A,A)')
C     * ITA_ATOM_CAT(1:LC),ITA_MULT(1:L)
C      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ITA_CALC,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_CALC(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

c      CALL LENSTR_BL( ITA_RES,L)
c      WRITE(LINE,'(A,A)')
c     * ITA_ATOM_CAT(1:LC),ITA_RES(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ITA_ATOM_AUTH,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ATOM_AUTH(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ITA_ATOM_CHEM,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ATOM_CHEM(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      IF(IERR.NE.0) THEN
        IERR=4
        GO TO 1000
      ENDIF

c      IF(OUT_CIF_CORR.EQ.0.OR.OUT_CIF_INS.EQ.0) THEN

      IF(OUT_CIF_CORR.EQ.0.OR.OUT_CIF_MULT.EQ.0) THEN

c        CALL LENSTR_BL(ITA_SEQ_AUTH,L)
c        WRITE(LINE,'(A,A)')
c     *   ITA_ATOM_CAT(1:LC),ITA_SEQ_AUTH(1:L)
c        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        CALL LENSTR_BL(ITA_MULT,L)
        WRITE(LINE,'(A,A)')
     *   ITA_ATOM_CAT(1:LC),ITA_MULT(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        CALL LENSTR_BL(ITA_ID_CORR,L)
        WRITE(LINE,'(A,A)')
     *   ITA_ATOM_CAT(1:LC),ITA_ID_CORR(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

      ENDIF

      IF(N_ANISO.GT.0) THEN
      CALL LENSTR_BL( ITA_ANISO_U11,L)
         WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ANISO_U11(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        CALL LENSTR_BL(ITA_ANISO_U22,L)
        WRITE(LINE,'(A,A)')
     *  ITA_ATOM_CAT(1:LC),ITA_ANISO_U22(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        CALL LENSTR_BL(ITA_ANISO_U33,L)
        WRITE(LINE,'(A,A)')
     *  ITA_ATOM_CAT(1:LC),ITA_ANISO_U33(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        CALL LENSTR_BL(ITA_ANISO_U12,L)
        WRITE(LINE,'(A,A)')
     *  ITA_ATOM_CAT(1:LC),ITA_ANISO_U12(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        CALL LENSTR_BL(ITA_ANISO_U13,L)
        WRITE(LINE,'(A,A)')
     *  ITA_ATOM_CAT(1:LC),ITA_ANISO_U13(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        CALL LENSTR_BL(ITA_ANISO_U23,L)
        WRITE(LINE,'(A,A)')
     *  ITA_ATOM_CAT(1:LC),ITA_ANISO_U23(1:L)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) THEN
          IERR=4
          GO TO 1000
        ENDIF
      ENDIF

      RETURN
C -------------------------
 1000 CONTINUE
      IUN = CRO_IUN
      CLOSE(IUN,ERR=1010)
 1010 CONTINUE
      RETURN
      END

      SUBROUTINE COMPARE_ENTITY(MDOC,IG1,IG2,IFLAG,IERR)
C -------------------------------------------------------
C -P- IFLAG = 1 edentical
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,IFLAG,IG1,IG2
C ******
      CHARACTER LINE*256
      CHARACTER RNUM1*5,GROUP1*4,CHAIN1*4,RNUMB1*8
     * ,SYMM11*8,SYMM21*8,LINK1*8
      CHARACTER RNUM2*5,GROUP2*4,CHAIN2*4,RNUMB2*8
     * ,SYMM12*8,SYMM22*8,LINK2*8
C     CHARACTER RNAME1*8,RNUMF1*8,MOD1*8,TYPE1*8
C     CHARACTER RNAME2*8,RNUMF2*8,MOD2*8,TYPE2*8
C -----------------------------------------------
      INCLUDE 'atom_com.fh'
C ------------------------------------------------------------
      IERR  = 0
      IFLAG = 0

      IF(N_GROUP.LE.0) RETURN
      IF(IG1.LE.0.OR.IG1.GT.N_GROUP) RETURN
      IF(IG2.LE.0.OR.IG2.GT.N_GROUP) RETURN
      IF(IG1.EQ.IG2) THEN
        IFLAG = 1
        RETURN
      ENDIF

C      write(*,*) '---comp',ig1,ig2

      IAR1       = IATOM_FIRST(IG1)
      IRP1       = I_RESID(IAR1)
      ICH1       = I_CHAIN(IRP1)
      IRS1       = IRES_FIRST(ICH1)
      NRES1      = NRES_CHAIN(ICH1)
      IRST1      = IRES_START_TREE(IG1)
      IRET1      = IRES_END_TREE(IG1)
      ITYPES1    = ITERM_S_TYPE(IG1)
      ITYPEF1    = ITERM_F_TYPE(IG1)

      GROUP1      = GROUP_ID(IG1)
      CHAIN1      = CHAIN_ID(IG1)

      IAR2       = IATOM_FIRST(IG2)
      IRP2       = I_RESID(IAR2)
      ICH2       = I_CHAIN(IRP2)
      IRS2       = IRES_FIRST(ICH2)
      NRES2      = NRES_CHAIN(ICH2)
      IRST2      = IRES_START_TREE(IG2)
      IRET2      = IRES_END_TREE(IG2)
      ITYPES2    = ITERM_S_TYPE(IG2)
      ITYPEF2    = ITERM_F_TYPE(IG2)

      GROUP2     = GROUP_ID(IG2)
      CHAIN2     = CHAIN_ID(IG2)

C      write(*,*) ICH_TYPE(ICH1),ICH_TYPE(ICH2)
C      write(*,*) NRES1,NRES2
C      write(*,*) ITYPES1,ITYPES2,ITYPEF1,ITYPEF2


      IF(ICH_TYPE(ICH1).NE.ICH_TYPE(ICH2)) RETURN
      IF(NRES1         .NE.NRES2         ) RETURN
      IF(ITYPES1       .NE.ITYPES2       ) RETURN
      IF(ITYPEF1       .NE.ITYPEF2       ) RETURN

      DO IR=1,NRES1
        IR1 = IRS1 + IR -1
        IR2 = IRS2 + IR -1 

C        write(*,*) '-n',RES_NAME(IR1),RES_NAME(IR2)

        IF(RES_NAME(IR1).NE.RES_NAME(IR2)) RETURN
        RNUM1     = RES_NUM_PDB(IR1)(3:7)
        RNUM2     = RES_NUM_PDB(IR2)(3:7)

C        write(*,*) '-r',RNUM1,RNUM2

        IF(RNUM1.NE.RNUM2) RETURN
        ITYPE1 = ICONN_TYPE(IR1)
        ITYPE2 = ICONN_TYPE(IR2)

C        write(*,*) '-t',ITYPE1,ITYPE2

        IF(ITYPE1.NE.ITYPE2) RETURN
        IRBS1  = IRES_BACK(IR1)
        RNUMB1 = ' '
        IF(IRBS1.GT.0) RNUMB1 = RES_NUM_PDB(IRBS1)(3:7)
C        RNUMB1 = RES_NUM_PDB(IRBS1)(3:7)
        IRBS2  = IRES_BACK(IR2)
C        RNUMB2 = RES_NUM_PDB(IRBS2)(3:7)
        RNUMB2 = ' '
        IF(IRBS2.GT.0) RNUMB2 = RES_NUM_PDB(IRBS2)(3:7)

C        write(*,*) '-b',RNUMb1,RNUMb2

        IF(RNUMB1.NE.RNUMB2) RETURN

c        IRFS1  = IRES_FORW(IR1)
c        RNUMF1 = RES_NUM_PDB(IRFS1)(3:7)
c        IRFS2  = IRES_FORW(IR2)
c        RNUMF2 = RES_NUM_PDB(IRFS2)(3:7)
c
C        write(*,*) '-b',RNUMf1,RNUMf2
c
c        IF(RNUMF1.NE.RNUMF2) RETURN

      ENDDO

      IFLAG = 1

C      write(*,*) '===f',iflag

C     additional links
C ----------non-default link ---
      IF(LN_N.GT.1) THEN
        DO ILN=1,LN_N

c             write(*,*) '--ln',iln,LN_ID(iLN),LN_1ICHN(ILN)

          IF(LN_ID(ILN)(1:1).NE.'?'.AND.
     *       LN_ID(ILN)(1:1).NE.'.'     ) THEN
C     *                             .AND.LN_USED(ILN).NE.'S') THEN
            IF((LN_1ICHN(ILN).EQ.LN_2ICHN(ILN)).AND.
     *         (LN_1ICHN(ILN).EQ.IG1          )     ) THEN
              SYMM11 = LN_SYMM1(ILN)
              SYMM21 = LN_SYMM2(ILN)
              IF((SYMM11.EQ.'.'.OR.SYMM11.EQ.'1_555').AND.
     *           (SYMM21.EQ.'.'.OR.SYMM21.EQ.'1_555')     ) THEN
                LINK1 = LN_ID(ILN)
                CALL SET_ICONN(LINK1,ICONNS1)

c              write(*,*) '----conn',ICONNS1

                IF(ICONNS1.GT.2.AND.ICONNS1.LE.N_CONN_TYPE.AND.
     *             ICONNS1.NE.4) THEN
c     *             ICONNS1.NE.4.AND.ICONNS1.NE.36  ) THEN

C                 gap - ICONN=10 , cis - ICONN=3

                  IR1    = LN_1IRES(ILN)
                  IR2    = LN_2IRES(ILN)
                  RNUM1  = RES_NUM_PDB(IR2)(3:7)
                  RNUMB1 = RES_NUM_PDB(IR1)(3:7)
C--                 
                  DO JLN=1,LN_N

c             write(*,*) '----jln',jln,LN_ID(JLN),LN_ID(JLN)

                    IF(LN_ID(JLN)(1:1).NE.'?'.AND.
     *                 LN_ID(JLN)(1:1).NE.'.'     ) THEN    
c     *                 LN_USED(JLN).NE.'S'        ) THEN
                     IF((LN_1ICHN(JLN).EQ.LN_2ICHN(JLN)).AND.
     *                   (LN_1ICHN(JLN).EQ.IG2          )     ) THEN
                        SYMM12 = LN_SYMM1(JLN)
                        SYMM22 = LN_SYMM2(JLN)
                        IF((SYMM12.EQ.'.'.OR.SYMM12.EQ.'1_555').AND.
     *                     (SYMM22.EQ.'.'.OR.SYMM22.EQ.'1_555') ) THEN
                          LINK2 = LN_ID(JLN)
                          CALL SET_ICONN(LINK2,ICONNS2)

                           IF(ICONNS2.GT.2.AND.ICONNS2.LE.N_CONN_TYPE
     *                        .AND.ICONNS2.NE.4) 
     *                                                              THEN
c     *                        .AND.ICONNS2.NE.4.AND.ICONNS2.NE.36  ) 
c     *                                                              THEN
C                           gap - ICONN=10 , cis - ICONN=3

                            IR1    = LN_1IRES(JLN)
                            IR2    = LN_2IRES(JLN)
                            RNUM2  = RES_NUM_PDB(IR2)(3:7)
                            RNUMB2 = RES_NUM_PDB(IR1)(3:7)

c               write(*,*) '---rrr',RNUM1,RNUM2,ICONNS1,ICONNS2                
c     *                            ,RNUMB1,RNUMB2

                            IF((LINK1.EQ.LINK2)    .AND.
     *                         (RNUM1.EQ.RNUM2)    .AND.
     *                         (ICONNS1.EQ.ICONNS2).AND.
     *                         (RNUMB1.EQ.RNUMB2)      ) THEN


c               write(*,*) '---us',LN_USED(ILN),LN_USED(JLN)                

                              IF(LN_USED(ILN).NE.'S'.AND.
     *                           LN_USED(JLN).NE.'S') THEN
                                GO TO 200
                              ENDIF
c                              GO TO 200

                            ENDIF

                          ENDIF
                        ENDIF
                      ENDIF
                    ENDIF
                  ENDDO
                  IFLAG = 0
                  GO TO 100
 200              CONTINUE
C --
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDDO
      ENDIF
C ---------------------------
 100  CONTINUE
      RETURN
      END   

      SUBROUTINE COPY_USED_FLAG(MDOC,IG1,IG2,IERR)
C -------------------------------------------------------
C -P- IG1 --> IG2
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,IG1,IG2
C     INTEGER*4 IFLAG
C ******
C     CHARACTER LINE*256
      CHARACTER RNUM1*5,GROUP1*4,CHAIN1*4,RNUMB1*8
     * ,SYMM11*8,SYMM21*8,LINK1*8
      CHARACTER RNUM2*5,GROUP2*4,CHAIN2*4,RNUMB2*8
     * ,SYMM12*8,SYMM22*8,LINK2*8
C     CHARACTER RNAME1*8,RNUMF1*8,MOD1*8,TYPE1*8
C     CHARACTER RNAME2*8,RNUMF2*8,MOD1*8,TYPE2*8
C -----------------------------------------------
      INCLUDE 'atom_com.fh'
C ------------------------------------------------------------
      IERR = 0
      IF(IG1.LE.0.OR.IG1.GT.N_GROUP) RETURN
      IF(IG2.LE.0.OR.IG2.GT.N_GROUP) RETURN
      IF(IG1.EQ.IG2) THEN
        RETURN
      ENDIF

      IAR1       = IATOM_FIRST(IG1)
      IRP1       = I_RESID(IAR1)
      ICH1       = I_CHAIN(IRP1)
      IRS1       = IRES_FIRST(ICH1)
      NRES1      = NRES_CHAIN(ICH1)
      IRST1      = IRES_START_TREE(IG1)
      IRET1      = IRES_END_TREE(IG1)
      ITYPES1    = ITERM_S_TYPE(IG1)
      ITYPEF1    = ITERM_F_TYPE(IG1)

      GROUP1      = GROUP_ID(IG1)
      CHAIN1      = CHAIN_ID(IG1)

      IAR2       = IATOM_FIRST(IG2)
      IRP2       = I_RESID(IAR2)
      ICH2       = I_CHAIN(IRP2)
      IRS2       = IRES_FIRST(ICH2)
      NRES2      = NRES_CHAIN(ICH2)
      IRST2      = IRES_START_TREE(IG2)
      IRET2      = IRES_END_TREE(IG2)
      ITYPES2    = ITERM_S_TYPE(IG2)
      ITYPEF2    = ITERM_F_TYPE(IG2)

      GROUP2     = GROUP_ID(IG2)
      CHAIN2     = CHAIN_ID(IG2)


C     additional links
C ----------non-default link ---
      IF(LN_N.GT.1) THEN
        DO ILN=1,LN_N

c             write(*,*) '--ln',iln,LN_ID(iLN),LN_1ICHN(ILN)

          IF(LN_ID(ILN)(1:1).NE.'?'.AND.LN_ID(ILN)(1:1).NE.'.'
     *                             .AND.LN_USED(ILN).NE.'S') THEN
            IF((LN_1ICHN(ILN).EQ.LN_2ICHN(ILN)).AND.
     *         (LN_1ICHN(ILN).EQ.IG1          )     ) THEN
              SYMM11 = LN_SYMM1(ILN)
              SYMM21 = LN_SYMM2(ILN)

              IF((SYMM11.EQ.'.'.OR.SYMM11.EQ.'1_555').AND.
     *           (SYMM21.EQ.'.'.OR.SYMM21.EQ.'1_555')     ) THEN
 
                LINK1 = LN_ID(ILN)
                CALL SET_ICONN(LINK1,ICONNS1)

                IF(ICONNS1.GT.2.AND.ICONNS1.LE.N_CONN_TYPE
     *                                   .AND.ICONNS1.NE.4) THEN

                  IR1    = LN_1IRES(ILN)
                  IR2    = LN_2IRES(ILN)
                  RNUM1  = RES_NUM_PDB(IR2)(3:7)
                  RNUMB1 = RES_NUM_PDB(IR1)(3:7)
C--                 
                  DO JLN=1,LN_N

c             write(*,*) '----jln',jln,LN_ID(JLN),LN_ID(JLN)

                    IF(LN_ID(JLN)(1:1).NE.'?'.AND.
     *                 LN_ID(JLN)(1:1).NE.'.'.AND.
     *                 LN_USED(JLN).NE.'S'        ) THEN
                      IF((LN_1ICHN(JLN).EQ.LN_2ICHN(JLN)).AND.
     *                   (LN_1ICHN(JLN).EQ.IG2          )     ) THEN
                        SYMM12 = LN_SYMM1(JLN)
                        SYMM22 = LN_SYMM2(JLN)
                        IF((SYMM12.EQ.'.'.OR.SYMM12.EQ.'1_555').AND.
     *                     (SYMM22.EQ.'.'.OR.SYMM22.EQ.'1_555') ) THEN
                          LINK2 = LN_ID(JLN)
                          CALL SET_ICONN(LINK2,ICONNS2)
                          IF(ICONNS2.GT.2.AND.ICONNS2.LE.
     *                           N_CONN_TYPE.AND.ICONNS2.NE.4) THEN


                            IR1    = LN_1IRES(JLN)
                            IR2    = LN_2IRES(JLN)
                            RNUM2  = RES_NUM_PDB(IR2)(3:7)
                            RNUMB2 = RES_NUM_PDB(IR1)(3:7)

c               write(*,*) '---rrr',RNUM1,RNUM2,ICONNS1,ICONNS2                
c     *                            ,RNUMB1,RNUMB2

                            IF((LINK1.EQ.LINK2)    .AND.
     *                         (RNUM1.EQ.RNUM2)    .AND.
     *                         (ICONNS1.EQ.ICONNS2).AND.
     *                         (RNUMB1.EQ.RNUMB2)      ) THEN

                              LN_ENT(JLN)  = LN_ENT(ILN)
                              LN_USED(JLN) = LN_USED(ILN)

c                     write(*,*) '--copy',LN_ENT(ILN),'-->',LN_ENT(JLN)

                            ENDIF

                          ENDIF

                        ENDIF
                      ENDIF
                    ENDIF
                  ENDDO

 200              CONTINUE
C --
              ENDIF

              ENDIF
            ENDIF
          ENDIF
        ENDDO
      ENDIF
C ---------------------------
 100  CONTINUE
      RETURN
      END

      SUBROUTINE COPY_ENTITY_TREE(MDOC,IERR)
C -------------------------------------------------------
C -P- 
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
C ******
C     CHARACTER LINE*256
      CHARACTER RNUM*5,RNUME*5,LIST*1
C -----------------------------------------------
      INCLUDE 'atom_com.fh'
C ------------------------------------------------------------
      IERR = 0
      LIST = ' '

      IF(N_GROUP.LE.0) RETURN

      IF(N_CHN_ENT.LE.0.OR.N_GRP_ASM.LE.0) THEN
        CALL CREAT_ENT_DESCR(MDOC,LIST,IERR)
        RETURN
      ENDIF
C ----
      DO IE=1,N_CHN_ENT   

        IF(ENT_NRES_CHAIN(IE).GT.0) THEN 

          IRS       = ENT_IRES_FIRST     (IE)
          NRES      = ENT_NRES_CHAIN     (IE)
          IRF       = IRS + NRES - 1

          DO IRE=IRS,IRF

            RNUM      = ENT_RES_AUTH_NUM(IRE)

            IF(ENT_RES_START_TREE(IE).EQ.RNUM) 
     *           ENT_IRES_START_TREE(IE) = IRE 
            IF(ENT_RES_END_TREE(IE).EQ.RNUM) 
     *           ENT_IRES_END_TREE(IE) = IRE 

            DO JRE=IRS,IRF
              IF(ENT_RES_AUTH_BNUM(JRE).EQ.RNUM) 
     *           ENT_IRES_BACK(JRE) = IRE 
            ENDDO

            IF(ENT_LN_N.GT.0) THEN
              DO IL=1,ENT_LN_N
                IF(ENT_LN_AUTH_NUM1(IL).EQ.RNUM) THEN
                  ENT_LN_1RNAM(IL) = ENT_RES_NAME(IRE)
                  ENT_LN_1IRES(IL) = IRE
                ENDIF           
                IF(ENT_LN_AUTH_NUM2(IL).EQ.RNUM) THEN
                  ENT_LN_2RNAM(IL) = ENT_RES_NAME(IRE)
                  ENT_LN_2IRES(IL) = IRE
                ENDIF           
              ENDDO
            ENDIF

          ENDDO
C --
          ISTART  = ENT_IRES_START_TREE(IE)
          IFINISH = ENT_IRES_END_TREE  (IE)

C --
          CALL CHECK_TREE_CRD(MDOC,NRES,ISTART,IFINISH,IRS,IRF
     *       ,ENT_IRES_BACK,ENT_IRES_FORW,ENT_ICONN_TYPE,IERR)  

C --
          ENT_IRES_START_TREE(IE) = ISTART
          ENT_IRES_END_TREE  (IE) = IFINISH

          ENT_RES_START_TREE (IE) = ENT_RES_AUTH_NUM(ISTART)
          ENT_RES_END_TREE   (IE) = ENT_RES_AUTH_NUM(IFINISH)

        ENDIF
      ENDDO
C ------------------------
      DO IG=1,N_GROUP
   
        IASM = IGROUP_ASM(IG)

        IF(IASM.GT.0.AND.IASM.LE.N_GRP_ASM) THEN

          IE = ASM_CHAIN_POINTER(IASM)

          IF(IE.GT.0.AND.ENT_NRES_CHAIN(IE).GT.1) THEN
C ===
            IRSE  = ENT_IRES_FIRST(IE)
            NRESE = ENT_NRES_CHAIN(IE)
            IRFE  = IRSE + NRESE -1

            IRS  = IRES_FIRST(IG)
            NRES = NRES_CHAIN(IG)
            IRF  = IRS  + NRES -1

            ICH_TYPE(IG) = ENT_ICHAIN_TYPE(IE)  

            IRES_START_TREE(IG) = 0 
            IRES_END_TREE  (IG) = 0
            ITERM_S_TYPE   (IG) = 7
            ITERM_F_TYPE   (IG) = 7

            DO IR=IRS,IRF
              RNUM = RES_NUM_PDB(IR)(3:7)
C             set - start,end,type
C
C             chain type: 
c
              IF(RNUM.EQ.ENT_RES_START_TREE(IE)) THEN
                IRES_START_TREE(IG) = IR
                ITERM_S_TYPE   (IG) = ENT_ITERM_S_TYPE(IE)
              ENDIF
              IF(RNUM.EQ.ENT_RES_END_TREE(IE)) THEN
                IRES_END_TREE(IG) = IR
                ITERM_F_TYPE (IG) = ENT_ITERM_F_TYPE(IE)
C
C             if 'polypept' : ICH_TYPE(IG) = 3 or 4 or 10
C                 , check OXT atom
C
C        IAS    = IRATM_FIRST   (I)
C        IAF    = IRATM_FIRST(I)+NATM_RES(I)-1
C             
C             if yes ITERM_F_TYPE (IG) = ENT_ITERM_F_TYPE(IE) = 
C
              ENDIF
C             init tree 

              IRES_BACK (IR) = 0  
              IRES_FORW (IR) = 0
              ICONN_TYPE(IR) = 10

            ENDDO
C ---
            DO IR=IRS,IRF
              RNUM = RES_NUM_PDB(IR)(3:7)
              DO IRE=IRSE,IRFE
                RNUME = ENT_RES_AUTH_NUM(IRE)
                IF(RNUME.EQ.RNUM) THEN
                  ICONN_TYPE(IR) = ENT_ICONN_TYPE(IRE)
                  IRBE           = ENT_IRES_BACK(IRE)  
                  IF(IRBE.GT.0) THEN
                    IRES_BACK (IR) = IRS + IRBE - IRSE 
                  ELSE
                    IRES_BACK (IR) = 0
                  ENDIF
                  GO TO 100
                ENDIF
              ENDDO
 100          CONTINUE

            ENDDO
C --
            ISTART  = IRES_START_TREE(IG)
            IFINISH = IRES_END_TREE  (IG)
C --
            CALL CHECK_TREE_CRD(MDOC,NRES,ISTART,IFINISH,IRS,IRF
     *        ,IRES_BACK,IRES_FORW,ICONN_TYPE,IERR)  
C --
            IRES_START_TREE(IG) = ISTART 
            IRES_END_TREE  (IG) = IFINISH
C ===
          ENDIF
        ENDIF
      ENDDO
C ------------------------
      CALL CHECK_TERMINUS(MDOC,IERR)
C ------------------------
      RETURN
      END

      SUBROUTINE CHECK_TREE_CRD(MDOC,NRES,ISTART,IFINISH,IRS,IRF
     *        ,IBACK,IFORW,ITYPE,IERR)  
C -------------------------------------------------------
C -P- 
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,NRES,ISTART,IFINISH
      INTEGER*4 IBACK(*),IFORW(*),ITYPE(*)
C     CHARACTER LINE*256
C ----------------------------
      IERR = 0
      IGAP = 10
C -
      DO I=IRS,IRF
        IFORW(I) = -1
      ENDDO

      DO I=IRS,IRF
        J   = I
 100    JB = IBACK(J)
        IF(JB.GT.0) THEN
          IFORW(JB) = 0
          JBB       = IBACK(JB)         
          IF(JBB.EQ.I) THEN
            IBACK(JB) = 0
            ITYPE(JB) = IGAP
            GO TO 200 
          ENDIF
          J = JB
          GO TO 100
        ENDIF

 200    CONTINUE

      ENDDO
C ---
      IF(ISTART.GT.0) THEN
        IF(IBACK(ISTART).GT.0) ISTART = 0
      ELSE
        ISTART = 0
      ENDIF
      IF(IFINISH.GT.0) THEN
        IF(IFORW(IFINISH).GT.0) IFINISH = 0
      ELSE
        IFINISH = 0
      ENDIF
C ---
      IF(IFINISH.GT.0) THEN
        I  = IFINISH
 300    IB = IBACK(I)
        IF(IB.GT.0) THEN
          I = IB
          GO TO 300
        ENDIF
        IS = I  
      ELSE
        IS = 0
      ENDIF

      DO I=IRS,IRF

        IF(IFORW(I).LT.0.AND.I.NE.IFINISH) THEN
          J  = I
 400      JB = IBACK(J)
          IF(JB.GT.0) THEN
            J = JB
            GO TO 400
          ENDIF
          IF(IS.GT.0.AND.J.NE.IS) THEN
            IF(J.EQ.ISTART) THEN
              IBACK(IS) = I
              IS        = J
              ITYPE(IS) = IGAP
            ELSE
              IBACK(J)  = IS
              ITYPE(J)  = IGAP
            ENDIF
          ELSE
            IS = J
          ENDIF
        ENDIF
      ENDDO
C -
      ISTART  = IS
C----

      IFS_OLD = 0

      DO I=IRS,IRF
        IF(IFORW(I).LT.0.AND.I.NE.IFINISH) THEN
          J  = I
 500      JB = IBACK(J)
          IF(JB.GT.0) THEN
            JBF = IFORW(JB)
            IF(JBF.GT.0) THEN
              IF(IFS_OLD.GT.0) THEN
                IFORW(IFS_OLD) = J
              ENDIF
              IFS_OLD = I
            ELSE
              IFORW(JB) = J
              J = JB
              GO TO 500
            ENDIF
          ELSE
            IFS_OLD = I
          ENDIF
        ENDIF
      ENDDO
C -
      IF(IFINISH.GT.0) THEN
        I = IFINISH
        J = I
 600    JB = IBACK(J)
        IF(JB.GT.0) THEN
          JBF = IFORW(JB)
          IF(JBF.GT.0) THEN
            IF(IFS_OLD.GT.0) THEN
              IFORW(IFS_OLD) = J
            ENDIF
            IFS_OLD = I
          ELSE
            IFORW(JB) = J
            J = JB
            GO TO 600
          ENDIF
        ELSE
          IFS_OLD = I
        ENDIF
      ENDIF
C
      IFINISH = IFS_OLD
C ----------------------------
      RETURN
      END

      SUBROUTINE CHECK_TERMINUS(MDOC,IERR)
C -------------------------------------------------------
C -P- 
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
C ******
C     CHARACTER LINE*256
C -----------------------------------------------
      INCLUDE 'atom_com.fh'
C ------------------------------------------------------------
      IERR = 0
      IF(N_GROUP.LE.0) RETURN
C ----
      DO IG=1,N_GROUP
   
        IASM = IGROUP_ASM   (IG)
        ITFT = ITERM_F_TYPE (IG)
C       chain type: 
        ICHT = ICH_TYPE(IG)
        IF(ICHT.EQ.3.OR.ICHT.EQ.4.OR.ICHT.EQ.10) THEN

C         if 'polypept' : ICH_TYPE(IG) = 3 or 4 or 10
C           , check OXT atom
c
          IR   = IRES_END_TREE(IG)
          IAS  = IRATM_FIRST   (IR)
          IAF  = IRATM_FIRST(IR)+NATM_RES(IR)-1
          IOXT = 0
          DO IA=IAS,IAF
            IF(ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN
              IF(ATM_NAME(IA).EQ.'OXT ') IOXT  = 1 
            ENDIF
          ENDDO
C             
C         if 'yes' ITERM_F_TYPE (IG)    =  2
C                  ENT_ITERM_F_TYPE(IE) =  2
C
C         TERM_S_TYPE( 1) = '.       '
C         TERM_S_TYPE( 2) = 'NH3     '
C         TERM_S_TYPE( 3) = 'FOR-N   '
C         TERM_S_TYPE( 4) = 'p5*END  '
C         TERM_S_TYPE( 5) = '5*END   '
C         TERM_S_TYPE( 6) = 'NH3-COO '
C         TERM_S_TYPE( 7) = 'TERMINUS'
C         TERM_S_TYPE( 8) = '        '
C         TERM_S_TYPE( 9) = '        '
C         TERM_S_TYPE(10) = '        '
C
C         TERM_F_TYPE( 1) = '.       '
C         TERM_F_TYPE( 2) = 'COO     '
C         TERM_F_TYPE( 3) = 'FOR-C   '
C         TERM_F_TYPE( 4) = 'p3*END  '
C         TERM_F_TYPE( 5) = '3*END   '
C         TERM_F_TYPE( 6) = 'NH3-COO '
C         TERM_F_TYPE( 7) = 'TERMINUS'
C         TERM_F_TYPE( 8) = 'CM-COO  '
C         TERM_F_TYPE( 9) = '        '
C         TERM_F_TYPE(10) = '        '
C
          IF(IOXT.EQ.1.AND.
     *       (ITFT.EQ.1.OR.ITFT.EQ.2.OR.ITFT.EQ.7)) THEN
            ITERM_F_TYPE (IG)    =  2
            IF(IASM.GT.0.AND.IASM.LE.N_GRP_ASM) THEN
              IE = ASM_CHAIN_POINTER(IASM)
              IF(IE.GT.0) THEN  
                ENT_ITERM_F_TYPE(IE) =  2
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
C ------------------------
      RETURN
      END

      SUBROUTINE WRT_ENTITY_POLY(MDOC,IUN,IFIRST,IERR)
C -------------------------------------------------------
C -P- 
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,IFIRST
C ******
      CHARACTER LINE*256

      CHARACTER RNAME*8,RNUM*5,RNUMB*5,MOD*8
      CHARACTER TYPE*8,TYPES*8,TYPEF*8,CHAIN*4
C     CHARACTER RNUMF*5,LINK*8
C -----------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'CIF_items_crd.fh'
C ------------------------------------------------------------
      IERR = 0
      IF(IUN.EQ.0) THEN
        CALL MSGERR(MDOC,' ERROR: output_CRD_file isn''t open')
        IERR=5
        RETURN
      ENDIF

      IF(N_CHN_ENT.LE.0) RETURN

      DO IE=1,N_CHN_ENT   

        IF(ENT_NRES_CHAIN(IE).GT.0) THEN 

          IRS       = ENT_IRES_FIRST     (IE)
          NRES      = ENT_NRES_CHAIN     (IE)
          IRST      = ENT_IRES_START_TREE(IE)
          IRET      = ENT_IRES_END_TREE  (IE)
          TYPES     = ENT_TERM_S_TYPE    (IE)
          TYPEF     = ENT_TERM_F_TYPE    (IE)
          CHAIN     = ENT_CHAIN_ID(IE)

          IF(IFIRST.EQ.0) THEN
            LINE='#####################'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            LINE='## ENTITY_POLY_SEQ ##'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            LINE='#####################'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            WRITE(LINE,'(''loop_'')')
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_ENTP_MON,L)
            WRITE(LINE,'(A)') ICS_ENTP_MON(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_ENTP_SEQ,L)
            WRITE(LINE,'(A)') ICS_ENTP_SEQ(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_ENTP_ID,L)
            WRITE(LINE,'(A)') ICS_ENTP_ID(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_ENTP_TYPE,L)
            WRITE(LINE,'(A)') ICS_ENTP_TYPE(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_ENTP_BSEQ,L)
            WRITE(LINE,'(A)') ICS_ENTP_BSEQ(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

c            CALL LENSTR_BL(ICS_ENTP_FSEQ,L)
c            WRITE(LINE,'(A)') ICS_ENTP_FSEQ(1:L)
c            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_ENTP_MOD,L)
            WRITE(LINE,'(A)') ICS_ENTP_MOD(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            IFIRST = 1
          ENDIF

          LINE = '# '
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---     tree
          NR       = NRES
          IRS_TREE = IRST
          IRF_TREE = IRET
          IF(NR.LE.0.OR.IRS.LE.0) THEN
            CALL MSGERR(MDOC,' ERROR: N-residues = 0')
            IERR = 1
            RETURN
          ENDIF
          IF(IRS_TREE.LE.0.OR.IRF_TREE.LE.0) THEN
            CALL MSGERR(MDOC,' ERROR: wrong tree structure ....')
            IERR = 1
            RETURN
          ENDIF
          IRF = IRS + NR - 1
          IR  = IRS_TREE         
C -- tree --
C         DO IR=IRS,IRS+NRES-1
 800      CONTINUE  

            RNAME     = ENT_RES_NAME    (IR)
            RNUM      = ENT_RES_AUTH_NUM(IR)

            IRBS      = ENT_IRES_BACK   (IR)
            IF(IRBS.GT.0) THEN
              RNUMB = ENT_RES_AUTH_NUM(IRBS)
            ELSE
              RNUMB = 'n/a'
            ENDIF

c            IRFS      = ENT_IRES_FORW   (IR)
c            IF(IRFS.GT.0) THEN
c              RNUMF = ENT_RES_AUTH_NUM(IRFS)
c            ELSE
c              RNUMF = 'n/a'
c            ENDIF


            ITYPE = ENT_ICONN_TYPE(IR)
            TYPE  = '.'
            IF(ITYPE.GT.0) TYPE = CONN_TYPE(ITYPE)
            CALL LENSTR_BL(TYPE,L)
            IF(L.LE.0.OR.TYPE(1:1).EQ.' ') TYPE = '.'  

            MOD = '.'
            IF(IR.EQ.IRST) THEN
              MOD = ENT_TERM_S_TYPE(IE) 
            ENDIF
            IF(IR.EQ.IRET) THEN
              MOD = ENT_TERM_F_TYPE(IE) 
            ENDIF

            CALL LENSTR_BL(MOD,L)
            IF(L.LE.0.OR.MOD(1:1).EQ.' ') MOD = '.'  

            WRITE(LINE,'('' '',A,1X,A,1X,A,1X,A,1X,A,1X,A)') 
     *                 RNAME,RNUM,CHAIN,TYPE,RNUMB,MOD
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

c            WRITE(LINE,'('' '',A,1X,A,1X,A,1X,A,1X,A,1X,A,1X,A)') 
c     *                 RNAME,RNUM,CHAIN,TYPE,RNUMB,RNUMF,MOD
c            CALL WRTSTR(IUN,MDOC,LINE,IERR)


C         ENDDO
C --- tree --
          IF(IR.NE.IRF_TREE) THEN
            IR = ENT_IRES_FORW(IR)
            IF(IR.LE.0.OR.IR.LT.IRS.OR.IR.GT.IRF) THEN
              CALL MSGERR(MDOC,' ERROR: wrong tree structure .....')
              IERR = 1
              RETURN
            ENDIF
            GO TO 800
          ENDIF
C --- tree --

        ENDIF
      ENDDO

      RETURN
      END


      SUBROUTINE WRT_ENTITY_LINK(MDOC,IUN,IFIRST,IERR)
C -------------------------------------------------------
C -P- 
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,IFIRST
C ******
      CHARACTER LINE*256

      REAL      DIST
      CHARACTER RNAME1*8,RNAME2*8,RNUM1*5,RNUM2*5,ATOM1*6,ATOM2*6
      CHARACTER CHAIN*4,LINK*8,LDIST*8
C -----------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'CIF_items_crd.fh'
C ------------------------------------------------------------
      IERR = 0
      IF(IUN.EQ.0) THEN
        CALL MSGERR(MDOC,' ERROR: output_CRD_file isn''t open')
        IERR=5
        RETURN
      ENDIF

      IF(N_CHN_ENT.LE.0) RETURN
      IF(ENT_LN_N .LE.0) RETURN

      N = 0
      DO IL=1,ENT_LN_N   
        LINK = ENT_LN_ID(IL) 
        CALL LENSTR_BL(LINK,L)
        IF(L.GT.0.AND.LINK(1:1).NE.'.'.AND.LINK(1:1).NE.'?'.AND.
     *   (ENT_LN_USED(IL).EQ.'L'.OR.ENT_LN_USED(IL).EQ.'e')) THEN 
          N = N + 1
        ENDIF
      ENDDO
      IF(N.LE.0) RETURN

      DO IL=1,ENT_LN_N   

        LINK = ENT_LN_ID(IL) 
        CALL LENSTR_BL(LINK,L)

        IF(L.GT.0.AND.LINK(1:1).NE.'.'.AND.LINK(1:1).NE.'?'.AND.
     *   (ENT_LN_USED(IL).EQ.'L'.OR.ENT_LN_USED(IL).EQ.'e')) THEN 

          ICHAIN = ENT_LN_ICHAIN(IL)
          CHAIN  = ENT_CHAIN_ID(ICHAIN)

          RNAME1 = ENT_LN_1RNAM (IL)  
          RNAME2 = ENT_LN_2RNAM (IL) 

          ATOM1  = ENT_LN_ATOM1 (IL)  
          ATOM2  = ENT_LN_ATOM2 (IL) 
          CALL CORR_NAME_CIF_OUT(ATOM1)
          CALL CORR_NAME_CIF_OUT(ATOM2)

          RNUM1  =  ENT_LN_AUTH_NUM1(IL)  
          RNUM2  =  ENT_LN_AUTH_NUM2(IL)  

          DIST   = ENT_LN_DIST(IL) 
          IF(DIST.LT.0.001.OR.DIST.GE.10000.0) THEN
            LDIST = '.'
          ELSE
            WRITE(LDIST,'(F8.3)') DIST
          ENDIF

          IF(IFIRST.EQ.0) THEN
            LINE='#################'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            LINE='## ENTITY_LINK ##'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            LINE='#################'
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            WRITE(LINE,'(''loop_'')')
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_LINK_ID,L)
            WRITE(LINE,'(A)') ICS_LINK_ID(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_LINK_ENT,L)
            WRITE(LINE,'(A)') ICS_LINK_ENT(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_LINK_MON1,L)
            WRITE(LINE,'(A)') ICS_LINK_MON1(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_LINK_NUM1,L)
            WRITE(LINE,'(A)') ICS_LINK_NUM1(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_LINK_ATM1,L)
            WRITE(LINE,'(A)') ICS_LINK_ATM1(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_LINK_MON2,L)
            WRITE(LINE,'(A)') ICS_LINK_MON2(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_LINK_NUM2,L)
            WRITE(LINE,'(A)') ICS_LINK_NUM2(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_LINK_ATM2,L)
            WRITE(LINE,'(A)') ICS_LINK_ATM2(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            CALL LENSTR_BL(ICS_LINK_DIST,L)
            WRITE(LINE,'(A)') ICS_LINK_DIST(1:L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            IFIRST = 1
          ENDIF

          WRITE(LINE,
     * '(A,A,1X,A,1X, A,1X,A,1X,A,1X, A,1X,A,1X,A,1X,A)') 
     *    ' ',LINK,CHAIN,RNAME1,RNUM1,ATOM1,RNAME2,RNUM2,ATOM2,LDIST
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

        ENDIF
      ENDDO

      RETURN
      END

      SUBROUTINE CREAT_ENT_DESCR(MDOC,LIST,IERR)
C ----------------------------------------------------------------------------
C -P- 
C -S-
C ----------------------------------------------------------------------------
      INTEGER*4 MDOC,IERR
C ------------------------
C     CHARACTER LINE*256
      CHARACTER RNAME*8,RNUM*5,GROUP*4,CHAIN*4,RNUMF*8,RNUMB*8
      CHARACTER SYMM1*8,SYMM2*8,LINK*8
      CHARACTER CHTYPE*16,LIST*1
C     CHARACTER RNAMN*8,MOD*8,TYPE*8
C -----------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'CIF_items_crd.fh'
C ------------------------------------------------------------
      M     = 99
      IERR  = 0
C ------------------------------------------------------------
C --- _entity.
C
      IF(LIST.EQ.'T') THEN
      write(*,*) '-CREAT_ENT-',LN_N
      do i=1,LN_N
      write(*,*) '-C-'
     * ,i,LN_ID(I),LN_USED(I),LN_ENT(i)
      write(*,*) '   '
     * ,LN_1ICHN(i),LN_1IRES(i),LN_2ICHN(i),LN_2IRES(i)
      ir1 = LN_1IRES(i)
      ir2 = LN_2IRES(i)
      write(*,*) '    '
     * ,RES_NUM_PDB(Ir1)(3:7),RES_NAME(Ir1),RES_NUM_PDB(Ir2)(3:7)
     * ,RES_NAME(Ir2),LN_ATOM1(i),LN_ATOM2(I),LN_ALT1(I),LN_ALT2(I)
      enddo
      ENDIF

      N_CHN_ENT    = 0
      N_GRP_ASM    = 0
      ENT_NRESIDUE = 0
      ENT_LN_N     = 0

      IF(LN_N.GT.0) THEN
        DO ILN=1,LN_N
          LN_ENT(ILN) = 'C'
         ENDDO
      ENDIF

      IF(N_GROUP.GT.0) THEN

        IF(LIST.EQ.'T') THEN
          write(*,*) '--ngroup',N_GROUP
        ENDIF

        DO  IG=1,N_GROUP

          CHAIN_ID(IG) = GROUP_ID(IG)

          CHTYPE = '.'
          CHAIN  = CHAIN_ID(IG)
          IF(ICH_TYPE(IG).EQ. 2) THEN
            IR          = IRES_FIRST(IG)
            CHTYPE      = 'non-polymer'
            CHAIN       = RES_NAME(IR)(1:3)
          ELSE IF(ICH_TYPE(IG).EQ. 9) THEN
            CHAIN       = 'HOH'
            CHTYPE      = 'water'
          ELSE IF(ICH_TYPE(IG).EQ.10) THEN
            CHTYPE      = 'polymer'
          ELSE IF(ICH_TYPE(IG).EQ.7.OR.ICH_TYPE(IG).EQ.8) THEN
            CHTYPE      = 'polysaccharide'
          ELSE IF(ICH_TYPE(IG).EQ.5.OR.ICH_TYPE(IG).EQ.6) THEN
            CHTYPE      = 'DNA/RNA'
          ELSE IF(ICH_TYPE(IG).EQ.3.OR.ICH_TYPE(IG).EQ.4) THEN
            CHTYPE      = 'polypeptide'
          ENDIF

          IF(LIST.EQ.'T') THEN
            write(*,*) '--ig,ient',ig,n_chn_ent,CHTYPE
     *      ,ITERM_S_TYPE(Ig),ITERM_F_TYPE(Ig)
          ENDIF

          N_GRP_ASM               = N_GRP_ASM + 1 
          IASM                    = N_GRP_ASM 
          ASM_GROUP_ID     (IASM) = GROUP_ID(IG)
          ASM_GROUP_POINTER(IASM) = IG
          ASM_CHAIN_ID     (IASM) = CHAIN_ID(IG)
          ASM_CHAIN_POINTER(IASM) = 0 

          IF(N_CHN_ENT.GE.1) THEN
            DO J=1,N_CHN_ENT
              IENT = J

              IF(LIST.EQ.'T') THEN
                write(*,*) '--1',CHAIN,ENT_CHAIN_ID(IENT)
              ENDIF

              IF(CHAIN.EQ.ENT_CHAIN_ID(IENT)) THEN
                IGROUP_ASM(IG)          = IASM
                CHAIN_ID  (IG)          = ASM_CHAIN_ID(IASM)
                ASM_CHAIN_POINTER(IASM) = IENT 
                ASM_CHAIN_ID(IASM)      = ENT_CHAIN_ID(IENT)
               
                IF(LIST.EQ.'T') THEN
                  write(*,*) '--2:',IGROUP_ASM(IG),CHAIN_ID(IG)
                ENDIF

                GO TO 100
              ENDIF
              IF(ICH_TYPE(IG).NE.9) THEN
                K = ENT_IGROUP_FIRST(IENT)
                CALL COMPARE_ENTITY(MDOC,IG,K,IFLAG,IERR)

                IF(LIST.EQ.'T') THEN
                  WRITE(*,*) '--FLAG',IFLAG
                ENDIF

                IF(IFLAG.EQ.1) THEN
                  IGROUP_ASM(IG)          = IASM
                  ASM_CHAIN_ID(IASM)      = ENT_CHAIN_ID(IENT)
                  CHAIN_ID  (IG)          = ENT_CHAIN_ID(IENT)
                  ASM_CHAIN_POINTER(IASM) = IENT 
               
                  IF(LIST.EQ.'T') THEN
                    write(*,*) '--3:',IGROUP_ASM(IG),CHAIN_ID(IG)
                  ENDIF

                  CALL COPY_USED_FLAG(MDOC,K,IG,IERR)

                  GO TO 100
                ENDIF
              ENDIF
            ENDDO
          ENDIF

          N_CHN_ENT = N_CHN_ENT + 1
          IENT      = N_CHN_ENT

          ENT_NRES_CHAIN     (N_CHN_ENT) = 0  
          ENT_IGROUP_FIRST   (N_CHN_ENT) = IG
          ENT_IRES_FIRST     (N_CHN_ENT) = 0
          ENT_IRES_START_TREE(N_CHN_ENT) = 0   
          ENT_IRES_END_TREE  (N_CHN_ENT) = 0   
          ENT_ITERM_S_TYPE   (N_CHN_ENT) = 1   
          ENT_ITERM_F_TYPE   (N_CHN_ENT) = 1  
          ENT_ICHAIN_TYPE    (N_CHN_ENT) = ICH_TYPE(IG)

          ENT_RES_START_TREE (N_CHN_ENT) = '.'
          ENT_RES_END_TREE   (N_CHN_ENT) = '.'
          ENT_TERM_S_TYPE    (N_CHN_ENT) = '.'
          ENT_TERM_F_TYPE    (N_CHN_ENT) = '.'
          ENT_CHAIN_ID       (N_CHN_ENT) = CHAIN
          ENT_CHAIN_TYPE     (N_CHN_ENT) = CHTYPE

          IGROUP_ASM(IG)          = IASM
          CHAIN_ID  (IG)          = ENT_CHAIN_ID(IENT)
          ASM_CHAIN_POINTER(IASM) = IENT 
          ASM_CHAIN_ID(IASM)      = ENT_CHAIN_ID(IENT)

          IF(ICH_TYPE(IG).LE.2.OR.ICH_TYPE(IG).EQ.9) GO TO 100

C --------------------------------------------
C     entity_poly
C
          IRS       = IRES_FIRST     (IG)
          NRES      = NRES_CHAIN     (IG)
          IRST      = IRES_START_TREE(IG)
          IRET      = IRES_END_TREE  (IG)
          ITYPES    = ITERM_S_TYPE   (IG)
          IF(ITYPES.LE.1) ITYPES = 7
          ITYPEF    = ITERM_F_TYPE   (IG)

          IF(ITYPEF.LE.1) ITYPEF = 7

          GROUP     = GROUP_ID(IG)
          CHAIN     = CHAIN_ID(IG)

          ENT_NRES_CHAIN     (N_CHN_ENT) = NRES  
          ENT_IRES_FIRST     (N_CHN_ENT) = ENT_NRESIDUE + 1
          IRESF_ENT                      = ENT_NRESIDUE + 1
          ENT_IRES_START_TREE(N_CHN_ENT) = IRST - IRS +  IRESF_ENT    
          ENT_IRES_END_TREE  (N_CHN_ENT) = IRET - IRS +  IRESF_ENT  
          ENT_ITERM_S_TYPE   (N_CHN_ENT) = ITYPES   
          ENT_ITERM_F_TYPE   (N_CHN_ENT) = ITYPEF   
          ENT_TERM_S_TYPE    (N_CHN_ENT) = TERM_S_TYPE(ITYPES)
          ENT_TERM_F_TYPE    (N_CHN_ENT) = TERM_F_TYPE(ITYPEF)

          NR       = ENT_NRES_CHAIN     (N_CHN_ENT)
          IRS_TREE = ENT_IRES_START_TREE(N_CHN_ENT)
          IRF_TREE = ENT_IRES_END_TREE  (N_CHN_ENT)
c
          IRS_E     = ENT_IRES_FIRST(N_CHN_ENT)

          IF(NRES.LE.0.OR.IRS.LE.0) THEN
            CALL MSGERR(MDOC,' ERROR: N-residues = 0')
            IERR = 1
            RETURN
          ENDIF
          IF(IRST.LE.0.OR.IRET.LE.0) THEN
            CALL MSGERR(MDOC,
     *      ' ERROR: wrong tree structure ...(in creat_ent_descr)')
            IERR = 1
            RETURN
          ENDIF

          IRF = IRS + NRES - 1

          IR  = IRST         
               
c 800      CONTINUE  
C -- tree --
          DO IR=IRS,IRS+NRES-1

            IF(LIST.EQ.'T') THEN
              WRITE(*,*) '-R-',IR,RES_NAME(IR)
     *        ,ICONN_TYPE(IR),RES_NUM_PDB(IR)
            ENDIF
 
            ENT_NRESIDUE = ENT_NRESIDUE + 1

            ENT_RES_NAME    (ENT_NRESIDUE) = RES_NAME   (IR)
            RNUM                           = RES_NUM_PDB(IR)(3:7)
            ENT_RES_AUTH_NUM(ENT_NRESIDUE) = RNUM

            IRBS    = IRES_BACK(IR)
            IRB     = IRES_BACK(IR) - IRS + 1
            IRB_ENT = IRESF_ENT + IRB - 1
            IRFR    = IRES_FORW(IR) - IRS + 1
            IRF_ENT = IRESF_ENT + IRFR - 1

            ENT_IRES_BACK   (ENT_NRESIDUE) = IRB_ENT
            ENT_IRES_FORW   (ENT_NRESIDUE) = IRF_ENT
            ENT_ICHAIN      (ENT_NRESIDUE) = N_CHN_ENT
            ENT_ICONN_TYPE  (ENT_NRESIDUE) = ICONN_TYPE(IR)
            ITYPE                          = ICONN_TYPE(IR)
            ENT_MOD_ID      (ENT_NRESIDUE) = '.'
            ENT_IRES_SERIAL (ENT_NRESIDUE) = IRES_SERIAL(IR)
            ENT_IRES_TYPE   (ENT_NRESIDUE) = IRES_TYPE(IR)

C ------- set link flag in link_list ---

            IF(LN_N.GT.0) THEN
            DO ILN=1,LN_N
              IF(LN_ID(ILN)(1:1).NE.'?'.AND.LN_ID(ILN)(1:1).NE.'.'
     *           .AND.LN_USED(ILN).NE.'S') THEN



                IF((LN_1ICHN(ILN).EQ.LN_2ICHN(ILN)).AND.
     *             (LN_1ICHN(ILN).EQ.IG           )     ) THEN

                  SYMM1 = LN_SYMM1(ILN)
                  SYMM2 = LN_SYMM2(ILN)
                  IF((SYMM1.EQ.'.'.OR.SYMM1.EQ.'1_555').AND.
     *               (SYMM2.EQ.'.'.OR.SYMM2.EQ.'1_555')     ) THEN
                    LINK = LN_ID(ILN)
                    CALL SET_ICONN(LINK,ICONNS)
                    IF(ICONNS.GE.2.AND.ICONNS.LE.N_CONN_TYPE
     *                                   .AND.ICONNS.NE.4) THEN
C                     gap - ICONN=10 , cis - ICONN=3
                      IR1  = LN_1IRES(ILN)
                      IR2  = LN_2IRES(ILN)

                      DIST = LN_DIST(ILN)
 
                      IF(IR1.EQ.IRBS.AND.IR2.EQ.IR) THEN

                        LN_ENT(ILN)    = 'E'
                        IF(LN_USED(ILN).EQ.'U') LN_USED(ILN) = 'u'

                        ICONN_TYPE(IR) = ICONNS
                        ENT_ICONN_TYPE(ENT_NRESIDUE) = ICONN_TYPE(IR)

c                        IF((ITYPE.GT.2.AND.ITYPE.NE.4.AND.ITYPE.NE.36)
                        IF((ITYPE.GT.2.AND.ITYPE.NE.4)
     *                    .OR.LN_USED(ILN).EQ.'u') THEN
C                         2 = 'TRANS' 4 = 'p' 36 = 'PTRANS'
                          RNAME = RES_NAME   (IR2)
                          RNUM  = RES_NUM_PDB(IR2)(3:7)
                          RNUMB = RES_NUM_PDB(IR1)(3:7)
                          RNUMF = '.'

                          ENT_LN_N = ENT_LN_N + 1

                          ENT_LN_ID    (ENT_LN_N) = LINK
                          ENT_LN_ICHAIN(ENT_LN_N) = N_CHN_ENT                

                          IR1_ENT = IRESF_ENT + IR1 -IRS 
                          IR2_ENT = IRESF_ENT + IR2 -IRS 
   
                          ENT_LN_1IRES (ENT_LN_N) = IR1_ENT 
                          ENT_LN_2IRES (ENT_LN_N) = IR2_ENT

                          ENT_LN_1RNAM (ENT_LN_N) = RES_NAME(IR1) 
                          ENT_LN_2RNAM (ENT_LN_N) = RES_NAME(IR2) 

                          ENT_LN_ATOM1 (ENT_LN_N) = LN_ATOM1(ILN) 
                          ENT_LN_ATOM2 (ENT_LN_N) = LN_ATOM2(ILN)

                    ENT_LN_AUTH_NUM1(ENT_LN_N) = RES_NUM_PDB(IR1)(3:7) 
                    ENT_LN_AUTH_NUM2(ENT_LN_N) = RES_NUM_PDB(IR2)(3:7) 

                          ENT_LN_USED  (ENT_LN_N) = 'E' 
                          IF(LN_USED(ILN).EQ.'u') 
     *                      ENT_LN_USED(ENT_LN_N) = 'e'
                          ENT_LN_DIST  (ENT_LN_N) = DIST 

                        ENDIF

                      ENDIF
                    ENDIF  
                  ENDIF
                ENDIF
              ENDIF
            ENDDO
            ENDIF
C ---
          ENDDO
C --- tree --
c          IF(IR.NE.IRET) THEN
c            IR = IRES_FORW(IR)
c            IF(IR.LE.0.OR.IR.LT.IRS.OR.IR.GT.IRF) THEN
c              CALL MSGERR(MDOC,' ERROR: wrong tree structure .....')
c              IERR = 1
c              RETURN
c            ENDIF
c            GO TO 800
c          ENDIF
C --- tree --

          IR1 = ENT_IRES_START_TREE(N_CHN_ENT)    
          IR2 = ENT_IRES_END_TREE  (N_CHN_ENT)  

          ENT_RES_START_TREE (N_CHN_ENT) = ENT_RES_AUTH_NUM(IR1) 
          ENT_RES_END_TREE   (N_CHN_ENT) = ENT_RES_AUTH_NUM(IR2)

C         entity_links
C 
          IF(LN_N.GT.0) THEN
          DO ILN=1,LN_N
            IF(LN_ID(ILN)(1:1).NE.'?'.AND.LN_ID(ILN)(1:1).NE.'.'
     *           .AND.LN_USED(ILN).NE.'S') THEN

              IF((LN_1ICHN(ILN).EQ.LN_2ICHN(ILN)).AND.
     *           (LN_1ICHN(ILN).EQ.IG           )     ) THEN

                SYMM1 = LN_SYMM1(ILN)
                SYMM2 = LN_SYMM2(ILN)
                IF((SYMM1.EQ.'.'.OR.SYMM1.EQ.'1_555').AND.
     *             (SYMM2.EQ.'.'.OR.SYMM2.EQ.'1_555')     ) THEN
                  LINK = LN_ID(ILN)
                  CALL SET_ICONN(LINK,ICONNS)

              IF(ICONNS.GT.2.AND.ICONNS.LE.N_CONN_TYPE
     *                                   .AND.ICONNS.NE.4) THEN

                  IF(LN_ENT(ILN).NE.'E'.AND.LN_ENT(ILN).NE.'e') THEN
c                  IF(LN_ENT(ILN).NE.'E'.OR.
c     *            (LN_USED(ILN).EQ.'U'.AND.
c     *             (LINK.EQ.'TRANS'.OR.LINK.EQ.'p'.OR.LINK.EQ.'PTRANS'
c     *                                            ))) THEN

                    IR1  = LN_1IRES(ILN)
                    IR2  = LN_2IRES(ILN)
                    DIST = LN_DIST(ILN)

                    RNAME = RES_NAME   (IR2)
                    RNUM  = RES_NUM_PDB(IR2)(3:7)
                    RNUMB = RES_NUM_PDB(IR1)(3:7)
                    RNUMF = '.'

                    ENT_LN_N = ENT_LN_N + 1

                    ENT_LN_ID    (ENT_LN_N) = LINK
                    ENT_LN_ICHAIN(ENT_LN_N) = N_CHN_ENT                

                    IR1_ENT = IRESF_ENT + IR1 -IRS 
                    IR2_ENT = IRESF_ENT + IR2 -IRS 
   
                    ENT_LN_1IRES (ENT_LN_N) = IR1_ENT 
                    ENT_LN_2IRES (ENT_LN_N) = IR2_ENT

                    ENT_LN_1RNAM (ENT_LN_N) = RES_NAME   (IR1) 
                    ENT_LN_2RNAM (ENT_LN_N) = RES_NAME   (IR2) 

                    ENT_LN_ATOM1 (ENT_LN_N) = LN_ATOM1(ILN) 
                    ENT_LN_ATOM2 (ENT_LN_N) = LN_ATOM2(ILN)

                    ENT_LN_AUTH_NUM1(ENT_LN_N) = RES_NUM_PDB(IR1)(3:7) 
                    ENT_LN_AUTH_NUM2(ENT_LN_N) = RES_NUM_PDB(IR2)(3:7) 

                    ENT_LN_USED     (ENT_LN_N) = 'L' 

                    ENT_LN_DIST     (ENT_LN_N) = DIST 

                    LN_ENT(ILN) = 'L'

                  ENDIF  
            ENDIF

                ENDIF
              ENDIF
            ENDIF
          ENDDO
          ENDIF
C ---------------------------
 100      CONTINUE
        ENDDO
      ENDIF

      IF(LIST.EQ.'T') THEN
      write(*,*) '-CREAT_ENT-',LN_N
      do i=1,LN_N
      write(*,*) '-C-'
     * ,i,LN_ID(I),LN_USED(I),LN_ENT(i)
      write(*,*) '   '
     * ,LN_1ICHN(i),LN_1IRES(i),LN_2ICHN(i),LN_2IRES(i)
      ir1 = LN_1IRES(i)
      ir2 = LN_2IRES(i)
      write(*,*) '    '
     * ,RES_NUM_PDB(Ir1)(3:7),RES_NAME(Ir1),RES_NUM_PDB(Ir2)(3:7)
     * ,RES_NAME(Ir2),LN_ATOM1(i),LN_ATOM2(I),LN_ALT1(I),LN_ALT2(I)
      enddo
      ENDIF

      RETURN
      END

C ******
      SUBROUTINE WRT_LINK(MDOC,IUN,IFIRST,IERR)
C -------------------------------------------------------
C -P- WRT_  - writes new CIF_file.
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,IFIRST
C ******
      REAL      DIST
      CHARACTER LINE*256,IRES1*5,IRES2*5,SYMM1*8,SYMM2*8
      CHARACTER RNAM1*8,RNAM2*8,GR1*4,GR2*4,LINK*8,LDIST*8
      CHARACTER ATOM1*6,ATOM2*6,ALT1*1,ALT2*1,CH3*3,CH9*9
C     CHARACTER temp*1
C -----------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'CIF_items_crd.fh'
C ------------------------------------------------------------
      IERR = 0
      IF(LN_N.LE.0) RETURN
      J = 0

C
C           LN_ENT    E - form ent_poly_seq (not trans 2 , ptrans 36 , p 4)
C                     L - form ent_link
C                     C - from conn
C
      DO I=1,LN_N


        IF(LN_ID(I)(1:1).NE.'?'.AND.LN_ID(I)(1:1).NE.'.'
     *     .AND.LN_ENT(I).NE.'E'.AND.LN_ENT(I).NE.'e'.AND.
     *          LN_ENT(I).NE.'L'   ) J = J + 1
C ?????
c        LINK = LN_ID(I)
c        CALL LENSTR_BL(LINK,L)
c        IF(L.LE.0) LINK = '.'
c        IF(LINK(1:1).NE.'?'.AND.LINK(1:1).NE.'.'
c     *     .AND.((LN_ENT(I).NE.'E'.AND.LN_ENT(I).NE.'L').OR.
c     *            LN_USED(I).EQ.'U'                         )) THEN

      ENDDO

      IF(J.LE.0) RETURN

      IF(IUN.EQ.0) THEN
        CALL MSGERR(MDOC,' ERROR: output_CRD_file isn''t open')
        IERR=5
        RETURN
      ENDIF

      IF(IFIRST.EQ.0) THEN

        LINE='#################'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        LINE='## STRUCT_CONN ##'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        LINE='#################'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        CALL LENSTR_BL(ICS_CONN_CAT,LENC)
        WRITE(LINE,'(''loop_'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_ID,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_ID(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_TYPE,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_TYPE(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_ATM1,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_ATM1(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_ALT1,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_ALT1(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_NUM1,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_NUM1(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_MON1,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_MON1(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_ENT1,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_ENT1(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_SYM1,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_SYM1(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_ATM2,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_ATM2(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_ALT2,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_ALT2(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_NUM2,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_NUM2(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_MON2,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_MON2(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_ENT2,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_ENT2(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_SYM2,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_SYM2(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_CONN_DIST,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_CONN_DIST(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN
        
        IFIRST=1
      ENDIF

      J = 0

      DO I=1,LN_N

        LINK = LN_ID(I)
        CALL LENSTR_BL(LINK,L)
        IF(L.LE.0) LINK = '.'

        IF(LINK(1:1).NE.'?'.AND.LINK(1:1).NE.'.'
     *     .AND.LN_ENT(I).NE.'E'.AND.LN_ENT(I).NE.'e'.AND.
     *          LN_ENT(I).NE.'L') THEN
C ?????
c        IF(LINK(1:1).NE.'?'.AND.LINK(1:1).NE.'.'
c     *     .AND.((LN_ENT(I).NE.'E'.AND.LN_ENT(I).NE.'L').OR.
c     *            LN_USED(I).EQ.'U'                         )) THEN

          J = J + 1
          WRITE(CH3,'(I3)') J
          IF(CH3(1:1).EQ.' ') THEN
            CH3(1:1) = CH3(2:2)
            CH3(2:2) = CH3(3:3)
            CH3(3:3) = ' '
            IF(CH3(1:1).EQ.' ') THEN
              CH3(1:1) = CH3(2:2)
              CH3(2:2) = ' '
            ENDIF
          ENDIF

          CH9 = CH3

          ATOM1 = LN_ATOM1(I)(1:4) 
          ATOM2 = LN_ATOM2(I)(1:4) 
          CALL LENSTR_BL(ATOM1,L)
          IF(L.LE.0) ATOM1 = '.'
          CALL LENSTR_BL(ATOM2,L)
          IF(L.LE.0) ATOM2 = '.'

          ALT1 = LN_ALT1(I) 
          ALT2 = LN_ALT2(I) 
          CALL LENSTR_BL(ALT1,L)
          IF(L.LE.0) ALT1 = '.'
          CALL LENSTR_BL(ALT2,L)
          IF(L.LE.0) ALT2 = '.'

          SYMM1 = LN_SYMM1(I) 
          SYMM2 = LN_SYMM2(I) 
          CALL LENSTR_BL(SYMM1,L)
          IF(L.LE.0) SYMM1 = '.'
          CALL LENSTR_BL(SYMM2,L)
          IF(L.LE.0) SYMM2 = '.'

          I1    = LN_1ICHN(I)
          IR1   = LN_1IRES(I)

          IF(IR1.GT.0.AND.I1.GT.0) THEN        
c            WRITE(IRES1,'(I5)') IRES_SERIAL(IR1)
            IRES1 = RES_NUM_PDB(IR1)(3:7)
            RNAM1 = LN_1RNAM(I)
            CALL LENSTR_BL(RNAM1,L)
            IF(L.LE.0) RNAM1 = '.'
            GR1   = GROUP_ID(I1)
            CALL LENSTR_BL(GR1,L)
            IF(L.LE.0) GR1 = '.'
          ELSE
            IRES1 = '.'
            RNAM1 = '.'
            GR1   = '.'
          ENDIF

          I2    = LN_2ICHN(I)
          IR2   = LN_2IRES(I)

          DIST = LN_DIST(I) 
          IF(DIST.LT.0.001.OR.DIST.GE.10000.0) THEN
            LDIST = '.'
          ELSE
            WRITE(LDIST,'(F8.3)') DIST
          ENDIF

          IF(IR2.GT.0.AND.I2.GT.0) THEN        
C            WRITE(IRES2,'(I5)') IRES_SERIAL(IR2)
            IRES2 = RES_NUM_PDB(IR2)(3:7)
            RNAM2 = LN_2RNAM(I) 
            CALL LENSTR_BL(RNAM2,L)
            IF(L.LE.0) RNAM2 = '.'
            GR2 = GROUP_ID(I2)  
            CALL LENSTR_BL(GR2,L)
            IF(L.LE.0) GR2 = '.'
          ELSE
            IRES2 = '.'
            RNAM2 = '.'
            GR2   = '.'
          ENDIF


          IF(LINK.EQ.'gap') THEN
            ATOM1 = '.'
            ALT1  = '.'
            ATOM2 = '.'
            ALT2  = '.'
          ENDIF

          CALL CORR_NAME_CIF_OUT(ATOM1)
          CALL CORR_NAME_CIF_OUT(ATOM2)

          WRITE(LINE,
     *    '(A3,1X,A8,1X,A6,1X,A1,1X,A5,1X,A8,1X,'//
     *    'A4,1X,A8,1X,A6,1X,A1,1X,A5,1X,A8,1X,A4)')    
     *    CH9(1:3),LINK
     *    ,ATOM1,ALT1,IRES1,RNAM1,GR1,SYMM1
     *    ,ATOM2,ALT2,IRES2,RNAM2,GR2
C23456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
C   HIS-ZN   NE2  .  149  HIS      AA .        ZN   .  996  ZN       Aa .
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          IF(IERR.NE.0) RETURN

          WRITE(LINE,
     *    '(5X,A8,5X,A)') SYMM2,LDIST
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          IF(IERR.NE.0) RETURN

        ENDIF

      ENDDO

      RETURN
      END

C ******
      SUBROUTINE WRT_MOD(MDOC,IUN,IFIRST,IERR)
C -------------------------------------------------------
C -P- WRT_  - writes new CIF_file.
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,IFIRST
C ******
      CHARACTER LINE*256,IRES*5,RNAM*8,RNAMN*8,GR*4
C -----------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'CIF_items_crd.fh'
C ------------------------------------------------------------
      IERR = 0
      IF(MOD_N.LE.0) RETURN

      DO I=1,MOD_N
        IF(MOD_USED(I).NE.'Y') GO TO 100
      ENDDO
      RETURN

 100  CONTINUE

      IF(IUN.EQ.0) THEN
        CALL MSGERR(MDOC,' ERROR: output_CRD_file isn''t open')
        IERR=5
        RETURN
      ENDIF

      IF(IFIRST.EQ.0) THEN

        LINE='#####################'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        LINE='## STRUCT_ASYM_MOD ##'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        LINE='#####################'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        CALL LENSTR_BL(ICS_MOD_CAT,LENC)
        WRITE(LINE,'(''loop_'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_MOD_ID,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_MOD_ID(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_MOD_NUM,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_MOD_NUM(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN


        CALL LENSTR_BL(ICS_MOD_MON,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_MOD_MON(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_MOD_NEW,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_MOD_NEW(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

c        CALL LENSTR_BL(ICS_MOD_ENT,LEN)
c        WRITE(LINE,'(A)') 
c     *  ICS_MOD_ENT(1:LEN)
c        CALL WRTSTR(IUN,MDOC,LINE,IERR)
c        IF(IERR.NE.0) RETURN

        CALL LENSTR_BL(ICS_MOD_ASM,LEN)
        WRITE(LINE,'(A)') 
     *  ICS_MOD_ASM(1:LEN)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

        IFIRST=1
      ENDIF

      DO I=1,MOD_N
        IF(MOD_USED(I).NE.'Y') THEN

          II   = MOD_ICHN(I)
          IR   = MOD_IRES(I)

          IF(IR.GT.0) THEN
C            WRITE(IRES,'(I5)') IRES_SERIAL(IR)
            IRES = RES_NUM_PDB(IR)(3:7)
          ELSE
            IRES = '.'
          ENDIF

C         standard
          RNAM = MOD_RNAM(I) 
          CALL LENSTR_BL(RNAM,L)
          IF(L.LE.0) RNAM = '.'

C         used
          RNAMN = MOD_RNAM_NEW(I) 
          CALL LENSTR_BL(RNAMN,L)
          IF(L.LE.0) RNAMN = '.'

          IF(II.GT.0) THEN
            GR = GROUP_ID(II)
            CALL LENSTR_BL(GR,L)
            IF(L.LE.0) GR = '.'
          ELSE
            GR = '.'
          ENDIF

          WRITE(LINE,'(2X,A8,2X,A5,2X,A8,2X,A8,2X,A)') 
     *    MOD_ID(I)
     *    ,IRES,RNAM,RNAMN,GR
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          IF(IERR.NE.0) RETURN

        ENDIF
      ENDDO

      RETURN
      END

C ******
      SUBROUTINE WRT_LINK_PDB(MDOC,IUN,SEG_FLAG,IERR)
C -------------------------------------------------------
C -P- 
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
C ******
      REAL      DIST
      CHARACTER LINE*256,IRES1*5,IRES2*5,SYMM1*8,SYMM2*8
      CHARACTER RNAM1*3,RNAM2*3,GR1*2,GR2*2,PNUM*12,LDIST*10
      CHARACTER ATOM1*4,ATOM2*4,ALT1*1,ALT2*1,ATOMA1*5,ATOMA2*5
      CHARACTER FRMT*80,FRMTC*80,FRMTS*80,ANAME*4,ASYMB*4
      CHARACTER SEG_FLAG*1
      CHARACTER SEG1*4,SEG2*4
C -----------------------------------------------
      INCLUDE 'atom_com.fh'
C ------------------------------------------------------------
      FRMTS = '(A6,1X,I3,1X,A3,1X,A1,1X,A5,3X,A3,1X,A1,1X,A5'//
     *        ',1X,A4,1X,A4,13X,A6,1X,A6)'
      FRMTC = '(A6,1X,I3,1X,A3,1X,A1,1X,A5,3X,A3,1X,A1,1X,A5'//
     *        ',1X,A4,1X,A4,7X,F6.2)'
      FRMT  = '(A4,8X,A5,A3,1X,A1,A5,3X,A10,2X,A5,A3,1X,A1,A5'//
     *        ',2X,A6,1X,A6,A8)'
C --
      IERR = 0
      IF(LN_N.LE.0) RETURN

      IF(IUN.EQ.0) THEN
        CALL MSGERR(MDOC,' ERROR: output_CRD(PDB)_file isn''t open')
        IERR=5
        RETURN
      ENDIF

      NCIS = 0
      NSS  = 0

      DO I=1,LN_N

C        IF(LN_ID(I)(1:1).EQ.'?'.OR.LN_ID(I)(1:1).EQ.'.'.AND.
C     *     LN_ENT(I).NE.'E') GO TO 100
C ??????
        IF((LN_ID(I)(1:1).EQ.'?'.OR.LN_ID(I)(1:1).EQ.'.').AND.
     *      LN_ENT(I).NE.'E') GO TO 100

        IF(LN_ID(I).EQ.'PTRANS'.AND.LN_USED(I).NE.'U'
     *      .AND.LN_USED(I).NE.'S'.AND.LN_USED(I).NE.'u') GO TO 100

        ATOM1 = LN_ATOM1(I)(1:4) 
        ATOM2 = LN_ATOM2(I)(1:4) 

        CALL LENSTR_BL(ATOM1,L)
        IF(L.LE.0) ATOM2 = ' '
        CALL LENSTR_BL(ATOM2,L)
        IF(L.LE.0) ATOM2 = ' '

        ALT1 = LN_ALT1(I) 
        ALT2 = LN_ALT2(I) 
        CALL LENSTR_BL(ALT1,L)
        IF(L.LE.0) ALT1 = ' '
        CALL LENSTR_BL(ALT2,L)
        IF(L.LE.0) ALT2 = ' '

        DIST = LN_DIST(I) 
        IF(DIST.LT.0.001.OR.DIST.GE.10000.0) THEN
C         LDIST = '.'
          LDIST = ' '
        ELSE
          WRITE(LDIST,'(F10.3)') DIST
        ENDIF

        SYMM1 = LN_SYMM1(I) 
        SYMM2 = LN_SYMM2(I) 
        CALL LENSTR_BL(SYMM1,L)
        IF(L.LE.0.OR.SYMM1(1:1).EQ.'.') THEN
          SYMM1 = ' '
        ELSE
          LLL=0
          DO LL=1,L
            IF(SYMM1(LL:LL).NE.'_') THEN
              LLL=LLL+1
              SYMM1(LLL:LLL) = SYMM1(LL:LL)
            ENDIF
          ENDDO
          IF(LLL.LT.L) THEN
            DO LL=LLL+1,L
              SYMM1(LL:LL) = ' '
            ENDDO
          ENDIF
        ENDIF
        CALL LENSTR_BL(SYMM2,L)
        IF(L.LE.0.OR.SYMM1(1:1).EQ.'.') THEN
           SYMM2 = ' '
        ELSE
          LLL=0
          DO LL=1,L
            IF(SYMM2(LL:LL).NE.'_') THEN
              LLL=LLL+1
              SYMM2(LLL:LLL) = SYMM2(LL:LL)
            ENDIF
          ENDDO
          IF(LLL.LT.L) THEN
            DO LL=LLL+1,L
              SYMM2(LL:LL) = ' '
            ENDDO
          ENDIF
        ENDIF
        I1    = LN_1ICHN(I)
        IR1   = LN_1IRES(I)

        IF(IR1.GT.0.AND.I1.GT.0) THEN        
          PNUM  = RES_NUM_PDB(IR1)
          IRES1 = PNUM(3:7)
          GR1   = PNUM(1:2)
          SEG1  = PNUM(8:11)
          RNAM1 = LN_1RNAM(I)(1:3)
          CALL LENSTR_BL(RNAM1,L)
          IF(L.LE.0) RNAM1 = ' '
          CALL LENSTR_BL(GR1,L)
          IF(L.LE.0) GR1 = ' '
          IF(IRES1(5:5) .EQ.'.') IRES1(5:5)=' '
          IF(ATOM1.NE.' '.AND.ATOM1.NE.'.') THEN
            NATMR = NATM_RES   (IR1)
            IAS   = IRATM_FIRST(IR1)
            IAF   = IAS + NATMR - 1
            DO IA=IAS,IAF
              IF(ATOM1.EQ.ATM_NAME(IA)) THEN
                ATOM1 = ATM_NAME_INP(IA) 
                ANAME = ATM_NAME_INP(IA)     
                IF(ANAME(4:4).EQ.'_') THEN
                  ATOM1(1:2) = ' '
                  ATOM1(2:4) = ANAME(1:3)  
                  IF(ATOM1(4:4).EQ.'_') THEN
                    ATOM1(4:4) = ' '  
                    IF(ATOM1(3:3).EQ.'_')  ATOM1(3:3) = ' '  
                  ENDIF
                ENDIF
              ENDIF
            ENDDO
          ENDIF
        ELSE
          IRES1 = ' '
          RNAM1 = ' '
          GR1   = ' '
          SEG1  = '    '
        ENDIF

        I2    = LN_2ICHN(I)
        IR2   = LN_2IRES(I)

        IF(IR2.GT.0.AND.I2.GT.0) THEN        
          PNUM  = RES_NUM_PDB(IR2)
          IRES2 = PNUM(3:7)
          GR2   = PNUM(1:2)
          SEG2  = PNUM(8:11)
          RNAM2 = LN_2RNAM(I)(1:3) 
          CALL LENSTR_BL(RNAM2,L)
          IF(L.LE.0) RNAM2 = ' '
          CALL LENSTR_BL(GR2,L)
          IF(L.LE.0) GR2 = ' '
          IF(IRES2(5:5) .EQ.'.') IRES2(5:5)=' '
          IF(ATOM2.NE.' '.AND.ATOM2.NE.'.') THEN
            NATMR = NATM_RES   (IR2)
            IAS   = IRATM_FIRST(IR2)
            IAF   = IAS + NATMR - 1
            DO IA=IAS,IAF
              IF(ATOM2.EQ.ATM_NAME(IA)) THEN
                ATOM2 = ATM_NAME_INP(IA)
                ANAME = ATM_NAME_INP(IA)     
                IF(ANAME(4:4).EQ.'_') THEN
                  ATOM2(1:2) = ' '
                  ATOM2(2:4) = ANAME(1:3)  
                  IF(ATOM2(4:4).EQ.'_') THEN
                    ATOM2(4:4) = ' '  
                    IF(ATOM2(3:3).EQ.'_')  ATOM2(3:3) = ' '  
                  ENDIF
                ENDIF
              ENDIF 
            ENDDO
          ENDIF
        ELSE
          IRES2 = ' '
          RNAM2 = ' '
          GR2   = ' '
          SEG2  = '    '
        ENDIF

        CALL PDB_RNAME_CORR_TO_WRITE(RNAM1)
        CALL PDB_RNAME_CORR_TO_WRITE(RNAM2)

        IF(SYMM1(1:1).EQ.'.') SYMM1 = ' '
        IF(SYMM2(1:1).EQ.'.') SYMM2 = ' '
        IF(ALT1.EQ.'.') ALT1 = ' '
        IF(ALT2.EQ.'.') ALT2 = ' '
        IF(ATOM1(1:1).EQ.'.') ATOM1(1:1) = ' '
        IF(ATOM2(1:1).EQ.'.') ATOM2(1:1) = ' '
        IF(RNAM1(1:1).EQ.'.') RNAM1(1:1) = ' '
        IF(RNAM2(1:1).EQ.'.') RNAM2(1:1) = ' '

        ATOMA1 = ATOM1//ALT1
        ATOMA2 = ATOM2//ALT2

        IF(SEG_FLAG.EQ.'Y') THEN
c          GR1 = ' '
c          GR2 = ' '
        ELSE
          SEG1  = '    '
          SEG2  = '    '
        ENDIF

        IF(LN_ID(I).EQ.'PCIS'.OR.LN_ID(I).EQ.'CIS'.AND.
     *     (SYMM1.EQ.' '.AND.SYMM2.EQ.' ').AND.
     *     (ALT1.EQ.' '.AND.ALT2.EQ.' '  )              ) THEN

          NCIS  = NCIS + 1
          ANGLE = 0.0

          WRITE(LINE,FRMTC)
     *    'CISPEP',NCIS
     *    ,RNAM1,GR1(1:1),IRES1
     *    ,RNAM2,GR2(1:1),IRES2,SEG1,SEG2
     *    ,ANGLE

        ELSE IF(LN_ID(I).EQ.'SS'.AND.
     *     (ALT1.EQ.' '.AND.ALT2.EQ.' ') ) THEN

          NSS = NSS + 1
          WRITE(LINE,FRMTS)
     *    'SSBOND',NSS
     *    ,RNAM1,GR1(1:1),IRES1
     *    ,RNAM2,GR2(1:1),IRES2,SEG1,SEG2
     *    ,SYMM1,SYMM2

        ELSE

          LDIST = SEG1//' '//SEG2//' '
          WRITE(LINE,FRMT)
     *    'LINK'
     *    ,ATOMA1,RNAM1,GR1(1:1),IRES1, LDIST
     *    ,ATOMA2,RNAM2,GR2(1:1),IRES2
     *    ,SYMM1,SYMM2,LN_ID(I)

        ENDIF
        
        CALL WRTSTR(IUN,MDOC,LINE,IERR)        
        IF(IERR.NE.0) RETURN

 100    CONTINUE

      ENDDO

      RETURN
      END

C ******
      SUBROUTINE WRT_MOD_PDB(MDOC,IUN,SEG_FLAG,IERR)
C -------------------------------------------------------
C -P-
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
C ******
      CHARACTER LINE*256,IRES*5,RNAM*8,RNAMN*3,GR*2,PNUM*12
      CHARACTER FRMT*80
      CHARACTER SEG_FLAG*1
      CHARACTER SEG*4
C -----------------------------------------------
      INCLUDE 'atom_com.fh'
C ------------------------------------------------------------
      DATA FRMT/
     *'(A6,6X,A3,1X,A1,1X,A5,1X,A8,1X,A4,35X,A8)'/
C ------------------------------------------------------------
      IERR = 0
      IF(MOD_N.LE.0) RETURN

      IF(IUN.EQ.0) THEN
        CALL MSGERR(MDOC,' ERROR: output_CRD(PDB)_file isn''t open')
        IERR=5
        RETURN
      ENDIF

      DO I=1,MOD_N

        II   = MOD_ICHN(I)
        IR   = MOD_IRES(I)

        IF(IR.GT.0) THEN
          PNUM = RES_NUM_PDB(IR)
          IRES = PNUM(3:7)
          GR   = PNUM(1:2)
        ELSE
          IRES = '.'
        ENDIF

        RNAM = MOD_RNAM(I) 
        CALL LENSTR_BL(RNAM,L)
        IF(L.LE.0) RNAM = '.'

        RNAMN = MOD_RNAM_NEW(I)(1:3) 
        CALL LENSTR_BL(RNAMN,L)
        IF(L.LE.0) RNAMN = '.'
        CALL PDB_RNAME_CORR_TO_WRITE(RNAMN)

        IF(II.GT.0) THEN
          PNUM = RES_NUM_PDB(IR)
          GR   = PNUM(1:2)
          SEG  = PNUM(8:11)
          CALL LENSTR_BL(GR,L)
          IF(L.LE.0) GR = '.'
          CALL LENSTR_BL(SEG,L)
          IF(L.LE.0) SEG = '.   '
        ELSE
          GR = '.'
          SEG = '    '
        ENDIF

c MODRES 3ABC ALA A   32  ALA  POST-TRANSLATIONAL MODIFICATION,D-ALANINE
C            actual     standard

        IF(SEG_FLAG.EQ.'Y') THEN
c          GR  = ' '
        ELSE
          SEG = '    '
        ENDIF

        WRITE(LINE,FRMT) 
     *  'MODRES'
     *  ,RNAMN,GR(1:1),IRES,RNAM,SEG
     *  ,MOD_ID(I)
 
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        IF(IERR.NE.0) RETURN

      ENDDO

      RETURN
      END

C ******
      SUBROUTINE WRCRD_CIF(MDOC,IOUT,MODE,IEND,IERR)
C
C -P- WRCRD - writes coordinates to file.
C
      INTEGER IOUT,MDOC,IERR,IEND,MODE
C ******
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C ------------------------------------------------------------
      REAL      XA(3),YA(3),AM(3,3)
      CHARACTER LINE*256,MULT*2,BFLAG*4,ASYMB*4,RNUM*5
      CHARACTER GROUP*4,CH8*8,CH60*60,WATOM1*6,WATOM2*6,CH11*11
C     CHARACTER ALT*2
C ------------------------------------------------------------
      IERR = 0
      
      IF(IEND.LE.0) THEN

        IF(MODE.EQ.0) THEN

          BFLAG = '.   '
          IF(CR_B_FLAG.EQ.1) BFLAG = 'Uani'

          IF(CR_MULT_FACTOR.GT.1.AND.CR_MULT_FACTOR.LT.100) THEN
            WRITE(MULT,'(I2)',ERR=400) CR_MULT_FACTOR
            GO TO 410
 400        CONTINUE
            MULT = '. '
          ELSE
            MULT = '. '
          ENDIF
 410      CONTINUE

          ASYMB      = CR_ASYMB
          IATOM      = CR_IATOLD

          IF((CR_HFLAG.EQ.'N').AND.
     *       (ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ').AND.
     *       (CR_ATYPE.EQ.'U'.OR.CR_ATYPE.EQ.'M')      ) THEN
            GO TO 500
          ENDIF
       
C          WRITE(RNUM(1:4),'(I4)') CR_IRES
C          RNUM(5:5) = CR_PNUM(7:7)
C          IF(RNUM(5:5).EQ.' ') RNUM(5:5) = '-'

          RNUM  = CR_PNUM(3:7)
          GROUP = CR_GROUP

          IF(CR_ATYPE.EQ.' ')    CR_ATYPE = '.'
          IF(CR_ALT  .EQ.' ')    CR_ALT   = '.'
          IF(CR_CORR .EQ.' ')    CR_CORR  = '.'
          IF(CR_BISO .GT.999.99) CR_BISO  = 999.99
          IF(CR_BISO .LT.-99.99) CR_BISO  = -99.99

          IF(CR_OCC  .GT. 99.99) CR_OCC   =  99.99
          IF(CR_OCC  .LT. -9.99) CR_OCC   = - 9.99

          IF(ST_CHEM.EQ.' ')    ST_CHEM = '.'

C          IF(OUT_CIF_CORR.GT.0.AND.OUT_CIF_INS.GT.0) THEN

          IF(OUT_CIF_CORR.GT.0.AND.OUT_CIF_MULT.GT.0) THEN
            CH8 = ' '
          ELSE
            CH8 = '  '//MULT//' '//CR_CORR
          ENDIF

          CALL NB_INVERT(CS_SCALE,AM,IERR)
          CALL NB_MVMULT(CS_ORT_TO_FRAC,CR_XYZ,YA)
      
          YA(1)     = YA(1) - CS_U(1)
          YA(2)     = YA(2) - CS_U(2)  
          YA(3)     = YA(3) - CS_U(3)   
          CALL NB_MVMULT(AM,YA,XA)

          WATOM1 = CR_ANAME
          CALL CORR_NAME_CIF_OUT(WATOM1)
          CALL LENSTR_BL(WATOM1,L)
          IF(L.LE.0) THEN
            L = 1
            WATOM1 = '?'
          ENDIF

          WATOM2 = CR_ANAME_INP
          CALL CORR_NAME_CIF_OUT(WATOM2)
          CALL LENSTR_BL(WATOM2,L2)
          IF(L2.LE.0) THEN
            WATOM2 =  WATOM1
            L2 = L
          ENDIF

          IF(L.LE.4) THEN
            WRITE(LINE,100)
     *      IATOM,WATOM1,CR_ALT,CR_RNAME  
     *      ,GROUP,RNUM
     *      ,XA(1),XA(2),XA(3)
     *      ,CR_OCC,CR_BISO,ASYMB,CR_ATYPE
 100        FORMAT(I6,1X,A6,1X,A1,1X,A,1X,A,1X,A5
     *      ,1X,F8.3,1X,F8.3,1X,F8.3,1X,F5.2,1X,F6.2           
     *      ,1X,A4,1X,A1)
          ELSE                                      
            WRITE(LINE,101)
     *      IATOM,WATOM1,CR_ALT,CR_RNAME  
     *      ,GROUP,RNUM
     *      ,XA(1),XA(2),XA(3)
     *      ,CR_OCC,CR_BISO,ASYMB,CR_ATYPE
 101        FORMAT(I6,1X,A6,1X,A1,1X,A,1X,A,1X,A5
     *      ,1X,F8.3,1X,F8.3,1X,F8.3,1X,F5.2,1X,F6.2           
     *      ,1X,A4,1X,A1)                                      
          ENDIF

          IF(IOUT.GT.0) THEN
            CALL WRTSTR(IOUT,MDOC,LINE,IERR)
            IF(IERR.NE.0) THEN
              GO TO 200
            ENDIF
          ENDIF

          CH11 = WATOM2//' '//ST_CHEM
          CALL LENSTR_BL(CH11,L11)

          CALL LENSTR_BL(CH8,L8)

          IF(CR_BTYPE.EQ.'A') THEN

            IF(CR_B_FLAG.EQ.1) THEN
              WRITE(CH60,'(6(1X,F9.4))') (CR_ANIS(IAN),IAN=1,6)
            ELSE
              CH60=' . . . . . .'
C     *'     .         .         .         .         .         .'
C       123456789 123456789 123456789 123456789 123456789 123456789
            ENDIF

            IF(L8.GT.0) THEN
              WRITE(LINE,'(A,A,1X,A)') CH11,CH8,CH60
            ELSE
              WRITE(LINE,'(7X,A,1X,A)') CH11,CH60
            ENDIF

C            IF(IOUT.GT.0) THEN
              CALL WRTSTR(IOUT,MDOC,LINE,IERR)
              IF(IERR.NE.0) THEN
                GO TO 200
              ENDIF
C            ENDIF

          ELSE
           
            IF(L8.GT.0) THEN
              WRITE(LINE,'(7X,A,A)') CH11,CH8
C              IF(IOUT.GT.0) THEN
                CALL WRTSTR(IOUT,MDOC,LINE,IERR)
                IF(IERR.NE.0) THEN
                  GO TO 200
                ENDIF
C              ENDIF
            ELSE
              WRITE(LINE,'(7X,A)') CH11
C              IF(IOUT.GT.0) THEN
                CALL WRTSTR(IOUT,MDOC,LINE,IERR)
                IF(IERR.NE.0) THEN
                  GO TO 200
                ENDIF
C              ENDIF
            ENDIF

          ENDIF

 500      CONTINUE


        ELSE
C
C         write comments
C
          IF(IOUT.GT.0) THEN
            CALL LENSTR_BL(CR_LINE,LEN)
            LINE = CR_LINE        
            CALL WRTSTR(IOUT,MDOC,LINE,IERR)
            IF(IERR.NE.0) THEN
              GO TO 200
            ENDIF
          ENDIF

        ENDIF

        IF(IERR.GT.0) GO TO 200
C ---
      ELSE
        IF(IOUT.GT.0) THEN

          END FILE IOUT

          CLOSE(IOUT,ERR=210)

        ENDIF
      ENDIF
 210  CONTINUE
      RETURN
C -----------------------------------------------
 200  CONTINUE 
      CALL MSGERR(MDOC,' ERROR: WRITE TO OUTPUT FILE ')

      CLOSE(IOUT,ERR=220)

 220  CONTINUE
      IERR=4
      RETURN
      END


C -I-
      SUBROUTINE WRITE_ATOMS_PDB(MDOC,HFLAG_O,DEPOS,SEG_FLAG
     *                                     ,PATH,NAMEC,EXT,IERR)
C ----------------------------------------------------------
C -P- WRITE_ATOMS_PDB - 
C
C    MDOC   - mode of writting messages to DOC-file
C             0 - only terminal , < - 0 only file, 0 < < 99 - both
C             >= 99 - don't write  
C    NAMEC  - name of input file without extention.
C    IERR   - output signal of error / = 1 -error , = 0 - OK / 
C -I-
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C --------------
      INTEGER   MDOC,IERR
      CHARACTER NAMEC*(*),EXT*(*),PATH*(*),HFLAG_O*1,DEPOS*1
      CHARACTER SEG_FLAG*1
C ----------------------------------------------------------------
      INTEGER   IANIS(6)
      REAL      XA(3),YA(3),AM(3,3)
      CHARACTER LINE*256,STR*256
      CHARACTER CHAIN*4,ALT*1,ASYMB*4,RES*3,ATYPE*1,ATOM*4,ANAME*4
      CHARACTER PNUM*12,IRES*5,CH4*4,SEG*4
C     CHARACTER GID*4,NCSF*1
C==================================================================
      IERR  = 0
      MD    = -ABS(MDOC)-1
      M     = 99
      PI    = 4.0*ATAN(1.0)
      CONST = 8.0*PI*PI
C --------
      IF(HFLAG_O.EQ.'y') HFLAG_O = 'Y'
      IF(HFLAG_O.NE.'Y') HFLAG_O = 'N'
      IF(SEG_FLAG.EQ.'y') SEG_FLAG = 'Y' 
      IF(SEG_FLAG.NE.'Y') SEG_FLAG = 'N'
C --------
      CALL LENSTR_BL(NAMEC,LEN)
      IF(LEN.GT.0.AND.NAMEC(1:1).NE.','.AND.NAMEC(1:1).NE.' ') THEN 
        PATH = ' '
        EXT  = ' '
C       IOUT = 11
        IOUT = CRO_IUN
        CALL OPENFW(IOUT,MD,PATH,NAMEC,EXT,IERR)
        CRO_IUN = IOUT
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERROR: OPEN OUT_PDB_FILE')
          RETURN
        ENDIF
      ENDIF
C -------------------
C ---- PDB-TITLE ----
      STR = CS_NAME_PDB
      CALL LENSTR_BL(STR,LEN)
      IF(LEN.LT.40) THEN
        DO II=LEN+1,40
          STR(II:II) = ' '
        ENDDO
      ENDIF
      WRITE(LINE,140) STR(1:40),CS_DATE_PDB,CS_CD_PDB
  140 FORMAT ('HEADER',4X,A40,A9,3X,A4)
      WRITE(IOUT ,'(A80)') LINE
      WRITE(LINE,150) CS_TITLE
  150 FORMAT ('COMPND',4X,A60)
      WRITE(IOUT ,'(A80)') LINE

      CALL WRITE_DEPOSIT_STATS(IOUT)
      CALL WRT_LINK_PDB(MDOC,IOUT,SEG_FLAG,IERR)
      CALL WRT_MOD_PDB(MDOC,IOUT,SEG_FLAG,IERR)

      NCODE = 1
      ZERO  = 0.0
      CELL4 = (CS_CELL(4)*180.0)/3.1415926
      CELL5 = (CS_CELL(5)*180.0)/3.1415926
      CELL6 = (CS_CELL(6)*180.0)/3.1415926
      WRITE(LINE,100) CS_CELL(1),CS_CELL(2),CS_CELL(3)
     *           ,CELL4,CELL5,CELL6,CS_SPGR(1:11)
  100 FORMAT ('CRYST1',3F9.3,3F7.2,1X,A11)
      WRITE(IOUT ,'(A80)') LINE
C     ----   scale ----
      WRITE(LINE,110) CS_SCALE(1,1),CS_SCALE(1,2)
     *               ,CS_SCALE(1,3),CS_U(1)
  110 FORMAT ('SCALE1',4X,3F10.6,5X,F10.5)
      WRITE(IOUT ,'(A80)') LINE
      WRITE(LINE,120) CS_SCALE(2,1),CS_SCALE(2,2)
     *               ,CS_SCALE(2,3),CS_U(2)
  120 FORMAT ('SCALE2',4X,3F10.6,5X,F10.5)
      WRITE(IOUT ,'(A80)') LINE
      WRITE(LINE,130) CS_SCALE(3,1),CS_SCALE(3,2)
     *               ,CS_SCALE(3,3),CS_U(3)
  130 FORMAT ('SCALE3',4X,3F10.6,5X,F10.5)
      WRITE(IOUT ,'(A80)') LINE
C -------------------
      NA = 0
C -------------------------------------
      IF(N_ATOM.GT.0) THEN 
      CALL NB_INVERT(CS_SCALE,AM,IERR)
      DO I=1,N_ATOM   

        IATOLD    = I_ATOLD(I)    
C ---
C  22.05.03
        IF(IATOLD.GT.99999) THEN
          IATOLD = MOD(IATOLD,100000) + 1
        ENDIF
C ---
        IRESID    = I_RESID    (I)
        RES       = RES_NAME   (IRESID)(1:3)
        IG        = I_CHAIN    (IRESID) 
        IB        = B_FLAG     (I)
        PNUM      = RES_NUM_PDB(IRESID)
        IRES      = PNUM(3:7)
        CHAIN     = PNUM(8:11)
        INSF      = ID_SF      (I)
        ASYMB     = CS_ELEMENT (INSF)      
        ATYPE     = ATM_TYPE   (I)    
        ALT       = ID_ALT     (I)    

        IF(ASYMB(1:2).EQ.'H '.AND.HFLAG_O.NE.'Y') GO TO 200

C       --- SCALE ---
C       CALL NB_INVERT(CS_SCALE,AM,IERR)
        CALL NB_MVMULT(CS_ORT_TO_FRAC,XYZ_CRD(1,I),YA)
      
        YA(1)     = YA(1) - CS_U(1)
        YA(2)     = YA(2) - CS_U(2)  
        YA(3)     = YA(3) - CS_U(3)   
        CALL NB_MVMULT(AM,YA,XA)
C       ----
C
C        B         = B_ISO      (I)  
C
        IF(IB.NE.0) THEN
C          DO IAN=1,6
C            IANIS(IAN) = U_ANISO(IAN,I)*10000.0
C          ENDDO
C
          CALL CALC_B_EQUIV(U_ANISO(1,I),B)
C
        ELSE
          B = U_ANISO(1,I)*CONST
        ENDIF

        OCC       = OCCUP      (I)

C       ANAME     = ATM_NAME (I)     
        ANAME     = ATM_NAME_INP(I)     
        IF(ANAME(4:4).EQ.'_') THEN
          ATOM(1:1) = ' '
          ATOM(2:4) = ANAME(1:3)  
          IF(ATOM(4:4).EQ.'_') THEN
            ATOM(4:4) = ' '  
            IF(ATOM(3:3).EQ.'_')  ATOM(3:3) = ' '  
          ENDIF
        ELSE
          ATOM = ANAME
        ENDIF

        IF(ATYPE.NE.'.'.AND.ATYPE.NE.' '.AND.ATYPE.NE.'y'.AND.
     *   ATYPE.NE.'Y'.AND.ATYPE.NE.'r'.AND.ATYPE.NE.'R')
     *   GO TO 200

c        CALL PDB_ANAME(ANAME,ASYMB,RES,ATOM)

        IF(ALT       .EQ.'.') ALT=' '
        IF(CHAIN(1:1).EQ.'.') CHAIN(1:1)=' '
        IF(CHAIN(2:2).EQ.'.') CHAIN(2:2)=' '
        IF(IRES(5:5) .EQ.'.') IRES(5:5)=' '

        CALL LENSTR_BL(ASYMB,LN)
        IF((LN.GT.1.AND.(ASYMB(2:2).EQ.'+'.OR.ASYMB(2:2).EQ.'-')).OR.
     *      LN.EQ.1) THEN
          IF(LN.GE.4) LN = 3
          CH4 = ' '//ASYMB(1:LN)
        ELSE
          CH4 = ASYMB
        ENDIF

        CALL PDB_RNAME_CORR_TO_WRITE(RES)
      
        NA = NA + 1
        SEG = '    '
        IF(SEG_FLAG.EQ.'Y') THEN
          SEG = CHAIN
c          CHAIN = '    '
        ENDIF
C ----
        WRITE(LINE,400) IATOLD,ATOM,ALT,RES,CHAIN(1:1),IRES
     *                 ,XA(1),XA(2),XA(3),OCC,B,SEG,CH4
 400    FORMAT(
     *'ATOM',1X,I6,1X,A4,A1,A3,1X,A1,A5,3X,3F8.3,2F6.2,6X,A4,A4)
        CALL LENSTR_BL(LINE,LN)
        IF(LN.GT.0) THEN
          WRITE(IOUT,'(A)') LINE(1:LN)
        ENDIF

        IF(IB.NE.0) THEN
          DO IAN=1,6
            IANIS(IAN) = U_ANISO(IAN,I)*10000.0
          ENDDO
          WRITE(LINE,410) IATOLD,ATOM,ALT,RES,CHAIN(1:1),IRES
     *                  ,(IANIS(L),L=1,6),CH4
 410      FORMAT ('ANISOU',I5,1X,A4,A1,A3,1X,A1,A5,1X,6I7,6X,A4)
          CALL LENSTR_BL(LINE,LN)
          IF(LN.GT.0) THEN
            WRITE(IOUT,'(A)') LINE(1:LN)
          ENDIF

        ENDIF     

 200    CONTINUE
C ----
      ENDDO
      ENDIF
C --------------------------------------
      WRITE(LINE,'('' Number of atoms to write :'',I8)') NA
      CALL MSGDOC(MDOC,LINE)
      END FILE IOUT
      CLOSE(IOUT)
C --------------------------------------
      RETURN
      END

      SUBROUTINE CALC_B_EQUIV(U_ANIS,B_EQUIV)
C ------------------------
      REAL U_ANIS(6)
C ------------------------
      PI    = 4.0*ATAN(1.0)
      CONST = 8.0*PI*PI
C ------------------------
      B_EQUIV = ((U_ANIS(1) +U_ANIS(2) + U_ANIS(3))/3.0)*CONST
C ------------------------
      RETURN
      END

      SUBROUTINE PDB_RNAME_CORR_TO_WRITE(RNAME)
C -----------------------------------------------
      CHARACTER RES*3,RNAME*(*)
C ----------------------------------------------
      CALL LENSTR_BL(RNAME,LEN)
      IF(LEN.LE.0) RETURN
      IF(LEN.GT.3) LEN=3
      RES = RNAME(1:LEN)
      IF(RES.EQ.'Cd'.OR.RES.EQ.'Cr') RES = 'C'
      IF(RES.EQ.'Ad'.OR.RES.EQ.'Ar') RES = 'A'
      IF(RES.EQ.'Gd'.OR.RES.EQ.'Gr') RES = 'G'
      IF(RES.EQ.'Td') RES = 'T'
      IF(RES.EQ.'Ur') RES = 'U'
      IF(RES.EQ.'Ir') RES = 'I'
      CALL LENSTR_BL(RES,LEN)
      IF(LEN.EQ.1) THEN
        RNAME = '  '//RES(1:1)
      ELSE IF(LEN.EQ.2) THEN
        RNAME = ' '//RES(1:2)
      ELSE
        RNAME = RES
      ENDIF
      RETURN
      END

      SUBROUTINE PDB_ANAME(ANAME,ASYMB,RNAME,ATOM)
C -----------------------------------------------
      CHARACTER ANAME*4,ASYMB*4,ATOM*4,RNAME*(*)
C ----------------------------------------------
C ---
      INCLUDE 'metal.fh'
C -----------------------------------------------
C      PARAMETER (N_NAME = 32)
C      CHARACTER NAME(N_NAME)*2
C      DATA NAME/'CO','MG','CA','ZN','CU','FE','CL','BR','MN','PB',
C     *          'HG','AL','GD','NA','CD','NI','SR','IN','HO','YB',
C     *          'TE','LI','RB','BA','CS','SM','TL','PT','BE','SE',
C     *          'MO','SI'/
C ??? more
C ---
C ---------------------------------------------
      CHARACTER CH1*1,CH2*2,TYPE*1
C ---------------------------------------------
      CALL LENSTR_BL(ANAME,LEN)
      IF(LEN.LE.3) ANAME(4:4) = ' '
      IF(LEN.LE.2) ANAME(3:3) = ' '
      IF(LEN.LE.1) ANAME(2:2) = ' '
      ATOM = '    '
      CH2  = ASYMB(1:2)
      DO  I=1,N_NAME
        IF(NAME(I).EQ.CH2) THEN
          CALL LENSTR_BL(CH2,LEN)
          IF(LEN.GT.1) THEN
            ATOM = ANAME
          ELSE
            CALL LENSTR_BL(ANAME,L)
            IF(L.GT.3) L = 3
            ATOM = ' '//ANAME(1:L)
          ENDIF
          RETURN
        ENDIF
      ENDDO
      IF(ASYMB.EQ.'H   '.OR.ASYMB.EQ.'D   ') THEN
        ATOM(2:4) = ANAME(1:3)
        IF(ANAME(4:4).NE.' ') THEN
          CH1 = ANAME(4:4)
          CALL CHKSMB(CH1,TYPE)
          IF(TYPE.EQ.'D'.OR.CH1.EQ.''''.OR.CH1.EQ.'"'.OR.CH1.EQ.'*')THEN
            ATOM(1:1) = ANAME(4:4)
            IF(ATOM(4:4).EQ.'_') THEN
              ATOM(4:4) = ' '
              IF(ATOM(3:3).EQ.'_') ATOM(3:3) = ' '
            ENDIF
          ELSE
            ATOM(1:4) = ANAME(1:4)
          ENDIF 
        ENDIF
      ELSE
        IF(ANAME(4:4).NE.' ') THEN
C          IF(ANAME(1:1).EQ.ASYMB(1:1)) THEN
C            ATOM(2:4) = ANAME(1:3)
C            ATOM(1:1) = ANAME(4:4)
C          ELSE
          CH1 = ANAME(4:4)
          CALL CHKSMB(CH1,TYPE)
          IF(TYPE.EQ.'D'.OR.CH1.EQ.''''.OR.CH1.EQ.'"'.OR.CH1.EQ.'*')THEN
            ATOM(2:4) = ANAME(1:3)
            ATOM(1:1) = ANAME(4:4)
            IF(ATOM(4:4).EQ.'_') THEN
              ATOM(4:4) = ' '
              IF(ATOM(3:3).EQ.'_') ATOM(3:3) = ' '
            ENDIF
          ELSE
            ATOM(1:4) = ANAME(1:4)
          ENDIF
C          ENDIF
        ELSE
          IF(ANAME(1:1).EQ.ASYMB(1:1)) THEN
            IF(ANAME(2:2).EQ.ASYMB(1:1)) THEN
              ATOM(1:3) = ANAME(1:3)
            ELSE
              ATOM(2:4) = ANAME(1:3)
            ENDIF
          ELSE
            ATOM(1:3) = ANAME(1:3)
          ENDIF
        ENDIF
      ENDIF
C --- special cases --

      IF(RNAME(1:3).EQ.'HEM') THEN
        IF(ANAME.EQ.'NA  ') ATOM=' N A'
        IF(ANAME.EQ.'NB  ') ATOM=' N B'
        IF(ANAME.EQ.'NC  ') ATOM=' N C'
        IF(ANAME.EQ.'ND  ') ATOM=' N D'
      ENDIF

      RETURN
      END

      SUBROUTINE READ_STR(MDOC,PATHC,NAMEC,EXTC,IERR)
C --------------------------------------------------------------
C -P- READ_STR - 
C
C    MDOC   - mode of writting messages to DOC-file
C             0 - only terminal , < - 0 only file, 0 < < 99 - both
C             >= 99 - don't write  
C    NAMEC  - name of input file
C    PATHC  - path
C    EXTC   - extention
C    IERR   - output signal of error / = 1 -error , = 0 - OK / 
C -I-
C ---------------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
C ---------------------------------------------------------------
      INTEGER     MDOC,IERR
      CHARACTER   NAMEC*(*),PATHC*(*),EXTC*(*)
C ----------------------------------------------------------------
      INTEGER     M,MD,IN,IEND,MODE
C     INTEGER     CR_IRES_OLD,CR_IGROUP_OLD
C     CHARACTER   CR_RES_OLD*5,CR_GROUP_OLD*4
C     CHARACTER   LINE*256
C ----------------------------------------------------------------
      IERR = 0
      MD   =-ABS(MDOC)-1
      M    = 99
C -------------------------------------------------
C --- open input CIFile 
C
C     IN  = 10
      IN  = CRS_IUN
      CALL ORSTR_CIF(MD,IN,PATHC,NAMEC,EXTC,IERR)
      CRS_IUN = IN
      IF(IERR.EQ.1) THEN
        CALL MSGERR(MDOC,' ERROR: open input file /str/')
        RETURN
      ELSE IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: reading title of input file /str/')
        CLOSE(IN)
        RETURN
      ENDIF
C -------------------------------------------------
      IF(N_ATOM.GT.0) THEN
        DO IA=1,N_ATOM
          CHEM_TYPE  (IA) =  '.'    
          IATM_BACK  (IA) =  0  
          IATM_FOR   (IA) =  0   
          IATM_EXTR  (IA) =  0   
          IATM_EXTR2 (IA) =  0   
          IATM_EXTR3 (IA) =  0   
        ENDDO
      ENDIF

C
C     for first call of RDCRD_CIF iend = -1
C
      IEND          = -1
C --------------------------------
C     start atom's loop 
C 
 200  CONTINUE

C
C     read information from file and put to commons: ....
C 
      CALL RDSTR_CIF(MDOC,IN,MODE,IEND,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: read input file /str/')
        CLOSE(CRS_IUN)
        RETURN
      ENDIF
C
C     IEND.NE.0 - end of file
C     
      IF(IEND.NE.0) THEN
        GO TO 300
      ENDIF
      IF(MODE.EQ.0) THEN

        IF(ST_IA.GT.0.AND.ST_IA.LE.N_ATOM) THEN
          VDW_RAD    (ST_IA) =  ST_VDW  
          ION_RAD    (ST_IA) =  ST_ION  
          CHEM_TYPE  (ST_IA) =  ATM_CHEM(ST_IA)   

c         ATM_CHEM   (ST_IA) =  ST_CHEM    

          HB_TYPE    (ST_IA) =  ST_HBT     
          IATM_BACK  (ST_IA) =  ST_IBACK  
          IATM_FOR   (ST_IA) =  ST_IFOR   
          IATM_EXTR  (ST_IA) =  ST_IEXTR   
          IATM_EXTR2 (ST_IA) =  ST_IEXTR2   
          IATM_EXTR3 (ST_IA) =  ST_IEXTR3   
          ID_PSI     (ST_IA) =  ST_ID_PSI  
          ATM_DIST   (ST_IA) =  ST_DIST    
          ATM_THETA  (ST_IA) =  ST_THT     
          ATM_PSI    (ST_IA) =  ST_PSI     
          ATM_CHARGE (ST_IA) =  ST_CHAR    
          ID_PHI     (ST_IA) =  0  
          ID_TREE    (ST_IA) =  0  
        ENDIF    

      ELSE
C
C       comments
C
C       CR_LINE - string of comments 

      ENDIF      
C ----
      GO TO 200
C
C     end of atom's loop
C --------------------------------------
 300  CONTINUE

      IF(N_ATOM.GT.0) THEN
        DO IA=1,N_ATOM
          IE  = IATM_EXTR(IA)
          IF(IE.GT.0) THEN
            IEA = IATM_EXTR(IE)
            IF(IEA.EQ.0) THEN
              IATM_EXTR(IE)  = IA
            ELSE IF(IEA.GT.0.AND.IEA.NE.IA) THEN
              IEA2 = IATM_EXTR2(IE)
              IF(IEA2.LE.0) THEN
                IATM_EXTR2(IE) = IA
              ELSE IF(IEA2.GT.0.AND.IEA2.NE.IA) THEN
                IATM_EXTR3(IE) = IA
              ENDIF             
            ENDIF
          ENDIF
        ENDDO
      ENDIF

C     check completeness !!!

C --------------------------------------
      RETURN
      END

      SUBROUTINE ORSTR_CIF(MDOC,IN,PATH,NAME,EXT,IERR)
C ----------------------------------------------------------------------------
      INTEGER   MDOC,IN,IERR
      CHARACTER NAME*(*),EXT*(*),PATH*(*)
C ------------------------------------------------------------
      INCLUDE 'crd_com.fh'
C --------------------------------------------------------------
C     CHARACTER LINE*256
C -------------------------------------------------------------------
      IERR = 0
      M    = 99
C -------------------------------------------------------------------
C     open file
      IERR = 0
      PATH = ' '
C     EXT  = 'str'
      CALL OPENFR(IN,M,PATH,NAME,EXT,IERR)
      CRS_IUN = IN
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: OPEN INPUT_FILE')
        RETURN
      ENDIF


Cdata_struct_list
Cloop_
C_atom_type.symbol
C_atom_type.scat_Cromer_Mann_a1
C_atom_type.scat_Cromer_Mann_a2
C_atom_type.scat_Cromer_Mann_a3
C_atom_type.scat_Cromer_Mann_a4
C_atom_type.scat_Cromer_Mann_b1
C_atom_type.scat_Cromer_Mann_b2
C_atom_type.scat_Cromer_Mann_b3
C_atom_type.scat_Cromer_Mann_b4
C_atom_type.scat_Cromer_Mann_c
C_atom_type.scat_dispersion_real
C_atom_type.scat_dispersion_imag
C_atom_type.radius_contact
C  N     12.21261   3.13220   2.01250   1.16630
C         0.00570   9.89331  28.99754   0.58260
C       -11.52901   0.00000   0.00000   1.70000
C  C      2.31000   1.02000   1.58860   0.86500
C        20.84392  10.20751   0.56870  51.65125
C         0.21560   0.00000   0.00000   1.90000
C  O      3.04850   2.28680   1.54630   0.86700
C        13.27711   5.70111   0.32390  32.90894
C         0.25080   0.00000   0.00000   1.40000
C  FE    11.76951   7.35731   3.52220   2.30450
C         4.76111   0.30720  15.35351  76.88058
C         1.03690   0.00000   0.00000   1.50000
C  S      6.90531   5.20341   1.43790   1.58630
C         1.46790  22.21512   0.25360  56.17207
C         0.86690   0.00000   0.00000   1.80000



      RETURN
      END

      SUBROUTINE RDSTR_CIF(MDOC,IN,MODE,IEND,IERR)
C -----------------------------------------------------------
C -P- RDSTR_CIF - 
C
      INTEGER IN,MDOC,IERR,IEND,MODE
C ******
C ------------------------------------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_C/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ------------------------------------------------------------
      INCLUDE 'crd_com.fh'
C -------------------------------------------------
      COMMON/COM_CRD_CIF/ IEND_CIF      
C ---
      INTEGER   IDATA
      REAL      FDATA
      CHARACTER DATA*80,ITEM*80
C --
      CHARACTER LINE*256
C --------------------------------------------------------------
      IERR = 0
      M    = 99      
      IF(IEND.EQ.-1) THEN
        REWIND IN
        IEND_CIF =-1
        IEND     = 0
      ENDIF

  300 CONTINUE   

      CALL GETCIF_C(IN,MDOC,IERR,IEND_CIF)
      IF(IERR.NE.0) THEN
        GO TO 1200
      ENDIF
      IF(IEND_CIF.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment
C   
        LINE=DT_CIF (NWORDSMAX)
        CALL LENSTR_BL(LINE,LEN)
        IF(LEN.LE.0.OR.LINE(1:1).EQ.'#'.OR.LINE(1:1).EQ.'C'.OR.
     *     LINE(1:1).EQ.'d'.OR.LINE(1:1).EQ.'c'.OR.
     *     LINE(1:1).EQ.'_') THEN
          MODE=1
          IF(LEN.LE.0) THEN
            LEN       = 1
            LINE(1:1) = '#'
          ENDIF
          CR_LINE = LINE(1:LEN)
          GO TO 500
        ENDIF
        GO TO 300 
      ELSE IF(IEND_CIF.NE.0) THEN
        GO TO 1300
      ENDIF

      IF(N_CIF.LE.0) GO TO 300
      IF(ITM_CIF(1)(1:13).NE.'_struct_atom.') GO TO 300

      IFLAG      = 0
      ST_IA      = 0
      ST_CHEM    = '.'
      ST_HBT     = '.'
      ST_PNUM    = '.'
      ST_IBACK   = 0
      ST_IFOR    = 0
      ST_IEXTR   = 0
      ST_IEXTR2  = 0
      ST_IEXTR3  = 0
      ST_ID_PSI  = '.'
      ST_DIST    = 0.0
      ST_THT     = 0.0
      ST_PSI     = 0.0
      ST_CHAR    = 0.0
      ST_VDW     = 0.0
      ST_ION     = 0.0

      DO I=1,N_CIF
        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM  = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA  = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IDATA = IDT_CIF(I)
        FDATA = FDT_CIF(I)

        IF(ITEM(1:13).EQ.'_struct_atom.') THEN

        IF(ITEM(14:26).EQ.'serial_number') THEN
          ST_IA      = IDATA
        ELSE IF(ITEM(14:22).EQ.'chem_type') THEN
          ST_CHEM    = DATA(1:4)
        ELSE IF(ITEM(14:26).EQ.'hydrogen_type') THEN
          ST_HBT     = DATA(1:1)
        ELSE IF(ITEM(14:23).EQ.'PDB_res_id') THEN
          ST_PNUM    = DATA
        ELSE IF(ITEM(14:17).EQ.'back') THEN
          ST_IBACK   = IDATA
        ELSE IF(ITEM(14:20).EQ.'forward') THEN
          ST_IFOR    = IDATA
        ELSE IF(ITEM(14:18).EQ.'extra') THEN
          ST_IEXTR   = IDATA
        ELSE IF(ITEM(14:18).EQ.'2extr') THEN
          ST_IEXTR2  = IDATA
        ELSE IF(ITEM(14:19).EQ.'psi_id') THEN
          ST_ID_PSI  = DATA(1:4)
        ELSE IF(ITEM(14:21).EQ.'distance') THEN
          ST_DIST    = FDATA
        ELSE IF(ITEM(14:18).EQ.'theta') THEN
          ST_THT     = FDATA
        ELSE IF(ITEM(14:16).EQ.'psi') THEN
          ST_PSI     = FDATA
        ELSE IF(ITEM(14:19).EQ.'charge') THEN
          ST_CHAR    = FDATA
        ELSE IF(ITEM(14:19).EQ.'radius') THEN
          ST_VDW     = FDATA
        ELSE IF(ITEM(14:23).EQ.'ion_radius') THEN
          ST_ION     = FDATA
        ENDIF

        ENDIF
      ENDDO


      MODE = 0

      WRITE(LINE,600)
     *       ST_IA,ST_HBT,ST_PNUM
     *      ,ST_IBACK,ST_IFOR,ST_IEXTR,ST_IEXTR2
     *      ,ST_ID_PSI,ST_DIST
     *      ,ST_THT,ST_PSI,ST_CHAR,ST_VDW
 600   FORMAT(I6,1X,A1,1X,A5
     *      ,4(1X,I6),1X,A4,3(1X,F7.2),2(1X,F6.2))

      CR_LINE = LINE

 500  CONTINUE
      CALL MSGDOC(MDOC,LINE)
C ---
      RETURN
1200  CONTINUE 
      CALL MSGERR(MDOC,' ERROR: read of file /str/')
      CLOSE(IN)
      IERR = 1
      RETURN
1300  CONTINUE 
      CLOSE(IN)
      IEND = 1
      RETURN
      END

      SUBROUTINE ORRST_CIF(MDOC,IN,PATH,NAME,EXT,IERR)
C ----------------------------------------------------------------------------
      INTEGER   MDOC,IN,IERR
      CHARACTER NAME*(*),EXT*(*),PATH*(*)
C ------------------------------------------------------------
      INCLUDE 'crd_com.fh'
C --------------------------------------------------------------
      CHARACTER CH7*7
C     CHARACTER LINE*256
C -------------------------------------------------------------------
      IERR = 0
      M    = 99
C -------------------------------------------------------------------
C     open file
      IERR = 0
      PATH = ' '
C     EXT  = 'rst'
      CALL OPENFR(IN,M,PATH,NAME,EXT,IERR)
      CRR_IUN = IN
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: OPEN INPUT_FILE')
        RETURN
      ENDIF
      READ(IN,'(A7)',END=100) CH7
      IF(CH7.EQ.'global_') THEN
        CR_FORM_RST = 'F'
        REWIND IN
      ELSE
        CLOSE(IN)
        CALL OPENUR(IN,M,PATH,NAME,EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERR: OPEN INPUT_FILE')
          RETURN
        ENDIF
        CR_FORM_RST = 'U'
      ENDIF

      RETURN
 100  CONTINUE
      IERR = 100
      RETURN
      END


      SUBROUTINE WRITE_STR(MDOC,PATH,NAMEC,EXT,IERR)
C ----------------------------------------------------------
C -P- WRITE_STR - 
C
C    MDOC   - mode of writting messages to DOC-file
C             0 - only terminal , < - 0 only file, 0 < < 99 - both
C             >= 99 - don't write  
C    NAMEC  - name of input file
C    IERR   - output signal of error / = 1 -error , = 0 - OK / 
C -I-
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'crd_com.fh'
C --------------
      INTEGER     MDOC,IERR
      CHARACTER   NAMEC*(*),PATH*(*),EXT*(*)
C ----------------------------------------------------------------
C     CHARACTER LINE*256
C==================================================================
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C --------
C     open output file
C
C     IN       = 16
      IN       = CRSO_IUN
C ---
c      CRSO_FILE = NAMEC
c      CRSO_PATH = PATH
c      CRSO_EXT  = EXT
C ---
      CALL OWSTR_CIF(MD,IN,PATH,NAMEC,EXT,IERR)
      CRSO_IUN = IN
      IF(IERR.EQ.1) THEN
        CALL MSGERR(MDOC,' ERROR: open output file /str/')
        RETURN
      ELSE IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: writing titles of output file /str/')
        RETURN
      ENDIF
C --------
      NATOM =  0
      IEND  = -1
C --------
      IF(N_ATOM.LE.0) THEN 
        CALL MSGERR(MDOC,' ERROR: number of atoms = 0')
        IERR=2
        RETURN
      ENDIF

      DO I=1,N_ATOM   

        ST_IA     = I
        ST_VDW    = VDW_RAD    (ST_IA) 
        ST_ION    = ION_RAD    (ST_IA) 
        ST_CHEM   = CHEM_TYPE  (ST_IA)     
        ST_HBT    = HB_TYPE    (ST_IA)      
        ST_IBACK  = IATM_BACK  (ST_IA)   
        ST_IFOR   = IATM_FOR   (ST_IA)    
        ST_IEXTR  = IATM_EXTR  (ST_IA)    
        ST_IEXTR2 = IATM_EXTR2 (ST_IA)    
        ST_IEXTR3 = IATM_EXTR3 (ST_IA)    
        ST_ID_PSI = ID_PSI     (ST_IA)   
        ST_DIST   = ATM_DIST   (ST_IA)     
        ST_THT    = ATM_THETA  (ST_IA)      
        ST_PSI    = ATM_PSI    (ST_IA)      
        ST_CHAR   = ATM_CHARGE (ST_IA)     
        IRES      = I_RESID    (I)
        ST_PNUM   = RES_NUM_PDB(IRES)(3:7)
C ----
        MODE = 0
        CALL WRSTR_CIF(M,IN,MODE,IEND,IERR)
        IF(IERR.NE.0) THEN
          RETURN
        ENDIF
C ----
      ENDDO
C --------------------------------------
C
C     close output file
C
      IENDW = 1
      MODE  = 0     
      CALL WRSTR_CIF(MDOC,IN,MODE,IENDW,IERR)

C --------------------------------------
      RETURN
      END

      SUBROUTINE OWSTR_CIF(MDOC,IUN,PATH,NAMEO,EXT,IERR)
C -P- 
C ----------------------------------------------------------------------------
C      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C ---
      INTEGER   MDOC,IUN,IERR
      CHARACTER NAMEO*(*),EXT*(*),PATH*(*)
C ----------------------------------
      CHARACTER LINE*256,CHAR4*4
C ------------------------------------------------------------
      INCLUDE 'CIF_items_crd.fh'
C ------------------------------------------------------------
      M     = 99
      IERR  = 0
      PI    = 4.0*ATAN(1.0)
      PI180 = PI/180.0
C ------------------------------------------------------------
C     open
C
      CALL LENSTR_BL(NAMEO,LEN)
      IF(LEN.GT.0.AND.NAMEO(1:1).NE.','.AND.NAMEO(1:1).NE.' ') THEN 
C       IUN = 16
        IUN = CRSO_IUN
        CALL OPENFW(IUN,M,PATH,NAMEO,EXT,IERR)
        CRSO_IUN = IUN
        IF(IERR.NE.0) THEN
          IERR=1  
          CALL MSGERR(MDOC,' ERROR: OPEN OUTPUT_FILE /str/ ')
          RETURN
        ENDIF
      ELSE
        IERR=1  
        CALL MSGERR(MDOC,' ERROR: WRONG NAME OF OUTPUT_FILE /str/')
        RETURN
      ENDIF
C -------------------------------------------------------
        WRITE(LINE,'(''global_'')') 
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        WRITE(LINE,'(''_entry.id   '',6X,A)') CR_CD_PDB(1:4)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        CALL LENSTR_BL(CR_NAME_PDB,LEN)
        IF(LEN.LE.0) THEN
          CR_NAME_PDB='-'
          LEN=1
        ENDIF
        WRITE(LINE,100) CR_NAME_PDB(1:LEN)
  100   FORMAT('_struct.keywords   ',1X,'''',A,'''')
        WRITE(LINE,'(''_audit.creation_date   '',1X,A)') 
     *  CR_DATE_PDB(1:9)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        CALL LENSTR_BL(CR_TITLE,LEN)
        IF(LEN.LE.0) THEN
          CR_TITLE='-'
          LEN=1
        ENDIF
        IF(LEN.GT.58) LEN=58
        WRITE(LINE,200) CR_TITLE(1:LEN)
  200   FORMAT('_struct.title ',1X,'''',A,'''')

C        WRITE(LINE,'(''_lib.name   '',2X,A)') LB_NAME(1:16)
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C
C        WRITE(LINE,'(''_lib.version'',2X,A)') LB_VERS(1:16)
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C
C        WRITE(LINE,'(''_lib.update '',2X,A)') LB_DATE(1:16)
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C
C        WRITE(LINE
C     *  ,'(''# ------------------------------------------------'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''#'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''data_struct_list'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

c        IF(LSF_NASYMB.GT.0) THEN
        IF(CS_NSFATM.GT.0) THEN
          WRITE(LINE,'(''loop_'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_atom_type.symbol'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_atom_type.scat_Cromer_Mann_a1'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_atom_type.scat_Cromer_Mann_a2'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_atom_type.scat_Cromer_Mann_a3'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_atom_type.scat_Cromer_Mann_a4'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_atom_type.scat_Cromer_Mann_b1'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_atom_type.scat_Cromer_Mann_b2'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_atom_type.scat_Cromer_Mann_b3'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_atom_type.scat_Cromer_Mann_b4'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_atom_type.scat_Cromer_Mann_c'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_atom_type.scat_dispersion_real'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_atom_type.scat_dispersion_imag'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_atom_type.radius_contact'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          ICOUNT = 0
          DO I=1,CS_NSFATM
            CHAR4 = CS_ELEMENT(I)
            IF(CHAR4(1:1).EQ.'?') THEN
              CHAR4=CS_ATYPE(I)
            ENDIF
 610        CONTINUE
            CALL GET_SFA(CHAR4
     *      ,N,NELC,A1,A2,A3,A4,B1,B2,B3,B4,CC,FI,FII,RAD,IERR)
            IF(IERR.NE.0.AND.IERR.NE.2) THEN
              IF(ICOUNT.LT.4) THEN
                WRITE(LINE,*) 
     *          ' WARNING : atom"s type "',CHAR4,'" not found'
                CALL MSGDOC(MDOC,LINE)
                ICOUNT = ICOUNT+1
              ELSE IF(ICOUNT.EQ.4) THEN
                CALL MSGDOC(MDOC,'   ... more ...')
                ICOUNT = ICOUNT+1
              ENDIF
              IERR = 0
              IF(ICOUNT.LE.4) THEN
                WRITE(LINE,*) 
     *          ' WARNING : default type  is "N   ".'
                CALL MSGDOC(MDOC,LINE)
              ENDIF
              CHAR4 = 'N   '
              GO TO 610
            ENDIF
            IERR         = 0
            CS_A   (1,I) = A1
            CS_A   (2,I) = A2
            CS_A   (3,I) = A3
            CS_A   (4,I) = A4
            CS_B   (1,I) = B1
            CS_B   (2,I) = B2
            CS_B   (3,I) = B3
            CS_B   (4,I) = B4
            CS_C     (I) = CC
            CS_FI    (I) = FI
            CS_FII   (I) = FII
            CS_RADIUS(I) = RAD
            CS_NELEC (I) = NELC
          ENDDO

          DO   I=1,CS_NSFATM
            WRITE(LINE,'(2X,A4,4(1X,F9.5))')
     *      CS_ELEMENT(I),CS_A(1,I),CS_A(2,I),CS_A(3,I),CS_A(4,I)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            WRITE(LINE,'(2X,4X,4(1X,F9.5))')
     *      CS_B(1,I),CS_B(2,I),CS_B(3,I),CS_B(4,I)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            WRITE(LINE,'(2X,4X,4(1X,F9.5))')
     *      CS_C(I),CS_FI(I),CS_FII(I),CS_RADIUS(I)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
          ENDDO
C          IF(LSF_NASYMB.GT.0) THEN
C          DO   I=1,LSF_NASYMB
C            WRITE(LINE,'(2X,A4,4(1X,F9.5))')
C     *      LSF_ATOM(I),LSF_A1(I),LSF_A2(I),LSF_A3(I),LSF_A4(I)
C            CALL WRTSTR(IUN,MDOC,LINE,IERR)
C            WRITE(LINE,'(2X,4X,4(1X,F9.5))')
C     *      LSF_B1(I),LSF_B2(I),LSF_B3(I),LSF_B4(I)
C            CALL WRTSTR(IUN,MDOC,LINE,IERR)
C            WRITE(LINE,'(2X,4X,4(1X,F9.5))')
C     *      LSF_C(I),LSF_FI(I),LSF_FII(I),LSF_RAD(I)
C            CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          ENDDO
C          ENDIF
        ENDIF
C ------------------------------------------
        WRITE(LINE,'(''loop_'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_struct_atom.serial_number'')')
c        CALL WRTSTR(IUN,MDOC,LINE,IERR)
c        WRITE(LINE,'(''_struct_atom.chem_type'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
c        WRITE(LINE,'(''_struct_atom.chem_type_number'')')
c        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_struct_atom.hydrogen_type'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_struct_atom.PDB_res_id'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_struct_atom.back'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_struct_atom.forward'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_struct_atom.extra'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_struct_atom.2extra'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_struct_atom.psi_id'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_struct_atom.distance'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_struct_atom.theta'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_struct_atom.psi'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_struct_atom.charge'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_struct_atom.radius'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_struct_atom.ion_radius'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

      RETURN
C -------------------------
C 1000 CONTINUE
C      IUN = CRSO_IUN
C      CLOSE(IUN,ERR=1010)
C 1010 CONTINUE
C      RETURN
      END

      SUBROUTINE WRSTR_CIF(MDOC,IOUT,MODE,IEND,IERR)
C ----------------------------------------------------------
C 
C
      INTEGER IOUT,MDOC,IERR,IEND,MODE
C ******
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C ------------------------------------------------------------
      CHARACTER LINE*256,CHAR4*4
C ------------------------------------------------------------
      IERR=0
      
      IF(IEND.LE.0) THEN

        IF(MODE.EQ.0) THEN

          CHAR4 = ST_CHEM  
          CALL LENSTR_BL(CHAR4,LEN)
          IF(LEN.LE.0) CHAR4 = '.'
          IF(ST_HBT   .EQ.' ') ST_HBT    = '.'
          IF(ST_ID_PSI.EQ.' ') ST_ID_PSI = '.'

c          WRITE(LINE,300)
c     *     ST_IA,CHAR4,ST_HBT,ST_PNUM
c     *    ,ST_IBACK,ST_IFOR,ST_IEXTR
c     *    ,ST_ID_PSI,ST_DIST
c     *    ,ST_THT,ST_PSI,ST_VDW,ST_ION
cC    *    ,ST_THT,ST_PSI,ST_CHAR,ST_VDW
c 300      FORMAT(I5,1X,A4,1X,A1,1X,A5
c     *      ,3(1X,I5),1X,A4,3(1X,F7.2),2(1X,F6.2))

          WRITE(LINE,300)
     *     ST_IA,ST_HBT,ST_PNUM
     *    ,ST_IBACK,ST_IFOR,ST_IEXTR,ST_IEXTR2
     *    ,ST_ID_PSI,ST_DIST
     *    ,ST_THT,ST_PSI,ST_VDW,ST_ION
C    *    ,ST_THT,ST_PSI,ST_CHAR,ST_VDW
 300      FORMAT(I6,1X,A1,1X,A5
     *      ,4(1X,I6),1X,A4,3(1X,F7.2),2(1X,F6.2))
          IF(IOUT.GT.0) THEN
            CALL WRTSTR(IOUT,MDOC,LINE,IERR)
            IF(IERR.NE.0) THEN
              GO TO 200
            ENDIF
          ENDIF

        ELSE
C
C         write comments
C
          IF(IOUT.GT.0) THEN
            CALL LENSTR_BL(CR_LINE,LEN)
            LINE = CR_LINE        
            CALL WRTSTR(IOUT,MDOC,LINE,IERR)
            IF(IERR.NE.0) THEN
              GO TO 200
            ENDIF
          ENDIF

        ENDIF

        IF(IERR.GT.0) GO TO 200
C ---
      ELSE

        IF(IOUT.GT.0) THEN

          END FILE IOUT

          CLOSE(IOUT,ERR=210)

        ENDIF

      ENDIF
 210  CONTINUE
      RETURN
C -----------------------------------------------
 200  CONTINUE 
      CALL MSGERR(MDOC,' ERROR: WRITE TO OUTPUT FILE /str/')

      CLOSE(IOUT,ERR=220)

 220  CONTINUE
      IERR=4
      RETURN
      END


C ******
      SUBROUTINE RDRST_CIF(MDOC,IN,MODE,IEND,IERR)
C
C -P- RDRST_CIF - reads restraints 
C
      INTEGER IN,MDOC,IERR,IEND,MODE
C ******
C ------------------------------------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_C/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ------------------------------------------------------------
      INCLUDE 'crd_com.fh'
C -------------------------------------------------
      COMMON/COM_CRD_CIF/ IEND_CIF      
C ---
      INTEGER   IDATA
      REAL      FDATA
      CHARACTER DATA*80,ITEM*80
C --
      CHARACTER LINE*256
C --------------------------------------------------------------
      IERR = 0
      M    = 99      
      IF(IEND.EQ.-1) THEN
        REWIND IN
        IEND_CIF =-1
        IEND     = 0
      ENDIF

      IF(CR_FORM_RST.EQ.'U') GO TO 700

  300 CONTINUE   
      CALL GETCIF_C(IN,MDOC,IERR,IEND_CIF)
      IF(IERR.NE.0) THEN
        GO TO 1200
      ENDIF
      IF(IEND_CIF.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment
C   
        LINE=DT_CIF (NWORDSMAX)
        CALL LENSTR_BL(LINE,LEN)
        IF(LEN.LE.0.OR.LINE(1:1).EQ.'#'.OR.LINE(1:1).EQ.'C'.OR.
     *     LINE(1:1).EQ.'d'.OR.LINE(1:1).EQ.'c'.OR.
     *     LINE(1:1).EQ.'_') THEN
          MODE=1
          IF(LEN.LE.0) THEN
            LEN       = 1
            LINE(1:1) = '#'
          ENDIF
          CR_LINE = LINE(1:LEN)
          GO TO 500
        ENDIF
        GO TO 300 
      ELSE IF(IEND_CIF.NE.0) THEN
        GO TO 1300
      ENDIF

      IF(N_CIF.LE.0) GO TO 300
      IF(ITM_CIF(1)(1:7).NE.'_restr.') GO TO 300

      IFLAG=0

      DO I=1,N_CIF
        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IDATA=IDT_CIF(I)
        FDATA=FDT_CIF(I)

        IF(ITEM(1:7).EQ.'_restr.') THEN

        IF(ITEM(8:13).EQ.'record') THEN
          RS_NAME  = DATA(1:LEND)
        ELSE IF(ITEM(8:13).EQ.'number') THEN
          RS_NUM   = IDATA
        ELSE IF(ITEM(8:12).EQ.'label') THEN
          RS_LABEL = DATA(1:LEND)
        ELSE IF(ITEM(8:13).EQ.'period') THEN
          RS_PRD   = IDATA
        ELSE IF(ITEM(8:16).EQ.'atom_id_1') THEN
          RS_IA1   = IDATA
        ELSE IF(ITEM(8:16).EQ.'atom_id_2') THEN
          RS_IA2   = IDATA
        ELSE IF(ITEM(8:16).EQ.'atom_id_3') THEN
          RS_IA3   = IDATA
        ELSE IF(ITEM(8:16).EQ.'atom_id_4') THEN
          RS_IA4   = IDATA
        ELSE IF(ITEM(8:12).EQ.'value') THEN
          RS_VIDL  = FDATA
        ELSE IF(ITEM(8:10).EQ.'dev') THEN
          RS_SDI   = FDATA
        ELSE IF(ITEM(8:14).EQ.'val_obs') THEN
          RS_VOBS  = FDATA
        ELSE IF(ITEM(8:15).EQ.'dist_dev') THEN
          RS_DESD  = FDATA
        ELSE IF(ITEM(8:11).EQ.'dist') THEN
          RS_DIST  = FDATA
        ELSE IF(ITEM(8:13).EQ.'econst') THEN
          RS_CNS   = FDATA
        ENDIF

        ENDIF
      ENDDO

      IF(RS_NAME.EQ.'MONO'.OR.RS_NAME.EQ.'LINK') THEN
        RS_SOURCE    = RS_NAME
        RS_SOURCE_ID = RS_LABEL
        GO TO 300
      ENDIF

      MODE=0

      WRITE(LINE,600) RS_NAME,RS_NUM,RS_LABEL,RS_PRD
     *  ,RS_IA1,RS_IA2
     *  ,RS_IA3,RS_IA4,RS_VIDL,RS_SDI,RS_VOBS
 600    FORMAT(A4,1X,I6,1X,A8,1X,I1,1X,I6,1X,I6,1X,I6,1X,I6
     *        ,1X,F8.3,1X,F8.3,1X,F8.3)

      CR_LINE=LINE

 500  CONTINUE

C      CALL MSGDOC(MDOC,LINE)
C ---
      RETURN
C -----------------------------------
 700  CONTINUE

      MODE=0 
      READ(IN,ERR=1200,END=710) RS_NAME,RS_NUM,RS_LABEL,RS_PRD
     *  ,RS_IA1,RS_IA2,RS_IA3,RS_IA4
     *  ,RS_VIDL,RS_SDI,RS_VOBS
     *  ,RS_DIST,RS_DESD,RS_CNS

      IF(RS_NAME.EQ.'MONO'.OR.RS_NAME.EQ.'LINK') THEN
        RS_SOURCE    = RS_NAME
        RS_SOURCE_ID = RS_LABEL
        GO TO 700
      ENDIF

C      WRITE(LINE,600) RS_NAME,RS_NUM,RS_LABEL,RS_PRD
C     *  ,RS_IA1,RS_IA2
C     *  ,RS_IA3,RS_IA4,RS_VIDL,RS_SDI,RS_VOBS
C
Cc      CALL MSGDOC(MDOC,LINE)

      IEND_CIF = 0
      IEND     = 0
      RETURN
C ---
 710  CONTINUE  
      IEND_CIF = 1
      GO TO 1300
C -----------------------------------
1200  CONTINUE 
      CALL MSGERR(MDOC,' ERR: READ OF FILE /rst/')
      CLOSE(IN)
      IERR=1
      RETURN
1300  CONTINUE 
      CLOSE(IN)
      IEND=1
      RETURN
      END

      SUBROUTINE ORVDW_CIF(MDOC,IN,PATH,NAME,EXT,IERR)
C ----------------------------------------------------------------------------
      INTEGER   MDOC,IN,IERR
      CHARACTER NAME*(*),EXT*(*),PATH*(*)
C ------------------------------------------------------------
      INCLUDE 'crd_com.fh'
C --------------------------------------------------------------
C     CHARACTER LINE*256
C -------------------------------------------------------------------
      IERR = 0
      M    = 99
C -------------------------------------------------------------------
C     open file
      IERR = 0
      PATH = ' '
C     EXT  = 'vdw'
      CALL OPENFR(IN,M,PATH,NAME,EXT,IERR)
      CRV_IUN = IN
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: OPEN INPUT_FILE')
        RETURN
      ENDIF
      RETURN
      END

C ******
      SUBROUTINE RDVDW_CIF(MDOC,IN,MODE,IEND,IERR)
C
C -P- RDVDW_CIF - reads VDW_restraints 
C
      INTEGER IN,MDOC,IERR,IEND,MODE
C ******
C ------------------------------------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_C/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ------------------------------------------------------------
      INCLUDE 'crd_com.fh'
C -------------------------------------------------
      COMMON/COM_CRD_CIF/ IEND_CIF      
C ---
      INTEGER   IDATA
      REAL      FDATA
      CHARACTER DATA*80,ITEM*80
C --
      CHARACTER LINE*256
C --------------------------------------------------------------
      IERR = 0
      M    = 99      
      IF(IEND.EQ.-1) THEN
        REWIND IN
        IEND_CIF =-1
        IEND     = 0
      ENDIF

  300 CONTINUE   
      CALL GETCIF_C(IN,MDOC,IERR,IEND_CIF)
      IF(IERR.NE.0) THEN
        GO TO 1200
      ENDIF
      IF(IEND_CIF.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment
C   
        LINE=DT_CIF (NWORDSMAX)
        CALL LENSTR_BL(LINE,LEN)
        IF(LEN.LE.0.OR.LINE(1:1).EQ.'#'.OR.LINE(1:1).EQ.'C'.OR.
     *     LINE(1:1).EQ.'d'.OR.LINE(1:1).EQ.'c'.OR.
     *     LINE(1:1).EQ.'_') THEN
          MODE=1
          IF(LEN.LE.0) THEN
            LEN=1
            LINE(1:1)='#'
          ENDIF
          CR_LINE=LINE(1:LEN)
          GO TO 500
        ENDIF
        GO TO 300 
      ELSE IF(IEND_CIF.NE.0) THEN
        GO TO 1300
      ENDIF

      IF(N_CIF.LE.0) GO TO 300
      IF(ITM_CIF(1)(1:7).NE.'_restr.') GO TO 300

      IFLAG=0

      DO I=1,N_CIF
        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM  = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA  = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IDATA = IDT_CIF(I)
        FDATA = FDT_CIF(I)

        IF(ITEM(1:7).EQ.'_restr.') THEN

        IF(ITEM(8:13).EQ.'record') THEN
          RSV_NAME  = DATA(1:LEND)
        ELSE IF(ITEM(8:13).EQ.'number') THEN
          RSV_NUM   = IDATA
        ELSE IF(ITEM(8:16).EQ.'atom_id_1') THEN
          RSV_IA1   = IDATA
        ELSE IF(ITEM(8:16).EQ.'atom_id_2') THEN
          RSV_IA2   = IDATA
        ELSE IF(ITEM(8:14).EQ.'rad_min') THEN
          RSV_RIDL  = FDATA
        ELSE IF(ITEM(8:14).EQ.'rad_obs') THEN
          RSV_ROBS   = FDATA
        ELSE IF(ITEM(8:13).EQ.'econst') THEN
          RSV_CNS    = FDATA
        ELSE IF(ITEM(8:11).EQ.'type') THEN
          RSV_TYPE   = DATA
        ELSE IF(ITEM(8:12).EQ.'hflag') THEN
          RSV_HFLAG  = DATA
        ELSE IF(ITEM(8:15).EQ.'symmetry') THEN
          RSV_SYMM   = DATA
        ENDIF

        ENDIF
      ENDDO


      MODE=0
      WRITE(LINE,600) RSV_NAME,RSV_NUM,RSV_SYMM
     *  ,RSV_IA1,RSV_IA2
     *  ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_TYPE,RSV_HFLAG
 600    FORMAT(A4,1X,I6,1X,A8,1X,I6,1X,I6
     *        ,1X,F8.3,1X,F8.3,1X,F8.3,1X,A1,1X,A1)

      CR_LINE=LINE

 500  CONTINUE
      CALL MSGDOC(MDOC,LINE)
C ---
      RETURN
1200  CONTINUE 
      CALL MSGERR(MDOC,' ERR: READ OF FILE /vdw/')
      CLOSE(IN)
      IERR=1
      RETURN
1300  CONTINUE 
      CLOSE(IN)
      IEND=1
      RETURN
      END

C ******
      SUBROUTINE RDCRD_CSD(MDOC,IN,MODE,IEND,IERR)
C
C -P- RDCRD_CIF - reads coordinates 
C
      INTEGER IN,MDOC,IERR,IEND,MODE
C ******
C ------------------------------------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C -----------------------------------------------------------
      INCLUDE 'crd_com.fh'
C ---------------------------------------------------------------
      COMMON/COM_CRD_CIF/ IEND_CIF      
C
      COMMON/COM_CRD_CIF_SAVE/ LC,LI,LA,LS,LN,LNA,LSM,LAL,LR,LCL,LM,LBF
     *                        ,L11,L22,L33,L12,L13,L23,LCR,LX1,LX2,LX3
     *                        ,LS1,LS2,LS3,LO,LSO,LB,LSB,LAA,LAC
C ---------------------------------------------------------------
      INTEGER   IDATA
      REAL      FDATA
      CHARACTER DATA*80,ITEM*80
C --
      REAL      X(3)
      CHARACTER LINE*256
      CHARACTER BFLAG*1,MULT*2,ASYMB*4,CH5*5,TYPE*1,ENT*4
C --------------------------------------------------------------
      INCLUDE 'CIF_items_crd.fh'
C ------------------------------------------------------------
      IERR = 0
      M    = 99      
      IF(IEND.EQ.-1) THEN
C       first call
        REWIND IN
        IEND_CIF = -1
        CR_IATOM =  0
        IEND     =  0

        CALL LENSTR_BL(ITA_ATOM_CAT,LC) 
        CALL LENSTR_BL(ITA_IATOM    ,LI ) 
        CALL LENSTR_BL(ITA_ATOM     ,LA ) 
        CALL LENSTR_BL(ITA_SYMB     ,LS ) 
        CALL LENSTR_BL(ITA_ISEQ     ,LN ) 
        CALL LENSTR_BL(ITA_ATOM_CHEM,LAC) 
        CALL LENSTR_BL(ITA_ATOM_AUTH,LAA) 
        CALL LENSTR_BL(ITA_SEQ_AUTH ,LNA) 
        CALL LENSTR_BL(ITA_ASYM     ,LSM) 
        CALL LENSTR_BL(ITA_ALT      ,LAL) 
        CALL LENSTR_BL(ITA_RES      ,LR ) 
        CALL LENSTR_BL(ITA_CALC     ,LCL) 
        CALL LENSTR_BL(ITA_MULT     ,LM ) 
        CALL LENSTR_BL(ITA_B_FLAG   ,LBF) 
        CALL LENSTR_BL(ITA_ANISO_U11,L11) 
        CALL LENSTR_BL(ITA_ANISO_U22,L22) 
        CALL LENSTR_BL(ITA_ANISO_U33,L33) 
        CALL LENSTR_BL(ITA_ANISO_U12,L12) 
        CALL LENSTR_BL(ITA_ANISO_U13,L13) 
        CALL LENSTR_BL(ITA_ANISO_U23,L23) 
        CALL LENSTR_BL(ITA_ID_CORR  ,LCR) 
        CALL LENSTR_BL(ITA_XYZ_CRD1 ,LX1) 
        CALL LENSTR_BL(ITA_XYZ_CRD2 ,LX2) 
        CALL LENSTR_BL(ITA_XYZ_CRD3 ,LX3) 
        CALL LENSTR_BL(ITA_SD_CRD1  ,LS1) 
        CALL LENSTR_BL(ITA_SD_CRD2  ,LS2) 
        CALL LENSTR_BL(ITA_SD_CRD3  ,LS3) 
        CALL LENSTR_BL(ITA_OCCUP    ,LO ) 
        CALL LENSTR_BL(ITA_SD_OCC   ,LSO) 
        CALL LENSTR_BL(ITA_B_ISO    ,LB ) 
        CALL LENSTR_BL(ITA_SD_ISO   ,LSB) 
      ENDIF

  300 CONTINUE   

      CALL GETCIF_INFO(IN,MDOC,IERR,IEND_CIF)
      IF(IERR.NE.0) THEN
        GO TO 1200
      ENDIF

      IF(IEND_CIF.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment
C   
        LINE=DT_CIF (NWORDSMAX)
        CALL LENSTR_BL(LINE,LEN)

        IF(LEN.LE.0.OR.LINE(1:1).EQ.'#'.OR.LINE(1:1).EQ.'C'.OR.
     *     LINE(1:1).EQ.'d'.OR.LINE(1:1).EQ.'c'.OR.
     *     LINE(1:1).EQ.'_') THEN
          MODE=1
          IF(LEN.LE.0) THEN
            LEN       = 1
            LINE(1:1) = '#'
          ENDIF
          CR_LINE = LINE(1:LEN)
          GO TO 500
        ENDIF
        GO TO 300 
      ELSE IF(IEND_CIF.NE.0) THEN
C       end of file
C ? close
        GO TO 1300
      ENDIF

      IF(N_CIF.LE.0) GO TO 300

C      CALL LENSTR_BL(ITA_ATOM_CAT,LC) 

      IF((ITM_CIF(1)(1:11).NE.'_atom_site_'     ).AND.
     *   (ITM_CIF(1)(1:16).NE.'_ccdc_atom_site_').AND.
     *   (ITM_CIF(1)(1:LC).NE.ITA_ATOM_CAT(1:LC))     ) THEN

c        IF(CR_IATOM.GT.0) THEN
c          GO TO 1300
c        ELSE
          GO TO 300
c        ENDIF

      ENDIF
C --- _atom_site ---

      CR_ANAME     = '.   '
      CR_ASYMB     = '.   '
      CR_RNAME     = '.  '
      CR_PNUM      = '.      '       
      CR_BTYPE     = '.'
      CR_ATYPE     = '.'
      CR_CORR      = '.'
      CR_IATOLD    = 0
      CR_IGROUP    = 0
      CR_SF_ID     = 0
      CR_GROUP     = '.   '
      CR_MULT_FLAG = 1
      CR_IRES      = 0
      IFLAG        = 0
      IFLAG_AUTH   = 0
      IFLAG_ISEQ   = 0
      IFLAG_IASM   = 0
      IFLAG_IENT   = 0
      ENT          = '.'      
      IFRAC        = 0

      DO I=1,N_CIF

        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM  = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA  = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IDATA = IDT_CIF(I)
        FDATA = FDT_CIF(I)

        LC1 = LC + 1
 
        IF((ITEM(LC1:LC+11).EQ.'atom_number'  ).OR.
     *     (ITEM(LC1:LI+LC).EQ.ITA_IATOM(1:LI))    ) THEN
          CR_IATOLD=IDATA
        ELSE IF((ITEM(LC1:LA+LC).EQ.ITA_ATOM(1:LA) ).OR.
     *          (ITEM(1:LENI).EQ.'_atom_site_label')    ) THEN
          CR_ANAME(1:LEND)=DATA(1:LEND)
        ELSE IF((ITEM(LC1:LS+LC).EQ.ITA_SYMB(1:LS)        ).OR.
     *          (ITEM(1:LENI).EQ.'_atom_site_type_symbol')    ) THEN
          CR_ASYMB(1:LEND) = DATA(1:LEND)
          IT = 1
C
C         IT = 1  convert symbols to upper case.
C                   
          CALL CHECK_LINE(IT,CR_ASYMB)
        ELSE IF((ITEM(LC1:20 ).EQ.'atom_type'       ).OR.
     *          (ITEM(LC1:LCL+LC).EQ.ITA_CALC(1:LCL))    ) THEN
          CR_ATYPE=DATA(1:1)
        ELSE IF(ITEM(LC1:LAL+LC).EQ.ITA_ALT(1:LAL)) THEN
          CR_ALT=DATA(1:1)
        ELSE IF((ITEM(LC1:24 ).EQ.'label_corr_id'       ).OR.
     *          (ITEM(LC1:LCR+LC).EQ. ITA_ID_CORR(1:LCR))) THEN
          CR_CORR=DATA(1:1)
        ELSE IF((ITEM(LC1:23).EQ.'label_res_id'  ).OR.
     *          (ITEM(LC1:LR+LC).EQ.ITA_RES(1:LR))) THEN
C                                 label_comp_id            
          CR_RNAME(1:LEND)=DATA(1:LEND)
        ELSE IF(ITEM(LC1:LN+LC).EQ.ITA_ISEQ(1:LN)) THEN

          CR_IRES    = IDATA
          IFLAG_ISEQ = 1
          
        ELSE IF(ITEM(LC1:LN+LC).EQ.ITA_SEQ_AUTH(1:LNA)) THEN
C
C    _atom_site.auth_seq_id

          IF(LEND.GT.0) THEN
            CH5 = '     '
            J   = 5
            DO K = 5,1,-1
              IF(DATA(K:K).NE.' ') THEN
                CH5(J:J) = DATA(K:K) 
                J = J -1
              ENDIF
            ENDDO
            CALL CHKSMB(CH5(5:5),TYPE)              
            IF(TYPE.EQ.'D') THEN
              DO K=2,5
                CH5(K-1:K-1) = CH5(K:K)
              ENDDO 
              CH5(5:5) = ' '
            ENDIF
          ENDIF

          CR_PNUM(3:7) = CH5
          IFLAG_AUTH   = 1

        ELSE IF((ITEM(LC1:26 ).EQ.'label_entity_id' ).OR.
     *          (ITEM(LC1:24 ).EQ.'label_asym_id'   ).OR. 
     *          (ITEM(LC1:LSM+LC).EQ.ITA_ASYM(1:LSM))) THEN
          CR_GROUP = DATA(1:LEND)
        ELSE IF(ITEM(LC1:26 ).EQ.'label_entity_id' ) THEN
         IFLAG_IENT = 1
         ENT        = DATA(1:LEND) 
        ELSE IF(ITEM(LC1:LSM+LC).EQ.ITA_ASYM(1:LSM)) THEN
C                                    label_asym_id'   
          IFLAG_IASM = 1
          CR_GROUP   = DATA(1:LEND)
        ELSE IF((ITEM(LC1:LENI).EQ.ITA_XYZ_CRD1(1:LX1)).OR.
     *          (ITEM(LC1:LENI).EQ.ITA_XYZ_CRD4(1:LX1))    ) THEN
          CR_XYZ(1)=FDATA
        ELSE IF((ITEM(LC1:LENI).EQ.ITA_XYZ_CRD2(1:LX2)).OR.
     *          (ITEM(LC1:LENI).EQ.ITA_XYZ_CRD5(1:LX1))    ) THEN
          CR_XYZ(2)=FDATA
        ELSE IF((ITEM(LC1:LENI).EQ.ITA_XYZ_CRD3(1:LX3)).OR.
     *          (ITEM(LC1:LENI).EQ.ITA_XYZ_CRD6(1:LX1))    ) THEN
          CR_XYZ(3)=FDATA
        ELSE IF(ITEM(1:LENI).EQ.'_atom_site_fract_x') THEN
          IFRAC = 1
          CR_XYZ(1)=FDATA
        ELSE IF(ITEM(1:LENI).EQ.'_atom_site_fract_y') THEN
          IFRAC = 1
          CR_XYZ(2)=FDATA
        ELSE IF(ITEM(1:LENI).EQ.'_atom_site_fract_z') THEN
          IFRAC = 1
          CR_XYZ(3)=FDATA
        ELSE IF(ITEM(LC1:LENI).EQ.ITA_OCCUP(1:LO)) THEN
          CR_OCC   = FDATA
        ELSE IF(ITEM(LC1:LENI).EQ.ITA_B_ISO(1:LB)) THEN
          CR_BISO  = FDATA
        ELSE IF(ITEM(LC1:LBF+LC).EQ.ITA_B_FLAG(1:LBF)) THEN
          CR_BTYPE = '.' 
          IF(DATA(1:4).EQ.'Uani'.OR.DATA(1:1).EQ.'A'
     *                          .OR.DATA(1:1).EQ.'a') CR_BTYPE = 'A'
        ELSE IF(ITEM(LC1:LM+LC).EQ.ITA_MULT(1:LM)) THEN
          IF(DATA(1:1).EQ.'.') THEN
            CR_MULT_FACTOR=1
          ELSE
            CR_MULT_FACTOR=IDATA
          ENDIF
        ELSE IF(ITEM(LC1:L11+LC).EQ.ITA_ANISO_U11(1:L11)) THEN
          CR_BTYPE     = 'A'
          CR_FLAG_USER = 'A'
          CR_ANIS(1)   = FDATA
        ELSE IF(ITEM(LC1:L22+LC).EQ.ITA_ANISO_U22(1:L22)) THEN
          CR_BTYPE     = 'A'
          CR_FLAG_USER = 'A'
          CR_ANIS(2)   = FDATA
        ELSE IF(ITEM(LC1:L33+LC).EQ.ITA_ANISO_U33(1:L33)) THEN
          CR_BTYPE     = 'A'
          CR_FLAG_USER = 'A'
          CR_ANIS(3)   = FDATA
        ELSE IF(ITEM(LC1:L12+LC).EQ.ITA_ANISO_U12(1:L12)) THEN
          CR_BTYPE     = 'A'
          CR_FLAG_USER = 'A'
          CR_ANIS(4)   = FDATA
        ELSE IF(ITEM(LC1:L13+LC).EQ.ITA_ANISO_U13(1:L13)) THEN
          CR_BTYPE     = 'A'
          CR_FLAG_USER = 'A'
          CR_ANIS(5)   = FDATA
        ELSE IF(ITEM(LC1:L23+LC).EQ.ITA_ANISO_U23(1:L23)) THEN
          CR_BTYPE     = 'A'
          CR_FLAG_USER = 'A'
          CR_ANIS(6)   = FDATA
        ENDIF

      ENDDO

      MODE = 0

c      IF(CR_IATOLD.LE.0) GO TO 300

      CR_IATOM  = CR_IATOM+1
      CR_IRES   = 1
      IT        = 1
      CALL CHECK_LINE(IT,CR_ASYMB)


      IF(IFLAG_AUTH.EQ.0) THEN
        WRITE(CR_PNUM(3:6),'(I4)') CR_IRES       
        CR_PNUM(7:7) = ' '
      ENDIF

      IF(IFLAG_ISEQ.EQ.0) THEN
        READ(CR_PNUM(3:6),'(I4)') CR_IRES       
      ENDIF

      CR_PNUM(1:2) = CR_GROUP(1:2)

      IF(IFLAG_IASM.LE.0) THEN
        CR_GROUP = ENT
      ENDIF

      IF(IFRAC.GT.0) THEN
        X(1) = CR_XYZ(1)
        X(2) = CR_XYZ(2)
        X(3) = CR_XYZ(3)
        CALL NB_FTOO(X,CR_XYZ,IERR)
      ENDIF

      CR_RNAME     = 'C00'
      CR_IGROUP    = 1
      CR_GROUP     = 'AA  '
      CR_MULT_FLAG = 1
      CR_IRES      = 1
      READ(CR_PNUM(3:6),'(I4)') CR_IRES       
      CR_PNUM(1:2) = 'AA'
      CR_PNUM(7:7) = ' '
      CR_IATOLD    = CR_IATOM
      CR_OCC       = 1.0
      CR_BISO      = 20.0
C ---
C     print 
C
      BFLAG='.'
      IF(CR_BTYPE.EQ.'A') BFLAG='A'

      IF(CR_MULT_FACTOR.GT.1) THEN
        I = CR_MULT_FACTOR
        IF(I.GT.99) I = 99
        IF(I.LT.0 ) I = 0
        WRITE(MULT,'(I2)') I
      ELSE
        MULT = '. '
      ENDIF

      ASYMB      = CR_ASYMB
      ST_CHEM    = CR_ASYMB

      WRITE(LINE,100)
     *    CR_IATOLD,CR_ANAME,ASYMB,CR_ATYPE
     *   ,CR_ALT,CR_CORR
     *   ,CR_RNAME,CR_IRES,CR_GROUP(1:2)
     *   ,CR_XYZ(1),CR_XYZ(2),CR_XYZ(3)
     *   ,CR_OCC,CR_BISO,BFLAG,MULT

  100     FORMAT(I6,1X,A4,1X,A4,1X,A1,1X,A1,1X,A1,1X,A3,1X 
     *    ,I4,1X,A,1X,F8.3,1X,F8.3,1X,F8.3,1X,F6.2,1X,F6.2
     *    ,1X,A1,1X,A2)
      CR_LINE=LINE
C ---   
 500  CONTINUE
      CALL MSGDOC(MDOC,LINE)
C ---
      RETURN
C -----------------------------
1200  CONTINUE 
      CALL MSGERR(MDOC,' ERROR: read input file')
      CLOSE(CRI_IUN)
      IERR=1
      RETURN

1300  CONTINUE 
C     end of file    
      CLOSE(CRI_IUN)
      IEND=1
      RETURN

      END









