C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
      SUBROUTINE PRE_DESCR(MMDOC,LIST,CHECK,COOR,SRCH
     *            ,NAME,NMNEW,NEW_FLAG_OUT,LIB2,KERR,IERR)
C ----------------------------------------------------------
C -P- PRE_DESCR - define/correct res_name, res_type 
C                                (use list of modifications)   
C                 create new description of monomer which can not be found
C                                in mon_lib.cif ( type of new monomers is  
C                                                            non-polymer )
C ----
C             NAME  - name of program ( 'makecif' or 'libcheck' )
C     output:
C             NMNEW    - number of new monomers
C             KERR = 2 - number of monomer in the library = 0
C             KERR = 0 and IERR = 0 - OK
C ----
C
C     'atom_com.fh' only in PRE_DESCR
C
C ---
C     PRE_DESCR - SSET_FUSE
C               - CCHKMON                - CP_MLIB
C               - SET_CTYPE(table)
C               - CHECK_ANAME
C               - LPUT_NEW
C               - CREAT_NEW(MODE='COOR') -
C               - CPL_MLIB
C                 
C -I-
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'lib_com.fh'
C -----------------------------------------------------------
      INTEGER   MDOC,IERR
      CHARACTER NAME*(*)
C ----------------------------------------------------------------
      CHARACTER LINE*256
      CHARACTER CH12*12,NEW_FLAG*1,MOD_FLG*1,LIST*1,RES*5,CHAIN*4
      CHARACTER MON*8,AMON*8,MOD*8,TYPE*16,CORR_MON*8,CORR_TYPE*16
      CHARACTER CTYPE*4,MODE*4,ASYMB*4,ALT_NAME*4,MON_NEW*8,COOR*1
      CHARACTER MODT*8,MON_OLD*8,MTYPE*1,CHECK*1,DNEW*1,ELEMENT*4
      CHARACTER CH8*8,SRCH*1,EL_D*4,EL_F*4,ASYMB_INP*4,ALT_FOR_COPY*1
      CHARACTER NEW_FLAG_OUT*1
C==================================================================
      IERR = 0

      MDOC = MMDOC
      MD   = -ABS(MDOC)-1
      M    = 99

      IF(LIST.EQ.'S') THEN
        MDOC = 999
        MD   = 999
      ENDIF

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDoc,' --- PRE_DESCR --- ')
        CALL PRINT_INFO_TEST(MDoc)
      ENDIF
C --------
      IF(N_ATOM.LE.0.OR.N_GROUP.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR: number of atoms = 0...')
        IERR=1
        RETURN
      ENDIF 
C---------
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDoc,' --- PRE_MONOM_LIST --- ')
      ENDIF
      CALL PRE_MONOM_LIST(MDOC,LIST,IERR)
      IF(IERR.NE.0) RETURN
C --------
      JERR     = 0
      KERR     = 0
      NMUSE    = 0
      NMNEW    = 0
      DNEW     = 'N'
      NEW_FLAG = 'N'
      TYPE     = '?'
      AMON     = '   '
      MOD      = ' '
      NEW_FLAG_OUT = 'N'
C ----
      CALL SET_LINK_CORR
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDoc,' --- after set_link_corr --- ')
      ENDIF
C ----
      DO IG=1,N_GROUP   

        IRS     = IRES_FIRST(IG)
        NRES    = NRES_CHAIN(IG)
        IRF     = IRS + NRES - 1
C ===
        ITS      = ITERM_S_TYPE(IG)
        ITF      = ITERM_F_TYPE(IG)
        IRS_TREE = IRES_START_TREE(IG)
        IRF_TREE = IRES_END_TREE  (IG)
c ===
        DO IR=IRS,IRF

          IRES  = IRES_SERIAL(IR)
          NATMR = NATM_RES   (IR)
          IAS   = IRATM_FIRST(IR)
          IAF   = IAS + NATMR - 1
          CH12  = RES_NUM_PDB(IR)
          RES   = CH12(3:7)
          CHAIN = CH12(8:11)

          NMON_CRT_NEW = 0


 300      CONTINUE

          NEW_FLAG = 'N'

          JERR     = 0
          KERR     = 0

          CR_RNAME = RES_NAME(IR)
          MON      = CR_RNAME

          MOD_FLG  = 'N'
          IF(MOD_N.GT.0) THEN
            DO IM = 1,MOD_N
              IF(MOD_IRES    (IM).EQ.IR  .AND.
     *           MOD_ICHN    (IM).EQ.IG  .AND.
     *           MOD_RNAM_NEW(IM).EQ.MON .AND.
     *           MOD_ID      (IM).EQ.'RENAME') THEN
                MON           = MOD_RNAM(IM)
                MOD_FLG       = 'Y'
                MOD_FLAG (IR) = 'Y'
                GO TO 200
              ENDIF
            ENDDO
          ENDIF
          IM = 0
 200      CONTINUE
          MON_OLD = MON
          CALL CHECK_MON_LIB(MDOC,MON,CH12
     *     ,AMON,MOD,NEW_FLAG,NMUSE,NMNEW,TYPE,LIST,JERR) 
C         JERR = 1  - not found ; 
C              = 2 - number of monomer in the library = 0
          IF(JERR.EQ.2) THEN
            KERR = JERR
            RETURN
          ENDIF
          JERR = 0

          IF(MON.NE.MON_OLD) THEN
            IF(MOD_FLG.EQ.'N') THEN
              MOD   = 'RENAME'
              MTYPE = 'N'  
              IA    = 0
              CALL PUT_M_TABL(MDOC,MOD,IG,IR,IA,MON,MTYPE,IERR)
              IF(IERR.NE.0) RETURN
              MOD_FLG       = 'Y'
              MOD_FLAG (IR) = 'Y'
              IF(MOD_N.GT.0) THEN
                DO IM = 1,MOD_N
                  IF(MOD_IRES   (IM).EQ.IR  .AND.
     *               MOD_ICHN   (IM).EQ.IG  .AND.
     *               MOD_RNAM   (IM).EQ.MON .AND.
     *               MOD_ID     (IM).EQ.'RENAME') THEN
                    GO TO 210
                  ENDIF
                ENDDO
              ENDIF
              IM = 0
 210          CONTINUE
            ELSE
              MOD_RNAM(IM)  = MON
            ENDIF
          ENDIF

          IF(IM.LE.0) THEN
            MOD_FLG       = 'N'
            MOD_FLAG (IR) = 'N'
          ENDIF 

          CALL GET_INI_RES_TYPE(MDOC,LINE,MON,IT,IERR)
          IF(IRES_TYPE(IR).LE.2) IRES_TYPE(IR) = IT
          IT = IRES_TYPE(IR)
          IF(IT.EQ.3.OR.IT.EQ.5.OR.IT.EQ.7.OR.IT.EQ.8) THEN
            CALL LENSTR_BL(L1L_TYPE,LEN) 
            DO ITT=1,N_RES_TYPE
              TYPE = RES_TYPE(ITT)
              IF(L1L_TYPE(1:LEN).EQ.TYPE(1:LEN)) GO TO 801
            ENDDO
            ITT = 1
 801        CONTINUE
            IF(ITT.EQ.4.OR.ITT.EQ.6.OR.ITT.EQ.7.OR.ITT.EQ.8) THEN
              IRES_TYPE(IR) = ITT
              IT = ITT
            ENDIF
          ENDIF

          IF(LIST.EQ.'T') THEN
            WRITE(LINE,*) '-1',IG,IR,RES_NAME(IR),MON,IT,MOD_FLG,MOD
            CALL MSGDOC(MDoc,LINE)
          ENDIF

          IF(IRES_TYPE(IR).EQ.6) THEN
C           RNA          
            IF(MOD_FLG.EQ.'N') THEN
              MON             = RES_NAME(IR) 
              IF((MON(2:2).EQ.'d'.OR.MON(2:2).EQ.' ').AND.
     *                  MON(1:1).NE.'T'.AND.MON(1:2).NE.'+T') THEN
                MON(2:2)      = 'r'
                RES_NAME(IR)  = MON
C                IRES_TYPE(IR) = 6
              ENDIF
            ELSE
              MON             =  MOD_RNAM(IM) 
              IF((MON(2:2).EQ.'d'.OR.MON(2:2).EQ.' ').AND.
     *                  MON(1:1).NE.'T'.AND.MON(1:2).NE.'+T') THEN
                MON(2:2)      = 'r'
                MOD_RNAM(IM)  = MON
C                IRES_TYPE(IR) = 6
              ENDIF
            ENDIF
 
          ELSE IF(IRES_TYPE(IR).EQ.5) THEN
C           DNA
            IF(MOD_FLG.EQ.'N') THEN
              MON             = RES_NAME(IR) 
              IF((MON(2:2).EQ.'r'.OR.MON(2:2).EQ.' ').AND.
     *                                      MON(1:1).NE.'U') THEN
                MON(2:2)      = 'd'
                RES_NAME(IR)  = MON
              ENDIF
            ELSE
              MON             =  MOD_RNAM(IM) 
              IF((MON(2:2).EQ.'r'.OR.MON(2:2).EQ.' ').AND.
     *                                      MON(1:1).NE.'U') THEN
                MON(2:2)      = 'd'
                MOD_RNAM(IM)  = MON
              ENDIF
            ENDIF
          ENDIF

          IF(LIST.EQ.'T') THEN
            WRITE(LINE,*) '-2',IG,IR,RES_NAME(IR),MON,IT,MOD_FLG,MOD
            CALL MSGDOC(MDoc,LINE)
          ENDIF

          IF(IRES_TYPE(IR).EQ.5) THEN
C           DNA
            DO IA=IAS,IAF
              CR_ANAME = ATM_NAME (IA)
              CALL CHECK_ANAME(MON,AMON,MOD,CR_ANAME,ALT_NAME)
              IF(CR_ANAME.EQ.'O2* ') THEN
                IF(MON.NE.'T'.AND.MON.NE.'+T'.AND.MON.NE.'Td') THEN
                  IF(MON(2:2).EQ.'d') MON(2:2) = 'r'
                  IRES_TYPE(IR) = 6
                ENDIF
                IF(MOD_FLG.EQ.'N') THEN
c                  MON           = RES_NAME(IR) 
                  RES_NAME(IR)  = MON
                ELSE
c                  MON           = MOD_RNAM(IM) 
                  MOD_RNAM(IM)  = MON
                ENDIF
                GO TO 500
              ENDIF
            ENDDO
 500        CONTINUE

            IF(LIST.EQ.'T') THEN
              WRITE(LINE,*) '-3',IG,IR,RES_NAME(IR),MON,IT,MOD_FLG,MOD
              CALL MSGDOC(MDoc,LINE)
            ENDIF

            IF(MOD_FLG.EQ.'N'.AND.MON.NE.MON_OLD) THEN
              MOD   = 'RENAME'
              MTYPE = 'N'  
              IA    = 0
              CALL PUT_M_TABL(MDOC,MOD,IG,IR,IA,MON,MTYPE,IERR)
              IF(IERR.NE.0) RETURN
              MOD_FLG       = 'Y'
              MOD_FLAG (IR) = 'Y'
            ENDIF

            CALL CHECK_MON_LIB(MDOC,MON,CH12
     *       ,AMON,MOD,NEW_FLAG,NMUSE,NMNEW,TYPE,LIST,JERR) 
C           JERR = 1  - not found ; 
C                = 2 - number of monomer in the library = 0
            IF(JERR.EQ.2) THEN
              KERR = JERR
              RETURN
            ENDIF
            JERR=0

          ELSE IF(IRES_TYPE(IR).EQ.6) THEN
C           RNA
            CALL CHECK_MON_LIB(MDOC,MON,CH12
     *       ,AMON,MOD,NEW_FLAG,NMUSE,NMNEW,TYPE,LIST,JERR) 
C           JERR = 1  - not found ; 
C                = 2 - number of monomer in the library = 0
            IF(JERR.EQ.2) THEN
              KERR = JERR
              RETURN
            ENDIF
            JERR=0

          ENDIF

          DO IA=IAS,IAF
            CR_ANAME = ATM_NAME (IA)
            CALL CHECK_ANAME(MON,AMON,MOD,CR_ANAME,ALT_NAME)
            ATM_NAME(IA) = CR_ANAME
          ENDDO

C     check unique atom names
          NA =IAF-IAS+1
          IF(NA.GT.1) THEN
            DO IA=IAS,IAF-1
            DO JA=IA+1,IAF
              IF((ATM_NAME(IA).EQ.ATM_NAME(JA)).AND.
     *           (ID_ALT(IA)  .EQ.ID_ALT(JA)  )     ) THEN 
                LINE = ' ERROR : '//MON//
     *          ' : duplicated atom_name : "'//ATM_NAME(IA)//'".'
                CALL MSGERR(MDOC,LINE)
                LINE = '         chain: '//RES_NUM_PDB(IR)(8:11)//
     *                 ' residue: '//RES_NUM_PDB(IR)(3:7)
                CALL MSGERR(MDOC,LINE)
                IERR = 1
              ENDIF           
            ENDDO
            ENDDO
            IF(IERR.NE.0) RETURN
          ENDIF

          CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITT,IERR)
          IF(NRES.LE.1) THEN
            IF(ITT.EQ.3) THEN
              ITERM_S_TYPE(IG) = 2
              ITERM_F_TYPE(IG) = 2
              ITS      = ITERM_S_TYPE(IG)
              ITF      = ITERM_F_TYPE(IG)
            ELSE IF(ITT.EQ.5) THEN
              ITERM_S_TYPE(IG) = 4
              ITERM_F_TYPE(IG) = 4
              ITS      = ITERM_S_TYPE(IG)
              ITF      = ITERM_F_TYPE(IG)
            ENDIF
          ENDIF

          CALL GET_ALT_FOR_COPY(MDOC,IAS,IAF,ALT_FOR_COPY,IERR)

          IF(LIST.EQ.'T') THEN
            WRITE(LINE,*) 'GET_ALT_FOR_COPY:',ALT_FOR_COPY,';'
            CALL MSGDOC(MDOC,LINE)
          ENDIF

          DO IA=IAS,IAF

            INSF      = ID_SF    (IA)  
            ASYMB     = CS_ATYPE (INSF)      
            ASYMB_INP = ASYMB
            CALL SET_CTYPE(ASYMB,CTYPE)
            CR_ANAME = ATM_NAME (IA)
            CR_ANAME_INP = ATM_NAME_INP(IA)
            ST_CHEM  = ATM_CHEM(IA)
            CR_ATYPE = CTYPE(1:1)
            CR_ALT   = ID_ALT   (IA) 
            CR_CORR  = ID_CORR  (IA) 
            IF(ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN 
              CR_XYZ(1)= XYZ_CRD  (1,IA)
              CR_XYZ(2)= XYZ_CRD  (2,IA)
              CR_XYZ(3)= XYZ_CRD  (3,IA)
              CR_ANAME = ATM_NAME (IA)
              CR_ASYMB = ASYMB
              CR_SF_ID = INSF
              CR_OCC   = OCCUP    (IA)
              CALL LPUT_NEW(MDOC,LIST,ALT_FOR_COPY,ITT,IERR)
              IF(IERR.NE.0) RETURN
            ENDIF
          ENDDO

          IF(LIST.EQ.'T') THEN
            WRITE(LINE,*) 'NEW_FLAG:',NEW_FLAG,IG,IR,MON,check
            CALL MSGDOC(MDOC,LINE)
            WRITE(LINE,*) 'C1_NATOM:',C1_NATOM
            CALL MSGDOC(MDOC,LINE)
          ENDIF

          IF(C1_NATOM.GT.0) THEN
            CALL COPYC2(MDOC,IERR)
            IF(IERR.NE.0) RETURN
          ELSE

          ENDIF  
C
C         new_flag = n/m & mon  ;  new_flag = Y and l1l_mname = c1_rname = mon
C
c --
          IF(CHECK.EQ.'0'.AND.NEW_FLAG.EQ.'Y') THEN 
C           no global_search, create new
            MON_NEW = ' ' 

          ELSE IF(NEW_FLAG.EQ.'Y') THEN
C           global_search before and (?) to create new
            MON_NEW = MON

          ELSE IF(NEW_FLAG.NE.'Y') THEN
C           chechk list of atoms /C1(crd) and L1(lib)/ 
            MON_NEW = MON 
C           CALL GET_STANDARD_RES_TYPE(MDOC,LINE,MON,ITT,IERR)
C --- 03.06.03
            CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITT,IERR)
            IF(LIST.EQ.'T') THEN
              write(*,*) ' lib2,lb_pass,itt::',lib2,lb_pass,itt
              write(*,*) ' itf,its::',itf,its
            ENDIF
C            
C ---
            IF(CHECK.NE.'0') THEN 

            IF(((ITT.NE. 5.AND.ITT.NE.6.AND.
     *           ITT.NE. 7.AND.ITT.NE.8.AND.
     *           ITT.NE. 3.AND.ITT.NE.4.AND.
     *           ITT.NE.10.AND.ITT.NE.9     ).AND.CHECK.EQ.'N').OR.
     *                                            CHECK.EQ.'Y')THEN
              IF(IR.EQ.IRS_TREE) THEN
                IF(ITS.GT.1.AND.ITS.LE.N_STERM_TYPE) THEN
                  MODT = TERM_S_TYPE(ITS)
                  IF(LIST.EQ.'T') THEN
                    write(*,*) '===>',modt
                  ENDIF
                  CALL MODIF(MDOC,MODT,IERR)
                  IERR=0
                ENDIF
              ENDIF
              IF(IR.EQ.IRF_TREE) THEN
                IF(ITF.GT.1.AND.ITF.LE.N_FTERM_TYPE) THEN
                  MODT = TERM_F_TYPE(ITF)
                  IF(LIST.EQ.'T') THEN
                    write(*,*) '===>',modt
                  ENDIF
                  CALL MODIF(MDOC,MODT,IERR)
                  IERR=0
                ENDIF
              ENDIF

              IF(MOD_N.GT.0) THEN      
                DO I=1,MOD_N
                  MC  = MOD_ICHN(I)
                  MR  = MOD_IRES(I)
                  MOD = MOD_ID  (I)
                  IF(IR.EQ.MR.AND.IG.EQ.MC) THEN
                    CALL MODIF(MDOC,MOD,IERR)
                    IF(IERR.EQ.2) THEN
                      IERR=0
                    ENDIF
                    IF(IERR.NE.0) RETURN
                  ENDIF
                ENDDO
              ENDIF

              IF(LIST.EQ.'T') THEN
                WRITE(LINE,*) 
     *          '--before check_cmp_mon5:',MON_NEW,';',IERR,it
                CALL MSGERR(MDOC,LINE)
              ENDIF
C 
C             new_flag = N/M , mon_new = mon
C
              CALL CHECK_CMP_MON5(MDOC,LIST,CHECK,IG,IR,IAS
     *                      ,NMON_CRT_NEW,MON_NEW,NEW_FLAG,IERR)
              IF(IERR.NE.0) IERR = 0
C
C             create new for: MON_NEW  = MONOMER_NEW (new_name)= in C1,L1 
C                             NEW_FLAG = 'Y' 
C                             then MON_NEW = ' '            
C             else
C                   NEW_FLAG = N/M , mon_new = mon  
C             
              IF(LIST.EQ.'T') THEN
                WRITE(LINE,*) 
     *          '--after check_cmp_mon5:',MON_NEW,';',NEW_FLAG,';',IERR
                CALL MSGERR(MDOC,LINE)
              ENDIF

              IF(NEW_FLAG.EQ.'Y') THEN 
                WRITE(LINE,'(3A)')' WARNING : ',MON,
     *         ' : program can not match library description....'
                CALL MSGERR(MDOC,LINE)
                MON_NEW = ' '
              ENDIF

C           else
C             NEW_FLAG.NE.'Y' &  MON_NEW = MON              
C             no global searching , create new if NEW_FLAG = 'M'

            ENDIF
            ENDIF

          ENDIF          

C -- 6.04.03
          IF(NEW_FLAG.EQ.'Y') THEN
            LIB2    = 1 
            LB_PASS = 0
          ENDIF
C --
          IF(NEW_FLAG.NE.'N') THEN
            IF(NEW_FLAG.EQ.'Y') THEN
              NEW_FLAG_OUT = NEW_FLAG
            ELSE
              IF(NEW_FLAG_OUT.NE.'Y') NEW_FLAG_OUT = NEW_FLAG 
            ENDIF 
          ENDIF
 
          IF(NEW_FLAG.EQ.'Y'.AND.MON_NEW(1:1).NE.' ') THEN

            IF(LIST.EQ.'T') THEN
              LINE = '--before global search:'//MON_NEW//';'//
     *        MON//';'//NEW_FLAG//';'
              CALL MSGERR(MDOC,LINE)
            ENDIF


            CALL GLOBAL_SEARCH_NEW(MDOC,LIST,MON,MON_NEW,NEW_FLAG,SRCH
     *        ,NMON_CRT_NEW,IG,IR,IAS,IERR)           
            IF(IERR.NE.0) RETURN
C
C             NEW_FLAG     'Y'        'C'             N/M
C             MON_NEW      ' '       new_name       mon_iso (from srch)
C                      create new     --  createnew if 'M' ---

            IF(LIST.EQ.'T') THEN
              LINE = '--after global search:'//MON_NEW//';'//
     *        MON//';'//NEW_FLAG//';'//L1L_PRSNT//';'
              CALL MSGERR(MDOC,LINE)
            ENDIF

            IF(NEW_FLAG.EQ.'C'.OR.NEW_FLAG.EQ.'G') THEN
              IF(L1L_PRSNT.EQ.'M') THEN
                NEW_FLAG = 'M'
              ELSE
                L1L_FUSE   = 'C'
                L1L_PRSNT  = '.'
                IF(NEW_FLAG.EQ.'C') CALL CPL_MLIB(MDOC,IERR)
                IF(IERR.NE.0) RETURN
                NEW_FLAG = 'N'
                NMNEW = NMNEW + 1
              ENDIF
            ENDIF
          ENDIF

C ----
          IF(MON_NEW.NE.MON.AND.MON_NEW(1:1).NE.' ') THEN
            MOD   = 'RENAME'
            MTYPE = 'N'  
            CALL PUT_M_TABL(M,MOD,IG,IR,IAS,MON_NEW,MTYPE,IERR)
            IF(IERR.NE.0) RETURN

            LINE = ' WARNING : residue: '//MON//' '//RES//' chain:'//
     *      CHAIN //' - rename' 
            CALL MSGDOC(MDOC,LINE)
            WRITE(LINE,
     *      '(''          "'',A,''" --> "'',A,''" '')')
     *      MON,MON_NEW
            CALL MSGDOC(MDOC,LINE)

            CALL LENSTR_BL(L1L_TYPE,LEN) 
            DO IT=1,N_RES_TYPE
              TYPE = RES_TYPE(IT)
              IF(L1L_TYPE(1:LEN).EQ.TYPE(1:LEN)) GO TO 820
            ENDDO
            IT = 1
 820        CONTINUE
            IRES_TYPE(IR) = IT
            MON = MON_NEW          
          ENDIF         

C         new atom name(C2) --> Atm_name 
C                              link, syn.
          IFIRST = 0
          DO IC=1,C1_NATOM
            IF(C2_ANAME(IC).NE.C1_ANAME(IC)) THEN
C              MMM = 99
C              IF(LIST.EQ.'T') MMM=MDOC
              CALL  PUT_SYNONYM_TO_LIST(MDOC,MON_NEW,IFIRST,RES,CHAIN
     *                ,C1_ANAME(IC),C2_ANAME(IC),DNEW,IERR)
C                           OLD        NEW
              CALL CHANGE_ATOM_IN_LINK_TAB(MDOC,IG,IR
     *                     ,C1_ANAME(IC),C2_ANAME(IC),IERR)
              DO IA=IAS,IAF
                IF(ATM_NAME(IA).EQ.C1_ANAME(IC)) THEN
                  ATM_NAME(IA) = C2_ANAME(IC)
                ENDIF
              ENDDO
            ENDIF
          ENDDO
          DO IC=1,C1_NATOM
            C1_ANAME(IC) = C2_ANAME(IC)
          ENDDO
          CALL COPYC1(MDOC,IERR)
          C1_RNAME = MON

          IF(L1L_PRSNT.EQ.'N') THEN
            MODE = ' '
            CALL COOR_CONN(MDOC,MODE,IERR)
          ENDIF
C ----          
c         CALL GET_STANDARD_RES_TYPE(MDOC,LINE,MON,ITT,IERR)
C --- 03.06.03
          CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITT,IERR)
C ---
          IF(LIST.EQ.'T') THEN
            WRITE(*,*) '-RES_TYPE,CHECK:',ITT,CHECK
          ENDIF
          IF(CHECK.NE.'0') THEN 
            IF(((ITT.NE. 5.AND.ITT.NE.6.AND.
     *           ITT.NE. 7.AND.ITT.NE.8.AND.
     *           ITT.NE. 3.AND.ITT.NE.4.AND.
     *           ITT.NE.10.AND.ITT.NE.9     ).AND.CHECK.EQ.'N').OR.
     *                                            CHECK.EQ.'Y')THEN

              CALL PRECHECK_L1_MON_DESCRIPTION(MDOC,LIST,IERR)
C             ierr 10  - add 'dummy' bonds    
C             ierr 100 - remove some bonds
C             ierr 1   - 
              IF(IERR.NE.0) THEN
                NEW_FLAG = 'M'
                IF(L1L_PRSNT.NE.'N') L1L_PRSNT = 'M'
                IERR = 0
              ENDIF
            ENDIF
          ENDIF

          IF(MON_NEW(1:1).EQ.' '.OR.NEW_FLAG.EQ.'M') THEN

            IF(COOR.EQ.'Y') MODE = 'TEST'
            VANGLE       = 0.0
            IF(LIST.EQ.'T') THEN
              LINE = '-- create new --'
              CALL MSGERR(MDOC,LINE)
            ENDIF

            CH8  = C1_RNAME
            LINE = '                   '//
     *      'program will create complete description for:'//CH8
            CALL MSGDOC(MDD,LINE)

            IF(L1L_PRSNT.NE.'N') THEN
              CALL GET_INI_RES_TYPE(MDOC,LINE,CH8,IT,IERR)
              IF(IERR.NE.0) RETURN
            ELSE
C             CALL CHECK_RES_TYPE_BY_ATOM_AND_BOND(MDOC,IT,IERR)
              IT = 1
              L1L_TYPE  =  RES_TYPE(IT) 
            ENDIF

           IF(LIST.EQ.'T') THEN
              WRITE(LINE,*) 
     *        '-- before create new:',it,l1a_natom,l1b_nbond
              CALL MSGERR(MDOC,LINE)
            ENDIF

            ITER = 0
            IF(IT.EQ.3.OR.IT.EQ.4) THEN
              MODT = 'AA-STAND'
              CALL MODIF(MDOC,MODT,IERR)
              IERR = 0
              ITER = 2
            ENDIF
            IF(IT.EQ.5.OR.IT.EQ.6) THEN
              MODT = 'NA-STAND'
              CALL MODIF(MDOC,MODT,IERR)
              IERR = 0
              ITER = 4
            ENDIF
            IF(ITER.GT.0) THEN
              MODT = TERM_S_TYPE(ITER)
              CALL MODIF(MDOC,MODT,IERR)
              IERR=0
              MODT = TERM_F_TYPE(ITER)
              CALL MODIF(MDOC,MODT,IERR)
              IERR=0
              CALL PRECHECK_L1_MON_DESCRIPTION(MDOC,LIST,IERR)
C               ierr 10  - add 'dummy' bonds    
C               ierr 100 - remove some bonds
C               ierr 1   - 
              IF(IERR.NE.0) THEN
                IERR = 0
              ENDIF 
            ENDIF

C            DO IA=1,L1A_NATOM
C              IF(L1A_COOR_FLAG(IA).NE.'Y') THEN
C                MODE = '.'
C                L1L_PRSNT = 'M'
C              ENDIF
C            ENDDO    

            MMM = MDOC
            IF(LB_PASS.EQ.1.AND.LIST.NE.'T'.AND.
     *         NAME.EQ.'refmac') MMM = 99
            CALL CREAT_NEW(MMM,LIST,MODE,C1_PNUM,NAME,VANGLE,IERR)
            IF(IERR.NE.0) RETURN
            CALL CPL_MLIB(MDOC,IERR)
            IF(IERR.NE.0) RETURN

            NMNEW = NMNEW + 1
C -- 6.04.03
            IF(LB_PASS.NE.1) THEN
c             NMNEW = NMNEW + 1 
              LIB2  = 1
            ENDIF
C --
            MON_NEW = L1L_MNAME

          ENDIF

C ---
          IF(MON_NEW.NE.MON.AND.MON_NEW(1:1).NE.' ') THEN
            MOD   = 'RENAME'
            MTYPE = 'N'  
            CALL PUT_M_TABL(M,MOD,IG,IR,IAS,MON_NEW,MTYPE,IERR)
            IF(IERR.NE.0) RETURN

            LINE = ' WARNING : residue: '//MON//' '//RES//' chain:'//
     *      CHAIN //' - rename' 
            CALL MSGDOC(MDOC,LINE)
            WRITE(LINE,
     *      '(''          "'',A,''" --> "'',A,''" '')')
     *      MON,MON_NEW
            CALL MSGDOC(MDOC,LINE)

C            CALL LENSTR_BL(L1L_TYPE,LEN) 
C            DO IT=1,N_RES_TYPE
C              TYPE = RES_TYPE(IT)
C              IF(L1L_TYPE(1:LEN).EQ.TYPE(1:LEN)) GO TO 810
C            ENDDO
C            IT = 1
C 810        CONTINUE
C            IRES_TYPE(IR) = IT
            MON = MON_NEW          
          ENDIF         


          CALL LENSTR_BL(L1L_TYPE,LEN) 
          DO IT=1,N_RES_TYPE
            TYPE = RES_TYPE(IT)
            IF(L1L_TYPE(1:LEN).EQ.TYPE(1:LEN)) GO TO 800
          ENDDO
          IT = 1
 800      CONTINUE
          IRES_TYPE(IR) = IT

C         new atom name(C2) --> Atm_name 
C                              link, syn.
          IFIRST = 0
          DO IC=1,C1_NATOM
            IF(C2_ANAME(IC).NE.C1_ANAME(IC)) THEN
C              MMM = 99
C              IF(LIST.EQ.'T') MMM=MDOC
              CALL  PUT_SYNONYM_TO_LIST(MDOC,MON_NEW,IFIRST,RES,CHAIN
     *                ,C1_ANAME(IC),C2_ANAME(IC),DNEW,IERR)
C                           OLD        NEW
              CALL CHANGE_ATOM_IN_LINK_TAB(MDOC,IG,IR
     *                     ,C1_ANAME(IC),C2_ANAME(IC),IERR)
              DO IA=IAS,IAF
                IF(ATM_NAME(IA).EQ.C1_ANAME(IC)) THEN
                  ATM_NAME(IA) = C2_ANAME(IC)
                ENDIF
              ENDDO
            ENDIF
          ENDDO
C ---
          DO IL=1,L1A_NATOM
            DO IA=IAS,IAF
              IF(ATM_NAME(IA).EQ.L1A_ANAME(IL)) THEN
                ATM_CHEM(IA) = L1A_CHEM(IL)
                CR_ASYMB     = L1A_SYMB(IL)
                INSF = ID_SF(IA)
                IF(INSF.GT.0.AND.CS_ELEMENT(INSF)(1:1).NE.'?')THEN
                  EL_D    = CR_ASYMB
                  EL_F    = CS_ELEMENT(INSF)
                  CALL LENSTR_BL(CS_ATYPE(INSF),LLL)
                  IF(LLL.GE.3) THEN
                    IF(CS_ATYPE(INSF)(2:2).EQ.'+'.OR.
     *                 CS_ATYPE(INSF)(2:2).EQ.'-'    ) THEN
                      EL_F    = CS_ATYPE(INSF)                          
                    ELSE IF(LLL.GE.4) THEN
                      IF(CS_ATYPE(INSF)(3:3).EQ.'+'.OR.
     *                   CS_ATYPE(INSF)(3:3).EQ.'-'    ) THEN
                        EL_F    = CS_ATYPE(INSF)
                      ENDIF
                    ENDIF
                  ENDIF
                  ELEMENT = EL_F 
                  CALL CUT_EL_NAME(EL_D)
                  CALL CUT_EL_NAME(EL_F)
C                 EL_F - element from file (without +/-)
C                 EL_D - element from dictionary (without +/-)
                  IF(EL_F.NE.EL_D) THEN
C                   from dict.
                    ELEMENT = CR_ASYMB 
                    LINE = ' WARNING : residue: '//MON//' '//RES//
     *               ' chain:'//CHAIN
                    CALL MSGERR(MDOC,LINE)
                    LINE = '           different element name:'//
     *              ' file:"'//EL_F//'"  dict:"'//EL_D//'"'
                    CALL MSGERR(MDOC,LINE)
                  ELSE
C                   from file
C                    ELEMENT = CS_ELEMENT(INSF)
                  ENDIF
                ELSE
                  ELEMENT = CR_ASYMB
C --              7.07.03               
c                 IF(INSF.GT.0) ELEMENT = CS_ATYPE(INSF)
C --
                ENDIF

                CALL CHKSMB(CR_ASYMB(2:2),TYPE)
                IF(TYPE.EQ.'D'.OR.TYPE.EQ.'S') CR_ASYMB(2:2) = ' '
                CR_ASYMB(3:3) = ' '
                CR_ASYMB(4:4) = ' '

                IF(CS_NSFATM.GT.0) THEN
                  DO ISF=1,CS_NSFATM
                    IF(ELEMENT.EQ.CS_ELEMENT(ISF)) THEN
                      INSF = ISF
                      GO TO 100
                    ENDIF
                  ENDDO
                ENDIF

                IF(CS_NSFATM.GE.MAXNSF) THEN
                  LINE = ' ERROR: number of atomic scattering'//
     *            ' or chemical types > limit.'
                  CALL MSGERR(MDOC,LINE)
                  CALL MSGERR(MDOC
     *  ,'        change parameter MAXNSF in atom_com.fh')
                  IERR=1
                  RETURN
                ENDIF

                CS_NSFATM            = CS_NSFATM + 1
                INSF                 = CS_NSFATM
                CS_ATYPE  (INSF)     = CR_ASYMB 
                CS_ELEMENT(INSF)     = ELEMENT 

 100            CONTINUE

                ID_SF    (IA) = INSF

C                ATM_TYPE (IA) = CR_ATYPE

              ENDIF
            ENDDO
          ENDDO
C ---
          IF(IR.NE.IRS.AND.
     *       (IRES_TYPE(IR).EQ.3.OR.IRES_TYPE(IR).EQ.4)) THEN 
            IF(ICONN_TYPE(IR).NE.37.AND.ICONN_TYPE(IR).NE.10.AND. 
     *         ICONN_TYPE(IR).NE.39     ) THEN
              CALL CHECK_CONN_TYPE_BY_BOND(MDOC,ICTYPE,IERR)
              IF(ICTYPE.GT.1)ICONN_TYPE(IR) = ICTYPE
            ENDIF 
          ENDIF
C ---

        ENDDO

      ENDDO

      IF(NMNEW.GT.0) THEN
        WRITE(LINE,'(A,I6)')
     *  ' number of new kinds of monomers            :', NMNEW
        CALL MSGDOC(MD,LINE)
      ENDIF

      IF(LML_NMON.GT.0) THEN
        DO LL=1,LML_NMON
          IF(LML_FUSE(LL).EQ.'C') DNEW = 'Y'
        ENDDO
      ENDIF        

C -- 6.04.03  DNEW not used here
C    IF(DNEW.EQ.'Y') NMNEW = NMNEW + 1

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,' --- END PRE_DESCR --- ')
        CALL PRINT_INFO_TEST(MDOC)
      ENDIF


      RETURN
      END

      SUBROUTINE CHECK_CONN_TYPE_BY_BOND(MDOC,ICTYPE,IERR)
C -----------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256
C -----------------------------
      IERR = 0
      ICTYPE = 1
C ---
       IF(L1B_NBOND.GT.0) THEN
         DO I=1,L1B_NBOND
           IF((L1B_1ATM(I).EQ.'N '.AND.L1B_2ATM(I).EQ.'CD').OR. 
     *        (L1B_2ATM(I).EQ.'N '.AND.L1B_1ATM(I).EQ.'CD')    )
     *     ICTYPE=36
           IF((L1B_1ATM(I).EQ.'N '.AND.L1B_2ATM(I).EQ.'CN').OR. 
     *        (L1B_2ATM(I).EQ.'N '.AND.L1B_1ATM(I).EQ.'CN')    )
     *     ICTYPE=38
         ENDDO
       ENDIF
C ----
      RETURN
      END

      SUBROUTINE CUT_EL_NAME(EL_NAME)
C -------------------------------------------
      CHARACTER EL_NAME*4,CHAR4*4
C -------------------------------------------
      CHAR4   = EL_NAME
      EL_NAME = ' '
      CALL LENSTR_BL(CHAR4,LEN)
      DO I=1,LEN
        IF(CHAR4(I:I).EQ.'+'.OR.CHAR4(I:I).EQ.'-') GO TO 100
         EL_NAME(I:I) = CHAR4(I:I)
      ENDDO
 100  CONTINUE
      RETURN
      END

      SUBROUTINE PRINT_INFO_TEST(MD)
C -------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'lib_com.fh'
C ----
      CHARACTER LINE*80
C -------------------        
      IF(ABS(MD).GE.99) RETURN
      CALL MSGDOC(MD,' ---ln id,used,ent,dist/res,ch,atom - ')
        IF(LN_N.GT.0) THEN
          DO LN=1,LN_N
         write(LINE,*) 'ln:',LN_ID(LN),LN_USEd(LN),LN_ENT(LN)
     *    ,LN_DIST(LN) 
         CALL MSGDOC(MD,LINE)
         write(LINE,*) '   ',LN_1IRES(ln),LN_1ICHN(LN),LN_ATOM1(LN)
         CALL MSGDOC(MD,LINE)
         write(LINE,*) '   ',LN_2IRES(ln),LN_2ICHN(LN),LN_ATOM2(LN)
         CALL MSGDOC(MD,LINE)
         write(LINE,*) '   ',LN_ALT1(LN),LN_ALT2(LN)
         CALL MSGDOC(MD,LINE)
          enddo             
        endif
       CALL MSGDOC(MD,' -- md id,res,ch,rnam,rnam_new - ')
        IF(MOD_N.GT.0) THEN
          DO IM = 1,MOD_N
       write(LINE,*) 'md:',mod_ID(im),';',MOD_USED(im) 
       CALL MSGDOC(MD,LINE)
       write(LINE,*) '   '
     *     ,mod_ires(im),mod_iCHN(im),mod_rnam(im),mod_rnam_new(im)
       CALL MSGDOC(MD,LINE)
          ENDDO
        ENDIF
c      CALL MSGDOC(MD,' -- syn amname,mname,atom,atom - ')
c        if(lms_nsyn.gt.0) then
c          DO LL=1,LMS_NSYN
c            write(LINE,*) 'sn:'
c     *      ,LMS_AMNAME(LL),LMS_MNAME(LL),LMS_AATOM(LL),LMS_ATOM(LL)
c     *      ,';',LMS_FLAG(LL)
c            CALL MSGDOC(MD,LINE)
c          ENDDO
c        ENDIF
c      CALL MSGDOC(MD,' -- der  mname,smname,type - ')
c      IF(LDR_NDER.GT.0) THEN
c        DO LL=1,LDR_NDER
c          write(LINE,*) 'dr:'
c     *    ,LDR_MNAME(LL),LDR_SMNAME(LL),LDR_TYPE(LL)
c          CALL MSGDOC(MD,LINE)
c        ENDDO
c      ENDIF
      CALL MSGDOC(MD,' ----- ')
C ---
      RETURN
      END


      SUBROUTINE CHANGE_ATOM_IN_LINK_TAB(MDOC,ICH1,IRES1
     *                     ,ATOM_OLD,ATOM_NEW,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      INTEGER*4 ICH1,IRES1

C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ---
      CHARACTER LINE*256,ATOM_OLD*4,ATOM_NEW*4
C -----------------------------------
      IERR=0
      IF(LN_N.LE.0) RETURN

      DO L=1,LN_N
        IF(LN_1IRES(L).EQ.IRES1.AND.LN_1ICHN(L).EQ.ICH1.AND.
     *     LN_ATOM1(L).EQ.ATOM_OLD) THEN
          LN_ATOM1(L) = ATOM_NEW
        ENDIF
        IF(LN_2IRES(L).EQ.IRES1.AND.LN_2ICHN(L).EQ.ICH1.AND.
     *     LN_ATOM2(L).EQ.ATOM_OLD) THEN
          LN_ATOM2(L) = ATOM_NEW
        ENDIF
      ENDDO

      RETURN
      END

      SUBROUTINE PUT_SYNONYM_TO_LIST(MDOC,MON,IFIRST,RES,CHAIN
     *         ,ATOM_OLD,ATOM_NEW,DNEW,IERR)
C -----------------------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------------------------
      INTEGER     MDOC,IERR
C -----------------------------------------------------------
      CHARACTER LINE*256
      CHARACTER MON*8,ATOM_OLD*4,ATOM_NEW*4,MONN*8,DNEW*1
      CHARACTER RES*5,CHAIN*4       
C -----------------------------------------------------------
      MONN = '.'
      CALL CHECK_SYNONYM(IT,MON,MONN,ATOM_NEW,ATOM_OLD)
      IF(IT.NE.0) RETURN

      IF(LMS_NSYN.GE.MAXMLIST) RETURN
      LMS_NSYN = LMS_NSYN + 1
      LMS_NEW  = LMS_NEW  + 1
      LMS_ISYN = LMS_NSYN

      IF(IFIRST.EQ.0) THEN
        WRITE(LINE,
     *  '('' WARNING : program changed the atom names to standard'')')
        CALL MSGDOC(MDOC,LINE)
        LINE = '           residue: '//MON//' '//RES//' chain:'//CHAIN 
        CALL MSGDOC(MDOC,LINE)
        IFIRST = 1
      ENDIF

      LMS_MNAME  (LMS_NSYN) = MON
      LMS_MNAME2 (LMS_NSYN) = '.' 
      LMS_ATOM   (LMS_NSYN) = ATOM_NEW
      LMS_MOD    (LMS_NSYN) = '.' 
      LMS_AATOM  (LMS_NSYN) = ATOM_OLD
      LMS_AMNAME (LMS_NSYN) = '.' 
      LMS_AMNAME2(LMS_NSYN) = '.' 
      LMS_FLAG   (LMS_NSYN) = 'N' 
      DNEW = 'Y'

      WRITE(LINE,
     * '(''           '',A,''  "'',A4,''" --> "'',A4,''" '')')
     *    MON,ATOM_OLD,ATOM_NEW
      CALL MSGDOC(MDOC,LINE)
C ----
      RETURN
      END


      SUBROUTINE PRE_MONOM_LIST(MDOC,LIST,IERR)
C ----------------------------------------------------------
C -I-
      INCLUDE 'atom_com.fh'

c      INCLUDE 'lib_com.fh'
C -----------------------------------------------------------
      INTEGER     MDOC,IERR
C ----------------------------------------------------------------
      CHARACTER MON*8,CH1*1,CHAR1*1,MODE*1,NODIST*1,LIST*1
C     CHARACTER LINE*256
C==================================================================
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
      MD0  = 0
      IF(MDOC.EQ.999) MD0 = 999
C --------
      IF(N_ATOM.LE.0.OR.N_GROUP.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR: number of atoms = 0...')
        IERR=1
        RETURN
      ENDIF 
C --------
      JERR     = 0
C ----------------------
      CH1      = 'N'
      CHAR1    = ' '
      CALL SSET_FUSE(CH1,CHAR1)
C ----------------------

c      IF(LIST.EQ.'T') THEN
c        DO L=1,300
c          WRITE(*,*) L,' ',LML_MNAME(L),' ',LML_FUSE(L)
c        ENDDO
c      ENDIF

      DO IG=1,N_GROUP   
        IRS       = IRES_FIRST(IG)
        NRES      = NRES_CHAIN(IG)
        IRF       = IRS + NRES - 1
        DO IR=IRS,IRF
          MON      = RES_NAME   (IR)
          IF(MOD_N.GT.0) THEN
            DO IM = 1,MOD_N
              IF(MOD_IRES    (IM).EQ.IR  .AND.
     *           MOD_ICHN    (IM).EQ.IG  .AND.
     *           MOD_RNAM_NEW(IM).EQ.MON      ) THEN
                MON  = MOD_RNAM(IM)
                GO TO 100
              ENDIF
            ENDDO
          ENDIF

 100      CONTINUE

          CALL LOOK_MON_LIB(MDOC,MON,IERR)
C         IERR = 1  - not found ; 
C              = 2 - number of monomer in the library = 0

c          IF(LIST.EQ.'T') THEN
c            WRITE(*,*) 'pre_monom_list:',ig,ir,mon,ierr
c          ENDIF
          IF(IERR.EQ.2) THEN
            RETURN
          ENDIF
          IERR=0

        ENDDO
      ENDDO

C
C     read mon_lib.cif
C
      CALL MSGDOC(MD0,' I am reading library. Please wait.')
      CALL MSGDOC(MD0,'               mon_lib.cif')
      MODE   = 'M'
      NODIST = 'N'
      CALL READ_LIB(MDOC,MODE,NODIST,LIST,IERR)
      IF(IERR.NE.0) RETURN

      RETURN
      END

      SUBROUTINE LOOK_MON_LIB(MDOC,MON,IERR)
C -----------------------------------------
C -P- CHKMON - looks for monomer's name in the library list
C              , set use_flag = "Y".
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER AMON*8,MON2*8
C     CHARACTER LINE*256
C --------------------------------
      IERR = 0

      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of monomer in the library = 0')
        IERR = 2
        RETURN
      ENDIF

      DO L=1,LML_NMON
        IF(MON.EQ.LML_MNAME(L)) THEN
          GO TO 100
        ENDIF
      ENDDO

      IF(LMS_NSYN.GT.0) THEN
        DO LL=1,LMS_NSYN
          IF(LMS_AMNAME(LL).EQ.MON) THEN
            MON  = LMS_MNAME(LL)
            DO L=1,LML_NMON
              IF(MON.EQ.LML_MNAME(L)) THEN
                GO TO 100
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

      IF(LDR_NDER.GT.0) THEN
        DO LL=1,LDR_NDER
          IF(LDR_MNAME(LL).EQ.MON) THEN
            AMON = LDR_SMNAME(LL)
            DO L=1,LML_NMON
              IF(AMON.EQ.LML_MNAME(L)) THEN
               MON = AMON 
               GO TO 100
              ENDIF
            ENDDO
            MON2 = AMON
            DO LLL=1,LDR_NDER
              IF(LDR_MNAME(LLL).EQ.MON2) THEN
                AMON = LDR_SMNAME(LLL)
                DO L=1,LML_NMON
                  IF(AMON.EQ.LML_MNAME(L)) THEN
                    MON = AMON 
                    GO TO 100
                  ENDIF
                ENDDO
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

C     monomer is not found.
      IERR=1
      RETURN

  100 CONTINUE

      IF(LML_FUSE(L).EQ.'N') THEN
        LML_FUSE(L) = 'R'
      ENDIF

      RETURN
      END     

      SUBROUTINE GLOBAL_SEARCH_NEW(MDOC,LIST,MON,MON_NEW,NEW_FLAG,SRCH
     *  ,NMON_CRT_NEW,IG,IR,IAS,IERR)           
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,MON_NEW*8,NEW_FLAG*1,LIST*1,SRCH*1
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ---
C -----------------------------------------------
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
C -----------------------------------------------
      CHARACTER CTYPE*4,ASYMB*4,MODE*4,MOD_R*1,MOD*8,MTYPE*1
      CHARACTER LINE*256,MONOMER_NEW*8,NODIST*1
C --------------------------------
      IERR      = 0
      MD        = -ABS(MDOC)-1
      IF(LIST.EQ.'T') MD = MDOC
      MDD       = MD
      M         = 99
      IF(LIST.EQ.'T'.OR.LIST.EQ.'L'.OR.LIST.EQ.'M') MDD = MDOC

      C_INDEX   = '.'
      C_CONTENT = '.'
      C_PAIR    = '.'

      IF(LMX_NMON.LE.0) THEN
        MON_NEW = ' '
        GO TO 100
      ENDIF 

      L_BEST = 0
      IF(C1_NATOM.LE.5.OR.LMX_NMON.LE.0) GO TO 200

      DO I=1,C1_NATOM

        S1_NDIST(I) = 0
        ASYMB = C1_ASYMB(I)
        IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *     ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *     ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
          CTYPE='C   '
        ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
          CTYPE='H   '
        ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
          CTYPE='P   '
        ELSE
          CTYPE='$   '
        ENDIF
        C1_ATYPE(I) = CTYPE(1:1)
      ENDDO

      MODE = ' '
      CALL CRD_CONN(MDOC,MODE,IERR)
      IF(IERR.NE.0) THEN
        LINE = ' ERROR : monomer '//MON//' in subroutine CRD_CONN'
        CALL MSGDOC(MDOC,LINE)
        IERR = 0
        GO TO 100
      ENDIF

      CALL CALC_INDEX_CRD(M,MON,N,C_CONTENT,C_INDEX,C_PAIR,IERR)

C ----
        write(line,'(''OLD-->'',I4,'';'',A,'';'',A30,'';'',A24,'';'')')
     *  N,MON,C_CONTENT,C_INDEX
        CALL MSGDOC(MD,LINE)
        write(line,'(''          :'',A24,'';'')')
     *  C_PAIR
        CALL MSGDOC(MD,LINE)
        write(line,*)
        CALL MSGDOC(MD,LINE)
C ---


      L_BEST    = 0
      ILIB_BEST = 0
C     for complete matching  INDI_BEST = 0
C      INDI_BEST = 13
      INDI_BEST = 0
      INDP_BEST = 100000

      DO I=1,LMX_NMON 

        ND = ABS(N - LMX_NATOM(I))

C        IF(N.EQ.LMX_NATOM(I).OR.(N.GT.9.AND.ND.LE.2)) THEN
        IF(ND.LE.0) THEN

          CALL CALC_INDEX_DIFF(M,C_CONTENT,C_INDEX,C_PAIR
     *     ,LMX_CONTENT(I),LMX_INDEX(I),LMX_PAIR(I)
     *     ,IDIFFC,IDIFFI,IDIFFP,IERR)


          IF(IDIFFC.EQ.0) THEN

C            IF((INDI_BEST.GT.IDIFFI).OR.
C     *         (INDI_BEST.EQ.IDIFFI.AND.
C     *          INDP_BEST.GT.IDIFFP     )) THEN

            IF(IDIFFI.EQ.0.AND.IDIFFP.EQ.0) THEN

              write(line,
     *        '(''-->'',I4,'';'',A,'';'',A30,'';'',A24,'';'')')
     *        LMX_NATOM(I),LMX_MNAME(I),LMX_CONTENT(I),LMX_INDEX(I)
              CALL MSGDOC(MD,LINE)
              write(line,'(''          :'',A24,'';'',3I4)')
     *        LMX_PAIR(I),IDIFFC,IDIFFI,IDIFFP
              CALL MSGDOC(MD,LINE)

              DO L=1,LML_NMON
                IF(LMX_MNAME(I).EQ.LML_MNAME(L)) THEN
                  GO TO 400
                ENDIF     
              ENDDO

              GO TO 300

 400          CONTINUE

              L_BEST    = I
              ILIB_BEST = L
              INDI_BEST = IDIFFI
              INDP_BEST = IDIFFP

              GO TO 200

            ENDIF
          ENDIF
        ENDIF

 300    CONTINUE

      ENDDO

 200  CONTINUE


      IF(L_BEST.GT.0) THEN

        I = L_BEST
        L = ILIB_BEST
        IF(LMX_MNAME(I).NE.MON) THEN 
          MON_NEW = LMX_MNAME(I)
          LINE = ' WARNING : monomer looks like '//LMX_MNAME(I)
     *          //'program will use this one' 
          CALL MSGDOC(MDD,LINE)
          IF(LML_FUSE(L).EQ.'N') THEN
C           read mon_lib.cif
             LML_FUSE(L) = 'R'
            MOD_R  = 'M'
            NODIST = 'N'
            CALL READ_LIB(M,MOD_R,NODIST,LIST,IERR)
            IF(IERR.NE.0) RETURN
          ENDIF

          IF(LIST.EQ.'T') THEN
            LINE = '           program will try to use this one'
            CALL MSGERR(MDOC,LINE)
            write(*,'(''NEW-->'',I4,'';'',A,'';'',A30,'';'',A24,'';'')')
     *      N,LMX_MNAME(I),LMX_CONTENT(I),LMX_INDEX(I)
            write(*,'(''          :'',A24,'';'')')
     *      LMX_PAIR(I)
          ENDIF

        ELSE
          MON_NEW = ' '
        ENDIF
      ELSE
          MON_NEW = ' '
      ENDIF

 100  CONTINUE

      IF(LIST.EQ.'T') THEN
        LINE= '--G-S :'//MON_NEW//';'//MON//';'//NEW_FLAG//';'
        CALL MSGDOC(MDOC,LINE)
      ENDIF


      IF(MON_NEW(1:1).NE.' ') THEN    

        L1L_MNAME = MON_NEW
        L1L_MNAME2= MON_NEW
        L1L_NAME  = '.'
        C1_RNAME  = MON_NEW
        NEW_FLAG = 'Y'
        IF(LML_PRSNT(L).EQ.'M') NEW_FLAG = 'M'
        CALL CP_MLIB(MDOC,MON_NEW,IERR)
        IF(IERR.NE.0) RETURN
        IT = 0
        CALL CHECK_CMP_MON3(M,LIST,IT,IERR)

        IF(IERR.NE.0) THEN
          NEW_FLAG = 'Y'
          MON_NEW  = ' '
          IERR     = 0
        ELSE
          DO IC=1,C1_NATOM
           IF(C2_ANAME(IC).NE.C1_ANAME(IC)) GO TO 500 
          ENDDO

          NEW_FLAG = 'N'
          IF(LML_PRSNT(L).EQ.'M') NEW_FLAG = 'M'
C
C         all names are equal:  new_flag = M/N ; mon_new = mon_iso (from srch)
C
          GO TO 510

 500      CONTINUE

C         There are different names:
C         copy mon_iso description , change mon_name
C         change atom names c1 -> L1
C
C         new_flag = 'C', MON_NEW = new_name
C          
          IF(NMON_CRT_NEW.GE.99) RETURN

          I = NMON_CRT_NEW + 1

 600      CONTINUE

          IF(I.GT.99) RETURN

          WRITE(MONOMER_NEW,'(I3)') I            
          MONOMER_NEW(1:1) = 'N'
          IF(MONOMER_NEW(2:2).EQ.' ') THEN
            MONOMER_NEW(2:2) = MONOMER_NEW(3:3)
            MONOMER_NEW(3:3) = ' '
          ENDIF

          CALL LENSTR_BL(MONOMER_NEW,LEN)
          CALL LENSTR_BL(MON,LM)
          MON_NEW = MON(1:LM)//'_'//MONOMER_NEW(1:LEN)

          CALL CHECK_MON_NAME_IN_LIB(MON_NEW,IERR)
          IF(IERR.EQ.0) THEN
            I = I + 1
            GO TO 600
          ELSE
            IERR = 0
          ENDIF

          NMON_CRT_NEW = I

          L1L_MNAME = MON_NEW
          L1L_MNAME2= MON_NEW
          L1L_NAME  = '.'
          C1_RNAME  = MON_NEW

          CALL CP_ANAME_C1_L1
          CALL COPYC2(MDOC,IERR)  
          NEW_FLAG = 'C'
          LINE = 
     *' WARNING : monomer has different atom name with lib_description' 
          CALL MSGDOC(MDD,LINE)
          LINE = '                         '//
     *           'program will change atom names of description'
          CALL MSGDOC(MDD,LINE)

 510      CONTINUE

          IF(LML_PRSNT(L).EQ.'M') THEN
            LINE = ' WARNING : monomer has the minimal description' 
            CALL MSGDOC(MDD,LINE)
c            LINE = '                         '//
c     *           'program will create complete description'
c            CALL MSGDOC(MDD,LINE)
          ENDIF
        ENDIF

      ENDIF

      IF(MON_NEW(1:1).EQ.' ') THEN    
C       create new for old mon_name = MON 
C       new_flag = 'N', MON_NEW = ' '

        NEW_FLAG  = 'Y'
        L1L_PRSNT = 'N'
c --
        L1L_MNAME = MON
        L1L_MNAME2= MON
        C1_RNAME  = MON
        L1L_NAME  = '.'
        L1L_CODE1 = 'x'
        L1L_TYPE  = 'non-polymer'
        L1L_MODE  = '.'
        L1L_FORM  = '.'
        L1L_FUSE  = '?'
        L1L_HFLAG = '.'
        L1L_NATM  = C1_NATOM
        L1L_NHATM = 0
        L1A_NATOM = C1_NATOM
        L1A_NHATOM= 0
        L1N_NCONN = 0
        L1B_NBOND = 0
        L1G_NANGL = 0
        L1T_NTORS = 0
        L1C_NCHIR = 0
        L1P_NPLAN = 0
        DO I=1,C1_NATOM
          L1A_COOR_FLAG(I) = 'Y'
          IF(C1_OCC(I).LT.0.0001) L1A_COOR_FLAG(I) = 'N'
          L1A_X    (I) = C1_XYZ(1,I)
          L1A_Y    (I) = C1_XYZ(2,I)
          L1A_Z    (I) = C1_XYZ(3,I)
          L1A_CHARG(I) = S1_CHAR(I) 
          L1A_INEW (I) = I
          L1A_IOLD (I) = I
          L1A_ICR  (I) = 0
          L1A_NDIST(I) = 0
          L1A_IBACK(I) = 0
          L1A_IFORW(I) = 0
          L1A_BACK (I) = '.'
          L1A_TYPE (I) = '.' 
          L1A_FORW (I) = '.'
          L1A_ANAME(I) = C1_ANAME(I)
          L1A_CHEM (I) = S1_CHEM (I)
          L1A_SYMB (I) = C1_ASYMB(I) 
          ASYMB = CS_ATYPE(C1_SF_ID(I))
          CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
          L1A_SF_ID(I) = INSF
          L1A_CHEM (I) = L1A_SYMB(I) 
          L1A_ATYPE(I) = C1_ATYPE(I)
          DO  J=1,MAX1BRN 
            L1A_CONN   (J,I) = 0
            L1A_LENCON (J,I) = 0
          ENDDO
          DO  J=1,MAX1EXT 
            L1A_IEXTR (J,I)  = 0
          ENDDO
        ENDDO

        IF(SRCH.EQ.'G') THEN

          MODE = ' '
          CALL COOR_CONN(MDOC,MODE,IERR)

          IMON = 0
          CALL LIB_CREATE_TEST_INDEX2(MDOC,IMON
     *            ,NAC,C_CONTENT,C_INDEX,C_PAIR,IERR)
          IF(IERR.NE.0) THEN
            LINE = ' ERROR : monomer '//MON//
     *      ' in subroutine LIB_CREATE_TEST_INDEX2'
            CALL MSGERR(MDOC,LINE)
            IERR = 1
            RETURN
          ENDIF


          IF(LIST.EQ.'T') THEN
          WRITE(LINE,'(I4,1X,2X,1X,A8,1X,I4,1X,A30,1X,A24)')
     *             IMON,MON,NAC,C_CONTENT,C_INDEX
          CALL MSGDOC(MDOC,LINE)
          WRITE(LINE,'(17X,A24)') C_PAIR
          CALL MSGDOC(MDOC,LINE)
          ENDIF

          IF(LIST.EQ.'T') THEN
            CALL MSGDOC(MDOC,'--- test_gm ---')
          ENDIF

          CALL TEST_GM(MDOC,LIST,SRCH
     *              ,NAC,C_CONTENT,C_INDEX,C_PAIR,IERR)
          IF(IERR.EQ.0) THEN
            NEW_FLAG = 'G'
            MON_NEW  = L1L_MNAME
          ELSE
            IERR      = 0
            NEW_FLAG  = 'Y'
            MON_NEW   = ' '
            L1L_PRSNT = 'N'
c --
            L1L_MNAME = MON
            L1L_MNAME2= MON
            C1_RNAME  = MON
            L1L_NAME  = '.'
            L1L_CODE1 = 'x'
            L1L_TYPE  = 'non-polymer'
            L1L_MODE  = '.'
            L1L_FORM  = '.'
            L1L_FUSE  = '?'
            L1L_HFLAG = '.'
            L1L_NATM  = C1_NATOM
            L1L_NHATM = 0
            L1A_NATOM = C1_NATOM
            L1A_NHATOM= 0
            L1N_NCONN = 0
            L1B_NBOND = 0
            L1G_NANGL = 0
            L1T_NTORS = 0
            L1C_NCHIR = 0
            L1P_NPLAN = 0
            DO I=1,C1_NATOM
              L1A_COOR_FLAG(I) = 'Y'
              IF(C1_OCC(I).LT.0.0001) L1A_COOR_FLAG(I) = 'N'
              L1A_X    (I) = C1_XYZ(1,I)
              L1A_Y    (I) = C1_XYZ(2,I)
              L1A_Z    (I) = C1_XYZ(3,I)
              L1A_CHARG(I) = S1_CHAR(I) 
              L1A_INEW (I) = I
              L1A_IOLD (I) = I
              L1A_ICR  (I) = 0
              L1A_NDIST(I) = 0
              L1A_IBACK(I) = 0
              L1A_IFORW(I) = 0
              L1A_BACK (I) = '.'
              L1A_TYPE (I) = '.' 
              L1A_FORW (I) = '.'
              L1A_ANAME(I) = C1_ANAME(I)
              L1A_CHEM (I) = S1_CHEM (I)
              L1A_SYMB (I) = C1_ASYMB(I) 
              ASYMB = CS_ATYPE(C1_SF_ID(I))
              CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
              L1A_SF_ID(I) = INSF
              L1A_CHEM (I) = L1A_SYMB(I) 
              L1A_ATYPE(I) = C1_ATYPE(I)
              DO  J=1,MAX1BRN 
                L1A_CONN   (J,I) = 0
                L1A_LENCON (J,I) = 0
              ENDDO
              DO  J=1,MAX1EXT 
                L1A_IEXTR (J,I)  = 0
              ENDDO
            ENDDO
          ENDIF        
        ENDIF

      ENDIF

      RETURN
      END

      SUBROUTINE CP_ANAME_C1_L1
C ----------------------------------------------------
C -------------------------
      INCLUDE 'lib_com.fh'
C -------------------------
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C ----------------------------------------------------
      DO IC=1,C1_NATOM

      IF(L1A_NATOM.GT.0) THEN
        DO I=1, L1A_NATOM
          IF(C2_ANAME(IC).EQ.L1A_ANAME(I)) L1A_ANAME(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1A_BACK(I)) L1A_BACK(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1A_FORW(I)) L1A_FORW(I) = C1_ANAME(IC)
        ENDDO
      ENDIF
      IF(L1N_NCONN.GT.0) THEN
        DO I=1, L1N_NCONN
          IF(C2_ANAME(IC).EQ.L1N_1ATM(I)) L1N_1ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1N_2ATM(I)) L1N_2ATM(I) = C1_ANAME(IC)
        ENDDO
      ENDIF
      IF(L1B_NBOND.GT.0) THEN
        DO I=1,L1B_NBOND
          IF(C2_ANAME(IC).EQ.L1B_1ATM(I)) L1B_1ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1B_2ATM(I)) L1B_2ATM(I) = C1_ANAME(IC)
        ENDDO
      ENDIF
      IF(L1G_NANGL.GT.0) THEN
        DO I=1,L1G_NANGL
          IF(C2_ANAME(IC).EQ.L1G_1ATM(I)) L1G_1ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1G_2ATM(I)) L1G_2ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1G_3ATM(I)) L1G_3ATM(I) = C1_ANAME(IC)
        ENDDO
      ENDIF
      IF(L1T_NTORS.GT.0) THEN
        DO I=1,L1T_NTORS
          IF(C2_ANAME(IC).EQ.L1T_1ATM(I)) L1T_1ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1T_2ATM(I)) L1T_2ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1T_3ATM(I)) L1T_3ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1T_4ATM(I)) L1T_4ATM(I) = C1_ANAME(IC)
        ENDDO
      ENDIF
      IF(L1C_NCHIR.GT.0) THEN
        DO I=1,L1C_NCHIR
          IF(C2_ANAME(IC).EQ.L1C_1ATM(I)) L1C_1ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1C_2ATM(I)) L1C_2ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1C_3ATM(I)) L1C_3ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1C_4ATM(I)) L1C_4ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1C_5ATM(I)) L1C_5ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1C_6ATM(I)) L1C_6ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1C_7ATM(I)) L1C_7ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1C_8ATM(I)) L1C_8ATM(I) = C1_ANAME(IC)
          IF(C2_ANAME(IC).EQ.L1C_9ATM(I)) L1C_9ATM(I) = C1_ANAME(IC)
       ENDDO
      ENDIF

      IF(L1P_NPLAN.GT.0) THEN
        DO IP=1,L1P_NPLAN
          DO   I=1,L1P_NATOM (L1P_NPLAN)
            ICH4 = L1P_ATOM(I,IP)  
            IF(C2_ANAME(IC).EQ.CH4) THEN
               CH4 =  C1_ANAME(IC)
               L1P_ATOM(I,IP) = ICH4
            ENDIF
          ENDDO  
        ENDDO
      ENDIF  

      ENDDO
C ----------
      RETURN
      END

      SUBROUTINE CALC_INDEX_CRD(MDOC,MON,N,C_CONTENT
     *                                    ,C_INDEX,C_PAIR,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4,MON*8,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C ------------------------------------------
C     CHARACTER LINE*256
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
C --------------------------------
      IERR = 0
C     M    =-ABS(MDOC)-1
C ------------------------------------------
      MODE = 'CRD '

      ISYN = 1
      LIST = 'S'
C ????
      CALL CHECK_COMPL(MDOC,LIST,MODE,ISYN,MON,IERR)

      C_CONTENT = MTC_C_CONTENT
      C_INDEX   = MTC_C_INDEX
      C_PAIR    = MTC_C_PAIR
      N         = MTC_NA1
      RETURN
      END

      SUBROUTINE CALC_INDEX_DIFF(MDOC,C_CONTENT1,C_INDEX1,C_PAIR1
     *    ,C_CONTENT2,C_INDEX2,C_PAIR2,IDIFFC,IDIFFI,IDIFFP,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      CHARACTER C_INDEX1  *24
      CHARACTER C_CONTENT1*30
      CHARACTER C_INDEX2  *24
      CHARACTER C_CONTENT2*30
      CHARACTER C_PAIR1   *24
      CHARACTER C_PAIR2   *24
C ------------------------------------------
C     CHARACTER LINE*256
      CHARACTER CHAR2*2,CHAR3*3
      INTEGER*4 ICHAR1,ICHAR2
C ------------------------
      IERR = 0
C     M    =-ABS(MDOC)-1
C --------
      IDIFFC = 0
      IDIFFI = 0
      IDIFFP = 0

C      DO I=1,30
      DO I=4,15
        I1 = (I-1)*2 + 1
        I2 = I1 + 1
        CHAR2 = C_CONTENT1(I1:I2)
C        CALL CHTOINT(CHAR,ICHAR1)
        READ(CHAR2,'(I2)') ICHAR1
        CHAR2 = C_CONTENT2(I1:I2)
C        CALL CHTOINT(CHAR,ICHAR2)
        READ(CHAR2,'(I2)') ICHAR2
        IDIFFC = IDIFFC + ABS(ICHAR1-ICHAR2)
      ENDDO

C      DO I=1,8

      DO I=1,6
        I1 = (I-1)*3 + 1
        I2 = I1 + 2
        CHAR3 = C_INDEX1(I1:I2)
C        CALL CHTOINT(CHAR,ICHAR1)
        READ(CHAR3,'(I3)') ICHAR1
        CHAR3 = C_INDEX2(I1:I2)
C        CALL CHTOINT(CHAR,ICHAR2)
        READ(CHAR3,'(I3)') ICHAR2
        IDIFFI = IDIFFI + ABS(ICHAR1-ICHAR2)
      ENDDO

      DO I=1,8
        I1 = (I-1)*3 + 1
        I2 = I1 + 2
        CHAR3 = C_PAIR1(I1:I2)
C        CALL CHTOINT(CHAR,ICHAR1)
        READ(CHAR3,'(I3)') ICHAR1
        CHAR3 = C_PAIR2(I1:I2)
C        CALL CHTOINT(CHAR,ICHAR2)
        READ(CHAR3,'(I3)') ICHAR2
        IDIFFP = IDIFFP + ABS(ICHAR1-ICHAR2)
      ENDDO
C --------
      RETURN
      END

      SUBROUTINE CHECK_CMP_MON3(MDOC,LIST,IT,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR,IT
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER ASYMB*4,CTYPE*4,MODE_M*4,MON*8,RES*5,CHAIN*4
      CHARACTER MODE*4,LINE*256,LIST*1
C -----------------------------------
      IERR = 0
      MD   = 99   
      M    = -ABS(MDOC)-1
      IF(LIST.EQ.'S') MDOC = MD

      IF(L1A_NATOM.LE.0) THEN
        WRITE(LINE,'(A,A,A,I6)')
     *' ERROR: number of atoms in monomer (lib) ',L1L_MNAME,' = ',
     * L1A_NATOM
        CALL MSGERR(MDOC,LINE)
        IERR=1
        RETURN
      ENDIF

      NA        = L1A_NATOM
      MON       = L1L_MNAME        
      RES       = C1_PNUM(3:7)
      CHAIN     = C1_PNUM(1:2)//'  '

      IF(NA.LE.0.OR.C1_NATOM.LE.0) THEN
        RETURN
      ENDIF

C ---- check ----
      L1A_NHATOM = 0
      DO I=1,NA
        L1A_INEW (I) = I 
        L1A_IOLD (I) = I
        L1A_ICHEM(I) = 0              
        L1A_ICR  (I) = 0
        L1A_NDIST(I) = 0
        L1A_IBACK(I) = 0
        L1A_IFORW(I) = 0
c        L1A_BACK (I) = '.'
C        L1A_TYPE (I) = '.' 
c        L1A_FORW (I) = '.'
        DO  J=1,MAX1BRN 
          L1A_CONN   (J,I) = 0
          L1A_LENCON (J,I) = 0
        ENDDO
        DO  J=1,MAX1EXT 
          L1A_TEXTR (J,I) = 0
          L1A_IEXTR (J,I) = 0
        ENDDO
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *     ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *     ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
          CTYPE='C   '
        ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
          CTYPE='H   '
          L1A_NHATOM   = L1A_NHATOM + 1
        ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
          CTYPE='P   '
        ELSE
          CTYPE='$   '
        ENDIF
        L1A_ATYPE(I)=CTYPE(1:1)
      ENDDO

      IF(IT.EQ.1) RETURN
C --
      MODE=' '
      CALL LIB_CONN(MDOC,MODE,IERR)
      CALL CRD_CONN(MDOC,MODE,IERR)

      MODE_M = '    '
      ISYN   = 2
      CALL CHECK_COMPL(MDOC,LIST,MODE_M,ISYN,MON,IERR)

      IF(LIST.EQ.'T'.OR.LIST.EQ.'L') THEN
        IF(IERR.NE.0) THEN
          WRITE(LINE,
     *    '('' WARNING : residue: '',A,'' '',A,'' chain:'',A)') 
     *    MON,RES,CHAIN
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,'(A,A,A,I2)')
     *    ' WARNING : ',MON,
     *    ' : program can not match library description....',IERR
          CALL MSGERR(MDOC,LINE)
        ENDIF
      ENDIF

      RETURN 
      END

      SUBROUTINE CHECK_MON_LIB(MDOC,MON,CHAR12
     * ,AMON,MOD,NEW_FLAG,NMUSE,NMNEW,TYPE,LIST,IERR)
C -----------------------------------------
C -P- CHKMON - looks for monomer's name in the library list
C              , set use_flag = "Y".
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR,NMUSE
      CHARACTER MON*8,AMON*8,MOD*8,NEW_FLAG*1,TYPE*16,NODIST*1
      CHARACTER MOD_R*1,RES*5,CHAIN*4
      CHARACTER CHAR12*12,MON2*8,MON3*8,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256
C --------------------------------
      IERR=0

      RES       = CHAR12(3:7)
      CHAIN     = CHAR12(8:11)
      C1_PNUM   = CHAR12
      TYPE      = '.'
      AMON      = '.'
      MOD       = '.'

      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of monomer in the library = 0')
        IERR=2
        RETURN
      ENDIF

      DO L=1,LML_NMON
        IF(MON.EQ.LML_MNAME(L)) THEN
          AMON = '.'
          MOD  = '.'
          TYPE = LML_TYPE(L)
          GO TO 100
        ENDIF     
      ENDDO

      MON2 = MON

      IF(LMS_NSYN.GT.0) THEN
        DO LL=1,LMS_NSYN
          IF(LMS_AMNAME(LL).EQ.MON) THEN
            AMON  = MON 
            MON2  = LMS_MNAME(LL)
            MOD   = LMS_MOD  (LL)
            DO L=1,LML_NMON
              IF(MON2.EQ.LML_MNAME(L)) THEN
                MON  = MON2
                TYPE = LML_TYPE(L)
                GO TO 100
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

      MON = MON2       

      IF(LDR_NDER.GT.0) THEN
        DO LL=1,LDR_NDER
          IF(LDR_MNAME(LL).EQ.MON2) THEN
            AMON = LDR_SMNAME(LL)
C           MOD  = LDR_MOD   (LL)
            TYPE = LDR_TYPE  (LL)
            DO L=1,LML_NMON
              IF(AMON.EQ.LML_MNAME(L)) THEN
                GO TO 100
              ENDIF
            ENDDO
            MON3 = AMON
            DO LLL=1,LDR_NDER
              IF(LDR_MNAME(LLL).EQ.MON3) THEN
                AMON = LDR_SMNAME(LLL)
C               MOD  = LDR_MOD(LLL)
                DO L=1,LML_NMON
                  IF(AMON.EQ.LML_MNAME(L)) THEN
                    TYPE = LML_TYPE(L)
                    GO TO 100
                  ENDIF
                ENDDO
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

C     monomer is not found.
      LINE = ' WARNING : residue: '//MON//' '//RES//' chain:'//CHAIN
     *       //' - not found in the library' 
      CALL MSGDOC(MDOC,LINE)

C      WRITE(LINE,                  
C     *'(''                         program will create description of ne
C     *w monomer'')')
C      CALL MSGERR(MDOC,LINE)

      IERR=1
      IF(LML_NMON.GE.MAXMLIST) THEN
        WRITE(LINE,
     *  '('' ERR: number of monomers >'',I6,'' /lib. limit/'')') 
     *  MAXMLIST
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     *  '        Change parameter MAXMLIST in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF

      C1_NATOM  = 0

      L1L_MNAME = MON 
      L1L_MNAME2= MON
      L1L_NAME  = '.'
      L1L_CODE1 = 'x'
      L1L_TYPE  = 'non-polymer'
      L1L_MODE  = '.'
      L1L_FORM  = '.'
      L1L_FUSE  = '?'
      L1L_PRSNT = 'N'
      L1L_HFLAG = '.'
      L1L_NATM  = 0
      L1L_NHATM = 0
      L1A_NATOM = 0
      L1A_NHATOM= 0
      L1N_NCONN = 0
      L1B_NBOND = 0
      L1G_NANGL = 0
      L1T_NTORS = 0
      L1C_NCHIR = 0
      L1P_NPLAN = 0
      AMON      = '.'
      MOD       = '.'
      TYPE      = L1L_TYPE
      NEW_FLAG  = 'Y'
      NMUSE     = NMUSE + 1
c     NMNEW     = NMNEW + 1

C -- 06.04.03
      LB_PASS = 0

      RETURN

  100 CONTINUE

C -----
      IF(LML_FUSE(L).EQ.'N') THEN
C       read mon_lib.cif
        LML_FUSE(L) = 'R'
        MOD_R       = 'M'
        NODIST      = 'N'
        CALL READ_LIB(MDOC,MOD_R,NODIST,LIST,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
C ----
      CALL CP_MLIB(MDOC,MON,IERR)
      IF(IERR.NE.0) RETURN
C -- 06.04.03
      LB_PASS = LML_PASS(L)

      C1_NATOM  = 0

      IF(LML_PRSNT(L).EQ.'M') THEN

        NEW_FLAG = 'M'
        LINE = ' WARNING : residue: '//MON//' '//RES//' chain:'//CHAIN
     *       //'- has the minimal description' 
        CALL MSGDOC(MDOC,LINE)
c        WRITE(LINE,                  
c     *'(''                         program will create complete descript
c     *ion'')')
c        CALL MSGDOC(MDOC,LINE)
        NMUSE = NMUSE + 1
c       NMNEW = NMNEW + 1

      ELSE
C -----
        IF(LML_PRSNT(L).EQ.'N') THEN
          NMUSE        = NMUSE + 1
          LML_PRSNT(L) = 'Y'
        ENDIF
        NEW_FLAG = 'N'

      ENDIF
C ---
      RETURN
      END     

      SUBROUTINE CHECK_MON_NAME_IN_LIB(MON,IERR)
C -----------------------------------------
      INTEGER*4 IERR
      CHARACTER MON*8,AMON*8,MON2*8,MON3*8
C ---
      INCLUDE 'lib_com.fh'
C --------------------------------
      IERR=0

      AMON      = '.'

      IF(LML_NMON.LE.0) THEN
        IERR=1
        RETURN
      ENDIF

      DO L=1,LML_NMON
        IF(MON.EQ.LML_MNAME(L)) THEN
          GO TO 100
        ENDIF     
      ENDDO

      MON2 = MON

      IF(LMS_NSYN.GT.0) THEN
        DO LL=1,LMS_NSYN
          IF(LMS_AMNAME(LL).EQ.MON) THEN
            AMON  = MON 
            MON2  = LMS_MNAME(LL)
            DO L=1,LML_NMON
              IF(MON2.EQ.LML_MNAME(L)) THEN
                MON  = MON2
                GO TO 100
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

      MON = MON2       

      IF(LDR_NDER.GT.0) THEN
        DO LL=1,LDR_NDER
          IF(LDR_MNAME(LL).EQ.MON2) THEN
            AMON = LDR_SMNAME(LL)
            DO L=1,LML_NMON
              IF(AMON.EQ.LML_MNAME(L)) THEN
                GO TO 100
              ENDIF
            ENDDO
            MON3 = AMON
            DO LLL=1,LDR_NDER
              IF(LDR_MNAME(LLL).EQ.MON3) THEN
                AMON = LDR_SMNAME(LLL)
                DO L=1,LML_NMON
                  IF(AMON.EQ.LML_MNAME(L)) THEN
                    GO TO 100
                  ENDIF
                ENDDO
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF
      IERR = 1
 100  CONTINUE
      RETURN
      END


C ******
      SUBROUTINE CHECK_ANAME(MON,AMON,MOD,ANAME,ALT_NAME)
C -----------------------------------------
C -P- CHECK_NAME - ATOM'S NAME
C -S-
C -----------------------------------------
      CHARACTER MON*8,AMON*8,ANAME*4,ALT_NAME*4
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C --------------------------------
      ALT_NAME = '.'
      IF(LMS_NSYN.GT.0) THEN

        DO L=1,LMS_NSYN
          IF(LMS_MNAME(L).EQ.MON.AND.LMS_ATOM(L).NE.'.') THEN
            IF(LMS_AMNAME(L).EQ.'.') THEN
              IF(LMS_AATOM(L).EQ.ANAME) THEN
                ALT_NAME = ANAME 
                ANAME    = LMS_ATOM(L)
                GO TO 100
              ENDIF
            ENDIF
          ENDIF
        ENDDO

  100   CONTINUE

        DO L=1,LMS_NSYN
          IF(LMS_MNAME(L).EQ.MON.AND.LMS_ATOM(L).NE.'.') THEN
            IF(LMS_AMNAME(L).EQ.AMON.AND.LMS_AMNAME(L).NE.'.') THEN
              IF(LMS_AATOM(L).EQ.ANAME) THEN
                ALT_NAME = ANAME 
                ANAME    = LMS_ATOM(L)
                GO TO 200
              ENDIF
            ENDIF
          ENDIF
        ENDDO

  200   CONTINUE

      ENDIF
      IF(ANAME.EQ.'H0  ') THEN
        ALT_NAME = ANAME 
        ANAME    = 'H   '
      ENDIF
      RETURN
      END     

      SUBROUTINE LPUT_NEW(MDOC,LIST,ALT_FOR_COPY,ITYPE,IERR)
C -----------------------------------------
C -P- LPUT_NEW - 
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
      INCLUDE 'link_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      CHARACTER MON*8,LINE*256,ASYMB*4,ALT_FOR_COPY*1,LIST*1
      CHARACTER CH1*1,EL_D*4,EL_F*4
C --------------------------------
      IF(C1_NATOM.LT.0) GO TO 200

      IF(C1_NATOM.GE.MX1ATOM) THEN
        MON = C1_RNAME 
        WRITE(LINE,'(A,A,A,I6)')
     *  ' ERROR: in "LPUT_NEW", number of atoms in monomer ',MON,' >',
     *  MX1ATOM
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     *  '          Change parameter MX1ATOM in "lib_com.fh"')
        IERR     = 0
        C1_NATOM =-1
        GO TO 200
      ENDIF

      IF(LIST.EQ.'T') THEN
         WRITE(*,*) 'LPUT:'
     *  ,C1_NATOM,CR_ANAME,';',CR_ALT,';',ALT_FOR_COPY,';',
     *  CR_ANAME_INP,';',CR_ASYMB,CR_SF_ID
      ENDIF

      IF(CR_ALT.NE.'.'.AND.CR_ALT.NE.ALT_FOR_COPY) RETURN
      IF(ITYPE.EQ.3) THEN
        IF(CR_ANAME.EQ.'OXT'.OR.CR_ANAME.EQ.'HXT'.OR.
     *     CR_ANAME.EQ.'HN1'.OR.CR_ANAME.EQ.'HN2'.OR.
     *     CR_ANAME.EQ.'HN3'.OR.CR_ANAME.EQ.'H1 '.OR.
     *     CR_ANAME.EQ.'H2 '.OR.CR_ANAME.EQ.'H3 '.OR.
     *                          CR_ANAME.EQ.'H'      ) RETURN
      ELSE IF(ITYPE.EQ.5) THEN
        IF(CR_ANAME.EQ.'O3T '.OR.CR_ANAME.EQ.'O3P '.OR.
     *     CR_ANAME.EQ.'HOP1'.OR.CR_ANAME.EQ.'HOP2'.OR.
     *     CR_ANAME.EQ.'HOP3'.OR.CR_ANAME.EQ.'HO3*'    ) RETURN
      ENDIF
      IF(C1_NATOM.GE.1) THEN
        DO I=1,C1_NATOM
          IF(CR_ANAME.EQ.C1_ANAME(I)) THEN
C            IF(CR_ALT.EQ.'.'.OR.
C     *         (CR_ALT.EQ.ALT_FOR_COPY.AND.C1_ALT(I).NE.'.')) THEN
C              GO TO 100
C            ENDIF
            RETURN
C           IF(C1_ALT(I).EQ.'.') RETURN
C           IF(C1_ALT(I).EQ.ALT_FOR_COPY) RETURN
          ENDIF
        ENDDO
      ENDIF

      C1_NATOM             = C1_NATOM + 1
      C1_RNAME             = CR_RNAME
      C1_OCC  (C1_NATOM)   = CR_OCC
      C1_XYZ  (1,C1_NATOM) = CR_XYZ(1)
      C1_XYZ  (2,C1_NATOM) = CR_XYZ(2)
      C1_XYZ  (3,C1_NATOM) = CR_XYZ(3)
      S1_CHAR (C1_NATOM)   = 0.0
      S1_INEW (C1_NATOM)   = C1_NATOM 
      S1_IOLD (C1_NATOM)   = C1_NATOM
      S1_ICRD (C1_NATOM)   = 0
      S1_NDIST(C1_NATOM)   = 0
      S1_IBACK(C1_NATOM)   = 0
      S1_IFORW(C1_NATOM)   = 0
      S1_BACK (C1_NATOM)   = '.'
      S1_FORW (C1_NATOM)   = '.'
      C1_ANAME(C1_NATOM)   = CR_ANAME
      C1_ANAME_INP(C1_NATOM)   = CR_ANAME_INP
      C1_ASYMB(C1_NATOM)   = CR_ASYMB 

C      S1_CHEM (C1_NATOM)   = CR_ASYMB 
      S1_CHEM (C1_NATOM)   = ST_CHEM

      C1_ATYPE(C1_NATOM)   = CR_ATYPE 
      C1_SF_ID(C1_NATOM)   = CR_SF_ID
      C1_ALT  (C1_NATOM)   = CR_ALT
      C1_CORR (C1_NATOM)   = CR_CORR
      DO  J=1,MX1BRN 
        S1_CONN   (J,C1_NATOM) = 0
        S1_LENCON (J,C1_NATOM) = 0
      ENDDO
      DO  J=1,MX1EXT 
        S1_IEXTR (J,C1_NATOM) = 0
      ENDDO

 200  CONTINUE
C ------
      IF(LIST.EQ.'T') THEN
         WRITE(*,*) '-L1L_PRSNT',L1L_PRSNT
         WRITE(*,*) '--',L1A_natom
      ENDIF

      IF(L1L_PRSNT.EQ.'M') THEN

        MON = L1L_MNAME
        IF(L1A_NATOM.LE.0) THEN
          WRITE(LINE,'(A,A3,A)')
     * ' ERROR: in "LPUT_NEW", number of atoms in monomer ',MON,' <'
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF

        DO I=1,L1A_NATOM
c         L1A_CHARG(I) = 0.0
          IF(L1A_ANAME(I).EQ.CR_ANAME) THEN
            L1A_COOR_FLAG(I) = 'Y'
            IF(CR_OCC.LT.0.0001) L1A_COOR_FLAG(I) = 'N'
            L1A_X    (I) = CR_XYZ(1)
            L1A_Y    (I) = CR_XYZ(2)
            L1A_Z    (I) = CR_XYZ(3)
            L1A_INEW (I) = I
            L1A_IOLD (I) = I
            L1A_ICR  (I) = 0
            L1A_NDIST(I) = 0
            L1A_IBACK(I) = 0
            L1A_IFORW(I) = 0
            L1A_BACK (I) = '.'
            L1A_TYPE (I) = '.' 
            L1A_FORW (I) = '.'
            L1A_SYMB (I) = CR_ASYMB 
            L1A_CHARG(I) = 0.0
            INSF         = CR_SF_ID
            ASYMB = CS_ATYPE(INSF)
            CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
            L1A_SF_ID(I) = INSF
            DO  J=1,MAX1BRN 
              L1A_CONN   (J,I) = 0
              L1A_LENCON (J,I) = 0
            ENDDO
            DO  J=1,MAX1EXT 
              L1A_IEXTR (J,I)  = 0
            ENDDO
C            NCONN_PDB=0
C            NHENT    =0
            GO TO 100
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A,A,A4,A,A)')
     *  ' WARNING: in monomer ',MON,' atom :',CR_ANAME,' not found',
     *  ' in the library list'
        CALL MSGDOC(MDOC,LINE)

 100    CONTINUE

      ELSE IF(L1L_PRSNT.EQ.'N') THEN

        IF(L1A_NATOM.GT.0) THEN
          DO I=1,L1A_NATOM
            IF(L1A_ANAME(I).EQ.CR_ANAME) RETURN
          ENDDO
        ENDIF
        IF(L1A_NATOM.GE.MAX1ATM) THEN
          WRITE(LINE,'(A,A3,A,I6)')
     *  ' ERROR: in "LPUT_NEW", number of atoms in monomer ',MON,' >',
     *  MAX1ATM
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *    '          Change parameter MAX1ATM in "lib_com.fh"')
          IERR=1
          RETURN
        ENDIF

        L1A_NATOM = L1A_NATOM + 1
        L1A_COOR_FLAG(L1A_NATOM) = 'Y'
        IF(CR_OCC.LT.0.0001) L1A_COOR_FLAG(L1A_NATOM) = 'N'
        L1A_CHARG(L1A_NATOM) = 0.0
        L1A_X    (L1A_NATOM) = CR_XYZ(1)
        L1A_Y    (L1A_NATOM) = CR_XYZ(2)
        L1A_Z    (L1A_NATOM) = CR_XYZ(3)
        L1A_INEW (L1A_NATOM) = L1A_NATOM 
        L1A_IOLD (L1A_NATOM) = L1A_NATOM
        L1A_ICR  (L1A_NATOM) = 0
        L1A_NDIST(L1A_NATOM) = 0
        L1A_IBACK(L1A_NATOM) = 0
        L1A_IFORW(L1A_NATOM) = 0
        L1A_BACK (L1A_NATOM) = '.'
        L1A_TYPE (L1A_NATOM) = '.' 
        L1A_FORW (L1A_NATOM) = '.'
        L1A_ANAME(L1A_NATOM) = CR_ANAME
        L1A_SYMB (L1A_NATOM) = CR_ASYMB 
        INSF = CR_SF_ID
        L1A_SF_ID(L1A_NATOM) = INSF
        ICHARGE = 0
        EL_F    = CS_ELEMENT(INSF)
        CALL LENSTR_BL(CS_ELEMENT(INSF),LLL)
        
        IF(CS_ELEMENT(INSF)(1:1).EQ.'?') THEN
          EL_F = CR_ASYMB
        ELSE IF(LLL.GE.3) THEN
          IF(CS_ELEMENT(INSF)(2:2).EQ.'+'.OR.
     *      CS_ELEMENT(INSF)(2:2).EQ.'-'    ) THEN
            EL_F = CS_ELEMENT(INSF)                          
            CH1  = CS_ELEMENT(INSF)(3:3)
            READ(CH1,'(I1)') ICHARGE
            IF(CS_ELEMENT(INSF)(2:2).EQ.'-')ICHARGE=-ICHARGE
          ELSE IF(LLL.GE.4) THEN
            IF(CS_ELEMENT(INSF)(3:3).EQ.'+'.OR.
     *        CS_ELEMENT(INSF)(3:3).EQ.'-'    ) THEN
              EL_F = CS_ELEMENT(INSF)
              CH1  = CS_ELEMENT(INSF)(4:4)
              READ(CH1,'(I1)') ICHARGE
              IF(CS_ELEMENT(INSF)(3:3).EQ.'-')ICHARGE=-ICHARGE
            ENDIF
          ENDIF
        ENDIF
C       CALL CUT_EL_NAME(EL_D)
        CALL CUT_EL_NAME(EL_F)
C       EL_F - element from file (without +/-)

        L1A_SYMB (L1A_NATOM) = EL_F
        L1A_CHARG(L1A_NATOM) = ICHARGE
        L1A_CHEM (L1A_NATOM) = CR_ASYMB 
        L1A_ATYPE(L1A_NATOM) = CR_ATYPE 
        IF(L1A_CHEM(L1A_NATOM)(1:2).NE.'H '.AND.
     *     L1A_CHEM(L1A_NATOM)(1:2).NE.'D ' )
     *     L1A_NHATOM=L1A_NHATOM + 1
        DO  J=1,MAX1BRN 
          L1A_CONN   (J,L1A_NATOM) = 0
          L1A_LENCON (J,L1A_NATOM) = 0
        ENDDO
        DO  J=1,MAX1EXT 
          L1A_IEXTR (J,L1A_NATOM) = 0
        ENDDO
        IF(NHENT.GT.0) THEN
          DO I=1,NHENT
            IF(HENT_ID(I).EQ.L1L_MNAME) THEN
              L1L_NAME = HENT_NAME(I)            
              L1L_FORM = HENT_FORMUL(I)
            ENDIF
          ENDDO
        ENDIF

      ENDIF

      RETURN
      END     

      SUBROUTINE CHECK_CMP_MON5(MMDOC,LIST,CHECK,IG,IR,IAS
     *                      ,NMON_CRT_NEW,MON_NEW,NEW_FLAG,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4,NEW_FLAG*1,MON_NEW*8,LIST*1,CHECK*1
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ---
      CHARACTER LINE*256,MON*8
      CHARACTER ASYMB*4,CTYPE*4,MOD*8,FUNC*3,MONN*8
      CHARACTER ATOM_MISS*4,ATOM_UNK*4,NAMEM*80,CHEMM*4,CHEMU*4
      CHARACTER MONOMER_NEW*8,RES*5,CHAIN*4,MODE_M*4,MTYPE*1
C -----------------------------------
c      COMMON/COM_NMON/ IFIRST_NM,NMON_CRT_NEW
c      INTEGER   IFIRST_NM,NMON_CRT_NEW
C -----------------------------------
C      INTEGER   NMOD_RES
C      CHARACTER MOD_RES(10)*8
      INTEGER   IATOM_UM(9),IATOM_MM(9)      
      CHARACTER ATOM_UM(9)*4,CHEMUM(9)*4,ATOM_MM(9)*4,CHEMMM(9)*4
C --------------------------------------
      IERR = 0
      MDOC = MMDOC
      MD   =-ABS(MDOC)-1
      M    = 99
      IF(LIST.EQ.'S') THEN
        MDOC = 999
        MD   = 999
      ELSE IF(LIST.EQ.'T'.OR.LIST.EQ.'L') THEN
        MD = MDOC
      ENDIF
C --------------
C     NEW_FLAG = 'N'
      IF(L1A_NATOM.LE.0) THEN
        WRITE(LINE,'(A,A,A,I6)')
     *  ' ERROR: number of atoms in monomer (lib) ',L1L_MNAME,' = ',
     *  L1A_NATOM
        CALL MSGERR(MDOC,LINE)
        IERR=1
        RETURN
      ENDIF

      NA        = L1A_NATOM
      MON       = C1_RNAME        
      NATM      = 0
      NATM_MISS = 0
      RES       = C1_PNUM(3:7)
      CHAIN     = C1_PNUM(8:11)

      IF(NA.LE.0.OR.C1_NATOM.LE.0) THEN
        RETURN
      ENDIF

      IFIRST_M=0

      IF(NA.GT.1) THEN
      DO I=1,NA-1
        DO J=I+1,NA
          IF(L1A_ANAME(I).EQ.L1A_ANAME(J)) THEN
            IF(IFIRST_M.EQ.0) THEN
              WRITE(LINE,
     * '('' WARNING : residue: '',A,'' '',A,'' chain:'',A)') 
     *        MON,RES,CHAIN
              CALL MSGDOC(MDOC,LINE)
              IFIRST_M=1
            ENDIF 
            WRITE(LINE,'(A,A,A,A4,A)')
     *' WARNING : ',MON,' : duplicated atom_name (lib) :"',
     * L1A_ANAME(I),'"'
            CALL MSGDOC(MDOC,LINE)
          ENDIF           
        ENDDO
      ENDDO
      ENDIF
C ---
      ATOM_MISS = '    '
      ATOM_UNK  = '    '
      N_MISS    = 0
      DO I=1,NA
        L1A_COOR_FLAG(I) = 'N'
        DO J=1,C1_NATOM
          IF(L1A_ANAME(I).EQ.C1_ANAME(J)) THEN
            IF(C1_OCC(J).GT.0.0001) THEN
              L1A_COOR_FLAG(I) = 'Y'
              L1A_X    (I) = C1_XYZ(1,J)
              L1A_Y    (I) = C1_XYZ(2,J)
              L1A_Z    (I) = C1_XYZ(3,J)
            ENDIF
            GO TO 700
          ENDIF
        ENDDO
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ') THEN
          IF(IFIRST_M.EQ.0) THEN
            WRITE(LINE,
     * '('' WARNING : residue: '',A,'' '',A,'' chain:'',A)') 
     *      MON,RES,CHAIN
            CALL MSGDOC(MDOC,LINE)
            IFIRST_M=1
          ENDIF 
          WRITE(LINE,
     *'( ''           atom: "'',A4,''" is absent in coord_file'')')
     *    L1A_ANAME(I)
          CALL MSGDOC(MDOC,LINE)
          ATOM_MISS  = L1A_ANAME(I)
          CHEMM      = ASYMB
          IATOM_MISS = I
          N_MISS     = N_MISS+1
          IF(NATM_MISS.LT.9) THEN
            NATM_MISS           = NATM_MISS +1
            ATOM_MM (NATM_MISS) = ATOM_MISS
            CHEMMM  (NATM_MISS) = ASYMB
            IATOM_MM(NATM_MISS) = I
          ENDIF
        ENDIF
 700    CONTINUE
      ENDDO


      N_UNKNOW=0
      DO J=1,C1_NATOM
        DO I=1,NA
          IF(L1A_ANAME(I).EQ.C1_ANAME(J)) GO TO 701
        ENDDO
        ASYMB = C1_ASYMB(J)
        IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ') THEN
          IF(IFIRST_M.EQ.0) THEN
            WRITE(LINE,
     * '('' WARNING : residue: '',A,'' '',A,'' chain:'',A)') 
     *      MON,RES,CHAIN
            CALL MSGDOC(MDOC,LINE)
            IFIRST_M=1
          ENDIF 
          WRITE(LINE,
     *'(''           atom: "'',A4,''" is absent in lib description.'')')
     *     C1_ANAME(J)
          CALL MSGDOC(MDOC,LINE)
          ATOM_UNK = C1_ANAME(J)
          CHEMU    = ASYMB
          IF(NATM.LT.9) THEN
            NATM           = NATM +1
            ATOM_UM (NATM) = ATOM_UNK
            CHEMUM  (NATM) = ASYMB
            IATOM_UM(NATM) = J
          ENDIF
          IATOM_UNK = J
          N_UNKNOW  = N_UNKNOW+1
        ENDIF
 701    CONTINUE
      ENDDO
C --       check compliteness,alt_name: 
C --       if(n_unknown >= n_miss > 0 ) --> check  
C
C          UNK   MISS
C
C           0     0    return
C          =<9    0    /no MAD/ return 
C           0    =<9   MDL
C           1     1    synonym (if chem=chem),return / REP
C           2     2           -"-"-                  / check
C
C          else check
C 

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,
     *    '('' N_UNK,N_MISS: '',2I5)') 
     *    N_UNKNOW,N_MISS
        CALL MSGDOC(MDOC,LINE)
      ENDIF


      FUNC=' '
      IF(N_UNKNOW.LE.0.AND.N_MISS.LE.0) THEN
C       OK
        RETURN
      ELSE IF(N_UNKNOW.GT.0.AND.N_MISS.EQ.0) THEN
C       Nc > Nl
C       OK
        RETURN
      ELSE IF(N_UNKNOW.EQ.0.AND.N_MISS.GT.0) THEN
C       Nc < Nl
C       OK
        RETURN
      ELSE IF(N_UNKNOW.EQ.1.AND.N_MISS.EQ.1) THEN

        IF(CHEMU.EQ.CHEMM) THEN 
          C2_ANAME(IATOM_UNK) = L1A_ANAME(IATOM_MISS)
C         OK

          IF(LIST.EQ.'T') THEN
          WRITE(LINE,*)'U,M:',C2_ANAME(IATOM_UNK),L1A_ANAME(IATOM_MISS)
          CALL MSGDOC(MDOC,LINE)
          ENDIF

          RETURN
        ENDIF

      ELSE IF(N_UNKNOW.EQ.2.AND.N_MISS.EQ.2) THEN

        IF((CHEMUM(1).EQ.CHEMMM(1)).AND.(CHEMUM(2).EQ.CHEMMM(2)).OR.
     *     (CHEMUM(2).EQ.CHEMMM(1)).AND.(CHEMUM(1).EQ.CHEMMM(2))) THEN
          IF(CHEMUM(1).EQ.CHEMMM(1)) THEN
            IU1 = IATOM_UM(1)
            IU2 = IATOM_UM(2)
          ELSE
            IU1 = IATOM_UM(2)
            IU2 = IATOM_UM(1)
          ENDIF
          IM1 = IATOM_MM(1)
          IM2 = IATOM_MM(2)

          IF(LIST.EQ.'T') THEN
            WRITE(LINE,*)'CHEM:',CHEMUM(1),CHEMMM(1),CHEMUM(2),CHEMMM(2)
            CALL MSGDOC(MDOC,LINE)
            WRITE(LINE,*) IM1,IM2,IU1,IU2
            CALL MSGDOC(MDOC,LINE)
          ENDIF

          C2_ANAME(IU1) = L1A_ANAME(IM1)
          C2_ANAME(IU2) = L1A_ANAME(IM2)
C         OK    
          RETURN
        ENDIF

      ENDIF   
C
C     create new for: MON_NEW  = MONOMER_NEW (new_name) 
C                     NEW_FLAG = 'Y' 
C
      IF(NMON_CRT_NEW.GE.99) RETURN

      I = NMON_CRT_NEW + 1

 100  CONTINUE

      IF(I.GE.99) RETURN

      WRITE(MONOMER_NEW,'(I3)') I            
      MONOMER_NEW(1:1) = 'N'
      IF(MONOMER_NEW(2:2).EQ.' ') THEN
        MONOMER_NEW(2:2) = MONOMER_NEW(3:3)
        MONOMER_NEW(3:3) = ' '
      ENDIF

      CALL LENSTR_BL(MONOMER_NEW,LEN)
      CALL LENSTR_BL(MON,LM)
      MON_NEW = MON(1:LM)//'_'//MONOMER_NEW(1:LEN)

      CALL CHECK_MON_NAME_IN_LIB(MON_NEW,IERR)
      IF(IERR.EQ.0) THEN
        I = I + 1
        GO TO 100
      ELSE
        IERR = 0
      ENDIF

      NMON_CRT_NEW = I

      C1_RNAME  = MON_NEW      
      L1L_MNAME = MON_NEW
      L1L_TYPE  = C1_RTYPE 
      NEW_FLAG  = 'Y'
      L1L_PRSNT = 'N'
c --
        L1L_MNAME2= '.'
        L1L_NAME  = '.'
        L1L_CODE1 = 'x'
        L1L_TYPE  = 'non-polymer'
        L1L_MODE  = '.'
        L1L_FORM  = '.'
        L1L_FUSE  = '?'
        L1L_HFLAG = '.'
        L1L_NATM  = C1_NATOM
        L1L_NHATM = 0
        L1A_NATOM = C1_NATOM
        L1A_NHATOM= 0
        L1N_NCONN = 0
        L1B_NBOND = 0
        L1G_NANGL = 0
        L1T_NTORS = 0
        L1C_NCHIR = 0
        L1P_NPLAN = 0
        DO I=1,C1_NATOM
          L1A_COOR_FLAG(I) = 'Y'
          IF(C1_OCC(I).LT.0.0001) L1A_COOR_FLAG(I) = 'N'
          L1A_X    (I) = C1_XYZ(1,I)
          L1A_Y    (I) = C1_XYZ(2,I)
          L1A_Z    (I) = C1_XYZ(3,I)
          L1A_CHARG(I) = S1_CHAR(I) 
          L1A_INEW (I) = I
          L1A_IOLD (I) = I
          L1A_ICR  (I) = 0
          L1A_NDIST(I) = 0
          L1A_IBACK(I) = 0
          L1A_IFORW(I) = 0
          L1A_BACK (I) = '.'
          L1A_TYPE (I) = '.' 
          L1A_FORW (I) = '.'
          L1A_ANAME(I) = C1_ANAME(I)
          L1A_CHEM (I) = S1_CHEM (I)
          L1A_SYMB (I) = C1_ASYMB(I) 
          ASYMB = CS_ATYPE(C1_SF_ID(I))
          CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
          L1A_SF_ID(I) = INSF
          L1A_CHEM (I) = L1A_SYMB(I) 
          L1A_ATYPE(I) = C1_ATYPE(I)
          DO  J=1,MAX1BRN 
            L1A_CONN   (J,I) = 0
            L1A_LENCON (J,I) = 0
          ENDDO
          DO  J=1,MAX1EXT 
            L1A_IEXTR (J,I)  = 0
          ENDDO
        ENDDO
C -------------------------------------------------
      RETURN
      END

      SUBROUTINE CHECK_DESCR_STRUCTURE(MMDOC,LIST,CHECK_SPEC
     *  ,DMIN_SPEC,CONN_FLAG,CIS_FLAG,LNK_FLAG,CHAIN_FLAG
     *  ,DNEW,NEW_FLAG,SS_FLAG,SUGAR_FLAG,CHECK,COOR,IERR)    
C -----------------------------------------------
C -P- CHECK_DESRC_STRUCTURE - 
C 
C     1. check atoms in special position.
C        ( if DMIN_SPEC > 0 )
C
C     2. check list of links. 
C
C     3. check chain connectivity, set residue"s conn_type
C        check type of peptide link: 'CIS' or 'TRANS' and
C        change it if CIS_FLAG = 'Y' 
C
C     4. check inter/intra chain links
C        if not in the dictionary: create it /set DNEW='Y'/
C        ( if LNK_FLAG = 'Y' )
C
C     5. check inter chain's connectivity 
C        if not in the dictionary: create it /set DNEW='Y'/
C        check actual distance: if big  - link will be ignored.      
C        ( if CONN_FLAG = 'Y' )
C
C     6. create new list of chains and set type of terminus residues.
C
C     7. check completeness of atom's list of residue.
C  --------------
C
C  input:
C
C     CONN_FLAG  - Y means : check & create new list of chains
C                                 create new list of links ( cis, ss, ...)
C                                 and modifications
C 
C     DMIN_SPEC  - minimum distance for special position / -1 not check /
C
C  output:
C
C     DNEW       - output flag for links. Y news new link was created.
C     NEW_FLAG   - output flag. Y means new monomer was found.
C
C --------------------------------------
C     atm_type() must be : H/D or C or $ ( setting in PRE_DESCR )
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER DNEW*1,NEW_FLAG*1,NAME*80,CHAIN_FLAG*1,SS_FLAG*1
      CHARACTER CONN_FLAG*1,CHECK_SPEC*1,CIS_FLAG*1,LNK_FLAG*1
      CHARACTER SUGAR_FLAG*1,LIST*1,CHECK*1,COOR*1
C ******
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'link_com.fh'
C -----------------------------------------------------------
      IERR = 0
      MDOC = MMDOC
      MD   =-ABS(MDOC)-1
      IF(LIST.EQ.'S') MDOC = 999
      IF(LIST.EQ.'T') MD   = MDOC

      DNEW     = 'N'
      LSO_NSYM = CS_NSYM
      NSUG     = 0

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MD,' --- CHECK_DESCR_STRUCTURE --- ')
        CALL PRINT_INFO_TEST(MD)
      ENDIF

      LN_N_INIT  = LN_N

C ---
      CALL DEF_SPEC_POS(MDOC,CHECK_SPEC,DMIN_SPEC,IERR)
      IF(IERR.NE.0) RETURN

 
c       CALL DEF_LINK_MOD(MDOC,DNEW,IERR)
c       IF(IERR.NE.0) RETURN
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MD,' --- DEF_CONN --- ')
      ENDIF

      IF(CONN_FLAG.NE.'0') THEN
        CALL DEF_CONN(MMDOC,LIST,CONN_FLAG,CIS_FLAG,SUGAR_FLAG
     *             ,LN_N_INIT,DNEW,NSUG,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MD,' --- DEF_LINK_NEW --- ')
      ENDIF

      IF(LNK_FLAG.NE.'0') THEN
        CALL DEF_LINK_NEW(MDOC,LIST,LNK_FLAG,SS_FLAG,SUGAR_FLAG
     *                 ,LN_N_INIT,DNEW,NSUG,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      IF(LIST.EQ.'T') THEN
        Write(*,*) '--> nsug: ',nsug,N_GROUP
      ENDIF
     
      IF(CHAIN_FLAG.EQ.'Y'.OR.NSUG.GT.0) THEN

        IF(LIST.EQ.'T') THEN
          CALL MSGDOC(MD,' --- SET_CHAIN --- ')
          CALL PRINT_INFO_TEST(MD)
        ENDIF

        CALL SET_CHAIN(MDOC,SUGAR_FLAG,CHAIN_FLAG,LIST,IERR)
        IF(IERR.NE.0) RETURN

        IF(LIST.EQ.'T') THEN
          CALL MSGDOC(MD,' --- SET_MOD --- ')
          CALL PRINT_INFO_TEST(MD)
        ENDIF

        CALL SET_MOD(MDOC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MD,' --- CREAT_ENT_DESCR --- ')
        CALL PRINT_INFO_TEST(MD)
      ENDIF

      CALL CREAT_ENT_DESCR(MDOC,LIST,IERR)
      IF(IERR.NE.0) RETURN

c      IF(LIST.EQ.'T') THEN
c        CALL MSGDOC(MD,' --- CHECK_MTCH --- ')
c        CALL PRINT_INFO_TEST(MD)
c      ENDIF

c      NAME='makecif'
c      CALL CHECK_MTCH(MMDOC,LIST,NAME,NEW_FLAG,DNEW,CHECK,COOR,IERR)
c      IF(IERR.NE.0) RETURN

      RETURN
      END


      SUBROUTINE SET_IDLIM(ASYMB,ITYPE)
C -------------------------------
C     set atom's type of limit of covalent bond
C
C      ITYPE               DLIM:  
C         1 - H or D        1.2
C         2 - others        1.7
C         3 - P or S        2.4
C         4 - heavy atom    3.0
C
C      DATA DLIM/ 1.2, 1.7, 2.4, 3.0 / in DEF_CONN_NEW /
C --------------------------------
      CHARACTER ASYMB*4
      CHARACTER CH2*2
C --
      INCLUDE 'metal.fh'
C --
C      PARAMETER (N_NAME = 33)
C      CHARACTER NAME(N_NAME)*2
C -----------------
C      DATA NAME/'CO','MG','CA','ZN','CU','FE','CL','BR','MN','PB',
C     *          'HG','AL','GD','NA','CD','NI','SR','IN','HO','YB',
C     *          'TE','LI','RB','BA','CS','SM','TL','PT','BE','SE',
C     *          'MO','SI','I '/
C ??? more
C --
C ---------------------------------------------
      CH2 = ASYMB(1:2)
      DO  I=1,N_NAME
        IF(NAME(I).EQ.CH2) THEN
          ITYPE = 4
          GO TO 100
        ENDIF
      ENDDO
      IF(ASYMB.EQ.'H   '.OR.ASYMB.EQ.'D   ') THEN
        ITYPE = 1
      ELSE IF(ASYMB.EQ.'P   '.OR.ASYMB.EQ.'S   ') THEN
        ITYPE = 3
      ELSE
        ITYPE = 2
      ENDIF
  100 CONTINUE

      RETURN
      END


C ******
      SUBROUTINE DEF_LINK_NEW(MDOC,LIST,LNK_FLAG,SS_FLAG,SUGAR_FLAG
     *                  ,LN_N_INIT,DNEW,NSUG,IERR)
C -----------------------------------------------
C     check inter/intra chain links
C        if not in the dictionary: create it /set DNEW='Y'/
C               
C        LNK_FLAG - Y - use new link, N - just warning message
C        DNEW      - output info flag  
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,LN_N_INIT
      CHARACTER DNEW*1
      CHARACTER LNK_FLAG*1,SS_FLAG*1,SUGAR_FLAG*1
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ----------------------------------------------------------------
      INCLUDE 'link_com.fh'
C -----------------------------------
      REAL      XX1(3),XX2(3),XX3(3),XX4(3)
      CHARACTER MON1*8,MON2*8,ATOM1*4,ATOM2*4,MOD1*8,MOD2*8,LINKS*8
      CHARACTER LINK*8,ALT1*1,CORR1*1,ALT2*1,CORR2*1,MON_N*8,LINK_NEW*8
      CHARACTER LLL_FLAG*1,USER*1,SUG*1,LIST*1
      CHARACTER ASYMB1*4,ASYMB2*4,FLAG*1,COOR_FLAG*1,ATOM*4
      CHARACTER LINE*256
      CHARACTER DEF_FLAG*1,CNEW*1,MTYPE*1,SYMM1*8,SYMM2*8,SS*1
      CHARACTER ALT1_C*1,ALT2_C*1,CONN*1,CH1*1
      PARAMETER ( IDMAX = 4 )
      REAL      DLIM(IDMAX)
      DATA DLIM/ 1.2, 1.7, 2.4, 3.0 /
C -----------------------------------

      IF(LIST.EQ.'T') THEN
        write(*,*) '-def_link_new-',LNK_FLAG,SS_FLAG,SUGAR_FLAG
     *  ,ln_n,LN_N_INIT,mod_n
        if(ln_n.gt.0) then
        do i=1,LN_N
          write(*,*) '-C-'
     *     ,i,LN_ID(I),LN_USED(I),LN_ENT(I)
          write(*,*) '    '
     *    ,LN_1ICHN(i),LN_1IRES(i),LN_2ICHN(i),LN_2IRES(i)
          ir1 = LN_1IRES(i)
          ir2 = LN_2IRES(i)
          write(*,*) '    '
     *    ,RES_NUM_PDB(Ir1)(3:7),RES_NAME(Ir1),RES_NUM_PDB(Ir2)(3:7)
     *    ,RES_NAME(Ir2),LN_ATOM1(i),LN_ATOM2(I),LN_ALT1(I),LN_ALT2(I)
     *    ,LN_SYMM1(I),LN_SYMM2(I)
        enddo
        endif
      ENDIF

      IERR  = 0

      IF(N_GROUP.LE.0.OR.N_ATOM.LE.0) THEN
        IERR=1
        RETURN
      ENDIF

C     LN_N_INI  = LN_N
      NCONN_PDB = 0

      CALL DEF_CENTER(MDOC,IERR)
 
      DO ICH1=1,N_GROUP

      DO ICH2=ICH1,N_GROUP

        N_R1 = NRES_CHAIN(ICH1)   
        N_R2 = NRES_CHAIN(ICH2)   

        IRS1 = IRES_FIRST(ICH1)
        IRS2 = IRES_FIRST(ICH2)

        IRF1 = IRS1 + N_R1 - 1
        IRF2 = IRS2 + N_R2 - 1

        IRS1_TREE = IRES_START_TREE(ICH1)
        IRF1_TREE = IRES_END_TREE  (ICH1)

        IRS2_TREE = IRES_START_TREE(ICH2)
        IRF2_TREE = IRES_END_TREE  (ICH2)

        IRS1 = IRS1_TREE
        IRF1 = IRF1_TREE

        ICONN_TYPE(IRS1) = 1

        N_R2 = NRES_CHAIN(ICH2)   

        IRS1 = IRES_FIRST(ICH1)
        IRS2 = IRES_FIRST(ICH2)
        IRF1 = IRS1 + N_R1 - 1
        IRF2 = IRS2 + N_R2 - 1

        IRS1_TREE = IRES_START_TREE(ICH1)
        IRF1_TREE = IRES_END_TREE  (ICH1)

        IRS2_TREE = IRES_START_TREE(ICH2)
        IRF2_TREE = IRES_END_TREE  (ICH2)

        IF(LIST.EQ.'T') THEN
          WRITE(*,*) '--ICH1,ICH2,IRS1,IRF1,IRS2,IRF2:'
     *    ,ICH1,ICH2,IRS1,IRF1,IRS2,IRF2
     *    ,IRS1_TREE,IRF1_TREE,IRS2_TREE,IRF2_TREE   
        ENDIF
C -- tree --
        I    = IRS1_TREE         
 1800   CONTINUE  
C       DO    I=IRS1,IRF1
C -- tree --

          MON1   = RES_NAME (I)
          ITYPE1 = IRES_TYPE(I)

          IF(ICH1.EQ.ICH2.AND.I.EQ.IRF1) GO TO 400

          IF(MOD_N.GT.0) THEN
            DO IM = 1,MOD_N
              IF(MOD_IRES   (IM).EQ.I   .AND.
     *          MOD_ICHN    (IM).EQ.ICH1.AND.
     *          MOD_RNAM    (IM).NE.'.' .AND.
     *          MOD_RNAM_NEW(IM).EQ.MON1     ) THEN
                MON1     = MOD_RNAM(IM)
                GO TO 700
              ENDIF
            ENDDO
          ENDIF
 700      CONTINUE

          IF(MON1.EQ.'HOH'.OR.MON1.EQ.'DUM') GO TO 400

C -- tree --
          J    = IRS2_TREE         
          IRS2 = IRS2_TREE
          IRF2 = IRF2_TREE
 2800     CONTINUE  

C         DO    J=IRS2,IRF2
C -- tree --

            MON2   = RES_NAME (J)
            ITYPE2 = IRES_TYPE(J)

            IF(ICH1.EQ.ICH2.AND.J.LE.I) GO TO 300

            IF(MOD_N.GT.0) THEN
              DO IM = 1,MOD_N
                IF(MOD_IRES   (IM).EQ.J   .AND.
     *            MOD_ICHN    (IM).EQ.ICH2.AND.
     *            MOD_RNAM    (IM).NE.'.' .AND.
     *            MOD_RNAM_NEW(IM).EQ.MON2     ) THEN
                  MON2     = MOD_RNAM(IM)
                  GO TO 710
                ENDIF
              ENDDO
            ENDIF
 710        CONTINUE

            IF(MON2.EQ.'HOH'.OR.MON2.EQ.'DUM') GO TO 300

C           chain connection , not check this
C           I1 = I + 1
            I1 = IRES_FORW(I)

C            IF(J.EQ.I1.AND.ICH1.EQ.ICH2) GO TO 300
            CONN = 'N'
            IF(ICH1.EQ.ICH2.AND.J.EQ.I1) CONN = 'Y'

C           possible user's link
            USER     = 'N'
            IF(LN_N_INIT.GT.0) THEN
              DO ILN=1,LN_N_INIT
                IF((LN_1IRES(ILN).EQ.I   .AND.
     *              LN_2IRES(ILN).EQ.J   .AND.
     *              LN_1ICHN(ILN).EQ.ICH1.AND.
     *              LN_2ICHN(ILN).EQ.ICH2           ).OR.
     *             (LN_2IRES(ILN).EQ.I   .AND.
     *              LN_1IRES(ILN).EQ.J   .AND.
     *              LN_2ICHN(ILN).EQ.ICH1.AND.
     *              LN_1ICHN(ILN).EQ.ICH2           )    )THEN
                  IF(LN_ID(ILN).NE.'gap') THEN
                    SYMM1 = LN_SYMM1(ILN)
                    SYMM2 = LN_SYMM2(ILN)
C  25.11.03
C                    IF((SYMM1.EQ.'.'.OR.SYMM1.EQ.'1_555').AND.
C     *                 (SYMM2.EQ.'.'.OR.SYMM2.EQ.'1_555')) THEN
                      USER     = 'P'
                      IF(LIST.EQ.'T') THEN
                       write(*,*) '-user-link-',ILN
                      ENDIF
C                    ENDIF
                  ENDIF
                ENDIF
              ENDDO
            ENDIF

c ----
C           only CA atom in residue
            IF(((ITYPE2.GE.3.AND.ITYPE2.LE.4).OR.ITYPE2.EQ.10).AND.
     *        NATM_RES(J).EQ.1.AND.ATM_NAME(IRATM_FIRST(J)).EQ.'CA  '
     *        .AND.USER.NE.'P') GO TO 300
c ----

            IDM = IDMAX
            CALL CHECK_CENTR(I,J,DLIM(IDM),IOUT)
C
C           IOUT =  1 d =< dlim
C                   2 rad1 =0 or rad2 =0
C                   0 d > dlim
            IF((IOUT.NE.0.AND.IOUT.LT.3).OR.USER.EQ.'P') THEN
C             potential links
              IAS = IRATM_FIRST(I)
              IAF = IRATM_FIRST(I)+NATM_RES(I)-1
              DO    IA=IAS,IAF

                IF(ATM_TYPE(IA).EQ.'M'.OR.ATM_TYPE(IA).EQ.'U'.OR.
     *             ATM_TYPE(IA).EQ.'D') GO TO 800

                ATOM1  = ATM_NAME(IA)
                INSF   = ID_SF(IA)  
                ASYMB1 = CS_ATYPE (INSF)      

                CALL SET_IDLIM(ASYMB1,ICATOM1)

                XI    = XYZ_CRD(1,IA)
                YI    = XYZ_CRD(2,IA)
                ZI    = XYZ_CRD(3,IA)
                ALT1  = ID_ALT   (IA)    
                CORR1 = ID_CORR  (IA)    

                JAS = IRATM_FIRST(J)
                JAF = IRATM_FIRST(J)+NATM_RES(J)-1
                DO    JA=JAS,JAF

                  IF(ATM_TYPE(IA).EQ.'M'.OR.ATM_TYPE(IA).EQ.'U'.OR.
     *               ATM_TYPE(IA).EQ.'D') GO TO 200

                  INSF   = ID_SF(JA)  
                  ASYMB2 = CS_ATYPE (INSF)      

                  CALL SET_IDLIM(ASYMB2,ICATOM2)

                  ATOM2 = ATM_NAME (JA)
                  XJ    = XYZ_CRD(1,JA)
                  YJ    = XYZ_CRD(2,JA)
                  ZJ    = XYZ_CRD(3,JA)
                  ALT2  = ID_ALT   (JA)    
                  CORR2 = ID_CORR  (JA)
    
C ??? 26.09.01
c                  IF(ALT1.NE.'.'.AND.ALT2.NE.'.'.AND.
c     *               ALT1.NE.ALT2) GO TO 200 
C ???
      
                  IF(CORR1.NE.'.'.AND.CORR2.NE.'.'.AND.
     *               CORR1.NE.CORR2) GO TO 200       

                  COOR_FLAG = 'Y'
                  IF(OCCUP(IA).LT.0.0001) COOR_FLAG = 'N'
                  IF(OCCUP(JA).LT.0.0001) COOR_FLAG = 'N'

                  IF(ICATOM1.EQ.1.AND.ICATOM2.EQ.1) THEN
                    IC = 0    
                  ELSE IF(ICATOM1.EQ.1.OR.ICATOM2.EQ.1) THEN    
                    IC = 1 
                  ELSE IF(ICATOM1.EQ.2.AND.ICATOM2.EQ.2) THEN    
                    IC = 2
                  ELSE IF(ICATOM1.EQ.4.AND.ICATOM2.EQ.4) THEN    
                    IC = 4
                  ELSE 
                    IC = 3
                  ENDIF

                  IF(IC.GT.1) THEN
C                   non-H atoms connections

C                   SS-link ? 
                    LLL_FLAG = LNK_FLAG
                    SS = 'N'
                    IF(ATOM1.EQ.'SG  '.AND.
     *                   (MON1.EQ.'CYS'.OR.MON1.EQ.'MPR').AND.
     *                 ATOM2.EQ.'SG  '.AND.
     *                   (MON2.EQ.'CYS'.OR.MON2.EQ.'MPR')) SS = 'Y'
                    IF(SS.EQ.'Y') LLL_FLAG = SS_FLAG

                    IF(CONN.EQ.'Y'.AND.SS.EQ.'N') GO TO 200

C                   sugar-link ?
                    SUG = 'N' 
                    IF(ITYPE1.EQ.7.OR.ITYPE1.EQ.8.OR.
     *                 ITYPE2.EQ.7.OR.ITYPE2.EQ.8    ) SUG = 'Y'
                    IF(SUG.EQ.'Y') LLL_FLAG = SUGAR_FLAG

C                   possible  link
                    LINKS = ' '
                    CALL CHECK_LINK_INFO(LINKS,MON1,MON2
     *                                  ,ATOM1,ATOM2,DIDEAL,ILINK)

                    IF(ICH1.NE.ICH2.AND.ILINK.LE.0) THEN
                      CALL CHECK_LINK_INFO(LINKS,MON2,MON1
     *                                  ,ATOM2,ATOM1,DIDEAL,ILINK)
                    ENDIF

                    IF(ILINK.GT.0) THEN
                      LINKS = LLL_LNAME(ILINK)                         
                      IF(SUG.EQ.'Y') THEN
                        IF(SUGAR_FLAG.EQ.'S') THEN
                         IF(LINKS(1:4).EQ.'BETA'.OR.LINKS(1:4).EQ.'ALPH'
     *                    .OR.LINKS.EQ.'MAN-SER'.OR.LINKS.EQ.'NAG-SER'
     *                    .OR.LINKS.EQ.'MAN-THR'.OR.LINKS.EQ.'NAG-THR'
     *                    .OR.LINKS.EQ.'MAN-ASN'.OR.LINKS.EQ.'NAG-ASN'
     *                    .OR.LINKS.EQ.'XYS-SER'.OR.LINKS.EQ.'NAG-THR'
     *                    .OR.LINKS.EQ.'XYS-ASN') THEN
C MAN-SER  bond_MAN-C1_=_SER-OG     MAN DEL-O1   .        SER .        .
C NAG-SER  bond_NAG-C1_=_SER-OG     NAG DEL-O1   .        SER .        .
C NAG-THR  bond_NAG-C1_=_THR-OG1    NAG DEL-O1   .        THR .        .
C MAN-THR  bond_MAN-C1_=_THR-OG1    MAN DEL-O1   .        THR .        .
C NAG-ASN  bond_NAG-C1_=_ASN-ND2    NAG DEL-O1   .        ASN .        .
C MAN-ASN  bond_MAN-C1_=_ASN-ND2    MAN DEL-O1   .        ASN .        .
C XYS-THR  bond_XYS-C1_=_THR-OG1    XYS XYS-O1   .        THR .        .
C XYS-SER  bond_XYS-C1_=_SER-OG     XYS XYS-O1   .        SER .        .
C XYS-ASN  bond_XYS-C1_=_ASN-ND2    XYS XYS-O1   .        ASN .        .


c          write(*,*) '==',MON1,MON2,ATOM1,ATOM2,LINKS,SUGAR_FLAG
c          write(*,*) '==',RES_NUM_PDB(I)(3:7),RES_NUM_PDB(j)(3:7)

                            LLL_FLAG = 'Y'
                          ELSE
                            LLL_FLAG = 'N'
                          ENDIF
                        ENDIF
                      ENDIF
                    ELSE
                      IF(SUG.EQ.'Y'.AND.SUGAR_FLAG.EQ.'S') THEN
                        LLL_FLAG = 'N'
                      ENDIF
                    ENDIF

C                   user's link
                    IF(LN_N_INIT.GT.0.AND.USER.EQ.'P') THEN
                      DO ILN=1,LN_N_INIT
                        ALT1_C = ALT1  
                        ALT2_C = ALT2  
                        IF(LN_USED(ILN).NE.'S') THEN
                          ALT1_C = '.'
                          ALT2_C = '.'
                        ENDIF
                        IOK = 0                          
                        IF(LN_1IRES(ILN).EQ.I   .AND.
     *                     LN_2IRES(ILN).EQ.J   .AND.
     *                     LN_1ICHN(ILN).EQ.ICH1.AND.
     *                     LN_2ICHN(ILN).EQ.ICH2.AND.           
     *                     LN_ATOM1(ILN)(1:4).EQ.ATOM1.AND.
     *                     LN_ATOM2(ILN)(1:4).EQ.ATOM2     ) THEN
                          IOK = 1
                        ELSE IF(LN_2IRES(ILN).EQ.I.AND.
     *                          LN_1IRES(ILN).EQ.J   .AND.
     *                          LN_2ICHN(ILN).EQ.ICH1.AND.
     *                          LN_1ICHN(ILN).EQ.ICH2.AND.      
     *                          LN_ATOM2(ILN)(1:4).EQ.ATOM1.AND.
     *                          LN_ATOM1(ILN)(1:4).EQ.ATOM2) THEN
                          IOK = 1
                          CH1 = ALT1_C  
                          ALT1_C = ALT2_C  
                          ALT2_C = CH1 
                        ENDIF
                        IF(IOK.EQ.1) THEN
                          IF(LN_ID(ILN).NE.'gap'.AND.
     *                       LN_ID(ILN).NE.'?'       ) THEN

                            IF((LN_ALT1 (ILN).EQ.ALT1_C .AND.
     *                          LN_ALT2 (ILN).EQ.ALT2_C      ).AND.
     *                         (ALT1.EQ.ALT2.OR.
     *                          LN_USED(ILN).EQ.'S') )THEN


                            SYMM1 = LN_SYMM1(ILN)
                            SYMM2 = LN_SYMM2(ILN)
                            IF((SYMM1.EQ.'.'.OR.SYMM1.EQ.'1_555').AND.
     *                         (SYMM2.EQ.'.'.OR.SYMM2.EQ.'1_555')) THEN
                              IF(LLL_FLAG.NE.'D') THEN
                                USER  = 'Y'
                                LINKS = LN_ID(ILN)
C                               link is found. This link will be used
C                               because it is user's definition
                                GO TO 100
                              ELSE
                                LN_ID(ILN) = '?'
                              ENDIF
                            ENDIF

                            ENDIF

                          ENDIF
                        ENDIF
                      ENDDO
C  25.11.03           user's link not found go to next atoms
                      IF(LIST.EQ.'T') THEN
                        write(*,*) '--UL not found:'
                      ENDIF
                      GO TO 200
                    ENDIF
C ??? 21.11.03
                    IF(ALT1.NE.'.'.AND.ALT2.NE.'.'.AND.
     *                 ALT1.NE.ALT2) GO TO 200 
C ???

                    ILN = 0
 100                CONTINUE

c                   IF(SUG.EQ.'Y'.AND.LLL_FLAG.EQ.'Y') THEN
c                    IF(LIST.EQ.'T') THEN
c                      write(*,*) 'lll_flag:',LLL_FLAG,COOR_FLAG,sug
c     *                ,SUGAR_FLAG,ic,links
c                    ENDIF

C                   check distance
                    DIST = 0.0
                    IF(COOR_FLAG.EQ.'Y') THEN
                      DX   = XI-XJ
                      DY   = YI-YJ
                      DZ   = ZI-ZJ
                      DIST = SQRT(DX*DX+DY*DY+DZ*DZ)
                      FLAG  = 'N'
                      IF(DIST.LE.DLIM(IC)) THEN
C                       there is connection
                        FLAG = 'Y'
                        IF(LLL_FLAG.NE.'N') THEN
C                         use it
                          CNEW = 'N'
                        ELSE
C                         only message
                          CNEW = 'Y'
                        ENDIF
                      ENDIF
                      IF(USER.EQ.'Y') THEN
                        FLAG = 'Y'
                        CNEW = 'N'
                      ENDIF
                    ELSE IF(USER.EQ.'Y') THEN
                      FLAG = 'Y'
                      CNEW = 'N'
                    ELSE
C                     no connection
                      DIST = DLIM(IC)+0.001
                      FLAG = 'N'
                      CNEW = 'N'
                    ENDIF

c                      IF(SUG.EQ.'Y'.AND.LLL_FLAG.EQ.'Y') THEN
c            write(*,*) 'flag:',FLAG,cnew,dist
c                      endif

                    IF(FLAG.EQ.'Y') THEN
C                     link is found

c                     IF(SUG.EQ.'Y'.AND.LLL_FLAG.EQ.'Y') THEN
                      IF(LIST.EQ.'T') THEN
                         write(*,*) '-f<',links,'>',user,flag,cnew
     *                   ,lll_flag,dist
                         if(iln.gt.0) write(*,*) iln,LN_DIST(iLN)
                         write(*,*)   MON1,ATOM1,MON2,ATOM2
                      ENDIF

                      MOD1    = '.'
                      MOD2    = '.'          
                      IREVERS = 0
C --- LINK ---
                      CALL LOOK_LINK(LINKS,MON1,ATOM1,MON2,ATOM2
     *                      ,ITYPE1,ITYPE2,ILINK,MOD1,MOD2,IREVERS)
                      
                      IF(LIST.EQ.'T') THEN
                         write(*,*) '-ilink:',ilink,IREVERS
                      ENDIF

                      IF(ILINK.LE.0) THEN
C                       new link description will be created /if CNEW='N'/
                        CALL LENSTR_BL(LINKS,LEN)
                        LINK  = ' '

                        CALL GET_DEFAULT_VBOND(MDOC,ASYMB1,ASYMB2
     *                  ,DIST_IDL,DEF_FLAG,IERR)
                        IF(IERR.NE.0) RETURN

                        IF(CNEW.EQ.'N') THEN
C                         use it 
                          IF(LEN.GT.0) LINK = LINKS
                          CALL CREAT_LINK(MDOC,LINK,INEW,LNEW,ILINK
     *                    ,ITYPE1,ITYPE2,MON1,ATOM1
     *                    ,MOD1,MON2,ATOM2,MOD2,DIST_IDL,IERR)
                          IF(IERR.NE.0) RETURN
                          IF(INEW.EQ.1) THEN
C                           output flag about "new" was used
                            DNEW = 'Y'
                            IF(ILN.GT.0) THEN
                            IF(LN_DIST(ILN).GT.0.01) THEN
                              DIST_IDL = LN_DIST(ILN) 
                            ENDIF
                            ENDIF

                            WRITE(LINE,'(A,A8,A)')
     *           ' WARNING : description of link:',LINK
     *            ,' not found in the dictionary.'
                            CALL MSGDOC(MDOC,LINE)
                            WRITE(LINE,
     * '(''           link will be created with bond_lenth ='',F8.3)') 
     *                      DIST_IDL
                            CALL MSGDOC(MDOC,LINE)
                          ENDIF

                        ENDIF
                      ELSE
                        CALL GET_IDL_BOND_LENTH(ILINK,DIST_IDL)
                        LINK  = LLL_LNAME(ILINK)                         

                        IF((LINK(1:4).EQ.'BETA'.OR.
     *                      LINK(1:4).EQ.'ALPH'    ).AND
     *                                      .USER.NE.'Y') THEN  
                          IF(ATOM1.EQ.'C1  ') THEN     
                            ATOM = ATOM2
                            IRR1 = I
                            IRR2 = J
                          ELSE 
                            ATOM = ATOM1
                            IRR1 = J
                            IRR2 = I
                          ENDIF
                          IT1  = 0  
                          IT2  = 0  
                          IT3  = 0  
                          IT4  = 0  
                          IAS1 = IRATM_FIRST(IRR1)
                          IAF1 = IRATM_FIRST(IRR1)+NATM_RES(IRR1)-1
                          IT = 0
                          DO  IA1=IAS1,IAF1
                            IF(ATM_NAME(IA1).EQ.'C1  ') THEN
                              XX1(1) = XYZ_CRD(1,IA1)
                              XX1(2) = XYZ_CRD(2,IA1)
                              XX1(3) = XYZ_CRD(3,IA1)
                              IT     = IT + 1
                            ELSE IF(ATM_NAME(IA1).EQ.'O5  ') THEN
                              XX3(1) = XYZ_CRD(1,IA1)
                              XX3(2) = XYZ_CRD(2,IA1)
                              XX3(3) = XYZ_CRD(3,IA1)
                              IT     = IT + 1
                            ELSE IF(ATM_NAME(IA1).EQ.'C2  ') THEN
                              XX4(1) = XYZ_CRD(1,IA1)
                              XX4(2) = XYZ_CRD(2,IA1)
                              XX4(3) = XYZ_CRD(3,IA1)
                              IT     = IT + 1
                            ENDIF
                          ENDDO
                          IAS2 = IRATM_FIRST(IRR2)
                          IAF2 = IRATM_FIRST(IRR2)+NATM_RES(IRR2)-1
                          DO  IA2=IAS2,IAF2
                            IF(ATM_NAME(IA2).EQ.ATOM) THEN
                              XX2(1) = XYZ_CRD(1,IA2)
                              XX2(2) = XYZ_CRD(2,IA2)
                              XX2(3) = XYZ_CRD(3,IA2)
                              IT     = IT + 1
                            ENDIF
                          ENDDO
                          IF(IT.GE.4) THEN

                            CALL CALC_I_OVOL_L(IT1,IT2,IT3,IT4
     *                        ,XX1,XX2,XX3,XX4,VOLOBS,PH)
                 
C                                          V2 -> I3 
C                           I2 - V1 -> I1 < 
C                                          V3 -> I4 

                            IT = 0
                            IF(PH.GE.0.0.AND.LINK(1:4).EQ.'BETA') THEN
                              IT = 1
                              LINK_NEW =  'ALPHA'//LINK(5:7)
                            ELSE IF(PH.LT.0.0.AND.LINK(1:4).EQ.'ALPH')
     *                                                            THEN
                              LINK_NEW =  'BETA'//LINK(6:8)
                              IT = 1   
                            ENDIF
                            IF(IT.GT.0) THEN
                              IF(ILN.GT.0) THEN
                                LN_ID(ILN) = LINK_NEW  
                              ENDIF

                              LINK = LINK_NEW
                              CALL LOOK_LINK_LIST(LINK,ILINK)
                            ENDIF

                          ENDIF

                        ENDIF

                      ENDIF

                      IF(ILINK.GT.0.AND.CNEW.EQ.'N') THEN
C                       this link will be used ( because CNEW.EQ.'N')

                        LINK  = LLL_LNAME(ILINK)                         
                        WRITE(LINE,'(A,A8,A,F10.3,A,F10.3)')
     *' WARNING : link:',LINK,' is found dist =',DIST,
     *                             ' ideal_dist=',DIST_IDL
                        IF(ILN.GT.0) THEN
                        IF(LN_USED(ILN).EQ.'S') THEN                        
                        WRITE(LINE,'(A,A8,A,F10.3,A,F10.3)')
     *' WARNING : link(spec):',LINK,' is found dist =',DIST,
     *                             ' ideal_dist=',DIST_IDL
                        ENDIF
                        ENDIF

                        CALL MSGDOC(MDOC,LINE)                    

                        WRITE(LINE,'(3A,A5,3A,A4,A1,3A,A5,3A,A4,A1)')
     *'           ch:',GROUP_ID(ICH1),' res:',RES_NUM_PDB(I)(3:7),
     *' ',RES_NAME(I),' at:',ATOM1,ALT1,'->',GROUP_ID(ICH2),
     *' res:',RES_NUM_PDB(J)(3:7),' ',RES_NAME(J),' at:',ATOM2,ALT2
                        CALL MSGDOC(MDOC,LINE)                    

                        IF(ILN.LE.0) THEN
                          CALL PUT_L_TABL(MDOC,LINK,ICH1,ICH2
     *                                ,I,J,IA,JA,IREVERS,IERR)
                          IF(IERR.NE.0) RETURN
                        ELSE
                          LN_ID(ILN) = LINK
                        ENDIF

                        MON_N = '   '
                        MTYPE = 'Y'

                        IF(ILN.GT.0) THEN
                        IF(LN_USED(ILN).EQ.'S') THEN                        
                          MTYPE = 'N'
                        ENDIF
                        ENDIF
                        IF(MTYPE.NE.'N') THEN
                          CALL PUT_M_TABL(MDOC,MOD1,ICH1
     *                                  ,I,IA,MON_N,MTYPE,IERR)
                          IF(IERR.NE.0) RETURN
                          CALL PUT_M_TABL(MDOC,MOD2,ICH2
     *                                  ,J,JA,MON_N,MTYPE,IERR)
                          IF(IERR.NE.0) RETURN
                        ENDIF
c                       for link: TRANS,CIS,p
                        IF(LINK.EQ.'TRANS'.OR.LINK.EQ.'CIS'.OR.
     *                     LINK.EQ.'PTRANS'.OR.LINK.EQ.'PCIS'.OR.
     *                     LINK.EQ.'NMTRANS'.OR.LINK.EQ.'NMCIS'.OR.
     *                     LINK.EQ.'p') THEN
                          IF(I.EQ.IRS1) THEN
                            ITERM_S_TYPE(ICH1) = 7
                          ENDIF
                          IF(I.EQ.IRF1) THEN
                            ITERM_F_TYPE(ICH1) = 7
                          ENDIF
                          IF(J.EQ.IRS2) THEN
                            ITERM_S_TYPE(ICH2) = 7
                          ENDIF
                          IF(J.EQ.IRF2) THEN
                            ITERM_F_TYPE(ICH2) = 7
                          ENDIF
c           write(*,*)'==',ich1,ich2,i,j,irs1,irf1,irs2,irf2
c           write(*,*)'==',ITERM_S_TYPE(ICH1),ITERM_F_TYPE(ICH1)
c           write(*,*)'==',ITERM_S_TYPE(ICH2),ITERM_F_TYPE(ICH2)

                        ENDIF
                        IF((ITYPE1.EQ.7.OR.ITYPE1.EQ.8).AND.
     *                     (ITYPE2.EQ.7.OR.ITYPE2.EQ.8).AND.
     *                      SUG.EQ.'Y') NSUG = NSUG +1

                      ELSE IF(CNEW.EQ.'Y') THEN
C                       link was found but not be used
C     *'('' INFO:     connection is found (not be used) dist='',F8.3
c123456789 123456789 123456789 123456789 123456789 123456789 123456789 123456789
c INFO:     link is found (not be used) dist=   1.359 ideal_dist=   1.330
c           ch:SS res:   2  MAF      at:O1   --> ch:BB res:   1  BEN      at:C6

                        WRITE(LINE,'(A,F8.3,A,F8.3)')
     *' INFO:     link is found (not be used) dist=',DIST
     *                   ,' ideal_dist=',DIST_IDL
                        CALL MSGDOC(MDOC,LINE)                    
                        WRITE(LINE,'(3A,A5,3A,A4,A1,3A,A5,3A,A4,A1)')
     *'           ch:',GROUP_ID(ICH1),' res:',RES_NUM_PDB(I)(3:7),
     *' ',RES_NAME(I),' at:',ATOM1,ALT1,'->ch:',GROUP_ID(ICH2),
     * ' res:',RES_NUM_PDB(J)(3:7),' ',RES_NAME(J),' at:',ATOM2,ALT2
                        CALL MSGDOC(MDOC,LINE)                    
                      ENDIF
C --- LINK ---
                    ENDIF
                    IF(USER.EQ.'Y') USER = 'P'
C                  -- IC gt 1 --
                  ENDIF
 200              CONTINUE
C                 -- JA --

                ENDDO
 800            CONTINUE
C               -- IA --
              ENDDO

C           -- IOUT ne 0 --
            ENDIF

 300        CONTINUE

C         -- J --
C   --- tree --
C         ENDDO
          IF(J.NE.IRF2) THEN

c           write(*,*) '--forw2:',j,IRES_FORW(J),irf2

            J = IRES_FORW(J)
            IF(J.LE.0) THEN
              CALL MSGERR(MDOC,' ERROR: wrong tree structure .....')
              IERR = 1
              RETURN
            ENDIF
            GO TO 2800
          ENDIF
C --- tree --
 400      CONTINUE
C         -- I --
C --- tree --
C       ENDDO
        IF(I.NE.IRF1) THEN

c           write(*,*) '--forw1:',i,IRES_FORW(i),irf1

          I = IRES_FORW(I)
          IF(I.LE.0) THEN
            CALL MSGERR(MDOC,' ERROR: wrong tree structure .....')
            IERR = 1
            RETURN
          ENDIF
          GO TO 1800
        ENDIF
C --- tree --
 500    CONTINUE
C     -- ICH2 --
      ENDDO
 600  CONTINUE
C     -- ICH1 --
      ENDDO

      RETURN
      END

      SUBROUTINE GET_IDL_BOND_LENTH(L,DIST_IDL)
C ----------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------
      DIST_IDL = 0.0
      IF(L.LE.0.OR.L.GT.LLL_NLINK) RETURN
      IF(LLB_NBOND.GT.0.AND.LLL_IBOND(L).GT.0) THEN
        DO IB = LLL_IBOND(L),LLB_NBOND
          IF(LLL_LNAME(L).EQ.LLB_LNAME(IB)) THEN
            DIST_IDL = LLB_VAL(IB)
            RETURN
          ENDIF
        ENDDO
      ENDIF
      RETURN
      END

      SUBROUTINE GET_DEFAULT_VBOND(MDOC,CHEM1,CHEM2,VAL,DEF_FLAG,IERR)
C ----------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C     INCLUDE 'ener_com.fh'
C ---
      CHARACTER CHEM1*4,CHEM2*4,DEF_FLAG*1
C     CHARACTER LINE*256
C -----------------------------------------
      IERR = 0

      DEF_FLAG ='N'
      VAL      = 0.0
      DO K=1,LEB_NBOND
         IF((LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K).EQ.CHEM2).OR.
     *      (LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K).EQ.CHEM1))
     *   THEN
           VAL = LEB_LENGTH(K) 
           GO TO 400
         ENDIF
      ENDDO
      D1 = 0.0
      D2 = 0.0
      DO K=1,LEB_NBOND
        IF(LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K)(1:1).EQ.'.')
     *    D1 = LEB_LENGTH(K)
        IF(LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K)(1:1).EQ.'.')
     *    D2 = LEB_LENGTH(K)
      ENDDO
      IF(D1.GT.0.0.AND.D2.GT.0.0) THEN
        DA  = (D1+D2)/2.0
        VAL = DA 
       ENDIF
      IF(VAL.LE.0.0) VAL = 1.5
      DEF_FLAG = 'Y'
 400  CONTINUE

      RETURN
      END

C ******
      SUBROUTINE DEF_LINK_MOD(MDOC,LIST,DNEW,IERR)
C -----------------------------------------------
C        check list of links. (user's definition)
C        if description is not in the dictionary: create it 
C
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER DNEW*1,LIST*1
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ----------------------------------------------------------------
      CHARACTER MON1*8,MON2*8,ATOM1*4,ATOM2*4,MOD1*8,MOD2*8
      CHARACTER LINK*8
      CHARACTER ASYMB1*4,ASYMB2*4,DEF_FLAG*1,MON_N*8,MTYPE*1
      CHARACTER LINE*256
C     CHARACTER LINKS*8,ALT1*1,CORR1*1,ALT2*1,CORR2*1,FLAG*1
C -----------------------------------
      IERR  = 0

      IF(LIST.EQ.'T') THEN
        CALL MSGERR(MDOC,' -- DEF_LINK_MOD')
        write(LINE,*) '==>LN_N',LN_N    
        CALL MSGERR(MDOC,LINE)
      ENDIF

      IF(LN_N.GT.0) THEN
C
C     check list of links. 
C
        DO ILN=1,LN_N

          ICH1   = LN_1ICHN (ILN)
          IR1    = LN_1IRES (ILN)

          IF(ICH1.LE.0.OR.IR1.LE.0) THEN
            LN_ID(ILN)(1:1) = '?'
            GO TO 320
          ENDIF

          MON1   = RES_NAME (IR1)
         
          ITYPE1 = IRES_TYPE(IR1)

          IF(MOD_N.GT.0) THEN
            DO IM = 1,MOD_N
              IF(MOD_IRES   (IM).EQ.IR1 .AND.
     *          MOD_ICHN    (IM).EQ.ICH1.AND.
     *          MOD_RNAM    (IM).NE.'.' .AND.
     *          MOD_RNAM_NEW(IM).EQ.MON1     ) THEN
                MON1     = MOD_RNAM(IM)
                GO TO 300
              ENDIF
            ENDDO
          ENDIF

 300      CONTINUE

          ICH2   = LN_2ICHN (ILN)
          IR2    = LN_2IRES (ILN)

          IF(ICH2.LE.0.OR.IR2.LE.0) THEN
            LN_ID(ILN)(1:1) = '?'
            GO TO 320
          ENDIF


          MON2   = RES_NAME (IR2)
          ITYPE2 = IRES_TYPE(IR2)

          IF(MOD_N.GT.0) THEN
            DO IM = 1,MOD_N
              IF(MOD_IRES   (IM).EQ.IR2 .AND.
     *          MOD_ICHN    (IM).EQ.ICH2.AND.
     *          MOD_RNAM    (IM).NE.'.' .AND.
     *          MOD_RNAM_NEW(IM).EQ.MON2     ) THEN
                MON2     = MOD_RNAM(IM)
                GO TO 310
              ENDIF
            ENDDO
          ENDIF

 310      CONTINUE


          LINK = LN_ID(ILN)
          CALL LENSTR_BL(LINK,L)
          IA1 = 0
          IA2 = 0

          IF(LIST.EQ.'T') THEN
            write(LINE,*)
     *      '>',iln,link,ich1,ir1,mon1,itype1
            CALL MSGERR(MDOC,LINE)
            write(LINE,*)
     *      '>',ich2,ir2,mon2,itype2,LN_ALT1(ILN),LN_ALT2(ILN)
            CALL MSGERR(MDOC,LINE)
            write(LINE,*) '   ',LN_ATOM1(ILN),';',LN_ATOM2(ILN),';'
            CALL MSGERR(MDOC,LINE)
          ENDIF

          IF(L.GT.0.AND.LINK(1:1).NE.'.'.AND.LINK(1:1).NE.'?') THEN

            IF(LN_ATOM1(ILN)(1:1).EQ.'.'.OR.
     *         LN_ATOM2(ILN)(1:1).EQ.'.'    ) THEN
              CALL GET_LINK_ATOM(LINK,ATOM1,ATOM2,IT)
              IF(IT.GT.0) THEN
                LN_ATOM1(ILN) = ATOM1//' '
                LN_ATOM2(ILN) = ATOM2//' '
              ENDIF
            ENDIF

            CALL LOOK_LINK_LIST(LINK,ILINK)

          ELSE

            LINK  = '.'
            L     = 1
            ILINK = 0
            IF((ITYPE1.EQ.7.OR.ITYPE1.EQ.8).AND.
     *         (ITYPE2.EQ.3.OR.ITYPE2.EQ.4)     ) THEN  
              LINK = MON1(1:3)//'-'//MON2(1:3)
            ELSE IF((ITYPE2.EQ.7.OR.ITYPE2.EQ.8).AND.
     *         (ITYPE1.EQ.3.OR.ITYPE1.EQ.4)     ) THEN  
              LINK = MON2(1:3)//'-'//MON1(1:3)
            ELSE            
c              LINE =' WARNING : link: '//MON1(1:3)//'<-->'//MON2(1:3)//
c     *              ' cannot be used without link_id'
c              CALL MSGDOC(MDOC,LINE)
c              GO TO 320
              LINE =' WARNING : link: '//MON1(1:3)//'<-->'//MON2(1:3)//
     *              ' is without link_id'
              CALL MSGDOC(MDOC,LINE)
              WRITE(LINE,
     * '(''           link will be created with covalent bond only'')') 
              CALL MSGDOC(MDOC,LINE)
            ENDIF
            CALL LOOK_LINK_LIST(LINK,ILINK)
            IF(ILINK.GT.0) THEN
              LN_ID(ILN) = LLL_LNAME(ILINK)
            ENDIF

          ENDIF

          IF(ILINK.LE.0) THEN

            MOD1    = '.'
            MOD2    = '.'          
            ATOM1   = LN_ATOM1(ILN)(1:4)
            ATOM2   = LN_ATOM2(ILN)(1:4)
            DIST    = LN_DIST (ILN)
                
            CALL LOOK_LINK(LINK,MON1,ATOM1,MON2,ATOM2
     *      ,ITYPE1,ITYPE2,ILINK,MOD1,MOD2,IREVERS)

            IF(ILINK.GT.0) THEN
              LINK       = LLL_LNAME(ILINK)
              LN_ID(ILN) = LINK 
              GO TO 320
            ENDIF

            IF(DIST.LT.0.001) THEN

              IAS = IRATM_FIRST(IR1)
              IAF = IRATM_FIRST(IR1)+NATM_RES(IR1)-1
              IA1 = 0
              DO    IA1=IAS,IAF
                IF(ATOM1.EQ.ATM_NAME(IA1)) THEN
                  INSF   = ID_SF(IA1)  
                  ASYMB1 = CS_ATYPE (INSF)      
                  GO TO 500
                ENDIF 
              ENDDO
              DIST = 1.5
              GO TO 520
 500          CONTINUE
              IAS = IRATM_FIRST(IR2)
              IAF = IRATM_FIRST(IR2)+NATM_RES(IR2)-1
              IA2 = 0
              DO    IA2=IAS,IAF
                IF(ATOM2.EQ.ATM_NAME(IA2)) THEN
                  INSF   = ID_SF(IA2)  
                  ASYMB2 = CS_ATYPE (INSF)      
                  GO TO 510
                ENDIF 
              ENDDO
              DIST = 1.5
              GO TO 520
 510          CONTINUE

              CALL GET_DEFAULT_VBOND(MDOC,ASYMB1,ASYMB2
     *            ,DIST,DEF_FLAG,IERR)
              IF(IERR.NE.0) RETURN
 520          CONTINUE
            ENDIF

            CALL CREAT_LINK(MDOC,LINK,INEW,LNEW,ILINK
     *      ,ITYPE1,ITYPE2
     *      ,MON1,ATOM1,MOD1,MON2,ATOM2,MOD2,DIST,IERR)                 
            IF(IERR.NE.0) RETURN

            IF(LNEW.EQ.1.OR.INEW.EQ.1) THEN

              LN_ID   (ILN)      = LINK
              LN_ATOM1(ILN)(1:4) = ATOM1
              LN_ATOM2(ILN)(1:4) = ATOM2
              LN_1ICHN(ILN)      = I_CHAIN(IR1)
              LN_2ICHN(ILN)      = I_CHAIN(IR2)
              LN_1IRES(ILN)      = IR1
              LN_2IRES(ILN)      = IR2
              LN_1RNAM(ILN)      = MON1
              LN_2RNAM(ILN)      = MON2
c              LN_ALT1 (ILN)      = '.'
c              LN_ALT2 (ILN)      = '.'
c              IF(IA1.GT.0) LN_ALT1(ILN) = ID_ALT(IA1)
c              IF(IA2.GT.0) LN_ALT2(ILN) = ID_ALT(IA2)
              LN_DIST (ILN)      = DIST
C
C           LN_ENT    E - form ent_poly_seq (not trans 2 , ptrans 36 , p 4)
C                     L - form ent_link
C                     C - from conn
C
              LN_ENT (ILN)       = 'C'
C???          LN_USED(ILN)       = '.'
              LN_USED(ILN)       = 'U'

              IF(LN_ALT1(ILN).NE.'.'.OR.LN_ALT1(ILN).NE.' ')
     *          LN_USED(ILN) = 'S'

C ---
C 13.05.2004
C              DNEW = 'Y'
C
c ---
              WRITE(LINE,'(A,A8,A)')' WARNING : description of link:',
     *          LINK,' not found in the dictionary'
              CALL MSGDOC(MDOC,LINE)
              WRITE(LINE,
     * '(''           link will be created with bond_lenth ='',F8.3)') 
     *        DIST
              CALL MSGDOC(MDOC,LINE)

            ENDIF
C ---
          ENDIF

          CALL LOOK_LINK(LINK,MON1,ATOM1,MON2,ATOM2
     *      ,ITYPE1,ITYPE2,ILINK,MOD1,MOD2,IREVERS)

          MON_N = '   '
          MTYPE = 'Y'
          IA1   = 0
          IA2   = 0

          IF(ILN.GT.0) THEN
          IF(LN_USED(ILN).EQ.'S') THEN                        
            MTYPE = 'N'
          ENDIF
          ENDIF

          IF(MTYPE.NE.'N') THEN 
            CALL PUT_M_TABL(MDOC,MOD1,ICH1
     *                    ,IR1,IA1,MON_N,MTYPE,IERR)
            IF(IERR.NE.0) RETURN
            CALL PUT_M_TABL(MDOC,MOD2,ICH2
     *                    ,IR2,IA2,MON_N,MTYPE,IERR)
            IF(IERR.NE.0) RETURN
          ENDIF

 320      CONTINUE

        ENDDO

      ENDIF

      IF(LIST.EQ.'T') THEN
        CALL MSGERR(MDOC,' -- end: DEF_LINK_MOD')
      ENDIF


      RETURN
      END

C ******
      SUBROUTINE DEF_CONN(MMDOC,LIST,CONN_FLAG,CIS_FLAG,SUGAR_FLAG
     *                   ,LN_N_INIT,DNEW,NSUG,IERR)
C -----------------------------------------------
C        check chain connectivity, set residue"s conn_type
C
C        check type of peptide link: 'CIS' or 'TRANS' and
C        change it if CIS_FLAG = 'Y' /set DNEW='Y'/
C
C        check actual distance: if distance is big  and CONN_FLAG ne 'Y'
C        - link will be ignored.      
C
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,LN_N_INIT
      CHARACTER CONN_FLAG*1,CIS_FLAG*1,DNEW*1,SUGAR_FLAG*1,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C     INCLUDE 'conn_com.fh'
      INCLUDE 'atom_com.fh'
C ******
C ----------------------------------------------------------------
C -------------------------------------------------------------------
c      PARAMETER ( NSTOR_PAR = 50 )
c      COMMON /COM_CONN_INF/  N_STOR,IFLAG_STOR,ICONN_ATOM_IND
c     *                      ,X_STOR,Y_STOR,Z_STOR
c     *                      ,ATOM_STOR
C -------------------------------------------------------------------
c      INTEGER    N_STOR,IFLAG_STOR(NSTOR_PAR,2)
c      REAL       X_STOR(NSTOR_PAR,2),Y_STOR(NSTOR_PAR,2)
c     *          ,Z_STOR(NSTOR_PAR,2)
c      CHARACTER  ATOM_STOR(NSTOR_PAR)*4
C ---
c      INTEGER    ICONN_ATOM_IND(2,MAXLLNK)
C -------------------------------------------------------------------
C ----------------------------------------------------------------
      REAL      XX1(3),XX2(3),XX3(3),XX4(3)
      CHARACTER MON1*8,MON2*8,ATOM1*4,ATOM2*4,MOD1*8,MOD2*8
      CHARACTER LINK*8,LINKS*8,SUG*1
C     CHARACTER ALT2*1,CORR2*1
C     CHARACTER ASYMB1*4,ASYMB2*4,DEF_FLAG*1,ALT1*1,CORR1*1
      CHARACTER LINE*256,FLAG*1,MON_N*8,MTYPE*1,LINK_NEW*8
      CHARACTER SYMM1*8,SYMM2*8,CHAR8*8,PRO*1,USER*1
C -----------------------------------
      IERR  = 0
      MDOC = MMDOC
      IF(LIST.EQ.'S') MDOC = 999
      LDOC = MDOC
      IF(LIST.EQ.'M') LDOC = 999
C ----
      NSUG  = 0

c       write(*,*) '--def_conn--',CONN_FLAG,CIS_FLAG,SUGAR_FLAG
c
C      do i=1,LN_N
C      write(*,*) '-C-'
C     * ,i,LN_ID(I),LN_1ICHN(i),LN_1IRES(i),LN_2ICHN(i),LN_2IRES(i)
C      ir1 = LN_1IRES(i)
C      ir2 = LN_2IRES(i)
C      write(*,*) '    '
C     * ,RES_NUM_PDB(Ir1)(3:7),RES_NAME(Ir1),RES_NUM_PDB(Ir2)(3:7)
C     * ,RES_NAME(Ir2),LN_ATOM1(i),LN_ATOM2(I)
C      enddo

C
C     check connectivity of chains (define type of connection)
C

      DO ICH1=1,N_GROUP

        N_R1 = NRES_CHAIN(ICH1)   

        IRS1      = IRES_FIRST(ICH1)
        IRF1      = IRS1 + N_R1 - 1
        IRS1_TREE = IRES_START_TREE(ICH1)
        IRF1_TREE = IRES_END_TREE  (ICH1)

        IRS1 = IRS1_TREE
        IRF1 = IRF1_TREE

        ICONN_TYPE(IRS1) = 1

        IF(IRF1.GT.IRS1) THEN

          DO IS=1,N_STOR    
            IFLAG_STOR(IS,2) = 0
          ENDDO

          IAS = IRATM_FIRST(IRS1)
          IAF = IRATM_FIRST(IRS1)+NATM_RES(IRS1)-1
          DO    IA=IAS,IAF
            ATOM2  = ATM_NAME (IA)
            XI     = XYZ_CRD(1,IA)
            YI     = XYZ_CRD(2,IA)
            ZI     = XYZ_CRD(3,IA)
c           ALT2   = ID_ALT   (IA)    
c           CORR2  = ID_CORR  (IA)    

            DO IS=1,N_STOR    
              IF(ATOM_STOR(IS).EQ.ATOM2.AND.
     *           IFLAG_STOR(IS,2).EQ.0) THEN
                IF(OCCUP(IA).GT.0.0001.AND.ATM_TYPE(IA).NE.'M'.AND.
     *             ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN
                  IFLAG_STOR(IS,2) = IA
                  X_STOR(IS,2)     = XI
                  Y_STOR(IS,2)     = YI
                  Z_STOR(IS,2)     = ZI
                ENDIF
              ENDIF
            ENDDO

          ENDDO

C -- tree --
          I   = IRS1
          IM1 = I      
          I   = IRES_FORW(I)
 1800     CONTINUE  
C         DO    I=IRS1+1,IRF1
C -- tree --

            DO IS=1,N_STOR    
              IFLAG_STOR(IS,1) = IFLAG_STOR(IS,2) 
              IF(IFLAG_STOR(IS,2).NE.0) THEN
                X_STOR(IS,1)     = X_STOR(IS,2)
                Y_STOR(IS,1)     = Y_STOR(IS,2)
                Z_STOR(IS,1)     = Z_STOR(IS,2)
              ENDIF
              IFLAG_STOR(IS,2) = 0
            ENDDO

            MON2   = RES_NAME (I)
            ITYPE2 = IRES_TYPE(I)
C           res- name modification
            IF(MOD_FLAG(I).EQ.'Y') THEN
              IF(MOD_N.GT.0) THEN
                DO IM = 1,MOD_N
                  IF(MOD_IRES    (IM).EQ.I   .AND.
     *               MOD_ICHN    (IM).EQ.ICH1.AND.
     *               MOD_RNAM    (IM).NE.'.' .AND.
     *               MOD_RNAM_NEW(IM).EQ.MON2     ) THEN
                    MON2     = MOD_RNAM(IM)
                    GO TO 200
                  ENDIF
                ENDDO
              ENDIF
 200          CONTINUE
            ENDIF

C           IM1 = I - 1
            MON1   = RES_NAME (IM1)
            ITYPE1 = IRES_TYPE(IM1)
C           res- name modification
            IF(MOD_FLAG(IM1).EQ.'Y') THEN
              IF(MOD_N.GT.0) THEN
                DO IM = 1,MOD_N
                  IF(MOD_IRES    (IM).EQ.IM1 .AND.
     *               MOD_ICHN    (IM).EQ.ICH1.AND.
     *               MOD_RNAM    (IM).NE.'.' .AND.
     *               MOD_RNAM_NEW(IM).EQ.MON1      ) THEN
                    MON1  = MOD_RNAM(IM)
                    GO TO 210
                  ENDIF
                ENDDO
              ENDIF
 210          CONTINUE
            ENDIF

            IF(MON1.EQ.'HOH'.OR.MON2.EQ.'HOH'.OR.
     *         MON1.EQ.'DUM'.OR.MON2.EQ.'DUM') GO TO 400
C
            IAS = IRATM_FIRST(I)
            IAF = IRATM_FIRST(I)+NATM_RES(I)-1
            DO    IA=IAS,IAF
              ATOM2  = ATM_NAME (IA)
              XI     = XYZ_CRD(1,IA)
              YI     = XYZ_CRD(2,IA)
              ZI     = XYZ_CRD(3,IA)
c             ALT2   = ID_ALT   (IA)    
c             CORR2  = ID_CORR  (IA)    

              DO IS=1,N_STOR    
                IF(ATOM_STOR(IS).EQ.ATOM2.AND.
     *             IFLAG_STOR(IS,2).EQ.0) THEN
                  IF(OCCUP(IA).GT.0.0001.AND.ATM_TYPE(IA).NE.'M'.AND.
     *               ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN
                    IFLAG_STOR(IS,2) = IA
                    X_STOR(IS,2)     = XI
                    Y_STOR(IS,2)     = YI
                    Z_STOR(IS,2)     = ZI
                  ENDIF
                ENDIF
              ENDDO

            ENDDO

            FLAG    = 'N'
            ILINK   = 0
            ICONN   = 1
            IREVERS = 0
            JREVERS = 0
            LINK    = ' '

            PRO   = 'N'
            IF(MON2.EQ.'PRO'  .OR.MON2.EQ.'HYP'  .OR.
     *         MON2.EQ.'PRO-D'.OR.MON2.EQ.'5HP'  .OR.
     *         MON2.EQ.'DPR'  .OR.MON2.EQ.'5HP-D'.OR. 
     *         MON2.EQ.'HYP-D'                        ) THEN
              PRO = 'Y'
            ELSE  
              IF(ICONN_TYPE(I).EQ.36.OR.ICONN_TYPE(I).EQ.37)PRO='Y'
              IF(ICONN_TYPE(I).EQ.38.OR.ICONN_TYPE(I).EQ.39)PRO='P'
            ENDIF

            SUG = 'N'
            IF((ITYPE1.GE.7.AND.ITYPE1.LE.8).AND.
     *         (ITYPE2.GE.7.AND.ITYPE2.LE.8)     ) SUG = 'Y'

C ----------non-default link (user definition) ---

            USER = 'N'

            IF((CONN_FLAG .NE.'D'.AND.SUG.EQ.'N').OR.
     *         (SUGAR_FLAG.NE.'D'.AND.SUG.EQ.'Y')    ) THEN

              IF(LN_N_INIT.GT.0) THEN
                DO ILN=1,LN_N_INIT
                  IF(LN_1IRES(ILN).EQ.IM1 .AND.
     *               LN_1ICHN(ILN).EQ.ICH1.AND.
     *               LN_2IRES(ILN).EQ. I  .AND.
     *               LN_2ICHN(ILN).EQ.ICH1.AND.
     *               LN_USED(ILN).NE.'S'       ) THEN
                    SYMM1 = LN_SYMM1(ILN)
                    SYMM2 = LN_SYMM2(ILN)
                    IF((SYMM1.EQ.'.'.OR.SYMM1.EQ.'1_555').AND.
     *                 (SYMM2.EQ.'.'.OR.SYMM2.EQ.'1_555')) THEN
                      LINKS = LN_ID(ILN)
                      CALL LOOK_LINK_LIST(LINKS,ILINKS)
                      CALL SET_ICONN(LINKS,ICONNS)

C                      IF(ICONNS.GE.2.AND.ICONNS.LE.N_CONN_TYPE.AND.
C     *                   ICONNS.NE.36             ) THEN

                      IF(ICONNS.GE.2.AND.ICONNS.LE.N_CONN_TYPE) THEN
C                       gap - ICONN=10 , cis  - ICONN=3  , ptrans - ICONN=36 
C                                        pcis - ICONN=37 , trans  - ICONN=2
                        FLAG  = 'Y'
                        LINK  = LINKS
                        ILINK = ILINKS
                        ICONN = ICONNS
                        USER  = 'Y'
                        IF(SUG.EQ.'Y') NSUG = NSUG + 1
                        GO TO 100
                      ENDIF  
                    ENDIF
                  ENDIF
                ENDDO
              ENDIF

            ENDIF

            IF((ITYPE1.GE.7.AND.ITYPE1.LE.8).AND.
     *         (ITYPE2.GE.7.AND.ITYPE2.LE.8)     ) THEN
C ------------------sugar ---
              LINK = 'BETA1-2'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 > 1.3 * DIST_IDEAL              

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'BETA1-3'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 > 1.3 * DIST_IDEAL              

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'BETA1-4'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 >

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'BETA1-6'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 > 

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'ALPHA1-2'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 > 1.3 * DIST_IDEAL              

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'ALPHA1-3'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 > 1.3 * DIST_IDEAL              

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'ALPHA1-4'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 >

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'ALPHA1-6'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 > 

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
              ENDIF

 110          CONTINUE

              IF(FLAG.EQ.'D') THEN 
                IS1    = ICONN_ATOM_IND(1,ILINK)
                IS2    = ICONN_ATOM_IND(2,ILINK)
                ATOM1  = ATOM_STOR(IS1)
                ATOM2  = ATOM_STOR(IS2)

                CALL LOOK_LINK(LINK,MON1,ATOM1,MON2,ATOM2
     *          ,ITYPE1,ITYPE2,ILINK,MOD1,MOD2,IREVERS)

                IF(ILINK.GT.0.AND.IREVERS.NE.1) THEN
                  I1      = IM1
                  I2      = I                      
                  IF(IREVERS.EQ.1) THEN
                    I2    = IM1
                    I1    = I
                  ENDIF

                  IAA1   = IFLAG_STOR(IA1,1)
                  IAA2   = IFLAG_STOR(IA2,2)
                  XX1(1) = X_STOR(IS1,1) 
                  XX1(2) = Y_STOR(IS1,1) 
                  XX1(3) = Z_STOR(IS1,1) 
                  XX2(1) = X_STOR(IS2,2) 
                  XX2(2) = Y_STOR(IS2,2) 
                  XX2(3) = Z_STOR(IS2,2) 
              
                  IF(JREVERS.EQ.1) THEN
                    I2      = IM1
                    I1      = I
                    IAA1    = IFLAG_STOR(IA1,2)
                    IAA2    = IFLAG_STOR(IA2,1)
                    XX1(1)  = X_STOR(IS1,2) 
                    XX1(2)  = Y_STOR(IS1,2) 
                    XX1(3)  = Z_STOR(IS1,2) 
                    XX2(1)  = X_STOR(IS2,1) 
                    XX2(2)  = Y_STOR(IS2,1) 
                    XX2(3)  = Z_STOR(IS2,1) 
                  ENDIF

C ---             check alpha or beta ?
C                 C1 - X - O5 - C2

                  IF(ATM_NAME(IAA1).EQ.'C1  ') THEN
                    IRR    = I1
C                    T      = XX1(1)  
C                    XX1(1) = XX2(1)
C                    XX2(1) = T
C                    T      = XX1(2)  
C                    XX1(2) = XX2(2)
C                    XX2(2) = T
C                    T      = XX1(3)  
C                    XX1(3) = XX2(3)
C                    XX2(3) = T
                  ELSE
                    IRR    = I2
                    T      = XX1(1)  
                    XX1(1) = XX2(1)
                    XX2(1) = T
                    T      = XX1(2)  
                    XX1(2) = XX2(2)
                    XX2(2) = T
                    T      = XX1(3)  
                    XX1(3) = XX2(3)
                    XX2(3) = T
                  ENDIF
                  IT1 = 0  
                  IT2 = 0  
                  IT3 = 0  
                  IT4 = 0  
                  IAS = IRATM_FIRST(IRR)
                  IAF = IRATM_FIRST(IRR)+NATM_RES(IRR)-1
                  IT = 0
                  DO  IA=IAS,IAF
                    IF(ATM_NAME(IA).EQ.'O5  ') THEN
                       XX3(1) = XYZ_CRD(1,IA)
                       XX3(2) = XYZ_CRD(2,IA)
                       XX3(3) = XYZ_CRD(3,IA)
                       IT     = IT + 1
                    ELSE IF(ATM_NAME(IA).EQ.'C2  ') THEN
                       XX4(1) = XYZ_CRD(1,IA)
                       XX4(2) = XYZ_CRD(2,IA)
                       XX4(3) = XYZ_CRD(3,IA)
                       IT     = IT + 1
                    ENDIF
                  ENDDO
                  IF(IT.GE.2) THEN

                    CALL CALC_I_OVOL_L(IT1,IT2,IT3,IT4,XX1,XX2,XX3,XX4
     *              ,VOLOBS,PH)
                 
C                                  V2 -> I3 
C                    I2 - V1 -> I1 < 
C                                  V3 -> I4 

                    IT = 0
                    IF(PH.GE.0.0.AND.LINK(1:4).EQ.'BETA') THEN
                      IT = 1
                      LINK_NEW =  'ALPHA'//LINK(5:7)
                    ELSE IF(PH.LT.0.0.AND.LINK(1:4).EQ.'ALPH') THEN
                      LINK_NEW =  'BETA'//LINK(6:8)
                      IT = 1   
                    ENDIF
                    IF(IT.GT.0) THEN
                      IF(LN_N.GT.0) THEN
                        DO IC=1,LN_N
                         IF(  LN_ID(IC)   .EQ.LINK .AND.
     *                       ((LN_1IRES(IC).EQ.I1.AND.
     *                         LN_2IRES(IC).EQ.I2     ).OR.
     *                        (LN_1IRES(IC).EQ.I2.AND.
     *                         LN_2IRES(IC).EQ.I1     )    ) ) THEN
                           LN_ID(IC) = LINK_NEW  
                          ENDIF
                        ENDDO
                      ENDIF

                     LINK = LINK_NEW
                     CALL SET_ICONN(LINK,ICONN)
                    ENDIF

                  ENDIF
C ---
                  IA      = 0
C                 sugar's connection is found
C                 put in table because there is not defaults for sugars
                  IF(SUGAR_FLAG.NE.'N') THEN
                    CALL PUT_L_TABL(MDOC,LINK,ICH1,ICH1
     *              ,I1,I2,IAA1,IAA2,IREVERS,IERR)

                    IF(SUG.EQ.'Y') NSUG = NSUG + 1
                  ENDIF

C            write(*,*) '-sug',link,i1,iaa1,i2,iaa2,IREVERS,jREVERS

c                  IF(JREVERS.EQ.1) THEN
c                    FLAG  = 'N'
c                    ILINK = 0
c                    ICONN = 1
c                  ENDIF

                  GO TO 100
                ELSE
                  FLAG  = 'N'
                  ILINK = 0
                  ICONN = 1
                ENDIF
              ENDIF
            ELSE IF(((ITYPE1.GE.3.AND.ITYPE1.LE.4).OR.ITYPE1.EQ.10).AND.
     *              ((ITYPE2.GE.3.AND.ITYPE2.LE.4).OR.ITYPE2.EQ.10)     
     *                                                         ) THEN
C ----------default link for peptides ---
              FLAG  = 'D'
              IF(MON1.EQ.'FOR') THEN
                LINK  = 'FOR_C-N'
              ELSE IF(MON2.EQ.'FOR') THEN
                LINK  = 'FOR_C-C'
              ELSE IF(MON1.EQ.'ACE') THEN
                LINK  = 'ACE_C-N'
              ELSE IF(MON1.EQ.'DFO') THEN
                IF(MON2.EQ.'NME') THEN
                  LINK  = 'DFO-NME'
                ELSE IF(MON2.EQ.'DFO') THEN
                  LINK  = 'DFO-DFO'
                ELSE IF(MON2.EQ.'STA') THEN
                  LINK  = 'DFO-STA'
                ELSE
                  LINK  = 'DFO_C-N'
                ENDIF
              ELSE IF(MON1.EQ.'STA') THEN
                IF(MON2.EQ.'NME') THEN
                  LINK  = 'STA-NME'
                ELSE IF(MON2.EQ.'DFO') THEN
                  LINK  = 'STA-DFO'
                ELSE IF(MON2.EQ.'STA') THEN
                  LINK  = 'STA-STA'
                ELSE
                  LINK  = 'STA_C-N'
                ENDIF
              ELSE IF(MON2.EQ.'DFO') THEN
                LINK  = 'DFO_N-C'
               ELSE IF(MON2.EQ.'STA') THEN
                LINK  = 'STA_N-C'
              ELSE IF(MON2.EQ.'NME') THEN
                LINK  = 'NME_N-C'
              ELSE IF(MON2.EQ.'AHT') THEN
                LINK  = 'TRANS'
              ELSE IF(MON1.EQ.'IVA') THEN
                LINK  = 'TRANS'
              ELSE IF(MON2.EQ.'DFO') THEN
                LINK  = 'TRANS'
              ELSE IF(MON1.EQ.'INI') THEN
                LINK  = 'TRANS'
              ELSE IF(MON2.EQ.'INI') THEN
                LINK  = 'TRANS'
              ELSE IF(MON1.EQ.'ILG')THEN
                IF(ITYPE2.EQ.10) THEN
                  LINK  = 'ILG_CD-N'
                ELSE
                  LINK  = 'ILG_CD-p'
                ENDIF
              ELSE IF(ITYPE1.EQ.10) THEN
                IF(ITYPE2.GE.3.AND.ITYPE2.LE.4) THEN     
                  LINK  = 'LINK_CNp'
                ELSE
                  LINK  = 'LINK_C-N'
                ENDIF
              ELSE IF(ITYPE2.EQ.10) THEN
                IF(ITYPE1.GE.3.AND.ITYPE1.LE.4) THEN     
                  LINK  = 'LINK_CpN'
                ELSE
                  LINK  = 'LINK_C-N'
                ENDIF
              ELSE 
                LINK  = 'TRANS'
                IF(PRO.EQ.'Y') LINK = 'PTRANS'
                IF(PRO.EQ.'P') LINK = 'NMTRANS'
C               default 'gap'
                IF(ICONN_TYPE(I).EQ.10) LINK = 'gap'
              ENDIF
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
C -----------------
C     5 'FOR_C-N ', bond_FOR-C_=_N-peptide
C     6 'FOR_C-C ', bond_FOR-C_=_C-peptide
C     7 'ACE_C-N ', bond_ACE-C_=_N_peptide
C     8 'DFO_C-N ', bond_DFO-C_=_N-peptide
C     9 'NME_N-C ', bond_NME-N_=_C-peptide
C
C  ???   FOR+AA may be single residue -> modification
C ------------- ---

C ----------default link for DNA/RNA ---
            ELSE IF((ITYPE1.GE.5.AND.ITYPE1.LE.6).AND.
     *              (ITYPE2.GE.5.AND.ITYPE2.LE.6)     ) THEN
              FLAG  = 'D'
              LINK  = 'p'
C             default 'gap'
              IF(ICONN_TYPE(I).EQ.10) LINK = 'gap'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
            ENDIF
  
C ---------------------------
 100        CONTINUE

            IF(FLAG.EQ.'Y'.OR.FLAG.EQ.'D') THEN
C             D - default, Y - user

              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)

              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                                       ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 >       


C       write(*,*) '-f-',link,flag,conn_flag,user,mon1,mon2,idist,dist
C       write(*,*) '  -',sug,jrevers,irevers


              IF(IDIST.EQ.0) THEN
              
                IF(LINK(1:3).NE.'gap') THEN

                  IS1   = ICONN_ATOM_IND(1,ILINK)
                  IS2   = ICONN_ATOM_IND(2,ILINK)
                  ATOM1 = ATOM_STOR(IS1)
                  ATOM2 = ATOM_STOR(IS2)

                  CHAR8 = MON2
                  IF(LINK.EQ.'PTRANS'.OR.LINK.EQ.'PCIS'.OR.
     *            LINK.EQ.'NMTRANS'.OR.LINK.EQ.'NMCIS') CHAR8 = 'PRO'
                  CALL LOOK_LINK(LINK,MON1,ATOM1,CHAR8,ATOM2
     *            ,ITYPE1,ITYPE2,ILINK,MOD1,MOD2,IREVERS)

C       write(*,*) '  -r',link,jrevers,irevers

                  IF(ILINK.GT.0) THEN
                    I1 = IM1
                    I2 = I                      
                    IA = 0
C                   put MOD1 and MOD2 to the list of modifications
                    MTYPE = 'Y'
                    IF(JREVERS.EQ.0) THEN
                      IF(MOD1(1:1).NE.'.'.AND.MOD1(1:1).NE.' ') THEN
                        MON_N='   '
                        CALL PUT_M_TABL(MDOC,MOD1,ICH1
     *                                      ,I1,IA,MON_N,MTYPE,IERR)
                      ENDIF
                      IF(MOD2(1:1).NE.'.'.AND.MOD2(1:1).NE.' ') THEN
                        MON_N='   '
                        CALL PUT_M_TABL(MDOC,MOD2,ICH1
     *                                       ,I2,IA,MON_N,MTYPE,IERR)
                      ENDIF
                    ELSE
                      IF(MOD2(1:1).NE.'.'.AND.MOD2(1:1).NE.' ') THEN
                        MON_N='   '
                        CALL PUT_M_TABL(MDOC,MOD2,ICH1
     *                                      ,I1,IA,MON_N,MTYPE,IERR)
                      ENDIF
                      IF(MOD1(1:1).NE.'.'.AND.MOD1(1:1).NE.' ') THEN
                        MON_N='   '
                        CALL PUT_M_TABL(MDOC,MOD1,ICH1
     *                                       ,I2,IA,MON_N,MTYPE,IERR)
                      ENDIF
                    ENDIF
                    IF(IERR.NE.0) RETURN

                    IF(LINK.EQ.'TRANS'.OR.LINK.EQ.'PTRANS'.OR.
     *                                    LINK.EQ.'NMTRANS') THEN 
c                    IF(FLAG.EQ.'D'.AND.
c     *                 (LINK.EQ.'TRANS'.OR.LINK.EQ.'PTRANS')) THEN 
C                     check CIS peptide bond
                      CALL CALC_PEP_BOND_ANGLE(MDOC,ANGOBS,IERR)

                      IF(IERR.EQ.0) THEN
                        IF(ABS(ANGOBS).GT.180.0) 
     *                    ANGOBS = ABS(360.0-ABS(ANGOBS))
                        IF(ABS(ANGOBS).LT.90.0) THEN
                          IF(CIS_FLAG.EQ.'Y'.AND.USER.NE.'Y') THEN
                            LINK = 'CIS'
                            IF(PRO.EQ.'Y') LINK = 'PCIS'
                            IF(PRO.EQ.'P') LINK = 'NMCIS'
                            CALL SET_ICONN(LINK,ICONN)
                            IREVERS = 0
                            CALL PUT_L_TABL(MDOC,LINK,ICH1,ICH1
     *                      ,I1,I2,IA,IA,IREVERS,IERR)
                            WRITE(LINE,
     *'('' WARNING : CIS peptide bond is found, angle ='',F10.2)')
     *                      ANGOBS
                            CALL MSGDOC(MDOC,LINE)                    
                          ELSE
                            WRITE(LINE,
     *'('' WARNING : CIS peptide bond (not be used) angle ='',F10.2)')
     *                      ANGOBS
                            CALL MSGDOC(MDOC,LINE)                    
                          ENDIF

                          WRITE(LINE,'(3A,A5,3A,A5,2A)')
     *'           ch:',GROUP_ID(ICH1),' res:',RES_NUM_PDB(I1)(3:7),
     *' ',RES_NAME(I1),' -->',RES_NUM_PDB(I2)(3:7),' ',RES_NAME(I2)
                          CALL MSGDOC(MDOC,LINE)                    
                        ENDIF
                      ELSE
                        IERR=0
                      ENDIF
                    ELSE IF(LINK.EQ.'CIS'.OR.LINK.EQ.'PCIS'.OR. 
     *                      LINK.EQ.'NMCIS') THEN 
C                     check CIS peptide bond
                      CALL CALC_PEP_BOND_ANGLE(MDOC,ANGOBS,IERR)

                      IF(IERR.EQ.0) THEN
                        IF(ABS(ANGOBS).GT.180.0) 
     *                    ANGOBS = ABS(360.0-ABS(ANGOBS))
                        IF(ABS(ANGOBS).GT.90.0) THEN
                          IF(CIS_FLAG.EQ.'Y'.AND.USER.NE.'Y') THEN
                            LINK = 'TRANS'
                            IF(PRO.EQ.'Y') LINK = 'PTRANS'
                            IF(PRO.EQ.'P') LINK = 'NMTRANS'
                            CALL SET_ICONN(LINK,ICONN)
                            IREVERS = 0
                            CALL PUT_L_TABL(MDOC,LINK,ICH1,ICH1
     *                      ,I1,I2,IA,IA,IREVERS,IERR)
                            WRITE(LINE,'(A,F10.2)')
     *' WARNING : TRANS peptide bond is found instead CIS, angle =',
     *ANGOBS
                            CALL MSGDOC(MDOC,LINE)                    
                          ELSE
                            WRITE(LINE,'(A,F10.2)')
     *' WARNING : TRANS peptide bond (not be changed CIS) angle ='
     *,ANGOBS
                            CALL MSGDOC(MDOC,LINE)                    
                          ENDIF

                          WRITE(LINE,'(3A,A5,3A,A5,2A)')
     *'           ch:',GROUP_ID(ICH1),' res:',RES_NUM_PDB(I1)(3:7),
     *' ',RES_NAME(I1),' -->',RES_NUM_PDB(I2)(3:7),' ',RES_NAME(I2)
                          CALL MSGDOC(MDOC,LINE)                    
                        ENDIF
                      ELSE
                        IERR=0
                      ENDIF

                    ELSE IF(LINK.NE.'p'.AND.LINK.NE.'PTRANS'.AND.
     *                                         LINK.NE.'NMTRANS') THEN 

                      II1 = I1
                      II2 = I2
                      IF(JREVERS.EQ.1) THEN
                        II2 = I1
                        II1 = I2
                      ENDIF
c     *'('' WARNING : link: '',A8,'' ch:'',A,'' res:'',A5,'' ''
                      WRITE(LINE,'(A,A8,A,A,A,A5,A,A,A,A5,A,A)')
     *' WARNING : conn: ',LINK,' ch:',GROUP_ID(ICH1),' res:',
     *RES_NUM_PDB(II1)(3:7),' ',RES_NAME(II1),'-->',
     *RES_NUM_PDB(II2)(3:7),' ',RES_NAME(II2)
                      CALL MSGDOC(MDOC,LINE)                    
                    
                    ENDIF

                      
                    IF(JREVERS.EQ.1) THEN
                      ICONN = 1
                      CALL MSGDOC(MDOC,
     *                ' WARNING :       reverse conn, not be used')
                    ENDIF
                    IF(SUG.EQ.'Y'.AND.SUGAR_FLAG.EQ.'N'.AND.
     *                                USER.NE.'Y'           ) THEN
                      LINE = 
     *                '                 not be used ( sugar_flag = '//
     *                SUGAR_FLAG//' )'
                      CALL MSGDOC(MDOC,LINE)
                      ICONN = 1
                    ENDIF
                    IF(SUG.EQ.'N'.AND.CONN_FLAG.EQ.'N'.AND.
     *                 FLAG.NE.'D'.AND.USER.NE.'Y'           ) THEN
                      LINE = 
     *                '                 not be used ( conn_flag = '//
     *                CONN_FLAG//' )'
                      CALL MSGDOC(MDOC,LINE)
                      ICONN = 1
                    ENDIF
                    IF(ICONN.GT.1) ICONN_TYPE(I) = ICONN

                  ELSE
                    WRITE(LINE,'(A,A8,A)')
     *              ' WARNING : description of link:',LINK
     *              ,' not found. (chain connectivity)'
                    CALL MSGDOC(MDOC,LINE)
                    WRITE(LINE,'(''           link will be ignored'')') 
                    CALL MSGDOC(MDOC,LINE)
                  ENDIF
                ELSE
C                 --- gap (user definition) ---
                  I1      = IM1
                  I2      = I                      
                  WRITE(LINE,'(A,A,A,A5,A,A,A,A5,A,A)')
     *' WARNING : conn: gap (user) ch:',GROUP_ID(ICH1),' res:',
     *RES_NUM_PDB(I1)(3:7),' ',RES_NAME(I1),'-->',RES_NUM_PDB(I2)(3:7),
     *' ',RES_NAME(I2)
                  CALL MSGDOC(MDOC,LINE)                    
                  ICONN_TYPE(I) = ICONN
                ENDIF

              ELSE
C               -- dist is big --
C               message actual DIST
                I1      = IM1
                I2      = I                      
                IA      = 0
                IREVERS = 0

                IF(LINK(1:3).NE.'gap') THEN 

                  MMM = MDOC
                  IF(DIST.GT.9999.9) MMM = LDOC
 
                  CALL SET_ICONN(LINK,ICONN)
                  IF(ICONN.LE.0) ICONN = 1

                  IF(DIST.GT.9999.9) THEN
                    WRITE(LINE,
     *'('' WARNING : undefined distance for link:'',A8)')
     *              LINK
                  ELSE
                    WRITE(LINE,
     *'('' WARNING : big distance for conn:'',A8,'' dist ='',F10.3)')
     *              LINK,DIST
                  ENDIF
                  CALL MSGDOC(MMM,LINE)                    

                  WRITE(LINE,'(3A,A5,3A,A5,3A,F10.3)')
     *'           ch:',GROUP_ID(ICH1),' res:',RES_NUM_PDB(I1)(3:7),
     *' ',RES_NAME(I1),'-->',RES_NUM_PDB(I2)(3:7),' ',RES_NAME(I2),
     *' ideal_dist=',DIST_IDL
                  CALL MSGDOC(MMM,LINE)                    

                  IF(JREVERS.EQ.1) THEN
                    ICONN = 1
                    CALL MSGDOC(MMM,
     *              ' WARNING :       reverse conn, not be used')
                  ENDIF

                  IF(SUG.EQ.'Y') THEN
                    IF(SUGAR_FLAG.EQ.'N'.AND.USER.NE.'Y') THEN
                      LINE = 
     *                '                 not be used ( sugar_flag = '//
     *                SUGAR_FLAG//' )'
                      CALL MSGDOC(MMM,LINE)
                      ICONN = 1
                    ENDIF
                  ELSE
                    IF(CONN_FLAG.EQ.'N'.AND.USER.NE.'Y'.AND.
     *                 FLAG.NE.'D'                          ) THEN
                      LINE = 
     *                '                 not be used ( conn_flag = '//
     *                CONN_FLAG//' )'
                      CALL MSGDOC(MMM,LINE)
                      ICONN = 1
                    ENDIF
                  ENDIF
                  
                  IF(ICONN.GT.1) ICONN_TYPE(I) = ICONN

                  IF(USER.EQ.'Y') THEN                 
                    CALL SET_ICONN(LINK,ICONN)
c                    CALL PUT_L_TABL(MDOC,LINK,ICH1,ICH1
c     *              ,I1,I2,IA,IA,IREVERS,IERR)   
                    CALL MSGDOC(MMM,'     link will be created')
                    ICONN_TYPE(I) = ICONN
                  ENDIF

                ELSE

                  WRITE(LINE,'(3A,A5,3A,A5,2A)')
     *' WARNING : conn: gap.     ch:',GROUP_ID(ICH1),' res:',
     *RES_NUM_PDB(I1)(3:7),' ',RES_NAME(I1),'-->',RES_NUM_PDB(I2)(3:7),
     *' ',RES_NAME(I2)
                  CALL MSGDOC(LDOC,LINE)                    

c          write(*,*) '--',ITYPE1,ITYPE2,flag,user,LINK

                  IF(((ITYPE1.EQ.3.OR.ITYPE1.EQ.4.OR.ITYPE1.EQ.10).AND.
     *                (ITYPE2.EQ.3.OR.ITYPE2.EQ.4.OR.ITYPE2.EQ.10)).OR.
     *               ((ITYPE1.GE.5.AND.ITYPE1.LE.6).AND.
     *                (ITYPE2.GE.5.AND.ITYPE2.LE.6)     ) ) THEN
C                   polypeptide or DNA/RNA
                    IF((FLAG.EQ.'D'.AND.CONN_FLAG.NE.'N').OR.
     *                  USER.EQ.'Y') THEN                 
C                     it is gap-link (for default connection) 
                      LINK = 'gap'
                      CALL SET_ICONN(LINK,ICONN)
                      IF(USER.NE.'Y') THEN
                        IA = 0

c         write(*,*) '-----',link,IA,ICH1,I,I1,I2,IREVERS

                        CALL PUT_L_TABL(MDOC,LINK,ICH1,ICH1
     *                  ,I1,I2,IA,IA,IREVERS,IERR)
                      ENDIF   
                      CALL MSGDOC(LDOC,
     *                '           "gap"-link will be created')
                      ICONN_TYPE(I) = ICONN
                    ENDIF
                  ENDIF

                ENDIF

              ENDIF

            ENDIF

 400        CONTINUE
C         -- I --
C ---     tree
C         ENDDO
          IF(I.NE.IRF1) THEN
            IM1 = I
            I   = IRES_FORW(I)
            IF(I.LE.0) THEN
              CALL MSGERR(MDOC,' ERROR: wrong tree structure .....')
              IERR = 1
              RETURN
            ENDIF
            GO TO 1800
          ENDIF
C ---     tree --

        ENDIF
 600    CONTINUE
C     -- ICH1 --
      ENDDO

      RETURN
      END

      SUBROUTINE CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                                       ,I1,I2,IREVERS)
C -----------------
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------------------
C      PARAMETER ( NSTOR_PAR = 50 )
C      COMMON /COM_CONN_INF/  N_STOR,IFLAG_STOR,ICONN_ATOM_IND
C     *                      ,X_STOR,Y_STOR,Z_STOR
C     *                      ,ATOM_STOR
C -------------------------------------------------------------------
C      INTEGER    N_STOR,IFLAG_STOR(NSTOR_PAR,2)
C      REAL       X_STOR(NSTOR_PAR,2),Y_STOR(NSTOR_PAR,2)
C     *          ,Z_STOR(NSTOR_PAR,2)
C      CHARACTER  ATOM_STOR(NSTOR_PAR)*4
C ---
C      INTEGER    ICONN_ATOM_IND(2,MAXLLNK)
C -------------------------------------------------------------------
      DIST_IDL = 0.0
      DIST     = 0.0      
      IDIST    =-1
      IREVERS  = 0

      IF(ILINK.LE.0.OR.ILINK.GT.MAXLLNK) RETURN

      I1    = ICONN_ATOM_IND(1,ILINK)
      I2    = ICONN_ATOM_IND(2,ILINK)

c      WRITE(*,*) '===',I1,I2,IFLAG_STOR(I1,1),IFLAG_STOR(I2,2)

      DIST  = 10000.0

      IF(I1.EQ.0.OR.I2.EQ.0   ) RETURN 
      IF(IFLAG_STOR(I1,1).EQ.0) GO TO 100
      IF(IFLAG_STOR(I2,2).EQ.0) GO TO 100


      IDIST = 0

      X1    = X_STOR(I1,1) 
      Y1    = Y_STOR(I1,1) 
      Z1    = Z_STOR(I1,1) 
      X2    = X_STOR(I2,2) 
      Y2    = Y_STOR(I2,2) 
      Z2    = Z_STOR(I2,2) 
      D2    = (X1-X2)*(X1-X2) + (Y1-Y2)*(Y1-Y2) + (Z1-Z2)*(Z1-Z2)
      DIST  = SQRT(ABS(D2))

 100  CONTINUE

      IF(IFLAG_STOR(I2,1).EQ.0) GO TO 200
      IF(IFLAG_STOR(I1,2).EQ.0) GO TO 200

      IDIST = 0
      X1    = X_STOR(I2,1) 
      Y1    = Y_STOR(I2,1) 
      Z1    = Z_STOR(I2,1) 
      X2    = X_STOR(I1,2) 
      Y2    = Y_STOR(I1,2) 
      Z2    = Z_STOR(I1,2) 
      D2    = (X1-X2)*(X1-X2) + (Y1-Y2)*(Y1-Y2) + (Z1-Z2)*(Z1-Z2)
      DIST2 = SQRT(ABS(D2))

      IF(DIST2.LT.DIST) THEN
        DIST    = DIST2
        IREVERS = 1
      ENDIF

 200  CONTINUE

      DIST_IDL = BOND_IDL(ILINK)
      T        = DIST_IDL
      IF(T.LE.0.00001) T = 1.5
      T        = DIST/T

      IF(T.GT.1.3)    IDIST = 1
      IF(IDIST.EQ.-1) DIST  = 0.0

      RETURN
      END


      SUBROUTINE LOOK_LINK_LIST(LINKS,ILINK)
C -----------------------------------------------
C -P-  return ILINK = 0  not found in table of links ( LLL_ )
C -----------------------------------------------
      INTEGER*4 ILINK
      CHARACTER LINKS*8,LINK*8
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
C -----------------------------------
      ILINK = 0

      CALL LENSTR_BL(LINKS,LENS)

      IF(LLL_NLINK.GT.0.AND.LENS.GT.0) THEN

        DO L=1,LLL_NLINK

          LINK=LLL_LNAME(L)
          CALL LENSTR_BL(LINK,LENL)
          IF(LINKS(1:LENS).EQ.LINK(1:LENL)) THEN
            ILINK = L
            IF(LLL_FUSE(ILINK).NE.'?'.AND.
     *         LLL_FUSE(ILINK).NE.'C') LLL_FUSE(ILINK)='Y'
            GO TO 100
          ENDIF

        ENDDO
      
      ENDIF

 100  CONTINUE

      RETURN
      END

      SUBROUTINE LOOK_LINK(LINKS,MON1,ATOM1,MON2,ATOM2
     *          ,ITYPE1,ITYPE2,ILINK,MOD1,MOD2,IREVERS)
C -----------------------------------------------
C -P-  return ILINK =< 0  not found in table of links ( LLL_ )
C                      N  link's number in the list of links.
C              If LINKS = ' ' or '.' - looking by MON,ATOM,TYPE        
C
C      search by MON, TYPE ( of residue ) , ATOM
C      now used only bonds
C -----------------------------------------------
      INTEGER*4 ILINK,ITYPE1,ITYPE2
      CHARACTER LINKS*8,LINK*8,MON1*8,MON2*8,ATOM1*4,ATOM2*4
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER TYPE1*8 ,TYPE2*8
      CHARACTER LTYPE1*8,LTYPE2*8
      CHARACTER MOD1*8,MOD2*8
C -----------------------------------
      ILINK   = 0
      MOD1    = '.'
      MOD2    = '.'
      IREVERS = 0
      CALL LENSTR_BL(MON1 ,LM1)
      CALL LENSTR_BL(MON2 ,LM2)

      IF((ITYPE1.EQ.7.OR.ITYPE1.EQ.8).AND.LM1.GT.3) LM1 = 3
      IF((ITYPE2.EQ.7.OR.ITYPE2.EQ.8).AND.LM2.GT.3) LM2 = 3

      CALL LENSTR_BL(LINKS,LENS)

      IF(LENS.GT.0) THEN
        ILINK = -1
        IF(LINKS.EQ.'.') THEN
          LENS  = 0
          ILINK = 0
        ENDIF
      ENDIF     

      TYPE1 = RES_LTYPE(ITYPE1)
      TYPE2 = RES_LTYPE(ITYPE2)

c      write(*,*) 
c     * '-->',links,';',mon1,';',atom1,';',mon2
c     *,';',atom2,';',type1,';',type2,';',lens
c      write(*,*) '-- itype:',ITYPE1,ITYPE2 

      IF(LLL_NLINK.GT.0) THEN

        DO L=1,LLL_NLINK

          LINK = LLL_LNAME(L)

          IF(LENS.GT.0) THEN
            LINK = LLL_LNAME(L)
            CALL LENSTR_BL(LINK,LENL)
            IF(LINKS(1:LENS).NE.LINK(1:LENL)) GO TO 100     
          ENDIF

c       write(*,*)
c     * ' =',link,';',LLL_mon1(l),';',LLL_mon2(l)
c     *,';',LLL_type1(l),';',LLL_type2(l),';'

          CALL SET_LTYPE(LLL_TYPE1(L),IT1)    
          LTYPE1 = LLL_TYPE1(L)
          CALL SET_LTYPE(LLL_TYPE2(L),IT2)    
          LTYPE2 = LLL_TYPE2(L)


c          IF(LTYPE1.EQ.'polymer'.AND.TYPE1.EQ.'peptide')LTYPE1='peptide' 
c          IF(LTYPE2.EQ.'polymer'.AND.TYPE2.EQ.'peptide')LTYPE2='peptide' 

          IF( (MON1(1:LM1).EQ.LLL_MON1(L)) .OR.
     *        (LLL_MON1(L)(1:1).EQ.'.'.AND.
     *         ( (TYPE1.EQ.LTYPE1         ) .OR.
     *           (LTYPE1(1:1).EQ.'.'     )     ))) THEN

            IF( (MON2(1:LM2).EQ.LLL_MON2(L)) .OR.
     *          (LLL_MON2(L)(1:1).EQ.'.'.AND.
     *           ( (TYPE2.EQ.LTYPE2        ) .OR.
     *             (LTYPE2(1:1).EQ.'.'     )     ))) THEN
              IFLAG=1
              GO TO 200
            ENDIF
          ENDIF

          LTYPE1 = LLL_TYPE1(L)
          LTYPE2 = LLL_TYPE2(L)

c          IF(LTYPE1.EQ.'polymer'.AND.TYPE2.EQ.'peptide')LTYPE1='peptide' 
c          IF(LTYPE2.EQ.'polymer'.AND.TYPE1.EQ.'peptide')LTYPE2='peptide' 

          IF( (MON2(1:LM2).EQ.LLL_MON1(L)) .OR.
     *        (LLL_MON1(L)(1:1).EQ.'.'.AND.
     *         ( (TYPE2.EQ.LTYPE1        ) .OR.
     *           (LTYPE1(1:1).EQ.'.'     )     ))) THEN

            IF( (MON1(1:LM1).EQ.LLL_MON2(L)) .OR.
     *          (LLL_MON2(L)(1:1).EQ.'.'.AND.
     *           ( (TYPE1.EQ.LTYPE2        ) .OR.
     *             (LTYPE2(1:1).EQ.'.'  )     ))) THEN

              IFLAG=2
              GO TO 200
            ENDIF
          ENDIF
          GO TO 100

 200      CONTINUE

          IF(LLL_MON1(L)(1:1).EQ.'.'.AND.LLL_MON2(L)(1:1).EQ.'.')
     *    IFLAG = 3

c            WRITE(*,*) '-iflag:',iflag,LLL_IBOND(L),LLB_NBOND

          IF(LLB_NBOND.GT.0.AND.LLL_IBOND(L).GT.0) THEN

            DO IB=LLL_IBOND(L),LLB_NBOND
              IF(LLL_LNAME(L).EQ.LLB_LNAME(IB)) THEN

C                write(*,*) ib,';',LLL_LNAME(L),';',LLB_LNAME(IB),';'
C                write(*,*) ib,';',LLb_1atm(ib),';',LLB_2atm(IB),';'
C                write(*,*) 'iflag:',IFLAG,l

                IF(IFLAG.EQ.1.OR.IFLAG.EQ.3) THEN
                  IF(ATOM1.EQ.LLB_1ATM(IB).AND.
     *               ATOM2.EQ.LLB_2ATM(IB)) THEN
                    ILINK   = L
                    MOD1    = LLL_MOD1(L)
                    MOD2    = LLL_MOD2(L)
                    IREVERS = 0
                    RETURN 
                  ELSE IF(IFLAG.EQ.1.AND.MON1(1:LM1).EQ.MON2(1:LM2))THEN
                    IF(ATOM2.EQ.LLB_1ATM(IB).AND.
     *                 ATOM1.EQ.LLB_2ATM(IB)) THEN
                      ILINK   = L
                      MOD2    = LLL_MOD1(L)
                      MOD1    = LLL_MOD2(L)
                      IREVERS = 1
                      RETURN 
                    ENDIF
                  ENDIF
                ENDIF
                IF(IFLAG.EQ.2.OR.IFLAG.EQ.3) THEN
                  IF(ATOM2.EQ.LLB_1ATM(IB).AND.
     *               ATOM1.EQ.LLB_2ATM(IB)) THEN
                    ILINK   = L
                    MOD2    = LLL_MOD1(L)
                    MOD1    = LLL_MOD2(L)
                    IREVERS = 1
                    RETURN 
                  ELSE IF(IFLAG.EQ.2.AND.MON1(1:LM1).EQ.MON2(1:LM2))THEN
                    IF(ATOM1.EQ.LLB_1ATM(IB).AND.
     *                 ATOM2.EQ.LLB_2ATM(IB)) THEN
                      ILINK   = L
                      MOD1    = LLL_MOD1(L)
                      MOD2    = LLL_MOD2(L)
                      IREVERS = 0
                      RETURN 
                    ENDIF
                  ENDIF
                ENDIF
              ENDIF
            ENDDO

          ELSE

            IF((ATOM1(1:1).EQ.'.'.OR.ATOM1(1:1).EQ.' ').AND.
     *         (ATOM2(1:1).EQ.'.'.OR.ATOM2(1:1).EQ.' ')     ) THEN
              ILINK = L
              RETURN    
            ENDIF

          ENDIF

          IF(LENS.GT.0) THEN
            ILINK = -1
            RETURN
          ENDIF

 100      CONTINUE

        ENDDO

      ENDIF

      RETURN
      END

      SUBROUTINE GET_LINK_ATOM(LINKS,ATOM1,ATOM2,ILINK)
C -----------------------------------------------
C -P-  return ILINK =< 0  not found in table of links ( LLL_ )
C                      N  link's number in the list of links.
C              If LINKS = ' ' or '.' - looking by MON,ATOM,TYPE        
C
C      search by MON, TYPE ( of residue ) , ATOM
C      now used only bonds
C -----------------------------------------------
      INTEGER   ILINK
      CHARACTER LINK*8,LINKS*8,ATOM1*4,ATOM2*4
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------------
      ILINK   = 0

      CALL LENSTR_BL(LINKS,LENS)
      IF(LENS.LE.0.OR.LINKS(1:1).EQ.'.'.OR.LINKS(1:1).EQ.'?'.OR.
     *                LINKS     .EQ.'gap') THEN
        RETURN
      ENDIF     

      IF(LLL_NLINK.GT.0) THEN

        DO L=1,LLL_NLINK

          LINK = LLL_LNAME(L)

          CALL LENSTR_BL(LINK,LENL)
          IF(LENS.EQ.LENL.AND.LINKS(1:LENS).EQ.LINK(1:LENL)) THEN     

            IF(LLB_NBOND.GT.0.AND.LLL_IBOND(L).GT.0) THEN

              DO IB=LLL_IBOND(L),LLB_NBOND

                IF(LLL_LNAME(L).EQ.LLB_LNAME(IB)) THEN
                  ATOM1 = LLB_1ATM(IB)
                  ATOM2 = LLB_2ATM(IB)
                  ILINK = L
                  GO TO 100
                ENDIF
              ENDDO
            ENDIF
          ENDIF
        ENDDO
        ILINK = 0
 100    CONTINUE
      ENDIF

      RETURN
      END

      SUBROUTINE CHECK_LINK_INFO(LINKS,MON1,MON2,ATOM1,ATOM2
     *                         ,DIDEAL,ILINK)
C -----------------------------------------------
C -----------------------------------------------
      INTEGER   ILINK,ITYPE1,ITYPE2
      REAL      DIDEAL
      CHARACTER LINK*8,LATOM1*4,LATOM2*4,LMON1*8,LMON2*8
      CHARACTER LTYPE1*8,LTYPE2*8
      CHARACTER LINKS*8
      CHARACTER MON1*8,MON2*8,ATOM1*4,ATOM2*4
      CHARACTER TYPE1*8,TYPE2*8
      CHARACTER LINE*80,MN1*3,MN2*3
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      ILINK   = 0
      MDOC    = 0
      DIDEAL  = 0.0

      CALL LENSTR_BL(LINKS,LENS)
C      IF(LENS.LE.0.OR.LINKS(1:1).EQ.'.') THEN
C        RETURN
C      ENDIF     

C      DATA RNAMES/'MAN','NAG','FUC','GAL','GLC','GCU','CEG','XYS'/ 
C                  'ARB','RIP','ABE','RAM','MAG','MMA','GSA'   
C      ITYPE = 7
C      RES_LTYPE( 7) =  'pyranose'
C      DATA RNAME /'CYS','SER','THR','PRO','ALA','GLY','ASN','ASP' 
C      ITYPE = 3
C      RES_LTYPE( 3) =  'peptide '
C      DATA RNAMEP/'STA','DFO','FOR','BOC','IVA','NME','ACE','DAM'
C      ITYPE = 10
C      RES_LTYPE(10) =  'polymer '
C      DATA RNAMED/'A  ','C  ','G  ','T  ','U  ','I  ','+A ','+C ' 
C      ITYPE = 5
C      RES_LTYPE( 5) =  'DNA/RNA '
C
C      RES_TYPE( 9) =  'solvent         '
C      RES_TYPE(10) =  'polymer         '
C      RES_TYPE(11) =  'D-furanose      '
C      RES_TYPE(12) =  'L-furanose      '
C      RES_TYPE(13) =  'D-saccharide    '
C      RES_TYPE(14) =  'L-saccharide    '
C
C      RES_LTYPE( 9) =  'solvent '
C      RES_LTYPE(10) =  'polymer '
C      RES_LTYPE(11) =  'furanose'
C      RES_LTYPE(12) =  'furanose'
C      RES_LTYPE(13) =  'sacchari'
C      RES_LTYPE(14) =  'sacchari'

C      CALL SET_INI_RES_TYPE(MDOC,LINE,MON1,ITYPE1,IERR)
C      CALL SET_INI_RES_TYPE(MDOC,LINE,MON2,ITYPE2,IERR)
      CALL GET_INI_RES_TYPE(MDOC,LINE,MON1,ITYPE1,IERR)
      CALL GET_INI_RES_TYPE(MDOC,LINE,MON2,ITYPE2,IERR)

      TYPE1 = RES_LTYPE(ITYPE1)
      TYPE2 = RES_LTYPE(ITYPE2)

      CALL LENSTR_BL(MON1 ,LM1)
      CALL LENSTR_BL(MON2 ,LM2)

      IF((ITYPE1.EQ.7).AND.LM1.GT.3) LM1 = 3
      IF((ITYPE2.EQ.7).AND.LM2.GT.3) LM2 = 3
      MN1 = MON1(1:LM1) 
      MN2 = MON2(1:LM2) 


      IF(LLL_NLINK.GT.0) THEN

        DO L=1,LLL_NLINK

          LINK   = LLL_LNAME(L)
          LTYPE1 = LLL_TYPE1(L)
          LTYPE2 = LLL_TYPE2(L)
          LMON1  = LLL_MON1(L)
          LMON2  = LLL_MON2(L)

C LINK_C-N bond_C_=_N               .   .        polymer  .   .        polymer
C STA_N-C  bond_DFO-N_=_C-peptide   .   .        peptide  DFO .        .       
C XYS-ASN  bond_XYS-C1_=_ASN-ND2    XYS XYS-O1   .        ASN .        .
C ZN-CYS   bond_ZN_=_CYS-SG         ZN  .        .        CYS .        .
C CH2-N2   bond_CH2-CH2_=_Ar-N2     CH2 .        .        .   .        DNA/RNA

          CALL LENSTR_BL(LINK,LENL)
          IF(LENS.LE.0.OR.LINKS(1:1).EQ.'.') THEN
            IL = 1
          ELSE
            IL = 0
            IF(LENS.EQ.LENL.AND.LINKS(1:LENS).EQ.LINK(1:LENL)) IL = 1     
          ENDIF
          IF(LINK.EQ.'gap') IL = 0

          IF(IL.GT.0) THEN

            IT = 0
            IF(LMON1.NE.'.'.AND.LMON2.NE.'.') THEN
              IF(MN1.EQ.LMON1.AND.MN2.EQ.LMON2) IT =1
              IF(MN2.EQ.LMON1.AND.MN1.EQ.LMON2) IT =2
            ELSE IF(LMON1.EQ.'.'.AND.LMON2.NE.'.') THEN
              IF(LTYPE1.NE.'.') THEN
                IF(TYPE1.EQ.LTYPE1.AND.MN2.EQ.LMON2) IT =1
                IF(TYPE2.EQ.LTYPE1.AND.MN1.EQ.LMON2) IT =2
              ELSE
                IF(MN2.EQ.LMON2) IT =1
                IF(MN1.EQ.LMON2) IT =2
              ENDIF
            ELSE IF(LMON1.NE.'.'.AND.LMON2.EQ.'.') THEN
              IF(LTYPE2.NE.'.') THEN
                IF(TYPE2.EQ.LTYPE2.AND.MN1.EQ.LMON1) IT =1
                IF(TYPE1.EQ.LTYPE2.AND.MN2.EQ.LMON1) IT =2
              ELSE
                IF(MN1.EQ.LMON1) IT =1
                IF(MN2.EQ.LMON1) IT =2
              ENDIF
            ELSE
              IF(LTYPE1.NE.'.'.AND.LTYPE2.NE.'.') THEN
                IF(TYPE1.EQ.LTYPE1.AND.TYPE2.EQ.LTYPE2) IT =1
                IF(TYPE2.EQ.LTYPE1.AND.TYPE1.EQ.LTYPE2) IT =2
              ELSE IF(LTYPE1.NE.'.') THEN
                IF(TYPE1.EQ.LTYPE1) IT =1
                IF(TYPE2.EQ.LTYPE1) IT =2
              ELSE IF(LTYPE2.NE.'.') THEN
                IF(TYPE2.EQ.LTYPE2) IT =1
                IF(TYPE1.EQ.LTYPE2) IT =2
              ELSE
                IT = 1
              ENDIF
            ENDIF

            IF(IT.GT.0.AND.LLB_NBOND.GT.0.AND.LLL_IBOND(L).GT.0) THEN

              DO IB=LLL_IBOND(L),LLB_NBOND

                IF(LLL_LNAME(L).EQ.LLB_LNAME(IB)) THEN
                  IF(IT.EQ.1) THEN
                    LATOM1 = LLB_1ATM(IB)
                    LATOM2 = LLB_2ATM(IB)
                  ELSE
                    LATOM2 = LLB_1ATM(IB)
                    LATOM1 = LLB_2ATM(IB)
                  ENDIF
                  DIDEAL = LLB_VAL(IB)
                  IF(ATOM1.EQ.LATOM1.AND.ATOM2.EQ.LATOM2) THEN
                    ILINK = L
                    GO TO 100
                  ENDIF
                ENDIF
              ENDDO

            ENDIF
          ENDIF
        ENDDO
        ILINK = 0
 100    CONTINUE
      ENDIF

      RETURN
      END

C ******
      SUBROUTINE CREAT_LINK(MDOC,LINK,INEW,LNEW,ILINK
     *             ,ITYPE1,ITYPE2
     *             ,MON1,ATOM1,MOD1,MON2,ATOM2,MOD2,DIST,IERR)
C -----------------------------------------------
C -P-  - 
C -S-
C -----------------------------------------------
      REAL       DIST
      INTEGER*4  ILINK,MDOC,IERR
      CHARACTER MON1*8,MON2*8,ATOM1*4,ATOM2*4
      CHARACTER MOD1*8,MOD2*8,LINK*8
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER LINE*256,CH1*1,DETAIL*24
C ---
      COMMON/COM_CRT_LINK/ IFIRST_L,JFIRST_L,IFIRST_M,IFIRST_C
C -----------------------------------
      CALL LENSTR_BL(MON1 ,LM1)
      CALL LENSTR_BL(MON2 ,LM2)
      CALL LENSTR_BL(ATOM1,LA1)
      CALL LENSTR_BL(ATOM2,LA2)
      CALL LENSTR_BL(LINK ,LN )

      IF((ITYPE1.EQ.7.OR.ITYPE1.EQ.8).AND.LM1.GT.3) LM1 = 3
      IF((ITYPE2.EQ.7.OR.ITYPE2.EQ.8).AND.LM2.GT.3) LM2 = 3
 
      INEW = 0
      LNEW = 0

c      write(*,*) '--creat_ln:',ln,lm1,lm2,la1,la2
c      write(*,*) '          :'
c     *  ,link,';',mon1,';',mon2,';',atom1,';',atom2,';'

      IF(LN.LE.0.OR.(LINK(1:1).EQ.'.'.AND.LN.EQ.1)) THEN
        LINK = MON1(1:LM1)//'-'//MON2(1:LM2)
        CALL LENSTR_BL(LINK,LN)
c
C        LNEW = 1
c
      ENDIF

      DETAIL='bond_'//MON1(1:LM1)//'-'//ATOM1(1:LA1)//'_=_'//
     *                MON2(1:LM2)//'-'//ATOM2(1:LA2)
      CALL LENSTR_BL(DETAIL,LND)

      N = 0
      IF(LLL_NLINK.GT.0) THEN     
        DO K=1,LLL_NLINK
          CALL LENSTR_BL(LLL_LNAME(K),LNL)
          IF(LINK(1:LN).EQ.LLL_LNAME(K)(1:LN)) THEN
            IF(LNEW.EQ.1) THEN
              ILINK = K
              RETURN              
            ENDIF
            N = N + 1
            CALL LENSTR_BL(LLL_DETAIL(K),LNDL)
            IF(DETAIL(1:LND).EQ.LLL_DETAIL(K)(1:LNDL)) THEN
              ILINK = K
              RETURN   
            ENDIF
          ENDIF
        ENDDO
      ENDIF

      INEW = 1     
      IF(N.GT.0) THEN
        IF(N.GT.9) N = 0
        WRITE(CH1,'(I1)') N
        LINK = LINK(1:LN)//CH1
      ENDIF  

      IF(LLL_NLINK.GE.MAXLLNK) THEN
        IF(IFIRST_L.EQ.0) THEN
          WRITE(LINE,
     *'('' WARNING : Number of links  >'',I6)') MAXLLNK
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Change parameter MAXLLNK in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Now program stops to create new links.'')')
          CALL MSGERR(MDOC,LINE)
          IFIRST_L = 1
        ENDIF 
        ILINK = 0
        RETURN
      ELSE
        IFIRST_L = 0
      ENDIF

      LLL_NLINK = LLL_NLINK+1
      LLL_ILINK = LLL_NLINK
      ILINK     = LLL_NLINK

      CALL LENSTR_BL(LINK,LN)
      LLL_LNAME (ILINK) = LINK(1:LN)
      LLL_CODE1 (ILINK) = 'x'
      LLL_DETAIL(ILINK) = DETAIL
      LLL_MON1  (ILINK) = MON1(1:LM1)
      LLL_MON2  (ILINK) = MON2(1:LM2)
      LLL_MOD1  (ILINK) = MOD1
      LLL_MOD2  (ILINK) = MOD2
      LLL_TYPE1 (ILINK) = '.'
      LLL_TYPE2 (ILINK) = '.'
      LLL_FUSE  (ILINK) = 'C'
      LLL_ICONN (ILINK) = 0
      LLL_IATOM (ILINK) = 0
      LLL_IBOND (ILINK) = 0
      LLL_ITHET (ILINK) = 0
      LLL_IPLAN (ILINK) = 0
      LLL_ICHIR (ILINK) = 0
      LLL_ITORS (ILINK) = 0

      IF((LA1.LE.0.OR.ATOM1(1:1).EQ.'.').OR.
     *   (LA2.LE.0.OR.ATOM2(1:1).EQ.'.')    ) RETURN

      IF(LLB_NBOND.GE.MAXLBND) THEN
        WRITE(LINE,
     *'('' ERROR: number of bonds for the links >'',I6)') MAXLBND
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,
     *'(''        Change parameter MAXLBND in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
        IERR=1
        RETURN
      ENDIF

      LLB_NBOND            = LLB_NBOND+1
      LLL_IBOND(ILINK)     = LLB_NBOND
      LLB_LNAME(LLB_NBOND) = LLL_LNAME (ILINK)
      LLB_1ATM (LLB_NBOND) = ATOM1
      LLB_2ATM (LLB_NBOND) = ATOM2
      LLB_F1ATM(LLB_NBOND) = 1
      LLB_F2ATM(LLB_NBOND) = 2

      LLB_VAL  (LLB_NBOND) = DIST

      LLB_DEV  (LLB_NBOND) = 0.0
      LLB_VOBS (LLB_NBOND) = DIST
      LLB_TYPE (LLB_NBOND) = '.'

      RETURN
      END



C ******
      SUBROUTINE PUT_L_TABL(MDOC,LINK,JCH1,JCH2,JRES1,JRES2
     *                     ,JA1,JA2,IREVERS,IERR)
C -----------------------------------------------
C -P-   
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      INTEGER*4 JCH1,JCH2,JRES1,JRES2,JA1,JA2
      INTEGER*4 ICH1,ICH2,IRES1,IRES2,IA1,IA2
      CHARACTER LINK*8
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER LINE*256,ATOM1*4,ATOM2*4
C ---
      COMMON/COM_CRT_LINK/ IFIRST_L,JFIRST_L,IFIRST_M,IFIRST_C
C -----------------------------------
      IERR=0
      IF(LINK(1:1).EQ.'.'.OR.LINK(1:1).EQ.' ') RETURN

      IF(IREVERS.EQ.0) THEN
        ICH1  = JCH1
        ICH2  = JCH2
        IRES1 = JRES1
        IRES2 = JRES2
        IA1   = JA1
        IA2   = JA2
      ELSE
        ICH1  = JCH2
        ICH2  = JCH1
        IRES1 = JRES2
        IRES2 = JRES1
        IA1   = JA2
        IA2   = JA1
      ENDIF


      IF(LLL_NLINK.GT.0) THEN
        DO L=1,LLL_NLINK
          IF(LLL_LNAME(L).EQ.LINK) THEN
            IF(LLL_FUSE(L).NE.'?'.AND.LLL_FUSE(L).NE.'C') 
     *      LLL_FUSE(L)='Y'
            GO TO 100
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')
     *' WARNING : in "put_l_table", description of link :',LINK
     *       ,' not found in the library'
        CALL MSGDOC(MDOC,LINE)
C ?????
c        CALL MSGDOC(MDOC,'       It will be ignored.)
c        RETURN
 100    CONTINUE
      ENDIF

      IF(LN_N.GT.0) THEN
        IF(IA1.GT.0.AND.IA2.GT.0) THEN
          DO IC=1,LN_N
            IF(LN_ID   (IC).EQ.LINK       .AND.
     *         LN_1IRES(IC).EQ.IRES1      .AND.
     *         LN_2IRES(IC).EQ.IRES2      .AND.
     *         LN_ALT1 (IC).EQ.ID_ALT(IA1).AND.
     *         LN_ALT2 (IC).EQ.ID_ALT(IA2).AND.
     *         LN_1ICHN(IC).EQ.ICH1       .AND.
     *         LN_2ICHN(IC).EQ.ICH2            ) THEN
              RETURN
            ENDIF 
          ENDDO
        ELSE
          DO IC=1,LN_N
            IF(LN_ID   (IC).EQ.LINK       .AND.
     *         LN_1IRES(IC).EQ.IRES1      .AND.
     *         LN_2IRES(IC).EQ.IRES2      .AND.
     *         LN_1ICHN(IC).EQ.ICH1       .AND.
     *         LN_2ICHN(IC).EQ.ICH2            ) THEN
              RETURN
            ENDIF 
          ENDDO
        ENDIF
      ENDIF

      IF(LN_N.GE.MAXLINK) THEN
        IF(JFIRST_L.EQ.0) THEN
          WRITE(LINE,
     *'('' WARNING : Number of links >'',I6)') MAXLINK
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Change parameter MAXLINK in "atom_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Now program stops to use new links.'')')
          CALL MSGERR(MDOC,LINE)
          JFIRST_L = 1
        ENDIF
        RETURN
      ELSE
        JFIRST_L = 0
      ENDIF

      LN_N             = LN_N + 1
      LN_ID   (LN_N)   = LINK
      LN_1IRES(LN_N)   = IRES1
      LN_2IRES(LN_N)   = IRES2
      LN_1RNAM(LN_N)   = RES_NAME(IRES1)
      LN_2RNAM(LN_N)   = RES_NAME(IRES2)
      LN_1ICHN(LN_N)   = ICH1 
      LN_2ICHN(LN_N)   = ICH2     
      LINK_FLAG(IRES1) = 'Y'
      LINK_FLAG(IRES2) = 'Y'
      LN_SEQ1 (LN_N)   = '.'
      LN_SEQ2 (LN_N)   = '.'
      IF(IA1.GT.0) THEN    
        LN_ATOM1(LN_N)   = ATM_NAME(IA1)
        LN_ALT1 (LN_N)   = ID_ALT  (IA1)
      ELSE
        LN_ATOM1(LN_N)   = '.'
        LN_ALT1 (LN_N)   = '.'
      ENDIF
      IF(IA2.GT.0) THEN    
        LN_ATOM2(LN_N)   = ATM_NAME(IA2)
        LN_ALT2 (LN_N)   = ID_ALT  (IA2)
      ELSE
        LN_ATOM2(LN_N)   = '.'
        LN_ALT2 (LN_N)   = '.'
      ENDIF
      LN_SYMM1(LN_N)   = '.'
      LN_SYMM2(LN_N)   = '.'
      LN_DIST (LN_N)   = 0.0

      ATOM1 = LN_ATOM1(LN_N)(1:4)
      ATOM2 = LN_ATOM2(LN_N)(1:4)

      CALL CHECK_LINK_INFO(LINK,LN_1RNAM(LN_N),LN_2RNAM(LN_N)
     *                    ,ATOM1,ATOM2
     *                    ,DIDEAL,ILINK)
      IF(ILINK.GT.0) LN_DIST (LN_N) = DIDEAL
C
C           LN_ENT    E - form ent_poly_seq (not trans 2 , ptrans 36 , p 4)
C                     L - form ent_link
C                     C - from conn
C
      LN_USED (LN_N)   = '.'
      LN_ENT  (LN_N)   = 'C'

      RETURN
      END

C ******
      SUBROUTINE PUT_M_TABL(MDOC,MOD,ICH,IRES,IA,MON,MTYPE,IERR)    
C -----------------------------------------------
C -P-  - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      INTEGER*4 ICH,IRES
      CHARACTER MOD*8,MON*8,MTYPE*1
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER LINE*256
C ---
      COMMON/COM_CRT_LINK/ IFIRST_L,JFIRST_L,IFIRST_M,IFIRST_C
C -----------------------------------
      IERR=0
      IF(MON(1:1).NE.' ') THEN
        GO TO 200
      ENDIF
      IF(MOD(1:1).EQ.'.') THEN
        RETURN
      ENDIF
      IF(LDL_NMOD.GT.0) THEN
        DO L=1,LDL_NMOD
          IF(LDL_MNAME(L).EQ.MOD) THEN
            IF(LDL_FUSE(L).NE.'?'.AND.LDL_FUSE(L).NE.'C') 
     *      LDL_FUSE(L)='Y'
            GO TO 100
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' WARNING : description of modification:',
     *  MOD,     ' not found in the dictionary'
        CALL MSGDOC(MDOC,LINE)
C ?????
c        CALL MSGDOC(MDOC,'       It will be ignored.)
C        RETURN
 100    CONTINUE
      ENDIF

      IF(MOD.NE.'RENAME') MON = '.' 

 200  CONTINUE

      IF(MOD_N.GT.0) THEN
        DO IC=1,MOD_N
          IF(MOD_ID  (IC).EQ.MOD .AND.
     *       MOD_IRES(IC).EQ.IRES.AND.
     *       MOD_ICHN(IC).EQ.ICH      ) THEN
            RETURN
          ENDIF
        ENDDO
      ENDIF

c 200  CONTINUE

      IF(MOD_N.GE.MAXMODIF) THEN
        IF(IFIRST_M.EQ.0) THEN
          WRITE(LINE,
     *'('' WARNING : Number of modifications >'',I6)') MAXMODIF
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Change parameter MAXMODIF in "atom_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
c          WRITE(LINE,
c     *'(''           Now program stops to use new modifications.'')')
c          CALL MSGERR(MDOC,LINE)
          IFIRST_M=1
        ENDIF
        IERR = 1
        RETURN
      ELSE
        IFIRST_M=0
      ENDIF

      MOD_N               = MOD_N + 1
      MOD_ID  (MOD_N)     = MOD
      MOD_IRES(MOD_N)     = IRES
      MOD_RNAM(MOD_N)     = MON

      MOD_RNAM_NEW(MOD_N) = RES_NAME(IRES)

      MOD_ICHN(MOD_N)     = ICH 
      MOD_FLAG(IRES)      = 'Y'
      MOD_SEQ (MOD_N)     = '.'
      MOD_USED(MOD_N)     = MTYPE

      RETURN
      END

C ******
      SUBROUTINE DEF_SPEC_POS(MDOC,CHECK_SPEC,DMIN,IERR)    
C -----------------------------------------------
C -P-   
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      REAL      XC(3),XF(3)
      CHARACTER MON*8,CHECK_SPEC*1
      CHARACTER LINE*256
C -----------------------------------
      IERR  = 0
C ---
      IF(N_GROUP.LE.0.OR.N_ATOM.LE.0) THEN
        CALL MSGERR(MDOC,
     *  'ERROR: in "DEF_SPEC_POS", N_GROUP or N_ATOM = 0')
        IERR=1
        RETURN
      ENDIF

      DMIN2    = DMIN*DMIN

      N_R      = N_RESIDUE

C v-- check spec. position
      IMULT    = 1      
      IF(DMIN.GT.0.0) THEN
        DO    I=1,N_R
          IAS  = IRATM_FIRST   (I)
          IAF  = IRATM_FIRST(I)+NATM_RES(I)-1
          MON  = RES_NAME  (I)
          DO IA=IAS,IAF

            IF(OCCUP(IA).GT.0.0001.AND.ATM_TYPE(IA).NE.'M'.AND.
     *         ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN

              XC(1) = XYZ_CRD(1,IA)
              XC(2) = XYZ_CRD(2,IA)
              XC(3) = XYZ_CRD(3,IA)
              CALL NB_OTOF(XC,XF,IERR)

C              CALL NB_SPEC_POS(XF(1),XF(2),XF(3)
C     *        ,DLIMX,DLIMY,DLIMZ,MULT)

              CALL CHECK_SPEC_POS(XF,DMIN2,MULT)

              IF(MULT.NE.1) THEN

                IF(CHECK_SPEC.EQ.'Y') THEN
                  MULT_FACTOR(IA)  = MULT
                  WRITE(LINE,'(A,A4,A,A1,A,A,A,A,A,A,A)')
     *' WARNING : Atom ',ATM_NAME(IA),' ',ID_ALT(IA),' of residue: ',
     *MON,' Ir:',RES_NUM_PDB(I)(3:7),' ch:',RES_NUM_PDB(I),
     *' in spec. position'
                  CALL MSGDOC(MDOC,LINE)
                  WRITE(LINE,'(A,I3,A)')
     *'           mult=',MULT,';  please, check occupancy.'
                  CALL MSGDOC(MDOC,LINE)
                  IMULT = 0
                ELSE
                  WRITE(LINE,'(A,A4,A,A1,A,A,A,A,A,A,A)')
     *' INFO:     Atom ',ATM_NAME(IA),' ',ID_ALT(IA),' of residue: ',
     *MON,' Ir:',RES_NUM_PDB(I)(3:7),' ch',RES_NUM_PDB(I),
     *' in spec. position'
                  CALL MSGDOC(MDOC,LINE)
                  WRITE(LINE,'(A,I3,A,I3,A)')
     *'           mult=',MULT,', now atom"s mult=',MULT_FACTOR(IA),
     *' program did not change it'
                  CALL MSGDOC(MDOC,LINE)
C                 IMULT = 0

                ENDIF

              ENDIF   
            ENDIF
          ENDDO
        ENDDO
        IF(OUT_CIF_MULT.EQ.1.AND.IMULT.EQ.0) OUT_CIF_MULT = 0 
      ENDIF
C ^--end  check spec. position
      RETURN
      END

      SUBROUTINE CALC_PEP_BOND_ANGLE(MDOC,ANGOBS,IERR)
C -----------------------------------------------
C
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------------------
C      PARAMETER ( NSTOR_PAR = 50 )
C      COMMON /COM_CONN_INF/  N_STOR,IFLAG_STOR,ICONN_ATOM_IND
C     *                      ,X_STOR,Y_STOR,Z_STOR
C     *                      ,ATOM_STOR
C -------------------------------------------------------------------
C      INTEGER    N_STOR,IFLAG_STOR(NSTOR_PAR,2)
C      REAL       X_STOR(NSTOR_PAR,2),Y_STOR(NSTOR_PAR,2)
C     *          ,Z_STOR(NSTOR_PAR,2)
C      CHARACTER  ATOM_STOR(NSTOR_PAR)*4
C ---
C      INTEGER    ICONN_ATOM_IND(2,MAXLLNK)
C -------------------------------------------------------------------
      CHARACTER ATOM*4
C     CHARACTER LINE*256
C -----------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C !!!
      IERR  = 1
C --
      ATOM = 'CA  '
      IR   = 1
      DO I=1,N_STOR
        IF(ATOM.EQ.ATOM_STOR(I).AND.IFLAG_STOR(I,IR).GT.0) THEN
          X1 = X_STOR(I,IR)         
          Y1 = Y_STOR(I,IR)         
          Z1 = Z_STOR(I,IR)         
          GO TO 100
        ENDIF
      ENDDO
      RETURN
 100  CONTINUE
C --
      ATOM = 'C   '
      IR   = 1
      DO I=1,N_STOR
        IF(ATOM.EQ.ATOM_STOR(I).AND.IFLAG_STOR(I,IR).GT.0) THEN
          X2 = X_STOR(I,IR)         
          Y2 = Y_STOR(I,IR)         
          Z2 = Z_STOR(I,IR)         
          GO TO 200
        ENDIF
      ENDDO
      RETURN
 200  CONTINUE
C --
      ATOM = 'N   '
      IR   = 2
      DO I=1,N_STOR
        IF(ATOM.EQ.ATOM_STOR(I).AND.IFLAG_STOR(I,IR).GT.0) THEN
          X3 = X_STOR(I,IR)         
          Y3 = Y_STOR(I,IR)         
          Z3 = Z_STOR(I,IR)         
          GO TO 300
        ENDIF
      ENDDO
      RETURN
 300  CONTINUE
C --
      ATOM = 'CA  '
      IR   = 2
      DO I=1,N_STOR
        IF(ATOM.EQ.ATOM_STOR(I).AND.IFLAG_STOR(I,IR).GT.0) THEN
          X4 = X_STOR(I,IR)         
          Y4 = Y_STOR(I,IR)         
          Z4 = Z_STOR(I,IR)         
          GO TO 400
        ENDIF
      ENDDO
      RETURN
 400  CONTINUE
C ---
      A1 = X2-X1
      B1 = Y2-Y1
      C1 = Z2-Z1

      A2 = X3-X2
      B2 = Y3-Y2
      C2 = Z3-Z2

      A3 = X4-X3
      B3 = Y4-Y3
      C3 = Z4-Z3

      DN1X = B1*C2-B2*C1
      DN1Y = A1*C2-A2*C1
      DN1Z = A1*B2-A2*B1
      DN2X = B2*C3-B3*C2
      DN2Y = A2*C3-A3*C2
      DN2Z = A2*B3-A3*B2
      E1   = DN1X*DN2X+DN1Y*DN2Y+DN1Z*DN2Z
      E2   = SQRT(ABS(DN1X*DN1X+DN1Y*DN1Y+DN1Z*DN1Z))
      E3   = SQRT(ABS(DN2X*DN2X+DN2Y*DN2Y+DN2Z*DN2Z))
      IF(E2.LT.1.E-9.OR.E3.LT.1.E-9) THEN
        IF(E1.GE.0.) COSG =  1.0
        IF(E1.LT.0.) COSG = -1.0
      ELSE
        T    = E2*E3
        IF(ABS(T).GT.1.0E-8) THEN 
          COSG = E1/T
        ELSE
          COSG = 1.0
        ENDIF
      ENDIF
      ABC    = A1*DN2X-A2*(B1*C3-B3*C1)+A3*DN1X
      SS     = ABS(1.0 - COSG*COSG)
      SING   = SIGN(1.0,ABC)*SQRT(SS)
      ANGOBS = ATAN2(SING,COSG)
      IF(ANGOBS.GT.TWOPI) ANGOBS = ANGOBS - TWOPI
      IF(ANGOBS.LT. 0.0 ) ANGOBS = ANGOBS + TWOPI
      ANGOBS = ANGOBS/PI180
C ---
      IERR = 0

      RETURN
      END

C ******
      SUBROUTINE SET_CHAIN(MDOC,SUGAR_FLAG,CHAIN_FLAG,LIST,IERR)    
C -----------------------------------------------
C -P- SET_CHAIN - create new list of chains.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C ******
C     INTEGER*2 ICH
C     REAL      XC(3),XF(3)
C     CHARACTER CH*1,CH2*2,CHAIN*2,CHAIN_FLAG*1

      CHARACTER CHAIN_FLAG*1
      CHARACTER MON*8,MON2*8,MONOLD*8,PNUM*12,CHAR1*1,SUGAR_FLAG*1
      CHARACTER LINE*256
      CHARACTER LINK*8,ATOM1*4,ATOM2*4,CHAR5*5,CHAR8*8,LIST*1
C     EQUIVALENCE (CH2,ICH),(CH2(2:2),CH)
C ---
      COMMON/COM_CRT_LINK/ IFIRST_L,JFIRST_L,IFIRST_M,IFIRST_C
C -----------------------------------
      PI    = 4.0*ATAN(1.0)
C     TWOPI = 2.0*PI
C     PI180 = PI/180.0
      IERR  = 0
C ---
      IF(N_GROUP.LE.0.OR.N_ATOM.LE.0) THEN
        CALL MSGERR(MDOC,
     *  'ERROR: in "SET_CHAIN", N_GROUP or N_ATOM = 0')
        IERR = 1
        RETURN
      ENDIF

      MONOLD   = '?'
      IRES     = 0
      N_GROUP  = 0
      N_R      = N_RESIDUE
      ICH0     = 0
      IFIRST_C = 0

      IF(LN_N.GT.0) THEN
        DO ILN=1,LN_N

c        write(*,*) '==',LN_ID(ILN),';',
c     *   LN_1IRES(ILN),LN_2IRES(ILN),LN_1ICHN(ILN),LN_2ICHN(ILN)
c        write(*,*) '   ',LN_ATOM1(ILN),';',LN_ATOM2(ILN),';'
          
          LINK = LN_ID(ILN) 
             
          IF(LINK(1:1).NE.'.'.AND.LINK(1:1).NE.'?') THEN

            CALL GET_LINK_ATOM(LINK,ATOM1,ATOM2,IT)
            IF(IT.GT.0.AND.
     *         LN_ATOM1(ILN)(1:4).EQ.ATOM2.AND.
     *         LN_ATOM2(ILN)(1:4).EQ.ATOM1     ) THEN

              ITEMP         = LN_1ICHN(ILN)
              LN_1ICHN(ILN) = LN_2ICHN(ILN)
              LN_2ICHN(ILN) = ITEMP
              ITEMP         = LN_1IRES(ILN)
              LN_1IRES(ILN) = LN_2IRES(ILN)
              LN_2IRES(ILN) = ITEMP
              CHAR5         = LN_ATOM1(ILN)
              LN_ATOM1(ILN) = LN_ATOM2(ILN)
              LN_ATOM2(ILN) = CHAR5
              CHAR5         = LN_SEQ1(ILN)
              LN_SEQ1(ILN)  = LN_SEQ2(ILN)
              LN_SEQ2(ILN)  = CHAR5
              CHAR8         = LN_1RNAM(ILN)
              LN_1RNAM(ILN) = LN_2RNAM(ILN)
              LN_2RNAM(ILN) = CHAR8
              CHAR8         = LN_SYMM1(ILN)
              LN_SYMM1(ILN) = LN_SYMM2(ILN)
              LN_SYMM2(ILN) = CHAR8
              CHAR1         = LN_ALT1(ILN)
              LN_ALT1(ILN)  = LN_ALT2(ILN)
              LN_ALT2(ILN)  = CHAR1

            ENDIF
          ENDIF

        ENDDO
      ENDIF

      DO    I=1,N_R
        ITYPE  = ICONN_TYPE(I)
        IF(LN_N.GT.0.AND.I.GT.1) THEN
          I1 = I -1
          IGRP1 = I_CHAIN(I1) 
          IGRP2 = I_CHAIN(I ) 
c          IF(IGRP1.NE.IGRP2) THEN            
          IF(IGRP1.NE.IGRP2.AND.
     *      RES_NUM_PDB(I)(3:7).NE.RES_NUM_PDB(I1)(3:7) ) THEN            
            DO ILN=1,LN_N
              IR1   = LN_1IRES(ILN)
              IR2   = LN_2IRES(ILN) 
              ICH1  = LN_1ICHN(ILN)
              ICH2  = LN_2ICHN(ILN)
              IF(ICH1.EQ.IGRP1.AND.I1.EQ.IR1.AND.
     *           ICH2.EQ.IGRP2.AND.I .EQ.IR2.AND.     
     *           LN_USED(ILN).NE.'S'              ) THEN
                LINK = LN_ID(ILN)
                CALL SET_ICONN(LINK,ICONN)
                IF(ITYPE.LE.1.AND.ICONN.GT.1.AND.
     *                            ICONN.LE.N_CONN_TYPE) THEN

               IF(CR_SEGFLAG.NE.'Y') THEN
                 IF(RES_NUM_PDB(I)(8:8).EQ.
     *             RES_NUM_PDB(I1)(8:8) ) ICONN_TYPE(I) = ICONN
               ELSE
                 IF(RES_NUM_PDB(I)(8:11).EQ.
     *             RES_NUM_PDB(I1)(8:11) ) ICONN_TYPE(I) = ICONN
               ENDIF

                ENDIF
              ENDIF
            ENDDO
          ENDIF
        ENDIF

c        MON    = RES_NAME  (I)
c        write(*,*) '>>',i,mon,itype, ICONN_TYPE(I)

      ENDDO

C ---start cycle by residues
      DO    I=1,N_R

        MON    = RES_NAME  (I)
        ITYPE  = ICONN_TYPE(I)

C      CONN_TYPE( 1) = '.       '
C      CONN_TYPE( 2) = 'TRANS   '
C      CONN_TYPE( 3) = 'CIS     '
C      CONN_TYPE( 4) = 'p       '
C      CONN_TYPE( 5) = 'FOR_C-N '
C      CONN_TYPE( 6) = 'FOR_C-C '
C      CONN_TYPE( 7) = 'ACE_C-N '
C      CONN_TYPE( 8) = 'DFO_C-N '
C      CONN_TYPE( 9) = 'NME_N-C '
C      CONN_TYPE(10) = 'gap     '
C      CONN_TYPE(11) = 'SUGAR   '
C      CONN_TYPE(12) = 'BETA1-2 '
C      CONN_TYPE(13) = 'BETA1-3 '
C      CONN_TYPE(14) = 'BETA1-4 '
C      CONN_TYPE(15) = 'BETA1-6 '
C      CONN_TYPE(16) = 'ALPHA1-2'
C      CONN_TYPE(17) = 'ALPHA1-3'
C      CONN_TYPE(18) = 'ALPHA1-4'
C      CONN_TYPE(19) = 'ALPHA1-6'
C      CONN_TYPE(20) = 'IVA_C-N '
C      CONN_TYPE(21) = 'DFO-NME '
C      CONN_TYPE(22) = 'BOC_C-N '
C      CONN_TYPE(23) = 'DFO_N-C '
C      CONN_TYPE(24) = 'STA-NME '
C      CONN_TYPE(25) = 'STA_C-N '
C      CONN_TYPE(26) = 'STA_N-C '
C      CONN_TYPE(27) = 'STA_DFO '
C      CONN_TYPE(28) = 'DFO_STA '
C      CONN_TYPE(29) = 'STA_STA '
C      CONN_TYPE(30) = 'DFO_DFO '
C      CONN_TYPE(31) = 'ILG_CD-N'
C      CONN_TYPE(32) = 'ILG_CD-p'
C      CONN_TYPE(33) = 'LINK_C-N'
C      CONN_TYPE(34) = 'LINK_CNp'
C      CONN_TYPE(35) = 'LINK_CpN'
C      CONN_TYPE(36) = 'PTRANS'
C      CONN_TYPE(37) = 'PCIS'
C
        IRTYPE = IRES_TYPE (I)

c      DATA RES_TYPE /
c     1  '.               ',
c     2  'non-polymer     ',
c     3  'L-peptide       ',
c     4  'D-peptide       ',
c     5  'DNA             ',
c     6  'RNA             ',
c     7  'D-saccharide    ',
c     8  'L-saccharide    ',
c     9  'solvent         ',
c     *  'polymer         ' /
c      DATA CH_TYPE / 
c     1 '.       ',
c     2 'monomer ',
c     3 'polypept',
c     4 'polypept',
c     5 'DNA     ',
c     6 'RNA     ',
c     7 'sacchari',
c     8 'sacchari',
c     9 'solvent ',
c     * 'polypept' /

        IAS    = IRATM_FIRST   (I)
        IAF    = IRATM_FIRST(I)+NATM_RES(I)-1

        IF(I.EQ.1) THEN
C         first residue - start chain
          IF(IRTYPE.EQ.7.OR.IRTYPE.EQ.8) THEN
            IRES_BACK(I) = -1   
            IRES_FORW(I) =  0   
          ENDIF
          ICH_FLAG = 0
        ELSE IF(MON.EQ.MONOLD.AND.(MON.EQ.'HOH'.OR.MON.EQ.'DUM')) THEN
C         water chain
          ICH_FLAG = 1
          I1       = I - 1

          IF(CR_SEGFLAG.NE.'Y') THEN
            IF(RES_NUM_PDB(I)(8:9).NE.
     *         RES_NUM_PDB(I1)(8:9)) ICH_FLAG = 0
          ELSE
            IF(RES_NUM_PDB(I)(8:11).NE.
     *         RES_NUM_PDB(I1)(8:11)) ICH_FLAG = 0
          ENDIF

        ELSE IF(ITYPE .GT.1.AND.ITYPE .LE.N_CONN_TYPE.AND.
     *          IRTYPE.NE.7.AND.IRTYPE.NE.8.AND.
     *          IRTYPE.NE.1.AND.IRTYPE.NE.2               ) THEN
C         chain continue
          ICH_FLAG = 1
          IRTYPE1 = IRES_TYPE(I-1)
          IF(IRTYPE.EQ.3.OR.IRTYPE.EQ.4) THEN
            IF(IRTYPE1.NE.3.AND.IRTYPE1.NE.4.AND.IRTYPE1.NE.10) 
     *      ICH_FLAG = 0
          ENDIF

        ELSE
C         new chain
          ICH_FLAG = 0

          IF(IRTYPE.EQ.7.OR.IRTYPE.EQ.8) THEN
            IRES_BACK(I) = -1   
            IRES_FORW(I) =  0   
          ENDIF

          I1 = I - 1
          IRTYPE1 = IRES_TYPE(I1)

          IF((IRTYPE .EQ.7.OR.IRTYPE .EQ.8).AND.
     *       (IRTYPE1.EQ.7.OR.IRTYPE1.EQ.8)     ) THEN
C           saccharide
C           IRES_BACK(N_RESIDUE  ) = N_RESIDUE-1 
C           IRES_FORW(N_RESIDUE-1) = N_RESIDUE 
         
            DO I1=ICH0,I-1
              IF(RES_NUM_PDB(I)(3:7).NE.RES_NUM_PDB(I1)(3:7)) THEN            

              IF(LN_N.GT.0) THEN
                DO ICN=1,LN_N
                  LINK = LN_ID(ICN)
                  CALL SET_ICONN(LINK,ICONN)
                  IF(ICONN.GT.1.AND.ICONN.LE.N_CONN_TYPE.AND.
     *              LN_USED(ICN).NE.'S'              ) THEN

                    IF(LN_1IRES(ICN).EQ.I1.AND.LN_2IRES(ICN).EQ.I) THEN
C                   chain continue  i1-->i
                      IRES_BACK(I)  = I1   
                      IF(IRES_FORW(I1).LE.0) IRES_FORW(I1) = I   
                      ICH_FLAG      = 1
                      GO TO 300   
                    ELSE IF(LN_2IRES(ICN).EQ.I1.AND.LN_1IRES(ICN).EQ.I)
     *              THEN
C                   chain continue  i1<--i
                      IRES_BACK(I1) = I   
                      IRES_FORW(I)  = I1   
                      ICH_FLAG      = 1
                      GO TO 300   
                    ENDIF

                  ENDIF
                ENDDO
              ENDIF

              ENDIF
            ENDDO
          ENDIF

         
        ENDIF
 
 300    CONTINUE

        IF(ICH_FLAG.EQ.0) THEN
C         start of new chain 
          ICH0 = I
          IF(N_GROUP.GE.MAXCHAIN) THEN
            IF(IFIRST_C.EQ.0) THEN
              WRITE(LINE,
     *'('' WARNING : Number of chains >'',I6)') MAXCHAIN
              CALL MSGERR(MDOC,LINE)
              WRITE(LINE,
     *'(''           Change parameter MAXCHAIN in "atom_com.fh"'')')
              CALL MSGERR(MDOC,LINE)

              IERR = 1
              RETURN

C              WRITE(LINE,
C     *'(''           Now program stops to create new chains !!!'')')
C              CALL MSGERR(MDOC,LINE)
C              IFIRST_C=1

            ENDIF
            GO TO 100
          ELSE
            IFIRST_C=0
          ENDIF

          N_GROUP                 = N_GROUP +1
          IRES_FIRST   (N_GROUP)  = I

          ITERM_S_TYPE (N_GROUP)  = 1
          ITERM_F_TYPE (N_GROUP)  = 1

          NRES_CHAIN   (N_GROUP)  = 0
          NATM_CHAIN   (N_GROUP)  = 0

          PNUM = RES_NUM_PDB(I)

          RES_NUM_PDB(I) = PNUM

          CHAIN_ID   (N_GROUP)  = RES_NUM_PDB(I)(8:11)

          N_GROUP               = N_GROUP 
          ICHAIN_GRP (N_GROUP)  = N_GROUP
          GROUP_ID   (N_GROUP)  = RES_NUM_PDB(I)(8:11)  
          IATOM_FIRST(N_GROUP)  = IAS
          NCS_FLAG   (N_GROUP)  = '.'
          I_NCS      (N_GROUP)  = 0
          MULT_FLAG  (N_GROUP)  = 0

          IF(IRTYPE.EQ.7.OR.IRTYPE.EQ.8) THEN
            IRES_START_TREE(N_GROUP) = I 
          ENDIF

        ENDIF
 100    CONTINUE

        IF(IRTYPE.NE.7.AND.IRTYPE.NE.8) THEN
          IRES_FORW(I) = 0 
          IF(NRES_CHAIN(N_GROUP).EQ.0) THEN
            IRES_BACK(I)     = -1   
            IRES_START_TREE(N_GROUP) = I 
          ELSE
            IRES_BACK(I)   = I-1 
            IRES_FORW(I-1) = I 
          ENDIF
          IRES_END_TREE(N_GROUP) = I 
        ELSE 
          IRES_END_TREE(N_GROUP) = I 
        ENDIF

        NRES_CHAIN (N_GROUP)  = NRES_CHAIN(N_GROUP)  + 1
        NATM_CHAIN (N_GROUP)  = NATM_CHAIN(N_GROUP)  + NATM_RES(I)

        I_CHAIN    (I)        = N_GROUP

        RES_NUM_PDB(I)(1:2)   = GROUP_ID(N_GROUP)(1:2)
        RES_NUM_PDB(I)(8:11)  = GROUP_ID(N_GROUP)


        IF(NRES_CHAIN(N_GROUP).LE.1) THEN
          ICH_TYPE(N_GROUP) = 2
        ELSE
          ICH_TYPE(N_GROUP) = 10
          IF(IRTYPE.EQ.3.OR.IRTYPE.EQ.4.OR.IRTYPE.EQ.10) THEN
            ICH_TYPE(N_GROUP) = 3
          ELSE IF(IRTYPE.EQ.5.OR.IRTYPE.EQ.6) THEN
            ICH_TYPE(N_GROUP) = 5
          ELSE IF(IRTYPE.EQ.7.OR.IRTYPE.EQ.8) THEN
            ICH_TYPE(N_GROUP) = 7
          ENDIF
        ENDIF
        IF(MON.EQ.'HOH'.OR.MON.EQ.'DUM') THEN
          ICH_TYPE(N_GROUP) = 9
        ENDIF

        MONOLD = MON

      ENDDO
C ---end cycle by residues

      IF(LN_N.GT.0) THEN
        DO I=1,LN_N
          IR1         = LN_1IRES(I)
          IR2         = LN_2IRES(I) 
          LN_1ICHN(I) = I_CHAIN(IR1)
          LN_2ICHN(I) = I_CHAIN(IR2)
        ENDDO
      ENDIF

      IF(MOD_N.GT.0) THEN
        DO I=1,MOD_N
          IR          = MOD_IRES(I)
          MOD_ICHN(I) = I_CHAIN(IR) 
        ENDDO
      ENDIF
C -----
      DO IG=1,N_GROUP

        NR  = NRES_CHAIN  (IG)
        IRS = IRES_FIRST  (IG)
        IRF = IRS+NR-1         

        DO IR=IRS,IRF
          
          ITYPE = IRES_TYPE(IR)
          MON   = RES_NAME (IR)

          IF(MOD_N.GT.0) THEN
            DO IM = 1,MOD_N
              IF(MOD_IRES   (IM).EQ.IR  .AND.
     *          MOD_ICHN    (IM).EQ.IG  .AND.
     *          MOD_RNAM    (IM).NE.'.' .AND.
     *          MOD_RNAM_NEW(IM).EQ.MON      ) THEN
                MON      = MOD_RNAM(IM)
                GO TO 700
              ENDIF
            ENDDO
          ENDIF
 700      CONTINUE


          IF(ITYPE.EQ.7.OR.ITYPE.EQ.8) THEN
C           --- sugar
            IF(LN_N.GT.0) THEN
              DO IL=1,LN_N
                LINK = LN_ID(IL)

c            write(*,*) il,link,ig,ir,LN_ATOM1(IL),LN_ATOM2(IL)
c     *      ,LN_1ICHN(IL),LN_2ICHN(IL)
c     *      ,LN_1IRES(IL),LN_2Ires(IL)

                IF(((LN_ATOM1(IL).EQ.'C1  '.AND.
     *               LN_1ICHN(IL).EQ.IG    .AND.
     *               LN_1IRES(IL).EQ.IR         ).OR.
     *              (LN_ATOM2(IL).EQ.'C1  '.AND.
     *               LN_2ICHN(IL).EQ.IG    .AND.
     *               LN_2IRES(IL).EQ.IR         )    ).AND. 
     *             LN_USED(ILN).NE.'S'                   ) THEN
                  ICHANGE = 0
                  IF(LINK(1:5).EQ.'ALPHA') THEN
                    IF(MON(5:5).EQ.'b') THEN
                      MON2      = MON
                      MON2(5:5) = 'a'
                      CALL LOOK_MON_LIB2(MDOC,MON2,LIST,IERR)
                      IF(IERR.EQ.0) THEN
                        MON(5:5)     = 'a'
C                        RES_NAME(IR) = MON
                        ICHANGE      = 1
                      ELSE
                        IERR = 0
                      ENDIF
                    ELSE IF(MON(5:5).NE.'a') THEN

                    ENDIF
                  ELSE IF(LINK(1:4).EQ.'BETA') THEN
                    IF(MON(5:5).EQ.'a') THEN
                      MON2      = MON
                      MON2(5:5) = 'b'
                      CALL LOOK_MON_LIB2(MDOC,MON2,LIST,IERR)
                      IF(IERR.EQ.0) THEN
                        MON(5:5)     = 'b'
C                       RES_NAME(IR) = MON
                        ICHANGE      = 1
                      ELSE
                        IERR = 0
                      ENDIF
                    ELSE IF(MON(5:5).NE.'b') THEN

                    ENDIF
                  ENDIF

                  IF(MOD_N.GT.0.AND.ICHANGE.EQ.1) THEN
                    DO IM=1,MOD_N
                      IGM             = MOD_ICHN(IM)
                      IRM             = MOD_IRES(IM)
                      IF(IG.EQ.IGM.AND.IR.EQ.IRM) THEN
                        IF(SUGAR_FLAG.NE.'D'.AND.
     *                                    MOD_USED(IM).EQ.'U') THEN
        LINE = ' WARNING:  sugar type is different with actual:'//MON
                          CALL MSGDOC(MDOC,LINE)                    
                          WRITE(LINE,'(3A,A5,2A)')
     *'           ch:',GROUP_ID(IG),' res:',RES_NUM_PDB(IR)(3:7),
     *' ',MOD_RNAM(IM)
                          CALL MSGDOC(MDOC,LINE)                    
        LINE =        '           residue name will not be changed' 
                          CALL MSGDOC(MDOC,LINE)                    
                        ELSE
C                         MOD_RNAM_NEW(IM) = RES_NAME(IR)
                          MOD_RNAM(IM) = MON
                        ENDIF
                      ENDIF
                    ENDDO
                  ENDIF

                ENDIF
              ENDDO
            ENDIF
C           --- sugar
          ENDIF

        ENDDO
      ENDDO

      IF(LN_N.GT.0) THEN
        DO I=1,LN_N
          IR1         = LN_1IRES(I)
          IR2         = LN_2IRES(I) 
          LN_1RNAM(I) = RES_NAME(IR1)
          LN_2RNAM(I) = RES_NAME(IR2)
        ENDDO
      ENDIF

c      IF(MOD_N.GT.0) THEN
c        DO I=1,MOD_N
c          IR              = MOD_IRES(I)
cC         MOD_RNAM_NEW(I) = RES_NAME(IR)
c          MOD_RNAM(I) = RES_NAME(IR)
c        ENDDO
c      ENDIF

      CALL SUGAR_NET(MDOC,IERR)    

      CALL CHECK_RESIDUE_NUM(MDOC,IERR)

      IF(CR_SEGFLAG.NE.'Y') THEN
        CALL CHECK_CHAIN_ID_CIF(MDOC,INEW,IERR)
      ELSE
        CALL CHECK_CHAIN_ID_SEG(MDOC,INEW,IERR)
      ENDIF

      IF(INEW.GT.0) THEN
        CALL MSGDOC(MDOC,
     *' WARNING: Chain_list is not correct. Program has changed it.')
        CALL MSGDOC(MDOC,
     *'          Different chains have the same chain id.')
      ENDIF

      RETURN
      END

      SUBROUTINE LOOK_MON_LIB2(MDOC,MON,LIST,IERR)
C -----------------------------------------
C -P- CHKMON - looks for monomer's name in the library list
C              , set use_flag = "Y".
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER AMON*8,MON2*8,MOD_R*1,NODIST*1,LIST*1
C     CHARACTER LINE*256
C --------------------------------
      IERR = 0

      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of monomer in the library = 0')
        IERR = 2
        RETURN
      ENDIF

      DO L=1,LML_NMON
        IF(MON.EQ.LML_MNAME(L)) THEN
          GO TO 100
        ENDIF
      ENDDO

      IF(LMS_NSYN.GT.0) THEN
        DO LL=1,LMS_NSYN
          IF(LMS_AMNAME(LL).EQ.MON) THEN
            MON  = LMS_MNAME(LL)
            DO L=1,LML_NMON
              IF(MON.EQ.LML_MNAME(L)) THEN
                GO TO 100
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

      IF(LDR_NDER.GT.0) THEN
        DO LL=1,LDR_NDER
          IF(LDR_MNAME(LL).EQ.MON) THEN
            AMON = LDR_SMNAME(LL)
            DO L=1,LML_NMON
              IF(AMON.EQ.LML_MNAME(L)) THEN
               MON = AMON 
               GO TO 100
              ENDIF
            ENDDO
            MON2 = AMON
            DO LLL=1,LDR_NDER
              IF(LDR_MNAME(LLL).EQ.MON2) THEN
                AMON = LDR_SMNAME(LLL)
                DO L=1,LML_NMON
                  IF(AMON.EQ.LML_MNAME(L)) THEN
                    MON = AMON 
                    GO TO 100
                  ENDIF
                ENDDO
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

C     monomer is not found.
      IERR=1
      RETURN

  100 CONTINUE

C -----
      IF(LML_FUSE(L).EQ.'N') THEN
C       read mon_lib.cif
        LML_FUSE(L) = 'R'
        MOD_R       = 'M'
        NODIST      = 'N'
        CALL READ_LIB(MDOC,MOD_R,NODIST,LIST,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
C ----
      RETURN
      END     

      SUBROUTINE CHECK_RESIDUE_NUM(MDOC,IERR)
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ---
C     CHARACTER LINE*256
C -----------------------------------
      IERR = 0
      IF(N_GROUP.LE.0.OR.N_ATOM.LE.0) THEN
        CALL MSGERR(MDOC,
     *  'ERROR: in "CHECK_RESIDUE_NUM", N_GROUP or N_ATOM = 0')
        IERR=1
        RETURN
      ENDIF
     
      DO IG=1,N_GROUP
        NR    = NRES_CHAIN  (IG)
        IF(NR.GT.1) THEN
          IRS   = IRES_FIRST  (IG)
          IRF   = IRS+NR-1         
          IRES0 = IRES_SERIAL(IRS) 
          DO IR=IRS+1,IRF
            DO JR=IRS,IR-1 
              IF(IRES_SERIAL(IR).EQ.IRES_SERIAL(JR)) THEN
                II = -1
                DO KR=IRS,IRF
                  II = II + 1
                  IRES_SERIAL(KR) = IRES0 + II
                ENDDO
                OUT_CIF_INS = 0
                GO TO 100
              ENDIF
            ENDDO
          ENDDO
        ENDIF
 100    CONTINUE
      ENDDO

      RETURN
      END

      SUBROUTINE SUGAR_NET(MDOC,IERR)    
C -----------------------------------------------
C -P- 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
C     CHARACTER LINE*256
C -----------------------------------
      IERR = 0
      IF(N_GROUP.LE.0.OR.N_ATOM.LE.0) THEN
        CALL MSGERR(MDOC,
     *  'ERROR: in "SUGAR_NET", N_GROUP or N_ATOM = 0')
        IERR=1
        RETURN
      ENDIF
     
c      DO IG=1,N_GROUP
c        IF(ICH_TYPE(IG).EQ.7) THEN
c          WRITE(*,*) '--S,F:', IRES_START_TREE(IG),IRES_END_TREE(IG)
c          NR  = NRES_CHAIN  (IG)
c          IRS = IRES_FIRST  (IG)
c          IRF = IRS+NR-1         
c          DO IR=IRS,IRF
c       WRITE(*,*) ' --tree>:',IR,IRES_BACK(IR),IRES_forw(IR)
c     *  ,ICONN_TYPE(IR)
c          ENDDO
c        ENDIF
c      ENDDO

      DO IG=1,N_GROUP
        IF(ICH_TYPE(IG).EQ.7) THEN
          NR  = NRES_CHAIN  (IG)
          IRS = IRES_FIRST  (IG)
          IRF = IRS+NR-1         
          IF(NR.EQ.1) THEN
            IRES_START_TREE(IG) = IRS 
            IRES_BACK(IRS)      =-1 
            IRES_FORW(IRS)      = 0 
            IRES_END_TREE(IG)   = IRS 
            GO TO 100
          ENDIF
          NBACK = 0
          DO IR=IRS,IRF
            IF(IRES_BACK(IR).LE.0) THEN
              IRES_START_TREE(IG) = IR 
              NBACK = NBACK + 1
            ENDIF
          ENDDO
          IF(NBACK.EQ.0) THEN
            IRES_START_TREE(IG) = IRS 
            IB                  = IRES_BACK(IRS)     
            IRES_BACK(IRS)      =-1 
            IRES_FORW(IB)       = 0 
          ELSE IF(NBACK.GT.1) THEN
            IRES_START_TREE(IG) = IRS 
            IRES_END_TREE(IG)   = IRF 
            DO IR=IRS,IRF
              IRES_BACK(IR)     = IR-1 
              IRES_FORW(IR)     = IR+1 
            ENDDO
            IRES_BACK(IRS)      =-1 
            IRES_FORW(IRF)      = 0 
            GO TO 100
          ENDIF
          NFORW = 0
          DO IR=IRS,IRF
            IF(IRES_FORW(IR).LE.0) NFORW = NFORW + 1
          ENDDO
          IRST = IRES_START_TREE(IG)  
          IF(NFORW.LE.0.OR.IRES_FORW(IRST).LE.0) THEN
            IRES_START_TREE(IG) = IRS 
            IRES_END_TREE(IG)   = IRF 
            DO IR=IRS,IRF
              IRES_BACK(IR)     = IR-1 
              IRES_FORW(IR)     = IR+1 
            ENDDO
            IRES_BACK(IRS)      =-1 
            IRES_FORW(IRF)      = 0 
            GO TO 100
          ENDIF
C ----
C         search first forw = 0          
          I =  IRES_START_TREE(IG)
 200      CONTINUE
          IFR = IRES_FORW(I)         
          IF(IFR.LE.0) THEN
            IEND = I
          ELSE
            I = IFR
            GO TO 200
          ENDIF            
C ----
          IRES_END_TREE(IG)   = IEND 

          IF(NFORW.GT.1) THEN
C         other branchs
            DO IR=IRS,IRF
              IF(IRES_FORW(IR).LE.0.AND.IR.NE.IEND) THEN         
                J    = IR
                JEND = J
 300            CONTINUE

                IB  = IRES_BACK(J)         
                IFR = IRES_FORW(IB)         
                IF(J.NE.IFR) THEN
                  IRES_FORW(IEND) = J                  
                  IEND = JEND 
                ELSE
                  J = IB
                  GO TO 300
                ENDIF
 
              ENDIF
            ENDDO

            IRES_END_TREE(IG)   = JEND 

          ENDIF          

 100      CONTINUE

          DO IR=IRS,IRF
            ICONN_TYPE(IR) = 1
            IRB = IRES_BACK(IR)
            IF(LN_N.GT.0.AND.IRB.GT.0) THEN
              DO ICN=1,LN_N
              IF(LN_USED(ICN).NE.'S') THEN
              IF((LN_1IRES(ICN).EQ.IRB.AND.LN_2IRES(ICN).EQ.IR).OR.
     *           (LN_2IRES(ICN).EQ.IRB.AND.LN_1IRES(ICN).EQ.IR)  ) THEN
                CALL SET_ICONN(LN_ID(ICN),ICONN)
                ICONN_TYPE(IR) = ICONN
                GO TO 400
              ENDIF
              ENDIF
              ENDDO
            ENDIF
 400        CONTINUE
          ENDDO

        ENDIF
      ENDDO

c      DO IG=1,N_GROUP
c        IF(ICH_TYPE(IG).EQ.7) THEN
c          WRITE(*,*) 'S,F:', IRES_START_TREE(IG),IRES_END_TREE(IG)
c          NR  = NRES_CHAIN  (IG)
c          IRS = IRES_FIRST  (IG)
c          IRF = IRS+NR-1         
c          DO IR=IRS,IRF
c          WRITE(*,*) ' tree>:',IR,IRES_BACK(IR),IRES_forw(IR)
c     *    ,ICONN_TYPE(IR)
c          ENDDO
c        ENDIF
c      ENDDO

      RETURN
      END

C ******
      SUBROUTINE SET_MOD(MDOC,IERR)    
C -----------------------------------------------
C -P- SET_MOD - set type of terminus residues.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER LINE*256,GROUP*4,MON*8,LINK*8
C     CHARACTER ATOM*4,CHAIN*4
C -----------------------------------
      IERR = 0
      IF(N_GROUP.LE.0.OR.N_ATOM.LE.0) THEN
        CALL MSGERR(MDOC,
     *  'ERROR: in "SET_MOD", N_GROUP or N_ATOM = 0')
        IERR=1
        RETURN
      ENDIF

      DO IG=1,N_GROUP

        GROUP = GROUP_ID    (IG)
        IC    = ICHAIN_GRP  (IG)
        IGA   = IATOM_FIRST (IG)
        NR    = NRES_CHAIN  (IG)
        IRS   = IRES_FIRST  (IG)
        NAC   = NATM_CHAIN  (IG)
C       CHAIN = CHAIN_ID    (IG)

        IAF    = IGA - 1
        IRF    = IRS+NR-1         
        ICYCLE = 0

        IRS    = IRES_START_TREE(IG)
        IRF    = IRES_END_TREE  (IG)

C -- tree --
        IR = IRS
C ----------        
 800    CONTINUE  
C       DO IR=IRS,IRF
C -- tree --
          
          IAS = IAF + 1
          IAF = IAS + NATM_RES(IR) - 1

          ITYPE = IRES_TYPE(IR)
          MON   = RES_NAME (IR)

          IOXT  = 0
          IPATM = 0
          IPTER = 0
          DO IA=IAS,IAF
            IF(ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN
              IF(IR.EQ.IRF.AND.ATM_NAME(IA).EQ.'OXT ') IOXT  = 1 
              IF(IR.EQ.IRS.AND.ATM_NAME(IA).EQ.'P   ') IPATM = 1 
              IF(IR.EQ.IRF.AND.ATM_NAME(IA).EQ.'PT  ') IPTER = 1 
            ENDIF
          ENDDO

          ICL = 0

          IF(IR.EQ.IRS) THEN
            IF(LN_N.GT.0) THEN
              DO IL=1,LN_N
                IF(LN_USED(IL).NE.'S') THEN
                IF(LN_2ICHN(IL).EQ.IC) THEN
                  IF(LN_2IRES(IL).EQ.IR)THEN
                    LINK = LN_ID(IL)
                    CALL SET_ICONN(LINK,ICONN)    
                    IF((ITYPE.EQ.3.OR.ITYPE.EQ.4).AND.
     *                 (ICONN.EQ. 2.OR.ICONN.EQ. 3.OR.
     *                  ICONN.EQ.38.OR.ICONN.EQ.39.OR.
     *                  ICONN.EQ.36.OR.ICONN.EQ.37)) ICL = 1
                    IF((ITYPE.EQ.5.OR.ITYPE.EQ.6).AND.
     *                 (ICONN.EQ.4              )) ICL = 1
                    IF(ICL.EQ.1) THEN
                      ICYCLE = ICYCLE + 1
                      GO TO 100
                    ENDIF
                  ENDIF
                ENDIF
                ENDIF
              ENDDO
            ENDIF
            IF(ITYPE.EQ.3.OR.ITYPE.EQ.4) THEN
              ITERM_S_TYPE (IG) = 1  
              IF(MON(1:3).NE.'ILG') THEN
                ITERM_S_TYPE (IG) = 2  
              ENDIF
            ELSE IF(ITYPE.EQ.10.AND.MON.EQ.'FOR') THEN
              ITERM_S_TYPE(IG) = 3  
            ELSE IF(ITYPE.EQ.10.AND.MON.EQ.'BAL') THEN
              ITERM_S_TYPE(IG) = 2  
            ELSE IF(ITYPE.EQ.5.OR.ITYPE.EQ.6) THEN
              ITERM_S_TYPE(IG) = 5  
              IF(IPATM.EQ.1) ITERM_S_TYPE(IG) = 4  
            ENDIF
          ENDIF           

 100      CONTINUE
          ICL = 0
          IF(IR.EQ.IRF) THEN
            IF(LN_N.GT.0) THEN
              DO IL=1,LN_N
                IF(LN_USED(IL).NE.'S') THEN
                IF(LN_1ICHN(IL).EQ.IC) THEN
                  IF(LN_1IRES(IL).EQ.IR)THEN
                    LINK=LN_ID(IL)
                    CALL SET_ICONN(LINK,ICONN)    
                    IF((ITYPE.EQ.3.OR.ITYPE.EQ.4).AND.
     *                 (ICONN.EQ. 2.OR.ICONN.EQ. 3.OR.
     *                  ICONN.EQ.38.OR.ICONN.EQ.39.OR.
     *                  ICONN.EQ.36.OR.ICONN.EQ.37)) ICL = 1
                    IF((ITYPE.EQ.5.OR.ITYPE.EQ.6).AND.
     *                 (ICONN.EQ.4              )) ICL=1
                    IF(ICL.EQ.1) THEN
                      ICYCLE = ICYCLE+1
                      GO TO 200
                    ENDIF
                  ENDIF
                ENDIF
                ENDIF
              ENDDO
            ENDIF

            IF(ITYPE.EQ.3.OR.ITYPE.EQ.4) THEN

              ITERM_F_TYPE (IG) = 1  

              IF(MON(1:3).NE.'BLE'.AND.MON(1:3).NE.'B1F'.AND.
     *           MON(1:3).NE.'B2F'.AND.MON(1:3).NE.'B2A'.AND.
     *           MON(1:3).NE.'B2I'.AND.MON(1:3).NE.'B2V'.AND.   
     *           MON(1:3).NE.'BLY'.AND.MON(1:3).NE.'ILG'     ) THEN
                IF(IOXT.EQ.1) ITERM_F_TYPE (IG) = 2  
              ENDIF

            ELSE IF(ITYPE.EQ.10.AND.MON.EQ.'FOR') THEN
              ITERM_F_TYPE(IG) = 3  
            ELSE IF(ITYPE.EQ.10.AND.MON.EQ.'BAL') THEN
              IF(IOXT.EQ.1) ITERM_F_TYPE(IG) = 2  
            ELSE IF(ITYPE.EQ.10.AND.
     *              (MON.EQ.'DFO'.OR.MON.EQ.'STA')) THEN
              ITERM_F_TYPE(IG) = 8  
            ELSE IF(ITYPE.EQ.5.OR.ITYPE.EQ.6) THEN
              ITERM_F_TYPE (IG) = 5  
              IF(IPTER.EQ.1) ITERM_S_TYPE (IG) = 4  
            ENDIF            
          ENDIF

 200      CONTINUE

C --- tree --
C       ENDDO
        IF(IR.NE.IRF) THEN
          IR = IRES_FORW(IR)
          IF(IR.LE.0) THEN
            CALL MSGERR(MDOC,' ERROR: wrong tree structure .....')
            IERR = 1
            RETURN
          ENDIF
          GO TO 800
        ENDIF
C --- tree --

        IF(ICYCLE.GE.2) THEN
          GROUP = GROUP_ID(IG)
          WRITE(LINE,
     *    '('' WARNING : chain '',A,'' is cyclic ?'')') GROUP
          CALL MSGDOC(MDOC,LINE)
        ENDIF

      ENDDO

      RETURN
      END

C -------------------------

      SUBROUTINE DEF_CENTER(MDOC,IERR)
C --------------------------------------------
      INCLUDE 'atom_com.fh'
C ----------------------------------------------------------------
c      COMMON /RESID_INF_2/ CENTER_RES,RADIUS_RES,IFLAG_RES
c      REAL                 CENTER_RES(3,MAXRESID  )
c      REAL                 RADIUS_RES(MAXRESID  )
c      INTEGER              IFLAG_RES (MAXRESID  )
C -----------------------------------
      INCLUDE 'link_com.fh'
C ----------------------------------------------------------------
      REAL      X(3),C(3)
      CHARACTER ASYMB*4,ATYPE*1
C     CHARACTER ANAME*4,ALT*1,CORR*1
C     CHARACTER LINE*256
C --------------------------
      IF(N_ATOM.LE.0.OR.N_GROUP.LE.0) THEN
        IERR=1
        RETURN
      ENDIF 

      DO IG=1,N_GROUP   

        IAR       = IATOM_FIRST(IG)
        IRP       = I_RESID    (IAR)
        ICH       = I_CHAIN    (IRP)
        IRS       = IRES_FIRST (ICH)
        NRES      = NRES_CHAIN (ICH)

        DO IR=IRS,IRS+NRES-1

          NATMR     = NATM_RES    (IR)
          IAS       = IRATM_FIRST (IR)

          IF(NATMR.LE.1) THEN

            CENTER_RES(1,IR)    = XYZ_CRD  (1,IAS) 
            CENTER_RES(2,IR)    = XYZ_CRD  (2,IAS)  
            CENTER_RES(3,IR)    = XYZ_CRD  (3,IAS)   
            RADIUS_RES(IR)      = 0.0
            IFLAG_RES (IR)      = 0
            NA                  = NATMR

          ELSE

            XMAX =-1.E 30
            YMAX =-1.E 30
            ZMAX =-1.E 30
            XMIN = 1.E 30
            YMIN = 1.E 30
            ZMIN = 1.E 30

            NA = 0
            DO IA=IAS,IAS+NATMR-1
C
              IATOM     = IA
C
C             ANAME     = ATM_NAME (IA)     
              INSF      = ID_SF    (IA)  
              ASYMB     = CS_ATYPE (INSF)      
              ATYPE     = ATM_TYPE (IA)    
C             ALT       = ID_ALT   (IA)    
C             CORR      = ID_CORR  (IA)    
              X(1)      = XYZ_CRD  (1,IA) 
              X(2)      = XYZ_CRD  (2,IA)  
              X(3)      = XYZ_CRD  (3,IA)   
C             BISO      = B_ISO    (IA)  
c             BISO      = U_ANISO  (1,IA)  
              OCC       = OCCUP    (IA)
              IF(OCC.LE.0.0                              ) GO TO 110
              IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') GO TO 110
              IF(ATYPE.EQ.'N'.OR.ATYPE.EQ.'D'.OR.
     *           ATYPE.EQ.'M'.OR.ATYPE.EQ.'U'            ) GO TO 110

                IF(X(1).GT.XMAX) XMAX = X(1)
                IF(X(2).GT.YMAX) YMAX = X(2)
                IF(X(3).GT.ZMAX) ZMAX = X(3)
                IF(X(1).LT.XMIN) XMIN = X(1)
                IF(X(2).LT.YMIN) YMIN = X(2)
                IF(X(3).LT.ZMIN) ZMIN = X(3)
                NA=NA+1
 110          CONTINUE
            ENDDO
            IF(NA.GT.0) THEN
              C(1)    = (XMAX+XMIN)/2.0  
              C(2)    = (YMAX+YMIN)/2.0
              C(3)    = (ZMAX+ZMIN)/2.0
            ELSE
              C(1) = 0.0
              C(2) = 0.0
              C(3) = 0.0
            ENDIF

            NA  = 0
            RAD = 0.0
            DO IA=IAS,IAS+NATMR-1
C
              IATOM     = IA
C
C             ANAME     = ATM_NAME (IA)     
              INSF      = ID_SF    (IA)  
              ASYMB     = CS_ATYPE (INSF)      
              ATYPE     = ATM_TYPE (IA)    
C             ALT       = ID_ALT   (IA)    
C             CORR      = ID_CORR  (IA)    
              X(1)      = XYZ_CRD  (1,IA) 
              X(2)      = XYZ_CRD  (2,IA)  
              X(3)      = XYZ_CRD  (3,IA)   
C             BISO      = B_ISO    (IA)  
c             BISO      = U_ANISO  (1,IA)  
              OCC       = OCCUP    (IA)
              IF(OCC.LE.0.0                              ) GO TO 120
              IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') GO TO 120
              IF(ATYPE.EQ.'N'.OR.ATYPE.EQ.'D'.OR.
     *           ATYPE.EQ.'M'.OR.ATYPE.EQ.'U'            ) GO TO 120

                T1 = X(1)-C(1)
                T2 = X(2)-C(2)
                T3 = X(3)-C(3)
                R  = SQRT(T1*T1+T2*T2+T3*T3)
                IF(R.GT.RAD) RAD = R
                NA = NA + 1
 120          CONTINUE

            ENDDO

            CENTER_RES(1,IR)    = C(1)
            CENTER_RES(2,IR)    = C(2)
            CENTER_RES(3,IR)    = C(3)
            RADIUS_RES(IR)      = RAD
            IFLAG_RES (IR)      = 0
            IF(NA.LE.0)  RADIUS_RES(IR) = -1.0

          ENDIF


          IFLAG_RES (IR)      = 0
          IF(NCONN_PDB.GT.0) THEN
            DO IA=IAS,IAS+NATMR-1
              IATOM = IA
              DO ICN=1,NCONN_PDB
                IF(ICON1_PDB(ICN).EQ.IATOM.OR.
     *             ICON2_PDB(ICN).EQ.IATOM  ) THEN
                  IFLAG_RES(IR) = -1
                  GO TO 130
                ENDIF
              ENDDO
            ENDDO 
          ENDIF
 130      CONTINUE

        ENDDO
 100    CONTINUE

      ENDDO
      RETURN
      END

      SUBROUTINE CHECK_CENTR(IR1,IR2,DLIM,IOUT)
C --------------------------------------------
      INCLUDE 'atom_com.fh'
C --------------------------------------------
c      COMMON /RESID_INF_2/CENTER_RES,RADIUS_RES,IFLAG_RES
c      REAL                CENTER_RES(3,MAXRESID  )
c      REAL                RADIUS_RES(MAXRESID  )
c      INTEGER             IFLAG_RES (MAXRESID  )
C ---
      REAL      X1,X2,Y1,Y2,Z1,Z2,R1,R2
C ----------------------------------------------------
      IF(IFLAG_RES(IR1).LT.0.OR.IFLAG_RES(IR2).LT.0) THEN
        IOUT = -1
        RETURN
      ENDIF

      IF(RADIUS_RES(IR1).LT.0.0.OR.RADIUS_RES(IR2).LT.0.0) THEN  
        IOUT =  3
        RETURN
      ELSE IF(RADIUS_RES(IR1).LE.0.0.OR.
     *        RADIUS_RES(IR2).LE.0.0    ) THEN  
        IOUT =  2
        RETURN
      ENDIF

      X1 = CENTER_RES(1,IR1)  
      Y1 = CENTER_RES(2,IR1)   
      Z1 = CENTER_RES(3,IR1)  
      R1 = RADIUS_RES(IR1)     
      X2 = CENTER_RES(1,IR2)  
      Y2 = CENTER_RES(2,IR2)   
      Z2 = CENTER_RES(3,IR2)  
      R2 = RADIUS_RES(IR2)     
      D  = R1 + R2 + DLIM + .00001
      D2 = D*D
C ---
      IOUT  = 0
      DIST2 = (X1-X2)*(X1-X2)+(Y1-Y2)*(Y1-Y2)+(Z1-Z2)*(Z1-Z2)
      IF(DIST2.LE.D2) IOUT = 1

      RETURN
      END



      SUBROUTINE REPLACE_SYNONYM(IG,IR)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER MONN*8,MON*8
C -----------------------------------
      IF(LMS_NSYN.LE.0.OR.N_GROUP.LE.0.OR.IG.LE.0.OR.IR.LE.0) RETURN

C     DO IGG=IG,N_GROUP
      DO IGG=IG,IG

        NRR  = NRES_CHAIN  (IGG)
        IRRS = IRES_FIRST  (IGG)
        IRRF = IRRS+NRR-1        

C       DO IRR=IRRS,IRRF
        DO IRR=IR,IR

          IAAS = IRATM_FIRST(IRR)
          NAA  = NATM_RES   (IRR)     
          IAAF = IAAS+NAA-1
          MONN = RES_NAME   (IRR)
          MON  = ' '

          DO LL=1,LMS_NSYN
            IF(LMS_AMNAME(LL).EQ.MONN) THEN
              MON = LMS_MNAME(LL)
              GO TO 100
            ENDIF
          ENDDO

 100      CONTINUE

          DO IAA=IAAS,IAAF
            DO LL=1,LMS_NSYN
              IF(LMS_MNAME(LL).EQ.MONN.OR.
     *           LMS_MNAME(LL).EQ.MON     ) THEN
                IF(ATM_NAME(IAA).EQ.LMS_AATOM(LL)) THEN
                  ATM_NAME(IAA) = LMS_ATOM(LL)
                  GO TO 200
                ENDIF
              ENDIF
            ENDDO
 200        CONTINUE
          ENDDO

        ENDDO

      ENDDO

      RETURN
      END

      SUBROUTINE GET_ALT_FOR_COPY(MDOC,IAS,IAF,ALT_FOR_COPY,IERR)
C -----------------------------------
      INTEGER   MDOC,IERR,IAS,IAF
      CHARACTER ALT_FOR_COPY*1 
C --
      INCLUDE 'atom_com.fh'
C --
C -----------------------------------------------------------
      INTEGER N_ALT,I_ALT(20)
C ---
      CHARACTER LINE*256,ALT(20)*1
C -----------------------------------
      ALT_FOR_COPY = '.'
      N_ALT        = 0

      DO IA=IAS,IAF

        IF(ATM_TYPE(IA).EQ.'U'.OR.ATM_TYPE(IA).EQ.'D'.OR.
     *                            ATM_TYPE(IA).EQ.'N') GO TO 100
        IF(OCCUP(IA).LT.0.0001.OR.ID_ALT(IA).EQ.'.' ) GO TO 100

        IF(N_ALT.GT.0) THEN
          DO I=1,N_ALT
            IF(ID_ALT(IA).EQ.ALT(I)) THEN
              I_ALT(I) = I_ALT(I) + 1 
              GO TO 100
            ENDIF
          ENDDO
        ENDIF

        IF(N_ALT.LT.20) THEN
          N_ALT = N_ALT + 1
          ALT(N_ALT)   = ID_ALT(IA)
          I_ALT(N_ALT) = 1
        ENDIF
 100    CONTINUE

      ENDDO
C --  
      IF(N_ALT.GT.0) THEN
        N = 0
        DO I=1,N_ALT
          IF(N.LT.I_ALT(I)) THEN
            N = I_ALT(I) 
            ALT_FOR_COPY = ALT(I)
          ENDIF
        ENDDO
      ENDIF
C --
      RETURN
      END

      SUBROUTINE PRE_MONOM(MDOC,IG,IR,IAS,IAF,IERR)    
C -----------------------------------------------
C -P- PRE_MONOM - reads current monomer and copy into C1_... array
C -S-             one copy for alternative position
C -----------------------------------------------
      INTEGER*4 MDOC,IG,IR,IAS,IAF,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
C -----------------------------------------------------------
C ---
      CHARACTER LINE*256,ALT_FOR_COPY*1
C -----------------------------------
      PI       = 4.0*ATAN(1.0)
      CONST    = 8.0*PI*PI

      C1_NATOM = 0

      CALL GET_ALT_FOR_COPY(MDOC,IAS,IAF,ALT_FOR_COPY,IERR)

      DO IA=IAS,IAF

        IF(ATM_TYPE(IA).EQ.'U'.OR.ATM_TYPE(IA).EQ.'D'.OR.
     *                            ATM_TYPE(IA).EQ.'N') GO TO 200

        IF(C1_NATOM.GT.0) THEN
          DO   I=1,C1_NATOM
            IF(ATM_NAME(IA).EQ.C1_ANAME(I)) THEN
              IF( ID_ALT(IA).EQ.'.'.OR.
     *           (ID_ALT(IA).EQ.ALT_FOR_COPY.AND.C1_ALT(I).NE.'.')) THEN
                GO TO 100
              ENDIF
              GO TO 200
            ENDIF
          ENDDO
        ENDIF
        IF(C1_NATOM.GE.MX1ATOM) THEN
          WRITE(LINE
     * ,'('' ERROR: number of atoms of monomer '',A7,'' >'',I6)') 
     *    RES_NUM_PDB(IR),MX1ATOM
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     * ,'         Change parameter MX1ATOM in "lib_com.fh"')
          IERR=2
          RETURN
        ENDIF
        C1_NATOM           = C1_NATOM + 1
 100    CONTINUE
        IATM             = C1_NATOM
        C1_NALT (IATM)   = 1
        C1_IALT (IATM)   = 0
        C1_ANAME(IATM)   = ATM_NAME(IA)
        C1_ANAME_INP(IATM)= ATM_NAME_INP(IA)
        C1_ICH           = IG  
        C1_IRES          = IR 
        S1_ICRD (IATM)   = IA
        DO   I=1,3
          C1_XYZ(I,IATM) = XYZ_CRD(I,IA)
C         C1_CSD(I,IATM) = SD_CRD (I,IA)
        ENDDO
        DO   I=1,6
          C1_ANIS(I,IATM) = 0.0
C         C1_ASD (I,IATM) = 0.0
        ENDDO
        C1_OCC   (IATM) = OCCUP   (IA)
C       C1_BSD   (IATM) = 0.0
C       C1_OSD   (IATM) = 0.0
        C1_USER  (IATM) = MULT_FACTOR(IA)+0.001

        S1_CHAR(IATM)   = 0.0 
        S1_CHEM(IATM)   = ATM_CHEM(IA) 

        INSF            = ID_SF   (IA)
        C1_ASYMB (IATM) = CS_ATYPE(INSF)
        C1_SF_ID (IATM) = INSF

        C1_ATYPE (IATM) = 'M'
        C1_ALT   (IATM) = ID_ALT  (IA)
        C1_CORR  (IATM) = ID_CORR (IA)

        C1_BTYPE (IATM) = 'I'
        IF(B_FLAG(IA).GT.0) THEN
          C1_BTYPE(IATM) = 'A'
          DO   I=1,6
            C1_ANIS(I,IATM) = U_ANISO(I,IA)
          ENDDO
          CALL CALC_B_EQUIV(U_ANISO(1,IA),BISO)
          C1_BISO  (IATM) = BISO
        ELSE
          C1_ANIS(1,IATM) = U_ANISO(1,IA)
          C1_BISO(IATM)   = U_ANISO(1,IA)/CONST
        ENDIF

        C1_RNAME        = RES_NAME(IR)
        C1_CODE1        = '.'
        C1_PNUM         = RES_NUM_PDB(IR)
        IRT             = IRES_TYPE  (IR)
        C1_RTYPE        = RES_TYPE   (IRT)
        C1_FSC   (IATM) = 'N'
        C1_FSA   (IATM) = 'N'
        C1_FUS   (IATM) = 'N'

 200    CONTINUE
      ENDDO

      IF(C1_NATOM.LE.0) THEN
        WRITE(LINE
     * ,'('' ERROR: number of atoms of monomer (c1_natom)=0'')') 
        CALL MSGERR(MDOC,LINE)
        IERR=2
        RETURN
      ENDIF

      RETURN
      END

      SUBROUTINE COPY_C1_L1(MDOC,MONOMER_NEW,IERR)
C -----------------------------------------------
C     define before L1L_TYPE,L1L_PRSNT
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ---
C -----------------------------------------------
      CHARACTER ASYMB*4,MONOMER_NEW*8
C -----------------------------------------------
        NANH = 0
        NA   = 0
c --
        L1L_MNAME = MONOMER_NEW
        L1L_MNAME2= MONOMER_NEW
        L1L_NAME  = '.'
        L1L_CODE1 = 'x'
C        L1L_TYPE  = 'non-polymer'  
C        L1L_TYPE  = C1_RTYPE 
        L1L_MODE  = '.'
        L1L_FORM  = '.'
        L1L_FUSE  = '?'
        L1L_HFLAG = '.'
C        L1L_NATM  = C1_NATOM
C        L1L_NHATM = 0
C        L1A_NATOM = C1_NATOM
C        L1A_NHATOM= 0
        L1N_NCONN = 0
        L1B_NBOND = 0
        L1G_NANGL = 0
        L1T_NTORS = 0
        L1C_NCHIR = 0
        L1P_NPLAN = 0
        DO I=1,C1_NATOM
          IF(NA.GT.0) THEN
            DO J=1,NA
              IF(C1_ANAME(I).EQ.L1A_ANAME(J)) GO TO 100
            ENDDO
          ENDIF
          NA = NA + 1
          L1A_COOR_FLAG(I) = 'Y'
          IF(C1_OCC(I).LT.0.0001) L1A_COOR_FLAG(NA) = 'N'
          L1A_X    (NA) = C1_XYZ(1,I)
          L1A_Y    (NA) = C1_XYZ(2,I)
          L1A_Z    (NA) = C1_XYZ(3,I)
          L1A_CHARG(NA) = S1_CHAR(I) 
          L1A_INEW (NA) = I
          L1A_IOLD (NA) = I
          L1A_ICR  (NA) = 0
          L1A_NDIST(NA) = 0
          L1A_IBACK(NA) = 0
          L1A_IFORW(NA) = 0
          L1A_BACK (NA) = '.'
          L1A_TYPE (NA) = '.' 
          L1A_FORW (NA) = '.'
          L1A_ANAME(NA) = C1_ANAME(I)
          L1A_CHEM (NA) = S1_CHEM (I)
          L1A_SYMB (NA) = C1_ASYMB(I) 

          ASYMB = L1A_SYMB(NA)
          IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ') THEN
            NANH = NANH + 1 
          ENDIF

          NA = NA + 1
          ASYMB = CS_ATYPE(C1_SF_ID(I))
          CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
          L1A_SF_ID(NA) = INSF
C          L1A_CHEM (NA) = L1A_SYMB(NA) 
          L1A_ATYPE(NA) = C1_ATYPE(I)
          DO  J=1,MAX1BRN 
            L1A_CONN   (J,NA) = 0
            L1A_LENCON (J,NA) = 0
          ENDDO
          DO  J=1,MAX1EXT 
            L1A_IEXTR (J,NA)  = 0
          ENDDO
 100      CONTINUE
        ENDDO

        L1L_NATM   = NA
        L1L_NHATM  = NANH
        L1A_NATOM  = NA
        L1A_NHATOM = NANH

      RETURN
      END

      SUBROUTINE CREAT_MOD(MDOC,MOD,MON,FUNC,NAMEM,ATOM_M,ATOM_U
     * ,IATOM_M,IATOM_U,IMOD,CHEMM,CHEMU,IERR)
C -----------------------------------------------
C -P-  - 
C -S-
C -----------------------------------------------
C     REAL       DIST
      INTEGER*4 IMOD,MDOC,IERR
      CHARACTER MON*8,ATOM_M*4,ATOM_U*4,CHEMM*4,CHEMU*4,FUNC*3
      CHARACTER MOD*8,NAMEM*(*),ATOM*4,DEF_FLAG*1
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C     INCLUDE 'ener_com.fh'
C ******
      CHARACTER LINE*256,DETAIL*48,CHEM1*4,CHEM2*4
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4,LB*3
C ---
      COMMON/COM_CRT_MOD/ IFIRST_D
C -----------------------------------
      M  =-ABS(MDOC)-1
      NA = 0
      NB = 0
      NG = 0
      NT = 0
      NP = 0
      CALL LENSTR_BL(NAMEM,LEN)
      IF(LEN.GT.48) LEN=48
      DETAIL = NAMEM(1:LEN)


      WRITE(LINE,'(''           create modification: '',A)') 
     * MOD
      CALL MSGDOC(M,LINE)
      WRITE(LINE,'(''           detail: '',A)') 
     * DETAIL(1:LEN)
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.GT.78) LEN=78
      CALL MSGDOC(M,LINE(1:LEN))

      IF(LDL_NMOD.GE.MAXDMDF) THEN
        IF(IFIRST_D.EQ.0) THEN
          WRITE(LINE,
     *'('' WARNING : Number of modifications >'',I6)') MAXDMDF
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Change parameter MAXDMDF in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,'(A)')
     *'           Now program stops to create new modifications.'
          CALL MSGERR(MDOC,LINE)
          IFIRST_D=1
        ENDIF 
        IERR=1
        RETURN
      ELSE
        IFIRST_D=0
      ENDIF
      LDL_NMOD = LDL_NMOD+1
      LDL_IMOD = LDL_NMOD
      IMOD     = LDL_NMOD
      CALL LENSTR_BL(NAMEM,LEN)
      IF(LEN.GT.48) LEN=48
      DETAIL = NAMEM(1:LEN)
      CALL LENSTR_BL(MOD,LEN)
      LDL_MNAME (IMOD) = MOD(1:LEN)
      LDL_COMP  (IMOD) = '.'
      CALL LENSTR_BL(DETAIL,LEN)
      LDL_DETAIL(IMOD) = DETAIL(1:LEN)
C//'<-- do not change that'
      LDL_ORDER  (IMOD) = 0
      LDL_TYPE   (IMOD) = '.'
      LDL_FUSE   (IMOD) = 'C'
      LDL_ICONN  (IMOD) = 0
      LDL_IATOM  (IMOD) = 0
      LDL_IBOND  (IMOD) = 0
      LDL_ITHET  (IMOD) = 0
      LDL_IPLAN  (IMOD) = 0
      LDL_ICHIR  (IMOD) = 0
      LDL_ITORS  (IMOD) = 0

      LB = 'MOD'
      NA = LDA_NATOM
      CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP,IERR)
      IF(IERR.NE.0) RETURN

      LDA_NATOM            = LDA_NATOM + 1
      LDL_IATOM(IMOD)      = LDA_NATOM
      LDA_MNAME(LDA_NATOM) = LDL_MNAME (IMOD)
      LDA_BACK (LDA_NATOM) = '.'
      LDA_FORW (LDA_NATOM) = '.'
      LDA_CHARG(LDA_NATOM) = 0.0


      IF(FUNC.EQ.'REP') THEN
        LDA_FUNCT(LDA_NATOM) = 'change'
        LDA_ANAME(LDA_NATOM) = ATOM_M
        LDA_ANEW (LDA_NATOM) = ATOM_U
        LDA_SYMB (LDA_NATOM) = CHEMU
        LDA_CHEM (LDA_NATOM) = CHEMU
      ELSE IF(FUNC.EQ.'ADD') THEN
        LDA_FUNCT(LDA_NATOM) = 'add'
        LDA_ANAME(LDA_NATOM) = '.'
        LDA_ANEW (LDA_NATOM) = ATOM_U
        LDA_SYMB (LDA_NATOM) = CHEMU
        LDA_CHEM (LDA_NATOM) = CHEMU
      ELSE IF(FUNC.EQ.'DEL') THEN
        LDA_FUNCT(LDA_NATOM) = 'delete'
        LDA_ANAME(LDA_NATOM) = ATOM_M
        LDA_ANEW (LDA_NATOM) = '.'
        LDA_SYMB (LDA_NATOM) = '.'
        LDA_CHEM (LDA_NATOM) = '.'
      ENDIF


      IF(FUNC.EQ.'REP') THEN
        IF(L1B_NBOND.GT.0) THEN
          DO I=1,L1B_NBOND
            J = 0
            IF(L1B_1ATM (I).EQ.ATOM_M) THEN
              I1 = IATOM_M  
              J = 1
            ELSE IF(L1B_2ATM (I).EQ.ATOM_M) THEN
              J  = 2
              I2 = IATOM_U
            ENDIF
            IF(J.NE.0) THEN

              IF(J.EQ.1) THEN
                L1B_1ATM (I) = ATOM_U
                ATOM         = L1B_2ATM (I)
              ELSE
                L1B_2ATM (I) = ATOM_U
                ATOM         = L1B_1ATM (I)
              ENDIF
              IF(L1A_NATOM.GT.0) THEN
                DO L=1,L1A_NATOM
                  IF(L1A_ANAME(L).EQ.ATOM) THEN
                    IF(L1A_SYMB(L)(1:2).EQ.'H '.OR.
     *                 L1A_SYMB(L)(1:2).EQ.'D ') THEN
                      LB = 'MOD'
                      NA = LDA_NATOM
                      CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP
     *                ,IERR)
                      IF(IERR.NE.0) RETURN
                      LDA_NATOM            = LDA_NATOM + 1
                      LDA_MNAME(LDA_NATOM) = LDL_MNAME (IMOD)
                      LDA_FUNCT(LDA_NATOM) = 'delete'
                      LDA_ANAME(LDA_NATOM) = L1A_ANAME(L)
                      LDA_ANEW (LDA_NATOM) = '.'
                      LDA_SYMB (LDA_NATOM) = '.'
                      LDA_CHEM (LDA_NATOM) = '.'
                      LDA_BACK (LDA_NATOM) = '.'
                      LDA_FORW (LDA_NATOM) = '.'
                      LDA_CHARG(LDA_NATOM) = 0.0
                      GO TO 100
                    ELSE
                      IF(J.EQ.1) CHEM2 = L1A_CHEM(L)
                      IF(J.EQ.2) CHEM1 = L1A_CHEM(L)
                      GO TO 200
                    ENDIF
                  ENDIF
                ENDDO
              ENDIF
              GO TO 100
 200          CONTINUE


              LB = 'MOD'
              NB = LDB_NBOND
              CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP
     *                ,IERR)
              IF(IERR.NE.0) RETURN
              LDB_NBOND = LDB_NBOND + 1
              IF(LDL_IBOND(IMOD).EQ.0) LDL_IBOND(IMOD) = LDB_NBOND


              LDB_FUNCT(LDB_NBOND)   = 'change'
              LDB_MNAME(LDB_NBOND)   = LDL_MNAME (IMOD)
              IF(J.EQ.1) THEN
                LDB_1ATM (LDB_NBOND) = ATOM_U
                LDB_2ATM (LDB_NBOND) = ATOM
                CHEM1                = CHEMU
              ELSE
                LDB_2ATM (LDB_NBOND) = ATOM_U
                LDB_1ATM (LDB_NBOND) = ATOM
                CHEM2                = CHEMU
              ENDIF

C              WRITE(*,*) j,';',CHEM1,';',CHEM2,';'

              CALL GET_DEFAULT_VBOND(M,CHEM1,CHEM2
     *            ,VAL,DEF_FLAG,IERR)
              IF(IERR.NE.0) RETURN

              IF(DEF_FLAG.EQ.'Y') THEN
                WRITE(LINE,
     *'(''           '',A3,'' : default bond legnth will used '')')
     *  MON
                CALL MSGDOC(M,LINE)
                WRITE(LINE,'(A,A4,A,A4,A,F8.3,A,A4,A,A4,A)')
     *  '           chem_type: ',CHEM1,'-',CHEM2,' ',L1B_VAL(L),
     *  ' (',L1A_ANAME(I1),'-',L1A_ANAME(I2),')' 
                CALL MSGDOC(M,LINE)
              ENDIF

              L1B_DEV (I) = 0.02
              IF(VAL.GT.0.0) L1B_VAL(I)=VAL

              LDB_TYPE (LDB_NBOND) = '.'
              LDB_VAL  (LDB_NBOND) = L1B_VAL(I)
              LDB_DEV  (LDB_NBOND) = L1B_DEV(I)
 100          CONTINUE

            ENDIF
          ENDDO
        ENDIF

        IF(L1G_NANGL.GT.0) THEN
          DO I=1,L1G_NANGL
            J = 0
            IF(L1G_1ATM (I).EQ.ATOM_M) THEN
              L1G_1ATM (I) = ATOM_U
              J            = 1
              ATOM2        = L1G_2ATM (I)
              ATOM3        = L1G_3ATM (I)
            ELSE IF(L1G_2ATM (I).EQ.ATOM_M) THEN
              L1G_2ATM (I) = ATOM_U
              J            = 2
              ATOM1        = L1G_1ATM (I)
              ATOM3        = L1G_3ATM (I)
            ELSE IF(L1G_3ATM (I).EQ.ATOM_M) THEN
              L1G_3ATM (I) = ATOM_U
              J            = 3
              ATOM1        = L1G_1ATM (I)
              ATOM2        = L1G_2ATM (I)
            ENDIF
            IF(L1A_NATOM.GT.0) THEN
              DO L=1,L1A_NATOM
                IF(L1A_ANAME(L).EQ.ATOM1) THEN
                  IF(L1A_SYMB(L)(1:2).EQ.'H '.OR.
     *               L1A_SYMB(L)(1:2).EQ.'D ') THEN
                    J = 0
                  ENDIF  
                ENDIF  
                IF(L1A_ANAME(L).EQ.ATOM2) THEN
                  IF(L1A_SYMB(L)(1:2).EQ.'H '.OR.
     *               L1A_SYMB(L)(1:2).EQ.'D ') THEN
                    J = 0
                  ENDIF  
                ENDIF  
                IF(L1A_ANAME(L).EQ.ATOM3) THEN
                  IF(L1A_SYMB(L)(1:2).EQ.'H '.OR.
     *               L1A_SYMB(L)(1:2).EQ.'D ') THEN
                    J = 0
                  ENDIF  
                ENDIF  
              ENDDO  
            ENDIF  
            IF(J.NE.0) THEN

              LB = 'MOD'
              NG = LDG_NANGL
              CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP
     *                ,IERR)
              IF(IERR.NE.0) RETURN
              LDG_NANGL = LDG_NANGL + 1
              IF(LDL_ITHET(IMOD).EQ.0) LDL_ITHET(IMOD) = LDG_NANGL

              LDG_FUNCT(LDG_NANGL)   = 'change'
              LDG_MNAME(LDG_NANGL)   = LDL_MNAME (IMOD)
              IF(J.EQ.1) THEN
                LDG_1ATM (LDG_NANGL) = ATOM_U
                LDG_2ATM (LDG_NANGL) = ATOM2
                LDG_3ATM (LDG_NANGL) = ATOM3
              ELSE IF(J.EQ.2) THEN
                LDG_2ATM (LDG_NANGL) = ATOM_U
                LDG_1ATM (LDG_NANGL) = ATOM1
                LDG_3ATM (LDG_NANGL) = ATOM3
              ELSE
                LDG_3ATM (LDG_NANGL) = ATOM_U
                LDG_1ATM (LDG_NANGL) = ATOM1
                LDG_2ATM (LDG_NANGL) = ATOM2
              ENDIF
              LDG_VAL  (LDG_NANGL) = L1G_VAL(I)
              LDG_DEV  (LDG_NANGL) = L1G_DEV(I)

            ENDIF
          ENDDO
        ENDIF
      ELSE IF(FUNC.EQ.'ADD') THEN

        DO IAC=1,C1_NATOM
          IF(C1_ANAME(IAC).EQ.ATOM_U) THEN

c            WRITE(*,*) IAC,S1_NDIST(IAC)

            IF(S1_NDIST(IAC).LE.0) RETURN
            IF(S1_NDIST(IAC).GT.0) THEN
              DO JAC=S1_NDIST(IAC),1,-1
                IF(S1_CONN(JAC,IAC).GT.0) THEN
                  IA    = S1_CONN(JAC,IAC)
                  ATOM  = C1_ANAME(IA)
                  CHEM2 = S1_CHEM (IA)
                  IF(C1_ASYMB(IA)(1:2).NE.'H '.AND.
     *               C1_ASYMB(IA)(1:2).NE.'D ') THEN
                  
C ////


        LB = 'MOD'
        NB = LDB_NBOND
        CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP
     *                ,IERR)
        IF(IERR.NE.0) RETURN
        LDB_NBOND = LDB_NBOND+1
        IF(LDL_IBOND(IMOD).EQ.0) LDL_IBOND(IMOD) = LDB_NBOND


        LDB_FUNCT(LDB_NBOND)   = 'add'
        LDB_MNAME(LDB_NBOND)   = LDL_MNAME (IMOD)
        LDB_1ATM (LDB_NBOND)   = ATOM_U
        LDB_2ATM (LDB_NBOND)   = ATOM
        CHEM1                  = CHEMU

        VAL = 0.0
        DO K=1,LEB_NBOND
           IF((LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K).EQ.CHEM2).OR.
     *        (LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K).EQ.CHEM1))
     *     THEN
             VAL = LEB_LENGTH(K) 
             GO TO 400
           ENDIF
        ENDDO
        D1 = 0.0
        D2 = 0.0
        DO K=1,LEB_NBOND
          IF(LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K)(1:1).EQ.'.')
     *          D1=LEB_LENGTH(K)
          IF(LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K)(1:1).EQ.'.')
     *    D2 = LEB_LENGTH(K)

        ENDDO
        IF(D1.GT.0.0.AND.D2.GT.0.0) THEN
          DA  = (D1+D2)/2.0
          VAL = DA  
        ENDIF
        IF(VAL.LE.0.0) VAL = 1.5

        WRITE(LINE,
     *  '('' WARNING : '',A3,'' : default bond legnth will used '')')
     *  MON
        CALL MSGDOC(M,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,F8.3,A,A4,A,A4,A)')
     *  '           chem_type: ',CHEM1,'-',CHEM2,' ',VAL,' (',ATOM_U,
     *'-',ATOM,')'
                CALL MSGDOC(M,LINE)


 400    CONTINUE
        DEV = 0.02

        LDB_TYPE (LDB_NBOND) = '.'
        LDB_VAL  (LDB_NBOND) = VAL
        LDB_DEV  (LDB_NBOND) = DEV
C ///


                  ENDIF
                ENDIF
              ENDDO
            ENDIF
          ENDIF
        ENDDO



      ELSE IF(FUNC.EQ.'DEL') THEN

      ENDIF

      RETURN
      END

      SUBROUTINE CREAT_MOD_NADD(MDOC,MOD,MON,IMOD,NAMEM
     * ,NATM,ATOM_UM,CHEMUM,IERR)
C -----------------------------------------------
C -P-  - 
C -S-
C -----------------------------------------------
      INTEGER*4  IMOD,MDOC,IERR
      CHARACTER  MON*8,ATOM_UM(9)*4,CHEMUM(9)*4
C     CHARACTER  FUNC*3
      CHARACTER  MOD*8,NAMEM*(*),ATOM_U*4,CHEMU*4
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C     INCLUDE 'ener_com.fh'
C ******
      CHARACTER LINE*256,DETAIL*48,LB*3,CHEM1*4,CHEM2*4
      CHARACTER ATOM1*4,ATOM2*4,ATOM*4,CHEM*4
C ---
      COMMON/COM_CRT_MOD/ IFIRST_D
C -----------------------------------
      IERR = 0
      IF(NATM.LE.0.OR.NATM.GE.10) RETURN

      NA = 0
      NB = 0
      NG = 0
      NT = 0
      NP = 0

      CALL LENSTR_BL(NAMEM,LEN)
      IF(LEN.GT.48) LEN=48
      DETAIL = NAMEM(1:LEN)

      WRITE(LINE,'(''           create modification: '',A)') 
     * MOD
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           detail: '',A)') 
     * DETAIL(1:LEN)
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.GT.78) LEN=78
      CALL MSGDOC(MDOC,LINE(1:LEN))

      IF(LDL_NMOD.GE.MAXDMDF) THEN
        IF(IFIRST_D.EQ.0) THEN
          WRITE(LINE,
     *'('' WARNING : Number of modifications >'',I6)') MAXDMDF
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Change parameter MAXDMDF in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,'(A)')
     *'           Now program stops to create new modifications.'
          CALL MSGERR(MDOC,LINE)
          IFIRST_D = 1
        ENDIF 
        IERR=1
        RETURN
      ELSE
        IFIRST_D = 0
      ENDIF

      LDL_NMOD = LDL_NMOD+1
      LDL_IMOD = LDL_NMOD
      IMOD     = LDL_NMOD
      CALL LENSTR_BL(NAMEM,LEN)
      IF(LEN.GT.48) LEN=48
      DETAIL = NAMEM(1:LEN)
      CALL LENSTR_BL(MOD,LEN)
      LDL_MNAME (IMOD) = MOD(1:LEN)
      LDL_COMP  (IMOD) = '.'
      CALL LENSTR_BL(DETAIL,LEN)
      LDL_DETAIL(IMOD) = DETAIL(1:LEN)
C//'<-- do not change that'
      LDL_ORDER  (IMOD) = 0
      LDL_TYPE   (IMOD) = '.'
      LDL_FUSE   (IMOD) = 'C'
      LDL_ICONN  (IMOD) = 0
      LDL_IATOM  (IMOD) = 0
      LDL_IBOND  (IMOD) = 0
      LDL_ITHET  (IMOD) = 0
      LDL_IPLAN  (IMOD) = 0
      LDL_ICHIR  (IMOD) = 0
      LDL_ITORS  (IMOD) = 0

      LDL_IATOM(IMOD)  = LDA_NATOM + 1
      DO IADD=1,NATM
        LB = 'MOD'
        NA = LDA_NATOM
        CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP,IERR)
        IF(IERR.NE.0) RETURN

        LDA_NATOM            = LDA_NATOM + 1
        LDA_MNAME(LDA_NATOM) = LDL_MNAME (IMOD)
        LDA_BACK (LDA_NATOM) = '.'
        LDA_FORW (LDA_NATOM) = '.'
        LDA_CHARG(LDA_NATOM) = 0.0

        LDA_FUNCT(LDA_NATOM) = 'add'
        LDA_ANAME(LDA_NATOM) = '.'
        LDA_ANEW (LDA_NATOM) = ATOM_UM(IADD)
        LDA_SYMB (LDA_NATOM) = CHEMUM (IADD)
        LDA_CHEM (LDA_NATOM) = CHEMUM (IADD)
      ENDDO
C     --- BONDS
      DO IU=1,NATM
        ATOM_U = ATOM_UM(IU)
        CHEMU  = CHEMUM(IU)
        DO IAC=1,C1_NATOM
          IF(C1_ANAME(IAC).EQ.ATOM_U) THEN
            IF(S1_NDIST(IAC).LE.0) GO TO 410
            IF(S1_NDIST(IAC).GT.0) THEN
              DO JAC=S1_NDIST(IAC),1,-1
                IF(S1_CONN(JAC,IAC).GT.0) THEN
                  IA    = S1_CONN(JAC,IAC)
                  ATOM  = C1_ANAME(IA)
                  CHEM2 = S1_CHEM (IA)
                  IF(C1_ASYMB(IA)(1:2).NE.'H '.AND.
     *               C1_ASYMB(IA)(1:2).NE.'D ') THEN
C ////
        LB = 'MOD'
        NB = LDB_NBOND
        CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP
     *                ,IERR)
        IF(IERR.NE.0) RETURN
        LDB_NBOND = LDB_NBOND + 1
        IF(LDL_IBOND(IMOD).EQ.0) LDL_IBOND(IMOD) = LDB_NBOND


        LDB_FUNCT(LDB_NBOND)   = 'add'
        LDB_MNAME(LDB_NBOND)   = LDL_MNAME (IMOD)
        LDB_1ATM (LDB_NBOND)   = ATOM_U
        LDB_2ATM (LDB_NBOND)   = ATOM
        CHEM1                  = CHEMU
        VAL = 0.0
        DO K=1,LEB_NBOND
           IF((LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K).EQ.CHEM2).OR.
     *        (LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K).EQ.CHEM1))
     *     THEN
             VAL = LEB_LENGTH(K) 
             GO TO 400
           ENDIF
        ENDDO
        D1 = 0.0
        D2 = 0.0
        DO K=1,LEB_NBOND
          IF(LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K)(1:1).EQ.'.')
     *          D1 = LEB_LENGTH(K)
          IF(LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K)(1:1).EQ.'.')
     *    D2 = LEB_LENGTH(K)

        ENDDO
        IF(D1.GT.0.0.AND.D2.GT.0.0) THEN
          DA  = (D1+D2)/2.0
          VAL = DA  
        ENDIF
        IF(VAL.LE.0.0) VAL = 1.5
        WRITE(LINE,
     *'(''           '',A,'' : default bond legnth will used '')')
     *  MON
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,F8.3,A,A4,A,A4,A)')
     *'           chem_type: ',CHEM1,'-',CHEM2,' ',VAL,' (',ATOM_U,'-',
     *ATOM,')'
                CALL MSGDOC(MDOC,LINE)


 400    CONTINUE
        DEV = 0.02

        LDB_TYPE (LDB_NBOND) = '.'
        LDB_VAL  (LDB_NBOND) = VAL
        LDB_DEV  (LDB_NBOND) = DEV
C ///
                  ENDIF
                ENDIF
              ENDDO
            ENDIF
          ENDIF
 410      CONTINUE
        ENDDO

      ENDDO
C     --- ANGLES
      DO IAC=1,C1_NATOM
        ATOM  = C1_ANAME(IAC)
        CHEM  = S1_CHEM (IAC)
        IF(C1_ASYMB(IAC)(1:2).NE.'H '.AND.
     *     C1_ASYMB(IAC)(1:2).NE.'D ') THEN
          IF(S1_NDIST(IAC).LE.0) GO TO 510
          IF(S1_NDIST(IAC).GT.1) THEN
            DO JAC=1,S1_NDIST(IAC)-1
              IA1 = S1_CONN(JAC,IAC)
              IF(S1_CONN(JAC,IAC).GT.0) THEN
                ATOM1 = C1_ANAME(IA1)
                CHEM1 = S1_CHEM (IA1)
                IF(C1_ASYMB(IA1)(1:2).NE.'H '.AND.
     *             C1_ASYMB(IA1)(1:2).NE.'D ') THEN
                  DO KAC=JAC+1,S1_NDIST(IAC)
                    IA2   = S1_CONN(KAC,IAC)
                    IF(S1_CONN(KAC,IAC).GT.0) THEN
                      ATOM2 = C1_ANAME(IA2)
                      CHEM2 = S1_CHEM (IA2)
                      IF(C1_ASYMB(IA2)(1:2).NE.'H '.AND.
     *                   C1_ASYMB(IA2)(1:2).NE.'D ') THEN
                        DO IU=1,NATM
                          ATOM_U = ATOM_UM(IU)
                          CHEMU  = CHEMUM(IU)
                          IF((ATOM1.EQ.ATOM_U).OR.
     *                       (ATOM2.EQ.ATOM_U)) THEN
C ////

C       LG = 'MOD'
        NG = LDG_NANGL
        CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP
     *                ,IERR)
        IF(IERR.NE.0) RETURN
        LDG_NANGL = LDG_NANGL + 1

        IF(LDL_ITHET(IMOD).EQ.0) LDL_ITHET(IMOD) = LDG_NANGL

        LDG_FUNCT(LDG_NANGL)   = 'add'
        LDG_MNAME(LDG_NANGL)   = LDL_MNAME (IMOD)
        LDG_1ATM (LDG_NANGL)   = ATOM1
        LDG_2ATM (LDG_NANGL)   = ATOM
        LDG_3ATM (LDG_NANGL)   = ATOM2

        VAL = 0.0
        DO K=1,LEG_NANGL
          IF(LEG_2ATM(K).EQ.CHEM) THEN
            IF((LEG_1ATM(K).EQ.CHEM1.AND.LEG_3ATM(K).EQ.CHEM2).OR.
     *         (LEG_1ATM(K).EQ.CHEM2.AND.LEG_3ATM(K).EQ.CHEM1))
     *      THEN
              VAL = LEG_ANGLE(K) 
              GO TO 500
            ENDIF
          ENDIF
        ENDDO
        D1 = 0.0
        DO K=1,LEG_NANGL
          IF(LEG_2ATM(K).EQ.CHEM) THEN
            IF(LEG_1ATM(K)(1:1).EQ.'.'.AND.LEG_3ATM(K)(1:1).EQ.'.')
     *      THEN
              D1 = LEG_ANGLE(K)
            ENDIF
          ENDIF
        ENDDO
        IF(D1.GT.0.0) THEN
          VAL = D1  
        ENDIF
        IF(VAL.LE.0.0) VAL = 109.45

        WRITE(LINE,'(A,A,A)')
     *'           ',MON,' : default angle value will used '
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,A4,A,F8.3,A,A4,A,A4,A,A4,A)')
     *  '           chem_type: ',CHEM1,'-',CHEM,'-',CHEM2,' ',VAL,' (',
     *  ' (',ATOM1,'-',ATOM,'-',ATOM2,')' 
                CALL MSGDOC(MDOC,LINE)
 500    CONTINUE
        DEV = 3.0

        LDG_VAL  (LDG_NANGL) = VAL
        LDG_DEV  (LDG_NANGL) = DEV
C ///
                          ENDIF
                        ENDDO
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF
              ENDIF
            ENDDO
          ENDIF
        ENDIF
 510    CONTINUE
      ENDDO
C ---
      RETURN
      END


      SUBROUTINE CREAT_MOD_NDEL(MDOC,MOD,MON,IMOD,NAMEM
     * ,NATM,ATOM_UM,IERR)
C -----------------------------------------------
C -P-  - 
C -S-
C -----------------------------------------------
      INTEGER*4  IMOD,MDOC,IERR
      CHARACTER  MON*8,ATOM_UM(9)*4
      CHARACTER  MOD*8,NAMEM*(*)
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C     INCLUDE 'ener_com.fh'
C ******
      CHARACTER LINE*256,DETAIL*48,LB*3
C     CHARACTER CHEM1*4,CHEM2*4,CHEMU*4,FUNC*3
C     CHARACTER ATOM1*4,ATOM2*4,ATOM*4,CHEM*4,ATOM_U*4
C ---
      COMMON/COM_CRT_MOD/ IFIRST_D
C -----------------------------------
      IERR = 0
      IF(NATM.LE.0.OR.NATM.GE.10) RETURN

      NA = 0
      NB = 0
      NG = 0
      NT = 0
      NP = 0

      CALL LENSTR_BL(NAMEM,LEN)
      IF(LEN.GT.48) LEN=48
      DETAIL = NAMEM(1:LEN)

      WRITE(LINE,'(''           create modification: '',A)') 
     * MOD
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           detail: '',A)') 
     * DETAIL(1:LEN)
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.GT.78) LEN=78
      CALL MSGDOC(MDOC,LINE(1:LEN))

      IF(LDL_NMOD.GE.MAXDMDF) THEN
        IF(IFIRST_D.EQ.0) THEN
          WRITE(LINE,
     *'('' WARNING : Number of modifications >'',I6)') MAXDMDF
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Change parameter MAXDMDF in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Now program stops to create new modifications.'')')
          CALL MSGERR(MDOC,LINE)
          IFIRST_D = 1
        ENDIF 
        IERR = 1
        RETURN
      ELSE
        IFIRST_D=0
      ENDIF

      LDL_NMOD = LDL_NMOD + 1
      LDL_IMOD = LDL_NMOD
      IMOD     = LDL_NMOD
      CALL LENSTR_BL(NAMEM,LEN)
      IF(LEN.GT.48) LEN=48
      DETAIL = NAMEM(1:LEN)
      CALL LENSTR_BL(MOD,LEN)
      LDL_MNAME (IMOD) = MOD(1:LEN)
      LDL_COMP  (IMOD) = '.'
      CALL LENSTR_BL(DETAIL,LEN)
      LDL_DETAIL(IMOD) = DETAIL(1:LEN)
C//'<-- do not change that'
      LDL_ORDER  (IMOD) = 0
      LDL_TYPE   (IMOD) = '.'
      LDL_FUSE   (IMOD) = 'C'
      LDL_ICONN  (IMOD) = 0
      LDL_IATOM  (IMOD) = 0
      LDL_IBOND  (IMOD) = 0
      LDL_ITHET  (IMOD) = 0
      LDL_IPLAN  (IMOD) = 0
      LDL_ICHIR  (IMOD) = 0
      LDL_ITORS  (IMOD) = 0

      LDL_IATOM(IMOD)  = LDA_NATOM + 1

      DO IADD=1,NATM
        LB = 'MOD'
        NA = LDA_NATOM
        CALL CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP,IERR)
        IF(IERR.NE.0) RETURN

        LDA_NATOM            = LDA_NATOM+1
        LDA_MNAME(LDA_NATOM) = LDL_MNAME (IMOD)
        LDA_BACK (LDA_NATOM) = '.'
        LDA_FORW (LDA_NATOM) = '.'
        LDA_CHARG(LDA_NATOM) = 0.0

        LDA_FUNCT(LDA_NATOM) = 'delete'
        LDA_ANAME(LDA_NATOM) = ATOM_UM(IADD)
        LDA_ANEW (LDA_NATOM) = '.'
        LDA_SYMB (LDA_NATOM) = '.'
        LDA_CHEM (LDA_NATOM) = '.'
      ENDDO
      RETURN
      END

      SUBROUTINE LOOK_MOD(MON,ATOM_MISS,ATOM_UNK,NATM,MOD,NAMEM
     * ,ATOM_U,FUNC,IMOD,IRTYPE,IERR)
C -----------------------------------------------
C -P-  return IMOD = 0  not found in table of MODs ( LDL_ )
C -S-                N  number of MOD in table.
C      search by MOD, NAMEM
C
C       check modification:   id: 'MONATMAT' rep ATM <-- AT
C                                 'MON-ATMM' del 
C                                 'MON+ATMU' add
C                                 'MON+9ADD' mad N atoms N < 10
C                                 'MON+7DEL' mad N atoms N < 10
C                           name:                      'REP-C5M_<-BR__-Td'
C                                                      'ADD-BR__->Td'
C                                 'ADD-atm1-atm2-atm3'
C                                 'DEL-atm1-atm2-atm3'
C                                                      'DEL-C5M_-Td'
C     compare MOD and DETAIL
C -----------------------------------------------
      INTEGER*4 IMOD,IERR
      CHARACTER MOD*8,MON*8,FUNC*3,STR*80,MOD_L*8,FUNC_L*3
      CHARACTER ATOM_MISS*4,ATOM_UNK*4,ATOM_U(9)*4,AUM(9)*4
      CHARACTER M3*3,AM*4,AU*4,CH1*1,CH2*2,NAMEM*(*)
C ---
      INCLUDE 'lib_com.fh'
C      INCLUDE 'atom_com.fh'
C -----------------------------------
C     create id and name
      M3 = MON(1:3)
      CALL LENSTR_BL(M3,LEN)
      IF(LEN.LE.1.OR.M3(2:2).EQ.' ') THEN
        M3(2:2)  = '_'
        MON(2:2) = ' '
      ENDIF
      IF(LEN.LE.2.OR.M3(3:3).EQ.' ') THEN
        M3(3:3)  = '_'
        MON(3:3) = ' '
      ENDIF
      IF(FUNC.EQ.'MAD'.OR.FUNC.EQ.'MDL') THEN 
        DO II=1,NATM
          AU=ATOM_U(II)
          CALL LENSTR_BL(AU,LEN)
          IF(LEN.LE.0.OR.AU(1:1).EQ.' ') AU(1:1)='_'
          IF(LEN.LE.1.OR.AU(2:2).EQ.' ') AU(2:2)='_'
          IF(LEN.LE.2.OR.AU(3:3).EQ.' ') AU(3:3)='_'
          IF(LEN.LE.3.OR.AU(4:4).EQ.' ') AU(4:4)='_'
          AUM(II)=AU
        ENDDO
      ELSE
        AM=ATOM_MISS
        CALL LENSTR_BL(AM,LEN)
        IF(LEN.LE.0.OR.AM(1:1).EQ.' ') AM(1:1)=' '
        IF(LEN.LE.1.OR.AM(2:2).EQ.' ') AM(2:2)=' '
        IF(LEN.LE.2.OR.AM(3:3).EQ.' ') AM(3:3)=' '
        IF(LEN.LE.3.OR.AM(4:4).EQ.' ') AM(4:4)=' '
        ATOM_MISS=AM

        AU=ATOM_UNK
        CALL LENSTR_BL(AU,LEN)
        IF(LEN.LE.0.OR.AU(1:1).EQ.' ') AU(1:1)=' '
        IF(LEN.LE.1.OR.AU(2:2).EQ.' ') AU(2:2)=' '
        IF(LEN.LE.2.OR.AU(3:3).EQ.' ') AU(3:3)=' '
        IF(LEN.LE.3.OR.AU(4:4).EQ.' ') AU(4:4)=' '
        ATOM_UNK=AU

        AM=ATOM_MISS
        CALL LENSTR_BL(AM,LEN)
        IF(LEN.LE.0.OR.AM(1:1).EQ.' ') AM(1:1)='_'
        IF(LEN.LE.1.OR.AM(2:2).EQ.' ') AM(2:2)='_'
        IF(LEN.LE.2.OR.AM(3:3).EQ.' ') AM(3:3)='_'
        IF(LEN.LE.3.OR.AM(4:4).EQ.' ') AM(4:4)='_'
        AU=ATOM_UNK
        CALL LENSTR_BL(AU,LEN)
        IF(LEN.LE.0.OR.AU(1:1).EQ.' ') AU(1:1)='_'
        IF(LEN.LE.1.OR.AU(2:2).EQ.' ') AU(2:2)='_'
        IF(LEN.LE.2.OR.AU(3:3).EQ.' ') AU(3:3)='_'
        IF(LEN.LE.3.OR.AU(4:4).EQ.' ') AU(4:4)='_'

      ENDIF

      IF(FUNC.EQ.'REP') THEN
        CH2   = '<-'
        MOD   = M3//AM(1:3)//ATOM_UNK(1:2)
        NAMEM = FUNC//'-'//AM//CH2//AU//'-'//MON
      ELSE IF(FUNC.EQ.'ADD') THEN
        CH2   = '->'
        MOD   = M3//'+'//ATOM_UNK(1:4)
        NAMEM = FUNC//'-'//AU//CH2//MON
      ELSE IF(FUNC.EQ.'DEL') THEN 
        CH2   = '->'
        MOD   = M3//'-'//ATOM_MISS(1:4)
        NAMEM = FUNC//'-'//AM//CH2//MON
      ELSE IF(FUNC.EQ.'MAD') THEN 
        IF(NATM.LE.0.OR.NATM.GE.10) RETURN
        WRITE(CH1,'(I1)') NATM
        MOD = M3//'+'//CH1//ATOM_U(1)(1:3)
        STR = 'ADD'
        DO II=1,NATM
          CALL LENSTR_BL(STR,LEN)
          NAMEM = STR(1:LEN)//'-'//AUM(II)
          STR   = NAMEM 
        ENDDO
      ELSE IF(FUNC.EQ.'MDL') THEN 
        IF(NATM.LE.0.OR.NATM.GE.10) RETURN
        WRITE(CH1,'(I1)') NATM
        MOD = M3//'-'//CH1//ATOM_U(1)(1:3)
        STR = 'DEL'
        DO II=1,NATM
          CALL LENSTR_BL(STR,LEN)
          NAMEM = STR(1:LEN)//'-'//AUM(II)
          STR   = NAMEM 
        ENDDO
      ENDIF
C     search
      IMOD = 0

      IF(LDL_NMOD.GT.0) THEN
        DO L=1,LDL_NMOD
          IF(MOD.EQ.LDL_MNAME(L)) THEN
            CALL LENSTR_BL(NAMEM,LEN)
            IF(NAMEM(1:LEN).EQ.LDL_DETAIL(L)(1:LEN)) THEN
              IMOD = L
              RETURN
            ENDIF
          ENDIF
        ENDDO
      ENDIF

      IF(LDL_NMOD.GT.0) THEN
        
        FUNC_L = FUNC
        IF(FUNC.EQ.'MDL') FUNC_L = 'DEL'
        IF(FUNC.EQ.'MAD') FUNC_L = 'ADD'

        IF(IRTYPE.EQ.3.OR.IRTYPE.EQ.4) THEN
C         protein
          IT = 3
        ELSE IF(IRTYPE.EQ.5.OR.IRTYPE.EQ.6) THEN
C         DNA/RNA
          IT = 5
        ELSE IF(IRTYPE.EQ.7.OR.IRTYPE.EQ.8) THEN
C         saccharide

          MOD_L = ' '
          IF(MOD(4:7).EQ.'-1O1'.AND.NAMEM(1:8).EQ.'DEL-O1__') THEN
            MOD_L = 'DEL-O1'
          ELSE IF(MOD(4:7).EQ.'-1O2'.AND.NAMEM(1:8).EQ.'DEL-O2__')THEN
            MOD_L = 'DEL-O2'
          ENDIF

          IF(LDL_NMOD.GT.0.AND.MOD_L.NE.' ') THEN
            DO L=1,LDL_NMOD
              IF(MOD_L.EQ.LDL_MNAME(L)) THEN
                MOD  = MOD_L
                IMOD = L
                RETURN
              ENDIF
            ENDDO
          ENDIF

        ENDIF

        CALL LOOK_MODREC(FUNC_L,IT,NAMEM,IMOD,MOD_L,IERR)      
        IF(IMOD.GT.0) MOD = MOD_L

      ENDIF

      RETURN
      END

      
      SUBROUTINE LOOK_MODREC(FUNC,IRTYPE,NAMEM,IMOD,MOD,IERR)      
C ------------------------------------------------------
      INTEGER*4 IMOD,IERR
      CHARACTER NAMEM*(*),MOD*8,FUNC*3
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      IERR = 0
      IMOD = 0
      MOD  = ' '

      CALL LENSTR_BL(NAMEM,LEN)

      IF(LEN      .LE.0) RETURN
      IF(N_MOD_REC.LE.0) RETURN

C      WRITE(*,*) ' N_MOD_REC:',N_MOD_REC,';',FUNC

      DO L=1,N_MOD_REC

C        WRITE(*,*) IRTYPE,MOD_REC_IRTYPE(L)
C        WRITE(*,*) ';',NAMEM(1:LEN),';',MOD_REC_DETAIL(L)(1:LEN),';'
C     *  ,MOD_REC_FUNC(L),';'

        IF(IRTYPE.EQ.MOD_REC_IRTYPE(L).AND.
     *     FUNC  .EQ.MOD_REC_FUNC(L)       ) THEN
          IF(NAMEM(1:LEN).EQ.MOD_REC_DETAIL(L)(1:LEN)) THEN
            MOD = MOD_REC_ID(L)

C            WRITE(*,*) ' MOD:',';',MOD,';'             

            GO TO 100
          ENDIF
        ENDIF
      ENDDO 
      RETURN

 100  CONTINUE
      IF(LDL_NMOD.GT.0) THEN
        DO L=1,LDL_NMOD

C        WRITE(*,*) L,';',MOD,';',LDL_MNAME(L),';'

          IF(MOD.EQ.LDL_MNAME(L)) THEN
            IF(MOD.EQ.LDL_MNAME(L)) THEN
              IMOD = L
              RETURN
            ENDIF
          ENDIF
        ENDDO
      ENDIF

      RETURN
      END

      SUBROUTINE CHECK_MEMORY_L(MDOC,LB,NA,NB,NG,NT,NP,IERR)
C --------------------------------
      INTEGER   NA,NB,NG,NT,NP,IERR
      CHARACTER LB*3,LINE*256
      INCLUDE 'lib_com.fh'
C --------------------------------
C     LB = 'MON' 'LB1' 'MOD' 'LIN'
C
      IERR=0
      IF(LB.EQ.'MOD') THEN
        IF(NA.GE.MAXDATM) THEN
          WRITE(LINE,
     *'('' ERROR: number of atoms for the modifications >'',I6)') 
     *  MAXDATM
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''        Change parameter MAXDATM in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF
        IF(NB.GE.MAXDBND) THEN
          WRITE(LINE,
     *'('' ERROR: number of bonds for the modifications >'',I6)') 
     *  MAXDBND
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''        Change parameter MAXDBND in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF
        IF(NG.GE.MAXDANG) THEN
          WRITE(LINE,
     *'('' ERROR: number of angles for the modifications >'',I6)') 
     *  MAXDANG
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''        Change parameter MAXDANG in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF
      ENDIF
      RETURN
      END

      SUBROUTINE CHECK_COMPL(MDOC,LIST,MODE,ISYN,MON,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4,MON*8,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C ------------------------------------------
      INTEGER*4 IPAIR1(LENLIM)
      INTEGER*4 IPAIR2(LENLIM)

      CHARACTER LINE*80,SYMB*4,CH4*4,MONN*8,ATOM*4,AATOM*4
      INTEGER   ICONTENT(15)
      CHARACTER ATM_SYMB(15)*2
      DATA  ATM_SYMB
     */'C ','N ','O ','S ','P ','CO','MG','CA','ZN','CU','FE','CL','MN'
     *,'MO','  '/
C       1    2    3    4    5    6    7    8    9    10   11   12   13
C       14   15
C --------------------------------
      IERR = 0
      M    =-ABS(MDOC)-1
      IF(LIST.EQ.'T'.OR.LIST.EQ.'L') M = MDOC
C ------------------------------------------
      MTC_NTYPE = 0
      DO I=1,MAX1ATM
        MTC_NUMB  (I,1) = 0
        MTC_NUMB  (I,2) = 0
        MTC_NUMB1 (I)   = 0
        MTC_NUMB2 (I)   = 0
        MTC_NAME1 (I)   = ' '
        MTC_NAME2 (I)   = ' '
        MTC_IB1   (I)   = 0
        MTC_IB2   (I)   = 0
        DO J=1,MAX1ATM
          MTC_CONN(I,J) = 0
        ENDDO
      ENDDO
      DO I=1,LENLIM
        MTC_INDEX1(I)   = 0
        MTC_INDEX2(I)   = 0
      ENDDO
      DO I=1,LENLIM
        IPAIR1(I)   = 0
        IPAIR2(I)   = 0
      ENDDO
      DO I=1,15
        ICONTENT(I) = 0
      ENDDO

      MTC_C_INDEX   = '000'
      MTC_C_CONTENT = '000'
      MTC_C_PAIR    = '000'

      ISCORE  = 0
      NOCC    = 0
C --------------------------------------
      IF(MODE.EQ.'LIB ') GO TO 420      

      MTC_NA1 = 0

      IF(C1_NATOM.LE.0) RETURN

      IF(LIST.EQ.'T') THEN
        write(line,'(''crd NA:'',I4,A)')
     *  C1_NATOM,C1_RNAME
        CALL MSGDOC(MDoc,LINE)
        DO I=1,C1_NATOM
          write(line,'(''  '',I4,A,A,F8.2)')
     *    i,C1_ANAME(I),C1_ASYMB(I),C1_OCC(I)
          CALL MSGDOC(MDoc,LINE)
          NL = S1_NDIST(I)
          IF(NL.GT.0) THEN
            DO J=1,NL
              k = S1_CONN(J,I)
              write(line,'(''  --->'',2I4,A,A)')
     *        j,S1_CONN(J,I),C1_ANAME(k),C1_ASYMB(k)
              CALL MSGDOC(MDoc,LINE)
            ENDDO
          ENDIF
        ENDDO
      ENDIF 

      DO I=1,C1_NATOM
      IF(C1_ANAME(I).NE.'    ') THEN
        IF(C1_OCC(I).LT.0.0001) THEN
          NOCC = NOCC + 1
        ELSE
          SYMB = C1_ASYMB(I)
          IF(SYMB(1:2).NE.'H '.AND.SYMB(1:2).NE.'D ') THEN
            MTC_NA1            = MTC_NA1+1
            MTC_NUMB1(MTC_NA1) = I
            MTC_NAME1(MTC_NA1) = C1_ANAME(I)
            MTC_IB1  (I)       = MTC_NA1
            MTC_SYMB1(MTC_NA1) = 4
            IF(SYMB(1:2).EQ.'C ') MTC_SYMB1(MTC_NA1) = 1
            IF(SYMB(1:2).EQ.'N ') MTC_SYMB1(MTC_NA1) = 2
            IF(SYMB(1:2).EQ.'O ') MTC_SYMB1(MTC_NA1) = 3
            IF(MTC_NTYPE.GT.0) THEN
              DO J=1,MTC_NTYPE
                IF(SYMB(1:2).EQ. MTC_SYMB(J)(1:2)) THEN
                  MTC_NUMB(J,1) = MTC_NUMB(J,1) + 1
                  GO TO 400
                ENDIF
              ENDDO
            ENDIF
            MTC_NTYPE     = MTC_NTYPE + 1
            J             = MTC_NTYPE
            MTC_NUMB(J,1) = MTC_NUMB(J,1) + 1
            MTC_SYMB(J)   = SYMB(1:2)
 400        CONTINUE
            IF(MODE(1:1).NE.' ') THEN
              DO K=1,15
                IF(SYMB(1:2).EQ.ATM_SYMB(K)) THEN
                  ICONTENT(K) =  ICONTENT(K) + 1
                  GO TO 410
                ENDIF
              ENDDO
            ENDIF
 410        CONTINUE
          ENDIF
        ENDIF
      ENDIF
      ENDDO

      IF(MTC_NA1.GT.0) THEN
        DO IM=1,MTC_NA1
          I  = MTC_NUMB1(IM)
          NL = S1_NDIST(I)
          IF(NL.GT.0) THEN
            DO J=1,NL
              KK = S1_CONN(J,I)
              IF(MTC_IB1(KK).NE.0) THEN
                NJA  = MTC_IB1(KK)
                SYMB = C1_ASYMB(KK)
                IF(SYMB(1:2).NE.'H '.AND.SYMB(1:2).NE.'D ') THEN
                  IF(IM.GT.NJA) THEN
C                   MTC_CONN1(IM<NJA)
                    MTC_CONN(NJA,IM) = 1
                  ELSE
                    MTC_CONN(IM,NJA) = 1
                  ENDIF
                ENDIF
              ENDIF
            ENDDO
          ENDIF            
        ENDDO 
      ENDIF

      IF(MODE.EQ.'CRD ') THEN
        DO I=1,15
          WRITE(CH4,'(I4)') ICONTENT(I)
          IF(ICONTENT(I).GT.99) CH4='9999'
          IF(CH4(3:3).EQ.' ') CH4(3:3) = '0' 
          I1 = (I-1)*2 + 1
          I2 = I1  + 1
          MTC_C_CONTENT(I1:I2) = CH4(3:4)
        ENDDO

        IF(LIST.EQ.'T') THEN
          write(line,'(''crd -->'',A30,'';'')')
     *    MTC_C_CONTENT
          CALL MSGDOC(MDoc,LINE)
        endif

      ENDIF

      IF(MTC_NA1.LE.1.AND.MODE.EQ.'CRD ') RETURN

 420  CONTINUE
      IF(MODE.EQ.'CRD ') GO TO 450      

      MTC_NA2 = 0
 
      IF(L1A_NATOM.LE.0) RETURN

      IF(LIST.EQ.'T') THEN
        write(line,'(''lib NA:'',I4,A)')
     *  L1A_NATOM,L1L_MNAME
        CALL MSGDOC(MDoc,LINE)
        DO I=1,l1a_NATOM
          write(line,'(''  '',I4,A,A,i4)')
     *    i,L1A_ANAME(I),L1A_SYMB(I),L1A_NDIST(I)
          CALL MSGDOC(MDoc,LINE)
          NL = L1A_NDIST(I)
          IF(NL.GT.0) THEN
            DO J=1,NL
              k = L1A_CONN(J,I)
              write(line,'(''  --->'',2I4,A,A)')
     *        j,L1A_CONN(J,I),L1A_ANAME(k),L1A_SYMB(k)
              CALL MSGDOC(MDoc,LINE)
            ENDDO
          ENDIF
        ENDDO
        IF(L1B_NBOND.GT.0) THEN
          DO IB=1,L1B_NBOND
            write(line,'(''  bond'',I4,'' '',A,''-->'',A)')
     *      IB,L1B_1ATM(IB),L1B_2ATM(IB)
            CALL MSGDOC(MDoc,LINE)
          ENDDO
        ENDIF
      ENDIF 


      DO I=1,L1A_NATOM
      IF(L1A_ANAME(I).NE.'    ') THEN
        SYMB = L1A_SYMB(I)
        IF(SYMB(1:2).NE.'H '.AND.SYMB(1:2).NE.'D ') THEN
          MTC_NA2            = MTC_NA2+1
          MTC_NUMB2(MTC_NA2) = I
          MTC_NAME2(MTC_NA2) = L1A_ANAME(I)
          MTC_IB2(I)         = MTC_NA2
          MTC_SYMB2(MTC_NA2) = 4
          IF(SYMB(1:2).EQ.'C ') MTC_SYMB2(MTC_NA2) = 1
          IF(SYMB(1:2).EQ.'N ') MTC_SYMB2(MTC_NA2) = 2
          IF(SYMB(1:2).EQ.'O ') MTC_SYMB2(MTC_NA2) = 3
          IF(MTC_NTYPE.GT.0) THEN
            DO J=1,MTC_NTYPE
              IF(SYMB(1:2).EQ. MTC_SYMB(J)(1:2)) THEN
                MTC_NUMB(J,2) = MTC_NUMB(J,2) + 1
                GO TO 430
              ENDIF
            ENDDO
          ENDIF
          MTC_NTYPE     = MTC_NTYPE + 1
          J             = MTC_NTYPE
          MTC_NUMB(J,2) = MTC_NUMB(J,2) + 1
          MTC_SYMB(J)   = SYMB(1:2)
 430      CONTINUE
          IF(MODE(1:1).NE.' ') THEN
            DO K=1,15
              IF(SYMB(1:2).EQ.ATM_SYMB(K)) THEN
                ICONTENT(K) =  ICONTENT(K) + 1
                GO TO 440
              ENDIF
            ENDDO
          ENDIF
 440      CONTINUE
        ENDIF
      ENDIF
      ENDDO

      IF(MTC_NA2.GT.0) THEN
   
        DO IM=1,MTC_NA2
          I  = MTC_NUMB2(IM)
          NL = L1A_NDIST(I)
          IF(NL.GT.0) THEN
            DO J=1,NL
              KK = L1A_CONN(J,I)
              IF(MTC_IB2(KK).NE.0) THEN
                NJA  = MTC_IB2(KK)
                SYMB = L1A_SYMB(KK)
                IF(SYMB(1:2).NE.'H '.AND.SYMB(1:2).NE.'D ') THEN
                  IF(IM.GT.NJA) THEN
C                   MTC_CONN2(IM>NJA)
                    MTC_CONN(IM,NJA) = 1
                  ELSE
                    MTC_CONN(NJA,IM) = 1
                  ENDIF
                ENDIF
              ENDIF
            ENDDO
          ENDIF            
        ENDDO

      ENDIF

      IF(MODE.EQ.'LIB ') THEN
        DO I=1,15
          WRITE(CH4,'(I4)') ICONTENT(I)
          IF(ICONTENT(I).GT.99) CH4='9999'
          IF(CH4(3:3).EQ.' ') CH4(3:3) = '0' 
          I1 = (I-1)*2 + 1
          I2 = I1  + 1
          MTC_C_CONTENT(I1:I2) = CH4(3:4)
        ENDDO

        IF(LIST.EQ.'T') THEN
          write(line,'(''lib -->'',A30,'';'')')
     *    MTC_C_CONTENT
          CALL MSGDOC(MDoc,LINE)
        ENDIF

      ENDIF

      IF(MTC_NA2.LE.1.AND.MODE.EQ.'LIB ') RETURN

 450  CONTINUE


      IF((MTC_NA1.LE.1.OR.MTC_NA2.LE.1).AND.MODE(1:1).EQ.' ') THEN

        IF(MTC_NA1.EQ.1.AND.MTC_NA2.EQ.1) THEN
          IF(MTC_NAME1(1).EQ.MTC_NAME2(1)) THEN
            RETURN
          ELSE
            IS = MTC_SYMB1(1)
            JS = MTC_SYMB2(1)
            IF(IS.EQ.JS) THEN
              MTC_NEW(1)=1
              GO TO 200
            ENDIF
          ENDIF 
        ELSE IF(MTC_NA1.LE.0.OR.MTC_NA2.LE.0) THEN
          IERR=5 
        ELSE IF(MTC_NA1.EQ.1) THEN
          IERR=6
        ELSE IF(MTC_NA2.EQ.1) THEN
          IERR=7
        ENDIF

        RETURN

      ENDIF

C -----////
      IF(LIST.EQ.'T') THEN
      IF(MODE(1:1).EQ.' ') THEN
        N =  MTC_NTYPE
        IF(N.GT.25) N = 25
        WRITE(LINE,'(''Natom(crd,lib),Nocc:'',3(1X,I3))') 
     *  MTC_NA1,MTC_NA2,NOCC
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(4X,25(1X,A2))'   ) (MTC_SYMB(J)  ,J=1,N)
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(''crd:'',25(I3))') (MTC_NUMB(J,1),J=1,N)
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(''lib:'',25(I3))') (MTC_NUMB(J,2),J=1,N)
        CALL MSGERR(MDOC,LINE)
      ENDIF
      ENDIF
C -----////

      IF(MODE(1:1).EQ.' ') THEN
C       IF((MTC_NA1-MTC_NA2).GT.(NOCC+1)) THEN
        IF(ABS((MTC_NA1+NOCC)-MTC_NA2).GT.2) THEN
          IERR = 11
          RETURN
        ENDIF

        DO I=1,MTC_NTYPE
          IF(MTC_SYMB(I).NE.'C   '.AND.MTC_SYMB(I).NE.'N   '.AND.
     *       MTC_SYMB(I).NE.'O   '                         ) THEN
            IF(MTC_NUMB(I,1).NE.MTC_NUMB(I,2)) THEN
              IERR = 12
              RETURN
            ENDIF
          ENDIF
        ENDDO
      ENDIF
C --------------------   
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDoc,' ')
        write(line,'(''-->1     '',10A4)')
     *  (MTC_NAME1(I),I=1,10) 
        CALL MSGDOC(MDoc,LINE)
        DO J=1,10
          write(line,'(''l '',A4,'' '',10I4,''  '',a4)')
     *    MTC_NAME2(J),(MTC_CONN(J,I),I=1,10),mtc_name1(j)
          CALL MSGDOC(MDoc,LINE)
        ENDDO
        write(line,'(''-->2     '',10A4)')
     *  (MTC_NAME2(I),I=1,10) 
        CALL MSGDOC(MDoc,LINE)
        CALL MSGDOC(MDoc,' ')
      ENDIF

      IF(MODE.NE.'LIB ') CALL SET_TABCONN_C
      IF(MODE.NE.'CRD ') CALL SET_TABCONN_L

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDoc,' ')
        write(line,'(''       '',10A4)')
     *  (MTC_NAME1(I),I=1,10) 
        CALL MSGDOC(MDoc,LINE)
        DO J=1,10
          write(line,'(''l '',A4,'' '',10I4)')
     *    MTC_NAME2(J),(MTC_CONN(J,I),I=1,10)
          CALL MSGDOC(MDoc,LINE)
        ENDDO
        write(line,'(''-->2     '',10A4)')
     *  (MTC_NAME2(I),I=1,10) 
        CALL MSGDOC(MDoc,LINE)
        CALL MSGDOC(MDoc,' ')
      ENDIF
C -------------------
C                I
C         \      .
C          \     .
C   J  .....\... N          N - minimal number of bonds between I - J atoms
C            \
C      L1A    \  C1
C              \
C               \
C                \
C
C
C --------------------
      IF(MODE.NE.'LIB ') CALL SET_VECTOR_C(IPAIR1)
      IF(MODE.NE.'CRD ') CALL SET_VECTOR_L(IPAIR2)
c -----------------------------------------------
c           1, 2, ..length..  ,8
c  index:             N                 N  pairs of atoms with with length
c
c            1, 2, ...          ,8
c  vector: 1          Nc             C
c  / for   2          Nn             N
c   each   3          No             O
c   atom / 4          N-             -
c ------------------------------------------------

C -----////
      IF(LIST.EQ.'T') THEN

      IF(MODE(1:1).EQ.' ') THEN
      CALL MSGERR(MDOC,' ----crd------')
      WRITE(LINE,'('' Index: '',8(1X,I3))') (MTC_INDEX1(J),J=1,LENLIM)
      CALL MSGERR(MDOC,LINE)
      DO I=1,MTC_NA1
        WRITE(LINE,'(I3,1X,A4,1X,I4,8(1X,I3),'' C '')') 
     *      I,MTC_NAME1(I),MTC_SYMB1(I),(MTC_VEC1(I,J,1),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(13X,8(1X,I3),'' N '')') 
     *               (MTC_VEC1(I,J,2),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(13X,8(1X,I3),'' O '')') 
     *               (MTC_VEC1(I,J,3),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(13X,8(1X,I3),'' - '')') 
     *               (MTC_VEC1(I,J,4),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
      ENDDO

      CALL CREATE_INDEX(MTC_INDEX1,MTC_C_INDEX,IPAIR1,MTC_C_PAIR)

      write(line,'(''-->'',A24,'';'')')
     *MTC_C_INDEX
      CALL MSGDOC(MDOC,LINE)
      write(line,'(''  ;'',A24,'';'')')
     *MTC_C_PAIR
      CALL MSGDOC(MDOC,LINE)
      ENDIF

      IF(MODE(1:1).EQ.' ') THEN
      CALL MSGERR(MDOC,' ----lib------')
      WRITE(LINE,'('' Index: '',8(1X,I3))') (MTC_INDEX2(J),J=1,LENLIM)
      CALL MSGERR(MDOC,LINE)
      DO I=1,MTC_NA2
        WRITE(LINE,'(I3,1X,A4,1X,I4,8(1X,I3),'' C '')') 
     *       I,MTC_NAME2(I),MTC_SYMB2(I),(MTC_VEC2(I,J,1),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(13X,8(1X,I3),'' N '')') 
     *               (MTC_VEC2(I,J,2),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(13X,8(1X,I3),'' O '')') 
     *               (MTC_VEC2(I,J,3),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'(13X,8(1X,I3),'' - '')') 
     *               (MTC_VEC2(I,J,4),J=1,LENLIM) 
        CALL MSGERR(MDOC,LINE)
      ENDDO
      CALL MSGERR(MDOC,' ----------')

      CALL CREATE_INDEX(MTC_INDEX2,MTC_C_INDEX,IPAIR2,MTC_C_PAIR)

      write(line,'(''-->'',A24,'';'')')
     *MTC_C_INDEX
      CALL MSGDOC(MDOC,LINE)
      write(line,'(''  ;'',A24,'';'')')
     *MTC_C_PAIR
      CALL MSGDOC(MDOC,LINE)
      ENDIF

      ENDIF
C -----////
C --------------------
      IF(MODE.EQ.'CRD ') THEN
        CALL CREATE_INDEX(MTC_INDEX1,MTC_C_INDEX,IPAIR1,MTC_C_PAIR)
        RETURN
      ELSE IF(MODE.EQ.'LIB ') THEN
        CALL CREATE_INDEX(MTC_INDEX2,MTC_C_INDEX,IPAIR2,MTC_C_PAIR)

        IF(LIST.EQ.'T') THEN
        write(line,'(''-->'',A24,'';'')')
     *  MTC_C_INDEX
        CALL MSGDOC(MDOC,LINE)
        write(line,'(''  ;'',A24,'';'')')
     *  MTC_C_PAIR
        CALL MSGDOC(MDOC,LINE)
        ENDIF

        RETURN
      ENDIF
C --------------------
      CALL COMP_VECTOR
C ---------------------------------------
C              ATOM_1
C       1,2 ---   i  ---
C
C           ...  N_equiv ...     
C
C a   1          "
C t   2          "
C o   .          "
C m   j         delt
C !   .          "
C 2   .          "
C     .          "
C ---------------------------------------- 

C -----////
      IF(LIST.EQ.'T') THEN
      CALL MSGERR(MDOC,' ---- EQUIV ------')
      DO I=1,MTC_NA1
        N =  MTC_NEQUIV(I)
        IF(N.GT.20) N = 20
        IF(N.GT.0) THEN
          WRITE(LINE,'(2I4,'' - '',20(1X,I2))') 
     *    I,N,(MTC_DELTA(J,I),J=1,N) 
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,'(''         - '',20(1X,I2))') 
     *    (MTC_IEQUIV(J,I),J=1,N) 
          CALL MSGERR(MDOC,LINE)
        ELSE
          WRITE(LINE,'(2I4,'' - '')') 
     *    I,N 
          CALL MSGERR(MDOC,LINE)
        ENDIF  
      ENDDO 
      ENDIF
C -----////


C --------------------
      DO I=1,MTC_NA1
        MTC_NEW(I) = 0
      ENDDO
      N_NEW = 0
C --------------------

 100  CONTINUE

      CALL CHECK_EQUIV(MDOC,N_NEW,IFLAG,ISCORE,IERR)
      IF(IERR.NE.0) THEN
        RETURN
      ENDIF

      IF(N_NEW.EQ.MTC_NA1) GO TO 200
      IF(IFLAG.EQ.1      ) GO TO 100

      IF(N_NEW.LT.MTC_NA1) THEN

C       IF((MTC_NA1-N_NEW).EQ.1) ?????

        IERR=5
        RETURN
      ENDIF

C -----------------
C     --- OK ---
C 
 200  CONTINUE
C  SYNONYMS & COORDS


C -----////
      IF(LIST.EQ.'T') THEN
      WRITE(LINE,'(''  ISCORE : '',I5)') ISCORE
      CALL MSGERR(MDOC,LINE)
      DO I=1,MTC_NA1
        IF(MTC_NEW(I).NE.0) THEN
          J  = MTC_NEW(I)
          WRITE(LINE,*) I,MTC_NAME1(I),J,MTC_NAME2(J)
          CALL MSGERR(MDOC,LINE)
        ELSE
          WRITE(LINE,*) I,MTC_NAME1(I),' -'
          CALL MSGERR(MDOC,LINE)
        ENDIF
      ENDDO
      ENDIF
C -----////

      DO I=1,MTC_NA1
        IF(MTC_NEW(I).NE.0) THEN
          J  = MTC_NEW(I)
          IF(MTC_NAME1(I).NE.MTC_NAME2(J)) THEN
            DO I2=1,MTC_NA1
              IF(MTC_NAME1(I2).EQ.MTC_NAME2(J)) THEN
                J2  = MTC_NEW(I2)
                IF(MTC_NAME1(I).EQ.MTC_NAME2(J2)) THEN
                  MTC_NEW(I)  = J2
                  MTC_NEW(I2) = J
                  II = MTC_NUMB2(J)
                  MTC_NUMB2(J) = MTC_NUMB2(J2)
                  MTC_NUMB2(J2)= II
                  II = MTC_NUMB1(I)
                  MTC_NUMB1(I) = MTC_NUMB1(I2)
                  MTC_NUMB1(I2)= II
                  GO TO 300
                ELSE
C                 I - J
C                     I2- J3
C                         I3-J3  
                  DO I3=1,MTC_NA1
                   IF(MTC_NAME1(I3).EQ.MTC_NAME2(J2)) THEN
                     J3  = MTC_NEW(I3)
                     IF(MTC_NAME1(I).EQ.MTC_NAME2(J3)) THEN
                        MTC_NEW(I)  = J3
                        MTC_NEW(I2) = J
                        MTC_NEW(I3) = J2
                        II = MTC_NUMB2(J)
                        MTC_NUMB2(J) = MTC_NUMB2(J3)
                        MTC_NUMB2(J3)= MTC_NUMB2(J2)
                        MTC_NUMB2(J2)= II
                        II = MTC_NUMB1(I)
                        MTC_NUMB1(I) = MTC_NUMB1(I3)
                        MTC_NUMB1(I3)= MTC_NUMB1(I2)
                        MTC_NUMB1(I2)= II
                        GO TO 300
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF
              ENDIF
            ENDDO
          ENDIF
        ENDIF        
 300    CONTINUE
      ENDDO

C -----////
      IF(LIST.EQ.'T') THEN
      WRITE(LINE,'('' NEW --- : '')') 
      CALL MSGERR(MDOC,LINE)
      DO I=1,MTC_NA1
        IF(MTC_NEW(I).NE.0) THEN
          J  = MTC_NEW(I)
          WRITE(LINE,*) I,MTC_NAME1(I),J,MTC_NAME2(J)
          CALL MSGERR(MDOC,LINE)
        ELSE
          WRITE(LINE,*) I,MTC_NAME1(I),' -'
          CALL MSGERR(MDOC,LINE)
        ENDIF
      ENDDO
      ENDIF
C -----////

      IFIRST   = 0
      IFIRST_S = 0

C     IF(ISYN.GE.1) RETURN
      IF(ISYN.EQ.1) RETURN

      CALL COPYC2(MDOC,IERR)

      DO I=1,MTC_NA1

        IF(MTC_NEW(I).NE.0) THEN

          J  = MTC_NEW(I)
          JJ = MTC_NUMB2(J)
          II = MTC_NUMB1(I)

          L1A_COOR_FLAG(JJ) = 'Y'
          IF(C1_OCC(II).LT.0.0001) L1A_COOR_FLAG(JJ) = 'N'
          L1A_X (JJ) = C1_XYZ(1,II)
          L1A_Y (JJ) = C1_XYZ(2,II)
          L1A_Z (JJ) = C1_XYZ(3,II)

          IF(C1_ANAME(II).NE.L1A_ANAME(JJ)) THEN

            IF(ISYN.EQ.0) THEN

              IF(LMS_NSYN.GE.MAXMLIST) RETURN
              IF(LMS_NSYN.GT.0) THEN
                DO IS=1,LMS_NSYN
                  IF(LMS_MNAME (IS).EQ.MON     .AND.
     *               LMS_MNAME2(IS).EQ.C1_RNAME     ) THEN
                    IF(LMS_ATOM (IS).EQ.L1A_ANAME(JJ).AND.
     *                 LMS_AATOM(IS).EQ.C1_ANAME(II)      ) THEN
                      GO TO 500
                    ENDIF
                  ENDIF
                ENDDO
              ENDIF

              MONN  = C1_RNAME
              IF(MON.EQ.MONN) MONN = '.'
              ATOM  = L1A_ANAME(JJ)
              AATOM = C1_ANAME (II)
 
              CALL CHECK_SYNONYM(IT,MON,MONN,ATOM,AATOM)
              IF(IT.EQ.0) THEN
                LMS_NSYN = LMS_NSYN + 1
                LMS_NEW  = LMS_NEW  + 1
                IF(IFIRST_S.EQ.0) THEN
                  LMS_ISYN = LMS_NSYN
                  IFIRST_S = 1
                ENDIF
                LMS_MNAME  (LMS_NSYN) = MON
                LMS_MNAME2 (LMS_NSYN) = '.'
                LMS_ATOM   (LMS_NSYN) = ATOM
                LMS_MOD    (LMS_NSYN) = '.' 
                LMS_AATOM  (LMS_NSYN) = AATOM 
                LMS_AMNAME (LMS_NSYN) = MONN  
                LMS_AMNAME2(LMS_NSYN) = '.' 
                LMS_FLAG   (LMS_NSYN) = 'N' 
              ENDIF

 500          CONTINUE

            ENDIF

            IF(IFIRST.EQ.0) THEN
              IFIRST   = 1
                WRITE(LINE,
     * '('' WARNING : program changed some atom names to standard'')')
              CALL MSGDOC(M,LINE)
            ENDIF
            WRITE(LINE,'(A,A,A,A4,A,A4,A)')
     *'           ',MON,'  "',C1_ANAME(II),'" ---> "',L1A_ANAME(JJ),'"'
            CALL MSGDOC(M,LINE)

            C2_ANAME(II)=L1A_ANAME(JJ)
C           C1_ANAME(II)=L1A_ANAME(JJ)

          ENDIF
        ENDIF
      ENDDO

      IF(IFIRST.NE.0.AND.ISYN.EQ.0) THEN
        CALL COPYC1(MDOC,IERR)  
      ENDIF

C --------------------
      RETURN
      END

      SUBROUTINE CREATE_INDEX(INDEX,C_INDEX,IPAIR,C_PAIR)
C ------------------------------------------
      PARAMETER (LENLIM   =  8)
      INTEGER*4 INDEX(LENLIM)
      INTEGER*4 IPAIR(LENLIM)
      CHARACTER C_INDEX  *24
      CHARACTER C_PAIR   *24
      CHARACTER CH4*4
C ------------------------------------------
        DO I=1,8
          IND = INDEX(I)/2
          WRITE(CH4,'(I4)') IND
          IF(IND.GT.999) CH4='9999'
          IF(CH4(3:3).EQ.' ') CH4(3:3) = '0' 
          IF(CH4(2:2).EQ.' ') CH4(2:2) = '0' 
          I1 = (I-1)*3 + 1
          I2 = I1  + 2
          C_INDEX(I1:I2) = CH4(2:4)

          IND =  IPAIR(I)/2
          WRITE(CH4,'(I4)') IND
          IF(IND.GT.999) CH4='9999'
          IF(CH4(3:3).EQ.' ') CH4(3:3) = '0' 
          IF(CH4(2:2).EQ.' ') CH4(2:2) = '0' 
          I1 = (I-1)*3 + 1
          I2 = I1  + 2
          C_PAIR(I1:I2) = CH4(2:4)
        ENDDO
      RETURN
      END

      SUBROUTINE CHECK_SYNONYM(IT,MON,MONN,ATOM,AATOM)
C ----------------------------
      INTEGER   IT
      CHARACTER MON*8,MONN*8,ATOM*4,AATOM*4
C ---
      INCLUDE 'lib_com.fh'
C ----------------------------

      IT = 2
      IF(LMS_NSYN.GE.MAXMLIST) RETURN
       
      IF(LMS_NSYN.GT.0) THEN
        DO I=1,LMS_NSYN
          IF(LMS_MNAME(I).EQ.MON .AND.LMS_AMNAME(I).EQ.MONN .AND.
     *       LMS_ATOM (I).EQ.ATOM.AND.LMS_AATOM (I).EQ.AATOM     )
     *    THEN
            IT = 1
            RETURN
          ENDIF 
        ENDDO
      ENDIF
      IT = 0
      RETURN
      END


      SUBROUTINE SET_VECTOR_L(IPAIR2)
C -----------------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24

      INTEGER*4 IPAIR2(*)
C ---------------------------------------------
      NA = MTC_NA2
      DO I=1,NA
        DO J=1,LENLIM
          DO K=1,ISYMBMAX
            MTC_VEC2(I,J,K) = 0
          ENDDO
        ENDDO
      ENDDO
C --
      LN = NA
      IF(LN.GT.LENLIM) LN = LENLIM

      DO I=1,NA
        IS = MTC_SYMB2(I)
        DO J=1,NA
          IF(I.NE.J) THEN
            JS = MTC_SYMB2(J)
            IF(J.GT.I) THEN
              IL = MTC_CONN(J,I)
            ELSE
              IL = MTC_CONN(I,J)
            ENDIF
            IF(IL.GT.0.AND.IL.LE.LN.AND.JS.GT.0.AND.JS.LE.ISYMBMAX)
     *      THEN
              MTC_VEC2(I,IL,JS) = MTC_VEC2(I,IL,JS) + 1
              MTC_INDEX2(IL)    = MTC_INDEX2(IL)    + 1
C            'C ','N ','O ',..
              IP = 0
              IF(IL.EQ.1) THEN
              IF(IS.EQ.1) THEN
                IF(JS.EQ.1) THEN
                  IP = 1
                ELSE IF(JS.EQ.2) THEN
                  IP = 2
                ELSE IF(JS.EQ.3) THEN
                  IP = 3
                ENDIF
              ELSE IF(IS.EQ.2) THEN
                IF(JS.EQ.1) THEN
                  IP = 2
                ELSE IF(JS.EQ.2) THEN
                  IP = 4
                ELSE IF(JS.EQ.3) THEN
                  IP = 5
                ENDIF
              ELSE IF(IS.EQ.3) THEN
                IF(JS.EQ.1) THEN
                  IP = 3
                ELSE IF(JS.EQ.2) THEN
                  IP = 5
                ELSE IF(JS.EQ.3) THEN
                  IP = 6
                ENDIF
              ENDIF
              ENDIF
              IF(IP.GT.0) IPAIR2(IP) = IPAIR2(IP) + 1
            ENDIF
          ENDIF
        ENDDO
      ENDDO
      RETURN
      END

      SUBROUTINE SET_VECTOR_C(IPAIR1)
C -----------------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24

      INTEGER*4 IPAIR1(*)
C ---------------------------------------------
      NA = MTC_NA1
      DO I=1,NA
        DO J=1,LENLIM
          DO K=1,ISYMBMAX
            MTC_VEC1(I,J,K) = 0
          ENDDO
        ENDDO
      ENDDO
C --
      LN = NA
      IF(LN.GT.LENLIM) LN = LENLIM

      DO I=1,NA
        IS = MTC_SYMB1(I)
        DO J=1,NA
          IF(I.NE.J) THEN
            JS = MTC_SYMB1(J)
            IF(I.GT.J) THEN
              IL = MTC_CONN(J,I)
            ELSE
              IL = MTC_CONN(I,J)
            ENDIF
            IF(IL.GT.0.AND.IL.LE.LN.AND.JS.GT.0.AND.JS.LE.ISYMBMAX)
     *      THEN
              MTC_VEC1(I,IL,JS) = MTC_VEC1(I,IL,JS) + 1
              MTC_INDEX1(IL)    = MTC_INDEX1(IL)    + 1
C            'C ','N ','O ',..
              IP = 0
              IF(IL.EQ.1) THEN
              IF(IS.EQ.1) THEN
                IF(JS.EQ.1) THEN
                  IP = 1
                ELSE IF(JS.EQ.2) THEN
                  IP = 2
                ELSE IF(JS.EQ.3) THEN
                  IP = 3
                ENDIF
              ELSE IF(IS.EQ.2) THEN
                IF(JS.EQ.1) THEN
                  IP = 2
                ELSE IF(JS.EQ.2) THEN
                  IP = 4
                ELSE IF(JS.EQ.3) THEN
                  IP = 5
                ENDIF
              ELSE IF(IS.EQ.3) THEN
                IF(JS.EQ.1) THEN
                  IP = 3
                ELSE IF(JS.EQ.2) THEN
                  IP = 5
                ELSE IF(JS.EQ.3) THEN
                  IP = 6
                ENDIF
              ENDIF
              ENDIF
              IF(IP.GT.0) IPAIR1(IP) = IPAIR1(IP) + 1
            ENDIF
          ENDIF
        ENDDO
      ENDDO
      RETURN
      END


       SUBROUTINE SET_TABCONN_C
C --------------------
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C ---------------------------------------------
       NA = MTC_NA1
       DO I=1,NA
C --1    I-I1     
         DO I1=1,NA
           IF(I.EQ.I1) GO TO 101
           IF(I.GT.I1) THEN
             IL1=MTC_CONN(I1,I)
           ELSE
             IL1=MTC_CONN(I,I1)
           ENDIF
           IF(IL1.EQ.1.AND.NA.GT.2) THEN
C --2        I-I1-I2     
             DO I2=1,NA
               IF(I.EQ.I2.OR.I1.EQ.I2) GO TO 102
               IF(I1.GT.I2) THEN
                 IL2=MTC_CONN(I2,I1)
               ELSE
                 IL2=MTC_CONN(I1,I2)
               ENDIF
               IF(IL2.EQ.1.AND.NA.GE.3) THEN
                 IF(I.GT.I2) THEN
                   IF(MTC_CONN(I2,I).EQ.0.OR.
     *             MTC_CONN(I2,I).GT.2) MTC_CONN(I2,I)=2 
                 ELSE
                   IF(MTC_CONN(I,I2).EQ.0.OR.
     *             MTC_CONN(I,I2).GT.2) MTC_CONN(I,I2)=2 
                 ENDIF
C --3          I-I1-I2-I3     
                 DO I3=1,NA
                   IF(I.EQ.I3.OR.I1.EQ.I3.OR.I2.EQ.I3) GO TO 103
                   IF(I2.GT.I3) THEN
                     IL3=MTC_CONN(I3,I2)
                   ELSE
                     IL3=MTC_CONN(I2,I3)
                   ENDIF
                   IF(IL3.EQ.1.AND.NA.GE.4) THEN
                     IF(I.GT.I3) THEN
                       IF(MTC_CONN(I3,I).EQ.0.OR. 
     *                 MTC_CONN(I3,I).GT.3)  
     *                 MTC_CONN(I3,I)=3 
                     ELSE
                       IF(MTC_CONN(I,I3).EQ.0.OR.
     *                 MTC_CONN(I,I3).GT.3)  
     *                 MTC_CONN(I,I3)=3 
                     ENDIF
C --4
                     DO I4=1,NA
                       IF(I.EQ.I4.OR.I1.EQ.I4.OR.I2.EQ.I4.OR. 
     *                 I3.EQ.I4) GO TO 104
                       IF(I3.GT.I4) THEN
                         IL4=MTC_CONN(I4,I3)
                       ELSE
                         IL4=MTC_CONN(I3,I4)
                       ENDIF
                       IF(IL4.EQ.1.AND.NA.GE.5) THEN
                         IF(I.GT.I4) THEN
                           IF(MTC_CONN(I4,I).EQ.0.OR.
     *                     MTC_CONN(I4,I).GT.4)  
     *                     MTC_CONN(I4,I)=4 
                         ELSE
                           IF(MTC_CONN(I,I4).EQ.0.OR. 
     *                     MTC_CONN(I,I4).GT.4)  
     *                     MTC_CONN(I,I4)=4 
                         ENDIF
C --5
                         DO I5=1,NA
                           IF(I.EQ.I5.OR.I1.EQ.I5.OR.I2.EQ.I5.OR.
     *                     I3.EQ.I5.OR.I4.EQ.I5) GO TO 105
                           IF(I4.GT.I5) THEN
                             IL5=MTC_CONN(I5,I4)
                           ELSE
                             IL5=MTC_CONN(I4,I5)
                           ENDIF
                           IF(IL5.EQ.1.AND.NA.GE.6) THEN
                             IF(I.GT.I5) THEN
                               IF(MTC_CONN(I5,I).EQ.0.OR. 
     *                         MTC_CONN(I5,I).GT.5)  
     *                         MTC_CONN(I5,I)=5 
                             ELSE
                               IF(MTC_CONN(I,I5).EQ.0.OR. 
     *                         MTC_CONN(I,I5).GT.5) 
     *                         MTC_CONN(I,I5)=5 
                             ENDIF
C --6
                             DO I6=1,NA
                               IF(I.EQ.I6.OR.I1.EQ.I6.OR.I2.EQ.I6.OR.
     *                         I3.EQ.I6.OR.I4.EQ.I6.OR.I5.EQ.I6) 
     *                         GO TO 106
                               IF(I5.GT.I6) THEN
                                 IL6=MTC_CONN(I6,I5)
                               ELSE
                                 IL6=MTC_CONN(I5,I6)
                               ENDIF
                               IF(IL6.EQ.1.AND.NA.GE.7) THEN
                                 IF(I.GT.I6) THEN
                                   IF(MTC_CONN(I6,I).EQ.0.OR.
     *                             MTC_CONN(I6,I).GT.6)
     *                             MTC_CONN(I6,I)=6 
                                 ELSE
                                   IF(MTC_CONN(I,I6).EQ.0.OR. 
     *                             MTC_CONN(I,I6).GT.6)
     *                             MTC_CONN(I,I6)=6 
                                 ENDIF
C --7
                                 DO I7=1,NA
                                   IF(I.EQ.I7.OR.I1.EQ.I7.OR.I2.EQ.I7
     *                             .OR.I3.EQ.I7.OR.I4.EQ.I7.OR. 
     *                             I5.EQ.I7.OR.I6.EQ.I7) GO TO 107
                                   IF(I6.GT.I7) THEN
                                     IL7=MTC_CONN(I7,I6)
                                   ELSE
                                     IL7=MTC_CONN(I6,I7)
                                   ENDIF
                                   IF(IL7.EQ.1.AND.NA.GE.8) THEN
                                     IF(I.GT.I7) THEN
                                       IF(MTC_CONN(I7,I).EQ.0.OR.
     *                                 MTC_CONN(I7,I).GT.7) 
     *                                 MTC_CONN(I7,I)=7 
                                     ELSE
                                       IF(MTC_CONN(I,I7).EQ.0.OR. 
     *                                 MTC_CONN(I,I7).GT.7)  
     *                                 MTC_CONN(I,I7)=7 
                                     ENDIF
C --8
                                     DO I8=1,NA
                                     IF(I.EQ.I8.OR.I1.EQ.I8.OR.I2.EQ.I8
     *                               .OR.I3.EQ.I8.OR.I4.EQ.I8.OR. 
     *                               I5.EQ.I8.OR.I6.EQ.I8.OR.I7.EQ.I8) 
     *                                 GO TO 108
                                       IF(I7.GT.I8) THEN
                                         IL8=MTC_CONN(I8,I7)
                                       ELSE
                                         IL8=MTC_CONN(I7,I8)
                                       ENDIF
                                       IF(IL8.EQ.1) THEN
                                         IF(I.GT.I8) THEN
                                           IF(MTC_CONN(I8,I).EQ.0.OR.
     *                                     MTC_CONN(I8,I).GT.8)
     *                                     MTC_CONN(I8,I)=8 
                                         ELSE
                                           IF(MTC_CONN(I,I8).EQ.0.OR.
     *                                     MTC_CONN(I,I8).GT.8)  
     *                                     MTC_CONN(I,I8)=8 
                                         ENDIF


                                       ENDIF
 108                                   CONTINUE
                                     ENDDO
C --8
                                   ENDIF
 107                               CONTINUE
                                 ENDDO
C --7
                               ENDIF
 106                           CONTINUE
                             ENDDO
C --6
                           ENDIF
 105                       CONTINUE
                         ENDDO
C --5
                       ENDIF
 104                   CONTINUE
                     ENDDO
C --4
                   ENDIF
 103               CONTINUE
                 ENDDO
C --3
               ENDIF
 102           CONTINUE
             ENDDO
C --2
           ENDIF
 101       CONTINUE
         ENDDO
C --1    
       ENDDO

       RETURN
       END

       SUBROUTINE SET_TABCONN_L
C --------------------
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C ---------------------------------------------
       NA=MTC_NA2
       DO I=1,NA
C --1    I-I1     
         DO I1=1,NA
           IF(I.EQ.I1) GO TO 201
           IF(I1.GT.I) THEN
             IL1=MTC_CONN(I1,I)
           ELSE
             IL1=MTC_CONN(I,I1)
           ENDIF
           IF(IL1.EQ.1.AND.NA.GT.2) THEN
C --2        I-I1-I2     
             DO I2=1,NA
               IF(I.EQ.I2.OR.I1.EQ.I2) GO TO 202
               IF(I2.GT.I1) THEN
                 IL2=MTC_CONN(I2,I1)
               ELSE
                 IL2=MTC_CONN(I1,I2)
               ENDIF
               IF(IL2.EQ.1.AND.NA.GE.3) THEN
                 IF(I2.GT.I) THEN
                   IF(MTC_CONN(I2,I).EQ.0.OR. 
     *             MTC_CONN(I2,I).GT.2) 
     *             MTC_CONN(I2,I)=2 
                 ELSE
                   IF(MTC_CONN(I,I2).EQ.0.OR.
     *             MTC_CONN(I,I2).GT.2) 
     *             MTC_CONN(I,I2)=2 
                 ENDIF
C --3          I-I1-I2-I3     
                 DO I3=1,NA
                   IF(I.EQ.I3.OR.I1.EQ.I3.OR.I2.EQ.I3) GO TO 203
                   IF(I3.GT.I2) THEN
                     IL3=MTC_CONN(I3,I2)
                   ELSE
                     IL3=MTC_CONN(I2,I3)
                   ENDIF
                   IF(IL3.EQ.1.AND.NA.GE.4) THEN
                     IF(I3.GT.I) THEN
                       IF(MTC_CONN(I3,I).EQ.0.OR.
     *                 MTC_CONN(I3,I).GT.3) 
     *                 MTC_CONN(I3,I)=3 
                     ELSE
                       IF(MTC_CONN(I,I3).EQ.0.OR. 
     *                 MTC_CONN(I,I3).GT.3) 
     *                 MTC_CONN(I,I3)=3 
                     ENDIF
C --4
                     DO I4=1,NA
                       IF(I.EQ.I4.OR.I1.EQ.I4.OR.I2.EQ.I4.OR. 
     *                 I3.EQ.I4) GO TO 204
                       IF(I4.GT.I3) THEN
                         IL4=MTC_CONN(I4,I3)
                       ELSE
                         IL4=MTC_CONN(I3,I4)
                       ENDIF
                       IF(IL4.EQ.1.AND.NA.GE.5) THEN
                         IF(I4.GT.I) THEN
                           IF(MTC_CONN(I4,I).EQ.0.OR. 
     *                     MTC_CONN(I4,I).GT.4) 
     *                     MTC_CONN(I4,I)=4 
                         ELSE
                           IF(MTC_CONN(I,I4).EQ.0.OR. 
     *                     MTC_CONN(I,I4).GT.4) 
     *                     MTC_CONN(I,I4)=4 
                         ENDIF
C --5
                         DO I5=1,NA
                           IF(I.EQ.I5.OR.I1.EQ.I5.OR.I2.EQ.I5.OR.
     *                     I3.EQ.I5.OR.I4.EQ.I5) GO TO 205
                           IF(I5.GT.I4) THEN
                             IL5=MTC_CONN(I5,I4)
                           ELSE
                             IL5=MTC_CONN(I4,I5)
                           ENDIF
                           IF(IL5.EQ.1.AND.NA.GE.6) THEN
                             IF(I5.GT.I) THEN
                               IF(MTC_CONN(I5,I).EQ.0.OR. 
     *                         MTC_CONN(I5,I).GT.5) 
     *                         MTC_CONN(I5,I)=5 
                             ELSE
                               IF(MTC_CONN(I,I5).EQ.0.OR. 
     *                         MTC_CONN(I,I5).GT.5) 
     *                         MTC_CONN(I,I5)=5 
                             ENDIF
C --6
                             DO I6=1,NA
                               IF(I.EQ.I6.OR.I1.EQ.I6.OR.I2.EQ.I6.OR.
     *                         I3.EQ.I6.OR.I4.EQ.I6.OR.I5.EQ.I6) 
     *                         GO TO 206
                               IF(I6.GT.I5) THEN
                                 IL6=MTC_CONN(I6,I5)
                               ELSE
                                 IL6=MTC_CONN(I5,I6)
                               ENDIF
                               IF(IL6.EQ.1.AND.NA.GE.7) THEN
                                 IF(I6.GT.I) THEN
                                   IF(MTC_CONN(I6,I).EQ.0.OR. 
     *                             MTC_CONN(I6,I).GT.6) 
     *                             MTC_CONN(I6,I)=6 
                                 ELSE
                                   IF(MTC_CONN(I,I6).EQ.0.OR. 
     *                             MTC_CONN(I,I6).GT.6) 
     *                             MTC_CONN(I,I6)=6 
                                 ENDIF
C --7
                                 DO I7=1,NA
                                   IF(I.EQ.I7.OR.I1.EQ.I7.OR.I2.EQ.I7
     *                             .OR.I3.EQ.I7.OR.I4.EQ.I7.OR. 
     *                             I5.EQ.I7.OR.I6.EQ.I7) GO TO 207
                                   IF(I7.GT.I6) THEN
                                     IL7=MTC_CONN(I7,I6)
                                   ELSE
                                     IL7=MTC_CONN(I6,I7)
                                   ENDIF
                                   IF(IL7.EQ.1.AND.NA.GE.8) THEN
                                     IF(I7.GT.I) THEN
                                       IF(MTC_CONN(I7,I).EQ.0.OR. 
     *                                 MTC_CONN(I7,I).GT.7) 
     *                                 MTC_CONN(I7,I)=7 
                                     ELSE
                                       IF(MTC_CONN(I,I7).EQ.0.OR. 
     *                                 MTC_CONN(I,I7).GT.7) 
     *                                 MTC_CONN(I,I7)=7 
                                     ENDIF
C --8
                                     DO I8=1,NA
                                     IF(I.EQ.I8.OR.I1.EQ.I8.OR.I2.EQ.I8
     *                               .OR.I3.EQ.I8.OR.I4.EQ.I8.OR. 
     *                               I5.EQ.I8.OR.I6.EQ.I8.OR.I7.EQ.I8) 
     *                                 GO TO 208
                                       IF(I8.GT.I7) THEN
                                         IL8=MTC_CONN(I8,I7)
                                       ELSE
                                         IL8=MTC_CONN(I7,I8)
                                       ENDIF
                                       IF(IL8.EQ.1) THEN
                                         IF(I8.GT.I) THEN
                                           IF(MTC_CONN(I8,I).EQ.0.OR. 
     *                                     MTC_CONN(I8,I).GT.8) 
     *                                     MTC_CONN(I8,I)=8 
                                         ELSE
                                           IF(MTC_CONN(I,I8).EQ.0.OR. 
     *                                     MTC_CONN(I,I8).GT.8) 
     *                                     MTC_CONN(I,I8)=8 
                                         ENDIF


                                       ENDIF
 208                                   CONTINUE
                                     ENDDO
C --8
                                   ENDIF
 207                               CONTINUE
                                 ENDDO
C --7
                               ENDIF
 206                           CONTINUE
                             ENDDO
C --6
                           ENDIF
 205                       CONTINUE
                         ENDDO
C --5
                       ENDIF
 204                   CONTINUE
                     ENDDO
C --4
                   ENDIF
 203               CONTINUE
                 ENDDO
C --3
               ENDIF
 202           CONTINUE
             ENDDO
C --2
           ENDIF
 201       CONTINUE
         ENDDO
C --1    
       ENDDO


C ------------------
       RETURN
       END

      SUBROUTINE COMP_VECTOR
C --------------------
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C ---------------------------------------------
      ND = ABS(MTC_NA2-MTC_NA1)
      IF(MTC_NA2.LT.5.AND.ND.GT.0) THEN
        ND = 1
      ELSE IF(MTC_NA2.LT.10.AND.ND.GT.1) THEN
        ND = 2
      ELSE IF(ND.GT.10) THEN
        ND = 10
      ENDIF

      DO I=1,MTC_NA1
        MTC_NEQUIV(I) = 0
      ENDDO

      DO I1=1,MTC_NA1

        DO I2=1,MTC_NA2
          IF(MTC_SYMB1(I1).EQ.MTC_SYMB2(I2)) THEN
            IDEL = 0
            DO I=1,ISYMBMAX
              DO J=1,LENLIM
                IDEL = IDEL + ABS(MTC_VEC1(I1,J,I)-MTC_VEC2(I2,J,I))
              ENDDO
            ENDDO
            IF(IDEL.LE.ND) THEN
              MTC_NEQUIV(I1)    = MTC_NEQUIV(I1)+1
              II                = MTC_NEQUIV(I1)
              MTC_IEQUIV(II,I1) = I2
              MTC_DELTA (II,I1) = IDEL
            ENDIF
          ENDIF
        ENDDO

      ENDDO 

C ---------
      RETURN
      END

      SUBROUTINE CHECK_EQUIV(MDOC,N_NEW,IFLAG,ISCORE,IERR)
C --------------------
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C --------------------
C     CHARACTER LINE*80
C --------------------
      IERR = 0
C ---
C
C     now MTC_SYMB1() - pointer to defined atoms in MTC_...1
C
      N_NEW_OLD = N_NEW
      IONE      = 0
      IDELTA    = 1000
      IFLAG     = 0
      NMIN      = 1000
      IMIN      = 0
      DO I=1,MTC_NA1
        IF(MTC_NEW(I).EQ.0) THEN
          IF(MTC_NEQUIV(I).EQ.0) THEN
            IERR = 3
            RETURN
          ENDIF
          IF(MTC_NEQUIV(I).LT.NMIN) THEN
            NMIN = MTC_NEQUIV(I)
            IMIN = I
          ENDIF
          IF(MTC_NEQUIV(I).EQ.1) THEN
            IF(IONE.EQ.0) THEN
              IONE   = I
              IDELTA = MTC_DELTA(1,IONE)
            ELSE IF(MTC_DELTA(1,I).LT.IDELTA) THEN
              IONE   = I
              IDELTA = MTC_DELTA(1,IONE)
            ELSE IF(MTC_DELTA(1,I).EQ.IDELTA) THEN
              J = MTC_IEQUIV(1,I)
              IF(MTC_NAME1(I).EQ.MTC_NAME2(J)) THEN
                IONE   = I
                IDELTA = MTC_DELTA(1,IONE)
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
      IF(IONE.GT.0) THEN
        MTC_NEW(IONE) = MTC_IEQUIV(1,IONE)
        ISCORE        = ISCORE + IDELTA

C        WRITE(LINE,'(I3,'' = '',I3,''( 1 )'',I3)') 
C     *  IONE,MTC_NEW(IONE),ISCORE
C        CALL MSGERR(MDOC,LINE)

        GO TO 100
      ENDIF
C ----------
      NE = MTC_NEQUIV(IMIN)
      NN = N_NEW
      IF(NN.GT.0) THEN
        ISUM_MIN = 100000
        IDELTA   = 1000
        JMIN     = 0
        DO I=1,NE
          IF(MTC_DELTA(I,IMIN).LE.IDELTA) THEN
            ISUM = 0
            II   = MTC_IEQUIV(I,IMIN)
            DO J=1,NN
              J1 = MTC_SYMB1(J)
              J2 = MTC_NEW(J1)
C -1-
              IF(IMIN.GT.J1) THEN
                IDIST1 = MTC_CONN(J1,IMIN)
              ELSE
                IDIST1 = MTC_CONN(IMIN,J1)
              ENDIF
C -2-
              IF(J2.GT.II) THEN
                IDIST2 = MTC_CONN(J2,II)
              ELSE
                IDIST2 = MTC_CONN(II,J2)
              ENDIF

              ISUM = ISUM + ABS(IDIST1-IDIST2)

            ENDDO

            IF(MTC_DELTA(I,IMIN).LT.IDELTA) THEN

              IA_MIN   = I
              IDELTA   = MTC_DELTA(I,IMIN)
              ISUM_MIN = ISUM

            ELSE IF(MTC_DELTA(I,IMIN).EQ.IDELTA) THEN

              IF(ISUM.LE.ISUM_MIN) THEN
                IF(ISUM.LT.ISUM_MIN) THEN
                  ISUM_MIN = ISUM
                  IA_MIN   = I                
                ELSE IF(MTC_NAME1(IMIN).EQ.MTC_NAME2(II)) THEN
                  ISUM_MIN = ISUM
                  IA_MIN   = I
                ENDIF
              ENDIF
             
            ENDIF

          ENDIF

        ENDDO

        IONE          = IMIN
        MTC_NEW(IONE) = MTC_IEQUIV(IA_MIN,IONE)
        ISCORE        = ISCORE + MTC_DELTA(IA_MIN,IMIN)

C        WRITE(LINE,'(I3,'' = '',I3,''('',I3,'' )'',I3)') 
C     *  IONE,MTC_NEW(IONE),IA_MIN,ISCORE
C        CALL MSGERR(MDOC,LINE)

      ELSE
        IA     = 0
        IDELTA = 1000
        DO I=1,NE
          II = MTC_IEQUIV(I,IMIN)
          IF(MTC_DELTA(I,IMIN).LT.IDELTA) THEN
            IDELTA = MTC_DELTA(I,IMIN)
            IA     = I
          ELSE IF(MTC_DELTA(I,IMIN).EQ.IDELTA) THEN
            IF(MTC_NAME1(IMIN).EQ.MTC_NAME2(II)) THEN
              IA     = I
              IDELTA = MTC_DELTA(I,IMIN)
            ENDIF
          ENDIF
        ENDDO

        IONE          = IMIN
        MTC_NEW(IMIN) = MTC_IEQUIV(IA,IMIN)
        ISCORE        = ISCORE + IDELTA

C        WRITE(LINE,'(I3,'' = '',I3,''('',I3,'' )'',I3)') 
C     *  IONE,MTC_NEW(IONE),IA,ISCORE
C        CALL MSGERR(MDOC,LINE)

      ENDIF
C ----------
 100  CONTINUE
      DO I=1,MTC_NA1-1
        DO J=I+1,MTC_NA1
          IF(MTC_NEW(I).NE.0.AND.MTC_NEW(I).EQ.MTC_NEW(J)) THEN
            IERR = 4
            RETURN
          ENDIF
        ENDDO
      ENDDO
      N_NEW = 0
      DO I=1,MTC_NA1
        IF(MTC_NEW(I).EQ.0.AND.MTC_NEQUIV(I).GT.0) THEN
          JJ = 0
          NN = MTC_NEQUIV(I)
          DO J=1,NN
            IF(MTC_IEQUIV(J,I).NE.MTC_NEW(IONE)) THEN
              JJ = JJ+1
              MTC_IEQUIV(JJ,I) = MTC_IEQUIV(J,I)
              MTC_DELTA (JJ,I) = MTC_DELTA (J,I)
            ELSE
              MTC_NEQUIV(I) = MTC_NEQUIV(I)-1

C        WRITE(LINE,'(I3,'' REMOVE '',I3,'' now nequiv  '',I3)') 
C     *  I,MTC_NEW(IONE),MTC_NEQUIV(I)
C        CALL MSGERR(MDOC,LINE)

            ENDIF
          ENDDO
        ENDIF
        IF(MTC_NEW(I).GT.0) THEN
          N_NEW = N_NEW+1
          MTC_SYMB1(N_NEW) = I 
        ENDIF
      ENDDO
      IF(N_NEW.GT.N_NEW_OLD) IFLAG = 1
C --------------------
      RETURN
      END

      SUBROUTINE TEST_GM(MDOC,LIST,SRCH
     *              ,NAC,C_CONTENT,C_INDEX,C_PAIR,IERR)
C -------------------------------------
      INTEGER MEMORY
      PARAMETER (MEMORY  =  1 000 000)
C ----
      INTEGER*2 IPOOL(MEMORY)
C -------------------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---
C -------------------------------------------
      INTEGER MAXMPONTER
      PARAMETER (MAXMPONTER = 3500)
      INTEGER MAXMPOOL
      PARAMETER (MAXMPOOL = 600 000)
      INTEGER   MATCH_POINTER(MAXMPONTER)
      INTEGER*2 MATCH_POOL   (MAXMPOOL)
      COMMON /COM_MATCH_POOL/ MEM_TOT,MATCH_NMON
     *                       ,MATCH_POINTER,MATCH_POOL
C ------------------------------------------
C     IP = MATCH_POINTER(I) 
C       MATCH_POOL(IP  ) = IMON 
C       MATCH_POOL(IP+1) = NATOM  
C       MATCH_POOL(IP+2) = NBOND
C
C       MATCH_POOL(IP+3) = ICONTENT(I) 
C       . . . . . 
C       MATCH_POOL(IP+17) = ICONTENT(I) 
C 'C ','N ','O ','S ','P ','CO','MG','CA','ZN','CU','FE','CL','MN','MO','  '
C  1    2    3    4    5    6    7    8    9    10   11   12   13   14   15
C  
C       IPA = IP + 17
C       MATCH_POOL(IPA+1) = IATOM
C       MATCH_POOL(IPA+2) = IATYPE
C
C       IPB = IB + 17 + 2*NATOM
C       MATCH_POOL(IPA+1) = IATOM1
C       MATCH_POOL(IPA+1) = IATOM2
C       MATCH_POOL(IPA+1) = IBTYPE
C
C       0-dumm,1-sing,2-doub,3-trip,4-arom,5-delo,6-meta,7-cova
C
C ---------------------------------------------------------------
C -----------------------------------------------
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
C -----------------------------------------------
      CHARACTER LINE*256,MON*8,LIST*1,SRCH*1,MOD_R*1,MON_NEW*8
      CHARACTER MON_INP*8,NODIST*1
C ---------------------------------------------------------------
      M         = 99
      MON_INP   = L1L_MNAME
      CALL COPYL2(MDOC,IERR)

      L_BEST    = 0
      ILIB_BEST = 0
C     for complete matching  INDI_BEST = 0
C     INDI_BEST = 13
      INDI_BEST = 0
      INDP_BEST = 100000

      IF(SRCH.EQ.'G') GO TO 700

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC, '-----INDEX ---')
      ENDIF

      DO I=1,LMX_NMON 

        ND = ABS(NAC - LMX_NATOM(I))

C        IF(NAC.EQ.LMX_NATOM(I).OR.(NAC.GT.9.AND.ND.LE.2)) THEN
        IF(ND.LE.0) THEN

          CALL CALC_INDEX_DIFF(M,C_CONTENT,C_INDEX,C_PAIR
     *     ,LMX_CONTENT(I),LMX_INDEX(I),LMX_PAIR(I)
     *     ,IDIFFC,IDIFFI,IDIFFP,IERR)


          IF(IDIFFC.EQ.0) THEN

            IF(IDIFFI.EQ.0.AND.IDIFFP.EQ.0) THEN

C            IF((INDI_BEST.GT.IDIFFI).OR.
C     *         (INDI_BEST.EQ.IDIFFI.AND.
C     *          INDP_BEST.GT.IDIFFP     )) THEN

              IF(LIST.EQ.'T') THEN
            write(line,'(''-->'',I4,'';'',A,'';'',A30,'';'',A24,'';'')')
     *        LMX_NATOM(I),LMX_MNAME(I),LMX_CONTENT(I),LMX_INDEX(I)
              CALL MSGDOC(MDOC,LINE)
              write(line,'(''          :'',A24,'';'',3I4)')
     *        LMX_PAIR(I),IDIFFC,IDIFFI,IDIFFP
              CALL MSGDOC(MDOC,LINE)
              ENDIF

              DO L=1,LML_NMON
                IF(LMX_MNAME(I).EQ.LML_MNAME(L)) THEN
                  GO TO 400
                ENDIF     
              ENDDO

              GO TO 300

 400          CONTINUE

              L_BEST    = I
              ILIB_BEST = L
              INDI_BEST = IDIFFI
              INDP_BEST = IDIFFP
              GO TO 200

            ENDIF
          ENDIF
        ENDIF

 300    CONTINUE

      ENDDO

 200  CONTINUE

      IF(L_BEST.GT.0) THEN

        I       = L_BEST
        L       = ILIB_BEST
        MON_NEW = LMX_MNAME(I) 
        LINE = ' WARNING : monomer looks like '//LMX_MNAME(I)
     *        //'program will use this one' 
        CALL MSGDOC(MDOC,LINE)
C        IF(LML_FUSE(L).EQ.'N') THEN
C         read mon_lib.cif
C          LML_FUSE(L) = 'R'
C          MOD_R       = 'M'
C          CALL READ_LIB(M,MOD_R,LIST,IERR)
C          IF(IERR.NE.0) RETURN
C        ENDIF
C        CALL CP_MLIB(MDOC,MON_NEW,IERR)
C        IF(IERR.NE.0) RETURN
C
C        L1L_MNAME  = MON_INP
C        L1L_MNAME2 = MON_INP
C        L1L_NAME   = '.'

        DO IM=1,MATCH_NMON
          IP   = MATCH_POINTER(IM)
          IMON = MATCH_POOL(IP  )
          MON  = LML_MNAME(IMON)
          IF(MON.EQ.MON_NEW) THEN
            IMS = IM
            IMF = IM
            GO TO 500
          ENDIF
        ENDDO
      ELSE
        IERR = 1
      ENDIF
C ------------------------------------------

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '--after index srch',srch,ierr
        CALL MSGDOC(MDOC,LINE)
      ENDIF

      IF(SRCH.NE.'A') RETURN

      IERR = 0

 700  CONTINUE

      IMS = 1
      IMF = MATCH_NMON
 500  CONTINUE
C ---
      IDIRECT = 0

      IPT   = MATCH_POINTER(MATCH_NMON+1)
      IMONT = MATCH_POOL(IPT  )
      N     = MATCH_POOL(IPT+1)
      NE    = MATCH_POOL(IPT+2)

      I_MU  = 1
      I_IE  = I_MU  + N
 
      IPA = IPT + 17
      J   = 0
      DO IA=1,N
        J = J + 2
        IPOOL(I_MU -1 + IA) = MATCH_POOL(IPA+J) 
      ENDDO

      IPB = IPT + 17 + 2*N
      J   = 0
      DO IB=1,NE
        J = J + 1
        IPOOL(I_IE -1 + J) = MATCH_POOL(IPB+J) 
        J = J + 1
        IPOOL(I_IE -1 + J) = MATCH_POOL(IPB+J) 
        J = J + 1
        IPOOL(I_IE -1 + J) = 1 
      ENDDO

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '----- N MATCH ---:',N,MATCH_NMON
        CALL MSGDOC(MDOC,LINE)
        write(LINE,*) '--:',ipt,imont,n,ne 
        CALL MSGDOC(MDOC,LINE)
      ENDIF

      DO IM=IMS,IMF

        IP  = MATCH_POINTER(IM)

        IMON = MATCH_POOL(IP  )
        MON  = LML_MNAME(IMON)
        M    = MATCH_POOL(IP+1)
        NEI  = MATCH_POOL(IP+2)  

        

        IF(M.GE.N.AND.MON.NE.MON_INP) THEN
C ---
          IPT_C = IPT + 2
          IP_C  = IP  + 2
          DO IC=1,15
            IF(MATCH_POOL(IPT_C+IC).GT.MATCH_POOL(IP_C+IC)) GO TO 100
          ENDDO
C --- 
          MEM = 2*N + M + 3*NE + 3*NEI + N*(N+1)*M
          IF(MEM.GT.MEMORY) THEN
            IF(LIST.EQ.'T') THEN
              WRITE(LINE,*) '--- not memory enough :',MON,IM
              CALL MSGDOC(MDOC,LINE)
            ENDIF
            GO TO 100
          ENDIF 

          I_MUI = I_IE  + NE*3
          I_IEI = I_MUI + M
          I_ISO = I_IEI + NEI*3
          I_IP  = I_ISO + N
C ---
          IPA = IP + 17
          J   = 0
          DO IA=1,M
            J = J + 2
            IPOOL(I_MUI -1 + IA) = MATCH_POOL(IPA+J) 
          ENDDO

          IPB = IP + 17 + 2*M
          J   = 0
          DO IB=1,NEI
            J = J + 1
            IPOOL(I_IEI -1 + J) = MATCH_POOL(IPB+J) 
            J = J + 1
            IPOOL(I_IEI -1 + J) = MATCH_POOL(IPB+J) 
            J = J + 1
            IPOOL(I_IEI -1 + J) = 1 
          ENDDO
C --- 
          CALL GM_ULLMAN(N,NE,M,NEI,IDIRECT
     *     ,IPOOL(I_MU),IPOOL(I_MUI),IPOOL(I_IE),IPOOL(I_IEI)
     *     ,I,IPOOL(I_ISO),IPOOL(I_IP))
C ---
          IF(I.GT.N) THEN

            IF(LIST.EQ.'T') THEN
            WRITE(LINE,*) '=========',IM,' ==== ',MON,' ====='
            CALL MSGDOC(MDOC,LINE)
            DO J=1,N
              WRITE(LINE,*) J,' I_mu --> I_mui',IPOOL(I_ISO + J - 1) 
              CALL MSGDOC(MDOC,LINE)
            ENDDO
            ENDIF

            LINE = ' INFO: sub_structure in :'//MON
            CALL MSGDOC(MDOC,LINE)
            GO TO 600
          ENDIF

        ENDIF
 100    CONTINUE
      ENDDO
      CALL MSGDOC(MDOC,' INFO:  no sub_structure was found' )
      IERR = 1
      RETURN
C -------------------------------------
 600  CONTINUE
      CALL COPYL2(MDOC,IERR)
      DO L=1,LML_NMON
        IF(MON.EQ.LML_MNAME(L)) THEN
          GO TO 610
        ENDIF     
      ENDDO
      IERR = 1
      RETURN
 610  CONTINUE

      IF(LML_FUSE(L).EQ.'N') THEN
C       read mon_lib.cif
        LML_FUSE(L) = 'R'
        MOD_R       = 'M'
        NODIST      = 'N'
        CALL READ_LIB(M,MOD_R,NODIST,LIST,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      CALL CP_MLIB(MDOC,MON,IERR)
      IF(IERR.NE.0) RETURN

      L1L_MNAME  = MON_INP
      L1L_MNAME2 = MON_INP
      L1L_NAME   = '.'
      IF(M.NE.N) THEN
        L1L_TYPE  = 'non-polymer'
      ENDIF
C ---
C     atom's number
      IPT   = MATCH_POINTER(MATCH_NMON+1)
      IPA = IPT + 17
      J   = -1
      DO IA=1,N
        J = J + 2
        IPOOL(I_IE -1 + IA) = MATCH_POOL(IPA+J) 
      ENDDO
C ---
C     atom's number
      IP  = MATCH_POINTER(IM)
      IPA = IP + 17
      J   = -1
      DO IA=1,M
        J = J + 2
        IPOOL(I_IEI -1 + IA) = MATCH_POOL(IPA+J) 
      ENDDO
C ---

      CALL CORR_DESCRIPTION_GM(MDOC,LIST,N,M
     *,IPOOL(I_MU),IPOOL(I_IE),IPOOL(I_MUI),IPOOL(I_IEI),IPOOL(I_ISO)
     *,IERR)                       
C       NU             NP        MU           MP          ISO
C ---
C     atom_names L2 -> L1, remove other atoms.
C -- 
C     atom's number: 
c     IPOOL(I_IE) IPOOL(I_IEI)
C       NP           MP
C
c     IPOOL(I_MU) IPOOL(I_MUI) ,IPOOL(I_ISO)
c       NU           MU           ISO
c       N            M
c      ISO - isomorphism  /  NU(i) = MU(ISO(i)) /
C      NP(I) ->L2   MP(I) ->L1      
C ---  
C -------------------------------------
      RETURN
      END

      SUBROUTINE GM_ULLMAN(N,NE,M,NEI,IDIRECT
     *                    ,MU,MUI,IE,IEI,I,ISO,IP)
C -------------------------------------
C      SUBROUTINE GM_ULLMAN(N,NE,M,NEI,IDIRECT
C     *                    ,MU,MUI,IE,IEI,I,ISO,IP)
C ----------
C   Graph_matching_Ullmann_algorithm   
C ----------
C                    n           m        n =< m
C list of atoms     MU          MUI (*) labels
C N of bonds        NE          NEI
C list of bonds     IE          IEI (3,*) I1,I2,label
C
C output: OK if I > n else not found isomorphous graph.
C         ISO - isomorphism  /  MU(i) = MUI(ISO(i)) /
C
C -------------------------------------
      INTEGER*2 MU(*),MUI(*),IE(3,*),IEI(3,*),ISO(*),IP(N,M,*)
C -------------------------------------
c      write(*,*) '-----N:',n
c      DO K=1,N
c        write(*,*) k,mu(k)
c      enddo
c      write(*,*) '-----M:',m
c      DO K=1,M
c        write(*,*) k,mui(k)
c      enddo
c      write(*,*) '-----'


      DO K=1,N
      DO L=1,M
        IF(MU(K).EQ.MUI(L)) THEN
          IP(K,L,1) = 1
        ELSE
          IP(K,L,1) = 0
        ENDIF
      ENDDO
      ENDDO
      I = 1
      J = 1
C ---------
 100  CONTINUE
      IF(I.GT.N) RETURN

      IF(IP(I,J,I).NE.0) THEN

        ISO(I) = J

        DO K=1,N
        DO L=1,M
          IP(K,L,I+1) = IP(K,L,I)
          IF(K.GT.I.AND.L.EQ.J) IP(K,L,I+1) = 0
        ENDDO
        ENDDO

        CALL FORWARD_CHECK_GM(I,N,NE,M,NEI,IDIRECT
     *                            ,IE,IEI,ISO,IP,IFLAG)

        IF(IFLAG.EQ.0) THEN
          I = I + 1
          J = 1
        ELSE
          J = ISO(I)
          J = J + 1
       ENDIF

      ELSE
        J = J + 1
      ENDIF
      IF(J.GT.M) THEN
        IF(I.LE.1) RETURN        
        I = I -1
        J = ISO(I)
        J = J + 1
      ENDIF    
      GO TO 100
C -------------------------------------
      END

      SUBROUTINE FORWARD_CHECK_GM(I,N,NE,M,NEI,IDIRECT
     *                            ,IE,IEI,ISO,IP,IFLAG)
C -------------------------------------
      INTEGER*2 IE(3,*),IEI(3,*),ISO(*),IP(N,M,*)
C -------------------------------------
      DO K=I+1,N
      DO L=1,M

        IF(IP(K,L,I+1).GT.0) THEN

          DO IS=1,I
            IWS = ISO(IS)
C       ---
          IFLAG1 = 0
          DO KE=1,NE
            IF((IE(1,KE).EQ.K.AND.IE(2,KE).EQ.IS).OR.
     *         (IDIRECT.EQ.0.AND.
     *          IE(2,KE).EQ.K.AND.IE(1,KE).EQ.IS))THEN

              IFLAG1 =-1
                
              DO JE=1,NEI

                IF((IEI(1,JE).EQ.L.AND.IEI(2,JE).EQ.IWS).OR.
     *             (IDIRECT.EQ.0.AND.
     *              IEI(2,JE).EQ.L.AND.IEI(1,JE).EQ.IWS)) THEN
                  IF(IE(3,KE).EQ.IEI(3,JE)) THEN
                    IFLAG1 = 1
                    GO TO 100
                  ENDIF
                ENDIF
              ENDDO 
            ENDIF
          ENDDO

 100      CONTINUE

C       ---
          IFLAG2 = 0
          DO JE=1,NEI
            IF((IEI(1,JE).EQ.L.AND.IEI(2,JE).EQ.IWS).OR.
     *         (IDIRECT.EQ.0.AND.
     *          IEI(2,JE).EQ.L.AND.IEI(1,JE).EQ.IWS)) THEN

              IFLAG2 =-1

              DO KE=1,NE

                IF((IE(1,KE).EQ.K.AND.IE(2,KE).EQ.IS).OR.
     *             (IDIRECT.EQ.0.AND.
     *              IE(2,KE).EQ.K.AND.IE(1,KE).EQ.IS)) THEN
                  IF(IE(3,KE).EQ.IEI(3,JE)) THEN
                    IFLAG2 = 1
                    GO TO 200
                  ENDIF
                ENDIF
              ENDDO 
            ENDIF
          ENDDO

 200      CONTINUE

          ENDDO

          IF(IFLAG1.EQ.1.AND.IFLAG2.EQ.1) THEN
            IP(K,L,I+1) = 1
          ELSE IF(IFLAG1.EQ.-1.OR.IFLAG2.EQ.-1) THEN
            IP(K,L,I+1) = 0
          ENDIF
C       ---
 300      CONTINUE          
        ENDIF

      ENDDO
      ENDDO
C ----      
      IFLAG = 0
      DO K=1,N
        DO L=1,M
          IF(IP(K,L,I+1).GT.0) GO TO 400
        ENDDO
        IFLAG = 1
        RETURN
 400    CONTINUE
      ENDDO
C ----
      RETURN
C -------------------------------------
      END

      SUBROUTINE CORR_DESCRIPTION_GM(MDOC,LIST,N,M,NU,NP,MU,MP,ISO,IERR)
C --------------------------------------------------------
C     atom_names L2 -> L1, remove other atoms.
C -- 
C     atom's number: 
c     IPOOL(I_IE) IPOOL(I_IEI)
C       NP           MP
C
c     IPOOL(I_MU) IPOOL(I_MUI) ,IPOOL(I_ISO)
c       NU           MU           ISO
c       N            M
c      ISO - isomorphism  /  NU(i) = MU(ISO(i)) /
C      NP(I) ->L2   MP(I) ->L1      
C ---  
C     I --> IP = NP(I)   ISO(I) --> J --> JP --> MP(J)
C           !                             ! 
C           V                             V
C          L2A_                          L1A_
C ---------------------------------------------------------
      INTEGER   MDOC,N,M,IERR
      INTEGER*2 NU(*),NP(*),MU(*),MP(*),ISO(*)
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,LIST*1,SYMB*4,ATOM*4,ATOM_NEW*4,TREE*1
C ---
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C ---------------------------------------------------------------
      M = 99
C ----
      DO I=1,L1A_NATOM
        L1A_ICR(I) = 0   
      ENDDO
      DO I=1,L2A_NATOM
        L2A_ICR(I) = 0   
      ENDDO
      CALL SET_NUM_L1_GM(MDOC,IERR)
      CALL SET_NUM_L2_GM(MDOC,IERR)
C ----
      DO JP=1,L1A_NATOM
        DO J=1,M
          IF(JP.EQ.MP(J)) THEN
            DO I=1,N
              IF(ISO(I).EQ.J) THEN
                L1A_ICR(JP)    = NP(I)
                L2A_ICR(NP(I)) = JP
                GO TO 100
              ENDIF 
            ENDDO
          ENDIF
        ENDDO
 100    CONTINUE
      ENDDO
C ----

      IF(LIST.EQ.'T') THEN
        line = ' --- l1 --  CORR_DESCRIPTION_GM:'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,L1A_NATOM
          write(line,
     *    '(i2,1x,a,1x,i4)')
     *     ia,l1a_aname(ia),L1A_icr(Ia)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        DO    I=1,L1B_Nbond
          write(line,'(i2,1x,a,1x,a,1x,2i4)')
     *     i,l1b_1atm(i),L1b_2atm(I),l1b_i1atm(i),L1b_i2atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        IF(L1G_NANGL.GT.0) THEN
        DO    I=1,L1G_NANGL
          write(line,'(i2,1x,a,1x,a,1x,A,1X,3i4)')
     *     i,l1G_1atm(i),L1G_2atm(I),L1G_3atm(I)
     *     ,l1G_i1atm(i),L1G_i2atm(I),L1G_i3atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF

        line = ' --- l2 --  CORR_DESCRIPTION_GM:'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L2A_ISTART,L2A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,L2A_NATOM
          write(line,'(i2,1x,a,1x,i4)')ia,l2a_aname(ia),L2A_icr(Ia)
          CALL MSGDOC(MDOC,LINE)
        ENDDO

        DO    I=1,L2B_Nbond
          write(line,'(i2,1x,a,1x,a,1x,2i4)')
     *     i,l2b_1atm(i),L2b_2atm(I),l2b_i1atm(i),L2b_i2atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO

        line = ' --- iso-- CORR_DESCRIPTION_GM:'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) '  N,M:',n,m
        CALL MSGDOC(MDOC,LINE)

        DO    I=1,N
          write(line, '(2i4,1x,a,1x,2i4)')
     *     i,np(I),' -->',iso(i),mp(iso(i))
          CALL MSGDOC(MDOC,LINE)
        ENDDO

      ENDIF

C ----
      DO I=1,L1A_NATOM
        SYMB = L1A_SYMB(I)
        IF((SYMB(1:2).EQ.'H '.OR.SYMB(1:2).EQ.'D ').AND.
     *                                    L1B_NBOND.GT.0) THEN
          DO IB=1,L1B_NBOND
            IF((L1B_I1ATM(IB).EQ.I.AND.L1A_ICR(L1B_I2ATM(IB)).GT.0).OR.
     *         (L1B_I2ATM(IB).EQ.I.AND.L1A_ICR(L1B_I1ATM(IB)).GT.0))THEN
C --
              IF(L1B_I1ATM(IB).EQ.I) JP = L1B_I2ATM(IB)
              IF(L1B_I2ATM(IB).EQ.I) JP = L1B_I1ATM(IB)
              IP = L1A_ICR(JP) 

              IF(L2B_NBOND.GT.0) THEN
              DO K=1,L2B_NBOND
                KA = 0
                IF(L2B_I1ATM(K).EQ.IP) KA = L2B_I2ATM(K)
                IF(L2B_I2ATM(K).EQ.IP) KA = L2B_I1ATM(K)
                IF(KA.GT.0) THEN
                  SYMB = L2A_SYMB(KA)
                  IF((SYMB(1:2).EQ.'H '.OR.SYMB(1:2).EQ.'D ').AND.
     *                                            L2A_ICR(KA).EQ.0) THEN
                    L2A_ICR(KA) = I
                    L1A_ICR(I)  = KA
                    GO TO 200
                  ENDIF
                ENDIF
              ENDDO
              ENDIF
C --          
              L1A_ICR(I) = -1            
              GO TO 200
            ENDIF
          ENDDO
        ENDIF
 200    CONTINUE
      ENDDO
C ----
      DO IA=1,L1A_NATOM
        IF(L1A_ICR(IA).GE.0) THEN
          ATOM     = L1A_ANAME(IA) 
          ATOM_NEW = '????'
          IF(L1A_ICR(IA).GT.0) ATOM_NEW = L2A_ANAME(L1A_ICR(IA))
C ---
          DO JA=1,L1A_NATOM
            IF(L1A_IBACK(JA).EQ.IA) L1A_BACK(JA) = ATOM_NEW 
            IF(L1A_IFORW(JA).EQ.IA) L1A_FORW(JA) = ATOM_NEW 
          ENDDO
          IF(L1N_NCONN.GT.0) THEN
            DO I=1,L1N_NCONN
              IF(L1N_I1ATM(I).EQ.IA) L1N_1ATM(I) = ATOM_NEW
              IF(L1N_I2ATM(I).EQ.IA) L1N_2ATM(I) = ATOM_NEW
            ENDDO
          ENDIF

          IF(L1B_NBOND.GT.0) THEN 
            DO I=1,L1B_NBOND
              IF(L1B_I1ATM(I).EQ.IA) L1B_1ATM(I) = ATOM_NEW 
              IF(L1B_I2ATM(I).EQ.IA) L1B_2ATM(I) = ATOM_NEW  
            ENDDO
          ENDIF
          IF(L1G_NANGL.GT.0) THEN
            DO I=1,L1G_NANGL
              IF(L1G_I1ATM(I).EQ.IA) L1G_1ATM(I) = ATOM_NEW
              IF(L1G_I2ATM(I).EQ.IA) L1G_2ATM(I) = ATOM_NEW
              IF(L1G_I3ATM(I).EQ.IA) L1G_3ATM(I) = ATOM_NEW
            ENDDO
          ENDIF
          IF(L1T_NTORS.GT.0) THEN 
            DO I=1,L1T_NTORS 
              IF(L1T_I1ATM(I).EQ.IA) L1T_1ATM(I) = ATOM_NEW 
              IF(L1T_I2ATM(I).EQ.IA) L1T_2ATM(I) = ATOM_NEW 
              IF(L1T_I3ATM(I).EQ.IA) L1T_3ATM(I) = ATOM_NEW 
              IF(L1T_I4ATM(I).EQ.IA) L1T_4ATM(I) = ATOM_NEW 
            ENDDO
          ENDIF
          IF(L1C_NCHIR.GT.0) THEN 
            DO I=1,L1C_NCHIR 
              IF(L1C_I1ATM(I).EQ.IA) L1C_1ATM(I) = ATOM_NEW 
              IF(L1C_I2ATM(I).EQ.IA) L1C_2ATM(I) = ATOM_NEW 
              IF(L1C_I3ATM(I).EQ.IA) L1C_3ATM(I) = ATOM_NEW 
              IF(L1C_I4ATM(I).EQ.IA) L1C_4ATM(I) = ATOM_NEW 
              IF(L1C_I5ATM(I).EQ.IA) L1C_5ATM(I) = ATOM_NEW 
              IF(L1C_I6ATM(I).EQ.IA) L1C_6ATM(I) = ATOM_NEW 
              IF(L1C_I7ATM(I).EQ.IA) L1C_7ATM(I) = ATOM_NEW 
              IF(L1C_I8ATM(I).EQ.IA) L1C_8ATM(I) = ATOM_NEW 
              IF(L1C_I9ATM(I).EQ.IA) L1C_9ATM(I) = ATOM_NEW 
           ENDDO
          ENDIF
          IF(L1P_NPLAN.GT.0) THEN
            DO I=1,L1P_NPLAN 
              IF(L1P_NATOM(I).GT.0) THEN
                DO J=1,L1P_NATOM(I)
                  IF(L1P_IATOM(J,I).EQ.IA) THEN
                    ICH4 = L1P_ATOM(J,I)
                    CH4 = ATOM_NEW 
                    L1P_ATOM(J,I) = ICH4
                    IF(CH4.EQ.'????') L1P_IATOM(J,I) = 0
                  ENDIF
                ENDDO
              ENDIF
            ENDDO
          ENDIF          
C --- 
          L1A_ANAME(IA) = ATOM_NEW
        ENDIF
      ENDDO


      IF(LIST.EQ.'T') THEN
        line = ' --- l1 --  before compress_GM:'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,L1A_NATOM
          write(line,'(i2,1x,a,1x,i4)')
     *     ia,l1a_aname(ia),L1A_icr(Ia)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        DO    I=1,L1B_Nbond
          write(line,'(i2,1x,a,1x,a,1x,2i4)')
     *     i,l1b_1atm(i),L1b_2atm(I),l1b_i1atm(i),L1b_i2atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO

        IF(L1G_NANGL.GT.0) THEN
        DO    I=1,L1G_NANGL
          write(line,'(i2,1x,a,1x,a,1x,A,1X,3i4)')
     *     i,l1G_1atm(i),L1G_2atm(I),L1G_3atm(I)
     *     ,l1G_i1atm(i),L1G_i2atm(I),L1G_i3atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF

        line = ' --- l2 -- before compress_ _GM:'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L2A_ISTART,L2A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,L2A_NATOM
          write(line,'(i2,1x,a,1x,i4)')
     *     ia,l2a_aname(ia),L2A_icr(Ia)
          CALL MSGDOC(MDOC,LINE)
        ENDDO

        DO    I=1,L2B_Nbond
          write(line,'(i2,1x,a,1x,a,1x,2i4)')
     *     i,l2b_1atm(i),L2b_2atm(I),l2b_i1atm(i),L2b_i2atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO


      ENDIF

C ----
C     compress L1
      CALL COMPRESS_L1_GM(MDOC,IERR)


      IF(LIST.EQ.'T') THEN
        line = ' --- l1 --  after compress_GM:'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,L1A_NATOM
          write(line,'(i2,1x,a,1x,i4)')
     *     ia,l1a_aname(ia),L1A_icr(Ia)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        DO    I=1,L1B_Nbond
          write(line,'(i2,1x,a,1x,a,1x,2i4)')
     *     i,l1b_1atm(i),L1b_2atm(I),l1b_i1atm(i),L1b_i2atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO

        IF(L1G_NANGL.GT.0) THEN
        DO    I=1,L1G_NANGL
          write(line,'(i2,1x,a,1x,a,1x,A,1X,3i4)')
     *     i,l1G_1atm(i),L1G_2atm(I),L1G_3atm(I)
     *     ,l1G_i1atm(i),L1G_i2atm(I),L1G_i3atm(I)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF


      ENDIF
      IF(N.NE.M) THEN
        DO JA=1,L1A_NATOM
          L1A_BACK(JA) = '.' 
          L1A_FORW(JA) = '.' 
        ENDDO
      ENDIF
C ----
C     check tree
      L = 0
      CALL CHECK_RLIB_TREE(MDOC,LIST,L,IERR)                 
C ---
C     L =< 0 from L1 (not cp_mlib) ; l = 0 cpl_mlib with  L1L_FUSE = 'C'
C ------
      RETURN
      END

      SUBROUTINE LIB_CREATE_TEST_INDEX2(MDOC,IMON
     *            ,NAC,C_CONTENT,C_INDEX,C_PAIR,IERR)
C -------------------------------------------
      INTEGER MAXMPONTER
      PARAMETER (MAXMPONTER = 3500)
      INTEGER MAXMPOOL
      PARAMETER (MAXMPOOL = 600 000)
      INTEGER   MATCH_POINTER(MAXMPONTER)
      INTEGER*2 MATCH_POOL   (MAXMPOOL)
      COMMON /COM_MATCH_POOL/ MEM_TOT,MATCH_NMON
     *                       ,MATCH_POINTER,MATCH_POOL
C ------------------------------------------
C     IP = MATCH_POINTER(I) 
C       MATCH_POOL(IP  ) = IMON 
C       MATCH_POOL(IP+1) = NATOM  
C       MATCH_POOL(IP+2) = NBOND
C
C       MATCH_POOL(IP+3) = ICONTENT(I) 
C       . . . . . 
C       MATCH_POOL(IP+17) = ICONTENT(I) 
C 'C ','N ','O ','S ','P ','CO','MG','CA','ZN','CU','FE','CL','MN','MO','  '
C  1    2    3    4    5    6    7    8    9    10   11   12   13   14   15
C  
C       IPA = IP + 17
C       MATCH_POOL(IPA+1) = IATOM
C       MATCH_POOL(IPA+2) = IATYPE
C
C       IPB = IB + 17 + 2*NATOM
C       MATCH_POOL(IPA+1) = IATOM1
C       MATCH_POOL(IPA+1) = IATOM2
C       MATCH_POOL(IPA+1) = IBTYPE
C
C       0-dumm,1-sing,2-doub,3-trip,4-arom,5-delo,6-meta,7-cova
C
C ---------------------------------------------------------------
      INTEGER  MDOC,IERR,MEM_TOT,IMON,NMON
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER SYMB*4,MON*8,LINE*256
C -----------------------------------------------
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
C -----------------------------------------------

      INTEGER   ICONTENT(15)
      CHARACTER ATM_SYMB(15)*2
      DATA  ATM_SYMB
     */'C ','N ','O ','S ','P ','CO','MG','CA','ZN','CU','FE','CL','MN'
     *,'MO','  '/
C       1    2    3    4    5    6    7    8    9    10   11   12   13
C       14   15
C ---------------------------------------------------------------------
      IERR   = 0
c      IF(NMON.GE.MAXMPONTER) THEN
c        WRITE(LINE,
c     *'('' ERROR: in LIB_CREATE_TEST_INDEX2: numbe of monomers >'',I8)')
c     *  MAXMPONTER
c        CALL MSGERR(MDOC,LINE)         
c        IERR = 1
c        RETURN
c      ENDIF    
C -----
      CALL COPYL2(MDOC,IERR)
      IF(IMON.GT.0) THEN
        MON = LML_MNAME(IMON)
      ELSE
        MON = L1L_MNAME
      ENDIF
C -----
      CALL CALC_INDEX(MDOC,MON,NAC,C_CONTENT,C_INDEX,C_PAIR,IERR)
C -----
      NA     = L2A_NATOM
      IF(NA.LE.1) THEN
        RETURN
      ENDIF
      DO I=1,15
        ICONTENT(I) = 0
      ENDDO
C --------------------
      NATOM  = 0

      DO IA=1,NA
        L2A_ICR(IA) = 0 
        IF(L2A_ANAME(IA).NE.'    ') THEN
          SYMB = L2A_SYMB(IA)
          IF(SYMB(1:2).NE.'H '.AND.SYMB(1:2).NE.'D ') THEN
            DO K=1,15
              IF(SYMB(1:2).EQ.ATM_SYMB(K)) THEN
                GO TO 100
              ENDIF             
            ENDDO
            K = 15
 100        CONTINUE
            NATOM       = NATOM + 1
            ICONTENT(K) = ICONTENT(K) + 1
            L2A_ICR(IA) = NATOM
            L2A_CONN(1,NATOM) = IA
            L2A_CONN(2,NATOM) = K
          ENDIF
        ENDIF
      ENDDO  
      IF(NATOM.LE.4)     RETURN
      IF(L2B_NBOND.LE.3) RETURN
C -------------------- 
      NBOND = 0     
      DO IA=1,NA-1
        IF(L2A_ICR(IA).GT.0) THEN 
          DO JA=IA+1,NA
            IF(L2A_ICR(JA).GT.0) THEN 
              DO IB=1,L2B_NBOND
                IF(L2B_1ATM(IB).EQ.L2A_ANAME(IA).AND.
     *             L2B_2ATM(IB).EQ.L2A_ANAME(JA)) THEN
                  NBOND = NBOND + 1
                  L2N_I1ATM (NBOND) = L2A_ICR(IA)
                  L2N_I2ATM (NBOND) = L2A_ICR(JA)
                  L2N_TYPE  (NBOND) = L2B_TYPE(IB)
                  GO TO 200
                ELSE IF(L2B_2ATM(IB).EQ.L2A_ANAME(IA).AND.
     *                  L2B_1ATM(IB).EQ.L2A_ANAME(JA)) THEN
                  NBOND = NBOND + 1
                  L2N_I1ATM (NBOND) = L2A_ICR(JA)
                  L2N_I2ATM (NBOND) = L2A_ICR(IA)
                  L2N_TYPE  (NBOND) = L2B_TYPE(IB)
                  GO TO 200
                ENDIF
              ENDDO

 200          CONTINUE
            ENDIF
          ENDDO
        ENDIF
      ENDDO
C --------------------
      IF(NATOM.LE.4) RETURN
      IF(NBOND.LE.3) RETURN      
C ----------------------------------------
      MEM  = MEM_TOT
      NMON = MATCH_NMON
      IT = MEM + 18 +NATOM*2 + NBOND*3
      IF(IT.GT.MAXMPOOL) THEN
        WRITE(LINE,
     *  '('' ERROR: in LIB_CREATE_INDEX2: not memory enough:'')')
        CALL MSGERR(MDOC,LINE)         
        IERR = 1
        RETURN
      ENDIF    

      NMON1    = NMON + 1

      MEM = MEM + 1
      MATCH_POINTER(NMON1) = MEM
c     MATCH_NMON           = NMON

c     write(*,*) '--ind2:',nmon1,mem,imon,natom,nbond 

      MATCH_POOL(MEM) = IMON 
      MEM = MEM + 1
      MATCH_POOL(MEM) = NATOM  
      MEM = MEM + 1
      MATCH_POOL(MEM) = NBOND

      DO I=1,15
        MEM = MEM + 1 
        MATCH_POOL(MEM) = ICONTENT(I) 
      ENDDO

      DO IA=1,NATOM

        MEM = MEM + 1 
        MATCH_POOL(MEM) = L2A_CONN(1,IA) 

        MEM = MEM + 1 
        MATCH_POOL(MEM) = L2A_CONN(2,IA) 

      ENDDO

      DO IB=1,NBOND

        IT = 0

C       0-dumm,1-sing,2-doub,3-trip,4-arom,5-delo,6-meta,7-cova

        IF(L2N_TYPE(IB)(1:4).EQ.'sing') THEN
          IT = 1
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'doub') THEN
          IT = 2
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'trip') THEN
          IT = 3
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'arom') THEN
          IT = 4
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'delo') THEN
          IT = 5
        ELSE IF(L2N_TYPE(IB)(1:4).EQ.'meta') THEN
          IT = 6
        ELSE IF((L2N_TYPE(IB)(1:4).EQ.'cova').OR.
     *          (L2N_TYPE(IB)(1:1).EQ.'.'   )    )THEN
          IT = 7
        ENDIF

        MEM = MEM + 1 
        MATCH_POOL(MEM) = L2N_I1ATM(IB) 
        MEM = MEM + 1 
        MATCH_POOL(MEM) = L2N_I2ATM(IB) 
        MEM = MEM + 1 
        MATCH_POOL(MEM) = IT 

      ENDDO

C ---------------------
      RETURN
      END

      SUBROUTINE CALC_INDEX(MDOC,MON,N,C_CONTENT,C_INDEX,C_PAIR,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4,MON*8,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C ------------------------------------------
      CHARACTER LINE*256
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
C --------------------------------
      IERR = 0
      M    =-ABS(MDOC)-1
C ------------------------------------------
      MODE = 'LIB '
      LIST = ' '
      ISYN = 0
      CALL CHECK_COMPL(MDOC,LIST,MODE,ISYN,MON,IERR)

      C_CONTENT = MTC_C_CONTENT
      C_INDEX   = MTC_C_INDEX
      C_PAIR    = MTC_C_PAIR
      N         = MTC_NA2
      RETURN
      END

      SUBROUTINE COOR_CONN(MDOC,MODE,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4
C ---
      INCLUDE 'lib_com.fh'
C ******
      REAL      DLIM(4)
      CHARACTER CIATOM*1,CJATOM*1,LINE*256,MON*8
      CHARACTER FLAG*1
C     INTEGER*4 IJA(3),ICH4
C     CHARACTER CH2*2,CH4*4,ASYMB*4,CTYPE*4,MOD*1
C     EQUIVALENCE (ICH4,CH4)
      DATA DLIM/ 1.2, 1.7, 2.4, 2.85 /
C --------------------------------
C     M = -ABS(MDOC)-1

      NA     = L1A_NATOM
      MON    = L1L_MNAME        

      IF(NA.LE.1) THEN
        RETURN
      ENDIF

      DO    IA=1,NA-1
      IF(L1A_ANAME(IA).NE.'    ') THEN
        CIATOM = L1A_ATYPE(IA)
        XI     = L1A_X(IA)
        YI     = L1A_Y(IA)
        ZI     = L1A_Z(IA)
        DO    JA=IA+1,NA
        IF(L1A_ANAME(JA).NE.'    ') THEN
          CJATOM = L1A_ATYPE(JA)
          XJ     = L1A_X(JA)
          YJ     = L1A_Y(JA)
          ZJ     = L1A_Z(JA)
          IF(CIATOM.EQ.'H'.OR.CJATOM.EQ.'H') THEN    
            IC=1 
          ELSE IF(CIATOM.EQ.'C'.AND.CJATOM.EQ.'C') THEN    
            IC=2
          ELSE IF(CIATOM.EQ.'$'.AND.CJATOM.EQ.'$') THEN    
            IC=4
          ELSE 
            IC=3
          ENDIF
 
          IF(IC.GT.0) THEN
            
            DIST = 0.0
            IF(L1A_COOR_FLAG(IA).EQ.'Y'.AND.
     *         L1A_COOR_FLAG(JA).EQ.'Y'     ) THEN
              DX   = XI-XJ
              DY   = YI-YJ
              DZ   = ZI-ZJ
              DIST = SQRT(DX*DX+DY*DY+DZ*DZ)
            ENDIF 

            FLAG = 'N'
            IF(MODE.EQ.'CONN') THEN
              IF(L1N_NCONN.GT.0) THEN
                DO ICN=1,L1N_NCONN
                  IF((L1N_I1ATM(ICN).EQ.IA.AND.
     *                L1N_I2ATM(ICN).EQ.JA     ).OR.
     *               (L1N_I1ATM(ICN).EQ.JA.AND.
     *                L1N_I2ATM(ICN).EQ.IA     )) THEN
                    FLAG = 'Y'
                    GO TO 500
                  ENDIF
                ENDDO
              ENDIF
 500          CONTINUE
            ENDIF

            IF((DIST.LE.DLIM(IC).AND.DIST.GT.0.001)
     *                              .OR.FLAG.EQ.'Y') THEN
              IF(L1B_NBOND.GE.MAX1BND) THEN
                WRITE(LINE,'(3A,I6)')
     *          ' ERROR: number of bonds of new monomer '
     *          ,L1L_MNAME,' >',MAX1BND 
                CALL MSGERR(MDOC,LINE)
                CALL MSGERR(MDOC,
     *  '          Change parameter MAX1BND in "lib_com.fh"')
                IERR=1
                RETURN
              ENDIF 
              IF(L1A_NDIST(IA).LT.MAX1BRN) THEN
                L1A_NDIST(IA)              = L1A_NDIST(IA) + 1
                L1A_CONN(L1A_NDIST(IA),IA) = JA
                IF(L1A_ATYPE(JA).EQ.'H') THEN
                  L1A_LENCON(1,IA) = L1A_LENCON(1,IA) + 1
                ENDIF
              ENDIF
              IF(L1A_NDIST(JA).LT.MAX1BRN) THEN
                L1A_NDIST(JA)              = L1A_NDIST(JA) + 1
                L1A_CONN(L1A_NDIST(JA),JA) = IA
                IF(L1A_ATYPE(IA).EQ.'H') THEN
                  L1A_LENCON(1,JA) = L1A_LENCON(1,JA) + 1
                ENDIF
              ENDIF
              L1B_NBOND             = L1B_NBOND+1
              L1B_I1ATM (L1B_NBOND) = IA
              L1B_1ATM  (L1B_NBOND) = L1A_ANAME(IA)
              L1B_I2ATM (L1B_NBOND) = JA
              L1B_2ATM  (L1B_NBOND) = L1A_ANAME(JA)
              L1B_VOBS  (L1B_NBOND) = DIST
              L1B_TYPE  (L1B_NBOND) = '.'
            ENDIF
          ENDIF
        ENDIF
        ENDDO
      ENDIF
      ENDDO

      RETURN
      END

      SUBROUTINE CRD_CONN(MDOC,MODE,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4
C ---
      INCLUDE 'lib_com.fh'
C ******
      REAL      DLIM(4)
C     CHARACTER LINE*256
      CHARACTER CIATOM*1,CJATOM*1,MON*8
      CHARACTER ASYMB*4,CTYPE*4
C     INTEGER*4 IJA(3),ICH4
C     CHARACTER CH2*2,CH4*4,FLAG*1,MOD*1
C     EQUIVALENCE (ICH4,CH4)
      DATA DLIM/ 1.2, 1.7, 2.4, 2.85 /
C --------------------------------
      IERR = 0
      M    =-ABS(MDOC)-1

      NA   = L1A_NATOM
      MON  = L1L_MNAME        

      DO I=1,C1_NATOM
        S1_INEW (I) = I 
        S1_IOLD (I) = I
        S1_ICHEM(I) = 0              
        S1_NDIST(I) = 0
        S1_IBACK(I) = 0
        S1_IFORW(I) = 0
        S1_BACK (I) = '.'
        S1_FORW (I) = '.'
        S1_CHEM (I) = C1_ASYMB(I) 
        DO  J=1,MX1BRN 
          S1_CONN   (J,I) = 0
          S1_LENCON (J,I) = 0
        ENDDO
        DO  J=1,MX1EXT 
          S1_IEXTR (J,I) = 0
        ENDDO
        ASYMB = C1_ASYMB(I)
        IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *     ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *     ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
          CTYPE='C   '
        ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
          CTYPE='H   '
        ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
          CTYPE='P   '
        ELSE
          CTYPE='$   '
        ENDIF
        C1_ATYPE(I) = CTYPE(1:1)
      ENDDO

      IF(C1_NATOM.GT.1) THEN
        DO    IA=1,C1_NATOM-1
        IF(C1_ANAME(IA).NE.'    ') THEN
          CIATOM = C1_ATYPE(IA)
          XI     = C1_XYZ(1,IA)
          YI     = C1_XYZ(2,IA)
          ZI     = C1_XYZ(3,IA)
          DO    JA=IA+1,C1_NATOM
          IF(C1_ANAME(JA).NE.'    ') THEN
            CJATOM = C1_ATYPE(JA)
            XJ     = C1_XYZ(1,JA)
            YJ     = C1_XYZ(2,JA)
            ZJ     = C1_XYZ(3,JA)
            IF(CIATOM.EQ.'H'.OR.CJATOM.EQ.'H') THEN    
              IC=1 
            ELSE IF(CIATOM.EQ.'C'.AND.CJATOM.EQ.'C') THEN    
              IC=2
            ELSE IF(CIATOM.EQ.'$'.AND.CJATOM.EQ.'$') THEN    
              IC=4
            ELSE 
              IC=3
            ENDIF
 
            IF(IC.GT.0) THEN
            
              DIST = 0.0
              IF(C1_OCC(IA).GT.0.0001.AND.
     *           C1_OCC(JA).GT.0.0001     ) THEN
                DX   = XI-XJ
                DY   = YI-YJ
                DZ   = ZI-ZJ
                DIST = SQRT(DX*DX+DY*DY+DZ*DZ)
              ENDIF 

              IF(DIST.LE.DLIM(IC).AND.DIST.GT.0.001) THEN
                IF(S1_NDIST(IA).LT.MX1BRN) THEN
                  S1_NDIST(IA)             = S1_NDIST(IA) + 1
                  S1_CONN(S1_NDIST(IA),IA) = JA
                  IF(C1_ATYPE(JA).EQ.'H') THEN
                    S1_LENCON(1,IA) = S1_LENCON(1,IA) + 1
                  ENDIF
                ENDIF
                IF(S1_NDIST(JA).LT.MX1BRN) THEN
                  S1_NDIST(JA)             = S1_NDIST(JA) + 1
                  S1_CONN(S1_NDIST(JA),JA) = IA
                  IF(C1_ATYPE(IA).EQ.'H') THEN
                    S1_LENCON(1,JA) = S1_LENCON(1,JA) + 1
                  ENDIF
                ENDIF
              ENDIF
            ENDIF
          ENDIF
          ENDDO
        ENDIF
        ENDDO
      ENDIF

      RETURN
      END
C
      SUBROUTINE SET_NUM_MOD(MDOC,MON,PNUM,IERR)
C -----------------------------------------------
C -P- SET_NUM - defines atom's number for atom's name.
C    
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,PNUM*12
C ---
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------
      CHARACTER NAME*4,LINE*256
C --------------------------------------------------------
      IERR = 0
C --
      DO I=1,L1A_NATOM
        L1A_IOLD  (I) = I
        L1A_INEW  (I) = I
        L1A_LENGTH(I) =-1.0
        L1A_THETA (I) =-1.0
        L1A_PHI   (I) = 0.0
        L1A_ID_PSI(I) = '?' 
      ENDDO
      IFLAGB      = 0
      IFLAGF      = 0
      L1A_ISTART  = 0
      L1A_IFINISH = 0
C ------
      IF(L1A_NATOM.GT.1) THEN
        DO I=1,L1A_NATOM-1
          NAME = L1A_ANAME(I)
          DO J=I+1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN
              IF(PNUM(1:1).EQ.' ') THEN
                LINE = ' WARNING : '//MON//
     *                 ' : duplicated atom_name : '//L1A_ANAME(J)
              ELSE
                LINE = ' WARNING : '//MON//' '//PNUM//
     *                 ' : duplicated atom_name : '//L1A_ANAME(J)
              ENDIF
              CALL MSGDOC(MDOC,LINE)
              IERR = 1
            ENDIF
          ENDDO
        ENDDO
      ENDIF
C ------
      DO I=1,L1A_NATOM
C --
        NAME = L1A_BACK(I)
        IF(NAME(1:1).NE.'.'.AND.NAME(1:1).NE.'n/a') THEN
          DO J=1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN
              L1A_IBACK(I) = J
              GO TO 100
            ENDIF
          ENDDO

C         without back atom

          L1A_IBACK(I) = 0
          IF(L1A_SYMB(I)(1:2).NE.'H '.AND.L1A_SYMB(I)(1:2).NE.'D ') THEN
            IF(PNUM(1:1).EQ.' ') THEN
              LINE = ' WARNING : '//MON//
     *             ' : back_atom for '//L1A_ANAME(I)//' is absent'
            ELSE      
              LINE = ' WARNING : '//MON//' '//PNUM//
     *             ' : back_atom for '//L1A_ANAME(I)//' is absent'
            ENDIF
            CALL MSGDOC(MDOC,LINE)
            IERR = 1
          ELSE
            L1A_BACK(I) = '.'
            L1A_FORW(I) = '.'
          ENDIF
  100     CONTINUE
        ELSE     
          L1A_IBACK(I) = -1
          L1A_ISTART   = I
          IFLAGB       = IFLAGB + 1
        ENDIF
C --
        CALL LENSTR_BL(L1A_FORW(I),LEN)
        IF(LEN.LE.0) L1A_FORW(I) = '.'
        NAME = L1A_FORW(I)
        IF(NAME(1:3).EQ.'END') THEN
          L1A_IFORW(I) = -1
          L1A_IFINISH  = I
          IFLAGF       = IFLAGF + 1
        ELSE IF(NAME(1:1).NE.'.') THEN
          DO J=1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN 
              L1A_IFORW(I) = J
              IF(L1A_BACK(J).NE.L1A_ANAME(I)) THEN
                IF(PNUM(1:1).EQ.' ') THEN
                  LINE = ' WARNING : '//MON//
     * ' : atom '//L1A_ANAME(I)//' has wrong forward_atom '//NAME
                ELSE
                  LINE = ' WARNING : '//MON//' '//PNUM//
     * ' : atom '//L1A_ANAME(I)//' has wrong forward_atom '//NAME
                ENDIF 
                CALL MSGDOC(MDOC,LINE)
                IERR=1
              ENDIF
              GO TO 120
            ENDIF
          ENDDO
          L1A_IFORW(I) = 0
          IF(PNUM(1:1).EQ.' ') THEN
            LINE = ' WARNING : '//MON//
     *             ' : forward_atom for '//L1A_ANAME(I)//' is absent'
          ELSE   
            LINE = ' WARNING : '//MON//' '//PNUM//
     *             ' : forward_atom for '//L1A_ANAME(I)//' is absent'
          ENDIF
          CALL MSGDOC(MDOC,LINE)
          IERR = 1
  120     CONTINUE
        ELSE     
          L1A_IFORW(I) = 0
        ENDIF
C ------
        L1A_NDIST(I) = 0
        L1A_NEXTR(I) = 0
      ENDDO

      IF(IFLAGB.LE.0) THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : first atom of the tree is absent'
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : first atom of the tree is absent'
        ENDIF
        CALL MSGDOC(MDOC,LINE)
        IERR = 1
      ELSE IF(IFLAGB.GT.1) THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : wrong definition of first atom of the tree'
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : wrong definition of first atom of the tree'
        ENDIF
        CALL MSGDOC(MDOC,LINE)
        IERR = 1
      ENDIF
      IF(IFLAGF.LE.0) THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : last atom of the tree is absent'
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : last atom of the tree is absent'
        ENDIF
        CALL MSGDOC(MDOC,LINE)
        IERR = 1
      ELSE IF(IFLAGF.GT.1) THEN
        IF(PNUM(1:1).EQ.' ') THEN
           LINE = ' WARNING : '//MON//
     *            ' : multiple definition of last atom of the tree'
        ELSE
           LINE = ' WARNING : '//MON//' '//PNUM//
     *            ' : multiple definition of last atom of the tree'
        ENDIF
        CALL MSGDOC(MDOC,LINE)
        IERR = 1
      ENDIF
C -----
      IF(IERR.EQ.0) THEN
C
C       back bone definition
C
        DO I=1,L1A_NATOM
          L1A_NDIST(I) = 0
        ENDDO
        I = L1A_IFINISH 
  700     CONTINUE
          J = L1A_IBACK(I)
          IF(J.LT.0) GO TO 710
          L1A_FORW(J)  = L1A_ANAME(I)
          L1A_IFORW(J) = I 

          L1A_NDIST(J) = L1A_NDIST(J) + 1

          I            = J
          GO TO 700
  710   CONTINUE
      ENDIF
C ---
      RETURN
      END

C ******
      SUBROUTINE MODIF(MDOC,MOD_IN,IERR)
C -----------------------------------------------
C -P- MODIF - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256
      CHARACTER COMP*8,TYPE*8,PNUM*12,TREE*1,BACK*4,FORW*4
      CHARACTER LIST *1,MOD_IN*8
C -----------------------------------
      IERR = 0
      LIST = '.'
c      LIST = 'T'

      MOD = MOD_IN

      IF(MOD(1:1).EQ.'.') RETURN

      IF(LDL_NMOD.LE.0) THEN
        CALL MSGDOC(MDOC,
     * ' WARNING: number of modifications in library = 0')
        IERR = 0
        RETURN
      ENDIF

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF:',mod
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF


      IF(MOD.EQ.'NH3'.OR.MOD.EQ.'AA-STAND'.OR.
     *                   MOD.EQ.'AA-STPRO'    ) THEN
      IF(L1A_NATOM.GT.3.AND.L1B_NBOND.GT.2) THEN
        DO I=1,L1B_NBOND
          IF((L1B_1ATM(I).EQ.'N' .AND.L1B_2ATM(I).EQ.'CD').OR.
     *       (L1B_1ATM(I).EQ.'CD'.AND.L1B_2ATM(I).EQ.'N' ).OR.
     *       (L1B_1ATM(I).EQ.'N' .AND.L1B_2ATM(I).EQ.'CN').OR.
     *       (L1B_1ATM(I).EQ.'CN'.AND.L1B_2ATM(I).EQ.'N' )) THEN
            IF(MOD.EQ.'NH3'     ) THEN
              MOD = 'NH2'
              IF((L1B_1ATM(I).EQ.'N' .AND.L1B_2ATM(I).EQ.'CN').OR.
     *        (L1B_1ATM(I).EQ.'CN'.AND.L1B_2ATM(I).EQ.'N' )) 
     *        MOD = 'NH2N'
            ENDIF
            IF(MOD.EQ.'AA-STAND') MOD = 'AA-STPRO'
            GO TO 600          
          ENDIF
        ENDDO
      ENDIF
      ENDIF

 600  CONTINUE

      DO   L=1,LDL_NMOD
        IF(MOD.EQ.LDL_MNAME(L)) THEN
          LDL_IMOD = L
          GO TO 100
        ENDIF
C       IF(MOD.EQ.LDL_MNAME(L).AND.LDL_FUSE(L).NE.'N') GO TO 100
      ENDDO  

      WRITE(LINE,'(A,A8,A,A)')' WARNING: modification ',MOD,
     *    ' not found in library for ',L1L_MNAME
      CALL MSGDOC(MDOC,LINE)
      IERR = 0
      RETURN

  100 CONTINUE
      L = LDL_IMOD

      IF(L.LE.0) THEN
        IF(LIST.EQ.'T') THEN
          WRITE(*,*) ' ERROR: L=0 for:',MOD
        ENDIF 
        RETURN
      ENDIF

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF0:',mod,l
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF

      PNUM = ' '
      IF(L1L_PRSNT.EQ.'Y'.OR.L1L_PRSNT.EQ.'.') THEN
        TREE = 'N'
        DO I=1,L1A_NATOM
          IF(L1A_BACK(I).NE.'.') TREE = 'Y'
        ENDDO

        IF(TREE.EQ.'Y') THEN
          CALL SET_NUM_MOD(MDOC,L1L_MNAME,PNUM,IERR)
          IF(IERR.NE.0) THEN
            TREE = 'N' 
            IERR = 0
          ENDIF
        ENDIF
      ELSE
        TREE = 'N' 
      ENDIF

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF2:',mod,tree
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF

      IA      = LDL_IATOM(L)
      IN      = LDL_ICONN(L)
      IB      = LDL_IBOND(L)
      IG      = LDL_ITHET(L)
      IT      = LDL_ITORS(L)
      IP      = LDL_IPLAN(L)
      IC      = LDL_ICHIR(L)
      IO      = LDL_ORDER(L)
      IF(L1L_PRSNT.NE.'Y'.AND.L1L_PRSNT.NE.'.') THEN
        IN = 0
        IG = 0
        IT = 0
        IP = 0 
      ENDIF
      IDELA   = 0
      IDELN   = 0
      IDELB   = 0
      IDELG   = 0
      IDELT   = 0
      IDELC   = 0
      IDELP   = 0
      ISTART  = 0
      IFINISH = 0
      ISTART_OLD  = 0
      IFINISH_OLD = 0

      COMP = LDL_COMP(L)
      TYPE = LDL_TYPE(L)
 
      IF(IA.GT.0) THEN
        CALL MOD_AMLIB(MDOC,MOD,IA,TREE,ISTART,IFINISH
     *         ,IDELA,IDELN,IDELB,IDELG,IDELT,IDELC,IDELP,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IN.GT.0) THEN
        CALL MOD_NMLIB(MDOC,MOD,IN,TREE
     *  ,ISTART,IFINISH,ISTART_OLD,IFINISH_OLD,IDELN,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IB.GT.0) THEN
        CALL MOD_BMLIB(MDOC,MOD,IB,IDELB,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IG.GT.0) THEN
        CALL MOD_GMLIB(MDOC,MOD,IG,IDELG,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IT.GT.0) THEN
        CALL MOD_TMLIB(MDOC,MOD,IT,IDELT,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IP.GT.0) THEN
        CALL MOD_PMLIB(MDOC,MOD,IP,IDELP,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IC.GT.0) THEN
        CALL MOD_CMLIB(MDOC,MOD,IC,IDELC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF3:',mod
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      WRITE(*,*) ' so,fo:',ISTART_old,IFINISH_old
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF

      IF(ISTART_OLD.GT.0) THEN
        BACK = L1A_BACK(ISTART_OLD)        
        DO LA=1,L1A_NATOM
          IF(L1A_ANAME(LA).EQ.BACK) THEN
            L1A_BACK (LA) = '.'
            GO TO 300
          ENDIF
        ENDDO
      ENDIF
 300  CONTINUE
      IF(IFINISH_OLD.GT.0) THEN
        FORW = L1A_FORW(IFINISH_OLD)        
        DO LA=1,L1A_NATOM
          IF(L1A_ANAME(LA).EQ.FORW) THEN
            L1A_FORW (LA) = 'END'
            GO TO 400
          ENDIF
        ENDDO
      ENDIF
 400  CONTINUE
      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF4:',mod
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF

      IF(IDELA.GT.0) THEN
        N      = 0
        NHATOM = 0
        DO LA=1,L1A_NATOM
          IF(L1A_ANAME(LA).NE.'    ') THEN
            N                = N+1 
            L1A_COOR_FLAG(N) = L1A_COOR_FLAG(LA)
            L1A_CHARG(N)     = L1A_CHARG(LA)
            IF(L1A_COOR_FLAG(N).EQ.'Y') THEN
              L1A_X    (N) = L1A_X    (LA)
              L1A_Y    (N) = L1A_Y    (LA)
              L1A_Z    (N) = L1A_Z    (LA)
            ELSE
              L1A_X    (N) = 0.0
              L1A_Y    (N) = 0.0
              L1A_Z    (N) = 0.0 
            ENDIF
            IF(LA.EQ.L1A_ISTART)  L1A_ISTART  = N
            IF(LA.EQ.L1A_IFINISH) L1A_IFINISH = N
            IF(LA.EQ.ISTART)  ISTART  = N
            IF(LA.EQ.IFINISH) IFINISH = N
            L1A_INEW (N) = N 
            L1A_IOLD (N) = N
            L1A_ICR  (N) = 0
            L1A_NDIST(N) = 0
            L1A_IBACK(N) = 0
            L1A_IFORW(N) = 0
            L1A_BACK (N) = L1A_BACK (LA)
            L1A_TYPE (N) = L1A_TYPE (LA) 
            L1A_FORW (N) = L1A_FORW (LA) 
            L1A_ANAME(N) = L1A_ANAME(LA)
            L1A_SYMB (N) = L1A_SYMB (LA)  
            L1A_CHEM (N) = L1A_CHEM (LA)
            L1A_ATYPE(N) = 'M'
            IF(L1A_SYMB(N)(1:2).NE.'H '.AND.
     *         L1A_SYMB(N)(1:2).NE.'D ' )
     *         NHATOM = NHATOM + 1
            DO  J=1,MAX1BRN 
              L1A_CONN   (J,N) = 0
              L1A_LENCON (J,N) = 0
            ENDDO
            DO  J=1,MAX1EXT 
              L1A_IEXTR (J,N) = 0
              L1A_TEXTR (J,N) = 0
            ENDDO
          ENDIF
        ENDDO
        L1A_NATOM  = N
        L1A_NHATOM = NHATOM
      ENDIF

      IF(IDELB.GT.0) THEN
        IF(L1B_NBOND.GT.0) THEN
          N = 0
          DO LB=1,L1B_NBOND
            IF(L1B_1ATM(LB).NE.'    ') THEN
              N            = N+1 
              L1B_I1ATM(N) = 0
              L1B_I2ATM(N) = 0
              L1B_1ATM (N) = L1B_1ATM (LB)
              L1B_2ATM (N) = L1B_2ATM (LB)
              L1B_TYPE (N) = L1B_TYPE (LB)
              L1B_FLAG (N) = L1B_FLAG (LB)
              L1B_VOBS (N) = L1B_VOBS (LB)  
              L1B_VAL  (N) = L1B_VAL  (LB) 
              L1B_DEV  (N) = L1B_DEV  (LB) 
            ENDIF
          ENDDO
          L1B_NBOND = N
        ENDIF
      ENDIF

      IF(IDELN.GT.0) THEN
        IF(L1N_NCONN.GT.0) THEN
          N = 0
          DO LN=1,L1N_NCONN
            IF(L1N_1ATM(LN).NE.'    ') THEN
              N            = N+1 
              L1N_I1ATM(N) = 0
              L1N_I2ATM(N) = 0
              L1N_1ATM (N) = L1N_1ATM (LN)
              L1N_2ATM (N) = L1N_2ATM (LN)
              L1N_TYPE (N) = L1N_TYPE (LN)
            ENDIF
          ENDDO
          L1N_NCONN = N
        ENDIF
      ENDIF
 
      IF(IDELG.GT.0) THEN
        IF(L1G_NANGL.GT.0) THEN
          N = 0
          DO LG=1,L1G_NANGL
            IF(L1G_1ATM(LG).NE.'    ') THEN
              N            = N+1 
              L1G_I1ATM(N) = 0
              L1G_I2ATM(N) = 0
              L1G_I3ATM(N) = 0
              L1G_1ATM (N) = L1G_1ATM (LG)
              L1G_2ATM (N) = L1G_2ATM (LG)
              L1G_3ATM (N) = L1G_3ATM (LG)
              L1G_FLAG (N) = L1G_FLAG (LG)
              L1G_VOBS (N) = L1G_VOBS (LG)  
              L1G_VAL  (N) = L1G_VAL  (LG) 
              L1G_DEV  (N) = L1G_DEV  (LG) 
            ENDIF
          ENDDO
          L1G_NANGL = N
        ENDIF
      ENDIF

      IF(IDELT.GT.0) THEN
        IF(L1T_NTORS.GT.0) THEN
          N = 0
          DO LT=1,L1T_NTORS
            IF(L1T_1ATM(LT).NE.'    ') THEN
              N            = N+1 
              L1T_I1ATM(N) = 0
              L1T_I2ATM(N) = 0
              L1T_I3ATM(N) = 0
              L1T_I4ATM(N) = 0
              L1T_1ATM (N) = L1T_1ATM (LT)
              L1T_2ATM (N) = L1T_2ATM (LT)
              L1T_3ATM (N) = L1T_3ATM (LT)
              L1T_4ATM (N) = L1T_4ATM (LT)
              L1T_FLAG (N) = L1T_FLAG (LT)
              L1T_VOBS (N) = L1T_VOBS (LT)  
              L1T_VAL  (N) = L1T_VAL  (LT) 
              L1T_DEV  (N) = L1T_DEV  (LT) 
              L1T_PRD  (N) = L1T_PRD  (LT) 
              L1T_LABEL(N) = L1T_LABEL(LT) 
            ENDIF
          ENDDO
          L1T_NTORS = N
        ENDIF
      ENDIF

      IF(IDELC.GT.0) THEN
        IF(L1C_NCHIR.GT.0) THEN
          N = 0
          DO LC=1,L1C_NCHIR
            IF(L1C_1ATM(LC).NE.'    ') THEN
              N            = N+1 
              L1C_I1ATM(N) = 0
              L1C_I2ATM(N) = 0
              L1C_I3ATM(N) = 0
              L1C_I4ATM(N) = 0
              L1C_1ATM (N) = L1C_1ATM (LC)
              L1C_2ATM (N) = L1C_2ATM (LC)
              L1C_3ATM (N) = L1C_3ATM (LC)
              L1C_4ATM (N) = L1C_4ATM (LC)
              L1C_5ATM (N) = L1C_5ATM (LC)
              L1C_6ATM (N) = L1C_6ATM (LC)
              L1C_7ATM (N) = L1C_7ATM (LC)
              L1C_8ATM (N) = L1C_8ATM (LC)
              L1C_9ATM (N) = L1C_9ATM (LC)
              L1C_FLAG (N) = L1C_FLAG (LC)
              L1C_VOL  (N) = L1C_VOL  (LC) 
              L1C_VOBS (N) = L1C_VOBS (LC) 
              L1C_SIGN (N) = L1C_SIGN (LC) 
            ENDIF
          ENDDO
          L1C_NCHIR = N
        ENDIF
      ENDIF

        IF(IDELP.GT.0) THEN
          IF(L1P_NPLAN.GT.0) THEN

C           remove plan with NA < 4
            DO LP=1,L1P_NPLAN
              N = 0
              DO LPA=1,L1P_NATOM(LP)
                IF(L1P_ATOM(LPA,LP).GT.0) THEN
                  N = N + 1
                  L1P_FLAG  (N,LP) = L1P_FLAG (LPA,LP) 
                  L1P_DOBS  (N,LP) = L1P_DOBS (LPA,LP)
                  L1P_EDEV  (N,LP) = L1P_EDEV (LPA,LP)
                  L1P_IATOM (N,LP) = L1P_IATOM(LPA,LP)
                  L1P_DEV   (N,LP) = L1P_DEV  (LPA,LP)
                  L1P_ATOM  (N,LP) = L1P_ATOM (LPA,LP)
                 ENDIF
              ENDDO
              IF(N.GT.3) THEN
                L1P_NATOM(LP) = N
              ELSE 
                L1P_NATOM(LP) = 0
              ENDIF
            ENDDO
C           unite common plans 
            IF(L1P_NPLAN.GT.1) THEN
              DO LP1=1,L1P_NPLAN-1
              IF(L1P_NATOM(LP1).GT.0) THEN
              DO LP2=LP1+1,L1P_NPLAN
              IF(L1P_NATOM(LP2).GT.0) THEN
 
                NCOMM = 0
                DO LPA1=1,L1P_NATOM(LP1)
                DO LPA2=1,L1P_NATOM(LP2)
                  IF(L1P_ATOM(LPA1,LP1).EQ.L1P_ATOM(LPA2,LP2)) THEN
                    NCOMM = NCOMM + 1
                  ENDIF
                ENDDO
                ENDDO
                IF(NCOMM.GE.3) THEN
                  N = L1P_NATOM(LP1)
                  DO LPA2=1,L1P_NATOM(LP2)
                    DO LPA1=1,L1P_NATOM(LP1)
                      IF(L1P_ATOM(LPA1,LP1).EQ.
     *                   L1P_ATOM(LPA2,LP2)) THEN
                        GO TO 500
                      ENDIF
                    ENDDO
                    N = N + 1
                    L1P_FLAG  (N,LP1) = L1P_FLAG (LPA2,LP2) 
                    L1P_DOBS  (N,LP1) = L1P_DOBS (LPA2,LP2)
                    L1P_EDEV  (N,LP1) = L1P_EDEV (LPA2,LP2)
                    L1P_IATOM (N,LP1) = L1P_IATOM(LPA2,LP2)
                    L1P_DEV   (N,LP1) = L1P_DEV  (LPA2,LP2)
                    L1P_ATOM  (N,LP1) = L1P_ATOM (LPA2,LP2)
 500                CONTINUE
                  ENDDO
                  L1P_NATOM(LP1) = N
                  L1P_NATOM(LP2) = 0
                ENDIF 
              ENDIF
              ENDDO
              ENDIF
              ENDDO 
            ENDIF
C           remove plan with NA = 0
            NP = 0
            DO LP=1,L1P_NPLAN
              IF(L1P_NATOM(LP).GT.0) THEN
                NP = NP + 1
                L1P_NATOM(NP) = L1P_NATOM(LP)
                L1P_LABEL(NP) = L1P_LABEL(LP)
                DO LPA=1,L1P_NATOM(LP)
                  L1P_FLAG  (LPA,NP) = L1P_FLAG (LPA,LP) 
                  L1P_DOBS  (LPA,NP) = L1P_DOBS (LPA,LP)
                  L1P_EDEV  (LPA,NP) = L1P_EDEV (LPA,LP)
                  L1P_IATOM (LPA,NP) = L1P_IATOM(LPA,LP)
                  L1P_DEV   (LPA,NP) = L1P_DEV  (LPA,LP)
                  L1P_ATOM  (LPA,NP) = L1P_ATOM (LPA,LP)
                ENDDO
              ENDIF
            ENDDO
            L1P_NPLAN = NP
c
          ENDIF
        ENDIF

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF5:',mod
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF
 
      IF(L1L_PRSNT.EQ.'Y'.OR.L1L_PRSNT.EQ.'.') THEN
      IF(TREE.EQ.'Y') THEN
        PNUM = ' '
        CALL SET_NUM_MOD(MDOC,L1L_MNAME,PNUM,IERR)
        IF(IERR.NE.0) THEN
          TREE = 'N' 
          IERR = 0
        ENDIF
      ENDIF
      ENDIF

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIF6:::',mod,tree
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
       write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF
 
      IF(TREE.EQ.'Y'.AND.
     *   ((ISTART .NE.0.AND.ISTART .NE.L1A_ISTART ).OR.
     *    (IFINISH.NE.0.AND.IFINISH.NE.L1A_IFINISH)    )) THEN
        IF(ISTART.EQ.L1A_IFINISH.AND.ISTART.GT.0) THEN
          ITYPE = 0
          CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)
          IF(IERR.NE.0) THEN
            TREE = 'N'
            IERR = 0
            GO TO 200
          ENDIF
        ENDIF
        IF(ISTART.NE.L1A_ISTART.AND.ISTART.GT.0) THEN
          ITYPE = 1
          CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)
          IF(IERR.NE.0) THEN
            TREE = 'N'
            IERR = 0
            GO TO 200
          ENDIF
        ENDIF
        IF(IFINISH.NE.L1A_IFINISH.AND.IFINISH.GT.0) THEN
          ITYPE = 2
          CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)
          IF(IERR.NE.0) THEN
            TREE = 'N'
            IERR = 0
            GO TO 200
          ENDIF
        ENDIF
      ENDIF
 200  CONTINUE

      IF(LIST.EQ.'T') THEN
      WRITE(*,*) '--MODIFend:',mod
      WRITE(*,*) ' L1L_MNAME,L1L_PRSNT:',L1L_MNAME,L1L_PRSNT
      WRITE(*,*) ' na,nb,ng:',L1A_NATOM,l1b_nbond,l1g_nangl
      WRITE(*,*) ' s,f:',L1A_ISTART,L1A_IFINISH
      DO I=1,L1A_NATOM
        write(*,*) '::',i,L1A_ANAME(i),L1A_BACK(I),L1A_FORW(I)
      enddo   
      WRITE(*,*) '-----'
      ENDIF
 
      RETURN
      END

      SUBROUTINE MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C --
      CHARACTER TYPE*8,TYPE_T*8
C -----------------------------------------------
      IERR = 0

      IF(ITYPE.EQ.0) THEN

C       revers
C        write(*,*) '   revers:',istart,ifinish

        I            = L1A_IFINISH 
        L1A_BACK (I) = '.'         
        L1A_IBACK(I) = -1
        
  100     CONTINUE

          IF(I.LE.0) GO TO 400
          J = L1A_IBACK(I)
          IF(J.LE.0) GO TO 110

          IF(I.GT.0.AND.J.GT.0) THEN

            L1A_IBACK(J) = I 
            L1A_BACK (J) = L1A_ANAME(I)
            TYPE         = L1A_TYPE (J)
            L1A_TYPE (J) = L1A_TYPE (I)
            L1A_FORW (I) = L1A_ANAME(J)
            L1A_IFORW(I) = J
            L1A_TYPE (I) = TYPE  

          ELSE
            GO TO 400
          ENDIF

          I = J
          GO TO 100

  110   CONTINUE

        IST          = L1A_ISTART
        L1A_ISTART   = L1A_IFINISH
        L1A_IFINISH  = I
        L1A_FORW (I) = 'END'         
        L1A_IFORW(I) = -1

      ELSE IF(ITYPE.EQ.1) THEN

C       new start       
C        write(*,*) '   new start:',istart

        I    = ISTART 
        II   = 0
        TYPE = '.'
        
  200     CONTINUE

          IF(I.LE.0) GO TO 400

          J = L1A_IBACK(I)
          IF(J.LE.0) GO TO 210

          IF(I.GT.0.AND.II.GT.0) THEN
            L1A_IBACK(I) = II 
            TYPE_T       = L1A_TYPE (I)
            L1A_BACK (I) = L1A_ANAME(II)
            L1A_TYPE (I) = TYPE
            TYPE         = TYPE_T
          ENDIF   

          L1A_FORW (I) = L1A_ANAME(J)
          L1A_IFORW(I) = J 

          II = I 
          I  = J
          GO TO 200

  210   CONTINUE

        IF(I.GT.0.AND.II.GT.0) THEN
          L1A_IBACK(I) = II 
          L1A_BACK (I) = L1A_ANAME(II)
          L1A_TYPE (I) = TYPE
          L1A_FORW (I) = '.'
          L1A_IFORW(I) = 0 
        ENDIF   

        L1A_ISTART        = ISTART
        L1A_BACK (ISTART) = '.'         
        L1A_IBACK(ISTART) = -1
c ----
C       check backbon
C       

          I            = L1A_IFINISH 
          IF(I.GT.0) THEN
            L1A_FORW (I) = 'END'         
            L1A_IFORW(I) = -1
          ENDIF
 
  220     CONTINUE

          IF(I.LE.0) GO TO 400
          J = L1A_IBACK(I)
          IF(J.LE.0) GO TO 230

          IF(J.GT.0.AND.I.GT.0) THEN
            L1A_FORW (J) = L1A_ANAME(I)
            L1A_IFORW(J) = I
c            GO TO 230 
          ENDIF

          I = J
          GO TO 220

  230   CONTINUE

c ----
      ELSE IF(ITYPE.EQ.2) THEN

C       new finish
C        write(*,*) '   new finish:',ifinish

          I            = IFINISH 
          IF(IFINISH.GT.0) THEN
            L1A_FORW (I) = 'END'         
            L1A_IFORW(I) = -1
          ENDIF
  300     CONTINUE

          IF(I.LE.0) GO TO 400
          J = L1A_IBACK(I)
          IF(J.LE.0) GO TO 310

          IF(J.GT.0.AND.I.GT.0) THEN
            L1A_FORW (J) = L1A_ANAME(I)
            L1A_IFORW(J) = I
c            GO TO 310 
          ENDIF

          I = J
          GO TO 300

  310   CONTINUE

        IF(L1A_IFINISH.GT.0) THEN
          L1A_FORW (L1A_IFINISH) = '.'
          L1A_IFORW(L1A_IFINISH) = 0
        ENDIF

        L1A_IFINISH   = IFINISH

      ENDIF

      RETURN
 400  CONTINUE
      IERR = 1
      RETURN

      END

      SUBROUTINE MOD_AMLIB(MDOC,MOD,IA,TREE,ISTART,IFINISH
     *         ,IDELA,IDELN,IDELB,IDELG,IDELT,IDELC,IDELP,IERR)
C -----------------------------------------------
C -P- MOD_AMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IA,IERR
      CHARACTER MOD*8,TREE*1
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      REAL      CHARG
      CHARACTER LINE*256,FUNCT*8
      CHARACTER ANAME*4,ANEW*4,SYMB*4,CHEM*4
C ---
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C -----------------------------------
      IERR = 0
      IF(LDA_NATOM.LE.0.OR.LDA_NATOM.LT.IA.OR.IA.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of atoms in monomer = 0')
c        IERR = 1
        RETURN
      ENDIF

      DO   L=IA,LDA_NATOM
        IF(MOD.EQ.LDA_MNAME(L)) THEN
          FUNCT = LDA_FUNCT(L)
          ANAME = LDA_ANAME(L)
          ANEW  = LDA_ANEW (L)
          SYMB  = LDA_SYMB (L)
          CHEM  = LDA_CHEM (L)
          CHARG = LDA_CHARG(L)
             
          IF(FUNCT(1:6).EQ.'delete') THEN
            IF(L1A_NATOM.LE.0) THEN
              WRITE(LINE,'(5A)')' WARNING: number of atoms in mon ',
     *  L1L_MNAME,' for mod ',MOD,' = 0'
              CALL MSGDOC(MDOC,LINE)
              IERR=0
              GO TO 100
            ENDIF

            DO LA=1,L1A_NATOM
              IF(ANAME.EQ.L1A_ANAME(LA)) THEN

                L1A_ANAME(LA) = '    '
                L1A_ATYPE(LA) = 'D'
                IDELA = 1

                DO LAJ=1,L1A_NATOM
C                  IF(ANAME.EQ.L1A_BACK(LAJ)) THEN
C                    L1A_BACK(LAJ) = '.'
C                  ENDIF
                  IF(ANAME.EQ.L1A_FORW(LAJ)) THEN
                    L1A_FORW(LAJ) = '.'
                  ENDIF
                ENDDO

                IF(LA.EQ.L1A_ISTART) THEN
                  ISTART            = L1A_IFORW(LA)
                  IF(ISTART.GT.0) THEN
                    L1A_IBACK(ISTART) = -1 
                    L1A_BACK(ISTART)  = '.' 
                    L1A_ISTART        = ISTART
                  ENDIF
                ELSE IF(LA.EQ.L1A_IFINISH) THEN 
                  IFINISH            = L1A_IBACK(LA)
                  IF(IFINISH.GT.0) THEN 
                    L1A_IFORW(IFINISH) = -1 
                    L1A_FORW(IFINISH)  = 'END' 
                    L1A_IFINISH        = IFINISH
                  ENDIF
                ENDIF

                IF(L1B_NBOND.GT.0) THEN
                  DO LB=1,L1B_NBOND
                    IF(ANAME.EQ.L1B_1ATM(LB).OR.
     *                 ANAME.EQ.L1B_2ATM(LB)) THEN
                      L1B_1ATM(LB) = '    '
                      L1B_2ATM(LB) = '    '
                      IDELB        = 1
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1G_NANGL.GT.0) THEN
                  DO LG=1,L1G_NANGL
                    IF(ANAME.EQ.L1G_1ATM(LG).OR.
     *                 ANAME.EQ.L1G_2ATM(LG).OR.
     *                 ANAME.EQ.L1G_3ATM(LG)) THEN
                      L1G_1ATM(LG) = '    '
                      L1G_2ATM(LG) = '    '
                      L1G_3ATM(LG) = '    '
                      IDELG        = 1
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1T_NTORS.GT.0) THEN
                  DO LT=1,L1T_NTORS
                    IF(ANAME.EQ.L1T_1ATM(LT).OR.
     *                 ANAME.EQ.L1T_2ATM(LT).OR.
     *                 ANAME.EQ.L1T_3ATM(LT).OR.
     *                 ANAME.EQ.L1T_4ATM(LT)) THEN
                      L1T_1ATM(LT) = '    '
                      L1T_2ATM(LT) = '    '
                      L1T_3ATM(LT) = '    '
                      L1T_4ATM(LT) = '    '
                      IDELT        = 1
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1C_NCHIR.GT.0) THEN
                  DO LC=1,L1C_NCHIR
                    IF(ANAME.EQ.L1C_1ATM(LC).OR.
     *                 ANAME.EQ.L1C_2ATM(LC).OR.
     *                 ANAME.EQ.L1C_3ATM(LC).OR.
     *                 ANAME.EQ.L1C_4ATM(LC).OR.
     *                 ANAME.EQ.L1C_5ATM(LC).OR.
     *                 ANAME.EQ.L1C_6ATM(LC).OR.
     *                 ANAME.EQ.L1C_7ATM(LC).OR.
     *                 ANAME.EQ.L1C_8ATM(LC).OR.
     *                 ANAME.EQ.L1C_9ATM(LC)) THEN
                      L1C_1ATM(LC) = '    '
                      L1C_2ATM(LC) = '    '
                      L1C_3ATM(LC) = '    '
                      L1C_4ATM(LC) = '    '
                      L1C_5ATM(LC) = '    '
                      L1C_6ATM(LC) = '    '
                      L1C_7ATM(LC) = '    '
                      L1C_8ATM(LC) = '    '
                      L1C_9ATM(LC) = '    '
                      IDELC        = 1
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1N_NCONN.GT.0) THEN
                  DO LN=1,L1N_NCONN
                    IF(ANAME.EQ.L1N_1ATM(LN).OR.
     *                 ANAME.EQ.L1N_2ATM(LN)    ) THEN
                      L1N_1ATM(LN) = '    '
                      L1N_2ATM(LN) = '    '
                      IDELN        = 1
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1P_NPLAN.GT.0) THEN
                  ATOM = ANAME
                  DO LP=1,L1P_NPLAN
                    IF(L1P_NATOM(LP).GT.0) THEN
                      DO IA1=1,L1P_NATOM(LP)
                        IF(L1P_ATOM(IA1,LP).EQ.IATOM) THEN
                          L1P_ATOM(IA1,LP) = 0
                        ENDIF
                      ENDDO
                    ENDIF
                  ENDDO
                  IDELP = 1
                ENDIF
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:6).EQ.'change') THEN
            IF(L1A_NATOM.LE.0) THEN
              WRITE(LINE,'(5A)')' WARNING: number of atoms in mon ',
     * L1L_MNAME,' for mod ',MOD,' = 0'
              CALL MSGDOC(MDOC,LINE)
              IERR=0
              GO TO 100
            ENDIF
            DO LA=1,L1A_NATOM
              IF(ANAME.EQ.L1A_ANAME(LA)) THEN

                IF(ABS(CHARG).GT.0.0) L1A_CHARG(LA) = CHARG
                IF(ANEW(1:1).NE.'.')  L1A_ANAME(LA) = ANEW
                IF(SYMB(1:1).NE.'.')  L1A_SYMB (LA) = SYMB  
                IF(CHEM(1:1).NE.'.')  L1A_CHEM (LA) = CHEM 

                IF(ANEW(1:1).EQ.'.') GO TO 100
                IF(L1B_NBOND.GT.0) THEN
                  DO LB=1,L1B_NBOND
                    IF(ANAME.EQ.L1B_1ATM(LB)) THEN
                      L1B_1ATM(LB) = ANEW
                    ELSE IF(ANAME.EQ.L1B_2ATM(LB)) THEN
                      L1B_2ATM(LB) = ANEW
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1G_NANGL.GT.0) THEN
                  DO LG=1,L1G_NANGL
                    IF(ANAME.EQ.L1G_1ATM(LG)) THEN
                      L1G_1ATM(LG) = ANEW
                    ELSE IF(ANAME.EQ.L1G_2ATM(LG)) THEN
                      L1G_2ATM(LG) = ANEW
                    ELSE IF(ANAME.EQ.L1G_3ATM(LG)) THEN
                      L1G_3ATM(LG) = ANEW
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1T_NTORS.GT.0) THEN
                  DO LT=1,L1T_NTORS
                    IF(ANAME.EQ.L1T_1ATM(LT)) THEN
                      L1T_1ATM(LT) = ANEW
                    ELSE IF(ANAME.EQ.L1T_2ATM(LT)) THEN
                      L1T_2ATM(LT) = ANEW
                    ELSE IF(ANAME.EQ.L1T_3ATM(LT)) THEN
                      L1T_3ATM(LT) = ANEW
                    ELSE IF(ANAME.EQ.L1T_4ATM(LT)) THEN
                      L1T_4ATM(LT) = ANEW
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1C_NCHIR.GT.0) THEN
                  DO LC=1,L1C_NCHIR
                    IF(ANAME.EQ.L1C_1ATM(LC)) THEN
                      L1C_1ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_2ATM(LC)) THEN
                      L1C_2ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_3ATM(LC)) THEN
                      L1C_3ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_4ATM(LC)) THEN
                      L1C_4ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_5ATM(LC)) THEN
                      L1C_5ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_6ATM(LC)) THEN
                      L1C_6ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_7ATM(LC)) THEN
                      L1C_7ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_8ATM(LC)) THEN
                      L1C_8ATM(LC) = ANEW
                    ELSE IF(ANAME.EQ.L1C_9ATM(LC)) THEN
                      L1C_9ATM(LC) = ANEW
                    ENDIF
                  ENDDO
                ENDIF
                IF(L1N_NCONN.GT.0) THEN
                  DO LN=1,L1N_NCONN
                    IF(ANAME.EQ.L1N_1ATM(LN)) THEN
                      L1N_1ATM(LN) = ANEW
                    ELSE IF(ANAME.EQ.L1N_2ATM(LN)) THEN
                      L1N_2ATM(LN) = ANEW
                    ENDIF
                  ENDDO
                ENDIF
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:3).EQ.'add') THEN
            IF(L1A_NATOM.GT.MAX1ATM) THEN
              WRITE(LINE,'(3A,I6)')
     *' WARNING: number of atoms in monomer ',L1L_MNAME,' for mod  >',
     *   MAX1ATM
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC
     * ,'         Change parameter MAX1ATM in "lib_com.fh"')
              IERR=0
              GO TO 100
            ENDIF

            DO I=1,L1A_NATOM
              IF(L1A_ANAME(I).EQ.ANEW) GO TO 100 
            ENDDO

            L1A_NATOM = L1A_NATOM+1

            L1A_COOR_FLAG(L1A_NATOM) = 'N'
            L1A_CHARG(L1A_NATOM) = CHARG
            L1A_X    (L1A_NATOM) = 0.0
            L1A_Y    (L1A_NATOM) = 0.0
            L1A_Z    (L1A_NATOM) = 0.0
            L1A_INEW (L1A_NATOM) = L1A_NATOM 
            L1A_IOLD (L1A_NATOM) = L1A_NATOM
            L1A_ICR  (L1A_NATOM) = 0
            L1A_NDIST(L1A_NATOM) = 0
            L1A_IBACK(L1A_NATOM) = 0
            L1A_IFORW(L1A_NATOM) = 0
            L1A_BACK (L1A_NATOM) = ' '
            L1A_TYPE (L1A_NATOM) = ' ' 
            L1A_FORW (L1A_NATOM) = ' ' 
            L1A_ANAME(L1A_NATOM) = ANEW
            L1A_SYMB (L1A_NATOM) = SYMB  
            L1A_CHEM (L1A_NATOM) = CHEM 
            IF(L1A_SYMB(L1A_NATOM)(1:2).NE.'H '.AND.
     *         L1A_SYMB(L1A_NATOM)(1:2).NE.'D ' )
     *         L1A_NHATOM = L1A_NHATOM + 1
            L1A_ATYPE(L1A_NATOM) = 'M'
            DO  J=1,MAX1BRN 
              L1A_CONN   (J,L1A_NATOM) = 0
              L1A_LENCON (J,L1A_NATOM) = 0
            ENDDO
            DO  J=1,MAX1EXT 
              L1A_IEXTR (J,L1A_NATOM) = 0
              L1A_TEXTR (J,L1A_NATOM) = 0
            ENDDO
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  


      RETURN
      END

      SUBROUTINE MOD_NMLIB(MDOC,MOD,IN,TREE,ISTART,IFINISH
     *  ,ISTART_OLD,IFINISH_OLD,IDEL,IERR)
C -----------------------------------------------
C -P- MOD_NMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IN,IERR,IDEL
      CHARACTER MOD*8,TREE*1
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256,FUNCT*8
      CHARACTER BACK*4,FORW*4,ATOM*4,ATM1*4,ATM2*4,BTYPE*8,TYPE*8
C -----------------------------------
      IERR = 0
      IF(LDN_NCONN.LE.0.OR.LDN_NCONN.LT.IN.OR.IN.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of conn. in monomer = 0.')
c        IERR = 1
        RETURN
      ENDIF

      IDEL = 0

      DO   L=IN,LDN_NCONN

        IF(MOD.EQ.LDN_MNAME(L)) THEN
          FUNCT = LDN_FUNCT(L)
          BACK  = LDN_BACK (L)
          FORW  = LDN_FORW (L)
          ATOM  = LDN_ATOM (L)
          ATM1  = LDN_1ATM (L)
          ATM2  = LDN_2ATM (L)
          BTYPE = LDN_BTYPE(L)
          TYPE  = LDN_TYPE (L)

          IF(FUNCT(1:6).EQ.'delete') THEN

C            IF(L1A_NATOM.GT.0) THEN
C            DO LA=1,L1A_NATOM
C              IF(ATOM.EQ.L1A_ANAME(LA)) THEN
C                L1A_BACK (LA) = ' '
C                L1A_FORW (LA) = ' '
C                L1A_TYPE (LA) = ' '
C                GO TO 100
C              ENDIF
C            ENDDO
C            ENDIF

            IF(L1N_NCONN.GT.0) THEN
            DO LN=1,L1N_NCONN
              IF((ATM1.EQ.L1N_1ATM(LN).AND.ATM2.EQ.L1N_2ATM(LN)).OR.
     *           (ATM2.EQ.L1N_1ATM(LN).AND.ATM1.EQ.L1N_2ATM(LN))) THEN
                L1N_1ATM (LN) = ' '
                L1N_2ATM (LN) = ' '
                L1N_TYPE (LN) = ' '
                GO TO 100
              ENDIF
            ENDDO
            ENDIF

          ELSE IF(FUNCT(1:6).EQ.'change') THEN

            IF(L1A_NATOM.GT.0) THEN
              DO LA=1,L1A_NATOM
                IF(ATOM.EQ.L1A_ANAME(LA)) THEN
                  IF(BACK (1:1).NE.'.') THEN
                    IF(L1A_BACK(LA).EQ.'.'.OR.L1A_BACK(LA).EQ.'n/a'.OR.
     *                 L1A_BACK(LA).EQ.'START') THEN
                      ISTART_OLD = LA
                    ENDIF
                    L1A_BACK(LA) = BACK 
                  ENDIF
                  IF(FORW (1:1).NE.'.') THEN
                    IF(L1A_FORW(LA).EQ.'END') THEN
                      IFINISH_OLD = LA
                    ENDIF
                    L1A_FORW(LA) = FORW
                  ENDIF
                  IF(BTYPE(1:1).NE.'.') L1A_TYPE(LA) = BTYPE
C                 IF(TYPE (1:3).EQ.'END'  ) L1A_FORW(LA) = 'END'
C                 IF(TYPE (1:5).EQ.'START') L1A_BACK(LA) = '.'
                  IF(TYPE (1:3).EQ.'END'  ) IFINISH = LA
                  IF(TYPE (1:5).EQ.'START') ISTART  = LA
                  GO TO 100
                ENDIF
              ENDDO
            ENDIF

            IF(L1N_NCONN.GT.0) THEN
            DO LN=1,L1N_NCONN
              IF((ATM1.EQ.L1N_1ATM(LN).AND.ATM2.EQ.L1N_2ATM(LN)).OR.
     *           (ATM2.EQ.L1N_1ATM(LN).AND.ATM1.EQ.L1N_2ATM(LN))) THEN
                L1N_1ATM (LN) = ATM1
                L1N_2ATM (LN) = ATM2
                L1N_TYPE (LN) = TYPE
                GO TO 100
              ENDIF
            ENDDO
            ENDIF

          ELSE IF(FUNCT(1:3).EQ.'add') THEN

            IF(L1A_NATOM.GT.0) THEN
              DO LA=1,L1A_NATOM
                IF(ATOM.EQ.L1A_ANAME(LA)) THEN

                  IF(BACK (1:1).NE.'.') L1A_BACK(LA) = BACK 
                  IF(FORW (1:1).NE.'.') L1A_FORW(LA) = FORW
                  IF(BTYPE(1:1).NE.'.') L1A_TYPE(LA) = BTYPE
C                  IF(TYPE (1:3).EQ.'END'  ) L1A_FORW(LA) = 'END'
C                  IF(TYPE (1:5).EQ.'START') L1A_BACK(LA) = '.'
                  IF(TYPE (1:3).EQ.'END'  ) IFINISH = LA
                  IF(TYPE (1:5).EQ.'START') ISTART  = LA
                  GO TO 100
                ENDIF
              ENDDO
            ENDIF
 
            IF(L1N_NCONN.GT.0) THEN
            DO LN=1,L1N_NCONN
              IF((ATM1.EQ.L1N_1ATM(LN).AND.ATM2.EQ.L1N_2ATM(LN)).OR.
     *           (ATM2.EQ.L1N_1ATM(LN).AND.ATM1.EQ.L1N_2ATM(LN))) THEN
                L1N_1ATM (LN) = ATM1
                L1N_2ATM (LN) = ATM2
                L1N_TYPE (LN) = TYPE
                GO TO 100
              ENDIF
            ENDDO
            ENDIF


            IF(L1N_NCONN.GT.MAX1CONN) THEN
              WRITE(LINE,'(3A,I6)')
     *' WARNING: number of CONNs in monomer ',L1L_MNAME,' for mod  >',
     *    MAX1CONN
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC
     * ,'         Change parameter MAX1CONN in "lib_com.fh"')
              IERR=0
              GO TO 100
            ENDIF
            L1N_NCONN            = L1N_NCONN + 1
            L1N_1ATM (L1N_NCONN) = ATM1 
            L1N_2ATM (L1N_NCONN) = ATM2
            L1A_TYPE (L1N_NCONN) = TYPE
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  

      RETURN
      END

      SUBROUTINE MOD_BMLIB(MDOC,MOD,IB,IDEL,IERR)
C -----------------------------------------------
C -P- MOD_BMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IB,IERR
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      REAL      VAL,VOBS,DEV
      CHARACTER LINE*256,FUNCT*8
      CHARACTER ATM1*4,ATM2*4,TYPE*8
C -----------------------------------
      IERR = 0
      IF(LDB_NBOND.LE.0.OR.LDB_NBOND.LT.IB.OR.IB.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of bonds in monomer = 0')
c        IERR=1
        RETURN
      ENDIF

      DO   L=IB,LDB_NBOND
        IF(MOD.EQ.LDB_MNAME(L)) THEN
          FUNCT=LDB_FUNCT(L)
          ATM1 =LDB_1ATM (L)
          ATM2 =LDB_2ATM (L)
          TYPE =LDB_TYPE (L)
          VAL  =LDB_VAL  (L)
          VOBS =LDB_VOBS (L)
          DEV  =LDB_DEV  (L)
          IF(FUNCT(1:6).EQ.'delete') THEN
            IF(L1B_NBOND.LE.0) THEN
c              WRITE(LINE,
c     *''WARNING: number of bonds in mon '',A,'' for mod '',A,'' = 0''
c     *)')     L1L_MNAME,MOD 
c              CALL MSGERR(MDOC,LINE)
              IERR=0
              GO TO 100
            ENDIF
            DO LB=1,L1B_NBOND
              IF( ((ATM1.EQ.L1B_1ATM(LB)).AND.(ATM2.EQ.L1B_2ATM(LB))) 
     *        .OR.((ATM2.EQ.L1B_1ATM(LB)).AND.(ATM1.EQ.L1B_2ATM(LB)))) 
     *          THEN
                L1B_1ATM(LB)='    '
                L1B_2ATM(LB)='    '
                IDEL=1
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:6).EQ.'change') THEN
            IF(L1B_NBOND.LE.0) THEN
c              WRITE(LINE,'(
c     *'' WARNING: number of bonds in mon '',A,'' for mod '',A,'' = 0''
c     *)')     L1L_MNAME,MOD 
c              CALL MSGERR(MDOC,LINE)
               IERR=0
              GO TO 100
            ENDIF
            DO LB=1,L1B_NBOND
              IF( ((ATM1.EQ.L1B_1ATM(LB)).AND.(ATM2.EQ.L1B_2ATM(LB))) 
     *        .OR.((ATM2.EQ.L1B_1ATM(LB)).AND.(ATM1.EQ.L1B_2ATM(LB)))) 
     *          THEN
                IF(ABS(VAL) .GT.0.0) L1B_VAL (LB)  = VAL
                IF(ABS(VOBS).GT.0.0) L1B_VOBS(LB)  = VOBS
                IF(ABS(DEV) .GT.0.0) L1B_DEV (LB)  = DEV
                IF(TYPE(1:1).NE.'.') L1B_TYPE(LB)  = TYPE
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:3).EQ.'add') THEN
            IF(L1B_NBOND.GT.MAX1BND) THEN
              WRITE(LINE,'(3A,I6)')
     * ' WARNING: number of bonds in monomer ',MAX1BND,' for mod  >',
     *    MAX1BND
              CALL MSGERR(MDOC
     * ,'         Change parameter MAX1BND in "lib_com.fh"')
              IERR=0
              GO TO 100
            ENDIF

            IF(L1B_NBOND.GT.0) THEN
            DO LB=1,L1B_NBOND
              IF( ((ATM1.EQ.L1B_1ATM(LB)).AND.(ATM2.EQ.L1B_2ATM(LB))) 
     *        .OR.((ATM2.EQ.L1B_1ATM(LB)).AND.(ATM1.EQ.L1B_2ATM(LB)))) 
     *          THEN
                IF(ABS(VAL) .GT.0.0) L1B_VAL (LB)  = VAL
                IF(ABS(VOBS).GT.0.0) L1B_VOBS(LB)  = VOBS
                IF(ABS(DEV) .GT.0.0) L1B_DEV (LB)  = DEV
                IF(TYPE(1:1).NE.'.') L1B_TYPE(LB)  = TYPE
                GO TO 100
              ENDIF
            ENDDO
            ENDIF

            L1B_NBOND = L1B_NBOND+1

            L1B_I1ATM(L1B_NBOND) = 0
            L1B_I2ATM(L1B_NBOND) = 0
            L1B_1ATM (L1B_NBOND) = ATM1 
            L1B_2ATM (L1B_NBOND) = ATM2
            L1B_TYPE (L1B_NBOND) = TYPE
            L1B_FLAG (L1B_NBOND) = ' '
            L1B_VOBS (L1B_NBOND) = VOBS  
            L1B_VAL  (L1B_NBOND) = VAL 
            L1B_DEV  (L1B_NBOND) = DEV 
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  
      RETURN
      END

      SUBROUTINE MOD_GMLIB(MDOC,MOD,IG,IDEL,IERR)
C -----------------------------------------------
C -P- MOD_GMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IG,IERR
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      REAL      VAL,VOBS,DEV
      CHARACTER LINE*256,FUNCT*8
      CHARACTER ATM1*4,ATM2*4,ATM3*4
C     CHARACTER TYPE*8
C -----------------------------------
      IERR = 0
      IF(LDG_NANGL.LE.0.OR.LDG_NANGL.LT.IG.OR.IG.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of angles in monomer = 0')
c        IERR=1
        RETURN
      ENDIF

      DO   L=IG,LDG_NANGL
        IF(MOD.EQ.LDG_MNAME(L)) THEN
          FUNCT=LDG_FUNCT(L)
          ATM1 =LDG_1ATM (L)
          ATM2 =LDG_2ATM (L)
          ATM3 =LDG_3ATM (L)
          VAL  =LDG_VAL  (L)
          VOBS =LDG_VOBS (L)
          DEV  =LDG_DEV  (L)
          IF(FUNCT(1:6).EQ.'delete') THEN
            IF(L1G_NANGL.LE.0) THEN
c              WRITE(LINE,'(
c     *''WARNING: number of angles in mon '',A,'' for mod '',A,'' = 0''
c     *)') L1L_MNAME,MOD 
c              CALL MSGERR(MDOC,LINE)
              IERR=0
              GO TO 100
            ENDIF
            DO LG=1,L1G_NANGL
              IF( ((ATM1.EQ.L1G_1ATM(LG)).AND.(ATM2.EQ.L1G_2ATM(LG)) 
     *                                   .AND.(ATM3.EQ.L1G_3ATM(LG))) 
     *        .OR.((ATM3.EQ.L1G_1ATM(LG)).AND.(ATM2.EQ.L1G_2ATM(LG))
     *                                   .AND.(ATM1.EQ.L1G_3ATM(LG)))) 
     *          THEN
                L1G_1ATM(LG)='    '
                L1G_2ATM(LG)='    '
                L1G_3ATM(LG)='    '
                IDEL=1
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:6).EQ.'change') THEN
            IF(L1G_NANGL.LE.0) THEN
c              WRITE(LINE,'(
c     *'' WARNING: number of angles in mon '',A,'' for mod '',A,'' = 0''
c     *)')     L1L_MNAME,MOD 
c              CALL MSGERR(MDOC,LINE)
              IERR=0
              GO TO 100
            ENDIF
            DO LG=1,L1G_NANGL
              IF( ((ATM1.EQ.L1G_1ATM(LG)).AND.(ATM2.EQ.L1G_2ATM(LG)) 
     *                                   .AND.(ATM3.EQ.L1G_3ATM(LG))) 
     *        .OR.((ATM3.EQ.L1G_1ATM(LG)).AND.(ATM2.EQ.L1G_2ATM(LG))
     *                                   .AND.(ATM1.EQ.L1G_3ATM(LG)))) 
     *          THEN
                IF(ABS(VAL) .GT.0.0) L1G_VAL (LG)  = VAL
                IF(ABS(VOBS).GT.0.0) L1G_VOBS(LG)  = VOBS
                IF(ABS(DEV) .GT.0.0) L1G_DEV (LG)  = DEV
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:3).EQ.'add') THEN
            IF(L1G_NANGL.GT.MAX1ANG) THEN
          WRITE(LINE,'(3A,I6)')' WARNING: number of angles in monomer ',
     *        L1L_MNAME,' for mod  >',MAX1ANG
              CALL MSGERR(MDOC
     * ,'         Change parameter MAX1ANG in "lib_com.fh"')
              IERR=0
              GO TO 100
            ENDIF

            IF(L1G_NANGL.GT.0) THEN
            DO LG=1,L1G_NANGL
              IF( ((ATM1.EQ.L1G_1ATM(LG)).AND.(ATM2.EQ.L1G_2ATM(LG)) 
     *                                   .AND.(ATM3.EQ.L1G_3ATM(LG))) 
     *        .OR.((ATM3.EQ.L1G_1ATM(LG)).AND.(ATM2.EQ.L1G_2ATM(LG))
     *                                   .AND.(ATM1.EQ.L1G_3ATM(LG)))) 
     *          THEN
                IF(ABS(VAL) .GT.0.0) L1G_VAL (LG)  = VAL
                IF(ABS(VOBS).GT.0.0) L1G_VOBS(LG)  = VOBS
                IF(ABS(DEV) .GT.0.0) L1G_DEV (LG)  = DEV
                GO TO 100
              ENDIF
            ENDDO
            ENDIF

            L1G_NANGL = L1G_NANGL+1

            L1G_I1ATM(L1G_NANGL) = 0
            L1G_I2ATM(L1G_NANGL) = 0
            L1G_I3ATM(L1G_NANGL) = 0
            L1G_1ATM (L1G_NANGL) = ATM1 
            L1G_2ATM (L1G_NANGL) = ATM2
            L1G_3ATM (L1G_NANGL) = ATM3
            L1G_FLAG (L1G_NANGL) = ' '
            L1G_VOBS (L1G_NANGL) = VOBS  
            L1G_VAL  (L1G_NANGL) = VAL 
            L1G_DEV  (L1G_NANGL) = DEV 
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  
      RETURN
      END

      SUBROUTINE MOD_TMLIB(MDOC,MOD,IT,IDEL,IERR)
C -----------------------------------------------
C -P- MOD_TMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IT,IERR
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      REAL      VAL,VOBS,DEV
      INTEGER   IPRD
      CHARACTER LINE*256,FUNCT*8
      CHARACTER ATM1*4,ATM2*4,ATM3*4,ATM4*4,LABEL*8
C -----------------------------------
      IERR = 0
      IF(LDT_NTORS.LE.0.OR.LDT_NTORS.LT.IT.OR.IT.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of tors in monomer = 0')
c        IERR=1
        RETURN
      ENDIF

      DO   L=IT,LDT_NTORS
        IF(MOD.EQ.LDT_MNAME(L)) THEN
          FUNCT = LDT_FUNCT(L)
          ATM1  = LDT_1ATM (L)
          ATM2  = LDT_2ATM (L)
          ATM3  = LDT_3ATM (L)
          ATM4  = LDT_4ATM (L)
          VAL   = LDT_VAL  (L)
          VOBS  = LDT_VOBS (L)
          DEV   = LDT_DEV  (L)
          IPRD  = LDT_PRD  (L)
          LABEL = LDT_LABEL(L)
          IF(FUNCT(1:6).EQ.'delete') THEN
            IF(L1T_NTORS.LE.0) THEN
              IERR = 0
              GO TO 100
            ENDIF
            DO LT=1,L1T_NTORS
              IF((ATM1.EQ.L1T_1ATM(LT).AND.ATM2.EQ.L1T_2ATM(LT).AND. 
     *            ATM3.EQ.L1T_3ATM(LT).AND.ATM4.EQ.L1T_4ATM(LT) )    
     *       .OR.(ATM4.EQ.L1T_1ATM(LT).AND.ATM3.EQ.L1T_2ATM(LT).AND.
     *            ATM2.EQ.L1T_3ATM(LT).AND.ATM1.EQ.L1T_4ATM(LT) ) ) THEN 
                L1T_1ATM(LT)='    '
                L1T_2ATM(LT)='    '
                L1T_3ATM(LT)='    '
                L1T_4ATM(LT)='    '
                IDEL = 1
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:6).EQ.'change') THEN
            IF(L1T_NTORS.LE.0) THEN
              IERR=0
              GO TO 100
            ENDIF
            DO LT=1,L1T_NTORS
              IF((ATM1.EQ.L1T_1ATM(LT).AND.ATM2.EQ.L1T_2ATM(LT).AND. 
     *            ATM3.EQ.L1T_3ATM(LT).AND.ATM4.EQ.L1T_4ATM(LT) )    
     *       .OR.(ATM4.EQ.L1T_1ATM(LT).AND.ATM3.EQ.L1T_2ATM(LT).AND.
     *            ATM2.EQ.L1T_3ATM(LT).AND.ATM1.EQ.L1T_4ATM(LT) ) ) THEN 
                IF(ABS(VAL)  .GT.0.0) L1T_VAL  (LT) = VAL
                IF(ABS(VOBS) .GT.0.0) L1T_VOBS (LT) = VOBS
                IF(ABS(DEV)  .GT.0.0) L1T_DEV  (LT) = DEV
                                      L1T_PRD  (LT) = IPRD
                IF(LABEL(1:1).NE.'.') L1T_LABEL(LT) = LABEL
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:3).EQ.'add') THEN
            IF(L1T_NTORS.GT.MAX1TOR) THEN
          WRITE(LINE,'(3A,I6)')' WARNING: number of tors in monomer ',
     *        L1L_MNAME,' for mod  >',MAX1TOR
              CALL MSGERR(MDOC
     * ,'         Change parameter MAX1TOR in "lib_com.fh"')
              IERR=0
              GO TO 100
            ENDIF

            IF(L1T_NTORS.GT.0) THEN
            DO LT=1,L1T_NTORS
              IF((ATM1.EQ.L1T_1ATM(LT).AND.ATM2.EQ.L1T_2ATM(LT).AND. 
     *            ATM3.EQ.L1T_3ATM(LT).AND.ATM4.EQ.L1T_4ATM(LT) )    
     *       .OR.(ATM4.EQ.L1T_1ATM(LT).AND.ATM3.EQ.L1T_2ATM(LT).AND.
     *            ATM2.EQ.L1T_3ATM(LT).AND.ATM1.EQ.L1T_4ATM(LT) ) ) THEN 
                IF(ABS(VAL)  .GT.0.0) L1T_VAL  (LT) = VAL
                IF(ABS(VOBS) .GT.0.0) L1T_VOBS (LT) = VOBS
                IF(ABS(DEV)  .GT.0.0) L1T_DEV  (LT) = DEV
                                      L1T_PRD  (LT) = IPRD
                IF(LABEL(1:1).NE.'.') L1T_LABEL(LT) = LABEL
                GO TO 100
              ENDIF
            ENDDO
            ENDIF

            L1T_NTORS = L1T_NTORS+1

            L1T_I1ATM(L1T_NTORS) = 0
            L1T_I2ATM(L1T_NTORS) = 0
            L1T_I3ATM(L1T_NTORS) = 0
            L1T_I4ATM(L1T_NTORS) = 0
            L1T_1ATM (L1T_NTORS) = ATM1 
            L1T_2ATM (L1T_NTORS) = ATM2
            L1T_3ATM (L1T_NTORS) = ATM3
            L1T_4ATM (L1T_NTORS) = ATM4
            L1T_FLAG (L1T_NTORS) = ' '
            L1T_VOBS (L1T_NTORS) = VOBS  
            L1T_VAL  (L1T_NTORS) = VAL 
            L1T_DEV  (L1T_NTORS) = DEV 
            L1T_LABEL(L1T_NTORS) = LABEL 
            L1T_PRD  (L1T_NTORS) = IPRD 
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  
      RETURN
      END

      SUBROUTINE MOD_CMLIB(MDOC,MOD,IC,IDEL,IERR)
C -----------------------------------------------
C -P- MOD_CMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IC,IERR
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      REAL      VOL
      CHARACTER LINE*256,FUNCT*8
      CHARACTER ATM1*4,ATM2*4,ATM3*4,ATM4*4,SIGN*8
      CHARACTER ATM5*4,ATM6*4,ATM7*4,ATM8*4,ATM9*4
C -----------------------------------
      IERR = 0
      IF(LDC_NCHIR.LE.0.OR.LDC_NCHIR.LT.IC.OR.IC.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of CHIR in monomer = 0')
c        IERR=1
        RETURN
      ENDIF

      DO   L=IC,LDC_NCHIR
        IF(MOD.EQ.LDC_MNAME(L)) THEN
          FUNCT = LDC_FUNCT(L)
          ATM1  = LDC_1ATM (L)
          ATM2  = LDC_2ATM (L)
          ATM3  = LDC_3ATM (L)
          ATM4  = LDC_4ATM (L)
          ATM5  = LDC_5ATM (L)
          ATM6  = LDC_6ATM (L)
          ATM7  = LDC_7ATM (L)
          ATM8  = LDC_8ATM (L)
          ATM9  = LDC_9ATM (L)
          VOL   = LDC_VOL  (L)
          SIGN  = LDC_SIGN (L)
          IF(FUNCT(1:6).EQ.'delete') THEN
            IF(L1C_NCHIR.LE.0) THEN
              IERR = 0
              GO TO 100
            ENDIF
            DO LC=1,L1C_NCHIR
              IF(((ATM1.EQ.L1C_1ATM(LC).AND.ATM2.EQ.L1C_2ATM(LC).AND. 
     *            ATM3.EQ.L1C_3ATM(LC).AND.ATM4.EQ.L1C_4ATM(LC) )    
     *       .OR.(ATM4.EQ.L1C_1ATM(LC).AND.ATM3.EQ.L1C_2ATM(LC).AND.
     *            ATM2.EQ.L1C_3ATM(LC).AND.ATM1.EQ.L1C_4ATM(LC) ) ) 
     *       .OR.(ATM1.EQ.L1C_1ATM(LC).AND.
     *                    L1C_SIGN(LC)(1:4).EQ.'cros')) THEN
                L1C_1ATM(LC)='.   '
                L1C_2ATM(LC)='.   '
                L1C_3ATM(LC)='.   '
                L1C_4ATM(LC)='.   '
                L1C_5ATM(LC)='.   '
                L1C_6ATM(LC)='.   '
                L1C_7ATM(LC)='.   '
                L1C_8ATM(LC)='.   '
                L1C_9ATM(LC)='.   '
                IDEL = 1
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:6).EQ.'change') THEN
            IF(L1C_NCHIR.LE.0) THEN
              IERR=0
              GO TO 100
            ENDIF
            DO LC=1,L1C_NCHIR
              IF(((ATM1.EQ.L1C_1ATM(LC).AND.ATM2.EQ.L1C_2ATM(LC).AND. 
     *            ATM3.EQ.L1C_3ATM(LC).AND.ATM4.EQ.L1C_4ATM(LC) )    
     *       .OR.(ATM4.EQ.L1C_1ATM(LC).AND.ATM3.EQ.L1C_2ATM(LC).AND.
     *           (ATM2.EQ.L1C_3ATM(LC).AND.ATM1.EQ.L1C_4ATM(LC) ) ) )
     *       .OR.(ATM1.EQ.L1C_1ATM(LC).AND.
     *                    SIGN(1:4).EQ.'cros')) THEN
                IF(ABS(VOL)  .GT.0.0) L1C_VOL  (LC) = VOL
                IF(SIGN(1:1).NE.'.')  L1C_SIGN (LC) = SIGN
                IF(SIGN(1:4).EQ.'cros') THEN
                  L1C_I2ATM(LC) = 0
                  L1C_I3ATM(LC) = 0
                  L1C_I4ATM(LC) = 0
                  L1C_I5ATM(LC) = 0
                  L1C_I6ATM(LC) = 0
                  L1C_I7ATM(LC) = 0
                  L1C_I8ATM(LC) = 0
                  L1C_I9ATM(LC) = 0
                  L1C_2ATM (LC) = ATM2
                  L1C_3ATM (LC) = ATM3
                  L1C_4ATM (LC) = ATM4
                  L1C_5ATM (LC) = ATM5 
                  L1C_6ATM (LC) = ATM6
                  L1C_7ATM (LC) = ATM7
                  L1C_8ATM (LC) = ATM8
                  L1C_9ATM (LC) = ATM9
                ENDIF 
                GO TO 100
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:3).EQ.'add') THEN
            IF(L1C_NCHIR.GT.MAX1CHR) THEN
          WRITE(LINE,'(3A,I6)')' WARNING: number of chir. in monomer ',
     *     L1L_MNAME,' for mod  >',MAX1CHR
              CALL MSGERR(MDOC
     * ,'         Change parameter MAX1CHR in "lib_com.fh"')
              IERR=0
              GO TO 100
            ENDIF

            IF(L1C_NCHIR.GT.0) THEN
            DO LC=1,L1C_NCHIR
              IF((ATM1.EQ.L1C_1ATM(LC).AND.ATM2.EQ.L1C_2ATM(LC).AND. 
     *            ATM3.EQ.L1C_3ATM(LC).AND.ATM4.EQ.L1C_4ATM(LC) )    
     *       .OR.(ATM4.EQ.L1C_1ATM(LC).AND.ATM3.EQ.L1C_2ATM(LC).AND.
     *            ATM2.EQ.L1C_3ATM(LC).AND.ATM1.EQ.L1C_4ATM(LC) ) ) THEN 
                IF(ABS(VOL)  .GT.0.0) L1C_VOL  (LC) = VOL
                IF(SIGN(1:1).NE.'.')  L1C_SIGN (LC) = SIGN
                GO TO 100
              ENDIF
            ENDDO
            ENDIF

            L1C_NCHIR = L1C_NCHIR+1

            L1C_I1ATM(L1C_NCHIR) = 0
            L1C_I2ATM(L1C_NCHIR) = 0
            L1C_I3ATM(L1C_NCHIR) = 0
            L1C_I4ATM(L1C_NCHIR) = 0
            L1C_I5ATM(L1C_NCHIR) = 0
            L1C_I6ATM(L1C_NCHIR) = 0
            L1C_I7ATM(L1C_NCHIR) = 0
            L1C_I8ATM(L1C_NCHIR) = 0
            L1C_I9ATM(L1C_NCHIR) = 0
            L1C_1ATM (L1C_NCHIR) = ATM1 
            L1C_2ATM (L1C_NCHIR) = ATM2
            L1C_3ATM (L1C_NCHIR) = ATM3
            L1C_4ATM (L1C_NCHIR) = ATM4
            L1C_5ATM (L1C_NCHIR) = ATM5 
            L1C_6ATM (L1C_NCHIR) = ATM6
            L1C_7ATM (L1C_NCHIR) = ATM7
            L1C_8ATM (L1C_NCHIR) = ATM8
            L1C_9ATM (L1C_NCHIR) = ATM9
            L1C_FLAG (L1C_NCHIR) = ' '
            L1C_VOL  (L1C_NCHIR) = VOL 
            L1C_SIGN (L1C_NCHIR) = SIGN 
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  
      RETURN
      END

      SUBROUTINE MOD_PMLIB(MDOC,MOD,IP,IDEL,IERR)
C -----------------------------------------------
C -P- MOD_PMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IP,IERR
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
C     REAL      VOL
      CHARACTER LINE*256,FUNCT*8,LABEL*8
C     CHARACTER ATM1*4,ATM2*4,ATM3*4,ATM4*4,SIGN*8
C -----------------------------------
      IERR = 0
      IF(LDP_NPLAN.LE.0.OR.LDP_NPLAN.LT.IP.OR.IP.LE.0) THEN
c        CALL MSGERR(MDOC,' ERR: number of PLAN in monomer = 0')
c        IERR=1
        RETURN
      ENDIF

      DO   L=IP,LDP_NPLAN
        IF(MOD.EQ.LDP_MNAME(L)) THEN

          FUNCT = LDP_FUNCT(L)
          LABEL = LDP_LABEL(L)
          IF(FUNCT(1:6).EQ.'delete') THEN
            IF(L1P_NPLAN.LE.0) THEN
              IERR = 0
              GO TO 100
            ENDIF
            DO LP=1,L1P_NPLAN
              IF(LABEL.EQ.L1P_LABEL(LP)) THEN 
                IF(LDP_NATOM(L).GT.0.AND.L1P_NATOM(LP).GT.0) THEN
                  DO IA=1,LDP_NATOM(L)
                    DO IA1=1,L1P_NATOM(LP)
                      IF(LDP_ATOM(IA,L).EQ.L1P_ATOM(IA1,LP)) THEN
                        L1P_ATOM(IA1,LP) = 0
                        IDEL = 1
                      ENDIF
                    ENDDO
                  ENDDO
                ENDIF
                GO TO 100  
              ENDIF
            ENDDO
          ELSE IF(FUNCT(1:6).EQ.'change') THEN
C           change only L1P_DEV
            IF(L1P_NPLAN.LE.0) THEN
              IERR = 0
              GO TO 100
            ENDIF
            DO LP=1,L1P_NPLAN
              IF(LABEL.EQ.L1P_LABEL(LP)) THEN 
                IF(LDP_NATOM(L).GT.0.AND.L1P_NATOM(LP).GT.0) THEN
                  DO IA=1,LDP_NATOM(L)
                    DO IA1=1,L1P_NATOM(LP)
                      IF(LDP_ATOM(IA,L).EQ.L1P_ATOM(IA1,LP)) THEN
                        L1P_DEV(IA1,LP) = LDP_DEV(IA,L)
                      ENDIF
                    ENDDO
                  ENDDO
                ENDIF
                GO TO 100  
              ENDIF
            ENDDO

          ELSE IF(FUNCT(1:3).EQ.'add') THEN
C           only add new plan
            IF(L1P_NPLAN+1.GT.MAX1PLN) THEN
         WRITE(LINE,'(3A,I6)')' ERR: number of planar groups for mod '
     *        ,MOD,' >',MAX1PLN
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC,
     *   '           Change parameter MAX1PLN in "lib_com.fh"')
              IERR=1
              RETURN
            ENDIF

            IF(LDP_NATOM(L).GT.MAX1APL-4) THEN
             WRITE(LINE,'(3A,I6)')' ERR: number of plan atoms in mod '
     *        ,MOD,' >',MAX1APL
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC,
     *   '           Change parameter MAX1APL in "lib_com.fh"')
              IERR=1
              RETURN
            ENDIF
            IF(LDP_NATOM(L).LE.3) THEN
              WRITE(LINE,'(3A)')
     *        ' WARNING: number of plan atoms in mod '
     *        ,MOD,'  < 4'
              CALL MSGERR(MDOC,LINE)
              RETURN
            ENDIF

            L1P_NPLAN = L1P_NPLAN+1
            L1P_NATOM (L1P_NPLAN) = LDP_NATOM(L)
            L1P_LABEL (L1P_NPLAN) = LDP_LABEL(L)
            DO   I=1,L1P_NATOM(L1P_NPLAN)
              L1P_FLAG  (I,L1P_NPLAN) = 0
              L1P_DOBS  (I,L1P_NPLAN) = 0.0
              L1P_EDEV  (I,L1P_NPLAN) = 0.0
              L1P_IATOM (I,L1P_NPLAN) = 0
              L1P_DEV   (I,L1P_NPLAN) = LDP_DEV (I,L)
              L1P_ATOM  (I,L1P_NPLAN) = LDP_ATOM(I,L)
            ENDDO  
            IDEL = 1
C
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO  
      RETURN
      END

      SUBROUTINE SET_NUM_L1_GM(MDOC,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM*4
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C -----------------------------------
      IF(L1B_NBOND.GT.0) THEN 
        DO I=1,L1B_NBOND
          L1B_I1ATM(I) = 0 
          L1B_I2ATM(I) = 0 
        ENDDO
      ENDIF
      IF(L1N_NCONN.GT.0) THEN
        DO I=1,L1N_NCONN
          L1N_I1ATM(I) = 0
          L1N_I2ATM(I) = 0
        ENDDO
      ENDIF
      IF(L1G_NANGL.GT.0) THEN
        DO I=1,L1G_NANGL
          L1G_I1ATM(I) = 0
          L1G_I2ATM(I) = 0
          L1G_I3ATM(I) = 0
        ENDDO
      ENDIF
      IF(L1T_NTORS.GT.0) THEN 
        DO I=1,L1T_NTORS 
          L1T_I1ATM(I) = 0 
          L1T_I2ATM(I) = 0 
          L1T_I3ATM(I) = 0 
          L1T_I4ATM(I) = 0
        ENDDO
      ENDIF
      IF(L1C_NCHIR.GT.0) THEN 
        DO I=1,L1C_NCHIR 
          L1C_I1ATM(I) = 0
          L1C_I2ATM(I) = 0 
          L1C_I3ATM(I) = 0 
          L1C_I4ATM(I) = 0
          L1C_I5ATM(I) = 0
          L1C_I6ATM(I) = 0 
          L1C_I7ATM(I) = 0 
          L1C_I8ATM(I) = 0
          L1C_I9ATM(I) = 0
        ENDDO
      ENDIF
      IF(L1P_NPLAN.GT.0) THEN
        DO I=1,L1P_NPLAN 
          IF(L1P_NATOM(I).GT.0) THEN
            DO J=1,L1P_NATOM(I)
              L1P_IATOM(J,I) = 0
            ENDDO
          ENDIF
        ENDDO
      ENDIF
C --
      DO IA=1,L1A_NATOM
        ATOM = L1A_ANAME(IA)
C --    
        DO JA=1,L1A_NATOM
          IF(L1A_BACK(JA).EQ.ATOM) L1A_IBACK(JA) = IA
          IF(L1A_FORW(JA).EQ.ATOM) L1A_IFORW(JA) = IA
        ENDDO
        IF(L1N_NCONN.GT.0) THEN
          DO I=1,L1N_NCONN
            IF(L1N_1ATM(I).EQ.ATOM) L1N_I1ATM(I) = IA
            IF(L1N_2ATM(I).EQ.ATOM) L1N_I2ATM(I) = IA
          ENDDO
        ENDIF
        IF(L1B_NBOND.GT.0) THEN 
          DO I=1,L1B_NBOND
            IF(L1B_1ATM(I).EQ.ATOM) L1B_I1ATM(I) = IA 
            IF(L1B_2ATM(I).EQ.ATOM) L1B_I2ATM(I) = IA 
          ENDDO
        ENDIF
        IF(L1G_NANGL.GT.0) THEN
          DO I=1,L1G_NANGL
            IF(L1G_1ATM(I).EQ.ATOM) L1G_I1ATM(I) = IA
            IF(L1G_2ATM(I).EQ.ATOM) L1G_I2ATM(I) = IA
            IF(L1G_3ATM(I).EQ.ATOM) L1G_I3ATM(I) = IA
          ENDDO
        ENDIF
        IF(L1T_NTORS.GT.0) THEN 
          DO I=1,L1T_NTORS 
            IF(L1T_1ATM(I).EQ.ATOM) L1T_I1ATM(I) = IA 
            IF(L1T_2ATM(I).EQ.ATOM) L1T_I2ATM(I) = IA 
            IF(L1T_3ATM(I).EQ.ATOM) L1T_I3ATM(I) = IA 
            IF(L1T_4ATM(I).EQ.ATOM) L1T_I4ATM(I) = IA 
         ENDDO
        ENDIF
        IF(L1C_NCHIR.GT.0) THEN 
          DO I=1,L1C_NCHIR 
            IF(L1C_1ATM(I).EQ.ATOM) L1C_I1ATM(I) = IA 
            IF(L1C_2ATM(I).EQ.ATOM) L1C_I2ATM(I) = IA 
            IF(L1C_3ATM(I).EQ.ATOM) L1C_I3ATM(I) = IA 
            IF(L1C_4ATM(I).EQ.ATOM) L1C_I4ATM(I) = IA 
            IF(L1C_5ATM(I).EQ.ATOM) L1C_I5ATM(I) = IA 
            IF(L1C_6ATM(I).EQ.ATOM) L1C_I6ATM(I) = IA 
            IF(L1C_7ATM(I).EQ.ATOM) L1C_I7ATM(I) = IA 
            IF(L1C_8ATM(I).EQ.ATOM) L1C_I8ATM(I) = IA 
            IF(L1C_9ATM(I).EQ.ATOM) L1C_I9ATM(I) = IA 
         ENDDO
        ENDIF
        IF(L1P_NPLAN.GT.0) THEN
          DO I=1,L1P_NPLAN 
            IF(L1P_NATOM(I).GT.0) THEN
              DO J=1,L1P_NATOM(I)
                ICH4 = L1P_ATOM(J,I)
                IF(CH4.EQ.ATOM) L1P_IATOM(J,I) = IA
              ENDDO
            ENDIF
          ENDDO
        ENDIF
C ---
      ENDDO
C ----
      RETURN
      END   

      SUBROUTINE SET_NUM_L2_GM(MDOC,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM*4
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C -----------------------------------
      IF(L2B_NBOND.GT.0) THEN 
        DO I=1,L2B_NBOND
          L2B_I1ATM(I) = 0 
          L2B_I2ATM(I) = 0 
        ENDDO
      ENDIF
      IF(L2N_NCONN.GT.0) THEN
        DO I=1,L2N_NCONN
          L2N_I1ATM(I) = 0
          L2N_I2ATM(I) = 0
        ENDDO
      ENDIF
      IF(L2G_NANGL.GT.0) THEN
        DO I=1,L2G_NANGL
          L2G_I1ATM(I) = 0
          L2G_I2ATM(I) = 0
          L2G_I3ATM(I) = 0
        ENDDO
      ENDIF
      IF(L2T_NTORS.GT.0) THEN 
        DO I=1,L2T_NTORS 
          L2T_I1ATM(I) = 0 
          L2T_I2ATM(I) = 0 
          L2T_I3ATM(I) = 0 
          L2T_I4ATM(I) = 0
        ENDDO
      ENDIF
      IF(L2C_NCHIR.GT.0) THEN 
        DO I=1,L2C_NCHIR 
          L2C_I1ATM(I) = 0
          L2C_I2ATM(I) = 0 
          L2C_I3ATM(I) = 0 
          L2C_I4ATM(I) = 0
          L2C_I5ATM(I) = 0
          L2C_I6ATM(I) = 0 
          L2C_I7ATM(I) = 0 
          L2C_I8ATM(I) = 0
          L2C_I9ATM(I) = 0
        ENDDO
      ENDIF
      IF(L2P_NPLAN.GT.0) THEN
        DO I=1,L2P_NPLAN 
          IF(L2P_NATOM(I).GT.0) THEN
            DO J=1,L2P_NATOM(I)
              L2P_IATOM(J,I) = 0
            ENDDO
          ENDIF
        ENDDO
      ENDIF
C --
      DO IA=1,L2A_NATOM
        ATOM = L2A_ANAME(IA)
C --    
        DO JA=1,L2A_NATOM
          IF(L2A_BACK(JA).EQ.ATOM) L2A_IBACK(JA) = IA
          IF(L2A_FORW(JA).EQ.ATOM) L2A_IFORW(JA) = IA
        ENDDO
        IF(L2N_NCONN.GT.0) THEN
          DO I=1,L2N_NCONN
            IF(L2N_1ATM(I).EQ.ATOM) L2N_I1ATM(I) = IA
            IF(L2N_2ATM(I).EQ.ATOM) L2N_I2ATM(I) = IA
          ENDDO
        ENDIF
        IF(L2B_NBOND.GT.0) THEN 
          DO I=1,L2B_NBOND
            IF(L2B_1ATM(I).EQ.ATOM) L2B_I1ATM(I) = IA 
            IF(L2B_2ATM(I).EQ.ATOM) L2B_I2ATM(I) = IA 
          ENDDO
        ENDIF
        IF(L2G_NANGL.GT.0) THEN
          DO I=1,L2G_NANGL
            IF(L2G_1ATM(I).EQ.ATOM) L2G_I1ATM(I) = IA
            IF(L2G_2ATM(I).EQ.ATOM) L2G_I2ATM(I) = IA
            IF(L2G_3ATM(I).EQ.ATOM) L2G_I3ATM(I) = IA
          ENDDO
        ENDIF
        IF(L2T_NTORS.GT.0) THEN 
          DO I=1,L2T_NTORS 
            IF(L2T_1ATM(I).EQ.ATOM) L2T_I1ATM(I) = IA 
            IF(L2T_2ATM(I).EQ.ATOM) L2T_I2ATM(I) = IA 
            IF(L2T_3ATM(I).EQ.ATOM) L2T_I3ATM(I) = IA 
            IF(L2T_4ATM(I).EQ.ATOM) L2T_I4ATM(I) = IA 
         ENDDO
        ENDIF
        IF(L2C_NCHIR.GT.0) THEN 
          DO I=1,L2C_NCHIR 
            IF(L2C_1ATM(I).EQ.ATOM) L2C_I1ATM(I) = IA 
            IF(L2C_2ATM(I).EQ.ATOM) L2C_I2ATM(I) = IA 
            IF(L2C_3ATM(I).EQ.ATOM) L2C_I3ATM(I) = IA 
            IF(L2C_4ATM(I).EQ.ATOM) L2C_I4ATM(I) = IA 
            IF(L2C_5ATM(I).EQ.ATOM) L2C_I5ATM(I) = IA 
            IF(L2C_6ATM(I).EQ.ATOM) L2C_I6ATM(I) = IA 
            IF(L2C_7ATM(I).EQ.ATOM) L2C_I7ATM(I) = IA 
            IF(L2C_8ATM(I).EQ.ATOM) L2C_I8ATM(I) = IA 
            IF(L2C_9ATM(I).EQ.ATOM) L2C_I9ATM(I) = IA 
         ENDDO
        ENDIF
        IF(L2P_NPLAN.GT.0) THEN
          DO I=1,L2P_NPLAN 
            IF(L2P_NATOM(I).GT.0) THEN
              DO J=1,L2P_NATOM(I)
                ICH4 = L2P_ATOM(J,I)
                IF(CH4.EQ.ATOM) L2P_IATOM(J,I) = IA
              ENDDO
            ENDIF
          ENDDO
        ENDIF
C ---
      ENDDO
C ----
      RETURN
      END

      SUBROUTINE COMPRESS_L1_GM(MDOC,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM*4
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C -----------------------------------
      NA = 0
      DO IATM=1,L1A_NATOM
        IF(L1A_ANAME(IATM).NE.'????'.AND.
     *     L1A_ICR(IATM).NE.0) THEN
         NA = NA + 1
          L1A_CHARG (NA) = L1A_CHARG (IATM)
          L1A_X     (NA) = L1A_X     (IATM)
          L1A_Y     (NA) = L1A_Y     (IATM)
          L1A_Z     (NA) = L1A_Z     (IATM)
          L1A_LENGTH(NA) = L1A_LENGTH(IATM)
          L1A_THETA (NA) = L1A_THETA (IATM)
          L1A_PHI   (NA) = L1A_PHI   (IATM)
          L1A_NRING (NA) = L1A_NRING (IATM)
          L1A_INEW  (NA) = L1A_INEW  (IATM)
          L1A_IOLD  (NA) = L1A_IOLD  (IATM)
          L1A_ICR   (NA) = L1A_ICR   (IATM)
          L1A_IBACK (NA) = L1A_IBACK (IATM)
          L1A_IFORW (NA) = L1A_IFORW (IATM)
          L1A_NDIST (NA) = L1A_NDIST (IATM)
          L1A_NEXTR (NA) = L1A_NEXTR (IATM)
          L1A_ICHEM (NA) = L1A_ICHEM (IATM)
          L1A_SF_ID (NA) = L1A_SF_ID (IATM)
          L1A_ID_PSI(NA) = L1A_ID_PSI(IATM)
          L1A_SYMB  (NA) = L1A_SYMB  (IATM)
          L1A_ATYPE (NA) = L1A_ATYPE (IATM)
          L1A_ANAME (NA) = L1A_ANAME (IATM)
          L1A_TYPE  (NA) = L1A_TYPE  (IATM)
          L1A_BACK  (NA) = L1A_BACK  (IATM)
          L1A_FORW  (NA) = L1A_FORW  (IATM)
          L1A_CHEM  (NA) = L1A_CHEM  (IATM)
          L1A_COOR_FLAG(NA) = L1A_COOR_FLAG(IATM)  
        ENDIF
      ENDDO
      L1A_NATOM = NA
C --    
      NC = 0
      IF(L1N_NCONN.GT.0) THEN
        DO I=1,L1N_NCONN
          IF(L1N_1ATM(I).NE.'????'.AND.L1N_2ATM(I).NE.'????'.AND.
     *       L1N_I1ATM(I).NE.0.AND.L1N_I2ATM(I).NE.0) THEN
            NC = NC + 1
            L1N_I1ATM (NC) = L1N_I1ATM (I)
            L1N_I2ATM (NC) = L1N_I2ATM (I)
            L1N_1ATM  (NC) = L1N_1ATM  (I)
            L1N_2ATM  (NC) = L1N_2ATM  (I)
            L1N_TYPE  (NC) = L1N_TYPE  (I)
          ENDIF
        ENDDO
      ENDIF
      L1N_NCONN = NC
C --
      NB = 0
      IF(L1B_NBOND.GT.0) THEN 
        DO I=1,L1B_NBOND
          IF(L1B_1ATM(I).NE.'????'.AND.L1B_2ATM(I).NE.'????'.AND.
     *       L1B_I1ATM(I).NE.0.AND.L1B_I2ATM(I).NE.0) THEN
            NB = NB + 1
            L1B_I1ATM (NB) = L1B_I1ATM (I)
            L1B_I2ATM (NB) = L1B_I2ATM (I)
            L1B_1ATM  (NB) = L1B_1ATM  (I)
            L1B_2ATM  (NB) = L1B_2ATM  (I)
            L1B_TYPE  (NB) = L1B_TYPE  (I)
            L1B_FLAG  (NB) = L1B_FLAG  (I) 
            L1B_VAL   (NB) = L1B_VAL   (I)
            L1B_DEV   (NB) = L1B_DEV   (I)
            L1B_VOBS  (NB) = L1B_VOBS  (I) 
            L1B_EVAL  (NB) = L1B_EVAL  (I)
          ENDIF
        ENDDO
      ENDIF
      L1B_NBOND = NB
C ---
      NG = 0
      IF(L1G_NANGL.GT.0) THEN
        DO I=1,L1G_NANGL
          IF(L1G_1ATM(I).NE.'????'.AND.L1G_2ATM(I).NE.'????'.AND.
     *                                 L1G_3ATM(I).NE.'????'.AND.
     *       L1G_I1ATM(I).NE.0.AND.L1G_I2ATM(I).NE.0.AND.
     *                                 L1G_I3ATM(I).NE.0     ) THEN
            NG = NG + 1
            L1G_I1ATM (NG) = L1G_I1ATM (I)
            L1G_I2ATM (NG) = L1G_I2ATM (I)
            L1G_I3ATM (NG) = L1G_I3ATM (I)
            L1G_1ATM  (NG) = L1G_1ATM  (I)
            L1G_2ATM  (NG) = L1G_2ATM  (I)
            L1G_3ATM  (NG) = L1G_3ATM  (I)
            L1G_VAL   (NG) = L1G_VAL   (I)
            L1G_VOBS  (NG) = L1G_VOBS  (I)
            L1G_DEV   (NG) = L1G_DEV   (I)
            L1G_EVAL  (NG) = L1G_EVAL  (I) 
          ENDIF
        ENDDO
      ENDIF
      L1G_NANGL = NG
C ---
      NT = 0
      IF(L1T_NTORS.GT.0) THEN 
        DO I=1,L1T_NTORS 
          IF(L1T_1ATM(I).NE.'????'.AND.L1T_2ATM(I).NE.'????'.AND.
     *       L1T_3ATM(I).NE.'????'.AND.L1T_4ATM(I).NE.'????'.AND.
     *       L1T_I1ATM(I).NE.0.AND.L1T_I2ATM(I).NE.0.AND.
     *       L1T_I3ATM(I).NE.0.AND.L1T_I4ATM(I).NE.0     ) THEN
            NT = NT + 1
            L1T_1ATM  (NT) = L1T_1ATM  (I) 
            L1T_2ATM  (NT) = L1T_2ATM  (I)
            L1T_3ATM  (NT) = L1T_3ATM  (I)
            L1T_4ATM  (NT) = L1T_4ATM  (I)
            L1T_LABEL (NT) = L1T_LABEL (I)
            L1T_FLAG  (NT) = L1T_FLAG  (I)
            L1T_VAL   (NT) = L1T_VAL   (I)
            L1T_DEV   (NT) = L1T_DEV   (I) 
            L1T_VOBS  (NT) = L1T_VOBS  (I)
            L1T_EVAL  (NT) = L1T_EVAL  (I)
            L1T_PRD   (NT) = L1T_PRD   (I)
            L1T_I1ATM (NT) = L1T_I2ATM (I)
            L1T_I2ATM (NT) = L1T_I2ATM (I)
            L1T_I3ATM (NT) = L1T_I3ATM (I)
            L1T_I4ATM (NT) = L1T_I4ATM (I)
          ENDIF
        ENDDO
      ENDIF
      L1T_NTORS = NT
C ---
      NC = 0
      IF(L1C_NCHIR.GT.0) THEN 
        DO I=1,L1C_NCHIR 
          IF(L1C_1ATM(I).NE.'????'.AND.L1C_2ATM(I).NE.'????'.AND.
     *       L1C_3ATM(I).NE.'????'.AND.L1C_4ATM(I).NE.'????'.AND.
     *       L1C_I1ATM(I).NE.0) THEN 
            IF((L1C_SIGN(I)(1:4).EQ.'cros').or.(L1C_I2ATM(I).NE.0
     *         .AND.L1C_I3ATM(I).NE.0.AND.L1C_I4ATM(I).NE.0)) THEN
              NC = NC + 1
              L1C_I1ATM (NC) = L1C_I1ATM (I) 
              L1C_I2ATM (NC) = L1C_I2ATM (I)
              L1C_I3ATM (NC) = L1C_I3ATM (I) 
              L1C_I4ATM (NC) = L1C_I4ATM (I)
              L1C_I5ATM (NC) = L1C_I5ATM (I) 
              L1C_I6ATM (NC) = L1C_I6ATM (I)
              L1C_I7ATM (NC) = L1C_I7ATM (I) 
              L1C_I8ATM (NC) = L1C_I8ATM (I)
              L1C_I9ATM (NC) = L1C_I9ATM (I)
              L1C_1ATM  (NC) = L1C_1ATM  (I)  
              L1C_2ATM  (NC) = L1C_2ATM  (I)
              L1C_3ATM  (NC) = L1C_3ATM  (I)
              L1C_4ATM  (NC) = L1C_4ATM  (I)
              L1C_5ATM  (NC) = L1C_5ATM  (I)  
              L1C_6ATM  (NC) = L1C_6ATM  (I)
              L1C_7ATM  (NC) = L1C_7ATM  (I)
              L1C_8ATM  (NC) = L1C_8ATM  (I)
              L1C_9ATM  (NC) = L1C_9ATM  (I)
              L1C_SIGN  (NC) = L1C_SIGN  (I)
              L1C_FLAG  (NC) = L1C_FLAG  (I)
              L1C_VOL   (NC) = L1C_VOL   (I)
              L1C_VOBS  (NC) = L1C_VOBS  (I)
              L1C_EVOL  (NC) = L1C_EVOL  (I)
            ENDIF
          ENDIF
        ENDDO
      ENDIF
      L1C_NCHIR = NC
C ---
      NP = 1
      IF(L1P_NPLAN.GT.0) THEN
        DO I=1,L1P_NPLAN 
          NPA = 0
          IF(L1P_NATOM(I).GT.0) THEN
            DO J=1,L1P_NATOM(I)
              IF(L1P_IATOM(J,I).GT.0) THEN
                NPA = NPA + 1
                L1P_IATOM (NPA,NP) = L1P_IATOM (J,I)
                L1P_ATOM  (NPA,NP) = L1P_ATOM  (J,I)
                L1P_FLAG  (NPA,NP) = L1P_FLAG  (J,I)
                L1P_DEV   (NPA,NP) = L1P_DEV   (J,I)
                L1P_DOBS  (NPA,NP) = L1P_DOBS  (J,I)
                L1P_EDEV  (NPA,NP) = L1P_EDEV  (J,I) 
              ENDIF
            ENDDO
            IF(NPA.GE.4) THEN 
              L1P_LABEL (NP) = L1P_LABEL (I)
              L1P_NATOM (NP) = NPA
              NP = NP + 1
            ENDIF
          ENDIF
        ENDDO
      ENDIF
      L1P_NPLAN = NP - 1 
C ----
      RETURN
      END   
