C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
      SUBROUTINE GETLIB(MMDOC,LIST,NODIST,NUMB_LIB
     *            ,LIBM_PATH,LIBE_PATH,LIBS_PATH
     *            ,LIBM_NAME,LIBE_NAME,LIBS_NAME
     *            ,LIBM_EXT ,LIBE_EXT ,LIBS_EXT
     *            ,LIB2_NAME,LIB_IND  ,FILE_LIB_OUT ,IERR)
C -------------------------------------------------------
C ---
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------
      INTEGER MMDOC
      CHARACTER LIBM_PATH*(*)    ,LIBE_PATH*(*),LIBS_PATH*(*)
      CHARACTER LIBM_NAME(20)*256,LIBE_NAME*(*),LIBS_NAME*(*)
      CHARACTER LIBM_EXT*(*)     ,LIBE_EXT*(*) ,LIBS_EXT*(*)
      CHARACTER LIB2_NAME*(*)    ,LIB_IND*(*)  ,FILE_LIB_OUT*(*)
      INTEGER*4 MDOC,MMM,IS,IERR,NUMB_LIB
      CHARACTER MOD*1,CHAR1*1,LIST*1,NODIST*1
C ----------------------------------------------
      IERR = 0
      MDOC = MMDOC
      MMM  = MDOC
      IF(LIST.EQ.'S') THEN
        MDOC = 999
        MMM  = MDOC
      ELSE IF(LIST.EQ.'M') THEN
        MMM = 999
      ENDIF
C ---
C
      CALL INITLIB(MMM,NODIST,NUMB_LIB
     *            ,LIBM_PATH,LIBE_PATH,LIBS_PATH
     *            ,LIBM_NAME,LIBE_NAME,LIBS_NAME
     *            ,LIBM_EXT ,LIBE_EXT ,LIBS_EXT
     *            ,LIB2_NAME,LIB_IND  ,FILE_LIB_OUT ,IERR)
      IF(IERR.NE.0) RETURN
C ---
C     read list of all monomers in the library. 

      LB_TFLAG = 'N'
      CALL GET_LLIST(MDOC,IERR)    
      IF(IERR.NE.0) RETURN
      CALL GET_INDEX(MDOC,IERR)
      IF(IERR.NE.0) RETURN
      MOD   = 'N'
      CHAR1 = 'N'
      CALL SSET_FUSE(MOD,CHAR1)
C  ---
C     read ener_lib.cif
      CALL MSGDOC(MDOC,' I am reading libraries. Please wait.')
      CALL MSGDOC(MDOC,'     - energy parameters')
      MOD = 'E'
      CALL READ_LIB(MDOC,MOD,NODIST,LIST,IERR)
      IF(IERR.NE.0) RETURN
C     read mon_lib.cif (links & mod )
      CALL MSGDOC(MDOC,'     - monomer"s description (links & mod )')
      MOD = 'N'
      CALL READ_LIB(MDOC,MOD,NODIST,LIST,IERR)
      IF(IERR.NE.0) RETURN
C ---
C     initialization COM_CONN_INF
      CALL INIT_CONN_INF(MDOC,IERR)     
C ---
      RETURN
      END

      SUBROUTINE INITLIB(MDOC,NODIST,NUMB_LIB
     *            ,LIBM_PATH,LIBE_PATH,LIBS_PATH
     *            ,LIBM_NAME,LIBE_NAME,LIBS_NAME
     *            ,LIBM_EXT ,LIBE_EXT ,LIBS_EXT
     *            ,LIB2_NAME,LIB_IND  ,FILE_LIB_OUT ,IERR)
C -------------------------------------------------------
C -P- INITLIB - initialization of common blocks of library.
C -S-
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,NUMB_LIB
      CHARACTER LIBM_PATH*(*)    ,LIBE_PATH*(*),LIBS_PATH*(*)
      CHARACTER LIBM_NAME(20)*256,LIBE_NAME*(*),LIBS_NAME*(*)
      CHARACTER LIBM_EXT *(*)    ,LIBE_EXT *(*),LIBS_EXT *(*)
      CHARACTER LIB2_NAME*(*)    ,LIB_IND  *(*),FILE_LIB_OUT*(*)
      CHARACTER NODIST*1
C ******
      CHARACTER LINE*256
      INTEGER*4 IL,I,LEN
C -----------------------------------
      IERR=0
C -----------------------------------
      IS = LMB_TOTAL * 4
      WRITE(LINE,'('' Size of lib_com.fh(bytes) :'',I10)') IS
      CALL MSGDOC(MDOC,LINE)
C -----------------------------------
      DO I=1,20
       LIBM_NAME(I) = ' '
      ENDDO

      IF(NODIST.NE.'Y') THEN
        NUMB_LIB     = 1
C ---
        LIBM_NAME( 1) = 'list/mon_lib_list'
c        LIBM_NAME( 2) = 'mon_lib_prot'
c        LIBM_NAME( 3) = 'mon_lib_na'
c        LIBM_NAME( 4) = 'mon_lib_sug'
c        LIBM_NAME( 5) = 'mon_lib_met'
c        LIBM_NAME( 6) = 'mon_lib_1'
c        LIBM_NAME( 7) = 'mon_lib_2'
c        LIBM_NAME( 8) = 'mon_lib_3'
c        LIBM_NAME( 9) = 'mon_lib_4'
c        LIBM_NAME(10) = 'mon_lib_5'
c        LIBM_NAME(11) = 'mon_lib_6'
c        LIBM_NAME(12) = 'mon_lib_7'
c        LIBM_NAME(13) = 'mon_lib_8'
c        LIBM_NAME(14) = 'mon_lib_9'
c        LIBM_NAME(15) = 'mon_lib_10'
c        LIBM_NAME(16) = 'mon_lib_11'
c        LIBM_NAME(17) = 'mon_lib_12'
c        LIBM_NAME(18) = 'mon_lib_13'
c        LIBM_NAME(19) = ' '
c        LIBM_NAME(20) = ' '
C ---
        LIBM_EXT     = 'cif'
        LIB_IND      = 'mon_lib_ind'
      ELSE
        NUMB_LIB          = 1
        LIBM_NAME(1)      = ' '
        CALL LENSTR_BL(LIB2_NAME,LEN)
        IF(LEN.GT.0.AND.LIB2_NAME(1:1).NE.','.AND.
     *                  LIB2_NAME(1:1).NE.' ') THEN
          NUMB_LIB     = 1
          LIBM_NAME(1) = LIB2_NAME
          LIBM_PATH    = ' '
          LIBM_EXT     = ' '
        ENDIF
        LIB2_NAME    = ' '
        LIB_IND      = ' '
      ENDIF
C --
      LIBE_NAME    = 'ener_lib'
      LIBE_EXT     = 'cif'
C ---
      LMI_FILE(1) = ' '
      LMI_PATH    = ' '
      LMI_EXT     = ' '
      IL          = 0

      DO I=1,NUMB_LIB
        LINE = LIBM_NAME(I)
        CALL LENSTR_BL(LINE,LEN)
        IF(LEN.GT.0.AND.LINE(1:1).NE.','.AND.
     *                LINE(1:1).NE.' ') THEN
          IL = IL +1
          IF(IL.GT.MAXLIB) THEN
            WRITE(LINE,'(A,I5,A)')
     * ' ERROR: number of dictionaries >',MAXLIB,' /lib. limit/ '
            CALL MSGERR(MDOC,LINE)
            IERR=1
            RETURN
          ENDIF
          LB_NUMB_LIB  = IL
          LMI_FILE(IL) = LINE
          LMI_PATH     = LIBM_PATH
          LMI_EXT      = LIBM_EXT
        ENDIF
      ENDDO

      IF(NUMB_LIB.EQ.1) THEN
        LMI_FILE(2) = NODIST
      ENDIF

      LEI_FILE = ' '
      LEI_PATH = ' '
      LEI_EXT  = ' '
      CALL LENSTR_BL(LIBE_NAME,LEN)
      IF(LEN.GT.0.AND.LIBE_NAME(1:1).NE.','.AND.
     *                LIBE_NAME(1:1).NE.' ') THEN
        LEI_FILE = LIBE_NAME
        LEI_PATH = LIBE_PATH
        LEI_EXT  = LIBE_EXT
      ENDIF

      LMI2_FILE = ' '
      LMI2_PATH = ' '
      LMI2_EXT  = ' '
      CALL LENSTR_BL(LIB2_NAME,LEN)
      IF(LEN.GT.0.AND.LIB2_NAME(1:1).NE.','.AND.
     *                LIB2_NAME(1:1).NE.' ') THEN
        LMI2_FILE=LIB2_NAME
      ENDIF
      LIN_FILE = ' '
      LIN_PATH = ' '
      LIN_EXT  = ' '
      CALL LENSTR_BL(LIB_IND,LEN)
      IF(LEN.GT.0.AND.LIB_IND(1:1).NE.','.AND.
     *                LIB_IND(1:1).NE.' ') THEN
        LIN_FILE = LIB_IND
        LIN_PATH = LIBM_PATH
        LIN_EXT  = LIBM_EXT
      ENDIF

      CALL LENSTR_BL(FILE_LIB_OUT,LEN)
      IF(LEN.GT.0.AND.FILE_LIB_OUT(1:1).NE.','.AND.
     *                FILE_LIB_OUT(1:1).NE.' ') THEN
        LMO_FILE = FILE_LIB_OUT
        LMO_PATH = ' '
        LMO_EXT  = ' '
      ELSE
        LMO_FILE = 'new.lib' 
        FILE_LIB_OUT = LMO_FILE
        LMO_PATH = ' '
        LMO_EXT  = ' '
      ENDIF
      LEO_FILE = 'new_ener_lib'
      LEO_PATH = ' '
      LEO_EXT  = 'cif'
      LMI_IUN  = 0
      LMI2_IUN = 0
      LMO_IUN  = 0
      LEI_IUN  = 0
      LEO_IUN  = 0
      LSI_IUN  = 0
      LSI_PATH = ' '
      LSI_FILE = ' '
      LSI_EXT  = ' '
      CALL LENSTR_BL(LIBS_NAME,LEN)
      IF(LEN.GT.0.AND.LIBS_NAME(1:1).NE.','.AND.
     *                LIBS_NAME(1:1).NE.' ') THEN
        LSI_PATH = LIBS_PATH
        LSI_FILE = LIBS_NAME
        LSI_EXT  = LIBS_EXT
      ENDIF
      IERR=0
C -----------------------------------
C     initialization counters of library
      LB_NAME     = '?'
      LB_VERS     = '?'
      LB_DATE     = '?'
      LB2_NAME    = '?'
      LB2_VERS    = '?'
      LB2_DATE    = '?'
      LB_PASS     = 0
      LML_NMON    = 0
      LML_NPRSNT  = 0
      LML_IMON    = 0
      LMX_NMON    = 0
      LMS_NSYN    = 0
      LMS_NEW     = 0
      LMS_ISYN    = 0
      LDR_NDER    = 0
      LDR_IDER    = 0
      LMR_NREC    = 0
      LB_HFLAG    = 'N'
      LB_TFLAG    = 'N'
      LSO_NSYM    = 1
      LSO_SYMOP(1)= 'X,Y,Z'
      LSF_NASYMB  = 0
      DO   I=1,MAXMLIST
        LML_ISYN (I) = 0
        LML_IDER (I) = 0
        LML_IMMON(I) = 0
        LML_ILMON(I) = 0
      ENDDO
      DO   I=1,MAXMLIST
        LML_PASS (I) = 0
        LML_NATM (I) = 0
        LML_NHATM(I) = 0
        LML_MNAME(I) = '?'
        LML_MNAME2(I)= '?'
        LML_NAME (I) = '?'
        LML_FORM (I) = '?'
        LML_CODE1(I) = '?'
        LML_TYPE (I) = '?'
        LML_MODE (I) = '?'
        LML_FUSE (I) = 'N'
        LML_PRSNT(I) = 'N'
      ENDDO
      LLL_NLINK = 0
      LLL_ILINK = 0
      DO   I=1,MAXLLNK
        LLL_LNAME  (I) = '?'
        LLL_DETAIL (I) = '?'
        LLL_CODE1  (I) = '?'
        LLL_MOD1   (I) = '?'
        LLL_MON1   (I) = '?'
        LLL_FLAG1  (I) = 0
        LLL_TYPE1  (I) = '?'
        LLL_MOD2   (I) = '?'
        LLL_MON2   (I) = '?'
        LLL_FLAG2  (I) = 0
        LLL_TYPE2  (I) = '?'
        LLL_FUSE   (I) = 'N'
      ENDDO
      LDL_NMOD  = 0
      LDL_IMOD  = 0
      DO   I=1,MAXDMDF
        LDL_MNAME  (I) = '?'
        LDL_DETAIL (I) = '?'
        LDL_COMP   (I) = '?'
        LDL_TYPE   (I) = '?'
        LDL_ORDER  (I) = 0
        LDL_FUSE   (I) = 'N'
      ENDDO
      CALL INIT_CNT
C ----------------------------------
      RETURN
      END     
 
      SUBROUTINE INIT_CONN_INF(MDOC,IERR)     
C -----------------------------------------------
C      DATA N_STOR /8/
C
C      DATA ATOM_STOR /
C     * 'N   ','C   ','C1  ','O3* ','O3  ','O4  ','O6  ','P   ','    '
C     *,'    '/
C        1      2      3      4      5      6      7      8      9
C -----------------------------------
C      1    2    3   4    5      6       7       8       9     10
C      -  TRANS CIS  P FOR_C-N FOR_C-C ACE_C-N DFO_C-N NME_N-C  gap
C      DATA ICONN_ATOM_IND/
C     *0,0, 2,1, 2,1,4,8, 2,1,  2,2,    2,1,    2,1,   2,1,     0,0,
C     *0,0, 5,3, 6,3,7,3, 0,0,  0,0,    0,0,    0,0,   0,0,     0,0/ 
C          B1-3 B1-4 B1-6
C      1    2    3   4    5      6       7       8       9     20
C ------------------------------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER ATOM1*4,ATOM2*4
C     CHARACTER LINE*256
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------------------------
      IERR   = 0
      N_STOR = 0

      ATOM_STOR( 1) = 'CA  '
      ATOM_STOR( 2) = 'C   '
      ATOM_STOR( 3) = 'N   '
      ATOM_STOR( 4) = 'OXT '
      ATOM_STOR( 5) = 'O1P '
      ATOM_STOR( 6) = 'O2P '
      ATOM_STOR( 7) = 'P   '
      ATOM_STOR( 8) = 'O3* '
      ATOM_STOR( 9) = 'O5* '
      ATOM_STOR(10) = 'O2* '
      ATOM_STOR(11) = 'OT  '
      ATOM_STOR(12) = 'O5T '
      ATOM_STOR(13) = 'O3T '

      N_STOR = 13

      IF(LLL_NLINK.GT.0) THEN

        DO L=1,LLL_NLINK

          ICONN_ATOM_IND(1,L) = 0
          ICONN_ATOM_IND(2,L) = 0

          IF(LLB_NBOND.GT.0.AND.LLL_IBOND(L).GT.0) THEN
            DO IB = LLL_IBOND(L),LLB_NBOND
              IF(LLL_LNAME(L).EQ.LLB_LNAME(IB)) THEN

                ATOM1 = LLB_1ATM(IB)
                ATOM2 = LLB_2ATM(IB)
          
                IF(ATOM1.NE.'.'.AND.ATOM2.NE.'.'.AND.
     *             ATOM1.NE.' '.AND.ATOM2.NE.' ') THEN

                  IF(N_STOR.GT.0) THEN
                    DO IA = 1,N_STOR
                      IF(ATOM1.EQ.ATOM_STOR(IA)) GO TO 100
                    ENDDO
                  ENDIF
                  IF(N_STOR.GE.NSTOR_PAR) THEN
                    RETURN
                  ENDIF
                  N_STOR        = N_STOR + 1
                  IA            = N_STOR
                  ATOM_STOR(IA) = ATOM1

  100             CONTINUE
                  IA1 = IA

                  IF(N_STOR.GT.0) THEN
                    DO IA = 1,N_STOR
                      IF(ATOM2.EQ.ATOM_STOR(IA)) GO TO 200
                    ENDDO
                  ENDIF
                  IF(N_STOR.GE.NSTOR_PAR) THEN
                    RETURN
                  ENDIF
                  N_STOR        = N_STOR + 1
                  IA            = N_STOR
                  ATOM_STOR(IA) = ATOM2

  200             CONTINUE
                  IA2 = IA

                  ICONN_ATOM_IND(1,L) = IA1
                  ICONN_ATOM_IND(2,L) = IA2
                  BOND_IDL(L)         = LLB_VAL(IB)
                ENDIF

              ENDIF
            ENDDO
        
          ENDIF

        ENDDO
      ENDIF

      RETURN
      END


C ******
      SUBROUTINE GET_INDEX(MDOC,IERR)
C -----------------------------------------------
C
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'crd_com.fh'
C ---
C -----------------------------------
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
      CHARACTER LINE*256,MON*8,CH2*2,FORM*1,FILE*256
C -----------------------------------
      IERR     = 0
      M        = 99
C --------------------
      LMX_NMON = 0

      CALL LENSTR_BL(LIN_FILE,LEN)
      IF(LEN.GT.0.AND.LIN_FILE(1:1).NE.' '.AND.
     *  LIN_FILE(1:1).NE.',') THEN
        IUN   = CRO_IUN
        CALL OPENFR(IUN,M,LIN_PATH,LIN_FILE,LIN_EXT,IERR)
        CRO_IUN = IUN
        IF(IERR.NE.0) THEN
          CALL LENSTR_BL(LIN_FILE,L)
          LINE = ' ERROR: can"t open (index) '//LIN_FILE(1:L)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ELSE
        RETURN
      ENDIF

      LMX_NMON = 0

 100  CONTINUE

      READ(IUN,'(A)',ERR=200,END=200) LINE

      READ(LINE,'(I4,1X,A2,1X,A8,1X,I4,1X,A30,1X,A24)')
     *    L,CH2,MON,N,C_CONTENT,C_INDEX

C       write(*,
C    * '(I4,'' '',A2,'' '',I4,'';'',A3,'';'',A30,'';'',A24,'';'')')
C    *  L,CH2,N,MON,C_CONTENT,C_INDEX

      READ(IUN,'(A)',ERR=200,END=200) LINE

      READ(LINE,'(17X,A24)') C_PAIR

      LMX_NMON              = LMX_NMON + 1
      LMX_NATOM  (LMX_NMON) = N 
      LMX_MNAME  (LMX_NMON) = MON
      LMX_INDEX  (LMX_NMON) = C_INDEX
      LMX_CONTENT(LMX_NMON) = C_CONTENT
      LMX_PAIR   (LMX_NMON) = C_PAIR
      GO TO 100
C ---
 200  CONTINUE
      CLOSE(IUN,ERR=300)
 300  CONTINUE
C  ----------------------
      CALL LENSTR_BL(LIN_FILE,LEN)
      IF(LEN.GT.0.AND.LIN_FILE(1:1).NE.' '.AND.
     *  LIN_FILE(1:1).NE.',') THEN
        IUN   = CRO_IUN
        FILE  = LIN_FILE(1:LEN)//'2'
        CALL OPENFR(IUN,M,LIN_PATH,FILE,LIN_EXT,IERR)
        CRO_IUN = IUN
        IF(IERR.NE.0) THEN
          CALL LENSTR_BL(FILE,L)
          LINE = ' ERROR: can"t open (index2) '//FILE(1:L)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ELSE
        RETURN
      ENDIF

      FORM = 'F'

      CALL LIB_READ_INDEX2(MDOC,IUN,FORM,IERR)
      CLOSE(IUN)

C  ----------------------
      RETURN
      END

      SUBROUTINE LIB_READ_INDEX2(MDOC,IUN,FORM,IERR)
C -------------------------------------------
      INTEGER MAXMPONTER
      PARAMETER (MAXMPONTER = 3500)
      INTEGER MAXMPOOL
      PARAMETER (MAXMPOOL = 600 000)
      INTEGER   MATCH_POINTER(MAXMPONTER)
      INTEGER*2 MATCH_POOL   (MAXMPOOL)
      COMMON /COM_MATCH_POOL/ MEM_TOT,MATCH_NMON
     *                       ,MATCH_POINTER,MATCH_POOL
C ------------------------------------------
C     IP = MATCH_POINTER(I) 
C       MATCH_POOL(IP  ) = IMON 
C       MATCH_POOL(IP+1) = NATOM  
C       MATCH_POOL(IP+2) = NBOND
C
C       IPC = IP+2
C       MATCH_POOL(IPC+1)  = ICONTENT(1) 
C       . . . . . 
C       MATCH_POOL(IPC+15) = ICONTENT(15) 
C 'C ','N ','O ','S ','P ','CO','MG','CA','ZN','CU','FE','CL','MN','MO','  '
C  1    2    3    4    5    6    7    8    9    10   11   12   13   14   15
C  
C       IPA = IP + 17
C       MATCH_POOL(IPA+1) = IATOM
C       MATCH_POOL(IPA+2) = IATYPE
C
C       IPB = IP + 17 + 2*NATOM
C       MATCH_POOL(IPA+1) = IATOM1
C       MATCH_POOL(IPA+1) = IATOM2
C       MATCH_POOL(IPA+1) = IBTYPE
C
C       0-dumm,1-sing,2-doub,3-trip,4-arom,5-delo,6-meta,7-cova
C
C ---------------------------------------------------------------
      INTEGER  MDOC,IERR,IUN
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER MON*8,FORM*1,LINE*256
C ---------------------------------------------------------------------
      IF(FORM.EQ.'U') THEN
        READ(IUN) MATCH_NMON,MEM_TOT
      ELSE
        READ(IUN,'(I5,I12)') MATCH_NMON,MEM_TOT
      ENDIF

      IF(MEM_TOT.LE.0.OR.MATCH_NMON.LE.0) THEN
        MATCH_NMON = 0
        IERR = 1
        RETURN      
      ENDIF

      IF(MEM_TOT.GT.MAXMPOOL) THEN
        WRITE(LINE,'(A)')
     *  ' ERROR: in LIB_CREATE_INDEX2: not memory enough:'
        CALL MSGERR(MDOC,LINE)         
        MATCH_NMON = 0
        IERR = 1
        RETURN
      ENDIF    

      IF(FORM.EQ.'U') THEN
        READ(IUN) (MATCH_POINTER(IM),IM=1,MATCH_NMON)
      ELSE
        READ(IUN,'(10I8)') (MATCH_POINTER(IM),IM=1,MATCH_NMON)
      ENDIF


      IF(FORM.EQ.'U') THEN
        READ(IUN) (MATCH_POOL(IM),IM=1,MEM_TOT)
      ELSE
        READ(IUN,'(20I4)') (MATCH_POOL(IM),IM=1,MEM_TOT)
      ENDIF

C ---------------------
      RETURN
      END

C ******
      SUBROUTINE GET_LLIST(MDOC,IERR)
C -----------------------------------------------
C -P- GET_LLIST - reads  only title and list_information of monomer's from 
C -P-             the library_file. 
C                 If LB_TFLAG = 'N' read all monomers,
C                 if = 'Y' read accoding list of monomers which was prepared
C                 before.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,IEND
C ---
      INCLUDE 'lib_com.fh'
C ---
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---
      COMMON/COM_CRD_CIF/ IEND_CIF      
      INTEGER*4 IEND_CIF
C ---
C -----------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,IUN,M,IFIRST,I,NM
      INTEGER*4 LCMP,LSN,LDR,LMD,LNK,LCMPA,LMDA,LNKB
      CHARACTER DATA*80,ITEM*80,LINE*256,CH1*1,LIB*256
C -----------------------------------
      INCLUDE 'crd_com.fh'
C ----------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------

      LML_NMON   = 0
      LML_NPRSNT = 0
      LLL_NLINK  = 0
      LDL_NMOD   = 0
      LML_IMON   = 0
      LB_PASS    = 0
C ---
      CALL INIT_CNT
C ------
 100  CONTINUE
      LB_PASS = LB_PASS + 1
      IFIRST  = 0
      IERR    = 0
      IEND    = 0
C ------
C     open file of mon_library
C     IUN = 10
      IUN = CRI_IUN
      M   = 99
      IF(LB_PASS.LE.LB_NUMB_LIB) THEN
        LIB = LMI_FILE(LB_PASS)
        CALL LENSTR_BL(LIB,LEN)
        IF(LEN.LE.0) GO TO 410
        CALL OPENFR(IUN,M,LMI_PATH,LIB,LMI_EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL LENSTR_BL(LIB,LEN) 
          IF(LEN.GT.60) LEN=60
          WRITE(LINE,*) ' ERROR: can"t open (lib) ',LIB(1:LEN)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ELSE
        CALL OPENFR(IUN,M,LMI2_PATH,LMI2_FILE,LMI2_EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL LENSTR_BL(LMI2_FILE,LEN) 
          IF(LEN.GT.60) LEN=60
          WRITE(LINE,*) ' ERROR: can"t open (lib2) ',LMI2_FILE(1:LEN)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ENDIF
      LMI_IUN = IUN
      IEND    = -1
C -------
      IF(IEND.EQ.-1) THEN
        REWIND IUN
        IEND_CIF = -1
        IEND     = 0
      ENDIF

  300 CONTINUE   
      CALL GETCIF_INFO(IUN,MDOC,IERR,IEND_CIF)
      IF(IERR.NE.0.OR.(IEND_CIF.NE.0.AND.IEND_CIF.NE.-2)) THEN
C        CLOSE(IUN)
C        LMI_IUN=0
        IEND=1
        GO TO 400
C       RETURN
      ENDIF

      IF(IEND_CIF.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment
C   
        GO TO 300
      ENDIF

      IF(N_CIF.LE.0) GO TO 300
      DO I=1,N_CIF

        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IF(LENB.LE.0.OR.LENB.GT.60) THEN
          BLK_CIF = ' '
          LENB    = 1
        ENDIF 
        IDATA = IDT_CIF(I)
        FDATA = FDT_CIF(I)


        CALL LENSTR_BL(ITL_CMP  ,LCMP )
        CALL LENSTR_BL(ITL_SNM  ,LSN  )
        CALL LENSTR_BL(ITL_SNMA ,LSNA )
        CALL LENSTR_BL(ITL_DER  ,LDR  )
        CALL LENSTR_BL(ITL_MOD  ,LMD  )
        CALL LENSTR_BL(ITL_LNK  ,LNK  )
        CALL LENSTR_BL(ITL_CMPA ,LCMPA)
        CALL LENSTR_BL(ITL_MODA ,LMDA )
        CALL LENSTR_BL(ITL_LNKB ,LNKB )

        CALL LENSTR_BL(ITL_GLOBAL,L)

        IF(BLK_CIF(1:LENB).EQ.ITL_GLOBAL(1:L)) THEN
          CALL LENSTR_BL(ITL_LIB_NAME,L)
          IF(ITEM(1:LENI).EQ.ITL_LIB_NAME(1:L)) THEN
            LB_NAME=DATA(1:LEND)
            CALL MSGDOC(MDOC,' ------------------------------')
            CALL MSGDOC(MDOC,' ---  LIBRARY OF MONOMERS   ---')
            LL = LEND
            IF(LL.GT.60) LL=60
            WRITE(LINE,'(A,6X,A)') ITEM(1:12),LB_NAME(1:LL)
            CALL MSGDOC(MDOC,LINE)
          ENDIF
          CALL LENSTR_BL(ITL_LIB_VER,L)
          IF(ITEM(1:LENI).EQ.ITL_LIB_VER(1:L)) THEN
            LB_VERS=DATA(1:LEND)
            LL = LEND
            IF(LL.GT.60) LL=60
            WRITE(LINE,'(A,6X,A)') ITEM(1:12),LB_VERS(1:LL)
            CALL MSGDOC(MDOC,LINE)
          ENDIF
          CALL LENSTR_BL(ITL_LIB_UPD,L)
          IF(ITEM(1:LENI).EQ.ITL_LIB_UPD(1:L)) THEN
            LB_DATE=DATA(1:LEND)
            LL = LEND
            IF(LL.GT.60) LL=60
            WRITE(LINE,'(A,6X,A)') ITEM(1:12),LB_DATE(1:LL)
            CALL MSGDOC(MDOC,LINE)
            CALL MSGDOC(MDOC,' ------------------------------')
          ENDIF
        ELSE IF(ITEM(1:LCMP).EQ.ITL_CMP(1:LCMP)) THEN
          IFIRST=1
          CALL PT_MLIST(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
          IF(IERR.NE.0) THEN
            CLOSE(IUN,ERR=420)
 420        CONTINUE
            LMI_IUN=0
            RETURN
          ENDIF

        ELSE IF(ITEM(1:LSN).EQ.ITL_SNM(1:LSN)) THEN
          CALL PT_MSYN(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ELSE IF(ITEM(1:LSNA).EQ.ITL_SNMA(1:LSNA)) THEN
          CALL PT_MSYN(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ELSE IF(ITEM(1:LDR).EQ.ITL_DER(1:LDR)) THEN
          CALL PT_MDER(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ELSE IF(ITEM(1:LMD).EQ.ITL_MOD(1:LMD)) THEN
          CALL PT_MDLIST(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ELSE IF(ITEM(1:LNK).EQ.ITL_LNK(1:LNK)) THEN
           CALL PT_LNLIST(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
C
C -- this is old
c        ELSE IF(ITEM(1:17).EQ.'_lib_mod_mon_list') THEN
c           CALL PT_MDMON(MDOC,I,BLK_CIF,LENB,ITEM,LENI
c     *    ,DATA,IDATA,FDATA,LEND,IERR)
c        ELSE IF(ITEM(1:18).EQ.'_lib_link_mon_list') THEN
c           CALL PT_LNMON(MDOC,I,BLK_CIF,LENB,ITEM,LENI
c     *    ,DATA,IDATA,FDATA,LEND,IERR)
C
        ELSE IF(ITEM(1:LCMPA).EQ.ITL_CMPA(1:LCMPA)) THEN
          GO TO 400
        ELSE IF(ITEM(1:LMDA).EQ.ITL_MODA(1:LMDA)) THEN
          GO TO 400
        ELSE IF(ITEM(1:LNKB).EQ.ITL_LNKB(1:LNKB)) THEN
          GO TO 400
        ELSE
c          IF(IFIRST.EQ.1) GO TO 400
        ENDIF
      ENDDO
      GO TO 300

  400 CONTINUE
      CLOSE(IUN,ERR=410)
 410  CONTINUE
      LMI_IUN=0
      
      IF(LB_PASS.EQ.LB_NUMB_LIB) THEN
        CALL LENSTR_BL(LMI2_FILE,LEN)
        IF(LEN.GT.0.AND.LMI2_FILE(1:1).NE.','.AND.
     *    LMI2_FILE(1:1).NE.' ') THEN
          GO TO 100
        ENDIF
      ELSE IF(LB_PASS.LT.LB_NUMB_LIB) THEN
        GO TO 100
      ENDIF
C -----------------------------------------------------------
      LML_NPRSNT = 0
      NM         = 0
      IF(LML_NMON.GT.0) THEN
        DO I=1,LML_NMON
          CH1 = LML_PRSNT(I)
          IF(CH1.EQ.'.'.OR.CH1.EQ.'C') 
     *    LML_NPRSNT = LML_NPRSNT + 1
          IF(LML_MNAME(I)(1:3).NE.'???') NM = NM + 1
        ENDDO
      ENDIF
C -----------------
      CALL SET_LIB_RES_TYPE_TAB(MDOC,IERR)
C -----------------
      LB_PASS = 0
      WRITE(LINE,
     *'('' NUMBER OF MONOMERS IN THE LIBRARY          :'',I6)') NM
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,
     *'(''               with complete description    :'',I6)')
     * LML_NPRSNT
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,
     *'('' NUMBER OF MODIFICATIONS                    :'',I6)') 
     * LDL_NMOD
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,
     *'('' NUMBER OF LINKS                            :'',I6)') 
     * LLL_NLINK
      CALL MSGDOC(MDOC,LINE)

      RETURN
C -----------------------------------
      END     

      SUBROUTINE SET_LIB_RES_TYPE_TAB(MDOC,IERR)
C ------------------------------------------------------
      INTEGER   MDOC,IERR
      CHARACTER MON*8,MONN*8,TYPE*16
C ---
      INCLUDE 'lib_com.fh'
C ---
C ------------------------------------------------------
      INTEGER    NRNAME_PAR,NRNAMEP_PAR,NRNAMED_PAR,NRNAMES_PAR

      PARAMETER ( NRNAME_PAR  = 400 )
      PARAMETER ( NRNAMEP_PAR = 200 )
      PARAMETER ( NRNAMED_PAR = 200 )
      PARAMETER ( NRNAMES_PAR = 200 )

      COMMON/COM_RES_TYPE/  NRNAME_T,NRNAMEP_T,NRNAMED_T,NRNAMES_T
     *                     ,RNAME_T,RNAMEP_T,RNAMED_T,RNAMES_T
      INTEGER   NRNAME_T,NRNAMEP_T,NRNAMED_T,NRNAMES_T
      CHARACTER RNAME_T (NRNAME_PAR )*8
      CHARACTER RNAMEP_T(NRNAMEP_PAR)*8
      CHARACTER RNAMED_T(NRNAMED_PAR)*8
      CHARACTER RNAMES_T(NRNAMES_PAR)*8
C==================================================================
      IERR  = 0
C L-peptide 
C D-peptide 
C peptide
C
C polymer 
C
C DNA
C RNA
C DNA/RNA
C 
C L-pyranose
C D-pyranose
C pyranose
C
C non-polymer
C
C solvent 
C
      NRNAME_T  = 0
      NRNAMEP_T = 0
      NRNAMED_T = 0
      NRNAMES_T = 0

      IF(LML_NMON.GT.0) THEN
        DO IM=1,LML_NMON
          MONN  = LML_MNAME(IM)
          TYPE  = LML_TYPE(IM)
          MON   = MONN
          TYPE  = LML_TYPE(IM)
          IF(TYPE(1:4).EQ.'L-pe'.OR.TYPE(1:4).EQ.'D-pe'.OR.
     *       TYPE(1:4).EQ.'pept') THEN
            IF(NRNAME_T.GT.0) THEN
              DO I=1,NRNAME_T
                IF(RNAME_T(I).EQ.MON) GO TO 100
              ENDDO
            ENDIF
            NRNAME_T = NRNAME_T + 1
            RNAME_T(NRNAME_T) = MON       
          ELSE IF(TYPE(1:4).EQ.'poly') THEN
            IF(NRNAMEP_T.GT.0) THEN
              DO I=1,NRNAMEP_T
                IF(RNAMEP_T(I).EQ.MON) GO TO 100
              ENDDO
            ENDIF
            NRNAMEP_T = NRNAMEP_T + 1
            RNAMEP_T(NRNAMEP_T) = MON 
          ELSE IF(TYPE(1:3).EQ.'DNA'.OR.TYPE(1:3).EQ.'RNA') THEN
            IF(NRNAMED_T.GT.0) THEN
              DO I=1,NRNAMED_T
               IF(RNAMED_T(I).EQ.MON) GO TO 100
              ENDDO
            ENDIF
            NRNAMED_T = NRNAMED_T + 1
            RNAMED_T(NRNAMED_T) = MON 
          ELSE IF(TYPE(1:4).EQ.'L-py'.OR.TYPE(1:4).EQ.'D-py'.OR.
     *       TYPE(1:4).EQ.'pyra') THEN
            IF(NRNAMES_T.GT.0) THEN
              DO I=1,NRNAMES_T
                IF(RNAMES_T(I).EQ.MON) GO TO 100
              ENDDO
            ENDIF
            NRNAMES_T = NRNAMES_T + 1
            RNAMES_T(NRNAMES_T) = MON 
          ENDIF
 100      CONTINUE
        ENDDO
      ENDIF
C ----
      IF(LDR_NDER.GT.0) THEN
        DO IM=1,LDR_NDER
          MONN  = LDR_MNAME(IM)
          MON   = MONN
          TYPE  = LDR_TYPE(IM)
          IF(TYPE(1:4).EQ.'L-pe'.OR.TYPE(1:4).EQ.'D-pe'.OR.
     *       TYPE(1:4).EQ.'pept') THEN
            IF(NRNAME_T.GT.0) THEN
              DO I=1,NRNAME_T
                IF(RNAME_T(I).EQ.MON) GO TO 200
              ENDDO
            ENDIF      
            NRNAME_T = NRNAME_T + 1
            RNAME_T(NRNAME_T) = MON 
          ELSE IF(TYPE(1:4).EQ.'poly') THEN
            IF(NRNAMEP_T.GT.0) THEN
              DO I=1,NRNAMEP_T
                IF(RNAMEP_T(I).EQ.MON) GO TO 200
              ENDDO
            ENDIF      
            NRNAMEP_T = NRNAMEP_T + 1
            RNAMEP_T(NRNAMEP_T) = MON 
          ELSE IF(TYPE(1:3).EQ.'DNA'.OR.TYPE(1:3).EQ.'RNA') THEN
            IF(NRNAMED_T.GT.0) THEN
              DO I=1,NRNAMED_T
                IF(RNAMED_T(I).EQ.MON) GO TO 200
              ENDDO
            ENDIF      
            NRNAMED_T = NRNAMED_T + 1
            RNAMED_T(NRNAMED_T) = MON 
          ELSE IF(TYPE(1:4).EQ.'L-py'.OR.TYPE(1:4).EQ.'D-py'.OR.
     *       TYPE(1:4).EQ.'pyra') THEN
            IF(NRNAMES_T.GT.0) THEN
              DO I=1,NRNAMES_T
                IF(RNAMES_T(I).EQ.MON) GO TO 200
              ENDDO
            ENDIF      
            NRNAMES_T = NRNAMES_T + 1
            RNAMES_T(NRNAMES_T) = MON 
          ENDIF
 200      CONTINUE
        ENDDO
      ENDIF
C ----
      RETURN
      END

C ******
      SUBROUTINE SSET_FUSE(CH1,CH2)
C -----------------------------------------
C -P- SET_FUSE - set use_flag = CH1 / "Y" or "N" /
C -S-            set            CH2   
C -----------------------------------------
      CHARACTER CH1*1,CH2*(*)
C ******
      INTEGER*4 L
C -----------------------------------------
      INCLUDE 'lib_com.fh'
C --------------------------------
      IF(LML_NMON.LE.0) RETURN
      DO L=1,LML_NMON
        IF(CH1.EQ.'N') THEN
          LMA_NATOM = 0
          LMN_NCONN = 0
          LMB_NBOND = 0
          LMG_NANGL = 0
          LMT_NTORS = 0
          LMC_NCHIR = 0
          LMP_NPLAN = 0
          DO   I=1,MAXMLIST
            LML_IATOM(I) = 0
            LML_ICONN(I) = 0
            LML_IBOND(I) = 0
            LML_ITHET(I) = 0
            LML_ITORS(I) = 0
            LML_IPLAN(I) = 0
            LML_ICHIR(I) = 0
          ENDDO
        ELSE
          IF(CH1.NE.' ') LML_FUSE (L)   = CH1
        ENDIF
      ENDDO

      RETURN
      END     

C ******
      SUBROUTINE READ_LIB(MDOC,MOD,NODIST,LIST,IERR)
C -------------------------------------------------------
C -P- READ_LIB - reads libraries of monomers and energy parameters.
C -S-
C                MOD - 'A' - all    
C                      'M' - only monomers
C                      'N' - only MOD and LINK
C                      'E' - only ener_lib
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MOD*1,NODIST*1,LIST*1

C ******
C -----------------------------------------------
      INTEGER*4 IEND
      CHARACTER MODE*4
C -----------------------------------------------
      IERR=0
      IEND=0      
C ---
      IF(MOD.EQ.'A'.OR.MOD.EQ.'N') THEN
        CALL RD_MD_LINK_LIB(MDOC,IERR,IEND)
        IF(IERR.NE.0) RETURN
      ENDIF

      IF(MOD.EQ.'A'.OR.MOD.EQ.'M') THEN

        CALL CHECK_FUSE_R(MDOC,IERR)
        CALL RD_MONLIB(MDOC,NODIST,LIST,IERR,IEND)
        IF(IERR.NE.0) RETURN

        CALL SET_FUSE_Y(MDOC,IERR)

      ENDIF
C ---
C     creat list of chemical type of atoms from mon_library 
c      CALL GET_CLIST(MDOC,IERR)    
c      IF(IERR.NE.0) RETURN
C ---
      IF(MOD.EQ.'A'.OR.MOD.EQ.'E') THEN
c       MODE = 'H   '
        MODE = 'ALL '
        IF(MODE.NE.'ALL ') THEN
          CALL GET_CLIST(MDOC,IERR)    
          IF(IERR.NE.0) RETURN
        ENDIF
        CALL RD_ENRLIB(MDOC,MODE,IERR)
        IF(IERR.NE.0) RETURN

        CALL SET_ENER_POINTER_TO_ATOM(MDOC,IERR)
        IF(IERR.NE.0) RETURN
        
      ENDIF

C -----------------------------------
      RETURN
      END     

      SUBROUTINE SET_ENER_POINTER_TO_ATOM(MDOC,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ------
C      REAL      LEA_WEIGHT (MAXETYP)
C      REAL      LEA_RADIUS (MAXETYP)
C      REAL      LEA_HRADIUS(MAXETYP)
C      REAL      LEA_IRADIUS(MAXETYP)
C      REAL      LEA_POLAR  (MAXETYP)
C      REAL      LEA_HPOLAR (MAXETYP)
C      INTEGER*4 LEA_VALENCY(MAXETYP)
C      INTEGER*4 LEA_NATOM,LEA_IATOM
C
C      CHARACTER LEA_ANAME (MAXETYP)*4
C      CHARACTER LEA_ENAME (MAXETYP)*4
C      CHARACTER LEA_HTYPE (MAXETYP)*1
C      CHARACTER LEA_TYPE  (MAXETYP)*1
C
C      REAL      LEB_CONST   (MAXBTYP)
C      REAL      LEB_LENGTH  (MAXBTYP)
C      INTEGER*4 LEB_NBOND,LEB_IBOND
C      INTEGER*4 LEB_I1ATM   (MAXBTYP)
C      INTEGER*4 LEB_I2ATM   (MAXBTYP)
C      CHARACTER LEB_1ATM  (MAXBTYP)*4
C      CHARACTER LEB_2ATM  (MAXBTYP)*4
C      CHARACTER LEB_TYPE  (MAXBTYP)*8
C
C      REAL      LEG_CONST (MAXATYP)
C      REAL      LEG_ANGLE (MAXATYP)
C      INTEGER*4 LEG_NANGL,LEG_IANGL 
C      INTEGER*4 LEG_I1ATM (MAXTTYP)
C      INTEGER*4 LEG_I2ATM (MAXTTYP)
C      INTEGER*4 LEG_I3ATM (MAXTTYP)
C      CHARACTER LEG_1ATM  (MAXATYP)*4
C      CHARACTER LEG_2ATM  (MAXATYP)*4
C      CHARACTER LEG_3ATM  (MAXATYP)*4
C ------------------------------------------------
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4
      CHARACTER LINE*256
C --------------------------------------------------------
      IERR = 0
      IF(LEA_NATOM.LE.0) RETURN

      IF(LEB_NBOND.GT.0) THEN
        DO IB=1,LEB_NBOND
          ATOM1 = LEB_1ATM(IB) 
          DO IA=1,LEA_NATOM
            IF(ATOM1.EQ.LEA_ANAME(IA)) THEN
              LEB_I1ATM(IB) = IA
              GO TO 100  
            ENDIF
          ENDDO
          IERR = 1
          LINE = 'ERROR: ener_lib(bond): atom type:'//ATOM1//
     *    ' not found in the list'
          CALL MSGERR(MDOC,line)
 100      CONTINUE
          ATOM2 = LEB_2ATM(IB)
          DO IA=1,LEA_NATOM
            IF(ATOM2.EQ.LEA_ANAME(IA)) THEN
              LEB_I2ATM(IB) = IA
              GO TO 200  
            ENDIF
          ENDDO
          IERR = 1
          LINE = 'ERROR: ener_lib(bond): atom type:'//ATOM2//
     *    ' not found in the list'
          CALL MSGERR(MDOC,LINE)
 200      CONTINUE
        ENDDO
      ENDIF

      IF(LEG_NANGL.GT.0) THEN
        DO IG=1,LEG_NANGL
          ATOM1 = LEG_1ATM(IG) 
          DO IA=1,LEA_NATOM
            IF(ATOM1.EQ.LEA_ANAME(IA)) THEN
              LEG_I1ATM(IG) = IA
              GO TO 300  
            ENDIF
          ENDDO
          IERR = 1
          LINE = 'ERROR: ener_lib(angle): atom type:'//ATOM1//
     *    ' not found in the list'
          CALL MSGERR(MDOC,LINE)
 300      CONTINUE
          ATOM2 = LEG_2ATM(IG)
          DO IA=1,LEA_NATOM
            IF(ATOM2.EQ.LEA_ANAME(IA)) THEN
              LEG_I2ATM(IG) = IA
              GO TO 400  
            ENDIF
          ENDDO
          IERR = 1
          LINE = 'ERROR: ener_lib(angle): atom type:'//ATOM2//
     *    ' not found in the list'
          CALL MSGERR(MDOC,LINE)
 400      CONTINUE
          ATOM3 = LEG_3ATM(IG)
          DO IA=1,LEA_NATOM
            IF(ATOM3.EQ.LEA_ANAME(IA)) THEN
              LEG_I3ATM(IG) = IA
              GO TO 500  
            ENDIF
          ENDDO
          IERR = 1
          LINE = 'ERROR: ener_lib(angle): atom type:'//ATOM3//
     *    ' not found in the list'
          CALL MSGERR(MDOC,LINE)
 500      CONTINUE
        ENDDO
      ENDIF

      RETURN
      END


C ******
      SUBROUTINE RD_MONLIB(MDOC,NODIST,LIST,IERR,IEND)
C -------------------------------------------------------
C -P- RD_MONLIB - reads library of monomers
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,IEND
      CHARACTER NODIST*1
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---
      COMMON/COM_CRD_CIF/ IEND_CIF      
C ---
C -----------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,IUN,M,IFLAG_MON,IFLAG_MOD,IFLAG_LINK,I,IM
      INTEGER*4 NLIB_LIM
      CHARACTER DATA*80,ITEM*80,BLOCK*8,BLOCK_OLD*8,LIST*1,NODIST_FLAG*1
      CHARACTER LINE*256
      CHARACTER MOD*1,LIB*256,MON*8,CHAR1*1,NAME*256,CH8*8
C ---
      INCLUDE 'crd_com.fh'
C ----------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------
C
C     CALL INIT_CNT
C
      MOD      = 'M'
      LB_PASS  = 0
      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of monomers in library = 0.')
        IERR=1
        RETURN
      ENDIF

      NLIB_LIM = LB_NUMB_LIB

 200  CONTINUE

      LB_PASS    = LB_PASS + 1

      IM = 0
      DO I=1,LML_NMON
        IF(LML_FUSE(I).EQ.'R'.AND.LML_PASS(I).EQ.LB_PASS) IM = IM + 1
      ENDDO

      IF(IM.LE.0) GO TO 410 

      IERR       = 0
      IEND       = 0
      IFLAG_MON  = 0
      IFLAG_MOD  = 0
      IFLAG_LINK = 0
C ------
C     open file of mon_library
C     IUN = 10

      IUN = CRI_IUN
      M   = 99

      IF(LB_PASS.LE.1) THEN

        DO I=1,LML_NMON

          IF(LML_FUSE(I).EQ.'R'.AND.LML_PASS(I).EQ.LB_PASS) THEN

C            IF(LIST.EQ.'T') THEN
C              WRITE(*,*) '-RD:',I,LML_MNAME(I),LML_FUSE(I),LML_PASS(I)
C              WRITE(*,*) '-RD:',lb_pass,';',nodist,';',LMI_FILE(LB_PASS)
C              WRITE(*,*) '-RD:',LMI_FILE(1),';',NLIB_LIM
C            ENDIF

            MON = LML_MNAME(I)
            CALL LENSTR_BL(LIB,LEN) 

            CHAR1 = MON(1:1)
            IMODE = -1
            CALL CHECK_LINE(IMODE,CHAR1) 
            NAME = LMI_FILE(LB_PASS)
            CALL LENSTR_BL(NAME,LN)
 
            CALL LENSTR_BL(LMI_FILE(2),LLN) 

            NODIST_FLAG = 'N'
            IF(NLIB_LIM.EQ.1.AND.LLN.EQ.1) THEN
              IF(LMI_FILE(2)(1:1).EQ.'Y') NODIST_FLAG = 'Y'
            ENDIF

            IF(NODIST.NE.'Y'.AND.NODIST_FLAG.NE.'Y') THEN
              CH8 = MON
              IF(CH8.EQ.'CD') CH8 ='CD_EL' 
              IF(CH8.EQ.'CR') CH8 ='CR_EL' 
              IF(CH8.EQ.'GD') CH8 ='GD_EL' 
              IF(CH8.EQ.'AR') CH8 ='AR_EL' 
              IF(CH8.EQ.'IR') CH8 ='IR_EL' 
              IF(CH8.EQ.'COM') CH8 ='COM_COM' 
              IMODE = 1
c             convert symbols to upper case
              CALL CHECK_LINE(IMODE,CH8) 
              LIB = CHAR1//'/'//CH8 
            ELSE
              LIB = NAME
            ENDIF

            CALL OPENFR(IUN,M,LMI_PATH,LIB,LMI_EXT,IERR)
            IF(IERR.NE.0) THEN
              CALL LENSTR_BL(LIB,LEN) 
              IF(LEN.GT.50) LEN=50
              IF(LEN.LE.0) THEN
                LEN = 1
                LIB(1:1) = '?'
              ENDIF
              WRITE(LINE,*) ' ERROR: can"t open (lib.):',LIB(1:LEN)
              CALL MSGERR(MDOC,LINE)
              RETURN
            ENDIF

            CALL RD_MONLIB_ONE(MDOC,MOD,IUN,NODIST,LIST,IERR,IEND)
            IF(IERR.NE.0) RETURN

          ENDIF

        ENDDO

        GO TO 410

      ELSE IF(LB_PASS.LE.NLIB_LIM) THEN
        LIB = LMI_FILE(LB_PASS) 
        CALL OPENFR(IUN,M,LMI_PATH,LIB,LMI_EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL LENSTR_BL(LIB,LEN) 
          IF(LEN.GT.50) LEN=50
          IF(LEN.LE.0) THEN
            LEN = 1
            LIB(1:1) = '?'
          ENDIF
          WRITE(LINE,*) ' ERROR: can"t open (lib..)',LIB(1:LEN)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ELSE
        CALL OPENFR(IUN,M,LMI2_PATH,LMI2_FILE,LMI2_EXT,IERR)
        IF(IERR.NE.0) THEN
          LIB = LMI2_FILE
          CALL LENSTR_BL(LMI2_FILE,LEN) 
          IF(LEN.GT.50) LEN=50
          IF(LEN.LE.0) THEN
            LIB = '?'
            LEN = 1
          ENDIF
          WRITE(LINE,*) ' ERROR: can"t open (lib2.)',LIB(1:LEN)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ENDIF

C      CALL OPENFR(IUN,M,LMI_PATH,LMI_FILE,LMI_EXT,IERR)
C      IF(IERR.NE.0) THEN
C        CALL MSGERR(MDOC,' ERROR: can''t open "mon_lib.cif" .')
C        RETURN
C      ENDIF

      CALL RD_MONLIB_ONE(MDOC,MOD,IUN,NODIST,LIST,IERR,IEND)
      IF(IERR.NE.0) RETURN

 410  CONTINUE

      LMI_IUN = 0

      IF(LB_PASS.EQ.NLIB_LIM) THEN
        CALL LENSTR_BL(LMI2_FILE,LEN)
        IF(LEN.GT.0.AND.LMI2_FILE(1:1).NE.','.AND.
     *    LMI2_FILE(1:1).NE.' ') THEN
          GO TO 200
        ENDIF
      ELSE IF(LB_PASS.LT.NLIB_LIM) THEN
        GO TO 200
      ENDIF
C ----
      LB_PASS = 0
      RETURN
      END     

      SUBROUTINE RD_MONLIB_ONE(MDOC,MOD,IUN,NODIST,LIST,IERR,IEND)
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,IEND
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---
      COMMON/COM_CRD_CIF/ IEND_CIF      
C ---
C -----------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,IUN,M,IFLAG_MON,IFLAG_MOD,IFLAG_LINK,I,IM
      INTEGER*4 NLIB_LIM
      CHARACTER DATA*80,ITEM*80,BLOCK*8,BLOCK_OLD*8
      CHARACTER LINE*256,MOD*1,LIB*256,LIST*1,NODIST*1
C ---
      INCLUDE 'crd_com.fh'
C ----------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------
c      LIST = 'N'
C ----
      IERR       = 0
      IEND       = 0
      IFLAG_MON  = 0
      IFLAG_MOD  = 0
      IFLAG_LINK = 0

      LMI_IUN   = IUN
      IEND      = -1
      BLOCK_OLD = '   '
      L_OLD     = -1
      L         = 0
C -------
      IF(IEND.EQ.-1) THEN
        REWIND IUN
        IEND_CIF = -1
        IEND     = 0
      ENDIF

  300 CONTINUE   
      
      CALL GETCIF_INFO(IUN,MDOC,IERR,IEND_CIF)

      IF(IERR.NE.0.OR.(IEND_CIF.NE.0.AND.IEND_CIF.NE.-2)) THEN

        IEND=1
        GO TO 400
C        CLOSE(IUN)
C        LMI_IUN=0
C        RETURN
      ENDIF

      IF(IEND_CIF.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment
C   
        CALL LENSTR_BL(DT_CIF(1),LEND) 
        DATA = DT_CIF(1)(1:LEND)
        GO TO 300
      ENDIF
      
      CALL LENSTR_BL(BLK_CIF,LENB)
      CALL LENSTR_BL(ITL_DCMP,LDCMP)
c     DATA ITL_DCMP      /'data_comp_                              '/

C -- !!  BLK_CIF(1:10) = 'data_comp_XXX

c      IF(LIST.EQ.'T') THEN
c        WRITE(*,*) 'BLK_CIF:',BLK_CIF(1:LDCM)
c      ENDIF

C      LBB = 10
C      LS  = LBB+1
C      LF  = LBB+3

      LS  = LDCMP + 1 
      LF  = LENB

      CALL LENSTR_BL(DT_CIF(1),LEND) 
      DATA = DT_CIF(1)(1:LEND)

      IF(N_CIF.EQ.0) THEN

        CALL LENSTR_BL(ITL_DCMP,LDCM) 

C        IF(LENB.GE.LS.AND.LENB.LE.LF.AND.
C     *            BLK_CIF(1:LBB).EQ.'data_comp_') THEN

        IF(BLK_CIF(1:LDCM).EQ.ITL_DCMP(1:LDCM)) THEN

          LB = LENB
C         IF(LB.GT.13) LB = 13
          BLOCK = BLK_CIF(LS:LB)
c          IF(LB.LT.LF    ) BLOCK(3:3) = ' '
c          IF(LB.LT.(LF-1)) BLOCK(2:2) = ' '

          IF(BLOCK.NE.BLOCK_OLD) THEN
            IF(LML_NMON.LE.0) THEN
              CALL MSGERR(MDOC
     *        ,' ERROR: number of monomers in library = 0')
              IERR = 1
              CLOSE(IUN,ERR=440)
 440          CONTINUE
              LMI_IUN = 0
              RETURN
            ENDIF
            DO L=1,LML_NMON
              IF(BLOCK.EQ.LML_MNAME(L)) THEN
                BLK_FLAG = LML_FUSE(L)
                BLK_FLAG = 'Y'
                LML_IMON = L

                IF(LIST.EQ.'T') THEN
                  WRITE(*,*) 'RM_ONE:',L,LML_MNAME(L),LML_FUSE(L),L_OLD
                ENDIF

                IF(L_OLD.GT.0) THEN
                  IF(LML_FUSE(L_OLD).EQ.'R') THEN
                    CALL CHECK_RLIB_TREE(MDOC,LIST,L_OLD,IERR)
                  ENDIF
                ENDIF

                L_OLD = L
                GO TO 100
              ENDIF
            ENDDO
            BLK_FLAG = 'N'

  100       CONTINUE
            BLOCK_OLD = BLOCK
          ENDIF
        ENDIF
        GO TO 300
      ENDIF

      CALL LENSTR_BL(DT_CIF(1),LEND) 
      DATA = DT_CIF(1)(1:LEND)


      DO I=1,N_CIF

        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM  = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA  = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IDATA = IDT_CIF(I)
        FDATA = FDT_CIF(I)

c       IF(ITEM(1:16).EQ.'_chem_comp_atom.') IFLAG_MON = 1
c       IF(ITEM(1:15).EQ.'_chem_mod_atom.')  IFLAG_MOD = 1
c       IF(ITEM(1:16).EQ.'_chem_link_bond.') IFLAG_LINK = 1

        CALL LENSTR_BL(ITL_CMPA,LCMA)
        CALL LENSTR_BL(ITL_MODA,LMDA)
        CALL LENSTR_BL(ITL_LNKB,LLNB)
        IF(ITEM(1:LCMA).EQ.ITL_CMPA(1:LCMA)) IFLAG_MON  = 1
        IF(ITEM(1:LMDA).EQ.ITL_MODA(1:LMDA)) IFLAG_MOD  = 1
        IF(ITEM(1:LLNB).EQ.ITL_LNKB(1:LLNB)) IFLAG_LINK = 1


C       DATA ITL_CMP       /'_chem_comp.                             '/
C       DATA ITL_MOD       /'_chem_mod.                              '/
C       DATA ITL_LNK       /'_chem_link.                             '/

        CALL LENSTR_BL(ITL_CMP,LCM)
        CALL LENSTR_BL(ITL_MOD,LMD)
        CALL LENSTR_BL(ITL_LNK,LLN)

        IF(BLK_CIF(1:7) .EQ.'global_') THEN         

        ELSE IF(ITEM(1:LCM-1).EQ.ITL_CMP(1:LCM-1).AND.
     *            BLK_CIF(1:LENB).NE.'data_comp_list') THEN

          IF(MOD.NE.'N') THEN

c            IF(LIST.EQ.'T') THEN
c              WRITE(*,*) 'RM_ONE::',I,L
c              WRITE(*,*) 'RM_ONE::',I,L,LML_FUSE(L)
c            ENDIF

            IF(LML_FUSE(L).EQ.'R') THEN

            CALL PUT_MNLIB(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *      ,DATA,IDATA,FDATA,LEND,IERR)
            IF(IERR.NE.0) THEN
              CLOSE(IUN)
              LMI_IUN = 0
              RETURN
            ENDIF

            ENDIF

          ENDIF 

        ELSE IF(ITEM(1:LMD-1).EQ.ITL_MOD(1:LMD-1)) THEN

C          IF(MOD.EQ.'M'.AND.IFLAG_MON.EQ.1) GO TO 400 

        ELSE IF(ITEM(1:LLN-1).EQ.ITL_LNK(1:LLN-1)) THEN

C          IF(MOD.EQ.'M'.AND.IFLAG_MON.EQ.1) GO TO 400 

        ENDIF

      ENDDO
      GO TO 300
C -----------------------------------
 400  CONTINUE

c      IF(LIST.EQ.'T') THEN
c        WRITE(*,*) 'RM_ONE-:',L_OLD
c        WRITE(*,*) 'LML_PASS:',LML_PASS(L_OLD),LML_FUSE(L_OLD)
c      ENDIF

      IF(L_OLD.GT.0) THEN
      IF(L_OLD.GT.1.OR.LML_PASS(L_OLD).GT.1.OR.NODIST.EQ.'Y') THEN
        IF(LML_FUSE(L_OLD).EQ.'R') THEN
          CALL CHECK_RLIB_TREE(MDOC,LIST,L_OLD,IERR)
        ENDIF
      ENDIF
      ENDIF

      CLOSE(IUN,ERR=410)
 410  CONTINUE
      RETURN
      END

      SUBROUTINE CHECK_RLIB_TREE(MDOC,LIST,L,IERR)                 
C ----------------------------------------
C     L =< 0 from L1 (not cp_mlib) ; l = 0 cpl_mlib with  L1L_FUSE = 'C'
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER ASYMB*4,CTYPE*4,MON*8,LIST*1,TREE*1,PNUM*12
      CHARACTER MODE*4,LINE*256
C ----------------------------------------

      IF(L.GT.0) THEN
        MON = LML_MNAME(L)
        IF(LIST.EQ.'T') THEN
          write(line,*) '--check_rlib:',l,LML_NMON,mon
          CALL MSGDOC(MDOC,LINE)
          write(line,*) '---fused,pass:',LML_FUSE(l),LML_PASS(l)
          CALL MSGDOC(MDOC,LINE)
        ENDIF

        IA        = LML_IATOM(L)
        CALL COUNT_NATOM_LIB(MDOC,MON,IA,NATOM,NHATOM,IERR)
        IF(IERR.NE.0) RETURN

        IF(LIST.EQ.'T') THEN
          write(line,*) '--ia,na,nha:',ia,NATOM,NHATOM
          CALL MSGDOC(MDOC,LINE)
        ENDIF

        LML_NATM  (L) = NATOM
        LML_NHATM (L) = NHATOM

        LML_FUSE(L) = 'Y'
        CALL CP_MLIB(MDOC,MON,IERR)
        IF(IERR.NE.0) THEN
          IF(LIST.EQ.'T') THEN
            write(line,*) '--cp_mlib:',ierr
            CALL MSGDOC(MDOC,LINE)
          ENDIF
          RETURN
        ENDIF
C ---
        IF(L1B_NBOND.GE.2.AND.L1G_NANGL.LE.0) THEN
          L1L_PRSNT    = 'M'
          LML_PRSNT(L) = 'M' 
        ENDIF
C ---
      ELSE
        MON = L1L_MNAME
        IF(LIST.EQ.'T') THEN
          write(line,*) '--check_rlib:',l,mon,L1A_NATOM
          CALL MSGDOC(MDOC,LINE)
        ENDIF
      ENDIF

      NA   = L1A_NATOM
      IF(NA.LE.1) RETURN

      TREE = 'N'
      DO I=1,NA
        IF(L1A_BACK(I).NE.'.') TREE = 'Y'
      ENDDO
      IF(L.GT.0) THEN
        IF(LML_PASS(L).GT.1) TREE = 'N'
      ENDIF

      CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITYPE_RES,IERR)

      IF(LIST.EQ.'T') THEN
c        call WRITE_LIB_RES_TYPE_TAB(MDOC,IERR)
        write(*,*) '-- ini_res_type:',mon,itype_res
      ENDIF               

      CALL PRECHECK_L1_MON_DESCRIPTION(MDOC,LIST,IERR)
      IF(IERR.NE.0) THEN
        IF(IERR.LT.100) TREE = 'N'
        IERR = 0
      ENDIF
      L1A_ISTART  = 0
      L1A_IFINISH = 0
      DO I=1,NA
        L1A_INEW (I) = I 
        L1A_IOLD (I) = I
        L1A_ICHEM(I) = 0              
        L1A_ICR  (I) = 0
        L1A_NDIST(I) = 0
        L1A_IBACK(I) = 0
        L1A_IFORW(I) = 0
C        L1A_BACK (I) = '.'
C        L1A_TYPE (I) = '.' 
C        L1A_FORW (I) = '.'
        DO  J=1,MAX1BRN 
          L1A_CONN   (J,I) = 0
          L1A_LENCON (J,I) = 0
        ENDDO
        DO  J=1,MAX1EXT 
          L1A_TEXTR (J,I) = 0
          L1A_IEXTR (J,I) = 0
        ENDDO
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *     ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *     ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
          CTYPE='C   '
        ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
          CTYPE='H   '
          L1A_NHATOM   = L1A_NHATOM + 1
        ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
          CTYPE='P   '
        ELSE
          CTYPE='$   '
        ENDIF
        L1A_ATYPE(I)=CTYPE(1:1)
      ENDDO
C --
      MODE=' '
      CALL LIB_CONN(MDOC,MODE,IERR)
C --
      IF(LIST.EQ.'T') THEN
        NA   = L1A_NATOM
        write(line,*) '-- before ring -- prsnt,tree:'
     *   ,L1L_PRSNT,':',TREE,':'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     * '(i2,1x,a,1x,2i4,1x,i3,1x,1x,i3,1x,'';'',6i3,'';'',6i3,A)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_icr(Ia),L1A_ichem(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5),L1A_CHEM(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF

  
      IF(L1L_PRSNT.NE.'M') THEN

        IF(TREE.EQ.'Y') THEN
          PNUM = '       '
          CALL SET_NUM_MOD(MDOC,MON,PNUM,IERR)

          IF(LIST.EQ.'T') THEN
            NA   = L1A_NATOM
            write(line,*) '-- after SET_NUM_MOD  --',mon
            CALL MSGDOC(MDOC,LINE)
            write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
            CALL MSGDOC(MDOC,LINE)
            DO    IA=1,NA
              write(line,
     * '(i2,1x,a,1x,2i4,1x,i3,1x,1x,i3,1x,'';'',6i3,'';'',6i3,A)') 
     *        ia,l1a_aname(ia)
     *        ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_icr(Ia),L1A_ichem(Ia)
     *        ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *        ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5),L1A_CHEM(IA)
              CALL MSGDOC(MDOC,LINE)
            ENDDO
          ENDIF

c         CALL CHECK_RES_TYPE(MDOC,ITYPE_RES,IERR)
c          CALL CHECK_RES_TYPE_BY_ATOM_AND_BOND
c     *                                  (MDOC,ITYPE_RES,IERR)
          IF(LIST.EQ.'T') THEN
            write(*,*) '-- itype_res:',itype_res
          ENDIF               

          IF(IERR.EQ.0) THEN
            CALL CHECK_TREE_DIRECTION(MDOC,LIST,ITYPE_RES,IERR)
            IF(IERR.NE.0) THEN
              TREE = 'N'
              IERR = 0
            ENDIF
          ENDIF
        ENDIF

        IF(LIST.EQ.'T') THEN
          WRITE(LINE,*) '== before ring: tree,ierr:',TREE,';',IERR
          call msgdoc(mdoc,line)
        endif

        IF(TREE.EQ.'N') THEN
C ---
C         define rings
          IPRSNT = 1
          CALL RING(MDOC,LIST,NRING,IPRSNT,IERR)
C ---
C         create tree like structure
          IF(LIST.EQ.'T') THEN
            WRITE(LINE,*) '== create tree: tree,ierr',TREE,';',IERR
            call msgdoc(mdoc,line)
          ENDIF

          CALL CREATE_TREE_NEW(MDOC,LIST,IERR)
          IF(LIST.EQ.'T') THEN
             WRITE(LINE,*) '== set_num_mod:',TREE,';',IERR
           call msgdoc(mdoc,line)
          ENDIF
          PNUM = '       '
          CALL SET_NUM_MOD(MDOC,MON,PNUM,IERR)
          IF(IERR.EQ.0) THEN

c           CALL CHECK_RES_TYPE(MDOC,ITYPE_RES,IERR)
c            CALL CHECK_RES_TYPE_BY_ATOM_AND_BOND
c     *                                  (MDOC,ITYPE_RES,IERR)

            CALL CHECK_TREE_DIRECTION(MDOC,LIST,ITYPE_RES,IERR)
C ---
            IF(IERR.EQ.0) TREE = 'C'
          ENDIF
C          IERR = 0
        ENDIF

      ENDIF
C ---------
      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '== before end:',TREE,';',IERR
        call msgdoc(mdoc,line)
        NA     = L1A_NATOM
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
C ---
      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '-- end check_rlib, tree,ierr:',TREE,';',IERR
        call msgdoc(mdoc,line)
      ENDIF


      IF(IERR.NE.0) RETURN

      IF(TREE.EQ.'C'.OR.L.EQ.0) THEN
        L1L_FUSE = 'Y'
        IF(L.LE.1) L1L_FUSE   = 'C'
        CALL CPL_MLIB(MDOC,IERR)
      ENDIF
C ----------------------------------------
      RETURN
      END

      SUBROUTINE CHECK_TREE_DIRECTION(MDOC,LIST,ITYPE_RES,IERR)
C -----------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256
      CHARACTER ATOMS*4,ATOMF*4,ATOM*4,MON*8,TREE*1,LIST*1
C -----------------------------

      IERR = 0
      MON  = L1L_MNAME
      NA   = L1A_NATOM
      IF(NA.LE.2) RETURN
C      CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITYPE_RES,IERR)

      IF(ITYPE_RES.EQ.5.OR.ITYPE_RES.EQ.6.OR.ITYPE_RES.EQ.7.OR.
     *   ITYPE_RES.EQ.8.OR.ITYPE_RES.EQ.3.OR.ITYPE_RES.EQ.4.OR.
     *                                      ITYPE_RES.EQ.10) THEN

        IF(ITYPE_RES.EQ.5.OR.ITYPE_RES.EQ.6) THEN
C         P -> O5* - C5*  - C4* = C3* -> O3*
          ATOMS = 'O5* '
          DO I=1,NA
            ATOM = L1A_ANAME(I)
            IF(ATOM.EQ.'O3T ') ATOMS = 'O3T '
            IF(ATOM.EQ.'P   '.AND.ATOMS.NE.'O3T ') ATOMS = 'P   '
          ENDDO
          ATOMF = 'O3* '
        ELSE IF(ITYPE_RES.EQ. 7.OR.ITYPE_RES.EQ.8) THEN
C         C1 -> C2 -> C3 -> C4 -> C5 -> O5
          ATOMS = 'C1  '
          ATOMF = 'O5  '
        ELSE IF(ITYPE_RES.EQ.3.OR.ITYPE_RES.EQ.4.OR.
     *                                      ITYPE_RES.EQ.10) THEN
C         N -> CA -> C
          ATOMS = 'N   '
          ATOMF = 'C   '
        ENDIF
C         
        ISTART  = 0
        IFINISH = 0
        DO I=1,NA
          ATOM = L1A_ANAME(I)
          IF(ATOM.EQ.ATOMS) ISTART  = I
          IF(ATOM.EQ.ATOMF) IFINISH = I
        ENDDO

        TREE = 'Y'

        IF(LIST.EQ.'T') THEN
        write(*,*) 'corr sl,fl:',l1a_istart,l1a_ifinish
        write(*,*) '     is,if:',istart,ifinish
        write(*,*) '   itype_r:',itype_res
        NA     = L1A_NATOM
        LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF

        IF(TREE.EQ.'Y'.AND.
     *    ((ISTART .NE.0.AND.ISTART .NE.L1A_ISTART ).OR.
     *     (IFINISH.NE.0.AND.IFINISH.NE.L1A_IFINISH)    )) THEN
          IF(ISTART.EQ.L1A_IFINISH.AND.ISTART.GT.0) THEN
            ITYPE = 0
            CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)

            IF(LIST.EQ.'T') THEN
            write(*,*) '  it:',itype,l1a_istart,l1a_ifinish,IERR
             NA     = L1A_NATOM
            LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
            CALL MSGDOC(MDOC,LINE)
            DO    IA=1,NA
            write(line,
     *      '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *      ia,l1a_aname(ia)
     *      ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *      ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *      ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
            CALL MSGDOC(MDOC,LINE)
            ENDDO
            ENDIF

            IF(IERR.NE.0) THEN
              TREE = 'N'
              IERR = 0
              GO TO 200
            ENDIF
          ENDIF
          IF(ISTART.NE.L1A_ISTART.AND.ISTART.GT.0) THEN
            ITYPE = 1
            CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)

            IF(LIST.EQ.'T') THEN
            write(*,*) '  it:',itype,l1a_istart,l1a_ifinish,IERR
            NA     = L1A_NATOM
            LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
            CALL MSGDOC(MDOC,LINE)
            DO    IA=1,NA
            write(line,
     *    '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *      ia,l1a_aname(ia)
     *      ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *      ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *      ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
            CALL MSGDOC(MDOC,LINE)
            ENDDO
            ENDIF

            IF(IERR.NE.0) THEN
              TREE = 'N'
              IERR = 0
              GO TO 200
            ENDIF
          ENDIF
          IF(IFINISH.NE.L1A_IFINISH.AND.IFINISH.GT.0) THEN
            ITYPE = 2
            CALL MOD_TREE_BACKBONE(ITYPE,ISTART,IFINISH,IERR)

            IF(LIST.EQ.'T') THEN
            write(*,*) '  it:',itype,l1a_istart,l1a_ifinish,IERR
            NA     = L1A_NATOM
            LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
            CALL MSGDOC(MDOC,LINE)
            DO    IA=1,NA
            write(line,
     *    '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *      ia,l1a_aname(ia)
     *      ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *      ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *      ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
            CALL MSGDOC(MDOC,LINE)
            ENDDO
            ENDIF

            IF(IERR.NE.0) THEN
              TREE = 'N'
              IERR = 0
              GO TO 200
            ENDIF
          ENDIF
        ENDIF
 200    CONTINUE
        IF(TREE.EQ.'N') IERR = 1

        IF(LIST.EQ.'T') THEN
        write(*,*) '  NEW:',l1a_istart,l1a_ifinish,IERR
        NA     = L1A_NATOM
        LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF

      ENDIF
C ----
      RETURN
      END



      SUBROUTINE CREATE_TREE_NEW(MDOC,LIST,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256,ASYMB*4,ATOM1*4,ATOM2*4
      CHARACTER MON*8,LIST*1
C --------------------------------
      IERR = 0
C     M    =-ABS(MDOC)-1
C ---
C      LIST = 'N'
C      LIST = 'T'

      NA     = L1A_NATOM
      MON    = L1L_MNAME        

      IF(NA.LE.0) THEN
        IERR=1
        RETURN
      ENDIF

      CALL PRECHECK_RES_TYPE(MDOC,ITYPE_RES,IERR)


C     store : L1A_LENCON(1,IA) in  L1A_IOLD(IA) 
C     copy L1A_CONN(J,IA) to L1A_LENCON(J,IA)
      DO IA=1,NA
        L1A_IOLD(IA)=L1A_LENCON(1,IA)
        IF(L1A_NDIST(IA).GT.0) THEN
          DO J=1,L1A_NDIST(IA)
C            L1A_LENCON(J,IA)= L1A_CONN(J,IA)
c ---  7.07.03         
            L1A_LENCON(J,IA)= ABS(L1A_CONN(J,IA))
C ---
          ENDDO
        ENDIF
      ENDDO

C -----
C     NC - total number of connect.
C     L1A_NEXTR(I) - number of connect. for Ith atom.
C
      NC=0
      DO I=1,NA
        L1A_NEXTR(I)=0
        IF(L1A_NDIST(I).GT.0) THEN
          DO J=1,L1A_NDIST(I)
            IF(L1A_LENCON(J,I).GT.0) THEN
              NC=NC+1
              L1A_NEXTR(I)=L1A_NEXTR(I)+1
            ENDIF
          ENDDO
        ENDIF

        L1A_BACK (I) = '.'
        L1A_IBACK(I) = 0
        L1A_FORW (I) = '.'
        L1A_IFORW(I) = 0

        IF(L1B_NBOND.EQ.0) THEN
C         no bonds
          IF(I.EQ.NA) THEN
            L1A_FORW(I)= 'END'
            I_LAST     = I
          ENDIF
          IF(I.EQ.1) THEN
            L1A_BACK(I)  = '.'
            L1A_IBACK(I) = 0
            I_FIRST      = I
          ENDIF
          IF(I.GT.1) THEN
            L1A_BACK (I) = L1A_ANAME(I-1)
            L1A_IBACK(I) = I-1
            L1A_TYPE (I) = 'DUMMY' 
          ENDIF
          IF(I.LT.NA) THEN
            L1A_FORW (I) = L1A_ANAME(I+1)
            L1A_IFORW(I) = I+1
          ENDIF
        ENDIF

      ENDDO

      IF(L1B_NBOND.EQ.0) GO TO 300

C
C ---- definition back's atoms and last atom
C

      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        LINE='1:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF



      IFIRST    = 0
      IFIRST_NH = 0
      IFIRST_NR = 0
      ICYCLE    = 0
      I_LAST    = 0
      I_LAST_NH = 0
      I_LAST_NR = 0
      NH_NR     = 1000
      NH_NH     = 1000
      NL_NR     = 1000
      NL_NH     = 1000

      DO WHILE ( NC .GT. 1 )    

        NC_OLD = NC
        DO I=NA,1,-1

          NDI = L1A_NDIST(I)
          NCN = L1A_NEXTR(I)

          IF(NDI.GT.0.AND.NCN.EQ.1) THEN
C           now only 1 connect. for Ith atom (NCN=1)             
            DO IC=1,NDI
              IP = L1A_LENCON(IC,I)
              IF(IP.GT.0) THEN
C               remove this connect. and set back atom IP
C                                          IP --> I
                NC           = NC-1
                L1A_NEXTR(I) = 0
                L1A_BACK (I) = L1A_ANAME(IP)
                L1A_IBACK(I) = IP

                IF(IFIRST.EQ.0) THEN
C                 last atom
                  I_LAST = I
                  IFIRST = 1
                ENDIF
           
                IF(IFIRST_NH.EQ.0.AND.ICYCLE.LT.1) THEN
C                 first no H atom   
                  ASYMB = L1A_SYMB(I)
                  IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ')THEN
                    NH = L1A_IOLD(I)
                    NL = L1A_NDIST(I)-NH
C                   NL number of noH atoms, keep atom with min NL 
                    IF(NL.EQ.NL_NH) THEN
C                     with min number of H atoms
                      IF(NH.LT.NH_NH) THEN
                        I_LAST_NH = I
c                       IFIRST_NH = 1
                        NH_NH = NH
                      ENDIF
                    ELSE IF(NL.LT.NL_NH) THEN
                      I_LAST_NH = I
c                     IFIRST_NH = 1
                      NH_NH     = NH
                      NL_NH     = NL
                    ENDIF
                  ENDIF
                ENDIF
           
                IF(IFIRST_NR.EQ.0.AND.ICYCLE.LT.1) THEN
C                 first no H atom and not in the ring     
                  ASYMB = L1A_SYMB(I)
                  IF((ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ')
     *               .AND.L1A_NRING(I).LE.0) THEN
                    NH = L1A_IOLD(I)
                    NL = L1A_NDIST(I)-NH
C                   NL number of noH and no RING atoms, keep atom with min NL 
                    IF(NL.EQ.NL_NR) THEN
C                     with min number of H atoms
                      IF(NH.LT.NH_NR) THEN
                        I_LAST_NR = I
c                       IFIRST_NR = 1
                        NH_NR=NH
                      ENDIF
                    ELSE IF(NL.LT.NL_NR) THEN
                      I_LAST_NR = I
c                     IFIRST_NR = 1
                      NH_NR     = NH
                      NL_NR     = NL
                    ENDIF
                  ENDIF
                ENDIF

C               correction for back atom of Ith atom after removing 
C               current connection IP --> I
                NDIP  = L1A_NDIST(IP)
                NCNIP = L1A_NEXTR(IP)
                IF(NDIP.GT.0.AND.NCNIP.GT.0) THEN
                  ITEMP = 0
                  DO IPC=1,NDIP
                    IPP = L1A_LENCON(IPC,IP)
                    IF(IPP.GT.0.AND.IPP.EQ.I) THEN
                      ITEMP = 1
                      GO TO 100
                    ENDIF
                  ENDDO

 100              CONTINUE
                  IF(ITEMP.EQ.1) THEN
                    NC = NC-1                 
                    IF(L1A_FORW(IP).EQ.'.') THEN
                      L1A_FORW(IP)  = L1A_ANAME(I)
                      L1A_IFORW(IP) = I
                    ENDIF
                    L1A_NEXTR(IP)      = L1A_NEXTR(IP)-1
                    L1A_LENCON(IPC,IP) = 0
                  ENDIF
                ENDIF

              ENDIF
            ENDDO
          ENDIF
        ENDDO

        ICYCLE = ICYCLE + 1

            IF(LIST.EQ.'T') THEN
            WRITE(*,*) '->ICYCLE,NC:',ICYCLE,NC            
            ENDIF

      IF(ICYCLE.EQ.1) THEN 
      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        LINE='ic=1:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
      ENDIF

        IF(NC_OLD.EQ.NC) THEN
C         was not removing in this cycle 
C         it is ring. remove 1 connection 

          ITEMP=0


          IF(ITYPE_RES.EQ.5.OR.ITYPE_RES.EQ.6.OR.ITYPE_RES.EQ.7.OR.
     *       ITYPE_RES.EQ.8.OR.ITYPE_RES.EQ.3.OR.ITYPE_RES.EQ.4.OR.
     *                                      ITYPE_RES.EQ.10) THEN

          IF(LIST.EQ.'T') THEN
            WRITE(*,*) 'ITYPE_RES:',ITYPE_RES            
          ENDIF
 
C         remove if not backbone 
          DO I=1,NA
            ATOM1 = L1A_ANAME(I)
            NDI = L1A_NDIST(I)
            NCN = L1A_NEXTR(I)
            IF(NDI.GT.0.AND.NCN.EQ.2) THEN
C             Ith atom has 2 connections
C             remove one , it would be extra connection             
              DO II=1,L1A_NDIST(I)
                IF(L1A_LENCON(II,I).GT.0) THEN
                  J                = L1A_LENCON(II,I)
                  ATOM2 = L1A_ANAME(J)

                  IF(ITYPE_RES.EQ. 5.OR.ITYPE_RES.EQ.6) THEN
C                   P -> O5* - C5*  - C4* = C3* -> O3*

                    IF((ATOM1.EQ.'C4* '.AND.ATOM2.EQ.'C3* ').OR.
     *                 (ATOM2.EQ.'C4* '.AND.ATOM1.EQ.'C3* ')) GO TO 400

                  ELSE IF(ITYPE_RES.EQ. 7.OR.ITYPE_RES.EQ.8) THEN
C                   C1 -> C2 -> C3 -> C4 -> C5 -> O5

                    IF((ATOM1.EQ.'C1  '.AND.ATOM2.EQ.'C2  ').OR.
     *                 (ATOM2.EQ.'C1  '.AND.ATOM1.EQ.'C2  ')) GO TO 400
                    IF((ATOM1.EQ.'C2  '.AND.ATOM2.EQ.'C3  ').OR.
     *                 (ATOM2.EQ.'C2  '.AND.ATOM1.EQ.'C3  ')) GO TO 400
                    IF((ATOM1.EQ.'C3  '.AND.ATOM2.EQ.'C4  ').OR.
     *                 (ATOM2.EQ.'C3  '.AND.ATOM1.EQ.'C4  ')) GO TO 400
                    IF((ATOM1.EQ.'C4  '.AND.ATOM2.EQ.'C5  ').OR.
     *                 (ATOM2.EQ.'C4  '.AND.ATOM1.EQ.'C5  ')) GO TO 400
                    IF((ATOM1.EQ.'C5  '.AND.ATOM2.EQ.'O5  ').OR.
     *                 (ATOM2.EQ.'C5  '.AND.ATOM1.EQ.'O5  ')) GO TO 400

                  ELSE IF(ITYPE_RES.EQ.3.OR.ITYPE_RES.EQ.4.OR.
     *                                      ITYPE_RES.EQ.10) THEN
C                   N -> CA -> C
                    IF((ATOM1.EQ.'N   '.AND.ATOM2.EQ.'CA  ').OR.
     *                 (ATOM2.EQ.'N   '.AND.ATOM1.EQ.'CA  ')) GO TO 400

                  ENDIF

c                  L1A_LENCON(II,I) = - L1A_LENCON(II,I)
c                  L1A_NEXTR(I)     =  L1A_NEXTR(I) - 1
                  DO IJ=1,L1A_NDIST(J)
                    IF(L1A_LENCON(IJ,J).GT.0.AND.
     *                 L1A_LENCON(IJ,J).EQ.I     ) THEN
                      CALL CHECK_RING_FOR_TREE(NA,IRING,I,J,L1A_NDIST
     *                  ,L1A_NEXTR,L1A_LENCON,L2A_ICR,L2A_IBACK
     *                  ,L2B_I1ATM,L2B_I2ATM,MAX1BRN,MAX1ATM,MAX1BND)  
                      IF(IRING.GT.0) THEN
                        L1A_LENCON(II,I) = - L1A_LENCON(II,I)
                        L1A_NEXTR(I)     =  L1A_NEXTR(I) - 1
                        JJ               = L1A_LENCON(IJ,J)
                        L1A_LENCON(IJ,J) = - L1A_LENCON(IJ,J)
                        L1A_NEXTR(J)     = L1A_NEXTR(J)-1
                        ITEMP = 4
                        NC    = NC-2

                        IF(LIST.EQ.'T') THEN
                          WRITE(*,*) 'ITEMP_b,I,J:',ITEMP,I,J,NC            
                        ENDIF

                        GO TO 200
                      ENDIF
                    ENDIF
                  ENDDO

                ENDIF
 400            CONTINUE
              ENDDO                 
            ENDIF
          ENDDO
          ENDIF
C  
          DO I=1,NA
            NDI = L1A_NDIST(I)
            NCN = L1A_NEXTR(I)
            IF(NDI.GT.0.AND.NCN.EQ.2) THEN
C             Ith atom has 2 connections
C             remove one , it would be extra connection             
              DO II=1,L1A_NDIST(I)
                IF(L1A_LENCON(II,I).GT.0) THEN
                  J                = L1A_LENCON(II,I)
c                  L1A_LENCON(II,I) = - L1A_LENCON(II,I)
c                  L1A_NEXTR(I)     =  L1A_NEXTR(I) - 1
                  DO IJ=1,L1A_NDIST(J)
                    IF(L1A_LENCON(IJ,J).GT.0.AND.
     *                 L1A_LENCON(IJ,J).EQ.I     ) THEN
                      CALL CHECK_RING_FOR_TREE(NA,IRING,I,J,L1A_NDIST
     *                  ,L1A_NEXTR,L1A_LENCON,L2A_ICR,L2A_IBACK
     *                  ,L2B_I1ATM,L2B_I2ATM,MAX1BRN,MAX1ATM,MAX1BND)  
                      IF(IRING.GT.0) THEN
                        L1A_LENCON(II,I) = - L1A_LENCON(II,I)
                        L1A_NEXTR(I)     =  L1A_NEXTR(I) - 1
                        JJ               = L1A_LENCON(IJ,J)
                        L1A_LENCON(IJ,J) = - L1A_LENCON(IJ,J)
                        L1A_NEXTR(J)     = L1A_NEXTR(J)-1
                        ITEMP = 3
                        NC    = NC-2

                        IF(LIST.EQ.'T') THEN
                          WRITE(*,*) 'ITEMP_r,I,J:',ITEMP,I,J,NC
                        ENDIF

                        GO TO 200
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF
              ENDDO                 
            ENDIF
          ENDDO
C        
          DO I=1,NA
            NDI = L1A_NDIST(I)
            NCN = L1A_NEXTR(I)
            IF(NDI.GT.0.AND.NCN.EQ.2) THEN
              DO II=1,L1A_NDIST(I)
                IF(L1A_LENCON(II,I).GT.0) THEN
                  J                = L1A_LENCON(II,I)
c                  L1A_LENCON(II,I) = - L1A_LENCON(II,I)
c                  L1A_NEXTR(I)     =  L1A_NEXTR(I)- 1
                  DO IJ=1,L1A_NDIST(J)
                    IF(L1A_LENCON(IJ,J).GT.0.AND.
     *                 L1A_LENCON(IJ,J).EQ.I     ) THEN
                      L1A_LENCON(II,I) = - L1A_LENCON(II,I)
                      L1A_NEXTR(I)     =  L1A_NEXTR(I)- 1
                      JJ               = L1A_LENCON(IJ,J)
                      L1A_LENCON(IJ,J) =-L1A_LENCON(IJ,J)
                      L1A_NEXTR(J)     = L1A_NEXTR(J)-1
                      ITEMP = 2
                      NC    = NC-2

                      IF(LIST.EQ.'T') THEN
                        WRITE(*,*) 'ITEMP1,I,J:',ITEMP,I,J,NC            
                      ENDIF

                      GO TO 200
                    ENDIF
                  ENDDO
                ENDIF
              ENDDO
            ENDIF
          ENDDO                     
C        
          DO I=1,NA
            NDI = L1A_NDIST(I)
            NCN = L1A_NEXTR(I)
            IF(NDI.GT.0.AND.NCN.GT.2) THEN
              DO II=1,L1A_NDIST(I)
                IF(L1A_LENCON(II,I).GT.0) THEN
                  J                = L1A_LENCON(II,I)
c                  L1A_LENCON(II,I) = - L1A_LENCON(II,I)
c                  L1A_NEXTR(I)     = L1A_NEXTR(I) - 1
                  DO IJ=1,L1A_NDIST(J)
                    IF(L1A_LENCON(IJ,J).GT.0.AND.
     *                 L1A_LENCON(IJ,J).EQ.I     ) THEN
                      L1A_LENCON(II,I) = - L1A_LENCON(II,I)
                      L1A_NEXTR(I)     = L1A_NEXTR(I) - 1
                      JJ               = L1A_LENCON(IJ,J)
                      L1A_LENCON(IJ,J) =-L1A_LENCON(IJ,J)
                      L1A_NEXTR(J)     = L1A_NEXTR(J)-1
                      ITEMP = 1
                      NC    = NC-2

                      IF(LIST.EQ.'T') THEN
                        WRITE(*,*) 'ITEMP1,I,J:',ITEMP,I,J,NC            
                      ENDIF

                      GO TO 200
                    ENDIF
                  ENDDO
                ENDIF
              ENDDO
            ENDIF
          ENDDO                     

 200      CONTINUE

C         if ITEMP=0 not any removing, ???   

          IF(LIST.EQ.'T') THEN
            IF(ITEMP.LE.0) THEN
              WRITE(*,*) '>ITEMP NC:',ITEMP,NC            

        NA     = L1A_NATOM
        LINE='ic=1:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO

            ENDIF
          ENDIF

          IF(ITEMP.LE.0) THEN
            CALL MSGERR(MDOC,' ERROR: can not create tree structure')
            IERR = 1
            RETURN
          ENDIF
 
        ENDIF

      ENDDO


      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        LINE='2:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF




C
C ---- end definition back's atoms and last atom
C
      
      IF(LIST.EQ.'T') THEN
      write(LINE,*) ' last:',i_last,i_last_nh,i_last_nr,nh_nh,nh_nr
      CALL MSGDOC(MDOC,LINE)
      ENDIF
                       
      IF(I_LAST_NR.GT.0) THEN
C       last atom is no RING and no H atom
        I_LAST = I_LAST_NR
      ELSE IF(I_LAST_NH.GT.0) THEN
C       last atom is no H atom
        I_LAST = I_LAST_NH
      ENDIF

      L1A_FORW(I_LAST)   = 'END'
      L1A_IFORW(I_LAST)  = 0

      IF(NA.GT.1) THEN

C       define first atom and forward's atoms
        I       = I_LAST
        I_FIRST = I

        DO WHILE ( I.GT.0 )
          IB = L1A_IBACK(I)
          IF(IB.GT.0) THEN
            L1A_FORW(IB)  = L1A_ANAME(I)
            L1A_IFORW(IB) = I
            I_FIRST       = IB
          ENDIF
          I = IB
        ENDDO

        L1A_IBACK(I_FIRST) = 0
        L1A_BACK(I_FIRST)  = '.'

C       change direction fist --> last to first <-- last
        I       = I_LAST
        I_LAST  = I_FIRST
        I_FIRST = I

        DO WHILE ( I.GT.0 )
          IB = L1A_IBACK(I)

          ASYMB        = L1A_FORW(I) 
          L1A_FORW(I)  = L1A_BACK(I) 
          L1A_BACK(I)  = ASYMB
          IT           = L1A_IFORW(I) 
          L1A_IFORW(I) = L1A_IBACK(I) 
          L1A_IBACK(I) = IT

          IF(I.EQ.I_FIRST) THEN
            L1A_IBACK(I) = 0
            L1A_BACK(I)  = '.'
          ENDIF
          IF(I.EQ.I_LAST) THEN
            L1A_IFORW(I) = 0
            L1A_FORW(I)  = 'END'
          ENDIF

          I = IB

        ENDDO

C       define first atom again


        I       = I_LAST
        I_FIRST = I

        DO WHILE ( I.GT.0 )
          IB = L1A_IBACK(I)
          IF(IB.GT.0) THEN
            I_FIRST       = IB
          ENDIF
          I = IB
        ENDDO

        L1A_IBACK(I_FIRST) = 0
        L1A_BACK (I_FIRST) = '.'

C       define last atom again

        IMAX = 0
        LMAX = 0

        DO IA=1,NA
          
          IF(IA.NE.I_FIRST) THEN
            LEN = 0  
            I   = IA
            DO WHILE ( I.GT.0 )
              IB = L1A_IBACK(I)
              IF(IB.GT.0) THEN
                LEN = LEN+1
              ENDIF
              I = IB
            ENDDO

            IF(LEN.GE.LMAX.AND.LEN.GT.0) THEN
              IF(LEN.EQ.LMAX) THEN
                ASYMB = L1A_SYMB(IA)
                IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ')THEN
                  IMAX = IA
                ENDIF
              ELSE
                IMAX = IA
                LMAX = LEN
              ENDIF
            ENDIF

          ENDIF

        ENDDO

        I_LAST = IMAX

C       define forward's atoms again

        DO I=1,NA
          L1A_FORW (I) = '.'
          L1A_IFORW(I) = 0
        ENDDO

        L1A_FORW(I_LAST)   = 'END'
        L1A_IFORW(I_LAST)  = 0

C       main way

        I       = I_LAST
        DO WHILE ( I.GT.0 )
          IB = L1A_IBACK(I)
          IF(IB.GT.0) THEN
            L1A_FORW(IB)  = L1A_ANAME(I)
            L1A_IFORW(IB) = I
          ENDIF
          I = IB
        ENDDO

C       side way for noH-atoms

        DO IA=1,NA
          IF(IA.NE.I_FIRST) THEN
            ASYMB = L1A_SYMB(IA)
            IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ')THEN
              I = IA
              DO WHILE ( I.GT.0 )
                IB = L1A_IBACK(I)
                IF(IB.GT.0) THEN
                IF(L1A_IFORW(IB).EQ.0) THEN
                  L1A_FORW(IB)  = L1A_ANAME(I)
                  L1A_IFORW(IB) = I
                  IF(IB.EQ.I_LAST) THEN
                    I_LAST             = I
                    L1A_FORW(I_LAST)   = 'END'
                    L1A_IFORW(I_LAST)  = 0
                  ENDIF
                ENDIF
                ENDIF
                I = IB
              ENDDO
            ENDIF
          ENDIF
        ENDDO

C       side way for H-atoms

        DO IA=1,NA
          IF(IA.NE.I_FIRST) THEN
            ASYMB = L1A_SYMB(IA)
            IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ')THEN
              I = IA
              DO WHILE ( I.GT.0 )
                IB = L1A_IBACK(I)
                IF(IB.GT.0.AND.IB.NE.I_LAST) THEN
                IF(L1A_IFORW(IB).EQ.0) THEN
                  L1A_FORW(IB)  = L1A_ANAME(I)
                  L1A_IFORW(IB) = I
C                  IF(IB.EQ.I_LAST) THEN
C                    I_LAST             = I
C                    L1A_FORW(I_LAST)   = 'END'
C                    L1A_IFORW(I_LAST)  = 0
C                  ENDIF
                ENDIF
                ENDIF
                I = IB
              ENDDO
            ENDIF
          ENDIF
        ENDDO

      ELSE

        I_FIRST            = I_LAST
        L1A_IBACK(I_FIRST) = 0
        L1A_BACK(I_FIRST)  = '.'

      ENDIF

      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        LINE='3:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF



C     check and correct new first atom

      N = L1A_NDIST(I_FIRST)
      IF(N.GT.0) THEN
        DO I=1,N
          J = L1A_LENCON(I,I_FIRST)
          IF(J.GT.0) THEN
          IF(L1A_IBACK(J).NE.I_FIRST) THEN
            IF(L1A_IFORW(J).LE.0) THEN
              L1A_IFORW(J) = L1A_IBACK(J)
              L1A_FORW(J)  = L1A_BACK(J)
            ENDIF
            IF(L1A_IFORW(J).EQ.I_FIRST) THEN
              L1A_IFORW(J) = 0
              L1A_FORW(J)  = '.'
            ENDIF
            L1A_IBACK(J) = I_FIRST
            L1A_BACK(J)  = L1A_ANAME(I_FIRST)
          ENDIF
          ENDIF
        ENDDO
      ENDIF

      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        LINE='4:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF


C     create list of  extra connections ( i.e L1A_LENCON(J,I) < 0 )

      L1N_NCONN = 0  
      DO I=1,NA
        IF(L1A_NDIST(I).GT.0) THEN
          DO J=1,L1A_NDIST(I)
            JJ = L1A_LENCON(J,I)
            IF(JJ.LT.0) THEN
            IF(ABS(JJ).GT.I) THEN
              IF(L1N_NCONN.GE.MAX1CONN) THEN
                WRITE(LINE,'(3A,I6)')
     *      ' ERROR: number of extra connections of new monomer'
     *          ,L1L_MNAME,' >',MAX1CONN
                CALL MSGERR(MDOC,LINE)
                CALL MSGERR(MDOC,
     *  '          Change parameter MAX1CONN in "lib_com.fh"')
                IERR=1
                RETURN
              ENDIF
              L1N_NCONN            = L1N_NCONN + 1  
              L1N_1ATM (L1N_NCONN) = L1A_ANAME(I)
              L1N_2ATM (L1N_NCONN) = L1A_ANAME(-JJ)
              L1N_I1ATM(L1N_NCONN) = I
              L1N_I2ATM(L1N_NCONN) =-JJ
              L1N_TYPE (L1N_NCONN) = '.'
            ENDIF
            ENDIF
          ENDDO
        ENDIF
      ENDDO       

C     set "dummy" connection with last atom for all atoms without
C     any connection

      J = I_LAST
      IFIRST = 0
      DO I=1,NA
        IF(L1A_IBACK(I).EQ.0.AND.L1A_IFORW(I).EQ.0.AND.I.NE.J) THEN
          L1A_IBACK(I) = J
          L1A_TYPE (I) = 'DUMMY'
          L1A_BACK (I) = L1A_ANAME(J)
          IF(IFIRST.EQ.0) THEN
            L1A_IFORW(I) = 0
            L1A_FORW (I) = '.'
            IFIRST = 1 
          ELSE
            L1A_IFORW(J) = I
            L1A_FORW (J) = L1A_ANAME(I)
            L1A_IFORW(I) = 0
            L1A_FORW (I) = '.'
          ENDIF
          J            = I
        ENDIF
      ENDDO


C     set back atom for atom which has not it ( ? )

      DO I=1,NA
        IF(L1A_IBACK(I).EQ.0.AND.I.NE.I_FIRST) THEN
          L1A_IBACK(I)= I_FIRST
          L1A_BACK(I) = L1A_ANAME(I_FIRST)
          L1A_TYPE(I) = 'DUMMY'
        ENDIF
      ENDDO

 300  CONTINUE

      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        LINE='5:aname,ib,if,ndist,next,lencon(1..12)'
        CALL MSGDOC(MDOC,LINE)
        WRITE(*,*) '  NC=',NC
        DO    IA=1,NA
          write(line,
     *    '(i2,1x,a4,4i4,'';'',12i4,'';'')') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia)
     *    ,L1A_NDIST(IA),l1a_nextr(ia),(l1a_lencon(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF

      L1A_ISTART  = I_FIRST
      L1A_IFINISH = I_LAST
C ---     
C     restore L1A_LENCON(1,IA)

      DO IA=1,NA
        L1A_LENCON(1,IA) = L1A_IOLD(IA)
        L1A_IOLD(IA)     = 0
      ENDDO

      RETURN
      END

      SUBROUTINE CHECK_RING_FOR_TREE(NA,IRING,LA1,LA2,NDIST,NEXTR
     *              ,LENCON,IAC,IPN,I1,I2,MAX1BRN,MAX1ATM,MAX1BND)
C ------------------------------------------------------------------
      INTEGER NA,LA1,LA2,IRING,MAX1BRN,MAX1ATM,MAX1BND
      INTEGER NDIST(*),NEXTR(*),LENCON(MAX1BRN,MAX1ATM)
      INTEGER IAC(*),IPN(*),I1(*),I2(*)
C ------------------------------------------------------------------
      IRING = 0
      N     = 0
      DO I=1,NA  
        IF(NDIST(I).GT.0.AND.NEXTR(I).GT.0) THEN
          N      = N + 1
          IAC(N) = N 
          IPN(N) = I 
        ENDIF
      ENDDO
      IF(N.LE.4) RETURN
      NBOND = 0
      DO I=1,N
        DO J=1,NDIST(IPN(I)) 
          JJ = LENCON(J,IPN(I))
          IF(JJ.GT.0) THEN
            DO K=1,N
              IF((IPN(I).NE.LA1.AND.IPN(I).NE.LA2).OR.
     *           (JJ    .NE.LA1.AND.JJ    .NE.LA2)    ) THEN
                IF(IPN(K).EQ.JJ.AND.IPN(K).GT.I) THEN
                  NBOND = NBOND + 1
                  I1(NBOND) = I
                  I2(NBOND) = K
                ENDIF
              ENDIF
            ENDDO
          ENDIF
        ENDDO  
      ENDDO
      IF(NBOND.LE.2) RETURN
C -----
      DO IA=1,N
        DO JA=1,N
          J = IAC(JA) 
          DO IB=1,NBOND
            IK = 0
            IF(I1(IB).EQ.J.AND.I2(IB).NE.J) THEN
              IK = I2(IB)
            ELSE IF(I2(IB).EQ.J.AND.I1(IB).NE.J) THEN
              IK = I1(IB)
            ENDIF
            IF(IK.GT.0) THEN
              DO KA=1,N
                IF(IAC(KA).EQ.IK) IAC(KA) = J  
              ENDDO
              DO JB=1,NBOND
                IF(I1(JB).EQ.IK) I1(JB) = J
                IF(I2(JB).EQ.IK) I2(JB) = J
              ENDDO
            ENDIF    
          ENDDO
        ENDDO
C --
        NPIECE = 1
        DO J=2,N
          DO K=1,J-1
            IF(IAC(J).EQ.IAC(K)) GO TO 300
          ENDDO
          NPIECE = NPIECE + 1 
 300      CONTINUE
        ENDDO

        IF(NPIECE.LE.1) THEN
          IRING = 1
          GO TO 200
        ENDIF
C -- 
      ENDDO
 200  CONTINUE
C -------
      RETURN
      END

      SUBROUTINE PRECHECK_L1_MON_DESCRIPTION(MDOC,LIST,IERR)
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,MON*8,LIST*1,TREE*1
C -----------------------------------------------
      IERR = 0
      MON  = L1L_MNAME
      NA   = L1A_NATOM
      IF(NA.LE.1) RETURN
      CALL COPYL2(MDOC,IERR)
C --
      DO I=1,L2A_NATOM
        L1A_ICR(I) = I  
        L2A_ICR(I) = I  
      ENDDO
      CALL SET_NUM_L1_GM(MDOC,IERR)
      CALL SET_NUM_L2_GM(MDOC,IERR)

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,' -- PRECHECK_L1_MON_DESCRIPTION --- ')
        WRITE(LINE,*) ' --- NA:',L1A_NATOM
        CALL MSGDOC(MDOC,LINE)
        IF(NA.GT.0) THEN
        DO IA=1,NA
          WRITE(LINE,*) IA,' ',L1A_ANAME(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF
        WRITE(LINE,*) ' --- NB:',L1B_NBOND,L1C_NCHIR 
        CALL MSGDOC(MDOC,LINE)
        IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
          WRITE(LINE,*) IB,' ',L1B_I1ATM(IB),L1B_I2ATM(IB)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF
      ENDIF
C -----
      DO IA=1,NA
        DO JA=1,NA
          J = L2A_ICR(JA) 
          DO IB=1,L2B_NBOND
            IK = 0
            IF(L2B_I1ATM(IB).EQ.J.AND.L2B_I2ATM(IB).NE.J) THEN
              IK = L2B_I2ATM(IB)
            ELSE IF(L2B_I2ATM(IB).EQ.J.AND.L2B_I1ATM(IB).NE.J) THEN
              IK = L2B_I1ATM(IB)
            ENDIF
            IF(IK.GT.0) THEN
              DO KA=1,NA
                IF(L2A_ICR(KA).EQ.IK) L2A_ICR(KA) = J  
              ENDDO
              DO JB=1,L2B_NBOND
                IF(L2B_I1ATM(JB).EQ.IK) L2B_I1ATM(JB) = J
                IF(L2B_I2ATM(JB).EQ.IK) L2B_I2ATM(JB) = J
              ENDDO
            ENDIF    
          ENDDO
        ENDDO
C --
        NPIECE = 1
        DO J=2,NA
          DO K=1,J-1
            IF(L2A_ICR(J).EQ.L2A_ICR(K)) GO TO 100
          ENDDO
          NPIECE = NPIECE + 1 
 100      CONTINUE
        ENDDO
        IF(NPIECE.LE.1) GO TO 200
C -- 
      ENDDO

C -----
C     maybe there is "dummy' connection ?
      TREE = 'N'
      DO I=1,NA
        IF(L2A_BACK(I).NE.'.') TREE = 'Y'
      ENDDO
C ---
      IF(TREE.EQ.'Y'.AND.L1L_PRSNT.NE.'M') THEN
        DO I=1,L2A_NATOM
          L2A_ICR(I) = I  
        ENDDO

        CALL SET_NUM_L2_GM(MDOC,IERR)

        DO I=1,NA
          IF(L2A_TYPE(I).EQ.'DUMMY'.AND.L2A_IBACK(I).GT.0) THEN
            IF(L2B_NBOND.GE.MAX1BND) THEN
              WRITE(LINE
     *        ,'('' ERROR: number of bonds of monomer >'',I6)') 
     *        MAX1BND
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC
     *        ,'         Change parameter MAX1BND in "lib_com.fh"')
              IERR=1
              RETURN
            ENDIF
            II          = L2A_IBACK(I)
            L2B_NBOND   = L2B_NBOND+1
            L           = L2B_NBOND
            L2B_1ATM (L)= L2A_ANAME(II)
            L2B_2ATM (L)= L2A_ANAME(I)
            L2B_I1ATM(L)= II
            L2B_I2ATM(L)= I
          ENDIF
        ENDDO

C -----
        DO IA=1,NA
          DO JA=1,NA
            J = L2A_ICR(JA) 
            DO IB=1,L2B_NBOND
              IK = 0
              IF(L2B_I1ATM(IB).EQ.J.AND.L2B_I2ATM(IB).NE.J) THEN
                IK = L2B_I2ATM(IB)
              ELSE IF(L2B_I2ATM(IB).EQ.J.AND.L2B_I1ATM(IB).NE.J) THEN
                IK = L2B_I1ATM(IB)
              ENDIF
              IF(IK.GT.0) THEN
                DO KA=1,NA
                  IF(L2A_ICR(KA).EQ.IK) L2A_ICR(KA) = J  
                ENDDO
                DO JB=1,L2B_NBOND
                  IF(L2B_I1ATM(JB).EQ.IK) L2B_I1ATM(JB) = J
                  IF(L2B_I2ATM(JB).EQ.IK) L2B_I2ATM(JB) = J
                ENDDO
              ENDIF    
            ENDDO
          ENDDO
C --
          NPIECE = 1
          DO J=2,NA
            DO K=1,J-1
              IF(L2A_ICR(J).EQ.L2A_ICR(K)) GO TO 300
            ENDDO
            NPIECE = NPIECE + 1 
 300        CONTINUE
          ENDDO
          IF(NPIECE.LE.1) GO TO 200
C -- 
        ENDDO

      ENDIF

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '---- I,NPIECE:',I,NPIECE,L1C_NCHIR 
        CALL MSGDOC(MDOC,LINE)         
        DO K=1,NA
          WRITE(LINE,*) '--',L2A_ANAME(K),K,L2A_ICR(K) 
          CALL MSGDOC(MDOC,LINE)         
        ENDDO
        CALL MSGDOC(MDOC,'-----------------')         
      ENDIF 

      NPIECE1 = NPIECE - 1
      WRITE(LINE,
     *'('' WARNING: monomer:'',A,'' not completely connected.'')') MON
      CALL MSGERR(MDOC,LINE)         
      WRITE(LINE,'(A,I4,a)')
     *   '          program will add ',NPIECE1
     *    ,' additional connections in tree structure'
      CALL MSGERR(MDOC,LINE)         

      IERR = 10

 200  CONTINUE
      JERR = 0
      IF(L1N_NCONN.GT.0) THEN
        DO I=1,L1N_NCONN
          IF(L1N_I1ATM(I).EQ.0) JERR = 1
          IF(L1N_I2ATM(I).EQ.0) JERR = 1
        ENDDO
      ENDIF
      IF(L1B_NBOND.GT.0) THEN 
        DO I=1,L1B_NBOND
          IF(L1B_I1ATM(I).EQ.0) JERR = 1 
          IF(L1B_I2ATM(I).EQ.0) JERR = 1
        ENDDO
      ENDIF

      IERR = IERR + JERR*100

      CALL COMPRESS_L1_GM(MDOC,KERR)
C -------
      RETURN
      END

C ******
      SUBROUTINE RD_MD_LINK_LIB(MDOC,IERR,IEND)
C -------------------------------------------------------
C -P- 
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,IEND
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---
      COMMON/COM_CRD_CIF/ IEND_CIF      
C ---
C -----------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,IUN,M,IFLAG_MON,IFLAG_MOD,IFLAG_LINK,I
      INTEGER*4 NLIB_LIM
      CHARACTER DATA*80,ITEM*80,BLOCK*8,BLOCK_OLD*8
      CHARACTER LINE*256,MOD*1,LIB*256
C ---
      INCLUDE 'crd_com.fh'
C ----------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------
C
C     CALL INIT_CNT
C
      MOD      = 'N'
      LB_PASS  = 0
      NLIB_LIM = 1

 200  CONTINUE

      LB_PASS    = LB_PASS + 1
      IERR       = 0
      IEND       = 0
      IFLAG_MON  = 0
      IFLAG_MOD  = 0
      IFLAG_LINK = 0
C ------
C     open file of mon_library
C     IUN = 10
      IUN = CRI_IUN
      M   = 99
      IF(LB_PASS.LE.NLIB_LIM) THEN
        LIB = LMI_FILE(LB_PASS)
        CALL OPENFR(IUN,M,LMI_PATH,LIB,LMI_EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL LENSTR_BL(LIB,LEN) 
          IF(LEN.GT.50) LEN=50
          IF(LEN.LE.0) THEN
            LIB = '?'
            LEN = 1
          ENDIF
          WRITE(LINE,*) ' ERROR: can"t open (lbl):',LIB(1:LEN)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ELSE
        CALL OPENFR(IUN,M,LMI2_PATH,LMI2_FILE,LMI2_EXT,IERR)
        IF(IERR.NE.0) THEN
          LIB = LMI2_FILE
          CALL LENSTR_BL(LMI2_FILE,LEN) 
          IF(LEN.GT.50) LEN=50
          IF(LEN.LE.0) THEN
            LIB = '?'
            LEN = 1
          ENDIF
          WRITE(LINE,*) ' ERROR: can"t open (lbl2):',LIB(1:LEN)
          CALL MSGERR(MDOC,LINE)
          RETURN
        ENDIF
      ENDIF
C      CALL OPENFR(IUN,M,LMI_PATH,LMI_FILE,LMI_EXT,IERR)
C      IF(IERR.NE.0) THEN
C        CALL MSGERR(MDOC,' ERROR: can''t open "mon_lib.cif" .')
C        RETURN
C      ENDIF
      LMI_IUN   = IUN
      IEND      = -1
      BLOCK_OLD = '   '
C -------
      IF(IEND.EQ.-1) THEN
        REWIND IUN
        IEND_CIF = -1
        IEND     = 0
      ENDIF

  300 CONTINUE   
      
      CALL GETCIF_INFO(IUN,MDOC,IERR,IEND_CIF)
      IF(IERR.NE.0.OR.(IEND_CIF.NE.0.AND.IEND_CIF.NE.-2)) THEN

        IEND=1
        GO TO 400
C        CLOSE(IUN)
C        LMI_IUN=0
C        RETURN
      ENDIF

      IF(IEND_CIF.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment
C   
        CALL LENSTR_BL(DT_CIF(1),LEND) 
        DATA = DT_CIF(1)(1:LEND)
        GO TO 300
      ENDIF
      
      CALL LENSTR_BL(BLK_CIF,LENB) 
      CALL LENSTR_BL(ITL_DCMP,LDCMP)

C -- !!  BLK_CIF(1:10) = 'data_comp_XXX
C      LBB = 10
C      LS  = LBB+1
C      LF  = LBB+3

      LS  = LDCMP + 1 
      LF  = LENB

      CALL LENSTR_BL(DT_CIF(1),LEND) 
      DATA = DT_CIF(1)(1:LEND)

      IF(N_CIF.EQ.0) THEN

        CALL LENSTR_BL(ITL_DCMP,LDCM) 

C        IF(LENB.GE.LS.AND.LENB.LE.LF.AND.
C     *            BLK_CIF(1:LBB).EQ.'data_comp_') THEN
        IF(BLK_CIF(1:LDCM).EQ.ITL_DCMP(1:LDCM)) THEN

C          IF(MOD.EQ.'N'.AND.IFLAG_MOD.EQ.1.AND. 
C     *                      IFLAG_LINK.EQ.1) GO TO 400 

          LB = LENB
c          IF(LB.GT.13) LB = 13
          BLOCK = BLK_CIF(LS:LB)
c          IF(LB.LT.LF    ) BLOCK(3:3) = ' '
c          IF(LB.LT.(LF-1)) BLOCK(2:2) = ' '

          IF(BLOCK.NE.BLOCK_OLD) THEN
            IF(LML_NMON.LE.0) THEN
              CALL MSGERR(MDOC
     *        ,' ERROR: number of monomers in library = 0')
              IERR=1
              CLOSE(IUN,ERR=440)
 440          CONTINUE
              LMI_IUN=0
              RETURN
            ENDIF
            DO L=1,LML_NMON
              IF(BLOCK.EQ.LML_MNAME(L)) THEN
                BLK_FLAG=LML_FUSE(L)
                GO TO 100
              ENDIF
            ENDDO
            BLK_FLAG='N'

  100       CONTINUE
            BLOCK_OLD=BLOCK
          ENDIF
        ENDIF
        GO TO 300
      ENDIF

      CALL LENSTR_BL(DT_CIF(1),LEND) 
      DATA = DT_CIF(1)(1:LEND)

      DO I=1,N_CIF


        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IDATA = IDT_CIF(I)
        FDATA = FDT_CIF(I)

c       IF(ITEM(1:16).EQ.'_chem_comp_atom.') IFLAG_MON = 1
c       IF(ITEM(1:15).EQ.'_chem_mod_atom.')  IFLAG_MOD = 1
c       IF(ITEM(1:16).EQ.'_chem_link_bond.') IFLAG_LINK = 1
        CALL LENSTR_BL(ITL_CMPA,LCMA)
        CALL LENSTR_BL(ITL_MODA,LMDA)
        CALL LENSTR_BL(ITL_LNKB,LLNB)
        IF(ITEM(1:LCMA).EQ.ITL_CMPA(1:LCMA)) IFLAG_MON  = 1
        IF(ITEM(1:LMDA).EQ.ITL_MODA(1:LMDA)) IFLAG_MOD  = 1
        IF(ITEM(1:LLNB).EQ.ITL_LNKB(1:LLNB)) IFLAG_LINK = 1


C       DATA ITL_CMP       /'_chem_comp.                             '/
C       DATA ITL_MOD       /'_chem_mod.                              '/
C       DATA ITL_LNK       /'_chem_link.                             '/
        CALL LENSTR_BL(ITL_CMP,LCM)
        CALL LENSTR_BL(ITL_MOD,LMD)
        CALL LENSTR_BL(ITL_LNK,LLN)

        IF(BLK_CIF(1:7) .EQ.'global_') THEN         

        ELSE IF(ITEM(1:LCM-1).EQ.ITL_CMP(1:LCM-1)) THEN


C          IF(MOD.EQ.'N'.AND.IFLAG_MOD.EQ.1.AND. 
C     *                      IFLAG_LINK.EQ.1) GO TO 400 
          
C          IF(MOD.NE.'N') THEN
        
C            CALL PUT_MNLIB(MDOC,I,BLK_CIF,LENB,ITEM,LENI
C     *      ,DATA,IDATA,FDATA,LEND,IERR)

c           IF(IERR.NE.0) THEN
c             CLOSE(IUN)
c             LMI_IUN=0
c             RETURN
c           ENDIF

C          ENDIF 

        ELSE IF(ITEM(1:LMD-1).EQ.ITL_MOD(1:LMD-1)) THEN

C          IF(MOD.EQ.'M'.AND.IFLAG_MON.EQ.1) GO TO 400 

          IF(MOD.NE.'M') THEN
            CALL PUT_MDLIB(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *      ,DATA,IDATA,FDATA,LEND,IERR)

            IF(IERR.NE.0) THEN
              CLOSE(IUN,ERR=430)
 430          CONTINUE
              LMI_IUN=0
              RETURN
            ENDIF

          ENDIF

        ELSE IF(ITEM(1:LLN-1).EQ.ITL_LNK(1:LLN-1)) THEN

C          IF(MOD.EQ.'M'.AND.IFLAG_MON.EQ.1) GO TO 400 

          IF(MOD.NE.'M') THEN
            CALL PUT_LNLIB(MDOC,I,BLK_CIF,LENB,ITEM,LENI
     *      ,DATA,IDATA,FDATA,LEND,IERR)

            IF(IERR.NE.0) THEN
              CLOSE(IUN,ERR=420)
 420          CONTINUE
              LMI_IUN=0
              RETURN
            ENDIF

          ENDIF

        ENDIF

      ENDDO
      GO TO 300
C -----------------------------------
 400  CONTINUE
      CLOSE(IUN,ERR=410)
 410  CONTINUE
      LMI_IUN=0

      IF(LB_PASS.EQ.NLIB_LIM) THEN
        CALL LENSTR_BL(LMI2_FILE,LEN)
        IF(LEN.GT.0.AND.LMI2_FILE(1:1).NE.','.AND.
     *    LMI2_FILE(1:1).NE.' ') THEN
          GO TO 200
        ENDIF
      ELSE IF(LB_PASS.LT.NLIB_LIM) THEN
        GO TO 200
      ENDIF
C ----
      LB_PASS = 0
      RETURN
      END     

C ******
      SUBROUTINE CP_MLIB(MDOC,MON,IERR)
C -----------------------------------------------
C -P- CP_MLIB - copies monomer's information from library to special
C -P-           commons for one current monomer /L1M_LIST/,/L1M_ATOM/,... 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,MON2*8,MON3*8,MOD*8,MOD1*8,MOD2*8
C ---
      INCLUDE 'lib_com.fh'

C ******
C ---
      CHARACTER LINE*256
C -----------------------------------
      IERR = 0
      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of monomers in library = 0')
        IERR=1
        RETURN
      ENDIF

      MOD  = ' '
      MOD1 = ' '
      MOD2 = ' '
      LDR = 0 

      DO   L=1,LML_NMON
   
        IF(MON.EQ.LML_MNAME(L).AND.LML_FUSE(L).NE.'N'.AND.
     *                             LML_FUSE(L).NE.'R'     ) THEN
          MON2 = MON
          MOD  = ' '
          GO TO 100
        ENDIF
      ENDDO

      MON2 = MON

      IF(LMS_NSYN.GT.0) THEN
        DO LL=1,LMS_NSYN
          IF(LMS_AMNAME(LL).EQ.MON) THEN
            MON2  = LMS_MNAME(LL)
            DO L=1,LML_NMON
              IF(MON2.EQ.LML_MNAME(L).AND.LML_FUSE(L).NE.'N'.AND.
     *                                    LML_FUSE(L).NE.'R'     ) THEN
                MON  = MON2
                MOD  = LMS_MOD(LL)
                GO TO 100
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

      MON = MON2

      IF(LDR_NDER.GT.0) THEN
        DO LL=1,LDR_NDER
          IF(LDR_MNAME(LL).EQ.MON) THEN
            MON2 = LDR_SMNAME(LL)
            DO L=1,LML_NMON
              IF(MON2.EQ.LML_MNAME(L).AND.LML_FUSE(L).NE.'N'.AND.
     *                                    LML_FUSE(L).NE.'R'     ) THEN
                MOD1 = LDR_MOD(LL)
                LDR  = LL
                GO TO 100
              ENDIF
            ENDDO
            MON3 = MON2
            DO LLL=1,LDR_NDER
              IF(LDR_MNAME(LLL).EQ.MON3) THEN
                MON2  = LDR_SMNAME(LLL)
                DO L=1,LML_NMON
                  IF(MON2.EQ.LML_MNAME(L)) THEN
                    MOD2 = LDR_MOD(LL)
                    LDR  = LLL
                    GO TO 100
                  ENDIF
                ENDDO
              ENDIF
            ENDDO

          ENDIF
        ENDDO
      ENDIF

  
      WRITE(LINE
     *  ,'('' ERR: monomer '',A8,'' not found in library..'')') MON 
      CALL MSGDOC(MDOC,LINE)
      IERR = 2
      RETURN

  100 CONTINUE

      L1L_NATM  = LML_NATM  (L)
      L1L_NHATM = LML_NHATM (L)
      L1L_MNAME = LML_MNAME (L) 
      L1L_MNAME2= LML_MNAME2(L) 

      MON2      = L1L_MNAME

      L1L_NAME  = LML_NAME (L) 
      IF(LDR.GT.0) L1L_NAME  = LDR_NAME(LDR) 
      L1L_FORM  = LML_FORM (L) 
      L1L_CODE1 = LML_CODE1(L)
      L1L_TYPE  = LML_TYPE (L)
      IF(LDR.GT.0) L1L_TYPE  = LDR_TYPE(LDR) 

      L1L_MODE  = LML_MODE (L)

      L1L_FUSE  = LML_FUSE (L)
      L1L_PRSNT = LML_PRSNT(L)
      L1L_HFLAG = LB_HFLAG
      IA        = LML_IATOM(L)
      IN        = LML_ICONN(L)
      IB        = LML_IBOND(L)
      IG        = LML_ITHET(L)
      IT        = LML_ITORS(L)
      IP        = LML_IPLAN(L)
      IC        = LML_ICHIR(L)
      L1A_NATOM = 0
      L1A_NHATOM= 0
      L1N_NCONN = 0
      L1B_NBOND = 0
      L1G_NANGL = 0
      L1T_NTORS = 0
      L1C_NCHIR = 0
      L1P_NPLAN = 0
      L1A_NDUMMY= 0

      IF(IA.GT.0) THEN
        CALL CP_AMLIB(MDOC,MON2,IA,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IN.GT.0) THEN
        CALL CP_NMLIB(MDOC,MON2,IN,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IB.GT.0) THEN
        CALL CP_BMLIB(MDOC,MON2,IB,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IG.GT.0) THEN
        CALL CP_GMLIB(MDOC,MON2,IG,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IT.GT.0) THEN
        CALL CP_TMLIB(MDOC,MON2,IT,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IP.GT.0) THEN
        CALL CP_PMLIB(MDOC,MON2,IP,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      IF(IC.GT.0) THEN
        CALL CP_CMLIB(MDOC,MON2,IC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
c -----------------
      NA   = L1A_NATOM
      L1A_ISTART  = 0
      L1A_IFINISH = 0
      DO I=1,NA
        L1A_INEW (I) = I 
        L1A_IOLD (I) = I
        L1A_ICHEM(I) = 0              
        L1A_ICR  (I) = 0
        L1A_NDIST(I) = 0
        L1A_IBACK(I) = 0
        L1A_IFORW(I) = 0
        DO  J=1,MAX1BRN 
          L1A_CONN   (J,I) = 0
          L1A_LENCON (J,I) = 0
        ENDDO
        DO  J=1,MAX1EXT 
          L1A_TEXTR (J,I) = 0
          L1A_IEXTR (J,I) = 0
        ENDDO
      ENDDO
c -----------------
      IF(LDL_NMOD.GT.0) THEN
        DO L=1,LDL_NMOD
          IF(L1L_MODE.EQ.LDL_MNAME(L)) THEN
            CALL MODIF(MDOC,L1L_MODE,IERR)
            GO TO 200
          ENDIF
        ENDDO
 200    CONTINUE

        IF(MOD.NE.' ') THEN
          DO L=1,LDL_NMOD
            IF(MOD.EQ.LDL_MNAME(L)) THEN
              CALL MODIF(MDOC,MOD,IERR)
              GO TO 310
            ENDIF
          ENDDO
        ENDIF
 310    CONTINUE
        IF(MOD1.NE.' ') THEN
          DO L=1,LDL_NMOD
            IF(MOD1.EQ.LDL_MNAME(L)) THEN
              CALL MODIF(MDOC,MOD1,IERR)
              GO TO 320
            ENDIF
          ENDDO
        ENDIF
 320    CONTINUE
        IF(MOD2.NE.' ') THEN
          DO L=1,LDL_NMOD
            IF(MOD2.EQ.LDL_MNAME(L)) THEN
              CALL MODIF(MDOC,MOD2,IERR)
              GO TO 330
            ENDIF
          ENDDO
        ENDIF
 330    CONTINUE

      ENDIF
 300  CONTINUE

C ---
      IF(L1B_NBOND.GE.2.AND.L1G_NANGL.LE.0) THEN
        L1L_PRSNT    = 'M'
        LML_PRSNT(L) = 'M' 
      ENDIF
C ---
      CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITYPE_RES,IERR)

c      CALL CHECK_RES_TYPE_BY_ATOM_AND_BOND
c     *                (MDOC,ITYPE_RES,IERR)


      IF(ITYPE_RES.EQ.3) THEN
        MOD = 'AA-STAND'
        CALL MODIF(MDOC,MOD,IERR)
        IERR = 0
      ELSE IF(ITYPE_RES.EQ.5) THEN
        MOD = 'NA-STAND'
        CALL MODIF(MDOC,MOD,IERR)
        IERR = 0
      ENDIF
c ---
      IF(L1L_PRSNT.NE.'M') THEN
        CALL CHECK_EXTRA_CONN(MDOC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      RETURN
      END

      SUBROUTINE CHECK_EXTRA_CONN(MDOC,IERR)
C -----------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM1*4,ATOM2*4
C -----------------------------------
      IERR = 0

      IF(L1A_NATOM.LE.2) RETURN
      IF(L1B_NBOND.LE.2) RETURN

      NBACK = 0
      DO IA=1,L1A_NATOM
        IF(L1A_BACK(IA).NE.'.'.AND.L1A_BACK(IA).NE.'n/a'.AND.
     *     L1A_BACK(IA).NE.' ') THEN
          NBACK = NBACK + 1
        ENDIF
      ENDDO

      IF(NBACK.LE.1) RETURN

      DO IB=1,L1B_NBOND
        ATOM1 = L1B_1ATM(IB)
        ATOM2 = L1B_2ATM(IB)
        DO IA=1,L1A_NATOM
          IF((ATOM1.EQ.L1A_ANAME(IA).AND.ATOM2.EQ.L1A_BACK(IA)).OR.
     *     (ATOM2.EQ.L1A_ANAME(IA).AND.ATOM1.EQ.L1A_BACK(IA)))GO TO 100
        ENDDO


        IF(L1N_NCONN.GT.0) THEN
          DO IN=1,L1N_NCONN
            IF((ATOM1.EQ.L1N_1ATM(IN).AND.ATOM2.EQ.L1N_2ATM(IN)).OR.
     *      (ATOM2.EQ.L1N_1ATM(IN).AND.ATOM1.EQ.L1N_2ATM(IN)))GO TO 100
          ENDDO
        ENDIF

        L1N_NCONN = L1N_NCONN+1

        IF(L1N_NCONN.GT.MAX1CONN) THEN
          WRITE(LINE,'(A,A8,A,I6)')
     *' ERR: number of connections in monomer ',L1L_MNAME,'>',MAX1CONN
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF

        L1N_1ATM (L1N_NCONN) = ATOM1
        L1N_2ATM (L1N_NCONN) = ATOM2
        L1N_TYPE (L1N_NCONN) = '.'

 100    CONTINUE
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_AMLIB(MDOC,MON,IA,IERR)
C -----------------------------------------------
C -P- CP_AMLIB - copy atom's information from library to special
C -P-            commons for one current monomer /L1M_ATOM/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IA,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256
C -----------------------------------
      L1A_NATOM = 0
      IF(LMA_NATOM.LE.0.OR.LMA_NATOM.LT.IA.OR.IA.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of atoms in monomer = 0')
        IERR = 1
        RETURN
      ENDIF
      DO   L=IA,LMA_NATOM


        IF(MON.EQ.LMA_MNAME(L)) THEN

          L1A_NATOM = L1A_NATOM+1

          IF(L1A_NATOM.GT.MAX1ATM) THEN
            WRITE(LINE,'(A,A8,A,I6)')' ERR: number of atoms in monomer '
     &      ,MON,' >',MAX1ATM
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1ATM in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF

          L1A_COOR_FLAG(L1A_NATOM) = LMA_COOR_FLAG(L)
          L1A_CHARG    (L1A_NATOM) = LMA_CHARG    (L)
          IF(L1A_COOR_FLAG(L1A_NATOM).EQ.'Y') THEN
            L1A_X    (L1A_NATOM) = LMA_X    (L)
            L1A_Y    (L1A_NATOM) = LMA_Y    (L)
            L1A_Z    (L1A_NATOM) = LMA_Z    (L)
          ELSE
            L1A_X    (L1A_NATOM) = 0.0
            L1A_Y    (L1A_NATOM) = 0.0
            L1A_Z    (L1A_NATOM) = 0.0
          ENDIF

          L1A_LENGTH(L1A_NATOM) = 0.0
          L1A_THETA (L1A_NATOM) = 0.0
          L1A_PHI   (L1A_NATOM) = 0.0
          L1A_ID_PSI(L1A_NATOM) = '.'

          L1A_INEW (L1A_NATOM) = L1A_NATOM 
          L1A_IOLD (L1A_NATOM) = L1A_NATOM
          L1A_ICR  (L1A_NATOM) = 0
          L1A_NDIST(L1A_NATOM) = 0
          L1A_IBACK(L1A_NATOM) = 0
          L1A_IFORW(L1A_NATOM) = 0
          L1A_BACK (L1A_NATOM) = LMA_BACK (L)
          L1A_TYPE (L1A_NATOM) = LMA_TYPE (L)
          L1A_FORW (L1A_NATOM) = LMA_FORW (L)
          L1A_ANAME(L1A_NATOM) = LMA_ANAME(L)
          L1A_SYMB (L1A_NATOM) = LMA_SYMB (L) 
          L1A_SF_ID(L1A_NATOM) = LMA_SF_ID(L)
          L1A_CHEM (L1A_NATOM) = LMA_CHEM (L)
          IF(L1A_SYMB(L1A_NATOM)(1:2).NE.'H '.AND.
     *       L1A_SYMB(L1A_NATOM)(1:2).NE.'D '     ) THEN
            L1A_NHATOM=L1A_NHATOM + 1
          ELSE
            L1A_CHEM(L1A_NATOM) = 'H   '
          ENDIF
          L1A_ATYPE(L1A_NATOM) = 'M'
          DO  J=1,MAX1BRN 
            L1A_CONN   (J,L1A_NATOM) = 0
            L1A_LENCON (J,L1A_NATOM) = 0
          ENDDO
          DO  J=1,MAX1EXT 
            L1A_IEXTR (J,L1A_NATOM) = 0
            L1A_TEXTR (J,L1A_NATOM) = 0
          ENDDO
C
        ENDIF
      ENDDO  
      L1A_IGATM    = 0
      L1A_ISTART   = 0
      L1A_IFINISH  = 0
      L1A_I2START  = 0 
      L1A_I2FINISH = 0
      IF(L1A_NATOM.EQ.1) THEN
        L1A_FORW (1) = 'END'
      ENDIF
      RETURN
      END

      SUBROUTINE COUNT_NATOM_LIB(MDOC,MON,IA,NATOM,NHATOM,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IA,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256,ATOM*4,SYMB*4
C -----------------------------------
      NATOM  = 0
      NHATOM = 0
      IF(IA.LE.0) THEN
        LINE = ' ERR: monomer '//MON//' number of atoms = 0'
        CALL MSGERR(MDOC,LINE)
        IERR = 1
        RETURN
      ENDIF

      DO   L=IA,100000
        IF(MON.NE.LMA_MNAME(L)) RETURN
        ATOM  = LMA_ANAME(L)
        SYMB  = LMA_SYMB (L) 
        NATOM = NATOM + 1
        IF(SYMB(1:2).NE.'H '.AND.
     *     SYMB(1:2).NE.'D ' )
     *    NHATOM = NHATOM + 1
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_NMLIB(MDOC,MON,IN,IERR)
C -----------------------------------------------
C -P- CP_NMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IN,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256
C -----------------------------------
      L1N_NCONN=0
      IF(LMN_NCONN.LE.0.OR.LMN_NCONN.LT.IN.OR.IN.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of atoms in monomer = 0')
        IERR = 1
        RETURN
      ENDIF
      DO   L=IN,LMN_NCONN
        IF(MON.EQ.LMN_MNAME(L)) THEN
          L1N_NCONN = L1N_NCONN+1

          IF(L1N_NCONN.GT.MAX1CONN) THEN
            WRITE(LINE,'(A,A8,A,I6)')
     * ' ERR: number of connections in monomer ',MON,'>',MAX1CONN
            CALL MSGERR(MDOC,LINE)
            IERR=1
            RETURN
          ENDIF

          L1N_1ATM (L1N_NCONN) = LMN_1ATM (L)
          L1N_2ATM (L1N_NCONN) = LMN_2ATM (L)
          L1N_TYPE (L1N_NCONN) = LMN_TYPE (L)

        ENDIF
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_BMLIB(MDOC,MON,IB,IERR)
C -----------------------------------------------
C -P- CP_BMLIB - copies bond's information from library to special
C -P-            commons for one current monomer /L1M_BOND/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IB,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L1B_NBOND=0
      IF(LMB_NBOND.LE.0.OR.LMB_NBOND.LT.IB.OR.IB.LE.0) RETURN
      DO   L=IB,LMB_NBOND
        IF(MON.EQ.LMB_MNAME(L)) THEN

          L1B_NBOND = L1B_NBOND+1
          IF(L1B_NBOND.GT.MAX1BND) THEN
            WRITE(LINE,'(A,A8,A,I6)')
     *    ' ERR: number of bonds in monomer ',MON,' >',MAX1BND
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1BND in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF

          L1B_FLAG (L1B_NBOND) = 'N'
          L1B_VOBS (L1B_NBOND) = 0.0
          L1B_EVAL (L1B_NBOND) = 0.0
          L1B_VAL  (L1B_NBOND) = LMB_VAL  (L)
          L1B_DEV  (L1B_NBOND) = LMB_DEV  (L)
          L1B_I1ATM(L1B_NBOND) = 0
          L1B_I2ATM(L1B_NBOND) = 0
          L1B_1ATM (L1B_NBOND) = LMB_1ATM (L)
          L1B_2ATM (L1B_NBOND) = LMB_2ATM (L)
          L1B_TYPE (L1B_NBOND) = LMB_TYPE (L)

        ENDIF
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_GMLIB(MDOC,MON,IG,IERR)
C -----------------------------------------------
C -P- CP_GMLIB - copies angle's information from library to special
C -P-            commons for one current monomer /L1M_ANGL/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IG,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L1G_NANGL=0
      IF(LMG_NANGL.LE.0.OR.LMG_NANGL.LT.IG.OR.IG.LE.0) RETURN
      DO   L=IG,LMG_NANGL
        IF(MON.EQ.LMG_MNAME(L)) THEN

          L1G_NANGL = L1G_NANGL+1
          IF(L1G_NANGL.GT.MAX1ANG) THEN
            WRITE(LINE,'(A,A8,A,I6)')
     *  ' ERR: number of angles in monomer ',MON,' >',MAX1ANG
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1ANG in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF
          L1G_FLAG (L1G_NANGL) = 'N'
          L1G_VOBS (L1G_NANGL) = 0.0
          L1G_EVAL (L1G_NANGL) = 0.0
          L1G_VAL  (L1G_NANGL) = LMG_VAL  (L)
          L1G_DEV  (L1G_NANGL) = LMG_DEV  (L)
          L1G_I1ATM (L1G_NANGL) = 0
          L1G_I2ATM (L1G_NANGL) = 0
          L1G_I3ATM (L1G_NANGL) = 0
          L1G_1ATM (L1G_NANGL) = LMG_1ATM (L)
          L1G_2ATM (L1G_NANGL) = LMG_2ATM (L)
          L1G_3ATM (L1G_NANGL) = LMG_3ATM (L)

        ENDIF
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_TMLIB(MDOC,MON,IT,IERR)
C -----------------------------------------------
C -P- CP_TMLIB - copies tortion's information from library to special
C -P-            commons for one current monomer /L1M_TORS/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IT,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L1T_NTORS=0
      IF(LMT_NTORS.LE.0.OR.LMT_NTORS.LT.IT.OR.IT.LE.0) RETURN
      DO   L=IT,LMT_NTORS
        IF(MON.EQ.LMT_MNAME(L)) THEN

          L1T_NTORS = L1T_NTORS+1
          IF(L1T_NTORS.GT.MAX1TOR) THEN
            WRITE(LINE,'(A,A8,A,I6)')
     *   ' ERR: number of torsions in monomer ',MON,' >',MAX1TOR
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1TOR in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF

          L1T_FLAG (L1T_NTORS) = 'N'
          L1T_VOBS (L1T_NTORS) = 0.0
          L1T_EVAL (L1T_NTORS) = 0.0
          L1T_VAL  (L1T_NTORS) = LMT_VAL  (L)
          L1T_DEV  (L1T_NTORS) = LMT_DEV  (L)
          L1T_I1ATM (L1T_NTORS) = 0
          L1T_I2ATM (L1T_NTORS) = 0
          L1T_I3ATM (L1T_NTORS) = 0
          L1T_I4ATM (L1T_NTORS) = 0
          L1T_1ATM (L1T_NTORS) = LMT_1ATM (L)
          L1T_2ATM (L1T_NTORS) = LMT_2ATM (L)
          L1T_3ATM (L1T_NTORS) = LMT_3ATM (L)
          L1T_4ATM (L1T_NTORS) = LMT_4ATM (L)
          L1T_PRD  (L1T_NTORS) = LMT_PRD  (L)
          L1T_LABEL(L1T_NTORS) = LMT_LABEL(L)

        ENDIF
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_CMLIB(MDOC,MON,IC,IERR)
C -----------------------------------------------
C -P- CP_CMLIB - copies chiralities from library to special
C -P-            commons for one current monomer /L1M_CHIR/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IC,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L1C_NCHIR=0
      IF(LMC_NCHIR.LE.0.OR.LMC_NCHIR.LT.IC.OR.IC.LE.0) RETURN
      DO   L=IC,LMC_NCHIR
        IF(MON.EQ.LMC_MNAME(L)) THEN

          L1C_NCHIR = L1C_NCHIR+1
          IF(L1C_NCHIR.GT.MAX1CHR) THEN
           WRITE(LINE,'(A,A8,A,I6)')
     *   ' ERR: number of chiral centres in monomer ',MON,' >',MAX1CHR
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1CHR in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF

          L1C_FLAG  (L1C_NCHIR) = LMC_FLAG (L)
          L1C_VOL   (L1C_NCHIR) = 0.0
          L1C_VOBS  (L1C_NCHIR) = 0.0
          L1C_EVOL  (L1C_NCHIR) = 0.0
          L1C_I1ATM (L1C_NCHIR) = 0
          L1C_I2ATM (L1C_NCHIR) = 0
          L1C_I3ATM (L1C_NCHIR) = 0
          L1C_I4ATM (L1C_NCHIR) = 0
          L1C_I5ATM (L1C_NCHIR) = 0
          L1C_I6ATM (L1C_NCHIR) = 0
          L1C_I7ATM (L1C_NCHIR) = 0
          L1C_I8ATM (L1C_NCHIR) = 0
          L1C_I9ATM (L1C_NCHIR) = 0
          L1C_1ATM  (L1C_NCHIR) = LMC_1ATM (L)
          L1C_2ATM  (L1C_NCHIR) = LMC_2ATM (L)
          L1C_3ATM  (L1C_NCHIR) = LMC_3ATM (L)
          L1C_4ATM  (L1C_NCHIR) = LMC_4ATM (L)
          L1C_5ATM  (L1C_NCHIR) = LMC_5ATM (L)
          L1C_6ATM  (L1C_NCHIR) = LMC_6ATM (L)
          L1C_7ATM  (L1C_NCHIR) = LMC_7ATM (L)
          L1C_8ATM  (L1C_NCHIR) = LMC_8ATM (L)
          L1C_9ATM  (L1C_NCHIR) = LMC_9ATM (L)
          L1C_SIGN  (L1C_NCHIR) = LMC_SIGN (L)

        ENDIF
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CP_PMLIB(MDOC,MON,IP,IERR)
C -----------------------------------------------
C -P- CP_PMLIB - copies planarities from library to special
C -P-            commons for one current monomer /L1M_PLAN/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IP,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L1P_NPLAN=0
      IF(LMP_NPLAN.LE.0.OR.LMP_NPLAN.LT.IP.OR.IP.LE.0) RETURN
      DO   L=IP,LMP_NPLAN
        IF(MON.EQ.LMP_MNAME(L)) THEN

          L1P_NPLAN = L1P_NPLAN+1
          IF(L1P_NPLAN.GT.MAX1PLN) THEN
            WRITE(LINE,'(A,A8,A,I6)')
     *      ' ERR: number of planar groups in monomer ',MON,' >',MAX1PLN
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1PLN in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF
          IF(LMP_NATOM(L).LE.0.OR.LMP_NATOM(L).GT.MAX1APL) THEN
            WRITE(LINE,'(A,A8,A,I6)')
     &      ' ERR: number of plan atoms in monomer ',MON,' >',MAX1APL
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAX1APL in "lib_com.fh"')
            IERR=1
            RETURN
          ENDIF
          L1P_NATOM (L1P_NPLAN) = LMP_NATOM(L)
          L1P_LABEL (L1P_NPLAN) = LMP_LABEL(L)
          DO   I=1,L1P_NATOM (L1P_NPLAN)
            L1P_FLAG  (I,L1P_NPLAN) = 0
            L1P_DOBS  (I,L1P_NPLAN) = 0.0
            L1P_EDEV  (I,L1P_NPLAN) = 0.0
            L1P_IATOM (I,L1P_NPLAN) = 0
            L1P_DEV   (I,L1P_NPLAN) = LMP_DEV  (I,L)
            L1P_ATOM  (I,L1P_NPLAN) = LMP_ATOM (I,L)
          ENDDO  
        ENDIF
      ENDDO  
      RETURN
      END


      SUBROUTINE COPYL2(MDOC,IERR)
C -----------------------------------------------
C -P- COPYL2 - copis information from /L1A / to /L2A / 
C -S-                               
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
C      CHARACTER LINE*256
C -----------------------------------
      IF(L1A_NATOM.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR : L1A --> L2A number of atoms =0')
        IERR = 1
        RETURN
      ENDIF       

      L2L_NATM    = L1L_NATM
      L2L_NHATM   = L1L_NHATM

      L2L_MNAME   = L1L_MNAME
      L2L_MNAME2  = L1L_MNAME2
      L2L_CODE1   = L1L_CODE1
      L2L_NAME    = L1L_NAME
      L2L_FORM    = L1L_FORM
      L2L_TYPE    = L1L_TYPE
      L2L_MODE    = L1L_MODE
      L2L_FUSE    = L1L_FUSE
      L2L_PRSNT   = L1L_PRSNT 
      L2L_HFLAG   = L1L_HFLAG 

      L2A_NATOM    = L1A_NATOM 
      L2A_NHATOM   = L1A_NHATOM
      L2A_IGATM    = L1A_IGATM  
      L2A_ISTART   = L1A_ISTART
      L2A_IFINISH  = L1A_IFINISH
      L2A_I2START  = L1A_I2START 
      L2A_I2FINISH = L1A_I2FINISH


      DO IATM=1,L1A_NATOM

        L2A_CHARG (IATM) = L1A_CHARG (IATM)
        L2A_X     (IATM) = L1A_X     (IATM)
        L2A_Y     (IATM) = L1A_Y     (IATM)
        L2A_Z     (IATM) = L1A_Z     (IATM)
        L2A_LENGTH(IATM) = L1A_LENGTH(IATM)
        L2A_THETA (IATM) = L1A_THETA (IATM)
        L2A_PHI   (IATM) = L1A_PHI   (IATM)
        L2A_NRING (IATM) = L1A_NRING (IATM)
        L2A_INEW  (IATM) = L1A_INEW  (IATM)
        L2A_IOLD  (IATM) = L1A_IOLD  (IATM)
        L2A_ICR   (IATM) = L1A_ICR   (IATM)
        L2A_IBACK (IATM) = L1A_IBACK (IATM)
        L2A_IFORW (IATM) = L1A_IFORW (IATM)
        L2A_NDIST (IATM) = L1A_NDIST (IATM)
        L2A_NEXTR (IATM) = L1A_NEXTR (IATM)
        L2A_ICHEM (IATM) = L1A_ICHEM (IATM)
        L2A_SF_ID (IATM) = L1A_SF_ID (IATM)
        L2A_ID_PSI(IATM) = L1A_ID_PSI(IATM)
        L2A_SYMB  (IATM) = L1A_SYMB  (IATM)
        L2A_ATYPE (IATM) = L1A_ATYPE (IATM)
        L2A_ANAME (IATM) = L1A_ANAME (IATM)
        L2A_TYPE  (IATM) = L1A_TYPE  (IATM)
        L2A_BACK  (IATM) = L1A_BACK  (IATM)
        L2A_FORW  (IATM) = L1A_FORW  (IATM)
        L2A_CHEM  (IATM) = L1A_CHEM  (IATM)

        L2A_COOR_FLAG(IATM) = L1A_COOR_FLAG(IATM) 
        IF(L1A_NDIST(IATM).GT.0) THEN
          DO  I=1,L1A_NDIST(IATM)
            L2A_CONN     (I,IATM) = L1A_CONN     (I,IATM)
            L2A_LENCON   (I,IATM) = L1A_LENCON   (I,IATM)
            L2A_RING_ID  (I,IATM) = L1A_RING_ID  (I,IATM)
            L2A_RING_ORD (I,IATM) = L1A_RING_ORD (I,IATM)
          ENDDO
        ENDIF

        IF(L1A_NEXTR(IATM).GT.0) THEN
          DO  I=1,L1A_NEXTR(IATM)
            L2A_IEXTR(I,IATM) = L1A_IEXTR(I,IATM)
            L2A_TEXTR(I,IATM) = L1A_TEXTR(I,IATM)
          ENDDO
        ENDIF
        

      ENDDO

      L2N_NCONN = L1N_NCONN 
      IF(L1N_NCONN.GT.0) THEN
        DO I=1,L1N_NCONN
          L2N_I1ATM (I) = L1N_I1ATM (I)
          L2N_I2ATM (I) = L1N_I2ATM (I)
          L2N_1ATM  (I) = L1N_1ATM  (I)
          L2N_2ATM  (I) = L1N_2ATM  (I)
          L2N_TYPE  (I) = L1N_TYPE  (I)
        ENDDO
      ENDIF

      L2B_NBOND = L1B_NBOND 
      IF(L1B_NBOND.GT.0) THEN 
        DO I=1,L1B_NBOND
          L2B_I1ATM (I) = L1B_I1ATM (I)
          L2B_I2ATM (I) = L1B_I2ATM (I)
          L2B_1ATM  (I) = L1B_1ATM  (I)
          L2B_2ATM  (I) = L1B_2ATM  (I)
          L2B_TYPE  (I) = L1B_TYPE  (I)
          L2B_FLAG  (I) = L1B_FLAG  (I) 
          L2B_VAL   (I) = L1B_VAL   (I)
          L2B_DEV   (I) = L1B_DEV   (I)
          L2B_VOBS  (I) = L1B_VOBS  (I) 
          L2B_EVAL  (I) = L1B_EVAL  (I)
        ENDDO
      ENDIF

      L2G_NANGL = L1G_NANGL
      IF(L1G_NANGL.GT.0) THEN
        DO I=1,L1G_NANGL
          L2G_I1ATM (I) = L1G_I1ATM (I)
          L2G_I2ATM (I) = L1G_I2ATM (I)
          L2G_I3ATM (I) = L1G_I3ATM (I)
          L2G_VAL   (I) = L1G_VAL   (I)
          L2G_VOBS  (I) = L1G_VOBS  (I)
          L2G_DEV   (I) = L1G_DEV   (I)
          L2G_EVAL  (I) = L1G_EVAL  (I) 
        ENDDO
      ENDIF

      L2T_NTORS = L1T_NTORS
      IF(L1T_NTORS.GT.0) THEN 
        DO I=1,L1T_NTORS 
          L2T_1ATM  (I) = L1T_1ATM  (I) 
          L2T_2ATM  (I) = L1T_2ATM  (I)
          L2T_3ATM  (I) = L1T_3ATM  (I)
          L2T_4ATM  (I) = L1T_4ATM  (I)
          L2T_LABEL (I) = L1T_LABEL (I)
          L2T_FLAG  (I) = L1T_FLAG  (I)
          L2T_VAL   (I) = L1T_VAL   (I)
          L2T_DEV   (I) = L1T_DEV   (I) 
          L2T_VOBS  (I) = L1T_VOBS  (I)
          L2T_EVAL  (I) = L1T_EVAL  (I)
          L2T_PRD   (I) = L1T_PRD   (I)
          L2T_I1ATM (I) = L1T_I2ATM (I)
          L2T_I2ATM (I) = L1T_I2ATM (I)
          L2T_I3ATM (I) = L1T_I3ATM (I)
          L2T_I4ATM (I) = L1T_I4ATM (I)
        ENDDO
      ENDIF


      L2C_NCHIR = L1C_NCHIR
      IF(L1C_NCHIR.GT.0) THEN
        DO I=1,L1C_NCHIR  
          L2C_I1ATM (I) = L1C_I1ATM (I) 
          L2C_I2ATM (I) = L1C_I2ATM (I)
          L2C_I3ATM (I) = L1C_I3ATM (I) 
          L2C_I4ATM (I) = L1C_I4ATM (I)
          L2C_I5ATM (I) = L1C_I5ATM (I) 
          L2C_I6ATM (I) = L1C_I6ATM (I)
          L2C_I7ATM (I) = L1C_I7ATM (I) 
          L2C_I8ATM (I) = L1C_I8ATM (I)
          L2C_I9ATM (I) = L1C_I9ATM (I)
          L2C_1ATM  (I) = L1C_1ATM  (I)  
          L2C_2ATM  (I) = L1C_2ATM  (I)
          L2C_3ATM  (I) = L1C_3ATM  (I)
          L2C_4ATM  (I) = L1C_4ATM  (I)
          L2C_5ATM  (I) = L1C_5ATM  (I)  
          L2C_6ATM  (I) = L1C_6ATM  (I)
          L2C_7ATM  (I) = L1C_7ATM  (I)
          L2C_8ATM  (I) = L1C_8ATM  (I)
          L2C_9ATM  (I) = L1C_9ATM  (I)
          L2C_SIGN  (I) = L1C_SIGN  (I)
          L2C_FLAG  (I) = L1C_FLAG  (I)
          L2C_VOL   (I) = L1C_VOL   (I)
          L2C_VOBS  (I) = L1C_VOBS  (I)
          L2C_EVOL  (I) = L1C_EVOL  (I)
        ENDDO
      ENDIF

      L2P_NPLAN = L1P_NPLAN
      IF(L1P_NPLAN.GT.0) THEN
        DO I=1, L1P_NPLAN 
          L2P_LABEL (I) = L1P_LABEL (I)
          L2P_NATOM (I) = L1P_NATOM (I)
          IF(L1P_NATOM (I).GT.0) THEN
            DO J=1,L1P_NATOM (I)
              L2P_IATOM (J,I) = L1P_IATOM (J,I)
              L2P_ATOM  (J,I) = L1P_ATOM  (J,I)
              L2P_FLAG  (J,I) = L1P_FLAG  (J,I)
              L2P_DEV   (J,I) = L1P_DEV   (J,I)
              L2P_DOBS  (J,I) = L1P_DOBS  (J,I)
              L2P_EDEV  (J,I) = L1P_EDEV  (J,I) 
            ENDDO
          ENDIF
        ENDDO
      ENDIF

      RETURN

      END

C ******
      SUBROUTINE COPYC2(MDOC,IERR)
C -----------------------------------------------
C -P- COPYC2 - copis information from /CR1ATM/ to /CR2ATM/ 
C -S-                               
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
C      CHARACTER LINE*256
C -----------------------------------
      IF(C1_NATOM.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: C1 --> C2 number of atoms =0')
        IERR=1
        RETURN
      ENDIF       

      C2_NATOM  = C1_NATOM 
      C2_IGLOBAL= C1_IGLOBAL  
      C2_IGATM  = C1_IGATM  
      C2_ICH    = C1_ICH  
      C2_IRES   = C1_IRES 
      C2_IGRES  = C1_IGRES
      C2_RNAME  = C1_RNAME
      C2_CODE1  = C1_CODE1
      C2_PNUM   = C1_PNUM
      C2_RTYPE  = C1_RTYPE
      C2_S_TERM = C1_S_TERM
      C2_F_TERM = C1_F_TERM

      DO   IATM=1,MX1ATOM
        S2_CONN_S (IATM) = S1_CONN_S (IATM)
        S2_CONN_F (IATM) = S1_CONN_F (IATM) 
        S2_ISTART (IATM) = S1_ISTART (IATM)
        S2_IFINISH(IATM) = S1_IFINISH(IATM)
      ENDDO

      DO   IATM=1,C1_NATOM
        C2_NALT  (IATM) = C1_NALT (IATM)
        C2_ANAME (IATM) = C1_ANAME(IATM)
        C2_ANAME_INP(IATM) = C1_ANAME_INP(IATM)
        C2_IALT  (IATM) = C1_IALT (IATM)  
        DO   I=1,3
          C2_XYZ(I,IATM) = C1_XYZ (I,IATM)
          C2_CSD(I,IATM) = C1_CSD (I,IATM)
        ENDDO
        DO   I=1,6
          C2_ANIS(I,IATM) = C1_ANIS (I,IATM)
          C2_ASD (I,IATM) = C1_ASD  (I,IATM)
        ENDDO
        C2_BISO  (IATM) = C1_BISO (IATM)
        C2_OCC   (IATM) = C1_OCC  (IATM)
        C2_BSD   (IATM) = C1_BSD  (IATM)
        C2_OSD   (IATM) = C1_OSD  (IATM)
        C2_USER  (IATM) = C1_USER (IATM)
        C2_ASYMB (IATM) = C1_ASYMB(IATM)
        C2_SF_ID (IATM) = C1_SF_ID(IATM)
        C2_ATYPE (IATM) = C1_ATYPE(IATM)
        C2_ALT   (IATM) = C1_ALT  (IATM)
        C2_CORR  (IATM) = C1_CORR (IATM)
        C2_BTYPE (IATM) = C1_BTYPE(IATM)
        C2_FSC   (IATM) = C1_FSC  (IATM)
        C2_FSA   (IATM) = C1_FSA  (IATM)
        C2_FUS   (IATM) = C1_FUS  (IATM)
        S2_INEW  (IATM) = S1_INEW (IATM)
        S2_IOLD  (IATM) = S1_IOLD (IATM)
        S2_ILIB  (IATM) = S1_ILIB (IATM)
        S2_ICRD  (IATM) = S1_ICRD (IATM)
        S2_IBACK (IATM) = S1_IBACK(IATM)
        S2_IFORW (IATM) = S1_IFORW(IATM)
        S2_BACK  (IATM) = S1_BACK (IATM)
        S2_FORW  (IATM) = S1_FORW (IATM)
        S2_ILIB  (IATM) = S1_ILIB (IATM)
        S2_NDIST (IATM) = S1_NDIST(IATM)
        S2_NEXTR (IATM) = S1_NEXTR(IATM)
        S2_HBT   (IATM) = S1_HBT  (IATM)
        S2_ID_PSI(IATM) = S1_ID_PSI(IATM)
        S2_VDW   (IATM) = S1_VDW  (IATM)
        S2_ION   (IATM) = S1_ION  (IATM)
        S2_CHAR  (IATM) = S1_CHAR (IATM)
        S2_CHEM  (IATM) = S1_CHEM (IATM)
        S2_ICHEM (IATM) = S1_ICHEM(IATM)
        S2_FTREE        = S1_FTREE  
        DO  I=1,MX1BRN
          S2_CONN(I,IATM)   = S1_CONN(I,IATM)
          S2_LENCON(I,IATM) = S1_LENCON(I,IATM)
        ENDDO
        DO  I=1,MX1EXT
          S2_IEXTR(I,IATM) = S1_IEXTR(I,IATM)
        ENDDO
        DO   I=1,3
          S2_DIST(IATM) = S1_DIST (IATM)
          S2_THT (IATM) = S1_THT  (IATM)
          S2_PSI (IATM) = S1_PSI  (IATM)
        ENDDO
      
      ENDDO
      RETURN
      END

C ******
      SUBROUTINE COPYC1(MDOC,IERR)
C -----------------------------------------------
C -P- COPYC1 - copis information from /CR2ATM/ to /CR1ATM/ 
C -S-                               
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
C      CHARACTER LINE*256
C -----------------------------------
      IF(C2_NATOM.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: C2 --> C1 number of atoms =0')
        IERR=1
        RETURN
      ENDIF       

      C1_NATOM  = C2_NATOM 
      C1_IGLOBAL= C2_IGLOBAL  
      C1_IGATM  = C2_IGATM  
      C1_ICH    = C2_ICH  
      C1_IRES   = C2_IRES 
      C1_IGRES  = C2_IGRES
      C1_RNAME  = C2_RNAME
      C1_CODE1  = C2_CODE1
      C1_PNUM   = C2_PNUM
      C1_RTYPE  = C2_RTYPE
      C1_S_TERM = C2_S_TERM
      C1_F_TERM = C2_F_TERM

      DO   IATM=1,MX1ATOM
        S1_CONN_S (IATM) = S2_CONN_S (IATM)
        S1_CONN_F (IATM) = S2_CONN_F (IATM) 
        S1_ISTART (IATM) = S2_ISTART (IATM)
        S1_IFINISH(IATM) = S2_IFINISH(IATM)
      ENDDO

      DO   IATM=1,C2_NATOM
        C1_NALT  (IATM) = C2_NALT (IATM)
        C1_ANAME (IATM) = C2_ANAME(IATM)
        C1_ANAME_INP(IATM) = C2_ANAME_INP(IATM)
        C1_IALT  (IATM) = C2_IALT (IATM)  
        DO   I=1,3
          C1_XYZ(I,IATM) = C2_XYZ (I,IATM)
          C1_CSD(I,IATM) = C2_CSD (I,IATM)
        ENDDO
        DO   I=1,6
          C1_ANIS(I,IATM) = C2_ANIS (I,IATM)
          C1_ASD (I,IATM) = C2_ASD  (I,IATM)
        ENDDO
        C1_BISO  (IATM) = C2_BISO (IATM)
        C1_OCC   (IATM) = C2_OCC  (IATM)
        C1_BSD   (IATM) = C2_BSD  (IATM)
        C1_OSD   (IATM) = C2_OSD  (IATM)
        C1_USER  (IATM) = C2_USER (IATM)
        C1_ASYMB (IATM) = C2_ASYMB(IATM)
        C1_SF_ID (IATM) = C2_SF_ID(IATM)
        C1_ATYPE (IATM) = C2_ATYPE(IATM)
        C1_ALT   (IATM) = C2_ALT  (IATM)
        C1_CORR  (IATM) = C2_CORR (IATM)
        C1_BTYPE (IATM) = C2_BTYPE(IATM)
        C1_FSC   (IATM) = C2_FSC  (IATM)
        C1_FSA   (IATM) = C2_FSA  (IATM)
        C1_FUS   (IATM) = C2_FUS  (IATM)
        S1_INEW  (IATM) = S2_INEW (IATM)
        S1_IOLD  (IATM) = S2_IOLD (IATM)
        S1_ILIB  (IATM) = S2_ILIB (IATM)
        S1_ICRD  (IATM) = S2_ICRD (IATM)
        S1_IBACK (IATM) = S2_IBACK(IATM)
        S1_IFORW (IATM) = S2_IFORW(IATM)
        S1_BACK  (IATM) = S2_BACK (IATM)
        S1_FORW  (IATM) = S2_FORW (IATM)
        S1_ILIB  (IATM) = S2_ILIB (IATM)
        S1_NDIST (IATM) = S2_NDIST(IATM)
        S1_NEXTR (IATM) = S2_NEXTR(IATM)
        S1_HBT   (IATM) = S2_HBT  (IATM)
        S1_ID_PSI(IATM) = S2_ID_PSI(IATM)
        S1_VDW   (IATM) = S2_VDW  (IATM)
        S1_ION   (IATM) = S2_ION  (IATM)
        S1_CHAR  (IATM) = S2_CHAR (IATM)
        S1_CHEM  (IATM) = S2_CHEM (IATM)
        S1_ICHEM (IATM) = S2_ICHEM(IATM)
        S1_FTREE        = S2_FTREE  
        DO  I=1,MX1BRN
          S1_CONN(I,IATM)   = S2_CONN(I,IATM)
          S1_LENCON(I,IATM) = S2_LENCON(I,IATM)
        ENDDO
        DO  I=1,MX1EXT
          S1_IEXTR(I,IATM) = S2_IEXTR(I,IATM)
        ENDDO
        DO   I=1,3
          S1_DIST(IATM) = S2_DIST (IATM)
          S1_THT (IATM) = S2_THT  (IATM)
          S1_PSI (IATM) = S2_PSI  (IATM)
        ENDDO
      
      ENDDO
      RETURN
      END


C ******
      SUBROUTINE CPL_MLIB(MDOC,IERR)
C -----------------------------------------------
C -P- CP_MLIB - copies monomer's information to library from special
C -P-           commons for one current monomer /L1M_LIST/,/L1M_ATOM/,... 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER MON*8
C     CHARACTER MMM*8
      CHARACTER LINE*256
C -----------------------------------
      IERR = 0
      MON  = L1L_MNAME
      IF(L1A_NATOM.LE.0) THEN
        CALL MSGERR(MDOC
     *  ,' ERR: number of atoms of monomer in library_L1 = 0')
        IERR=1
        RETURN
      ENDIF
      IF(LML_NMON.GE.MAXMLIST) THEN
        WRITE(LINE,'(A,I6,A)')
     *   ' ERR: number of monomers >',MAXMLIST,' /lib. limit/'
        CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMLIST in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF

      L_PASS = 3

      IF(LML_NMON.GT.0) THEN

        DO   LL=1,LML_NMON

          IF(MON.EQ.LML_MNAME(LL)) THEN

            IA = LML_IATOM(LL)
            IN = LML_ICONN(LL)
            IB = LML_IBOND(LL)
            IG = LML_ITHET(LL)
            IT = LML_ITORS(LL)
            IP = LML_IPLAN(LL)
            IC = LML_ICHIR(LL)
            L_PASS = LML_PASS(LL)
  
            IF(LMA_NATOM.GT.0.AND.LMA_NATOM.GE.IA.AND.IA.GT.0) THEN
              DO   L=IA,LMA_NATOM
                IF(MON.EQ.LMA_MNAME(L)) LMA_MNAME(L) = '?'
              ENDDO
            ENDIF
            IF(LMN_NCONN.GT.0.AND.LMN_NCONN.GE.IN.AND.IN.GT.0) THEN
              DO   L=IN,LMN_NCONN
                IF(MON.EQ.LMN_MNAME(L)) LMN_MNAME(L) = '?'
              ENDDO
            ENDIF
            IF(LMB_NBOND.GT.0.AND.LMB_NBOND.GE.IB.AND.IB.GT.0) THEN
              DO   L=IB,LMB_NBOND
                IF(MON.EQ.LMB_MNAME(L)) LMB_MNAME(L) = '?'
              ENDDO
            ENDIF
            IF(LMG_NANGL.GT.0.AND.LMG_NANGL.GE.IG.AND.IG.GT.0) THEN
              DO   L=IG,LMG_NANGL
                IF(MON.EQ.LMG_MNAME(L)) LMG_MNAME(L) = '?'
              ENDDO
            ENDIF
            IF(LMT_NTORS.GT.0.AND.LMT_NTORS.GE.IT.AND.IT.GT.0) THEN
              DO   L=IT,LMT_NTORS
                IF(MON.EQ.LMT_MNAME(L)) LMT_MNAME(L) = '?'
              ENDDO
            ENDIF
            IF(LMC_NCHIR.GT.0.AND.LMC_NCHIR.GE.IC.AND.IC.GT.0) THEN
              DO   L=IC,LMC_NCHIR
                IF(MON.EQ.LMC_MNAME(L)) LMC_MNAME(L) = '?'
              ENDDO
            ENDIF
            IF(LMP_NPLAN.GT.0.AND.LMP_NPLAN.GE.IP.AND.IP.GT.0) THEN
              DO   L=IP,LMP_NPLAN
                IF(MON.EQ.LMP_MNAME(L)) LMP_MNAME(L) = '?'
              ENDDO
            ENDIF

            LML_MNAME(LL) = '???'
            LML_FUSE(LL)  = 'N'
C           LML_FUSE(LL)  = '?'
            LML_IATOM(LL) = 0
            LML_ICONN(LL) = 0
            LML_IBOND(LL) = 0
            LML_ITHET(LL) = 0
            LML_ITORS(LL) = 0
            LML_IPLAN(LL) = 0
            LML_ICHIR(LL) = 0

          ENDIF

        ENDDO  
      ENDIF

      LML_NMON     = LML_NMON+1
      LML_IMON     = LML_NMON
      L            = LML_IMON
      LML_NATM (L) = L1L_NATM
      LML_NHATM(L) = L1L_NHATM
      LML_MNAME(L) = L1L_MNAME 
      LML_MNAME2(L)= L1L_MNAME2 
      LML_NAME (L) = L1L_NAME 
      LML_FORM (L) = L1L_FORM 
      LML_CODE1(L) = L1L_CODE1
      LML_TYPE (L) = L1L_TYPE
      LML_MODE (L) = L1L_MODE
      LML_FUSE (L) = L1L_FUSE
      LML_PRSNT(L) = L1L_PRSNT
      LML_PASS(L)  = L_PASS

      LML_IATOM(L) = 0
      LML_ICONN(L) = 0
      LML_IBOND(L) = 0
      LML_ITHET(L) = 0
      LML_ITORS(L) = 0
      LML_IPLAN(L) = 0
      LML_ICHIR(L) = 0
      IA           = L1A_NATOM
      IN           = L1N_NCONN
      IB           = L1B_NBOND
      IG           = L1G_NANGL
      IT           = L1T_NTORS
      IC           = L1C_NCHIR
      IP           = L1P_NPLAN

      IF(IA.GT.0) THEN
        CALL CPL_AMLIB(MDOC,MON,IA,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IN.GT.0) THEN
        CALL CPL_NMLIB(MDOC,MON,IN,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IB.GT.0) THEN
        CALL CPL_BMLIB(MDOC,MON,IB,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IG.GT.0) THEN
        CALL CPL_GMLIB(MDOC,MON,IG,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IT.GT.0) THEN
        CALL CPL_TMLIB(MDOC,MON,IT,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IP.GT.0) THEN
        CALL CPL_PMLIB(MDOC,MON,IP,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      IF(IC.GT.0) THEN
        CALL CPL_CMLIB(MDOC,MON,IC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
      RETURN
      END

C ******
      SUBROUTINE CPL_AMLIB(MDOC,MON,IA,IERR)
C -----------------------------------------------
C -P- CP_AMLIB - copy atom's information from library to special
C -P-            commons for one current monomer /L1M_ATOM/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IA,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256
C -----------------------------------
      L=LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      IAH = 0
      DO   II=1,IA
        I=L1A_IOLD(II)
        IF(LMA_NATOM.GE.MAXMATM) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: number of atoms for monomer ',MON,' >',MAX1ATM,
     *     ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMATM in "lib_com.fh"')
          LML_IMON = 0           
          IERR=1
          RETURN
        ENDIF
        LMA_NATOM=LMA_NATOM+1
        IF(LML_IATOM(L).EQ.0) LML_IATOM(L)=LMA_NATOM 
        LA=LMA_NATOM
        LMA_MNAME(LA)     = MON
        LMA_COOR_FLAG(LA) = L1A_COOR_FLAG(I)
        LMA_CHARG(LA)     = L1A_CHARG(I)
        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN
          LMA_X    (LA) = L1A_X    (I)
          LMA_Y    (LA) = L1A_Y    (I)
          LMA_Z    (LA) = L1A_Z    (I)
        ELSE
          LMA_X    (LA) = 0.0
          LMA_Y    (LA) = 0.0
          LMA_Z    (LA) = 0.0
        ENDIF
        LMA_BACK (LA) = L1A_BACK (I)
        LMA_TYPE (LA) = L1A_TYPE (I)
        LMA_FORW (LA) = L1A_FORW (I)
        LMA_ANAME(LA) = L1A_ANAME(I)
        LMA_SYMB (LA) = L1A_SYMB (I) 
        LMA_SF_ID(LA) = L1A_SF_ID(I) 
        LMA_CHEM (LA) = L1A_CHEM (I)
        IF(L1A_SYMB(I)(1:2).NE.'H '.AND.
     *    L1A_SYMB(I)(1:2).NE.'D ' )
     *    IAH = IAH + 1
      ENDDO  
      LML_NATM (L) = IA
      LML_NHATM(L) = IAH
      RETURN
      END

C ******
      SUBROUTINE CPL_NMLIB(MDOC,MON,IN,IERR)
C -----------------------------------------------
C -P- CP_NMLIB - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IN,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256
C -----------------------------------
      L=LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      DO   I=1,IN
        IF(LMN_NCONN.GE.MAXMCNN) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: number of connections for monomer ',MON,' >',MAXMCNN,
     *    ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMCNN in "lib_com.fh"')
          LML_IMON = 0           
          IERR = 1
          RETURN
        ENDIF
        LMN_NCONN=LMN_NCONN+1
        IF(LML_ICONN(L).EQ.0) LML_ICONN(L)=LMN_NCONN 
        LN            = LMN_NCONN
        LMN_MNAME(LN) = MON
        LMN_1ATM (LN) = L1N_1ATM (I)
        LMN_2ATM (LN) = L1N_2ATM (I)
        LMN_TYPE (LN) = L1N_TYPE (I)
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CPL_BMLIB(MDOC,MON,IB,IERR)
C -----------------------------------------------
C -P- CP_BMLIB - copies bond's information from library to special
C -P-            commons for one current monomer /L1M_BOND/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IB,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L = LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      DO   I=1,IB
        IF(LMB_NBOND.GE.MAXMBND) THEN
        WRITE(LINE,'(A,A8,A,I6,A)')' ERR: number of bonds for monomer '
     *    ,MON,'  >',MAXMBND,' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMBND in "lib_com.fh"')
          LML_IMON = 0           
          IERR = 1
          RETURN
        ENDIF
        LMB_NBOND = LMB_NBOND+1
        IF(LML_IBOND(L).EQ.0) LML_IBOND(L) = LMB_NBOND 
        LB            = LMB_NBOND
        LMB_MNAME(LB) = MON
        LMB_VAL  (LB) = L1B_VAL  (I)
        LMB_DEV  (LB) = L1B_DEV  (I)
        LMB_1ATM (LB) = L1B_1ATM (I)
        LMB_2ATM (LB) = L1B_2ATM (I)
        LMB_TYPE (LB) = L1B_TYPE (I)
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CPL_GMLIB(MDOC,MON,IG,IERR)
C -----------------------------------------------
C -P- CP_GMLIB - copies angle's information from library to special
C -P-            commons for one current monomer /L1M_ANGL/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IG,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L = LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      DO   I=1,IG
        IF(LMG_NANGL.GE.MAXMANG) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: number of angles for monomer ',MON,' >',MAXMANG,
     *    ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMANG in "lib_com.fh"')
          LML_IMON = 0           
          IERR = 1
          RETURN
        ENDIF
        LMG_NANGL = LMG_NANGL+1
        IF(LML_ITHET(L).EQ.0) LML_ITHET(L) = LMG_NANGL 
        LG            = LMG_NANGL
        LMG_MNAME(LG) = MON
        LMG_VAL  (LG) = L1G_VAL  (I)
        LMG_DEV  (LG) = L1G_DEV  (I)
        LMG_1ATM (LG) = L1G_1ATM (I)
        LMG_2ATM (LG) = L1G_2ATM (I)
        LMG_3ATM (LG) = L1G_3ATM (I)
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CPL_TMLIB(MDOC,MON,IT,IERR)
C -----------------------------------------------
C -P- CP_TMLIB - copies tortion's information from library to special
C -P-            commons for one current monomer /L1M_TORS/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IT,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L = LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      DO   I=1,IT
        IF(LMT_NTORS.GE.MAXMTOR) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: number of torsions for monomer ',MON,' >',MAXMTOR,
     *     ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMTOR in "lib_com.fh"')

          LML_IMON = 0           
          IERR = 1
          RETURN
        ENDIF
        LMT_NTORS = LMT_NTORS+1
        IF(LML_ITORS(L).EQ.0) LML_ITORS(L) = LMT_NTORS 
        LT            = LMT_NTORS
        LMT_MNAME(LT) = MON
        LMT_VAL  (LT) = L1T_VAL  (I)
        LMT_DEV  (LT) = L1T_DEV  (I)
        LMT_1ATM (LT) = L1T_1ATM (I)
        LMT_2ATM (LT) = L1T_2ATM (I)
        LMT_3ATM (LT) = L1T_3ATM (I)
        LMT_4ATM (LT) = L1T_4ATM (I)
        LMT_PRD  (LT) = L1T_PRD  (I)
        LMT_LABEL(LT) = L1T_LABEL(I)
      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CPL_CMLIB(MDOC,MON,IC,IERR)
C -----------------------------------------------
C -P- CP_CMLIB - copies chiralities from library to special
C -P-            commons for one current monomer /L1M_CHIR/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IC,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L = LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      DO   I=1,IC
        IF(LMC_NCHIR.GE.MAXMCHR) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *  ' ERR: number of chiralities for monomer ',MON,' >',MAXMCHR,
     *  ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMCHR in "lib_com.fh"')
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        LMC_NCHIR = LMC_NCHIR+1
        IF(LML_ICHIR(L).EQ.0) LML_ICHIR(L) = LMC_NCHIR 
        LC             = LMC_NCHIR
        LMC_MNAME (LC) = MON
        LMC_1ATM  (LC) = L1C_1ATM (I)
        LMC_2ATM  (LC) = L1C_2ATM (I)
        LMC_3ATM  (LC) = L1C_3ATM (I)
        LMC_4ATM  (LC) = L1C_4ATM (I)
        LMC_5ATM  (LC) = L1C_5ATM (I)
        LMC_6ATM  (LC) = L1C_6ATM (I)
        LMC_7ATM  (LC) = L1C_7ATM (I)
        LMC_8ATM  (LC) = L1C_8ATM (I)
        LMC_9ATM  (LC) = L1C_9ATM (I)
        LMC_SIGN  (LC) = L1C_SIGN (I)
        LMC_FLAG  (LC) = L1C_FLAG (I)

      ENDDO  
      RETURN
      END

C ******
      SUBROUTINE CPL_PMLIB(MDOC,MON,IP,IERR)
C -----------------------------------------------
C -P- CP_PMLIB - copies planarities from library to special
C -P-            commons for one current monomer /L1M_PLAN/ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IP,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C -----------------------------------
      L = LML_IMON
      IF(L.LE.0) THEN
        RETURN
      ENDIF
      DO   I=1,IP
        IF(LMP_NPLAN.GE.MAXMPLN) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: number of plan groups for monomer ',MON,' >',
     *    ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMPLN in "lib_com.fh"')
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        LMP_NPLAN = LMP_NPLAN+1
        IF(LML_IPLAN(L).EQ.0) LML_IPLAN(L) = LMP_NPLAN 
        LP = LMP_NPLAN

        IF(L1P_NATOM(I).GT.MAXMAPL) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: number of plan atoms in monomer ',MON,' >',MAXMAPL,
     *    '  or = 0'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *   '           Change parameter MAXMAPL in "lib_com.fh"')
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        LMP_MNAME(LP) = MON
        LMP_NATOM(LP) = L1P_NATOM(I)
        LMP_LABEL(LP) = L1P_LABEL(I)
        DO   IA=1,L1P_NATOM(I)
          LMP_DEV   (IA,LP) = L1P_DEV  (IA,I)
          LMP_ATOM  (IA,LP) = L1P_ATOM (IA,I)
        ENDDO  
      ENDDO  
      RETURN
      END


C ******
      SUBROUTINE SET_FUSE_Y(MDOC,IERR)
C -----------------------------------------
C -P- SET_FUSE_Y - replacet use_flag "R" to "Y" 
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR
C ******
C -----------------------------------------
      INCLUDE 'lib_com.fh'
C --------------------------------
      IERR = 0
      IF(LML_NMON.LE.0) RETURN

      DO L=1,LML_NMON
        IF(LML_FUSE(L).EQ.'R') THEN
          LML_FUSE(L) = 'Y'
        ENDIF
      ENDDO

      RETURN
      END     

      SUBROUTINE CHECK_FUSE_R(MDOC,IERR)
C -----------------------------------------------
C
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER MON*8
C -----------------------------------
      IERR = 0
      IF(LML_NMON.LE.0) RETURN

      DO   LL=1,LML_NMON

        IF(LML_FUSE(LL).EQ.'R') THEN
 
          MON       = LML_MNAME(LL) 

          IA = LML_IATOM(LL)
          IN = LML_ICONN(LL)
          IB = LML_IBOND(LL)
          IG = LML_ITHET(LL)
          IT = LML_ITORS(LL)
          IP = LML_IPLAN(LL)
          IC = LML_ICHIR(LL)
  
          IF(LMA_NATOM.GT.0.AND.LMA_NATOM.GE.IA.AND.IA.GT.0) THEN
            DO   L=IA,LMA_NATOM
              IF(MON.EQ.LMA_MNAME(L)) LMA_MNAME(L) = '?'
            ENDDO
          ENDIF
          IF(LMN_NCONN.GT.0.AND.LMN_NCONN.GE.IN.AND.IN.GT.0) THEN
            DO   L=IN,LMN_NCONN
              IF(MON.EQ.LMN_MNAME(L)) LMN_MNAME(L) = '?'
            ENDDO
          ENDIF
          IF(LMB_NBOND.GT.0.AND.LMB_NBOND.GE.IB.AND.IB.GT.0) THEN
            DO   L=IB,LMB_NBOND
              IF(MON.EQ.LMB_MNAME(L)) LMB_MNAME(L) = '?'
            ENDDO
          ENDIF
          IF(LMG_NANGL.GT.0.AND.LMG_NANGL.GE.IG.AND.IG.GT.0) THEN
            DO   L=IG,LMG_NANGL
              IF(MON.EQ.LMG_MNAME(L)) LMG_MNAME(L) = "?"
            ENDDO
          ENDIF
          IF(LMT_NTORS.GT.0.AND.LMT_NTORS.GE.IT.AND.IT.GT.0) THEN
            DO   L=IT,LMT_NTORS
              IF(MON.EQ.LMT_MNAME(L)) LMT_MNAME(L) = '?'
            ENDDO
          ENDIF
          IF(LMC_NCHIR.GT.0.AND.LMC_NCHIR.GE.IC.AND.IC.GT.0) THEN
            DO   L=IC,LMC_NCHIR
              IF(MON.EQ.LMC_MNAME(L)) LMC_MNAME(L) = '?'
            ENDDO
          ENDIF
          IF(LMP_NPLAN.GT.0.AND.LMP_NPLAN.GE.IP.AND.IP.GT.0) THEN
            DO   L=IP,LMP_NPLAN
              IF(MON.EQ.LMP_MNAME(L)) LMP_MNAME(L) = '?'
            ENDDO
          ENDIF

          LML_IATOM(LL) = 0
          LML_ICONN(LL) = 0
          LML_IBOND(LL) = 0
          LML_ITHET(LL) = 0
          LML_ITORS(LL) = 0
          LML_IPLAN(LL) = 0
          LML_ICHIR(LL) = 0

C          LML_NATM (LL) = 0
C          LML_NHATM(LL) = 0

        ENDIF
      ENDDO
      RETURN
      END
    
C ******
      SUBROUTINE PUT_MNLIB(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PUT_MNLIB - reads monomer's library.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------------------
      IERR = 0

      CALL LENSTR_BL(ITL_CMP ,LCMP)
      CALL LENSTR_BL(ITL_CMPA,LCMPA)
      CALL LENSTR_BL(ITL_CMPR,LCMPR)
      CALL LENSTR_BL(ITL_CMPB,LCMPB)
      CALL LENSTR_BL(ITL_CMPG,LCMPG)
      CALL LENSTR_BL(ITL_CMPT,LCMPT)
      CALL LENSTR_BL(ITL_CMPC,LCMPC)
      CALL LENSTR_BL(ITL_CMPP,LCMPP)

C     IF(ITEM(1:11).EQ.'_chem_comp.') THEN

      IF(ITEM(1:LCMP).EQ.ITL_CMP(1:LCMP)) THEN

      ELSE IF(ITEM(1:LCMPA).EQ.ITL_CMPA(1:LCMPA)) THEN
        CALL PT_MATOM(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LCMPR).EQ.ITL_CMPR(1:LCMPR)) THEN
        IF(LML_IMON.GT.0) THEN
C       IF(LML_PRSNT(LML_IMON).NE.'M') THEN
        IF(LML_PRSNT(LML_IMON).NE.'M'.AND.LML_PASS(LML_IMON).LE.1) THEN
          CALL PT_CONNECT(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ENDIF
        ENDIF
      ELSE IF(ITEM(1:LCMPB).EQ.ITL_CMPB(1:LCMPB)) THEN
        CALL PT_MBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LCMPG).EQ.ITL_CMPG(1:LCMPG)) THEN
        IF(LML_IMON.GT.0) THEN
        IF(LML_PRSNT(LML_IMON).NE.'M') THEN
          CALL PT_MANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ENDIF
        ENDIF
      ELSE IF(ITEM(1:LCMPT).EQ.ITL_CMPT(1:LCMPT)) THEN
        IF(LML_IMON.GT.0) THEN
        IF(LML_PRSNT(LML_IMON).NE.'M') THEN
          CALL PT_MTORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ENDIF
        ENDIF
      ELSE IF(ITEM(1:LCMPC).EQ.ITL_CMPC(1:LCMPC)) THEN
        CALL PT_MCHIR(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LCMPP).EQ.ITL_CMPP(1:LCMPP)) THEN
        IF(LML_IMON.GT.0) THEN
        IF(LML_PRSNT(LML_IMON).NE.'M') THEN
          CALL PT_MPLAN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
        ENDIF
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MLIST(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C ---------------------------------------------
C -P- PT_MLIST - reads monomer's information: NAME,CODE1,NATOM,...
C                if LB_TFLAG = 'N' 
C                       read all, set flag LML_FUSE = 'Y' and
C                       LML_IMON = serial number of monomer in the list.
C                if LB_TFLAG = 'Y' 
C                       read only NAME if it is in the list LMB_MNAME of
C                       common/LMB_LIST/ which has been created before and
C                       if LML_fuse = 'Y'.
C                    
C                set LML_IMON = serial number of monomer in the list or
C                = 0 if this monomer's name hasn's been found in the list
C                        or if LML_FUSE was equel 'N'.
C -S-
C ---------------------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      CHARACTER LINE*256,MON*8
C ---
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------
      IERR = 0
      CALL LENSTR_BL(ITL_CMP_ID,LC_ID)
      IF(ITEM(1:LC_ID).EQ.ITL_CMP_ID(1:LC_ID)) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp.id :',DATA(1:8),
     *          ' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        IF(LB_TFLAG.EQ.'N') THEN
C         read all
          IF(LML_NMON.GE.MAXMLIST) THEN
            WRITE(LINE,'(A,I6,A)')' ERROR: number of monomers >',
     *      MAXMLIST,' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LML_NMON = 0
            IERR     = 1
            RETURN
          ENDIF

          MON=DATA(1:8)

          IF(LML_NMON.GT.0) THEN
            DO IM=1,LML_NMON
              IF(MON.EQ.LML_MNAME(IM))THEN
C !!!!
                WRITE(LINE,'(A,A8)')
     *      ' WARNING: duplicated name of monomer ',MON
                CALL MSGDOC(MDOC,LINE)
                CALL MSGDOC(MDOC,
     *  '          Last entry will be used.')
                LML_IMON = IM
                GO TO 100 
              ENDIF
            ENDDO
          ENDIF

          LML_NMON = LML_NMON+1
          LML_IMON = LML_NMON

 100      CONTINUE

          II                  = LML_IMON
          LML_MNAME (II)      = MON
          LML_MNAME2(II)      = MON(1:3)
          LML_FUSE  (II)      = 'N'
          LML_PRSNT (II)      = '.'
          LML_FORM  (II)      = '.'             
          LML_NAME  (II)      = '.'             
          LML_TYPE  (II)      = '.'             
          LML_CODE1 (II)      = '.'
          LML_PASS  (II)      = LB_PASS

        ELSE
C         read only name is in the list of monomers
          MON = DATA(1:8)
          IF(LML_NMON.LE.0) THEN
            CALL MSGERR(MDOC
     *      ,' ERROR: number of monomers in the list = 0')
            IERR = 1
            RETURN
          ENDIF
          DO L=1,LML_NMON
            IF(MON.EQ.LML_MNAME(L).AND.LML_FUSE(L).EQ.'Y') THEN
              LML_IMON = L
              RETURN
            ENDIF
          ENDDO
          LML_IMON = 0           
        ENDIF
        RETURN
      ENDIF
C COMLETENESS ????
C      DATA ITL_CMP_ID    /'_chem_comp.id                           '/
C      DATA ITL_CMP_3LT   /'_chem_comp.three_letter_code            '/
C      DATA ITL_CMP_TYP   /'_chem_comp.group                        '/
C      DATA ITL_CMP_NA    /'_chem_comp.number_atoms_all             '/
C      DATA ITL_CMP_NH    /'_chem_comp.number_atoms_nh              '/
C      DATA ITL_CMP_NAM   /'_chem_comp.name                         '/
C      DATA ITL_CMP_FOR   /'_chem_comp.formula                      '/
C      DATA ITL_CMP_DSC   /'_chem_comp.desc_level                   '/
      CALL LENSTR_BL(ITL_CMP_3LT ,L3LT)
      CALL LENSTR_BL(ITL_CMP_TYP ,LTYP)
      CALL LENSTR_BL(ITL_CMP_NA  ,LNA)
      CALL LENSTR_BL(ITL_CMP_NH  ,LNH)
      CALL LENSTR_BL(ITL_CMP_NAM ,LNM)
      CALL LENSTR_BL(ITL_CMP_DSC ,LDS)

      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(12:26).EQ.'one_letter_code'  ) THEN
          LML_CODE1(LML_IMON)=DATA(1:1)
        ELSE IF(ITEM(1:L3LT).EQ.ITL_CMP_3LT(1:L3LT)) THEN
          LML_MNAME2(LML_IMON)=DATA(1:LEND)
        ELSE IF(ITEM(1:LTYP).EQ.ITL_CMP_TYP(1:LTYP)) THEN
          LML_TYPE (LML_IMON)=DATA(1:LEND)
        ELSE IF(ITEM(1:LNA).EQ.ITL_CMP_NA(1:LNA)) THEN
          LML_NATM (LML_IMON)=IDATA
        ELSE IF(ITEM(1:LNH).EQ.ITL_CMP_NH(1:LNH)) THEN
          LML_NHATM (LML_IMON)=IDATA
        ELSE IF(ITEM(1:LNM).EQ.ITL_CMP_NAM(1:LNM)) THEN
          LML_NAME(LML_IMON)=DATA(1:LEND)
        ELSE IF(ITEM(12:18).EQ.'formula') THEN
          LML_FORM(LML_IMON)=DATA(1:LEND)
        ELSE IF(ITEM(1:LDS).EQ.ITL_CMP_DSC(1:LDS)) THEN
          IF(DATA(1:1).EQ.'m') DATA(1:1) = 'M'
          LML_PRSNT(LML_IMON)=DATA(1:1)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MSYN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MSYN - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8
C -----------------------------------
      IERR=0
     
      IST = 1
      IF(ITEM(1:24).EQ.'_chem_comp_synonym_atom.' ) THEN
        IST = 25 
      ELSE IF(ITEM(1:19).EQ.'_chem_comp_synonym.' ) THEN
        IST = 20 
      ENDIF

      IFN = IST + 6
      IF(ITEM(IST:IFN).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')
     *    ' ERR: item _chem_comp_synonym.comp_id :',DATA(1:8),
     *    ' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF

        MON = DATA(1:8)

c        IF(LML_NMON.LE.0) THEN
c          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
c          IERR = 1
c          RETURN
c        ENDIF

        IF(LML_IMON.EQ.0) LML_IMON=1

c        DO J=1,LML_NMON
c          L = (LML_IMON-1)+J
c          IF(L.GT.LML_NMON) L = L-LML_NMON
c          IF(MON.EQ.LML_MNAME(L)) THEN
c            IF(LML_FUSE(L).NE.'Y'.OR.LB_PASS.NE.LML_PASS(L)) THEN
c              LML_IMON = 0           
c              RETURN
c            ENDIF
c            LML_IMON = L

            LMS_NSYN = LMS_NSYN + 1
            IF(LMS_NSYN.GT.MAXMLIST) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERROR: read number of synonyms',MON,' >',MAXMLIST,
     *      ' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LML_IMON = 0           
              IERR     = 1
              RETURN
            ENDIF

c            IF(LML_ISYN(L).EQ.0) LML_ISYN(L) = LMS_NSYN 

            LMS_MNAME (LMS_NSYN) = DATA(1:8)
            LMS_ATOM  (LMS_NSYN) = '.'
            LMS_AATOM (LMS_NSYN) = '.'
            LMS_AMNAME(LMS_NSYN) = '.'
            LMS_MOD   (LMS_NSYN) = '.'
            LMS_FLAG  (LMS_NSYN) = '.'
            IF(LB_PASS.GT.LB_NUMB_LIB) LMS_FLAG(LMS_NSYN) = 'N'
            LMS_ISYN             = 0

            RETURN
c          ENDIF
c        ENDDO

c        WRITE(LINE,'(
c     *  '' ERROR: item _chem_comp_synonym.comp_id :'',A8
c     *          ,'' not found in the monomer list'')') MON
c        CALL MSGERR(MDOC,LINE)
c        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
c        CALL MSGERR(MDOC,LINE)
c        LML_IMON = 0           
c        IERR     = 1
c        RETURN

      ENDIF

C COMLETENESS ????

      IFNAT = IST + 6
      IFNMD = IST + 5
      IFNAA = IST + 10
      IFNCM = IST + 10
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(IST:IFNAT).EQ.'atom_id'  ) THEN
          LMS_ATOM  (LMS_NSYN) = DATA(1:4)
        ELSE IF(ITEM(IST:IFNMD).EQ.'mod_id'   ) THEN
          LMS_MOD   (LMS_NSYN) = DATA(1:LEND)
        ELSE IF(ITEM(IST:IFNAA).EQ.'atom_altern') THEN
          LMS_AATOM (LMS_NSYN) = DATA(1:4)
        ELSE IF(ITEM(IST:IFNCM).EQ.'comp_altern') THEN
          LMS_AMNAME(LMS_NSYN) = DATA(1:8)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDER(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDER - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8
C -----------------------------------
      IERR = 0           
      IF(ITEM(18:24).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')
     *     ' ERR: item _chem_comp_deriv.comp_id :',DATA(1:8),
     *     ' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDR_IDER = 0           
          IERR     = 1
          RETURN
        ENDIF

        MON =  DATA(1:8)

        IF(LDR_NDER.GE.MAXMLIST) THEN
          WRITE(LINE,'(A,A8,A,I6,A)')' ERR: read number of derivatives '
     *      ,MON,'  >',MAXMLIST,' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
          LDR_IDER = 0           
          IERR     = 1
          RETURN
        ENDIF
        LDR_NDER = LDR_NDER+1
        LDR_IDER = LDR_NDER

        LDR_MNAME (LDR_NDER) = DATA(1:8)
        LDR_TYPE  (LDR_NDER) = '.'
        LDR_NAME  (LDR_NDER) = '.'
        LDR_SMNAME(LDR_NDER) = '.'
        LDR_MOD   (LDR_NDER) = '.'
      ENDIF

C COMLETENESS ????
      IF(LDR_IDER.GT.0.AND.I.GT.1) THEN
        IF(ITEM(18:23).EQ.'mod_id'  ) THEN
          LDR_MOD    (LDR_NDER)=DATA(1:LEND)
        ELSE IF(ITEM(18:31).EQ.'source_comp_id') THEN
          LDR_SMNAME (LDR_NDER)=DATA(1:LEND)
        ELSE IF(ITEM(18:21).EQ.'name') THEN
          LDR_NAME   (LDR_NDER)=DATA(1:LEND)
        ELSE IF(ITEM(18:22).EQ.'group') THEN
          LDR_TYPE   (LDR_NDER)=DATA(1:LEND)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MATOM(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MATOM - reads library information about atoms.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8,ASYMB*4,LMON*8,TYPE*1,CH1*1
C -----------------------------------
      IERR = 0
      IF(ITEM(17:23).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_atom.comp_id :',
     *    DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:LEND)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
          IERR = 1
          RETURN
        ENDIF

        IF(LML_IMON.EQ.0) LML_IMON = 1

        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          LMON = LML_MNAME(L)
          CALL LENSTR_BL(LMON,LENL)
        
          IF(MON(1:LEND).EQ.LMON(1:LENL)) THEN

            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON  = L
c            LML_NATM (L) = LML_NATM(L) +1
c            LML_NHATM(L) = LML_NHATM(L)+1
            LMA_NATOM = LMA_NATOM+1
            IF(LMA_NATOM.GT.MAXMATM) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *       ' ERR: read number of atoms for monomer ',MON,' >',MAXMATM,
     *           ' /lib.limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LML_IMON = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LML_IATOM(L).EQ.0) LML_IATOM(L) = LMA_NATOM 
            LMA_MNAME(LMA_NATOM) = DATA(1:LEND)
            LMA_X    (LMA_NATOM) = 0.0
            LMA_Y    (LMA_NATOM) = 0.0
            LMA_Z    (LMA_NATOM) = 0.0
            LMA_BACK (LMA_NATOM) = '.'
            LMA_TYPE (LMA_NATOM) = '.'
            LMA_FORW (LMA_NATOM) = '.'
            LMA_CHEM (LMA_NATOM) = '.'
            LMA_SYMB (LMA_NATOM) = '.'
            LMA_CHARG(LMA_NATOM) = 0.0
            LMA_COOR_FLAG(LMA_NATOM)='N'
            RETURN
          ENDIF

        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_atom.comp_id :',
     *      MON,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:23).EQ.'atom_id'  ) THEN
          CALL LENSTR_BL(DATA,LD)
          IF(LD.GT.4) THEN        
            DATA(4:4) = DATA(5:5) 
          ENDIF
C ---
          CALL CORR_H_ATOM_NAME(DATA)
C ---
          LMA_ANAME(LMA_NATOM) = DATA(1:4)

        ELSE IF(ITEM(17:27).EQ.'type_symbol'   ) THEN

          ASYMB = DATA(1:4)
          IT = 1
C
C         IT = 1  convert symbols to upper case.
C                   
          CALL CHECK_LINE(IT,ASYMB)             
          CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
          IF(IERR.EQ.2) THEN
            MON  =  LML_MNAME(LML_IMON)
            LINE ='          monomer:'//MON
            CALL MSGERR(MDOC,LINE)
            IERR = 0
          ENDIF
          IF(IERR.NE.0) RETURN

          LMA_SF_ID(LMA_NATOM) = INSF
          LMA_SYMB (LMA_NATOM) = ASYMB

        ELSE IF(ITEM(17:27).EQ.'type_energy'   ) THEN
          LMA_CHEM(LMA_NATOM) = DATA(1:4)
        ELSE IF(ITEM(17:30).EQ.'partial_charge') THEN
          LMA_CHARG(LMA_NATOM) = FDATA
        ELSE IF(ITEM(17:22).EQ.'charge') THEN
          LMA_CHARG(LMA_NATOM) = FDATA
        ELSE IF((ITEM(17:17).EQ.'x').OR.
     *          (ITEM(17:29).EQ.'model_Cartn_x')) THEN
          LMA_X(LMA_NATOM) = FDATA
          LMA_COOR_FLAG(LMA_NATOM) = 'Y'
          IF(DATA(1:1).EQ.'.'.AND.LEND.EQ.1)
     *           LMA_COOR_FLAG(LMA_NATOM) = 'N'
        ELSE IF((ITEM(17:17).EQ.'y').OR.
     *          (ITEM(17:29).EQ.'model_Cartn_y')) THEN
          LMA_Y(LMA_NATOM)     = FDATA
        ELSE IF((ITEM(17:17).EQ.'z').OR.
     *          (ITEM(17:29).EQ.'model_Cartn_z')) THEN
          LMA_Z(LMA_NATOM)     = FDATA
        ELSE IF(ITEM(17:20).EQ.'back') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMA_BACK (LMA_NATOM) = DATA(1:4)
        ELSE IF(ITEM(17:23).EQ.'forward') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMA_FORW (LMA_NATOM) = DATA(1:4)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     


      SUBROUTINE CORR_H_ATOM_NAME(DATA)
C -----------------------------------
      CHARACTER DATA*(*),TYPE*1,CH1*1
C -----------------------------------
      IF(DATA(1:1).EQ.' ') THEN
        DATA(1:1) = DATA(2:2) 
        DATA(2:2) = DATA(3:3) 
        DATA(3:3) = DATA(4:4) 
        DATA(4:4) = ' ' 
      ENDIF
      CH1 = DATA(1:1)
      CALL CHKSMB(CH1,TYPE)
      IF(TYPE.EQ.'D'.OR.CH1.EQ.''''.OR.CH1.EQ.'"'.OR.CH1.EQ.'*')THEN
        IF(DATA(4:4).EQ.' ') DATA(4:4) = '_'
        IF(DATA(3:3).EQ.' ') DATA(3:3) = '_'
        DATA(1:1) = DATA(2:2) 
        DATA(2:2) = DATA(3:3) 
        DATA(3:3) = DATA(4:4) 
        DATA(4:4) = CH1 
      ENDIF 
      RETURN
      END

C ******
      SUBROUTINE PT_CONNECT(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_CONNECT -
C -S-
C -------------------------------------------------------
C ******
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---
      COMMON/COM_CRD_CIF/ IEND_CIF      
C ---
      COMMON/COM_CONN_LIB/ MON,ATOM,BACK,FORW,TYPE,CONN      
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8,ATOM*4
      CHARACTER BACK*4,FORW*4,TYPE*8,CONN*8
C -----------------------------------
      IERR=0

      IF(ITEM(17:23).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_tree.comp_id :',
     *    DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:8)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list = 0')
          WRITE(LINE,'(A,A8,A)')'      monomer :',MON,
     *          ' not found in the monomer list'
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF
        IF(LML_IMON.EQ.0) LML_IMON = 1
        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          IF(MON.EQ.LML_MNAME(L)) THEN
            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON = L
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_tree.comp_id :',
     *          MON,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN
      ENDIF

      IF(ITEM(17:23).EQ.'atom_id'.AND.LML_IMON.GT.0.AND.I.GT.1 ) THEN 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _chem_comp_tree.atom_id :',
     *    DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        L    = LML_IMON
        MON  = LML_MNAME(L)
        CALL CORR_H_ATOM_NAME(DATA)
        ATOM = DATA(1:4)

        IA        = LML_IATOM(L)
        CALL COUNT_NATOM_LIB(MDOC,MON,IA,NATOM,NHATOM,IERR)
        IF(IERR.NE.0) RETURN
        LML_NATM  (L) = NATOM
        LML_NHATM (L) = NHATOM

        IF(LML_NATM(L).LE.0) THEN
          WRITE(LINE,'(A,A7,A)')
     *    ' ERR: number of atoms in the monomer ',MON,' = 0'
          CALL MSGERR(MDOC,LINE)
          IERR = 1
          RETURN
        ENDIF

        DO J=1,LML_NATM(L)
          IA = LML_IATOM(L)+J-1
          IF(ATOM.EQ.LMA_ANAME(IA)) THEN
            LMA_IATOM = IA
            RETURN
          ENDIF
        ENDDO

        WRITE(LINE,'(A,A,A)')' ERR: item _chem_comp_tree.atom_id :',
     *     ATOM,' not found in the atom list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' MON,BLOCK :'',A,A)') MON,BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN

      ENDIF

C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.2) THEN
        IF(LMA_IATOM.GT.0) THEN
          IF(ITEM(17:25).EQ.'atom_back'  ) THEN
            IF(DATA(1:3).EQ.'n/a') DATA = '.   '
            CALL CORR_H_ATOM_NAME(DATA)
            BACK=DATA(1:4)
          ELSE IF(ITEM(17:25).EQ.'back_type'  ) THEN
            TYPE=DATA(1:8)
          ELSE IF(ITEM(17:28).EQ.'atom_forward'  ) THEN
            IF(DATA(1:3).EQ.'n/a') DATA = '.   '
            CALL CORR_H_ATOM_NAME(DATA)
            FORW=DATA(1:4)
          ELSE IF(ITEM(17:28).EQ.'connect_type'  ) THEN
            CONN=DATA(1:8)
          ENDIF

C         ELSE
c          IF(ITEM(28:44).EQ.'connect_atom_id_1'  ) THEN
c            LMN_1ATM(LMN_NCONN)=DATA(1:4)
c          ELSE IF(ITEM(28:44).EQ.'connect_atom_id_2'  ) THEN
c            LMN_2ATM(LMN_NCONN)=DATA(1:4)
C          ENDIF

        ENDIF
      ENDIF

      IF(I.EQ.N_CIF.AND.LML_IMON.GT.0) THEN

        IF(CONN(1:3).EQ.'ADD') THEN
          L         = LML_IMON
          LMA_IATOM = 0
          LMN_NCONN = LMN_NCONN+1
          IF(LMN_NCONN.GT.MAXMCNN) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of connections for monomer '
     *      ,MON,'  >',MAXMCNN,'/lib.limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LML_IMON = 0           
            IERR=1
            RETURN
          ENDIF
          IF(LML_ICONN(L).EQ.0) LML_ICONN(L)=LMN_NCONN 
          LMN_MNAME(LMN_NCONN)  = MON
          LMN_1ATM (LMN_NCONN)  = ATOM
          LMN_2ATM (LMN_NCONN)  = BACK
          LMN_TYPE (LMN_NCONN)  = TYPE

        ELSE

          LMA_BACK(LMA_IATOM) = BACK
          IF(CONN(1:5).EQ.'DUMMY') THEN
            LMA_TYPE(LMA_IATOM) = CONN
          ELSE
            LMA_TYPE(LMA_IATOM) = '.'
          ENDIF
          LMA_FORW(LMA_IATOM) = FORW
          IF(CONN(1:5).EQ.'START') THEN
            LMA_BACK(LMA_IATOM) = '.'
          ELSE IF(CONN(1:3).EQ.'END') THEN
            LMA_FORW(LMA_IATOM) = 'END'
          ENDIF

        ENDIF

      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MBOND - reads library information about bonds.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8,TYPE*1,CH1*1
C -----------------------------------
      IERR=0
      IF(ITEM(17:23).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_bond.comp_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:8)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LML_IMON.EQ.0) LML_IMON=1
        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          IF(MON.EQ.LML_MNAME(L)) THEN
            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON  = L
            LMB_NBOND = LMB_NBOND+1
            IF(LMB_NBOND.GT.MAXMBND) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *     ' ERR: read number of bonds for monomer '
     *        ,MON,'  >',MAXMBND,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LML_IMON = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LML_IBOND(L).EQ.0) LML_IBOND(L) = LMB_NBOND 
            LMB_MNAME(LMB_NBOND) = DATA(1:8)
            LMB_1ATM (LMB_NBOND) = '.'
            LMB_2ATM (LMB_NBOND) = '.'
            LMB_TYPE (LMB_NBOND) = '.'
            LMB_DEV  (LMB_NBOND) = 0.0
            LMB_VAL  (LMB_NBOND) = 0.0
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_bond.comp_id :'
     *          ,MON,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:25).EQ.'atom_id_1'  ) THEN
          CALL LENSTR_BL(DATA,LD)
          IF(LD.GT.4) THEN
            DATA(4:4) = DATA(5:5) 
          ENDIF
C ---
          CALL CORR_H_ATOM_NAME(DATA)
C ---
          LMB_1ATM (LMB_NBOND)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_2'  ) THEN
          CALL LENSTR_BL(DATA,LD)
          IF(LD.GT.4) THEN
            DATA(4:4) = DATA(5:5) 
          ENDIF
C ---
          CALL CORR_H_ATOM_NAME(DATA)
C ---
          LMB_2ATM (LMB_NBOND)=DATA(1:4)
        ELSE IF((ITEM(17:20).EQ.'type').OR.
     *          (ITEM(17:27).EQ.'value_order')) THEN
          IF(DATA.EQ.'SING') DATA = 'single'
          IF(DATA.EQ.'DOUB') DATA = 'double'
          IF(DATA.EQ.'TRIP') DATA = 'triple'
          IF(DATA.EQ.'AROM') DATA = 'arom'
          IF(DATA.EQ.'META') DATA = 'metal'
          IF(DATA.EQ.'DELO') DATA = 'deloc'
          LMB_TYPE (LMB_NBOND)=DATA(1:8)
        ELSE IF(ITEM(17:30).EQ.'value_dist_esd') THEN
          LMB_DEV  (LMB_NBOND)=FDATA
        ELSE IF(ITEM(17:26).EQ.'value_dist') THEN
          LMB_VAL  (LMB_NBOND)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     
C ******

      SUBROUTINE PT_MANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MANGL - read library information about angles.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8
C -----------------------------------
      IERR=0
      IF(ITEM(18:24).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_angle.comp_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:8)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
          IERR = 1
          RETURN
        ENDIF
        IF(LML_IMON.EQ.0) LML_IMON = 1
        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          IF(MON.EQ.LML_MNAME(L)) THEN
            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON  = L
            LMG_NANGL = LMG_NANGL+1
            IF(LMG_NANGL.GT.MAXMANG) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *    ' ERR: read number of angles for monomer '
     *        ,MON,'  >',MAXMANG,'/lib.limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LML_IMON = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LML_ITHET(L).EQ.0) LML_ITHET(L) = LMG_NANGL 
            LMG_MNAME(LMG_NANGL) = DATA(1:8)
            LMG_1ATM (LMG_NANGL) = '.'
            LMG_2ATM (LMG_NANGL) = '.'
            LMG_3ATM (LMG_NANGL) = '.'
            LMG_DEV  (LMG_NANGL) = 0.0
            LMG_VAL  (LMG_NANGL) = 0.0
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A),')' ERR: item _chem_comp_angle.comp_id :'
     *          ,MON,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(18:26)     .EQ.'atom_id_1'  ) THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMG_1ATM (LMG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(18:26).EQ.'atom_id_2'  ) THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMG_2ATM (LMG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(18:26).EQ.'atom_id_3'  ) THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMG_3ATM (LMG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(18:32).EQ.'value_angle_esd') THEN
          LMG_DEV  (LMG_NANGL)=FDATA
        ELSE IF(ITEM(18:28).EQ.'value_angle') THEN
          LMG_VAL  (LMG_NANGL)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MTORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MTORS - reads library information about torsion angles.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8
C -----------------------------------
      IERR=0
      IF(ITEM(16:22).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_tor.comp_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:8)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LML_IMON.EQ.0) LML_IMON=1
        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          IF(MON.EQ.LML_MNAME(L)) THEN
            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON  = L
            LMT_NTORS = LMT_NTORS+1
            IF(LMT_NTORS.GT.MAXMTOR) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of tors for monomer ',MON,' >'
     *        ,MAXMTOR,'/lib.limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LML_IMON = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LML_ITORS(L).EQ.0) LML_ITORS(L) = LMT_NTORS 
            LMT_MNAME(LMT_NTORS) = DATA(1:8)
            LMT_1ATM (LMT_NTORS) = '.'
            LMT_2ATM (LMT_NTORS) = '.'
            LMT_3ATM (LMT_NTORS) = '.'
            LMT_4ATM (LMT_NTORS) = '.'
            LMT_LABEL(LMT_NTORS) = '.'
            LMT_DEV  (LMT_NTORS) = 0.0
            LMT_VAL  (LMT_NTORS) = 0.0
            LMT_PRD  (LMT_NTORS) = 0
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_tor.comp_id :'
     *          ,MON,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(16:30).EQ.'value_angle_esd' ) THEN
          LMT_DEV  (LMT_NTORS)=FDATA
        ELSE IF(ITEM(16:26).EQ.'value_angle') THEN
          LMT_VAL  (LMT_NTORS)=FDATA
        ELSE IF(ITEM(16:21).EQ.'period') THEN
          LMT_PRD  (LMT_NTORS)=IDATA
        ELSE IF(ITEM(16:24).EQ.'atom_id_1') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMT_1ATM (LMT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_2') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMT_2ATM (LMT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_3') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMT_3ATM (LMT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_4') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMT_4ATM (LMT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:17).EQ.'id') THEN
          LMT_LABEL(LMT_NTORS)=DATA(1:8)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MPLAN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MPLAN - reads library information about plane_groups.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      COMMON/STTCPLN/ DEV,ISATOM,LABEL,MNAME
      REAL      DEV
      INTEGER*4 ISATOM
      CHARACTER LABEL*8,MNAME*8
C ---
      INTEGER*4 IATOM
      CHARACTER LINE*256,MON*8,ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C -----------------------------------
      IERR=0
      IF(ITEM(23:29).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')
     *   ' ERR: item _chem_comp_plane_atom.comp_id :',DATA(1:8)
     *    ,' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:8)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
          IERR = 1
          RETURN
        ENDIF
        IF(LML_IMON.EQ.0) LML_IMON=1
        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          IF(MON.EQ.LML_MNAME(L)) THEN
            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON = L
            MNAME    = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')
     *    ' ERR: item _chem_comp_plane_atom.comp_id :',MON
     *   ,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(23:30).EQ.     'plane_id'    ) THEN
          LABEL  = DATA(1:8)
        ELSE IF(ITEM(23:29).EQ.'atom_id') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          ATOM   = DATA(1:4)
          ISATOM = IATOM
        ELSE IF(ITEM(23:30).EQ.'dist_esd') THEN
          DEV    = FDATA
        ENDIF
      ENDIF

      IF(LML_IMON.GT.0.AND.I.EQ.4) THEN
        L = LML_IMON
        IF(LML_IPLAN(L).LE.LMP_NPLAN) THEN
          IF(LML_IPLAN(L).GT.0) THEN
            DO II=LML_IPLAN(L),LMP_NPLAN
               IF(LABEL.EQ.LMP_LABEL(II)) GO TO 100
            ENDDO
          ENDIF
          LMP_NPLAN = LMP_NPLAN + 1
          IF(LMP_NPLAN.GT.MAXMPLN) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *       ' ERR: read number of plans for monomer ',MNAME,' >'
     *     ,MAXMPLN,'/lib.limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LML_IMON = 0           
            IERR     = 1
            RETURN
          ENDIF
          IF(LML_IPLAN(L).EQ.0) LML_IPLAN(L) = LMP_NPLAN
          II            = LMP_NPLAN
          LMP_NATOM(II) = 0
          LMP_MNAME(II) = MNAME
 100      CONTINUE

          LMP_NATOM(II) = LMP_NATOM(II)+1
          IF(LMP_NATOM(II).GT.MAXMAPL) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of plans atom for monomer ',MNAME,
     *      '  >',MAXMAPL,' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LML_IMON = 0           
            IERR     = 1
            RETURN
          ENDIF
          LMP_LABEL(II)               = LABEL
          LMP_ATOM (LMP_NATOM(II),II) = ISATOM
          LMP_DEV  (LMP_NATOM(II),II) = DEV
        ENDIF
      ENDIF 
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MCHIR(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MCHIR - reads library information about chiralities.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MON*8
C -----------------------------------
      IERR=0
      IF(ITEM(17:23).EQ.'comp_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_chir.comp_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LML_IMON = 0           
          IERR     = 1
          RETURN
        ENDIF
        MON = DATA(1:8)
        IF(LML_NMON.LE.0) THEN
          CALL MSGERR(MDOC,' ERR: number of monomers in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LML_IMON.EQ.0) LML_IMON=1
        DO J=1,LML_NMON
          L = (LML_IMON-1)+J
          IF(L.GT.LML_NMON) L = L-LML_NMON
          IF(MON.EQ.LML_MNAME(L)) THEN
            IF(LML_FUSE(L).NE.'R'.OR.LB_PASS.NE.LML_PASS(L)) THEN
              LML_IMON = 0           
              RETURN
            ENDIF
            LML_IMON  = L
            LMC_NCHIR = LMC_NCHIR+1
            IF(LMC_NCHIR.GT.MAXMCHR) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *        ' ERR: read number of chiralities for monomer ',
     *        MON,'  >',MAXMCHR,'/lib.limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LML_IMON = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LML_ICHIR(L).EQ.0) LML_ICHIR(L) = LMC_NCHIR 
            LMC_MNAME(LMC_NCHIR) = DATA(1:8)
            LMC_1ATM (LMC_NCHIR) = '.'
            LMC_2ATM (LMC_NCHIR) = '.'
            LMC_3ATM (LMC_NCHIR) = '.'
            LMC_4ATM (LMC_NCHIR) = '.'
            LMC_5ATM (LMC_NCHIR) = '.'
            LMC_6ATM (LMC_NCHIR) = '.'
            LMC_7ATM (LMC_NCHIR) = '.'
            LMC_8ATM (LMC_NCHIR) = '.'
            LMC_9ATM (LMC_NCHIR) = '.'
            LMC_SIGN (LMC_NCHIR) = '.'
            LMC_FLAG (LMC_NCHIR) = 'N'
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_comp_chir.comp_id :',MON,
     *          ,' not found in the monomer list'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LML_IMON = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LML_IMON.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:27).EQ.'volume_sign'    ) THEN
          LMC_SIGN  (LMC_NCHIR)=DATA(1:8)
        ELSE IF(ITEM(17:30).EQ.'atom_id_centre') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_1ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_1') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_2ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_2') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_3ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_3') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_4ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_4') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_5ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_5') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_6ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_6') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_7ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_7') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_8ATM (LMC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_8') THEN
          CALL CORR_H_ATOM_NAME(DATA)
          LMC_9ATM (LMC_NCHIR)=DATA(1:4)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     


      SUBROUTINE INIT_CNT
C -------------------------------------------------------
C -P- INIT_CNT -   initialization counters of library.
C -S-
C -------------------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------------
C   
      DO   I=1,MAXMATM
        LMA_CHARG(I) = 0.0
        LMA_BACK (I) = '?'
        LMA_TYPE (I) = '.'
        LMA_FORW (I) = '?'
        LMA_ANAME(I) = '?'
        LMA_SYMB (I) = '?'
        LMA_CHEM (I) = '?'
      ENDDO
      LMA_NATOM = 0
      LMN_NCONN = 0
c      LDR_NDER  = 0
      LMB_NBOND = 0
      LMG_NANGL = 0
      LMT_NTORS = 0
      LMC_NCHIR = 0
      LMP_NPLAN = 0
      LLA_NATOM = 0
      LLN_NCONN = 0
      LLB_NBOND = 0
      LLG_NANGL = 0
      LLT_NTORS = 0
      LLC_NCHIR = 0
      LLP_NPLAN = 0
      LDA_NATOM = 0
      LDN_NCONN = 0
      LDB_NBOND = 0
      LDG_NANGL = 0
      LDT_NTORS = 0
      LDC_NCHIR = 0
      LDP_NPLAN = 0
      DO   I=1,MAXMLIST
        LML_PASS (I) = 0
        LML_IATOM(I) = 0
        LML_ICONN(I) = 0
        LML_IBOND(I) = 0
        LML_ITHET(I) = 0
        LML_ITORS(I) = 0
        LML_IPLAN(I) = 0
        LML_ICHIR(I) = 0
      ENDDO
      DO   I=1,MAXLLNK
        LLL_IATOM(I) = 0
        LLL_ICONN(I) = 0
        LLL_IBOND(I) = 0
        LLL_ITHET(I) = 0
        LLL_ITORS(I) = 0
        LLL_IPLAN(I) = 0
        LLL_ICHIR(I) = 0
      ENDDO
      DO   I=1,MAXDMDF
        LDL_IATOM(I) = 0
        LDL_ICONN(I) = 0
        LDL_IBOND(I) = 0
        LDL_ITHET(I) = 0
        LDL_ITORS(I) = 0
        LDL_IPLAN(I) = 0
        LDL_ICHIR(I) = 0
      ENDDO
      RETURN
      END


C ******
      SUBROUTINE WRT_LIB(MDOC,MODE,ICRD,IERR)
C -------------------------------------------------------
C -P- WRT_LIB - writes library to the file.
C
C     MODE:  TITC - titles only for new
C            TITA - all
C            TITL - 'Y', 'C', except 'N' , 'C'
C            MONL
C            MONC
C            MONA
C            MODL
C            MODC
C            MODA
C            LINL
C            LINC
C            LINA
C
C            STOP
C
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,ICRD
      CHARACTER MODE*4
C ******
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      INCLUDE 'crd_com.fh'
C ----------------------------------
      INTEGER*4 IATOM
      CHARACTER LINE*256
      CHARACTER ATOM*4,CH1_1*1,CH1_2*1,CH2*2,CH3*3,POINT*4
      CHARACTER TYPE*8,CH8*8,CHAR8*8
      CHARACTER WATOM1*6,WATOM2*6,WATOM3*6,WATOM4*6
      CHARACTER WATOM5*6,WATOM6*6,WATOM7*6,WATOM8*6,WATOM9*6
C     CHARACTER CH1_3*1,CH1_4*1,CH1_5*1,CH5*5
      CHARACTER STR*80,TITLE_M*80,CH4*4
      EQUIVALENCE (IATOM,ATOM)
      DATA POINT/'.   '/,TYPE/'.       '/
C -----------------------------------
  
      IF(MODE(1:3).EQ.'TIT') THEN
        IF(ICRD.EQ.0) THEN
          IF(LMO_FILE.EQ.' ') RETURN
          IERR=0
C         open file 
          IF(LMO_IUN.NE.0) THEN
            CALL MSGERR(MDOC,' ERR: output_lib_file was open before')
            IERR=1
            RETURN
          ENDIF
          M   = 99

C         IUN = 11
          IUN = CRO3_IUN
          CALL OPENFW(IUN,M,LMO_PATH,LMO_FILE,LMO_EXT,IERR)
          CRO3_IUN = IUN

          IF(IERR.NE.0) THEN
            CALL MSGERR(MDOC,' ERR: can''t open output_lib_file')
            RETURN
          ENDIF
          LMO_IUN = IUN
          WRITE(LINE,'(''global_'')') 
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_name   '',6X,A)') LB_NAME(1:16)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_version'',6X,A)') LB_VERS(1:16)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_update '',6X,A)') LB_DATE(1:16)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

C          WRITE(LINE
C     *  ,'(''# ------------------------------------------------'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''#'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''# ---   LIST OF MONOMERS ---'')')
          TITLE_M = '# ---   LIST OF MONOMERS ---'
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''#'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''data_comp_list'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ELSE 
          IF(ICRD.LE.0) THEN
            CALL MSGERR(MDOC,' ERR: output_CIFile isn''t open.')
            IERR=1
            RETURN
          ENDIF
          IUN = ICRD 
C          WRITE(LINE
C     *  ,'(''# ------------------------------------------------'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''#'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''# ---   LIST OF NEW MONOMERS ---'')')
          TITLE_M = '# ---   LIST OF NEW MONOMERS ---'
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''#'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''data_comp_list'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
        ENDIF

C        WRITE(LINE,'(''loop_'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.id'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.one_letter_code'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.name'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.type'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.number_atoms_all'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.number_atoms_nh'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)
C        WRITE(LINE,'(''_chem_comp.desc_level'')')
C        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        IF(LML_NMON.GT.0) THEN

c            WRITE(*,*) '-wrt-:',LB_NUMB_LIB,LML_NMON,MODE
c            WRITE(*,*) '-wrt:'
c     *      ,LML_MNAME(LML_NMON),LML_FUSE(LML_NMON),LML_PASS(LML_NMON)

          IFIRST_M = 0
          DO L=1,LML_NMON

            IF((LML_FUSE(L).EQ.'C'.AND.MODE.EQ.'TITC').OR. 
     *         (MODE.EQ.'TITA')                       .OR. 
     *         (LML_FUSE(L).NE.'N'.AND.LML_FUSE(L).NE.'?'.AND.
     *                                          MODE.EQ.'TITL')) THEN

c            WRITE(*,*) '-wrt:',l,LML_MNAME(l),LML_FUSE(l),LML_PASS(l)


              IF(IFIRST_M.EQ.0) THEN
                WRITE(LINE,'(A)')
     *  '# ------------------------------------------------'
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                LINE = TITLE_M
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.three_letter_code'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.group'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.number_atoms_all'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.number_atoms_nh'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.desc_level'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST_M = 1
              ENDIF
              CH3 = LML_MNAME2(L)(1:3)
              J   = LML_IATOM(L)
              NA  = 0
              NHA = 0                  
              IF(J.GT.0) THEN
                IF(LMA_NATOM.GT.0) THEN
                  DO IA=J,LMA_NATOM
                    IF(LMA_MNAME(IA).EQ.LML_MNAME(L)) THEN
                      NA = NA+1
                      IF(LMA_SYMB(IA).NE.'H   '.AND.
     *                   LMA_SYMB(IA).NE.'D   ') THEN
                        NHA=NHA+1
                      ENDIF
                    ENDIF           
                  ENDDO
                ENDIF
              ENDIF

              CH1_2 = ''''
              CH1_1 = LML_PRSNT(L)
              IF(CH1_1.EQ.' ') CH1_1 = '.'
              STR = LML_NAME(L)
              CALL LENSTR_BL(STR,LEN)
              IF(LEN.GT.36) LEN = 36
              IF(LEN.LT.36) THEN
                DO II=LEN+1,36
                  STR(II:II) = ' '
                ENDDO
              ENDIF
              IF(LML_MNAME(L)(1:1).NE.'?') THEN
                WRITE(LINE,100)
     *          LML_MNAME(L),CH3,CH1_2,STR(1:36),CH1_2
     *         ,LML_TYPE(L),NA,NHA,CH1_1
C     *        ,LML_NATM(L),LML_NHATM(L)
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
  100           FORMAT(A8,1X,A3,1X,A1,A36,A1,1X,A16,1X,I4,I4,1X,A1)
              ENDIF
            ENDIF
          ENDDO
        ELSE
          IF(MODE.NE.'TITC') THEN
            WRITE(LINE,'('' Number of monomers = 0'')')
            CALL MSGDOC(MDOC,LINE)
            LMO_IUN = 0
            RETURN
          ENDIF
        ENDIF

        IF(LMS_NEW.GT.0.OR.MODE.NE.'TITC') THEN
        IF(LMS_NSYN.GT.0) THEN
          IFIRST_M = 0

          DO L=1,LMS_NSYN
            IF((LMS_FLAG(L).EQ.'N'.OR.MODE.NE.'TITC').AND.
     *          LMS_ATOM(L).EQ.'.') THEN
              IF(IFIRST_M.EQ.0) THEN

                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''# ---   LIST OF SYNONYMS ---'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_synonym_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_chem_comp_synonym.comp_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST_M = 1
              ENDIF
              WRITE(LINE,200) 
     *        LMS_MNAME(L)
     *        ,LMS_AMNAME(L),LMS_MOD(L)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  200         FORMAT(A8,4X,A8,1X,A8)
            ENDIF
          ENDDO

          IFIRST_MM = 0

          DO L=1,LMS_NSYN
            IF((LMS_FLAG(L).EQ.'N'.OR.MODE.NE.'TITC').AND.
     *          LMS_ATOM(L).NE.'.') THEN
              IF(IFIRST_MM.EQ.0) THEN

                IF(IFIRST_M.EQ.0) THEN
                  WRITE(LINE,'(''#'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''# ---   LIST OF SYNONYMS ---'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                ENDIF

                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_synonym_atom_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym_atom.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_synonym_atom.comp_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_synonym_atom.atom_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                IFIRST_MM = 1
              ENDIF
              WATOM1 = LMS_ATOM(L)
              WATOM2 = LMS_AATOM(L)
              CALL CORR_NAME_CIF_OUT(WATOM1)
              CALL CORR_NAME_CIF_OUT(WATOM2)
              WRITE(LINE,201) 
     *        LMS_MNAME(L)
     *        ,LMS_AMNAME(L),WATOM1,WATOM2
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
 201          FORMAT(A8,4X,A8,1X,A6,1X,A6)
            ENDIF
          ENDDO


        ENDIF
        ENDIF

        IF(LLL_NLINK.GT.0) THEN
          IFIRST=0
          DO L=1,LLL_NLINK
            IF((LLL_FUSE(L).EQ.'C'.AND.MODE.EQ.'TITC').OR. 
     *         (MODE.EQ.'TITA')                       .OR. 
     *         (LLL_FUSE(L).NE.'N'.AND.LLL_FUSE(L).NE.'?'.AND.
     *                                 MODE.EQ.'TITL')) THEN
              IF(IFIRST.EQ.0) THEN 
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''# ---   LIST OF LINKS ---'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_link_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                WRITE(LINE,'(''_chem_link.one_letter_code'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                WRITE(LINE,'(''_chem_link.name'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.comp_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.mod_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.group_comp_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.comp_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.mod_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.group_comp_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST=1
              ENDIF
              WRITE(LINE,300) 
     *        LLL_LNAME(L)
     *        ,LLL_MON1(L),LLL_MOD1(L),LLL_TYPE1(L)
     *        ,LLL_MON2(L),LLL_MOD2(L),LLL_TYPE2(L)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  300         FORMAT(A8,1X,A8,1X,A8,1X,A8
     *                              ,1X,A8,1X,A8,1X,A8)
              WRITE(LINE,301) LLL_DETAIL(L)(1:24)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
 301          FORMAT(1X,A24)
            ENDIF
          ENDDO
        ENDIF

C        IF(LRL_NMON.GT.0.AND.MODE.NE.'TIT?') THEN
C          WRITE(LINE,'(''#'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE
C     *    ,'(''# ---   LIST OF RECOGNIZED LINKED MONOMERS ---'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''#'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''data_link_comp_list'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''loop_'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''_lib_link_comp_list_comp_id'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''_lib_link_comp_list_link_id'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          DO L=1,LRL_NMON
C            WRITE(LINE,310) 
C     *      LRL_MON(L),LRL_LINK(L)
C            CALL WRTSTR(IUN,MDOC,LINE,IERR)
C  310       FORMAT(1X,A3,2X,A8)
C          ENDDO
C        ENDIF

        IF(LDL_NMOD.GT.0) THEN
          IFIRST=0
          DO L=1,LDL_NMOD
            IF((LDL_FUSE(L).EQ.'C'.AND.MODE.EQ.'TITC').OR. 
     *         (MODE.EQ.'TITA')                       .OR. 
     *         (LDL_FUSE(L).NE.'N'.AND.LDL_FUSE(L).NE.'?'.AND.
     *                                 MODE.EQ.'TITL')) THEN
              IF(IFIRST.EQ.0) THEN 
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''# ---   LIST OF MODIFICATIONS ---'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_mod_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.one_letter_code'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.group_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.sub_mod_id'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.sub_mod_order'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST=1
              ENDIF

c              WRITE(CH2,'(I2)') LDL_ORDER(L)
c              IF(LDL_ORDER(L).EQ.0) CH2='. '

              WRITE(LINE,400) 
     *        LDL_MNAME(L),LDL_DETAIL(L),LDL_COMP(L),LDL_TYPE(L)
    
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  400         FORMAT(A8,1X,A48,1X,A8,1X,A8)
            ENDIF
          ENDDO
        ENDIF

c        IF(LMR_NREC.GT.0.AND.MODE.NE.'TITC') THEN
c          WRITE(LINE,'(''#'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE
c     *    ,'(''# ---   LIST OF RECOGNIZED MODIFIED MONOMERS ---'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''#'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''data_mod_comp_list'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''loop_'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''_chem_mod_comp.comp_id'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''_chem_mod_comp.mod_id'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''_chem_mod_comp.name'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          WRITE(LINE,'(''_chem_mod_comp.type'')')
c          CALL WRTSTR(IUN,MDOC,LINE,IERR)
c          DO L=1,LMR_NREC
c            WRITE(LINE,410) 
c     *      LMR_COMP(L),LMR_MNAME(L),LMR_DETAIL(L),LMR_TYPE(L)
c            CALL WRTSTR(IUN,MDOC,LINE,IERR)
c  410       FORMAT(1X,A3,5X,A8,1X,A48,1X,A8)
c          ENDDO
c        ENDIF

      ELSE IF(MODE(1:3).EQ.'MON'.OR.MODE(1:3).EQ.'LIN'.OR.
     *        MODE(1:3).EQ.'MOD') THEN

        IF(ICRD.GT.0) THEN
          IF(ICRD.LE.0) THEN
            CALL MSGERR(MDOC,' ERROR: output_CIFile isn''t open')
            IERR=1
            RETURN
          ENDIF
          IUN=ICRD 
        ELSE
          IF(LMO_IUN.EQ.0) THEN
            CALL MSGERR(MDOC,' ERR: output_lib_file isn''t open..')
            IERR=1
            RETURN
          ENDIF
          IUN=LMO_IUN 
        ENDIF

        IF(MODE(1:3).EQ.'LIN'.OR.MODE(1:3).EQ.'MOD') GO TO 6000


        IF(LML_NMON.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# --- DESCRIPTION OF MONOMERS ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          DO I=1,LML_NMON

            IF((LML_FUSE(I).EQ.'C'.AND.MODE.EQ.'MONC').OR.
     *         (MODE.EQ.'MONA')                       .OR.
     *         (LML_FUSE(I).NE.'N'.AND.LML_FUSE(I).NE.'?'.AND.
     *                                 MODE.EQ.'MONL')) THEN
              CH8 = LML_MNAME(I)
              IF(CH8(1:1).NE.'?') THEN
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_'',A8)') CH8
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF
              J=LML_IATOM(I)
              IF(J.GT.0) THEN
                ICOOR=0
                IF(LMA_NATOM.GT.0) THEN
                  DO L=J,LMA_NATOM
                    IF(LMA_MNAME(L).NE.CH8) GO TO 511
                    IF(LMA_COOR_FLAG(L).EQ.'N'.OR.
     *                 LMA_COOR_FLAG(L).EQ.'.'    ) ICOOR=1
                  ENDDO
                ENDIF
 511            CONTINUE
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.type_symbol'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.type_energy'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                IF(LML_PRSNT(I).NE.'M') THEN
                  WRITE(LINE,'(''_chem_comp_atom.partial_charge'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                ENDIF
                IF(ICOOR.EQ.0) THEN
                  WRITE(LINE,'(''_chem_comp_atom.x'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_atom.y'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_atom.z'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                ENDIF
                IF(LMA_NATOM.GT.0) THEN
                  DO L=J,LMA_NATOM
                    IF(LMA_MNAME(L).NE.CH8) GO TO 510
                    WATOM1 = LMA_ANAME(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
c                    IF(LML_PRSNT(I).NE.'M') THEN
                    IF(ICOOR.NE.0) THEN
                      WRITE(LINE,500) 
     *                LMA_MNAME(L),WATOM1
     *               ,LMA_SYMB(L),LMA_CHEM(L),LMA_CHARG(L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
  500                 FORMAT(1X,A8,6X,A6,1X,A4,1X,A4,3X,F8.3)
                    ELSE
                      WRITE(LINE,501) 
     *                LMA_MNAME(L),WATOM1
     *               ,LMA_SYMB(L),LMA_CHEM(L),LMA_CHARG(L)
     *               ,LMA_X(L),LMA_Y(L),LMA_Z(L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 501                  FORMAT(1X,A8,6X,A6,1X,A4,1X,A4,3X,F8.3
     *                ,3X,F8.3,1X,F8.3,1X,F8.3)
c                      WRITE(LINE,501) 
c     *                LMA_MNAME(L),WATOM1
c     *               ,LMA_SYMB(L),LMA_CHEM(L)
c                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
c 501                  FORMAT(1X,A8,1X,A6,1X,A4,1X,A4)
                    ENDIF
                  ENDDO
  510             CONTINUE
                ENDIF
              ENDIF
              J=LML_IATOM(I)
              K=LML_ICONN(I)
              IF(J.GT.0.AND.LML_PRSNT(I).NE.'M') THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.atom_back'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_comp_tree.back_type'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.atom_forward'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

C               WRITE(LINE
C    *          ,'(''_chem_comp_tree.additional_connect_atom_id_1'')')
C               CALL WRTSTR(IUN,MDOC,LINE,IERR)
C               WRITE(LINE
C    *          ,'(''_chem_comp_tree.additional_connect_atom_id_2'')')
C               CALL WRTSTR(IUN,MDOC,LINE,IERR)
c               WRITE(LINE
c    *          ,'(''_chem_comp_tree.additional_connect_type'')')
c               CALL WRTSTR(IUN,MDOC,LINE,IERR)

                WRITE(LINE
     *          ,'(''_chem_comp_tree.connect_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                IF(LMA_NATOM.GT.0) THEN
                  DO L=J,LMA_NATOM
                    IF(LMA_MNAME(L).NE.CH8) GO TO 610
C !!!
                    CHAR8 = LMA_TYPE(L)
                    IF(CHAR8.EQ.' ') CHAR8 = '.'
                    IF(LMA_BACK(L)(1:1).EQ.'.') CHAR8='START' 
                    IF(LMA_FORW(L).EQ.'END ') THEN
                      CHAR8       = 'END' 
                      LMA_FORW(L) = '.'
                    ENDIF
C !!!
                    CH4 = LMA_BACK(L)
                    IF(CH4(1:1).EQ.'.') CH4 = 'n/a '

                    WATOM1 = LMA_ANAME(L)
                    WATOM2 = CH4
                    WATOM3 = LMA_FORW(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)

                    WRITE(LINE,600) 
     *              LMA_MNAME(L)
     *             ,WATOM1,WATOM2,WATOM3
     *             ,CHAR8

C    *             ,POINT,POINT,TYPE
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
  600        FORMAT(1X,A8,1X,A6,1X,A6,1X,A6,1X,A8)
C 600        FORMAT(1X,A8,6X,A4,1X,A4,1X,A8,1X,A4,1X,A4,1X,A4,1X,A8)
                  ENDDO
  610             CONTINUE
                ENDIF
                IF(LMN_NCONN.GT.0.AND.K.GT.0) THEN
                  DO L=K,LMN_NCONN
                    IF(LMN_MNAME(L).NE.CH8) GO TO 620
                    CHAR8 = 'ADD'
                    WATOM1 = LMN_1ATM(L)
                    WATOM2 = LMN_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    WRITE(LINE,630)
     *              LMN_MNAME(L),WATOM1
     *             ,WATOM2,POINT,CHAR8

  630               FORMAT(1X,A8,1X,A6,1X,A6,1X,A,1X,A)

C    *              LMN_MNAME(L),POINT,POINT,TYPE,POINT,LMN_1ATM(L)
C    *             ,LMN_2ATM(L),LMN_TYPE(L)

                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDDO
  620             CONTINUE
                ENDIF
              ENDIF
              J=LML_IBOND(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LML_PRSNT(I).NE.'M') THEN
                  WRITE(LINE,'(''_chem_comp_bond.value_dist'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_bond.value_dist_esd'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                ENDIF
                IF(LMB_NBOND.GT.0) THEN
                  DO L=J,LMB_NBOND
                    IF(LMB_MNAME(L).NE.CH8) GO TO 710
                    ESD=LMB_DEV(L)
                    IF(ESD.LE.0.0) ESD=0.02
                    WATOM1 = LMB_1ATM(L)
                    WATOM2 = LMB_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    IF(LML_PRSNT(I).NE.'M') THEN
                      WRITE(LINE,700) 
     *                LMB_MNAME(L)
     *               ,WATOM1,WATOM2,LMB_TYPE(L),LMB_VAL(L)
     *               ,ESD
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
  700                 FORMAT(1X,A8,1X,A6,1X,A6,4X,A8,1X,F8.3,1X,F8.3)
                    ELSE
                      WRITE(LINE,701) 
     *                LMB_MNAME(L)
     *               ,WATOM1,WATOM2,LMB_TYPE(L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 701                  FORMAT(1X,A8,1X,A6,1X,A6,4X,A8)
                    ENDIF
                  ENDDO
  710             CONTINUE
                ENDIF
              ENDIF
              J=LML_ITHET(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LMG_NANGL.GT.0) THEN
                  DO L=J,LMG_NANGL
                    IF(LMG_MNAME(L).NE.CH8) GO TO 810
                    ESD=LMG_DEV(L)
                    IF(ESD.LE.0.0) ESD=3.0
                    WATOM1 = LMG_1ATM(L)
                    WATOM2 = LMG_2ATM(L)
                    WATOM3 = LMG_3ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)

                    WRITE(LINE,800) 
     *              LMG_MNAME(L)
     *             ,WATOM1,WATOM2,WATOM3,LMG_VAL(L)
     *             ,ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
  800               FORMAT(1X,A8,1X,A6,1X,A6,1X,A6,1X,F8.3,1X,F8.3)
                  ENDDO
  810             CONTINUE
                ENDIF
              ENDIF
              J=LML_ITORS(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_4'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.period'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LMT_NTORS.GT.0) THEN
                  IC=0
                  DO L=J,LMT_NTORS
                    IF(LMT_MNAME(L).NE.CH8) GO TO 910
                    ANGL=LMT_VAL(L)
                    IF(ANGL.GT. 180.0) ANGL=ANGL-360.0
                    IF(ANGL.LE.-180.0) ANGL=ANGL+360.0
                    IPRD=LMT_PRD(L)
                    ESD=LMT_DEV(L)
                    IF(ESD.LE.0.0) ESD = 20.0
                    CHAR8 =LMT_LABEL(L)
                    IF(IPRD.EQ.0) ESD=0.0
C !!!!
c                    IF(IPRD.EQ.0) IPRD=1
c                    IF(CHAR8(1:5).EQ.'CONST') THEN
c                      IPRD=0
c                      IC=IC+1
c                      IF(IC.GT.99) IC=99
c                      WRITE(CH2,'(I2)') IC
c                      IF(CH2(1:1).EQ.' ') CH2(1:1)='0'
c                      CHAR8='CONST_'//CH2
c  
c                      IF(IPRD.EQ.0) ESD=0.0
c
c                    ENDIF
C !!!
                    WATOM1 = LMT_1ATM(L) 
                    WATOM2 = LMT_2ATM(L) 
                    WATOM3 = LMT_3ATM(L)
                    WATOM4 = LMT_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)

                    WRITE(LINE,900) 
     *              LMT_MNAME(L),CHAR8
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,ANGL,ESD,IPRD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
  900               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A6,1X,A6,2X
     *              ,F8.3,1X,F8.3,1X,I3)
                  ENDDO

  910             CONTINUE
                ENDIF
              ENDIF
              J=LML_ICHIR(I)
              IF(J.GT.0) THEN
                IF(LMC_NCHIR.GT.0) THEN
                  IC     = 0
                  ICROSS = 0
                  DO L=J,LMC_NCHIR
                    IF(LMC_MNAME(L).NE.CH8) GO TO 1011
                    IF(LMC_SIGN(L)(1:6).EQ.'cross3'.OR.
     *                 LMC_SIGN(L)(1:6).EQ.'cross4'.OR.
     *                 LMC_SIGN(L)(1:6).EQ.'cross5'.OR.
     *                 LMC_SIGN(L)(1:6).EQ.'cross6'.OR.
     *                 LMC_SIGN(L)(1:5).EQ.'star5'.OR.
     *                 LMC_SIGN(L)(1:5).EQ.'star6'    ) ICROSS = 1
                  ENDDO
 1011             CONTINUE

                  WRITE(LINE,'(''loop_'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.comp_id'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.id'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_centre'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_1'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_2'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_3'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.volume_sign'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  IF(ICROSS.EQ.1) THEN
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_4'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_5'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_6'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_7'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_8'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDIF

                  DO L=J,LMC_NCHIR
                    IF(LMC_MNAME(L).NE.CH8) GO TO 1010
C !!
                    IC=IC+1
                    IF(IC.GT.99) IC=99
                    WRITE(CH2,'(I2)') IC
                    IF(CH2(1:1).EQ.' ') CH2(1:1)='0'
                    CHAR8='chir_'//CH2  
C !!!
                    WATOM1 = LMC_1ATM(L) 
                    WATOM2 = LMC_2ATM(L) 
                    WATOM3 = LMC_3ATM(L)
                    WATOM4 = LMC_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,1000) 
     *              LMC_MNAME(L),CHAR8
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,LMC_SIGN(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1000               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A6,1X,A6,4X,A8)
                    IF(ICROSS.EQ.1) THEN
                      WATOM5 = LMC_5ATM(L) 
                      WATOM6 = LMC_6ATM(L) 
                      WATOM7 = LMC_7ATM(L)
                      WATOM8 = LMC_8ATM(L)
                      WATOM9 = LMC_9ATM(L)
                      CALL CORR_NAME_CIF_OUT(WATOM5)
                      CALL CORR_NAME_CIF_OUT(WATOM6)
                      CALL CORR_NAME_CIF_OUT(WATOM7)
                      CALL CORR_NAME_CIF_OUT(WATOM8)
                      CALL CORR_NAME_CIF_OUT(WATOM9)
                      WRITE(LINE,1001) 
     *                WATOM5,WATOM6,WATOM7,WATOM8,WATOM9
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1001                 FORMAT(19X,A6,1X,A6,1X,A6,1X,A6,1X,A6)
                    ENDIF
                  ENDDO
 1010             CONTINUE
                ENDIF

              ENDIF
              J=LML_IPLAN(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.plane_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LMP_NPLAN.GT.0) THEN
                  DO L=J,LMP_NPLAN
                    IF(LMP_MNAME(L).NE.CH8) GO TO 1110
                    DO K=1,LMP_NATOM(L)
                      IATOM  = LMP_ATOM(K,L)
                      WATOM1 = ATOM
                      CALL CORR_NAME_CIF_OUT(WATOM1)
                      WRITE(LINE,1100) 
     *                LMP_MNAME(L)
     *               ,LMP_LABEL(L),WATOM1,LMP_DEV(K,L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1100                 FORMAT(1X,A8,1X,A8,2X,A6,1X,F8.3)
                    ENDDO
                  ENDDO
 1110             CONTINUE
                ENDIF
              ENDIF
            ENDIF
          ENDDO
        ENDIF

        IF(MODE(1:3).EQ.'MON') GO TO 6200

 6000   CONTINUE
        IF(MODE(1:3).EQ.'MOD') GO TO 6100


        IF(LLL_NLINK.GT.0) THEN
        IFIRST=0
        DO I=1,LLL_NLINK
          IF((LLL_FUSE(I).EQ.'C'.AND.MODE.EQ.'LINC').OR.
     *       (MODE.EQ.'LINA')                       .OR.
     *       (LLL_FUSE(I).NE.'N'.AND.LLL_FUSE(I).NE.'?'.AND.
     *                               MODE.EQ.'LINL')) THEN
            IF(IFIRST.EQ.0) THEN
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''# --- DESCRIPTION OF LINKS ---'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''#'')')
              IFIRST=1
            ENDIF
            CH8=LLL_LNAME(I)
            IF(LLL_NLINK.GT.1.AND.I.GT.1) THEN
              DO J=1,I-1
                IF(CH8.EQ.LLL_LNAME(J)) GO TO 6101
              ENDDO
            ENDIF
            WRITE(LINE,'(''#'')')
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            WRITE(LINE,'(''data_link_'',A8)') CH8
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            WRITE(LINE,'(''#'')')
            CALL WRTSTR(IUN,MDOC,LINE,IERR)


C           J=LLL_IATOM(I)
C           IF(J.GT.0) THEN
C              WRITE(LINE,'(''loop_'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_atom_link_id'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_atom_atom_id'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_atom_type_symbol'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_atom_type'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_atom_charge'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              IF(LLA_NATOM.GT.0) THEN
C                DO L=J,LLA_NATOM
C                  IF(LLA_MNAME(L).NE.CH8) GO TO 2510
C                  WRITE(LINE,2500) 
C     *            LLA_MNAME(L)
C     *           ,LLA_ANAME(L),LLA_SYMB(L),LLA_CHEM(L),LLA_CHARG(L)
C                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
C 2500             FORMAT(1X,A8,6X,A4,1X,A4,1X,A4,3X,F8.3)
C                ENDDO
C 2510           CONTINUE
C              ENDIF
C           ENDIF
C           J=LLL_IATOM(I)
C            J=LLL_ICONN(I)
C            IF(J.GT.0) THEN
C              WRITE(LINE,'(''loop_'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.link_id'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.comp_flag_atom'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.atom_id'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.comp_flag_back'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.atom_back'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.back_type'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.comp_flag_forward'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.atom_forward'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C              WRITE(LINE,'(''_chem_link_tree.connect_type'')')
C              CALL WRTSTR(IUN,MDOC,LINE,IERR)
C
C              IF(LLN_NCONN.GT.0) THEN
C                DO L=J,LLN_NCONN
C                  IF(LLN_LNAME(L).NE.CH8) GO TO 2610
C                  WRITE(CH1_1,'(I1)') LLN_FATOM(L)
C                  WRITE(CH1_2,'(I1)') LLN_FBACK(L)
C                  WRITE(CH1_3,'(I1)') LLN_FFORW(L)
C                  WRITE(CH1_4,'(I1)') LLN_F1ATM(L)
C                  WRITE(CH1_5,'(I1)') LLN_F2ATM(L)
C                  IF(CH1_1.EQ.'0') CH1_1='.'
C                  IF(CH1_2.EQ.'0') CH1_2='.'
C                  IF(CH1_3.EQ.'0') CH1_3='.'
C                  IF(CH1_4.EQ.'0') CH1_4='.'
C                  IF(CH1_5.EQ.'0') CH1_5='.'
C
C
C !!!
C                  LLN_TYPE(L)='.'
C !!!!
C                    CH4 = LLN_BACK(L)
C                    IF(CH4(1:1).EQ.'.') CH4 = 'n/a '
C
C                  WRITE(LINE,2600) 
C     *            LLN_LNAME(L),CH1_1
C     *           ,LLN_ATOM(L),CH1_2,CH4,LLN_BTYPE(L)
C     *           ,CH1_3,LLN_FORW(L),LLN_TYPE(L)
C
C     *           ,CH1_3,LLN_FORW(L)   ,CH1_4,LLN_1ATM(L)
C     *           ,CH1_5,LLN_2ATM(L),LLN_TYPE(L)
C
C                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
C 2600             FORMAT(1X,A8,1X,A1,1X,A4,1X,A1,1X,A4,1X,A8,1X,A1
C     *            ,1X,A4,1X,A8)
C 2600             FORMAT(1X,A8,1X,A1,1X,A4,1X,A1,1X,A4,1X,A8,1X,A1
C     *            ,1X,A4,1X,A1,1X,A4,1X,A1,1X,A4,1X,A8)
C                ENDDO
C 2610           CONTINUE
C              ENDIF
C            ENDIF

            J=LLL_IBOND(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.value_dist'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.value_dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLB_NBOND.GT.0) THEN
                  DO L=J,LLB_NBOND
                    IF(LLB_LNAME(L).NE.CH8) GO TO 2710
                    ESD=LLB_DEV(L)
                    IF(ESD.LE.0.0) ESD=0.02

                    WATOM1 = LLB_1ATM(L)
                    WATOM2 = LLB_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)


                    WRITE(LINE,2700) 
     *              LLB_LNAME(L),LLB_F1ATM(L),WATOM1
     *             ,LLB_F2ATM(L),WATOM2,LLB_TYPE(L)
     *             ,LLB_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 2700               FORMAT(1X,A8,1X,I1,1X,A6,2X,I1,1X,A6,4X,A8,1X
     *              ,F8.3,1X,F8.3)
                  ENDDO
 2710             CONTINUE
                ENDIF
            ENDIF
            J=LLL_ITHET(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_3_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLG_NANGL.GT.0) THEN
                  DO L=J,LLG_NANGL
                    IF(LLG_LNAME(L).NE.CH8) GO TO 2810
                    ESD=LLG_DEV(L)
                    IF(ESD.LE.0.0) ESD=3.0

                    WATOM1 = LLG_1ATM(L)
                    WATOM2 = LLG_2ATM(L)
                    WATOM3 = LLG_3ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)


                    WRITE(LINE,2800) 
     *              LLG_LNAME(L),LLG_F1ATM(L)
     *             ,WATOM1,LLG_F2ATM(L),WATOM2
     *             ,LLG_F3ATM(L),WATOM3
     *             ,LLG_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 2800               FORMAT(1X,A8,1X,I1,1X,A6,2X,I1,1X,A6,2X,I1,1X,A6
     *              ,1X,F8.3,1X,F8.3)
                  ENDDO
 2810             CONTINUE
                ENDIF
            ENDIF
            J=LLL_ITORS(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_3_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_4_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_4'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.period'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLT_NTORS.GT.0) THEN
                  DO L=J,LLT_NTORS
                    IF(LLT_LNAME(L).NE.CH8) GO TO 2910
                    ESD=LLT_DEV(L)
                    IF(ESD.LE.0.0) ESD=20.0
                    WATOM1 = LLT_1ATM(L) 
                    WATOM2 = LLT_2ATM(L)
                    WATOM3 = LLT_3ATM(L)
                    WATOM4 = LLT_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,2900) 
     *              LLT_LNAME(L),LLT_LABEL(L),LLT_F1ATM(L),WATOM1
     *             ,LLT_F2ATM(L),WATOM2      ,LLT_F3ATM(L),WATOM3
     *             ,LLT_F4ATM(L),WATOM4
     *             ,LLT_VAL(L),ESD,LLT_PRD(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 2900               FORMAT(1X,A8,1X,A8,1X,I1,1X,A6,1X,I1,1X,A6,1X,I1
     *              ,1X,A6,1X,I1,1X,A6,1X,F7.2,1X,F5.1,1X,I1)
                  ENDDO
 2910             CONTINUE
                ENDIF
            ENDIF
            J=LLL_ICHIR(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

C                WRITE(LINE,'(''_chem_link_chir.id'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)

           WRITE(LINE,'(''_chem_link_chir.atom_centre_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_centre'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_3_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.volume_sign'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLC_NCHIR.GT.0) THEN
                  DO L=J,LLC_NCHIR
                    IF(LLC_LNAME(L).NE.CH8) GO TO 3010
C !!!
                    CHAR8='.'
C !!!
                    WATOM1 = LLC_1ATM(L)
                    WATOM2 = LLC_2ATM(L)
                    WATOM3 = LLC_3ATM(L)
                    WATOM4 = LLC_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,3000) 
     *              LLC_LNAME(L),LLC_F1ATM(L),WATOM1
     *             ,LLC_F2ATM(L),WATOM2,LLC_F3ATM(L),WATOM3
     *             ,LLC_F4ATM(L),WATOM4
     *             ,LLC_SIGN(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 3000               FORMAT(1X,A8,3X,I1,1X,A6,2X,I1
     *              ,1X,A6,2X,I1,1X,A6,2X,I1,1X,A6,2X,A8)
                  ENDDO
 3010             CONTINUE
                ENDIF
            ENDIF
            J=LLL_IPLAN(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.plane_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.atom_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLP_NPLAN.GT.0) THEN
                  DO L=J,LLP_NPLAN
                    IF(LLP_LNAME(L).NE.CH8) GO TO 3110
                    DO K=1,LLP_NATOM(L)
                      IATOM = LLP_ATOM(K,L)
                      WATOM1 = ATOM
                      CALL CORR_NAME_CIF_OUT(WATOM1)
                      WRITE(LINE,3100) 
     *                LLP_LNAME(L),LLP_LABEL(L)
     *               ,LLP_FATOM(K,L),WATOM1,LLP_DEV(K,L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 3100                 FORMAT(1X,A8,3X,A8,2X,I1,1X,A6,1X,F8.3)
                    ENDDO
                  ENDDO
 3110             CONTINUE
                ENDIF
            ENDIF
          ENDIF
 6101     CONTINUE
        ENDDO
        ENDIF

 6100   CONTINUE
        IF(MODE(1:3).EQ.'LIN') GO TO 6200

        IF(LDL_NMOD.GT.0) THEN
        IFIRST=0
        DO I=1,LDL_NMOD
          IF((LDL_FUSE(I).EQ.'C'.AND.MODE.EQ.'MODC').OR.
     *       (MODE.EQ.'MODA')                       .OR.
     *       (LDL_FUSE(I).NE.'N'.AND.LDL_FUSE(I).NE.'?'.AND.
     *                               MODE.EQ.'MODL')) THEN
            IF(IFIRST.EQ.0) THEN
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''# --- DESCRIPTION OF MODIFICATIONS ---'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''#'')')
              IFIRST=1
            ENDIF
C            IF(LDL_SUB_MOD(I)(1:1).EQ.'.') THEN
              CH8=LDL_MNAME(I)
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''data_mod_'',A8)') CH8
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              J=LDL_IATOM(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_type_symbol'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_type_energy'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_partial_charge'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDA_NATOM.GT.0) THEN
                  DO L=J,LDA_NATOM
                    IF(LDA_MNAME(L).NE.CH8) GO TO 4510
                    WATOM1 = LDA_ANAME(L) 
                    WATOM2 = LDA_ANEW(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    WRITE(LINE,4500) 
     *              LDA_MNAME(L),LDA_FUNCT(L)
     *              ,WATOM1,WATOM2,LDA_SYMB(L),LDA_CHEM(L)
     *              ,LDA_CHARG(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4500               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A4,1X,A4,1X,F8.3)
                  ENDDO
 4510             CONTINUE
                ENDIF
              ENDIF
              J=LDL_IATOM(I)
              K=LDL_ICONN(I)
              IF(K.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.atom_back'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.back_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.atom_forward'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.connect_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                IF(LDN_NCONN.GT.0) THEN
                  DO L=K,LDN_NCONN
                    IF(LDN_MNAME(L).NE.CH8) GO TO 4610

C !!!!
C                    CHAR8='.'
C                    IF(LDN_BACK(L)(1:1).EQ.'.'.AND.
C     *                 LDN_FUNCT(L)(1:6).NE.'delete') THEN
C                      CHAR8='START' 
C                      LMA_BACK(L)='.'
C                    ENDIF
C                    IF(LDN_FORW(L)(1:3).EQ.'END') THEN 
C                      CHAR8='END' 
C                      LMA_FORW(L)='.'
C                    ENDIF
C                    LDN_TYPE(L)=CHAR8
C !!!!
                    CH4 = LDN_BACK(L)
                    IF(CH4(1:1).EQ.'.') CH4 = 'n/a '
                    WATOM1 = LDN_ATOM(L)
                    WATOM2 = CH4
                    WATOM3 = LDN_FORW(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)

                    WRITE(LINE,4600) 
     *              LDN_MNAME(L),LDN_FUNCT(L)
     *             ,WATOM1,WATOM2,LDN_BTYPE(L)
     *             ,WATOM3,LDN_TYPE(L)

c     *             ,LDN_FORW(L),LDN_1ATM(L)
c     *             ,LDN_2ATM(L),LDN_TYPE(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4600               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A8
     *              ,1X,A6,1X,A8)
                  ENDDO
 4610             CONTINUE
                ENDIF
              ENDIF
              J=LDL_IBOND(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.new_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.new_value_dist'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.new_value_dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDB_NBOND.GT.0) THEN
                  DO L=J,LDB_NBOND
                    IF(LDB_MNAME(L).NE.CH8) GO TO 4710
                    ESD=LDB_DEV(L)
                    IF(ESD.LE.0.0) ESD=0.02
                    WATOM1 = LDB_1ATM(L) 
                    WATOM2 = LDB_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    WRITE(LINE,4700) 
     *              LDB_MNAME(L),LDB_FUNCT(L),WATOM1
     *             ,WATOM2,LDB_TYPE(L)
     *             ,LDB_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4700               FORMAT(1X,A8,1X,A8,1X,A6,2X,A6,4X,A8,1X
     *              ,F8.3,1X,F8.3)
                  ENDDO
 4710             CONTINUE
                ENDIF
              ENDIF
              J=LDL_ITHET(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.new_value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.new_value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDG_NANGL.GT.0) THEN
                  DO L=J,LDG_NANGL
                    IF(LDG_MNAME(L).NE.CH8) GO TO 4810
                    ESD=LDG_DEV(L)
                    IF(ESD.LE.0.0) ESD=3.0
                    WATOM1 = LDG_1ATM(L)
                    WATOM2 = LDG_2ATM(L)
                    WATOM3 = LDG_3ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    WRITE(LINE,4800) 
     *              LDG_MNAME(L),LDG_FUNCT(L)
     *             ,WATOM1,WATOM2
     *             ,WATOM3
     *             ,LDG_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4800               FORMAT(1X,A8,1X,A8,1X,A6,2X,A6,2X,A6
     *              ,1X,F8.3,1X,F8.3)
                  ENDDO
 4810             CONTINUE
                ENDIF
              ENDIF
              J=LDL_ITORS(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_4'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.new_value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.new_value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.new_period'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDT_NTORS.GT.0) THEN
                  DO L=J,LDT_NTORS
                    IF(LDT_MNAME(L).NE.CH8) GO TO 4910
                    ESD=LDT_DEV(L)
                    IF(ESD.LE.0.0) ESD=20.0
                    WATOM1 = LDT_1ATM(L)
                    WATOM2 = LDT_2ATM(L)
                    WATOM3 = LDT_3ATM(L)
                    WATOM4 = LDT_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,4900) 
     *              LDT_MNAME(L),LDT_FUNCT(L),LDT_LABEL(L)
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,LDT_VAL(L),ESD,LDT_PRD(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4900               FORMAT(1X,A8,1X,A8,1X,A8,1X,A6,1X,A6
     *              ,1X,A6,1X,A6,1X,F7.2,1X,F5.1,1X,I1)
                  ENDDO
 4910             CONTINUE
                ENDIF
              ENDIF

              J=LDL_ICHIR(I)
              IF(J.GT.0) THEN

                IF(LDC_NCHIR.GT.0) THEN
                  ICROSS = 0
                  DO L=J,LDC_NCHIR
                    IF(LDC_MNAME(L).NE.CH8) GO TO 5011
                    IF(LDC_SIGN(L)(1:6).EQ.'cross3'.OR.
     *                 LDC_SIGN(L)(1:6).EQ.'cross4'.OR.
     *                 LDC_SIGN(L)(1:6).EQ.'cross5'.OR.
     *                 LDC_SIGN(L)(1:6).EQ.'cross6'.OR.
     *                 LDC_SIGN(L)(1:5).EQ.'star5'.OR.
     *                 LDC_SIGN(L)(1:5).EQ.'star6'    ) ICROSS = 1
                  ENDDO
 5011             CONTINUE
                ENDIF

                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

C                WRITE(LINE,'(''_chem_mod_chir.id'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                WRITE(LINE,'(''_chem_mod_chir.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_centre'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.new_volume_sign'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  IF(ICROSS.EQ.1) THEN
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_4'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_5'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_6'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_7'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_8'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDIF

                IF(LDC_NCHIR.GT.0) THEN
                  DO L=J,LDC_NCHIR
                    IF(LDC_MNAME(L).NE.CH8) GO TO 5010
C !!!
                    CHAR8='.'
C !!! 
                    WATOM1 = LDC_1ATM(L)
                    WATOM2 = LDC_2ATM(L)
                    WATOM3 = LDC_3ATM(L)
                    WATOM4 = LDC_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,5000) 
     *              LDC_MNAME(L),LDC_FUNCT(L)
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,LDC_SIGN(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 5000               FORMAT(1X,A8,3X,1X,A8,1X,A6,2X,A6,2X,A6
     *              ,2X,A6,2X,A8)
                    IF(ICROSS.EQ.1) THEN
                      WATOM5 = LDC_5ATM(L) 
                      WATOM6 = LDC_6ATM(L) 
                      WATOM7 = LDC_7ATM(L)
                      WATOM8 = LDC_8ATM(L)
                      WATOM9 = LDC_9ATM(L)
                      CALL CORR_NAME_CIF_OUT(WATOM5)
                      CALL CORR_NAME_CIF_OUT(WATOM6)
                      CALL CORR_NAME_CIF_OUT(WATOM7)
                      CALL CORR_NAME_CIF_OUT(WATOM8)
                      CALL CORR_NAME_CIF_OUT(WATOM9)
                      WRITE(LINE,5001) 
     *                WATOM5,WATOM6,WATOM7,WATOM8,WATOM9
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 5001                 FORMAT(19X,A6,1X,A6,1X,A6,1X,A6,1X,A6)
                    ENDIF

                  ENDDO
 5010             CONTINUE
                ENDIF
              ENDIF
              J=LDL_IPLAN(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.plane_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.new_dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDP_NPLAN.GT.0) THEN
                  DO L=J,LDP_NPLAN
                    IF(LDP_MNAME(L).NE.CH8) GO TO 5110
                    DO K=1,LDP_NATOM(L)
                      IATOM  = LDP_ATOM(K,L)
                      WATOM1 = ATOM
                      CALL CORR_NAME_CIF_OUT(WATOM1)
                      WRITE(LINE,5100) 
     *                LDP_MNAME(L),LDP_FUNCT(L),LDP_LABEL(L)
     *               ,WATOM1,LDP_DEV(K,L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 5100                 FORMAT(1X,A8,3X,A8,2X,A8,1X,A6,1X,F8.3)
                    ENDDO
                  ENDDO
 5110             CONTINUE
                ENDIF
              ENDIF
C            ENDIF

          ENDIF
        ENDDO
        ENDIF

 6200   CONTINUE

        WRITE(LINE,'(A)')
     *  '# ------------------------------------------------------'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

      ELSE IF(MODE.EQ.'STOP') THEN
        IF(LMO_IUN.EQ.0) THEN
          CALL MSGERR(MDOC,' ERR: output_lib_file can''t be close')
          IERR=1
          RETURN
        ENDIF
        END FILE LMO_IUN
        CLOSE(LMO_IUN)
        LMO_IUN = 0
      ENDIF
C -----------------------------------
      RETURN
      END     


C ******
      SUBROUTINE WRT_LIB_NEW(MDOC,MODE,ICRD,IERR)
C -------------------------------------------------------
C -P- WRT_LIB - writes library to the file.
C
C     MODE:  TITC - titles only for new
C            TITA - all
C            TITL - 'Y', 'C', except 'N' , 'C'
C            MONL
C            MONC
C            MONA
C            MODL
C            MODC
C            MODA
C            LINL
C            LINC
C            LINA
C
C            STOP
C
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR,ICRD
      CHARACTER MODE*4
C ******
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      INCLUDE 'crd_com.fh'
C ----------------------------------
      INTEGER*4 IATOM
      CHARACTER LINE*256
      CHARACTER ATOM*4,CH1_1*1,CH1_2*1,CH2*2,CH3*3,POINT*4
      CHARACTER TYPE*8,CH8*8,CHAR8*8
      CHARACTER WATOM1*6,WATOM2*6,WATOM3*6,WATOM4*6
C     CHARACTER CH1_3*1,CH1_4*1,CH1_5*1,CH5*5
      CHARACTER STR*80,TITLE_M*80,CH4*4
      EQUIVALENCE (IATOM,ATOM)
      DATA POINT/'.   '/,TYPE/'.       '/
C -----------------------------------
  
      IF(MODE(1:3).EQ.'TIT') THEN
        IF(ICRD.EQ.0) THEN
          IF(LMO_FILE.EQ.' ') RETURN
          IERR=0
C         open file 
          IF(LMO_IUN.NE.0) THEN
            CALL MSGERR(MDOC,' ERR: output_lib_file was open before')
            IERR=1
            RETURN
          ENDIF
          M   = 99

C         IUN = 11
          IUN = CRO3_IUN
          CALL OPENFW(IUN,M,LMO_PATH,LMO_FILE,LMO_EXT,IERR)
          CRO3_IUN = IUN

          IF(IERR.NE.0) THEN
            CALL MSGERR(MDOC,' ERR: can''t open output_lib_file')
            RETURN
          ENDIF
          LMO_IUN = IUN
          WRITE(LINE,'(''global_'')') 
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_name   '',6X,A)') LB_NAME(1:16)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_version'',6X,A)') LB_VERS(1:16)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_update '',6X,A)') LB_DATE(1:16)
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          TITLE_M = '# ---   LIST OF MONOMERS ---'

        ELSE 
          IF(ICRD.LE.0) THEN
            CALL MSGERR(MDOC,' ERR: output_CIFile isn''t open.')
            IERR=1
            RETURN
          ENDIF
          IUN = ICRD 

          TITLE_M = '# ---   LIST OF NEW MONOMERS ---'

        ENDIF

        IF(LML_NMON.GT.0) THEN
          IFIRST_M = 0
          DO L=1,LML_NMON

            IF((LML_FUSE(L).EQ.'C'.AND.MODE.EQ.'TITC').OR. 
     *         (MODE.EQ.'TITA')                       .OR. 
     *         (LML_FUSE(L).NE.'N'.AND.LML_FUSE(L).NE.'?'.AND.
     *                                          MODE.EQ.'TITL')) THEN
              IF(IFIRST_M.EQ.0) THEN
                WRITE(LINE,'(A)')
     *  '# ------------------------------------------------'
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                LINE = TITLE_M
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF

              CALL WRT_TITLE_MONOMER(MDOC,IUN,L,IFIRST_M,IERR)

            ENDIF
          ENDDO
        ELSE
          IF(MODE.NE.'TITC') THEN
            WRITE(LINE,'('' Number of monomers = 0'')')
            CALL MSGDOC(MDOC,LINE)
            LMO_IUN = 0
            RETURN
          ENDIF
        ENDIF

        IF(LMS_NEW.GT.0.OR.MODE.NE.'TITC') THEN
        IF(LMS_NSYN.GT.0) THEN
          IFIRST_M = 0

          DO L=1,LMS_NSYN
            IF((LMS_FLAG(L).EQ.'N'.OR.MODE.NE.'TITC').AND.
     *          LMS_ATOM(L).EQ.'.') THEN

              IF(IFIRST_M.EQ.0) THEN

                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''# ---   LIST OF SYNONYMS ---'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_synonym_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_chem_comp_synonym.comp_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST_M = 1
              ENDIF
              WRITE(LINE,200) 
     *        LMS_MNAME(L)
     *        ,LMS_AMNAME(L),LMS_MOD(L)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  200         FORMAT(A8,4X,A8,1X,A8)
            ENDIF
          ENDDO

          IFIRST_MM = 0

          DO L=1,LMS_NSYN
            IF((LMS_FLAG(L).EQ.'N'.OR.MODE.NE.'TITC').AND.
     *          LMS_ATOM(L).NE.'.') THEN
              IF(IFIRST_MM.EQ.0) THEN

                IF(IFIRST_M.EQ.0) THEN
                  WRITE(LINE,'(''#'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''# ---   LIST OF SYNONYMS ---'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                ENDIF

                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_synonym_atom_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym_atom.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_synonym_atom.comp_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_synonym_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_chem_comp_synonym_atom.atom_alternative_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                IFIRST_MM = 1
              ENDIF
              WATOM1 = LMS_ATOM(L)
              WATOM2 = LMS_AATOM(L)
              CALL CORR_NAME_CIF_OUT(WATOM1)
              CALL CORR_NAME_CIF_OUT(WATOM2)
              WRITE(LINE,201) 
     *        LMS_MNAME(L)
     *        ,LMS_AMNAME(L),WATOM1,WATOM2
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
 201          FORMAT(A8,4X,A8,1X,A6,1X,A6)
            ENDIF
          ENDDO


        ENDIF
        ENDIF

        IF(LLL_NLINK.GT.0) THEN
          IFIRST=0
          DO L=1,LLL_NLINK
            IF((LLL_FUSE(L).EQ.'C'.AND.MODE.EQ.'TITC').OR. 
     *         (MODE.EQ.'TITA')                       .OR. 
     *         (LLL_FUSE(L).NE.'N'.AND.LLL_FUSE(L).NE.'?'.AND.
     *                                 MODE.EQ.'TITL')) THEN


              IF(IFIRST.EQ.0) THEN 
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''# ---   LIST OF LINKS ---'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF

              CALL WRT_TITLE_LINK(MDOC,IUN,L,IFIRST,IERR)

            ENDIF
          ENDDO
        ENDIF

        IF(LDL_NMOD.GT.0) THEN
          IFIRST=0
          DO L=1,LDL_NMOD
            IF((LDL_FUSE(L).EQ.'C'.AND.MODE.EQ.'TITC').OR. 
     *         (MODE.EQ.'TITA')                       .OR. 
     *         (LDL_FUSE(L).NE.'N'.AND.LDL_FUSE(L).NE.'?'.AND.
     *                                 MODE.EQ.'TITL')) THEN
              IF(IFIRST.EQ.0) THEN 
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''# ---   LIST OF MODIFICATIONS ---'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF

              CALL WRT_TITLE_MODIFICATION(MDOC,IUN,L,IFIRST,IERR)

            ENDIF
          ENDDO
        ENDIF

      ELSE IF(MODE(1:3).EQ.'MON'.OR.MODE(1:3).EQ.'LIN'.OR.
     *        MODE(1:3).EQ.'MOD') THEN

        IF(ICRD.GT.0) THEN
          IF(ICRD.LE.0) THEN
            CALL MSGERR(MDOC,' ERROR: output_CIFile isn''t open')
            IERR=1
            RETURN
          ENDIF
          IUN=ICRD 
        ELSE
          IF(LMO_IUN.EQ.0) THEN
            CALL MSGERR(MDOC,' ERR: output_lib_file isn''t open..')
            IERR=1
            RETURN
          ENDIF
          IUN=LMO_IUN 
        ENDIF

        IF(MODE(1:3).EQ.'LIN'.OR.MODE(1:3).EQ.'MOD') GO TO 6000


        IF(LML_NMON.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# --- DESCRIPTION OF MONOMERS ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          DO I=1,LML_NMON

            IF((LML_FUSE(I).EQ.'C'.AND.MODE.EQ.'MONC').OR.
     *         (MODE.EQ.'MONA')                       .OR.
     *         (LML_FUSE(I).NE.'N'.AND.LML_FUSE(I).NE.'?'.AND.
     *                                 MODE.EQ.'MONL')) THEN          
              CALL WRT_DESRC_ONE_MONOMER(MDOC,IUN,I,IERR)

            ENDIF
          ENDDO
        ENDIF

        IF(MODE(1:3).EQ.'MON') GO TO 6200

 6000   CONTINUE
        IF(MODE(1:3).EQ.'MOD') GO TO 6100


        IF(LLL_NLINK.GT.0) THEN
        IFIRST=0
        DO I=1,LLL_NLINK
          IF((LLL_FUSE(I).EQ.'C'.AND.MODE.EQ.'LINC').OR.
     *       (MODE.EQ.'LINA')                       .OR.
     *       (LLL_FUSE(I).NE.'N'.AND.LLL_FUSE(I).NE.'?'.AND.
     *                               MODE.EQ.'LINL')) THEN
            IF(IFIRST.EQ.0) THEN
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''# --- DESCRIPTION OF LINKS ---'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''#'')')
              IFIRST=1
            ENDIF


            CALL WRT_DESRC_ONE_LINK(MDOC,IUN,I,IERR)
           
          ENDIF

        ENDDO
        ENDIF

 6100   CONTINUE
        IF(MODE(1:3).EQ.'LIN') GO TO 6200

        IF(LDL_NMOD.GT.0) THEN
        IFIRST=0
        DO I=1,LDL_NMOD
          IF((LDL_FUSE(I).EQ.'C'.AND.MODE.EQ.'MODC').OR.
     *       (MODE.EQ.'MODA')                       .OR.
     *       (LDL_FUSE(I).NE.'N'.AND.LDL_FUSE(I).NE.'?'.AND.
     *                               MODE.EQ.'MODL')) THEN
            IF(IFIRST.EQ.0) THEN
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''# --- DESCRIPTION OF MODIFICATIONS ---'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''#'')')
              IFIRST=1
            ENDIF
C            IF(LDL_SUB_MOD(I)(1:1).EQ.'.') THEN

            CALL WRT_DESRC_ONE_MODIFICATION(MDOC,IUN,I,IERR)

C            ENDIF
          ENDIF
        ENDDO
        ENDIF

 6200   CONTINUE

        WRITE(LINE,'(A)')
     *  '# ------------------------------------------------------'
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

      ELSE IF(MODE.EQ.'STOP') THEN
        IF(LMO_IUN.EQ.0) THEN
          CALL MSGERR(MDOC,' ERR: output_lib_file can''t be close')
          IERR=1
          RETURN
        ENDIF
        END FILE LMO_IUN
        LMO_IUN = 0
      ENDIF
C -----------------------------------
      RETURN
      END     

      SUBROUTINE WRT_TITLE_MONOMER(MDOC,IUN,L,IFIRST_M,IERR)
C ------------------------------------------------------------
      INTEGER   MDOC,IUN,L,IFIRST_M,IERR
C ----
      CHARACTER LINE*256,STR*256,CH1_1*1,CH1_2*1,CH3*3
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ------------------------------------------------------------      
              IF(IFIRST_M.EQ.0) THEN
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.three_letter_code'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.group'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.number_atoms_all'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.number_atoms_nh'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp.desc_level'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST_M = 1
              ENDIF
              CH3 = LML_MNAME2(L)(1:3)
              J   = LML_IATOM(L)
              NA  = 0
              NHA = 0                  
              IF(J.GT.0) THEN
                IF(LMA_NATOM.GT.0) THEN
                  DO IA=J,LMA_NATOM
                    IF(LMA_MNAME(IA).EQ.LML_MNAME(L)) THEN
                      NA = NA+1
                      IF(LMA_SYMB(IA).NE.'H   '.AND.
     *                   LMA_SYMB(IA).NE.'D   ') THEN
                        NHA=NHA+1
                      ENDIF
                    ENDIF           
                  ENDDO
                ENDIF
              ENDIF

              CH1_2 = ''''
              CH1_1 = LML_PRSNT(L)
              IF(CH1_1.EQ.' ') CH1_1 = '.'
CZEB     aaa '4-HYDROXY-3,4-DIHYDRO-ZEBULARINEMIDI ' non-polymer        31  17 M
c2345678112311123456789 123456789 123456789 123456711123456789 123456112341234
c         123456789 123456789 123456789 12345611     123456789 123456112341234
              STR = LML_NAME(L)
              CALL LENSTR_BL(STR,LEN)
              IF(LEN.GT.36) LEN = 36
              IF(LEN.LT.36) THEN
                DO II=LEN+1,36
                  STR(II:II) = ' '
                ENDDO
              ENDIF
              IF(LML_MNAME(L)(1:1).NE.'?') THEN
                WRITE(LINE,100)
     *          LML_MNAME(L),CH3,CH1_2,STR(1:36),CH1_2
     *         ,LML_TYPE(L),NA,NHA,CH1_1
C     *        ,LML_NATM(L),LML_NHATM(L)
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
  100           FORMAT(A8,1X,A3,1X,A1,A36,A1,1X,A16,1X,I4,I4,1X,A1)
              ENDIF
C ------------------------
      RETURN
      END

      SUBROUTINE WRT_DESRC_ONE_MONOMER(MDOC,IUN,I,IERR)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      INTEGER*4 MDOC,IUN,I,IERR
      CHARACTER LINE*256
      CHARACTER CH2*2,POINT*4,TYPE*8,CH8*8,CH4*4,CHAR8*8
      CHARACTER WATOM1*6,WATOM2*6,WATOM3*6,WATOM4*6
      CHARACTER WATOM5*6,WATOM6*6,WATOM7*6,WATOM8*6,WATOM9*6
C ----------
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C ----------
      DATA POINT/'.   '/,TYPE/'.       '/
C -----------------------------------------------
              CH8 = LML_MNAME(I)
              IF(CH8(1:1).NE.'?') THEN
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_comp_'',A8)') CH8
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
              ENDIF
              J=LML_IATOM(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.type_symbol'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_atom.type_energy'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                IF(LML_PRSNT(I).NE.'M') THEN
                  WRITE(LINE,'(''_chem_comp_atom.partial_charge'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                ENDIF
                IF(LMA_NATOM.GT.0) THEN
                  DO L=J,LMA_NATOM
                    IF(LMA_MNAME(L).NE.CH8) GO TO 510
                    WATOM1 = LMA_ANAME(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
c                    IF(LML_PRSNT(I).NE.'M') THEN
                      WRITE(LINE,500) 
     *                LMA_MNAME(L),WATOM1
     *               ,LMA_SYMB(L),LMA_CHEM(L),LMA_CHARG(L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
  500                 FORMAT(1X,A8,6X,A6,1X,A4,1X,A4,3X,F8.3)
c                    ELSE
c                      WRITE(LINE,501) 
c     *                LMA_MNAME(L),WATOM1
c     *               ,LMA_SYMB(L),LMA_CHEM(L)
c                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
c 501                  FORMAT(1X,A8,1X,A6,1X,A4,1X,A4)
c                    ENDIF
                  ENDDO
  510             CONTINUE
                ENDIF
              ENDIF
              J=LML_IATOM(I)
              K=LML_ICONN(I)
              IF(J.GT.0.AND.LML_PRSNT(I).NE.'M') THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.atom_back'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_comp_tree.back_type'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tree.atom_forward'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

C               WRITE(LINE
C    *          ,'(''_chem_comp_tree.additional_connect_atom_id_1'')')
C               CALL WRTSTR(IUN,MDOC,LINE,IERR)
C               WRITE(LINE
C    *          ,'(''_chem_comp_tree.additional_connect_atom_id_2'')')
C               CALL WRTSTR(IUN,MDOC,LINE,IERR)
c               WRITE(LINE
c    *          ,'(''_chem_comp_tree.additional_connect_type'')')
c               CALL WRTSTR(IUN,MDOC,LINE,IERR)

                WRITE(LINE
     *          ,'(''_chem_comp_tree.connect_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                IF(LMA_NATOM.GT.0) THEN
                  DO L=J,LMA_NATOM
                    IF(LMA_MNAME(L).NE.CH8) GO TO 610
C !!!
                    CHAR8=LMA_TYPE(L)
                    IF(CHAR8.EQ.' ') CHAR8 = '.'
                    IF(LMA_BACK(L)(1:1).EQ.'.') CHAR8='START' 
                    IF(LMA_FORW(L).EQ.'END ') THEN
                      CHAR8       = 'END' 
                      LMA_FORW(L) = '.'
                    ENDIF
C !!!
                    CH4 = LMA_BACK(L)
                    IF(CH4(1:1).EQ.'.') CH4 = 'n/a '

                    WATOM1 = LMA_ANAME(L)
                    WATOM2 = CH4
                    WATOM3 = LMA_FORW(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)

                    WRITE(LINE,600) 
     *              LMA_MNAME(L)
     *             ,WATOM1,WATOM2,WATOM3
     *             ,CHAR8

C    *             ,POINT,POINT,TYPE
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
  600        FORMAT(1X,A8,1X,A6,1X,A6,1X,A6,1X,A8)
C 600        FORMAT(1X,A8,6X,A4,1X,A4,1X,A8,1X,A4,1X,A4,1X,A4,1X,A8)
                  ENDDO
  610             CONTINUE
                ENDIF
                IF(LMN_NCONN.GT.0.AND.K.GT.0) THEN
                  DO L=K,LMN_NCONN
                    IF(LMN_MNAME(L).NE.CH8) GO TO 620
                    CHAR8 = 'ADD'
                    WATOM1 = LMN_1ATM(L)
                    WATOM2 = LMN_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    WRITE(LINE,630)
     *              LMN_MNAME(L),WATOM1
     *             ,WATOM2,POINT,CHAR8

  630               FORMAT(1X,A8,1X,A6,1X,A6,1X,A,1X,A)

C    *              LMN_MNAME(L),POINT,POINT,TYPE,POINT,LMN_1ATM(L)
C    *             ,LMN_2ATM(L),LMN_TYPE(L)

                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDDO
  620             CONTINUE
                ENDIF
              ENDIF
              J=LML_IBOND(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_bond.type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LML_PRSNT(I).NE.'M') THEN
                  WRITE(LINE,'(''_chem_comp_bond.value_dist'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_bond.value_dist_esd'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                ENDIF
                IF(LMB_NBOND.GT.0) THEN
                  DO L=J,LMB_NBOND
                    IF(LMB_MNAME(L).NE.CH8) GO TO 710
                    ESD=LMB_DEV(L)
                    IF(ESD.LE.0.0) ESD=0.02
                    WATOM1 = LMB_1ATM(L)
                    WATOM2 = LMB_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    IF(LML_PRSNT(I).NE.'M') THEN
                      WRITE(LINE,700) 
     *                LMB_MNAME(L)
     *               ,WATOM1,WATOM2,LMB_TYPE(L),LMB_VAL(L)
     *               ,ESD
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
  700                 FORMAT(1X,A8,1X,A6,1X,A6,4X,A8,1X,F8.3,1X,F8.3)
                    ELSE
                      WRITE(LINE,701) 
     *                LMB_MNAME(L)
     *               ,WATOM1,WATOM2,LMB_TYPE(L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 701                  FORMAT(1X,A3,8X,A6,1X,A6,4X,A8)
                    ENDIF
                  ENDDO
  710             CONTINUE
                ENDIF
              ENDIF
              J=LML_ITHET(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_angle.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LMG_NANGL.GT.0) THEN
                  DO L=J,LMG_NANGL
                    IF(LMG_MNAME(L).NE.CH8) GO TO 810
                    ESD=LMG_DEV(L)
                    IF(ESD.LE.0.0) ESD=3.0
                    WATOM1 = LMG_1ATM(L)
                    WATOM2 = LMG_2ATM(L)
                    WATOM3 = LMG_3ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)

                    WRITE(LINE,800) 
     *              LMG_MNAME(L)
     *             ,WATOM1,WATOM2,WATOM3,LMG_VAL(L)
     *             ,ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
  800               FORMAT(1X,A8,1X,A6,1X,A6,1X,A6,1X,F8.3,1X,F8.3)
                  ENDDO
  810             CONTINUE
                ENDIF
              ENDIF
              J=LML_ITORS(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.atom_id_4'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_tor.period'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LMT_NTORS.GT.0) THEN
                  IC=0
                  DO L=J,LMT_NTORS
                    IF(LMT_MNAME(L).NE.CH8) GO TO 910
                    ANGL=LMT_VAL(L)
                    IF(ANGL.GT. 180.0) ANGL=ANGL-360.0
                    IF(ANGL.LE.-180.0) ANGL=ANGL+360.0
                    IPRD=LMT_PRD(L)
                    ESD=LMT_DEV(L)
                    IF(ESD.LE.0.0) ESD = 20.0
                    CHAR8 =LMT_LABEL(L)
                    IF(IPRD.EQ.0) ESD=0.0
C !!!!
c                    IF(IPRD.EQ.0) IPRD=1
c                    IF(CHAR8(1:5).EQ.'CONST') THEN
c                      IPRD=0
c                      IC=IC+1
c                      IF(IC.GT.99) IC=99
c                      WRITE(CH2,'(I2)') IC
c                      IF(CH2(1:1).EQ.' ') CH2(1:1)='0'
c                      CHAR8='CONST_'//CH2
c  
c                      IF(IPRD.EQ.0) ESD=0.0
c
c                    ENDIF
C !!!
                    WATOM1 = LMT_1ATM(L) 
                    WATOM2 = LMT_2ATM(L) 
                    WATOM3 = LMT_3ATM(L)
                    WATOM4 = LMT_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)

                    WRITE(LINE,900) 
     *              LMT_MNAME(L),CHAR8
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,ANGL,ESD,IPRD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
  900               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A6,1X,A6,2X
     *              ,F8.3,1X,F8.3,1X,I3)
                  ENDDO

  910             CONTINUE
                ENDIF
              ENDIF
              J=LML_ICHIR(I)
              IF(J.GT.0) THEN
                IF(LMC_NCHIR.GT.0) THEN

                  IC     = 0
                  ICROSS = 0
                  DO L=J,LMC_NCHIR
                    IF(LMC_MNAME(L).NE.CH8) GO TO 1011
                    IF(LMC_SIGN(L)(1:6).EQ.'cross3'.OR.
     *                 LMC_SIGN(L)(1:6).EQ.'cross4'.OR.
     *                 LMC_SIGN(L)(1:6).EQ.'cross5'.OR.
     *                 LMC_SIGN(L)(1:6).EQ.'cross6'.OR.
     *                 LMC_SIGN(L)(1:5).EQ.'star5'.OR.
     *                 LMC_SIGN(L)(1:5).EQ.'star6'    ) ICROSS = 1
                  ENDDO
 1011             CONTINUE

                  WRITE(LINE,'(''loop_'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.comp_id'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.id'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_centre'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_1'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_2'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.atom_id_3'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  WRITE(LINE,'(''_chem_comp_chir.volume_sign'')')
                  CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  IF(ICROSS.EQ.1) THEN
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_4'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_5'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_6'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_7'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_comp_chir.atom_id_8'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDIF

                  DO L=J,LMC_NCHIR
                    IF(LMC_MNAME(L).NE.CH8) GO TO 1010
C !!
                    IC=IC+1
                    IF(IC.GT.99) IC=99
                    WRITE(CH2,'(I2)') IC
                    IF(CH2(1:1).EQ.' ') CH2(1:1)='0'
                    CHAR8='chir_'//CH2  
C !!!
                    WATOM1 = LMC_1ATM(L) 
                    WATOM2 = LMC_2ATM(L) 
                    WATOM3 = LMC_3ATM(L)
                    WATOM4 = LMC_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,1000) 
     *              LMC_MNAME(L),CHAR8
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,LMC_SIGN(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1000               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A6,1X,A6,4X,A8)
                    IF(ICROSS.EQ.1) THEN
                      WATOM5 = LMC_5ATM(L) 
                      WATOM6 = LMC_6ATM(L) 
                      WATOM7 = LMC_7ATM(L)
                      WATOM8 = LMC_8ATM(L)
                      WATOM9 = LMC_9ATM(L)
                      CALL CORR_NAME_CIF_OUT(WATOM5)
                      CALL CORR_NAME_CIF_OUT(WATOM6)
                      CALL CORR_NAME_CIF_OUT(WATOM7)
                      CALL CORR_NAME_CIF_OUT(WATOM8)
                      CALL CORR_NAME_CIF_OUT(WATOM9)
                      WRITE(LINE,1001) 
     *                WATOM5,WATOM6,WATOM7,WATOM8,WATOM9
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1001                 FORMAT(19X,A6,1X,A6,1X,A6,1X,A6,1X,A6)
                    ENDIF
                  ENDDO
 1010             CONTINUE
                ENDIF
              ENDIF

              J=LML_IPLAN(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.plane_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_comp_plane_atom.dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LMP_NPLAN.GT.0) THEN
                  DO L=J,LMP_NPLAN
                    IF(LMP_MNAME(L).NE.CH8) GO TO 1110
                    DO K=1,LMP_NATOM(L)
                      IATOM  = LMP_ATOM(K,L)
                      WATOM1 = ATOM
                      CALL CORR_NAME_CIF_OUT(WATOM1)
                      WRITE(LINE,1100) 
     *                LMP_MNAME(L)
     *               ,LMP_LABEL(L),WATOM1,LMP_DEV(K,L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 1100                 FORMAT(1X,A8,1X,A8,2X,A6,1X,F8.3)
                    ENDDO
                  ENDDO
 1110             CONTINUE
                ENDIF
              ENDIF
C ---------------------------------
      RETURN
      END

      SUBROUTINE WRT_TITLE_LINK(MDOC,IUN,L,IFIRST,IERR)
C -----------------------------------------------------
      INTEGER*4 MDOC,IERR,IUN,L,IFIRST
      CHARACTER LINE*256
C ******
C -----------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------------------

              IF(IFIRST.EQ.0) THEN 
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_link_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                WRITE(LINE,'(''_chem_link.one_letter_code'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
C                WRITE(LINE,'(''_chem_link.name'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.comp_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.mod_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.group_comp_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.comp_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.mod_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.group_comp_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST=1
              ENDIF
              WRITE(LINE,300) 
     *        LLL_LNAME(L)
     *        ,LLL_MON1(L),LLL_MOD1(L),LLL_TYPE1(L)
     *        ,LLL_MON2(L),LLL_MOD2(L),LLL_TYPE2(L)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  300         FORMAT(A8,1X,A8,1X,A8,1X,A8
     *                              ,1X,A8,1X,A8,1X,A8)
              WRITE(LINE,301) LLL_DETAIL(L)(1:24)
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
 301          FORMAT(1X,A24)
C -------------------------
      RETURN
      END

C ******
      SUBROUTINE WRT_TITLE_MODIFICATION(MDOC,IUN,L,IFIRST,IERR)
C -----------------------------------------------------
      INTEGER*4 MDOC,IERR,IUN,L,IFIRST
      CHARACTER LINE*256
C ******
C -----------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------------------


              IF(IFIRST.EQ.0) THEN 
                WRITE(LINE,'(''#'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''data_mod_list'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.one_letter_code'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.name'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod.group_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.sub_mod_id'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
c                WRITE(LINE,'(''_chem_mod.sub_mod_order'')')
c                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IFIRST=1
              ENDIF

c              WRITE(CH2,'(I2)') LDL_ORDER(L)
c              IF(LDL_ORDER(L).EQ.0) CH2='. '

              WRITE(LINE,400) 
     *        LDL_MNAME(L),LDL_DETAIL(L),LDL_COMP(L),LDL_TYPE(L)
    
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
  400         FORMAT(A8,1X,A48,1X,A8,1X,A8)
C -------------------------
      RETURN
      END

      SUBROUTINE WRT_DESRC_ONE_LINK(MDOC,IUN,I,IERR)
C -------------------------------------------------------
      INTEGER*4 MDOC,IUN,IERR,I
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ----------------------------------
      CHARACTER LINE*256,CHAR8*8,CH8*8
      CHARACTER WATOM1*6,WATOM2*6,WATOM3*6,WATOM4*6
C ----
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C -------------------------------------------------------
            CH8=LLL_LNAME(I)
            IF(LLL_NLINK.GT.1.AND.I.GT.1) THEN
              DO J=1,I-1
                IF(CH8.EQ.LLL_LNAME(J)) GO TO 6101
              ENDDO
            ENDIF

            WRITE(LINE,'(''#'')')
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            WRITE(LINE,'(''data_link_'',A8)') CH8
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            WRITE(LINE,'(''#'')')
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            J=LLL_IBOND(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.value_dist'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_bond.value_dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLB_NBOND.GT.0) THEN
                  DO L=J,LLB_NBOND
                    IF(LLB_LNAME(L).NE.CH8) GO TO 2710
                    ESD=LLB_DEV(L)
                    IF(ESD.LE.0.0) ESD=0.02

                    WATOM1 = LLB_1ATM(L)
                    WATOM2 = LLB_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)


                    WRITE(LINE,2700) 
     *              LLB_LNAME(L),LLB_F1ATM(L),WATOM1
     *             ,LLB_F2ATM(L),WATOM2,LLB_TYPE(L)
     *             ,LLB_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 2700               FORMAT(1X,A8,1X,I1,1X,A6,2X,I1,1X,A6,4X,A8,1X
     *              ,F8.3,1X,F8.3)
                  ENDDO
 2710             CONTINUE
                ENDIF
            ENDIF
            J=LLL_ITHET(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_3_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_angle.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLG_NANGL.GT.0) THEN
                  DO L=J,LLG_NANGL
                    IF(LLG_LNAME(L).NE.CH8) GO TO 2810
                    ESD=LLG_DEV(L)
                    IF(ESD.LE.0.0) ESD=3.0

                    WATOM1 = LLG_1ATM(L)
                    WATOM2 = LLG_2ATM(L)
                    WATOM3 = LLG_3ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)


                    WRITE(LINE,2800) 
     *              LLG_LNAME(L),LLG_F1ATM(L)
     *             ,WATOM1,LLG_F2ATM(L),WATOM2
     *             ,LLG_F3ATM(L),WATOM3
     *             ,LLG_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 2800               FORMAT(1X,A8,1X,I1,1X,A6,2X,I1,1X,A6,2X,I1,1X,A6
     *              ,1X,F8.3,1X,F8.3)
                  ENDDO
 2810             CONTINUE
                ENDIF
            ENDIF
            J=LLL_ITORS(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_3_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_4_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.atom_id_4'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_tor.period'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLT_NTORS.GT.0) THEN
                  DO L=J,LLT_NTORS
                    IF(LLT_LNAME(L).NE.CH8) GO TO 2910
                    ESD=LLT_DEV(L)
                    IF(ESD.LE.0.0) ESD=20.0
                    WATOM1 = LLT_1ATM(L) 
                    WATOM2 = LLT_2ATM(L)
                    WATOM3 = LLT_3ATM(L)
                    WATOM4 = LLT_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,2900) 
     *              LLT_LNAME(L),LLT_LABEL(L),LLT_F1ATM(L),WATOM1
     *             ,LLT_F2ATM(L),WATOM2      ,LLT_F3ATM(L),WATOM3
     *             ,LLT_F4ATM(L),WATOM4
     *             ,LLT_VAL(L),ESD,LLT_PRD(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 2900               FORMAT(1X,A8,1X,A8,1X,I1,1X,A6,1X,I1,1X,A6,1X,I1
     *              ,1X,A6,1X,I1,1X,A6,1X,F7.2,1X,F5.1,1X,I1)
                  ENDDO
 2910             CONTINUE
                ENDIF
            ENDIF
            J=LLL_ICHIR(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

C                WRITE(LINE,'(''_chem_link_chir.id'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)

           WRITE(LINE,'(''_chem_link_chir.atom_centre_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_centre'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_1_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_2_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_3_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_chir.volume_sign'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLC_NCHIR.GT.0) THEN
                  DO L=J,LLC_NCHIR
                    IF(LLC_LNAME(L).NE.CH8) GO TO 3010
C !!!
                    CHAR8='.'
C !!!
                    WATOM1 = LLC_1ATM(L)
                    WATOM2 = LLC_2ATM(L)
                    WATOM3 = LLC_3ATM(L)
                    WATOM4 = LLC_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,3000) 
     *              LLC_LNAME(L),LLC_F1ATM(L),WATOM1
     *             ,LLC_F2ATM(L),WATOM2,LLC_F3ATM(L),WATOM3
     *             ,LLC_F4ATM(L),WATOM4
     *             ,LLC_SIGN(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 3000               FORMAT(1X,A8,3X,I1,1X,A6,2X,I1
     *              ,1X,A6,2X,I1,1X,A6,2X,I1,1X,A6,2X,A8)
                  ENDDO
 3010             CONTINUE
                ENDIF
            ENDIF
            J=LLL_IPLAN(I)
            IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.link_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.plane_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.atom_comp_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_link_plane.dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LLP_NPLAN.GT.0) THEN
                  DO L=J,LLP_NPLAN
                    IF(LLP_LNAME(L).NE.CH8) GO TO 3110
                    DO K=1,LLP_NATOM(L)
                      IATOM = LLP_ATOM(K,L)
                      WATOM1 = ATOM
                      CALL CORR_NAME_CIF_OUT(WATOM1)
                      WRITE(LINE,3100) 
     *                LLP_LNAME(L),LLP_LABEL(L)
     *               ,LLP_FATOM(K,L),WATOM1,LLP_DEV(K,L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 3100                 FORMAT(1X,A8,3X,A8,2X,I1,1X,A6,1X,F8.3)
                    ENDDO
                  ENDDO
 3110             CONTINUE
                ENDIF
            ENDIF

 6101     CONTINUE
C ----------------------------------
      RETURN
      END 

      SUBROUTINE WRT_DESRC_ONE_MODIFICATION(MDOC,IUN,I,IERR)
C -------------------------------------------------------
      INTEGER*4 MDOC,IUN,IERR,I
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ----------------------------------
      CHARACTER LINE*256,CHAR8*8,CH8*8,CH4*4
      CHARACTER WATOM1*6,WATOM2*6,WATOM3*6,WATOM4*6
      CHARACTER WATOM5*6,WATOM6*6,WATOM7*6,WATOM8*6,WATOM9*6
C ----
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C -------------------------------------------------------

              CH8=LDL_MNAME(I)
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''data_mod_'',A8)') CH8
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              WRITE(LINE,'(''#'')')
              CALL WRTSTR(IUN,MDOC,LINE,IERR)
              J=LDL_IATOM(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_type_symbol'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_type_energy'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_atom.new_partial_charge'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDA_NATOM.GT.0) THEN
                  DO L=J,LDA_NATOM
                    IF(LDA_MNAME(L).NE.CH8) GO TO 4510
                    WATOM1 = LDA_ANAME(L) 
                    WATOM2 = LDA_ANEW(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    WRITE(LINE,4500) 
     *              LDA_MNAME(L),LDA_FUNCT(L)
     *              ,WATOM1,WATOM2,LDA_SYMB(L),LDA_CHEM(L)
     *              ,LDA_CHARG(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4500               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A4,1X,A4,1X,F8.3)
                  ENDDO
 4510             CONTINUE
                ENDIF
              ENDIF
              J=LDL_IATOM(I)
              K=LDL_ICONN(I)
              IF(K.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.atom_back'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.back_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.atom_forward'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tree.connect_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                IF(LDN_NCONN.GT.0) THEN
                  DO L=K,LDN_NCONN
                    IF(LDN_MNAME(L).NE.CH8) GO TO 4610

C !!!!
C                    CHAR8='.'
C                    IF(LDN_BACK(L)(1:1).EQ.'.'.AND.
C     *                 LDN_FUNCT(L)(1:6).NE.'delete') THEN
C                      CHAR8='START' 
C                      LMA_BACK(L)='.'
C                    ENDIF
C                    IF(LDN_FORW(L)(1:3).EQ.'END') THEN 
C                      CHAR8='END' 
C                      LMA_FORW(L)='.'
C                    ENDIF
C                    LDN_TYPE(L)=CHAR8
C !!!!
                    CH4 = LDN_BACK(L)
                    IF(CH4(1:1).EQ.'.') CH4 = 'n/a '
                    WATOM1 = LDN_ATOM(L)
                    WATOM2 = CH4
                    WATOM3 = LDN_FORW(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)

                    WRITE(LINE,4600) 
     *              LDN_MNAME(L),LDN_FUNCT(L)
     *             ,WATOM1,WATOM2,LDN_BTYPE(L)
     *             ,WATOM3,LDN_TYPE(L)

c     *             ,LDN_FORW(L),LDN_1ATM(L)
c     *             ,LDN_2ATM(L),LDN_TYPE(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4600               FORMAT(1X,A8,1X,A8,1X,A6,1X,A6,1X,A8
     *              ,1X,A6,1X,A8)
                  ENDDO
 4610             CONTINUE
                ENDIF
              ENDIF
              J=LDL_IBOND(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.new_type'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.new_value_dist'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_bond.new_value_dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDB_NBOND.GT.0) THEN
                  DO L=J,LDB_NBOND
                    IF(LDB_MNAME(L).NE.CH8) GO TO 4710
                    ESD=LDB_DEV(L)
                    IF(ESD.LE.0.0) ESD=0.02
                    WATOM1 = LDB_1ATM(L) 
                    WATOM2 = LDB_2ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    WRITE(LINE,4700) 
     *              LDB_MNAME(L),LDB_FUNCT(L),WATOM1
     *             ,WATOM2,LDB_TYPE(L)
     *             ,LDB_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4700               FORMAT(1X,A8,1X,A8,1X,A6,2X,A6,4X,A8,1X
     *              ,F8.3,1X,F8.3)
                  ENDDO
 4710             CONTINUE
                ENDIF
              ENDIF
              J=LDL_ITHET(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.new_value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_angle.new_value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDG_NANGL.GT.0) THEN
                  DO L=J,LDG_NANGL
                    IF(LDG_MNAME(L).NE.CH8) GO TO 4810
                    ESD=LDG_DEV(L)
                    IF(ESD.LE.0.0) ESD=3.0
                    WATOM1 = LDG_1ATM(L)
                    WATOM2 = LDG_2ATM(L)
                    WATOM3 = LDG_3ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    WRITE(LINE,4800) 
     *              LDG_MNAME(L),LDG_FUNCT(L)
     *             ,WATOM1,WATOM2
     *             ,WATOM3
     *             ,LDG_VAL(L),ESD
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4800               FORMAT(1X,A8,1X,A8,1X,A6,2X,A6,2X,A6
     *              ,1X,F8.3,1X,F8.3)
                  ENDDO
 4810             CONTINUE
                ENDIF
              ENDIF
              J=LDL_ITORS(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.atom_id_4'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.new_value_angle'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.new_value_angle_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_tor.new_period'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDT_NTORS.GT.0) THEN
                  DO L=J,LDT_NTORS
                    IF(LDT_MNAME(L).NE.CH8) GO TO 4910
                    ESD=LDT_DEV(L)
                    IF(ESD.LE.0.0) ESD=20.0
                    WATOM1 = LDT_1ATM(L)
                    WATOM2 = LDT_2ATM(L)
                    WATOM3 = LDT_3ATM(L)
                    WATOM4 = LDT_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,4900) 
     *              LDT_MNAME(L),LDT_FUNCT(L),LDT_LABEL(L)
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,LDT_VAL(L),ESD,LDT_PRD(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 4900               FORMAT(1X,A8,1X,A8,1X,A8,1X,A6,1X,A6
     *              ,1X,A6,1X,A6,1X,F7.2,1X,F5.1,1X,I1)
                  ENDDO
 4910             CONTINUE
                ENDIF
              ENDIF
              J=LDL_ICHIR(I)
              IF(J.GT.0) THEN


                IF(LDC_NCHIR.GT.0) THEN
                  ICROSS = 0
                  DO L=J,LDC_NCHIR
                    IF(LDC_MNAME(L).NE.CH8) GO TO 5011
                    IF(LDC_SIGN(L)(1:6).EQ.'cross3'.OR.
     *                 LDC_SIGN(L)(1:6).EQ.'cross4'.OR.
     *                 LDC_SIGN(L)(1:6).EQ.'cross5'.OR.
     *                 LDC_SIGN(L)(1:6).EQ.'cross6'.OR.
     *                 LDC_SIGN(L)(1:5).EQ.'star5'.OR.
     *                 LDC_SIGN(L)(1:5).EQ.'star6'    ) ICROSS = 1
                  ENDDO
 5011             CONTINUE
                ENDIF 



                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

C                WRITE(LINE,'(''_chem_mod_chir.id'')')
C                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                WRITE(LINE,'(''_chem_mod_chir.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_centre'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_1'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_2'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.atom_id_3'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_chir.new_volume_sign'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)

                  IF(ICROSS.EQ.1) THEN
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_4'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_5'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_6'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_7'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                    WRITE(LINE,'(''_chem_mod_chir.atom_id_8'')')
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
                  ENDIF

                IF(LDC_NCHIR.GT.0) THEN
                  DO L=J,LDC_NCHIR
                    IF(LDC_MNAME(L).NE.CH8) GO TO 5010
C !!!
                    CHAR8='.'
C !!! 
                    WATOM1 = LDC_1ATM(L)
                    WATOM2 = LDC_2ATM(L)
                    WATOM3 = LDC_3ATM(L)
                    WATOM4 = LDC_4ATM(L)
                    CALL CORR_NAME_CIF_OUT(WATOM1)
                    CALL CORR_NAME_CIF_OUT(WATOM2)
                    CALL CORR_NAME_CIF_OUT(WATOM3)
                    CALL CORR_NAME_CIF_OUT(WATOM4)
                    WRITE(LINE,5000) 
     *              LDC_MNAME(L),LDC_FUNCT(L)
     *             ,WATOM1,WATOM2,WATOM3,WATOM4
     *             ,LDC_SIGN(L)
                    CALL WRTSTR(IUN,MDOC,LINE,IERR)
 5000               FORMAT(1X,A8,3X,1X,A8,1X,A6,2X,A6,2X,A6
     *              ,2X,A6,2X,A8)

                    IF(ICROSS.EQ.1) THEN
                      WATOM5 = LDC_5ATM(L) 
                      WATOM6 = LDC_6ATM(L) 
                      WATOM7 = LDC_7ATM(L)
                      WATOM8 = LDC_8ATM(L)
                      WATOM9 = LDC_9ATM(L)
                      CALL CORR_NAME_CIF_OUT(WATOM5)
                      CALL CORR_NAME_CIF_OUT(WATOM6)
                      CALL CORR_NAME_CIF_OUT(WATOM7)
                      CALL CORR_NAME_CIF_OUT(WATOM8)
                      CALL CORR_NAME_CIF_OUT(WATOM9)
                      WRITE(LINE,5001) 
     *                WATOM5,WATOM6,WATOM7,WATOM8,WATOM9
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 5001                 FORMAT(19X,A6,1X,A6,1X,A6,1X,A6,1X,A6)
                    ENDIF

                  ENDDO
 5010             CONTINUE
                ENDIF
              ENDIF
              J=LDL_IPLAN(I)
              IF(J.GT.0) THEN
                WRITE(LINE,'(''loop_'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.mod_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.function'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.plane_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.atom_id'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                WRITE(LINE,'(''_chem_mod_plane_atom.new_dist_esd'')')
                CALL WRTSTR(IUN,MDOC,LINE,IERR)
                IF(LDP_NPLAN.GT.0) THEN
                  DO L=J,LDP_NPLAN
                    IF(LDP_MNAME(L).NE.CH8) GO TO 5110
                    DO K=1,LDP_NATOM(L)
                      IATOM  = LDP_ATOM(K,L)
                      WATOM1 = ATOM
                      CALL CORR_NAME_CIF_OUT(WATOM1)
                      WRITE(LINE,5100) 
     *                LDP_MNAME(L),LDP_FUNCT(L),LDP_LABEL(L)
     *               ,WATOM1,LDP_DEV(K,L)
                      CALL WRTSTR(IUN,MDOC,LINE,IERR)
 5100                 FORMAT(1X,A8,3X,A8,2X,A8,1X,A6,1X,F8.3)
                    ENDDO
                  ENDDO
 5110             CONTINUE
                ENDIF
              ENDIF
C -----------------------------
      RETURN
      END

      SUBROUTINE CHKASYM(MDOC,ASYMB,INSF,IERR)
C -----------------------------------------------
C -P- CHKASYM -
C -S-
C ---
      INCLUDE 'lib_com.fh'
C --
      INTEGER*4 MDOC,IERR
      CHARACTER ASYMB*4
C ******
      CHARACTER LINE*256
C ---------------------------------------
      JERR = 0
  200 CONTINUE
      IERR = 0
      INSF = 0

      IF(LSF_NASYMB.GT.0) THEN
        DO  I=1,LSF_NASYMB
          IF(LSF_ELEMENT(I).EQ.ASYMB) THEN
            INSF = I
            GO TO 100
          ENDIF
        ENDDO
      ENDIF

      CALL GET_SFA(ASYMB
     *      ,N,NE,A1,A2,A3,A4,B1,B2,B3,B4,C,FI,FII,RAD,IERR)

C      CALL GET_SFA(ASYMB,NE,A1,A2,A3,A4,B1,B2,B3,B4,C,FI,FII,IERR)

      IF(IERR.EQ.1) THEN

        WRITE(LINE,300) ASYMB
  300   FORMAT(
     *  ' WARNING: can''t find atomic scatt.factors for :',A4)
        CALL MSGDOC(MDOC,LINE)
        CALL MSGDOC(MDOC,
     *  '          default symbol is "N   "')
        ASYMB = 'N   '
        JERR  = 2
        GO TO 200

      ENDIF

      LSF_NASYMB = LSF_NASYMB + 1
      IF(LSF_NASYMB.GT.MAXASYMB) THEN
        WRITE(LINE,'(A,I6,A)')
     *' ERR: number of tables of atomic scatt. factors >',MAXASYMB,
     *' /lib. limit/'
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF

      INSF                    = LSF_NASYMB

      LSF_ELEMENT(LSF_NASYMB) = ASYMB
      LSF_ATOM   (LSF_NASYMB) = ASYMB

      LSF_NE     (LSF_NASYMB) = NE
      LSF_A1     (LSF_NASYMB) = A1
      LSF_A2     (LSF_NASYMB) = A2
      LSF_A3     (LSF_NASYMB) = A3
      LSF_A4     (LSF_NASYMB) = A4
      LSF_B1     (LSF_NASYMB) = B1
      LSF_B2     (LSF_NASYMB) = B2
      LSF_B3     (LSF_NASYMB) = B3
      LSF_B4     (LSF_NASYMB) = B4
      LSF_C      (LSF_NASYMB) = C
      LSF_FI     (LSF_NASYMB) = FI
      LSF_FII    (LSF_NASYMB) = FII
      LSF_RAD    (LSF_NASYMB) = RAD
  100 CONTINUE     
      IERR = 0
      IF(JERR.GT.0) IERR = JERR
      RETURN
      END


C ******
      SUBROUTINE PUT_MDLIB(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PUT_MDLIB - reads modification's description.
C -S-
C -------------------------------------------------------
      INCLUDE 'lib_com.fh'
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------------------
      IERR = 0

C     DATA ITL_MOD       /'_chem_mod.                              '/
      CALL LENSTR_BL(ITL_MOD,LMD)
      CALL LENSTR_BL(ITL_MODA,LMDA)
      CALL LENSTR_BL(ITL_MODR,LMDR)
      CALL LENSTR_BL(ITL_MODB,LMDB)
      CALL LENSTR_BL(ITL_MODG,LMDG)
      CALL LENSTR_BL(ITL_MODT,LMDT)
      CALL LENSTR_BL(ITL_MODC,LMDC)
      CALL LENSTR_BL(ITL_MODP,LMDP)


      IF(LDL_NMOD.LE.0) RETURN
      IF(ITEM(1:LMD).EQ.ITL_MOD(1:LMD)) THEN
c        CALL PT_MDLIST(MDOC,I,BLOCK,LENB,ITEM,LENI
c     *    ,DATA,IDATA,FDATA,LEND,IERR)
C      ELSE IF(ITEM(1:15).EQ.'_chem_mod_comp.') THEN
C        CALL PT_MDREC(MDOC,I,BLOCK,LENB,ITEM,LENI
C     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDA).EQ.ITL_MODA(1:LMDA)) THEN
        CALL PT_MDATOM(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDR).EQ.ITL_MODR(1:LMDR)) THEN
        CALL PT_MDCONN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDB).EQ.ITL_MODB(1:LMDB)) THEN
        CALL PT_MDBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDG).EQ.ITL_MODG(1:LMDG)) THEN
        CALL PT_MDANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDT).EQ.ITL_MODT(1:LMDT)) THEN
        CALL PT_MDTORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDC).EQ.ITL_MODC(1:LMDC)) THEN
        CALL PT_MDCHIR(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LMDP).EQ.ITL_MODP(1:LMDP)) THEN
        CALL PT_MDPLAN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)

      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDLIST(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C ---------------------------------------------
C -P- PT_MDLIST - reads modification's description.
C -S-
C ---------------------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      CHARACTER LINE*256
C -----------------------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------------------
      IERR=0

      CALL LENSTR_BL(ITL_MOD_ID,LMDI)

C      DATA ITL_MOD_NAME  /'_chem_mod.name                          '/
C      DATA ITL_MOD_COMP  /'_chem_mod.comp_id                       '/
C      DATA ITL_MOD_GRP   /'_chem_mod.group_id                      '/
      CALL LENSTR_BL(ITL_MOD_NAME,LMDN)
      CALL LENSTR_BL(ITL_MOD_COMP,LMDC)
      CALL LENSTR_BL(ITL_MOD_GRP ,LMDG)
         
      IF(ITEM(1:LMDI).EQ.ITL_MOD_ID) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod.id :',DATA(1:8),
     *          ' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR     = 1
          RETURN
        ENDIF
        LDL_NMOD = LDL_NMOD+1
        IF(LDL_NMOD.GT.MAXDMDF) THEN
          WRITE(LINE,'(A,I6,A)')' ERR: number of modifications >'
     *    ,MAXDMDF,' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
          LDL_NMOD = 0
          IERR     = 1
          RETURN
        ENDIF
        LDL_IMOD                 = LDL_NMOD
        LDL_MNAME(LDL_IMOD)(1:8) = DATA(1:8)
        LDL_FUSE (LDL_IMOD)      = 'N'
        IF(LB_PASS.GT.LB_NUMB_LIB)  LDL_FUSE(LDL_IMOD) = 'C'
        LDL_ORDER(LDL_IMOD)      = 0
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(1:LMDC).EQ.ITL_MOD_COMP(1:LMDC)) THEN
          LDL_COMP  (LDL_IMOD) =DATA(1:LEND)
        ELSE IF(ITEM(1:LMDN).EQ.ITL_MOD_NAME(1:LMDN)) THEN
          LDL_DETAIL (LDL_IMOD)=DATA(1:LEND)
        ELSE IF(ITEM(1:LMDG).EQ.ITL_MOD_GRP(1:LMDG)) THEN
          LDL_TYPE(LDL_IMOD)=DATA(1:LEND)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDREC(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C ---------------------------------------------
C -P- PT_MDREC -
C -S-
C ---------------------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256
C -----------------------------------
      IERR=0

      IF(I.EQ.1) THEN
        LMR_NREC=LMR_NREC+1
        IF(LMR_NREC.GT.MAXDMDF) THEN
          WRITE(LINE,'(A,I6,A)')
     * ' ERR: number of lines in _chem_mod_comp. >',MAXDMDF,
     * ' /lib. limit'
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *    ' Change parameter MAXMLIST in "lib_com.fh"')
          LMR_NREC=0
          IERR=1
          RETURN
        ENDIF
      ENDIF

C COMLETENESS ????

        IF(ITEM(16:22).EQ.     'comp_id'  ) THEN
          LMR_COMP   (LMR_NREC)=DATA(1:LEND)
        ELSE IF(ITEM(16:21).EQ.'mod_id'   ) THEN
          LMR_MNAME  (LMR_NREC)=DATA(1:LEND)
        ELSE IF(ITEM(16:19).EQ.'name') THEN
          LMR_DETAIL (LMR_NREC)=DATA(1:LEND)
        ELSE IF(ITEM(16:19).EQ.'type') THEN
          LMR_TYPE   (LMR_NREC)=DATA(1:LEND)
        ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDATOM(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDATOM 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MOD*8,ASYMB*4
C -----------------------------------
      IERR = 0
      IF(ITEM(16:21).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_atom.mod_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR     = 1
          RETURN
        ENDIF
        MOD = DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC,
     *    ' ERR: number of modifications in the list= 0')
          IERR = 1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD=1
        DO J=1,LDL_NMOD
          L = (LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C          IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD  = L
            LDA_NATOM = LDA_NATOM+1
            IF(LDA_NATOM.GT.MAXDATM) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')' ERR: number of atoms for mod:'
     *        ,MOD,'  >',MAXDATM,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LDL_IMOD = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LDL_IATOM(L).EQ.0) LDL_IATOM(L) = LDA_NATOM 
            LDA_MNAME(LDA_NATOM) = DATA(1:8)

            LDA_SYMB (LDA_NATOM) = '.'
            LDA_CHEM (LDA_NATOM) = '.'
            LDA_CHARG(LDA_NATOM) = 0.0
            LDA_ANEW (LDA_NATOM) = '.'

            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_atom.mod_id :',
     *     MOD,' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(16:22).EQ.'atom_id'  ) THEN
          LDA_ANAME(LDA_NATOM)=DATA(1:4)
        ELSE IF(ITEM(16:30).EQ.'new_type_symbol') THEN
          ASYMB=DATA(1:4)
          IF(ASYMB(1:1).NE.'.') THEN
            CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
            IERR = 0
          ENDIF
          LDA_SYMB (LDA_NATOM)=ASYMB
        ELSE IF(ITEM(16:30).EQ.'new_type_energy') THEN
          LDA_CHEM(LDA_NATOM)=DATA(1:4)
        ELSE IF(ITEM(16:23).EQ.'function') THEN
          LDA_FUNCT(LDA_NATOM)=DATA(1:8)
        ELSE IF(ITEM(16:33).EQ.'new_partial_charge') THEN
          LDA_CHARG(LDA_NATOM)=FDATA
        ELSE IF(ITEM(16:26).EQ.'new_atom_id') THEN
          LDA_ANEW (LDA_NATOM)=DATA(1:4)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDCONN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDCONN -
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------
      CHARACTER LINE*256,MOD*8
C -----------------------------------
      IERR = 0
      IF(ITEM(16:21).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_tree.mod_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR     = 1
          RETURN
        ENDIF
        MOD = DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of modifications in the list = 0')
          LDL_IMOD = 0           
          IERR     = 1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD = 1
        DO J=1,LDL_NMOD
          L = (LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C          IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD  = L
            LDN_NCONN = LDN_NCONN+1
            IF(LDN_NCONN.GT.MAXDCNN) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *        ' ERR: read number of connections for mod:'
     *        ,MOD,'  >',MAXDCNN,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LDL_IMOD = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LDL_ICONN(L).EQ.0) LDL_ICONN(L) = LDN_NCONN 

            LDN_MNAME(LDN_NCONN) = MOD

            LDN_ATOM (LDN_NCONN) = '.'
            LDN_BACK (LDN_NCONN) = '.'
            LDN_BTYPE(LDN_NCONN) = '.'
            LDN_FORW (LDN_NCONN) = '.'
            LDN_1ATM (LDN_NCONN) = '.'
            LDN_TYPE (LDN_NCONN) = '.'
            LDN_2ATM (LDN_NCONN) = '.'

            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_tree.mod_id :'
     *     ,MOD,' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR     = 1
        RETURN
      ENDIF

C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(16:22).EQ.     'atom_id' ) THEN 
          LDN_ATOM(LDN_NCONN)  = DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_back'  ) THEN
          IF(DATA(1:3).EQ.'n/a') DATA(1:4) = '.   '
          LDN_BACK(LDN_NCONN)  = DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'back_type'  ) THEN
          LDN_BTYPE(LDN_NCONN) = DATA(1:8)
        ELSE IF(ITEM(16:23).EQ.'function'  ) THEN
          LDN_FUNCT(LDN_NCONN) = DATA(1:8)
        ELSE IF(ITEM(16:27).EQ.'atom_forward'  ) THEN
          IF(DATA(1:3).EQ.'n/a') DATA(1:4) = '.   '
          LDN_FORW(LDN_NCONN)  = DATA(1:4)
        ELSE IF(ITEM(16:27).EQ.'connect_type'  ) THEN
          LDN_TYPE(LDN_NCONN)=DATA(1:8)
        ENDIF

C        ELSE IF(ITEM(27:43).EQ.'connect_atom_id_1'  ) THEN
C          LDN_1ATM(LDN_NCONN) = DATA(1:4)
C        ELSE IF(ITEM(27:38).EQ.'connect_type'  ) THEN
C          LDN_TYPE(LDN_NCONN) = DATA(1:8)
C        ELSE IF(ITEM(27:43).EQ.'connect_atom_id_2'  ) THEN
C          LDN_2ATM(LDN_NCONN) = DATA(1:4)
C        ENDIF

      ENDIF

      RETURN
C -----------------------------------
      END     


C ******
      SUBROUTINE PT_MDBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDBOND -
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MOD*8
C -----------------------------------
      IERR = 0
      IF(ITEM(16:21).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_bond.mod_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR     = 1
          RETURN
        ENDIF
        MOD = DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of modifications in the list= 0')
          IERR = 1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD = 1
        DO J=1,LDL_NMOD
          L = (LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C         IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD  = L
            LDB_NBOND = LDB_NBOND+1
            IF(LDB_NBOND.GT.MAXDBND) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of bonds for mod:',MOD,' >',MAXDBND,
     *      ' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LDL_IMOD = 0           
              IERR     = 1
              RETURN
            ENDIF
            IF(LDL_IBOND(L).EQ.0) LDL_IBOND(L)=LDB_NBOND 
            LDB_MNAME(LDB_NBOND) = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_bond.mod_id :',MOD,
     *   ' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR     = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(16:24).EQ.'atom_id_1'  ) THEN
          LDB_1ATM (LDB_NBOND)  = DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_2'  ) THEN
          LDB_2ATM (LDB_NBOND)  = DATA(1:4)
        ELSE IF(ITEM(16:23).EQ.'new_type') THEN
          LDB_TYPE (LDB_NBOND)  = DATA(1:8)
        ELSE IF(ITEM(16:33).EQ.'new_value_dist_esd') THEN
          LDB_DEV  (LDB_NBOND)  = FDATA
        ELSE IF(ITEM(16:29).EQ.'new_value_dist') THEN
          LDB_VAL  (LDB_NBOND)  = FDATA
        ELSE IF(ITEM(16:23).EQ.'function'  ) THEN
          LDB_FUNCT (LDB_NBOND) = DATA(1:8)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     
C ******

      SUBROUTINE PT_MDANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDANGL - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MOD*8
C -----------------------------------
      IERR=0
      IF(ITEM(17:22).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_angle.mod_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR=1
          RETURN
        ENDIF
        MOD=DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of modifications in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD=1
        DO J=1,LDL_NMOD
          L=(LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C          IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD = L
            LDG_NANGL=LDG_NANGL+1
            IF(LDG_NANGL.GT.MAXDANG) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *  ' ERR: read number of angles for mod:',MOD,' >',MAXDANG,
     *  ' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LDL_IMOD = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LDL_ITHET(L).EQ.0) LDL_ITHET(L)=LDG_NANGL 
            LDG_MNAME(LDG_NANGL) = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_angle.mod_id :',MOD,
     *  ' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????

      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:25)     .EQ.'atom_id_1'  ) THEN
          LDG_1ATM (LDG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_2'  ) THEN
          LDG_2ATM (LDG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'atom_id_3'  ) THEN
          LDG_3ATM (LDG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(17:35).EQ.'new_value_angle_esd') THEN
          LDG_DEV  (LDG_NANGL)=FDATA
        ELSE IF(ITEM(17:31).EQ.'new_value_angle') THEN
          LDG_VAL  (LDG_NANGL)=FDATA
        ELSE IF(ITEM(17:24).EQ.'function'  ) THEN
          LDG_FUNCT (LDG_NANGL)=DATA(1:8)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDTORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDTORS - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MOD*8
C -----------------------------------
      IERR=0
      IF(ITEM(15:20).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_tor.mod_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR=1
          RETURN
        ENDIF
        MOD=DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of modifications in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD=1
        DO J=1,LDL_NMOD
          L=(LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C          IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD = L
            LDT_NTORS=LDT_NTORS+1
            IF(LDT_NTORS.GT.MAXDTOR) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *       ' ERR: read number of tors for mod:'
     *        ,MOD,'  >',MAXDTOR,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LDL_IMOD = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LDL_ITORS(L).EQ.0) LDL_ITORS(L)=LDT_NTORS 
            LDT_MNAME(LDT_NTORS) = DATA(1:8)
            LDT_LABEL(LDT_NTORS) = '.'
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_tor.mod_id :'
     *  ,MOD,' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(15:33).EQ.'new_value_angle_esd' ) THEN
          LDT_DEV  (LDT_NTORS)=FDATA
        ELSE IF(ITEM(15:29).EQ.'new_value_angle'    ) THEN
          LDT_VAL  (LDT_NTORS)=FDATA
        ELSE IF(ITEM(15:24).EQ.'new_period') THEN
          LDT_PRD  (LDT_NTORS)=IDATA
        ELSE IF(ITEM(15:23).EQ.'atom_id_1') THEN
          LDT_1ATM (LDT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(15:23).EQ.'atom_id_2') THEN
          LDT_2ATM (LDT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(15:23).EQ.'atom_id_3') THEN
          LDT_3ATM (LDT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(15:23).EQ.'atom_id_4') THEN
          LDT_4ATM (LDT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(15:16).EQ.'id') THEN
          LDT_LABEL(LDT_NTORS)=DATA(1:8)
        ELSE IF(ITEM(15:22).EQ.'function') THEN
          LDT_FUNCT(LDT_NTORS)=DATA(1:8)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDPLAN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDPLAN -
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      COMMON/STTDPLN/ DEV,ISATOM,LABEL,MNAME,FUNCT
      REAL      DEV
      INTEGER*4 ISATOM
      CHARACTER LABEL*8,MNAME*8,FUNCT*8
C ---
      INTEGER*4 IATOM
      CHARACTER LINE*256,MOD*8,ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C -----------------------------------
      IERR=0
      IF(ITEM(22:27).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')
     *     ' ERR: item _chem_mod_plane_atom.mod_id :',DATA(1:8)
     *    ,' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR=1
          RETURN
        ENDIF
        MOD=DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of modifications in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD=1
        DO J=1,LDL_NMOD
          L=(LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C          IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD = L
            MNAME = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_plane_atom.mod_id :'
     *   ,MOD,' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(22:29).EQ.     'plane_id'    ) THEN
          LABEL= DATA(1:8)
        ELSE IF(ITEM(22:29).EQ.'function'    ) THEN
          FUNCT= DATA(1:8)
        ELSE IF(ITEM(22:28).EQ.'atom_id') THEN
          ATOM = DATA(1:4)
          ISATOM=IATOM
        ELSE IF(ITEM(22:33).EQ.'new_dist_esd') THEN
          DEV = FDATA
        ENDIF
      ENDIF

      IF(LDL_IMOD.GT.0.AND.I.EQ.5) THEN
        L=LDL_IMOD
        IF(LDL_IPLAN(L).LE.LDP_NPLAN) THEN
          IF(LDL_IPLAN(L).GT.0) THEN
            DO II=LDL_IPLAN(L),LDP_NPLAN
               IF(LABEL.EQ.LDP_LABEL(II)) GO TO 100
            ENDDO
          ENDIF
          LDP_NPLAN=LDP_NPLAN+1
          IF(LDP_NPLAN.GT.MAXDPLN) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *  ' ERR: read number of plans for mod:',MNAME,' >',MAXDPLN,
     *  ' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LDL_IMOD = 0           
            IERR=1
            RETURN
          ENDIF
          IF(LDL_IPLAN(L).EQ.0) LDL_IPLAN(L)=LDP_NPLAN
          II=LDP_NPLAN
          LDP_NATOM(II)=0
          LDP_MNAME(II)=MNAME
 100      CONTINUE

          LDP_NATOM(II)=LDP_NATOM(II)+1
          IF(LDP_NATOM(II).GT.MAXDAPL) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of plans atom for monomer ',MNAME,
     *      '  >',MAXDAPL,' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LDL_IMOD = 0           
            IERR=1
            RETURN
          ENDIF
          LDP_FUNCT(II)=FUNCT
          LDP_LABEL(II)=LABEL
          LDP_ATOM (LDP_NATOM(II),II) = ISATOM
          LDP_DEV  (LDP_NATOM(II),II) = DEV
        ENDIF
      ENDIF 
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_MDCHIR(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_MDCHIR - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,MOD*8
C -----------------------------------
      IERR=0
      IF(ITEM(16:21).EQ.'mod_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_chir.mod_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LDL_IMOD = 0           
          IERR=1
          RETURN
        ENDIF
        MOD=DATA(1:8)
        IF(LDL_NMOD.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of modifications in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LDL_IMOD.EQ.0) LDL_IMOD=1
        DO J=1,LDL_NMOD
          L=(LDL_IMOD-1)+J
          IF(L.GT.LDL_NMOD) L=L-LDL_NMOD
C          IF(MOD.EQ.LDL_MNAME(L).AND.LDL_SUB_MOD(L)(1:1).EQ.'.')THEN
          IF(MOD.EQ.LDL_MNAME(L))THEN
            LDL_IMOD = L
            LDC_NCHIR=LDC_NCHIR+1
            IF(LDC_NCHIR.GT.MAXMCHR) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *        ' ERR: read number of chiralities for mod:',MOD,
     *        '  >',MAXMCHR,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LDL_IMOD = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LDL_ICHIR(L).EQ.0) LDL_ICHIR(L)=LDC_NCHIR 
            LDC_MNAME(LDC_NCHIR) = DATA(1:8)
            LDC_1ATM (LDC_NCHIR) = '.'
            LDC_2ATM (LDC_NCHIR) = '.'
            LDC_3ATM (LDC_NCHIR) = '.'
            LDC_4ATM (LDC_NCHIR) = '.'
            LDC_5ATM (LDC_NCHIR) = '.'
            LDC_6ATM (LDC_NCHIR) = '.'
            LDC_7ATM (LDC_NCHIR) = '.'
            LDC_8ATM (LDC_NCHIR) = '.'
            LDC_9ATM (LDC_NCHIR) = '.'
            LDC_SIGN (LDC_NCHIR) = '.'
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_mod_chir.mod_id :',MOD
     *  ,' not found in the list of modifications'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LDL_IMOD = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LDL_IMOD.GT.0.AND.I.GT.1) THEN
        IF(ITEM(16:30).EQ.'new_volume_sign'    ) THEN
          LDC_SIGN  (LDC_NCHIR)=DATA(1:8)
        ELSE IF(ITEM(16:23).EQ.'function'    ) THEN
          LDC_FUNCT (LDC_NCHIR)=DATA(1:8)
        ELSE IF(ITEM(16:29).EQ.'atom_id_centre') THEN
          LDC_1ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_1') THEN
          LDC_2ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_2') THEN
          LDC_3ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_3') THEN
          LDC_4ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_4') THEN
          LDC_5ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_5') THEN
          LDC_6ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_6') THEN
          LDC_7ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_7') THEN
          LDC_8ATM (LDC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(16:24).EQ.'atom_id_8') THEN
          LDC_9ATM (LDC_NCHIR)=DATA(1:4)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PUT_LNLIB(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PUT_LNLIB - reads link's description.
C -S-
C -------------------------------------------------------
      INCLUDE 'lib_com.fh'
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------------------
      IERR=0

C      DATA ITL_LNK       /'_chem_link.                             '/
C      DATA ITL_LNKB      /'_chem_link_bond.                        '/
C      DATA ITL_LNKG      /'_chem_link_angle.                       '/
C      DATA ITL_LNKT      /'_chem_link_tor.                         '/
C      DATA ITL_LNKC      /'_chem_link_chir.                        '/
C      DATA ITL_LNKP      /'_chem_link_plane.                       '/

      CALL LENSTR_BL(ITL_LNK ,LLNK)
      CALL LENSTR_BL(ITL_LNKB,LLNKB)
      CALL LENSTR_BL(ITL_LNKG,LLNKG)
      CALL LENSTR_BL(ITL_LNKT,LLNKT)
      CALL LENSTR_BL(ITL_LNKC,LLNKC)
      CALL LENSTR_BL(ITL_LNKP,LLNKP)
 
      IF(LLL_NLINK.LE.0) RETURN
      IF(ITEM(1:LLNK).EQ.ITL_LNK(1:LLNK)) THEN
C        CALL PT_LNLIST(MDOC,I,BLOCK,LENB,ITEM,LENI
C     *    ,DATA,IDATA,FDATA,LEND,IERR)
C      ELSE IF(ITEM(1:16).EQ.'_chem_link_tree.') THEN
C        CALL PT_LNCONN(MDOC,I,BLOCK,LENB,ITEM,LENI
C     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LLNKB).EQ.ITL_LNKB(1:LLNKB)) THEN
        CALL PT_LNBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LLNKG).EQ.ITL_LNKG(1:LLNKG)) THEN
        CALL PT_LNANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LLNKT).EQ.ITL_LNKT(1:LLNKT)) THEN
        CALL PT_LNTORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LLNKC).EQ.ITL_LNKC(1:LLNKC)) THEN
        CALL PT_LNCHIR(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:LLNKP).EQ.ITL_LNKP(1:LLNKP)) THEN
        CALL PT_LNPLAN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)

      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_LNLIST(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C ---------------------------------------------
C -P- PT_LNLIST - reads link's description.
C -S-
C ---------------------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256
C -----------------------------------------------
      INCLUDE 'CIF_items_lib.fh'
C -----------------------------------------------
      IERR=0

C      DATA ITL_LNK_ID    /'_chem_link.id                           '/
C      DATA ITL_LNK_NAME  /'_chem_link.name                         '/
C      DATA ITL_LNK_COM1  /'_chem_link.comp_id_1                    '/
C      DATA ITL_LNK_MOD1  /'_chem_link.mod_id_1                     '/
C      DATA ITL_LNK_GRP1  /'_chem_link.group_comp_1                 '/
C      DATA ITL_LNK_COM2  /'_chem_link.comp_id_2                    '/
C      DATA ITL_LNK_MOD2  /'_chem_link.mod_id_2                     '/
C      DATA ITL_LNK_GRP2  /'_chem_link.group_comp_2                 '/

      CALL LENSTR_BL(ITL_LNK_ID  ,LLID)
         
      IF(ITEM(1:LLID).EQ.ITL_LNK_ID(1:LLID)) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link.id :',DATA(1:8)
     *          ,' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_IMOD = 0           
          IERR     = 1
          RETURN
        ENDIF
        LLL_NLINK = LLL_NLINK+1
        IF(LLL_NLINK.GT.MAXLLNK) THEN
          WRITE(LINE,'(A,I6,A)')' ERR: number of links >',MAXLLNK,
     *    ' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
          LLL_NLINK = 0
          IERR      = 1
          RETURN
        ENDIF
        LLL_ILINK                 = LLL_NLINK
        LLL_LNAME(LLL_ILINK)(1:8) = DATA(1:8)
        LLL_FUSE (LLL_ILINK)      = 'N'
        IF(LB_PASS.GT.LB_NUMB_LIB)  LLL_FUSE(LLL_ILINK) = 'C'
        RETURN
      ENDIF
C COMLETENESS ????
      CALL LENSTR_BL(ITL_LNK_NAME,LLNM)
      CALL LENSTR_BL(ITL_LNK_COM1,LLC1)
      CALL LENSTR_BL(ITL_LNK_MOD1,LLM1)
      CALL LENSTR_BL(ITL_LNK_GRP1,LLG1)
      CALL LENSTR_BL(ITL_LNK_COM2,LLC2)
      CALL LENSTR_BL(ITL_LNK_MOD2,LLM2)
      CALL LENSTR_BL(ITL_LNK_GRP2,LLG2)
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(12:26).EQ.'one_letter_code'  ) THEN
          LLL_CODE1  (LLL_ILINK)=DATA(1:1)
        ELSE IF(ITEM(1:LLNM).EQ.ITL_LNK_NAME(1:LLNM)) THEN
          LLL_DETAIL (LLL_ILINK)=DATA(1:LEND)
        ELSE IF(ITEM(1:LLC1).EQ.ITL_LNK_COM1(1:LLC1)) THEN
          LLL_MON1   (LLL_ILINK)=DATA(1:LEND)
        ELSE IF(ITEM(1:LLC2).EQ.ITL_LNK_COM2(1:LLC2)) THEN
          LLL_MON2   (LLL_ILINK)=DATA(1:LEND)
        ELSE IF(ITEM(1:LLM1).EQ.ITL_LNK_MOD1(1:LLM1)) THEN
          LLL_MOD1   (LLL_ILINK)=DATA(1:LEND)
        ELSE IF(ITEM(1:LLM2).EQ.ITL_LNK_MOD2(1:LLM2)) THEN
          LLL_MOD2   (LLL_ILINK)=DATA(1:LEND)
        ELSE IF(ITEM(1:LLG1).EQ.ITL_LNK_GRP1(1:LLG1)) THEN
          LLL_TYPE1  (LLL_ILINK)=DATA(1:LEND)
        ELSE IF(ITEM(1:LLG2).EQ.ITL_LNK_GRP2(1:LLG2)) THEN
          LLL_TYPE2  (LLL_ILINK)=DATA(1:LEND)
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_LNCONN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_LNCONN -
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,LINK*8
C -----------------------------------
      IERR = 0
      IF(ITEM(17:23).EQ.'link_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_tree.link_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_ILINK = 0           
          IERR      = 1
          RETURN
        ENDIF
        LINK = DATA(1:8)
        IF(LLL_NLINK.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of links in the list = 0')
          LLL_ILINK = 0           
          IERR      = 1
          RETURN
        ENDIF
        IF(LLL_ILINK.EQ.0) LLL_ILINK=1
        DO J=1,LLL_NLINK
          L=(LLL_ILINK-1)+J
          IF(L.GT.LLL_NLINK) L=L-LLL_NLINK
          IF(LINK.EQ.LLL_LNAME(L)) THEN
            LLL_ILINK = L
            LLN_NCONN = LLN_NCONN+1
            IF(LLN_NCONN.GT.MAXLCNN) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *        ' ERR: read number of connections for link:'
     *        ,LINK,'  >',MAXLCNN,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LLL_ILINK = 0           
              IERR      = 1
              RETURN
            ENDIF
            IF(LLL_ICONN(L).EQ.0) LLL_ICONN(L)=LLN_NCONN 
            LLN_LNAME(LLN_NCONN) = LINK
            LLN_ATOM (LLN_NCONN) = '.'
            LLN_FATOM(LLN_NCONN) = 0
            LLN_BACK (LLN_NCONN) = '.'
            LLN_FBACK(LLN_NCONN) = 0
            LLN_BTYPE(LLN_NCONN) = '.'
            LLN_FORW (LLN_NCONN) = '.'
            LLN_FFORW(LLN_NCONN) = 0
            LLN_1ATM (LLN_NCONN) = '.'
            LLN_F1ATM(LLN_NCONN) = 0
            LLN_TYPE (LLN_NCONN) = '.'
            LLN_2ATM (LLN_NCONN) = '.'
            LLN_F2ATM(LLN_NCONN) = 0
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_tree.link_id :'
     *     ,LINK,' not found in the list of links'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LLL_ILINK = 0           
        IERR      = 1
        RETURN
      ENDIF

C COMLETENESS ????
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:29).EQ.'_atom_comp_id'  ) THEN
          LLN_FATOM(LLN_NCONN)=IDATA
        ELSE IF(ITEM(17:23).EQ.'atom_id' ) THEN 
          LLN_ATOM(LLN_NCONN)=DATA(1:4)
        ELSE IF(ITEM(17:33).EQ.'atom_back_comp_id'  ) THEN
          LLN_FBACK(LLN_NCONN)=IDATA
        ELSE IF(ITEM(17:25).EQ.'atom_back'  ) THEN
          IF(DATA(1:3).EQ.'n/a') DATA(1:4) = '.   '
          LLN_BACK(LLN_NCONN)=DATA(1:4)
        ELSE IF(ITEM(17:25).EQ.'back_type'  ) THEN
          LLN_BTYPE(LLN_NCONN)=DATA(1:8)
        ELSE IF(ITEM(17:36).EQ.'atom_forward_comp_id'  ) THEN
          LLN_FFORW(LLN_NCONN)=IDATA
        ELSE IF(ITEM(17:28).EQ.'atom_forward'  ) THEN
          IF(DATA(1:3).EQ.'n/a') DATA(1:4) = '.   '
          LLN_FORW(LLN_NCONN)=DATA(1:4)
        ELSE IF(ITEM(17:28).EQ.'connect_type'  ) THEN
          LLN_TYPE(LLN_NCONN)=DATA(1:8)
        ENDIF

c        ELSE IF(ITEM(28:49).EQ.'connect_atom_comp_id_1'  ) THEN
c          LLN_F1ATM(LLN_NCONN)=IDATA
c        ELSE IF(ITEM(28:44).EQ.'connect_atom_id_1'  ) THEN
c          LLN_1ATM(LLN_NCONN)=DATA(1:4)
c        ELSE IF(ITEM(28:39).EQ.'connect_type'  ) THEN
c          LLN_TYPE(LLN_NCONN)=DATA(1:8)
c        ELSE IF(ITEM(28:49).EQ.'connect_atom_comp_id_2'  ) THEN
c          LLN_F2ATM(LLN_NCONN)=IDATA
c        ELSE IF(ITEM(28:44).EQ.'connect_atom_id_2'  ) THEN
c          LLN_2ATM(LLN_NCONN)=DATA(1:4)
c        ENDIF

      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_LNBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_LNBOND -
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,LINK*8
C -----------------------------------
      IERR=0
      IF(ITEM(17:23).EQ.'link_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_bond.link_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_ILINK = 0           
          IERR=1
          RETURN
        ENDIF
        LINK=DATA(1:8)
        IF(LLL_NLINK.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of links in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LLL_ILINK.EQ.0) LLL_ILINK=1
        DO J=1,LLL_NLINK
          L=(LLL_ILINK-1)+J
          IF(L.GT.LLL_NLINK) L=L-LLL_NLINK
          IF(LINK.EQ.LLL_LNAME(L)) THEN
            LLL_ILINK = L
            LLB_NBOND=LLB_NBOND+1
            IF(LLB_NBOND.GT.MAXLBND) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of bonds for link:',LINK,' >',MAXLBND
     *        ,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LLL_ILINK = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LLL_IBOND(L).EQ.0) LLL_IBOND(L)=LLB_NBOND 
            LLB_LNAME(LLB_NBOND) = DATA(1:8)
            RETURN
          ENDIF
        ENDDO   
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_bond.link_id :'
     *    ,LINK,' not found in the list of links'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LLL_ILINK = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:30).EQ.'atom_1_comp_id'  ) THEN
          LLB_F1ATM (LLB_NBOND)=IDATA
        ELSE IF(ITEM(17:25).EQ.'atom_id_1'  ) THEN
          LLB_1ATM (LLB_NBOND)=DATA(1:4)
        ELSE IF(ITEM(17:30).EQ.'atom_2_comp_id'  ) THEN
          LLB_F2ATM (LLB_NBOND)=IDATA
        ELSE IF(ITEM(17:25).EQ.'atom_id_2'  ) THEN
          LLB_2ATM (LLB_NBOND)=DATA(1:4)
        ELSE IF(ITEM(17:20).EQ.'type') THEN
          LLB_TYPE (LLB_NBOND)=DATA(1:8)
        ELSE IF(ITEM(17:30).EQ.'value_dist_esd') THEN
          LLB_DEV  (LLB_NBOND)=FDATA
        ELSE IF(ITEM(17:26).EQ.'value_dist') THEN
          LLB_VAL  (LLB_NBOND)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     
C ******

      SUBROUTINE PT_LNANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_LNANGL - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,LINK*8
C -----------------------------------
      IERR=0
      IF(ITEM(18:24).EQ.'link_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_angle.link_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_ILINK = 0           
          IERR=1
          RETURN
        ENDIF
        LINK=DATA(1:8)
        IF(LLL_NLINK.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of links in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LLL_ILINK.EQ.0) LLL_ILINK=1
        DO J=1,LLL_NLINK
          L=(LLL_ILINK-1)+J
          IF(L.GT.LLL_NLINK) L=L-LLL_NLINK
          IF(LINK.EQ.LLL_LNAME(L)) THEN
            LLL_ILINK = L
            LLG_NANGL=LLG_NANGL+1
            IF(LLG_NANGL.GT.MAXLANG) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of angles for link:',LINK,' >',MAXLANG
     *        ,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LLL_ILINK = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LLL_ITHET(L).EQ.0) LLL_ITHET(L)=LLG_NANGL 
            LLG_LNAME(LLG_NANGL) = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_angle.link_id :'
     *   ,LINK,' not found in the list of links'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LLL_ILINK = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(18:26)     .EQ.'atom_id_1'  ) THEN
          LLG_1ATM (LLG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(18:31).EQ.'atom_1_comp_id'  ) THEN
          LLG_F1ATM (LLG_NANGL)=IDATA
        ELSE IF(ITEM(18:26).EQ.'atom_id_2'  ) THEN
          LLG_2ATM (LLG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(18:31).EQ.'atom_2_comp_id'  ) THEN
          LLG_F2ATM (LLG_NANGL)=IDATA
        ELSE IF(ITEM(18:26).EQ.'atom_id_3'  ) THEN
          LLG_3ATM (LLG_NANGL)=DATA(1:4)
        ELSE IF(ITEM(18:31).EQ.'atom_3_comp_id'  ) THEN
          LLG_F3ATM (LLG_NANGL)=IDATA
        ELSE IF(ITEM(18:32).EQ.'value_angle_esd') THEN
          LLG_DEV  (LLG_NANGL)=FDATA
        ELSE IF(ITEM(18:28).EQ.'value_angle') THEN
          LLG_VAL  (LLG_NANGL)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_LNTORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_LNTORS - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,LINK*8
C -----------------------------------
      IERR=0
      IF(ITEM(16:23).EQ.'link_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_tor.link_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_ILINK = 0           
          IERR=1
          RETURN
        ENDIF
        LINK=DATA(1:8)
        IF(LLL_NLINK.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of links in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LLL_ILINK.EQ.0) LLL_ILINK=1
        DO J=1,LLL_NLINK
          L=(LLL_ILINK-1)+J
          IF(L.GT.LLL_NLINK) L=L-LLL_NLINK
          IF(LINK.EQ.LLL_LNAME(L)) THEN
            LLL_ILINK = L
            LLT_NTORS=LLT_NTORS+1
            IF(LLT_NTORS.GT.MAXLTOR) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of tors for link:',LINK,' >',MAXLTOR
     *        ,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LLL_ILINK = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LLL_ITORS(L).EQ.0) LLL_ITORS(L)=LLT_NTORS 
            LLT_LNAME(LLT_NTORS) = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_tor.link_id :',LINK
     *  ,' not found in the list of links'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LLL_ILINK = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(16:30).EQ.'value_angle_esd' ) THEN
          LLT_DEV  (LLT_NTORS)=FDATA
        ELSE IF(ITEM(16:26).EQ.'value_angle') THEN
          LLT_VAL  (LLT_NTORS)=FDATA
        ELSE IF(ITEM(16:21).EQ.'period') THEN
          LLT_PRD  (LLT_NTORS)=IDATA
        ELSE IF(ITEM(16:24).EQ.'atom_id_1') THEN
          LLT_1ATM (LLT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:29).EQ.'atom_1_comp_id') THEN
          LLT_F1ATM (LLT_NTORS)=IDATA
        ELSE IF(ITEM(16:24).EQ.'atom_id_2') THEN
          LLT_2ATM (LLT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:29).EQ.'atom_2_comp_id') THEN
          LLT_F2ATM (LLT_NTORS)=IDATA
        ELSE IF(ITEM(16:24).EQ.'atom_id_3') THEN
          LLT_3ATM (LLT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:29).EQ.'atom_3_comp_id') THEN
          LLT_F3ATM (LLT_NTORS)=IDATA
        ELSE IF(ITEM(16:24).EQ.'atom_id_4') THEN
          LLT_4ATM (LLT_NTORS)=DATA(1:4)
        ELSE IF(ITEM(16:29).EQ.'atom_4_comp_id') THEN
          LLT_F4ATM (LLT_NTORS)=IDATA
        ELSE IF(ITEM(16:17).EQ.'id') THEN
          LLT_LABEL(LLT_NTORS)=DATA(1:8)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_LNPLAN(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_LNPLAN -
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      COMMON/STTLPLN/ DEV,ISATOM,LABEL,LNAME,FLAG
      REAL      DEV
      INTEGER*4 ISATOM,FLAG
      CHARACTER LABEL*8,LNAME*8
C ---
      INTEGER*4 IATOM
      CHARACTER LINE*256,LINK*8,ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C -----------------------------------
      IERR = 0
      IF(ITEM(18:24).EQ.'link_id' ) THEN 
        IF(I.NE.1) THEN
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_plane.link_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_ILINK = 0           
          IERR      = 1
          RETURN
        ENDIF
        LINK = DATA(1:8)
        IF(LLL_NLINK.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of links in the list= 0')
          IERR = 1
          RETURN
        ENDIF
        IF(LLL_ILINK.EQ.0) LLL_ILINK = 1
        DO J=1,LLL_NLINK
          L = (LLL_ILINK-1)+J
          IF(L.GT.LLL_NLINK) L = L-LLL_NLINK
          IF(LINK.EQ.LLL_LNAME(L)) THEN
            LLL_ILINK = L
            LNAME     = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
      WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_plane.link_id :'
     *   ,LINK,' not found in the list of links'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LLL_ILINK = 0           
        IERR      = 1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(18:25).EQ.     'plane_id'    ) THEN
          LABEL  = DATA(1:8)
        ELSE IF(ITEM(18:29).EQ.'atom_comp_id') THEN
          FLAG   = IDATA
        ELSE IF(ITEM(18:24).EQ.'atom_id') THEN
          ATOM   = DATA(1:4)
          ISATOM = IATOM
        ELSE IF(ITEM(18:25).EQ.'dist_esd') THEN
          DEV    = FDATA
        ENDIF
      ENDIF

      IF(LLL_ILINK.GT.0.AND.I.EQ.5) THEN
        L = LLL_ILINK
        IF(LLL_IPLAN(L).LE.LLP_NPLAN) THEN
          IF(LLL_IPLAN(L).GT.0) THEN
            DO II=LLL_IPLAN(L),LLP_NPLAN
               IF(LABEL.EQ.LLP_LABEL(II)) GO TO 100
            ENDDO
          ENDIF
          LLP_NPLAN = LLP_NPLAN+1
          IF(LLP_NPLAN.GT.MAXLPLN) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of plans for link:',LNAME,' >',
     *      MAXLPLN,' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LLL_ILINK = 0           
            IERR      = 1
            RETURN
          ENDIF
          IF(LLL_IPLAN(L).EQ.0) LLL_IPLAN(L) = LLP_NPLAN
          II            = LLP_NPLAN
          LLP_NATOM(II) = 0
          LLP_LNAME(II) = LNAME
 100      CONTINUE

          LLP_NATOM(II) = LLP_NATOM(II)+1
          IF(LLP_NATOM(II).GT.MAXLAPL) THEN
            WRITE(LINE,'(A,A8,A,I6,A)')
     *      ' ERR: read number of plans atom for link: '
     *      ,LNAME,'  >',MAXLAPL,' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            LLL_ILINK = 0           
            IERR      = 1
            RETURN
          ENDIF
          LLP_LABEL(II)               = LABEL
          LLP_FATOM(LLP_NATOM(II),II) = FLAG
          LLP_ATOM (LLP_NATOM(II),II) = ISATOM
          LLP_DEV  (LLP_NATOM(II),II) = DEV
        ENDIF
      ENDIF 
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_LNCHIR(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_LNCHIR - 
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,LINK*8
C -----------------------------------
      IERR=0  
      IF(ITEM(17:23).EQ.'link_id' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_chir.link_id :'
     *    ,DATA(1:8),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LLL_ILINK = 0           
          IERR=1
          RETURN
        ENDIF
        LINK=DATA(1:8)
        IF(LLL_NLINK.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of links in the list= 0')
          IERR=1
          RETURN
        ENDIF
        IF(LLL_ILINK.EQ.0) LLL_ILINK=1
        DO J=1,LLL_NLINK
          L=(LLL_ILINK-1)+J
          IF(L.GT.LLL_NLINK) L=L-LLL_NLINK
          IF(LINK.EQ.LLL_LNAME(L)) THEN
            LLL_ILINK = L
            LLC_NCHIR=LLC_NCHIR+1
            IF(LLC_NCHIR.GT.MAXLCHR) THEN
              WRITE(LINE,'(A,A8,A,I6,A)')
     *        ' ERR: read number of chiralities for link:'
     *        ,LINK,'  >',MAXLCHR,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
              LLL_ILINK = 0           
              IERR=1
              RETURN
            ENDIF
            IF(LLL_ICHIR(L).EQ.0) LLL_ICHIR(L)=LLC_NCHIR 
            LLC_LNAME(LLC_NCHIR) = DATA(1:8)
            RETURN
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' ERR: item _chem_link_chir.link_id :'
     *  ,LINK,' not found in the list of links'
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,'('' BLOCK :'',A)') BLOCK(1:LENB)
        CALL MSGERR(MDOC,LINE)
        LLL_ILINK = 0           
        IERR=1
        RETURN
      ENDIF
C COMLETENESS ????
      IF(LLL_ILINK.GT.0.AND.I.GT.1) THEN
        IF(ITEM(17:27).EQ.'volume_sign'    ) THEN
          LLC_SIGN  (LLC_NCHIR)=DATA(1:8)
        ELSE IF(ITEM(17:30).EQ.'atom_id_centre') THEN
          LLC_1ATM (LLC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:35).EQ.'atom_centre_comp_id') THEN
          LLC_F1ATM (LLC_NCHIR)=IDATA
        ELSE IF(ITEM(17:25).EQ.'atom_id_1') THEN
          LLC_2ATM (LLC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:30).EQ.'atom_1_comp_id') THEN
          LLC_F2ATM (LLC_NCHIR)=IDATA
        ELSE IF(ITEM(17:25).EQ.'atom_id_2') THEN
          LLC_3ATM (LLC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:30).EQ.'atom_2_comp_id') THEN
          LLC_F3ATM (LLC_NCHIR)=IDATA
        ELSE IF(ITEM(17:25).EQ.'atom_id_3') THEN
          LLC_4ATM (LLC_NCHIR)=DATA(1:4)
        ELSE IF(ITEM(17:30).EQ.'atom_3_comp_id') THEN
          LLC_F4ATM (LLC_NCHIR)=IDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     


         SUBROUTINE COPYMD(MDOC,IMOD,IERR)
         RETURN
         END
         SUBROUTINE CHKMOD(MDOC,ML_ID,JERR)
         RETURN
         END
         SUBROUTINE CHKLNK(MDOC,LN_ID,JERR)
         RETURN
         END
         SUBROUTINE COPYLN(MDOC,ILINK,IERR)
         RETURN
         END 

C ******
      SUBROUTINE RD_ENRLIB(MDOC,MODE,IERR)
C -------------------------------------------------------
C -P- RD_ENLIB - reads library of energy parameters
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
      INCLUDE 'crd_com.fh'
C ----------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---
      COMMON/COM_CRD_CIF/ IEND_CIF      
C ---
C -----------------------------------
      REAL      FDATA
      INTEGER*4 IDATA,IUN,M,IEND
      CHARACTER DATA*80,ITEM*80
C -----------------------------------
      IERR = 0
      IEND = 0

      IF(MODE.EQ.'ALL ') LEA_NATOM = 0
      LEB_NBOND  = 0
      LEG_NANGL  = 0
      LET_NTORS  = 0
      LEW_NCONT  = 0
      LEH_NHBOND = 0
      LES_NSYN   = 0

C ------
C     open file of mon_library
C     IUN = 10
      IUN = CRI_IUN
      M   = 99
      CALL OPENFR(IUN,M,LEI_PATH,LEI_FILE,LEI_EXT,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: can''t open "ener_lib.cif"')
        RETURN
      ENDIF
      LEI_IUN = IUN
      IEND    =-1
C -------
      IF(IEND.EQ.-1) THEN
        REWIND IUN
        IEND_CIF =-1
        IEND     = 0
      ENDIF

  300 CONTINUE   
      
      CALL GETCIF_INFO(IUN,MDOC,IERR,IEND_CIF)
      IF(IERR.NE.0.OR.(IEND_CIF.NE.0.AND.IEND_CIF.NE.-2)) THEN
        CLOSE(IUN,ERR=410)
 410    CONTINUE
        LEI_IUN = 0
        IEND    = 1
        RETURN
      ENDIF

      IF(IEND_CIF.EQ.-2) THEN
C
C       This string / DT_CIF (NWORDSMAX) / is a comment
C   
        GO TO 300
      ENDIF
      
      IF(N_CIF.LE.0) GO TO 300

      DO I=1,N_CIF
        CALL LENSTR_BL(ITM_CIF(I),LENI) 
        ITEM  = ITM_CIF(I)(1:LENI)
        CALL LENSTR_BL(DT_CIF(I),LEND) 
        DATA  = DT_CIF(I)(1:LEND)
        CALL LENSTR_BL(BLK_CIF,LENB) 
        IDATA = IDT_CIF(I)
        FDATA = FDT_CIF(I)

        IF(BLK_CIF(1:7) .EQ.'global_') THEN         

        ELSE IF(ITEM(1:5).EQ.'_lib_') THEN
          CALL PUT_ENLIB(MDOC,MODE,I,BLK_CIF,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
          IF(IERR.NE.0) THEN
            CLOSE(IUN,ERR=400)
 400        CONTINUE
            LEI_IUN = 0
            RETURN
          ENDIF
        ENDIF
      ENDDO
      GO TO 300
C -----------------------------------
      END     

C ******
      SUBROUTINE PUT_ENLIB(MDOC,MODE,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PUT_ENLIB - reads energy library.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*),MODE*4
C ******
C -----------------------------------------------
      IERR=0
      IF(ITEM(1:9).EQ.'_lib_atom') THEN
        CALL PT_EATOM(MDOC,MODE,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:9).EQ.'_lib_bond') THEN
        CALL PT_EBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:9).EQ.'_lib_angl') THEN
        CALL PT_EANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:9).EQ.'_lib_tors') THEN
        CALL PT_ETORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:8).EQ.'_lib_vdw') THEN
        CALL PT_EVDW(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:10).EQ.'_lib_hbond') THEN
        CALL PT_EHBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)
      ELSE IF(ITEM(1:12).EQ.'_lib_synonym') THEN
        CALL PT_ESYNONYM(MDOC,I,BLOCK,LENB,ITEM,LENI
     *    ,DATA,IDATA,FDATA,LEND,IERR)

      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_EATOM(MDOC,MODE,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_EATOM - reads energy library information about atoms.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*),MODE*4
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,CHEM*4
C -----------------------------------
      IERR = 0
      IF(ITEM(11:14).EQ.'type' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_atom.type :',DATA(1:4)
     *    ,' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LEA_IATOM = 0           
          IERR      = 1
          RETURN
        ENDIF
        CHEM = DATA(1:4)
        IF(MODE.NE.'ALL ') THEN
          IF(LEA_NATOM.LE.0) THEN
            CALL MSGERR(MDOC
     *      ,' ERR: number of atom types in the list= 0')
            LEA_IATOM = 0           
            IERR      = 1
            RETURN
          ENDIF
          DO L=1,LEA_NATOM
            IF(CHEM.EQ.LEA_ANAME(L)) THEN
              LEA_IATOM           = L
              LEA_TYPE(LEA_IATOM) = 'Y'
              RETURN
            ENDIF
          ENDDO
          IF(CHEM(1:1).EQ.'H'.AND.MODE.EQ.'H   ') THEN
            IF(LEA_NATOM.GT.MAXETYP) THEN
              WRITE(LINE,'(A,I6,A)')' ERR: number of atom types >'
     *        ,MAXETYP,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXETYP in "lib_com.fh"')
              IERR = 1
              RETURN
            ENDIF
            LEA_NATOM            = LEA_NATOM + 1
            LEA_ANAME(LEA_NATOM) = CHEM
            LEA_TYPE (LEA_NATOM) = 'Y'
            LEA_IATOM            = LEA_NATOM
          ELSE
            LEA_IATOM = 0
          ENDIF
          RETURN
        ELSE
          IF(LEA_NATOM.GT.MAXETYP) THEN
            WRITE(LINE,'(A,I6,A)')' ERR: number of atom types >'
     *      ,MAXETYP,' /lib. limit/'
            CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXMLIST in "lib_com.fh"')
            IERR = 1
            RETURN
          ENDIF
          LEA_NATOM            = LEA_NATOM + 1
          LEA_ANAME(LEA_NATOM) = CHEM
          LEA_TYPE (LEA_NATOM) = 'Y'
          LEA_IATOM            = LEA_NATOM
          LEA_WEIGHT(LEA_IATOM)  = 0.0
          LEA_RADIUS(LEA_IATOM)  = 0.0
          LEA_HRADIUS(LEA_IATOM) = 0.0
          LEA_IRADIUS(LEA_IATOM) = 0.0
          LEA_POLAR(LEA_IATOM)   = 0.0
          LEA_HPOLAR(LEA_IATOM)  = 0.0
          LEA_VALENCY(LEA_IATOM) = 0
          LEA_SP(LEA_IATOM)      = 0
          RETURN        
        ENDIF
      ENDIF
C COMLETENESS ????
      IF(LEA_IATOM.GT.0.AND.I.GT.1) THEN
        IF(ITEM(11:17).EQ.'hb_type') THEN
          LEA_HTYPE(LEA_IATOM) = DATA(1:1)
        ELSE IF(ITEM(11:16).EQ.'weight') THEN
          LEA_WEIGHT(LEA_IATOM) = FDATA
        ELSE IF(ITEM(11:20).EQ.'vdw_radius') THEN
          LEA_RADIUS(LEA_IATOM) = FDATA
        ELSE IF(ITEM(11:15).EQ.'polar') THEN
          LEA_POLAR(LEA_IATOM) = FDATA
        ELSE IF(ITEM(11:16).EQ.'hpolar') THEN
          LEA_HPOLAR(LEA_IATOM) = FDATA
        ELSE IF(ITEM(11:21).EQ.'vdwh_radius') THEN
          LEA_HRADIUS(LEA_IATOM) = FDATA
        ELSE IF(ITEM(11:20).EQ.'ion_radius') THEN
          LEA_IRADIUS(LEA_IATOM) = FDATA
        ELSE IF(ITEM(11:17).EQ.'element') THEN
          LEA_ENAME(LEA_IATOM) = DATA
        ELSE IF(ITEM(11:17).EQ.'valency') THEN
          LEA_VALENCY(LEA_IATOM) = IDATA
        ELSE IF(ITEM(11:12).EQ.'sp') THEN
          LEA_SP(LEA_IATOM) = IDATA
        ENDIF
      ENDIF
      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_EBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_EBOND - reads enegy library information about bonds.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,CHEM*4
C -----------------------------------
      IERR=0
      IF(ITEM(11:21).EQ.'atom_type_1' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_bond.atom_type_1 :'
     *    ,DATA(1:4),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LEB_IBOND = 0           
          IERR      = 1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEB_IBOND = 0           
          IERR      = 1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEB_NBOND=LEB_NBOND+1
            IF(LEB_NBOND.GT.MAXBTYP) THEN
              WRITE(LINE,'(A,I6,A)')' ERR: read number of bonds  >'
     *        ,MAXBTYP,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXBTYP in "lib_com.fh"')
              LEB_IBOND = 0           
              IERR=1
              RETURN
            ENDIF
            LEB_IBOND              = LEB_NBOND           
            LEB_1ATM   (LEB_NBOND) = DATA(1:4)
            LEB_2ATM   (LEB_NBOND) = '.'
            LEB_TYPE   (LEB_NBOND) = '.'
            LEB_I1ATM  (LEB_NBOND) = 0
            LEB_I2ATM  (LEB_NBOND) = 0
            LEB_CONST  (LEB_NBOND) = 0.0
            LEB_LENGTH (LEB_NBOND) = 0.0
            RETURN
          ENDIF
        ENDDO
        LEB_IBOND = 0           
        RETURN
      ENDIF

      IF(LEB_IBOND.NE.0.AND.ITEM(11:21).EQ.'atom_type_2') THEN 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_bond_atom_type_2 :'
     *    ,DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LEB_IBOND = 0           
          LEB_NBOND = LEB_NBOND -1          
          IERR      = 1
          RETURN
        ENDIF
        CHEM = DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEB_IBOND = 0           
          IERR      = 1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEB_2ATM   (LEB_NBOND) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LEB_IBOND = 0           
        LEB_NBOND = LEB_NBOND - 1
        RETURN
      ENDIF

C COMLETENESS ????

      IF(LEB_IBOND.GT.0.AND.I.GT.2) THEN
        IF(ITEM(11:14).EQ.'type') THEN
          LEB_TYPE (LEB_NBOND) = DATA(1:8)
        ELSE IF(ITEM(11:15).EQ.'const') THEN
          LEB_CONST  (LEB_NBOND) = FDATA
        ELSE IF(ITEM(11:16).EQ.'length') THEN
          LEB_LENGTH (LEB_NBOND) = FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_EANGL(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_EANGL - reads enegy library information about angles.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,CHEM*4
C -----------------------------------
      IERR=0
      IF(ITEM(12:22).EQ.'atom_type_1' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_angle.atom_type_1 :'
     *    ,DATA(1:4),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LEG_IANGL = 0           
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEG_IANGL = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEG_NANGL=LEG_NANGL+1
            IF(LEG_NANGL.GT.MAXATYP) THEN
              WRITE(LINE,'(A,I6,A)')' ERR: read number of angles  >'
     *        ,MAXATYP,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXATYP in "lib_com.fh"')
              LEG_IANGL = 0           
              IERR=1
              RETURN
            ENDIF
            LEG_IANGL = LEG_NANGL           
            LEG_1ATM   (LEG_NANGL) = DATA(1:4)
            LEG_2ATM   (LEG_NANGL) = '.'
            LEG_3ATM   (LEG_NANGL) = '.'
            LEG_I1ATM  (LEG_NANGL) = 0
            LEG_I2ATM  (LEG_NANGL) = 0
            LEG_I3ATM  (LEG_NANGL) = 0
            LEG_CONST  (LEG_NANGL) = 0.0
            LEG_ANGLE  (LEG_NANGL) = 0.0
            RETURN
          ENDIF
        ENDDO
        LEG_IANGL = 0           
        RETURN
      ENDIF

      IF(LEG_IANGL.NE.0.AND.ITEM(12:22).EQ.'atom_type_2') THEN 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_angle_atom_type_2 :'
     *    ,DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LEG_IANGL = 0           
          LEG_NANGL = LEG_NANGL -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEG_IANGL = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEG_2ATM   (LEG_NANGL) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LEG_IANGL = 0           
        LEG_NANGL = LEG_NANGL - 1
        RETURN
      ENDIF

      IF(LEG_IANGL.NE.0.AND.ITEM(12:22).EQ.'atom_type_3') THEN 
        IF(I.NE.3) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_angle_atom_type_3 :'
     *    ,DATA(1:4),' must be third in the string'
          CALL MSGERR(MDOC,LINE)
          LEG_IANGL = 0           
          LEG_NANGL = LEG_NANGL -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEG_IANGL = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEG_3ATM   (LEG_NANGL) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LEG_IANGL = 0           
        LEG_NANGL = LEG_NANGL - 1
        RETURN
      ENDIF

C COMLETENESS ????

      IF(LEG_IANGL.GT.0.AND.I.GT.3) THEN
        IF(ITEM(12:16).EQ.'const') THEN
          LEG_CONST (LEG_NANGL)=FDATA
        ELSE IF(ITEM(12:16).EQ.'value') THEN
          LEG_ANGLE (LEG_NANGL)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_ETORS(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_ETORS - reads enegy library information about torsion angles.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,CHEM*4
C -----------------------------------
      IERR=0
      IF(ITEM(11:21).EQ.'atom_type_1' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_tor.atom_type_1 :'
     *    ,DATA(1:4),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LET_ITORS = 0           
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LET_ITORS = 0           
          IERR=1
          RETURN
        ENDIF
        IF(CHEM(1:1).EQ.'.') GO TO 100
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            GO TO 100
          ENDIF
        ENDDO
        LET_ITORS = 0           
        RETURN

  100   CONTINUE
        IF(LET_NTORS.GT.MAXTTYP) THEN
          WRITE(LINE,'(A,I6,A)')' ERR: read number of torsions >'
     *    ,MAXTTYP,' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXTTYP in "lib_com.fh"')
          LET_ITORS = 0           
          IERR=1
          RETURN
        ENDIF
        LET_NTORS=LET_NTORS+1
        LET_ITORS = LET_NTORS           
        LET_1ATM   (LET_NTORS) = DATA(1:4)
        LET_2ATM   (LET_NTORS) = '.'
        LET_3ATM   (LET_NTORS) = '.'
        LET_4ATM   (LET_NTORS) = '.'
        LET_CONST  (LET_NTORS) = 0.0
        LET_ANGLE  (LET_NTORS) = 0.0
        LET_PRD    (LET_NTORS) =  0
        LET_LABEL  (LET_NTORS) = '.'
        RETURN
      ENDIF

      IF(LET_ITORS.NE.0.AND.ITEM(11:21).EQ.'atom_type_2') THEN 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_tor.atom_type_2 :'
     *    ,DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LET_ITORS = 0           
          LET_NTORS = LET_NTORS -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LET_ITORS = 0           
          LET_NTORS = LET_NTORS -1          
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LET_2ATM   (LET_NTORS) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LET_ITORS = 0           
        LET_NTORS = LET_NTORS - 1
        RETURN
      ENDIF

      IF(LET_ITORS.NE.0.AND.ITEM(11:21).EQ.'atom_type_3') THEN 
        IF(I.NE.3) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_tor_atom_type_3 :'
     *    ,DATA(1:4),' must be third in the string'
          CALL MSGERR(MDOC,LINE)
          LET_ITORS = 0           
          LET_NTORS = LET_NTORS -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LET_ITORS = 0           
          LET_NTORS = LET_NTORS - 1
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LET_3ATM   (LET_NTORS) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LET_ITORS = 0           
        LET_NTORS = LET_NTORS - 1
        RETURN
      ENDIF

      IF(LET_ITORS.NE.0.AND.ITEM(11:21).EQ.'atom_type_4') THEN 
        IF(I.NE.4) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_tor.atom_type_4 :'
     *    ,DATA(1:4),' must be fourth in the string'
          CALL MSGERR(MDOC,LINE)
          LET_ITORS = 0           
          LET_NTORS = LET_NTORS -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(CHEM(1:1).EQ.'.') THEN
          LET_4ATM   (LET_NTORS) = DATA(1:4)
          RETURN
        ENDIF
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LET_ITORS = 0           
          LET_NTORS = LET_NTORS - 1
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LET_4ATM   (LET_NTORS) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LET_ITORS = 0           
        LET_NTORS = LET_NTORS - 1
        RETURN
      ENDIF


C COMLETENESS ????

      IF(LET_ITORS.GT.0.AND.I.GT.4) THEN
        IF(ITEM(11:15).EQ.'const') THEN
          LET_CONST (LET_NTORS)=FDATA
        ELSE IF(ITEM(11:15).EQ.'angle') THEN
          LET_ANGLE (LET_NTORS)=FDATA
        ELSE IF(ITEM(11:16).EQ.'period') THEN
          LET_PRD (LET_NTORS)=IDATA
        ELSE IF(ITEM(11:15).EQ.'label') THEN
          LET_LABEL (LET_NTORS)=DATA(1:8)
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_EVDW(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_EVDW - reads enegy library information about VDW - contacts.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,CHEM*4
C -----------------------------------
      IERR=0
      IF(ITEM(10:20).EQ.'atom_type_1' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_vdw.atom_type_1 :'
     *    ,DATA(1:4),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LEW_ICONT = 0           
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEW_ICONT = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEW_NCONT=LEW_NCONT+1
            IF(LEW_NCONT.GT.MAXWTYP) THEN
              WRITE(LINE,'(A,I6,A)')
     *   ' ERR: read number of vdw contacts  >',MAXWTYP,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXWTYP in "lib_com.fh"')
              LEW_ICONT = 0           
              IERR=1
              RETURN
            ENDIF
            LEW_ICONT = LEW_NCONT           
            LEW_1ATM   (LEW_NCONT) = DATA(1:4)
            LEW_2ATM   (LEW_NCONT) = '.'
            LEW_HFLAG  (LEW_NCONT) = '.'
            LEW_EMIN   (LEW_NCONT) = 0.0
            LEW_RMIN   (LEW_NCONT) = 0.0
            RETURN
          ENDIF
        ENDDO
        LEW_ICONT = 0           
        RETURN
      ENDIF

      IF(LEW_ICONT.NE.0.AND.ITEM(10:20).EQ.'atom_type_2') THEN 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_vdw.atom_type_2 :'
     *    ,DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LEW_ICONT = 0           
          LEW_NCONT = LEW_NCONT -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEW_ICONT = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEW_2ATM   (LEW_NCONT) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LEW_ICONT = 0           
        LEW_NCONT = LEW_NCONT - 1
        RETURN
      ENDIF

C COMLETENESS ????

      IF(LEW_ICONT.GT.0.AND.I.GT.2) THEN
        IF(ITEM(10:15).EQ.'H_flag') THEN
          LEW_HFLAG (LEW_NCONT)=DATA(1:1)
        ELSE IF(ITEM(10:15).EQ.'energy') THEN
          LEW_EMIN  (LEW_NCONT)=FDATA
        ELSE IF(ITEM(10:15).EQ.'radius') THEN
          LEW_RMIN  (LEW_NCONT)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE PT_EHBOND(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_EHBOND - reads enegy library information about H - bonds.
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256,CHEM*4
C -----------------------------------
      IERR=0
      IF(ITEM(12:22).EQ.'atom_type_1' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_hbond.atom_type_1 :'
     *    ,DATA(1:4),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LEH_IHBOND = 0           
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEH_IHBOND = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEH_NHBOND=LEH_NHBOND+1
            IF(LEH_NHBOND.GT.MAXHTYP) THEN
              WRITE(LINE,'(A,I6,A)')' ERR: read number of H bonds  >'
     *        ,MAXHTYP,' /lib. limit/'
              CALL MSGERR(MDOC,LINE)
            CALL MSGERR(MDOC,
     *  ' Change parameter MAXHTYP in "lib_com.fh"')
              LEH_IHBOND = 0           
              IERR=1
              RETURN
            ENDIF
            LEH_IHBOND = LEH_NHBOND           
            LEH_1ATM   (LEH_NHBOND) = DATA(1:4)
            LEH_2ATM   (LEH_NHBOND) = '.'
            LEH_EMIN   (LEH_NHBOND) = 0.0
            LEH_DIST   (LEH_NHBOND) = 0.0
            RETURN
          ENDIF
        ENDDO
        LEH_IHBOND = 0           
        RETURN
      ENDIF

      IF(LEH_IHBOND.NE.0.AND.ITEM(12:22).EQ.'atom_type_2') THEN 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_hbond.atom_type_2 :'
     *    ,DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LEH_IHBOND = 0           
          LEH_NHBOND = LEH_NHBOND -1          
          IERR=1
          RETURN
        ENDIF
        CHEM=DATA(1:4)
        IF(LEA_NATOM.LE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERR: number of atom types in the list= 0')
          LEH_IHBOND = 0           
          IERR=1
          RETURN
        ENDIF
        DO L=1,LEA_NATOM
          IF(CHEM.EQ.LEA_ANAME(L).AND.LEA_TYPE(L).EQ.'Y') THEN
            LEH_2ATM   (LEH_NHBOND) = DATA(1:4)
            RETURN
          ENDIF
        ENDDO
        LEH_IHBOND = 0           
        LEH_NHBOND = LEH_NHBOND - 1
        RETURN
      ENDIF

C COMLETENESS ????

      IF(LEH_IHBOND.GT.0.AND.I.GT.2) THEN
        IF(ITEM(12:14).EQ.'min') THEN
          LEH_EMIN  (LEH_NHBOND)=FDATA
        ELSE IF(ITEM(12:15).EQ.'dist') THEN
          LEH_DIST  (LEH_NHBOND)=FDATA
        ENDIF
      ENDIF

      RETURN
C -----------------------------------
      END     
C ******
      SUBROUTINE PT_ESYNONYM(MDOC,I,BLOCK,LENB,ITEM,LENI
     *  ,DATA,IDATA,FDATA,LEND,IERR)
C -------------------------------------------------------
C -P- PT_ESYNONYM
C -S-
C -------------------------------------------------------
C ----
      REAL      FDATA
      INTEGER*4 IDATA,MDOC,I,IERR
      INTEGER*4 LENB,LENI,LEND
      CHARACTER BLOCK*(*),DATA*(*),ITEM*(*)
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256
C -----------------------------------
      IERR = 0
      IF(ITEM(14:22).EQ.'atom_type' ) THEN 
        IF(I.NE.1) THEN
          WRITE(LINE,'(A,A4,A)')' ERR: item _lib_synonym.atom_type :'
     *    ,DATA(1:4),' must be first in the string'
          CALL MSGERR(MDOC,LINE)
          LES_ISYN = 0           
          IERR     = 1
          RETURN
        ENDIF
        IF(LES_NSYN.GT.MAXSTYP) THEN
          WRITE(LINE,'(A,I6,A)')' ERR: read number of synonym. types  >'
     *    ,MAXSTYP,' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *  ' Change parameter MAXSTYP in "lib_com.fh"')
          LES_ISYN = 0           
          IERR = 1
          RETURN
        ENDIF
        LES_NSYN           = LES_NSYN + 1
        LES_ISYN           = LES_NSYN           
        LES_ATYP(LES_NSYN) = DATA(1:4)
        LES_STYP(LES_NSYN) = '.'
        RETURN
      ENDIF

      IF(LES_ISYN.NE.0.AND.ITEM(14:34).EQ.'atom_alternative_type') THEN 
 
        IF(I.NE.2) THEN
          WRITE(LINE,'(A,A4,A)')
     *    ' ERR: item _lib_synonym.atom_alternative_type :'
     *    ,DATA(1:4),' must be second in the string'
          CALL MSGERR(MDOC,LINE)
          LES_ISYN = 0           
          LES_NSYN = LES_NSYN -1          
          IERR=1
          RETURN
        ENDIF

        LES_STYP(LES_NSYN) = DATA(1:4)

      ENDIF

      RETURN
C -----------------------------------
      END     

C ******
      SUBROUTINE GET_CLIST(MDOC,IERR)
C -----------------------------------------------
C -P- GET_CLIST - creat list of chemical type of atoms
C -P-             from mon_library.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C      CHARACTER MODE*4
C ---
      INCLUDE 'lib_com.fh'
C ******
C ---
      CHARACTER LINE*256
C --------------------------------
      IERR=0
      LEA_NATOM = 0
      IF(LMA_NATOM.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR: number of atoms in library = 0')
        IERR=2
        RETURN
      ENDIF

      DO L=1,LMA_NATOM
        IF(LEA_NATOM.GT.0) THEN
          DO I=1,LEA_NATOM
            IF(LMA_CHEM(L).EQ.LEA_ANAME(I)) GO TO 100
          ENDDO
        ENDIF
        IF(LEA_NATOM.GT.MAXETYP) THEN
          WRITE(LINE,'(A,I6,A)')' ERROR: number of atom types >'
     *    ,MAXETYP,' /lib. limit/'
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF
        LEA_NATOM = LEA_NATOM + 1
        LEA_ANAME(LEA_NATOM) = LMA_CHEM(L)
        LEA_TYPE (LEA_NATOM) = 'N'
  100   CONTINUE
      ENDDO

c     LEA_NATOM = 0
      WRITE(LINE,'(A,I6)')
     *' NUMBER OF ATOM TYPES IN THE STRUCTURE    :', LEA_NATOM
      CALL MSGDOC(MDOC,LINE)

      RETURN
      END     

C ******
      SUBROUTINE WRT_ELIB(MODE,MDOC,IERR)
C -------------------------------------------------------
C -P- WRT_ELIB - writes energy library to the file.
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4
C ******
      CHARACTER LINE*256
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
      INCLUDE 'crd_com.fh'
C ----------------------------------
C -----------------------------------
      IF(LEO_FILE.EQ.' ') RETURN
      IERR=0
      IF(MODE.EQ.'TITL') THEN
C     open file 
        IF(LEO_IUN.NE.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERROR: output_ener_lib_file was open before')
          IERR=1
          RETURN
        ENDIF
        M=99
C       IUN=12
        IUN=CRO_IUN
        CALL OPENFW(IUN,M,LEO_PATH,LEO_FILE,LEO_EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERR: can''t open output ener_lib file')
          RETURN
        ENDIF
        LEO_IUN=IUN

        WRITE(LINE,'(''#'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''data_ener_lib'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        WRITE(LINE,'(''#'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''# --- ATOM ---'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''#'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        IF(LEA_NATOM.GT.0) THEN

          WRITE(LINE,'(''loop_'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)


          WRITE(LINE,'(''_lib_atom.type'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.weight'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.hb_type'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.vdw_radius'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''_lib_atom.polar'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.vdwh_radius'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
C          WRITE(LINE,'(''_lib_atom.hpolar'')')
C          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.ion_radius'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.element'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.valency'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_atom.sp'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          DO L=1,LEA_NATOM
c            WRITE(LINE,100) 
c     *      LEA_ANAME(L)
c     *      ,LEA_WEIGHT(L),LEA_HTYPE(L),LEA_RADIUS(L),LEA_POLAR(L)
c     *      ,LEA_HRADIUS(L),LEA_HPOLAR(L)
c  100       FORMAT(1X,A4,1X,F10.5,1X,A1,1X,F8.3,1X,F8.3,1X
c     *            ,F8.3,1X,F8.3)
            WRITE(LINE,100) 
     *      LEA_ANAME(L)
     *      ,LEA_WEIGHT(L),LEA_HTYPE(L),LEA_RADIUS(L)
     *      ,LEA_HRADIUS(L),LEA_IRADIUS(L),LEA_ENAME(L),LEA_VALENCY(L)
     *      ,LEA_SP(L)
  100       FORMAT(1X,A4,2X,F10.5,2X,A1,2X,F8.3,2X,F8.3,2X,A4
     *            ,F8.3,I5,1X,I3)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
          ENDDO
        ELSE
          WRITE(LINE,'(''#  Number of atoms = 0'')')
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF
      ELSE IF(MODE.EQ.'WRIT') THEN
        IF(LEO_IUN.EQ.0) THEN
          CALL MSGERR(MDOC,' ERR: output_ener_lib_file isn''t open')
          IERR=1
          RETURN
        ENDIF
        IUN=LEO_IUN 
        IF(LEB_NBOND.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# ---  BONDS ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''loop_'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          WRITE(LINE,'(''_lib_bond.atom_type_1'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_bond.atom_type_2'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_bond.type'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_bond.const'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_bond.length'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          DO I1=1,LEA_NATOM
          DO I2=1,I1

          DO L=1,LEB_NBOND
            IF(LEA_ANAME(I1).EQ.LEB_1ATM(L).AND.
     *          LEA_ANAME(I2).EQ.LEB_2ATM(L)) THEN
            WRITE(LINE,200) 
     *      LEB_1ATM(L),LEB_2ATM(L),LEB_TYPE(L),LEB_CONST(L)
     *      ,LEB_LENGTH(L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ELSE IF(LEA_ANAME(I1).EQ.LEB_2ATM(L).AND.
     *         LEA_ANAME(I2).EQ.LEB_1ATM(L)) THEN
            WRITE(LINE,200) 
     *      LEB_2ATM(L),LEB_1ATM(L),LEB_TYPE(L),LEB_CONST(L)
     *      ,LEB_LENGTH(L)
  200       FORMAT(1X,A4,1X,A4,1X,A8,1X,F8.3,1X,F8.3)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF
          ENDDO

        ENDDO
        ENDDO

        ELSE
          WRITE(LINE,'(''#   Number of bonds = 0'')')
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF
        IF(LEG_NANGL.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# ---  ANGLES ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''loop_'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          WRITE(LINE,'(''_lib_angle.atom_type_1'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_angle.atom_type_2'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_angle.atom_type_3'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_angle.const'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_angle.value'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          DO I2=1,LEA_NATOM
          DO I1=1,LEA_NATOM
          DO I3=1,I1

          DO L=1,LEG_NANGL
             
            IF(LEA_ANAME(I1).EQ.LEG_1ATM(L).AND.
     *         LEA_ANAME(I2).EQ.LEG_2ATM(L).AND.
     *         LEA_ANAME(I3).EQ.LEG_3ATM(L)) THEN

            WRITE(LINE,300) 
     *      LEG_1ATM(L),LEG_2ATM(L),LEG_3ATM(L),LEG_CONST(L)
     *      ,LEG_ANGLE(L)
  300       FORMAT(1X,A4,1X,A4,1X,A4,1X,F8.3,1X,F8.3)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ELSE IF(LEA_ANAME(I1).EQ.LEG_3ATM(L).AND.
     *         LEA_ANAME(I2).EQ.LEG_2ATM(L).AND.
     *         LEA_ANAME(I3).EQ.LEG_1ATM(L)) THEN
            WRITE(LINE,300) 
     *      LEG_3ATM(L),LEG_2ATM(L),LEG_1ATM(L),LEG_CONST(L)
     *      ,LEG_ANGLE(L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF

          ENDDO

          ENDDO
          ENDDO
          ENDDO
        ELSE
          WRITE(LINE,'(''#  Number of angles = 0'')')
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF
        IF(LET_NTORS.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# ---  TORSIONS ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''loop_'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          WRITE(LINE,'(''_lib_tor.atom_type_1'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.atom_type_2'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.atom_type_3'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.atom_type_4'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.label'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.const'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.angle'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_tor.period'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          DO L=1,LET_NTORS
            WRITE(LINE,400) 
     *       LET_1ATM(L),LET_2ATM(L),LET_3ATM(L),LET_4ATM(L)
     *      ,LET_LABEL(L),LET_CONST(L),LET_ANGLE(L),LET_PRD(L)
  400       FORMAT(1X,A4,1X,A4,1X,A4,1X,A4,1X,A8,1X
     *             ,F8.3,1X,F8.3,1X,I5)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
          ENDDO
        ELSE
          WRITE(LINE,'(''# Number of tortions = 0'')')
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF
        IF(LEW_NCONT.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# ---  VDW contacts ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''loop_'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          WRITE(LINE,'(''_lib_vdw.atom_type_1'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_vdw.atom_type_2'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_vdw.energy_min'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_vdw.radius_min'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_vdw.H_flag'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          DO I1=1,LEA_NATOM
          DO I2=1,I1

          DO L=1,LEW_NCONT

            IF(LEA_ANAME(I1).EQ.LEW_1ATM(L).AND.
     *          LEA_ANAME(I2).EQ.LEW_2ATM(L)) THEN

            WRITE(LINE,500) 
     *      LEW_1ATM(L),LEW_2ATM(L),LEW_EMIN(L),LEW_RMIN(L)
     *      ,LEW_HFLAG(L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ELSE IF(LEA_ANAME(I1).EQ.LEW_2ATM(L).AND.
     *          LEA_ANAME(I2).EQ.LEW_1ATM(L)) THEN

            WRITE(LINE,500) 
     *      LEW_2ATM(L),LEW_1ATM(L),LEW_EMIN(L),LEW_RMIN(L)
     *      ,LEW_HFLAG(L)
  500       FORMAT(1X,A4,1X,A4,2X,F10.5,2X,F8.3,3X,A1)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)

            ENDIF

          ENDDO

          ENDDO     
          ENDDO     

        ELSE
          WRITE(LINE,'(''#   Number of VDW contacts = 0'')')
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF
        IF(LEH_NHBOND.GT.0) THEN
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''# ---  H-BONDS ---'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''#'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''loop_'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          WRITE(LINE,'(''_lib_hbond.atom_type_1'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_hbond.atom_type_2'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_hbond.min'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)
          WRITE(LINE,'(''_lib_hbond.dist'')')
          CALL WRTSTR(IUN,MDOC,LINE,IERR)

          DO I1=1,LEA_NATOM
          DO I2=1,I1

          DO L=1,LEH_NHBOND

            IF(LEA_ANAME(I1).EQ.LEH_1ATM(L).AND.
     *         LEA_ANAME(I2).EQ.LEH_2ATM(L)) THEN

            WRITE(LINE,600) 
     *      LEH_1ATM(L),LEH_2ATM(L),LEH_EMIN(L)
     *      ,LEH_DIST(L)
  600       FORMAT(1X,A4,1X,A4,1X,F8.3,1X,F8.3)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ELSE IF(LEA_ANAME(I1).EQ.LEH_2ATM(L).AND.
     *         LEA_ANAME(I2).EQ.LEH_1ATM(L)) THEN

            WRITE(LINE,600) 
     *      LEH_2ATM(L),LEH_1ATM(L),LEH_EMIN(L)
     *      ,LEH_DIST(L)
            CALL WRTSTR(IUN,MDOC,LINE,IERR)
            ENDIF

          ENDDO

          ENDDO
          ENDDO

        ELSE
          WRITE(LINE,'(''#   Number of H - bonds = 0'')')
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF

        WRITE(LINE,'(''# ----------------------'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
      ELSE IF(MODE.EQ.'STOP') THEN
        IF(LEO_IUN.EQ.0) THEN
          CALL MSGERR(MDOC
     *    ,' ERROR: output "ener_lib.cif": can''t be closed')
          IERR=1
          RETURN
        ENDIF
        END FILE LEO_IUN
        LEO_IUN = 0
      ENDIF
C -----------------------------------
      RETURN
      END     
