C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C -----------------------------------------------
C 
C use before: subr. "lput_new" to put info into L1L_, L1A_
C
C use after : subr."cpl_mlib" to copy descr. of new mon. to library.
C
C ierr  2 - list of bonds is not correct (L1A_PSNT = 'M')
C      10 - not completely connected
C
      SUBROUTINE CREAT_NEW(MMDOC,LIST,MODE_I,PNUM,NAME,VANGLE,IERR)
C --------------------------------------------------------
C -P- CREAT_NEW -
C         -- MODE: 'COOR'/'TEST' --
C           'TEST' as COOR but Vobs --> Vidl
C
C       L1L_PRSNT = 'N'
C     input:
C        L1L_MNAME
C        L1L_CODE
C        L1L_TYPE
C        L1L_NAME
C        L1A_NATOM 
C        L1A_COOR_FLAG()  = 'Y' 
C        L1A_X        () 
C        L1A_Y        () 
C        L1A_Z        ()
C        L1A_ANAME    ()  - atom's name 
C        L1A_SYMB     ()  - atom's symbol - 'C   ','N   ','O   ','H   ',
C                                           'FE  ','P   ','S   ','CL  ',...
C
C       L1L_PRSNT = 'N'
C     input:
C        L1L_MNAME
C        L1L_CODE
C        L1L_TYPE
C        L1L_NAME
C        L1A_NATOM 
C        L1A_COOR_FLAG()  = 'N' (or 'Y')
C              L1A_X        () 
C              L1A_Y        () 
C              L1A_Z        ()
C        L1A_CHEM     ()
C        L1A_ANAME    ()  - atom's name 
C        L1A_SYMB     ()  - atom's symbol - 'C   ','N   ','O   ','H   ',
C                                           'FE  ','P   ','S   ','CL  ',...
C        L1B_NBOND
C        L1B_1ATM     ()
C        L1B_2ATM     ()
C        L1B_TYPE     () ? or L1A_CHEM or full(with H) list of atoms 
C
C        L1C_NCHIR
C ---
C -S-
C --------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE_I*4,NAME*(*),LIST*1,PNUM*12
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ---
      CHARACTER LINE*256,CH4*4,MON*8,COOR*1,MODE*4,MON_INPUT*8
      CHARACTER ASYMB*4,CTYPE*4,MOD*1,MODE_M*4,CHEM_FLAG*1,TYPE*16
C ---------------------------------------------
      MDOC = MMDOC
      M  = 99
      MD =-ABS(MDOC)-1
      MT = 99
      IF(LIST.EQ.'T') MT = MDOC
      IF(LIST.EQ.'T'.OR.LIST.EQ.'L') THEN        
        MD = MDOC
      ELSE IF(LIST.EQ.'S') THEN
        MDOC = 99
        MD   = 99       
      ENDIF
      IERR = 0
C --------------------------------------------------------
      COOR = 'N'
      MODE = 'CONN'

      MON  = L1L_MNAME        

      IF(MODE_I.EQ.'TEST') THEN
        COOR ='Y'
      ENDIF

      IF(L1L_PRSNT.NE.'N'.AND.L1L_PRSNT.NE.'M') THEN
        LINE = ' ERROR in MAKE_NEW: '//MON//
     *         ' : L1L_PRSNT must be N or M'
        CALL MSGDOC(MD,LINE)
        IERR = 1
        RETURN
      ENDIF           

      IF(LIST.EQ.'T') THEN
        write(LINE,*) '---make_new :prsnt,coor:',L1L_PRSNT,COOR
        CALL MSGERR(MDOC,LINE)
      ENDIF

      IF(L1A_NATOM.LE.0) THEN
        WRITE(LINE,'(3A,I4)')
     *' ERROR: number of atoms in new monomer ',L1L_MNAME,' = ',
     * L1A_NATOM
        CALL MSGERR(MDOC,LINE)
        IERR=1
        RETURN
      ENDIF

      NA     = L1A_NATOM
      MON    = L1L_MNAME        

C     check unique atom names

      IF(NA.GT.1) THEN
        DO I=1,NA-1
          DO J=I+1,NA
            IF(L1A_ANAME(I).EQ.L1A_ANAME(J)) THEN
              LINE = ' ERROR : '//MON//
     *               ' : duplicated atom_name : "'//L1A_ANAME(I)//'".'
              CALL MSGERR(MDOC,LINE)
              IERR = 1
            ENDIF           
          ENDDO
        ENDDO
        IF(IERR.NE.0) RETURN
      ENDIF

C     set atom types to L1A_ATYPE() using L1A_SYMB

      DO I=1,NA
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *     ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *     ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
          CTYPE='C   '
        ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
          CTYPE='H   '
          L1A_NHATOM   = L1A_NHATOM + 1
        ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
          CTYPE='P   '
        ELSE
          CTYPE='$   '
        ENDIF
        L1A_ATYPE(I)=CTYPE(1:1)
      ENDDO

C --------------------------------------------------------

      IF(L1L_PRSNT.EQ.'N') THEN
        CHEM_FLAG  = 'N'
        MODE = 'COOR'

C       remove Hatoms with occ = 0
C       check occ.

        CALL CHECK_LIST_ATOM(MDOC,IERR)
        IF(IERR.NE.0) RETURN
        NA = L1A_NATOM
        
      ELSE IF(L1L_PRSNT.EQ.'M') THEN
        MODE       = 'CONN'
        CHEM_FLAG  = 'Y'

c       check list of bonds

        CALL CHECK_LIST_BOND(MDOC,CHEM_FLAG,IERR)
        IF(IERR.NE.0) RETURN

      ENDIF

C     clean some arrays

      IF(LIST.EQ.'T') THEN
        write(LINE,*) '---chir before:',L1C_NCHIR,L1L_PRSNT
        CALL MSGERR(MDOC,LINE)
      ENDIF

      L1A_NHATOM = 0
      IF(L1L_PRSNT.NE.'M') THEN
        L1C_NCHIR  = 0
      ELSE
C       check atoms of chiralities

        CALL CHECK_CHIR_ATOM(MDOC,IERR)
        IF(IERR.NE.0) RETURN

      ENDIF

      IF(LIST.EQ.'T') THEN
        write(LINE,*) '---chir after:',L1C_NCHIR,L1L_PRSNT
        CALL MSGERR(MDOC,LINE)
      ENDIF


      L1N_NCONN  = 0
      L1P_NPLAN  = 0 
      L1T_NTORS  = 0
      L1G_NANGL  = 0
      DO I=1,NA
        L1A_INEW (I) = I 
        L1A_IOLD (I) = I
        L1A_ICHEM(I) = 0              
        L1A_ICR  (I) = 0
        L1A_ICHIR(I) = 0
        L1A_NDIST(I) = 0
        L1A_IBACK(I) = 0
        L1A_IFORW(I) = 0
        L1A_BACK (I) = '.'
        L1A_TYPE (I) = '.' 
        L1A_FORW (I) = '.'
        L1A_NRING(I) = 0

        IF(CHEM_FLAG.NE.'Y') L1A_CHEM(I) = '.' 

        DO  J=1,MAX1BRN 
          L1A_CONN     (J,I) = 0
          L1A_LENCON   (J,I) = 0
          L1A_RING_ID  (J,I) = 0
          L1A_RING_ORD (J,I) = 0
          L1A_RING_FLAT(J,I) = 0
        ENDDO
        DO  J=1,MAX1EXT 
          L1A_TEXTR (J,I) = 0
          L1A_IEXTR (J,I) = 0
        ENDDO
      ENDDO
C ---
      IF(NA.LE.1) THEN
        L1A_ISTART  = 1
        L1A_IFINISH = 1
        L1A_BACK(1) = '.'
        L1A_FORW(1) = 'END'
        L1A_CHEM(1) = L1A_SYMB(1) 
        NRING       = 0
        L1A_NRING(1)= 0
        ITYPE_RES   = 1
        GO TO 300
      ENDIF
C --------------------------------------------------------
C ---

      i=1
      LINE = ' --- before lib_conn/coor_conn ---'
      CALL WRITE_TEST(MT,i,line)

C      create description of connectivity  

      IF(L1L_PRSNT.NE.'M') THEN
        CALL LIST_BONDS_FROM_COOR(MDOC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      i=2
      LINE = ' --- before REMOVE_TRIANGLE_H ---'
      CALL WRITE_TEST(MT,i,line)

      CALL REMOVE_TRIANGLE_H(MDOC,IERR)

      i=2
      LINE = ' --- after REMOVE_TRIANGLE_H ---'
      CALL WRITE_TEST(MT,i,line)

C     CALL REMOVE_TRIANGLE(MDOC,IERR)

      CALL LIB_CONN(MDOC,MODE,IERR)
      IF(IERR.NE.0) RETURN

      i=2
      LINE = ' --- after lib_conn/coor_conn ---'
      CALL WRITE_TEST(MT,i,line)
C --------------------------------------------------------
C

      CALL CHECK_CONNECTIVITY(MDOC,LIST,IERR)
      IF(IERR.NE.0) RETURN

      i=2
      LINE = ' --- after  CHECK_CONNECTIVITY---'
      CALL WRITE_TEST(MT,i,line)
C
C --------------------------------------------------------
C
C     define l1a_ichir     
C     L1A_ICHIR() = 1 user, 2 (n=4 or n=3( coords--> volume >  RLIMC(=0.5))

      CALL DEFINE_CHIR_FLAG(MDOC,IERR)
      IF(IERR.NE.0) RETURN
C       
C
C --------------------------------------------------------
C
C     list of rings
C --
      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        line = ' --- before ring -- chem_flag:'//CHEM_FLAG
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(*,*) 'charge:',l1a_charg(ia)
          write(line,
     * '(i2,1x,a,1x,2i4,1x,i3,1x,1x,i3,1x,'';'',6i3,'';'',6i3,A)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_ichir(Ia),L1A_ichem(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5),L1A_CHEM(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
C ---
      IPRSNT = 1
      CALL RING(MDOC,LIST,NRINGT,IPRSNT,IERR)
      IF(IERR.NE.0) RETURN

      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        line = ' --- after ring -- chem_flag:'//CHEM_FLAG
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     * '(i2,1x,a,1x,2i4,1x,i3,1x,1x,i3,1x,'';'',6i3,'';'',6i3,A)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_ichir(Ia),L1A_ichem(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5),L1A_CHEM(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF


C --------------------------------------------------------
C      coors        CHEM_FLAG  = 'N'
C      bond order   CHEM_FLAG  = 'B'
C      chem type    CHEM_FLAG  = 'Y'
C      atom list    CHEM_FLAG  = 'L'

C      IF(CHEM_FLAG.EQ.'Y') CHEM_FLAG  = 'L'

      IF(CHEM_FLAG.EQ.'N') THEN
C       bond_order from coords
        CALL ADD_TYPE_USING_COORD(MDOC,LIST,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERROR: in subroutine ADD_TYPE_USING_COORD')
          RETURN
        ENDIF
      ELSE IF(CHEM_FLAG.EQ.'Y') THEN
C       bond_order from chem types
        CALL ADD_TYPE_USING_CHEM(MDOC,LIST,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERROR: in subroutine ADD_TYPE_USING_CHEM')
          RETURN
        ENDIF
      ELSE IF(CHEM_FLAG.EQ.'L') THEN
C       bond_order from list of atoms and bonds 
        CALL ADD_TYPE_USING_LIST(MDOC,LIST,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERROR: in subroutine ADD_TYPE_USING_LIST')
          RETURN
        ENDIF
      ENDIF
cd      STOP
      CALL USE_VALENCY(MDOC,LIST,IERR)     
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: in subroutine USE_VALENCY')
        RETURN
      ENDIF

C --------------------------------------------------------
      NA  = L1A_NATOM
      NNH = L1A_NHATOM
C --------------------------------------------------------
C     define  chemical types
C
      CALL CHECK_CHEM_DD_MIN(MDOC,LIST,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: in subroutine CHECK_CHEM_DD_MIN')
        RETURN
      ENDIF

C ---

      IF(LIST.EQ.'T') THEN
        i=3
        LINE = ' --- after check_chem_dd ---'
        CALL WRITE_TEST(MT,i,line)
        call msgdoc(mdoc,' --- rings ---n,id,ord,flat')
        DO I=1,NA
          WRITE(LINE,'(I4,1X,A,1X,I4,3X,5(3I3,2X))') 
     *    I,l1a_aname(I),L1A_NRING(I)
     *    ,(L1A_RING_ID(J,I),L1A_RING_ORD(J,I),L1A_RING_FLAT(J,I),J=1,5)
          call msgdoc(mdoc,line)
        ENDDO
        call msgdoc(mdoc,' ------')
      ENDIF

C --------------------------------------------------------
C     CHECK_CHIR
C     analyze atoms conneted with othere 3 atoms  and create chir. or plan 
C     without coordinates,

      CALL LENSTR_BL(L1L_TYPE,LEN) 
      DO IT=1,N_RES_TYPE
        TYPE = RES_TYPE(IT)
        IF(L1L_TYPE(1:LEN).EQ.TYPE(1:LEN)) GO TO 801
      ENDDO
      IT = 1
 801  CONTINUE
      ITYPE_RES = IT
 
      CALL CHECK_CHIR(MDOC,LIST,ITYPE_RES,IERR)
      IF(IERR.NE.0) RETURN

C       calc number of noH-atoms

      NH = 0
      DO I=1,L1A_NATOM
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ') THEN
          NH = NH + 1
        ENDIF
      ENDDO
      L1A_NHATOM = NH
      L1L_NATM   = L1A_NATOM
      L1L_NHATM  = L1A_NHATOM
C --------------------------------------------------------
C     CHECK_PLAN
C     check plans

      CALL CHECK_PLAN(MDOC,NRINGT,LIST,IERR)
      IF(IERR.NE.0) RETURN

C
C --------------------------------------------------------
C     create tree like structure
c
      CALL CREATE_TREE_NEW(MDOC,LIST,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERROR: in subroutine CREATE_TREE_NEW')
        RETURN
      ENDIF
C      CALL CHECK_RES_TYPE(MDOC,ITYPE_RES,IERR)
C      IF(IERR.NE.0) RETURN
c      CALL CHECK_RES_TYPE_BY_ATOM_AND_BOND
c     *                                  (MDOC,ITYPE_RES,IERR)
c       CALL GET_INI_RES_TYPE(MDOC,LINE,CH8,IT,IERR)

      CALL LENSTR_BL(L1L_TYPE,LEN) 
      DO IT=1,N_RES_TYPE
        TYPE = RES_TYPE(IT)
        IF(L1L_TYPE(1:LEN).EQ.TYPE(1:LEN)) GO TO 800
      ENDDO
      IT = 1
 800  CONTINUE
      ITYPE_RES = IT

      CALL CHECK_TREE_DIRECTION(MDOC,LIST,ITYPE_RES,IERR)
      IF(IERR.NE.0) RETURN

 300  CONTINUE
C ---
C     calc number of noH-atoms
      NH = 0
      DO I=1,L1A_NATOM
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ') THEN
          NH = NH + 1
        ENDIF
      ENDDO
      L1A_NHATOM = NH
C ---------
      IF(LIST.EQ.'T') THEN
        i=4
        WRITE(LINE,'(A,2I5)') 
     *  '-  after create_tree -',L1C_NCHIR,L1P_NPLAN
        CALL MSGDOC(MDOC,LINE)
        write(LINE,*) '==res_type',ITYPE_RES
        CALL MSGDOC(MDOC,LINE)
        CALL WRITE_TEST(MT,i,line)
      ENDIF
C -----------------------------------------------
C SET_NUM - defines atom's number for atom's name.
C           checks tree like sructure, extra_atoms
C           adds H_atoms

      CALL SET_NUM(MDOC,MON,PNUM,IERR)
      IF(IERR.NE.0) RETURN

C -----------------------------------------------
      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        write(line,*) ' after set_num'
        CALL MSGDOC(MDOC,LINE)
        write(line,*) 'first,LAST:',L1A_ISTART,L1A_IFINISH
        CALL MSGDOC(MDOC,LINE)
        LINE=
     *'aname,  back ,  forw  ,      nd,conn(1..5) ,  next,iext(1..5)'
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     *    '(i2,i3,1x,a4,1x,2i4,1x,a4,1x,1x,a4,1x,'';'',6i3,'';'',6i3)') 
     *    ia,l1a_iold(ia),l1a_aname(ia)
     *    ,L1A_Iback(Ia),L1A_IFORW(Ia),L1A_back(Ia),L1A_FORW(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
C --------------------------------------------------------
      CALL ADD_HATOM_TO_PLAN(MDOC,IERR)
      IERR = 0
C --------------------------------------------------------
C --------------------------------------------------------
C     create new descriptions (bonds,angles,tors) with values

      L1G_NANGL = 0
      L1T_NTORS = 0
      CALL CALC_VOBSN(MDOC,LIST,MON,NRINGT,IERR)
      IF(IERR.NE.0) THEN
        RETURN
      ENDIF 
      IF(COOR.EQ.'Y') THEN
        CALL SET_VOBS_TO_VIDL(MDOC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
C ----
C     rebuild coords for H-atoms if all nonH-atoms have coords.

      IT = 0
      CALL H_ATOM_COORS_REBUILD(MDOC,LIST,IT,IERR)

C --------------------------------------------------
      IF(LIST.EQ.'T') write(*,*) ' --- ps---'
C ---   Create PostScript file ---
C      IF(L1L_PRSNT.NE.'M') THEN
      IF(NAME(1:1).NE.'?') THEN
        MOD       = 'C'
        MON_INPUT = ' '
        CALL GRAPH_NEWL(MDOC,MOD,MON_INPUT,NAME,VANGLE,IERR)
        IERR = 0
      ENDIF
C --------------------------------------------------
      IF(LIST.EQ.'T') write(*,*) ' ---end  ps---'
C     calc number of noH-atoms
      NH = 0
      DO I=1,L1A_NATOM
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ') THEN
          NH = NH + 1
        ENDIF
      ENDDO
      L1A_NHATOM = NH
      L1L_NATM   = L1A_NATOM
      L1L_NHATM  = L1A_NHATOM
      L1L_FUSE   = 'C'
      L1L_PRSNT  = '.'
C --------------------------------------------------
      IF(LIST.EQ.'T') write(*,*) ' ---end  make_new---'

      RETURN
      END     
C
      SUBROUTINE  CHECK_LIST_BOND(MDOC,CHEM_FLAG,IERR)
C --------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER CHEM_FLAG*1
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM1*4,ATOM2*4,CHEM*4,MON*8
C ---------------------------------------------
C      check list of bonds
C
C      bond order ? CHEM_FLAG  = 'B'
C      chem type  ? CHEM_FLAG  = 'Y'
C      atom list  ? CHEM_FLAG  = 'L'
C ------------------------------------
      IERR = 0
      NA   = L1A_NATOM
      NB   = L1B_NBOND 
      MON  = L1L_MNAME        

      IF(NA.LE.0.OR.NB.LE.0) RETURN

C     remove duplicated bonds
      IF(NB.GT.1) THEN
        NNB = 1
        DO IB=2,NB
          ATOM1 = L1B_1ATM(IB)
          ATOM2 = L1B_2ATM(IB)
          DO JB=1,NNB
            IF((ATOM1.EQ.L1B_1ATM(JB).AND.ATOM2.EQ.L1B_2ATM(JB)).OR. 
     *         (ATOM1.EQ.L1B_2ATM(JB).AND.ATOM2.EQ.L1B_1ATM(JB))) THEN 
              GO TO 100
            ENDIF 
          ENDDO
          NNB            = NNB + 1
          L1B_1ATM (NNB) = ATOM1 
          L1B_2ATM (NNB) = ATOM2 
          L1B_TYPE (NNB) = L1B_TYPE (IB)
          L1B_I1ATM(NNB) = L1B_I1ATM(IB)
          L1B_I2ATM(NNB) = L1B_I2ATM(IB)
          L1B_VOBS (NNB) = L1B_VOBS (IB)
          L1B_VAL  (NNB) = L1B_VAL  (IB) 
          L1B_DEV  (NNB) = L1B_DEV  (IB) 


 100      CONTINUE
        ENDDO
        L1B_NBOND = NNB
        NB        = NNB 
      ENDIF

C     check all l1b_1atm,l1b_2atm in the atom list
      DO IB=1,NB
        ATOM1 = L1B_1ATM(IB)
        ATOM2 = L1B_2ATM(IB)
        DO IA=1,NA 
          IF(ATOM1.EQ.L1A_ANAME(IA)) GO TO 200         
        ENDDO
        IERR = 2
        LINE = ' ERROR: '//MON//
     *         ' : list of bonds: ATOM:'//ATOM1//' ?'
        CALL MSGDOC(MDOC,LINE)
        
 200    CONTINUE
        DO IA=1,NA 
          IF(ATOM2.EQ.L1A_ANAME(IA)) GO TO 300         
        ENDDO
        IERR = 2
        LINE = ' ERROR: '//MON//
     *         ' : list of bonds: ATOM:'//ATOM2//' ?'
        CALL MSGDOC(MDOC,LINE)

 300    CONTINUE
      ENDDO
      IF(IERR.NE.0) RETURN

C      bond order ? CHEM_FLAG  = 'B'
C      chem type  ? CHEM_FLAG  = 'Y'
C      atom list  ? CHEM_FLAG  = 'L'
      CHEM_FLAG = 'B'
      DO IB=1,NB
        IF(L1B_TYPE(IB)(1:1).EQ.'.'.OR.L1B_TYPE(IB)(1:4).EQ.'cova') THEN
          CHEM_FLAG = 'Y'
        ENDIF
      ENDDO
      IF(CHEM_FLAG.EQ.'Y') THEN
        DO IA=1,NA
          IF(L1A_CHEM(IA)(1:1).EQ.'.') CHEM_FLAG = 'L'
        ENDDO
      ENDIF

      IF(CHEM_FLAG.EQ.'Y') THEN
C       check chem types    
        DO IA=1,NA
          CHEM = L1A_CHEM(IA) 
          DO IE=1,LEA_NATOM
            IF(CHEM.EQ.LEA_ANAME (IE)) GO TO 400
          ENDDO
          CHEM_FLAG = 'L'
          LINE = ' WARNING: '//MON//
     *         ' : chemical TYPE:'//CHEM//' not found'
          CALL MSGDOC(MDOC,LINE)
 400      CONTINUE
        ENDDO
      ENDIF


      RETURN
      END

      SUBROUTINE REMOVE_TRIANGLE(MDOC,IERR)
C --------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,MON*8
C ---------------------------------------------
      IERR = 0
      MON  = L1L_MNAME        
      NB   = L1B_NBOND
      IF(NB.LE.2) RETURN
C ---
      DO I=1,NB-2
        IF(L1B_TYPE(I)(1:1).NE.'?') THEN
          DO J=I+1,NB-1
            IF(L1B_TYPE(J)(1:1).NE.'?') THEN
              IF(L1B_I1ATM(I).EQ.L1B_I1ATM(J)) THEN 
                IB1 = L1B_I2ATM(I)   
                IB2 = L1B_I2ATM(J)   
                IB3 = L1B_I1ATM(I)
              ELSE IF(L1B_I1ATM(I).EQ.L1B_I2ATM(J)) THEN 
                IB1 = L1B_I2ATM(I)   
                IB2 = L1B_I1ATM(J)   
                IB3 = L1B_I1ATM(I)
              ELSE IF(L1B_I2ATM(I).EQ.L1B_I1ATM(J)) THEN 
                IB1 = L1B_I1ATM(I)   
                IB2 = L1B_I2ATM(J)   
                IB3 = L1B_I2ATM(I)
              ELSE IF(L1B_I2ATM(I).EQ.L1B_I2ATM(J)) THEN 
                IB1 = L1B_I1ATM(I)   
                IB2 = L1B_I1ATM(J)   
                IB3 = L1B_I2ATM(I)
              ELSE
                IB1 = 0
                IB2 = 0
                IB3 = 0
              ENDIF
              IF(IB1.GT.0) THEN
                DO K=J+1,NB
                  IF(L1B_TYPE(K)(1:1).NE.'?') THEN
                  IF((L1B_I1ATM(K).EQ.IB1.AND.L1B_I2ATM(K).EQ.IB2).OR.
     *               (L1B_I1ATM(K).EQ.IB2.AND.L1B_I2ATM(K).EQ.IB1))THEN
                    L1B_TYPE(K) = '?' 

        LINE = ' WARNING: '//MON//' triangle:'//L1A_ANAME(IB1)//
     *         ' - '//L1A_ANAME(IB2)//' - '//L1A_ANAME(IB3)
        CALL MSGDOC(MDOC,LINE)
        LINE = '          bond:'//L1B_1ATM(K)//' - '//L1B_2ATM(K)//
     *         ' is removed'
        CALL MSGDOC(MDOC,LINE)
                    GO TO 200
                  ENDIF
                  ENDIF
 200              CONTINUE
                ENDDO
              ENDIF
            ENDIF
          ENDDO
        ENDIF 
      ENDDO
C -----
      NNB = 0
      DO IB=1,L1B_NBOND
        IF(L1B_TYPE(IB)(1:1).NE.'?') THEN
          NNB            = NNB + 1
          L1B_1ATM (NNB) = L1B_1ATM (IB) 
          L1B_2ATM (NNB) = L1B_2ATM (IB)
          L1B_TYPE (NNB) = L1B_TYPE (IB)
          L1B_I1ATM(NNB) = L1B_I1ATM(IB)
          L1B_I2ATM(NNB) = L1B_I2ATM(IB)
          L1B_VOBS (NNB) = L1B_VOBS (IB)
          L1B_VAL  (NNB) = L1B_VAL  (IB) 
          L1B_DEV  (NNB) = L1B_DEV  (IB) 
        ENDIF 
      ENDDO
      L1B_NBOND = NNB

      RETURN
      END

      SUBROUTINE REMOVE_TRIANGLE_H(MDOC,IERR)
C --------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,MON*8
C ---------------------------------------------
      IERR = 0
      MON  = L1L_MNAME        
      NB   = L1B_NBOND
      IF(NB.LE.2) RETURN
C ---
      DO I=1,NB-2
        IF(L1B_TYPE(I)(1:1).NE.'?') THEN
          DO J=I+1,NB-1
            IF(L1B_TYPE(J)(1:1).NE.'?') THEN
              IF(L1B_I1ATM(I).EQ.L1B_I1ATM(J)) THEN 
                IB1 = L1B_I2ATM(I)   
                IB2 = L1B_I2ATM(J)   
                IB3 = L1B_I1ATM(I)
              ELSE IF(L1B_I1ATM(I).EQ.L1B_I2ATM(J)) THEN 
                IB1 = L1B_I2ATM(I)   
                IB2 = L1B_I1ATM(J)   
                IB3 = L1B_I1ATM(I)
              ELSE IF(L1B_I2ATM(I).EQ.L1B_I1ATM(J)) THEN 
                IB1 = L1B_I1ATM(I)   
                IB2 = L1B_I2ATM(J)   
                IB3 = L1B_I2ATM(I)
              ELSE IF(L1B_I2ATM(I).EQ.L1B_I2ATM(J)) THEN 
                IB1 = L1B_I1ATM(I)   
                IB2 = L1B_I1ATM(J)   
                IB3 = L1B_I2ATM(I)
              ELSE
                IB1 = 0
                IB2 = 0
                IB3 = 0
              ENDIF
              IF(IB1.GT.0.AND.L1A_ATYPE(IB2).EQ.'H') THEN
                DO K=J+1,NB
                  IF(L1B_TYPE(K)(1:1).NE.'?') THEN
                  IF((L1B_I1ATM(K).EQ.IB1.AND.L1B_I2ATM(K).EQ.IB2).OR.
     *               (L1B_I1ATM(K).EQ.IB2.AND.L1B_I2ATM(K).EQ.IB1))THEN
        LINE = ' WARNING: '//MON//' triangle:'//L1A_ANAME(IB1)//
     *         ' - '//L1A_ANAME(IB2)//' - '//L1A_ANAME(IB3)
        CALL MSGDOC(MDOC,LINE)
                    IF(L1A_ATYPE(IB3).EQ.'H') THEN 
                      L1B_TYPE(J) = '?'
        LINE = '          bond:'//L1B_1ATM(J)//' - '//L1B_2ATM(J)//
     *         ' is removed'
        CALL MSGDOC(MDOC,LINE)
                       GO TO 100
                    ENDIF 
                    L1B_TYPE(K) = '?' 
        LINE = '          bond:'//L1B_1ATM(K)//' - '//L1B_2ATM(K)//
     *         ' is removed'
        CALL MSGDOC(MDOC,LINE)
                    GO TO 200
                  ENDIF
                  ENDIF
 200              CONTINUE
                ENDDO
              ENDIF
            ENDIF
          ENDDO
        ENDIF 
 100    CONTINUE
      ENDDO
C -----
      NNB = 0
      DO IB=1,L1B_NBOND
        IF(L1B_TYPE(IB)(1:1).NE.'?') THEN
          NNB            = NNB + 1
          L1B_1ATM (NNB) = L1B_1ATM (IB) 
          L1B_2ATM (NNB) = L1B_2ATM (IB)
          L1B_TYPE (NNB) = L1B_TYPE (IB)
          L1B_I1ATM(NNB) = L1B_I1ATM(IB)
          L1B_I2ATM(NNB) = L1B_I2ATM(IB)
          L1B_VOBS (NNB) = L1B_VOBS (IB)
          L1B_VAL  (NNB) = L1B_VAL  (IB) 
          L1B_DEV  (NNB) = L1B_DEV  (IB) 
        ENDIF 
      ENDDO
      L1B_NBOND = NNB

      RETURN
      END
C


      SUBROUTINE DEFINE_CHIR_FLAG(MDOC,IERR)
C -------------------------------------------------
C     DIFINE_CHIR_FLAG
C     not flat atom
C     L1A_ICHIR() = 1 user, 2 (n=4 or n=3( coords--> volume >  RLIMC)
C 
C     RLIMC=0.5
C -------------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------
      INTEGER*4 IJA(3)
      CHARACTER LINE*256
C ----------------------------------------------------
      IERR = 0
C     M    =-ABS(MDOC)-1
C ----------------
      NA     = L1A_NATOM
      RLIMC  = 0.5

      IF(L1L_PRSNT.EQ.'M'.AND.L1C_NCHIR.GT.0) THEN
        DO I=1,L1C_NCHIR
          IF(L1C_SIGN(I)(1:4).NE.'cros'.AND.
     *       L1C_SIGN(I)(1:4).NE.'star'     ) THEN  
            J = L1C_I1ATM(I)
            IF(J.GT.0) L1A_ICHIR(J) = 1
          ENDIF         
        ENDDO
      ENDIF

      IF(NA.GT.3) THEN
        DO   I=1,NA

          IF(L1A_NDIST(I).GE.3.AND.L1A_ATYPE(I).NE.'H'.AND.
     *                             L1A_ICHIR(I).LE.0) THEN
            NNH  = 0
            NH   = 0
            AVOL = 0.0
            VOL  = 0.0

            DO J=1,L1A_NDIST(I)
              IJ = ABS(L1A_CONN(J,I))
              IF(L1A_ATYPE(IJ).NE.'H') THEN
                NNH = NNH + 1
                IF(NNH.LE.3) IJA(NNH) = IJ
              ELSE
                NH = NH + 1
              ENDIF
            ENDDO  

                
            N = NNH +NH
            IF(N.GT.3) THEN
              L1A_ICHIR(I) = 2
            ENDIF

c           IF(NNH.GE.3.AND.L1L_PRSNT.EQ.'M') THEN
            IF(NNH.GE.3) THEN
              I1 = IJA(1)
              I2 = IJA(2)
              I3 = IJA(3)
              IF(L1A_COOR_FLAG(I ).EQ.'N'.OR.
     *           L1A_COOR_FLAG(I1).EQ.'N'.OR.
     *           L1A_COOR_FLAG(I2).EQ.'N'.OR.
     *           L1A_COOR_FLAG(I3).EQ.'N'    ) THEN                 
                GO TO 600
              ENDIF
              X1 = L1A_X(I)
              Y1 = L1A_Y(I)
              Z1 = L1A_Z(I)
              X2 = L1A_X(I1)
              Y2 = L1A_Y(I1)
              Z2 = L1A_Z(I1)
              X3 = L1A_X(I2)
              Y3 = L1A_Y(I2)
              Z3 = L1A_Z(I2)
              X4 = L1A_X(I3)
              Y4 = L1A_Y(I3)
              Z4 = L1A_Z(I3)
              A1 = X2-X1
              A4 = Y2-Y1
              A7 = Z2-Z1
              A2 = X3-X1
              A5 = Y3-Y1
              A8 = Z3-Z1
              A3 = X4-X1
              A6 = Y4-Y1
              A9 = Z4-Z1
              VOL = A1*(A5*A9 - A8*A6)
     *             -A4*(A2*A9 - A8*A3)
     *             +A7*(A2*A6 - A5*A3)
              AVOL = ABS(VOL)
              IF(AVOL.GT.RLIMC) L1A_ICHIR(I) = 2
            ENDIF

 600        CONTINUE

          ENDIF
        ENDDO
      ENDIF

      RETURN
      END


      SUBROUTINE LIB_CONN(MDOC,MODE,IERR)
C -----------------------------------------
C  output:
C
C     L1A_NDIST(IA)   - number of connect. 
C     L1A_CONN(I,IA)  - list of connect. ( Ith conn. with atom L1A_CONN(I,IA))
C     L1A_LENCON(1,IA)- number oc connect. with H atoms
C
C    list of connect / only set atom's number using L1B_1ATM() and L1B_2ATM()
C     L1B_I1ATM (IB) = IA
C     L1B_I2ATM (IB) = JA
C     L1B_VOBS  (IB) = DIST  / if L1A_COOR_FLAG(IA) = 'Y' /
C -------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER CIATOM*1,CJATOM*1,MON*8
      CHARACTER FLAG*1,LINE*256
C --------------------------------
      IERR = 0
C     M    = -ABS(MDOC)-1
C -----
      NA     = L1A_NATOM
      MON    = L1L_MNAME        


      DO IA=1,NA
        L1A_NDIST(IA) = 0
      ENDDO
     
      IF(NA.LE.1) THEN
        RETURN
      ENDIF

      DO    IA=1,NA-1
      IF(L1A_ANAME(IA).NE.'    ') THEN
        CIATOM = L1A_ATYPE(IA)
        XI     = L1A_X(IA)
        YI     = L1A_Y(IA)
        ZI     = L1A_Z(IA)

        DO    JA=IA+1,NA
        IF(L1A_ANAME(JA).NE.'    ') THEN
          CJATOM = L1A_ATYPE(JA)
          XJ     = L1A_X(JA)
          YJ     = L1A_Y(JA)
          ZJ     = L1A_Z(JA)
          IF(CIATOM.EQ.'H'.OR.CJATOM.EQ.'H') THEN    
            IC=1 
          ELSE IF(CIATOM.EQ.'C'.AND.CJATOM.EQ.'C') THEN    
            IC=2
          ELSE IF(CIATOM.EQ.'$'.AND.CJATOM.EQ.'$') THEN    
            IC=4
          ELSE 
            IC=3
          ENDIF
 
          DIST=0.0

          IF(L1A_COOR_FLAG(IA).EQ.'Y'.AND.
     *       L1A_COOR_FLAG(JA).EQ.'Y'     ) THEN
            DX   = XI-XJ
            DY   = YI-YJ
            DZ   = ZI-ZJ
            DIST = SQRT(DX*DX+DY*DY+DZ*DZ)
          ENDIF 

          FLAG = 'N'
          IF(L1B_NBOND.GT.0) THEN
            DO IB=1,L1B_NBOND
              IF(L1B_1ATM(IB).EQ.L1A_ANAME(IA).AND.
     *           L1B_2ATM(IB).EQ.L1A_ANAME(JA)) THEN
                L1B_I1ATM (IB) = IA
                L1B_I2ATM (IB) = JA
                L1B_VOBS  (IB) = DIST
                FLAG           = 'Y'
                GO TO 501
              ELSE IF(L1B_2ATM(IB).EQ.L1A_ANAME(IA).AND.
     *                L1B_1ATM(IB).EQ.L1A_ANAME(JA)) THEN
                L1B_I1ATM (IB) = JA
                L1B_I2ATM (IB) = IA
                L1B_VOBS  (IB) = DIST
                FLAG           = 'Y'
                GO TO 501
              ENDIF
            ENDDO

 501        CONTINUE
            IF(FLAG.EQ.'Y') THEN
              IF(L1A_NDIST(IA).LT.MAX1BRN) THEN
                L1A_NDIST(IA)              = L1A_NDIST(IA) + 1
                L1A_CONN(L1A_NDIST(IA),IA) = JA
                IF(L1A_ATYPE(JA).EQ.'H') THEN
                  L1A_LENCON(1,IA) = L1A_LENCON(1,IA) + 1
                ENDIF
              ELSE
                WRITE(LINE,'(3A,I6)')
     *          ' WARNING: number of connections of new monomer '
     *          ,L1L_MNAME,' >',MAX1BND 
                CALL MSGERR(MDOC,LINE)
                CALL MSGERR(MDOC,
     *    '        Change parameter MAX1BND in "lib_com.fh"')
              ENDIF
              IF(L1A_NDIST(JA).LT.MAX1BRN) THEN
                L1A_NDIST(JA)              = L1A_NDIST(JA) + 1
                L1A_CONN(L1A_NDIST(JA),JA) = IA
                IF(L1A_ATYPE(IA).EQ.'H') THEN
                  L1A_LENCON(1,JA) = L1A_LENCON(1,JA) + 1
                ENDIF
              ELSE
                WRITE(LINE,'(3A,I6)')
     *          ' WARNING: number of connections of new monomer '
     *          ,L1L_MNAME,' >',MAX1BND 
                CALL MSGERR(MDOC,LINE)
                CALL MSGERR(MDOC,
     *    '        Change parameter MAX1BND in "lib_com.fh"')
              ENDIF
            ENDIF

          ENDIF
        ENDIF
        ENDDO
      ENDIF
      ENDDO

      RETURN
      END

      SUBROUTINE LIST_BONDS_FROM_COOR(MDOC,IERR)
C -----------------------------------------
C  output:
C
C     L1A_NDIST(IA)   - number of connect. 
C     L1A_CONN(I,IA)  - list of connect. ( Ith conn. with atom L1A_CONN(I,IA))
C     L1A_LENCON(1,IA)- number oc connect. with H atoms
C
C    list of connect / only set atom's number using L1B_1ATM() and L1B_2ATM()
C     L1B_I1ATM (IB) = IA
C     L1B_I2ATM (IB) = JA
C     L1B_VOBS  (IB) = DIST  
C -------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256
      REAL      DLIM(4)
      CHARACTER CIATOM*1,CJATOM*1
      DATA DLIM/ 1.2, 1.7, 2.4, 2.85 /
C --------------------------------
      IERR   = 0
      IFIRST = 0
 100  CONTINUE
C -----
      NA        = L1A_NATOM
      L1B_NBOND = 0

      IF(NA.LE.1) THEN
        RETURN
      ENDIF

      DO IA=1,NA
        L1A_NDIST(IA) = 0 
      ENDDO
C ---
      DO    IA=1,NA-1
        CIATOM = L1A_ATYPE(IA)
        XI     = L1A_X(IA)
        YI     = L1A_Y(IA)
        ZI     = L1A_Z(IA)
        DO    JA=IA+1,NA
          CJATOM = L1A_ATYPE(JA)
          XJ     = L1A_X(JA)
          YJ     = L1A_Y(JA)
          ZJ     = L1A_Z(JA)
          IF(CIATOM.EQ.'H'.OR.CJATOM.EQ.'H') THEN    
            IC=1 
          ELSE IF(CIATOM.EQ.'C'.AND.CJATOM.EQ.'C') THEN    
            IC=2
          ELSE IF(CIATOM.EQ.'$'.AND.CJATOM.EQ.'$') THEN    
            IC=4
          ELSE 
            IC=3
          ENDIF
          DX   = XI-XJ
          DY   = YI-YJ
          DZ   = ZI-ZJ
          DIST = SQRT(DX*DX+DY*DY+DZ*DZ)
          IF(DIST.LE.DLIM(IC).AND.DIST.GT.0.001) THEN 
            IF(L1B_NBOND.GE.MAX1BND) THEN
              WRITE(LINE,'(3A,I6)')
     *        ' ERROR: number of bonds of new monomer '
     *        ,L1L_MNAME,' >',MAX1BND 
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC,
     *  '          Change parameter MAX1BND in "lib_com.fh"')
              IERR=1
              RETURN
            ENDIF 
            L1A_NDIST(IA) = L1A_NDIST(IA) + 1
            L1A_NDIST(JA) = L1A_NDIST(JA) + 1

            L1B_NBOND             = L1B_NBOND+1
            L1B_I1ATM (L1B_NBOND) = IA
            L1B_1ATM  (L1B_NBOND) = L1A_ANAME(IA)
            L1B_I2ATM (L1B_NBOND) = JA
            L1B_2ATM  (L1B_NBOND) = L1A_ANAME(JA)
            L1B_VOBS  (L1B_NBOND) = DIST
            L1B_TYPE  (L1B_NBOND) = '.'
          ENDIF

        ENDDO
      ENDDO

C     check_H-atoms connection, must be = 1

      IF(IFIRST.EQ.0) THEN
        IERR   = 0
        IFIRST = 1
        DO    IA=1,NA
          CIATOM = L1A_ATYPE(IA)
          IF(CIATOM.EQ.'H'.AND.L1A_NDIST(IA).NE.1) THEN
            L1A_ATYPE(IA) = '?'
            IERR = 1
          ENDIF
        ENDDO
        IF(IERR.NE.0) THEN
          IERR = 0
          CALL CHECK_LIST_ATOM(MDOC,IERR)
          IF(IERR.EQ.0) GO TO 100
        ENDIF
      ENDIF
C ---
      RETURN
      END

C --- Garib ---

C
      SUBROUTINE ADD_TYPE_USING_COORD(MDOC,LIST,IERR)
C --------------------------------------------
      IMPLICIT NONE
      INCLUDE 'lib_com.fh'
C
C--defines bond orders using coordinates
C
C----Alternative way is loop over atoms and their neibours.
C --------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LIST*1
C ------------------------------
C        L1A_NATOM 
C        L1A_COOR_FLAG()  'Y' 
C        L1A_X        () 
C        L1A_Y        () 
C        L1A_Z        ()
C        L1A_CHARG    ()
C        L1A_ANAME    ()  - atom's name 
C        L1A_SYMB     ()  - atom's symbol - 'C   ','N   ','O   ','H   ',
C                                           'FE  ','P   ','S   ','CL  ',...
C        L1A_ATYPE    ()  'H' for H and D
C                         'C' for C,N,O,B,F,LI  
C                         'P' for P,S  
C                         '$' other heavy atoms'   
C
C --- connection         
c
C    DO IC=1,L1A_NDIST(IA)  for each  IA - L1A_NDIST number of connected atoms
C    IAC = L1A_CONN(IC,IA)  connection:  IA --> IAC
C
C    number of connections with H-atoms
C    N_HATOM     = L1A_LENCON(1,IA)
C
C    only for H-atom:  
C    ICONN_H defines connection for H-atom
c    ICONN_H  = ABS(L1A_CONN(1,I))
C    i.e H-atom I is connected with atom ICONN_H 
C    ring
CC
c        DO I=1,L1A_NRING(IA)
c          L1A_RING_ID  (I,IA) - ring number
c          L1A_RING_ORD (I,IA) = 4,5,6 
c          L1A_RING_FLAT(I,IA) = 1 flat, 0 not flat
c
C --- chirality
C
C     L1A_ICHIR() : > 0 chir
C     L1A_ICHIR() = 1 user, 2 (ndist>3 or 
C                              ndist>2 ( coords--> volume >  RLIMC(=0.5))
c
C ---
C        L1B_NBOND
C        L1B_1ATM     ()
C        L1B_2ATM     ()
C        L1B_TYPE     () 
C        L1B_VOBS     () 
C
C ---------------------
C
      INTEGER IB,IA1,IA2,IB1,IB2,IEB1,IEB2,ILB,IL1,IL2,IBB,IA3,NBOND
      INTEGER ISING
      REAL    DIST,DIFF_DIST,DIFF_PREV,DIST1,DIST_BOND,VAL
      CHARACTER BOND_ORDER*8,BOND_ORDER1*8,ASYMB1*4,ASYMB2*4
      CHARACTER LINE*256
C
C -----------------------------------------------------------
      IERR = 0
      IF(L1B_NBOND.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
C
      DO IB=1,L1B_NBOND
C
C---loop over all energetic type pairs and find 
C---closest distance for these element pairs.
        IA1    = L1B_I1ATM(IB)
        IA2    = L1B_I2ATM(IB)
        ASYMB1 = L1A_SYMB(IA1)
        ASYMB2 = L1A_SYMB(IA2)
        DIST   = L1B_VOBS(IB)
C----Now check and define
C
C---Values should be read from the library
        BOND_ORDER = '.'
        DIFF_PREV  = 1.0E32
C
C 
C---Define obvious ones first
C
cd        WRITE(*,*)ASYMB1,ASYMB2,L1A_NDIST(IA1),L1A_NDIST(IA2),
cd     &            L1A_LENCON(1,IA1),L1A_LENCON(1,IA2)
        IF(ASYMB1(1:2).EQ.'H '.OR.
     &     ASYMB1(1:2).EQ.'D '.OR.
     &     ASYMB2(1:2).EQ.'H '.OR.
     &     ASYMB2(1:2).EQ.'D '.OR.

     &     ASYMB1(1:2).EQ.'F '.OR.
     &     ASYMB2(1:2).EQ.'F '.OR.

     &     ASYMB1(1:2).EQ.'CL'.OR.
     &     ASYMB2(1:2).EQ.'CL'.OR.

     &     ASYMB1(1:2).EQ.'I '.OR.
     &     ASYMB2(1:2).EQ.'I '.OR.

     &     ASYMB1(1:2).EQ.'CL'.OR.
     &     ASYMB2(1:2).EQ.'CL'.OR.

     &     ASYMB1(1:2).EQ.'BR'.OR.
     &     ASYMB2(1:2).EQ.'BR'.OR.

     &     ASYMB1(1:2).EQ.'B '.OR.
     &     ASYMB2(1:2).EQ.'B '
     &                                        )THEN
          BOND_ORDER = 'single'
        ELSEIF(ASYMB1(1:2).EQ.'O ') THEN
          IF(L1A_NDIST(IA1).EQ.2) BOND_ORDER = 'single'
        ELSEIF(ASYMB2(1:2).EQ.'O ') THEN
          IF(L1A_NDIST(IA2).EQ.2) BOND_ORDER = 'single'
        ELSEIF(ASYMB1(1:2).EQ.'C ') THEN
          IF(L1A_NDIST(IA1).EQ.4) BOND_ORDER = 'single'
        ELSEIF(ASYMB2(1:2).EQ.'C ') THEN
          IF(L1A_NDIST(IA2).EQ.4) BOND_ORDER = 'single'
        ELSEIF(ASYMB1(1:2).EQ.'N ') THEN
          IF(L1A_NDIST(IA1).EQ.4) BOND_ORDER = 'single'
        ELSEIF(ASYMB2(1:2).EQ.'N ') THEN
          IF(L1A_NDIST(IA2).EQ.4) BOND_ORDER = 'single'
        ELSEIF(ASYMB1(1:2).EQ.'S ') THEN
          IF(L1A_NDIST(IA1).EQ.2) BOND_ORDER = 'single'
        ELSEIF(ASYMB2(1:2).EQ.'S ') THEN
          IF(L1A_NDIST(IA2).EQ.2) BOND_ORDER = 'single'
        ELSE IF(ASYMB1(1:2).EQ.'SE') THEN
          IF(L1A_NDIST(IA1).EQ.2) BOND_ORDER = 'single'
        ELSE IF(ASYMB2(1:2).EQ.'SE') THEN
          IF(L1A_NDIST(IA2).EQ.2) BOND_ORDER = 'single'
        ENDIF
C
        DO   ILB=1,LEB_NBOND
          IB1 = LEB_I1ATM(ILB)
          IB2 = LEB_I2ATM(ILB)
C
C--Make sure that we are not considering single bonds between sp1
C--atoms. They are much shorter.
          IF((ASYMB1(1:2).EQ.LEA_ENAME(IB1)(1:2).AND.
     &        ASYMB2(1:2).EQ.LEA_ENAME(IB2)(1:2)).OR.
     &       (ASYMB2(1:2).EQ.LEA_ENAME(IB1)(1:2).AND.
     &        ASYMB1(1:2).EQ.LEA_ENAME(IB2)(1:2))) THEN
            IF((LEB_1ATM(ILB)(1:3).NE.'CSP'.AND.
     &          LEB_2ATM(ILB)(1:3).NE.'CSP'.AND.
     &          LEB_1ATM(ILB)(1:2).NE.'NS'.AND.
     &          LEB_2ATM(ILB)(1:2).NE.'NS').OR.
     &          LEB_TYPE(ILB)(1:4).EQ.'trip') THEN
              DIFF_DIST = ABS(DIST-LEB_LENGTH(ILB))
              IF(DIFF_DIST.LT.DIFF_PREV) THEN
                DIFF_PREV  = DIFF_DIST
                BOND_ORDER = LEB_TYPE(ILB)
              ENDIF
            ENDIF
          ENDIF
        ENDDO
C
C---There is no pair. Look for "covalent diameter" of atoms
        BOND_ORDER1 = '.'
        IF(BOND_ORDER(1:1).EQ.'.') THEN
          DO   IEB1=1,LEB_NBOND
            IF(LEB_2ATM(IEB1)(1:1).EQ.'.') THEN
            IL1 = LEB_I1ATM(IEB1)
            IF(ASYMB1(1:2).EQ.LEA_ENAME(IL1)(1:2)) THEN
              BOND_ORDER1 = LEB_TYPE(IEB1)
              DO  IEB2=1,LEB_NBOND
                IF(LEB_2ATM(IEB2)(1:1).EQ.'.') THEN
                IF(BOND_ORDER1(1:4).EQ.LEB_TYPE(IEB2)(1:4)) THEN
                  IL2 = LEB_I1ATM(IEB2)
                  IF(ASYMB2(1:2).EQ.LEA_ENAME(IL2)(1:2)) THEN
                    DIST_BOND = (LEB_LENGTH(IEB1)+LEB_LENGTH(IEB2))/2.0
                    DIFF_DIST = ABS(DIST_BOND-DIST)
                    IF(DIFF_DIST.LT.DIFF_PREV) THEN
                      DIFF_PREV  = DIFF_DIST
                      BOND_ORDER = BOND_ORDER1
                    ENDIF
                  ENDIF
                  ENDIF
                ENDIF
              ENDDO
            ENDIF
            ENDIF
          ENDDO
        ENDIF
C
C---Still no bond order. If one of the atoms can have metal bond
        IF(BOND_ORDER(1:1).EQ.'.') THEN
          DO   IEB1=1,LEB_NBOND
            IB1 = LEB_I1ATM(IEB1)
            IB2 = LEB_I2ATM(IEB1)

c            IB1 = LEB_I1ATM(ILB)
c            IB2 = LEB_I2ATM(ILB)

c       write(*,*) ib1,ib2,'<',ASYMB1,'><',ASYMB2,'>'
c     * ,'<',LEA_ENAME(IB1),'><',LEA_ENAME(IB2),'>',LEB_TYPE(IEB1)


            IF((ASYMB1(1:2).EQ.LEA_ENAME(IB1)(1:2) .OR.
     &          ASYMB2(1:2).EQ.LEA_ENAME(IB1)(1:2) .OR.
     &          ASYMB1(1:2).EQ.LEA_ENAME(IB2)(1:2) .OR.
     &          ASYMB2(1:2).EQ.LEA_ENAME(IB2)(1:2)).AND.
     &          LEB_TYPE(IEB1)(1:5).EQ.'metal'         ) THEN
              BOND_ORDER = 'metal'
              GOTO 100
            ENDIF
          ENDDO
        ENDIF
C
c---Could not find from the energetic library. Something is wrong.
C---All atoms should be in the energetic library. Either library is not full
C---or element name is not correct.
        IF(BOND_ORDER.EQ.'.') THEN
          IERR = 1
          BOND_ORDER = 'single'
        ENDIF
 100    CONTINUE
C
c---Now define bond orders.
        L1B_TYPE(IB) = BOND_ORDER
C
C--Print to make sure things are all right.

      ENDDO
C
C---Check if element name is not correct.
C
      IF(IERR.NE.0) THEN
        DO   IA1=1,L1A_NATOM
          ASYMB1 = L1A_SYMB(IA1)
          DO   IL1=1,LEA_NATOM
            IF(ASYMB1(1:2).EQ.LEA_ENAME(IL1)) GOTO 200
          ENDDO
          LINE = 'ERROR: Atom '//L1A_ANAME(IA1)(1:4)//
     &    ' with element name '//ASYMB1(1:2)
          CALL MSGERR(MDOC,LINE)
          LINE = '       does not exist in the'//
     &        'energetic library "ener_lib.cif"'
          CALL MSGERR(MDOC,LINE)
 200      CONTINUE
        ENDDO
        LINE = 'ERROR: Energetic library - "ener_lib.cif" is incomplete'
        CALL MSGERR(MDOC,LINE)
        RETURN
      ENDIF
C
C--Can we correct some bond orders?
C
C--First see if we have triple bond. Then another bond must be single
      DO   IB=1,L1B_NBOND
        IA1    = L1B_I1ATM(IB)
        IA2    = L1B_I2ATM(IB)
        IF(L1B_TYPE(IB).EQ.'trip') THEN
          ASYMB1 = L1A_SYMB(IA1)
          ASYMB2 = L1A_SYMB(IA2)
          NBOND = L1A_NDIST(IA1)
          DO   IBB=1,NBOND
            IA3 = L1A_CONN(IBB,IA1)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IA3.NE.IA2.AND.IA3.GT.0) THEN
              CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,IERR)
              IF(L1B_TYPE(IB1)(1:4).NE.'meta') L1B_TYPE(IB1) = 'single'
            ENDIF
          ENDDO
          NBOND = L1A_NDIST(IA2)
          DO   IBB=1,NBOND
            IA3 = L1A_CONN(IBB,IA2)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IA3.NE.IA1.AND.IA3.GT.0) THEN
              CALL SRCH_BOND(MDOC,L1L_MNAME,IA2,IA3,VAL,IB1,IERR)
              IF(L1B_TYPE(IB1)(1:4).NE.'meta') L1B_TYPE(IB1) = 'single'
            ENDIF
          ENDDO
        ELSE IF(L1B_TYPE(IB)(1:4).EQ.'delo'.OR.
     &          L1B_TYPE(IB)(1:4).EQ.'arom') THEN
C
C--If one of the atoms is C and bond order is defines as 'deloc' or 'arom'
C--C has three bonds, two of them is single then 'deloc' should become 'double'
          ASYMB1 = L1A_SYMB(IA1)
          ASYMB2 = L1A_SYMB(IA2)
          ISING = 0
          IF(ASYMB1(1:2).EQ.'C ') THEN
            NBOND = L1A_NDIST(IA1)
            DO   IBB=1,NBOND
              IA3 = L1A_CONN(IBB,IA1)
              IF(IA3.LT.0) IA3 = -IA3
              IF(IA3.NE.IA2.AND.IA3.GT.0) THEN
                CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,IERR)
                IF(L1B_TYPE(IB1)(1:4).EQ.'sing') ISING = ISING + 1
              ENDIF
            ENDDO
          ELSE IF(ASYMB2(1:2).EQ.'C ') THEN
            NBOND = L1A_NDIST(IA2)
            DO   IBB=1,NBOND
              IA3 = L1A_CONN(IBB,IA2)
              IF(IA3.LT.0) IA3 = -IA3
              IF(IA3.NE.IA1.AND.IA3.GT.0) THEN
                CALL SRCH_BOND(MDOC,L1L_MNAME,IA2,IA3,VAL,IB1,IERR)
                IF(L1B_TYPE(IB1)(1:4).EQ.'sing') ISING = ISING + 1
              ENDIF
            ENDDO
          ENDIF
          IF(ISING.EQ.2) L1B_TYPE(IB) = 'double'
        ENDIF
  
C
C--If one of the atoms is Hydrogen then bond order is single
        IF((L1A_SYMB(IA1)(1:2).EQ.'H '.OR.
     &      L1A_SYMB(IA2)(1:2).EQ.'H ').AND.
     &     L1B_TYPE(IB)(1:4).NE.'meta') THEN
          L1B_TYPE(IB) = 'single'
        ENDIF
      ENDDO


      RETURN
      END

      SUBROUTINE CHECK_OXYGENS_BOND(MDOC,LIST,IERR) 
      IMPLICIT NONE
      INCLUDE 'lib_com.fh'

      INTEGER MDOC,IERR
      CHARACTER LIST*1
C
C---Makes corrections for Oxygens bound to C, S and P
      INTEGER IA,IA1,IA2,IA3,ID,IB1,IB2,IB3,IB4,IOXIG,IA_OX(10)
      INTEGER IA31,IA32,IOTHER_BOND
      REAL EPS_L,VAL
      DATA EPS_L/1.0E-4/
C
      DO   IA=1,L1A_NATOM
C
C--Try to avoid repeatation.
        IF(L1A_SYMB(IA)(1:2).EQ.'O '.AND.
     &            ABS(L1A_CHARG(IA)).LT.EPS_L) THEN
          IF(L1A_NDIST(IA).EQ.1) THEN
C
C--Check neibouring atom. If it is C, S or P then try to make corrections
            IA1 = L1A_CONN(1,IA)
            IF(IA1.LT.0) IA1 = -IA1
            IF(IA1.GT.0) THEN
              IF(L1A_SYMB(IA1)(1:2).EQ.'C '.AND.L1A_NDIST(IA1).LT.4) 
     &                 THEN
C
C---It is C. If it is sp2 C then correction can be made. If C has four bounds 
C---then it cannot be SP2. Then it is SP3. 
                DO  ID=1,L1A_NDIST(IA1)
                  IA3 = L1A_CONN(ID,IA1)
                  IF(IA3.LT.0) IA3 = -IA3
                  IF(IA3.GT.0.AND.IA3.NE.IA) THEN
                    IF(L1A_SYMB(IA3)(1:2).EQ.'O ') THEN
C
C---There is another oxygen binds to the C. 
                      IF(L1A_NDIST(IA3).EQ.1) THEN
                        CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB1,
     &                            IERR)
                        CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB2,
     &                            IERR)
                        L1B_TYPE(IB1) = 'deloc'
                        L1B_TYPE(IB2) = 'deloc'
                        IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                     ABS(L1A_CHARG(IA3)).LT.EPS_L) THEN
                              L1A_CHARG(IA ) = -0.5
                              L1A_CHARG(IA3) = -0.5
                        ENDIF
                      ENDIF
                    ENDIF
                  ENDIF
                ENDDO
              ELSE IF(L1A_SYMB(IA1)(1:2).EQ.'S ') THEN
C
C---If there are 2 Oxygens with one bond. or 3 oxygens
                IF(L1A_NDIST(IA1).EQ.4) THEN
                  IOXIG = 0
                  IOTHER_BOND = 0
                  DO  ID=1,L1A_NDIST(IA1)
                    IA3 = L1A_CONN(ID,IA1)
                    IF(IA3.LT.0) IA3 = -IA3
                    IF(IA3.NE.IA.AND.IA3.GT.0) THEN
                      IF(L1A_SYMB(IA3)(1:2).EQ.'O ') THEN
                        IF(L1A_NDIST(IA3).EQ.1) THEN
                          IOXIG       = IOXIG + 1
                          IA_OX(IOXIG) = IA3
                        ELSE
                          IOTHER_BOND = IOTHER_BOND + 1
                        ENDIF
                      ELSE
C
C---What is happenning to the bond which is bound to the S and something else.
C---If it is not O then it can have double bond to S.
                        CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                        IF(L1B_TYPE(IB1).EQ.'single') THEN
                          IOTHER_BOND = IOTHER_BOND + 1
                        ELSE IF(L1B_TYPE(IB1).EQ.'double') THEN
                          IOTHER_BOND = IOTHER_BOND + 2
                        ELSE
                          IOTHER_BOND = IOTHER_BOND + 1
                        ENDIF
                      ENDIF
                    ENDIF
                  ENDDO
                  IF(IOXIG.EQ.0) THEN
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB2,
     &                            IERR)
                    IF(IOTHER_BOND.EQ.5) THEN
                      L1B_TYPE(IB2) = 'single'
                    ELSEIF(IOTHER_BOND.EQ.4) THEN
                      L1B_TYPE(IB2) = 'double'
                    ENDIF
                  ELSE IF(IOXIG.EQ.1) THEN
                    IA3 = IA_OX(1)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB2,
     &                            IERR)
C
C--If there is only one Oxygen then bonds could be double only. Should count 
C--number of other bonds also.
                    IF(IOTHER_BOND.EQ.2) THEN
                      L1B_TYPE(IB1) = 'double'
                      L1B_TYPE(IB2) = 'double'
                    ELSEIF(IOTHER_BOND.EQ.3) THEN 
C
c---Charge is -1
                      L1B_TYPE(IB1)  = 'deloc'
                      L1B_TYPE(IB2)  = 'deloc'
                      L1A_CHARG(IA)  = -0.5
                      L1A_CHARG(IA3) = -0.5
                    ELSEIF(IOTHER_BOND.EQ.4) THEN
                       L1B_TYPE(IB1) = 'deloc'
                       L1B_TYPE(IB2) = 'deloc'
                       L1A_CHARG(IA) = -1.0
                       L1A_CHARG(IA3) = -1.0
                    ENDIF
                  ELSE IF(IOXIG.EQ.2) THEN
                    IA3 = IA_OX(1)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                    IA31 = IA_OX(2)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA31,VAL,IB2,
     &                            IERR)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB3,
     &                            IERR)
C
C---If there are 2 more Oxygens then bonds are double and charge is -1
                    IF(IOTHER_BOND.EQ.1) THEN
                      L1B_TYPE(IB1)   = 'deloc'
                      L1B_TYPE(IB2)   = 'deloc'
                      L1B_TYPE(IB3)   = 'deloc'
C
C---Can one of the bonds not with Oxygen be double bond?? Check it
                      IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(1))).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L) THEN
                        L1A_CHARG(IA  ) = -0.33
                        L1A_CHARG(IA3 ) = -0.33
                        L1A_CHARG(IA31) = -0.33
                      ENDIF
                    ELSEIF(IOTHER_BOND.EQ.2) THEN
                      L1B_TYPE(IB1) = 'deloc'
                      L1B_TYPE(IB2) = 'deloc'
                      L1B_TYPE(IB3) = 'deloc'
                      IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(1))).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L) THEN
                        L1A_CHARG(IA  ) = -0.66
                        L1A_CHARG(IA3 ) = -0.66
                        L1A_CHARG(IA31) = -0.66
                      ENDIF
                    ENDIF
                  ELSE IF(IOXIG.EQ.3) THEN
C
C---If there are 3 extra Oxygens then it is SO4 and charge should ne -2
                    IA3 = IA_OX(1)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                    IA31 = IA_OX(2)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA31,VAL,IB2,
     &                            IERR)
                    IA32 = IA_OX(3)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA32,VAL,IB3,
     &                            IERR)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB4,
     &                            IERR)
                    L1B_TYPE(IB1) = 'deloc'
                    L1B_TYPE(IB2) = 'deloc'
                    L1B_TYPE(IB3) = 'deloc'
                    L1B_TYPE(IB4) = 'deloc'
                    IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                 ABS(L1A_CHARG(IA_OX(1))).LT.EPS_L.AND.
     &                 ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L.AND.
     &                 ABS(L1A_CHARG(IA_OX(3))).LT.EPS_L) THEN

                      L1A_CHARG(IA  ) = -0.5
                      L1A_CHARG(IA3 ) = -0.5
                      L1A_CHARG(IA31) = -0.5
                      L1A_CHARG(IA32) = -0.5
                    ENDIF
                  ENDIF
                ENDIF
              ELSE IF(L1A_SYMB(IA1)(1:2).EQ.'P ') THEN
C
C--If there are 2 oxygens with one bond
C
C---If there are 2 Oxygens with one bond. or 3 oxygens
                IF(L1A_NDIST(IA1).EQ.4) THEN
                  IOXIG = 0
                  IOTHER_BOND = 0
                  DO  ID=1,L1A_NDIST(IA1)
                    IA3 = L1A_CONN(ID,IA1)
                    IF(IA3.LT.0) IA3 = -IA3
                    IF(IA3.NE.IA.AND.IA3.GT.0) THEN
                      IF(L1A_SYMB(IA3)(1:2).EQ.'O ') THEN
                        IF(L1A_NDIST(IA3).EQ.1) THEN
                          IOXIG = IOXIG + 1
                          IA_OX(IOXIG) = IA3
                        ELSE
                          IOTHER_BOND = IOTHER_BOND +1 
                        ENDIF
                      ELSE
                        CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                        IF(L1B_TYPE(IB1).EQ.'single') THEN
                          IOTHER_BOND = IOTHER_BOND + 1
                        ELSE IF(L1B_TYPE(IB1).EQ.'double') THEN
                          IOTHER_BOND = IOTHER_BOND + 2
                        ELSE
                          IOTHER_BOND = IOTHER_BOND + 1
                        ENDIF                         
                      ENDIF
                    ENDIF
                  ENDDO
                  IF(IOXIG.EQ.0) THEN
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB2,
     &                            IERR)
                    IF(IOTHER_BOND.EQ.3) THEN
                      L1B_TYPE(IB2) = 'double'
                    ELSE IF(IOTHER_BOND.EQ.4) THEN
                      L1B_TYPE(IB2) = 'single'
                    ENDIF
                  ELSEIF(IOXIG.EQ.1) THEN
                    IA3 = IA_OX(1)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB2,
     &                            IERR)
                    IF(IOTHER_BOND.EQ.2) THEN
                      L1B_TYPE(IB1) = 'deloc'
                      L1B_TYPE(IB2) = 'deloc'
                      IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA3)).LT.EPS_L) THEN
                        L1A_CHARG(IA) = -0.5
                        L1A_CHARG(IA3) = -0.5
                      ENDIF
                    ELSE IF(IOTHER_BOND.EQ.3) THEN
                      L1B_TYPE(IB1) = 'deloc'
                      L1B_TYPE(IB1) = 'deloc'
                      IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA3)).LT.EPS_L) THEN
                        L1A_CHARG(IA)  = -1.0
                        L1A_CHARG(IA3) = -1.0
                      ENDIF            
                    ENDIF
                  ELSE IF(IOXIG.EQ.2) THEN
                    IA3 = IA_OX(1)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                    IA31 = IA_OX(2)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA31,VAL,IB2,
     &                            IERR)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB3,
     &                            IERR)
                    IF(IOTHER_BOND.EQ.1) THEN
                      L1B_TYPE(IB1) = 'deloc'
                      L1B_TYPE(IB2) = 'deloc'
                      L1B_TYPE(IB3) = 'deloc'
                      IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(1))).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L) THEN
                        L1A_CHARG(IA)   = -0.66
                        L1A_CHARG(IA3)  = -0.66
                        L1A_CHARG(IA31) = -0.66
                      ENDIF
                    ELSE
                      L1B_TYPE(IB1) = 'deloc'
                      L1B_TYPE(IB2) = 'deloc'
                      L1B_tYPE(IB3) = 'deloc'
                      L1B_TYPE(IB3) = 'deloc'
                      IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(1))).LT.EPS_L.AND.
     &                   ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L) THEN
                        L1A_CHARG(IA)   = -0.33
                        L1A_CHARG(IA3)  = -0.33
                        L1A_CHARG(IA31) = -0.33
                      ENDIF
                    ENDIF
                  ELSE IF(IOXIG.EQ.3) THEN
                     IA3 = IA_OX(1)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA3,VAL,IB1,
     &                            IERR)
                    IA31 = IA_OX(2)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA31,VAL,IB2,
     &                            IERR)
                    IA32 = IA_OX(3)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA2,VAL,IB3,
     &                            IERR)
                    CALL SRCH_BOND(MDOC,L1L_MNAME,IA1,IA,VAL,IB4,
     &                            IERR) 
                    L1B_TYPE(IB1) = 'deloc'
                    L1B_TYPE(IB2) = 'deloc'
                    L1B_TYPE(IB3) = 'deloc'
                    L1B_TYPE(IB4) = 'deloc'
                    IF(ABS(L1A_CHARG(IA )).LT.EPS_L.AND.
     &                 ABS(L1A_CHARG(IA_OX(1))).LT.EPS_L.AND.
     &                 ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L.AND.
     &                 ABS(L1A_CHARG(IA_OX(2))).LT.EPS_L) THEN
                      L1A_CHARG(IA)   = -0.75
                      L1A_CHARG(IA3)  = -0.75
                      L1A_CHARG(IA31) = -0.75
                      L1A_CHARG(IA32) = -0.75
                    ENDIF
                  ENDIF
                ENDIF
              ENDIF
            ENDIF
          ENDIF
        ENDIF
      ENDDO
      RETURN
      END

      SUBROUTINE ADD_TYPE_USING_CHEM(MDOC,LIST,IERR)
C --------------------------------------------
      IMPLICIT NONE
C
C--defines bond orders using atom chemical types
C
C --------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LIST*1
C --
      INCLUDE 'lib_com.fh'
C --
C ------------------------------
C        L1A_NATOM 
C        L1A_CHARG    ()
C        L1A_ANAME    ()  - atom's name 
C        L1A_SYMB     ()  - atom's symbol - 'C   ','N   ','O   ','H   ',
C                                           'FE  ','P   ','S   ','CL  ',...
C        L1A_CHEM     ()
C        L1A_ATYPE    ()  'H' for H and D
C                         'C' for C,N,O,B,F,LI  
C                         'P' for P,S  
C                         '$' other heavy atoms'   
C
C --- connection         
c
C    DO IC=1,L1A_NDIST(IA)  for each  IA - L1A_NDIST number of connected atoms
C    IAC = L1A_CONN(IC,IA)  connection:  IA --> IAC
C
C    number of connections with H-atoms
C    N_HATOM     = L1A_LENCON(1,IA)
C
C    only for H-atom:  
C    ICONN_H defines connection for H-atom
c    ICONN_H  = ABS(L1A_CONN(1,I))
C    i.e H-atom I is connected with atom ICONN_H 
C    ring
CC
c        DO I=1,L1A_NRING(IA)
c          L1A_RING_ID  (I,IA) - ring number
c          L1A_RING_ORD (I,IA) = 4,5,6 
c          L1A_RING_FLAT(I,IA) = 1 flat, 0 not flat
c
C --- chirality
C
C     L1A_ICHIR() : > 0 chir, < 0 flat, else =0
C     L1A_ICHIR() = 1 user, 2 (ndist > 3 )
c
C ---
C        L1B_NBOND
C        L1B_1ATM     ()
C        L1B_2ATM     ()
C        L1B_TYPE     () 
C        L1B_VOBS     () 
C
C ---------------------

      IERR = 1

C --------------------------------------------
C ---
      RETURN
      END

      SUBROUTINE ADD_TYPE_USING_LIST(MDOC,LIST,IERR)
C --------------------------------------------
      IMPLICIT NONE
C
C--defines bond orders using list of atoms (without chemical types)
C                       and list of bonds (without orders)
C --------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LIST*1
C --
      INCLUDE 'lib_com.fh'
C --
C ------------------------------
C        L1A_NATOM 
C        L1A_CHARG    ()
C        L1A_ANAME    ()  - atom's name 
C        L1A_SYMB     ()  - atom's symbol - 'C   ','N   ','O   ','H   ',
C                                           'FE  ','P   ','S   ','CL  ',...
C        L1A_ATYPE    ()  'H' for H and D
C                         'C' for C,N,O,B,F,LI  
C                         'P' for P,S  
C                         '$' other heavy atoms'   
C
C --- connection         
c
C    DO IC=1,L1A_NDIST(IA)  for each  IA - L1A_NDIST number of connected atoms
C    IAC = L1A_CONN(IC,IA)  connection:  IA --> IAC
C
C    number of connections with H-atoms
C    N_HATOM     = L1A_LENCON(1,IA)
C
C    only for H-atom:  
C    ICONN_H defines connection for H-atom
c    ICONN_H  = ABS(L1A_CONN(1,I))
C    i.e H-atom I is connected with atom ICONN_H 
C    ring
C
c        DO I=1,L1A_NRING(IA)
c          L1A_RING_ID  (I,IA) - ring number
c          L1A_RING_ORD (I,IA) = 4,5,6 
c          L1A_RING_FLAT(I,IA) = 1 flat, 0 not flat
c
C --- chirality
C
C     L1A_ICHIR() : > 0 chir, < 0 flat, 0 non-flat
C     L1A_ICHIR() = 1 user, 2 (ndist > 3 )
c
C ---
C        L1B_NBOND
C        L1B_1ATM     ()
C        L1B_2ATM     ()
C        L1B_VOBS     () 
C
C ---------------------
C
C---First define sp2, sp3 types etc. 
      INTEGER I,NBOND,N_HATOM,IA,IA1,IA2,IB,IR,IR1,IR2,NRING_ALL,
     &        IRING_FLAG,IAA,NBOND1,IA3
      REAL OXIDATION
      CHARACTER SYMB*4,SYMB1*4,SYMB2*4
      LOGICAL IS_IT_METAL,IS_IT_METAL1,IS_IT_METAL2
      EXTERNAL IS_IT_METAL
C
C--Treat simplest cases first.
      DO   I=1,L1B_NBOND
        IA1 = L1B_I1ATM(I)
        IA2 = L1B_I2ATM(I)
C
C---Find NBOND = all_bonds-metal_bonds. Metals have to be treated
C---properly. Sometimes metal bond will be counted in other cases
C---they should not be counted.

        SYMB1 = L1A_SYMB(IA1)
        SYMB2 = L1A_SYMB(IA2)

        IF(SYMB1(1:2).EQ.'H '.OR.
     &     SYMB1(1:2).EQ.'D '.OR.
     &     SYMB2(1:2).EQ.'H '.OR.
     &     SYMB2(1:2).EQ.'D '.OR.

     &     SYMB1(1:2).EQ.'F '.OR.
     &     SYMB2(1:2).EQ.'F '.OR.

     &     SYMB1(1:2).EQ.'CL'.OR.
     &     SYMB2(1:2).EQ.'CL'.OR.

     &     SYMB1(1:2).EQ.'I '.OR.
     &     SYMB2(1:2).EQ.'I '.OR.

     &     SYMB1(1:2).EQ.'CL'.OR.
     &     SYMB2(1:2).EQ.'CL'.OR.

     &     SYMB1(1:2).EQ.'BR'.OR.
     &     SYMB2(1:2).EQ.'BR'.OR.

     &     SYMB1(1:2).EQ.'B '.OR.
     &     SYMB2(1:2).EQ.'B '
     &                                        )THEN
          L1B_TYPE(I) = 'single'
        ELSEIF(IS_IT_METAL(L1A_SYMB(IA1)).OR.
     &         IS_IT_METAL(L1A_SYMB(IA2))) THEN
          L1B_TYPE(I) = 'metal'
        ELSE
          NBOND1 = L1A_NDIST(IA1)
          NBOND  = NBOND1
          DO  IAA=1,NBOND
            IA3 = L1A_CONN(IAA,IA1)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IS_IT_METAL(L1A_SYMB(IA3))) NBOND1 = NBOND1-1
          ENDDO
          IF(SYMB1(1:2).EQ.'C '.AND.NBOND1.EQ.4) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB1(1:2).EQ.'O '.AND.NBOND1.EQ.2) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB1(1:2).EQ.'N '.AND.NBOND1.EQ.4) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB1(1:2).EQ.'S '.AND.NBOND1.EQ.2) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB1(1:2).EQ.'SE'.AND.NBOND1.EQ.2) THEN
            L1B_TYPE(I) = 'single'
          ENDIF

          NBOND1 = L1A_NDIST(IA2)
          NBOND  = NBOND1
          DO  IAA=1,NBOND
            IA3 = L1A_CONN(IAA,IA2)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IS_IT_METAL(L1A_SYMB(IA3))) NBOND1 = NBOND1-1
          ENDDO

C ????????????????????????
C         OXIDATION  = L1A_CHARG(IA2) ???
          OXIDATION  = 0.0
          IF(SYMB1(1:2).EQ.'C '.AND.NBOND1.EQ.4) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB2(1:2).EQ.'O '.AND.NBOND1.EQ.2) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB2(1:2).EQ.'N '.AND.NBOND1.EQ.4) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB2(1:2).EQ.'S '.AND.NBOND1.EQ.2) THEN
            L1B_TYPE(I) = 'single'
          ELSE IF(SYMB2(1:2).EQ.'SE'.AND.NBOND1.EQ.2) THEN
            L1B_TYPE(I) = 'single'
          ENDIF
        ENDIF
      ENDDO
C
      DO   I=1,L1B_NBOND
        IF(L1B_TYPE(I).EQ.'.'.OR.L1B_TYPE(I)(1:3).EQ.'cov') GOTO 100
      ENDDO
      RETURN
C
C---We have not finished yet.
 100  CONTINUE
C
C--Define sp2 atoms. L1A_ICHIR(I) = -1
      DO   IA=1,L1A_NATOM
        L1A_ICHIR(IA) = 0
        SYMB  = L1A_SYMB(IA)
        NBOND = L1A_NDIST(IA)
        IF(SYMB(1:2).EQ.'C ') THEN
          IF(NBOND.EQ.3) THEN
            L1A_ICHIR(IA) = -1
          ENDIF
        ELSEIF(SYMB(1:2).EQ.'N ') THEN
          IF(NBOND.EQ.3.OR.NBOND.EQ.2) THEN
            L1A_ICHIR(IA) = -1
          ENDIF
        ELSEIF(SYMB(1:2).EQ.'B ') THEN
          IF(NBOND.EQ.3) THEN
            L1A_ICHIR(IA) = -1
          ENDIF
        ELSE

        ENDIF
      ENDDO
             
C
C---Go through rings and define if they are aromatic
C---Find number of rings
      NRING_ALL = 0
      DO  IA=1,L1A_NATOM
        DO   IR=1,L1A_NRING(IA)
          IF(NRING_ALL.LT.L1A_RING_ID(IR,IA)) 
     &             NRING_ALL=L1A_RING_ID(IR,IA)
        ENDDO
      ENDDO
C
C---Go through all rings
      IF(NRING_ALL.GT.0) THEN
        DO   IR=1,NRING_ALL
          IRING_FLAG = 0
          DO   IA=1,L1A_NATOM
            IF(L1A_NRING(IA).GT.0) THEN
              DO  IR1=1,L1A_NRING(IA)
                IF(L1A_RING_ID(IR1,IA).EQ.IR) THEN
                  IF(L1A_ICHIR(IA).NE.-1) THEN
                    IRING_FLAG = 1
                    GOTO 200
                  ENDIF
                ENDIF
              ENDDO
            ENDIF
          ENDDO
C
c--It is flat ring. all bonds inside this ring are aromatic
          DO   IB=1,L1B_NBOND
            IA1 = L1B_I1ATM(IB)
            IA2 = L1B_I2ATM(IB)
            IF(L1A_NRING(IA1).GT.0.AND.L1A_NRING(IA2).GT.0) THEN
              DO   IR1=1,L1A_NRING(IA1)
                IF(L1A_RING_ID(IR1,IA1).EQ.IR) THEN
                  DO  IR2=1,L1A_NRING(IA2)
                    IF(L1A_RING_ID(IR2,IA2).EQ.IR) THEN
C
C--atoms are from the same ring and  ring is flat then nond is aromatic
                      IF(L1B_TYPE(IB).NE.'.'.AND.
     &                   L1B_TYPE(IB)(1:3).NE.'cov')THEN
                        L1B_TYPE(IB) = 'aromatic'
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF
              ENDDO
            ENDIF
          ENDDO
 200      CONTINUE
        ENDDO
      ENDIF
C
      DO   I=1,L1B_NBOND
        IF(L1B_TYPE(I)(1:1).EQ.'.'.OR.L1B_TYPE(I)(1:2).EQ.'co') GOTO 300
      ENDDO
      GOTO 500
 300  CONTINUE
C
c---If still have not decided then if N or in some other cases we can make
C---decisions
C

C---Go through bonds
      DO   IB=1,L1B_NBOND
        IF(L1B_TYPE(IB)(1:1).EQ.'.'.OR.L1B_TYPE(IB)(1:3).EQ.'cov') THEN
C
C--Look atoms which make this bond and count their defined bonds
          IA1 = L1B_I1ATM(IB)
          IA2 = L1B_I2ATM(IB)
C
C---If atom would be aromatic decison could have been made already. It is
C---not
          IF(L1A_SYMB(IA1)(1:2).EQ.'N ') THEN
            IF(L1A_NDIST(IA1).GE.3) THEN
              L1B_TYPE(IB) = 'single'
C
c---Goto the next bond
              GOTO 400
            ENDIF
          ENDIF
          IF(L1A_SYMB(IA2)(1:2).EQ.'N ') THEN
            IF(L1A_NDIST(IA2).GE.3) THEN
              L1B_TYPE(IB) = 'single'
C
c---Goto the next bond
              GOTO 400
            ENDIF
          ENDIF
        ENDIF
 400    CONTINUE
      ENDDO

cd      DO   I=1,L1B_NBOND
cd        IF(L1B_TYPE(I).EQ.'.'.OR.L1B_TYPE(I)(1:3).EQ.'cov') GOTO 300
cd      ENDDO
 500  CONTINUE
C ---
      RETURN
      END
C
      LOGICAL FUNCTION IS_IT_METAL(SYMB)
C
c--
      IMPLICIT NONE
      INCLUDE 'metal.fh'
      CHARACTER SYMB*(*)
C
      INTEGER I
C
      DO I=1,N_NAME
        IF(SYMB(1:2).EQ.NAME(I)(1:2)) THEN
          IS_IT_METAL = .TRUE.
          RETURN
        ENDIF
      ENDDO
      IS_IT_METAL = .FALSE.
      RETURN
      END

      SUBROUTINE USE_VALENCY(MDOC,LIST,IERR)
      IMPLICIT NONE
C --------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LIST*1
C ---
      REAL ANBO
      INTEGER NBO
      REAL    OXIDATION 
      INCLUDE 'lib_com.fh'
      CHARACTER LINE*256
      CHARACTER BTYPE*8,ANAME*4,ASYMB*4,ANAME_H*4,CH1*1,CH4*4
      CHARACTER ATOM_BONDS(20)*4
      INTEGER IA,ND,NBOND_ATOM,IB,NA,NNH,IDD,ID,LB,NH_ADD,LAN,IH,
     &        LLL,J,K,N_DUBL
      REAL    VAL
C ---------------------------------------------
      IF(LIST.EQ.'T') THEN
        write(LINE,*) '---use valency --'
        CALL MSGERR(MDOC,LINE)
        IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
        WRITE(LINE,'(I4,'' bond '',A4,'' - '',A4,'' :'',2F8.3,2I3,A)')
     *    IB,L1B_1ATM(IB),L1B_2ATM(IB),L1B_VAL(IB),L1B_VOBS(IB)
     *    ,L1B_I1ATM(IB),L1B_I2ATM(IB),L1B_TYPE(IB)
          CALL MSGDOC(MDOC,LINE)
        ENDDO 
        ENDIF
      ENDIF

      CALL CHECK_OXYGENS_BOND(MDOC,LIST,IERR)
      NA  = L1A_NATOM
      NNH = L1A_NHATOM
C
C---Oxygens have to be treated using routine ???
      DO IA=1,L1A_NATOM
        NBO        = 0
        ANBO       = 0.0
        NBOND_ATOM = 0
        OXIDATION  = L1A_CHARG(IA)
        ND         = L1A_NDIST(IA)
        ASYMB      = L1A_SYMB(IA)
        ANAME      = L1A_ANAME(IA)

        IF(ND.GT.0.AND.
     *     (ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ')) THEN
          DO IDD=1,ND
            ID = L1A_CONN(IDD,IA)
            IF(ID.LT.0) ID = -ID
            CALL SRCH_BOND(MDOC,L1L_MNAME,IA,ID,VAL,LB,IERR)
            IF(IERR.EQ.0.AND.LB.GT.0) THEN
              BTYPE = L1B_TYPE(LB)
              IF(BTYPE(1:4).EQ.'sing') THEN
                ANBO       = ANBO + 1.0
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'sing'
              ELSE IF(BTYPE(1:4).EQ.'doub') THEN
                ANBO       = ANBO + 2.0
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'doub'

              ELSE IF(BTYPE(1:4).EQ.'trip') THEN
                ANBO       = ANBO + 3.0
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'trip'

              ELSE IF(BTYPE(1:4).EQ.'arom') THEN
                ANBO       = ANBO + 1.5 
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'arom'

              ELSE IF(BTYPE(1:4).EQ.'delo') THEN
                ANBO       = ANBO + 1.5
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'delo'
              ELSE IF(BTYPE(1:4).EQ.'cova') THEN
                ANBO       = ANBO + 1.0
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'cova'
              ELSE IF(BTYPE(1:4).EQ.'meta') THEN
                ANBO       = ANBO + 1.0
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'meta'
              ELSE IF(BTYPE(1:4).EQ.'dumm') THEN
C               dummy bond
              ELSE
                WRITE(LINE,'(A)')'Warning: Unrecognised bond type.'
     &              //' Assumed single'
                ANBO       = ANBO + 1.0
                NBOND_ATOM = NBOND_ATOM + 1
                ATOM_BONDS(NBOND_ATOM) = 'sing'
              ENDIF
            ELSE
              IERR = 0
              GO TO 100
            ENDIF
          ENDDO
          NBO   = NINT(ANBO+0.1)
          ASYMB = L1A_SYMB(IA)

          CALL FIND_HYDR_TYPE(MDOC,NBO,ANBO,NBOND_ATOM,OXIDATION,
     &                      NH_ADD,ASYMB,ATOM_BONDS)


          IF(LIST.EQ.'T') THEN
            WRITE(LINE,'('' ia,asym,nd,nbo,val:'',i3,a,3i4)')
     *      IA,ASYMB,ND,NBO,OXIDATION
            CALL MSGDOC(MDOC,LINE)
          ENDIF

          IF(NH_ADD.LE.0) GO TO 100

          CALL LENSTR_BL(ANAME,LAN)
          IF(ASYMB(1:1).EQ.'C ') THEN
            IF(LAN.LE.1) THEN
              ANAME_H = 'H'
              LAN = 1
            ELSE
              IF(LAN.GT.4) LAN = 4
              ANAME_H = 'H'//ANAME(2:LAN)
C             LAN     = LAN + 1
            ENDIF
          ELSE  
            IF(LAN.GT.3) LAN = 3
            ANAME_H = 'H'//ANAME(1:LAN)
            LAN     = LAN + 1
          ENDIF

C  ????   unique name ?       
          N_DUBL = 0

          DO IH=1,NH_ADD

            IF(NA.GE.MAX1ATM) THEN
              WRITE(LINE
     *        ,'('' ERROR : number of atoms of monomer >'',I6)') 
     *        MAX1ATM
              CALL MSGERR(MDOC,LINE)
              CALL MSGERR(MDOC
     *        ,'         Change parameter MAX1ATM in "lib_com.fh"')
              IERR=1
              RETURN
            ENDIF

            NA  = NA + 1
            NNH = NNH + 1

            L1A_COOR_FLAG(NA) = 'N'
            L1A_X    (NA) = 0.0
            L1A_Y    (NA) = 0.0
            L1A_Z    (NA) = 0.0
            L1A_CHARG(NA) = 0.0
            L1A_INEW (NA) = NA
            L1A_IOLD (NA) = NA
            L1A_ICR  (NA) = 0
            L1A_ICHIR(NA) = 0
            L1A_IBACK(NA) = 0
            L1A_IFORW(NA) = 0
            L1A_BACK (NA) = '.'
            L1A_TYPE (NA) = '.' 
            L1A_FORW (NA) = '.'
            LLL           = LAN
            IF(NH_ADD.GT.1) THEN
              WRITE(CH1,'(I1)') IH
              LLL = LAN + 1
              IF(LLL.GT.4) LLL = 4
              ANAME_H(LLL:LLL) = CH1
            ENDIF

            DO K=1,NA-1
              IF(ANAME_H.EQ.L1A_ANAME(K)) THEN
                N_DUBL = N_DUBL + 1
                WRITE(CH4,'(I4)') N_DUBL
                IF(CH4(2:2).EQ.' ') CH4(2:2) = '_' 
                IF(CH4(3:3).EQ.' ') CH4(3:3) = '_' 
                ANAME_H = 'H'//CH4(2:4)
              ENDIF           
            ENDDO

            CALL LENSTR_BL(ANAME_H,LLL)
            L1A_ANAME(NA) = ANAME_H(1:LLL)       

            L1A_CHEM (NA) = 'H   '
            L1A_SYMB (NA) = 'H   '

            L1A_ATYPE(NA) = 'H'

            L1A_NDIST(NA) = 1
            L1A_CONN   (1,NA) = IA
            L1A_LENCON (1,NA) = 0

            L1A_NDIST(IA) = L1A_NDIST(IA) + 1 
            L1A_CONN (L1A_NDIST(IA),IA) = NA
            L1A_LENCON (1,IA) = L1A_LENCON (1,IA) + 1

            L1A_NEXTR(NA) = 0
            DO  J=1,MAX1EXT 
              L1A_IEXTR (J,NA)  = 0
            ENDDO
            L1A_LENGTH(NA) = 0.0
            L1A_THETA (NA) = 0.0
            L1A_PHI   (NA) = 0.0
            L1A_ID_PSI(NA) = '.'

            L1A_RING_ID  (1,NA) = 0
            L1A_RING_ORD (1,NA) = 0
            L1A_RING_FLAT(1,NA) = 0

            IF(L1B_NBOND.LT.MAX1BND) THEN
              L1B_NBOND             = L1B_NBOND+1
              L1B_I1ATM (L1B_NBOND) = IA
              L1B_1ATM  (L1B_NBOND) = L1A_ANAME(IA)
              L1B_I2ATM (L1B_NBOND) = NA
              L1B_2ATM  (L1B_NBOND) = L1A_ANAME(NA)
              L1B_VAL   (L1B_NBOND) = 0.98
              L1B_VOBS  (L1B_NBOND) = 0.0
              L1B_TYPE  (L1B_NBOND) = 'single'
              L1B_EVAL  (L1B_NBOND) = 0.0
              L1B_DEV   (L1B_NBOND) = 0.02
            ENDIF
          ENDDO
        ENDIF
 100    CONTINUE
      ENDDO
C----
      IF(LIST.EQ.'T') THEN
        write(LINE,*) '---after use valency --'
        CALL MSGERR(MDOC,LINE)
        IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
        WRITE(LINE,'(I4,'' bond '',A4,'' - '',A4,'' :'',2F8.3,2I3,A)')
     *    IB,L1B_1ATM(IB),L1B_2ATM(IB),L1B_VAL(IB),L1B_VOBS(IB)
     *    ,L1B_I1ATM(IB),L1B_I2ATM(IB),L1B_TYPE(IB)
          CALL MSGDOC(MDOC,LINE)
        ENDDO 
        ENDIF
      ENDIF

      L1A_NATOM  = NA
      L1A_NHATOM = NNH
      L1L_NATM   = L1A_NATOM
      L1L_NHATM  = L1A_NHATOM
      RETURN
      END
C
      SUBROUTINE FIND_HYDR_TYPE(MDOC,NBOND,ANBOND,
     &           NBOND_ATOM,OXIDATION,N_MISSING,ASYMB,ATOM_BONDS)

      IMPLICIT NONE
C
C---Finds number of missing hydrogens. Uses oxidation state
C---number of atoms bound already, number of bonds.      
      INTEGER MDOC,NBOND,NBOND_ATOM,N_OXIDATION,N_MISSING
      REAL    ANBOND,OXIDATION
      CHARACTER ASYMB*(*),LINE*256
C
      INTEGER IATOM,IVALENCY
      CHARACTER ATOM_BONDS(20)*(*)
C
C---Loop over possible atoms
      N_MISSING = 0
      IF(ASYMB.EQ.'LI') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'BE') THEN
        N_MISSING = INT(2.0 - (ANBOND-OXIDATION)+0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'B ') THEN
        N_MISSING = INT(3.0 - (ANBOND - OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.3) N_MISSING = 3
cd        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'C ') THEN
        N_MISSING = INT(4.0-(ANBOND-OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4
        IF((NBOND_ATOM+N_MISSING).GT.4) THEN
          N_MISSING = 4 - NBOND_ATOM
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'N ') THEN
        N_MISSING = INT(3.0-(ANBOND-OXIDATION)+0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.3) N_MISSING = 3
        IF((NBOND_ATOM+N_MISSING).GT.4) THEN
          N_MISSING = 4 - NBOND_ATOM
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'O ') THEN
        N_MISSING = INT(2.0-(ANBOND-OXIDATION)+0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.2) N_MISSING = 2
        IF((NBOND_ATOM+N_MISSING).GT.2) THEN
          N_MISSING = 2 - NBOND_ATOM
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'F ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'NE') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'NA') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'MG') THEN
        N_MISSING = INT(2.0 - (ANBOND - OXIDATION)+0.2)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.2) N_MISSING = 2

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'AL') THEN
        N_MISSING = INT(3.0 - (ANBOND-OXIDATION)+0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.3) N_MISSING = 3

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'SI') THEN
        N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4
        IF((NBOND_ATOM+N_MISSING).GT.4) THEN
          N_MISSING = 4 - NBOND_ATOM
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'P ') THEN
        IF(NBOND.LE.3) THEN
          N_MISSING = INT(3.0 - (ANBOND-OXIDATION)+0.25)
        ELSE
          N_MISSING = INT(5.0- (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF((NBOND_ATOM+N_MISSING).GT.4) THEN
          N_MISSING = 4 - NBOND_ATOM
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'S ') THEN
        IF(NBOND.LE.2) THEN
          N_MISSING = INT(2.0 - (ANBOND-OXIDATION) + 0.25)
        ELSEIF(NBOND.LE.4) THEN
          N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(6.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4
        IF((NBOND_ATOM+N_MISSING).GT.4) THEN
          N_MISSING = 4 - NBOND_ATOM
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'CL') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'AR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'K ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CA') THEN
        N_MISSING = INT(2.0 - (ANBOND-OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.2) N_MISSING = 2

        N_MISSING = 0


      ELSE IF(ASYMB(1:2).EQ.'SC') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TI') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'V ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'MN') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'FE') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CO') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'NI') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CU') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'ZN') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'GA') THEN
        N_MISSING = INT(3.0 - (ANBOND-OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.3) N_MISSING = 3

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'GE') THEN
        IF(NBOND.LE.2) THEN
          N_MISSING = INT(2.0 - (ANBOND-OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'AS') THEN
        IF(NBOND.LE.3) THEN
          N_MISSING = INT(3.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(5.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'SE') THEN
        IF(NBOND.LE.2) THEN
          N_MISSING = INT(2.0 - (ANBOND - OXIDATION) + 0.25)
        ELSEIF(NBOND.LE.4) THEN
          N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(6.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4
        IF((NBOND_ATOM+N_MISSING).GT.4) THEN
          N_MISSING = 4 - NBOND_ATOM 
          IF(N_MISSING.LT.0) N_MISSING = 0
        ENDIF
      ELSE IF(ASYMB(1:2).EQ.'BR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'KR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'RB') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'SR') THEN
        N_MISSING = INT(2.0 - (ANBOND-OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.2) N_MISSING = 2

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'Y ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'ZR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'NB') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'MO') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TC') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'RU') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'RH') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PD') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'AG') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CD') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'IN') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'SN') THEN
        IF(NBOND.LE.2) THEN
          N_MISSING = INT(2.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'SB') THEN
        IF(NBOND.LE.3) THEN
          N_MISSING = INT(3.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(5.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'TE') THEN
        IF(NBOND.LE.2) THEN
          N_MISSING = INT(2.0 - (ANBOND - OXIDATION) + 0.25)
        ELSEIF(NBOND.LE.4) THEN
          N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(6.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'I ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'XE') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CS') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'BA') THEN
        N_MISSING = INT(2.0 - (ANBOND-OXIDATION) + 0.25)
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.2) N_MISSING = 2

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'LA') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CE') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'ND') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PM') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'SM') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'EU') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'GD') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TB') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'DY') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'HO') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'ER') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TM') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'YB') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'LU') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'HF') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TA') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'W ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'RE') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'OS') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'IR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PT') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'AU') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'HG') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TL') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PB') THEN
        IF(NBOND.LE.2) THEN
          N_MISSING = INT(2.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(4.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.4) N_MISSING = 4

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'BI') THEN
        IF(NBOND.LE.3) THEN
          N_MISSING = INT(3.0 - (ANBOND - OXIDATION) + 0.25)
        ELSE
          N_MISSING = INT(5.0 - (ANBOND - OXIDATION) + 0.25)
        ENDIF
        IF(N_MISSING.LT.0) N_MISSING = 0
        IF(N_MISSING.GT.5) N_MISSING = 5

        N_MISSING = 0

      ELSE IF(ASYMB(1:2).EQ.'PO') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'AT') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'RN') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'FR') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'RA') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'AC') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'TH') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PA') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'U ') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'NP') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'PU') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'AM') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CM') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'BK') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'CF') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'ES') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'FM') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'MD') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'NO') THEN
        N_MISSING = 0
      ELSE IF(ASYMB(1:2).EQ.'LR') THEN
        N_MISSING = 0
      ELSE
        LINE = 'WARNING: Unrecognised atom name: '//ASYMB
        CALL MSGDOC(MDOC,LINE)
      ENDIF
      RETURN
      END

C
      SUBROUTINE CHECK_CHEM_DD_MIN(MDOC,LIST,IERR)
      IMPLICIT NONE
C -----------------------------------------
C -P- CHECK_CHEM -
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LIST*1
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C -----------------------------------------
      INTEGER NA,I,NBOND,N_OXIDATION,N_HATOM,IR1,IRING5,IRING6,
     &        IRING_THIS,ICONN_H,IR,IRING_FLAG,NBOND_OXI,J,
     &        NRING_ALL,IA,IA3
      INTEGER LB,IRING_FLAT1
      INTEGER IOXIG,IB,IA_OX(8)
      REAL    VAL
      CHARACTER LINE*256,SYMB*4,NAME*4,CHEM*4
      LOGICAL  IS_IT_METAL
      EXTERNAL IS_IT_METAL
C -----------------------------------------
      IERR = 0
      NA   = L1A_NATOM

      IF(LIST.EQ.'T') THEN
        call msgdoc(mdoc,'---check_chem_dd_min---')
        call msgdoc(mdoc,'aname/symb/chem/nbond/nhatom/iback/iforw')
      ENDIF

      DO I=1,NA

cd        L1A_SP_HYBR(I) = 4
C --
        NBOND       = L1A_NDIST(I)
C       number of connections with H-atoms
        N_HATOM     = L1A_LENCON(1,I)
        N_OXIDATION = L1A_CHARG(I)
C       element name
        SYMB        = L1A_SYMB(I)
C       ring-5:  
C               IRING5 >  0 flat 
C               IRING5 > 10 flat ring-55 
C               IRING5 <  0 not flat 
        IRING5      = L1A_IBACK(I)
C       ring-6:  
C               IRING6 >  0 flat 
C               IRING6 > 10 flat ring-66 
C               IRING6 <  0 not flat 
        IRING6      = L1A_IFORW(I)
C       only for H-atom:  
C          ICONN_H defines connection for H-atom
        ICONN_H     = ABS(L1A_CONN(1,I))
C          if(abs(ICONN_H)) > 0
C          connection with: L1A_SYMB(ICONN_H)
C --
        IF(LIST.EQ.'T') THEN
          write(line,'(i5,a,a,a,a,a,a,a,4i5)') 
     *    i,'/',L1A_ANAME(I),'/',L1A_SYMB(I),'/',L1A_CHEM(I),'/'
     *    ,NBOND,N_HATOM,L1A_IBACK(I),L1A_IFORW(I)
          call msgdoc(mdoc,line) 
        ENDIF
        NBOND_OXI = NBOND-N_OXIDATION
        IF(NBOND.GT.0) THEN
          IF(SYMB(1:2).EQ.'LI') THEN
C
C---Group 1 elements
            L1A_CHEM(I) = 'LI'

C
C---Group 2 elements


C
C---Group 3 elements
          ELSE IF(SYMB(1:2).EQ.'B ') THEN
             L1A_CHEM(I) = 'B   '
C
C---Group 4 elements
          ELSE IF(SYMB(1:2).EQ.'C ') THEN
C
C---Carbon. 
            IF(NBOND.EQ.4) THEN
C
c--Take care of the formal charge.
C
C---sp3 carbon
              L1A_ICHIR(I) = 0
              IF(N_HATOM.EQ.0) THEN
                L1A_CHEM(I) = 'CT  '
                L1A_ICHIR(I) = 1
              ELSEIF(N_HATOM.EQ.1) THEN
                 L1A_CHEM(I) = 'CH1 '
                 L1A_ICHIR(I) = 1
              ELSEIF(N_HATOM.EQ.2) THEN
                L1A_CHEM(I) = 'CH2 '
              ELSEIF(N_HATOM.EQ.3) THEN
                L1A_CHEM(I) = 'CH3 '
              ELSEIF(N_HATOM.EQ.4) THEN
C
C--This seems to be wrong. or methane
              ELSEIF(N_HATOM.EQ.4) THEN
                L1A_CHEM(I) = 'CH3 '
              ELSE
                
C
C--Wrong number of hydrogens
              ENDIF
            ELSEIF(NBOND.EQ.3) THEN
C
C--sp2 carbon. In this case chirality will be removed.
C
C--Save for future use
              L1A_ICHIR(I) = -1
              IF(N_HATOM.EQ.0) THEN
                L1A_CHEM(I) = 'C   '
              ELSEIF(N_HATOM.EQ.1) THEN
                L1A_CHEM(I) = 'C1  '
              ELSEIF(N_HATOM.EQ.2) THEN
                L1A_CHEM(I) = 'C2  '
              ELSE
C
C--Error
                IERR = 1
              ENDIF
            ELSEIF(NBOND.EQ.2) THEN
C
C--sp1 carbon
              L1A_ICHIR(I) = 0
              IF(N_HATOM.EQ.0) THEN
                L1A_CHEM(I) = 'CSP '
              ELSEIF(N_HATOM.EQ.1) THEN
                L1A_CHEM(I) = 'CSP1'
              ELSE
C
C---Error
                IERR = 1
              ENDIF
            ELSE
C
C---Wrong number of bonds on carbon
            ENDIF
          ELSE IF(SYMB(1:2).EQ.'SI') THEN
C
C---Most SI are tetragonal (according to csd. But there are hexagonal
C---SI also.
            L1A_ICHIR(I) = 1
            IF(NBOND.EQ.4) THEN
              L1A_CHEM(I) = 'SI  '
            ELSE
              L1A_CHEM(I) = 'SI1 '
            ENDIF
          ELSE IF(SYMB(1:2).EQ.'GE') THEN
            L1A_ICHIR(I) = 1
            IF(NBOND.EQ.4) THEN
              L1A_CHEM(I) = 'GE  '
            ELSE
              L1A_CHEM(I) = 'GE1 '
            ENDIF

          ELSE IF(SYMB(1:2).EQ.'SN') THEN
C
c---SN has various forms. 
             L1A_CHEM(I)  = 'SN  '
             L1A_ICHIR(I) = 0

          ELSE IF(SYMB(1:2).EQ.'PB') THEN
C
C--Same problem
             L1A_CHEM(I)  = 'PB  '
             L1A_ICHIR(I) = 0
C
C--Group 5 elements
          ELSE IF(SYMB(1:2).EQ.'N ') THEN
            IF(NBOND.EQ.4) THEN
C
C---Definitely sp3
              L1A_ICHIR(I) = 1
              IF(N_HATOM.EQ.0) THEN
                L1A_CHEM(I) = 'NT  '
              ELSE IF(N_HATOM.EQ.1) THEN
                L1A_CHEM(I) = 'NT1 '
              ELSE IF(N_HATOM.EQ.2) THEN
                L1A_CHEM(I) = 'NT2 '
                L1A_ICHIR(I) = 0
              ELSE IF(N_HATOM.EQ.3) THEN
                L1A_CHEM(I) = 'NT3 '
                L1A_ICHIR(I) = 0
              ELSE IF(N_HATOM.EQ.4) THEN
C
C--NH4(+1) assign NT
                L1A_CHEM(I) = 'NT  '
                L1A_ICHIR(I) = 0
              ELSE
C
C---Error
              ENDIF
            ELSE IF(NBOND.EQ.3) THEN
C
C---Could be sp2 or sp3. Could be sp3 if bonds are longer.
              IF(L1A_ICHIR(I).EQ.2) THEN
C
C---Too much reliance on coordinates. How to define sp3 N when 
C---there are no coordinates?????
                IF(N_HATOM.EQ.0) THEN
                  L1A_CHEM(I) = 'NT  '
                ELSE IF(N_HATOM.EQ.1) THEN
                  L1A_CHEM(I) = 'NT1 '
                ELSE IF(N_HATOM.EQ.2) THEN
                  L1A_CHEM(I) = 'NT2 '
                ELSE IF(N_HATOM.EQ.3) THEN
C
C---NH3 unlikely. but consider as NT3
                L1A_CHEM(I) = 'NT3 '

                ENDIF

              ELSE
C
C---SP2. Same problem as above
                L1A_ICHIR(I) = -1
                IF(N_HATOM.EQ.0) THEN
                  L1A_CHEM(I) = 'N   '
                ELSE IF(N_HATOM.EQ.1) THEN
                  L1A_CHEM(I) = 'NH1 '
                ELSE IF(N_HATOM.EQ.2) THEN
                  L1A_CHEM(I) = 'NH2 '
                ELSE IF(N_HATOM.EQ.3) THEN
C
C---NH3 unlikely. but consider as N
                  L1A_CHEM(I) = 'N   '
                ELSE
C
C---Error
                ENDIF          
              ENDIF
C
C--sp2 define and save for the future use
            ELSE IF(NBOND.EQ.2) THEN
              L1A_ICHIR(I) = -1
              IF(N_HATOM.EQ.0) THEN
                L1A_CHEM(I) = 'N   '
              ELSE IF(N_HATOM.EQ.1) THEN
                L1A_CHEM(I) = 'N   '
              ELSE
C
C---Error
              ENDIF
            ELSE IF(NBOND.EQ.1) THEN
C
C---sp1
              L1A_ICHIR(I) = 0
              IF(N_HATOM.EQ.0) THEN
                L1A_CHEM(I) = 'NS  '
              ELSE
C
C---Error
              ENDIF
C
C---Error
            ENDIF
          ELSE IF(SYMB(1:2).EQ.'P ') THEN
C
c--Most P are tetragonal
             L1A_ICHIR(I) = 1
             IF(NBOND.EQ.4) THEN
               L1A_CHEM(I) = 'P   '
             ELSE
               L1A_CHEM(I) = 'P1  ' 
             ENDIF
             IF(NBOND.NE.3) L1A_ICHIR(I) = 0
          ELSE IF(SYMB(1:2).EQ.'AS') THEN
C
             L1A_ICHIR(I) = 0
             IF(NBOND.EQ.4) THEN
               L1A_CHEM(I) = 'AS  '
             ELSE
               L1A_CHEM(I) = 'AS1 '
             ENDIF
          ELSE IF(SYMB(1:2).EQ.'SB') THEN
C
C---Very different
             L1A_CHEM(I) = 'SB  '
          ELSE IF(SYMB(1:2).EQ.'BI') THEN
             L1A_CHEM(I) = 'BI  '
C
C---Group 6 elements
             
          ELSE IF(SYMB(1:2).EQ.'O ') THEN
C
C--Here we should check bonded atom and its environment
            IF(NBOND.EQ.2) THEN
              IF(N_HATOM.EQ.1) THEN
                L1A_CHEM(I) = 'OH1 '
              ELSEIF(N_HATOM.EQ.0) THEN
                IF(NBOND.EQ.2) THEN
                  L1A_CHEM(I) = 'O2  '
                ELSE
C
C--Go and look bound atom if it has another O change its type also.
                ENDIF
              ENDIF
            ELSE IF(NBOND.EQ.1) THEN
C
c--This case will have to be revisited below.
              L1A_CHEM(I) = 'O   '

           ELSE
C---Error
           ENDIF          
C
C----Error
          ELSE IF(SYMB(1:2).EQ.'S ') THEN
C
C---With I have to do a little bit more. But perhaps later.
            IF(NBOND.EQ.4) THEN
              L1A_CHEM(I) = 'ST  '
            ELSEIF(NBOND.EQ.3) THEN
              L1A_CHEM(I) = 'S3  '
            ELSE IF(NBOND.EQ.2) THEN
              L1A_CHEM(I) = 'S2  '
              IF(N_HATOM.EQ.1) L1A_CHEM(I) = 'SH1 '
            ELSE IF(NBOND.EQ.1) THEN
              L1A_CHEM(I) = 'S1  '
            ENDIF
          ELSE IF(SYMB(1:2).EQ.'SE') THEN
            L1A_CHEM(I) = 'SE  '
            IF(NBOND.EQ.4) L1A_ICHIR(I) = 1
          ELSEIF(SYMB(1:2).EQ.'TE') THEN
            L1A_CHEM(I) = 'TE  '
          ELSEIF(SYMB(1:2).EQ.'PO') THEN
            L1A_CHEM(I) = 'PO  '
     
          ELSEIF(SYMB(1:2).EQ.'B ') THEN
C

            IF(NBOND.EQ.4) THEN

            ENDIF

          ELSEIF(SYMB(1:2).EQ.'H '.OR.SYMB(1:2).EQ.'D ') THEN
C
C---Not more than one bond.
            L1A_CHEM(I) = 'H   '
          ELSE
            L1A_CHEM(I) = SYMB
          ENDIF
        ENDIF

        IF(L1A_CHEM(I).EQ.'.') L1A_CHEM(I) = L1A_SYMB(I)
C       check with table 
        NAME = L1A_CHEM(I)
        DO J=1,LEA_NATOM
          IF(LEA_ANAME(J).EQ.NAME) THEN
            GO TO 140
          ENDIF  
        ENDDO
        IF(LES_NSYN.GT.0) THEN
          DO J=1,LES_NSYN
            IF(LES_STYP(J).EQ.NAME) THEN
              L1A_CHEM(I) = LES_ATYP(J)
              GO TO 140
            ENDIF  
          ENDDO
        ENDIF

        IF(L1A_CHEM(I)(1:1).NE.'H') THEN
          LINE = ' WARNING: '// L1L_MNAME//
     *    ' : unknown chemical_type of atom '//L1A_ANAME(I)//
     *    ' - "'//L1A_CHEM(I) //'"'
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *    '(''                default type is - "'',A4,''"'')')
     *      NAME
          CALL MSGERR(MDOC,LINE)
        ENDIF
        L1A_CHEM(I)  = L1A_SYMB(I)
        NAME         = L1A_CHEM(I)
        DO J=1,LEA_NATOM
          IF(LEA_ANAME(J).EQ.NAME) THEN
            GO TO 140
          ENDIF  
        ENDDO
        IF(LES_NSYN.GT.0) THEN
          DO J=1,LES_NSYN
            IF(LES_STYP(J).EQ.NAME) THEN
              L1A_CHEM(I) = LES_ATYP(J)
              GO TO 140
            ENDIF  
          ENDDO
        ENDIF
  140   CONTINUE

      ENDDO
C
C---Now loop over rings and see if they are flat
C
C--Find number of rings
      NRING_ALL = 0
      DO   I=1,L1A_NATOM
        IF(L1A_NRING(I).GT.0) THEN
          DO   IR=1,L1A_NRING(I)
            IF(NRING_ALL.LT.L1A_RING_ID(IR,I))
     &             NRING_ALL = L1A_RING_ID(IR,I)
          ENDDO
        ENDIF
      ENDDO
      IF(NRING_ALL.GT.0) THEN
        DO   IR=1,NRING_ALL
          IRING_FLAG = 0
          DO  IA=1,L1A_NATOM
            IF(L1A_NRING(IA).GT.0) THEN
C
C--If at least two of the atoms is not sp2 ring is not flat
              DO  IR1=1,L1A_NRING(IA)
                IF(L1A_RING_ID(IR1,IA).EQ.IR) THEN

C --- 23.03.03
                  IF(IS_IT_METAL(L1A_SYMB(IA))) THEN
                    IRING_FLAG = 2
                    GOTO 10  
                  ENDIF
C ---
                  IF(L1A_ICHIR(IA).NE.-1) THEN
                    IRING_FLAG = IRING_FLAG + 1
C A-VA --???        GOTO 10
                  ENDIF
                ENDIF
              ENDDO
            ENDIF
          ENDDO
 10       CONTINUE
C
C---If IRING_FLAG > 1 then ring is not flat. go and correct all ring id
          DO   IA=1,L1A_NATOM
            IF(L1A_NRING(IA).GT.0) THEN
              DO  IR1=1,L1A_NRING(IA)
              IF(L1A_RING_ID(IR1,IA).EQ.IR) THEN
                IF(IRING_FLAG.EQ.0) THEN
                  L1A_RING_FLAT(IR1,IA) = 1
                ELSE IF(IRING_FLAG.EQ.1) THEN
C A-VA ????       L1A_RING_FLAT(IR1,IA) = 2
                  L1A_RING_FLAT(IR1,IA) = 1
                ELSE
                  L1A_RING_FLAT(IR1,IA) = 0
                ENDIF
              ENDIF
              ENDDO
            ENDIF
          ENDDO
        ENDDO
      ENDIF
C
C--Now go through atoms and define their atomic types using 
C--ring info also.
      DO   I=1,L1A_NATOM
C
C---Can be flat ring if atom is sp2.
          IF(L1A_ICHIR(I).EQ.-1) THEN
            IF(L1A_NRING(I).GT.0) THEN
              IRING_THIS = 0
              CHEM = L1A_CHEM(I)
              DO   IR=1,L1A_NRING(I)
                IRING_FLAT1 = L1A_RING_FLAT(IR,I)
                IF(L1A_RING_FLAT(IR,I).EQ.1) THEN
                  IF(L1A_RING_ORD(IR,I).EQ.5) THEN
C
c--Only N and C are considered. How about S?
                     IF(CHEM.EQ.'C   ') THEN
                       IF(IRING_THIS.EQ.5) THEN
                         L1A_CHEM(I) = 'CR55'
                       ELSE IF(IRING_THIS.EQ.6) THEN
                         L1A_CHEM(I) = 'CR56'
                       ELSE
                         L1A_CHEM(I) = 'CR5 '
                       ENDIF
                     ELSE IF(CHEM.EQ.'C1  ') THEN
                       L1A_CHEM(I) = 'CR15'
                     ELSE IF(CHEM.EQ.'C2  ') THEN
C
C---Impossible
                     ELSE IF(CHEM.EQ.'N   ') THEN
                       IF(IRING_THIS.EQ.5) THEN
                         L1A_CHEM(I) = 'NR55'
                       ELSE IF(IRING_THIS.EQ.6) THEN
                         L1A_CHEM(I) = 'NR56'
                       ELSE
                         L1A_CHEM(I) = 'NRD5'
                         IF(L1A_NDIST(I).EQ.3) L1A_CHEM(I) = 'NR5 '
                       ENDIF
                     ELSE IF(CHEM.EQ.'NH1 ') THEN
                       L1A_CHEM(I) = 'NR15'
                     ELSE IF(CHEM.EQ.'NH2 ') THEN
C
C---Impossible
                     ENDIF
                     IRING_THIS = 5
                  ELSEIF(L1A_RING_ORD(IR,I).EQ.6) THEN
C
c--Only N and C are considered. How about S?
                     IF(CHEM.EQ.'C   ') THEN
                       IF(IRING_THIS.EQ.5) THEN
                         L1A_CHEM(I) = 'CR56'
                       ELSE IF(IRING_THIS.EQ.6) THEN
                         L1A_CHEM(I) = 'CR66'
                       ELSE
                         L1A_CHEM(I) = 'CR6 '
                       ENDIF
                     ELSE IF(CHEM.EQ.'C1  ') THEN
                       L1A_CHEM(I) = 'CR16'
                     ELSE IF(CHEM.EQ.'C2  ') THEN
C
C---Impossible
                     ELSE IF(CHEM.EQ.'N   ') THEN
                       IF(IRING_THIS.EQ.5) THEN
                         L1A_CHEM(I) = 'NR56'
                       ELSE IF(IRING_THIS.EQ.6) THEN
                         L1A_CHEM(I) = 'NR66'
                       ELSE
                         L1A_CHEM(I) = 'NRD6'
                         IF(L1A_NDIST(I).EQ.3) L1A_CHEM(I) = 'NR6 '
                       ENDIF
                     ELSE IF(CHEM.EQ.'NH1 ') THEN
                       L1A_CHEM(I) = 'NR16'
                     ELSE IF(CHEM.EQ.'NH2 ') THEN
C
C---Impossible
                     ENDIF
                     IRING_THIS = 6
                  ENDIF
                ENDIF
              ENDDO
            ENDIF
          ENDIF
C
C---Now correct for N
        IF(L1A_SYMB(I)(1:2).EQ.'N ') THEN
          IF(L1A_NDIST(I).EQ.2.OR.L1A_NDIST(I).EQ.1) THEN
            DO   IB=1,L1A_NDIST(I)
              IA3 = L1A_CONN(IB,I)
              IF(IA3.LT.0) IA3 = -IA3
              IF(IA3.GT.0) THEN
                CALL SRCH_BOND(MDOC,L1L_MNAME,I,IA3,VAL,LB,IERR)
                IF(L1B_TYPE(LB)(1:3).EQ.'tri')  L1A_CHEM(I) = 'NS  '
              ENDIF
            ENDDO
          ENDIF
        ENDIF
C
C--Now correct for oxygens.
        IF(L1A_SYMB(I)(1:2).EQ.'C '.AND.L1A_ICHIR(I).EQ.-1) THEN
          IOXIG  = 0
          DO   IB=1,L1A_NDIST(I)
            IA3 = L1A_CONN(IB,I)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IA3.GT.0) THEN
              IF(L1A_SYMB(IA3).EQ.'O '.AND.L1A_NDIST(IA3).EQ.1) THEN
                IOXIG = IOXIG + 1
                IA_OX(IOXIG) = IA3
              ENDIF
            ENDIF
          ENDDO
          IF(IOXIG.EQ.2) THEN
            L1A_CHEM(IA_OX(1)) = 'OC  '
            L1A_CHEM(IA_OX(2)) = 'OC  '
          ENDIF
        ELSEIF(L1A_SYMB(I)(1:2).EQ.'S ') THEN
          IOXIG  = 0
          DO   IB=1,L1A_NDIST(I)
            IA3 = L1A_CONN(IB,I)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IA3.GT.0) THEN
              IF(L1A_SYMB(IA3).EQ.'O '.AND.L1A_NDIST(IA3).EQ.1) THEN
                IOXIG = IOXIG + 1
                IA_OX(IOXIG) = IA3
              ENDIF
            ENDIF
          ENDDO
          IF(IOXIG.GE.2) THEN
            DO J=1,IOXIG
              L1A_CHEM(IA_OX(J)) = 'OS  '
            ENDDO
          ENDIF
        ELSEIF(L1A_SYMB(I)(1:2).EQ.'P ') THEN
          IOXIG  = 0
          DO   IB=1,L1A_NDIST(I) 
            IA3 = L1A_CONN(IB,I)
            IF(IA3.LT.0) IA3 = -IA3
            IF(IA3.GT.0) THEN
              IF(L1A_SYMB(IA3).EQ.'O '.AND.L1A_NDIST(IA3).EQ.1) THEN
                IOXIG = IOXIG + 1
                IA_OX(IOXIG) = IA3
              ENDIF
            ENDIF
          ENDDO
          IF(IOXIG.GE.2) THEN
            DO J=1,IOXIG
              L1A_CHEM(IA_OX(J)) = 'OP  '
            ENDDO
          ENDIF
        ENDIF
      ENDDO
      RETURN
      END

C --- Garib ---

      SUBROUTINE CHECK_CHIR(MDOC,LIST,ITYPE_RES,IERR)
C -------------------------------------------------
C     CHIRALITY OR PLAN
C
C -------------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LIST*1
      LOGICAL  IS_IT_METAL
      EXTERNAL IS_IT_METAL
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------
      INTEGER*4 IJA(3),IJHA(3),NNH,NHA,I,J,IJ,NA,IC,I1,I2,I3,NCOMM
      CHARACTER LINE*256,SYMB*4,CH2*2
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C ----------------------------------------------------
      IERR =  0
C ----------------
      NA     = L1A_NATOM

      IF(NA.GT.3) THEN

        CALL REMOVE_USER_CHIR_CENTRE(MDOC,LIST,IERR)

        DO   I=1,NA
          IF(L1A_NDIST(I).GE.2.AND.L1A_ATYPE(I).NE.'H') THEN
            IF(IS_IT_METAL(L1A_SYMB(I))) GO TO 600
            NNH=0
            NHA=0
            DO IJ=1,3
              IJA (IJ) = 0
              IJHA(IJ) = 0
            ENDDO
            DO J=1,L1A_NDIST(I)
              IJ = ABS(L1A_CONN(J,I))
              IF(L1A_ATYPE(IJ).NE.'H') THEN
                NNH = NNH + 1
                IF(NNH.LE.3) IJA(NNH) = IJ
              ELSE
                NHA = NHA + 1
                IF(NHA.LE.3) IJHA(NHA) = IJ
              ENDIF
            ENDDO 

            IF(L1A_ICHIR(I).LT.0.AND.NNH.LE.2.AND.NNH.GT.0) THEN
              IF(NHA.GT.0) THEN
                NNH      = NNH + 1
                IJA(NNH) = IJHA(1)
                IF(NHA.GT.1.AND.NNH.LT.3) THEN
                  NNH      = NNH + 1
                  IJA(NNH) = IJHA(2)
                ENDIF
              ENDIF
            ENDIF
 
            I1 = IJA(1)
            I2 = IJA(2)
            I3 = IJA(3)

            IF(LIST.EQ.'T') THEN
              WRITE(line,'(A,I5,A,5I5)') 
     *        'cc:',I,L1A_ANAME(I),L1A_ICHIR(I),NNH,I1,I2,I3
              call msgdoc(mdoc,line)
            ENDIF

            IF(L1A_ICHIR(I).LT.0.AND.NNH.GE.2) THEN
C               planar groups
                IF(L1P_NPLAN.GT.0) THEN
                  DO IP=1,L1P_NPLAN
                    NAP   = L1P_NATOM(IP)
                    NCOMM = 0
                    DO IAP=1,NAP
                      ICH4 = L1P_ATOM(IAP,IP) 
                      IF(CH4.EQ.L1A_ANAME( I).OR.
     *                   CH4.EQ.L1A_ANAME(I1).OR.
     *                   CH4.EQ.L1A_ANAME(I2)    ) THEN
                        NCOMM = NCOMM + 1
                      ELSE IF(I3.GT.0) THEN 
                        IF(CH4.EQ.L1A_ANAME(I3)) NCOMM = NCOMM + 1
                      ENDIF     
                    ENDDO
                    IF(NCOMM.GE.3) GO TO 600
C                   IF(NCOMM.GE.4) GO TO 600
                  ENDDO
                ENDIF

                IF(L1P_NPLAN.GE.MAX1PLN) THEN
                  WRITE(LINE,
     *'(''ERROR: number of plan groups in new monomer '',A,'' >'',I6)'
     *) L1L_MNAME,MAX1PLN
                  CALL MSGERR(MDOC,LINE)
                  CALL MSGERR(MDOC,
     *  '          Change parameter MAX1PLN in "lib_com.fh"')
                  IERR=1
                  RETURN
                ENDIF

                IF(I1.GT.0.AND.I2.GT.0) THEN
                  L1P_NPLAN              = L1P_NPLAN + 1
                  L1A_ICHEM(I)           = L1P_NPLAN              
                  L1P_NATOM(L1P_NPLAN)   = 3
                  L1P_IATOM(1,L1P_NPLAN) = I
                  CH4                    = L1A_ANAME(I)
                  L1P_ATOM (1,L1P_NPLAN) = ICH4
                  L1P_IATOM(2,L1P_NPLAN) = I1
                  CH4                    = L1A_ANAME(I1)
                  L1P_ATOM (2,L1P_NPLAN) = ICH4
                  L1P_IATOM(3,L1P_NPLAN) = I2
                  CH4                    = L1A_ANAME(I2)
                  L1P_ATOM (3,L1P_NPLAN) = ICH4
                  IF(I3.GT.0) THEN
                    L1P_NATOM(L1P_NPLAN)   = 4
                    L1P_IATOM(4,L1P_NPLAN) = I3
                    CH4                    = L1A_ANAME(I3)
                    L1P_ATOM (4,L1P_NPLAN) = ICH4
                  ELSE
                    L1P_IATOM(4,L1P_NPLAN) = 0
                    L1P_ATOM (4,L1P_NPLAN) = 0
                  ENDIF
                  WRITE(CH2,'(I2)') L1P_NPLAN              
                  IF(CH2(1:1).EQ.' ') THEN
                    L1P_LABEL(L1P_NPLAN)='plan-'//CH2(2:2)
                  ELSE
                    L1P_LABEL(L1P_NPLAN)='plan-'//CH2
                  ENDIF

                  L1P_DOBS(1,L1P_NPLAN) = 0.0
                  L1P_DEV (1,L1P_NPLAN) = 0.02
                ENDIF

            ELSE IF(L1A_ICHIR(I).GT.0.AND.NNH.GE.3) THEN
C               chiral centres 

                IF(NNH.GE.3) THEN
                  IF(L1C_NCHIR.GT.0) THEN
                    DO IC=1,L1C_NCHIR
                      IF(L1C_1ATM(IC).EQ.L1A_ANAME(I)) GO TO 600 
                    ENDDO
                  ENDIF
                  IF(L1C_NCHIR.GE.MAX1CHR) THEN
                    WRITE(LINE,
     *'(''ERROR: number of chiral centres in monomer '',A,'' >'',I6)'
     *) L1L_MNAME,MAX1CHR
                    CALL MSGERR(MDOC,LINE)
                    CALL MSGERR(MDOC,
     *  '          Change parameter MAX1CHR in "lib_com.fh"')
                    IERR=1
                    RETURN
                  ENDIF
                  CALL SRCH_CHIR_CENTRE(MDOC,L1L_MNAME,I,LC,IERR)
                  IF(I1.GT.0.AND.I2.GT.0.AND.I3.GT.0.AND.LC.LE.0) THEN
                    L1C_NCHIR   = L1C_NCHIR + 1
                    L1A_ICHEM(I)= - L1C_NCHIR         
                    L1C_I1ATM(L1C_NCHIR) = I
                    L1C_1ATM (L1C_NCHIR) = L1A_ANAME(I)
                    L1C_I2ATM(L1C_NCHIR) = I1
                    L1C_2ATM (L1C_NCHIR) = L1A_ANAME(I1)
                    L1C_I3ATM(L1C_NCHIR) = I2
                    L1C_3ATM (L1C_NCHIR) = L1A_ANAME(I2)
                    L1C_I4ATM(L1C_NCHIR) = I3
                    L1C_4ATM (L1C_NCHIR) = L1A_ANAME(I3)
                    L1C_I5ATM(L1C_NCHIR) = 0
                    L1C_5ATM (L1C_NCHIR) = '.'
                    L1C_I6ATM(L1C_NCHIR) = 0
                    L1C_6ATM (L1C_NCHIR) = '.'
                    L1C_I7ATM(L1C_NCHIR) = 0
                    L1C_7ATM (L1C_NCHIR) = '.'
                    L1C_I8ATM(L1C_NCHIR) = 0
                    L1C_8ATM (L1C_NCHIR) = '.'
                    L1C_I9ATM(L1C_NCHIR) = 0
                    L1C_9ATM (L1C_NCHIR) = '.'
                    L1C_VOL  (L1C_NCHIR) = 0.0
                    L1C_VOBS (L1C_NCHIR) = 0.0

c                   IF(L1L_PRSNT.EQ.'N'.AND.
                    IF(L1A_COOR_FLAG(I ).EQ.'Y'.AND.
     *                 L1A_COOR_FLAG(I1).EQ.'Y'.AND. 
     *                 L1A_COOR_FLAG(I2).EQ.'Y'.AND. 
     *                 L1A_COOR_FLAG(I3).EQ.'Y'     ) THEN
                      X1 = L1A_X(I)
                      Y1 = L1A_Y(I)
                      Z1 = L1A_Z(I)
                      X2 = L1A_X(I1)
                      Y2 = L1A_Y(I1)
                      Z2 = L1A_Z(I1)
                      X3 = L1A_X(I2)
                      Y3 = L1A_Y(I2)
                      Z3 = L1A_Z(I2)
                      X4 = L1A_X(I3)
                      Y4 = L1A_Y(I3)
                      Z4 = L1A_Z(I3)
                      A1 = X2-X1
                      A4 = Y2-Y1
                      A7 = Z2-Z1
                      A2 = X3-X1
                      A5 = Y3-Y1
                      A8 = Z3-Z1
                      A3 = X4-X1
                      A6 = Y4-Y1
                      A9 = Z4-Z1
                      VOL = A1*(A5*A9 - A8*A6)
     *                     -A4*(A2*A9 - A8*A3)
     *                     +A7*(A2*A6 - A5*A3)
                      IF(VOL.LT.0.0) THEN
                        L1C_SIGN(L1C_NCHIR) = 'negativ'
                        L1C_FLAG(L1C_NCHIR) = 'L'
                      ELSE
                        L1C_SIGN(L1C_NCHIR) = 'positiv'
                        L1C_FLAG(L1C_NCHIR) = 'R'
                      ENDIF
                    ELSE 
                      L1C_SIGN(L1C_NCHIR) = 'both   '
                      L1C_FLAG(L1C_NCHIR) = 'B'
                      IF(L1C_1ATM(L1C_NCHIR).EQ.'CA  '.AND.
     *                  (ITYPE_RES.EQ.3.OR.ITYPE_RES.EQ.4)) THEN
                        CALL PEPTIDE_CHIR_CORR(MDOC,LIST,ITYPE_RES,
     *                  L1C_2ATM(L1C_NCHIR),L1C_3ATM(L1C_NCHIR),
     *                  L1C_4ATM(L1C_NCHIR),L1C_SIGN(L1C_NCHIR),
     *                  L1C_FLAG(L1C_NCHIR),IERR)
                      ENDIF
                    ENDIF
                  ENDIF
                ENDIF

            ENDIF

 600        CONTINUE

          ENDIF
        ENDDO
      ENDIF

      RETURN
      END

      SUBROUTINE PEPTIDE_CHIR_CORR(MDOC,LIST,ITYPE_RES,
     *       ATOM1,ATOM2,ATOM3,SIGN,FLAG,IERR)
C -----------------------------------------
      INTEGER   MDOC,IERR,ITYPE_RES
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4,SIGN*8,FLAG*1
      CHARACTER LINE*256,LIST*1
C -----------------------------------------
C     CA --> N  CB  C  neg L-pept
      IT = 0
      IF(ATOM1.EQ.'N   ') THEN
        IF(ATOM2.EQ.'C   ') THEN
          IF(ATOM3.EQ.'CB  ') IT =-1
        ELSE IF(ATOM2.EQ.'CB  ') THEN
          IF(ATOM3.EQ.'C   ') IT = 1
        ENDIF
      ELSE IF(ATOM1.EQ.'C   ') THEN
        IF(ATOM2.EQ.'CB  ') THEN
          IF(ATOM3.EQ.'N   ') IT =-1
        ELSE IF(ATOM2.EQ.'N   ') THEN
          IF(ATOM3.EQ.'CB  ') IT = 1
        ENDIF
      ELSE IF(ATOM1.EQ.'CB  ') THEN
        IF(ATOM2.EQ.'N   ') THEN
          IF(ATOM3.EQ.'C   ') IT =-1
        ELSE IF(ATOM2.EQ.'C   ') THEN
          IF(ATOM3.EQ.'N   ') IT = 1
        ENDIF
      ENDIF
      
      IF(IT.EQ.0) RETURN
      IF(ITYPE_RES.EQ.3) IT =-IT

      IF(IT.LT.0) THEN
        SIGN = 'negativ'
        FLAG = 'L'
      ELSE
        SIGN = 'positiv'
        FLAG = 'R'
      ENDIF

      RETURN
      END

      SUBROUTINE CHECK_PLAN(MDOC,NRING,LIST,IERR)
C -----------------------------------------
C -P- CHECK_PLAN -
C -S-
C -----------------------------------------
      INTEGER   MDOC,IERR,NRING
C ---
      INCLUDE 'lib_com.fh'
C ******
      LOGICAL  IS_IT_METAL
      EXTERNAL IS_IT_METAL
      CHARACTER LINE*256,LIST*1
      INTEGER   NA,IP,IAP,I,J,IA,NP,N,NCONN,ICONN,JCONN,JA,IFLAT,JFLAT
      INTEGER*4 ICH4,IAC,KI,NAI,KJ,NAJ,IR,IFLAT_SAME,IB,LB
      CHARACTER CH2*2,CH4*4,SYMB*4,BTYPE*8
      EQUIVALENCE (ICH4,CH4)
C -----------------------------------------
C     L1A_ICHIR() : > 0 chir, < 0 flat, 0 non-flat
C
      NA = L1A_NATOM

C --- define l1a_icr() - number of flat ring 
      DO IA=1,NA
        L1A_ICR(IA) = 0
      ENDDO
      IF(NRING.GT.0) THEN      
        DO J=1,NRING
          DO IA=1,NA
            IF(L1A_NRING(IA).GT.0) THEN
              DO IR=1,L1A_NRING(IA)
                IF(L1A_RING_ID  (IR,IA).EQ.J.AND.
     *             L1A_RING_FLAT(IR,IA).GT.0     ) THEN
                  L1A_ICR(IA) = J
                ENDIF
              ENDDO
            ENDIF
          ENDDO
        ENDDO
      ENDIF
C ---

      IF(LIST.EQ.'T') THEN
      IF(L1P_NPLAN.GT.0) THEN
         call msgdoc(mdoc,'ip,iap,icr,ichir(<0 flat,>0 chir')
        DO IP=1,L1P_NPLAN
          NAP = L1P_NATOM(IP)
          IF(NAP.GT.0) THEN
            DO IAP=1,NAP
              j=L1P_IATOM(IAP,IP)              
               WRITE(line,'(A,4I5,A)') 
     *        'plan-;',ip,iap,L1A_ICR(j),L1A_ICHIR(j),l1a_aname(j)
              call msgdoc(mdoc,line)
            ENDDO
          ENDIF
        ENDDO
      ENDIF
      ENDIF


      IF(L1P_NPLAN.GT.0.AND.NRING.GT.0) THEN
        DO I=1,L1P_NPLAN

          DO J=1,NRING

            NP = 0
            DO IA=1,NA
              IF(L1A_ICR(IA).EQ.J) THEN
                DO IP=1,L1P_NATOM(I)
                  IF(L1P_IATOM(IP,I).EQ.IA) THEN
                    NP = NP+1
                  ENDIF
                ENDDO  
              ENDIF
            ENDDO
C
C           NP -number of atoms (from i-plan) in j-ring(flat)            
C
C          

c           IF(NP.GT.2) THEN
            IF(NP.GE.2) THEN
              DO IA=1,NA
                IF(L1A_ICR(IA).EQ.J.AND.L1A_ICR(IA).NE.0) THEN
                  IF(L1P_IATOM(1,I).NE.IA.AND.
     *               L1P_IATOM(2,I).NE.IA.AND.
     *               L1P_IATOM(3,I).NE.IA.AND.
     *               L1P_IATOM(4,I).NE.IA     ) THEN
                    IF(L1P_NATOM(I).GE.MAX1APL) THEN
                      WRITE(LINE,'(3A,I6)')
     *    ' ERROR: number of atoms in planar group of new monomer'
     *                ,L1L_MNAME,' >',MAX1APL
                      CALL MSGERR(MDOC,LINE)
                    CALL MSGERR(MDOC,
     *  '          Change parameter MAX1APL in "lib_com.fh"')
                      IERR=1
                      RETURN
                    ENDIF
                
C                    IF(L1A_SYMB(IA).NE.'FE  ') THEN
c                    IF(IS_IT_METAL(L1A_SYMB(IA))) THEN

                    L1P_NATOM(I)              = L1P_NATOM(I) + 1
                    L1P_IATOM(L1P_NATOM(I),I) = IA
                    CH4                       = L1A_ANAME(IA)
                    L1P_ATOM (L1P_NATOM(I),I) = ICH4
                    L1P_DOBS (L1P_NATOM(I),I) = 0.0
                    L1P_DEV  (L1P_NATOM(I),I) = 0.02
                    
C                    ENDIF

                  ENDIF
                  L1A_ICR(IA) = 0
                ENDIF
              ENDDO
            ENDIF
  
          ENDDO
        ENDDO
      ENDIF

      IF(LIST.EQ.'T') THEN
      IF(L1P_NPLAN.GT.0) THEN
        DO IP=1,L1P_NPLAN
          NAP = L1P_NATOM(IP)
          IF(NAP.GT.0) THEN
            DO IAP=1,NAP
              j=L1P_IATOM(IAP,IP)
              WRITE(line,*) 'plan=;',ip,iap,L1A_ICR(j),l1a_aname(j)
              call msgdoc(mdoc,line)
            ENDDO
          ENDIF
        ENDDO
      ENDIF
      ENDIF



      IF(NRING.GT.0) THEN
        DO J=1,NRING
          IFIRST = 0
          DO IA=1,NA
C///
            L1A_ICR(IA) = 0
            IF(L1A_NRING(IA).GT.0) THEN
              DO IR=1,L1A_NRING(IA)
                IF(L1A_RING_ID  (IR,IA).EQ.J.AND.
     *             L1A_RING_FLAT(IR,IA).GT.0     ) THEN
                  L1A_ICR(IA) = J
                ENDIF
              ENDDO
            ENDIF
C///
            IF(L1A_ICR(IA).EQ.J) THEN
              IF(IFIRST.EQ.0) THEN
                IF(L1P_NPLAN.GE.MAX1PLN) THEN
                  WRITE(LINE,'(3A,I6)')
     *         ' ERROR: number of planar groups in new monomer'
     *            ,L1L_MNAME,' >',MAX1PLN
                  CALL MSGERR(MDOC,LINE)
                    CALL MSGERR(MDOC,
     *  '          Change parameter MAX1PLN in "lib_com.fh"')
                  IERR=1
                  RETURN
                ENDIF
                L1P_NPLAN            = L1P_NPLAN + 1
                L1P_NATOM(L1P_NPLAN) = 0
                WRITE(CH2,'(I2)') L1P_NPLAN              
                IF(CH2(1:1).EQ.' ') THEN
                  L1P_LABEL(L1P_NPLAN) = 'plan-'//CH2(2:2)
                ELSE
                  L1P_LABEL(L1P_NPLAN) = 'plan-'//CH2
                ENDIF
                IFIRST = 1
              ENDIF

              IF(L1P_NATOM(L1P_NPLAN).GE.MAX1APL) THEN
                WRITE(LINE,'(3A,I6)')
     *    ' ERROR: number of atoms in planar group of new monomer'
     *            ,L1L_MNAME,' >',MAX1APL
                CALL MSGERR(MDOC,LINE)
                    CALL MSGERR(MDOC,
     *  '          Change parameter MAX1APL in "lib_com.fh"')
                IERR=1
                RETURN
              ENDIF

C              IF(L1A_SYMB(IA).NE.'FE  '.AND.L1A_SYMB(IA).NE.'H   '
C     *                       .AND.L1A_SYMB(IA).NE.'D   ') THEN
              IF(L1A_SYMB(IA).NE.'H   '.AND.L1A_SYMB(IA).NE.'D   ') THEN
               
                IF(L1P_NATOM(L1P_NPLAN).GT.0) THEN
                  DO JAP=1,L1P_NATOM(L1P_NPLAN)
                    JA = L1P_IATOM(JAP,L1P_NPLAN)
                    IF(JA.EQ.IA) GO TO 300
                  ENDDO
                ENDIF

                L1P_NATOM(L1P_NPLAN)     = L1P_NATOM(L1P_NPLAN) + 1
                IAP                      = L1P_NATOM(L1P_NPLAN)
                L1P_IATOM(IAP,L1P_NPLAN) = IA
                CH4                      = L1A_ANAME(IA)
                L1P_ATOM (IAP,L1P_NPLAN) = ICH4
                L1P_DOBS(IAP,L1P_NPLAN)  = 0.0
                L1P_DEV (IAP,L1P_NPLAN)  = 0.02

 300            CONTINUE

                L1A_ICR(IA)             = 0

C                IF(L1A_NDIST(IA).EQ.3.OR.
C     *                (L1A_NDIST(IA).EQ.2.AND.L1A_ICHIR(IA).LT.0)) THEN
                IF(L1A_NDIST(IA).EQ.3.OR.
     *                (L1A_NDIST(IA).EQ.2.AND.L1A_ICR(IA).GT.0)) THEN

                  DO ID=1,L1A_NDIST(IA)
                    I = ABS(L1A_CONN(ID,IA)) 
C                    IF(L1A_ICR(I).LE.0.AND.I.GT.0.AND.
C     *                 L1A_SYMB(I).NE.'FE  '.AND.L1A_SYMB(I).NE.'H   '
C     *                       .AND.L1A_SYMB(I).NE.'D   ') THEN
                    IF(I.GT.0) THEN
                    IF(L1A_ICR (I).LE.0     .AND.
     *                 L1A_SYMB(I).NE.'H   '.AND.
     *                 L1A_SYMB(I).NE.'D   '     ) THEN

                      IF(L1P_NATOM(L1P_NPLAN).GT.0) THEN
                        DO JAP=1,L1P_NATOM(L1P_NPLAN)
                          JA = L1P_IATOM(JAP,L1P_NPLAN)
                          IF(JA.EQ.IA) GO TO 200
                        ENDDO
                      ENDIF

                      L1P_NATOM(L1P_NPLAN)    = L1P_NATOM(L1P_NPLAN)+1
                      IAP                     = L1P_NATOM(L1P_NPLAN)
                      L1P_IATOM(IAP,L1P_NPLAN)= I
                      CH4                     = L1A_ANAME(I)
                      L1P_ATOM (IAP,L1P_NPLAN)= ICH4
                      L1P_DOBS(IAP,L1P_NPLAN) = 0.0
                      L1P_DEV (IAP,L1P_NPLAN) = 0.02

 200                  CONTINUE
                      
                    ENDIF
                    ENDIF
                  ENDDO
                ENDIF
              ENDIF
              
            ENDIF
          ENDDO
        ENDDO
      ENDIF

C --- define l1a_icr() - number of flat ring 

      DO IA=1,NA
        L1A_ICR(IA) = 0
      ENDDO
      IF(NRING.GT.0) THEN      
        DO J=1,NRING
          DO IA=1,NA
            IF(L1A_NRING(IA).GT.0) THEN
              DO IR=1,L1A_NRING(IA)
                IF(L1A_RING_ID  (IR,IA).EQ.J.AND.
     *             L1A_RING_FLAT(IR,IA).GT.0     ) THEN
                  L1A_ICR(IA) = J
                ENDIF
              ENDDO
            ENDIF
          ENDDO
        ENDDO
      ENDIF
C ---
      IF(LIST.EQ.'T') THEN
      IF(L1P_NPLAN.GT.0) THEN
        DO IP=1,L1P_NPLAN
          NAP = L1P_NATOM(IP)
          IF(NAP.GT.0) THEN
            DO IAP=1,NAP
              j=L1P_IATOM(IAP,IP)
              WRITE(line,*) 'plan==;',ip,iap,L1A_ICR(j),l1a_aname(j)
     *                       ,L1P_DOBS(iap,ip)
              call msgdoc(mdoc,line)
            ENDDO
          ENDIF
        ENDDO
      ENDIF
      ENDIF
C ---
      IF(L1P_NPLAN.GT.1) THEN
        NP = L1P_NPLAN
        DO I=1,NP-1
          NAI = L1P_NATOM(I)
          IF(NAI.GT.0) THEN
            DO J=I+1,NP
              NAJ = L1P_NATOM(J)

              IF(NAJ.GT.0) THEN
                N     = 0
                ICONN = 0
                JCONN = 0
                DO KJ=1,NAJ
                  JA   = L1P_IATOM(KJ,J)
                  DO KI=1,NAI
                    IA   = L1P_IATOM(KI,I)

                    IF(L1P_ATOM(KJ,J).EQ.L1P_ATOM(KI,I)) THEN
                      L1P_DOBS(KJ,J)   =-1.0
                      N                = N + 1
                      IF(N.EQ.1) ICONN = JA
                      IF(N.EQ.2) JCONN = JA
                    ENDIF

                  ENDDO
                ENDDO

                IF(LIST.EQ.'T') THEN
                  WRITE(line,'(A,3I5)') 
     *            '---i,j,n;',i,j,n
                  call msgdoc(mdoc,line)
                ENDIF

                IF(N.GE.3) THEN
                  N = 3
                ELSE IF(N.EQ.2) THEN

C                  IFLAT  = 0  
c                  IF(L1A_ICHIR(ICONN).LT.0) IFLAT = 1
C                  IF(L1A_ICR(ICONN).GT.0) IFLAT = 1
C                  JFLAT  = 0  
c                  IF(L1A_ICHIR(JCONN).LT.0) JFLAT = 1
C                  IF(L1A_ICR(JCONN).GT.0) JFLAT = 1

                  CALL CHECK_PLAN_CONNECTION(LIST,ICONN,JCONN,IFLAT)

                  N = 0

                  CALL SRCH_BOND(MDOC,L1L_MNAME,ICONN,JCONN,VAL,LB,IERR)
                  KERR = IERR
                  IF(IERR.EQ.0.AND.LB.GT.0) THEN                
                    BTYPE = L1B_TYPE(LB)
                    IF(BTYPE(1:4).EQ.'sing'.OR.BTYPE(1:4).EQ.'cova'.OR.
     *                 BTYPE(1:1).EQ.'.') THEN
                      IB = 1

                      IF(IFLAT.GT.0) IB = 2 
                      
                    ELSE
                      IB = 2

                      IF(IFLAT.LT.0) IB = 1 

                    ENDIF
                  ELSE
                    IERR = 0
                    IB   = 1
                  ENDIF
                  IF(IB.GE.2) N = 3

                  IF(LIST.EQ.'T') THEN
                    WRITE(line,'(A,2I5,a,a,4i5)') 
     *              '---ia,ja,n,ib;',ICONN,JCONN,
     *              L1A_ANAME(Iconn),L1A_ANAME(jconn),N,IB,IFLAT,KERR
                    call msgdoc(mdoc,line)
                  ENDIF

                ENDIF

                IF(N.GE.3) THEN
                  DO KJ=1,NAJ
                    IF(L1P_DOBS(KJ,J).GE.0.0) THEN
                      NAI = NAI+1
                      IF(NAI.GT.MAX1APL) THEN
                        WRITE(LINE,'(3A,I6)')
     *    ' ERROR: number of atoms in planar group of new monomer'
     *            ,L1L_MNAME,' >',MAX1APL
                        CALL MSGERR(MDOC,LINE)
                        CALL MSGERR(MDOC,
     *  '          Change parameter MAX1APL in "lib_com.fh"')
                        IERR=1
                        RETURN
                      ENDIF
                      L1P_ATOM (NAI,I) = L1P_ATOM (KJ,J)
                      L1P_DOBS (NAI,I) = L1P_DOBS (KJ,J)
                      L1P_IATOM(NAI,I) = L1P_IATOM(KJ,J)
                      L1P_ATOM (NAI,I) = L1P_ATOM (KJ,J)
                      L1P_NATOM(I)     = NAI
                    ENDIF
                  ENDDO
                  L1P_NATOM(J) = 0
                ELSE
                  DO KJ=1,NAJ
                    L1P_DOBS(KJ,J) = 0.0
                  ENDDO
                ENDIF
              ENDIF

            ENDDO
          ENDIF
        ENDDO

        IF(LIST.EQ.'T') THEN
        IF(L1P_NPLAN.GT.0) THEN
          DO IP=1,L1P_NPLAN
            NAP = L1P_NATOM(IP)
            IF(NAP.GT.0) THEN
              DO IAP=1,NAP
                j=L1P_IATOM(IAP,IP)
                WRITE(line,*) 'plan...;',ip,iap,l1a_aname(j)
     *                       ,L1P_DOBS(iap,ip)
                call msgdoc(mdoc,line)
              ENDDO
            ENDIF
          ENDDO
        ENDIF
        ENDIF
C ---
        NP = L1P_NPLAN
        DO I=1,NP-1
          NAI = L1P_NATOM(I)
          IF(NAI.GT.0) THEN
            DO J=I+1,NP
              NAJ = L1P_NATOM(J)
              IF(NAJ.GT.0) THEN
                N     = 0
                DO KJ=1,NAJ
                  JA   = L1P_IATOM(KJ,J)
                  DO KI=1,NAI
                    IA   = L1P_IATOM(KI,I)
                    IF(L1P_ATOM(KJ,J).EQ.L1P_ATOM(KI,I)) THEN
                      L1P_DOBS(KJ,J)   =-1.0
                      N                = N + 1
                    ENDIF
                  ENDDO
                ENDDO

                IF(LIST.EQ.'T') THEN
                  WRITE(line,'(A,3I5)') 
     *            '-=-i,j,n;',i,j,n
                  call msgdoc(mdoc,line)
                ENDIF

                IF(N.GE.3) THEN
                  DO KJ=1,NAJ
                    IF(L1P_DOBS(KJ,J).GE.0.0) THEN
                      NAI = NAI+1
                      IF(NAI.GT.MAX1APL) THEN
                        WRITE(LINE,'(3A,I6)')
     *    ' ERROR: number of atoms in planar group of new monomer'
     *            ,L1L_MNAME,' >',MAX1APL
                        CALL MSGERR(MDOC,LINE)
                        CALL MSGERR(MDOC,
     *  '          Change parameter MAX1APL in "lib_com.fh"')
                        IERR=1
                        RETURN
                      ENDIF
                      L1P_ATOM (NAI,I) = L1P_ATOM (KJ,J)
                      L1P_DOBS (NAI,I) = L1P_DOBS (KJ,J)
                      L1P_IATOM(NAI,I) = L1P_IATOM(KJ,J)
                      L1P_ATOM (NAI,I) = L1P_ATOM (KJ,J)
                      L1P_NATOM(I)     = NAI
                    ENDIF
                  ENDDO
                  L1P_NATOM(J) = 0
                ELSE
                  DO KJ=1,NAJ
                    L1P_DOBS(KJ,J) = 0.0
                  ENDDO
                ENDIF
              ENDIF

            ENDDO
          ENDIF
        ENDDO

C ---
        II = 0
        DO I=1,NP
          IF(L1P_NATOM(I).GT.0) THEN
            II            = II + 1
            L1P_NATOM(II) = L1P_NATOM(I)
C           L1P_LABEL(II) = L1P_LABEL(I)
            WRITE(CH2,'(I2)') II              
            IF(CH2(1:1).EQ.' ') THEN
              L1P_LABEL(II) = 'plan-'//CH2(2:2)
            ELSE
              L1P_LABEL(II) = 'plan-'//CH2
            ENDIF
            DO IA=1,L1P_NATOM(I)
              L1P_ATOM (IA,II) = L1P_ATOM (IA,I)
              L1P_DOBS (IA,II) = L1P_DOBS (IA,I)
              L1P_IATOM(IA,II) = L1P_IATOM(IA,I)
              L1P_ATOM (IA,II) = L1P_ATOM (IA,I)
              L1P_DEV  (IA,II) = 0.02
            ENDDO
          ENDIF
        ENDDO
        L1P_NPLAN=II
      ENDIF

      IF(LIST.EQ.'T') THEN
      IF(L1P_NPLAN.GT.0) THEN
        DO IP=1,L1P_NPLAN
          NAP = L1P_NATOM(IP)
          IF(NAP.GT.0) THEN
            DO IAP=1,NAP
              j=L1P_IATOM(IAP,IP)
              WRITE(line,*) 'plan===;',ip,iap,l1a_aname(j)     
              call msgdoc(mdoc,line)
            ENDDO
          ENDIF
        ENDDO
      ENDIF
      ENDIF

      RETURN
      END

      SUBROUTINE CHECK_PLAN_CONNECTION(LIST,IA,JA,IFLAT)
C -----------------------------------------------------
      INTEGER*4 IA,JA
      CHARACTER LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ---
C -------------------------------
      IFLAT = 0
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '-- CHECK_PLAN_CONNECTION--'
        WRITE(*,*) IA,JA,L1A_NRING(IA),L1A_NRING(JA)
      ENDIF

C     is atoms: Ia,Ja in the same ring ?

      IF(L1A_NRING(IA).GT.0.AND.L1A_NRING(JA).GT.0) THEN


        DO I=1,L1A_NRING(IA)
          ID = L1A_RING_ID(I,IA)
          DO J=1,L1A_NRING(JA)
            JD = L1A_RING_ID(J,JA)
            IF(ID.EQ.JD) THEN
              IF(L1A_RING_FLAT(I,IA).GT.0) IFLAT = 1
              IF(IFLAT.EQ.0) IFLAT = -1
            ENDIF
          ENDDO
        ENDDO

      ENDIF

      RETURN
      END

      SUBROUTINE RING(MDOC,LIST,NRINGT,IPRSNT,IERR)
C -----------------------------------------------------
      INTEGER   MDOC,IERR
      CHARACTER LINE*256,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER NDIST(MAX1ATM) 
      INTEGER IRING(MX1ATOM)
      INTEGER CONN (MAX1BRN,MAX1ATM) 
      INTEGER ICHEM(MAX1ATM)
C -------------------------------
C     IPRSNT = 1 for make_new
C     make_new: L1A_ICHEM() : > 0 plan , < 0 chir
C --------------------------------
      IERR = 0
C --
      IF(LIST.EQ.'T') THEN
        NA     = L1A_NATOM
        write(line,*) ' --- ring ---'
        CALL MSGDOC(MDOC,LINE)
        DO    IA=1,NA
          write(line,
     * '(i2,1x,a4,1x,i4,'';'',6i3,'';'',7i3)') 
     *    ia,l1a_aname(ia)
     *    ,L1A_Ichir(Ia)
     *    ,L1A_NDIST(IA),(l1a_conn(j,ia),j=1,5)
     *    ,l1a_nextr(ia),(l1a_iextr(k,ia),k=1,5),L1A_ICHEM(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
C ---
      NA     = L1A_NATOM
      NRINGT = 0
      DO I=1,NA
        ICHEM(I) = 0 
        L1A_NRING(I) = 0
        NDIST(I) = L1A_NDIST(I)
        IF(NDIST(I).GT.0) THEN
          DO J=1,NDIST(I)
            CONN(J,I) = L1A_CONN(J,I)
          ENDDO
        ENDIF
        IF(IPRSNT.EQ.0) THEN
          IF(L1A_NEXTR(I).GT.0) THEN
            DO J=1,L1A_NEXTR(I)
              K = L1A_IEXTR(J,I)
              IF(K.GT.0) THEN
                NDIST(I) = NDIST(I) + 1
                CONN(NDIST(I),I) = K
              ENDIF
            ENDDO
          ENDIF         
          IF(L1A_IBACK(I).GT.0) THEN
            NDIST(I) = NDIST(I) + 1
            CONN(NDIST(I),I) = L1A_IBACK(I)
          ENDIF 
        ELSE
          IF(L1A_ICHIR(I).GT.0.OR.L1A_ATYPE(I).EQ.'P'.OR.
     *    L1A_ATYPE(I).EQ.'P') ICHEM(I)=-1
        ENDIF     
        DO J=1,MAX1BRN
          L1A_RING_ID  (J,I) = 0
          L1A_RING_ORD (J,I) = 0
          L1A_RING_FLAT(J,I) = 0
        ENDDO
      ENDDO
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,'---------')
        DO    IA=1,NA
          write(line,
     * '(''=ia:'',i3,A,'' Ndist:'',i4,'' ;'',12i3,'';'')') 
     *    ia,l1a_aname(ia),NDIST(IA),(conn(j,ia),j=1,12)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        CALL MSGDOC(MDOC,'---------')
      ENDIF

C -------------------

      IF(NA.GE.4) THEN
        DO I=1,NA
          IRING(1) = I
          NDI = NDIST(I)
          IF(NDI.LE.0) GO TO 100

          JP = I
c         IF(L1A_NRING(I).NE.0) JP = 0

          DO I1=1,NDI
            IP1 = CONN(I1,I)
            JP1 = IP1
C           I --> IP1
            IRING(2) = IP1
            NDI1     = NDIST(IP1)
            IF(NDI1.LE.1) GO TO 101
            DO I2=1,NDI1
              IP2 = CONN(I2,IP1)
              JP2 = IP2
              IF(IP2.EQ.I) GO TO 102
C             I --> IP1 --> IP2
              IRING(3) = IP2
              NDI2     = NDIST(IP2)
              IF(NDI2.LE.1) GO TO 102
              DO I3=1,NDI2
                IP3 = CONN(I3,IP2)
                JP3 = IP3
                IF(IP3.EQ.IP1) GO TO 103
C               I --> IP1 --> IP2 --> IP3
                IF(I.EQ.IP3) THEN
C                 triangle
                  IF(JP .GT.0.AND.JP1.GT.0.AND.JP2.GT.0.AND.
     *               JP3.GT.0.AND.IPRSNT.GT.0) THEN
                    DO II=1,L1A_NDIST(I)
                      IF(L1A_CONN(II,I).EQ.IP2) THEN
C                       L1A_CONN(II,I) =-ABS(L1A_CONN(II,I)) 
                        GO TO 220
                      ENDIF
                    ENDDO
  220               CONTINUE
C                   L1A_CONN(I3,IP2) =-ABS(L1A_CONN(I3,IP2))
                  ENDIF
                  GO TO 103
                ENDIF
                IRING(4) = IP3
                NDI3     = NDIST(IP3)
                IF(NDI3.LE.1) GO TO 103
                DO I4=1,NDI3
                  IP4 = CONN(I4,IP3)
                  JP4 = IP4
                  IF(IP4.EQ.IP1.OR.IP4.EQ.IP2) GO TO 104
C                 I --> IP1 --> IP2 --> IP3 --> IP4
                  IF(I.EQ.IP4) THEN
C                   square

                    NR = 4
                    CALL IS_THERE_THIS_RING(NR,IRING
     *                                     ,NRINGT,IRING_ID) 
                    IF(IRING_ID.LE.0) THEN

c                        write(*,*) '5:',i,ip1,ip2,ip3,ip4
c                        write(*,*) ' :',jp,jp1,jp2,jp3,jp4
c                        write(*,*) ' :',iprsnt

                      IF(JP .GT.0.AND.JP1.GT.0.AND.JP2.GT.0.AND.
     *                   JP3.GT.0.AND.JP4.GT.0.AND.IPRSNT.GT.0) THEN
                        DO II=1,L1A_NDIST(I)
                          IF(L1A_CONN(II,I).EQ.IP3) THEN
                            L1A_CONN(II,I) =-ABS(L1A_CONN(II,I))
                            GO TO 230
                          ENDIF
                        ENDDO
  230                   CONTINUE
                        L1A_CONN(I4,IP3) =-ABS(L1A_CONN(I4,IP3)) 
                      ENDIF

                      NRINGT = NRINGT + 1
                      CALL ADD_THIS_RING(NR,IRING,NRINGT,ICHEM)
                    ENDIF
                    GO TO 104
                  ENDIF
                  IRING(5) = IP4
                  NDI4     = NDIST(IP4)
                  IF(NDI4.LE.1) GO TO 104
                  DO I5=1,NDI4
                    IP5 = CONN(I5,IP4)
                    JP5 = IP5
                    IF(IP5.EQ.IP1.OR.IP5.EQ.IP2.OR.IP5.EQ.IP3) GO TO 105
C                   I-->IP1-->IP2-->IP3-->IP4-->IP5
                    IF(I.EQ.IP5) THEN
                      NR = 5
                      CALL IS_THERE_THIS_RING(NR,IRING
     *                                       ,NRINGT,IRING_ID) 
                      IF(IRING_ID.LE.0) THEN

c                        write(*,*) '5:',i,ip1,ip2,ip3,ip4,ip5
c                        write(*,*) ' :',jp,jp1,jp2,jp3,jp4,jp5
c                        write(*,*) ' :',iprsnt

                        IF(JP .GT.0.AND.JP1.GT.0.AND.JP2.GT.0.AND.
     *                     JP3.GT.0.AND.JP4.GT.0.AND.JP5.GT.0.AND.
     *                     IPRSNT.GT.0) THEN
                           DO II=1,L1A_NDIST(I)
                             IF(L1A_CONN(II,I).EQ.IP4) THEN
                               L1A_CONN(II,I) =-ABS(L1A_CONN(II,I))
                               GO TO 240
                             ENDIF
                           ENDDO
  240                      CONTINUE
                           L1A_CONN(I5,IP4) =-ABS(L1A_CONN(I5,IP4)) 

c                        write(*,*) ' >',L1A_CONN(I5,IP4),i5,ip4
c                        write(*,*) ' >',L1A_CONN(ii,I)  ,ii,i

                        ENDIF

                        NRINGT = NRINGT + 1
                        CALL ADD_THIS_RING(NR,IRING,NRINGT,ICHEM)
                      ENDIF
                      GO TO 105
                    ENDIF
                    IRING(6) = IP5
                    NDI5     = NDIST(IP5)
                    IF(NDI5.LE.1) GO TO 105
                    DO I6=1,NDI5
                      IP6 = CONN(I6,IP5)
                      JP6 = IP6
                      IF(IP6.EQ.IP1.OR.IP6.EQ.IP2.OR.IP6.EQ.IP3.OR.
     *                   IP6.EQ.IP4) GO TO 106
C                         I-->IP1-->IP2-->IP3-->IP4-->IP5-->IP6
                      IF(I.EQ.IP6) THEN
                        NR = 6
                        CALL IS_THERE_THIS_RING(NR,IRING
     *                                         ,NRINGT,IRING_ID) 
                        IF(IRING_ID.LE.0) THEN

c                          write(*,*) '6:',i,ip1,ip2,ip3,ip4,ip5,ip6
c                          write(*,*) ' :',jp,jp1,jp2,jp3,jp4,jp5,jp6
c                          write(*,*) ' :',iprsnt

                          IF(JP .GT.0.AND.JP1.GT.0.AND.JP2.GT.0.AND.
     *                       JP3.GT.0.AND.JP4.GT.0.AND.JP5.GT.0.AND.
     *                       JP6.GT.0.AND.IPRSNT.GT.0) THEN
                            DO II=1,L1A_NDIST(I)
                              IF(L1A_CONN(II,I).EQ.IP5) THEN
                                L1A_CONN(II,I) =-ABS(L1A_CONN(II,I))
                                GO TO 250
                              ENDIF
                            ENDDO
  250                       CONTINUE
                            L1A_CONN(I6,IP5) =-ABS(L1A_CONN(I6,IP5)) 

c                            write(*,*) ' >',L1A_CONN(I6,IP5),ip6,ip5
c                            write(*,*) ' >',L1A_CONN(ii,I)  ,ii,i

                          ENDIF

                          NRINGT = NRINGT + 1
                          CALL ADD_THIS_RING(NR,IRING,NRINGT,ICHEM)
                        ENDIF
                        GO TO 106
                      ENDIF
C ---///
        IF(IPRSNT.GT.1.AND.NA.GE.7) THEN
          NDI6     = NDIST(IP6)
          IF(NDI6.LE.1) GO TO 106
          DO I7=1,NDI6
            JP7 = CONN(I7,IP6)
            IF(I.EQ.JP7) THEN
C             NR = 7
              IF(JP .GT.0.AND.JP1.GT.0.AND.JP2.GT.0.AND.
     *           JP3.GT.0.AND.JP4.GT.0.AND.JP5.GT.0.AND.
     *           JP6.GT.0.AND.JP7.GT.0.AND.
     *           IPRSNT.GT.0) THEN
                DO II=1,L1A_NDIST(I)
                  IF(L1A_CONN(II,I).EQ.IP6) THEN
                    L1A_CONN(II,I) =-ABS(L1A_CONN(II,I))
                    GO TO 260
                  ENDIF
                ENDDO
  260           CONTINUE
                L1A_CONN(I7,IP6) =-ABS(L1A_CONN(I7,IP6)) 
              ENDIF
              GO TO 107 
            ENDIF
            NDI7     = NDIST(JP7)
            IF(NDI7.LE.1) GO TO 107
            DO I8=1,NDI7
              JP8 = CONN(I8,JP7)
              IF(I.EQ.JP8) THEN
C               NR = 8
                IF(JP .GT.0.AND.JP1.GT.0.AND.JP2.GT.0.AND.
     *             JP3.GT.0.AND.JP4.GT.0.AND.JP5.GT.0.AND.
     *             JP6.GT.0.AND.JP7.GT.0.AND.JP8.GT.0.AND.
     *             IPRSNT.GT.0) THEN
                  DO II=1,L1A_NDIST(I)
                    IF(L1A_CONN(II,I).EQ.JP7) THEN
                      L1A_CONN(II,I) =-ABS(L1A_CONN(II,I))
                      GO TO 270
                    ENDIF
                  ENDDO
  270             CONTINUE
                  L1A_CONN(I8,JP7) =-ABS(L1A_CONN(I8,JP7)) 
                ENDIF
                GO TO 108 
              ENDIF
C ...

 108        CONTINUE
            ENDDO
 107        CONTINUE
          ENDDO
        ENDIF
C----///
C                     I-->IP1-->IP2-->IP3-->IP4-->IP5-->IP6 end
 106                  CONTINUE
                    ENDDO
C                   I-->IP1-->IP2-->IP3-->IP4-->IP5end
 105                CONTINUE
                  ENDDO
C                 I --> IP1 --> IP2 --> IP3 --> IP4 end
  104             CONTINUE
                ENDDO
C               I --> IP1 --> IP2 --> IP3 end
  103           CONTINUE
              ENDDO
C             I --> IP1 --> IP2 end
  102         CONTINUE
            ENDDO
C           I --> IP1 end
  101       CONTINUE
          ENDDO      
  100     CONTINUE
        ENDDO
      ENDIF 

C -------------------

C ---
      IF(LIST.EQ.'T') THEN
        call msgdoc(mdoc,' --- rings ---')
        WRITE(LINE,'(A,I5)') 'Nringt=',NRINGT 
        call msgdoc(mdoc,line)
        DO I=1,NA
          WRITE(LINE,'(I4,1X,A,1X,I4,3X,5(3I3,2X))') 
     *    I,l1a_aname(I),L1A_NRING(I)
     *    ,(L1A_RING_ID(J,I),L1A_RING_ORD(J,I)
     *    ,L1A_RING_FLAT(J,I),J=1,5)
          call msgdoc(mdoc,line)
        ENDDO
        call msgdoc(mdoc,' ------')
      ENDIF
C ---
      RETURN
      END     

      SUBROUTINE ADD_THIS_RING(NR,IRING,NRINGT,ICHEM)
C -----------------------------------------------------
      INTEGER MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER IRING(*)
      INTEGER ICHEM(*)
C -------------------------------
      IF(NR.LE.0) RETURN
      IFLAT = 1
      DO I=1,NR                   
        IF(ICHEM(I).LT.0) IFLAT = 0          
      ENDDO
      DO I=1,NR
        IA = IRING(I)                    
        L1A_NRING(IA) = L1A_NRING(IA) + 1
        L1A_RING_ID  (L1A_NRING(IA),IA) = NRINGT
        L1A_RING_ORD (L1A_NRING(IA),IA) = NR
        L1A_RING_FLAT(L1A_NRING(IA),IA) = IFLAT
      ENDDO
C ---
      RETURN
      END     

      SUBROUTINE IS_THERE_THIS_RING(NR,IRING,NRINGT,IRING_ID)
C -----------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER IRING(*)
      INTEGER JRING(MX1ATOM)
C -------------------------------
      IRING_ID = 0
      IF(NR.LE.2.OR.NRINGT.LE.0) RETURN

      CALL RING_SRCH(NR,IRING,NRINGT,IRING_ID)
      IF(IRING_ID.GT.0) RETURN
C ---
      IF(NR.LE.3) RETURN
      DO I=1,NR
        NNR = 0
        DO J=1,NR
          IF(I.NE.J) THEN
            NNR = NNR + 1
            JRING(NNR) = IRING(J)
          ENDIF
        ENDDO
        IF(NNR.GT.2) THEN
          CALL RING_SRCH(NNR,JRING,NRINGT,IRING_ID)
          IF(IRING_ID.GT.0) RETURN
        ENDIF
      ENDDO
C ---
      IF(NR.LE.4) RETURN
      DO I=1,NR
      DO K=1,NR
        IF(I.NE.K) THEN
          NNR = 0
          DO J=1,NR
            IF(J.NE.I.AND.J.NE.K) THEN
              NNR = NNR + 1
              JRING(NNR) = IRING(J)
            ENDIF
          ENDDO
          IF(NNR.GT.2) THEN
            CALL RING_SRCH(NNR,JRING,NRINGT,IRING_ID)
            IF(IRING_ID.GT.0) RETURN
          ENDIF
        ENDIF
      ENDDO
      ENDDO
C ---
      IF(NR.LE.5) RETURN
      DO I=1,NR
      DO K=1,NR
      DO L=1,NR
        IF(I.NE.K.AND.I.NE.L.AND.K.NE.L) THEN
          NNR = 0
          DO J=1,NR
            IF(J.NE.I.AND.J.NE.K.AND.J.NE.L) THEN
              NNR = NNR + 1
              JRING(NNR) = IRING(J)
            ENDIF
          ENDDO
          IF(NNR.GT.2) THEN
            CALL RING_SRCH(NNR,JRING,NRINGT,IRING_ID)
            IF(IRING_ID.GT.0) RETURN
          ENDIF
        ENDIF
      ENDDO
      ENDDO
      ENDDO
C ---         
      RETURN
      END     

      SUBROUTINE RING_SRCH(NR,IRING,NRINGT,IRING_ID)
C -----------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER IRING(*)
C -------------------------------
      IRING_ID = 0
      IF(NR.LE.2.OR.NRINGT.LE.0) RETURN
      DO I=1,NRINGT
        DO J=1,NR
          IA = IRING(J)
          IF(L1A_NRING(IA).LE.0) RETURN
          DO K=1,L1A_NRING(IA)
            IF(L1A_RING_ID(K,IA).EQ.I) GO TO 100
          ENDDO
          GO TO 200
 100      CONTINUE
        ENDDO
        IRING_ID = I
        RETURN  
 200    CONTINUE
      ENDDO
C ---
      RETURN
      END     

      SUBROUTINE SET_NUM(MDOC,MON,PNUM,IERR)
C -----------------------------------------------
C -P- SET_NUM - defines atom's number for atom's name.
C               check tree like sructure, extra_atoms
C               add H_atoms
C    
C        used ener_lib.cif     
C     input:
C        L1A_NATOM 
C        L1A_NHATOM 
C        L1A_COOR_FLAG()  = 'Y' or 'N'
C        L1A_X        () 
C        L1A_Y        () 
C        L1A_Z        ()
C        L1A_CHEM     ()
C        L1A_BACK     ()
C        L1A_TYPE     ()
C        L1A_FORW     ()
C        L1N_NCONN
C        L1N_1ATM     ()
C        L1N_2ATM     ()
C        L1N_TYPE     ()
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,PNUM*12
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C -------------------------------------------------------
      CHARACTER NAME*4,LINE*256
C --------------------------------------------------------
      IERR = 0
C      IF(L1A_NHATOM.EQ.L1A_NATOM) THEN
C        CALL ADD_H(MDOC,MON,IERR)
C      ENDIF
C --
      DO I=1,L1A_NATOM
        L1A_IOLD  (I) = I
        L1A_INEW  (I) = I
c       L1A_COOR_FLAG(I)='N'
        L1A_LENGTH(I) =-1.0
        L1A_THETA (I) =-1.0
        L1A_PHI   (I) = 0.0
        L1A_ID_PSI(I) = '?' 
      ENDDO
      IFLAGB = 0
      IFLAGF = 0
      IERR   = 0
C ------
      IF(L1A_NATOM.GT.1) THEN
        DO I=1,L1A_NATOM-1
          NAME = L1A_ANAME(I)
          DO J=I+1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN
              IF(PNUM(1:1).EQ.' ') THEN
                LINE = ' WARNING : '//MON//
     *                 ' : duplicated atom_name: '//L1A_ANAME(J)
              ELSE
                LINE = ' WARNING : '//MON//' '//PNUM//
     *                 ' : duplicated atom_name: '//L1A_ANAME(J)
              ENDIF
              CALL MSGERR(MDOC,LINE)
              IERR = 1
            ENDIF
          ENDDO
        ENDDO
      ENDIF
C ------

      DO I=1,L1A_NATOM
C --
        NAME = L1A_BACK(I)
        IF(NAME(1:1).NE.'.') THEN
          DO J=1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN
              L1A_IBACK(I) = J
              GO TO 100
            ENDIF
          ENDDO

C         without back atom

          L1A_IBACK(I) = 0
          IF(L1A_SYMB(I)(1:2).NE.'H '.AND.L1A_SYMB(I)(1:2).NE.'D ') THEN
            IF(PNUM(1:1).EQ.' ') THEN
              LINE = ' WARNING : '//MON//
     *             ' : back_atom for '//L1A_ANAME(I)//' is absent'
            ELSE      
              LINE = ' WARNING : '//MON//' '//PNUM//
     *             ' : back_atom for '//L1A_ANAME(I)//' is absent'
            ENDIF
            CALL MSGERR(MDOC,LINE)
            IERR = 1
          ELSE
            L1A_BACK(I) = '.'
            L1A_FORW(I) = '.'
          ENDIF
  100     CONTINUE
        ELSE     
           L1A_IBACK(I) = -1
          L1A_ISTART   = I
          IFLAGB       = IFLAGB + 1
        ENDIF
C --
        CALL LENSTR_BL(L1A_FORW(I),LEN)
        IF(LEN.LE.0) L1A_FORW(I) = '.'
        NAME = L1A_FORW(I)
        IF(NAME(1:3).EQ.'END') THEN
          L1A_IFORW(I) = -1
          L1A_IFINISH  = I
          IFLAGF       = IFLAGF + 1
        ELSE IF(NAME(1:1).NE.'.') THEN
          DO J=1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN 
              L1A_IFORW(I) = J
              IF(L1A_BACK(J).NE.L1A_ANAME(I)) THEN
                IF(PNUM(1:1).EQ.' ') THEN
                  LINE = ' WARNING : '//MON//
     * ' : atom '//L1A_ANAME(I)//' has wrong forward_atom '//NAME
                ELSE
                  LINE = ' WARNING : '//MON//' '//PNUM//
     * ' : atom '//L1A_ANAME(I)//' has wrong forward_atom '//NAME
                ENDIF 
                CALL MSGERR(MDOC,LINE)
                IERR=1
              ENDIF
              GO TO 120
            ENDIF
          ENDDO
          L1A_IFORW(I) = 0
          IF(PNUM(1:1).EQ.' ') THEN
            LINE = ' WARNING : '//MON//
     *             ' : forward_atom for '//L1A_ANAME(I)//' is absent'
          ELSE   
            LINE = ' WARNING : '//MON//' '//PNUM//
     *             ' : forward_atom for '//L1A_ANAME(I)//' is absent'
          ENDIF
          CALL MSGERR(MDOC,LINE)
          IERR = 1
  120     CONTINUE
        ELSE     
          L1A_IFORW(I) = 0
        ENDIF
C ------
        L1A_NDIST(I) = 0
        L1A_NEXTR(I) = 0
        NAME         = L1A_CHEM(I)
        DO J=1,LEA_NATOM
          IF(LEA_ANAME(J).EQ.NAME) THEN
            L1A_ICHEM(I) = J
            GO TO 140
          ENDIF  
        ENDDO
        IF(LES_NSYN.GT.0) THEN
          DO J=1,LES_NSYN
            IF(LES_STYP(J).EQ.NAME) THEN
              DO JS=1,LEA_NATOM
                IF(LEA_ANAME(JS).EQ.LES_ATYP(J)) THEN
                  L1A_CHEM(I)  = LES_ATYP(J)
                  L1A_ICHEM(I) = JS
                  GO TO 140
                ENDIF  
              ENDDO
            ENDIF  
          ENDDO
        ENDIF

C       NAME='CH1 '
        NAME = L1A_SYMB(I)
        IF(L1A_SYMB(I)(1:2).NE.'H '.AND.L1A_SYMB(I)(1:2).NE.'D ') THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : unknown chemical type of atom '//L1A_ANAME(I)//
     *           ' - '//L1A_CHEM(I)
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : unknown chemical type of atom '//L1A_ANAME(I)//
     *           ' - '//L1A_CHEM(I)
        ENDIF
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,
     *'(''                 default type is - "'',A4,''"'')')
     *      NAME
        CALL MSGERR(MDOC,LINE)
        ENDIF
        DO J=1,LEA_NATOM
          IF(LEA_ANAME(J).EQ.NAME) THEN
            L1A_ICHEM(I)=J
            GO TO 140
          ENDIF  
        ENDDO
        IF(LES_NSYN.GT.0) THEN
          DO J=1,LES_NSYN
            IF(LES_STYP(J).EQ.NAME) THEN
              DO JS=1,LEA_NATOM
                IF(LEA_ANAME(JS).EQ.LES_ATYP(J)) THEN
                  L1A_CHEM(I)  = LES_ATYP(J)
                  L1A_ICHEM(I) = JS
                  GO TO 140
                ENDIF  
              ENDDO
            ENDIF  
          ENDDO
        ENDIF
        L1A_ICHEM(I) = 1
  140   CONTINUE
      ENDDO

      IF(IFLAGB.LE.0) THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : first atom of the tree is absent'
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : first atom of the tree is absent'
        ENDIF
        CALL MSGERR(MDOC,LINE)
        IERR = 1
      ELSE IF(IFLAGB.GT.1) THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : wrong definition of first atom of the tree'
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : wrong definition of first atom of the tree'
        ENDIF
        CALL MSGERR(MDOC,LINE)
        IERR = 1
      ENDIF
      IF(IFLAGF.LE.0) THEN
        IF(PNUM(1:1).EQ.' ') THEN
          LINE = ' WARNING : '//MON//
     *           ' : last atom of the tree is absent'
        ELSE
          LINE = ' WARNING : '//MON//' '//PNUM//
     *           ' : last atom of the tree is absent'
        ENDIF
        CALL MSGERR(MDOC,LINE)
        IERR = 1
      ELSE IF(IFLAGF.GT.1) THEN
        IF(PNUM(1:1).EQ.' ') THEN
           LINE = ' WARNING : '//MON//
     *            ' : multiple definition of last atom of the tree'
        ELSE
           LINE = ' WARNING : '//MON//' '//PNUM//
     *            ' : multiple definition of last atom of the tree'
        ENDIF
        CALL MSGERR(MDOC,LINE)
        IERR = 1
      ENDIF
C -----
      IF(IERR.EQ.0) THEN
        I = L1A_IFINISH 
  700     CONTINUE
          J = L1A_IBACK(I)
          IF(J.LT.0) GO TO 710
          L1A_FORW(J)  = L1A_ANAME(I)
          L1A_IFORW(J) = I 
          I            = J
          GO TO 700
  710   CONTINUE
      ENDIF
C ---
      DO I=1,L1A_NATOM
        DO J=1,L1A_NATOM
          IF(L1A_IBACK(J).GT.0.AND.L1A_IBACK(J).EQ.I) THEN
C     *                             L1A_TYPE(J).NE.'DUMMY') THEN
            L1A_NDIST(I)               = L1A_NDIST(I) + 1
            L1A_CONN(L1A_NDIST(I),I)   = J 
            L1A_LENCON(L1A_NDIST(I),I) = 0 
          ENDIF
        ENDDO 
      ENDDO
C ---
      IF(L1N_NCONN.GT.0) THEN
        DO  I = 1,L1N_NCONN
          NAME = L1N_1ATM(I)
          DO J=1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN
              L1N_I1ATM(I) = J
              GO TO 500
            ENDIF
          ENDDO
          IF(PNUM(1:1).EQ.' ') THEN
            LINE = ' WARNING : '//MON//
     *             ' : unknown extra_atom_name - '//NAME
          ELSE
            LINE = ' WARNING : '//MON//' '//PNUM//
     *             ' : unknown extra_atom_name - '//NAME
          ENDIF
          CALL MSGERR(MDOC,LINE)
          L1N_I1ATM(I) = 0
  500     CONTINUE  
          NAME = L1N_2ATM(I)
          DO J=1,L1A_NATOM
            IF(NAME.EQ.L1A_ANAME(J)) THEN
              L1N_I2ATM(I) = J
              GO TO 600
            ENDIF
          ENDDO
          IF(PNUM(1:1).EQ.' ') THEN
            LINE = ' WARNING : '//MON//
     *             ' : unknown extra_atom_name - '//NAME
          ELSE
            LINE = ' WARNING : '//MON//' '//PNUM//
     *             ' : unknown extra_atom_name - '//NAME
          ENDIF
          CALL MSGERR(MDOC,LINE)
          L1N_I2ATM(I) = 0
  600     CONTINUE  
          IF(L1N_I1ATM(I).GT.0.AND.L1N_I2ATM(I).GT.0) THEN
            J                          = L1N_I1ATM(I)
            K                          = L1N_I2ATM(I)
            L1A_NEXTR(J)               = L1A_NEXTR(J) +1
            L1A_IEXTR(L1A_NEXTR(J),J)  = K 
            L1A_NEXTR(K)               = L1A_NEXTR(K) +1
            L1A_IEXTR(L1A_NEXTR(K),K)  = J 
            IF(L1N_TYPE(K).EQ.'DUMMY') L1A_TEXTR(L1A_NEXTR(J),J) = 1
            IF(L1N_TYPE(J).EQ.'DUMMY') L1A_TEXTR(L1A_NEXTR(K),K) = 1
          ENDIF   
        ENDDO
      ENDIF
C ---
      IF(IERR.EQ.0) CALL CONNECT(MDOC,MON,PNUM,IERR)
      IERR = 0

      RETURN
      END

C ******
      SUBROUTINE CONNECT(MDOC,MON,PNUM,IERR)
C -----------------------------------------------
C -P- CONNECT - 
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER MON*3
C ---
      INCLUDE 'lib_com.fh'
C ******
      PARAMETER ( NSTLIM = 10 )
      INTEGER*4 NSTCK,ISTACK(NSTLIM),ICSTACK(NSTLIM)
      INTEGER*4 IC
      INTEGER*4 INEW_T(MX1ATOM),IOLD_T(MX1ATOM)
      CHARACTER LINE*256,PNUM*12,CH6*6
C ---------------------------------------
      IERR=0
      DO IC=1,L1A_NATOM
        INEW_T(IC) = L1A_NDIST(IC)
        IOLD_T(IC) = L1A_IOLD (IC)
      ENDDO
C ---
      ISTART  = L1A_ISTART
      IFINISH = L1A_IFINISH
C ---
  210 CONTINUE
      DO IC=1,L1A_NATOM
        IF(INEW_T(IC).EQ.0) THEN
          IF(L1A_IBACK(IC).EQ.-1) GO TO 200
          JC = L1A_IBACK(IC)
          IF(JC.LE.0) GO TO 100
          IBRN = L1A_NDIST(JC)-INEW_T(JC)+1
          IS   = 0
          IF(L1A_NDIST(IC).GT.0) THEN
            DO K=1,L1A_NDIST(IC)
              IS = IS+L1A_LENCON(K,IC)
            ENDDO
          ENDIF
          L1A_LENCON(IBRN,JC) = IS
          L1A_CONN(IBRN,JC)   = IC
          INEW_T(IC)          = -1
          INEW_T(JC)          = INEW_T(JC)-1
        ENDIF
  100   CONTINUE
      ENDDO
      GO TO 210
  200 CONTINUE  
C ---
      DO IC=1,L1A_NATOM
        NL = L1A_NDIST(IC)
        IF(NL.GT.1) THEN

          DO J=1,NL
            KC = L1A_CONN(J,IC)
            IF(L1A_ANAME(KC).EQ.L1A_FORW(IC)) THEN
              ITEMP           = L1A_CONN(J,IC)
              L1A_CONN(J,IC)  = L1A_CONN(NL,IC)
              L1A_CONN(NL,IC) = ITEMP
              GO TO 300
            ENDIF
          ENDDO
          IF(L1A_IFORW(IC).NE.-1) THEN 
            IF(PNUM(1:1).EQ.' ') THEN
              LINE = ' WARNING : '//MON//
     * ' : forward_atom '//L1A_FORW(IC)//' (for '//L1A_ANAME(IC)//
     *        ') is not in the table of connects'
            ELSE
              LINE = ' WARNING : '//MON//' '//PNUM//
     * ' : forward_atom '//L1A_FORW(IC)//' (for '//L1A_ANAME(IC)//
     *        ') is not in the table of con'
            ENDIF
            CALL MSGERR(MDOC,LINE)
            IERR=1
            GO TO 2000
          ENDIF 
  300     CONTINUE

          NL = NL-1
          IF(NL.GT.1) THEN
            DO J=1,NL-1
              L  = L1A_LENCON(J,IC)
              LC = L1A_CONN(J,IC)
              DO K=J+1,NL
                M  = L1A_LENCON(K,IC)
                MC = L1A_CONN(K,IC)
                IF(L1A_ANAME(LC)(1:1).EQ.'H'.AND.
     *             L1A_ANAME(MC)(1:1).NE.'H') 
     *          GO TO 600
                IF(M.LT.L.OR.
     *            (L1A_ANAME(LC)(1:1).NE.'H'.AND.
     *             L1A_ANAME(MC)(1:1).EQ.'H')) THEN
                  ITEMP          = L1A_CONN(J,IC)
                  L1A_CONN(J,IC) = L1A_CONN(K,IC)
                  L1A_CONN(K,IC) = ITEMP
                ENDIF
  600           CONTINUE
              ENDDO
            ENDDO
          ENDIF

        ENDIF
      ENDDO
C ------
      I         = ISTART
      IC        = 1
      INEW_T(I) = 1
      IOLD_T(1) = I
      J         = 2
      NSTCK     = 0
C ----------------------------
  400 CONTINUE

      N = L1A_NDIST(I)
      IF(N.LE.0.AND.NSTCK.LE.0) GO TO 500

        IF(N.EQ.0) THEN

          I     = ISTACK (NSTCK)
          IC    = ICSTACK(NSTCK)
          NSTCK = NSTCK-1

        ELSE IF(N.EQ.1) THEN

          INEXT         = L1A_CONN(1,I)
          INEW_T(INEXT) = J
          IOLD_T(J)     = INEXT
          J             = J+1
          IC            = 1
          I             = INEXT

        ELSE IF(N.GT.1) THEN

  410     CONTINUE
          INEXT         = L1A_CONN(IC,I)
          INEW_T(INEXT) = J
          IOLD_T(J)     = INEXT
          J             = J+1
          IF(IC.LT.N) THEN
            IC    = IC    + 1
            NSTCK = NSTCK + 1
            IF(NSTCK.GT.NSTLIM) THEN
              WRITE(CH6,'(I6)') NSTLIM
              IF(PNUM(1:1).EQ.' ') THEN
                LINE = ' WARNING : '//MON//
     *        ' : N-stack > '//CH6
              ELSE
                LINE = ' WARNING : '//MON//' '//PNUM//
     *        ' : N-stack > '//CH6
              ENDIF
              CALL MSGERR(MDOC,LINE)
              IERR=1
              GO TO 2000
            ENDIF
            ISTACK(NSTCK)  = I
            ICSTACK(NSTCK) = IC
          ENDIF   
          I  = INEXT
          IC = 1

        ELSE
          IF(PNUM(1:1).EQ.' ') THEN
            LINE = ' WARNING : '//MON//
     *    ' : bad tree structure'
          ELSE
            LINE = ' WARNING : '//MON//' '//PNUM//
     *    ' : bad tree structure'
          ENDIF
          CALL MSGERR(MDOC,LINE)
          IERR=1
          GO TO 2000
        ENDIF

      GO TO 400
C ----------------------------
  500 CONTINUE
C ---
      DO IC=1,L1A_NATOM
        L1A_INEW(IC) = INEW_T(IC)
        L1A_IOLD(IC) = IOLD_T(IC)
      ENDDO
      RETURN
C ------------------
 2000 CONTINUE
      IF(PNUM(1:1).EQ.' ') THEN
        LINE = ' WARNING : '//MON//
     *         ' wrong tree structure /in subr. CONNECT/'
      ELSE
        LINE = ' WARNING : '//MON//' '//PNUM//
     *         ' wrong tree structure /in subr. CONNECT/'
      ENDIF
      CALL MSGERR(MDOC,LINE)
      RETURN    
      END

      SUBROUTINE SET_NUM_LIB(MDOC,LIST)
C -----------------------------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER*4 ICH4
      CHARACTER CH4*4,CH4A*4,LIST*1,LINE*256
      EQUIVALENCE (ICH4,CH4)
C --------------------------------------------------------
      IF(LIST.EQ.'T') THEN
        WRITE(LINE,'(''set_num_lib:'',5i4)')
     *  L1A_NATOM,L1B_NBOND,L1G_NANGL,L1T_NTORS,L1C_NCHIR
        CALL MSGdoc(MDOC,line)
      ENDIF

      NA = L1A_NATOM
      IF(NA.GT.0) THEN
      IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
          DO J=1,NA
            IF(L1B_1ATM(IB).EQ.L1A_ANAME(J)) L1B_I1ATM(IB)=J
            IF(L1B_2ATM(IB).EQ.L1A_ANAME(J)) L1B_I2ATM(IB)=J
          ENDDO
        ENDDO
      ENDIF
       
      IF(L1G_NANGL.GT.0) THEN
        DO IG=1,L1G_NANGL
          DO J=1,NA
            IF(L1G_1ATM(IG).EQ.L1A_ANAME(J)) L1G_I1ATM(IG)=J
            IF(L1G_2ATM(IG).EQ.L1A_ANAME(J)) L1G_I2ATM(IG)=J
            IF(L1G_3ATM(IG).EQ.L1A_ANAME(J)) L1G_I3ATM(IG)=J
          ENDDO
        ENDDO
      ENDIF
 
      IF(L1T_NTORS.GT.0) THEN
        DO IT=1,L1T_NTORS
          DO J=1,NA
            IF(L1T_1ATM(IT).EQ.L1A_ANAME(J)) L1T_I1ATM(IT)=J
            IF(L1T_2ATM(IT).EQ.L1A_ANAME(J)) L1T_I2ATM(IT)=J
            IF(L1T_3ATM(IT).EQ.L1A_ANAME(J)) L1T_I3ATM(IT)=J
            IF(L1T_4ATM(IT).EQ.L1A_ANAME(J)) L1T_I4ATM(IT)=J
          ENDDO
        ENDDO
      ENDIF
       
      IF(L1C_NCHIR.GT.0) THEN
        DO IC=1,L1C_NCHIR
          DO J=1,NA
            IF(L1C_1ATM(IC).EQ.L1A_ANAME(J)) L1C_I1ATM(IC)=J
            IF(L1C_2ATM(IC).EQ.L1A_ANAME(J)) L1C_I2ATM(IC)=J
            IF(L1C_3ATM(IC).EQ.L1A_ANAME(J)) L1C_I3ATM(IC)=J
            IF(L1C_4ATM(IC).EQ.L1A_ANAME(J)) L1C_I4ATM(IC)=J
            IF(L1C_5ATM(IC).EQ.L1A_ANAME(J)) L1C_I5ATM(IC)=J
            IF(L1C_6ATM(IC).EQ.L1A_ANAME(J)) L1C_I6ATM(IC)=J
            IF(L1C_7ATM(IC).EQ.L1A_ANAME(J)) L1C_I7ATM(IC)=J
            IF(L1C_8ATM(IC).EQ.L1A_ANAME(J)) L1C_I8ATM(IC)=J
            IF(L1C_9ATM(IC).EQ.L1A_ANAME(J)) L1C_I9ATM(IC)=J
          ENDDO
          CALL CALC_IVOL(IC,VOLIDL,PH1,PH2,PH3)
          L1C_VOL(IC) = VOLIDL
        ENDDO
      ENDIF

      IF(L1P_NPLAN.GT.0) THEN
        DO IP=1,L1P_NPLAN
          NAP = L1P_NATOM(IP)
          IF(NAP.GT.0) THEN
            DO IAP=1,NAP
              ICH4 = L1P_ATOM(IAP,IP)
              CALL LENSTR_BL(CH4,LEN)

            IF(LIST.EQ.'T') THEN
        WRITE(LINE,'(''set_num_lib:'',2i3,'':'',a,'':'',a,'':'',2i3)')
     *  IP,IAP,L1P_LABEL(IP),CH4,LEN,L1P_IATOM(IAP,IP)
            CALL MSGdoc(MDOC,line)
            ENDIF

              DO J=1,NA
                CH4A = L1A_ANAME(J)
                CALL LENSTR_BL(CH4A,LENA)
c               IF(LEN.LE.3) CH4A(4:4) = ' '
c               IF(LEN.LE.2) CH4A(3:3) = ' '
c               IF(LEN.LE.1) CH4A(2:2) = ' '
                IF(LEN.EQ.LENA.AND.CH4(1:LEN).EQ.CH4A(1:LEN))THEN
                  L1P_IATOM(IAP,IP)=J
                  GO TO 100
                ENDIF
              ENDDO
              L1P_IATOM(IAP,IP) = 0              
 100          CONTINUE

              IF(LIST.EQ.'T') THEN
       WRITE(LINE,'(''set_num_lib:'',2i3,'':'',a,'':'',a,'':'',2i3)')
     * IP,IAP,L1P_LABEL(IP),CH4,LENa,L1P_IATOM(IAP,IP)
              CALL MSGdoc(MDOC,line)
              ENDIF

            ENDDO
          ENDIF
        ENDDO
      ENDIF
      ENDIF
C --
      RETURN
      END

C ******
      SUBROUTINE ADD_HATOM_TO_PLAN(MDOC,IERR)
C -------------------------------------------------
C     add H_atoms to PLAN
C
C -------------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------
      CHARACTER LINE*256,SYMB*4,ANAME*4,HANAME*4
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C ----------------------------------------------------
      IERR = 0
C     M    =-ABS(MDOC)-1
C ----------------
      IF(L1P_NPLAN.LE.0) RETURN

      DO IP=1,L1P_NPLAN
        NAP = L1P_NATOM(IP) 

C        write(*,*) '--plan',ip,nap

        DO IA=1,NAP 
          I    = L1P_IATOM(IA,IP)
          SYMB = L1A_CHEM(I)

C          iCH4 = L1P_ATOM(iA,IP)
C          write(*,*) '  ',symb,i,L1A_NDIST(I),ch4
          
          IF(L1A_ICHIR(I).LT.0) THEN

            ND = L1A_NDIST(I) + L1A_NEXTR(I)
            IF(L1A_IBACK(I).GT.0) ND = ND + 1

            IF(ND.GE.2) THEN
              DO J=1,L1A_NDIST(I)
                IJ = ABS(L1A_CONN(J,I))
 
C            write(*,*) '   conn',ij,L1A_ATYPE(IJ),L1A_ANAME(IJ)

                IF(L1A_ATYPE(IJ).EQ.'H'.OR.L1A_ATYPE(IJ).EQ.'M') THEN
                  HANAME = L1A_ANAME(IJ)
                  DO JA=1,NAP 
                    ICH4  = L1P_ATOM(JA,IP) 
                    ANAME = CH4
                    IF(ANAME.EQ.HANAME) GO TO 100
                  ENDDO
                  IF(L1P_NATOM(IP).GE.MAX1APL) THEN
                    WRITE(LINE,'(3A,I6)')
     *    ' ERROR: number of atoms in planar group of new monomer'
     *                ,L1L_MNAME,' >',MAX1APL
                    CALL MSGERR(MDOC,LINE)
                    CALL MSGERR(MDOC,
     *  '          Change parameter MAX1APL in "lib_com.fh"')
                    IERR=1
                    RETURN
                  ENDIF
                  L1P_NATOM(IP)    = L1P_NATOM(IP) + 1
                  KA               = L1P_NATOM(IP)
                  L1P_IATOM(KA,IP) = IJ
                  CH4              = HANAME
                  L1P_ATOM(KA,IP)  = ICH4
                  L1P_DOBS(KA,IP)  = 0.0
                  L1P_DEV (KA,IP)  = 0.02
  100             CONTINUE
                ENDIF
              ENDDO
            ENDIF
          ENDIF
        ENDDO
      ENDDO
C ----
      RETURN
      END       
C
      SUBROUTINE CHECK_CONNECTIVITY(MDOC,LIST,IERR)
C -------------------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,MON*8,LIST*1,TREE*1
C -----------------------------------------------
      IERR = 0
      MON  = L1L_MNAME
      NA   = L1A_NATOM
      IF(NA.LE.1) RETURN
      CALL COPYL2(MDOC,IERR)
C --
      DO I=1,L2A_NATOM
        L2A_ICR(I) = I  
      ENDDO

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,' -- PRECHECK_L1_MON_DESCRIPTION --- ')
        WRITE(LINE,*) ' --- NA:',L1A_NATOM
        CALL MSGDOC(MDOC,LINE)
        IF(NA.GT.0) THEN
        DO IA=1,NA
          WRITE(LINE,*) IA,' ',L1A_ANAME(IA)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF
        WRITE(LINE,*) ' --- NB:',L1B_NBOND
        CALL MSGDOC(MDOC,LINE)
        IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
          WRITE(LINE,*) IB,' ',L1B_I1ATM(IB),L1B_I2ATM(IB)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
        ENDIF
      ENDIF
C -----
      DO IA=1,NA
        DO JA=1,NA
          J = L2A_ICR(JA) 
          DO IB=1,L2B_NBOND
            IK = 0
            IF(L2B_I1ATM(IB).EQ.J.AND.L2B_I2ATM(IB).NE.J) THEN
              IK = L2B_I2ATM(IB)
            ELSE IF(L2B_I2ATM(IB).EQ.J.AND.L2B_I1ATM(IB).NE.J) THEN
              IK = L2B_I1ATM(IB)
            ENDIF
            IF(IK.GT.0) THEN
              DO KA=1,NA
                IF(L2A_ICR(KA).EQ.IK) L2A_ICR(KA) = J  
              ENDDO
              DO JB=1,L2B_NBOND
                IF(L2B_I1ATM(JB).EQ.IK) L2B_I1ATM(JB) = J
                IF(L2B_I2ATM(JB).EQ.IK) L2B_I2ATM(JB) = J
              ENDDO
            ENDIF    
          ENDDO
        ENDDO
C --
        NPIECE = 1
        DO J=2,NA
          DO K=1,J-1
            IF(L2A_ICR(J).EQ.L2A_ICR(K)) GO TO 100
          ENDDO
          NPIECE = NPIECE + 1 
 100      CONTINUE
        ENDDO
        IF(NPIECE.LE.1) GO TO 200
C -- 
      ENDDO

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) '---- I,NPIECE:',I,NPIECE
        CALL MSGDOC(MDOC,LINE)         
        DO K=1,NA
          WRITE(LINE,*) '--',L2A_ANAME(K),K,L2A_ICR(K) 
          CALL MSGDOC(MDOC,LINE)         
        ENDDO
        CALL MSGDOC(MDOC,'-----------------')         
      ENDIF 

      NPIECE1 = NPIECE - 1
      WRITE(LINE,
     *'('' ERROR: monomer:'',A,'' not completely connected.'')') MON
      CALL MSGERR(MDOC,LINE)         

      IERR = 20

 200  CONTINUE
C -------
      RETURN
      END

      SUBROUTINE  CHECK_LIST_ATOM(MDOC,IERR)
C --------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM1*4,ATOM2*4,CHEM*4,MON*8
C ---------------------------------------------
      IERR = 0
      MON  = L1L_MNAME        
      NA   = L1A_NATOM
      I = 0
      DO IA=1,NA
        IF((L1A_ATYPE(IA).NE.'H'.AND.L1A_ATYPE(IA).NE.'?').OR.
     *     (L1A_ATYPE(IA).EQ.'H'.AND.L1A_COOR_FLAG(IA).EQ.'Y')) THEN
          I = I + 1
          L1A_COOR_FLAG(I) = L1A_COOR_FLAG(IA) 
          L1A_X        (I) = L1A_X        (IA)
          L1A_Y        (I) = L1A_Y        (IA)
          L1A_Z        (I) = L1A_Z        (IA)
          L1A_ANAME    (I) = L1A_ANAME    (IA) 
          L1A_SYMB     (I) = L1A_SYMB     (IA)
          L1A_CHEM     (I) = L1A_CHEM     (IA)
          L1A_ATYPE    (I) = L1A_ATYPE    (IA)
        ENDIF
      ENDDO
      IF(I.LE.0) THEN
        IERR = 1
        LINE = ' ERROR: '//MON//': number atoms = 0'
        CALL MSGDOC(MDOC,LINE)
        RETURN
      ELSE
        L1A_NATOM = I     
        NA        = I
      ENDIF
C ---
      DO IA=1,NA
        IF(L1A_COOR_FLAG(IA).NE.'Y') THEN
          IERR = 1
          LINE = ' ERROR: '//MON//': can not create new monomer'
          CALL MSGDOC(MDOC,LINE)
          LINE = '                   Some atoms without coordinates' 
          CALL MSGDOC(MDOC,LINE)
          RETURN
        ENDIF
      ENDDO    

      RETURN
      END

      SUBROUTINE REMOVE_USER_CHIR_CENTRE(MDOC,LIST,IERR)
C -------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------
      LOGICAL  IS_IT_METAL
      EXTERNAL IS_IT_METAL
      INTEGER   I,J,IA,N
      CHARACTER LINE*256,ATOM*4,MON*8,LIST*1
C ----------------------------------------------------
      IERR = 0
C ----------------
      IF(L1A_NATOM.LE.0) RETURN
      IF(L1C_NCHIR.LE.0) RETURN

      IF(LIST.EQ.'T') THEN
        write(*,*) ' before R_U_C_C nchir:',L1C_NCHIR 
      ENDIF
 
      N = 0
      DO I=1,L1C_NCHIR  

        IF(L1C_SIGN(I)(1:4).EQ.'cros'.OR.
     *     L1C_SIGN(I)(1:4).EQ.'star'    ) THEN
          J = 1
          GO TO 100
        ENDIF

        IA = L1C_I1ATM(I)
        IF(IS_IT_METAL(L1A_SYMB(IA))) THEN 
          IF(L1L_PRSNT.EQ.'M') THEN
            J = 1
            GO TO 100
          ENDIF
        ENDIF 

        ATOM = L1C_1ATM(I)
        J = 0
        DO IA=1,L1A_NATOM
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            IF(L1A_ICHIR(IA).LE.0) J = 0
            GO TO 100
          ENDIF
        ENDDO
 100    CONTINUE

        IF(J.GT.0) THEN
          N = N + 1
          L1C_I1ATM(N) = L1C_I1ATM(I) 
          L1C_1ATM (N) = L1C_1ATM (I) 
          L1C_I2ATM(N) = L1C_I2ATM(I) 
          L1C_2ATM (N) = L1C_2ATM (I) 
          L1C_I3ATM(N) = L1C_I3ATM(I) 
          L1C_3ATM (N) = L1C_3ATM (I) 
          L1C_I4ATM(N) = L1C_I4ATM(I) 
          L1C_4ATM (N) = L1C_4ATM (I) 
          L1C_SIGN (N) = L1C_SIGN (I)
          L1C_FLAG (N) = L1C_FLAG (I)
          L1C_VOL  (N) = L1C_VOL  (I)
          L1C_VOBS (N) = L1C_VOBS (I)
          L1C_I5ATM(N) = L1C_I5ATM(I) 
          L1C_5ATM (N) = L1C_5ATM (I) 
          L1C_I6ATM(N) = L1C_I6ATM(I) 
          L1C_6ATM (N) = L1C_6ATM (I) 
          L1C_I7ATM(N) = L1C_I7ATM(I) 
          L1C_7ATM (N) = L1C_7ATM (I) 
          L1C_I8ATM(N) = L1C_I8ATM(I) 
          L1C_8ATM (N) = L1C_8ATM (I) 
          L1C_I9ATM(N) = L1C_I9ATM(I) 
          L1C_9ATM (N) = L1C_9ATM (I) 
        ENDIF
      ENDDO

      L1C_NCHIR = N 

      IF(LIST.EQ.'T') THEN
        write(*,*) ' R_U_C_C nchir:',L1C_NCHIR 
      ENDIF
C ---
      RETURN
      END 

      SUBROUTINE CHECK_CHIR_ATOM(MDOC,IERR)
C -------------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------
      CHARACTER LINE*256,ATOM*4,MON*8
C ----------------------------------------------------
      IERR = 0
C ----------------
      NA   = L1A_NATOM
      MON  = L1L_MNAME        
      IF(NA.LE.0) RETURN
      IF(L1C_NCHIR.LE.0) RETURN

      DO I=1,L1C_NCHIR  
        ATOM = L1C_1ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 100
          ENDIF
        ENDDO
 100    L1C_I1ATM(I) = J
        ATOM = L1C_2ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 200
          ENDIF
        ENDDO
 200    L1C_I2ATM(I) = J
        ATOM = L1C_3ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 300
          ENDIF
        ENDDO
 300    L1C_I3ATM(I) = J
        ATOM = L1C_4ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 400
          ENDIF
        ENDDO
 400    L1C_I4ATM(I) = J
        ATOM = L1C_4ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 500
          ENDIF
        ENDDO
 500    L1C_I5ATM(I) = J
        ATOM = L1C_4ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 600
          ENDIF
        ENDDO
 600    L1C_I6ATM(I) = J
        ATOM = L1C_4ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 700
          ENDIF
        ENDDO
 700    L1C_I7ATM(I) = J
        ATOM = L1C_4ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 800
          ENDIF
        ENDDO
 800    L1C_I8ATM(I) = J
        ATOM = L1C_4ATM(I)
        J = 0
        DO IA=1,NA
          IF(ATOM.EQ.L1A_ANAME(IA)) THEN
            J = IA
            GO TO 900
          ENDIF
        ENDDO
 900    L1C_I9ATM(I) = J
      ENDDO

      N    = 0
      JERR = 0
      DO I=1,L1C_NCHIR  
        IF(L1C_SIGN(I)(1:4).NE.'cros'.AND.
     *     L1C_SIGN(I)(1:4).NE.'star'.AND.
     *    (L1C_I1ATM(I).EQ.0.OR.L1C_I2ATM(I).EQ.0.AND.
     *     L1C_I3ATM(I).EQ.0.OR.L1C_I4ATM(I).EQ.0     )) THEN
          JERR = 1
          GO TO 1000
        ELSE IF(L1C_I1ATM(I).EQ.0) THEN
          JERR = 1
          GO TO 1000
        ENDIF 

          N = N + 1
          L1C_I1ATM(N) = L1C_I1ATM(I) 
          L1C_1ATM (N) = L1C_1ATM (I) 
          L1C_I2ATM(N) = L1C_I2ATM(I) 
          L1C_2ATM (N) = L1C_2ATM (I) 
          L1C_I3ATM(N) = L1C_I3ATM(I) 
          L1C_3ATM (N) = L1C_3ATM (I) 
          L1C_I4ATM(N) = L1C_I4ATM(I) 
          L1C_4ATM (N) = L1C_4ATM (I) 
          L1C_SIGN (N) = L1C_SIGN (I)
          L1C_I1ATM(N) = L1C_I1ATM(I) 
          L1C_1ATM (N) = L1C_1ATM (I) 
          L1C_FLAG (N) = L1C_FLAG (I)
          L1C_I5ATM(N) = L1C_I5ATM(I) 
          L1C_5ATM (N) = L1C_5ATM (I) 
          L1C_I6ATM(N) = L1C_I6ATM(I) 
          L1C_6ATM (N) = L1C_6ATM (I) 
          L1C_I7ATM(N) = L1C_I7ATM(I) 
          L1C_7ATM (N) = L1C_7ATM (I) 
          L1C_I8ATM(N) = L1C_I8ATM(I) 
          L1C_8ATM (N) = L1C_8ATM (I) 
          L1C_I9ATM(N) = L1C_I9ATM(I) 
          L1C_9ATM (N) = L1C_9ATM (I) 
          L1C_VOBS (N) = L1C_VOBS (I)
          L1C_VOL  (N) = L1C_VOL  (I)
 1000     CONTINUE

      ENDDO
      IF(JERR.NE.0) THEN
        LINE = ' WARNING: '//MON//': some chirality is not defined'
        CALL MSGDOC(MDOC,LINE)
      ENDIF
      L1C_NCHIR = N 
C ---
      RETURN
      END 

      SUBROUTINE CALC_VOBSN(MDOC,LIST,MON,NRINGT,IERR)
C -----------------------------------------------
C -P- CONNECT - 
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ******
      PARAMETER ( NSTLIM = 10 )
      INTEGER*4 NSTCK,ISTACK(NSTLIM),ICSTACK(NSTLIM)
C --------------------------------------
      CHARACTER LINE*256
C ---------------------------------------
      IERR=0
C ---
c      DO I=1,L1A_NATOM
c        IF(L1A_NDIST(I).GT.0) THEN
c          N=0
c          DO J=1,L1A_NDIST(I)
c            K=L1A_CONN(J,I)
c            IF(L1A_TYPE(K).NE.'DUMMY') THEN
c              N=N+1
c              L1A_CONN(N,I)=K
c            ENDIF  
c          ENDDO
c          L1A_NDIST(I)=N
c        ENDIF
c        IF(L1A_NEXTR(I).GT.0) THEN
c          NN=0
c          DO J=1,L1A_NEXTR(I)
c            K=L1A_TEXTR(J,I)
c            IF(K.EQ.0) THEN
c              NN=NN+1
c              L1A_IEXTR(NN,I)=L1A_IEXTR(J,I)
c              L1A_TEXTR(NN,I)=0
c            ENDIF  
c          ENDDO
c          L1A_NEXTR(I)=NN
c        ENDIF
c      ENDDO
C ---
      ISTART  = L1A_ISTART
      IFINISH = L1A_IFINISH
      ISTART2 = 0
C ---
      I       = ISTART
      IC      = 1
      NSTCK   = 0
      NV      = 0
      NC      = 0
C ----------------------------
  400 CONTINUE

      N = L1A_NDIST(I)
      NE= L1A_NEXTR(I)

      IF(LIST.EQ.'T') THEN
        write(*,*) '---CALC_VOBSN--'
        write(*,'(''i,ic,NST,n,NE,'',5I3,1X,A4,1X,I3)') 
     *  i,ic,NSTCK,n,NE,l1a_aname(i),L1A_CONN(1,I)
      ENDIF

      IF(IC.EQ.1) THEN

        CALL CALC_VOBSNN(MDOC,LIST,I,NV,NC,MON,IERR)
        IF(IERR.NE.0) RETURN

      ENDIF

      IF(N.LE.0.AND.NSTCK.LE.0) GO TO 500

        IF(N.EQ.0) THEN

          I     = ISTACK (NSTCK)
          IC    = ICSTACK(NSTCK)
          NSTCK = NSTCK-1

        ELSE IF(N.EQ.1) THEN

          INEXT = L1A_CONN(1,I)
          IC    = 1
          I     = INEXT

        ELSE IF(N.GT.1) THEN

  410     CONTINUE
          INEXT = L1A_CONN(IC,I)

          IF(IC.LT.N) THEN
            IC    = IC+1
            NSTCK = NSTCK+1
            IF(NSTCK.GT.NSTLIM) THEN
              WRITE(LINE,
     *        '('' ERROR: '',A,'' : N-stack > '',I6)')
     *        MON,NSTLIM
              CALL MSGERR(MDOC,LINE)
              IERR=1
              GO TO 2000
            ENDIF
            ISTACK(NSTCK)  = I
            ICSTACK(NSTCK) = IC
          ENDIF   
          I  = INEXT
          IC = 1

        ELSE

          WRITE(LINE,
     *    '('' WARNING : '',A,'' : bad tree structure '')')
     *    MON
          CALL MSGERR(MDOC,LINE)
          IERR=1
          GO TO 2000

        ENDIF

      GO TO 400
C -------------------------------
  500 CONTINUE
C ---

      IF(LIST.EQ.'T') write(*,*) '---end CALC_VOBSN--'

      CALL SET_TRIANGLE_ANGLES(MDOC,LIST,IERR)
      IF(IERR.NE.0) GO TO 2000

      IF(LIST.EQ.'T') THEN
        MMM=1
        CALL PRINT_LIB_LBC(MMM,IERR)
      ENDIF

      IANGL = 0
      IMET  = 0
      CALL CHECK_METAL_CHIR(MDOC,MON,IANGL,LIST,IERR)
      IF(IERR.NE.0) THEN
        ICOOR = 0
        COOR_SUM = 0.0
        DO I=1,L1A_NATOM
          IF(L1A_SYMB(I).NE.'H   '.AND.
     *       L1A_SYMB(I).NE.'D   '     ) THEN
            IF(L1A_COOR_FLAG(I).EQ.'N'.OR.
     *         L1A_COOR_FLAG(I).EQ.'.') THEN
              ICOOR=1 
            ELSE
              COOR_SUM = COOR_SUM +  
     *               ABS(L1A_X(I)) + ABS(L1A_Y(I)) + ABS(L1A_Z(I)) 
            ENDIF
          ENDIF
        ENDDO
        IF(COOR_SUM.LT.0.001) ICOOR = 1
        IF(ICOOR.GT.0) GO TO 2000 
        IERR = 0
        IMET = 1
      ENDIF

      IF(LIST.EQ.'T') write(*,*) '---before TORS_CORR --'

      IF(LIST.EQ.'T') THEN
        MMM=1
        CALL PRINT_LIB_LBC(MMM,IERR)
      ENDIF

      IF(IMET.EQ.0) THEN 
        CALL TORSION_CORRECTION(MDOC,LIST,NRINGT,IERR)
        IF(IERR.NE.0) GO TO 2000
      ENDIF

      IF(LIST.EQ.'T') write(*,*) '---after TORS_CORR --',L1B_NBOND

      IF(L1C_NCHIR.GT.0) THEN
        DO  I = 1,L1C_NCHIR
          PH1 = 0.0
          PH2 = 0.0
          PH3 = 0.0
          CALL CALC_IVOL(I,VOLIDL,PH1,PH2,PH3)
          CALL CALC_OVOL(I,VOLOBS,IERR)
          IERR = 0
          L1C_VOL (I) = VOLIDL
          L1C_VOBS(I) = VOLOBS
c         L1C_SIGN(I) = 'positiv'
        ENDDO
      ENDIF

      CALL PLAN_RSTR(MDOC,IERR)

      IF(LIST.EQ.'T') write(*,*)'---end end CALC_VOBSN--',L1B_NBOND

      IF(LIST.EQ.'T') THEN
        MMM=1
        CALL PRINT_LIB_LBC(MMM,IERR)
      ENDIF

      RETURN
C -------------------------------
 2000 CONTINUE
      WRITE(LINE,
     * '('' WARNING : '',A,'' /subroutine CALC_VOBSN/'')')
     * MON
      CALL MSGERR(MDOC,LINE)
      RETURN    
      END

      SUBROUTINE SET_TRIANGLE_ANGLES(MDOC,LIST,IERR)
C --------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,MON*8,LIST*1
C ---------------------------------------------
      IERR = 0
      MON  = L1L_MNAME        
      NB   = L1B_NBOND
      IF(NB.LE.2) RETURN
C ---
      DO I=1,NB-2
        DO J=I+1,NB-1
          IF(L1B_I1ATM(I).EQ.L1B_I1ATM(J)) THEN 
            IB1 = L1B_I2ATM(I)   
            IB2 = L1B_I2ATM(J)   
            IB3 = L1B_I1ATM(I)
          ELSE IF(L1B_I1ATM(I).EQ.L1B_I2ATM(J)) THEN 
            IB1 = L1B_I2ATM(I)   
            IB2 = L1B_I1ATM(J)   
            IB3 = L1B_I1ATM(I)
          ELSE IF(L1B_I2ATM(I).EQ.L1B_I1ATM(J)) THEN 
            IB1 = L1B_I1ATM(I)   
            IB2 = L1B_I2ATM(J)   
            IB3 = L1B_I2ATM(I)
          ELSE IF(L1B_I2ATM(I).EQ.L1B_I2ATM(J)) THEN 
            IB1 = L1B_I1ATM(I)   
            IB2 = L1B_I1ATM(J)   
            IB3 = L1B_I2ATM(I)
          ELSE
            IB1 = 0
            IB2 = 0
            IB3 = 0
          ENDIF
          IF(IB1.GT.0) THEN
            DO K=J+1,NB
              IF((L1B_I1ATM(K).EQ.IB1.AND.L1B_I2ATM(K).EQ.IB2).OR.
     *           (L1B_I1ATM(K).EQ.IB2.AND.L1B_I2ATM(K).EQ.IB1))THEN
                IF(LIST.EQ.'T') THEN  
        LINE = ' WARNING: '//MON//' triangle:'//L1A_ANAME(IB1)//
     *         ' - '//L1A_ANAME(IB2)//' - '//L1A_ANAME(IB3)
        CALL MSGDOC(MDOC,LINE)
        LINE = '          bond:'//L1B_1ATM(K)//' - '//L1B_2ATM(K)
        CALL MSGDOC(MDOC,LINE)
                ENDIF

                CALL SET_TANGLE_VALUE(MDOC,MON,I,J,K,IB1,IB2,IB3,IERR)
                IERR = 0
                GO TO 200
              ENDIF
 200          CONTINUE
            ENDDO
          ENDIF
        ENDDO
      ENDDO

      RETURN
      END

      SUBROUTINE SET_TANGLE_VALUE(MDOC,MON,I,J,K,IA1,IA2,IA3,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,I,J,K,IA1,IA2,IA3,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C --
      REAL      BOND1,BOND2,BOND3
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4,LINE*256
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4
C --------------------------------------------------------
C       IA1--ib3--IA2
C         \      /
C         ib2  ib1
C           \  /  
C           IA3
C --------------------------------------------------------
      M    =-ABS(MDOC)-1  
      IERR = 0
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C ---
      IB1 = 0
      IB2 = 0
      IB3 = 0
      IF((L1B_I1ATM(I).EQ.IA1.AND.L1B_I2ATM(I).EQ.IA2).OR.
     *   (L1B_I1ATM(I).EQ.IA2.AND.L1B_I2ATM(I).EQ.IA1))THEN
        IB3 = I
      ELSE IF((L1B_I1ATM(I).EQ.IA2.AND.L1B_I2ATM(I).EQ.IA3).OR.
     *        (L1B_I1ATM(I).EQ.IA3.AND.L1B_I2ATM(I).EQ.IA2))THEN
        IB1 = I
      ELSE IF((L1B_I1ATM(I).EQ.IA1.AND.L1B_I2ATM(I).EQ.IA3).OR.
     *        (L1B_I1ATM(I).EQ.IA3.AND.L1B_I2ATM(I).EQ.IA1))THEN
        IB2 = I
      ENDIF
      IF((L1B_I1ATM(J).EQ.IA1.AND.L1B_I2ATM(J).EQ.IA2).OR.
     *   (L1B_I1ATM(J).EQ.IA2.AND.L1B_I2ATM(J).EQ.IA1))THEN
        IB3 = J
      ELSE IF((L1B_I1ATM(J).EQ.IA2.AND.L1B_I2ATM(J).EQ.IA3).OR.
     *        (L1B_I1ATM(J).EQ.IA3.AND.L1B_I2ATM(J).EQ.IA2))THEN
        IB1 = J
      ELSE IF((L1B_I1ATM(J).EQ.IA1.AND.L1B_I2ATM(J).EQ.IA3).OR.
     *        (L1B_I1ATM(J).EQ.IA3.AND.L1B_I2ATM(J).EQ.IA1))THEN
        IB2 = J
      ENDIF
      IF((L1B_I1ATM(K).EQ.IA1.AND.L1B_I2ATM(K).EQ.IA2).OR.
     *   (L1B_I1ATM(K).EQ.IA2.AND.L1B_I2ATM(K).EQ.IA1))THEN
        IB3 = K
      ELSE IF((L1B_I1ATM(K).EQ.IA2.AND.L1B_I2ATM(K).EQ.IA3).OR.
     *        (L1B_I1ATM(K).EQ.IA3.AND.L1B_I2ATM(K).EQ.IA2))THEN
        IB1 = K
      ELSE IF((L1B_I1ATM(K).EQ.IA1.AND.L1B_I2ATM(K).EQ.IA3).OR.
     *        (L1B_I1ATM(K).EQ.IA3.AND.L1B_I2ATM(K).EQ.IA1))THEN
        IB2 = K
      ENDIF
      IF(IB1.EQ.0.OR.IB2.EQ.0.OR.IB3.EQ.0) RETURN
C ---  
      BOND1 = L1B_VAL(IB1) 
      BOND2 = L1B_VAL(IB2) 
      BOND3 = L1B_VAL(IB3) 
      IF(BOND1.LT.0.001.OR.BOND2.LT.0.001.OR.BOND3.LT.0.001) RETURN
C ---
      DO II=1,3
        IF(II.EQ.1) THEN
          IAA1 = IA1
          IAA2 = IA2
          IAA3 = IA3
          B1   = BOND1
          B2   = BOND2
          B3   = BOND3      
        ELSE IF(II.EQ.2) THEN
          IAA1 = IA3
          IAA2 = IA1
          IAA3 = IA2
          B1   = BOND3
          B2   = BOND1
          B3   = BOND2      
        ELSE
          IAA1 = IA2
          IAA2 = IA3
          IAA3 = IA1
          B1   = BOND2
          B2   = BOND3
          B3   = BOND1      
        ENDIF
C ---
        T1     = B1*B1 + B3*B3 - B2*B2 
        T2     = 2.0*B1*B3 
        IF(T2.LT.0.0001) GO TO 200 
        COSANG = T1/T2
        IF(ABS(COSANG).GT.1.0) GO TO 200 
        ANG    = ACOS(COSANG)
        IF(ANG.GT. PI) ANG = ANG - TWOPI
        IF(ANG.LT.-PI) ANG = ANG + TWOPI
        ANG = ANG/PI180
C ---  
        CALL SRCH_ANGL(MDOC,MON,IAA1,IAA2,IAA3,VAL,L,IERR)
        IF(IERR.EQ.0.AND.L.GT.0) GO TO 100
        IERR = 0
        IF(L1G_NANGL.GE.MAX1ANG) THEN
          WRITE(LINE
     * ,'('' ERROR: number of angles of monomer >'',I6)') 
     *    MAX1ANG
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     * ,'         Change parameter MAX1ANG in "lib_com.fh"')
          IERR=1
          RETURN
        ENDIF
        L1G_NANGL   = L1G_NANGL+1
        L           = L1G_NANGL
        L1G_1ATM(L) = L1A_ANAME(IAA1)
        L1G_2ATM(L) = L1A_ANAME(IAA2)
        L1G_3ATM(L) = L1A_ANAME(IAA3)
        L1G_I1ATM(L)= IAA1
        L1G_I2ATM(L)= IAA2
        L1G_I3ATM(L)= IAA3
        L1G_VOBS(L) = 0.0
        L1G_EVAL(L) = 0.0
        L1G_DEV (L) = 3.0
 100    CONTINUE
        L1G_VAL(L) = ANG
 200    CONTINUE
      ENDDO
C ---
      RETURN
      END            


      SUBROUTINE PRINT_LIB_LBC(MDOC,IERR)
C -----------------------------------------------
C -P- 
C -S-
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
      CHARACTER SIGN*8
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C --------------------------------------------------------
      IF(ABS(MDOC).GE.99) RETURN

      WRITE(LINE,'('' N BOND,ANGLE,TORS,CHIR,PLAN:'',5I4)')
     * L1B_NBOND,L1G_NANGL,L1T_NTORS,L1C_NCHIR,L1P_NPLAN
      CALL MSGDOC(MDOC,LINE)
      IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
          WRITE(LINE,
     *    '(I4,'' bond '',A4,'' - '',A4,'' :'',2F8.3,2I3,A)')
     *    IB,L1B_1ATM(IB),L1B_2ATM(IB),L1B_VAL(IB),L1B_VOBS(IB)
     *    ,L1B_I1ATM(IB),L1B_I2ATM(IB),L1B_TYPE(IB)
          CALL MSGDOC(MDOC,LINE)
        ENDDO 
      ENDIF
C ---
      IF(L1G_NANGL.GT.0) THEN
        DO IG=1,L1G_NANGL
          WRITE(LINE,'(I4,'' angle '',A4,'' - '',A4,'' - '',A4
     *    ,2F8.3,3I3)')
     *    IG,L1G_1ATM(IG),L1G_2ATM(IG),L1G_3ATM(IG)
     *    ,L1G_VAL(IG),L1G_VOBS(IG)
     *    ,L1G_I1ATM(IG),L1G_I2ATM(IG),L1G_I3ATM(IG)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
C ---
      IF(L1T_NTORS.GT.0) THEN
        DO IT=1,L1T_NTORS
          WRITE(LINE,'(I4,''tr:'',A4,'' - '',A4,'' - '',A4
     *     ,'' - '',A4,'' :'',2F6.1,I2,A,4I3)')
     *    IT,L1T_1ATM(IT),L1T_2ATM(IT),L1T_3ATM(IT),L1T_4ATM(IT)
     *    ,L1T_VAL(IT), L1T_VOBS(IT),L1T_PRD(IT),L1T_LABEL(IT)
     *    ,L1T_I1ATM(IT),L1T_I2ATM(IT),L1T_I3ATM(IT),L1T_I4ATM(IT)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
C ---
      IF(L1C_NCHIR.GT.0) THEN
        DO IC=1,L1C_NCHIR
          WRITE(LINE,'(I4,''ch:'',A4,'' '',A4,'' '',A4,'' '',A4
     *    ,'' :'',2F7.2,A,4I3,A)')
     *    IC,L1C_1ATM(IC),L1C_2ATM(IC),L1C_3ATM(IC),L1C_4ATM(IC)
     *    ,L1C_VOL(IC),L1C_VOBS(IC),L1C_SIGN(IC)
     *    ,L1C_I1ATM(IC),L1C_I2ATM(IC),L1C_I3ATM(IC),L1C_I4ATM(IC)
     *    ,L1C_FLAG(IC)
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF

      IF(L1P_NPLAN.GT.0) THEN
        DO  IP=1,L1P_NPLAN
          DO  I = 1,L1P_NATOM(IP)
            WRITE(LINE,'(I4,'' '',A,'' atom '',A4,I4)')
     *      IP,L1P_LABEL(IP),L1P_ATOM(I,IP),L1P_IATOM(I,IP)
            CALL MSGDOC(MDOC,LINE)
          ENDDO
        ENDDO
      ENDIF

      RETURN
      END

      SUBROUTINE CALC_VOBSNN(MDOC,LIST,I0,NV,NC,MON,IERR)
C -----------------------------------------------
C -P- CALC_VOBS - 
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,LIST*1
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C --------------------------------------------------------
        IF(LIST.EQ.'T') THEN
          write(*,*) '   CALC_VOBSNN-->',I0,L1B_NBOND
        ENDIF

        I  = I0
        I1 = I 
        IF(L1A_IBACK(I1).GT.0.AND.L1A_TYPE(I1).NE.'DUMMY') THEN
          I2 = L1A_IBACK(I1)
          CALL SET_VBOND(MDOC,MON,I1,I2,IERR)
          IF(IERR.NE.0) RETURN
        ENDIF

        IF(L1A_NEXTR(I).GT.0) THEN
          DO K = 1,L1A_NEXTR(I)
            I1 = I
            I2 = L1A_IEXTR(K,I)
            IF(I1.LT.I2) THEN
              CALL SET_VBOND(MDOC,MON,I1,I2,IERR)
              IF(IERR.NE.0) RETURN
            ENDIF
          ENDDO
        ENDIF

        I2 = I
 
        IF(L1A_IBACK(I2).GT.0.AND.L1A_TYPE(I2).NE.'DUMMY') THEN
          I1 = L1A_IBACK(I2)
          IF(L1A_NDIST(I2).GT.0) THEN
            DO J = 1,L1A_NDIST(I2)
              I3 = L1A_CONN(J,I2)
              IF(I3.GT.0) THEN
              IF(L1A_TYPE(I3).NE.'DUMMY') THEN
                CALL SET_VANGL(MDOC,MON,I1,I2,I3,IERR)
                IF(IERR.NE.0) RETURN
              ENDIF
              ENDIF
            ENDDO
          ENDIF 
          IF(L1A_NEXTR(I2).GT.0) THEN
            DO J = 1,L1A_NEXTR(I2)
              I3 = L1A_IEXTR(J,I2)
              CALL SET_VANGL(MDOC,MON,I1,I2,I3,IERR)
              IF(IERR.NE.0) RETURN
            ENDDO
          ENDIF 
        ENDIF

        IF(L1A_NDIST(I2).GT.1) THEN
          DO J = 2,L1A_NDIST(I2)
            I3 = L1A_CONN(J,I2)
            IF(I3.GT.0) THEN
            IF(L1A_TYPE(I3).NE.'DUMMY') THEN
              DO K=1,J-1
                I1 = L1A_CONN(K,I2)
                IF(I1.GT.0) THEN
                IF(L1A_TYPE(I1).NE.'DUMMY') THEN
                  CALL SET_VANGL(MDOC,MON,I1,I2,I3,IERR)
                  IF(IERR.NE.0) RETURN
                ENDIF
                ENDIF
              ENDDO
            ENDIF
            ENDIF
          ENDDO
        ENDIF  
        IF(L1A_NEXTR(I2).GT.1) THEN
          DO J = 2,L1A_NEXTR(I2)
C           I1=L1A_IEXTR(J-1,I2)
            I3 = L1A_IEXTR(J,I2)
            DO K=1,J-1
              I1 = L1A_IEXTR(K,I2)
              CALL SET_VANGL(MDOC,MON,I1,I2,I3,IERR)
              IF(IERR.NE.0) RETURN
            ENDDO
          ENDDO
        ENDIF  

        IF(L1A_NEXTR(I2).GT.0.AND.L1A_NDIST(I2).GT.0) THEN
          DO J=1,L1A_NEXTR(I2)
            I3 = L1A_IEXTR(J,I2)
            DO K=1,L1A_NDIST(I2)
              I1 = L1A_CONN(K,I2)
              IF(I1.GT.0) THEN
              IF(L1A_TYPE(I1).NE.'DUMMY') THEN
                CALL SET_VANGL(MDOC,MON,I1,I2,I3,IERR)
                IF(IERR.NE.0) RETURN
              ENDIF
              ENDIF
            ENDDO
          ENDDO
        ENDIF  

C ---   tors ---

        I3 = I
        IF(L1A_IBACK(I3).GT.0.AND.L1A_TYPE(I3).NE.'DUMMY') THEN
          I2 = L1A_IBACK(I3)
        ELSE
          I2 = 0
          GO TO 100
        ENDIF

        IF(L1A_IBACK(I2).GT.0.AND.L1A_TYPE(I2).NE.'DUMMY') THEN
          I1 = L1A_IBACK(I2)
        ELSE IF(L1A_NDIST(I2).GT.1) THEN
          I1 = 0
          NDIST = L1A_NDIST(I2)  
          IF(L1A_CONN(NDIST  ,I2).NE.I3) THEN
            I1 = L1A_CONN(NDIST,I2)
          ELSE
            IF(L1A_CONN(NDIST-1,I2).NE.I3) I1 = L1A_CONN(NDIST-1,I2)
          ENDIF
          IF(I1.LE.0) GO TO 100  
        ELSE IF(L1A_NEXTR(I3).GT.0) THEN
          J  = L1A_NEXTR(I3)
          I1 = L1A_IEXTR(J,I2)
        ELSE 
          I1 = 0
          GO TO 100
        ENDIF

        I4 = L1A_IFORW(I3)
        IF(I4.GT.0) THEN
          IF(L1A_TYPE(I4).EQ.'DUMMY') I4=0
        ENDIF

        IF(I4.GT.0) THEN
          IF((L1A_SYMB(I4)(1:2).EQ.'H '.OR.L1A_SYMB(I4)(1:2).EQ.'D ')
     *       .AND.L1A_NEXTR(I3).GT.0) THEN
            I4 = L1A_IEXTR(1,I3)
          ENDIF
        ENDIF

        IF(I4.GT.0) THEN
          IF(I1.NE.I2.AND.I1.NE.I3.AND.I1.NE.I4.AND.I2.NE.I3.AND.
     *       I2.NE.I4.AND.I3.NE.I4) THEN
            CALL SET_VTORS(MDOC,I1,I2,I3,I4,NV,NC,IERR)
            IF(IERR.NE.0) RETURN
          ENDIF
        ELSE
          IF(L1A_NEXTR(I3).GT.0) THEN
            IF(I1.NE.I2.AND.I1.NE.I3.AND.I2.NE.I3) THEN
              DO II=1,L1A_NEXTR(I3)
                I4 = L1A_IEXTR(II,I3)
                IF(I4.GT.0) THEN
                  CALL SET_VTORS(MDOC,I1,I2,I3,I4,NV,NC,IERR)
                  IF(IERR.NE.0) RETURN
                  GO TO 100
                ENDIF
              ENDDO
            ENDIF
          ENDIF
        ENDIF

  100   CONTINUE

        IF(L1A_NEXTR(I3).GT.0.AND.I2.GT.0) THEN
          DO II=1,L1A_NEXTR(I3)
            I4 = L1A_IEXTR(II,I3)
            IF(I4.GT.0) THEN
              I5 = L1A_IBACK(I4)
              IF(I5.GT.0) THEN
                IF(I3.GE.I4) I5 = 0
              ELSE
                I5 = L1A_IFORW(I4)
              ENDIF 
              IF(I5.GT.0) THEN
                CALL SET_VTORS(MDOC,I2,I3,I4,I5,NV,NC,IERR)
                IF(IERR.NE.0) RETURN
              ENDIF
            ENDIF
          ENDDO
        ENDIF
      RETURN
      END

      SUBROUTINE SET_VBOND(MDOC,MON,I1,I2,IERR)
C -----------------------------------------------
C -P- SET_VBOND - 
C -S-
      INTEGER*4 MDOC,I1,I2,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ------------------------------------------------
      CHARACTER LINE*256
      CHARACTER CHEM1*4,CHEM2*4,BTYPE*8,ECHEM1*4,ECHEM2*4
      REAL      DLIM1(4),DLIM2(4),DEFD(4)
      INTEGER*4 ICH4
      CHARACTER CIATOM*1,CJATOM*1
      CHARACTER ASYMB*4,CTYPE*4,CH4*4
      EQUIVALENCE (ICH4,CH4)
      DATA DLIM1/ 0.75 , 1.10 , 1.50 , 1.8 /
      DATA DLIM2/ 1.2  , 1.60 , 2.00 , 3.0 /
      DATA DEFD / 0.96 , 1.45 , 1.80 , 2.5 /
C --------------------------------------------------------
      M=-ABS(MDOC)-1
      IERR = 0
      IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.L1A_COOR_FLAG(I2).EQ.'Y') THEN
        CALL CALC_DOBS(I1,I2,DOBS)
      ELSE
        DOBS=0.0
      ENDIF

      CALL SRCH_BOND(MDOC,MON,I1,I2,VAL,L,IERR)

      IF(IERR.NE.0) THEN
        IF(L1B_NBOND.GE.MAX1BND) THEN
          WRITE(LINE
     *   ,'('' ERROR: number of bonds of monomer >'',I6)') 
     *    MAX1BND
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     *   ,'         Change parameter MAX1BND in "lib_com.fh"')
          IERR=1
          RETURN
        ENDIF
        IERR = 0
        L1B_NBOND   = L1B_NBOND+1
        L           = L1B_NBOND
        BTYPE       = 'coval'
      ELSE
        BTYPE       = L1B_TYPE(L)
      ENDIF
      
      L1B_1ATM(L) = L1A_ANAME(I1)
      L1B_2ATM(L) = L1A_ANAME(I2)
      L1B_I1ATM(L)= I1
      L1B_I2ATM(L)= I2
      L1B_TYPE(L) = BTYPE
      L1B_VOBS(L) = DOBS
      L1B_EVAL(L) = 0.0
      L1B_DEV (L) = 0.02
      CHEM1       = L1A_CHEM(I1)
      CHEM2       = L1A_CHEM(I2)
      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '

      IDEF_TYPE = 0
      DIST1     = 0.0
      DIST2     = 0.0
      DIST3     = 0.0
      DO J=1,LEB_NBOND
        ECHEM1 = LEB_1ATM(J)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEB_2ATM(J) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2).OR.
     *     (ECHEM1.EQ.CHEM2.AND.ECHEM2.EQ.CHEM1)) THEN
          IF((BTYPE.EQ.'.'.AND.LEB_TYPE(J).EQ.'.').OR.
     *       (BTYPE(1:4).EQ.LEB_TYPE(J)(1:4)     )    ) THEN
            L1B_VAL(L) = LEB_LENGTH(J) 
            L1B_EVAL(L)= LEB_LENGTH(J) 
            GO TO 100
          ENDIF
          IF(LEB_TYPE(J).EQ.'.') THEN
            DIST1     = LEB_LENGTH(J)
            IDEF_TYPE = 1 
          ELSE IF(LEB_TYPE(J)(1:4).EQ.'sing') THEN
            DIST2     = LEB_LENGTH(J)
            IDEF_TYPE = 2 
          ELSE
            DIST3     = LEB_LENGTH(J)
            IDEF_TYPE = 3 
          ENDIF     
        ENDIF
      ENDDO
      IF(IDEF_TYPE.GT.0) THEN
        IF(IDEF_TYPE.EQ.1) DIST3 = DIST1
        IF(IDEF_TYPE.EQ.2) DIST3 = DIST2
        L1B_VAL(L) = DIST3 
        L1B_EVAL(L)= DIST3
        GO TO 100
      ENDIF
      D1 = 0.0
      D2 = 0.0
      DO J=1,LEB_NBOND
        ECHEM1 = LEB_1ATM(J)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        IF(ECHEM1.EQ.CHEM1.AND.LEB_2ATM(J)(1:1).EQ.'.')
     *  D1=LEB_LENGTH(J)
        IF(ECHEM1.EQ.CHEM2.AND.LEB_2ATM(J)(1:1).EQ.'.')
     *  D2=LEB_LENGTH(J)
      ENDDO
      IF(D1.GT.0.0.AND.D2.GT.0.0) THEN
        DA         = (D1+D2)/2.0
        L1B_VAL(L) = DA  
        L1B_EVAL(L)= DA
        WRITE(LINE,
     *'('' WARNING : '',A,'' : default bond length will used '')')
     *  MON
c        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,F8.3,A,A4,A,A4,A)')
     *  '                 chem_type: ',CHEM1,'-',CHEM2,' ',L1B_VAL(L),
     *   ' (',L1A_ANAME(I1),'-',L1A_ANAME(I2),')'
c        CALL MSGDOC(MDOC,LINE)
        GO TO 100
      ENDIF

      ASYMB = L1A_SYMB(I1)
      IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *   ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *   ASYMB(1:2).EQ.'F '                           ) THEN
        CTYPE = 'C   '
      ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
        CTYPE = 'H   '
      ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
        CTYPE = 'P   '
      ELSE
        CTYPE = '$   '
      ENDIF
      CIATOM = CTYPE(1:1)
      ASYMB  = L1A_SYMB(I2)
      IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *   ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *   ASYMB(1:2).EQ.'F '                           ) THEN
        CTYPE='C   '
      ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
        CTYPE='H   '
      ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
        CTYPE='P   '
      ELSE
        CTYPE='$   '
      ENDIF
      CJATOM = CTYPE(1:1)
      IF(CIATOM.EQ.'H'.OR.CJATOM.EQ.'H') THEN    
        IC=1 
      ELSE IF(CIATOM.EQ.'C'.AND.CJATOM.EQ.'C') THEN    
        IC=2
      ELSE IF(CIATOM.EQ.'$'.AND.CJATOM.EQ.'$') THEN    
        IC=4
      ELSE 
        IC=3
      ENDIF
      IF(IC.GT.0.AND.DOBS.GT.DLIM1(IC).AND.DOBS.LT.DLIM2(IC)) THEN
        L1B_VAL(L) = DOBS
        WRITE(LINE,'(3A)')
     *' WARNING : ',MON,' : observed bond legnth will used '
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,F8.3,A,A4,A,A4,A)')
     *  '             chem_type: ',CHEM1,'-',CHEM2,' ',DOBS,' (',
     * L1A_ANAME(I1),'-',L1A_ANAME(I2),')'
        CALL MSGDOC(MDOC,LINE)
      ELSE
        IF(IC.GT.0) THEN
          L1B_VAL(L) = DEFD(IC)
        ELSE
          L1B_VAL(L) = 1.0
        ENDIF
        WRITE(LINE,
     *'('' WARNING : '',A,'' : default bond legnth will used '')')
     *  MON
c        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,F8.3,A,A4,A,A4,A)')
     *  '                 chem_type: ',CHEM1,'-',CHEM2,' ',L1B_VAL(L),
     *  ' (',L1A_ANAME(I1),'-',L1A_ANAME(I2),')'
c        CALL MSGDOC(MDOC,LINE)
      ENDIF
  100 CONTINUE
      RETURN
      END

      SUBROUTINE SET_VANGL(MDOC,MON,I1,I2,I3,IERR)
C -----------------------------------------------
C -P- SET_VANGL - 
C -S-
      INTEGER*4 MDOC,I1,I2,I3,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ******
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4,LINE*256
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4
C --------------------------------------------------------
      M=-ABS(MDOC)-1  
      IERR = 0
      IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.L1A_COOR_FLAG(I2).EQ.'Y'.AND.
     *   L1A_COOR_FLAG(I3).EQ.'Y') THEN
        CALL CALC_ANGOBS(I1,I2,I3,ANGOBS)
      ELSE
        ANGOBS = 0.0
      ENDIF
      IF(L1G_NANGL.GE.MAX1ANG) THEN
        WRITE(LINE
     * ,'('' ERROR: number of angles of monomer >'',I6)') 
     *    MAX1ANG
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     * ,'         Change parameter MAX1ANG in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF
      L1G_NANGL   = L1G_NANGL+1
      L           = L1G_NANGL
      L1G_1ATM(L) = L1A_ANAME(I1)
      L1G_2ATM(L) = L1A_ANAME(I2)
      L1G_3ATM(L) = L1A_ANAME(I3)
      L1G_I1ATM(L)= I1
      L1G_I2ATM(L)= I2
      L1G_I3ATM(L)= I3
      L1G_VOBS(L) = ANGOBS
      L1G_EVAL(L) = 0.0
      L1G_DEV (L) = 3.0
      CHEM1       = L1A_CHEM(I1)
      CHEM2       = L1A_CHEM(I2)
      CHEM3       = L1A_CHEM(I3)
      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '
      IF(L1A_SYMB(I3).EQ.'H   '.OR.L1A_SYMB(I3).EQ.'D   ') CHEM3='H   '

      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '
        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2.AND.
     *                      ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM1.EQ.CHEM3.AND.ECHEM2.EQ.CHEM2.AND. 
     *                      ECHEM3.EQ.CHEM1)) THEN
          L1G_VAL(L) = LEG_ANGLE(I) 
          L1G_EVAL(L)= LEG_ANGLE(I) 
          GO TO 100
        ENDIF
      ENDDO
      AENER=0.0
      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '
        IF(ECHEM1(1:1).EQ.'.'.AND.ECHEM2.EQ.CHEM2.AND.
     *     ECHEM3(1:1).EQ.'.') AENER = LEG_ANGLE(I)
      ENDDO
      IF(AENER.GT.0.0) THEN
        DD = ABS(90.0-AENER)
        IF(ANGOBS.GT.165.0.AND.DD.LT.1.0) AENER=180.0
        L1G_VAL(L) = AENER 
        L1G_EVAL(L)= AENER
        WRITE(LINE,
     *'('' WARNING : '',A,'' : default angle value will used '')')
     *  MON
c        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,A4,A,F8.3,A,A4,A,A4,A,A4,A)')
     *'                 chem_type : ',CHEM1,'-',CHEM2,'-',CHEM3,' ',
     *AENER,' (',L1A_ANAME(I1),'-',L1A_ANAME(I2),'-',L1A_ANAME(I3),')'
c       CALL MSGDOC(MDOC,LINE)
        GO TO 100
      ENDIF

      IF(ANGOBS.GT.30.0) THEN
        L1G_VAL(L) = ANGOBS
        WRITE(LINE,
     *'('' WARNING : '',A,'' : observed angle value will used '')')
     *  MON
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,A4,A,F8.3,A,A4,A,A4,A,A4,A)')
     *'                 chem_type : ',CHEM1,'-',CHEM2,'-',CHEM3,' ',
     *ANGOBS,' (',L1A_ANAME(I1),'-',L1A_ANAME(I2),'-',L1A_ANAME(I3)
       CALL MSGDOC(MDOC,LINE)
      ELSE
        ANGOBS=109.47
        L1G_VAL(L) = ANGOBS
        WRITE(LINE,
     *'('' WARNING : '',A,'' : default angle value will used '')')
     *  MON
c        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(A,A4,A,A4,A,A4,A,F8.3,A,A4,A,A4,A,A4,A)')
     *'                 chem_type : ',CHEM1,'-',CHEM2,'-',CHEM3,' ',
     *ANGOBS,' (',L1A_ANAME(I1),'-',L1A_ANAME(I2),'-',L1A_ANAME(I3)
c       CALL MSGDOC(MDOC,LINE)
      ENDIF
  100 CONTINUE

      RETURN
      END            

      SUBROUTINE SET_VTORS(MDOC,I1,I2,I3,I4,NV,NC,IERR)
C -----------------------------------------------
C -P- SET_VANGL - 
C -S-
      INTEGER*4 MDOC,I1,I2,I3,I4,NV,IERR
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ******
      INTEGER   IRING(4)
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4,CHEM4*4,LINE*256
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4,ECHEM4*4
      CHARACTER RING1*3,RING2*3,RING3*3,RING4*3
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C --------------------------------------------------------
      IOBS = 0
      INEW = 0
      IERR = 0
      IF(I1.LE.0 .OR.I2.LE.0 .OR.I3.LE.0 .OR.I4.LE.0 .OR.
     *   I1.EQ.I2.OR.I1.EQ.I3.OR.I1.EQ.I4.OR.I2.EQ.I3.OR.
     *               I2.EQ.I4.OR.I3.EQ.I4 ) RETURN

      IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.L1A_COOR_FLAG(I2).EQ.'Y'.AND.
     *   L1A_COOR_FLAG(I3).EQ.'Y'.AND.L1A_COOR_FLAG(I4).EQ.'Y') THEN
        CALL CALC_TRSOBS(I1,I2,I3,I4,ANGOBS)
        IOBS = 1
      ELSE
        ANGOBS = 180.0
      ENDIF

      IF(L1T_NTORS.GE.MAX1TOR) THEN
        WRITE(LINE
     * ,'('' ERROR: number of tors. angles of monomer >'',I6)') 
     *    MAX1TOR
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC
     * ,'         Change parameter MAX1TOR in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF

      L1T_NTORS   = L1T_NTORS+1
      L           = L1T_NTORS
      L1T_1ATM(L) = L1A_ANAME(I1)
      L1T_2ATM(L) = L1A_ANAME(I2)
      L1T_3ATM(L) = L1A_ANAME(I3)
      L1T_4ATM(L) = L1A_ANAME(I4)
      L1T_I1ATM(L)= I1
      L1T_I2ATM(L)= I2
      L1T_I3ATM(L)= I3
      L1T_I4ATM(L)= I4
      L1T_VAL(L)  = ANGOBS
      L1T_VOBS(L) = ANGOBS
      L1T_FLAG(L) = 'N'
      IF(IOBS.EQ.1) L1T_FLAG(L) = 'C'
      L1T_DEV (L) = 20.0
      L1T_EVAL(L) = 0.0
      L1T_PRD (L) = 1

      CHEM1 = L1A_CHEM(I1)
      CALL CHECK_RING(CHEM1,RING1)
      CHEM2 = L1A_CHEM(I2)
      CALL CHECK_RING(CHEM2,RING2)
      CHEM3 = L1A_CHEM(I3)
      CALL CHECK_RING(CHEM3,RING3)
      CHEM4 = L1A_CHEM(I4)
      CALL CHECK_RING(CHEM4,RING4)

      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '
      IF(L1A_SYMB(I3).EQ.'H   '.OR.L1A_SYMB(I3).EQ.'D   ') CHEM3='H   '
      IF(L1A_SYMB(I4).EQ.'H   '.OR.L1A_SYMB(I4).EQ.'D   ') CHEM4='H   '

      DO I=1,LET_NTORS
        ECHEM1 = LET_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LET_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LET_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '
        ECHEM4 = LET_4ATM(I) 
        CALL LENSTR_BL(ECHEM4,LN)
        IF(ECHEM4(1:1).EQ.'H'.AND.LN.GT.2) ECHEM4='H   '

        IF((ECHEM2.EQ.CHEM2.AND.ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM2.EQ.CHEM3.AND.ECHEM3.EQ.CHEM2)) THEN

          L1T_VAL(L) = LET_ANGLE(I) 
          L1T_EVAL(L)= LET_ANGLE(I)
          L1T_PRD(L) = LET_PRD  (I) 

          IF(LET_CONST(I).GT.2.0) THEN
            L1T_LABEL(L) = 'CONST'

            IF(RING2(1:1).EQ.'R'.AND.RING3(1:1).EQ.'R') THEN
              IF(RING2(2:2).EQ.'R'.AND.RING2(2:2).EQ.RING3(2:2)) THEN 
                L1T_VAL(L) = 180.0
                IF(RING2(3:3).EQ.'5'.AND.RING1(2:2).EQ.RING4(2:2)) 
     *          L1T_VAL(L) = 0.0
              ELSE IF(RING2(2:2).EQ.'R'.AND.
     *                RING2(2:2).NE.RING3(2:2)) THEN 
                IF(RING4(1:1).EQ.'R') THEN 
                  L1T_VAL(L) = 180.0
                ELSE
                  L1T_VAL(L) = 0.0
                ENDIF
              ELSE IF(RING3(2:2).EQ.'R'.AND.
     *                RING2(2:2).NE.RING3(2:2)) THEN 
                IF(RING1(1:1).EQ.'R') THEN 
                  L1T_VAL(L) = 180.0
                ELSE
                  L1T_VAL(L) = 0.0
                ENDIF
              ELSE
                IF(RING1(1:1).EQ.RING4(1:1)) THEN 
                  L1T_VAL(L) = 0.0
                ELSE
                  L1T_VAL(L) = 180.0
                ENDIF
              ENDIF
            ENDIF

            L1T_EVAL(L) = L1T_VAL(L)

            IF(IOBS.EQ.1) THEN
              DEL = ABS(L1T_VAL(L)-ANGOBS)
              IF(DEL.GT.90.0.AND.DEL.LT.270.0) THEN
                L1T_VAL(L) = L1T_VAL(L) + 180.0
                IF(L1T_VAL(L).GE.360.0) L1T_VAL(L) = L1T_VAL(L)-360.0
              ENDIF
            ENDIF

            L1T_PRD (L) = 0
          ELSE
            L1T_VAL(L) = ANGOBS 
          ENDIF
          GO TO 100
        ENDIF

      ENDDO
      L1T_VAL(L) = ANGOBS
 100  CONTINUE

      IF(L1T_EVAL(L).LE.-180.0) L1T_EVAL(L) = L1T_EVAL(L) + 360.0
C --
      ID = 0 
      IF(L1T_PRD(L).NE.0.AND.L1P_NPLAN.GT.0) THEN
        DO  IP=1,L1P_NPLAN
          N = 0
          DO  I = 1,L1P_NATOM(IP)
            IATOM = L1P_ATOM(I,IP)
            IF(L1T_1ATM(L).EQ.ATOM) THEN
              N=N+1
              IRING(N) = L1T_I1ATM(L)
            ENDIF
            IF(L1T_2ATM(L).EQ.ATOM) THEN
              N=N+1
              IRING(N) = L1T_I2ATM(L)
            ENDIF
            IF(L1T_3ATM(L).EQ.ATOM) THEN
              N=N+1
              IRING(N) = L1T_I3ATM(L)
            ENDIF
            IF(L1T_4ATM(L).EQ.ATOM) THEN
              N=N+1
              IRING(N) = L1T_I4ATM(L)
            ENDIF
          ENDDO
          IF(N.GE.4) THEN
            L1T_PRD(L) = 0
            GO TO 200
          ELSE IF(N.EQ.3) THEN
            CALL CHECK_RING_ID(MDOC,IRING(1)
     *                        ,IRING(2),IRING(3),IRING(1),ID,PHI,IERR)
            IERR = 0
            IF(ID.GT.1) THEN
              L1T_PRD(L) = 0
              GO TO 200
            ENDIF 
          ENDIF
        ENDDO
      ENDIF
C --
 200  CONTINUE
      IF(L1T_PRD(L).GT.0) THEN
        NV = NV + 1
        WRITE(CHEM1,'(I4)') NV
        N = 4
        IF(CHEM1(1:1).EQ.' ') N=3 
        IF(CHEM1(2:2).EQ.' ') N=2 
        IF(CHEM1(3:3).EQ.' ') N=1 
        LINE(1:4)    = 'var_'
        LINE(5:N+4)  = CHEM1(5-N:4)
        L1T_LABEL(L) = LINE(1:N+4)
      ELSE
        NC = NC + 1
        WRITE(CHEM1,'(I4)') NC
        N = 4
        IF(CHEM1(1:1).EQ.' ') N=3 
        IF(CHEM1(2:2).EQ.' ') N=2 
        IF(CHEM1(3:3).EQ.' ') N=1 
        LINE(1:6) = 'CONST_'
        IF(N.GT.2) N = 2
        LINE(7:N+6)  = CHEM1(5-N:4)
        L1T_LABEL(L) = LINE(1:N+6)
        L1T_DEV (L)  = 0.0
      ENDIF

C     CALL CHECK_RING_ID(MDOC,I1,I2,I3,I4,ID,PHI,IERR)

      IF(LINE(1:5).EQ.'CONST') THEN
        IF(ABS(ID).GT.0) THEN
          L1T_VAL(L) = PHI
          IF(IOBS.EQ.0) L1T_VOBS(L) = PHI
        ENDIF
      ELSE
        IF(IOBS.EQ.0) THEN
          IF(ID.GT.0) THEN
            L1T_VAL(L)  = PHI
            L1T_VOBS(L) = PHI
C         ENDIF
          ELSE  
            IF(L1T_VAL(L).LT.5.0) THEN
              L1T_VAL(L) = 5.0          
            ELSE IF(L1T_VAL(L).GT.175.0) THEN
              L1T_VAL(L) = 175.0          
            ENDIF
          ENDIF
        ENDIF
      ENDIF


      RETURN
      END            

      SUBROUTINE CHECK_RING_ID(MDOC,N1,N2,N3,N4,ID,PHI,IERR)
C -----------------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LINE*256
C ---
      INCLUDE 'lib_com.fh' 
C -----------------------------------------------------
      IERR  = 0
      IRING = 0
      NR1  = L1A_NRING(N1)
      NR2  = L1A_NRING(N2)
      NR3  = L1A_NRING(N3)
      NR4  = L1A_NRING(N4)
      ID   = 0
      ID1  = 0
      ID4  = 0
      PHI  = 0.0  
      IFLAT= 0 
C ---
      IF(NR2.GT.0) THEN
        DO I2=1,NR2
          IR2 = L1A_RING_ID(I2,N2) 
          IF(NR3.GT.0) THEN
            DO I3=1,NR3
              IR3 = L1A_RING_ID(I3,N3)
              IF(IR2.EQ.IR3) THEN
                IF(L1A_RING_FLAT(I3,N3).GT.0) IFLAT = 1
                ID = 1
                IF(NR1.GT.0) THEN
                  DO I1=1,NR1
                    IR1 = L1A_RING_ID(I1,N1)
                    IF(IR1.EQ.IR2) THEN
                      ID1 = 1
                      ID  = 2
                      IF(NR4.GT.0) THEN
                        DO I4=1,NR4
                          IR4 = L1A_RING_ID(I4,N4)
                          IF(IR1.EQ.IR4) THEN
                            ID4 = 2
                            ID1 = 2
                            IRING = IR1
                            ID  = 3
                            GO TO 100
                          ENDIF
                        ENDDO
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF

                IF(NR4.GT.0) THEN
                  DO I4=1,NR4
                    IR4 = L1A_RING_ID(I4,N4)
                    IF(IR4.EQ.IR2) THEN
                      ID4 = 1
                      ID  = 2
                      IF(NR1.GT.0) THEN
                        DO I1=1,NR1
                          IR1 = L1A_RING_ID(I1,N1)
                          IF(IR1.EQ.IR4) THEN
                            ID1 = 2
                            ID4 = 2
                            IRING = IR1
                            ID  = 3
                            GO TO 100
                          ENDIF
                        ENDDO
                      ENDIF
                    ENDIF
                  ENDDO
                ENDIF
              ENDIF 
            ENDDO
          ENDIF
        ENDDO
      ENDIF
  100 CONTINUE
      PHI = 0.0
      IF(ID1.EQ.1.OR.ID4.EQ.1) PHI = 180.0
      IF(IFLAT.LE.0) ID = -ID 
C ---
      RETURN
      END

      SUBROUTINE SRCH_BOND(MDOC,MON,I1,I2,VAL,LB,IERR)
C -----------------------------------------------
C -P- 
C -S-
      REAL      VAL
      INTEGER*4 MDOC,I1,I2,LB,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
c     CHARACTER LINE*256
      CHARACTER ATOM1*4,ATOM2*4
      CHARACTER CHEM1*4,CHEM2*4
      CHARACTER ECHEM1*4,ECHEM2*4
C --------------------------------------------------------
      IERR  = 0
      VAL   = 0.0
c     M     =-ABS(MDOC)-1
      NBOND = L1B_NBOND
      IF(NBOND.LE.0.OR.I1.LE.0.OR.I2.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
      ATOM1 = L1A_ANAME(I1)
      ATOM2 = L1A_ANAME(I2)
      DO J=1,NBOND
        IF((L1B_1ATM(J).EQ.ATOM1.AND.L1B_2ATM(J).EQ.ATOM2).OR.
     *     (L1B_1ATM(J).EQ.ATOM2.AND.L1B_2ATM(J).EQ.ATOM1)) THEN
          VAL = L1B_VAL(J) 
          LB  = J
          GO TO 100
        ENDIF
      ENDDO
      IERR = 2

      CHEM1 = L1A_CHEM(I1)
      CHEM2 = L1A_CHEM(I2)
      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '

      DO J=1,LEB_NBOND
        ECHEM1 = LEB_1ATM(J)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEB_2ATM(J) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2).OR.
     *     (ECHEM1.EQ.CHEM2.AND.ECHEM2.EQ.CHEM1)) THEN
          VAL  = LEB_LENGTH(J) 
          IERR = 3
          GO TO 100
        ENDIF
      ENDDO
      D1 = 0.0
      D2 = 0.0
      DO J=1,LEB_NBOND
        ECHEM1 = LEB_1ATM(J)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEB_2ATM(J) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '

        IF(ECHEM1.EQ.CHEM1.AND.ECHEM2(1:1).EQ.'.') THEN
          D1 = LEB_LENGTH(J) 
        ENDIF
        IF(ECHEM1.EQ.CHEM2.AND.ECHEM2(1:1).EQ.'.') THEN
          D2 = LEB_LENGTH(J) 
        ENDIF
      ENDDO
      IF(D1.GT.0.0.AND.D2.GT.0.0) THEN
        VAL  = (D1+D2)/2.0 
        IERR = 3
      ENDIF
 100  CONTINUE

      RETURN
      END

      SUBROUTINE SRCH_ANGL(MDOC,MON,I1,I2,I3,VAL,LG,IERR)
C -----------------------------------------------
C -P- 
C -S-
      REAL      VAL
      INTEGER*4 MDOC,I1,I2,I3,LG,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
c     CHARACTER LINE*256
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4
C --------------------------------------------------------
      IERR  = 0
      VAL   = 0.0
      LG    = 0
c     M     =-ABS(MDOC)-1  
      NANGL = L1G_NANGL
      IF(NANGL.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
      ATOM1 = L1A_ANAME(I1)
      ATOM2 = L1A_ANAME(I2)
      ATOM3 = L1A_ANAME(I3)
      DO I=1,NANGL
        IF((L1G_1ATM(I).EQ.ATOM1.AND.L1G_2ATM(I).EQ.ATOM2.AND.
     *                               L1G_3ATM(I).EQ.ATOM3).OR.
     *     (L1G_1ATM(I).EQ.ATOM3.AND.L1G_2ATM(I).EQ.ATOM2.AND. 
     *                               L1G_3ATM(I).EQ.ATOM1)) THEN
          VAL = L1G_VAL(I) 
          LG  = I
          GO TO 100
        ENDIF
      ENDDO
      IERR  = 2
      CHEM1 = L1A_CHEM(I1)
      CHEM2 = L1A_CHEM(I2)
      CHEM3 = L1A_CHEM(I3)
      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '
      IF(L1A_SYMB(I3).EQ.'H   '.OR.L1A_SYMB(I3).EQ.'D   ') CHEM3='H   '

      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2.AND.
     *                               ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM1.EQ.CHEM3.AND.ECHEM2.EQ.CHEM2.AND. 
     *                               ECHEM3.EQ.CHEM1)) THEN
          VAL  = LEG_ANGLE(I) 
          IERR = 3
          GO TO 100
        ENDIF
      ENDDO
      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF(ECHEM1(1:1).EQ.'.'  .AND.
     *     ECHEM2     .EQ.CHEM2.AND.
     *     ECHEM3(1:1).EQ.'.') THEN
          VAL = LEG_ANGLE(I) 
          IF(VAL.GT.0.0) THEN
            IERR = 3
            GO TO 100
          ENDIF
        ENDIF
      ENDDO
 100  CONTINUE
      RETURN
      END

      SUBROUTINE SRCH_ANGL_2(MDOC,MON,I1,I2,I3,VAL,LG,IERR)
C -----------------------------------------------
C -P- 
C -S-
      REAL      VAL
      INTEGER*4 MDOC,I1,I2,I3,LG,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C     CHARACTER LINE*256
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4
C --------------------------------------------------------
      IERR  = 0
      VAL   = 0.0
c     M     =-ABS(MDOC)-1  
      NANGL = L2G_NANGL
      IF(NANGL.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
      ATOM1 = L2A_ANAME(I1)
      ATOM2 = L2A_ANAME(I2)
      ATOM3 = L2A_ANAME(I3)
      DO I=1,NANGL
        IF((L2G_1ATM(I).EQ.ATOM1.AND.L2G_2ATM(I).EQ.ATOM2.AND.
     *                               L2G_3ATM(I).EQ.ATOM3).OR.
     *     (L2G_1ATM(I).EQ.ATOM3.AND.L2G_2ATM(I).EQ.ATOM2.AND. 
     *                               L2G_3ATM(I).EQ.ATOM1)) THEN
          VAL = L2G_VAL(I) 
          LG  = I
          GO TO 100
        ENDIF
      ENDDO
      IERR  = 2
      CHEM1 = L2A_CHEM(I1)
      CHEM2 = L2A_CHEM(I2)
      CHEM3 = L2A_CHEM(I3)
      IF(L2A_SYMB(I1).EQ.'H   '.OR.L2A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L2A_SYMB(I2).EQ.'H   '.OR.L2A_SYMB(I2).EQ.'D   ') CHEM2='H   '
      IF(L2A_SYMB(I3).EQ.'H   '.OR.L2A_SYMB(I3).EQ.'D   ') CHEM3='H   '

      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2.AND.
     *                               ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM1.EQ.CHEM3.AND.ECHEM2.EQ.CHEM2.AND. 
     *                               ECHEM3.EQ.CHEM1)) THEN
          VAL  = LEG_ANGLE(I) 
          IERR = 3
          GO TO 100
        ENDIF
      ENDDO
      DO I=1,LEG_NANGL
        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF(ECHEM1(1:1).EQ.'.'  .AND.
     *     ECHEM2     .EQ.CHEM2.AND.
     *     ECHEM3(1:1).EQ.'.') THEN
          VAL = LEG_ANGLE(I) 
          IF(VAL.GT.0.0) THEN
            IERR = 3
            GO TO 100
          ENDIF
        ENDIF
      ENDDO
 100  CONTINUE
      RETURN
      END

      SUBROUTINE SRCH_ANGL_L(MDOC,MON,I1,I2,I3,IF1,IF2,IF3,VAL,LG,IERR)
C -----------------------------------------------
C      1 -- 2 --- 3
C   IF1=2      ! IF3=1
C        IF2=2 !

      REAL      VAL
      INTEGER*4 MDOC,I1,I2,I3,LG,IERR,IF1,IF2,IF3
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
c     CHARACTER LINE*256
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4
C --------------------------------------------------------
      IERR  = 0
      VAL   = 0.0
c     M     =-ABS(MDOC)-1  
      NANGL = LLG_NANGL
      IF(NANGL.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
      IF(IF1.EQ.1) THEN
        JF1   = 2
        ATOM1 = L1A_ANAME(I1)
      ELSE
        JF1   = 1
        ATOM1 = L2A_ANAME(I1)
      ENDIF
      IF(IF2.EQ.1) THEN
        JF2   = 2
        ATOM2 = L1A_ANAME(I2)
      ELSE
        JF2   = 1
        ATOM2 = L2A_ANAME(I2)
      ENDIF
      IF(IF3.EQ.1) THEN
        JF3   = 2
        ATOM3 = L1A_ANAME(I3)
      ELSE
        JF3   = 1
        ATOM3 = L2A_ANAME(I3)
      ENDIF
      DO I=1,NANGL
        IF((LLG_1ATM(I) .EQ.ATOM1.AND.LLG_2ATM(I) .EQ.ATOM2.AND.
     *      LLG_F1ATM(I).EQ.JF1  .AND.LLG_F2ATM(I).EQ.JF2  .AND.
     *      LLG_F3ATM(I).EQ.JF3  .AND.LLG_3ATM(I) .EQ.ATOM3     ).OR.
     *     (LLG_1ATM(I) .EQ.ATOM3.AND.LLG_2ATM(I) .EQ.ATOM2.AND. 
     *      LLG_F1ATM(I).EQ.JF3  .AND.LLG_F2ATM(I).EQ.JF2  .AND.
     *      LLG_F3ATM(I).EQ.JF1  .AND.LLG_3ATM(I) .EQ.ATOM1     )) THEN
          VAL = LLG_VAL(I) 
          LG  = I
          GO TO 100
        ENDIF
      ENDDO
      IERR  = 2
      IF(IF1.EQ.1) THEN
        CHEM1 = L1A_CHEM(I1)
        IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ')CHEM1='H   '
      ELSE
        CHEM1 = L2A_CHEM(I1)
        IF(L2A_SYMB(I1).EQ.'H   '.OR.L2A_SYMB(I1).EQ.'D   ')CHEM1='H   '
      ENDIF
      IF(IF2.EQ.1) THEN
        CHEM2 = L1A_CHEM(I2)
        IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ')CHEM2='H   '
      ELSE
        CHEM2 = L2A_CHEM(I2)
        IF(L2A_SYMB(I2).EQ.'H   '.OR.L2A_SYMB(I2).EQ.'D   ')CHEM2='H   '
      ENDIF
      IF(IF3.EQ.1) THEN
        CHEM3 = L1A_CHEM(I3)
        IF(L1A_SYMB(I3).EQ.'H   '.OR.L1A_SYMB(I3).EQ.'D   ')CHEM3='H   '
      ELSE
        CHEM3 = L2A_CHEM(I3)
        IF(L2A_SYMB(I3).EQ.'H   '.OR.L2A_SYMB(I3).EQ.'D   ')CHEM3='H   '
      ENDIF

      DO I=1,LEG_NANGL

        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF((ECHEM1.EQ.CHEM1.AND.ECHEM2.EQ.CHEM2.AND.
     *                               ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM1.EQ.CHEM3.AND.ECHEM2.EQ.CHEM2.AND. 
     *                               ECHEM3.EQ.CHEM1)) THEN
          VAL  = LEG_ANGLE(I) 
          IERR = 3
          GO TO 100
        ENDIF
      ENDDO
      DO I=1,LEG_NANGL

        ECHEM1 = LEG_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LEG_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LEG_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '

        IF(ECHEM1(1:1).EQ.'.'  .AND.
     *     ECHEM2     .EQ.CHEM2.AND.
     *     ECHEM3(1:1).EQ.'.') THEN
          VAL = LEG_ANGLE(I) 
          IF(VAL.GT.0.0) THEN
            IERR = 3
            GO TO 100
          ENDIF
        ENDIF
      ENDDO
 100  CONTINUE
      RETURN
      END

      SUBROUTINE SRCH_TORS(MDOC,MON,I1,I2,I3,I4,VAL,LT,INV,IERR)
C -----------------------------------------------
C -P- 
C -S-
      REAL      VAL
      INTEGER*4 MDOC,I1,I2,I3,I4,LT,INV,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ******
C     CHARACTER LINE*256
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4,ATOM4*4
      CHARACTER CHEM1*4,CHEM2*4,CHEM3*4,CHEM4*4
      CHARACTER ECHEM1*4,ECHEM2*4,ECHEM3*4,ECHEM4*4
      CHARACTER RING1*3,RING2*3,RING3*3,RING4*3
C     CHARACTER LABEL*8
CC --------------------------------------------------------
      IERR  = 0
      VAL   = 0.0
      INV   = 1
C     M     =-ABS(MDOC)-1  
      NTORS = L1T_NTORS
      IF(NTORS.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0.OR.I4.LE.0) 
     *THEN
        IERR = 1
        RETURN
      ENDIF
      ATOM1 = L1A_ANAME(I1)
      ATOM2 = L1A_ANAME(I2)
      ATOM3 = L1A_ANAME(I3)
      ATOM4 = L1A_ANAME(I4)
      DO I=1,NTORS
        IF(L1T_2ATM(I).EQ.ATOM2.AND.L1T_3ATM(I).EQ.ATOM3) THEN
          IF(L1T_1ATM(I).EQ.ATOM1.AND.L1T_4ATM(I).EQ.ATOM4) THEN
            VAL = L1T_VAL(I) 
            LT  = I
            INV = 1
            GO TO 100
          ENDIF
        ELSE IF(L1T_2ATM(I).EQ.ATOM3.AND.L1T_3ATM(I).EQ.ATOM2) THEN
          IF(L1T_1ATM(I).EQ.ATOM4.AND.L1T_4ATM(I).EQ.ATOM1) THEN
            VAL = L1T_VAL(I) 
            LT  = I
            INV =-1
            GO TO 100
          ENDIF
        ENDIF
      ENDDO
      IERR=2

C      IPRD =L1T_PRD (L)
C      VAL  =L1T_VAL (L)
C      LABEL=L1T_LABEL(L)

      CHEM1 = L1A_CHEM(I1)
      CALL CHECK_RING(CHEM1,RING1)
      CHEM2 = L1A_CHEM(I2)
      CALL CHECK_RING(CHEM2,RING2)
      CHEM3 = L1A_CHEM(I3)
      CALL CHECK_RING(CHEM3,RING3)
      CHEM4 = L1A_CHEM(I4)
      CALL CHECK_RING(CHEM4,RING4)
      IF(L1A_SYMB(I1).EQ.'H   '.OR.L1A_SYMB(I1).EQ.'D   ') CHEM1='H   '
      IF(L1A_SYMB(I2).EQ.'H   '.OR.L1A_SYMB(I2).EQ.'D   ') CHEM2='H   '
      IF(L1A_SYMB(I3).EQ.'H   '.OR.L1A_SYMB(I3).EQ.'D   ') CHEM3='H   '
      IF(L1A_SYMB(I4).EQ.'H   '.OR.L1A_SYMB(I4).EQ.'D   ') CHEM4='H   '


      DO I=1,LET_NTORS
        ECHEM1 = LET_1ATM(I)
        CALL LENSTR_BL(ECHEM1,LN)
        IF(ECHEM1(1:1).EQ.'H'.AND.LN.GT.2) ECHEM1='H   '
        ECHEM2 = LET_2ATM(I) 
        CALL LENSTR_BL(ECHEM2,LN)
        IF(ECHEM2(1:1).EQ.'H'.AND.LN.GT.2) ECHEM2='H   '
        ECHEM3 = LET_3ATM(I) 
        CALL LENSTR_BL(ECHEM3,LN)
        IF(ECHEM3(1:1).EQ.'H'.AND.LN.GT.2) ECHEM3='H   '
        ECHEM4 = LET_4ATM(I) 
        CALL LENSTR_BL(ECHEM4,LN)
        IF(ECHEM4(1:1).EQ.'H'.AND.LN.GT.2) ECHEM4='H   '

        IF((ECHEM2.EQ.CHEM2.AND.ECHEM3.EQ.CHEM3).OR.
     *     (ECHEM2.EQ.CHEM3.AND.ECHEM3.EQ.CHEM2)) THEN
          VAL  = LET_ANGLE(I) 
          IPRD = LET_PRD  (I) 
          IF(LET_CONST(I).GT.2.0) THEN

C            LABEL  ='CONST'

            IPRD = 0
            IF(RING2(1:1).EQ.'R'.AND.RING3(1:1).EQ.'R') THEN
              IF(RING2(2:2).EQ.'R'.AND.RING2(2:2).EQ.RING3(2:2)) THEN 
                VAL = 180.0
                IF(RING2(3:3).EQ.'5'.AND.RING1(2:2).EQ.RING4(2:2)) 
     *          VAL = 0.0
              ELSE IF(RING2(2:2).EQ.'R'.AND.
     *                RING2(2:2).NE.RING3(2:2)) THEN 
                IF(RING4(1:1).EQ.'R') THEN 
                  VAL = 180.0
                ELSE
                  VAL = 0.0
                ENDIF
              ELSE IF(RING3(2:2).EQ.'R'.AND.
     *                RING2(2:2).NE.RING3(2:2)) THEN 
                IF(RING1(1:1).EQ.'R') THEN 
                  VAL = 180.0
                ELSE
                  VAL = 0.0
                ENDIF
              ELSE
                IF(RING1(1:1).EQ.RING4(1:1)) THEN 
                  VAL = 0.0
                ELSE
                  VAL = 180.0
                ENDIF
              ENDIF
            ENDIF
            
          ELSE

          ENDIF
          IERR = 3
          GO TO 100
        ENDIF
      ENDDO

 100  CONTINUE

      RETURN
      END

      SUBROUTINE SRCH_CHIR(MDOC,MON,I1,I2,I3,I4,VOL,LC,IS,IERR)
C -----------------------------------------------
C -P- 
C -S-
      REAL      VOL
      INTEGER*4 MDOC,I1,I2,I3,I4,LC,IS,IERR
      CHARACTER MON*8,SIGN*8
C ---
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ******
C     CHARACTER LINE*256
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4,ATOM4*4
C --------------------------------------------------------
C     M     =-ABS(MDOC)-1       
      IERR  = 0
      LC    = 0
      NCHIR = L1C_NCHIR
      IF(NCHIR.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0.OR.I4.LE.0) 
     *THEN
        IERR = 1
        RETURN
      ENDIF
      ATOM1 = L1A_ANAME(I1)
      ATOM2 = L1A_ANAME(I2)
      ATOM3 = L1A_ANAME(I3)
      ATOM4 = L1A_ANAME(I4)
      DO I=1,NCHIR
        IF(L1C_1ATM(I).EQ.ATOM1.AND.
     *     L1C_SIGN(I)(1:4).NE.'star'.AND.
     *     L1C_SIGN(I)(1:4).NE.'cros'     ) THEN

          IF((L1C_2ATM(I).EQ.ATOM2.AND.L1C_3ATM(I).EQ.ATOM3.AND.
     *        L1C_4ATM(I).EQ.ATOM4).OR.
     *       (L1C_3ATM(I).EQ.ATOM2.AND.L1C_4ATM(I).EQ.ATOM3.AND.
     *        L1C_2ATM(I).EQ.ATOM4).OR.
     *       (L1C_4ATM(I).EQ.ATOM2.AND.L1C_2ATM(I).EQ.ATOM3.AND.
     *        L1C_3ATM(I).EQ.ATOM4) ) THEN
            VOL  = L1C_VOL(I) 
            SIGN = L1C_SIGN(I) 
            IF(SIGN(1:4).EQ.'both') THEN
              IF(L1C_FLAG(I).EQ.'R') SIGN = 'positiv'
              IF(L1C_FLAG(I).EQ.'L') SIGN = 'negativ'
            ENDIF
            LC   = I
            IS   = 1
            IF(SIGN(1:3).EQ.'neg') IS =-1
            GO TO 100
          ELSE IF((L1C_3ATM(I).EQ.ATOM2.AND.L1C_2ATM(I).EQ.ATOM3.AND.
     *        L1C_4ATM(I).EQ.ATOM4).OR.
     *       (L1C_2ATM(I).EQ.ATOM2.AND.L1C_4ATM(I).EQ.ATOM3.AND.
     *        L1C_3ATM(I).EQ.ATOM4).OR.
     *       (L1C_4ATM(I).EQ.ATOM2.AND.L1C_3ATM(I).EQ.ATOM3.AND.
     *        L1C_2ATM(I).EQ.ATOM4)) THEN
            VOL  = L1C_VOL(I) 
            SIGN = L1C_SIGN(I) 
            IF(SIGN(1:4).EQ.'both') THEN
              IF(L1C_FLAG(I).EQ.'R') SIGN = 'positiv'
              IF(L1C_FLAG(I).EQ.'L') SIGN = 'negativ'
            ENDIF
            LC   = I
            IS   = 1
            IF(SIGN(1:3).EQ.'neg') IS =-1
            IS = IS*(-1)
            GO TO 100
          ENDIF

        ENDIF
      ENDDO
      IERR = 2
C ---------------------------------------
 100  CONTINUE
      RETURN
      END

      SUBROUTINE SRCH_CHIR_CENTRE(MDOC,MON,I1,LC,IERR)
C -----------------------------------------------
C -P- 
C -S-
C     REAL      VOL
      INTEGER*4 MDOC,I1,LC,IERR
C     INTEGER*4 I2,I3,I4,IS
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER ATOM1*4
C     CHARACTER ATOM2*4,ATOM3*4,ATOM4*4,SIGN*8
C     CHARACTER LINE*256
C --------------------------------------------------------
C     M     =-ABS(MDOC)-1  
      IERR  = 0
      NCHIR = L1C_NCHIR
      IF(NCHIR.LE.0.OR.I1.LE.0) THEN
        LC = 0
        RETURN
      ENDIF

      ATOM1 = L1A_ANAME(I1)
      DO I=1,NCHIR
        IF(L1C_1ATM(I).EQ.ATOM1.AND.
     *     L1C_SIGN(I)(1:4).NE.'star'.AND.
     *     L1C_SIGN(I)(1:4).NE.'cros'     ) THEN
          LC = I
          RETURN
        ENDIF
      ENDDO
      LC = 0
C ---------------------------------------
      RETURN
      END


      SUBROUTINE SRCH_CHIR_CENTRE_L(MDOC,LINK,ATOM,LC,IERR)
C -----------------------------------------------
C -P- 
C -S-
C     REAL      VOL
      INTEGER*4 MDOC,LC,IERR
C     INTEGER*4 I1,I2,I3,I4,IS
      CHARACTER LINK*8
C     CHARACTER SIGN*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER ATOM*4
C     CHARACTER LINE*80
C
C    *,LLC_VOL,LLC_NCHIR,LLC_F1ATM,LLC_F2ATM,LLC_F3ATM,LLC_F4ATM
C    *,LLC_1ATM,LLC_2ATM,LLC_3ATM,LLC_4ATM,LLC_LNAME,LLC_SIGN
C --------------------------------------------------------
C     M     =-ABS(MDOC)-1  
      IERR  = 0
      NCHIR = LLC_NCHIR
      IF(NCHIR.LE.0) THEN
        LC = 0
        RETURN
      ENDIF

      DO I=1,NCHIR
        IF(LINK.EQ.LLL_LNAME(I).AND.LLC_1ATM(I).EQ.ATOM.AND.
     *     L1C_SIGN(I)(1:4).NE.'star'.AND.
     *     L1C_SIGN(I)(1:4).NE.'cros'     ) THEN
          LC = I
          RETURN
        ENDIF
      ENDDO
      LC = 0
C ---------------------------------------
      RETURN
      END

      SUBROUTINE SRCH_CHIR_CENTRE_2(MDOC,ATOM,LC
     *  ,ATOM2,ATOM3,ATOM4,IS,IERR)
C -----------------------------------------------
C -P- 
C -S-
      INTEGER*4 MDOC,LC,IS,IERR
C     INTEGER*4 I1,I2,I3,I4
      CHARACTER SIGN*8
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER ATOM*4,ATOM2*4,ATOM3*4,ATOM4*4
C     CHARACTER LINE*256
C --------------------------------------------------------
C     M     =-ABS(MDOC)-1  
      IERR  = 0
      NCHIR = L2C_NCHIR
      IF(NCHIR.LE.0) THEN
        LC = 0
        RETURN
      ENDIF

      DO I=1,NCHIR
        IF(L2C_1ATM(I).EQ.ATOM.AND.
     *     L1C_SIGN(I)(1:4).NE.'star'.AND.
     *     L1C_SIGN(I)(1:4).NE.'cros'     ) THEN
          LC    = I
          ATOM2 = L2C_2ATM(I)
          ATOM3 = L2C_3ATM(I)
          ATOM4 = L2C_4ATM(I)
          SIGN  = L2C_SIGN(I) 
          IS    = 0
          IF(SIGN(1:3).EQ.'pos') IS = 1
          IF(SIGN(1:3).EQ.'neg') IS =-1
          RETURN
        ENDIF
      ENDDO
      LC = 0
C ---------------------------------------
      RETURN
      END

      SUBROUTINE CHECK_RING(TYPE,RING)
C -----------------------------------------------
C -P-  - 
C -S-
C ******
      CHARACTER TYPE*4
      CHARACTER RING*3
C --------------------------------------------------------
      IF(TYPE(1:3).EQ.'CR5'.OR.TYPE.EQ.'CR15'.OR.TYPE.EQ.'NRD5'.OR.
     *   TYPE(1:3).EQ.'NR5'.OR.TYPE.EQ.'NR15') THEN
        RING = 'R5 '
      ELSE IF(TYPE.EQ.'NR16'.OR.TYPE.EQ.'CR16'.OR.TYPE.EQ.'NRD6'.OR.
     *     TYPE(1:3).EQ.'NR6'.OR.TYPE(1:3).EQ.'CR6') THEN
        RING = 'R6 '
      ELSE IF(TYPE.EQ.'CR66'.OR.TYPE.EQ.'NR66') THEN
        RING = 'RR6'
      ELSE IF(TYPE.EQ.'CR56'.OR.TYPE.EQ.'NR56') THEN
        RING = 'RR5'
      ELSE IF(TYPE.EQ.'CR55'.OR.TYPE.EQ.'NR55') THEN
        RING = 'RRR'
      ELSE
        RING = 'N  '
      ENDIF
      RETURN
      END

      SUBROUTINE SRCH_PLAN(MDOC,MON,I1,I2,I3,I4,LP,IERR)
C -----------------------------------------------
C 
C 
      INTEGER*4 MDOC,IERR
      CHARACTER ATOM1*4,ATOM2*4,ATOM3*4,ATOM4*4,MON*8
C ---
      INCLUDE 'lib_com.fh'
C ---
C     REAL      DOBS    (MAX1APL)
C     INTEGER*4 IATM    (MAX1APL)
C     INTEGER*4 JATM    (MAX1APL)
C     CHARACTER LINE*256
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C --------------------------------------------------------
C     M     =-ABS(MDOC)-1  
      IERR  = 0
      NPLAN = L1P_NPLAN
      LP    = 0
      IF(NPLAN.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0.OR.I4.LE.0) 
     *THEN
        IERR = 1
        RETURN
      ENDIF

      ATOM1 = L1A_ANAME(I1)
      ATOM2 = L1A_ANAME(I2)
      ATOM3 = L1A_ANAME(I3)
      ATOM4 = L1A_ANAME(I4)

      DO  IP=1,NPLAN
        IF(L1P_NATOM(IP).GE.4) THEN
          N = 0
          DO  I = 1,L1P_NATOM(IP)
            IATOM  = L1P_ATOM(I,IP)
            IF(ATOM.EQ.ATOM1) N = N + 1
            IF(ATOM.EQ.ATOM2) N = N + 1
            IF(ATOM.EQ.ATOM3) N = N + 1
            IF(ATOM.EQ.ATOM4) N = N + 1
          ENDDO
          IF(N.GE.4) THEN
            LP = IP
            GO TO 100
          ENDIF
        ENDIF
      ENDDO
  100 CONTINUE
      RETURN
      END

C ******
      SUBROUTINE PLAN_RSTR(MDOC,IERR)
C -----------------------------------------------
C -P- PLAN_RSTR -
C -S-
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
      REAL      DOBS    (MAX1APL)
      INTEGER*4 IATM    (MAX1APL)
      INTEGER*4 JATM    (MAX1APL)
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C --------------------------------------------------------
      IERR = 0
      IF(L1P_NPLAN.GT.0) THEN
        DO  IP=1,L1P_NPLAN
          IF(L1P_NATOM(IP).GE.4) THEN
            N = 0
            DO  I = 1,L1P_NATOM(IP)
              IATOM          = L1P_ATOM(I,IP)
              L1P_DOBS(I,IP) = 0.0
              DO  J = 1,L1A_NATOM
                IF(ATOM.EQ.L1A_ANAME(J)) THEN
                  IF(L1A_COOR_FLAG(J).EQ.'Y') THEN
                    N       = N + 1
                    IATM(N) = J
                    JATM(N) = I 
                  ENDIF
                  GO TO 100  
                ENDIF
              ENDDO
  100         CONTINUE
            ENDDO 
            IF(N.GE.4) THEN
              CALL CALC_PLDEV(N,IATM,DOBS)
              DO J=1,N
                JJ              = JATM(J)
                L1P_DOBS(JJ,IP) = DOBS(J)
              ENDDO
            ENDIF
          ENDIF
        ENDDO
      ENDIF
      RETURN
      END


C ******
      SUBROUTINE CALC_DOBS(I1,I2,DOBS)
C -----------------------------------------------
C -P- CALC_DOBS - 
C -S-
      REAL      DOBS
      INTEGER*4 I1,I2
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------------------------
      DOBS = 0.0
      IF(I1.LE.0.OR.I2.LE.0) RETURN
      X1   = L1A_X(I1)
      Y1   = L1A_Y(I1)
      Z1   = L1A_Z(I1)
      X2   = L1A_X(I2)
      Y2   = L1A_Y(I2)
      Z2   = L1A_Z(I2)
      DX   = X1-X2
      DY   = Y1-Y2
      DZ   = Z1-Z2

      DOBS = SQRT(ABS(DX*DX+DY*DY+DZ*DZ))

      RETURN
      END

C ******
      SUBROUTINE CALC_ANGOBS(I1,I2,I3,ANGOBS)
C -----------------------------------------------
C -P- CALC_ANGOBS - 
C -S-
C                         IA1        IA2      IA3
C               I3 - 1 -> I2  - 2 -> I1 - 3 -> I
      REAL      ANGOBS
      INTEGER*4 I1,I2,I3
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------
      ANGOBS = 0.0
      IF(I1.LE.0.OR.I2.LE.0.OR.I3.LE.0) RETURN
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      X1 = L1A_X(I1)
      Y1 = L1A_Y(I1)
      Z1 = L1A_Z(I1)
      X2 = L1A_X(I2)
      Y2 = L1A_Y(I2)
      Z2 = L1A_Z(I2)
      X3 = L1A_X(I3)
      Y3 = L1A_Y(I3)
      Z3 = L1A_Z(I3)

      A3 = X3-X2
      B3 = Y3-Y2
      C3 = Z3-Z2

      IF(I1.EQ.0) THEN
        A2 = 1.
        B2 = 0.
        C2 = 0.
      ELSE
        A2 = X2-X1
        B2 = Y2-Y1
        C2 = Z2-Z1
      ENDIF

      AMOD   = SQRT(A2*A2+B2*B2+C2*C2)*SQRT(ABS(A3*A3+B3*B3+C3*C3))
      T      = AMOD
      IF(T.LT.1.0E-8) T = 1.0
      COST   = (A3*A2+B3*B2+C3*C2)/T
      IF(COST.GT. 1.0) COST = 1.0
      IF(COST.LT.-1.0) COST =-1.0
      ANGOBS = ACOS(COST)
      ANGOBS = PI-ANGOBS
C ???
      IF(ANGOBS.GT. PI) ANGOBS = ANGOBS - TWOPI
      IF(ANGOBS.LT.-PI) ANGOBS = ANGOBS + TWOPI
      ANGOBS = ANGOBS/PI180

      RETURN
      END

      SUBROUTINE CALC_TRSOBS(I1,I2,I3,I4,ANGOBS)
C -----------------------------------------------
C -P- CALC_TRSOBS - 
C -S-
C              IA1        IA2        IA3      IA4
C               I3 - 1 -> I2  - 2 -> I1 - 3 -> I
C ---
      REAL      ANGOBS
      INTEGER*4 I1,I2,I3,I4
C ---
      REAL    V1(3),V2(3)      
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------
      ANGOBS = 0.0
      IF(I3.LE.0.OR.I4.LE.0) RETURN
      PI     = 4.0*ATAN(1.0)
      TWOPI  = 2.0*PI
      PI180  = PI/180.0
C ---
      X3  = L1A_X(I3)
      Y3  = L1A_Y(I3)
      Z3  = L1A_Z(I3)
      X4  = L1A_X(I4)
      Y4  = L1A_Y(I4)
      Z4  = L1A_Z(I4)
      II2 = I2 
      II1 = I1
 100  CONTINUE
      IF(II2.GT.0) THEN
        X2 = L1A_X(II2)
        Y2 = L1A_Y(II2)
        Z2 = L1A_Z(II2)
        IF(II1.GT.0) THEN 
          X1 = L1A_X(II1)
          Y1 = L1A_Y(II1)
          Z1 = L1A_Z(II1)
        ELSE
          X1 =-1.
          Y1 = 0.
          Z1 = 0.
        ENDIF
      ELSE
        X2 =-1.
        Y2 = 0.
        Z2 = 0.
        X1 =-1.
        Y1 = 1.
        Z1 = 0.
      ENDIF
      V1(1) = X2-X1
      V1(2) = Y2-Y1
      V1(3) = Z2-Z1
      V2(1) = X3-X2
      V2(2) = Y3-Y2
      V2(3) = Z3-Z2
      CALL NB_VMOD(V1,AV1)
      CALL NB_VMOD(V2,AV2)
      CALL NB_VPROD(V1,V2,S)
      COSA1 = S/(AV1*AV2)
      ANG1  = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
      ANG1  = PI-ANG1
C     10 grad = 0.175
      D    = PI - 0.175/2.0                                 
      IF(ANG1.GT.D.AND.II2.GT.0) THEN
        IB = L1A_IBACK(II2)
        IF(IB.GT.0) THEN
          II1 = L1A_IBACK(IB)
        ELSE
          II1 = 0
        ENDIF
        II2 = IB
        GO TO 100
      ENDIF
      A3   = X4-X3
      B3   = Y4-Y3
      C3   = Z4-Z3
      A2   = X3-X2
      B2   = Y3-Y2
      C2   = Z3-Z2
      A1   = X2-X1
      B1   = Y2-Y1
      C1   = Z2-Z1
      DN1X = B1*C2-B2*C1
      DN1Y = A1*C2-A2*C1
      DN1Z = A1*B2-A2*B1
      DN2X = B2*C3-B3*C2
      DN2Y = A2*C3-A3*C2
      DN2Z = A2*B3-A3*B2
      E1   = DN1X*DN2X+DN1Y*DN2Y+DN1Z*DN2Z
      E2   = SQRT(ABS(DN1X*DN1X+DN1Y*DN1Y+DN1Z*DN1Z))
      E3   = SQRT(ABS(DN2X*DN2X+DN2Y*DN2Y+DN2Z*DN2Z))
      IF(E2.LT.1.E-9.OR.E3.LT.1.E-9) THEN
        IF(E1.GE.0.) COSG = 1.
        IF(E1.LT.0.) COSG =-1.
      ELSE
        T    = E2*E3
        IF(T.LT.1.0E-8) T = 1.0
        COSG = E1/T
      ENDIF
C---------------NOW WE ARE CALCULATING MIXED VECTORS------------------
C-----ABC=A1*(B2*C3-B3*C2)-A2*(B1*C3-B3*C1)+A3*(B1*C2-B2*C1) !-------
C------------------------------------------------------------------
      ABC    = A1*DN2X-A2*(B1*C3-B3*C1)+A3*DN1X
      SS     = ABS(1.0 - COSG*COSG)
      SING   = SIGN(1.0,ABC)*SQRT(SS)
      ANGOBS = ATAN2(SING,COSG)
C ???
      IF(ANGOBS.GT. PI) ANGOBS = ANGOBS - TWOPI
      IF(ANGOBS.LE.-PI) ANGOBS = ANGOBS + TWOPI
      ANGOBS = ANGOBS/PI180

      RETURN
      END

C ******
      SUBROUTINE CALC_OVOL(IC,VOLOBS,IERR)
C -----------------------------------------------
C -P- CALC_VOL - 
C -S-
C                                V2 -> I3       A3  /
C               I2 - V1 -> I1  <              -----<  A1 
C                                V3 -> I4       A2  \
C
      REAL      VOLOBS
      INTEGER*4 IC
C ---
      INCLUDE 'lib_com.fh'
C ******
      REAL A(9)
      INTEGER*4 I1,I2,I3,I4
      CHARACTER NAME*4
C ---------------------------------------
      IERR   = 1
      VOLOBS = 0.0
      IF(IC.LE.0) RETURN
      IF(L1C_SIGN(IC)(1:4).EQ.'star'.OR.
     *   L1C_SIGN(IC)(1:4).EQ.'cros'     ) RETURN

      NAME   = L1C_1ATM(IC)
      DO I=1,L1A_NATOM
        IF(NAME.EQ.L1A_ANAME(I)) THEN
          I1            = I
          L1C_I1ATM(IC) = I
          GO TO 100
        ENDIF
      ENDDO
      RETURN
  100 CONTINUE    
      IF(L1A_COOR_FLAG(I1).EQ.'N') RETURN

      NAME = L1C_2ATM(IC)
      DO I=1,L1A_NATOM
        IF(NAME.EQ.L1A_ANAME(I)) THEN
          I2            = I
          L1C_I2ATM(IC) = I
          GO TO 110
        ENDIF
      ENDDO
      RETURN
  110 CONTINUE    
      IF(L1A_COOR_FLAG(I2).EQ.'N') RETURN

      NAME = L1C_3ATM(IC)
      DO I=1,L1A_NATOM
        IF(NAME.EQ.L1A_ANAME(I)) THEN
          I3            = I
          L1C_I3ATM(IC) = I
          GO TO 120
        ENDIF
      ENDDO
      RETURN
  120 CONTINUE    
      IF(L1A_COOR_FLAG(I3).EQ.'N') RETURN

      NAME = L1C_4ATM(IC)
      DO I=1,L1A_NATOM
        IF(NAME.EQ.L1A_ANAME(I)) THEN
          I4            = I
          L1C_I4ATM(IC) = I
          GO TO 130
        ENDIF
      ENDDO
      RETURN
  130 CONTINUE    
      IF(L1A_COOR_FLAG(I4).EQ.'N') RETURN
      IERR = 0

      A(1) = L1A_X(I2)-L1A_X(I1)
      A(4) = L1A_Y(I2)-L1A_Y(I1)
      A(7) = L1A_Z(I2)-L1A_Z(I1)
      A(2) = L1A_X(I3)-L1A_X(I1)
      A(5) = L1A_Y(I3)-L1A_Y(I1)
      A(8) = L1A_Z(I3)-L1A_Z(I1)
      A(3) = L1A_X(I4)-L1A_X(I1)
      A(6) = L1A_Y(I4)-L1A_Y(I1)
      A(9) = L1A_Z(I4)-L1A_Z(I1)
      VOLOBS = A(1)*(A(5)*A(9)-A(8)*A(6))
     *       - A(4)*(A(2)*A(9)-A(8)*A(3))
     *       + A(7)*(A(2)*A(6)-A(5)*A(3))

       
C     L1C_FLAG(IC)='C'

      RETURN
      END

C ******
      SUBROUTINE CALC_IVOL(IC,VOLIDL,PH1,PH2,PH3)
C -----------------------------------------------
C -P- CALC_IIVOL - 
C -S-                                           PH3    I3
C                                V2 -> I3        A3   /    
C               I2 - V1 -> I1  <             I2 -----<  A1  PH1 
C                                V3 -> I4        A2   \    
C                                               PH2    I4  
C       
      REAL      VOLIDL
      INTEGER*4 IC
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
C ******
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      IF(L1C_SIGN(IC)(1:4).EQ.'star'.OR.
     *   L1C_SIGN(IC)(1:4).EQ.'cros'     ) GO TO 1000

      I1    = 0
      I2    = 0
      I3    = 0

      IF(L1B_NBOND.GT.0.AND.L1G_NANGL.GT.0) THEN

        DO  IB=1,L1B_NBOND
          IF(I1.EQ.0) THEN
            IF((L1B_1ATM(IB).EQ.L1C_1ATM(IC) .AND.
     *          L1B_2ATM(IB).EQ.L1C_2ATM(IC)).OR.
     *         (L1B_1ATM(IB).EQ.L1C_2ATM(IC) .AND.
     *          L1B_2ATM(IB).EQ.L1C_1ATM(IC))    ) THEN
              V1 = L1B_VAL(IB)
              I1 = 1
            ENDIF  
          ENDIF  
          IF(I2.EQ.0) THEN
            IF((L1B_1ATM(IB).EQ.L1C_1ATM(IC) .AND.
     *          L1B_2ATM(IB).EQ.L1C_3ATM(IC)).OR.
     *         (L1B_1ATM(IB).EQ.L1C_3ATM(IC) .AND.
     *          L1B_2ATM(IB).EQ.L1C_1ATM(IC))    ) THEN
              V2 = L1B_VAL(IB)
              I2 = 1
            ENDIF  
          ENDIF  
          IF(I3.EQ.0) THEN
            IF((L1B_1ATM(IB).EQ.L1C_1ATM(IC) .AND.
     *          L1B_2ATM(IB).EQ.L1C_4ATM(IC)).OR.
     *         (L1B_1ATM(IB).EQ.L1C_4ATM(IC) .AND.
     *          L1B_2ATM(IB).EQ.L1C_1ATM(IC))    ) THEN
              V3 = L1B_VAL(IB)
              I3 = 1
            ENDIF  
          ENDIF  
          IF(I1.EQ.1.AND.I2.EQ.1.AND.I3.EQ.1) GO TO 100 
        ENDDO
        GO TO 1000

  100   CONTINUE                    

        I1 = 0
        I2 = 0
        I3 = 0
        DO  IG=1,L1G_NANGL
          IF(I1.EQ.0) THEN
            IF(L1G_1ATM(IG).EQ.L1C_3ATM(IC) .OR.
     *         L1G_1ATM(IG).EQ.L1C_4ATM(IC))  THEN
              IF(L1G_2ATM(IG).EQ.L1C_1ATM(IC)) THEN
                IF(L1G_3ATM(IG).EQ.L1C_3ATM(IC) .OR.
     *             L1G_3ATM(IG).EQ.L1C_4ATM(IC))  THEN
                  A1 = L1G_VAL(IG)*PI180
                  I1 = 1
                ENDIF
              ENDIF
            ENDIF  
          ENDIF  
          IF(I2.EQ.0) THEN
            IF(L1G_1ATM(IG).EQ.L1C_2ATM(IC) .OR.
     *         L1G_1ATM(IG).EQ.L1C_4ATM(IC))  THEN
              IF(L1G_2ATM(IG).EQ.L1C_1ATM(IC)) THEN
                IF(L1G_3ATM(IG).EQ.L1C_2ATM(IC) .OR.
     *             L1G_3ATM(IG).EQ.L1C_4ATM(IC))  THEN
                  A2 = L1G_VAL(IG)*PI180
                  I2 = 1
                ENDIF
              ENDIF
            ENDIF  
          ENDIF  
          IF(I3.EQ.0) THEN
            IF(L1G_1ATM(IG).EQ.L1C_2ATM(IC) .OR.
     *         L1G_1ATM(IG).EQ.L1C_3ATM(IC))  THEN
              IF(L1G_2ATM(IG).EQ.L1C_1ATM(IC))THEN
                IF(L1G_3ATM(IG).EQ.L1C_2ATM(IC) .OR.
     *             L1G_3ATM(IG).EQ.L1C_3ATM(IC))  THEN
                  A3 = L1G_VAL(IG)*PI180
                  I3 = 1
                ENDIF
              ENDIF
            ENDIF  
          ENDIF  
          IF(I1.EQ.1.AND.I2.EQ.1.AND.I3.EQ.1) GO TO 200 
        ENDDO
        GO TO 1000
  200   CONTINUE                    




        COA1 = COS(A1)
        COA2 = COS(A2)
        COA3 = COS(A3)

        VOLIDL=V1*V2*V3*
     *       SQRT(ABS(1.-COA1**2-COA2**2-COA3**2+2.*COA1*COA2*COA3))

        CALL GET_TORS(A3,A2,A1,PH1)
        CALL GET_TORS(A1,A3,A2,PH2)
        CALL GET_TORS(A2,A1,A3,PH3)

        IF(PH1.GT. PI) PH1 = PH1 - TWOPI
        IF(PH1.LT.-PI) PH1 = PH1 + TWOPI
        PH1 = PH1/PI180
        IF(PH2.GT. PI) PH2 = PH2 - TWOPI
        IF(PH2.LT.-PI) PH2 = PH2 + TWOPI
        PH2 = PH2/PI180
        IF(PH3.GT. PI) PH3 = PH3 - TWOPI
        IF(PH3.LT.-PI) PH3 = PH3 + TWOPI
        PH3 = PH3/PI180

        RETURN
      ENDIF

 1000 CONTINUE

      VOLIDL = 0.0
      PH1    = 0.0
      PH2    = 0.0
      PH3    = 0.0
      RETURN
      END

      SUBROUTINE CALC_I_OVOL_L(I1,I2,I3,I4,XX1,XX2,XX3,XX4
     * ,VOLOBS,PH)
C -----------------------------------------------
C -P- CALC_I_OVOL_L - 
C -S-
C                                V2 -> I3 
C               I2 - V1 -> I1  < 
C                                V3 -> I4 
C
      REAL      VOLOBS
      REAL      XX1(3),XX2(3),XX3(3),XX4(3)
      INTEGER*4 I1,I2,I3,I4
C ---
C ******
      REAL A(9)
      REAL  V1(3),V2(3),V3(3),VT(3),V12(3),V13(3)
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C ---------------------------------------
      A(1) = XX2(1)-XX1(1)
      A(4) = XX2(2)-XX1(2)
      A(7) = XX2(3)-XX1(3)
      A(2) = XX3(1)-XX1(1)
      A(5) = XX3(2)-XX1(2)
      A(8) = XX3(3)-XX1(3)
      A(3) = XX4(1)-XX1(1)
      A(6) = XX4(2)-XX1(2)
      A(9) = XX4(3)-XX1(3)

      VOLOBS = A(1)*(A(5)*A(9)-A(8)*A(6))
     *       - A(4)*(A(2)*A(9)-A(8)*A(3))
     *       + A(7)*(A(2)*A(6)-A(5)*A(3))

      PH = 0.0
      V1(1) = XX1(1) - XX2(1) 
      V1(2) = XX1(2) - XX2(2) 
      V1(3) = XX1(3) - XX2(3) 
      V2(1) = XX3(1) - XX1(1) 
      V2(2) = XX3(2) - XX1(2) 
      V2(3) = XX3(3) - XX1(3) 
      V3(1) = XX4(1) - XX1(1) 
      V3(2) = XX4(2) - XX1(2) 
      V3(3) = XX4(3) - XX1(3) 
      CALL NB_VMOD(V1,AV1)
      CALL NB_VMOD(V2,AV2)
      CALL NB_VMOD(V3,AV3)
      CALL NB_VMULT(V1,V2,V12)
      CALL NB_VMOD(V12,AV12)
      CALL NB_VMULT(V1,V3,V13)
      CALL NB_VMOD(V13,AV13)
      IF(AV12.LE.0.0.OR.AV13.LE.0.0) GO TO 200

      CALL NB_VPROD(V12,V13,ACOS23)
      T      = AV12*AV13
      IF(ABS(T).LT.1.0E-8) T = 1.0
      ACOS23 = ACOS23/T

      IF(ACOS23.GT. 1.0) ACOS23 = 1.0      
      IF(ACOS23.LT.-1.0) ACOS23 =-1.0

      PH     = ACOS(ACOS23) 

      CALL NB_VMULT(V1,V2,VT)
      CALL NB_VPROD(VT,V3,TEST)

      IF(TEST.LT.0) PH = -PH

      IF(PH.GT. PI) PH = PH - TWOPI        
      IF(PH.LE.-PI) PH = PH + TWOPI        

      PH = PH/PI180
 200  CONTINUE

      RETURN
      END

      SUBROUTINE GET_TORS(A1,A2,A12,T)
C ----------------------------------------------------
      PI     = 4.0*ATAN(1.0)
      TWOPI  = 2.0*PI
      SINA1  = SIN(A1)
      COSA1  = COS(A1)
      SINA2  = SIN(A2)
      COSA2  = COS(A2)
      COSA12 = COS(A12)
      S      = A1+A2+A12
      S      = SIN(S)
      IF(ABS(S).LT.0.002) THEN
        T = PI
      ELSE IF(ABS(SINA1).LT.0.000001.OR.ABS(SINA2).LT.0.000001) THEN
        T = 0.0
      ELSE
        COST = (COSA12-COSA1*COSA2)/(SINA1*SINA2)
        IF(COST.GT. 1.0) COST = 1.0
        IF(COST.LT.-1.0) COST =-1.0
        T = ACOS(COST)
      ENDIF
      IF(T.GT. PI) T = T - TWOPI
      IF(T.LT.-PI) T = T + TWOPI
C ---
      RETURN
      END


      SUBROUTINE SET_VOBS_TO_VIDL(MDOC,IERR)
C -----------------------------------------------
C -P- 
C -S-
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ******
      CHARACTER LINE*256
C --------------------------------------------------------
C      WRITE(LINE,'('' N BOND,ANGLE,TORS:'',3I4)')
C     * L1B_NBOND,L1G_NANGL,L1T_NTORS
C      CALL MSGDOC(MDOC,LINE)

      IF(L1B_NBOND.GT.0) THEN
        DO IB=1,L1B_NBOND
          IF(L1B_VOBS(IB).GT.0.001) L1B_VAL(IB) = L1B_VOBS(IB)
          IF(L1B_TYPE(IB).EQ.'.') L1B_TYPE(IB) = 'coval'
        ENDDO 
      ENDIF
C ---
      IF(L1G_NANGL.GT.0) THEN
        DO IG=1,L1G_NANGL
           IF(L1G_VOBS(IG).GT.0.001) L1G_VAL(IG) = L1G_VOBS(IG)
        ENDDO
      ENDIF
C ---
      IF(L1T_NTORS.GT.0) THEN
        DO IT=1,L1T_NTORS
          L1T_VAL(IT) = L1T_VOBS(IT)
        ENDDO
      ENDIF

      RETURN
      END

      SUBROUTINE COORD_4(AV1,AV2,AV3,V1,V2,ANG1,ANG2,PHI,V3)
C --------------------
C     in libcheck and in make_rst
C
      REAL V1(3),V2(3),V3(3),N12(3),P12(3),V23(3)
     *    ,VP3(3),VN3(3),X(3),VV1(3)
C     REAL VS(3)
C --------------------
      PI     = 4.0*ATAN(1.0)
      COSA1  = COS(ANG1)
      COSA2  = COS(ANG2)
      SINA1  = SIN(ANG1)
      SINA2  = SIN(ANG2)
      COSPHI = COS(PHI)
      SINPHI = SIN(PHI)
      VV1(1) = V1(1)
      VV1(2) = V1(2)
      VV1(3) = V1(3)
C --
      IF(ABS(SINA2).LT.0.02) THEN
        T = AV3/AMAX1(AV2,0.00001)
        IF(COSA2.GT.0.0) T =-T
        CALL NB_VSCAL(V2,T,V3)
        RETURN
      ENDIF
      IF(ABS(SINA1).LT.0.02) THEN
        VV1(1) = 1.0
        VV1(2) = 0.0
        VV1(3) = 0.0
        CALL NB_VMOD(VV1,AVV1)
        CALL NB_VMOD(V2,AVV2)
        CALL NB_VPROD(VV1,V2,S)
        COSA1 = S/(AVV1*AVV2)
        AANG1  = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
        AANG1  = PI-AANG1
        COSA1  = COS(AANG1)
        SINA1  = SIN(AANG1)
        IF(ABS(SINA1).LT.0.02) THEN
          VV1(1) = 0.0
          VV1(2) = 1.0
          VV1(3) = 0.0
          CALL NB_VMOD(VV1,AVV1)
          CALL NB_VMOD(V2,AVV2)
          CALL NB_VPROD(VV1,V2,S)
          COSA1 = S/(AVV1*AVV2)
          AANG1  = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
          AANG1  = PI-AANG1
          COSA1  = COS(AANG1)
          SINA1  = SIN(AANG1)
          IF(ABS(SINA1).LT.0.02) THEN
            VV1(1) = 0.0
            VV1(2) = 1.0
            VV1(3) = 0.0
            CALL NB_VMOD(VV1,AVV1)
            CALL NB_VMOD(V2,AVV2)
            CALL NB_VPROD(VV1,V2,S)
            COSA1 = S/(AVV1*AVV2)
            AANG1  = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
            AANG1  = PI-AANG1
            COSA1  = COS(AANG1)
            SINA1  = SIN(AANG1)
          ENDIF
        ENDIF
      ENDIF

      CALL NB_VMULT(VV1,V2,X)
      CALL NB_VUNIT(X,N12,JERR)
      CALL NB_VMULT(N12,V2,X)
      CALL NB_VUNIT(X,P12,JERR)

      AP23 = AV3*SINA2
      T = (AV3*(-COSA2))/AMAX1(AV2,0.00001)
      CALL NB_VSCAL(V2,T,V23)
      T1 = AP23*COSPHI
      CALL NB_VSCAL(P12,T1,VP3)
      T1 = AP23*SINPHI
      CALL NB_VSCAL(N12,T1,VN3)

      CALL NB_VADD(V23,VP3,X)
      CALL NB_VADD(X,VN3,V3)
C --
C --------------------------- 
      RETURN
      END

      SUBROUTINE CALC_PLDEV(N,IATM,DOBS)
C -----------------------------------------------
C -P- CALC_PLDEV - 
C -S-
      INTEGER*4 N,IATM(*)
      REAL      DOBS(*)
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------------------------
      REAL      X(3,MAX1APL),DEL(MAX1APL),VM(3)
C -------------------------------------------------
      IF(N.LE.0) RETURN
      DO  I = 1,N
        II     = IATM(I)
        X(1,I) = L1A_X(II)
        X(2,I) = L1A_Y(II)
        X(3,I) = L1A_Z(II)
      ENDDO

      IF(N.GE.4) THEN

        CALL FIT_PLANE(N,X,VM,D)

        DO  I = 1,N
          DEL(I) = 0
          DO J=1,3
            DEL(I) = DEL(I)+VM(J)*X(J,I)
          ENDDO
          DOBS(I) = DEL(I)-D
        ENDDO

      ELSE

        DO  I = 1,N
          DOBS(I) = 0.0
        ENDDO

      ENDIF

      RETURN
      END      

C ******
      SUBROUTINE FIT_PLANE(N,X,VM,D)
C -P- PLAN - fit a least-squares plan to a set of points.
C -S-
C     PROCEDURE OF SCHOMAKER ET AL.(ACTA CRYST.,12,600,1959)
C
C ******
      REAL   X(3,*),XS(3),XXS(3,3),B(3,3),A(3,3)
      REAL   VM(3),VMI(3),BV(3)
      DATA   ZIP/1.0E-5/
      DATA   MM/10/
C ------------------------------------
C
C----SET UP THE A MATRIX
      SN = N
      IF(N.LE.0) STOP ' N =< 0 in subroutine "FIT_PLANE"'
C ---
      DO    I=1,3
        XS(I) = 0
        DO    K=1,N
          XS(I) = XS(I) + X(I,K)
        ENDDO
      ENDDO
C ---
      DO    I=1,3
        DO    J=1,3
          XXS(I,J) = 0
          DO    K=1,N
            XXS(I,J) = XXS(I,J) + X(I,K)*X(J,K)
          ENDDO
          A(I,J) = XXS(I,J) - XS(I)*XS(J)/SN
        ENDDO
      ENDDO
C
C----EVALUATE MATRIX B=ADJ(A)*G
C
      B(1,1) = A(2,2)*A(3,3)-A(2,3)*A(3,2)
      B(2,1) = A(3,1)*A(2,3)-A(2,1)*A(3,3)
      B(3,1) = A(2,1)*A(3,2)-A(3,1)*A(2,2)
      B(1,2) = A(3,2)*A(1,3)-A(1,2)*A(3,3)
      B(2,2) = A(1,1)*A(3,3)-A(3,1)*A(1,3)
      B(3,2) = A(3,1)*A(1,2)-A(1,1)*A(3,2)
      B(1,3) = A(1,2)*A(2,3)-A(1,3)*A(2,2)
      B(2,3) = A(2,1)*A(1,3)-A(1,1)*A(2,3)
      B(3,3) = A(1,1)*A(2,2)-A(2,1)*A(1,2)

C
C----CHOOSE THE LARGEST COLUMN VECTOR OF B AS THE INITIAL SOLUTION
C
      BV(1) = B(1,1)**2+B(2,1)**2+B(3,1)**2
      BV(2) = B(1,2)**2+B(2,2)**2+B(3,2)**2
      BV(3) = B(1,3)**2+B(2,3)**2+B(3,3)**2

      KK    = 1
      IF(BV(2).GT.BV( 1)) KK = 2
      IF(BV(3).GT.BV(KK)) KK = 3
      VM1 = B(1,KK)

      IF(ABS(VM1).LE.ZIP) THEN
        VM(1) = 0.0
        VM(2) = 0.0
        VM(3) = 0.0
        D     = 0.0
        RETURN
      ENDIF

      VMI_MIN = 1E30
      DO    I=1,3
        VMI(I) = B(I,KK)/VM1
        IF(ABS(VMI(I)).LT.VMI_MIN) VMI_MON = ABS(VMI(I))
      ENDDO

      IF(VMI_MIN.LE.ZIP) THEN
        VM(1) = 0.0
        VM(2) = 0.0
        VM(3) = 0.0
        D     = 0.0
        RETURN
      ENDIF

C
C----SOLVE TO CONVERGENCE BY ITERATION OF M(I)=B*M(I-1)
C
      DO    NNN=1,MM
        VM(1)  = B(1,1)*VMI(1)+B(1,2)*VMI(2)+B(1,3)*VMI(3)
        VM(2)  = B(2,1)*VMI(1)+B(2,2)*VMI(2)+B(2,3)*VMI(3)
        VM(3)  = B(3,1)*VMI(1)+B(3,2)*VMI(2)+B(3,3)*VMI(3)
        IF(ABS(VMI(1)).LT.ZIP) GO TO 110
        IF(ABS(VMI(2)).LT.ZIP) GO TO 110
        IF(ABS(VMI(3)).LT.ZIP) GO TO 110
        RATIO1 = VM(1)/VMI(1)
        RATIO2 = VM(2)/VMI(2)
        RATIO3 = VM(3)/VMI(3)
        RAT12  = ABS(RATIO2/RATIO1-1.0)
        RAT13  = ABS(RATIO3/RATIO1-1.0)
        IF(RAT12.LT.ZIP.AND.RAT13.LT.ZIP) GO TO 110
        IF(ABS(VM(1)).LT.ZIP) GO TO 110
        DO    I=1,3
          VMI(I) = VM(I)/VM(1)
        ENDDO
      ENDDO   
C
C----NORMALIZE THE SOLUTION VECTOR AND EVALUATE D(PLANE TO ORIGIN DISTAN
C
  110 ORM = 0
      DO    I=1,3
        ORM = ORM + VM(I)*VM(I)
      ENDDO

      ORM = SQRT(ABS(ORM))

      IF(ORM.LT.ZIP) THEN
        VM(1) = 0.0
        VM(2) = 0.0
        VM(3) = 0.0
        D     = 0.0
        RETURN
      ENDIF

      DO     I=1,3
        VM(I) = VM(I)/ORM
      ENDDO

      D = (VM(1)*XS(1)+VM(2)*XS(2)+VM(3)*XS(3))/SN

      RETURN
      END

C ==========================================================

C ========================================================
      SUBROUTINE GRAPH_NEWL(MDOC,MOD,MON_INPUT,PROG,VANGLE,IERR)
C -----------------------------------------------
C -P-  
C -S-
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,ATOM*4,PROG*(*),MOD*1,MON_INPUT*8
C     CHARACTER TYPE*8
      REAL      X(3),Y(3),C(3)
      INTEGER   IXP(2),IYP(2)
C ----
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS
C ----
      CHARACTER       NAME*256,LINE*256,PATH*1,EXT*1,MNAME*80,ACHIR(4)*4
      CHARACTER       CH30(3)*30,CH28(3)*28
      CHARACTER       CH28A(3)*28,CH28B(3)*28,CH28C(3)*28
C ---
      INCLUDE 'lib_com.fh'
C ******
      INCLUDE 'crd_com.fh'
C --------------------------------------------------------
      NA    = L1A_NATOM
      NB    = L1B_NBOND
      CALL LENSTR_BL(MON_INPUT,L)
      IF(L.GT.0.AND.MON_INPUT(1:1).NE.'?'.AND.
     *              MON_INPUT(1:1).NE.' '      ) THEN
        MON   = MON_INPUT 
      ELSE
        MON   = L1L_MNAME 
      ENDIF
      MNAME = L1L_NAME

cd      IF(NA.LE.2.OR.NB.LE.1) RETURN



      XMAX =-1.E 30
      YMAX =-1.E 30
      ZMAX =-1.E 30
      XMIN = 1.E 30
      YMIN = 1.E 30
      ZMIN = 1.E 30

      N = 0
      DO I=1,NA

        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN

          L2A_X(I) = L1A_X(I)
          L2A_Y(I) = L1A_Y(I)
          L2A_Z(I) = L1A_Z(I)

          X(1) = L2A_X(I)
          X(2) = L2A_Y(I)
          X(3) = L2A_Z(I)

          IF(X(1).GT.XMAX) XMAX = X(1)
          IF(X(2).GT.YMAX) YMAX = X(2)
          IF(X(3).GT.ZMAX) ZMAX = X(3)

          IF(X(1).LT.XMIN) XMIN = X(1)
          IF(X(2).LT.YMIN) YMIN = X(2)
          IF(X(3).LT.ZMIN) ZMIN = X(3)
          N=N+1
        ENDIF
      ENDDO

      IF(N.LE.0) THEN
c        WRITE(LINE,'(
c     * '' WARNING: number of atoms < 1 for '',A)') MON
c        CALL MSGERR(MDOC,LINE)
c        CALL MSGERR(MDOC,
c     * '            Can not create PostScript file and CIFile')
        IERR=0
        RETURN
      ENDIF
C ---

      CALL LENSTR_BL(PROG,LP)
      CALL LENSTR_BL(MON,LM)

C      write(*,*) 'prog    :',prog
C      write(*,*) 'cro_file:',CRO_FILE      

      IF(PROG.EQ.'libcheck') THEN
        CALL LENSTR_BL(CRO_FILE,LO)
        IF(LO.GT.0.AND.CRO_FILE(1:1).NE.',') THEN 
C          IF(LO.GT.(75-LM)) LO = 75 - LM 
          IF(LO.GT.(250-LM)) LO = 250 - LM 
          NAME=CRO_FILE(1:LO)//'_'//MON(1:LM)//'.cif'
        ELSE
          NAME=PROG(1:LP)//'_'//MON(1:LM)//'.cif'
        ENDIF
C       IUN=40
        IUN = CRO2_IUN

C      write(*,*) 'prog    :',prog
C      write(*,*) 'cro_file:',CRO_FILE(1:lo)     
C      CALL LENSTR_BL(CRO_FILE,Llll)
C      write(*,*) 'name:',name(1:llll)

        M    = 99
        PATH = ' '
        EXT  = ' '
        CALL OPENFW(IUN,M,PATH,NAME,EXT,IERR)
        CRO2_IUN = IUN
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,
     *    ' WARNING: can''t open output CIFile for new monomer')
          IUN  = 0
          IERR = 0
        ENDIF

        IF(IUN.GT.0) THEN
          CALL LENSTR_BL(NAME,L)
          IF(L.GT.66) L = 66
          LINE='* CIFile  : '//NAME(1:L)
          CALL MSGDOC(MDOC,LINE)
          CALL WR_CIF_NEW(MDOC,CRO2_IUN,PROG,IERR)
        ENDIF

        CALL LENSTR_BL(CRO_FILE,LO)
        IF(LO.GT.0.AND.CRO_FILE(1:1).NE.',') THEN 
C          IF(LO.GT.(75-LM)) LO = 75 - LM 
          IF(LO.GT.(250-LM)) LO = 250 - LM 
          NAME=CRO_FILE(1:LO)//'_'//MON(1:LM)//'.pdb'
        ELSE
          NAME = PROG(1:LP)//'_'//MON(1:LM)//'.pdb'
        ENDIF

C      CALL LENSTR_BL(CRO_FILE,Llll)
C      write(*,*) 'name:',name(1:llll)

        IUN  = CRO2_IUN
        M    = 99
        PATH = ' '
        EXT  = ' '
        CALL OPENFW(IUN,M,PATH,NAME,EXT,IERR)
        CRO2_IUN = IUN
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,
     *    ' WARNING: can''t open output PDB File for new monomer')
          IUN  = 0
          IERR = 0
        ENDIF

        IF(IUN.GT.0) THEN
          CALL LENSTR_BL(NAME,L)
          IF(L.GT.66) L = 66
          LINE='* PDBfile : '//NAME(1:L)
          CALL MSGDOC(MDOC,LINE)
          CALL WR_PDB_NEW(MDOC,CRO2_IUN,PROG,IERR)
        ENDIF

      ENDIF
C ---
      IF(N.GE.3) THEN

        C(1)    = (XMAX+XMIN)/2.0  
        C(2)    = (YMAX+YMIN)/2.0
        C(3)    = (ZMAX+ZMIN)/2.0

        XB      = (XMAX-XMIN)/2.0  
        YB      = (YMAX-YMIN)/2.0
        ZB      = (ZMAX-ZMIN)/2.0


        ICHNG = 0
        IF(XB.LT.ZB.AND.XB.LT.YB) THEN
          I1 = 1
          I2 = 2
          I3 = 3          
          ICHNG = 1
        ELSE IF(YB.LT.ZB.AND.YB.LT.XB) THEN          
          I1 = 3
          I2 = 2
          I3 = 1          
          ICHNG = 2
        ENDIF

        IF(ICHNG.GT.0) THEN
          DO I=1,NA
            IF(L1A_COOR_FLAG(I).EQ.'Y') THEN
              X(1)  = L2A_X(I)
              X(2)  = L2A_Y(I)
              X(3)  = L2A_Z(I)
              T     = X(I1)
              X(I1) = X(I2)
              X(I2) = X(I3)
              X(I3) = T
              L2A_X(I) = X(1)
              L2A_Y(I) = X(2)
              L2A_Z(I) = X(3)
            ENDIF
          ENDDO
          T     = C(I1)
          C(I1) = C(I2)
          C(I2) = C(I3)
          C(I3) = T
        ENDIF

      ELSE
        WRITE(LINE,'(A,A)')
     * ' WARNING: number of atoms < 3 for ', MON
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     * '            Can not create PostScript file')
        IERR=0
        RETURN
      ENDIF

      RAD=0.0
      DO I=1,NA
        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN
          X(1) = L2A_X(I)
          X(2) = L2A_Y(I)
          X(3) = L2A_Z(I)
          T1   = X(1)-C(1)
          T2   = X(2)-C(2)
          T3   = X(3)-C(3)
          R    = SQRT(T1*T1+T2*T2+T3*T3)
          IF(R.GT.RAD) RAD=R
          L2A_X(I) = T1
          L2A_Y(I) = T2
          L2A_Z(I) = T3
        ENDIF
      ENDDO

C --- rotation --

      ANGLE = (VANGLE*3.1415926)/180.0
      COSA  = COS(ANGLE)
      SINA  = SIN(ANGLE)
      DO I=1,NA
        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN
          X(1) = L2A_X(I)
          X(2) = L2A_Y(I)
          X(3) = L2A_Z(I)
          T1   = X(2)*COSA+X(3)*SINA
          T2   =-X(2)*SINA+X(3)*COSA
          X(2) = T1 
          X(3) = T2
          L2A_X(I) = X(1)
          L2A_Y(I) = X(2)
          L2A_Z(I) = X(3)
        ENDIF
      ENDDO

C -----
C ------------------

      NPAGE=5
      CALL LENSTR_BL(PROG,LP)
      CALL LENSTR_BL(MON,LM)
      IF(PROG.EQ.'libcheck') THEN
        CALL LENSTR_BL(CRO_FILE,LO)
        IF(LO.GT.0.AND.CRO_FILE(1:1).NE.',') THEN 
C          IF(LO.GT.(75-LM)) LO = 75 - LM 
          IF(LO.GT.(250-LM)) LO = 250 - LM 
          NAME=CRO_FILE(1:LO)//'_'//MON(1:LM)//'.ps'
        ELSE
          NAME=PROG(1:LP)//'_'//MON(1:LM)//'.ps'
        ENDIF
      ELSE
        CALL LENSTR_BL(CRPS_PATH,LPATH)
        CALL LENSTR_BL(CRPS_FILE,LFILE)
        IF(LPATH.GT.0) THEN
          LINE = CRPS_PATH(1:LPATH)//CRPS_FILE(1:LFILE)
        ELSE
          LINE = CRPS_FILE
        ENDIF
        CALL LENSTR_BL(LINE,LEN)
        CALL LENSTR_BL(CRPS_EXT,LE)
C        LLEN = 80 - (LM+LE+1)
        LLEN = 256 - (LM+LE+1)
        IF(LEN.LE.0) THEN
          LINE = 'makecif'
          LEN  = 7
        ELSE IF(LEN.GT.LLEN) THEN
          LEN = LLEN
        ENDIF
        NAME = LINE(1:LEN)//'_'//MON(1:LM)//'.'//CRPS_EXT(1:LE)
      ENDIF
      CALL OPENTX(NAME,NPAGE,IERR)
C      PATH = ' '
C      EXT  = ' '
C      MDOC = 99
C      CALL  OPENFW(IUN_PS,MDOC,PATH,FNAME,EXT,IERR)
C      IF(IERR.NE.0) GO TO 900

      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: can not open PostScript file')
        IERR=0           
        RETURN
      ENDIF
      IPEN=1
      CALL NEWPEN(IPEN)
C ---
      IBX=180
      IBY=180
      ISHX=50
      ISHY=80
      CALL SET_BOX_TX(IBX,IBY,ISHX,ISHY)
      CALL GET_BOX_TX(IBXX,IBXY,ISHX,ISHY,IX0_PS,IY0_PS
     *   ,LIM_XMIN,LIM_XMAX,LIM_YMIN,LIM_YMAX)
C -----------------------
      BORDER = 2.5
      IBX    = IBXX
      IBX2   = IBX/2
      BOX    = (RAD+BORDER)*2.0
      RADBOR = RAD+BORDER
      SCALE  = IBX/BOX
C -----------------------
C ------ title ----
C     CALL TITLE_MONL(MON)

      CALL LENSTR_BL(PROG,L)
      CALL TITLE_MONL_1(MON,MNAME)
C ---left---

      IX0 = 0
      IY0 = 0
      CALL ORITX(IX0,IY0)
      CALL DRAW_FRAME(IBX,IBX)
C -----------------
      DO L=1,NB

        I1    = L1B_I1ATM(L) 
        I2    = L1B_I2ATM(L) 
        IF(I1.GT.0.AND.I2.GT.0) THEN
        IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I2).EQ.'Y') THEN
           
          X(1) = L2A_X(I1)
          X(2) = L2A_Y(I1)
          X(3) = L2A_Z(I1)

          CALL PROJ_TXL(X,RADBOR,IBX,SCALE,IXP)

          Y(1) = L2A_X(I2)
          Y(2) = L2A_Y(I2)
          Y(3) = L2A_Z(I2)


          CALL PROJ_TXL(Y,RADBOR,IBX,SCALE,IYP)

          CALL MOVTXX(IXP(1),IXP(2))
          CALL VECTXX(IYP(1),IYP(2))

        ENDIF
        ENDIF
      ENDDO
C --
      IDX     =-3
      IDY     = 3
      ISIZE   = 8
      SZ_LETT = 0.5
      IMOD    = 0

      DO I=1,NA
        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN

          X(1) = L2A_X(I)
          X(2) = L2A_Y(I)
          X(3) = L2A_Z(I)
          CALL PROJ_TXL(X,RADBOR,IBX,SCALE,IXP)
          IX   = IXP(1)+IDX
          IY   = IXP(2)+IDY
          X(1) = SZ_LETT
          X(2) = 0.0
          I0   = 0
          CALL PROJ_TXL(X,RADBOR,I0,SCALE,IXP)
          ISZ  = IXP(1)/10
          ATOM = L1A_ANAME(I)
          CALL LENSTR_BL(ATOM,LEN)
          IXX  = IX/10
          IYY  = IY/10  
          CALL TXTEXT(ATOM(1:LEN),ISZ,IXX,IYY,IMOD)
        ENDIF
      ENDDO
C ---
C ---right---

C ---
c      IBX =190
c      IBY =190
C      ISHX=50
      ISHY = ISHY+IBX
      CALL SET_BOX_TX(IBX,IBY,ISHX,ISHY)
      ANGLE = (-9.0*3.1415926)/180.0
      COSA  = COS(ANGLE)
      SINA  = SIN(ANGLE)

      IX0 = 0
      IY0 = 0
      CALL ORITX(IX0,IY0)
      CALL DRAW_FRAME(IBX,IBX)
C -----------------
      DO L=1,NB

        I1    = L1B_I1ATM(L) 
        I2    = L1B_I2ATM(L) 

        IF(I1.GT.0.AND.I2.GT.0) THEN
        IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I2).EQ.'Y') THEN

          X(1) = L2A_X(I1)
          X(2) = L2A_Y(I1)
          X(3) = L2A_Z(I1)
          T1   = X(2)*COSA+X(3)*SINA
          T2   =-X(2)*SINA+X(3)*COSA
          X(2) = T1 
          X(3) = T2
          CALL PROJ_TXL(X,RADBOR,IBX,SCALE,IXP)

          Y(1) = L2A_X(I2)
          Y(2) = L2A_Y(I2)
          Y(3) = L2A_Z(I2)
          T1   = Y(2)*COSA+Y(3)*SINA
          T2   =-Y(2)*SINA+Y(3)*COSA
          Y(2) = T1
          Y(3) = T2
          CALL PROJ_TXL(Y,RADBOR,IBX,SCALE,IYP)

          CALL MOVTXX(IXP(1),IXP(2))
          CALL VECTXX(IYP(1),IYP(2))
        ENDIF
        ENDIF
      ENDDO
      IDX   =-3
      IDY   = 3
      ISIZE = 8
      IMOD  = 0

      DO I=1,NA
        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN
          X(1) = L2A_X(I)
          X(2) = L2A_Y(I)
          X(3) = L2A_Z(I)
          T1   = X(2)*COSA+X(3)*SINA
          T2   =-X(2)*SINA+X(3)*COSA
          X(2) = T1
          X(3) = T2
          CALL PROJ_TXL(X,RADBOR,IBX,SCALE,IXP)
          IX   = IXP(1)+IDX
          IY   = IXP(2)+IDY
          X(1) = SZ_LETT
          X(2) = 0.0
          I0   = 0
          CALL PROJ_TXL(X,RADBOR,I0,SCALE,IXP)
          ISZ  = IXP(1)/10
          ATOM = L1A_ANAME(I)
          CALL LENSTR_BL(ATOM,LEN)
          IXX  = IX/10
          IYY  = IY/10  
          CALL TXTEXT(ATOM(1:LEN),ISZ,IXX,IYY,IMOD)
        ENDIF
      ENDDO
C ---
C ------------------------------------------
      IMOD   = 1
      ID1    = 20
      ID2    = 15
      IDEL   = 10
      ISIZE1 = 10
      ISIZE  = 8
      IXL0   = ISHX+IBX
      IYLT   = 230
      IXLMAX = (LIM_XMAX-LIM_XMIN) - 6*IDEL
      LENY   = LIM_YMAX-LIM_YMIN
      L3     = LENY/3-10
      IY1    = 15
      IY2    = 15+L3
      IY3    = 15+L3*2
      IYL1   = IY1+50
      IYL2   = IY2+50
      IYL3   = IY3+50
 
C ---------------------------------------
      IF(NB.GT.0) THEN

      LINE = 'BONDS'
      IXL  = IXL0+ID1 
      IF(IXL.GT.IXLMAX) THEN
        CALL NEWPG
        CALL TITLE_MONL(MON)
        IXL=ISHX
      ENDIF
      CALL TXTEXT(LINE,ISIZE1,IXL,IYLT,IMOD)
C ---
      IF(MOD.EQ.'L') THEN
      LINE=
     *'lib - value from library, crd - value from coords(created), chem  
     *-from ener_lib'
      ELSE
      LINE=
     *'lib - value for library, crd - value from coords, chem - from ene
     *r_lib'
      ENDIF
C ---
      IXL   = IXL+ID1
      IY1   = 60
      CALL TXTEXT(LINE,ISIZE,IXL,IY1,IMOD)

      LINE  = 'Dlib Dcrd Dchem'
      IXL   = IXL+ID2
      IF(IXL.GT.IXLMAX) THEN
        CALL NEWPG
        CALL TITLE_MONL(MON)
        IXL=ISHX
      ENDIF
      IY1  = 11
      IY2  = 21+L3
      IY3  = 31+L3*2
      IYL1 = IY1+40
      IYL2 = IY2+40
      IYL3 = IY3+40
      IYY1 = IYL1+12
      IYY2 = IYL2+12
      IYY3 = IYL3+12
      CALL TXTEXT(LINE,ISIZE,IXL,IYY1,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY2,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY3,IMOD)
C ---
      IXL  =  IXL+ID2
      DO I=1,3
        CH30(I) = ' '
        CH28(I) = ' '
      ENDDO
      N = 0
      DO L=1,NB
        I1    = L1B_I1ATM(L) 
        I2    = L1B_I2ATM(L)

        IF(I1.GT.0.AND.I2.GT.0) THEN 
        IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I2).EQ.'Y') THEN
          N = N+1 
          WRITE(CH30(N),100) 
     *    L1A_ANAME(I1),L1A_ANAME(I2)
 100      FORMAT(A4,'-',A4)
          WRITE(CH28(N),110) 
     *    L1B_VAL(L),L1B_VOBS(L),L1B_EVAL(L) 
 110      FORMAT(3F7.3)
          IF(N.EQ.3) THEN
            CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
            CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
            CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
            CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
            CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
            CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
            DO I=1,3
              CH30(I) = ' '
              CH28(I) = ' '
            ENDDO
            N   = 0
            IXL = IXL+IDEL
            IF(IXL.GT.IXLMAX) THEN
              CALL NEWPG
              CALL TITLE_MONL(MON)
              IXL=ISHX
            ENDIF
          ENDIF
        ENDIF
        ENDIF
      ENDDO
      IF(N.GT.0) THEN
        CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
        CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
        CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
        CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
        CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
        CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
        DO I=1,3
          CH30(I) = ' '
          CH28(I) = ' '
        ENDDO
        N=0
        IXL=IXL+IDEL
        IF(IXL.GT.IXLMAX) THEN
          CALL NEWPG
          CALL TITLE_MONL(MON)
          IXL=ISHX
        ENDIF
      ENDIF

      ENDIF
C ---------------------------------------
      IF(L1G_NANGL.GT.0) THEN

      LINE = 'ANGLES'
      IXL  = IXL+ID1 
      IXLP = IXL+ID1
      IF(IXLP.GT.IXLMAX) THEN
        CALL NEWPG
        CALL TITLE_MONL(MON)
        IXL=ISHX
      ENDIF
      CALL TXTEXT(LINE,ISIZE1,IXL,IYLT,IMOD)
C ---
      LINE='lib crd chem'
      IY1   = 5
      IY2   = 20+L3
      IY3   = 30+L3*2
      IXL   = IXL+ID1
      IYL1  = IY1+70
      IYL2  = IY2+70
      IYL3  = IY3+70
      IYL1A = IYL1+30
      IYL1B = IYL1+55
      IYL2A = IYL2+30
      IYL2B = IYL2+55
      IYL3A = IYL3+30
      IYL3B = IYL3+55
      IYY1  = IYL1+15
      IYY2  = IYL2+15
      IYY3  = IYL3+15
      CALL TXTEXT(LINE,ISIZE,IXL,IYY1,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY2,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY3,IMOD)
C ---
      IXL  =  IXL+ID2
      DO I=1,3
        CH30(I)  = ' '
        CH28(I)  = ' '
        CH28A(I) = ' '
        CH28B(I) = ' '
      ENDDO
      N  = 0
      NG = L1G_NANGL
      IF(NG.GT.0) THEN
      DO L=1,NG
        I1    = L1G_I1ATM(L) 
        I2    = L1G_I2ATM(L) 
        I3    = L1G_I3ATM(L)
        IF(I1.GT.0.AND.I2.GT.0.AND.I3.GT.0) THEN 
        IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I2).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I3).EQ.'Y') THEN
          N = N+1 
          WRITE(CH30(N),200) 
     *    L1A_ANAME(I1),L1A_ANAME(I2),L1A_ANAME(I3)
 200      FORMAT(A4,'-',A4,'-',A4)
          WRITE(CH28(N),210) 
     *    L1G_VAL(L) 
 210      FORMAT(F8.2)
          IYL1A = IYL1+30
          WRITE(CH28A(N),210) 
     *    L1G_VOBS(L)
          WRITE(CH28B(N),210) 
     *    L1G_EVAL(L) 
          IF(N.EQ.3) THEN
            CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
            CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
            CALL TXTEXT(CH28A(1),ISIZE,IXL,IYL1A,IMOD)
            CALL TXTEXT(CH28B(1),ISIZE,IXL,IYL1B,IMOD)


            CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
            CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
            CALL TXTEXT(CH28A(2),ISIZE,IXL,IYL2A,IMOD)
            CALL TXTEXT(CH28B(2),ISIZE,IXL,IYL2B,IMOD)

            CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
            CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
            CALL TXTEXT(CH28A(3),ISIZE,IXL,IYL3A,IMOD)
            CALL TXTEXT(CH28B(3),ISIZE,IXL,IYL3B,IMOD)

            DO I=1,3
              CH30(I)  = ' '
              CH28(I)  = ' '
              CH28A(I) = ' '
              CH28B(I) = ' '
            ENDDO
            N   = 0
            IXL = IXL+IDEL
            IF(IXL.GT.IXLMAX) THEN
              CALL NEWPG
              CALL TITLE_MONL(MON)
              IXL=ISHX
            ENDIF
          ENDIF
        ENDIF
        ENDIF
      ENDDO
      IF(N.GT.0) THEN
        CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
        CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
        CALL TXTEXT(CH28A(1),ISIZE,IXL,IYL1A,IMOD)
        CALL TXTEXT(CH28B(1),ISIZE,IXL,IYL1B,IMOD)
        CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
        CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
        CALL TXTEXT(CH28A(2),ISIZE,IXL,IYL2A,IMOD)
        CALL TXTEXT(CH28B(2),ISIZE,IXL,IYL2B,IMOD)
        CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
        CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
        CALL TXTEXT(CH28A(3),ISIZE,IXL,IYL3A,IMOD)
        CALL TXTEXT(CH28B(3),ISIZE,IXL,IYL3B,IMOD)
        DO I=1,3
          CH30(I)  = ' '
          CH28(I)  = ' '
          CH28A(I) = ' '
          CH28B(I) = ' '
        ENDDO
        N   = 0
        IXL = IXL+IDEL
        IF(IXL.GT.IXLMAX) THEN
          CALL NEWPG
          CALL TITLE_MONL(MON)
          IXL = ISHX
        ENDIF
      ENDIF
      ENDIF

      ENDIF
C ---------------------------------------
      IF(L1T_NTORS.GT.0) THEN

      LINE = 'TORSION ANGLES'
      IXL  = IXL+ID1 
      IXLP = IXL+ID1
      IF(IXLP.GT.IXLMAX) THEN
        CALL NEWPG
        CALL TITLE_MONL(MON)
        IXL = ISHX
      ENDIF
      IYL = IYLT-10
      CALL TXTEXT(LINE,ISIZE1,IXL,IYL,IMOD)
C ---
      LINE  = 'lib crd chem period'
      IXL   = IXL+ID1

      IY1 = 2
      IY2 = 4+L3


      IY1T =IY1
      IYL1 =IY1T+145
      IYL1A=IYL1+30
      IYL1B=IYL1+60
      IYL1C=IYL1+85

      IY2T =IY2+95
      IYL2 =IY2T+145
      IYL2A=IYL2+30
      IYL2B=IYL2+60
      IYL2C=IYL2+85

      IYY1 =IYL1+12
      IYY2 =IYL2+8

      CALL TXTEXT(LINE,ISIZE,IXL,IYY1,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY2,IMOD)
C ---
      IXL  =  IXL+ID2
      DO I=1,3
        CH30(I)=' '
        CH28(I)=' '
        CH28A(I)=' '
        CH28B(I)=' '
        CH28C(I)=' '
      ENDDO
      N=0
      NT=L1T_NTORS
      IF(NT.GT.0) THEN
      DO L=1,NT
        I1    = L1T_I1ATM(L) 
        I2    = L1T_I2ATM(L) 
        I3    = L1T_I3ATM(L) 
        I4    = L1T_I4ATM(L) 
        IF(I1.GT.0.AND.I2.GT.0.AND.I3.GT.0.AND.I4.GT.0) THEN
        IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I2).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I3).EQ.'Y'.AND.
     *     L1A_COOR_FLAG(I4).EQ.'Y') THEN
          N=N+1 
          WRITE(CH30(N),300) 
     *    L1A_ANAME(I1),L1A_ANAME(I2),L1A_ANAME(I3),L1A_ANAME(I4)
     *    ,L1T_LABEL(L)
 300      FORMAT(A4,'-',A4,'-',A4,'-',A4,' ',A8)
          WRITE(CH28(N),310) 
     *    L1T_VAL(L) 
 310      FORMAT(F8.2)
          WRITE(CH28A(N),310) 
     *    L1T_VOBS(L)
          WRITE(CH28B(N),310) 
     *    L1T_EVAL(L) 
          WRITE(CH28C(N),315) 
     *    L1T_PRD(L) 
 315      FORMAT(I4)
          IF(N.EQ.2) THEN
            CALL TXTEXT(CH30(1),ISIZE,IXL,IY1T,IMOD)
            CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
            CALL TXTEXT(CH28A(1),ISIZE,IXL,IYL1A,IMOD)
            CALL TXTEXT(CH28B(1),ISIZE,IXL,IYL1B,IMOD)
            CALL TXTEXT(CH28C(1),ISIZE,IXL,IYL1C,IMOD)

            CALL TXTEXT(CH30(2),ISIZE,IXL,IY2T,IMOD)
            CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
            CALL TXTEXT(CH28A(2),ISIZE,IXL,IYL2A,IMOD)
            CALL TXTEXT(CH28B(2),ISIZE,IXL,IYL2B,IMOD)
            CALL TXTEXT(CH28C(2),ISIZE,IXL,IYL2C,IMOD)

            DO I=1,2
              CH30(I)=' '
              CH28(I)=' '
              CH28A(I)=' '
              CH28B(I)=' '
              CH28C(I)=' '
            ENDDO
            N=0
            IXL=IXL+IDEL
            IF(IXL.GT.IXLMAX) THEN
              CALL NEWPG
              CALL TITLE_MONL(MON)
              IXL=ISHX
            ENDIF
          ENDIF
        ENDIF
        ENDIF
      ENDDO
      IF(N.GT.0) THEN
        CALL TXTEXT(CH30(1),ISIZE,IXL,IY1T,IMOD)
        CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
        CALL TXTEXT(CH28A(1),ISIZE,IXL,IYL1A,IMOD)
        CALL TXTEXT(CH28B(1),ISIZE,IXL,IYL1B,IMOD)
        CALL TXTEXT(CH28C(1),ISIZE,IXL,IYL1C,IMOD)

        CALL TXTEXT(CH30(2),ISIZE,IXL,IY2T,IMOD)
        CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
        CALL TXTEXT(CH28A(2),ISIZE,IXL,IYL2A,IMOD)
        CALL TXTEXT(CH28B(2),ISIZE,IXL,IYL2B,IMOD)
        CALL TXTEXT(CH28C(2),ISIZE,IXL,IYL2C,IMOD)
        DO I=1,3
          CH30(I)=' '
          CH28(I)=' '
          CH28A(I)=' '
          CH28B(I)=' '
          CH28C(I)=' '
        ENDDO
        N=0
        IXL=IXL+IDEL
        IF(IXL.GT.IXLMAX) THEN
          CALL NEWPG
          CALL TITLE_MONL(MON)
          IXL=ISHX
        ENDIF
      ENDIF
      ENDIF

      ENDIF
C ---------------------------------------
      IF(L1C_NCHIR.GT.0) THEN

      LINE='CHIRALITY'
      IXL = IXL+ID1 
      IXLP=IXL+ID1
      IF(IXLP.GT.IXLMAX) THEN
        CALL NEWPG
        CALL TITLE_MONL(MON)
        IXL=ISHX
      ENDIF
      IYL=IYLT-5
      CALL TXTEXT(LINE,ISIZE1,IXL,IYL,IMOD)
C ---
      LINE='ideal crd'
      IXL   = IXL+ID1
      IY1= 5
      IY2= 17+L3
      IY3= 19+L3*2
      IYL1=IY1+95
      IYL2=IY2+95
      IYL3=IY3+95

      IYL1A=IYL1+25
      IYL2A=IYL2+25
      IYL3A=IYL3+25

      IYY1=IYL1+18
      IYY2=IYL2+18
      IYY3=IYL3+18
      CALL TXTEXT(LINE,ISIZE,IXL,IYY1,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY2,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY3,IMOD)
C ---
      IXL  =  IXL+ID2
      DO I=1,3
        CH30(I)=' '
        CH28(I)=' '
        CH28A(I)=' '
      ENDDO
      N=0
      NC=L1C_NCHIR
      IF(NC.GT.0) THEN
      DO L=1,NC
        I1    = L1C_I1ATM(L) 
        I2    = L1C_I2ATM(L) 
        I3    = L1C_I3ATM(L) 
        I4    = L1C_I4ATM(L) 
        ICOOR = 1
        IF(I1.GT.0) THEN
          ACHIR(1) = L1A_ANAME(I1) 
          IF(L1A_COOR_FLAG(I1).NE.'Y') ICOOR = 0
        ELSE 
          ACHIR(1) = '.'  
          ICOOR = 0
        ENDIF
        IF(I2.GT.0) THEN
          ACHIR(2) = L1A_ANAME(I2) 
          IF(L1A_COOR_FLAG(I2).NE.'Y') ICOOR = 0
        ELSE 
          ACHIR(2) = '.'  
          ICOOR = 0
        ENDIF
        IF(I3.GT.0) THEN
          ACHIR(3) = L1A_ANAME(I3) 
          IF(L1A_COOR_FLAG(I3).NE.'Y') ICOOR = 0
        ELSE 
          ACHIR(3) = '.'  
          ICOOR = 0
        ENDIF
        IF(I4.GT.0) THEN
          ACHIR(4) = L1A_ANAME(I4) 
          IF(L1A_COOR_FLAG(I4).NE.'Y') ICOOR = 0
        ELSE 
          ACHIR(4) = '.'  
          ICOOR = 0
        ENDIF
       
        IF(L1C_SIGN(L)(1:4).EQ.'cros'.OR.
     *     L1C_SIGN(L)(1:4).EQ.'star'    ) ICOOR = 1

        IF(ICOOR.EQ.1) THEN
          N=N+1 
          VOL=L1C_VOL(L)
          LINE=L1C_SIGN(L)
          IF(LINE(1:3).EQ.'neg') VOL=-VOL 
          WRITE(CH30(N),400) 
     *    ACHIR(1),ACHIR(2),ACHIR(3),ACHIR(4)
 400      FORMAT(A4,'->',A4,'-',A4,'-',A4)
          WRITE(CH28(N),410) 
     *    VOL
 410      FORMAT(2F8.2)
          WRITE(CH28A(N),410) 
     *    L1C_VOBS(L)
          IF(N.EQ.3) THEN
            CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
            CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
            CALL TXTEXT(CH28A(1),ISIZE,IXL,IYL1A,IMOD)
            CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
            CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
            CALL TXTEXT(CH28A(2),ISIZE,IXL,IYL2A,IMOD)
            CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
            CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
            CALL TXTEXT(CH28A(3),ISIZE,IXL,IYL3A,IMOD)
            DO I=1,3
              CH30(I)=' '
              CH28(I)=' '
              CH28A(I)=' '
            ENDDO
            N=0
            IXL=IXL+IDEL
            IF(IXL.GT.IXLMAX) THEN
              CALL NEWPG
              CALL TITLE_MONL(MON)
              IXL=ISHX
            ENDIF
          ENDIF
        ENDIF
      ENDDO
      IF(N.GT.0) THEN
        CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
        CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
        CALL TXTEXT(CH28A(1),ISIZE,IXL,IYL1A,IMOD)
        CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
        CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
        CALL TXTEXT(CH28A(2),ISIZE,IXL,IYL2A,IMOD)
        CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
        CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
        CALL TXTEXT(CH28A(3),ISIZE,IXL,IYL3A,IMOD)
        DO I=1,3
          CH30(I)=' '
          CH28(I)=' '
          CH28A(I)=' '
        ENDDO
        N=0
        IXL=IXL+IDEL
        IF(IXL.GT.IXLMAX) THEN
          CALL NEWPG
          CALL TITLE_MONL(MON)
          IXL=ISHX
        ENDIF
      ENDIF
      ENDIF

      ENDIF
C ---------------------------------------
      IF(L1P_NPLAN.GT.0) THEN

      LINE='PLANES'
      IXL   = IXL+ID1
      IXLP=IXL+ID1
      IF(IXLP.GT.IXLMAX) THEN
        CALL NEWPG
        CALL TITLE_MONL(MON)
        IXL=ISHX
      ENDIF
      CALL TXTEXT(LINE,ISIZE1,IXL,IYLT,IMOD)
C ---
      LINE='Disp_crd esd'
      IXL   = IXL+ID1
      IY1= 15
      IY2= 35+L3
      IY3= 35+L3*2
      IYL1=IY1+65
      IYL2=IY2+65
      IYL3=IY3+65
      IYY1=IYL1+5
      IYY2=IYL2+5
      IYY3=IYL3+5
      CALL TXTEXT(LINE,ISIZE,IXL,IYY1,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY2,IMOD)
      CALL TXTEXT(LINE,ISIZE,IXL,IYY3,IMOD)
C ---
      IXL  =  IXL+ID2
      DO I=1,3
        CH30(I)=' '
        CH28(I)=' '
      ENDDO
      N=0
      NP=L1P_NPLAN
      IF(NP.GT.0) THEN
        DO IP=1,NP
        NA=L1P_NATOM(IP)
        DO IA=1,NA
          N=N+1 
          WRITE(CH30(N),500) 
     *    L1P_LABEL(IP),L1P_ATOM(IA,IP)
 500      FORMAT(A8,' ',A4)
          WRITE(CH28(N),510) 
     *    L1P_DOBS(IA,IP),L1P_DEV(IA,IP) 
 510      FORMAT(2F7.3)
          IF(N.EQ.3) THEN
            CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
            CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
            CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
            CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
            CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
            CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
            DO I=1,3
              CH30(I)=' '
              CH28(I)=' '
            ENDDO
            N=0
            IXL=IXL+IDEL
            IF(IXL.GT.IXLMAX) THEN
              CALL NEWPG
              CALL TITLE_MONL(MON)
              IXL=ISHX
            ENDIF
          ENDIF
        ENDDO
        ENDDO
        IF(N.GT.0) THEN
          CALL TXTEXT(CH30(1),ISIZE,IXL,IY1,IMOD)
          CALL TXTEXT(CH28(1),ISIZE,IXL,IYL1,IMOD)
          CALL TXTEXT(CH30(2),ISIZE,IXL,IY2,IMOD)
          CALL TXTEXT(CH28(2),ISIZE,IXL,IYL2,IMOD)
          CALL TXTEXT(CH30(3),ISIZE,IXL,IY3,IMOD)
          CALL TXTEXT(CH28(3),ISIZE,IXL,IYL3,IMOD)
          DO I=1,3
            CH30(I)=' '
            CH28(I)=' '
          ENDDO
          N=0
          IXL=IXL+IDEL
          IF(IXL.GT.IXLMAX) THEN
            CALL NEWPG
            CALL TITLE_MONL(MON)
            IXL=ISHX
          ENDIF
        ENDIF
      ENDIF

      ENDIF
C -----------------------------------

      CALL ENDTX

      RETURN
      END

      SUBROUTINE TITLE_MONL(MON)
      CHARACTER MON*3,LINE*256
C -------------------------------
      IMOD  =  1
      IDEL  =  2
      ISIZE = 20
      IXL1  = 25
      IYL   = 230
      LINE  = MON
      CALL TXTEXT(LINE,ISIZE,IXL1,IYL,IMOD)
      RETURN
      END

      SUBROUTINE TITLE_MONL_1(MON,MNAME)
      CHARACTER MON*3,LINE*256,MNAME*(*)
C -------------------------------
      CALL LENSTR_BL(MNAME,LEN)
      IF(LEN.GT.3.AND.MNAME(1:1).NE.'.') THEN
        IMOD  =  1
        ISIZE = 20
        IXL1  = 15
        IYL   = 230
        LINE  = MON
        CALL TXTEXT(LINE,ISIZE,IXL1,IYL,IMOD)
        ISIZE = 10
        IXL1  = 35
        IYL   = 220 - LEN/2
        LINE  = MNAME(1:LEN)
        CALL TXTEXT(LINE,ISIZE,IXL1,IYL,IMOD)
      ELSE
        IMOD  =  1
        ISIZE = 20
        IXL1  = 25
        IYL   = 230
        LINE  = MON
        CALL TXTEXT(LINE,ISIZE,IXL1,IYL,IMOD)
      ENDIF
      RETURN
      END

      SUBROUTINE PROJ_TXL(X,RADBOR,IBX,SCALE,IXP)
C -----------------------------------------------
      REAL      X(3)
      INTEGER   IXP(2)
C --------------------------------------------------------
      Z0     = RADBOR*6.0
      XP     = (X(1)*Z0)/(Z0-X(3))
      YP     = (X(2)*Z0)/(Z0-X(3))
      IXP(1) = (XP*SCALE+IBX/2.0)*10.0
      IXP(2) = (YP*SCALE+IBX/2.0)*10.0
      RETURN
      END

      SUBROUTINE DRAW_FRAME(IBX,IBY)
      IT  = 0
      IT1 = 0
      CALL MOVTXX(IT,IT1)
      IT  = 0
      IT1 = IBY*10.0
      CALL VECTXX(IT,IT1)
      IT  = IBX*10.0
      IT1 = IBY*10.0
      CALL VECTXX(IT,IT1)
      IT  = IBX*10.0
      IT1 = 0
      CALL VECTXX(IT,IT1)
      IT  = 0
      IT1 = 0
      CALL VECTXX(IT,IT1)
      RETURN
      END

C ===============================================

      SUBROUTINE WR_CIF_NEW(MDOC,IUN,PROG,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,IUN
      CHARACTER MON*8,PROG*(*)
      REAL      X(3)
C ----
      CHARACTER LINE*256,TITLE*80,WATOM1*6
      CHARACTER ATOM*4,ASYMB*4,CH27*27,ATOM_FLAG*1,CH1*1
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'CIF_items_crd.fh'
C --------------------------------------------------------
      CH1=''''
      NA  = L1A_NATOM
      MON = L1L_MNAME
      CALL LENSTR_BL(PROG,LP)
C --
      WRITE(LINE,'(''data_structure_'',A)') MON
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C      WRITE(LINE,'(''_database_2.database_id'',2X,A)') MON
C      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---_entry.id
      CALL LENSTR_BL(ICS_ENTRY_ID,L)
      WRITE(LINE,'(A,2X,A)')
     *ICS_ENTRY_ID(1:L),MON
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---_database_2.code_PDB
      CALL LENSTR_BL(ICS_CAT_PDB,L)
      WRITE(LINE,'(A,2X,A)')
     *ICS_CAT_PDB(1:L),MON
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C --- 
      TITLE='coordinates of '//MON//' from program: '//PROG(1:LP)
      CALL LENSTR_BL(TITLE,LEN)
C --- _struct.title
      CALL LENSTR_BL(ICS_TITLE,L)
      I=LEN+L+4      
      IF(I.GT.78) LEN=78-L-4
      WRITE(LINE,'(A,2X,A,A,A)')
     * ICS_TITLE(1:L),CH1,TITLE(1:LEN),CH1
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---
      CALL LENSTR_BL(ICS_CELL_ENT,L)
      WRITE(LINE,'(A,2X,A)')
     *ICS_CELL_ENT(1:L),MON
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---
      T=100.0
      CALL LENSTR_BL(ICS_CELL1,L)
      WRITE(LINE,'(A,5X,F8.3)') 
     * ICS_CELL1(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ICS_CELL2,L)
      WRITE(LINE,'(A,5X,F8.3)') 
     * ICS_CELL2(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ICS_CELL1,L)
      WRITE(LINE,'(A,5X,F8.3)')
     * ICS_CELL3(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      T=90.0
      CALL LENSTR_BL(ICS_CELL4,L)
      WRITE(LINE,'(A,2X,F8.3)')
     * ICS_CELL4(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ICS_CELL5,L)
      WRITE(LINE,'(A,3X,F8.3)')
     * ICS_CELL5(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ICS_CELL6,L)
      WRITE(LINE,'(A,2X,F8.3)')
     * ICS_CELL6(1:L),T
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---
C --- _symmetry.
      CALL LENSTR_BL(ICS_SYMM_ID,L)
      WRITE(LINE,'(A,2X,A)') ICS_SYMM_ID(1:L),MON 
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C --- _symmetry.space_group_name_H-M
      CALL LENSTR_BL(ICS_SYMM_SPGR,L)
      WRITE(LINE,'(A,2X,A,A,A)') 
     * ICS_SYMM_SPGR(1:L),CH1,'P 1',CH1
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C --- _symmetry.Int_Tables_number
      CALL LENSTR_BL(ICS_SYMM_NSPGR,L)
      WRITE(LINE,'(A,2X,A)')
     * ICS_SYMM_NSPGR(1:L),'1'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C --- _symmetry.cell_setting_number
C      CALL LENSTR_BL(ICS_SYMM_SETT,L)
C      WRITE(LINE,'(A,2X,A)') 
C     *ICS_SYMM_SETT(1:L),'1'
C      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C -----------------------------------
      WRITE(LINE,'(''loop_'')') 
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---   _symmetry_equiv.id
      CALL LENSTR_BL(ICS_SYMM_EID,L)
      WRITE(LINE,'(A)') 
     *ICS_SYMM_EID(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---   _symmetry_equiv.pos_as_xyz
      CALL LENSTR_BL(ICS_SYMM_SYMOP,L)
      WRITE(LINE,'(A)')
     *ICS_SYMM_SYMOP(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ---
      LINE='  1   X,Y,Z'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ------------
C --- _entity.
      WRITE(LINE,'(''loop_'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C       _entity.id
      CALL LENSTR_BL(ICS_ENT_ID,L)
      WRITE(LINE,'(A)') ICS_ENT_ID(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C       _entity.type
      CALL LENSTR_BL(ICS_ENT_TYP,L)
      WRITE(LINE,'(A)') ICS_ENT_TYP(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      LINE='   AA   non-polymer'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C --- _struct_asym.
      WRITE(LINE,'(''loop_'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C       _struct_asym.id
      CALL LENSTR_BL(ICS_ASYM_ID,L)
      WRITE(LINE,'(A)') ICS_ASYM_ID(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C       _struct_asym.entity_id
      CALL LENSTR_BL(ICS_ASYM_ENT,L)
      WRITE(LINE,'(A)') ICS_ASYM_ENT(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C _struct_asym.nc_symmetry_id    
c      CALL LENSTR_BL(ICS_ASYM_NCS,L)
c      WRITE(LINE,'(A)') ICS_ASYM_NCS(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C _struct_asym.nc_symmetry_flag
c      CALL LENSTR_BL(ICS_ASYM_FLAG,L)
c      WRITE(LINE,'(A)') ICS_ASYM_FLAG(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C _struct_asym.multiplicity
c      CALL LENSTR_BL(ICS_ASYM_MULT,L)
c      WRITE(LINE,'(A)') ICS_ASYM_MULT(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C_struct_asym.PDB_chain_label
c      CALL LENSTR_BL(ICS_ASYM_PDB,L)
c      WRITE(LINE,'(A)') ICS_ASYM_PDB(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ----------
      LINE = '   AA   AA'
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ------------
C -- _atom_site.
      CALL LENSTR_BL(ITA_ATOM_CAT,LC)
      WRITE(LINE,'(''loop_'')')
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C -- _atom_site.id
      CALL LENSTR_BL(ITA_IATOM,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_IATOM(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C_atom_site.label_atom_id
      CALL LENSTR_BL(ITA_ATOM,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ATOM(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C_atom_site.label_alt_id
      CALL LENSTR_BL(ITA_ALT,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ALT(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

c      CALL LENSTR_BL(ITA_ID_CORR,L)
c      WRITE(LINE,'(A,A)')
c     * ITA_ATOM_CAT(1:LC),ITA_ID_CORR(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C_atom_site.label_comp_id
      CALL LENSTR_BL( ITA_RES,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_RES(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C_atom_site.label_asym_id
      CALL LENSTR_BL(ITA_ASYM,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ASYM(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C_atom_site.label_seq_id
      CALL LENSTR_BL(ITA_ISEQ,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_ISEQ(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

      CALL LENSTR_BL(ITA_XYZ_CRD1,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_XYZ_CRD1(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ITA_XYZ_CRD2,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_XYZ_CRD2(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ITA_XYZ_CRD3,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_XYZ_CRD3(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ITA_OCCUP,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_OCCUP(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
      CALL LENSTR_BL(ITA_B_ISO,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_B_ISO(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

c_atom_site.thermal_displace_type
c      CALL LENSTR_BL(ITA_B_FLAG,L)
c      WRITE(LINE,'(A,A)')
c     * ITA_ATOM_CAT(1:LC),ITA_B_FLAG(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C_atom_site.type_symbol
      CALL LENSTR_BL(ITA_SYMB,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_SYMB(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C_atom_site.symmetry_multiplicity
c      CALL LENSTR_BL(ITA_MULT,L)
c      WRITE(LINE,'(A,A)')
c     * ITA_ATOM_CAT(1:LC),ITA_MULT(1:L)
c      CALL WRTSTR(IUN,MDOC,LINE,IERR)

C_atom_site.calc_flag
      CALL LENSTR_BL(ITA_CALC,L)
      WRITE(LINE,'(A,A)')
     * ITA_ATOM_CAT(1:LC),ITA_CALC(1:L)
      CALL WRTSTR(IUN,MDOC,LINE,IERR)
C ----------------------------

      DO I=1,NA

        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN

          X(1) = L1A_X(I)
          X(2) = L1A_Y(I)
          X(3) = L1A_Z(I)
          WRITE(CH27,'(3(1X,F8.3))') X(1),X(2),X(3)
          ATOM_FLAG = '.'
        ELSE
          CH27='     .        .        .   '
          ATOM_FLAG = 'D'
        ENDIF
        
        WATOM1  = L1A_ANAME(I)
        CALL CORR_NAME_CIF_OUT(WATOM1)
        ASYMB = L1A_SYMB(I)

        CALL LENSTR_BL(ASYMB,LN)
C --- 9.07.03
        IF(LN.GT.3) LN = 3
        ASYMB = ' '//ASYMB(1:LN)
c ---
c        IF(LN.LE.2.AND.L1A_CHARG(I).NE.0.0) THEN
c          CHARGE  = ABS(L1A_CHARG(I)) + 0.1
c          ICHARGE = CHARGE 
c          WRITE(CH1,'(I1)') ICHARGE
c          ASYMB(LN+1:LN+1) = '+'
c          IF(L1A_CHARG(I).LT.0.0) ASYMB(LN+1:LN+1) = '-'
c          ASYMB(LN+2:LN+2) = CH1
c        ENDIF 
c ---
        WRITE(LINE,200) I,WATOM1,MON,CH27,ASYMB,ATOM_FLAG
  200   FORMAT(I5,1X,A6,' . ',A8,' AA  1',A27
     *  ,'   1.00  20.0 ',1X,A4,1X,A1)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

      ENDDO

      END FILE IUN
      CLOSE(IUN,ERR=300)
 300  CONTINUE
      RETURN
      END

      SUBROUTINE WR_PDB_NEW(MDOC,IUN,PROG,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,IUN
      CHARACTER MON*8,PROG*(*)
      REAL      X(3)
C ----
      CHARACTER LINE*256,TITLE*80,CODE*4,RES*3,CH1*1
      CHARACTER ATOM*4,ASYMB*4,ANAME*4,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C --------------------------------------------------------
      NA  = L1A_NATOM
      MON = L1L_MNAME
      CALL LENSTR_BL(PROG,LP)
      CALL LENSTR_BL(MON,LM)
C --
C ---- PDB-TITLE ----
      IF(LP.GT.10) LP = 10
C            123456789     12345678    9 123456789    123456789 ! 
      TITLE='coords of ' //MON(1:LM)//' from prog: '//PROG(1:LP)
      CALL LENSTR_BL(TITLE,LEN)
      IF(LEN.LT.40) THEN
        DO II=LEN+1,40
          TITLE(II:II) = ' '
        ENDDO
      ENDIF
      LMM  = LM
      IF(LM.GT.4) LMM = 4
      CODE = MON(1:LMM)
      IF(LM.LE.3) CODE(4:4) = ' '
      IF(LM.LE.2) CODE(3:3) = ' '
      IF(LM.LE.1) CODE(2:2) = ' '
      WRITE(LINE,140) TITLE(1:40),CODE
  140 FORMAT ('HEADER',4X,A40,9X,3X,A4)
      CALL LENSTR_BL(LINE,LN)
      IF(LN.GT.0) THEN
        WRITE(IUN,'(A)') LINE(1:LN)
      ENDIF
      IF(LM.GT.3) THEN
        WRITE(LINE,200) 
     *  'MODRES'
     *  ,MON(1:3),'A','   1 ',MON
     *  ,'RENAME  '
 200    FORMAT(A6,6X,A3,1X,A1,1X,A5,1X,A8,40X,A8)
        CALL LENSTR_BL(LINE,LN)
        WRITE(IUN,'(A)') LINE(1:LN)        
      ENDIF
C ------------
      CELL1 = 100.0
      CELL2 = 100.0
      CELL3 = 100.0
      CELL4 = 90.0
      CELL5 = 90.0
      CELL6 = 90.0
      WRITE(LINE,100) CELL1,CELL2,CELL3
     *           ,CELL4,CELL5,CELL6,'P 1'
  100 FORMAT ('CRYST1',3F9.3,3F7.2,1X,A)
      CALL LENSTR_BL(LINE,LN)
      IF(LN.GT.0) THEN
        WRITE(IUN,'(A)') LINE(1:LN)
      ENDIF
C ------------
      DO I=1,NA

        IF(L1A_COOR_FLAG(I).EQ.'Y') THEN

          X(1) = L1A_X(I)
          X(2) = L1A_Y(I)
          X(3) = L1A_Z(I)
        
          ATOM  = L1A_ANAME(I)
          ASYMB = L1A_SYMB(I)

          CALL PDB_ANAME(ATOM,ASYMB,RES,ANAME)

c          LIST = ' '
c          CALL PDB_ANAME_MNEW(MDOC,LIST,ATOM,ASYMB,RES,ANAME)

          ASYMB = L1A_SYMB(I)

          CALL LENSTR_BL(ASYMB,LN)
C --- 9.07.03
          IF(LN.GT.3) LN = 3
          ASYMB = ' '//ASYMB(1:LN)
C ---
c          IF(LN.LE.2.AND.L1A_CHARG(I).NE.0.0) THEN
c            CHARGE  = ABS(L1A_CHARG(I)) + 0.1
c            ICHARGE = CHARGE 
c            WRITE(CH1,'(I1)') ICHARGE
c            ASYMB(LN+1:LN+1) = '+'
c            IF(L1A_CHARG(I).LT.0.0) ASYMB(LN+1:LN+1) = '-'
c            ASYMB(LN+2:LN+2) = CH1
c            IF(LN.LE.1) THEN
c              ASYMB = ' '//ASYMB(1:LN+2)
c            ENDIF
c          ELSE
c            IF(LN.LE.1) THEN
c              ASYMB = ' '//ASYMB(1:LN+2)
c            ENDIF
c          ENDIF 
C ---
          IRES = 1
          OCC  = 1.0
          B    = 20.0
          WRITE(LINE,400) I,ANAME,CODE(1:3),IRES
     *                 ,X(1),X(2),X(3),OCC,B,ASYMB
 400  FORMAT('ATOM',1X,I6,1X,A4,1X,A3,1X,'A',I4,4X,3F8.3,2F6.2,10X,A4)
          CALL LENSTR_BL(LINE,LN)
          IF(LN.GT.0) THEN
            WRITE(IUN,'(A)') LINE(1:LN)
          ENDIF
        ENDIF
      ENDDO

      END FILE IUN
      CLOSE(IUN,ERR=300)
 300  CONTINUE
      RETURN
      END

      SUBROUTINE WRITE_TEST(MDOC,k,STR)
C --------------------------------------------
      INTEGER*4 MDOC,k
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,MON*8,STR*(*)
C ---------------------------------------------
      IF(ABS(MDOC).GE.99) RETURN
      NA     = L1A_NATOM
      MON    = L1L_MNAME

      CALL MSGDOC(MDOC,'----------')
      CALL MSGDOC(MDOC,STR)
      WRITE(LINE,*) '--',MON,'--',L1L_PRSNT,'--',k
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(a,5i5)') 
     * '--',NA,L1N_NCONN,C1_NATOM,L1A_NHATOM,L1B_NBOND       
      CALL MSGDOC(MDOC,LINE)

      CALL MSGDOC(MDOC,'--aname,atype,chem,coor_flag')
      DO I=1,NA
         WRITE(LINE,*)
     *   i,L1A_ANAME(I),'/',L1A_ATYPE(I),'/',L1A_CHEM(I)
     *  ,'/',L1A_COOR_FLAG(I),'/',L1A_X(I),L1A_Y(I),L1A_Z(I)
     *  ,L1A_NDIST(I)
        CALL MSGDOC(MDOC,LINE)
      ENDDO

      if(k.eq.1) return

      CALL MSGDOC(MDOC,'--aname,atype,ndist,conn(1,..)')
      DO I=1,NA
        nd = L1A_NDIST(I)
        if(nd.gt.12) nd=12
        if(nd.gt.0) then
          WRITE(LINE,'(i5,a,a,a,a,a,i5,12i5)')
     *    i,'/',L1A_ANAME(I),'/',L1A_ATYPE(I),'/',nd,
     *    (L1A_CONN(j,I),j=1,nd)
        else
          WRITE(LINE,'(i5,a,a,a,a,a,i8)')
     *    i,'/',L1A_ANAME(I),'/',L1A_ATYPE(I),'/',nd
        endif
        CALL MSGDOC(MDOC,LINE)
      ENDDO
      CALL MSGDOC(MDOC,'----')
      WRITE(LINE,'('' -- Nbond:'',i5)') L1B_NBOND 
        CALL MSGDOC(MDOC,LINE)

      IF(L1B_NBOND.GT.0.and.k.eq.2) THEN
        DO IB=1,L1B_NBOND 
   
          IA = L1B_I1ATM(IB) 
          JA = L1B_I2ATM(IB) 
          IF(IA.GT.0.AND.JA.GT.0) THEN        
          WRITE(LINE,*)
     *    IB,'/',L1A_ANAME(iA),'--',L1A_ANAME(JA),'/'
     *    ,L1B_VOBS(IB),L1B_TYPE(IB) 
          CALL MSGDOC(MDOC,LINE)
          ELSE
          WRITE(LINE,*) IB,' -- wrong bond'
          CALL MSGDOC(MDOC,LINE)
          ENDIF
        ENDDO
      ENDIF
      CALL MSGDOC(MDOC,'----------')

      if(k.eq.2) return
 
      LINE = '--aname,atypr,chem,ichir,ichem,iback'//
     * 'iforw,len(1),len(2),nr,rid(1),r_ord,r_flt'
      CALL MSGDOC(MDOC,LINE)
      DO I=1,NA
        nr = L1A_NRING(I)
        nri= 0
        nro= 0
        IF(NR.GT.0) THEN
          NRI = L1A_RING_ID (1,I) 
          NRO = L1A_RING_ORD(1,I)
          IFLAT = L1A_RING_FLAT(1,I)
        ENDIF
        WRITE(LINE,'(I5,A,A,A,A,A,A,I5,I5,I5,4i5,3i5)')
     *  i,L1A_ANAME(I),'/',L1A_ATYPE(I),'/',L1A_CHEM(I),'/',
     *  L1A_ICHIR(I),L1A_ICHEM(I),L1A_IBACK(I),L1A_IFORW(I)
     * ,L1A_LENCON(1,I),L1A_LENCON(2,I)
     * ,NR,NRI,NRO,IFLAT      
        CALL MSGDOC(MDOC,LINE)
      ENDDO
      CALL MSGDOC(MDOC,'----------')

      RETURN
      END

      SUBROUTINE PDB_ANAME_MNEW(MDOC,LIST,ANAME,ASYMB,RNAME,ATOM)
C -----------------------------------------------
      CHARACTER ANAME*4,ASYMB*4,ATOM*4,RNAME*(*)
      CHARACTER LINE*256,LIST*1
C ----------------------------------------------
C ---
      INCLUDE 'metal.fh'
C -----------------------------------------------
C      PARAMETER (N_NAME = 32)
C      CHARACTER NAME(N_NAME)*2
C      DATA NAME/'CO','MG','CA','ZN','CU','FE','CL','BR','MN','PB',
C     *          'HG','AL','GD','NA','CD','NI','SR','IN','HO','YB',
C     *          'TE','LI','RB','BA','CS','SM','TL','PT','BE','SE',
C     *          'MO','SI'/
C ??? more
C ---
C ---------------------------------------------
      CHARACTER CH2*2
C ---------------------------------------------
      CALL LENSTR_BL(ANAME,LEN)
      IF(LEN.LE.3) ANAME(4:4) = ' '
      IF(LEN.LE.2) ANAME(3:3) = ' '
      IF(LEN.LE.1) ANAME(2:2) = ' '

      IF(LIST.EQ.'T') THEN
        LINE = 'in-->'//ANAME//': symb:'//ASYMB//':  '
        CALL MSGDOC(MDOC,LINE)
      ENDIF
      ATOM = '    '
      CH2  = ASYMB(1:2)
      DO  I=1,N_NAME
        IF(NAME(I).EQ.CH2) THEN
          ATOM = ANAME
          RETURN
        ENDIF
      ENDDO      
C ---
      IF(ASYMB.EQ.'H   '.OR.ASYMB.EQ.'D   ') THEN
        ATOM(2:4) = ANAME(1:3)
        IF(ANAME(4:4).NE.' ') ATOM(1:1) = ANAME(4:4)
      ELSE
        IF(ANAME(4:4).NE.' ') THEN
          IF(ANAME(1:1).EQ.ASYMB(1:1)) THEN
            ATOM(2:4) = ANAME(1:3)
            ATOM(1:1) = ANAME(4:4)
          ELSE
            ATOM(1:4) = ANAME(1:4)
          ENDIF
        ELSE
          IF(ANAME(1:1).EQ.ASYMB(1:1)) THEN
            IF(ANAME(2:2).EQ.ASYMB(1:1)) THEN
              ATOM(1:3) = ANAME(1:3)
            ELSE
              ATOM(2:4) = ANAME(1:3)
            ENDIF
          ELSE
            ATOM(1:4) = ANAME(1:3)
          ENDIF
        ENDIF
      ENDIF
C --- special cases --

      IF(RNAME(1:3).EQ.'HEM') THEN
        IF(ANAME.EQ.'NA  ') ATOM=' N A'
        IF(ANAME.EQ.'NB  ') ATOM=' N B'
        IF(ANAME.EQ.'NC  ') ATOM=' N C'
        IF(ANAME.EQ.'ND  ') ATOM=' N D'
      ENDIF

      IF(LIST.EQ.'T') THEN
        LINE = '    >'//ATOM//': symb:'//ASYMB//':  '
        CALL MSGDOC(MDOC,LINE)
      ENDIF

      RETURN
      END

      SUBROUTINE PRECHECK_RES_TYPE(MDOC,ITYPE_RES,IERR)
C -----------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM*4
C -----------------------------
      IERR = 0
      NA   = L1A_NATOM
      ITYPE_RES = 1
C ---
      N_PROT = 0
      N_DNA  = 0
      N_SUG  = 0
      DO I=1,NA
        ATOM = L1A_ANAME(I)
C       P -> O5* - C5*  - C4* = C3* -> O3*
        IF(ATOM.EQ.'O4* '.OR.ATOM.EQ.'O5* '.OR.ATOM.EQ.'C5* '.OR.
     *     ATOM.EQ.'C4* '.OR.ATOM.EQ.'C3* '.OR.ATOM.EQ.'O3* '.OR.
     *     ATOM.EQ.'C1* '.OR.ATOM.EQ.'C2* '.OR.ATOM.EQ.'P   '    ) THEN
          N_DNA = N_DNA + 1
        ELSE IF(ATOM.EQ.'C1  '.OR.ATOM.EQ.'C2  '.OR.ATOM.EQ.'C3  '.OR.
     *     ATOM.EQ.'C4  '.OR.ATOM.EQ.'C5  '.OR.ATOM.EQ.'O5  '    ) THEN
C       C1 -> C2 -> C3 -> C4 -> C5 -> O5
          N_SUG =N_SUG + 1
        ELSE IF(ATOM.EQ.'N   '.OR.ATOM.EQ.'CA  '.OR.ATOM.EQ.'C   '.OR.
     *          ATOM.EQ.'O  '                                    ) THEN
C         N -> CA -> C
          N_PROT = N_PROT + 1
        ENDIF
      ENDDO
      IF(N_DNA.GE.9) THEN
        ITYPE_RES = 5
      ELSE IF(N_SUG.GE.6) THEN
        ITYPE_RES = 7
      ELSE IF(N_PROT.GE.4) THEN
        ITYPE_RES = 3 
      ENDIF

C ----
      RETURN
      END

      SUBROUTINE CHECK_RES_TYPE_BY_ATOM_AND_BOND
     *                                  (MDOC,ITYPE_RES,IERR)
C -----------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM*4
C -----------------------------
      IERR = 0
      NA   = L1A_NATOM
      ITYPE_RES = 1
C ---
      N_PROT = 0
      N_DNA  = 0
      N_SUG  = 0
      N_O2S  = 0
      DO I=1,NA
        ATOM = L1A_ANAME(I)
        IF(ATOM.EQ.'O2* ') N_O2S = N_O2S + 1
C       P -> O5* - C5*  - C4* = C3* -> O3*
        IF(ATOM.EQ.'O4* '.OR.ATOM.EQ.'O5* '.OR.ATOM.EQ.'C5* '.OR.
     *     ATOM.EQ.'C4* '.OR.ATOM.EQ.'C3* '.OR.ATOM.EQ.'O3* '.OR.
     *     ATOM.EQ.'C1* '.OR.ATOM.EQ.'C2* '.OR.ATOM.EQ.'P   '    ) THEN
          N_DNA = N_DNA + 1
        ELSE IF(ATOM.EQ.'C1  '.OR.ATOM.EQ.'C2  '.OR.ATOM.EQ.'C3  '.OR.
     *     ATOM.EQ.'C4  '.OR.ATOM.EQ.'C5  '.OR.ATOM.EQ.'O5  '    ) THEN
C       C1 -> C2 -> C3 -> C4 -> C5 -> O5
          N_SUG =N_SUG + 1
        ELSE IF(ATOM.EQ.'N   '.OR.ATOM.EQ.'CA  '.OR.ATOM.EQ.'C   '.OR.
     *          ATOM.EQ.'O  '                                    ) THEN
C         N -> CA -> C --> O
          N_PROT = N_PROT + 1
        ENDIF
      ENDDO
      IF(N_DNA.GE.9) THEN
         IF(L1B_NBOND.GT.0) THEN
           NB = 0
           DO I=1,L1B_NBOND
           IF(((L1B_1ATM(I).EQ.'P  '.AND.L1B_2ATM(I).EQ.'O5*').OR.
     *         (L1B_1ATM(I).EQ.'O5*'.AND.L1B_2ATM(I).EQ.'P  ')    ).OR.
     *        ((L1B_1ATM(I).EQ.'O5*'.AND.L1B_2ATM(I).EQ.'C5*').OR.
     *         (L1B_1ATM(I).EQ.'C5*'.AND.L1B_2ATM(I).EQ.'O5*')    ).OR.
     *        ((L1B_1ATM(I).EQ.'C5*'.AND.L1B_2ATM(I).EQ.'C4*').OR.
     *         (L1B_1ATM(I).EQ.'C4*'.AND.L1B_2ATM(I).EQ.'C5*')    ).OR.
     *        ((L1B_1ATM(I).EQ.'C4*'.AND.L1B_2ATM(I).EQ.'C3*').OR.
     *         (L1B_1ATM(I).EQ.'C3*'.AND.L1B_2ATM(I).EQ.'C4*')    ).OR.
     *        ((L1B_1ATM(I).EQ.'C3*'.AND.L1B_2ATM(I).EQ.'O3*').OR.
     *         (L1B_1ATM(I).EQ.'O3*'.AND.L1B_2ATM(I).EQ.'C3*')    ).OR.
     *        ((L1B_1ATM(I).EQ.'C3*'.AND.L1B_2ATM(I).EQ.'C2*').OR.
     *         (L1B_1ATM(I).EQ.'C2*'.AND.L1B_2ATM(I).EQ.'C3*')    ).OR.
     *        ((L1B_1ATM(I).EQ.'C2*'.AND.L1B_2ATM(I).EQ.'C1*').OR.
     *         (L1B_1ATM(I).EQ.'C1*'.AND.L1B_2ATM(I).EQ.'C2*')    ).OR.
     *        ((L1B_1ATM(I).EQ.'C1*'.AND.L1B_2ATM(I).EQ.'O4*').OR.
     *         (L1B_1ATM(I).EQ.'O4*'.AND.L1B_2ATM(I).EQ.'C1*')    ).OR.
     *        ((L1B_1ATM(I).EQ.'O4*'.AND.L1B_2ATM(I).EQ.'C4*').OR.
     *         (L1B_1ATM(I).EQ.'C4*'.AND.L1B_2ATM(I).EQ.'O4*')    ))
     *       NB = NB + 1
           ENDDO
           IF(NB.EQ.9) THEN
             ITYPE_RES = 5 
             L1L_TYPE  = 'DNA             '
             IF(N_O2S.GT.0) L1L_TYPE  = 'RNA             '
          ENDIF
         ENDIF
       ELSE IF(N_SUG.GE.6) THEN
         IF(L1B_NBOND.GT.0) THEN
           NB = 0
           DO I=1,L1B_NBOND
             IF(((L1B_1ATM(I).EQ.'C1'.AND.L1B_2ATM(I).EQ.'C2').OR.
     *           (L1B_1ATM(I).EQ.'C2'.AND.L1B_2ATM(I).EQ.'C1')    ).OR.
     *          ((L1B_1ATM(I).EQ.'C2'.AND.L1B_2ATM(I).EQ.'C3').OR.
     *           (L1B_1ATM(I).EQ.'C3'.AND.L1B_2ATM(I).EQ.'C2')    ).OR.
     *          ((L1B_1ATM(I).EQ.'C4'.AND.L1B_2ATM(I).EQ.'C3').OR.
     *           (L1B_1ATM(I).EQ.'C3'.AND.L1B_2ATM(I).EQ.'C4')    ).OR.
     *          ((L1B_1ATM(I).EQ.'C4'.AND.L1B_2ATM(I).EQ.'C5').OR.
     *           (L1B_1ATM(I).EQ.'C5'.AND.L1B_2ATM(I).EQ.'C4')    ).OR.
     *          ((L1B_1ATM(I).EQ.'O5'.AND.L1B_2ATM(I).EQ.'C5').OR.
     *           (L1B_1ATM(I).EQ.'C5'.AND.L1B_2ATM(I).EQ.'O5')    ).OR.
     *          ((L1B_1ATM(I).EQ.'C1'.AND.L1B_2ATM(I).EQ.'O5').OR.
     *           (L1B_1ATM(I).EQ.'O5'.AND.L1B_2ATM(I).EQ.'C1')    ))
     *       NB = NB + 1
           ENDDO
           IF(NB.EQ.6) THEN
             ITYPE_RES = 7
             L1L_TYPE  = 'D-pyranose      '
           ENDIF 
         ENDIF
       ELSE IF(N_PROT.GE.4) THEN
         IF(L1B_NBOND.GT.0) THEN
           NB = 0
           DO I=1,L1B_NBOND
             IF(((L1B_1ATM(I).EQ.'N '.AND.L1B_2ATM(I).EQ.'CA').OR.
     *           (L1B_1ATM(I).EQ.'CA'.AND.L1B_2ATM(I).EQ.'N ')    ).OR.
     *          ((L1B_1ATM(I).EQ.'CA'.AND.L1B_2ATM(I).EQ.'C ').OR.
     *           (L1B_1ATM(I).EQ.'C '.AND.L1B_2ATM(I).EQ.'CA')    ).OR.
     *          ((L1B_1ATM(I).EQ.'C '.AND.L1B_2ATM(I).EQ.'O ').OR.
     *           (L1B_1ATM(I).EQ.'O '.AND.L1B_2ATM(I).EQ.'C ')    ))
     *       NB = NB + 1
           ENDDO
          IF(NB.EQ.3) THEN
            ITYPE_RES = 3 
            L1L_TYPE  = 'L-peptide       '
         ENDIF
        ENDIF
      ENDIF

C ----
      RETURN
      END

      SUBROUTINE CHECK_RES_TYPE(MDOC,ITYPE_RES,IERR)
C -----------------------------
      INTEGER    NRNAME_PAR,NRNAMEP_PAR,NRNAMED_PAR,NRNAMES_PAR

      PARAMETER ( NRNAME_PAR  = 400 )
      PARAMETER ( NRNAMEP_PAR = 200 )
      PARAMETER ( NRNAMED_PAR = 200 )
      PARAMETER ( NRNAMES_PAR = 200 )

      COMMON/COM_RES_TYPE/  NRNAME_T,NRNAMEP_T,NRNAMED_T,NRNAMES_T
     *                     ,RNAME_T,RNAMEP_T,RNAMED_T,RNAMES_T
      INTEGER   NRNAME_T,NRNAMEP_T,NRNAMED_T,NRNAMES_T
      CHARACTER RNAME_T (NRNAME_PAR )*8
      CHARACTER RNAMEP_T(NRNAMEP_PAR)*8
      CHARACTER RNAMED_T(NRNAMED_PAR)*8
      CHARACTER RNAMES_T(NRNAMES_PAR)*8
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256,ATOM*4,MON*8,ATOMJ*4
C -----------------------------
      IERR = 0
      MON  = L1L_MNAME
      NA   = L1A_NATOM
      ITYPE_RES = 1
C ---
      N_PROT = 0
      N_DNA  = 0
      N_SUG  = 0
      I_PROT = 0
      I_DNA  = 0
      I_SUG  = 0
      DO I=1,NA
        ATOM = L1A_ANAME(I)
C       P -> O5* - C5*  - C4* = C3* -> O3*
        IF(ATOM.EQ.'O4* '.OR.ATOM.EQ.'O5* '.OR.ATOM.EQ.'C5* '.OR.
     *     ATOM.EQ.'C4* '.OR.ATOM.EQ.'C3* '.OR.ATOM.EQ.'O3* '.OR.
     *     ATOM.EQ.'C1* '.OR.ATOM.EQ.'C2* '.OR.ATOM.EQ.'P   '    ) THEN
          N_DNA = N_DNA + 1
          IF(ATOM.EQ.'O5* ') THEN
            K  = 0
            IB = L1A_IBACK(I)
            IF(IB.GT.0) THEN
C             IF(L1A_ANAME(IB).EQ.'P   ') K=K+1
              IF(L1A_ANAME(IB).EQ.'C5* ') K=K+1
            ENDIF
            DO J=1,NA
              ATOMJ = L1A_ANAME(J)
              IB    = L1A_IBACK(J)   
              IF(IB.GT.0) THEN
C                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'P   ') K=K+1
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'C5* ') K=K+1
              ENDIF
            ENDDO
            IF(K.LT.1) I_DNA = 1
          ELSE IF(ATOM.EQ.'C5* ') THEN
            K  = 0
            IB = L1A_IBACK(I)
            IF(IB.GT.0) THEN
              IF(L1A_ANAME(IB).EQ.'O5* ') K=K+1
              IF(L1A_ANAME(IB).EQ.'C4* ') K=K+1
            ENDIF
            DO J=1,NA
              ATOMJ = L1A_ANAME(J)
              IB    = L1A_IBACK(J)   
              IF(IB.GT.0) THEN
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'O5* ') K=K+1
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'C4* ') K=K+1
              ENDIF
            ENDDO
            IF(K.LT.2) I_DNA = 1
          ELSE IF(ATOM.EQ.'C4* ') THEN
            K  = 0
            IB = L1A_IBACK(I)
            IF(IB.GT.0) THEN
              IF(L1A_ANAME(IB).EQ.'C5* ') K=K+1
              IF(L1A_ANAME(IB).EQ.'C3* ') K=K+1
            ENDIF
            DO J=1,NA
              ATOMJ = L1A_ANAME(J)
              IB    = L1A_IBACK(J)   
              IF(IB.GT.0) THEN
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'C5* ') K=K+1
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'C3* ') K=K+1
              ENDIF
            ENDDO
            IF(K.LT.2) I_DNA = 1

          ELSE IF(ATOM.EQ.'C3* ') THEN 
            K  = 0
            IB = L1A_IBACK(I)
            IF(IB.GT.0) THEN
              IF(L1A_ANAME(IB).EQ.'C4* ') K=K+1
              IF(L1A_ANAME(IB).EQ.'O3* ') K=K+1
            ENDIF
            DO J=1,NA
              ATOMJ = L1A_ANAME(J)
              IB    = L1A_IBACK(J)   
              IF(IB.GT.0) THEN
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'C4* ') K=K+1
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'O3* ') K=K+1
              ENDIF
            ENDDO
            IF(K.LT.2) I_DNA = 1
          ELSE IF(ATOM.EQ.'O3* ') THEN 
            K  = 0
            IB = L1A_IBACK(I)
            IF(IB.GT.0) THEN
               IF(L1A_ANAME(IB).EQ.'C3* ') K=K+1
            ENDIF
            DO J=1,NA
              ATOMJ = L1A_ANAME(J)
              IB    = L1A_IBACK(J)   
              IF(IB.GT.0) THEN
                 IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'C3* ') K=K+1
              ENDIF
            ENDDO
            IF(K.LT.1) I_DNA = 1
          ENDIF
        ELSE IF(ATOM.EQ.'C1  '.OR.ATOM.EQ.'C2  '.OR.ATOM.EQ.'C3  '.OR.
     *     ATOM.EQ.'C4  '.OR.ATOM.EQ.'C5  '.OR.ATOM.EQ.'O5  '    ) THEN
C       C1 -> C2 -> C3 -> C4 -> C5 -> O5
          N_SUG = N_SUG + 1
          IF(ATOM.EQ.'C2  ') THEN
            K  = 0
            IB = L1A_IBACK(I)
            IF(IB.GT.0) THEN
              IF(L1A_ANAME(IB).EQ.'C1  ') K=K+1
              IF(L1A_ANAME(IB).EQ.'C3  ') K=K+1
            ENDIF
            DO J=1,NA
              ATOMJ = L1A_ANAME(J)
              IB    = L1A_IBACK(J)   
              IF(IB.GT.0) THEN
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'C1  ') K=K+1
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'C3  ') K=K+1
              ENDIF
            ENDDO
            IF(K.LT.2) I_SUG = 1
          ELSE IF(ATOM.EQ.'C3  ') THEN
            K  = 0
            IB = L1A_IBACK(I)
            IF(IB.GT.0) THEN
              IF(L1A_ANAME(IB).EQ.'C2  ') K=K+1
              IF(L1A_ANAME(IB).EQ.'C4  ') K=K+1
            ENDIF
            DO J=1,NA
              ATOMJ = L1A_ANAME(J)
              IB    = L1A_IBACK(J)   
              IF(IB.GT.0) THEN
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'C2  ') K=K+1
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'C4  ') K=K+1
              ENDIF
            ENDDO
            IF(K.LT.2) I_SUG = 1
          ELSE IF(ATOM.EQ.'C4  ') THEN
            K  = 0
            IB = L1A_IBACK(I)
            IF(IB.GT.0) THEN
              IF(L1A_ANAME(IB).EQ.'C3  ') K=K+1
              IF(L1A_ANAME(IB).EQ.'C5  ') K=K+1
            ENDIF
            DO J=1,NA
              ATOMJ = L1A_ANAME(J)
              IB    = L1A_IBACK(J)   
              IF(IB.GT.0) THEN
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'C3  ') K=K+1
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'C5  ') K=K+1
              ENDIF
            ENDDO
            IF(K.LT.2) I_SUG = 1
          ELSE IF(ATOM.EQ.'C5  ') THEN
            K  = 0
            IB = L1A_IBACK(I)
            IF(IB.GT.0) THEN
              IF(L1A_ANAME(IB).EQ.'O5  ') K=K+1
            ENDIF
            DO J=1,NA
              ATOMJ = L1A_ANAME(J)
              IB    = L1A_IBACK(J)   
              IF(IB.GT.0) THEN
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'O5  ') K=K+1
              ENDIF
            ENDDO
            IF(K.LT.1) I_SUG = 1
          ENDIF
        ELSE IF(ATOM.EQ.'N   '.OR.ATOM.EQ.'CA  '.OR.ATOM.EQ.'C   ') THEN
C         N -> CA -> C
          N_PROT = N_PROT + 1
          IF(ATOM.EQ.'CA  ') THEN
            K  = 0
            IB = L1A_IBACK(I)
            IF(IB.GT.0) THEN
              IF(L1A_ANAME(IB).EQ.'C   ') K=K+1
              IF(L1A_ANAME(IB).EQ.'N   ') K=K+1
            ENDIF
            DO J=1,NA
              ATOMJ = L1A_ANAME(J)
              IB    = L1A_IBACK(J)   
              IF(IB.GT.0) THEN
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'C   ') K=K+1
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'N   ') K=K+1
              ENDIF
            ENDDO
            IF(K.LT.2) I_PROT = 1
          ELSE IF(ATOM.EQ.'C   ') THEN
            K  = 0
            IB = L1A_IBACK(I)
            IF(IB.GT.0) THEN
              IF(L1A_ANAME(IB).EQ.'CA  ') K=K+1
              IF(L1A_ANAME(IB).EQ.'O   ') K=K+1
            ENDIF
            DO J=1,NA
              ATOMJ = L1A_ANAME(J)
              IB    = L1A_IBACK(J)   
              IF(IB.GT.0) THEN
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'CA  ') K=K+1
                IF(L1A_ANAME(IB).EQ.ATOM.AND.ATOMJ.EQ.'O   ') K=K+1
              ENDIF
            ENDDO
            IF(K.LT.2) I_PROT = 1
          ENDIF
        ENDIF
      ENDDO
      IF(N_DNA.GE.9.AND.I_DNA.LE.0) THEN
        ITYPE_RES = 5
        L1L_TYPE  = 'DNA             '
      ELSE IF(N_SUG.GE.6.AND.I_SUG.LE.0) THEN
        
        IF(L1B_NBOND.GT.0) THEN
          I_SUG = 1
          DO LB=1,L1B_NBOND
            IF((L1B_1ATM(LB).EQ.'O5  '.AND.L1B_2ATM(LB).EQ.'C1  ').OR.
     *         (L1B_2ATM(LB).EQ.'O5  '.AND.L1B_1ATM(LB).EQ.'C1  ')) THEN
              I_SUG = 0
            ENDIF
          ENDDO
        ENDIF
        IF(I_SUG.LE.0) THEN
          ITYPE_RES = 7
          L1L_TYPE  = 'D-pyranose      '
        ENDIF
      ELSE IF(N_PROT.GE.3.AND.I_PROT.LE.0) THEN
        ITYPE_RES = 3 
        L1L_TYPE  = 'L-peptide       '
      ENDIF
C ----
      IF(ITYPE_RES.GT.1) THEN
        IF(ITYPE_RES.EQ.3) THEN
          IF(NRNAME_T.GT.0) THEN
            DO I=1,NRNAME_T
              IF(RNAME_T(I).EQ.MON) GO TO 100
            ENDDO
          ENDIF
          IF(NRNAME_T.GE.NRNAME_PAR) GO TO 100
          NRNAME_T = NRNAME_T + 1
          RNAME_T(NRNAME_T) = MON       
        ELSE IF(ITYPE_RES.EQ.5) THEN
          IF(NRNAMED_T.GT.0) THEN
            DO I=1,NRNAMED_T
              IF(RNAMED_T(I).EQ.MON) GO TO 100
            ENDDO
          ENDIF
          IF(NRNAMED_T.GE.NRNAMED_PAR) GO TO 100
          NRNAMED_T = NRNAMED_T + 1
          RNAMED_T(NRNAMED_T) = MON       
        ELSE IF(ITYPE_RES.EQ.7) THEN
          IF(NRNAMES_T.GT.0) THEN
            DO I=1,NRNAMES_T
              IF(RNAMES_T(I).EQ.MON) GO TO 100
            ENDDO
          ENDIF
          IF(NRNAMES_T.GE.NRNAMES_PAR) GO TO 100
          NRNAMES_T = NRNAMES_T + 1
          RNAMES_T(NRNAMES_T) = MON                 
        ENDIF
      ENDIF
 100  CONTINUE
C ----
      RETURN
      END

      SUBROUTINE TORSION_CORRECTION(MDOC,LIST,NRINGT,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LIST*1,FLAG*1
      CHARACTER LINE*256
      INTEGER IRING,NR,IFLAT,IATOM(6),ICHIR(6),IACHIR(6),ICONN(6)
      INTEGER NPHI(6),NCH(6),IBOND(6),IPHI(6) 
      REAL    PHI(6) 

      INTEGER MAXRING
      PARAMETER (MAXRING  = 200 )
      INTEGER IORDER(MAXRING),ISCORE(MAXRING)
C --------------------------------------------------------
      IERR = 0
C ---
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      IF(L1A_NATOM.LE.3) RETURN
      IF(L1T_NTORS.LE.0) RETURN

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) ' --- TORSION_CORRECTION --',NRINGT
      ENDIF
C ---
      IF(L1C_NCHIR.GT.0) THEN
C     L1C_FLAG = 'N'- user def(min descr); new: 'R'or 'L' from coord;'B' both
C                     L1L_PRSNT='M'        L1L_PRSNT='M'or'N'
C       check user chiralities. From coords will be accepted.      
        DO  I = 1,L1C_NCHIR 
          IF(L1C_SIGN(I)(1:4).EQ.'star'.OR.
     *       L1C_SIGN(I)(1:4).EQ.'cros'     ) THEN
            L1C_FLAG(I) = 'X'
          ELSE 
            IF(L1C_FLAG(I).EQ.'N') THEN
              IF(L1C_SIGN(I)(1:3).EQ.'pos') THEN
                FLAG = 'R'
              ELSE IF(L1C_SIGN(I)(1:3).EQ.'neg') THEN
                FLAG = 'L'
              ELSE
                FLAG = 'B'
              ENDIF
              CALL CALC_OVOL(I,VOLOBS,IERR)
              IF(IERR.EQ.0) THEN
                IF(VOLOBS.LT.0.0) THEN
                  L1C_FLAG(I) = 'L'
                ELSE
                  L1C_FLAG(I) = 'R'
                ENDIF
              ELSE
                L1C_FLAG(I) = FLAG
              ENDIF
              IERR = 0
              IF(FLAG.NE.'B'.AND.FLAG.NE.L1C_FLAG(I)) THEN
                LINE = 
     *' WARNING: in TORSION_CORRECTION: problem with chir:'//L1C_1ATM(I)
                CALL MSGERR(MDOC,LINE)
                LINE = 
     *         '          '//'user chiralities<->from coords (accepted)' 
                CALL MSGERR(MDOC,LINE)
              ENDIF
            ENDIF
          ENDIF
        ENDDO
      ENDIF
C ---
      IF(NRINGT.LE.0) RETURN

C --- ring order: plan, ring6(flat),ring5(flat); ring6(flat),ring5 
C                        sp2 >4       sp2 > 2
C     Icoef       *10000     *1000     *100          *10
C     NBR( neighbor rings+1)   ---  7,6,5,4,3,2,1 ----                 
C     ISCORE() = ICOEF*NBR           

      NRT = 0
      DO IRING=1,NRINGT
        CALL GET_RING(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR       
     *                    ,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
        IF(LIST.EQ.'T') THEN
          WRITE(*,*) ' ierr --',ierr,NR
        ENDIF
        IF(IERR.EQ.2) THEN
          CALL MSGERR(MDOC,
     *    ' WARNING: not possible to do Torsion Correction')
          IERR = 0
          GO TO 500
        ENDIF
        IF(IERR.EQ.3) THEN
C         some ring with theta = 180
        ENDIF
        IF(IERR.EQ.0.AND.NRT.LT.MAXRING) THEN 
          NRT         = NRT + 1
          IORDER(NRT) = IRING
          NBR         = 0
          DO I=1,NR
            IF(IBOND(I).GT.0) NBR = NBR + 1
          ENDDO
        
          ICOEF = 1
          IF(NR.EQ.6) ICOEF = 10 
          IF(IFLAT.EQ.2) ICOEF = 10000  
          IF(IFLAT.EQ.1.AND.NR.EQ.6) ICOEF = 1000  
          IF(IFLAT.EQ.1.AND.NR.EQ.5) ICOEF = 100  
          ISCORE(NRT) = ICOEF*(NBR+1) 
        ELSE
          IERR = 0 
          IF(NRT.GE.MAXRING) GO TO 600
        ENDIF
      ENDDO
 600  CONTINUE

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) ' NRT --',NRT,IORDER(1)
      ENDIF

        IF(LIST.EQ.'T') THEN
          IF(L1C_NCHIR.GT.0) THEN
            DO IC=1,L1C_NCHIR
             WRITE(*,'(A,5I5,A)') 'CH:',IC,L1C_I1ATM(IC),L1C_I2ATM(IC)
     *         ,L1C_I3ATM(IC),L1C_I4ATM(IC),L1C_FLAG(IC)
            ENDDO
          ENDIF
          IF(L1T_NTORS.GT.0) THEN
            DO IT=1,L1T_NTORS
              WRITE(*,'(A,5I5,A,F8.2)') 'TR:',IT,L1T_I1ATM(IT)
     *        ,L1T_I2ATM(IT),L1T_I3ATM(IT),L1T_I4ATM(IT),L1T_FLAG(IT)
     *        ,L1T_VOBS(IT)
            ENDDO
          ENDIF
        ENDIF




      IF(NRT.LE.0) THEN
C       no rings -  5, 6
        CALL MSGERR(MDOC,
     *  ' WARNING: all rings are not 5 or 6 order')
        GO TO 500
      ENDIF

C     sort
      IF(NRT.GT.1) THEN
        DO I=1,NRT-1      
          DO J=2,NRT
            IF(ISCORE(I).LT.ISCORE(J)) THEN
              IT        = ISCORE(J) 
              ISCORE(J) = ISCORE(I)
              ISCORE(I) = IT 
              IT        = IORDER(J) 
              IORDER(J) = IORDER(I)
              IORDER(I) = IT 
            ENDIF      
          ENDDO
        ENDDO
      ENDIF
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) ' NRT,IORD(1) --',NRT,IORDER(1)
        WRITE(*,*) ' ----START plan-CYCLES ---'
      ENDIF
C ---
C     flat rings    
      DO JRING=1,NRT
        IRING = IORDER(JRING) 
        CALL GET_RING(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR,ICONN,IPHI       
     *                    ,NCH,NPHI,IBOND,LIST,IERR)        

C        WRITE(*,*) ' --plan:',iring,iflat,ierr

        IF(IERR.NE.0.OR.IFLAT.LE.0) THEN
          IERR = 0
          GO TO 100
        ENDIF

        CALL SET_PLAN_TORS(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR,ICONN
     *                   ,IPHI,NCH,NPHI,IBOND,LIST,IERR)        

        IF(IERR.NE.0) RETURN

        IF(LIST.EQ.'T') THEN
          IF(L1C_NCHIR.GT.0) THEN
            DO IC=1,L1C_NCHIR
            WRITE(*,'(A,5I5,A)') 'CH:',IC,L1C_I1ATM(IC),L1C_I2ATM(IC)
     *         ,L1C_I3ATM(IC),L1C_I4ATM(IC),L1C_FLAG(IC)
            ENDDO
          ENDIF
          IF(L1T_NTORS.GT.0) THEN
            DO IT=1,L1T_NTORS
              WRITE(*,'(A,5I5,A,F8.2)') 'TR:',IT,L1T_I1ATM(IT)
     *       ,L1T_I2ATM(IT),L1T_I3ATM(IT),L1T_I4ATM(IT),L1T_FLAG(IT)
     *       ,L1T_VOBS(IT)
            ENDDO
          ENDIF
        ENDIF

 100    CONTINUE
      ENDDO
C ---
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) ' ----START ring -CYCLES ---'
      ENDIF

C     non-flat rings
      DO JRING=1,NRT
        IRING = IORDER(JRING) 
        CALL GET_RING(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR,ICONN,IPHI       
     *                    ,NCH,NPHI,IBOND,LIST,IERR)        

c        WRITE(*,*) ' --tors:',iring,iflat,ierr

        IF(IERR.NE.0.OR.IFLAT.GE.1) THEN
          IERR = 0
          GO TO 200
        ENDIF

        CALL SET_RING_TORS(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR,ICONN
     *                   ,IPHI,NCH,NPHI,IBOND,LIST,IERR)        

        IF(IERR.NE.0) RETURN

        IF(LIST.EQ.'T') THEN
          IF(L1C_NCHIR.GT.0) THEN
            DO IC=1,L1C_NCHIR
             WRITE(*,'(A,5I5,A)') 'CH:',IC,L1C_I1ATM(IC),L1C_I2ATM(IC)
     *         ,L1C_I3ATM(IC),L1C_I4ATM(IC),L1C_FLAG(IC)
            ENDDO
          ENDIF
          IF(L1T_NTORS.GT.0) THEN
            DO IT=1,L1T_NTORS
              WRITE(*,'(A,5I5,A,F8.2)') 'TR:',IT,L1T_I1ATM(IT)
     *        ,L1T_I2ATM(IT),L1T_I3ATM(IT),L1T_I4ATM(IT),L1T_FLAG(IT)
     *        ,L1T_VOBS(IT)
            ENDDO
          ENDIF
        ENDIF


 200    CONTINUE
      ENDDO

 500  CONTINUE

      DO ITORS=1,L1T_NTORS
        I1 = L1T_I1ATM(ITORS)
        I2 = L1T_I2ATM(ITORS)
        I3 = L1T_I3ATM(ITORS)
        I4 = L1T_I4ATM(ITORS)
        IF(L1T_FLAG(ITORS).EQ.'D') THEN
          L1T_VAL(ITORS) =  L1T_VOBS(ITORS)
          IF(I1.GT.0.AND.I2.GT.0.AND.I3.GT.0.AND.I4.GT.0) THEN
          IF(L1A_COOR_FLAG(I1).EQ.'Y'.AND.L1A_COOR_FLAG(I2).EQ.'Y'.AND.
     *       L1A_COOR_FLAG(I3).EQ.'Y'.AND.L1A_COOR_FLAG(I4).EQ.'Y') THEN
            CALL CALC_TRSOBS(I1,I2,I3,I4,VOBS)
            L1T_VOBS(ITORS) = VOBS
          ENDIF
          ENDIF         
        ENDIF         
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE GET_RING(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR,ICONN
     *                   ,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     neighbor: 2-plan,1-flat, 5, 6
C                          
C ----
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*),IPHI(*)
      CHARACTER CHEM*4,LIST*1              
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0      
      NR   = 0      

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '------------> GET_RING:',IRING 
      ENDIF

C     NR IATOM()        
      DO IA=1,L1A_NATOM
        IF(L1A_NRING(IA).NE.0) THEN
          DO IRA=1,L1A_NRING(IA)
            IRING_ID = L1A_RING_ID (IRA,IA)
C           IORD     = L1A_RING_ORD(IRA,IA)
            IF(IRING_ID.EQ.IRING) THEN
              NR   = NR + 1
C             IFL      = L1A_RING_FLAT(IRA,IA)
C             IFL > 0  flat
              IF(NR.LE.6) THEN        
                IATOM(NR) = IA
              ENDIF
            ENDIF
          ENDDO
        ENDIF 
      ENDDO
      IF(NR.LT.5.OR.NR.GT.6) THEN
        IERR = 1 
        RETURN
      ENDIF 

C ---------------
C     order
      CALL GET_RING_ORDER(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR,ICONN
     *                    ,IPHI,NCH,NPHI,IBOND,IERR)        
      IF(IERR.NE.0) RETURN
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '--NR:',NR        
        WRITE(*,'(A,6I5)') '--iatom:',(IATOM(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6(1X,A4))') 
     *   '--atom :',(L1A_ANAME(IATOM(JJJJ)),JJJJ=1,NR) 
      ENDIF     
C ---------------
C     flat: 2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)
C
c     (ia1,ia2--ia..) in the same plan iflat = 2
c     else   Nsp2  (ring6: sp2 >4 ; ring5: sp2 > 2) --> iflat = 1    

      IFLAT = 0

      CALL CHECK_RING_IS_PLAN(IRING,IFLAGP) 
      IF(IFLAGP.GT.0) IFLAT = IFLAGP

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,I5)') '--FLAT:',IFLAT
      ENDIF     

C ---------------
c     ICONN() = 1 met_chir
C ---------------
C      NCH()           ICHIR()             IACHIR()   
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom    
C                                                          
      CALL GET_RING_CHIR(MDOC,IRING,NR,JFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)     
      IF(IERR.NE.0) RETURN

      IF(JFLAT.GT.0.AND.IFLAT.LE.0) IFLAT = JFLAT

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,6I5)') '--NCH :',(NCH(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '--CHIR:',(ICHIR(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '--ACHR:',(IACHIR(JJJJ),JJJJ=1,NR) 
      ENDIF     
C
C ---------------
C     NPHI()           IPHI() 
C     tors_id         0,(+/-)1,9 

      CALL GET_RING_TORS(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)        

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,6I5)') '--NPHI:',(NPHI(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '--IPHI:',(IPHI(JJJJ),JJJJ=1,NR) 
      ENDIF     
C
C ---------------
C     IBOND()        
C     neighbor: 2-plan,1-flat, 5, 6

      CALL GET_RING_BOND(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)        

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,6I5)') '--BOND:',(IBOND(JJJJ),JJJJ=1,NR) 
      ENDIF     
C
C ---------------
      RETURN
      END

      SUBROUTINE SET_PLAN_TORS(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR
     *                  ,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat, 5, 6
C                          
C ----
C ----
      CHARACTER LIST*1,LINE*256
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0      
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '------------> SET_PLAN_TORS:',IRING 
      ENDIF

      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)

        IF(NPHI(I2).LE.0) THEN
C         there is not tors
C
          LINE = 
     *' WARNING: in TORSION_CORRECTION: missing tors.:'//L1A_ANAME(IA2)
     *         //' - '//L1A_ANAME(IA3)     
          CALL MSGERR(MDOC,LINE)
          NV = 0
          NC = 0  
          CALL SET_VTORS(MDOC,IA1,IA2,IA3,IA4,NV,NC,IERR)
          IF(IERR.NE.0) RETURN
          IPHI(I2) = 9
          NPHI(I2) = L1T_NTORS
          L1T_VOBS(L1T_NTORS) = 0.0
          IF(ICONN(I2).GT.0.OR.ICONN(I3).GT.0) L1T_VAL(L1T_NTORS)=0.0
        ENDIF

        ICHIR2 = ICHIR(I2)
        ICHIR3 = ICHIR(I3)

        IF(NPHI(I2).GT.0) THEN
          IF(IBOND(I2).GT.0) THEN
C           there is neighbor ring I2-I3
C
            CALL GET_CORRECT_CHIR(ICHIR(I2),ICHIR(I3),IBOND(I2)
     *                                             ,ICHIR2,ICHIR3) 
 
            IF(IPHI(I2).LT.9) THEN
C             tors was defined before           
C             check ichir(i2),ichir(i3) # 9 (if(nch(i2),nch(i3) > 0)
            ELSE
C             set chir I2,I3: (RR) (LL) 
              IF(NCH(I2).GT.0.AND.NCH(I3).GT.0) THEN        
                IF(ICHIR2.EQ.9) THEN
C                 9 --> ? 
                  IF(ICHIR3.EQ.1) THEN
C                   set R - (R)
                    ICHIR2 = 1 
                  ELSE IF(ICHIR3.EQ.-1) THEN
C                   set L - (L)
                    ICHIR2 =-1 
                  ELSE
C                   set R - R (i.e 9-9) 
                    ICHIR2 = 1 
                    ICHIR3 = 1 
                  ENDIF   
                ELSE IF(ICHIR3.EQ.9) THEN
C                 9 --> ?
                  IF(ICHIR2.EQ.1) THEN
C                   set (R) - R 
                    ICHIR3 = 1 
                  ELSE IF(ICHIR3.EQ.-1) THEN
C                   set (L) - L
                    ICHIR3 =-1 
CC--              ELSE
CC--                set RR
CC--                ICHIR2 = 1 
CC--                ICHIR3 = 1 
                  ENDIF   
                ELSE IF(ICHIR2.NE.ICHIR3) THEN
C                 not possible (R-L or L-R)
C                 ?
                ENDIF
              ELSE
                IF(ICHIR2.EQ.0.AND.ICHIR3.EQ.9) THEN
C                 0 --> 9
                  IF(IBOND(I3).GT.0) THEN
                    IF(ICHIR(I4).GE.0) THEN
C                          3
C                     set  R - (R) or R - (0) or  R - (9) 
                      ICHIR3 = 1 
                    ELSE IF(ICHIR(I4).EQ.-1) THEN
C                          3
C                     set  L - (L)  
                      ICHIR3 =-1 
                    ENDIF
                  ENDIF
                ELSE IF(ICHIR2.EQ.9.AND.ICHIR3.EQ.0) THEN
C                 9 --> 0
                  IF(IBOND(I2).GT.0) THEN
                    IF(ICHIR(I1).GE.1) THEN
C                               2
C                     set  (R) -  R or (0) - R or  (9) - R 
                      ICHIR2 = 1 
                    ELSE IF(ICHIR(I1).EQ.-1) THEN
C                                 2 
C                     set  (L) -  L  
                      ICHIR2 =-1 
                    ENDIF
                  ENDIF
         
                ENDIF
              ENDIF
              IPHI(I2) = 0
            ENDIF

            CALL SET_CORRECT_CHIR(ICHIR2,ICHIR3,IBOND(I2)
     *                                     ,ICHIR(I2),ICHIR(I3))
          ENDIF
        ENDIF

c        
C                  --sp3--           --sp3--
C         check  flat ! flat   or  plan ! plan      not possible
C                  --sp2--           --sp3--
C               (or single plan)
C
      ENDDO

      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(IBOND(I2).LE.0) THEN
C         there is not neighbor ring I2-I3
          IF(ICHIR(I2).EQ.9) THEN
C           2      2     2     
C           L~(R)  R~(L) R~(R)
            IF(ICHIR(I3).EQ.1) THEN
              ICHIR(I2) =-1
            ELSE
              ICHIR(I2) = 1
            ENDIF
          ENDIF

          IF(NPHI(I2).GT.0.AND.IPHI(I2).EQ.9) THEN
C           there is tors which is not defined
C
            IPHI(I2) = 0

          ENDIF
        ENDIF
      ENDDO 

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,6I5)') '  NCH :',(NCH(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  CHIR:',(ICHIR(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  NPHI:',(NPHI(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  IPHI:',(IPHI(JJJJ),JJJJ=1,NR) 
      ENDIF     


      CALL CHIR_TO_LIST(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        


      CALL TORS_TO_LIST(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,6I5)') '  NCH :',(NCH(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  CHIR:',(ICHIR(JJJJ),JJJJ=1,NR) 
      ENDIF     

      RETURN
      END

      SUBROUTINE GET_CORRECT_CHIR(ICHIR1,ICHIR2,IBOND,ICH1,ICH2)
C ---- 
      INTEGER ICHIR1,ICHIR2,IBOND,ICH1,ICH2 
C ---- 
      IB = IBOND/100
      IB = IBOND - IB*100
      ICH1 = ICHIR1
      IF(IB.GT.20.AND.ICH1.NE.9) ICH1 = -ICH1
      ICH2 = ICHIR2
      IF(MOD(IB,2).EQ.0.AND.ICH2.NE.9) ICH2 = -ICH2        
C ---- 
      RETURN
      END

      SUBROUTINE SET_CORRECT_CHIR(ICH1,ICH2,IBOND,ICHIR1,ICHIR2)
C ---- 
      INTEGER ICHIR1,ICHIR2,IBOND,ICH1,ICH2 
C ---- 
      IB = IBOND/100
      IB = IBOND - IB*100
      IF(ICHIR1.EQ.9) THEN
        ICHIR1 = ICH1
        IF(IB.GT.20) ICHIR1 = -ICHIR1
      ENDIF
      IF(ICHIR2.EQ.9) THEN
        ICHIR2 = ICH2
        IF(MOD(IB,2).EQ.0) ICHIR2 = -ICHIR2       
      ENDIF
C ---- 
      RETURN
      END

      SUBROUTINE SET_RING_TORS(MDOC,IRING,NR,IFLAT,IATOM,ICHIR,IACHIR
     *                   ,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat, 5, 6
C                          
C ----
      CHARACTER LIST*1,LINE*256
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
C
      INTEGER IFRAME_PS(6),IFRAME_NPS(6),IFRAME(6)        
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0      
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '------------> SET_RING_TORS:',IRING 
      ENDIF
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(NPHI(I2).LE.0) THEN
C         there is not tors
C
          LINE = 
     *' WARNING: in TORSION_CORRECTION: missing tors.:'//L1A_ANAME(IA2)
     *         //' - '//L1A_ANAME(IA3)     
          CALL MSGERR(MDOC,LINE)
          NV = 0
          NC = 0  
          CALL SET_VTORS(MDOC,IA1,IA2,IA3,IA4,NV,NC,IERR)
          IF(IERR.NE.0) RETURN
          IPHI(I2) = 9
          NPHI(I2) = L1T_NTORS
C???        
C         L1T_VOBS(L1T_NTORS) = ? chir(i2) , cir(i3)
C???
        ENDIF
      ENDDO

      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
C ---   possible phi
        IFRAME_PS(I2) = IPHI(I2)
C ---   nonpossible phi
        IFRAME_NPS(I2) = 9
        INP = 9
c       phi -

        CALL GET_CORRECT_CHIR(ICHIR(I2),ICHIR(I3),IBOND(I2)
     *                                             ,ICHIR2,ICHIR3) 

        IF((ICHIR2.EQ.-1.AND.ICHIR3.EQ.1).OR. 
     *     (ICHIR2.EQ.-1.AND.ICHIR3.EQ.0).OR. 
     *     (ICHIR2.EQ. 0.AND.ICHIR3.EQ.1)    ) 
     *  INP =-1
        IF(IBOND(I2).GE.100) THEN
          IF((ICHIR2.EQ. 1.AND.ICHIR3.EQ.-1).OR. 
     *       (ICHIR2.EQ. 1.AND.ICHIR3.EQ. 1).OR. 
     *       (ICHIR2.EQ.-1.AND.ICHIR3.EQ.-1).OR. 
     *       (ICHIR2.EQ. 0.AND.ICHIR3.EQ. 0)    ) 
     *    INP =-1
        ENDIF
        IF(INP.NE.9.AND.IFRAME_PS(I2).NE.9) THEN
C         error
          INP = 9
          GO TO 100
        ENDIF
        INP2 = 9
C -     phi +
        IF((ICHIR2.EQ. 1.AND.ICHIR3.EQ.-1).OR. 
     *     (ICHIR2.EQ. 1.AND.ICHIR3.EQ. 0).OR. 
     *     (ICHIR2.EQ. 0.AND.ICHIR3.EQ.-1)    ) 
     *  INP2 = 1
        IF(IBOND(I2).GE.100) THEN
          IF((ICHIR2.EQ.-1.AND.ICHIR3.EQ. 1).OR. 
     *       (ICHIR2.EQ. 1.AND.ICHIR3.EQ. 1).OR. 
     *       (ICHIR2.EQ.-1.AND.ICHIR3.EQ.-1).OR. 
     *       (ICHIR2.EQ. 0.AND.ICHIR3.EQ. 0)    ) 
     *    INP2 = 1
        ENDIF
        IF(INP2.NE.9.AND.IFRAME_PS(I2).NE.9) THEN
C         error
          INP = 9
          GO TO 100
        ENDIF
        IF(INP.NE.9) THEN
          IFRAME_PS(I2) = 0
          GO TO 100
        ELSE
          INP = INP2
        ENDIF
C -     phi 0
        INP2 = 9
        IF((ICHIR2.EQ.-1.AND.ICHIR3.EQ. 1).OR. 
     *     (ICHIR2.EQ. 1.AND.ICHIR3.EQ.-1)    ) 
     *  INP = 0
        IF(IBOND(I2).GE.100) THEN
          IF((ICHIR2.EQ. 0.AND.ICHIR3.EQ. 1).OR. 
     *       (ICHIR2.EQ. 0.AND.ICHIR3.EQ.-1).OR. 
     *       (ICHIR2.EQ. 1.AND.ICHIR3.EQ. 0).OR. 
     *       (ICHIR2.EQ.-1.AND.ICHIR3.EQ. 0)    ) 
     *    INP2 = 0
        ENDIF
        IF(INP2.NE.9.AND.IFRAME_PS(I2).NE.9) THEN
C         error
          INP = 9
          GO TO 100
        ENDIF
        INP = INP2
 100    CONTINUE
        IFRAME_NPS(I2) = INP
C ---
      ENDDO

C ---
C     number of 0
C     ?
C     ? go to?
C ----

      CALL GET_FRAME(NR,IFRAME_PS,IFRAME_NPS,IFRAME,ISCORE,ITB)

C   !  3 CYCLES FOR +, -, 0
C   !
C   V
C
C ---- 
C
C + 
C
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '-fr-p :',(IFRAME_PS(jjjj),jjjj=1,nr)
        WRITE(*,*) '-fr-np:',(IFRAME_NPS(jjjj),jjjj=1,nr)
        WRITE(*,*) '-fr   :',(IFRAME(jjjj),jjjj=1,nr)
      ENDIF

      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(NPHI(I2).GT.0) THEN
C         there is tors
C
          IF(IBOND(I2).GT.0) THEN
C           there is neighbor ring I2-I3
C

            CALL GET_CORRECT_CHIR(ICHIR(I2),ICHIR(I3),IBOND(I2)
     *                                             ,ICHIR2,ICHIR3) 

            IF(IPHI(I2).LT.9) THEN
C             tors was defined before           
C             check ichir(i2),ichir(i3) # 9 (if(nch(i2),nch(i3) > 0) 

            ELSE
C             set chir I2,I3:
              IF(IFRAME(I2).EQ.1) THEN
                IF(ICHIR2.EQ.9) ICHIR2 =-1
                IF(ICHIR3.EQ.9) ICHIR3 = 1
              ENDIF

            ENDIF
 
            CALL SET_CORRECT_CHIR(ICHIR2,ICHIR3,IBOND(I2)
     *                                     ,ICHIR(I2),ICHIR(I3))

          ENDIF 

        ENDIF
      ENDDO
C
C -
C
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(NPHI(I2).GT.0) THEN
C         there is tors
C
          IF(IBOND(I2).GT.0) THEN
C           there is neighbor ring I2-I3
C

            CALL GET_CORRECT_CHIR(ICHIR(I2),ICHIR(I3),IBOND(I2)
     *                                             ,ICHIR2,ICHIR3) 


            IF(IPHI(I2).LT.9) THEN
C             tors was defined before           
C             check ichir(i2),ichir(i3) # 9 (if(nch(i2),nch(i3) > 0) 

            ELSE
C             set chir I2,I3:
              IF(IFRAME(I2).EQ.-1) THEN
                IF(ICHIR2.EQ.9) ICHIR2 = 1
                IF(ICHIR3.EQ.9) ICHIR3 =-1
              ENDIF

            ENDIF
 
            CALL SET_CORRECT_CHIR(ICHIR2,ICHIR3,IBOND(I2)
     *                                     ,ICHIR(I2),ICHIR(I3))

          ENDIF 

        ENDIF
      ENDDO
C
C 0
C
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(NPHI(I2).GT.0) THEN
C         there is tors
C
          IF(IBOND(I2).GT.0) THEN
C           there is neighbor ring I2-I3
C

            CALL GET_CORRECT_CHIR(ICHIR(I2),ICHIR(I3),IBOND(I2)
     *                                             ,ICHIR2,ICHIR3) 
            IF(IPHI(I2).LT.9) THEN
C             tors was defined before           
C             check ichir(i2),ichir(i3) # 9 (if(nch(i2),nch(i3) > 0) 

            ELSE
C             set chir I2,I3:
              IF(IFRAME(I2).EQ. 0) THEN
                IF(ICHIR2.EQ.9.AND.ICHIR3.EQ.-1) THEN
                  ICHIR2 =-1
                ELSE IF(ICHIR3.EQ.9.AND.ICHIR2.EQ.-1) THEN
                  ICHIR3 =-1
                ELSE
                  IF(ICHIR2.EQ.9) ICHIR2 = 1
                  IF(ICHIR3.EQ.9) ICHIR3 = 1
                ENDIF
              ENDIF

              IPHI(I2) = IFRAME(I2)   
  
            ENDIF
 
            CALL SET_CORRECT_CHIR(ICHIR2,ICHIR3,IBOND(I2)
     *                                     ,ICHIR(I2),ICHIR(I3))

          ENDIF 

        ENDIF
      ENDDO
C ---
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(IBOND(I2).LE.0) THEN
C         there is not neighbor ring I2-I3
          IF(ICHIR(I2).EQ.9) THEN
C           2      2     2     
C           L~(R)  R~(L) R~(R)
            ICHIR(I2) = 1
            IF(ICHIR(I3).EQ.1) ICHIR(I2) =-1  
          ENDIF

          IF(NPHI(I2).GT.0.AND.IPHI(I2).EQ.9) THEN
C           there is tors which is not defined
C
            IFR = IFRAME(I2)

            IF((NR.EQ.6.AND.(ITB.EQ.5.OR.ITB.EQ.6)
     *                        .AND.IFRAME(I3).EQ.0).OR. 
     *         (NR.EQ.5.AND.(ITB.EQ.1.OR.ITB.EQ.2)
     *             .AND.(IFRAME(I1).EQ.0.OR.IFRAME(I3).EQ.0))) THEN
              IF(IFR.LT.0) THEN
                IFR =-2
              ELSE
                IFR = 2
              ENDIF

            ENDIF

            IPHI(I2) = IFR

          ENDIF
        ENDIF
      ENDDO 

      IF(LIST.EQ.'T') THEN
        WRITE(*,'(A,6I5)') '  NCH :',(NCH(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  CHIR:',(ICHIR(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  ACHR:',(IACHIR(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  NPHI:',(NPHI(JJJJ),JJJJ=1,NR) 
        WRITE(*,'(A,6I5)') '  IPHI:',(IPHI(JJJJ),JJJJ=1,NR) 
      ENDIF     

      CALL CHIR_TO_LIST(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
      CALL TORS_TO_LIST(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        

C ---
      RETURN
      END

      SUBROUTINE GET_FRAME(NR,IFRAME_PS,IFRAME_NPS,IFRAME
     *                                           ,ISCORE,ITBEST)
C ---
      INTEGER IFRAME_PS(*),IFRAME_NPS(*),IFRAME(*)        
      INTEGER ITAB6(12,9),ITAB5(10,3)      
      DATA ITAB6/
     *   0, 1,-1, 0, 1,-1, 0, 1,-1, 0, 1,-1,
     *   0,-1, 1, 0,-1, 1, 0,-1, 1, 0,-1, 1,
     *   0, 0, 1,-1, 1,-1, 0, 0, 1,-1, 1,-1,
     *   0, 0,-1, 1,-1, 1, 0, 0,-1, 1,-1, 1,
     *   0, 1, 0,-1, 1,-1, 0, 1, 0,-1, 1,-1,
     *   0,-1, 0, 1,-1, 1, 0,-1, 0, 1,-1, 1,
     *   1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
     *  -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
     *   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 /
C        1  2  3  4  5  6  7  8  9 10 11 12
C ---
      DATA ITAB5/
     *   0, 1,-1, 1,-1, 0, 1,-1, 1,-1,  
     *   0,-1, 1,-1, 1, 0,-1, 1,-1, 1,  
     *   0, 0, 0, 0, 0, 0, 0, 0, 0, 0 /
C        1  2  3  4  5  6  7  8  9 10 
C --------------------------------------------------
      ISCORE = 10000
      IBEST  = 0
      ITBEST = 0

c      NT = 3
C --- 2.06.03
      NT = 2
c ---
      IF(NR.EQ.6) NT = 9

      DO IT=1,NT
        DO I=1,NR
          ISC = 0
          DO J=1,NR
            IJ = I + (J-1)
            IF(NR.EQ.6) THEN
              ITAB = ITAB6(IJ,IT) 
            ELSE  
              ITAB = ITAB5(IJ,IT) 
            ENDIF
            IF(IFRAME_PS(J).NE.9) THEN   
              IF(IFRAME_PS(J).NE.ITAB) THEN   
                ISC = ISC + 1
              ENDIF
            ENDIF
            IF(IFRAME_NPS(J).NE.9) THEN   
              IF(IFRAME_NPS(J).EQ.ITAB) THEN   
                ISC = ISC + 1
              ENDIF
            ENDIF
          ENDDO
          IF(ISC.LT.ISCORE) THEN
            ISCORE = ISC
            IBEST  = I    
            ITBEST = IT
          ENDIF

        ENDDO
      ENDDO
C --- 
      DO I=1,NR
        IJ = IBEST + (I-1)
        IF(NR.EQ.6) THEN
          ITAB = ITAB6(IJ,ITBEST)       
        ELSE
          ITAB = ITAB5(IJ,ITBEST) 
        ENDIF
        IFRAME(I) = ITAB      
      ENDDO
C ---
      RETURN
      END



      SUBROUTINE GET_RING_ORDER(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat, 5, 6
C                          
C ----
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0


      IACHIR(1) = IATOM(1)
      NNR = 1
      IPP = 0

      DO NNR=1,NR
        IF(NNR.EQ.1) THEN
          IACHIR(1) = IATOM(1)
          IATOM (1) = 0 
        ELSE
          IP = IACHIR(NNR-1)
          DO IR=1,NR
            I  = IATOM(IR)
            IF(I.GT.0) THEN
              CALL CHECK_ATOM_CONN(I,IP,IFLAG)
              IF(IFLAG.EQ.1) THEN
                IACHIR(NNR) = I
                IATOM(IR)   = 0 
                GO TO 100
              ENDIF
            ENDIF
          ENDDO        
        ENDIF
 100    CONTINUE
      ENDDO

      DO I=1,NR
        IATOM(I) = IACHIR(I)
      ENDDO
C ---
C     check all thetas ( 0 or 180)
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        MMM = 99
        MON = ' '
        CALL SRCH_ANGL(MMM,MON,IA1,IA2,IA3,ANGL,LG,IERR)
        IF(IERR.NE.0.OR.ANGL.LT.10.0.OR.ANGL.GT.170.0) THEN
          IERR = 3
          RETURN
        ENDIF 
      ENDDO     
C ---
      RETURN
      END

      SUBROUTINE GET_RING_CHIR(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat,inv1,inv2
C                                         021, 121, 221
C ----
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
      INTEGER IMC(10)        

      CHARACTER LINE*256,SIGN*8,MON*8
      LOGICAL  IS_IT_METAL
      EXTERNAL IS_IT_METAL
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0
      MON  = ' '
      DO I=1,NR
        IFLAT = 0
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        ICHIR (I2) = 0
        NCH   (I2) = 0
        IACHIR(I2) = 0
        ICONN (I2) = 0
        IF(L1C_NCHIR.LE.0) GO TO 100

        IF(IS_IT_METAL(L1A_SYMB(IA2))) THEN
          IB = 0  
          CALL SRCH_METAL_CHIR(MDOC,MON,IA2,IB,IBC,IFR,IMC
     *                                   ,ICROSS,SIGN,LC,IERR)
          IF(IERR.NE.0.AND.LC.GT.0) THEN
            IERR = 0
          ELSE 
            IF(IERR.EQ.0) THEN
              IFLAT     = 1
              ICONN(I2) = 1
            ENDIF
            IERR = 0
            GO TO 100
          ENDIF  
        ENDIF

        NC = L1A_NDIST(IA2) + L1A_NEXTR(IA2)
        IF(L1A_IBACK(IA2).GT.0) NC = NC + 1
        IF(NC.GE.3) THEN          
          NNR = 0
          IF(L1A_IBACK(IA2).GT.0) THEN
            IB  = L1A_IBACK(IA2) 
            IF(IB.NE.IA1.AND.IB.NE.IA3) THEN
              NNR = NNR + 1
              IBOND(NNR) = IB
            ENDIF
          ENDIF
          IF(L1A_NDIST(IA2).GT.0) THEN
            DO ID=1,L1A_NDIST(IA2)
              II = L1A_CONN(ID,IA2)
              IF(II.NE.IA1.AND.II.NE.IA3) THEN
                IF(L1A_SYMB(II).NE.'H   '.AND.
     *             L1A_SYMB(II).NE.'D   '     ) THEN
                  NNR = NNR + 1   
                  IBOND(NNR) = II
                ENDIF
              ENDIF
            ENDDO
          ENDIF
          IF(L1A_NEXTR(IA2).GT.0) THEN
            DO ID=1,L1A_NEXTR(IA2)
              II = L1A_IEXTR(ID,IA2)
              IF(II.NE.IA1.AND.II.NE.IA3) THEN
                IF(L1A_SYMB(II).NE.'H   '.AND.
     *             L1A_SYMB(II).NE.'D   '     ) THEN
                  NNR = NNR + 1   
                  IBOND(NNR) = II
                ENDIF
              ENDIF
            ENDDO
          ENDIF
          IA = 0
          IF(NNR.EQ.1) THEN
            IA = IBOND(1)
          ELSE IF(NNR.GT.1) THEN
            IA = IBOND(1)
            IF(L1A_NRING(IA2).GT.1) THEN 
              DO IR=1,L1A_NRING(IA2)
                IRID = L1A_RING_ID(IR,IA2)
                IF(IRID.NE.IRING) THEN
                  DO IB=1,NNR
                    IBA = IBOND(IB)
                    IF(L1A_NRING(IBA).GT.1) THEN 
                      DO JR=1,L1A_NRING(IBA)
                        JRID = L1A_RING_ID(JR,IBA)
                        IF(IRID.EQ.JRID) THEN
                          IA = IBA
                          GO TO 200
                        ENDIF
                      ENDDO
                    ENDIF
                  ENDDO
                ENDIF
              ENDDO 
            ENDIF  
          ENDIF
 200      CONTINUE
          IF(IA.GT.0) THEN
            CALL GET_CHIR_SIGN(IA2,IA1,IA,IA3,ICH,ISIGN) 
            IF(ICH.GT.0.AND.ISIGN.EQ.0) THEN
              IERR = 2
              LINE = ' WARNING: problem with chirality:'//
     *               L1A_ANAME(IA2)
              CALL MSGERR(MDOC,LINE)
            ENDIF
            IF(ICH.EQ.0) IA = 0
            NCH   (I2) = ICH
            IACHIR(I2) = IA
            ICHIR (I2) = ISIGN          
          ENDIF 
        ENDIF
 100    CONTINUE
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE GET_CHIR_SIGN(ICN,IA1,IA2,IA3,ICHIR,ISIGN) 
C ------------------------------------------------------
      INTEGER ICN,IA1,IA2,IA3,ICHIR,ISIGN        
      INTEGER IC(3),ID(3)
C ---
      INCLUDE 'lib_com.fh'
C ------------------------------------------------------
      ICHIR = 0
      ISIGN = 0
      IF(L1C_NCHIR.LE.0) RETURN
      DO ICH=1,L1C_NCHIR
      IF(L1C_SIGN(ICH)(1:4).NE.'cros'.AND.
     *   L1C_SIGN(ICH)(1:4).NE.'star'    ) THEN
        ICC   = L1C_I1ATM(ICH)
        IC(1) = L1C_I2ATM(ICH)
        IC(2) = L1C_I3ATM(ICH)
        IC(3) = L1C_I4ATM(ICH)
        ID(1) = 0
        ID(2) = 0
        ID(3) = 0
        IF(ICC.EQ.ICN) THEN
          NZERO = 0
          IF(IA1.EQ.IC(1)) THEN
            I1    = IA1
            ID(1) = I1
          ELSE IF(IA1.EQ.IC(2)) THEN
            I1    = IA1
            ID(2) = I1
          ELSE IF(IA1.EQ.IC(3)) THEN
            I1    = IA1
            ID(3) = I1
          ELSE
            I1    = 0
            NZERO = NZERO + 1     
          ENDIF
          IF(IA2.EQ.IC(1)) THEN
            I2    = IA2
            ID(1) = I2
          ELSE IF(IA2.EQ.IC(2)) THEN
            I2    = IA2
            ID(2) = I2
          ELSE IF(IA2.EQ.IC(3)) THEN
            I2    = IA2
            ID(3) = I2
          ELSE
            I2    = 0
            NZERO = NZERO + 1     
          ENDIF
          IF(IA3.EQ.IC(1)) THEN
            I3    = IA3
            ID(1) = I3
          ELSE IF(IA3.EQ.IC(2)) THEN
            I3    = IA3
            ID(2) = I3
          ELSE IF(IA3.EQ.IC(3)) THEN
            I3    = IA3
            ID(3) = I3
          ELSE
            I3    = 0
            NZERO = NZERO + 1     
          ENDIF
          IF(NZERO.GT.1) THEN
C           error
            RETURN
          ENDIF 
          ICHIR = ICH
          IF(L1C_FLAG(ICH).EQ.'B') THEN
            ISIGN = 9
            RETURN
          ENDIF
          IF(NZERO.EQ.1) THEN
            IF(ID(1).EQ.0) IAA = IC(1)
            IF(ID(2).EQ.0) IAA = IC(2)
            IF(ID(3).EQ.0) IAA = IC(3)
            IF(I1.EQ.0) I1 = IAA 
            IF(I2.EQ.0) I2 = IAA 
            IF(I3.EQ.0) I3 = IAA           
          ENDIF
          INVER = 1 
          IF(IC(1).EQ.I1) THEN 
            IF(IC(2).EQ.I2.AND.IC(3).EQ.I3) GO TO 100
          ELSE IF(IC(1).EQ.I2) THEN 
            IF(IC(2).EQ.I3.AND.IC(3).EQ.I1) GO TO 100
          ELSE IF(IC(1).EQ.I3) THEN 
            IF(IC(2).EQ.I1.AND.IC(3).EQ.I2) GO TO 100
          ENDIF
          INVER =-1
 100      CONTINUE
          IF(NZERO.EQ.1) THEN  
            IF(INVER.EQ.1)THEN
              INVER =-1
            ELSE
              INVER = 1
            ENDIF 
          ENDIF
          ISIGN = 0
          IF(L1C_FLAG(ICH).EQ.'R') THEN
            ISIGN = 1
          ELSE IF(L1C_FLAG(ICH).EQ.'L') THEN
            ISIGN =-1
          ENDIF
          ISIGN = ISIGN*INVER
          RETURN
        ENDIF
      ENDIF
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE CHIR_TO_LIST(MDOC,IRING,NR,IFLAT,IATOM
     *    ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat,inv1,inv2
C                                         021, 121, 221
C ----
      CHARACTER LIST*1
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR= 0
C ---
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IF(NCH(I2).GT.0) THEN
          CALL SET_CHIR_SIGN(NCH(I2),IA2,IA1,IACHIR(I2),IA3,ICHIR(I2)) 

          IF(LIST.EQ.'T') THEN
            WRITE(*,*) '--cnt:',NCH(I2),I2,iA2
            WRITE(*,*) '-- cH:',IA1,IACHIR(I2),IA3,ICHIR(I2)
            WRITE(*,*) ' list:',L1C_I1ATM(nch(i2)),L1C_I2ATM(nch(i2))
     *      ,L1C_I3ATM(nch(i2)),L1C_I4ATM(nch(i2))
            WRITE(*,*) ' flag:',L1C_FLAG(NCH(I2))
          ENDIF

        ENDIF
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE SET_CHIR_SIGN(ICH,ICN,IA1,IA2,IA3,ISIGN) 
C ------------------------------------------------------
      INTEGER ICN,IA1,IA2,IA3,ICH,ISIGN        
      INTEGER IC(3),ID(3)
C ---
      INCLUDE 'lib_com.fh'
C ------------------------------------------------------
      IF(L1C_NCHIR.LE.0.OR.ICH.GT.L1C_NCHIR) RETURN
      IF(ISIGN.NE.1.AND.ISIGN.NE.-1) RETURN
C ---
      ICC   = L1C_I1ATM(ICH)
      IC(1) = L1C_I2ATM(ICH)
      IC(2) = L1C_I3ATM(ICH)
      IC(3) = L1C_I4ATM(ICH)
      ID(1) = 0
      ID(2) = 0
      ID(3) = 0
      IF(ICC.EQ.ICN) THEN
        NZERO = 0
        IF(IA1.EQ.IC(1)) THEN
          I1    = IA1
          ID(1) = I1
        ELSE IF(IA1.EQ.IC(2)) THEN
          I1    = IA1
          ID(2) = I1
        ELSE IF(IA1.EQ.IC(3)) THEN
          I1    = IA1
          ID(3) = I1
        ELSE
          I1    = 0
          NZERO = NZERO + 1     
        ENDIF
        IF(IA2.EQ.IC(1)) THEN
          I2    = IA2
          ID(1) = I2
        ELSE IF(IA2.EQ.IC(2)) THEN
          I2    = IA2
          ID(2) = I2
        ELSE IF(IA2.EQ.IC(3)) THEN
          I2    = IA2
          ID(3) = I2
        ELSE
          I2    = 0
          NZERO = NZERO + 1     
        ENDIF
        IF(IA3.EQ.IC(1)) THEN
          I3    = IA3
          ID(1) = I3
        ELSE IF(IA3.EQ.IC(2)) THEN
          I3    = IA3
          ID(2) = I3
        ELSE IF(IA3.EQ.IC(3)) THEN
          I3    = IA3
          ID(3) = I3
        ELSE
          I3    = 0
          NZERO = NZERO + 1     
        ENDIF
        IF(NZERO.GT.1) THEN
C         error
          RETURN
        ENDIF 
        IF(L1C_FLAG(ICH).NE.'B') RETURN
        IF(NZERO.EQ.1) THEN
          IF(ID(1).EQ.0) IAA = IC(1)
          IF(ID(2).EQ.0) IAA = IC(2)
          IF(ID(3).EQ.0) IAA = IC(3)
          IF(I1.EQ.0) I1 = IAA 
          IF(I2.EQ.0) I2 = IAA 
          IF(I3.EQ.0) I3 = IAA           
        ENDIF
        INVER = 1 
        IF(IC(1).EQ.I1) THEN 
          IF(IC(2).EQ.I2.AND.IC(3).EQ.I3) GO TO 100
        ELSE IF(IC(1).EQ.I2) THEN 
          IF(IC(2).EQ.I3.AND.IC(3).EQ.I1) GO TO 100
        ELSE IF(IC(1).EQ.I3) THEN 
          IF(IC(2).EQ.I1.AND.IC(3).EQ.I2) GO TO 100
        ENDIF
        INVER =-1
 100    CONTINUE
        IF(NZERO.EQ.1) THEN  
          IF(INVER.EQ.1)THEN
            INVER =-1
          ELSE
            INVER = 1
          ENDIF 
        ENDIF
        ISN = ISIGN*INVER
        IF(ISN.EQ.1) THEN
          L1C_FLAG(ICH) = 'R'
        ELSE IF(ISN.EQ.-1) THEN
          L1C_FLAG(ICH) = 'L'
        ENDIF
      ENDIF
C ---
      RETURN
      END

      SUBROUTINE GET_RING_BOND(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat,inv1,inv2
C                                         021, 121, 221
C ----
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IBOND(I2) = 0
        IC1       = 0
        IC2       = 0
        IFLT      = 0
        IA_RING   = 0
        JA_RING   = 0
        IF(L1A_NRING(IA2).NE.0.AND.L1A_NRING(IA3).NE.0) THEN
          DO IR=1,L1A_NRING(IA2)
            IP = L1A_RING_ID(IR,IA2)
            IF(IP.NE.IRING) THEN
              DO JR=1,L1A_NRING(IA3)
                IF(IP.EQ.L1A_RING_ID(JR,IA3)) THEN
                  DO IA=1,L1A_NATOM
                    IF(L1A_NRING(IA).GT.0.AND.
     *                 IA.NE.IA1.AND.IA.NE.IA2.AND.IA.NE.IA3)THEN
                      DO IAR=1,L1A_NRING(IA)
                        IF(IP.EQ.L1A_RING_ID(IAR,IA)) THEN
                          CALL CHECK_ATOM_CONN(IA2,IA,IFLAG1)

                          IF(IFLAG1.EQ.1) THEN

                          DO JA=1,L1A_NATOM
                            IF(L1A_NRING(JA).GT.0.AND.JA.NE.IA.AND.
     *                        JA.NE.IA2.AND.JA.NE.IA3.AND.JA.NE.IA4)THEN
                              DO JAR=1,L1A_NRING(JA)
                                IF(IP.EQ.L1A_RING_ID(JAR,JA)) THEN
                                  CALL CHECK_ATOM_CONN(IA3,IA,IFLAG2)
                                  IF(IFLAG2.EQ.1) THEN
                                    CALL CHECK_RING_IS_PLAN(IP,IFLAGP)
                                    IF(IFLAGP.GT.0.OR.IFLT.EQ.0) THEN
                                      IFLT = IFLAGP 
                                      IA_RING = IA
                                      JA_RING = JA
                                      IC1     = 1
                                      IC2     = 1
                                      IF(IFLAGP.EQ.2) GO TO 100
                                    ENDIF  
                                  ENDIF
                                ENDIF
                              ENDDO
                            ENDIF
                          ENDDO

                          ENDIF

                        ENDIF
                      ENDDO 
                    ENDIF
                  ENDDO 
                  IC1 = 1
                  IC2 = 1
                ENDIF
              ENDDO
            ENDIF
          ENDDO
          GO TO 200
 100      CONTINUE
          IF(NCH(I2).GT.0.AND.IACHIR(I2).NE.IA_RING.AND.
     *                                      IA_RING.GT.0) IC1 = 2
          IF(NCH(I3).GT.0.AND.IACHIR(I3).NE.JA_RING.AND.
     *                                      JA_RING.GT.0) IC2 = 2
          IBOND(I2) = IFLT*100 + IC1*10 + IC2
        ENDIF
 200    CONTINUE
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE GET_RING_TORS(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat,inv1,inv2
C                                         021, 121, 221
C ----
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)
        IPHI(I2) = 9
        NPHI(I2) = 0
        IF(L1T_NTORS.LE.0) GO TO 100
        DO ITORS=1,L1T_NTORS
          IT1 = L1T_I1ATM(ITORS)
          IT2 = L1T_I2ATM(ITORS)
          IT3 = L1T_I3ATM(ITORS)
          IT4 = L1T_I4ATM(ITORS)
          IF((IA2.EQ.IT2.AND.IA3.EQ.IT3).OR.
     *       (IA2.EQ.IT3.AND.IA3.EQ.IT2)    ) THEN
            NPHI(I2) = ITORS
            IF(L1T_FLAG(ITORS).EQ.'C'.OR.L1T_FLAG(ITORS).EQ.'D') THEN
              IF((NCH(I2).GT.0.AND.ICHIR(I2).EQ.9).OR.
     *           (NCH(I3).GT.0.AND.ICHIR(I3).EQ.9)    ) GO TO 100
              IF(ICONN(I2).GT.0.OR.ICONN(I3).GT.0) THEN
                IPHI(I2) = 0
                GO TO 100 
              ENDIF  
              L1T_FLAG(ITORS) = 'D'
              NEG = 1
              ID1 = 0
              ID2 = 0
              IF(IT2.EQ.IA3) THEN
                NEG =-1
                IT2 = IA3
                IT3 = IA2
                IT  = IT1
                IT1 = IT4
                IT4 = IT              
              ENDIF

              CALL CONVERT_TORS_ANGLE(IT1,IA1,NCH(I2),IACHIR(I2)
     *                                         ,ICHIR(I2),ID1,IERR1)
              CALL CONVERT_TORS_ANGLE(IT4,IA4,NCH(I3),IACHIR(I3)
     *                                         ,ICHIR(I3),ID2,IERR2)
              IF(IERR1.NE.0.OR.IERR2.NE.0) GO TO 100

              ID2 = -ID2
              IF(ID2.EQ.-6) ID2 = 6
C             list --> ring 
              VOBS = ABS(L1T_VOBS(ITORS))
              IPH  = VOBS/30.0 + 0.5 
              IF(L1T_VOBS(ITORS).LT.0.0) IPH = -IPH
              IF(IPH.GT. 6) IPH = IPH - 12
              IF(IPH.LE.-6) IPH = IPH + 12
              L1T_VOBS(ITORS) = IPH*30.0             
c              IPH = IPH*NEG
              IF(IPH.EQ.-6) IPH = 6
              IPH = IPH - ID1
              IF(IPH.GT. 6) IPH = IPH - 12
              IF(IPH.LE.-6) IPH = IPH + 12
              IPH = IPH - ID2
              IF(IPH.GT. 6) IPH = IPH - 12
              IF(IPH.LE.-6) IPH = IPH + 12
              IPH = IPH/2
              IF(IPH.EQ. 3) IPH = 0
              IF(IPH.EQ. 2) IPH =-1
              IF(IPH.EQ.-2) IPH = 1
              IPHI(I2) = IPH
            ENDIF
            GO TO 100
          ENDIF
        ENDDO

 100    CONTINUE
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE TORS_TO_LIST(MDOC,IRING,NR,IFLAT,IATOM
     *  ,ICHIR,IACHIR,ICONN,IPHI,NCH,NPHI,IBOND,LIST,IERR)        
C ----
C       get         rings
C       NR          IFLAT                 
C    ord(5,6)     2-plan, 1-flat (ring6: sp2 >4 ; ring5: sp2 > 2)  
C
C      NCH()           ICHIR()             IACHIR()             ICONN()
C     chir_id  1(+,R),-1(-,L),0(),9(both)   iatom              2,3,4,..
C                                                           number of connect. 
C 
C         NPHI()           IPHI()        IBOND()
C        tors_id         0,(+/-)1,9     2 -plan,1-flat,inv1,inv2
C                                         021, 121, 221
C ----
      CHARACTER LIST*1
      INTEGER IRING,NR,IFLAT,IERR,IATOM(*),ICHIR(*),IACHIR(*),ICONN(*)
      INTEGER NPHI(*),NCH(*),IBOND(*)
      INTEGER IPHI(*)        
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------
      IERR = 0
      DO I=1,NR
        I1  = I
        IA1 = IATOM(I1)
        I2  = I1 + 1
        IF(I2.GT.NR) I2 = 1
        IA2 = IATOM(I2)
        I3  = I2 + 1
        IF(I3.GT.NR) I3 = 1
        IA3 = IATOM(I3)
        I4  = I3 + 1
        IF(I4.GT.NR) I4 = 1
        IA4 = IATOM(I4)

        IF(NPHI(I2).GT.0.AND.NPHI(I2).LE.L1T_NTORS) THEN
          ITORS = NPHI(I2)
          IT1 = L1T_I1ATM(ITORS)
          IT2 = L1T_I2ATM(ITORS)
          IT3 = L1T_I3ATM(ITORS)
          IT4 = L1T_I4ATM(ITORS)
          IF((IA2.EQ.IT2.AND.IA3.EQ.IT3).OR.
     *       (IA2.EQ.IT3.AND.IA3.EQ.IT2)    ) THEN
            IF(L1T_FLAG(ITORS).NE.'D'.AND.ICONN(I2).LE.0.AND.
     *                                    ICONN(I3).LE.0     ) THEN
              NEG = 1
              ID1 = 0
              ID2 = 0
              IF(IT2.EQ.IA3) THEN
                NEG =-1
                IT2 = IA3
                IT3 = IA2
                IT  = IT1
                IT1 = IT4
                IT4 = IT              
              ENDIF

              CALL CONVERT_TORS_ANGLE(IT1,IA1,NCH(I2),IACHIR(I2)
     *                                         ,ICHIR(I2),ID1,IERR1)
              CALL CONVERT_TORS_ANGLE(IT4,IA4,NCH(I3),IACHIR(I3)
     *                                         ,ICHIR(I3),ID2,IERR2)
              IF(IERR1.NE.0.OR.IERR2.NE.0) THEN
                CALL MSGERR(MDOC,
     * ' WARNING: in TORSION_CORRECTION: not all chir. are defined')
              ENDIF

              ID2 = -ID2
              IF(ID2.EQ.-6) ID2 = 6

C             ring --> list  
              IPH = IPHI(I2)
              IPH = IPH*2
              IF(IPH.EQ. 4) IPH = 1
              IF(IPH.EQ.-4) IPH =-1
              IPHH= IPH
c             IPH = IPH*NEG              
              IF(IPH.EQ.-6) IPH = 6
              IPH = IPH + ID1
              IF(IPH.GT. 6) IPH = IPH - 12
              IF(IPH.LE.-6) IPH = IPH + 12
              IPH = IPH + ID2
              IF(IPH.GT. 6) IPH = IPH - 12
              IF(IPH.LE.-6) IPH = IPH + 12
c              IPH = IPH*NEG              
              L1T_FLAG(ITORS) = 'D'
              L1T_VOBS(ITORS) = IPH*30.0

              IF(LIST.EQ.'T') THEN
              WRITE(*,*) '--i2,IA2,IPH,NEG,ich:'
     *                   ,i2,IA2,IPHH,NEG,ICHIR(I2)
              WRITE(*,*) 'IT1,IA1,IAA,ID1:',IT1,IA1,IACHIR(I2),ID1
              WRITE(*,*) 'IT4,IA4,IAA,ID2:',IT4,IA4,IACHIR(I3),ID2
              WRITE(*,*) 'IPH   -->  :',IPH
              ENDIF

            ENDIF
          ENDIF
        ENDIF
      ENDDO
C ---
      RETURN
      END


      SUBROUTINE CONVERT_TORS_ANGLE(IT,IA,NCH,IACHIR,ICHIR,ID,IERR)
C --------------------------------------------
C       
C --------------------------------------------
      IERR = 0
      ID   = 0

c     write(*,*) '-->',it,ia,iachir,ichir

      IF(IT.NE.IA) THEN
        IF(NCH.EQ.0) THEN
          ID = 6
        ELSE
          IF(IACHIR.EQ.IT) THEN
            IF(ICHIR.EQ. 1) THEN
              ID =-4
            ELSE IF(ICHIR.EQ.-1) THEN
              ID = 4
            ELSE IF(ICHIR.EQ. 9) THEN
C             ????
              IERR = 1
              ID =-4
            ELSE
              ID = 6
            ENDIF
          ELSE
            IF(ICHIR.EQ. 1) THEN
              ID = 4
            ELSE IF(ICHIR.EQ.-1) THEN
              ID =-4
            ELSE IF(ICHIR.EQ. 9) THEN
C             ????
              IERR = 1
              ID = 4
            ELSE
              ID = 6
            ENDIF
          ENDIF
        ENDIF
      ELSE
        ID = 0 
      ENDIF
C ---
      RETURN
      END

      SUBROUTINE CHECK_RING_IS_PLAN(IRING,IFLAGP)
C --------------------------------------------
      INTEGER IARING(6)
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER CHEM*4,RATOM*4
      INTEGER*4 IATOM
      CHARACTER ATOM*4
      EQUIVALENCE (IATOM,ATOM)
C --------------------------------------------
      IERR   = 0      
      IFLAGP = 0
      NR     = 0        
      DO IA=1,L1A_NATOM
        IF(L1A_NRING(IA).NE.0) THEN
          DO IRA=1,L1A_NRING(IA)
            IRING_ID = L1A_RING_ID (IRA,IA)
C           IORD     = L1A_RING_ORD(IRA,IA)
C           IFL      = L1A_RING_FLAT(IRA,IA)
            IF(IRING_ID.EQ.IRING) THEN
              IF(NR.LT.6) THEN        
                NR         = NR + 1
                IARING(NR) = IA
              ENDIF
            ENDIF
          ENDDO
        ENDIF 
      ENDDO

      IF(L1P_NPLAN.GT.0) THEN
        DO  IP=1,L1P_NPLAN
          N = 0
          DO I=1,L1P_NATOM(IP)
            IATOM = L1P_ATOM(I,IP)
            DO IR=1,NR 
              RATOM = L1A_ANAME(IARING(IR))
              IF(RATOM.EQ.ATOM) N=N+1
            ENDDO
          ENDDO
          IF(N.GE.4.AND.N.EQ.NR) THEN
            IFLAGP = 2
            GO TO 200
          ENDIF
        ENDDO
      ENDIF

 200  CONTINUE

      IF(IFLAGP.EQ.0) THEN
        N = 0
        DO I=1,NR
          IA   = IARING(I) 
          CHEM = L1A_CHEM(IA)
          IF(L1A_SYMB(IA).EQ.'H   '.OR.L1A_SYMB(IA).EQ.'D   ') 
     *    CHEM = 'H   '
          DO IE=1,LEA_NATOM
            IF(CHEM.EQ.LEA_ANAME(IE)) THEN
              IF(LEA_SP(IE).EQ.2) THEN
                N = N + 1
                GO TO 100
              ENDIF
            ENDIF 
          ENDDO
 100      CONTINUE
        ENDDO
        IF((NR.EQ.6.AND.N.GT.4).OR.(NR.EQ.5.AND.N.GT.2)) IFLAGP=1
      ENDIF  
C ---
      RETURN
      END

      SUBROUTINE CHECK_ATOM_CONN(IA1,IA2,IFLAG)
C --------------------------------------------
C     iflag = 1 yes
C ---
      INCLUDE 'lib_com.fh'
C --------------------------------------------
      IFLAG = 0
      IF(IA1.LE.0.OR.IA2.LE.0) RETURN

      IF(L1A_IBACK(IA2).EQ.IA1) THEN
        IFLAG = 1
        GO TO 100
      ENDIF  
        
      IF(L1A_NDIST(IA2).GT.0) THEN
        DO ID=1,L1A_NDIST(IA2)
          II = L1A_CONN(ID,IA2)
          IF(II.EQ.IA1) THEN
            IFLAG = 1
            GO TO 100
          ENDIF
        ENDDO
      ENDIF 
      IF(L1A_NEXTR(IA2).GT.0) THEN
        DO IE=1,L1A_NEXTR(IA2)
          II = L1A_IEXTR(IE,IA2)
          IF(II.EQ.IA1) THEN
            IFLAG = 1
            GO TO 100
          ENDIF
        ENDDO
      ENDIF
 100  CONTINUE
C ---
      RETURN
      END

      SUBROUTINE CHECK_METAL_CHIR(MDOC,MON,IANGL,LIST,IERR)
C --------------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      LOGICAL   IS_IT_METAL
      EXTERNAL  IS_IT_METAL
      INTEGER   IBOND(10),IMC(10)
      CHARACTER LINE*256,SIGN*8,MON*8,LIST*1
C --------------------------------------------------------
      IERR  = 0
      JERR  = 0
      DO I=1,10
        IBOND(I) = 0
        IMC(I)   = 0
      ENDDO
C ---
      IF(LIST.EQ.'T') THEN
        write(*,*) '---CHECK_METAL_CHIR--',L1C_NCHIR
      ENDIF

      DO IA=1,L1A_NATOM 
        IF(IS_IT_METAL(L1A_SYMB(IA))) THEN
          NC  = 0 
          NCH = 0
          IF(L1A_IBACK(IA).GT.0) THEN
            NC = NC + 1  
            IBOND(NC)  = L1A_IBACK(IA) 
            IB         = IBOND(NC) 
            IF(L1A_SYMB(IB).EQ.'H   '.OR.L1A_SYMB(IB).EQ.'D   ') 
     *      NCH = NCH + 1
          ENDIF
          IF(L1A_NDIST(IA).GT.0) THEN
            DO ID=1,L1A_NDIST(IA)
              NC = NC + 1               
              IBOND(NC) = L1A_CONN(ID,IA)
              IB        = IBOND(NC) 
              IF(L1A_SYMB(IB).EQ.'H   '.OR.L1A_SYMB(IB).EQ.'D   ') 
     *        NCH = NCH + 1
            ENDDO
          ENDIF
          IF(L1A_NEXTR(IA).GT.0) THEN
            DO ID=1,L1A_NEXTR(IA)
              NC = NC + 1               
              IBOND(NC) = L1A_IEXTR(ID,IA)
              IB        = IBOND(NC) 
              IF(L1A_SYMB(IB).EQ.'H   '.OR.L1A_SYMB(IB).EQ.'D   ') 
     *        NCH = NCH + 1
            ENDDO
          ENDIF      
          IF(NC.LE.1) GO TO 100
          IF((NC-NCH).LE.1) GO TO 100
          DO I=1,NC
            IB  = IBOND(I)
            MON = ' '
            DO K=1,10
              IMC(K) = 0
            ENDDO
            CALL SRCH_METAL_CHIR(MDOC,MON,IA,IB,IBC,IFR,IMC
     *                               ,ICROSS,SIGN,LC,IERR)  
            IF(LIST.EQ.'T') THEN
              write(*,*)'srch_m_c:',IA,IB,LC,IERR
              write(*,*)'  IBC,IFR,ICROSS:',IBC,IFR,ICROSS
              write(*,*)'  IB:',IBOND(1),IBOND(2),IBOND(3),IBOND(4)
              write(*,*)'  IM:',IMC(1),IMC(2),IMC(3),IMC(4)
            ENDIF

            IF(IERR.EQ.0) THEN
              NFOUND1 = 0
              NFOUND2 = 0
              DO J=1,NC
                IAA=IBOND(J)
                IF(IAA.EQ.IFR.OR.IAA.EQ.IBC) THEN
                  NFOUND1 = NFOUND1 + 1 
                  GO TO 200
                ENDIF
                IF(ICROSS.GT.0) THEN
                  DO K=1,ICROSS
                    IF(IAA.EQ.IMC(K)) THEN
                      NFOUND2 = NFOUND2 + 1 
                      GO TO 200
                    ENDIF
                  ENDDO
                ENDIF
 200            CONTINUE
              ENDDO
              IF(SIGN(1:4).EQ.'cros') THEN
                IF(ICROSS.EQ.2) THEN
                  DO J=1,NC
                    IAA=IBOND(J)
                    IF(IAA.NE.IBC.AND.IAA.NE.IFR.AND.
     *                            IAA.NE.L1C_I4ATM(LC)) THEN
                      IMC(2)  = IAA
                      NFOUND2 = NFOUND2 + 1                       
                    ENDIF
                  ENDDO          
                ENDIF
              ELSE

              ENDIF  

              IF((NFOUND1.GT.0.AND.SIGN(1:4).EQ.'star').OR. 
     *           (NFOUND1.LE.1.AND.ICROSS.EQ.0        ).OR. 
     *           (NFOUND2.GE.1.AND.ICROSS.EQ.0        ).OR. 
     *           (NFOUND2.LE.0.AND.ICROSS.NE.0        ).OR. 
     *            NFOUND2.GT.ICROSS                        ) THEN 
            IF(LIST.EQ.'T') THEN
              write(*,*) ' NF1,NF2,ICROSS:',NFOUND1,NFOUND2,ICROSS
            ENDIF
                JERR = 1
       LINE = ' ERROR: wrong metal chirality for:'//L1A_ANAME(IA)  
                CALL MSGERR(MDOC,LINE)
                GO TO 100
              ENDIF 

              MMM = 99
              MON = ' '  

              IF(LIST.EQ.'T') THEN
                write(*,*) '---METAL_ang--corr'
                write(*,*) '-ia,nc,icross:',ia,nc,icross
                write(*,'(a,8i4)') '-ibc,ifr,mc(1234):',ibc,ifr
     *          ,imc(1),imc(2),imc(3),imc(4),imc(5),imc(6) 
              ENDIF

              CALL METAL_ANGLE_TORS_CORRECTION(MDOC,MON,NC,IA,IBC,IFR
     *             ,IMC,ICROSS,IERR)
              JERR = IERR
              IERR = 0
              GO TO 100
            ENDIF 
            IF(LC.GT.0.AND.IERR.EQ.9) THEN
              IERR = 0
              GO TO 100
            ENDIF
            IERR = 0
          ENDDO
C         no met. chir. IERR = 0
          IF(NC.GT.1) THEN
C           ierr = 0
            LINE = ' WARNING: there is not metal chirality for:'//
     *             L1A_ANAME(IA)  
            CALL MSGERR(MDOC,LINE)

            CALL METAL_CHIR_FROM_COORD(MDOC,LIST,MON
     *                                ,IA,NC,IBOND,IERR)
            IF(IERR.LE.2.AND.IERR.NE.0) THEN
              IF(IERR.EQ.1) THEN
                LINE =               
     *' WARNING: coords are not good enough to create Chirality'
                CALL MSGERR(MDOC,LINE)
              ENDIF
C             --- IERR = 2 no coords
              IF(IANGL.EQ.1) THEN

              IF(LIST.EQ.'T') THEN
                write(*,*) '--chek_MET_chir--'
                write(*,*) '-ia,nc:',ia,nc
                write(*,'(a,6i4)') '-ibond(1234):'
     *          ,ibond(1),ibond(2),ibond(3),ibond(4)                            
              ENDIF

                CALL CHECK_DEFAULT_MET_CHIR(MDOC,MON,IA,NC
     *                                     ,IBOND,LIST,IERR)
              ENDIF
            ENDIF
            IF(IERR.NE.0) JERR = IERR
            IERR = 0  
          ENDIF 

        ENDIF
 100    CONTINUE
      ENDDO
C ----
      IERR = JERR 
C ---------------------------------------
      RETURN
      END


      SUBROUTINE METAL_ANGLE_TORS_CORRECTION(MDOC,MON,NC,IC,IBC,IFR
     *             ,IMC,ICROSS,IERR)
C --------------------------------------------------------
      INTEGER   MDOC,IERR,NC,IC,IBC,IFR,ICROSS
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER   IMC(*),IN(12),INP(12)
      CHARACTER LINE*256,MON*8
C --------------------------------------------------------
C     check corr. angles
      
      IF(IFR.GT.0.AND.IBC.GT.0) THEN
        VAL = 180.0
        CALL CHANGE_ANGLE_VALUE(IBC,IC,IFR,VAL)
      ENDIF

      IF(ICROSS.GT.0) THEN 
        DO I=1,ICROSS
          IA  = IMC(I)
          VAL = 90.0
          IF(IA.GT.0) THEN
            IF(IBC.GT.0) CALL CHANGE_ANGLE_VALUE(IBC,IC,IA,VAL)
            IF(IFR.GT.0) CALL CHANGE_ANGLE_VALUE(IFR,IC,IA,VAL) 
          ENDIF
        ENDDO
      ENDIF 

      IF(ICROSS.GT.1) THEN
        DELTA = 360.0/FLOAT(ICROSS)
        DO I=1,ICROSS-1
          IA = IMC(I)
          IF(IA.GT.0) THEN
            DO J=I+1,ICROSS
              JA = IMC(J)
              IF(JA.GT.0) THEN
                VAL =FLOAT((J-I))*DELTA
                IF(VAL.GT.180.0) THEN
                  VAL  = 360.0 - VAL
                ENDIF
                IVAL = VAL + 0.1
                VAL = IVAL 
                CALL CHANGE_ANGLE_VALUE(IA,IC,JA,VAL)
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF 

C     tors definition
      N = 0
      IF(IBC.GT.0) THEN
        N = N + 1 
        IN(N) = IBC
      ENDIF
      IF(IFR.GT.0) THEN
        N = N + 1 
        IN(N) = IFR
      ENDIF
      IF(ICROSS.GT.0) THEN
        DO I=1,ICROSS
          N = N + 1 
          IN(N) = IMC(I)
        ENDDO
      ENDIF
      IF(N.LE.0) RETURN

      IA1_BEST   = 0
      IA4_BEST   = 0
      IRING_BEST =-1
      PHI_BEST   = 0.0

      DO ITORS=1,L1T_NTORS
        I1 = L1T_I1ATM(ITORS)
        I2 = L1T_I2ATM(ITORS)
        I3 = L1T_I3ATM(ITORS) 
        I4 = L1T_I4ATM(ITORS) 
        IF(IC.EQ.I2.OR.IC.EQ.I3) THEN
          IF(IC.EQ.I2) THEN
            I  = I2
            I2 = I3
            I3 = I 
            I  = I4
            I4 = I1
            I1 = I
          ENDIF
          DO IP=1,N
            IF(IN(IP).EQ.I2) THEN
              IP2 = IN(IP)

              IRING_BEST =-1

              DO JP=1,N
                IF(IN(JP).NE.I2) THEN
                  IP4 = IN(JP)
                  CALL SRCH_ANGL(MDOC,MON,IP2,IC,IP4,ANG4,LG,KERR)
                  IANG4 = 1   
                  IF(ANG4.LT.10.0.OR.ANG4.GT.170.0) IANG4 = 0
                  NP = 0 
                  IF(L1A_IBACK(IP2).GT.0) THEN
                    NP = NP + 1  
                    INP(NP)  = L1A_IBACK(IP2) 
                  ENDIF
                  IF(L1A_NDIST(IP2).GT.0) THEN
                    DO ID=1,L1A_NDIST(IP2)
                      NP = NP + 1               
                      INP(NP) = L1A_CONN(ID,IP2)
                    ENDDO
                  ENDIF
                  IF(L1A_NEXTR(IP2).GT.0) THEN
                    DO ID=1,L1A_NEXTR(IP2)
                      NP = NP + 1               
                      INP(NP) = L1A_IEXTR(ID,IP2)
                    ENDDO
                  ENDIF      
                  IF(NP.GE.1) THEN
                    DO KP=1,NP
                      IF(INP(KP).NE.IC) THEN
                        IP1 = INP(KP)
                        CALL SRCH_ANGL(MDOC,MON,IP1,IP2,IC,ANG1,LG,KERR)
                        IANG1 = 1   
                        IF(ANG1.LT.10.0.OR.ANG1.GT.170.0) IANG1=0
                        IRING = 0
                        PHI   = 180.0
                        IF(IANG1.GT.0.AND.IANG4.GT.0) THEN
                          IRING = 1
                          CALL CHECK_RING_ID(MDOC,IP1,IP2,IC
     *                                      ,IP4,ID,PHI,KERR) 
                          IF(ID.EQ.3) IRING = 2
C                         plan ?        
                        ENDIF  
                        IF(IRING.GT.IRING_BEST) THEN
                          IA1_BEST   = IP1
                          IA4_BEST   = IP4
                          IRING_BEST = IRING
                          PHI_BEST   = PHI
                        ENDIF
                      ENDIF
                    ENDDO
                  ENDIF
                ENDIF
              ENDDO 

              IF(IRING_BEST.GE.0) THEN
                L1T_I1ATM(ITORS)  = IA1_BEST
                L1T_1ATM (ITORS)  = L1A_ANAME(IA1_BEST)
                L1T_I2ATM(ITORS)  = IP2
                L1T_2ATM (ITORS)  = L1A_ANAME(IP2)
                L1T_I3ATM(ITORS)  = IC
                L1T_3ATM (ITORS)  = L1A_ANAME(IC)
                L1T_I4ATM(ITORS)  = IA4_BEST
                L1T_4ATM (ITORS)  = L1A_ANAME(IA4_BEST)
                L1T_VAL  (ITORS)  = PHI_BEST
              ENDIF
            ENDIF 
          ENDDO
        ENDIF 
      ENDDO
C ---------------------------------------
      RETURN
      END

      SUBROUTINE CHANGE_ANGLE_VALUE(I1,I2,I3,VAL)
C ---------------------------------------
      INTEGER I1,I2,I3
      REAL    VAL  
C ---
      INCLUDE 'lib_com.fh'
C ---
C ---------------------------------------
      NANGL = L1G_NANGL
      IF(NANGL.LE.0.OR.I1.LE.0.OR.I2.LE.0.OR.I3.LE.0) RETURN
      DO I=1,NANGL
        IF((L1G_I1ATM(I).EQ.I1.AND.L1G_I2ATM(I).EQ.I2.AND.
     *                             L1G_I3ATM(I).EQ.I3).OR.
     *     (L1G_I1ATM(I).EQ.I3.AND.L1G_I2ATM(I).EQ.I2.AND. 
     *                             L1G_I3ATM(I).EQ.I1)) THEN

C          WRITE(*,*) '-----ANG:',I
C          WRITE(*,*) '       1:',L1G_I1ATM(I),L1G_1ATM(I)
C          WRITE(*,*) '       2:',L1G_I2ATM(I),L1G_2ATM(I)
C          WRITE(*,*) '       3:',L1G_I3ATM(I),L1G_3ATM(I)

          L1G_VAL(I) = VAL 
          RETURN
        ENDIF
      ENDDO
C ---
      RETURN
      END

      SUBROUTINE SRCH_METAL_CHIR(MDOC,MON,IC,IB,IBC,IFR,IMC
     *                                   ,ICROSS,SIGN,LC,IERR)
C -----------------------------------------------
      INTEGER   MDOC,IC,IB,IFR,IMC(*),ICROSS,LC,IERR
      CHARACTER MON*8,SIGN*8
C ---
      INCLUDE 'lib_com.fh'
C ---
C     CHARACTER LINE*256
      CHARACTER CH1*1
C --------------------------------------------------------
      IERR   = 0
      LC     = 0
      ICROSS = 0
      IBC    = 0
      IFR    = 0
      NCHIR = L1C_NCHIR
      IF(NCHIR.LE.0.OR.IC.LE.0) THEN
        IERR = 1
        RETURN
      ENDIF
      DO I=1,NCHIR
        IF(L1C_I1ATM(I).EQ.IC) THEN
          IF(L1C_SIGN(I)(1:4).EQ.'cros'.OR.
     *       L1C_SIGN(I)(1:4).EQ.'star'    ) THEN
            IF(L1C_SIGN(I)(1:4).EQ.'cros') THEN
C             L1C_SIGN = 'crossN'
              CH1 = L1C_SIGN(I)(6:6)
            ELSE 
C             L1C_SIGN = 'starN'
              CH1 = L1C_SIGN(I)(5:5)
            ENDIF
            IF(CH1.NE.'0'.AND.CH1.NE.'1'.AND.CH1.NE.'2'.AND.
     *         CH1.NE.'3'.AND.CH1.NE.'4'.AND.CH1.NE.'5'.AND.
     *         CH1.NE.'6'.AND.CH1.NE.'7'.AND.CH1.NE.'8'.AND.
     *         CH1.NE.'9') THEN
              IERR = 3
              GO TO 100
            ENDIF 
            READ(CH1,'(I1)') ICROSS
            IF(L1C_SIGN(I)(1:4).EQ.'cros') THEN
              IBC    = L1C_I2ATM(I)
              IFR    = L1C_I3ATM(I)
              IF(ICROSS.GT.0) THEN
                IMC(1) = L1C_I4ATM(I) 
                IF(ICROSS.GT.1) THEN
                  IMC(2) = L1C_I5ATM(I) 
                  IF(ICROSS.GT.2) THEN
                    IMC(3) = L1C_I6ATM(I) 
                    IF(ICROSS.GT.3) THEN
                      IMC(4) = L1C_I7ATM(I) 
                      IF(ICROSS.GT.4) THEN
                        IMC(5) = L1C_I8ATM(I) 
                        IF(ICROSS.GT.5) THEN
                          IMC(6) = L1C_I9ATM(I)
                        ENDIF 
                      ENDIF 
                    ENDIF 
                  ENDIF 
                ENDIF 
              ENDIF 
            ELSE
              IBC    = 0
              IFR    = 0               
              IMC(1) = L1C_I2ATM(I) 
              IMC(2) = L1C_I3ATM(I) 
              IMC(3) = L1C_I4ATM(I) 
              IMC(4) = L1C_I5ATM(I) 
              IMC(5) = L1C_I6ATM(I) 
              IMC(6) = L1C_I7ATM(I) 
            ENDIF 
            SIGN = L1C_SIGN(I) 
            LC   = I
            GO TO 100 
          ELSE
C           there is usual chirality
            IERR = 9
            LC   = I
            GO TO 100 
          ENDIF
        ENDIF
      ENDDO
      IERR = 2
C ---------------------------------------
 100  CONTINUE
      RETURN
      END

      SUBROUTINE CHECK_DEFAULT_MET_CHIR(MDOC,MON,IA,NC
     *                                       ,IBOND,LIST,IERR)
C --------------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      REAL      A(9)
      LOGICAL   IS_IT_METAL
      EXTERNAL  IS_IT_METAL
      INTEGER   IBOND(10),IMIN(2),IMC(10),ITEMP(6),I180(2,10)
      CHARACTER LINE*256,SIGN*8,MON*8,CH1*1,LIST*1
C --------------------------------------------------------
      IERR = 0
C ---
      IF(NC.LE.1.OR.NC.GT.4) THEN
        IERR = 1
        RETURN 
      ENDIF  
C --- how many 180 90 120 ?
      ITETR = 1
      N180  = 0
      N90   = 0
      N120  = 0          
      DO I=1,10
        IMC(I) = 0 
      ENDDO
      DO I=1,NC-1 
        DO J=I+1,NC 
          CALL SRCH_ANGL(MDOC,MON,IBOND(I),IA,IBOND(J),ANG,LG,IERR)
          IF(IERR.NE.0) RETURN
          IF(ANG.GT.162.0) THEN
            N180 = N180 + 1
            IF(N180.LE.10) THEN
              I180(1,N180) = IBOND(I)
              I180(2,N180) = IBOND(J)
            ENDIF
          ENDIF
          IF(ABS(ANG-90.0).LT.10.0) THEN
            N90 = N90 + 1
          ENDIF
          IF(ABS(ANG-120.0).LT.10.0) THEN
            N120 = N120 + 1
          ENDIF
          IF(ABS(ANG-109.5).GT.5.0) ITETR = 0
        ENDDO
      ENDDO

      IF(NC.GT.2.AND.ITETR.EQ.1) GO TO 500

C ---------
      IF(NC.EQ.2) THEN
        IF(N180.EQ.1) THEN
          ICROSS = 0
          IBC    = IBOND(1)
          IFR    = IBOND(2)
          IMC(1) = 0         
        ELSE
C         OK
          RETURN
        ENDIF
      ELSE IF(NC.EQ.4.AND.N180.EQ.2.AND.N90.EQ.4) THEN
        ICROSS = 2 
        IBC = I180(1,1)
        IFR = I180(2,1)
        N = 0  
        DO I=1,NC
          IF(IBOND(I).NE.IBC.AND.IBOND(I).NE.IFR) THEN
            N = N + 1 
            IMC(N) = IBOND(I)
          ENDIF
        ENDDO
      ELSE IF(NC.EQ.3.AND.N180.EQ.1.AND.N90.EQ.2) THEN
        ICROSS = 1 
        IBC = I180(1,1)
        IFR = I180(2,1)
        N = 0  
        DO I=1,NC
          IF(IBOND(I).NE.IBC.AND.IBOND(I).NE.IFR) THEN
            N = N + 1 
            IMC(N) = IBOND(I)
          ENDIF
        ENDDO        
      ELSE IF(NC.EQ.3.AND.N120.EQ.2.AND.N180.EQ.0) THEN
        ICROSS = 3 
        IBC = 0
        IFR = 0
        IMC(1) = IBOND(1)
        IMC(2) = IBOND(2)
        IMC(3) = IBOND(3)
      ELSE
        IERR = 1 
        RETURN 
      ENDIF
C ---------
      CALL SET_METAL_CHIRALITY(MDOC,MON,ICROSS,IA,IBC,IFR,IMC,LC,IERR)
      IF(IERR.NE.0) THEN
        IERR = 3
        RETURN
      ENDIF

              IF(LIST.EQ.'T') THEN
                write(*,*) '---METAL_ang--corr'
                write(*,*) '-ia,nc,icross:',ia,nc,icross
                write(*,'(a,6i4)') '-ibc,ifr,mc(1234):',ibc,ifr
     *          ,imc(1),imc(2),imc(3),imc(4)                                
              ENDIF

      CALL METAL_ANGLE_TORS_CORRECTION(MDOC,MON,NC,IA,IBC,IFR
     *             ,IMC,ICROSS,IERR)
      IF(IERR.NE.0) THEN
        IERR = 3
        RETURN
      ENDIF
      RETURN       
C ---------
 500  CONTINUE
      N = 0
      DO I=1,NC
        IF(L1A_SYMB(IBOND(I)).NE.'H   '.AND.
     *     L1A_SYMB(IBOND(I)).NE.'D   '     ) THEN
          N = N + 1          
          IMC(N) = IBOND(I)
        ENDIF
      ENDDO
      IF(N.GE.3) THEN
        IF(L1C_NCHIR.GE.MAX1CHR) THEN
          WRITE(LINE,
     *'(''ERROR: number of chiral centres in monomer '',A,'' >'',I6)'
     *) MON,MAX1CHR
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *  '          Change parameter MAX1CHR in "lib_com.fh"')
          IERR=3
          RETURN
        ENDIF
        L1C_NCHIR   = L1C_NCHIR + 1
        L1C_I1ATM(L1C_NCHIR) = IA
        L1C_1ATM (L1C_NCHIR) = L1A_ANAME(IA)
        L1C_I2ATM(L1C_NCHIR) = IMC(1)
        L1C_2ATM (L1C_NCHIR) = L1A_ANAME(IMC(1))
        L1C_I3ATM(L1C_NCHIR) = IMC(2)
        L1C_3ATM (L1C_NCHIR) = L1A_ANAME(IMC(2))
        L1C_I4ATM(L1C_NCHIR) = IMC(3)
        L1C_4ATM (L1C_NCHIR) = L1A_ANAME(IMC(3))
        L1C_I5ATM(L1C_NCHIR) = 0
        L1C_5ATM (L1C_NCHIR) = '.'
        L1C_I6ATM(L1C_NCHIR) = 0
        L1C_6ATM (L1C_NCHIR) = '.'
        L1C_I7ATM(L1C_NCHIR) = 0
        L1C_7ATM (L1C_NCHIR) = '.'
        L1C_I8ATM(L1C_NCHIR) = 0
        L1C_8ATM (L1C_NCHIR) = '.'
        L1C_I9ATM(L1C_NCHIR) = 0
        L1C_9ATM (L1C_NCHIR) = '.'
        L1C_VOL  (L1C_NCHIR) = 0.0
        L1C_VOBS (L1C_NCHIR) = 0.0
        L1C_SIGN (L1C_NCHIR) = 'both'
        L1C_FLAG (L1C_NCHIR) = 'L'
        LC  = L1C_NCHIR
        PH1 = 0.0
        PH2 = 0.0
        PH3 = 0.0
        CALL CALC_IVOL(LC,VOLIDL,PH1,PH2,PH3)
        CALL CALC_OVOL(LC,VOLOBS,IERR)
        IERR = 0
        L1C_VOL (LC) = VOLIDL
        L1C_VOBS(LC) = VOLOBS
      ENDIF
C --------
      RETURN
      END

      SUBROUTINE METAL_CHIR_FROM_COORD(MDOC,LIST,MON
     *                                   ,IA,NC,IBOND,IERR)
C --------------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      REAL      A(9)
      LOGICAL   IS_IT_METAL
      EXTERNAL  IS_IT_METAL
      INTEGER   IBOND(10),IMIN(2),IMC(10),ITEMP(6),I180(2,10)
      CHARACTER LINE*256,SIGN*8,MON*8,CH1*1,LIST*1
C --------------------------------------------------------
C --------------------------------------------------------
      IERR  = 0
      DELTA = 18.0
C --- all coords ? nc > 1
      IF(NC.LE.1) RETURN 
      DO I=1,NC
        IF(L1A_COOR_FLAG(IBOND(I)).NE.'Y') THEN
          IERR = 2
          RETURN
        ENDIF
      ENDDO
C --- how many 180 ?
      ITETR = 1
      N180  = 0          
      DO I=1,NC-1 
        DO J=I+1,NC 
          CALL CALC_ANGOBS(IBOND(I),IA,IBOND(J),ANG)
          IF(ANG.GT.(180.0-DELTA)) THEN
            N180 = N180 + 1
            IF(N180.LE.10) THEN
              I180(1,N180) = IBOND(I)
              I180(2,N180) = IBOND(J)
            ENDIF
          ENDIF
          IF(ABS(ANG-109.5).GT.(DELTA/3.0)) ITETR = 0
        ENDDO
      ENDDO

      IF((NC.EQ.3.OR.NC.EQ.4).AND.ITETR.EQ.1) GO TO 500

C --- find bond with all others 90
      IBC   = 0
      NSIDE = 0  
      DO I=1,NC
        N = 0
        DO J=1,NC
          IF(I.NE.J) THEN
            CALL CALC_ANGOBS(IBOND(I),IA,IBOND(J),ANG)
            IF(ABS(ANG-90.0).GT.DELTA.AND.
     *             ANG.LT.(180.0-DELTA)) GO TO 100
            N = N + 1
          ENDIF
        ENDDO
        IF(IBC.EQ.0.OR.N.GT.NSIDE) THEN
          IBC   = IBOND(I)
          NSIDE = N
        ENDIF
 100    CONTINUE
      ENDDO
      IFR = 0      
      IF(IBC.GT.0.AND.N180.GT.0) THEN
        DO I=1,N180
          IF(IBC.EQ.I180(1,I)) THEN
            IFR = I180(2,I)
            GO TO 200
          ELSE IF(IBC.EQ.I180(2,I)) THEN
            IFR = I180(1,I)
            GO TO 200
          ENDIF 
        ENDDO
      ENDIF
 200  CONTINUE
C --- min_delta   
      IMIN(1) = 0 
      IMIN(2) = 0
      AMIN    = 1000.0  
      DO I=1,NC-1 
        DO J=I+1,NC 
          II = IBOND(I)
          JJ = IBOND(J)         
          IF(II.NE.IBC.AND.II.NE.IFR.AND.JJ.NE.IBC.AND.JJ.NE.IFR)THEN
            CALL CALC_ANGOBS(IBOND(I),IA,IBOND(J),ANG)
            IF(ANG.LT.AMIN) THEN
              AMIN = ANG
              IMIN(1) = II
              IMIN(2) = JJ
            ENDIF
          ENDIF
        ENDDO
      ENDDO
C ---        
      NSIDE = 0
      DO I=1,NC
        II = IBOND(I)
        IF(II.NE.IBC.AND.II.NE.IFR) NSIDE = NSIDE + 1
      ENDDO
      DO I=1,10
        IMC(I) = 0
      ENDDO
      NS180 = N180
      IF(IBC.GT.0.AND.IFR.GT.0) NS180 = NS180 -1

      IF(LIST.EQ.'T') THEN
        write(*,*) '---METAL_CHIR_FROM_COORD--',DELTA
        write(*,*) '-ia,nc,nside:',ia,nc,nside
        write(*,'(a,3i4)') '-ibc,ifr,n180:',ibc,ifr,N180,NS180
        write(*,*) '-amin:',amin,IMIN(1),IMIN(2)
        if(nc.gt.0)
     *   write(*,'(a,10i4)') '-ib:',(ibond(i),i=1,nc)
      ENDIF
C --------
      IF(NSIDE.EQ.0) THEN
        ICROSS = 0
        IF(IBC.EQ.0.AND.IFR.EQ.0) THEN
          IERR = 1
          GO TO 310
        ENDIF
        IMC(1) = 0
        GO TO 400 
      ELSE IF(NSIDE.EQ.1) THEN
        ICROSS = 1
        IF(IBC.EQ.0) THEN
          IERR = 1
          GO TO 310
        ENDIF
        DO I=1,NC
          II = IBOND(I)
          IF(II.NE.IBC.AND.II.NE.IFR) IMC(1) = IBOND(I)
        ENDDO
        GO TO 400
      ELSE 
        IF(NSIDE.EQ.2.AND.NS180.EQ.1) THEN
          ICROSS = 2
          IF(IBC.EQ.0.OR.IFR.EQ.0) THEN
            IERR = 1
            GO TO 310
          ENDIF
          GO TO 300
        ENDIF  
        IF((ABS(AMIN-90.0).LT.10.0).AND.
     *     NSIDE.LE.4                  ) THEN
          IF((NSIDE.GT.2.AND.NS180.GT.0).OR.
     *       (NSIDE.LE.2.AND.NS180.LE.0)    ) THEN
            ICROSS = 4
            GO TO 300
          ENDIF 
        ENDIF
        IF((ABS(AMIN-60.0).LT.10.0).AND.
     *     NSIDE.LE.6                  ) THEN
          IF((NSIDE.GT.3.AND.NS180.GT.0).OR.
     *       (NSIDE.LE.2.AND.NS180.LE.0)    ) THEN
            ICROSS = 6
            GO TO 300
          ENDIF 
        ENDIF
        IF((ABS(AMIN-120.0).LT.10.0).AND.
     *    NSIDE.LE.3.AND.NS180.LE.0      ) THEN
          ICROSS = 3
          GO TO 300
        ENDIF
        IF((ABS(AMIN-144.0).LT.10.0.AND.NSIDE.EQ.2).OR.
     *     (ABS(AMIN- 72.0).LT.10.0.AND.NSIDE.GE.2)    ) THEN
          IF(NSIDE.LE.5.AND.NS180.LE.0) THEN
            ICROSS = 5
            GO TO 300
          ENDIF 
        ENDIF
      ENDIF
 310  CONTINUE
C     ERROR
      IF(LIST.EQ.'T') THEN
        write(*,*) '---ierr=',ierr
        write(*,'(a,10i4)') '-ib:',(ibond(i),i=1,nc)
       DO I=1,NC-1 
          DO J=I+1,NC 
            CALL CALC_ANGOBS(IBOND(I),IA,IBOND(J),ANG)
            write(*,*) '-i,j,ang:',i,j,ang
          ENDDO
        ENDDO
      ENDIF
      IERR = 1
      RETURN
C -----------------------------
 300  CONTINUE
      IDELTA = 360/ICROSS
      IMC(1) = IMIN(1)      
      DO I=1,NC
        II = IBOND(I)
        IF(II.NE.IBC.AND.II.NE.IFR.AND.II.NE.IMC(1)) THEN
          CALL CALC_ANGOBS(IBOND(I),IA,IMC(1),ANG)
          VOL = 0.0
          IF(IBC.GT.0) THEN
            A(1) = L1A_X(IBC) - L1A_X(IA)
            A(4) = L1A_Y(IBC) - L1A_Y(IA)
            A(7) = L1A_Z(IBC) - L1A_Z(IA)
            A(2) = L1A_X(IMC(1)) - L1A_X(IA)
            A(5) = L1A_Y(IMC(1)) - L1A_Y(IA)
            A(8) = L1A_Z(IMC(1)) - L1A_Z(IA)
            A(3) = L1A_X(IBOND(I)) - L1A_X(IA)
            A(6) = L1A_Y(IBOND(I)) - L1A_Y(IA)
            A(9) = L1A_Z(IBOND(I)) - L1A_Z(IA)
            VOL =  A(1)*(A(5)*A(9)-A(8)*A(6))
     *           - A(4)*(A(2)*A(9)-A(8)*A(3))
     *           + A(7)*(A(2)*A(6)-A(5)*A(3))           
          ENDIF
          IANG = ANG/FLOAT(IDELTA) + 0.5
          IF(IANG.LT.0     ) IANG = 0
          IF(IANG.GT.ICROSS) IANG = IANG - ICROSS
          IF(VOL.LT.0.0) IANG = ICROSS - IANG
          IF(IANG.EQ.ICROSS) IANG = 0
          IANG = IANG + 1    
          IF(IANG.LE.2     ) IANG = 2
          IF(IANG.GT.ICROSS) IANG = ICROSS
          IF(IMC(IANG).GT.0) THEN
            IMC1 = 1
            IF(IANG.LT.ICROSS) IMC1 = IMC(IANG+1)
            IF(IMC(IANG-1).LE.0.AND.IANG.GT.2) THEN
              IMC(IANG-1) = II
            ELSE IF(IMC1.LE.0) THEN
              IMC(IANG+1) = II
            ELSE
              IMC(IANG) = II
            ENDIF        
          ELSE
            IMC(IANG) = II
          ENDIF
        ENDIF
      ENDDO
C ---
      IF(LIST.EQ.'T') THEN
        write(*,'(a,10i4)') '-imc:',(iMC(i),i=1,ICROSS)
      ENDIF 
      IF(IMC(2).EQ.0.AND.IMC(ICROSS).GT.0) THEN
        DO I=2,ICROSS
          J = ICROSS+2-I
          ITEMP(J) = IMC(I)
        ENDDO
        DO I=2,ICROSS
          IMC(I) = ITEMP(I)          
        ENDDO
      ENDIF
      IF(LIST.EQ.'T') THEN
        write(*,'(a,10i4)') '=imc:',(iMC(i),i=1,ICROSS)
      ENDIF 
C ---------------------------      
 400  CONTINUE
      CALL SET_METAL_CHIRALITY(MDOC,MON,ICROSS,IA,IBC,IFR,IMC,LC,IERR)
      IF(IERR.NE.0) THEN
        IERR = 3
        RETURN
      ENDIF
      CALL METAL_ANGLE_TORS_CORRECTION(MDOC,MON,NC,IC,IBC,IFR
     *             ,IMC,ICROSS,IERR)
      IF(IERR.NE.0) THEN
        IERR = 3
        RETURN
      ENDIF
      RETURN
C ---------
 500  CONTINUE
      N = 0
      DO I=1,NC
        IF(L1A_SYMB(IBOND(I)).NE.'H   '.AND.
     *     L1A_SYMB(IBOND(I)).NE.'D   '     ) THEN
          N = N + 1          
          IMC(N) = IBOND(I)
        ENDIF
      ENDDO
      IF(N.GE.3) THEN
        IF(L1C_NCHIR.GE.MAX1CHR) THEN
          WRITE(LINE,
     *'(''ERROR: number of chiral centres in monomer '',A,'' >'',I6)'
     *) MON,MAX1CHR
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *  '          Change parameter MAX1CHR in "lib_com.fh"')
          IERR=3
          RETURN
        ENDIF
        L1C_NCHIR   = L1C_NCHIR + 1
        L1C_I1ATM(L1C_NCHIR) = IA
        L1C_1ATM (L1C_NCHIR) = L1A_ANAME(IA)
        L1C_I2ATM(L1C_NCHIR) = IMC(1)
        L1C_2ATM (L1C_NCHIR) = L1A_ANAME(IMC(1))
        L1C_I3ATM(L1C_NCHIR) = IMC(2)
        L1C_3ATM (L1C_NCHIR) = L1A_ANAME(IMC(2))
        L1C_I4ATM(L1C_NCHIR) = IMC(3)
        L1C_4ATM (L1C_NCHIR) = L1A_ANAME(IMC(3))
        L1C_I5ATM(L1C_NCHIR) = 0
        L1C_5ATM (L1C_NCHIR) = '.'
        L1C_I6ATM(L1C_NCHIR) = 0
        L1C_6ATM (L1C_NCHIR) = '.'
        L1C_I7ATM(L1C_NCHIR) = 0
        L1C_7ATM (L1C_NCHIR) = '.'
        L1C_I8ATM(L1C_NCHIR) = 0
        L1C_8ATM (L1C_NCHIR) = '.'
        L1C_I9ATM(L1C_NCHIR) = 0
        L1C_9ATM (L1C_NCHIR) = '.'
        L1C_VOL  (L1C_NCHIR) = 0.0
        L1C_VOBS (L1C_NCHIR) = 0.0
        L1C_SIGN (L1C_NCHIR) = 'both'
        L1C_FLAG (L1C_NCHIR) = 'L'
        LC  = L1C_NCHIR
        PH1 = 0.0
        PH2 = 0.0
        PH3 = 0.0
        CALL CALC_IVOL(LC,VOLIDL,PH1,PH2,PH3)
        CALL CALC_OVOL(LC,VOLOBS,IERR)
        IERR = 0
        L1C_VOL (LC) = VOLIDL
        L1C_VOBS(LC) = VOLOBS
      ENDIF
C --------
      RETURN
      END

      SUBROUTINE SET_METAL_CHIRALITY(MDOC,MON,ICROSS
     *                              ,IA,IBC,IFR,IMC,LC,IERR)
C --------------------------------------------------------
      INTEGER   MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C ---
      INTEGER   IMC(*)
      CHARACTER LINE*256,CH1*1,MON*8
C --------------------------------------------------------
      IERR = 0
      LC   = 0
      IF(L1C_NCHIR.GE.MAX1CHR) THEN
        WRITE(LINE,
     *'(''ERROR: number of chiral centres in monomer '',A,'' >'',I6)'
     *) MON,MAX1CHR
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     *  '          Change parameter MAX1CHR in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF
      IF(IA.LE.0) RETURN 
     
      L1C_NCHIR   = L1C_NCHIR + 1

      L1C_2ATM(L1C_NCHIR) = '.'
      L1C_3ATM(L1C_NCHIR) = '.'
      L1C_4ATM(L1C_NCHIR) = '.'
      L1C_5ATM(L1C_NCHIR) = '.'
      L1C_6ATM(L1C_NCHIR) = '.'
      L1C_7ATM(L1C_NCHIR) = '.'
      L1C_8ATM(L1C_NCHIR) = '.'
      L1C_9ATM(L1C_NCHIR) = '.'
      L1C_I2ATM(L1C_NCHIR) = 0
      L1C_I3ATM(L1C_NCHIR) = 0
      L1C_I4ATM(L1C_NCHIR) = 0
      L1C_I5ATM(L1C_NCHIR) = 0
      L1C_I6ATM(L1C_NCHIR) = 0
      L1C_I7ATM(L1C_NCHIR) = 0
      L1C_I8ATM(L1C_NCHIR) = 0
      L1C_I9ATM(L1C_NCHIR) = 0

      L1C_I1ATM(L1C_NCHIR) = IA
      L1C_1ATM (L1C_NCHIR) = L1A_ANAME(IA)
      L1C_I2ATM(L1C_NCHIR) = IBC
      IF(IBC.GT.0) L1C_2ATM (L1C_NCHIR) = L1A_ANAME(IBC)
      L1C_I3ATM(L1C_NCHIR) = IFR
      IF(IFR.GT.0) L1C_3ATM (L1C_NCHIR) = L1A_ANAME(IFR)
      L1C_I4ATM(L1C_NCHIR) = IMC(1)
      IF(IMC(1).GT.0) L1C_4ATM (L1C_NCHIR) = L1A_ANAME(IMC(1))
      IF(ICROSS.GT.2) THEN 
        L1C_I5ATM(L1C_NCHIR) = IMC(2)
        IF(IMC(2).GT.0) L1C_5ATM (L1C_NCHIR) = L1A_ANAME(IMC(2))
        L1C_I6ATM(L1C_NCHIR) = IMC(3)
        IF(IMC(3).GT.0) L1C_6ATM (L1C_NCHIR) = L1A_ANAME(IMC(3))
        L1C_I7ATM(L1C_NCHIR) = IMC(4)
        IF(IMC(4).GT.0) L1C_7ATM (L1C_NCHIR) = L1A_ANAME(IMC(4))
        L1C_I8ATM(L1C_NCHIR) = IMC(5)
        IF(IMC(5).GT.0) L1C_8ATM (L1C_NCHIR) = L1A_ANAME(IMC(5))
        L1C_I9ATM(L1C_NCHIR) = IMC(6)
        IF(IMC(6).GT.0) L1C_9ATM (L1C_NCHIR) = L1A_ANAME(IMC(6))
      ENDIF
      L1C_VOL  (L1C_NCHIR) = 0.0
      L1C_VOBS (L1C_NCHIR) = 0.0
      WRITE(CH1,'(I1)') ICROSS
      L1C_SIGN(L1C_NCHIR) = 'cross'//CH1
      L1C_FLAG(L1C_NCHIR) = 'X'
      LC = L1C_NCHIR
C --------
      RETURN
      END

      SUBROUTINE H_ATOM_COORS_REBUILD(MDOC,LIST,IMODE,IERR)
C --------------------------------------------------------
      INTEGER   MDOC,IERR,IMODE
C
C     IMODE = 0 generate H-atom coords (if there are only nonH-atom coors)
C           = 1 new H-atom coords
C ---
      INCLUDE 'lib_com.fh'
C ---
      REAL      V1(3),V2(3),V3(3),VV(3,12),VN(3)
      INTEGER   ICONN(12)
      CHARACTER LINE*256,LIST*1,MON*8
C --------------------------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      IERR  = 0
      MON   = ' '
      IF(L1A_NATOM.LE.3) RETURN
C ----
      ICOOR        = 0
      COOR_SUM     = 0.0
      ICOOR_TOT    = 0
      COOR_SUM_TOT = 0.0
      DO I=1,L1A_NATOM

        IF(L1A_COOR_FLAG(I).EQ.'N'.OR.
     *     L1A_COOR_FLAG(I).EQ.'.') THEN
          ICOOR_TOT=1 
        ELSE
          COOR_SUM_TOT = COOR_SUM_TOT +  
     *           ABS(L1A_X(I)) + ABS(L1A_Y(I)) + ABS(L1A_Z(I)) 
        ENDIF

        IF(L1A_SYMB(I).NE.'H   '.AND.
     *     L1A_SYMB(I).NE.'D   '     ) THEN
          IF(L1A_COOR_FLAG(I).EQ.'N'.OR.
     *       L1A_COOR_FLAG(I).EQ.'.') THEN
            ICOOR=1 
          ELSE
            COOR_SUM = COOR_SUM +  
     *             ABS(L1A_X(I)) + ABS(L1A_Y(I)) + ABS(L1A_Z(I)) 
          ENDIF
        ENDIF
      ENDDO
      IF(COOR_SUM.LT.0.001) ICOOR = 1
      IF(COOR_SUM_TOT.LT.0.001) ICOOR_TOT = 1
C
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '>>ICOOR,ICOOR_TOT:',ICOOR,ICOOR_TOT
      ENDIF
C        nonH-atoms -  not all nonH-atoms have coords 
      IF(ICOOR.GT.0) RETURN
C        all atoms have coords 
      IF(IMODE.EQ.0.AND.ICOOR_TOT.LE.0) RETURN
      IF(L1T_NTORS.LE.0) RETURN
C ----
      DO II=1,L1A_NATOM
        IF(L1A_SYMB(II).NE.'H   '.AND.L1A_SYMB(II).NE.'D   ') THEN

          CALL SET_CONN_L(II,N,NH,ICONN)
               
          IF(LIST.EQ.'T') THEN
            write(*,*) '========>',ii,L1A_ANAME(ii),n,nh
          ENDIF 

          IF(NH.NE.(N-1)) THEN
            IERR = 4
            GO TO 300
          ENDIF
          DO J=1,N
            JA = ICONN(J)  
            IF(L1A_SYMB(JA).EQ.'H   '.OR.
     *         L1A_SYMB(JA).EQ.'D   '    ) THEN
              I = JA  
            ENDIF 
          ENDDO 

          DO IT=1,L1T_NTORS
            I1  = L1T_I1ATM(IT)
            I2  = L1T_I2ATM(IT)
            I3  = L1T_I3ATM(IT)
            I4  = L1T_I4ATM(IT)
            IF(I1.EQ.I.OR.I4.EQ.I) THEN
              IF(I1.EQ.I) THEN
                IB   = I2
                IBB  = I3
                IBBB = I4
              ELSE
                IB   = I3
                IBB  = I2
                IBBB = I1
              ENDIF
              PH  = L1T_VAL(IT) 
              PH  = PH*PI180  
              GO TO 100
            ENDIF   
          ENDDO
          IERR = 2
          GO TO 300

 100      CONTINUE

          CALL SET_CONN_L(IB,N,NH,ICONN)
         
          IF(LIST.EQ.'T') THEN
            WRITE(*,*) '-IB,N,NH:',IB,N,NH
          ENDIF 
C ----
C         IBBB --> IBB --> IB --> I(h)
C              AV1     AV2    AV3 
C                 ANG1    ANG2
C                      PH
            
          CALL SRCH_BOND(MDOC,MON,I,IB,AV3,LB,IERR)
          IF(IERR.NE.0) GO TO 200

          CALL SRCH_BOND(MDOC,MON,IB,IBB,AV2,LB,IERR)
          IF(IERR.NE.0) GO TO 200

          CALL SRCH_BOND(MDOC,MON,IBB,IBBB,AV1,LB,IERR)
          IF(IERR.NE.0) GO TO 200

          CALL SRCH_ANGL(MDOC,MON,IB,IBB,IBBB,ANG1,LG,IERR)
          IF(IERR.NE.0) GO TO 200
          ANG1 = ANG1*PI180

          CALL SRCH_ANGL(MDOC,MON,I,IB,IBB,ANG2,LG,IERR)
          IF(IERR.NE.0) GO TO 200
          ANG2 = ANG2*PI180

          V1(1) =  L1A_X(IBB) - L1A_X(IBBB)
          V1(2) =  L1A_Y(IBB) - L1A_Y(IBBB)
          V1(3) =  L1A_Z(IBB) - L1A_Z(IBBB)

          V2(1) =  L1A_X(IB) - L1A_X(IBB)
          V2(2) =  L1A_Y(IB) - L1A_Y(IBB)
          V2(3) =  L1A_Z(IB) - L1A_Z(IBB)
 
          CALL COORD_4(AV1,AV2,AV3,V1,V2,ANG1,ANG2,PH,V3)
          L1A_X(I) = L1A_X(IB) + V3(1)
          L1A_Y(I) = L1A_Y(IB) + V3(2)
          L1A_Z(I) = L1A_Z(IB) + V3(3)
          L1A_COOR_FLAG(I) = 'Y'

          IF(LIST.EQ.'T') write(*,*) '==>',i,L1A_ANAME(i),ph 

          IF(NH.GT.1) THEN
            DELTA = TWOPI/FLOAT(NH)
            DO J=1,N
              JA = ICONN(J)  
              IF(JA.NE.I) THEN
                IF(L1A_SYMB(JA).EQ.'H   '.OR.
     *             L1A_SYMB(JA).EQ.'D   '    ) THEN
                  PH = PH + DELTA 
                  CALL COORD_4(AV1,AV2,AV3,V1,V2,ANG1,ANG2,PH,V3)
                  L1A_X(JA) = L1A_X(IB) + V3(1)
                  L1A_Y(JA) = L1A_Y(IB) + V3(2)
                  L1A_Z(JA) = L1A_Z(IB) + V3(3)
                  L1A_COOR_FLAG(JA) = 'Y'
              
          IF(LIST.EQ.'T') write(*,*) '==>',ja,L1A_ANAME(ja),ph 

                ENDIF
              ENDIF 
            ENDDO 
          ENDIF 
          GO TO 200
      
 300      CONTINUE
          IBACK = II

          IF(LIST.EQ.'T') WRITE(*,*) '=IBACK,N,NH:',IBACK,N,NH,IERR

          IF(NH.EQ.1.AND.N.GE.3) THEN          
            V3(1) = 0.0
            V3(2) = 0.0
            V3(3) = 0.0
            NN    = 0
            C     = -1.0
            DO J=1,N
              JA = ICONN(J)  

            IF(LIST.EQ.'T') then
              write(*,*) '>',J,ja,L1A_ANAME(ja),NN,L1A_SYMB(JA)
            ENDIF

              IF(L1A_SYMB(JA).EQ.'H   '.OR.
     *           L1A_SYMB(JA).EQ.'D   '    ) THEN
                JAH = JA  
              ELSE
                V1(1) = (L1A_X(IBACK) - L1A_X(JA))
                V1(2) = (L1A_Y(IBACK) - L1A_Y(JA))
                V1(3) = (L1A_Z(IBACK) - L1A_Z(JA))
                CALL NB_VMOD(V1,AV1)
                IF(AV1.GT.0.2) THEN 
                  NN       = NN + 1
                  VV(1,NN) = V1(1)/AV1
                  VV(2,NN) = V1(2)/AV1
                  VV(3,NN) = V1(3)/AV1
                ENDIF 
                V3(1) = V3(1) + V1(1)/AV1
                V3(2) = V3(2) + V1(2)/AV1
                V3(3) = V3(3) + V1(3)/AV1
              ENDIF
            ENDDO
            CALL SRCH_BOND(MDOC,MON,JAH,IBACK,AV3,LB,IERR)
            IF(IERR.NE.0) GO TO 200
            IF(NN.GE.3) THEN
              V1(1) = VV(1,2) - VV(1,1)                  
              V1(2) = VV(2,2) - VV(2,1)                  
              V1(3) = VV(3,2) - VV(3,1)                  
              V2(1) = VV(1,3) - VV(1,1)                  
              V2(2) = VV(2,3) - VV(2,1)                  
              V2(3) = VV(3,3) - VV(3,1)                  
              CALL NB_VMULT(V1,V2,VN)
              CALL NB_VMOD(VN,AVN)
              IF(AVN.GT.0.02) THEN
                CALL NB_VMOD(V3,AV1)
                IF(AV1.GT.0.01) THEN
                  CALL NB_VPROD(V3,VN,PROD)
                  C = 1.0
                  IF(PROD.LT.0.0) C = -1.0  
                  V3(1) = VN(1)*C
                  V3(2) = VN(2)*C
                  V3(3) = VN(3)*C
                ELSE
                  V3(1) = VN(1)
                  V3(2) = VN(2)
                  V3(3) = VN(3)
                ENDIF
              ENDIF
            ENDIF

            CALL NB_VMOD(V3,AV1)
            IF(AV1.LT.0.01) GO TO 200
            V3(1) = (V3(1)*AV3)/AV1
            V3(2) = (V3(2)*AV3)/AV1
            V3(3) = (V3(3)*AV3)/AV1

            L1A_X(JAH) = L1A_X(IBACK) + V3(1)
            L1A_Y(JAH) = L1A_Y(IBACK) + V3(2)
            L1A_Z(JAH) = L1A_Z(IBACK) + V3(3)
            L1A_COOR_FLAG(JAH) = 'Y'
              
            IF(LIST.EQ.'T') then
              write(*,*) '==>',jah,L1A_ANAME(jah),av1,C,NN
            ENDIF
            IERR = 0
            GO TO 200
          ELSE IF(NH.EQ.2.AND.N.EQ.4) THEN
            JJA = 0
            DO J=1,N
              JAA = ICONN(J)  
              IF(L1A_SYMB(JAA).NE.'H   '.AND.
     *           L1A_SYMB(JAA).NE.'D   '      ) THEN
                JA = JAA
                IF(JJA.LE.0) JJA = JA  
              ELSE
                JAH = JAA
              ENDIF
            ENDDO

            IF(LIST.EQ.'T') write(*,*) '  ja,jja:',ja,jja
  
C            JJA'        H
C               \       /
C                JA-->IBACK 
C                       \
C                       JJA
            V1(1) =  L1A_X(JJA)   - L1A_X(IBACK)
            V1(2) =  L1A_Y(JJA)   - L1A_Y(IBACK)
            V1(3) =  L1A_Z(JJA)   - L1A_Z(IBACK)
            V2(1) =  L1A_X(IBACK) - L1A_X(JA)
            V2(2) =  L1A_Y(IBACK) - L1A_Y(JA)
            V2(3) =  L1A_Z(IBACK) - L1A_Z(JA)
            CALL NB_VMOD(V1,AV1)
            CALL NB_VMOD(V2,AV2)
            IF(AV1.LT.0.01.OR.AV2.LT.0.01) GO TO 200
            CALL NB_VPROD(V1,V2,S)
            COSA1 = S/(AV1*AV2)
            ANG1  = ACOS(AMIN1(AMAX1(COSA1,-1.0),1.0))
            ANG1  = PI-ANG1
            CALL SRCH_BOND(MDOC,MON,JAH,IBACK,AV3,LB,IERR)
            IF(IERR.NE.0) GO TO 200
            ANG2  = 109.54*PI180
            DELTA = TWOPI/3.0
            PH    = (-180.0)*PI180
            DO J=1,N
              JAA = ICONN(J)  
              IF(L1A_SYMB(JAA).EQ.'H   '.OR.
     *           L1A_SYMB(JAA).EQ.'D   '    ) THEN
                PH = PH + DELTA 
                CALL COORD_4(AV1,AV2,AV3,V1,V2,ANG1,ANG2,PH,V3)
                L1A_X(JAA) = L1A_X(IBACK) + V3(1)
                L1A_Y(JAA) = L1A_Y(IBACK) + V3(2)
                L1A_Z(JAA) = L1A_Z(IBACK) + V3(3)
                L1A_COOR_FLAG(JAA) = 'Y'
              
         IF(LIST.EQ.'T') write(*,*) '==>',jaa,L1A_ANAME(jaa),ph 

              ENDIF
            ENDDO 
            IERR = 0
            GO TO 200
          ENDIF 
 200      CONTINUE
          IF(LIST.EQ.'T') THEN
            WRITE(*,*) '>>I,IERR:',I,IERR
          ENDIF
          IERR = 0 
        ENDIF
      ENDDO
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '>>IERR:',IERR
      ENDIF
      IERR = 0
C --------
      RETURN
      END

      SUBROUTINE SET_CONN_L(IA,N,NH,ICONN)
C -----------------------------------
      INCLUDE 'lib_com.fh'
C ----------------------------------------------------------
      INTEGER     IA,N,ICONN(*)
C -----------------------------------
      N  = 0
      NH = 0
      IF(IA.LE.0) RETURN
      IF(L1A_IBACK(IA).GT.0) THEN
        N = N + 1 
        ICONN(N) = L1A_IBACK(IA)
      ENDIF
      IF(L1A_NDIST(IA).GT.0) THEN
        DO J=1,L1A_NDIST(IA)
          IC = L1A_CONN(J,IA)
          N  = N + 1 
          ICONN(N) = IC
        ENDDO
      ENDIF
      IF(L1A_NEXTR(IA).GT.0) THEN
        DO J=1,L1A_NEXTR(IA)
          IC = L1A_IEXTR(J,IA)
          N  = N + 1 
          ICONN(N) = IC
        ENDDO
      ENDIF
      IF(N.GT.0) THEN
        DO I=1,N
          IC = ICONN(I)
          IF(L1A_SYMB(IC).EQ.'H   '.OR.L1A_SYMB(IC).EQ.'D   ')
     *    NH = NH + 1
        ENDDO
      ENDIF
C ----
      RETURN
      END
