C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
      SUBROUTINE SET_UNIT_CORR
C -------------------------------
C     in make_subr.f:
C                    in SUBROUTINE START: after CALL SET_UNIT_NUMBERS  
C
C -------------------------------
      RETURN
      END

      SUBROUTINE SET_LINK_CORR
C -------------------------------
C     in make_crd.f:
C                    in SUBROUTINE PRE_DESCR  
C
C -------------------------------
      RETURN
      END

      SUBROUTINE WRT_BATCH(LINE)
C
C -P- WRT_BATCH - dummy routine.
C
      CHARACTER LINE*(*)
C ----------------------------
      RETURN
      END

      SUBROUTINE CLOSE_BATCH(M)
C
C -P- CLOSE_BATCH - dummy routine.
C ---
      INTEGER   M
C -------------------------
      RETURN
      END

      SUBROUTINE FINISH
C -----------------------------------------------------------
C     FINISH - dummy routine.
C -----------------------------------------------------------
      RETURN
      END

      SUBROUTINE OPENDOC(MMDOC)
C ---
      IMPLICIT NONE
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER   IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER   BAT_MODE,BATCH_FILE,IBATCH
      REAL RVAL_1,RVAL_2
C ---
      INTEGER    MMDOC
C ----------------------------
cd      INCLUDE 'crd_com.fh'
C ---------------------------------------------------------------------
C     set 1 if you want to write to log-file. 

      DOC_FILE   = 0

      RETURN
      END

      SUBROUTINE CREAT_VDW_REST(MDOC,NAMEO,CUTOFF,DMIN,IERR)
C -----------------------------------------------------------
C     dummy routine for refmac
C
      INTEGER   MDOC,IERR
      REAL      CUTOFF,DMIN
      CHARACTER NAMEO*(*)
C -----------------------------------------------------------
      IERR = 0
C --------
      RETURN
      END

      SUBROUTINE WRITE_DEPOSIT_STATS(IOUT_FILE)
c
C---This subroutine writes deposition files to IOUT_FILE.
C---IOUT_FILe is normally pdb file. It will write only if
C---number of reflections is more than 0.
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'ncs_rest.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'solvent.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'makecif_version.fh'
      INTEGER IOUT_FILE
C
C---Local variables
      INTEGER NB1,I,IREST,ITLSGRP,IPIECE,INCS,IGRP,INCH,LENSTR,
     &        N_REFINED_ATOMS,ISPAN
      REAL B_OVER_COOR,S_TENS(3,3),RTD2
      CHARACTER ALL_CHAINS*120
C
      EXTERNAL LENSTR
C---
C----Info about program. I.e. REFMAC
      RTD2 = RTODEG*RTODEG
      IF(NHREFL_WORK.LE.0) RETURN
      NB1 = NBIN + 1
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3 REFINEMENT.'
      WRITE(IOUT_FILE,'(A,A)')
     &'REMARK   3   PROGRAM     : REFMAC ',R_VERSNO
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   AUTHORS     : MURSHUDOV,VAGIN,DODSON'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
C
C---What kind of residual
      IF(REFS.EQ.'MLKF') THEN
      IF(.NOT.MIR_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    REFINEMENT TARGET : MAXIMUM LIKELIHOOD'
      ELSEIF(MIR_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    REFINEMENT TARGET : MAXIMUM LIKELIHOOD WITH PHASES' 
      ENDIF
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    REFINEMENT TARGET : LEAST-SQUARES'
      ENDIF
C
C---Info about data (overall info)
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  DATA USED IN REFINEMENT.'
      WRITE(IOUT_FILE,'(A,F6.2)')
     &'REMARK   3   RESOLUTION RANGE HIGH (ANGSTROMS) : ',HD_HIGH
      WRITE(IOUT_FILE,'(A,F6.2)')
     &'REMARK   3   RESOLUTION RANGE LOW  (ANGSTROMS) : ',HD_LOW
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   DATA CUTOFF            (SIGMA(F)) : NONE'
      WRITE(IOUT_FILE,'(A,F6.2)')
     &'REMARK   3   COMPLETENESS FOR RANGE        (%) : ',
     & HPERC_SHELL_REFL(NB1)
      WRITE(IOUT_FILE,'(A,I7)')
     &'REMARK   3   NUMBER OF REFLECTIONS             : ',
     &HNREF_SHELL_WORK(NB1)
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
C
C---Info about cross validation and other overall stats 
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  FIT TO DATA USED IN REFINEMENT.'
      IF(PERC_FREE.GT.0.0) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   CROSS-VALIDATION METHOD          : THROUGHOUT'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   FREE R VALUE TEST SET SELECTION  : RANDOM'
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   CROSS-VALIDATION METHOD          : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   FREE R VALUE TEST SET SELECTION  : NULL'
      ENDIF
      WRITE(IOUT_FILE,'(A,F8.5)')
     &'REMARK   3   R VALUE     (WORKING + TEST SET) :',
     &        HRFAC_SHELL_ALL(NB1)
      WRITE(IOUT_FILE,'(A,F8.5)')
     &'REMARK   3   R VALUE            (WORKING SET) : ',
     &        RFACTOR_WORK
      IF(PERC_FREE.GT.0.0) THEN
      WRITE(IOUT_FILE,'(A,F8.5)')
     &'REMARK   3   FREE R VALUE                     : ',RFACTOR_FREE
      WRITE(IOUT_FILE,'(A,F4.1)')
     &'REMARK   3   FREE R VALUE TEST SET SIZE   (%) : ',PERC_FREE
      WRITE(IOUT_FILE,'(A,I5)')
     &'REMARK   3   FREE R VALUE TEST SET COUNT      : ',NHREFL_FREE
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   FREE R VALUE                     : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   FREE R VALUE TEST SET SIZE   (%) : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   FREE R VALUE TEST SET COUNT      : NULL'   
      ENDIF
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
C
C---Info about highest resolution bin
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  FIT IN THE HIGHEST RESOLUTION BIN.'
      WRITE(IOUT_FILE,'(A,I8)')
     &'REMARK   3   TOTAL NUMBER OF BINS USED           :',HNSHELL
      WRITE(IOUT_FILE,'(A,F8.3)')
     &'REMARK   3   BIN RESOLUTION RANGE HIGH           : ',
     &                           HD_SHELL_HIGH(HNSHELL)
      WRITE(IOUT_FILE,'(A,F8.3)')
     &'REMARK   3   BIN RESOLUTION RANGE LOW            : ',
     &                           HD_SHELL_LOW(HNSHELL)
      WRITE(IOUT_FILE,'(A,I8)')
     &'REMARK   3   REFLECTION IN BIN     (WORKING SET) : ',
     &                           HNREF_SHELL_WORK(HNSHELL)
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3   BIN COMPLETENESS (WORKING+TEST) (%) : ',
     &                           HPERC_SHELL_REFL(HNSHELL)
      WRITE(IOUT_FILE,'(A,F8.3)')
     &'REMARK   3   BIN R VALUE           (WORKING SET) : ',
     &                           HRFAC_SHELL_WORK(HNSHELL)
      WRITE(IOUT_FILE,'(A,I8)')
     &'REMARK   3   BIN FREE R VALUE SET COUNT          : ',
     &                           HNREF_SHELL_FREE(HNSHELL)
      WRITE(IOUT_FILE,'(A,F8.3)')
     &'REMARK   3   BIN FREE R VALUE                    : ',
     &                           HRFAC_SHELL_FREE(HNSHELL)      
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
C
C---Info about number of different atoms      
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  NUMBER OF NON-HYDROGEN ATOMS USED IN REFINEMENT.'
      CALL FIND_NREFINED_ATOMS(N_REFINED_ATOMS)
      WRITE(IOUT_FILE,'(A,I8)')
     &'REMARK   3   ALL ATOMS                : ',N_REFINED_ATOMS
cREMARK   3   NUCLEIC ACID ATOMS       : NULL
cREMARK   3   HETEROGEN ATOMS          : NULL
cREMARK   3   SOLVENT ATOMS            : NULL
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'

C
C---Info about B values, Iso and aniso.
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  B VALUES.'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   FROM WILSON PLOT           (A**2) : NULL'
      CALL FIND_B_OVER_COOR(B_OVER_COOR)
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   MEAN B VALUE      (OVERALL, A**2) : ',B_OVER_COOR
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   OVERALL ANISOTROPIC B VALUE.'
C
C----IF anisotropic scaling is available
      IF(B_LS_ANISO_OVER_FLAG) THEN
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3    B11 (A**2) : ',B_LS_ANISO_OVER(1)
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3    B22 (A**2) : ',B_LS_ANISO_OVER(2)
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3    B33 (A**2) : ',B_LS_ANISO_OVER(3)
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3    B12 (A**2) : ',B_LS_ANISO_OVER(4)
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3    B13 (A**2) : ',B_LS_ANISO_OVER(5)
      WRITE(IOUT_FILE,'(A,F8.2)')
     &'REMARK   3    B23 (A**2) : ',B_LS_ANISO_OVER(6)
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    B11 (A**2) : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    B22 (A**2) : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    B33 (A**2) : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    B12 (A**2) : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    B13 (A**2) : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    B23 (A**2) : NULL'
      ENDIF
C
C---Some overall error estimations
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  ESTIMATED OVERALL COORDINATE ERROR.'
      IF(HESU_CRUIC.GT.0.0) THEN
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   ESU BASED ON R VALUE                            '//
     &'(A): ',HESU_CRUIC
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   ESU BASED ON R VALUE                            '//
     &'(A): NULL'
      ENDIF
      IF(HESU_FREE.GT.0.0) THEN
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   ESU BASED ON FREE R VALUE                       '//
     &'(A): ',HESU_FREE
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   ESU BASED ON FREE R VALUE                       '//
     &'(A): NULL'
      WRITE(IOUT_FILE,'(A)')
      ENDIF
      IF(HESU_ML.GT.0.0) THEN
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   ESU BASED ON MAXIMUM LIKELIHOOD                 '//
     &'(A): ',HESU_ML
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   ESU BASED ON MAXIMUM LIKELIHOOD                 '//
     &'(A): NULL'
      ENDIF
      IF(HESU_ML_B.GT.0.0) THEN
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   ESU FOR B VALUES BASED ON MAXIMUM LIKELIHOOD '//
     &'(A**2): ',HESU_ML_B
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   ESU FOR B VALUES BASED ON MAXIMUM LIKELIHOOD '//
     &'(A**2): NULL'
      ENDIF
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'

C
C---Correlation coefficients
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3 CORRELATION COEFFICIENTS.'
      IF(HCORR_FOFC.LE.1.0.AND.HCORR_FOFC.GE.-1.0) THEN
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   CORRELATION COEFFICIENT FO-FC      : ',HCORR_FOFC
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   CORRELATION COEFFICIENT FO-FC      : NULL'
      ENDIF
      IF(HCORR_FOFC_FREE.LE.1.0.AND.HCORR_FOFC_FREE.GE.-1.0) THEN
      WRITE(IOUT_FILE,'(A,F7.3)')
     &'REMARK   3   CORRELATION COEFFICIENT FO-FC FREE : ',
     &HCORR_FOFC_FREE
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   CORRELATION COEFFICIENT FO-FC FREE : NULL'
      ENDIF
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
C
C---Geometric restraints
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  RMS DEVIATIONS FROM IDEAL VALUES        COUNT'
     &//'    RMS    WEIGHT'
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Bond distances: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   BOND LENGTHS REFINED ATOMS        (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO      
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Bond distances: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   BOND LENGTHS OTHERS               (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO  
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Bond angles  : refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   BOND ANGLES REFINED ATOMS   (DEGREES):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Bond angles  : others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   BOND ANGLES OTHERS          (DEGREES):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Torsion angles, period  1. refined')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   TORSION ANGLES, PERIOD 1    (DEGREES):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Torsion angles, period  2. refined')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   TORSION ANGLES, PERIOD 2    (DEGREES):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Torsion angles, period  3. refined')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   TORSION ANGLES, PERIOD 3    (DEGREES):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Torsion angles, period  4. refined')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   TORSION ANGLES, PERIOD 4    (DEGREES):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Chiral centres: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   CHIRAL-CENTER RESTRAINTS       (A**3):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Planar groups: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   GENERAL PLANES REFINED ATOMS      (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Planar groups: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   GENERAL PLANES OTHERS             (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO

      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'VDW repulsions: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   NON-BONDED CONTACTS REFINED ATOMS (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO 
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'VDW repulsions: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   NON-BONDED CONTACTS OTHERS        (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO      

      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'VDW; torsion: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   NON-BONDED TORSION REFINED ATOMS  (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'VDW; torsion: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   NON-BONDED TORSION OTHERS         (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO

      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'HBOND: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   H-BOND (X...Y) REFINED ATOMS      (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'HBOND: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   H-BOND (X...Y) OTHERS             (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO

      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Metal-ion: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   POTENTIAL METAL-ION REFINED ATOMS (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.'Metal-ion: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   POTENTIAL METAL-ION OTHERS        (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &    'VDW repulsions; symmetry: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SYMMETRY VDW REFINED ATOMS        (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &    'VDW repulsions; symmetry: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SYMMETRY VDW OTHERS               (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &    'HBOND; symmetry: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SYMMETRY H-BOND REFINED ATOMS     (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &    'HBOND; symmetry: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SYMMETRY H-BOND OTHERS            (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &    'Metal-ion; symmetry: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SYMMETRY METAL-ION REFINED ATOMS  (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &    'Metal-ion; symmetry: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SYMMETRY METAL-ION OTHERS         (A):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO

      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  ISOTROPIC THERMAL FACTOR RESTRAINTS.     COUNT'
     &//'   RMS    WEIGHT'
C
C
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &        'M. chain bond B values: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   MAIN-CHAIN BOND REFINED ATOMS  (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST)(1:30).EQ.
     &        'M. chain bond B values: others')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   MAIN-CHAIN BOND OTHER ATOMS    (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO

      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &        'M. chain angle B values: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   MAIN-CHAIN ANGLE REFINED ATOMS (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &        'S. chain bond B values: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SIDE-CHAIN BOND REFINED ATOMS  (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &        'S. chain angle B values: refined atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SIDE-CHAIN ANGLE REFINED ATOMS (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      IF(ITEMP.GT.1) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3 ANISOTROPIC THERMAL FACTOR RESTRAINTS.    COUNT'
     &//'   RMS   WEIGHT'
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST).EQ.
     &        'Rigid bond restraints')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   RIGID-BOND RESTRAINTS          (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
C
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST)(1:22).EQ.
     &        'Sphericity. Free atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SPHERICITY; FREE ATOMS         (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      DO  IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST)(1:24).EQ.
     &        'Sphericity. Bonded atoms')THEN
      WRITE(IOUT_FILE,'(A,I6,A,F6.3,A,F6.3)')
     &'REMARK   3   SPHERICITY; BONDED ATOMS       (A**2):',
     &HRESTR_NUM(IREST),' ;',HRESTR_DEV(IREST),' ;',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDDO
      ENDIF
C
C--------------Ncs restraints
      IF(NUMBER_NCSR.LE.0) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  NCS RESTRAINTS STATISTICS'
      WRITE(IOUT_FILE,'(A,I4)')
     &'REMARK   3   NUMBER OF NCS GROUPS : NULL'
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  NCS RESTRAINTS STATISTICS'
      WRITE(IOUT_FILE,'(A,I4)')
     &'REMARK   3   NUMBER OF DIFFERENT NCS GROUPS :',NUMBER_NCSR
      DO   INCS = 1,NUMBER_NCSR
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A,I4)')
     &'REMARK   3  NCS GROUP NUMBER               :',INCS
      ALL_CHAINS = ' '
      DO   INCH=1,NCS_N_CHAIN(INCS)
        IF(LENSTR(ALL_CHAINS).GT.0) THEN
          ALL_CHAINS=ALL_CHAINS(1:LENSTR(ALL_CHAINS))
     &        //' '//NCS_CHAINS(INCH,INCS)
        ELSE
          ALL_CHAINS = ' '//NCS_CHAINS(INCH,INCS)
        ENDIF
      ENDDO
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3     CHAIN NAMES                    :'
     &//ALL_CHAINS(1:LENSTR(ALL_CHAINS))
      WRITE(IOUT_FILE,'(A,I4)')
     &'REMARK   3     NUMBER OF COMPONENTS NCS GROUP : ',NCS_SPANS(INCS)
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3       COMPONENT C  SSSEQI  TO  C   SSSEQI   CODE'
      DO ISPAN = 1,NCS_SPANS(INCS)
        DO  INCH=1,NCS_N_CHAIN(INCS)
        WRITE(IOUT_FILE,'(A,I4,5X,A,I6,7X,A,1X,I6,3X,I4)')
     &'REMARK   3        ',ISPAN,NCS_CHAINS(INCH,INCS),
     &                 NCS_IRES_FIRST(ISPAN,INCS),
     &                 NCS_CHAINS(INCH,INCS),
     &                 NCS_IRES_LAST(ISPAN,INCS),
     &                 NCS_ICODE(ISPAN,INCS)
        ENDDO
      ENDDO

      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3                   GROUP CHAIN        COUNT'
     &//'   RMS     WEIGHT'
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST)(1:30).EQ.
     &'NCS: tight positional , group ') THEN
      READ(HRESTR_TYPE(IREST),'(30X,I2)')IGRP
      IF(IGRP.EQ.INCS) THEN
      WRITE(IOUT_FILE,'(A,I6,A,F5.2,A,F5.2)')
     &'REMARK   3   TIGHT POSITIONAL  '//
     &HRESTR_TYPE(IREST)(31:32)//'   '//HRESTR_TYPE(IREST)(39:40)//
     &'    (A): ',
     &HRESTR_NUM(IREST),' ; ',HRESTR_DEV(IREST),' ; ',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDIF
      ENDDO

      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST)(1:30).EQ.
     &'NCS: medium positional, group ') THEN
      READ(HRESTR_TYPE(IREST),'(30X,I2)')IGRP
      IF(IGRP.EQ.INCS) THEN

      WRITE(IOUT_FILE,'(A,I6,A,F5.2,A,F5.2)')
     &'REMARK   3   MEDIUM POSITIONAL '//
     &HRESTR_TYPE(IREST)(31:32)//'   '//HRESTR_TYPE(IREST)(39:40)//
     &'    (A): ',
     &HRESTR_NUM(IREST),' ; ',HRESTR_DEV(IREST),' ; ',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDIF
      ENDDO

      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST)(1:30).EQ.
     &'NCS: loose positional , group ') THEN
      READ(HRESTR_TYPE(IREST),'(30X,I2)')IGRP
      IF(IGRP.EQ.INCS) THEN
      WRITE(IOUT_FILE,'(A,I6,A,F5.2,A,F5.2)')
     &'REMARK   3   LOOSE POSITIONAL  '//
     &HRESTR_TYPE(IREST)(31:32)//'   '//HRESTR_TYPE(IREST)(39:40)//
     &'    (A): ',
     &HRESTR_NUM(IREST),' ; ',HRESTR_DEV(IREST),' ; ',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDIF
      ENDDO
C
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST)(1:30).EQ.
     &'NCS: tight thermal    , group ')THEN
      READ(HRESTR_TYPE(IREST),'(30X,I2)')IGRP
      IF(IGRP.EQ.INCS) THEN
      WRITE(IOUT_FILE,'(A,I6,A,F5.2,A,F5.2)')
     &'REMARK   3   TIGHT THERMAL     '//
     &HRESTR_TYPE(IREST)(31:32)//'   '//HRESTR_TYPE(IREST)(39:40)//
     &' (A**2): ',
     &HRESTR_NUM(IREST),' ; ',HRESTR_DEV(IREST),' ; ',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDIF
      ENDDO

      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST)(1:30).EQ.
     &'NCS: medium thermal   , group ')THEN
      READ(HRESTR_TYPE(IREST),'(30X,I2)')IGRP
      IF(IGRP.EQ.INCS) THEN
      WRITE(IOUT_FILE,'(A,I6,A,F5.2,A,F5.2)')
     &'REMARK   3   MEDIUM THERMAL    '//
     &HRESTR_TYPE(IREST)(31:32)//'   '//HRESTR_TYPE(IREST)(39:40)//
     &' (A**2): ',
     &HRESTR_NUM(IREST),' ; ',HRESTR_DEV(IREST),' ; ',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDIF
      ENDDO
      DO   IREST = 1,HNRESTR
      IF(HRESTR_TYPE(IREST)(1:30).EQ.
     &'NCS: loose thermal    , group ') THEN
      READ(HRESTR_TYPE(IREST),'(30X,I2)')IGRP
      IF(IGRP.EQ.INCS) THEN
      WRITE(IOUT_FILE,'(A,I6,A,F5.2,A,F5.2)')
     &'REMARK   3   LOOSE THERMAL     '//
     &HRESTR_TYPE(IREST)(31:32)//'   '//HRESTR_TYPE(IREST)(39:40)//
     &' (A**2): ',
     &HRESTR_NUM(IREST),' ; ',HRESTR_DEV(IREST),' ; ',
     &HRESTR_DEVITAR(IREST)
      ENDIF
      ENDIF
      ENDDO
      ENDDO
      ENDIF

      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      IF(.NOT.(NTLSGRP.GT.0.AND.NTLS_CYCLE.GT.0)) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  TLS DETAILS'
      WRITE(IOUT_FILE,'(A,I4)')
     &'REMARK   3   NUMBER OF TLS GROUPS  : NULL'
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  TLS DETAILS'
      WRITE(IOUT_FILE,'(A,I4)')
     &'REMARK   3   NUMBER OF TLS GROUPS  : ',NTLSGRP
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   ATOM RECORD CONTAINS RESIDUAL B FACTORS ONLY'
      DO    ITLSGRP = 1,NTLSGRP 
        WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
        WRITE(IOUT_FILE,'(A,I5)')
     &'REMARK   3   TLS GROUP : ',ITLSGRP
        WRITE(IOUT_FILE,'(A,I4)')
     &'REMARK   3    NUMBER OF COMPONENTS GROUP : ',
     &           ITLSGRP_PIECES(ITLSGRP)
        WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    COMPONENTS        C SSSEQI   TO'
     &//'  C SSSEQI'
        DO   IPIECE = 1,ITLSGRP_PIECES(ITLSGRP)
          WRITE(IOUT_FILE,'(A,3X,A,I6,8X,A,I6)')
     &'REMARK   3    RESIDUE RANGE :',TLSGRP_CHN(IPIECE,ITLSGRP),
     &       ITLSGRP_FROM(IPIECE,ITLSGRP),
     &       TLSGRP_CHN(IPIECE,ITLSGRP),
     &       ITLSGRP_TO(IPIECE,ITLSGRP)
        ENDDO
        WRITE(IOUT_FILE,'(A,3F9.4)')
     &'REMARK   3    ORIGIN FOR THE GROUP (A):',
     &      (TLSORIGIN(I,ITLSGRP),I=1,3)
        WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    T TENSOR'
        WRITE(IOUT_FILE,'(2(A,F9.4))')
     &'REMARK   3      T11:',TMAT(1,ITLSGRP),' T22:',TMAT(2,ITLSGRP)
        WRITE(IOUT_FILE,'(2(A,F9.4))')
     &'REMARK   3      T33:',TMAT(3,ITLSGRP),' T12:',TMAT(4,ITLSGRP)
        WRITE(IOUT_FILE,'(2(A,F9.4))')
     &'REMARK   3      T13:',TMAT(5,ITLSGRP),' T23:',TMAT(6,ITLSGRP)

        WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    L TENSOR'
        WRITE(IOUT_FILE,'(2(A,F9.4))')
     &'REMARK   3      L11:',LMAT(1,ITLSGRP)*RTD2,
     &               ' L22:',LMAT(2,ITLSGRP)*RTD2
        WRITE(IOUT_FILE,'(2(A,F9.4))')
     &'REMARK   3      L33:',LMAT(3,ITLSGRP)*RTD2,
     &               ' L12:',LMAT(4,ITLSGRP)*RTD2
        WRITE(IOUT_FILE,'(2(A,F9.4))')
     &'REMARK   3      L13:',LMAT(5,ITLSGRP)*RTD2,
     &               ' L23:',LMAT(6,ITLSGRP)*RTD2

        S_TENS(1,2) = SMAT(3,ITLSGRP)*RTODEG
        S_TENS(1,3) = SMAT(4,ITLSGRP)*RTODEG
        S_TENS(2,3) = SMAT(5,ITLSGRP)*RTODEG
        S_TENS(2,1) = SMAT(6,ITLSGRP)*RTODEG
        S_TENS(3,1) = SMAT(7,ITLSGRP)*RTODEG
        S_TENS(3,2) = SMAT(8,ITLSGRP)*RTODEG
        S_TENS(3,3) = -(2.0*SMAT(2,ITLSGRP) + SMAT(1,ITLSGRP))*
     &                              RTODEG/3.0
        S_TENS(1,1) = S_TENS(3,3) + SMAT(2,ITLSGRP)*RTODEG
        S_TENS(2,2) = S_TENS(1,1) + SMAT(1,ITLSGRP)*RTODEG
        WRITE(IOUT_FILE,'(A)')
     &'REMARK   3    S TENSOR'
        WRITE(IOUT_FILE,'(3(A,F9.4))')
     &'REMARK   3      S11:',S_TENS(1,1),' S12:',S_TENS(1,2),
     & ' S13:',S_TENS(1,3)
        WRITE(IOUT_FILE,'(3(A,F9.4))')
     &'REMARK   3      S21:',S_TENS(2,1),' S22:',S_TENS(2,2),
     & ' S23:',S_TENS(2,3)
        WRITE(IOUT_FILE,'(3(A,F9.4))')
     &'REMARK   3      S31:',S_TENS(3,1),' S32:',S_TENS(3,2),
     & ' S33:',S_TENS(3,3)
        ENDDO
      ENDIF
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
C
C----Info about bulk solvent modelling
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  BULK SOLVENT MODELLING.'
      IF(NSCOPT.EQ.1.AND.SOLVENT_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   METHOD USED : BABINET MODEL WITH MASK'
      ELSEIF(NSCOPT.EQ.0.AND.SOLVENT_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   METHOD USED :  MASK'
      ELSEIF(NSCOPT.EQ.0.AND..NOT.SOLVENT_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   METHOD USED : NONE'
      ELSEIF(NSCOPT.EQ.1.AND..NOT.SOLVENT_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   METHOD USED : BABINET MODEL'
      ENDIF

      IF(SOLVENT_FLAG) THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   PARAMETERS FOR MASK CALCULATION'
      WRITE(IOUT_FILE,'(A,F6.2)')
     &'REMARK   3   VDW PROBE RADIUS   : ',PROB_VDW
      WRITE(IOUT_FILE,'(A,F6.2)')
     &'REMARK   3   ION PROBE RADIUS   : ',PROB_ION
      WRITE(IOUT_FILE,'(A,F6.2)')
     &'REMARK   3   SHRINKAGE RADIUS   : ',RADII_SHRINK
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   PARAMETERS FOR MASK CACLULATION'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   VDW PROBE RADIUS   : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   ION PROBE RADIUS   : NULL'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3   SHRINKAGE RADIUS   : NULL'
      ENDIF
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'
      IF(MAKE_HFLAG.EQ.'Y') THEN
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  OTHER REFINEMENT REMARKS:'
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  HYDROGENS HAVE BEEN ADDED IN THE RIDING POSITIONS'
      ELSE
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3  OTHER REFINEMENT REMARKS: NULL'
      ENDIF
      WRITE(IOUT_FILE,'(A)')
     &'REMARK   3'

      RETURN
      END
C
      SUBROUTINE FIND_B_OVER_COOR(B_OVER_COOR)
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'const.fh'
C
      REAL B_OVER_COOR
      INTEGER IA
C
      B_OVER_COOR = 0.0
      DO   IA = 1,N_ATOM
        IF(OCCUP(IA).GT.0) THEN
          IF(U_ANISO(2,IA).EQ.0.0) THEN
            B_OVER_COOR = B_OVER_COOR + U_ANISO(1,IA)
          ELSE
            B_OVER_COOR = B_OVER_COOR + 
     &            (U_ANISO(1,IA)+U_ANISO(2,IA)+U_ANISO(3,IA))/3.0
          ENDIF
       ENDIF
      ENDDO
      B_OVER_COOR = B_OVER_COOR/FLOAT(N_ATOM)*PISQ8
      RETURN
      END
C
      SUBROUTINE FIND_NREFINED_ATOMS(N_REFINED_ATOMS)
C
      IMPLICIT NONE
      INTEGER N_REFINED_ATOMS
      INCLUDE 'atom_com.fh'
C
      INTEGER IA,I_INTER,I_1
C
      N_REFINED_ATOMS = 0
      DO    IA=1,N_ATOM
        I_INTER = ATOM_REF_FLAG(IA)/10
        I_1 = ATOM_REF_FLAG(IA) - I_INTER*10
        IF(I_1.GT.2) THEN
          N_REFINED_ATOMS = N_REFINED_ATOMS + 1
        ENDIF
      ENDDO
      RETURN
      END
