C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C ******
C -P-
C -P------   SUBROUTINES DEPENDED ON SYSTEM --------------------
C -P-
C      CVX - for VMS VAX 
C      CDP - for unix system
C      CMS - for MS-DOS
C      CLN - for Linux 
C ******

      SUBROUTINE GET_PATH(MDOC,NAME,PATH,IERR)
C ----------------------------------------
C
C -P- GET_PATH - call getenv / get BLANC - path of blanc directory /
C
      CHARACTER NAME*(*),PATH*(*)
C ******
C ----------------------------------------
C     / setenv BLANC ~alexei/blanc /
C     CALL GET_PATH('BLANC',LINE)
C     LINE='~alexei/blanc' 
C ----------------------------------------
      CHARACTER LINE*256

cpjx Don't use temp_makefile_path.fh to set library path
cpjx      INCLUDE "temp_makecif_path.fh"
C ------------------------------------
      IERR=0

      CALL UGTENV(NAME,LINE)
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.LE.0) THEN
cpjx  MAKECIFLIB would be set in temp_makefile_path.fh
cpjx  but this is unsafe - get the path from the CLIBD_MON
cpjx  variable instead.
cpjx        PATH=MAKECIFLIB
        CALL UGTENV('CLIBD_MON',LINE)
        PATH=LINE(1:LENSTR(LINE))
      ELSE
        PATH=LINE(1:LEN)
      ENDIF

      RETURN
      END

C ******
      SUBROUTINE DISPL_BL(LINE)
C
C -P- DISPL_BL - write message to terminal and stop cursor at the end of line.
C
C             NOTE : for Linux ( CLN ) cursor will not stop
C                    at the end of line.
C
      CHARACTER LINE*(*)
      INTEGER*4 NL
C ----------------------------
      CALL LENSTR_BL(LINE,NL)
      IF(NL.GT.79) NL=79

CVX   WRITE(*,'(''$'',A)')   LINE(1:NL)
      WRITE(*,'('' '',A,$)') LINE(1:NL)
CMS   WRITE(*,'('' '',A,\)') LINE(1:NL)
CLN   WRITE(*,'('' '',A)')   LINE(1:NL)
      RETURN
      END
C ******

C ******
      SUBROUTINE CLOCK(IH)
C
C -P- CLOCK - get date to --> array IH()
C
C    IH(2),IH(3),IH(4),    IH(5),IH(6),IH(7)
C     sec   min  hour      day   month year
C
      INTEGER*4 IH(7)
C ******
      CHARACTER CID*10
c --------------------------------

      CALL UTIME(CID)

c          UTIME - Get current time hh:mm:ss          
c Input:     none
c Output:    TIME - as ASCII string
c Arguments: CHARACTER*(*) CTIME
c Usage:     CALL UTIME(CTIME)
cpjx  CID is a character string which contains the
cpjx  the date as hh:mm:ss

      READ(CID,'(I2,1X,I2,1X,I2,2X)') IH(4),IH(3),IH(2)

      CALL IDATE(IMON,IDAY,IYR)
      IF(IYR.GE.99) THEN
        IYR=IYR+1900
      ELSE
        IYR=IYR+2000
      ENDIF
      IH(5)=IDAY
      IH(6)=IMON
      IH(7)=IYR
      IH(1)=0
C
C  Dummy routine for Linux
C
CLN   IH(4)=0
CLN   IH(3)=0
CLN   IH(2)=0
CLN   IH(5)=01
CLN   IH(6)=01
CLN   IH(7)=1990
CLN   IH(1)=0

      RETURN
      END


C ===============================================================

      SUBROUTINE GETNOS(CH3)
C
C -P- GETNOS - get name of operating system
C
      CHARACTER CH3*3
C --------------------------------
CMS   CH3='MSD'      
CVX   CH3='VAX'      
      CH3='UNX'      
CLN   CH3='LIN'      
      RETURN
      END

CMS   SUBROUTINE EXIT
CMS   STOP
CMS   END

