      SUBROUTINE CREAT_VDW_REST(MDOC,NAMEO,CUTOFF,DMIN,IERR)
C -----------------------------------------------------------
      INTEGER   MDOC,IERR
      REAL      CUTOFF,DMIN
      CHARACTER NAMEO*(*)
      CHARACTER LINE*256
      CHARACTER MOD*1,HBOND*1,SPEC*1,WAT*1,TYPE1*4,TYPE2*4
C -----------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C --------
C     DMIN  = 0.5
      MOD   = 'B'
      WAT   = 'Y'
      SPEC  = 'N'
      TYPE1 = '    '
      TYPE1 = '    '
      HBOND = 'N'
      CALL CALC_CONTACT(MDOC,CUTOFF,DMIN,MOD,WAT,HBOND
     *  ,SPEC,TYPE1,TYPE2,NAMEO,IERR)
      RETURN
      END

      SUBROUTINE CALC_CONTACT(MDOC,CUT_OFF,DMIN,MOD,WAT,HBOND
     *  ,SPEC,TYPE1,TYPE2,NAMEO,IERR)
C ----------------------------------------------------------
C -P- CALC_CONTACT - 
C    CUT:   <3.5> -  distance cut_off.
C    DLIM:  <0.5> -  minimal distance to recognize atom in special position.
C                    if dist (betweem symmetry related atoms) < DLIM then 
C                    atom is in special position.
C    MOD: <S>/I/B/N: S - intra molecular contacts.
C                    I - inter molecular contacts.
C                    B - both  molecular contacts.
C                    N - generate symmetry related atoms around initial molecule
C                        and add its to output file (see alse WAT="S").
C                        if MOD="N" and WAT="S" program set WAT="Y."
C    HBOND: <N>/Y : Y - only potential H-bond contacts ( just contacts between:
C                       O - O , O - N and N - N atoms).
C    WAT: <N>/Y/S : N - without water, Y - with, S - only water structure -
C                       generate symmetry related water molecules around initial
C                       molecule and add its to output file.
C    SPEC: <N>/Y : Y - special contacts between TYPE1 and TYPE2.
C    TYPE1   < >     - type of atom_1, for example "S" means all sulfur atoms.
C    TYPE2   < >     - type of atom_2, " " means all atoms.
C -S-
C -I-
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR
      CHARACTER   NAMEO*(*),MOD*1,WAT*1,HBOND*1
      CHARACTER   SPEC*1,TYPE1*(*),TYPE2*(*)
C ----------------------------------------------------------------
      REAL      AM(3,3),TR(3),XYZ1(3),XYZ2(3)
      CHARACTER RNAME1*8,ANAME1*4,ASYMB1*4,ATYPE1*1,ALT1*1,CORR1*1
      CHARACTER RNAME2*8,ANAME2*4,ASYMB2*4,ATYPE2*1,ALT2*1,CORR2*1
      CHARACTER LINE*256,TP1*4,TP2*4,CH2*2,CH12*12,PATH*1,EXT*3
C --------------------------
      PARAMETER (IPRCNT=48)
      INTEGER   NCONT,IOSYM(IPRCNT),ITRANS(3,IPRCNT)
      REAL      XSYM(3,IPRCNT),DISTAN(IPRCNT)
      PARAMETER (IPRWAT=400)
      REAL      XWSYM(3,IPRWAT),IOS(IPRWAT)
     *         ,ITRX(IPRWAT),ITRY(IPRWAT),ITRZ(IPRWAT)
C==================================================================
      IERR  = 0
      MD    = -ABS(MDOC)-1
      M     = 99
      PI    = 4.0*ATAN(1.0)
      CONST = 8.0*PI*PI
C --------
      IUN = 0
      CALL LENSTR_BL(NAMEO,LEN)
      IF(LEN.GT.0.AND.NAMEO(1:1).NE.','.AND.NAMEO(1:1).NE.' ') THEN 
        IUN  = CRVO_IUN
        CALL WRITE_TITLE_VDW(M,IUN,NAMEO,IERR)
        IF(IERR.NE.0) THEN
          CLOSE(CRVO_IUN)
          RETURN
        ENDIF
      ENDIF
C ----------------------------------
      ITEST      = 0
      LMSG       = 0
      MSG_FLAG   = 0
      MSG_FLAG_A = 0
      IFIRST     = 0
      IF(CUT_OFF.LE.0.0) CUT_OFF = 3.5

C     IF(DMIN.LE.0.0) DMIN = 0.5

      IF(MOD.EQ.'i') MOD='I'
      IF(MOD.EQ.'s') MOD='S'
      IF(MOD.EQ.'b') MOD='B'
      IF(MOD.EQ.'n') MOD='N'
      IF(MOD.NE.'B'.AND.MOD.NE.'I'.AND.MOD.NE.'N') MOD='S'
      IF(WAT.EQ.'y') WAT='Y'
      IF(WAT.EQ.'n') WAT='N'
      IF(WAT.EQ.'s') WAT='S'
      IF(WAT.NE.'Y'.AND.WAT.NE.'S') WAT='N'
      IF(MOD.EQ.'N'.AND.WAT.EQ.'S') WAT='Y'
      IF(WAT.EQ.'S') MOD='B'
      IF(HBOND.EQ.'y') HBOND='Y'
      IF(HBOND.EQ.'n') HBOND='N'
      IF(HBOND.NE.'Y') HBOND='N'
      IF(SPEC.EQ.'y') SPEC='Y'
      IF(SPEC.EQ.'n') SPEC='N'
      IF(SPEC.NE.'Y') SPEC='N'
      TP1 = '    '
      CALL LENSTR_BL(TYPE1,LEN)
      IF(LEN.GT.0.AND.TYPE1(1:1).NE.','.AND.TYPE1(1:1).NE.' ') THEN 
        IF(LEN.GE.4) THEN
          TP1 = TYPE1(1:4)
        ELSE
          TP1(1:LEN) = TYPE1(1:LEN)
        ENDIF
      ENDIF
      IM = 1
      CALL CHECK_LINE(IM,TP1)
      TP2 = '    '
      CALL LENSTR_BL(TYPE2,LEN)
      IF(LEN.GT.0.AND.TYPE2(1:1).NE.','.AND.TYPE2(1:1).NE.' ') THEN 
        IF(LEN.GE.4) THEN
          TP2 = TYPE2(1:4)
        ELSE
          TP2(1:LEN) = TYPE2(1:LEN)
        ENDIF
      ENDIF
      IM = 1
      CALL CHECK_LINE(IM,TP2)
C --------
      IF(N_ATOM.LE.0.OR.N_GROUP.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR: number of atoms = 0.')
        IERR=1
        RETURN
      ENDIF 
      NSPEC  = 0
      NC_TOT = 0
      IA_NEW = 0
      IR_NEW = 0
      IG_NEW = N_GROUP+1

      IF(IG_NEW.GE.MAXCHAIN) THEN
        WRITE(LINE
     *  ,'('' ERROR: number of chains >'',I6)') MAXCHAIN
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     *    '        Change parameter MAXCHAIN in "atom_com.fh"')
        IERR=1
        RETURN
      ENDIF
      IRES_FIRST  (IG_NEW) = N_RESIDUE +1
      IATOM_FIRST (IG_NEW) = N_ATOM    +1
      NATM_CHAIN  (IG_NEW) = 0
      NRES_CHAIN  (IG_NEW) = 0

      NATOT  = N_ATOM
      IR_TOT = N_RESIDUE

      DLIM2 = CUT_OFF*CUT_OFF
      DMIN2 = DMIN*DMIN


      CALL DEF_CENTER_C(MDOC,IERR)


      DO I=1,N_ATOM
        XYZ1(1) = XYZ_CRD(1,I)
        XYZ1(2) = XYZ_CRD(2,I)
        XYZ1(3) = XYZ_CRD(3,I)
        CALL NB_OTOF(XYZ1,XYZ2,IERR)
        XYZ_CRD(1,I) = XYZ2(1)
        XYZ_CRD(2,I) = XYZ2(2)
        XYZ_CRD(3,I) = XYZ2(3)
      ENDDO 

      DO IG=1,N_GROUP   
        IAR       = IATOM_FIRST(IG)
        IRP       = I_RESID(IAR)
        ICH       = I_CHAIN(IRP)
        IRS       = IRES_FIRST(ICH)
        NRES      = NRES_CHAIN(ICH)
C        IF(NCS_FLAG(IG).NE.'N'.AND.NCS_FLAG(IG).NE.'n') THEN
          DO IR=IRS,IRS+NRES-1
            XYZ1(1) = CENTER_RES(1,IR)
            XYZ1(2) = CENTER_RES(2,IR)
            XYZ1(3) = CENTER_RES(3,IR)
            CALL NB_OTOF(XYZ1,XYZ2,IERR)
            CENTER_RES(1,IR) = XYZ2(1)
            CENTER_RES(2,IR) = XYZ2(2)
            CENTER_RES(3,IR) = XYZ2(3)
          ENDDO 
C        ENDIF
      ENDDO 



      CALL MSGDOC(M,                                                
     *' Iatom Atom Alt    Res  Chn    Iatom Atom Alt    Res  Chn Isym Tx
     * Ty Tz Dist') 
C ----
      DO IG1=1,N_GROUP   
                  
        IAR1       = IATOM_FIRST(IG1)
        IRP1       = I_RESID(IAR1)
        ICH1       = I_CHAIN(IRP1)
        IGRP1      = IG1
        IRS1       = IRES_FIRST(ICH1)
        NRES1      = NRES_CHAIN(ICH1)

C        IF(NCS_FLAG(IG1).NE.'N'.AND.NCS_FLAG(IG1).NE.'n') THEN

c        IRS1_TREE = IRES_START_TREE(IG1)
c        IRF1_TREE = IRES_END_TREE  (IG1)

         
        DO IR1=IRS1,IRS1+NRES1-1

          IRES1      = IRES_SERIAL (IR1)
          RNAME1     = RES_NAME    (IR1)
          NATMR1     = NATM_RES    (IR1)
          IAS1       = IRATM_FIRST (IR1)
          CH12       = RES_NUM_PDB (IR1)

C         IF(RNAME1.NE.'HOH'.AND.WAT.EQ.'S'.AND.MOD.NE.'N') GO TO 100
          IF(WAT.EQ.'S'.AND.MOD.NE.'N') THEN
            IF(RNAME1.NE.'HOH'.AND.RNAME1.NE.'DUM') GO TO 100
          ENDIF
          IF((RNAME1.EQ.'HOH'.OR.RNAME1.EQ.'DUM').AND.WAT.EQ.'N') 
     *    GO TO 100

C ---
          DO IG2=1,IG1   
            IAR2       = IATOM_FIRST(IG2)
            IRP2       = I_RESID    (IAR2)
            ICH2       = I_CHAIN    (IRP2)
            IRS2       = IRES_FIRST (ICH2)
            NRES2      = NRES_CHAIN (ICH2)
C            IF(NCS_FLAG(IG2).NE.'N'.AND.NCS_FLAG(IG2).NE.'n') THEN
              DO IR2=IRS2,IRS2+NRES2-1
                IRES2      = IRES_SERIAL(IR2)
                RNAME2     = RES_NAME(IR2)
                IF((RNAME2.EQ.'HOH'.OR.RNAME2.EQ.'DUM').AND.
     *          (WAT.EQ.'N'.OR.WAT.EQ.'S')) 
     *          GO TO 220
                IF((RNAME2.EQ.'HOH'.OR.RNAME2.EQ.'DUM').AND.MOD.EQ.'N') 
     *          GO TO 220
                CALL CHECK_CENTR_C(IR1,IR2,CUT_OFF,IOUT)
              ENDDO
 220          CONTINUE
C            ENDIF 
          ENDDO
C ---
          DO IA1=IAS1,IAS1+NATMR1-1
C
C            IATOM1     = I_ATOM   (IA1)     
C
            IATOM1     = IA1     
            ANAME1     = ATM_NAME (IA1)     
            INSF       = ID_SF(IA1)  
            ASYMB1     = CS_ATYPE (INSF)      
            ATYPE1     = ATM_TYPE (IA1)    
            ALT1       = ID_ALT   (IA1)    
            CORR1      = ID_CORR  (IA1)    
            XYZ1(1)    = XYZ_CRD  (1,IA1) 
            XYZ1(2)    = XYZ_CRD  (2,IA1)  
            XYZ1(3)    = XYZ_CRD  (3,IA1)   

C           BISO1      =  U_ANISO(1,IA1)  

            OCC1       = OCCUP    (IA1)
            IWAT       = 0 
            ISPEC_FLAG = 0
            IF(OCC1.LE.0.0) GO TO 110
            IF(ASYMB1.EQ.'H   '.OR.ASYMB1.EQ.'D   ') GO TO 110
            IF(ATYPE1.EQ.'N'.OR.ATYPE1.EQ.'D'.OR.
     *         ATYPE1.EQ.'U'.OR.ATYPE1.EQ.'M'      ) GO TO 110

            CALL CHECK_SPOS_CONT_C(XYZ1,DMIN2,ISPEC)

            IF(DMIN.GT.0.0) THEN
              IF(ISPEC.GT.1) THEN
                MULT_FACTOR(IA1)=ISPEC      
                ISPEC_FLAG  = 1
              ENDIF
            ENDIF


C ---
C           DO IG2=1,N_GROUP   
            DO IG2=1,IG1   
                  
              IAR2       = IATOM_FIRST(IG2)
              IRP2       = I_RESID(IAR2)
              ICH2       = I_CHAIN(IRP2)
              IGRP2      = IG2
              IRS2       = IRES_FIRST(ICH2)
              NRES2      = NRES_CHAIN(ICH2)

C              IF(NCS_FLAG(IG2).NE.'N'.AND.NCS_FLAG(IG2).NE.'n') THEN

              DO IR2=IRS2,IRS2+NRES2-1


                IRES2      = IRES_SERIAL(IR2)
                RNAME2     = RES_NAME(IR2)
                NATMR2     = NATM_RES(IR2)
                IAS2       = IRATM_FIRST(IR2)

                IF((RNAME2.EQ.'HOH'.OR.RNAME2.EQ.'DUM').AND.
     *          (WAT.EQ.'N'.OR.WAT.EQ.'S')) 
     *          GO TO 200

                IF((RNAME2.EQ.'HOH'.OR.RNAME2.EQ.'DUM').AND.MOD.EQ.'N') 
     *          GO TO 200

                IOUT=IFLAG_RES(IR2)
                
                IF(IOUT.EQ.0) GO TO 200

                DO IA2=IAS2,IAS2+NATMR2-1
C
C                IATOM2     = I_ATOM   (IA2)     
C

                  IATOM2     = IA2     
                  ANAME2     = ATM_NAME (IA2)     
                  INSF       = ID_SF(IA2)  
                  ASYMB2     = CS_ATYPE (INSF)      
                  ATYPE2     = ATM_TYPE (IA2)    
                  ALT2       = ID_ALT   (IA2)    
                  CORR2      = ID_CORR  (IA2)    
                  XYZ2(1)    = XYZ_CRD  (1,IA2) 
                  XYZ2(2)    = XYZ_CRD  (2,IA2)  
                  XYZ2(3)    = XYZ_CRD  (3,IA2)   

C                 BISO2      = U_ANISO(1,IA2)  

                  OCC2       = OCCUP    (IA2)

                  IF(IATOM1.LT.IATOM2) GO TO 210

C                  IF(IATOM1.LT.IATOM2.AND.IG1.EQ.IG2.AND.
C     *                                    IR1.EQ.IR2     ) GO TO 210
                  IF(OCC2.LE.0.0) GO TO 210



                  IF(ASYMB2.EQ.'H   '.OR.ASYMB2.EQ.'D   ') GO TO 210
                  IF(ATYPE2.EQ.'N'.OR.ATYPE2.EQ.'D'.OR.
     *               ATYPE2.EQ.'U'.OR.ATYPE2.EQ.'M'      ) GO TO 210

                  IFLAG=1
                  CALL CHECK_DIST_C(XYZ2,DLIM2,DMIN2,DIST2,NCONT,XSYM
     *                      ,IOSYM,ITRANS,DISTAN,IPRCNT,IFLAG)

                 
                  IF(NCONT.GT.0) THEN
                    DO IC=1,NCONT
                      IYES=0           
                      IF((IOSYM(IC).NE.1.OR.ITRANS(1,IC).NE.0.OR.
     *                  ITRANS(2,IC).NE.0.OR.ITRANS(3,IC).NE.0).AND. 
     *                  (MOD.EQ.'S'.OR.MOD.EQ.'B'.OR.MOD.EQ.'N')) THEN
C                       symm. related
                        IYES=1

                      ELSE IF((IOSYM(IC).EQ.1.AND.ITRANS(1,IC).EQ.0
     *                  .AND.ITRANS(2,IC).EQ.0.AND.ITRANS(3,IC).EQ.0) 
     *                  .AND.(IA1.GT.IA2).AND.
     *                  (MOD.EQ.'I'.OR.MOD.EQ.'B')) THEN
c                       intra chain or inter chain
C
                        IT = ABS(IR1-IR2)
                        IF(IG1.EQ.IG2.AND.
     *                    (RNAME1.EQ.'HOH'.OR.RNAME1.EQ.'DUM')) THEN
                          IT = IT + 1
                        ENDIF
C                       if(ig1.eq.ig2)         ( ig1, ir1,ir2,ia1,ia2 )
C                       check tree - if connect 1-4  it = 1      
C --
                        IF(IG1.EQ.IG2.AND.
     *                     (RNAME1.NE.'HOH'.AND.RNAME1.NE.'DUM')) THEN
                          IERR  = 0
                          ICONN = 0
                          CALL CHECK_TREE_CONN(MDOC,IA1,IA2,ICONN,IERR)


                          IF(IERR.NE.0) THEN
                            IERR = 0
                          ELSE
                            IF(ICONN.GT.0) THEN
                              IT = 0
                            ELSE
                              IT = 2
                            ENDIF
                          ENDIF
                        ENDIF
C --
                        IF((IG1.NE.IG2).OR.(IT.GT.1)) IYES=1

                      ENDIF


                      IF(IYES.EQ.1.AND.HBOND.EQ.'Y') THEN
                        IF(ASYMB1.NE.'O   '.OR.ASYMB1.NE.'N   '.OR.
     *                     ASYMB2.NE.'O   '.OR.ASYMB2.NE.'N   ') IYES=0 
                      ENDIF
                      IF(IYES.EQ.1.AND.SPEC.EQ.'Y') THEN
                        IF(TP1.NE.'    '.AND.ASYMB1.NE.TP1.AND.
     *                     ASYMB2.NE.TP1) IYES=0 
                        IF(TP2.NE.'    '.AND.ASYMB1.NE.TP2.AND.
     *                     ASYMB2.NE.TP2) IYES=0 
                      ENDIF

C                      IDENT=1
C                      IF(IOSYM(IC).NE.1.OR.ITRANS(1,IC).NE.0.OR.
C     *                  ITRANS(2,IC).NE.0.OR.ITRANS(3,IC).NE.0) 
C     *                IDENT=0
C                      IF(IDENT.EQ.1) THEN
C                        IF(ALT1.NE.'.'.AND.ALT2.NE.'.'.AND.
C     *                  ALT1.NE.ALT2) IYES=0       
C                        IDR=ABS(IR1-IR2)
C                        IF(IG1.EQ.IG2.AND.IDR.LE.1) IYES=0 
C                      ENDIF


                      IF(ISPEC_FLAG.GT.0.AND.DMIN.GT.0.000001) THEN
                        IF(IA1.EQ.IA2.AND.IG1.EQ.IG2.AND.
     *                     IR1.EQ.IR2.AND.
     *                     ITRANS(1,IC).EQ.0.AND.ITRANS(2,IC).EQ.0
     *                     .AND.ITRANS(3,IC).EQ.0) THEN     
C                         spec. position
                          IYES=0
                        ENDIF
                      ENDIF

                      IF(IYES.EQ.1) THEN 
C ---
                        IF(IUN.GT.0) THEN
                          CALL WR_RST_VDW(MDOC,IUN,ASYMB1,ASYMB2
     *                    ,IA1,ANAME1,ALT1,IR1,RNAME1,IG1
     *                    ,IA2,ANAME2,ALT2,IR2,RNAME2,IG2
     *                ,IOSYM(IC),ITRANS(1,IC),ITRANS(2,IC),ITRANS(3,IC)
     *                    ,DISTAN(IC),ITEST,IERR)
                          IF(IERR.LT.0) THEN
                            IERR=0
                            IYES=0
                            GO TO 222
                          ENDIF
                          IF(IERR.NE.0) RETURN

                          IF(DISTAN(IC).LE.2.0) THEN 
                            IF(IFIRST.EQ.0) THEN
      CALL MSGDOC(MDOC,'WARNING: small distanceis ( < 2.0 ) :')
      CALL MSGDOC(MDOC,                                                
     *' Iatom Atom Alt    Res  Chn    Iatom Atom Alt    Res  Chn Isym Tx
     * Ty Tz Dist') 
                              IFIRST=1
                              LMSG  =0
                              MMDOC =MDOC
                            ENDIF                         

                        WRITE(LINE,'(
     *                  I6,1X,A4,1X,A1,1X,I5,1X,A3,1X,I2,1X,'' - ''
     *                 ,I6,1X,A4,1X,A1,1X,I5,1X,A3,1X,I2,1X
     *                 ,I3,1X,3I3,F7.3)') 
     *                  IATOM1,ANAME1,ALT1,IRES1,RNAME1(1:3),IGRP1
     *                 ,IATOM2,ANAME2,ALT2,IRES2,RNAME2(1:3),IGRP2
     *                 ,IOSYM(IC),ITRANS(1,IC),ITRANS(2,IC),ITRANS(3,IC)
     *                 ,DISTAN(IC)
                        IF(LMSG.EQ.100) THEN
                          CALL MSGDOC(MMDOC,' ... more ...')
                          MMDOC=MD 
                        ENDIF
                        LMSG=LMSG+1
                        CALL MSGDOC(MMDOC,LINE)

                          ENDIF
                        ENDIF
C ---
                        NC_TOT=NC_TOT+1
C PRINT CHAINE

                        WRITE(LINE,'(
     *                  I6,1X,A4,1X,A1,1X,I5,1X,A3,1X,I2,1X,'' - ''
     *                 ,I6,1X,A4,1X,A1,1X,I5,1X,A3,1X,I2,1X
     *                 ,I3,1X,3I3,F7.3)') 
     *                  IATOM1,ANAME1,ALT1,IRES1,RNAME1(1:3),IGRP1
     *                 ,IATOM2,ANAME2,ALT2,IRES2,RNAME2(1:3),IGRP2
     *                 ,IOSYM(IC),ITRANS(1,IC),ITRANS(2,IC),ITRANS(3,IC)
     *                 ,DISTAN(IC)
                        CALL MSGDOC(M,LINE)

                        IF(MOD.EQ.'N') THEN
c                          IF(ANAME1.EQ.'O   '.AND.RNAME1.EQ.'HOH'.AND.
c     *                       (ALT1.EQ.'.'.OR.ALT1.EQ.' ')) THEN

                          IF(IOSYM(IC).NE.1.OR.ITRANS(1,IC).NE.0.OR.
     *                    ITRANS(2,IC).NE.0.OR.ITRANS(3,IC).NE.0) THEN 
                            IF(IWAT.LT.IPRWAT) THEN
                              IF(IWAT.GT.0) THEN
                                DO IW=1,IWAT
                                  IF(IOS(IW).EQ.IOSYM(IC).AND.
     *                            ITRX(IW).EQ.ITRANS(1,IC).AND.
     *                            ITRY(IW).EQ.ITRANS(2,IC).AND.
     *                            ITRZ(IW).EQ.ITRANS(3,IC)) GO TO 400
                                ENDDO
                              ENDIF
                              IWAT=IWAT+1
                              XWSYM(1,IWAT)=XSYM(1,IC)
                              XWSYM(2,IWAT)=XSYM(2,IC)
                              XWSYM(3,IWAT)=XSYM(3,IC)
                              IOS  (IWAT)  =IOSYM(IC)
                              ITRX (IWAT)  =ITRANS(1,IC)
                              ITRY (IWAT)  =ITRANS(2,IC)
                              ITRZ (IWAT)  =ITRANS(3,IC)
 400                          CONTINUE
                            ELSE

                              IF(MSG_FLAG.EQ.0) THEN
                                 MSG_FLAG=1
          WRITE(LINE
     *    ,'('' WARNING: number symm. atoms >'',I6)') IPRWAT
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *      '        Change parameter IPRWAT in program')

                              ENDIF


                            ENDIF
                          ENDIF

c                          ENDIF 
                        ELSE IF(WAT.EQ.'S') THEN
                          IF(ANAME1.EQ.'O   '.AND.
     *                       (RNAME1.EQ.'HOH'.OR.RNAME1.EQ.'DUM').AND.
     *                       (ALT1.EQ.'.'.OR.ALT1.EQ.' ')) THEN

                          IF(IOSYM(IC).NE.1.OR.ITRANS(1,IC).NE.0.OR.
     *                    ITRANS(2,IC).NE.0.OR.ITRANS(3,IC).NE.0) THEN 
                            IF(IWAT.LT.IPRWAT) THEN
                              IF(IWAT.GT.0) THEN
                                DO IW=1,IWAT
                                  IF(IOS(IW).EQ.IOSYM(IC).AND.
     *                            ITRX(IW).EQ.ITRANS(1,IC).AND.
     *                            ITRY(IW).EQ.ITRANS(2,IC).AND.
     *                            ITRZ(IW).EQ.ITRANS(3,IC)) GO TO 410
                                ENDDO
                              ENDIF
                              IWAT=IWAT+1
                              XWSYM(1,IWAT)=XSYM(1,IC)
                              XWSYM(2,IWAT)=XSYM(2,IC)
                              XWSYM(3,IWAT)=XSYM(3,IC)
                              IOS  (IWAT)  =IOSYM(IC)
                              ITRX (IWAT)  =ITRANS(1,IC)
                              ITRY (IWAT)  =ITRANS(2,IC)
                              ITRZ (IWAT)  =ITRANS(3,IC)
 410                          CONTINUE
                            ELSE
                              IF(MSG_FLAG.EQ.0) THEN
                                 MSG_FLAG=1
          WRITE(LINE
     *    ,'('' WARNING: number symm. atoms >'',I6)') IPRWAT
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *      '        Program stops to generate more symm. atoms')
          CALL MSGERR(MDOC,
     *      '        Change parameter IPRWAT in program')

                              ENDIF
                            ENDIF
                          ENDIF
                          ENDIF 
                        
                        ENDIF

                      ENDIF
 222                  CONTINUE
                    ENDDO
                  ELSE

                  ENDIF

 210              CONTINUE
                ENDDO
 200            CONTINUE
              ENDDO

C              ENDIF

            ENDDO
            IF(ISPEC_FLAG.GT.0) NSPEC=NSPEC+1
            IF(IWAT.GT.0) THEN
    


C              IATOM_FIRST (IG_NEW) = NATOT+1 
              I_NCS       (IG_NEW) = 0
              MULT_FLAG   (IG_NEW) = 1
              NCS_FLAG    (IG_NEW) = '.'
              GROUP_ID    (IG_NEW) = '*.. '
C              IRES_FIRST  (IG_NEW) = N_RESIDUE+1
              ICHAIN_GRP  (IG_NEW) = IG_NEW
              ITERM_S_TYPE(IG_NEW) = 0
              ITERM_F_TYPE(IG_NEW) = 0
              ICH_TYPE    (IG_NEW) = 0

              DO I=1,IWAT

                IF(NATOT.GE.MAXATOM) THEN
                  IF(MSG_FLAG_A.EQ.0) THEN
                    MSG_FLAG_A=1
        WRITE(LINE
     *  ,'('' WARNING: number of atoms  >'',I6)') MAXATOM
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     *      '        Program stops to generate new atoms')
        CALL MSGERR(MDOC,
     *      '        Change parameter MAXATOM in "atom_com.fh"')

                  ENDIF 
                  GO TO 300
                ENDIF

                IF(IR_TOT.GE.MAXRESID) THEN
                  IF(MSG_FLAG_A.EQ.0) THEN
                    MSG_FLAG_A=1
        WRITE(LINE
     *  ,'('' WARNING: number of residues  >'',I6)') MAXRESID
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     *      '        Program stops to generate new atoms')
        CALL MSGERR(MDOC,
     *      '        Change parameter MAXRESID in "atom_com.fh"')

                  ENDIF 
                  GO TO 300
                ENDIF

                IA_NEW = IA_NEW + 1
                IR_NEW = IR_NEW + 1
                IR_TOT = IR_TOT + 1
                NATOT  = NATOT  + 1

                NRES_CHAIN  (IG_NEW) = IR_NEW
                NATM_CHAIN  (IG_NEW) = IA_NEW

                IRES_SERIAL(IR_TOT)  = IR_NEW
                RES_NAME   (IR_TOT)  = RNAME1
                NATM_RES   (IR_TOT)  = 1
                IRATM_FIRST(IR_TOT)  = NATOT
                I_CHAIN    (IR_TOT)  = IG_NEW
                IRES_TYPE  (IR_TOT)  = 0
                ICONN_TYPE (IR_TOT)  = 0
                CH2(2:2)='*'
                IF(IG_NEW.LT.100.AND.IG_NEW.GT.0) 
     *          WRITE(CH2,'(I2)') IG_NEW
                CH2(1:1)='*'
C               RES_NUM_PDB(IR_TOT)  = CH2//'     '
                RES_NUM_PDB(IR_TOT)  = CH2//CH12(3:12)
                MOD_FLAG   (IR_TOT)  = '.'
                LINK_FLAG  (IR_TOT)  = '.'

C               I_ATOM   (NATOT)  = NATOT

                I_ATOLD  (NATOT)  = NATOT
                I_RESID  (NATOT)  = IR_TOT 
                ATM_NAME (NATOT)  = ANAME1
                ATM_NAME_INP(NATOT)  = ANAME1
                ATM_CHEM (NATOT)  = '.'
                ATM_TYPE (NATOT)  = ATYPE1
                ID_ALT   (NATOT)  = ALT1
                ID_CORR  (NATOT)  = CORR1 
                XYZ_CRD  (1,NATOT)= XWSYM(1,I)
                XYZ_CRD  (2,NATOT)= XWSYM(2,I)
                XYZ_CRD  (3,NATOT)= XWSYM(3,I)

c               B_ISO    (NATOT)  = BISO1
C               U_ANISO(1,NATOT)  = BISO1
                U_ANISO(1,NATOT)  = U_ANISO(1,IA1)  

                OCCUP    (NATOT)  = OCC1
C               OCCUP    (NATOT)  = 0.0
                B_FLAG   (NATOT)  = 0
                ID_SF    (NATOT)  = ID_SF(IA1)
                MULT_FACTOR(NATOT)= 0
 300            CONTINUE
              ENDDO
            ENDIF
 110        CONTINUE
          ENDDO
 100      CONTINUE
        ENDDO

C        ENDIF

      ENDDO
      CALL MSGDOC(MDOC,' ------------')
      WRITE(LINE,'('' Number of contacts        :'',I8)') NC_TOT
      CALL MSGDOC(M,LINE)
      IF(LMSG.GT.100) THEN
        WRITE(LINE,'('' Number of contacts (< 2.0):'',I8)') LMSG
        CALL MSGDOC(MDOC,LINE)
      ENDIF

      IF(NSPEC.GT.0) THEN
        WRITE(LINE,'(''   Atoms in special positions:'',I8)') NSPEC
        CALL MSGDOC(M,LINE)
      ENDIF

      IF(IA_NEW.GT.0) THEN
        WRITE(LINE,'('' Number of new atoms :'',I8)') IA_NEW
        CALL MSGDOC(M,LINE)
        N_GROUP   = IG_NEW
        N_ATOM    = NATOT
        N_RESIDUE = IR_TOT
      ENDIF

      DO I=1,N_ATOM
        XYZ1(1)=XYZ_CRD(1,I)
        XYZ1(2)=XYZ_CRD(2,I)
        XYZ1(3)=XYZ_CRD(3,I)
        CALL NB_FTOO(XYZ1,XYZ2,IERR)
        XYZ_CRD(1,I)=XYZ2(1)
        XYZ_CRD(2,I)=XYZ2(2)
        XYZ_CRD(3,I)=XYZ2(3)
      ENDDO 

      DO IG=1,N_GROUP   
        IAR       = IATOM_FIRST(IG)
        IRP       = I_RESID(IAR)
        ICH       = I_CHAIN(IRP)
        IRS       = IRES_FIRST(ICH)
        NRES      = NRES_CHAIN(ICH)
        IF(NCS_FLAG(IG).NE.'N'.AND.NCS_FLAG(IG).NE.'n') THEN
          DO IR=IRS,IRS+NRES-1
            XYZ1(1)=CENTER_RES(1,IR)
            XYZ1(2)=CENTER_RES(2,IR)
            XYZ1(3)=CENTER_RES(3,IR)
            CALL NB_FTOO(XYZ1,XYZ2,IERR)
            CENTER_RES(1,IR)=XYZ2(1)
            CENTER_RES(2,IR)=XYZ2(2)
            CENTER_RES(3,IR)=XYZ2(3)
          ENDDO 
        ENDIF
      ENDDO 

      IF(IUN.GT.0) THEN
        END FILE CRVO_IUN
        CLOSE(CRVO_IUN)
      ENDIF

      RETURN
      END

      SUBROUTINE CHECK_TREE_CONN(MDOC,IA1,IA2,ICONN,IERR)
C -----------------------------------
C -----------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'crd_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,ICONN,IA1,IA2
C -----------------------------------
      IERR  = 0
      ICONN = 1
C ---
      IBA1  = IATM_BACK  (IA1)
      IFA1  = IATM_FOR   (IA1)
      IEA1  = IATM_EXTR  (IA1)
      IE2A1 = IATM_EXTR2 (IA1)

      IBA2  = IATM_BACK  (IA2)
      IFA2  = IATM_FOR   (IA2)
      IEA2  = IATM_EXTR  (IA2)
      IE2A2 = IATM_EXTR2 (IA2)
C
C      1 <--> 2        1 <...> 2
C
      IF(IBA1.EQ.IA2.OR.IBA2 .EQ.IA1) RETURN
      IF(IEA1.EQ.IA2.OR.IE2A1.EQ.IA2.OR.
     *   IEA2.EQ.IA1.OR.IE2A2.EQ.IA1    ) RETURN


C
C      1 ---> * ---> 2      1 ...> * ---> 2        1 <...> * <...> 2
C      1 <--- * <--- 2      1<---- * <... 2
C      1 <--- * ---> 2      1 ...> * <--- 2
C                           1 ---> * <... 2

      IBBA1 = 0
      IBBA2 = 0
      IF(IBA1.GT.0) IBBA1 = IATM_BACK(IBA1)
      IF(IBA2.GT.0) IBBA2 = IATM_BACK(IBA2)

      IF(IBBA1.EQ.IA2 .OR .IBBA2.EQ.IA1) RETURN
      IF(IBA1 .EQ.IBA2.AND.IBA2 .GT.0  ) RETURN

      IF((IEA1 .EQ.IBA2.OR.IE2A1.EQ.IBA2).AND.IBA2.GT.0) RETURN
      IF((IEA2 .EQ.IBA1.OR.IE2A2.EQ.IBA1).AND.IBA1.GT.0) RETURN

      IF(IEA1.GT.0) THEN
        IBEA1 = IATM_BACK(IEA1)
        IF(IBEA1 .EQ.IA2) RETURN
      ENDIF
      IF(IE2A1.GT.0) THEN
        IBE2A1 = IATM_BACK(IE2A1)
        IF(IBE2A1 .EQ.IA2) RETURN
      ENDIF

      IF(IEA2.GT.0) THEN
        IBEA2 = IATM_BACK(IEA2)
        IF(IBEA2 .EQ.IA1) RETURN
      ENDIF
      IF(IE2A2.GT.0) THEN
        IBE2A2 = IATM_BACK(IE2A2)
        IF(IBE2A2 .EQ.IA1) RETURN
      ENDIF
      IF((IEA1 .EQ.IEA2.OR.IEA1 .EQ.IE2A2).AND.IEA1 .GT.0) RETURN
      IF((IE2A1.EQ.IEA2.OR.IE2A1.EQ.IE2A2).AND.IE2A1.GT.0) RETURN
C ---
      IF(IBA1.GT.0) THEN
        IBBA1  = IATM_BACK  (IBA1)
        IBEA1  = IATM_EXTR  (IBA1)
        IBE2A1 = IATM_EXTR2 (IBA1)
        IF(IBA2.GT.0) THEN
C         IBA1 --> IBA2      IBA1 <-- IBA2     IBA1 .... IBA2
          IBBA2 = IATM_BACK(IBA2)
          IF(IBBA1.EQ.IBA2.OR.IBBA2.EQ.IBA1) RETURN
          IBEA2  = IATM_EXTR  (IBA2)
          IBE2A2 = IATM_EXTR2 (IBA2)
          IF(IBEA1.EQ.IBA2.OR.IBE2A1.EQ.IBA2) RETURN
          IF(IBEA2.EQ.IBA1.OR.IBE2A2.EQ.IBA1) RETURN
        ENDIF           
        IF(IFA2.GT.0) THEN
C         IBA1 --> IFA2      IBA1 <-- IFA2     IBA1 .... IFA2
          IBFA2 = IATM_BACK(IFA2)
          IF(IBBA1.EQ.IFA2.OR.IBFA2.EQ.IBA1) RETURN
          IFEA2  = IATM_EXTR  (IFA2)
          IFE2A2 = IATM_EXTR2 (IFA2)
          IF(IBEA1.EQ.IFA2.OR.IBE2A1.EQ.IFA2) RETURN
          IF(IFEA2.EQ.IBA1.OR.IFE2A2.EQ.IBA1) RETURN       
        ENDIF
        IF(IEA2.GT.0) THEN
C         IBA1 --> IEA2      IBA1 <-- IEA2 
          IBEA2 = IATM_BACK(IEA2)
          IF(IBBA1.EQ.IEA2.OR.IBEA2.EQ.IBA1) RETURN
          IF(IE2A2.GT.0) THEN
C           IBA1 --> IE2A2      IBA1 <-- IE2A2 
            IBE2A2 = IATM_BACK(IE2A2)
            IF(IBBA1.EQ.IE2A2.OR.IBE2A2.EQ.IBA1) RETURN
          ENDIF
        ENDIF
      ENDIF
C ---
      IF(IBA2.GT.0) THEN
        IBBA2  = IATM_BACK  (IBA2)
        IBEA2  = IATM_EXTR  (IBA2)
        IBE2A2 = IATM_EXTR2 (IBA2)
        IF(IFA1.GT.0) THEN
C         IFA1 --> IBA2      IFA1 <-- IBA2     IFA1 .... IBA2
          IBFA1 = IATM_BACK(IFA1)
          IF(IBBA2.EQ.IFA1.OR.IBFA1.EQ.IBA2) RETURN
          IFEA1  = IATM_EXTR  (IFA1)
          IFE2A1 = IATM_EXTR2 (IFA1)
          IF(IBEA2.EQ.IFA1.OR.IBE2A2.EQ.IFA1) RETURN
          IF(IFEA1.EQ.IBA2.OR.IFE2A1.EQ.IBA2) RETURN              
        ENDIF
        IF(IEA1.GT.0) THEN
C         IEA1 --> IBA2      IEA1 <-- IBA2 
          IBEA1 = IATM_BACK(IEA1)
          IF(IBBA2.EQ.IEA1.OR.IBEA1.EQ.IBA2) RETURN
          IF(IE2A1.GT.0) THEN
C           IE2A1 --> IBA2      IE2A1 <-- IBA2 
            IBE2A1 = IATM_BACK(IE2A1)
            IF(IBBA2.EQ.IE2A1.OR.IBE2A1.EQ.IBA2) RETURN
          ENDIF
        ENDIF
      ENDIF
C ---
      IF(IFA1.GT.0) THEN
        IBFA1  = IATM_BACK  (IFA1)
        IFEA1  = IATM_EXTR  (IFA1)
        IFE2A1 = IATM_EXTR2 (IFA1)
        IF(IFA2.GT.0) THEN
C         IFA1 --> IFA2      IFA1 <-- IFA2     IFA1 .... IFA2
          IBFA2 = IATM_BACK(IFA2)
          IF(IBFA2.EQ.IFA1.OR.IBFA1.EQ.IFA2) RETURN
          IFEA2  = IATM_EXTR  (IFA2)
          IFE2A2 = IATM_EXTR2 (IFA2)
          IF(IFEA2.EQ.IFA1.OR.IFE2A2.EQ.IFA1) RETURN
          IF(IFEA1.EQ.IFA2.OR.IFE2A1.EQ.IFA2) RETURN              
        ENDIF
        IF(IEA2.GT.0) THEN
C         IFA1 --> IEA2      IFA1 <-- IEA2 
          IBEA2 = IATM_BACK(IEA2)
          IF(IBEA2.EQ.IFA1.OR.IBFA1.EQ.IEA2) RETURN
          IF(IE2A2.GT.0) THEN
C           IFA1 --> IE2A2      IFA1 <-- IE2A2 
            IBE2A2 = IATM_BACK(IE2A2)
            IF(IBFA1.EQ.IE2A2.OR.IBE2A2.EQ.IFA1) RETURN
          ENDIF
        ENDIF
      ENDIF
C ---
      IF(IFA2.GT.0) THEN
        IBFA2  = IATM_BACK  (IFA2)
        IFEA2  = IATM_EXTR  (IFA2)
        IFE2A2 = IATM_EXTR2 (IFA2)
        IF(IEA1.GT.0) THEN
C         IEA1 --> IFA2      IEA1 <-- IFA2 
          IBEA1 = IATM_BACK(IEA1)
          IF(IBEA1.EQ.IFA2.OR.IBFA2.EQ.IEA1) RETURN
          IF(IE2A1.GT.0) THEN
C           IE2A1 --> IFA2      IE2A1 <-- IFA2 
            IBE2A1 = IATM_BACK(IE2A1)
            IF(IBFA2.EQ.IE2A1.OR.IBE2A1.EQ.IFA2) RETURN
          ENDIF
        ENDIF
      ENDIF
C ---
      IF(IEA1.GT.0) THEN
        IBEA1  = IATM_BACK(IEA1)
        IF(IEA2.GT.0) THEN
C         IEA1 --> IEA2      IEA1 <-- IEA2 
          IBEA2  = IATM_BACK(IEA2)
          IF(IBEA2.EQ.IEA1.OR.IBEA1.EQ.IEA2) RETURN
          IF(IE2A2.GT.0) THEN
C           IEA1 --> IE2A2      IEA1 <-- IE2A2 
            IBE2A2  = IATM_BACK(IE2A2)
            IF(IBE2A2.EQ.IEA1.OR.IBEA1.EQ.IE2A2) RETURN
          ENDIF
        ENDIF
        IF(IE2A1.GT.0) THEN
          IBE2A1  = IATM_BACK(IE2A1)
          IF(IEA2.GT.0) THEN
C           IE2A1 --> IEA2      IE2A1 <-- IEA2 
            IBEA2  = IATM_BACK(IEA2)
            IF(IBEA2.EQ.IE2A1.OR.IBE2A1.EQ.IEA2) RETURN
            IF(IE2A2.GT.0) THEN
C             IE2A1 --> IE2A2      IE2A1 <-- IE2A2 
              IBE2A2  = IATM_BACK(IE2A2)
              IF(IBE2A2.EQ.IE2A1.OR.IBE2A1.EQ.IE2A2) RETURN
            ENDIF
          ENDIF
        ENDIF
      ENDIF        
C ---
      ICONN = 0
      RETURN
      END

      SUBROUTINE CHECK_DIST_C(XX,DLIM2,DMIN2,DIST2,NCONT,XSYM,IOSYM
     *                 ,ITRANS,DISTAN,IPRCNT,IFLAG)
C -----------------------------------
      INCLUDE 'atom_com.fh'
C -----------------------------------
      INTEGER   NCONT,IOSYM(IPRCNT),ITRANS(3,IPRCNT),IFLAG
      REAL      XSYM(3,IPRCNT),DISTAN(IPRCNT)
      REAL      XX(3)
C ---
      COMMON/COM_ATM_OLD/ NA_OLD,XOLD,ISYM_OLD
      REAL      XOLD(3,96)
      INTEGER   NA_OLD,ISYM_OLD(96)
C ---
      REAL      ZZ(3)
C --------------------------------------------------------------------
C     XX - test , YY --> Z - change   

      NCONT=0

      DO I=1,NA_OLD

        ZZ(1) = XOLD(1,I)
        ZZ(2) = XOLD(2,I)
        ZZ(3) = XOLD(3,I)
        
        CALL  CALC_DIST_C(ZZ,XX,DIST2,ITX,ITY,ITZ)

        IF(IFLAG.EQ.0) GO TO 100

        IF(DIST2.LT.DMIN2) THEN

        ELSE IF(DIST2.LE.DLIM2) THEN

          IF(NCONT.LT.IPRCNT) THEN
            NCONT=NCONT+1
            ITRANS(1,NCONT)=ITX    
            ITRANS(2,NCONT)=ITY
            ITRANS(3,NCONT)=ITZ    
            IOSYM(NCONT)=ISYM_OLD(I) 
            ZZ(1)=ZZ(1)+ITX
            ZZ(2)=ZZ(2)+ITY
            ZZ(3)=ZZ(3)+ITZ
            XSYM(1,NCONT)=ZZ(1)
            XSYM(2,NCONT)=ZZ(2)
            XSYM(3,NCONT)=ZZ(3)
            DISTAN(NCONT)= SQRT(DIST2)
          ENDIF
        ENDIF

 100    CONTINUE

      ENDDO

      RETURN
      END


      SUBROUTINE CHECK_SPOS_CONT_C(X,DMIN2,ISPEC)
C -----------------------------------
      INCLUDE 'atom_com.fh'
C -----------------------------------
      INTEGER   ISPEC
      REAL      X(3),DMIN2
C ---
      COMMON/COM_ATM_OLD/ NA_OLD,XOLD,ISYM_OLD
      REAL      XOLD(3,96)
      INTEGER   NA_OLD,ISYM_OLD(96)
C ---
      REAL      ZZ(3)
C --------------------------------------------------------------------
      ISPEC       = 1
      NA_OLD      = 1
      XOLD(1,1)   = X(1)
      XOLD(2,1)   = X(2)
      XOLD(3,1)   = X(3)
      ISYM_OLD(1) = 1
      IF(CS_NSYM.LE.1) RETURN

      DO     I=2,CS_NSYM

        ZZ(1)= CS_M_CS(1,1,I)*X(1) + CS_M_CS(1,2,I)*X(2) + 
     *         CS_M_CS(1,3,I)*X(3) + CS_V_CS(1,I)
        ZZ(2)= CS_M_CS(2,1,I)*X(1) + CS_M_CS(2,2,I)*X(2) +
     *         CS_M_CS(2,3,I)*X(3) + CS_V_CS(2,I)
        ZZ(3)= CS_M_CS(3,1,I)*X(1) + CS_M_CS(3,2,I)*X(2) +
     *         CS_M_CS(3,3,I)*X(3) + CS_V_CS(3,I)

        DO J=1,NA_OLD
          CALL  CALC_DIST_C(ZZ,XOLD(1,J),D2,ITX,ITY,ITZ)
          IF(D2.LT.DMIN2) GO TO 100
        ENDDO

        NA_OLD           = NA_OLD+1
        XOLD(1,NA_OLD)   = ZZ(1)
        XOLD(2,NA_OLD)   = ZZ(2)
        XOLD(3,NA_OLD)   = ZZ(3)
        ISYM_OLD(NA_OLD) = I

 100    CONTINUE

      ENDDO

      ISPEC = CS_NSYM/NA_OLD

      RETURN
      END


      SUBROUTINE CALC_DIST_C(ZZ,XX,D2,ITX,ITY,ITZ)
      REAL      XX(3),ZZ(3),WW(3),W(3)

        WW(1) = ZZ(1)-XX(1)
        WW(2) = ZZ(2)-XX(2)
        WW(3) = ZZ(3)-XX(3)

        ITZ = 0
31      IF(WW(3).LT.0.0) THEN
          WW(3) = WW(3)+1.0
          ITZ   = ITZ+1
          GO TO 31
        ENDIF

32      IF(WW(3).GE.0.5) THEN
          WW(3) = WW(3)-1.0                                             
          ITZ   = ITZ-1
          GO TO 32
        ENDIF

        ITX = 0
11      IF(WW(1).LT.0.0) THEN
          WW(1) = WW(1)+1.0
          ITX   = ITX+1
          GO TO 11
        ENDIF
12      IF(WW(1).GE.0.5) THEN
          WW(1) = WW(1)-1.0
          ITX   = ITX-1
          GO TO 12
        ENDIF

        ITY=0
21      IF(WW(2).LT.0.0) THEN
          WW(2) = WW(2)+1.0
          ITY   = ITY+1
          GO TO 21
        ENDIF
22      IF(WW(2).GE.0.5) THEN
          WW(2) = WW(2)-1.0
          ITY   = ITY-1
          GO TO 22
        ENDIF

        CALL NB_FTOO(WW,W,IERR)

        D2 = W(1)*W(1)+W(2)*W(2)+W(3)*W(3)

      RETURN
      END

      SUBROUTINE DEF_CENTER_C(MDOC,IERR)
C --------------------------------------------
      INCLUDE 'atom_com.fh'
C ----------------------------------------------------------------
      REAL      X(3),C(3)
      CHARACTER RNAME*3,ANAME*4,ASYMB*4,ATYPE*1,ALT*1,CORR*1
      CHARACTER LINE*256,CH12*12
C --------------------------
      IF(N_ATOM.LE.0.OR.N_GROUP.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR: number of atoms = 0...')
        IERR=1
        RETURN
      ENDIF 

      DO IG=1,N_GROUP   
                  
        IAR       = IATOM_FIRST(IG)
        IRP       = I_RESID(IAR)
        ICH       = I_CHAIN(IRP)
        IGRP      = IG
        IRS       = IRES_FIRST(ICH)
        NRES      = NRES_CHAIN(ICH)

        IF(NCS_FLAG(IG).EQ.'N'.OR.NCS_FLAG(IG).EQ.'n') GO TO 100

        DO IR=IRS,IRS+NRES-1

          IRES      = IRES_SERIAL(IR)
          RNAME     = RES_NAME(IR)
          NATMR     = NATM_RES(IR)
          IAS       = IRATM_FIRST(IR)
          CH12      = RES_NUM_PDB(IR)

          IF(NATMR.LE.1) THEN

            CENTER_RES(1,IR)    = XYZ_CRD  (1,IAS) 
            CENTER_RES(2,IR)    = XYZ_CRD  (2,IAS)  
            CENTER_RES(3,IR)    = XYZ_CRD  (3,IAS)   
            RADIUS_RES(IR)      = 0.0
            IFLAG_RES (IR)      = 0

          ELSE

            XMAX =-1.E 30
            YMAX =-1.E 30
            ZMAX =-1.E 30
            XMIN = 1.E 30
            YMIN = 1.E 30
            ZMIN = 1.E 30
            DO IA=IAS,IAS+NATMR-1
C
C              IATOM     = I_ATOM   (IA)     
C
              IATOM     = IA     
              ANAME     = ATM_NAME (IA)     
              INSF      = ID_SF(IA)  
              ASYMB     = CS_ATYPE (INSF)      
              ATYPE     = ATM_TYPE (IA)    
              ALT       = ID_ALT   (IA)    
              CORR      = ID_CORR  (IA)    
              X(1)      = XYZ_CRD  (1,IA) 
              X(2)      = XYZ_CRD  (2,IA)  
              X(3)      = XYZ_CRD  (3,IA)   
C             BISO      = B_ISO    (IA)  
C             BISO      = U_ANISO(1,IA)  
              OCC       = OCCUP    (IA)
              IF(OCC  .LE.0.0                            ) GO TO 110
              IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') GO TO 110
              IF(ATYPE.EQ.'N'.OR.ATYPE.EQ.'D'.OR.
     *           ATYPE.EQ.'M'.OR.ATYPE.EQ.'U'            ) GO TO 110

              IF(X(1).GT.XMAX) XMAX = X(1)
              IF(X(2).GT.YMAX) YMAX = X(2)
              IF(X(3).GT.ZMAX) ZMAX = X(3)
              IF(X(1).LT.XMIN) XMIN = X(1)
              IF(X(2).LT.YMIN) YMIN = X(2)
              IF(X(3).LT.ZMIN) ZMIN = X(3)

 110          CONTINUE
            ENDDO

            C(1)    = (XMAX+XMIN)/2.0  
            C(2)    = (YMAX+YMIN)/2.0
            C(3)    = (ZMAX+ZMIN)/2.0

            RAD = 0.0
            DO IA=IAS,IAS+NATMR-1
C
C             IATOM     = I_ATOM   (IA)     
C
              IATOM     = IA     
              ANAME     = ATM_NAME (IA)     
              INSF      = ID_SF    (IA)  
              ASYMB     = CS_ATYPE (INSF)      
              ATYPE     = ATM_TYPE (IA)    
              ALT       = ID_ALT   (IA)    
              CORR      = ID_CORR  (IA)    
              X(1)      = XYZ_CRD  (1,IA) 
              X(2)      = XYZ_CRD  (2,IA)  
              X(3)      = XYZ_CRD  (3,IA)   
C             BISO      = U_ANISO(1,IA)  
C             BISO      = B_ISO    (IA)  
              OCC       = OCCUP    (IA)
              IF(OCC.LE.0.0                              ) GO TO 120
              IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') GO TO 120
              IF(ATYPE.EQ.'N'.OR.ATYPE.EQ.'D'.OR.
     *           ATYPE.EQ.'M'.OR.ATYPE.EQ.'U'            ) GO TO 120

              T1 = X(1)-C(1)
              T2 = X(2)-C(2)
              T3 = X(3)-C(3)
              R  = SQRT(T1*T1+T2*T2+T3*T3)
              IF(R.GT.RAD) RAD = R

 120          CONTINUE

            ENDDO

            CENTER_RES(1,IR)    = C(1)
            CENTER_RES(2,IR)    = C(2)
            CENTER_RES(3,IR)    = C(3)
            RADIUS_RES(IR)      = RAD
            IFLAG_RES (IR)      = 0

          ENDIF
        ENDDO
 100    CONTINUE
      ENDDO
      RETURN
      END

      SUBROUTINE CHECK_CENTR_C(IR1,IR2,DLIM,IOUT)
C --------------------------------------------
      INCLUDE 'atom_com.fh'
C ----------------------------------------------------------------
      REAL      X1(3),X2(3),Z(3),R1,R2
C --------------------------
      IF(RADIUS_RES(IR2).LE.0.0) THEN  
        IFLAG_RES (IR2)=-1
        RETURN
      ENDIF
      X1(1) = CENTER_RES(1,IR1)  
      X1(2) = CENTER_RES(2,IR1)   
      X1(3) = CENTER_RES(3,IR1)  
      R1    = RADIUS_RES(IR1)     
      X2(1) = CENTER_RES(1,IR2)  
      X2(2) = CENTER_RES(2,IR2)   
      X2(3) = CENTER_RES(3,IR2)  
      R2    = RADIUS_RES(IR2)     
      D     = R1 + R2 + DLIM + .00001
      D2    = D*D
C ---
      IOUT = 1
      DO     I=1,CS_NSYM
          Z(1)= CS_M_CS(1,1,I)*X2(1) + CS_M_CS(1,2,I)*X2(2) + 
     *          CS_M_CS(1,3,I)*X2(3) + CS_V_CS(1,I)
          Z(2)= CS_M_CS(2,1,I)*X2(1) + CS_M_CS(2,2,I)*X2(2) +
     *          CS_M_CS(2,3,I)*X2(3) + CS_V_CS(2,I)
          Z(3)= CS_M_CS(3,1,I)*X2(1) + CS_M_CS(3,2,I)*X2(2) +
     *          CS_M_CS(3,3,I)*X2(3) + CS_V_CS(3,I)
        
        CALL  CALC_DIST_C(X1,Z,DIST2,ITX,ITY,ITZ)

        IF(DIST2.LE.D2) GO TO 100

      ENDDO
      IOUT = 0
 100  CONTINUE
      IFLAG_RES(IR2) = IOUT
      RETURN
      END

      SUBROUTINE WR_RST_VDW(MDOC,IOUT,ASYMB1,ASYMB2
     *                 ,IATOM1,ANAME1,ALT1,IR1,RNAME1,IGRP1
     *                 ,IATOM2,ANAME2,ALT2,IR2,RNAME2,IGRP2
     *                 ,IOSYM,ITRX,ITRY,ITRZ
     *                 ,DIST,ITEST,IERR)
C ----------------------------------------------------
      INCLUDE 'atom_com.fh'
C ////
      INCLUDE 'lib_com.fh'
c      INCLUDE 'ener_com.fh'
C ////
C ----------------------------------------------------
      REAL      RIDL,ROBS,ECONST
      INTEGER*4 MDOC,IERR,IA1,IA2,IA3
      CHARACTER NAME*4
      CHARACTER TYPE*1,HFLAG*1,SYMM*8
      CHARACTER ALT1*1,ALT2*1,CH1*4,CH2*4,ASYMB1*4,ASYMB2*4
      CHARACTER ANAME1*4,ANAME2*4,RNAME1*8,RNAME2*8
      CHARACTER CHAR3*3,CHART*3,LINK*8,ATM1*4,ATM2*4
      CHARACTER LINE*256
C ----------------------------------------------------
      IERR=0
C ---
C ////
C     check link
      IRES1      = IRES_SERIAL(IR1)
      IRES2      = IRES_SERIAL(IR2)
      IF(LN_N.GT.0) THEN      
        DO I=1,LN_N
          I1   = LN_1ICHN(I)
          I2   = LN_2ICHN(I)
          LINK = LN_ID(I)
          IRL1 = LN_1IRES(I)
          IRL2 = LN_2IRES(I)
          IF((I1.EQ.IGRP1.AND.I2.EQ.IGRP2).OR.
     *       (I2.EQ.IGRP1.AND.I1.EQ.IGRP2)) THEN
          IF((IRL1.EQ.IR1.AND.IRL2.EQ.IR2).OR.
     *       (IRL2.EQ.IR1.AND.IRL1.EQ.IR2)) THEN

            IF(LLL_NLINK.LE.0) THEN
              CALL MSGERR(MDOC,
     *        ' WARNING: number of links in library = 0')
              IERR=0
              GO TO 620
            ENDIF
            DO   L=1,LLL_NLINK
              IF(LINK.EQ.LLL_LNAME(L)) THEN
                LLL_ILINK = L
                GO TO 600
              ENDIF
            ENDDO  
            WRITE(LINE
     *      ,'('' WARNING: link '',A8,'' not found in library.'')')
     *      LINK
            CALL MSGERR(MDOC,LINE)
            IERR = 0
            GO TO 620
  600       CONTINUE
            L  = LLL_ILINK
            LB = LLL_IBOND(L)
            LG = LLL_ITHET(L)
            IF(LB.GT.0) THEN
              DO  IB=LB,LLB_NBOND
                IF(LINK.EQ.LLB_LNAME(IB)) THEN
                  ATM1   = LLB_1ATM (IB)   
                  IFLAG1 = LLB_F1ATM(IB)
                  ATM2   = LLB_2ATM (IB)
                  IFLAG2 = LLB_F2ATM(IB)
                  IF((ATM1.EQ.ANAME1.AND.ATM2.EQ.ANAME2).OR.
     *               (ATM2.EQ.ANAME1.AND.ATM1.EQ.ANAME2)) GO TO 100
                ENDIF
              ENDDO
            ENDIF
            IF(LG.GT.0) THEN
              DO  IG=LG,LLG_NANGL
                IF(LINK.EQ.LLG_LNAME(IG)) THEN
                  ATM1   = LLG_1ATM (IG)   
                  IFLAG1 = LLG_F1ATM(IG)
                  ATM2   = LLG_3ATM (IG)
                  IFLAG2 = LLG_F3ATM(IG)
                  IF((ATM1.EQ.ANAME1.AND.ATM2.EQ.ANAME2).OR.
     *               (ATM2.EQ.ANAME1.AND.ATM1.EQ.ANAME2)) GO TO 100
                ENDIF
              ENDDO
            ENDIF
          ENDIF
          ENDIF
 620      CONTINUE
        ENDDO
      ENDIF
C ////
C ---
      CH1  = GROUP_ID(IGRP1)
      CH2  = GROUP_ID(IGRP2)
      ROBS = DIST
    
      IT = ITRX+5
      WRITE(CHART(1:1),'(I1)') IT
      IT = ITRY+5
      WRITE(CHART(2:2),'(I1)') IT
      IT = ITRZ+5
      WRITE(CHART(3:3),'(I1)') IT

      WRITE(CHAR3,'(I3)') IOSYM
      N = 3
      IF(CHAR3(1:1).EQ.' ') N = 2
      IF(CHAR3(2:2).EQ.' ') N = 1
      LS   = 3-N+1
      SYMM = CHAR3(LS:3)//'_'//CHART
      CALL LENSTR_BL(SYMM,LN)
      IF(LN.GT.0.AND.LN.LT.8) THEN
        DO I=LN+1,8
          SYMM(I:I) = ' '
        ENDDO
      ENDIF
C ---
C     get ener_parameters
C     C    C       -0.19686     3.600   h
C     O    N       -1.500       2.850
C                      hb_type
C     OB      15.99940  A     1.600     1.600
C ---
C# _hb_type      donnor/acceptor's type:   
C#                     N=neither
C#                     D=donnor
C#                     A=acceptor
C#                     B=both
C#                     H=hydrogen candidate to hydrogen bonding
C RSV_HFLAG - vdw_H_flag ( 'h' or '.' )
C#  _H_flag         "h" - the parameters for atoms with hydrogens 
C RSV_SYMM - symmetry code of atom_2 ,nnn_ttt : nnn - N_symm_operator
C                                               ttt   translation
C            ttt : TxTyTz, N_trans = (T - 5)                        
      NAME   = 'VDW '
      ECONST =-0.19686
      RIDL   = 3.60
      HFLAG  = 'h'
      TYPE   = 'N'
      IF(ROBS.LT.3.3) THEN
        IH=0
        IF((ASYMB1.EQ.'O   '.OR.ASYMB1.EQ.'N   ').AND.
     *     (ASYMB2.EQ.'O   '.OR.ASYMB2.EQ.'N   ')) THEN
          IH=1
        ENDIF
        IF((ASYMB1.EQ.'O   '.OR.ASYMB1.EQ.'S   ').AND.
     *     (ASYMB2.EQ.'O   '.OR.ASYMB2.EQ.'S   ')) THEN
          IH=1
        ENDIF
        IF(ASYMB1.EQ.'O   '.AND.ASYMB2.EQ.'O   ') THEN
          IH=1
        ENDIF
        IF(ASYMB1.EQ.'N   '.AND.ASYMB2.EQ.'N   ') THEN
          IH=1
        ENDIF
        IF(IH.GT.0) THEN 
          NAME   = 'HB  '   
          ECONST =-1.500
          RIDL   = 2.850
          HFLAG  = 'h'
          TYPE   = 'A'
        ENDIF
      ENDIF
c      DO I=1,LET_NTORS
c        IF((LET_2ATM(I).EQ.CHEM2.AND.LET_3ATM(I).EQ.CHEM3).OR.
c     *     (LET_2ATM(I).EQ.CHEM3.AND.LET_3ATM(I).EQ.CHEM2)) THEN
c          L1T_VAL(L) = LET_ANGLE(I) 
c          L1T_EVAL(L)= LET_ANGLE(I)
c          L1T_PRD(L) = LET_PRD  (I) 
c          IF(LET_CONST(I).GT.2.0) THEN
C ----
      CALL WRESTR_VDW(MDOC,IOUT,NAME,TYPE,HFLAG,SYMM
     *  ,RIDL,ROBS,ECONST,IATOM1,IATOM2,ANAME1,ANAME2,ALT1,ALT2
     *  ,IRES1,RNAME1,IRES2,RNAME2,CH1,CH2,IERR)
      IF(IERR.NE.0) RETURN
C ---
      RETURN
 100  CONTINUE
      IERR=-1
      RETURN
      END

      SUBROUTINE WRESTR_VDW(MDOC,IOUT,NAME,TYPE,HFLAG,SYMM
     *  ,RIDL,ROBS,ECONST,IA1,IA2,ATOM1,ATOM2,ALT1,ALT2
     *  ,IR1,RNAME1,IR2,RNAME2,CH1,CH2,IERR)
C -----------------------------------------------
C -P-  WRESTR - 
C -S-
      REAL      RIDL,ROBS,ECONST
      INTEGER*4 MDOC,IERR,IA1,IA2,IR1,IR2
      CHARACTER NAME*4
      CHARACTER TYPE*1,HFLAG*1,SYMM*8
      CHARACTER ALT1*1,ALT2*1,CH1*4,CH2*4
      CHARACTER ATOM1*4,ATOM2*4,RNAME1*8,RNAME2*8
C ---
      INCLUDE 'crd_com.fh'
C ******
C -----------------------------------
      CHARACTER LINE*256
C --------------------------------------------------------
      IERR = 0
      IUN  = IOUT
      IF(ALT1.EQ.'.') ALT1 = ' '
      IF(ALT2.EQ.'.') ALT2 = ' '
      IF(CH1(1:1).EQ.'.') CH1  = '    '
      IF(CH2(1:1).EQ.'.') CH2  = '    '
      N=0
      IF(NAME.EQ.'VDW ') THEN
        RSV_NVDW = RSV_NVDW+1
        N        = RSV_NVDW
      ELSE IF(NAME.EQ.'HB ') THEN
        RSV_NHB = RSV_NHB+1
        N       = RSV_NHB
      ENDIF
      IF(N.GT.0) THEN

        WRITE(LINE,200) 
     *   ATOM1,ALT1,IR1,RNAME1,CH1
     *  ,ATOM2,ALT2,IR2,RNAME2,CH2
 200    FORMAT('# ',A4,A1,I5,1X,A,1X,A,' - ',A4,A1,I5,1X,A,1X,A)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,100) NAME,N,IA1,IA2
     *  ,RIDL,ROBS,ECONST,TYPE,HFLAG,SYMM(1:8)
 100    FORMAT(A4,1X,I6,1X,I6,1X,I6
     *   ,1X,F8.3,1X,F8.3,1X,F8.3,1X,A1,1X,A1,1X,A8)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
      ENDIF

      RETURN
      END

C ******
      SUBROUTINE WRITE_TITLE_VDW(MDOC,IUN,NAMEO,IERR)
C -----------------------------------------------
C -P-  -  writes title to VDW_file.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,IOUT
      CHARACTER NAMEO*(*)
C ---
      INCLUDE 'crd_com.fh'
C ******
      CHARACTER LINE*256,EXT*3,PATH*1
C -----------------------------------
      IERR = 0
      M    = 99
C     IUN  = 11
      IUN  = CRVO_IUN
      EXT  = 'vdw'
      PATH = ' '
      CALL OPENFW(IUN,M,PATH,NAMEO,EXT,IERR)
      CRVO_IUN = IUN
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: can''t open VDW_file.')
        RETURN
      ENDIF
C ---
        WRITE(LINE,'(''global_'')') 
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        WRITE(LINE,'(''_entry.id  '',1X,A)') CR_CD_PDB(1:4)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        CALL LENSTR_BL(CR_NAME_PDB,LEN)
        IF(LEN.LE.0) THEN
          CR_NAME_PDB=' '
          LEN=1
        ENDIF
        WRITE(LINE,100) CR_NAME_PDB(1:LEN)
  100   FORMAT('_struct.keywords  ',1X,'''',A,'''')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_autid.creation_date  '',1X,A)') 
     *  CR_DATE_PDB(1:9)
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        CALL LENSTR_BL(CR_TITLE,LEN)
        IF(LEN.LE.0) THEN
          CR_TITLE='---'
          LEN=3
        ENDIF
        IF(LEN.GT.60) LEN=60 
        WRITE(LINE,200) CR_TITLE(1:LEN)
 200    FORMAT('_struct.title    ',1X,'''',A,'''') 
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

        WRITE(LINE,'(''#'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''data_restraints'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''#'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''loop_'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''#'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_restr.record'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_restr.number'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)


        WRITE(LINE,'(''_restr.atom_id_1'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_restr.atom_id_2'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_restr.rad_min'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_restr.rad_obs'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_restr.econst'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_restr.type'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_restr.hflag'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)
        WRITE(LINE,'(''_restr.symmetry'')')
        CALL WRTSTR(IUN,MDOC,LINE,IERR)

      RETURN
      END






