C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
      SUBROUTINE NCS_CONST(MAX_MAT,MAX_VEC,A_MAT,VECT,
     &               WORKSPACE,N_WORKSPACE)
      IMPLICIT NONE

      INCLUDE 'ncs_rest.fh'
      INCLUDE 'atom_com.fh'
      INTEGER MAX_MAT,MAX_VEC,NDIST,N_WORKSPACE
      REAL SUMP,SUMB
      REAL A_MAT(*),VECT(*),WORKSPACE(*)
C
C--Give space for intermediate arrays.
      IF((13+MAX_NCS)*N_ATOM.GE.N_WORKSPACE) THEN
         CALL ERRWRT(-1,'Not enough memory for NCS restraints')
         CALL ERRWRT(1,'Increase QQDEN in pls_incl.fh and recompile'//
     &            'program')
      ENDIF
      CALL NCS_CONST1(MAX_MAT,MAX_VEC,A_MAT,VECT,
     &             WORKSPACE(1),
     &             WORKSPACE(3*N_ATOM+1),WORKSPACE(6*N_ATOM+1),
     &             WORKSPACE(9*N_ATOM+1),WORKSPACE(10*N_ATOM+1))
      RETURN
      END

      SUBROUTINE NCS_CONST1(MAX_MAT,MAX_VEC,A_MAT,VECT,XA,
     &                    XB,XC,WS,IAT)
C
C----Restraints on non-crystallographic symmetry related molecules 
C----to obey it
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'const.fh'
      INCLUDE 'ncs_rest.fh'
      INCLUDE 'rharvest.fh'
      INCLUDE 'restr_files.fh'
C
      INTEGER MAX_MAT,MAX_VEC
      REAL A_MAT(*),VECT(*)
      REAL XA(3,*),XB(3,*),XC(3,*),WS(*)
      INTEGER IAT(N_ATOM,MAX_NCS)
C
      INTEGER I,L1,NPAR_U_NCS,IX,ISCRN,NS,IS,NCHN,ICHN,
     &        K,IA,ISS,LL,IFAIL,IGROUP,JX,IANISO,IY,IA1,LV,LM,M0,
     &        MM,NCHN1,IFIRST
      REAL WT,WBB,CC,DS,AN12N,BS,BGR,BMT
      REAL              RNCS_XYZ_ALL(3,3,MAX_NCS),
     &                  RNCS_XYZ_INV(3,3,MAX_NCS),
     +                  XYZ1(3),XYZA(3),
     +                  VV(3),VV2(3,3),VV0(3,3),VV1(3,3)
      INTEGER           NSW(6)
      INTEGER LENSTR
      EXTERNAL LENSTR
      LOGICAL           ANISO_FLAG_NCS,ERROR
C
C----Read the header record for a symmetry group
      IF(NUMBER_NCSC.LE.0) THEN
        CALL ERRWRT(0,'No NCS has been defined')
        RETURN
      ENDIF
C
      ISCRN       = 0
      IFAIL       = -1
      IF(NCSC_FILE_NAME(1:1).EQ.' ') RETURN
      CALL CCPDPN(ISCRN,NCSC_FILE_NAME(1:LENSTR(NCSC_FILE_NAME)),
     &          'UNKNOWN','U',LL,IFAIL)
C
      LV = NVPOS + 1
      LM = NMPOS + 9*NDIS + 1
      DO      IGROUP=1,NUMBER_NCSC
C
C----Initialise weights
C
C--Second derivative matrix for not rotated atoms
        READ(ISCRN)NS
        IF(NS.LE.0) GOTO 300
        NCHN = NCSC_N_CHAIN(IGROUP)
        IF(NCHN.LE.1) GOTO 300
C
C----Read the atom equivalences for this symmetry group
        DO    IS=1,NS
          READ(ISCRN) (IAT(IS,K),K=1,NCHN)
C
C----Find the symmetry transformations. This part should be changed.
          WS(IS) = 1.0
          DO   K=1,NCHN
            IA = IAT(IS,K)
            IF(ATOM_REF_FLAG(IA).LE.0) GOTO 10
          ENDDO
 10       CONTINUE
        ENDDO
C---
        DO   K = 1,NCHN
          IF(K.EQ.1) THEN
            CALL MAT2IDENT(3,3,RNCS_XYZ_ALL(1,1,1),ERROR)
            CALL MAT2IDENT(3,3,RNCS_XYZ_INV(1,1,1),ERROR)
          ENDIF
          DO  IS = 1,NS
            ISS    = IAT(IS,K)
            IF(K.EQ.1) THEN
C
c---Refernence set of atoms for NCS
              XA(1,IS) = XYZ_CRD(1,ISS)
              XA(2,IS) = XYZ_CRD(2,ISS)
              XA(3,IS) = XYZ_CRD(3,ISS)
            ELSE
C
C---Working set of atoms for which transformation should be found. 
              XB(1,IS) = XYZ_CRD(1,ISS)
              XB(2,IS) = XYZ_CRD(2,ISS)
              XB(3,IS) = XYZ_CRD(3,ISS)
            ENDIF
          ENDDO
C
C---Find transformation matrix
          IF(K.NE.1) THEN 
            CALL TOSS1(NS,RNCS_XYZ_ALL(1,1,K),VV,XA,XB,XC,WS)
            CALL MATTRANS(3,3,RNCS_XYZ_ALL(1,1,K),RNCS_XYZ_INV(1,1,K),
     &                       ERROR)
          ENDIF
        ENDDO

C---Cycle over all atom equavalences
        DO     IS=1,NS
          DO   IX=1,3
            VV(IX) = 0.0
          ENDDO
          DO   IX=1,3
            DO  IY=1,3
              VV2(IX,IY) = 0.0
            ENDDO
          ENDDO
          BGR  = 0.0
          BMT  = 0.0
          DO   K=1,NCHN
            IA = IAT(IS,K)
            IF(ATOM_REF_FLAG(IA).LE.0) GOTO 200
            IA1   = ATOM_REF_FLAG(IA)/10
C
C--Take gradient and second derivative elements for this chain
            M0    = 3*(IA1-1)
            MM    = 6*(IA1-1)
            DO   IX = 1,3
              XYZA(IX) = VECT(M0+IX)
            ENDDO
            CALL MAT2VECT(3,3,RNCS_XYZ_INV(1,1,K),XYZA,XYZ1,ERROR)
            DO   IX=1,3
              VV(IX) = VV(IX) + XYZ1(IX)
            ENDDO
            BGR = BGR + VECT(LV+IA1)
            DO   IX=1,3
              VV0(IX,IX) = A_MAT(MM+IX)
            ENDDO
            VV0(1,2) = A_MAT(MM+4)
            VV0(1,3) = A_MAT(MM+5)
            VV0(2,3) = A_MAT(MM+6)
            VV0(2,1) = VV0(1,2)
            VV0(3,1) = VV0(3,1)
            VV0(3,2) = VV0(2,3)
            CALL MATT2MAT(3,3,RNCS_XYZ_INV(1,1,K),VV0,VV1,ERROR)
            CALL MAT2MAT(3,3,VV1,RNCS_XYZ_INV(1,1,K),VV0,ERROR)
            DO  IX=1,3
              DO  IY=1,3
                VV2(IX,IY) = VV2(IX,IY) + VV0(IX,IY)
              ENDDO
            ENDDO
            BMT = BMT + A_MAT(LM+IA1)
C
C--Add gradients and second derivatives for B values also
 200        CONTINUE
          ENDDO
          DO  IX=1,3
            VV(IX) = VV(IX)/FLOAT(NCHN)
            DO  IY=1,3
              VV2(IX,IY) = VV2(IX,IY)/FLOAT(NCHN)
            ENDDO
          ENDDO
          BGR = BGR/FLOAT(NCHN)
          BMT = BMT/FLOAT(NCHN)
C
C---For B values
          DO  K=1,NCHN
            IA = IAT(IS,K)
            IF(ATOM_REF_FLAG(IA).LE.0) GOTO 250
            IA1   = ATOM_REF_FLAG(IA)/10
C
C--Take gradient and second derivative elements for this chain
            M0    = 3*(IA1-1)
            MM    = 6*(IA1-1)
            CALL MAT2VECT(3,3,RNCS_XYZ_ALL(1,1,K),VV,XYZA,ERROR)
            DO   IX=1,3
              VECT(M0+IX) = XYZA(IX)
            ENDDO
            VECT(LV+IA1)  = BGR
            CALL MATT2MAT(3,3,RNCS_XYZ_ALL(1,1,K),VV2,VV0,ERROR)
            CALL MAT2MAT(3,3,VV0,RNCS_XYZ_ALL(1,1,K),VV1,ERROR)

            DO   IX=1,3
              A_MAT(MM+IX) = VV1(IX,IX)
            ENDDO
            A_MAT(MM+4)     = VV1(1,2)
            A_MAT(MM+5)     = VV1(1,3)
            A_MAT(MM+6)     = VV1(2,3)
            A_MAT(LM+IA1) = BMT
C
C---For B values
 250        CONTINUE
          ENDDO
        ENDDO
 300    CONTINUE
      ENDDO
C
C--We need to remove non-diagonal elements for now.
      DO   IX=1,9*NDIS
        A_MAT(NMPOS+IX) = 0.0
      ENDDO
      DO  IX=1,NBIS
        A_MAT(NMPOS + 9*NDIS + NMTMP + IX) = 0.0
      ENDDO
      NONDIAG_FLAG = .FALSE.
      CLOSE(UNIT = ISCRN)
      RETURN
      END
