      subroutine read_psuedorest(bond_file)
c
c---This routine reads external restraints and adds them to 
c---the bond file. 
      implicit none
      include 'atom_com.fh'
c
c---inputs
      character bond_file*(*)
c
c---  locals
c
c---  Things for psuedo restraints
      integer ierr
      integer ia1,ia2,i1,i2,i3,i4,ibtype
      integer isym_out(4)
      real rs_vidl,rs_sigma
      character psuedorest_file*512
      logical ires_defined(2),chain_defined(2),ins_defined(2)
      logical atom_defined(2),alt_defined(2)
      logical dist_defined,sigma_defined,type_defined,prob_defined
      integer ires_in(2)
      character ins_in(2)*1,atom_in(2)*4,alt_in(2)*1,chain_in(2)*4
      real dist_value,sigma_value,prob_in
      integer ia_first_atom,ia_last_atom
c
c---  Things for parser
      integer maxtok,NTOK,itk
      parameter (maxtok = 200)
      integer ibeg(maxtok),iend(maxtok),idec(maxtok),itype(maxtok)
      character line*600,key*4
      character cvalue(maxtok)*4
      real fvalue(maxtok)
      logical lend,lprint
      integer iend_r,lend_f
c
c---  loops and others
      integer i,j,k,l,ich,ires,ia,ir_first,ir_last,ia_first,ia_last
      integer jrs
      character alt_code*1,ins_code*1,type_in*10
      character asmgrp*4
      integer ipsuedo,ibond,ifail,ll
c
c--externals
      integer lenstr
      external lenstr
c
c---- Body
      call ugtenv('PSRESTIN',psuedorest_file)
      l=lenstr(psuedorest_file)
      if(l.le.0) return
      ipsuedo = 0
      ll=0
      ifail = -1
      call ccpdpn(ipsuedo,psuedorest_file,'UNKNOWN','F',ll,ifail)
      l=0
      l = lenstr(bond_file)
      if(l.le.0) then
         call errwrt(1,'In read_pseudorest. There is no bond file.')
      endif
      ibond = 0
      ll = 0
      ifail = -1
      call ccpdpn(ibond,bond_file,'UNKNOWN','U',ll,ifail)
C
c--read till the end
      do while(.TRUE.)
         read(ibond,end=5) ia1,ia2,rs_vidl,rs_sigma,i1,i2,i3,i4,ibtype
      enddo

 5    continue
      backspace ibond

      lend = .TRUE.
      key = ' '
      ierr = 0
      lend_f = 0
      do while(lend_f.ge.0.and.key(1:3).ne.'END'.and.ierr.eq.0)
         ires_defined(1) = .FALSE.
         ires_defined(2) = .FALSE.
         chain_defined(1) = .FALSE.
         chain_defined(2) = .FALSE.
         ins_defined(1) = .FALSE.
         ins_defined(2) = .FALSE.
         atom_defined(1) = .FALSE.
         atom_defined(2) = .FALSE.
         alt_defined(1) = .FALSE.
         alt_defined(2) = .FALSE.
         dist_defined = .FALSE.
         sigma_defined = .FALSE.
         type_defined  = .FALSE.
         prob_defined = .FALSE.
         lprint = .FALSE.
         line = ' '
         key = ' '
         do while(line.eq.' '.and.lend_f.ge.0)
            read(ipsuedo,'(a)',iostat=lend_f)line
         enddo
         if(lend_f.lt.0) goto 999
         call parser(key,line,ibeg,iend,itype,fvalue,cvalue,idec,ntok,
     &        lend,lprint)
         call ccpupc(key)
         do  itk=2,ntok
            call ccpupc(cvalue(itk))
         enddo
         if(key.eq.'EXTE') then
            itk = 2
            if(cvalue(itk).ne.'DIST') ierr = 4
            if(cvalue(itk).eq.'DIST') then
               itk = itk+1
 10            continue
               if(cvalue(itk).eq.'FIRS') then
                  itk = itk + 1
 15               continue
                  if(cvalue(itk).eq.'SECO'.OR.cvalue(itk).eq.'FIRS'.OR.
     &               cvalue(itk).eq.'VALU'.OR.cvalue(itk).eq.'SIGM') 
     &                              goto 10
                  if(cvalue(itk).eq.'CHAI') then
                     itk = itk + 1
                     if(itk.gt.NTOK) then
                        ierr = 1
                        goto 999
                     endif
                     chain_in(1) = line(ibeg(itk):iend(itk))
                     chain_defined(1) = .TRUE.
                     itk = itk +1.
                  else if(cvalue(itk).eq.'RESI') then
                     itk = itk + 1
                     if(itk.gt.NTOK) then
                        ierr = 1
                        goto 999
                     endif
                     ires_in(1) = nint(fvalue(itk))
                     ires_defined(1) = .TRUE.
                     itk = itk + 1
                  else if(cvalue(itk).eq.'INSE') then
                     itk = itk + 1
                     if(itk.gt.NTOK) then
                        ierr = 1
                        goto 999
                     endif
                     ins_in(1) = line(ibeg(itk):iend(itk))
                     ins_defined(1) = .TRUE.
                     itk = itk + 1
                  else if(cvalue(itk).eq.'ATOM') then
                     itk = itk + 1
                     if(itk.gt.NTOK) then
                        ierr = 1
                        goto 999
                     endif
                     atom_in(1) = line(ibeg(itk):iend(itk))
                     atom_defined(1) = .TRUE.
                     itk = itk + 1
                  else if(cvalue(itk).eq.'ALTE') then
                     itk = itk + 1
                     if(itk.gt.NTOK) then
                        ierr = 1
                        goto 999
                     endif
                     alt_in(1) = line(ibeg(itk):iend(itk))
                     alt_defined(1) = .TRUE.
                     itk = itk + 1
                  endif
                  goto 15
               else if(cvalue(itk).eq.'SECO') then
                  itk = itk + 1
 25               continue
                  if(cvalue(itk).eq.'SECO'.OR.cvalue(itk).eq.'FIRS'.OR.
     &               cvalue(itk).eq.'VALU'.OR.cvalue(itk).eq.'SIGM') 
     &                              goto 10
                 if(cvalue(itk).eq.'CHAI') then
                     itk = itk + 1
                     if(itk.gt.NTOK) then
                        ierr = 1
                        goto 999
                     endif
                     chain_in(2) = line(ibeg(itk):iend(itk))
                     chain_defined(2) = .TRUE.
                     itk = itk + 1
                  else if(cvalue(itk).eq.'RESI') then
                     itk = itk + 1
                     if(itk.gt.NTOK) then
                        ierr = 1
                        goto 999
                     endif
                     ires_in(2) = nint(fvalue(itk))
                     ires_defined(2) = .TRUE.
                     itk = itk + 1
                  else if(cvalue(itk).eq.'INSE') then
                     itk = itk + 1
                     if(itk.gt.NTOK) then
                        ierr = 1
                        goto 999
                     endif
                     ins_in(2) = line(ibeg(itk):iend(itk))
                     ins_defined(2) = .TRUE.
                     itk = itk + 1
                  else if(cvalue(itk).eq.'ATOM') then
                     itk = itk + 1
                     if(itk.gt.NTOK) then
                        ierr = 1
                        goto 999
                     endif
                     atom_in(2) = line(ibeg(itk):iend(itk))
                     atom_defined(2) = .TRUE.
                     itk = itk + 1
                  else if(cvalue(itk).eq.'ALTE') then
                     itk = itk + 1
                     if(itk.gt.NTOK) then
                        ierr = 1
                        goto 999
                     endif
                     alt_in(2) = line(ibeg(itk):iend(itk))
                     alt_defined(2) = .TRUE.
                     itk = itk + 1
                  endif
                  goto 25
               else if(cvalue(itk).eq.'VALU') then
                  itk = itk+1
                  if(itk.gt.NTOK) then
                     ierr = 1
                     goto 999
                  endif
                  if(itype(itk).ne.2) then
                     ierr = 2
                     goto 999
                  endif
                  dist_value = fvalue(itk)
                  dist_defined = .TRUE.
                  itk = itk + 1
                  goto 10
               else if(cvalue(itk).eq.'SIGM') then
                  itk = itk + 1
                  if(itk.gt.NTOK) then
                     ierr = 1
                     goto 999
                  endif
                  if(itype(itk).ne.2) then
                     ierr = 2
                     goto 999
                  endif
                  sigma_value = fvalue(itk)
                  sigma_defined = .TRUE.
                  itk = itk + 1
                  goto 10
               else if(cvalue(itk).eq.'TYPE') then
                  itk = itk + 1
                  type_in = line(ibeg(itk):iend(itk))
                  type_defined = .TRUE.
                  itk = itk + 1
                  goto 10
               else if(cvalue(itk).eq.'PROB') then
                  itk = itk+1
                  if(itk.gt.NTOK) then
                     ierr = 1
                     goto 999
                  endif
                  if(itype(itk).ne.2) then
                     ierr = 2
                     goto 999
                  endif
                  prob_in = fvalue(itk)
                  prob_defined = .TRUE.
                  itk=itk+1
                  goto 10
               endif
            endif
c
c---Now check if everything is o.k. I.e. we have all necessary information
            if(.not.dist_defined) then
               call errwrt(-1,'Value for the distance must be defined')
               ierr = 1
               goto 999
            endif
            if(.not.sigma_defined) sigma_value = 0.02
            if(.not.ires_defined(1)) then
               call errwrt(-1,
     &         'Residue number for the first atom has not been defined')
               ierr = 1
               goto 999
            endif
            if(.not.ires_defined(2)) then
               call errwrt(-1,
     &        'Residue number for the second atom has not been defined')
               ierr = 1
               goto 999
            endif
            if(.not.chain_defined(1)) then
               call errwrt(-1,
     &           'Chain name for the first atom has not been defined')       
            endif
            if(.not.chain_defined(2)) then
               call errwrt(-1,
     &          'Chain name for the second atom has not been defined') 
            endif
            if(.not.atom_defined(1)) then
               call errwrt(-1,
     &          'Atom name for the first atom has not been defined')
               ierr = 1
               goto 999
            endif
            if(.not.atom_defined(2)) then
               call errwrt(-1,
     &          'Atom name for the second atom has not been defined')
               ierr = 1
               goto 999
            endif
            if(.not.ins_defined(1)) ins_in(1) = ' '
            if(.not.ins_defined(2)) ins_in(2) = ' '
            if(.not.alt_defined(1)) alt_in(1) = '.'
            if(.not.alt_defined(2)) alt_in(2) = '.'
            if(.not.type_defined) type_in = 'External'
c     
C-Now find atomic numbers and write to a file
c
            do  ich=1,n_group
               call get_asm_group_id(asmgrp,ich)
               if(chain_in(1).eq.asmgrp) then
                  ir_first = ires_first(ich)
                  ir_last  = ir_first + nres_chain(ich)-1
                  do ires=ir_first,ir_last
                     read(res_num_pdb(ires)(3:6),*)jrs
                     ins_code = res_num_pdb(ires)(7:7)
                     if(ires_in(1).eq.jrs.and.
     &                    ins_code.eq.ins_in(1)) then
                        ia_first = iratm_first(ires)
                        ia_last  = ia_first+natm_res(ires)-1
                        do  ia=ia_first,ia_last
                            if(atom_in(1).eq.atm_name(ia).and.
     &                          alt_in(1).eq.id_alt(ia)) then
                              ia_first_atom = ia
                              goto 200
                           endif
                        enddo
                     endif
                  enddo
               endif
            enddo
            ierr = 3
            goto 999
 200        continue
            do  ich=1,n_group
               call get_asm_group_id(asmgrp,ich)
               if(chain_in(2).eq.asmgrp) then
                  ir_first = ires_first(ich)
                  ir_last  = ir_first + nres_chain(ich)-1
                  do ires=ir_first,ir_last
                     read(res_num_pdb(ires)(3:6),*)jrs
                     ins_code = res_num_pdb(ires)(7:7)
                     if(ires_in(2).eq.jrs.and.
     &                    ins_code.eq.ins_in(2)) then
                        ia_first = iratm_first(ires)
                        ia_last  = ia_first+natm_res(ires)-1
                        do  ia=ia_first,ia_last
                           if(atom_in(2).eq.atm_name(ia).and.
     &                          alt_in(2).eq.id_alt(ia)) then
                              ia_last_atom = ia
                              goto 300
                           endif
                        enddo
                     endif
                  enddo
               endif
            enddo
            ierr = 3
            goto 999
 300        continue
c
c---Find out if these atoms are related by symmetry or directly
            call find_symm_contact(ia_first_atom,ia_last_atom,isym_out)
c
c
c---Add this info into the file
            write(ibond)ia_first_atom,ia_last_atom,dist_value,
     &           sigma_value,(isym_out(i),i=1,4),2
            write(*,*)ia_first_atom,ia_last_atom,dist_value,
     &           sigma_value,(isym_out(i),i=1,4),2,ierr
C
C--Found. Now write as usual
         endif
      enddo
c     stop
c---  Read and remove redundant pairs
 999  continue
      close(ipsuedo)
      close(ibond)
      if(ierr.eq.0) return
c
c---  Process errors
      if(ierr.eq.1) write(*,*)'Incomplete instruction for restrtaint'
      if(ierr.eq.2) write(*,*)'Wrong data type for distance/sigma'
      if(ierr.eq.3) write(*,*)'Specified atoms(s) could not be found'
      if(ierr.eq.4) write(*,*)'Wrong instruction'
      write(*,*)'Example of instructions:'
      write(*,*)'extr dist first residue <number> chain <name> atom'
     &//' <name> second residue <number> chain <name> atom <name>'
     &//' value <number> sigma <number>'
      write(*,*)'If alternative or insertion code are aslo present then'
     &//' they can be added using subkeywords alte or inse'
      call errwrt(1,'Cannot continue. Quitting now')
      return
      end
c
      subroutine find_symm_contact(ia1,ia2,isym_out)
      implicit none
      include 'atom_com.fh'
c
c---inputs
      integer ia1,ia2
c
c---outputs
      integer isym_out(4)
c
c---locals
      integer is,itx(3)
      real d_p,d_l
      real xyz_1(3),xyz_2(3),xyz_frac2(3),xyz_frac1(3),xyz_sym(3)
      real xyz_d(3),axyz(3),axyz_o(3)
      logical error
c
c---body
      xyz_1(1:3) = xyz_crd(1:3,ia1)
      xyz_2(1:3) = xyz_crd(1:3,ia2)
      call mat2vec(3,3,cs_ort_to_frac,xyz_2,xyz_frac2,error)
      call mat2vec(3,3,cs_ort_to_frac,xyz_1,xyz_frac1,error)
      d_p = 1.E32
      isym_out(1) = 1
      isym_out(2:4) = 0
      do  is=1,cs_nsym
         call mat2vec(3,3,cs_m_cs(1,1,is),xyz_frac2,xyz_sym,error)
         xyz_sym(1:3) = xyz_sym(1:3) + cs_v_cs(1:3,is)
         xyz_d = xyz_frac1 - xyz_frac2
         call amod_r(xyz_d(1)+0.5,1.0,itx(1),axyz(1))
         axyz(1) = axyz(1)-0.5
         call amod_r(xyz_d(2)+0.5,1.0,itx(2),axyz(2))
         axyz(2) = axyz(2)-0.5
         call amod_r(xyz_d(3)+0.5,1.0,itx(3),axyz(3))
         axyz(3) = axyz(3)-0.5
         call mat2vec(3,3,cs_frac_to_ort,axyz,axyz_o,error)
         d_l = axyz_o(1)**2+axyz_o(2)**2+axyz_o(3)**3
         if(d_p.gt.d_l) then
            isym_out(1) = is
            isym_out(2:4) = itx(1:3)
            d_p = d_l
         endif
      enddo
      return
      end
