C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C

C TODO
C 1) many contributions to 2nd derivative are missing
C 2) libration has effect on bondlength (not relevant at the moment, since
C not refining coordinates)
C 3) need external file to hold TLS parameters; can be used as
C starting values --- yes, but needs to tidy w.r.t. keyworded input
C 4) reduce memory requirements

      SUBROUTINE TLS_REFINE
      IMPLICIT NONE
C
C---Refinement of TLS parameters

C   Note we don't want to apply U restraints when just TLS.
C   Restraints are in BREF, RIGID_BOND, BSPHERE_RESTR which are
C   called from GEOM.

C   TLS tensors are held in TMAT(6,MAXTLSGRP),LMAT(6,MAXTLSGRP),SMAT(8,MAXTLSGRP)
C   in orthogonal coordinates in A and radians (though radians are converted
C   to degrees on input/output).
      INCLUDE 'atom_com.fh'
      INCLUDE 'const.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'weights.fh'
      INCLUDE 'save_all_params.fh'


      INTEGER MCOLS
      PARAMETER (MCOLS = 200)
      INTEGER NLPRGI,NLPRGO,LOOKUP(MCOLS)
      COMMON /MTZRD/NLPRGI,NLPRGO,LOOKUP
      COMMON /REF_SPG/ GX,GU1,GQ
      REAL  GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
C---Local variables
C
      INTEGER IWRITE_FIRST,IANALYSE_REST
      INTEGER IL_MIN
      INTEGER J,I,I1,IA,ICYCL,IDOM,NTLSGRP20,IPAR
      INTEGER IFLAG,NTRY_THIS,ITR
      REAL ALPHA
      REAL TEMP_LOCAL,TLS_TRACE
      INTEGER NWORK_TLS
      PARAMETER (NWORK_TLS = MAXTLSGRP*200)
      REAL*8 WORKSPACE(NWORK_TLS)
cd      COMMON /R_SCRATCH/ WORKSPACE(NWORK_TLS)

      REAL SHIFTWGT
      REAL*8 TOLER
      REAL ALP1,ALP2,DOT1_R
      REAL FXRAY_OLD
      LOGICAL ERROR
      CHARACTER MON_STYLE_SAVE*4
      LOGICAL LREFIN_SAVE,LINITIAL
      EXTERNAL DOT1_R
C---Define and initialise tls groups
      CALL TLS_INIT
      TOLER = 0.5D-7

C---Calcalate A matrices for particular set of orthogonal coordinates
C   obtained from XORT0(3,MAXATOM). Elements of A are orthogonal coordinates
C   w.r.t. TLS orgins, and are placed back in XORT0(3,MAXATOM).
      CALL CALC_AMAT

C---Calculate initial U matrices from initial TLS parameters
C   and (total) isotropic values.
      LINITIAL = .TRUE.
      CALL TLS2ANISOU(LINITIAL)
C
      MON_STYLE_SAVE = MON_STYLE
      NTLSGRP20 = NTLSGRP*20
      DO    ICYCL=1,NTLS_CYCLE
         IF(ICYCL.NE.1.AND.MON_STYLE.NE.'NONE'.AND.
     &                     MON_STYLE.NE.'MANY') MON_STYLE = 'FEW'
         IF(ICYCL.EQ.NTLS_CYCLE) MON_STYLE=MON_STYLE_SAVE
         IF (MON_STYLE.NE.'NONE') THEN
          WRITE(6,'(/,/,A,I4,/)') ' ***TLS refinement cycle*** ',ICYCL
         ENDIF
        ALPHA         = 1.0
        IWRITE_FIRST  = 1
        IANALYSE_REST = 0
        CALL ANALYSE_VDW(ALPHA,IWRITE_FIRST,IANALYSE_REST)
C
C---Calculate derivatives wrt individual atomic displacement parameters
         CALL REFALL
         CALL REPORT_XRAY_STATS
         FXRAY_OLD = FXRAY
cd         ALL_SCALES_FLAG = .FALSE.
C
C---Testing only

         IF (MON_STYLE.EQ.'MANY') THEN
          WRITE(6,'(/,/,A,F12.3,/)') ' **X-ray residual** ',FXRAY
         ENDIF
C
C---Calculate derivatives wrt TLS parameters using chain rule
         CALL DERIVS_OF_TLS
C
C---Solve linear equations using singular value decomposition
C
C---Add more conditioning and analysis
cd         DO   I=1,NTLSGRP20
cd            WRITE(*,*)(HX_TLS(I,J),J=1,NTLSGRP20)
cd         ENDDO

cd          CALL ADD_CONDITIONS_TLS(MAXTLSGRP20,NTLSGRP20,NTLSGRP,
cd     &       GX_TLS,HX_TLS,WORKSPACE,NWORK_TLS)

cd         WRITE(*,*)((HX_TLS(I,J),I=1,NTLSGRP20),J=1,NTLSGRP20)
cd         WRITE(*,*)'GRADS ',(GX_TLS(I),I=1,NTLSGRP20)
         CALL  DEIGEN_FILTER_R(TOLER,HX_TLS,NTLSGRP20,MAXTLSGRP20,
     &             GX_TLS,SHFT_TLS,WORKSPACE,NWORK_TLS)
cd         WRITE(*,*)
cd         WRITE(*,*)(SHFT_TLS(I),I=1,NTLSGRP20)
C
C--Add corrections to shifts according to constraint (trace of T matrices is 0)
C
cd         WRITE(*,*)'Should be 0.0 is',SHFT_TLS(1)
         TEMP_LOCAL = SHFT_TLS(2) + SHFT_TLS(3)
         IF(NTLSGRP.GT.1) THEN
           DO   I=2,NTLSGRP
             I1 = 20*(I-1)
             TEMP_LOCAL = TEMP_LOCAL + SHFT_TLS(I1+1) + 
     &                      SHFT_TLS(I1+2) + SHFT_TLS(I1+3)
           ENDDO
         ENDIF
cd         SHFT_TLS(1) = -TEMP_LOCAL
C
C---Apply shifts to TLS parameters 
         IPAR     = 0
         SHIFTWGT = 1.0
cd*bdamp
         NTRY_THIS = 0
 10      CONTINUE
         DO IDOM=1,NTLSGRP
          DO I = 1,6
            IPAR            = IPAR +1
            TMAT(I,IDOM)    = TMAT(I,IDOM) + SHFT_TLS(IPAR)*SHIFTWGT 
          ENDDO
          DO I = 1,6
            IPAR = IPAR +1
            LMAT(I,IDOM)    = LMAT(I,IDOM) + SHFT_TLS(IPAR)*SHIFTWGT
          ENDDO
          DO I = 1,8
            IPAR = IPAR +1
            SMAT(I,IDOM)    = SMAT(I,IDOM) + SHFT_TLS(IPAR)*SHIFTWGT
          ENDDO
         ENDDO
         CALL MAKE_L_POSITIVE
C
C---Derive new aniso-U from shift in TLS parameters
         LINITIAL = .FALSE.
         CALL SAVE_OVERALL_PARAMS('S')
         CALL MAKE_L_POSITIVE
         CALL TLS2ANISOU(LINITIAL)
         CALL ADD_SCALE_CONTR
         CALL MAKE_U_POSITIVE
         UOVER_ATOM = 0.0
         GOTO 100
         DO   I=1,NTLSGRP20
           SHFT_TLS(I) = -SHFT_TLS(I)
         ENDDO
         HCALC = .FALSE.
         GRADC = .FALSE.
         CALL REFALL

         DO IL_MIN=1,3
cd           WRITE(*,*)FXRAY,FXRAY_OLD
           IF(FXRAY.GT.FXRAY_OLD) THEN
cd             WRITE(*,*)'Half shift ??',FXRAY,FXRAY_OLD

             DO   I=1,NTLSGRP20
               SHFT_TLS(I) = SHFT_TLS(I)/2.0D0
             ENDDO
             IPAR = 0
             DO IDOM=1,NTLSGRP
               DO I = 1,6
                 IPAR        = IPAR +1
                 TMAT(I,IDOM) = TMAT(I,IDOM) +SHFT_TLS(IPAR)*SHIFTWGT 
               ENDDO
               DO I = 1,6
                 IPAR = IPAR +1
                 LMAT(I,IDOM) = LMAT(I,IDOM) + SHFT_TLS(IPAR)*SHIFTWGT
               ENDDO
               DO I = 1,8
                 IPAR = IPAR +1
                 SMAT(I,IDOM) = SMAT(I,IDOM) + SHFT_TLS(IPAR)*SHIFTWGT
               ENDDO
             ENDDO
             CALL MAKE_L_POSITIVE
             CALL TLS2ANISOU(LINITIAL)
             CALL ADD_SCALE_CONTR
             CALL MAKE_U_POSITIVE
             UOVER_ATOM = 0.0
             CALL SAVE_OVERALL_PARAMS('R')
             CALL REFALL
           ENDIF
         ENDDO
         CALL SAVE_OVERALL_PARAMS('R')
         TLS_TRACE = 0.0
         DO   ITR = 1,NTLSGRP
           TLS_TRACE = TLS_TRACE + TMAT(1,ITR)+TMAT(2,ITR)+TMAT(3,ITR)
         ENDDO
         TLS_TRACE = TLS_TRACE/FLOAT(3*NTLSGRP)
cd         DO   ITR = 1,NTLSGRP
cd           TMAT(1,ITR) = TMAT(1,ITR) - TLS_TRACE
cd           TMAT(2,ITR) = TMAT(2,ITR) - TLS_TRACE
cd           TMAT(3,ITR) = TMAT(3,ITR) - TLS_TRACE
cd         ENDDO
cd         TLS_TRACE = 0.0
cd         DO   ITR = 1,NTLSGRP
cd           TLS_TRACE = TLS_TRACE + TMAT(1,ITR)+TMAT(2,ITR)+TMAT(3,ITR)
cd         ENDDO
100      CONTINUE
         HCALC = .TRUE.
         GRADC = .TRUE.
         IF (PRINT_TLSPARS) THEN
           DO  IDOM=1,NTLSGRP
             WRITE(6,'(/,A,I4,A2,A)') 'TLS group ',IDOM,': ',
     +                    TLSGRP_TITLE(IDOM)
             WRITE(6,'(A11,I2,A4,6F8.3)') 'T tensor (',IDOM,') = ',
     +                    (TMAT(I,IDOM),I=1,6)
             WRITE(6,'(A11,I2,A4,6F8.3)') 'L tensor (',IDOM,') = ',
     +                    (LMAT(I,IDOM)*RTODEG*RTODEG,I=1,6)
             WRITE(6,'(A11,I2,A4,8F8.3)') 'S tensor (',IDOM,') = ',
     +                    (SMAT(I,IDOM)*RTODEG,I=1,8)
           ENDDO
         ENDIF
C
C---Make shure trace of T matrices is 0. Sometimes numerical imprecisions
C---can cause departure from 0 trace
      ENDDO
      MON_STYLE = MON_STYLE_SAVE
C---Write new mtz
cd      IF(NLPRGO.NE.0) THEN
cd        LREFIN_SAVE = LREFIN
cd        LREFIN    = .FALSE.
cd        CALL REFALL
cd        LREFIN = LREFIN_SAVE
cd      ENDIF

c---Write new coordinate file
cd      CALL NEWBRK

C---Write new TLS parameters file
      IF(NTLS_CYCLE.GT.0) CALL WRITE_TLS_FILE

      DO   IA=1,N_ATOM
          DO   I=1,6
            U_ANISO(I,IA) = UANISO_OLD(I,IA)
          ENDDO
      ENDDO
      UOVER_ATOM = 0.0
      RETURN
      END
C
      SUBROUTINE MAKE_L_POSITIVE
      IMPLICIT NONE
C
C---This subroutine make L matrices of TLS non-negative. In principle
C---if overall B would be in T then whole matrix should be positive definite.
C---It will have to be worked on.
      INCLUDE 'atom_com.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'refi_flags.fh'
C
      INTEGER I,IDOM,LWORK,INFO
      REAL UANISO0(3,3),UANISO1(6),EVALUE(6),WORK(100)
C
      LWORK = 100
C
      DO   IDOM =1,NTLSGRP
        UANISO0(1,1) = LMAT(1,IDOM)
        UANISO0(2,2) = LMAT(2,IDOM)
        UANISO0(3,3) = LMAT(3,IDOM)
        UANISO0(1,2) = LMAT(4,IDOM)
        UANISO0(1,3) = LMAT(5,IDOM)
        UANISO0(2,3) = LMAT(6,IDOM)
        UANISO0(2,1) = UANISO0(1,2)
        UANISO0(3,1) = UANISO0(1,3)
        UANISO0(3,2) = UANISO0(2,3)
        CALL SSYEV_MO('V','U',3,UANISO0,3,EVALUE,WORK,LWORK,INFO)
        EVALUE(1) = AMAX1(0.0,EVALUE(1))
        EVALUE(2) = AMAX1(0.0,EVALUE(2))
        EVALUE(3) = AMAX1(0.0,EVALUE(3))
        CALL EIGEN2U(EVALUE,UANISO0,UANISO1)
        DO    I=1,6
          LMAT(I,IDOM) = UANISO1(I)
        ENDDO
      ENDDO
C
      RETURN
      END
C
      SUBROUTINE ADD_CONDITIONS_TLS(NMAX20,NTLS20,NTLS,GX,HX,
     &             WORKSPACE,NWORKSPACE)
      IMPLICIT NONE
C
C---Add conditions to TLS. Current conditions are only trace over
C---translational parameters of TLS groups is equal 0. Overall B will be 
C---handled with scale and later with individual atomic refinement.
C
      INTEGER NMAX20,NTLS20,NTLS,NWORKSPACE
      REAL*8 GX(NMAX20),HX(NMAX20,NMAX20)
      REAL*8 WORKSPACE(*)
C
C---Local vriables
      INTEGER I,J,I1
      REAL GSAVE
C---
      IF(NWORKSPACE.LT.2*NTLS20) THEN
        CALL ERRWRT(1,'Not enough space for ADD_CONDITIONS_TLS')
      ENDIF
      DO  I=1,NTLS20
        WORKSPACE(I) = 0.0D0
        WORKSPACE(NTLS20+I) = HX(1,I)
      ENDDO
      DO   I=1,NTLS
         I1 = 20*(I-1)
         WORKSPACE(I1+1) = -1.0D0
         WORKSPACE(I1+2) = -1.0D0
         WORKSPACE(I1+3) = -1.0D0
      ENDDO
      GSAVE = GX(1)
      DO   I=1,NTLS20
        GX(I) = GX(I) + WORKSPACE(I)*GSAVE
        DO   J=1,NTLS20
           HX(I,J) = HX(I,J) + WORKSPACE(NTLS20+I)*WORKSPACE(J)+
     &                         WORKSPACE(NTLS20+J)*WORKSPACE(I)+
     &                   WORKSPACE(NTLS20+1)*WORKSPACE(I)*WORKSPACE(J)
        ENDDO
      ENDDO

      return
      END
C
      SUBROUTINE TLS_INIT
C
C--Defines groups according to read parameters
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'const.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'tls.fh'

C
C---Local variables
      CHARACTER ATNMP*8,CHNNMP*4,TLSFIL*200,LINE*200
      INTEGER   IDOM
      REAL      RNUMTLSGRP(MAXTLSGRP),UANISO_ORT(6),UANISO_CELL(6)
      LOGICAL   LTLSSET(MAXTLSGRP)

C---Initialisations
      DO   IA=1,N_ATOM
        XORT0(1,IA) = XYZ_CRD(1,IA)
        XORT0(2,IA) = XYZ_CRD(2,IA)
        XORT0(3,IA) = XYZ_CRD(3,IA)
        DO    I=1,6
          UANISO_OLD(I,IA) = U_ANISO(I,IA)
        ENDDO
      ENDDO
C      
      T_REMAIN = 0.0
      DO IDOM=1,MAXTLSGRP
        DO I = 1,6
          TMAT(I,IDOM) = 0.0
          LMAT(I,IDOM) = 0.0
        ENDDO
        DO I = 1,8
          SMAT(I,IDOM) = 0.0
        ENDDO
        DO I = 1,3
          TLSORIGIN(I,IDOM) = 0.0
        ENDDO
        RNUMTLSGRP(IDOM) = 0.0
        LTLSSET(IDOM) = .FALSE.
      ENDDO

C---If TLSIN defined, read parameters in
      CALL UGTENV('TLSIN',TLSFIL)
      IF (TLSFIL.NE.' ') CALL READ_TLS_FILE

C  Move the NTLSGRP count here 
      NTLSGRP = 0
      DO   II=1,MAXTLSGRP
        IF(ITLSGRP_PIECES(II).GT.0) NTLSGRP = NTLSGRP+1
      ENDDO

      IF(NTLSGRP.GT.0) THEN
C---Set IGROUP(IA) for each atom based on input residue ranges 
C   and atom selection1
        DO   IA = 1,N_ATOM
          ATNMP      = ATM_NAME_INP(IA)
          call get_chain_namepdb(chnnmp,i_resid(ia))
c          IF(REFID.EQ.'UNRE') THEN
c            CHNNMP = RES_NUM_PDB(I_RESID(IA))(1:1)
c          ELSE
c            CHNNMP = ASM_GROUP_ID(I_CHAIN(I_RESID(IA)))(1:1)
c          ENDIF

          READ(RES_NUM_PDB(I_RESID(IA))(3:6),*)JRS
          IGROUP(IA) = 0
C---Loop over TLS groups
c---Is this atom refinable. It should be moved to another place.
          DO IDOM=1,NTLSGRP
            IF(ITLSGRP_PIECES(IDOM).GT.0) THEN
              IPIECE = ITLSGRP_PIECES(IDOM)
C---Loop over pieces of TLS group
              DO IP1 = 1,IPIECE
                IF(CHNNMP.EQ.TLSGRP_CHN(IP1,IDOM).AND.
     +                    JRS.GE.ITLSGRP_FROM(IP1,IDOM).AND.
     +                    JRS.LE.ITLSGRP_TO(IP1,IDOM)) THEN
C---Loop over atom selections for this piece
C   Allow atom names (char*3), 'ALL', 'MNC', 'SDC'
                  DO ISEL=1,MAXSELECT
                    IF (TLSGRP_SELECT(ISEL,IP1,IDOM).EQ.'ALL') THEN
                       IGROUP(IA)        = IDOM
                       GOTO 10
                     ELSEIF (TLSGRP_SELECT(ISEL,IP1,IDOM).EQ.'MNC' .AND.
     +                  (ATNMP(1:2).EQ.'CA'.OR.ATNMP(1:2).EQ.'N '.OR.
     +                   ATNMP(1:2).EQ.'C '.OR.ATNMP(1:2).EQ.'O ')) THEN
                        IGROUP(IA)       = IDOM
                       GOTO 10
                    ELSEIF (TLSGRP_SELECT(ISEL,IP1,IDOM).EQ.'SDC' .AND.
     +                 (ATNMP(1:2).NE.'CA'.AND.ATNMP(1:2).NE.'N '.AND.
     +                  ATNMP(1:2).NE.'C '.AND.ATNMP(1:2).NE.'O ')) THEN
                      IGROUP(IA)        = IDOM
                      GOTO 10
                    ELSEIF (TLSGRP_SELECT(ISEL,IP1,IDOM).EQ.
     &                                        ATNMP(1:4)) THEN
                      IGROUP(IA)        = IDOM
                      GOTO 10
                    ENDIF
                  ENDDO
                ENDIF
              ENDDO
            ENDIF
          ENDDO
 10       CONTINUE
        ENDDO
      ELSE
C---If no groups set up yet, default is whole molecule
        NTLSGRP           = 1
        ITLSGRP_PIECES(1) = 1
        DO   IA=1,N_ATOM
           IGROUP(IA)        = 1
        ENDDO
      ENDIF
      IA1 = 0
      DO   IA=1,N_ATOM
        
        IF(OCCUP(IA).GT.0.0.AND.
     &        (CS_ELEMENT(ID_SF(IA)).NE.'H   '.OR.
     &         CS_ELEMENT(ID_SF(IA)).NE.'H-1  ')) THEN
          IA1 = IA1 + 1
          ATOM_REF_FLAG(IA) = IA1*10 + 4
        ELSE IF(OCCUP(IA).GT.0.0.AND.
     &        (CS_ELEMENT(ID_SF(IA)).EQ.'H   '.OR.
     &         CS_ELEMENT(ID_SF(IA)).EQ.'H-1  ')) THEN
          IA1 = IA1 + 1
          ATOM_REF_FLAG(IA) = IA1*10 + 2
        ELSE
           ATOM_REF_FLAG(IA) = 0
        ENDIF
      ENDDO

C---Report TLS Groups
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,' ')
      CALL ERRWRT(-1,'######  TLS Group Definitions ######')
      CALL ERRWRT(-1,' ')
      DO II = 1,NTLSGRP
        WRITE(LINE,'(A,I4,A,I4)')'  Group:',II, 
     +  ':    No. of pieces:',ITLSGRP_PIECES(II)
        CALL ERRWRT(-1,LINE)
        DO III = 1,ITLSGRP_PIECES(II)
         WRITE(LINE,'(A,A,A,2I5)') ' Chain:  ',TLSGRP_CHN(iii,ii),
     +' Span:',ITLSGRP_FROM(III,II),ITLSGRP_TO(III,II)
          CALL ERRWRT(-1,LINE)
        END DO
        CALL ERRWRT(-1,' ')
      END DO

C **** Set origins for TLS groups ****

C---Return TLS group origins in TLSORIGIN

      CALL FIND_TLS_ORIGIN

C **** Set parameter values for TLS groups ****

C---Check if set already
      DO IDOM=1,NTLSGRP
        IF (TMAT(1,IDOM).NE.0.0) LTLSSET(IDOM) = .TRUE.        
      ENDDO 

C---Calculate initial T matrices for groups where not already set
      DO    IA=1,N_ATOM
        IDOM = IGROUP(IA)

        IF(IDOM.GT.0) THEN
          IF(.NOT.LTLSSET(IDOM)) THEN

C---Calculate averages for initial T matrix
C---Isotropic Bs should have been expanded by call to 
C   ALLB S2ANISOU in refmac.f
            Q = OCCUP(IA)
            RNUMTLSGRP(IDOM) = RNUMTLSGRP(IDOM) + Q
          ENDIF
        ENDIF
      ENDDO 

      DO IDOM=1,NTLSGRP

cd        IF(.NOT.LTLSSET(IDOM)) THEN
cd         DO I = 1,6
cd          TMAT(I,IDOM) = TMAT(I,IDOM)/RNUMTLSGRP(IDOM)
cd         ENDDO
cd        ENDIF

C---TLS2ANISOU uses DELxMAT to calculate shift in U_ANISO.
C   In first call, shift is from 0 to xMAT.

        IF (MON_STYLE.NE.'NONE'.AND.PRINT_TLSPARS) THEN
          WRITE(6,'(/,A)') ' Initial TLS parameters '
          WRITE(6,'(/,A,I4,A2,A)') ' TLS group ',IDOM,': ',
     +                    TLSGRP_TITLE(IDOM)
          WRITE(6,'(A11,I3,A4,6F8.3)') ' T tensor (',IDOM,') = ',
     +                    (TMAT(I,IDOM),I=1,6)
          WRITE(6,'(A11,I3,A4,6F8.3)') ' L tensor (',IDOM,') = ',
     +                    (LMAT(I,IDOM)*RTODEG*RTODEG,I=1,6)
          WRITE(6,'(A11,I3,A4,8F8.3)') ' S tensor (',IDOM,') = ',
     +                    (SMAT(I,IDOM)*RTODEG,I=1,8)
        ENDIF
      ENDDO 

      RETURN
      END

      SUBROUTINE READ_TLS_FILE
      IMPLICIT NONE
C---Read TLS parameters from TLSIN
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'tls.fh'

      INTEGER NPARS
      PARAMETER (NPARS = 200)
      CHARACTER*60 OLINE

c---Things for parser
      CHARACTER LINE*256,KEY*4,CVALUE(NPARS)*4
      INTEGER IBEG(NPARS),IEND(NPARS),IDEC(NPARS),ITYP(NPARS),NTOK
      REAL FVALUE(NPARS)
      LOGICAL LEND,LPRINT

      CHARACTER RANGEFROM*20,RANGETO*20,ERRLIN*200
      INTEGER ITLSIN,IFAIL,IGR,IPIECE,ITOK,ISEL,I,LENSTR,IDOM,IP,IDOT
c
      integer ii,itk,ierr
      integer nselect
      character select_atoms(MAXSELECT)*4
      integer ifirst,ilast
      character chnid*4
      EXTERNAL LENSTR

      ITLSIN = 0
      IFAIL = -1
      CALL CCPDPN(ITLSIN,'TLSIN','READONLY','F',0,IFAIL)

      IGR = 0
      DO   ISEL=1,MAXSELECT
        DO  IP=1,MAXPIECES_TLS
          DO  IDOM=1,MAXTLSGRP
            TLSGRP_SELECT(ISEL,IP,IDOM) = ' '
          ENDDO
        ENDDO
      ENDDO
 10   CONTINUE

      LINE = ' '
      READ(ITLSIN,'(A)',END=999) LINE
      IF(LENSTR(LINE).LE.0) GOTO 10
      KEY  = ' '
      NTOK = NPARS
      LPRINT = .TRUE.

      CALL PARSER(KEY,LINE,IBEG,IEND,ITYP,FVALUE,CVALUE,IDEC,NTOK,LEND,
     +            LPRINT)
      call ccpupc(key)
      do  i=1,ntok
         call ccpupc(cvalue(i))
      enddo
      IF(KEY(1:3).EQ.'TLS') THEN
        IGR = IGR + 1
        IF(IGR.GT.MAXTLSGRP) THEN
          WRITE(OLINE,'(A,I5)')
     &      'Too many tls groups. Maximum allowed is ',MAXTLSGRP
          CALL ERRWRT(1,OLINE)
        ENDIF
        TLSGRP_TITLE(IGR) = LINE(5:84)
      ELSEIF(KEY(1:4).EQ.'RANG') THEN
        ITLSGRP_PIECES(IGR) = ITLSGRP_PIECES(IGR) + 1
        IPIECE              = ITLSGRP_PIECES(IGR)
        itk = 2
       call get_range_tls(ntok,itk,ityp,ibeg,iend,line,cvalue,fvalue,
     &       ifirst,ilast,chnid,nselect,select_atoms,ierr)
cd        IF(IEND(2)-IBEG(2) .GT. 19)
cd     +       CALL ERRWRT(1,'Format for TLS RANGE too spread out')
cd        RANGEFROM = LINE (IBEG(2):IEND(2)) 
cd        IDOT = INDEX(RANGEFROM,'.')
cd        IF (IDOT.EQ.0) IDOT = IEND(2) - IBEG(2) + 2
cd        READ(RANGEFROM(2:IDOT-1),*) ITLSGRP_FROM(IPIECE,IGR)
        TLSGRP_CHN(IPIECE,IGR) = chnid
        itlsgrp_from(ipiece,igr)=ifirst
        itlsgrp_to(ipiece,igr) = ilast
        do ii=1,nselect
           tlsgrp_select(ii,ipiece,igr)=select_atoms(ii)
        enddo
cd        IF(IEND(3)-IBEG(3) .GT. 19)
cd     +       CALL ERRWRT(1,'Format for TLS RANGE too spread out')
cd        RANGETO = LINE (IBEG(3):IEND(3))
cd        IDOT = INDEX(RANGETO,'.')
cd        IF (IDOT.EQ.0) IDOT = IEND(3) - IBEG(3) + 2
cd        READ(RANGETO(2:IDOT-1),*) ITLSGRP_TO(IPIECE,IGR)

        IF(ITLSGRP_FROM(IPIECE,IGR).LT.0) ITLSGRP_PIECES(IGR) = -1 
C---Is an atom selection present?
cd        IF (NTOK.GE.4) THEN
cd          DO ITOK=4,NTOK
cd            ISEL=ITOK-3
cd            IF (ISEL.GT.MAXSELECT) THEN
cd              WRITE(ERRLIN,'(A,/,A,I4)') 
cd     +          'Too many atom selections made.',
cd     +          'Maximum allowed: ',MAXSELECT
cd              GOTO 10
cd            ENDIF
cd            TLSGRP_SELECT(ISEL,IPIECE,IGR)=LINE(IBEG(ITOK):IEND(ITOK))
cd          ENDDO
cd        ELSE
cd          TLSGRP_SELECT(1,IPIECE,IGR)='ALL'
cd        ENDIF
      ELSEIF(KEY(1:4).EQ.'ORIG') THEN
        CALL GTNREA(2,3,TLSORIGIN(1,IGR),NTOK,ITYP,FVALUE)
      ELSEIF(KEY.EQ.'T   ') THEN
        CALL GTNREA(2,6,TMAT(1,IGR),NTOK,ITYP,FVALUE)
      ELSEIF(KEY(1:4).EQ.'L   ') THEN
        CALL GTNREA(2,6,LMAT(1,IGR),NTOK,ITYP,FVALUE)
C---TLSIN holds L in units of degrees**2
        DO   I=1,6
          TMAT(I,IGR) = TMAT(I,IGR)
        ENDDO
        DO I = 1,6
          LMAT(I,IGR) = LMAT(I,IGR)*DEGTOR*DEGTOR
        ENDDO
      ELSEIF(KEY.EQ.'S   ') THEN
        CALL GTNREA(2,8,SMAT(1,IGR),NTOK,ITYP,FVALUE)
C---TLSIN holds S in units of degrees*Angstrom
        DO I = 1,8
          SMAT(I,IGR) = SMAT(I,IGR)*DEGTOR
        ENDDO
      ELSE IF(KEY(1:3).EQ.'END') THEN
         GOTO 999
      ENDIF

      GOTO 10
 999  CONTINUE
      CLOSE(ITLSIN)

      RETURN
      END
c
      subroutine get_range_tls(ntok,itk,ityp,ibeg,iend,line,cvalue,
     &     fvalue,ifirst,ilast,chnid,
     &     nselect,select_atoms,ierr)

      implicit none
      include 'atom_com.fh'
      include 'tls.fh'
c
c--inputs
      integer ntok,itk
      integer ityp(*),ibeg(*),iend(*)
      character line*(*)
      character cvalue(*)*4
      real fvalue(*)
c
c---outputs
      integer ierr
      integer nselect
      integer ifirst,ilast
      character chnid*(*)
      character select_atoms(maxselect)*(*)
c
c--locals
      integer itk1,ii
      CHARACTER RANGEFROM*20,RANGETO*20,ERRLIN*200
      INTEGER ITLSIN,IFAIL,IGR,IPIECE,ITOK,ISEL,I,LENSTR,IDOM,IP,IDOT
c
c--body
      itk1 = itk
      if(cvalue(itk).eq.'FROM') then
         call read_fromto1(ntok,itk1,cvalue,line,ibeg,iend,ityp,
     &        fvalue,ifirst,ilast,chnid,ierr)
         itk1 = itk+6
         write(*,*)ifirst,ilast,chnid
         if(itk1.lt.ntok) then
            if(cvalue(itk1).eq.'SELE') then
               do  itok=itk1+1,ntok
                  isel = itok-itk1
                  select_atoms(isel)=line(ibeg(itok):iend(itok))
               enddo
            endif
         else
            isel = 1
            select_atoms(isel) = 'ALL'
         endif
         if(ierr.gt.0) then
            call errwrt(0,'Problem in reading TLS file')
            return
         endif
         tls_output_format = 'F'
      else
         tls_output_format = 'O'
         IF(IEND(2)-IBEG(2) .GT. 19)
     +        CALL ERRWRT(1,'Format for TLS RANGE too spread out')
         RANGEFROM = LINE (IBEG(2):IEND(2)) 
         IDOT = INDEX(RANGEFROM,'.')
         IF (IDOT.EQ.0) IDOT = IEND(2) - IBEG(2) + 2
         READ(RANGEFROM(2:IDOT-1),*) ifirst
         IF(IEND(3)-IBEG(3) .GT. 19)
     +        CALL ERRWRT(1,'Format for TLS RANGE too spread out')
         RANGETO = LINE (IBEG(3):IEND(3))
         IDOT = INDEX(RANGETO,'.')
         IF (IDOT.EQ.0) IDOT = IEND(3) - IBEG(3) + 2
         READ(RANGETO(2:IDOT-1),*) ilast
         chnid = rangefrom(1:1)
C---  Is an atom selection present?        IF (NTOK.GE.4) THEN
         if(ntok.gt.4) then
            DO ITOK=4,NTOK
               isel=ITOK-3
               IF (ISEL.GT.MAXSELECT) THEN
                  WRITE(ERRLIN,'(A,/,A,I4)') 
     +                 'Too many atom selections made.',
     +                 'Maximum allowed: ',MAXSELECT
                  ierr = 1
                  call errwrt(1,errlin)
               ENDIF
               select_atoms(isel) = line(ibeg(itok):iend(itok))
            ENDDO
         ELSE
            isel = 1
            select_atoms(1)='ALL'
         ENDIF
      endif
      nselect = isel
      return
      end

      subroutine write_tls_file
      implicit none
      include 'atom_com.fh'
      include 'tls.fh'

      if(tls_output_format.eq.'F') then
         call write_tls_file2
      else
         call write_tls_file1
      endif
      return
      end
c
      SUBROUTINE WRITE_TLS_FILE1

C---Write TLS parameters to TLSOUT
C   Can be analysed with CCP4 program TLSANL
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'makecif_version.fh'
      INTEGER ITLSOUT,IFAIL,IDOM,III
      CHARACTER RANGEFROM*6,RANGETO*6,LINE*256
      INTEGER LENSTR
      EXTERNAL LENSTR

      ITLSOUT = 0
      IFAIL   = -1
      CALL CCPDPN(ITLSOUT,'TLSOUT','NEW','F',0,IFAIL)

      WRITE(ITLSOUT,'(/,A)') 'REFMAC_'//R_VERSNO

      DO IDOM=1,NTLSGRP

        WRITE(ITLSOUT,'(/,A4,A)') 'TLS ',
     &       TLSGRP_TITLE(IDOM)(1:LENSTR(TLSGRP_TITLE(IDOM)))
        DO III = 1,ITLSGRP_PIECES(IDOM)
          WRITE(RANGEFROM,'(A1,I4,A1)') TLSGRP_CHN(III,IDOM),
     +          ITLSGRP_FROM(III,IDOM),'.'
          WRITE(RANGETO,'(A1,I4,A1)') TLSGRP_CHN(III,IDOM),
     +          ITLSGRP_TO(III,IDOM),'.'

CC  Add in TLSGRP_SELECT
          WRITE(LINE,'(A7,A1,A6,A3,A6,A1)') 'RANGE  ',
     +            '''',RANGEFROM,''' ''',RANGETO,''''


          DO   ISEL = 1,MAXSELECT
            IF(TLSGRP_SELECT(ISEL,III,IDOM).NE.' ') THEN
              LINE = LINE(1:LENSTR(LINE))//' '//
     &             TLSGRP_SELECT(ISEL,III,IDOM)
     &             (1:LENSTR(TLSGRP_SELECT(ISEL,III,IDOM)))

            ENDIF
          ENDDO
          WRITE(ITLSOUT,'(A)')LINE(1:LENSTR(LINE))
        ENDDO
        WRITE(ITLSOUT,'(A7,3F8.3)') 'ORIGIN ',
     +                          (TLSORIGIN(I,IDOM),I=1,3)
        WRITE(ITLSOUT,'(A4,6F8.4)') 'T   ',
     +                          (TMAT(I,IDOM),I=1,6)
        WRITE(ITLSOUT,'(A4,6F8.4)') 'L   ',
     +                          (LMAT(I,IDOM)*RTODEG*RTODEG,I=1,6)
        WRITE(ITLSOUT,'(A4,8F8.4)') 'S   ',
     +                          (SMAT(I,IDOM)*RTODEG,I=1,8)

      ENDDO

      CLOSE(ITLSOUT)

      RETURN
      END
c
      SUBROUTINE WRITE_TLS_FILE2
      implicit none
C---Write TLS parameters to TLSOUT
C   Can be analysed with CCP4 program TLSANL
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'makecif_version.fh'
c
c---locals
      INTEGER ITLSOUT,IFAIL,IDOM,III
      integer i,isel
      CHARACTER RANGEFROM*6,RANGETO*6,LINE*256
c
c---locals
      INTEGER LENSTR
      EXTERNAL LENSTR

      ITLSOUT = 0
      IFAIL   = -1
      CALL CCPDPN(ITLSOUT,'TLSOUT','NEW','F',0,IFAIL)

      WRITE(ITLSOUT,'(/,A)') 'REFMAC_'//R_VERSNO

      DO IDOM=1,NTLSGRP

        WRITE(ITLSOUT,'(/,A4,A)') 'TLS ',
     &       TLSGRP_TITLE(IDOM)(1:LENSTR(TLSGRP_TITLE(IDOM)))
        DO III = 1,ITLSGRP_PIECES(IDOM)
           write(line,'(2A,I5,1x,2A,i5,1x,2A)')'RANGE ','FROM ',
     &          itlsgrp_from(iii,idom),
     &          tlsgrp_chn(iii,idom),
     &          ' TO ',
     &          itlsgrp_to(iii,idom),
     &          tlsgrp_chn(iii,idom),
     &          ' SELECT '
          
          DO   ISEL = 1,MAXSELECT
            IF(TLSGRP_SELECT(ISEL,III,IDOM).NE.' ') THEN
              LINE = LINE(1:LENSTR(LINE))//' '//
     &             TLSGRP_SELECT(ISEL,III,IDOM)
     &             (1:LENSTR(TLSGRP_SELECT(ISEL,III,IDOM)))

            ENDIF
          ENDDO
          WRITE(ITLSOUT,'(A)')LINE(1:LENSTR(LINE))
        ENDDO
        WRITE(ITLSOUT,'(A7,3F8.3)') 'ORIGIN ',
     +                          (TLSORIGIN(I,IDOM),I=1,3)
        WRITE(ITLSOUT,'(A4,6F8.4)') 'T   ',
     +                          (TMAT(I,IDOM),I=1,6)
        WRITE(ITLSOUT,'(A4,6F8.4)') 'L   ',
     +                          (LMAT(I,IDOM)*RTODEG*RTODEG,I=1,6)
        WRITE(ITLSOUT,'(A4,8F8.4)') 'S   ',
     +                          (SMAT(I,IDOM)*RTODEG,I=1,8)

      ENDDO

      CLOSE(ITLSOUT)

      RETURN
      END
c
      SUBROUTINE TLS2ANISOU(LINITIAL)
      IMPLICIT NONE
C---Derive aniso-U from TLS tensors
C   These are held in U_ANISO(MAXATOM,6) in A**2 but w.r.t. crystallographic
C   axes.
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'refi_flags.fh'

      REAL UANISO_ORT(6),X,Y,Z
      INTEGER IA,I,IANISO,IDOM
      INTEGER LWORK,INFO
      REAL UANISO0(3,3),UANISO1(6),EVALUE(6),WORKSPACE(100)
      LOGICAL LINITIAL,LRECALC

      LWORK = 100
 100  CONTINUE
C
C--May need to be removed
C
cd      CALL CALC_AMAT
      DO    IA=1,N_ATOM
        IF(ATOM_REF_FLAG(IA).GT.0) THEN
        IDOM = IGROUP(IA)

        IF(IDOM.GT.0.AND.OCCUP(IA).GT.0.0) THEN
          X = XORT0(1,IA)
          Y = XORT0(2,IA)
          Z = XORT0(3,IA)

C---Transfer to UANISO_CELL
          IF(UANISO_OLD(2,IA).NE.0.0) THEN
            DO I = 1,6
              UANISO_ORT(I) = UANISO_OLD(I,IA)
            ENDDO
          ELSE
            UANISO_ORT(1) = UANISO_OLD(1,IA)
            UANISO_ORT(2) = UANISO_OLD(1,IA)
            UANISO_ORT(3) = UANISO_OLD(1,IA)
            UANISO_ORT(4) = 0.0
            UANISO_ORT(5) = 0.0
            UANISO_ORT(6) = 0.0
          ENDIF

C---In the first call, the initial U_ANISO comes from XYZIN B factor
C   which contains contributions from individual factors and TLS parameters.
C   I.e. we start off with the correct isotropic value, which we preserve
C   while adding anisotropic component from initial TLS.
cd         IF (LINITIAL) 
cd     +    BISOOLD = (UANISO_ORT(1)+UANISO_ORT(2)+UANISO_ORT(3))/3.0

C---Symmetric tensors are in the order (1,1),(2,2),(3,3),(1,2),(1,3),(2,3)
C---The S tensor is in the order 
C   (2,2)-(1,1),(1,1)-(3,3),(1,2),(1,3),(2,3),(2,1),(3,1),(3,2)
C   Beware! RESTRAIN has different order.

C---If atom included in TLS analysis, derive U tensor in orthogonal units
C   See Table 2 of Schomaker and Trueblood
          UANISO_ORT(1) = UANISO_ORT(1) + TMAT(1,IDOM) + 
     +      LMAT(2,IDOM)*Z**2 + LMAT(3,IDOM)*Y**2 -
     +      2.0*LMAT(6,IDOM)*Y*Z +
     +      2.0*SMAT(6,IDOM)*Z - 2.0*SMAT(7,IDOM)*Y
          UANISO_ORT(2) = UANISO_ORT(2) + TMAT(2,IDOM) + 
     +      LMAT(3,IDOM)*X**2 + LMAT(1,IDOM)*Z**2 -
     +      2.0*LMAT(5,IDOM)*Z*X +
     +      2.0*SMAT(8,IDOM)*X - 2.0*SMAT(3,IDOM)*Z
          UANISO_ORT(3) = UANISO_ORT(3) + TMAT(3,IDOM) + 
     +      LMAT(1,IDOM)*Y**2 + LMAT(2,IDOM)*X**2 -
     +      2.0*LMAT(4,IDOM)*X*Y +
     +      2.0*SMAT(4,IDOM)*Y - 2.0*SMAT(5,IDOM)*X
          UANISO_ORT(4) = UANISO_ORT(4) + TMAT(4,IDOM) - 
     +      LMAT(4,IDOM)*Z**2 + LMAT(5,IDOM)*Y*Z +
     +      LMAT(6,IDOM)*X*Z - LMAT(3,IDOM)*X*Y +
     +      SMAT(7,IDOM)*X - SMAT(8,IDOM)*Y +
     +      SMAT(1,IDOM)*Z
          UANISO_ORT(5) = UANISO_ORT(5) + TMAT(5,IDOM) - 
     +      LMAT(5,IDOM)*Y**2 + LMAT(4,IDOM)*Y*Z +
     +      LMAT(6,IDOM)*X*Y - LMAT(2,IDOM)*X*Z +
     +      SMAT(5,IDOM)*Z - SMAT(6,IDOM)*X +
     +      SMAT(2,IDOM)*Y
          UANISO_ORT(6) = UANISO_ORT(6) + TMAT(6,IDOM) - 
     +      LMAT(6,IDOM)*X**2 + LMAT(5,IDOM)*Y*X +
     +      LMAT(4,IDOM)*X*Z - LMAT(1,IDOM)*Z*Y +
     +      SMAT(3,IDOM)*Y - SMAT(4,IDOM)*Z -
     +      (SMAT(1,IDOM) + SMAT(2,IDOM))*X

C---In the first call, restore correct isotropic component.
cd          IF (LINITIAL) THEN
cd           BISONEW = (UANISO_ORT(1)+UANISO_ORT(2)+UANISO_ORT(3))/3.0
cd           UANISO_ORT(1) = UANISO_ORT(1) - BISONEW + BISOOLD
cd           UANISO_ORT(2) = UANISO_ORT(2) - BISONEW + BISOOLD
cd           UANISO_ORT(3) = UANISO_ORT(3) - BISONEW + BISOOLD
cd          ENDIF

C
C---Make U vlues positive
                UANISO0(1,1) = UANISO_ORT(1)
                UANISO0(2,2) = UANISO_ORT(2)
                UANISO0(3,3) = UANISO_ORT(3)
                UANISO0(1,2) = UANISO_ORT(4)
                UANISO0(1,3) = UANISO_ORT(5)
                UANISO0(2,3) = UANISO_ORT(6)
                UANISO0(2,1) = UANISO0(1,2)
                UANISO0(3,1) = UANISO0(1,3)
                UANISO0(3,2) = UANISO0(2,3)
                CALL SSYEV_MO('V','U',3,UANISO0,3,EVALUE,WORKSPACE,
     &                          LWORK,INFO)
cd                IF(EVALUE(1).LT.BResetMin.OR.EVALUE(2).LT.BResetMin.OR.
cd     &             EVALUE(3).LT.BResetMin.OR.EVALUE(1).GT.BResetMax.OR.
cd     &             EVALUE(2).GT.BResetMax.OR.EVALUE(3).GT.BResetMAX) 
cd     &                                   THEN
cd                  EVALUE(1)=AMAX1(BResetMin,AMIN1(BResetMax,EVALUE(1)))
cd                  EVALUE(2)=AMAX1(BResetMin,AMIN1(BResetMax,EVALUE(2)))
cd                  EVALUE(3)=AMAX1(BResetMin,AMIN1(BResetMax,EVALUE(3)))
                  CALL EIGEN2U(EVALUE,UANISO0,UANISO1)
                  DO    IANISO=1,6
                    U_ANISO(IANISO,IA) = UANISO_ORT(IANISO)
                  ENDDO
cd                ENDIF
C---Transfer to U_ANISO 
cd          DO I = 1,6
cd            U_ANISO(I,IA) = UANISO_ORT(I)
cd          ENDDO
        ELSE
cd          DO  I=1,6
cd            U_ANISO(I,IA) = UANISO_OLD(I,IA)
cd          ENDDO
C
          IF(UANISO_OLD(2,IA).EQ.0.0) THEN
            UANISO_OLD(1,IA) = UANISO_OLD(1,IA)
            U_ANISO(1,IA) = UANISO_OLD(1,IA)
          ELSE
            DO   I=1,6
              IF(I.LE.3) UANISO_OLD(I,IA) = UANISO_OLD(I,IA)
              U_ANISO(I,IA) = UANISO_OLD(I,IA)

            ENDDO
          ENDIF
        ENDIF
        ENDIF
      ENDDO
C
C---Check positive definite
C
      LRECALC = .FALSE.
      IF (LRECALC) THEN
        DO IDOM=1,NTLSGRP
          IF (PRINT_TLSPARS) THEN
           WRITE(6,'(/,A,I4,A2,A)') ' TLS group ',IDOM,': ',
     +                    TLSGRP_TITLE(IDOM)
           WRITE(6,'(A11,I3,A4,6F8.3)') 'T tensor (',IDOM,') = ',
     +                    (TMAT(I,IDOM),I=1,6)
           WRITE(6,'(A11,I3,A4,6F8.3)') 'L tensor (',IDOM,') = ',
     +                    (LMAT(I,IDOM)*RTODEG*RTODEG,I=1,6)
           WRITE(6,'(A11,I3,A4,9F8.3)') 'S tensor (',IDOM,') = ',
     +                    (SMAT(I,IDOM)*RTODEG,I=1,8)
          ENDIF
        ENDDO
        LINITIAL = .FALSE.
cd        GOTO 100
      ENDIF

      RETURN
      END
C
      SUBROUTINE ADD_SCALE_CONTR
C
c---Adds contribution of scaling (isotropic u values) to individual U 
C---values
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'const.fh'
C
      INTEGER IA
C
      DO   IA=1,N_ATOM
        IF(ATOM_REF_FLAG(IA).GT.0) THEN
        IF(U_ANISO(2,IA).LE.0.0) THEN
           U_ANISO(1,IA) = U_ANISO(1,IA) + UOVER_ATOM
        ELSE
           U_ANISO(1,IA) = U_ANISO(1,IA) + UOVER_ATOM
           U_ANISO(2,IA) = U_ANISO(2,IA) + UOVER_ATOM
           U_ANISO(3,IA) = U_ANISO(3,IA) + UOVER_ATOM
        ENDIF
C
        IF(UANISO_OLD(2,IA).LE.0.0) THEN
           UANISO_OLD(1,IA) = UANISO_OLD(1,IA) + UOVER_ATOM
        ELSE
           UANISO_OLD(1,IA) = UANISO_OLD(1,IA) + UOVER_ATOM
           UANISO_OLD(2,IA) = UANISO_OLD(2,IA) + UOVER_ATOM
           UANISO_OLD(3,IA) = UANISO_OLD(3,IA) + UOVER_ATOM
        ENDIF

        ENDIF
      ENDDO
      UOVER_ATOM = 0.0
      RETURN
      END
C
      SUBROUTINE MAKE_U_POSITIVE
C
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'const.fh'

      INTEGER IA
      REAL U_MIN,UEIGEN
C
      U_MIN = 1.0E32
      DO   IA=1,N_ATOM
        IF(OCCUP(IA).GT.0.0) THEN
          IF(ATOM_REF_FLAG(IA).GT.0) THEN
            IF(U_ANISO(2,IA).LE.0.0) THEN
              U_MIN = AMIN1(U_MIN,U_ANISO(1,IA))
            ELSE
              CALL FIND_MIN_EIGEN(U_ANISO(1,IA),UEIGEN)
              U_MIN = AMIN1(U_MIN,UEIGEN)
            ENDIF
          ENDIF
        ENDIF
      ENDDO
C
      IF(U_MIN.LT.BResetMin) THEN
        WRITE(*,*)'Problem in MAKE_U_POSITIVE',U_MIN,BResetMin
        DO   IA=1,N_ATOM
          IF(ATOM_REF_FLAG(IA).GT.0) THEN
            IF(U_ANISO(2,IA).EQ.0.0) THEN
              U_ANISO(1,IA) = U_ANISO(1,IA) + BResetMin - U_MIN
            ELSE
              U_ANISO(1,IA) = U_ANISO(1,IA) + BResetMin - U_MIN
              U_ANISO(2,IA) = U_ANISO(2,IA) + BResetMin - U_MIN
              U_ANISO(3,IA) = U_ANISO(3,IA) + BResetMin - U_MIN
            ENDIF
          ENDIF
        ENDDO
cd        UOVER_ATOM = UOVER_ATOM - BResetMin + U_MIN
cd        B_LS_OVER = B_LS_OVER0 + (BResetMin-U_MIN)*PISQ8
      ENDIF

      RETURN
      END
C
      SUBROUTINE CHECK_POSDEF_US(LRECALC)

      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'const.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'celsym_aniso.fh'
      INCLUDE 'tls.fh'


      INTEGER IDOM
      LOGICAL LRECALC,ERROR
      REAL UANISO0(6),UANISO1(6),EVECTOR(9)

      LRECALC = .FALSE.

      BMIN_LOCAL = 1.0E32
      DO    IA=1,N_ATOM
        IF(U_ANISO(2,IA).NE.0.0) THEN
          CALL FIND_MIN_EIGEN(U_ANISO(1,IA),EIGEN_MIN)
          BMIN_LOCAL = AMIN1(BMIN_LOCAL,EIGEN_MIN)
        ELSE
           BMIN_LOCAL = AMIN1(BMIN_LOCAL,U_ANISO(1,IA))
        ENDIF
      ENDDO

      IF(BMIN_LOCAL.LT.BResetMin) THEN
cd        CALL ERRWRT(1,'We are here')
        DO    IDOM=1,NTLSGRP
          DO   I=1,3
            TMAT(I,IDOM) = TMAT(I,IDOM) + BResetMin - BMIN_LOCAL
          ENDDO
        ENDDO
        DO    IA=1,N_ATOM
cd          IF(IGROUP(IA).LE.0) THEN
            IF(U_ANISO(2,IA).NE.0.0) THEN
              DO   I=1,3
                U_ANISO(I,IA) = U_ANISO(I,IA)+BResetMin-BMIN_LOCAL
              ENDDO
            ELSE
              U_ANISO(1,IA) = U_ANISO(1,IA)+BResetMin-BMIN_LOCAL
            ENDIF
cd          ENDIF
        ENDDO
      ENDIF

      RETURN
      END

      SUBROUTINE CALC_AMAT

C---Calculates A matrices for particular set of orthogonal coordinates
C   obtained from XORT0(3,MAXATOM). Elements of A are orthogonal coordinates
C   w.r.t. TLS orgins, and are placed back in XORT0(3,MAXATOM).

C   Changing origin or equivalently XORT0 shouldn't affect converged values
C   of U, but does change corresponding values of T and S.
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'tls.fh'



      DO    IA = 1,N_ATOM
         ITLSGRP = IGROUP(IA)
         IF(ITLSGRP.GT.0) THEN
           DO   IX=1,3
C
C
             XORT0(IX,IA) = XORT0(IX,IA)-TLSORIGIN(IX,ITLSGRP)
           ENDDO
         ENDIF
      ENDDO

      RETURN
      END
       
      SUBROUTINE FIND_TLS_ORIGIN
C
C---Finds origin of each TLS group as centroid of atoms.
      INCLUDE 'atom_com.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'tls.fh'


      REAL QATOM(MAXTLSGRP)
      LOGICAL LORIGINSET(MAXTLSGRP)

      DO ITLSGRP = 1,NTLSGRP
        QATOM(ITLSGRP) = 0.0
        IF (TLSORIGIN(1,ITLSGRP).EQ.0.0) THEN
          LORIGINSET(ITLSGRP) = .FALSE.
          WRITE(6,'(/,A,I2,A,/)') 'Calculating TLS origin of group ',
     +                              ITLSGRP,' from centroid of group.'
        ELSE
          LORIGINSET(ITLSGRP) = .TRUE.
        ENDIF
      ENDDO
      DO    IA=1,N_ATOM
        ITLSGRP  = IGROUP(IA)
        IF(ITLSGRP.GT.0) THEN 
          IF(.NOT.LORIGINSET(ITLSGRP)) THEN
            DO    IX=1,3
              TLSORIGIN(IX,ITLSGRP) = TLSORIGIN(IX,ITLSGRP) +
     +                                       XORT0(IX,IA)*OCCUP(IA)
            ENDDO
            QATOM(ITLSGRP) = QATOM(ITLSGRP) + OCCUP(IA)
          ENDIF
        ENDIF
      ENDDO

      DO    ITLSGRP = 1,NTLSGRP
        IF(QATOM(ITLSGRP).GT.0.0 .AND. .NOT.LORIGINSET(ITLSGRP)) THEN
          DO   IX=1,3
            TLSORIGIN(IX,ITLSGRP)=TLSORIGIN(IX,ITLSGRP)/QATOM(ITLSGRP)
          ENDDO
        ENDIF
      ENDDO
      DO ITLSGRP = 1,NTLSGRP
        write(6,*) 'TLS origin for group ',ITLSGRP,
     +                           (TLSORIGIN(IX,ITLSGRP),IX=1,3)
      ENDDO

      RETURN
      END

      SUBROUTINE DERIVS_OF_TLS
C
C---Calculates derivatives of minimised function wrt TLS parameters.
C---using chain rule. 
C
C--- 1) Neglects second derivatives of U, but U linear in TLS.
C--- 2) Only diagonal terms w.r.t. atoms of second derivative of function 
C     wrt U are used. But HUU doesn't contain off-diagonal terms.
C--- 3) No cross-derivatives w.r.t. different TLS groups are included.
C     But these would need terms of 2) which aren't available.
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'tls.fh'
      INCLUDE 'restr_files.fh'
      INCLUDE 'refi_flags.fh'


      REAL DUDTLSGRP(6,20),DUDTLSGRP1(6,20),DUDTLSGRP2(6,20)

      INTEGER  NS_DIST(4)
  
      COMMON /REF_SPG/ GX,GU1,GQ
      REAL  GX(3*MAXATOM),GQ(MAXATOM),GU1(6*MAXATOM)
C
      REAL H_XX(3,3),H_UU(6,6),H_QQ,H_XB(3),H_XU(3,6),H_XQ(3),H_QX(3),  
     &     H_BQ,H_QB,H_UQ(6),H_QU(6)
C
cd      REAL HXX(6*MAXATOM),HUU(21*MAXATOM),HQQ(MAXATOM),HQU(6*MAXATOM)
cd      COMMON /REF_SEC/HXX,HUU,HQQ,HQU
C
      INTEGER IA,IA1,IA2,IA11,IA12,IA21,IA22
      REAL HX2DR(6)
      REAL H_XDD,H_UUD(3),H_UQD,H_QQD
C
C---Initialise
      DO    IPAR=1,MAXTLSGRP20
        GX_TLS(IPAR) = 0.0D0
        DO    IPAR1=1,MAXTLSGRP20
          HX_TLS(IPAR,IPAR1) = 0.0D0
        ENDDO
      ENDDO
C
C---Calculate derivatives of minimised function wrt tlsgrp
C---parameters using chain rule. 
      IU   = 1
      IUU  = 1
      DO   IA=1,N_ATOM
        IF(ATOM_REF_FLAG(IA).GT.0) THEN
          ITLSGRP = IGROUP(IA)
          IA11 = ATOM_REF_FLAG(IA)/10
          IA21 = ATOM_REF_FLAG(IA) - IA11*10
          IF(ITLSGRP.GT.0.AND.IA21.GT.2) THEN
            CALL DERIVS_WRT_TLSPARS(IA,DUDTLSGRP)
            CALL FAST_HESSIAN_DIAGONAL(IA,H_XXD,H_UUD,H_UQD,H_QQD)  

            IPAR0   = 20*ITLSGRP-20
            DO   IPAR = 1,20
              IPAR0 = IPAR0 + 1
              GX_TLS(IPAR0) = GX_TLS(IPAR0)+
     +                         (GU1(IU)*DUDTLSGRP(1,IPAR)+
     +                          GU1(IU+1)*DUDTLSGRP(2,IPAR)+
     +                          GU1(IU+2)*DUDTLSGRP(3,IPAR)+
     +                          GU1(IU+3)*DUDTLSGRP(4,IPAR)+
     +                          GU1(IU+4)*DUDTLSGRP(5,IPAR)+
     +                          GU1(IU+5)*DUDTLSGRP(6,IPAR))
              IPAR10 = 20*ITLSGRP-20
              DO   IPAR1 = 1,20
                IPAR10 = IPAR10 + 1
C---First contribution: diagonal HUU elements
cd                HX_TLS(IPAR0,IPAR10) = HX_TLS(IPAR0,IPAR10) +
cd     +                           (HUU(IUU)*DUDTLSGRP(1,IPAR)*
cd     +                                    DUDTLSGRP(1,IPAR1)+
cd     +                          HUU(IUU+1)*DUDTLSGRP(2,IPAR)*
cd     +                                    DUDTLSGRP(2,IPAR1)+
cd     +                          HUU(IUU+2)*DUDTLSGRP(3,IPAR)*
cd     +                                    DUDTLSGRP(3,IPAR1)+
cd     +                          HUU(IUU+3)*DUDTLSGRP(4,IPAR)*
c     +                                    DUDTLSGRP(4,IPAR1)+
cd d    +                          HUU(IUU+4)*DUDTLSGRP(5,IPAR)*
cd     +                                    DUDTLSGRP(5,IPAR1)+
cd     +                          HUU(IUU+5)*DUDTLSGRP(6,IPAR)*
cd     +                                    DUDTLSGRP(6,IPAR1))

C---Second contribution: off-diagonal HUU elements
cd                HX_TLS(IPAR0,IPAR10) = HX_TLS(IPAR0,IPAR10) + (
cd     +          HUU(IUU+6) *(DUDTLSGRP(1,IPAR)*DUDTLSGRP(2,IPAR1) +
cd     +                      DUDTLSGRP(2,IPAR)*DUDTLSGRP(1,IPAR1)) +
cd     +          HUU(IUU+7) *(DUDTLSGRP(1,IPAR)*DUDTLSGRP(3,IPAR1) +
cd     +                      DUDTLSGRP(3,IPAR)*DUDTLSGRP(1,IPAR1)) +
cd     +          HUU(IUU+8) *(DUDTLSGRP(1,IPAR)*DUDTLSGRP(4,IPAR1) +
cd     +                      DUDTLSGRP(4,IPAR)*DUDTLSGRP(1,IPAR1)) +
cd     +          HUU(IUU+9) *(DUDTLSGRP(1,IPAR)*DUDTLSGRP(5,IPAR1) +
cd     +                      DUDTLSGRP(5,IPAR)*DUDTLSGRP(1,IPAR1)) +
cd     +          HUU(IUU+10)*(DUDTLSGRP(1,IPAR)*DUDTLSGRP(6,IPAR1) +
cd     +                      DUDTLSGRP(6,IPAR)*DUDTLSGRP(1,IPAR1)) +
cd     +          HUU(IUU+11)*(DUDTLSGRP(2,IPAR)*DUDTLSGRP(3,IPAR1) +
cd     +                      DUDTLSGRP(3,IPAR)*DUDTLSGRP(2,IPAR1)) +
cd     +          HUU(IUU+12)*(DUDTLSGRP(2,IPAR)*DUDTLSGRP(4,IPAR1) +
cd     +                      DUDTLSGRP(4,IPAR)*DUDTLSGRP(2,IPAR1)) +
cd     +          HUU(IUU+13)*(DUDTLSGRP(2,IPAR)*DUDTLSGRP(5,IPAR1) +
cd     +                      DUDTLSGRP(5,IPAR)*DUDTLSGRP(2,IPAR1)) +
c     +          HUU(IUU+14)*(DUDTLSGRP(2,IPAR)*DUDTLSGRP(6,IPAR1) +
cd d    +                      DUDTLSGRP(6,IPAR)*DUDTLSGRP(2,IPAR1)) +
cd     +          HUU(IUU+15)*(DUDTLSGRP(3,IPAR)*DUDTLSGRP(4,IPAR1) +
cd     +                      DUDTLSGRP(4,IPAR)*DUDTLSGRP(3,IPAR1)) +
cd     +          HUU(IUU+16)*(DUDTLSGRP(3,IPAR)*DUDTLSGRP(5,IPAR1) +
cd     +                      DUDTLSGRP(5,IPAR)*DUDTLSGRP(3,IPAR1)) +
cd     +          HUU(IUU+17)*(DUDTLSGRP(3,IPAR)*DUDTLSGRP(6,IPAR1) +
cd     +                      DUDTLSGRP(6,IPAR)*DUDTLSGRP(3,IPAR1)) +
cd     +          HUU(IUU+18)*(DUDTLSGRP(4,IPAR)*DUDTLSGRP(5,IPAR1) +
cd     +                      DUDTLSGRP(5,IPAR)*DUDTLSGRP(4,IPAR1)) +
cd     +          HUU(IUU+19)*(DUDTLSGRP(4,IPAR)*DUDTLSGRP(6,IPAR1) +
cd     +                      DUDTLSGRP(6,IPAR)*DUDTLSGRP(4,IPAR1)) +
cd     +          HUU(IUU+20)*(DUDTLSGRP(5,IPAR)*DUDTLSGRP(6,IPAR1) +
cd     +                      DUDTLSGRP(6,IPAR)*DUDTLSGRP(5,IPAR1)))

C---First contribution: diagonal HUU elements
                HX_TLS(IPAR0,IPAR10) = HX_TLS(IPAR0,IPAR10) + 
     +                           (H_UUD(1)*DUDTLSGRP(1,IPAR)*
     +                                     DUDTLSGRP(1,IPAR1)+
     +                            H_UUD(1)*DUDTLSGRP(2,IPAR)*
     +                                     DUDTLSGRP(2,IPAR1)+
     +                            H_UUD(1)*DUDTLSGRP(3,IPAR)*
     +                                     DUDTLSGRP(3,IPAR1)+
     +                            H_UUD(3)*DUDTLSGRP(4,IPAR)*
     +                                     DUDTLSGRP(4,IPAR1)+
     +                            H_UUD(3)*DUDTLSGRP(5,IPAR)*
     +                                     DUDTLSGRP(5,IPAR1)+
     +                            H_UUD(3)*DUDTLSGRP(6,IPAR)*
     +                                     DUDTLSGRP(6,IPAR1))

C---Second contribution: off-diagonal HUU elements
                HX_TLS(IPAR0,IPAR10) = HX_TLS(IPAR0,IPAR10) + (
     +           H_UUD(2)*(DUDTLSGRP(1,IPAR)*DUDTLSGRP(2,IPAR1) +
     +                     DUDTLSGRP(2,IPAR)*DUDTLSGRP(1,IPAR1)) +
     +           H_UUD(2)*(DUDTLSGRP(1,IPAR)*DUDTLSGRP(3,IPAR1) +
     +                     DUDTLSGRP(3,IPAR)*DUDTLSGRP(1,IPAR1)) +
     +           H_UUD(2)*(DUDTLSGRP(2,IPAR)*DUDTLSGRP(3,IPAR1) +
     +                     DUDTLSGRP(3,IPAR)*DUDTLSGRP(2,IPAR1)))
              ENDDO
            ENDDO
          ENDIF
          IF(U_ANISO(2,IA).LE.0.0) THEN
            IU  = IU  + 1
            IUU = IUU + 1
          ELSE
            IU  = IU  + 6
            IUU = IUU + 21
          ENDIF
        ENDIF
      ENDDO
C
C---Add non-diag conributions
cd      goto 999
cd      return
      IF(.NOT.XNONDIAG_FLAG) RETURN
      IF(LENSTR(VDW_FILE_0).LE.0) RETURN
      ISCRV          = 0
      IFAIL          = -1
      CALL CCPDPN(ISCRV,VDW_FILE_0(1:LENSTR(VDW_FILE_0)),'UNKNOWN','U',
     &              LL,IFAIL)
 10   CONTINUE
C
c---If both atoms are in the list of rigid groups
      READ(ISCRV,END=999)IA1,IA2,RS_VIDL,RS_SDI,NS_DIST(1),NS_DIST(2),
     &                   NS_DIST(3),NS_DIST(4),IVDW_TYPE
      IA11 = ATOM_REF_FLAG(IA1)/10
      IA12 = ATOM_REF_FLAG(IA1) - IA11*10
      IA21 = ATOM_REF_FLAG(IA2)/10
      IA22 = ATOM_REF_FLAG(IA2) - IA21*10
      IF(IGROUP(IA1).GT.0.AND.IGROUP(IA2).GT.0.AND.
     &   ATOM_REF_FLAG(IA1).GT.0.AND.ATOM_REF_FLAG(IA2).GT.0.AND.
     &   IA21.GT.2.AND.IA22.GT.2                 ) THEN
        IGR1 = IGROUP(IA1)
        IGR2 = IGROUP(IA2)
        CALL DERIVS_WRT_TLSPARS(IA1,DUDTLSGRP1)
        CALL DERIVS_WRT_TLSPARS(IA2,DUDTLSGRP2)
        CALL FAST_HESSIAN_NONDIAGONAL(IA1,IA2,NS_DIST,
     &    H_XX,H_UU,H_QQ,H_XB,H_XU,H_XQ,H_QX,H_BQ,H_QB,H_UQ,H_QU)
cd        if(ia1.ne.ia2) then
        DO   IRIG1=1,20
          IPAR0 = 20*(IGR1-1) + IRIG1
          CALL MAT2VEC(6,6,H_UU,DUDTLSGRP1(1,IRIG1),HX2DR,ERROR)
          DO   IRIG2=1,20
            IPAR10 = 20*(IGR2-1) + IRIG2
            TMP    = DOT1_R(6,6,HX2DR,DUDTLSGRP2(1,IRIG2))
            HX_TLS(IPAR0,IPAR10) = HX_TLS(IPAR0,IPAR10) + TMP 
cd            IF(IGR1.NE.IGR2) THEN
cd              HX_TLS(IPAR10,IPAR0) = HX_TLS(IPAR10,IPAR0) + TMP
            IF(IA1.NE.IA2) THEN
              HX_TLS(IPAR10,IPAR0) = HX_TLS(IPAR10,IPAR0) + TMP 
            ENDIF
          ENDDO
        ENDDO
cd        endif
      ENDIF
      GOTO 10
 999  CONTINUE
cd      do  irig1=1,ntlsgrp*20-1
cd         do   irig2=irig1+1,ntlsgrp*20
cd            if(hx_tls(irig1,irig2)-hx_tls(irig2,irig1).ne.0.0) then
cd               write(*,*)'disaster',irig1,irig2,
cd     &              hx_tls(irig1,irig2)-hx_tls(irig2,irig1)
cd            endif
cd         enddo
cd      enddo
      CLOSE(ISCRV)
cd      stop
C
      RETURN
      END

      SUBROUTINE DERIVS_WRT_TLSPARS(IA,DUDTLSGRP)
C
C---Calculates derivatives of anisotropic displacement parameters wrt 
C---TLS parameters for atom IA and stores them in DUDTLSGRP

C---cf. RESTRAIN s/r lscalc line 9001
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'tls.fh'

      INTEGER IA
      REAL DUDTLSGRP(6,20)

      REAL X,Y,Z,XX,YY,ZZ,XY,XZ,YZ

      DO   ITLS = 1,20
       DO   IU = 1,6
         DUDTLSGRP(IU,ITLS) = 0.0
       ENDDO
      ENDDO

C---Contribution of T tensor
      DUDTLSGRP(1,1) = 1.0
      DUDTLSGRP(2,2) = 1.0
      DUDTLSGRP(3,3) = 1.0
      DUDTLSGRP(4,4) = 1.0
      DUDTLSGRP(5,5) = 1.0
      DUDTLSGRP(6,6) = 1.0

C---Contribution of L tensor
C   See G in Table 2 of Schomaker and Trueblood
      X = XORT0(1,IA)
      Y = XORT0(2,IA)
      Z = XORT0(3,IA) 
      XX = X**2
      YY = Y**2
      ZZ = Z**2
      XY = X*Y
      XZ = X*Z
      YZ = Y*Z
      DUDTLSGRP(1, 8) = ZZ
      DUDTLSGRP(1, 9) = YY
      DUDTLSGRP(1,12) = -2.0*YZ
      DUDTLSGRP(2, 7) = ZZ
      DUDTLSGRP(2, 9) = XX
      DUDTLSGRP(2,11) = -2.0*XZ
      DUDTLSGRP(3, 7) = YY
      DUDTLSGRP(3, 8) = XX
      DUDTLSGRP(3,10) = -2.0*XY
      DUDTLSGRP(4, 9) = -XY
      DUDTLSGRP(4,10) = -ZZ
      DUDTLSGRP(4,11) = YZ
      DUDTLSGRP(4,12) = XZ
      DUDTLSGRP(5, 8) = -XZ
      DUDTLSGRP(5,10) = YZ
      DUDTLSGRP(5,11) = -YY
      DUDTLSGRP(5,12) = XY
      DUDTLSGRP(6, 7) = -YZ
      DUDTLSGRP(6,10) = XZ
      DUDTLSGRP(6,11) = XY
      DUDTLSGRP(6,12) = -XX

C---Contribution of S tensor
C   See H in Table 2 of Schomaker and Trueblood
      DUDTLSGRP(1,18) = 2.0*Z 
      DUDTLSGRP(1,19) = -2.0*Y
      DUDTLSGRP(2,20) = 2.0*X
      DUDTLSGRP(2,15) = -2.0*Z
      DUDTLSGRP(3,16) = 2.0*Y
      DUDTLSGRP(3,17) = -2.0*X
      DUDTLSGRP(4,19) = X
      DUDTLSGRP(4,20) = -Y
      DUDTLSGRP(4,13) = Z
      DUDTLSGRP(5,17) = Z
      DUDTLSGRP(5,18) = -X
      DUDTLSGRP(5,14) = Y
      DUDTLSGRP(6,15) = Y
      DUDTLSGRP(6,16) = -Z
      DUDTLSGRP(6,13) = -X
      DUDTLSGRP(6,14) = -X

      RETURN
      END

