C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
      SUBROUTINE MIN_QUADR_POLIN(AL0,AL1,F0,F1,DF0,A1,A2,X_MIN)
C
C---Given f(a),f'(a),f(b) a1,a2 finds minimum of quadratic interpolating
C---polynom in the interval (min(a1,a2),max(a1,a2)
      IMPLICIT NONE
      REAL AL0,Al1,F0,F1,DF0,A1,A2,X_MIN
C
      REAL A,B,C,F_X0,F_X1,X0,X1,AL1M0
      REAL DF10,A11,A22,F_A1,F_A2,F_MIN,F_C,X_MIN1
      REAL PUT_IN_INTERVAL
      EXTERNAL PUT_IN_INTERVAL
C
C---If AL0 = AL1 (unlikely case. Calling routine should take care of that)
C---then take neares point in interval (A1,A2) as a minimiser. It does not
C---matter which pont is used
      IF(AL0.EQ.AL1) THEN
        X_MIN = PUT_IN_INTERVAL(A1,A2,AL0)
        RETURN
      ENDIF
C
C---Convert derivative to X = (AL-Al0)/(AL1-AL0), AL0 --> 0.0 AL1 --> 1.0
      AL1M0 = AL1 - AL0
      DF10  = DF0*AL1M0
      A11   = (A1-AL0)/AL1M0
      A22   = (A2-AL0)/AL1M0
      CALL QUAD_INTER(F0,F1,DF10,A,B,C)
C
C---Calculate values of interpolating polynom for all possible points
      X0  = PUT_IN_INTERVAL(A11,A22,0.0)
      X1  = PUT_IN_INTERVAL(A11,A22,1.0)

      F_A1 = C+A11*(B+A*A22)
      F_A2 = C+A22*(B+A*A22)
      F_X0 = C+X0*(B+A*X0)
      F_X1 = C+X1*(B+A*X1)
      X_MIN = X0
      F_MIN = F_X0
C
      CALL MIN_OF_2(X1,X_MIN,F_X1,F_MIN)
      CALL MIN_OF_2(X0,X_MIN,F_X0,F_MIN)
      CALL MIN_OF_2(X1,X_MIN,F_X1,F_MIN)
C
C--Find minimum of interpolating polynom in the given interval
      IF(A.NE.0.0) THEN
        X_MIN1= -B/(2.0*A)
        X_MIN1 = PUT_IN_INTERVAL(A11,A22,X_MIN)
        F_C   = A*X_MIN1**2 + B*X_MIN1 + C
        CALL MIN_OF_2(X_MIN1,X_MIN,F_C,F_MIN)
      ENDIF
      X_MIN = AL0 + X_MIN*(AL1-AL0)
      RETURN
      END
C
      SUBROUTINE QUAD_INTER(F0,F1,DF0,A,B,C)
C
c---Given f(0),f'(0) and f(1) calculates coefficients for quadratic
C---interpolation for z = (X-X0)/(X1-X0)
      REAL F0,F1,DF0,A,B,C
C
      A   = F1-F0-DF0
      B   = DF0
      C   = F0
      RETURN
      END
C
      SUBROUTINE MIN_CUBE_INTER(X0,X1,F0,F1,DF0,DF1,A1,A2,X_MIN)
C
C---given a, b, f(a), f'(a), f(b), f'(b) and a1, a2 finds minimum of
C---cubic interpolating polynom in the interval (min(a1,a2),max(a1,a2)) 
C---inclusive
      IMPLICIT NONE
      REAL X0,X1,F0,F1,DF0,DF1,A1,A2,X_MIN
C
      REAL A,B,C,D,X_MIN1,X_MIN2,X1MX0,DF10,DF11,A11,A22,X_0,X_1,
     &     F_X0,F_X1,F_A1,F_A2,F_MIN,F_M1,F_M2
      DOUBLE PRECISION D_LOC
      REAL EPS_LOC
      REAL AM1
      REAL PUT_IN_INTERVAL
      EXTERNAL PUT_IN_INTERVAL
      DATA EPS_LOC /1.0E-7/
C
cd      WRITE(*,*)X1,X0
      IF(ABS(X1-X0).LE.EPS_LOC) THEN
        X_MIN = (X1+X0)/2.0
        RETURN
      ENDIF
C
C---Convert argument to switch X0 --> 0.0, X1 --> 1.0
      X1MX0 = X1-X0
      DF10  = DF0*X1MX0
      DF11  = DF1*X1MX0
      A11   = (A1-X0)/X1MX0
      A22   = (A2-X0)/X1MX0
C
      CALL CUBE_INTER(F0,F1,DF10,DF11,A,B,C,D)
      AM1 = A
      IF(B.GT.AM1) AM1 = B
      IF(C.GT.AM1) AM1 = C
      A = A/AM1
      B = B/AM1
      C = C/AM1
      D = D/AM1
      X_0  = PUT_IN_INTERVAL(A11,A22,0.0)
      X_1  = PUT_IN_INTERVAL(A11,A22,1.0)
      F_X0 = D + X_0*(C+X_0*(B+X_0*A))
      F_X1 = D + X_1*(C+X_1*(B+X_1*A))
      F_A1 = D + A11*(C+A11*(B+A11*A))
      F_A2 = D + A22*(C+A22*(B+A22*A))
C
C---First find minimum of function in four points X_0,X_1,A11,A22
C---These points migth coincide
      X_MIN = X_0
      F_MIN = F_X0
      CALL MIN_OF_2(X_1,X_MIN,F_X1,F_MIN)
      CALL MIN_OF_2(A11,X_MIN,F_A1,F_MIN)
      CALL MIN_OF_2(A22,X_MIN,F_A2,F_MIN)
C
C----Now find minimum of cubic polynom and compare it with previous
C----values
      IF(ABS(A).GT.EPS_LOC) THEN
        D_LOC = B**2-3.0*A*C
        IF(D_LOC.GE.0.0D0) THEN
          X_MIN1 = (-B+DSQRT(D_LOC))/(3*A)
          X_MIN1 = PUT_IN_INTERVAL(A11,A22,X_MIN1)
          F_M1   = D + X_MIN1*(C + X_MIN1*(B + X_MIN1*A))
          CALL MIN_OF_2(X_MIN1,X_MIN,F_M1,F_MIN)
          X_MIN2 = (-B-DSQRT(D_LOC))/(3*A)
          X_MIN2 = PUT_IN_INTERVAL(A11,A22,X_MIN2)
          F_M2   = D + X_MIN2*(C + X_MIN2*(B+ X_MIN2*A))
          CALL MIN_OF_2(X_MIN2,X_MIN,F_M2,F_MIN)
        ENDIF
      ELSE
        IF(ABS(B).GT.EPS_LOC) THEN
          X_MIN1 =  -C/(2.0*B)
          X_MIN1 = PUT_IN_INTERVAL(A11,A22,X_MIN1)
          F_M1   = D + X_MIN1*(C + X_MIN1*B)
          CALL MIN_OF_2(X_MIN1,X_MIN,F_M1,F_MIN)
        ENDIF
      ENDIF
C
C---Convert to original scale
      X_MIN = X0 + X_MIN*X1MX0

cd      STOP
      RETURN
      END
C
      SUBROUTINE CUBE_INTER(F0,F1,DF0,DF1,A,B,C,D)
C
C---Given f(0), f'(0), f(1) and f'(1) calculates coefficient of
C---cubic interpolation for z = (X-X0)/(X1-X0)
      IMPLICIT NONE
      REAL F0,F1,DF0,DF1,A,B,C,D
C
      D       = F0
      C       = DF0
      B       = 3*(F1-F0) - 2.0*DF0-DF1
      A       = DF0 + DF1 - 2.0*(F1-F0)

      RETURN
      END
C      
      REAL FUNCTION PUT_IN_INTERVAL(A1,A2,X)
C
C--Puts X into interval (A1,A2). if it is not in (A1,A2) then
C--takes nearest point. A1 could be less or greater than A2
      IMPLICIT NONE
      REAL A1,A2,X
C
      PUT_IN_INTERVAL = AMIN1(AMAX1(A1,A2),AMAX1(AMIN1(A1,A2),X))
      END
C
      SUBROUTINE MIN_OF_2(X_1,X_2,F_1,F_2)
C
C---It changes values of F_2 and X_2 to F_1 and X_1 if F_2.Gt.F_1
      IMPLICIT NONE
      REAL X_1,X_2,F_1,F_2
C
      IF(F_2.GT.F_1) THEN
        X_2 = X_1
        F_2 = F_1
      ENDIF
      RETURN
      END
C
      SUBROUTINE CUB_SPLINE_COEFS(N_POINTS,X_SAMPLE,Y_SAMPLE,COEFS_S)
      IMPLICIT NONE
C
C----Coefficients for cubic spline interpolation
C----This routine uses not-aknot conditions on the boundary. 
C----see de Boor, A practical guide to splines (1978)
C----
      REAL X_SAMPLE(*),Y_SAMPLE(*),COEFS_S(4,*)
      INTEGER N_POINTS
C
C----Local variables
      INTEGER I,N_POINTS1
      REAL    TEMP,DELTA,DFDX1,DFDX2
C
C---Consider N = 1
C---It will have to be considered in interpolating subroutine
      IF(N_POINTS.LE.1) THEN
         COEFS_S(1,1) = Y_SAMPLE(1)
         COEFS_S(2,1) = 0.0
         COEFS_S(3,1) = 0.0
         COEFS_S(4,1) = 0.0
         RETURN
      ENDIF
C
C---Points should be distinct and increasing
      N_POINTS1 = N_POINTS-1

      DO   I=1,N_POINTS1
        IF(X_SAMPLE(I).GE.X_SAMPLE(I+1)) THEN
          CALL ERRWRT(-1,'Points must be increasing and distinct')
          CALL ERRWRT(1,'Error in CUB_SPLINE_COEFS')
        ENDIF
      ENDDO
      DO    I=1,N_POINTS
        COEFS_S(1,I) = Y_SAMPLE(I)
      ENDDO
C
C---N=2. Linear interpolation
      IF(N_POINTS.EQ.2) THEN
        COEFS_S(2,1) = 
     &             (Y_SAMPLE(2)-Y_SAMPLE(1))/(X_SAMPLE(2)-X_SAMPLE(1))
        COEFS_S(3,1) = 0.0
        COEFS_S(4,1) = 0.0
        RETURN
      ENDIF
C
C--N>=3. general case
      DO   I=2,N_POINTS
         COEFS_S(3,I) = X_SAMPLE(I) - X_SAMPLE(I-1)
         COEFS_S(4,I) = (COEFS_S(1,I)-COEFS_S(1,I-1))/COEFS_S(3,I)
      ENDDO
      COEFS_S(4,1) = COEFS_S(3,3)
      COEFS_S(3,1) = COEFS_S(3,2) + COEFS_S(3,3)
      COEFS_S(2,1) = ((COEFS_S(3,2)+2.0*COEFS_S(3,1))*COEFS_S(4,2)*
     &               COEFS_S(3,3) + COEFS_S(3,2)*COEFS_S(3,2)*
     &               COEFS_S(4,3))/COEFS_S(3,1)
      DO   I=2,N_POINTS1
        TEMP = -COEFS_S(3,I+1)/COEFS_S(4,I-1)
        COEFS_S(2,I) = TEMP*COEFS_S(2,I-1)+3.0*(COEFS_S(3,I)*
     &                 COEFS_S(4,I+1)+COEFS_S(3,I+1)*COEFS_S(4,I))
        COEFS_S(4,I) = TEMP*COEFS_S(3,I-1)+2.0*(COEFS_S(3,I)+
     &                  COEFS_S(3,I+1))
      ENDDO
C
C--not-a-knot at the last point
      IF(N_POINTS.GT.3) THEN
        TEMP = COEFS_S(3,N_POINTS1) + COEFS_S(3,N_POINTS)
        COEFS_S(2,N_POINTS) = ((COEFS_S(3,N_POINTS) + 2.0*TEMP)*
     &                    COEFS_S(4,N_POINTS)*COEFS_S(3,N_POINTS1)+
     &                    COEFS_S(3,N_POINTS)**2*(COEFS_S(1,N_POINTS1)-
     &                    COEFS_S(1,N_POINTS-2))/COEFS_S(3,N_POINTS1))/
     &                           TEMP
        TEMP = -TEMP/COEFS_S(4,N_POINTS1)
        COEFS_S(4,N_POINTS) = COEFS_S(3,N_POINTS1)
      ELSE
        COEFS_S(2,N_POINTS) = 2.0*COEFS_S(4,N_POINTS)
        COEFS_S(4,N_POINTS) = 1.0
        TEMP = -1.0/COEFS_S(4,N_POINTS1)
      ENDIF
      COEFS_S(4,N_POINTS) = TEMP*COEFS_S(3,N_POINTS1) + 
     &                        COEFS_S(4,N_POINTS)
      COEFS_S(2,N_POINTS) = (COEFS_S(2,N_POINTS1)*TEMP + 
     &                      COEFS_S(2,N_POINTS))/COEFS_S(4,N_POINTS)
C
C---Back substitution
      DO   I=N_POINTS1,1,-1
        COEFS_S(2,I) = (COEFS_S(2,I)-COEFS_S(3,I)*COEFS_S(2,I+1))/
     &                  COEFS_S(4,I)
      ENDDO
C
C---Now generate coefficients for cubic spline (picewise cubic functions)
      DO   I=2,N_POINTS
         DELTA = COEFS_S(3,I)
         DFDX1 = (COEFS_S(1,I) - COEFS_S(1,I-1))/DELTA
         DFDX2 = COEFS_S(2,I-1) + COEFS_S(2,I) - 2.0*DFDX1
         COEFS_S(3,I-1) = (DFDX1-COEFS_S(2,I-1)-DFDX2)/DELTA
         COEFS_S(4,I-1) = (DFDX2/DELTA)/DELTA
      ENDDO
C
C---Normal termination
      RETURN
      END
C
      SUBROUTINE CUBIC_SPLINE_VALUE1(N_POINTS,X_POINTS,X_CURRENT,
     &                               I_INTERVAL,Y_CURRENT,COEFS_S)
      IMPLICIT NONE
C
c---Calculates value of function at point X_CURRENT using cubic interpolation
c---Interpolation coefficient are assumed to be known. Interval number is known
C
      REAL  X_POINTS(*),COEFS_S(4,*),X_CURRENT,Y_CURRENT
      INTEGER I_INTERVAL,N_POINTS,IERROR
C
C----Local variables
      INTEGER I_INT1
      REAL   DX
C
c----Calculate value of function at the given point
      I_INT1 = MAX(1,MIN(N_POINTS-1,I_INTERVAL))
      DX = X_CURRENT-X_POINTS(I_INT1)
      Y_CURRENT =     COEFS_S(1,I_INT1) + 
     &             DX*(COEFS_S(2,I_INT1)+
     &             DX*(COEFS_S(3,I_INT1)+
     &             DX* COEFS_S(4,I_INT1)))
      RETURN
      END
C
      SUBROUTINE CUBIC_SPLINE_VALUE2(N_POINTS,X_POINTS,X_CURRENT,
     &                              Y_CURRENT,COEFS_S)
      IMPLICIT NONE
C
c---Calculates value of function at point X_CURRENT using cubic interpolation
c---Interpolation coefficient are assumed to be known. Interval number is not
C---known
C
      REAL  X_POINTS(*),COEFS_S(4,*),X_CURRENT,Y_CURRENT
      INTEGER I_INTERVAL,N_POINTS,IERROR
C
C----Local variables
      REAL   DX
      INTEGER K1,K2,K

C
C----Find interval where X_CURRENT belongs. First two conditions
C----means that extrapolation will be used. Not a very good idea.
      IF(X_CURRENT.LE.X_POINTS(1)) THEN
        K1 = 1
      ELSEIF(X_CURRENT.GE.X_POINTS(N_POINTS)) THEN
        K1= N_POINTS - 1
      ELSE
         
        K1 = 1
        K2 = N_POINTS-1
 1      CONTINUE
        IF(K2.GT.K1+1) THEN
          K = (K1+K2)/2
          IF(X_POINTS(K).GT.X_CURRENT) THEN
            K2 = K
          ELSE
            K1 = K
          ENDIF
          GOTO 1
        ENDIF
       ENDIF
C
c----Calculate value of function at the given point
       DX = X_CURRENT-X_POINTS(K1)
       Y_CURRENT =     COEFS_S(1,K1) + 
     &             DX*(COEFS_S(2,K1)+
     &             DX*(COEFS_S(3,K1)+
     &             DX* COEFS_S(4,K1)))
       RETURN
       END
C
      SUBROUTINE LINTER_VALUE2(N_POINTS,X_POINTS,Y_POINTS,X_CURRENT,
     &                              K1,Y_CURRENT)
      IMPLICIT NONE
C
c---Calculates value of function at point X_CURRENT using cubic interpolation
c---Interpolation coefficient are assumed to be known. Interval number is not
C---known
C
      REAL  X_POINTS(*),Y_POINTS(*),X_CURRENT,Y_CURRENT
      INTEGER I_INTERVAL,N_POINTS,IERROR
C
C----Local variables
      REAL   DX,A,B
      INTEGER K1,K2,K

C
C----Find interval where X_CURRENT belongs. First two conditions
C----means that extrapolation will be used. Not a very good idea.
cd      WRITE(*,*)N_POINTS,K1
      IF(N_POINTS.EQ.1) THEN
         Y_CURRENT = Y_POINTS(1)
         X_CURRENT = X_POINTS(1)
         K1 =1
         RETURN
      ENDIF
      IF(K1.GE.1.AND.K1.LT.N_POINTS) THEN
         IF(X_CURRENT.GE.X_POINTS(K1).AND.X_CURRENT.LE.X_POINTS(K1+1)) 
     &           GOTO 20
      ENDIF
cd      IF(K1.LT.1.OR.K1.GT.N_POINTS-1) THEN
        IF(X_CURRENT.LE.X_POINTS(1)) THEN
          K1 = 1
        ELSEIF(X_CURRENT.GE.X_POINTS(N_POINTS)) THEN
          K1= N_POINTS - 1
        ELSE
         
          K1 = 1
          K2 = N_POINTS
 1        CONTINUE
          IF(K2.GT.K1+1) THEN
            K = (K1+K2)/2
            IF(X_POINTS(K).GT.X_CURRENT) THEN
              K2 = K
            ELSE
              K1 = K
            ENDIF
            GOTO 1
          ENDIF
         ENDIF
cd       ENDIF
C
c----Calculate value of function at the given point
 20      CONTINUE
       B = Y_POINTS(K1)
       A = (Y_POINTS(K1+1)-Y_POINTS(K1))/
     &         (X_POINTS(K1+1)-X_POINTS(K1))

       DX = X_CURRENT-X_POINTS(K1)
       Y_CURRENT = A*DX+B
       IF(X_CURRENT.LT.X_POINTS(1)) THEN
         Y_CURRENT = AMAX1(0.1*Y_POINTS(1),
     &            AMIN1(10.0*Y_POINTS(1),Y_CURRENT))
       ELSE IF(X_CURRENT.GT.X_POINTS(N_POINTS)) THEN
         Y_CURRENT = AMAX1(0.1*Y_POINTS(N_POINTS),
     &            AMIN1(10.0*Y_POINTS(N_POINTS),Y_CURRENT))
       ENDIF
       RETURN
       END
C
      SUBROUTINE LINBID(MDIMX1,MDIMX2,DIMX1,DIMX2,X1GRID,X2GRID,
     &                  YATGRID,X1CURR,X2CURR,YCURR,IL,IB,T,U)
      IMPLICIT NONE
      INTEGER l,IL,b,IB,X1L,X1U,X1M,X2L,X2U,X2M,DIMX1,DIMX2,INDL,INDB,
     &        MDIMX1,MDIMX2
      REAL X1GRID(*),X2GRID(*),YATGRID(MDIMX1,MDIMX2)
      REAL X1CURR,X2CURR,YCURR,UR,LR,LL,UL,U,T
c
      X1L=1
      X1U=DIMX1+1
 10   IF (X1U-X1L.GT.1) THEN
         X1M = (X1U+X1L)/2
         IF ((X1GRID(DIMX1).GT.X1GRID(1)).EQV.(X1CURR.GT.X1GRID(X1M)))
     &   THEN
            X1L = X1M
         ELSE
            X1U = X1M
         ENDIF
      GOTO 10
      ENDIF
      IL = X1L
C
      X2L=1
      X2U=DIMX2+1
 20   IF (X2U-X2L.GT.1) THEN
         X2M = (X2U+X2L)/2
       IF ((X2GRID(DIMX2).GT.X2GRID(1)).EQV.(X2CURR.GT.X2GRID(X2M)))
     &   THEN
            X2L = X2M
         ELSE
            X2U = X2M
         ENDIF
      GOTO 20
      ENDIF
      IB = X2L
c
      IF (IL.EQ.DIMX1) IL = IL-1
      IF (IB.EQ.DIMX2) IB = IB-1
c     
      LL = YATGRID(IL,IB)
      LR = YATGRID(IL+1,IB)
      UR = YATGRID(IL+1,IB+1)
      UL = YATGRID(IL,IB+1)
c
      T = (X1CURR-X1GRID(IL))/(X1GRID(IL+1)-X1GRID(IL))
      U = (X2CURR-X2GRID(IB))/(X2GRID(IB+1)-X2GRID(IB))
  
      YCURR = (1-T)*(1-U)*LL + T*(1-U)*LR + T*U*UR + (1-T)*U*UL 
      RETURN
      END
C
      SUBROUTINE LINBID_FIX(MDIMX1,MDIMX2,DIMX1,DIMX2,YATGRID,
     &                      IL,IB,T,U,YCURR)
      IMPLICIT NONE
      INTEGER IL,IB,DIMX1,DIMX2,MDIMX1,MDIMX2
      REAL YATGRID(MDIMX1,MDIMX2)
      REAL YCURR,UR,LR,LL,UL,U,T
c     
      LL = YATGRID(IL,IB)
      LR = YATGRID(IL+1,IB)
      UR = YATGRID(IL+1,IB+1)
      UL = YATGRID(IL,IB+1)
c 
      YCURR = (1-T)*(1-U)*LL + T*(1-U)*LR + T*U*UR + (1-T)*U*UL 
      RETURN
      END
C
      SUBROUTINE POLINT2D(X1GRID,X2GRID,YATGRID,DIMX1,DIMX2,
     &                    X1CURR,X2CURR,YCURR)
      IMPLICIT NONE
      INTEGER DIMX1,DIMX2,i,j
      REAL X1GRID(DIMX1),X2GRID(DIMX2),YATGRID(DIMX1,DIMX2),
     &     X1CURR,X2CURR,YCURR,DY,YX2TEMP(DIMX2),YX1TEMP(DIMX1)  
c
      DO i = 1,DIMX1
         DO j = 1,DIMX2
            YX2TEMP(j) = YATGRID(i,j)
         ENDDO
         CALL POLINT(X2GRID,YX2TEMP,DIMX2,X2CURR,YX1TEMP(i),DY)
      ENDDO
      CALL POLINT(X1GRID,YX1TEMP,DIMX1,X1CURR,YCURR,DY)   
      RETURN
      END
c
      SUBROUTINE POLINT(XGRID,YGRID,DIMX,XCURR,YCURR,DY)
C
      IMPLICIT NONE
      INTEGER i,NS,DIMX,m
      REAL XCURR,YCURR,DY,XGRID(DIMX),YGRID(DIMX),C(DIMX),D(DIMX),DEN,
     &     HO,HP,DIF,DIFT,W
C
      NS = 1
      DIF = ABS(XCURR-XGRID(1))
      DO i = 1,DIMX
         DIFT = ABS(XCURR-XGRID(i))
         IF (DIFT.LT.DIF) THEN
            NS = i
            DIF = DIFT
         ENDIF
         C(i) = YGRID(i)
         D(i) = YGRID(i) 
      ENDDO  
      YCURR = YGRID(NS)
      NS = NS-1
      DO m = 1,2
         DO i = 1,DIMX-m
            HO = XGRID(i)-XCURR
            HP = XGRID(i+m)-XCURR
            W = C(i+1)-D(i)
            DEN = HO-HP
            IF (DEN.EQ.0.) THEN
               print*, 'division by zero'
               stop
            ENDIF
            DEN = W/DEN
            D(i) = HP*DEN
            C(i) = HO*DEN
         ENDDO
         IF (2*NS.LT.DIMX-m) THEN
            DY = C(NS+1)
         ELSE
            DY = D(NS)
            NS = NS-1
         ENDIF
         YCURR = YCURR+DY
      ENDDO
      RETURN
      END
C
      SUBROUTINE GAUSS_SMOOTH(H_SM,N_P,X_P,Y_P,X_CUR,Y_CUR)
      IMPLICIT NONE
C
C---This subroutine uses gaussian kernel with H_SM as width for
C---smothing function. Simplest smothing possible.
C---If H_SM is negative then routine finds minimum interval and sets 
C---H_SM = 1.5*MIN_INTERVAL. In first call it tabulates exponential
C---function for negative arguments. It should be outside this routine
C
      INTEGER N_P
      REAL H_SM,X_CUR,Y_CUR
      REAL X_P(*),Y_P(*)
C
      INTEGER IFIRST,I,IXDIFF
      REAL XDIFF,SUM1,SUM2,G
      REAL MIN_INT
      REAL GAUSS(50001)
C
      COMMON /GH_SMOOTH/IFIRST,GAUSS
      DATA IFIRST/0/
      SAVE /GH_SMOOTH/
C
      IF(IFIRST.EQ.0) THEN
        DO   I=1,50000
          GAUSS(I) = EXP(-.002*I+.002)
        ENDDO
        GAUSS(50001) = 0.0
        IFIRST = 1
      ENDIF
C
c--If H_SM is less than 0 then find its value

      IF(H_SM.LE.0.0) THEN
         MIN_INT = 1.0E32
         DO   I=1,N_P-1
           MIN_INT = AMIN1(MIN_INT,X_P(I+1)-X_P(I))
         ENDDO
         H_SM = 1.5*MIN_INT
      ENDIF
cd      WRITE(*,*)MIN_INT,H_SM
cd      STOP
C
      SUM1 = 0.0
      SUM2 = 0.0
      DO   I=1,N_P
         XDIFF = (X_CUR-X_P(I))/H_SM
         XDIFF = XDIFF*XDIFF/2.0
         IXDIFF = INT(AMIN1(XDIFF*500.0+1.0,50001.1))
         G     = GAUSS(IXDIFF)
         SUM1 = SUM1 + G
         SUM2 = SUM2 + G*Y_P(I)
      ENDDO
cd      IF(SUM1.LE.0.0) THEN
cd        
cd      ELSE
        Y_CUR = SUM2/SUM1
cd      ENDIF
cd      WRITE(*,*)Y_CUR,X_CUR,X_P(1),X_P(N_P)
      RETURN
      END
C
C     ======================================
      REAL FUNCTION FINTER_CUB(X,XO,XD,YA,N,J,C)
C     ======================================
C
C==== CUBIC SPLINE INTERPOLATION.
C==== X  = INTERPOLATION POINT IN X.
C==== XO = FIRST SAMPLE POINT IN X.
C==== XD = INCREMENT IN X BETWEEN SAMPLE POINTS.
C==== YA = ARRAY OF N SAMPLE POINTS IN Y.
C==== N  = NUMBER OF SAMPLE POINTS.
C==== J  = RETURNED ARRAY INDEX. MUST BE SET TO ZERO BEFORE FIRST CALL.
C==== C  = RETURNED ARRAY OF 4 CUBIC COEFFICIENTS. J AND C MUST NOT BE
C         MODIFIED BETWEEN CALLS.
C==== FSPLIN = INTERPOLATED VALUE IN Y.
C
C
C
      IMPLICIT NONE
C     .. Scalar Arguments ..
      INTEGER J,N
      REAL X,XD,XO
C     ..
C     .. Array Arguments ..
      REAL C(4),YA(*)
C     ..
C     .. Local Scalars ..
      INTEGER I,I1
      REAL G1,G2,S,U0,U1,U2,V0,V1,V2,X1,XD2,YD,YD1
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC MIN
C     ..
      IF (N.LE.2) THEN
        J = 1
        IF (N.EQ.1) THEN
          FINTER_CUB = YA(1)
        ELSE
          FINTER_CUB = YA(1) + (YA(2)-YA(1))*(X-XO)/XD
        ENDIF
      ELSE
C==== COMPUTE WHICH INTERVAL TO USE.
        I = MIN(MAX(INT((X-XO)/XD),0)+1,N-1)
        X1 = XO + (I-1)*XD
C==== SAME AS LAST CALL ?
        IF (I.NE.J) THEN
C==== NO, RESET FOR NEXT CALL.
          J = I
C
C==== COMPUTE WEIGHTED DISPLACEMENT VECTOR (U1,V1) BETWEEN I AND I+1.
          XD2 = XD*XD
          I1 = I + 1
          YD1 = YA(I1) - YA(I)
          S = XD2 + YD1*YD1
          U1 = XD/S
          V1 = YD1/S
          C(1) = YA(I)
C
          IF (I.GT.1) THEN
C==== COMPUTE VECTOR (U0,V0) BETWEEN I-1 AND I, AND GRADIENT G1 AT I.
            YD = YA(I) - YA(I-1)
            S = XD2 + YD*YD
            U0 = XD/S
            V0 = YD/S
            G1 = (V0+V1)/ (U0+U1)
C
            IF (I1.EQ.N) GOTO 10
          ENDIF
C==== COMPUTE VECTOR (U2,V2) BETWEEN I+1 AND I+2, AND GRADIENT G2 AT I+1.
          YD = YA(I1+1) - YA(I1)
          S = XD2 + YD*YD 
          U2 = XD/S
          V2 = YD/S
          G2 = (V1+V2)/ (U1+U2)
C
          IF (I.EQ.1) THEN
C==== CASE OF FIRST INTERVAL, COMPUTE QUADRATIC COEFFIENTS.
            C(2) = YD1/XD
            C(3) = G2 - C(2)
            C(2) = C(2) - C(3)
            C(3) = C(3)/XD
            C(4) = 0.
          ELSE
C==== GENERAL CASE, COMPUTE CUBIC COEFFICENTS.
            C(2) = G1
            C(3) = YD1/XD
            C(4) = G1 + G2 - 2.*C(3)
            C(3) = (C(3)-C(4)-G1)/XD
            C(4) = C(4)/XD2
          ENDIF
          GOTO 20
C
C==== CASE OF LAST INTERVAL, COMPUTE QUADRATIC COEFFICIENTS.
10        C(2) = G1
          C(3) = (YD1/XD-G1)/XD
          C(4) = 0.
        ENDIF
C
C==== COMPUTE FUNCTION VALUE AND RETURN.
20      S = X - X1
        FINTER_CUB = C(1) + S*(C(2)+S*(C(3)+S*C(4)))
      ENDIF
      END
