c
c--   To be added:
c---  if some of the fractions become too small fix them to zero.
c---  small could be 0.1 or 0.05. Would of course be better if we could
c---  make a probabilistic decision
c
      subroutine refine_ls_parameters(
     &     nasym,hkl_asym,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)
c
c---  Initialise ls scale parameters
c-------------------------------------------------------------------
c
c---  inputs
      implicit none
      include 'agreem.fh'
      include 'celsym.fh'
      include 'twin_refmac.fh'

      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
c
c---  Outputs. Scale parameters are in agreem.fh
      integer ierr
c
c---  locals
      integer maxpart_l,maxcont_l
      parameter (maxpart_l=3)
      parameter (maxcont_l=48)
      real scale_ov0,b_ov0,scale_bulk0,b_bulk0,baniso_ov0(6)
      real scale_part0(maxpart_l),b_part0(maxpart_l),alpha0(maxcont_l)
      integer num_p
      real, allocatable :: dfdp1(:) 
      real, allocatable :: dfdp1dp2(:,:)
      real, allocatable :: shift(:)
      real, allocatable :: par0(:)
      real toler

      integer i,ncycle_ls,j,k,j1
      integer ip
      integer ndomain
      real alpha(48)
c---  locals for line minimisation
      real fold,g2p
      real r1,r2,tmp,tst,a,b
      real d1,d2,f_value,rfac_i,rfac_w_i,rfac_f
      real lambd,lambd2,lambdmin,lam0,l12
      real f1,f2,d2p
      real tol_conv,al0,tol_conv1
      parameter (tol_conv = 1.0e-2)
      parameter (tol_conv1 = 1.0e-6)
      parameter (al0 = 1.0e-4)
      real dot_r
      external dot_r
c
c---- body
c--------------------------------------------------------------
      toler = 1.0E-8
      ndomain = ntwin_domain
      alpha(1:ndomain) = twin_frac(1:ndomain)

      num_p = ndomain+8+2.0*npart_act
c
c--   allocate memory    
      if(.not.allocated(dfdp1)) allocate(dfdp1(num_p))
      if(.not.allocated(dfdp1dp2)) allocate(dfdp1dp2(num_p,num_p))
      if(.not.allocated(shift)) allocate(shift(num_p))
      allocate(par0(num_p))
c------------------------------
      ncycle_ls=50
      call save_params_ls(nmaxpart,maxpart_l,maxcont_l,npart_act,
     &     ndomain,
     &     scale_ls_over,b_ls_over,scale_ls_part,
     &     b_ls_part,b_ls_aniso_over,scale_ls_bulk,b_ls_bulk,alpha,
     &     scale_ov0,b_ov0,scale_part0,b_part0,baniso_ov0,scale_bulk0,
     &     b_bulk0,alpha0)
c
c---  Overall cycles for minimisation
      do i = 1,ncycle_ls
         call copy_ls_params(num_p,maxpart_l,maxcont_l,npart_act,
     &        ndomain,par0,scale_ov0,b_ov0,scale_part0,b_part0,
     &        baniso_ov0,scale_bulk0,b_bulk0,alpha0)
c
        call derivative_df_dp(maxsym,nsym,rot,tr,cell,
     &        nasym,hkl_asym,fcalc,fpart,
     &        num_blocks,block_start,ref_2_asym_start,
     &        nobs,iobs,obs_start,
     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &        num_asym_ref,block_2_asym,
     &        nmaxpart,npart_act,ndomain,alpha,
     &        b_ls_aniso_over,scale_ls_over,b_ls_over,scale_ls_bulk,
     &        b_ls_bulk,scale_ls_part,b_ls_part,
     &        num_p,
     &        dfdp1,dfdp1dp2,f_value,
     &        ierr)
         fold = f_value
c         write(*,*)'cycle and function value',i,f_value
         call eigen_filter_r90(toler,dfdp1dp2,num_p,num_p,dfdp1,shift,
     &        ierr)
c
c---  Find initial shift length. make sure that parameters are reasonable
         call init_lambd_ls(num_p,shift,lam0,
     &        nmaxpart,npart_act,ndomain,
     &        alpha,scale_ls_over,b_ls_over,scale_ls_part,b_ls_part,
     &        b_ls_aniso_over,scale_ls_bulk,b_ls_bulk)
         shift(1:num_p) = shift(1:num_p)*lam0
         g2p = dot_product(shift,dfdp1)
         tst = 0.0
c
c---  Line minimisation
         do  j=1,num_p
            tst = max(tst,abs(shift(j))/max(abs(par0(j)),1.0))
         enddo
         lambdmin = tol_conv1/tst
         lambd = 1.0         
         do j=1,100
            call restore_params_ls(nmaxpart,maxpart_l,maxcont_l,
     &           npart_act,
     &           ndomain,scale_ls_over,b_ls_over,scale_ls_part,
     &           b_ls_part,b_ls_aniso_over,scale_ls_bulk,b_ls_bulk,
     &           alpha,
     &           scale_ov0,b_ov0,scale_part0,b_part0,baniso_ov0,
     &           scale_bulk0,b_bulk0,alpha0)
            call add_shift_ls0(num_p,lambd,shift,
     &           nmaxpart,npart_act,ndomain,
     &           alpha,scale_ls_over,b_ls_over,scale_ls_part,
     &           b_ls_part,b_ls_aniso_over,scale_ls_bulk,b_ls_bulk)
            
            call  fvalue_ls_intens(maxsym,nsym,rot,tr,cell,
     &           nasym,hkl_asym,fcalc,fpart,
     &           num_blocks,block_start,ref_2_asym_start,
     &           nobs,iobs,obs_start,
     &           ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &           num_asym_ref,block_2_asym,
     &           nmaxpart,npart_act,ndomain,alpha,
     &           b_ls_aniso_over,scale_ls_over,b_ls_over,scale_ls_bulk,
     &           b_ls_bulk,scale_ls_part,b_ls_part,f1,
     &           ierr)
c     
c---  Shifts are too small or convergence have been reached
            if(lambd.le.lambdmin) goto 20
            if(f1.le.fold+al0*lambd*g2p) goto 20
c
c---  Try new point and use interpolations
            if(j.eq.1) then
               tmp = -g2p/(2.0*(f1-fold-g2p))
            else
               l12 = lambd-lambd2
               r1 = f1-fold-lambd*g2p
               r2 = f2-fold-lambd2*g2p
               a  = (r1/lambd**2-r2/lambd2**2)/l12
               b = (-lambd2*r1/lambd**2+lambd*r2/lambd2**2)/l12
               if(a.eq.0.0) then
                  tmp = -g2p/(2.0*b)
               else
                  d1 = max(0.0,b**2-3.0*a*g2p)
                  tmp = (-b+sqrt(d1))/(3.0*a)
               endif
            endif
            tmp = min(tmp,0.5*lambd)
            lambd2 = lambd
            f2 = f1
            lambd = max(tmp,0.1*lambd)
         enddo
         call errwrt(1,'Line minimisation failed')
 20      continue
c
c---  Check the convergence
         tst = 0.0
         do  j=1,num_p
            tst = max(tst,abs(shift(j))*lambd/max(abs(par0(j)),1.0))
         enddo
         tst = g2p*lambd/num_p
 21      continue
         if(tst.lt.tol_conv.or.f1.ge.fold) then 
            if(f1.gt.fold) then
               call restore_params_ls(nmaxpart,maxpart_l,maxcont_l,
     &              npart_act,
     &              ndomain,scale_ls_over,b_ls_over,scale_ls_part,
     &              b_ls_part,b_ls_aniso_over,scale_ls_bulk,b_ls_bulk,
     &              alpha,
     &              scale_ov0,b_ov0,scale_part0,b_part0,baniso_ov0,
     &              scale_bulk0,b_bulk0,alpha0)
            endif
            goto 30
         endif
         call restore_params_ls(nmaxpart,maxpart_l,maxcont_l,
     &        npart_act,
     &        ndomain,scale_ls_over,b_ls_over,scale_ls_part,
     &        b_ls_part,b_ls_aniso_over,scale_ls_bulk,b_ls_bulk,
     &        alpha,
     &        scale_ov0,b_ov0,scale_part0,b_part0,baniso_ov0,
     &        scale_bulk0,b_bulk0,alpha0)
         call add_shift_ls0(num_p,lambd,shift,
     &           nmaxpart,npart_act,ndomain,
     &           alpha,scale_ls_over,b_ls_over,scale_ls_part,
     &           b_ls_part,b_ls_aniso_over,scale_ls_bulk,b_ls_bulk)
         call save_params_ls(nmaxpart,maxpart_l,maxcont_l,npart_act,
     &        ndomain,scale_ls_over,b_ls_over,scale_ls_part,
     &        b_ls_part,b_ls_aniso_over,scale_ls_bulk,b_ls_bulk,alpha,
     &        scale_ov0,b_ov0,scale_part0,b_part0,baniso_ov0,
     &        scale_bulk0,b_bulk0,alpha0)
c         write(*,*)b_ls_aniso_over
c         write(*,*)b_ls_aniso_over(1)+b_ls_aniso_over(2)+
c     &        b_ls_aniso_over(3)
      enddo
 30   continue

      ntwin_domain = ndomain
      twin_frac(1:ndomain) = alpha(1:ndomain)
c      stop
c
c--   deallocate memory
      deallocate (dfdp1)
      deallocate (dfdp1dp2)
      deallocate (shift)
      deallocate (par0)
c----------------------
      return 
      end
c
      subroutine derivative_df_dp(maxsym,nsym,rot,tr,cell,
     &        nasym,hkl_asym,fcalc,fpart,
     &        num_blocks,block_start,ref_2_asym_start,
     &        nobs,iobs,obs_start,
     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &        num_asym_ref,block_2_asym,
     &        nmaxpart,npart,ndomain,alpha,
     &        b_ls_aniso_over,scale_ls_over,b_ls_over,scale_ls_bulk,
     &        b_ls_bulk,scale_ls_part,b_ls_part,
     &        num_p,
     &        dfdp1,dfdp1dp2,f_value,
     &        ierr)
      implicit none
c---  inputs
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)

      integer nasym
      integer nmaxpart,npart
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
      integer ndomain
      real b_ls_aniso_over(6),scale_ls_over,b_ls_over,scale_ls_bulk
      real b_ls_bulk,scale_ls_part(nmaxpart),b_ls_part(nmaxpart)
      real    alpha(48)
c
      integer num_p
c
c---  Outputs
      integer ierr
      real dfdp1(num_p)
      real dfdp1dp2(num_p,num_p)
      real f_value
c
c---  locals
      integer i,j,m,k,is,jc,jal,ia,ii
      integer maxpart_l,maxcont_l
      parameter (maxpart_l = 3)
      parameter (maxcont_l = 48)
      real Ict,Ict0
      real Ic(maxcont_l)
      real dsdandb(6),dIct_dp(maxcont_l)
      real dfh_dp(48)
c
      integer il
      integer o_s,o_f,c_s,c_f
      integer c_1,c_n,ip,ip1
      integer obs_contributor_start,obs_contributor_finish
      integer contri_number_obs,obs_num
      real w,fh,dfh_dIct
      real ast,bst,cst,cosast,cosbst,coscst,rsq,ss
      real expb,expbs,expbsres,expbulk,expbulks,expbulksres
      real bulk_cont,expbs_bulk,expban,bans,exp1
      real ss_v(6),hkl_this(3),hkl_sym(3),s_this(3)
      real a_all,b_all,a_part(maxpart_l),b_part(maxpart_l)
      real falp
      real part_expb(maxpart_l)
      real part_expbs(maxpart_l)
      real part_expbsres(maxpart_l)
      real dIc_dps(maxcont_l,maxpart_l),dIc_dpb(maxcont_l,maxpart_l)
      real dIc_dan(maxcont_l,6),dIc_dalpha(maxcont_l)
      real dIct_dalpha(maxcont_l),dIct_danis(6)
      real dIct_dps(maxpart_l),dIct_dpb(maxpart_l)
      real cs_ort_to_frac(3,3),cs_frac_to_ort(3,3)
      real sqrtw
      real c0
      integer ierror
      logical error
c
c---  Body
      c0 = 1.0
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierr)
      if(ierr.gt.0) then
         write(*,*)'Problem in orthogonalisation'
         ierr = 1
         return
      endif

      call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
      dfdp1(1:num_p)            = 0.0
      dfdp1dp2(1:num_p,1:num_p) = 0.0
      f_value                   = 0.0
c     
      do i=1,num_blocks
c     
c---  Define necessary pointers to contributors and observations
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
c     
c---  All reflections in this block have the same resolution (???)
         call define_res(hkl_asym(1,c_1),hkl_asym(2,c_1),
     &        hkl_asym(3,c_1),ast,bst,cst,cosast,cosbst,coscst,rsq)
         ss=rsq/4.0
         expb        = exp(-ss*b_ls_over)
         expbs       = expb*scale_ls_over
         expbsres    = -expbs*ss
         expbulk     = exp(-ss*b_ls_bulk)
         expbulks    = scale_ls_bulk*expbulk
         expbulksres = -ss*expbulks
         bulk_cont   = 1.0-expbulks
         expbs_bulk  = bulk_cont*expbs
c
c---  Calculate all necessary properties of contributors to the reflections
         jc = 0
         Ic(1:maxcont_l) = 0.0
         do m=c_s,c_f
            jc            = jc + 1
            c_n           = block_2_asym(m)
            a_all         = fcalc(1,c_n)
            b_all         = fcalc(2,c_n)
            hkl_this(1:3) = hkl_asym(1:3,c_n)
            expban        = 0.0
            dsdandb(1:6)  = 0.0
            do  is=1,nsym
               call mat2vect(3,3,rot(1,1,is),hkl_this,hkl_sym,error)
               call mat2vect(3,3,cs_ort_to_frac,hkl_sym,s_this,error)
               ss_v(1) = s_this(1)*s_this(1)
               ss_v(2) = s_this(2)*s_this(2)
               ss_v(3) = s_this(3)*s_this(3)
               ss_v(4) = 2.0*s_this(1)*s_this(2)
               ss_v(5) = 2.0*s_this(1)*s_this(3)
               ss_v(6) = 2.0*s_this(2)*s_this(3)
               bans    = ss_v(1)*b_ls_aniso_over(1)+
     &                   ss_v(2)*b_ls_aniso_over(2)+
     &                   ss_v(3)*b_ls_aniso_over(3)+
     &                   ss_v(4)*b_ls_aniso_over(4)+
     &                   ss_v(5)*b_ls_aniso_over(5)+
     &                   ss_v(6)*b_ls_aniso_over(6)
               exp1         = exp(-bans/4.0)
               expban       = expban + exp1
               dsdandb(1:6) = dsdandb(1:6) - ss_v(1:6)*exp1
            enddo
            expban = expban/nsym
            dsdandb(1:6) = dsdandb(1:6)/(4*nsym) 
c
c---  Calculate anisotropic scales and derivatives wrt them.
            do ip=1,npart
               part_expb(ip)  = exp(-b_ls_part(ip)*ss)
               part_expbs(ip) = part_expb(ip)*scale_ls_part(ip)
               part_expbsres(ip) = -ss*part_expbs(ip)
               a_part(ip) = fpart(ip,1,c_n)
               b_part(ip) = fpart(ip,2,c_n)
               a_all = a_all + a_part(ip)*part_expbs(ip)
               b_all = b_all + b_part(ip)*part_expbs(ip)
            enddo
C     
C---  Derivatives corresponding to contributors
            Ic(jc) = a_all**2.0+b_all**2.0
            do  ip=1,npart
               falp  = 2.0*(a_all*a_part(ip)+ b_all*b_part(ip))*expban
               dIc_dps(jc,ip) = falp*part_expb(ip)
               dIc_dpb(jc,ip) = falp*part_expbsres(ip)
            enddo
            dIc_dan(jc,1:6) = Ic(jc)*dsdandb(1:6)
            Ic(jc) = Ic(jc)*expban
         enddo
c     
c---  go through each observation in that block
         do j=o_s,o_f
            obs_contributor_start    = obs_start(j)+1
            obs_contributor_finish   = obs_start(j+1)
            Ict0                     = 0.0
            dIct_dalpha(1:maxcont_l) = 0.0
            dIct_danis(1:6)          = 0.0
            dIct_dps(1:npart)        = 0.0
            dIct_dpb(1:npart)        = 0.0
            do k=obs_contributor_start,obs_contributor_finish
c     
c---  Find position of this contributor and domain number (alpha)
               jc   = ref_2_asym(k)
               jal  = comp_numb(k)
               Ict0 = Ict0 + Ic(jc)*alpha(jal)
               dIct_dalpha(jal) = dIct_dalpha(jal) + Ic(jc)
               dIct_danis(1:6)  = dIct_danis(1:6) + 
     &              alpha(jal)*dIc_dan(jc,1:6)
               dIct_dps(1:npart)  = dIct_dps(1:npart) + 
     &              alpha(jal)*dIc_dps(jc,1:npart)
               dIct_dpb(1:npart)  = dIct_dpb(1:npart) + 
     &              alpha(jal)*dIc_dpb(jc,1:npart)
            enddo
            Ict = Ict0*expbs_bulk
            w   = 1.0
c     w=2.0*iobs(2,j)**2.0+ c0*(max(0.0,iobs(1,j))+Ict)
            sqrtw = sqrt(w)
            fh=(sqrt(Ict)-sqrt(max(0.0,iobs(1,j))))/sqrtw

c     dfh_dIct = 1/sqrtw - c0*fh/(2.0*w)
            if(Ict.le.0.0) then
               dfh_dIct = 0.0
            else
               dfh_dIct = 0.5/(sqrt(Ict)*sqrtw)
            endif
c     dfh_dIct = 1/sqrtw - fh/sqrtw
            f_value=f_value+(fh**2 + log(w))/2.0
c     
c---  Calculate derivatise
c     
c---  alphas
            if(ndomain.gt.1) then
               do ia=1,ndomain-1
                  dIct_dp(ia)=
     &                 (dIct_dalpha(ia+1)-dIct_dalpha(1))*expbs_bulk
               enddo
            endif
c     
c---  Overall scales
            ip = ndomain
            dIct_dp(ip) = Ict0*expb*bulk_cont
            ip = ip + 1
            dIct_dp(ip) = Ict0*expbsres*bulk_cont
            ip = ip + 1
c     
c---  Partials
            do  ii=1,npart
               dIct_dp(ip) = dIct_dps(ii)*expbs_bulk
               ip = ip + 1
               dIct_dp(ip) = dIct_dpb(ii)*expbs_bulk
               ip = ip + 1
            enddo
c     
c---  aniso
            dIct_dp(ip) = (dIct_danis(1)-dIct_danis(3))*expbs_bulk
            ip = ip +1
            dIct_dp(ip) = (dIct_danis(2)-dIct_danis(3))*expbs_bulk
            ip = ip +1 
            dIct_dp(ip:ip+2) = dIct_danis(4:6)*expbs_bulk
            ip = ip + 3
c            dIct_dp(ip:ip+4) = 0
c            ip = ip + 5
c     
c---  Bulk solvent
            dIct_dp(ip) = -Ict0*expbs*expbulk
            ip = ip + 1
            dIct_dp(ip) = -Ict0*expbs*expbulksres
c
c---  Compute derivatives of the function           
            do ip=1,num_p
               dfh_dp(ip)=dfh_dIct*dIct_dp(ip)
            enddo
            do ip=1,num_p
               dfdp1(ip) = dfdp1(ip)+ fh*dfh_dp(ip)
c     +1/w*dIct_dp(ip)             
               do ip1=1,num_p
                  dfdp1dp2(ip,ip1)=dfdp1dp2(ip,ip1) + 
     &                 dfh_dp(ip)*dfh_dp(ip1) 
c     -1/w**2*dIct_dp(ip)*dIct_dp(ip1)
               enddo
            enddo
c     
c---  end of observations in block
         enddo 
c     
c---  end of blocks      
      enddo
c      do  j=1,num_p
c         write(*,*)dfdp1(j),dfdp1(j)/dfdp1dp2(j,j)
c         write(*,*)dfdp1dp2(j,1:num_p)
c      enddo
c      stop
      return 
      end
c
      subroutine fvalue_ls_intens(maxsym,nsym,rot,tr,cell,
     &        nasym,hkl_asym,fcalc,fpart,
     &        num_blocks,block_start,ref_2_asym_start,
     &        nobs,iobs,obs_start,
     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &        num_asym_ref,block_2_asym,
     &        nmaxpart,npart,ndomain,alpha,
     &        b_ls_aniso_over,scale_ls_over,b_ls_over,scale_ls_bulk,
     &        b_ls_bulk,scale_ls_part,b_ls_part,
     &        f_value,
     &        ierr)

      implicit none
c---  inputs
      integer maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym)
      real cell(6)

      integer nasym
      integer nmaxpart,npart
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)
      integer ndomain
      real b_ls_aniso_over(6),scale_ls_over,b_ls_over,scale_ls_bulk
      real b_ls_bulk,scale_ls_part(nmaxpart),b_ls_part(nmaxpart)
      real    alpha(48)
c
c---  Outputs
      integer ierr
      real f_value
c
c---  locals
      integer i,j,m,k,is,jc,jal,ia,ii
      integer maxpart_l,maxcont_l
      parameter (maxpart_l = 3)
      parameter (maxcont_l = 48)
      real Ict,Ict0
      real Ic(maxcont_l)
c
      integer il
      integer o_s,o_f,c_s,c_f
      integer c_1,c_n,ip,ip1
      integer obs_contributor_start,obs_contributor_finish
      integer contri_number_obs,obs_num
      real w,fh,dfh_dIct
      real ast,bst,cst,cosast,cosbst,coscst,rsq,ss
      real expb,expbs,expbsres,expbulk,expbulks,expbulksres
      real bulk_cont,expbs_bulk,expban,bans,exp1
      real ss_v(6),hkl_this(3),hkl_sym(3),s_this(3)
      real a_all,b_all,a_part(maxpart_l),b_part(maxpart_l)
      real falp
      real part_expb(maxpart_l)
      real part_expbs(maxpart_l)
      real cs_ort_to_frac(3,3),cs_frac_to_ort(3,3)
      real sqrtw
      real c0
      integer ierror
      logical error
c
c---  Body
      c0 = 1.0
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierr)
      if(ierr.gt.0) then
         write(*,*)'Problem in orthogonalisation'
         ierr = 1
         return
      endif

      call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
      f_value                   = 0.0     
      do i=1,num_blocks
c     
c---  Define necessary pointers to contributors and observations
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
c     
c---  All reflections in this block have the same resolution (???)
         call define_res(hkl_asym(1,c_1),hkl_asym(2,c_1),
     &        hkl_asym(3,c_1),ast,bst,cst,cosast,cosbst,coscst,rsq)
         ss=rsq/4.0
         expb        = exp(-ss*b_ls_over)
         expbs       = expb*scale_ls_over
         expbulk     = exp(-ss*b_ls_bulk)
         expbulks    = scale_ls_bulk*expbulk
         bulk_cont   = 1.0-expbulks
         expbs_bulk  = bulk_cont*expbs
c
c---  Calculate all necessary properties of contributors to the reflections
         jc = 0
         Ic(1:maxcont_l) = 0.0
         do m=c_s,c_f
            jc            = jc + 1
            c_n           = block_2_asym(m)
            a_all         = fcalc(1,c_n)
            b_all         = fcalc(2,c_n)
            hkl_this(1:3) = hkl_asym(1:3,c_n)
            expban        = 0.0
            do  is=1,nsym
               call mat2vect(3,3,rot(1,1,is),hkl_this,hkl_sym,error)
               call mat2vect(3,3,cs_ort_to_frac,hkl_sym,s_this,error)
               ss_v(1) = s_this(1)*s_this(1)
               ss_v(2) = s_this(2)*s_this(2)
               ss_v(3) = s_this(3)*s_this(3)
               ss_v(4) = 2.0*s_this(1)*s_this(2)
               ss_v(5) = 2.0*s_this(1)*s_this(3)
               ss_v(6) = 2.0*s_this(2)*s_this(3)
               bans    = ss_v(1)*b_ls_aniso_over(1)+
     &                   ss_v(2)*b_ls_aniso_over(2)+
     &                   ss_v(3)*b_ls_aniso_over(3)+
     &                   ss_v(4)*b_ls_aniso_over(4)+
     &                   ss_v(5)*b_ls_aniso_over(5)+
     &                   ss_v(6)*b_ls_aniso_over(6)
               exp1         = exp(-bans/4.0)
               expban       = expban + exp1
            enddo
            expban = expban/nsym
c
c---  Calculate anisotropic scales and derivatives wrt them.
            do ip=1,npart
               part_expb(ip)  = exp(-b_ls_part(ip)*ss)
               part_expbs(ip) = part_expb(ip)*scale_ls_part(ip)
               a_part(ip) = fpart(ip,1,c_n)
               b_part(ip) = fpart(ip,2,c_n)
               a_all = a_all + a_part(ip)*part_expbs(ip)
               b_all = b_all + b_part(ip)*part_expbs(ip)
            enddo
C     
C---  Derivatives corresponding to contributors
            Ic(jc) = a_all**2+b_all**2
            Ic(jc) = Ic(jc)*expban
         enddo
c     
c---  go through each observation in that block
         do j=o_s,o_f
            obs_contributor_start    = obs_start(j)+1
            obs_contributor_finish   = obs_start(j+1)
            Ict0                     = 0.0
            do k=obs_contributor_start,obs_contributor_finish
c     
c---  Find position of this contributor and domain number (alpha)
               jc   = ref_2_asym(k)
               jal  = comp_numb(k)
               Ict0 = Ict0 + Ic(jc)*alpha(jal)
            enddo
            Ict = Ict0*expbs_bulk
            w   = 1.0
c     w=2.0*iobs(2,j)**2.0+ c0*(max(0.0,iobs(1,j))+Ict)
            sqrtw   = sqrt(w)
            fh      = (sqrt(Ict)-sqrt(max(0.0,iobs(1,j))))/sqrtw
            f_value = f_value+(fh**2 + log(w))/2.0
c     
c---  end of observations in block
         enddo 
c     
c---  end of blocks      
      enddo
      return 
      end
c
      subroutine calc_aniso_scale(maxsym,nsym,rot,tr,cell,
     &     cs_ort_to_frac,hkl_this,b_ls_aniso_over,expban)
      implicit none
c
c---inputs
      integer maxsym,nsym
      real cell(6),rot(3,3,maxsym),tr(3,maxsym)
      real cs_ort_to_frac(3,3),hkl_this(3)
      real b_ls_aniso_over(6)
c
c---output
      real expban
c
c---locals
      integer is
      real bans
      real hkl_sym(3),s_this(3),ss_v(6)
      logical error
c
c---  body
c----------------------------------------------------
      expban        = 0.0
      do  is=1,nsym
         call mat2vect(3,3,rot(1,1,is),hkl_this,hkl_sym,error)
         call mat2vect(3,3,cs_ort_to_frac,hkl_sym,s_this,error)
         ss_v(1) = s_this(1)*s_this(1)
         ss_v(2) = s_this(2)*s_this(2)
         ss_v(3) = s_this(3)*s_this(3)
         ss_v(4) = 2.0*s_this(1)*s_this(2)
         ss_v(5) = 2.0*s_this(1)*s_this(3)
         ss_v(6) = 2.0*s_this(2)*s_this(3)
         bans    = ss_v(1)*b_ls_aniso_over(1)+
     &             ss_v(2)*b_ls_aniso_over(2)+
     &             ss_v(3)*b_ls_aniso_over(3)+
     &             ss_v(4)*b_ls_aniso_over(4)+
     &             ss_v(5)*b_ls_aniso_over(5)+
     &             ss_v(6)*b_ls_aniso_over(6)
         expban       = expban + exp(-bans/4.0)
      enddo
      expban = expban/nsym

      return
      end
c
      subroutine calc_aniso_scale_ders(maxsym,nsym,rot,tr,cell,
     &     cs_ort_to_frac,hkl_this,b_ls_aniso_over,expban,dsdandb)
      implicit none
c
c---inputs
      integer maxsym,nsym
      real cell(6),rot(3,3,maxsym),tr(3,maxsym)
      real cs_ort_to_frac(3,3),hkl_this(3)
      real b_ls_aniso_over(6)
c
c---output
      real expban
      real dsdandb(6)
c
c---locals
      integer is
      real bans,exp1
      real hkl_sym(3),s_this(3),ss_v(6)
      logical error

      expban        = 0.0
      dsdandb(1:6)  = 0.0
      do  is=1,nsym
         call mat2vect(3,3,rot(1,1,is),hkl_this,hkl_sym,error)
         call mat2vect(3,3,cs_ort_to_frac,hkl_sym,s_this,error)
         ss_v(1) = s_this(1)*s_this(1)
         ss_v(2) = s_this(2)*s_this(2)
         ss_v(3) = s_this(3)*s_this(3)
         ss_v(4) = 2.0*s_this(1)*s_this(2)
         ss_v(5) = 2.0*s_this(1)*s_this(3)
         ss_v(6) = 2.0*s_this(2)*s_this(3)
         bans    = ss_v(1)*b_ls_aniso_over(1)+
     &        ss_v(2)*b_ls_aniso_over(2)+
     &        ss_v(3)*b_ls_aniso_over(3)+
     &        ss_v(4)*b_ls_aniso_over(4)+
     &        ss_v(5)*b_ls_aniso_over(5)+
     &        ss_v(6)*b_ls_aniso_over(6)
         exp1         = exp(-bans/4.0)
         expban       = expban + exp1
         dsdandb(1:6) = dsdandb(1:6) - ss_v(1:6)*exp1
      enddo
      expban = expban/nsym
      dsdandb(1:6) = dsdandb(1:6)/(4*nsym) 
      
      return
      end
c
      subroutine save_params_ls(maxpart,maxpart_l,maxcont_l,npart,
     &     ndomain,scale_ls_over,b_ls_over,scale_ls_part,
     &     b_ls_part,b_ls_aniso_over,scale_ls_bulk,b_ls_bulk,alpha,
     &     scale_ov0,b_ov0,scale_part0,b_part0,baniso_ov0,scale_bulk0,
     &     b_bulk0,alpha0)
      implicit none
      integer maxpart,maxpart_l,maxcont_l,npart,ndomain
c
c---  inputs
      real scale_ls_over,b_ls_over,scale_ls_part(maxpart)
      real b_ls_part(maxpart),alpha(48),b_ls_aniso_over(6)
      real scale_ls_bulk,b_ls_bulk
c
c---  outputs
      real scale_ov0,b_ov0,scale_part0(maxpart_l),b_part0(maxpart_l)
      real alpha0(maxcont_l),baniso_ov0(6)
      real scale_bulk0,b_bulk0
c
c--locals
      
c
c---  body
      scale_ov0            = scale_ls_over
      b_ov0                = b_ls_over
      baniso_ov0(1:6)      = b_ls_aniso_over(1:6)
      scale_part0(1:npart) = scale_ls_part(1:npart)
      b_part0(1:npart)     = b_ls_part(1:npart)
      alpha0(1:ndomain)    = alpha(1:ndomain)
      scale_bulk0          = scale_ls_bulk
      b_bulk0              = b_ls_bulk

      return
      end
c
      subroutine restore_params_ls(maxpart,maxpart_l,maxcont_l,npart,
     &     ndomain,scale_ls_over,b_ls_over,scale_ls_part,
     &     b_ls_part,b_ls_aniso_over,scale_ls_bulk,b_ls_bulk,alpha,
     &     scale_ov0,b_ov0,scale_part0,b_part0,baniso_ov0,scale_bulk0,
     &     b_bulk0,alpha0)
      implicit none
      integer maxpart,maxpart_l,maxcont_l,npart,ndomain
c
c---  inputs
      real scale_ls_over,b_ls_over,scale_ls_part(maxpart)
      real b_ls_part(maxpart),alpha(48),b_ls_aniso_over(6)
      real scale_ls_bulk,b_ls_bulk
c
c---  outputs
      real scale_ov0,b_ov0,scale_part0(maxpart_l),b_part0(maxpart_l)
      real alpha0(maxcont_l),baniso_ov0(6)
      real scale_bulk0,b_bulk0
c
c--locals
      
c
c---  body
      scale_ls_over          = scale_ov0
      b_ls_over              = b_ov0
      b_ls_aniso_over(1:6)   = baniso_ov0(1:6) 
      scale_ls_part(1:npart) = scale_part0(1:npart)
      b_ls_part(1:npart)     = b_part0(1:npart)
      alpha(1:ndomain)       = alpha0(1:ndomain)
      scale_ls_bulk          = scale_bulk0
      b_ls_bulk              = b_bulk0

      return
      end
c
      subroutine copy_ls_params(num_p,maxpart_l,maxcont_l,
     &     npart,ndomain,par0,scale_ov0,b_ov0,scale_part0,b_part0,
     &     baniso_ov0,scale_bulk0,b_bulk0,alpha0)
c
      implicit none
c
c---inputs
      integer max_num_p,maxpart_l,maxcont_l,npart,ndomain,num_p
      real scale_ov0,b_ov0,scale_bulk0,b_bulk0
      real baniso_ov0(6),scale_part0(maxpart_l),b_part0(maxpart_l)
      real alpha0(48)
c
c--outputs
      real par0(num_p)
c
c--locals
      integer ip,i
c
      if(ndomain.gt.1) then
         par0(1:ndomain-1) = alpha0(2:ndomain)
      endif
      ip = ndomain
      par0(ip:ip+4) = baniso_ov0(2:6)
      ip = ip + 5
      par0(ip) = scale_ov0
      ip = ip + 1
      par0(ip) = b_ov0
      do  i=1,npart
         ip = ip + 1
         par0(ip) = scale_part0(i)
         ip = ip + 1
         par0(ip) = b_part0(i)
      enddo
      ip = ip + 1
      par0(ip) = scale_bulk0
      ip = ip + 1
      par0(ip) = b_bulk0

      return
      end
c
      subroutine init_lambd_ls(num_p,shift,lambda,
     &        nmaxpart,npart,ndomain,
     &        alpha,scale_ls_over,b_ls_over,scale_ls_part,b_ls_part,
     &        b_ls_aniso_over,scale_ls_bulk,b_ls_bulk)
c
      implicit none 
c
c--inputs
      integer nmaxpart,ndomain,num_p,npart
      real alpha(48)
      real scale_ls_over,b_ls_over,scale_ls_bulk,b_ls_bulk
      real b_ls_aniso_over(6)
      real scale_ls_part(nmaxpart),b_ls_part(nmaxpart)
      real shift(num_p)
c
c---output
      real lambda
c
c--locals
      integer count
      integer ip,i,ipa,ishift
      real a_loc,shft3,alpha_sum
c
c---body
      lambda = 1.0
      count = 1

      ishift = 0
      do while(count.gt.0)
         ipa = 1
         ishift = ishift + 1
c
c---  Twin fractions
         count = 0
         if(ndomain.gt.1) then
            alpha_sum = 0.0
            do ip=2,ndomain
               a_loc = alpha(ip)-shift(ipa)*lambda
               ipa = ipa + 1
               alpha_sum = alpha_sum+a_loc
               if(a_loc.lt.0.0.or.a_loc.gt.1.0) count = count + 1
            enddo
            a_loc=1.0-alpha_sum
            if(a_loc.lt.0.0.or.a_loc.gt.1.0) count = count + 1
         endif
c
c--Overall scale and B
         a_loc      = scale_ls_over - shift(ipa)*lambda
         ipa = ipa + 1
         if(a_loc.le.0.0) count = count + 1
         a_loc          = b_ls_over     - shift(ipa)*lambda
         ipa = ipa + 1
         if(a_loc.gt.500.0.or.a_loc.lt.-100.0) count = count + 1
C
C---  Scale and B for partials
         do  ip=1,npart
            a_loc = scale_ls_part(ip)-shift(ipa)*lambda
            ipa = ipa + 1
            if(a_loc.lt.0.0) count = count + 1
            a_loc = b_ls_part(ip) - shift(ipa)*lambda
            ipa = ipa + 1
            if(a_loc.gt.500.0.or.a_loc.lt.-50.0) count = count + 1
         enddo
c
c---  Aniso B
         shft3 = 0.0
         a_loc = b_ls_aniso_over(1) - shift(ipa)*lambda
         shft3 = shift(ipa)
         ipa = ipa + 1
         a_loc = b_ls_aniso_over(2) - shift(ipa)*lambda
         shft3 = shft3 + shift(ipa)
         ipa = ipa + 1
         a_loc = b_ls_aniso_over(3) + shft3
         a_loc = b_ls_aniso_over(4) - shift(ipa)*lambda
         ipa = ipa + 1
         a_loc = b_ls_aniso_over(5) - shift(ipa)*lambda
         ipa = ipa + 1
         a_loc = b_ls_aniso_over(6) - shift(ipa)*lambda
         ipa = ipa + 1
c
c---  Babinet's B
         a_loc = scale_ls_bulk - shift(ipa)*lambda
         ipa = ipa + 1
         if(a_loc.lt.0.0.or.a_loc.gt.1.0) count = count + 1
         a_loc  = b_ls_bulk     - shift(ipa)*lambda
         if(a_loc.lt.-50.0.or.a_loc.gt.500.0) count = count + 1
         if(count.gt.0) lambda = lambda/2.0
      enddo
c
      return
      end
c
      subroutine add_shift_ls0(num_p,lambda,shift,
     &           nmaxpart,npart,ndomain,
     &           alpha,scale_ls_over,b_ls_over,scale_ls_part,
     &           b_ls_part,b_ls_aniso_over,scale_ls_bulk,b_ls_bulk)
      implicit none 
      real alpha(48)
      integer nmaxpart
      real b_ls_aniso_over(6),scale_ls_over,b_ls_over,scale_ls_bulk
      real b_ls_bulk,scale_ls_part(nmaxpart),b_ls_part(nmaxpart)
      integer npart,ndomain,num_p
      real lambda,shift (num_p)
c
c--   locals
      real alpha_sum,shft3
      integer ip,ipa,j
c     add shift to alpha 2 to alpha n
c
c---Chek if shifts are reasonable.
      alpha_sum=0.0
      do ip=1,ndomain-1
 90      continue
         if(alpha(ip+1)-shift(ip).lt.0.0)then 
            do j=1,ndomain+2*npart+8
               shift(j)=shift(j)/2.0
            enddo
            go to 90
         endif 
      enddo
 80    continue
       if(scale_ls_over - shift(ndomain).lt.0.0)then 
          do j=1,ndomain+2*npart+8
             shift(j)=shift(j)/2.0
          enddo 
          go to 80
       endif  
c      add shift now       
c
c---  Twin fractions
       do ip=1,ndomain-1
          alpha(ip+1)=alpha(ip+1)-shift(ip)*lambda
       enddo
       
       do ip=2,ndomain
          alpha_sum=alpha_sum+alpha(ip)
       enddo
       alpha(1)=1-alpha_sum
c
c--Overall scale and B
       ipa = ndomain
       scale_ls_over      = scale_ls_over - shift(ipa)*lambda
       ipa = ipa + 1
       b_ls_over          = b_ls_over     - shift(ipa)*lambda
       ipa = ipa + 1
C
C---  Scale and B for partials
       do  ip=1,npart
          scale_ls_part(ip) = scale_ls_part(ip)-shift(ipa)*lambda
          ipa = ipa + 1
          b_ls_part(ip) = b_ls_part(ip) -shift(ipa)*lambda
          ipa = ipa + 1
       enddo

c
c---  Aniso B
       shft3 = 0.0
       b_ls_aniso_over(1) = b_ls_aniso_over(1) - shift(ipa)*lambda
       shft3 = shift(ipa)
       ipa = ipa + 1
       b_ls_aniso_over(2) = b_ls_aniso_over(2) - shift(ipa)*lambda
       shft3 = shft3 + shift(ipa)
       ipa = ipa + 1
       b_ls_aniso_over(3) = b_ls_aniso_over(3) + shft3*lambda
       b_ls_aniso_over(4) = b_ls_aniso_over(4) - shift(ipa)*lambda
       ipa = ipa + 1
       b_ls_aniso_over(5) = b_ls_aniso_over(5) - shift(ipa)*lambda
       ipa = ipa + 1
       b_ls_aniso_over(6) = b_ls_aniso_over(6) - shift(ipa)*lambda
       ipa = ipa + 1
c
c---  Babinet's B
       scale_ls_bulk = scale_ls_bulk - shift(ipa)*lambda
       ipa = ipa + 1
       b_ls_bulk     = b_ls_bulk     - shift(ipa)*lambda
       return
       end
