      subroutine ml_getexpected_f(maxsym,nsym,rot,tr,cell,
     &     nasym,hkl_asym,fcalc,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fexp,
     &     ierr)
      implicit none
      include 'agreem.fh'
c
c---  inputs
      integer maxsym,nsym
      real cell(6),rot(3,3,maxsym),tr(3,maxsym)
      integer nasym
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)  
c
c--   outputs
      integer ierr
      real fexp(2,nasym)
C
C---  locals
      real, allocatable :: scales(:)
      real, allocatable :: icalc(:)
      real, allocatable :: epsls(:)
      real, allocatable :: centrs(:)
      real, allocatable :: sigmas(:)
      real, allocatable :: fc1(:,:)
      real, allocatable :: fmax(:)
c
c--   for derivatives
      integer maxcont,i
      real df(48),df2(48)
      logical error
c
      real fmod,phi,fmod1,phi1,cc,A0,B0,A1,B1
c
c---body
      writE(*,*)'We are in ml_getf'
      maxcont = 48
      allocate(scales(nasym))
      allocate(epsls(nasym))
      allocate(centrs(nasym))
      allocate(fc1(2,nasym))
      allocate(fmax(nasym))
      allocate(sigmas(nasym))

      call calc_epsls_centrs(nasym,maxsym,nsym,rot,hkl_asym,epsls,
     &     centrs)
      write(*,*)'After epsls'
c
c--remove this
      call scale2asym(maxsym,nasym,nsym,cell,rot,tr,hkl_asym,
     &     b_ls_aniso_over,scales,error)
      write(*,*)'After scales'
      call calc_sigmas(nasym,cell,sigmas,hkl_asym,error)
      write(*,*)'After sigmas'
      call  calc_full_fcalc(nasym,npart_act,cell,hkl_asym,
     &     fcalc,fpart,fc1,error)
      write(*,*)'After full fcalc'
c
c--Using a simple approximation calculate detwinned structur factors
      call calc_f_mlgauss(maxsym,nsym,rot,tr,cell,
     &     nasym,hkl_asym,fc1,sigmas,epsls,centrs,fmax,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)
c
c--Improve detwinned structure factors usin laplace approximation to 
c--ml
c      call calc_f_mllaplace(num_block,nasym,sum_contri,nobs,ncomp,
c     &     nref_block_obs,nref_comp,
c     &     nref_block_contri,block_contributor,obs_2_asym,comp_numb,
c     &     scales,sigmas,iobs,abcd,fc1,epsls,centrs,alpha,fmax,error)

      write(*,*)'After f_mllaplace'
c
c--   Calculate the expected value of structure factors using laplace 
c--   approximation. Calculate the functional value also.
c      call calc_fexp_mllaplace(num_block,nasym,sum_contri,nobs,ncomp,
c     &     nref_block_obs,nref_comp,
c     &     nref_block_contri,block_contributor,obs_2_asym,comp_numb,
c     &     scales,sigmas,iobs,abcd,fc1,epsls,centrs,alpha,fmax,fexp,
c     &     error)
c
c---Now calculate expected value of the structure factors using ML
      open(44)
      cc = 180.0/(4.0*atan2(1.0,1.0))
      do  i=1,nasym
         A0 = fexp(1,i) - fc1(1,i)
         B0 = fexp(2,i) - fc1(2,i)
         A1 = fexp(1,i) + A0
         B1 = fexp(2,i) + B0
         fmod = sqrt(A1**2+B1**2)
         fmod1 = sqrt(A0**2+B0**2)
         phi = 0.0
         if(fmod.gt.0.0) phi = atan2(B1,A1)*cc
         phi1 = 0.0
         if(fmod1.gt.0.0) phi1 = atan2(B0,A0)*cc
         write(44,'(3I4,4F10.3)')hkl_asym(1:3,i),fmod,phi,fmod1,phi1
      enddo
      close(44)
      deallocate(scales)
      deallocate(epsls)
      deallocate(centrs)
      deallocate(fc1)
      deallocate(fmax)
      deallocate(sigmas)
      call ccperr(1,'That is all we have')
      return
      end
c
      subroutine scale2asym(maxsym,nasym,nsym,cell,rot,tr,hkl_asym,
     &     scale_ml_over,b_ml_over,b_ml_aniso,scale_ml_bulk,
     &     b_ml_bulk,scales,error)

      implicit none
c
c---  inputs
      integer nasym,maxsym,nsym
      real rot(3,3,maxsym),tr(3,maxsym),cell(6)
      integer hkl_asym(3,nasym)
      real scale_ml_over,b_ml_over,b_ml_aniso(6)
      real scale_ml_bulk,b_ml_bulk
c
c---  outputs
      real scales(nasym)
      logical error
c
c---  locals
      real cs_frac_to_ort(3,3),cs_ort_to_frac(3,3)
      real hkl_this(3),hkl_sym(3)
      real s_this(3),ss_v(6)
      real bans,exp1
      real ast,bst,cst,cosast,cosbst,coscst,rsq,ss,expban
      integer i,is,ierror
c
c---  body
      error = .FALSE.
      do  i=1,nasym
         call calc_aniso_scale(maxsym,nsym,rot,tr,cell,
     &     cs_ort_to_frac,hkl_this,b_ml_aniso,expban)
         scales(i) = expban
      enddo
      return
      end
c
      subroutine calc_sigmas(nasym,cell,sigmas,hkl_asym,
     &    error)
      implicit none
      include 'agreem.fh'
c
c---  inputs
      integer nasym
      real cell(6)
      integer hkl_asym(3,nasym)
c
c---  outputs
      real sigmas(nasym)
      logical error
c
c---  locals
      real cs_frac_to_ort(3,3),cs_ort_to_frac(3,3)
      real hkl_this(3),hkl_sym(3)
      real s_this(3),ss_v(6)
      real ast,bst,cst,cosast,cosbst,coscst,rsq,ss,expban
      integer i,is,ierror
c
c---  body
      error = .FALSE.
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierror)
      call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
      do  i=1,nasym
         call define_res(hkl_asym(1,i),hkl_asym(2,i),
     &        hkl_asym(3,i),ast,bst,cst,cosast,cosbst,coscst,rsq)
         ss=rsq/4.0
         sigmas(i) = exp(sigma_ml_scale_over-ss*sigma_ml_b_over)*
     &        (1.0-exp(sigma_ml_scale_bulk-ss*sigma_ml_b_bulk))
      enddo
      return
      end
c
      subroutine calc_full_fcalc(nasym,npart1,cell,hkl_asym,fc,
     &     fcp1,fcout,error)
      implicit none
      include 'agreem.fh'
c
c---inputs
      integer nasym,npart1
      real cell(6)
      integer hkl_asym(3,nasym)
      real fc(2,nasym),fcp1(npart1,2,nasym)

c
c--outputs
      real fcout(2,nasym)
      logical error
c
c---locals
      real expbs_bulk
      real cs_frac_to_ort(3,3),cs_ort_to_frac(3,3)
      real ast,bst,cst,cosast,cosbst,coscst,rsq,ss
      integer i,ip
      integer ierror
c
c---  body
      error = .FALSE.
      call nb_frorth(cell(1),cell(2),cell(3),cell(4),cell(5),cell(6),
     &     cs_frac_to_ort,cs_ort_to_frac,ierror)
      call define_res_pars(cell,ast,bst,cst,cosast,cosbst,coscst)
      do   i=1,nasym
         fcout(1,i) = fc(1,i)
         fcout(2,i) = fc(2,i)
         call define_res(hkl_asym(1,i),hkl_asym(2,i),
     &        hkl_asym(3,i),ast,bst,cst,cosast,cosbst,coscst,rsq)
         ss=rsq/4.0
         do   ip=1,npart_act
            fcout(1,i) = fcout(1,i) + 
     &           scale_ml_part(ip)*exp(-ss*b_ml_part(ip))*fcp1(ip,1,i)
            fcout(2,i) = fcout(2,i)+
     &           scale_ml_part(ip)*exp(-ss*b_ml_part(ip))*fcp1(ip,2,i)
         enddo
         expbs_bulk=scale_ml_over*exp(-ss*b_ml_over)*
     &        (1.0-scale_ml_bulk*exp(-ss*b_ml_bulk))
         expbs_bulk = sqrt(expbs_bulk)
         fcout(1,i) = fcout(1,i)*expbs_bulk
         fcout(2,i) = fcout(2,i)*expbs_bulk
      enddo
      return
      end
c
      subroutine calc_f_mlgauss(maxsym,nsym,rot,tr,cell,
     &     nasym,hkl_asym,fc1,sigmas,epsls,centrs,fmax,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)
      implicit none
      include 'agreem.fh'
c
c---  inputs
      integer maxsym,nsym
      real cell(6),rot(3,3,maxsym),tr(3,maxsym)
      integer nasym
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      real    sigmas(nasym),scales(nasym),epsls(nasym),centrs(nasym)
      real    fc1(2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)  

c
c--   outputs
      real fmax(nasym)
      integer ierr
c
c--   locals
      logical error
      integer icycle,ncycle
      integer i,j,nc,jc,jc1,m,o_s,o_e,c_n,c_n1,o_c_s,o_c_e,jal,jal1
      integer c_s,c_e
      integer k,k1
      real ic0,fc0,Ict0,ic1,sigma0,sigma1
      real delta,fvalue
      real Ic(48),scale_loc(48)
      real df(48),df2(48,48),shift(48)
      real toler,lambda
      data toler/1.0E-6/
c
c---Find initial estimation for detwinned structure factors using
c---gaussian approximation   
      write(*,*)'In mlgauss'
      do  i=1,nasym
         fmax(i) = sqrt(fc1(1,i)**2+fc1(2,i)**2)
      enddo
      ncycle = 20
      do  i=1,num_blocks
c     
c--   Define necessary pointers to contributors and observations
         o_s=block_start(i)+1
         o_e=block_start(i+1)
         c_s=ref_2_asym_start(i)+1
         c_e=ref_2_asym_start(i+1)
c
c---  May need loop over cycles.
         do icycle = 1,ncycle
            jc=0
            fvalue = 0.0
            nc = c_e-c_s+1
            df(1:nc) = 0.0
            df2(1:nc,1:nc) = 0.0
            do m=c_s,c_e
               jc = jc+1
               c_n = block_2_asym(m)
               fc0 = sqrt(fc1(1,c_n)**2+fc1(2,c_n)**2)
               sigma0 = epsls(c_n)*sigmas(c_n)
               sigma1 = (1.0+centrs(c_n))*sigma0
c     
c--   for ml we need to calculate several integrals. Assuming that we
c--   are near to maximum
               delta = fmax(c_n)-fc0
               fvalue = fvalue + delta**2/sigma1
               df(jc) = df(jc) + (fmax(c_n)-fc0)/sigma1
               df2(jc,jc) = df2(jc,jc) + 1.0/sigma1
               Ic(jc) = fmax(c_n)**2
               scale_loc(jc) = scales(c_n)
            enddo
c     
            do  j=o_s,o_e
               o_c_s=obs_start(j)+1
               o_c_e=obs_start(j+1)
               do  k=o_c_s,o_c_e
                  jc  = ref_2_asym(k)
                  jal = comp_numb(k)
                  Ict0 = Ict0 + Ic(jc)*alpha(jal)*scale_loc(jc)
               enddo
               delta = Ict0-iobs(1,j)
               fvalue = fvalue + delta**2/(2.0*iobs(2,j)**2)
               do k=o_c_s,o_c_e
                  jc = ref_2_asym(k)
                  jal = comp_numb(k)
                  df(jc) = df(jc) + 
     &                 2.0*alpha(jal)*scale_loc(jc)*
     &                 sqrt(Ic(jc))*delta/iobs(2,j)**2
                  do  k1=o_c_s,o_c_e
                     jc1  = ref_2_asym(k1)
                     jal1 = comp_numb(k1)
                     df2(jc,jc1) = df2(jc,jc1) + 
     &                    4.0*scale_loc(jc)*scale_loc(jc1)*
     &                    sqrt(Ic(jc))*sqrt(Ic(jc1))*
     &                    alpha(jal)*alpha(jal1)/iobs(2,j)**2
                  enddo
               enddo
            enddo
c     
c--   Solve the equation
            write(*,*)'Functional value =',fvalue
            call solve_linear(48,nc,toler,df,df2,shift,error)
c
c--line minimise
            if(error) then
               write(*,*)nc,toler,df(1:nc),df2(1:nc,1:nc)
               stop
            endif
            jc = 0
            lambda = 1.0
            do  m=c_s,c_e
               jc = jc + 1
               c_n = block_2_asym(m)
               fmax(c_n) = fmax(c_n) - lambda*shift(m)
            enddo
         enddo
      enddo
      return
      end
c
      subroutine calc_f_mllaplace(num_block,nasym,sum_contri,nobs,ncomp,
     &     nref_block_obs,nref_comp,
     &     nref_block_contri,block_contributor,obs_2_asym,comp_numb,
     &     scales,sigmas,iobs,abcd,fc1,epsls,centrs,alpha,fmax,error)

      implicit none
c
c---inputs
      integer num_alpha,npart1,sum_contri,nobs,num_block,ncomp,nasym
      integer nref_block_obs(num_block+1)
      integer nref_block_contri(num_block+1)
      integer block_contributor(sum_contri)
      integer nref_comp(nobs+1)
      integer comp_numb(ncomp)
      integer  obs_2_asym(ncomp)   
      real iobs(2,nobs)
      real fc1(2,nasym),epsls(nasym),centrs(nasym),abcd(4,nasym)
      real scales(nasym),sigmas(nasym)
      real alpha(48)
c
c--   outputs
      real fmax(nasym)
      logical error
c
c--locals
      integer i,j,icycle,maxcont,ir
      integer c_s,c_e,c_n,jline,jc,nc
      integer o_s,o_e,o_c_s,o_c_e
      integer k,k1
      real ftmp(48)
      real fval_c,lambd,lambdmin,f1,fold,g2p,tst
      real l12,r1,r2,a,b,d1,tmp,lambd2,f2,al0
      real df(48),df2(48,48),shift(48)
      real toler,tol_conv
      data toler/5.0E-8/,tol_conv/1.E-2/
      real dot_r
      external dot_r
      integer count
c
c--Calculate the maximum of the exponent
      maxcont = 48
      write(*,*)'In mllaplace'
      do  i=1,num_block
         ir = i
         c_s=nref_block_contri(ir)+1
         c_e=nref_block_contri(ir+1)
         jc = 0
         o_s=nref_block_obs(i)+1
         o_e=nref_block_obs(i+1)
         do  j=c_s,c_e
            jc = jc + 1
            c_n = block_contributor(j)
            ftmp(jc) = fmax(c_n)
         enddo
         do  icycle=1,50
            call deriv_mllaplace(nasym,num_block,nobs,ncomp,sum_contri,
     &           num_alpha,maxcont,nc,ir,nref_block_obs,
     &           nref_block_contri,
     &           block_contributor,nref_comp,obs_2_asym,comp_numb,
     &           sigmas,abcd,
     &           fc1,iobs,scales,centrs,epsls,alpha,fmax,df,df2,fval_c)
            fold = fval_c
c
c--Solve the equation
            shift(1:nc) = 0.0
            call solve_linear(48,nc,toler,df,df2,shift,error)

            if(error) then
               write(*,*)nc,toler,df(1:nc),df2(1:nc,1:nc)
               stop
            endif
c     
            g2p = dot_r(nc,48,shift,df)
            tst = 0.0
            do  j=1,nc
               tst = max(tst,abs(shift(j)/max(abs(ftmp(j)),1.0)))
            enddo
            if(tst.eq.0.0) goto 20
            lambdmin = tol_conv/tst
            lambd = 1.0
c
c--   Find the initial lambda
            count = 1
            do while(count.gt.0)
               count = 0
               jc = 0
               do j = c_s,c_e
                  c_n = block_contributor(j)
                  jc = jc + 1
                  if(ftmp(jc)-lambd*shift(jc).le.0.0) 
     &                 count = count + 1
               enddo
               lambd = lambd/2.0
            enddo
c
c--line minimisation
            do jline=1,100
c
c--   add shifts
               jc = 0
               do  j=c_s,c_e
                  c_n = block_contributor(j)
                  jc = jc + 1
                  fmax(c_n) = ftmp(jc) - lambd*shift(jc)
               enddo
c
c--calculate the value of function
               call fvalue_mllaplace(nasym,num_block,nobs,ncomp,
     &              sum_contri,
     &              num_alpha,nc,i,nref_block_obs,nref_block_contri,
     &              block_contributor,nref_comp,obs_2_asym,comp_numb,
     &              sigmas,
     &              abcd,fc1,iobs,scales,centrs,epsls,alpha,fmax,f1)
c     
c--   Shifts are too small or convergence have been reached
               if(lambd.le.lambdmin) goto 20
               if(f1.le.fold+al0*lambd*g2p) goto 20
c     
c--   Try new point and use interpolations
               if(jline.eq.1) then
                  tmp = -g2p/(2.0*(f1-fold-g2p))
               else
                  l12 = lambd-lambd2
                  r1 = f1-fold-lambd*g2p
                  r2 = f2-fold-lambd2*g2p
                  a  = (r1/lambd**2-r2/lambd2**2)/l12
                  b = (-lambd2*r1/lambd**2+lambd*r2/lambd2**2)/l12
                  if(a.eq.0.0) then
                     tmp = -g2p/(2.0*b)
                  else
                     d1 = max(0.0,b**2-3.0*a*g2p)
c     d                  if(d1.le.0.0) then
c     d                     call errwrt(0,'Problem with roundoff')
c     d                  endif
                     tmp = (-b+sqrt(d1))/(3.0*a)
                  endif
               endif
               tmp = min(tmp,0.9*lambd)
               lambd2 = lambd
               f2 = f1
               lambd = max(tmp,0.1*lambd)
            enddo
            call errwrt(1,'Line minimisation failed')
 20         continue
c
c--Check the convergence
            tst = 0.0
            do  j=1,nc
               tst = max(tst,abs(shift(j))*lambd/max(abs(ftmp(j)),1.0))
            enddo
            tst = g2p*lambd/2.0
            if(tst.lt.tol_conv.or.f1.gt.fold) then
               if(f1.gt.fold) then
                  jc = 0
                  do  j=c_s,c_e
                     c_n = block_contributor(j)
                     jc = jc + 1
                     fmax(c_n) = ftmp(jc)
                  enddo
               endif
               goto 30
            endif
            jc = 0
            do  j=c_s,c_e
               c_n = block_contributor(j)
               jc = jc + 1
               fmax(c_n) = ftmp(jc) - shift(jc)*lambd
               ftmp(jc) = fmax(c_n)
            enddo
         enddo
 30      continue

      enddo
      return
      end
c
      subroutine deriv_mllaplace(nasym,num_block,nobs,ncomp,sum_contri,
     &     num_alpha,maxcont,nc,ir,nref_block_obs,nref_block_contri,
     &     block_contributor,nref_comp,obs_2_asym,comp_numb,sigmas,
     &     abcd,fc1,iobs,
     &     scales,centrs,epsls,alpha,fmax,df,df2,fval_c)
      implicit none
c
c---inputs
      integer ir,maxcont
      integer num_alpha,npart1,sum_contri,nobs,num_block,ncomp,nasym
      integer nref_block_obs(num_block+1)
      integer nref_block_contri(num_block+1)
      integer block_contributor(sum_contri)
      integer nref_comp(nobs+1)
      integer comp_numb(ncomp)
      integer  obs_2_asym(ncomp)   
      real iobs(2,nobs)
      real fc1(2,nasym),epsls(nasym),centrs(nasym),abcd(4,nasym)
      real scales(nasym),sigmas(nasym)
      real alpha(48)
      real fmax(nasym)
c
c--outputs
      integer nc
      real df(maxcont),df2(maxcont,maxcont)
      real fval_c
c
c--locals
      integer j,jc,jc1,m,o_s,o_e,c_n,c_n1,o_c_s,o_c_e,jal,jal1
      integer c_s,c_e
      integer k,k1
      integer icent
      real ic0,fc0,ic1,sigma0,sigma1,io0(48),fo0(48)
      real ftmp(48)
      real const1,a,delta
      real cosa,sina,cos2a,sin2a,cosc,sinc,fom,fomd,cosdiff,cos2diff
      real cos2c,sin2c
      real xx,xx0,xx1
      real Ict
      real fval
      real eps_loc
      data eps_loc/1.0E-3/
      real sim
      external sim
      logical error
c
c---body
c     
c--   Define necessary pointers to contributors and observations
      o_s=nref_block_obs(ir)+1
      o_e=nref_block_obs(ir+1)
      c_s=nref_block_contri(ir)+1
      c_e=nref_block_contri(ir+1)
      jc=0
      nc = c_e-c_s+1
      df(1:nc) = 0.0
      df2(1:nc,1:nc) = 0.0
      fval_c = 0.0
      do m=c_s,c_e
         jc = jc+1
         c_n = block_contributor(m)
         sigma0 = epsls(c_n)*sigmas(c_n)
         ic0 = fc1(1,c_n)**2+fc1(2,c_n)**2
         fc0    = sqrt(ic0)
         io0(jc) = fmax(c_n)**2
         fo0(jc) = fmax(c_n)
         xx  = 2.0*fo0(jc)*fc0/sigma0
         icent = nint(centrs(c_n))
         if(  abs(abcd(1,c_n)).le.eps_loc.and.
     &        abs(abcd(2,c_n)).le.eps_loc.and.
     &        abs(abcd(3,c_n)).le.eps_loc.and.
     &        abs(abcd(4,c_n)).le.eps_loc) then
            
            if(icent.eq.0) then
c     
c--   acentric
c---  treat 0 x seperately. Take care of phase info
               call bessi0(xx,xx0,xx1)
               fom = sim(xx)
               if(xx.gt.eps_loc) then
                  fomd = (1-fom/xx-fom**2)
               else
                  fomd = 0.5
               endif
               df(jc) =  df(jc) + 
     &              2.0*(fo0(jc)-fom*fc0)/sigma0-1/fo0(jc)
               df2(jc,jc) = df2(jc,jc) + 
     &              2.0/sigma0-fomd*(2.0*fc0/sigma0)**2+
     &              1/fo0(jc)**2
               fval_c = fval_c + (fo0(jc)**2+fc0**2)/sigma0-
     &              xx1 - log(xx0) - log(fo0(jc))
            else
c     
c--   centric
               if(xx.le.30.0) then
                  fval = log(cosh(xx/2.0))
                  fom = tanh(xx/2.0)
               else
                  fval = xx/2.0
                  fom = 1.0
               endif
               fomd = 1-fom**2
               df(jc) = (fo0(jc)-fom*fc0)/sigma0
               df2(jc,jc) = 1/sigma0-fomd*(fc0/sigma0)**2
               fval_c = fval_c + 
     &              (fc0**2-fo0(jc)**2)/(2.0*sigmas(c_n))-fval
            endif
         else
            if(fc0.gt.0.0) then
               cosc = fc1(1,c_n)/fc0
               sinc = fc1(2,c_n)/fc0
            else
               cosc = 0.0
               sinc = 0.0
            endif
            call calc_mcoss(icent,xx,abcd(1,c_n),cosc,sinc,
     &           cosa,sina,cos2a,sin2a,fval,error)
            cos2c = cosc*cosc-sinc*sinc
            sin2c = 2.0*cosc*sinc
            cosdiff = cosa*cosc+sina*sinc
            cos2diff = cos2a*cos2c+cos2a*cos2c
            if(nint(centrs(c_n)).eq.0) then
               cosdiff = cosa*cosc+sina*sinc
               cos2diff = cos2a*cos2c+cos2a*cos2c
               df(jc) = 2.0*(fo0(jc)-cosdiff*fc0)/sigma0-1/fo0(jc)
               df2(jc,jc) = 2/sigma0-2.0*(1+cos2diff)*
     &              (fc0/sigma0)**2+
     &              1/fo0(jc)**2
            else
               df(jc) = (fo0(jc)-cosdiff*fc0)/sigma0
               df2(jc,jc) = 1/sigma0-cos2diff*(fc0/sigma0)**2
            endif
            fval_c = fval_c + 
     &           (fc0**2+fo0(jc)**2)/((1.0+centrs(c_n))*sigma0) -
     &           fval
            if(icent.eq.0) then
               fval_c = fval_c - log(fo0(jc))
            endif
         endif
      enddo
c
      do  j=o_s,o_e
         o_c_s=nref_comp(j)+1
         o_c_e=nref_comp(j+1)
         Ict = 0.0
         do  k=o_c_s,o_c_e
            jc = obs_2_asym(k)
            jal = comp_numb(k)
            c_n = block_contributor(jc+c_s-1)
            Ict = Ict + alpha(jal)*io0(jc)*scales(c_n)
         enddo
         delta = Ict - iobs(1,j)
         const1 = 1.0/iobs(2,j)**2
         fval_c = fval_c + delta**2*const1/2.0
         do  k=o_c_s,o_c_e
            jc  = obs_2_asym(k)
            c_n = block_contributor(jc+c_s-1)
            jal = comp_numb(k)
            df(jc) = df(jc) + 
     &           2.0*alpha(jal)*delta*fo0(jc)*scales(c_n)*const1
            df2(jc,jc) = df2(jc,jc) + 
     &           2.0*alpha(jal)*delta*scales(c_n)*const1
            do  k1=o_c_s,o_c_e
               jc1 = obs_2_asym(k1)
               c_n1 = block_contributor(jc1+c_s-1)
               jal1 = comp_numb(k1)
               df2(jc,jc1) = df2(jc,jc1) + 
     &              4.0*scales(c_n)*scales(c_n1)*
     &              alpha(jal)*alpha(jal1)*fo0(jc)*fo0(jc1)*const1
            enddo
         enddo
      enddo
c
      return
      end
c
      subroutine fvalue_mllaplace(nasym,num_block,nobs,ncomp,sum_contri,
     &     num_alpha,nc,ir,nref_block_obs,nref_block_contri,
     &     block_contributor,nref_comp,obs_2_asym,comp_numb,
     &     sigmas,abcd,fc1,iobs,
     &     scales,centrs,epsls,alpha,fmax,fval_c)
      implicit none
c
c---inputs
      integer ir
      integer num_alpha,npart1,sum_contri,nobs,num_block,ncomp,nasym
      integer nref_block_obs(num_block+1)
      integer nref_block_contri(num_block+1)
      integer block_contributor(sum_contri)
      integer nref_comp(nobs+1)
      integer comp_numb(ncomp)
      integer  obs_2_asym(ncomp)   
      real iobs(2,nobs)
      real fc1(2,nasym),epsls(nasym),centrs(nasym),abcd(4,nasym)
      real scales(nasym),sigmas(nasym)
      real alpha(48)
      real fmax(nasym)
c
c--outputs
      integer nc
      real fval_c
c
c--locals
      integer j,jc,jc1,m,o_s,o_e,c_n,c_n1,o_c_s,o_c_e,jal,jal1
      integer c_s,c_e
      integer k,k1
      integer icent
      real ic0,fc0,ic1,sigma0,sigma1,io0(48),fo0(48)
      real ftmp(48)
      real const1,a,delta
      real cosa,sina,cos2a,sin2a,cosc,sinc,fom
      real xx,xx0,xx1
      real Ict
      real fval
      real eps_loc
      data eps_loc/1.0E-3/
      real sim
      external sim
      logical error
c
c---body
c     
c--   Define necessary pointers to contributors and observations
      o_s=nref_block_obs(ir)+1
      o_e=nref_block_obs(ir+1)
      c_s=nref_block_contri(ir)+1
      c_e=nref_block_contri(ir+1)
      jc=0
      nc = c_e-c_s+1
      fval_c = 0.0
      do m=c_s,c_e
         jc = jc+1
         c_n = block_contributor(m)
         sigma0 = epsls(c_n)*sigmas(c_n)
         ic0 = fc1(1,c_n)**2+fc1(2,c_n)**2
         fc0    = sqrt(ic0)
         io0(jc) = fmax(c_n)**2
         fo0(jc) = fmax(c_n)
         xx  = 2.0*fo0(jc)*fc0/sigma0
         icent = nint(centrs(c_n))
         if(  abs(abcd(1,c_n)).le.eps_loc.and.
     &        abs(abcd(2,c_n)).le.eps_loc.and.
     &        abs(abcd(3,c_n)).le.eps_loc.and.
     &        abs(abcd(4,c_n)).le.eps_loc) then
            
            if(icent.eq.0) then
c     
c--   acentric
c---  treat 0 x seperately. Take care of phase info
               call bessi0(xx,xx0,xx1)
               fval_c = fval_c + (fo0(jc)**2+fc0**2)/sigma0-
     &              xx1 - log(xx0) - log(fo0(jc))
            else
c     
c--   centric
               if(xx.le.30.0) then
                  fval = log(cosh(xx/2.0))
               else
                  fval = xx/2.0
               endif
               fval_c = fval_c + 
     &              (fc0**2-fo0(jc)**2)/(2.0*sigmas(c_n))-fval
            endif
         else
            if(fc0.gt.0.0) then
               cosc = fc1(1,c_n)/fc0
               sinc = fc1(2,c_n)/fc0
            else
               cosc = 0.0
               sinc = 0.0
            endif
            call calc_mcoss(icent,xx,abcd(1,c_n),cosc,sinc,
     &           cosa,sina,cos2a,sin2a,fval,error)
            fval_c = fval_c + 
     &           (fc0**2+fo0(jc)**2)/((1.0+centrs(c_n))*sigma0) -
     &           fval
            if(icent.eq.0) then
               fval_c = fval_c - log(fo0(jc))
            endif
         endif
      enddo
c     
      do  j=o_s,o_e
         o_c_s=nref_comp(j)+1
         o_c_e=nref_comp(j+1)
         Ict = 0.0
         do  k=o_c_s,o_c_e
            jc = obs_2_asym(k)
            jal = comp_numb(k)
            c_n = block_contributor(jc+c_s-1)
            Ict = Ict + alpha(jal)*io0(jc)*scales(c_n)
         enddo
         delta = Ict - iobs(1,j)
         const1 = 1.0/iobs(2,j)**2
         fval_c = fval_c + delta**2*const1/2.0
      enddo
c
      return
      end
c
      subroutine calc_fexp_mllaplace(num_block,nasym,sum_contri,nobs,
     &     ncomp,nref_block_obs,nref_comp,
     &     nref_block_contri,block_contributor,obs_2_asym,comp_numb,
     &     scales,sigmas,iobs,abcd,fc1,epsls,centrs,alpha,fmax,fexp,
     &     error)
      implicit none
c
c--inputs
      integer num_alpha,npart1,sum_contri,nobs,num_block,ncomp,nasym
      integer nref_block_obs(num_block+1)
      integer nref_block_contri(num_block+1)
      integer block_contributor(sum_contri)
      integer nref_comp(nobs+1)
      integer comp_numb(ncomp)
      integer  obs_2_asym(ncomp)   
      real iobs(2,nobs)
      real fc1(2,nasym),epsls(nasym),centrs(nasym),abcd(4,nasym)
      real scales(nasym),sigmas(nasym)
      real fmax(nasym)
      real alpha(48)
c
c--outputs
      real fexp(2,nasym)
      logical error
c
c--locals
      integer maxcont,nc
      integer i,j,jc,jc1,m,o_s,o_e,c_n,c_n1,o_c_s,o_c_e,jal,jal1
      integer c_s,c_e
      integer k,k1
      integer icent
      real ic0,fc0,ic1,sigma0,sigma1,fo0
      real cosa,sina,cos2a,sin2a,cosc,sinc,fom
      real xx,fval
      real Ict
      real eps_loc
      data eps_loc/1.0E-3/
      real sim
      external sim
c
c---body
      maxcont = 48
      do  i=1,nasym
         fexp(1,i)=fc1(1,i)
         fexp(2,i)=fc1(2,i)
      enddo
      do  i=1,num_block
         o_s=nref_block_obs(i)+1
         o_e=nref_block_obs(i+1)
         c_s=nref_block_contri(i)+1
         c_e=nref_block_contri(i+1)
         jc=0
         do m=c_s,c_e
            jc = jc+1
            c_n = block_contributor(m)
            sigma0 = epsls(c_n)*sigmas(c_n)
            ic0 = fc1(1,c_n)**2+fc1(2,c_n)**2
            fc0    = sqrt(ic0)
            fo0 = fmax(c_n)
            xx  = 2.0*fo0*fc0/sigma0
            icent = nint(centrs(c_n))
            cosc = 0.0
            sinc = 0.0
            if(fc0.gt.0.0) then
               cosc = fc1(1,c_n)/fc0
               sinc = fc1(2,c_n)/fc0
            endif
            if(  abs(abcd(1,c_n)).le.eps_loc.and.
     &           abs(abcd(2,c_n)).le.eps_loc.and.
     &           abs(abcd(3,c_n)).le.eps_loc.and.
     &           abs(abcd(4,c_n)).le.eps_loc) then
               
               if(icent.eq.0) then
c     
c--   acentric
c---  treat 0 x seperately. Take care of phase info
                  fom = sim(xx)
               else
                  if(xx.le.30.0) then
                     fom = tanh(xx/2.0)
                  else
                     fom = 1.0
                  endif
               endif
               cosa = fom*cosc
               sina = fom*sinc
            else
               if(fc0.gt.0.0) then
                  cosc = fc1(1,c_n)/fc0
                  sinc = fc1(2,c_n)/fc0
               else
                  cosc = 0.0
                  sinc = 0.0
               endif
               call calc_mcoss(icent,xx,abcd(1,c_n),cosc,sinc,
     &              cosa,sina,cos2a,sin2a,fval,error)
            endif
            fexp(1,c_n) = fmax(c_n)*cosa
            fexp(2,c_n) = fmax(c_n)*sina
         enddo
      enddo
c
      return
      end
