C --- MOD_SUBR.FTN ---
C ------------------------------------------------------------
      SUBROUTINE CHECK_BOND(MDOC,RS_NAME,RS_NBOND,RS_LABEL
     *     ,ATOM1,ALT1,ATOM2,ALT2,RS_VIDL,RS_SDI,RS_VOBS
     *     ,RMS_B,NB_GT_1S,NB_GT_3S,NB_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NBOND
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
C ----------------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
C --------
      DEL = ABS(RS_VIDL-RS_VOBS)
      SD  = RS_SDI
      IF(SD.LE.0.0) SD=1.0
      TEST=DEL/SD
      IF(TEST.GT. 1.0) NB_GT_1S  = NB_GT_1S  + 1 
      IF(TEST.GT. 3.0) NB_GT_3S  = NB_GT_3S  + 1 
      IF(TEST.GT.10.0) NB_GT_10S = NB_GT_10S + 1
      RMS_B = RMS_B + DEL*DEL 
      IF(TEST.GT.SLIM) THEN
        IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
        IFLAG=1
        WRITE(LINE,100) RS_NAME,RS_LABEL
     *  ,ATOM1,ALT1,ATOM2,ALT2
     *  ,RS_VIDL,RS_SDI,RS_VOBS

 100    FORMAT(A4,1X,A8,1X,
     *  A4,1X,A1,' - ',A4,1X,A1
     *      ,1X,F7.3,1X,F7.3,1X,F7.3)
        CALL MSGDOC(MD,LINE)
      ENDIF
C --------------------------------------
      RETURN
      END


      SUBROUTINE CHECK_ANGLE(MDOC,RS_NAME,RS_NANGL,RS_LABEL
     *     ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3
     *     ,RS_VIDL,RS_SDI,RS_VOBS
     *     ,RMS_A,NA_GT_1S,NA_GT_3S,NA_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NANGL
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
      CHARACTER   CH3*1,ATOM3*4,ALT3*1,IRES3*4,RES3*8
C ----------------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
C --------
      ANG1 = RS_VIDL
      IF(ANG1.LE.-180.0) THEN
        ANG1 = ANG1+360.0
      ENDIF
      IF(ANG1.GT.180.0) THEN
        ANG1 = ANG1-360.0
      ENDIF

      ANG2 = RS_VOBS
      IF(ANG2.LE.-180.0) THEN
        ANG2 = ANG2+360.0
      ENDIF
      IF(ANG2.GT.180.0) THEN
        ANG2 = ANG2-360.0
      ENDIF

      DEL = ABS(ANG1-ANG2)
      IF(DEL.GT.180.0) DEL = 360.0-DEL
      SD = RS_SDI
      IF(SD.LE.0.0) SD=1.0
      TEST = DEL/SD
      IF(TEST.GT. 1.0) NA_GT_1S  = NA_GT_1S  + 1 
      IF(TEST.GT. 3.0) NA_GT_3S  = NA_GT_3S  + 1 
      IF(TEST.GT.10.0) NA_GT_10S = NA_GT_10S + 1
      RMS_A = RMS_A + DEL*DEL 
      IF(TEST.GT.SLIM) THEN
        IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
        IFLAG=1
        WRITE(LINE,100) RS_NAME,
     *  ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3
     *  ,RS_VIDL,RS_SDI,RS_VOBS
 100    FORMAT(A4,1X,
     *    A4,1X,A1,' - ',A4,1X,A1,' - ',A4,1X,A1
     *        ,1X,F8.3,1X,F8.3,1X,F8.3)
        CALL MSGDOC(MD,LINE)
      ENDIF
C --------------------------------------
      RETURN
      END

      SUBROUTINE CHECK_TORS(MDOC,RS_NAME,RS_NTORS,RS_LABEL
     *     ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_PRD
     *     ,RMS_T,NT_GT_1S,NT_GT_3S,NT_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NTORS,RS_PRD
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
      CHARACTER   CH3*1,ATOM3*4,ALT3*1,IRES3*4,RES3*8
      CHARACTER   CH4*1,ATOM4*4,ALT4*1,IRES4*4,RES4*8
C ----------------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
C --------
      IF(RS_LABEL(1:5).NE.'CONST') THEN
        IPRD = RS_PRD
        IF(IPRD.LE.0) IPRD=1
        PRD = 360.0/IPRD

        ANG1 = RS_VOBS-RS_VIDL

 10     CONTINUE
        IF(ANG1.LT.0.0) THEN
          ANG1 = ANG1+PRD
          GO TO 10
        ENDIF
 20     CONTINUE
        IF(ANG1.GE.PRD) THEN
          ANG1 = ANG1-PRD
          GO TO 20
        ENDIF

C        ANG2=RS_VOBS
C 30     CONTINUE
C        IF(ANG2.LT.0.0) THEN
C          ANG2=ANG2+PRD
C          GO TO 30
C        ENDIF
C 40     CONTINUE
C        IF(ANG2.GE.PRD) THEN
C          ANG2=ANG2-PRD
C          GO TO 40
C        ENDIF

        DEL  = ABS(ANG1)
        DEL2 = ABS(DEL-PRD)
        IF(DEL2.LT.DEL) DEL = DEL2

        SD = RS_SDI
        IF(SD.LE.0.0) SD = 1.0
        TEST = DEL/SD
        IF(TEST.GT. 1.0) NT_GT_1S  = NT_GT_1S  + 1 
        IF(TEST.GT. 3.0) NT_GT_3S  = NT_GT_3S  + 1 
        IF(TEST.GT.10.0) NT_GT_10S = NT_GT_10S + 1
        RMS_T = RMS_T + DEL*DEL 
      ELSE
        IF(SLIM.GT.0.0) THEN
          TEST = 0.0
        ELSE
          TEST = 2.0*ABS(SLIM)+1.0
        ENDIF
      ENDIF

      IF(TEST.GT.SLIM) THEN
        IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
        IFLAG = 1
        WRITE(LINE,100) RS_NAME,RS_LABEL,
     *  ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *  ,RS_VIDL,RS_SDI,RS_VOBS,RS_PRD
 100    FORMAT(A4,1X,A8,1X,
     *  A4,1X,A1,' - ',A4,1X,A1,' - ',A4,1X,A1,' - ',A4,1X,A1
     *        ,1X,F8.3,1X,F8.3,1X,F8.3,I3)
        CALL MSGDOC(MD,LINE)

      ENDIF
C --------------------------------------
      RETURN
      END

      SUBROUTINE CHECK_CHIR(MDOC,RS_NAME,RS_NCHIR,RS_LABEL
     *     ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *     ,RS_VIDL,RS_SDI,RS_VOBS
     *     ,RMS_C,NC_GT_1S,NC_GT_3S,NC_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NCHIR
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
      CHARACTER   CH3*1,ATOM3*4,ALT3*1,IRES3*4,RES3*8
      CHARACTER   CH4*1,ATOM4*4,ALT4*1,IRES4*4,RES4*8
C ----------------------------------------------------------------
      IERR= 0
      MD  = -ABS(MDOC)-1
C --------
      VOL1 = RS_VIDL
      VOL2 = RS_VOBS  
      IF(RS_LABEL(1:7).EQ.'negativ') THEN
        VOL1 = -VOL1
      ENDIF
      DEL = ABS(VOL1-VOL2)
      SD  = 0.5
      IF(SD.LE.0.0) SD = 1.0
      TEST = DEL/SD
      IF(TEST.GT. 1.0) NC_GT_1S  = NC_GT_1S  + 1 
      IF(TEST.GT. 3.0) NC_GT_3S  = NC_GT_3S  + 1 
      IF(TEST.GT.10.0) NC_GT_10S = NC_GT_10S + 1
      RMS_C = RMS_C + DEL*DEL 

      IF(TEST.GT.SLIM) THEN
        IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
        IFLAG=1

        WRITE(LINE,100) RS_NAME,RS_LABEL,
     *  ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *  ,RS_VIDL,RS_VOBS
 100    FORMAT(A4,1X,A8,
     *  A4,1X,A1,' : ',A4,1X,A1,',',A4,1X,A1,',',A4,1X,A1
     *          ,1X,F8.3,1X,F8.3)
        CALL MSGDOC(MD,LINE)

      ENDIF
C --------------------------------------
      RETURN
      END

      SUBROUTINE CHECK_PLAN(MDOC,RS_NAME,RS_NPLAN,RS_LABEL
     *     ,ATOM1,ALT1,RS_VIDL,RS_VOBS
     *     ,RMS_P,NP_GT_1S,NP_GT_3S,NP_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NPLAN
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
C ----------------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
C --------
      DEL = ABS(RS_VOBS)
      SD  = RS_VIDL
      IF(SD.LE.0.0) SD=0.02
      TEST=DEL/SD
      IF(TEST.GT. 1.0) NP_GT_1S  = NP_GT_1S  + 1 
      IF(TEST.GT. 3.0) NP_GT_3S  = NP_GT_3S  + 1 
      IF(TEST.GT.10.0) NP_GT_10S = NP_GT_10S + 1
      RMS_P = RMS_P + DEL*DEL 
      IF(TEST.GT.SLIM) THEN
        IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
        IFLAG=1

        WRITE(LINE,100) RS_NAME,RS_LABEL,
     *   ATOM1,ALT1,RS_VIDL,RS_VOBS
 100    FORMAT(A4,1X,A8,1X,
     *   A4,1X,A1,1X,F8.3,1X,F8.3)
        CALL MSGDOC(MD,LINE)

      ENDIF
C --------------------------------------
      RETURN
      END

      SUBROUTINE CHECK_VDW(MDOC,RSV_NAME,RSV_NVDW,RSV_SYMM
     *     ,ATOM1,ALT1,ATOM2,ALT2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSB_HFLAG,RSV_TYPE
     *     ,RMS_VDW,NVDW_GT_1S,NVDW_GT_3S,NVDW_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RSV_NVDW
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8
      CHARACTER   LINE*256,C_LINE*256,RSV_TYPE*1,RSV_HFLAG*1
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
C ----------------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
C --------
      DEL = ABS(RSV_RIDL-RSV_ROBS)
      IF(RSV_RIDL.LT.RSV_ROBS) DEL = 0.0
      SD  = 0.05
      IF(SD.LE.0.0) SD = 1.0
      TEST = DEL/SD
      IF(TEST.GT. 1.0) NVDW_GT_1S  = NVDW_GT_1S  + 1 
      IF(TEST.GT. 3.0) NVDW_GT_3S  = NVDW_GT_3S  + 1 
      IF(TEST.GT.10.0) NVDW_GT_10S = NVDW_GT_10S + 1
      RMS_VDW = RMS_VDW + DEL*DEL 
      IF(TEST.GT.SLIM) THEN
        IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
        IFLAG=1
        WRITE(LINE,100) RSV_NAME,RSV_SYMM
     *  ,ATOM1,ALT1,ATOM2,ALT2
     *  ,RSV_RIDL,RSV_ROBS,RSV_CNS

 100    FORMAT(A4,1X,A8,1X,
     *  A4,1X,A1,' - ',A4,1X,A1
     *      ,1X,F7.3,1X,F7.3,1X,F7.3)
        CALL MSGDOC(MD,LINE)
      ENDIF
C --------------------------------------
      RETURN
      END


      SUBROUTINE CHECK_HB(MDOC,RSV_NAME,RSV_NVDW,RSV_SYMM
     *     ,ATOM1,ALT1,ATOM2,ALT2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,RMS_HB,NHB_GT_1S,NHB_GT_3S,NHB_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RSV_NHB
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8
      CHARACTER   LINE*256,C_LINE*256,RSV_TYPE*1,RSV_HFLAG*1
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
C ----------------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
C --------
      DEL = ABS(RSV_RIDL-RSV_ROBS)
      IF(RSV_RIDL.LT.RSV_ROBS) DEL=0.0
      SD = 0.05
      IF(SD.LE.0.0) SD = 1.0
      TEST = DEL/SD
      IF(TEST.GT. 1.0) NHB_GT_1S  = NHB_GT_1S  + 1 
      IF(TEST.GT. 3.0) NHB_GT_3S  = NHB_GT_3S  + 1 
      IF(TEST.GT.10.0) NHB_GT_10S = NHB_GT_10S + 1
      RMS_HB = RMS_HB + DEL*DEL 
      IF(TEST.GT.SLIM) THEN
        IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
        IFLAG=1
        WRITE(LINE,100) RSV_NAME,RSV_SYMM
     *  ,ATOM1,ALT1,ATOM2,ALT2
     *  ,RSV_RIDL,RSV_ROBS,RSV_CNS

 100    FORMAT(A4,1X,A8,1X,
     *  A4,1X,A1,' - ',A4,1X,A1
     *      ,1X,F7.3,1X,F7.3,1X,F7.3)
        CALL MSGDOC(MD,LINE)
      ENDIF
C --------------------------------------
      RETURN
      END

