      subroutine read_hklf5(nobs,ncomp,iobs,
     &     nref_comp,hkl_comp,comp_numb,ierr,input_file)
c
c---This subroutine reads hklf 5 file of observations.
c
C---Organisation
C
      implicit none
      integer ierr
      integer nobs,ncomp
      real iobs(2,nobs)
      integer nref_comp(nobs)
      integer hkl_comp(3,ncomp)
      integer comp_numb(ncomp)
      character input_file*(*)

      character*4 text
      integer num,ii,in
      real hl,kl,ll,fol,sol,icomp
      integer in_file
C
      call open_form_file(in_file,input_file,ierr)
      read(in_file,'(a4,i2)')text,num
      if(text.ne.'HKLF'.or.num.ne.5 ) then
        write(*,*)'HKLIN is not hklf5 file.'
        ierr = 1
        return
      endif
            
      ii = 0
      nref_comp(1) = 0 
      in = 0
 100  read(in_file,'(3I4,2F8.2,I4)',err=102) hl,kl,ll,fol,sol,icomp
         
      in = in + 1
      hkl_comp(1,in) = hl
      hkl_comp(2,in) = kl 
      hkl_comp(3,in) = ll

      comp_numb(in) = abs(icomp)
      if(icomp.gt.0) then
        ii = ii  + 1
        if(ii.gt.nobs) then
           write(*,*)'Problem in reading hklf 5 file'
           ierr = 1
           return
        endif
        iobs(1,ii) = fol
        iobs(2,ii) = sol
        nref_comp(ii+1) = in
      endif
      if(hl.eq.0.and.kl.eq.0.and.ll.eq.0) goto 101
      goto 100
 101  continue

      return
 102  write(*,*)'Error in reading HKLF 5 file'
      ierr = 1
      return
      end

 
      subroutine read_hklf5_size(nobs,ncomp,n_twins,ierr,input_file)
c
c---This subroutine reads hklf 5 file of observations and find the size
C---of observations
c
      implicit none
      integer ierr
      integer nobs,ncomp,n_twins
      character input_file*(*)

      character*4 text
      integer num,icomp
      real hl,kl,ll,fol,sol      
c
      integer in_file
C
      call open_form_file(in_file,input_file,ierr)
      read(11,'(a4,i2)')text,num
      if(text.ne.'HKLF'.or.num.ne.5 ) then
        write(*,*)'Incorrect file.'
        ierr = 1
        return
      endif
            
      nobs = 1
      ncomp = 0
      n_twins = 1
 100  read(11,'(3I4,2F8.2,I4)',err=102) hl,kl,ll,fol,sol,icomp
      ncomp = ncomp + 1
      n_twins = max(n_twins,abs(icomp))
      if(icomp.gt.0) then
        nobs = nobs  + 1
      endif
      if(hl.eq.0.and.kl.eq.0.and.ll.eq.0) goto 101
      goto 100
 101  continue
      return
 102  write(*,*)'Error in reading HKLF 5 file'
      ierr = 1
      return
      end
