      subroutine read_sdfv3000_file(mdoc,iun,list,natommax,natom
     &     ,latom_charge
     &     ,latom_nhydr,latom_weight,xyz_sdf,latom_name,latom_symb
     &     ,latom_chiral
     &     ,nbondmax,nbond
     &     ,lbond1,lbond2,lbond_order,lbond_flag
     &     ,nchirmax,nchir,lchir_atom,lchir_sign
     &     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors,mon
     &     ,ierr)
      implicit none
c
c---  inputs
      integer mdoc,iun
      character mon*8,list*1
      integer   natommax,natom
      integer   ntorsmax
      integer nbondmax,nbond
      integer nchirmax,nchir
c
c---outputs
      integer   ierr
      integer   latom_nhydr(natommax)
      real      latom_charge(natommax)
      real      latom_weight(natommax)
      real      xyz_sdf(3,natommax)
      character latom_name(natommax)*4,latom_chiral(natommax)*6
      character latom_symb(natommax)*2
      integer   ntors,ltors_period(ntorsmax)
      integer   ltors_atom(4,ntorsmax)
      real      ltors(ntorsmax)
c
      integer   lbond1(nbondmax),lbond2(nbondmax)
      integer   lbond_flag(nbondmax)
      character lbond_order(nbondmax)*8
      integer   lchir_atom(9,nchirmax)
      character lchir_sign(nchirmax)*6
c
c---  locals
      integer l,is,is1,ia,ib,ib0,ie,ii,ia1,ia2,ibb
      integer iv3000,iv2000
      integer hydr_at,ster_at,ster_bond,valence_at,charge_at
      character err_message*80
      character element_name*2
c
      integer maxitems,nitems
      parameter (maxitems = 200)
      integer ibeg(maxitems),iend(maxitems)
      character line_in*256,key*16,key1*16
      character bond_order*4
      character index_at(500)*4
c
c---  body
      rewind(iun)
      ierr = 0
      read(iun,'(a)',end=999,err=999)line_in
      read(iun,'(a)',end=999,err=999)line_in
c
c---Take mon name
      read(iun,'(a)',end=999,err=999)line_in
      call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
      mon = line_in(ibeg(1):iend(1))
      read(iun,'(a)',end=999,err=999)line_in
c
c---Start reading
 10   continue
      call read_sdfv3000_line(mdoc,iun,line_in,ierr)
      if(ierr.gt.0) goto 999
      call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
      if(ierr.gt.0) goto 999
      key = line_in(ibeg(1):iend(1)) 
      call check_line(1,key)
      if(key.eq.'BEGIN') then
         key1 = line_in(ibeg(2):iend(2))
         call check_line(1,key1)
         if(key1.eq.'CTAB') goto 15
      endif
      goto 10
 15   continue
c
c---next line must be 'COUNTS' line
      call read_sdfv3000_line(mdoc,iun,line_in,ierr)
      if(ierr.gt.0) goto 999
      call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
      if(ierr.gt.0) goto 999
      key = line_in(ibeg(1):iend(1))
      call check_line(1,key)
      if(key(1:6).eq.'COUNTS') then
         read(line_in(ibeg(2):iend(2)),*)natom
         read(line_in(ibeg(3):iend(3)),*)nbond
         goto 20
      endif
      goto 15
      err_message = 'COUNT line could not be found'
      goto 999
 20   continue
      call read_sdfv3000_line(mdoc,iun,line_in,ierr)
      if(ierr.gt.0) goto 999
      call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
      if(ierr.gt.0) goto 999
      if(nitems.lt.2) goto 20
      key = line_in(ibeg(1):iend(1))
      key1 = line_in(ibeg(2):iend(2))
      call check_line(1,key)
      call check_line(1,key1)
      if(key(1:4).eq.'BEGIN'.and.key1.eq.'ATOM') then
         do  ia=1,natom
            latom_chiral(ia) = ' '
            call read_sdfv3000_line(mdoc,iun,line_in,ierr)
            if(ierr.gt.0) goto 999
            call parse_items(mdoc,maxitems,nitems,line_in,
     &           ibeg,iend,ierr)
            if(ierr.gt.0) goto 999
            if(nitems.lt.5) then
               ierr = 1
               err_message = 'Wrong atoms line in sdfv3000 file'
               goto 999
            endif
            index_at(ia) = line_in(ibeg(1):iend(1))
            latom_symb(ia) = line_in(ibeg(2):iend(2))
            latom_name(ia) = latom_symb(ia)
            read(line_in(ibeg(3):iend(3)),*) xyz_sdf(1,ia)
            read(line_in(ibeg(4):iend(4)),*) xyz_sdf(2,ia)
            read(line_in(ibeg(5):iend(5)),*) xyz_sdf(3,ia)
            do ii=1,nitems
               key=line_in(ibeg(ii):iend(ii))
               call check_line(1,key)
               if(key(1:3).eq.'CHG') then
                  ie = index(key,'=')
                  if(ie.le.0) then
                     err_message='Wrong keyword for charge'
                     ierr = 1
                     goto 999
                  endif
                  call lenstr_bl(key,l)
                  if(ie.ge.l) then
                     err_message='Wrong keyword for charge'
                     ierr = 1
                     goto 999
                  endif
                  read(key(ie+1:l),*)latom_charge(ia)
               elseif(key(1:4).eq.'MASS') then
                  ie = index(key,'=')
                  if(ie.le.0) then
                     err_message = 'Wrong keyword for MASS'
                     ierr = 1
                     goto 999
                  endif
                  call lenstr_bl(key,l)
                  if(ie.ge.l) then
                     err_message='Wrong keyword for charge'
                     ierr = 1
                     goto 999
                  endif
                  read(key(ie+1:l),*)latom_weight(ia)
                  
               endif
            enddo
         enddo
         goto 30
      endif
      goto 20
 31   continue
      ierr = 1
      err_message = 'ATOM record coul not be found'
      goto 999
 30   continue
      call read_sdfv3000_line(mdoc,iun,line_in,ierr)
      if(ierr.gt.0) goto 999
      call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
      if(ierr.gt.0) goto 999
      if(nitems.lt.2) goto 30
      key = line_in(ibeg(1):iend(1))
      key1 = line_in(ibeg(2):iend(2))
      call check_line(1,key)
      call check_line(1,key1)

      if(key(1:4).eq.'BEGIN'.and.key1.eq.'BOND') then
         ib = 0
         do  ib0=1,nbond
            do ia=1,natom
               if(index_at(ia).eq.line_in(ibeg(2):iend(2))) then
                  ia1 = ia
                  goto 35
               endif
            enddo
            goto 39
 35         continue
            do ia=1,natom
               if(index_at(ia).eq.line_in(ibeg(3):iend(3))) then
                  ia2 = ia
                  goto 36
               endif
            enddo
            goto 39
 36         continue
            ib = ib + 1
            lbond1(ib) = ia1
            lbond2(ib) = ia2
            read(line_in(ibeg(4):iend(4)),*)ibb
            if(ibb.eq.1 ) then
               lbond_order(ib) = 'single'
            elseif(ibb.eq.2) then
               lbond_order(ib) = 'double'
            elseif(ibb.eq.3) then
               lbond_order(ib) = 'triple'
            elseif(ibb.eq.4) then
               lbond_order(ib) = 'deloc'
            elseif(ibb.eq.5) then
               lbond_order(ib) = 'arom'
            elseif(ibb.eq.6) then

            else
               lbond_order(ib) = '.'
            endif
 39         continue
         enddo
         goto 40
      endif
      goto 30
 41   continue
      ierr = 1
      err_message = 'ATOM record coul not be found'
      goto 999
 40   continue


 999  continue
c
c---  Error return
      if(ierr.gt.0) then
         call msgerr(mdoc,err_message)
         ierr = 1
         return
      endif
      end
c
      subroutine read_sdfv3000_line(mdoc,iun,line_out,ierr)
      implicit none
c
c---read sdf v3000 line. Take care the fact that symbol - is line continuation
c
c---  inputs
      integer mdoc,iun
c
c---outputs
      integer ierr
      character line_out*(*)
c
c---locals
      integer l,l1
      character line_loc*256
      character err_message*80
c
      line_out = ' '
 10   continue
      read(iun,'(a)',err=20,end=30) line_loc
      if(line_loc(1:1).ne.'#') then
         if(line_loc(1:4).eq.'M V3') then
            line_loc(1:4) = '    '
         else
            err_message = 'Wrong line beginning in sdf v3000'
            ierr = 1
            goto 999
         endif
         call lenstr(line_out,l)
         if(l.le.0) then
            line_out = line_loc
         else
            call lenstr_bl(line_loc,l1)
            line_out = line_out(1:l)//line_loc(1:l1)
         endif
      endif
      call lenstr(line_out,l)
      if(line_out(l:l).eq.'-') then
         line_out(l:l) = ' '
         goto 10
      endif
      return
 20   continue
      call msgerr(mdoc,'Problem in reading mol2 line')
      ierr = 1
      return
 30   continue
      call msgerr(mdoc,'Premature end of mol2 line')
      ierr = 1
 999  continue
      if(ierr.gt.0) then
         call lenstr_bl(err_message,l)
         if(l.gt.0) then
            call msgerr(mdoc,err_message)
         else
            call msgerr(mdoc,'Problem in read_sdfv300')
         endif
         ierr=1
      endif
      return
      end
c
      subroutine read_sdfv2000_file( mdoc,iun,list,natommax,natom
     &     ,latom_charge
     &     ,latom_nhydr,latom_weight,xyz_sdf,latom_name,latom_symb
     &     ,latom_chiral
     &     ,nbondmax,nbond
     &     ,lbond1,lbond2,lbond_order,lbond_flag
     &     ,nchirmax,nchir,lchir_atom,lchir_sign
     &     ,ntorsmax,ntors,ltors_atom,ltors_period,ltors,mon
     &     ,ierr)
      implicit none
c
c---Read sdf v2000 file
c
c---  inputs
      integer mdoc,iun
      character mon*8,list*1
      integer   natommax,natom
      integer   ntorsmax
      integer nbondmax,nbond
      integer nchirmax,nchir
c
c---outputs
      integer ierr
      integer   latom_nhydr(natommax)
      real      latom_charge(natommax)
      real      latom_weight(natommax)
      real      xyz_sdf(3,natommax)
      character latom_name(natommax)*4,latom_chiral(natommax)*6
      character latom_symb(natommax)*2
      integer   ntors,ltors_period(ntorsmax)
      integer   ltors_atom(4,ntorsmax)
      real      ltors(ntorsmax)

      integer   lbond1(nbondmax),lbond2(nbondmax)
      integer lbond_flag(nbondmax)
      character lbond_order(nbondmax)*8
      integer lchir_atom(9,nchirmax)
      character lchir_sign(nchirmax)*6
c
c---  locals
      logical ch_flag
      integer bond_order
      integer i,l,is,is1,ia,ia1,ib,l1,ic,ncharge,icharge
      integer iv3000,iv2000
      integer hydr_at,ster_at,ster_bond,valence_at,charge_at
      integer mass_diff
      character err_message*80
      character line_in*256
      character element_name*2
      character key*4,key1*4
      integer maxitems,nitems
      parameter (maxitems=200)
      integer ibeg(maxitems),iend(maxitems)
c
c---  Initialise
      rewind(iun)
      err_message   = ' '
      natom         = 0
      nbond         = 0
      ntors         = 0
      nchir         = 0
c     
c---  Read the first three lines: header
      read(iun,'(a)')line_in
      call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
      if(ierr.gt.0) goto 999
      if(nitems.gt.0) then
         mon = line_in(ibeg(1):iend(1))
      endif
      call lenstr_bl(mon,l)
      if(l.le.0.or.mon.eq.','.or.mon.eq.'.') then
         mon ='sdf'
      endif
      read(iun,'(a)')line_in
      read(iun,'(a)')line_in
      read(iun,'(a)')line_in
c
c--read coordinates and other info file
      read(line_in,*)natom,nbond
      if(list.eq.'T') then
         write(*,*)'sdf3dmol: Number of atoms,bonds',natom,nbond
      endif
      do  ia=1,natom
         latom_chiral(ia) = ' '
         line_in = ' '
         read(iun,'(a)',end=100)line_in
         if(list.eq.'T') then
            write(*,*)'sdf3dmol: ',line_in
         endif
         
         call parse_items(mdoc,maxitems,nitems,line_in,ibeg,iend,ierr)
         if(ierr.gt.0) goto 999
         read(line_in(ibeg(1):iend(1)),*)xyz_sdf(1,ia)
         read(line_in(ibeg(2):iend(2)),*)xyz_sdf(2,ia)
         read(line_in(ibeg(3):iend(3)),*)xyz_sdf(3,ia)
         element_name = line_in(ibeg(4):iend(4))
         mass_diff = 0
         charge_at = 0
         ster_at   = 0
         hydr_at   = 0
         ster_bond = 0
         valence_at= 0

         if(nitems.ge.5) read(line_in(ibeg(5):iend(5)),*)mass_diff
         if(nitems.ge.6) read(line_in(ibeg(6):iend(6)),*)charge_at
         if(nitems.ge.7) then
            read(line_in(ibeg(7):iend(7)),*)ster_at
            if(ster_at.ne.0) latom_chiral(ia) = ' '
         endif
         if(nitems.ge.8) read(line_in(ibeg(8):iend(8)),*)hydr_at
         if(nitems.ge.9) read(line_in(ibeg(9):iend(9)),*)ster_bond
         if(nitems.ge.10) read(line_in(ibeg(10):iend(10)),*)valence_at
         latom_charge(ia) = 0
         if(charge_at.ne.0.and.charge_at.ne.4) then
            latom_charge(ia) = 4-charge_at
         endif
         call check_line(1,element_name)
         latom_symb(ia) = element_name
         latom_name(ia) = element_name//' '
         if(charge_at.eq.4) then
c     
c--   doublet radical? later
            latom_charge(ia) = 0
         endif
c
c         hydr_at(ia) = hydr_at(ia)-1
c
c---hydrogens later
         if(hydr_at.gt.0) then
            err_message = 'Treatment of implicit hydrogens is not ready'
            ierr = 1
            goto 999
         endif
      enddo
      write(*,*)'Atoms read'
      goto 110
 100  continue
      err_message = 'Premature end of sdf file'
      ierr = 1
      goto 999
 110  continue
c     
c---  read bonds
      write(*,*)'Reading bond files'
      do  ib=1,nbond
         read(iun,'(a)',err=999,end=999)line_in
         call parse_items(mdoc,maxitems,nitems,line_in,
     &        ibeg,iend,ierr)
         if(ierr.gt.0) goto 999
         if(nitems.lt.3) then
            ierr = 1
            err_message = 'Wrong line for bonds'
            goto 999
         endif
         read(line_in(ibeg(1):iend(1)),*)lbond1(ib)
         read(line_in(ibeg(2):iend(2)),*)lbond2(ib)
         read(line_in(ibeg(3):iend(3)),*)bond_order
         ster_bond = 0
         if(nitems.ge.4) read(line_in(ibeg(4):iend(4)),*)ster_bond
         if(bond_order.eq.1) then
            lbond_order(ib) = 'single'
         elseif(bond_order.eq.2) then
            lbond_order(ib) = 'double'
         elseif(bond_order.eq.3) then
            lbond_order(ib) = 'triple'
         elseif(bond_order.eq.4) then
            lbond_order(ib) = 'aromatic'
         elseif(bond_order.ge.4.and.bond_order.le.7) then
            lbond_order(ib) = 'deloc'
         elseif(bond_order.eq.8) then
            lbond_order(ib) = '.'
         else
            ierr = 1
            return
         endif
      enddo
      goto 205
 200  continue
      err_message = 'Premature end of sdf file'
      ierr = 1
      close(iun)
      goto 999
 205  continue
      ch_flag=.FALSE.
 210  continue
c
c--Read charges
      read(iun,'(a)',err=999,end=300)line_in
      call lenstr_bl(line_in,l)
      if(l.le.0) goto 210
      if(line_in(1:1).eq.'M') then
         if(line_in(4:6).eq.'END') goto 300
         if(line_in(4:6).eq.'CHG') then
            if(.not.ch_flag) then
               write(*,*)'Here '
               ch_flag=.TRUE.
               do  ia=1,natom
                  latom_charge(ia) = 0
               enddo
            endif
            ncharge = 1
            if(line_in(7:9).ne.'   ') then
               read(line_in(7:9),*)ncharge
            endif
            l1 = 10
            do ic=1,ncharge
               read(line_in(l1:l1+3),'(i4)')ia1
               if(line_in(l1+4:l1+7).eq.'   ') then
                  latom_charge(ia1) = 0
               else
                  read(line_in(l1+4:l1+7),'(i4)')icharge
                  latom_charge(ia1) = icharge
               endif
               write(*,*)ia1,latom_charge(ia1)
               l1 = l1 + 8
            enddo
c
c--radical?
         endif
      endif
      goto 210
 300  continue
      close(iun)
      return
 999  continue
      if(ierr.gt.0) then
         call lenstr_bl(err_message,l)
         if(l.gt.0) then
            call msgerr(mdoc,err_message)
         else
            call msgerr(mdoc,'Problem in reading sdf v2000 file')
         endif
      endif
      close(iun)
      return
      end
c
