c
      subroutine xml_version(iout)
      implicit none
c
      integer iout
c
c---  body     
      write(iout,'(a)')
     &     '<?xml version="1.0" encoding="ASCII" standalone="yes"?>'
      return
      end
c
      subroutine xml_comment(iout,text)
      implicit none
c
      integer iout
      character text*(*)
c
c---  body
      write(iout,'(3a)')'<!-- ',trim(text),' -->'
      return
      end
c
      subroutine xml_oneliner(iout,xinfo,xtag,xval,xattr,xattr_val)
      implicit none
c
      integer iout
      character xinfo*(*),xtag*(*),xval*(*),xattr*(*),xattr_val*(*)
c
      character line*512
c
      line = trim(xinfo)//' <'//trim(xtag)
     
      if(len_trim(xattr).ne.0) then
         line = trim(line)//' '//trim(xattr)//'='//trim(xattr_val)
      endif
      if(len_trim(xval).ne.0) then
         line = trim(line)//'> '//trim(xval)//' </'//trim(xtag)//'>'
      else
         line = trim(line)//'/>'
      endif
      line = trim(line)//' <br/>'
      write(iout,'(a)')trim(line)
c
      return
      end
c
      subroutine xml_additem(iout,line_xml,xinfo,xtag,xval,xattr,
     &     xattr_val)
      implicit none
c
      integer iout
      character xinfo*(*),xtag*(*),xval*(*),xattr*(*),xattr_val*(*)
      character line_xml*(*)
c
c---  Sizes needs to be checked also.
      if(len_trim(xattr).ne.0) then
         if(len_trim(trim(line_xml)//' '//trim(xinfo)//
     &        ' <'//trim(xtag)//' '//
     &        trim(xattr)//'='//trim(xattr_val)//'> '//
     &        trim(xval)//' </'//trim(xtag)//'>').gt.len(line_xml)) then
            write(iout,'(a)')trim(line_xml)
            line_xml = ' '
         endif
         line_xml = trim(line_xml)//' '//trim(xinfo)//
     &        ' <'//trim(xtag)//' '//
     &        trim(xattr)//'='//trim(xattr_val)//'> '//
     &        trim(xval)//' </'//trim(xtag)//'>'
      else
         if(len_trim(trim(line_xml)//' '//trim(xinfo)//
     &        ' <'//trim(xtag)//'> '//
     &        trim(xval)//' </'//trim(xtag)//'>').gt.len(line_xml)) then
            write(iout,'(a)')trim(line_xml)
            line_xml = ' '
         endif
         line_xml = trim(line_xml)//' '//trim(xinfo)//
     &        ' <'//trim(xtag)//'> '//
     &        trim(xval)//' </'//trim(xtag)//'>'
      endif
      return
      end
c
      subroutine xml_dump(iout,line_xml)
      implicit none

      integer iout
      character line_xml*(*)
c
c---  body
      write(iout,'(2a)')trim(line_xml),' <br />'
      line_xml = ' '
      return
      end
c
      subroutine xml_opentag(iout,xinfo,xtag,xattr,xattr_val)
      implicit none
c
      integer iout
      character xinfo*(*),xtag*(*),xattr*(*),xattr_val*(*)
c
      if(len_trim(xattr).ne.0) then
         write(iout,'(2a)')trim(xinfo),' <'//trim(xtag)//' '//
     &        trim(xattr)//'='//trim(xattr_val)//'>'
      else
         write(iout,'(2a)')trim(xinfo),' <'//trim(xtag)//'>'
      endif
      return
      end
c
      subroutine xml_closetag(iout,xtag)
      implicit none
c
      integer iout
      character xtag*(*)
c
      write(iout,'(a)')'</'//trim(xtag)//'>'
      return
      end
