      subroutine idealise_ligand
      
      real dmin

      conv_flag = .FALSE.
      icycle = 0
      do while(icycle.le.ncycle_max.or..not.conv_flag)
         icycle = icycle + 1
         dmin =0.0
         call analyse_vdw(dmin)
         call find_restr_number(ndist)

         nvar = 3*n_atom
         nmat = 6*n_atom + 9*ndist

         allocate(grad(nvar))
         allocate(amat(nmat))
         allocate(shift(nvar))

         call calc_dist_contr
         call calc_angl_contr
         call calc_chir_contr
         call calc_plane_contr
         call calc_vdw_contr

         call cgsolve_block

         call apply_shift_ideal

         deallocate(grad)
         deallocate(amat)
         deallocate(shift)

      enddo
      return
      end
c
      subroutine calc_dist_contr(n_atom,xyz_in,nr_bond,iat_ref,rs_vidl)

      nbond = 0
      do i=1b,nr_bond

         ia(1:2) = iatref(1:2,ib)
         diff = xyz_in(1:3,ia(1))-xyz_in(1:3,ia(2))
         dist = sqrt(sum(diff**2))
         dist_diff = dist-rs_vidl(1,ib)
         diff1 = diff/max(dist,small_bond)
         wl = 1.0/rs_vidl(2,ib)
         iv(1:2) = (ia(1:2)-1)*3+1
         grad(iv(1):iv(1)+2) = grad(iv(1):iv(1)+2) + wl*dist_diff*dddx1(1:3)
         grad(iv(2):iv(2)+2) = grad(iv(1):iv(1)+2) + wl*dist_diff*dddx2(1:3)
         
         im(1:2) = (ia(1:2)-1)*6+1
         do i=1,5
            do j=i+1,6
               amat(im(1):im(1)+5) = amat(im(1):im(1)+5) + wl*dddx1(i)*dddx1(j)
               amat(im(2):im(2)+5) = amat(im(2):im(2)+5) + wl*dddx2(i)*dddx2(j)
            enddo
         enddo
         call find_ref_to_dist(ia1,ia2,idist)
         im = 6*n_atom+9*(idist-1)+1
         do i=1,6
            do j=1,6
               amat(im) = amat(m)+wl*dddx1(i)*dddx2(j)
               im = im + 1
            enddo
         enddo
         nbond = nbond + 1
         zbond = zbond + dist_diff/rs_vidl(2,ib)
      enddo
      zbond = zbond/nbond
      
      return
      end

      subroutine calc_angl_contr

      return
      end

      subroutine calc_chir_contr

      return
      end

      subroutine calc_plane_contr

      return
      end

      subroutine calc_vdw_contr

      return
      end

      subroutine calc_tors_contr

      return
      end

      
