
      SUBROUTINE SET_DEFAULT(LINE)
C ---------------------------------------------------------------
C     SET_DEFAULT - write info about the defaults, get the defaults 
C                   and go to batch mode.  
C ---------------------------------------------------------------
      CHARACTER LINE*(*)
C ---------------------------------------------------------------
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ----------------------------------------------------------------
      PARAMETER ( KEY_MAX = 40 )
C ---
      COMMON/COMASK/ IEND,NKEY,FLAG,STOR,STOR_KEY 
      INTEGER*4 FLAG(KEY_MAX),IEND,NKEY
      CHARACTER STOR(KEY_MAX)*256,STOR_KEY(KEY_MAX)*11
C ---
      COMMON/COMASK2/ NKEY_TEST,KEY_TEST
      INTEGER*4 NKEY_TEST
      CHARACTER KEY_TEST(KEY_MAX)*11
C ---------------------------------------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMFREAD_KEYWORDS/ 
     *                  FWORDS,IFRD_ERR,NWORDS,LEN_WORDS,IWORDS
     *                 ,WORDS,IN_STRING
      REAL      FWORDS   (NWORDSMAX)
      INTEGER*4 LEN_WORDS(NWORDSMAX)
      INTEGER*4 IWORDS   (NWORDSMAX)
      INTEGER*4 NWORDS,IFRD_ERR
      CHARACTER WORDS(NWORDSMAX)*256
      CHARACTER IN_STRING*256
C --------------------------------------------------------------
C ---
      INTEGER*4 NL,NLK
      CHARACTER STR*256,KEY*80,K_TEST*11,CHAR1*1,IN_STRING2*256
      CHARACTER STR1*256,S_END*256
C ---------------------------------------------------------
      IF(IBATCH.NE.0) THEN
C       It is not interactive mode 
        RETURN
      ENDIF

      CALL LENSTR_BL(LINE,NL)
      IF(NL.GT.255) NL=255
      IF(NL.LE.0) THEN
        STR(1:1) = ' '
        NL       = 1
      ELSE
        STR = LINE(1:NL)
      ENDIF

      IWD = 0
      IWB = 0

      IF(STR(1:1).EQ.'?') THEN
C       first call of dialogue
        IF(NL.GT.2) THEN
          S_END  = STR(3:NL)
          NL_END = NL-2
        ELSE
          S_END  = ' '
          NL_END = 0
        ENDIF
        NKEY = 0
        DO I=1,KEY_MAX
          FLAG(I)=0
        ENDDO

        M=0
        CALL MSGDOC(M,'#---  type "key_word   parameters" and/or ---')
        CALL MSGDOC(M,'#---  type "CR" for to run program        ---')

 200    CONTINUE
C       start loop of dialogue

        IF(BAT_MODE.EQ.0) CALL DISPL_BL('-->')

C       read input line
        READ(*,'(A)') IN_STRING
        CALL LENSTR_BL(IN_STRING,L)
        IF(L.GT.0) THEN
          IFIRST     = 0
          II         = 0
          IN_STRING2 = ' '
          DO I=1,L
            IF(IFIRST.EQ.0.AND.IN_STRING(I:I).EQ.' ') THEN
            ELSE
              IFIRST = 1
              II     = II+1
              IN_STRING2(II:II) = IN_STRING(I:I)
            ENDIF
          ENDDO
          IN_STRING = IN_STRING2
          CALL LENSTR_BL(IN_STRING,L)
          IF(L.GT.0.AND.IN_STRING(1:1).EQ.'#') GO TO 200
C         comments or empty line
        ENDIF
        IF(L.LE.0.OR.IN_STRING(1:1).EQ.' '.OR.
     *  IN_STRING(1:4).EQ.'_END'.OR.IN_STRING(1:4).EQ.'_end') 
     *  GO TO 100
C       finish of dialogue
C ----
        CALL FRD_PARM_KEYWORDS
C ----
        IF(NWORDS.LE.0) GO TO 200

C       get key_word:  'word  <...> ' or '_word <...> '    
        KEY = WORDS(1)
        NLK = LEN_WORDS(1)
        IF(NLK.GE.1) THEN
          IF(KEY(1:1).NE.'_') THEN
C           first symbol must be '_' if not add it
            KEY = '_'//KEY(1:NLK)
            NLK = NLK + 1
          ELSE
            KEY = KEY(1:NLK)
          ENDIF
        ELSE
          KEY = ' '
          NLK = 1
        ENDIF
        
        IF(NLK.GT.12) NLK=12
        IF(NLK.LE.1) GO TO 200 
C       check keyword KEY and convert to uppercase
        CALL CHECK_LINE(1,KEY(1:NLK))

C       create string of parameters STR without keyword 
        DO I=1,L
          J = I+LEN_WORDS(1)-1
          IF(IN_STRING(I:J).EQ.WORDS(1)(1:LEN_WORDS(1))) THEN
            JJ = J+1
            IF(JJ.EQ.L) GO TO 200 
            STR = IN_STRING(JJ:L)
            NL  = L-J
            GO TO 300
          ENDIF
        ENDDO
        GO TO 200

 300    CONTINUE
C       remove last symbol ':' from keywords 
        IF(KEY(NLK:NLK).EQ.':') THEN
          KEY(NLK:NLK) = ' '
          NLK          = NLK-1
        ENDIF

C       creat correct string STR : 'keyword <parameters>'
        STR=KEY(1:NLK)//' '//STR(1:NL) 
        CALL LENSTR_BL(STR,NL)
        IF(NL.GT.256) NL=256
        IF(NLK.GT.1) THEN
          IF(NKEY_TEST.GT.0) THEN
C           check with possible keywords / KEY_TEST(NKEY_TEST) /               
            IMODE  = 1
            K_TEST = KEY(2:NLK)
            NLKK   = NLK-1
            CALL CHECK_LINE(IMODE,K_TEST)
            DO I=1,NKEY_TEST
              CALL LENSTR_BL(KEY_TEST(I),LEN)
              IF(LEN.EQ.NLKK) THEN
                IF(KEY_TEST(I)(1:LEN).EQ.K_TEST(1:LEN)) GO TO 310
              ENDIF
            ENDDO

            L = LEN
            IF(L.GT.11) L = 11
            STR1 = ' WARNING: no such keyword :'//K_TEST(1:L)
            IF(L.GT.0) THEN
              CALL MSGERR(M,STR1)
            ELSE
              CALL MSGERR(M,' WARNING: no such keyword')
            ENDIF

            GO TO 200

 310        CONTINUE          
          ENDIF
        ENDIF

        IF(BAT_MODE.EQ.1) THEN
          MM = 1
          IF(NL.GT.0) CALL MSGDOC(MM,STR(1:NL))
        ENDIF


        IF(NKEY.GT.0) THEN
C         check with previous keywords 
C         if there is such keywords replace stored string STOR
          DO I=1,NKEY
            CALL LENSTR_BL(STOR_KEY(I),NLSK)
            IF(NLSK.EQ.NLK.AND.KEY(1:NLK).EQ.STOR_KEY(I)(1:NLK))THEN
              STOR(I)     = STR(1:NL)
              STOR_KEY(I) = KEY(1:NLK)
              GO TO 200
            ENDIF 
          ENDDO
        ENDIF
        IF(NKEY.LT.KEY_MAX) THEN
C         store new keyword in STOR_KEY and string STR in STOR
          NKEY           = NKEY+1
          FLAG(NKEY)     = 1
          STOR(NKEY)     = STR(1:NL)
          STOR_KEY(NKEY) = KEY(1:NLK)
        ENDIF

        GO TO 200

C       end loop of dialogue
C ----------------------------------
 100    CONTINUE
C       finish of dialogue
        
        IF(BATCH_FILE.GT.0.AND.NKEY.GT.0) THEN
C         write to batch file
          DO I=1,NKEY
            STR=STOR(I)
            CALL LENSTR_BL(STR,NL)
            IF(NL.LE.0) THEN
              NL=1
              STR=' '
            ELSE
              IF(NL.GT.256) NL=256
            ENDIF
            WRITE(BATCH_FILE,'(A)',ERR=10) STR(1:NL)
          ENDDO
        ENDIF

        IBATCH = 1
        IEND   = 1
        IWB    = 1
        IWD    = 0

        IF(NL_END.EQ.0) THEN
          STR   = '_END'
          NL    = 4
        ELSE
          STR = '_END'//S_END(1:NL_END)
          NL  = NL_END + 4
        ENDIF

      ELSE
C
C       it is possible keyword if string is : 'keyword: <....>'
C         or comment string
C   
        IF(STR(1:1).NE.' ') THEN
          N  = NL
          NK = 0
          IF(NL.GT.12) N = 12
          DO I=1,N
            IF(STR(I:I).EQ.':') THEN
              IF(NK.GT.0.AND.NKEY_TEST.LT.KEY_MAX) THEN
                NKEY_TEST           = NKEY_TEST + 1
                KEY_TEST(NKEY_TEST) = STR(1:NK)
              ENDIF
              GO TO 320 
            ENDIF
            NK = NK + 1
          ENDDO
        ENDIF
 320    CONTINUE       
        STR    = '#'//STR(1:NL)
        NL     = NL+1
        IWB    = 1
        IWD    = 1
      ENDIF


      IF(BATCH_FILE.GT.0.AND.IWB.GT.0) THEN
C       write to batch file
        CALL LENSTR_BL(STR,NL)
        IF(NL.LE.0) THEN
          NL  = 1
          STR = '#'
        ELSE
          IF(NL.GT.256) NL = 256
        ENDIF
        WRITE(BATCH_FILE,'(A)',ERR=10) STR(1:NL)
      ENDIF

      IF(IWD.GT.0) THEN
        M = 0
        CALL LENSTR_BL(STR,NL)
        IF(NL.LE.0) THEN
          NL  = 1
          STR = ' '
        ELSE
          IF(NL.GT.256) NL = 256
        ENDIF
        CALL MSGDOC(M,STR(1:NL))
      ENDIF
C ---
      RETURN
 10   M = 0
      CALL MSGERR(M,' ERROR: writing to batch file')
      CALL FINISH
      END
C ******
      SUBROUTINE FRD_PARM_KEYWORDS
C -------------------------------------------------------
C -P- FRD_PARM - free format reading of the string of characters.
C                See common /COMFREAD/
C
C     input:     IN_STRING - input string; a word is the part of the string
C                            between two blancs or two "'".
C     output:    NWORDS    - number of words of the string
C                IWORDS    - array of integer value of each word.
C                FWORDS    - array of real value of each word.
C                WORDS     - array of words
C                LEN_WORDS - array of lengths of the words
C                IFRD_ERR  - signal of error. 
C                            0  means OK.
C                            1 - number of words > NWORDSMAX = 40
C -----------------------------------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMFREAD_KEYWORDS/ 
     *                  FWORDS,IFRD_ERR,NWORDS,LEN_WORDS,IWORDS
     *                 ,WORDS,IN_STRING
      REAL      FWORDS   (NWORDSMAX)
      INTEGER*4 LEN_WORDS(NWORDSMAX)
      INTEGER*4 IWORDS   (NWORDSMAX)
      INTEGER*4 NWORDS,IFRD_ERR
      CHARACTER WORDS(NWORDSMAX)*256
      CHARACTER IN_STRING*256
C --------------------------------------------------------------
C ******
      REAL      FA
      INTEGER*4 NW,IS,IW,IAP,LEN,IP,IA
      CHARACTER CH*1,CK*1,STR*256
C --------------------------------------------------------------
      IFRD_ERR=0
      NWORDS  =0
      NW      =0
      IW      =0
      IS      =0
      IAP     =0
      CALL LENSTR_BL(IN_STRING,LEN)
      IF(LEN.LE.0) RETURN
      IF(LEN.GT.256) LEN=256
C -----------------
      DO   IP=1,LEN
        CH=IN_STRING(IP:IP)
        CALL CHKSMB(CH,CK)
        IF(CK.EQ.'?') CH=' '
        IF(CH.EQ.'''') THEN
          IAP=IAP+1
          IF(IAP.GE.2) IAP=0
        ENDIF
        IF(CH.NE.' '.OR.IAP.EQ.1) THEN
C         start of a word
          IF(IS.EQ.0) THEN
            IS=1
            NW=NW+1
            IF(NW.GT.20) THEN
              IFRD_ERR=1
              RETURN
            ENDIF
          ENDIF
          IF(CH.NE.'''') THEN
            IW=IW+1
            STR(IW:IW)=CH       
          ELSE
            IF(IW.GT.0) THEN
            ENDIF
          ENDIF
        ENDIF
        IF((CH.EQ.' '.AND.IS.EQ.1.AND.IAP.EQ.0).OR.
     *       (IP.EQ.LEN.AND.IW.NE.0)) THEN
          IF(IW.LE.0) THEN
            WORDS(NW)='?'
            LEN_WORDS(NW)=1
          ELSE
            WORDS(NW)=STR(1:IW)
            LEN_WORDS(NW)=IW
          ENDIF
          NWORDS=NW
          CALL WTODIG(STR,IW,FA,IA)
          IWORDS(NW)=IA
          FWORDS(NW)=FA
          IS=0
          IW=0
          IAP=0
        ENDIF
      ENDDO
C -----------------
      RETURN
      END      

      SUBROUTINE ASK(LINE)
C --------------------------------------------------------------
C     ASK - read keyword (from input LINE) and get the default (output LINE).
C --------------------------------------------------------------
      CHARACTER LINE*(*)
C ---
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ------------------------------------------------------
      PARAMETER ( KEY_MAX = 40 )
C ------------------------------------------------------
      COMMON/COMASK/ IEND,NKEY,FLAG,STOR,STOR_KEY 
      INTEGER*4 FLAG(KEY_MAX),IEND,NKEY
      CHARACTER STOR(KEY_MAX)*256,STOR_KEY(KEY_MAX)*11
C --
      COMMON/COMASK2/ NKEY_TEST,KEY_TEST
      INTEGER*4 NKEY_TEST
      CHARACTER KEY_TEST(KEY_MAX)*11
C ---------------------------------------------------------
      INTEGER*4 NL,NLA,NLK
      CHARACTER STR*256,KEYR*12,KEY*12,ANS*256
C ---------------------------------------------------------

      MDOC = 0
      ANS  = ' '
      CALL LENSTR_BL(LINE,NLK)
      IF(NLK.GT.11) NLK=11
      
C     get keyword from input line
      IF(NLK.GE.1) THEN
        IF(LINE(NLK:NLK).EQ.':') THEN
          LINE(NLK:NLK) = ' '
          NLK           = NLK-1
        ENDIF
      ENDIF

      IF(NLK.GE.1) THEN
        KEY = '_'//LINE(1:NLK)
        NLK = NLK+1
      ELSE
        KEY = ' '
        NLK = 1
      ENDIF

      CALL CHECK_LINE(1,KEY)
C     now KEY is keyword      
     

      CALL LENSTR_BL(LINE,NL)
      IF(NL.GT.254) NL = 254
      IF(NL.LE.0) THEN
        LINE(1:1) = ' '
        NL        = 1
      ENDIF

      NL          = NL + 1
      LINE(NL:NL) = ':'

      IF(IBATCH.EQ.0) THEN
C       display keyword and ask parameters in iteractive mode
        IF(BAT_MODE.EQ.0) CALL DISPL_BL(LINE(1:NL))
      ENDIF
C ---
      IF(NLK.GT.1.AND.IBATCH.GT.0) THEN
C       not iterractive mode
C       search KEY in array of stored kewords STOR_KEY

        DO K=1,KEY_MAX
          IF(FLAG(K).GT.0) THEN
            CALL LENSTR_BL(STOR_KEY(K),NLSK)
            IF(NLSK.EQ.NLK.AND.KEY(1:NLK).EQ.STOR_KEY(K)(1:NLK))THEN
              ANS = STOR(K)
              CALL LENSTR_BL(ANS,NLA)
C             FLAG(K) = 0
              FLAG(K) = -1
              NKEY    = NKEY-1
              GO TO 200
            ENDIF
          ENDIF
        ENDDO

      ENDIF

            
 100  CONTINUE
      IF(IEND.GT.0) THEN
        IT = 2*KEY_MAX 
        IF(IEND.GT.IT) GO TO 20
        ANS(1:12) = ',,,,,,,,,,,,'
        NLA       = 12
        LINE      = ANS(1:NLA)
        IEND      = IEND + 1
        RETURN
      ENDIF

      LINE=' '
      READ(*,'(A)',ERR=10,END=20) LINE
      CALL LENSTR_BL(LINE,NLA)
      IF(NLA.GT.255) NLA = 255
      IF(NLA.LE.0) THEN
        LINE(1:12) = ',,,,,,,,,,,,'
        NLA        = 12
      ENDIF

      ANS=LINE(1:NLA)

      IF(ANS(1:4).EQ.'_END'.OR.ANS(1:4).EQ.'_end') THEN
        IEND = IEND + 1
        GO TO 100
      ENDIF

      IF(BAT_MODE.EQ.1) THEN
        M = 1
        IF(NLA.GT.0) CALL MSGDOC(M,LINE(1:NLA))
      ENDIF

 200  CONTINUE

      IF(ANS(1:1).EQ.'#') THEN
C       write to batch file
        IF(BATCH_FILE.GT.0) THEN
          WRITE(BATCH_FILE,'(A)') ANS(1:NLA)
        ENDIF
        GO TO 100
      ENDIF

      IF(NLK.GT.1.AND.ANS(1:1).EQ.'_') THEN
C       IBATCH = 1
        NLKR   = 0
        IF(NLA.GT.0) THEN
          DO I=1,NLA
            IF(ANS(I:I).NE.' ') THEN
              KEYR(I:I) = ANS(I:I)
              NLKR      = NLKR + 1
            ELSE
              GO TO 300
            ENDIF
          ENDDO
        ENDIF
 300    CONTINUE

C       IF(NLA.GE.NLK) THEN
C       KEYR = ANS(1:NLK)
          CALL CHECK_LINE(1,KEYR)
          IF(KEY(1:NLK).NE.KEYR(1:NLKR)) THEN
            DO K=1,KEY_MAX
              IF(FLAG(K).EQ.0) THEN
                IF(NLA.GT.NLKR) THEN
                  STOR(K)     = KEYR(1:NLKR)//' '//ANS(NLKR+2:NLA)
                  STOR_KEY(K) = KEYR(1:NLKR)
                ELSE
                  STOR(K)     = KEYR(1:NLKR)//'   '
                  STOR_KEY(K) = KEYR(1:NLKR)
                ENDIF
                FLAG(K) = 1
                NKEY    = NKEY + 1
                GO TO 100  
              ENDIF
            ENDDO
            GO TO 100
          ENDIF
C       ENDIF
        N= NLA - (NLKR+1)
        IF(N.LE.0) THEN
          ANS(1:12) = ',,,,,,,,,,'
          N         = 12
        ELSE
          K1       = NLKR+2
          K2       = K1 +N - 1
          ANS(1:N) = ANS(K1:K2)
        ENDIF
        NLA = N
      ENDIF
      
C -----
C     remove first blancs from answer string      
      J   = 0
      IFL = 0
      DO I=1,NLA
        IF(IFL.NE.0.OR.ANS(I:I).NE.' ') THEN
          J        = J+1
          IFL      = 1
          ANS(J:J) = ANS(I:I)
        ENDIF            
      ENDDO
      NLA     = J
      NLA_ANS = NLA
C ---
C     put several symbols ',' in the end of answer string 
      LINE    = ANS(1:NLA)
      IF(NLA.LE.245) THEN
        NLA               = NLA+6
        LINE(NLA+1:NLA+6) = ',,,,,,'
      ENDIF

      IF(BATCH_FILE.GT.0.AND.IEND.EQ.0) THEN
C       write to batch file
        IF(NLK.GT.1) THEN
          WRITE(BATCH_FILE,'(A)',ERR=30)
     *     KEY(1:NLK)//' '//ANS(1:NLA_ANS)
        ELSE
          WRITE(BATCH_FILE,'(A)',ERR=30) ANS(1:NLA_ANS)
        ENDIF
      ENDIF
C ---
      RETURN
C ---------------------------------------------------------
 10   CALL MSGERR(MDOC,' ERROR: read input stream')
      GO TO 1000
 20   CALL MSGERR(MDOC,' ERROR: end of input stream')
      GO TO 1000
 30   CALL MSGERR(MDOC,' ERROR: write to batch file')
 1000 CALL FINISH
      END


C ******
      SUBROUTINE CHECK_BATCH(IBAT)
C
C -P- CHECK_BAT - return info about mode / dialogue (0) or batch (1)/.
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ******
      INTEGER*4 IBAT
C ------
      IBAT = BAT_MODE
      RETURN
      END

C ******
      SUBROUTINE SET_BATCH(IBAT)
C
C -P- CHECK_BAT - return info about mode / dialogue (0) or batch (1)/.
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ******
      INTEGER*4 IBAT
C ------
      BAT_MODE = IBAT
      RETURN
      END

C ******
      SUBROUTINE SET_DOC_UNIT(IUNIT)
C
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ******
      INTEGER*4 IUNIT
C ------
      DOC_FILE = IUNIT
      RETURN
      END

C ******
      SUBROUTINE CLEAR_DEF
C
C -P- CLEAR_DEF - return dialogue mode.  
C
C ******
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ---
      PARAMETER ( KEY_MAX = 40 )
      COMMON/COMASK/ IEND,NKEY,FLAG,STOR,STOR_KEY 
      INTEGER*4 FLAG(KEY_MAX),IEND,NKEY
      CHARACTER STOR(KEY_MAX)*256,STOR_KEY(KEY_MAX)*11
      COMMON/COMASK2/ NKEY_TEST,KEY_TEST
      INTEGER*4 NKEY_TEST
      CHARACTER KEY_TEST(KEY_MAX)*11
C -----------------------------------------------------------
C     IF(BAT_MODE.GT.0) RETURN
      IEND      = 0
      IBATCH    = 0
      NKEY      = 0
      NKEY_TEST = 0
      DO I=1,KEY_MAX
        FLAG(I) = 0
      ENDDO
      RETURN
      END

C ******
      SUBROUTINE WRT_BATCH(LINE)
C
C -P- WRT_BATCH - write message to BATCH-FILE.
C
      CHARACTER LINE*(*)
C ******
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ---
      INTEGER*4 NL
      CHARACTER STR*256
C ---------------------------------------------------------
      IF(BATCH_FILE.GT.0) THEN
        CALL LENSTR_BL(LINE,NL)
        IF(NL.LE.0) THEN
          NL  = 1
          STR = ' '
        ELSE
C         IF(NL.GT.79) NL=79
          STR = LINE(1:NL)
        ENDIF
        WRITE(BATCH_FILE,'(A)',ERR=10) STR(1:NL)
      ENDIF
C ---
      RETURN
 10   CALL MSGERR(MDOC,' ERROR: write to BATCH_file')
      CALL FINISH
      END

      SUBROUTINE OPENDOC(MMDOC)
C
C -P- OPENDOC   open file-document iunit=DOC_FILE  =48
C                and file-inbatch  iunit=BATCH_FILE=47
C 
C     input :    MMDOC > 0  open, get name from terminal 
C                MMDOC < 0  open, get name from /COMLIB/..,LINEL,..  
C     output:    MMDOC , =0 don't open
C
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ---
      INTEGER*4  MMDOC,MDOC
C ******
      CHARACTER  NAME1*80,MSG*1,MSG4*1,FNAME*80,CH1*1,TYPE*1
      CHARACTER  NAMEB*80,NAME*80
      CHARACTER  LINE*80

CMS   LOGICAL*2  EXI

      LOGICAL    EXI
C ----------------------------
      INCLUDE 'crd_com.fh'
C ---------------------------------------------------------------------
C     DOC_FILE   = 0
C     BATCH_FILE = 0
C     BAT_MODE   = 0
  10  CONTINUE
      MDOC = MMDOC      
      IF(MDOC.GE.997) THEN
        NAME1 = LINEL
        IF(MDOC.EQ.997) NAME1='#'
      ELSE
        IF(MDOC.EQ.0.OR.ABS(MDOC).GE.99) RETURN
        DOC_FILE = ABS(MDOC)
        NAME1    = ' '
        IF(MDOC.GT.0) THEN
          WRITE(*,*) 
          CALL DISPL_BL(
     *    'FILE-DOCUMENT / tape name or CR / :')
          READ(*,'(A)')  NAME1
        ELSE
          NAME1=LINEL
        ENDIF
      ENDIF
  11  CH1=NAME1(1:1)

      CALL LENSTR_BL(NAME1,LEN)

      CALL CHKSMB(CH1,TYPE)
      IF(TYPE.EQ.'?'.OR.CH1.EQ.' '.OR.CH1.EQ.',') THEN
        NAME1(1:1)=' '
      ENDIF
      CALL LENSTR_BL(NAME1,LEN)
      IF(NAME1(1:1).EQ.'#') THEN
        IF(MDOC.GT.0) THEN
          READ(*,'(A)')  NAME1
          GO TO 11           
        ELSE
          DOC_FILE   = 0
          MDOC       = 0
          BATCH_FILE = 0
          MMDOC      = MDOC
          RETURN
        ENDIF
      ENDIF

      IF(NAME1(1:1).EQ.'_') THEN
        IF(NAME1(1:4).EQ.'_DOC') THEN
C
C         IBATCH  =1
C
          BAT_MODE=1
          CALL LENSTR_BL(NAME1,LEN)
          IF(LEN.GE.6) THEN
            J=0
            LINE=' '
            DO I=6,LEN
              IF(NAME1(I:I).NE.' ') THEN
                J=J+1
                LINE(J:J)=NAME1(I:I)
              ENDIF
            ENDDO
            CALL LENSTR_BL(LINE,LEN)
            NAME1=LINE(1:LEN)

            IF(MDOC.EQ.997) THEN
            IF(NAME1(1:1).EQ.'N'.OR.NAME1(1:1).EQ.'n') THEN
              MMDOC = 0
              RETURN
            ELSE IF(NAME1(1:1).EQ.'Y'.OR.NAME1(1:1).EQ.'y') THEN
              MDOC  = 999
              MMDOC = 999
              NAME1 = PROGRAMM
            ELSE IF(NAME1(1:1).EQ.'A'.OR.NAME1(1:1).EQ.'a') THEN
              MDOC  = 998
              MMDOC = 998
              NAME1 = PROGRAMM
            ENDIF
            ENDIF
          ELSE
            NAME1 = ' '
          ENDIF
        ENDIF
      ENDIF

      IF(NAME1(1:1).NE.' ') THEN
C --
        CALL LENSTR_BL(NAME1,LEN)
        IF(LEN.GT.0.AND.NAME1(1:1).NE.','.AND.NAME1(1:1).NE.' ') THEN
          NAME=NAME1(1:LEN)
          DO I=LEN,1,-1
            IF(NAME(I:I).EQ.',') THEN
              NAME(I:I)=' '
            ELSE
              IF(NAME(I:I).NE.' ') GO TO 800
            ENDIF 
          ENDDO
 800      CONTINUE
          LINE = NAME
          CALL LENSTR_BL(LINE,LEN)
          IF(LEN.GT.4.AND.LINE(LEN-3:LEN).EQ.'.doc') THEN
            NAME1 = LINE(1:LEN-4)
          ENDIF
        ENDIF
C -------

        CALL LENSTR_BL(NAME1,NL)

        FNAME = NAME1(1:NL)//'.doc'
        NAMEB = NAME1(1:NL)//'.btc'

        IF(MDOC.GT.0) THEN   

        INQUIRE(FILE=FNAME,EXIST=EXI)
        IF(EXI) THEN
C         DOC_FILE=48
          DOC_FILE = CRDOC_IUN
          OPEN(UNIT=DOC_FILE,FILE=FNAME,ACCESS='SEQUENTIAL',ERR=20,
     *         STATUS='OLD',FORM='FORMATTED') 
 50       CONTINUE
          IF(MMDOC.GE.998) THEN
C do not keep old contents : LINE(1:1)='N'
            LINE(1:1)='N'
            IF(MMDOC.EQ.998) LINE(1:1)='Y'
          ELSE
            CALL DISPL_BL(
     *      'Do you want to keep old contents (<Y>,N) ? :')
            READ(*,'(A)') LINE
          ENDIF
          IF(LINE(1:1).EQ.'_') THEN
            IF(LINE(1:5).EQ.'_KEEP') THEN
              CALL LENSTR_BL(LINE,LEN)
              IF(LEN.GE.7) THEN
                J=0
                DO I=7,LEN
                 IF(LINE(I:I).NE.' ') THEN
                   J=J+1
                   LINE(J:J)=LINE(I:I)
                   GO TO 100 
                 ENDIF
                ENDDO
              ENDIF
            ENDIF
          ENDIF
 100      CONTINUE
          MSG=LINE(1:1)
          IF(MSG.EQ.'#') GO TO 50
          IF(MSG.EQ.'n') MSG='N'
          IF(MSG.EQ.'N') THEN
            REWIND DOC_FILE
          ELSE
            DO   I=1,32767
              READ(DOC_FILE,'(A)',END=45) LINE
            ENDDO
   45       CONTINUE             
            BACKSPACE DOC_FILE
          ENDIF 
        ELSE
   30     CONTINUE
          IF(MDOC.GE.998) THEN
            LINE(1:1)='Y'
          ELSE
            CALL DISPL_BL(
     *'Do you really want to have DOC-file (<Y>,N) ?:')
            READ(*,'(A)') LINE
          ENDIF
          IF(LINE(1:1).EQ.'_') THEN
            IF(LINE(1:5).EQ.'_KEEP') THEN
              CALL LENSTR_BL(LINE,LEN)
              IF(LEN.GE.7) THEN
                J=0
                DO I=7,LEN
                 IF(LINE(I:I).NE.' ') THEN
                   J=J+1
                   LINE(J:J)=LINE(I:I)
                   GO TO 101 
                 ENDIF
                ENDDO
              ENDIF
            ENDIF
          ENDIF
 101      CONTINUE
          MSG4 = LINE(1:1)
          IF(MSG4.EQ.'#') GO TO 30
          IF(MSG4.EQ.'n') MSG4='N'
          IF(MSG4.NE.'N') THEN
            DOC_FILE=48
            OPEN(UNIT=DOC_FILE,FILE=FNAME,ACCESS='SEQUENTIAL',ERR=20,
     *          STATUS='UNKNOWN',FORM='FORMATTED')           
          ELSE 
            DOC_FILE   = 0
            MDOC       = 0
            BATCH_FILE = 0
          ENDIF 
        ENDIF

        ENDIF

      ELSE
        DOC_FILE   = 0
        MDOC       = 0
        BATCH_FILE = 0
      ENDIF

c     IF(DOC_FILE.NE.0.AND.MMDOC.NE.999) THEN

      IF(DOC_FILE.NE.0) THEN
C       BATCH_FILE=47
        BATCH_FILE = CRBAT_IUN
        INQUIRE(FILE=NAMEB,EXIST=EXI)
        IF(EXI) THEN
          OPEN(UNIT=BATCH_FILE,FILE=NAMEB,ACCESS='SEQUENTIAL',ERR=20,
     *         STATUS='OLD',FORM='FORMATTED')           
          IF(MSG.EQ.'N') THEN
            REWIND BATCH_FILE
          ELSE  
            DO   I=1,32767
              READ(BATCH_FILE,'(A)',END=46) LINE
            ENDDO
   46       CONTINUE             
            BACKSPACE BATCH_FILE
          ENDIF
        ELSE
          OPEN(UNIT=BATCH_FILE,FILE=NAMEB,ACCESS='SEQUENTIAL',ERR=20,
     *         STATUS='UNKNOWN',FORM='FORMATTED')           
        ENDIF 
      ENDIF
      WRITE(*,*)
      MDOC  = ABS(MDOC)
      MMDOC = MDOC
      RETURN

   20 WRITE(*,*) ' ERROR: OPEN DOC_FILE or BATCH_FILE'
      IF(MMDOC.LT.997) GO TO 10
      RETURN
      END

      SUBROUTINE CLOSE_BATCH(M)
C
C -P- CLOSE_BATCH - close BATCH-file.
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ---
C ******
      INTEGER*4 M
      CHARACTER LINE*80
C -------------------------
      IF(BATCH_FILE.GT.0) THEN
        LINE='stop'
        CALL WRT_BATCH(LINE)
        END FILE BATCH_FILE
        CLOSE(BATCH_FILE)
        BATCH_FILE=0
      ENDIF
      RETURN
      END          

C ******
      SUBROUTINE CLOSE_DOC(M)
C
C -P- CLOSE_DOC - close DOC-file.
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ---
C ******
      INTEGER*4 M
C -------------------------
      IF(DOC_FILE.GT.0) THEN
        END FILE DOC_FILE
        CLOSE(DOC_FILE)
      ENDIF
      RETURN
      END          


      SUBROUTINE FINISH
C -----------------------------------------------------------
C     FINISH - close DOC-file.
C -----------------------------------------------------------
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ------
      INTEGER*4 M,LEN
      CHARACTER LINE*80
C ------------------------------------------------------------
      M=-1      

      CALL LENSTR_BL(PROGRAMM,LEN)
      IF(LEN.LE.0) THEN
        LEN=1
        PROGRAMM(1:1)=' '
      ELSE IF(LEN.GT.20) THEN
        LEN=20
      ENDIF
      WRITE(LINE,10) PROGRAMM(1:LEN)      
  10  FORMAT(' **** END //////// ',A,' ///////// END ****')

      CALL MSGDOC(M,LINE)
      IF(DOC_FILE.GT.0) THEN
        END FILE DOC_FILE
        CLOSE(DOC_FILE)
      ENDIF

      IF(BATCH_FILE.GT.0) THEN
C        WRITE(LINE,20) PROGRAMM(1:LEN)      
C  20    FORMAT('_END   ',A)
C        CALL WRT_BATCH(LINE)
        LINE='stop'
        CALL WRT_BATCH(LINE)
        END FILE BATCH_FILE
        CLOSE(BATCH_FILE)
      ENDIF

      CALL EXIT
      END          

      SUBROUTINE ERRWRT(N,LINE)
      INTEGER   N,M
      CHARACTER LINE*(*)
C --------------------------------
      M = 0
      CALL MSGERR(M,LINE)
      RETURN
      END

      SUBROUTINE START_CCP4
C --------------------------------
      CALL CCPFYP
      RETURN
      END

      SUBROUTINE SET_UNIT_CORR
C -------------------------------
C     in make_subr.f:
C                    in SUBROUTINE START: after CALL SET_UNIT_NUMBERS  
C
C -------------------------------
      RETURN
      END

      SUBROUTINE SET_LINK_CORR
C -------------------------------
C     in make_crd.f:
C                    in SUBROUTINE PRE_DESCR  
C
C -------------------------------
      RETURN
      END

      SUBROUTINE CORR_FILE_NAME(NAMEF)
C -------------------------------------------
      CHARACTER NAMEF*(*),NAME*256
C -------------------------------------------
      CALL LENSTR_BL(NAMEF,LEN)
      IF(LEN.GT.0.AND.NAMEF(1:1).NE.','.AND.NAMEF(1:1).NE.' ') THEN
        NAME = NAMEF(1:LEN)
        DO I=LEN,1,-1
          IF(NAME(I:I).EQ.',') THEN
            NAME(I:I)=' '
          ELSE
            IF(NAME(I:I).NE.' ') GO TO 100
          ENDIF 
        ENDDO
 100    CONTINUE
      ELSE
        NAME = ' '
      ENDIF
      NAMEF = NAME
      RETURN 
      END

      SUBROUTINE WRITE_DEPOSIT_STATS(IOUT_FILE)
      IMPLICIT NONE
      INTEGER IOUT_FILE
      RETURN
      END
