c
      subroutine find_max_ints(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
      real fmax(2,nasym)
c
      integer maxcomp

      real, allocatable :: df(:)
      real, allocatable :: shift(:)
      real, allocatable :: d2f(:,:)
      real, allocatable :: d2f_inv(:,:)
      integer, allocatable :: obs_bins(:)
      integer, allocatable :: epsls(:)
      integer, allocatable :: centrs(:)
      real, allocatable :: aniso_scales(:)
c     
c--   locals
      integer i,j,k,k1,ibin
      integer jc,jc1,jal,jal1
      integer o_s,o_f,c_s,c_f,o_c_s,o_c_f,c_n
      integer np,ierr
      real aniso_l(48)
      real sigma,sigma1,eps_l
      real a_all,b_all,Ic(48),Icexp,sigIc
      real iobs_l,w1,wo
      integer nzero,nzero1
      integer inv_flag
c
      real toler
c
c
c---  body
      toler = 0.1e-6
      maxcomp = 0
      do i=1,num_blocks
         maxcomp = max(maxcomp,
     &        ref_2_asym_start(i+1)-ref_2_asym_start(i)+1)
      enddo
      allocate(df(maxcomp))
      allocate(shift(maxcomp))
      allocate(d2f(maxcomp,maxcomp))
      allocate(d2f_inv(maxcomp,maxcomp))
      allocate(obs_bins(num_blocks))
      call get_obs_bins(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
c
      allocate(epsls(nasym))
      allocate(centrs(nasym))
      call get_eps_centrs(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     epsls,centrs,
     &     ierr)

      allocate(aniso_scales(nasym))
      call aniso_contrs(nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     aniso_scales,
     &     ierr)

      nzero1 = 0
      nzero = 0
      inv_flag = 1
      do i=1,num_blocks
         df(1:maxcomp) = 0.0
         d2f(1:maxcomp,1:maxcomp) = 0.0
         ibin = obs_bins(i)
         sigma = sigma_ml(ibin)
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         jc = 0
         do j=c_s,c_f
            jc = jc + 1
            c_n = block_2_asym(j)
            a_all = scale_ml(ibin,1)*fcalc(1,c_n)
            b_all = scale_ml(ibin,1)*fcalc(2,c_n)
            do  k=1,npart_act
               a_all = a_all +
     &              scale_ml(ibin,k+1)*fpart(k,1,c_n)
               b_all = b_all + 
     &              scale_ml(ibin,k+1)*fpart(k,2,c_n)
            enddo
            Ic(jc) = (a_all**2+b_all**2)
c*aniso_scales(c_n)
            eps_l = epsls(c_n)
            sigma1 = sigma
c*aniso_scales(c_n)
            Icexp = Ic(jc)
            sigIc  = sigma1+2.0*sqrt(Ic(jc))*sqrt(sigma1)
            if(centrs(c_n).eq.1) sigIc = 2.0*sigIc
            w1 = 1.0/sigIc**2
            df(jc) = df(jc) + w1*Icexp
            d2f(jc,jc) = d2f(jc,jc) + w1
            aniso_l(jc) = aniso_scales(c_n)
c            aniso_l(jc) = 1.0
         enddo
         
         do  j=o_s,o_f
            iobs_l = max(0.0,iobs(1,j))
            if(iobs(1,j).le.0.0) nzero1 = nzero1 + 1
            o_c_s = obs_start(j) + 1
            o_c_f = obs_start(j+1)
            wo = 1/iobs(2,j)**2
c            wo = 1.0
            do k=o_c_s,o_c_f
               jc = ref_2_asym(k)
               jal = comp_numb(k)
               df(jc) = df(jc) + 
     &              twin_frac(jal)*iobs_l*wo*aniso_l(jc)
               do k1=o_c_s,o_c_f
                  jc1 = ref_2_asym(k1)
                  jal1 = comp_numb(k1)
                  d2f(jc,jc1) = d2f(jc,jc1) + 
     &                 twin_frac(jal)*twin_frac(jal1)*wo*
     &                 aniso_l(jc)*aniso_l(jc1)
               enddo
            enddo
         enddo
         np = c_f - c_s + 1
         call eigen_filter_inv_r90(toler,d2f(1:np,1:np),np,np,
     &        df(1:np),shift(1:np),d2f_inv(1:np,1:np),ierr)
         jc = 0
         do j=c_s,c_f
            jc = jc + 1
            c_n = block_2_asym(j)
            fmax(1,c_n) = sqrt(max(0.0*Ic(jc),shift(jc)))
            if(fmax(1,c_n).le.0.0) then
               fmax(1,c_n) = 0.5*sqrt(Ic(jc))
            endif
            fmax(2,c_n) = sqrt(fmax(1,c_n)**2+
     &           sqrt(d2f_inv(jc,jc)))-fmax(1,c_n)
            if(shift(jc).le.0.0) then
c               write(*,*)'Problem in max',iobs(1,o_s:o_f),shift(1:np),
c     &              fmax(1:2,c_n),'calc ',Ic(1:np)
               nzero = nzero + 1
            endif
            if(d2f_inv(jc,jc).le.0) then 
c               write(*,*)'Another problem',d2f_inv(jc,jc)
            endif
c            if(np.eq.1.and.iobs(1,o_s).gt.0.0) write(*,*)fmax(1:2,c_n),
c     &           sqrt(iobs(1,o_s)),
c     & sqrt(iobs(1,o_s)+iobs(2,o_s))-sqrt(iobs(1,o_s))
         enddo
      enddo
c      write(*,*)nzero,nzero1
c
      deallocate(df)
      deallocate(shift)
      deallocate(d2f)
      deallocate(obs_bins)
      deallocate(aniso_scales)
      deallocate(epsls)
      deallocate(centrs)
      return
      end
c
      subroutine find_max_ints_rat(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
      real fmax(2,nasym)
c
      integer maxcomp

      real, allocatable :: df(:,:)
      real, allocatable :: shift(:)
      real, allocatable :: d2f(:,:)
      real, allocatable :: d2f_inv(:,:)
      integer, allocatable :: obs_bins(:)
      integer, allocatable :: epsls(:)
      integer, allocatable :: centrs(:)
      real, allocatable :: aniso_scales(:)
c     
c--   locals
      integer i,j,k,k1,ibin
      integer jc,jc1,jal,jal1
      integer o_s,o_f,c_s,c_f,o_c_s,o_c_f,c_n
      integer np,ierr
      real aniso_l(48)
      real sigma,sigma1,eps_l,obs2calc
      real a_all(48),b_all(48),Ic(48),Icexp,sigIc
      real del0,del1
      real Ict0
      real iobs_l,w1,wo
      integer nzero,nzero1
      integer inv_flag
c
      real toler
c
c
c---  body
      allocate(aniso_scales(nasym))
      call aniso_contrs(nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     aniso_scales,
     &     ierr)

      toler = 0.1e-6
      maxcomp = 0
      do i=1,num_blocks
         maxcomp = max(maxcomp,
     &        ref_2_asym_start(i+1)-ref_2_asym_start(i))
      enddo
      allocate(df(2,maxcomp))
      nzero1 = 0
      nzero = 0
      inv_flag = 1
      scale_ml(1:nbin_ml,1:(npart_act+1))=1.0
      del0 = 0.0
      del1 = 0.0
      do i=1,num_blocks
c         df(1:2,1:maxcomp) = 0.0
c         write(*,*)'Block number ',i
c         ibin = obs_bins(i)
         ibin = 1
c         sigma = sigma_ml(ibin)
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         jc = 0
         np = c_f - c_s + 1
         a_all(1:np) = 0.0
         b_all(1:np) = 0.0
         do j=c_s,c_f
            jc = jc + 1
            c_n = block_2_asym(j)
            a_all(jc) = scale_ml(ibin,1)*fcalc(1,c_n)
            b_all(jc) = scale_ml(ibin,1)*fcalc(2,c_n)
            do  k=1,npart_act
               a_all(jc) = a_all(jc) +
     &              scale_ml(ibin,k+1)*fpart(k,1,c_n)
               b_all(jc) = b_all(jc) + 
     &              scale_ml(ibin,k+1)*fpart(k,2,c_n)
            enddo
            Ic(jc) = a_all(jc)**2 + b_all(jc)**2
            Ic(jc) = Ic(jc)*aniso_scales(c_n)
         enddo

c         write(*,*)'Contrib ok'
         df(1:2,1:np) = 0.0
         do  j=o_s,o_f
            iobs_l = max(0.01*iobs(2,j),iobs(1,j))
            if(iobs(1,j).le.0.0) nzero1 = nzero1 + 1
            o_c_s = obs_start(j) + 1
            o_c_f = obs_start(j+1)
            Ict0 = 0.0
            do k=o_c_s,o_c_f
               jc = ref_2_asym(k)
               jal = comp_numb(k)
               Ict0 = Ict0 + twin_frac(jal)*Ic(jc)
            enddo
            obs2calc = sqrt(iobs_l/Ict0)
c            del0 = del0 + abs(sqrt(iobs_l)-sqrt(Ict0))
c            del1 = del1 + sqrt(iobs_l)
            do k=o_c_s,o_c_f
               jc = ref_2_asym(k)
               jal = comp_numb(k)
               df(1,jc) = df(1,jc) + twin_frac(jal)*obs2calc*a_all(jc)
               df(2,jc) = df(2,jc) + twin_frac(jal)*obs2calc*b_all(jc)
            enddo
         enddo
         jc = 0
         do j=c_s,c_f
            jc = jc + 1
            c_n = block_2_asym(j)
            fmax(1,c_n) = sqrt(df(1,jc)**2+df(2,jc)**2)
c            fmax(1,c_n) = fmax(1,c_n)
c/sqrt(aniso_scales(c_n))
c            del0 = del0 + abs(fmax(1,c_n)-sqrt(Ic(jc)))
c            del1 = del1 + fmax(1,c_n)
c            fmax(1,c_n) = sqrt(Ic(jc))
            fmax(2,c_n) = 0.1*fmax(1,c_n)
c            if(c_n.le.100) write(*,*)fmax(1,c_n)
c            if(i.le.100) write(*,*)twin_frac(1:ntwin_domain),
c     &           obs2calc,fmax(1,c_n),sqrt(Ic(jc)),
c     &           sqrt(max(0.0,iobs(1,o_s)))
         enddo
      enddo
c      write(*,*)'Another r ',del0/del1
c      write(*,*)nzero,nzero1
c
c      stop
      deallocate(df)
      deallocate(aniso_scales)
c      stop
      return
      end
c
      subroutine find_max_ml_twin(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
      real fmax(2,nasym)
c
      integer maxcomp

      real, allocatable :: df(:)
      real, allocatable :: shift(:)
      real, allocatable :: d2f(:,:)
      real, allocatable :: d2f_inv(:,:)
      integer, allocatable :: obs_bins(:)
      integer, allocatable :: epsls(:)
      integer, allocatable :: centrs(:)
      real, allocatable :: aniso_scales(:)
c
c--   locals
      integer i,j,k,k1,ibin
      integer jc,jc1,jal,jal1
      integer o_s,o_f,c_s,c_f,o_c_s,o_c_f,c_n
      integer np,ierr
      real sigma,sigma1,eps_l
      real a_all,b_all,Icexp,sigIc,Ict0,fobs
      real iobs_l,w1,wo,del1
      real fom,xx,xx0,xx1
      real aniso_l(48)
      real Ic(48),fc(48),fmax_save(48),fobs_l(48)
c
      integer nref_l
      real del_l,rfac_l
c
c--   for minimisation
      integer ncycle_lapl,ncycle_line,ic_l,icycle
      real fold,f1,a,b,r1,r2,f2,d1
      real lambd,lambd2,lambdmin,tst,g2p,tmp,l12
c
      logical conv_line,conv_flag,shift_ok
      real al0,tol_conv
      real toler
      real sim,fom_calc
      external sim,fom_calc
c
c---  body
      al0 = 1.0e-4
      tol_conv = 1.0E-6
      toler = 1.0e-8
      maxcomp = 0
      do i=1,num_blocks
         maxcomp = max(maxcomp,
     &        ref_2_asym_start(i+1)-ref_2_asym_start(i)+1)
      enddo
      allocate(df(maxcomp))
      allocate(shift(maxcomp))
      allocate(d2f(maxcomp,maxcomp))
      allocate(d2f_inv(maxcomp,maxcomp))
      allocate(obs_bins(num_blocks))
      call get_obs_bins(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
c
      allocate(epsls(nasym))
      allocate(centrs(nasym))
      call get_eps_centrs(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     epsls,centrs,
     &     ierr)
c
      allocate(aniso_scales(nasym))
      call aniso_contrs(nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     aniso_scales,
     &     ierr)
      ncycle_lapl = 20
      ncycle_line = 20
      del_l  = 0.0
      rfac_l = 0.0
      nref_l = 0
c      do i=1,nbin_ml
c         write(*,*)scale_ml(i,1:(npart_act+1)),sigma_ml(i)
c      enddo
c      stop
      do i=1,num_blocks
         ibin = obs_bins(i)
         sigma = sigma_ml(ibin)
         icycle = 0
         conv_flag = .FALSE.
c         write(*,*)'block_number ',i
         do while(icycle.le.ncycle_lapl .and. .not.conv_flag)
            icycle = icycle + 1
            fold = 0.0
            df(1:maxcomp) = 0.0
            d2f(1:maxcomp,1:maxcomp) = 0.0
            o_s = block_start(i)+1
            o_f = block_start(i+1)
            c_s = ref_2_asym_start(i)+1
            c_f = ref_2_asym_start(i+1)
            jc = 0
c
c--Add scale contribution?
            do j=c_s,c_f
               jc = jc + 1
               c_n = block_2_asym(j)
               a_all = scale_ml(ibin,1)*fcalc(1,c_n)
               b_all = scale_ml(ibin,1)*fcalc(2,c_n)
               do  k=1,npart_act
                  a_all = a_all +
     &                 scale_ml(ibin,k+1)*fpart(k,1,c_n)
                  b_all = b_all + 
     &                 scale_ml(ibin,k+1)*fpart(k,2,c_n)
               enddo
               Ic(jc) = a_all**2+b_all**2
               aniso_l(jc) = sqrt(aniso_scales(c_n))
c               aniso_l(jc) = 1.0
               fobs_l(jc) = fmax(1,c_n)
c               write(*,*)icycle,fmax(1,c_n)
               fc(jc)   = sqrt(Ic(jc))
               sigma1 = sigma*epsls(c_n)*(1+centrs(c_n))
               w1 = 1.0/sigma1
               xx = 2.0*fobs_l(jc)*fc(jc)*w1
               fom  = fom_calc(centrs(c_n),xx)
               if(centrs(c_n).eq.0) then
                  call bessi0(xx,xx1,xx0)
               else
                  if(xx.gt.60) then
                     xx1 = 0.5
                     xx0 = xx
                  else
                     xx0 = 0.0
                     xx1 = cosh(xx)
                  endif
               endif
c               if(i.eq.58871) then
c                  write(*,*)icycle,xx,xx0,xx1,w1,fom,epsls(c_n),
c     &                 centrs(c_n)
c                  write(*,*)'anis',ibin,aniso_l(jc),w1,sigma
c                  write(*,*)'obs',fc(jc),fobs_l(jc),
c     &                 sqrt(iobs(1,o_s))/aniso_l(1)
c               endif
               df(jc) = df(jc) + 2.0*(fobs_l(jc)-fc(jc)*fom)*w1
               d2f(jc,jc) = d2f(jc,jc) + 2.0*w1
               fold = fold + (fobs_l(jc)**2+Ic(jc))*w1-xx0-log(xx1)
               if(centrs(c_n).eq.0) then
                  fold = fold - 1.0*log(fobs_l(jc))
                  df(jc) = df(jc) - 1.0/fobs_l(jc)
                  d2f(jc,jc) = d2f(jc,jc) + 1.0/fobs_l(jc)**2
               else
c                  fold = fold - 1.0*log(fobs_l(jc))
c                  df(jc) = df(jc) - 1.0/fobs_l(jc)
c                  d2f(jc,jc) = d2f(jc,jc) + 1.0/fobs_l(jc)**2
               endif               
c               fobs_l(jc) = fobs_l(jc)*aniso_l(jc)
c               if(i.eq.1989) then
c                  write(*,*)fobs_l(jc),fc(jc),sigma,sigma1,xx,xx1,fom,w1,
c                  write(*,*)'dd', 2.0*(fobs_l(jc)-fc(jc)*fom)*w1
c               endif
            enddo
            
            do  j=o_s,o_f
               iobs_l = max(-3.0*iobs(2,j),iobs(1,j))
               o_c_s = obs_start(j) + 1
               o_c_f = obs_start(j+1)
               Ict0 = 0
               do  k=o_c_s,o_c_f
                  jc = ref_2_asym(k)
                  jal = comp_numb(k)
                  Ict0 = Ict0 + 
     &                 twin_frac(jal)*(fobs_l(jc)*aniso_l(jc))**2
               enddo
               fold = fold + (Ict0-iobs_l)**2/(2.0*iobs(2,j)**2)
               wo = 1/iobs(2,j)**2
               del1 = wo*(Ict0-iobs_l)
c                  if(i.eq.1989) then
c                     write(*,*)'del1 ',Ict0,iobs_l
c                  endif
c               if(i.eq.1989) then
c                  write(*,*)'obs ',sqrt(iobs(1,j))/aniso_l(jc)
c               endif
               do k=o_c_s,o_c_f
                  jc = ref_2_asym(k)
                  jal = comp_numb(k)
                  df(jc) = df(jc) + 
     &                 2.0*twin_frac(jal)*del1*fobs_l(jc)*aniso_l(jc)**2

                  do k1=o_c_s,o_c_f
                     jc1 = ref_2_asym(k1)
                     jal1 = comp_numb(k1)
                     d2f(jc,jc1) = d2f(jc,jc1) + 
     &                    4.0*wo*twin_frac(jal)*twin_frac(jal1)*
     &                    (fobs_l(jc)*fobs_l(jc1))*
     &                    (aniso_l(jc)*aniso_l(jc1))**2
                  enddo
               enddo
            enddo
            np = c_f - c_s + 1
c            write(*,*)np,df(1:np),d2f(1:np,1:np)
            call eigen_filter_inv_r90(toler,d2f(1:np,1:np),np,np,
     &           df(1:np),shift(1:np),d2f_inv(1:np,1:np),ierr)
c            if(i.eq.1989) then
c               write(*,*)'shifts',shift(1:np),df(1:np),d2f(1:np,1:np)
c               write(*,*)'inv1',d2f_inv(1:np,1:np)
c               write(*,*)'inv',fmax(1,block_2_asym(c_s:c_f)),
c     &              fc(1:np),iobs(1,o_s:o_f)
c            endif
c            write(*,*)shift(1:np)
            if(ierr.ne.0) then
               write(*,*)'Problem'
               write(*,*)df(1:np)
               write(*,*)d2f(1:np,1:np)
               stop
            endif
            g2p = dot_product(df(1:np),shift(1:np))
            fmax_save(1:np) = fmax(1,block_2_asym(c_s:c_f))
c
c--   line minimisation
            tst = maxval(abs(shift(1:np))/fmax_save(1:np))
            lambdmin = tol_conv
            lambd = 1.0
            shift_ok = .FALSE.
            do while(.not.shift_ok)
               jc = 0
               shift_ok = .TRUE.
               do j=c_s,c_f
                  jc = jc + 1
                  shift_ok = shift_ok.and.
     &                 ((fmax_save(jc)-shift(jc)*lambd).gt.0.0)
               enddo
               if(lambd.le.0.1) goto 19
               if(.not.shift_ok) lambd = 0.75*lambd
               if(lambd.le.lambdmin) then
                  write(*,*)'We have a problem '
                  write(*,*)i,icycle,c_s,c_f,o_s,o_f,fmax_save(1:np),
     &                 shift(1:np),df(1:np),lambd,lambdmin,ncycle_line
                  goto 20
c                  stop
               endif
            enddo
 19         continue
c            write(*,*)lambd,fmax_save(1:np),shift(1:np)
c            if(lambd.le.lambdmin) goto 20
            ic_l = 0
            conv_line = .FALSE.
            do while(ic_l.le.ncycle_line.and. .not.conv_line)
               ic_l = ic_l + 1
               jc = 0
               do j=c_s,c_f
                  jc = jc + 1
                  c_n = block_2_asym(j)
                  fmax(1,c_n) = max(1.0e-6,
     &                 max(fmax_save(jc)/2,
     &                 fmax_save(jc)-shift(jc)*lambd))
               enddo
               f1 = 0.0
               jc = 0
               do j=c_s,c_f
                  jc = jc + 1
                  c_n = block_2_asym(j)
c                  Ic(jc) = a_all**2+b_all**2
                  fobs_l(jc) = fmax(1,c_n)
c                  fc(jc)   = sqrt(Ic(jc))
                  sigma1 = sigma*epsls(c_n)*(1+centrs(c_n))
                  w1 = 1.0/sigma1
                  xx = 2.0*fobs_l(jc)*fc(jc)*w1
                  if(centrs(c_n).eq.0) then
                     call bessi0(xx,xx1,xx0)
                     f1 = f1 - 1.0*log(fobs_l(jc))
                  else
c                     f1 = f1 - log(fobs_l(jc))
                     if(xx.gt.60) then
                        xx1 = 0.5
                        xx0 = xx
                     else
                        xx0 = 0.0
                        xx1 = cosh(xx)
                     endif
                  endif
                  f1 = f1 + (fobs_l(jc)**2+Ic(jc))*w1-xx0-log(xx1)
c                  anisos_l(jc) = sqrt(aniso_scales(c_n))
               enddo
            
               do  j=o_s,o_f
                  iobs_l = max(-3.0*iobs(2,j),iobs(1,j))
                  o_c_s = obs_start(j) + 1
                  o_c_f = obs_start(j+1)
                  Ict0 = 0
                  do  k=o_c_s,o_c_f
                     jc = ref_2_asym(k)
                     jal = comp_numb(k)
                     Ict0 = Ict0 + 
     &                    twin_frac(jal)*(fobs_l(jc)*aniso_l(jc))**2
                  enddo
                  f1 = f1 + (Ict0-iobs_l)**2/(2.0*iobs(2,j)**2)
               enddo
c               if(i.eq.1989) 
c     &              write(*,*)i,lambd,shift(1:np),
c     &              ic_l,icycle,f1,fold,fobs_l(1),Ict0,iobs_l
               if(lambd.lt.lambdmin) goto 20
               if(f1.le.fold-al0*lambd*g2p) then
                  conv_line = .TRUE.
                  goto 20
               endif
               if(ic_l.eq.1) then
c                  tmp = g2p/(2.0*(f1-fold+lambd*g2p))
                  tmp = 0.5
               else
                  l12 = lambd-lambd2
                  r1 = f1-fold+lambd*g2p
                  r2 = f2-fold+lambd2*g2p
                  a  = (r1/lambd**2-r2/lambd2**2)/l12
                  b = (-lambd2*r1/lambd**2+lambd*r2/lambd2**2)/l12
                  if(a.eq.0.0) then
                     tmp = g2p/(2.0*b)
                  else
                     d1 = max(0.0,b**2+3.0*a*g2p)
                     tmp = (-b+sqrt(d1))/(3.0*a)
                  endif
               endif
c               if(i.eq.58871)
c     &              write(*,*)ic_l,tmp,lambd,f1,fold,g2p
               tmp = min(tmp,0.9*lambd)
               lambd2 = lambd
               f2 = f1
               lambd = max(tmp,0.1*lambd)
            enddo
 20         continue
c
c--   Check the convergence
            tst = 0.0
            tst = maxval(abs(shift(1:np))*lambd/fmax_save(1:np))
            tst = g2p*lambd/np
            
            if(tst.lt.tol_conv.or.f1.gt.fold) then 
               if(f1.gt.fold) then
                  fmax(1,block_2_asym(c_s:c_f)) = fmax_save(1:np)
                  goto 30
               endif
               conv_flag = .TRUE.
            endif
c            if(i.eq.3346)
c     &           write(*,*)f1,fold,np,ic_l,lambd
         enddo
 30      continue
c         stop
         jc = 0
         do j=c_s,c_f
            jc = jc + 1
            c_n = block_2_asym(j)
c         write(*,*)fmax(1,c_n),iobs(1,o_s:o_f)

            del_l = del_l + abs(fmax(1,c_n)-fc(jc))
            rfac_l = rfac_l + abs(fmax(1,c_n))
            fmax(2,c_n) = sqrt(0.5*d2f_inv(jc,jc))
c            if(fmax(1,c_n).le.0.0) then
c               write(*,*)'Here we are ?'
c               stop
c            endif
            nref_l = nref_l + 1
        enddo
c        stop
      enddo

      deallocate(df)
      deallocate(shift)
      deallocate(d2f)
      deallocate(d2f_inv)
      deallocate(obs_bins)
      deallocate(epsls)
      deallocate(centrs)    
      write(*,*)nref_l,nasym
c      stop
      return
      end
c
      subroutine find_fexpected_ml(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,fexpected,fomcalc,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
      real fmax(2,nasym)
      real fexpected(2,nasym)
      real fomcalc(nasym)
c
      integer maxcomp

      real, allocatable :: df(:)
      real, allocatable :: shift(:)
      real, allocatable :: d2f(:,:)
      integer, allocatable :: obs_bins(:)
      integer, allocatable :: epsls(:)
      integer, allocatable :: centrs(:)
c
c--   locals
      integer i,j,k,k1,ibin
      integer jc,jc1,jal,jal1
      integer o_s,o_f,c_s,c_f,o_c_s,o_c_f,c_n,c_1
      integer np,ierr
      integer i_inter
      real sigma,sigma1,eps_l
      real scale_now
      real a_all,b_all,Icexp,sigIc,Ict0,fobs
      real ss,stl_c
      real iobs_l,w1,wo,del1
      real fom,xx,xx0,xx1
      real Ic(48),fc(48),fmax_save(48)
c
c--   for minimisation
      integer ncycle_lapl,ncycle_line,ic_l,icycle
      real fold,f1,a,b,r1,r2,f2,d1
      real cosp,sinp
c
      integer nref_l
      real fomall_l
      logical conv_line,conv_flag,shift_ok
      real al0,tol_conv
      real toler
      real sim,fom_calc,lstlsq_r
      external sim,fom_calc,lstlsq_r
c
c---  body
      al0 = 1.0e-4
      tol_conv = 1.0E-4
      toler = 0.1e-8
      maxcomp = 0
      do i=1,num_blocks
         maxcomp = max(maxcomp,
     &        ref_2_asym_start(i+1)-ref_2_asym_start(i)+1)
      enddo
      allocate(df(maxcomp))
      allocate(shift(maxcomp))
      allocate(d2f(maxcomp,maxcomp))
      allocate(obs_bins(num_blocks))
      fexpected(1:2,1:nasym) = 0.0
      call get_obs_bins(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
c
      allocate(epsls(nasym))
      allocate(centrs(nasym))
      call get_eps_centrs(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     epsls,centrs,
     &     ierr)
      fomall_l = 0.0
      nref_l = 0
      i_inter = -1
      do i=1,num_blocks
         ibin = obs_bins(i)
c         sigma = sigma_ml(ibin)
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
         ss = lstlsq_r(1,hkl_asym(1:3,c_1))
         stl_c = 2.0*sqrt(ss)
         call linter_value2(nbin_ml,smeanb_ml,sigma_ml,stl_c,
     &        i_inter,sigma)
         jc = 0
         do j=c_s,c_f
            jc = jc + 1
            c_n = block_2_asym(j)
            call linter_value2(nbin_ml,smeanb_ml,scale_ml(1,1),
     &           stl_c,i_inter,scale_now)
            a_all = scale_now*fcalc(1,c_n)
            b_all = scale_now*fcalc(2,c_n)
            do  k=1,npart_act
               call linter_value2(nbin_ml,smeanb_ml,scale_ml(1,k+1),
     &              stl_c,i_inter,scale_now)
               a_all = a_all + scale_now*fpart(k,1,c_n)
               b_all = b_all + scale_now*fpart(k,2,c_n)
            enddo
            Ic(jc) = a_all**2+b_all**2
            fobs = fmax(1,c_n)
            fc(jc)   = sqrt(Ic(jc))
            sigma1 = sigma*epsls(c_n)*(1+centrs(c_n))
     &           + 2.0*fmax(2,c_n)**2
            w1 = 1.0/sigma1
            xx = 2.0*fobs*fc(jc)*w1
            fom = fom_calc(centrs(c_n),xx)
            cosp = 0.0
            sinp = 0.0
            if(fc(jc).gt.0.0) then
               cosp = a_all/fc(jc)
               sinp = b_all/fc(jc)
            endif
            fexpected(1,c_n) = fmax(1,c_n)*fom*cosp
            fexpected(2,c_n) = fmax(1,c_n)*fom*sinp
            fomcalc(c_n) = fom
            fomall_l = fomall_l + fom
            nref_l = nref_l + 1
         enddo
      enddo
c      stop
c
      deallocate(df)
      deallocate(shift)
      deallocate(d2f)
      deallocate(obs_bins)
      deallocate(epsls)
      deallocate(centrs)
      return
      end
c
      subroutine find_fexpected2_ml(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,fexpected,fomcalc,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
      real fmax(2,nasym)
      real fexpected(2,nasym),fomcalc(nasym)
c
      integer maxcomp

      real, allocatable :: v1(:)
      real, allocatable :: df(:)
      real, allocatable :: df_j(:)
      real, allocatable :: shift(:)
      real, allocatable :: d2f(:,:)
      real, allocatable :: d2f_j(:,:)
      real, allocatable :: d2f_inv(:,:)
      integer, allocatable :: obs_bins(:)
      integer, allocatable :: epsls(:)
      integer, allocatable :: centrs(:)
      real, allocatable :: aniso_scales(:)
c
c--   locals
      integer i,j,k,k1,ibin
      integer jc,jc1,jal,jal1
      integer o_s,o_f,c_s,c_f,o_c_s,o_c_f,c_n,c_1
      integer np,ierr
      real aniso_l(48)
      real sigma,sigma1,eps_l
      real a_all,b_all,Icexp,sigIc,Ict0,fobs
      real iobs_l,w1,wo,del1
      real fom,xx,xx0,xx1
      real Ic(48),fc(48),fmax_save(48),fobs_l(48)
c
c--   for minimisation
      integer ncycle_lapl,ncycle_line,ic_l,icycle
      real fold,f1,a,b,r1,r2,f2,d1
      real cosp,sinp,cc
c
      real al0,tol_conv
      real toler
      real v0,v01,det0,det1,fomprime,fom2prime,a0
      real ss,stl_c
      integer i_inter
      real scale_now
      real sim,calc_determinant,lstlsq_r
      external sim,calc_determinant,lstlsq_r
c
c---  body
      eps_l = 1.0e-8
      al0 = 1.0e-4
      tol_conv = 1.0E-4
      toler = 0.1e-8
      maxcomp = 0
      fexpected(1:2,1:nasym) = 0.0
      fomcalc(1:nasym) = 0.0
      do i=1,num_blocks
         maxcomp = max(maxcomp,
     &        ref_2_asym_start(i+1)-ref_2_asym_start(i)+1)
      enddo
      allocate(v1(maxcomp))
      allocate(df(maxcomp))
      allocate(df_j(maxcomp))
c      allocate(shift(maxcomp))
      allocate(d2f(maxcomp,maxcomp))
      allocate(d2f_j(maxcomp,maxcomp))
      allocate(d2f_inv(maxcomp,maxcomp))

      allocate(obs_bins(num_blocks))
      call get_obs_bins(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
c
      allocate(epsls(nasym))
      allocate(centrs(nasym))
      call get_eps_centrs(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     epsls,centrs,
     &     ierr)
c
      allocate(aniso_scales(nasym))
      call aniso_contrs(nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     aniso_scales,
     &     ierr)
      i_inter = -1
c      write(*,*)'looping over'
      do i=1,num_blocks
         ibin = obs_bins(i)
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
         ss = lstlsq_r(1,hkl_asym(1:3,c_1))
         stl_c = 2.0*sqrt(ss)
         call linter_value2(nbin_ml,smeanb_ml,sigma_ml,stl_c,
     &        i_inter,sigma)
         jc = 0
         np = c_f - c_s + 1
         df(1:np) = 0.0
         d2f(1:np,1:np) = 0.0
         do j=c_s,c_f
            jc = jc + 1
            c_n = block_2_asym(j)
            call linter_value2(nbin_ml,smeanb_ml,scale_ml(1,1),stl_c,
     &           i_inter,scale_now)
            a_all = scale_now*fcalc(1,c_n)
            b_all = scale_now*fcalc(2,c_n)
            do  k=1,npart_act
               call linter_value2(nbin_ml,smeanb_ml,scale_ml(1,k+1),
     &              stl_c,i_inter,scale_now)
               a_all = a_all + scale_now*fpart(k,1,c_n)
               b_all = b_all + scale_now*fpart(k,2,c_n)
            enddo
            Ic(jc) = a_all**2+b_all**2
            fobs = fmax(1,c_n)
            fc(jc)   = sqrt(Ic(jc))
            sigma1 = sigma*epsls(c_n)*(1+centrs(c_n))
            w1 = 1.0/sigma1
            xx = 2.0*fobs*fc(jc)*w1
            if(centrs(c_n).eq.0) then
               df(jc) = df(jc) - 1.0/fobs
               d2f(jc,jc) = d2f(jc,jc) + 1.0/fobs**2
               fom = sim(xx)
            else
               if(xx.gt.60) then
                  fom = 1.0
               else
                  fom = tanh(xx)
               endif
            endif
            df(jc) = df(jc) + 2.0*(fobs-fc(jc)*fom)*w1
            d2f(jc,jc) = d2f(jc,jc) + 2.0*w1
            cosp = 0.0
            sinp = 0.0
            if(fc(jc).gt.0) then
               cosp = a_all/fc(jc)
               sinp = b_all/fc(jc)
            endif
            aniso_l(jc) = sqrt(aniso_scales(c_n))
            fobs_l(jc) = fmax(1,c_n)
            fexpected(1,c_n) = fmax(1,c_n)*fom*cosp
            fexpected(2,c_n) = fmax(1,c_n)*fom*sinp
            fomcalc(c_n) = fom
         enddo
         
         do  j=o_s,o_f
            iobs_l = max(-3.0*iobs(2,j),iobs(1,j))
            o_c_s = obs_start(j) + 1
            o_c_f = obs_start(j+1)
            Ict0 = 0.0
            do  k=o_c_s,o_c_f
               jc = ref_2_asym(k)
               jal = comp_numb(k)
               Ict0 = Ict0 + twin_frac(jal)*(fobs_l(jc)*aniso_l(jc))**2
            enddo
c            write(*,*)iobs(1,j)/iobs(2,j)
            wo = 1/iobs(2,j)**2
            del1 = wo*(iobs_l-Ict0)
            do k=o_c_s,o_c_f
               jc = ref_2_asym(k)
               jal = comp_numb(k)
               df(jc) = df(jc) +
     &              2.0*twin_frac(jal)*del1*fobs_l(jc)*aniso_l(jc)**2
               do k1=o_c_s,o_c_f
                  jc1 = ref_2_asym(k1)
                  jal1 = comp_numb(k1)
                  d2f(jc,jc1) = d2f(jc,jc1) + 
     &                 4.0*wo*twin_frac(jal)*twin_frac(jal1)*
     &                 fobs_l(jc)*fobs_l(jc1)*
     &                 (aniso_l(jc)*aniso_l(jc1))**2
               enddo
            enddo
         enddo
c         write(*,*)np,d2f(1:np,1:np),fmax(1:2,block_2_asym(c_s:c_f))

         call calc_inv_determinant(np,d2f(1:np,1:np),
     &        d2f_inv(1:np,1:np),det0)
         v1(1:np) = matmul(d2f_inv(1:np,1:np),df(1:np))
         v0 = 0.5*dot_product(v1(1:np),df(1:np))
         jc = 0
         do j=c_s,c_f
            jc = jc + 1
            c_n = block_2_asym(j)
            if(fmax(1,c_n).le.1.0e-4) then
               fexpected(1:2,c_n) = 0.0
            else
               df_j(1:np) = df(1:np)
               d2f_j(1:np,1:np) = d2f(1:np,1:np)
               sigma1 = sigma*epsls(c_n)*(1+centrs(c_n))
               a0 = 2.0*fc(jc)/sigma1
               xx = 2.0*fmax(1,c_n)*fc(jc)/sigma1
               if(centrs(c_n).eq.0) then
                  if(xx.gt.eps_l) then
                     fom = sim(xx)
                     fomprime = (1.0-fom/xx-fom**2)*a0
                     fom2prime = 
     &                    ((-fomprime*xx+fom)/xx**2-
     &                    2.0*fomprime*fom)*a0**2
                  else
                     fom = 0.0
                     fomprime = 0.5*a0
                     fom2prime = 0.0
                  endif
               else
                  fom=tanh(xx)
                  fomprime = (1-fom**2)*a0
                  fom2prime = -2.0*fom*fomprime*a0**2
               endif
               df_j(jc) = df_j(jc) - 1.0/fmax(1,c_n) - fomprime
               d2f_j(jc,jc) = d2f_j(jc,jc) + 
     &              1.0/fmax(1,c_n)**2 - fom2prime
c            write(*,*)centrs(c_n),fmax(1,c_n),fc(jc),fomprime,fom,a0,
c     &           xx,np,d2f(1:np,1:np),d2f_j(1:np,1:np)
               call calc_inv_determinant(np,d2f_j(1:np,1:np),
     &              d2f_inv(1:np,1:np),det1)
               v1(1:np) = matmul(d2f_inv(1:np,1:np),df_j(1:np))
               v01 = 0.5*dot_product(v1(1:np),df_j(1:np))
c               if(centrs(c_n).eq.1) then
c                  write(*,*)d2f(1:np,1:np),d2f_j(1:np,1:np)
c               write(*,*)'1 ',fexpected(1:2,c_n),centrs(c_n),df_j(1:np)
c               write(*,*)fmax(1,c_n),fc(jc)
c               endif
               cc = max(-3.0,min(3.0,v01-v0+0.5*(log(det1)-log(det0))))
               fexpected(1:2,c_n) = fexpected(1:2,c_n)*exp(cc)
c               if(centrs(c_n).eq.1) then
c               write(*,*)'2 ',fexpected(1:2,c_n),v01,v0,det1,det0
c               endif
            endif
         enddo
      enddo
c      stop
c
      deallocate(v1)
      deallocate(df)
      deallocate(df_j)
c      deallocate(shift)
      deallocate(d2f)
      deallocate(d2f_j)
      deallocate(d2f_inv)
      deallocate(obs_bins)
      deallocate(epsls)
      deallocate(centrs)
      deallocate(aniso_scales)
      return
      end
c
      subroutine derivs_dfdf_twin_ls(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,
     &     dfda,d2fda2,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
      include 'mtz_things.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
      real fmax(2,nasym)
      real dfda(2,nasym),d2fda2(nasym)
      integer ierr
c
c---  locals
      integer o_s,o_f,c_s,c_f,o_c_s,o_c_f,c_n
      integer jal,jc,np
      integer i,j,k,ip,ibin,ndens,nref_all
      real sc_p(48),sigma,sigma1,ss
      real phase,yo
      real w_h,waver
      real del1,ddel,Ict0,fct,fh1,fh2
c
      integer, allocatable :: epsls(:)
      integer, allocatable :: centrs(:)
      integer, allocatable :: obs_bins(:)
      real, allocatable ::  fexpected(:,:)
      real, allocatable :: fomcalc(:)
c
c
      integer block_2_asym_l(48)
      real a_all(2,48),Ic(48),epcent(48)
      real dIct_dAB(2,48)
c      integer 
      real lstlsq_r
      external lstlsq_r
c
c---  testing
      real fc0,fc1,del0,rfac0,rfac1
      real Floc,sigmaF
c
c---  body
      allocate(fexpected(2,nasym))
      allocate(fomcalc(nasym))
c      call find_fexpected_ml(
c     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
c     &     num_blocks,block_start,ref_2_asym_start,
c     &     nobs,iobs,obs_start,
c     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
c     &     num_asym_ref,block_2_asym,fmax,fexpected,fomcalc,
c     &     ierr)
c
      allocate(obs_bins(num_blocks))
      call get_obs_bins(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
c
      allocate(epsls(nasym))
      allocate(centrs(nasym))
      call get_eps_centrs(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     epsls,centrs,
     &     ierr)
c
      dfda(1:2,1:nasym) = 0.0
      d2fda2(1:nasym) = 0.0
      waver = 0.0
      nref_all = 0
      ndens = 1

      del0 = 0.0
      del1 = 0.0
      rfac0 = 0.0
      rfac1 = 0.0
      scale_ml(1:nbin_ml,1:(npart_act+1))=1.0
      do i=1,num_blocks
         ibin = obs_bins(i)
         sigma = sigma_ml(ibin)
c         sigma = 1.0
         if(freer(i).ne.0) then
            o_s = block_start(i)+1 
            o_f = block_start(i+1)
            c_s = ref_2_asym_start(i)+1
            c_f = ref_2_asym_start(i+1)
            jc = 0
            np = c_f - c_s + 1
            do j=c_s,c_f
               jc = jc + 1
               c_n = block_2_asym(j)
               a_all(1:2,jc) = scale_ml(ibin,1)*fcalc(1:2,c_n)
               ss = lstlsq_r(1,hkl_asym(1:3,c_n))
               sc_p(jc)  = scale_ls_over*exp(-b_ls_over*ss)*
     &              (1.0-scale_ls_bulk*exp(-b_ls_bulk*ss))
               sc_p(jc) = sqrt(sc_p(jc))
c               sc_p(jc) = sqrt(sc_p(jc))*scale_ml(ibin,1)
               do ip=1,npart_act
c                  a_all(1,jc)=
c     &                 a_all(1,jc)+scale_ml(ibin,ip+1)*fpart(ip,1,c_n)
c                  a_all(2,jc)=
c     &                 a_all(2,jc)+scale_ml(ibin,ip+1)*fpart(ip,2,c_n)
                  a_all(1,jc)= a_all(1,jc)+fpart(ip,1,c_n)
                  a_all(2,jc)= a_all(2,jc)+fpart(ip,2,c_n)
               enddo
               Ic(jc) = a_all(1,jc)**2+a_all(2,jc)**2
               epcent(jc) = epsls(c_n)/(2-centrs(c_n))
            enddo
c
            do j=o_s,o_f
               Ict0 = 0.0
               o_c_s = obs_start(j)+1
               o_c_f = obs_start(j+1)
               dIct_dAB(1:2,1:np) = 0.0
               sigma1 = 0.0
               do k=o_c_s,o_c_f
                  jc = ref_2_asym(k)
                  jal = comp_numb(k)
                  Ict0 = Ict0 + twin_frac(jal)*Ic(jc)
                  dIct_dAB(1:2,jc) = dIct_dAB(1:2,jc) + 
     &                 2.0*twin_frac(jal)*a_all(1:2,jc)
                  sigma1 = sigma1 + twin_frac(jal)**2*Ic(jc)*epcent(jc)
               enddo

               sigma1 = sigma1*sigma/Ict0
               Floc = sqrt(max(0.0,iobs(1,j)))
               sigmaF = iobs(2,j)/(sqrt(Floc**2+iobs(2,j))+Floc)
               sigma1 = sigmaF**2 + sigma1
               sigma1 = 10.0*sigma1
               fct = sqrt(Ict0)
               fh1 = Ict0-max(-3.0*iobs(2,j),iobs(1,j))
               fh2 = fct + sqrt(max(0.001*iobs(2,j),iobs(1,j)))
               del1 = fh1/fh2
               ddel = 1/fh2-0.5*fh1/(fct*fh2**2)
               dIct_dAB(1:2,1:np) = ddel*dIct_dAB(1:2,1:np)
               jc = 0
c               sigma1 = 1.0
               do k=c_s,c_f
                  jc = jc + 1
                  c_n = block_2_asym(k)
                  dfda(1:2,c_n) = dfda(1:2,c_n) + 
     &                 del1*dIct_dAB(1:2,jc)/sigma1*sc_p(jc)
                  d2fda2(c_n) = d2fda2(c_n) + 
     &                 (dIct_dAB(1,jc)**2+
     &                  dIct_dAB(2,jc)**2)/sigma1*sc_p(jc)**2
               enddo
            enddo
         endif
      enddo
      d2fda2(1:nasym) = 2.0*d2fda2(1:nasym)*ifactor_cc*nsmult

      deallocate(epsls)
      deallocate(centrs)
      deallocate(fexpected)
      deallocate(obs_bins)
      deallocate(fomcalc)
      return
      end
c
      subroutine derivs_dfdf_twin(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,
     &     dfda,d2fda2,
     &     ierr)
      implicit none
c
c---Initialise ml parameters
      include 'celsym.fh'
      include 'agreem.fh'
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
      include 'mtz_things.fh'
c
      integer nasym,npart_act
      integer hkl_asym(3,nasym)
      real    fcalc(2,nasym),fpart(npart_act,2,nasym)
      integer num_blocks
      integer block_start(num_blocks+1),ref_2_asym_start(num_blocks+1)
      integer freer(num_blocks)
      integer nobs
      integer obs_start(nobs+1)
      real    iobs(2,nobs)
      integer ncomp
      integer comp_numb(ncomp),ref_2_asym(ncomp),ref_2_symm(ncomp)
      integer num_asym_ref
      integer block_2_asym(num_asym_ref)   
      real fmax(2,nasym)
      real dfda(2,nasym),d2fda2(nasym)
      integer ierr
c
c---  locals
      integer o_s,o_f,c_s,c_f,o_c_s,o_c_f,c_n,c_1
      integer i,j,ip,ibin,ndens,nref_all,i_inter
      real sc_p,sigma,sigma1,ss,stl_c,scale_now
      real phase,yo
      real w_h,waver
      real a_all(2)
c
      integer, allocatable :: epsls(:)
      integer, allocatable :: centrs(:)
      integer, allocatable :: obs_bins(:)
      real, allocatable ::  fexpected(:,:)
      real, allocatable :: fomcalc(:)
c
      integer nzero
c
      real lstlsq_r
      external lstlsq_r
c
c---  testing
      real fc0,fc1,del0,del1,rfac0,rfac1
c
c---  body
      allocate(fexpected(2,nasym))
      allocate(fomcalc(nasym))
c      call find_max_ml_twin(
c     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
c     &     num_blocks,block_start,ref_2_asym_start,
c     &     nobs,iobs,obs_start,
c     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
c     &     num_asym_ref,block_2_asym,fmax,
c     &     ierr)

      call find_fexpected_ml(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,fexpected,fomcalc,
     &     ierr)
      nzero = 0
c      do i=1,nasym
c         write(*,*)fomcalc(i),fmax(1:2,i),fexpected(1:2,i)
c         if(fomcalc(i).le.0.0) nzero = nzero + 1
c      enddo
c      write(*,*)nzero
c      stop
c
      allocate(obs_bins(num_blocks))
      call get_obs_bins(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     obs_bins,
     &     ierr)
c
      allocate(epsls(nasym))
      allocate(centrs(nasym))
      call get_eps_centrs(
     &     nasym,hkl_asym,freer,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     epsls,centrs,
     &     ierr)
c
      dfda(1:2,1:nasym) = 0.0
      d2fda2(1:nasym) = 0.0
      waver = 0.0
      nref_all = 0
      ndens = 1

      del0 = 0.0
      del1 = 0.0
      rfac0 = 0.0
      rfac1 = 0.0
c      scale_ml(1:nbin_ml,1:(npart_act+1))=1.0
c      open(24)
c      do i=1,100
c         write(*,*)fcalc(1:2,i),fpart(1,1:2,i)
c      enddo
c      write(*,*)'To there'
      i_inter = -1
c      open(24)
c      write(*,*)nbin_ml
c      stop
      do i=1,num_blocks
         ibin = obs_bins(i)
         sigma = sigma_ml(ibin)
         o_s = block_start(i)+1 
         o_f = block_start(i+1)
         c_s = ref_2_asym_start(i)+1
         c_f = ref_2_asym_start(i+1)
         c_1 = block_2_asym(c_s)
         ss = lstlsq_r(1,hkl_asym(1:3,c_1))
         stl_c = 2.0*sqrt(ss)
c         write(*,*)ibin,2.0*sqrt(ss),sminb_ml(ibin),smaxb_ml(ibin)
c         sigma = 1.0
         call linter_value2(nbin_ml,smeanb_ml,sigma_ml,stl_c,
     &        i_inter,sigma)
         if(freer(i).ne.0) then

            do j=c_s,c_f
               c_n = block_2_asym(j)
               if(fmax(1,c_n).gt.0.0) then
                  call linter_value2(nbin_ml,smeanb_ml,scale_ml(1,1),
     &                 stl_c,i_inter,scale_now)
c                  scale_now = scale_ml(ibin,1)
                  a_all(1) = scale_now*fcalc(1,c_n)
                  a_all(2) = scale_now*fcalc(2,c_n)
                  ss = lstlsq_r(1,hkl_asym(1:3,c_n))
                  sc_p  = scale_ls_over*exp(-b_ls_over*ss)*
     &                 (1.0-scale_ls_bulk*exp(-b_ls_bulk*ss))
c                  sc_p = 1.0
                  sc_p = sqrt(sc_p)*scale_now
c                  sc_p = 1.0
                  do ip=1,npart_act
                     call linter_value2(nbin_ml,smeanb_ml,
     &                    scale_ml(1,ip+1),
     &                    stl_c,i_inter,scale_now)
c                     scale_now = scale_ml(ibin,ip+1)
                     a_all(1)=a_all(1)+scale_now*fpart(ip,1,c_n)
                     a_all(2)=a_all(2)+scale_now*fpart(ip,2,c_n)
                  enddo
c                  write(24,*)ss,sigma
                  sigma1 =  
     &                 sigma*epsls(c_n)*(1+centrs(c_n))
c     &                 +2.0*fmax(2,c_n)**2
                  fc0 = sqrt(a_all(1)**2+a_all(2)**2)
                  del0 = del0 + abs(fc0-fmax(1,c_n))
                  rfac0 = rfac0 + abs(fmax(1,c_n))
                  fc1 = sqrt(fexpected(1,c_n)**2+fexpected(2,c_n)**2)
c                  if(fc1.le.0.0.or.fc0.le.0.0) then
c                     write(*,*)'Problem ',ibin,sigma,fc1,fc0
c                     stop
c                  endif
                  del1 = del1 + abs(fc0-fc1)
                  rfac1 = rfac1 + abs(fc1)
                  dfda(1:2,c_n) = (a_all(1:2)-fexpected(1:2,c_n))/sigma1
                  dfda(1:2,c_n) = sc_p*dfda(1:2,c_n)
                  d2fda2(c_n) = 1.0/sigma1*sc_p**2
                  yo = fmax(1,c_n)
                  phase  = 0.0
                  if(a_all(1)**2+a_all(2)**2.gt.0.0) 
     &                 phase = atan2(a_all(2),a_all(1))
                  call integrate_info(ndens,centrs(c_n),sigma1,yo,
     &                 a_all(1),a_all(2),c_n,phase,w_h)
                  waver = waver + w_h
                  nref_all = nref_all + 1
               endif
            enddo
         endif
      enddo
c      close(24)
      waver = waver/nref_all
      d2fda2(1:nasym) = 2.0*waver*d2fda2(1:nasym)*ifactor_cc*nsmult

      deallocate(epsls)
      deallocate(centrs)
      deallocate(fexpected)
      deallocate(obs_bins)
      deallocate(fomcalc)
c      stop
      return
      end
