C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
      SUBROUTINE PRE_DESCR(MMDOC,LIST,CHECK,COOR,SRCH
     *            ,NAME,NMNEW,NEW_FLAG_OUT,LIB2,KERR,IERR)
C ----------------------------------------------------------
C -P- PRE_DESCR - define/correct res_name, res_type 
C                                (use list of modifications)   
C                 create new description of monomer which can not be found
C                                in mon_lib.cif ( type of new monomers is  
C                                                            non-polymer )
C ----
C             NAME  - name of program ( 'makecif' or 'libcheck' )
C     output:
C             NMNEW    - number of new monomers
C             KERR = 2 - number of monomer in the library = 0
C             KERR = 0 and IERR = 0 - OK
C ----
C
C     'atom_com.fh' only in PRE_DESCR
C
C ---
C     PRE_DESCR - SSET_FUSE
C               - CCHKMON                - CP_MLIB
C               - SET_CTYPE(table)
C               - CHECK_ANAME
C               - LPUT_NEW
C               - CREAT_NEW(MODE='COOR') -
C               - CPL_MLIB
C                 
C -I-
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'lib_com.fh'
C -----------------------------------------------------------
      INTEGER   MDOC,IERR
      CHARACTER NAME*(*)
C ----------------------------------------------------------------
      CHARACTER LINE*256
      CHARACTER CH12*12,NEW_FLAG*1,MOD_FLG*1,LIST*1,RES*5,CHAIN*4
      CHARACTER MON*8,AMON*8,MOD*8,TYPE*16,CORR_MON*8,CORR_TYPE*16
      CHARACTER CTYPE*4,MODE*4,ASYMB*4,ALT_NAME*4,MON_NEW*8,COOR*1
      CHARACTER MODT*8,MON_OLD*8,MTYPE*1,CHECK*1,DNEW*1,ELEMENT*4
      CHARACTER CH8*8,SRCH*1,EL_D*4,EL_F*4,ASYMB_INP*4,ALT_FOR_COPY*1
      CHARACTER NEW_FLAG_OUT*1
C==================================================================
      IERR = 0

      MDOC = MMDOC
      MD   = -ABS(MDOC)-1
      M    = 99

      IF(LIST.EQ.'S') THEN
        MDOC = 999
        MD   = 999
      ENDIF

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDoc,' --- PRE_DESCR --- ')
        CALL PRINT_INFO_TEST(MDoc)
      ENDIF
C --------
      IF(N_ATOM.LE.0.OR.N_GROUP.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR: number of atoms = 0...')
        IERR=1
        RETURN
      ENDIF 
C---------
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDoc,' --- PRE_MONOM_LIST --- ')
      ENDIF
      CALL PRE_MONOM_LIST(MDOC,LIST,IERR)
      IF(IERR.NE.0) RETURN
C --------
      JERR     = 0
      KERR     = 0
      NMUSE    = 0
      NMNEW    = 0
      DNEW     = 'N'
      NEW_FLAG = 'N'
      TYPE     = '?'
      AMON     = '   '
      MOD      = ' '
      MODE     = ' '
      NEW_FLAG_OUT = 'N'
C ----
      CALL SET_LINK_CORR
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDoc,' --- after set_link_corr --- ')
      ENDIF
C ----
      DO IG=1,N_GROUP   

        IRS     = IRES_FIRST(IG)
        NRES    = NRES_CHAIN(IG)
        IRF     = IRS + NRES - 1
C ===
        ITS      = ITERM_S_TYPE(IG)
        ITF      = ITERM_F_TYPE(IG)
        IRS_TREE = IRES_START_TREE(IG)
        IRF_TREE = IRES_END_TREE  (IG)
c ===
        DO IR=IRS,IRF

          IRES  = IRES_SERIAL(IR)
          NATMR = NATM_RES   (IR)
          IAS   = IRATM_FIRST(IR)
          IAF   = IAS + NATMR - 1
          CH12  = RES_NUM_PDB(IR)
          RES   = CH12(3:7)
          CHAIN = CH12(8:11)

          NMON_CRT_NEW = 0


 300      CONTINUE

          NEW_FLAG = 'N'

          JERR     = 0
          KERR     = 0

          CR_RNAME = RES_NAME(IR)
          MON      = CR_RNAME

          MOD_FLG  = 'N'
          IF(MOD_N.GT.0) THEN
            DO IM = 1,MOD_N
              IF(MOD_IRES    (IM).EQ.IR  .AND.
     *           MOD_ICHN    (IM).EQ.IG  .AND.
     *           MOD_RNAM_NEW(IM).EQ.MON .AND.
     *           MOD_ID      (IM).EQ.'RENAME') THEN
                MON           = MOD_RNAM(IM)
                MOD_FLG       = 'Y'
                MOD_FLAG (IR) = 'Y'
                GO TO 200
              ENDIF
            ENDDO
          ENDIF
          IM = 0
 200      CONTINUE
          MON_OLD = MON
          CALL CHECK_MON_LIB(MDOC,MON,CH12
     *     ,AMON,MOD,NEW_FLAG,NMUSE,NMNEW,TYPE,LIST,JERR) 
C         JERR = 1  - not found ; 
C              = 2 - number of monomer in the library = 0
          IF(JERR.EQ.2) THEN
            KERR = JERR
            RETURN
          ENDIF
          JERR = 0

          IF(MON.NE.MON_OLD) THEN
            IF(MOD_FLG.EQ.'N') THEN
              MOD   = 'RENAME'
              MTYPE = 'N'  
              IA    = 0
              CALL PUT_M_TABL(MDOC,MOD,IG,IR,IA,MON,MTYPE,IERR)
              IF(IERR.NE.0) RETURN
              MOD_FLG       = 'Y'
              MOD_FLAG (IR) = 'Y'
              IF(MOD_N.GT.0) THEN
                DO IM = 1,MOD_N
                  IF(MOD_IRES   (IM).EQ.IR  .AND.
     *               MOD_ICHN   (IM).EQ.IG  .AND.
     *               MOD_RNAM   (IM).EQ.MON .AND.
     *               MOD_ID     (IM).EQ.'RENAME') THEN
                    GO TO 210
                  ENDIF
                ENDDO
              ENDIF
              IM = 0
 210          CONTINUE
            ELSE
              MOD_RNAM(IM)  = MON
            ENDIF
          ENDIF

          IF(IM.LE.0) THEN
            MOD_FLG       = 'N'
            MOD_FLAG (IR) = 'N'
          ENDIF 

          CALL GET_INI_RES_TYPE(MDOC,LINE,MON,IT,IERR)
          IF(IRES_TYPE(IR).LE.2) IRES_TYPE(IR) = IT
          IT = IRES_TYPE(IR)
          IF(IT.EQ.3.OR.IT.EQ.5.OR.IT.EQ.7.OR.IT.EQ.8) THEN
            CALL LENSTR_BL(L1L_TYPE,LEN) 
            DO ITT=1,N_RES_TYPE
              TYPE = RES_TYPE(ITT)
              IF(L1L_TYPE(1:LEN).EQ.TYPE(1:LEN)) GO TO 801
            ENDDO
            ITT = 1
 801        CONTINUE
            IF(ITT.EQ.4.OR.ITT.EQ.6.OR.ITT.EQ.7.OR.ITT.EQ.8) THEN
              IRES_TYPE(IR) = ITT
              IT = ITT
            ENDIF
          ENDIF

          IF(LIST.EQ.'T') THEN
            WRITE(LINE,*) '-1',IG,IR,RES_NAME(IR),MON,IT,MOD_FLG,MOD
            CALL MSGDOC(MDoc,LINE)
          ENDIF

          IF(IRES_TYPE(IR).EQ.6) THEN
C           RNA          
            IF(MOD_FLG.EQ.'N') THEN
              MON             = RES_NAME(IR) 
              IF(MON(2:2).EQ.'d'.OR.MON(2:2).EQ.' ') THEN
                MON(2:2)      = 'r'
                RES_NAME(IR)  = MON
C                IRES_TYPE(IR) = 6
              ENDIF
            ELSE
              MON             =  MOD_RNAM(IM) 
              IF((MON(2:2).EQ.'d'.OR.MON(2:2).EQ.' ').AND.
     *                  MON(1:1).NE.'T'.AND.MON(1:2).NE.'+T') THEN
                MON(2:2)      = 'r'
                MOD_RNAM(IM)  = MON
C                IRES_TYPE(IR) = 6
              ENDIF
            ENDIF
 
          ELSE IF(IRES_TYPE(IR).EQ.5) THEN
C           DNA
            IF(MOD_FLG.EQ.'N') THEN
              MON             = RES_NAME(IR) 
              IF((MON(2:2).EQ.'r'.OR.MON(2:2).EQ.' ').AND.
     *                                      MON(1:1).NE.'U') THEN
                MON(2:2)      = 'd'
                RES_NAME(IR)  = MON
              ENDIF
            ELSE
              MON             =  MOD_RNAM(IM) 
              IF((MON(2:2).EQ.'r'.OR.MON(2:2).EQ.' ').AND.
     *                                      MON(1:1).NE.'U') THEN
                MON(2:2)      = 'd'
                MOD_RNAM(IM)  = MON
              ENDIF
            ENDIF
          ENDIF

          IF(LIST.EQ.'T') THEN
            WRITE(LINE,*) '-2',IG,IR,RES_NAME(IR),MON,IT,MOD_FLG,MOD
            CALL MSGDOC(MDoc,LINE)
          ENDIF

          IF(IRES_TYPE(IR).EQ.5) THEN
C           DNA
            DO IA=IAS,IAF
              CR_ANAME = ATM_NAME (IA)
              CALL CHECK_ANAME(MON,AMON,MOD,CR_ANAME,ALT_NAME)
              IF(CR_ANAME.EQ.'O2* '.or.
     &           cr_aname.eq.'O2'' ') THEN
c                IF(MON.NE.'T'.AND.MON.NE.'+T'.AND.MON.NE.'Td') THEN
                  IF(MON(2:2).EQ.'d') MON(2:2) = 'r'
                  IRES_TYPE(IR) = 6
c                ENDIF
                IF(MOD_FLG.EQ.'N') THEN
c                  MON           = RES_NAME(IR) 
                  RES_NAME(IR)  = MON
                ELSE
c                  MON           = MOD_RNAM(IM) 
                  MOD_RNAM(IM)  = MON
                ENDIF
                GO TO 500
              ENDIF
            ENDDO
 500        CONTINUE

            IF(LIST.EQ.'T') THEN
              WRITE(LINE,*) '-3',IG,IR,RES_NAME(IR),MON,IT,MOD_FLG,MOD
              CALL MSGDOC(MDoc,LINE)
            ENDIF

            IF(MOD_FLG.EQ.'N'.AND.MON.NE.MON_OLD) THEN
              MOD   = 'RENAME'
              MTYPE = 'N'  
              IA    = 0
              CALL PUT_M_TABL(MDOC,MOD,IG,IR,IA,MON,MTYPE,IERR)
              IF(IERR.NE.0) RETURN
              MOD_FLG       = 'Y'
              MOD_FLAG (IR) = 'Y'
            ENDIF

            CALL CHECK_MON_LIB(MDOC,MON,CH12
     *       ,AMON,MOD,NEW_FLAG,NMUSE,NMNEW,TYPE,LIST,JERR) 
C           JERR = 1  - not found ; 
C                = 2 - number of monomer in the library = 0
            IF(JERR.EQ.2) THEN
              KERR = JERR
              RETURN
            ENDIF
            JERR=0

          ELSE IF(IRES_TYPE(IR).EQ.6) THEN
C           RNA
            CALL CHECK_MON_LIB(MDOC,MON,CH12
     *       ,AMON,MOD,NEW_FLAG,NMUSE,NMNEW,TYPE,LIST,JERR) 
C           JERR = 1  - not found ; 
C                = 2 - number of monomer in the library = 0
            IF(JERR.EQ.2) THEN
              KERR = JERR
              RETURN
            ENDIF
            JERR=0

          ENDIF

          DO IA=IAS,IAF
            CR_ANAME = ATM_NAME (IA)
            CALL CHECK_ANAME(MON,AMON,MOD,CR_ANAME,ALT_NAME)
            ATM_NAME(IA) = CR_ANAME
          ENDDO

C     check unique atom names
          NA =IAF-IAS+1
          IF(NA.GT.1) THEN
            DO IA=IAS,IAF-1
            DO JA=IA+1,IAF
              IF((ATM_NAME(IA).EQ.ATM_NAME(JA)).AND.
     *           (ID_ALT(IA)  .EQ.ID_ALT(JA)  )     ) THEN 
                LINE = ' ERROR : '//MON//
     *          ' : duplicated atom_name : "'//ATM_NAME(IA)//'".'
                CALL MSGERR(MDOC,LINE)
                LINE = '         chain: '//RES_NUM_PDB(IR)(8:11)//
     *                 ' residue: '//RES_NUM_PDB(IR)(3:7)
                CALL MSGERR(MDOC,LINE)
                IERR = 1
              ENDIF           
            ENDDO
            ENDDO
            IF(IERR.NE.0) RETURN
          ENDIF
          CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITT,IERR)
          IF(NRES.LE.1) THEN
            IF(ITT.EQ.3) THEN
              ITERM_S_TYPE(IG) = 2
              ITERM_F_TYPE(IG) = 2
              ITS      = ITERM_S_TYPE(IG)
              ITF      = ITERM_F_TYPE(IG)
            ELSE IF(ITT.EQ.5) THEN
              ITERM_S_TYPE(IG) = 4
              ITERM_F_TYPE(IG) = 4
              ITS      = ITERM_S_TYPE(IG)
              ITF      = ITERM_F_TYPE(IG)
            ENDIF
          ENDIF

          CALL GET_ALT_FOR_COPY(MDOC,IAS,IAF,ALT_FOR_COPY,IERR)

          IF(LIST.EQ.'T') THEN
            WRITE(LINE,*) 'GET_ALT_FOR_COPY:',ALT_FOR_COPY,';'
            CALL MSGDOC(MDOC,LINE)
          ENDIF
          DO IA=IAS,IAF
            INSF      = ID_SF    (IA)  
            ASYMB     = CS_ATYPE (INSF)      
            ASYMB_INP = ASYMB
            CALL SET_CTYPE(ASYMB,CTYPE)
            CR_ANAME = ATM_NAME (IA)
            CR_ANAME_INP = ATM_NAME_INP(IA)
            ST_CHEM  = ATM_CHEM(IA)
            CR_ATYPE = CTYPE(1:1)
            CR_ALT   = ID_ALT   (IA) 
            CR_SEG   = SEG_ID   (IA) 
            CR_CORR  = ID_CORR  (IA) 
            IF(ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN 
              CR_XYZ(1)= XYZ_CRD  (1,IA)
              CR_XYZ(2)= XYZ_CRD  (2,IA)
              CR_XYZ(3)= XYZ_CRD  (3,IA)
              CR_ANAME = ATM_NAME (IA)
              CR_ASYMB = ASYMB
              CR_SF_ID = INSF
              CR_OCC   = OCCUP    (IA)
              CALL LPUT_NEW(MDOC,LIST,ALT_FOR_COPY,ITT,IERR)
              IF(IERR.NE.0) RETURN
            ENDIF
          ENDDO

          IF(LIST.EQ.'T') THEN
            WRITE(LINE,*) 'NEW_FLAG:',NEW_FLAG,IG,IR,MON,check
            CALL MSGDOC(MDOC,LINE)
            WRITE(LINE,*) 'C1_NATOM:',C1_NATOM
            CALL MSGDOC(MDOC,LINE)
          ENDIF
          IF(C1_NATOM.GT.0) THEN
            CALL COPYC2(MDOC,IERR)
            IF(IERR.NE.0) RETURN
          ELSE

          ENDIF  
C
C         new_flag = n/m & mon  ;  new_flag = Y and l1l_mname = c1_rname = mon
C
c --
          IF(CHECK.EQ.'0'.AND.NEW_FLAG.EQ.'Y') THEN 
C           no global_search, create new
            MON_NEW = ' ' 

          ELSE IF(NEW_FLAG.EQ.'Y') THEN
C           global_search before and (?) to create new
            MON_NEW = MON

          ELSE IF(NEW_FLAG.NE.'Y') THEN
C           chechk list of atoms /C1(crd) and L1(lib)/ 
            MON_NEW = MON 
C           CALL GET_STANDARD_RES_TYPE(MDOC,LINE,MON,ITT,IERR)
C --- 03.06.03
            CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITT,IERR)
            IF(LIST.EQ.'T') THEN
              write(*,*) ' lib2,lb_pass,itt::',lib2,lb_pass,itt
              write(*,*) ' itf,its::',itf,its
            ENDIF
C            
C ---
            IF(CHECK.NE.'0') THEN 

            IF(((ITT.NE. 5.AND.ITT.NE.6.AND.
     *           ITT.NE. 7.AND.ITT.NE.8.AND.
     *           ITT.NE. 3.AND.ITT.NE.4.AND.
     *           ITT.NE.10.AND.ITT.NE.9     ).AND.CHECK.EQ.'N').OR.
     *                                            CHECK.EQ.'Y')THEN
              IF(IR.EQ.IRS_TREE) THEN
                IF(ITS.GT.1.AND.ITS.LE.N_STERM_TYPE) THEN
                  MODT = TERM_S_TYPE(ITS)
                  IF(LIST.EQ.'T') THEN
                    write(*,*) '===>',modt
                  ENDIF
                  CALL MODIF(MDOC,MODT,IERR)
                  IERR=0
                ENDIF
              ENDIF
              IF(IR.EQ.IRF_TREE) THEN
                IF(ITF.GT.1.AND.ITF.LE.N_FTERM_TYPE) THEN
                  MODT = TERM_F_TYPE(ITF)
                  IF(LIST.EQ.'T') THEN
                    write(*,*) '===>',modt
                  ENDIF
                  CALL MODIF(MDOC,MODT,IERR)
                  IERR=0
                ENDIF
              ENDIF

              IF(MOD_N.GT.0) THEN      
                DO I=1,MOD_N
                  MC  = MOD_ICHN(I)
                  MR  = MOD_IRES(I)
                  MOD = MOD_ID  (I)
                  IF(IR.EQ.MR.AND.IG.EQ.MC) THEN
                    CALL MODIF(MDOC,MOD,IERR)
                    IF(IERR.EQ.2) THEN
                      IERR=0
                    ENDIF
                    IF(IERR.NE.0) RETURN
                  ENDIF
                ENDDO
              ENDIF

              IF(LIST.EQ.'T') THEN
                WRITE(LINE,*) 
     *          '--before check_cmp_mon5:',MON_NEW,';',IERR,it
                CALL MSGERR(MDOC,LINE)
              ENDIF
C 
C             new_flag = N/M , mon_new = mon
C
              CALL CHECK_CMP_MON5(MDOC,LIST,CHECK,IG,IR,IAS
     *                      ,NMON_CRT_NEW,MON_NEW,NEW_FLAG,IERR)
              IF(IERR.NE.0) IERR = 0
C
C             create new for: MON_NEW  = MONOMER_NEW (new_name)= in C1,L1 
C                             NEW_FLAG = 'Y' 
C                             then MON_NEW = ' '            
C             else
C                   NEW_FLAG = N/M , mon_new = mon  
C             
              IF(LIST.EQ.'T') THEN
                WRITE(LINE,*) 
     *          '--after check_cmp_mon5:',MON_NEW,';',NEW_FLAG,';',IERR
                CALL MSGERR(MDOC,LINE)
              ENDIF

              IF(NEW_FLAG.EQ.'Y') THEN 
                WRITE(LINE,'(3A)')' WARNING : ',MON,
     *         ' : program can not match library description....'
                CALL MSGERR(MDOC,LINE)
                MON_NEW = ' '
              ENDIF

C           else
C             NEW_FLAG.NE.'Y' &  MON_NEW = MON              
C             no global searching , create new if NEW_FLAG = 'M'

            ENDIF
            ENDIF

          ENDIF          

C -- 6.04.03
          IF(NEW_FLAG.EQ.'Y') THEN
            LIB2    = 1 
            LB_PASS = 0
          ENDIF
C --
          IF(NEW_FLAG.NE.'N') THEN
            IF(NEW_FLAG.EQ.'Y') THEN
              NEW_FLAG_OUT = NEW_FLAG
            ELSE
              IF(NEW_FLAG_OUT.NE.'Y') NEW_FLAG_OUT = NEW_FLAG 
            ENDIF 
          ENDIF
 
          IF(NEW_FLAG.EQ.'Y'.AND.MON_NEW(1:1).NE.' ') THEN

            IF(LIST.EQ.'T') THEN
              LINE = '--before global search:'//MON_NEW//';'//
     *        MON//';'//NEW_FLAG//';'
              CALL MSGERR(MDOC,LINE)
            ENDIF

            CALL GLOBAL_SEARCH_NEW(MDOC,LIST,MON,MON_NEW,NEW_FLAG,SRCH
     *        ,NMON_CRT_NEW,IG,IR,IAS,IERR)
c            stop
c            NEW_FLAG = 'Y'
c            MON_NEW  = ' '
            IF(IERR.NE.0) RETURN
C
C             NEW_FLAG     'Y'        'C'             N/M
C             MON_NEW      ' '       new_name       mon_iso (from srch)
C                      create new     --  createnew if 'M' ---
c
            IF(LIST.EQ.'T') THEN
              LINE = '--after global search:'//MON_NEW//';'//
     *        MON//';'//NEW_FLAG//';'//L1L_PRSNT//';'
              CALL MSGERR(MDOC,LINE)
            ENDIF

            IF(NEW_FLAG.EQ.'C'.OR.NEW_FLAG.EQ.'G') THEN
              IF(L1L_PRSNT.EQ.'M') THEN
                NEW_FLAG = 'M'
              ELSE
                L1L_FUSE   = 'C'
                L1L_PRSNT  = '.'
                IF(NEW_FLAG.EQ.'C') CALL CPL_MLIB(MDOC,IERR)
                IF(IERR.NE.0) RETURN
                NEW_FLAG = 'N'
                NMNEW = NMNEW + 1
              ENDIF
            ENDIF
          ENDIF

C ----
          IF(MON_NEW.NE.MON.AND.MON_NEW(1:1).NE.' ') THEN
            MOD   = 'RENAME'
            MTYPE = 'N'  
            CALL PUT_M_TABL(M,MOD,IG,IR,IAS,MON_NEW,MTYPE,IERR)
            IF(IERR.NE.0) RETURN

            LINE = ' WARNING : residue: '//MON//' '//RES//' chain:'//
     *      CHAIN //' - rename' 
            CALL MSGDOC(MDOC,LINE)
            WRITE(LINE,
     *      '(''          "'',A,''" --> "'',A,''" '')')
     *      MON,MON_NEW
            CALL MSGDOC(MDOC,LINE)

            CALL LENSTR_BL(L1L_TYPE,LEN) 
            DO IT=1,N_RES_TYPE
              TYPE = RES_TYPE(IT)
              IF(L1L_TYPE(1:LEN).EQ.TYPE(1:LEN)) GO TO 820
            ENDDO
            IT = 1
 820        CONTINUE
            IRES_TYPE(IR) = IT
            MON = MON_NEW          
          ENDIF         

C         new atom name(C2) --> Atm_name 
C                              link, syn.
          IFIRST = 0
          DO IC=1,C1_NATOM
            IF(C2_ANAME(IC).NE.C1_ANAME(IC)) THEN
C              MMM = 99
C              IF(LIST.EQ.'T') MMM=MDOC
              CALL  PUT_SYNONYM_TO_LIST(MDOC,MON_NEW,IFIRST,RES,CHAIN
     *                ,C1_ANAME(IC),C2_ANAME(IC),DNEW,IERR)
C                           OLD        NEW
              CALL CHANGE_ATOM_IN_LINK_TAB(MDOC,IG,IR
     *                     ,C1_ANAME(IC),C2_ANAME(IC),IERR)
              DO IA=IAS,IAF
                IF(ATM_NAME(IA).EQ.C1_ANAME(IC)) THEN
                  ATM_NAME(IA) = C2_ANAME(IC)
                ENDIF
              ENDDO
            ENDIF
          ENDDO
          DO IC=1,C1_NATOM
            C1_ANAME(IC) = C2_ANAME(IC)
          ENDDO
          CALL COPYC1(MDOC,IERR)
          C1_RNAME = MON

          IF(L1L_PRSNT.EQ.'N') THEN
            MODE = ' '
            CALL COOR_CONN(MDOC,MODE,IERR)
          ENDIF
C ----          
c         CALL GET_STANDARD_RES_TYPE(MDOC,LINE,MON,ITT,IERR)
C --- 03.06.03
          CALL GET_INI_RES_TYPE(MDOC,LINE,MON,ITT,IERR)
C ---
          IF(LIST.EQ.'T') THEN
            WRITE(*,*) '-RES_TYPE,CHECK:',ITT,CHECK
          ENDIF
          IF(CHECK.NE.'0') THEN 
            IF(((ITT.NE. 5.AND.ITT.NE.6.AND.
     *           ITT.NE. 7.AND.ITT.NE.8.AND.
     *           ITT.NE. 3.AND.ITT.NE.4.AND.
     *           ITT.NE.10.AND.ITT.NE.9     ).AND.CHECK.EQ.'N').OR.
     *                                            CHECK.EQ.'Y')THEN
              CALL PRECHECK_L1_MON_DESCRIPTION(MDOC,LIST,IERR)
C             ierr 10  - add 'dummy' bonds    
C             ierr 100 - remove some bonds
C             ierr 1   - 
              IF(IERR.NE.0) THEN
                NEW_FLAG = 'M'
                IF(L1L_PRSNT.NE.'N') L1L_PRSNT = 'M'
                IERR = 0
              ENDIF
            ENDIF
          ENDIF

          IF(MON_NEW(1:1).EQ.' '.OR.NEW_FLAG.EQ.'M') THEN

            IF(COOR.EQ.'Y') MODE = 'TEST'
            VANGLE       = 0.0
            IF(LIST.EQ.'T') THEN
              LINE = '-- create new --'
              CALL MSGERR(MDOC,LINE)
            ENDIF

            CH8  = C1_RNAME
            LINE = '                   '//
     *      'program will create complete description for:'//CH8
            MDD = 0
            CALL MSGDOC(MDD,LINE)

            IF(L1L_PRSNT.NE.'N') THEN
              CALL GET_INI_RES_TYPE(MDOC,LINE,CH8,IT,IERR)
              IF(IERR.NE.0) RETURN
            ELSE
C             CALL CHECK_RES_TYPE_BY_ATOM_AND_BOND(MDOC,IT,IERR)
              IT = 1
              L1L_TYPE  =  RES_TYPE(IT) 
            ENDIF

           IF(LIST.EQ.'T') THEN
              WRITE(LINE,*) 
     *        '-- before create new:',it,l1a_natom,l1b_nbond
              CALL MSGERR(MDOC,LINE)
            ENDIF

            ITER = 0
            IF(IT.EQ.3.OR.IT.EQ.4) THEN
              MODT = 'AA-STAND'
              CALL MODIF(MDOC,MODT,IERR)
              IERR = 0
              ITER = 2
            ENDIF
            IF(IT.EQ.5.OR.IT.EQ.6) THEN
              MODT = 'NA-STAND'
              CALL MODIF(MDOC,MODT,IERR)
              IERR = 0
              ITER = 4
            ENDIF
            IF(ITER.GT.0) THEN
              MODT = TERM_S_TYPE(ITER)
              CALL MODIF(MDOC,MODT,IERR)
              IERR=0
              MODT = TERM_F_TYPE(ITER)
              CALL MODIF(MDOC,MODT,IERR)
              IERR=0
              CALL PRECHECK_L1_MON_DESCRIPTION(MDOC,LIST,IERR)
C               ierr 10  - add 'dummy' bonds    
C               ierr 100 - remove some bonds
C               ierr 1   - 
              IF(IERR.NE.0) THEN
                IERR = 0
              ENDIF 
            ENDIF

C            DO IA=1,L1A_NATOM
C              IF(L1A_COOR_FLAG(IA).NE.'Y') THEN
C                MODE = '.'
C                L1L_PRSNT = 'M'
C              ENDIF
C            ENDDO    

            MMM = MDOC
            IF(LB_PASS.EQ.1.AND.LIST.NE.'T'.AND.
     *         NAME.EQ.'refmac') MMM = 99
            CALL CREAT_NEW(MMM,LIST,MODE,C1_PNUM,NAME,VANGLE,IERR)
            IF(IERR.NE.0) RETURN
            CALL CPL_MLIB(MDOC,IERR)
            IF(IERR.NE.0) RETURN

            NMNEW = NMNEW + 1
C -- 6.04.03
            IF(LB_PASS.NE.1) THEN
c             NMNEW = NMNEW + 1 
              LIB2  = 1
            ENDIF
C --
            MON_NEW = L1L_MNAME

          ENDIF

C ---
          IF(MON_NEW.NE.MON.AND.MON_NEW(1:1).NE.' ') THEN
            MOD   = 'RENAME'
            MTYPE = 'N'  
            CALL PUT_M_TABL(M,MOD,IG,IR,IAS,MON_NEW,MTYPE,IERR)
            IF(IERR.NE.0) RETURN

            LINE = ' WARNING : residue: '//MON//' '//RES//' chain:'//
     *      CHAIN //' - rename' 
            CALL MSGDOC(MDOC,LINE)
            WRITE(LINE,
     *      '(''          "'',A,''" --> "'',A,''" '')')
     *      MON,MON_NEW
            CALL MSGDOC(MDOC,LINE)

C            CALL LENSTR_BL(L1L_TYPE,LEN) 
C            DO IT=1,N_RES_TYPE
C              TYPE = RES_TYPE(IT)
C              IF(L1L_TYPE(1:LEN).EQ.TYPE(1:LEN)) GO TO 810
C            ENDDO
C            IT = 1
C 810        CONTINUE
C            IRES_TYPE(IR) = IT
            MON = MON_NEW          
          ENDIF         


          CALL LENSTR_BL(L1L_TYPE,LEN) 
          DO IT=1,N_RES_TYPE
            TYPE = RES_TYPE(IT)
            IF(L1L_TYPE(1:LEN).EQ.TYPE(1:LEN)) GO TO 800
          ENDDO
          IT = 1
 800      CONTINUE
          IRES_TYPE(IR) = IT

C         new atom name(C2) --> Atm_name 
C                              link, syn.
          IFIRST = 0
          DO IC=1,C1_NATOM
            IF(C2_ANAME(IC).NE.C1_ANAME(IC)) THEN
C              MMM = 99
C              IF(LIST.EQ.'T') MMM=MDOC
              CALL  PUT_SYNONYM_TO_LIST(MDOC,MON_NEW,IFIRST,RES,CHAIN
     *                ,C1_ANAME(IC),C2_ANAME(IC),DNEW,IERR)
C                           OLD        NEW
              CALL CHANGE_ATOM_IN_LINK_TAB(MDOC,IG,IR
     *                     ,C1_ANAME(IC),C2_ANAME(IC),IERR)
              DO IA=IAS,IAF
                IF(ATM_NAME(IA).EQ.C1_ANAME(IC)) THEN
                  ATM_NAME(IA) = C2_ANAME(IC)
                ENDIF
              ENDDO
            ENDIF
          ENDDO
C ---
          DO IL=1,L1A_NATOM
            DO IA=IAS,IAF
              IF(ATM_NAME(IA).EQ.L1A_ANAME(IL)) THEN
                ATM_CHEM(IA) = L1A_CHEM(IL)
                CR_ASYMB     = L1A_SYMB(IL)
                INSF = ID_SF(IA)
                IF(INSF.GT.0.AND.CS_ELEMENT(INSF)(1:1).NE.'?')THEN
                  EL_D    = CR_ASYMB
                  EL_F    = CS_ELEMENT(INSF)
                  CALL LENSTR_BL(CS_ATYPE(INSF),LLL)
                  IF(LLL.GE.3) THEN
                    IF(CS_ATYPE(INSF)(2:2).EQ.'+'.OR.
     *                 CS_ATYPE(INSF)(2:2).EQ.'-'    ) THEN
                      EL_F    = CS_ATYPE(INSF)                          
                    ELSE IF(LLL.GE.4) THEN
                      IF(CS_ATYPE(INSF)(3:3).EQ.'+'.OR.
     *                   CS_ATYPE(INSF)(3:3).EQ.'-'    ) THEN
                        EL_F    = CS_ATYPE(INSF)
                      ENDIF
                    ENDIF
                  ENDIF
                  ELEMENT = EL_F 
                  CALL CUT_EL_NAME(EL_D)
                  CALL CUT_EL_NAME(EL_F)
C                 EL_F - element from file (without +/-)
C                 EL_D - element from dictionary (without +/-)
                  IF(EL_F.NE.EL_D) THEN
C                   from dict.
                    ELEMENT = CR_ASYMB 
                    LINE = ' WARNING : residue: '//MON//' '//RES//
     *               ' chain:'//CHAIN
                    CALL MSGERR(MDOC,LINE)
                    LINE = '           different element name:'//
     *              ' file:"'//EL_F//'"  dict:"'//EL_D//'"'
                    CALL MSGERR(MDOC,LINE)
                  ELSE
C                   from file
C                    ELEMENT = CS_ELEMENT(INSF)
                  ENDIF
                ELSE
                  ELEMENT = CR_ASYMB
C --              7.07.03               
c                 IF(INSF.GT.0) ELEMENT = CS_ATYPE(INSF)
C --
                ENDIF

                CALL CHKSMB(CR_ASYMB(2:2),TYPE)
                IF(TYPE.EQ.'D'.OR.TYPE.EQ.'S') CR_ASYMB(2:2) = ' '
                CR_ASYMB(3:3) = ' '
                CR_ASYMB(4:4) = ' '

                IF(CS_NSFATM.GT.0) THEN
                  DO ISF=1,CS_NSFATM
                    IF(ELEMENT.EQ.CS_ELEMENT(ISF)) THEN
                      INSF = ISF
                      GO TO 100
                    ENDIF
                  ENDDO
                ENDIF

                IF(CS_NSFATM.GE.MAXNSF) THEN
                  LINE = ' ERROR: number of atomic scattering'//
     *            ' or chemical types > limit.'
                  CALL MSGERR(MDOC,LINE)
                  CALL MSGERR(MDOC
     *  ,'        change parameter MAXNSF in atom_com.fh')
                  IERR=1
                  RETURN
                ENDIF

                CS_NSFATM            = CS_NSFATM + 1
                INSF                 = CS_NSFATM
                CS_ATYPE  (INSF)     = CR_ASYMB 
                CS_ELEMENT(INSF)     = ELEMENT 

 100            CONTINUE

                ID_SF    (IA) = INSF

C                ATM_TYPE (IA) = CR_ATYPE

              ENDIF
            ENDDO
          ENDDO
C ---
          IF(IR.NE.IRS.AND.
     *       (IRES_TYPE(IR).EQ.3.OR.IRES_TYPE(IR).EQ.4)) THEN 
            IF(ICONN_TYPE(IR).NE.37.AND.ICONN_TYPE(IR).NE.10.AND. 
     *         ICONN_TYPE(IR).NE.39     ) THEN
              CALL CHECK_CONN_TYPE_BY_BOND(MDOC,ICTYPE,IERR)
              IF(ICTYPE.GT.1)ICONN_TYPE(IR) = ICTYPE
            ENDIF 
          ENDIF
C ---

        ENDDO

      ENDDO

      IF(NMNEW.GT.0) THEN
        WRITE(LINE,'(A,I6)')
     *  ' number of new kinds of monomers            :', NMNEW
        CALL MSGDOC(MD,LINE)
      ENDIF

      IF(LML_NMON.GT.0) THEN
        DO LL=1,LML_NMON
          IF(LML_FUSE(LL).EQ.'C') DNEW = 'Y'
        ENDDO
      ENDIF        

C -- 6.04.03  DNEW not used here
C    IF(DNEW.EQ.'Y') NMNEW = NMNEW + 1

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MDOC,' --- END PRE_DESCR --- ')
        CALL PRINT_INFO_TEST(MDOC)
      ENDIF


      RETURN
      END

      SUBROUTINE CHECK_CONN_TYPE_BY_BOND(MDOC,ICTYPE,IERR)
C -----------------------------
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256
C -----------------------------
      IERR = 0
      ICTYPE = 1
C ---
       IF(L1B_NBOND.GT.0) THEN
         DO I=1,L1B_NBOND
           IF((L1B_1ATM(I).EQ.'N '.AND.L1B_2ATM(I).EQ.'CD').OR. 
     *        (L1B_2ATM(I).EQ.'N '.AND.L1B_1ATM(I).EQ.'CD')    )
     *     ICTYPE=36
           IF((L1B_1ATM(I).EQ.'N '.AND.L1B_2ATM(I).EQ.'CN').OR. 
     *        (L1B_2ATM(I).EQ.'N '.AND.L1B_1ATM(I).EQ.'CN')    )
     *     ICTYPE=38
         ENDDO
       ENDIF
C ----
      RETURN
      END

      SUBROUTINE CUT_EL_NAME(EL_NAME)
C -------------------------------------------
      CHARACTER EL_NAME*4,CHAR4*4
C -------------------------------------------
      CHAR4   = EL_NAME
      EL_NAME = ' '
      CALL LENSTR_BL(CHAR4,LEN)
      DO I=1,LEN
        IF(CHAR4(I:I).EQ.'+'.OR.CHAR4(I:I).EQ.'-') GO TO 100
         EL_NAME(I:I) = CHAR4(I:I)
      ENDDO
 100  CONTINUE
      RETURN
      END

      SUBROUTINE PRINT_INFO_TEST(MD)
C -------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'lib_com.fh'
C ----
      CHARACTER LINE*80
C -------------------        
      IF(ABS(MD).GE.99) RETURN
      CALL MSGDOC(MD,' ---ln id,used,ent,dist/res,ch,atom - ')
        IF(LN_N.GT.0) THEN
          DO LN=1,LN_N
         write(LINE,*) 'ln:',LN_ID(LN),LN_USEd(LN),LN_ENT(LN)
     *    ,LN_DIST(LN) 
         CALL MSGDOC(MD,LINE)
         write(LINE,*) '   ',LN_1IRES(ln),LN_1ICHN(LN),LN_ATOM1(LN)
         CALL MSGDOC(MD,LINE)
         write(LINE,*) '   ',LN_2IRES(ln),LN_2ICHN(LN),LN_ATOM2(LN)
         CALL MSGDOC(MD,LINE)
         write(LINE,*) '   ',LN_ALT1(LN),LN_ALT2(LN)
         CALL MSGDOC(MD,LINE)
          enddo             
        endif
       CALL MSGDOC(MD,' -- md id,res,ch,rnam,rnam_new - ')
        IF(MOD_N.GT.0) THEN
          DO IM = 1,MOD_N
       write(LINE,*) 'md:',mod_ID(im),';',MOD_USED(im) 
       CALL MSGDOC(MD,LINE)
       write(LINE,*) '   '
     *     ,mod_ires(im),mod_iCHN(im),mod_rnam(im),mod_rnam_new(im)
       CALL MSGDOC(MD,LINE)
          ENDDO
        ENDIF
c      CALL MSGDOC(MD,' -- syn amname,mname,atom,atom - ')
c        if(lms_nsyn.gt.0) then
c          DO LL=1,LMS_NSYN
c            write(LINE,*) 'sn:'
c     *      ,LMS_AMNAME(LL),LMS_MNAME(LL),LMS_AATOM(LL),LMS_ATOM(LL)
c     *      ,';',LMS_FLAG(LL)
c            CALL MSGDOC(MD,LINE)
c          ENDDO
c        ENDIF
c      CALL MSGDOC(MD,' -- der  mname,smname,type - ')
c      IF(LDR_NDER.GT.0) THEN
c        DO LL=1,LDR_NDER
c          write(LINE,*) 'dr:'
c     *    ,LDR_MNAME(LL),LDR_SMNAME(LL),LDR_TYPE(LL)
c          CALL MSGDOC(MD,LINE)
c        ENDDO
c      ENDIF
      CALL MSGDOC(MD,' ----- ')
C ---
      RETURN
      END


      SUBROUTINE CHANGE_ATOM_IN_LINK_TAB(MDOC,ICH1,IRES1
     *                     ,ATOM_OLD,ATOM_NEW,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      INTEGER*4 ICH1,IRES1

C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ---
      CHARACTER LINE*256,ATOM_OLD*4,ATOM_NEW*4
C -----------------------------------
      IERR=0
      IF(LN_N.LE.0) RETURN

      DO L=1,LN_N
        IF(LN_1IRES(L).EQ.IRES1.AND.LN_1ICHN(L).EQ.ICH1.AND.
     *     LN_ATOM1(L).EQ.ATOM_OLD) THEN
          LN_ATOM1(L) = ATOM_NEW
        ENDIF
        IF(LN_2IRES(L).EQ.IRES1.AND.LN_2ICHN(L).EQ.ICH1.AND.
     *     LN_ATOM2(L).EQ.ATOM_OLD) THEN
          LN_ATOM2(L) = ATOM_NEW
        ENDIF
      ENDDO

      RETURN
      END

      SUBROUTINE PUT_SYNONYM_TO_LIST(MDOC,MON,IFIRST,RES,CHAIN
     *         ,ATOM_OLD,ATOM_NEW,DNEW,IERR)
C -----------------------------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------------------------
      INTEGER     MDOC,IERR
C -----------------------------------------------------------
      CHARACTER LINE*256
      CHARACTER MON*8,ATOM_OLD*4,ATOM_NEW*4,MONN*8,DNEW*1
      CHARACTER RES*5,CHAIN*4       
C -----------------------------------------------------------
      MONN = '.'
      CALL CHECK_SYNONYM(IT,MON,MONN,ATOM_NEW,ATOM_OLD)
      IF(IT.NE.0.or.MON.eq.'.'.or.MON.eq.' ') RETURN

      IF(LMS_NSYN.GE.MAXMLIST) RETURN
      LMS_NSYN = LMS_NSYN + 1
      LMS_NEW  = LMS_NEW  + 1
      LMS_ISYN = LMS_NSYN

      IF(IFIRST.EQ.0) THEN
        WRITE(LINE,
     *  '('' WARNING : program changed the atom names to standard'')')
        CALL MSGDOC(MDOC,LINE)
        LINE = '           residue: '//MON//' '//RES//' chain:'//CHAIN 
        CALL MSGDOC(MDOC,LINE)
        IFIRST = 1
      ENDIF

      LMS_MNAME  (LMS_NSYN) = MON
      LMS_MNAME2 (LMS_NSYN) = '.' 
      LMS_ATOM   (LMS_NSYN) = ATOM_NEW
      LMS_MOD    (LMS_NSYN) = '.' 
      LMS_AATOM  (LMS_NSYN) = ATOM_OLD
      LMS_AMNAME (LMS_NSYN) = '.' 
      LMS_AMNAME2(LMS_NSYN) = '.' 
      LMS_FLAG   (LMS_NSYN) = 'N' 
      DNEW = 'Y'

      WRITE(LINE,
     * '(''           '',A,''  "'',A4,''" --> "'',A4,''" '')')
     *    MON,ATOM_OLD,ATOM_NEW
      CALL MSGDOC(MDOC,LINE)
C ----
      RETURN
      END


      SUBROUTINE PRE_MONOM_LIST(MDOC,LIST,IERR)
C ----------------------------------------------------------
C -I-
      INCLUDE 'atom_com.fh'

c      INCLUDE 'lib_com.fh'
C -----------------------------------------------------------
      INTEGER     MDOC,IERR
C ----------------------------------------------------------------
      CHARACTER MON*8,CH1*1,CHAR1*1,MODE*1,NODIST*1,LIST*1
C     CHARACTER LINE*256
C==================================================================
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
      MD0  = 0
      IF(MDOC.EQ.999) MD0 = 999
C --------
      IF(N_ATOM.LE.0.OR.N_GROUP.LE.0) THEN
        CALL MSGERR(MDOC,' ERROR: number of atoms = 0...')
        IERR=1
        RETURN
      ENDIF 
C --------
      JERR     = 0
C ----------------------
      CH1      = 'N'
      CHAR1    = ' '
      CALL SSET_FUSE(CH1,CHAR1)
C ----------------------

c      IF(LIST.EQ.'T') THEN
c        DO L=1,300
c          WRITE(*,*) L,' ',LML_MNAME(L),' ',LML_FUSE(L)
c        ENDDO
c      ENDIF

      DO IG=1,N_GROUP   
        IRS       = IRES_FIRST(IG)
        NRES      = NRES_CHAIN(IG)
        IRF       = IRS + NRES - 1
        DO IR=IRS,IRF
          MON      = RES_NAME   (IR)
          IF(MOD_N.GT.0) THEN
            DO IM = 1,MOD_N
              IF(MOD_IRES    (IM).EQ.IR  .AND.
     *           MOD_ICHN    (IM).EQ.IG  .AND.
     *           MOD_RNAM_NEW(IM).EQ.MON      ) THEN
                MON  = MOD_RNAM(IM)
                GO TO 100
              ENDIF
            ENDDO
          ENDIF

 100      CONTINUE

          CALL LOOK_MON_LIB(MDOC,MON,IERR)
C         IERR = 1  - not found ; 
C              = 2 - number of monomer in the library = 0

c          IF(LIST.EQ.'T') THEN
c            WRITE(*,*) 'pre_monom_list:',ig,ir,mon,ierr
c          ENDIF
          IF(IERR.EQ.2) THEN
            RETURN
          ENDIF
          IERR=0

        ENDDO
      ENDDO

C
C     read mon_lib.cif
C
      CALL MSGDOC(MD0,' I am reading library. Please wait.')
      CALL MSGDOC(MD0,'               mon_lib.cif')
      MODE   = 'M'
      NODIST = 'N'
      CALL READ_LIB(MDOC,MODE,NODIST,LIST,IERR)
      IF(IERR.NE.0) RETURN

      RETURN
      END

      SUBROUTINE LOOK_MON_LIB(MDOC,MON,IERR)
C -----------------------------------------
C -P- CHKMON - looks for monomer's name in the library list
C              , set use_flag = "Y".
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER AMON*8,MON2*8
C     CHARACTER LINE*256
C --------------------------------
      IERR = 0

      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of monomer in the library = 0')
        IERR = 2
        RETURN
      ENDIF

      DO L=1,LML_NMON
        IF(MON.EQ.LML_MNAME(L)) THEN
          GO TO 100
        ENDIF
      ENDDO

      IF(LMS_NSYN.GT.0) THEN
        DO LL=1,LMS_NSYN
          IF(LMS_AMNAME(LL).EQ.MON) THEN
            MON  = LMS_MNAME(LL)
            DO L=1,LML_NMON
              IF(MON.EQ.LML_MNAME(L)) THEN
                GO TO 100
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

      IF(LDR_NDER.GT.0) THEN
        DO LL=1,LDR_NDER
          IF(LDR_MNAME(LL).EQ.MON) THEN
            AMON = LDR_SMNAME(LL)
            DO L=1,LML_NMON
              IF(AMON.EQ.LML_MNAME(L)) THEN
               MON = AMON 
               GO TO 100
              ENDIF
            ENDDO
            MON2 = AMON
            DO LLL=1,LDR_NDER
              IF(LDR_MNAME(LLL).EQ.MON2) THEN
                AMON = LDR_SMNAME(LLL)
                DO L=1,LML_NMON
                  IF(AMON.EQ.LML_MNAME(L)) THEN
                    MON = AMON 
                    GO TO 100
                  ENDIF
                ENDDO
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

C     monomer is not found.
      IERR=1
      RETURN

  100 CONTINUE

      IF(LML_FUSE(L).EQ.'N') THEN
        LML_FUSE(L) = 'R'
      ENDIF

      RETURN
      END     

      SUBROUTINE GLOBAL_SEARCH_NEW(MDOC,LIST,MON,MON_NEW,NEW_FLAG,SRCH
     *  ,NMON_CRT_NEW,IG,IR,IAS,IERR)           
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8,MON_NEW*8,NEW_FLAG*1,LIST*1,SRCH*1
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ---
C -----------------------------------------------
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
C -----------------------------------------------
      CHARACTER CTYPE*4,ASYMB*4,MODE*4,MOD_R*1,MOD*8,MTYPE*1
      CHARACTER LINE*256,MONOMER_NEW*8,NODIST*1
C --------------------------------
      IERR      = 0
      MD        = -ABS(MDOC)-1
      IF(LIST.EQ.'T') MD = MDOC
      MDD       = MD
      M         = 99
      IF(LIST.EQ.'T'.OR.LIST.EQ.'L'.OR.LIST.EQ.'M') MDD = MDOC

      C_INDEX   = '.'
      C_CONTENT = '.'
      C_PAIR    = '.'

      IF(LMX_NMON.LE.0) THEN
        MON_NEW = ' '
        GO TO 100
      ENDIF 

      L_BEST = 0
      IF(C1_NATOM.LE.5.OR.LMX_NMON.LE.0) GO TO 200

      DO I=1,C1_NATOM

        S1_NDIST(I) = 0
        ASYMB = C1_ASYMB(I)
        IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *     ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *     ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
          CTYPE='C   '
        ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
          CTYPE='H   '
        ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
          CTYPE='P   '
        ELSE
          CTYPE='$   '
        ENDIF
        C1_ATYPE(I) = CTYPE(1:1)
      ENDDO

      MODE = ' '
      CALL CRD_CONN(MDOC,MODE,IERR)
      IF(IERR.NE.0) THEN
        LINE = ' ERROR : monomer '//MON//' in subroutine CRD_CONN'
        CALL MSGDOC(MDOC,LINE)
        IERR = 0
        GO TO 100
      ENDIF

      CALL CALC_INDEX_CRD(M,MON,N,C_CONTENT,C_INDEX,C_PAIR,IERR)

C ----
      write(line,'(''OLD-->'',I4,'';'',A,'';'',A30,'';'',A24,'';'')')
     *     N,MON,C_CONTENT,C_INDEX
      CALL MSGDOC(MD,LINE)
      write(line,'(''          :'',A24,'';'')')
     *     C_PAIR
      CALL MSGDOC(MD,LINE)
      write(line,*)
      CALL MSGDOC(MD,LINE)
C ---


      L_BEST    = 0
      ILIB_BEST = 0
C     for complete matching  INDI_BEST = 0
C     INDI_BEST = 13
      INDI_BEST = 0
      INDP_BEST = 100000

      DO I=1,LMX_NMON 

        ND = ABS(N - LMX_NATOM(I))

C        IF(N.EQ.LMX_NATOM(I).OR.(N.GT.9.AND.ND.LE.2)) THEN
        IF(ND.LE.0) THEN

          CALL CALC_INDEX_DIFF(M,C_CONTENT,C_INDEX,C_PAIR
     *     ,LMX_CONTENT(I),LMX_INDEX(I),LMX_PAIR(I)
     *     ,IDIFFC,IDIFFI,IDIFFP,IERR)

          IF(IDIFFC.EQ.0) THEN

C            IF((INDI_BEST.GT.IDIFFI).OR.
C     *         (INDI_BEST.EQ.IDIFFI.AND.
C     *          INDP_BEST.GT.IDIFFP     )) THEN

            IF(IDIFFI.EQ.0.AND.IDIFFP.EQ.0) THEN

              write(line,
     *        '(''-->'',I4,'';'',A,'';'',A30,'';'',A24,'';'')')
     *        LMX_NATOM(I),LMX_MNAME(I),LMX_CONTENT(I),LMX_INDEX(I)
              CALL MSGDOC(MD,LINE)
              write(line,'(''          :'',A24,'';'',3I4)')
     *        LMX_PAIR(I),IDIFFC,IDIFFI,IDIFFP
              CALL MSGDOC(MD,LINE)

              DO L=1,LML_NMON
                IF(LMX_MNAME(I).EQ.LML_MNAME(L)) THEN
                  GO TO 400
                ENDIF     
              ENDDO

              GO TO 300

 400          CONTINUE

              L_BEST    = I
              ILIB_BEST = L
              INDI_BEST = IDIFFI
              INDP_BEST = IDIFFP

              GO TO 200

            ENDIF
          ENDIF
        ENDIF

 300    CONTINUE

      ENDDO

 200  CONTINUE

      IF(L_BEST.GT.0) THEN

        I = L_BEST
        L = ILIB_BEST
        IF(LMX_MNAME(I).NE.MON) THEN 
          MON_NEW = LMX_MNAME(I)
          LINE = ' WARNING : monomer looks like '//LMX_MNAME(I)
     *          //'the program will try to use this' 
          CALL MSGDOC(MDD,LINE)
          IF(LML_FUSE(L).EQ.'N') THEN
C           read mon_lib.cif
             LML_FUSE(L) = 'R'
            MOD_R  = 'M'
            NODIST = 'N'
            CALL READ_LIB(M,MOD_R,NODIST,LIST,IERR)
            IF(IERR.NE.0) RETURN
          ENDIF

          IF(LIST.EQ.'T') THEN
            LINE = '           program will try to use this one'
            CALL MSGERR(MDOC,LINE)
            write(*,'(''NEW-->'',I4,'';'',A,'';'',A30,'';'',A24,'';'')')
     *      N,LMX_MNAME(I),LMX_CONTENT(I),LMX_INDEX(I)
            write(*,'(''          :'',A24,'';'')')
     *      LMX_PAIR(I)
          ENDIF

        ELSE
          MON_NEW = ' '
        ENDIF
      ELSE
          MON_NEW = ' '
      ENDIF

 100  CONTINUE

      IF(LIST.EQ.'T') THEN
         LINE= '--G-S :'//MON_NEW//';'//MON//';'//NEW_FLAG//';'
         CALL MSGDOC(MDOC,LINE)
      ENDIF

      IF(MON_NEW(1:1).NE.' ') THEN    
        L1L_MNAME = MON_NEW
        L1L_MNAME2= MON_NEW
        L1L_NAME  = '.'
        C1_RNAME  = MON_NEW
        NEW_FLAG = 'Y'
        IF(LML_PRSNT(L).EQ.'M') NEW_FLAG = 'M'
        CALL CP_MLIB(MDOC,MON_NEW,IERR)
        IF(IERR.NE.0) RETURN
        IT = 0
        CALL CHECK_CMP_MON3(M,LIST,IT,IERR)
c
        IF(IERR.NE.0) THEN
          NEW_FLAG = 'Y'
          MON_NEW  = ' '
          IERR     = 0
        ELSE
          DO IC=1,C1_NATOM
           IF(C2_ANAME(IC).NE.C1_ANAME(IC)) GO TO 500 
          ENDDO

          NEW_FLAG = 'N'
          IF(LML_PRSNT(L).EQ.'M') NEW_FLAG = 'M'
C
C         all names are equal:  new_flag = M/N ; mon_new = mon_iso (from srch)
C
          GO TO 510

 500      CONTINUE
c---Creating synonims in case when atom names are different has a problem
c---Skip it for now.
          LINE = 
     *' WARNING: Some of the atom names of the monomer '//MON//
     &         ' is different from the library desciption' 
          CALL MSGDOC(MDD,LINE)
c          LINE = '                         '//
c     *         'program will change the atom names in the description'
          line = '         '//
     &         'The program will create a new description'
          MON_NEW = ' '
          NEW_FLAG = 'Y'
          CALL MSGDOC(MDD,LINE)
          goto 510

C         There are different atom names:
C         copy mon_iso description , change mon_name
C         change atom names c1 -> L1
C
C         new_flag = 'C', MON_NEW = new_name
C          
          IF(NMON_CRT_NEW.GE.99) RETURN

          I = NMON_CRT_NEW + 1

 600      CONTINUE
c

c
          IF(I.GT.99) RETURN

          WRITE(MONOMER_NEW,'(I3)') I            
          MONOMER_NEW(1:1) = 'N'
          IF(MONOMER_NEW(2:2).EQ.' ') THEN
            MONOMER_NEW(2:2) = MONOMER_NEW(3:3)
            MONOMER_NEW(3:3) = ' '
          ENDIF

          CALL LENSTR_BL(MONOMER_NEW,LEN)
          CALL LENSTR_BL(MON,LM)
          MON_NEW = MON(1:LM)//'_'//MONOMER_NEW(1:LEN)

          CALL CHECK_MON_NAME_IN_LIB(MON_NEW,IERR)
          IF(IERR.EQ.0) THEN
            I = I + 1
            GO TO 600
          ELSE
            IERR = 0
          ENDIF

          NMON_CRT_NEW = I

          L1L_MNAME = MON_NEW
          L1L_MNAME2= MON_NEW
          L1L_NAME  = '.'
          C1_RNAME  = MON_NEW
          CALL CP_ANAME_C1_L1
          CALL COPYC2(MDOC,IERR)  
          NEW_FLAG = 'C'


 510      CONTINUE

          IF(LML_PRSNT(L).EQ.'M') THEN
            LINE = ' WARNING : monomer has the minimal description' 
            CALL MSGDOC(MDD,LINE)
c            LINE = '                         '//
c     *           'program will create complete description'
c            CALL MSGDOC(MDD,LINE)
          ENDIF
        ENDIF
      ENDIF
c
      IF(MON_NEW(1:1).EQ.' ') THEN    
C       create new for old mon_name = MON 
C       new_flag = 'N', MON_NEW = ' '

        NEW_FLAG  = 'Y'
        L1L_PRSNT = 'N'
c --
        L1L_MNAME = MON
        L1L_MNAME2= MON
        C1_RNAME  = MON
        L1L_NAME  = '.'
        L1L_CODE1 = 'x'
        L1L_TYPE  = 'non-polymer'
        L1L_MODE  = '.'
        L1L_FORM  = '.'
        L1L_FUSE  = '?'
        L1L_HFLAG = '.'
        L1L_NATM  = C1_NATOM
        L1L_NHATM = 0
        L1A_NATOM = C1_NATOM
        L1A_NHATOM= 0
        L1N_NCONN = 0
        L1B_NBOND = 0
        L1G_NANGL = 0
        L1T_NTORS = 0
        L1C_NCHIR = 0
        L1P_NPLAN = 0
        DO I=1,C1_NATOM
          L1A_COOR_FLAG(I) = 'Y'
          IF(C1_OCC(I).LT.0.0001) L1A_COOR_FLAG(I) = 'N'
          L1A_X    (I) = C1_XYZ(1,I)
          L1A_Y    (I) = C1_XYZ(2,I)
          L1A_Z    (I) = C1_XYZ(3,I)
          L1A_CHARG(I) = S1_CHAR(I) 
          L1A_INEW (I) = I
          L1A_IOLD (I) = I
          L1A_ICR  (I) = 0
          L1A_NDIST(I) = 0
          L1A_IBACK(I) = 0
          L1A_IFORW(I) = 0
          L1A_BACK (I) = '.'
          L1A_TYPE (I) = '.' 
          L1A_FORW (I) = '.'
          L1A_ANAME(I) = C1_ANAME(I)
          L1A_CHEM (I) = S1_CHEM (I)
          L1A_SYMB (I) = C1_ASYMB(I) 
          ASYMB = CS_ATYPE(C1_SF_ID(I))
          CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
          L1A_SF_ID(I) = INSF
          L1A_CHEM (I) = L1A_SYMB(I) 
          L1A_ATYPE(I) = C1_ATYPE(I)
          DO  J=1,MAX1BRN 
            L1A_CONN   (J,I) = 0
            L1A_LENCON (J,I) = 0
          ENDDO
          DO  J=1,MAX1EXT 
            L1A_IEXTR (J,I)  = 0
          ENDDO
        ENDDO

        IF(SRCH.EQ.'G') THEN

          MODE = ' '
          CALL COOR_CONN(MDOC,MODE,IERR)

          IMON = 0
          CALL LIB_CREATE_TEST_INDEX2(MDOC,IMON
     *            ,NAC,C_CONTENT,C_INDEX,C_PAIR,IERR)
          IF(IERR.NE.0) THEN
            LINE = ' ERROR : monomer '//MON//
     *      ' in subroutine LIB_CREATE_TEST_INDEX2'
            CALL MSGERR(MDOC,LINE)
            IERR = 1
            RETURN
          ENDIF

          IF(LIST.EQ.'T') THEN
          WRITE(LINE,'(I4,1X,2X,1X,A8,1X,I4,1X,A30,1X,A24)')
     *             IMON,MON,NAC,C_CONTENT,C_INDEX
          CALL MSGDOC(MDOC,LINE)
          WRITE(LINE,'(17X,A24)') C_PAIR
          CALL MSGDOC(MDOC,LINE)
          ENDIF

          IF(LIST.EQ.'T') THEN
            CALL MSGDOC(MDOC,'--- test_gm ---')
          ENDIF

          CALL TEST_GM(MDOC,LIST,SRCH
     *              ,NAC,C_CONTENT,C_INDEX,C_PAIR,IERR)
          IF(IERR.EQ.0) THEN
            NEW_FLAG = 'G'
            MON_NEW  = L1L_MNAME
          ELSE
            IERR      = 0
            NEW_FLAG  = 'Y'
            MON_NEW   = ' '
            L1L_PRSNT = 'N'
c --
            L1L_MNAME = MON
            L1L_MNAME2= MON
            C1_RNAME  = MON
            L1L_NAME  = '.'
            L1L_CODE1 = 'x'
            L1L_TYPE  = 'non-polymer'
            L1L_MODE  = '.'
            L1L_FORM  = '.'
            L1L_FUSE  = '?'
            L1L_HFLAG = '.'
            L1L_NATM  = C1_NATOM
            L1L_NHATM = 0
            L1A_NATOM = C1_NATOM
            L1A_NHATOM= 0
            L1N_NCONN = 0
            L1B_NBOND = 0
            L1G_NANGL = 0
            L1T_NTORS = 0
            L1C_NCHIR = 0
            L1P_NPLAN = 0
            DO I=1,C1_NATOM
              L1A_COOR_FLAG(I) = 'Y'
              IF(C1_OCC(I).LT.0.0001) L1A_COOR_FLAG(I) = 'N'
              L1A_X    (I) = C1_XYZ(1,I)
              L1A_Y    (I) = C1_XYZ(2,I)
              L1A_Z    (I) = C1_XYZ(3,I)
              L1A_CHARG(I) = S1_CHAR(I) 
              L1A_INEW (I) = I
              L1A_IOLD (I) = I
              L1A_ICR  (I) = 0
              L1A_NDIST(I) = 0
              L1A_IBACK(I) = 0
              L1A_IFORW(I) = 0
              L1A_BACK (I) = '.'
              L1A_TYPE (I) = '.' 
              L1A_FORW (I) = '.'
              L1A_ANAME(I) = C1_ANAME(I)
              L1A_CHEM (I) = S1_CHEM (I)
              L1A_SYMB (I) = C1_ASYMB(I) 
              ASYMB = CS_ATYPE(C1_SF_ID(I))
              CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
              L1A_SF_ID(I) = INSF
              L1A_CHEM (I) = L1A_SYMB(I) 
              L1A_ATYPE(I) = C1_ATYPE(I)
              DO  J=1,MAX1BRN 
                L1A_CONN   (J,I) = 0
                L1A_LENCON (J,I) = 0
              ENDDO
              DO  J=1,MAX1EXT 
                L1A_IEXTR (J,I)  = 0
              ENDDO
            ENDDO
          ENDIF        
        ENDIF

      ENDIF

      RETURN
      END

      SUBROUTINE CP_ANAME_C1_L1
C ----------------------------------------------------
C -------------------------
      INCLUDE 'lib_com.fh'
C -------------------------
      INTEGER*4 ICH4
      CHARACTER CH4*4
      EQUIVALENCE (ICH4,CH4)
C ----------------------------------------------------
      CHARACTER L3A_BACK      (MAX1ATM)*4
      CHARACTER L3A_FORW      (MAX1ATM)*4
      CHARACTER L3A_ANAME     (MAX1ATM)*4

      CHARACTER L3N_1ATM  (MAX1CONN)*4
      CHARACTER L3N_2ATM  (MAX1CONN)*4

      CHARACTER L3B_1ATM  (MAX1BND)*4
      CHARACTER L3B_2ATM  (MAX1BND)*4

      CHARACTER L3G_1ATM  (MAX1ANG)*4
      CHARACTER L3G_2ATM  (MAX1ANG)*4
      CHARACTER L3G_3ATM  (MAX1ANG)*4

      CHARACTER L3T_1ATM  (MAX1TOR)*4
      CHARACTER L3T_2ATM  (MAX1TOR)*4
      CHARACTER L3T_3ATM  (MAX1TOR)*4
      CHARACTER L3T_4ATM  (MAX1TOR)*4

      CHARACTER L3C_1ATM  (MAX1CHR)*4
      CHARACTER L3C_2ATM  (MAX1CHR)*4
      CHARACTER L3C_3ATM  (MAX1CHR)*4
      CHARACTER L3C_4ATM  (MAX1CHR)*4

      CHARACTER L3C_5ATM  (MAX1CHR)*4
      CHARACTER L3C_6ATM  (MAX1CHR)*4
      CHARACTER L3C_7ATM  (MAX1CHR)*4
      CHARACTER L3C_8ATM  (MAX1CHR)*4
      CHARACTER L3C_9ATM  (MAX1CHR)*4

      INTEGER*4 L3P_ATOM  (MAX1APL,MAX1PLN)
c
c---  body

      IF(L1A_NATOM.GT.0) THEN
         l3a_aname(1:l1a_natom) = l1a_aname(1:l1a_natom)
         l3a_back(1:l1a_natom) = l1a_back(1:l1a_natom)
         l3a_forw(1:l1a_natom) = l1a_forw(1:l1a_natom)
         DO IC=1,C1_NATOM
            DO I=1, L1A_NATOM
              IF(C2_ANAME(IC).EQ.L1A_ANAME(I)) then
                 L3A_ANAME(I) = C1_ANAME(IC)
              endif
              IF(C2_ANAME(IC).EQ.L1A_BACK(I)) L3A_BACK(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1A_FORW(I)) L3A_FORW(I) = C1_ANAME(IC)
            ENDDO
         enddo
         l1a_aname(1:l1a_natom) = l3a_aname(1:l1a_natom)
         l1a_back(1:l1a_natom) = l3a_back(1:l1a_natom)
         l1a_forw(1:l1a_natom) = l3a_forw(1:l1a_natom)
      endif

      IF(L1N_NCONN.GT.0) THEN     
         l3n_1atm(1:l1a_nconn) = l1n_1atm(1:l1a_natom)
         l3n_2atm(1:l1a_nconn) = l1n_2atm(1:l1a_natom)
         do ic=1,c1_natom
            DO I=1, L1N_NCONN
              IF(C2_ANAME(IC).EQ.L1N_1ATM(I)) L3N_1ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1N_2ATM(I)) L3N_2ATM(I) = C1_ANAME(IC)
            ENDDO
         ENDdo
         l1n_1atm(1:l1a_nconn) = l3n_1atm(1:l1a_nconn)
         l1n_2atm(1:l1a_nconn) = l3n_2atm(1:l1a_nconn)
      endif

c
      IF(L1B_NBOND.GT.0) THEN
         l3b_1atm(1:l1b_nbond) = l1b_1atm(1:l1b_nbond)
         l3b_2atm(1:l1b_nbond) = l1b_2atm(1:l1b_nbond)
         do ic=1,c1_natom
           DO I=1,L1B_NBOND
             IF(C2_ANAME(IC).EQ.L1B_1ATM(I)) L3B_1ATM(I) = C1_ANAME(IC)
             IF(C2_ANAME(IC).EQ.L1B_2ATM(I)) L3B_2ATM(I) = C1_ANAME(IC)
           ENDDO
        enddo
         l1b_1atm(1:l1b_nbond) = l3b_1atm(1:l1b_nbond)
         l1b_2atm(1:l1b_nbond) = l3b_2atm(1:l1b_nbond)
      ENDIF
c

      IF(L1G_NANGL.GT.0) THEN
         l3g_1atm(1:l1g_nangl) = l1g_1atm(1:l1g_nangl)
         l3g_2atm(1:l1g_nangl) = l1g_2atm(2:l1g_nangl)
         l3g_3atm(1:l1g_nangl) = l1g_3atm(2:l1g_nangl)
         do ic=1,c1_natom
            DO I=1,L1G_NANGL
              IF(C2_ANAME(IC).EQ.L1G_1ATM(I)) L3G_1ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1G_2ATM(I)) L3G_2ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1G_3ATM(I)) L3G_3ATM(I) = C1_ANAME(IC)
            ENDDO
         enddo
         l1g_1atm(1:l1g_nangl) = l3g_1atm(1:l1g_nangl)
         l1g_2atm(1:l1g_nangl) = l3g_2atm(2:l1g_nangl)
         l1g_3atm(1:l1g_nangl) = l3g_3atm(2:l1g_nangl)
      ENDIF

      IF(L1T_NTORS.GT.0) THEN
        l3t_1atm(1:l1t_ntors) = l1t_1atm(1:l1t_ntors)
        l3t_2atm(1:l1t_ntors) = l1t_2atm(1:l1t_ntors)
        l3t_3atm(1:l1t_ntors) = l1t_3atm(1:l1t_ntors)
        l3t_4atm(1:l1t_ntors) = l1t_4atm(1:l1t_ntors)
        do ic=1,c1_natom
           DO I=1,L1T_NTORS
              IF(C2_ANAME(IC).EQ.L1T_1ATM(I)) L3T_1ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1T_2ATM(I)) L3T_2ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1T_3ATM(I)) L3T_3ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1T_4ATM(I)) L3T_4ATM(I) = C1_ANAME(IC)
           ENDDO
        enddo
        l1t_1atm(1:l1t_ntors) = l3t_1atm(1:l1t_ntors)
        l1t_2atm(1:l1t_ntors) = l3t_2atm(1:l1t_ntors)
        l1t_3atm(1:l1t_ntors) = l3t_3atm(1:l1t_ntors)
        l1t_4atm(1:l1t_ntors) = l3t_4atm(1:l1t_ntors)
      ENDIF
      IF(L1C_NCHIR.GT.0) THEN
        l3c_1atm(1:l1c_nchir) = l1c_1atm(1:l1c_nchir)
        l3c_2atm(1:l1c_nchir) = l1c_2atm(1:l1c_nchir)
        l3c_3atm(1:l1c_nchir) = l1c_3atm(1:l1c_nchir)
        l3c_4atm(1:l1c_nchir) = l1c_4atm(1:l1c_nchir)
        l3c_5atm(1:l1c_nchir) = l1c_5atm(1:l1c_nchir)
        l3c_6atm(1:l1c_nchir) = l1c_6atm(1:l1c_nchir)
        l3c_7atm(1:l1c_nchir) = l1c_7atm(1:l1c_nchir)
        l3c_8atm(1:l1c_nchir) = l1c_8atm(1:l1c_nchir)
        l3c_9atm(1:l1c_nchir) = l1c_9atm(1:l1c_nchir)
        do ic=1,c1_natom
           DO I=1,L1C_NCHIR
              IF(C2_ANAME(IC).EQ.L1C_1ATM(I)) L3C_1ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1C_2ATM(I)) L3C_2ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1C_3ATM(I)) L3C_3ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1C_4ATM(I)) L3C_4ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1C_5ATM(I)) L3C_5ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1C_6ATM(I)) L3C_6ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1C_7ATM(I)) L3C_7ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1C_8ATM(I)) L3C_8ATM(I) = C1_ANAME(IC)
              IF(C2_ANAME(IC).EQ.L1C_9ATM(I)) L3C_9ATM(I) = C1_ANAME(IC)
           ENDDO
        enddo
        l1c_1atm(1:l1c_nchir) = l3c_1atm(1:l1c_nchir)
        l1c_2atm(1:l1c_nchir) = l3c_2atm(1:l1c_nchir)
        l1c_3atm(1:l1c_nchir) = l3c_3atm(1:l1c_nchir)
        l1c_4atm(1:l1c_nchir) = l3c_4atm(1:l1c_nchir)
        l1c_5atm(1:l1c_nchir) = l3c_5atm(1:l1c_nchir)
        l1c_6atm(1:l1c_nchir) = l3c_6atm(1:l1c_nchir)
        l1c_7atm(1:l1c_nchir) = l3c_7atm(1:l1c_nchir)
        l1c_8atm(1:l1c_nchir) = l3c_8atm(1:l1c_nchir)
        l1c_9atm(1:l1c_nchir) = l3c_9atm(1:l1c_nchir)
      ENDIF

      IF(L1P_NPLAN.GT.0) THEN
        do ip=1,l1p_nplan
           do i=1,l1p_natom(ip)
              l3p_atom(i,ip) = l1p_atom(i,ip)
           enddo
        enddo
        do ic=1,c1_natom
           DO IP=1,L1P_NPLAN
              DO   I=1,L1P_NATOM (ip)
                 ICH4 = L1P_ATOM(I,IP)  
                 IF(C2_ANAME(IC).EQ.CH4) THEN
                    CH4 =  C1_ANAME(IC)
                    L3P_ATOM(I,IP) = ICH4
                 ENDIF
              ENDDO 
           ENDDO
        enddo
        do ip=1,l1p_nplan
           do i=1,l1p_natom(ip)
              l1p_atom(i,ip) = l3p_atom(i,ip)
           enddo
        enddo
      ENDIF  


C ----------
      
      RETURN
      END

      SUBROUTINE CALC_INDEX_CRD(MDOC,MON,N,C_CONTENT
     *                                    ,C_INDEX,C_PAIR,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4,MON*8,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ---------------------------------------------
      PARAMETER (ISYMBMAX =  4)
      PARAMETER (LENLIM   =  8)
      COMMON /MTC_ATOM/ MTC_NEW,MTC_CONN,MTC_NTYPE,MTC_NUMB
     *                 ,MTC_NA1    ,MTC_NA2 
     *                 ,MTC_NUMB1  ,MTC_NUMB2
     *                 ,MTC_IB1    ,MTC_IB2
     *                 ,MTC_INDEX1 ,MTC_INDEX2
     *                 ,MTC_VEC1   ,MTC_VEC2
     *                 ,MTC_SYMB1  ,MTC_SYMB2
     *                 ,MTC_NEQUIV ,MTC_IEQUIV   ,MTC_DELTA
     *                 ,MTC_NAME1  ,MTC_NAME2    ,MTC_SYMB
     *                 ,MTC_C_INDEX,MTC_C_CONTENT,MTC_C_PAIR
      INTEGER*4 MTC_NA1
      INTEGER*4 MTC_NA2 
      INTEGER*4 MTC_NEW   (MAX1ATM) 
      INTEGER*4 MTC_NUMB1 (MAX1ATM)
      INTEGER*4 MTC_NUMB2 (MAX1ATM)
      INTEGER*4 MTC_IB1   (MAX1ATM)
      INTEGER*4 MTC_IB2   (MAX1ATM)
      INTEGER*4 MTC_CONN  (MAX1ATM,MAX1ATM)
      INTEGER*4 MTC_VEC1  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_VEC2  (MAX1ATM,LENLIM,ISYMBMAX)
      INTEGER*4 MTC_INDEX1(LENLIM)
      INTEGER*4 MTC_INDEX2(LENLIM)
      INTEGER*4 MTC_SYMB1 (MAX1ATM) 
      INTEGER*4 MTC_SYMB2 (MAX1ATM) 
      INTEGER*4 MTC_NEQUIV(MAX1ATM) 
      INTEGER*4 MTC_IEQUIV(MAX1ATM,MAX1ATM) 
      INTEGER*4 MTC_DELTA (MAX1ATM,MAX1ATM) 
      CHARACTER MTC_NAME1 (MAX1ATM)*4
      CHARACTER MTC_NAME2 (MAX1ATM)*4

      INTEGER*4 MTC_NTYPE
      INTEGER*4 MTC_NUMB  (MAX1ATM,2)
      CHARACTER MTC_SYMB  (MAX1ATM)*4
      CHARACTER MTC_C_INDEX  *24
      CHARACTER MTC_C_CONTENT*30
      CHARACTER MTC_C_PAIR   *24
C ------------------------------------------
C     CHARACTER LINE*256
      CHARACTER C_INDEX  *24
      CHARACTER C_CONTENT*30
      CHARACTER C_PAIR   *24
C --------------------------------
      IERR = 0
C     M    =-ABS(MDOC)-1
C ------------------------------------------
      MODE = 'CRD '

      ISYN = 1
      LIST = 'S'
C ????
      CALL CHECK_COMPL(MDOC,LIST,MODE,ISYN,MON,IERR)

      C_CONTENT = MTC_C_CONTENT
      C_INDEX   = MTC_C_INDEX
      C_PAIR    = MTC_C_PAIR
      N         = MTC_NA1
      RETURN
      END

      SUBROUTINE CALC_INDEX_DIFF(MDOC,C_CONTENT1,C_INDEX1,C_PAIR1
     *    ,C_CONTENT2,C_INDEX2,C_PAIR2,IDIFFC,IDIFFI,IDIFFP,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      CHARACTER C_INDEX1  *24
      CHARACTER C_CONTENT1*30
      CHARACTER C_INDEX2  *24
      CHARACTER C_CONTENT2*30
      CHARACTER C_PAIR1   *24
      CHARACTER C_PAIR2   *24
C ------------------------------------------
C     CHARACTER LINE*256
      CHARACTER CHAR2*2,CHAR3*3
      INTEGER*4 ICHAR1,ICHAR2
C ------------------------
      IERR = 0
C     M    =-ABS(MDOC)-1
C --------
      IDIFFC = 0
      IDIFFI = 0
      IDIFFP = 0

C      DO I=1,30
      DO I=4,15
        I1 = (I-1)*2 + 1
        I2 = I1 + 1
        CHAR2 = C_CONTENT1(I1:I2)
C        CALL CHTOINT(CHAR,ICHAR1)
        READ(CHAR2,'(I2)') ICHAR1
        CHAR2 = C_CONTENT2(I1:I2)
C        CALL CHTOINT(CHAR,ICHAR2)
        READ(CHAR2,'(I2)') ICHAR2
        IDIFFC = IDIFFC + ABS(ICHAR1-ICHAR2)
      ENDDO

C      DO I=1,8

      DO I=1,6
        I1 = (I-1)*3 + 1
        I2 = I1 + 2
        CHAR3 = C_INDEX1(I1:I2)
C        CALL CHTOINT(CHAR,ICHAR1)
        READ(CHAR3,'(I3)') ICHAR1
        CHAR3 = C_INDEX2(I1:I2)
C        CALL CHTOINT(CHAR,ICHAR2)
        READ(CHAR3,'(I3)') ICHAR2
        IDIFFI = IDIFFI + ABS(ICHAR1-ICHAR2)
      ENDDO

      DO I=1,8
        I1 = (I-1)*3 + 1
        I2 = I1 + 2
        CHAR3 = C_PAIR1(I1:I2)
C        CALL CHTOINT(CHAR,ICHAR1)
        READ(CHAR3,'(I3)') ICHAR1
        CHAR3 = C_PAIR2(I1:I2)
C        CALL CHTOINT(CHAR,ICHAR2)
        READ(CHAR3,'(I3)') ICHAR2
        IDIFFP = IDIFFP + ABS(ICHAR1-ICHAR2)
      ENDDO
C --------
      RETURN
      END

      SUBROUTINE CHECK_CMP_MON3(MDOC,LIST,IT,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR,IT
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER ASYMB*4,CTYPE*4,MODE_M*4,MON*8,RES*5,CHAIN*4
      CHARACTER MODE*4,LINE*256,LIST*1
C -----------------------------------
      IERR = 0
      MD   = 99   
      M    = -ABS(MDOC)-1
      IF(LIST.EQ.'S') MDOC = MD

      IF(L1A_NATOM.LE.0) THEN
        WRITE(LINE,'(A,A,A,I6)')
     *' ERROR: number of atoms in monomer (lib) ',L1L_MNAME,' = ',
     * L1A_NATOM
        CALL MSGERR(MDOC,LINE)
        IERR=1
        RETURN
      ENDIF

      NA        = L1A_NATOM
      MON       = L1L_MNAME        
      RES       = C1_PNUM(3:7)
      CHAIN     = C1_PNUM(1:2)//'  '

      IF(NA.LE.0.OR.C1_NATOM.LE.0) THEN
        RETURN
      ENDIF

C ---- check ----
      L1A_NHATOM = 0
      DO I=1,NA
        L1A_INEW (I) = I 
        L1A_IOLD (I) = I
        L1A_ICHEM(I) = 0              
        L1A_ICR  (I) = 0
        L1A_NDIST(I) = 0
        L1A_IBACK(I) = 0
        L1A_IFORW(I) = 0
c        L1A_BACK (I) = '.'
C        L1A_TYPE (I) = '.' 
c        L1A_FORW (I) = '.'
        DO  J=1,MAX1BRN 
          L1A_CONN   (J,I) = 0
          L1A_LENCON (J,I) = 0
        ENDDO
        DO  J=1,MAX1EXT 
          L1A_TEXTR (J,I) = 0
          L1A_IEXTR (J,I) = 0
        ENDDO
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).EQ.'C '.OR.ASYMB(1:2).EQ.'N '.OR.
     *     ASYMB(1:2).EQ.'O '.OR.ASYMB(1:2).EQ.'B '.OR.
     *     ASYMB(1:2).EQ.'F '.OR.ASYMB(1:2).EQ.'LI'      ) THEN
          CTYPE='C   '
        ELSE IF(ASYMB(1:2).EQ.'H '.OR.ASYMB(1:2).EQ.'D ') THEN
          CTYPE='H   '
          L1A_NHATOM   = L1A_NHATOM + 1
        ELSE IF(ASYMB(1:2).EQ.'P '.OR.ASYMB(1:2).EQ.'S ') THEN
          CTYPE='P   '
        ELSE
          CTYPE='$   '
        ENDIF
        L1A_ATYPE(I)=CTYPE(1:1)
      ENDDO

      IF(IT.EQ.1) RETURN
C --
      MODE=' '
      CALL LIB_CONN(MDOC,MODE,IERR)
      CALL CRD_CONN(MDOC,MODE,IERR)

      MODE_M = '    '
      ISYN   = 2
      CALL CHECK_COMPL(MDOC,LIST,MODE_M,ISYN,MON,IERR)

      IF(LIST.EQ.'T'.OR.LIST.EQ.'L') THEN
        IF(IERR.NE.0) THEN
          WRITE(LINE,
     *    '('' WARNING : residue: '',A,'' '',A,'' chain:'',A)') 
     *    MON,RES,CHAIN
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,'(A,A,A,I2)')
     *    ' WARNING : ',MON,
     *    ' : program can not match library description....',IERR
          CALL MSGERR(MDOC,LINE)
        ENDIF
      ENDIF

      RETURN 
      END

      SUBROUTINE CHECK_MON_LIB(MDOC,MON,CHAR12
     * ,AMON,MOD,NEW_FLAG,NMUSE,NMNEW,TYPE,LIST,IERR)
C -----------------------------------------
C -P- CHKMON - looks for monomer's name in the library list
C              , set use_flag = "Y".
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR,NMUSE
      CHARACTER MON*8,AMON*8,MOD*8,NEW_FLAG*1,TYPE*16,NODIST*1
      CHARACTER MOD_R*1,RES*5,CHAIN*4
      CHARACTER CHAR12*12,MON2*8,MON3*8,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER LINE*256
C --------------------------------
      IERR=0

      RES       = CHAR12(3:7)
      CHAIN     = CHAR12(8:11)
      C1_PNUM   = CHAR12
      TYPE      = '.'
      AMON      = '.'
      MOD       = '.'

      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of monomer in the library = 0')
        IERR=2
        RETURN
      ENDIF

      DO L=1,LML_NMON
        IF(MON.EQ.LML_MNAME(L)) THEN
          AMON = '.'
          MOD  = '.'
          TYPE = LML_TYPE(L)
          GO TO 100
        ENDIF     
      ENDDO

      MON2 = MON

      IF(LMS_NSYN.GT.0) THEN
        DO LL=1,LMS_NSYN
          IF(LMS_AMNAME(LL).EQ.MON) THEN
            AMON  = MON 
            MON2  = LMS_MNAME(LL)
            MOD   = LMS_MOD  (LL)
            DO L=1,LML_NMON
              IF(MON2.EQ.LML_MNAME(L)) THEN
                MON  = MON2
                TYPE = LML_TYPE(L)
                GO TO 100
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

      MON = MON2       

      IF(LDR_NDER.GT.0) THEN
        DO LL=1,LDR_NDER
          IF(LDR_MNAME(LL).EQ.MON2) THEN
            AMON = LDR_SMNAME(LL)
C           MOD  = LDR_MOD   (LL)
            TYPE = LDR_TYPE  (LL)
            DO L=1,LML_NMON
              IF(AMON.EQ.LML_MNAME(L)) THEN
                GO TO 100
              ENDIF
            ENDDO
            MON3 = AMON
            DO LLL=1,LDR_NDER
              IF(LDR_MNAME(LLL).EQ.MON3) THEN
                AMON = LDR_SMNAME(LLL)
C               MOD  = LDR_MOD(LLL)
                DO L=1,LML_NMON
                  IF(AMON.EQ.LML_MNAME(L)) THEN
                    TYPE = LML_TYPE(L)
                    GO TO 100
                  ENDIF
                ENDDO
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

C     monomer is not found.
      LINE = ' WARNING : residue: '//MON//' '//RES//' chain:'//CHAIN
     *       //' - is not in the library' 
      CALL MSGDOC(MDOC,LINE)

C      WRITE(LINE,                  
C     *'(''                         program will create description of ne
C     *w monomer'')')
C      CALL MSGERR(MDOC,LINE)

      IERR=1
      IF(LML_NMON.GE.MAXMLIST) THEN
        WRITE(LINE,
     *  '('' ERR: number of monomers >'',I6,'' /lib. limit/'')') 
     *  MAXMLIST
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     *  '        Change parameter MAXMLIST in "lib_com.fh"')
        IERR=1
        RETURN
      ENDIF

      C1_NATOM  = 0

      L1L_MNAME = MON 
      L1L_MNAME2= MON
      L1L_NAME  = '.'
      L1L_CODE1 = 'x'
      L1L_TYPE  = 'non-polymer'
      L1L_MODE  = '.'
      L1L_FORM  = '.'
      L1L_FUSE  = '?'
      L1L_PRSNT = 'N'
      L1L_HFLAG = '.'
      L1L_NATM  = 0
      L1L_NHATM = 0
      L1A_NATOM = 0
      L1A_NHATOM= 0
      L1N_NCONN = 0
      L1B_NBOND = 0
      L1G_NANGL = 0
      L1T_NTORS = 0
      L1C_NCHIR = 0
      L1P_NPLAN = 0
      AMON      = '.'
      MOD       = '.'
      TYPE      = L1L_TYPE
      NEW_FLAG  = 'Y'
      NMUSE     = NMUSE + 1
c     NMNEW     = NMNEW + 1

C -- 06.04.03
      LB_PASS = 0

      RETURN

  100 CONTINUE

C -----
      IF(LML_FUSE(L).EQ.'N') THEN
C       read mon_lib.cif
        LML_FUSE(L) = 'R'
        MOD_R       = 'M'
        NODIST      = 'N'
        CALL READ_LIB(MDOC,MOD_R,NODIST,LIST,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
C ----
      CALL CP_MLIB(MDOC,MON,IERR)
      IF(IERR.NE.0) RETURN
C -- 06.04.03
      LB_PASS = LML_PASS(L)

      C1_NATOM  = 0

      IF(LML_PRSNT(L).EQ.'M') THEN

        NEW_FLAG = 'M'
        LINE = ' WARNING : residue: '//MON//' '//RES//' chain:'//CHAIN
     *       //'- has the minimal description' 
        CALL MSGDOC(MDOC,LINE)
c        WRITE(LINE,                  
c     *'(''                         program will create complete descript
c     *ion'')')
c        CALL MSGDOC(MDOC,LINE)
        NMUSE = NMUSE + 1
c       NMNEW = NMNEW + 1

      ELSE
C -----
        IF(LML_PRSNT(L).EQ.'N') THEN
          NMUSE        = NMUSE + 1
          LML_PRSNT(L) = 'Y'
        ENDIF
        NEW_FLAG = 'N'

      ENDIF
C ---
      RETURN
      END     

      SUBROUTINE CHECK_MON_NAME_IN_LIB(MON,IERR)
C -----------------------------------------
      INTEGER*4 IERR
      CHARACTER MON*8,AMON*8,MON2*8,MON3*8
C ---
      INCLUDE 'lib_com.fh'
C --------------------------------
      IERR=0

      AMON      = '.'

      IF(LML_NMON.LE.0) THEN
        IERR=1
        RETURN
      ENDIF

      DO L=1,LML_NMON
        IF(MON.EQ.LML_MNAME(L)) THEN
          GO TO 100
        ENDIF     
      ENDDO

      MON2 = MON

      IF(LMS_NSYN.GT.0) THEN
        DO LL=1,LMS_NSYN
          IF(LMS_AMNAME(LL).EQ.MON) THEN
            AMON  = MON 
            MON2  = LMS_MNAME(LL)
            DO L=1,LML_NMON
              IF(MON2.EQ.LML_MNAME(L)) THEN
                MON  = MON2
                GO TO 100
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

      MON = MON2       

      IF(LDR_NDER.GT.0) THEN
        DO LL=1,LDR_NDER
          IF(LDR_MNAME(LL).EQ.MON2) THEN
            AMON = LDR_SMNAME(LL)
            DO L=1,LML_NMON
              IF(AMON.EQ.LML_MNAME(L)) THEN
                GO TO 100
              ENDIF
            ENDDO
            MON3 = AMON
            DO LLL=1,LDR_NDER
              IF(LDR_MNAME(LLL).EQ.MON3) THEN
                AMON = LDR_SMNAME(LLL)
                DO L=1,LML_NMON
                  IF(AMON.EQ.LML_MNAME(L)) THEN
                    GO TO 100
                  ENDIF
                ENDDO
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF
      IERR = 1
 100  CONTINUE
      RETURN
      END


C ******
      SUBROUTINE CHECK_ANAME(MON,AMON,MOD,ANAME,ALT_NAME)
C -----------------------------------------
C -P- CHECK_NAME - ATOM'S NAME
C -S-
C -----------------------------------------
      CHARACTER MON*8,AMON*8,ANAME*4,ALT_NAME*4
      CHARACTER MOD*8
C ---
      INCLUDE 'lib_com.fh'
C ******
C --------------------------------
      ALT_NAME = '.'
      IF(LMS_NSYN.GT.0) THEN

        DO L=1,LMS_NSYN
          IF(LMS_MNAME(L).EQ.MON.AND.LMS_ATOM(L).NE.'.') THEN
            IF(LMS_AMNAME(L).EQ.'.') THEN
              IF(LMS_AATOM(L).EQ.ANAME) THEN
                ALT_NAME = ANAME 
                ANAME    = LMS_ATOM(L)
                GO TO 100
              ENDIF
            ENDIF
          ENDIF
        ENDDO

  100   CONTINUE

        DO L=1,LMS_NSYN
          IF(LMS_MNAME(L).EQ.MON.AND.LMS_ATOM(L).NE.'.') THEN
            IF(LMS_AMNAME(L).EQ.AMON.AND.LMS_AMNAME(L).NE.'.') THEN
              IF(LMS_AATOM(L).EQ.ANAME) THEN
                ALT_NAME = ANAME 
                ANAME    = LMS_ATOM(L)
                GO TO 200
              ENDIF
            ENDIF
          ENDIF
        ENDDO

  200   CONTINUE

      ENDIF
      IF(ANAME.EQ.'H0  ') THEN
        ALT_NAME = ANAME 
        ANAME    = 'H   '
      ENDIF
      RETURN
      END     

      SUBROUTINE LPUT_NEW(MDOC,LIST,ALT_FOR_COPY,ITYPE,IERR)
C -----------------------------------------
C -P- LPUT_NEW - 
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'lib_com.fh'
      INCLUDE 'link_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      CHARACTER MON*8,LINE*256,ASYMB*4,ALT_FOR_COPY*1,LIST*1
      CHARACTER CH1*1,EL_D*4,EL_F*4
C --------------------------------
      IF(C1_NATOM.LT.0) GO TO 200

      IF(C1_NATOM.GE.MX1ATOM) THEN
        MON = C1_RNAME 
        WRITE(LINE,'(A,A,A,I6)')
     *  ' ERROR: in "LPUT_NEW", number of atoms in monomer ',MON,' >',
     *  MX1ATOM
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     *  '          Change parameter MX1ATOM in "lib_com.fh"')
        IERR     = 0
        C1_NATOM =-1
        GO TO 200
      ENDIF

      IF(LIST.EQ.'T') THEN
         WRITE(*,*) 'LPUT:'
     *  ,C1_NATOM,CR_ANAME,';',CR_ALT,';',ALT_FOR_COPY,';',
     *  CR_ANAME_INP,';',CR_ASYMB,CR_SF_ID
      ENDIF

      IF(CR_ALT.NE.'.'.AND.CR_ALT.NE.ALT_FOR_COPY) RETURN
      IF(ITYPE.EQ.3) THEN
        IF(CR_ANAME.EQ.'OXT'.OR.CR_ANAME.EQ.'HXT'.OR.
     *     CR_ANAME.EQ.'HN1'.OR.CR_ANAME.EQ.'HN2'.OR.
     *     CR_ANAME.EQ.'HN3'.OR.CR_ANAME.EQ.'H1 '.OR.
     *     CR_ANAME.EQ.'H2 '.OR.CR_ANAME.EQ.'H3 '.OR.
     *                          CR_ANAME.EQ.'H'      ) RETURN
      ELSE IF(ITYPE.EQ.5) THEN
        IF(CR_ANAME.EQ.'O3T '.OR.CR_ANAME.EQ.'O3P '.OR.
     *     CR_ANAME.EQ.'HOP1'.OR.CR_ANAME.EQ.'HOP2'.OR.
     *     CR_ANAME.EQ.'HOP3'.OR.CR_ANAME.EQ.'HO3*'    ) RETURN
      ENDIF
      IF(C1_NATOM.GE.1) THEN
        DO I=1,C1_NATOM
          IF(CR_ANAME.EQ.C1_ANAME(I)) THEN
C            IF(CR_ALT.EQ.'.'.OR.
C     *         (CR_ALT.EQ.ALT_FOR_COPY.AND.C1_ALT(I).NE.'.')) THEN
C              GO TO 100
C            ENDIF
            RETURN
C           IF(C1_ALT(I).EQ.'.') RETURN
C           IF(C1_ALT(I).EQ.ALT_FOR_COPY) RETURN
          ENDIF
        ENDDO
      ENDIF

      C1_NATOM             = C1_NATOM + 1
      C1_RNAME             = CR_RNAME
      C1_OCC  (C1_NATOM)   = CR_OCC
      C1_XYZ  (1,C1_NATOM) = CR_XYZ(1)
      C1_XYZ  (2,C1_NATOM) = CR_XYZ(2)
      C1_XYZ  (3,C1_NATOM) = CR_XYZ(3)
      S1_CHAR (C1_NATOM)   = 0.0
      S1_INEW (C1_NATOM)   = C1_NATOM 
      S1_IOLD (C1_NATOM)   = C1_NATOM
      S1_ICRD (C1_NATOM)   = 0
      S1_NDIST(C1_NATOM)   = 0
      S1_IBACK(C1_NATOM)   = 0
      S1_IFORW(C1_NATOM)   = 0
      S1_BACK (C1_NATOM)   = '.'
      S1_FORW (C1_NATOM)   = '.'
      C1_ANAME(C1_NATOM)   = CR_ANAME
      C1_ANAME_INP(C1_NATOM)   = CR_ANAME_INP
      C1_ASYMB(C1_NATOM)   = CR_ASYMB 

C      S1_CHEM (C1_NATOM)   = CR_ASYMB 
      S1_CHEM (C1_NATOM)   = ST_CHEM

      C1_ATYPE(C1_NATOM)   = CR_ATYPE 
      C1_SF_ID(C1_NATOM)   = CR_SF_ID
      C1_ALT  (C1_NATOM)   = CR_ALT
      C1_SEG  (C1_NATOM)   = CR_SEG
      C1_CORR (C1_NATOM)   = CR_CORR
      DO  J=1,MX1BRN 
        S1_CONN   (J,C1_NATOM) = 0
        S1_LENCON (J,C1_NATOM) = 0
      ENDDO
      DO  J=1,MX1EXT 
        S1_IEXTR (J,C1_NATOM) = 0
      ENDDO

 200  CONTINUE
C ------
      IF(LIST.EQ.'T') THEN
         WRITE(*,*) '-L1L_PRSNT',L1L_PRSNT
         WRITE(*,*) '--',L1A_natom
      ENDIF

      IF(L1L_PRSNT.EQ.'M') THEN

        MON = L1L_MNAME
        IF(L1A_NATOM.LE.0) THEN
          WRITE(LINE,'(A,A3,A)')
     * ' ERROR: in "LPUT_NEW", number of atoms in monomer ',MON,' <'
          CALL MSGERR(MDOC,LINE)
          IERR=1
          RETURN
        ENDIF

        DO I=1,L1A_NATOM
c         L1A_CHARG(I) = 0.0
          IF(L1A_ANAME(I).EQ.CR_ANAME) THEN
            L1A_COOR_FLAG(I) = 'Y'
            IF(CR_OCC.LT.0.0001) L1A_COOR_FLAG(I) = 'N'
            L1A_X    (I) = CR_XYZ(1)
            L1A_Y    (I) = CR_XYZ(2)
            L1A_Z    (I) = CR_XYZ(3)
            L1A_INEW (I) = I
            L1A_IOLD (I) = I
            L1A_ICR  (I) = 0
            L1A_NDIST(I) = 0
            L1A_IBACK(I) = 0
            L1A_IFORW(I) = 0
            L1A_BACK (I) = '.'
            L1A_TYPE (I) = '.' 
            L1A_FORW (I) = '.'
            L1A_SYMB (I) = CR_ASYMB 
            L1A_CHARG(I) = 0.0
            INSF         = CR_SF_ID
            ASYMB = CS_ATYPE(INSF)
            CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
            L1A_SF_ID(I) = INSF
            DO  J=1,MAX1BRN 
              L1A_CONN   (J,I) = 0
              L1A_LENCON (J,I) = 0
            ENDDO
            DO  J=1,MAX1EXT 
              L1A_IEXTR (J,I)  = 0
            ENDDO
C            NCONN_PDB=0
C            NHENT    =0
            GO TO 100
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A,A,A4,A,A)')
     *  ' WARNING: in monomer ',MON,' atom :',CR_ANAME,' is not',
     *  ' in the library list'
        CALL MSGDOC(MDOC,LINE)

 100    CONTINUE

      ELSE IF(L1L_PRSNT.EQ.'N') THEN

        IF(L1A_NATOM.GT.0) THEN
          DO I=1,L1A_NATOM
            IF(L1A_ANAME(I).EQ.CR_ANAME) RETURN
          ENDDO
        ENDIF
        IF(L1A_NATOM.GE.MAX1ATM) THEN
          WRITE(LINE,'(A,A3,A,I6)')
     *  ' ERROR: in "LPUT_NEW", number of atoms in monomer ',MON,' >',
     *  MAX1ATM
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *    '          Change parameter MAX1ATM in "lib_com.fh"')
          IERR=1
          RETURN
        ENDIF

        L1A_NATOM = L1A_NATOM + 1
        L1A_COOR_FLAG(L1A_NATOM) = 'Y'
        IF(CR_OCC.LT.0.0001) L1A_COOR_FLAG(L1A_NATOM) = 'N'
        L1A_CHARG(L1A_NATOM) = 0.0
        L1A_X    (L1A_NATOM) = CR_XYZ(1)
        L1A_Y    (L1A_NATOM) = CR_XYZ(2)
        L1A_Z    (L1A_NATOM) = CR_XYZ(3)
        L1A_INEW (L1A_NATOM) = L1A_NATOM 
        L1A_IOLD (L1A_NATOM) = L1A_NATOM
        L1A_ICR  (L1A_NATOM) = 0
        L1A_NDIST(L1A_NATOM) = 0
        L1A_IBACK(L1A_NATOM) = 0
        L1A_IFORW(L1A_NATOM) = 0
        L1A_BACK (L1A_NATOM) = '.'
        L1A_TYPE (L1A_NATOM) = '.' 
        L1A_FORW (L1A_NATOM) = '.'
        L1A_ANAME(L1A_NATOM) = CR_ANAME
        L1A_SYMB (L1A_NATOM) = CR_ASYMB 
        INSF = CR_SF_ID
        L1A_SF_ID(L1A_NATOM) = INSF
        ICHARGE = 0
        EL_F    = CS_ELEMENT(INSF)
        CALL LENSTR_BL(CS_ELEMENT(INSF),LLL)
        
        IF(CS_ELEMENT(INSF)(1:1).EQ.'?') THEN
          EL_F = CR_ASYMB
        ELSE IF(LLL.GE.3) THEN
          IF(CS_ELEMENT(INSF)(2:2).EQ.'+'.OR.
     *      CS_ELEMENT(INSF)(2:2).EQ.'-'    ) THEN
            EL_F = CS_ELEMENT(INSF)                          
            CH1  = CS_ELEMENT(INSF)(3:3)
            READ(CH1,'(I1)') ICHARGE
            IF(CS_ELEMENT(INSF)(2:2).EQ.'-')ICHARGE=-ICHARGE
          ELSE IF(LLL.GE.4) THEN
            IF(CS_ELEMENT(INSF)(3:3).EQ.'+'.OR.
     *        CS_ELEMENT(INSF)(3:3).EQ.'-'    ) THEN
              EL_F = CS_ELEMENT(INSF)
              CH1  = CS_ELEMENT(INSF)(4:4)
              READ(CH1,'(I1)') ICHARGE
              IF(CS_ELEMENT(INSF)(3:3).EQ.'-')ICHARGE=-ICHARGE
            ENDIF
          ENDIF
        ENDIF
C       CALL CUT_EL_NAME(EL_D)
        CALL CUT_EL_NAME(EL_F)
C       EL_F - element from file (without +/-)

        L1A_SYMB (L1A_NATOM) = EL_F
        L1A_CHARG(L1A_NATOM) = ICHARGE
        L1A_CHEM (L1A_NATOM) = CR_ASYMB 
        L1A_ATYPE(L1A_NATOM) = CR_ATYPE 
        IF(L1A_CHEM(L1A_NATOM)(1:2).NE.'H '.AND.
     *     L1A_CHEM(L1A_NATOM)(1:2).NE.'D ' )
     *     L1A_NHATOM=L1A_NHATOM + 1
        DO  J=1,MAX1BRN 
          L1A_CONN   (J,L1A_NATOM) = 0
          L1A_LENCON (J,L1A_NATOM) = 0
        ENDDO
        DO  J=1,MAX1EXT 
          L1A_IEXTR (J,L1A_NATOM) = 0
        ENDDO
        IF(NHENT.GT.0) THEN
          DO I=1,NHENT
            IF(HENT_ID(I).EQ.L1L_MNAME) THEN
              L1L_NAME = HENT_NAME(I)            
              L1L_FORM = HENT_FORMUL(I)
            ENDIF
          ENDDO
        ENDIF

      ENDIF

      RETURN
      END     

      SUBROUTINE CHECK_CMP_MON5(MMDOC,LIST,CHECK,IG,IR,IAS
     *                      ,NMON_CRT_NEW,MON_NEW,NEW_FLAG,IERR)
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MODE*4,NEW_FLAG*1,MON_NEW*8,LIST*1,CHECK*1
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ---
      CHARACTER LINE*256,MON*8
      CHARACTER ASYMB*4,CTYPE*4,MOD*8,FUNC*3,MONN*8
      CHARACTER ATOM_MISS*4,ATOM_UNK*4,NAMEM*80,CHEMM*4,CHEMU*4
      CHARACTER MONOMER_NEW*8,RES*5,CHAIN*4,MODE_M*4,MTYPE*1
C -----------------------------------
c      COMMON/COM_NMON/ IFIRST_NM,NMON_CRT_NEW
c      INTEGER   IFIRST_NM,NMON_CRT_NEW
C -----------------------------------
C      INTEGER   NMOD_RES
C      CHARACTER MOD_RES(10)*8
      INTEGER   IATOM_UM(9),IATOM_MM(9)      
      CHARACTER ATOM_UM(9)*4,CHEMUM(9)*4,ATOM_MM(9)*4,CHEMMM(9)*4
C --------------------------------------
      IERR = 0
      MDOC = MMDOC
      MD   =-ABS(MDOC)-1
      M    = 99
      IF(LIST.EQ.'S') THEN
        MDOC = 999
        MD   = 999
      ELSE IF(LIST.EQ.'T'.OR.LIST.EQ.'L') THEN
        MD = MDOC
      ENDIF
C --------------
C     NEW_FLAG = 'N'
      IF(L1A_NATOM.LE.0) THEN
        WRITE(LINE,'(A,A,A,I6)')
     *  ' ERROR: number of atoms in monomer (lib) ',L1L_MNAME,' = ',
     *  L1A_NATOM
        CALL MSGERR(MDOC,LINE)
        IERR=1
        RETURN
      ENDIF

      NA        = L1A_NATOM
      MON       = C1_RNAME        
      NATM      = 0
      NATM_MISS = 0
      RES       = C1_PNUM(3:7)
      CHAIN     = C1_PNUM(8:11)

      IF(NA.LE.0.OR.C1_NATOM.LE.0) THEN
        RETURN
      ENDIF

      IFIRST_M=0

      IF(NA.GT.1) THEN
      DO I=1,NA-1
        DO J=I+1,NA
          IF(L1A_ANAME(I).EQ.L1A_ANAME(J)) THEN
            IF(IFIRST_M.EQ.0) THEN
              WRITE(LINE,
     * '('' WARNING : residue: '',A,'' '',A,'' chain:'',A)') 
     *        MON,RES,CHAIN
              CALL MSGDOC(MDOC,LINE)
              IFIRST_M=1
            ENDIF 
            WRITE(LINE,'(A,A,A,A4,A)')
     *' WARNING : ',MON,' : duplicated atom_name (lib) :"',
     * L1A_ANAME(I),'"'
            CALL MSGDOC(MDOC,LINE)
          ENDIF           
        ENDDO
      ENDDO
      ENDIF
C ---
      ATOM_MISS = '    '
      ATOM_UNK  = '    '
      N_MISS    = 0
      DO I=1,NA
        L1A_COOR_FLAG(I) = 'N'
        DO J=1,C1_NATOM
          IF(L1A_ANAME(I).EQ.C1_ANAME(J)) THEN
            IF(C1_OCC(J).GT.0.0001) THEN
              L1A_COOR_FLAG(I) = 'Y'
              L1A_X    (I) = C1_XYZ(1,J)
              L1A_Y    (I) = C1_XYZ(2,J)
              L1A_Z    (I) = C1_XYZ(3,J)
            ENDIF
            GO TO 700
          ENDIF
        ENDDO
        ASYMB = L1A_SYMB(I)
        IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ') THEN
          IF(IFIRST_M.EQ.0) THEN
            WRITE(LINE,
     * '('' WARNING : residue: '',A,'' '',A,'' chain:'',A)') 
     *      MON,RES,CHAIN
            CALL MSGDOC(MDOC,LINE)
            IFIRST_M=1
          ENDIF 
          WRITE(LINE,
     *'( ''           atom: "'',A4,''" is absent in coord_file'')')
     *    L1A_ANAME(I)
          CALL MSGDOC(MDOC,LINE)
          ATOM_MISS  = L1A_ANAME(I)
          CHEMM      = ASYMB
          IATOM_MISS = I
          N_MISS     = N_MISS+1
          IF(NATM_MISS.LT.9) THEN
            NATM_MISS           = NATM_MISS +1
            ATOM_MM (NATM_MISS) = ATOM_MISS
            CHEMMM  (NATM_MISS) = ASYMB
            IATOM_MM(NATM_MISS) = I
          ENDIF
        ENDIF
 700    CONTINUE
      ENDDO


      N_UNKNOW=0
      DO J=1,C1_NATOM
        DO I=1,NA
          IF(L1A_ANAME(I).EQ.C1_ANAME(J)) GO TO 701
        ENDDO
        ASYMB = C1_ASYMB(J)
        IF(ASYMB(1:2).NE.'H '.AND.ASYMB(1:2).NE.'D ') THEN
          IF(IFIRST_M.EQ.0) THEN
            WRITE(LINE,
     * '('' WARNING : residue: '',A,'' '',A,'' chain:'',A)') 
     *      MON,RES,CHAIN
            CALL MSGDOC(MDOC,LINE)
            IFIRST_M=1
          ENDIF 
          WRITE(LINE,
     *'(''           atom: "'',A4,''" is absent in lib description.'')')
     *     C1_ANAME(J)
          CALL MSGDOC(MDOC,LINE)
          ATOM_UNK = C1_ANAME(J)
          CHEMU    = ASYMB
          IF(NATM.LT.9) THEN
            NATM           = NATM +1
            ATOM_UM (NATM) = ATOM_UNK
            CHEMUM  (NATM) = ASYMB
            IATOM_UM(NATM) = J
          ENDIF
          IATOM_UNK = J
          N_UNKNOW  = N_UNKNOW+1
        ENDIF
 701    CONTINUE
      ENDDO
C --       check compliteness,alt_name: 
C --       if(n_unknown >= n_miss > 0 ) --> check  
C
C          UNK   MISS
C
C           0     0    return
C          =<9    0    /no MAD/ return 
C           0    =<9   MDL
C           1     1    synonym (if chem=chem),return / REP
C           2     2           -"-"-                  / check
C
C          else check
C 

      IF(LIST.EQ.'T') THEN
        WRITE(LINE,
     *    '('' N_UNK,N_MISS: '',2I5)') 
     *    N_UNKNOW,N_MISS
        CALL MSGDOC(MDOC,LINE)
      ENDIF


      FUNC=' '
      IF(N_UNKNOW.LE.0.AND.N_MISS.LE.0) THEN
C       OK
        RETURN
      ELSE IF(N_UNKNOW.GT.0.AND.N_MISS.EQ.0) THEN
C       Nc > Nl
C       OK
        RETURN
      ELSE IF(N_UNKNOW.EQ.0.AND.N_MISS.GT.0) THEN
C       Nc < Nl
C       OK
        RETURN
      ELSE IF(N_UNKNOW.EQ.1.AND.N_MISS.EQ.1) THEN

        IF(CHEMU.EQ.CHEMM) THEN 
          C2_ANAME(IATOM_UNK) = L1A_ANAME(IATOM_MISS)
C         OK

          IF(LIST.EQ.'T') THEN
          WRITE(LINE,*)'U,M:',C2_ANAME(IATOM_UNK),L1A_ANAME(IATOM_MISS)
          CALL MSGDOC(MDOC,LINE)
          ENDIF

          RETURN
        ENDIF

      ELSE IF(N_UNKNOW.EQ.2.AND.N_MISS.EQ.2) THEN

        IF((CHEMUM(1).EQ.CHEMMM(1)).AND.(CHEMUM(2).EQ.CHEMMM(2)).OR.
     *     (CHEMUM(2).EQ.CHEMMM(1)).AND.(CHEMUM(1).EQ.CHEMMM(2))) THEN
          IF(CHEMUM(1).EQ.CHEMMM(1)) THEN
            IU1 = IATOM_UM(1)
            IU2 = IATOM_UM(2)
          ELSE
            IU1 = IATOM_UM(2)
            IU2 = IATOM_UM(1)
          ENDIF
          IM1 = IATOM_MM(1)
          IM2 = IATOM_MM(2)

          IF(LIST.EQ.'T') THEN
            WRITE(LINE,*)'CHEM:',CHEMUM(1),CHEMMM(1),CHEMUM(2),CHEMMM(2)
            CALL MSGDOC(MDOC,LINE)
            WRITE(LINE,*) IM1,IM2,IU1,IU2
            CALL MSGDOC(MDOC,LINE)
          ENDIF

          C2_ANAME(IU1) = L1A_ANAME(IM1)
          C2_ANAME(IU2) = L1A_ANAME(IM2)
C         OK    
          RETURN
        ENDIF

      ENDIF   
C
C     create new for: MON_NEW  = MONOMER_NEW (new_name) 
C                     NEW_FLAG = 'Y' 
C
      IF(NMON_CRT_NEW.GE.99) RETURN

      I = NMON_CRT_NEW + 1

 100  CONTINUE

      IF(I.GE.99) RETURN

      WRITE(MONOMER_NEW,'(I3)') I            
      MONOMER_NEW(1:1) = 'N'
      IF(MONOMER_NEW(2:2).EQ.' ') THEN
        MONOMER_NEW(2:2) = MONOMER_NEW(3:3)
        MONOMER_NEW(3:3) = ' '
      ENDIF

      CALL LENSTR_BL(MONOMER_NEW,LEN)
      CALL LENSTR_BL(MON,LM)
      MON_NEW = MON(1:LM)//'_'//MONOMER_NEW(1:LEN)

      CALL CHECK_MON_NAME_IN_LIB(MON_NEW,IERR)
      IF(IERR.EQ.0) THEN
        I = I + 1
        GO TO 100
      ELSE
        IERR = 0
      ENDIF

      NMON_CRT_NEW = I

      C1_RNAME  = MON_NEW      
      L1L_MNAME = MON_NEW
      L1L_TYPE  = C1_RTYPE 
      NEW_FLAG  = 'Y'
      L1L_PRSNT = 'N'
c --
        L1L_MNAME2= '.'
        L1L_NAME  = '.'
        L1L_CODE1 = 'x'
        L1L_TYPE  = 'non-polymer'
        L1L_MODE  = '.'
        L1L_FORM  = '.'
        L1L_FUSE  = '?'
        L1L_HFLAG = '.'
        L1L_NATM  = C1_NATOM
        L1L_NHATM = 0
        L1A_NATOM = C1_NATOM
        L1A_NHATOM= 0
        L1N_NCONN = 0
        L1B_NBOND = 0
        L1G_NANGL = 0
        L1T_NTORS = 0
        L1C_NCHIR = 0
        L1P_NPLAN = 0
        DO I=1,C1_NATOM
          L1A_COOR_FLAG(I) = 'Y'
          IF(C1_OCC(I).LT.0.0001) L1A_COOR_FLAG(I) = 'N'
          L1A_X    (I) = C1_XYZ(1,I)
          L1A_Y    (I) = C1_XYZ(2,I)
          L1A_Z    (I) = C1_XYZ(3,I)
          L1A_CHARG(I) = S1_CHAR(I) 
          L1A_INEW (I) = I
          L1A_IOLD (I) = I
          L1A_ICR  (I) = 0
          L1A_NDIST(I) = 0
          L1A_IBACK(I) = 0
          L1A_IFORW(I) = 0
          L1A_BACK (I) = '.'
          L1A_TYPE (I) = '.' 
          L1A_FORW (I) = '.'
          L1A_ANAME(I) = C1_ANAME(I)
          L1A_CHEM (I) = S1_CHEM (I)
          L1A_SYMB (I) = C1_ASYMB(I) 
          ASYMB = CS_ATYPE(C1_SF_ID(I))
          CALL CHKASYM(MDOC,ASYMB,INSF,IERR)
          L1A_SF_ID(I) = INSF
          L1A_CHEM (I) = L1A_SYMB(I) 
          L1A_ATYPE(I) = C1_ATYPE(I)
          DO  J=1,MAX1BRN 
            L1A_CONN   (J,I) = 0
            L1A_LENCON (J,I) = 0
          ENDDO
          DO  J=1,MAX1EXT 
            L1A_IEXTR (J,I)  = 0
          ENDDO
        ENDDO
C -------------------------------------------------
      RETURN
      END

      SUBROUTINE CHECK_DESCR_STRUCTURE(MMDOC,LIST,CHECK_SPEC
     *  ,DMIN_SPEC,CONN_FLAG,CIS_FLAG,LNK_FLAG,CHAIN_FLAG
     *  ,DNEW,NEW_FLAG,SS_FLAG,SUGAR_FLAG,CHECK,COOR,IERR)    
C -----------------------------------------------
C -P- CHECK_DESRC_STRUCTURE - 
C 
C     1. check atoms in special position.
C        ( if DMIN_SPEC > 0 )
C
C     2. check list of links. 
C
C     3. check chain connectivity, set residue"s conn_type
C        check type of peptide link: 'CIS' or 'TRANS' and
C        change it if CIS_FLAG = 'Y' 
C
C     4. check inter/intra chain links
C        if not in the dictionary: create it /set DNEW='Y'/
C        ( if LNK_FLAG = 'Y' )
C
C     5. check inter chain's connectivity 
C        if not in the dictionary: create it /set DNEW='Y'/
C        check actual distance: if big  - link will be ignored.      
C        ( if CONN_FLAG = 'Y' )
C
C     6. create new list of chains and set type of terminus residues.
C
C     7. check completeness of atom's list of residue.
C  --------------
C
C  input:
C
C     CONN_FLAG  - Y means : check & create new list of chains
C                                 create new list of links ( cis, ss, ...)
C                                 and modifications
C 
C     DMIN_SPEC  - minimum distance for special position / -1 not check /
C
C  output:
C
C     DNEW       - output flag for links. Y news new link was created.
C     NEW_FLAG   - output flag. Y means new monomer was found.
C
C --------------------------------------
C     atm_type() must be : H/D or C or $ ( setting in PRE_DESCR )
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER DNEW*1,NEW_FLAG*1,NAME*80,CHAIN_FLAG*1,SS_FLAG*1
      CHARACTER CONN_FLAG*1,CHECK_SPEC*1,CIS_FLAG*1,LNK_FLAG*1
      CHARACTER SUGAR_FLAG*1,LIST*1,CHECK*1,COOR*1
C ******
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'link_com.fh'
C -----------------------------------------------------------
      IERR = 0
      MDOC = MMDOC
      MD   =-ABS(MDOC)-1
      IF(LIST.EQ.'S') MDOC = 999
      IF(LIST.EQ.'T') MD   = MDOC

      DNEW     = 'N'
      LSO_NSYM = CS_NSYM
      NSUG     = 0

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MD,' --- CHECK_DESCR_STRUCTURE --- ')
        CALL PRINT_INFO_TEST(MD)
      ENDIF

      LN_N_INIT  = LN_N

C ---
      CALL DEF_SPEC_POS(MDOC,CHECK_SPEC,DMIN_SPEC,IERR)
      IF(IERR.NE.0) RETURN

 
c       CALL DEF_LINK_MOD(MDOC,DNEW,IERR)
c       IF(IERR.NE.0) RETURN
      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MD,' --- DEF_CONN --- ')
      ENDIF

      IF(CONN_FLAG.NE.'0') THEN
        CALL DEF_CONN(MMDOC,LIST,CONN_FLAG,CIS_FLAG,SUGAR_FLAG
     *             ,LN_N_INIT,DNEW,NSUG,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MD,' --- DEF_LINK_NEW --- ')
      ENDIF

      IF(LNK_FLAG.NE.'0') THEN
        CALL DEF_LINK_NEW(MDOC,LIST,LNK_FLAG,SS_FLAG,SUGAR_FLAG
     *                 ,LN_N_INIT,DNEW,NSUG,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      IF(LIST.EQ.'T') THEN
        Write(*,*) '--> nsug: ',nsug,N_GROUP
      ENDIF
     
      IF(CHAIN_FLAG.EQ.'Y'.OR.NSUG.GT.0) THEN

        IF(LIST.EQ.'T') THEN
          CALL MSGDOC(MD,' --- SET_CHAIN --- ')
          CALL PRINT_INFO_TEST(MD)
        ENDIF

        CALL SET_CHAIN(MDOC,SUGAR_FLAG,CHAIN_FLAG,LIST,IERR)
        IF(IERR.NE.0) RETURN

        IF(LIST.EQ.'T') THEN
          CALL MSGDOC(MD,' --- SET_MOD --- ')
          CALL PRINT_INFO_TEST(MD)
        ENDIF

        CALL SET_MOD(MDOC,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF

      IF(LIST.EQ.'T') THEN
        CALL MSGDOC(MD,' --- CREAT_ENT_DESCR --- ')
        CALL PRINT_INFO_TEST(MD)
      ENDIF

      CALL CREAT_ENT_DESCR(MDOC,LIST,IERR)
      IF(IERR.NE.0) RETURN

c      IF(LIST.EQ.'T') THEN
c        CALL MSGDOC(MD,' --- CHECK_MTCH --- ')
c        CALL PRINT_INFO_TEST(MD)
c      ENDIF

c      NAME='makecif'
c      CALL CHECK_MTCH(MMDOC,LIST,NAME,NEW_FLAG,DNEW,CHECK,COOR,IERR)
c      IF(IERR.NE.0) RETURN

      RETURN
      END


      SUBROUTINE SET_IDLIM(ASYMB,ITYPE)
C -------------------------------
C     set atom's type of limit of covalent bond
C
C      ITYPE               DLIM:  
C         1 - H or D        1.2
C         2 - others        1.7
C         3 - P or S        2.4
C         4 - heavy atom    3.0
C
C      DATA DLIM/ 1.2, 1.7, 2.4, 3.0 / in DEF_CONN_NEW /
C --------------------------------
      CHARACTER ASYMB*4
      CHARACTER CH2*2
C --
      INCLUDE 'metal.fh'
C --
C      PARAMETER (N_NAME = 33)
C      CHARACTER NAME(N_NAME)*2
C -----------------
C      DATA NAME/'CO','MG','CA','ZN','CU','FE','CL','BR','MN','PB',
C     *          'HG','AL','GD','NA','CD','NI','SR','IN','HO','YB',
C     *          'TE','LI','RB','BA','CS','SM','TL','PT','BE','SE',
C     *          'MO','SI','I '/
C ??? more
C --
C ---------------------------------------------
      CH2 = ASYMB(1:2)
      DO  I=1,N_NAME
        IF(NAME(I).EQ.CH2) THEN
          ITYPE = 4
          GO TO 100
        ENDIF
      ENDDO
      IF(ASYMB.EQ.'H   '.OR.ASYMB.EQ.'D   ') THEN
        ITYPE = 1
      ELSE IF(ASYMB.EQ.'P   '.OR.ASYMB.EQ.'S   ') THEN
        ITYPE = 3
      ELSE
        ITYPE = 2
      ENDIF
  100 CONTINUE

      RETURN
      END


C ******
      SUBROUTINE DEF_LINK_NEW(MDOC,LIST,LNK_FLAG,SS_FLAG,SUGAR_FLAG
     *                  ,LN_N_INIT,DNEW,NSUG,IERR)
      implicit none
C -----------------------------------------------
C     check inter/intra chain links
C        if not in the dictionary: create it /set DNEW='Y'/
C               
C        LNK_FLAG - Y - use new link, N - just warning message
C        DNEW      - output info flag  
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,LN_N_INIT
      integer nsug
      CHARACTER DNEW*1
      CHARACTER LNK_FLAG*1,SS_FLAG*1,SUGAR_FLAG*1
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ----------------------------------------------------------------
      INCLUDE 'link_com.fh'
C -----------------------------------
      REAL      XX1(3),XX2(3),XX3(3),XX4(3)
      CHARACTER MON1*8,MON2*8,ATOM1*4,ATOM2*4,MOD1*8,MOD2*8,LINKS*8
      CHARACTER LINK*8,ALT1*1,CORR1*1,ALT2*1,CORR2*1,MON_N*8,LINK_NEW*8
      CHARACTER LLL_FLAG*1,USER*1,SUG*1,LIST*1
      CHARACTER ASYMB1*4,ASYMB2*4,FLAG*1,COOR_FLAG*1,ATOM*4
      character achem1*4,achem2*4
      CHARACTER LINE*256
      CHARACTER DEF_FLAG*1,CNEW*1,MTYPE*1,SYMM1*8,SYMM2*8,SS*1
      CHARACTER ALT1_C*1,ALT2_C*1,CONN*1,CH1*1
c
c---
      integer ic,ich1,ich2,iln,idm,iok,insf,icatom1,icatom2,inew,ilink
      integer iout,it,it1,it2,it3,it4,itype1,itype2,lnew,irevers,len
      integer irs1,irs2,irf1,irf2,irr1,irr2
      integer id,i,j,i1,j1,ia,ia1,ia2,ja,iaf1,iaf2,ias1,ias2
      real dist_idl,dist,dideal,ph,volobs
      real dx,dy,dz,xi,yi,zi,xj,yj,zj
      integer ivfile
      real dlim_cont
      character vdw_file_link*512
      integer nvdw,nvdw1
      integer, allocatable :: ia_1(:,:),nvdw_s(:,:)
      character(len=8), allocatable :: res_name_mod(:)
      integer idmax
      PARAMETER ( IDMAX = 4 )
      REAL      DLIM(IDMAX)
      DATA DLIM/ 1.2, 1.9, 2.5, 3.0 /
C -----------------------------------
      IERR  = 0
      IF(N_GROUP.LE.0.OR.N_ATOM.LE.0) THEN
        IERR=1
        RETURN
      ENDIF
c
c---  Find all contacts. To do: Find properly maximun bond distance
      dlim_cont = dlim(idmax)
      call find_unique_file_name(vdw_file_link,'_vdw_link')
      call find_all_contacts(dlim_cont,maxatom,n_atom,xyz_crd,occup,
     &     maxnso,cs_nsym,cs_m_cs,cs_v_cs,cs_cell,
     &     vdw_file_link,ierr)
      call open_unform_file(ivfile,vdw_file_link,ierr)
      read(ivfile)nvdw
      if(nvdw.le.0) then
         close(ivfile,status='DELETE')
         return
      endif
      allocate(ia_1(2,nvdw))
      allocate(nvdw_s(4,nvdw))
      do id=1,nvdw
         read(id)ia_1(1:2,id),nvdw_s(1:4,id)
      enddo
      close(ivfile,status='DELETE')
c
      if(nvdw.le.0) return
      allocate(res_name_mod(n_residue))
      do irs1=1,n_residue
         mon1 = res_name(irs1)
         ich1 = i_chain(irs1)
         call mod_change_mon_name(mon1,irs1,ich1)
         res_name_mod(irs1) = mon1
      enddo
      call vdw_remove_intraresidue(nvdw,nvdw1,ia_1(1:2,1:nvdw),
     &     nvdw_s(1:4,1:nvdw),res_name_mod)
      nvdw = nvdw1
      deallocate(nvdw_s)
c
      NCONN_PDB = 0
      nsug = 0
      do id=1,nvdw
         ia = ia_1(1,id)
         ja = ia_1(2,id)
         i = i_resid(ia)
         j = i_resid(ja)
         ich1 = i_chain(i)
         ich2 = i_chain(j)
         IRS1 = IRES_START_TREE(ICH1)
         IRF1 = IRES_END_TREE  (ICH1)
         IRS2 = IRES_START_TREE(ICH2)
         IRF2 = IRES_END_TREE  (ICH2)
         ICONN_TYPE(IRS1) = 1

         MON1   = res_name_mod(i)
         ITYPE1 = IRES_TYPE(I)
         MON2   = res_name_mod(j)
         ITYPE2 = IRES_TYPE(J)
c
c---Careful here. It should be done in remove_intra
         CONN = 'N'
         i1 = ires_forw(i)
         j1 = ires_forw(j)
         IF(ICH1.EQ.ICH2.AND.(J.EQ.I1.or.j1.eq.i)) CONN = 'Y'

C           possible user's link.
c---  It should check all links between these residues and if there is any 
c---  then this particular link should not be used
         USER     = 'N'
         IF(LN_N_INIT.GT.0) THEN
            DO ILN=1,LN_N_INIT
               IF((LN_1IRES(ILN).EQ.I   .AND.
     *              LN_2IRES(ILN).EQ.J   .AND.
     *              LN_1ICHN(ILN).EQ.ICH1.AND.
     *              LN_2ICHN(ILN).EQ.ICH2           ).OR.
     *              (LN_2IRES(ILN).EQ.I   .AND.
     *              LN_1IRES(ILN).EQ.J   .AND.
     *              LN_2ICHN(ILN).EQ.ICH1.AND.
     *              LN_1ICHN(ILN).EQ.ICH2           )    )THEN
                  IF(LN_ID(ILN).NE.'gap') THEN
                     SYMM1 = LN_SYMM1(ILN)
                     SYMM2 = LN_SYMM2(ILN)
                     USER     = 'P'
                  ENDIF
               ENDIF
            ENDDO
         ENDIF
c ----
         IF(USER.EQ.'P') THEN
c
C---  potential links      
            ATOM1  = ATM_NAME(IA)
            INSF   = ID_SF(IA)  
            ASYMB1 = CS_ATYPE (INSF)
            achem1 = atm_chem(ia)
c
c---Find more accurate bond "radius"
            CALL SET_IDLIM(ASYMB1,ICATOM1)
            XI    = XYZ_CRD(1,IA)
            YI    = XYZ_CRD(2,IA)
            ZI    = XYZ_CRD(3,IA)
            ALT1  = ID_ALT   (IA)    
            CORR1 = ID_CORR  (IA)    
            
            INSF   = ID_SF(JA)  
            ASYMB2 = CS_ATYPE (INSF)
            achem2 = atm_chem(ja)
            
            CALL SET_IDLIM(ASYMB2,ICATOM2)
            
            ATOM2 = ATM_NAME (JA)
            XJ    = XYZ_CRD(1,JA)
            YJ    = XYZ_CRD(2,JA)
            ZJ    = XYZ_CRD(3,JA)
            ALT2  = ID_ALT   (JA)    
            CORR2 = ID_CORR  (JA)      
c
C---  SS-link ? To do: It needs to be redone as a separate loop
            LLL_FLAG = LNK_FLAG
            SS = 'N'
            IF(ATOM1.EQ.'SG  '.AND.
     *           (MON1.EQ.'CYS'.OR.MON1.EQ.'MPR').AND.
     *           ATOM2.EQ.'SG  '.AND.
     *           (MON2.EQ.'CYS'.OR.MON2.EQ.'MPR')) SS = 'Y'
            IF(SS.EQ.'Y') LLL_FLAG = SS_FLAG
            IF(CONN.EQ.'Y'.AND.SS.EQ.'N') GO TO 200
c
C---  sugar-link ?
            SUG = 'N' 
            IF(ITYPE1.EQ.7.OR.ITYPE1.EQ.8.OR.
     *           ITYPE2.EQ.7.OR.ITYPE2.EQ.8    ) SUG = 'Y'
            IF(SUG.EQ.'Y') LLL_FLAG = SUGAR_FLAG
c
C---  possible  link
            LINKS = ' '
            CALL CHECK_LINK_INFO(LINKS,MON1,MON2
     *           ,ATOM1,ATOM2,DIDEAL,ILINK)
c
c----
            IF(ILINK.GT.0) THEN
               LINKS = LLL_LNAME(ILINK)                         
               IF(SUG.EQ.'Y') THEN
                  IF(SUGAR_FLAG.EQ.'S') THEN
                     IF(LINKS(1:4).EQ.'BETA'.OR.LINKS(1:4).EQ.'ALPH'
     *                    .OR.LINKS.EQ.'MAN-SER'.OR.LINKS.EQ.'NAG-SER'
     *                    .OR.LINKS.EQ.'MAN-THR'.OR.LINKS.EQ.'NAG-THR'
     *                    .OR.LINKS.EQ.'MAN-ASN'.OR.LINKS.EQ.'NAG-ASN'
     *                    .OR.LINKS.EQ.'XYS-SER'.OR.LINKS.EQ.'NAG-THR'
     *                    .OR.LINKS.EQ.'XYS-ASN') THEN
                        LLL_FLAG = 'Y'
                     ELSE
                        LLL_FLAG = 'N'
                     ENDIF
                  ENDIF
               ENDIF
            ELSE
               IF(SUG.EQ.'Y'.AND.SUGAR_FLAG.EQ.'S') THEN
                  LLL_FLAG = 'N'
               ENDIF
            ENDIF
C     user's link
            IF(LN_N_INIT.GT.0.AND.USER.EQ.'P') THEN
               DO ILN=1,LN_N_INIT
                  ALT1_C = ALT1  
                  ALT2_C = ALT2  
                  IF(LN_USED(ILN).NE.'S') THEN
                     ALT1_C = '.'
                     ALT2_C = '.'
                  ENDIF
                  IOK = 0                          
                  IF(LN_1IRES(ILN).EQ.I   .AND.
     *                 LN_2IRES(ILN).EQ.J   .AND.
     *                 LN_1ICHN(ILN).EQ.ICH1.AND.
     *                 LN_2ICHN(ILN).EQ.ICH2.AND.           
     *                 LN_ATOM1(ILN)(1:4).EQ.ATOM1.AND.
     *                 LN_ATOM2(ILN)(1:4).EQ.ATOM2     ) THEN
                     IOK = 1
                  ELSE IF(LN_2IRES(ILN).EQ.I.AND.
     *                    LN_1IRES(ILN).EQ.J   .AND.
     *                    LN_2ICHN(ILN).EQ.ICH1.AND.
     *                    LN_1ICHN(ILN).EQ.ICH2.AND.      
     *                    LN_ATOM2(ILN)(1:4).EQ.ATOM1.AND.
     *                    LN_ATOM1(ILN)(1:4).EQ.ATOM2) THEN
                     IOK = 1
                     CH1 = ALT1_C  
                     ALT1_C = ALT2_C  
                     ALT2_C = CH1 
                  ENDIF
                  IF(IOK.EQ.1) THEN
                     IF(LN_ID(ILN).NE.'gap'.AND.
     *                    LN_ID(ILN).NE.'?'       ) THEN
                        IF((LN_ALT1 (ILN).EQ.ALT1_C .AND.
     *                       LN_ALT2 (ILN).EQ.ALT2_C      ).AND.
     *                       (ALT1.EQ.ALT2.OR.
     *                       LN_USED(ILN).EQ.'S') )THEN
                           SYMM1 = LN_SYMM1(ILN)
                           SYMM2 = LN_SYMM2(ILN)
                           IF((SYMM1.EQ.'.'.OR.SYMM1.EQ.'1_555').AND.
     *                          (SYMM2.EQ.'.'.OR.SYMM2.EQ.'1_555')) THEN
                              IF(LLL_FLAG.NE.'D') THEN
                                 USER  = 'Y'
                                 LINKS = LN_ID(ILN)
                                 GO TO 100
                              ELSE
                                 LN_ID(ILN) = '?'
                              ENDIF
                           ENDIF
                        ENDIF
                     ENDIF
                  ENDIF
               ENDDO
C     25.11.03           user's link not found go to next atoms
               GO TO 200
            ENDIF
C     ??? 21.11.03. To do? It needs to be done in remove_intra
            IF(ALT1.NE.'.'.AND.ALT2.NE.'.'.AND.
     *           ALT1.NE.ALT2) GO TO 200 
C ???

            ILN = 0
 100        CONTINUE
C     check distance
            DX   = XI-XJ
            DY   = YI-YJ
            DZ   = ZI-ZJ
            DIST = SQRT(DX*DX+DY*DY+DZ*DZ)
            FLAG  = 'N'
c
c---- dlim needs to be found
            IF(DIST.LE.DLIM(IC)) THEN
C     there is connection
               FLAG = 'Y'
               IF(LLL_FLAG.NE.'N') THEN
C     use it
                  CNEW = 'N'
               ELSE
C     only message
                  CNEW = 'Y'
               ENDIF
            ENDIF
            IF(USER.EQ.'Y') THEN
               FLAG = 'Y'
               CNEW = 'N'
            ENDIF                  
            IF(FLAG.EQ.'Y') THEN
C     link is found
               MOD1    = '.'
               MOD2    = '.'          
               IREVERS = 0
C     --- LINK ---
               CALL LOOK_LINK(LINKS,MON1,ATOM1,MON2,ATOM2
     *              ,ITYPE1,ITYPE2,ILINK,MOD1,MOD2,IREVERS)
               IF(ILINK.LE.0) THEN
c                  call report_potential_link()
C     new link description will be created /if CNEW='N'/
                  CALL LENSTR_BL(LINKS,LEN)
                  LINK  = ' '
                  CALL GET_DEFAULT_VBOND(MDOC,achem1,achem2
     *                 ,DIST_IDL,DEF_FLAG,IERR)
                  IF(IERR.NE.0) RETURN
                  IF(CNEW.EQ.'N') THEN
C     use it 
                     IF(LEN.GT.0) LINK = LINKS
                     CALL CREAT_LINK(MDOC,LINK,INEW,LNEW,ILINK
     *                    ,ITYPE1,ITYPE2,MON1,ATOM1
     *                    ,MOD1,MON2,ATOM2,MOD2,DIST_IDL,IERR)
                     IF(IERR.NE.0) RETURN
                     IF(INEW.EQ.1) THEN
C     output flag about "new" was used
                        DNEW = 'Y'
                        IF(ILN.GT.0) THEN
                           IF(LN_DIST(ILN).GT.0.01) THEN
                              DIST_IDL = LN_DIST(ILN) 
                           ENDIF
                        ENDIF
                               
                        WRITE(LINE,'(A,A8,A)')
     *           ' WARNING : description of link:',LINK
     *            ,' is not in the dictionary.'
                        CALL MSGDOC(MDOC,LINE)
                        WRITE(LINE,
     * '(''           link will be created with bond_lenth ='',F8.3)') 
     *                       DIST_IDL
                        CALL MSGDOC(MDOC,LINE)
                     ENDIF
                  ENDIF
               ELSE
                  CALL GET_IDL_BOND_LENTH(ILINK,DIST_IDL)
                  LINK  = LLL_LNAME(ILINK)                         
                  call find_best_sugar_link(link,ilink,ia,ja,ierr)
               ENDIF
               IF(ILINK.GT.0.AND.CNEW.EQ.'N') THEN
c 
C---  this link will be used ( because CNEW.EQ.'N')
                  LINK  = LLL_LNAME(ILINK)                         
                  WRITE(LINE,'(A,A8,A,F10.3,A,F10.3)')
     *' WARNING : link:',LINK,' is found dist =',DIST,
     *                 ' ideal_dist=',DIST_IDL
                  IF(ILN.GT.0) THEN
                     IF(LN_USED(ILN).EQ.'S') THEN                        
                        WRITE(LINE,'(A,A8,A,F10.3,A,F10.3)')
     *' WARNING : link(spec):',LINK,' is found dist =',DIST,
     *                             ' ideal_dist=',DIST_IDL
                     ENDIF
                  ENDIF
                  CALL MSGDOC(MDOC,LINE)

                  WRITE(LINE,'(3A,A5,3A,A4,A1,3A,A5,3A,A4,A1)')
     *'           ch:',GROUP_ID(ICH1),' res:',RES_NUM_PDB(I)(3:7),
     *' ',RES_NAME(I),' at:',ATOM1,ALT1,'->',GROUP_ID(ICH2),
     *' res:',RES_NUM_PDB(J)(3:7),' ',RES_NAME(J),' at:',ATOM2,ALT2
                  CALL MSGDOC(MDOC,LINE)                    
                  
                  IF(ILN.LE.0) THEN
                     CALL PUT_L_TABL(MDOC,LINK,ICH1,ICH2
     *                    ,I,J,IA,JA,IREVERS,IERR)
                     IF(IERR.NE.0) RETURN
                  ELSE
                     LN_ID(ILN) = LINK
                  ENDIF
                  MON_N = '   '
                  MTYPE = 'Y'
                  IF(ILN.GT.0) MTYPE = 'N'
               ENDIF
               IF(MTYPE.NE.'N') THEN
                  CALL PUT_M_TABL(MDOC,MOD1,ICH1
     *                 ,I,IA,MON_N,MTYPE,IERR)
                  IF(IERR.NE.0) RETURN
                  CALL PUT_M_TABL(MDOC,MOD2,ICH2
     *                 ,J,JA,MON_N,MTYPE,IERR)
                  IF(IERR.NE.0) RETURN
               ENDIF
c     for link: TRANS,CIS,p
               IF(LINK.EQ.'TRANS'.OR.LINK.EQ.'CIS'.OR.
     *              LINK.EQ.'PTRANS'.OR.LINK.EQ.'PCIS'.OR.
     *              LINK.EQ.'NMTRANS'.OR.LINK.EQ.'NMCIS'.OR.
     *              LINK.EQ.'p') THEN
                  IF(I.EQ.IRS1) ITERM_S_TYPE(ICH1) = 7
                  IF(I.EQ.IRF1) ITERM_F_TYPE(ICH1) = 7
                  IF(J.EQ.IRS2) ITERM_S_TYPE(ICH2) = 7
                  IF(J.EQ.IRF2) ITERM_F_TYPE(ICH2) = 7
               ENDIF
               IF((ITYPE1.EQ.7.OR.ITYPE1.EQ.8).AND.
     *              (ITYPE2.EQ.7.OR.ITYPE2.EQ.8).AND.
     *              SUG.EQ.'Y') NSUG = NSUG +1
            ELSE IF(CNEW.EQ.'Y') THEN
               WRITE(LINE,'(A,F8.3,A,F8.3)')
     *' INFO:     link is found (not be used) dist=',DIST
     *                   ,' ideal_dist=',DIST_IDL
               CALL MSGDOC(MDOC,LINE)                  
               WRITE(LINE,'(3A,A5,3A,A4,A1,3A,A5,3A,A4,A1)')
     *'           ch:',GROUP_ID(ICH1),' res:',RES_NUM_PDB(I)(3:7),
     *' ',RES_NAME(I),' at:',ATOM1,ALT1,'->ch:',GROUP_ID(ICH2),
     * ' res:',RES_NUM_PDB(J)(3:7),' ',RES_NAME(J),' at:',ATOM2,ALT2
               CALL MSGDOC(MDOC,LINE)
            ENDIF
C --- LINK ---
         ENDIF
 200     CONTINUE         
 800     CONTINUE          
 300     CONTINUE
 400     CONTINUE
 500     CONTINUE
 600     CONTINUE
      enddo
      deallocate(ia_1)

      RETURN
      END

      SUBROUTINE GET_IDL_BOND_LENTH(L,DIST_IDL)
C ----------------------------------------
      INCLUDE 'lib_com.fh'
C -----------------------------------------
      DIST_IDL = 0.0
      IF(L.LE.0.OR.L.GT.LLL_NLINK) RETURN
      IF(LLB_NBOND.GT.0.AND.LLL_IBOND(L).GT.0) THEN
        DO IB = LLL_IBOND(L),LLB_NBOND
          IF(LLL_LNAME(L).EQ.LLB_LNAME(IB)) THEN
            DIST_IDL = LLB_VAL(IB)
            RETURN
          ENDIF
        ENDDO
      ENDIF
      RETURN
      END

      SUBROUTINE GET_DEFAULT_VBOND(MDOC,CHEM1,CHEM2,VAL,DEF_FLAG,IERR)
C ----------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
C     INCLUDE 'ener_com.fh'
C ---
      CHARACTER CHEM1*4,CHEM2*4,DEF_FLAG*1
C     CHARACTER LINE*256
C -----------------------------------------
      IERR = 0

      DEF_FLAG ='N'
      VAL      = 0.0
      DO K=1,LEB_NBOND
         IF((LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K).EQ.CHEM2).OR.
     *      (LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K).EQ.CHEM1))
     *   THEN
           VAL = LEB_LENGTH(K) 
           GO TO 400
         ENDIF
      ENDDO
      D1 = 0.0
      D2 = 0.0
      DO K=1,LEB_NBOND
        IF(LEB_1ATM(K).EQ.CHEM1.AND.LEB_2ATM(K)(1:1).EQ.'.')
     *    D1 = LEB_LENGTH(K)
        IF(LEB_1ATM(K).EQ.CHEM2.AND.LEB_2ATM(K)(1:1).EQ.'.')
     *    D2 = LEB_LENGTH(K)
      ENDDO
      IF(D1.GT.0.0.AND.D2.GT.0.0) THEN
        DA  = (D1+D2)/2.0
        VAL = DA 
       ENDIF
      IF(VAL.LE.0.0) VAL = 1.5
      DEF_FLAG = 'Y'
 400  CONTINUE

      RETURN
      END

C ******
      SUBROUTINE DEF_LINK_MOD(MDOC,LIST,DNEW,IERR)
C -----------------------------------------------
C        check list of links. (user's definition)
C        if description is not in the dictionary: create it 
C
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER DNEW*1,LIST*1
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ----------------------------------------------------------------
      CHARACTER MON1*8,MON2*8,ATOM1*4,ATOM2*4,MOD1*8,MOD2*8
      CHARACTER LINK*8
      CHARACTER ASYMB1*4,ASYMB2*4,DEF_FLAG*1,MON_N*8,MTYPE*1
      CHARACTER LINE*256
C     CHARACTER LINKS*8,ALT1*1,CORR1*1,ALT2*1,CORR2*1,FLAG*1
C -----------------------------------
      IERR  = 0

      IF(LIST.EQ.'T') THEN
        CALL MSGERR(MDOC,' -- DEF_LINK_MOD')
        write(LINE,*) '==>LN_N',LN_N    
        CALL MSGERR(MDOC,LINE)
      ENDIF

      IF(LN_N.GT.0) THEN
C
C     check list of links. 
C
        DO ILN=1,LN_N

          ICH1   = LN_1ICHN (ILN)
          IR1    = LN_1IRES (ILN)

          IF(ICH1.LE.0.OR.IR1.LE.0) THEN
            LN_ID(ILN)(1:1) = '?'
            GO TO 320
          ENDIF

          MON1   = RES_NAME (IR1)
         
          ITYPE1 = IRES_TYPE(IR1)

          IF(MOD_N.GT.0) THEN
            DO IM = 1,MOD_N
              IF(MOD_IRES   (IM).EQ.IR1 .AND.
     *          MOD_ICHN    (IM).EQ.ICH1.AND.
     *          MOD_RNAM    (IM).NE.'.' .AND.
     *          MOD_RNAM_NEW(IM).EQ.MON1     ) THEN
                MON1     = MOD_RNAM(IM)
                GO TO 300
              ENDIF
            ENDDO
          ENDIF

 300      CONTINUE

          ICH2   = LN_2ICHN (ILN)
          IR2    = LN_2IRES (ILN)

          IF(ICH2.LE.0.OR.IR2.LE.0) THEN
            LN_ID(ILN)(1:1) = '?'
            GO TO 320
          ENDIF


          MON2   = RES_NAME (IR2)
          ITYPE2 = IRES_TYPE(IR2)

          IF(MOD_N.GT.0) THEN
            DO IM = 1,MOD_N
              IF(MOD_IRES   (IM).EQ.IR2 .AND.
     *          MOD_ICHN    (IM).EQ.ICH2.AND.
     *          MOD_RNAM    (IM).NE.'.' .AND.
     *          MOD_RNAM_NEW(IM).EQ.MON2     ) THEN
                MON2     = MOD_RNAM(IM)
                GO TO 310
              ENDIF
            ENDDO
          ENDIF

 310      CONTINUE


          LINK = LN_ID(ILN)
          CALL LENSTR_BL(LINK,L)
          IA1 = 0
          IA2 = 0

          IF(LIST.EQ.'T') THEN
            write(LINE,*)
     *      '>',iln,link,ich1,ir1,mon1,itype1
            CALL MSGERR(MDOC,LINE)
            write(LINE,*)
     *      '>',ich2,ir2,mon2,itype2,LN_ALT1(ILN),LN_ALT2(ILN)
            CALL MSGERR(MDOC,LINE)
            write(LINE,*) '   ',LN_ATOM1(ILN),';',LN_ATOM2(ILN),';'
            CALL MSGERR(MDOC,LINE)
          ENDIF

          IF(L.GT.0.AND.LINK(1:1).NE.'.'.AND.LINK(1:1).NE.'?') THEN

            IF(LN_ATOM1(ILN)(1:1).EQ.'.'.OR.
     *         LN_ATOM2(ILN)(1:1).EQ.'.'    ) THEN
              CALL GET_LINK_ATOM(LINK,ATOM1,ATOM2,IT)
              IF(IT.GT.0) THEN
                LN_ATOM1(ILN) = ATOM1//' '
                LN_ATOM2(ILN) = ATOM2//' '
              ENDIF
            else
              ATOM1   = LN_ATOM1(ILN)(1:4)
              ATOM2   = LN_ATOM2(ILN)(1:4)              
            ENDIF

            CALL LOOK_LINK_LIST(LINK,ILINK)

          ELSE

            LINK  = '.'
            L     = 1
            ILINK = 0
            IF((ITYPE1.EQ.7.OR.ITYPE1.EQ.8).AND.
     *         (ITYPE2.EQ.3.OR.ITYPE2.EQ.4)     ) THEN  
              LINK = MON1(1:3)//'-'//MON2(1:3)
            ELSE IF((ITYPE2.EQ.7.OR.ITYPE2.EQ.8).AND.
     *         (ITYPE1.EQ.3.OR.ITYPE1.EQ.4)     ) THEN  
              LINK = MON2(1:3)//'-'//MON1(1:3)
            ELSE            
c              LINE =' WARNING : link: '//MON1(1:3)//'<-->'//MON2(1:3)//
c     *              ' cannot be used without link_id'
c              CALL MSGDOC(MDOC,LINE)
c              GO TO 320
              LINE =' WARNING : link: '//MON1(1:3)//'<-->'//MON2(1:3)//
     *              ' is without link_id'
              CALL MSGDOC(MDOC,LINE)
              WRITE(LINE,
     * '(''           link will be created with covalent bond only'')') 
              CALL MSGDOC(MDOC,LINE)
            ENDIF
            CALL LOOK_LINK_LIST(LINK,ILINK)
            IF(ILINK.GT.0) THEN
              LN_ID(ILN) = LLL_LNAME(ILINK)
            ENDIF

          ENDIF

          IF(ILINK.LE.0) THEN

            MOD1    = '.'
            MOD2    = '.'          
            ATOM1   = LN_ATOM1(ILN)(1:4)
            ATOM2   = LN_ATOM2(ILN)(1:4)
            DIST    = LN_DIST (ILN)
                
            CALL LOOK_LINK(LINK,MON1,ATOM1,MON2,ATOM2
     *      ,ITYPE1,ITYPE2,ILINK,MOD1,MOD2,IREVERS)

            IF(ILINK.GT.0) THEN
              LINK       = LLL_LNAME(ILINK)
              LN_ID(ILN) = LINK 
              GO TO 320
            ENDIF

            IF(DIST.LT.0.001) THEN

              IAS = IRATM_FIRST(IR1)
              IAF = IRATM_FIRST(IR1)+NATM_RES(IR1)-1
              IA1 = 0
              DO    IA1=IAS,IAF
                IF(ATOM1.EQ.ATM_NAME(IA1)) THEN
                  INSF   = ID_SF(IA1)  
                  ASYMB1 = CS_ATYPE (INSF)      
                  GO TO 500
                ENDIF 
              ENDDO
              DIST = 1.5
              GO TO 520
 500          CONTINUE
              IAS = IRATM_FIRST(IR2)
              IAF = IRATM_FIRST(IR2)+NATM_RES(IR2)-1
              IA2 = 0
              DO    IA2=IAS,IAF
                IF(ATOM2.EQ.ATM_NAME(IA2)) THEN
                  INSF   = ID_SF(IA2)  
                  ASYMB2 = CS_ATYPE (INSF)      
                  GO TO 510
                ENDIF 
              ENDDO
              DIST = 1.5
              GO TO 520
 510          CONTINUE

              CALL GET_DEFAULT_VBOND(MDOC,ASYMB1,ASYMB2
     *            ,DIST,DEF_FLAG,IERR)
              IF(IERR.NE.0) RETURN
 520          CONTINUE
            ENDIF

            CALL CREAT_LINK(MDOC,LINK,INEW,LNEW,ILINK
     *      ,ITYPE1,ITYPE2
     *      ,MON1,ATOM1,MOD1,MON2,ATOM2,MOD2,DIST,IERR)                 
            IF(IERR.NE.0) RETURN

            IF(LNEW.EQ.1.OR.INEW.EQ.1) THEN

              LN_ID   (ILN)      = LINK
              LN_ATOM1(ILN)(1:4) = ATOM1
              LN_ATOM2(ILN)(1:4) = ATOM2
              LN_1ICHN(ILN)      = I_CHAIN(IR1)
              LN_2ICHN(ILN)      = I_CHAIN(IR2)
              LN_1IRES(ILN)      = IR1
              LN_2IRES(ILN)      = IR2
              LN_1RNAM(ILN)      = MON1
              LN_2RNAM(ILN)      = MON2
c              LN_ALT1 (ILN)      = '.'
c              LN_ALT2 (ILN)      = '.'
c              IF(IA1.GT.0) LN_ALT1(ILN) = ID_ALT(IA1)
c              IF(IA2.GT.0) LN_ALT2(ILN) = ID_ALT(IA2)
              LN_DIST (ILN)      = DIST
C
C           LN_ENT    E - form ent_poly_seq (not trans 2 , ptrans 36 , p 4)
C                     L - form ent_link
C                     C - from conn
C
              LN_ENT (ILN)       = 'C'
C???          LN_USED(ILN)       = '.'
              LN_USED(ILN)       = 'U'

              IF(LN_ALT1(ILN).NE.'.'.OR.LN_ALT1(ILN).NE.' ')
     *          LN_USED(ILN) = 'S'

C ---
C 13.05.2004
C              DNEW = 'Y'
C
c ---
              WRITE(LINE,'(A,A8,A)')' WARNING : description of link:',
     *          LINK,' is not in the dictionary'
              CALL MSGDOC(MDOC,LINE)
              WRITE(LINE,
     * '(''           link will be created with bond_lenth ='',F8.3)') 
     *        DIST
              CALL MSGDOC(MDOC,LINE)

            ENDIF
C ---
          ENDIF

          CALL LOOK_LINK(LINK,MON1,ATOM1,MON2,ATOM2
     *      ,ITYPE1,ITYPE2,ILINK,MOD1,MOD2,IREVERS)

          MON_N = '   '
          MTYPE = 'Y'
          IA1   = 0
          IA2   = 0

          IF(ILN.GT.0) THEN
          IF(LN_USED(ILN).EQ.'S') THEN                        
            MTYPE = 'N'
          ENDIF
          ENDIF

          IF(MTYPE.NE.'N') THEN 
            CALL PUT_M_TABL(MDOC,MOD1,ICH1
     *                    ,IR1,IA1,MON_N,MTYPE,IERR)
            IF(IERR.NE.0) RETURN
            CALL PUT_M_TABL(MDOC,MOD2,ICH2
     *                    ,IR2,IA2,MON_N,MTYPE,IERR)
            IF(IERR.NE.0) RETURN
          ENDIF

 320      CONTINUE

        ENDDO

      ENDIF

      IF(LIST.EQ.'T') THEN
        CALL MSGERR(MDOC,' -- end: DEF_LINK_MOD')
      ENDIF


      RETURN
      END

C ******
      SUBROUTINE DEF_CONN(MMDOC,LIST,CONN_FLAG,CIS_FLAG,SUGAR_FLAG
     *                   ,LN_N_INIT,DNEW,NSUG,IERR)
C -----------------------------------------------
C        check chain connectivity, set residue"s conn_type
C
C        check type of peptide link: 'CIS' or 'TRANS' and
C        change it if CIS_FLAG = 'Y' /set DNEW='Y'/
C
C        check actual distance: if distance is big  and CONN_FLAG ne 'Y'
C        - link will be ignored.      
C
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,LN_N_INIT
      CHARACTER CONN_FLAG*1,CIS_FLAG*1,DNEW*1,SUGAR_FLAG*1,LIST*1
C ---
      INCLUDE 'lib_com.fh'
C     INCLUDE 'conn_com.fh'
      INCLUDE 'atom_com.fh'
C ******
C ----------------------------------------------------------------
C -------------------------------------------------------------------
c      PARAMETER ( NSTOR_PAR = 50 )
c      COMMON /COM_CONN_INF/  N_STOR,IFLAG_STOR,ICONN_ATOM_IND
c     *                      ,X_STOR,Y_STOR,Z_STOR
c     *                      ,ATOM_STOR
C -------------------------------------------------------------------
c      INTEGER    N_STOR,IFLAG_STOR(NSTOR_PAR,2)
c      REAL       X_STOR(NSTOR_PAR,2),Y_STOR(NSTOR_PAR,2)
c     *          ,Z_STOR(NSTOR_PAR,2)
c      CHARACTER  ATOM_STOR(NSTOR_PAR)*4
C ---
c      INTEGER    ICONN_ATOM_IND(2,MAXLLNK)
C -------------------------------------------------------------------
C ----------------------------------------------------------------
      REAL      XX1(3),XX2(3),XX3(3),XX4(3)
      CHARACTER MON1*8,MON2*8,ATOM1*4,ATOM2*4,MOD1*8,MOD2*8
      CHARACTER LINK*8,LINKS*8,SUG*1
C     CHARACTER ALT2*1,CORR2*1
C     CHARACTER ASYMB1*4,ASYMB2*4,DEF_FLAG*1,ALT1*1,CORR1*1
      CHARACTER LINE*256,FLAG*1,MON_N*8,MTYPE*1,LINK_NEW*8
      CHARACTER SYMM1*8,SYMM2*8,CHAR8*8,PRO*1,USER*1
C -----------------------------------
      IERR  = 0
      MDOC = MMDOC
      IF(LIST.EQ.'S') MDOC = 999
      LDOC = MDOC
      IF(LIST.EQ.'M') LDOC = 999
C ----
      NSUG  = 0

c       write(*,*) '--def_conn--',CONN_FLAG,CIS_FLAG,SUGAR_FLAG
c
C      do i=1,LN_N
C      write(*,*) '-C-'
C     * ,i,LN_ID(I),LN_1ICHN(i),LN_1IRES(i),LN_2ICHN(i),LN_2IRES(i)
C      ir1 = LN_1IRES(i)
C      ir2 = LN_2IRES(i)
C      write(*,*) '    '
C     * ,RES_NUM_PDB(Ir1)(3:7),RES_NAME(Ir1),RES_NUM_PDB(Ir2)(3:7)
C     * ,RES_NAME(Ir2),LN_ATOM1(i),LN_ATOM2(I)
C      enddo

C
C     check connectivity of chains (define type of connection)
C

      DO ICH1=1,N_GROUP

        N_R1 = NRES_CHAIN(ICH1)   

        IRS1      = IRES_FIRST(ICH1)
        IRF1      = IRS1 + N_R1 - 1
        IRS1_TREE = IRES_START_TREE(ICH1)
        IRF1_TREE = IRES_END_TREE  (ICH1)

        IRS1 = IRS1_TREE
        IRF1 = IRF1_TREE

        ICONN_TYPE(IRS1) = 1

        IF(IRF1.GT.IRS1) THEN

          DO IS=1,N_STOR    
            IFLAG_STOR(IS,2) = 0
          ENDDO

          IAS = IRATM_FIRST(IRS1)
          IAF = IRATM_FIRST(IRS1)+NATM_RES(IRS1)-1
          DO    IA=IAS,IAF
            ATOM2  = ATM_NAME (IA)
            XI     = XYZ_CRD(1,IA)
            YI     = XYZ_CRD(2,IA)
            ZI     = XYZ_CRD(3,IA)
c           ALT2   = ID_ALT   (IA)    
c           CORR2  = ID_CORR  (IA)    

            DO IS=1,N_STOR    
              IF(ATOM_STOR(IS).EQ.ATOM2.AND.
     *           IFLAG_STOR(IS,2).EQ.0) THEN
                IF(OCCUP(IA).GT.0.0001.AND.ATM_TYPE(IA).NE.'M'.AND.
     *             ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN
                  IFLAG_STOR(IS,2) = IA
                  X_STOR(IS,2)     = XI
                  Y_STOR(IS,2)     = YI
                  Z_STOR(IS,2)     = ZI
                ENDIF
              ENDIF
            ENDDO

          ENDDO

C -- tree --
          I   = IRS1
          IM1 = I      
          I   = IRES_FORW(I)
 1800     CONTINUE  
C         DO    I=IRS1+1,IRF1
C -- tree --

            DO IS=1,N_STOR    
              IFLAG_STOR(IS,1) = IFLAG_STOR(IS,2) 
              IF(IFLAG_STOR(IS,2).NE.0) THEN
                X_STOR(IS,1)     = X_STOR(IS,2)
                Y_STOR(IS,1)     = Y_STOR(IS,2)
                Z_STOR(IS,1)     = Z_STOR(IS,2)
              ENDIF
              IFLAG_STOR(IS,2) = 0
            ENDDO

            MON2   = RES_NAME (I)
            ITYPE2 = IRES_TYPE(I)
C           res- name modification
            IF(MOD_FLAG(I).EQ.'Y') THEN
              IF(MOD_N.GT.0) THEN
                DO IM = 1,MOD_N
                  IF(MOD_IRES    (IM).EQ.I   .AND.
     *               MOD_ICHN    (IM).EQ.ICH1.AND.
     *               MOD_RNAM    (IM).NE.'.' .AND.
     *               MOD_RNAM_NEW(IM).EQ.MON2     ) THEN
                    MON2     = MOD_RNAM(IM)
                    GO TO 200
                  ENDIF
                ENDDO
              ENDIF
 200          CONTINUE
            ENDIF

C           IM1 = I - 1
            MON1   = RES_NAME (IM1)
            ITYPE1 = IRES_TYPE(IM1)
C           res- name modification
            IF(MOD_FLAG(IM1).EQ.'Y') THEN
              IF(MOD_N.GT.0) THEN
                DO IM = 1,MOD_N
                  IF(MOD_IRES    (IM).EQ.IM1 .AND.
     *               MOD_ICHN    (IM).EQ.ICH1.AND.
     *               MOD_RNAM    (IM).NE.'.' .AND.
     *               MOD_RNAM_NEW(IM).EQ.MON1      ) THEN
                    MON1  = MOD_RNAM(IM)
                    GO TO 210
                  ENDIF
                ENDDO
              ENDIF
 210          CONTINUE
            ENDIF

            IF(MON1.EQ.'HOH'.OR.MON2.EQ.'HOH'.OR.
     *         MON1.EQ.'DUM'.OR.MON2.EQ.'DUM') GO TO 400
C
            IAS = IRATM_FIRST(I)
            IAF = IRATM_FIRST(I)+NATM_RES(I)-1
            DO    IA=IAS,IAF
              ATOM2  = ATM_NAME (IA)
              XI     = XYZ_CRD(1,IA)
              YI     = XYZ_CRD(2,IA)
              ZI     = XYZ_CRD(3,IA)
c             ALT2   = ID_ALT   (IA)    
c             CORR2  = ID_CORR  (IA)    

              DO IS=1,N_STOR    
                IF(ATOM_STOR(IS).EQ.ATOM2.AND.
     *             IFLAG_STOR(IS,2).EQ.0) THEN
                  IF(OCCUP(IA).GT.0.0001.AND.ATM_TYPE(IA).NE.'M'.AND.
     *               ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN
                    IFLAG_STOR(IS,2) = IA
                    X_STOR(IS,2)     = XI
                    Y_STOR(IS,2)     = YI
                    Z_STOR(IS,2)     = ZI
                  ENDIF
                ENDIF
              ENDDO

            ENDDO

            FLAG    = 'N'
            ILINK   = 0
            ICONN   = 1
            IREVERS = 0
            JREVERS = 0
            LINK    = ' '

            PRO   = 'N'
            IF(MON2.EQ.'PRO'  .OR.MON2.EQ.'HYP'  .OR.
     *         MON2.EQ.'PRO-D'.OR.MON2.EQ.'5HP'  .OR.
     *         MON2.EQ.'DPR'  .OR.MON2.EQ.'5HP-D'.OR. 
     *         MON2.EQ.'HYP-D'                        ) THEN
              PRO = 'Y'
            ELSE  
              IF(ICONN_TYPE(I).EQ.36.OR.ICONN_TYPE(I).EQ.37)PRO='Y'
              IF(ICONN_TYPE(I).EQ.38.OR.ICONN_TYPE(I).EQ.39)PRO='P'
            ENDIF

            SUG = 'N'
            IF((ITYPE1.GE.7.AND.ITYPE1.LE.8).AND.
     *         (ITYPE2.GE.7.AND.ITYPE2.LE.8)     ) SUG = 'Y'

C ----------non-default link (user definition) ---

            USER = 'N'

            IF((CONN_FLAG .NE.'D'.AND.SUG.EQ.'N').OR.
     *         (SUGAR_FLAG.NE.'D'.AND.SUG.EQ.'Y')    ) THEN

              IF(LN_N_INIT.GT.0) THEN
                DO ILN=1,LN_N_INIT
                  IF(LN_1IRES(ILN).EQ.IM1 .AND.
     *               LN_1ICHN(ILN).EQ.ICH1.AND.
     *               LN_2IRES(ILN).EQ. I  .AND.
     *               LN_2ICHN(ILN).EQ.ICH1.AND.
     *               LN_USED(ILN).NE.'S'       ) THEN
                    SYMM1 = LN_SYMM1(ILN)
                    SYMM2 = LN_SYMM2(ILN)
                    IF((SYMM1.EQ.'.'.OR.SYMM1.EQ.'1_555').AND.
     *                 (SYMM2.EQ.'.'.OR.SYMM2.EQ.'1_555')) THEN
                      LINKS = LN_ID(ILN)
                      CALL LOOK_LINK_LIST(LINKS,ILINKS)
                      CALL SET_ICONN(LINKS,ICONNS)

C                      IF(ICONNS.GE.2.AND.ICONNS.LE.N_CONN_TYPE.AND.
C     *                   ICONNS.NE.36             ) THEN

                      IF(ICONNS.GE.2.AND.ICONNS.LE.N_CONN_TYPE) THEN
C                       gap - ICONN=10 , cis  - ICONN=3  , ptrans - ICONN=36 
C                                        pcis - ICONN=37 , trans  - ICONN=2
                        FLAG  = 'Y'
                        LINK  = LINKS
                        ILINK = ILINKS
                        ICONN = ICONNS
                        USER  = 'Y'
                        IF(SUG.EQ.'Y') NSUG = NSUG + 1
                        GO TO 100
                      ENDIF  
                    ENDIF
                  ENDIF
                ENDDO
              ENDIF

            ENDIF

            IF((ITYPE1.GE.7.AND.ITYPE1.LE.8).AND.
     *         (ITYPE2.GE.7.AND.ITYPE2.LE.8)     ) THEN
C ------------------sugar ---
              LINK = 'BETA1-2'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 > 1.3 * DIST_IDEAL              

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'BETA1-3'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 > 1.3 * DIST_IDEAL              

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'BETA1-4'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 >

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'BETA1-6'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 > 

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'ALPHA1-2'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 > 1.3 * DIST_IDEAL              

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'ALPHA1-3'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 > 1.3 * DIST_IDEAL              

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'ALPHA1-4'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 >

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
                GO TO 110
              ENDIF

              LINK = 'ALPHA1-6'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                               ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 > 

              IF(IDIST.EQ.0) THEN
                FLAG  = 'D'
              ENDIF

 110          CONTINUE

              IF(FLAG.EQ.'D') THEN 
                IS1    = ICONN_ATOM_IND(1,ILINK)
                IS2    = ICONN_ATOM_IND(2,ILINK)
                ATOM1  = ATOM_STOR(IS1)
                ATOM2  = ATOM_STOR(IS2)

                CALL LOOK_LINK(LINK,MON1,ATOM1,MON2,ATOM2
     *          ,ITYPE1,ITYPE2,ILINK,MOD1,MOD2,IREVERS)

                IF(ILINK.GT.0.AND.IREVERS.NE.1) THEN
                  I1      = IM1
                  I2      = I                      
                  IF(IREVERS.EQ.1) THEN
                    I2    = IM1
                    I1    = I
                  ENDIF

                  IAA1   = IFLAG_STOR(IA1,1)
                  IAA2   = IFLAG_STOR(IA2,2)
                  XX1(1) = X_STOR(IS1,1) 
                  XX1(2) = Y_STOR(IS1,1) 
                  XX1(3) = Z_STOR(IS1,1) 
                  XX2(1) = X_STOR(IS2,2) 
                  XX2(2) = Y_STOR(IS2,2) 
                  XX2(3) = Z_STOR(IS2,2) 
              
                  IF(JREVERS.EQ.1) THEN
                    I2      = IM1
                    I1      = I
                    IAA1    = IFLAG_STOR(IA1,2)
                    IAA2    = IFLAG_STOR(IA2,1)
                    XX1(1)  = X_STOR(IS1,2) 
                    XX1(2)  = Y_STOR(IS1,2) 
                    XX1(3)  = Z_STOR(IS1,2) 
                    XX2(1)  = X_STOR(IS2,1) 
                    XX2(2)  = Y_STOR(IS2,1) 
                    XX2(3)  = Z_STOR(IS2,1) 
                  ENDIF

C ---             check alpha or beta ?
C                 C1 - X - O5 - C2

                  IF(ATM_NAME(IAA1).EQ.'C1  ') THEN
                    IRR    = I1
C                    T      = XX1(1)  
C                    XX1(1) = XX2(1)
C                    XX2(1) = T
C                    T      = XX1(2)  
C                    XX1(2) = XX2(2)
C                    XX2(2) = T
C                    T      = XX1(3)  
C                    XX1(3) = XX2(3)
C                    XX2(3) = T
                  ELSE
                    IRR    = I2
                    T      = XX1(1)  
                    XX1(1) = XX2(1)
                    XX2(1) = T
                    T      = XX1(2)  
                    XX1(2) = XX2(2)
                    XX2(2) = T
                    T      = XX1(3)  
                    XX1(3) = XX2(3)
                    XX2(3) = T
                  ENDIF
                  IT1 = 0  
                  IT2 = 0  
                  IT3 = 0  
                  IT4 = 0  
                  IAS = IRATM_FIRST(IRR)
                  IAF = IRATM_FIRST(IRR)+NATM_RES(IRR)-1
                  IT = 0
                  DO  IA=IAS,IAF
                    IF(ATM_NAME(IA).EQ.'O5  ') THEN
                       XX3(1) = XYZ_CRD(1,IA)
                       XX3(2) = XYZ_CRD(2,IA)
                       XX3(3) = XYZ_CRD(3,IA)
                       IT     = IT + 1
                    ELSE IF(ATM_NAME(IA).EQ.'C2  ') THEN
                       XX4(1) = XYZ_CRD(1,IA)
                       XX4(2) = XYZ_CRD(2,IA)
                       XX4(3) = XYZ_CRD(3,IA)
                       IT     = IT + 1
                    ENDIF
                  ENDDO
                  IF(IT.GE.2) THEN

                    CALL CALC_I_OVOL_L(IT1,IT2,IT3,IT4,XX1,XX2,XX3,XX4
     *              ,VOLOBS,PH)
                 
C                                  V2 -> I3 
C                    I2 - V1 -> I1 < 
C                                  V3 -> I4 

                    IT = 0
                    IF(PH.GE.0.0.AND.LINK(1:4).EQ.'BETA') THEN
                      IT = 1
                      LINK_NEW =  'ALPHA'//LINK(5:7)
                    ELSE IF(PH.LT.0.0.AND.LINK(1:4).EQ.'ALPH') THEN
                      LINK_NEW =  'BETA'//LINK(6:8)
                      IT = 1   
                    ENDIF
                    IF(IT.GT.0) THEN
                      IF(LN_N.GT.0) THEN
                        DO IC=1,LN_N
                         IF(  LN_ID(IC)   .EQ.LINK .AND.
     *                       ((LN_1IRES(IC).EQ.I1.AND.
     *                         LN_2IRES(IC).EQ.I2     ).OR.
     *                        (LN_1IRES(IC).EQ.I2.AND.
     *                         LN_2IRES(IC).EQ.I1     )    ) ) THEN
                           LN_ID(IC) = LINK_NEW  
                          ENDIF
                        ENDDO
                      ENDIF

                     LINK = LINK_NEW
                     CALL SET_ICONN(LINK,ICONN)
                    ENDIF

                  ENDIF
C ---
                  IA      = 0
C                 sugar's connection is found
C                 put in table because there is not defaults for sugars
                  IF(SUGAR_FLAG.NE.'N') THEN
                    CALL PUT_L_TABL(MDOC,LINK,ICH1,ICH1
     *              ,I1,I2,IAA1,IAA2,IREVERS,IERR)

                    IF(SUG.EQ.'Y') NSUG = NSUG + 1
                  ENDIF

C            write(*,*) '-sug',link,i1,iaa1,i2,iaa2,IREVERS,jREVERS

c                  IF(JREVERS.EQ.1) THEN
c                    FLAG  = 'N'
c                    ILINK = 0
c                    ICONN = 1
c                  ENDIF

                  GO TO 100
                ELSE
                  FLAG  = 'N'
                  ILINK = 0
                  ICONN = 1
                ENDIF
              ENDIF
            ELSE IF(((ITYPE1.GE.3.AND.ITYPE1.LE.4).OR.ITYPE1.EQ.10).AND.
     *              ((ITYPE2.GE.3.AND.ITYPE2.LE.4).OR.ITYPE2.EQ.10)     
     *                                                         ) THEN
C ----------default link for peptides ---
              FLAG  = 'D'
              IF(MON1.EQ.'FOR') THEN
                LINK  = 'FOR_C-N'
              ELSE IF(MON2.EQ.'FOR') THEN
                LINK  = 'FOR_C-C'
              ELSE IF(MON1.EQ.'ACE') THEN
                LINK  = 'ACE_C-N'
              ELSE IF(MON1.EQ.'DFO') THEN
                IF(MON2.EQ.'NME') THEN
                  LINK  = 'DFO-NME'
                ELSE IF(MON2.EQ.'DFO') THEN
                  LINK  = 'DFO-DFO'
                ELSE IF(MON2.EQ.'STA') THEN
                  LINK  = 'DFO-STA'
                ELSE
                  LINK  = 'DFO_C-N'
                ENDIF
              ELSE IF(MON1.EQ.'STA') THEN
                IF(MON2.EQ.'NME') THEN
                  LINK  = 'STA-NME'
                ELSE IF(MON2.EQ.'DFO') THEN
                  LINK  = 'STA-DFO'
                ELSE IF(MON2.EQ.'STA') THEN
                  LINK  = 'STA-STA'
                ELSE
                  LINK  = 'STA_C-N'
                ENDIF
              ELSE IF(MON2.EQ.'DFO') THEN
                LINK  = 'DFO_N-C'
               ELSE IF(MON2.EQ.'STA') THEN
                LINK  = 'STA_N-C'
              ELSE IF(MON2.EQ.'NME') THEN
                LINK  = 'NME_N-C'
              ELSE IF(MON2.EQ.'AHT') THEN
                LINK  = 'TRANS'
              ELSE IF(MON1.EQ.'IVA') THEN
                LINK  = 'TRANS'
              ELSE IF(MON2.EQ.'DFO') THEN
                LINK  = 'TRANS'
              ELSE IF(MON1.EQ.'INI') THEN
                LINK  = 'TRANS'
              ELSE IF(MON2.EQ.'INI') THEN
                LINK  = 'TRANS'
              ELSE IF(MON1.EQ.'ILG')THEN
                IF(ITYPE2.EQ.10) THEN
                  LINK  = 'ILG_CD-N'
                ELSE
                  LINK  = 'ILG_CD-p'
                ENDIF
              ELSE IF(ITYPE1.EQ.10) THEN
                IF(ITYPE2.GE.3.AND.ITYPE2.LE.4) THEN     
                  LINK  = 'LINK_CNp'
                ELSE
                  LINK  = 'LINK_C-N'
                ENDIF
              ELSE IF(ITYPE2.EQ.10) THEN
                IF(ITYPE1.GE.3.AND.ITYPE1.LE.4) THEN     
                  LINK  = 'LINK_CpN'
                ELSE
                  LINK  = 'LINK_C-N'
                ENDIF
              ELSE 
                LINK  = 'TRANS'
                IF(PRO.EQ.'Y') LINK = 'PTRANS'
                IF(PRO.EQ.'P') LINK = 'NMTRANS'
C               default 'gap'
                IF(ICONN_TYPE(I).EQ.10) LINK = 'gap'
              ENDIF
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
C -----------------
C     5 'FOR_C-N ', bond_FOR-C_=_N-peptide
C     6 'FOR_C-C ', bond_FOR-C_=_C-peptide
C     7 'ACE_C-N ', bond_ACE-C_=_N_peptide
C     8 'DFO_C-N ', bond_DFO-C_=_N-peptide
C     9 'NME_N-C ', bond_NME-N_=_C-peptide
C
C  ???   FOR+AA may be single residue -> modification
C ------------- ---

C ----------default link for DNA/RNA ---
            ELSE IF((ITYPE1.GE.5.AND.ITYPE1.LE.6).AND.
     *              (ITYPE2.GE.5.AND.ITYPE2.LE.6)     ) THEN
              FLAG  = 'D'
              LINK  = 'p'
C             default 'gap'
              IF(ICONN_TYPE(I).EQ.10) LINK = 'gap'
              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)
            ENDIF
  
C ---------------------------
 100        CONTINUE

            IF(FLAG.EQ.'Y'.OR.FLAG.EQ.'D') THEN
C             D - default, Y - user

              CALL LOOK_LINK_LIST(LINK,ILINK)
              CALL SET_ICONN(LINK,ICONN)

              CALL CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                                       ,IA1,IA2,JREVERS)
C             IDIST = -1 no dist, IDIST = 1 >       


C       write(*,*) '-f-',link,flag,conn_flag,user,mon1,mon2,idist,dist
C       write(*,*) '  -',sug,jrevers,irevers


              IF(IDIST.EQ.0) THEN
              
                IF(LINK(1:3).NE.'gap') THEN

                  IS1   = ICONN_ATOM_IND(1,ILINK)
                  IS2   = ICONN_ATOM_IND(2,ILINK)
                  ATOM1 = ATOM_STOR(IS1)
                  ATOM2 = ATOM_STOR(IS2)

                  CHAR8 = MON2
                  IF(LINK.EQ.'PTRANS'.OR.LINK.EQ.'PCIS'.OR.
     *            LINK.EQ.'NMTRANS'.OR.LINK.EQ.'NMCIS') CHAR8 = 'PRO'
                  CALL LOOK_LINK(LINK,MON1,ATOM1,CHAR8,ATOM2
     *            ,ITYPE1,ITYPE2,ILINK,MOD1,MOD2,IREVERS)

C       write(*,*) '  -r',link,jrevers,irevers

                  IF(ILINK.GT.0) THEN
                    I1 = IM1
                    I2 = I                      
                    IA = 0
C                   put MOD1 and MOD2 to the list of modifications
                    MTYPE = 'Y'
                    IF(JREVERS.EQ.0) THEN
                      IF(MOD1(1:1).NE.'.'.AND.MOD1(1:1).NE.' ') THEN
                        MON_N='   '
                        CALL PUT_M_TABL(MDOC,MOD1,ICH1
     *                                      ,I1,IA,MON_N,MTYPE,IERR)
                      ENDIF
                      IF(MOD2(1:1).NE.'.'.AND.MOD2(1:1).NE.' ') THEN
                        MON_N='   '
                        CALL PUT_M_TABL(MDOC,MOD2,ICH1
     *                                       ,I2,IA,MON_N,MTYPE,IERR)
                      ENDIF
                    ELSE
                      IF(MOD2(1:1).NE.'.'.AND.MOD2(1:1).NE.' ') THEN
                        MON_N='   '
                        CALL PUT_M_TABL(MDOC,MOD2,ICH1
     *                                      ,I1,IA,MON_N,MTYPE,IERR)
                      ENDIF
                      IF(MOD1(1:1).NE.'.'.AND.MOD1(1:1).NE.' ') THEN
                        MON_N='   '
                        CALL PUT_M_TABL(MDOC,MOD1,ICH1
     *                                       ,I2,IA,MON_N,MTYPE,IERR)
                      ENDIF
                    ENDIF
                    IF(IERR.NE.0) RETURN

                    IF(LINK.EQ.'TRANS'.OR.LINK.EQ.'PTRANS'.OR.
     *                                    LINK.EQ.'NMTRANS') THEN 
c                    IF(FLAG.EQ.'D'.AND.
c     *                 (LINK.EQ.'TRANS'.OR.LINK.EQ.'PTRANS')) THEN 
C                     check CIS peptide bond
                      CALL CALC_PEP_BOND_ANGLE(MDOC,ANGOBS,IERR)

                      IF(IERR.EQ.0) THEN
                        IF(ABS(ANGOBS).GT.180.0) 
     *                    ANGOBS = ABS(360.0-ABS(ANGOBS))
                        IF(ABS(ANGOBS).LT.90.0) THEN
                          IF(CIS_FLAG.EQ.'Y'.AND.USER.NE.'Y') THEN
                            LINK = 'CIS'
                            IF(PRO.EQ.'Y') LINK = 'PCIS'
                            IF(PRO.EQ.'P') LINK = 'NMCIS'
                            CALL SET_ICONN(LINK,ICONN)
                            IREVERS = 0
                            CALL PUT_L_TABL(MDOC,LINK,ICH1,ICH1
     *                      ,I1,I2,IA,IA,IREVERS,IERR)
                            WRITE(LINE,
     *'('' WARNING : CIS peptide bond is found, angle ='',F10.2)')
     *                      ANGOBS
                            CALL MSGDOC(MDOC,LINE)                    
                          ELSE
                            WRITE(LINE,
     *'('' WARNING : CIS peptide bond (not be used) angle ='',F10.2)')
     *                      ANGOBS
                            CALL MSGDOC(MDOC,LINE)                    
                          ENDIF

                          WRITE(LINE,'(3A,A5,3A,A5,2A)')
     *'           ch:',GROUP_ID(ICH1),' res:',RES_NUM_PDB(I1)(3:7),
     *' ',RES_NAME(I1),' -->',RES_NUM_PDB(I2)(3:7),' ',RES_NAME(I2)
                          CALL MSGDOC(MDOC,LINE)                    
                        ENDIF
                      ELSE
                        IERR=0
                      ENDIF
                    ELSE IF(LINK.EQ.'CIS'.OR.LINK.EQ.'PCIS'.OR. 
     *                      LINK.EQ.'NMCIS') THEN 
C                     check CIS peptide bond
                      CALL CALC_PEP_BOND_ANGLE(MDOC,ANGOBS,IERR)

                      IF(IERR.EQ.0) THEN
                        IF(ABS(ANGOBS).GT.180.0) 
     *                    ANGOBS = ABS(360.0-ABS(ANGOBS))
                        IF(ABS(ANGOBS).GT.90.0) THEN
                          IF(CIS_FLAG.EQ.'Y'.AND.USER.NE.'Y') THEN
                            LINK = 'TRANS'
                            IF(PRO.EQ.'Y') LINK = 'PTRANS'
                            IF(PRO.EQ.'P') LINK = 'NMTRANS'
                            CALL SET_ICONN(LINK,ICONN)
                            IREVERS = 0
                            CALL PUT_L_TABL(MDOC,LINK,ICH1,ICH1
     *                      ,I1,I2,IA,IA,IREVERS,IERR)
                            WRITE(LINE,'(A,F10.2)')
     *' WARNING : TRANS peptide bond is found instead CIS, angle =',
     *ANGOBS
                            CALL MSGDOC(MDOC,LINE)                    
                          ELSE
                            WRITE(LINE,'(A,F10.2)')
     *' WARNING : TRANS peptide bond (not be changed CIS) angle ='
     *,ANGOBS
                            CALL MSGDOC(MDOC,LINE)                    
                          ENDIF

                          WRITE(LINE,'(3A,A5,3A,A5,2A)')
     *'           ch:',GROUP_ID(ICH1),' res:',RES_NUM_PDB(I1)(3:7),
     *' ',RES_NAME(I1),' -->',RES_NUM_PDB(I2)(3:7),' ',RES_NAME(I2)
                          CALL MSGDOC(MDOC,LINE)                    
                        ENDIF
                      ELSE
                        IERR=0
                      ENDIF

                    ELSE IF(LINK.NE.'p'.AND.LINK.NE.'PTRANS'.AND.
     *                                         LINK.NE.'NMTRANS') THEN 

                      II1 = I1
                      II2 = I2
                      IF(JREVERS.EQ.1) THEN
                        II2 = I1
                        II1 = I2
                      ENDIF
c     *'('' WARNING : link: '',A8,'' ch:'',A,'' res:'',A5,'' ''
                      WRITE(LINE,'(A,A8,A,A,A,A5,A,A,A,A5,A,A)')
     *' WARNING : conn: ',LINK,' ch:',GROUP_ID(ICH1),' res:',
     *RES_NUM_PDB(II1)(3:7),' ',RES_NAME(II1),'-->',
     *RES_NUM_PDB(II2)(3:7),' ',RES_NAME(II2)
                      CALL MSGDOC(MDOC,LINE)                    
                    
                    ENDIF

                      
                    IF(JREVERS.EQ.1) THEN
                      ICONN = 1
                      CALL MSGDOC(MDOC,
     *                ' WARNING :       reverse conn, not be used')
                    ENDIF
                    IF(SUG.EQ.'Y'.AND.SUGAR_FLAG.EQ.'N'.AND.
     *                                USER.NE.'Y'           ) THEN
                      LINE = 
     *                '                 not be used ( sugar_flag = '//
     *                SUGAR_FLAG//' )'
                      CALL MSGDOC(MDOC,LINE)
                      ICONN = 1
                    ENDIF
                    IF(SUG.EQ.'N'.AND.CONN_FLAG.EQ.'N'.AND.
     *                 FLAG.NE.'D'.AND.USER.NE.'Y'           ) THEN
                      LINE = 
     *                '                 not be used ( conn_flag = '//
     *                CONN_FLAG//' )'
                      CALL MSGDOC(MDOC,LINE)
                      ICONN = 1
                    ENDIF
                    IF(ICONN.GT.1) ICONN_TYPE(I) = ICONN

                  ELSE
                    WRITE(LINE,'(A,A8,A)')
     *              ' WARNING : description of the link:',LINK
     *              ,' is not present. (chain connectivity)'
                    CALL MSGDOC(MDOC,LINE)
                    WRITE(LINE,'(''           link will be ignored'')') 
                    CALL MSGDOC(MDOC,LINE)
                  ENDIF
                ELSE
C                 --- gap (user definition) ---
                  I1      = IM1
                  I2      = I                      
                  WRITE(LINE,'(A,A,A,A5,A,A,A,A5,A,A)')
     *' WARNING : conn: gap (user) ch:',GROUP_ID(ICH1),' res:',
     *RES_NUM_PDB(I1)(3:7),' ',RES_NAME(I1),'-->',RES_NUM_PDB(I2)(3:7),
     *' ',RES_NAME(I2)
                  CALL MSGDOC(MDOC,LINE)                    
                  ICONN_TYPE(I) = ICONN
                ENDIF

              ELSE
C               -- dist is big --
C               message actual DIST
                I1      = IM1
                I2      = I                      
                IA      = 0
                IREVERS = 0

                IF(LINK(1:3).NE.'gap') THEN 

                  MMM = MDOC
                  IF(DIST.GT.9999.9) MMM = LDOC
 
                  CALL SET_ICONN(LINK,ICONN)
                  IF(ICONN.LE.0) ICONN = 1

                  IF(DIST.GT.9999.9) THEN
                    WRITE(LINE,
     *'('' WARNING : undefined distance for link:'',A8)')
     *              LINK
                  ELSE
                    WRITE(LINE,
     *'('' WARNING : big distance for conn:'',A8,'' dist ='',F10.3)')
     *              LINK,DIST
                  ENDIF
                  CALL MSGDOC(MMM,LINE)                    

                  WRITE(LINE,'(3A,A5,3A,A5,3A,F10.3)')
     *'           ch:',GROUP_ID(ICH1),' res:',RES_NUM_PDB(I1)(3:7),
     *' ',RES_NAME(I1),'-->',RES_NUM_PDB(I2)(3:7),' ',RES_NAME(I2),
     *' ideal_dist=',DIST_IDL
                  CALL MSGDOC(MMM,LINE)                    

                  IF(JREVERS.EQ.1) THEN
                    ICONN = 1
                    CALL MSGDOC(MMM,
     *              ' WARNING :       reverse conn, not be used')
                  ENDIF

                  IF(SUG.EQ.'Y') THEN
                    IF(SUGAR_FLAG.EQ.'N'.AND.USER.NE.'Y') THEN
                      LINE = 
     *                '                 not be used ( sugar_flag = '//
     *                SUGAR_FLAG//' )'
                      CALL MSGDOC(MMM,LINE)
                      ICONN = 1
                    ENDIF
                  ELSE
                    IF(CONN_FLAG.EQ.'N'.AND.USER.NE.'Y'.AND.
     *                 FLAG.NE.'D'                          ) THEN
                      LINE = 
     *                '                 not be used ( conn_flag = '//
     *                CONN_FLAG//' )'
                      CALL MSGDOC(MMM,LINE)
                      ICONN = 1
                    ENDIF
                  ENDIF
                  
                  IF(ICONN.GT.1) ICONN_TYPE(I) = ICONN

                  IF(USER.EQ.'Y') THEN                 
                    CALL SET_ICONN(LINK,ICONN)
c                    CALL PUT_L_TABL(MDOC,LINK,ICH1,ICH1
c     *              ,I1,I2,IA,IA,IREVERS,IERR)   
                    CALL MSGDOC(MMM,'     link will be created')
                    ICONN_TYPE(I) = ICONN
                  ENDIF

                ELSE

                  WRITE(LINE,'(3A,A5,3A,A5,2A)')
     *' WARNING : conn: gap.     ch:',GROUP_ID(ICH1),' res:',
     *RES_NUM_PDB(I1)(3:7),' ',RES_NAME(I1),'-->',RES_NUM_PDB(I2)(3:7),
     *' ',RES_NAME(I2)
                  CALL MSGDOC(LDOC,LINE)                    

c          write(*,*) '--',ITYPE1,ITYPE2,flag,user,LINK

                  IF(((ITYPE1.EQ.3.OR.ITYPE1.EQ.4.OR.ITYPE1.EQ.10).AND.
     *                (ITYPE2.EQ.3.OR.ITYPE2.EQ.4.OR.ITYPE2.EQ.10)).OR.
     *               ((ITYPE1.GE.5.AND.ITYPE1.LE.6).AND.
     *                (ITYPE2.GE.5.AND.ITYPE2.LE.6)     ) ) THEN
C                   polypeptide or DNA/RNA
                    IF((FLAG.EQ.'D'.AND.CONN_FLAG.NE.'N').OR.
     *                  USER.EQ.'Y') THEN                 
C                     it is gap-link (for default connection) 
                      LINK = 'gap'
                      CALL SET_ICONN(LINK,ICONN)
                      IF(USER.NE.'Y') THEN
                        IA = 0

c         write(*,*) '-----',link,IA,ICH1,I,I1,I2,IREVERS

                        CALL PUT_L_TABL(MDOC,LINK,ICH1,ICH1
     *                  ,I1,I2,IA,IA,IREVERS,IERR)
                      ENDIF   
                      CALL MSGDOC(LDOC,
     *                '           "gap"-link will be created')
                      ICONN_TYPE(I) = ICONN
                    ENDIF
                  ENDIF

                ENDIF

              ENDIF

            ENDIF

 400        CONTINUE
C         -- I --
C ---     tree
C         ENDDO
          IF(I.NE.IRF1) THEN
            IM1 = I
            I   = IRES_FORW(I)
            IF(I.LE.0) THEN
              CALL MSGERR(MDOC,' ERROR: wrong tree structure .....')
              IERR = 1
              RETURN
            ENDIF
            GO TO 1800
          ENDIF
C ---     tree --

        ENDIF
 600    CONTINUE
C     -- ICH1 --
      ENDDO

      RETURN
      END

      SUBROUTINE CALC_CONN_DIST(ILINK,DIST_IDL,DIST,IDIST
     *                                       ,I1,I2,IREVERS)
C -----------------
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------------------
C      PARAMETER ( NSTOR_PAR = 50 )
C      COMMON /COM_CONN_INF/  N_STOR,IFLAG_STOR,ICONN_ATOM_IND
C     *                      ,X_STOR,Y_STOR,Z_STOR
C     *                      ,ATOM_STOR
C -------------------------------------------------------------------
C      INTEGER    N_STOR,IFLAG_STOR(NSTOR_PAR,2)
C      REAL       X_STOR(NSTOR_PAR,2),Y_STOR(NSTOR_PAR,2)
C     *          ,Z_STOR(NSTOR_PAR,2)
C      CHARACTER  ATOM_STOR(NSTOR_PAR)*4
C ---
C      INTEGER    ICONN_ATOM_IND(2,MAXLLNK)
C -------------------------------------------------------------------
      DIST_IDL = 0.0
      DIST     = 0.0      
      IDIST    =-1
      IREVERS  = 0

      IF(ILINK.LE.0.OR.ILINK.GT.MAXLLNK) RETURN

      I1    = ICONN_ATOM_IND(1,ILINK)
      I2    = ICONN_ATOM_IND(2,ILINK)

c      WRITE(*,*) '===',I1,I2,IFLAG_STOR(I1,1),IFLAG_STOR(I2,2)

      DIST  = 10000.0

      IF(I1.EQ.0.OR.I2.EQ.0   ) RETURN 
      IF(IFLAG_STOR(I1,1).EQ.0) GO TO 100
      IF(IFLAG_STOR(I2,2).EQ.0) GO TO 100


      IDIST = 0

      X1    = X_STOR(I1,1) 
      Y1    = Y_STOR(I1,1) 
      Z1    = Z_STOR(I1,1) 
      X2    = X_STOR(I2,2) 
      Y2    = Y_STOR(I2,2) 
      Z2    = Z_STOR(I2,2) 
      D2    = (X1-X2)*(X1-X2) + (Y1-Y2)*(Y1-Y2) + (Z1-Z2)*(Z1-Z2)
      DIST  = SQRT(ABS(D2))

 100  CONTINUE

      IF(IFLAG_STOR(I2,1).EQ.0) GO TO 200
      IF(IFLAG_STOR(I1,2).EQ.0) GO TO 200

      IDIST = 0
      X1    = X_STOR(I2,1) 
      Y1    = Y_STOR(I2,1) 
      Z1    = Z_STOR(I2,1) 
      X2    = X_STOR(I1,2) 
      Y2    = Y_STOR(I1,2) 
      Z2    = Z_STOR(I1,2) 
      D2    = (X1-X2)*(X1-X2) + (Y1-Y2)*(Y1-Y2) + (Z1-Z2)*(Z1-Z2)
      DIST2 = SQRT(ABS(D2))

      IF(DIST2.LT.DIST) THEN
        DIST    = DIST2
        IREVERS = 1
      ENDIF

 200  CONTINUE

      DIST_IDL = BOND_IDL(ILINK)
      T        = DIST_IDL
      IF(T.LE.0.00001) T = 1.5
      T        = DIST/T

      IF(T.GT.1.3)    IDIST = 1
      IF(IDIST.EQ.-1) DIST  = 0.0

      RETURN
      END


      SUBROUTINE LOOK_LINK_LIST(LINKS,ILINK)
C -----------------------------------------------
C -P-  return ILINK = 0  not found in table of links ( LLL_ )
C -----------------------------------------------
      INTEGER*4 ILINK
      CHARACTER LINKS*8,LINK*8
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
C -----------------------------------
      ILINK = 0

      CALL LENSTR_BL(LINKS,LENS)

      IF(LLL_NLINK.GT.0.AND.LENS.GT.0) THEN

        DO L=1,LLL_NLINK

          LINK=LLL_LNAME(L)
          CALL LENSTR_BL(LINK,LENL)
          IF(LINKS(1:LENS).EQ.LINK(1:LENL)) THEN
            ILINK = L
            IF(LLL_FUSE(ILINK).NE.'?'.AND.
     *         LLL_FUSE(ILINK).NE.'C') LLL_FUSE(ILINK)='Y'
            GO TO 100
          ENDIF

        ENDDO
      
      ENDIF

 100  CONTINUE

      RETURN
      END

      SUBROUTINE LOOK_LINK(LINKS,MON1,ATOM1,MON2,ATOM2
     *          ,ITYPE1,ITYPE2,ILINK,MOD1,MOD2,IREVERS)
C -----------------------------------------------
C -P-  return ILINK =< 0  not found in table of links ( LLL_ )
C                      N  link's number in the list of links.
C              If LINKS = ' ' or '.' - looking by MON,ATOM,TYPE        
C
C      search by MON, TYPE ( of residue ) , ATOM
C      now used only bonds
C -----------------------------------------------
      INTEGER*4 ILINK,ITYPE1,ITYPE2
      CHARACTER LINKS*8,LINK*8,MON1*8,MON2*8,ATOM1*4,ATOM2*4
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER TYPE1*8 ,TYPE2*8
      CHARACTER LTYPE1*8,LTYPE2*8
      CHARACTER MOD1*8,MOD2*8
C -----------------------------------
      ILINK   = 0
      MOD1    = '.'
      MOD2    = '.'
      IREVERS = 0
      CALL LENSTR_BL(MON1 ,LM1)
      CALL LENSTR_BL(MON2 ,LM2)

      IF((ITYPE1.EQ.7.OR.ITYPE1.EQ.8).AND.LM1.GT.3) LM1 = 3
      IF((ITYPE2.EQ.7.OR.ITYPE2.EQ.8).AND.LM2.GT.3) LM2 = 3

      CALL LENSTR_BL(LINKS,LENS)

      IF(LENS.GT.0) THEN
        ILINK = -1
        IF(LINKS.EQ.'.') THEN
          LENS  = 0
          ILINK = 0
        ENDIF
      ENDIF     

      TYPE1 = RES_LTYPE(ITYPE1)
      TYPE2 = RES_LTYPE(ITYPE2)

c      write(*,*) 
c     * '-->',links,';',mon1,';',atom1,';',mon2
c     *,';',atom2,';',type1,';',type2,';',lens
c      write(*,*) '-- itype:',ITYPE1,ITYPE2 

      IF(LLL_NLINK.GT.0) THEN

        DO L=1,LLL_NLINK

          LINK = LLL_LNAME(L)

          IF(LENS.GT.0) THEN
            LINK = LLL_LNAME(L)
            CALL LENSTR_BL(LINK,LENL)
            IF(LINKS(1:LENS).NE.LINK(1:LENL)) GO TO 100     
          ENDIF

c       write(*,*)
c     * ' =',link,';',LLL_mon1(l),';',LLL_mon2(l)
c     *,';',LLL_type1(l),';',LLL_type2(l),';'

          CALL SET_LTYPE(LLL_TYPE1(L),IT1)    
          LTYPE1 = LLL_TYPE1(L)
          CALL SET_LTYPE(LLL_TYPE2(L),IT2)    
          LTYPE2 = LLL_TYPE2(L)


c          IF(LTYPE1.EQ.'polymer'.AND.TYPE1.EQ.'peptide')LTYPE1='peptide' 
c          IF(LTYPE2.EQ.'polymer'.AND.TYPE2.EQ.'peptide')LTYPE2='peptide' 

          IF( (MON1(1:LM1).EQ.LLL_MON1(L)) .OR.
     *        (LLL_MON1(L)(1:1).EQ.'.'.AND.
     *         ( (TYPE1.EQ.LTYPE1         ) .OR.
     *           (LTYPE1(1:1).EQ.'.'     )     ))) THEN

            IF( (MON2(1:LM2).EQ.LLL_MON2(L)) .OR.
     *          (LLL_MON2(L)(1:1).EQ.'.'.AND.
     *           ( (TYPE2.EQ.LTYPE2        ) .OR.
     *             (LTYPE2(1:1).EQ.'.'     )     ))) THEN
              IFLAG=1
              GO TO 200
            ENDIF
          ENDIF

          LTYPE1 = LLL_TYPE1(L)
          LTYPE2 = LLL_TYPE2(L)

c          IF(LTYPE1.EQ.'polymer'.AND.TYPE2.EQ.'peptide')LTYPE1='peptide' 
c          IF(LTYPE2.EQ.'polymer'.AND.TYPE1.EQ.'peptide')LTYPE2='peptide' 

          IF( (MON2(1:LM2).EQ.LLL_MON1(L)) .OR.
     *        (LLL_MON1(L)(1:1).EQ.'.'.AND.
     *         ( (TYPE2.EQ.LTYPE1        ) .OR.
     *           (LTYPE1(1:1).EQ.'.'     )     ))) THEN

            IF( (MON1(1:LM1).EQ.LLL_MON2(L)) .OR.
     *          (LLL_MON2(L)(1:1).EQ.'.'.AND.
     *           ( (TYPE1.EQ.LTYPE2        ) .OR.
     *             (LTYPE2(1:1).EQ.'.'  )     ))) THEN

              IFLAG=2
              GO TO 200
            ENDIF
          ENDIF
          GO TO 100

 200      CONTINUE

          IF(LLL_MON1(L)(1:1).EQ.'.'.AND.LLL_MON2(L)(1:1).EQ.'.')
     *    IFLAG = 3

c            WRITE(*,*) '-iflag:',iflag,LLL_IBOND(L),LLB_NBOND

          IF(LLB_NBOND.GT.0.AND.LLL_IBOND(L).GT.0) THEN

            DO IB=LLL_IBOND(L),LLB_NBOND
              IF(LLL_LNAME(L).EQ.LLB_LNAME(IB)) THEN

C                write(*,*) ib,';',LLL_LNAME(L),';',LLB_LNAME(IB),';'
C                write(*,*) ib,';',LLb_1atm(ib),';',LLB_2atm(IB),';'
C                write(*,*) 'iflag:',IFLAG,l

                IF(IFLAG.EQ.1.OR.IFLAG.EQ.3) THEN
                  IF(ATOM1.EQ.LLB_1ATM(IB).AND.
     *               ATOM2.EQ.LLB_2ATM(IB)) THEN
                    ILINK   = L
                    MOD1    = LLL_MOD1(L)
                    MOD2    = LLL_MOD2(L)
                    IREVERS = 0
                    RETURN 
                  ELSE IF(IFLAG.EQ.1.AND.MON1(1:LM1).EQ.MON2(1:LM2))THEN
                    IF(ATOM2.EQ.LLB_1ATM(IB).AND.
     *                 ATOM1.EQ.LLB_2ATM(IB)) THEN
                      ILINK   = L
                      MOD2    = LLL_MOD1(L)
                      MOD1    = LLL_MOD2(L)
                      IREVERS = 1
                      RETURN 
                    ENDIF
                  ENDIF
                ENDIF
                IF(IFLAG.EQ.2.OR.IFLAG.EQ.3) THEN
                  IF(ATOM2.EQ.LLB_1ATM(IB).AND.
     *               ATOM1.EQ.LLB_2ATM(IB)) THEN
                    ILINK   = L
                    MOD2    = LLL_MOD1(L)
                    MOD1    = LLL_MOD2(L)
                    IREVERS = 1
                    RETURN 
                  ELSE IF(IFLAG.EQ.2.AND.MON1(1:LM1).EQ.MON2(1:LM2))THEN
                    IF(ATOM1.EQ.LLB_1ATM(IB).AND.
     *                 ATOM2.EQ.LLB_2ATM(IB)) THEN
                      ILINK   = L
                      MOD1    = LLL_MOD1(L)
                      MOD2    = LLL_MOD2(L)
                      IREVERS = 0
                      RETURN 
                    ENDIF
                  ENDIF
                ENDIF
              ENDIF
            ENDDO

          ELSE

            IF((ATOM1(1:1).EQ.'.'.OR.ATOM1(1:1).EQ.' ').AND.
     *         (ATOM2(1:1).EQ.'.'.OR.ATOM2(1:1).EQ.' ')     ) THEN
              ILINK = L
              RETURN    
            ENDIF

          ENDIF

          IF(LENS.GT.0) THEN
            ILINK = -1
            RETURN
          ENDIF

 100      CONTINUE

        ENDDO

      ENDIF

      RETURN
      END

      SUBROUTINE GET_LINK_ATOM(LINKS,ATOM1,ATOM2,ILINK)
C -----------------------------------------------
C -P-  return ILINK =< 0  not found in table of links ( LLL_ )
C                      N  link's number in the list of links.
C              If LINKS = ' ' or '.' - looking by MON,ATOM,TYPE        
C
C      search by MON, TYPE ( of residue ) , ATOM
C      now used only bonds
C -----------------------------------------------
      INTEGER   ILINK
      CHARACTER LINK*8,LINKS*8,ATOM1*4,ATOM2*4
C ---
      INCLUDE 'lib_com.fh'
C -----------------------------------
      ILINK   = 0

      CALL LENSTR_BL(LINKS,LENS)
      IF(LENS.LE.0.OR.LINKS(1:1).EQ.'.'.OR.LINKS(1:1).EQ.'?'.OR.
     *                LINKS     .EQ.'gap') THEN
        RETURN
      ENDIF     

      IF(LLL_NLINK.GT.0) THEN

        DO L=1,LLL_NLINK

          LINK = LLL_LNAME(L)

          CALL LENSTR_BL(LINK,LENL)
          IF(LENS.EQ.LENL.AND.LINKS(1:LENS).EQ.LINK(1:LENL)) THEN     

            IF(LLB_NBOND.GT.0.AND.LLL_IBOND(L).GT.0) THEN

              DO IB=LLL_IBOND(L),LLB_NBOND

                IF(LLL_LNAME(L).EQ.LLB_LNAME(IB)) THEN
                  ATOM1 = LLB_1ATM(IB)
                  ATOM2 = LLB_2ATM(IB)
                  ILINK = L
                  GO TO 100
                ENDIF
              ENDDO
            ENDIF
          ENDIF
        ENDDO
        ILINK = 0
 100    CONTINUE
      ENDIF

      RETURN
      END

      SUBROUTINE CHECK_LINK_INFO(LINKS,MON1,MON2,ATOM1,ATOM2
     *                         ,DIDEAL,ILINK)
C -----------------------------------------------
C -----------------------------------------------
      INTEGER   ILINK,ITYPE1,ITYPE2
      REAL      DIDEAL
      CHARACTER LINK*8,LATOM1*4,LATOM2*4,LMON1*8,LMON2*8
      CHARACTER LTYPE1*8,LTYPE2*8
      CHARACTER LINKS*8
      CHARACTER MON1*8,MON2*8,ATOM1*4,ATOM2*4
      CHARACTER TYPE1*8,TYPE2*8
      CHARACTER LINE*80,MN1*3,MN2*3
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      ILINK   = 0
      MDOC    = 0
      DIDEAL  = 0.0

      CALL LENSTR_BL(LINKS,LENS)
C      IF(LENS.LE.0.OR.LINKS(1:1).EQ.'.') THEN
C        RETURN
C      ENDIF     

C      DATA RNAMES/'MAN','NAG','FUC','GAL','GLC','GCU','CEG','XYS'/ 
C                  'ARB','RIP','ABE','RAM','MAG','MMA','GSA'   
C      ITYPE = 7
C      RES_LTYPE( 7) =  'pyranose'
C      DATA RNAME /'CYS','SER','THR','PRO','ALA','GLY','ASN','ASP' 
C      ITYPE = 3
C      RES_LTYPE( 3) =  'peptide '
C      DATA RNAMEP/'STA','DFO','FOR','BOC','IVA','NME','ACE','DAM'
C      ITYPE = 10
C      RES_LTYPE(10) =  'polymer '
C      DATA RNAMED/'A  ','C  ','G  ','T  ','U  ','I  ','+A ','+C ' 
C      ITYPE = 5
C      RES_LTYPE( 5) =  'DNA/RNA '
C
C      RES_TYPE( 9) =  'solvent         '
C      RES_TYPE(10) =  'polymer         '
C      RES_TYPE(11) =  'D-furanose      '
C      RES_TYPE(12) =  'L-furanose      '
C      RES_TYPE(13) =  'D-saccharide    '
C      RES_TYPE(14) =  'L-saccharide    '
C
C      RES_LTYPE( 9) =  'solvent '
C      RES_LTYPE(10) =  'polymer '
C      RES_LTYPE(11) =  'furanose'
C      RES_LTYPE(12) =  'furanose'
C      RES_LTYPE(13) =  'sacchari'
C      RES_LTYPE(14) =  'sacchari'

C      CALL SET_INI_RES_TYPE(MDOC,LINE,MON1,ITYPE1,IERR)
C      CALL SET_INI_RES_TYPE(MDOC,LINE,MON2,ITYPE2,IERR)
      CALL GET_INI_RES_TYPE(MDOC,LINE,MON1,ITYPE1,IERR)
      CALL GET_INI_RES_TYPE(MDOC,LINE,MON2,ITYPE2,IERR)

      TYPE1 = RES_LTYPE(ITYPE1)
      TYPE2 = RES_LTYPE(ITYPE2)

      CALL LENSTR_BL(MON1 ,LM1)
      CALL LENSTR_BL(MON2 ,LM2)

      IF((ITYPE1.EQ.7).AND.LM1.GT.3) LM1 = 3
      IF((ITYPE2.EQ.7).AND.LM2.GT.3) LM2 = 3
      MN1 = MON1(1:LM1) 
      MN2 = MON2(1:LM2) 


      IF(LLL_NLINK.GT.0) THEN

        DO L=1,LLL_NLINK

          LINK   = LLL_LNAME(L)
          LTYPE1 = LLL_TYPE1(L)
          LTYPE2 = LLL_TYPE2(L)
          LMON1  = LLL_MON1(L)
          LMON2  = LLL_MON2(L)

C LINK_C-N bond_C_=_N               .   .        polymer  .   .        polymer
C STA_N-C  bond_DFO-N_=_C-peptide   .   .        peptide  DFO .        .       
C XYS-ASN  bond_XYS-C1_=_ASN-ND2    XYS XYS-O1   .        ASN .        .
C ZN-CYS   bond_ZN_=_CYS-SG         ZN  .        .        CYS .        .
C CH2-N2   bond_CH2-CH2_=_Ar-N2     CH2 .        .        .   .        DNA/RNA

          CALL LENSTR_BL(LINK,LENL)
          IF(LENS.LE.0.OR.LINKS(1:1).EQ.'.') THEN
            IL = 1
          ELSE
            IL = 0
            IF(LENS.EQ.LENL.AND.LINKS(1:LENS).EQ.LINK(1:LENL)) IL = 1     
          ENDIF
          IF(LINK.EQ.'gap') IL = 0

          IF(IL.GT.0) THEN

            IT = 0
            IF(LMON1.NE.'.'.AND.LMON2.NE.'.') THEN
              IF(MN1.EQ.LMON1.AND.MN2.EQ.LMON2) IT =1
              IF(MN2.EQ.LMON1.AND.MN1.EQ.LMON2) IT =2
            ELSE IF(LMON1.EQ.'.'.AND.LMON2.NE.'.') THEN
              IF(LTYPE1.NE.'.') THEN
                IF(TYPE1.EQ.LTYPE1.AND.MN2.EQ.LMON2) IT =1
                IF(TYPE2.EQ.LTYPE1.AND.MN1.EQ.LMON2) IT =2
              ELSE
                IF(MN2.EQ.LMON2) IT =1
                IF(MN1.EQ.LMON2) IT =2
              ENDIF
            ELSE IF(LMON1.NE.'.'.AND.LMON2.EQ.'.') THEN
              IF(LTYPE2.NE.'.') THEN
                IF(TYPE2.EQ.LTYPE2.AND.MN1.EQ.LMON1) IT =1
                IF(TYPE1.EQ.LTYPE2.AND.MN2.EQ.LMON1) IT =2
              ELSE
                IF(MN1.EQ.LMON1) IT =1
                IF(MN2.EQ.LMON1) IT =2
              ENDIF
            ELSE
              IF(LTYPE1.NE.'.'.AND.LTYPE2.NE.'.') THEN
                IF(TYPE1.EQ.LTYPE1.AND.TYPE2.EQ.LTYPE2) IT =1
                IF(TYPE2.EQ.LTYPE1.AND.TYPE1.EQ.LTYPE2) IT =2
              ELSE IF(LTYPE1.NE.'.') THEN
                IF(TYPE1.EQ.LTYPE1) IT =1
                IF(TYPE2.EQ.LTYPE1) IT =2
              ELSE IF(LTYPE2.NE.'.') THEN
                IF(TYPE2.EQ.LTYPE2) IT =1
                IF(TYPE1.EQ.LTYPE2) IT =2
              ELSE
                IT = 1
              ENDIF
            ENDIF

            IF(IT.GT.0.AND.LLB_NBOND.GT.0.AND.LLL_IBOND(L).GT.0) THEN

              DO IB=LLL_IBOND(L),LLB_NBOND

                IF(LLL_LNAME(L).EQ.LLB_LNAME(IB)) THEN
                  IF(IT.EQ.1) THEN
                    LATOM1 = LLB_1ATM(IB)
                    LATOM2 = LLB_2ATM(IB)
                  ELSE
                    LATOM2 = LLB_1ATM(IB)
                    LATOM1 = LLB_2ATM(IB)
                  ENDIF
                  DIDEAL = LLB_VAL(IB)
                  IF(ATOM1.EQ.LATOM1.AND.ATOM2.EQ.LATOM2) THEN
                    ILINK = L
                    GO TO 100
                  ENDIF
                ENDIF
              ENDDO

            ENDIF
          ENDIF
        ENDDO
        ILINK = 0
 100    CONTINUE
      ENDIF

      RETURN
      END

C ******
      SUBROUTINE CREAT_LINK(MDOC,LINK,INEW,LNEW,ILINK
     *             ,ITYPE1,ITYPE2
     *             ,MON1,ATOM1,MOD1,MON2,ATOM2,MOD2,DIST,IERR)
C -----------------------------------------------
C -P-  - 
C -S-
C -----------------------------------------------
      REAL       DIST
      INTEGER*4  ILINK,MDOC,IERR
      CHARACTER MON1*8,MON2*8,ATOM1*4,ATOM2*4
      CHARACTER MOD1*8,MOD2*8,LINK*8
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER LINE*256,CH1*1,DETAIL*24
C ---
      COMMON/COM_CRT_LINK/ IFIRST_L,JFIRST_L,IFIRST_M,IFIRST_C
C -----------------------------------
      CALL LENSTR_BL(MON1 ,LM1)
      CALL LENSTR_BL(MON2 ,LM2)
      CALL LENSTR_BL(ATOM1,LA1)
      CALL LENSTR_BL(ATOM2,LA2)
      CALL LENSTR_BL(LINK ,LN )

      IF((ITYPE1.EQ.7.OR.ITYPE1.EQ.8).AND.LM1.GT.3) LM1 = 3
      IF((ITYPE2.EQ.7.OR.ITYPE2.EQ.8).AND.LM2.GT.3) LM2 = 3
 
      INEW = 0
      LNEW = 0

c      write(*,*) '--creat_ln:',ln,lm1,lm2,la1,la2
c      write(*,*) '          :'
c     *  ,link,';',mon1,';',mon2,';',atom1,';',atom2,';'

      IF(LN.LE.0.OR.(LINK(1:1).EQ.'.'.AND.LN.EQ.1)) THEN
        LINK = MON1(1:LM1)//'-'//MON2(1:LM2)
        CALL LENSTR_BL(LINK,LN)
c
C        LNEW = 1
c
      ENDIF

      DETAIL='bond_'//MON1(1:LM1)//'-'//ATOM1(1:LA1)//'_=_'//
     *                MON2(1:LM2)//'-'//ATOM2(1:LA2)
      CALL LENSTR_BL(DETAIL,LND)

      N = 0
      IF(LLL_NLINK.GT.0) THEN     
        DO K=1,LLL_NLINK
          CALL LENSTR_BL(LLL_LNAME(K),LNL)
          IF(LINK(1:LN).EQ.LLL_LNAME(K)(1:LN)) THEN
            IF(LNEW.EQ.1) THEN
              ILINK = K
              RETURN              
            ENDIF
            N = N + 1
            CALL LENSTR_BL(LLL_DETAIL(K),LNDL)
            IF(DETAIL(1:LND).EQ.LLL_DETAIL(K)(1:LNDL)) THEN
              ILINK = K
              RETURN   
            ENDIF
          ENDIF
        ENDDO
      ENDIF

      INEW = 1     
      IF(N.GT.0) THEN
        IF(N.GT.9) N = 0
        WRITE(CH1,'(I1)') N
        LINK = LINK(1:LN)//CH1
      ENDIF  

      IF(LLL_NLINK.GE.MAXLLNK) THEN
        IF(IFIRST_L.EQ.0) THEN
          WRITE(LINE,
     *'('' WARNING : Number of links  >'',I6)') MAXLLNK
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Change parameter MAXLLNK in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Now program stops to create new links.'')')
          CALL MSGERR(MDOC,LINE)
          IFIRST_L = 1
        ENDIF 
        ILINK = 0
        RETURN
      ELSE
        IFIRST_L = 0
      ENDIF

      LLL_NLINK = LLL_NLINK+1
      LLL_ILINK = LLL_NLINK
      ILINK     = LLL_NLINK

      CALL LENSTR_BL(LINK,LN)
      LLL_LNAME (ILINK) = LINK(1:LN)
      LLL_CODE1 (ILINK) = 'x'
      LLL_DETAIL(ILINK) = DETAIL
      LLL_MON1  (ILINK) = MON1(1:LM1)
      LLL_MON2  (ILINK) = MON2(1:LM2)
      LLL_MOD1  (ILINK) = MOD1
      LLL_MOD2  (ILINK) = MOD2
      LLL_TYPE1 (ILINK) = '.'
      LLL_TYPE2 (ILINK) = '.'
      LLL_FUSE  (ILINK) = 'C'
      LLL_ICONN (ILINK) = 0
      LLL_IATOM (ILINK) = 0
      LLL_IBOND (ILINK) = 0
      LLL_ITHET (ILINK) = 0
      LLL_IPLAN (ILINK) = 0
      LLL_ICHIR (ILINK) = 0
      LLL_ITORS (ILINK) = 0

      IF((LA1.LE.0.OR.ATOM1(1:1).EQ.'.').OR.
     *   (LA2.LE.0.OR.ATOM2(1:1).EQ.'.')    ) RETURN

      IF(LLB_NBOND.GE.MAXLBND) THEN
        WRITE(LINE,
     *'('' ERROR: number of bonds for the links >'',I6)') MAXLBND
        CALL MSGERR(MDOC,LINE)
        WRITE(LINE,
     *'(''        Change parameter MAXLBND in "lib_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
        IERR=1
        RETURN
      ENDIF

      LLB_NBOND            = LLB_NBOND+1
      LLL_IBOND(ILINK)     = LLB_NBOND
      LLB_LNAME(LLB_NBOND) = LLL_LNAME (ILINK)
      LLB_1ATM (LLB_NBOND) = ATOM1
      LLB_2ATM (LLB_NBOND) = ATOM2
      LLB_F1ATM(LLB_NBOND) = 1
      LLB_F2ATM(LLB_NBOND) = 2

      LLB_VAL  (LLB_NBOND) = DIST

      LLB_DEV  (LLB_NBOND) = 0.0
      LLB_VOBS (LLB_NBOND) = DIST
      LLB_TYPE (LLB_NBOND) = '.'

      RETURN
      END



C ******
      SUBROUTINE PUT_L_TABL(MDOC,LINK,JCH1,JCH2,JRES1,JRES2
     *                     ,JA1,JA2,IREVERS,IERR)
C -----------------------------------------------
C -P-   
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      INTEGER*4 JCH1,JCH2,JRES1,JRES2,JA1,JA2
      INTEGER*4 ICH1,ICH2,IRES1,IRES2,IA1,IA2
      CHARACTER LINK*8
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER LINE*256,ATOM1*4,ATOM2*4
C ---
      COMMON/COM_CRT_LINK/ IFIRST_L,JFIRST_L,IFIRST_M,IFIRST_C
C -----------------------------------
      IERR=0
      IF(LINK(1:1).EQ.'.'.OR.LINK(1:1).EQ.' ') RETURN

      IF(IREVERS.EQ.0) THEN
        ICH1  = JCH1
        ICH2  = JCH2
        IRES1 = JRES1
        IRES2 = JRES2
        IA1   = JA1
        IA2   = JA2
      ELSE
        ICH1  = JCH2
        ICH2  = JCH1
        IRES1 = JRES2
        IRES2 = JRES1
        IA1   = JA2
        IA2   = JA1
      ENDIF


      IF(LLL_NLINK.GT.0) THEN
        DO L=1,LLL_NLINK
          IF(LLL_LNAME(L).EQ.LINK) THEN
            IF(LLL_FUSE(L).NE.'?'.AND.LLL_FUSE(L).NE.'C') 
     *      LLL_FUSE(L)='Y'
            GO TO 100
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')
     *' WARNING : in "put_l_table", description of link :',LINK
     *       ,' is not in the library'
        CALL MSGDOC(MDOC,LINE)
C ?????
c        CALL MSGDOC(MDOC,'       It will be ignored.)
c        RETURN
 100    CONTINUE
      ENDIF

      IF(LN_N.GT.0) THEN
        IF(IA1.GT.0.AND.IA2.GT.0) THEN
          DO IC=1,LN_N
            IF(LN_ID   (IC).EQ.LINK       .AND.
     *         LN_1IRES(IC).EQ.IRES1      .AND.
     *         LN_2IRES(IC).EQ.IRES2      .AND.
     *         LN_ALT1 (IC).EQ.ID_ALT(IA1).AND.
     *         LN_ALT2 (IC).EQ.ID_ALT(IA2).AND.
     *         LN_1ICHN(IC).EQ.ICH1       .AND.
     *         LN_2ICHN(IC).EQ.ICH2            ) THEN
              RETURN
            ENDIF 
          ENDDO
        ELSE
          DO IC=1,LN_N
            IF(LN_ID   (IC).EQ.LINK       .AND.
     *         LN_1IRES(IC).EQ.IRES1      .AND.
     *         LN_2IRES(IC).EQ.IRES2      .AND.
     *         LN_1ICHN(IC).EQ.ICH1       .AND.
     *         LN_2ICHN(IC).EQ.ICH2            ) THEN
              RETURN
            ENDIF 
          ENDDO
        ENDIF
      ENDIF

      IF(LN_N.GE.MAXLINK) THEN
        IF(JFIRST_L.EQ.0) THEN
          WRITE(LINE,
     *'('' WARNING : Number of links >'',I6)') MAXLINK
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Change parameter MAXLINK in "atom_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Now program stops to use new links.'')')
          CALL MSGERR(MDOC,LINE)
          JFIRST_L = 1
        ENDIF
        RETURN
      ELSE
        JFIRST_L = 0
      ENDIF

      LN_N             = LN_N + 1
      LN_ID   (LN_N)   = LINK
      LN_1IRES(LN_N)   = IRES1
      LN_2IRES(LN_N)   = IRES2
      LN_1RNAM(LN_N)   = RES_NAME(IRES1)
      LN_2RNAM(LN_N)   = RES_NAME(IRES2)
      LN_1ICHN(LN_N)   = ICH1 
      LN_2ICHN(LN_N)   = ICH2     
      LINK_FLAG(IRES1) = 'Y'
      LINK_FLAG(IRES2) = 'Y'
      LN_SEQ1 (LN_N)   = '.'
      LN_SEQ2 (LN_N)   = '.'
      IF(IA1.GT.0) THEN    
        LN_ATOM1(LN_N)   = ATM_NAME(IA1)
        LN_ALT1 (LN_N)   = ID_ALT  (IA1)
      ELSE
        LN_ATOM1(LN_N)   = '.'
        LN_ALT1 (LN_N)   = '.'
      ENDIF
      IF(IA2.GT.0) THEN    
        LN_ATOM2(LN_N)   = ATM_NAME(IA2)
        LN_ALT2 (LN_N)   = ID_ALT  (IA2)
      ELSE
        LN_ATOM2(LN_N)   = '.'
        LN_ALT2 (LN_N)   = '.'
      ENDIF
      LN_SYMM1(LN_N)   = '.'
      LN_SYMM2(LN_N)   = '.'
      LN_DIST (LN_N)   = 0.0

      ATOM1 = LN_ATOM1(LN_N)(1:4)
      ATOM2 = LN_ATOM2(LN_N)(1:4)

      CALL CHECK_LINK_INFO(LINK,LN_1RNAM(LN_N),LN_2RNAM(LN_N)
     *                    ,ATOM1,ATOM2
     *                    ,DIDEAL,ILINK)
      IF(ILINK.GT.0) LN_DIST (LN_N) = DIDEAL
C
C           LN_ENT    E - form ent_poly_seq (not trans 2 , ptrans 36 , p 4)
C                     L - form ent_link
C                     C - from conn
C
      LN_USED (LN_N)   = '.'
      LN_ENT  (LN_N)   = 'C'

      RETURN
      END

C ******
      SUBROUTINE PUT_M_TABL(MDOC,MOD,ICH,IRES,IA,MON,MTYPE,IERR)    
C -----------------------------------------------
C -P-  - 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      INTEGER*4 ICH,IRES
      CHARACTER MOD*8,MON*8,MTYPE*1
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER LINE*256
C ---
      COMMON/COM_CRT_LINK/ IFIRST_L,JFIRST_L,IFIRST_M,IFIRST_C
C -----------------------------------
      IERR=0
      IF(MON(1:1).NE.' ') THEN
        GO TO 200
      ENDIF
      IF(MOD(1:1).EQ.'.') THEN
        RETURN
      ENDIF
      IF(LDL_NMOD.GT.0) THEN
        DO L=1,LDL_NMOD
          IF(LDL_MNAME(L).EQ.MOD) THEN
            IF(LDL_FUSE(L).NE.'?'.AND.LDL_FUSE(L).NE.'C') 
     *      LDL_FUSE(L)='Y'
            GO TO 100
          ENDIF
        ENDDO
        WRITE(LINE,'(A,A8,A)')' WARNING : description of modification:',
     *  MOD,     ' is not in the dictionary'
        CALL MSGDOC(MDOC,LINE)
C ?????
c        CALL MSGDOC(MDOC,'       It will be ignored.)
C        RETURN
 100    CONTINUE
      ENDIF

      IF(MOD.NE.'RENAME') MON = '.' 

 200  CONTINUE

      IF(MOD_N.GT.0) THEN
        DO IC=1,MOD_N
          IF(MOD_ID  (IC).EQ.MOD .AND.
     *       MOD_IRES(IC).EQ.IRES.AND.
     *       MOD_ICHN(IC).EQ.ICH      ) THEN
            RETURN
          ENDIF
        ENDDO
      ENDIF

c 200  CONTINUE

      IF(MOD_N.GE.MAXMODIF) THEN
        IF(IFIRST_M.EQ.0) THEN
          WRITE(LINE,
     *'('' WARNING : Number of modifications >'',I6)') MAXMODIF
          CALL MSGERR(MDOC,LINE)
          WRITE(LINE,
     *'(''           Change parameter MAXMODIF in "atom_com.fh"'')')
          CALL MSGERR(MDOC,LINE)
c          WRITE(LINE,
c     *'(''           Now program stops to use new modifications.'')')
c          CALL MSGERR(MDOC,LINE)
          IFIRST_M=1
        ENDIF
        IERR = 1
        RETURN
      ELSE
        IFIRST_M=0
      ENDIF

      MOD_N               = MOD_N + 1
      MOD_ID  (MOD_N)     = MOD
      MOD_IRES(MOD_N)     = IRES
      MOD_RNAM(MOD_N)     = MON

      MOD_RNAM_NEW(MOD_N) = RES_NAME(IRES)

      MOD_ICHN(MOD_N)     = ICH 
      MOD_FLAG(IRES)      = 'Y'
      MOD_SEQ (MOD_N)     = '.'
      MOD_USED(MOD_N)     = MTYPE

      RETURN
      END

C ******
      SUBROUTINE DEF_SPEC_POS(MDOC,CHECK_SPEC,DMIN,IERR)    
C -----------------------------------------------
C -P-   
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
      REAL      XC(3),XF(3)
      CHARACTER MON*8,CHECK_SPEC*1
      CHARACTER LINE*256
C -----------------------------------
      IERR  = 0
C ---
      IF(N_GROUP.LE.0.OR.N_ATOM.LE.0) THEN
        CALL MSGERR(MDOC,
     *  'ERROR: in "DEF_SPEC_POS", N_GROUP or N_ATOM = 0')
        IERR=1
        RETURN
      ENDIF

      DMIN2    = DMIN*DMIN

      N_R      = N_RESIDUE

C v-- check spec. position
      IMULT    = 1      
      IF(DMIN.GT.0.0) THEN
        DO    I=1,N_R
          IAS  = IRATM_FIRST   (I)
          IAF  = IRATM_FIRST(I)+NATM_RES(I)-1
          MON  = RES_NAME  (I)
          DO IA=IAS,IAF

            IF(OCCUP(IA).GT.0.0001.AND.ATM_TYPE(IA).NE.'M'.AND.
     *         ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN

              XC(1) = XYZ_CRD(1,IA)
              XC(2) = XYZ_CRD(2,IA)
              XC(3) = XYZ_CRD(3,IA)
              CALL NB_OTOF(XC,XF,IERR)

C              CALL NB_SPEC_POS(XF(1),XF(2),XF(3)
C     *        ,DLIMX,DLIMY,DLIMZ,MULT)

              CALL CHECK_SPEC_POS(XF,DMIN2,MULT)

              IF(MULT.NE.1) THEN

                IF(CHECK_SPEC.EQ.'Y') THEN
                  MULT_FACTOR(IA)  = MULT
                  WRITE(LINE,'(A,A4,A,A1,A,A,A,A,A,A,A)')
     *' WARNING : Atom ',ATM_NAME(IA),' ',ID_ALT(IA),' of residue: ',
     *MON,' Ir:',RES_NUM_PDB(I)(3:7),' ch:',RES_NUM_PDB(I),
     *' in spec. position'
                  CALL MSGDOC(MDOC,LINE)
                  WRITE(LINE,'(A,I3,A)')
     *'           mult=',MULT,';  please, check occupancy.'
                  CALL MSGDOC(MDOC,LINE)
                  IMULT = 0
                ELSE
                  WRITE(LINE,'(A,A4,A,A1,A,A,A,A,A,A,A)')
     *' INFO:     Atom ',ATM_NAME(IA),' ',ID_ALT(IA),' of residue: ',
     *MON,' Ir:',RES_NUM_PDB(I)(3:7),' ch',RES_NUM_PDB(I),
     *' in spec. position'
                  CALL MSGDOC(MDOC,LINE)
                  WRITE(LINE,'(A,I3,A,I3,A)')
     *'           mult=',MULT,', now atom"s mult=',MULT_FACTOR(IA),
     *' program did not change it'
                  CALL MSGDOC(MDOC,LINE)
C                 IMULT = 0

                ENDIF

              ENDIF   
            ENDIF
          ENDDO
        ENDDO
        IF(OUT_CIF_MULT.EQ.1.AND.IMULT.EQ.0) OUT_CIF_MULT = 0 
      ENDIF
C ^--end  check spec. position
      RETURN
      END

      SUBROUTINE CALC_PEP_BOND_ANGLE(MDOC,ANGOBS,IERR)
C -----------------------------------------------
C
C -----------------------------------------------
      INCLUDE 'lib_com.fh'
C -------------------------------------------------------------------
C      PARAMETER ( NSTOR_PAR = 50 )
C      COMMON /COM_CONN_INF/  N_STOR,IFLAG_STOR,ICONN_ATOM_IND
C     *                      ,X_STOR,Y_STOR,Z_STOR
C     *                      ,ATOM_STOR
C -------------------------------------------------------------------
C      INTEGER    N_STOR,IFLAG_STOR(NSTOR_PAR,2)
C      REAL       X_STOR(NSTOR_PAR,2),Y_STOR(NSTOR_PAR,2)
C     *          ,Z_STOR(NSTOR_PAR,2)
C      CHARACTER  ATOM_STOR(NSTOR_PAR)*4
C ---
C      INTEGER    ICONN_ATOM_IND(2,MAXLLNK)
C -------------------------------------------------------------------
      CHARACTER ATOM*4
C     CHARACTER LINE*256
C -----------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C !!!
      IERR  = 1
C --
      ATOM = 'CA  '
      IR   = 1
      DO I=1,N_STOR
        IF(ATOM.EQ.ATOM_STOR(I).AND.IFLAG_STOR(I,IR).GT.0) THEN
          X1 = X_STOR(I,IR)         
          Y1 = Y_STOR(I,IR)         
          Z1 = Z_STOR(I,IR)         
          GO TO 100
        ENDIF
      ENDDO
      RETURN
 100  CONTINUE
C --
      ATOM = 'C   '
      IR   = 1
      DO I=1,N_STOR
        IF(ATOM.EQ.ATOM_STOR(I).AND.IFLAG_STOR(I,IR).GT.0) THEN
          X2 = X_STOR(I,IR)         
          Y2 = Y_STOR(I,IR)         
          Z2 = Z_STOR(I,IR)         
          GO TO 200
        ENDIF
      ENDDO
      RETURN
 200  CONTINUE
C --
      ATOM = 'N   '
      IR   = 2
      DO I=1,N_STOR
        IF(ATOM.EQ.ATOM_STOR(I).AND.IFLAG_STOR(I,IR).GT.0) THEN
          X3 = X_STOR(I,IR)         
          Y3 = Y_STOR(I,IR)         
          Z3 = Z_STOR(I,IR)         
          GO TO 300
        ENDIF
      ENDDO
      RETURN
 300  CONTINUE
C --
      ATOM = 'CA  '
      IR   = 2
      DO I=1,N_STOR
        IF(ATOM.EQ.ATOM_STOR(I).AND.IFLAG_STOR(I,IR).GT.0) THEN
          X4 = X_STOR(I,IR)         
          Y4 = Y_STOR(I,IR)         
          Z4 = Z_STOR(I,IR)         
          GO TO 400
        ENDIF
      ENDDO
      RETURN
 400  CONTINUE
C ---
      A1 = X2-X1
      B1 = Y2-Y1
      C1 = Z2-Z1

      A2 = X3-X2
      B2 = Y3-Y2
      C2 = Z3-Z2

      A3 = X4-X3
      B3 = Y4-Y3
      C3 = Z4-Z3

      DN1X = B1*C2-B2*C1
      DN1Y = A1*C2-A2*C1
      DN1Z = A1*B2-A2*B1
      DN2X = B2*C3-B3*C2
      DN2Y = A2*C3-A3*C2
      DN2Z = A2*B3-A3*B2
      E1   = DN1X*DN2X+DN1Y*DN2Y+DN1Z*DN2Z
      E2   = SQRT(ABS(DN1X*DN1X+DN1Y*DN1Y+DN1Z*DN1Z))
      E3   = SQRT(ABS(DN2X*DN2X+DN2Y*DN2Y+DN2Z*DN2Z))
      IF(E2.LT.1.E-9.OR.E3.LT.1.E-9) THEN
        IF(E1.GE.0.) COSG =  1.0
        IF(E1.LT.0.) COSG = -1.0
      ELSE
        T    = E2*E3
        IF(ABS(T).GT.1.0E-8) THEN 
          COSG = E1/T
        ELSE
          COSG = 1.0
        ENDIF
      ENDIF
      ABC    = A1*DN2X-A2*(B1*C3-B3*C1)+A3*DN1X
      SS     = ABS(1.0 - COSG*COSG)
      SING   = SIGN(1.0,ABC)*SQRT(SS)
      ANGOBS = ATAN2(SING,COSG)
      IF(ANGOBS.GT.TWOPI) ANGOBS = ANGOBS - TWOPI
      IF(ANGOBS.LT. 0.0 ) ANGOBS = ANGOBS + TWOPI
      ANGOBS = ANGOBS/PI180
C ---
      IERR = 0

      RETURN
      END

C ******
      SUBROUTINE SET_CHAIN(MDOC,SUGAR_FLAG,CHAIN_FLAG,LIST,IERR)    
C -----------------------------------------------
C -P- SET_CHAIN - create new list of chains.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C ******
C     INTEGER*2 ICH
C     REAL      XC(3),XF(3)
C     CHARACTER CH*1,CH2*2,CHAIN*2,CHAIN_FLAG*1

      CHARACTER CHAIN_FLAG*1
      CHARACTER MON*8,MON2*8,MONOLD*8,PNUM*12,CHAR1*1,SUGAR_FLAG*1
      CHARACTER LINE*256
      CHARACTER LINK*8,ATOM1*4,ATOM2*4,CHAR5*5,CHAR8*8,LIST*1
C     EQUIVALENCE (CH2,ICH),(CH2(2:2),CH)
C ---
      COMMON/COM_CRT_LINK/ IFIRST_L,JFIRST_L,IFIRST_M,IFIRST_C
C -----------------------------------
      PI    = 4.0*ATAN(1.0)
C     TWOPI = 2.0*PI
C     PI180 = PI/180.0
      IERR  = 0
C ---
      IF(N_GROUP.LE.0.OR.N_ATOM.LE.0) THEN
        CALL MSGERR(MDOC,
     *  'ERROR: in "SET_CHAIN", N_GROUP or N_ATOM = 0')
        IERR = 1
        RETURN
      ENDIF

      MONOLD   = '?'
      IRES     = 0
      N_GROUP  = 0
      N_R      = N_RESIDUE
      ICH0     = 0
      IFIRST_C = 0

      IF(LN_N.GT.0) THEN
        DO ILN=1,LN_N

c        write(*,*) '==',LN_ID(ILN),';',
c     *   LN_1IRES(ILN),LN_2IRES(ILN),LN_1ICHN(ILN),LN_2ICHN(ILN)
c        write(*,*) '   ',LN_ATOM1(ILN),';',LN_ATOM2(ILN),';'
          
          LINK = LN_ID(ILN) 
             
          IF(LINK(1:1).NE.'.'.AND.LINK(1:1).NE.'?') THEN

            CALL GET_LINK_ATOM(LINK,ATOM1,ATOM2,IT)
            IF(IT.GT.0.AND.
     *         LN_ATOM1(ILN)(1:4).EQ.ATOM2.AND.
     *         LN_ATOM2(ILN)(1:4).EQ.ATOM1     ) THEN

              ITEMP         = LN_1ICHN(ILN)
              LN_1ICHN(ILN) = LN_2ICHN(ILN)
              LN_2ICHN(ILN) = ITEMP
              ITEMP         = LN_1IRES(ILN)
              LN_1IRES(ILN) = LN_2IRES(ILN)
              LN_2IRES(ILN) = ITEMP
              CHAR5         = LN_ATOM1(ILN)
              LN_ATOM1(ILN) = LN_ATOM2(ILN)
              LN_ATOM2(ILN) = CHAR5
              CHAR5         = LN_SEQ1(ILN)
              LN_SEQ1(ILN)  = LN_SEQ2(ILN)
              LN_SEQ2(ILN)  = CHAR5
              CHAR8         = LN_1RNAM(ILN)
              LN_1RNAM(ILN) = LN_2RNAM(ILN)
              LN_2RNAM(ILN) = CHAR8
              CHAR8         = LN_SYMM1(ILN)
              LN_SYMM1(ILN) = LN_SYMM2(ILN)
              LN_SYMM2(ILN) = CHAR8
              CHAR1         = LN_ALT1(ILN)
              LN_ALT1(ILN)  = LN_ALT2(ILN)
              LN_ALT2(ILN)  = CHAR1

            ENDIF
          ENDIF

        ENDDO
      ENDIF

      DO    I=1,N_R
        ITYPE  = ICONN_TYPE(I)
        IF(LN_N.GT.0.AND.I.GT.1) THEN
          I1 = I -1
          IGRP1 = I_CHAIN(I1) 
          IGRP2 = I_CHAIN(I ) 
c          IF(IGRP1.NE.IGRP2) THEN            
          IF(IGRP1.NE.IGRP2.AND.
     *      RES_NUM_PDB(I)(3:7).NE.RES_NUM_PDB(I1)(3:7) ) THEN            
            DO ILN=1,LN_N
              IR1   = LN_1IRES(ILN)
              IR2   = LN_2IRES(ILN) 
              ICH1  = LN_1ICHN(ILN)
              ICH2  = LN_2ICHN(ILN)
              IF(ICH1.EQ.IGRP1.AND.I1.EQ.IR1.AND.
     *           ICH2.EQ.IGRP2.AND.I .EQ.IR2.AND.     
     *           LN_USED(ILN).NE.'S'              ) THEN
                LINK = LN_ID(ILN)
                CALL SET_ICONN(LINK,ICONN)
                IF(ITYPE.LE.1.AND.ICONN.GT.1.AND.
     *                            ICONN.LE.N_CONN_TYPE) THEN

               IF(CR_SEGFLAG.NE.'Y') THEN
                 IF(RES_NUM_PDB(I)(8:8).EQ.
     *             RES_NUM_PDB(I1)(8:8) ) ICONN_TYPE(I) = ICONN
               ELSE
                 IF(RES_NUM_PDB(I)(8:11).EQ.
     *             RES_NUM_PDB(I1)(8:11) ) ICONN_TYPE(I) = ICONN
               ENDIF

                ENDIF
              ENDIF
            ENDDO
          ENDIF
        ENDIF

c        MON    = RES_NAME  (I)
c        write(*,*) '>>',i,mon,itype, ICONN_TYPE(I)

      ENDDO

C ---start cycle by residues
      DO    I=1,N_R

        MON    = RES_NAME  (I)
        ITYPE  = ICONN_TYPE(I)

C      CONN_TYPE( 1) = '.       '
C      CONN_TYPE( 2) = 'TRANS   '
C      CONN_TYPE( 3) = 'CIS     '
C      CONN_TYPE( 4) = 'p       '
C      CONN_TYPE( 5) = 'FOR_C-N '
C      CONN_TYPE( 6) = 'FOR_C-C '
C      CONN_TYPE( 7) = 'ACE_C-N '
C      CONN_TYPE( 8) = 'DFO_C-N '
C      CONN_TYPE( 9) = 'NME_N-C '
C      CONN_TYPE(10) = 'gap     '
C      CONN_TYPE(11) = 'SUGAR   '
C      CONN_TYPE(12) = 'BETA1-2 '
C      CONN_TYPE(13) = 'BETA1-3 '
C      CONN_TYPE(14) = 'BETA1-4 '
C      CONN_TYPE(15) = 'BETA1-6 '
C      CONN_TYPE(16) = 'ALPHA1-2'
C      CONN_TYPE(17) = 'ALPHA1-3'
C      CONN_TYPE(18) = 'ALPHA1-4'
C      CONN_TYPE(19) = 'ALPHA1-6'
C      CONN_TYPE(20) = 'IVA_C-N '
C      CONN_TYPE(21) = 'DFO-NME '
C      CONN_TYPE(22) = 'BOC_C-N '
C      CONN_TYPE(23) = 'DFO_N-C '
C      CONN_TYPE(24) = 'STA-NME '
C      CONN_TYPE(25) = 'STA_C-N '
C      CONN_TYPE(26) = 'STA_N-C '
C      CONN_TYPE(27) = 'STA_DFO '
C      CONN_TYPE(28) = 'DFO_STA '
C      CONN_TYPE(29) = 'STA_STA '
C      CONN_TYPE(30) = 'DFO_DFO '
C      CONN_TYPE(31) = 'ILG_CD-N'
C      CONN_TYPE(32) = 'ILG_CD-p'
C      CONN_TYPE(33) = 'LINK_C-N'
C      CONN_TYPE(34) = 'LINK_CNp'
C      CONN_TYPE(35) = 'LINK_CpN'
C      CONN_TYPE(36) = 'PTRANS'
C      CONN_TYPE(37) = 'PCIS'
C
        IRTYPE = IRES_TYPE (I)

c      DATA RES_TYPE /
c     1  '.               ',
c     2  'non-polymer     ',
c     3  'L-peptide       ',
c     4  'D-peptide       ',
c     5  'DNA             ',
c     6  'RNA             ',
c     7  'D-saccharide    ',
c     8  'L-saccharide    ',
c     9  'solvent         ',
c     *  'polymer         ' /
c      DATA CH_TYPE / 
c     1 '.       ',
c     2 'monomer ',
c     3 'polypept',
c     4 'polypept',
c     5 'DNA     ',
c     6 'RNA     ',
c     7 'sacchari',
c     8 'sacchari',
c     9 'solvent ',
c     * 'polypept' /

        IAS    = IRATM_FIRST   (I)
        IAF    = IRATM_FIRST(I)+NATM_RES(I)-1

        IF(I.EQ.1) THEN
C         first residue - start chain
          IF(IRTYPE.EQ.7.OR.IRTYPE.EQ.8) THEN
            IRES_BACK(I) = -1   
            IRES_FORW(I) =  0   
          ENDIF
          ICH_FLAG = 0
        ELSE IF(MON.EQ.MONOLD.AND.(MON.EQ.'HOH'.OR.MON.EQ.'DUM')) THEN
C         water chain
          ICH_FLAG = 1
          I1       = I - 1

          IF(CR_SEGFLAG.NE.'Y') THEN
            IF(RES_NUM_PDB(I)(8:9).NE.
     *         RES_NUM_PDB(I1)(8:9)) ICH_FLAG = 0
          ELSE
            IF(RES_NUM_PDB(I)(8:11).NE.
     *         RES_NUM_PDB(I1)(8:11)) ICH_FLAG = 0
          ENDIF

        ELSE IF(ITYPE .GT.1.AND.ITYPE .LE.N_CONN_TYPE.AND.
     *          IRTYPE.NE.7.AND.IRTYPE.NE.8.AND.
     *          IRTYPE.NE.1.AND.IRTYPE.NE.2               ) THEN
C         chain continue
          ICH_FLAG = 1
          IRTYPE1 = IRES_TYPE(I-1)
          IF(IRTYPE.EQ.3.OR.IRTYPE.EQ.4) THEN
            IF(IRTYPE1.NE.3.AND.IRTYPE1.NE.4.AND.IRTYPE1.NE.10) 
     *      ICH_FLAG = 0
          ENDIF

        ELSE
C         new chain
          ICH_FLAG = 0

          IF(IRTYPE.EQ.7.OR.IRTYPE.EQ.8) THEN
            IRES_BACK(I) = -1   
            IRES_FORW(I) =  0   
          ENDIF

          I1 = I - 1
          IRTYPE1 = IRES_TYPE(I1)

          IF((IRTYPE .EQ.7.OR.IRTYPE .EQ.8).AND.
     *       (IRTYPE1.EQ.7.OR.IRTYPE1.EQ.8)     ) THEN
C           saccharide
C           IRES_BACK(N_RESIDUE  ) = N_RESIDUE-1 
C           IRES_FORW(N_RESIDUE-1) = N_RESIDUE 
         
            DO I1=ICH0,I-1
              IF(RES_NUM_PDB(I)(3:7).NE.RES_NUM_PDB(I1)(3:7)) THEN            

              IF(LN_N.GT.0) THEN
                DO ICN=1,LN_N
                  LINK = LN_ID(ICN)
                  CALL SET_ICONN(LINK,ICONN)
                  IF(ICONN.GT.1.AND.ICONN.LE.N_CONN_TYPE.AND.
     *              LN_USED(ICN).NE.'S'              ) THEN

                    IF(LN_1IRES(ICN).EQ.I1.AND.LN_2IRES(ICN).EQ.I) THEN
C                   chain continue  i1-->i
                      IRES_BACK(I)  = I1   
                      IF(IRES_FORW(I1).LE.0) IRES_FORW(I1) = I   
                      ICH_FLAG      = 1
                      GO TO 300   
                    ELSE IF(LN_2IRES(ICN).EQ.I1.AND.LN_1IRES(ICN).EQ.I)
     *              THEN
C                   chain continue  i1<--i
                      IRES_BACK(I1) = I   
                      IRES_FORW(I)  = I1   
                      ICH_FLAG      = 1
                      GO TO 300   
                    ENDIF

                  ENDIF
                ENDDO
              ENDIF

              ENDIF
            ENDDO
          ENDIF

         
        ENDIF
 
 300    CONTINUE

        IF(ICH_FLAG.EQ.0) THEN
C         start of new chain 
          ICH0 = I
          IF(N_GROUP.GE.MAXCHAIN) THEN
            IF(IFIRST_C.EQ.0) THEN
              WRITE(LINE,
     *'('' WARNING : Number of chains >'',I6)') MAXCHAIN
              CALL MSGERR(MDOC,LINE)
              WRITE(LINE,
     *'(''           Change parameter MAXCHAIN in "atom_com.fh"'')')
              CALL MSGERR(MDOC,LINE)

              IERR = 1
              RETURN

C              WRITE(LINE,
C     *'(''           Now program stops to create new chains !!!'')')
C              CALL MSGERR(MDOC,LINE)
C              IFIRST_C=1

            ENDIF
            GO TO 100
          ELSE
            IFIRST_C=0
          ENDIF

          N_GROUP                 = N_GROUP +1
          IRES_FIRST   (N_GROUP)  = I

          ITERM_S_TYPE (N_GROUP)  = 1
          ITERM_F_TYPE (N_GROUP)  = 1

          NRES_CHAIN   (N_GROUP)  = 0
          NATM_CHAIN   (N_GROUP)  = 0

          PNUM = RES_NUM_PDB(I)

          RES_NUM_PDB(I) = PNUM

          CHAIN_ID   (N_GROUP)  = RES_NUM_PDB(I)(8:11)

          N_GROUP               = N_GROUP 
          ICHAIN_GRP (N_GROUP)  = N_GROUP
          GROUP_ID   (N_GROUP)  = RES_NUM_PDB(I)(8:11)  
          IATOM_FIRST(N_GROUP)  = IAS
          NCS_FLAG   (N_GROUP)  = '.'
          I_NCS      (N_GROUP)  = 0
          MULT_FLAG  (N_GROUP)  = 0

          IF(IRTYPE.EQ.7.OR.IRTYPE.EQ.8) THEN
            IRES_START_TREE(N_GROUP) = I 
          ENDIF

        ENDIF
 100    CONTINUE

        IF(IRTYPE.NE.7.AND.IRTYPE.NE.8) THEN
          IRES_FORW(I) = 0 
          IF(NRES_CHAIN(N_GROUP).EQ.0) THEN
            IRES_BACK(I)     = -1   
            IRES_START_TREE(N_GROUP) = I 
          ELSE
            IRES_BACK(I)   = I-1 
            IRES_FORW(I-1) = I 
          ENDIF
          IRES_END_TREE(N_GROUP) = I 
        ELSE 
          IRES_END_TREE(N_GROUP) = I 
        ENDIF

        NRES_CHAIN (N_GROUP)  = NRES_CHAIN(N_GROUP)  + 1
        NATM_CHAIN (N_GROUP)  = NATM_CHAIN(N_GROUP)  + NATM_RES(I)

        I_CHAIN    (I)        = N_GROUP

        RES_NUM_PDB(I)(1:2)   = GROUP_ID(N_GROUP)(1:2)
        RES_NUM_PDB(I)(8:11)  = GROUP_ID(N_GROUP)


        IF(NRES_CHAIN(N_GROUP).LE.1) THEN
          ICH_TYPE(N_GROUP) = 2
        ELSE
          ICH_TYPE(N_GROUP) = 10
          IF(IRTYPE.EQ.3.OR.IRTYPE.EQ.4.OR.IRTYPE.EQ.10) THEN
            ICH_TYPE(N_GROUP) = 3
          ELSE IF(IRTYPE.EQ.5.OR.IRTYPE.EQ.6) THEN
            ICH_TYPE(N_GROUP) = 5
          ELSE IF(IRTYPE.EQ.7.OR.IRTYPE.EQ.8) THEN
            ICH_TYPE(N_GROUP) = 7
          ENDIF
        ENDIF
        IF(MON.EQ.'HOH'.OR.MON.EQ.'DUM') THEN
          ICH_TYPE(N_GROUP) = 9
        ENDIF

        MONOLD = MON

      ENDDO
C ---end cycle by residues

      IF(LN_N.GT.0) THEN
        DO I=1,LN_N
          IR1         = LN_1IRES(I)
          IR2         = LN_2IRES(I) 
          LN_1ICHN(I) = I_CHAIN(IR1)
          LN_2ICHN(I) = I_CHAIN(IR2)
        ENDDO
      ENDIF

      IF(MOD_N.GT.0) THEN
        DO I=1,MOD_N
          IR          = MOD_IRES(I)
          MOD_ICHN(I) = I_CHAIN(IR) 
        ENDDO
      ENDIF
C -----
      DO IG=1,N_GROUP

        NR  = NRES_CHAIN  (IG)
        IRS = IRES_FIRST  (IG)
        IRF = IRS+NR-1         

        DO IR=IRS,IRF
          
          ITYPE = IRES_TYPE(IR)
          MON   = RES_NAME (IR)

          IF(MOD_N.GT.0) THEN
            DO IM = 1,MOD_N
              IF(MOD_IRES   (IM).EQ.IR  .AND.
     *          MOD_ICHN    (IM).EQ.IG  .AND.
     *          MOD_RNAM    (IM).NE.'.' .AND.
     *          MOD_RNAM_NEW(IM).EQ.MON      ) THEN
                MON      = MOD_RNAM(IM)
                GO TO 700
              ENDIF
            ENDDO
          ENDIF
 700      CONTINUE


          IF(ITYPE.EQ.7.OR.ITYPE.EQ.8) THEN
C           --- sugar
            IF(LN_N.GT.0) THEN
              DO IL=1,LN_N
                LINK = LN_ID(IL)

c            write(*,*) il,link,ig,ir,LN_ATOM1(IL),LN_ATOM2(IL)
c     *      ,LN_1ICHN(IL),LN_2ICHN(IL)
c     *      ,LN_1IRES(IL),LN_2Ires(IL)

                IF(((LN_ATOM1(IL).EQ.'C1  '.AND.
     *               LN_1ICHN(IL).EQ.IG    .AND.
     *               LN_1IRES(IL).EQ.IR         ).OR.
     *              (LN_ATOM2(IL).EQ.'C1  '.AND.
     *               LN_2ICHN(IL).EQ.IG    .AND.
     *               LN_2IRES(IL).EQ.IR         )    ).AND. 
     *             LN_USED(ILN).NE.'S'                   ) THEN
                  ICHANGE = 0
                  IF(LINK(1:5).EQ.'ALPHA') THEN
                    IF(MON(5:5).EQ.'b') THEN
                      MON2      = MON
                      MON2(5:5) = 'a'
                      CALL LOOK_MON_LIB2(MDOC,MON2,LIST,IERR)
                      IF(IERR.EQ.0) THEN
                        MON(5:5)     = 'a'
C                        RES_NAME(IR) = MON
                        ICHANGE      = 1
                      ELSE
                        IERR = 0
                      ENDIF
                    ELSE IF(MON(5:5).NE.'a') THEN

                    ENDIF
                  ELSE IF(LINK(1:4).EQ.'BETA') THEN
                    IF(MON(5:5).EQ.'a') THEN
                      MON2      = MON
                      MON2(5:5) = 'b'
                      CALL LOOK_MON_LIB2(MDOC,MON2,LIST,IERR)
                      IF(IERR.EQ.0) THEN
                        MON(5:5)     = 'b'
C                       RES_NAME(IR) = MON
                        ICHANGE      = 1
                      ELSE
                        IERR = 0
                      ENDIF
                    ELSE IF(MON(5:5).NE.'b') THEN

                    ENDIF
                  ENDIF

                  IF(MOD_N.GT.0.AND.ICHANGE.EQ.1) THEN
                    DO IM=1,MOD_N
                      IGM             = MOD_ICHN(IM)
                      IRM             = MOD_IRES(IM)
                      IF(IG.EQ.IGM.AND.IR.EQ.IRM) THEN
                        IF(SUGAR_FLAG.NE.'D'.AND.
     *                                    MOD_USED(IM).EQ.'U') THEN
        LINE = ' WARNING:  sugar type is different with actual:'//MON
                          CALL MSGDOC(MDOC,LINE)                    
                          WRITE(LINE,'(3A,A5,2A)')
     *'           ch:',GROUP_ID(IG),' res:',RES_NUM_PDB(IR)(3:7),
     *' ',MOD_RNAM(IM)
                          CALL MSGDOC(MDOC,LINE)                    
        LINE =        '           residue name will not be changed' 
                          CALL MSGDOC(MDOC,LINE)                    
                        ELSE
C                         MOD_RNAM_NEW(IM) = RES_NAME(IR)
                          MOD_RNAM(IM) = MON
                        ENDIF
                      ENDIF
                    ENDDO
                  ENDIF

                ENDIF
              ENDDO
            ENDIF
C           --- sugar
          ENDIF

        ENDDO
      ENDDO

      IF(LN_N.GT.0) THEN
        DO I=1,LN_N
          IR1         = LN_1IRES(I)
          IR2         = LN_2IRES(I) 
          LN_1RNAM(I) = RES_NAME(IR1)
          LN_2RNAM(I) = RES_NAME(IR2)
        ENDDO
      ENDIF

c      IF(MOD_N.GT.0) THEN
c        DO I=1,MOD_N
c          IR              = MOD_IRES(I)
cC         MOD_RNAM_NEW(I) = RES_NAME(IR)
c          MOD_RNAM(I) = RES_NAME(IR)
c        ENDDO
c      ENDIF

      CALL SUGAR_NET(MDOC,IERR)    

      CALL CHECK_RESIDUE_NUM(MDOC,IERR)

      IF(CR_SEGFLAG.NE.'Y') THEN
        CALL CHECK_CHAIN_ID_CIF(MDOC,INEW,IERR)
      ELSE
        CALL CHECK_CHAIN_ID_SEG(MDOC,INEW,IERR)
      ENDIF

      IF(INEW.GT.0) THEN
        CALL MSGDOC(MDOC,
     *' WARNING: Chain_list is not correct. Program has changed it.')
        CALL MSGDOC(MDOC,
     *'          Different chains have the same chain id.')
      ENDIF

      RETURN
      END

      SUBROUTINE LOOK_MON_LIB2(MDOC,MON,LIST,IERR)
C -----------------------------------------
C -P- CHKMON - looks for monomer's name in the library list
C              , set use_flag = "Y".
C -S-
C -----------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER MON*8
C ---
      INCLUDE 'lib_com.fh'
C ---
      CHARACTER AMON*8,MON2*8,MOD_R*1,NODIST*1,LIST*1
C     CHARACTER LINE*256
C --------------------------------
      IERR = 0

      IF(LML_NMON.LE.0) THEN
        CALL MSGERR(MDOC,' ERR: number of monomer in the library = 0')
        IERR = 2
        RETURN
      ENDIF

      DO L=1,LML_NMON
        IF(MON.EQ.LML_MNAME(L)) THEN
          GO TO 100
        ENDIF
      ENDDO

      IF(LMS_NSYN.GT.0) THEN
        DO LL=1,LMS_NSYN
          IF(LMS_AMNAME(LL).EQ.MON) THEN
            MON  = LMS_MNAME(LL)
            DO L=1,LML_NMON
              IF(MON.EQ.LML_MNAME(L)) THEN
                GO TO 100
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

      IF(LDR_NDER.GT.0) THEN
        DO LL=1,LDR_NDER
          IF(LDR_MNAME(LL).EQ.MON) THEN
            AMON = LDR_SMNAME(LL)
            DO L=1,LML_NMON
              IF(AMON.EQ.LML_MNAME(L)) THEN
               MON = AMON 
               GO TO 100
              ENDIF
            ENDDO
            MON2 = AMON
            DO LLL=1,LDR_NDER
              IF(LDR_MNAME(LLL).EQ.MON2) THEN
                AMON = LDR_SMNAME(LLL)
                DO L=1,LML_NMON
                  IF(AMON.EQ.LML_MNAME(L)) THEN
                    MON = AMON 
                    GO TO 100
                  ENDIF
                ENDDO
              ENDIF
            ENDDO
          ENDIF
        ENDDO
      ENDIF

C     monomer is not found.
      IERR=1
      RETURN

  100 CONTINUE

C -----
      IF(LML_FUSE(L).EQ.'N') THEN
C       read mon_lib.cif
        LML_FUSE(L) = 'R'
        MOD_R       = 'M'
        NODIST      = 'N'
        CALL READ_LIB(MDOC,MOD_R,NODIST,LIST,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
C ----
      RETURN
      END     

      SUBROUTINE CHECK_RESIDUE_NUM(MDOC,IERR)
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ---
C     CHARACTER LINE*256
C -----------------------------------
      IERR = 0
      IF(N_GROUP.LE.0.OR.N_ATOM.LE.0) THEN
        CALL MSGERR(MDOC,
     *  'ERROR: in "CHECK_RESIDUE_NUM", N_GROUP or N_ATOM = 0')
        IERR=1
        RETURN
      ENDIF
     
      DO IG=1,N_GROUP
        NR    = NRES_CHAIN  (IG)
        IF(NR.GT.1) THEN
          IRS   = IRES_FIRST  (IG)
          IRF   = IRS+NR-1         
          IRES0 = IRES_SERIAL(IRS) 
          DO IR=IRS+1,IRF
            DO JR=IRS,IR-1 
              IF(IRES_SERIAL(IR).EQ.IRES_SERIAL(JR)) THEN
                II = -1
                DO KR=IRS,IRF
                  II = II + 1
                  IRES_SERIAL(KR) = IRES0 + II
                ENDDO
                OUT_CIF_INS = 0
                GO TO 100
              ENDIF
            ENDDO
          ENDDO
        ENDIF
 100    CONTINUE
      ENDDO

      RETURN
      END

      SUBROUTINE SUGAR_NET(MDOC,IERR)    
C -----------------------------------------------
C -P- 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'lib_com.fh'
      INCLUDE 'atom_com.fh'
C ******
C     CHARACTER LINE*256
C -----------------------------------
      IERR = 0
      IF(N_GROUP.LE.0.OR.N_ATOM.LE.0) THEN
        CALL MSGERR(MDOC,
     *  'ERROR: in "SUGAR_NET", N_GROUP or N_ATOM = 0')
        IERR=1
        RETURN
      ENDIF
     
c      DO IG=1,N_GROUP
c        IF(ICH_TYPE(IG).EQ.7) THEN
c          WRITE(*,*) '--S,F:', IRES_START_TREE(IG),IRES_END_TREE(IG)
c          NR  = NRES_CHAIN  (IG)
c          IRS = IRES_FIRST  (IG)
c          IRF = IRS+NR-1         
c          DO IR=IRS,IRF
c       WRITE(*,*) ' --tree>:',IR,IRES_BACK(IR),IRES_forw(IR)
c     *  ,ICONN_TYPE(IR)
c          ENDDO
c        ENDIF
c      ENDDO

      DO IG=1,N_GROUP
        IF(ICH_TYPE(IG).EQ.7) THEN
          NR  = NRES_CHAIN  (IG)
          IRS = IRES_FIRST  (IG)
          IRF = IRS+NR-1         
          IF(NR.EQ.1) THEN
            IRES_START_TREE(IG) = IRS 
            IRES_BACK(IRS)      =-1 
            IRES_FORW(IRS)      = 0 
            IRES_END_TREE(IG)   = IRS 
            GO TO 100
          ENDIF
          NBACK = 0
          DO IR=IRS,IRF
            IF(IRES_BACK(IR).LE.0) THEN
              IRES_START_TREE(IG) = IR 
              NBACK = NBACK + 1
            ENDIF
          ENDDO
          IF(NBACK.EQ.0) THEN
            IRES_START_TREE(IG) = IRS 
            IB                  = IRES_BACK(IRS)     
            IRES_BACK(IRS)      =-1 
            IRES_FORW(IB)       = 0 
          ELSE IF(NBACK.GT.1) THEN
            IRES_START_TREE(IG) = IRS 
            IRES_END_TREE(IG)   = IRF 
            DO IR=IRS,IRF
              IRES_BACK(IR)     = IR-1 
              IRES_FORW(IR)     = IR+1 
            ENDDO
            IRES_BACK(IRS)      =-1 
            IRES_FORW(IRF)      = 0 
            GO TO 100
          ENDIF
          NFORW = 0
          DO IR=IRS,IRF
            IF(IRES_FORW(IR).LE.0) NFORW = NFORW + 1
          ENDDO
          IRST = IRES_START_TREE(IG)  
          IF(NFORW.LE.0.OR.IRES_FORW(IRST).LE.0) THEN
            IRES_START_TREE(IG) = IRS 
            IRES_END_TREE(IG)   = IRF 
            DO IR=IRS,IRF
              IRES_BACK(IR)     = IR-1 
              IRES_FORW(IR)     = IR+1 
            ENDDO
            IRES_BACK(IRS)      =-1 
            IRES_FORW(IRF)      = 0 
            GO TO 100
          ENDIF
C ----
C         search first forw = 0          
          I =  IRES_START_TREE(IG)
 200      CONTINUE
          IFR = IRES_FORW(I)         
          IF(IFR.LE.0) THEN
            IEND = I
          ELSE
            I = IFR
            GO TO 200
          ENDIF            
C ----
          IRES_END_TREE(IG)   = IEND 

          IF(NFORW.GT.1) THEN
C         other branchs
            DO IR=IRS,IRF
              IF(IRES_FORW(IR).LE.0.AND.IR.NE.IEND) THEN         
                J    = IR
                JEND = J
 300            CONTINUE

                IB  = IRES_BACK(J)         
                IFR = IRES_FORW(IB)         
                IF(J.NE.IFR) THEN
                  IRES_FORW(IEND) = J                  
                  IEND = JEND 
                ELSE
                  J = IB
                  GO TO 300
                ENDIF
 
              ENDIF
            ENDDO

            IRES_END_TREE(IG)   = JEND 

          ENDIF          

 100      CONTINUE

          DO IR=IRS,IRF
            ICONN_TYPE(IR) = 1
            IRB = IRES_BACK(IR)
            IF(LN_N.GT.0.AND.IRB.GT.0) THEN
              DO ICN=1,LN_N
              IF(LN_USED(ICN).NE.'S') THEN
              IF((LN_1IRES(ICN).EQ.IRB.AND.LN_2IRES(ICN).EQ.IR).OR.
     *           (LN_2IRES(ICN).EQ.IRB.AND.LN_1IRES(ICN).EQ.IR)  ) THEN
                CALL SET_ICONN(LN_ID(ICN),ICONN)
                ICONN_TYPE(IR) = ICONN
                GO TO 400
              ENDIF
              ENDIF
              ENDDO
            ENDIF
 400        CONTINUE
          ENDDO

        ENDIF
      ENDDO

c      DO IG=1,N_GROUP
c        IF(ICH_TYPE(IG).EQ.7) THEN
c          WRITE(*,*) 'S,F:', IRES_START_TREE(IG),IRES_END_TREE(IG)
c          NR  = NRES_CHAIN  (IG)
c          IRS = IRES_FIRST  (IG)
c          IRF = IRS+NR-1         
c          DO IR=IRS,IRF
c          WRITE(*,*) ' tree>:',IR,IRES_BACK(IR),IRES_forw(IR)
c     *    ,ICONN_TYPE(IR)
c          ENDDO
c        ENDIF
c      ENDDO

      RETURN
      END

C ******
