C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C --- make_subr.f ---
C =====================================================================
C
C        ----   Library of subroutines ---
C
C ******
C ================================================

      SUBROUTINE SET_PATH_PROG_PARM(LIB_PATH,PROG_NAME
     *                         ,LIBS_PATH,LIBS_NAME,LIBS_EXT)
C -------------------------------------------------------
      CHARACTER LIB_PATH*(*),PROG_NAME*(*)
      CHARACTER LIBS_PATH*(*),LIBS_NAME*(*),LIBS_EXT*(*)
      INCLUDE 'crd_com.fh'
C -------------------------------------------------------
C      CALL LENSTR_BL(LIBS_PATH,LEN)
C      IF(LEN.LE.0.OR.LIBS_PATH.EQ.','.OR.LIBS_PATH.EQ.' ') THEN
C        LIBS_PATH    = LIB_PATH     
C      ENDIF
C      CALL LENSTR_BL(LIBS_NAME,LEN)
C      IF(LEN.LE.0.OR.LIBS_NAME.EQ.','.OR.LIBS_NAME.EQ.' ') THEN
C        LIBS_NAME    = 'symlib'
C      ENDIF
C      CALL LENSTR_BL(LIBS_EXT,LEN)
C      IF(LEN.LE.0.OR.LIBS_EXT.EQ.','.OR.LIBS_EXT.EQ.' ') THEN
C        LIBS_EXT     = 'blc'
C      ENDIF
C --
      CRG_FILE     = LIBS_NAME
      CRG_PATH     = LIBS_PATH
      CRG_EXT      = LIBS_EXT
      CR_PROG_NAME = PROG_NAME
      CR_LIB_PATH  = LIB_PATH
      CR_PROG_PATH = LIB_PATH
      CALL LENSTR_BL(LIB_PATH,L)
      IF(L.GE.6) THEN
C       CR_PROG_PATH = LIB_PATH(1:L-5)//'/bin/'
        CR_PROG_PATH = ' '
      ENDIF
C -----------------------------------
      RETURN
      END     

      SUBROUTINE SET_UNIT_NUMBERS
C -----------------------------------
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ----
      INCLUDE 'crd_com.fh'
C ----------------------------------
C------
C ---  doc-file ---
      DOC_FILE   = 0
C -----
      BATCH_FILE = 0
      BAT_MODE   = 0

      CRDOC_IUN = 48
      CRBAT_IUN = 47
      CRSM_IUN  = 45
      CRPS_IUN  = 51
      CR_SC_IUN = 52

      CRI_IUN   = 31
      CRO_IUN   = 32
      CRSO_IUN  = 33
      CRRO_IUN  = 34
      CRVO_IUN  = 35

      CRI_IUN   = 36
      CRS_IUN   = 37
      CRR_IUN   = 38
      CRV_IUN   = 39

      CRI2_IUN  = 40
      CRI3_IUN  = 41
      CRO2_IUN  = 42
      CRO3_IUN  = 43

      RETURN
      END

C ====================================================

C -I-
      SUBROUTINE NB_FTOO(X,Y,IERR)
C
C -P- NB_FTOO - transform fractional coords X(3) to orthoganal Y(3).
C --------------------------------------------------
C -I-
      INCLUDE 'atom_com.fh'
C ---------------------------------------------------
      REAL X(3),Y(3)
C---------------------------------------------------------------------
      IERR=0
      CALL NB_MVMULT(CS_FRAC_TO_ORT,X,Y)
      RETURN
      END

C -I-
      SUBROUTINE NB_OTOF(X,Y,IERR)
C
C -P- NB_OTOF - transform orthogonal coords X(3) to fractional Y(3).
C --------------------------------------------------
C -I-
      INCLUDE 'atom_com.fh'
C ---------------------------------------------------
      REAL X(3),Y(3)
C---------------------------------------------------------------------
      IERR=0
      CALL NB_MVMULT(CS_ORT_TO_FRAC,X,Y)
      RETURN
      END

      SUBROUTINE CHECK_SPEC_POS(X,DMIN2,ISPEC)
C -----------------------------------
      INCLUDE 'atom_com.fh'
C -----------------------------------
      INTEGER   ISPEC
      REAL      X(3),DMIN2
C ---
      COMMON/COM_ATM_OLD/ NA_OLD,XOLD,ISYM_OLD
      REAL      XOLD(3,96)
      INTEGER   NA_OLD,ISYM_OLD(96)
C ---
      REAL      ZZ(3)
C --------------------------------------------------------------------
      ISPEC       = 1
      NA_OLD      = 1
      XOLD(1,1)   = X(1)
      XOLD(2,1)   = X(2)
      XOLD(3,1)   = X(3)
      ISYM_OLD(1) = 1

      IF(CS_NSYM.LE.1) RETURN

      DO     I=2,CS_NSYM
        ZZ(1) = CS_M_CS(1,1,I)*X(1) + CS_M_CS(1,2,I)*X(2) + 
     *          CS_M_CS(1,3,I)*X(3) + CS_V_CS(1,I)
        ZZ(2) = CS_M_CS(2,1,I)*X(1) + CS_M_CS(2,2,I)*X(2) +
     *          CS_M_CS(2,3,I)*X(3) + CS_V_CS(2,I)
        ZZ(3) = CS_M_CS(3,1,I)*X(1) + CS_M_CS(3,2,I)*X(2) +
     *          CS_M_CS(3,3,I)*X(3) + CS_V_CS(3,I)
        DO J=1,NA_OLD
          CALL  CALC_DIST(ZZ,XOLD,D2,ITX,ITY,ITZ)
          IF(D2.LT.DMIN2) GO TO 100
        ENDDO
        NA_OLD           = NA_OLD+1
        XOLD(1,NA_OLD)   = ZZ(1)
        XOLD(2,NA_OLD)   = ZZ(2)
        XOLD(3,NA_OLD)   = ZZ(3)
        ISYM_OLD(NA_OLD) = I

 100    CONTINUE
      ENDDO

      ISPEC = CS_NSYM/NA_OLD

      RETURN
      END

      SUBROUTINE CALC_DIST(ZZ,XX,D2,ITX,ITY,ITZ)
C --------------------------------------------------------------
      REAL      XX(3),ZZ(3),WW(3),W(3)
C --------------------------------------------------------------
        WW(1) = ZZ(1)-XX(1)
        WW(2) = ZZ(2)-XX(2)
        WW(3) = ZZ(3)-XX(3)

        ITZ = 0
31      IF(WW(3).LT.0.0) THEN
          WW(3) = WW(3)+1.0
          ITZ   = ITZ+1
          GO TO 31
        ENDIF

32      IF(WW(3).GE.0.5) THEN
          WW(3) = WW(3)-1.0                                             
          ITZ   = ITZ-1
          GO TO 32
        ENDIF

        ITX = 0
11      IF(WW(1).LT.0.0) THEN
          WW(1) = WW(1)+1.0
          ITX   = ITX+1
          GO TO 11
        ENDIF
12      IF(WW(1).GE.0.5) THEN
          WW(1) = WW(1)-1.0
          ITX   = ITX-1
          GO TO 12
        ENDIF

        ITY = 0
21      IF(WW(2).LT.0.0) THEN
          WW(2) = WW(2)+1.0
          ITY   = ITY+1
          GO TO 21
        ENDIF
22      IF(WW(2).GE.0.5) THEN
          WW(2) = WW(2)-1.0
          ITY   = ITY-1
          GO TO 22
        ENDIF

        CALL NB_FTOO(WW,W,IERR)

        D2 = W(1)*W(1)+W(2)*W(2)+W(3)*W(3)

      RETURN
      END

C -I-
      SUBROUTINE NB_ASCELL(ITYPE,XI,YI,ZI,ZMAX,XO,YO,ZO,
     .                   JSYM,TRANS,IERR)
C -------------------------------------------------------------------
C -P- NB_ASCELL - transforms:  XI,YI,ZI  /in frac. units/
C -P-          to asymmetric part of cell -->  XO,YO,ZO,
C
C      ITYPE = 0   0 =< XO  < 1     0 =< YO  < 1     0 =< ZO =< ZMAX
C            = 1   0 =< XO  < 1     0 =< YO =< 1/2   0 =< ZO =< ZMAX
C            = 2   0 =< XO =< 1/2   0 =< YO =< 1/2   0 =< ZO =< ZMAX
C
C      JSYM     - number of operator of symmetry
C      TRANS(3) - translations
C
C            XO = [Rjsym]*XI + TRANS(1)
C            YO = [Rjsym]*YI + TRANS(2)
C            ZO = [Rjsym]*ZI + TRANS(3)
C      
C      IERR = 0   OK
C           = 1   NO SUCH POINT
C --------------------------------------------------------------
C -I-
      INCLUDE 'atom_com.fh'
C --------------------------------------------
      REAL      TRANS(3)
C ---------------------------------------
      IERR=0
      DO     I=1,CS_NSYM
        JSYM = I
        XO = CS_M_CS(1,1,I)*XI + CS_M_CS(1,2,I)*YI + 
     *       CS_M_CS(1,3,I)*ZI + CS_V_CS(1,I)
        YO = CS_M_CS(2,1,I)*XI + CS_M_CS(2,2,I)*YI +
     *       CS_M_CS(2,3,I)*ZI + CS_V_CS(2,I)
        ZO = CS_M_CS(3,1,I)*XI + CS_M_CS(3,2,I)*YI +
     *       CS_M_CS(3,3,I)*ZI +CS_V_CS(3,I)
        TRANS(3) = 0.0
31      IF(ZO.LT.0.0) THEN
          ZO       = ZO+1.0
          TRANS(3) = TRANS(3)+1.0
          GO TO 31
        ENDIF
32      IF(ZO.GE.1.0) THEN
          ZO       = ZO-1.0                                             
          TRANS(3) = TRANS(3)-1.0
          GO TO 32
        ENDIF

        IF(ZO.GT.ZMAX) GO TO 200

        TRANS(1) = 0.0
11      IF(XO.LT.0.0) THEN
          XO       = XO+1.0
          TRANS(1) = TRANS(1)+1.0
          GO TO 11
        ENDIF
12      IF(XO.GE.1.0) THEN
          XO       = XO-1.0
          TRANS(1) = TRANS(1)-1.0
          GO TO 12
        ENDIF

        TRANS(2) = 0.0
21      IF(YO.LT.0.0) THEN
          YO       = YO+1.0
          TRANS(2) = TRANS(2)+1.0
          GO TO 21
        ENDIF
22      IF(YO.GE.1.0) THEN
          YO       = YO-1.0
          TRANS(2) = TRANS(2)-1.0
          GO TO 22
        ENDIF

        IF(ITYPE.EQ.0)         GO TO 100

        IF(YO.LE.0.5)   THEN
          IF(ITYPE.EQ.1)       GO TO 100
          IF(XO.LE.0.5) THEN
            IF(ITYPE.EQ.2)     GO TO 100
          ENDIF
        ENDIF

  200   CONTINUE
      ENDDO
C -------------------
      IERR=1
  100 CONTINUE
      RETURN
      END

      SUBROUTINE GET_STANDARD_RES_TYPE(MDOC,LINE,MONN,ITYPE,IERR)
C ------------------------------------------------------
      INTEGER   MDOC,ITYPE,IERR
      CHARACTER LINE*(*),MON*3,MONN*8
C -------------
      PARAMETER ( NRNAME = 63 )
      CHARACTER RNAME(63)*3
      PARAMETER ( NRNAMEP = 17 )
      CHARACTER RNAMEP(17)*3
      PARAMETER ( NRNAMED = 37 )
      CHARACTER RNAMED(37)*3
      PARAMETER ( NRNAMES = 14 )
      CHARACTER RNAMES(14)*3
C ---------------------------------------------------------
C     ITYPE = 3 RES_LTYPE( 3) =  'peptide '
C
      DATA RNAME /'CYS','SER','THR','PRO','ALA','GLY','ASN','ASP' 
     *           ,'GLU','GLN','HIS','ARG','LYS','MET','ILE','LEU' 
     *           ,'VAL','PHE','TYR','TRP','TRY','HYP','PCA','SAR' 
     *           ,'ORN','CSS','CSH','DAR','DPR','NLE','DAS','INI'
     *           ,'DGL','DGN','DHI','DIL','DIV','DLI','DSN','DSP'
     *           ,'ABA','BMT','MLE','MVA','DVA','MSE','PTR','DAL' 
     *           ,'DPN','DTR','DTH','TYS','CGU','DCY','ILG','OCS'
     *           ,'KCX','SAH','SAM','SEP','LLP','5HP','CSO'      /
C
C -------------
C     ITYPE = 10 RES_LTYPE(10) = 'polymer '
C
      DATA RNAMEP/'STA','DFO','FOR','BOC','IVA','NME','ACE','DAM'
     *           ,'ETA','ANI','ADD','ACB','TFA','DIP','MPR','CXM' 
     *           ,'BAL'                                          /
C
C -------------
C     ITYPE = 5 RES_LTYPE( 5) =  'DNA/RNA '
C
      DATA RNAMED/'A  ','C  ','G  ','T  ','U  ','I  ','+A ','+C ' 
     *           ,'+G ','+T ','+U ','1MA','1MG','2MG','5MC','5MU'
     *           ,'7MG','H2U','M2G','OMC','OMG','OMU','PSU','YG '
     *           ,'Ad ','Ar ','Cd ','Cr ','Gd ','Gr ','Td ','Ur '
     *           ,'Ir ','DA','DC','DG','DT'/
C
C -------------
C     ITYPE = 7 RES_LTYPE( 7) =  'pyranose' 
C
      DATA RNAMES/'MAN','NAG','FUC','GAL','GLC','GCU','GSA','XYS' 
     *           ,'ARB','RIP','ABE','RAM','MAG','MMA'            /
C==================================================================
      IERR  = 0
      ITYPE = 1

      MON = MONN(1:3)

      DO I=1,NRNAME
        IF(MON.EQ.RNAME(I)) THEN
          ITYPE = 3
          GO TO 100
        ENDIF
      ENDDO
      DO I=1,NRNAMEP
        IF(MON.EQ.RNAMEP(I)) THEN
          ITYPE = 10
          GO TO 100
        ENDIF
      ENDDO
      DO I=1,NRNAMED
        IF(MON.EQ.RNAMED(I)) THEN
          ITYPE = 5
          GO TO 100
        ENDIF
      ENDDO
      DO I=1,NRNAMES
        IF(MON.EQ.RNAMES(I)) THEN
          ITYPE = 7
          GO TO 100
        ENDIF
      ENDDO

      IF(MON.EQ.'HOH'.OR.MON.EQ.'DUM') THEN
        ITYPE = 9
        GO TO 100
      ENDIF

 100  CONTINUE
      RETURN
      END

      SUBROUTINE GET_INI_RES_TYPE(MDOC,LINE,MONN,ITYPE,IERR)
C ------------------------------------------------------
      INTEGER   MDOC,ITYPE,IERR
      CHARACTER LINE*(*),MON*8,MONN*8
C ------------------------------------------------------
      include 'standard_residue.fh'
C==================================================================
      IERR  = 0
      ITYPE = 1

      MON = MONN

      IF(NRNAME_T.GT.0) THEN
         DO I=1,NRNAME_T
            IF(MON.EQ.RNAME_T(I)) THEN
               ITYPE = 3
               GO TO 100
            ENDIF
         ENDDO
      ENDIF
      IF(NRNAMEP_T.GT.0) THEN
         DO I=1,NRNAMEP_T
            IF(MON.EQ.RNAMEP_T(I)) THEN
               ITYPE = 10
               GO TO 100
            ENDIF
         ENDDO
      ENDIF
      IF(NRNAMED_T.GT.0) THEN
         DO I=1,NRNAMED_T
            IF(MON.EQ.RNAMED_T(I)) THEN
               ITYPE = 5
               GO TO 100
            ENDIF
         ENDDO
      ENDIF
      IF(NRNAMES_T.GT.0) THEN
      DO I=1,NRNAMES_T
        IF(MON.EQ.RNAMES_T(I)) THEN
          ITYPE = 7
          GO TO 100
        ENDIF
      ENDDO
      ENDIF
      IF(MON.EQ.'HOH'.OR.MON.EQ.'DUM') THEN
        ITYPE = 9
        GO TO 100
      ENDIF

 100  CONTINUE
      RETURN
      END

      SUBROUTINE WRITE_LIB_RES_TYPE_TAB(MDOC,IERR)
C ------------------------------------------------------
      INTEGER   MDOC,IERR
      CHARACTER LINE*80
C ------------------------------------------------------
      include 'standard_residue.fh'
C==================================================================
      IERR  = 0
C ------
      IF(NRNAME_T.GT.0) THEN
        LINE = '--- L/D - peptides ---'
        CALL MSGDOC(MDOC,LINE)
        DO I=1,NRNAME_T
          WRITE(LINE,'(I4,'') '',A)') I,RNAME_T(I)  
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
      IF(NRNAMEP_T.GT.0) THEN
        LINE = '--- polymer ---'
        CALL MSGDOC(MDOC,LINE)
        DO I=1,NRNAMEP_T
          WRITE(LINE,'(I4,'') '',A)') I,RNAMEP_T(I)  
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
      IF(NRNAMED_T.GT.0) THEN
        LINE = '--- DNA/RNA ---'
        CALL MSGDOC(MDOC,LINE)
        DO I=1,NRNAMED_T
          WRITE(LINE,'(I4,'') '',A)') I,RNAMED_T(I)  
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
      IF(NRNAMES_T.GT.0) THEN
        LINE = '--- L/D pyranose ---'
        CALL MSGDOC(MDOC,LINE)
        DO I=1,NRNAMES_T
          WRITE(LINE,'(I4,'') '',A)') I,RNAMES_T(I)  
          CALL MSGDOC(MDOC,LINE)
        ENDDO
      ENDIF
      RETURN
      END


      SUBROUTINE INIT_RES_TYPE_TAB
C ------------------------------------------------------
      INTEGER    NRNAME_PAR,NRNAMEP_PAR,NRNAMED_PAR,NRNAMES_PAR

      PARAMETER ( NRNAME_PAR  = 400 )
      PARAMETER ( NRNAMEP_PAR = 200 )
      PARAMETER ( NRNAMED_PAR = 200 )
      PARAMETER ( NRNAMES_PAR = 200 )

      COMMON/COM_RES_TYPE/  NRNAME_T,NRNAMEP_T,NRNAMED_T,NRNAMES_T
     *                     ,RNAME_T,RNAMEP_T,RNAMED_T,RNAMES_T
      INTEGER   NRNAME_T,NRNAMEP_T,NRNAMED_T,NRNAMES_T
      CHARACTER RNAME_T (NRNAME_PAR )*8
      CHARACTER RNAMEP_T(NRNAMEP_PAR)*8
      CHARACTER RNAMED_T(NRNAMED_PAR)*8
      CHARACTER RNAMES_T(NRNAMES_PAR)*8
C -------------
      PARAMETER ( NRNAME = 63 )
      CHARACTER RNAME(63)*3
      PARAMETER ( NRNAMEP = 17 )
      CHARACTER RNAMEP(17)*3
      PARAMETER ( NRNAMED = 33 )
      CHARACTER RNAMED(33)*3
      PARAMETER ( NRNAMES = 14 )
      CHARACTER RNAMES(14)*3
C ---------------------------------------------------------
C     ITYPE = 3 RES_LTYPE( 3) =  'peptide '
C
      DATA RNAME /'CYS','SER','THR','PRO','ALA','GLY','ASN','ASP' 
     *           ,'GLU','GLN','HIS','ARG','LYS','MET','ILE','LEU' 
     *           ,'VAL','PHE','TYR','TRP','TRY','HYP','PCA','SAR' 
     *           ,'ORN','CSS','CSH','DAR','DPR','NLE','DAS','INI'
     *           ,'DGL','DGN','DHI','DIL','DIV','DLI','DSN','DSP'
     *           ,'ABA','BMT','MLE','MVA','DVA','MSE','PTR','DAL' 
     *           ,'DPN','DTR','DTH','TYS','CGU','DCY','ILG','OCS'
     *           ,'KCX','SAH','SAM','SEP','LLP','5HP','CSO'      /
C
C -------------
C     ITYPE = 10 RES_LTYPE(10) = 'polymer '
C
      DATA RNAMEP/'STA','DFO','FOR','BOC','IVA','NME','ACE','DAM'
     *           ,'ETA','ANI','ADD','ACB','TFA','DIP','MPR','CXM' 
     *           ,'BAL'                                          /
C
C -------------
C     ITYPE = 5 RES_LTYPE( 5) =  'DNA/RNA '
C
      DATA RNAMED/'A  ','C  ','G  ','T  ','U  ','I  ','+A ','+C ' 
     *           ,'+G ','+T ','+U ','1MA','1MG','2MG','5MC','5MU'
     *           ,'7MG','H2U','M2G','OMC','OMG','OMU','PSU','YG '
     *           ,'Ad ','Ar ','Cd ','Cr ','Gd ','Gr ','Td ','Ur '
     *           ,'Ir '/
C
C -------------
C     ITYPE = 7 RES_LTYPE( 7) =  'pyranose' 
C
      DATA RNAMES/'MAN','NAG','FUC','GAL','GLC','GCU','GSA','XYS' 
     *           ,'ARB','RIP','ABE','RAM','MAG','MMA'            /
C==================================================================
      NRNAME_T = NRNAME 
      DO I=1,NRNAME
        RNAME_T(I) = RNAME(I)
      ENDDO
      NRNAMEP_T = NRNAMEP 
      DO I=1,NRNAMEP
        RNAMEP_T(I) = RNAMEP(I)
      ENDDO
      NRNAMED_T = NRNAMED 
      DO I=1,NRNAMED
        RNAMED_T(I) = RNAMED(I)
      ENDDO
      NRNAMES_T = NRNAMES 
      DO I=1,NRNAMES
        RNAMES_T(I) = RNAMES(I)
      ENDDO
C ----
      RETURN
      END

      SUBROUTINE CORR_NAME(ANAME,RNAME,ASYMB,CTYPE)
      CHARACTER ANAME*4,RNAME*8,ASYMB*4,CTYPE*4
      CHARACTER LINE*80,TYPE*1,CH1*1,CH2*2,CH4*4
C ---
      INCLUDE 'metal.fh'
C ---
C      PARAMETER (N_NAME = 32)
C      CHARACTER NAME(N_NAME)*2
C      DATA NAME/'CO','MG','CA','ZN','CU','FE','CL','BR','MN','PB',
C     *          'HG','AL','GD','NA','CD','NI','SR','IN','HO','YB',
C     *          'TE','LI','RB','BA','CS','SM','TL','PT','BE','SE',
C     *          'MO','SI'/
C ??? more
C ---
C ---------------------------------------------
      IF(ANAME(1:1).NE.' ') THEN
        CH1 = ANAME(1:1)
        CALL CHKSMB(CH1,TYPE)
        IF(TYPE.EQ.'D'.OR.CH1.EQ.''''.OR.CH1.EQ.'*') THEN
          CALL LENSTR_BL(ANAME,LN)
          IF(LN.LE.1) THEN
            LN = 2
            ANAME(2:2) = 'H'
          ENDIF
          ASYMB     = ANAME(2:2)//'   '
          CH4       = '    '
          CH4(1:LN) = ANAME(2:LN)//CH1
          ANAME     = CH4
C         CTYPE='H   '
          IF(ASYMB(1:1).EQ.'H') CTYPE = 'H   '
C        ELSE IF(ANAME(4:4).EQ.' ') THEN
        ELSE 
          CH2=ANAME(1:2)
          DO  I=1,N_NAME
            IF(NAME(I).EQ.CH2) THEN
              ASYMB  = ANAME(1:2)//'  '
              CTYPE  = '$   '
              GO TO 100
            ENDIF
          ENDDO
          ASYMB = ANAME(2:2)//'   '
          CTYPE = 'C   '
          IF(ASYMB(1:1).EQ.'H') CTYPE = 'H   '
  100     CONTINUE
c        ELSE
c          ASYMB=ANAME(2:2)//'   '
c          CTYPE='C   '
c          IF(ASYMB(1:1).EQ.'H') CTYPE = 'H   '
        ENDIF  
      ELSE
        ASYMB=ANAME(2:2)//'   '
        IF(ASYMB(1:1).EQ.'M') ASYMB = 'C   '
        IF(ASYMB(1:1).EQ.'C'.OR.ASYMB(1:1).EQ.'N'.OR.
     *     ASYMB(1:1).EQ.'O'.OR.ASYMB(1:1).EQ.'B'.OR.
     *     ASYMB(1:1).EQ.'F'                         ) THEN
          CTYPE = 'C   '
        ELSE
          CTYPE = '$   '
        ENDIF
        IF(ASYMB(1:1).EQ.'H') CTYPE = 'H   '
      ENDIF
      
      IF(ANAME(1:1).EQ.' ') THEN
        ANAME = ANAME(2:4)//' '
      ENDIF
      IF(ANAME(2:2).EQ.' ') THEN
        ANAME(2:4) = ANAME(3:4)//' '
        IF(ANAME(2:2).EQ.' ') ANAME(2:4) = ANAME(3:4)//' '
      ENDIF
C ---
      IF(RNAME(1:1).EQ.' ') THEN
        RNAME = RNAME(2:3)//' '
        IF(RNAME(1:1).EQ.' ') RNAME = RNAME(2:3)//' '
      ENDIF

      IF(RNAME.EQ.'WAT') RNAME = 'HOH'
      IF(RNAME.EQ.'DOD') RNAME = 'HOH'
      IF(RNAME.EQ.'H2O') RNAME = 'HOH'
      if(rname.eq.'TIP') rname = 'HOH'

c      IF(RNAME.EQ.'CYT') THEN
c        RNAME = 'C'
c      ENDIF
c      IF(RNAME.EQ.'ADE') THEN
c        RNAME = 'A'
c      ENDIF
c      IF(RNAME.EQ.'THY') THEN
c        RNAME = 'T'
c      ENDIF
c      IF(RNAME.EQ.'GUA') THEN
c        RNAME = 'G'
c      ENDIF
c      IF(RNAME.EQ.'URI') THEN
c        RNAME = 'U'
c      ENDIF

c      IF(RNAME.EQ.'C'.OR.RNAME.EQ.'+C') THEN
c        IF(ANAME(1:1).EQ.'''') ANAME(1:1)='*'
c        IF(ANAME(2:2).EQ.'''') ANAME(2:2)='*'
c        IF(ANAME(3:3).EQ.'''') ANAME(3:3)='*'
c        IF(ANAME(4:4).EQ.'''') ANAME(4:4)='*'
c      ENDIF
c      IF(RNAME.EQ.'A'.OR.RNAME.EQ.'+A') THEN
c        IF(ANAME(1:1).EQ.'''') ANAME(1:1)='*'
c        IF(ANAME(2:2).EQ.'''') ANAME(2:2)='*'
c        IF(ANAME(3:3).EQ.'''') ANAME(3:3)='*'
c        IF(ANAME(4:4).EQ.'''') ANAME(4:4)='*'
c      ENDIF
c      IF(RNAME.EQ.'T'.OR.RNAME.EQ.'+T') THEN
c        IF(ANAME(1:1).EQ.'''') ANAME(1:1)='*'
c        IF(ANAME(2:2).EQ.'''') ANAME(2:2)='*'
c        IF(ANAME(3:3).EQ.'''') ANAME(3:3)='*'
c        IF(ANAME(4:4).EQ.'''') ANAME(4:4)='*'
c      ENDIF
c      IF(RNAME.EQ.'G'.OR.RNAME.EQ.'+G') THEN
c        IF(ANAME(1:1).EQ.'''') ANAME(1:1)='*'
c        IF(ANAME(2:2).EQ.'''') ANAME(2:2)='*'
c        IF(ANAME(3:3).EQ.'''') ANAME(3:3)='*'
c        IF(ANAME(4:4).EQ.'''') ANAME(4:4)='*'
c      ENDIF
c      IF(RNAME.EQ.'U'.OR.RNAME.EQ.'+U') THEN
c        IF(ANAME(1:1).EQ.'''') ANAME(1:1)='*'
c        IF(ANAME(2:2).EQ.'''') ANAME(2:2)='*'
c        IF(ANAME(3:3).EQ.'''') ANAME(3:3)='*'
c        IF(ANAME(4:4).EQ.'''') ANAME(4:4)='*'
c      ENDIF

c      IF(RNAME.EQ.'YG') THEN
c        IF(ANAME(1:1).EQ.'''') ANAME(1:1)='*'
c        IF(ANAME(2:2).EQ.'''') ANAME(2:2)='*'
c        IF(ANAME(3:3).EQ.'''') ANAME(3:3)='*'
c        IF(ANAME(4:4).EQ.'''') ANAME(4:4)='*'
c      ENDIF
c      IF(RNAME.EQ.'PSU') THEN
c        IF(ANAME(1:1).EQ.'''') ANAME(1:1)='*'
c        IF(ANAME(2:2).EQ.'''') ANAME(2:2)='*'
c        IF(ANAME(3:3).EQ.'''') ANAME(3:3)='*'
c        IF(ANAME(4:4).EQ.'''') ANAME(4:4)='*'
c      ENDIF
c      IF(RNAME.EQ.'1MA') THEN
c        IF(ANAME(1:1).EQ.'''') ANAME(1:1)='*'
c        IF(ANAME(2:2).EQ.'''') ANAME(2:2)='*'
c        IF(ANAME(3:3).EQ.'''') ANAME(3:3)='*'
c        IF(ANAME(4:4).EQ.'''') ANAME(4:4)='*'
c      ENDIF
c      IF(RNAME.EQ.'1MG') THEN
c        IF(ANAME(1:1).EQ.'''') ANAME(1:1)='*'
c        IF(ANAME(2:2).EQ.'''') ANAME(2:2)='*'
c        IF(ANAME(3:3).EQ.'''') ANAME(3:3)='*'
c        IF(ANAME(4:4).EQ.'''') ANAME(4:4)='*'
c      ENDIF
c      IF(RNAME.EQ.'I'.OR.RNAME.EQ.'Ir') THEN
c        IF(ANAME(1:1).EQ.'''') ANAME(1:1)='*'
c        IF(ANAME(2:2).EQ.'''') ANAME(2:2)='*'
c        IF(ANAME(3:3).EQ.'''') ANAME(3:3)='*'
c        IF(ANAME(4:4).EQ.'''') ANAME(4:4)='*'
c      ENDIF

c      IF(RNAME(1:1).EQ.'''') RNAME(1:1)=','
c      IF(RNAME(2:2).EQ.'''') RNAME(2:2)=','
c      IF(RNAME(3:3).EQ.'''') RNAME(3:3)=','

C      IF(ANAME(1:1).EQ.'''') ANAME(1:1)=','
C      IF(ANAME(2:2).EQ.'''') ANAME(2:2)=','
C      IF(ANAME(3:3).EQ.'''') ANAME(3:3)=','
C      IF(ANAME(4:4).EQ.'''') ANAME(4:4)=','
      CALL LENSTR_BL(ANAME,LN)
c      IF(ANAME(2:2).EQ.' '.AND.LN.GE.2) ANAME(2:2)='_'
c      IF(ANAME(3:3).EQ.' '.AND.LN.GE.3) ANAME(3:3)='_'


      IF(ANAME(1:4).EQ.'OT  ') ANAME(1:4) = 'OXT '

      if(asymb.eq.'X  ') then
         asymb = 'O  '
         ctype = 'C   '
      endif
      IF(ASYMB.EQ.'D  ') THEN
        ASYMB    = 'H   '
        CTYPE='H   '
      ENDIF
      IF(ANAME.EQ.'HE21') THEN
        ASYMB    = 'H   '
        CTYPE='H   '
      ENDIF
      IF(ANAME.EQ.'HE22') THEN
        ASYMB    = 'H   '
        CTYPE='H   '
      ENDIF
      IF(ANAME.EQ.'HD21') THEN
        ASYMB    = 'H   '
        CTYPE='H   '
      ENDIF
      IF(ANAME.EQ.'HD22') THEN
        ASYMB    = 'H   '
        CTYPE='H   '
      ENDIF
      IF(ANAME.EQ.'HH11') THEN
        ASYMB    = 'H   '
        CTYPE='H   '
      ENDIF
      IF(ANAME.EQ.'HH12') THEN
        ASYMB    = 'H   '
        CTYPE='H   '
      ENDIF
      IF(ANAME.EQ.'HH21') THEN
        ASYMB    = 'H   '
        CTYPE='H   '
      ENDIF
      IF(ANAME.EQ.'HH22') THEN
        ASYMB    = 'H   '
        CTYPE='H   '
      ENDIF

      IF(RNAME.EQ.'DUM') THEN
        ANAME = 'DUM '
        ASYMB = 'O   '
        CTYPE = 'C   '
      ENDIF
      IF(RNAME.EQ.'HOH') THEN
        IF(ASYMB(1:1).EQ.'O') THEN
          ANAME = 'O   '
          ASYMB = 'O   '
          CTYPE = 'C   '
        ELSE IF(ASYMB(1:1).EQ.'H'.OR.ASYMB(1:1).EQ.'D') THEN
          ASYMB = 'H   '
          CTYPE = 'H   '
          IF(ANAME(1:2).EQ.'D1') ANAME = 'H1  '
          IF(ANAME(1:2).EQ.'D2') ANAME = 'H2  '
        ELSE
          ANAME = 'O   '
          ASYMB = 'O   '
          CTYPE = 'C   '
        ENDIF
      ENDIF

C ---  special cases ---
c      IF(RNAME.EQ.'IUM'.AND.CTYPE.EQ.'$   ') THEN
c        RNAME = ANAME(1:2)
c      ENDIF

C      CALL SET_INI_RES_TYPE(MDOC,LINE,RNAME,ITYPE,IERR)
      CALL GET_STANDARD_RES_TYPE(MDOC,LINE,RNAME,ITYPE,IERR)
      IF(ITYPE.EQ.1) THEN
        CALL GET_INI_RES_TYPE(MDOC,LINE,RNAME,ITYPE,IERR)
      ENDIF
c         ITYPE = 3  peptide
c         ITYPE = 10 polymer
c         ITYPE = 5  dna/rna
c         ITYPE = 7  sugar
c         ITYPE = 9  HOH
      IF(ITYPE.EQ.5) THEN
        IF(ANAME.EQ.'P5  ') THEN
          ANAME    = 'P   '
          CTYPE='C   '
        ENDIF
        IF(ANAME.EQ.'O51 ') THEN
          ANAME    = 'OP1 '
          CTYPE='C   '
        ENDIF
        IF(ANAME.EQ.'O52 ') THEN
          ANAME    = 'OP2 '
          CTYPE='C   '
        ENDIF
      ELSE IF(ITYPE.EQ.3.OR.ITYPE.EQ.4) THEN
        IF(ANAME.EQ.'H0  ') THEN
          ANAME    = 'H   '
          CTYPE='H   '
        ENDIF
        IF(ANAME.EQ.'HT1 ') THEN
          ANAME    = 'H1  '
          ASYMB    = 'H   '
          CTYPE    = 'H   '
        ENDIF
        IF(ANAME.EQ.'HT2 ') THEN
          ANAME    = 'H2  '
          ASYMB    = 'H   '
          CTYPE    = 'H   '
        ENDIF
        IF(ANAME.EQ.'HT3 ') THEN
          ANAME    = 'H3  '
          ASYMB    = 'H   '
          CTYPE    = 'H   '
        ENDIF
      ENDIF

      RETURN
      END

      SUBROUTINE SET_CTYPE(ASYMB,CTYPE)
      CHARACTER ASYMB*4,CTYPE*4
      CHARACTER CH2*2
C ---
      INCLUDE 'metal.fh'
C ---
C      PARAMETER (N_NAME = 32)
C      CHARACTER NAME(N_NAME)*2
C      DATA NAME/'CO','MG','CA','ZN','CU','FE','CL','BR','MN','PB',
C     *          'HG','AL','GD','NA','CD','NI','SR','IN','HO','YB',
C     *          'TE','LI','RB','BA','CS','SM','TL','PT','BE','SE',
C     *          'MO','SI'/
C ??? more
C ---
C ---------------------------------------------
      CH2 = ASYMB(1:2)
      DO  I=1,N_NAME
        IF(NAME(I).EQ.CH2) THEN
          CTYPE = '$   '
          GO TO 100
        ENDIF
      ENDDO
      IF(ASYMB.EQ.'H   '.OR.ASYMB.EQ.'D   ') THEN
        CTYPE = 'H   '
      ELSE
        CTYPE = 'C   '
      ENDIF
  100 CONTINUE
      RETURN
      END

      SUBROUTINE CHECK_CHAIN_ID_SEG(MDOC,INEW,IERR)
C -----------------------------------------------
C -P- 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
c     CHARACTER LINE*80
C ---
C -----------------------------------
      INCLUDE 'atom_com.fh'
C -----------------------------------
C ---
      CHARACTER CH1*1,CH4*4
      INTEGER   NLETT
      CHARACTER LETT*60
C ---
      DATA NLETT /60/
      DATA LETT/
     *'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPRSTUVWXYZ123456789'/
C      123456789 123456789 123456789 123456789 123456789 123456789       
C ------------------------------------
      IERR = 0
      INEW = 0
      IF(N_GROUP.LE.1) THEN
        RETURN
      ENDIF

      DO I=1,N_GROUP
        CH4 = GROUP_ID(I)
        DO J=1,I-1
          IF(CH4.EQ.GROUP_ID(J)) GO TO 600
        ENDDO
      ENDDO
      RETURN

 600  CONTINUE

      DO I=2,N_GROUP

        CH4 = GROUP_ID(I) 
                 
        DO J=1,I-1
          IF(CH4.EQ.GROUP_ID(J)) GO TO 100
        ENDDO
        GO TO 200

 100    CONTINUE

        DO K=1,NLETT
          CH1 = LETT(K:K)
          DO J=1,N_GROUP
            IF(GROUP_ID(J)(4:4).EQ.GROUP_ID(I)(4:4).AND.I.NE.J) THEN
              IF(CH1.EQ.GROUP_ID(J)(4:4)) GO TO 300
            ENDIF
          ENDDO
          GO TO 400
 300      CONTINUE
        ENDDO

 400    CONTINUE

        GROUP_ID(I)(4:4) = CH1
 
 200    CONTINUE

      ENDDO


      DO I=1,N_GROUP
        CH4 = GROUP_ID(I)
        IF(CH4(4:4).NE.' ') THEN
          IF(CH4(3:3).EQ.' ') CH4(3:3) = '_'
          IF(CH4(2:2).EQ.' ') CH4(2:2) = '_'
          GROUP_ID(I) = CH4
        ENDIF
        IRS         = IRES_FIRST(I)
        IRF         = IRS + NRES_CHAIN(I) - 1
        DO IR=IRS,IRF
          RES_NUM_PDB(IR)(1:2)   = GROUP_ID(I)(1:2)
          RES_NUM_PDB(IR)(8:11)  = GROUP_ID(I)
          RES_NUM_PDB(IR)(12:12) = ' '
        ENDDO
      ENDDO


      DO I=1,N_GROUP
        CH4 = GROUP_ID(I)
        DO J=1,I-1
          IF(CH4.EQ.GROUP_ID(J)) INEW = 1
        ENDDO
      ENDDO

C ----------------------
      RETURN
      END

      SUBROUTINE CHECK_CHAIN_ID_CIF(MDOC,INEW,IERR)
C -----------------------------------------------
C -P- 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
c     CHARACTER LINE*80
C ---
C -----------------------------------
      INCLUDE 'atom_com.fh'
C -----------------------------------
C ---
      CHARACTER CH1*1,CH2*2
      INTEGER   NLETT
      CHARACTER LETT*60
C ---
      DATA NLETT /60/
      DATA LETT/
     *'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPRSTUVWXYZ123456789'/
C      123456789 123456789 123456789 123456789 123456789 123456789       
C ------------------------------------
      IERR = 0
      INEW = 0
      IF(N_GROUP.LE.1) THEN
        RETURN
      ENDIF

      DO I=1,N_GROUP
        CH2 = GROUP_ID(I)(1:2) 
        DO J=1,I-1
          IF(CH2.EQ.GROUP_ID(J)(1:2)) GO TO 600
        ENDDO
      ENDDO
      RETURN

 600  CONTINUE

      DO I=1,N_GROUP
        IF(GROUP_ID(I)(1:1).EQ.' ') GROUP_ID(I)(1:1) = 'X' 
        IF(GROUP_ID(I)(1:1).EQ.'.') GROUP_ID(I)(1:1) = 'X' 
        GROUP_ID(I)(2:2) = GROUP_ID(I)(1:1) 
        GROUP_ID(I)(3:3) = GROUP_ID(I)(1:1) 
      ENDDO

      DO I=2,N_GROUP

        CH2 = GROUP_ID(I)(1:2) 
                 
        DO J=1,I-1
          IF(CH2.EQ.GROUP_ID(J)(1:2)) GO TO 100
        ENDDO
        GO TO 200

 100    CONTINUE

        DO K=1,NLETT
          CH1 = LETT(K:K)
          DO J=1,N_GROUP
            IF(GROUP_ID(J)(1:1).EQ.GROUP_ID(I)(1:1).AND.I.NE.J) THEN
              IF(CH1.EQ.GROUP_ID(J)(2:2)) GO TO 300
            ENDIF
          ENDDO
          GO TO 400
 300      CONTINUE
        ENDDO

 400    CONTINUE

        GROUP_ID(I)(2:2) = CH1
 
 200    CONTINUE

      ENDDO

 500  CONTINUE

      DO I=1,N_GROUP
        CH2 = GROUP_ID(I)(2:3)
        IF(CH2.NE.GROUP_ID(I)(1:2)) INEW = 1
        GROUP_ID(I)(3:3) = ' '
        GROUP_ID(I)(4:4) = ' ' 
        CHAIN_ID(I) = GROUP_ID(I)      
        IRS         = IRES_FIRST(I)
        IRF         = IRS + NRES_CHAIN(I) - 1
        DO IR=IRS,IRF
          RES_NUM_PDB(IR)(1:2)  = GROUP_ID(I)(1:2)
          RES_NUM_PDB(IR)(8:11) = GROUP_ID(I)
        ENDDO
      ENDDO
C ----------------------
      RETURN
      END


      SUBROUTINE CHECK_CHAIN_ID_PDB(MDOC,INEW,IERR)
C -----------------------------------------------
C -P- 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C     CHARACTER LINE*80
C ---
C -----------------------------------
      INCLUDE 'atom_com.fh'
C -----------------------------------
C ---
      CHARACTER CH1*1,CH2*2
      INTEGER   NLETT
      CHARACTER LETT*60
C ---
      DATA NLETT /60/
      DATA LETT/
     *'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPRSTUVWXYZ123456789'/
C      123456789 123456789 123456789 123456789 123456789 123456789       
C ------------------------------------
      IERR = 0
      INEW = 0
      IF(N_GROUP.LE.0) RETURN

      DO I=1,N_GROUP
        IF(GROUP_ID(I)(1:1).EQ.' ') GROUP_ID(I)(1:1) = 'X' 
        IF(GROUP_ID(I)(1:1).EQ.'.') GROUP_ID(I)(1:1) = 'X' 
        GROUP_ID(I)(2:2) = GROUP_ID(I)(1:1) 
        GROUP_ID(I)(3:3) = GROUP_ID(I)(1:1) 
      ENDDO

      IF(N_GROUP.LE.1) GO TO 500

      DO I=2,N_GROUP

        CH2 = GROUP_ID(I)(1:2) 
                 
        DO J=1,I-1
          IF(CH2.EQ.GROUP_ID(J)(1:2)) GO TO 100
        ENDDO
        GO TO 200

 100    CONTINUE

        DO K=1,NLETT
          CH1 = LETT(K:K)
          DO J=1,N_GROUP
            IF(GROUP_ID(J)(1:1).EQ.GROUP_ID(I)(1:1).AND.I.NE.J) THEN
              IF(CH1.EQ.GROUP_ID(J)(2:2)) GO TO 300
            ENDIF
          ENDDO
          GO TO 400
 300      CONTINUE
        ENDDO

 400    CONTINUE

        GROUP_ID(I)(2:2) = CH1
 
 200    CONTINUE

      ENDDO

 500  CONTINUE

      DO I=1,N_GROUP
        CH2 = GROUP_ID(I)(2:3)
        IF(CH2.NE.GROUP_ID(I)(1:2)) INEW = 1
        GROUP_ID(I)(3:3) = ' '
        GROUP_ID(I)(4:4) = ' ' 
        CHAIN_ID(I) = GROUP_ID(I)      
        IRS         = IRES_FIRST(I)
        IRF         = IRS + NRES_CHAIN(I) - 1
        DO IR=IRS,IRF
          RES_NUM_PDB(IR)(1:2)  = GROUP_ID(I)(1:2)
          RES_NUM_PDB(IR)(8:11) = GROUP_ID(I)
        ENDDO
      ENDDO
C ----------------------
      RETURN
      END


      SUBROUTINE CORR_NAME_CIF_OUT(ATOM)
      implicit none
      CHARACTER ATOM*(*),ATOM1*80,CH1*1,TYPE*1
C ------
c
      integer i,ln
      integer ii1p,ii2p,iisp,iid
c
      ln = len_trim(atom)
      if(ln.le.0) return
      i = 1
      do while(atom(i:i).eq.' '.and.i.lt.ln)
         i = i + 1
      enddo
      if(i.le.ln) atom1 = atom(i:ln)
      atom = trim(atom1)
      ln = len_trim(atom)
      ii1p = 0
      ii2p = 0
      iisp = 0
      iid = 0
      do i=1,ln
         if(atom(i:i).eq.'''') ii1p = ii1p + 1
         if(atom(i:i).eq.'"') ii2p = ii2p + 1
         if(atom(i:i).eq.' ') iisp = iisp + 1
         if(atom(i:i).eq.'#') iisp = iisp + 1
         if(atom(i:i).eq.';') iisp = iisp + 1
      enddo
      if(ii1p.gt.0.and.ii2p.gt.0) then
         write(*,*)'ERROR in CORR_NAME_CIF_OUT: '//'
     &        The are prime and double prime in the atom name'
         stop
      endif
      atom1 = trim(atom)
      if(iisp.gt.0.and.ii1p.le.0.or.ii2p.gt.0) then
         atom1 = ''''//trim(atom)//''''
      else if(iisp.gt.0.and.ii2p.le.0.or.ii1p.gt.0) then
         atom1 = '"'//trim(atom)//'"'
      endif

      atom = trim(atom1)
      RETURN
      END

C =========== blanc =======================================================

      SUBROUTINE FRD_PARM
C -------------------------------------------------------
C -P- FRD_PARM - free format reading of the string of characters.
C                See common /COMFREAD/
C
C     input:     IN_STRING - input string; a word is the part of the string
C                            between two blancs or two "'".
C     output:    NWORDS    - number of words of the string
C                IWORDS    - array of integer value of each word.
C                FWORDS    - array of real value of each word.
C                WORDS     - array of words
C                LEN_WORDS - array of lengths of the words
C                IFRD_ERR  - signal of error. 
C                            0  means OK.
C                            1 - number of words > NWORDSMAX = 40
C -----------------------------------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMFREAD/ 
     *                  FWORDS,IFRD_ERR,NWORDS,LEN_WORDS,IWORDS
     *                 ,WORDS,IN_STRING
      REAL      FWORDS   (NWORDSMAX)
      INTEGER*4 LEN_WORDS(NWORDSMAX)
      INTEGER*4 IWORDS   (NWORDSMAX)
      INTEGER*4 NWORDS,IFRD_ERR
      CHARACTER WORDS(NWORDSMAX)*80
      CHARACTER IN_STRING*80
C --------------------------------------------------------------
      REAL      FA
      INTEGER*4 NW,IS,IW,IAP,LEN,IP,IA
      CHARACTER CH*1,CK*1,STR*80
C --------------------------------------------------------------
      IFRD_ERR = 0
      NWORDS   = 0
      NW       = 0
      IW       = 0
      IS       = 0
      IAP      = 0
      CALL LENSTR_BL(IN_STRING,LEN)
      IF(LEN.LE.0) RETURN
      IF(LEN.GT.80) LEN=80
C -----------------
      DO   IP=1,LEN
        CH = IN_STRING(IP:IP)
        CALL CHKSMB(CH,CK)
        IF(CK.EQ.'?') CH = ' '
        IF(CH.EQ.'''') THEN
          IAP = IAP+1
          IF(IAP.GE.2) IAP = 0
        ENDIF
        IF(CH.NE.' '.OR.IAP.EQ.1) THEN
C         start of a word
          IF(IS.EQ.0) THEN
            IS = 1
            NW = NW + 1
            IF(NW.GT.20) THEN
              IFRD_ERR=1
              RETURN
            ENDIF
          ENDIF
          IF(CH.NE.'''') THEN
            IW         = IW + 1
            STR(IW:IW) = CH       
          ELSE
            IF(IW.GT.0) THEN
            ENDIF
          ENDIF
        ENDIF
        IF((CH.EQ.' '.AND.IS.EQ.1.AND.IAP.EQ.0).OR.
     *       (IP.EQ.LEN.AND.IW.NE.0)) THEN
          IF(IW.LE.0) THEN
            WORDS(NW)     = '?'
            LEN_WORDS(NW) = 1
          ELSE
            WORDS(NW)     = STR(1:IW)
            LEN_WORDS(NW) = IW
          ENDIF
          NWORDS = NW
          CALL WTODIG(STR,IW,FA,IA)
          IWORDS(NW) = IA
          FWORDS(NW) = FA
          IS         = 0
          IW         = 0
          IAP        = 0
        ENDIF
      ENDDO
C -----------------
      RETURN
      END      

C ******
      SUBROUTINE WTODIG(STR,IW,F,I)
C -------------------------------------------------------
C -P- WTODIG - convert string to integer and real.
C              
C              STR  - input string of characters (without blancs).
C              IW   - number of characters in the string.
C              I    - output integer value of string.
C              F    - output real value of string.
C      Subroutine returns I=0 and F=0.0 if it can't convert the string 
C      to the digits.
C      Examples right strings: "+23", "324", "-123", "-1.0", "0.23",
C                              "+2.00", "-1.2E-2", "0.3e+2", "-3E4".
C -S- 
C -------------------------------------------------------
      REAL F
      INTEGER*4 I,IW
      CHARACTER STR*(*)
C ******
C ---
      REAL A,SIGN
      INTEGER*4 IA,INTGR,IPOINT,NP,K,J
      CHARACTER CH*1,NUM(10)*1
      DATA NUM /'0','1','2','3','4','5','6','7','8','9'/
C ---------------------------------
      INTGR  = 0
      SIGN   = 1.0
      IPOINT = 0
      NP     = 0
      F      = 0.0
      I      = 0
      A      = 0.0
      IA     = 0
      IE     = 0
      IF(IW.GT.16) RETURN
C --------------------------------
      DO   J=1,IW
        CH=STR(J:J)
        DO    K=1,10
          IF(CH.EQ.NUM(K)) GO TO 100
        ENDDO  
        IF((CH.EQ.'-'.OR.CH.EQ.'+').AND.J.EQ.1) THEN
          IF(CH.EQ.'-') SIGN=-1.0
          GO TO 200
        ENDIF
        IF(CH.EQ.'.'.AND.IPOINT.EQ.0) THEN
          IPOINT=1
          GO TO 200
        ENDIF
        IF(CH.EQ.'e'.OR.CH.EQ.'E') THEN
          IF(A.EQ.0.0) RETURN
          IE=1
          GO TO 300
        ENDIF
        RETURN
  100   CONTINUE
        K = K - 1
        IF(IPOINT.EQ.1) NP = NP + 1
        A = A*10.0 + K
        IF(IPOINT.EQ.0) IA = IA*10 + K
 200    CONTINUE
      ENDDO
 300  F = SIGN*A/10.0**NP
      I = IA
      IF(SIGN.LT.0.0) I=-I
C --- 
      J = J + 1
      IF(IE.EQ.0.OR.J.GT.IW) RETURN
      I     = 0
      IA    = 0
      A     = F
      F     = 0.0
      ISIGN = 1
C --------------------------------
      JJ = J
      DO   J=JJ,IW
        CH=STR(J:J)
        DO    K=1,10
          IF(CH.EQ.NUM(K)) GO TO 400
        ENDDO  
        IF((CH.EQ.'-'.OR.CH.EQ.'+').AND.J.EQ.JJ) THEN
          IF(CH.EQ.'-') ISIGN = -1
          GO TO 500
        ENDIF
        RETURN
  400   CONTINUE
        K  = K-1
        IA = IA*10+K
  500   CONTINUE
      ENDDO
      IF(IA.GT.31) IA=31
      IF(ISIGN.LT.0) IA = -IA
      F = A * 10.0**IA
C ---------------------------------
      RETURN
      END

      SUBROUTINE SET_BYTE
      COMMON/COM_BYTE/ IBYTE1,IBYTE2
     *,ISTART_A_CAP,ISTART_A_LOW,ISTART_DIG_0
C --------------------------
      INTEGER   IN4
      INTEGER*2 IN2(2)
      EQUIVALENCE (IN4,IN2(1))
C -----------------------
      CHARACTER CHAR*1
      INTEGER*2 ICH
      CHARACTER CH2*2
      EQUIVALENCE (CH2,ICH)
C -----
      IN2(1) = 100
      IN2(2) = 0
      IF(IN4.EQ.100) THEN
C          IN4
C          2 1
        IBYTE1 = 1
        IBYTE2 = 2
      ELSE
C          IN4
C          1 2
        IBYTE1 = 2
        IBYTE2 = 1
      ENDIF
C -----------------------------------------
      CHAR               = '0'
      ICH                = 0
      CH2(IBYTE1:IBYTE1) = CHAR
      ISTART_DIG_0       = ICH
      CHAR               = 'A'
      ICH                = 0
      CH2(IBYTE1:IBYTE1) = CHAR
      ISTART_A_CAP       = ICH
      CHAR               = 'a'
      ICH                = 0
      CH2(IBYTE1:IBYTE1) = CHAR
      ISTART_A_LOW       = ICH
      RETURN
      END

C ******
      SUBROUTINE CHECK_LINE(IMODE,LINE)
C ------------------------------------------
C -P- CHECK_LINE - check and convert symbols of line.
C               MODE  0  only check
C                    -1  convert symbols to low case.
C                     1  to upper
C ---------------------------------------------
      CHARACTER LINE*(*)
      COMMON/COM_BYTE/ IBYTE1,IBYTE2
     *,ISTART_A_CAP,ISTART_A_LOW,ISTART_DIG_0
C ******
      INTEGER   ICH4
      CHARACTER CHAR*1,TYPE*1
C -----------------------------------------
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.GT.256) LEN=256
      IF(LEN.GT.0) THEN
        DO I=1,LEN       
          ICH4 = 0
          CHAR = LINE(I:I) 
          CALL CHKSMB(CHAR,TYPE)
          IF(TYPE.EQ.'l'.AND.IMODE.EQ.1) THEN
            CALL CHTOINT(CHAR,ICH4)
C           ICH4 = ICH4 - 32
            ICH4 = ICH4 - (ISTART_A_LOW - ISTART_A_CAP)
            CALL INTTOCH(CHAR,ICH4)
          ELSE IF(TYPE.EQ.'L'.AND.IMODE.EQ.-1) THEN
            CALL CHTOINT(CHAR,ICH4)
C           ICH4 = ICH4 + 32
            ICH4 = ICH4 + (ISTART_A_LOW - ISTART_A_CAP)
            CALL INTTOCH(CHAR,ICH4)
          ENDIF
          IF(TYPE.EQ.'?') CHAR = ' '
          LINE(I:I) = CHAR
        ENDDO
      ENDIF
      RETURN
      END

C ******
      SUBROUTINE CHKSMB(CHAR,TYPE)
C ------------------------------------------
C -P- CHKSMB - check symbol.
C
C  input: CHAR - one symbol.   
C  output TYPE - one symbol
C
C  if   CHAR = 'A' -- 'Z'           TYPE = 'L'    
C       CHAR = 'a' -- 'z'           TYPE = 'l'    
C       CHAR = '0' -- '9'           TYPE = 'D'    
C       CHAR = '+' or '-'           TYPE = 'S'
C       CHAR = '*' or '/' or
C              '=' or '.'           TYPE = 'O'
C       CHAR = ' '                  TYPE = 'B'
C       CHAR = any printed symbol   TYPE = 'C'
C  else             Type = '?'
C ---------------------------------------------
      CHARACTER CHAR*1,TYPE*1
      COMMON/COM_BYTE/ IBYTE1,IBYTE2
     *,ISTART_A_CAP,ISTART_A_LOW,ISTART_DIG_0
C ******
      INTEGER   ICH
      CHARACTER CH*1
C     CHARACTER CH1*1
C -----------------------------------------
      TYPE = '?'
      ICH  = 0
      CH   = CHAR
      CALL LENSTR_BL(CH,LEN)
      IF(CH.EQ.' '.AND.LEN.LE.0) LEN=1
      IF(LEN.LE.0) THEN
        TYPE = '?'
        RETURN
      ENDIF

      CALL CHTOINT(CH,ICH)

C      IF(ICH.GE. 65 .AND.ICH.LE. 90 ) THEN
C        TYPE='L'
C      ELSE IF(ICH.GE. 97 .AND.ICH.LE.122 ) THEN
C        TYPE='l'
C      ELSE IF(ICH.GE. 48 .AND.ICH.LE. 57 ) THEN
C        TYPE='D'

      ISF_CAP = ISTART_A_CAP+25
      ISF_LOW = ISTART_A_LOW+25
      ISF_DIG = ISTART_DIG_0+9
      
      IF(ICH.GE.ISTART_A_CAP.AND.ICH.LE.ISF_CAP ) THEN
        TYPE='L'
      ELSE IF(ICH.GE.ISTART_A_LOW.AND.ICH.LE.ISF_LOW ) THEN
        TYPE='l'
      ELSE IF(ICH.GE.ISTART_DIG_0.AND.ICH.LE.ISF_DIG ) THEN
        TYPE='D'
      ELSE IF(CH.EQ.'+'.OR.CH.EQ.'-') THEN
        TYPE='S'
      ELSE IF(CH.EQ.'*'.OR.CH.EQ.'/'.OR.CH.EQ.'.'.OR.CH.EQ.'=') THEN
        TYPE='O'
      ELSE IF(CH.EQ.' ') THEN
        TYPE='B'
      ELSE IF(CH.EQ.'''') THEN
C             '
        TYPE='C'
      ELSE IF(CH.EQ.'_') THEN
        TYPE='U'
      ELSE IF(CH.EQ.'\\') THEN
C             \
        TYPE='C'
      ELSE 
        IF(CH.EQ.'!'.OR.CH.EQ.'@'.OR.CH.EQ.'#'.OR.CH.EQ.'$'
     * .OR.CH.EQ.'"'.OR.CH.EQ.'>'.OR.CH.EQ.'%'.OR.CH.EQ.'^'
     * .OR.CH.EQ.'`'.OR.CH.EQ.'?'.OR.CH.EQ.'('.OR.CH.EQ.'['
     * .OR.CH.EQ.'&'.OR.CH.EQ.'<'.OR.CH.EQ.')'.OR.CH.EQ.'~'
     * .OR.CH.EQ.']'.OR.CH.EQ.'{'.OR.CH.EQ.'}'.OR.CH.EQ.'|'
     * .OR.CH.EQ.';'.OR.CH.EQ.':'.OR.CH.EQ.',') THEN
          TYPE='C'
        ENDIF
      ENDIF
      RETURN
      END

      SUBROUTINE CLEAR_LINE(LINE)
C
      CHARACTER LINE*(*)
C ******
      INTEGER*4 L
C -------------------------------------------------------------
      CALL LENSTR_BL(LINE,L)
      IF(L.GT.0) THEN
        DO I=L,1,-1
          IF(LINE(I:I).EQ.',') THEN
            LINE(I:I)=' '
          ELSE
            IF(LINE(I:I).NE.' ') GO TO 100
          ENDIF 
        ENDDO
 100    CONTINUE
      ENDIF
      RETURN
      END


C ******
      SUBROUTINE CHTOINT(CHAR,ICHAR)
C ------------------------------------------
C -P- CHTOINT - convert a character to integer
C ---------------------------------------------
      CHARACTER CHAR*1
      INTEGER*4 ICHAR
C ----------------------------------------
      COMMON/COM_BYTE/ IBYTE1,IBYTE2
     *,ISTART_A_CAP,ISTART_A_LOW,ISTART_DIG_0
C ******
      INTEGER*2 ICH
      CHARACTER CH2*2
      EQUIVALENCE (CH2,ICH)
C -----------------------------------------
      ICH                = 0
      CH2(IBYTE1:IBYTE1) = CHAR
      ICHAR              = ICH
      RETURN
      END

C ******
      SUBROUTINE INTTOCH(CHAR,ICHAR)
C ------------------------------------------
C -P- INTTOCH - convert a integer to character 
C ---------------------------------------------
      CHARACTER CHAR*1
      INTEGER*4 ICHAR
C ----------------------------------------
      COMMON/COM_BYTE/ IBYTE1,IBYTE2
     *,ISTART_A_CAP,ISTART_A_LOW,ISTART_DIG_0
C ******
      INTEGER*2 ICH
      CHARACTER CH2*2
      EQUIVALENCE (CH2,ICH)
C -----------------------------------------
      ICH  = ICHAR
      CHAR = CH2(IBYTE1:IBYTE1)
      RETURN
      END

C ******
      SUBROUTINE WRTSTR(IUN,MDOC,LINE,IERR)
C -------------------------------------------------------
C -P- WRTSTR - writes a string to file.
C -S-
C -------------------------------------------------------
      INTEGER*4 MDOC,IUN,IERR
C ******
      CHARACTER LINE*(*)
C ----------------------------------
      IERR=0
      IF(IUN.LE.0) RETURN
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.LE.0) RETURN
      WRITE(IUN,'(A)',ERR=100) LINE(1:LEN)
      RETURN
  100 CONTINUE
      IERR=1
      RETURN
      END      

C =====================================================

C ******
      SUBROUTINE START(IG,MDOC,PROG)
C
C -P- START - initialization common/COMLIB/,/CRYSTL/,.., open DOC-file.
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80,PATH*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ------
C --------------
      INCLUDE 'crd_com.fh'
C -------------------------------------------------
C ---
      INTEGER*4  MDOC,IG
      CHARACTER  PROG*(*)
C ******
      INTEGER*4  M,IERR
      CHARACTER  LINE*80
C -------------------------
C     PI     = 4.0*ATAN(1.0)
      IGRAPH = IG
C -----------------------
      IERR   = 0
C -----------------------
      CALL SET_BYTE
      IBATCH = 0
      CALL INIT_DEFAULTS
C ---
      CALL SET_UNIT_NUMBERS
      CALL SET_CIF_TYPES
      CALL SET_UNIT_CORR
C ---
      CALL LENSTR_BL(PROG,LEN_PROG)
      IF(LEN_PROG.LE.0) THEN
        LEN_PROG  = 1
        PROG(1:1) = 'x'
      ELSE IF(LEN_PROG.GT.20) THEN
        LEN_PROG = 20
      ENDIF
      PROGRAMM = PROG(1:LEN_PROG)
      IF(MDOC.GE.997) THEN
C       subroutine mode
        LINEL  =  PROG(1:LEN_PROG)
C        M      = -ABS(MDOC)
      ENDIF
C ---
      IF(MDOC.EQ.0) THEN
        M = 0
      ELSE IF(MDOC.GE.997) THEN
C       subroutine mode
C       M = 999
        M = MDOC    
      ELSE IF(MDOC.LE.-997) THEN
C       subroutine mode
        M = 0
      ELSE IF(MDOC.LT.0) THEN
        M =-48
        IF(MDOC.LE.-99) M =-99
      ELSE IF(MDOC.GT.0) THEN
        M = 48
        IF(MDOC.GE.99) M = 99
      ENDIF

      CALL OPENDOC(M)

      IF(M.EQ.0) MDOC = 0
      MDOC = ABS(MDOC)
      IF(MDOC.GE.997) THEN
C       subroutine mode
        MDOC = 1
      ENDIF
C ---
C
      CALL INIT_ATM_INF(MDOC,IERR)
      CALL INIT_CRD_INF(MDOC,IERR)
C ---
C ----------------------------------
      CALL WRT_BATCH('# --------------------------------')
C      CALL LENSTR_BL(MAKECIFLIB,LEN_P)
C      PATH  = MAKECIFLIB
C      PATH  = PATH(1:LEN_P)//'/bin/'
C      LEN_P = LEN_P+5

      PATH  = CR_PROG_PATH
      CALL LENSTR_BL(PATH,LEN_P)
C     LINE  = PATH(1:LEN_P)//PROGRAMM(1:LEN_PROG)//' <<stop'
      LINE  = PROGRAMM(1:LEN_PROG)//' <<stop'
C
C      LINE='$BLANC/exe/'//PROGRAMM(1:LEN)//' <<stop'
C
      CALL WRT_BATCH(LINE)
      CALL WRT_BATCH('# --------------------------------')
      CALL WRT_BATCH('# first line :   "_DOC  <N>,Y,A "')
      LINE=
     *'#   N - means without DOC-file: "'//PROGRAMM(1:LEN_PROG)//'.doc"'
      CALL WRT_BATCH(LINE)
      CALL WRT_BATCH(
     *'#   Y - create new file or rewrite if it is old file')
      CALL WRT_BATCH(
     *'#   A - means to keep old contents and add new information')
      CALL WRT_BATCH('#  ')
      CALL WRT_BATCH('_DOC  Y')
      CALL WRT_BATCH('#  ')
C ---
      RETURN
      END          

      SUBROUTINE INIT_DEFAULTS
C -----------------------------------------------------
      PARAMETER ( KEY_MAX = 40 )
C -----
      COMMON/COMASK/ IEND,NKEY,FLAG,STOR,STOR_KEY 
      INTEGER*4 FLAG(KEY_MAX),IEND,NKEY
      CHARACTER STOR(KEY_MAX)*256,STOR_KEY(KEY_MAX)*11
C --
      COMMON/COMASK2/ NKEY_TEST,KEY_TEST
      INTEGER*4 NKEY_TEST
      CHARACTER KEY_TEST(KEY_MAX)*11
C ---
C ------------------------------------------------------
      CALL SET_BYTE
C --
      IEND           = 0
      NKEY           = 0
      NKEY_TEST      = 0
C --
      DO I=1,KEY_MAX
        FLAG(I) = 0
      ENDDO
C -----------------------
      RETURN
      END

      SUBROUTINE INIT_ATM_INF(MDOC,IERR)
C ==================================================================
C
C     initialization common blocks CS_...
C
C ==================================================================
      INCLUDE 'atom_com.fh'  
C ==================================================================
      INTEGER   MDOC,IERR
C     CHARACTER LINE*80
C ==================================================================
      PI   = 4.0*ATAN(1.0)
      IERR = 0
C ---
      PROG_NAME_CRD = '.'
C     N_GROUP    - number of chains
C     N_RESIDUE  - number of residues
C     N_ATOM     - number of atoms
C
      N_GRP_ASM     = 0
      N_CHN_ENT     = 0
      ENT_NRESIDUE  = 0
      ENT_LN_N      = 0
      N_GROUP       = 0
      N_RESIDUE     = 0
      N_ATOM        = 0
      LN_N          = 0
      MOD_N         = 0
      N_ANISO       = 0
C ----
      CS_CELL(1)    = 100.0
      CS_CELL(2)    = 100.0
      CS_CELL(3)    = 100.0
      CS_CELL(4)    = PI/2.0
      CS_CELL(5)    = PI/2.0
      CS_CELL(6)    = PI/2.0
      CS_SCALE(1,1) = 1.0
      CS_SCALE(1,2) = 0.0
      CS_SCALE(1,3) = 0.0
      CS_SCALE(2,1) = 0.0
      CS_SCALE(2,2) = 1.0
      CS_SCALE(2,3) = 0.0
      CS_SCALE(3,1) = 0.0
      CS_SCALE(3,2) = 0.0
      CS_SCALE(3,3) = 1.0
      CS_U(1)       = 0.0
      CS_U(2)       = 0.0
      CS_U(3)       = 0.0
C
      CS_ORT_TO_FRAC(1,1) = 1.0
      CS_ORT_TO_FRAC(1,2) = 0.0
      CS_ORT_TO_FRAC(1,3) = 0.0
      CS_ORT_TO_FRAC(2,1) = 0.0
      CS_ORT_TO_FRAC(2,2) = 1.0
      CS_ORT_TO_FRAC(2,3) = 0.0
      CS_ORT_TO_FRAC(3,1) = 0.0
      CS_ORT_TO_FRAC(3,2) = 0.0
      CS_ORT_TO_FRAC(3,3) = 1.0
      CS_FRAC_TO_ORT(1,1) = 1.0
      CS_FRAC_TO_ORT(1,2) = 0.0
      CS_FRAC_TO_ORT(1,3) = 0.0
      CS_FRAC_TO_ORT(2,1) = 0.0
      CS_FRAC_TO_ORT(2,2) = 1.0
      CS_FRAC_TO_ORT(2,3) = 0.0
      CS_FRAC_TO_ORT(3,1) = 0.0
      CS_FRAC_TO_ORT(3,2) = 0.0
      CS_FRAC_TO_ORT(3,3) = 1.0
C
      CS_NAME_PDB = '----'
      CS_DATE_PDB = 'XX-XXX-XX'
      CS_CD_PDB   = 'xxxx'
      CS_TITLE    = '---'
      CS_RFAC_PDB = '.'
      CS_RESL_PDB = '.'
      CS_MODEL_PDB= 0
      CS_NSPGR    = 1
      CS_SETT     = 1
      CS_SPGR     = 'P 1        '
      CS_NSYM     = 1
      CS_NSYMOP   = 0
      CS_NCS      = 0
      CS_NSFATM   = 0
C     CS_SYMOP(1) = 'X,Y,Z'

      CS_M_CS(1,1,1) = 1.0       
      CS_M_CS(1,2,1) = 0.0       
      CS_M_CS(1,3,1) = 0.0       
      CS_M_CS(2,1,1) = 0.0       
      CS_M_CS(2,2,1) = 1.0       
      CS_M_CS(2,3,1) = 0.0       
      CS_M_CS(3,1,1) = 0.0       
      CS_M_CS(3,2,1) = 0.0       
      CS_M_CS(3,3,1) = 1.0       

      CS_V_CS(1,1) = 0.0       
      CS_V_CS(2,1) = 0.0       
      CS_V_CS(3,1) = 0.0             
C ---
      CS_TEMPER     = 0.0
      CS_WAVEL      = 0.0
      CS_RES_MIN    = 0.0
      CS_RES_MAX    = 0.0
      CS_RFAC_ALL   = 0.0
      CS_RFAC_OBS   = 0.0
      CS_SIGMA_I    = 0.0
      CS_SIGMA_F    = 0.0
      CS_CD_NDB     = '?'
      CS_CD_CSD     = '?'
      CS_DATE_NDB   = '?'
      CS_DATE_CREAT = '?'
      CS_PROGRAM    = '?'
      CS_METHOD     = '?'
C----
C ----- PDB 2 --------------------
      CS_RFAC_CUT     = 0.0
      CS_NMODEL       = 0
      CS_RMEGR_ALL    = 0.0
      CS_RMERG_OBS    = 0.0
      CS_RMERG_IOBS   = 0.0
      CS_RES_RMIN     = 0.0
      CS_RES_RMAX     = 0.0
      CS_SIGMAR_I     = 0.0
      CS_SIGMAR_F     = 0.0
      CS_RFREE_ALL    = 0.0
      CS_RFREE_OBS    = 0.0
      CS_RFREE_CUT    = 0.0
      CS_DPI          = 0.0
      CS_ERR_CRD_MIN  = 0.0
      CS_ERR_CRD_MAX  = 0.0
      CS_NDB_TITLE    = '?'
      CS_NAME_NDB     = '?                           '
      CS_INFO_FLAG    = '?'
C ---
      OUT_CIF_MULT    = 0
      OUT_CIF_CORR    = 0
      OUT_CIF_INS     = 0
C------------------------------------------
      RETURN
      END

      SUBROUTINE INIT_CRD_INF(MDOC,IERR)
C ==================================================================
C
C     initialization common blocks CR_...
C
C ==================================================================
      INCLUDE 'crd_com.fh'  
C ==================================================================
      INTEGER   MDOC,IERR
C     CHARACTER LINE*80
C ==================================================================
      PI   = 4.0*ATAN(1.0)
      IERR = 0
C ---
      CR_CELL(1)          = 1.0
      CR_CELL(2)          = 1.0
      CR_CELL(3)          = 1.0
      CR_CELL(4)          = PI/2.0
      CR_CELL(5)          = PI/2.0
      CR_CELL(6)          = PI/2.0
      CR_SCALE(1,1)       = 1.0
      CR_SCALE(1,2)       = 0.0
      CR_SCALE(1,3)       = 0.0
      CR_SCALE(2,1)       = 0.0
      CR_SCALE(2,2)       = 1.0
      CR_SCALE(2,3)       = 0.0
      CR_SCALE(3,1)       = 0.0
      CR_SCALE(3,2)       = 0.0
      CR_SCALE(3,3)       = 1.0
      CR_U(1)             = 0.0
      CR_U(2)             = 0.0
      CR_U(3)             = 0.0
      CR_ORT_TO_FRAC(1,1) = 1.0
      CR_ORT_TO_FRAC(1,2) = 0.0
      CR_ORT_TO_FRAC(1,3) = 0.0
      CR_ORT_TO_FRAC(2,1) = 0.0
      CR_ORT_TO_FRAC(2,2) = 1.0
      CR_ORT_TO_FRAC(2,3) = 0.0
      CR_ORT_TO_FRAC(3,1) = 0.0
      CR_ORT_TO_FRAC(3,2) = 0.0
      CR_ORT_TO_FRAC(3,3) = 1.0
      CR_FRAC_TO_ORT(1,1) = 1.0
      CR_FRAC_TO_ORT(1,2) = 0.0
      CR_FRAC_TO_ORT(1,3) = 0.0
      CR_FRAC_TO_ORT(2,1) = 0.0
      CR_FRAC_TO_ORT(2,2) = 1.0
      CR_FRAC_TO_ORT(2,3) = 0.0
      CR_FRAC_TO_ORT(3,1) = 0.0
      CR_FRAC_TO_ORT(3,2) = 0.0
      CR_FRAC_TO_ORT(3,3) = 1.0
C
      CR_NAME_PDB   = '----'
      CR_DATE_PDB   = 'XX-XXX-XX'
      CR_CD_PDB     = 'xxxx'
      CR_TITLE      = '---'
      CR_RFAC_PDB   = '.'
      CR_RESL_PDB   = '.'
      CR_MODEL_PDB  = 0
      CR_NSPGR      = 1
      CR_SETT       = 1
      CR_SPGR       = 'P 1        '
      CR_NSYM       = 1
      CR_NCS        = 0
      CR_NSFATM     = 0
      CR_SYMOP      = 'X,Y,Z'
      CR_TIME       = '?'
      CR_SOFT       = '?'
C ---
      CR_TEMPER     = 0.0
      CR_WAVEL      = 0.0
      CR_RES_MIN    = 0.0
      CR_RES_MAX    = 0.0
      CR_RFAC_ALL   = 0.0
      CR_RFAC_OBS   = 0.0
      CR_SIGMA_I    = 0.0
      CR_SIGMA_F    = 0.0
      CR_CD_NDB     = '?'
      CR_CD_CSD     = '?'
      CR_DATE_NDB   = '?'
      CR_DATE_CREAT = '?'
      CR_PROGRAM    = '?'
      CR_METHOD     = '?'
C ----
C ----- PDB 2 --------------------
      CR_RFAC_CUT     = 0.0
      CR_NMODEL       = 0
      CR_RMEGR_ALL    = 0.0
      CR_RMERG_OBS    = 0.0
      CR_RMERG_IOBS   = 0.0
      CR_RES_RMIN     = 0.0
      CR_RES_RMAX     = 0.0
      CR_SIGMAR_I     = 0.0
      CR_SIGMAR_F     = 0.0
      CR_RFREE_ALL    = 0.0
      CR_RFREE_OBS    = 0.0
      CR_RFREE_CUT    = 0.0
      CR_DPI          = 0.0
      CR_ERR_CRD_MIN  = 0.0
      CR_ERR_CRD_MAX  = 0.0
      CR_NDB_TITLE    = '?'
      CR_NAME_NDB     = '?'
      CR_INFO_FLAG    = 'C'
C -------------------------------------------
      CR_SEGFLAG      = 'N'
      CR_HFLAG        = '?'
      CR_PDB_REC      = '?'
      CR_MULT_FLAG    = 0
C ---
      CR_RNAME        = '.'
      CR_ANAME        = '.'
      CR_ANAME_INP    = '.'
      CR_ASYMB        = '.'  
      CR_ATYPE        = '.' 
      CR_GROUP        = '.   '
      CR_CHAIN        = '.   '
      CR_FSC          = '.'
      CR_FSA          = '.'
      CR_IATOM        = 0
      CR_IATOLD       = 0  
      CR_IA           = 0
      CR_IRES         = 0
      CR_IGRES        = 0
      CR_ICH          = 0
      CR_IGROUP       = 0
      CR_MULT_FACTOR  = 1
      CR_SF_ID        = 0
      CR_RTYPE        = '.'
      CR_TERM         = '.'
      CR_B_FLAG       = 0
      CR_BTYPE        = 'I'
      CR_FLAG_USER    = 'N'
      CR_LINE         = ' '
      CR_ALT          = '.'
      CR_CORR         = '.'
      CR_SEG          = '.'
      CR_PNUM         = ' '
      ST_CHEM         = '.'
C ------------------------------------------
C     CRI_IUN         = 0
      CRI_FILE        = ' '
      CRI_PATH        = ' '
      CRI_EXT         = ' '      
C ------------------------------------------
      RETURN
      END

      SUBROUTINE COPY_CR_CS
C -----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C -----------------------------------------------------------
      CS_CD_PDB     =  CR_CD_PDB
      CS_CD_NDB     =  CR_CD_NDB      
      CS_INFO_FLAG  =  CR_INFO_FLAG    
      CS_NAME_PDB   =  CR_NAME_PDB
      CS_NAME_NDB   =  CR_NAME_NDB
      CS_DATE_PDB   =  CR_DATE_PDB
      CS_DATE_NDB   =  CR_DATE_NDB
      CS_TITLE      =  CR_TITLE
      CS_NDB_TITLE  =  CR_NDB_TITLE
      CS_MODEL_PDB  =  CR_MODEL_PDB
      CS_RFAC_PDB   =  CR_RFAC_PDB
      CS_RESL_PDB   =  CR_RESL_PDB
      CS_TEMPER     =  CR_TEMPER
      CS_WAVEL      =  CR_WAVEL
      CS_DATE_CREAT =  CR_DATE_CREAT
      CS_RES_RMIN   =  CR_RES_RMIN
      CS_RES_RMAX   =  CR_RES_RMAX
      CS_RFREE_CUT  =  CR_RFREE_CUT
      CS_RFREE_OBS  =  CR_RFREE_OBS
      CS_RFREE_ALL  =  CR_RFREE_ALL
      CS_RFAC_ALL   =  CR_RFAC_ALL
      CS_RFAC_OBS   =  CR_RFAC_OBS
      CS_RFAC_CUT   =  CR_RFAC_CUT
      CS_SIGMA_F    =  CR_SIGMA_F
      CS_SIGMA_I    =  CR_SIGMA_I
      CS_SIGMAR_F   =  CR_SIGMAR_F
      CS_SIGMAR_I   =  CR_SIGMAR_I
      CS_RMERG_IOBS =  CR_RMERG_IOBS
      CS_RMERG_ALL  =  CR_RMERG_ALL
      CS_RMERG_OBS  =  CR_RMERG_OBS
      CS_PROGRAM    =  CR_PROGRAM
      CS_METHOD     =  CR_METHOD
      CS_DPI        =  CR_DPI
      CS_NMODEL     =  CR_NMODEL
      CS_ERR_CRD_MIN=  CR_ERR_CRD_MIN
      CS_ERR_CRD_MAX=  CR_ERR_CRD_MAX

      DO I=1,6
        CS_CELL(I) = CR_CELL(I)
      ENDDO

      DO I=1,3
        CS_U(I) = CR_U(I)
        DO J=1,3
          CS_SCALE(I,J) = CR_SCALE(I,J)
        ENDDO
      ENDDO

      CS_NSPGR = CR_NSPGR
      CS_SPGR  = CR_SPGR
      CS_SETT  = CR_SETT
C -------------------------------
      RETURN
      END
     
C ******
      SUBROUTINE MSGDOC(MDOC,STRING)
C ---
C -P- MSGDOC - writes message to terminal or/and DOC_FILE
C
C        MDOC   < 0  : write to DOC_FILE only ( if DOC_FILE > 0 )
C               = 0  : write to terminal only
C      0 < MDOC < 99 : write to terminal and to DOC_FILE ( if DOC_FILE > 0 )
C              >= 99 : don't write 
C -S-
C ---
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ---
      INTEGER*4 MDOC
      CHARACTER STRING*(*)
C ******
C -----------------------------------
      IF(IGRAPH.EQ.0) THEN
        IF(ABS(MDOC).GE.99) RETURN
        CALL LENSTR_BL(STRING,NL)
C       IF(NL.GE.80) NL=79
        IF(MDOC.GE.0) THEN
          IF(NL.LE.0) THEN
            IF(MDOC.GE.0) WRITE(*,*) 
            IF(MDOC.NE.0.AND.DOC_FILE.GT.0) WRITE(DOC_FILE,*) 
          ELSE
            IF(MDOC.GE.0) WRITE(*,100) STRING(1:NL)
            IF(MDOC.NE.0.AND.DOC_FILE.GT.0) 
     *      WRITE(DOC_FILE,101) STRING(1:NL)
 100        FORMAT(' ',A)
 101        FORMAT(A)
          ENDIF
        ELSE
          IF(NL.LE.0) THEN
            IF(DOC_FILE.GT.0) WRITE(DOC_FILE,*) 
          ELSE
            IF(DOC_FILE.GT.0) WRITE(DOC_FILE,101) STRING(1:NL)
          ENDIF
        ENDIF
      ELSE
C       CALL MSGDOG(MDOC,STRING)
      ENDIF
      RETURN
      END

C ******
      SUBROUTINE MSGERR(MDOC,STRING)
C ---
C -P- MSGERR - writes message about error to terminal or/and DOC_FILE
C        MDOC   < 0  write to DOC_FILE only ( if DOC_FILE > 0 )
C               = 0  write to terminal only
C      0 < MDOC < 99 write to terminal and to DOC_FILE ( if DOC_FILE > 0 )
C              >= 99 don't write 
C -S-
C ---
C ---
      COMMON/COMLIB/ IGRAPH,DOC_FILE,INF_FILE,BATCH_FILE,IBATCH
     .              ,BAT_MODE,RVAL_1,RVAL_2
     .              ,IVAL_1,IVAL_2,LINEL,MSGL_1,MSGL_2
     .              ,PROGRAMM
      CHARACTER LINEL*80,MSGL_1*1,MSGL_2*1,PROGRAMM*80
      INTEGER*4 IGRAPH,IVAL_1,IVAL_2,DOC_FILE,INF_FILE 
      INTEGER*4 BAT_MODE,BATCH_FILE,IBATCH
C ---
      INTEGER*4 MDOC
      CHARACTER STRING*(*)
C ******
C -----------------------------------
      IF(IGRAPH.EQ.0) THEN
        IF(MDOC.GE.99) RETURN
        CALL LENSTR_BL(STRING,NL)
C       IF(NL.GE.80) NL=79
        IF(NL.LE.0) THEN
          WRITE(*,*) 
          IF(MDOC.NE.0.AND.DOC_FILE.GT.0) WRITE(DOC_FILE,*) 
        ELSE
          WRITE(*,100) STRING(1:NL)
          IF(MDOC.NE.0.AND.DOC_FILE.GT.0) 
     *    WRITE(DOC_FILE,101) STRING(1:NL)
 100      FORMAT(' ',A)
 101      FORMAT(A)
        ENDIF
      ELSE
C        CALL MSGERG(MDOC,STRING)
      ENDIF
      RETURN
      END

C ******
      SUBROUTINE LENSTR_BL(STRING,NL)
C -P- LENSTR_BL - gives length of string.
C -S-
      INTEGER*4 NL
      CHARACTER STRING*(*)
C ******
C -------------------------------------
      N  = LEN(STRING)
      NL = N
      DO 10 I=N,1,-1
        IF(STRING(NL:NL).NE.' ') GO TO 20      
        NL = NL-1
   10 CONTINUE
   20 RETURN
      END



C -P-
C -P------ vector-matrix subroutines --------------------
C -P-

C -I-
      SUBROUTINE NB_VMOD(X,D)
C -P- NB_VMOD - D=!X!  X(3) - vector     
      REAL X(3)
C -I-
      X2 = X(1)*X(1)
      Y2 = X(2)*X(2)
      Z2 = X(3)*X(3)
      D  = SQRT(X2+Y2+Z2)
      RETURN
      END

C -I-
      SUBROUTINE NB_VUNIT(X,Y,IERR)
C -P- NB_VUNIT -  Y=X/!X!    if !X!=0 then Y=(1,0,0) and IERR=1       
      REAL X(3),Y(3)
C -I-
      IERR = 0
      CALL NB_VMOD(X,D)
      IF(D.GT.1.0E-8) THEN
        D    = 1./D
        Y(1) = X(1)*D
        Y(2) = X(2)*D
        Y(3) = X(3)*D
      ELSE
        IERR = 1
        Y(1) = 1.0
        Y(2) = 0.0
        Y(3) = 0.0
      ENDIF
      RETURN
      END

C -I-
      SUBROUTINE NB_VSCAL(X,S,Y)
C -P- NB_VSCALE - Y=S*X  S - coefficient
      REAL X(3),Y(3)
C -I-
      Y(1) = X(1)*S
      Y(2) = X(2)*S
      Y(3) = X(3)*S
      RETURN
      END

C -I-
      SUBROUTINE NB_VADD(X,Y,Z)
C -P- NB_VADD - Z=X+Y
      REAL X(3),Y(3),Z(3)
C -I-
      Z(1) = X(1)+Y(1)
      Z(2) = X(2)+Y(2)
      Z(3) = X(3)+Y(3)
      RETURN
      END

C -I-
      SUBROUTINE NB_VSUB(X,Y,Z)
C -P- NB_VSUB - Z=X-Y
      REAL X(3),Y(3),Z(3)
C -I-
      Z(1) = X(1)-Y(1)
      Z(2) = X(2)-Y(2)
      Z(3) = X(3)-Y(3)
      RETURN
      END

C -I-
      SUBROUTINE NB_VPROD(X,Y,S)
C -P- NB_VPROD - S = (X.Y)  S=X(1)*Y(1)+X(2)*Y(2)+X(3)*Y(3)
      REAL X(3),Y(3)
C -I-
      S = X(1)*Y(1)+X(2)*Y(2)+X(3)*Y(3)
      RETURN
      END

C -I-
      SUBROUTINE NB_VCOPY(X,Y)
C -P- NB_VCOPY - Y <= X
      REAL X(3),Y(3)
C -I-
      Y(1) = X(1)
      Y(2) = X(2)
      Y(3) = X(3)
      RETURN
      END

C -I-
      SUBROUTINE NB_VMULT(X,Y,Z)
C -P- NB_VMULT Z = X*Y    
      REAL X(3),Y(3),Z(3)
C -I-
      VX   = X(2)*Y(3)-X(3)*Y(2)
      VY   = X(3)*Y(1)-X(1)*Y(3)
      Z(3) = X(1)*Y(2)-X(2)*Y(1)
      Z(1) = VX
      Z(2) = VY
      RETURN
      END

C -I-
      SUBROUTINE NB_MCOPY(X,Y)      
      REAL X(9),Y(9)
C -P- NB_MCOPY - [Y] <= [X]
C                             ! 11 12 13 !
C            [Y] =[X]     X = ! 21 22 23 !
C                             ! 31 32 33 !
C -I-
      DO     I=1,9    
        Y(I) = X(I) 
      ENDDO
      RETURN        
      END           

C -I-
      SUBROUTINE NB_MATMLT(X,Y,Z)
      REAL X(3,3),Y(3,3),Z(3,3)
C -P- NB_MATMLT - [Z] =[X] [Y]
C                               ! 11 12 13 !
C           [Z] =[X] [Y]    X = ! 21 22 23 !
C                               ! 31 32 33 !
C -I-
      DO     I=1,3
      DO     J=1,3
        Z(I,J) = 0.0
        DO     K=1,3
          Z(I,J) = Z(I,J)+X(I,K)*Y(K,J)
        ENDDO
      ENDDO
      ENDDO
      RETURN
      END

C ******
C -I-
      SUBROUTINE NB_MVMULT(AM,X,Y)
      REAL X(3),Y(3),AM(3,3)
C -P- NB_MVMULT -  Y =[AM] X
C                             !1!   ! 11 12 13 !    !1!
C           Y =[AM] X       Y !2! = ! 21 22 23 !  X !2!
C                             !3!   ! 31 32 33 !    !3!
C -I-
      Y(1) = AM(1,1)*X(1)+AM(1,2)*X(2)+AM(1,3)*X(3)
      Y(2) = AM(2,1)*X(1)+AM(2,2)*X(2)+AM(2,3)*X(3)
      Y(3) = AM(3,1)*X(1)+AM(3,2)*X(2)+AM(3,3)*X(3)
      RETURN
      END

C -I-
      SUBROUTINE NB_MTRANS(AM,BM)
      REAL AM(3,3),BM(3,3)
C -P- NB_MTRANS - matrix transposition
C           ! 11 21 31 !            ! 11 12 13 !  
C     AM  = ! 12 22 32 !  --> BM =  ! 21 22 33 !
C           ! 13 23 33 !            ! 31 32 33 !    
C     It is posible to use CALL NB_MTRANS(AM,AM)
C -I-
      BM(1,1) = AM(1,1)
      BM(2,2) = AM(2,2)
      BM(3,3) = AM(3,3)
      T       = AM(1,2)
      BM(1,2) = AM(2,1)
      BM(2,1) = T
      T       = AM(1,3)
      BM(1,3) = AM(3,1)
      BM(3,1) = T
      T       = AM(3,2)
      BM(3,2) = AM(2,3)
      BM(2,3) = T
      RETURN
      END

C -I-
      SUBROUTINE NB_INVERT(S,SS,IERR)
C
C -P- NB_INVERT - invertion matrix S(3,3) , result marix SS(3,3)
C
C -------------
      REAL S(3,3),SS(3,3)
      INTEGER IERR
C -I-
C -------------------------------
      IERR=0
      DO    I=1,3
      DO    J=1,3
        SS(I,J) = 0.
      ENDDO
      ENDDO
C
      DET = 0.0

      DO    J=1,3
      DO    I=1,3
        IF(I.EQ.1) THEN
          I1=2
          I2=3
        ELSE IF(I.EQ.2) THEN
          I1=1
          I2=3
        ELSE
          I1=1
          I2=2
        ENDIF
        IF(J.EQ.1) THEN
          J1=2
          J2=3
        ELSE IF(J.EQ.2) THEN
          J1=1
          J2=3
        ELSE
          J1=1
          J2=2
        ENDIF
        SS(I,J) = (-1)**(I+J)*( S(J1,I1)*S(J2,I2)-
     *                          S(J2,I1)*S(J1,I2) )
      ENDDO
      ENDDO

      DET = S(1,1)*SS(1,1)+S(1,2)*SS(2,1)+S(1,3)*SS(3,1)

      IF(ABS(DET).LT.1.0E-30) THEN
        IERR = 1
        DET  = 0.0
      ELSE
        DET = 1./DET
      ENDIF
      DO    I=1,3
      DO    J=1,3
        SS(I,J) = DET*SS(I,J)
      ENDDO
      ENDDO

      RETURN
      END

      SUBROUTINE  NB_EUL2MATR(ALPHA1,ALPHA2,ALPHA3,ROT_TEMP)
C
C---Converts euler angles to rotation matrix
      REAL ROT_TEMP(3,3),ALPHA1,ALPHA2,ALPHA3
C
C---Local variables
      REAL SIN1,COS1,SIN2,COS2,SIN3,COS3

      SIN1 = SIN(ALPHA1)
      SIN2 = SIN(ALPHA2)
      SIN3 = SIN(ALPHA3)

      COS1 = COS(ALPHA1)
      COS2 = COS(ALPHA2)
      COS3 = COS(ALPHA3)
      ROT_TEMP(1,1) =  COS1*COS2*COS3 - SIN1*SIN3
      ROT_TEMP(1,2) = -COS1*COS2*SIN3 - SIN1*COS3
      ROT_TEMP(1,3) =  COS1*SIN2
      ROT_TEMP(2,1) =  SIN1*COS2*COS3 + COS1*SIN3
      ROT_TEMP(2,2) = -SIN1*COS2*SIN3 + COS1*COS3
      ROT_TEMP(2,3) =  SIN1*SIN2
      ROT_TEMP(3,1) = -SIN2*COS3
      ROT_TEMP(3,2) =  SIN2*SIN3
      ROT_TEMP(3,3) =  COS2

      RETURN
      END

C ******
      SUBROUTINE NB_FRORTH(A,B,C,ALPHA,BETA,GAMMA,FRTOCR,CRTOFR,IERR)
C
C -P- FRORTH - calc transformation to orthogonal angstroms from fractional
C -P-          cell FRTOCR and back - CRTOFR 
C
C       ALPHA,BETA,GAMMA - in radian
C
C       orthog axes are defined to have 
C       A parallel to XO   Cstar parallel to ZO 
C
C                                 ! 11 21 31 !
C            Xo=[FRTOCR] Xf    RO=! 12 22 32 !
C                                 ! 13 23 33 !
C
C            Xf=[CRTOFR] Xo
C
      REAL FRTOCR(3,3),CRTOFR(3,3)      
      INTEGER IERR
C ******
      IERR  = 0
C --
      SINA  = SIN(ALPHA)
      COSA  = COS(ALPHA)
      SINB  = SIN(BETA)
      COSB  = COS(BETA)
      SING  = SIN(GAMMA)
      COSG  = COS(GAMMA)
      COSBS = (COSA*COSG-COSB)/(SINA*SING)
      SINBS = SQRT(ABS(1.-COSBS*COSBS))
      COSAS = (COSG*COSB-COSA)/(SINB*SING)
      SINAS = SQRT(ABS(1.-COSAS*COSAS))
      COSGS = (COSA*COSB-COSG)/(SINA*SINB)
      SINGS = SQRT(ABS(1.-COSGS*COSGS))
C
      DO     I=1,3
      DO     J=1,3
        FRTOCR(I,J) = 0.0
      ENDDO
      ENDDO
C
      FRTOCR(1,1) = A
      FRTOCR(1,2) = B*COSG
      FRTOCR(1,3) = C*COSB
      FRTOCR(2,1) = 0.0
      FRTOCR(2,2) = B*SING
      FRTOCR(2,3) =-C*SINB*COSAS
      FRTOCR(3,1) = 0.0
      FRTOCR(3,2) = 0.0
      FRTOCR(3,3) = C*SINB*SINAS
      CALL NB_INVERT(FRTOCR,CRTOFR,IERR)
      RETURN
      END

      SUBROUTINE SET_CIF_TYPES
C ----------------------------------------
      INCLUDE 'atom_com.fh'
C ----------------------------------------
c      PARAMETER (MAXTYPES =  20)
c      PARAMETER (MAXTYPES2 = 40)
c      COMMON /CIF_TYPES/ 
c     *                   N_RES_TYPE,N_STERM_TYPE,N_FTERM_TYPE
c     *                  ,N_CONN_TYPE,N_CH_TYPE
c     *                  ,RES_TYPE,RES_LTYPE
c     *                  ,TERM_S_TYPE,TERM_F_TYPE,CONN_TYPE
c     *                  ,CH_TYPE
c      INTEGER*4 N_RES_TYPE
c      INTEGER*4 N_STERM_TYPE
c      INTEGER*4 N_FTERM_TYPE
c      INTEGER*4 N_CONN_TYPE
c      INTEGER*4 N_CH_TYPE
c      CHARACTER RES_TYPE    (MAXTYPES )*16
c      CHARACTER RES_LTYPE   (MAXTYPES )*8
c      CHARACTER TERM_S_TYPE (MAXTYPES )*8
c      CHARACTER TERM_F_TYPE (MAXTYPES )*8
c      CHARACTER CONN_TYPE   (MAXTYPES2)*8
c      CHARACTER CH_TYPE     (MAXTYPES )*8
C N_RES_TYPE   - number of types of monomers.
C N_STERM_TYPE - number of types of N-terminus.
C N_FTERM_TYPE - number of types of C-terminus.
C N_CONN_TYPE  - number of types of connections.
C RES_TYPE    _ type of each residue: "pept","DNA","RNA,"solv",...
C TERM_S_TYPE - type of terminus of chain: "NH3"
C TERM_F_TYPE - type of terminus of chain: "COO"
C CONN_TYPE   - type of connectivity with previous residue:"CIS","TRNS",...
C -----------

      N_RES_TYPE   = 14
      N_STERM_TYPE = 7
      N_FTERM_TYPE = 7
      N_CONN_TYPE  = 39
      N_CH_TYPE    = 10

      RES_TYPE( 1) =  '.               '
      RES_TYPE( 2) =  'non-polymer     '
      RES_TYPE( 3) =  'L-peptide       '
      RES_TYPE( 4) =  'D-peptide       '
      RES_TYPE( 5) =  'DNA             '
      RES_TYPE( 6) =  'RNA             '
      RES_TYPE( 7) =  'D-pyranose      '
      RES_TYPE( 8) =  'L-pyranose      '
      RES_TYPE( 9) =  'solvent         '
      RES_TYPE(10) =  'polymer         '
      RES_TYPE(11) =  'D-furanose      '
      RES_TYPE(12) =  'L-furanose      '
      RES_TYPE(13) =  'D-saccharide    '
      RES_TYPE(14) =  'L-saccharide    '

      RES_LTYPE( 1) =  '.       '
      RES_LTYPE( 2) =  'non-poly'
      RES_LTYPE( 3) =  'peptide '
      RES_LTYPE( 4) =  'peptide '
      RES_LTYPE( 5) =  'DNA/RNA '
      RES_LTYPE( 6) =  'DNA/RNA '
      RES_LTYPE( 7) =  'pyranose'
      RES_LTYPE( 8) =  'pyranose'
      RES_LTYPE( 9) =  'solvent '
      RES_LTYPE(10) =  'polymer '
      RES_LTYPE(11) =  'furanose'
      RES_LTYPE(12) =  'furanose'
      RES_LTYPE(13) =  'sacchari'
      RES_LTYPE(14) =  'sacchari'

      TERM_S_TYPE( 1) = '.       '
      TERM_S_TYPE( 2) = 'NH3     '
      TERM_S_TYPE( 3) = 'FOR-N   '
      TERM_S_TYPE( 4) = 'p5*END  '
      TERM_S_TYPE( 5) = '5*END   '
      TERM_S_TYPE( 6) = 'NH3-COO '
      TERM_S_TYPE( 7) = 'TERMINUS'
      TERM_S_TYPE( 8) = '        '
      TERM_S_TYPE( 9) = '        '
      TERM_S_TYPE(10) = '        '

      TERM_F_TYPE( 1) = '.       '
      TERM_F_TYPE( 2) = 'COO     '
      TERM_F_TYPE( 3) = 'FOR-C   '
      TERM_F_TYPE( 4) = 'p3*END  '
      TERM_F_TYPE( 5) = '3*END   '
      TERM_F_TYPE( 6) = 'NH3-COO '
      TERM_F_TYPE( 7) = 'TERMINUS'
      TERM_F_TYPE( 8) = 'CM-COO  '
      TERM_F_TYPE( 9) = '        '
      TERM_F_TYPE(10) = '        '

      CONN_TYPE( 1) = '.       '
      CONN_TYPE( 2) = 'TRANS   '
      CONN_TYPE( 3) = 'CIS     '
      CONN_TYPE( 4) = 'p       '
      CONN_TYPE( 5) = 'FOR_C-N '
      CONN_TYPE( 6) = 'FOR_C-C '
      CONN_TYPE( 7) = 'ACE_C-N '
      CONN_TYPE( 8) = 'DFO_C-N '
      CONN_TYPE( 9) = 'NME_N-C '
      CONN_TYPE(10) = 'gap     '
      CONN_TYPE(11) = 'SUGAR   '
      CONN_TYPE(12) = 'BETA1-2 '
      CONN_TYPE(13) = 'BETA1-3 '
      CONN_TYPE(14) = 'BETA1-4 '
      CONN_TYPE(15) = 'BETA1-6 '
      CONN_TYPE(16) = 'ALPHA1-2'
      CONN_TYPE(17) = 'ALPHA1-3'
      CONN_TYPE(18) = 'ALPHA1-4'
      CONN_TYPE(19) = 'ALPHA1-6'
      CONN_TYPE(20) = 'IVA_C-N '
      CONN_TYPE(21) = 'DFO-NME '
      CONN_TYPE(22) = 'BOC_C-N '
      CONN_TYPE(23) = 'DFO_N-C '
      CONN_TYPE(24) = 'STA-NME '
      CONN_TYPE(25) = 'STA_C-N '
      CONN_TYPE(26) = 'STA_N-C '
      CONN_TYPE(27) = 'STA_DFO '
      CONN_TYPE(28) = 'DFO_STA '
      CONN_TYPE(29) = 'STA_STA '
      CONN_TYPE(30) = 'DFO_DFO '
      CONN_TYPE(31) = 'ILG_CD-N'
      CONN_TYPE(32) = 'ILG_CD-p'
      CONN_TYPE(33) = 'LINK_C-N'
      CONN_TYPE(34) = 'LINK_CNp'
      CONN_TYPE(35) = 'LINK_CpN'
      CONN_TYPE(36) = 'PTRANS'
      CONN_TYPE(37) = 'PCIS'
      CONN_TYPE(38) = 'NMTRANS'
      CONN_TYPE(39) = 'NMCIS'

      CH_TYPE( 1) = '.       '
      CH_TYPE( 2) = 'non-poly'
      CH_TYPE( 3) = 'polypept'
      CH_TYPE( 4) = 'polypept'
      CH_TYPE( 5) = 'DNA     '
      CH_TYPE( 6) = 'RNA     '
      CH_TYPE( 7) = 'sacchari'
      CH_TYPE( 8) = 'sacchari'
      CH_TYPE( 9) = 'water   '
      CH_TYPE(10) = 'polymer ' 

C     N_MOD_REC
C     MOD_REC_IRTYPE( )     
C     MOD_REC_DETAIL( )*48
C     MOD_REC_ID    ( )

      N_MOD_REC = 2
  
      MOD_REC_IRTYPE(1) = 5     
      MOD_REC_DETAIL(1) = 'DEL-O2*_' 
      MOD_REC_ID    (1) = 'RNA-O2*'
      MOD_REC_FUNC  (1) = 'DEL'
      MOD_REC_IRTYPE(2) = 3     
      MOD_REC_DETAIL(2) = 'DEL-OXT_' 
      MOD_REC_ID    (2) = 'DEL-OXT'
      MOD_REC_FUNC  (2) = 'DEL'


C BETA1-2  glycosidic_bond_beta1-2  .   DEL-HO2  pyranose .   DEL-O1   pyranose
C BETA1-3  glycosidic_bond_beta1-3  .   DEL-HO3  pyranose .   DEL-O1   pyranose
C BETA2-3  glycosidic_bond_beta1-3  .   DEL-O2   pyranose SIA .        .
C BETA1-4  glycosidic_bond_beta1-4  .   DEL-HO4  pyranose .   DEL-O1   pyranose
C BETA1-6  glycosidic_bond_beta1-6  .   DEL-HO6  pyranose .   DEL-O1   pyranose
C ALPHA1-2 glycosidic_bond_alpha1-2 .   DEL-HO2  pyranose .   DEL-O1   pyranose
C ALPHA1-3 glycosidic_bond_alpha1-3 .   DEL-HO3  pyranose .   DEL-O1   pyranose
C ALPHA2-3 glycosidic_bond_alpha1-3 .   DEL-O2   pyranose SIA .        .
C ALPHA1-4 glycosidic_bond_alpha1-4 .   DEL-HO4  pyranose .   DEL-O1   pyranose
C ALPHA1-6 glycosidic_bond_alpha1-6 .   DEL-HO6  pyranose .   DEL-O1   pyranose
C BETA2-3  glycosidic_bond_beta1-3  .   DEL-O2   pyranose SIA .        .
C ALPHA2-3 glycosidic_bond_alpha1-3 .   DEL-O2   pyranose SIA .        .
C
C MAN-SER  bond_MAN-C1_=_SER-OG     MAN DEL-O1   .        SER .        .
C NAG-SER  bond_NAG-C1_=_SER-OG     NAG DEL-O1   .        SER .        .
C NAG-THR  bond_NAG-C1_=_THR-OG1    NAG DEL-O1   .        THR .        .
C MAN-THR  bond_MAN-C1_=_THR-OG1    MAN DEL-O1   .        THR .        .
C NAG-ASN  bond_NAG-C1_=_ASN-ND2    NAG DEL-O1   .        ASN .        .
C MAN-ASN  bond_MAN-C1_=_ASN-ND2    MAN DEL-O1   .        ASN .        .
C XYS-THR  bond_XYS-C1_=_THR-OG1    XYS XYS-O1   .        THR .        .
C XYS-SER  bond_XYS-C1_=_SER-OG     XYS XYS-O1   .        SER .        .
C XYS-ASN  bond_XYS-C1_=_ASN-ND2    XYS XYS-O1   .        ASN .        .


      RETURN
      END

C ******
      SUBROUTINE SET_ICONN(LINK,ICONN)    
C -----------------------------------------------
C -P-  
C -S-
C -----------------------------------------------
      INTEGER*4 ICONN 
      CHARACTER LINK*8
C ---
      INCLUDE 'atom_com.fh'
C ******
      CHARACTER CHAR8*8
C -----------------------------------
      ICONN = 1
      CHAR8 = LINK
      DO I=1,N_CONN_TYPE
        IF(CHAR8.EQ.CONN_TYPE(I)) THEN
          ICONN = I
          RETURN
        ENDIF
      ENDDO
      RETURN
      END

C ******
      SUBROUTINE SET_ITYPE(TYPE,ITYPE)    
C -----------------------------------------------
C -P-  
C -S-
C -----------------------------------------------
      INTEGER*4 ITYPE 
      CHARACTER TYPE*(*)
C      CHARACTER TYPE*16
C ---
      INCLUDE 'atom_com.fh'
C ******
C -----------------------------------
      ITYPE = 1
      DO I=1,N_RES_TYPE
        CALL LENSTR_BL(TYPE,LT)
        IF(LT.LE.0) LT=1
        IF(TYPE(1:LT).EQ.RES_TYPE(I)(1:LT)) THEN
          ITYPE = I
          RETURN
        ENDIF
      ENDDO
      RETURN
      END
C ******
      SUBROUTINE SET_LTYPE(TYPE,ITYPE)    
C -----------------------------------------------
C -P-  
C -S-
C -----------------------------------------------
      INTEGER*4 ITYPE 
      CHARACTER TYPE*(*)
C      CHARACTER TYPE*8
C ---
      INCLUDE 'atom_com.fh'
C ******
C -----------------------------------
      ITYPE = 1
      DO I=1,N_RES_TYPE
        IF(TYPE.EQ.RES_LTYPE(I)) THEN
          ITYPE = I
          RETURN
        ENDIF
      ENDDO
      CALL SET_ITYPE(TYPE,ITYPE)    
      RETURN
      END
C ******
      SUBROUTINE SET_CH_TYPE(TYPE,ITYPE)    
C -----------------------------------------------
C -P-  
C -S-
C -----------------------------------------------
      INTEGER*4 ITYPE 
      CHARACTER TYPE*8
C ---
      INCLUDE 'atom_com.fh'
C ******
C -----------------------------------
      ITYPE = 1
      DO I=1,N_CH_TYPE
        IF(TYPE.EQ.CH_TYPE(I)) THEN
          ITYPE = I
          RETURN
        ENDIF
      ENDDO
      RETURN
      END

C ******
      SUBROUTINE SET_TERM_S_TYPE(TYPE,ITYPE)    
C -----------------------------------------------
C -P-  
C -S-
C -----------------------------------------------
      INTEGER*4 ITYPE 
      CHARACTER TYPE*8
C ---
      INCLUDE 'atom_com.fh'
C ******
C -----------------------------------
      N_STERM_TYPE = 6
      N_FTERM_TYPE = 6
      ITYPE = 1
      DO I=1,N_STERM_TYPE
        IF(TYPE.EQ.TERM_S_TYPE(I)) THEN
          ITYPE = I
          RETURN
        ENDIF
      ENDDO
      RETURN
      END

      SUBROUTINE SET_TERM_F_TYPE(TYPE,ITYPE)    
C -----------------------------------------------
C -P-  
C -S-
C -----------------------------------------------
      INTEGER*4 ITYPE 
      CHARACTER TYPE*8
C ---
      INCLUDE 'atom_com.fh'
C ******
C -----------------------------------
      ITYPE = 1
      DO I=1,N_FTERM_TYPE
        IF(TYPE.EQ.TERM_F_TYPE(I)) THEN
          ITYPE = I
          RETURN
        ENDIF
      ENDDO
      RETURN
      END

C ******
      SUBROUTINE CHNG_DATE(CH9,CH10)
C -------------------------------------------------------
C -P- CHNG_DATE - 
C -------------------------------------------------------
      CHARACTER CH9*9,CH10*10
C ******
      CHARACTER MONTH(12)*3
      DATA MONTH/'JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP'
     *           ,'OCT','NOV','DEC'/
C ---------------------------------
      IF(CH9(1:1).EQ.'X') THEN
        CH10 = 'XXXX-XX-XX'
        RETURN
      ENDIF
      CH10(1:2) = '19'
      CH10(3:4) = CH9(8:9)
      IF(CH10(3:3).EQ.'0'.OR.CH10(3:3).EQ.'1'.OR.CH10(3:3).EQ.'2') THEN
        CH10(1:2) = '20'
      ENDIF
      CH10(5:5)  = '-'
      CH10(8:8)  = '-'
      CH10(9:10) = CH9(1:2)
      IM         = 0
      DO I=1,12
        IF(CH9(4:6).EQ.MONTH(I)) THEN
          IM = I
          GO TO 100
        ENDIF
      ENDDO
 100  CONTINUE
      IF(IM.LE.0) IM = 1
      WRITE(CH10(6:7),'(I2)') IM
      IF(CH10(6:6).EQ.' ') CH10(6:6) = '0'
      RETURN
      END

C ******
      SUBROUTINE CHNG_DATE_BACK(CH10,CH9)
C -------------------------------------------------------
C -P- CHNG_DATE_BACK - 
C -------------------------------------------------------
      CHARACTER CH9*9,CH10*10
C ******
      CHARACTER MONTH(12)*3
      DATA MONTH/'JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP'
     *           ,'OCT','NOV','DEC'/
C ---------------------------------
      IF(CH10(1:1).EQ.'X') THEN
        CH9 = 'XX-XXX-XX'
        RETURN
      ENDIF
      CH9(8:9) =CH10(3:4)
      CH9(3:3) = '-'
      CH9(7:7) = '-'
      CH9(1:2) = CH10(9:10)
      READ(CH10(6:7),'(I2)') IM
      IF(IM.LE.0)  IM = 1
      IF(IM.GT.12) IM = 12
      CH9(4:6) = MONTH(IM)
      RETURN
      END
C
C ---    subroutines to read CIFile ----
C
C ******
      SUBROUTINE GETCIF_INFO(IUN,MDOC,IERR,IEND)
C -------------------------------------------------------
C -P- GETCIF_INFO - reads the records from file and get information 
C -P-               from records by CIF_style. 
C     Each call of subroutine returns set of loop (or only one) 
C     item_names and corresponding data, also its data_block_name or
C     comment string.
C     Returned information are in common /COMCIF/
C     
C     input:
C           IUN  - log. unit number.
C           MDOC - mode of writing messages to DOC-file. 
C                   0 - only terminal , < 0 only file, 0 < < 99 - both
C                   >= 99 - don't write  
C           IEND - for first call must be equal = -1; for others = 0 
C                  ( or -2 come back after getting comment string)
C
C     output:
C           IEND  =  0  - OK 
C                 =  1  - end of file 
C                 = -2  - OK, comment string was reading, puts comment string
C                             into DT_CIF.
C                                                   
C           IERR  - signal of error. 0 means OK.               
C
C           Returned information are in common /COMCIF/:
C
C                  IEND = 0
C           N_CIF     - number of returned data.
C           ITM_CIF() - array of item_name
C           DT_CIF () - array of data as string of characters.
C           FDT_CIF() - array of data as integer.
C           IDT_CIF() - array of data as real.
C           BLK_CIF   - data_block_name.
C                  IEND = -2
C           DT_CIF(NWORDSMAX) - comment string  
C -----------------------------------------------------------
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMCIF_INFO/ N_CIF,I_CIF,FDT_CIF,IDT_CIF
     *               ,N_DATA,N_ITEM
     *               ,DT_CIF,ITM_CIF,BLK_CIF,LOOP_FLAG,BLK_FLAG
      REAL      FDT_CIF(NWORDSMAX)
      INTEGER*4 IDT_CIF(NWORDSMAX)
      INTEGER*4 N_DATA   
      INTEGER*4 N_ITEM  
      INTEGER*4 N_CIF   
      INTEGER*4 I_CIF
      CHARACTER DT_CIF (NWORDSMAX)*80
      CHARACTER ITM_CIF(NWORDSMAX)*80
      CHARACTER BLK_CIF*80
      CHARACTER LOOP_FLAG*1,BLK_FLAG*1
C ---
      COMMON /COMFREAD_INFO/ FWORDS,IFRD_ERR,NWORDS,LEN_WORDS,IWORDS
     *                 ,WORDS,IN_STRING
      REAL      FWORDS   (NWORDSMAX)
      INTEGER*4 LEN_WORDS(NWORDSMAX)
      INTEGER*4 IWORDS   (NWORDSMAX)
      INTEGER*4 NWORDS,IFRD_ERR
      CHARACTER WORDS(NWORDSMAX)*80
      CHARACTER IN_STRING*1024
      character str_loc*256
C --------------------------------------------------------------
      INTEGER*4 MDOC,IUN,IERR,IEND
C ******
      INTEGER*4 I,II,IFLAG,LEN_IN,LN,LNN
      CHARACTER LINE*256
      logical found
C --------------------------------------------------------------

      IERR = 0
      IF(IEND.EQ.-1) THEN
C       first call
        N_DATA    = 0
        N_CIF     = 0
        N_ITEM    = 0
        I_CIF     = 0
        NWORDS    = 0
        BLK_CIF   = ' '
        BLK_FLAG  = 'N'
        LOOP_FLAG = 'N'
        IEND      = 0
      ELSE IF(IEND.EQ.-2) THEN
C       back after giving comments
        IEND  = 0
        I_CIF = NWORDS
      ELSE
        IEND      = 0
        LOOP_FLAG = 'N'
      ENDIF
C ------------------------------------------------------
  300 CONTINUE

      IF(I_CIF.EQ.NWORDS) THEN

C ===        
C         get one string
C
 200     CALL GETLINE(IUN,MDOC,IN_STRING,IERR,IEND)
C         end of file or reading error
         IF(IERR.NE.0.OR.IEND.NE.0) RETURN
C ===          
         CALL LENSTR_BL(IN_STRING,LEN_IN)

         IF(LEN_IN.GT.1.AND.IN_STRING(1:1).NE.';'.AND.
     *        IN_STRING(1:1).NE.'#'.AND.IN_STRING(1:1).NE.'<') THEN
C     remove comments in the line
            IFLAG = 0
            II1   = 1
            ii2   = 1
            found = .FALSE.
            i = 0
c
c--   IF comment sign is not inside matching primes then remove comments
c--   Note: primes must be matching
            do while (.not.found.and.i.lt.len_in)
               i = i + 1
               if(in_string(i:i).eq.''''.and.ii2.eq.1) then
                  if(ii1.eq.1) then
                     if(i.eq.1) then
                        ii1 = -1
                     else if(in_string(i-1:i-1).eq.' ') then
                        ii1 = -1
                     endif
                  else
                     if(i.eq.len_in) then
                        ii1 = 1
                     else if(in_string(i+1:i+1).eq.' ') then
                        ii1 = 1
                     endif
                  endif
               endif

               if(in_string(i:i).eq.'"'.and.ii1.eq.1) then
                  if(ii2.eq.1) then
                     if(i.eq.1) then
                        ii2 = -1
                     else if(in_string(i-1:i-1).eq.' ') then
                        ii2 = -1
                     endif
                  else
                     if(i.eq.len_in) then
                        ii2 = 1
                     else if(in_string(i+1:i+1).eq.' ') then
                        ii2 = 1
                     endif
                  endif
               endif                     

               if(ii1.eq.1.and.ii2.eq.1) then
                  if(in_string(i:i).eq.'#') found = .TRUE.
               endif
            enddo
            if(ii1.lt.0.or.ii2.lt.0) then
               write(*,*)'ERROR: The line contains unmatched prime'
               write(*,*)'Line :',trim(in_string)
               stop
            endif
            if(found) in_string(i:len_in) = ' '
         endif
C ===        
C         read next line because data block is not open 
         IF(IN_STRING(1:5).NE.'data_'.AND.
     *        IN_STRING(1:7).NE.'global_'.AND.BLK_FLAG.EQ.'N') 
     *        GO TO 200
C ===
         IF(IN_STRING(1:1).EQ.';') THEN
C           text variable started with ;
C
C           only first line with information will be accepted
C           set value looks like  '....'
C
            IFLAG=0
            CALL LENSTR_BL(IN_STRING,LEN_IN)
            LN = LEN_IN
            LINE(2:LN+1)    = IN_STRING(1:LN)
            LINE(1:1)       = ''''
            LINE(2:2)       = ' '
            LINE(LN+2:LN+2) = ''''
            IF(LEN_IN.GT.1) THEN
C             value (text) is ready
               IFLAG=1
            ENDIF
            DO I=1,32000
C
c---  read next line till second ;
               CALL GETLINE(IUN,MDOC,IN_STRING,IERR,IEND)
               IF(IERR.NE.0.OR.IEND.NE.0) RETURN
               CALL LENSTR_BL(IN_STRING,LEN_IN)
               IF(IFLAG.EQ.0) THEN
C---- 
c---- if value is not ready yet
                  CALL LENSTR_BL(IN_STRING,LEN_IN)
                  IF(LEN_IN.GT.1) THEN
                     LINE = IN_STRING
                     LN   = LEN_IN
                     LINE(2:LN+1) = IN_STRING(1:LN)
                     LINE(1:1)    = ''''
                     IF(LINE(2:2).EQ.';') LINE(2:2) = ' '
                     LINE(LN+2:LN+2) = ''''
                     IFLAG           = 1
C
c---- value (text) is ready
                  ENDIF
               ENDIF
               IF(IN_STRING(1:1).EQ.';') GO TO 100
            ENDDO
 100        CONTINUE
            LNN=LN+2
            IF(LNN.GT.3) THEN
               LN    = 0
               IFLAG = 0
               DO I=2,LNN-1
C     remove forward blancs
                  IF(LINE(I:I).EQ.' '.AND.IFLAG.EQ.0) THEN
                     
                  ELSE
                     IFLAG       = 1
                     LN          = LN + 1
                     LINE(LN:LN) = LINE(I:I)
                  ENDIF
                  
               ENDDO
            ENDIF
            LN          = LN + 1
            LINE(LN:LN) = ''''
            IN_STRING   = LINE(1:LN)
         ENDIF
C ===
         CALL FRD_PARM_INFO
         IF(IFRD_ERR.NE.0) THEN
            CALL MSGERR(MDOC
     *      ,' WARNING: CIF_read: number of words > limit')
         ENDIF
         IF(NWORDS.LE.0) GO TO 200
         if(words(1)(1:1).eq.'#'.or.words(1)(1:1).eq.'<') then
            len_in = len_trim(in_string)
            ll = len_in
c            ll = min(ll,79)
            dt_cif(nwordsmax) = in_string(1:ll)
            iend = -2
            nwords = i_cif
            return
         endif
         I_CIF = 0
      ENDIF      

      I_CIF = I_CIF + 1
      IF((WORDS(I_CIF)(1:5).EQ.'data_'  ).OR. 
     *      (WORDS(I_CIF)(1:7).EQ.'global_')) THEN
C
C         first or next block data
C
         BLK_CIF=WORDS(I_CIF)(1:LEN_WORDS(I_CIF))
         IF(N_DATA.NE.0) THEN
            CALL MSGERR(MDOC
     *           ,' ERR: CIF_read: number of data > number of items')
            WRITE(LINE,'(''       last items :<'',A,''>'')') 
     *           ITM_CIF(N_DATA)(1:16)
            CALL MSGERR(MDOC,LINE)
         ENDIF
         N_DATA    = 0
         N_ITEM    = 0
         LOOP_FLAG = 'N' 
         BLK_FLAG  = 'Y'
         IF(WORDS(I_CIF)(1:5).EQ.'data_'  ) THEN 
            NWORDS = 0
            I_CIF  = 0
            N_CIF  = 0
            RETURN
         ENDIF
      ELSE IF(BLK_FLAG.EQ.'Y') THEN
C
C         block data was started
C       
         IF(WORDS(I_CIF)(1:5).EQ.'loop_'  ) THEN 
C
C         loop
C       
            IF(N_DATA.NE.0) THEN
               CALL MSGERR(MDOC,
     *              ' ERR: CIF_read: number of data > number of items')
               WRITE(LINE,'(''       last items :<'',A,''>'')') 
     *                ITM_CIF(N_DATA)(1:16)
               CALL MSGERR(MDOC,LINE)
            ENDIF
            LOOP_FLAG = 'Y'
            N_DATA    = 0
            N_ITEM    = 0

         ELSE IF(WORDS(I_CIF)(1:1).EQ.'_'  ) THEN 
C
C           item
C
            IF(LOOP_FLAG.EQ.'N') N_ITEM=0
            IF(N_DATA.NE.0) THEN
               CALL MSGERR(MDOC
     *            ,' ERR: CIF_read: number of data > number of items')
               WRITE(LINE,'(''       last items :<'',A,''>'')') 
     *                ITM_CIF(N_DATA)(1:16)
               CALL MSGERR(MDOC,LINE)
            ENDIF
            N_DATA = 0        
            N_ITEM = N_ITEM+1
            IF(N_ITEM.GT.NWORDSMAX) THEN
               WRITE(LINE,'(A,I5)')
     *         ' ERR: CIF_read: too many items in the loop >',NWORDSMAX
               CALL MSGERR(MDOC,LINE)
            ENDIF
            ITM_CIF(N_ITEM)=WORDS(I_CIF) (1:LEN_WORDS(I_CIF))
         ELSE
C
C           data
C
            IF(N_ITEM.LE.0) THEN
               CALL MSGERR(MDOC
     *       ,' ERR: CIF_read: number of items =0 / before the data /')
               CALL MSGERR(MDOC,IN_STRING)
            ENDIF
            LOOP_FLAG      = 'N'
            N_DATA         = N_DATA + 1
            N_CIF          = N_DATA
            str_loc = words(i_cif)
            call remove_matching_primes(str_loc)
            DT_CIF(N_CIF)  = trim(str_loc)
            IDT_CIF(N_CIF) = IWORDS(I_CIF)
            FDT_CIF(N_CIF) = FWORDS(I_CIF)
            IF(N_DATA.EQ.N_ITEM) THEN
               N_DATA = 0
               RETURN
            ENDIF
         ENDIF

      ELSE
         I_CIF = NWORDS
      ENDIF   
      
      GO TO 300
C     -------------------------
      END

C ******
      SUBROUTINE FRD_PARM_INFO
      implicit none
C -------------------------------------------------------
C -P- FRD_PARM_INFO  - free format reading of the string of characters.
C                      See common /COMFREAD_INFO/
C
C     input:     IN_STRING - input string; a word is the part of the string
C                            between two blancs or two "'".
C     output:    NWORDS    - number of words of the string
C                IWORDS    - array of integer value of each word.
C                FWORDS    - array of real value of each word.
C                WORDS     - array of words
C                LEN_WORDS - array of lengths of the words
C                IFRD_ERR  - signal of error. 
C                            0  means OK.
C                            1 - number of words > NWORDSMAX = 60
C -S-
C -----------------------------------------------------------
      integer nwordsmax
      PARAMETER ( NWORDSMAX = 60 )
      COMMON /COMFREAD_INFO/ 
     *                  FWORDS,IFRD_ERR,NWORDS,LEN_WORDS,IWORDS
     *                 ,WORDS,IN_STRING
      REAL      FWORDS   (NWORDSMAX)
      INTEGER*4 LEN_WORDS(NWORDSMAX)
      INTEGER*4 IWORDS   (NWORDSMAX)
      INTEGER*4 NWORDS,IFRD_ERR
      CHARACTER WORDS(NWORDSMAX)*80
      CHARACTER IN_STRING*1024
C --------------------------------------------------------------
C ******
c
      integer i,ii1p,ii2p,iword,l,ip,iw
      integer nmax_words
      parameter (nmax_words = 200)
      integer ibegin(nmax_words),iend(nmax_words)

      integer ia
      REAL      FA
      CHARACTER CH*1
cSTR_loc*256
      logical started
C --------------------------------------------------------------
      IFRD_ERR = 0
      NWORDS   = 0
c      q1_open = .FALSE.
c      q2_open = .FALSE.
      CALL LENSTR_BL(IN_STRING,l)
      IF(l.LE.0) RETURN
C      IF(LEN.GT.80) LEN=80
C -----------------
      IP = 0
      ii1p = 1
      ii2p = 1
c
c---  divide into words. Seperater is a space not contained inside matching primes

      iword = 0
      started = .FALSE.

      do ip=1,l
         ch = in_string(ip:ip)
c
c---Prime in the beginning of a string
         if(ip.eq.1.and.ch.eq.'''') then
            ii1p = -1
         elseif(ip.gt.1.and.in_string(ip-1:ip-1).eq.' '.and.
     &           ch.eq.''''.and.ii2p.eq.1.and.ii1p.eq.1) then
            ii1p = -1
         endif
c
c---  Prime at the end of a string
         if(ip.eq.l.and.ch.eq.''''.and.ii1p.eq.-1) then
            ii1p = 1
         else if(ip.lt.l.and.ch.eq.''''.and.
     &           in_string(ip+1:ip+1).eq.' '.and.ii1p.eq.-1) then
            ii1p = 1
         endif
c
c---  Double prime in the beginning of a string
         if(ip.eq.1.and.ch.eq.'"') then
            ii2p = -1
         elseif(ip.gt.1.and.in_string(ip-1:ip-1).eq.' '.and.
     &           ch.eq.'"'.and.ii2p.eq.1.and.ii1p.eq.1) then
            ii2p = -1
         endif
         if(ip.eq.l.and.ch.eq.'"'.and.ii2p.eq.-1) then
            ii2p = 1
         else if(ip.lt.l.and.ch.eq.'"'.and.
     &           in_string(ip+1:ip+1).eq.' '.and.ii2p.eq.-1) then
            ii2p = 1
         endif


c         if(ch.eq.''''.and.ii2p.eq.1) ii1p = -ii1p
c         if(ch.eq.'"'.and.ii1p.eq.1) ii2p = -ii2p
         if(ch.ne.' '.and..not.started) then
            iword = iword + 1
            if(iword.gt.nwordsmax) then
               nwords = iword
               ifrd_err = 1
               return
            endif
            ibegin(iword) = ip
            started = .TRUE.
         endif

         if(ch.eq.' '.and.started.and.ii1p.eq.1.and.ii2p.eq.1) then
            iend(iword) = ip-1
            started = .FALSE.
         endif
      enddo
      if(started) then
         iend(iword) = l
         started = .FALSE.
      endif
      nwords = iword

      do iw=1,nwords
c         str_loc = in_string(ibegin(iw):iend(iw))
c         l = len_trim(str_loc)
c
c---  This should be done outside?
c         call remove_matching_primes(str_loc)

         words(iw) = trim(in_string(ibegin(iw):iend(iw)))
         len_words(iw) = len_trim(words(iw))
         call wtodig(words(iw),len_words(iw),fa,ia)
         iwords(iw) = ia
         fwords(iw) = fa
      enddo
C -----------------
 100  CONTINUE
      RETURN
      END      
c
      subroutine remove_matching_primes(word_in)
      implicit none
      character word_in*(*)
c
c---  If a string has matching primes in the beginning and end then they
c---  are removed
      integer i,l

      
      l = len_trim(word_in)
c
c?????????????
      if(l.le.0) word_in = '?'
      if(word_in(1:1).eq.''''.and.word_in(l:l).eq.'''') then
         word_in(1:1) = ' '
         word_in(l:l) = ' '
         do i=1,l-1
            word_in(i:i) = word_in(i+1:i+1)
         enddo
         if(len_trim(word_in).le.0) word_in = '?'
      elseif(word_in(1:1).eq.'"'.and.word_in(l:l).eq.'"') then
         word_in(1:1) = ' '
         word_in(l:l) = ' '
         do i=1,l-1
            word_in(i:i) = word_in(i+1:i+1)
         enddo
         if(len_trim(word_in).le.0) word_in = '?'
      endif

      return
      end
      
C ******
      SUBROUTINE GETLINE(IUN,MDOC,STR,IERR,IEND)
C -----------------------------------------------
C -P- GETLINE - reads one record of file to string STR .
c               Replaces unreadable character with spaces
C               If lenght of STR = 0  set STR(1:1)=' '.
C      input:
C         IUN  - logical unit_number.
C         MDOC - mode of writting messages to DOC-file /See subr. OPENDOC/
C                0 - only terminal , < - 0 only file, 0 < < 99 - both
C                >= 99 - don't write  
C      output:
C         STR  - output string
C         IERR - "1" means read_error,  "0" - OK.
C         IEND - "1" means end-of-file, "0" - STR was reading.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IUN,IERR,IEND
      CHARACTER STR*(*)
C ******
C -----------------------------------------------
      INTEGER*4 NL
      CHARACTER CH1*1,CHAR1*1,LINE*1024
C -----------------------------------------------
      IERR = 0
      IEND = 0
      READ(IUN,'(A)',ERR=1000,END=1010) LINE
      CALL LENSTR_BL(LINE,LN)
      if(ln.le.0) return
      do i=1,ln
        char1 = line(i:i)
        call chksmb(char1,ch1)
        if(ch1.eq.'?') line(i:i) = ' '
      enddo
      NL=LEN(STR)
      if(nl.le.0) then
         write(*,*)'ERROR in the input parameter str: GETLINE'
         stop
      endif
      str = line
c
c--Compress input line and remove redundant spaces
c      str = ' '
c      if(ln.le.0) return
c      isp = 0
c      il = 0
c      do i=1,ln
c         if(line(i:i).eq.' ') isp = isp + 1
c         if(line(i:i).ne.' ') isp = 0
c         if(isp.le.1) then
c            il = il + 1
c            if(il.gt.nl) then
c               write(*,*)
c     &              'ERROR: Input line is longer than tr: GETLINE'
c               stop
c            endif
c            str(il:il) = line(i:i)
c         endif
c      enddo
      RETURN
C ----------------------------------
 1000 CALL MSGDOC(MDOC,' ERROR: read error.')     
      IERR=1
      RETURN
 1010 IEND=1
      RETURN
C -----------------------------------
      END     

C ================================================================


C ============================================================
C --- BLGRAPH ---
C
      SUBROUTINE MOVTXX(IX,IY)
      COMMON /COMORG/ ITYPE,SLEN,IXORG,IYORG
C -----------------------------------------
      IXORG = IX/10.0
      IYORG = IY/10.0
      SLEN  = 0.0
      X     = IX/10.0
      Y     = IY/10.0
      CALL MOVTX(X,Y)
      RETURN
      END

      SUBROUTINE VECTXX(IX,IY)
      COMMON /COMORG/ ITYPE,SLEN,IXORG,IYORG
CN    DATA DLEN/ 7.0 /
CVX   DATA DLEN/ 7.0 /
CMS   DATA DLEN/ 1.0 /
      DATA DLEN/ 2.0 /
C -------------------------------------------
      X = IX/10.0
      Y = IY/10.0
      IF(ITYPE.EQ.0) THEN
        CALL VECTX(X,Y)
      ELSE
        XORG = IXORG
        YORG = IYORG
        ALLL = (XORG-X)*(XORG-X) + (YORG-Y)*(YORG-Y)
        ALLL = SQRT(ABS(ALLL))
        IF(ALLL.GT.0.0) THEN     
          STOT = SLEN+ALLL
          N2   = STOT/DLEN
          AN2  = STOT-N2*DLEN
          IF(AN2.GT.0.0) THEN
            N2 = N2 + 1
          ELSE
            AN2 = DLEN
          ENDIF
          N1  = SLEN/DLEN
          AN1 = SLEN-N1*DLEN
          N1  = N1 + 1
          IF(N1.EQ.N2) AN2 = AN2-AN1
          COSA = (X-XORG)/ALLL
          SINA = (Y-YORG)/ALLL
          IF(N2.GE.N1) THEN
            DO I=N1,N2
              IF(I.EQ.N1.AND.I.NE.N2) THEN
                D   = DLEN-AN1
                SX  = D*COSA
                SY  = D*SINA
              ELSE IF(I.EQ.N2) THEN
                D   = AN2
                SX  = D*COSA
                SY  = D*SINA
              ELSE
                SX  = DLEN*COSA
                SY  = DLEN*SINA
              ENDIF
              X     = XORG+SX
              Y     = YORG+SY
              XORG  = X
              YORG  = Y
              IXORG = IXORG
              IYORG = IYORG
              IF(MOD(I,2).EQ.1) THEN
                CALL VECTX(X,Y)
              ELSE
                CALL MOVTX(X,Y)
              ENDIF
            ENDDO
          ENDIF
          SLEN = STOT
        ENDIF
      ENDIF
      RETURN
      END


      SUBROUTINE SET_BOX_TX(IBX,IBY,ISHXI,ISHYI)
C ---
      COMMON /TX_BOX/ IBOXX,IBOXY,ISHX,ISHY
      INTEGER IBOXX,IBOXY,ISHX,ISHY
C ----
      COMMON/TX_ORIG/  IXO,IYO,IX0,IY0,XO,YO
C ----
      COMMON /TX_SLCT/   IPAGE
      INTEGER            IPAGE
C
      COMMON /PS_BOX/ BBOXX1,BBOXX2,BBOXY1,BBOXY2
      INTEGER  BBOXX1,BBOXX2,BBOXY1,BBOXY2
C -------------------------------
C     ISHX >= BOXY1
C     IBOXX + ISHX =< BOXY2
C     ISHY >= BOXY1
C     IBOXY + ISHY =< BOXX2
C

      LIM_XMIN = BBOXY1
      LIM_XMAX = BBOXY2
      LIM_YMIN = BBOXX1
      LIM_YMAX = BBOXX2

      ISHX  = ISHXI
      ISHY  = ISHYI
      ITX = LIM_XMAX-LIM_XMIN
      IF(ISHX.GT.ITX) ISHX = ITX
      ITY = LIM_YMAX-LIM_YMIN
      IF(ISHY.GT.ITY) ISHY = ITY
      IF(ISHX.LT.0) ISHX = 0
      IF(ISHY.LT.0) ISHY = 0
      IBOXX    = IBX
      IBOXY    = IBY
      IF((IBOXX+ISHX).GT.ITX) IBOXX = ITX-ISHX
      IF((IBOXY+ISHY).GT.ITY) IBOXY = ITY-ISHY
      IF(IBOXX.LT.0) IBOXX = 0
      IF(IBOXY.LT.0) IBOXY = 0

      RETURN
      END

      SUBROUTINE GET_BOX_TX(IBX,IBY,ISHX_PS,ISHY_PS,IX0_PS,IY0_PS
     *   ,LIM_XMIN,LIM_XMAX,LIM_YMIN,LIM_YMAX)
C ---
      COMMON /TX_BOX/ IBOXX,IBOXY,ISHX,ISHY
      INTEGER IBOXX,IBOXY,ISHX,ISHY
C ----
      COMMON/TX_ORIG/  IXO,IYO,IX0,IY0,XO,YO
C ----
      COMMON /TX_SLCT/   IPAGE
      INTEGER            IPAGE
C
      COMMON /PS_BOX/ BBOXX1,BBOXX2,BBOXY1,BBOXY2
      INTEGER  BBOXX1,BBOXX2,BBOXY1,BBOXY2
C -------------------------------

C      BBOXX1 =  30
C      BBOXX2 = 550
C      BBOXY1 =  50
C      BBOXY2 = 780

      LIM_XMIN = BBOXY1
      LIM_XMAX = BBOXY2
      LIM_YMIN = BBOXX1
      LIM_YMAX = BBOXX2


      IBX      = IBOXX
      IBY      = IBOXY
      ISHX_PS  = ISHX
      ISHY_PS  = ISHY
      IX0_PS   = IX0
      IY0_PS   = IY0

C     ISHX >= BOXY1
C     IBOXX + ISHX =< BOXY2
C     ISHY >= BOXY1
C     IBOXY + ISHY =< BOXX2
C
      RETURN
      END

      SUBROUTINE OPENTX(NAME,NPAGE,IERR)
C ----
      COMMON /TX_BOX/ IBOXX,IBOXY,ISHX,ISHY
      INTEGER IBOXX,IBOXY,ISHX,ISHY
C ----
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS
C --------------------------------                 
      CHARACTER       NAME*(*)
C ---------------------------------------------------
      PARAMETER ( MXCOLR = 19 )
      CHARACTER*12 COLNAM(MXCOLR)
      REAL         RGB(3,MXCOLR)
      INTEGER      NPAGE
C     INTEGER      PLTYPE, COLPLT(3,13)
      CHARACTER    FILPS*256
C ----------------
      COMMON /PS_BOX/ BBOXX1,BBOXX2,BBOXY1,BBOXY2
      INTEGER  BBOXX1,BBOXX2,BBOXY1,BBOXY2
C ---------------------------------------
      INTEGER   IERR
      CHARACTER LINE*80
C -------------------------------
      INCLUDE 'crd_com.fh'
C -------------------------------
      IERR   =  0
C     M      = 99
      MDOC   = 0
      IUN_PS = CRPS_IUN        

      CALL INIT_TX_PAR(RGB,COLNAM)

      CALL PSSETPG(NPAGE)

      FILPS = NAME

      CALL LENSTR_BL(FILPS,LN)
      IF(LN.LE.0.OR.FILPS(1:1).EQ.' '.OR.FILPS(1:1).EQ.',') THEN
        WRITE(LINE,*) ' ERROR: wrong name of ps_file'  
        CALL MSGERR(MDOC,LINE)
        IERR=1
        GO TO 100
      ENDIF

      LLN = LN
      IF(LLN.GT.67) LLN = 67
      IF(LLN.LT. 1) LLN = 1
      WRITE(LINE,'(''* Plotfile: '',A)') FILPS(1:LLN)
      CALL MSGDOC(MDOC,LINE)

C  --- Open and Initialize the PostScript file
      CALL PSOPEN (FILPS,BBOXX1,BBOXX2,BBOXY1,BBOXY2,MXCOLR,
     +     RGB,.FALSE.,1,IERR)
      IF(IERR.NE.0) GO TO 100
      CRPS_IUN = IUN_PS      
      IOPEN=1
 100  CONTINUE
      RETURN
      END
 
      SUBROUTINE NEWPEN(IPEN)
      COMMON /TX_SLCT/ IPAGE
      INTEGER   IPAGE
      INTEGER IPEN
C --------------------------------------------------
      RETURN
      END
 
      SUBROUTINE NEWPG
C ----------------------------------------------------
      COMMON /TX_SLCT/ IPAGE
      INTEGER          IPAGE
C ---------------------------------------------
      COMMON /PS_BOX/ BBOXX1,BBOXX2,BBOXY1,BBOXY2
      INTEGER  BBOXX1,BBOXX2,BBOXY1,BBOXY2
C ---
C      REAL*4 YL, XCENTR
C ----------------------------------------------------
      CALL PSNWPAG(BBOXX1,BBOXX2,BBOXY1,BBOXY2,.FALSE.)

      IPAGE=IPAGE+1

      RETURN
      END
 
      SUBROUTINE PNTTX(IX,IY)
      X = IX/10.0
      Y = IY/10.0
      CALL MOVTX(X,Y)
      CALL VECTX(X,Y)
      END
 
      SUBROUTINE MOVTX(X,Y)
C ---
      COMMON/TX_ORIG/ IXO,IYO,IX0,IY0,XO,YO
C -----------------------------------------

      XO = X
      YO = Y

      RETURN
      END
 
      SUBROUTINE VECTX(X,Y)
C ---
      COMMON /TX_BOX/ IBOXX,IBOXY,ISHX,ISHY
      INTEGER         IBOXX,IBOXY,ISHX,ISHY
C ----
      COMMON/TX_ORIG/  IXO,IYO,IX0,IY0,XO,YO
C ----
      COMMON /TX_SLCT/ IPAGE
      INTEGER          IPAGE
C ----------------
      COMMON /PS_BOX/ BBOXX1,BBOXX2,BBOXY1,BBOXY2
      INTEGER         BBOXX1,BBOXX2,BBOXY1,BBOXY2
C ---------------------------------------
      CALL MOVTX(XO,YO)

      XT = X+IX0
      YT = Y+IY0

      FBOXX = IBOXX
      FBOXY = IBOXY 

      IF(XT.LT.0.0  ) XT = 0.0
      IF(YT.LT.0.0  ) YT = 0.0
      IF(XT.GT.FBOXY) XT = FBOXY
      IF(YT.GT.FBOXX) YT = FBOXX

      XT = XT+ISHX
      YT = YT+ISHY

      FBOXX1 = BBOXX1
      FBOXX2 = BBOXX2
      FBOXY1 = BBOXY1
      FBOXY2 = BBOXY2

      XTT = YT+FBOXX1
      YTT = FBOXY2-XT

      IF(XTT.LT.FBOXX1) XTT = FBOXX1
      IF(YTT.LT.FBOXY1) YTT = FBOXY1
      IF(XTT.GT.FBOXX2) XTT = FBOXX2
      IF(YTT.GT.FBOXY2) YTT = FBOXY2

      X2 = XTT
      Y2 = YTT

      XT = XO+IX0
      YT = YO+IY0
 
      IF(XT.LT.0.0  ) XT = 0.0
      IF(YT.LT.0.0  ) YT = 0.0
      IF(XT.GT.FBOXY) XT = FBOXY
      IF(YT.GT.FBOXX) YT = FBOXX

      XT = XT+ISHX
      YT = YT+ISHY

      XTT = YT+FBOXX1
      YTT = FBOXY2-XT

      IF(XTT.LT.FBOXX1) XTT = FBOXX1
      IF(YTT.LT.FBOXY1) YTT = FBOXY1
      IF(XTT.GT.FBOXX2) XTT = FBOXX2
      IF(YTT.GT.FBOXY2) YTT = FBOXY2

      X1 = XTT
      Y1 = YTT


      IF(ABS(X1).GT.999.0) X1 = 1.0
      IF(ABS(X2).GT.999.0) X2 = 1.0
      IF(ABS(Y1).GT.999.0) Y1 = 1.0
      IF(ABS(Y2).GT.999.0) Y2 = 1.0

      CALL PSLINE (X1, Y1, X2, Y2)

      XO = X
      YO = Y 
 
      RETURN
C ---------------
      ENTRY  ORITX(IX,IY)
      IX0 = IX
      IY0 = IY
      RETURN
      END

      SUBROUTINE ENDTX
C ------------------------------------
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS
C ------------------------------------
C ----------------
      COMMON /PS_BOX/ BBOXX1,BBOXX2,BBOXY1,BBOXY2
      INTEGER  BBOXX1,BBOXX2,BBOXY1,BBOXY2
C ---------------------------------------

C  --- Write out end of PostScript file
      CALL PSCLOS(BBOXX1,BBOXX2,BBOXY1,BBOXY2)

      IOPEN = 0
      RETURN
      END

      SUBROUTINE TXSYMB (SYM,ISIZEX,IX,IY,IMOD)
C -----------------------------------------
      CHARACTER SYM *(*)
C ---- IMOD = 1 absolute coord. system
C --------------------------
      CALL GET_BOX_TX(IBX,IBY,ISHX,ISHY,IX0_PS,IY0_PS
     *   ,LIM_XMIN,LIM_XMAX,LIM_YMIN,LIM_YMAX)

      IF(IMOD.LE.0) THEN

        IXT = IX+IX0_PS
        IYT = IY+IY0_PS

        IF(IXT.LT.0  ) IXT = 0
        IF(IYT.LT.0  ) IYT = 0
        IF(IXT.GT.IBX) IXT = IBX
        IF(IYT.GT.IBY) IYT = IBY

        IXT = IXT+ISHX
        IYT = IYT+ISHY


C      LIM_XMIN=BBOXY1
C      LIM_XMAX=BBOXY2
C      LIM_YMIN=BBOXX1
C      LIM_YMAX=BBOXX2
C        IXTT=IYT+BBOXX1
C        IYTT=BBOXY2-IXT
C      IF(IXTT.LT.BBOXX1) IXTT=BBOXX1
C      IF(IYTT.LT.BBOXY1) IYTT=BBOXY1
C      IF(IXTT.GT.BBOXX2) IXTT=BBOXX2
C      IF(IYTT.GT.BBOXY2) IYTT=BBOXY2

        IXTT = IYT+LIM_YMIN
        IYTT = LIM_XMAX-IXT

        IF(IXTT.LT.LIM_YMIN) IXTT = LIM_YMIN
        IF(IYTT.LT.LIM_XMIN) IYTT = LIM_XMIN
        IF(IXTT.GT.LIM_YMAX) IXTT = LIM_YMAX
        IF(IYTT.GT.LIM_XMAX) IYTT = LIM_XMAX

        XL = IXTT
        YL = IYTT

      ELSE
C
C       LIM_XMIN=BBOXY1 50
C       LIM_XMAX=BBOXY2 780

C       LIM_YMIN=BBOXX1 30
C       LIM_YMAX=BBOXX2 550
C       IBX = 650
C       IBY = 500
C       ISHX_PS  = 80
C       ISHY_PS  = 50
C
        IXTT = IX
        IYTT = IY

        IXT = IYTT+LIM_YMIN
        IYT = LIM_XMAX-IXTT

        IF(IXT.LT.LIM_YMIN) IXT = LIM_YMIN
        IF(IYT.LT.LIM_XMIN) IYT = LIM_XMIN
        IF(IXT.GT.LIM_YMAX) IXT = LIM_YMAX
        IF(IYT.GT.LIM_XMAX) IYT = LIM_XMAX

        XL = IXT
        YL = IYT

      ENDIF

      SIZE = ISIZEX
      CALL PSTEXT(XL,YL,SIZE,SYM)
      RETURN
      END

      SUBROUTINE TXTEXT(SYM,ISIZEX,IX,IY,IMOD)
C -----------------------------------------
      CHARACTER SYM *(*)
C ---- IMOD = 1 absolute coord. system
C --------------------------
      CALL GET_BOX_TX(IBX,IBY,ISHX,ISHY,IX0_PS,IY0_PS
     *   ,LIM_XMIN,LIM_XMAX,LIM_YMIN,LIM_YMAX)

      IF(IMOD.LE.0) THEN

        IXT = IX+IX0_PS
        IYT = IY+IY0_PS

        IF(IXT.LT.0  ) IXT = 0
        IF(IYT.LT.0  ) IYT = 0
        IF(IXT.GT.IBX) IXT = IBX
        IF(IYT.GT.IBY) IYT = IBY

        IXT = IXT+ISHX
        IYT = IYT+ISHY


C      LIM_XMIN=BBOXY1
C      LIM_XMAX=BBOXY2
C      LIM_YMIN=BBOXX1
C      LIM_YMAX=BBOXX2
C        IXTT=IYT+BBOXX1
C        IYTT=BBOXY2-IXT
C      IF(IXTT.LT.BBOXX1) IXTT=BBOXX1
C      IF(IYTT.LT.BBOXY1) IYTT=BBOXY1
C      IF(IXTT.GT.BBOXX2) IXTT=BBOXX2
C      IF(IYTT.GT.BBOXY2) IYTT=BBOXY2

        IXTT = IYT+LIM_YMIN
        IYTT = LIM_XMAX-IXT

        IF(IXTT.LT.LIM_YMIN) IXTT = LIM_YMIN
        IF(IYTT.LT.LIM_XMIN) IYTT = LIM_XMIN
        IF(IXTT.GT.LIM_YMAX) IXTT = LIM_YMAX
        IF(IYTT.GT.LIM_XMAX) IYTT = LIM_XMAX

        XL=IXTT
        YL=IYTT

      ELSE
C
C       LIM_XMIN=BBOXY1 50
C       LIM_XMAX=BBOXY2 780

C       LIM_YMIN=BBOXX1 30
C       LIM_YMAX=BBOXX2 550
C       IBX = 650
C       IBY = 500
C       ISHX_PS  = 80
C       ISHY_PS  = 50
C
        IXTT = IX
        IYTT = IY

        IXT = IYTT+LIM_YMIN
        IYT = LIM_XMAX-IXTT

        IF(IXT.LT.LIM_YMIN) IXT = LIM_YMIN
        IF(IYT.LT.LIM_XMIN) IYT = LIM_XMIN
        IF(IXT.GT.LIM_YMAX) IXT = LIM_YMAX
        IF(IYT.GT.LIM_XMAX) IYT = LIM_XMAX

        XL = IXT
        YL = IYT

      ENDIF

      SIZE = ISIZEX
      IF(SIZE.LT.0.0.OR.SIZE.GT.99.9) SIZE = 1.0
      CALL PSPRINT(XL,YL,SIZE,SYM)

      RETURN
      END

      SUBROUTINE PSPRINT(X,Y,SIZE,TEXT)
C ---------------------------------------
      COMMON /COM_PS/ IOPEN,IUN_PS
C ----
      COMMON /PS_BOX/ BBOXX1,BBOXX2,BBOXY1,BBOXY2
      INTEGER  BBOXX1,BBOXX2,BBOXY1,BBOXY2
C ---------------------------------------
      CHARACTER TEXT*(*)
      CHARACTER CH*1,FLAGB*1,SYMB*1,STR*80
      REAL          SIZE,X,Y,XX,YY
      INTEGER       N,LEN,I
C --------------------------------------------
      COEF  = 0.72
      YY    = Y-SIZE/4.0
      XX    = X
      FLAGB = 'N'
      STR   = ' '
      N     = 0
      CALL LENSTR_BL(TEXT,LEN)
      IF(LEN.LE.0) RETURN
      IF(LEN.GT.78) LEN = 78
      LEN = LEN+1

      DO I=1,LEN
        IF(I.LT.LEN) THEN
          CH=TEXT(I:I)
          CALL CHKSMB(CH,SYMB)
          IF(SYMB.EQ.'?') CH = '^'
          IF(CH  .EQ.'(') CH = '{'
          IF(CH  .EQ.')') CH = '}'
        ELSE
          CH = ' '
        ENDIF
        IF(CH.EQ.' '.AND.FLAGB.EQ.'N') THEN
          IF(XX.GT.BBOXX2) XX=BBOXX2          
          WRITE(IUN_PS,'(2F7.2,'' moveto'')') XX,YY
          IF(N.GT.0) THEN
            WRITE(IUN_PS,'(''('',A,'')'')') STR(1:N)
            WRITE(IUN_PS,'(F4.1,'' Print'')') SIZE
            XX = XX+SIZE*N*COEF
            N  = 0
          ENDIF
        ENDIF
        IF(CH.NE.' ') THEN
          N        = N+1        
          STR(N:N) = CH
          FLAGB    = 'N'  
        ELSE
          FLAGB = 'Y'  
          XX    = XX+SIZE*COEF
        ENDIF
      ENDDO
      RETURN
      END

      SUBROUTINE PSPRINTS(X,Y,SIZE,TEXT)
C ---------------------------------------
      COMMON /COM_PS/ IOPEN,IUN_PS
C ---
      COMMON /PS_BOX/ BBOXX1,BBOXX2,BBOXY1,BBOXY2
      INTEGER  BBOXX1,BBOXX2,BBOXY1,BBOXY2
C ---------------------------------------
      CHARACTER TEXT*(*)
      CHARACTER CH*1,FLAGB*1,SYMB*1,STR*80
      REAL          SIZE,X,Y,XX,YY
      INTEGER       N,LEN,I
C --------------------------------------------
      COEF  = 0.72
      YY    = Y-SIZE/4.0
      XX    = X
      FLAGB = 'N'
      STR   = ' '
      N     = 0
      CALL LENSTR_BL(TEXT,LEN)
      IF(LEN.LE.0) RETURN

      IF(LEN.GT.78) LEN = 78
      LEN = LEN + 1

      DO I=1,LEN
        IF(I.LT.LEN) THEN
          CH = TEXT(I:I)
          CALL CHKSMB(CH,SYMB)
          IF(SYMB.EQ.'?') CH = '^'
          IF(CH  .EQ.'(') CH = '{'
          IF(CH  .EQ.')') CH = '}'
        ELSE
          CH = ' '
        ENDIF
        IF(CH.EQ.' '.AND.FLAGB.EQ.'N') THEN
          IF(XX.GT.BBOXX2) XX = BBOXX2          
          WRITE(IUN_PS,'(2F7.2,'' moveto'')') XX,YY
          IF(N.GT.0) THEN
C            WRITE(51,'(''('',A,'')'')') STR(1:N)
C            WRITE(51,'(F4.1,'' Print'')') SIZE
C            XX=XX+SIZE*N*COEF
            XXX = XX
            DO J=1,N
              WRITE(IUN_PS,'(''('',A,'')'')') STR(J:J)
              WRITE(IUN_PS,'(F4.1,'' Print'')') SIZE
              XXX = XXX+SIZE*COEF
              WRITE(IUN_PS,'(2F7.2,'' moveto'')') XXX,YY
            ENDDO
            XX = XX + SIZE*N*COEF
            N  = 0
          ENDIF
        ENDIF
        IF(CH.NE.' ') THEN
          N       = N + 1        
          STR(N:N)= CH
          FLAGB   = 'N'  
        ELSE
          FLAGB = 'Y'  
          XX    = XX + SIZE*COEF
        ENDIF
      ENDDO
      RETURN
      END


      SUBROUTINE INIT_TX_PAR(RGB,COLNAM)
C-----------------------------------------------------------------------
C
C Initialization of common variables 
C
C-----------------------------------------------------------------------
      PARAMETER ( MXCOLR = 19 )
      CHARACTER*12 COLNAM(MXCOLR)
      REAL         RGB(3,MXCOLR)

C ---
      COMMON /TX_BOX/ IBOXX,IBOXY,ISHX,ISHY
      INTEGER IBOXX,IBOXY,ISHX,ISHY
C ----
      COMMON/TX_ORIG/  IXO,IYO,IX0,IY0,XO,YO
C ----
      COMMON /TX_SLCT/   IPAGE
      INTEGER            IPAGE
C ----
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS
C -------------
      COMMON /COMORG/ ITYPE,SLEN,IXORG,IYORG
C ----
C
      COMMON /PS_BOX/ BBOXX1,BBOXX2,BBOXY1,BBOXY2
      INTEGER  BBOXX1,BBOXX2,BBOXY1,BBOXY2
C ---
      CHARACTER*12 COLNAM_D(MXCOLR)
      REAL         RGB_D(3,MXCOLR)
C ----
      INTEGER ICOL,ILINE
C ----
      DATA 
     + ((RGB_D(ILINE,ICOL),ILINE=1,3),COLNAM_D(ICOL),ICOL=1,MXCOLR) /
     +     0.0000, 0.0000, 0.0000, 'BLACK',
     +     1.0000, 1.0000, 1.0000, 'WHITE',
     +     1.0000, 0.0000, 0.0000, 'RED',
     +     0.0000, 1.0000, 0.0000, 'GREEN',
     +     0.0000, 0.0000, 1.0000, 'BLUE',
     +     1.0000, 1.0000, 0.0000, 'YELLOW',
     +     0.8000, 0.5000, 0.0000, 'ORANGE',
     +     0.5000, 1.0000, 0.0000, 'LIME GREEN',
     +     0.5000, 0.0000, 1.0000, 'PURPLE',
     +     0.5000, 1.0000, 1.0000, 'CYAN',
     +     1.0000, 0.5000, 1.0000, 'PINK',
     +     0.3000, 0.8000, 1.0000, 'SKY BLUE',
     +     1.0000, 1.0000, 0.7000, 'CREAM',
     +     0.0000, 1.0000, 1.0000, 'TURQUOISE',
     +     1.0000, 0.0000, 1.0000, 'LILAC',
     +     0.8000, 0.0000, 0.0000, 'BRICK RED',
     +     0.5000, 0.0000, 0.0000, 'BROWN',
     +     0.9700, 0.9700, 0.9700, 'LIGHT GREY',
     +     1.0000, 1.0000, 1.0000, 'WHITE' /
c     +     1.0000, 1.0000, 1.0000, 'WHITE' /
C ------------------------------------------------------
      DO ICOL=1,MXCOLR
        DO ILINE=1,3
          RGB(ILINE,ICOL) = RGB_D(ILINE,ICOL)
        ENDDO
        COLNAM(ICOL) = COLNAM_D(ICOL)
      ENDDO

      CALL INIT_TX

      RETURN
      END

      SUBROUTINE INIT_TX
C-----------------------------------------------------------------------
C
C Initialization of common variables 
C
C-----------------------------------------------------------------------
C ---
      COMMON /TX_BOX/ IBOXX,IBOXY,ISHX,ISHY
      INTEGER IBOXX,IBOXY,ISHX,ISHY
C ----
      COMMON/TX_ORIG/  IXO,IYO,IX0,IY0,XO,YO
C ----
      COMMON /TX_SLCT/   IPAGE
      INTEGER            IPAGE
C ----
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS
C -------------
      COMMON /COMORG/ ITYPE,SLEN,IXORG,IYORG
C ----
C
      COMMON /PS_BOX/ BBOXX1,BBOXX2,BBOXY1,BBOXY2
      INTEGER  BBOXX1,BBOXX2,BBOXY1,BBOXY2
C ---
C ------------------------------------------------------

      BBOXX1  =  30
      BBOXX2  = 550
      BBOXY1  =  50
      BBOXY2  = 780

      IBOXX   = 650
      IBOXY   = 500

      IXO     = 0
      IYO     = 0
      IX0     = 0
      IY0     = 0
      IPAGE   = 0
      IOPEN   = 0
      ISHX_PS = 30
      ISHY_PS = 20
      IXORG   = 0
      IYORG   = 0
      SLEN    = 0.0
      ITYPE   = 0
      XO      = 0.0
      YO      = 0.0

      RETURN
      END
C =========================
C**************************************************************************
C
C  PS.F    - PostScript subroutines
C
C            Written by Roman Laskowski, University College, London,
C            November 1993.
C
C            Original version was part of v.3.0 of the PROCHECK suite
C            of programs. (Previously the routines were incorporated in
C            pplot.f).
C
C            Subsequent amendments will be labelled by CHECK v.m.n-->
C            and CHECK v.m.n<-- where m.n is the version number
C            corresponding to the change
C
C  v.3.0.1 - Change of plot-file names. All plot-file names now have the
C            form: <filename>_nn.ps  where <filename> is the name of the
C            input data file, and nn is a sequential number 01, 02, ...
C                                             Roman Laskowski (29 Mar 1994)
C            (a little changed. 21.09.96 Vagin)
C
C            !!! PSOPEN( ....,IERR) !!!
C--------------------------------------------------------------------------
C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSSETPG  -  Set page specifications
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSSETPG(TOTALNBPAGES)

C ---

      INTEGER TOTPAG, CURPAG

      COMMON /ISPS/ TOTPAG, CURPAG
C ---
      INTEGER TOTALNBPAGES

      TOTPAG = TOTALNBPAGES
      CURPAG = 1

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSOPEN  -  Open PostScript file and write out header records
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSOPEN(FNAME,BBOXX1,BBOXX2,BBOXY1,BBOXY2,MXCOLR,RGB,
     -    INCOL,BAKCOL,IERR)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS


      INTEGER TOTPAG, CURPAG

      COMMON /ISPS/ TOTPAG, CURPAG
C ---

      CHARACTER*(*)  FNAME
      CHARACTER*2    COLNO
      CHARACTER      PATH*1,EXT*1
      INTEGER        BAKCOL, BBOXX1, BBOXX2, BBOXY1, BBOXY2, I, ICOL,
     -               MXCOLR
      LOGICAL        INCOL
      REAL           RGB(3,MXCOLR)

C---- Open output file
C      IERR = 0
C      OPEN(UNIT = IUN_PS, FILE=FNAME, STATUS='UNKNOWN',
C     -     FORM='FORMATTED', ACCESS='SEQUENTIAL',
CVAX     -     CARRIAGECONTROL = 'LIST',
C     -     ERR=900)

      PATH = ' '
      EXT  = ' '
      MDOC = 99
      CALL  OPENFW(IUN_PS,MDOC,PATH,FNAME,EXT,IERR)
      IF(IERR.NE.0) GO TO 900

C---- Write out headings to PostScript file
      WRITE(IUN_PS,10) TOTPAG
 10   FORMAT(
     -    '%!PS-Adobe-3.0',/,
     -    '%%Creator: Procheck',/,
     -'%%DocumentNeededResources: font Times-Roman Symbol Times-Bold',/,
     -    '%%BoundingBox: (atend)',/,
     -    '%%Pages:',I3,/,
     -    '%%EndComments',/,
     -    '%%BeginProlog')

      CALL PSRESOURCE_NEW (IUN_PS)

      WRITE(IUN_PS,20)
 20   FORMAT(
     -    '/L { moveto lineto stroke } bind def',/,
     -    '/Col { setrgbcolor } bind def')

C---- Loop to define the colours
      IF (INCOL) THEN
          DO 100, ICOL = 1, MXCOLR
              WRITE(COLNO,40) ICOL
 40           FORMAT(I2)
              IF (COLNO(1:1).EQ.' ') COLNO(1:1) = '0'
              WRITE(IUN_PS,60) COLNO, (RGB(I,ICOL), I = 1, 3)
 60           FORMAT('/Col',A2,' {gsave ',3F8.4,' setrgbcolor } def')
 100      CONTINUE
      ENDIF

      WRITE(IUN_PS,120)
 120  FORMAT(
     -    '/Poly3 { moveto lineto lineto fill grestore } bind ',
     -    'def',/,
     -    '/Pl3 { 6 copy Poly3 moveto moveto moveto closepath ',
     -    'stroke } bind def',/,
     -    '/Pline3 { 6 copy Poly3 moveto lineto lineto closepa',
     -    'th stroke } bind def')
      WRITE(IUN_PS,250)
 250  FORMAT(
     -    '/Poly4 { moveto lineto lineto lineto fill grestore } bind ',
     -    'def',/,
     -    '/Pl4 { 8 copy Poly4 moveto moveto moveto moveto closepath ',
     -    'stroke } bind def',/,
     -    '/Pline4 { 8 copy Poly4 moveto lineto lineto lineto closepa',
     -    'th stroke } bind def',/,
     -    '/Circle { gsave newpath 0.0 setgray 3 copy 0 360 arc fill ',
     -    'stroke grestore }',/
     -    'bind def')
      WRITE(IUN_PS,300)
 300  FORMAT(
     - '/Print { /Times-Roman-Extd findfont exch scalefont setfont show'
     -    ,' } bind def',/,
     -    '/Bprint { /Times-Bold findfont exch scalefont setfont show',
     -    ' } bind def',/,
     -    '/Gprint { /Symbol findfont exch scalefont setfont show } b',
     -    'ind def',/,
     -    '/Center {',/,
     -    '  dup /Times-Roman-Extd findfont exch scalefont setfont',/,
     -    '  exch stringwidth pop -2 div exch -3 div rmoveto',/,
     -    ' } bind def',/,
     -    '/CenterRot90 {',/,
     -    '  dup /Times-Roman-Extd findfont exch scalefont setfont',/,
     -    '  exch stringwidth pop -2 div exch 3 div exch rmoveto',/,
     -    ' } bind def',/,
     -    '/UncenterRot90 {',/,
     -    '  dup /Times-Roman-Extd findfont exch scalefont setfont',/,
     -    '  exch stringwidth } bind def',/,
     -    '/Rot90 { gsave currentpoint translate 90 rotate } bind def'
     -    ,/,'%%EndProlog')
      WRITE(IUN_PS,400) CURPAG, TOTPAG
 400  FORMAT(
     -    '%%BeginSetup',/,
     -    '1 setlinecap 1 setlinejoin 1 setlinewidth 0 setgray [ ] 0 ',
     -    'setdash newpath',/,
     -    '/Times-Roman /Times-Roman-Extd encode_vector ReEncodeSmall'
     -    ,/,'%%EndSetup',/,
     -    '%%Page:',I5,I5)
      WRITE(IUN_PS,500) REAL(BBOXX1), REAL(BBOXY1), REAL(BBOXX2),
     -     REAL(BBOXY1), REAL(BBOXX2), REAL(BBOXY2), REAL(BBOXX1),
     -     REAL(BBOXY2)
 500  FORMAT(
     -    '/ProcheckSave save def',/,
     -    2F6.2,' moveto',2(2F7.2,' lineto'),/,
     -    2F7.2,' lineto closepath gsave',/,
     -    'gsave 1.0000 setgray fill grestore',/,
     -    'clip newpath')

C---- Draw in the background colour
      IF (INCOL) THEN
          CALL PSHADE(0.0,BAKCOL,RGB,MXCOLR,INCOL)
          CALL PSUBOX(REAL(BBOXX1), REAL(BBOXY1), REAL(BBOXX2),
     -        REAL(BBOXY1), REAL(BBOXX2), REAL(BBOXY2), REAL(BBOXX1),
     -        REAL(BBOXY2))
      ENDIF

      GO TO 999

C---- Errors on parameter file
 900  CONTINUE
      MDOC=0
      CALL MSGERR(MDOC,'WARNING: Unable to open Postscript file')
      IERR=1
      GO TO 999

 999  CONTINUE
      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSRESOURCE  -  Write resource to PostScript file
C
C----------------------------------------------------------------------+---
      SUBROUTINE PSRESOURCE_NEW(UN)
C --------------------------------------
      INTEGER       UN
      CHARACTER LINE*80
C --------------------------------------
      WRITE(UN,'(A)')
     *'%%BeginResource: latin1_prolog'
      WRITE(UN,'(A)')
     *' '
      WRITE(UN,'(A)')
     *'% ReEncodeSmall from Adobe Postscript Tutorial and Cookbook'
      WRITE(UN,'(A)')
     *'/reencsmalldict 12 dict def'
      WRITE(UN,'(A)')
     *'/ReEncodeSmall'
      WRITE(UN,'(A)')
     *' {reencsmalldict begin'
      WRITE(UN,'(A)')
     *'  /newcodesandnames exch def'
      WRITE(UN,'(A)')
     *'  /newfontname exch def'
      WRITE(UN,'(A)')
     *'  /basefontname exch def'
      WRITE(UN,'(A)')
     *' '
      WRITE(UN,'(A)')
     *'  /basefontdict basefontname findfont def'
      WRITE(UN,'(A)')
     *'  /newfont basefontdict maxlength dict def'
      WRITE(UN,'(A)')
     *' '
      WRITE(UN,'(A)')
     *'  basefontdict'
      WRITE(UN,'(A)')
     *'   {exch dup /FID ne'
      WRITE(UN,'(A)')
     *'     {dup /Encoding eq'
      WRITE(UN,'(A)')
     *'       {exch dup length array copy'
      WRITE(UN,'(A)')
     *'	 newfont 3 1 roll put}'
      WRITE(UN,'(A)')
     *'       {exch newfont 3 1 roll put}'
      WRITE(UN,'(A)')
     *'       ifelse'
      WRITE(UN,'(A)')
     *'     }'
      WRITE(UN,'(A)')
     *'     {pop pop}'
      WRITE(UN,'(A)')
     *'     ifelse'
      WRITE(UN,'(A)')
     *'   }forall'
      WRITE(UN,'(A)')
     *' '
      WRITE(UN,'(A)')
     *'  newfont /FontName newfontname put'
      WRITE(UN,'(A)')
     *'  newcodesandnames aload pop'
      WRITE(UN,'(A)')
     *' '
      WRITE(UN,'(A)')
     *'  newcodesandnames length 2 idiv'
      WRITE(UN,'(A)')
     *'   {newfont /Encoding get 3 1 roll put}'
      WRITE(UN,'(A)')
     *'   repeat'
      WRITE(UN,'(A)')
     *' '
      WRITE(UN,'(A)')
     *'  newfontname newfont definefont pop'
      WRITE(UN,'(A)')
     *'  end'
      WRITE(UN,'(A)')
     *'}def'
      WRITE(UN,'(A)')
     *'%%EndResource'
      WRITE(UN,'(A)')
     *'%%BeginResource: latin1_encoding'
      WRITE(UN,'(A)')
     *'/encode_vector ['
      WRITE(UN,'(A)')
     *'8#040  /space        8#041  /exclam       8#042  /quotedbl     '
      WRITE(UN,'(A)')
     *'8#043  /numbersign   8#044  /dollar       8#045  /percent      '
      WRITE(UN,'(A)')
     *'8#046  /ampersand    8#047  /quoteright   8#050  /parenleft    '
      WRITE(UN,'(A)')
     *'8#051  /parenright   8#052  /asterisk     8#053  /plus         '
      WRITE(UN,'(A)')
     *'8#054  /comma        8#055  /minus        8#056  /period       '
      WRITE(UN,'(A)')
     *'8#057  /slash        8#060  /zero         8#061  /one          '
      WRITE(UN,'(A)')
     *'8#062  /two          8#063  /three        8#064  /four         '
      WRITE(UN,'(A)')
     *'8#065  /five         8#066  /six          8#067  /seven        '
      WRITE(UN,'(A)')
     *'8#070  /eight        8#071  /nine         8#072  /colon        '
      WRITE(UN,'(A)')
     *'8#073  /semicolon    8#074  /less         8#075  /equal        '
      WRITE(UN,'(A)')
     *'8#076  /greater      8#077  /question     8#100  /at           '
      WRITE(UN,'(A)')
     *'8#101  /A            8#102  /B            8#103  /C            '
      WRITE(UN,'(A)')
     *'8#104  /D            8#105  /E            8#106  /F            '
      WRITE(UN,'(A)')
     *'8#107  /G            8#110  /H            8#111  /I            '
      WRITE(UN,'(A)')
     *'8#112  /J            8#113  /K            8#114  /L            '
      WRITE(UN,'(A)')
     *'8#115  /M            8#116  /N            8#117  /O            '
      WRITE(UN,'(A)')
     *'8#120  /P            8#121  /Q            8#122  /R            '
      WRITE(UN,'(A)')
     *'8#123  /S            8#124  /T            8#125  /U            '
      WRITE(UN,'(A)')
     *'8#126  /V            8#127  /W            8#130  /X            '
      WRITE(UN,'(A)')
     *'8#131  /Y            8#132  /Z            8#133  /bracketleft  '
      WRITE(UN,'(A)')
     *'8#134  /backslash    8#135  /bracketright 8#136  /asciicircum  '
      WRITE(UN,'(A)')
     *'8#137  /underscore   8#140  /quoteleft    8#141  /a            '
      WRITE(UN,'(A)')
     *'8#142  /b            8#143  /c            8#144  /d            '
      WRITE(UN,'(A)')
     *'8#145  /e            8#146  /f            8#147  /g            '
      WRITE(UN,'(A)')
     *'8#150  /h            8#151  /i            8#152  /j            '
      WRITE(UN,'(A)')
     *'8#153  /k            8#154  /l            8#155  /m            '
      WRITE(UN,'(A)')
     *'8#156  /n            8#157  /o            8#160  /p            '
      WRITE(UN,'(A)')
     *'8#161  /q            8#162  /r            8#163  /s            '
      WRITE(UN,'(A)')
     *'8#164  /t            8#165  /u            8#166  /v            '
      WRITE(UN,'(A)')
     *'8#167  /w            8#170  /x            8#171  /y            '
      WRITE(UN,'(A)')
     *'8#172  /z            8#173  /braceleft    8#174  /bar          '
      WRITE(UN,'(A)')
     *'8#175  /braceright   8#176  /tilde        8#240  /space        '
      WRITE(UN,'(A)')
     *'8#241  /exclamdown   8#242  /cent         8#243  /sterling     '
      WRITE(UN,'(A)')
     *'8#244  /currency     8#245  /yen          8#246  /brokenbar    '
      WRITE(UN,'(A)')
     *'8#247  /section      8#250  /dieresis     8#251  /copyright    '
      WRITE(UN,'(A)')
     *'8#252  /ordfeminine  8#253  /guillemotleft 8#254  /logicalnot  '
      WRITE(UN,'(A)')
     *'8#255  /hyphen       8#256  /registered   8#257  /macron       '
      WRITE(UN,'(A)')
     *'8#260  /degree       8#261  /plusminus    8#262  /twosuperior  '
      WRITE(UN,'(A)')
     *'8#263  /threesuperior 8#264  /acute       8#265  /mu           '
      WRITE(UN,'(A)')
     *'8#266  /paragraph    8#267  /bullet       8#270  /cedilla      '
      WRITE(UN,'(A)')
     *'8#271  /dotlessi    8#272  /ordmasculine 8#273  /guillemotright'
      WRITE(UN,'(A)')
     *'8#274  /onequarter   8#275  /onehalf      8#276  /threequarters'
      WRITE(UN,'(A)')
     *'8#277  /questiondown 8#300  /Agrave       8#301  /Aacute       '
      WRITE(UN,'(A)')
     *'8#302  /Acircumflex  8#303  /Atilde       8#304  /Adieresis    '
      WRITE(UN,'(A)')
     *'8#305  /Aring        8#306  /AE           8#307  /Ccedilla     '
      WRITE(UN,'(A)')
     *'8#310  /Egrave       8#311  /Eacute       8#312  /Ecircumflex  '
      WRITE(UN,'(A)')
     *'8#313  /Edieresis    8#314  /Igrave       8#315  /Iacute       '
      WRITE(UN,'(A)')
     *'8#316  /Icircumflex  8#317  /Idieresis    8#320  /Eth          '
      WRITE(UN,'(A)')
     *'8#321  /Ntilde       8#322  /Ograve       8#323  /Oacute       '
      WRITE(UN,'(A)')
     *'8#324  /Ocircumflex  8#325  /Otilde       8#326  /Odieresis    '
      WRITE(UN,'(A)')
     *'8#327  /multiply     8#330  /Oslash       8#331  /Ugrave       '
      WRITE(UN,'(A)')
     *'8#332  /Uacute       8#333  /Ucircumflex  8#334  /Udieresis    '
      WRITE(UN,'(A)')
     *'8#335  /Yacute       8#336  /Thorn        8#337  /germandbls   '
      WRITE(UN,'(A)')
     *'8#340  /agrave       8#341  /aacute       8#342  /acircumflex  '
      WRITE(UN,'(A)')
     *'8#343  /atilde       8#344  /adieresis    8#345  /aring        '
      WRITE(UN,'(A)')
     *'8#346  /ae           8#347  /ccedilla     8#350  /egrave       '
      WRITE(UN,'(A)')
     *'8#351  /eacute       8#352  /ecircumflex  8#353  /edieresis    '
      WRITE(UN,'(A)')
     *'8#354  /igrave       8#355  /iacute       8#356  /icircumflex  '
      WRITE(UN,'(A)')
     *'8#357  /idieresis    8#360  /eth          8#361  /ntilde       '
      WRITE(UN,'(A)')
     *'8#362  /ograve       8#363  /oacute       8#364  /ocircumflex  '
      WRITE(UN,'(A)')
     *'8#365  /otilde       8#366  /odieresis    8#367  /divide       '
      WRITE(UN,'(A)')
     *'8#370  /oslash       8#371  /ugrave       8#372  /uacute       '
      WRITE(UN,'(A)')
     *'8#373  /ucircumflex  8#374  /udieresis    8#375  /yacute       '
      WRITE(UN,'(A)')
     *'8#376  /thorn        8#377  /ydieresis    	'
      WRITE(UN,'(A)')
     *'] def'
      WRITE(UN,'(A)')
     *'%%EndResource'
C -----------------------
      RETURN
      END

      SUBROUTINE PSRESOURCE_OLD(UN)

      INTEGER       UN
      CHARACTER LINE*80
C     CHARACTER RESFILE*80

      INTEGER       IERR,MDOC,IUN
      CHARACTER FILE*256,PATH*256,EXT*256
C --------------------------------------
      INCLUDE 'crd_com.fh'
C ---
      IERR = 0
      MDOC = 0

C      CALL GET_PATH(MDOC,'MAKECIF',LINE,IERR)
C      IF(IERR.NE.0) RETURN
C      CALL LENSTR_BL(LINE,LEN)
C      IF(LEN.GT.0) THEN
C       PATH=LINE(1:LEN)//'/dic/'
C      ENDIF

      PATH = CR_LIB_PATH

      FILE = 'ps.resource'
      EXT  = ' '

C     IUN  = 52
      IUN  = CR_SC_IUN

      M    = 99
      CALL OPENFR(IUN,M,PATH,FILE,EXT,IERR)
      CR_SC_IUN = IUN

      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: can''t open ps.resource')
        RETURN
      ENDIF
C---- Read in the resource
      DO I = 1, 104
         READ(IUN,'(A)',END=900,ERR=900) LINE
         WRITE(UN,'(A)') LINE
      ENDDO
      GOTO 999

 900  CONTINUE
      CALL MSGERR(MDOC,'ERROR: Problem with file ps.resource.')
      IERR=1
 999  CONTINUE

      CLOSE(CR_SC_IUN)

      RETURN
      END
C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSNWPAG  -  Write new page lines to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSNWPAG(BBOXX1,BBOXX2,BBOXY1,BBOXY2,INCOL)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      INTEGER TOTPAG, CURPAG

      COMMON /ISPS/ TOTPAG, CURPAG
C ---

      INTEGER       BAKCOL, BBOXX1, BBOXX2, BBOXY1, BBOXY2
C     ?????????????????????? BAKCOL

      LOGICAL        INCOL

C---- Write out new page lines to PostScript file

      CURPAG = CURPAG + 1

      WRITE(IUN_PS,500) CURPAG, TOTPAG,
     -     REAL(BBOXX1), REAL(BBOXY1), REAL(BBOXX2),
     -     REAL(BBOXY1), REAL(BBOXX2), REAL(BBOXY2), REAL(BBOXX1),
     -     REAL(BBOXY2)
 500  FORMAT(
     -    'grestore stroke',/,
     -    'ProcheckSave restore',/,
     -    'showpage',/,
     -    '%%Page:',I3,I3,/,
     -    '/ProcheckSave save def',/,
     -    2F6.2,' moveto',2(2F7.2,' lineto'),/,
     -    2F7.2,' lineto closepath gsave',/,
     -    'gsave 1.0000 setgray fill grestore',/,
     -    'clip newpath')

C---- Draw in the background colour
      IF (INCOL) THEN
          CALL PSHADE(0.0,BAKCOL,RGB,MXCOLR,INCOL)
          CALL PSUBOX(REAL(BBOXX1), REAL(BBOXY1), REAL(BBOXX2),
     -        REAL(BBOXY1), REAL(BBOXX2), REAL(BBOXY2), REAL(BBOXX1),
     -        REAL(BBOXY2))
      ENDIF

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSCLOS  -  Write final lines to PostScript file and close
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSCLOS(BBOXX1,BBOXX2,BBOXY1,BBOXY2)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      INTEGER       BBOXX1, BBOXX2, BBOXY1, BBOXY2

C---- Write out closing lines to PostScript file
      WRITE(IUN_PS,100) BBOXX1 - 1, BBOXY1 - 1, BBOXX2 + 1, BBOXY2 + 1
 100  FORMAT(
     -    'grestore stroke',/,
     -    'ProcheckSave restore',/,
     -    'showpage',/,
     -    '%%Trailer',/,
     -    '%%BoundingBox:',4I4,/,
     -    '%%EOF')


C---- Close the file
      CLOSE(IUN_PS)

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSBBOX  -  Write out bounded box to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSBBOX(X1,Y1,X2,Y2,X3,Y3,X4,Y4)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      REAL          X1, X2, Y1, Y2, X3, Y3, X4, Y4

      WRITE(IUN_PS,100) X1, Y1, X2, Y2, X3, Y3, X4, Y4
 100  FORMAT(8F7.2,' Pline4')

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSCOLB  -  Write background colour level
C
C----------------------------------------------------------------------+--- 

      SUBROUTINE PSCOLB(R,G,B)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      REAL          R, G, B

      WRITE(IUN_PS,100) R, G, B
 100  FORMAT(3F8.4,' Col')

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSCOLR  -  Write colour level
C
C----------------------------------------------------------------------+--- 

      SUBROUTINE PSCOLR(R,G,B)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      REAL          R, G, B

      WRITE(IUN_PS,100) R, G, B
 100  FORMAT('gsave ',3F8.4,' Col')

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSCIRC  -  Write out a black circle to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSCIRC(X,Y,RADIUS)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      REAL          X, Y, RADIUS,R

      R = RADIUS
      IF(R.LT.0.5.OR.R.GT.999.9) R=1.0
      IF(ABS(X).GT.999.9) X=1.0
      IF(ABS(Y).GT.999.9) Y=1.0

      WRITE(IUN_PS,100) X, Y, R
 100  FORMAT(3F7.2,' Circle')

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSCTXT  -  Write out centred text to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSCTXT(X,Y,SIZE,TEXT)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      CHARACTER*(*) TEXT
      REAL          SIZE, X, Y

      WRITE(IUN_PS,100) X, Y
 100  FORMAT(2F7.2,' moveto')
      CALL LENSTR_BL(TEXT,LEN)
      WRITE(IUN_PS,200) TEXT(1:LEN), SIZE
 200  FORMAT('(',A,')',/,F4.1,' Center')
      WRITE(IUN_PS,300) TEXT(1:LEN), SIZE
 300  FORMAT('(',A,')',/,F4.1,' Print')
      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSLINE  -  Write line out to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSLINE(X1,Y1,X2,Y2)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      REAL          X1, X2, Y1, Y2

      IF(ABS(X1).GT.999.0) X1=1.0
      IF(ABS(X2).GT.999.0) X2=1.0
      IF(ABS(Y1).GT.999.0) Y1=1.0
      IF(ABS(Y2).GT.999.0) Y2=1.0

      WRITE(IUN_PS,100) X1, Y1, X2, Y2
 100  FORMAT(4F7.2,' L')

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSLWID  -  Write line-width out to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSLWID(LWIDTH)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      REAL          LWIDTH, T

      T = LWIDTH
      IF(T.LT.0.01) T = 0.01
      IF(T.GT.2.0 ) T = 2.0

      WRITE(IUN_PS,100) T
 100  FORMAT(F5.2,' setlinewidth')

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSMARK  -  Write point-marker to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSMARK(X,Y,MARKER,HWIDX,HWIDY)

      INTEGER       MARKER
      REAL          HWIDX, HWIDY, X, Y

C---- Print appropriate marker

C---- Oridnary residue
      IF (MARKER.EQ.1) THEN
           CALL PSBBOX(X - HWIDX,Y - HWIDY,X - HWIDX,Y + HWIDY,
     -                 X + HWIDX,Y + HWIDY,X + HWIDX,Y - HWIDY)

C---- Glycine
      ELSE IF (MARKER.EQ.2) THEN
          CALL PSTRIA(X - HWIDX,Y - 0.6 * HWIDY,X + HWIDX,
     -        Y - 0.6 * HWIDY,X,Y + 1.2 * HWIDY)

C---- Residue in disallowed region
      ELSE IF (MARKER.EQ.3) THEN
           CALL PSBBOX(X - HWIDX,Y - HWIDY,X - HWIDX,Y + HWIDY,
     -                 X + HWIDX,Y + HWIDY,X + HWIDX,Y - HWIDY)
      ENDIF

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSRCTX  -  Write out text centred and rotated through 90
C                        degrees to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSRCTX(X,Y,SIZE,TEXT)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      CHARACTER*(*) TEXT
      REAL          SIZE, X, Y

      WRITE(IUN_PS,100) X, Y
 100  FORMAT(2F7.2,' moveto')
      CALL LENSTR_BL(TEXT,LEN)
      WRITE(IUN_PS,200) TEXT(1:LEN), SIZE
 200  FORMAT('(',A,') ',F4.1,' CenterRot90 Rot90')
      WRITE(IUN_PS,300) TEXT(1:LEN), SIZE
 300  FORMAT('(',A,') ',F4.1,' Print')
      WRITE(IUN_PS,400)
 400  FORMAT('grestore')

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSRTXT  -  Write out text rotated through 90 degrees to
C                        PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSRTXT(X,Y,SIZE,TEXT)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      CHARACTER*(*) TEXT
      REAL          SIZE, X, Y

      WRITE(IUN_PS,100) X, Y
 100  FORMAT(2F7.2,' moveto')
      CALL LENSTR_BL(TEXT,LEN)
      WRITE(IUN_PS,200) TEXT(1:LEN), SIZE
 200  FORMAT('(',A,') ',F4.1,' UncenterRot90 Rot90')
      WRITE(IUN_PS,300) TEXT(1:LEN), SIZE
 300  FORMAT('(',A,') ',F4.1,' Print')
      WRITE(IUN_PS,400)
 400  FORMAT('grestore')

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSDASH  -  Switch dashed lines on/off
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSDASH(ONOFF)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      INTEGER       ONOFF

      IF (ONOFF.EQ.0) THEN
          WRITE(IUN_PS,100)
 100      FORMAT('[]  0 setdash')
      ELSE
          WRITE(IUN_PS,120) ONOFF, ONOFF
 120      FORMAT('[ ', I2, ' ', I2, ' ]  0 setdash')
      ENDIF

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PS_CALE  -  Write out colour or black-and-white shading
C                        level to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PS_CALE(SHADE,INCOL,MXCOLR,RGB,MINCOL,MAXCOL)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      INTEGER       ICOL, MAXCOL, MINCOL, MXCOLR
      LOGICAL       INCOL
      REAL          COLOUR(3), RGB(3,MXCOLR), SHADE

C---- If black-and-white PostScript file, then write out grey-level
      IF (.NOT.INCOL) THEN
          WRITE(IUN_PS,100) SHADE
 100      FORMAT('gsave',F7.4,' setgray')

C---- Otherwise, if in colour, determine the right mix of colours
      ELSE
          DO 200, ICOL = 1, 3
              COLOUR(ICOL) = RGB(ICOL,MINCOL) + (1.0 - SHADE)
     -            * (RGB(ICOL,MAXCOL) - RGB(ICOL,MINCOL))
 200      CONTINUE

C----     Write out the 3 RGB values
          WRITE(IUN_PS,220) (COLOUR(ICOL), ICOL = 1, 3)
 220      FORMAT('gsave ',3F8.4,' Col')
      ENDIF

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSHADE  -  Write shading level out to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSHADE(SHADE,COLOUR,RGB,MXCOLR,INCOL)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      CHARACTER*2   COLNO
      INTEGER       COLOUR, MXCOLR
      LOGICAL       INCOL
      REAL          RGB(3,MXCOLR), SHADE

      IF (.NOT.INCOL) THEN
          WRITE(IUN_PS,100) SHADE
 100      FORMAT('gsave',F7.4,' setgray')
      ELSE
          WRITE(COLNO,140) COLOUR
 140      FORMAT(I2)
          IF (COLNO(1:1).EQ.' ') COLNO(1:1) = '0'
          WRITE(IUN_PS,200) COLNO
 200      FORMAT('Col',A2)
      ENDIF

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSTEXT  -  Write out text to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSTEXT(X,Y,SIZE,TEXT)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      CHARACTER*(*) TEXT
      REAL          SIZE, X, Y

      T1=X
      T2=Y - SIZE / 4.0
      IF(ABS(T1).GT.999.0) T1=1.0
      IF(ABS(T2).GT.999.0) T2=1.0
      WRITE(IUN_PS,100) T1,T2 
 100  FORMAT(2F7.2,' moveto')
      CALL LENSTR_BL(TEXT,LEN)
      SZ=SIZE
      IF(SZ.LT.0.5.OR.SZ.GT.99.9) SZ=1.0
      WRITE(IUN_PS,300) TEXT(1:LEN), SZ
 300  FORMAT('(',A,')',/,F4.1,' Print')
      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSBTEXT  -  Write out text to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSBTEXT(X,Y,SIZE,TEXT)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      CHARACTER*(*) TEXT
      REAL          SIZE, X, Y

      T1=X
      T2=Y - SIZE / 4.0
      IF(ABS(T1).GT.999.0) T1=1.0
      IF(ABS(T2).GT.999.0) T2=1.0
      WRITE(IUN_PS,100) T1,T2 
 100  FORMAT(2F7.2,' moveto')
      CALL LENSTR_BL(TEXT,LEN)
      SZ=SIZE
      IF(SZ.LT.0.5.OR.SZ.GT.99.9) SZ=1.0
      WRITE(IUN_PS,300) TEXT(1:LEN), SZ
 300  FORMAT('(',A,')',/,F4.1,' Bprint')
      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSSYMB  -  Write out symbol text to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSSYMB(X,Y,SIZE,TEXT)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      CHARACTER*(*) TEXT
      REAL          SIZE, X, Y

      T1=X
      T2=Y - SIZE / 4.0
      IF(ABS(T1).GT.999.0) T1=1.0
      IF(ABS(T2).GT.999.0) T2=1.0
      WRITE(IUN_PS,100) T1,T2 
 100  FORMAT(2F7.2,' moveto')
      CALL LENSTR_BL(TEXT,LEN)
      SZ=SIZE
      IF(SZ.LT.0.5.OR.SZ.GT.99.9) SZ=1.0
      WRITE(IUN_PS,300) TEXT(1:LEN), SZ
 300  FORMAT('(',A,')',/,F4.1,' Gprint')

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSTRIA  -  Write out bounded triangle to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSTRIA(X1,Y1,X2,Y2,X3,Y3)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      REAL          X1, X2, Y1, Y2, X3, Y3

      IF(ABS(X1).GT.999.0) X1=0.0
      IF(ABS(X2).GT.999.0) X2=0.0
      IF(ABS(Y1).GT.999.0) Y1=0.0
      IF(ABS(Y2).GT.999.0) Y2=0.0

      IF(ABS(X3).GT.999.0) X3=0.0
      IF(ABS(Y3).GT.999.0) Y3=0.0

      WRITE(IUN_PS,100) X1, Y1, X2, Y2, X3, Y3
 100  FORMAT(6F7.2,' Pline3')

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSUBOX  -  Write out unbounded box to PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE PSUBOX(X1,Y1,X2,Y2,X3,Y3,X4,Y4)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      REAL          X1, X2, Y1, Y2, X3, Y3, X4, Y4

      IF(ABS(X1).GT.999.0) X1=0.0
      IF(ABS(X2).GT.999.0) X2=0.0
      IF(ABS(Y1).GT.999.0) Y1=0.0
      IF(ABS(Y2).GT.999.0) Y2=0.0

      IF(ABS(X3).GT.999.0) X3=0.0
      IF(ABS(X4).GT.999.0) X4=0.0
      IF(ABS(Y3).GT.999.0) Y3=0.0
      IF(ABS(Y4).GT.999.0) Y4=0.0

      WRITE(IUN_PS,100) X1, Y1, X2, Y2, X3, Y3, X4, Y4
 100  FORMAT(8F7.2,' Pl4')

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE PSUTRI  -  Write out unbounded triangle to PostScript file
C
C----------------------------------------------------------------------+--- 

      SUBROUTINE PSUTRI(X1,Y1,X2,Y2,X3,Y3)
      COMMON /COM_PS/ IOPEN,IUN_PS
      INTEGER         IOPEN,IUN_PS

      REAL          X1, X2, X3, Y1, Y2, Y3

      WRITE(IUN_PS,100) X1, Y1, X2, Y2, X3, Y3
 100  FORMAT(6F7.2,' Pl3')

      RETURN
      END

C--------------------------------------------------------------------------
C**************************************************************************
C
C  SUBROUTINE AXES  -  Draw graph axes and axis-labels, writing out to
C                      PostScript file
C
C----------------------------------------------------------------------+---

      SUBROUTINE AXES(XLIM1,XLIM2,YLIM1,YLIM2,NPTSX,NPTSY,XMIN,XMAX,
     -    YMIN,YMAX,SIZLAB,INTRLX,INTRLY,TSIZE,NUMBEX,NUMBEY,ZEROS,
     -    NOENDX,NOENDY,FULTIC)

      CHARACTER*5    LABEL
      INTEGER        IFROM, IMARK, INTRLX, INTRLY, IVALUE, NPTSX, NPTSY
      LOGICAL        FULTIC, NOENDX, NOENDY, NUMBEX, NUMBEY, ZEROS
      REAL           SIZLAB, TSIZE, UGAP, VALUE, VGAP, X, XCENTR, XGAP,
     -               XLIM1, XLIM2, XMAX, XMIN, X1, X2, Y, YCENTR, YGAP,
     -               YLIM1, YLIM2, YMAX, YMIN, Y1, Y2

C Routine parameters:-
C ------------------
C XLIM1, XLIM2, YLIM1, YLIM2 - x- and y-extent of graph area (ie coords
C          of graph-box). In PostScript coords.
C NPTSX, NPTSY - Numbers of ticks along x- and y-axes
C XMIN, XMAX, YMIN, YMAX - Minimum and maximum x- and y-values on plotted
C          axes
C SIZLAB - Label-size for numbers on the axis (in PostScript coords).
C INTRLX, INTRLY - Integer values indicating how the numbers on the axes
C          are to be formatted. (O=format as integer,1=format as real with
C          1 number after decimal point,2=real with 2 numbers after decimal
C          point.
C TSIZE  - A measure of the distance of axis labels from the axis (in
C          PostScript coords).
C NUMBEX, NUMBEY - Flags indicating whether numbers are actually required
C          on the x- and y-axes
C ZEROS  - Flag indicating whether zero value on the y-axis is required
C NOEND  - Flag indicating whether the last numbers on the x- and y-axes
C          are required
C FULTIC - Flag indicating whether axis ticks are to be full-ticks,
C          extending a little to the other side of the axis, or half-ticks
C          only.

C---- Initialise variables
      IF (NPTSX.GT.0) THEN
          XGAP = (XLIM2 - XLIM1) / NPTSX
          UGAP = (XMAX - XMIN) / NPTSX
      ENDIF
      IF (NPTSY.GT.0) THEN
          YGAP = (YLIM2 - YLIM1) / NPTSY
          VGAP = (YMAX - YMIN) / NPTSY
      ENDIF
      XCENTR = (XLIM1 + XLIM2) / 2.0
      YCENTR = (YLIM1 + YLIM2) / 2.0

C---- Draw box round graph
      CALL PSLWID(0.6)
      CALL PSLINE(XLIM1,YLIM1,XLIM1,YLIM2)
      CALL PSLINE(XLIM1,YLIM2,XLIM2,YLIM2)
      CALL PSLINE(XLIM2,YLIM2,XLIM2,YLIM1)
      CALL PSLINE(XLIM2,YLIM1,XLIM1,YLIM1)

C---- x-axis point markers and labels
      X = XLIM1
      Y = YLIM1 - TSIZE / 2.0
      IF (NPTSX.GT.0) THEN
          DO 100, IMARK = 1, NPTSX + 1
              VALUE = XMIN + (IMARK - 1) * UGAP
              IF (VALUE.GE.0.0) THEN
                  IVALUE = VALUE + 0.5
              ELSE
                  IVALUE = VALUE - 0.5
              ENDIF
              IF (INTRLX.EQ.0) THEN
                  WRITE(LABEL,20) IVALUE
 20               FORMAT(I5)
              ELSE IF (INTRLX.EQ.1) THEN
                  WRITE(LABEL,40) VALUE
 40               FORMAT(F5.1)
              ELSE IF (INTRLX.EQ.2) THEN
                  WRITE(LABEL,60) VALUE
 60               FORMAT(F5.2)
              ENDIF
              IFROM = 1
              IF (LABEL(1:1).EQ.' ') IFROM = 2
              IF (LABEL(2:2).EQ.' ') IFROM = 3
              IF (LABEL(3:3).EQ.' ') IFROM = 4
              IF (LABEL(4:4).EQ.' ') IFROM = 5
              IF (NUMBEX) THEN
                  IF (.NOT.(NOENDX .AND. IMARK.EQ.NPTSX + 1)) THEN
                      Y1 = YLIM1
                      Y2 = YLIM1 - SIZLAB / 3.0
                      IF (FULTIC) Y1 = Y1 + SIZLAB / 6.0
                      CALL PSCTXT(X,Y,SIZLAB,LABEL(IFROM:5))
                      CALL PSLINE(X,Y1,X,Y2)
                  ENDIF
              ENDIF
              X = X + XGAP
 100      CONTINUE
      ENDIF

C---- y-axis point markers and labels
      X = XLIM1 - TSIZE
      Y = YLIM1
      IF (NPTSY.GT.0) THEN
          DO 200, IMARK = 1, NPTSY + 1
              VALUE = YMIN + (IMARK - 1) * VGAP
              IF (VALUE.GE.0.0) THEN
                  IVALUE = VALUE + 0.5
              ELSE
                  IVALUE = VALUE - 0.5
              ENDIF
              IF (INTRLY.EQ.0) THEN
                  WRITE(LABEL,20) IVALUE
              ELSE IF (INTRLY.EQ.1) THEN
                  WRITE(LABEL,40) VALUE
              ELSE
                  WRITE(LABEL,60) VALUE
              ENDIF
              IFROM = 1
              IF (NUMBEY .AND. (ZEROS .OR. IMARK.GT.1)) THEN
                  IF (.NOT.(NOENDY .AND. IMARK.EQ.NPTSY + 1)) THEN
                      X1 = XLIM1 - SIZLAB / 3.0
                      X2 = XLIM1
                      IF (FULTIC) X2 = X2 + SIZLAB / 6.0
                      CALL PSCTXT(X,Y,SIZLAB,LABEL(1:5))
                      CALL PSLINE(X1,Y,X2,Y)
                  ENDIF
              ENDIF
              Y = Y + YGAP
 200      CONTINUE
      ENDIF

      RETURN
      END

C==========================================================================
C-----------------------------------------------------------------------
C
C      SUBROUTINE PSBOX
C
C-----------------------------------------------------------------------
      SUBROUTINE PSBOX (XL,XR,YL,YH)
      REAL*4 XL,XR,YL,YH

      CALL PSLINE (XL,YH,XR,YH)
      CALL PSLINE (XR,YH,XR,YL)
      CALL PSLINE (XR,YL,XL,YL)
      CALL PSLINE (XL,YL,XL,YH)
      RETURN
      END
c
      subroutine check_valid_atom_name(asymb,ok)
      implicit none
      include 'all_elements.fh'
c
      character asymb*(*)
      logical ok
c
      integer i,l
      character a_loc*4
      logical ok_l

      a_loc = trim(asymb)
      l= len_trim(a_loc)
      ok_l = .FALSE.
      do while(.not.ok_l.and.i.le.l)
         i = i + 1
         ok_l = a_loc(i:i).eq.'+'.and.a_loc(i:i).eq.'-'
      enddo
      if(ok_l) a_loc(i:l) = ' '
      ok = .FALSE.
      i = 0
      do while(.not.ok.and.i.le.nall_elements)
         i = i + 1
         ok = trim(a_loc).eq.trim(all_elements(i))
      enddo
      return
      end
