

      subroutine gauss_sample(n_atom,xyz_in,xyz_out,ndist,
     &     n_object,n_target,ndist_per_atom,dist_per_atom,ref_2_dist,
     &     ref_2_mat)
      implicit none

c
c--- Sampling using gauss markov random field. It is assumed that we have 
c---  sparse matrix with blocks. Each block is 3x3 matrix. Diagonal blocks are 
c---  identity matrix. 
c
      integer ib,ia
      real xmean(3),x_this(3)

      do ib=1,n_burn+1
         do ia=1,n_atom
            xmean(1:3) = 0.0
            do id=1,ndist_per_atom(ia)
               id1 = ref_2_dist(ia,id)
               if(n_target(id1).eq.ia) then
                  x_this(1:3) = xrand(1:3,n_object(id1))
                  ic = ref_2_mat(id1)
                  do i1=1,3
                     do i2=1,3
                        anondiag(i1,i2) = am(ic)
                        ic = ic + 1
                     enddo
                  enddo
               elseif(n_object(id1).eq.ia) then
                  x_this(1:3) = xrand(1:3,n_target(id1))
                  ic = ref_2_mat(id1)
                  do i1=1,3
                     do i2=1,3
                        anondiag(i2,i1) = am(ic)
                        ic = ic + 1
                     enddo
                  enddo
               endif
               xmean(1:3) = xmean(1:3) + 
     &              matmul(anondiag(1:3,1:3),x_this(1:3))
            enddo
            call random_numbers_gauss(3,x_this)
            x_this = x_this*sigma
            xrand(1:3,ia) = x_this(1:3) + xmean(1:3)
         enddo
      enddo

      return
      end
c
c---Basic routines

      subroutine random_numbers_gauss(nrand,x_this)
      implicit none
c
c---Generate a vector of random numbers. 
      integer nrand
      real x_this(nrand)

      integer nrand1
      real gauss_random

      nrand1 = nrand/2

      do ir=1,nrand
         x_this(ir) =  gauss_random(x)
      enddo

      return
      end


      real function gauss_random(x)
      implicit none
c
c---  Gaussian random number generator. It uses random_number and generates
c--   two random numbers
      real x
c
      real w
      real xrand(2)

      save ihave,rand
      data ihave/0/

      if(ihave.eq.0) then
         w = 2.0
         do while (w.gt.1.0) 
            call random_number(xrand)
            w = 4.0*(xrand(1)-0.5)**2+(xrand(2)-0.5)**2
         enddo
         w = sqrt((-2.0*log(w))/w)
         gauss_random = xrand(1)*w
         rand = xrand(2)*w
         ihave = 1
      else
         gauss_random = rand
         ihave = 0
      endif

      return
      end
