      subroutine refall_twin(ndens,gx,gu1,gq,gu_anom,gq_anom)
      implicit none
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'refi_flags.fh' 
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      real gx(*),gu1(*),gq(*),gu_anom(*),gq_anom(*)
c
      integer nasym_ll
      integer nasym
      integer nexcl_atom
      integer, allocatable :: hkl_asym(:,:)
      real, allocatable :: hl_abcd(:,:)
      real, allocatable :: fsolvent(:,:,:)
      real, allocatable :: fcalc(:,:)
      real, allocatable :: fpart(:,:,:)
      integer, allocatable :: excl_atom_num(:)
c
c---Observations
      integer nobs_in,ncomp,num_blocks,num_asym_ref,num_obs,jsym
      integer num_list
      integer, allocatable :: block_start(:)
      integer, allocatable :: ref_2_asym_start(:)
      integer, allocatable :: obs_start(:)
      integer, allocatable :: comp_numb(:)
      integer, allocatable :: ref_2_asym(:)
      integer, allocatable :: ref_2_symm(:)
      integer, allocatable :: block_2_asym(:)
      integer, allocatable :: freer(:)
      real, allocatable :: weights_b(:)
      real, allocatable :: iobs(:,:)
      real, allocatable :: fmax(:,:)
      real, allocatable :: dfda(:,:,:)
      real, allocatable :: d2fda2(:,:)
c
      integer nzero,nfree
      integer in_file,ierr
      integer iobs_file
      integer i,ii,j,jj,k,kk,io,io1,jo1,ko1,ib,o_s,o_f
      integer npart_act
      integer jnum_o
      integer ndens,nasym1,nmodel
      real pisq8_l
c
c---  Scaling, stat calculation, gradients secders for twin refinement
      ndens = 1
      nmodel = 1
      call open_unform_file(in_file,refl_asym,ierr)
      read(in_file)nasym
      allocate(hkl_asym(3,nasym))
   
c--If phase info is available then use it also. We could make it as if
c--it is always present. Perhaps it is better way of dealing with this problem
c--
c
      do  i=1,nasym
        read(in_file)hkl_asym(1,i),hkl_asym(2,i),hkl_asym(3,i)
      enddo
      close(in_file)
      npart_act = 1
      npart = 1
      allocate(fpart(npart_act,2,nasym))
      call solvent_twin(nasym,ndens,nmodel,hkl_asym,
     &     fpart(npart_act:npart_act,1:2,1:nasym))
c
c---  Exclude atoms from refinement 

c
c---Structure factors from coordinates
      allocate(fcalc(2,nasym))
      call fs_from_crd(nasym,ndens,nmodel,hkl_asym,fcalc)
c
c---read observations
      call open_unform_file(in_file,refl_file,ierr)
      read(in_file)nobs,ncomp,num_blocks,num_asym_ref
c     
c---  We need to define memories
      allocate(freer(num_blocks))
      allocate(weights_b(num_blocks))
      allocate(block_start(num_blocks+1))
      allocate(ref_2_asym_start(num_blocks+1))
      allocate(iobs(2,nobs))
      allocate(obs_start(nobs+1))
      allocate(comp_numb(ncomp))
      allocate(ref_2_asym(ncomp))
      allocate(ref_2_symm(ncomp))
      allocate(block_2_asym(num_asym_ref))
      allocate(hl_abcd(4,nasym))
      num_list = num_blocks
c
c--   read abcd       
      hl_abcd(1:4,1:nasym) = 0.0
c
c---  How many fractions do we have. Need to be stored somewhere.
      block_start(1) = 0
      obs_start(1) = 0
      io1 = 1
      ref_2_asym_start(1) = 0
      ii = 0
      do  ib=1,num_blocks
         read(in_file)num_obs,jsym,freer(ib),weights_b(ib)
         block_start(ib+1) = block_start(ib) + num_obs
         do   io=1,num_obs
            ii = ii + 1
            read(in_file)jnum_o
            obs_start(io1+1) = obs_start(io1) + jnum_o
            jo1 = obs_start(io1)
            read(in_file)iobs(1,ii),iobs(2,ii),(comp_numb(jo1+jj),
     &           ref_2_asym(jo1+jj),ref_2_symm(jo1+jj),jj=1,jnum_o)
c            iobs(1:2,ii) = iobs(1:2,ii)/scale_ls_init
            io1 = io1 + 1
         enddo
         ko1 = ref_2_asym_start(ib)
         read(in_file)(block_2_asym(ko1+kk),kk=1,jsym)
         ref_2_asym_start(ib+1) = ref_2_asym_start(ib) + jsym
      enddo
      close(in_file)
c
c---ls scale
      if(.not.linit) then
         call init_ls_params(nasym,hkl_asym,fcalc,npart_act,fpart,
     &        num_blocks,block_start,ref_2_asym_start,
     &        nobs,iobs,obs_start,
     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &        num_asym_ref,block_2_asym,
     &        ierr)
         linit = .TRUE.
      endif
      do i=1,num_blocks
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         do j=o_s,o_f
            iobs(1:2,j) = iobs(1:2,j)/scale_ls_init
         enddo
      enddo
      pisq8_l = 128.0*atan2(1.0,1.0)**2
      b_ls_over = uover_atom*pisq8_l
c
      call refine_ls_parameters(
     &     nasym,hkl_asym,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)
      uover_atom = b_ls_over/pisq8_l
      uover_atom = uover_atom/2.0
c
c      uover_atom = 0.0
c
c---ls stats

      call calc_ls_stat(nasym,hkl_asym,freer,weights_b,
     &     fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,ierr)
c      stop
      call apply_scales_ls_twin(
     &     nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)
c      b_ls_over = 0.0
c      b_ls_over_flag = .FALSE.
c      stop
c
c---  ml scale
      allocate(fmax(2,nasym))
      fmax(1:2,1:nasym) = 0.
      if(.not.mlinit) then
c         call init_ml_pars(
c     &        nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
c     &        num_blocks,block_start,ref_2_asym_start,
c     &        nobs,iobs,obs_start,
c     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
c     &        num_asym_ref,block_2_asym,
c     &        ierr)
c         stop
c         call ls_ml_pars(
c     &     nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
c     &     num_blocks,block_start,ref_2_asym_start,
c     &     nobs,iobs,obs_start,
c     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
c     &     num_asym_ref,block_2_asym,
c     &     ierr)
c     stop
c         call  find_max_ints_rat(
c     &        nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
c     &        num_blocks,block_start,ref_2_asym_start,
c     &        nobs,iobs,obs_start,
c     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
c     &        num_asym_ref,block_2_asym,fmax,
c     &        ierr)
c
c         call ml_ml_pars(
c     &        nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
c     &        num_blocks,block_start,ref_2_asym_start,
c     &        nobs,iobs,obs_start,
c     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
c     &        num_asym_ref,block_2_asym,fmax,
c     &        ierr)

c         if(len_trim(fobs_appr_file).le.0) then
c            call find_unique_file_name(fobs_appr_file,'.fmax.asym')
c         endif
c         call open_unform_file(iobs_file,fobs_appr_file,ierr)
c         write(iobs_file) nasym
c         do i=1,nasym
c            write(iobs_file)fmax(1:2,i)
c         enddo
c         close(iobs_file)
         mlinit = .TRUE.
      endif
c
c---Read previous approximations
c      call open_unform_file(iobs_file,fobs_appr_file,ierr)
c      read(iobs_file)nasym1
c      if(nasym1.ne.nasym) then
c         call errwrt(1,'Problem ')
c      endif
c      do i=1,nasym
c         read(iobs_file)fmax(1:2,i)
c      enddo
c      close(iobs_file)
c
c      if(len_trim(fobs_appr_file).gt.0) then
c         call open_unform_file(iobs_file,fobs_appr_file,ierr)
c         read(iobs_file) nasym_ll
c         do i=1,nasym_ll
c            read(iobs_file)fmax(1:2,i)
c         enddo
c         close(iobs_file)
c      else
         call  find_max_ints_rat(
     &        nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
     &        num_blocks,block_start,ref_2_asym_start,
     &        nobs,iobs,obs_start,
     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &        num_asym_ref,block_2_asym,fmax,
     &        ierr)
c      endif
c
c---  ML parameter refinement (again)
      call ml_ml_pars(
     &     nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,
     &     ierr)

      call find_max_ml_twin(
     &     nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,
     &     ierr)
      nzero = 0
c      do i=1,nasym
c         if(fmax(1,i).le.0.) nzero = nzero + 1
c         write(*,*)fmax(1:2,i)
c      enddo
c      write(*,*)nzero,nasym
c      stop

c
c---  save these estimators for further use
c      if(len_trim(fobs_appr_file).le.0) then
c         call find_unique_file_name(fobs_appr_file,'.fmax.asym')
c      endif
c      call open_unform_file(iobs_file,fobs_appr_file,ierr)
c      write(iobs_file) nasym
c      do i=1,nasym
c         write(iobs_file)fmax(1:2,i)
c      enddo
c      close(iobs_file)

      call ml_ml_pars(
     &     nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,
     &     ierr)

c
c---  ml stats
      call calc_ml_stat(
     &     nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,fmax,ierr)
c
c---  derivs

      if(.not.lrefin) then
         call decide_twin_opers_1(nasym,hkl_asym,fcalc)
         if(rand_ref_flag) then
            call reflection_write_rand(
     &           nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
     &           num_blocks,block_start,ref_2_asym_start,
     &           nobs,iobs,obs_start,
     &           ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &           num_asym_ref,block_2_asym,fmax,
     &           ierr)
         else
            call mtz_write_twin(
     &           nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
     &           num_blocks,block_start,ref_2_asym_start,
     &           nobs,iobs,obs_start,
     &           ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &           num_asym_ref,block_2_asym,fmax,
     &           ierr)
         endif
      elseif (gradc.and.hcalc) then
         allocate(dfda(2,nasym,1))
         allocate(d2fda2(nasym,1))
c
c---  Different functionals here. ls, detwin/ml, ml-laplace
         if(twin_refine_func.eq.'DTML') then
            call derivs_dfdf_twin(
     &           nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
     &           num_blocks,block_start,ref_2_asym_start,
     &           nobs,iobs,obs_start,
     &           ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &           num_asym_ref,block_2_asym,fmax,
     &           dfda(1:2,1:nasym,1:1),d2fda2(1:nasym,1:1),
     &           ierr)
         elseif(twin_refine_func.eq.'PFML') then

         elseif(twin_refine_func.eq.'FTLS') then
            call derivs_dfdf_twin_ls(
     &           nasym,hkl_asym,freer,weights_b,fcalc,npart_act,fpart,
     &           num_blocks,block_start,ref_2_asym_start,
     &           nobs,iobs,obs_start,
     &           ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &           num_asym_ref,block_2_asym,fmax,
     &           dfda(1:2,1:nasym,1:1),d2fda2(1:nasym,1:1),
     &           ierr)
         endif
         call grads_from_fs_twin(nasym,ndens,nmodel,hkl_asym,dfda,
     &        gx,gu1,gq,gu_anom,gq_anom)
c
c---  secder approximation
         call d2da_radial_twin(nasym,hkl_asym,d2fda2,nmodel)
         call fast_hessian_tabulation(sminb_ml(1),smaxb_ml(nbin_ml),
     &        nmodel)
         call calculate_dpi_ml(nmodel)
         deallocate(dfda)
         deallocate(d2fda2)
c
      endif
c     
c      do i=1,100
c         write(*,*)dfda(1:2,i,1)
c      enddo
c      stop
c      b_ls_over = 0.0
      deallocate(freer)
      deallocate(weights_b)
      deallocate(block_start)
      deallocate(ref_2_asym_start)
      deallocate(iobs)
      deallocate(obs_start)
      deallocate(comp_numb)
      deallocate(ref_2_asym)
      deallocate(ref_2_symm)
      deallocate(block_2_asym)
      deallocate(hl_abcd)
      deallocate(fmax)
c
c--- grads
    
      deallocate(hkl_asym)
      deallocate(fpart)
      deallocate(fcalc)

      return
      end
c
      subroutine sfcalc_and_scale_twin(ndens)
      implicit none
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'monitor.fh'
      INCLUDE 'refi_flags.fh' 
      include 'weights.fh'
      include 'twin_refmac.fh'
      include 'restr_files.fh'
c
      integer nasym
      integer nexcl_atom
      integer, allocatable :: hkl_asym(:,:)
      real, allocatable :: hl_abcd(:,:)
      real, allocatable :: fsolvent(:,:,:)
      real, allocatable :: fcalc(:,:)
      real, allocatable :: fpart(:,:,:)
      integer, allocatable :: excl_atom_num(:)
c
c---Observations
      integer nobs_in,ncomp,num_blocks,num_asym_ref,num_obs,jsym
      integer num_list
      integer, allocatable :: block_start(:)
      integer, allocatable :: ref_2_asym_start(:)
      integer, allocatable :: obs_start(:)
      integer, allocatable :: comp_numb(:)
      integer, allocatable :: ref_2_asym(:)
      integer, allocatable :: ref_2_symm(:)
      integer, allocatable :: block_2_asym(:)
      integer, allocatable :: freer(:)
      real, allocatable :: weights_b(:)
      real, allocatable :: iobs(:,:)
c
      integer in_file,ierr
      integer iobs_file
      integer i,ii,j,jj,k,kk,io,io1,jo1,ko1,ib,o_s,o_f
      integer npart_act
      integer jnum_o
      integer ndens,nasym1,nmodel
      real pisq8_l
c
c---  Scaling, stat calculation, gradients secders for twin refinement
      ndens = 1
      nmodel = 1
      call open_unform_file(in_file,refl_asym,ierr)
      read(in_file)nasym
      allocate(hkl_asym(3,nasym))
   
c--If phase info is available then use it also. We could make it as if
c--it is always present. Perhaps it is better way of dealing with this problem
c--
c
      do  i=1,nasym
        read(in_file)hkl_asym(1,i),hkl_asym(2,i),hkl_asym(3,i)
      enddo
      close(in_file)
      npart_act = 1
      npart = 1
      allocate(fpart(npart_act,2,nasym))
      call solvent_twin(nasym,ndens,nmodel,hkl_asym,
     &     fpart(npart_act:npart_act,1:2,1:nasym))
c
c---  Exclude atoms from refinement 

c
c---Structure factors from coordinates
      allocate(fcalc(2,nasym))
      call fs_from_crd(nasym,ndens,nmodel,hkl_asym,fcalc)
c
c---read observations
      call open_unform_file(in_file,refl_file,ierr)
      read(in_file)nobs,ncomp,num_blocks,num_asym_ref
c     
c---  We need to define memories
      allocate(freer(num_blocks))
      allocate(weights_b(num_blocks))
      allocate(block_start(num_blocks+1))
      allocate(ref_2_asym_start(num_blocks+1))
      allocate(iobs(2,nobs))
      allocate(obs_start(nobs+1))
      allocate(comp_numb(ncomp))
      allocate(ref_2_asym(ncomp))
      allocate(ref_2_symm(ncomp))
      allocate(block_2_asym(num_asym_ref))
      allocate(hl_abcd(4,nasym))
      num_list = num_blocks
c
c--   read abcd       
      hl_abcd(1:4,1:nasym) = 0.0
c
c---  How many fractions do we have. Need to be stored somewhere.
      block_start(1) = 0
      obs_start(1) = 0
      io1 = 1
      ref_2_asym_start(1) = 0
      ii = 0
      do  ib=1,num_blocks
         read(in_file)num_obs,jsym,freer(ib),weights_b(ib)
         block_start(ib+1) = block_start(ib) + num_obs
         do   io=1,num_obs
            ii = ii + 1
            read(in_file)jnum_o
            obs_start(io1+1) = obs_start(io1) + jnum_o
            jo1 = obs_start(io1)
            read(in_file)iobs(1,ii),iobs(2,ii),(comp_numb(jo1+jj),
     &           ref_2_asym(jo1+jj),ref_2_symm(jo1+jj),jj=1,jnum_o)
c            iobs(1:2,ii) = iobs(1:2,ii)/scale_ls_init
            io1 = io1 + 1
         enddo
         ko1 = ref_2_asym_start(ib)
         read(in_file)(block_2_asym(ko1+kk),kk=1,jsym)
         ref_2_asym_start(ib+1) = ref_2_asym_start(ib) + jsym
      enddo
      close(in_file)
c
c---ls scale
      if(.not.linit) then
         call init_ls_params(nasym,hkl_asym,fcalc,npart_act,fpart,
     &        num_blocks,block_start,ref_2_asym_start,
     &        nobs,iobs,obs_start,
     &        ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &        num_asym_ref,block_2_asym,
     &        ierr)
c         linit = .TRUE.
      endif
      do i=1,num_blocks
         o_s = block_start(i)+1
         o_f = block_start(i+1)
         do j=o_s,o_f
            iobs(1:2,j) = iobs(1:2,j)/scale_ls_init
         enddo
      enddo
      pisq8_l = 128.0*atan2(1.0,1.0)**2
      b_ls_over = uover_atom*pisq8_l
c
      call refine_ls_parameters(
     &     nasym,hkl_asym,fcalc,npart_act,fpart,
     &     num_blocks,block_start,ref_2_asym_start,
     &     nobs,iobs,obs_start,
     &     ncomp,comp_numb,ref_2_asym,ref_2_symm,
     &     num_asym_ref,block_2_asym,
     &     ierr)

      deallocate(freer)
      deallocate(weights_b)
      deallocate(block_start)
      deallocate(ref_2_asym_start)
      deallocate(iobs)
      deallocate(obs_start)
      deallocate(comp_numb)
      deallocate(ref_2_asym)
      deallocate(ref_2_symm)
      deallocate(block_2_asym)
      deallocate(hl_abcd)
      deallocate(hkl_asym)
      deallocate(fpart)
      deallocate(fcalc)

      return
      end

      subroutine d2da_radial_twin(nasym,hkl_asym,d2fda2,nmodel)
      implicit none
      integer nasym,nmodel
      include 'weights.fh'
      integer hkl_asym(3,nasym)
      real d2fda2(nasym)
c
      integer, allocatable :: nind(:)
      real, allocatable :: phase(:)
c
      integer hmax,kmax,lmax
      common /hkllim/hmax,kmax,lmax      
      integer i
c
c---  body
      hmax = maxval(abs(hkl_asym(1,1:nasym)))+1
      kmax = maxval(abs(hkl_asym(2,1:nasym)))+1
      lmax = maxval(abs(hkl_asym(3,1:nasym)))+1

c      write(*,*)hmax,kmax,lmax
c      stop
      allocate(nind(nasym))
      allocate(phase(nasym))
      phase(1:nasym) = abs(0.1*d2fda2(1:nasym))
      do i=1,nasym
         call pack(nind(i),hkl_asym(1,i),hkl_asym(2,i),hkl_asym(2,i))
      enddo
      call d2da_radial(nasym,nind,nmodel,d2fda2,phase)
      deallocate(nind)
      deallocate(phase)

      return
      end
c
      subroutine solvent_twin(nasym,ndens,nmodel,hkl_asym,fsolvent)
      implicit none
      INCLUDE 'atom_com.fh'
      include 'models.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'monitor.fh'
      include 'solvent.fh'
      include 'rharvest.fh'
c
      integer nasym
      integer hkl_asym(3,nasym)
      real fsolvent(2,nasym,1)
c
      integer ndens
      real, allocatable :: den(:,:,:,:)
      real, allocatable :: pool(:)
      integer, allocatable :: nind(:)
      real,   allocatable :: occup_save(:,:,:)
c
      integer nmfour,ngx,ngy,ngz
      integer ia
      integer hmax,kmax,lmax
      common /hkllim/hmax,kmax,lmax
      logical save,restore
      parameter (save=.true.)
      parameter (restore=.false.)
c
      integer i,nmodel,im,natom_im,nanom
      real tmp1,tmp2
c
      nx = 0
      ny = 0
      nz = 0
      call get_grid_spacing(fshann,ngx,ngy,ngz,hmax,kmax,lmax)
      call asylim_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,ipx,ipy,ipz,nmfour)
      hmax = maxval(abs(hkl_asym(1,1:nasym)))+1
      kmax = maxval(abs(hkl_asym(2,1:nasym)))+1
      lmax = maxval(abs(hkl_asym(3,1:nasym)))+1
      n1 = nx
      n2 = ny
      n3 = nz/ipz
      if(ipz.gt.1) n3 = n3 + 1
c
      nanom=0
      allocate(occup_save(n_atom_mod_max,nmodel,nanom+1))
      call saveinit_restore_occ_for_excl(save,nmodel,n_atom_mod_max,
     &  nanom,occup_save,1.)
      call set_hkon_flags(nmodel)
      allocate(den(n1,n2,n3,nmodel))
      call mask_init(den(1:n1,1:n2,1:n3,1:nmodel))
      call solvent_mask(den(1:n1,1:n2,1:n3,1:nmodel))
      call prot_shrink(den(1:n1,1:n2,1:n3,1:nmodel))
      call saveinit_restore_occ_for_excl(restore,nmodel,n_atom_mod_max,
     &  nanom,occup_save,1.)
      call set_hkon_flags(nmodel)
      call write_solvent_mask(den(1:n1,1:n2,1:n3,1:nmodel))

      call redalli(n1,n2,n3,nx,ny,nz,ndens,rotr,trr,NonCubSym,den)
      allocate(nind(nasym))
      do i=1,nasym
         call pack(nind(i),hkl_asym(1,i),hkl_asym(2,i),hkl_asym(3,i))
      enddo
      call rfft(nasym,ndens,den,fsolvent(1:1,1:nasym,1:1),
     &     fsolvent(2:2,1:nasym,1:1),nind)
      deallocate(den)
      call process_solvent(nasym,ndens,nind,fsolvent(1:1,1:nasym,1:1),
     &     fsolvent(2:2,1:nasym,1:1))
      deallocate(nind)
c
      do i=1,nasym
         tmp1 = fsolvent(1,i,1)*cos(fsolvent(2,i,1))
         tmp2 = fsolvent(1,i,1)*sin(fsolvent(2,i,1))
         fsolvent(1,i,1) = tmp1
         fsolvent(2,i,1) = tmp2
      enddo
      if(ncycle_overall.le.0) then
        SCALE_LS_PART_REFINE_FLAG(NPART) = SCALE_LS_SOLVENT_MASK_FLAG
        B_LS_PART_REFINE_FLAG(NPART)     = B_LS_SOLVENT_MASK_FLAG
        SCALE_LS_PART(NPART)             = SCALE_LS_SOL_M
        B_LS_PART(NPART)                 = B_LS_SOL_M
      ENDIF
c
c---  resotore atom occupancies
      call saveinit_restore_occ_for_excl(restore,nmodel,n_atom_mod_max,
     &  nanom,occup_save,1.)
      deallocate(occup_save)
      nx = 0
      ny = 0
      nz = 0
      return
      end
c
      subroutine fs_from_crd(nasym,ndens,nmodel,hkl_asym,fcalc)
      implicit none
      include 'atom_com.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'monitor.fh'
      include 'solvent.fh'
      include 'rharvest.fh'

      integer nasym,ndens,nmodel
      integer hkl_asym(3,nasym)
      real fcalc(2,nasym,ndens)

c
      real, allocatable :: den(:,:,:,:)
      integer, allocatable :: nind(:)
c
      integer i,ir,ia
      integer nmfour,ngx,ngy,ngz
      integer hmax,kmax,lmax
      common /hkllim/hmax,kmax,lmax
      real grid_max,umin_req,umin_loc,umax_loc
      real b_add_loc
      real pisq81
      real tmp1,tmp2
      logical add,remove
      parameter (add = .true.)
      parameter (remove = .false.)
c
      real ss
      real lstlsq_r
      external lstlsq_r
c
c---- body
      ny = 0
      nz = 0
      call get_grid_spacing(fshann,ngx,ngy,ngz,hmax,kmax,lmax)
      call asylim_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,ipx,ipy,ipz,nmfour)
      hmax = maxval(abs(hkl_asym(1,1:nasym)))+1
      kmax = maxval(abs(hkl_asym(2,1:nasym)))+1
      lmax = maxval(abs(hkl_asym(3,1:nasym)))+1
c      write(*,*)hmax,kmax,lmax
c      write(*,*)minval(hkl_asym(1,1:nasym))+1
c      write(*,*)minval(hkl_asym(2,1:nasym))+1
c      write(*,*)minval(hkl_asym(3,1:nasym))+1
c      stop
      n1 = nx
      n2 = ny
      n3 = nz/ipz
      if(ipz.gt.1) n3 = n3 + 1
      pisq81 = 8.0*(4.0*atan2(1.0,1.0))**2
      call find_u_extremes(umin_loc,umax_loc,nmodel)
      grid_max = amax1(CS_CELL(1)/real(NX),amax1(CS_CELL(2)/real(NY),
     &                 CS_CELL(3)/real(NZ)))
      umin_req = grid_max*grid_max/1.1
c      umin_req = grid_max*grid_max*0.90909090909090909
      if(umin_loc.le.0) then
         call errwrt(0,'Problem with negative B')
      endif
C
C---If u values are too small then add some value to all atoms to avoid
      u_add_loc = 0.0
      if(umin_req.gt.umin_loc) then
        u_add_loc = umin_req - umin_loc
c        write(*,*)u_add_loc
c???   was this setting to 0 just for debugging maybe? P.
c        u_add_loc = 0.0
        call add_remove_uaddloc_from_atoms(add,nmodel,u_add_loc)
      endif
c      stop
      b_add_loc = u_add_loc*pisq81
      allocate(den(n1,n2,n3,ndens))
      call densty(n1,n2,n3,ndens,nmodel,den)
      call redalli(n1,n2,n3,nx,ny,nz,ndens,rotr,trr,NonCubSym,den)
      allocate(nind(nasym))
      do i=1,nasym
         call pack(nind(i),hkl_asym(1,i),hkl_asym(2,i),hkl_asym(3,i))
      enddo
      call rfft(nasym,ndens,den,fcalc(1:1,1:nasym,1:1),
     &     fcalc(2:2,1:nasym,1:1),nind)
      deallocate(nind)
      deallocate(den)
c
      do i=1,nasym
         ss = lstlsq_r(1,hkl_asym(1:3,i))
         fcalc(1,i,1) = fcalc(1,i,1)*exp(ss*b_add_loc)
         tmp1 = fcalc(1,i,1)*cos(fcalc(2,i,1))
         tmp2 = fcalc(1,i,1)*sin(fcalc(2,i,1))
         fcalc(1,i,1) = tmp1
         fcalc(2,i,1) = tmp2
      enddo
      
C
C--Now remove added b values from Fs
      call add_remove_uaddloc_from_atoms(remove,nmodel,u_add_loc)
      return
      end
c
      subroutine grads_from_fs_twin(nasym,ndens,nmodel,hkl_asym,dfdab,
     &     gx,gu,gq,gu_anom,gq_anom)
      implicit none
      include 'atom_com.fh'
      INCLUDE 'celsym.fh'
      INCLUDE 'refi_flags.fh'
      INCLUDE 'agreem.fh'
      INCLUDE 'const.fh'
      INCLUDE 'vitals.fh'
      INCLUDE 'monitor.fh'
      include 'solvent.fh'
      include 'rharvest.fh'
      integer nasym,ndens,nmodel
      integer hkl_asym(3,nasym)
      real dfdab(2,nasym,ndens)
      real gx(*),gu(*),gq(*),gu_anom(*),gq_anom(*)

c
      real, allocatable :: den(:,:,:,:)
      integer, allocatable :: nind(:)
c
      integer ipp,nmfour
      integer hmax,kmax,lmax
      common /hkllim/hmax,kmax,lmax
      integer ngx,ngy,ngz
      integer i,ir,ia
      integer ihh(3)
      real grid_max,umin_req,umin_loc,umax_loc,rsq,fshann_l
      real b_add_loc
      real tmp1,tmp2
      logical add,remove
      parameter (add = .true.)
      parameter (remove = .false.)
c
      integer hhh(3)
      real lstlsq_r
      external lstlsq_r
c
c---grids and so on
c
c--Sort out grids and additional b values if needed.
c      write(*,*)'in grads_from'
c      do i=1,100
c         write(*,*)dfdab(1:2,i,1)
c      enddo
c      stop
      pisq8 =128.0*(atan2(1.0,1.0))**2
      call find_u_extremes(umin_loc,umax_loc,nmodel)
      fshann_l = fshann
      call get_grid_spacing(fshann_l,ngx,ngy,ngz,hmax,kmax,lmax)
      call asylim_r(maxnso,cs_nsym,cs_m_cs,cs_v_cs,IPX,IPY,IPZ,NMFOUR)
      hmax = maxval(abs(hkl_asym(1,1:nasym)))+1
      kmax = maxval(abs(hkl_asym(2,1:nasym)))+1
      lmax = maxval(abs(hkl_asym(3,1:nasym)))+1
      n1 = nx
      n2 = ny
      n3 = nz/ipz
c      write(*,*)nx,ny,nz,n1,n2,n3,ipz
c      write(*,*)hmax,kmax,lmax
      if(ipz.gt.1) n3 = n3 + 1
      grid_max = amax1(CS_CELL(1)/real(NX),amax1(CS_CELL(2)/real(NY),
     &                 CS_CELL(3)/real(NZ)))
      umin_req = grid_max*grid_max/1.1
c      umin_req = grid_max*grid_max*0.90909090909090909
      if(umin_loc.le.0) then
         call errwrt(0,'Problem with negative B')
      endif
C
C---If u values are too small then add some value to all atoms to avoid
      u_add_loc = 0.0
      if(umin_req.gt.umin_loc) then
        u_add_loc = umin_req - umin_loc
c???   was this just for debugging maybe? P.
        u_add_loc = 0.0
        call add_remove_uaddloc_from_atoms(add,nmodel,u_add_loc)
      endif
      b_add_loc = u_add_loc*pisq8
      if (b_add_loc.ne.0.) then
        do  ir=1,nasym
           rsq = lstlsq_r(1,hkl_asym(1:3,ir))
           do i=1,ndens
              dfdab(1:2,ir,i) =dfdab(1:2,ir,i)*exp(rsq*b_add_loc)
c              if(ir.le.100) write(*,*)dfdab(1:2,ir,1)
           enddo
        enddo
      endif
c      stop
      allocate(nind(nasym))
      allocate(den(n1,n2,n3,1))
c      write(*,*)'In grads',n1,n2,n3,hmax,kmax,lmax
      do ir=1,nasym
         call pack(nind(ir),hkl_asym(1,ir),hkl_asym(2,ir),
     &        hkl_asym(3,ir))
         do i=1,ndens
            tmp1 = -sqrt(dfdab(1,ir,i)**2+dfdab(2,ir,i)**2)
            tmp2 = 0.0
            if(tmp1.lt.0.0) then
               tmp2 = atan2(dfdab(2,ir,i),dfdab(1,ir,i))
            endif
c            write(*,*)tmp1,tmp2
            dfdab(1,ir,i) = tmp1
            dfdab(2,ir,i) = tmp2
         enddo
c         if(i.le.10) write(*,*)dfdab(1,i,ndens)
      enddo
c      stop
      ipp = 0
c      do i=1,100
c         write(*,*)dfdab(1:2,i,1)
c      enddo
c      write(*,*)'to fft'
      call fft(nasym,ndens,den,dfdab(1:1,1:nasym,1:1),
     &     dfdab(2:2,1:nasym,1:1),nind,ipp)
c      write(*,*)maxval(den(1:n1,1:n2,1:n3,1:ndens)),
c     &     minval(den(1:n1,1:n2,1:n3,1:ndens))
      deallocate(nind)
      gx(1:3*n_atom) = 0.0
      gu(1:6*n_atom) = 0.0
      gq(1:n_atom) = 0.0
      call grad_all(n1,n2,n3,ndens,nmodel,den,gx,gu,gq,gu_anom,gq_anom)
c      write(*,*)maxval(gx(1:3*n_atom)),maxval(gu(1:6*n_atom)),
c     &     maxval(gq(1:n_atom))
c      write(*,*)minval(gx(1:3*n_atom)),minval(gu(1:6*n_atom)),
c     &     minval(gq(1:n_atom))
c      write(*,*)maxval(gu_anom(1:6*n_atom)),minval(gq_anom(1:n_atom))
      deallocate(den)
c      stop
c
c---  Return b values
      call add_remove_uaddloc_from_atoms(remove,nmodel,u_add_loc)
      if (b_add_loc.ne.0.0) then
         do  ir=1,nasym
            ihh(1:3) = hkl_asym(1:3,ir)
            rsq = lstlsq_r(1,hkl_asym(1:3,ir))
            do i=1,ndens
               dfdab(1,ir,i) =dfdab(1,ir,i)*exp(-rsq*b_add_loc)
            enddo
         enddo
      endif
      return
      end
