C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C
      SUBROUTINE EMIN(MDOC,NAMEC,RNAMER,RNAMEV,RNAMES,NAMET
     * ,NAMEO,RNAMEG,RNAMEI,NCYCLER,SLIMR,REFR,RESOLR
     * ,PROG_LIB_PATH,LIBS_PATH,LIBS_NAME,LIBS_EXT,PROG_NAME
     * ,ITEST,LIST,IERR)
C ----------------------------------------------------------
C
C                   ---  ENERGY MINIMIZATION ---
C                                             /Vers 1.5 22.04.2000/
C
C     EMIN     - energy minimization / or B_factor regularization / 
C                minimizes the energy of structure using the restraints files
C                from program MAKECIF.
C 
C                E_total = E_bond + E_angle + E_tors + E_vdw + E_hb
C                                 
C                          E_bond  = Sum ( Kb * (Bobs     -Bidl)**2    )
C                          E_angle = Sum ( Ka * (ANGLEobs -ANGLEidl)**2)
C                          E_tors  = Sum ( Kt * (PHIobs   -PHIidl)**2  )
C                          E_vdw   = Lennard-Jones 6-12 potential
C                          E_bond  = 10-12 potential
C
C       It is possible to use subroutine EMIN instead of program.
C       Use all subroutines without "main_emin.f" which just
C       prepares parameters for subroutine "emin".
C
C        SUBROUTINE EMIN(MDOC,NAMEC,RNAMER,RNAMEV
C     *     ,NAMEO,RNAMEG,RNAMEI,NCYCLER,SLIMR,REFR,RESOLR,IERR)
C 
C      input parameters:
C
C         MDOC         -  =999 with  DOC-file: "emin.doc",  
C                        if = -999 without this file.
C                        It must be 999 or -999 !!!!
C
C  NAMEC  :    input file of coordinates
C  RNAMER :    input file of restraints / from MAKECIF program/
C  RNAMEV : < > input file /VDW_restraints/  , " " means without this file
C  NAMEO  : <emin.crd> output CIfile /crd/ 
C  RNAMEG : <emin_grd.crd> output file of gradients
C  RNAMEI : <emin_ind.crd> output file of inform. about gradients
C  NCYCLER:  <10> - max number of function calculation
C  REFR   :  <E>/T - E_energy minimization , Thermal factor regularization
C  SLIM   :  <0.0> - level of messages. if abs(Videal-Vobs)/SIG > SLIM ,
C                  the information about restraints will be written to DOC_file
C  RESOL  :   dummy
C
C      output:
C
C         IERR          - signal of error, 0 means OK.
C ---
C      INTEGER     MDOC,IERR,NCYCLER
C      CHARACTER   NAMEC*(*),RNAMER*(*),RNAMEV*(*),REFR*1
C      CHARACTER   NAMEO*(*),RNAMEG*(*),RNAMEI*(*)
C      REAL        SLIMR
C ---
C ---------------------------------------------------------------------
C   Create directories:   blanc/make
C                         blanc/dic
C                         blanc/exe
C
C   For compilation you need to have 11 files in the same directory blanc/make:
C
C      atom_com.fh - include file with control memory parameters
C      crd_com.fh  - include file with description common blocks /CR.. /
C      lib_com.fh  - include file with description common blocks /Lib../
C      
C      CIF_com.fh
C      rstr_com.fh
C      main_emin.f - main program.
C      emin.f      - subroutines
C      emin_subr.f
C      make_subr.f -  ...
C      makefile
C
C   Compilation's command for UNIX:
C                             make emin
C                 programs would be in blanc/exe
C 
C    Program uses the file:  blanc/dic/symlib.blc
C    
C    don't foget set command: "setenv BLANC <path_to_blanc_dir>"
C 
C ==================================================================
C ----------------------------------------------------------
C  FILE_C:    input file of coordinates
C  FILE_R:    input file of restraints / from MAKECIF program/
C  FILE_V: < > input file /VDW_restraints/  , " " means without this file
C  FILE_O: <emin.crd> output CIfile /crd/ 
C  FILE_G: <emin_grd.crd> output file of gradients
C  FILE_I: <emin_ind.crd> output file of inform. about gradients
C  NC:     <10> - max number of function calculation
C  REF:    <E>/T - E_energy minimization , Termal factor regularization
C  SLIM:   <0.0> - level of messages. if abs(Videal-Vobs)/SIG > SLIM ,
C                   the information about restraints will be written to DOC_file
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'ref_com.fh'
C --------------------------------------------------------------
      COMMON/REF_NAMES_E/ SLIM,NAMER,NAMEV,NAMEG,NAMEI
      CHARACTER NAMER*80,NAMEV*80,NAMEG*80,NAMEI*80
      REAL      SLIM
C ---------------------------------------------------------------
      INTEGER     MDOC,IERR,NCYCLER
      CHARACTER   NAMEC*(*),RNAMER*(*),RNAMEV*(*),REFR*1,LIST*1
      CHARACTER   NAMEO*(*),RNAMEG*(*),RNAMEI*(*),NAMET*(*),RNAMES*(*)
      REAL        SLIMR
C ----------------------------------------------------------------
      INTEGER*2 ISYM(5,3,1)
      REAL      POOL(1)
      CHARACTER PROG_LIB_PATH*80,PROG_NAME*80
      CHARACTER LIBS_PATH*(*),LIBS_NAME*(*),LIBS_EXT*(*)
C ----------------------------------------------------------------
      CHARACTER LINE*256,PATH*80,EXT*80
      INTEGER*4 NOSPGR_INPUT
      REAL      CELL_INPUT(6)
C     CHARACTER PROG*80
C==================================================================
C ---
      INCLUDE 'emin_version.fh'
C -----------------------------------------------
      IERR = 0
      NOSPGR_INPUT = 0
      DO I=1,6
        CELL_INPUT(I) = 0.0
      ENDDO
C     PROG = 'emin'
C -----------------------------
      CALL SET_PATH_PROG_PARM(PROG_LIB_PATH,PROG_NAME
     *                         ,LIBS_PATH,LIBS_NAME,LIBS_EXT)
C ------------------------------
      IF(ABS(MDOC).GE.997) THEN
        MDOC_C=1
        IF(MDOC.LT.0) THEN
          MDOC=0
        ELSE      
C   
C         MDOC=999
C         IF(MSG.EQ.'Y') MDOC=999 do not keep old contents
C         IF(MSG.EQ.'A') MDOC=998 keep old contents
C         IF(MSG.EQ.'#') MDOC=997 batch mode, "_DOC " will be read
C          
C         for subroutine case:
C
C         MDOC=999 do not keep old contents
C         MDOC=998 keep old contents
C
C         MDOC=-999 without DOC-file
C
        ENDIF
        CALL START(0,MDOC,PROG_NAME)
      ELSE
        MDOC_C=0
      ENDIF
C ---------------------------
      IF(MDOC.GT.0) THEN
        M=-1
        CALL MSGDOC(M,' ')
        CALL MSGDOC(M,VERSION)
        CALL MSGDOC(M,' ')
      ENDIF
      CALL CLOSE_BATCH(M)
C --------------------------
      MD  = -ABS(MDOC)-1
      M   = 99
C ---
      IF(SLIMR  .LE.0.0) SLIMR   =-0.01  
      IF(NCYCLER.LE.0  ) NCYCLER = 10
C     NAMER=NAMEC
C --------
      CALL LENSTR_BL(RNAMEG,LEN)
      IF(LEN.LE.0.OR.RNAMEG(1:1).EQ.','.OR.RNAMEG(1:1).EQ.' ') THEN 
        RNAMEG='emin_grd.crd'
      ENDIF
      CALL LENSTR_BL(RNAMEI,LEN)
      IF(LEN.LE.0.OR.RNAMEI(1:1).EQ.','.OR.RNAMEI(1:1).EQ.' ') THEN 
        RNAMEI='emin_ind.crd'
      ENDIF
C -------
      CR_SEGFLAG = 'N'
      EXT  = ' '
      PATH = ' '
      CALL MSGDOC(MDOC,' --- read CRD_file  ---')
      IERR = 0
      CALL READ_ATOMS(MDOC,PATH,NAMEC,EXT
     *               ,NOSPGR_INPUT,CELL_INPUT,IERR)
      IF(IERR.GE.7) IERR = 0
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: READ INPUT_FILE /crd/ ..')
        GO TO 100
      ENDIF

C      CALL LENSTR_BL(RNAMES,LEN)
C      IF(LEN.NE.0.AND.RNAMES(1:1).NE.','.AND.RNAMES(1:1).EQ.' ') THEN 
C        REFR = 'S'
C        CALL READ_STR(MDOC,PATH,RNAMES,EXT,IERR)
C        IF(IERR.NE.0) THEN
C          CALL MSGERR(MDOC,' ERR: READ INPUT_FILE /str/ ..')
C          GO TO 100
C        ENDIF
C      ENDIF
       
      N_PHI = 0
      DO I=1,N_ATOM
        IPOINTER_VAR(I) = 1
      ENDDO
C --------
      MEMORY  = 1
      NCRDMAX = 1
      IPRSYM  = 1
      NSYM    = 1
      NCYCLE  = NCYCLER
      ICYCLE  = 0
      SLIM    = 100.
      NAMEG   = RNAMEG
      NAMEI   = RNAMEI
      NAMER   = RNAMER
      NAMEV   = RNAMEV
      NFUNCT  = 0
      NSTEP   = 0
      NGRAD   = 0
      NBACK   = 0
      NSHAKE  = 0
      WEIGHT  = 1.0
      IDEBUG  = 0
      IF(REFR.EQ.'t') REFR = 'T'
      IF(REFR.NE.'T') REFR = 'E'
c      IF(REFR.EQ.'s') REFR = 'S'
c      IF(REFR.NE.'T'.AND.REFR.NE.'S') REFR = 'E'
      REF     = REFR
      IF(LIST.EQ.'l') LIST = 'L' 
      IF(LIST.EQ.'t') LIST = 'T' 
      IF(LIST.NE.'L'.AND.LIST.NE.'T') LIST = 'S'
      MOD_E   = 'N'
C     MOD_E   = '2'
      MOD_D   = ' '
      MOD_R   = 'N'
      IF(RESOLR.LE.0.0) RESOLR = 1.0
      RESOL     = RESOLR
      SHIFT_LIM = 0.5
      SHIFT_MIN = 0.0
      SHIFT_SHK = 0.0
c      IF(REF.EQ.S) THEN
c        CALL TREE_INITIALIZATION(MDOC,IERR)
c        IF(IERR.NE.0) GO TO 100
c        CALL TREE_BOND_INIT(MDOC,IERR)
c        IF(IERR.NE.0) GO TO 100
c      ENDIF
C ---
      CALL MSGDOC(MDOC,' --- minimization ---')
      CALL GET_RESTR(MDOC,ITEST,IERR)
      IF(IERR.NE.0) GO TO 100
      CALL M_MIN(MDOC,LIST,POOL,MEMORY,NCRDMAX,NSYM,ISYM,IPRSYM,IERR)
      IF(IERR.NE.0) GO TO 100
      SLIM   = SLIMR
      CALL EE_FUNCT(MDOC,LIST,IERR)
      IF(IERR.NE.0) GO TO 100
C ------------------------------------------------------------
      EXT = ' '
      CALL LENSTR_BL(NAMEO,LEN)
      IF(LEN.LE.0.OR.NAMEO(1:1).EQ.','.OR.NAMEO(1:1).EQ.',') THEN
        NAMEO='emin.crd'
        EXT=' '
      ENDIF
      CALL WR_REF_COOR(MDOC,NAMEO,EXT,IERR)
      IF(IERR.NE.0) GO TO 100
C ---
      CALL E_WRT_I(MDOC,IERR)
      IF(IERR.NE.0) THEN
        GO TO 100
      ENDIF
C --------------------------------------
 100  CONTINUE
      IF(MDOC_C.EQ.1) CALL FINISH
      RETURN
      END

      SUBROUTINE D_FUNCT(MDOC,POOL,MEMORY,NCRDMAX
     *   ,NSYM,ISYM,IPRSYM,IERR)
C ---------------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C ----------------------------------------------------------------
      INTEGER*2 ISYM(5,3,IPRSYM)
      REAL      POOL(MEMORY)
C ---------------------------------------------------------------
      INTEGER     MDOC,IERR
C ----------------------------------------------------------------
      TFUNCT_D = 0.0
      GGRAD_2D = 0.0
      BETAG    = 0.0
      RETURN
      END


      SUBROUTINE GET_RESTR(MDOC,ITEST,IERR)
C --------------------------------------------------------
      INCLUDE 'crd_com.fh'
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
      INCLUDE 'ener_com.fh'
C --------------------------------------------------------------
      INTEGER     MDOC,IERR,RS_NUM_OLD
      CHARACTER   LINE*256,EXT*80,PATH*80
      CHARACTER   C_LINE*256
C ----------------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C --------
      IFLAG  = 0
      C_LINE = ' '
C --------
      IF(N_ATOM.LE.1) THEN
        CALL MSGERR(MDOC,'ERROR: number of atoms < 2')
        IERR=1
        RETURN
      ENDIF
C --------
C     IN   = 10
      IN   = CRR_IUN
      EXT  = ' '
      PATH = ' '
      CALL ORRST_CIF(MD,IN,PATH,NAMER,EXT,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: OPEN INPUT_FILE /rst/')
        RETURN
      ENDIF
C --------
      NR_BOND     = 0
      NR_ANGL     = 0
      NR_TORS     = 0
      NR_CHIR     = 0
      NR_PLAN     = 0
      RS_NUM_OLD  = -1
      IEND        = -1
C --------------------------------
 200  CONTINUE
      CALL RDRST_CIF(M,IN,MODE,IEND,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: READ INPUT_FILE /rst/')
        RETURN
      ENDIF
      IF(IEND.NE.0) GO TO 300
  
      IF(MODE.EQ.0) THEN

        IA1 = RS_IA1
        IA2 = RS_IA2
        IA3 = RS_IA3
        IA4 = RS_IA4

C  ITEST: 1 only BOND, 2 only ANGLE, 3 only BOND and ANGLE, 4 only VDW and HB
C         5 only tors,  6 onli chir, 7 only plan    
C  ITEST < 0 whitout VDW (REF=S)  

        IF(RS_NAME.EQ.'BOND'.AND.ITEST.NE.4.AND.
     *     (ITEST.EQ.0.OR.ITEST.EQ.1.OR.ITEST.EQ.3)) THEN

          CALL GET_BOND_EMIN(MDOC,RS_NAME,NR_BOND,RS_LABEL,IA1,IA2
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,C_LINE,IFLAG,IERR)
           IF(IERR.NE.0) RETURN

        ELSE IF(RS_NAME.EQ.'ANGL'.AND.ITEST.NE.4.AND.
     *     (ITEST.EQ.0.OR.ITEST.EQ.2.OR.ITEST.EQ.3)) THEN

          CALL GET_ANGLE_EMIN(MDOC,RS_NAME,NR_ANGL
     *     ,RS_LABEL,IA1,IA2,IA3
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,C_LINE,IFLAG,IERR)
           IF(IERR.NE.0) RETURN

        ELSE IF(RS_NAME.EQ.'TORS'.AND.ITEST.NE.4.AND.
     *     (ITEST.EQ.0.OR.ITEST.EQ.5)) THEN

          CALL GET_TORS_EMIN(MDOC,RS_NAME,NR_TORS,RS_LABEL
     *     ,IA1,IA2,IA3,IA4
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_PRD,RS_CNS
     *     ,C_LINE,IFLAG,IERR)
           IF(IERR.NE.0) RETURN

        ELSE IF(RS_NAME.EQ.'CHIR'.AND.ITEST.NE.4.AND.
     *     (ITEST.EQ.0.OR.ITEST.EQ.6)) THEN

          CALL GET_CHIR_EMIN(MDOC,RS_NAME,NR_CHIR,RS_LABEL
     *     ,IA1,IA2,IA3,IA4
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,C_LINE,IFLAG,IERR)
           IF(IERR.NE.0) RETURN

        ELSE IF(RS_NAME.EQ.'PLAN'.AND.ITEST.NE.4.AND.
     *     (ITEST.EQ.0.OR.ITEST.EQ.7)) THEN

          CALL GET_PLAN_EMIN(MDOC,RS_NAME,NR_PLAN,RS_LABEL
     *     ,RS_NUM,RS_NUM_OLD,IA1
     *     ,RS_VIDL,RS_VOBS
     *     ,C_LINE,IFLAG,IERR)
           IF(IERR.NE.0) RETURN

        ENDIF

        RS_NUM_OLD = RS_NUM

      ELSE

C       CR_LINE - string of comments 
c        IF(IFLAG.GT.0) THEN
c          CALL MSGDOC(MD,C_LINE)
c        ENDIF
        C_LINE = CR_LINE
        IFLAG  = 0

      ENDIF      
C ----
      GO TO 200
C --------------------------------------
 300  CONTINUE
C------------------------------ --------
      IFLAG_VDW = 0
      IFLAG_HB  = 0
      NR_VDW    = 0
      NR_HB     = 0
      CALL LENSTR_BL(NAMEV,LEN)
      IF(LEN.LE.0.OR.NAMEV(1:1).EQ.','.OR.NAMEV(1:1).EQ.' ') GO TO 500
C     IN   = 10
      IN   = CRV_IUN
      EXT  = ' '
      PATH = ' ' 
      CALL ORVDW_CIF(MD,IN,PATH,NAMEV,EXT,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: OPEN INPUT_FILE /vdw/')
        RETURN
      ENDIF
C --------
      IF(ITEST.NE.0.AND.ITEST.NE.4) GO TO 500

      RSV_NUM_OLD = -1
      IEND        = -1
C --------------------------------
 400  CONTINUE
      CALL RDVDW_CIF(M,IN,MODE,IEND,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: READ INPUT_FILE /vdw/')
        RETURN
      ENDIF
      IF(IEND.NE.0) GO TO 500
  
      IF(MODE.EQ.0) THEN

        IA1 = RSV_IA1
        IA2 = RSV_IA2

        IF(RSV_NAME.EQ.'VDW '.AND.IFLAG_VDW.EQ.0) THEN

          CALL GET_VDW_EMIN(MDOC,RSV_NAME,NR_VDW,RSV_SYMM
     *      ,IA1,IA2
     *      ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *      ,C_LINE,IFLAG,IERR)
          IF(IERR.NE.0) THEN
            IFLAG_VDW = 1
            IERR      = 0
          ENDIF
        ELSE IF(RSV_NAME.EQ.'HB  '.AND.IFLAG_HB.EQ.0) THEN

          CALL GET_HB_EMIN(MDOC,RSV_NAME,NR_HB,RSV_SYMM
     *      ,IA1,IA2
     *      ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *      ,C_LINE,IFLAG,IERR)
          IF(IERR.NE.0) THEN
            IFLAG_HB = 1
            IERR     = 0
          ENDIF

        ENDIF

        RSV_NUM_OLD = RSV_NUM

      ELSE

C       CR_LINE - string of comments 
c        IF(IFLAG.GT.0) THEN
c          CALL MSGDOC(MD,C_LINE)
c        ENDIF
        C_LINE = CR_LINE
        IFLAG  = 0

      ENDIF      
C ----
      GO TO 400
C --------------------------------------
 500  CONTINUE
C ---
      CALL MSGDOC(MDOC,'----- ')
      WRITE(LINE,'('' Number of bond restraints    :'',I8)') 
     *NR_BOND
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of angle restraints   :'',I8)') 
     *NR_ANGL
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of torsion restraints :'',I8)') 
     *NR_TORS
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of chiralities        :'',I8)') 
     *NR_CHIR
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of planar groups      :'',I8)') 
     *NR_PLAN
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of VDW_contacts       :'',I8)') 
     *NR_VDW
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'(''           H_bonds            :'',I8)') 
     *NR_HB 
      CALL MSGDOC(MDOC,LINE)
C ---
      CALL MSGDOC(MDOC,'----- ')
C --------------------------------------
      RETURN
      END


      SUBROUTINE EE_FUNCT(MDOC,LIST,IERR)
C --------------------------------------------------------
      INCLUDE 'crd_com.fh'
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
      INCLUDE 'ref_com.fh'
C ----------------------------------------------------------------
      INCLUDE 'ener_com.fh'
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR,RS_NUM_OLD
      CHARACTER   LINE*256,EXT*3,LINE_OLD*256,LIST*1
C ---
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
      CHARACTER   CH3*1,ATOM3*4,ALT3*1,IRES3*4,RES3*8
      CHARACTER   CH4*1,ATOM4*4,ALT4*1,IRES4*4,RES4*8
      REAL        RMS_B
      INTEGER     NB_GT_1S,NB_GT_3S,NB_GT_10S
      REAL        RMS_A
      INTEGER     NA_GT_1S,NA_GT_3S,NA_GT_10S
      REAL        RMS_T
      INTEGER     NT_GT_1S,NT_GT_3S,NT_GT_10S
      REAL        RMS_C
      INTEGER     NC_GT_1S,NC_GT_3S,NC_GT_10S
      REAL        RMS_P
      INTEGER     NP_GT_1S,NP_GT_3S,NP_GT_10S
      CHARACTER   C_LINE*256
C ---------------------------------------------------------------
      PARAMETER  (MAXAPLN = 100)
      INTEGER     NA_PLAN,PL_IATOM (MAXAPLN)
      CHARACTER   PL_LABEL*8
      CHARACTER   PL_ATOM  (MAXAPLN)*4
      CHARACTER   PL_ALT   (MAXAPLN)*1
      REAL        PL_DEL(MAXAPLN),PL_DOBS(MAXAPLN),PL_SD(MAXAPLN)
CC ----------------------------------------------------------------
      IERR= 0
      MD  =-ABS(MDOC)-1
      M   = 99
      MDD = MD
      IF(ABS(MDOC).EQ.2.OR.ABS(MDOC).EQ.3) MDD=99      
      IF(ABS(MDOC).EQ.3) MD =99
      IF(LIST.EQ.'T') THEN
        MD  =-ABS(MDOC)-1
        MDD = MD
      ENDIF 
C --------
      IFLAG    = 0
      C_LINE   = ' '
      LINE_OLD = '?'
C --------
      WT_BOND  = 1.0
      WT_ANGLE = 1.0
      WT_TORS  = 1.0
      WT_VDW   = 1.0
      WT_HB    = 1.0
C --------------
      NB_GT_1S  = 0
      NB_GT_3S  = 0
      NB_GT_10S = 0
      RMS_B     = 0.0
C --------
      NA_GT_1S  = 0
      NA_GT_3S  = 0
      NA_GT_10S = 0
      RMS_A     = 0.0
C --------
      NT_GT_1S  = 0
      NT_GT_3S  = 0
      NT_GT_10S = 0
      RMS_T     = 0.0
C --------
      NC_GT_1S  = 0
      NC_GT_3S  = 0
      NC_GT_10S = 0
      RMS_C     = 0.0
C --------
      NP_GT_1S  = 0
      NP_GT_3S  = 0
      NP_GT_10S = 0
      RMS_P     = 0.0
C --------
      IF(N_ATOM.LE.1) THEN
        CALL MSGERR(MDOC,'ERROR: number of atoms < 2')
        IERR=1
        RETURN
      ENDIF
C ----
      NR_ATOM            = 0
      ENER_TOTAL         = 0.0
      ENER_AVER          = 0.0
      ENER_RMS           = 0.0
      BOND_ENER_TOTAL    = 0.0
      BOND_ENER_AVER     = 0.0
      BOND_ENER_RMS      = 0.0
      ANGLE_ENER_TOTAL   = 0.0
      ANGLE_ENER_AVER    = 0.0
      ANGLE_ENER_RMS     = 0.0
      TORS_ENER_TOTAL    = 0.0
      TORS_ENER_AVER     = 0.0
      TORS_ENER_RMS      = 0.0
      VDW_ENER_TOTAL     = 0.0
      VDW_ENER_AVER      = 0.0
      VDW_ENER_RMS       = 0.0
      HB_ENER_TOTAL      = 0.0
      HB_ENER_AVER       = 0.0
      HB_ENER_RMS        = 0.0
      SHIFTE_AVER        = 0.0
      SHIFTE_RMS         = 0.0
      SHIFTE_MAX         = 0.0
      RLAP_AVER          = 0.0

      DO IA=1,N_ATOM
C        I_BLOCK    (  IA)  = 0
        BOND_DER   (1,IA)  = 0.0
        BOND_DER   (2,IA)  = 0.0
        BOND_DER   (3,IA)  = 0.0
        BOND_DER2  (  IA)  = 0.0
        BOND_ENER  (  IA)  = 0.0 
        ANGLE_DER  (1,IA)  = 0.0
        ANGLE_DER  (2,IA)  = 0.0
        ANGLE_DER  (3,IA)  = 0.0
        ANGLE_DER2 (  IA)  = 0.0
        ANGLE_ENER (  IA)  = 0.0 
        TORS_DER   (1,IA)  = 0.0
        TORS_DER   (2,IA)  = 0.0
        TORS_DER   (3,IA)  = 0.0
        TORS_DER2  (  IA)  = 0.0
        VDW_ENER   (  IA)  = 0.0 
        VDW_DER    (1,IA)  = 0.0
        VDW_DER    (2,IA)  = 0.0
        VDW_DER    (3,IA)  = 0.0
        VDW_DER2   (  IA)  = 0.0
        HB_ENER    (  IA)  = 0.0 
        HB_DER     (1,IA)  = 0.0
        HB_DER     (2,IA)  = 0.0
        HB_DER     (3,IA)  = 0.0
        HB_DER2    (  IA)  = 0.0
        HB_ENER    (  IA)  = 0.0 
      ENDDO
C --------
      NA_PLAN     = 0
      RS_NATOM    = 0
      RS_NBOND    = 0
      RS_NANGL    = 0
      RS_NTORS    = 0
      RS_NCHIR    = 0
      RS_NPLAN    = 0
      RS_NUM      = 0
      RS_NUM_OLD  = -1
CC --------------------------------
      IF(NR_BOND.GT.0) THEN
      DO I=1,NR_BOND
        
        IA1=RB_IA1(I)
        IA2=RB_IA2(I)
        IF(IA1.GT.0.AND.IA1.LE.N_ATOM) THEN
          IR     = I_RESID (IA1) 
          ICH    = I_CHAIN (IR) 
          CH1    = GROUP_ID(ICH)(1:1)
          ATOM1  = ATM_NAME(IA1)
          ALT1   = ID_ALT (IA1)
          IRES1  = RES_NUM_PDB(IR)(3:6)
          RES1   = RES_NAME(IR)
        ELSE
          CH1    = ' '
          ATOM1  = '    '
          ALT1   = ' '
          IRES1  = '    '
          RES1   = '    '
        ENDIF        
        IF(IA2.GT.0.AND.IA2.LE.N_ATOM) THEN
          IR     = I_RESID (IA2 ) 
          ICH    = I_CHAIN (IR) 
          CH2    = GROUP_ID(ICH)(1:1)
          ATOM2  = ATM_NAME(IA2)
          ALT2   = ID_ALT (IA2)
          IRES2  = RES_NUM_PDB(IR)(3:6)
          RES2   = RES_NAME(IR)
        ELSE
          CH2    = ' '
          ATOM2  = '    '
          ALT2   = ' '
          IRES2  = '    '
          RES2   = '    '
        ENDIF        
        RS_NAME = 'BOND'

        LINE_OLD = C_LINE
        WRITE(C_LINE,'(''# '',A,1X,A5,1X,A2,'' - '',A,1X,A5,1X,A2)')
     *  RES1,IRES1,CH1,RES2,IRES2,CH2  
        CALL LENSTR_BL(LINE_OLD,LEN1)
        CALL LENSTR_BL(C_LINE,LEN2)
        IFLAG = 0
        IF(LEN1.EQ.LEN2.AND.LINE_OLD.EQ.C_LINE) IFLAG=1
        
          CALL ENER_BOND(MDD,RS_NAME,RS_NBOND,RB_CHEM(I),IA1,IA2
     *     ,ATOM1,ALT1,ATOM2,ALT2
     *     ,RB_VIDL(I),RB_SDID(I),RB_VOBS(I),RB_CNST(I)
     *     ,RMS_B,NB_GT_1S,NB_GT_3S,NB_GT_10S,SLIM
     *     ,C_LINE,IFLAG,IERR)
           IF(IERR.NE.0) RETURN

      ENDDO
      ENDIF

      IF(NR_ANGL.GT.0.AND.(REF.EQ.'E'.OR.REF.EQ.'R'))THEN
      DO I=1,NR_ANGL
        IA1 = RA_IA1(I)
        IA2 = RA_IA2(I)
        IA3 = RA_IA3(I)
        IF(IA1.GT.0.AND.IA1.LE.N_ATOM) THEN
          IR     = I_RESID (IA1) 
          ICH    = I_CHAIN (IR) 
          CH1    = GROUP_ID(ICH)(1:1)
          ATOM1  = ATM_NAME(IA1)
          ALT1   = ID_ALT (IA1)
          IRES1  = RES_NUM_PDB(IR)(3:6)
          RES1   = RES_NAME(IR)
        ELSE
          CH1    = ' '
          ATOM1  = '    '
          ALT1   = ' '
          IRES1  = '    '
          RES1   = '    '
        ENDIF        
        IF(IA2.GT.0.AND.IA2.LE.N_ATOM) THEN
          IR     = I_RESID (IA2 ) 
          ICH    = I_CHAIN (IR) 
          CH2    = GROUP_ID(ICH)(1:1)
          ATOM2  = ATM_NAME(IA2)
          ALT2   = ID_ALT (IA2)
          IRES2  = RES_NUM_PDB(IR)(3:6)
          RES2   = RES_NAME(IR)
        ELSE
          CH2    = ' '
          ATOM2  = '    '
          ALT2   = ' '
          IRES2  = '    '
          RES2   = '    '
        ENDIF        
        IF(IA3.GT.0.AND.IA3.LE.N_ATOM) THEN
          IR     = I_RESID (IA3 ) 
          ICH    = I_CHAIN (IR) 
          CH3    = GROUP_ID(ICH)(1:1)
          ATOM3  = ATM_NAME(IA3)
          ALT3   = ID_ALT (IA3)
          IRES3  = RES_NUM_PDB(IR)(3:6)
          RES3   = RES_NAME(IR)
        ELSE
          CH3    = ' '
          ATOM3  = '    '
          ALT3   = ' '
          IRES3  = '    '
          RES3   = '    '
        ENDIF        


        LINE_OLD = C_LINE
        WRITE(C_LINE,'(''# '',A,1X,A5,1X,A2,'' - '',A,1X,A5,1X,A2
     *  ,'' - '',A3,1X,A5,1X,A2)')
     *  RES1,IRES1,CH1,RES2,IRES2,CH2,RES3,IRES3,CH3  
        CALL LENSTR_BL(LINE_OLD,LEN1)
        CALL LENSTR_BL(C_LINE,LEN2)
        IFLAG = 0
        IF(LEN1.EQ.LEN2.AND.LINE_OLD.EQ.C_LINE) IFLAG=1
        
        RS_NAME  = 'ANGL'
        RS_LABEL = ' '
          CALL ENER_ANGLE(MDD,RS_NAME,RS_NANGL,RS_LABEL
     *     ,IA1,IA2,IA3
     *     ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3
     *     ,RA_VIDL(I),RA_SDID(I),RA_VOBS(I),RA_CNST(I)
     *     ,RMS_A,NA_GT_1S,NA_GT_3S,NA_GT_10S,SLIM
     *     ,C_LINE,IFLAG,LIST,IERR)
           IF(IERR.NE.0) RETURN
      ENDDO
      ENDIF

      IF(NR_TORS.GT.0.AND.(REF.EQ.'E'.OR.REF.EQ.'R'))THEN
      DO I=1,NR_TORS
        IA1 = RT_IA1(I)
        IA2 = RT_IA2(I)
        IA3 = RT_IA3(I)
        IA4 = RT_IA4(I)
        IF(IA1.GT.0.AND.IA1.LE.N_ATOM) THEN
          IR     = I_RESID (IA1) 
          ICH    = I_CHAIN (IR) 
          CH1    = GROUP_ID(ICH)(1:1)
          ATOM1  = ATM_NAME(IA1)
          ALT1   = ID_ALT (IA1)
          IRES1  = RES_NUM_PDB(IR)(3:6)
          RES1   = RES_NAME(IR)
        ELSE
          CH1    = ' '
          ATOM1  = '    '
          ALT1   = ' '
          IRES1  = '    '
          RES1   = '    '
        ENDIF        
        IF(IA2.GT.0.AND.IA2.LE.N_ATOM) THEN
          IR     = I_RESID (IA2 ) 
          ICH    = I_CHAIN (IR) 
          CH2    = GROUP_ID(ICH)(1:1)
          ATOM2  = ATM_NAME(IA2)
          ALT2   = ID_ALT (IA2)
          IRES2  = RES_NUM_PDB(IR)(3:6)
          RES2   = RES_NAME(IR)
        ELSE
          CH2    = ' '
          ATOM2  = '    '
          ALT2   = ' '
          IRES2  = '    '
          RES2   = '    '
        ENDIF        
        IF(IA3.GT.0.AND.IA3.LE.N_ATOM) THEN
          IR     = I_RESID (IA3 ) 
          ICH    = I_CHAIN (IR) 
          CH3    = GROUP_ID(ICH)(1:1)
          ATOM3  = ATM_NAME(IA3)
          ALT3   = ID_ALT (IA3)
          IRES3  = RES_NUM_PDB(IR)(3:6)
          RES3   = RES_NAME(IR)
        ELSE
          CH3    = ' '
          ATOM3  = '    '
          ALT3   = ' '
          IRES3  = '    '
          RES3   = '    '
        ENDIF        
        IF(IA4.GT.0.AND.IA4.LE.N_ATOM) THEN
          IR     = I_RESID (IA4 ) 
          ICH    = I_CHAIN (IR) 
          CH4    = GROUP_ID(ICH)(1:1)
          ATOM4  = ATM_NAME(IA4)
          ALT4   = ID_ALT (IA4)
          IRES4  = RES_NUM_PDB(IR)(3:6)
          RES4   = RES_NAME(IR)
        ELSE
          CH4    = ' '
          ATOM4  = '    '
          ALT4   = ' '
          IRES4  = '    '
          RES4   = '    '
        ENDIF        
        RS_NAME = 'TORS'

        LINE_OLD = C_LINE
        WRITE(C_LINE,'(''# '',A,1X,A5,1X,A2,'' - '',A,1X,A5,1X,A2
     *  ,'' - '',A3,1X,A5,1X,A2,'' - '',A3,1X,A5,1X,A2)')
     *  RES1,IRES1,CH1,RES2,IRES2,CH2,RES3,IRES3,CH3,RES4,IRES4,CH4  
        CALL LENSTR_BL(LINE_OLD,LEN1)
        CALL LENSTR_BL(C_LINE,LEN2)
        IFLAG = 0
        IF(LEN1.EQ.LEN2.AND.LINE_OLD.EQ.C_LINE) IFLAG=1
         
          CALL ENER_TORS(MDD,RS_NAME,RS_NTORS,RT_LABEL(I)
     *     ,IA1,IA2,IA3,IA4
     *     ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *     ,RT_VIDL(I),RT_SDID(I),RT_VOBS(I),RT_PRD(I),RT_CNST(I)
     *     ,RMS_T,NT_GT_1S,NT_GT_3S,NT_GT_10S,SLIM
     *     ,C_LINE,IFLAG,LIST,IERR)
           IF(IERR.NE.0) RETURN

      ENDDO
      ENDIF

      IF(NR_CHIR.GT.0.AND.(REF.EQ.'E'.OR.REF.EQ.'R')) THEN
      DO I=1,NR_CHIR
        IA1 = RC_IA1(I)
        IA2 = RC_IA2(I)
        IA3 = RC_IA3(I)
        IA4 = RC_IA4(I)
        IF(IA1.GT.0.AND.IA1.LE.N_ATOM) THEN
          IR     = I_RESID (IA1) 
          ICH    = I_CHAIN (IR) 
          CH1    = GROUP_ID(ICH)(1:1)
          ATOM1  = ATM_NAME(IA1)
          ALT1   = ID_ALT (IA1)
          IRES1  = RES_NUM_PDB(IR)(3:6)
          RES1   = RES_NAME(IR)
        ELSE
          CH1    = ' '
          ATOM1  = '    '
          ALT1   = ' '
          IRES1  = '    '
          RES1   = '    '
        ENDIF        
        IF(IA2.GT.0.AND.IA2.LE.N_ATOM) THEN
          IR     = I_RESID (IA2 ) 
          ICH    = I_CHAIN (IR) 
          CH2    = GROUP_ID(ICH)(1:1)
          ATOM2  = ATM_NAME(IA2)
          ALT2   = ID_ALT (IA2)
          IRES2  = RES_NUM_PDB(IR)(3:6)
          RES2   = RES_NAME(IR)
        ELSE
          CH2    = ' '
          ATOM2  = '    '
          ALT2   = ' '
          IRES2  = '    '
          RES2   = '    '
        ENDIF        
        IF(IA3.GT.0.AND.IA3.LE.N_ATOM) THEN
          IR     = I_RESID (IA3 ) 
          ICH    = I_CHAIN (IR) 
          CH3    = GROUP_ID(ICH)(1:1)
          ATOM3  = ATM_NAME(IA3)
          ALT3   = ID_ALT (IA3)
          IRES3  = RES_NUM_PDB(IR)(3:6)
          RES3   = RES_NAME(IR)
        ELSE
          CH3    = ' '
          ATOM3  = '    '
          ALT3   = ' '
          IRES3  = '    '
          RES3   = '    '
        ENDIF        
        IF(IA4.GT.0.AND.IA4.LE.N_ATOM) THEN
          IR     = I_RESID (IA4 ) 
          ICH    = I_CHAIN (IR) 
          CH4    = GROUP_ID(ICH)(1:1)
          ATOM4  = ATM_NAME(IA4)
          ALT4   = ID_ALT (IA4)
          IRES4  = RES_NUM_PDB(IR)(3:6)
          RES4   = RES_NAME(IR)
        ELSE
          CH4    = ' '
          ATOM4  = '    '
          ALT4   = ' '
          IRES4  = '    '
          RES4   = '    '
        ENDIF        


        LINE_OLD = C_LINE
        WRITE(C_LINE,'(''# '',A,1X,A5,1X,A2,'' - '',A,1X,A5,1X,A2
     *  ,'' - '',A3,1X,A5,1X,A2,'' - '',A3,1X,A5,1X,A2)')
     *  RES1,IRES1,CH1,RES2,IRES2,CH2,RES3,IRES3,CH3,RES4,IRES4,CH4  
        CALL LENSTR_BL(LINE_OLD,LEN1)
        CALL LENSTR_BL(C_LINE,LEN2)
        IFLAG = 0
        IF(LEN1.EQ.LEN2.AND.LINE_OLD.EQ.C_LINE) IFLAG=1

        RS_NAME = 'CHIR'

          mdddd = 1       
         
          CALL CHECK_CHIR_EMIN(MDDdd,RS_NAME,RS_NCHIR,RC_SIGN(I)
     *     ,RS_NTORS,IA1,IA2,IA3,IA4
     *     ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *     ,RC_VIDL(I),RS_SDI,RC_VOBS(I),RC_CNST(I)
     *     ,RMS_C,NC_GT_1S,NC_GT_3S,NC_GT_10S,SLIM
     *     ,C_LINE,IFLAG,LIST,IERR)
           IF(IERR.NE.0) RETURN

      ENDDO
      ENDIF

      IF(NR_PLAN.GT.0.AND.(REF.EQ.'E'.OR.REF.EQ.'R')) THEN
        RS_NUM_OLD =-1
 
       DO I=1,NR_PLAN
          RS_NUM = I
          DO J=1,RP_NATOM(I)
            IA1 = RP_IATM(J,I)
            IF(IA1.GT.0.AND.IA1.LE.N_ATOM) THEN
              IR     = I_RESID (IA1) 
              ICH    = I_CHAIN (IR) 
              CH1    = GROUP_ID(ICH)(1:1)
              ATOM1  = ATM_NAME(IA1)
              ALT1   = ID_ALT (IA1)
              IRES1  = RES_NUM_PDB(IR)(3:6)
              RES1   = RES_NAME(IR)
            ELSE
              CH1    = ' '
              ATOM1  = '    '
              ALT1   = ' '
              IRES1  = '    '
              RES1   = '    '
            ENDIF        
            RS_NAME = 'PLAN'

            LINE_OLD = C_LINE
            WRITE(C_LINE,'(''# '',A,1X,A5,1X,A2)')
     *      RES1,IRES1,CH1
            CALL LENSTR_BL(LINE_OLD,LEN1)
            CALL LENSTR_BL(C_LINE,LEN2)
            IFLAG = 0
            IF(LEN1.EQ.LEN2.AND.LINE_OLD.EQ.C_LINE) IFLAG=1

            CALL CHECK_PLAN_EMIN(MDD,RS_NAME,RS_NPLAN,RP_LABEL(I)
     *       ,RS_NBOND,RS_NTORS,RS_NUM,RS_NUM_OLD,IA1
     *       ,ATOM1,ALT1,RP_DEV(J,I),RP_DOBS(J,I)
     *       ,RMS_P,NP_GT_1S,NP_GT_3S,NP_GT_10S,SLIM
     *       ,RMS_B,NB_GT_1S,NB_GT_3S,NB_GT_10S
     *       ,NA_PLAN,PL_LABEL,PL_IATOM,PL_ATOM,PL_ALT,PL_DEL,PL_DOBS
     *       ,PL_SD,MAXAPLN  
     *       ,C_LINE,IFLAG,LIST,IERR)
            IF(IERR.NE.0) RETURN
            RS_NUM_OLD = RS_NUM
          ENDDO
        ENDDO

        RS_NUM_OLD =-2
        CALL CHECK_PLAN_EMIN(MDD,RS_NAME,RS_NPLAN,RP_LABEL(I)
     *     ,RS_NBOND,RS_NTORS,RS_NUM,RS_NUM_OLD,IA1
     *     ,ATOM1,ALT1,RP_DEV(J,I),RP_DOBS(J,I)
     *     ,RMS_P,NP_GT_1S,NP_GT_3S,NP_GT_10S,SLIM
     *     ,RMS_B,NB_GT_1S,NB_GT_3S,NB_GT_10S
     *     ,NA_PLAN,PL_LABEL,PL_IATOM,PL_ATOM,PL_ALT,PL_DEL,PL_DOBS
     *     ,PL_SD,MAXAPLN  
     *     ,C_LINE,IFLAG,LIST,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
C --------
      IFLAG    = 0
      C_LINE   = ' '
      LINE_OLD = '?'

      RSV_NVDW     = 0
      RSV_NHB      = 0
      RSV_NUM_OLD  = -1
      IEND         = -1
      NVDW_GT_1S   = 0
      NVDW_GT_3S   = 0
      NVDW_GT_10S  = 0
      RMS_VDW      = 0.0
      NHB_GT_1S    = 0
      NHB_GT_3S    = 0
      NHB_GT_10S   = 0
      RMS_HB       = 0.0
C --------------------------------
      IF(NR_VDW.GT.0.AND.(REF.EQ.'E'.OR.REF.EQ.'R')) THEN

      DO I=1,NR_VDW    
        IA1 = RV_IA1(I)
        IA2 = RV_IA2(I)
        IF(IA1.GT.0.AND.IA1.LE.N_ATOM) THEN
          IR     = I_RESID (IA1) 
          ICH    = I_CHAIN (IR) 
          CH1    = GROUP_ID(ICH)(1:1)
          ATOM1  = ATM_NAME(IA1)
          ALT1   = ID_ALT (IA1)
          IRES1  = RES_NUM_PDB(IR)(3:6)
          RES1   = RES_NAME(IR)
        ELSE
          CH1    = ' '
          ATOM1  = '    '
          ALT1   = ' '
          IRES1  = '    '
          RES1   = '    '
        ENDIF        
        IF(IA2.GT.0.AND.IA2.LE.N_ATOM) THEN
          IR     = I_RESID (IA2 ) 
          ICH    = I_CHAIN (IR) 
          CH2    = GROUP_ID(ICH)(1:1)
          ATOM2  = ATM_NAME(IA2)
          ALT2   = ID_ALT (IA2)
          IRES2  = RES_NUM_PDB(IR)(3:6)
          RES2   = RES_NAME(IR)
        ELSE
          CH2    = ' '
          ATOM2  = '    '
          ALT2   = ' '
          IRES2  = '    '
          RES2   = '    '
        ENDIF        
        RSV_NAME = 'VDW '


        LINE_OLD = C_LINE
        WRITE(C_LINE,'(''# '',A,1X,A5,1X,A2,'' - '',A,1X,A5,1X,A2)')
     *  RES1,IRES1,CH1,RES2,IRES2,CH2  
        CALL LENSTR_BL(LINE_OLD,LEN1)
        CALL LENSTR_BL(C_LINE,LEN2)
        IFLAG = 0
        IF(LEN1.EQ.LEN2.AND.LINE_OLD.EQ.C_LINE) IFLAG=1
        
          IF(MOD_E.EQ.'2') THEN
            CALL ENER_VDW_2(MDD,RSV_NAME,RSV_NVDW,RV_SYMM(I)
     *      ,IA1,IA2
     *      ,ATOM1,ALT1,ATOM2,ALT2
     *      ,RV_VIDL(I),RV_VOBS(I),RV_CNST(I),RV_FLAG(I),RV_TYPE(I)
     *      ,RMS_VDW,NVDW_GT_1S,NVDW_GT_3S,NVDW_GT_10S,SLIM
     *      ,C_LINE,IFLAG,IERR)
          ELSE

            CALL ENER_VDW(MDD,RSV_NAME,RSV_NVDW,RV_SYMM(I)
     *      ,IA1,IA2
     *      ,ATOM1,ALT1,ATOM2,ALT2
     *      ,RV_VIDL(I),RV_VOBS(I),RV_CNST(I),RV_FLAG(I),RV_TYPE(I)
     *      ,RMS_VDW,NVDW_GT_1S,NVDW_GT_3S,NVDW_GT_10S,SLIM
     *      ,C_LINE,IFLAG,IERR)
          ENDIF

        ENDDO
        ENDIF


      IF(NR_HB.GT.0.AND.(REF.EQ.'E'.OR.REF.EQ.'R')) THEN

      DO I=1,NR_HB    
        IA1 = RH_IA1(I)
        IA2 = RH_IA2(I)
        IF(IA1.GT.0.AND.IA1.LE.N_ATOM) THEN
          IR     = I_RESID (IA1) 
          ICH    = I_CHAIN (IR) 
          CH1    = GROUP_ID(ICH)(1:1)
          ATOM1  = ATM_NAME(IA1)
          ALT1   = ID_ALT (IA1)
          IRES1  = RES_NUM_PDB(IR)(3:6)
          RES1   = RES_NAME(IR)
        ELSE
          CH1    = ' '
          ATOM1  = '    '
          ALT1   = ' '
          IRES1  = '    '
          RES1   = '    '
        ENDIF        
        IF(IA2.GT.0.AND.IA2.LE.N_ATOM) THEN
          IR     = I_RESID (IA2 ) 
          ICH    = I_CHAIN (IR) 
          CH2    = GROUP_ID(ICH)(1:1)
          ATOM2  = ATM_NAME(IA2)
          ALT2   = ID_ALT (IA2)
          IRES2  = RES_NUM_PDB(IR)(3:6)
          RES2   = RES_NAME(IR)
        ELSE
          CH2    = ' '
          ATOM2  = '    '
          ALT2   = ' '
          IRES2  = '    '
          RES2   = '    '
        ENDIF        

        RSV_NAME = 'HB  '

        LINE_OLD = C_LINE
        WRITE(C_LINE,'(''# '',A,1X,A5,1X,A2,'' - '',A,1X,A5,1X,A2)')
     *  RES1,IRES1,CH1,RES2,IRES2,CH2  
        CALL LENSTR_BL(LINE_OLD,LEN1)
        CALL LENSTR_BL(C_LINE,LEN2)
        IFLAG = 0
        IF(LEN1.EQ.LEN2.AND.LINE_OLD.EQ.C_LINE) IFLAG=1
        

          IF(MOD_E.EQ.'2') THEN
            CALL ENER_HB_2(MDD,RSV_NAME,RSV_NHB,RH_SYMM(I)
     *      ,IA1,IA2
     *      ,ATOM1,ALT1,ATOM2,ALT2
     *      ,RH_VIDL(I),RH_VOBS(I),RH_CNST(I),RH_FLAG(I),RH_TYPE(I)
     *      ,RMS_HB,NHB_GT_1S,NHB_GT_3S,NHB_GT_10S,SLIM
     *      ,C_LINE,IFLAG,IERR)
          ELSE
            CALL ENER_HB(MDD,RSV_NAME,RSV_NHB,RH_SYMM(I)
     *      ,IA1,IA2
     *      ,ATOM1,ALT1,ATOM2,ALT2
     *      ,RH_VIDL(I),RH_VOBS(I),RH_CNST(I),RH_FLAG(I),RH_TYPE(I)
     *      ,RMS_HB,NHB_GT_1S,NHB_GT_3S,NHB_GT_10S,SLIM
     *      ,C_LINE,IFLAG,IERR)
          ENDIF


        ENDDO
        ENDIF
C ---
      CALL CALC_SHFT_E(MDOC,RS_NBOND,RMS_B,COEF,IERR)
      IF(IERR.NE.0) RETURN
C ---
      IF(N_ATOM.GT.0) THEN
        NVAR = 0
        DO I=1,N_ATOM
          IF(IPOINTER_VAR(I).GT.0) NVAR = NVAR + 1 
        ENDDO
        IF(NVAR.GT.0) THEN
          ENER_AVER = ENER_TOTAL/NVAR
          ENER_RMS  = SQRT(ENER_RMS/NVAR)
        ENDIF
      ENDIF
      TFUNCT_E = 0.0
      IF(RLAP_E.GT.0.0) THEN
C       TFUNCT_E = (ENER_AVER)/(SQRT(RLAP_E))
        TFUNCT_E = (ENER_AVER)/RLAP_E
        IF(REF.EQ.'T') TFUNCT_E = TFUNCT_E / 2.0 
      ENDIF

      IF(IDEBUG.GT.0) THEN
      WRITE(LINE,'('' Function_E,Lap :'',2G12.4)') 
     * TFUNCT_E,RLAP_E
      CALL MSGDOC(MDOC,LINE)
      ENDIF

      CALL MSGDOC(MD,'----- ')
C      WRITE(LINE,'('' N_atom, NR_atom (refined)   :'',2I8)') 
C     * N_ATOM,NR_ATOM
c      WRITE(LINE,'(I4,'') Energy,<Energy>,Energy_rms :'',4G12.4)') 
c     * NF,ENER_TOTAL,ENER_AVER,ENER_RMS,RLAP_E

      NF = NFUNCT+1
      IF(REF.EQ.'E') THEN
      WRITE(LINE,'(I4,'') Energy,<Energy>,Energy_rms :'',3G12.4)') 
     * NF,ENER_TOTAL,ENER_AVER,ENER_RMS
      CALL MSGDOC(MDOC,LINE)
      ELSE
      WRITE(LINE,'(I4,'') Function,<F>,F_rms :'',3G12.4)') 
     * NF,ENER_TOTAL,ENER_AVER,ENER_RMS
      CALL MSGDOC(MDOC,LINE)
      ENDIF 
      CALL MSGDOC(MD,'----- ')
      WRITE(LINE,'(''      <Shift>,Shift_rms,Shift_max :'',3G12.4)') 
     * SHIFTE_AVER,SHIFTE_RMS,SHIFTE_MAX
      CALL MSGDOC(MDOC,LINE)
C ---
      WRITE(LINE,'(''           N_atom             :'',I8)') 
     * N_ATOM
      CALL MSGDOC(MDOC,LINE)
      IF(RS_NBOND.GT.0) THEN
        CALL MSGDOC(MD,'----- ')
        BOND_ENER_AVER = BOND_ENER_TOTAL/RS_NBOND
        BOND_ENER_RMS  = SQRT(BOND_ENER_RMS/RS_NBOND)
        WRITE(LINE,'('' Number of bond restraints    :'',I12)') 
     *  RS_NBOND
        CALL MSGDOC(MD,LINE)

      IF(REF.EQ.'E') THEN
        WRITE(LINE,'(''           bond energy        :'',G12.4)') 
     *   BOND_ENER_TOTAL 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''          <bond energy>       :'',G12.4)') 
     *   BOND_ENER_AVER 
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(''           bond_energy_rms    :'',G12.4)') 
     *   BOND_ENER_RMS 
        CALL MSGDOC(MD,LINE)
      ELSE
        WRITE(LINE,'(''           bond restraints    :'',G12.4)') 
     *   BOND_ENER_TOTAL 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''          <bond restraints>   :'',G12.4)') 
     *   BOND_ENER_AVER 
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(''           bond_restraints_rms:'',G12.4)') 
     *   BOND_ENER_RMS 
        CALL MSGDOC(MD,LINE)
      ENDIF
        WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     *   NB_GT_1S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     *   NB_GT_3S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     *  NB_GT_10S
        CALL MSGDOC(MD,LINE)
        IF(RS_NBOND.GT.0) THEN
          RMS_B=SQRT(RMS_B/RS_NBOND)
        IF(REF.EQ.'E') THEN
          WRITE(LINE,'(''           bond_rms           :'',F12.4)') 
     *    RMS_B
        ELSE
          WRITE(LINE,'(''           !B1-B2!_rms        :'',F12.4)') 
     *    RMS_B
        ENDIF
          CALL MSGDOC(MDOC,LINE)
        ENDIF
      ENDIF
C ---
      IF(RS_NANGL.GT.0) THEN
        CALL MSGDOC(MD,'----- ')
        WRITE(LINE,'('' Number of angle restraints   :'',I8)') 
     *   RS_NANGL
        CALL MSGDOC(MD,LINE)
        ANGLE_ENER_AVER = ANGLE_ENER_TOTAL/RS_NANGL
        ANGLE_ENER_RMS  = SQRT(ANGLE_ENER_RMS/RS_NANGL)
        WRITE(LINE,'(''           angle energy       :'',G12.4)') 
     *   ANGLE_ENER_TOTAL 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''          <angle energy>      :'',G12.4)') 
     *   ANGLE_ENER_AVER 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           angle_energy_rms   :'',G12.4)') 
     *   ANGLE_ENER_RMS 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     *  NA_GT_1S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     *  NA_GT_3S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     *  NA_GT_10S
        CALL MSGDOC(MD,LINE)
        IF(RS_NANGL.GT.0) THEN
          RMS_A=SQRT(RMS_A/RS_NANGL)
          WRITE(LINE,'(''           angle_rms          :'',F12.4)') 
     *    RMS_A
          CALL MSGDOC(MDOC,LINE)
        ENDIF
      ENDIF
C ---
      IF(RS_NTORS.GT.0) THEN
        CALL MSGDOC(MD,'----- ')
        WRITE(LINE,'('' Number of torsion restraints :'',I8)') 
     *  RS_NTORS
        TORS_ENER_AVER= TORS_ENER_TOTAL/RS_NTORS
        TORS_ENER_RMS = SQRT(TORS_ENER_RMS/RS_NTORS)
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           tors energy        :'',G12.4)') 
     *   TORS_ENER_TOTAL 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''          <tors energy>       :'',G12.4)') 
     *   TORS_ENER_AVER 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           tors_energy_rms    :'',G12.4)') 
     *   TORS_ENER_RMS 
        WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     *  NT_GT_1S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     *  NT_GT_3S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     *  NT_GT_10S
        CALL MSGDOC(MD,LINE)
        IF(RS_NTORS.GT.0) THEN
          RMS_T = SQRT(RMS_T/RS_NTORS)
          WRITE(LINE,'(''           rms                :'',F12.4)') 
     *    RMS_T
          CALL MSGDOC(MD,LINE)
        ENDIF
      ENDIF
C ---
      IF(RS_NCHIR.GT.0) THEN
      CALL MSGDOC(MD,'----- ')
      WRITE(LINE,'('' Number of chiralities         :'',I8)') 
     * RS_NCHIR
      CALL MSGDOC(MD,LINE)
      WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     * NC_GT_1S
      CALL MSGDOC(MD,LINE)
      WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     * NC_GT_3S
      CALL MSGDOC(MD,LINE)
      WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     * NC_GT_10S
      CALL MSGDOC(MD,LINE)
      IF(RS_NCHIR.GT.0) THEN
        RMS_C = SQRT(RMS_C/RS_NCHIR)
        WRITE(LINE,'(''           rms                :'',F12.4)') 
     *  RMS_C
        CALL MSGDOC(MD,LINE)
      ENDIF
      ENDIF
C ---
      IF(RS_NPLAN.GT.0) THEN
      CALL MSGDOC(MD,'----- ')
      WRITE(LINE,'('' Number of planar groups       :'',I8)') 
     * RS_NPLAN
      CALL MSGDOC(MD,LINE)
      WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     * NP_GT_1S
      CALL MSGDOC(MD,LINE)
      WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     * NP_GT_3S
      CALL MSGDOC(MD,LINE)
      WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     * NP_GT_10S
      CALL MSGDOC(MD,LINE)
      IF(RS_NPLAN.GT.0) THEN
        RMS_P = SQRT(RMS_P/RS_NPLAN)
        WRITE(LINE,'(''           rms                :'',F12.4)') 
     *  RMS_P
        CALL MSGDOC(MD,LINE)
      ENDIF
      ENDIF
C ---
      IF(RSV_NVDW.GT.0) THEN
        VDW_ENER_AVER = VDW_ENER_TOTAL/RSV_NVDW
        VDW_ENER_RMS  = SQRT(VDW_ENER_RMS/RSV_NVDW)
        CALL MSGDOC(MD,'----- ')
        WRITE(LINE,'('' Number of VDW_contacts        :'',I8)') 
     *   RSV_NVDW
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           VDW energy        :'',G12.4)') 
     *   VDW_ENER_TOTAL 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''          <VDW energy>       :'',G12.4)') 
     *   VDW_ENER_AVER 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           VDW_energy_rms    :'',G12.4)') 
     *   VDW_ENER_RMS 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     *   NVDW_GT_1S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     *  NVDW_GT_3S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     *  NVDW_GT_10S
        CALL MSGDOC(MD,LINE)
        IF(RSV_NVDW.GT.0) THEN
          RMS_VDW = SQRT(RMS_VDW/RSV_NVDW)
          WRITE(LINE,'(''           rms                :'',F12.4)') 
     *    RMS_VDW
          CALL MSGDOC(MD,LINE)
        ENDIF
      ENDIF
      IF(RSV_NHB.GT.0) THEN
        HB_ENER_AVER = HB_ENER_TOTAL/RSV_NHB
        HB_ENER_RMS  = SQRT(HB_ENER_RMS/RSV_NHB)
        WRITE(LINE,'('' Number of H_bonds            :'',I8)') 
     *  RSV_NHB
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           HB energy          :'',G12.4)') 
     *   HB_ENER_TOTAL 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''          <HB energy>         :'',G12.4)') 
     *   HB_ENER_AVER 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           HB_energy_rms      :'',G12.4)') 
     *   HB_ENER_RMS 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     *  NHB_GT_1S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     *  NHB_GT_3S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     *  NHB_GT_10S
        CALL MSGDOC(MD,LINE)
        IF(RSV_NHB.GT.0) THEN
          RMS_HB = SQRT(RMS_HB/RSV_NHB)
          WRITE(LINE,'(''           rms                :'',F12.4)') 
     *    RMS_HB
          CALL MSGDOC(MD,LINE)
        ENDIF
      ENDIF
C ---
      CALL MSGDOC(MD,'----- ')
C --------------------------------------
      RETURN
      END
C -I-
      SUBROUTINE E_WRT_I(MDOC,IERR)
C ----------------------------------------------------------
C -I-
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
      INCLUDE 'ref_com.fh'
      INCLUDE 'ener_com.fh'
C -----------
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR
      CHARACTER   EXT*80,PATH*80
C ----------------------------------------------------------------
      REAL      AM(3,3),TR(3)
      CHARACTER LINE*256,GID*4,NCSF*1,CH4*4
C==================================================================
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C --------
      NOUT1 =  0
C     NOUT  = 11
      NOUT  = CRO2_IUN
      EXT   = ' '
      PATH  = ' '
      CALL OWCRD_CIF(MD,NOUT,PATH,NAMEG,EXT,IERR)
      IF(IERR.NE.0) THEN
        CALL MSGERR(MDOC,' ERR: OPEN OUTPUT_FILE /grd/')
        RETURN
      ENDIF
      IF(NOUT1.GT.0) THEN
        NOUT1 = CRO3_IUN
        CALL OWCRD_CIF(MD,NOUT1,PATH,NAMEI,EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERR: OPEN OUTPUT_FILE /ind/')
          RETURN
        ENDIF
      ENDIF
C --------
      NATOM = 0
      IEND  =-1
      IEND1 =-1
C --------
      WRITE(CR_LINE,'(''#N,NR,E,<E>,E_rms :'',2I8,1X,3F12.3)') 
     *  N_ATOM,NR_ATOM,ENER_TOTAL,ENER_AVER,ENER_RMS
      MODE = 1
      IF(NOUT.GT.0) THEN
        CALL WRCRD_CIF(M,NOUT,MODE,IEND,IERR)
      ENDIF
      IF(IERR.NE.0) THEN
        CLOSE(NOUT) 
        IF(NOUT1.GT.0) CLOSE(NOUT1) 
        RETURN
      ENDIF
      IF(NOUT1.GT.0) THEN
        CALL WRCRD_CIF(M,NOUT1,MODE,IEND1,IERR)
      ENDIF
      IF(IERR.NE.0) THEN
        CLOSE(NOUT) 
        IF(NOUT.GT.0) CLOSE(NOUT) 
        RETURN
      ENDIF
C ---
C --------
      WRITE(CR_LINE,'(''#Eb,Ea,Et,Ev,Eh:'',1X,5F12.2)') 
     *  BOND_ENER_TOTAL,ANGLE_ENER_TOTAL,TORS_ENER_TOTAL
     * ,VDW_ENER_TOTAL,HB_ENER_TOTAL
      MODE=1
      IF(NOUT.GT.0) THEN
        CALL WRCRD_CIF(M,NOUT,MODE,IEND,IERR)
      ENDIF
      IF(IERR.NE.0) THEN
        CLOSE(NOUT) 
        IF(NOUT1.GT.0) CLOSE(NOUT1) 
        RETURN
      ENDIF
      IF(NOUT1.GT.0) THEN
        CALL WRCRD_CIF(M,NOUT1,MODE,IEND1,IERR)
      ENDIF
      IF(IERR.NE.0) THEN
        CLOSE(NOUT) 
        IF(NOUT.GT.0) CLOSE(NOUT) 
        RETURN
      ENDIF
C ---
      WRITE(CR_LINE,'(''#Nb,Na,Nt,Nv,Nh:'',1X,7I8)') 
     * RS_NBOND,RS_NANGL,RS_NTORS,RS_NCHIR,RS_NPLAN,RSV_NVDW,RSV_NHB
      MODE=1
      IF(NOUT.GT.0) THEN
        CALL WRCRD_CIF(M,NOUT,MODE,IEND,IERR)
      ENDIF
      IF(IERR.NE.0) THEN
        CLOSE(NOUT) 
        IF(NOUT1.GT.0) CLOSE(NOUT1) 
        RETURN
      ENDIF
      IF(NOUT1.GT.0) THEN
        CALL WRCRD_CIF(M,NOUT1,MODE,IEND1,IERR)
      ENDIF
      IF(IERR.NE.0) THEN
        CLOSE(NOUT) 
        IF(NOUT.GT.0) CLOSE(NOUT) 
        RETURN
      ENDIF
C ---
      WRITE(CR_LINE,'(''#<Sh>,Sh_rms,Sh_max,L :'',1X,4F12.5)') 
     * SHIFTE_AVER,SHIFTE_RMS,SHIFTE_MAX,RLAP_AVER
      MODE=1
      IF(NOUT.GT.0) THEN
        CALL WRCRD_CIF(M,NOUT,MODE,IEND,IERR)
      ENDIF
      IF(IERR.NE.0) THEN
        CLOSE(NOUT) 
        IF(NOUT1.GT.0) CLOSE(NOUT1) 
        RETURN
      ENDIF
      IF(NOUT1.GT.0) THEN
        CALL WRCRD_CIF(M,NOUT1,MODE,IEND1,IERR)
      ENDIF
      IF(IERR.NE.0) THEN
        CLOSE(NOUT) 
        IF(NOUT.GT.0) CLOSE(NOUT) 
        RETURN
      ENDIF
C -------------------------------------
 200  CONTINUE
      MODE=0

      IF(N_ATOM.LE.0) THEN 
        CALL MSGERR(MDOC,'ERROR: number of atoms = 0')
        IERR=1
        RETURN
      ENDIF

      DO I=1,N_ATOM   

        CR_IATOLD = I_ATOLD(I)    

        IRES      = I_RESID    (I)
        CR_RNAME  = RES_NAME   (IRES)
        CR_IRES   = IRES_SERIAL(IRES)
        IG        = I_CHAIN    (IRES) 
        CR_IGROUP = IG 
        IB        = B_FLAG     (I)
        CR_PNUM   = RES_NUM_PDB(IRES)
        CH4       = CR_PNUM(3:6)
        READ(CH4,'(I4)') CR_IRES

        IB = 0
        IF(IB.EQ.0) THEN
          CR_BTYPE  = '.'
          DO IAN=1,6
            CR_ANIS(IAN) = 0.0
          ENDDO
        ELSE
          CR_BTYPE  = 'A'
          DO IAN=1,6
            CR_ANIS(IAN) = U_ANISO(IAN,I)
          ENDDO
        ENDIF     

        CR_ANAME  = ATM_NAME (I)     
        CR_ANAME_INP  = ATM_NAME_INP(I)
        ST_CHEM   = ATM_CHEM(I)     
        INSF      = ID_SF    (I)
        CR_ASYMB  = CS_ATYPE (INSF)      
        CR_ATYPE  = ATM_TYPE (I)    
        CR_ALT    = ID_ALT   (I)    
        CR_SEG    = SEG_ID   (I)    
        CR_CORR   = ID_CORR  (I)    

        RLAP_B = BOND_DER2 (I)
        RLAP_G = ANGLE_DER2(I)
        RLAP_T = TORS_DER2 (I)
        RLAP_V = VDW_DER2  (I)
        RLAP_H = HB_DER2   (I)

        RLAP   = RLAP_B + RLAP_G +RLAP_T + RLAP_V +RLAP_H

C        RLAP   = RLAP_T

        IF(RLAP_B.GT.0.0) THEN
          DERX_B = BOND_DER (1,I)
          DERY_B = BOND_DER (2,I)
          DERZ_B = BOND_DER (3,I)
        ELSE
          DERX_B = 0.0
          DERY_B = 0.0
          DERZ_B = 0.0
        ENDIF

        IF(RLAP_G.GT.0.0) THEN
          DERX_G = ANGLE_DER (1,I)
          DERY_G = ANGLE_DER (2,I)
          DERZ_G = ANGLE_DER (3,I)
        ELSE
          DERX_G = 0.0
          DERY_G = 0.0
          DERZ_G = 0.0
        ENDIF

        IF(RLAP_T.GT.0.0) THEN
          DERX_T = TORS_DER (1,I)
          DERY_T = TORS_DER (2,I)
          DERZ_T = TORS_DER (3,I)
        ELSE
          DERX_T = 0.0
          DERY_T = 0.0
          DERZ_T = 0.0
        ENDIF

        IF(RLAP_V.GT.0.0) THEN
          DERX_V = VDW_DER (1,I)
          DERY_V = VDW_DER (2,I)
          DERZ_V = VDW_DER (3,I)
        ELSE
          DERX_V = 0.0
          DERY_V = 0.0
          DERZ_V = 0.0
        ENDIF

        IF(RLAP_H.GT.0.0) THEN
          DERX_H = HB_DER (1,I)
          DERY_H = HB_DER (2,I)
          DERZ_H = HB_DER (3,I)
        ELSE
          DERX_H = 0.0
          DERY_H = 0.0
          DERZ_H = 0.0
        ENDIF

        DERX = DERX_B + DERX_G + DERX_V  + DERX_T  + DERX_H
        DERY = DERY_B + DERY_G + DERY_V  + DERY_T  + DERY_H
        DERZ = DERZ_B + DERZ_G + DERZ_V  + DERZ_T  + DERZ_H

C        DERX = DERX_T
C        DERY = DERY_T
C        DERZ = DERZ_T

        IF(RLAP.GT.0.0001) THEN
          SHIFTX = -DERX/RLAP
          SHIFTY = -DERY/RLAP
          SHIFTZ = -DERZ/RLAP
        ELSE
          SHIFTX = 0.0
          SHIFTY = 0.0
          SHIFTZ = 0.0
        ENDIF

        SHIFT2 = (SHIFTX*SHIFTX+SHIFTY*SHIFTY+SHIFTZ*SHIFTZ)
        SHIFT  = SQRT(SHIFT2)

        CR_XYZ(1) = SHIFTX
        CR_XYZ(2) = SHIFTY  
        CR_XYZ(3) = SHIFTZ

        CR_BISO   = BOND_ENER  (I) + ANGLE_ENER (I)+ TORS_ENER (I) 
     *                             + VDW_ENER (I)  + HB_ENER (I) 
        CR_OCC    = RLAP/100.0

        CR_MULT_FACTOR = MULT_FACTOR(I)

        NATOM = NATOM + 1

C ----
        CALL WRCRD_CIF(M,NOUT,MODE,IEND,IERR)
        IF(IERR.NE.0) THEN
          RETURN
        ENDIF
C ----
        CR_XYZ(1) = BOND_ENER  (I)
        CR_XYZ(2) = ANGLE_ENER (I)  
        CR_XYZ(3) = TORS_ENER  (I)
   
        CR_BISO   = VDW_ENER   (I)
        CR_OCC    = HB_ENER    (I)

C ----
        IF(NOUT1.GT.0) THEN
          CALL WRCRD_CIF(M,NOUT1,MODE,IEND,IERR)
          IF(IERR.NE.0) THEN
            RETURN
          ENDIF
        ENDIF
C ----
      ENDDO
C --------------------------------------
 300  CONTINUE

      IEND=1
      MODE=0     
      CALL WRCRD_CIF(MDOC,NOUT,MODE,IEND,IERR)

C --------------------------------------
      RETURN
      END


C -I-
      SUBROUTINE CALC_SHFT_E(MDOC,NBOND,RMS_B,COEF,IERR)
C ==----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ref_com.fh'
      INCLUDE 'ener_com.fh'
C ----------------------------------------------------------------
      INTEGER     MDOC,IERR
C ----------------------------------------------------------------
      CHARACTER LINE*256
C==================================================================
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C --------
      IF(N_ATOM.LE.0) THEN
        CALL MSGERR(MDOC,'ERROR: number of atoms = 0')
        IERR=1
        RETURN
      ENDIF

      SHIFTE_AVER = 0.0
      SHIFTE_RMS  = 0.0
      SHIFTE_MAX  = 0.0
      BETAG       = 0.0
      NR_ATOM     = 0
      RLAP_AVER   = 0.0
      NVAR        = 0

      DO I=1,N_ATOM    
      IF(IPOINTER_VAR(I).GT.0) THEN
        NVAR = NVAR + 1

        RLAP_B = BOND_DER2 (I)
        RLAP_G = ANGLE_DER2(I)
        RLAP_T = TORS_DER2 (I)
        RLAP_V = VDW_DER2  (I)
        RLAP_H = HB_DER2   (I)

        IF(REF.EQ.'E'.OR.REF.EQ.'R') THEN
          RLAP   = RLAP_B + RLAP_G +RLAP_T + RLAP_V +RLAP_H
        ELSE
          RLAP   = RLAP_B + RLAP_V
          RLAP_G = 0.0
          RLAP_T = 0.0
          IF(REF.NE.'S') THEN
            RLAP_V = 0.0
          ENDIF
          RLAP_H = 0.0
        ENDIF

        IF(RLAP_B.GT.0.0) THEN
          IF(REF.EQ.'E'.OR.REF.EQ.'R') THEN
            DERX_B = BOND_DER (1,I)
            DERY_B = BOND_DER (2,I)
            DERZ_B = BOND_DER (3,I)
          ELSE
            DERX_B = BOND_DER (1,I)
            DERY_B = 0.0
            DERZ_B = 0.0
          ENDIF
        ELSE
          DERX_B = 0.0
          DERY_B = 0.0
          DERZ_B = 0.0
        ENDIF

        IF(RLAP_G.GT.0.0) THEN
          DERX_G = ANGLE_DER (1,I)
          DERY_G = ANGLE_DER (2,I)
          DERZ_G = ANGLE_DER (3,I)
        ELSE
          DERX_G = 0.0
          DERY_G = 0.0
          DERZ_G = 0.0
        ENDIF

        IF(RLAP_T.GT.0.0) THEN
          DERX_T = TORS_DER (1,I)
          DERY_T = TORS_DER (2,I)
          DERZ_T = TORS_DER (3,I)
        ELSE
          DERX_T = 0.0
          DERY_T = 0.0
          DERZ_T = 0.0
        ENDIF
C
        IF(RLAP_V.GT.0.0) THEN
          DERX_V = VDW_DER (1,I)
          DERY_V = VDW_DER (2,I)
          DERZ_V = VDW_DER (3,I)
        ELSE
          DERX_V = 0.0
          DERY_V = 0.0
          DERZ_V = 0.0
        ENDIF

        IF(RLAP_H.GT.0.0) THEN
          DERX_H = HB_DER (1,I)
          DERY_H = HB_DER (2,I)
          DERZ_H = HB_DER (3,I)
        ELSE
          DERX_H = 0.0
          DERY_H = 0.0
          DERZ_H = 0.0
        ENDIF  

        DERX = DERX_B + DERX_G + DERX_V  + DERX_T  + DERX_H
        DERY = DERY_B + DERY_G + DERY_V  + DERY_T  + DERY_H
        DERZ = DERZ_B + DERZ_G + DERZ_V  + DERZ_T  + DERZ_H

C        DERX = DERX_T
C        DERY = DERY_T
C        DERZ = DERZ_T

        IF(RLAP.GT.0.0001) THEN
          SHIFTX = -DERX/RLAP
          SHIFTY = -DERY/RLAP
          SHIFTZ = -DERZ/RLAP
          NR_ATOM= NR_ATOM+1
        ELSE
          SHIFTX = 0.0
          SHIFTY = 0.0
          SHIFTZ = 0.0
        ENDIF

        IF(REF.EQ.'E'.OR.REF.EQ.'R') THEN

          BETAG = BETAG + SHIFT2_ATOM(1,I) *  SHIFTX
     *                  + SHIFT2_ATOM(2,I) *  SHIFTY
     *                  + SHIFT2_ATOM(3,I) *  SHIFTZ

C          SHIFT2_ATOM(1,I) = SHIFT2_ATOM(1,I)  * (1.0 - WEIGHT) 
C     *                     + SHIFTX * WEIGHT  
C          SHIFT2_ATOM(2,I) = SHIFT2_ATOM(2,I)  * (1.0 - WEIGHT)
C     *                     + SHIFTY * WEIGHT
C          SHIFT2_ATOM(3,I) = SHIFT2_ATOM(1,I)  * (1.0 - WEIGHT)
C     *                     + SHIFTZ * WEIGHT
   
          SHIFT2 = (SHIFTX*SHIFTX+SHIFTY*SHIFTY+SHIFTZ*SHIFTZ)
        ELSE
          BETAG = BETAG + SHIFT2_ATOM(1,I) *  SHIFTX

C          SHIFT2_ATOM(1,I) = SHIFT2_ATOM(1,I)  * (1.0 - WEIGHT) 
C     *                     + SHIFTX * WEIGHT  
   
          SHIFT2 = (SHIFTX*SHIFTX)

        ENDIF

        SHIFT       = SQRT(SHIFT2)
        SHIFTE_AVER = SHIFTE_AVER + SHIFT
        SHIFTE_RMS  = SHIFTE_RMS + SHIFT2
        IF(SHIFT.GT.SHIFTE_MAX) SHIFTE_MAX=SHIFT
        RLAP_AVER   = RLAP_AVER + RLAP

      ENDIF
      ENDDO
C --------------------------------------
      IF(NVAR.GT.0) THEN
        SHIFTE_RMS  = SQRT(SHIFTE_RMS/NVAR)
        SHIFTE_AVER = SHIFTE_AVER    /NVAR
        RLAP_AVER   = RLAP_AVER      /NVAR
      ENDIF
      GGRAD_2E = SHIFTE_RMS
      RLAP_E   = RLAP_AVER
      IF(GGRAD_2E.GT.0.0.AND.GGRAD_2D.GT.0.0.AND.NVAR.GT.0) THEN
        BETAG = BETAG/(NVAR*GGRAD_2E*GGRAD_2D)
      ENDIF
C --------------------------------------
C      IF(IDEBUG.GT.0.AND.(REF.EQ.'T'.OR.REF.EQ.'R')) THEN
      IF(IDEBUG.GT.0.AND.(REF.EQ.'R')) THEN

        IF(GGRAD_2E.NE.0.0.AND.GGRAD_2D.NE.0) THEN

          write(LINE,*) nbond,rms_b,BOND_ENER_RMS
          CALL MSGDOC(MDOC,LINE)
          write(LINE,*) ' RESOL:',RESOL
          CALL MSGDOC(MDOC,LINE)
          IF(NBOND.GT.0) THEN
            ERMS  = SQRT(BOND_ENER_RMS/NBOND)
            RMSB  = SQRT(RMS_B/NBOND)
          ENDIF
          WRITE(LINE,*) ' bond_ener_rms:',ERMS
          CALL MSGDOC(MDOC,LINE)
          BRMS = (ERMS * ERMS)/500.0
          WRITE(LINE,*) ' brms:',BRMS
          CALL MSGDOC(MDOC,LINE)
          WRITE(LINE,*) ' bond_rms:',RMSB
          CALL MSGDOC(MDOC,LINE)

          WTN = WEIGHT
          WTR = WEIGHT
          IF(REF.EQ.'R'.AND.NBOND.GT.0) THEN
            IF(RMSB.GT.0.04) THEN
              WTR = 0.9999
            ELSE
              WTR = (RMSB*0.9999)/0.04
            ENDIF
          ENDIF        
          T1 = GGRAD_2E/GGRAD_2D   
          T2 = GGRAD_2D*(1.0-WTR)*WTR      
     *        +GGRAD_2E*WTR*WTR
          T3 = GGRAD_2D*(1.0-WTR)*(1.0-WTR)
     *        +GGRAD_2E*WTR*(1.0-WTR)
          T4 = T2 + (T3*GGRAD_2E)/GGRAD_2D
          IF(ABS(T4).GT.0.0) WTN = T2/T4
          WRITE(LINE,*) ' Old weight:',WTR
          WRITE(LINE,*) ' New weight:',WTN        
          CALL MSGDOC(MDOC,LINE)
          IF(REF.EQ.'R'.AND.NBOND.GT.0) WEIGHT=WTN
        ENDIF
      ENDIF
C ---------------------------------------
      SHIFTE_AVER = 0.0
      SHIFTE_RMS  = 0.0
      SHIFTE_MAX  = 0.0
      BETAG       = 0.0
      NR_ATOM     = 0
      RLAP_AVER   = 0.0
      NVAR        = 0
      DO I=1,N_ATOM   
      IF(IPOINTER_VAR(I).GT.0) THEN
        NVAR = NVAR + 1

        RLAP_B = BOND_DER2 (I)
        RLAP_G = ANGLE_DER2(I)
        RLAP_T = TORS_DER2 (I)
        RLAP_V = VDW_DER2  (I)
        RLAP_H = HB_DER2   (I)

        IF(REF.EQ.'E'.OR.REF.EQ.'R') THEN
          RLAP   = RLAP_B + RLAP_G +RLAP_T + RLAP_V +RLAP_H
        ELSE
          RLAP   = RLAP_B + RLAP_V
          RLAP_G = 0.0
          RLAP_T = 0.0
          IF(REF.NE.'S') THEN
            RLAP_V = 0.0
          ENDIF
          RLAP_H = 0.0
        ENDIF

        IF(RLAP_B.GT.0.0) THEN
          IF(REF.EQ.'E'.OR.REF.EQ.'R') THEN
            DERX_B = BOND_DER (1,I)
            DERY_B = BOND_DER (2,I)
            DERZ_B = BOND_DER (3,I)
          ELSE
            DERX_B = BOND_DER (1,I)
          ENDIF
        ELSE
          DERX_B = 0.0
          DERY_B = 0.0
          DERZ_B = 0.0
        ENDIF

        IF(RLAP_G.GT.0.0) THEN
          DERX_G = ANGLE_DER (1,I)
          DERY_G = ANGLE_DER (2,I)
          DERZ_G = ANGLE_DER (3,I)
        ELSE
          DERX_G = 0.0
          DERY_G = 0.0
          DERZ_G = 0.0
        ENDIF

        IF(RLAP_T.GT.0.0) THEN
          DERX_T = TORS_DER (1,I)
          DERY_T = TORS_DER (2,I)
          DERZ_T = TORS_DER (3,I)
        ELSE
          DERX_T = 0.0
          DERY_T = 0.0
          DERZ_T = 0.0
        ENDIF
C
        IF(RLAP_V.GT.0.0) THEN
          DERX_V = VDW_DER (1,I)
          DERY_V = VDW_DER (2,I)
          DERZ_V = VDW_DER (3,I)
        ELSE
          DERX_V = 0.0
          DERY_V = 0.0
          DERZ_V = 0.0
        ENDIF

        IF(RLAP_H.GT.0.0) THEN
          DERX_H = HB_DER (1,I)
          DERY_H = HB_DER (2,I)
          DERZ_H = HB_DER (3,I)
        ELSE
          DERX_H = 0.0
          DERY_H = 0.0
          DERZ_H = 0.0
        ENDIF  

        DERX = DERX_B + DERX_G + DERX_V  + DERX_T  + DERX_H
        DERY = DERY_B + DERY_G + DERY_V  + DERY_T  + DERY_H
        DERZ = DERZ_B + DERZ_G + DERZ_V  + DERZ_T  + DERZ_H

C        DERX = DERX_T
C        DERY = DERY_T
C        DERZ = DERZ_T

        COEF=1.0

        IF(RLAP.GT.0.0001) THEN
          SHIFTX  = -DERX/RLAP
          SHIFTY  = -DERY/RLAP
          SHIFTZ  = -DERZ/RLAP
          NR_ATOM = NR_ATOM+1
        ELSE
          SHIFTX = 0.0
          SHIFTY = 0.0
          SHIFTZ = 0.0
        ENDIF

        IF(REF.EQ.'E'.OR.REF.EQ.'R') THEN

          BETAG = BETAG + SHIFT2_ATOM(1,I) *  SHIFTX
     *                  + SHIFT2_ATOM(2,I) *  SHIFTY
     *                  + SHIFT2_ATOM(3,I) *  SHIFTZ

          SHIFT2_ATOM(1,I) = SHIFT2_ATOM(1,I)  * (1.0 - WEIGHT) 
     *                     + SHIFTX * WEIGHT  
          SHIFT2_ATOM(2,I) = SHIFT2_ATOM(2,I)  * (1.0 - WEIGHT)
     *                     + SHIFTY * WEIGHT
          SHIFT2_ATOM(3,I) = SHIFT2_ATOM(1,I)  * (1.0 - WEIGHT)
     *                     + SHIFTZ * WEIGHT
   
          SHIFT2 = (SHIFTX*SHIFTX+SHIFTY*SHIFTY+SHIFTZ*SHIFTZ)
        ELSE
          BETAG = BETAG + SHIFT2_ATOM(1,I) *  SHIFTX

          SHIFT2_ATOM(1,I) = SHIFT2_ATOM(1,I)  * (1.0 - WEIGHT) 
     *                     + SHIFTX * WEIGHT  
   
          SHIFT2 = (SHIFTX*SHIFTX)

        ENDIF
        SHIFT       = SQRT(SHIFT2)
        SHIFTE_AVER = SHIFTE_AVER + SHIFT
        SHIFTE_RMS  = SHIFTE_RMS + SHIFT2
        IF(SHIFT.GT.SHIFTE_MAX) SHIFTE_MAX=SHIFT
        RLAP_AVER = RLAP_AVER + RLAP

      ENDIF
      ENDDO
C --------------------------------------
      IF(NVAR.GT.0) THEN
        SHIFTE_RMS  = SQRT(SHIFTE_RMS/NVAR)
        SHIFTE_AVER = SHIFTE_AVER    /NVAR
        RLAP_AVER   = RLAP_AVER      /NVAR
      ENDIF
      GGRAD_2E = SHIFTE_RMS
      RLAP_E   = RLAP_AVER
      IF(GGRAD_2E.GT.0.0.AND.GGRAD_2D.GT.0.0.AND.NVAR.GT.0) THEN
        BETAG = BETAG/(NVAR*GGRAD_2E*GGRAD_2D)
      ENDIF
      RETURN
      END


C V==================
C V==================
      SUBROUTINE M_MIN(MDOC,LIST,POOL,MEMORY,NCRDMAX,NSYM,ISYM
     *                ,IPRSYM,IERR)
C -------------------------------------------------------- 
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'ref_com.fh'
C --------------------------------------------------------------
      INTEGER*2 ISYM(5,3,IPRSYM)
      REAL      POOL(MEMORY)
C ---------------------------------------------------------------
      INTEGER     MDOC,IERR
C ----------------------------------------------------------------
      CHARACTER LINE*256,LIST*1
C==================================================================
      IERR= 0
      MD  = -ABS(MDOC)-1
      M   = 99
C --------
      NFUNCT = 0
      NSTEP  = 0
      NGRAD  = 0
      NBACK  = 0
      NSHAKE = 0
      NTRIAL = 0
      DSTEP  = 0.5
      SS_OLD = DSTEP
      DS     = DSTEP
      SHIFT_LIM_B = 10.0
      SHIFT_LIM_S = 10.0
      IF(REF.EQ.'S'.AND.N_PHI.LE.0) THEN
        CALL MSGERR(MDOC,'ERROR: no variables for torsion refinement')    
        IERR = 1
        RETURN
      ENDIF

      MMM = M
      IF(LIST.EQ.'T') THEN
        write(*,*) '>>>FUNCT'
        MMM = MDOC
      ENDIF 
      CALL FUNCT(MMM,LIST,POOL,MEMORY,NCRDMAX
     *   ,NSYM,ISYM,IPRSYM,IERR)
      IF(IERR.NE.0) THEN
        RETURN
      ENDIF

      IF(REF.NE.'E'.AND.REF.NE.'T'.AND.REF.NE.'S') THEN
      WRITE(LINE,'(''initial Funtion,F_ener,F_dens :'',3G12.4)')
     * TFUNCT_NEW,TFUNCT_E,TFUNCT_D
      CALL MSGDOC(MDOC,LINE)    
      ENDIF

      IF(IDEBUG.GT.0) THEN
      WRITE(LINE,'(''init F,Fe,Fd,w :'',4G12.4)')
     * TFUNCT_NEW,TFUNCT_E,TFUNCT_D,WEIGHT
      CALL MSGDOC(MDOC,LINE)    
      WRITE(LINE,'(''  G2E,G2D,b,Le,Ld:'',5G12.4)')
     * GGRAD_2E,GGRAD_2D,BETAG,RLAP_E,RLAP_D
      CALL MSGDOC(MDOC,LINE)    
      ENDIF
    
 100  CONTINUE
 
      IF(NFUNCT.GT.1.AND.NSTEP.EQ.0.AND.NTRIAL.GE.3) GO TO 300
      IF(NFUNCT.GE.NCYCLE) GO TO 500

      CALL GRAD_SHIFT(MDOC
     * ,POOL,MEMORY,NCRDMAX,NSYM,ISYM,IPRSYM,IERR)
      IF(IERR.NE.0) THEN
        RETURN
      ENDIF

      IF(IDEBUG.GT.0) THEN
      WRITE(LINE,'(''--GRAD NsNgNf F,Fs,Fo:'',3I4,3G12.4)')
     * NSTEP,NGRAD,NFUNCT,TFUNCT_NEW,TFUNCT_S,TFUNCT_OLD
      CALL MSGDOC(MDOC,LINE)    
      WRITE(LINE,'(''  Gold,S_old:'',2G12.4)')
     * GGRAD_OLD,SS_OLD
      CALL MSGDOC(MDOC,LINE)    
      WRITE(LINE,'(''  G,G2,L,a,g:'',5G12.4)')
     * GGRAD,GGRAD_2,RLAP_T,ALPHAG,GAMMAG
      CALL MSGDOC(MDOC,LINE)    
      WRITE(LINE,'('' G2E,G2D,b,Le,Ld:'',5G12.4)')
     * GGRAD_2E,GGRAD_2D,BETAG,RLAP_E,RLAP_D
      ENDIF

      DS    = DSTEP
      STEP  = DS

 200  CONTINUE

c      IF(NFUNCT.GE.NCYCLE) GO TO 500

      CALL LIN_STEP(MDOC,LIST,STEP
     * ,POOL,MEMORY,NCRDMAX,NSYM,ISYM,IPRSYM,IERR)
      IF(IERR.NE.0) THEN
        RETURN
      ENDIF

      IF(REF.NE.'E'.AND.REF.NE.'T'.AND.REF.NE.'S') THEN
      WRITE(LINE,'(I6,'') Function,F_ener,F_dens:'',3G12.4)')
     * NFUNCT,TFUNCT_NEW,TFUNCT_E,TFUNCT_D
      CALL MSGDOC(MDOC,LINE)    
      ENDIF

      IF(IDEBUG.GT.0) THEN
      WRITE(LINE,'(I2,'') ng,nf,nb,nt,ns,s,sp:'',5I4,2G12.4)')
     * NSTEP,NGRAD,NFUNCT,NBACK,NTRIAL,NSHAKE,STEP_NEW,STEP_PREV
      CALL MSGDOC(MDOC,LINE)    
      WRITE(LINE,'(''  Fned,Fp,Fs:'',5G12.4)')
     * TFUNCT_NEW,TFUNCT_E,TFUNCT_D,TFUNCT_PREV,TFUNCT_S
      CALL MSGDOC(MDOC,LINE)    
      WRITE(LINE,'(''  G,G2,G2p,a,g:'',5G12.4)')
     * GGRAD,GGRAD_2,G2_PREV,ALPHAG,GAMMAG
      CALL MSGDOC(MDOC,LINE)    
      WRITE(LINE,'(''  G2E,G2D,b,Le,Ld:'',5G12.4)')
     * GGRAD_2E,GGRAD_2D,BETAG,RLAP_E,RLAP_D
      CALL MSGDOC(MDOC,LINE)    
      ST = (STEP_NEW-STEP_PREV)*GGRAD
      IF(ST.GT.0.0) THEN
        T =(TFUNCT_NEW-TFUNCT_PREV)/ST
        TT=(GGRAD_2-GGRAD)/ST
        WRITE(LINE,'('' Df/Dx,Dg/Dx:'',2G12.4)')
     *  T,TT
        CALL MSGDOC(MDOC,LINE)    
      ENDIF
      ENDIF

      IF(NBACK.GT.0) THEN
        T=TFUNCT_PREV-TFUNCT_NEW
        IF(T.LT.0.0) THEN
          CALL STEP_BACK(MDOC,STEP,IERR)
          IF(IERR.NE.0) THEN
            RETURN
          ENDIF
          IF(NSTEP.EQ.0) THEN
            DSTEP = DSTEP * 0.5
            NGRAD = 0

            IF(IDEBUG.GT.0) THEN
              WRITE(LINE,*) ' now DSTEP:',DSTEP
              CALL MSGDOC(MDOC,LINE)    
            ENDIF

          ENDIF
        ENDIF

        IF(NFUNCT.GE.NCYCLE) GO TO 500

        GO TO 100
      ENDIF

      T=TFUNCT_PREV-TFUNCT_NEW
      IF(T.GT.0.0) THEN
        STEP = STEP + DS
        NTRIAL = 0 
        IF(NBACK.EQ.0) THEN
C V1--    IF(NSTEP.GE.3)  THEN
          IF(ALPHAG.GE.0.5)  THEN
            DSTEP = DSTEP * 1.25
            DS    = DS    * 1.25

            IF(IDEBUG.GT.0) THEN
              WRITE(LINE,*) '  now DSTEP:',DSTEP
              CALL MSGDOC(MDOC,LINE)    
            ENDIF

          ENDIF
        ENDIF

        IF(NFUNCT.GE.NCYCLE) GO TO 500

C V1 -- GO TO 200
        GO TO 100
      ENDIF

      WRITE(LINE,*) '  step back'
      CALL MSGDOC(MDOC,LINE)    

      CALL STEP_BACK(MDOC,STEP,IERR)
      IF(IERR.NE.0) THEN
        RETURN
      ENDIF

      IF(NBACK.EQ.1) THEN
        DS = DS/2.0
        STEP = STEP + DS
        IF(NSTEP.EQ.0) THEN
          DSTEP=DSTEP*0.5
          NTRIAL=NTRIAL+1

          IF(IDEBUG.GT.0) THEN
            WRITE(LINE,*) ' now DSTEP :',DSTEP
            CALL MSGDOC(MDOC,LINE)    
          ENDIF

        ENDIF 
        GO TO 200
      ENDIF
  
      IF(NFUNCT.GE.NCYCLE) GO TO 500

      GO TO 100

C -----
 300  CONTINUE


      RETURN
C -----
 500  CONTINUE
      RETURN
      END

      SUBROUTINE STEP_BACK(MDOC,STEP,IERR)
C ---------------------------------------------------------------- 
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'ref_com_str.fh'
      INCLUDE 'ref_com.fh'
C ----------------------------------------------------------------
      INTEGER     MDOC,IERR
C ----------------------------------------------------------------
      CHARACTER LINE*256
C==================================================================
      IERR= 0
      MD  = -ABS(MDOC)-1
      M   = 99
C --------
      ST = STEP_PREV-STEP_NEW
      TFUNCT_NEW  = TFUNCT_PREV
      TFUNCT_PREV = TFUNCT_PP
      STEP_NEW    = STEP_PREV
      STEP_PREV   = STEP_PP
      GGRAD_2     = G2_PREV
      G2_PREV     = G2_PP
      STEP        = STEP_NEW
      NSTEP       = NSTEP - 1
      NBACK       = NBACK + 1
C --------

      IF(REF.EQ.'S') SHIFT_LIM_B = SHIFT_LIM_S 

      DO I=1,N_ATOM
        IF(IPOINTER_VAR(I).GT.0) THEN

          IF(REF.EQ.'B'.OR.REF.EQ.'T'.OR.REF.EQ.'S') THEN

            SX=SHIFT_ATOM(1,I)*ST
            SHIFT2 = SX*SX 
            SHIFT  = SQRT(SHIFT2) 
            IF(SHIFT.GT.SHIFT_LIM_B) THEN
              T=SHIFT_LIM_B/SHIFT
              SX = SX*T
            ENDIF
c           B_ISO (I) = B_ISO (I) + SX 
            IF(REF.EQ.'S') THEN 
              PHI_VAR(I) = PHI_VAR(I) + SX
            ELSE
              U_ANISO(1,I) = U_ANISO(1,I) + SX
            ENDIF
          ELSE

            SX=SHIFT_ATOM(1,I)*ST
            SY=SHIFT_ATOM(2,I)*ST
            SZ=SHIFT_ATOM(3,I)*ST
            SHIFT2 = SX*SX + SY*SY + SZ*SZ
            SHIFT  = SQRT(SHIFT2) 
            IF(SHIFT.GT.SHIFT_LIM) THEN
              T=SHIFT_LIM/SHIFT
              SX = SX*T
              SY = SY*T
              SZ = SZ*T
            ENDIF
            XYZ_CRD (1,I) = XYZ_CRD (1,I) + SX 
            XYZ_CRD (2,I) = XYZ_CRD (2,I) + SY
            XYZ_CRD (3,I) = XYZ_CRD (3,I) + SZ

          ENDIF

        ENDIF
      ENDDO
C --------  
      IF(REF.NE.'E'.AND.REF.NE.'T'.AND.REF.NE.'S') THEN
      WRITE(LINE,*) ' now Function:',TFUNCT_NEW
      CALL MSGDOC(MDOC,LINE)    
      ENDIF

      RETURN
      END

      SUBROUTINE FUNCT(MDOC,LIST,POOL,MEMORY,NCRDMAX
     *   ,NSYM,ISYM,IPRSYM,IERR)
C -------------------------------------------------------- 
      INCLUDE 'atom_com.fh'
      INCLUDE 'ref_com.fh'
C --------------------------------------------------------
      INTEGER*2 ISYM(5,3,IPRSYM)
      REAL      POOL(MEMORY)
C ---------------------------------------------------------------
      INTEGER     MDOC,IERR
C ----------------------------------------------------------------
      CHARACTER LINE*256,LIST*1
C==================================================================
      IERR= 0
      MD  = -ABS(MDOC)-1
      M   = 99
C -----------------------------------------------------------------
      TFUNCT   = 0.0
      TFUNCT_D = 0.0
      TFUNCT_E = 0.0
C---------
      GGRAD_2  = 0.0      
      GGRAD_2D = 0.0      
      GGRAD_2E = 0.0
      RLAP_T   = 0.0
      RLAP_E   = 0.0
      RLAP_D   = 0.0
      BETAG    = 0.0      
      DO I=1,N_ATOM
        DO J=1,3
          SHIFT2_ATOM(J,I) = 0.0
        ENDDO
      ENDDO
C --------
      IF(REF.EQ.'X'.OR.REF.EQ.'R'.OR.REF.EQ.'B'.OR.REF.EQ.'T') THEN
        CALL D_FUNCT(MDOC
     *   ,POOL,MEMORY,NCRDMAX,NSYM,ISYM,IPRSYM,IERR)
        IF(IERR.NE.0) RETURN
      ENDIF
C --------
      IF(REF.EQ.'E'.OR.REF.EQ.'R'.OR.REF.EQ.'T'.OR.REF.EQ.'S') THEN
        MDDD=3
        IF(NFUNCT.EQ.0) MDDD=2
        IF(ABS(MDOC).GE.99) MDDD = 99

        IF(LIST.EQ.'T') THEN
          MDDD = MDOC
          WRITE(*,*) '--EE_FUNCT_S:'//REF
        ENDIF 

        IF(REF.EQ.'S') THEN
          CALL EE_FUNCT_S(MDDD,LIST,IERR)  
          IF(IERR.NE.0) RETURN
        ELSE
          CALL EE_FUNCT(MDDD,LIST,IERR)  
          IF(IERR.NE.0) RETURN
        ENDIF

      ENDIF
C ----------
      TFUNCT = TFUNCT_D * (1.0-WEIGHT) + TFUNCT_E * WEIGHT
      IF(NFUNCT.EQ.0) THEN
        TFUNCT_OLD = TFUNCT
        TFUNCT_PP  = 0.0
        TFUNCT_S   = 0.0
        G2_PREV    = 0.0
        G2_PP      = 0.0
        STEP_PREV  = 0.0
        STEP_PP    = 0.0
        STEP_NEW   = 0.0

        DO I=1,N_ATOM
          IF(IPOINTER_VAR(I).GT.0) THEN
            IF(REF.EQ.'B'.OR.REF.EQ.'T'.OR.REF.EQ.'S') THEN
              SHIFT_ATOM(1,I) = SHIFT2_ATOM(1,I)
            ELSE
              DO J=1,3
                SHIFT_ATOM(J,I) = SHIFT2_ATOM(J,I)
              ENDDO
            ENDIF
          ENDIF
        ENDDO

        GGRAD      = GGRAD_2 
        GGRAD_OLD  = GGRAD_2
      ENDIF
C ----
      ALPHAG  = 0.0
      GAMMAG  = 0.0
      GGRAD_2 = 0.0
      G1G2    = 0.0
      G1G1    = 0.0
      NVAR    = 0
      DO I=1,N_ATOM
        IF(IPOINTER_VAR(I).GT.0) THEN
          NVAR = NVAR + 1
          T  = 0.0
          T1 = 0.0
          T2 = 0.0
          IF(REF.EQ.'B'.OR.REF.EQ.'T'.OR.REF.EQ.'S') THEN
            T  = T  + SHIFT2_ATOM(1,I) * SHIFT2_ATOM(1,I)
            T1 = T1 + SHIFT_ATOM(1,I)  * SHIFT2_ATOM(1,I)
            T2 = T2 + SHIFT_ATOM(1,I)  * SHIFT_ATOM(1,I)
          ELSE
            DO J=1,3
              T  = T  + SHIFT2_ATOM(J,I) * SHIFT2_ATOM(J,I)
              T1 = T1 + SHIFT_ATOM(J,I)  * SHIFT2_ATOM(J,I)
              T2 = T2 + SHIFT_ATOM(J,I)  * SHIFT_ATOM(J,I)
            ENDDO
          ENDIF
          GGRAD_2 = GGRAD_2 + T
          G1G2    = G1G2    + T1
          G1G1    = G1G1    + T2
        ENDIF
      ENDDO
C ---
      IF(NVAR.GT.0) THEN
        GGRAD_2 = SQRT(GGRAD_2/NVAR)
        G1G1    = SQRT(G1G1/NVAR)
        G1G2    = G1G2/NVAR
      ENDIF
      IF(NGRAD.EQ.0) GGRAD = GGRAD_2 
      IF(GGRAD_2.GT.0.0.AND.G1G1.GT.0.0) THEN
        ALPHAG  = G1G2/(GGRAD_2*G1G1)
      ENDIF
      IF(GGRAD.GT.0.0) THEN
        GAMMAG  = GGRAD_2/GGRAD
      ENDIF
C -----
      TFUNCT_NEW = TFUNCT
      NFUNCT     = NFUNCT+1
C ----
      RETURN
      END


      SUBROUTINE LIN_STEP(MDOC,LIST,STEP
     * ,POOL,MEMORY,NCRDMAX,NSYM,ISYM,IPRSYM,IERR)
C -------------------------------------------------------- 
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'ref_com_str.fh'
      INCLUDE 'ref_com.fh'
      INCLUDE 'rstr_com.fh'
C --------------------------------------------------------------
      INTEGER*2 ISYM(5,3,IPRSYM)
      REAL      POOL(MEMORY)
C ---------------------------------------------------------------
      INTEGER     MDOC,IERR
C --------------------------------------------------
      CHARACTER LINE*256,LIST*1
C==================================================================
      IERR= 0
      MD  = -ABS(MDOC)-1
      M   = 99
C --------
      TFUNCT_PP   = TFUNCT_PREV
      TFUNCT_PREV = TFUNCT_NEW
      G2_PP       = G2_PREV
      G2_PREV     = GGRAD_2
      STEP_PP     = STEP_PREV
      STEP_PREV   = STEP_NEW
      STEP_NEW    = STEP
      SHIFT_AVER  = 0.0
      SHIFT_RMS   = 0.0
      SHIFT_MAX   = 0.0

      ST = STEP_NEW-STEP_PREV
      ST_AVER = 0.0
      ST_RMS  = 0.0
      ST_MAX  = 0.0
C --------
      IF(REF.EQ.'S') SHIFT_LIM_B = SHIFT_LIM_S 
      NVAR = 0
      DO I=1,N_ATOM
        IF(IPOINTER_VAR(I).GT.0) THEN
          NVAR = NVAR + 1

          IF(REF.EQ.'B'.OR.REF.EQ.'T'.OR.REF.EQ.'S') THEN

            SX=SHIFT_ATOM(1,I)*ST
            SHIFT2 = SX*SX 
            SHIFT  = SQRT(SHIFT2) 
            ST_AVER = ST_AVER + SHIFT
            ST_RMS  = ST_RMS  + SHIFT2
            IF(SHIFT.GT.ST_MAX) ST_MAX=SHIFT
            IF(SHIFT.GT.SHIFT_LIM_B) THEN
              T=SHIFT_LIM_B/SHIFT
              SX = SX*T
            ENDIF
C           B_ISO (I) = B_ISO (I) + SX 
            IF(REF.EQ.'S') THEN 
              PHI_VAR(I) = PHI_VAR(I) + SX
            ELSE
              U_ANISO(1,I) = U_ANISO(1,I) + SX
            ENDIF
          ELSE

            SX=SHIFT_ATOM(1,I)*ST
            SY=SHIFT_ATOM(2,I)*ST
            SZ=SHIFT_ATOM(3,I)*ST
            SHIFT2 = SX*SX + SY*SY + SZ*SZ
            SHIFT  = SQRT(SHIFT2) 
            ST_AVER = ST_AVER + SHIFT
            ST_RMS  = ST_RMS  + SHIFT2
            IF(SHIFT.GT.ST_MAX) ST_MAX=SHIFT
            IF(SHIFT.GT.SHIFT_LIM) THEN
              T=SHIFT_LIM/SHIFT
              SX = SX*T
              SY = SY*T
              SZ = SZ*T
            ENDIF
            XYZ_CRD (1,I) = XYZ_CRD (1,I) + SX 
            XYZ_CRD (2,I) = XYZ_CRD (2,I) + SY
            XYZ_CRD (3,I) = XYZ_CRD (3,I) + SZ

          ENDIF

        ENDIF
      ENDDO
C --------
      IF(NVAR.GT.0) THEN
        ST_RMS = SQRT(ST_RMS/NVAR)
        ST_AVER= ST_AVER    /NVAR
      ENDIF

      IF(NSTEP.EQ.0.AND.NBACK.EQ.0) THEN
        SHIFT_MAX  = ST_MAX
        SHIFT_RMS  = ST_RMS
        SHIFT_AVER = ST_AVER   
      ENDIF

      IF(IDEBUG.GT.0) THEN
        WRITE(LINE,'(''    <shift>,rms,max :'',3G12.4)') 
     *  ST_AVER,ST_RMS,ST_MAX
        CALL MSGDOC(MDOC,LINE)    
      ENDIF
C --------
      CALL FUNCT(MDOC,LIST
     * ,POOL,MEMORY,NCRDMAX,NSYM,ISYM,IPRSYM,IERR)
      IF(IERR.NE.0) RETURN
C --------
      NSTEP=NSTEP+1
      RETURN
      END

      SUBROUTINE GRAD_SHIFT(MDOC
     * ,POOL,MEMORY,NCRDMAX,NSYM,ISYM,IPRSYM,IERR)
C -------------------------------------------------------- 
      INCLUDE 'atom_com.fh'
      INCLUDE 'ref_com.fh'
C --------------------------------------------------------------
      INTEGER*2 ISYM(5,3,IPRSYM)
      REAL      POOL(MEMORY)
C ---------------------------------------------------------------
      INTEGER     MDOC,IERR
C --------------------------------------------------
      CHARACTER LINE*256
C==================================================================
      IERR= 0
      MD  = -ABS(MDOC)-1
      M   = 99
C --------
      IF(ABS(STEP_NEW).GT.0.0) THEN
        GGRAD_OLD  = GGRAD
        SS_OLD     = STEP_NEW
        TFUNCT_OLD = TFUNCT_S
      ENDIF
C --------
      IF(ALPHAG.LE.0.0) NGRAD=0
      DO I=1,N_ATOM
        IF(IPOINTER_VAR(I).GT.0) THEN

          IF(NGRAD.EQ.0) THEN
            IF(REF.EQ.'B'.OR.REF.EQ.'T'.OR.REF.EQ.'S') THEN
              SHIFT_ATOM(1,I)=SHIFT2_ATOM(1,I)
            ELSE
              SHIFT_ATOM(1,I)=SHIFT2_ATOM(1,I)
              SHIFT_ATOM(2,I)=SHIFT2_ATOM(2,I)
              SHIFT_ATOM(3,I)=SHIFT2_ATOM(3,I)
            ENDIF
          ELSE
            T = GAMMAG* SS_OLD
            IF(REF.EQ.'B'.OR.REF.EQ.'T'.OR.REF.EQ.'S') THEN
              SHIFT_ATOM(1,I)=SHIFT_ATOM(1,I) * T + SHIFT2_ATOM(1,I)
            ELSE
              SHIFT_ATOM(1,I)=SHIFT_ATOM(1,I) * T + SHIFT2_ATOM(1,I)
              SHIFT_ATOM(2,I)=SHIFT_ATOM(2,I) * T + SHIFT2_ATOM(2,I)
              SHIFT_ATOM(3,I)=SHIFT_ATOM(3,I) * T + SHIFT2_ATOM(3,I)
            ENDIF
          ENDIF

        ENDIF
      ENDDO
C --------
      TFUNCT_S    = TFUNCT_NEW
      TFUNCT_PREV = TFUNCT_NEW
      TFUNCT_PP   = TFUNCT_NEW
      GGRAD       = GGRAD_2
      G2_PREV     = GGRAD_2
      G2_PP       = GGRAD_2
      STEP_NEW    = 0.0
      STEP_PREV   = 0.0
      STEP_PP     = 0.0
C --
      IF(MOD_R.EQ.'G') THEN
        NGRAD       = 0
      ELSE
        NGRAD       = NGRAD+1
      ENDIF
C --
      NSTEP       = 0
      NBACK       = 0
C -------
      RETURN
      END
C ^==================
C ^==================

C ----- subroutines ---------------------

      SUBROUTINE WR_REF_COOR(MDOC,NAMEO,EXT,IERR)
C --------------------------------------------------
      INTEGER   MDOC,IERR
      CHARACTER NAMEO*(*),EXT*3
C ----
      CHARACTER LINE*256,PATH*80
C -----------------------------------------------------------------
      INCLUDE 'crd_com.fh'
C==================================================================
      IERR = 0
      MD   = -ABS(MDOC)-1
      M    = 99
C ---
      CALL LENSTR_BL(NAMEO,LEN)
      IF(LEN.GT.0.AND.NAMEO(1:1).NE.','.AND.NAMEO(1:1).NE.' ') THEN 
        CALL MSGDOC(MDOC,' --- write CRD_file ---')
C       IOUT = 11
        IOUT = CRO_IUN
        PATH = ' '
        CALL OPENFW(IOUT,M,PATH,NAMEO,EXT,IERR)
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERR: OPEN OUTPUT_FILE /crd/ .')
          GO TO 100
        ENDIF  
        CLOSE(IOUT) 
C ---
        CALL WRITE_ATOMS(MDOC,PATH,NAMEO,EXT,IERR)
        IF(IERR.NE.0) THEN
          GO TO 100
        ENDIF
C ---
      ENDIF
C --------------------------------------
 100  CONTINUE
      RETURN
      END


      SUBROUTINE INIT_AT_INF(MDOC,IERR)
C===================================================================
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'ref_com_str.fh'
C ========================================================================
      CHARACTER LINE*256
C==================================================================
      IERR = 0
C ---
      LN_N         = 0
      MOD_N        = 0
      N_GROUP      = 0  
      N_RESIDUE    = 0
      N_ANISO      = 0
      N_ATOM       = 0
C ---
      N_PHI        = 0
C ---
      RETURN
      END

      SUBROUTINE EE_FUNCT_S(MDOC,LIST,IERR)
C --------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'rstr_com.fh'
      INCLUDE 'ref_com.fh'
      INCLUDE 'ref_com_str.fh'
C ----------------------------------------------------------------
      INCLUDE 'ener_com.fh'
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR
      CHARACTER   LINE*256,LIST*1
C ----------------------------------------------------------------
      REAL        RMS_B
      INTEGER     NB_GT_1S,NB_GT_3S,NB_GT_10S
      REAL        RMS_A
      INTEGER     NA_GT_1S,NA_GT_3S,NA_GT_10S
      REAL        RMS_T
      INTEGER     NT_GT_1S,NT_GT_3S,NT_GT_10S
      REAL        RMS_C
      INTEGER     NC_GT_1S,NC_GT_3S,NC_GT_10S
      REAL        RMS_P
      INTEGER     NP_GT_1S,NP_GT_3S,NP_GT_10S
      INTEGER     RS_NBOND,RSV_NVDW,RS_NANGL,RS_NTORS,RS_NCHIR
     *           ,RS_NPLAN,RSV_NHB
C ---------------------------------------------------------------
      IERR  = 0
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C ---
      MD  =-ABS(MDOC)-1
      M   = 99
      MDD = MD
      IF(ABS(MDOC).EQ.2.OR.ABS(MDOC).EQ.3) MDD=99      
      IF(ABS(MDOC).EQ.3) MD =99
      IF(LIST.EQ.'T') THEN
        MD  =-ABS(MDOC)-1
        MDD = MD

        md  = mdoc
        mdd = mdoc

      ENDIF 
C --------
      WT_BOND  = 1.0
      WT_ANGLE = 1.0
      WT_TORS  = 1.0
      WT_VDW   = 1.0
      WT_HB    = 1.0
C --------------
      NB_GT_1S  = 0
      NB_GT_3S  = 0
      NB_GT_10S = 0
      RMS_B     = 0.0
C --------
      IF(N_ATOM.LE.1) THEN
        CALL MSGERR(MDOC,'ERROR: number of atoms < 2')
        IERR=1
        RETURN
      ENDIF
C --------
      DO I=1,N_PHI
        J = IP_PSI(I)
        K = IATM_FOR(J)
        IF(K.GT.0) THEN
          ATM_PSI(K) = PHI_VAR(I)
        ENDIF
      ENDDO

      CALL ANGTOCR_S(MDOC,LIST,ATM_ISTART,ATM_IFINISH
     *  ,XYZ_CRD,ATM_NDIST
     *  ,ATM_DIST,ATM_THETA,ATM_PSI,ATM_CONN,MAXBRN,IERR)
      IF(IERR.NE.0) RETURN

C --------
      NR_ATOM            = 0
      ENER_TOTAL         = 0.0
      ENER_AVER          = 0.0
      ENER_RMS           = 0.0
      BOND_ENER_TOTAL    = 0.0
      BOND_ENER_AVER     = 0.0
      BOND_ENER_RMS      = 0.0
      ANGLE_ENER_TOTAL   = 0.0
      ANGLE_ENER_AVER    = 0.0
      ANGLE_ENER_RMS     = 0.0
      TORS_ENER_TOTAL    = 0.0
      TORS_ENER_AVER     = 0.0
      TORS_ENER_RMS      = 0.0
      VDW_ENER_TOTAL     = 0.0
      VDW_ENER_AVER      = 0.0
      VDW_ENER_RMS       = 0.0
      HB_ENER_TOTAL      = 0.0
      HB_ENER_AVER       = 0.0
      HB_ENER_RMS        = 0.0
      SHIFTE_AVER        = 0.0
      SHIFTE_RMS         = 0.0
      SHIFTE_MAX         = 0.0
      RLAP_AVER          = 0.0
C 
      RSV_NVDW     = 0
      NVDW_GT_1S   = 0
      NVDW_GT_3S   = 0
      NVDW_GT_10S  = 0
      RMS_VDW      = 0.0
      DO IA=1,N_ATOM
C        I_BLOCK    (  IA)  = 0
        BOND_DER   (1,IA)  = 0.0
        BOND_DER   (2,IA)  = 0.0
        BOND_DER   (3,IA)  = 0.0
        BOND_DER2  (  IA)  = 0.0
        BOND_ENER  (  IA)  = 0.0 
        ANGLE_DER  (1,IA)  = 0.0
        ANGLE_DER  (2,IA)  = 0.0
        ANGLE_DER  (3,IA)  = 0.0
        ANGLE_DER2 (  IA)  = 0.0
        ANGLE_ENER (  IA)  = 0.0 
        TORS_DER   (1,IA)  = 0.0
        TORS_DER   (2,IA)  = 0.0
        TORS_DER   (3,IA)  = 0.0
        TORS_DER2  (  IA)  = 0.0
        VDW_ENER   (  IA)  = 0.0 
        VDW_DER    (1,IA)  = 0.0
        VDW_DER    (2,IA)  = 0.0
        VDW_DER    (3,IA)  = 0.0
        VDW_DER2   (  IA)  = 0.0
        HB_ENER    (  IA)  = 0.0 
        HB_DER     (1,IA)  = 0.0
        HB_DER     (2,IA)  = 0.0
        HB_DER     (3,IA)  = 0.0
        HB_DER2    (  IA)  = 0.0
        HB_ENER    (  IA)  = 0.0 
      ENDDO
C --------
      NA_PLAN     = 0
      RS_NATOM    = 0
      RS_NBOND    = 0
      RS_NANGL    = 0
      RS_NTORS    = 0
      RS_NCHIR    = 0
      RS_NPLAN    = 0
C --------------------------------
      CALL ENER_STR(MDD,LIST,RS_NBOND,RSV_NVDW,NR_VDW
     *     ,RMS_B,NB_GT_1S,NB_GT_3S,NB_GT_10S
     *     ,RMS_VDW,NVDW_GT_1S,NVDW_GT_3S,NVDW_GT_10S,SLIM,IERR)
      IF(IERR.NE.0) RETURN
C --------------------------------
      DO I=1,N_PHI

c        BOND_DER(1,I) = BOND_DER(1,I)/PI180
c        VDW_DER(1,I)  = VDW_DER(1,I)/PI180

        IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) 'der:',i,BOND_DER(1,I),VDW_DER(1,I),NR_VDW
        CALL MSGDOC(MDOC,LINE)
        ENDIF

      ENDDO
C --------------------------------
      CALL CALC_SHFT_E(MDOC,RS_NBOND,RMS_B,COEF,IERR)
      IF(IERR.NE.0) RETURN

      DO I=1,N_PHI

        SHIFT2_ATOM(1,I)  =  SHIFT2_ATOM(1,I)/(PI180*20.0)

        IF(LIST.EQ.'T') THEN
          WRITE(LINE,*) 'shft> ',SHIFT2_ATOM(1,I)
          CALL MSGDOC(MDOC,LINE)
        ENDIF

      ENDDO
C --------------------------------
      IF(N_ATOM.GT.0) THEN
        NVAR = 0
        DO I=1,N_ATOM
          IF(IPOINTER_VAR(I).GT.0) NVAR = NVAR + 1 
        ENDDO
        IF(NVAR.GT.0) THEN
          ENER_AVER = ENER_TOTAL/NVAR
          ENER_RMS  = SQRT(ENER_RMS/NVAR)
        ENDIF
      ENDIF
      TFUNCT_E = 0.0
      IF(RLAP_E.GT.0.0) THEN
C       TFUNCT_E = (ENER_AVER)/(SQRT(RLAP_E))
        TFUNCT_E = (ENER_AVER)/RLAP_E
        IF(REF.EQ.'T') TFUNCT_E = TFUNCT_E / 2.0 
      ENDIF

      IF(IDEBUG.GT.0) THEN
      WRITE(LINE,'('' Function_E,Lap :'',2G12.4)') 
     * TFUNCT_E,RLAP_E
      CALL MSGDOC(MDOC,LINE)
      ENDIF

      CALL MSGDOC(MD,'----- ')
C      WRITE(LINE,'('' N_atom, NR_atom (refined)   :'',2I8)') 
C     * N_ATOM,NR_ATOM
c      WRITE(LINE,'(I4,'') Energy,<Energy>,Energy_rms :'',4G12.4)') 
c     * NF,ENER_TOTAL,ENER_AVER,ENER_RMS,RLAP_E

      NF = NFUNCT+1
      IF(REF.EQ.'E'.OR.REF.EQ.'S') THEN
      WRITE(LINE,'(I4,'') Energy,<Energy>,Energy_rms :'',3G12.4)') 
     * NF,ENER_TOTAL,ENER_AVER,ENER_RMS
      CALL MSGDOC(MDOC,LINE)
      ELSE
      WRITE(LINE,'(I4,'') Function,<F>,F_rms :'',3G12.4)') 
     * NF,ENER_TOTAL,ENER_AVER,ENER_RMS
      CALL MSGDOC(MDOC,LINE)
      ENDIF 
      CALL MSGDOC(MD,'----- ')
      WRITE(LINE,'(''      <Shift>,Shift_rms,Shift_max :'',3G12.4)') 
     * SHIFTE_AVER,SHIFTE_RMS,SHIFTE_MAX
      CALL MSGDOC(MDOC,LINE)
C ---
        WRITE(LINE,'(''           N_atom             :'',I8)') 
     * N_ATOM
      CALL MSGDOC(MDOC,LINE)
      IF(RS_NBOND.GT.0) THEN
        CALL MSGDOC(MD,'----- ')
        BOND_ENER_AVER = BOND_ENER_TOTAL/RS_NBOND
        BOND_ENER_RMS  = SQRT(BOND_ENER_RMS/RS_NBOND)
        WRITE(LINE,'('' Number of bond restraints    :'',I12)') 
     *  RS_NBOND
        CALL MSGDOC(MD,LINE)

        WRITE(LINE,'(''           bond energy        :'',G12.4)') 
     *   BOND_ENER_TOTAL 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''          <bond energy>       :'',G12.4)') 
     *   BOND_ENER_AVER 
        CALL MSGDOC(MDOC,LINE)
        WRITE(LINE,'(''           bond_energy_rms    :'',G12.4)') 
     *   BOND_ENER_RMS 
        CALL MSGDOC(MD,LINE)


        WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     *   NB_GT_1S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     *   NB_GT_3S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     *  NB_GT_10S
        CALL MSGDOC(MD,LINE)
        IF(RS_NBOND.GT.0) THEN
          RMS_B=SQRT(RMS_B/RS_NBOND)
          WRITE(LINE,'(''           bond_rms           :'',F12.4)') 
     *    RMS_B
          CALL MSGDOC(MDOC,LINE)
        ENDIF
      ENDIF
C ---
      IF(RSV_NVDW.GT.0) THEN
        VDW_ENER_AVER = VDW_ENER_TOTAL/RSV_NVDW
        VDW_ENER_RMS  = SQRT(VDW_ENER_RMS/RSV_NVDW)
        CALL MSGDOC(MD,'----- ')
        WRITE(LINE,'('' Number of VDW_contacts        :'',I8)') 
     *   RSV_NVDW
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           VDW energy        :'',G12.4)') 
     *   VDW_ENER_TOTAL 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''          <VDW energy>       :'',G12.4)') 
     *   VDW_ENER_AVER 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           VDW_energy_rms    :'',G12.4)') 
     *   VDW_ENER_RMS 
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 1sig  :'',I12)') 
     *   NVDW_GT_1S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 3sig  :'',I12)') 
     *  NVDW_GT_3S
        CALL MSGDOC(MD,LINE)
        WRITE(LINE,'(''           restraints > 10sig :'',I12)') 
     *  NVDW_GT_10S
        CALL MSGDOC(MD,LINE)
        IF(RSV_NVDW.GT.0) THEN
          RMS_VDW = SQRT(RMS_VDW/RSV_NVDW)
          WRITE(LINE,'(''           rms                :'',F12.4)') 
     *    RMS_VDW
          CALL MSGDOC(MD,LINE)
        ENDIF
      ENDIF
C ---
      CALL MSGDOC(MD,'----- ')
C --------------------------------------
      RETURN
      END

      SUBROUTINE ENER_STR(MDOC,LIST,RS_NBOND,RSV_NVDW,IVDW
     *     ,RMS_B,NB_GT_1S,NB_GT_3S,NB_GT_10S
     *     ,RMS_VDW,NVDW_GT_1S,NVDW_GT_3S,NVDW_GT_10S,SLIMR,IERR)
C --------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'rstr_com.fh'
      INCLUDE 'ref_com.fh'
      INCLUDE 'ref_com_str.fh'
C ----------------------------------------------------------------
      INCLUDE 'ener_com.fh'
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR
      INTEGER     RS_NBOND,RSV_NVDW
      CHARACTER   LINE*256,LIST*1
C ----------------------------------------------------------------
      REAL        RMS_B,SLIMR
      INTEGER     NB_GT_1S,NB_GT_3S,NB_GT_10S
      REAL        RMS_VDW
      INTEGER     NVDW_GT_1S,NVDW_GT_3S,NVDW_GT_10S
      REAL        SMALL_DIST
C --------------------------------------
      IERR = 0
      SMALL_DIST = 0.1
C ---------------------------------------------------------------
      RMAX  = 0
      DMAX  = 5.0
      ENERGY_VDW_MAX = -1.0E30
      DIST_VDW_MAX   = 0.0 
      DMAX2 = DMAX*DMAX
      IDUMMY = N_ATOM - ATM_NDUMMY + 1

      IF(LIST.EQ.'T') WRITE(*,*) '--ENER_SRT---',MDOC,MOD_E
C -------------------
      DO J=3,N_ATOM
        DO I=J-1,1,-1
          CALL CHECK(ITP,IBOND,IVDW,I,J)
          IF(ITP.EQ.0.AND.IBOND.EQ.0) GO TO 100
          XX = XYZ_CRD(1,I) - XYZ_CRD(1,J)
          YY = XYZ_CRD(2,I) - XYZ_CRD(2,J)
          ZZ = XYZ_CRD(3,I) - XYZ_CRD(3,J)
          IF(ITP.GT.0) THEN
            IF(ABS(XX).GT.DMAX.AND.ABS(YY).GT.DMAX.AND.
     *         ABS(ZZ).GT.DMAX                         ) THEN
              ITP = 0
            ENDIF
          ENDIF
          IF(ITP.EQ.0.AND.IBOND.EQ.0) GO TO 100
          R = XX*XX+YY*YY+ZZ*ZZ
          IF((R.LE.DMAX2.AND.ITP.GT.0).OR.IBOND.NE.0) THEN

            CALL FNCTN(MDOC,LIST,IBOND,R,RS_NBOND
     *                ,ENERGY,DERIV,DERIV2,DELTA,TEST,IERR)
            IF(IERR.NE.0) THEN
              IBOND = 0
              IERR  = 0
              GO TO 100
            ENDIF
            IF(ITP.GT.0) THEN
              IF(MOD_E.EQ.'2') THEN
              CALL FNCTN_VDW(MDOC,LIST,ITP,R,RSV_NVDW,I,J
     *        ,ENERGY_VDW,DERIV_VDW,DERIV2_VDW,DELTA_VDW,TEST_VDW,IERR)
              ELSE 
              CALL FNCTN_VDW_2(MDOC,LIST,ITP,R,RSV_NVDW,I,J
     *        ,ENERGY_VDW,DERIV_VDW,DERIV2_VDW,DELTA_VDW,TEST_VDW,IERR)
              ENDIF
              IF(LIST.EQ.'T') THEN
                IF(ENERGY_VDW.GT.ENERGY_VDW_MAX) THEN 
                  ENERGY_VDW_MAX = ENERGY_VDW
                  DIST_VDW_MAX   = SQRT(R)
                ENDIF
              ENDIF

            ENDIF
   
                IF(IBOND.GT.0) THEN
                  BOND_ENER_TOTAL = BOND_ENER_TOTAL + 2.0*ENERGY   
                  BOND_ENER_RMS   = BOND_ENER_RMS   + 4.0*ENERGY*ENERGY
c                  ENER_TOTAL      = ENER_TOTAL      + 2.0*ENERGY
c                  ENER_RMS        = ENER_RMS        + 4.0*ENERGY*ENERGY
                  IF(TEST.GT. 1.0) NB_GT_1S  = NB_GT_1S  + 1 
                  IF(TEST.GT. 3.0) NB_GT_3S  = NB_GT_3S  + 1 
                  IF(TEST.GT.10.0) NB_GT_10S = NB_GT_10S + 1
                  RMS_B = RMS_B + DELTA*DELTA 
                ELSE IF(ITP.GT.0) THEN
                  VDW_ENER_TOTAL = VDW_ENER_TOTAL + 2.0*ENERGY_VDW   
                  VDW_ENER_RMS   = VDW_ENER_RMS   + 
     *                                   4.0*ENERGY_VDW*ENERGY_VDW
c                  ENER_TOTAL     = ENER_TOTAL     + 2.0*ENERGY_VDW
c                  ENER_RMS       = ENER_RMS       + 
c     *                                   4.0*ENERGY_VDW*ENERGY_VDW
                  IF(TEST_VDW.GT.0.0) THEN
                    IF(TEST_VDW.GT. 1.0) NVDW_GT_1S  = NVDW_GT_1S  + 1 
                    IF(TEST_VDW.GT. 3.0) NVDW_GT_3S  = NVDW_GT_3S  + 1 
                    IF(TEST_VDW.GT.10.0) NVDW_GT_10S = NVDW_GT_10S + 1
                    RMS_VDW = RMS_VDW + DELTA_VDW*DELTA_VDW
                  ENDIF
                ENDIF 
C ---
            
            L1  = IATM_BACK(J)
            L1B = 0
            IF(L1.GT.0) L1B = IATM_BACK(L1)
            L2  = IATM_BACK(I)
            L2B = 0
            IF(L2.GT.0) L2B = IATM_BACK(L2)

C            IF(L1.LE.I.OR.L1B.LE.I) GO TO 610 

  600       IF(L1.EQ.L2) GO TO 610
           
            IF(L1.GT.L2) THEN
              L     = L1
              LL    = L2
              ICOEF = 1
            ELSE
              L     = L2
              LL    = L1
              ICOEF =-1
            ENDIF
            N9 = IATM_BACK(L)

c      IF(LIST.EQ.'T') THEN
c        write(line,'(A,6I4)') 'i,j,l,n9,ll>>',I,J,L,N9,LL,icoef
c        call msgdoc(mdoc,line)
c      ENDIF

C            IF(N9.NE.LL) THEN
            IF(N9.GT.0) THEN
              IF(ID_PHI(L).NE.0) THEN

c      IF(LIST.EQ.'T') THEN
c        write(line,'(A,6I4)') ' ID_PHI>>',ID_PHI(L),IVDW
c        call msgdoc(mdoc,line)
c        write(*,*) 'atm_d:',ATM_DIST(L) 
c      ENDIF
                

                XKL = XYZ_CRD(1,L)-XYZ_CRD(1,N9)
                YKL = XYZ_CRD(2,L)-XYZ_CRD(2,N9)
                ZKL = XYZ_CRD(3,L)-XYZ_CRD(3,N9)
                XK  = XYZ_CRD(1,J)-XYZ_CRD(1,L)
                YK  = XYZ_CRD(2,J)-XYZ_CRD(2,L)
                ZK  = XYZ_CRD(3,J)-XYZ_CRD(3,L)
C               DF/DFI
                XLL  = YKL*ZK-ZKL*YK
                YLL  = ZKL*XK-XKL*ZK
                ZLL  = XKL*YK-YKL*XK
                DLL  = ATM_DIST(L)
                IF(DLL.LT.SMALL_DIST) DLL = SMALL_DIST
                DLL2 = DLL*DLL
                RLL  = (XLL*XLL+YLL*YLL+ZLL*ZLL)/DLL2
                IF(RLL.GT.RMAX) RMAX = RLL
                KL    = ID_PHI(L)
                IF(IBOND.GT.0) THEN
                  TEMP = -DERIV*(XX*XLL+YY*YLL+ZZ*ZLL)/DLL
                  IF(ICOEF.LT.0) TEMP=-TEMP
                  BOND_DER (1,KL) = BOND_DER (1,KL) + TEMP
                  BOND_DER2(  KL) = BOND_DER2(  KL) + DERIV2
                  BOND_ENER  (KL) = BOND_ENER(  KL) + ENERGY 
c                  BOND_ENER_TOTAL = BOND_ENER_TOTAL + 2.0*ENERGY   
c                  BOND_ENER_RMS   = BOND_ENER_RMS   + 4.0*ENERGY*ENERGY
                  ENER_TOTAL      = ENER_TOTAL      + 2.0*ENERGY
                  ENER_RMS        = ENER_RMS        + 4.0*ENERGY*ENERGY
c                  IF(TEST.GT. 1.0) NB_GT_1S  = NB_GT_1S  + 1 
c                  IF(TEST.GT. 3.0) NB_GT_3S  = NB_GT_3S  + 1 
c                  IF(TEST.GT.10.0) NB_GT_10S = NB_GT_10S + 1
c                  RMS_B = RMS_B + DELTA*DELTA 
                ELSE IF(ITP.GT.0) THEN
                  TEMP = -DERIV_VDW*(XX*XLL+YY*YLL+ZZ*ZLL)/DLL
                  IF(ICOEF.LT.0) TEMP=-TEMP
                  VDW_DER (1,KL) = VDW_DER (1,KL) + TEMP
                  VDW_DER2(  KL) = VDW_DER2(  KL) + DERIV2_VDW
                  VDW_ENER  (KL) = VDW_ENER(  KL) + ENERGY_VDW 
c                  VDW_ENER_TOTAL = VDW_ENER_TOTAL + 2.0*ENERGY_VDW   
c                  VDW_ENER_RMS   = VDW_ENER_RMS   + 
c     *                                   4.0*ENERGY_VDW*ENERGY_VDW
                  ENER_TOTAL     = ENER_TOTAL     + 2.0*ENERGY_VDW
                  ENER_RMS       = ENER_RMS       + 
     *                                   4.0*ENERGY_VDW*ENERGY_VDW
c                  IF(TEST_VDW.GT.0.0) THEN
c                    IF(TEST_VDW.GT. 1.0) NVDW_GT_1S  = NVDW_GT_1S  + 1 
c                    IF(TEST_VDW.GT. 3.0) NVDW_GT_3S  = NVDW_GT_3S  + 1 
c                    IF(TEST_VDW.GT.10.0) NVDW_GT_10S = NVDW_GT_10S + 1
c                    RMS_VDW = RMS_VDW + DELTA_VDW*DELTA_VDW
c                  ENDIF
                ENDIF 
              ENDIF
C            ENDIF
            ENDIF
            IF(ICOEF.GT.0) THEN
              L1 = N9
            ELSE
              L2 = N9
            ENDIF
            GO TO 600
  610       CONTINUE
C ----------------------
C ---
          ENDIF
 100      CONTINUE
        ENDDO
      ENDDO
C ------------
      RMAX = SQRT(RMAX)
      IF(LIST.EQ.'T') THEN
        WRITE(*,*) ' E_vdw_max,dist:',ENERGY_VDW_MAX,DIST_VDW_MAX 
      ENDIF
C ------------
      IERR= 0
      RETURN
      END

      SUBROUTINE FNCTN(MDOC,LIST,IB,DLEN2,RS_NBOND
     *                ,ENERGY,DERIV,DERIV2,DELTA,TEST,IERR)
C -------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'rstr_com.fh'
      INCLUDE 'ref_com.fh'
      INCLUDE 'ref_com_str.fh'
C -------------------------------------
      INTEGER   RS_NBOND
      CHARACTER LINE*256,LIST*1
      REAL SMALL_BOND
C --------------------------------------
      IERR = 0
      SMALL_BOND = 0.1
      IF(IB.LE.0.OR.IB.GT.NR_BOND) THEN
        IERR = 0
        RETURN
      ENDIF
      DLEN     = SQRT(DLEN2)
      IF(SMALL_BOND.GT.DLEN) DLEN = SMALL_BOND 
      RS_NBOND = RS_NBOND +1
      DELTA    = DLEN - RB_VIDL(IB)
      ENERGY   = (RB_CNST(IB) * DELTA * DELTA)/2.0
      DERIV    = (RB_CNST(IB) * DELTA)/DLEN 
      DERIV2   = 2.0 * RB_CNST(IB)
      SD       = RB_SDID(IB)
      IF(SD.LE.0.0) SD=1.0
      TEST     = ABS(DELTA)/SD

      IF(LIST.EQ.'T') THEN
        write(line,*) 'bond>>>',ib,rs_nbond,dlen,RB_VIDL(IB),ENERGY
        call msgdoc(mdoc,line)
        write(*,*) '>>',RB_CNST(IB),delta,DERIV, DERIV2
         write(*,*)'-1:',XYZ_CRD(1,RB_IA1(IB))
     *   ,XYZ_CRD(2,RB_IA1(IB)),XYZ_CRD(3,RB_IA1(IB))
         write(*,*)'-2:',XYZ_CRD(1,RB_IA2(IB))
     *  ,XYZ_CRD(2,RB_IA2(IB)),XYZ_CRD(3,RB_IA2(IB))
      ENDIF

      RETURN
      END

      SUBROUTINE FNCTN_VDW(MDOC,LIST,ITP,DLEN2,RSV_NVDW,I,J
     *                ,ENERGY,DERIV,DERIV2,DELTA,TEST,IERR)
C -------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'rstr_com.fh'
      INCLUDE 'ref_com.fh'
      INCLUDE 'ref_com_str.fh'
C -------------------------------------
      INTEGER   RSV_NVDW
      CHARACTER LINE*256,LIST*1,CHEM1*4,CHEM2*4
      REAL SMALL_BOND
C --------------------------------------
      SMALL_BOND = 0.1
      IF(ITP.EQ.0) RETURN

C     CH1  CH1     -0.13540     3.700   h
C     HNH1 HNH1    -0.04974     1.600   .
      DLEN     = SQRT(DLEN2)
      IF(SMALL_BOND.GT.DLEN) DLEN = SMALL_BOND 

      RSV_NVDW = RSV_NVDW +1

      RSV_RIDL = 3.6
      RSV_CNS  =-0.1

C      CHEM1 = CHEM_TYPE(I) 
C      CHEM2 = CHEM_TYPE(J)

C     HO HF HS HG HE
c     IF(ASYMB1(1:2).EQ.'H '.OR.ASYMB1(1:2).EQ.'D ') GO TO 100
C     RSV_RIDL = 1.6
C     RSV_CNS  =-0.05


      COEF     = 1.0
      R        = DLEN 
      R2       = R*R 
c      IF(R.LT.1.0) THEN
c        COEF = 1.0/R
c        R2   = 1.0
c        R    = 1.0
c        D2   = 1.0
c        D    = 1.0
c      ENDIF

      DELTA  = (R-RSV_RIDL)

      RR     = RSV_RIDL/R
      RR2    = RR*RR
      RR6    = RR2*RR2*RR2
      RR12   = RR6*RR6
      CNS    = ABS(RSV_CNS)

      ENERGY = (CNS * (RR12 - 2.0 * RR6))/2.0

      DERIV  = (-6.0/R2)*(CNS * RR12 + ENERGY*2.0) * COEF
      DERIV2 = ABS((72.0*CNS)/(RSV_RIDL*RSV_RIDL)) *10.0

      SD = 0.05
      IF(SD.LE.0.0) SD=1.0
      TEST = ABS(DELTA)/SD

      IF(DELTA.GE.0) THEN
        TEST = -1.0
      ENDIF

c      IF(LIST.EQ.'T') THEN
c        write(line,*) 'vdw>>',RSV_NVDW,i,j,RSV_RIDL,ENERGY
c        call msgdoc(mdoc,line)
c      ENDIF
     


      RETURN
      END

      SUBROUTINE FNCTN_VDW_2(MDOC,LIST,ITP,DLEN2,RSV_NVDW,I,J
     *                ,ENERGY,DERIV,DERIV2,DELTA,TEST,IERR)
C -------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'rstr_com.fh'
      INCLUDE 'ref_com.fh'
      INCLUDE 'ref_com_str.fh'
C -------------------------------------
      INTEGER   RSV_NVDW
      CHARACTER LINE*256,LIST*1,CHEM1*4,CHEM2*4
      REAL SMALL_BOND
C --------------------------------------
      SMALL_BOND = 0.1
      IF(ITP.EQ.0) RETURN

C     CH1  CH1     -0.13540     3.700   h
C     HNH1 HNH1    -0.04974     1.600   .
      DLEN     = SQRT(DLEN2)
      IF(SMALL_BOND.GT.DLEN) DLEN = SMALL_BOND 

      RSV_NVDW = RSV_NVDW +1

      RSV_RIDL = 3.6
      RSV_CNS  = 4.0
      IF(ATM_CHEM(I).EQ.'H   '.OR.ATM_CHEM(J).EQ.'H   ')RSV_RIDL = 2.6

C      CHEM1 = CHEM_TYPE(I) 
C      CHEM2 = CHEM_TYPE(J)
C     HO HF HS HG HE
c     IF(CHEM1(1:2).EQ.'H '.OR.CHEM2(1:2).EQ.'H ') GO TO 100
C     RSV_RIDL = 1.6
C     RSV_CNS  =-0.05

      CNS    = ABS(RSV_CNS)

      DELTA    = DLEN - RSV_RIDL
      IF(DELTA.GT.0.0) DELTA = 0.0
      ENERGY   = (CNS * DELTA * DELTA)/2.0
      DERIV    = (CNS * DELTA)/DLEN 
      DERIV2   = 2.0 * CNS


      SD = 0.05
      IF(SD.LE.0.0) SD=1.0
      TEST = ABS(DELTA)/SD

      IF(DELTA.GE.0) THEN
        TEST = -1.0
      ENDIF

c      IF(LIST.EQ.'T') THEN
c        write(line,*) 'vdw>>',RSV_NVDW,i,j,RSV_RIDL,ENERGY,deriv
c        call msgdoc(mdoc,line)
c      ENDIF
     
      RETURN
      END

      SUBROUTINE CHECK(ITP,IBOND,IVDW,I,J)
C ----------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'rstr_com.fh'
      INCLUDE 'ref_com.fh'
      INCLUDE 'ref_com_str.fh'
      CHARACTER LINE*256
C ----------------------------------------------------------------
      ITP   = 1
      IBOND = 0

C     itp=0 no vdw, ibond=0 no bond


      IF(NR_BOND.GT.0) THEN
        DO IB=1,NR_BOND

          IF((RB_IA1(IB).EQ.I.AND.RB_IA2(IB).EQ.J).OR.
     *       (RB_IA2(IB).EQ.I.AND.RB_IA1(IB).EQ.J)     ) THEN

c            if(ib.eq.1) then
            IBOND = IB
            GO TO 200
c            endif

          ENDIF
        ENDDO
      ENDIF
 200  CONTINUE

      NT = N_ATOM-ATM_NDUMMY

c        mdoc=1
c        write(line,*) 'VDW>>',I,J,NT,itp,ivdw
c        call msgdoc(mdoc,line)

      IF(IVDW.LE.0) THEN
        ITP = 0
        RETURN
      ENDIF

C      IF(I.GT.NT.OR.J.GT.NT) THEN
C        ITP = 0
C        RETURN
C      ENDIF

C      IF(ITYPE(J).NE.0)   GO TO 500
C      IF(ITYPE(I).NE.0)   GO TO 500
C      IF(IGROUP(I).EQ.IGROUP(J).AND.IGROUP(I).NE.0) GO TO 500
C      IF(ICHAIN(I).NE.ICHAIN(J)) GO TO 100

      CALL CHECK_TREE_CONN_S(MDOC,I,J,ICONN,IERR)

      IF(ICONN.EQ.1) ITP = 0


c      IF(ATM_CHEM(I).EQ.'H   '.OR.ATM_CHEM(J).EQ.'H   ') ITP = 0

c      IF(LIST.EQ.'T') THEN
C        mdoc=1
C        write(line,*) 'VDW>>>>>>',I,J,NT,itp
C        call msgdoc(mdoc,line)
c      ENDIF

C 100  CONTINUE
C      RETURN
C 500  ITP = 0

      RETURN
      END

      SUBROUTINE SET_CONN_S(IA,N,ICONN)
C -----------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'ref_com_str.fh'
C ----------------------------------------------------------
      INTEGER     IA,N,ICONN(*)
C -----------------------------------
      NT = N_ATOM-ATM_NDUMMY
      N  = 0
      IF(IA.LE.0) RETURN
      IF(IATM_BACK(IA).GT.0) THEN
        N = N + 1 
        ICONN(N) = IATM_BACK(IA)
      ENDIF
      IF(ATM_NDIST(IA).GT.0) THEN
        DO J=1,ATM_NDIST(IA)
          IC = ATM_CONN(J,IA)
          IF(IC.LE.NT) THEN 
            N = N + 1 
            ICONN(N) = IC
          ENDIF
        ENDDO
      ENDIF
      IF(IATM_EXTR(IA).GT.0.AND.IATM_EXTR(IA).LE.NT) THEN
        N = N + 1 
        ICONN(N) = IATM_EXTR(IA)
      ENDIF
      IF(IATM_EXTR2(IA).GT.0.AND.IATM_EXTR2(IA).LE.NT) THEN
        N = N + 1 
        ICONN(N) = IATM_EXTR2(IA)
      ENDIF
      IF(IATM_EXTR3(IA).GT.0.AND.IATM_EXTR3(IA).LE.NT) THEN
        N = N + 1 
        ICONN(N) = IATM_EXTR3(IA)
      ENDIF
C ----
      RETURN
      END


      SUBROUTINE CHECK_TREE_CONN_S(MDOC,IA1,IA2,ICONN_FLAG,IERR)
C -----------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'ref_com_str.fh'
C     INCLUDE 'crd_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,ICONN_FLAG,IA1,IA2
      INTEGER     ICONN(10),ICONN1(10),ICONN2(10)
C -----------------------------------
C     ICONN_FLAG = 1 there is connection; not to calc VDW 
      IERR       = 0
      ICONN_FLAG = 1
      NT = N_ATOM-ATM_NDUMMY
C ---
      IF(IA1.GT.NT.OR.IA1.LE.0) RETURN
      IF(IA2.GT.NT.OR.IA2.LE.0) RETURN
  
      CALL SET_CONN_S(IA1,N,ICONN)
      IF(N.LE.0) RETURN 
      DO I1=1,N
        IA11 = ICONN(I1)  
        IF(IA11.EQ.IA2) RETURN
        CALL SET_CONN_S(IA11,N1,ICONN1)
        IF(N1.GT.0) THEN
          DO I2=1,N1
            IA12 = ICONN1(I2)  
            IF(IA12.EQ.IA2) RETURN
            CALL SET_CONN_S(IA12,N2,ICONN2)
            IF(N2.GT.0) THEN
              DO I3=1,N2
                IA13 = ICONN2(I3)  
                IF(IA13.EQ.IA2) RETURN
              ENDDO
            ENDIF
          ENDDO
        ENDIF    
      ENDDO 
C ---
      ICONN_FLAG = 0
      RETURN
      END

      SUBROUTINE CHECK_TREE_CONN_S_old(MDOC,IA1,IA2,ICONN,IERR)
C -----------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'atom_com_str.fh'
      INCLUDE 'ref_com_str.fh'
C     INCLUDE 'crd_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,ICONN,IA1,IA2
C -----------------------------------
      IERR  = 0
      ICONN = 1
      NT = N_ATOM-ATM_NDUMMY
C ---
      IF(IA1.GT.NT) RETURN
      IF(IA2.GT.NT) RETURN
      IBA1  = IATM_BACK  (IA1)
      IFA1  = IATM_FOR   (IA1)
      IF(IFA1.GT.NT) IFA1 = 0
      IEA1  = IATM_EXTR  (IA1)
      IE2A1 = IATM_EXTR2 (IA1)

      IBA2  = IATM_BACK  (IA2)
      IFA2  = IATM_FOR   (IA2)
      IF(IFA2.GT.NT) IFA2 = 0
      IEA2  = IATM_EXTR  (IA2)
      IE2A2 = IATM_EXTR2 (IA2)
C
C      1 <--> 2        1 <...> 2
C

      IF(IBA1.EQ.IA2.OR.IBA2 .EQ.IA1) RETURN
      IF(IEA1.EQ.IA2.OR.IE2A1.EQ.IA2.OR.
     *   IEA2.EQ.IA1.OR.IE2A2.EQ.IA1    ) RETURN

C
C      1 ---> * ---> 2      1 ...> * ---> 2        1 <...> * <...> 2
C      1 <--- * <--- 2      1<---- * <... 2
C      1 <--- * ---> 2      1 ...> * <--- 2
C                           1 ---> * <... 2

      IBBA1 = 0
      IBBA2 = 0
      IF(IBA1.GT.0) IBBA1 = IATM_BACK(IBA1)
      IF(IBA2.GT.0) IBBA2 = IATM_BACK(IBA2)

      IF(IBBA1.EQ.IA2 .OR .IBBA2.EQ.IA1) RETURN
      IF(IBA1 .EQ.IBA2.AND.IBA2 .GT.0  ) RETURN

      IF((IEA1 .EQ.IBA2.OR.IE2A1.EQ.IBA2).AND.IBA2.GT.0) RETURN
      IF((IEA2 .EQ.IBA1.OR.IE2A2.EQ.IBA1).AND.IBA1.GT.0) RETURN

      IF(IEA1.GT.0) THEN
        IBEA1 = IATM_BACK(IEA1)
        IF(IBEA1 .EQ.IA2) RETURN
      ENDIF
      IF(IE2A1.GT.0) THEN
        IBE2A1 = IATM_BACK(IE2A1)
        IF(IBE2A1 .EQ.IA2) RETURN
      ENDIF

      IF(IEA2.GT.0) THEN
        IBEA2 = IATM_BACK(IEA2)
        IF(IBEA2 .EQ.IA1) RETURN
      ENDIF
      IF(IE2A2.GT.0) THEN
        IBE2A2 = IATM_BACK(IE2A2)
        IF(IBE2A2 .EQ.IA1) RETURN
      ENDIF

      IF((IEA1 .EQ.IEA2.OR.IEA1 .EQ.IE2A2).AND.IEA1 .GT.0) RETURN
      IF((IE2A1.EQ.IEA2.OR.IE2A1.EQ.IE2A2).AND.IE2A1.GT.0) RETURN

C ---
      IF(IBA1.GT.0) THEN
        IBBA1  = IATM_BACK  (IBA1)
        IBEA1  = IATM_EXTR  (IBA1)
        IBE2A1 = IATM_EXTR2 (IBA1)
        IF(IBA2.GT.0) THEN
C         IBA1 --> IBA2      IBA1 <-- IBA2     IBA1 .... IBA2
          IBBA2 = IATM_BACK(IBA2)
          IF(IBBA1.EQ.IBA2.OR.IBBA2.EQ.IBA1) RETURN
          IBEA2  = IATM_EXTR  (IBA2)
          IBE2A2 = IATM_EXTR2 (IBA2)
          IF(IBEA1.EQ.IBA2.OR.IBE2A1.EQ.IBA2) RETURN
          IF(IBEA2.EQ.IBA1.OR.IBE2A2.EQ.IBA1) RETURN
        ENDIF           

        IF(IFA2.GT.0) THEN
C         IBA1 --> IFA2      IBA1 <-- IFA2     IBA1 .... IFA2
          IBFA2 = IATM_BACK(IFA2)
          IF(IBBA1.EQ.IFA2.OR.IBFA2.EQ.IBA1) RETURN
          IFEA2  = IATM_EXTR  (IFA2)
          IFE2A2 = IATM_EXTR2 (IFA2)
          IF(IBEA1.EQ.IFA2.OR.IBE2A1.EQ.IFA2) RETURN
          IF(IFEA2.EQ.IBA1.OR.IFE2A2.EQ.IBA1) RETURN       
        ENDIF

        IF(IEA2.GT.0) THEN
C         IBA1 --> IEA2      IBA1 <-- IEA2 
          IBEA2 = IATM_BACK(IEA2)
          IF(IBBA1.EQ.IEA2.OR.IBEA2.EQ.IBA1) RETURN
          IF(IE2A2.GT.0) THEN
C           IBA1 --> IE2A2      IBA1 <-- IE2A2 
            IBE2A2 = IATM_BACK(IE2A2)
            IF(IBBA1.EQ.IE2A2.OR.IBE2A2.EQ.IBA1) RETURN
          ENDIF
        ENDIF
      ENDIF
C ---
      IF(IBA2.GT.0) THEN
        IBBA2  = IATM_BACK  (IBA2)
        IBEA2  = IATM_EXTR  (IBA2)
        IBE2A2 = IATM_EXTR2 (IBA2)
        IF(IFA1.GT.0) THEN
C         IFA1 --> IBA2      IFA1 <-- IBA2     IFA1 .... IBA2
          IBFA1 = IATM_BACK(IFA1)
          IF(IBBA2.EQ.IFA1.OR.IBFA1.EQ.IBA2) RETURN
          IFEA1  = IATM_EXTR  (IFA1)
          IFE2A1 = IATM_EXTR2 (IFA1)
          IF(IBEA2.EQ.IFA1.OR.IBE2A2.EQ.IFA1) RETURN
          IF(IFEA1.EQ.IBA2.OR.IFE2A1.EQ.IBA2) RETURN              
        ENDIF
        IF(IEA1.GT.0) THEN
C         IEA1 --> IBA2      IEA1 <-- IBA2 
          IBEA1 = IATM_BACK(IEA1)
          IF(IBBA2.EQ.IEA1.OR.IBEA1.EQ.IBA2) RETURN
          IF(IE2A1.GT.0) THEN
C           IE2A1 --> IBA2      IE2A1 <-- IBA2 
            IBE2A1 = IATM_BACK(IE2A1)
            IF(IBBA2.EQ.IE2A1.OR.IBE2A1.EQ.IBA2) RETURN
          ENDIF
        ENDIF
      ENDIF
C ---
      IF(IFA1.GT.0) THEN
        IBFA1  = IATM_BACK  (IFA1)
        IFEA1  = IATM_EXTR  (IFA1)
        IFE2A1 = IATM_EXTR2 (IFA1)
        IF(IFA2.GT.0) THEN
C         IFA1 --> IFA2      IFA1 <-- IFA2     IFA1 .... IFA2
          IBFA2 = IATM_BACK(IFA2)
          IF(IBFA2.EQ.IFA1.OR.IBFA1.EQ.IFA2) RETURN
          IFEA2  = IATM_EXTR  (IFA2)
          IFE2A2 = IATM_EXTR2 (IFA2)
          IF(IFEA2.EQ.IFA1.OR.IFE2A2.EQ.IFA1) RETURN
          IF(IFEA1.EQ.IFA2.OR.IFE2A1.EQ.IFA2) RETURN              
        ENDIF
        IF(IEA2.GT.0) THEN
C         IFA1 --> IEA2      IFA1 <-- IEA2 
          IBEA2 = IATM_BACK(IEA2)
          IF(IBEA2.EQ.IFA1.OR.IBFA1.EQ.IEA2) RETURN
          IF(IE2A2.GT.0) THEN
C           IFA1 --> IE2A2      IFA1 <-- IE2A2 
            IBE2A2 = IATM_BACK(IE2A2)
            IF(IBFA1.EQ.IE2A2.OR.IBE2A2.EQ.IFA1) RETURN
          ENDIF
        ENDIF
      ENDIF
C ---
      IF(IFA2.GT.0) THEN
        IBFA2  = IATM_BACK  (IFA2)
        IFEA2  = IATM_EXTR  (IFA2)
        IFE2A2 = IATM_EXTR2 (IFA2)
        IF(IEA1.GT.0) THEN
C         IEA1 --> IFA2      IEA1 <-- IFA2 
          IBEA1 = IATM_BACK(IEA1)
          IF(IBEA1.EQ.IFA2.OR.IBFA2.EQ.IEA1) RETURN
          IF(IE2A1.GT.0) THEN
C           IE2A1 --> IFA2      IE2A1 <-- IFA2 
            IBE2A1 = IATM_BACK(IE2A1)
            IF(IBFA2.EQ.IE2A1.OR.IBE2A1.EQ.IFA2) RETURN
          ENDIF
        ENDIF
      ENDIF
C ---
      IF(IEA1.GT.0) THEN
        IBEA1  = IATM_BACK(IEA1)
        IF(IEA2.GT.0) THEN
C         IEA1 --> IEA2      IEA1 <-- IEA2 
          IBEA2  = IATM_BACK(IEA2)
          IF(IBEA2.EQ.IEA1.OR.IBEA1.EQ.IEA2) RETURN
          IF(IE2A2.GT.0) THEN
C           IEA1 --> IE2A2      IEA1 <-- IE2A2 
            IBE2A2  = IATM_BACK(IE2A2)
            IF(IBE2A2.EQ.IEA1.OR.IBEA1.EQ.IE2A2) RETURN
          ENDIF
        ENDIF
        IF(IE2A1.GT.0) THEN
          IBE2A1  = IATM_BACK(IE2A1)
          IF(IEA2.GT.0) THEN
C           IE2A1 --> IEA2      IE2A1 <-- IEA2 
            IBEA2  = IATM_BACK(IEA2)
            IF(IBEA2.EQ.IE2A1.OR.IBE2A1.EQ.IEA2) RETURN
            IF(IE2A2.GT.0) THEN
C             IE2A1 --> IE2A2      IE2A1 <-- IE2A2 
              IBE2A2  = IATM_BACK(IE2A2)
              IF(IBE2A2.EQ.IE2A1.OR.IBE2A1.EQ.IE2A2) RETURN
            ENDIF
          ENDIF
        ENDIF
      ENDIF        
C ---
      ICONN = 0
      RETURN
      END

C ------------------------------------------------------------
      SUBROUTINE ENER_TORS(MDOC,RS_NAME,RS_NTORS,RS_LABEL
     *     ,IA1,IA2,IA3,IA4
     *     ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_PRD,RS_CNS
     *     ,RMS_T,NT_GT_1S,NT_GT_3S,NT_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,LIST,IERR)
C -----------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NTORS,RS_PRD
      REAL        X1(3),X2(3),X3(3),X(3),Y(3),Z(3)
      REAL        X4(3),V1(3),V4(3)
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256,LIST*1
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
      CHARACTER   CH3*1,ATOM3*4,ALT3*1,IRES3*4,RES3*8
      CHARACTER   CH4*1,ATOM4*4,ALT4*1,IRES4*4,RES4*8
C ----------------------------------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      IERR  = 0
      MD    = -ABS(MDOC)-1
C -------------------------------
      X1(1) = XYZ_CRD  (1,IA1)
      X1(2) = XYZ_CRD  (2,IA1)
      X1(3) = XYZ_CRD  (3,IA1)

      X2(1) = XYZ_CRD  (1,IA2)
      X2(2) = XYZ_CRD  (2,IA2)
      X2(3) = XYZ_CRD  (3,IA2)

      X3(1) = XYZ_CRD  (1,IA3)
      X3(2) = XYZ_CRD  (2,IA3)
      X3(3) = XYZ_CRD  (3,IA3)

      X4(1) = XYZ_CRD  (1,IA4)
      X4(2) = XYZ_CRD  (2,IA4)
      X4(3) = XYZ_CRD  (3,IA4)


      X(1) = X2(1) - X3(1)
      X(2) = X2(2) - X3(2)
      X(3) = X2(3) - X3(3)

      Y(1) = X1(1) - X2(1)
      Y(2) = X1(2) - X2(2)
      Y(3) = X1(3) - X2(3)

      CALL NB_VMOD(X,AX)
      CALL NB_VMOD(Y,AY)
      IF(AX.LE.0.1.OR.AY.LE.0.1) RETURN

      X(1) = X3(1) - X2(1)
      X(2) = X3(2) - X2(2)
      X(3) = X3(3) - X2(3)

      Y(1) = X4(1) - X3(1)
      Y(2) = X4(2) - X3(2)
      Y(3) = X4(3) - X3(3)

      CALL NB_VMOD(X,AX)
      CALL NB_VMOD(Y,AY)
      IF(AX.LE.0.1.OR.AY.LE.0.1) RETURN

      CALL CALC_TORS_E(X1,X2,X3,X4,PHI)
      ANGLE = PHI
      PHI   = PHI/PI180
C --
c#
c# _atom_type atomic chemical type
c# _const     Constant KPHI
c# _period    NPH number of minima in the function
c# _angle     angle DELTA
c#            PHI - actual angle 
c#
c#          ENERGY = KPHI * ( 1 - COS( NPH * PHI -   DELTA) )
c#
c
      ANGLE0 = RS_VIDL * PI180
      RSCNS  = RS_CNS  
      IPRD   = RS_PRD

C ---
      IF(IPRD.GT.0) RETURN


      SSLIM = SLIM
      IF(LIST.EQ.'T') THEN
        SSLIM = -1
      ENDIF      

C      IF(RS_CNS.LE.0.001) THEN
C      ELSE

        RS_NTORS = RS_NTORS+1

        IF(RSCNS.LE.0.001) RSCNS = 10.0

        IF(IPRD.LE.0) THEN
          IPRD  = 1
          DELTA = ABS(RS_VIDL - PHI*IPRD)
          IF(DELTA.GT.180.0) THEN
            DELTA = ABS(DELTA-360.0)
          ENDIF 
          ANG  = (ANGLE-ANGLE0)
          IF(ANG.GT. PI) ANG = ANG - TWOPI
          IF(ANG.LE.-PI) ANG = ANG + TWOPI

          ENERGY = (RSCNS * ANG * ANG )/2.0
          DERIV  = RSCNS * ANG
          DERIV2 = 2.0 * RSCNS 

          IF(LIST.EQ.'T') THEN
            T=ANG/PI180
            WRITE(LINE,*) RS_PRD,RSCNS,ENERGY,T
            CALL MSGDOC(MD,LINE)
          ENDIF      

        ELSE

          DELTA = ABS(RS_VIDL - PHI*IPRD)
          IF(DELTA.GT.180.0) THEN
            DELTA = ABS(DELTA-360.0)
          ENDIF 

          ANG  = (ANGLE*IPRD-ANGLE0)
          IF(ANG.GT. PI) ANG = ANG - TWOPI
          IF(ANG.LE.-PI) ANG = ANG + TWOPI

          ENERGY = (RSCNS * (1.0  -  COS(ANG)))/2.0

          DERIV  = (RSCNS * IPRD * SIN(ANG))/2.0
          DERIV2 = RSCNS * IPRD * IPRD

        ENDIF

        CALL NB_VUNIT(X,Z,JERR)
        CALL NB_VMULT(Z,Y,V4)
        CALL NB_VMOD(V4,AV4)

        DERIVX4 = DERIV * V4(1)    
        DERIVY4 = DERIV * V4(2)    
        DERIVZ4 = DERIV * V4(3)    


        X(1) = X2(1) - X3(1)
        X(2) = X2(2) - X3(2)
        X(3) = X2(3) - X3(3)

        Y(1) = X1(1) - X2(1)
        Y(2) = X1(2) - X2(2)
        Y(3) = X1(3) - X2(3)


        CALL NB_VUNIT(X,Z,JERR)
        CALL NB_VMULT(Z,Y,V1)
        CALL NB_VMOD(V1,AV1)

        DERIVX1 = DERIV * V1(1)    
        DERIVY1 = DERIV * V1(2)    
        DERIVZ1 = DERIV * V1(3)    


c        I_BLOCK(IA1)=1
c        I_BLOCK(IA3)=1
        TORS_DER   (1,IA1) = TORS_DER   (1,IA1) + DERIVX1  
        TORS_DER   (2,IA1) = TORS_DER   (2,IA1) + DERIVY1  
        TORS_DER   (3,IA1) = TORS_DER   (3,IA1) + DERIVZ1  
        TORS_DER   (1,IA4) = TORS_DER   (1,IA4) + DERIVX4  
        TORS_DER   (2,IA4) = TORS_DER   (2,IA4) + DERIVY4  
        TORS_DER   (3,IA4) = TORS_DER   (3,IA4) + DERIVZ4  
        TORS_ENER  (  IA1) = TORS_ENER  (  IA1) + ENERGY 
        TORS_ENER  (  IA4) = TORS_ENER  (  IA4) + ENERGY 
        TORS_DER2  (IA1)   = TORS_DER2  (IA1) + DERIV2 * AV1
        TORS_DER2  (IA4)   = TORS_DER2  (IA4) + DERIV2 * AV4
        TORS_ENER_TOTAL    = TORS_ENER_TOTAL  + 2.0*ENERGY   
        TORS_ENER_RMS      = TORS_ENER_RMS    + 4.0*ENERGY*ENERGY   
        ENER_TOTAL         = ENER_TOTAL       + 2.0*ENERGY
        ENER_RMS           = ENER_RMS         + 4.0*ENERGY*ENERGY

        SD = RS_SDI
        IF(SD.LE.0.00001) SD = 1.0
        TEST = ABS(DELTA)/SD
        IF(TEST.GT. 1.0) NT_GT_1S  = NT_GT_1S  + 1 
        IF(TEST.GT. 3.0) NT_GT_3S  = NT_GT_3S  + 1 
        IF(TEST.GT.10.0) NT_GT_10S = NT_GT_10S + 1
        RMS_T = RMS_T + DELTA*DELTA 

C        test=-1.0
        IF(TEST.GT.SSLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG = 1
          A     = ANGLE/PI180
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *    ,RS_VIDL,RS_VOBS,A

 100      FORMAT(
     *    'TORS',1X,A4,A1,'- ',A4,A1,'- ',A4,A1,'- ',A4,A1
     *      ,' # PHI idl init obs:',F7.2,1X,F7.2,1X,F7.2)
          CALL MSGDOC(MD,LINE)

C      IF(RS_CNS.LE.0.001) THEN
c          WRITE(LINE,200)
c     *    DERIVX1,DERIVY1,DERIVZ1,DERIV2,RS_CNS
c 200      FORMAT(5G12.4)
c          CALL MSGDOC(MD,LINE)
c          WRITE(LINE,200)
c     *    DERIVX4,DERIVY4,DERIVZ4,AV1,AV4
c          CALL MSGDOC(MD,LINE)
        ENDIF


C      ENDIF
 
      RETURN
      END

      SUBROUTINE ENER_ANGLE(MDOC,RS_NAME,RS_NANGL,RS_LABEL
     *     ,IA1,IA2,IA3,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,RMS_A,NA_GT_1S,NA_GT_3S,NA_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,LIST,IERR)
C -----------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
      INCLUDE 'ref_com.fh'
C -----------
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NANGL
      REAL        X1(3),X2(3),X3(3),X(3),Y(3),Z(3),NOR(3)
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256,LIST*1
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
      CHARACTER   CH3*1,ATOM3*4,ALT3*1,IRES3*4,RES3*8
C ----------------------------------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      IERR  = 0
      MD    = -ABS(MDOC)-1
C -------------------------------
      SSLIM = SLIM
      IF(LIST.EQ.'T') THEN
        SSLIM = -1
      ENDIF      
      X1(1) = XYZ_CRD  (1,IA1)
      X1(2) = XYZ_CRD  (2,IA1)
      X1(3) = XYZ_CRD  (3,IA1)

      X2(1) = XYZ_CRD  (1,IA2)
      X2(2) = XYZ_CRD  (2,IA2)
      X2(3) = XYZ_CRD  (3,IA2)

      X3(1) = XYZ_CRD  (1,IA3)
      X3(2) = XYZ_CRD  (2,IA3)
      X3(3) = XYZ_CRD  (3,IA3)
     
      DX1   = X1(1)-X2(1)
      DY1   = X1(2)-X2(2)
      DZ1   = X1(3)-X2(3)
      DX3   = X3(1)-X2(1)
      DY3   = X3(2)-X2(2)
      DZ3   = X3(3)-X2(3)

      X(1) = X1(1) - X2(1) 
      X(2) = X1(2) - X2(2) 
      X(3) = X1(3) - X2(3) 

      Y(1) = X3(1) - X2(1) 
      Y(2) = X3(2) - X2(2) 
      Y(3) = X3(3) - X2(3) 

      CALL NB_VMOD(X,AX)
      CALL NB_VMOD(Y,AY)
      IF(AX.LE.0.1.OR.AY.LE.0.1) RETURN
      CALL NB_VPROD(X,Y,S)
      COSA  = S/(AX*AY)


      IF(ABS(COSA).GT.1.0) THEN
        ANGLE = 0.0
        IF(COSA.LT.0.0) ANGLE=PI
      ELSE
        ANGLE = ACOS(COSA)
      ENDIF

C --
C#
C# _atom_type atomic chemical type
C# _const     constant KTHETA
C# _value     equilibrium value for the angle THETA0
C#           THETA - actual angle    
C#
C#           ENERGY = KTHETA * ( THETA - THETA0 )**2
C#
      ANGLE0 = RS_VIDL * PI180
      RSCNS  = RS_CNS  
C ---
      IF(ABS(ANGLE).LE.0.0.OR.RS_CNS.LE.0.01) THEN

      ELSE

        RS_NANGL = RS_NANGL +1

        DELTA  = (ANGLE-ANGLE0)

        ENERGY = (RSCNS * DELTA * DELTA)/2.0

        DERIV  = RSCNS * DELTA
        DERIV2 = 2.0 * RSCNS

        CALL NB_VMULT(X,Y,Z)
        CALL NB_VUNIT(Z,NOR,JERR)
        CALL NB_VMULT(X,NOR,Z)
        CALL NB_VMOD(Z,AZ1)
        DERIVX1 = DERIV * Z(1)    
        DERIVY1 = DERIV * Z(2)    
        DERIVZ1 = DERIV * Z(3)    
        CALL NB_VMULT(Y,X,Z)
        CALL NB_VUNIT(Z,NOR,JERR)
        CALL NB_VMULT(Y,NOR,Z)
        CALL NB_VMOD(Z,AZ3)
        DERIVX3 = DERIV * Z(1)
        DERIVY3 = DERIV * Z(2)
        DERIVZ3 = DERIV * Z(3)
c        I_BLOCK(IA1)=1
c        I_BLOCK(IA3)=1
        ANGLE_DER   (1,IA1) = ANGLE_DER   (1,IA1) + DERIVX1  
        ANGLE_DER   (2,IA1) = ANGLE_DER   (2,IA1) + DERIVY1  
        ANGLE_DER   (3,IA1) = ANGLE_DER   (3,IA1) + DERIVZ1  
        ANGLE_DER   (1,IA3) = ANGLE_DER   (1,IA3) + DERIVX3  
        ANGLE_DER   (2,IA3) = ANGLE_DER   (2,IA3) + DERIVY3  
        ANGLE_DER   (3,IA3) = ANGLE_DER   (3,IA3) + DERIVZ3  
        ANGLE_ENER  (  IA1) = ANGLE_ENER  (  IA1) + ENERGY 
        ANGLE_ENER  (  IA3) = ANGLE_ENER  (  IA3) + ENERGY 
        ANGLE_DER2  (IA1)   = ANGLE_DER2  (IA1) + DERIV2*AZ1 
        ANGLE_DER2  (IA3)   = ANGLE_DER2  (IA3) + DERIV2*AZ3
        ANGLE_ENER_TOTAL    = ANGLE_ENER_TOTAL  + 2.0*ENERGY   
        ANGLE_ENER_RMS      = ANGLE_ENER_RMS    + 4.0*ENERGY*ENERGY   
        ENER_TOTAL          = ENER_TOTAL        + 2.0*ENERGY
        ENER_RMS            = ENER_RMS          + 4.0*ENERGY*ENERGY

        SD  = RS_SDI
        DLT = DELTA/PI180
        IF(SD.LE.0.00001) SD=1.0
        TEST = ABS(DLT)/SD
        IF(TEST.GT. 1.0) NA_GT_1S  = NA_GT_1S  + 1 
        IF(TEST.GT. 3.0) NA_GT_3S  = NA_GT_3S  + 1 
        IF(TEST.GT.10.0) NA_GT_10S = NA_GT_10S + 1
        RMS_A = RMS_A + DLT*DLT 

C        test=-1.0
        IF(TEST.GT.SSLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG = 1
          A     = ANGLE/PI180
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3
     *    ,RS_VIDL,RS_VOBS,A


 100      FORMAT(
     *    'ANGL',1X,A4,A1,'- ',A4,A1,'- ',A4,A1
     *      ,' # ANG idl init obs: ',F7.2,1X,F7.2,1X,F7.2)
          CALL MSGDOC(MD,LINE)

c          WRITE(LINE,200)
c     *    DERIVX1,DERIVY1,DERIVZ1,DERIV2
c 200      FORMAT(4G12.4)
c          CALL MSGDOC(MD,LINE)
c          WRITE(LINE,200)
c     *    DERIVX3,DERIVY3,DERIVZ3,DERIV2
c          CALL MSGDOC(MD,LINE)
        ENDIF


      ENDIF

      RETURN
      END

      SUBROUTINE ENER_BOND(MDOC,RS_NAME,RS_NBOND,RS_LABEL,IA1,IA2
     *     ,ATOM1,ALT1,ATOM2,ALT2,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,RMS_B,NB_GT_1S,NB_GT_3S,NB_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
      INCLUDE 'ref_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NBOND
      REAL        X1(3),X2(3)
      REAL        SMALL_BOND
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
C ----------------------------------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      CONST = 8.0*PI*PI
      IERR  = 0
      MD    = -ABS(MDOC)-1
      SMALL_BOND = 0.1
C -------------------------------
      X1(1) = XYZ_CRD  (1,IA1)
      X1(2) = XYZ_CRD  (2,IA1)
      X1(3) = XYZ_CRD  (3,IA1)
C      B1    = B_ISO    (  IA1)
      B1    = U_ANISO(1,IA1)*CONST

      X2(1) = XYZ_CRD  (1,IA2)
      X2(2) = XYZ_CRD  (2,IA2)
      X2(3) = XYZ_CRD  (3,IA2)
C      B2    = B_ISO    (  IA2)
      B2    = U_ANISO(1,IA2)*CONST

c #  
c #  _atom_type  atomic chemical type
c #  _const      constant KBOND
c #  _value     equilibrium length of this bond BOND0
c #              BOND - actual bond length 
c #
c #              ENERGY = KBOND * ( BOND - BOND0 )**2
c #
      DX     = X1(1)-X2(1)
      DY     = X1(2)-X2(2)
      DZ     = X1(3)-X2(3)
      DB     = B1   -B2 


      DLEN2  = (DX*DX+DY*DY+DZ*DZ) 
      DLEN   = SQRT(DLEN2)
      IF(SMALL_BOND.GT.DLEN) DLEN = SMALL_BOND 
      DLEN2  = DLEN*DLEN
      IF(RS_CNS.LE.0.01) RS_CNS = 0.01

      IF(REF.EQ.'E'.OR.REF.EQ.'R') THEN
C ---
      IF(DLEN2.LT.0.009.OR.RS_CNS.LT.0.01) THEN

      ELSE

        RS_NBOND = RS_NBOND +1

        DELTA  = (DLEN-RS_VIDL)

        ENERGY = (RS_CNS * DELTA * DELTA)/2.0

        DERIV  = (RS_CNS * DELTA)/DLEN 
        DERIV2 =  2.0 * RS_CNS

        DERIVX = DERIV * DX
        DERIVY = DERIV * DY
        DERIVZ = DERIV * DZ
c        I_BLOCK(IA1)=1
c        I_BLOCK(IA2)=1
        BOND_DER   (1,IA1) = BOND_DER   (1,IA1) + DERIVX  
        BOND_DER   (2,IA1) = BOND_DER   (2,IA1) + DERIVY  
        BOND_DER   (3,IA1) = BOND_DER   (3,IA1) + DERIVZ  
        BOND_DER   (1,IA2) = BOND_DER   (1,IA2) - DERIVX  
        BOND_DER   (2,IA2) = BOND_DER   (2,IA2) - DERIVY  
        BOND_DER   (3,IA2) = BOND_DER   (3,IA2) - DERIVZ  
        BOND_ENER  (  IA1) = BOND_ENER  (  IA1) + ENERGY 
        BOND_ENER  (  IA2) = BOND_ENER  (  IA2) + ENERGY 
        BOND_DER2  (IA1)   = BOND_DER2  (IA1) + DERIV2 
        BOND_DER2  (IA2)   = BOND_DER2  (IA2) + DERIV2 
        BOND_ENER_TOTAL    = BOND_ENER_TOTAL    + 2.0*ENERGY   
        BOND_ENER_RMS      = BOND_ENER_RMS      + 4.0*ENERGY*ENERGY
        ENER_TOTAL         = ENER_TOTAL         + 2.0*ENERGY
        ENER_RMS           = ENER_RMS           + 4.0*ENERGY*ENERGY

        SD = RS_SDI
        IF(SD.LE.0.0001) SD=1.0
        TEST = ABS(DELTA)/SD
        IF(TEST.GT. 1.0) NB_GT_1S  = NB_GT_1S  + 1 
        IF(TEST.GT. 3.0) NB_GT_3S  = NB_GT_3S  + 1 
        IF(TEST.GT.10.0) NB_GT_10S = NB_GT_10S + 1
        RMS_B = RMS_B + DELTA*DELTA 

C        test=-1.0
        IF(TEST.GT.SLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG = 1
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2
     *    ,RS_VIDL,RS_VOBS,DLEN


 100      FORMAT(
     *    'BOND',1X,A4,A1,'- ',A4,A1
     *      ,' # B idl init obs:',F7.3,1X,F7.3,1X,F7.3)
          CALL MSGDOC(MD,LINE)

c          WRITE(LINE,200)
c     *    DERIVX,DERIVY,DERIVZ,DERIV2
c 200      FORMAT(4G12.4)
c          CALL MSGDOC(MD,LINE)
        ENDIF
  
      ENDIF
C ----
      ELSE

      CNS = 8.0*PI*PI*RESOL

      IF(ABS(DB).LE.0.001.OR.CNS.LE.0.01) THEN

      ELSE

        RS_NBOND = RS_NBOND +1

        DELTA  = DB

        ENERGY = (CNS * DELTA * DELTA)/2.0

        DERIV  = (CNS * DELTA) 
        DERIV2 =  2.0 * CNS

        DERIVX = DERIV 
        BOND_DER   (1,IA1) = BOND_DER   (1,IA1) + DERIVX  
        BOND_DER   (1,IA2) = BOND_DER   (1,IA2) - DERIVX  
        BOND_ENER  (  IA1) = BOND_ENER  (  IA1) + ENERGY 
        BOND_ENER  (  IA2) = BOND_ENER  (  IA2) + ENERGY 
        BOND_DER2  (IA1)   = BOND_DER2  (IA1) + DERIV2 
        BOND_DER2  (IA2)   = BOND_DER2  (IA2) + DERIV2 
        BOND_ENER_TOTAL    = BOND_ENER_TOTAL    + 2.0*ENERGY   
        BOND_ENER_RMS      = BOND_ENER_RMS      + 4.0*ENERGY*ENERGY
        ENER_TOTAL         = ENER_TOTAL         + 2.0*ENERGY
        ENER_RMS           = ENER_RMS           + 4.0*ENERGY*ENERGY

        SD = 2.0
        IF(SD.LE.0.0) SD=1.0
        TEST = ABS(DELTA)/SD
        IF(TEST.GT. 1.0) NB_GT_1S  = NB_GT_1S  + 1 
        IF(TEST.GT. 3.0) NB_GT_3S  = NB_GT_3S  + 1 
        IF(TEST.GT.10.0) NB_GT_10S = NB_GT_10S + 1
        RMS_B = RMS_B + DELTA*DELTA 


C        test=-1.0
        IF(TEST.GT.SLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG = 1
          WRITE(LINE,300)
     *     ATOM1,ALT1,ATOM2,ALT2
     *    ,B1,B2


 300      FORMAT(
     *    'BOND',1X,A4,A1,'- ',A4,A1
     *      ,' # B1 B2:',F7.3,1X,F7.3)
          CALL MSGDOC(MD,LINE)

c          WRITE(LINE,400)
c     *    DERIVX,DERIV2,CNS
c 400      FORMAT(3G12.4)
c          CALL MSGDOC(MD,LINE)
        ENDIF
  
      ENDIF

      ENDIF
C --------------------------------------
      RETURN
      END

      SUBROUTINE ENER_VDW(MDOC,RSV_NAME,RSV_NVDW,RSV_SYMM,IA1,IA2
     *     ,ATOM1,ALT1,ATOM2,ALT2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,RMS_VDW,NVDW_GT_1S,NVDW_GT_3S,NVDW_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RSV_NVDW
      REAL        X1(3),X2(3),Y1(3),Y2(3),XF1(3),XF2(3),YF1(3),YF2(3)
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8,RSV_HFLAG*1,RSV_TYPE*1
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
C ----------------------------------------------------------------
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------

      X1(1) = XYZ_CRD  (1,IA1)
      X1(2) = XYZ_CRD  (2,IA1)
      X1(3) = XYZ_CRD  (3,IA1)

      X2(1) = XYZ_CRD  (1,IA2)
      X2(2) = XYZ_CRD  (2,IA2)
      X2(3) = XYZ_CRD  (3,IA2)

c#
c#  _atom_type      atomic chemical type
c#  _energy_min     EPSij  minimum of energy parameter
c#  _radius_min     Rmin radius of the minimum of energy parameter
c#                  Rij - actual distance
c#  _H_flag         "h" - the parameters for atoms with hydrogens 
c#
c#                      Lennard-Jones potential
c#
c#             ENERGY =  !EPSij! * ( (Rmin/Rij)**12 - 2 * (Rmin/Rij)**6 )
c#
      IF(RSV_SYMM(4:4).EQ.'_') THEN
        LS = 5
        READ(RSV_SYMM(1:3),'(I3)') IS
      ELSE IF(RSV_SYMM(3:3).EQ.'_') THEN
        LS = 4
        READ(RSV_SYMM(1:2),'(I2)') IS
      ELSE
        LS = 3
        READ(RSV_SYMM(1:1),'(I1)') IS
      ENDIF
      READ(RSV_SYMM(LS:LS),'(I1)') ITX
      ITX = ITX-5
      READ(RSV_SYMM(LS+1:LS+1),'(I1)') ITY
      ITY = ITY-5
      READ(RSV_SYMM(LS+2:LS+2),'(I1)') ITZ
      ITZ = ITZ-5
C ---
      CALL NB_OTOF(X2,XF2,IERR)

      TX   = XF2(1) - ITX - CS_V_CS(1,IS)
      TY   = XF2(2) - ITY - CS_V_CS(2,IS)
      TZ   = XF2(3) - ITZ - CS_V_CS(3,IS)

      YF2(1) = CS_M_CS(1,1,IS)*TX + CS_M_CS(2,1,IS)*TY + 
     *         CS_M_CS(3,1,IS)*TZ
      YF2(2) = CS_M_CS(1,2,IS)*TX + CS_M_CS(2,2,IS)*TY +
     *         CS_M_CS(3,2,IS)*TZ  
      YF2(3) = CS_M_CS(1,3,IS)*TX + CS_M_CS(2,3,IS)*TY +
     *         CS_M_CS(3,3,IS)*TZ 
      CALL NB_FTOO(YF2,Y2,IERR)

      CALL NB_OTOF(X1,XF1,IERR)
      YF1(1) = CS_M_CS(1,1,IS)*XF1(1) + CS_M_CS(1,2,IS)*XF1(2) + 
     *         CS_M_CS(1,3,IS)*XF1(3) + CS_V_CS(1,IS) + ITX
      YF1(2) = CS_M_CS(2,1,IS)*XF1(1) + CS_M_CS(2,2,IS)*XF1(2) +
     *         CS_M_CS(2,3,IS)*XF1(3) + CS_V_CS(2,IS) + ITY
      YF1(3) = CS_M_CS(3,1,IS)*XF1(1) + CS_M_CS(3,2,IS)*XF1(2) +
     *         CS_M_CS(3,3,IS)*XF1(3) + CS_V_CS(3,IS) + ITZ
      CALL NB_FTOO(YF1,Y1,IERR)

      DX1     = X1(1)-Y2(1)
      DY1     = X1(2)-Y2(2)
      DZ1     = X1(3)-Y2(3)

      DX2     = X2(1)-Y1(1)
      DY2     = X2(2)-Y1(2)
      DZ2     = X2(3)-Y1(3)

      R2     = (DX1*DX1+DY1*DY1+DZ1*DZ1) 
      R      = SQRT(R2)

      D2     = (DX2*DX2+DY2*DY2+DZ2*DZ2) 
      D      = SQRT(D2)
 
      IF(R2.LE.0.01) THEN

      ELSE

        RSV_NVDW = RSV_NVDW +1

        COEF = 1.0
        IF(R.LT.1.0) THEN
          COEF = 1.0/R
          R2   = 1.0
          R    = 1.0
          D2   = 1.0
          D    = 1.0
        ENDIF

        DELTA  = (R-RSV_RIDL)

        RR     = RSV_RIDL/R
        RR2    = RR*RR
        RR6    = RR2*RR2*RR2
        RR12   = RR6*RR6
        CNS    = ABS(RSV_CNS)

        CORR   = 0.2
        CNS    = CNS*CORR

        ENERGY = (CNS * (RR12 - 2.0 * RR6))/2.0

        DERIV  = (-6.0/R2)*(CNS * RR12 + ENERGY*2.0) * COEF
        DERIV2 = ABS((72.0*CNS)/(RSV_RIDL*RSV_RIDL)) *10.0

        DERIVX1 = DERIV * DX1 * 0.5
        DERIVY1 = DERIV * DY1 * 0.5
        DERIVZ1 = DERIV * DZ1 * 0.5

        DERIVX2 = DERIV * DX2 * 0.5
        DERIVY2 = DERIV * DY2 * 0.5
        DERIVZ2 = DERIV * DZ2 * 0.5

c        I_BLOCK(IA1)=1
c        I_BLOCK(IA2)=1
        VDW_DER   (1,IA1) = VDW_DER   (1,IA1) + DERIVX1  
        VDW_DER   (2,IA1) = VDW_DER   (2,IA1) + DERIVY1  
        VDW_DER   (3,IA1) = VDW_DER   (3,IA1) + DERIVZ1  
        VDW_DER   (1,IA2) = VDW_DER   (1,IA2) + DERIVX2  
        VDW_DER   (2,IA2) = VDW_DER   (2,IA2) + DERIVY2  
        VDW_DER   (3,IA2) = VDW_DER   (3,IA2) + DERIVZ2  
        VDW_ENER  (  IA1) = VDW_ENER  (  IA1) + ENERGY 
        VDW_ENER  (  IA2) = VDW_ENER  (  IA2) + ENERGY 
        VDW_DER2  (IA1)   = VDW_DER2  (IA1) + DERIV2 
        VDW_DER2  (IA2)   = VDW_DER2  (IA2) + DERIV2 
        VDW_ENER_TOTAL    = VDW_ENER_TOTAL    + 2.0*ENERGY   
        VDW_ENER_RMS      = VDW_ENER_RMS      + 4.0*ENERGY*ENERGY
        ENER_TOTAL        = ENER_TOTAL        + 2.0*ENERGY
        ENER_RMS          = ENER_RMS          + 4.0*ENERGY*ENERGY

        SD = 0.05
        IF(SD.LE.0.0001) SD=1.0
        TEST = ABS(DELTA)/SD
        IF(DELTA.LT.0) THEN
          IF(TEST.GT. 1.0) NVDW_GT_1S  = NVDW_GT_1S  + 1 
          IF(TEST.GT. 3.0) NVDW_GT_3S  = NVDW_GT_3S  + 1 
          IF(TEST.GT.10.0) NVDW_GT_10S = NVDW_GT_10S + 1
          RMS_VDW = RMS_VDW + DELTA*DELTA 
        ELSE
          TEST = -1.0
        ENDIF

C        test=-1
        IF(TEST.GT.SLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG = 1
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2
     *    ,RSV_RIDL,RSV_ROBS,R,RSV_SYMM
 100      FORMAT('VDW ',1X,A4,A1,'- ',A4,A1
     *      ,' # B idl init obs:',F7.3,1X,F7.3,1X,F7.3,1X,A8)
          CALL MSGDOC(MD,LINE)

c          WRITE(LINE,200)
c     *    DERIVX1,DERIVY1,DERIVZ1,DERIV2,is,itx,ity,itz
c 200      FORMAT(4G12.4,4i5)
c          CALL MSGDOC(MD,LINE)
c          WRITE(LINE,200)
c     *    DERIVX2,DERIVY2,DERIVZ2,DERIV2,is,itx,ity,itz
c          CALL MSGDOC(MD,LINE)
        ENDIF
  
      ENDIF
C --------------------------------------
      RETURN
      END


      SUBROUTINE ENER_HB(MDOC,RSV_NAME,RSV_NHB,RSV_SYMM,IA1,IA2
     *     ,ATOM1,ALT1,ATOM2,ALT2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,RMS_HB,NHB_GT_1S,NHB_GT_3S,NHB_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RSV_NHB
      REAL        X1(3),X2(3),Y1(3),Y2(3),XF1(3),XF2(3),YF1(3),YF2(3)
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8,RSV_HFLAG*1,RSV_TYPE*1
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
C ----------------------------------------------------------------
      IERR = 0
      MD   = -ABS(MDOC)-1
C -------------------------------
      X1(1) = XYZ_CRD  (1,IA1)
      X1(2) = XYZ_CRD  (2,IA1)
      X1(3) = XYZ_CRD  (3,IA1)

      X2(1) = XYZ_CRD  (1,IA2)
      X2(2) = XYZ_CRD  (2,IA2)
      X2(3) = XYZ_CRD  (3,IA2)
c#
c#  _atom_type     atomic chemical type
c#  _hbond_min     EPSHij  energy at minimum
c#  _hbond_dist    RHmin distance at minimum of energy
c#                 RHij - actual distance
c#
c#         ENERGY = !EPSHij! * ( 5 * (RHmin/RHij)**12 - 6 * (RHmin/RHij)**10 )
c#
      IF(RSV_SYMM(4:4).EQ.'_') THEN
        LS = 5
        READ(RSV_SYMM(1:3),'(I3)') IS
      ELSE IF(RSV_SYMM(3:3).EQ.'_') THEN
        LS = 4
        READ(RSV_SYMM(1:2),'(I2)') IS
      ELSE
        LS = 3
        READ(RSV_SYMM(1:1),'(I1)') IS
      ENDIF
      READ(RSV_SYMM(LS:LS),'(I1)') ITX
      ITX = ITX-5
      READ(RSV_SYMM(LS+1:LS+1),'(I1)') ITY
      ITY = ITY-5
      READ(RSV_SYMM(LS+2:LS+2),'(I1)') ITZ
      ITZ = ITZ-5
C ---
      CALL NB_OTOF(X2,XF2,IERR)

      TX   = XF2(1) - ITX - CS_V_CS(1,IS)
      TY   = XF2(2) - ITY - CS_V_CS(2,IS)
      TZ   = XF2(3) - ITZ - CS_V_CS(3,IS)

      YF2(1) = CS_M_CS(1,1,IS)*TX + CS_M_CS(2,1,IS)*TY + 
     *         CS_M_CS(3,1,IS)*TZ
      YF2(2) = CS_M_CS(1,2,IS)*TX + CS_M_CS(2,2,IS)*TY +
     *         CS_M_CS(3,2,IS)*TZ  
      YF2(3) = CS_M_CS(1,3,IS)*TX + CS_M_CS(2,3,IS)*TY +
     *         CS_M_CS(3,3,IS)*TZ 
      CALL NB_FTOO(YF2,Y2,IERR)

      CALL NB_OTOF(X1,XF1,IERR)
      YF1(1) = CS_M_CS(1,1,IS)*XF1(1) + CS_M_CS(1,2,IS)*XF1(2) + 
     *         CS_M_CS(1,3,IS)*XF1(3) + CS_V_CS(1,IS) + ITX
      YF1(2) = CS_M_CS(2,1,IS)*XF1(1) + CS_M_CS(2,2,IS)*XF1(2) +
     *         CS_M_CS(2,3,IS)*XF1(3) + CS_V_CS(2,IS) + ITY
      YF1(3) = CS_M_CS(3,1,IS)*XF1(1) + CS_M_CS(3,2,IS)*XF1(2) +
     *         CS_M_CS(3,3,IS)*XF1(3) + CS_V_CS(3,IS) + ITZ
      CALL NB_FTOO(YF1,Y1,IERR)

      DX1     = X1(1)-Y2(1)
      DY1     = X1(2)-Y2(2)
      DZ1     = X1(3)-Y2(3)

      DX2     = X2(1)-Y1(1)
      DY2     = X2(2)-Y1(2)
      DZ2     = X2(3)-Y1(3)

      R2     = (DX1*DX1+DY1*DY1+DZ1*DZ1) 
      R      = SQRT(R2)

      D2     = (DX2*DX2+DY2*DY2+DZ2*DZ2) 
      D      = SQRT(D2)
 
      IF(R2.LE.0.01) THEN

      ELSE

        RSV_NHB = RSV_NHB + 1

        COEF = 1.0
        IF(R.LT.1.0) THEN
          COEF = 1.0/R
          R2   = 1.0
          R    = 1.0
          D2   = 1.0
          D    = 1.0
        ENDIF
        DELTA  = (R-RSV_RIDL)
        RR     = RSV_RIDL/R
        RR2    = RR*RR
        RR6    = RR2*RR2*RR2
        RR10   = RR6*RR2*RR2
        RR12   = RR6*RR6
        CNS    = ABS(RSV_CNS)

        CORR   = 0.2
        CNS    = CNS*CORR

        ENERGY = (CNS * (5.0 * RR12 - 6.0 * RR10))/2.0

        DERIV  = (-10.0/R2)*(CNS * RR12 + ENERGY*2.0) * COEF
        DERIV2 = ABS((120.0*CNS)/(RSV_RIDL*RSV_RIDL)) * 10.0

        DERIVX1 = DERIV * DX1 * 0.5
        DERIVY1 = DERIV * DY1 * 0.5
        DERIVZ1 = DERIV * DZ1 * 0.5
        DERIVX2 = DERIV * DX2 * 0.5
        DERIVY2 = DERIV * DY2 * 0.5
        DERIVZ2 = DERIV * DZ2 * 0.5

c        I_BLOCK(IA1)=1
c        I_BLOCK(IA2)=1
        HB_DER   (1,IA1) = HB_DER   (1,IA1) + DERIVX1  
        HB_DER   (2,IA1) = HB_DER   (2,IA1) + DERIVY1  
        HB_DER   (3,IA1) = HB_DER   (3,IA1) + DERIVZ1  
        HB_DER   (1,IA2) = HB_DER   (1,IA2) + DERIVX2  
        HB_DER   (2,IA2) = HB_DER   (2,IA2) + DERIVY2  
        HB_DER   (3,IA2) = HB_DER   (3,IA2) + DERIVZ2  
        HB_ENER  (  IA1) = HB_ENER  (  IA1) + ENERGY 
        HB_ENER  (  IA2) = HB_ENER  (  IA2) + ENERGY 
        HB_DER2  (IA1)   = HB_DER2  (IA1) + DERIV2 
        HB_DER2  (IA2)   = HB_DER2  (IA2) + DERIV2 
        HB_ENER_TOTAL    = HB_ENER_TOTAL    + 2.0*ENERGY   
        HB_ENER_RMS      = HB_ENER_RMS      + 4.0*ENERGY*ENERGY
        ENER_TOTAL       = ENER_TOTAL        + 2.0*ENERGY
        ENER_RMS         = ENER_RMS          + 4.0*ENERGY*ENERGY

        SD = 0.05
        IF(SD.LE.0.0) SD=1.0
        TEST = ABS(DELTA)/SD
        IF(DELTA.LT.0) THEN
          IF(TEST.GT. 1.0) NHB_GT_1S  = NHB_GT_1S  + 1 
          IF(TEST.GT. 3.0) NHB_GT_3S  = NHB_GT_3S  + 1 
          IF(TEST.GT.10.0) NHB_GT_10S = NHB_GT_10S + 1
          RMS_HB = RMS_HB + DELTA*DELTA 
        ELSE
          TEST =-1.0
        ENDIF

C        test=-1.0
        IF(TEST.GT.SLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG = 1
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2
     *    ,RSV_RIDL,RSV_ROBS,R,RSV_SYMM
 100      FORMAT(
     *    'HB  ',1X,A4,A1,'- ',A4,A1
     *      ,' # B idl init obs:',F7.3,1X,F7.3,1X,F7.3,1X,A8)
          CALL MSGDOC(MD,LINE)

c          WRITE(LINE,200)
c     *    DERIVX1,DERIVY1,DERIVZ1,DERIV2,is,itx,ity,itz
c 200      FORMAT(4G12.4,4i5)
c          CALL MSGDOC(MD,LINE)
c          WRITE(LINE,200)
c     *    DERIVX2,DERIVY2,DERIVZ2,DERIV2,is,itx,ity,itz
c          CALL MSGDOC(MD,LINE)
        ENDIF
  
      ENDIF
C --------------------------------------
      RETURN
      END

      SUBROUTINE CALC_TORS_E(XX1,XX2,XX3,XX4,ANGOBS)
C -----------------------------------------------
C -P- CALC_TRSOBS - 
C -S-
C              IA1        IA2        IA3      IA4
C               I3 - 1 -> I2  - 2 -> I1 - 3 -> I
      REAL      ANGOBS
      REAL      XX1(3),XX2(3),XX3(3),XX4(3)
C ---
C ******
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      X1 = XX1(1)
      Y1 = XX1(2)
      Z1 = XX1(3)

      X2 = XX2(1)
      Y2 = XX2(2)
      Z2 = XX2(3)

      X3 = XX3(1)
      Y3 = XX3(2)
      Z3 = XX3(3)

      X4 = XX4(1)
      Y4 = XX4(2)
      Z4 = XX4(3)

      A3 = X4-X3
      B3 = Y4-Y3
      C3 = Z4-Z3
      A2 = X3-X2
      B2 = Y3-Y2
      C2 = Z3-Z2
      A1 = X2-X1
      B1 = Y2-Y1
      C1 = Z2-Z1
      DN1X = B1*C2-B2*C1
      DN1Y = A1*C2-A2*C1
      DN1Z = A1*B2-A2*B1
      DN2X = B2*C3-B3*C2
      DN2Y = A2*C3-A3*C2
      DN2Z = A2*B3-A3*B2
      E1   = DN1X*DN2X+DN1Y*DN2Y+DN1Z*DN2Z
      E2   = SQRT(DN1X*DN1X+DN1Y*DN1Y+DN1Z*DN1Z)
      E3   = SQRT(DN2X*DN2X+DN2Y*DN2Y+DN2Z*DN2Z)
      IF(E2.LT.1.E-9.OR.E3.LT.1.E-9) THEN
        IF(E1.GE.0.) COSG=1.
        IF(E1.LT.0.) COSG=-1.
      ELSE
        COSG = E1/(E2*E3)
      ENDIF
C---------------NOW WE ARE CALCULATING MIXED VECTORS------------------
C-----ABC=A1*(B2*C3-B3*C2)-A2*(B1*C3-B3*C1)+A3*(B1*C2-B2*C1) !-------
C------------------------------------------------------------------
      ABC    = A1*DN2X-A2*(B1*C3-B3*C1)+A3*DN1X
      SS     = ABS(1.0 - COSG*COSG)
      SING   = SIGN(1.0,ABC)*SQRT(SS)
      ANGOBS = ATAN2(SING,COSG)
      IF(ANGOBS.GT. PI ) ANGOBS = ANGOBS - TWOPI
      IF(ANGOBS.LE.-PI ) ANGOBS = ANGOBS + TWOPI

      RETURN
      END

      SUBROUTINE CHECK_CHIR_EMIN(MDOC,RS_NAME,RS_NCHIR,RS_LABEL
     *     ,RS_NTORS,IA1,IA2,IA3,IA4
     *     ,ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,RMS_C,NC_GT_1S,NC_GT_3S,NC_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,LIST,IERR)
C ----------------------------------------------------------
C -----------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NCHIR,RS_NTORS
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256,LIST*1
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
      CHARACTER   CH3*1,ATOM3*4,ALT3*1,IRES3*4,RES3*8
      CHARACTER   CH4*1,ATOM4*4,ALT4*1,IRES4*4,RES4*8
      REAL        V1(3),V2(3),V3(3),VT(3),V12(3),V13(3),X3(3),X4(3)
C ----------------------------------------------------------------
      IERR  = 0
      MD    = -ABS(MDOC)-1
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C --------
      RS_NCHIR = RS_NCHIR + 1
      CALL CALC_OVOL_PL(IA1,IA2,IA3,IA4,VOLOBS)

      VOL1 = RS_VIDL
      VOL2 = RS_VOBS  

      SSLIM = SLIM
      IF(LIST.EQ.'T') THEN
        WRITE(LINE,'(A,5I5,3F10.2,A)') 
     *  'TR:',RS_NCHIR,IA1,IA2,IA3,IA4,VOL1,VOL2,VOLOBS,RS_LABEL
        CALL MSGDOC(MD,LINE)
        SSLIM = -1
      ENDIF      

      PHIDL = RS_CNS*PI180
      IF(PHIDL.GT.TWOPI) RETURN

      IF(RS_LABEL(1:7).EQ.'negativ') THEN
        VOL1  = -VOL1
        PHIDL = -PHIDL
      ELSE IF(RS_LABEL(1:4).EQ.'both') THEN
        IF(VOLOBS.LT.0.0) THEN
          VOL1  = -VOL1
          PHIDL = -PHIDL
        ENDIF
      ENDIF

      IF(PHIDL.GT.TWOPI) PHIDL = PHIDL - TWOPI        
      IF(PHIDL.LT.  0.0) PHIDL = PHIDL + TWOPI        

      DEL = ABS(VOL1-VOLOBS)
  
      I1 = IA2
      I2 = IA1
      I3 = IA3
      I4 = IA4
      V1(1) = XYZ_CRD(1,I2) - XYZ_CRD(1,I1) 
      V1(2) = XYZ_CRD(2,I2) - XYZ_CRD(2,I1) 
      V1(3) = XYZ_CRD(3,I2) - XYZ_CRD(3,I1) 
      V2(1) = XYZ_CRD(1,I3) - XYZ_CRD(1,I2) 
      V2(2) = XYZ_CRD(2,I3) - XYZ_CRD(2,I2) 
      V2(3) = XYZ_CRD(3,I3) - XYZ_CRD(3,I2) 
      V3(1) = XYZ_CRD(1,I4) - XYZ_CRD(1,I2) 
      V3(2) = XYZ_CRD(2,I4) - XYZ_CRD(2,I2) 
      V3(3) = XYZ_CRD(3,I4) - XYZ_CRD(3,I2) 
      CALL NB_VMOD(V1,AV1)
      CALL NB_VMOD(V2,AV2)
      CALL NB_VMOD(V3,AV3)
      CALL NB_VMULT(V1,V2,V12)
      CALL NB_VMOD(V12,AV12)
      CALL NB_VMULT(V1,V3,V13)
      CALL NB_VMOD(V13,AV13)
      IF(AV12.LE.0.1.OR.AV13.LE.0.1.OR.AV1.LE.0.1) GO TO 200

      CALL NB_VPROD(V12,V13,ACOS23)
      ACOS23 = ACOS23/(AV12*AV13)

      IF(ABS(ACOS23).GT.1.0) THEN
        PH = 0.0
        IF(ACOS23.LT.0.0) PH=PI
      ELSE
        PH = ACOS(ACOS23) 
      ENDIF

      IF(VOLOBS.LT.0.0) PH=-PH

      IF(PH.GT.TWOPI) PH = PH - TWOPI        
      IF(PH.LT.  0.0) PH = PH + TWOPI        

      CONST    = 8.0
      RS_NTORS = RS_NTORS + 1
      ANG      = PH-PHIDL
      IF(ANG.GT. PI) ANG = PI        
      IF(ANG.LT.-PI) ANG =-PI        

      ANG = -ANG

c      T1 = PH/PI180
c      T2 = PHIDL/PI180
c      T3 = ANG/PI180
c      WRITE(*,*) '-PH,PHIDL,ANG:',T1,T2,T3

      ENERGY = (CONST * ANG * ANG )/2.0

      SSLIM = SLIM
      IF(LIST.EQ.'T') THEN
        T = ang/pi180
        t1= ph/pi180
        t2= phidl/pi180
        WRITE(LINE,'(A,6F10.2)') 
     *  'ch:', ENERGY,CONST,T,t1,t2,rs_cns
        CALL MSGDOC(MD,LINE)
        SSLIM = -1
      ENDIF      


      DERIV  = CONST * ANG
      DERIV2 = 2.0 * CONST 

      X3(1) = V12(1)/AV1
      X3(2) = V12(2)/AV1
      X3(3) = V12(3)/AV1
      X4(1) = V13(1)/AV1
      X4(2) = V13(2)/AV1
      X4(3) = V13(3)/AV1
      CALL NB_VMOD(X3,AX3)
      CALL NB_VMOD(X4,AX4)
      DERIVX3 = -DERIV * X3(1)    
      DERIVY3 = -DERIV * X3(2)
      DERIVZ3 = -DERIV * X3(3)

      DERIVX4 = DERIV * X4(1)
      DERIVY4 = DERIV * X4(2)
      DERIVZ4 = DERIV * X4(3)

c      I_BLOCK(I3)=1
c      I_BLOCK(I4)=1
      TORS_DER   (1,I3) = TORS_DER   (1,I3) + DERIVX3  
      TORS_DER   (2,I3) = TORS_DER   (2,I3) + DERIVY3  
      TORS_DER   (3,I3) = TORS_DER   (3,I3) + DERIVZ3  
      TORS_DER   (1,I4) = TORS_DER   (1,I4) + DERIVX4  
      TORS_DER   (2,I4) = TORS_DER   (2,I4) + DERIVY4  
      TORS_DER   (3,I4) = TORS_DER   (3,I4) + DERIVZ4  
      TORS_ENER  (  I3) = TORS_ENER  (  I3) + ENERGY 
      TORS_ENER  (  I4) = TORS_ENER  (  I4) + ENERGY 
      TORS_DER2  (I3)   = TORS_DER2  (I3)   + DERIV2 * AX3
      TORS_DER2  (I4)   = TORS_DER2  (I4)   + DERIV2 * AX4
      TORS_ENER_TOTAL   = TORS_ENER_TOTAL   + 2.0*ENERGY   
      TORS_ENER_RMS     = TORS_ENER_RMS     + 4.0*ENERGY*ENERGY   
      ENER_TOTAL        = ENER_TOTAL        + 2.0*ENERGY
      ENER_RMS          = ENER_RMS          + 4.0*ENERGY*ENERGY




 200  CONTINUE
      SD = 0.5
      IF(SD.LE.0.0) SD=1.0
      TEST = DEL/SD
      IF(TEST.GT. 1.0) NC_GT_1S  = NC_GT_1S  + 1 
      IF(TEST.GT. 3.0) NC_GT_3S  = NC_GT_3S  + 1 
      IF(TEST.GT.10.0) NC_GT_10S = NC_GT_10S + 1
      RMS_C = RMS_C + DEL*DEL 

C      test=-1.0
      IF(TEST.GT.SSLIM) THEN
        IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
        IFLAG = 1

        WRITE(LINE,100) RS_NAME,RS_LABEL,
     *  ATOM1,ALT1,ATOM2,ALT2,ATOM3,ALT3,ATOM4,ALT4
     *  ,VOL1,RS_VOBS,VOLOBS
 100    FORMAT(A4,1X,A8,
     *  A4,1X,A1,' : ',A4,1X,A1,',',A4,1X,A1,',',A4,1X,A1
     *          ,1X,F8.3,1X,F8.3,1X,F8.3)
        CALL MSGDOC(MD,LINE)

          A  = PH/PI180
          AI = PHIDL/PI180
          WRITE(LINE,300) A,AI,ENERGY
 300      FORMAT('PHI,PHIDL,E '
     *    ,1X,F7.2,1X,F7.2,1X,G12.4)
c          CALL MSGDOC(MD,LINE)
          WRITE(LINE,400)
     *    DERIVX3,DERIVY3,DERIVZ3,DERIV2,CONST
 400      FORMAT(5G12.4)
c          CALL MSGDOC(MD,LINE)
          WRITE(LINE,400)
     *    DERIVX4,DERIVY4,DERIVZ4,AV2,AV3
c          CALL MSGDOC(MD,LINE)


      ENDIF
C --------------------------------------
      RETURN
      END

      SUBROUTINE CHECK_PLAN_EMIN(MDOC,RS_NAME,RS_NPLAN,RS_LABEL
     *     ,RS_NBOND,RS_NTORS,RS_NUM,RS_NUM_OLD,IA1
     *     ,ATOM1,ALT1,RS_VIDL,RS_VOBS
     *     ,RMS_P,NP_GT_1S,NP_GT_3S,NP_GT_10S,SLIMR
     *     ,RMS_B,NB_GT_1S,NB_GT_3S,NB_GT_10S
     *     ,NA_PLAN,PL_LABEL,PL_IATOM,PL_ATOM,PL_ALT,PL_DEL,PL_DOBS
     *     ,PL_SD,MAXAPLN  
     *     ,C_LINE,IFLAG,LIST,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RS_NPLAN,RS_NUM,RS_NUM_OLD,RS_NTORS,RS_NBOND
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256,LIST*1
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,RES1*8
      REAL        V1(3),V2(3),V3(3),VT(3),V12(3),V13(3)

      INTEGER     NA_PLAN,PL_IATOM (MAXAPLN)
      CHARACTER   PL_LABEL*8
      CHARACTER   PL_ATOM  (MAXAPLN)*4
      CHARACTER   PL_ALT   (MAXAPLN)*1
      REAL        PL_DEL(MAXAPLN),PL_DOBS(MAXAPLN),PL_SD(MAXAPLN)
      REAL        ANORM(3,MAXAPLN)
C --------------------------------------
      IERR  = 0
      MD    = -ABS(MDOC)-1
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C -------------------------------
      SSLIM = SLIM
      IF(LIST.EQ.'T') THEN
        WRITE(LINE,*) 'RS_NUM,RS_NUM_OLD:',RS_NUM,RS_NUM_OLD
        CALL MSGDOC(MD,LINE)
        SSLIM = -1
      ENDIF      
C --------
      IF(RS_NUM_OLD.EQ.-1) NA_PLAN = 0
      IF(RS_NUM.NE.RS_NUM_OLD) THEN
        IF(NA_PLAN.GE.4) THEN
          RS_NPLAN = RS_NPLAN + 1

          CALL  CALC_PLDEV_PL(NA_PLAN,PL_IATOM,PL_DEL,ANORM)

          DO I=1,NA_PLAN
            DEL = ABS(PL_DEL(I))
            SD  = PL_SD (I)
            IF(SD.LE.0.00001) SD=0.02
            TEST = DEL/SD
            IF(TEST.GT. 1.0) NP_GT_1S  = NP_GT_1S  + 1 
            IF(TEST.GT. 3.0) NP_GT_3S  = NP_GT_3S  + 1 
            IF(TEST.GT.10.0) NP_GT_10S = NP_GT_10S + 1
            IF(TEST.GT. 1.0) NB_GT_1S  = NB_GT_1S  + 1 
            IF(TEST.GT. 3.0) NB_GT_3S  = NB_GT_3S  + 1 
            IF(TEST.GT.10.0) NB_GT_10S = NB_GT_10S + 1
            RMS_P    = RMS_P + DEL*DEL 
            RMS_B    = RMS_B + DEL*DEL 
            RS_NBOND = RS_NBOND + 1

C            test=-1.0
            IF(LIST.EQ.'T') THEN
              WRITE(*,100) PL_LABEL,
     *        PL_ATOM(I),PL_ALT(I),PL_SD(I),PL_DOBS(I),PL_DEL(I)
            ENDIF

            IF(TEST.GT.SSLIM) THEN
              IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
              IFLAG=1
              WRITE(LINE,100) PL_LABEL,
     *        PL_ATOM(I),PL_ALT(I),PL_SD(I),PL_DOBS(I),PL_DEL(I)
 100          FORMAT('PLAN',1X,A8,1X,
     *        A4,A1,' # DISP idl init obs: ',F8.3,1X,F8.3,1X,F8.3)
              CALL MSGDOC(MD,LINE)
            ENDIF

            DELTA = DEL
            IF(DELTA.GT.0.005) THEN
              CNS = 400.0    
              DX  = ANORM(1,I)*PL_DEL(I)
              DY  = ANORM(2,I)*PL_DEL(I)
              DZ  = ANORM(3,I)*PL_DEL(I)
              ENERGY = (CNS * DELTA * DELTA)/2.0
              DERIV  = CNS  
              DERIV2 = 2.0 * CNS
              DERIVX = DERIV * DX
              DERIVY = DERIV * DY
              DERIVZ = DERIV * DZ
              JA1    = PL_IATOM(I)  
              BOND_DER   (1,JA1) = BOND_DER   (1,JA1) + DERIVX  
              BOND_DER   (2,JA1) = BOND_DER   (2,JA1) + DERIVY  
              BOND_DER   (3,JA1) = BOND_DER   (3,JA1) + DERIVZ  
              BOND_ENER  (  JA1) = BOND_ENER  (  JA1) + ENERGY 
              BOND_DER2  (JA1)   = BOND_DER2  (JA1) + DERIV2 
              BOND_ENER_TOTAL    = BOND_ENER_TOTAL    + 2.0*ENERGY   
              BOND_ENER_RMS      = BOND_ENER_RMS    
     *                             + 4.0*ENERGY*ENERGY
              ENER_TOTAL         = ENER_TOTAL         + 2.0*ENERGY
              ENER_RMS           = ENER_RMS        
     *                                      + 4.0*ENERGY*ENERGY
            ENDIF

          ENDDO

        ENDIF

        NA_PLAN = 0

      ENDIF

      IF(RS_NUM_OLD.EQ.-2) RETURN

      NA_PLAN           = NA_PLAN+1
      PL_LABEL          = RS_LABEL
      PL_IATOM(NA_PLAN) = IA1
      PL_ATOM (NA_PLAN) = ATOM1
      PL_ALT  (NA_PLAN) = ALT1
      PL_DEL  (NA_PLAN) = 0.0
      PL_SD   (NA_PLAN) = RS_VIDL 
      PL_DEL  (NA_PLAN) = 0.0
      PL_DOBS (NA_PLAN) = RS_VOBS


      IF(LIST.EQ.'T') THEN
        WRITE(*,*) 'NA,IA1:',NA_PLAN,IA1,';',ATOM1,';',RS_LABEL,';'
c        WRITE(LINE,*) 'NA,IA1:',NA_PLAN,IA1,';',ATOM1,';',RS_LABEL,';'
c        CALL MSGDOC(MD,LINE)
      ENDIF      

      RETURN
      END

C ******
      SUBROUTINE CALC_OVOL_PL(I1,I2,I3,I4,VOLOBS)
C -----------------------------------------------
C -P- CALC_VOL - 
C -S-
C              IA1        IA2        IA3      IA4
C               I3 - 1 -> I2  - 2 -> I1 - 3 -> I
      REAL      VOLOBS
      INTEGER*4 IC
C ---
      INCLUDE 'atom_com.fh'
C ******
      REAL A(9)
      INTEGER*4 I1,I2,I3,I4
      CHARACTER NAME*4
C ---------------------------------------
      VOLOBS = 0.0

      A(1)=XYZ_CRD(1,I2)-XYZ_CRD(1,I1)
      A(4)=XYZ_CRD(2,I2)-XYZ_CRD(2,I1)
      A(7)=XYZ_CRD(3,I2)-XYZ_CRD(3,I1)
      A(2)=XYZ_CRD(1,I3)-XYZ_CRD(1,I1)
      A(5)=XYZ_CRD(2,I3)-XYZ_CRD(2,I1)
      A(8)=XYZ_CRD(3,I3)-XYZ_CRD(3,I1)
      A(3)=XYZ_CRD(1,I4)-XYZ_CRD(1,I1)
      A(6)=XYZ_CRD(2,I4)-XYZ_CRD(2,I1)
      A(9)=XYZ_CRD(3,I4)-XYZ_CRD(3,I1)

      VOLOBS = A(1)*(A(5)*A(9)-A(8)*A(6))
     *       - A(4)*(A(2)*A(9)-A(8)*A(3))
     *       + A(7)*(A(2)*A(6)-A(5)*A(3))
      RETURN
      END


C ******
      SUBROUTINE  CALC_PLDEV_PL(N,IATM,DEL,ANORM)
C -----------------------------------------------
C -P- CALC_PLDEV - 
C -S-
      INTEGER*4 N,IATM(*)
C ---
      INCLUDE 'atom_com.fh'
C ******
      PARAMETER  (MAXAPLN = 100)
      REAL      X(3,MAXAPLN),DEL(*),VM(3)
      REAL      ANORM(3,MAXAPLN)
C -------------------------------------------------
      DO  I = 1,N
          II=IATM(I)
          X(1,I)=XYZ_CRD (1,II)
          X(2,I)=XYZ_CRD (2,II)
          X(3,I)=XYZ_CRD (3,II)
      ENDDO

      CALL FIT_PLANE_EMIN(N,X,VM,D)

      DO  I = 1,N
        DEL(I)=0
        DO J=1,3
          ANORM(J,I) = VM(J)
          DEL(I)=DEL(I)+VM(J)*X(J,I)
        ENDDO
        DEL(I)=DEL(I)-D
      ENDDO
      RETURN
      END      

      SUBROUTINE FIT_PLANE_EMIN(N,X,VM,D)
C -P- PLAN - fit a least-squares plan to a set of points.
C -S-
C     PROCEDURE OF SCHOMAKER ET AL.(ACTA CRYST.,12,600,1959)
C
C ******
      REAL   X(3,*),XS(3),XXS(3,3),B(3,3),A(3,3)
      REAL   VM(3),VMI(3),BV(3)
      DATA   ZIP/1.0E-5/
      DATA   MM/10/
C ------------------------------------
C
C----SET UP THE A MATRIX
      SN = N
      IF(N.LE.0) STOP ' N =< 0 in subroutine "FIT_PLANE"'
C ---
      DO    I=1,3
        XS(I) = 0
        DO    K=1,N
          XS(I) = XS(I) + X(I,K)
        ENDDO
      ENDDO
C ---
      DO    I=1,3
        DO    J=1,3
          XXS(I,J) = 0
          DO    K=1,N
            XXS(I,J) = XXS(I,J) + X(I,K)*X(J,K)
          ENDDO
          A(I,J) = XXS(I,J) - XS(I)*XS(J)/SN
        ENDDO
      ENDDO
C
C----EVALUATE MATRIX B=ADJ(A)*G
C
      B(1,1) = A(2,2)*A(3,3)-A(2,3)*A(3,2)
      B(2,1) = A(3,1)*A(2,3)-A(2,1)*A(3,3)
      B(3,1) = A(2,1)*A(3,2)-A(3,1)*A(2,2)
      B(1,2) = A(3,2)*A(1,3)-A(1,2)*A(3,3)
      B(2,2) = A(1,1)*A(3,3)-A(3,1)*A(1,3)
      B(3,2) = A(3,1)*A(1,2)-A(1,1)*A(3,2)
      B(1,3) = A(1,2)*A(2,3)-A(1,3)*A(2,2)
      B(2,3) = A(2,1)*A(1,3)-A(1,1)*A(2,3)
      B(3,3) = A(1,1)*A(2,2)-A(2,1)*A(1,2)

C
C----CHOOSE THE LARGEST COLUMN VECTOR OF B AS THE INITIAL SOLUTION
C
      BV(1) = B(1,1)**2+B(2,1)**2+B(3,1)**2
      BV(2) = B(1,2)**2+B(2,2)**2+B(3,2)**2
      BV(3) = B(1,3)**2+B(2,3)**2+B(3,3)**2

      KK    = 1
      IF(BV(2).GT.BV( 1)) KK = 2
      IF(BV(3).GT.BV(KK)) KK = 3
      VM1 = B(1,KK)

      IF(ABS(VM1).LE.ZIP) THEN
        VM(1) = 0.0
        VM(2) = 0.0
        VM(3) = 0.0
        D     = 0.0
        RETURN
      ENDIF

      VMI_MIN = 1E30
      DO    I=1,3
        VMI(I) = B(I,KK)/VM1
        IF(ABS(VMI(I)).LT.VMI_MIN) VMI_MON = ABS(VMI(I))
      ENDDO

      IF(VMI_MIN.LE.ZIP) THEN
        VM(1) = 0.0
        VM(2) = 0.0
        VM(3) = 0.0
        D     = 0.0
        RETURN
      ENDIF

C
C----SOLVE TO CONVERGENCE BY ITERATION OF M(I)=B*M(I-1)
C
      DO    NNN=1,MM
        VM(1)  = B(1,1)*VMI(1)+B(1,2)*VMI(2)+B(1,3)*VMI(3)
        VM(2)  = B(2,1)*VMI(1)+B(2,2)*VMI(2)+B(2,3)*VMI(3)
        VM(3)  = B(3,1)*VMI(1)+B(3,2)*VMI(2)+B(3,3)*VMI(3)
        IF(ABS(VMI(1)).LT.ZIP) GO TO 110
        IF(ABS(VMI(2)).LT.ZIP) GO TO 110
        IF(ABS(VMI(3)).LT.ZIP) GO TO 110
        RATIO1 = VM(1)/VMI(1)
        RATIO2 = VM(2)/VMI(2)
        RATIO3 = VM(3)/VMI(3)
        RAT12  = ABS(RATIO2/RATIO1-1.0)
        RAT13  = ABS(RATIO3/RATIO1-1.0)
        IF(RAT12.LT.ZIP.AND.RAT13.LT.ZIP) GO TO 110
        IF(ABS(VM(1)).LT.ZIP) GO TO 110
        DO    I=1,3
          VMI(I) = VM(I)/VM(1)
        ENDDO
      ENDDO   
C
C----NORMALIZE THE SOLUTION VECTOR AND EVALUATE D(PLANE TO ORIGIN DISTAN
C
  110 ORM = 0
      DO    I=1,3
        ORM = ORM + VM(I)*VM(I)
      ENDDO

      ORM = SQRT(ABS(ORM))

      IF(ORM.LT.ZIP) THEN
        VM(1) = 0.0
        VM(2) = 0.0
        VM(3) = 0.0
        D     = 0.0
        RETURN
      ENDIF

      DO     I=1,3
        VM(I) = VM(I)/ORM
      ENDDO

      D = (VM(1)*XS(1)+VM(2)*XS(2)+VM(3)*XS(3))/SN

      RETURN
      END

      SUBROUTINE ENER_HB_2(MDOC,RSV_NAME,RSV_NHB,RSV_SYMM,IA1,IA2
     *     ,ATOM1,ALT1,ATOM2,ALT2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,RMS_HB,NHB_GT_1S,NHB_GT_3S,NHB_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RSV_NHB
      REAL        X1(3),X2(3),Y1(3),Y2(3),XF1(3),XF2(3),YF1(3),YF2(3)
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8,RSV_HFLAG*1,RSV_TYPE*1
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
C ----------------------------------------------------------------
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      X1(1)= XYZ_CRD  (1,IA1)
      X1(2)= XYZ_CRD  (2,IA1)
      X1(3)= XYZ_CRD  (3,IA1)

      X2(1)= XYZ_CRD  (1,IA2)
      X2(2)= XYZ_CRD  (2,IA2)
      X2(3)= XYZ_CRD  (3,IA2)
c#
c#  _atom_type     atomic chemical type
c#  _hbond_min     EPSHij  energy at minimum
c#  _hbond_dist    RHmin distance at minimum of energy
c#                 RHij - actual distance
c#
c#            ENERGY = !EPSHij! * ( (RHmin/RHij)**12 - 2 * (RHmin/RHij)**10 )
c#
      IF(RSV_SYMM(4:4).EQ.'_') THEN
        LS=5
        READ(RSV_SYMM(1:3),'(I3)') IS
      ELSE IF(RSV_SYMM(3:3).EQ.'_') THEN
        LS=4
        READ(RSV_SYMM(1:2),'(I2)') IS
      ELSE
        LS=3
        READ(RSV_SYMM(1:1),'(I1)') IS
      ENDIF
      READ(RSV_SYMM(LS:LS),'(I1)') ITX
      ITX=ITX-5
      READ(RSV_SYMM(LS+1:LS+1),'(I1)') ITY
      ITY=ITY-5
      READ(RSV_SYMM(LS+2:LS+2),'(I1)') ITZ
      ITZ=ITZ-5
C ---
      CALL NB_OTOF(X2,XF2,IERR)

      TX   = XF2(1) - ITX - CS_V_CS(1,IS)
      TY   = XF2(2) - ITY - CS_V_CS(2,IS)
      TZ   = XF2(3) - ITZ - CS_V_CS(3,IS)

      YF2(1)= CS_M_CS(1,1,IS)*TX + CS_M_CS(2,1,IS)*TY + 
     *        CS_M_CS(3,1,IS)*TZ
      YF2(2)= CS_M_CS(1,2,IS)*TX + CS_M_CS(2,2,IS)*TY +
     *        CS_M_CS(3,2,IS)*TZ  
      YF2(3)= CS_M_CS(1,3,IS)*TX + CS_M_CS(2,3,IS)*TY +
     *        CS_M_CS(3,3,IS)*TZ 
      CALL NB_FTOO(YF2,Y2,IERR)

      CALL NB_OTOF(X1,XF1,IERR)
      YF1(1)= CS_M_CS(1,1,IS)*XF1(1) + CS_M_CS(1,2,IS)*XF1(2) + 
     *        CS_M_CS(1,3,IS)*XF1(3) + CS_V_CS(1,IS) + ITX
      YF1(2)= CS_M_CS(2,1,IS)*XF1(1) + CS_M_CS(2,2,IS)*XF1(2) +
     *        CS_M_CS(2,3,IS)*XF1(3) + CS_V_CS(2,IS) + ITY
      YF1(3)= CS_M_CS(3,1,IS)*XF1(1) + CS_M_CS(3,2,IS)*XF1(2) +
     *        CS_M_CS(3,3,IS)*XF1(3) + CS_V_CS(3,IS) + ITZ
      CALL NB_FTOO(YF1,Y1,IERR)

      DX1     = X1(1)-Y2(1)
      DY1     = X1(2)-Y2(2)
      DZ1     = X1(3)-Y2(3)

      DX2     = X2(1)-Y1(1)
      DY2     = X2(2)-Y1(2)
      DZ2     = X2(3)-Y1(3)

      R2     = (DX1*DX1+DY1*DY1+DZ1*DZ1) 
      R      = SQRT(R2)

      D2     = (DX2*DX2+DY2*DY2+DZ2*DZ2) 
      D      = SQRT(D2)
 
      IF(R.LE.0.1) R = 0.1

      IF(R.LE.0.01) THEN

      ELSE

        COEF=1.0
C        IF(R.LT.0.5) THEN
C          COEF = 1.0/R
C          R2= 0.5
C          R = 0.5
C        ENDIF
        DELTA  = (R-RSV_RIDL)
 
        RSV_NHB = RSV_NHB + 1

        CNS    = ABS(RSV_CNS)

        CNS    = 4.0

        IF(DELTA.GE.0.0) GO TO 300

        ENERGY = (CNS * DELTA * DELTA )/2.0
        DERIV  = (CNS * DELTA * COEF  )/R 
        DERIV2 =  2.0 * CNS

        DERIVX1 = DERIV * DX1
        DERIVY1 = DERIV * DY1
        DERIVZ1 = DERIV * DZ1
        DERIVX2 = DERIV * DX2
        DERIVY2 = DERIV * DY2
        DERIVZ2 = DERIV * DZ2

c        I_BLOCK(IA1)=1
c        I_BLOCK(IA2)=1
        HB_DER   (1,IA1)= HB_DER   (1,IA1) + DERIVX1  
        HB_DER   (2,IA1)= HB_DER   (2,IA1) + DERIVY1  
        HB_DER   (3,IA1)= HB_DER   (3,IA1) + DERIVZ1  
        HB_DER   (1,IA2)= HB_DER   (1,IA2) + DERIVX2  
        HB_DER   (2,IA2)= HB_DER   (2,IA2) + DERIVY2  
        HB_DER   (3,IA2)= HB_DER   (3,IA2) + DERIVZ2  
        HB_ENER  (  IA1)= HB_ENER  (  IA1) + ENERGY 
        HB_ENER  (  IA2)= HB_ENER  (  IA2) + ENERGY 
        HB_DER2  (IA1)  = HB_DER2  (IA1) + DERIV2 
        HB_DER2  (IA2)  = HB_DER2  (IA2) + DERIV2 
        HB_ENER_TOTAL   = HB_ENER_TOTAL    + 2.0*ENERGY   
        HB_ENER_RMS     = HB_ENER_RMS      + 4.0*ENERGY*ENERGY
        ENER_TOTAL       = ENER_TOTAL        + 2.0*ENERGY
        ENER_RMS         = ENER_RMS          + 4.0*ENERGY*ENERGY

        SD=0.1
        IF(SD.LE.0.0) SD=1.0
        TEST=ABS(DELTA)/SD
        IF(DELTA.LT.0) THEN
          IF(TEST.GT. 1.0) NHB_GT_1S  = NHB_GT_1S  + 1 
          IF(TEST.GT. 3.0) NHB_GT_3S  = NHB_GT_3S  + 1 
          IF(TEST.GT.10.0) NHB_GT_10S = NHB_GT_10S + 1
          RMS_HB = RMS_HB + DELTA*DELTA 
        ENDIF

C        test=-1.0
        IF(TEST.GT.SLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG=1
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2
     *    ,RSV_RIDL,RSV_ROBS,R,D,ENERGY,RSV_SYMM,RSV_CNS
 100      FORMAT(
     *    'HB  ',1X,A4,A1,'- ',A4,A1
     *      ,1X,F7.3,1X,F7.3,1X,2F7.3,G12.4,1X,A8,F7.3)
          CALL MSGDOC(MD,LINE)

          WRITE(LINE,200)
     *    DERIVX1,DERIVY1,DERIVZ1,DERIV2,is,itx,ity,itz
 200      FORMAT(4G12.4,4i5)
          CALL MSGDOC(MD,LINE)
          WRITE(LINE,200)
     *    DERIVX2,DERIVY2,DERIVZ2,DERIV2,is,itx,ity,itz
          CALL MSGDOC(MD,LINE)
        ENDIF
 300    CONTINUE

      ENDIF
C --------------------------------------
      RETURN
      END

      SUBROUTINE ENER_VDW_2(MDOC,RSV_NAME,RSV_NVDW,RSV_SYMM,IA1,IA2
     *     ,ATOM1,ALT1,ATOM2,ALT2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,RMS_VDW,NVDW_GT_1S,NVDW_GT_3S,NVDW_GT_10S,SLIMR
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'ener_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     RSV_NVDW
      REAL        X1(3),X2(3),Y1(3),Y2(3),XF1(3),XF2(3),YF1(3),YF2(3)
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8,RSV_HFLAG*1,RSV_TYPE*1
      CHARACTER   LINE*256,C_LINE*256
      CHARACTER   CH1*1,ATOM1*4,ALT1*1,IRES1*4,RES1*8
      CHARACTER   CH2*1,ATOM2*4,ALT2*1,IRES2*4,RES2*8
C ----------------------------------------------------------------
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      X1(1)= XYZ_CRD  (1,IA1)
      X1(2)= XYZ_CRD  (2,IA1)
      X1(3)= XYZ_CRD  (3,IA1)

      X2(1)= XYZ_CRD  (1,IA2)
      X2(2)= XYZ_CRD  (2,IA2)
      X2(3)= XYZ_CRD  (3,IA2)

c#
c#  _atom_type      atomic chemical type
c#  _energy_min     EPSij  minimum of energy parameter
c#  _radius_min     Rmin radius of the minimum of energy parameter
c#                  Rij - actual distance
c#  _H_flag         "h" - the parameters for atoms with hydrogens 
c#
c#                      Lennard-Jones potential
c#
c#             ENERGY =  !EPSij! * ( (Rmin/Rij)**12 - 2 * (Rmin/Rij)**6 )
c#
      IF(RSV_SYMM(4:4).EQ.'_') THEN
        LS=5
        READ(RSV_SYMM(1:3),'(I3)') IS
      ELSE IF(RSV_SYMM(3:3).EQ.'_') THEN
        LS=4
        READ(RSV_SYMM(1:2),'(I2)') IS
      ELSE
        LS=3
        READ(RSV_SYMM(1:1),'(I1)') IS
      ENDIF
      READ(RSV_SYMM(LS:LS),'(I1)') ITX
      ITX=ITX-5
      READ(RSV_SYMM(LS+1:LS+1),'(I1)') ITY
      ITY=ITY-5
      READ(RSV_SYMM(LS+2:LS+2),'(I1)') ITZ
      ITZ=ITZ-5
C ---
      CALL NB_OTOF(X2,XF2,IERR)

      TX   = XF2(1) - ITX - CS_V_CS(1,IS)
      TY   = XF2(2) - ITY - CS_V_CS(2,IS)
      TZ   = XF2(3) - ITZ - CS_V_CS(3,IS)

      YF2(1)= CS_M_CS(1,1,IS)*TX + CS_M_CS(2,1,IS)*TY + 
     *        CS_M_CS(3,1,IS)*TZ
      YF2(2)= CS_M_CS(1,2,IS)*TX + CS_M_CS(2,2,IS)*TY +
     *        CS_M_CS(3,2,IS)*TZ  
      YF2(3)= CS_M_CS(1,3,IS)*TX + CS_M_CS(2,3,IS)*TY +
     *        CS_M_CS(3,3,IS)*TZ 
      CALL NB_FTOO(YF2,Y2,IERR)

      CALL NB_OTOF(X1,XF1,IERR)
      YF1(1)= CS_M_CS(1,1,IS)*XF1(1) + CS_M_CS(1,2,IS)*XF1(2) + 
     *        CS_M_CS(1,3,IS)*XF1(3) + CS_V_CS(1,IS) + ITX
      YF1(2)= CS_M_CS(2,1,IS)*XF1(1) + CS_M_CS(2,2,IS)*XF1(2) +
     *        CS_M_CS(2,3,IS)*XF1(3) + CS_V_CS(2,IS) + ITY
      YF1(3)= CS_M_CS(3,1,IS)*XF1(1) + CS_M_CS(3,2,IS)*XF1(2) +
     *        CS_M_CS(3,3,IS)*XF1(3) + CS_V_CS(3,IS) + ITZ
      CALL NB_FTOO(YF1,Y1,IERR)

      DX1     = X1(1)-Y2(1)
      DY1     = X1(2)-Y2(2)
      DZ1     = X1(3)-Y2(3)

      DX2     = X2(1)-Y1(1)
      DY2     = X2(2)-Y1(2)
      DZ2     = X2(3)-Y1(3)

      R2     = (DX1*DX1+DY1*DY1+DZ1*DZ1) 
      R      = SQRT(R2)

      D2     = (DX2*DX2+DY2*DY2+DZ2*DZ2) 
      D      = SQRT(D2)
 
      IF(R.LE.0.1) R = 0.1

      IF(R.LE.0.01) THEN

      ELSE

        RSV_NVDW = RSV_NVDW +1

        COEF=1.0
C        IF(R.LT.1.0) THEN
C          COEF = 1.0/R
C          R2= 1.0
C          R = 1.0
C          D2= 1.0
C          D = 1.0
C        ENDIF

        DELTA  = (R-RSV_RIDL)

        CNS    = 4.0
        IF(DELTA.GE.0.0) GO TO 300

        ENERGY = (CNS * DELTA * DELTA )/2.0
        DERIV  = (CNS * DELTA * COEF  )/R 
        DERIV2 =  2.0 * CNS

        DERIVX1 = DERIV * DX1
        DERIVY1 = DERIV * DY1
        DERIVZ1 = DERIV * DZ1

        DERIVX2 = DERIV * DX2
        DERIVY2 = DERIV * DY2
        DERIVZ2 = DERIV * DZ2

c        I_BLOCK(IA1)=1
c        I_BLOCK(IA2)=1
        VDW_DER   (1,IA1)= VDW_DER   (1,IA1) + DERIVX1  
        VDW_DER   (2,IA1)= VDW_DER   (2,IA1) + DERIVY1  
        VDW_DER   (3,IA1)= VDW_DER   (3,IA1) + DERIVZ1  
        VDW_DER   (1,IA2)= VDW_DER   (1,IA2) + DERIVX2  
        VDW_DER   (2,IA2)= VDW_DER   (2,IA2) + DERIVY2  
        VDW_DER   (3,IA2)= VDW_DER   (3,IA2) + DERIVZ2  
        VDW_ENER  (  IA1)= VDW_ENER  (  IA1) + ENERGY 
        VDW_ENER  (  IA2)= VDW_ENER  (  IA2) + ENERGY 
        VDW_DER2  (IA1)  = VDW_DER2  (IA1) + DERIV2 
        VDW_DER2  (IA2)  = VDW_DER2  (IA2) + DERIV2 
        VDW_ENER_TOTAL   = VDW_ENER_TOTAL    + 2.0*ENERGY   
        VDW_ENER_RMS     = VDW_ENER_RMS      + 4.0*ENERGY*ENERGY
        ENER_TOTAL       = ENER_TOTAL        + 2.0*ENERGY
        ENER_RMS         = ENER_RMS          + 4.0*ENERGY*ENERGY

        SD=0.1
        IF(SD.LE.0.0) SD=1.0
        TEST=ABS(DELTA)/SD
        IF(DELTA.LT.0) THEN
          IF(TEST.GT. 1.0) NVDW_GT_1S  = NVDW_GT_1S  + 1 
          IF(TEST.GT. 3.0) NVDW_GT_3S  = NVDW_GT_3S  + 1 
          IF(TEST.GT.10.0) NVDW_GT_10S = NVDW_GT_10S + 1
          RMS_VDW = RMS_VDW + DELTA*DELTA 
        ENDIF

C        test=-1.0
        IF(TEST.GT.SLIM) THEN
          IF(IFLAG.EQ.0) CALL MSGDOC(MD,C_LINE)
          IFLAG=1
          WRITE(LINE,100)
     *     ATOM1,ALT1,ATOM2,ALT2
     *    ,RSV_RIDL,RSV_ROBS,R,D,ENERGY,RSV_SYMM,RSV_CNS
 100      FORMAT(
     *    'VDW ',1X,A4,A1,'- ',A4,A1
     *      ,1X,F7.3,1X,F7.3,1X,2F7.3,G12.4,1X,A8,F7.3)
          CALL MSGDOC(MD,LINE)

          WRITE(LINE,200)
     *    DERIVX1,DERIVY1,DERIVZ1,DERIV2,is,itx,ity,itz
 200      FORMAT(4G12.4,4i5)
          CALL MSGDOC(MD,LINE)
          WRITE(LINE,200)
     *    DERIVX2,DERIVY2,DERIVZ2,DERIV2,is,itx,ity,itz
          CALL MSGDOC(MD,LINE)
        ENDIF

 300    CONTINUE
  
      ENDIF
C --------------------------------------
      RETURN
      END
C ==============================================================
C ------------------------------------------------------------
      SUBROUTINE GET_TORS_EMIN(MDOC,RS_NAME,NTORS,RS_LABEL
     *     ,IA1,IA2,IA3,IA4
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_PRD,RS_CNS
     *     ,C_LINE,IFLAG,IERR)
C -----------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     NTORS,RS_PRD
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
C ----------------------------------------------------------------
      PI   =4.0*ATAN(1.0)
      TWOPI=2.0*PI
      PI180=PI/180.0
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      IF(NTORS.GE.MAXRTORS) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of tors restraints > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRTORS in "rstr_com.fh"')
        IERR=1
        RETURN
      ENDIF
      NTORS = NTORS + 1
      RT_VIDL  (NTORS) = RS_VIDL
      RT_SDID  (NTORS) = RS_SDI
      RT_VOBS  (NTORS) = RS_VOBS
      RT_CNST  (NTORS) = RS_CNS
      RT_ANGLE (NTORS) = 0.0
      RT_IA1  (NTORS)  = IA1
      RT_IA2  (NTORS)  = IA2
      RT_IA3  (NTORS)  = IA3
      RT_IA4  (NTORS)  = IA4
      RT_PRD  (NTORS)  = RS_PRD
      RT_LABEL(NTORS)  = RS_LABEL
      RT_TYPE (NTORS)  = ' '
      RT_FLAG (NTORS)  = ' '
      RETURN
      END

      SUBROUTINE GET_ANGLE_EMIN(MDOC,RS_NAME,NANGL,RS_LABEL
     *     ,IA1,IA2,IA3
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,C_LINE,IFLAG,IERR)
C -----------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     NANGL
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
C ----------------------------------------------------------------
      PI   =4.0*ATAN(1.0)
      TWOPI=2.0*PI
      PI180=PI/180.0
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      IF(NANGL.GE.MAXRANGL) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of angle restraints > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRANGL in "rstr_com.fh"')
        IERR=1
        RETURN
      ENDIF
      NANGL = NANGL + 1
      RA_VIDL  (NANGL) = RS_VIDL
      RA_SDID  (NANGL) = RS_SDI
      RA_VOBS  (NANGL) = RS_VOBS
      RA_CNST  (NANGL) = RS_CNS
      RA_ANGLE (NANGL) = 0.0
      RA_IA1   (NANGL)  = IA1
      RA_IA2   (NANGL)  = IA2
      RA_IA3   (NANGL)  = IA3
      RA_TYPE  (NANGL)  = ' '
      RA_FLAG  (NANGL)  = ' '
      RETURN
      END

      SUBROUTINE GET_BOND_EMIN(MDOC,RS_NAME,NBOND,RS_LABEL,IA1,IA2
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     NBOND
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
C ----------------------------------------------------------------
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      IF(NBOND.GE.MAXRBOND) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of bond restraints > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRBOND in "rstr_com.fh"')
        IERR=1
        RETURN
      ENDIF
      NBOND = NBOND + 1
      RB_VIDL  (NBOND) = RS_VIDL
      RB_SDID  (NBOND) = RS_SDI
      RB_VOBS  (NBOND) = RS_VOBS
      RB_CNST  (NBOND) = RS_CNS
      RB_LENGTH(NBOND) = 0.0
      RB_IA1   (NBOND) = IA1
      RB_IA2   (NBOND) = IA2
      RB_CHEM  (NBOND) = RS_LABEL
      RB_TYPE  (NBOND) = ' '
      RB_FLAG  (NBOND) = ' '
      RETURN
      END

      SUBROUTINE GET_VDW_EMIN(MDOC,RSV_NAME,NVDW,RSV_SYMM,IA1,IA2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     NVDW
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8,RSV_HFLAG*1,RSV_TYPE*1
      CHARACTER   LINE*256,C_LINE*256
C ----------------------------------------------------------------
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      IF(NVDW.GE.MAXRVDW) THEN
        CALL MSGERR(MDOC
     *  ,' WARNING: number of VDW restraints > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRVDW in "rstr_com.fh"')
        IERR=1
        RETURN
      ENDIF
      NVDW = NVDW + 1
      RV_VIDL  (NVDW) = RSV_RIDL
      RV_SDID  (NVDW) = 0.0
      RV_VOBS  (NVDW) = RSV_ROBS
      RV_CNST  (NVDW) = RSV_CNS
      RV_LENGTH(NVDW) = 0.0
      RV_IA1   (NVDW) = IA1
      RV_IA2   (NVDW) = IA2
      RV_CHEM  (NVDW) = ' '
      RV_SYMM  (NVDW) = RSV_SYMM
      RV_TYPE  (NVDW) = ' '
      RV_FLAG  (NVDW) = RSV_HFLAG
      RETURN
      END


      SUBROUTINE GET_HB_EMIN(MDOC,RSV_NAME,NHB,RSV_SYMM,IA1,IA2
     *     ,RSV_RIDL,RSV_ROBS,RSV_CNS,RSV_HFLAG,RSV_TYPE
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C ==----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     NHB
      CHARACTER   RSV_NAME*4
      CHARACTER   RSV_SYMM*8,RSV_HFLAG*1,RSV_TYPE*1
      CHARACTER   LINE*256,C_LINE*256
C ----------------------------------------------------------------
      IERR= 0
      MD  = -ABS(MDOC)-1
C -------------------------------
      IF(NHB.GE.MAXRHB) THEN
        CALL MSGERR(MDOC
     *  ,' WARNING: number of H_bond restraints > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRHB in "rstr_com.fh"')
        IERR=1
        RETURN
      ENDIF
      NHB = NHB + 1
      RH_VIDL  (NHB) = RSV_RIDL
      RH_SDID  (NHB) = 0.0
      RH_VOBS  (NHB) = RSV_ROBS
      RH_CNST  (NHB) = RSV_CNS
      RH_LENGTH(NHB) = 0.0
      RH_IA1   (NHB) = IA1
      RH_IA2   (NHB) = IA2
      RH_CHEM  (NHB) = ' '
      RH_SYMM  (NHB) = RSV_SYMM
      RH_TYPE  (NHB) = ' '
      RH_FLAG  (NHB) = RSV_HFLAG
      RETURN
      END

C ------------------------------------------------------------
      SUBROUTINE GET_CHIR_EMIN(MDOC,RS_NAME,NCHIR,RS_LABEL
     *     ,IA1,IA2,IA3,IA4
     *     ,RS_VIDL,RS_SDI,RS_VOBS,RS_CNS
     *     ,C_LINE,IFLAG,IERR)
C -----------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C ----------------------------------------------------------
      INTEGER     MDOC,IERR,IFLAG
      INTEGER     NCHIR
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
C ----------------------------------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      IERR  = 0
      MD    =-ABS(MDOC)-1
C -------------------------------
      IF(NCHIR.GE.MAXRCHIR) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of chirality restraints > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRCHIR in "rstr_com.fh"')
        IERR=1
        RETURN
      ENDIF
      NCHIR = NCHIR + 1
      RC_VIDL  (NCHIR) = RS_VIDL
      RC_VOBS  (NCHIR) = RS_VOBS
      RC_CNST  (NCHIR) = RS_CNS
      RC_IA1   (NCHIR)  = IA1
      RC_IA2   (NCHIR)  = IA2
      RC_IA3   (NCHIR)  = IA3
      RC_IA4   (NCHIR)  = IA4
      RC_SIGN  (NCHIR)  = RS_LABEL
      RC_TYPE  (NCHIR)  = ' '
      RC_FLAG  (NCHIR)  = ' '
      RETURN
      END

      SUBROUTINE GET_PLAN_EMIN(MDOC,RS_NAME,NPLAN,RS_LABEL
     *     ,RS_NUM,RS_NUM_OLD,IA1
     *     ,RS_VIDL,RS_VOBS
     *     ,C_LINE,IFLAG,IERR)
C ----------------------------------------------------------
      INCLUDE 'atom_com.fh'
      INCLUDE 'rstr_com.fh'
C -----------------------------------------------------------
C ==----------------------------------------------------------
      INTEGER*4   MDOC,IERR,IFLAG,IA1,IAA1
      INTEGER     NPLAN,RS_NUM,RS_NUM_OLD
      CHARACTER   RS_NAME*4
      CHARACTER   RS_LABEL*8
      CHARACTER   LINE*256,C_LINE*256
C --------------------------------------
      IERR  = 0
      MD    = -ABS(MDOC)-1
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C -------------------------------
      IF(RS_NUM.NE.RS_NUM_OLD) THEN
        IF(NPLAN.GE.MAXRPLAN) THEN
          CALL MSGERR(MDOC
     *    ,' ERROR: number of plan restraints > limit.')
          CALL MSGERR(MDOC
     *    ,'      change parameter MAXRPLAN in "rstr_com.fh"')
          IERR=1
          RETURN
        ENDIF
        NPLAN = NPLAN + 1
        RP_NATOM(NPLAN)=0
      ENDIF

      NA = RP_NATOM(NPLAN) + 1
      IF(NA.GE.MAXRATMP) THEN
        CALL MSGERR(MDOC
     *  ,' ERROR: number of plan atoms > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXRATMP in "rstr-com.fh"')
        IERR=1
        RETURN
      ENDIF
      RP_NATOM(NPLAN)    = RP_NATOM(NPLAN)+1

      RP_LABEL(NPLAN)    = RS_LABEL
      RP_FLAG (NPLAN)    = ' '
      RP_IATM (NA,NPLAN) = IA1
      RP_DEV  (NA,NPLAN) = RS_VIDL 
      RP_DOBS (NA,NPLAN) = RS_VOBS

      RETURN
      END

      SUBROUTINE ANGTOCR_S(MDOC,LIST,ISTART,IFINISH
     *  ,X,NDIST
     *  ,LENGTH,THETA,PHI,CONN,MAX1BRN,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      REAL      LENGTH(*),X(3,*),THETA(*),PHI(*)
      INTEGER   CONN(MAX1BRN,*),NDIST(*)
C ---
      PARAMETER ( NSTLIM = 10 )
      INTEGER*4 NSTCK,ISTACK(NSTLIM),ICSTACK(NSTLIM)
      REAL      ASTACK(3,3,NSTLIM)
C --------------------------------------
      REAL      A(3,3)
      INTEGER*4 IC
      CHARACTER LINE*256,LIST*1
C ---------------------------------------
C ----
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0

      IERR = 0
C ---
      DO I=1,3
      DO J=1,3
        A(I,J) = 0.0
      ENDDO
      ENDDO
      A(1,1) = 1.0
      A(2,2) = 1.0
      A(3,3) = 1.0
C ---
      I        = ISTART
      IC       = 1
      NSTCK    = 0

      X(1,I) = 0.0
      X(2,I) = 0.0
      X(3,I) = 0.0

  400 CONTINUE

      N = NDIST(I)

      IF(N.LE.0.AND.NSTCK.LE.0) GO TO 500

        IF(N.EQ.0) THEN

          IF(NSTCK.LE.0) THEN
            GO TO 2000
          ENDIF
 
          I     = ISTACK (NSTCK)
          IC    = ICSTACK(NSTCK)
          CALL  NB_MCOPY(ASTACK(1,1,NSTCK),A)
          NSTCK = NSTCK-1
          IF(I.LE.0.OR.IC.LE.0) THEN
            GO TO 2000
          ENDIF

        ELSE IF(N.EQ.1) THEN

          INEXT = CONN(1,I)
          CALL POLTOCRD_S(INEXT,I,N,A,X
     *        ,LENGTH,THETA,PHI,CONN,MAX1BRN)
          CALL CHANGE_A(INEXT,I,N,A,THETA,PHI,CONN,MAX1BRN)
          IC    = 1
          I     = INEXT

        ELSE IF(N.GT.1) THEN

          INEXT = CONN(IC,I)

          CALL POLTOCRD_S(INEXT,I,N,A,X
     *        ,LENGTH,THETA,PHI,CONN,MAX1BRN)

          IF(IC.LT.N) THEN
            IC    = IC + 1
            NSTCK = NSTCK + 1
            IF(NSTCK.GT.NSTLIM) THEN
              WRITE(LINE,
     *        '('' ERROR: N-stack > '',I6)')
     *        NSTLIM
              CALL MSGERR(MDOC,LINE)
              IERR=1
              GO TO 2000
            ENDIF

            ISTACK(NSTCK)  = I
            ICSTACK(NSTCK) = IC
            CALL  NB_MCOPY(A,ASTACK(1,1,NSTCK))
          ENDIF
   
          CALL CHANGE_A(INEXT,I,N,A,THETA,PHI,CONN,MAX1BRN)
          I  = INEXT
          IC = 1

        ELSE

          GO TO 2000

        ENDIF
      GO TO 400
C -----------------
  500 CONTINUE
      RETURN
C ------------------
 2000 CONTINUE
      WRITE(LINE,
     *'('' WARNING: ANGTOCR : wrong tree structure'')')
      CALL MSGERR(MDOC,LINE)
      IERR = 1
      RETURN    
      END

      SUBROUTINE CHANGE_A(INEXT,I,N,A,THETA,PHI,CONN,MAX1BRN)
C ---------------------
      REAL      A(3,3),Y(3,3),Z(3,3),X(3,3)
      REAL      THETA(*),PHI(*)
      INTEGER   CONN(MAX1BRN,*)
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C -----------------------------------
      PHI0 = PHI(CONN(N,I))
      PHII = PHI(INEXT)

      IF(CONN(N,I).NE.INEXT) PHII = PHII + PHI0 

      THETAI = THETA(INEXT)
C ---
      T = PI - THETAI*PI180
c      T = THETAI*PI180
      F = PHII*PI180
      COST   = COS(T)
      SINT   = SIN(T)
      COSF   = COS(F)
      SINF   = SIN(F)
C ---
      Y(1,1) = COST
      Y(1,2) =-SINT
      Y(1,3) = 0.0
      Y(2,1) = SINT*COSF
      Y(2,2) = COST*COSF
      Y(2,3) =-SINF
      Y(3,1) = SINT*SINF
      Y(3,2) = COST*SINF
      Y(3,3) = COSF

C      TT = t/pi180
C      WRITE(*,*) 'CA',INEXT,I,N
C      WRITE(*,*) 't,f',tt,phiI   
c      write(*,*) 'A ',A(1,1),A(1,2),A(1,3)
c      write(*,*) 'A ',A(2,1),A(2,2),A(2,3)
c      write(*,*) 'A ',A(3,1),A(3,2),A(3,3)
C
c      X(1,1) = 1.0
c      X(1,2) = 0.0
c      X(1,3) = 0.0
c      X(2,1) = 0.0
c      X(2,2) = COSF
c      X(2,3) =-SINF
c      X(3,1) = 0.0
c      X(3,2) = SINF
c      X(3,3) = COSF
C
c      write(*,*) 'x ',x(1,1),x(1,2),x(1,3)
c      write(*,*) 'x ',x(2,1),x(2,2),x(2,3)
c      write(*,*) 'x ',x(3,1),x(3,2),x(3,3)
C
c      Z(1,1) = COST
c      Z(1,2) =-SINT
c      Z(1,3) = 0.0
c      Z(2,1) = SINT
c      Z(2,2) = COST
c      Z(2,3) = 0.0
c      Z(3,1) = 0.0
c      Z(3,2) = 0.0
c      Z(3,3) = 1.0
C
c      write(*,*) 'z ',z(1,1),z(1,2),z(1,3)
c      write(*,*) 'z ',z(2,1),z(2,2),z(2,3)
c      write(*,*) 'z ',z(3,1),z(3,2),z(3,3)
C
c      CALL NB_MATMLT(X,Z,Y)
C
c      write(*,*) 'y ',y(1,1),y(1,2),y(1,3)
c      write(*,*) 'y ',y(2,1),y(2,2),y(2,3)
c      write(*,*) 'y ',y(3,1),y(3,2),y(3,3)
C
C      CALL NB_MTRANS(Y,Y)

      CALL NB_MATMLT(A,Y,Z)
      CALL NB_MCOPY(Z,A)
C ---
      RETURN
      END

      SUBROUTINE POLTOCRD_S(INEXT,I,N,A,X
     *                    ,LENGTH,THETA,PHI,CONN,MAX1BRN)
C ---------------------
      REAL      LENGTH(*),X(3,*),THETA(*),PHI(*)
      REAL      A(3,3),DX(3),DY(3)
      INTEGER   CONN(MAX1BRN,*)
C ---------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
C -----------------------------------
      PHI0 = PHI(CONN(N,I))
      PHII = PHI(INEXT)

      IF(CONN(N,I).NE.INEXT) PHII = PHII + PHI0 

      PHII   = PHII*PI180
      THETAI = THETA(INEXT)*PI180
      DX(1)  =-COS(THETAI)*LENGTH(INEXT)
      DDX    = SIN(THETAI)*LENGTH(INEXT)
      DX(2)  = COS(PHII)*DDX
      DX(3)  = SIN(PHII)*DDX

      CALL NB_MVMULT(A,DX,DY)

      X(1,INEXT) = X(1,I) + DY(1)
      X(2,INEXT) = X(2,I) + DY(2)
      X(3,INEXT) = X(3,I) + DY(3)

      RETURN
      END
