
      program tlsgroups
c
      implicit none
      INCLUDE 'celsym.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'const.fh'
      INCLUDE 'monitor.fh'
c
c---locals
      integer isysw,isysr,ifofc,iscrf,iatmr,idisk,jdisk,newfil,
     &     inxyz,ioutx,mtzin
      COMMON /FILES / ISYSR,ISYSW,IFOFC,ISCRF,IATMR,IDISK,JDISK,NEWFIL
     .               ,INXYZ,IOUTX,MTZIN
      isysw = 6
c
c---body
      call ccpfyp
      isysw =6
      write(*,*)
      write(*,*)' tlsgroup version 0.1'
      write(*,*)

      call set_makecif_params
      call tls_instructions

      call makecif_refmac1
      call write_tls_params

      stop
      end

      subroutine set_makecif_params
      implicit none
      INCLUDE 'celsym.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'const.fh'
      INCLUDE 'monitor.fh'
c
c--Parameters
      MAKE_HFLAG         = 'A'
      MAKE_HFLAG_O       = 'N'
      MAKE_RFLAG         = 'N'
      MAKE_LNK_FLAG      = 'N'
      MAKE_CHECK_SPEC    = 'N'
      MAKE_FORM          = 'U'
      MAKE_PEPT_FLAG     = 'N'
      MAKE_CONN_FLAG     = 'N'
      MAKE_SYMM_FLAG     = 'Y'
      MAKE_CHAIN_FLAG    = 'N'
      MAKE_SS_FLAG       = 'Y'
      MAKE_CIS_FLAG      = 'Y'
      MAKE_SUGAR_FLAG    = 'S'
      MAKE_EXIT          = 'N'
      MAKE_CHECK         = 'N'
      MAKE_LIGAND_LEVEL_FLAG = 'H'
      MAKE_NEWL_VALUE_FLAG   = 'N'
      MAKE_NEW_FLAG      = 'N'
      MAKE_SRCH_FLAG     = 'N'
      make_segid_in_flag = 'N'
      make_segid_out_flag= 'N'
      MAKE_LIBS_PATH     = ' '
      MAKE_LIBS_NAME     = ' '
      MAKE_LIBS_EXT      = ' '
      MAKE_PROG_LIB_PATH = ' '
      MAKE_OUT_FILE      = ' '
      MAKE_FILE_LIB2     = ' '
      MAKE_CUTOFF        = 0.0
      MAKE_DMIN_SPEC     = 0.1
      return
      end
c
      subroutine tls_instructions
      implicit none
      include 'tls_define.fh'
      include 'makecif.fh'
c
c---locals
      integer i,ipiece,igroup
      integer npars
      parameter (npars = 500)
      integer ntok
      CHARACTER LINE*600,KEY*4,CVALUE(NPARS)*4
      INTEGER IBEG(NPARS),IEND(NPARS),IDEC(NPARS),ITYP(NPARS)
      REAL FVALUE(NPARS)
      LOGICAL LEND,lprint

      tls_define_flag = 'C'
      ngroup_tls = 0
 10   continue
      line = ' '
      key = ' '
      ntok = npars
      lprint = .TRUE.
      CALL PARSER(KEY,LINE,IBEG,IEND,ITYP,FVALUE,CVALUE,IDEC,NTOK,LEND,
     +            LPRINT)
      IF(LEND) GOTO 100
      
      call ccpupc(KEY)
      do  i=1,ntok
         call ccpupc(cvalue(i))
      enddo
      if(key.eq.'END') goto 100
c
      if(key.eq.'TLS') then
         if(cvalue(2).eq.'GROU') then
            if(cvalue(3).eq.'CHAI') then
               tls_define_flag = 'C'
            elseif(cvalue(3).eq.'DEFI') then
               tls_define_flag='D'
               if(ntok.gt.3) then
                  ngroup_tls = ngroup_tls + 1
                  if(ngroup_tls.gt.maxgroup_tls) stop
                  ipiece = 0
                  do  i=4,ntok
                     ipiece = ipiece + 1
                     ntls_pieces(ngroup_tls) = ipiece
                     if(ipiece.gt.maxpieces) stop
                     chains_gr(ngroup_tls,ipiece)=line(ibeg(i):iend(i))
                  enddo
               else
               endif
            endif
         endif
      else if(key.eq.'MAKE') then
         if(cvalue(2).eq.'SEGI') then
            if(ntok.ge.3.and.cvalue(3)(1:1).eq.'Y') 
     &           make_segid_in_flag='Y'
         endif
      endif
      goto 10
c
 100  continue
      return
      end
c
      subroutine write_tls_params
      implicit none
      include 'atom_com.fh'
      include 'makecif.fh'
      include 'tls_define.fh'
c
c---locals
      integer i,j,l,k
      integer itls_out,ifail,ll
      character tls_file*512
c
      integer lenstr
      external lenstr
c
      call ugtenv('TLSOUT',tls_file)
      l=lenstr(tls_file)
      if(l.le.0) tls_file = 'tls_file.tls'
      itls_out = 0
      ifail = -1
      call ccpdpn(itls_out,tls_file,'UNKNOWN','F',LL,IFAIL)
      write(*,*)n_grp_asm,n_group
      if(tls_define_flag.eq.'C') then
         do i=1,n_group
            write(itls_out,'(a)')'TLS'
            write(itls_out,'(a)')'range from 1 '//CHAIN_ID(i)//
     &           ' to 9999 '//CHAIN_ID(i)
            write(itls_out,*)
         enddo
      else
c
c--First check and make sure all chains are present in the pdb file
c
         do i=1,ngroup_tls
            do  j=1,ntls_pieces(i)
               do   k=1,n_group
                  if(chains_gr(i,j).eq.chain_id(k)) goto 50
               enddo
            enddo
         enddo
c
         write(*,*)
     &        'Error ==> One or more chains are absent in the PDB'
         stop
 50      continue
         do i=1,ngroup_tls
            write(itls_out,'(a)')'TLS '
            do j=1,ntls_pieces(i)
            write(itls_out,'(4a)')'range from 1 '//chains_gr(i,j)//
     &              ' to 9999 '//chains_gr(i,j)
            enddo
            write(itls_out,*)
         enddo
      endif
      close(itls_out)

      return
      end
c
      SUBROUTINE MAKECIF_REFMAC1
      IMPLICIT NONE
      INCLUDE 'celsym.fh'
      INCLUDE 'atom_com.fh'
      INCLUDE 'makecif.fh'
      INCLUDE 'const.fh'
      INCLUDE 'monitor.fh'
C
C--Read pdb file
c
c--locals
      REAL CELL_C(6)
      CHARACTER IN_COORD_FILE*256
      CHARACTER MAKE_FSTOP*1,h_r*1,pept_flag*1
      character file_type_flag*1
      INTEGER IERR,MDOC,NSPGRP,I
c
c---Body
      MDOC = -999
      CALL UGTENV('XYZIN',IN_COORD_FILE)
      if(in_coord_file.eq.' ') then
         write(*,*)'Error: Input file is empty'
         stop
      endif
      NSPGRP = 0
      DO   I=1,6
         CELL_C(I) = 0.0
      ENDDO
      IERR          = 0
      ierr = 99
      h_r='Y'
      pept_flag='N'
      write(*,*)in_coord_file(1:2)
      CALL PDB_OR_CIF(MDOC,IN_COORD_FILE,FILE_TYPE_FLAG,IERR)
      write(*,*)'file type =',file_type_flag
      CALL INIT_ATM_INF(MDOC,IERR)
      CALL INIT_DEFAULTS
      ierr = 0
      call get_pdb(mdoc,in_coord_file,nspgrp,cell_c,pept_flag,
     &     make_segid_in_flag,h_r,ierr)
      if(ierr.gt.0) then
         write(*,*)ierr
         write(*,*)'Error in reading pdb file'
         stop
      endif
      return
      end
c
      subroutine refmac_clean_up_files

      return
      end
