C
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C ======================================================================
C ******
      SUBROUTINE GET_PDB(MDOC,FILE_PDB
     *     ,NOSPGR_INPUT,CELL_INPUT,PEPT_FLAG,SEG_FLAG,
     *     HFLAG_REMOVE,IERR)    
C -----------------------------------------------
C -P- GET_PDB -
C -S-
C -----------------------------------------------
C     INTEGER*4 KERR
      INTEGER*4 MDOC,IERR,NOSPGR_INPUT
      REAL      CELL_INPUT(6)
      CHARACTER FILE_PDB*(*),PEPT_FLAG*1,SEG_FLAG*1
C ---
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C ******
      INCLUDE 'link_com.fh'
C -----------------------------------
      COMMON/STTCREC/ ICEND,JEND,ICH0,ICOMPND,IOCC,ICRST,IDNA,IHNTO
     *               ,ISCL,ISPGR,IRD_CRD,KEND_STTC,STR,FATOM
      INTEGER*4 ICEND,JEND,ICH0,ICOMPND,IOCC,ICRST,IDNA,IHNTO,ISCL
      INTEGER*4 IRD_CRD,ISPGR,KEND_STTC
      CHARACTER STR*256,FATOM*5
C ---
      COMMON/COM_RDAT/ CP_OXT,CP_OXT_OLD
      CHARACTER        CP_OXT*1,CP_OXT_OLD*1
C ---
      INTEGER*4 IEND
      REAL      X(3),ORT_FRAC_OLD(3,3),FRAC_TO_ORT_NEW(3,3)
      CHARACTER REC*6,CH12*12,LINE*256,CH5*5,INS_FLAG*1,RNAME_OLD*8
      CHARACTER LIST*1,PROG_NAME*1,ACODE*4,HFLAG_REMOVE*1
C -----------------------------------
      PI        = 4.0*ATAN(1.0)
      PI180     = PI/180.0
C -------
      LIST = 'N'
C     list = 'T' ierr 0 --> 98, ierr = 1 -->99
      IF(IERR.GE.98) THEN
        LIST = 'T'
        IERR = IERR -98
      ENDIF

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) ' ---get PDB: ierr =',ierr
      ENDIF

      IF(IERR.NE.1) THEN
        CALL INIT_RES_TYPE_TAB
        PROG_NAME   = '.'
      ELSE
C       subroutine is called from MAKECIF or LIBCHECK
        PROG_NAME   = 'M'
      ENDIF
C ---
C     remove H D atoms 22.07.2004
c      HFLAG_REMOVE = 'Y'
C ---
      CR_SEGFLAG  = SEG_FLAG
      IERR        = 0
      REC         = 'START '
      IR          = 0
      CH12        = '????????????'
      ICHAIN      = 0
      NCONN_PDB   = 0
      NHENT       = 0
      NSS_PDB     = 0
      NUMB_P      = 0
      CH5         = '?????'
      IC_FLAG     = 0
      IR_FLAG     = 0
      ICRST       = 0
      ISPGR       = 0

      N_GRP_ASM   = 0

      ENT_LN_N    = 0
      N_CHN_ENT   = 0
      N_GROUP     = 0
      N_RESIDUE   = 0
      N_ATOM      = 0
      MOD_N       = 0
      LN_N        = 0
      IDELT       = 0
      ID          = 0
      IPRES       = 0
      IPRES_OLD   =-1000
      INS_FLAG    = 'N'
      RNAME_OLD   = '?'
      IR_TYPE_OLD = 1
      CP_OXT      = 'N'
      CP_OXT_OLD  = 'N'

      OUT_CIF_MULT = 1
      OUT_CIF_CORR = 1
      OUT_CIF_INS  = 1

      CRI_FILE  = FILE_PDB
      CRI_PATH  = ' '
      CRI_EXT   = ' '

  100 CONTINUE

      CALL GETREC(MDOC,REC,NOSPGR_INPUT,CELL_INPUT,IERR,IEND
     *           ,PROG_NAME,ACODE,HFLAG_REMOVE)

      IF(IERR.NE.0) RETURN

      IF(IEND.NE.0) GO TO 200

c                     ATOM
      IF(REC(1:4).EQ.'ATOM') THEN

        IF(CR_PNUM.NE.CH12.OR.RNAME_OLD.NE.CR_RNAME) THEN
C         new residue
          IR_FLAG = 1
C          CALL SET_INI_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
          CALL GET_STANDARD_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
C         input CR_RNAME(1:3),output ITYPE: 1 - non-polymer
          IF(ITYPE.EQ.1) THEN
            CALL GET_INI_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
C           TYPE from dictionary, input CR_RNAME(1:8) ;  9 - HOH 
          ENDIF
c         ITYPE = 3  peptide
c         ITYPE = 10 polymer
c         ITYPE = 5  dna/rna
c         ITYPE = 7  sugar
c         ITYPE = 9  HOH , DUM

          IF(CR_PNUM(8:12).NE.CH5) IC_FLAG = 1

          IF(LIST.EQ.'T') THEN
            write(*,*) '------------'
            write(*,*) '<',cr_pnum,'><',ch5,'><',cr_rname,'><',cr_aname
            write(*,*) ic_flag,ir_flag,ir_type_old,itype,ich0
            write(*,*) 
          ENDIF

          IF(IC_FLAG.EQ.0) THEN
C            if IC_FLAG = 1 - new group
            IF(IR_TYPE_OLD.NE.ITYPE)              IC_FLAG = 1

C            IF(ITYPE.NE.3.AND.ITYPE.NE.10.AND.ITYPE.NE.5.AND.
C     *                                        ITYPE.NE.7) IC_FLAG = 1

            IF(ITYPE.NE.3.AND.ITYPE.NE.10.AND.ITYPE.NE.5) IC_FLAG = 1
 
            IF(IR_TYPE_OLD.EQ. 9.AND.ITYPE.EQ. 9) THEN
              IC_FLAG = 0
              IF(CR_PNUM(8:12).NE.CH5) IC_FLAG = 1 
            ENDIF
            IF(IR_TYPE_OLD.EQ. 3.AND.ITYPE.EQ.10) IC_FLAG = 0 
            IF(IR_TYPE_OLD.EQ.10.AND.ITYPE.EQ. 3) IC_FLAG = 0 
            IF(CP_OXT_OLD.EQ.'Y'.AND.
     *        (IR_TYPE_OLD.EQ.3.OR.IR_TYPE_OLD.EQ.10)) IC_FLAG = 1
            IF(IC_FLAG.EQ.1) THEN
              ICH0 = ICH0 + 1
              IF(ICH0.GT.9) ICH0 = 0
              WRITE(CR_PNUM(2:2),'(I1)') ICH0
              IF(CR_SEGFLAG.EQ.'Y') THEN
                CR_PNUM(12:12) = CR_PNUM(2:2)
              ELSE
                CR_PNUM(9:9) = CR_PNUM(2:2)
              ENDIF
            ENDIF    
          ELSE
            IF(IR_TYPE_OLD.EQ. 9.AND.ITYPE.EQ. 9) THEN
              IC_FLAG = 0 
              IF(CR_PNUM(8:12).NE.CH5) IC_FLAG = 1 
            ENDIF
          ENDIF
          CP_OXT_OLD  = 'N'
          IR_TYPE_OLD = ITYPE
          
        ENDIF

        IF(LIST.EQ.'T'.AND.IC_FLAG.EQ.1) THEN
          write(*,*) '  -->ic_flag:',ic_flag
        ENDIF

  
        IF(IC_FLAG.EQ.1) THEN
C         IF(CR_PNUM(8:12).NE.CH5) THEN
C         new group
C         IC_FLAG = 1
          IR_FLAG = 1
          ICHAIN  = ICHAIN + 1
          CH5     = CR_PNUM(8:12)
          IR      = 0
        ENDIF

        IF(IR_FLAG.EQ.1) THEN
c       IF(CR_PNUM.NE.CH12.OR.RNAME_OLD.NE.CR_RNAME) THEN
C         new residue
C         IR      = IR + 1
          READ(CR_PNUM(3:6),'(I4)') IPRES
          IF(CR_PNUM(7:7).NE.' ') THEN
            INS_FLAG = 'Y'
          ENDIF

          RNAME_OLD = CR_RNAME

          IF(IR.EQ.0) THEN
            IR    = IPRES
            IF(IR.LE.0) IR = 1
            IDELT = 0
            ID    = 0
          ELSE
            ID = IPRES - IPRES_OLD
            IF(ID.LE.0) THEN
C             CALL SET_INI_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
              CALL GET_STANDARD_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
              IF(ITYPE.EQ.1) THEN
                CALL GET_INI_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
              ENDIF
              IF(ITYPE.EQ.7) THEN
                IF(ID.EQ.0) ID = 1               
              ELSE
                ID           = 1
                OUT_CIF_INS  = 0
              ENDIF
            ENDIF
            IR = IR +ID 
          ENDIF

C         IR_FLAG = 1
          IF(LIST.EQ.'T') THEN
            write(*,*) '  -->ir_flag:',ir_flag
          ENDIF

        ENDIF

        CR_IRES = IR

        CALL CP_CRD(MDOC,IC_FLAG,IR_FLAG,ID,ACODE,LIST,IERR)
        IF(IERR.NE.0) RETURN

        CH12      = CR_PNUM
        CH5       = CH12(8:12)
        IC_FLAG   = 0
        IR_FLAG   = 0
        IPRES_OLD = IPRES

        IF(CP_OXT.EQ.'Y') CP_OXT_OLD = CP_OXT
        CP_OXT    = 'N'

      ENDIF

      GO TO 100
C -------------------------------------
  200 CONTINUE
C -------------------------------------
C
C     copy conn & links & ssbonds to LN array
C
      CALL NSS_PDB_TO_LN(MDOC,LIST,IERR)

      CALL CORR_NUMBER_CHAIN_PDB(MDOC,LIST,IERR)
C
      CALL CORR_SUGAR_PDB(MDOC,LIST,IERR)

      IF(PEPT_FLAG.EQ.'Y') THEN
        CALL CORR_PEPTIDE_PDB(MDOC,IERR)
      ENDIF

C
C     check and correct chain id
C
      IF(CR_SEGFLAG.NE.'Y') THEN
        CALL CHECK_CHAIN_ID_PDB(MDOC,INEW,IERR)
        IF(INEW.GT.0) THEN
c         CALL MSGDOC(MDOC,
c      *' WARNING: Chain_list is not correct. Program changed it.')
c         CALL MSGDOC(MDOC,
c      *'          Different chains have the same chain id.')
        ENDIF
      ELSE
        CALL CHECK_CHAIN_ID_SEG(MDOC,INEW,IERR)
      ENDIF
C
C     set type of chain's terminus
C
      CALL SET_MOD(MDOC,IERR)
      IERR = 0

C
C     set new atom's number
C

      DO I=1,N_ATOM
        I_ATOLD(I) = I
      ENDDO
C -------------------------------------
      ICONVERT = 1
      IF(CELL_INPUT(1).GT.1.0) THEN
        ICONVERT = 0
        IF(ICRST.GT.0) THEN
          ICONVERT = 1
          DO I=1,6
            IF(I.LE.3) THEN
              TEST = CELL_INPUT(I)/CS_CELL(I)
            ELSE
              TEST = (CELL_INPUT(I)*PI180)/CS_CELL(I)
            ENDIF
            IF(TEST.GT.1.1.OR.TEST.LT.0.9) ICONVERT = 0 
          ENDDO
        ENDIF

        CALL NB_MCOPY(CS_ORT_TO_FRAC,ORT_FRAC_OLD)      

C -->    21.11.02
C        ICRST = 1

        DO I=1,6
          CS_CELL(I) = CELL_INPUT(I) 
        ENDDO
        CS_CELL(4) = CS_CELL(4)*PI180
        CS_CELL(5) = CS_CELL(5)*PI180
        CS_CELL(6) = CS_CELL(6)*PI180

        CALL NB_FRORTH(CS_CELL(1),CS_CELL(2),CS_CELL(3)
     *             ,CS_CELL(4),CS_CELL(5),CS_CELL(6)
     *             ,CS_FRAC_TO_ORT,CS_ORT_TO_FRAC,IERR)

        DO I=1,3
          DO J=1,3
            CS_SCALE(I,J) = CS_ORT_TO_FRAC(I,J)
          ENDDO
          CS_U(I) = 0.0
        ENDDO

        CALL NB_MCOPY(CS_FRAC_TO_ORT,FRAC_TO_ORT_NEW)      

        IF(ICONVERT.GT.0) THEN 
C ////
cd          CALL MAKE_CORRECTION_TO_CELL_DIFF(ORT_FRAC_OLD
cd     *    ,FRAC_TO_ORT_NEW,IERR)
C ////
          DO I=1,N_ATOM
            CALL NB_MVMULT(ORT_FRAC_OLD,XYZ_CRD(1,I),X)
            CALL NB_MVMULT(FRAC_TO_ORT_NEW,X,XYZ_CRD(1,I))
          ENDDO
C ////
        ENDIF

      ENDIF
C --------------------------------------
      WRITE(LINE,'('' Number of atoms    :'',I8)') N_ATOM
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of residues :'',I8)') N_RESIDUE
      CALL MSGDOC(MDOC,LINE)
      WRITE(LINE,'('' Number of chains   :'',I8)') N_GROUP
      CALL MSGDOC(MDOC,LINE)
C ---

C --> 21.11.02
      IF(ICONVERT.EQ.0) IERR = 10

      IF(ISPGR.EQ.0.AND.ICRST.EQ.0) THEN
        IERR = 9
      ELSE IF(ISPGR.EQ.0) THEN
        IERR = 8
      ELSE IF(ICRST.EQ.0) THEN
        IERR = 7
      ENDIF
C ---
      CALL CHECK_NUM_IN_CHAIN(MDOC,IERR1)
      IF(IERR.EQ.0) IERR = IERR1
C     IERR =6
C ---
      RETURN
      END

C ******
      SUBROUTINE GETREC(MDOC,REC,NOSPGR_INPUT,CELL_INPUT
     *                 ,IERR,IEND,PROG_NAME,ACODE,HFLAG_REMOVE)
C -----------------------------------------------
C -P- GETREC - open file, reads a record of PDB_file and put information to 
C -P-          common/CRDINF/,/CRDATM/,/CRDMLN/. 
C              Creats string PNUM (7 chars).  
C              PNUM_PDB = chainID + residue's number + insertion code PDB.
C              Real chainID and residue's number will be calculated later.
C              Close file.
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR,IEND,NOSPGR_INPUT
      REAL      CELL_INPUT(6)
      CHARACTER REC*6,PROG_NAME*1,ACODE*4,HFLAG_REMOVE*1
C -----------------------------------------------
      INCLUDE 'crd_com.fh'
C ******
C -----------------------------------
      COMMON/STTCREC/ ICEND,JEND,ICH0,ICOMPND,IOCC,ICRST,IDNA,IHNTO
     *               ,ISCL,ISPGR,IRD_CRD,KEND_STTC,STR,FATOM
      INTEGER*4 ICEND,JEND,ICH0,ICOMPND,IOCC,ICRST,IDNA,IHNTO,ISCL
      INTEGER*4 IRD_CRD,ISPGR,KEND_STTC
      CHARACTER STR*256,FATOM*5
C ---
      COMMON/COM_RDAT/ CP_OXT,CP_OXT_OLD
      CHARACTER        CP_OXT*1,CP_OXT_OLD*1
C ---
      REAL      PI
      INTEGER*4 M,IUN
      CHARACTER LINE*80
C -----------------------------------
      IERR = 0
      IEND = 0
      IF(REC.EQ.'START ') THEN
C ---
C       open file of coords PDB
        IF(CRI_FILE.EQ.' ') THEN
          CALL MSGERR(MDOC,' ERROR: can''t open PDB_file')
          IERR=1
          RETURN
        ENDIF
C       IUN = 14
        IUN = CRI_IUN
        M   = 99
        CALL OPENFR(IUN,M,CRI_PATH,CRI_FILE,CRI_EXT,IERR)
        CRI_IUN = IUN
        IF(IERR.NE.0) THEN
          CALL MSGERR(MDOC,' ERROR: can''t open PDB_file')
          RETURN
        ENDIF
C ---
        PI = 4.0*ATAN(1.0)

        CR_CELL(1)  = 1.0
        CR_CELL(2)  = 1.0
        CR_CELL(3)  = 1.0
        CR_CELL(4)  = PI/2.0
        CR_CELL(5)  = PI/2.0
        CR_CELL(6)  = PI/2.0
        CR_NAME_PDB = '----'
        CR_DATE_PDB = 'XX-XXX-XX'
        CR_CD_PDB   = 'xxxx'
        CR_TITLE    = '---'
        CR_NSPGR    = 1
        CR_SETT     = 1
        CR_SPGR     = 'P 1'
        CR_IA       = 0
        CR_IRES     = 0
        CR_IGRES    = 0
        CR_ICH      = 0
        CR_IGROUP   = 0
        CR_GROUP    = '    '
        CR_CHAIN    = '    '
        CR_RTYPE    = '.'
        CR_TERM     = '.'
        CR_MODEL_PDB= 0
        CR_NCS      = 0
        CR_B_FLAG   = 0
        CR_RFAC_PDB = '.'
        CR_RESL_PDB = '.'
        ACODE       = ' '         
        CR_MULT_FLAG   = 0
        CR_MULT_FACTOR = 1

        ICEND       = 0
        ICH0        = 0
        ICOMPND     = 0
        IOCC        = 0
        ICRST       = 0
        IDNA        = 0
        IHNTO       = 0
        ICONN       = 0
        ISCL        = 0
        IRD_CRD     = 0
        ISPGR       = 0
        KEND_STTC   = 0
        CALL GETLINE(IUN,MDOC,STR,IERR,JEND)
        ICEND = JEND
        IF(IERR.NE.0.OR.JEND.NE.0) THEN
          IEND = JEND
          CLOSE(IUN)
          CRI_IUN = 0
          RETURN
        ENDIF
        REC = ' '
        
      ENDIF
C -----
      IUN = CRI_IUN
  100 CONTINUE
      LINE = STR   
      if(line(1:6).eq.'HETATM')line(1:6) = 'ATOM  '
      IEND = ICEND
      IF(IEND.NE.0) THEN
        CLOSE(IUN)
        RETURN
      ENDIF

      IF(KEND_STTC.NE.0) THEN
        JEND = KEND_STTC
        STR=' '
      ELSE
        STR = ' '
        CALL GETLINE(IUN,MDOC,STR,IERR,KEND_STTC)
        IF(IERR.NE.0) THEN
          CLOSE(IUN)
          RETURN
        ENDIF
        IMODE = 0
        CALL CHECK_LINE(IMODE,STR)
        CALL LENSTR_BL(STR,LEN)
        IF(KEND_STTC.NE.0.AND.LEN.LE.0) THEN
          JEND = KEND_STTC
          STR=' '
        ELSE IF(KEND_STTC.NE.0) THEN

        ENDIF
      ENDIF

      ICEND = JEND

      IF(LINE(1:6).EQ.'HEADER') THEN
        CALL RDHEAD_PDB(LINE)
        GO TO 100        
      ELSE IF(LINE(1:6).EQ.'COMPND') THEN
        ICOMPND = ICOMPND + 1
        IF(ICOMPND.EQ.1) CALL RDCOMPND(LINE)
        GO TO 100
      ELSE IF(LINE(1:5).EQ.'TITLE') THEN
        ICOMPND = ICOMPND + 1
        CALL RDTITLE_PDB(LINE)
        GO TO 100
      ELSE IF(LINE(1:4).EQ.'CRYS') THEN
        CALL RDCRYST1(LINE,NOSPGR_INPUT)
        GO TO 100
      ELSE IF(LINE(1:6).EQ.'MODEL ') THEN
        CALL RDMODEL(LINE)
        IF(CR_MODEL_PDB.GT.1) ICEND=1
        GO TO 100
      ELSE IF(LINE(1:6).EQ.'HET   ') THEN
        CALL RDHET(LINE)
        GO TO 100
      ELSE IF(LINE(1:6).EQ.'FORMUL') THEN
        CALL RDFORMUL(LINE)
        GO TO 100
      ELSE IF(LINE(1:6).EQ.'REMARK') THEN
        CALL RDREMARK(LINE)
        GO TO 100
      ELSE IF(LINE(1:6).EQ.'SCALE1'.OR.
     *        LINE(1:6).EQ.'SCALE2'.OR.
     *        LINE(1:6).EQ.'SCALE3') THEN
        CALL RDSCALE(LINE)
        GO TO 100
      ELSE IF(LINE(1:6).EQ.'MTRIX1'.OR.
     *        LINE(1:6).EQ.'MTRIX2'.OR.
     *        LINE(1:6).EQ.'MTRIX3') THEN
        CALL RDMTRIX(LINE)
        GO TO 100
      ELSE IF(LINE(1:6).EQ.'TER   ') THEN
        REC='TER   '
      ELSE IF(LINE(1:6).EQ.'CONECT') THEN
C       CALL RDCONECT(MDOC,ICONN,LINE,IERR)
        REC='CONECT'
      ELSE IF(LINE(1:6).EQ.'SSBOND') THEN
        CALL RDSSBOND(MDOC,LINE,IERR)
        REC='USER_L'
      ELSE IF(LINE(1:6).EQ.'MODRES') THEN
        CALL RDMODRES(MDOC,LINE,IERR)
        REC='USER_L'
      ELSE IF(LINE(1:6).EQ.'LINK  '.or.
     &       line(1:6).eq.'LINKR ') THEN
        line(1:6) = 'LINK  '
        CALL RDLINK(MDOC,LINE,IERR)
        REC='USER_L'
      ELSE IF(LINE(1:6).EQ.'CISPEP') THEN
        CALL RDCISPEP(MDOC,LINE,IERR)
        REC='USER_L'
c                            ATOM HETATM
      ELSE IF((LINE(1:4).EQ.'ATOM').OR. 
     *        (LINE(1:4).EQ.'HETA')) THEN
        IF(REC.EQ.'?') REC='ATOM  '
        CALL RDATOM(LINE,REC,NOSPGR_INPUT,CELL_INPUT,PROG_NAME
     *                                     ,ACODE,HFLAG_REMOVE)
c        IF(REC.NE.'?') REC='ATOM  '
        IF((STR(1:4).EQ.'SIGA').OR.          
     *     (STR(1:4).EQ.'ANIS').OR.          
     *     (STR(1:4).EQ.'USER').OR.          
     *     (STR(1:4).EQ.'SIGU')) GO TO 100
      ELSE IF(LINE(1:4).EQ.'ANIS') THEN
        CALL RDANISO(LINE)
        IF((STR(1:4).EQ.'SIGA').OR.          
     *     (STR(1:4).EQ.'USER').OR.          
     *     (STR(1:4).EQ.'SIGU')) GO TO 100
        IF(REC.NE.'?') REC='ATOM  '
      ELSE IF(LINE(1:4).EQ.'SIGA') THEN
        CALL RDSIGAT(LINE)
        IF((STR(1:4).EQ.'ANIS').OR.          
     *     (STR(1:4).EQ.'USER').OR.          
     *     (STR(1:4).EQ.'SIGU')) GO TO 100
        IF(REC.NE.'?') REC='ATOM  '
      ELSE IF(LINE(1:4).EQ.'SIGU') THEN
        CALL RDSIGUIJ(LINE)
        IF((STR(1:4).EQ.'SIGA').OR.          
     *     (STR(1:4).EQ.'USER').OR.          
     *     (STR(1:4).EQ.'ANIS')) GO TO 100          
       IF(REC.NE.'?') REC='ATOM  '
      ELSE
        GO TO 100
      ENDIF
      CR_PDB_REC = LINE(1:6)
      RETURN
C -----------------------------------
cCOLUMNS       DATA TYPE       FIELD          DEFINITION
c123456789012345678901234567890123456789012345678901234567890123456789012
cSSBOND   1 CYS E   48    CYS E   51                          2555
c----------------------------------------------------------------------------
c 1 -  6       Record name     "SSBOND"
c
c 8 - 10       Integer         serNum         Serial number.
c
c12 - 14       LString(3)      "CYS"          Residue name.
c
c16            Character       chainID1       Chain identifier.
c
c18 - 21       Integer         seqNum1        Residue sequence number.
c
c22            AChar           icode1         Insertion code.
c
c26 - 28       LString(3)      "CYS"          Residue name.
c
c30            Character       chainID2       Chain identifier.
c
c32 - 35       Integer         seqNum2        Residue sequence number.
c
c36            AChar           icode2         Insertion code.
c
c60 - 65       SymOP           sym1           Symmetry operator for 1st residue.
c
c67 - 72       SymOP           sym2           Symmetry operator for 2nd residue.
C ---
c LINK              Identification of inter-residue bonds.
c LINK
c
c Overview
c
c The LINK records specify connectivity between residues that is not implied by
c the primary structure. Connectivity is expressed in terms of the atom names.
c This record supplements information given in CONECT records and is provided
c here for convenience in searching.
c
c Record Format
c
c COLUMNS        DATA TYPE       FIELD       DEFINITION
c ----------------------------------------------------------------------------
c 1 -  6        Record name     "LINK  "
c
c13 - 16        Atom            name1       Atom name.
c
c17             Character       altLoc1     Alternate location indicator.
c
c18 - 20        Residue name    resName1    Residue name.
c
c22             Character       chainID1    Chain identifier.
c
c23 - 26        Integer         resSeq1     Residue sequence number.
c
c27             AChar           iCODE1      Insertion code.
c
c43 - 46        Atom            name2       Atom name.
c
c47             Character       altLoc2     Alternate location indicator.
c
c48 - 50        Residue name    resName2    Residue name.
c
c52             Character       chainID2    Chain identifier.
c
c53 - 56        Integer         resSeq2     Residue sequence number.
c
c57             AChar           iCode2      Insertion code.
c
c60 - 65        SymOP           sym1        Symmetry operator for 1st atom.
c
c67 - 72        SymOP           sym2        Symmetry operator for 2nd atom.
c
cDetails
c
c* The atoms involved in bonds between HET groups or between a HET group and
c standard residue are listed.
c
c* Interresidue linkages not implied by the primary structure are listed (e.g.,
c reduced peptide bond).
c
c* Non-standard linkages between residues, e.g., side-chain to side-chain, are
c listed.
c
c* Each LINK record specifies one linkage.
c
c* These records do not specify connectivity within a HET group (see CONECT),
c hydrogen bonds (see HYDBND), or disulfide bridges (see SSBOND).
c
c* Hydrogen bonds and salt bridges are described on HYDBND and SLTBRG records,
c respectively.
c
c * sym1 and sym2 are given as blank when the identity operator (and no cell
c translation) is to be applied to the atom.
c
c Verification/Validation/Value Authority Control
c
c The distance between the pair of atoms listed must be consistent with the
c bonding.
c
c Relationships to Other Record Types
c
c CONECT records are generated from LINKs when both atoms are present in the
c entry. If symmetry operators are given to generate one of the residues 
C involved
c in the bond, a REMARK record must appear which defines the symmetry
c transformation.
c
c Example
c
c          1         2         3         4         5         6         7
c 123456789012345678901234567890123456789012345678901234567890123456789012
c LINK         O1  DDA     1                 C3  DDL     2
c LINK        MN    MN   391                 OE2 GLU   217            2565
C SSBOND   1 CYS A   48    CYS D   48                          4456 

C ---
c MODRES            Identification of modifications to standard residues.
c MODRES 2ABC TTQ A   50A TRP  POST-TRANSLATIONAL MODIFICATION
c
c MODRES 3ABC ALA A   32  ALA  POST-TRANSLATIONAL MODIFICATION,D-ALANINE
c 1 -  6        Record name     "MODRES"
c
c 8 - 11        IDcode          idCode         ID code of this entry.
c
c13 - 15        LString         resName        Residue name used.
c
c17             Character       chainID        Chain identifier.
c
c19 - 22        Integer         seqNum         Sequence number.
c
c23             AChar           iCode          Insertion code.
c
c25 - 27        Residue name    stdRes         Standard residue name.
c
c30 - 70        String          comment        Description of the residue
c                                              modification.
C --
cExample
c
c         1         2         3         4         5         6         7
c123456789012345678901234567890123456789012345678901234567890123456789012
cSLTBRG       O   GLU    10      NZ   LYS   115
cSLTBRG       O   GLU    10      NZ   LYS   115                      3654
C CISPEP            Identification of peptide residues in cis conformation.
c
c CISPEP records specify the prolines and other peptides found to be in the cis
c conformation. This record replaces the use of footnote records to list cis
c peptides.
c
c Record Format
c
cCOLUMNS       DATA TYPE       FIELD        DEFINITION
c-------------------------------------------------------------------------
c 1 -  6       Record name     "CISPEP"
c
c 8 - 10       Integer         serNum       Record serial number.
c
c12 - 14       LString(3)      pep1         Residue name.
c
c16            Character       chainID1     Chain identifier.
c
c18 - 21       Integer         seqNum1      Residue sequence number.
c
c22            AChar           icode1       Insertion code.
c
c26 - 28       LString(3)      pep2         Residue name.
c
c30            Character       chainID2     Chain identifier.
c
c32 - 35       Integer         seqNum2      Residue sequence number.
c
c36            AChar           icode2       Insertion code.
c
c44 - 46       Integer         modnum       Identifies the specific model.
c
c54 - 59       Real(6.2)       measure      Measure of the angle in
c                                           degrees.
c
cDetails
c
c* Cis peptides are normally those with omega angles of 030. Deviations
clarger than 30 may be listed as cis by the depositor.
c
c* Each cis peptide is listed on a separate line, with an incrementally
cascending sequence number.
c
cVerification/Validation/Value Authority Control
c
cPDB generates these records automatically, however, the depositor may wish to
clist deviations larger than 30 degrees.
c
cRelationships to Other Record Types
c
cCISPEP is replacing the footnote which previously contained this information.
c
cPeptide bonds which deviate significantly from either cis or trans conformation
care annotated in the REMARK section.
c
cExample
c
c         1         2         3         4         5         6         7
c1234567890123456789012345678901234567890123456789012345678901234567890
cCISPEP   1 GLY A  116    GLY A  117                   18.50
cCISPEP   2 THR D   92    PRO D   93                  359.80
c
c* For a rhombohedral space group in the hexagonal setting, the lattice type
csymbol used is H.
c73 - 76        LString(4)      segID         Segment identifier, left-justified.
c
c77 - 78        LString(2)      element       Element symbol, right-justified.
c
c79 - 80        LString(2)      charge        Charge on the atom.
c* If an atom is provided in more than one position, then a non-blank alternate
clocation indicator must be used as the alternate location indicator for each of
cthe positions. Within a residue all atoms that are associated with each other
cin a given conformation are assigned the same alternate position indicator.
c
c* For atoms that are in alternate sites indicated by the alternate site
cindicator, sorting of atoms in the ATOM/HETATM list uses the following general
crules:
c
c     - In the simple case that involves a few atoms or a few residues with
c     alternate sites, the coordinates occur one after the other in the
c     entry.
c
c     - In the case of a whole macromolecular chain, or significant portion
c     of a chain, having alternate sites, the atoms for each alternate
c     position are listed together. The two conformers are delineated by
c     MODEL/ENDMDL records. In this case each MODEL must represent the
c     entire molecular assemblage, including any heterogen group which is
c     not necessarily disordered. Such is the case when DNA molecules are
c     placed in UP and DOWN positions.
c
c     - In the case of a large heterogen groups which are disordered, the
c     atoms for each conformer are listed together. The two lists are not
c     separated by MODEL/ENDMDL as is done for macromolecular chains.
c
c* Addition of atoms to side chains of standard residues are handled as follows:
c
c     The additional atoms (modifying group) are represented as a HET group
c     which is assigned its own residue name. The chainID, sequence number,
c     and insertion code assigned to the HET group is that of the standard
c     residue to which it is attached.
c
c* Chemical modifications of standard residue side chains by addition of new
catoms are handled as follows:
c
c     - The new atoms are represented as a HET group. This group is
c     assigned the chain name, sequence number, and insertion code of the
c     standard residue that it modifies.
c
c     - The atoms comprising these het groups are listed as HETATM and are
c     inserted in the ATOM list immediately after the TER record of the
c     chain. These groups are listed in the same order as the standard
c     residue to which they are bonded (i.e. from the N- to C-terminus for
c     polypeptides and from the 5' to 3' end for nucleic acids).
c
c     - Modified standard residues and the modifying het group may be
c     assigned the same SEGID to further describe the relationship between
c     the groups. PDB will use this mechanism only if SEGID's were not
c     assigned to these atoms for other purposes.
c
c     - Modified standard residues must have a corresponding MODRES record.
c
c* The insertion code is commonly used in sequence numbering and is described
chere. In most cases, the amino acids that comprise a protein are numbered
csequentially starting with 1. However, there are a number of situations that
cmay give rise to different numbering schemes:
c
c     - Homologous proteins can exist in a number of different species.
c     Depositors may use a residue numbering scheme in order to preserve
c     the homology. The reference protein may be numbered sequentially
c     starting with 1, then the homologous protein from another species
c     aligned to it. If residues are not present in the homologous
c     sequence, residue numbers may be skipped so that alignment can be
c     preserved. If additional residues are present relative to the
c     reference protein, they may have a letter, called an insertion code,
c     appended to the sequence number. Negative numbers and zeros are
c     permitted if they are needed to align the N-terminus.
c
c     REFERENCE PROTEIN NUMBERING        HOMOLOGOUS PROTEIN NUMBERING
c     ---------------------------------------------------------------------
c                 59                                  59
c                 60                                  60
c                 61
c                 62                                  62
c
c     REFERENCE PROTEIN NUMBERING         HOMOLOGOUS PROTEIN NUMBERING
c     ---------------------------------------------------------------------
c                 85                                  85
c                 86                                  86
c                                                     86A
c                                                     86B
c                 87                                  87
c
c     - The numbering of a proenzyme may be used for the enzyme following
c     cleavage.
c
c     - The molecule studied might be a portion of the whole protein. The
c     residue numbering scheme could show the relationship to the intact
c     protein.
c
c     - The protein might be a mutant with residues inserted and deleted.
c     As above, the residue numbering of the native protein could be
c     preserved by appropriate use of gaps in the numbering and/or
c     insertion codes.
c
c     - The nucleic acid community generally numbers structures
c     sequentially. For double-stranded nucleic acids, entries usually use
c     two different chain identifiers. For example, an octameric duplex
c     would be numbered 1 - 8 for chain A, and 9 - 16 for chain B.
c
c* If the depositor provides the data, then the isotropic B value is given for
cthe temperature factor.
c
c* If there is no isotropic B value from the depositor, but there is an ANISOU
crecord with anisotropic temperature factors, then the B equivalent is stored in
cthe tempFactor field, as calculated by:
c
c     B(eq) = 8pi**2{1/3[U(1,1) + U(2,2) + U(3,3)]}
c
c     - This will obviate the need to check if ANISOU records are present
c     before interpreting the contents of the temperature factor field.
c
c     - In some previously released PDB entries with anisotropic
c     temperature factors provided as ANISOU records, the temperature
c     factor field of the corresponding ATOM or HETATM record contained the
c     equivalent U-isotropic [U(eq)] which is calculated by:
c
c     U(eq) = 1/3[U(1,1) + U(2,2) + U(3,3)] x 10**-4
c
c* If there are neither isotropic B values from the depositor, nor anisotropic
ctemperature factors in ANISOU, then the default value of 0.0 is used for the
ctemperature factor.
c
c* In some entries, the occupancy and temperature factor fields are used for
cother quantities. In these cases, an explanation is provided in the remarks.
c
c* Columns 73 - 76 identify specific segments of the molecule. The segment id is
ca string of up to four (4) alphanumeric characters, left-justified, and may
cinclude a space, e.g., CH86, A 1, NASE. The segment itself may consist of a
ccomplete chain or a portion of a chain. The importance of this new field can be
cappreciated if one considers an antibody structure having two molecules in the
casymmetric unit. Since each chain must have a unique chain identifier, the two
cheavy chains and two light chains cannot currently be labeled to indicate their
cnature. Segment id's of CH, VH1, VH2, VH3, CL, and VL would clearly identify
cregions of the chains and the relationship between them. Users of X-PLOR will
cbe familiar with SEGID as used in the refinement application of X-PLOR.
c
c* Columns 77 - 78 contain the atom's element symbol (as given in the periodic
ctable), right-justified. This is especially needed because in some cases it has
cnot been possible to follow the convention that columns 13 - 14 of the atom
cname contain the element symbol. The most common cases are:
c
c     - In large het groups it sometimes is not possible to follow the
c     convention of having the first two characters be the chemical symbol
c     and still use atom names that are meaningful to users. A example is
c     nicotinamide adenine dinucleotide, atom names begin with an A or N,
c     depending on which portion of the molecule they appear in, e.g., AC6
c     or NC6, AN1 or NN1.
c
c     - Hydrogen naming sometimes conflicts with IUPAC conventions. For
c     example, a hydrogen named HG11 in columns 13 - 16 is differentiated
c     from a mercury atom by the element symbol in columns 77 - 78. Columns
c     13 - 16 present a unique name for each atom.
c
c* Columns 79 - 80 indicate any charge on the atom, e.g., 2+, 1-. In most cases
cthese are blank.
c
cVerification/Validation/Value Authority Control
c
cPDB checks ATOM/HETATM records for PDB format, sequence information, and
cpacking. The PDB reserves the right to return deposited coordinates to the
cauthor for transformation into PDB format.
c
cPDB intends to verify the coordinates against the experimental structure factor
cdata in the when available. Details on this will be forthcoming.
c
cRelationships to Other Record Types
c
cThe ATOM records are compared to the corresponding sequence database. Residue
cdiscrepancies appear in the SEQADV record. Missing atoms are annotated in the
cremarks. HETATM records are formatted in the same way as ATOM records. The
csequence implied by ATOM records must be identical to that given in SEQRES,
cwith the exception that residues that have no coordinates, e.g., due to
cdisorder, must appear in SEQRES. Remark 550 is used to describe the meaning
cassigned to any segment identifiers used.
c
cExample
c1234567890123456789012345678901234567890123456789012345678901234567890123456789
cATOM    145  N   VAL A  25      32.433  16.336  57.540  1.00 11.92      A1   N
cATOM    146  CA  VAL A  25      31.132  16.439  58.160  1.00 11.85      A1   C
cATOM    147  C   VAL A  25      30.447  15.105  58.363  1.00 12.34      A1   C
cATOM    148  O   VAL A  25      29.520  15.059  59.174  1.00 15.65      A1   O
cATOM    149  CB AVAL A  25      30.385  17.437  57.230  0.28 13.88      A1   C
cATOM    150  CB BVAL A  25      30.166  17.399  57.373  0.72 15.41      A1   C
cATOM    151  CG1AVAL A  25      28.870  17.401  57.336  0.28 12.64      A1   C
cATOM    152  CG1BVAL A  25      30.805  18.788  57.449  0.72 15.11      A1   C
cATOM    153  CG2AVAL A  25      30.835  18.826  57.661  0.28 13.58      A1   C
cATOM    154  CG2BVAL A  25      29.909  16.996  55.922  0.72 13.25      A1   C
cDetails
c
c* Every chain of ATOM/HETATM records presented on SEQRES records is terminated
cwith a TER record.
c
c* The TER records occur in the coordinate section of the entry, and indicate
cthe last residue presented for each polypeptide and/or nucleic acid chain for
cwhich there are coordinates. For proteins, the residue defined on the TER
crecord is the carboxy-terminal residue; for nucleic acids it is the 3'-terminal
cresidue.
c
c* For a cyclic molecule, the choice of termini is arbitrary.
c
c* Terminal oxygen atoms are presented as OXT for proteins, and as O5T or O3T
cfor nucleic acids.
c
c* The TER record has the same residue name, chain identifier, sequence number
cand insertion code as the terminal residue. The serial number of the TER record
cics one number greater than the serial number of the ATOM/HETATM preceding the
cTER.
c
c* For chains with gaps due to disorder, it is recommended that the C-terminus
catom be labelled O and OXT, and a REMARK explaining the ambiguity be provided.
c
cVerification/Validation/Value Authority Control
c
cTER must appear at the end of a chain. For proteins, there is usually a
cterminal oxygen, labeled OXT. The validation program checks for the occurrence
cof TER and OXT records.
c
cRelationships to Other Record Types
c
cThe residue name appearing on the TER record must be the same as the residue
cname of the immediately preceding ATOM or non-water HETATM record.
c
cExample
c
c         1         2         3         4         5         6         7         8
c12345678901234567890123456789012345678901234567890123456789012345678901234567890
cATOM   4150  H   ALA A 431       8.674  16.036  12.858  1.00  0.00           H
cTER    4151      ALA A 431
c
cATOM   1403  O   PRO P   2      12.701  33.564  15.827  1.09 18.03           O
cATOM   1404  CB  PRO P   2      13.512  32.617  18.642  1.09  9.32           C
cATOM   1405  CG  PRO P   2      12.828  33.382  19.740  1.09 12.23           C
cATOM   1406  CD  PRO P   2      12.324  34.603  18.985  1.09 11.47           C
cHETATM 1407  CA  BLE P   1      14.625  32.240  14.151  1.09 16.76           C
cHETATM 1408  CB  BLE P   1      15.610  33.091  13.297  1.09 16.56           C
cHETATM 1409  CG  BLE P   1      15.558  34.629  13.373  1.09 14.27           C
cHETATM 1410  CD1 BLE P   1      16.601  35.208  12.440  1.09 14.75           C
cHETATM 1411  CD2 BLE P   1      14.209  35.160  12.930  1.09 15.60           C
cHETATM 1412  N   BLE P   1      14.777  32.703  15.531  1.09 14.79           N
cHETATM 1413  B   BLE P   1      14.921  30.655  14.194  1.09 15.56           B
cHETATM 1414  O1  BLE P   1      14.852  30.178  12.832  1.09 16.10           O
cHETATM 1415  O2  BLE P   1      13.775  30.147  14.862  1.09 20.95           O
cTER    1416      BLE P   1
C -----------------------------------
      END     

C ******
      SUBROUTINE RDATOM(LINE,REC,NOSPGR_INPUT,CELL_INPUT
     *                            ,PROG_NAME,ACODE,HFLAG_REMOVE)
C -------------------------------------------------------
C -P- RDATOM - reads record ATOM/HETATOM from PDB_file.
C -S-
C -------------------------------------------------------
      CHARACTER LINE*(*),REC*(*),PROG_NAME*1,HFLAG_REMOVE*1
      INTEGER   NOSPGR_INPUT
      REAL      CELL_INPUT(6)
C ******
      COMMON/STTCREC/ ICEND,JEND,ICH0,ICOMPND,IOCC,ICRST,IDNA,IHNTO
     *               ,ISCL,ISPGR,IRD_CRD,KEND_STTC,STR,FATOM
      INTEGER*4 ICEND,JEND,ICH0,ICOMPND,IOCC,ICRST,IDNA,IHNTO,ISCL
      INTEGER*4 IRD_CRD,ISPGR,KEND_STTC
      CHARACTER STR*256,FATOM*5
C --
      COMMON/COM_RDAT/ CP_OXT,CP_OXT_OLD
      CHARACTER        CP_OXT*1,CP_OXT_OLD*1
C ------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      INTEGER*4 IA,NOSPGR,ISETT
      REAL      Y(3)
      CHARACTER PNUM*12,TYPE1*1,TYPE2*1,SGNAME*24,CH5*5,SEG*4,CH4*4
      CHARACTER FRMT*80,ANAME*4,RNAME*3,ASYMB*4,CTYPE*4,ACODE*4
      character mon3*3
      DATA FRMT/'(6X,A5,A1,A4,A1,A3,A7,3X,3F8.3,2F6.2,6X,A4,A4)'/
C     DATA FRMT/'(6X,I5,A1,A4,A1,A3,A7,3X,3F8.3,2F6.2,10X,A4)'/

c1234567890123456789012345678901234567890123456789012345678901234567890123456789
cATOM   4150  H   ALA A 431       8.674  16.036  12.858  1.00  0.00           H
c      123451123411231234567   123456781234567812345678123456123456          123
CATOM      1  N   ASP A   1      45.161  12.836   9.159  1.00 30.09      2SAR  8


C ------------------------------------
      PI    = 4.0*ATAN(1.0)
C     PI180 = PI/180.0
      ASYMB = '    '
      MDOC  = 1

      READ(LINE,FRMT)
     *  CH5,CR_CORR,ANAME,CR_ALT,mon3,PNUM(1:7)
     * ,CR_XYZ(1),CR_XYZ(2),CR_XYZ(3),CR_OCC,CR_BISO,CH4,ACODE
      rname = trim(adjustl(mon3))
C      READ(LINE,FRMT)
C     *  IA,CR_CORR,ANAME,CR_ALT,RNAME,PNUM
C     * ,CR_XYZ(1),CR_XYZ(2),CR_XYZ(3),CR_OCC,CR_BISO,ACODE
      CALL LENSTR_BL(LINE,LEN_INPUT)
C ---
C   22.05.03 
      
C ---
c      IF(PNUM(7:7).EQ.'''') PNUM(7:7)='"'
c      IF(PNUM(7:7).EQ.'#')  PNUM(7:7)='*'
c      CALL CHKSMB(PNUM(7:7),TYPE1)              
c      IF(TYPE1.EQ.'D') PNUM(7:7) = '?'

c      IF(PNUM(2:2).EQ.'''') PNUM(2:2)='"'
c      IF(PNUM(2:2).EQ.'#')  PNUM(2:2)='*'
      PNUM(8:12) = '     '

      
      IF(CR_SEGFLAG.EQ.'Y'.AND.LEN_INPUT.LE.72) THEN
        CR_SEGFLAG = 'N'
      ENDIF

      CR_SEG = ' '
      SEG    = ' '
      IF(CR_SEGFLAG.EQ.'Y'.OR.LEN_INPUT.GT.72) THEN
        CALL LENSTR_BL(CH4,LEN)
        SEG = '    '
        IF(LEN.GT.1) THEN
          II = 0
          IFIRST = 0
          SEG = '    '
          DO I=1,LEN
            IF(CH4(I:I).NE.' '.OR.IFIRST.GT.0) THEN
              II = II + 1
              SEG(II:II) = CH4(I:I)
              IFIRST = 1
            ENDIF
          ENDDO
        ELSE if(len.eq.1) then
          SEG(1:1) = CH4(1:1)
       else
          seg = ' '
        ENDIF

        IF(CR_SEGFLAG.EQ.'Y') THEN
          PNUM(8:11)  = SEG
          PNUM(12:12) = ' '
          CR_SEG      = '.'
        ELSE
          CALL LENSTR_BL(SEG,LEN)
          IF(LEN.LE.0) SEG(1:1) = '.'
          CR_SEG = SEG
          IF(CR_SEG(1:1).EQ.'_') CR_SEG(1:1) = '|'
        ENDIF
      ENDIF

      IF(CR_ALT .EQ.'''') CR_ALT  = '"'
      IF(CR_ALT .EQ.'#')  CR_ALT  = '*'

      FATOM(1:4) = ANAME
      FATOM(5:5) = CR_ALT

      IF(IRD_CRD.EQ.0) THEN
        CP_OXT = 'N'

        IF(ICRST.EQ.0.AND.CELL_INPUT(1).LT.1.0) THEN
          CALL MSGDOC(MDOC,
     *    ' WARNING: "CRYST1" card is absent in input PDB file')
          CALL MSGDOC(MDOC,'          Default: 100,100,100,90,90,90')
          ISCL = 0
          DO I=1,3
            CS_CELL(I) = 100.0
          ENDDO
          CS_CELL(4) = PI/2.0
          CS_CELL(5) = PI/2.0
          CS_CELL(6) = PI/2.0
          CR_NSYM  = 1
          CS_NSYM  = CR_NSYM
          CR_NSPGR = 1
          CS_NSPGR = CR_NSPGR
          CR_SETT  = 1
          CS_SETT  = CR_SETT
          CR_SPGR  = 'P 1'
          CS_SPGR  = 'P 1'
          
        ELSE IF(ICRST.LT.0) THEN
          ISCL = 0
        ENDIF

        IF(ISCL.EQ.0.AND.CELL_INPUT(1).LT.1.0) THEN
          CALL MSGDOC(MDOC,
     *    ' WARNING: "SCALE" card is absent in input PDB file')
        ENDIF

        CALL NB_FRORTH(CS_CELL(1),CS_CELL(2),CS_CELL(3)
     *             ,CS_CELL(4),CS_CELL(5),CS_CELL(6)
     *             ,CS_FRAC_TO_ORT,CS_ORT_TO_FRAC,IERR)

        IF(ISCL.LE.0) THEN
          DO I=1,3
            DO J=1,3
              CS_SCALE(I,J) = CS_ORT_TO_FRAC(I,J)
            ENDDO
            CS_U(I) = 0.0
          ENDDO
        ENDIF
        IF(ISPGR.EQ.0.AND.NOSPGR_INPUT.NE.0) THEN

          NOSPGR = NOSPGR_INPUT
          ISETT  = 1
          SGNAME = ' '
          write(*,*)'Are were here ?'
          stop
          CALL GET_SYMM_NB_NEW(MDOC,NOSPGR,ISETT,SGNAME
     *    ,CS_NSYM,CS_M_CS,CS_V_CS,MAXNSO,IERR)

          IF(IERR.GT.0) RETURN
          IF(IERR.LT.0) RETURN

          CR_NSYM  = CS_NSYM
          CR_NSPGR = NOSPGR
          CS_NSPGR = CR_NSPGR
          CR_SETT  = ISETT  
          CS_SETT  = CR_SETT
          CALL LENSTR_BL(SGNAME,LENR)
          CR_SPGR  = SGNAME(1:LENR)
          CS_SPGR  = SGNAME(1:LENR)
           
          ISPGR = 1
        ENDIF
        IRD_CRD = 1
      ENDIF

      IF(ISCL.GT.0) THEN
        CALL NB_MVMULT(CS_SCALE,CR_XYZ,Y)
        Y(1) = Y(1) + CS_U(1)
        Y(2) = Y(2) + CS_U(2)
        Y(3) = Y(3) + CS_U(3)
        CALL NB_MVMULT(CS_FRAC_TO_ORT,Y,CR_XYZ)
      ENDIF

      IF(RNAME.EQ.'   ') THEN
        CALL MSGDOC(MDOC,
     * ' WARNING: residue name is empty, default is "HOH"')
        RNAME='HOH'
      ENDIF

C      CR_IATOLD      = IA
C ---
C   22.05.03 
      CR_IATOLD      = 0     
C ---

      CR_MULT_FACTOR = 1
      CR_FSC         = 'N'
      CR_FSA         = 'N'
      CR_B_FLAG      = 0
      CR_BTYPE       = 'I'
      IF(CR_CORR.EQ.' ') CR_CORR = '.'
      IF(CR_ALT .EQ.' ') CR_ALT  = '.'
      CR_RNAME_PDB   = RNAME


      IF(CR_OCC.GT.1.0) THEN
        IF(IOCC.LE.0) THEN
          CALL MSGDOC(MDOC,' WARNING: occupancy > 1.0')
          CALL MSGDOC(MDOC,'          program set occupancy = 1.0')
          IOCC=1
        ENDIF 
        CR_OCC=1.0
      ENDIF

      IF(ANAME(1:1).EQ.'#') ANAME(1:1) = '_'
      IF(ANAME(2:2).EQ.'#') ANAME(2:2) = '_'
      IF(ANAME(3:3).EQ.'#') ANAME(3:3) = '_'
      IF(ANAME(4:4).EQ.'#') ANAME(4:4) = '_'

      CR_ANAME_INP = ANAME
      IF(CR_ANAME_INP(1:1).EQ.' ') THEN
        CR_ANAME_INP(1:1) = ANAME(2:2)
        CR_ANAME_INP(2:2) = ANAME(3:3)
        CR_ANAME_INP(3:3) = ANAME(4:4)
        CR_ANAME_INP(4:4) = '_'
        IF(CR_ANAME_INP(3:3).EQ.' ') CR_ANAME_INP(3:3) = '_'
        IF(CR_ANAME_INP(2:2).EQ.' ') CR_ANAME_INP(2:2) = '_'
      ENDIF
      CALL CORR_NAME_PDB(ANAME,RNAME,ASYMB,CTYPE)
c      CR_ANAME_INP = ANAME

      CALL CHKSMB(ACODE(1:1),TYPE1)
      CALL CHKSMB(ACODE(2:2),TYPE2)

      IF(TYPE1.NE.'D'.AND.TYPE2.NE.'D'.AND.TYPE2.NE.'B'.AND.
     *  LEN_INPUT.GE.77) THEN
        IF(LEN_INPUT.GE.80) THEN
          CALL CHKSMB(ACODE(3:3),TYPE1)
          CALL CHKSMB(ACODE(4:4),TYPE2)
          IF(TYPE2.EQ.'S'.AND.TYPE1.EQ.'D') THEN         
            TYPE1      = ACODE(3:3)
            ACODE(3:3) = ACODE(4:4)
            ACODE(4:4) = TYPE1 
          ENDIF 
          CALL CHKSMB(ACODE(3:3),TYPE1)
          CALL CHKSMB(ACODE(4:4),TYPE2)
          IF(TYPE1.EQ.'S'.AND.TYPE2.EQ.'D') THEN         
            IF(ACODE(4:4).EQ.'0') THEN
              ACODE(3:3) = ' '
              ACODE(4:4) = ' ' 
            ENDIF
          ENDIF 
        ENDIF
        IF(ACODE(1:1).EQ.' ') THEN
          ACODE = ACODE(2:4)//' '
        ENDIF
        IF(ACODE(2:2).EQ.' ') THEN
          ACODE(2:4) = ACODE(3:4)//' '
          IF(ACODE(2:2).EQ.' ') ACODE(2:4) = ACODE(3:4)//' '
        ENDIF
        CALL CHKSMB(ACODE(1:1),TYPE1)
        IF(TYPE1.EQ.'D'.OR.TYPE1.EQ.'B') ACODE = ' '
C       ASYMB = ACODE
        IT = 1
C
C       IT = 1  convert symbols to upper case.
C                   
        CALL CHECK_LINE(IT,ACODE)
         
      ELSE
        ACODE = ' '
      ENDIF

      CR_ANAME = ANAME
      CR_ASYMB = ASYMB

      IF(HFLAG_REMOVE.EQ.'Y'.AND.ASYMB.EQ.'H   ') THEN
        REC = '?'
        RETURN
      ENDIF

      IF(PROG_NAME.EQ.'M') THEN

      ELSE
        IF(ACODE(1:1).EQ.' ') ACODE = ASYMB
      ENDIF
         
      CR_ATYPE = CTYPE(1:1)

      PNUM(1:1) = PNUM(2:2)
      PNUM(2:2) = ' '

      IF(CR_SEGFLAG.EQ.'Y') THEN
        PNUM(1:1) = PNUM(8:8)
        PNUM(2:2) = ' '
      ELSE
        PNUM(8:8)  = PNUM(1:1)
        PNUM(9:12) = '    '
      ENDIF

      IF(REC(1:6).NE.LINE(1:6).AND.REC(1:6).NE.'ATOM  ') THEN

        ICH0 = ICH0+1
        IF(ICH0.GT.9) ICH0 = 0

      ELSE IF(LINE(1:6).EQ.'HETATM'.AND.
     *     CR_PNUM(3:7).NE.PNUM(3:7))THEN
  
        IF((RNAME.NE.'HOH'.AND.RNAME.NE.'DOD'.AND.RNAME.NE.'DUM').OR.
     *      CR_RNAME.NE.RNAME) THEN
          ICH0 = ICH0+1
          IF(ICH0.GT.9) ICH0 = 0
        ELSE IF((RNAME.EQ.'HOH'.OR.RNAME.EQ.'DOD'.OR.
     *           RNAME.EQ.'DUM').AND.
     *          (CR_RNAME.EQ.'HOH'.OR.CR_RNAME.EQ.'DOD'.OR.
     *           CR_RNAME.EQ.'DUM')) THEN

          IF(CR_SEGFLAG.EQ.'Y') THEN
            IF(PNUM(8:11).NE.CR_PNUM(8:11)) THEN
              ICH0 = ICH0 + 1
              IF(ICH0.GT.9) ICH0 = 0
            ENDIF
          ELSE
            IF(PNUM(1:1).NE.CR_PNUM(1:1)) THEN
              ICH0 = ICH0 + 1
              IF(ICH0.GT.9) ICH0 = 0
            ENDIF
          ENDIF
        ENDIF

      ELSE IF(LINE(1:6).EQ.'ATOM  '.AND.IHNTO.EQ.1) THEN

        ICH0 = ICH0 + 1
        IF(ICH0.GT.9) ICH0 = 0

      ELSE

        IF((RNAME.EQ.'HOH'.OR.RNAME.EQ.'DOD'.OR.RNAME.EQ.'DUM').AND.
     *     (CR_RNAME.NE.'DOD'.AND.CR_RNAME.NE.'HOH'.AND.
     *      CR_RNAME.NE.'DUM')) THEN
          ICH0 = ICH0 + 1
          IF(ICH0.GT.9) ICH0 = 0
        ELSE IF((RNAME.EQ.'HOH'.OR.RNAME.EQ.'DOD'.OR.
     *           RNAME.EQ.'DUM').AND.
     *          (CR_RNAME.EQ.'HOH'.OR.CR_RNAME.EQ.'DOD'.OR.
     *           CR_RNAME.EQ.'DUM')) THEN
          IF(CR_SEGFLAG.EQ.'Y') THEN
            IF(PNUM(8:11).NE.CR_PNUM(8:11)) THEN
              ICH0 = ICH0 + 1
              IF(ICH0.GT.9) ICH0 = 0
            ENDIF
          ELSE
            IF(PNUM(1:1).NE.CR_PNUM(1:1)) THEN
              ICH0 = ICH0 + 1
              IF(ICH0.GT.9) ICH0 = 0
            ENDIF
          ENDIF

        ENDIF

      ENDIF

      CR_RNAME = RNAME

      WRITE(PNUM(2:2),'(I1)') ICH0

      IF(CR_SEGFLAG.EQ.'Y') THEN
        PNUM(12:12) = PNUM(2:2)
      ELSE
        PNUM(9:9) = PNUM(2:2)
      ENDIF

      CR_PNUM = PNUM

      IF(ANAME.EQ.'OXT ') CP_OXT = 'Y'

      IHNTO = 0
c      IF(LINE(1:6).EQ.'HETATM') IHNTO = 1

      REC='ATOM  '

      RETURN
      END


C ******
      SUBROUTINE CP_CRD(MDOC,IC_FLAG,IR_FLAG,IDELTA,ACODE,LIST,IERR)
C -----------------------------------------------
C -P- CP_CRD - copy information from /CRD.../ to /ATOM.../ 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------------------------------
C ******
      COMMON/STTCREC/ ICEND,JEND,ICH0,ICOMPND,IOCC,ICRST,IDNA,IHNTO
     *               ,ISCL,ISPGR,IRD_CRD,KEND_STTC,STR,FATOM
      INTEGER*4 ICEND,JEND,ICH0,ICOMPND,IOCC,ICRST,IDNA,IHNTO,ISCL
      INTEGER*4 IRD_CRD,ISPGR,KEND_STTC
      CHARACTER STR*80,FATOM*5
      COMMON/CONT_COM/ N_PROT,N_DNA,N_SUG
C -----------------------------------
      INCLUDE 'link_com.fh'
C -----------------------------------
C ---
c     CHARACTER CHAR2*2,CHAR4*4,ACODE*4
      CHARACTER LINE*256
C     CHARACTER CODE6*6,PCODE1*6,PCODE2*6
      CHARACTER CODE6*10,PCODE1*10,PCODE2*10
      CHARACTER CHAR6*6,ATOM*4,CHAR4*4,CHAR4E*4
      CHARACTER PATOM1*5,PATOM2*5,CATOM*5
      CHARACTER CATOM1*5,CATOM2*5
      CHARACTER RES*3,RES1*3,RES2*8,TYPE*1,ELEMENT*4,ACODE*4,LIST*1
C -----------------------------------
      PI    = 4.0*ATAN(1.0)
      CONST = 8.0*PI*PI
      IERR  = 0

      IF(IC_FLAG.EQ.1) THEN

        N_GROUP = N_GROUP + 1
        IF(N_GROUP.GE.MAXCHAIN) THEN
          WRITE(LINE
     *    ,'('' ERROR: number of chains >'',I6)') MAXCHAIN
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *      '        Change parameter MAXCHAIN in "atom_com.fh"')
          IERR=1
          RETURN
        ENDIF

        IRES_FIRST  (N_GROUP) = N_RESIDUE + 1
        NRES_CHAIN  (N_GROUP) = 0          
        CHAIN_ID    (N_GROUP) = CR_PNUM(8:11)
        NATM_CHAIN  (N_GROUP) = 0
        ITERM_S_TYPE(N_GROUP) = 1
        ITERM_F_TYPE(N_GROUP) = 1
        ICH_TYPE    (N_GROUP) = 1

        ICHAIN_GRP  (N_GROUP) = N_GROUP
        IATOM_FIRST (N_GROUP) = N_ATOM + 1
        I_NCS       (N_GROUP) = 0
        NCS_FLAG    (N_GROUP) = '.'
        GROUP_ID    (N_GROUP) = CR_PNUM(8:11)

      ENDIF

      IF(IR_FLAG.EQ.1) THEN
        IF(N_RESIDUE.GE.MAXRESID) THEN
          WRITE(LINE
     *    ,'('' ERROR: number of monomers  >'',I6)') MAXRESID
          CALL MSGERR(MDOC,LINE)
          CALL MSGERR(MDOC,
     *      '        Change parameter MAXRESID in "atom_com.fh"')
          IERR=1
          RETURN
        ENDIF 

        N_RESIDUE = N_RESIDUE + 1

        N_PROT = 0
        N_DNA  = 0
        N_SUG  = 0

        IRES_FORW(N_RESIDUE) = 0 
        IF(NRES_CHAIN(N_GROUP).EQ.0) THEN
          IRES_BACK(N_RESIDUE)     = -1   
          IRES_START_TREE(N_GROUP) = N_RESIDUE 
        ELSE
          IRES_BACK(N_RESIDUE  ) = N_RESIDUE-1 
          IRES_FORW(N_RESIDUE-1) = N_RESIDUE 
        ENDIF
        IRES_END_TREE(N_GROUP) = N_RESIDUE 

        NRES_CHAIN (N_GROUP)   = NRES_CHAIN(N_GROUP) + 1 

C       CALL SET_INI_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
        CALL GET_STANDARD_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
        IF(ITYPE.EQ.1) THEN
          CALL GET_INI_RES_TYPE(MDOC,LINE,CR_RNAME,ITYPE,IERR)
        ENDIF
        IRES_TYPE  (N_RESIDUE) = ITYPE

        IF(NRES_CHAIN(N_GROUP).LE.1) THEN
          ICH_TYPE    (N_GROUP) = 2
          ICONN_TYPE(N_RESIDUE) = 1
        ELSE
          ICH_TYPE    (N_GROUP) = 10
          IF(ITYPE.EQ.3) THEN
            ICONN_TYPE(N_RESIDUE) = 2
            IF(RES_NAME(N_RESIDUE).EQ.'PRO'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'5HP'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'DPR'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'PCA'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'PRO-D'.OR.
     *         RES_NAME(N_RESIDUE).EQ.'5HP-D'.OR.
     *         RES_NAME(N_RESIDUE).EQ.'HYP-D'.OR.
     *         RES_NAME(N_RESIDUE).EQ.'HYP'      ) 
     *         ICONN_TYPE(N_RESIDUE) = 36
            IF(RES_NAME(N_RESIDUE).EQ.'BMT'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'SAR'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'MLE'  .OR.
     *         RES_NAME(N_RESIDUE).EQ.'MVA'      ) 
     *         ICONN_TYPE(N_RESIDUE) = 38
            IF(IDELTA.GT.1) ICONN_TYPE(N_RESIDUE) = 10
C           gap
            ICH_TYPE    (N_GROUP) = 3
          ELSE IF(ITYPE.EQ.5) THEN
            ICONN_TYPE(N_RESIDUE) = 4
            IF(IDELTA.GT.1) ICONN_TYPE(N_RESIDUE) = 10
C           gap
            ICH_TYPE    (N_GROUP) = 5
          ELSE IF(ITYPE.EQ.7) THEN
C           ICONN_TYPE(N_RESIDUE) = 11
            ICH_TYPE    (N_GROUP) = 7
          ENDIF
        ENDIF
        IF(CR_RNAME.EQ.'HOH'.OR.CR_RNAME.EQ.'DOD'.OR.
     *     CR_RNAME.EQ.'DUM') THEN
          ICH_TYPE(N_GROUP)     = 9
          ICONN_TYPE(N_RESIDUE) = 1
        ENDIF

        IRES_SERIAL (N_RESIDUE) = CR_IRES
        NATM_RES    (N_RESIDUE) = 0
        IRATM_FIRST (N_RESIDUE) = N_ATOM+1
        MOD_FLAG    (N_RESIDUE) = 'N'
        LINK_FLAG   (N_RESIDUE) = 'N'
        I_CHAIN     (N_RESIDUE) = N_GROUP
        RES_NAME    (N_RESIDUE) = CR_RNAME
        RES_NAME_PDB(N_RESIDUE) = CR_RNAME_PDB

        WRITE(CHAR6,'(I6)') CR_IRES

C        WRITE(CHAR2,'(I2)') N_GROUP
CCC      IF(CHAR2(2:2).EQ.'0') CHAR2(1:1) = '.'
C        CHAR2(1:1) = CR_PNUM(1:1)
C        RES_NUM_PDB (N_RESIDUE) = CHAR2//CR_PNUM(3:7)
        RES_NUM_PDB (N_RESIDUE) = CR_PNUM

      ENDIF 

      IF(N_ATOM.GE.MAXATOM) THEN
        WRITE(LINE
     *  ,'('' ERROR: number of atoms  >'',I6)') MAXATOM
        CALL MSGERR(MDOC,LINE)
        CALL MSGERR(MDOC,
     *      '        Change parameter MAXATOM in "atom_com.fh"')
        IERR=1
        RETURN
      ENDIF 

      N_ATOM              = N_ATOM + 1
C ---
C  22.05.03
      CR_IATOLD           = N_ATOM 
C ---
      I_ATOLD  (N_ATOM)   = CR_IATOLD
      NATM_CHAIN(N_GROUP) = NATM_CHAIN(N_GROUP) + 1
      NATM_RES(N_RESIDUE) = NATM_RES(N_RESIDUE) + 1
      I_RESID(N_ATOM)     = N_RESIDUE

      ATOM = CR_ANAME 
C       P -> O5* - C5*  - C4* = C3* -> O3*
      IF(ATOM.EQ.'O4* '.OR.ATOM.EQ.'O5* '.OR.ATOM.EQ.'C5* '.OR.
     *   ATOM.EQ.'C4* '.OR.ATOM.EQ.'C3* '.OR.ATOM.EQ.'O3* '.OR.
     *   ATOM.EQ.'C1* '.OR.ATOM.EQ.'C2* '                      ) THEN
        N_DNA = N_DNA + 1
      ELSE IF(ATOM.EQ.'C1  '.OR.ATOM.EQ.'C2  '.OR.ATOM.EQ.'C3  '.OR.
     *   ATOM.EQ.'C4  '.OR.ATOM.EQ.'C5  '.OR.ATOM.EQ.'O5  '    ) THEN
C       C1 -> C2 -> C3 -> C4 -> C5 -> O5
        N_SUG = N_SUG + 1
      ELSE IF(ATOM.EQ.'N   '.OR.ATOM.EQ.'CA  '.OR.ATOM.EQ.'C   '.OR.
     *        ATOM.EQ.'O  '                                    ) THEN
C         N -> CA -> C
        N_PROT = N_PROT + 1
      ENDIF

      IF(N_DNA.GE.8) THEN
c?        IF(IRES_TYPE(N_RESIDUE).LE.2) IRES_TYPE(N_RESIDUE) = 5
      ELSE IF(N_SUG.GE.6) THEN
c?        IF(IRES_TYPE(N_RESIDUE).LE.2) IRES_TYPE(N_RESIDUE) = 7
      ELSE IF(N_PROT.GE.4) THEN
c?        IF(IRES_TYPE(N_RESIDUE).LE.2) IRES_TYPE(N_RESIDUE) = 3
      ENDIF

      IF(IRES_TYPE(N_RESIDUE).EQ.6.OR.IRES_TYPE(N_RESIDUE).EQ.5) THEN
        IF(CR_ANAME.EQ.'OXT ') THEN
          CR_ANAME = 'OP3 '
          CALL MSGDOC(MDOC,
     *    ' WARNING : for DNA/RNA atom "OXT " --> "OP3 " (default)')
        ENDIF
        IF(CR_ANAME.EQ.'O3P '.or.CR_ANAME.eq.'O3T ') THEN
          CR_ANAME = 'OP3 '
          CALL MSGDOC(MDOC,
     *    ' WARNING : for DNA/RNA atom "O3P " --> "OP3 " (default)')
        ENDIF
        IF(CR_ANAME.EQ.'O3G ') THEN
          CR_ANAME = 'OP3 '
          CALL MSGDOC(MDOC,
     *    ' WARNING : for DNA/RNA atom "O3G " --> "OP3 " (default)')
        ENDIF
        IF(CR_ANAME.EQ.'OP3 ') ITERM_S_TYPE(N_GROUP) = 4
      ELSE IF(IRES_TYPE(N_RESIDUE).EQ.3.OR.
     *        IRES_TYPE(N_RESIDUE).EQ.4    ) THEN
        IF(CR_ANAME.EQ.'OXT ') ITERM_F_TYPE(N_GROUP) = 2
      ENDIF

      ATM_NAME (N_ATOM)   = CR_ANAME
      ATM_NAME_INP(N_ATOM)= CR_ANAME_INP
      ATM_CHEM(N_ATOM)    = '.'
C
C     ATM_TYPE (N_ATOM)   = CR_ATYPE
C                           H,C,$   
C
      ATM_TYPE (N_ATOM)   = '.'

      B_FLAG   (N_ATOM)   = CR_B_FLAG

      MULT_FACTOR(N_ATOM) = CR_MULT_FACTOR
      DO   I=1,3
        XYZ_CRD(I,N_ATOM) = CR_XYZ(I)
      ENDDO
C
C     B_ISO    (N_ATOM)   = CR_BISO
C
      DO I = 1,6
        U_ANISO(I,N_ATOM) = 0.0
      ENDDO
      U_ANISO(1,N_ATOM)   = CR_BISO/CONST

      OCCUP    (N_ATOM)   = CR_OCC
      

      IF(CR_B_FLAG.EQ.1) THEN 
        N_ANISO        = N_ANISO + 1
        B_FLAG(N_ATOM) = N_ATOM
        DO I = 1,6
         U_ANISO(I,N_ATOM) = CR_ANIS(I)
        ENDDO
      ENDIF

      ID_ALT (N_ATOM) = CR_ALT
      ID_CORR(N_ATOM) = CR_CORR
      SEG_ID(N_ATOM)  = CR_SEG

      IF(CR_PNUM(7:7).NE.' '.AND.CR_PNUM(7:7).NE.'.') OUT_CIF_INS =0
      IF(CR_CORR.NE.' '     .AND.CR_CORR.NE.'.'     ) OUT_CIF_CORR=0
      IF(CR_MULT_FACTOR.NE.1.AND.CR_MULT_FACTOR.NE.1) OUT_CIF_MULT=0

      ID_SF(N_ATOM)   = 0
      INSF            = 0
      
C --
      ELEMENT = ACODE
      IF(ACODE.EQ.' ') ELEMENT = '?'

C     ELEMENT = CR_ASYMB

      IF(ACODE.NE.' ') THEN
        CALL CHKSMB(CR_ASYMB(2:2),TYPE)
        IF(TYPE.EQ.'D'.OR.TYPE.EQ.'S') CR_ASYMB(2:2) = ' '
        CR_ASYMB(3:3) = ' '
        CR_ASYMB(4:4) = ' '
        CALL CHKSMB(ACODE(2:2),TYPE) 
        IF(TYPE.EQ.'D'.OR.TYPE.EQ.'S') ACODE(2:2) = ' '
        ACODE(3:3) = ' '
        ACODE(4:4) = ' '
        IF(ACODE.NE.CR_ASYMB) CR_ASYMB = ACODE
      ENDIF

      IF(CS_NSFATM.GT.0) THEN
        DO ISF=1,CS_NSFATM
          CHAR4E = CS_ELEMENT(ISF)
          CHAR4  = CS_ATYPE(ISF)
          IF(CHAR4.EQ.CR_ASYMB.AND.CHAR4E.EQ.ELEMENT) THEN
            INSF = ISF
            GO TO 200
          ENDIF
        ENDDO
      ENDIF

      IF(CS_NSFATM.GE.MAXNSF) THEN
        CALL MSGERR(MDOC
     *  ,' ERR: number of atomic scattering types > limit.')
        CALL MSGERR(MDOC
     *  ,'      change parameter MAXNSF')
        IERR=1
        RETURN
      ENDIF

      CS_NSFATM        = CS_NSFATM + 1
      INSF             = CS_NSFATM
      CS_ATYPE(INSF)   = CR_ASYMB 
      CS_ELEMENT(INSF) = ELEMENT 
      IF(ACODE.EQ.' ') CS_ELEMENT(INSF) = '?'
C --

 200  CONTINUE

      ID_SF(N_ATOM)  = INSF

      ITYPE = IRES_TYPE(N_RESIDUE)
      IF(ITYPE.EQ.5.AND.(CR_ANAME.EQ.'O2* '.or.
     &   cr_aname.eq.'O2'' ').AND.
     *   CR_RNAME(1:1).NE.'U') THEN
        IRES_TYPE  (N_RESIDUE) = 6
      ENDIF

      IF(NSS_PDB.GT.0) THEN

        DO ISS=1,NSS_PDB

          CODE6(1:1)  = CR_PNUM(1:1)  
          CODE6(2:6)  = CR_PNUM(3:7)
          CODE6(7:10) = CR_PNUM(8:11)
          IF(CR_SEGFLAG.NE.'Y') THEN
            CODE6(8:8) = ' '
          ENDIF
          PATOM1     = NSS_CODE1(ISS)(7:11)
          PATOM2     = NSS_CODE2(ISS)(7:11)
          PCODE1     = NSS_CODE1(ISS)(1:6)//NSS_CODE1(ISS)(12:15)
          PCODE2     = NSS_CODE2(ISS)(1:6)//NSS_CODE2(ISS)(12:15)
          RES1       = NSS_RES1 (ISS)
          RES2       = NSS_RES2 (ISS)
          
          CATOM      = CR_ANAME
          RES        = CR_RNAME(1:3)
          
C     code:
C      1         covalent bonds IC1,IC2,IC3,IC4
C      2         salt bridges   IC5 ( I has an excess of negative charge)
C      3         salt bridges   IC6 ( I has an excess of positive charge)
C      4         hydrogen bond  IC7 ( I acts as donor)
C      5         hydrogen bond  IC8 ( I acts as acceptor)
C
C      6         SS bridges
C      7         CIS
C      8         link
C      9         gap
C     10         modification


          IF(LIST.EQ.'T') THEN
c            write(*,*) 'iss:',iss,'>>',CATOM,'><',CR_ALT,'>'
          ENDIF

          CATOM1 = CATOM
          CATOM2 = CATOM

          IF(NSS_C(ISS).GE.6.OR.NSS_C(ISS).LE.8) THEN
            IF(CATOM(1:1).EQ.' ') THEN
              CATOM(1:1) = CATOM(2:2)
              CATOM(2:2) = CATOM(3:3)
              CATOM(3:3) = CATOM(4:4)
              CATOM(4:4) = ' '
            ENDIF         

            CATOM(5:5) = ' '
            IF(CR_ALT.NE.'.') CATOM(5:5) = CR_ALT

            CATOM1 = CATOM
            CATOM2 = CATOM

            IF(NSS_C(ISS).EQ.6) THEN
C              RES1   = 'CYS'
C              RES2   = 'CYS'
C              RES    = CR_RNAME(1:3)
              RES1   = '   '
              RES2   = '   '
              RES    = '   '
              CATOM1(5:5) = ' '
              CATOM2(5:5) = ' '
            ELSE IF(NSS_C(ISS).EQ.7) THEN
              RES1   = '   '
              RES2   = '   '
              RES    = '   '
            ELSE IF(NSS_C(ISS).EQ.8) THEN

              IF(PATOM1(1:1).EQ.' ') CATOM1 = ' '
              IF(PATOM2(1:1).EQ.' ') CATOM2 = ' '

              IF(PATOM1(5:5).EQ.' ') CATOM1(5:5) = ' '
              IF(PATOM2(5:5).EQ.' ') CATOM2(5:5) = ' '

            ENDIF
          ENDIF

          IF(NSS_C(ISS).EQ.9) THEN
            CATOM1  = ' '
            CATOM2  = ' '
            PATOM1 = ' '
            PATOM2 = ' '
            RES1   = ' '
            RES2   = ' '
            RES    = ' '
          ENDIF


          IF(NSS_C(ISS).EQ.10) THEN
            CATOM1 = ' '
            CATOM2 = ' '
            PATOM1 = ' '
            PATOM2 = ' '
            PCODE2 = '?'
            RES1   = NSS_RES1(ISS)
            RES2   = ' '
          ENDIF

          IF(LIST.EQ.'T') THEN
c            write(*,*) iss,'CC<',PCODE1,'><',PCODE2,'><',CODE6,'><'
c     *      ,RES1,'><',RES2,'><',RES,'><'
c     *      ,PATOM1,'><',PATOM2,'><',CATOM1,'><',CATOM2,'>'
          ENDIF

          IF(PCODE1.EQ.CODE6.AND.
     *       RES.EQ.RES1    .AND.CATOM1.EQ.PATOM1) THEN
            NSS_1(ISS) = N_ATOM
          ENDIF

          IF(PCODE2.EQ.CODE6.AND.
     *        RES.EQ.RES2(1:3).AND.CATOM2.EQ.PATOM2) THEN
            NSS_2(ISS) = N_ATOM
          ENDIF

          IF(LIST.EQ.'T') THEN
c            write(*,*) '==',ISS,NSS_1(ISS),NSS_2(ISS),N_ATOM,NSS_C(ISS)
          ENDIF

        ENDDO
      ENDIF

      RETURN
      END

C ******
      SUBROUTINE RDHEAD_PDB(LINE)
C -------------------------------------------------------
C -P- RDHEAD - reads record HEADER from PDB_file.
C -S-
C -------------------------------------------------------
      CHARACTER LINE*(*)
C ******
C ------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      CHARACTER FRMT*80
      DATA FRMT/'(10X,A40,A9,3X,A4)'/
C ------------------------------------
      READ(LINE,FRMT) CR_NAME_PDB,CR_DATE_PDB,CR_CD_PDB

      CALL LENSTR_BL(CR_NAME_PDB,LEN)
      IF(LEN.LE.0) THEN
        CR_NAME_PDB = '---'
        LEN = 3
      ELSE
        IF(LEN.GT.40) LEN=40
        DO I=1,LEN
          IF(CR_NAME_PDB(I:I).EQ.'''') CR_NAME_PDB(I:I) = '*'
        ENDDO
      ENDIF

      CS_NAME_PDB = CR_NAME_PDB(1:LEN)
      CR_NAME_PDB = CS_NAME_PDB

      CALL LENSTR_BL(CR_DATE_PDB,LEN)
      IF(LEN.LE.0) CR_DATE_PDB = 'XX-XXX-XX'
      CALL LENSTR_BL(CR_CD_PDB,LEN)
      IF(LEN.LE.0) CR_CD_PDB = 'XXXX'

      CS_CD_PDB   = CR_CD_PDB
      CS_DATE_PDB = CR_DATE_PDB

      RETURN
      END

      SUBROUTINE RDCOMPND(LINE)
C -------------------------------------------------------
C -P- RDCOMPND - reads record COMPND from PDB_file.
C -S-
C -------------------------------------------------------
      CHARACTER LINE*(*)
C ******
C ------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      CHARACTER FRMT*80
      DATA FRMT/'(10X,A68)'/
C ------------------------------------
      READ(LINE,FRMT) CR_TITLE

      CALL LENSTR_BL(CR_TITLE,LEN)
      IF(LEN.LE.0) THEN
        CR_TITLE = '---'
        LEN=3
      ELSE
        IF(LEN.GT.80) LEN=80
        DO I=1,LEN
          IF(CR_TITLE(I:I).EQ.'''') CR_TITLE(I:I) = '*'
        ENDDO
      ENDIF
      CS_TITLE = CR_TITLE(1:LEN)
      CR_TITLE = CS_TITLE

      RETURN
      END


      SUBROUTINE RDTITLE_PDB(LINE)
C -------------------------------------------------------
C     RDTITLE_PDB - reads record TITLE from PDB_file.
C 
C -------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C ---
      CHARACTER LINE*(*)
C -----------------------------------------------
C --------------------------------------------------------------
      CHARACTER FRMT*80
C     CHARACTER TITLE*68
      DATA FRMT/'(10X,A68)'/
C ------------------------------------
      READ(LINE,FRMT) CR_TITLE

      CALL LENSTR_BL(CR_TITLE,LEN)
      IF(LEN.LE.0) THEN
        CR_TITLE = '---'
        LEN = 3
      ELSE
        IF(LEN.GT.80) LEN=80
        DO I=1,LEN
          IF(CR_TITLE(I:I).EQ.'''') CR_TITLE(I:I) = '*'
        ENDDO
      ENDIF

      CS_TITLE = CR_TITLE(1:LEN)
      CR_TITLE = CS_TITLE

      RETURN
      END

      SUBROUTINE RDMODEL(LINE)
C -------------------------------------------------------
C -P- RDMODEL - reads record MODEL from PDB_file.
C -S-
C -------------------------------------------------------
      CHARACTER LINE*(*)
C ******
C ------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      INTEGER   MODEL
      CHARACTER FRMT*80
      DATA FRMT/'(10X,I4)'/
C ------------------------------------
      READ(LINE,FRMT) MODEL

      CR_MODEL_PDB = MODEL 
      CS_MODEL_PDB = CR_MODEL_PDB

      RETURN
      END

      SUBROUTINE RDREMARK(LINE)
C -------------------------------------------------------
C -P- RDREMARK - reads record REMARK from PDB_file.
C -S-
C -------------------------------------------------------
      CHARACTER LINE*(*)
C ******
C ------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      CHARACTER FRMT*80,CH36*36,CHAR*1,TYPE*1
      DATA FRMT/'(7X,I3,1X,A36)'/
C ------------------------------------
      CHAR=LINE(8:8)
      CALL CHKSMB(CHAR,TYPE)
      IF(TYPE.NE.'B'.AND.TYPE.NE.'D') GO TO 100
      CHAR=LINE(9:9)
      CALL CHKSMB(CHAR,TYPE)
      IF(TYPE.NE.'B'.AND.TYPE.NE.'D') GO TO 100
      CHAR=LINE(10:10)
      CALL CHKSMB(CHAR,TYPE)
      IF(TYPE.NE.'B'.AND.TYPE.NE.'D') GO TO 100

      READ(LINE,FRMT,ERR=100) I,CH36

      IF(I.EQ.2.AND.CH36(1:10).EQ.'RESOLUTION') THEN
        CR_RESL_PDB    = CH36
        CS_RESL_PDB    = CR_RESL_PDB
      ELSE IF(I.EQ.3.AND.CH36(1:10).EQ.'  R VALUE ') THEN
        CR_RFAC_PDB    = CH36
        CS_RFAC_PDB    = CR_RFAC_PDB
      ENDIF
  100 CONTINUE
      RETURN
      END

      SUBROUTINE RDHET(LINE)
C -------------------------------------------------------
C -P- RDHET - reads record HET from PDB_file.
C -S-
C -------------------------------------------------------
      CHARACTER LINE*(*)
C ******
C ------------------------------------------------------
      INCLUDE 'link_com.fh'
C -----------------------------------
c      PARAMETER ( MAXHENT  = 20 )
c      PARAMETER ( MAXSSBND = 30 )
c      COMMON /PDB_HENT/ NCONN_PDB,ICON1_PDB,ICON2_PDB,ICONC_PDB
c     *                 ,NSS_PDB,NSS_1,NSS_2
c     *                 ,NHENT,HENT_ID,HENT_NA,HENT_NAME,HENT_FORMUL
c     *                 ,NSS_CODE1,NSS_CODE2
c      INTEGER*4  NCONN_PDB
c      INTEGER*4  ICON1_PDB  (MAXATOM)
c      INTEGER*4  ICON2_PDB  (MAXATOM)
c      INTEGER*4  ICONC_PDB  (MAXATOM)
c      INTEGER*4  NSS_PDB
c      INTEGER*4  NSS_1      (MAXSSBND)
c      INTEGER*4  NSS_2      (MAXSSBND)
c      INTEGER*4  NHENT
c      INTEGER*4  HENT_NA    (MAXHENT)
c      CHARACTER  HENT_ID    (MAXHENT)*3
c      CHARACTER  HENT_NAME  (MAXHENT)*40
c      CHARACTER  HENT_FORMUL(MAXHENT)*40
c      CHARACTER  NSS_CODE1  (MAXSSBND)*6
c      CHARACTER  NSS_CODE2  (MAXSSBND)*6
C ---
      CHARACTER FRMT*80,MON*3,NAME*40
      DATA FRMT/'(7X,A3,10X,I5,5X,A40)'/
C ------------------------------------
      READ(LINE,FRMT) MON,NA,NAME

      IF(MON(1:1).EQ.' ') THEN
        MON = MON(2:3)//' '
        IF(MON(1:1).EQ.' ') MON = MON(2:3)//' '
      ENDIF

      CALL LENSTR_BL(NAME,LEN)
     
      IF(LEN.GT.0) THEN
        DO I=1,LEN
          IF(NAME(I:I).EQ.' ')  NAME(I:I) = '_'
          IF(NAME(I:I).EQ.'''') NAME(I:I) = '*'
        ENDDO 
      ELSE
        NAME = '.'
      ENDIF

      IF(NHENT.GT.0) THEN
        DO I=1,NHENT
          IF(HENT_ID(I).EQ.MON) RETURN
        ENDDO
      ENDIF
      IF(NHENT.LT.MAXHENT) THEN
        NHENT              = NHENT+1
        HENT_ID    (NHENT) = MON 
        HENT_NA    (NHENT) = NA 
        HENT_NAME  (NHENT) = NAME 
        HENT_FORMUL(NHENT) = '.' 
      ENDIF
      RETURN
      END

      SUBROUTINE RDFORMUL(LINE)
C -------------------------------------------------------
C -P- RDFORMUL - reads record FORMUL from PDB_file.
C -S-
C -------------------------------------------------------
      CHARACTER LINE*(*)
C ******
C ------------------------------------------------------
      INCLUDE 'link_com.fh'
C -----------------------------------
c      PARAMETER ( MAXHENT  = 20 )
c      PARAMETER ( MAXSSBND = 30 )
c      COMMON /PDB_HENT/ NCONN_PDB,ICON1_PDB,ICON2_PDB,ICONC_PDB
c     *                 ,NSS_PDB,NSS_1,NSS_2
c     *                 ,NHENT,HENT_ID,HENT_NA,HENT_NAME,HENT_FORMUL
c     *                 ,NSS_CODE1,NSS_CODE2
c      INTEGER*4  NCONN_PDB
c      INTEGER*4  ICON1_PDB  (MAXATOM)
c      INTEGER*4  ICON2_PDB  (MAXATOM)
c      INTEGER*4  ICONC_PDB  (MAXATOM)
c      INTEGER*4  NSS_PDB
c      INTEGER*4  NSS_1      (MAXSSBND)
c      INTEGER*4  NSS_2      (MAXSSBND)

c      INTEGER*4  NHENT
c      INTEGER*4  HENT_NA    (MAXHENT)
c      CHARACTER  HENT_ID    (MAXHENT)*3
c      CHARACTER  HENT_NAME  (MAXHENT)*40
c      CHARACTER  HENT_FORMUL(MAXHENT)*40

c      CHARACTER  NSS_CODE1  (MAXSSBND)*6
c      CHARACTER  NSS_CODE2  (MAXSSBND)*6
C ---
      CHARACTER FRMT*80,MON*3,FORMUL*40
      DATA FRMT/'(12X,A3,4X,A40)'/
C ------------------------------------
      READ(LINE,FRMT) MON,FORMUL

      IF(MON(1:1).EQ.' ') THEN
        MON=MON(2:3)//' '
        IF(MON(1:1).EQ.' ') MON=MON(2:3)//' '
      ENDIF

      IF(NHENT.GT.0) THEN
        DO I=1,NHENT
          IF(HENT_ID(I).EQ.MON)  GO TO 100
        ENDDO
      ENDIF
      RETURN
      
 100  CONTINUE
     
      HENT_FORMUL(I) = FORMUL 

      RETURN
      END

      SUBROUTINE RDCRYST1(LINE,NOSPGR_INPUT)
C -------------------------------------------------------
C -P- RDCRYST1 - reads record CRYST1 from PDB_file.
C -S-
C -------------------------------------------------------
      INTEGER   NOSPGR_INPUT
      CHARACTER LINE*(*)
C ******
C ------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      COMMON/STTCREC/ ICEND,JEND,ICH0,ICOMPND,IOCC,ICRST,IDNA,IHNTO
     *               ,ISCL,ISPGR,IRD_CRD,KEND_STTC,SSTR,FATOM
      INTEGER*4 ICEND,JEND,ICH0,ICOMPND,IOCC,ICRST,IDNA,IHNTO,ISCL
      INTEGER*4 IRD_CRD,ISPGR,KEND_STTC
      CHARACTER SSTR*256,FATOM*5,CHAR11*11
C -----------------------------------
c      PARAMETER ( NWORDSMAX = 40 )
c      COMMON /COMFREAD/ FWORDS,IFRD_ERR,NWORDS,LEN_WORDS,IWORDS
c     *                 ,WORDS,IN_STRING
c      REAL      FWORDS   (NWORDSMAX)
c      INTEGER*4 LEN_WORDS(NWORDSMAX)
c      INTEGER*4 IWORDS   (NWORDSMAX)
c      INTEGER*4 NWORDS,IFRD_ERR
c      CHARACTER WORDS(NWORDSMAX)*80
c      CHARACTER IN_STRING*80
C -----------------------------------
      CHARACTER FRMT*80,SP_GR*24,CHAR24*24
      INTEGER   NOSPGR,ISETT,NSYM
      CHARACTER SGNAME*24
      CHARACTER CHAR*1,TYPE*1
      DATA FRMT/'(6X,3F9.3,3F7.2,1X,A11)'/
C ------------------------------------
      PI    = 4.0*ATAN(1.0)
      TWOPI = 2.0*PI
      PI180 = PI/180.0
      ICRST = 1
      MDOC  = 1

      READ(LINE,FRMT) CR_CELL(1),CR_CELL(2),CR_CELL(3)
     *               ,CR_CELL(4),CR_CELL(5),CR_CELL(6)
     *               ,CHAR11

      SP_GR = CHAR11

      CR_CELL(4)=CR_CELL(4)*PI180
      CR_CELL(5)=CR_CELL(5)*PI180
      CR_CELL(6)=CR_CELL(6)*PI180

      IF(CR_CELL(1).LE.1.1.OR.CR_CELL(2).LE.1.1.OR.
     *   CR_CELL(3).LE.1.1.OR.CR_CELL(4).LE.0.001.OR.
     *   CR_CELL(5).LE.0.001.OR.CR_CELL(6).LE.0.001) THEN
        CALL MSGDOC(MDOC,' WARNING: wrong CELL parameters in PDB file')
        CALL MSGDOC(MDOC,'          Default: 100,100,100,90,90,90')
        CR_CELL(1)=100.0
        CR_CELL(2)=100.0
        CR_CELL(3)=100.0
        CR_CELL(4)=PI/2.0
        CR_CELL(5)=PI/2.0
        CR_CELL(6)=PI/2.0
        ICRST = -1
      ENDIF


      CS_CELL(1) = CR_CELL(1)
      CS_CELL(2) = CR_CELL(2)
      CS_CELL(3) = CR_CELL(3)
      CS_CELL(4) = CR_CELL(4)
      CS_CELL(5) = CR_CELL(5)
      CS_CELL(6) = CR_CELL(6)
C ---

      CS_NSYMOP = 0

      IF(NOSPGR_INPUT.NE.0) THEN
        ISPGR = 1
        IND   = 0
        GO TO 610
      ENDIF

      CALL LENSTR_BL(SP_GR,LENS)

      IF(LENS.LE.0) THEN
        SP_GR = ' '
        LENS  = 0
      ELSE
        J  = 0
        NB = 0
        CHAR24 = ' '
        DO I=1,LENS
          IF(SP_GR(I:I).EQ.' ') THEN
            IF(NB.NE.0) THEN
              J = J + 1
              CHAR24(J:J) = SP_GR(I:I)
            ENDIF
          ELSE
            NB = 1
            J  = J + 1
            CHAR24(J:J) = SP_GR(I:I)
          ENDIF
        ENDDO
        SP_GR = CHAR24
        CALL LENSTR_BL(SP_GR,LENS)
      ENDIF

      IF(LENS.LT.1.OR.LENS.GT.11) THEN
        CALL MSGDOC(MDOC
     *  ,' WARNING: wrong card "CRYST1" of PDB_file.')
        CALL MSGDOC(MDOC
     *  ,'          default space group "P 1"')
        SP_GR = 'P 1'
        LENS  = 3
      ELSE
        ISPGR = 1
      ENDIF

      N = 0
      DO I=1,LENS
        IF(SP_GR(I:I).EQ.' ') N = N + 1
        IF(SP_GR(I:I).NE.' ') GO TO 600
      ENDDO

  600 CONTINUE

      IF(N.GT.0) THEN
        DO I=1,LENS-N
          SP_GR(I:I)=SP_GR(I+N:I+N)
        ENDDO
        DO I=1,N
          SP_GR(I+LENS-N:I+LENS-N)=' '
        ENDDO
      ENDIF
      CALL LENSTR_BL(SP_GR,LENS)
      IF(LENS.LT.1.OR.LENS.GT.11) THEN
        CALL MSGDOC(MDOC
     *  ,' WARNING: wrong card "CRYST1" of PDB_file')
        CALL MSGDOC(MDOC
     *  ,'          default space group "P 1"')
        CR_SPGR = 'P 1'
        LENS    = 3
        ISPGR   = 0
      ELSE
        CR_SPGR = SP_GR(1:LENS)
        ISPGR   = 1
      ENDIF
C -------
      IND=0
      DO I=1,LENS
        CHAR = CR_SPGR(I:I)
        CALL CHKSMB(CHAR,TYPE)
        IF(TYPE.NE.'B'.AND.TYPE.NE.'D') IND=1
      ENDDO

  610 CONTINUE

      IF(IND.EQ.0) THEN

        IF(NOSPGR_INPUT.NE.0) THEN
          NOSPGR = NOSPGR_INPUT 
          ISPGR  = 1
        ELSE
          READ(CR_SPGR(1:LENS),*) NOSPGR
          ISPGR = 1
        ENDIF

        ISETT  = 1

        IF(NOSPGR.EQ.146.OR.NOSPGR.EQ.155) THEN
          T= (PI*2.0)/3.0
          IF(ABS(CS_CELL(6)-T).LE.0.0001) ISETT = 2
        ENDIF
        IF(NOSPGR.GE.3.AND.NOSPGR.LE.15.AND.ISETT.EQ.1) THEN
C         ISETT = 1
          T     = PI/2.0
          IF(ABS(CS_CELL(6)-T).LE.0.0001) ISETT = 2
        ENDIF
        NSYM   = 0
        SGNAME = ' '

      ELSE

        NOSPGR = 0
        ISETT  = 1
        NSYM   = 0
        SGNAME = CR_SPGR(1:LENS)
        IF((LENS.GE.3.AND.SGNAME(1:3).EQ.'R 3').OR.
     *     (LENS.GE.2.AND.SGNAME(1:2).EQ.'R3')) THEN
          T= (PI*2.0)/3.0
          IF(ABS(CR_CELL(6)-T).LE.0.0001) THEN
            ISETT       = 2
            SGNAME(1:1) = 'H'
          ENDIF
        ENDIF

C                sett 2     sett 1
C
C 3  P 2 P2      P 1 2 1   P 1 1 2
C 4  P21 P 21    P 1 21 1  P 1 1 21
C
C 5  B2  B 2               B 1 1 2
C 5  C2  C 2     C 1 2 1
C
C 
        IF(SGNAME.EQ.'P2' .OR.SGNAME.EQ.'P 2' .OR.
     *     SGNAME.EQ.'P21'.OR.SGNAME.EQ.'P 21'.OR.
     *     SGNAME.EQ.'B2' .OR.SGNAME.EQ.'B 2' .OR.
     *     SGNAME.EQ.'C2' .OR.SGNAME.EQ.'C 2'     ) THEN
          T  = PI/2.0
          ISETT = 2
          IF(ABS(CR_CELL(6)-T).GT.0.0001.AND.
     *       ABS(CR_CELL(5)-T).LE.0.0001     ) ISETT = 1
          IF(SGNAME.EQ.'P2'.OR.SGNAME.EQ.'P 2') THEN
            IF(ISETT.EQ.1) THEN
              SGNAME = 'P 1 1 2'
            ELSE
              SGNAME = 'P 1 2 1'
            ENDIF
          ELSE IF(SGNAME.EQ.'P21'.OR.SGNAME.EQ.'P 21') THEN
            IF(ISETT.EQ.1) THEN
              SGNAME = 'P 1 1 21'
            ELSE
              SGNAME = 'P 1 21 1'
            ENDIF
          ELSE IF(SGNAME.EQ.'B2'.OR.SGNAME.EQ.'B 2'.OR.
     *            SGNAME.EQ.'C2'.OR.SGNAME.EQ.'C 2'    ) THEN
            IF(ISETT.EQ.1) THEN
              SGNAME = 'B 1 1 2'
            ELSE
              SGNAME = 'C 1 2 1'
            ENDIF
          ENDIF
        ENDIF

      ENDIF
c
c      write(*,*) '<',SGNAME,'>',NOSPGR,ISETT
c
c      CALL GET_SYMM_NB_NEW(MDOC,NOSPGR,ISETT,SGNAME
c     *    ,CS_NSYM,CS_M_CS,CS_V_CS,CS_SYMOP,MAXNSO,IERR)

      CALL GET_SYMM_NB_NEW(MDOC,NOSPGR,ISETT,SGNAME
     *    ,CS_NSYM,CS_M_CS,CS_V_CS,MAXNSO,IERR)

      IF(IERR.GT.0) RETURN
      IF(IERR.LT.0) RETURN

      CR_NSYM  = CS_NSYM
      CR_NSPGR = NOSPGR
      CS_NSPGR = CR_NSPGR
      CR_SETT  = ISETT  
      CS_SETT  = CR_SETT
      CALL LENSTR_BL(SGNAME,LENR)
      CR_SPGR  = SGNAME(1:LENR)
      CS_SPGR  = SGNAME(1:LENR)
      ISPGR = 1

      RETURN
      END

C ******
      SUBROUTINE RDSCALE(LINE)
C -------------------------------------------------------
C -P- RDSCALE - reads record SCALE1 from PDB_file.
C -S-
C -------------------------------------------------------
      CHARACTER LINE*(*)
C ******
C ------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      COMMON/STTCREC/ ICEND,JEND,ICH0,ICOMPND,IOCC,ICRST,IDNA,IHNTO
     *               ,ISCL,ISPGR,IRD_CRD,KEND_STTC,STR,FATOM
      INTEGER*4 ICEND,JEND,ICH0,ICOMPND,IOCC,ICRST,IDNA,IHNTO,ISCL
      INTEGER*4 IRD_CRD,ISPGR,KEND_STTC
      CHARACTER STR*256,FATOM*5
C -----------------------------------
      CHARACTER FRMT*80,CH1*1
      DATA FRMT/'(5X,A1,4X,3F10.6,5X,F10.5)'/
C ------------------------------------
      READ(LINE,FRMT) CH1,S1,S2,S3,U

      I = 1
      IF(CH1.EQ.'2') I = 2
      IF(CH1.EQ.'3') I = 3

      CR_SCALE(I,1) = S1
      CR_SCALE(I,2) = S2
      CR_SCALE(I,3) = S3
      CR_U(I)       = U

      CS_SCALE(I,1) = CR_SCALE(I,1)
      CS_SCALE(I,2) = CR_SCALE(I,2)
      CS_SCALE(I,3) = CR_SCALE(I,3)
      CS_U(I) = CR_U(I)

      ISCL = 1

      RETURN
      END

C ******
      SUBROUTINE RDMTRIX(LINE)
C -------------------------------------------------------
C -P- RDMTRIX - reads record MTRIX1 from PDB_file.
C -S-
C -------------------------------------------------------
      CHARACTER LINE*(*),STR*256
C ******
C ------------------------------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
      CHARACTER FRMT*80,CH1*1
      DATA FRMT/'(5X,A1,1X,I3,3F10.6,5X,F10.5,4X,I1)'/
C ------------------------------------
      READ(LINE,FRMT) CH1,ICS,S1,S2,S3,V,IGIVEN

      IF(IGIVEN.EQ.0) THEN
        I = 1
        IF(CH1.EQ.'2') I = 2
        IF(CH1.EQ.'3') I = 3

        CR_NCS        = ICS
        CR_M_NCS(I,1) = S1
        CR_M_NCS(I,2) = S2
        CR_M_NCS(I,3) = S3
        CR_V_NCS(I)   = V

        IF(ICS.GT.MAXNCS) THEN
          MDOC = 1       
          WRITE(STR
     *,'('' WARNING: number of NCS operators of PDB file  >'',I6)') 
     *    MAXNCS
          CALL MSGERR(MDOC,STR)
          CALL MSGERR(MDOC,
     *      '        Change parameter MAXNCS in "atom_com.fh"')

        ELSE
          CS_M_NCS(I,1,ICS) = CR_M_NCS(I,1)
          CS_M_NCS(I,2,ICS) = CR_M_NCS(I,2)
          CS_M_NCS(I,3,ICS) = CR_M_NCS(I,3)
          CS_V_NCS(I,ICS)   = CR_V_NCS(I)
          CS_NCS            = ICS
        ENDIF
      ENDIF
      RETURN
      END

      SUBROUTINE RDSSBOND(MDOC,LINE,IERR)
C ----------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LINE*(*)
C ----------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'link_com.fh'
C -----------------------------------
C -----------------------------------
cCOLUMNS       DATA TYPE        FIELD             DEFINITION
c                                    123456789 123456789 123123456 123456
c123456789012345678901234567890123456789012345678901234567890123456789012
cSSBOND   1 CYS E   48    CYS E   51                          2555
cSSBOND   1 CYS E   48    CYS E   51  xxxx xxxx               2555
c      DATA FRMT/'(15X,A1,1X,A5,7X,A1,1X,A5,23X,A6,1X,A6)'/
c      DATA FRMT/'(15X,A1,1X,A5,7X,A1,1X,A5,1X,A4,1X,A4,13X,A6,1X,A6)'/
c----------------------------------------------------------------------------
c 1 -  6       Record name     "SSBOND"
c
c 8 - 10       Integer         serNum         Serial number.
c
c12 - 14       LString(3)      "CYS"          Residue name.
c
c16            Character       chainID1       Chain identifier.
c
c18 - 21       Integer         seqNum1        Residue sequence number.
c
c22            AChar           icode1         Insertion code.
c
c26 - 28       LString(3)      "CYS"          Residue name.
c
c30            Character       chainID2       Chain identifier.
c
c32 - 35       Integer         seqNum2        Residue sequence number.
c
c36            AChar           icode2         Insertion code.
c
c38 - 41       Character       segID1         Segment identifier
c
c43 - 46       Character       segID2         Segment identifier
c
c60 - 65       SymOP           sym1           Symmetry operator for 1st residue.
c
c67 - 72       SymOP           sym2           Symmetry operator for 2nd residue.
C ---
      CHARACTER STR*256
      CHARACTER CH1*1,CH2*1,CR1*5,CR2*5,SYMM1*6,SYMM2*6
      CHARACTER CA*5,CHAIN1*4,CHAIN2*4
      CHARACTER FRMT*80
C     DATA FRMT/'(15X,A1,1X,A5,7X,A1,1X,A5,23X,A6,1X,A6)'/
      DATA FRMT/
     *   '(15X,A1,1X,A5,7X,A1,1X,A5,1X,A4,1X,A4,13X,A6,1X,A6)'/
C ------------------------------------
      IERR = 0
      READ(LINE,FRMT) CH1,CR1,CH2,CR2,CHAIN1,CHAIN2,SYMM1,SYMM2
C
      IF(NSS_PDB.GE.MAXSSBND) THEN
        WRITE(STR
     *,'('' WARNING: number of SSBOND records of PDB file  >'',I6)') 
     *  MAXSSBND
        CALL MSGDOC(MDOC,STR)
C       IERR=1
        RETURN
      ENDIF 

      IF(CR_SEGFLAG.NE.'Y') THEN
        CHAIN1 = CH1//'   '
        CHAIN2 = CH2//'   '
      ELSE
        CH1 = CHAIN1(1:1)
        CH2 = CHAIN2(1:1)
      ENDIF

      CA = 'SG   '

      NSS_PDB            = NSS_PDB + 1
      NSS_CODE1(NSS_PDB) = CH1//CR1//CA//CHAIN1
      NSS_CODE2(NSS_PDB) = CH2//CR2//CA//CHAIN2
      NSS_1    (NSS_PDB) = 0
      NSS_2    (NSS_PDB) = 0
      NSS_C    (NSS_PDB) = 6
      NSS_ID   (NSS_PDB) = 'SS'
      NSS_RES1 (NSS_PDB) = ' '
      NSS_RES2 (NSS_PDB) = ' '
      NSS_SYMM1(NSS_PDB) = SYMM1
      NSS_SYMM2(NSS_PDB) = SYMM2
      NSS_DIST (NSS_PDB) = 0.0

      RETURN
      END

      SUBROUTINE RDLINK(MDOC,LINE,IERR)
C ----------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LINE*(*)
C ----------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'link_com.fh'
C -----------------------------------
c123456789012345678901234567890123456789012345678901234567890123456789012
cSSBOND   1 CYS E   48    CYS E   51.12345678901234567890123  2555
cSSBOND   1 CYS E   48    CYS E   51.1234567890123            2555
c          1         2         3         4         5         6         7
C      DATA FRMT/'(15X,A1,1X,A5,7X,A1,1X,A5,13X,A6,1X,A6)'/
C 123456123456123451231C12345123456789 12345123451231C1234512123456 123456
c 123456789012345678901234567890123456789012345678901234567890123456789012
c LINK         O1  DDA     1                 C3  DDL     2
c LINK        MN    MN   391                 OE2 GLU   217            2565
C             AAAAaRRR CiiiiI               AAAAaRRR CiiiiI           SSSS  
c ----------------------------------------------------------------------------
c 1 -  6        Record name     "LINK  "
c
c13 - 16        Atom            name1       Atom name.
c
c17             Character       altLoc1     Alternate location indicator.
c
c18 - 20        Residue name    resName1    Residue name.
c
c22             Character       chainID1    Chain identifier.
c
c23 - 26        Integer         resSeq1     Residue sequence number.
c
c27             AChar           iCODE1      Insertion code.
c
c43 - 46        Atom            name2       Atom name.
c
c47             Character       altLoc2     Alternate location indicator.
c
c48 - 50        Residue name    resName2    Residue name.
c
c52             Character       chainID2    Chain identifier.
c
c53 - 56        Integer         resSeq2     Residue sequence number.
c
c57             AChar           iCode2      Insertion code.
c
c60 - 65        SymOP           sym1        Symmetry operator for 1st atom.
c
c67 - 72        SymOP           sym2        Symmetry operator for 2nd atom.
C
c
c31 - 34       Character       segID1         Segment identifier
c
c36 - 39       Character       segID2         Segment identifier
c
C
c73 - 80        link_id (mon_lib.cif)   / special link 'gap' /      
C               if(link_id.eq.' ') link will be created
C                        and if(dist.gt.0.0) with default value
C ---
      CHARACTER STR*256
      CHARACTER CH1*1,CH2*1,CR1*3,CR2*3,SYMM1*6,SYMM2*6
      CHARACTER CA1*5,CA2*5,CN1*5,CN2*5,CH8*8,CH10*10,ATOM*4
      CHARACTER SEG1*4,SEG2*4
      CHARACTER FRMT*80,ASYMB*4,CTYPE*4
      DATA FRMT/
     *'(12X,A5,A3,1X,A1,A5,3X,A10,2X,A5,A3,1X,A1,A5,2X,A6,1X,A6,A8)'/
C123456123456123451231C12345123456789 12345123451231C1234512123456 123456
C            -----   X -----XXX----------XX     
c123456789012345678901234567890123456789012345678901234567890123456789012
cLINK         O1  DDA     1                 C3  DDL     2   12_555 12_555
cLINK        MN    MN   391      dist       OE2 GLU   217            2565link_id
CLINK         C   CH3 A   1                 O2*  +C A   1                    
CLINK         SG  CYS B  48                 SG  CYS C  48     4455   1555SS
C            AAAAaRRR CiiiiI     dist      AAAAaRRR CiiiiI  ssssss SSSSSSlink_id
C                              seg1-seg2-
C ------------------------------------
      integer l,iv
      real fv
c
      IERR = 0
      READ(LINE,FRMT) CA1,CR1,CH1,CN1,CH10,CA2,CR2,CH2,CN2
     * ,SYMM1,SYMM2,CH8
C
      IF(NSS_PDB.GE.MAXSSBND) THEN
        WRITE(STR
     *,'('' WARNING: number of LINK records of PDB file  >'',I6)') 
     *  MAXSSBND
        CALL MSGDOC(MDOC,STR)
C       IERR=1
        RETURN
      ENDIF 


C     READ(CH10,'(F10.5)') DIST
      DIST = 0.0
      l = len_trim(adjustl(ch8))
c      write(*,*)l
      if(l.gt.0) then
         call wtodig(trim(adjustl(ch8)),l,fv,iv)
c         write(*,*)l,fv,iv
         if(fv.gt.0.0) then
            dist = fv
            ch8 = ' '
         endif
      endif
c      write(*,*)ch8
c      write(*,*)dist
c      stop
      SEG1 = CH10(1:4)
      SEG2 = CH10(6:9)

      IF(CR_SEGFLAG.NE.'Y') THEN
        SEG1 = CH1//'   '
        SEG2 = CH2//'   '
      ELSE
        CH1 = SEG1(1:1)
        CH2 = SEG2(1:1)
      ENDIF

      ATOM = CA1(1:4)
      CALL CORR_NAME_PDB(ATOM,CR1,ASYMB,CTYPE)
      CA1(1:4) = ATOM
      ATOM = CA2(1:4)
      CALL CORR_NAME_PDB(ATOM,CR2,ASYMB,CTYPE)
      CA2(1:4) = ATOM

      ATOM = CA1(1:4)
      CALL LENSTR_BL(ATOM,L)
      IF(L.LE.0.OR.ATOM(1:1).EQ.'.') THEN
        ATOM = ' '
        CA1(1:4) = ATOM     
      ELSE
        IF(CA1(1:1).EQ.' ') THEN
          CA1(1:1) = CA1(2:2)
          CA1(2:2) = CA1(3:3)
          CA1(3:3) = CA1(4:4)
          CA1(4:4) = ' '
        ENDIF         
      ENDIF
C     CA1(5:5) = ' '

      ATOM = CA2(1:4)
      CALL LENSTR_BL(ATOM,L)
      IF(L.LE.0.OR.ATOM(1:1).EQ.'.') THEN
        ATOM = ' '
        CA2(1:4) = ATOM     
      ELSE
        IF(CA2(1:1).EQ.' ') THEN
          CA2(1:1) = CA2(2:2)
          CA2(2:2) = CA2(3:3)
          CA2(3:3) = CA2(4:4)
          CA2(4:4) = ' '
        ENDIF         
      ENDIF
C     CA2(5:5) = ' '

      NSS_PDB            = NSS_PDB + 1
      NSS_CODE1(NSS_PDB) = CH1//CN1//CA1//SEG1
      NSS_CODE2(NSS_PDB) = CH2//CN2//CA2//SEG2
      NSS_1    (NSS_PDB) = 0
      NSS_2    (NSS_PDB) = 0
      IF(CH8(1:3).EQ.'gap'.OR.CH8(1:3).EQ.'GAP') THEN
        NSS_C  (NSS_PDB) = 9 
        NSS_ID (NSS_PDB) = 'gap'
      ELSE
        NSS_C  (NSS_PDB) = 8
        NSS_ID (NSS_PDB) = CH8
      ENDIF
      NSS_RES1 (NSS_PDB) = CR1
      NSS_RES2 (NSS_PDB) = CR2
      NSS_SYMM1(NSS_PDB) = SYMM1
      NSS_SYMM2(NSS_PDB) = SYMM2
      NSS_DIST (NSS_PDB) = DIST
C ---
C      write(*,*) 'l<',NSS_ID(NSS_PDB),'><'
C     * ,NSS_RES1(NSS_PDB),'><',NSS_RES2(NSS_PDB),'><'
C     * ,NSS_CODE1(NSS_PDB),'><',NSS_CODE2(NSS_PDB),'>'
C ---
      RETURN
      END

      SUBROUTINE RDMODRES(MDOC,LINE,IERR)
C ----------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LINE*(*)
C ----------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'link_com.fh'
C -----------------------------------
C ---
c MODRES            Identification of modifications to standard residues.
c MODRES 2ABC TTQ A   50A TRP  POST-TRANSLATIONAL MODIFICATION
c
c MODRES 3ABC ALA A   32  ALA  POST-TRANSLATIONAL MODIFICATION,D-ALANINE
C            actual     standard
c 1 -  6        Record name     "MODRES"
c
c 8 - 11        IDcode          idCode         ID code of this entry.
c
c13 - 15        LString         resName        Residue name used.
c
c17             Character       chainID        Chain identifier.
c
c19 - 22        Integer         seqNum         Sequence number.
c
c23             AChar           iCode          Insertion code.
c
c25 - 32        Residue name    stdRes         Standard residue name.
c
c34 - 37        Character       segID         Segment identifier
c
c38 - 70        String          comment        Description of the residue
c                                              modification.
C --
C73 - 80        mod_id  (mon_lib.cif)
C                       if(mod_id.eq.' ') mod_id = 'RENAME'
C                                                 / change residue name only /
c ----------------------------------------------------------------------------
C ---
      CHARACTER STR*256
      CHARACTER CH1*1,CH2*1,CR1*3,CR2*8,CA1*5,CA2*5,CHAR8*8
      CHARACTER CN1*5,CN2*5,CH8*8,ASYMB*4,CTYPE*4,ATOM*4
      CHARACTER SEG*4
C     CHARACTER IRES1*5,IRES2*5,SYMM1*8,SYMM2*8
      CHARACTER FRMT*80
C      DATA FRMT/
C     *'(12X,A3,1X,A1,1X,A5,1X,A8,40X,A8)'/
      DATA FRMT/
     *'(12X,A3,1X,A1,1X,A5,1X,A8,1X,A4,35X,A8)'/
CMODRES 310D  +C A    1    C  CYTOSINE MODIFIED WITH CH3                 
CMODRES      ALA A   10  ALA  POST-TRANSLATIONAL MODIFICATION,D-ALANINE  COO
cMODRES 3ABC ALA A   32  ALA  POST-TRANSLATIONAL MODIFICATION,D-ALANINE  md_id
c123456789012345678901234567890123456789012345678901234567890123456789012
C            --- - ====^ ========123456789 123456789 123456789 123456789 
C                                 ---- 123456789 123456789 123456789 1234
C ------------------------------------
      IERR = 0
      READ(LINE,FRMT) CR1,CH1,CN1,CR2,SEG,CH8
C

      IF(NSS_PDB.GE.MAXSSBND) THEN
        WRITE(STR
     *,'('' WARNING: number of MODRES records of PDB file  >'',I6)') 
     *  MAXSSBND
        CALL MSGDOC(MDOC,STR)
C       IERR=1
        RETURN
      ENDIF 

      IF(CR_SEGFLAG.NE.'Y') THEN
        SEG = CH1//'   '
      ELSE
        CH1 = SEG(1:1)
      ENDIF

      if(len_trim(line(8:11)).ne.0) then
         str = ' WARNING : Modification seems to be from PDB.'//
     &        ' It will be ignored'
         call msgdoc(mdoc,str)
         ch8 = ' '
      endif
      CALL LENSTR_BL(CH8,LEN)     
      IF(LEN.LE.0) THEN
        CH8 = '.'

        STR = ' WARNING : file_PDB: MODRES record'//
     *        ' cannot be used without mod_id'
        CALL MSGDOC(MDOC,STR)
        STR = '<'//LINE(1:76)//'>'   
        CALL MSGDOC(MDOC,STR)
        RETURN
      ENDIF


      CA1 = ' '
      CA2 = ' '
      CN2 = ' '
      CH2 = ' '

      ATOM = 'C   '
      CALL CORR_NAME_PDB(ATOM,CR1,ASYMB,CTYPE)

      CALL LENSTR_BL(CR2,LCR2)
      IF(LCR2.GT.3) THEN
        CHAR8 = CR2
        CR2   = CHAR8(1:3)
        DO I=4,LCR2
          IF(CHAR8(I:I).EQ.' ') GO TO 100
          CR2(I:I) = CHAR8(I:I)
        ENDDO
 100    CONTINUE
      ENDIF

      CALL CORR_NAME_PDB(ATOM,CR2,ASYMB,CTYPE)

      NSS_PDB            = NSS_PDB + 1
      NSS_CODE1(NSS_PDB) = CH1//CN1//CA1//SEG
      NSS_CODE2(NSS_PDB) = CH2//CN2//CA2//'    '
      NSS_1    (NSS_PDB) = 0
      NSS_2    (NSS_PDB) = 0
      NSS_C    (NSS_PDB) = 10
      NSS_ID   (NSS_PDB) = CH8
      NSS_RES1 (NSS_PDB) = CR1
      NSS_RES2 (NSS_PDB) = ' '
      NSS_SYMM1(NSS_PDB) = CR1
      NSS_SYMM2(NSS_PDB) = CR2
      NSS_DIST (NSS_PDB) = 0.0

C ---
c      write(*,*) 'm<',NSS_ID(NSS_PDB),'><'
c     * ,NSS_RES1(NSS_PDB),'><',NSS_RES2(NSS_PDB),'><'
c     * ,NSS_CODE1(NSS_PDB),'><',NSS_CODE2(NSS_PDB),'>'
C ---
      RETURN
      END

      SUBROUTINE RDCISPEP(MDOC,LINE,IERR)
C ----------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LINE*(*)
C ----------------------------------
      INCLUDE 'crd_com.fh'
      INCLUDE 'link_com.fh'
C -----------------------------------
c CISPEP records specify the prolines and other peptides found to be in the cis
c conformation. This record replaces the use of footnote records to list cis
c peptides.
c
c Record Format
c
cCOLUMNS       DATA TYPE       FIELD        DEFINITION
c-------------------------------------------------------------------------
c 1 -  6       Record name     "CISPEP"
c
c 8 - 10       Integer         serNum       Record serial number.
c
c12 - 14       LString(3)      pep1         Residue name.
c
c16            Character       chainID1     Chain identifier.
c
c18 - 21       Integer         seqNum1      Residue sequence number.
c
c22            AChar           icode1       Insertion code.
c
c26 - 28       LString(3)      pep2         Residue name.
c
c30            Character       chainID2     Chain identifier.
c
c32 - 35       Integer         seqNum2      Residue sequence number.
c
c36            AChar           icode2       Insertion code.
c
c38 - 41       Character       segID1         Segment identifier
c
c43 - 46       Character       segID2         Segment identifier
c
c???44 - 46       Integer         modnum       Identifies the specific model.
c
c54 - 59       Real(6.2)       measure      Measure of the angle in
c                                           degrees.
c
c         1         2         3         4         5         6         7
c1234567890123456789012345678901234567890123456789012345678901234567890
C123456 123 123 1 12345   123 1 12345123456789 1234567123456
cCISPEP   1 GLY A  116    GLY A  117                   18.50
cCISPEP   2 THR D   92    PRO D   93                  359.80
c                                    SEG1 SEG2
C ---
      CHARACTER STR*256,CH1*1,CH2*1,CR1*5,CR2*5,CA1*5,CA2*5
      CHARACTER SEG1*4,SEG2*4
      CHARACTER FRMT*80
C      DATA FRMT/'(15X,A1,1X,A5,7X,A1,1X,A5)'/
      DATA FRMT/'(15X,A1,1X,A5,7X,A1,1X,A5,1X,A4,1X,A4)'/
C ------------------------------------
      IERR = 0
      READ(LINE,FRMT) CH1,CR1,CH2,CR2,SEG1,SEG2
C
      IF(NSS_PDB.GE.MAXSSBND) THEN
        WRITE(STR,'(A,I6)')
     *' WARNING: number of SSBOND or CISPEP records in PDB file >',
     * MAXSSBND
        CALL MSGDOC(MDOC,STR)
C       IERR=1
        RETURN
      ENDIF 

      IF(CR_SEGFLAG.NE.'Y') THEN
        SEG1 = CH1//'   '
        SEG2 = CH2//'   '
      ELSE
        CH1 = SEG1(1:1)
        CH2 = SEG2(1:1)
      ENDIF

      CA1='C    '
      CA2='N    '

      NSS_PDB            = NSS_PDB + 1
      NSS_CODE1(NSS_PDB) = CH1//CR1//CA1//SEG1
      NSS_CODE2(NSS_PDB) = CH2//CR2//CA2//SEG2
      NSS_1    (NSS_PDB) = 0
      NSS_2    (NSS_PDB) = 0
      NSS_C    (NSS_PDB) = 7
      NSS_ID   (NSS_PDB) = 'CIS'
      NSS_RES1 (NSS_PDB) = ' '
      NSS_RES2 (NSS_PDB) = ' '
      NSS_SYMM1(NSS_PDB) = '      '
      NSS_SYMM2(NSS_PDB) = '      '
      NSS_DIST (NSS_PDB) = 0.0

      RETURN
      END

      SUBROUTINE RDCONECT(MDOC,ICONN,LINE,IERR)
C -----------------------------------------------
C -P- 
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LINE*(*)
C ---
C -----------------------------------
      INCLUDE 'link_com.fh'
C -----------------------------------
C ---
      INTEGER*4 IC(8),ICODE(8),NC(8)
      CHARACTER STR*256
      CHARACTER FRMT*80
      DATA FRMT/'(6X,11I5)'/
      DATA ICODE/ 1,1,1,1,2,3,4,5/
C ------------------------------------
      IERR = 0
      READ(LINE,FRMT) I,IC(1),IC(2),IC(3),IC(4)
     *                 ,IC(7),IC(5),IC(8),IC(6)
      CALL NSRCH_PDB(I,N)
      IF(N.LE.0) RETURN

      DO J =1,6
        CALL NSRCH_PDB(IC(J),NC(J))
        IF(NC(J).GT.0) THEN
          IF(N.GT.NC(J)) THEN
            N2  = N 
            N1  = NC(J)
            ICD = -ICODE(J)
          ELSE
            N1  = N 
            N2  = NC(J)
            ICD = ICODE(J)
          ENDIF        
          
          DO L=1,NCONN_PDB
            IF(ICON1_PDB(L).EQ.N1.AND.
     *         ICON2_PDB(L).EQ.N2     ) GO TO 200
          ENDDO

          IF(NCONN_PDB.GE.MAXCONNP) THEN
            IF(ICONN.EQ.0) THEN
              WRITE(STR
     *   ,'('' WARNING: number of CONECT records of PDB file  >'',I6)') 
     *        MAXCONNP
              CALL MSGERR(MDOC,STR)
              CALL MSGERR(MDOC,
     *      '        Change parameter MAXCONNP in "link_com.fh"')
C             IERR=1
              ICONN = 1
            ENDIF
            RETURN
          ENDIF 
          NCONN_PDB              = NCONN_PDB+1
          ICON1_PDB  (NCONN_PDB) = N1
          ICON2_PDB  (NCONN_PDB) = N2
          ICONC_PDB  (NCONN_PDB) = ICD
          ICONN_SYMM1(NCONN_PDB) = ' '
          ICONN_SYMM2(NCONN_PDB) = ' '
        ENDIF
 200    CONTINUE
      ENDDO
      RETURN
      END

      SUBROUTINE NSS_PDB_TO_LN(MDOC,LIST,IERR)
C -----------------------------------------------
C -P- LINKS & SSBONDS TO NCONN_PDB
C -S-
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
      CHARACTER LINE*256
C ---
C -----------------------------------
      INCLUDE 'link_com.fh'
      INCLUDE 'atom_com.fh'
C -----------------------------------
C ---
      CHARACTER SYMM1*7,SYMM2*7,LINK*8,ATOM1*4,ATOM2*4,ALT1*1,ALT2*1
      CHARACTER SEQ1*5,SEQ2*5,MOD*8,SYMM*7,PATOM1*5,PATOM2*5,LIST*1
C     CHARACTER RES1*3,RES2*3
C ------------------------------------
C
C     code:
C      1         covalent bonds IC1,IC2,IC3,IC4
C      2         salt bridges   IC5 ( I has an excess of negative charge)
C      3         salt bridges   IC6 ( I has an excess of positive charge)
C      4         hydrogen bond  IC7 ( I acts as donor)
C      5         hydrogen bond  IC8 ( I acts as acceptor)
C
C      6         SS bridges
C      7         CIS
C      8         link
C      9         gap
C     10         modification
C
      IERR = 0
      IF(NSS_PDB.GT.0) THEN

        DO I=1,NSS_PDB

          IF(NSS_C(I).EQ.10) THEN

            IA1   = NSS_1    (I)
            IF(IA1.LE.0) GO TO 100

            MOD   = NSS_ID   (I)
            IRES1 = I_RESID(IA1)  
            SEQ1  = RES_NUM_PDB(IRES1)(3:7)
            ICH1  = I_CHAIN(IRES1)
            SYMM1 = NSS_SYMM1(I)
            SYMM2 = NSS_SYMM2(I)

C --
            IF(LIST.EQ.'T') THEN
              write(*,*) 'mm',ia1,mod,ires1,seq1,ich1,RES_NAME(IRES1)
     *        ,SYMM1(1:3),SYMM2(1:3)
            ENDIF
C --
            CALL LENSTR_BL(MOD,LEN)
            IF(LEN.LE.0) MOD(1:1) = '.'
C           IF(MOD(1:1).EQ.'.') MOD = 'RENAME'
            IF(MOD(1:1).EQ.'.') THEN
              WRITE(LINE,
     *'('' WARNING: MODRES record without ID, ignored.'')') 
              CALL MSGDOC(MDOC,LINE)
              GO TO 100
            ENDIF
            IF(MOD_N.GE.MAXMODIF) THEN
              WRITE(LINE,
     *'('' WARNING: Number of modifications. >'',I6)') MAXMODIF
              CALL MSGDOC(MDOC,LINE)
              WRITE(LINE,
     *'(''          Change parameter MAXMODIF in "atom_com.fh"'')')
              CALL MSGDOC(MDOC,LINE)
              WRITE(LINE,
     *'(''          Now program stops to use new modifications.'')')
              CALL MSGDOC(MDOC,LINE)
              RETURN
            ENDIF

            CALL LENSTR_BL(SEQ1,LEN)
            IF(LEN.LE.0) SEQ1(1:1) = '.'
            CALL LENSTR_BL(SYMM2,LEN)
            IF(LEN.LE.0) SYMM2(1:1) = '.'

            IF(IRES1.LE.0.OR.ICH1.LE.0) GO TO 100

            MOD_N               = MOD_N + 1
            MOD_ID      (MOD_N) = MOD
            MOD_IRES    (MOD_N) = IRES1
            MOD_SEQ     (MOD_N) = SEQ1
            MOD_RNAM    (MOD_N) = SYMM2
c           MOD_RNAM    (MOD_N) = SYMM2(1:3)
            MOD_RNAM_NEW(MOD_N) = RES_NAME(IRES1)
            MOD_ICHN    (MOD_N) = ICH1
            MOD_USED    (MOD_N) = 'U'

            MOD_FLAG    (IRES1) = 'Y'

 100        CONTINUE

          ELSE

            IF(LN_N.GE.MAXLINK) THEN

              WRITE(LINE,
     *      '('' WARNING: Number of links >'',I6)') MAXLINK
              CALL MSGDOC(MDOC,LINE)
              WRITE(LINE,
     *    '(''          Change parameter MAXLINK in "atom_com.fh"'')')
              CALL MSGDOC(MDOC,LINE)
              WRITE(LINE,
     *      '(''          Now program stops to create links.'')')
              CALL MSGDOC(MDOC,LINE)
              NSS_PDB = 0
              RETURN
            ENDIF

            IA1    = NSS_1    (I)
            IA2    = NSS_2    (I)
            IF(IA1.LE.0.OR.IA2.LE.0) THEN
C ---
            IF(LIST.EQ.'T') THEN
              write(*,*) 'LL_not',ia1,IA2,NSS_ID(I),NSS_CODE1(I)(7:11)
     *        ,NSS_CODE2(I)(7:11)
            ENDIF
C ---
              GO TO 200
            ENDIF
            LINK   = NSS_ID   (I)
            PATOM1 = NSS_CODE1(I)(7:11)
            PATOM2 = NSS_CODE2(I)(7:11)
            
            SYMM1 = ' '
            CALL LENSTR_BL(NSS_SYMM1(I),LEN)
            IF(LEN.GT.0) THEN
              SYMM(1:3) = NSS_SYMM1(I)(1:3)
              SYMM(4:4) = '_'
              SYMM(5:7) = NSS_SYMM1(I)(4:6)
              CALL LENSTR_BL(SYMM,LEN)
              K = 0
              DO J=1,LEN
                IF(SYMM(J:J).NE.' ') THEN
                  K = K + 1
                  SYMM1(K:K) = SYMM(J:J)
                ENDIF 
              ENDDO
            ENDIF

            SYMM2 = ' '
            CALL LENSTR_BL(NSS_SYMM2(I),LEN)
            IF(LEN.GT.0) THEN
              SYMM(1:3) = NSS_SYMM2(I)(1:3)
              SYMM(4:4) = '_'
              SYMM(5:7) = NSS_SYMM2(I)(4:6)
              K = 0
              CALL LENSTR_BL(SYMM,LEN)
              DO J=1,LEN
                IF(SYMM(J:J).NE.' ') THEN
                  K = K + 1
                  SYMM2(K:K) = SYMM(J:J)
                ENDIF 
              ENDDO
            ENDIF

C            SYMM1 = NSS_SYMM1(I)
C            SYMM2 = NSS_SYMM2(I)

            IRES1 = I_RESID(IA1)  
            IRES2 = I_RESID(IA2)  

            IF(PATOM1(1:1).EQ.' ') THEN
              ATOM1 = '.'
              ALT1  = '.'
            ELSE
              ATOM1 = ATM_NAME(IA1)  
              ALT1  = ID_ALT  (IA1) 
            ENDIF
            IF(PATOM2(1:1).EQ.' ') THEN
              ATOM2 = '.'
              ALT2  = '.'
            ELSE
              ATOM2 = ATM_NAME(IA2)  
              ALT2  = ID_ALT  (IA2) 
            ENDIF

            IF(NSS_C(I).EQ.6) THEN
              ALT1  = '.'
              ALT2  = '.'
            ELSE IF(NSS_C(I).EQ.8) THEN
              ALT1 = NSS_CODE1(I)(11:11)
              ALT2 = NSS_CODE2(I)(11:11)
            ENDIF

            SEQ1  = RES_NUM_PDB(IRES1)(3:7)
            SEQ2  = RES_NUM_PDB(IRES2)(3:7)
            ICH1  = I_CHAIN (IRES1)
            ICH2  = I_CHAIN (IRES2)
            DIST  = NSS_DIST(I)
C ---
            IF(LIST.EQ.'T') THEN
              write(*,*) 'LL',ia1,IA2,LINK,ires1,IRES2,seq1
     *        ,RES_NAME(IRES1),RES_NAME(IRES2)
     *        ,SYMM1(1:3),SYMM2(1:3)
            ENDIF
C ---
            IF(LINK.EQ.'CIS'.AND.
     *         (RES_NAME(IRES2).EQ.'PRO'  .OR.
     *          RES_NAME(IRES2).EQ.'5HP'  .OR.
     *          RES_NAME(IRES2).EQ.'DPR'  .OR.
     *          RES_NAME(IRES2).EQ.'PCA'  .OR.
     *          RES_NAME(IRES2).EQ.'PRO-D'.OR.
     *          RES_NAME(IRES2).EQ.'5HP-D'.OR.
     *          RES_NAME(IRES2).EQ.'HYP-D'.OR.
     *          RES_NAME(IRES2).EQ.'HYP'    )) LINK = 'PCIS'
            IF(LINK.EQ.'CIS'.AND.
     *          (RES_NAME(IRES2).EQ.'BMT'.OR.
     *           RES_NAME(IRES2).EQ.'SAR'.OR.
     *           RES_NAME(IRES2).EQ.'MLE'.OR.
     *           RES_NAME(IRES2).EQ.'MVA'    )) LINK = 'NMCIS'

            CALL LENSTR_BL(LINK,LEN)
            IF(LEN.LE.0) LINK(1:1)  = '.'
            IF(DIST.LE.0.00001) DIST = 0.0
            CALL LENSTR_BL(SEQ1,LEN)
            IF(LEN.LE.0) SEQ1(1:1)  = '.'
            CALL LENSTR_BL(SEQ2,LEN)
            IF(LEN.LE.0) SEQ2(1:1)  = '.'
            CALL LENSTR_BL(ATOM1,LEN)
            IF(LEN.LE.0) ATOM1(1:1) = '.'
            CALL LENSTR_BL(ATOM2,LEN)
            IF(LEN.LE.0) ATOM2(1:1) = '.'
            CALL LENSTR_BL(ALT1,LEN)
            IF(LEN.LE.0) ALT1(1:1)  = '.'
            CALL LENSTR_BL(ALT2,LEN)
            IF(LEN.LE.0) ALT2(1:1)  = '.'
            CALL LENSTR_BL(SYMM1,LEN)
            IF(LEN.LE.0) SYMM1(1:1)  = '.'
            CALL LENSTR_BL(SYMM2,LEN)
            IF(LEN.LE.0) SYMM2(1:1)  = '.'

            IF((SYMM1.EQ.'.'.OR.SYMM1.EQ.'1_555').AND.
     *         (SYMM2.EQ.'.'.OR.SYMM2.EQ.'1_555')     ) THEN
              SYMM1 = '.'
              SYMM2 = '.'
            ENDIF

            LN_N             = LN_N + 1
            LN_ID   (LN_N)   = LINK
            LN_1IRES(LN_N)   = IRES1
            LN_2IRES(LN_N)   = IRES2
            LN_1RNAM(LN_N)   = RES_NAME(IRES1)
            LN_2RNAM(LN_N)   = RES_NAME(IRES2)
            LN_1ICHN(LN_N)   = ICH1 
            LN_2ICHN(LN_N)   = ICH2     
            LN_SEQ1 (LN_N)   = SEQ1 
            LN_SEQ2 (LN_N)   = SEQ2     
            LN_ATOM1(LN_N)   = ATOM1 
            LN_ATOM2(LN_N)   = ATOM2
            LN_ALT1 (LN_N)   = ALT1 
            LN_ALT2 (LN_N)   = ALT2
            LN_SYMM1(LN_N)   = SYMM1 
            LN_SYMM2(LN_N)   = SYMM2     
            LN_DIST (LN_N)   = DIST 
          
            IF((SYMM2.NE.'.'.OR.SYMM2.NE.'.').AND.LINK(1:1).EQ.'.') THEN
              LINK = 'symmetry'
              LN_ID(LN_N)   = LINK
            ENDIF

            IF(LIST.EQ.'T') THEN
              WRITE(*,*) 'LL:',LINK,I,LN_N
              WRITE(*,*) '   '
     *        ,ICH1,IRES1,RES_NAME(IRES1),ATOM1,ALT1
              WRITE(*,*) '   '
     *        ,ICH2,IRES2,RES_NAME(IRES2),ATOM2,ALT2
            ENDIF
C
C           LN_ENT    E - form ent_poly_seq (not trans 2 , ptrans 36 , p 4)
C                     L - form ent_link
C                     C - from conn
C
            LN_USED (LN_N)   = 'U' 
            IF((LN_ALT1(LN_N).NE.'.'.AND.LN_ALT1(LN_N).NE.' ').OR.
     *         (LN_ALT2(LN_N).NE.'.'.AND.LN_ALT2(LN_N).NE.' ')     )
     *        LN_USED(LN_N) = 'S'
c           LN_USED (LN_N)   = '.' 
C ??????

            LN_ENT  (LN_N)   = 'C' 

            LINK_FLAG(IRES1) = 'Y'
            LINK_FLAG(IRES2) = 'Y'

            CALL SET_ICONN(LINK,ICONN)
C           IF(LINK.EQ.'CIS')    ICONN_TYPE(IRES2) = 3
C           IF(LINK.EQ.'PTRANS') ICONN_TYPE(IRES2) = 36
C           IF(LINK.EQ.'PCIS')   ICONN_TYPE(IRES2) = 37
C            IF(ICONN.GT.1.AND.ICONN.LE.N_CONN_TYPE) 
C     *        ICONN_TYPE(IRES2) = ICONN

 200      CONTINUE

          ENDIF

        ENDDO
      ENDIF

      NSS_PDB = 0

C ----------------------
      RETURN
      END

      SUBROUTINE NSRCH_PDB(I,N)
C -----------------------------------------------
C -P- 
C -S-
C -----------------------------------------------
      INTEGER*4 I,N
C ---
      INCLUDE 'atom_com.fh'
C ******
C ------------------------------------
      N  = 0
      II = ABS(I)
      IF(N_ATOM.LE.0) RETURN
      IF(II.LE.0.OR.II.GT.N_ATOM) RETURN

      KS = II
      IF(I_ATOLD(KS).EQ.II) THEN
        N = II
        RETURN  
      ELSE IF(I_ATOLD(KS).LT.II) THEN  
        KF = N_ATOM
        ID = 1
      ELSE
        KF = 1
        ID =-1
      ENDIF

      DO K=KS,KF,ID
        IF(I_ATOLD(K).EQ.II) THEN
          N = K
          RETURN
        ENDIF         
      ENDDO

      RETURN
      END

      SUBROUTINE RDANISO(LINE)
C -------------------------------------------------------
      CHARACTER LINE*(*)
C ******
C ------------------------------------------------------
      INCLUDE 'crd_com.fh'
C -----------------------------------
      INTEGER*4 IANISO(6)
      CHARACTER FRMT*80
      DATA FRMT/'(28X,6I7)'/
C ------------------------------------

      READ(LINE,FRMT) (IANISO(I),I=1,6)

      DO I=1,6
        CR_ANIS(I) = IANISO(I)/10000.0
      ENDDO 

      CR_B_FLAG = 1
      CR_BTYPE  = 'A'

      RETURN
      END

      SUBROUTINE RDSIGAT(LINE)
      CHARACTER LINE*(*)
      RETURN
      END

      SUBROUTINE RDSIGUIJ(LINE)
      CHARACTER LINE*(*)
      RETURN
      END

      SUBROUTINE CORR_NAME_PDB(ANAME,RNAME,ASYMB,CTYPE)
c
c----Many things are redundant. For example distortion of atom names
c---
      CHARACTER ANAME*4,RNAME*3,ASYMB*4,CTYPE*4
      CHARACTER TYPE*1,CH1*1,CH2*2,CH4*4
      CHARACTER LINE*256
c
      character atemp*16
      logical ok
C ---
      INCLUDE 'metal.fh'
C ---
C      PARAMETER (N_NAME = 32)
C      CHARACTER NAME(N_NAME)*2
C      DATA NAME/'CO','MG','CA','ZN','CU','FE','CL','BR','MN','PB',
C     *          'HG','AL','GD','NA','CD','NI','SR','IN','HO','YB',
C     *          'TE','LI','RB','BA','CS','SM','TL','PT','BE','SE',
C     *          'MO','SI'/
C ??? more
C ---
C ---------------------------------------------
c
c---  Do not do any correction. Read as it is from pdb and move to the left if 
c---  it is necessary
c---  Only use minimal number of built in assumptions

c
c---  Try to extract atomic symbol
      if(asymb.eq.' ') then
         if(aname(1:1).eq.' ') then
            asymb(1:1) = aname(2:2)
            if(aname(3:3).eq.'+'.or.aname(3:3).eq.'-') then
               asymb(1:3) = aname(2:4)
            endif
         else if(aname(3:3).eq.'+'.or.aname(3:3).eq.'-') then
            asymb(1:4) = aname(1:4)
c
c---  Is it a valid atom name?
            call check_valid_atom_name(asymb,ok)
            if(.not.ok) then
               write(*,*)aname,asymb
               write(*,*)'Problem in corr_atom_name. '//
     &              'Element name cannot be extractred from atom name'
               stop
            endif
         endif
      endif
      l = len_trim(aname)
      i = 1
      do while(aname(i:i).eq.' '.and.i.le.l)
         i = i + 1
      enddo

      atemp = aname(i:l)
      aname = trim(atemp)
      l = len_trim(aname)
      if(aname(2:2).eq.'+'.or.aname(2:2).eq.'-') then
         aname(2:4) = ' '
      endif
      if(aname(3:3).eq.'+'.or.aname(3:3).eq.'-') then
         aname(3:4) = ' '
      endif

      IF(RNAME.EQ.'WAT') RNAME = 'HOH'
      IF(RNAME.EQ.'DOD') RNAME = 'HOH'
      IF(RNAME.EQ.'H2O') RNAME = 'HOH'
      if(rname.eq.'TIP') rname = 'HOH'

      IF(RNAME.EQ.'DUM') THEN
        ANAME = 'DUM '
        ASYMB = 'O   '
        CTYPE = 'C   '
      ENDIF
      IF(RNAME.EQ.'HOH'.OR.RNAME.EQ.'DOD') THEN
        IF(ASYMB(1:1).EQ.'O') THEN
          ANAME = 'O   '
          ASYMB = 'O   '
          CTYPE = 'C   '
        ELSE IF(ASYMB(1:1).EQ.'H'.OR.ASYMB(1:1).EQ.'D') THEN
          ASYMB = 'H   '
          CTYPE = 'H   '
          IF(ANAME(1:2).EQ.'D1') ANAME = 'H1  '
          IF(ANAME(1:2).EQ.'D2') ANAME = 'H2  '
        ELSE
          ANAME = 'O   '
          ASYMB = 'O   '
          CTYPE = 'C   '
        ENDIF
      ENDIF


      CALL GET_STANDARD_RES_TYPE(MDOC,LINE,RNAME,ITYPE,IERR)
      IF(ITYPE.EQ.1) THEN
        CALL GET_INI_RES_TYPE(MDOC,LINE,RNAME,ITYPE,IERR)
      ENDIF
      IF(ITYPE.EQ.5) THEN
        IF(ANAME.EQ.'P5  ') THEN
          ANAME    = 'P   '
          CTYPE='C   '
        ENDIF
        IF(ANAME.EQ.'O51 ') THEN
          ANAME    = 'OP1 '
          CTYPE='C   '
        ENDIF
        IF(ANAME.EQ.'O52 ') THEN
          ANAME    = 'OP2 '
          CTYPE='C   '
        ENDIF
      ELSE IF(ITYPE.EQ.3.OR.ITYPE.EQ.4) THEN
        IF(ANAME.EQ.'H0  ') THEN
          ANAME    = 'H   '
          CTYPE='H   '
        ENDIF
        IF(ANAME.EQ.'HT1 ') THEN
          ANAME    = 'H1  '
          ASYMB    = 'H   '
          CTYPE    = 'H   '
        ENDIF
        IF(ANAME.EQ.'HT2 ') THEN
          ANAME    = 'H2  '
          ASYMB    = 'H   '
          CTYPE    = 'H   '
        ENDIF
        IF(ANAME.EQ.'HT3 ') THEN
          ANAME    = 'H3  '
          ASYMB    = 'H   '
          CTYPE    = 'H   '
        ENDIF
      ENDIF
      RETURN
      END

      SUBROUTINE CORR_SUGAR_PDB(MDOC,LIST,IERR)
C -----------------------------------------------
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'atom_com.fh'
C --- 
      REAL      XC1(3),XC2(3),XC4(3),XC5(3)
      REAL      XC6(3),XO1(3),XO5(3)
      CHARACTER ALT*1,MON*8
      CHARACTER LINE*256,LIST*1
C -----------------------------------
      IERR  = 0

      DO ICH=1,N_GROUP

        N_R = NRES_CHAIN(ICH)   

        IRS = IRES_FIRST(ICH)
        IRF = IRS + N_R - 1

        DO IR=IRS,IRF

          ITYPE  = IRES_TYPE(IR)

          IF(ITYPE.GE.7.AND.ITYPE.LE.8) THEN
C ------------------sugar ---
C ---             check alpha or beta ?
C                 C1 - O1 - O5 - C2        PH > 0 alpha, PH < 0 beta
C
C ---             check L or D ?
C                 C5 - C4 - O5 - C6        PH > 0 - L , PH < 0 - D
C ----------------------------
            IAS  = IRATM_FIRST(IR)
            IAF  = IRATM_FIRST(IR)+NATM_RES(IR)-1

            IF(MOD_N.GT.0) THEN
              DO I=1,MOD_N
                IF(MOD_ID(I).EQ.'RENAME') THEN
                  IF(MOD_IRES(I).EQ.IR .AND.
     *               MOD_ICHN(I).EQ.ICH     ) GO TO 100
                ENDIF
              ENDDO
            ENDIF

            MON  = RES_NAME(IR)(1:3)
            
            IF(MON(1:3).NE.'FUC'.AND.MON(1:3).NE.'MAN'.AND.
     *         MON(1:3).NE.'GAL'.AND.MON(1:3).NE.'NAG'.AND.
     *         MON(1:3).NE.'GLC'.AND.MON(1:3).NE.'GCU'     ) THEN
              GO TO 100
            ENDIF

            IF(MON(1:3).EQ.'FUC') THEN
              MON = MON(1:3)//'-a-L' 
            ELSE
              MON = MON(1:3)//'-b-D' 
            ENDIF 
            IT1  = 0  
            IT2  = 0  
            IT3  = 0  
            IT4  = 0  
            ITC1 = 0
            ITC2 = 0
            ITC4 = 0
            ITC5 = 0
            ITC6 = 0
            ITO1 = 0
            ITO5 = 0
            ALT  = '?'
            DO IA=IAS,IAF
              IF(OCCUP(IA).GT.0.0001.AND.ATM_TYPE(IA).NE.'M'.AND.
     *           ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN

                IF(ATM_NAME(IA).EQ.'C1  ') THEN
                  IF(ALT.EQ.'?'.OR.ID_ALT(IA).EQ.'.'.OR.
     *                                ALT.EQ.ID_ALT(IA)  ) THEN
                    XC1(1) = XYZ_CRD(1,IA)
                    XC1(2) = XYZ_CRD(2,IA)
                    XC1(3) = XYZ_CRD(3,IA)
                    ITC1   = 1
                    IF(ALT.EQ.'?') ALT = ID_ALT(IA)
                  ENDIF
                ELSE IF(ATM_NAME(IA).EQ.'O1  ') THEN
                  IF(ALT.EQ.'?'.OR.ID_ALT(IA).EQ.'.'.OR.
     *                                ALT.EQ.ID_ALT(IA)  ) THEN
                    XO1(1) = XYZ_CRD(1,IA)
                    XO1(2) = XYZ_CRD(2,IA)
                    XO1(3) = XYZ_CRD(3,IA)
                    ITO1   = 1
                    IF(ALT.EQ.'?') ALT = ID_ALT(IA)
                  ENDIF
                ELSE IF(ATM_NAME(IA).EQ.'C2  ') THEN
                  IF(ALT.EQ.'?'.OR.ID_ALT(IA).EQ.'.'.OR.
     *                                ALT.EQ.ID_ALT(IA)  ) THEN
                    XC2(1) = XYZ_CRD(1,IA)
                    XC2(2) = XYZ_CRD(2,IA)
                    XC2(3) = XYZ_CRD(3,IA)
                    ITC2   = 1
                    IF(ALT.EQ.'?') ALT = ID_ALT(IA)
                  ENDIF
                ELSE IF(ATM_NAME(IA).EQ.'O5  ') THEN
                  IF(ALT.EQ.'?'.OR.ID_ALT(IA).EQ.'.'.OR.
     *                                ALT.EQ.ID_ALT(IA)  ) THEN
                    XO5(1) = XYZ_CRD(1,IA)
                    XO5(2) = XYZ_CRD(2,IA)
                    XO5(3) = XYZ_CRD(3,IA)
                    ITO5   = 1
                    IF(ALT.EQ.'?') ALT = ID_ALT(IA)
                  ENDIF
                ELSE IF(ATM_NAME(IA).EQ.'C5  ') THEN
                  IF(ALT.EQ.'?'.OR.ID_ALT(IA).EQ.'.'.OR.
     *                                ALT.EQ.ID_ALT(IA)  ) THEN
                    XC5(1) = XYZ_CRD(1,IA)
                    XC5(2) = XYZ_CRD(2,IA)
                    XC5(3) = XYZ_CRD(3,IA)
                    ITC5   = 1
                    IF(ALT.EQ.'?') ALT = ID_ALT(IA)
                  ENDIF
                ELSE IF(ATM_NAME(IA).EQ.'C4  ') THEN
                  IF(ALT.EQ.'?'.OR.ID_ALT(IA).EQ.'.'.OR.
     *                                ALT.EQ.ID_ALT(IA)  ) THEN
                    XC4(1) = XYZ_CRD(1,IA)
                    XC4(2) = XYZ_CRD(2,IA)
                    XC4(3) = XYZ_CRD(3,IA)
                    ITC4   = 1
                    IF(ALT.EQ.'?') ALT = ID_ALT(IA)
                  ENDIF
                ELSE IF(ATM_NAME(IA).EQ.'C6  ') THEN
                  IF(ALT.EQ.'?'.OR.ID_ALT(IA).EQ.'.'.OR.
     *                                ALT.EQ.ID_ALT(IA)  ) THEN
                    XC6(1) = XYZ_CRD(1,IA)
                    XC6(2) = XYZ_CRD(2,IA)
                    XC6(3) = XYZ_CRD(3,IA)
                    ITC6   = 1
                    IF(ALT.EQ.'?') ALT = ID_ALT(IA)
                  ENDIF
                ENDIF
              ENDIF
            ENDDO
            IF(ITC1.NE.0.AND.ITO1.NE.0.AND.ITO5.NE.0.AND.ITC2.NE.0)THEN
C ---             check alpha or beta ?
C                 C1 - O1 - O5 - C2        PH > 0 alpha, PH < 0 beta

              CALL CALC_I_OVOL_L(ITC1,ITO1,ITO5,ITC2,XC1,XO1,XO5,XC2
     *              ,VOLOBS,PH)
              IF(PH.GE.0.0) THEN
                MON(5:5) ='a' 
              ELSE
                MON(5:5) ='b' 
              ENDIF
            ENDIF
            IF(ITC5.NE.0.AND.ITC4.NE.0.AND.ITO5.NE.0.AND.ITC6.NE.0)THEN
C ---             check L or D ?
C                 C5 - C4 - O5 - C6        PH > 0 - L , PH < 0 - D
              CALL CALC_I_OVOL_L(ITC5,ITC4,ITO5,ITC6,XC5,XC4,XO5,XC6
     *              ,VOLOBS,PH)
              IF(PH.GE.0.0) THEN
                MON(7:7) ='L' 
              ELSE
                MON(7:7) ='D' 
              ENDIF
            ENDIF

C           RES_NAME(IR) = MON

            IF(MOD_N.GE.MAXMODIF) THEN
              WRITE(LINE,
     *'('' WARNING: Number of modifications. >'',I6)') MAXMODIF
             CALL MSGDOC(MDOC,LINE)
              WRITE(LINE,
     *'(''          Change parameter MAXMODIF in "atom_com.fh"'')')
          CALL MSGDOC(MDOC,LINE)
              WRITE(LINE,
     *'(''          Now program stops to use new modifications.'')')
          CALL MSGDOC(MDOC,LINE)
              RETURN
            ENDIF

C MOD_N    - number of modifications.
C MOD_IRES - serial number of residue which was modified. 
C MOD_ICHN - chain's number of residue which was modified. 
C MOD_RNAM - standard residue name
C MOD_RNAM_NEW - actual residue name
C MOD_ID   - ID of modifications.
            
            MOD_N               = MOD_N + 1
            MOD_ID      (MOD_N) = 'RENAME'
            MOD_IRES    (MOD_N) = IR
            MOD_SEQ     (MOD_N) = RES_NUM_PDB(IR)(3:7)
C           MOD_RNAM    (MOD_N) = RES_NAME(IR)
            MOD_RNAM    (MOD_N) = MON
            MOD_RNAM_NEW(MOD_N) = RES_NAME(IR)(1:3)
            MOD_ICHN    (MOD_N) = ICH
            MOD_USED    (MOD_N) = 'N'
            MOD_FLAG    (IR)    = 'Y'


            IF(LIST.EQ.'T') THEN
              write(*,*) '==m',MOD_ID(MOD_N),RES_NUM_PDB(IR)(3:7) 
     *      ,'<',RES_NAME(IR),'><',RES_NAME(IR),'><',MON,'>'
            ENDIF

          ENDIF
 100      CONTINUE
        ENDDO
      ENDDO

      RETURN
      END

      SUBROUTINE CORR_PEPTIDE_PDB(MDOC,IERR)
C -----------------------------------------------
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'atom_com.fh'
C --- 
      REAL      XCA(3),XN(3),XC(3),XCB(3)
      CHARACTER ALT*1,MON*8
      CHARACTER LINE*256
C -----------------------------------
      IERR  = 0

      DO ICH=1,N_GROUP

        N_R = NRES_CHAIN(ICH)   

        IRS = IRES_FIRST(ICH)
        IRF = IRS + N_R - 1

        DO IR=IRS,IRF

          ITYPE  = IRES_TYPE(IR)

          IF(ITYPE.GE.3.AND.ITYPE.LE.4) THEN
C ------------------ peptide ---
C ---             check L or D ?
C PEPT-D change   CA   N   CB   C     PH > 0 L , PH < 0  D
C ----------------------------
            IAS  = IRATM_FIRST(IR)
            IAF  = IRATM_FIRST(IR)+NATM_RES(IR)-1

            IF(MOD_N.GT.0) THEN
              DO I=1,MOD_N
                IF(MOD_ID(I).EQ.'RENAME') THEN
                  IF(MOD_IRES(I).EQ.IR .AND.
     *               MOD_ICHN(I).EQ.ICH     ) GO TO 100
                ENDIF
              ENDDO
            ENDIF

            MON  = RES_NAME(IR)(1:3)

            IT1  = 0  
            IT2  = 0  
            IT3  = 0  
            IT4  = 0  
            ITCA = 0
            ITN  = 0
            ITC  = 0
            ITCB = 0
            ALT  = '?'
            DO IA=IAS,IAF
              IF(OCCUP(IA).GT.0.0001.AND.ATM_TYPE(IA).NE.'M'.AND.
     *           ATM_TYPE(IA).NE.'U'.AND.ATM_TYPE(IA).NE.'D') THEN

                IF(ATM_NAME(IA).EQ.'CA  ') THEN
                  IF(ALT.EQ.'?'.OR.ID_ALT(IA).EQ.'.'.OR.
     *                                ALT.EQ.ID_ALT(IA)  ) THEN
                    XCA(1) = XYZ_CRD(1,IA)
                    XCA(2) = XYZ_CRD(2,IA)
                    XCA(3) = XYZ_CRD(3,IA)
                    ITCA   = 1
                    IF(ALT.EQ.'?') ALT = ID_ALT(IA)
                  ENDIF
                ELSE IF(ATM_NAME(IA).EQ.'N   ') THEN
                  IF(ALT.EQ.'?'.OR.ID_ALT(IA).EQ.'.'.OR.
     *                                ALT.EQ.ID_ALT(IA)  ) THEN
                    XN(1) = XYZ_CRD(1,IA)
                    XN(2) = XYZ_CRD(2,IA)
                    XN(3) = XYZ_CRD(3,IA)
                    ITN   = 1
                    IF(ALT.EQ.'?') ALT = ID_ALT(IA)
                  ENDIF
                ELSE IF(ATM_NAME(IA).EQ.'C   ') THEN
                  IF(ALT.EQ.'?'.OR.ID_ALT(IA).EQ.'.'.OR.
     *                                ALT.EQ.ID_ALT(IA)  ) THEN
                    XC(1) = XYZ_CRD(1,IA)
                    XC(2) = XYZ_CRD(2,IA)
                    XC(3) = XYZ_CRD(3,IA)
                    ITC   = 1
                    IF(ALT.EQ.'?') ALT = ID_ALT(IA)
                  ENDIF
                ELSE IF(ATM_NAME(IA).EQ.'CB  ') THEN
                  IF(ALT.EQ.'?'.OR.ID_ALT(IA).EQ.'.'.OR.
     *                                ALT.EQ.ID_ALT(IA)  ) THEN
                    XCB(1) = XYZ_CRD(1,IA)
                    XCB(2) = XYZ_CRD(2,IA)
                    XCB(3) = XYZ_CRD(3,IA)
                    ITCB   = 1
                    IF(ALT.EQ.'?') ALT = ID_ALT(IA)
                  ENDIF
                ENDIF
              ENDIF
            ENDDO
            IF(ITCA.NE.0.AND.ITN.NE.0.AND.ITC.NE.0.AND.ITCB.NE.0)THEN
              CALL CALC_I_OVOL_L(ITCA,ITN,ITCB,ITC,XCA,XN,XCB,XC
     *              ,VOLOBS,PH)
              IF(PH.GE.0.0) THEN

              ELSE
                IF(MON.NE.'DAL'.AND.MON.NE.'DVA'.AND.
     *             MON.NE.'DPN'.AND.MON.NE.'DPR'.AND.
     *             MON.NE.'DTR'.AND.MON.NE.'DLE'     ) THEN

                  MON(4:5) ='-D' 
                ENDIF
                WRITE(LINE,
     * '('' WARNING : D-peptide : '',A,'' '',A,'' chain:'',A)') 
     *          MON(1:3),RES_NUM_PDB(IR)(3:7),RES_NUM_PDB(IR)(8:11)
                CALL MSGDOC(MDOC,LINE)
              ENDIF
            ENDIF

            RES_NAME(IR) = MON

          ENDIF
 100      CONTINUE
        ENDDO
      ENDDO

      RETURN
      END

      SUBROUTINE CHECK_NUM_IN_CHAIN(MDOC,IERR)
C -----------------------------------------------
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C --- 
      CHARACTER LINE*256,CH12I*12,CH12J*12
C -----------------------------------
      IERR  = 0

      L1 = 8
      L2 = 8
      IF(CR_SEGFLAG.EQ.'Y') L2 = 11

      DO ICH=1,N_GROUP

        N_R = NRES_CHAIN(ICH)   
         
        IF(N_R.GT.1) THEN

          IRS = IRES_FIRST(ICH)
          IRF = IRS + N_R - 1

          DO IR1=IRS,IRF-1
            CH12I = RES_NUM_PDB(IR1)
            DO IR2=IR1+1,IRF
              CH12J = RES_NUM_PDB(IR2)
              IF(CH12I(3:7).EQ.CH12J(3:7)) THEN
                WRITE(LINE,'(''ERROR: in chain '',A,'' residue:'',A)')
     *          CH12I(L1:L2),CH12I(3:7)
                CALL MSGERR(MDOC,LINE)
                LINE =
     *          '       different residues have the same number'
                CALL MSGERR(MDOC,LINE)
                IERR = 6
              ENDIF
            ENDDO        
          ENDDO

        ENDIF

      ENDDO

      RETURN
      END

      SUBROUTINE CORR_NUMBER_CHAIN_PDB(MDOC,LIST,IERR)
C -----------------------------------------------
      INTEGER*4 MDOC,IERR
C ---
      INCLUDE 'atom_com.fh'
      INCLUDE 'crd_com.fh'
C --- 
      CHARACTER LINE*256,GROUP_OLD*4,GROUP*4,PNUM*12,LIST*1
C -----------------------------------
      IERR  = 0
      IF(N_GROUP.LE.1) RETURN
C
      N_GROUP_NEW = 1
      I_NCS(1)    = 1
      GROUP_OLD   = GROUP_ID(1)
      N_R         = NRES_CHAIN(1)   
      IRS         = IRES_FIRST(1)
      IRF         = IRS + N_R - 1
      IR_TYPE_S_OLD = IRES_TYPE(IRS)
      IR_TYPE_F_OLD = IRES_TYPE(IRF)
      ITERM_S_OLD = ITERM_S_TYPE(1)
      ITERM_F_OLD = ITERM_F_TYPE(1)

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '--group 1:',GROUP_OLD
        WRITE(*,*) '  term :',ITERM_S_OLD,ITERM_F_OLD
        WRITE(*,*) '  type :',IR_TYPE_S_OLD,IR_TYPE_F_OLD
        WRITE(*,*) '--------'
      ENDIF
            
      DO IG=2,N_GROUP
        N_R       = NRES_CHAIN(IG)   
        IRS       = IRES_FIRST(IG)
        IRF       = IRS + N_R - 1
        IR_TYPE_S = IRES_TYPE(IRS)
        IR_TYPE_F = IRES_TYPE(IRF)
        ITERM_S   = ITERM_S_TYPE(IG)
        ITERM_F   = ITERM_F_TYPE(IG)
        GROUP     = GROUP_ID(IG)
        INEW      = 1
        IF(LIST.EQ.'T') THEN
          WRITE(*,*) '--group:',ig,GROUP
          WRITE(*,*) '  term :',ITERM_S,ITERM_F
          WRITE(*,*) '  type :',IR_TYPE_S,IR_TYPE_F
        ENDIF
        IF(GROUP(1:4).EQ.GROUP_OLD(1:4)) THEN
          IF(ITERM_F_OLD.NE.2.AND.ITERM_S.NE.4) THEN
            IF(IR_TYPE_F_OLD.EQ.3.OR.IR_TYPE_F_OLD.EQ.4) THEN
              IF(IR_TYPE_S.EQ.3.OR.IR_TYPE_S.EQ.4.OR.IR_TYPE_S.EQ.10)
     *          INEW = 0              
            ELSE IF(IR_TYPE_F_OLD.EQ.10) THEN
              IF(IR_TYPE_S.EQ.3.OR.IR_TYPE_S.EQ.4)
     *          INEW = 0              
            ELSE IF(IR_TYPE_F_OLD.EQ.5.OR.IR_TYPE_F_OLD.EQ.6) THEN
              IF(IR_TYPE_S.EQ.5.OR.IR_TYPE_S.EQ.6)
     *          INEW = 0              
            ELSE IF(IR_TYPE_F_OLD.EQ.9) THEN
              IF(IR_TYPE_S.EQ.9)
     *          INEW = 0        
            ENDIF      
          ENDIF
        ENDIF

        IF(LIST.EQ.'T') THEN
          WRITE(*,*) '--  new:',inew
        ENDIF

        IF(INEW.EQ.1) THEN
          N_GROUP_NEW = N_GROUP_NEW + 1
          I_NCS(IG)   = N_GROUP_NEW
        ELSE
          I_NCS(IG)   = N_GROUP_NEW
        ENDIF
        IR_TYPE_S_OLD = IR_TYPE_S
        IR_TYPE_F_OLD = IR_TYPE_F
        ITERM_S_OLD   = ITERM_S
        ITERM_F_OLD   = ITERM_F
        GROUP_OLD     = GROUP
      ENDDO
C ----
      IG_OLD    = 1
      IC_OLD    = 1
      IRSER_OLD = IRES_SERIAL(1)
      IADD      = 0
      DO IR=2,N_RESIDUE
        IC          = I_CHAIN(IR)
        IG          = I_NCS(IC)        
        I_CHAIN(IR) = IG
        PNUM        = RES_NUM_PDB(IR)
        ITYPE       = IRES_TYPE(IR)
        IRES_FORW(IR) = 0 
        IF(IC.NE.IC_OLD) THEN
          IADD = IRSER_OLD
        ENDIF
        IF(IG.NE.IG_OLD) THEN
          IRES_BACK(IR)   = -1   
          IADD = 0
          ICH0 = IG
          IF(ICH0.GT.9) ICH0 = 0
          WRITE(PNUM(2:2),'(I1)') ICH0
          IF(CR_SEGFLAG.EQ.'Y') THEN
            PNUM(12:12) = PNUM(2:2)
          ELSE
            PNUM(9:9) = PNUM(2:2)
          ENDIF
        ELSE
          IRES_BACK(IR)   = IR-1 
          IRES_FORW(IR-1) = IR 
          IF(IC.NE.IC_OLD) THEN
            ICONN_TYPE(IR) = 1
            IDELTA = IRES_SERIAL(IR)  - IRSER_OLD 
            IF(ITYPE.EQ.3.OR.ITYPE.EQ.4.OR.ITYPE.EQ.10) THEN
              ICONN_TYPE(IR) = 2
              IF(RES_NAME(IR).EQ.'PRO'  .OR.
     *           RES_NAME(IR).EQ.'5HP'  .OR.
     *           RES_NAME(IR).EQ.'PCA'  .OR.
     *           RES_NAME(IR).EQ.'DPR'  .OR.
     *           RES_NAME(IR).EQ.'PRO-D'.OR.
     *           RES_NAME(IR).EQ.'5HP-D'.OR.
     *           RES_NAME(IR).EQ.'HYP-D'.OR.
     *           RES_NAME(IR).EQ.'HYP'      ) 
     *        ICONN_TYPE(IR) = 36
              IF(RES_NAME(IR).EQ.'BMT'  .OR.
     *           RES_NAME(IR).EQ.'SAR'  .OR.
     *           RES_NAME(IR).EQ.'MLE'  .OR.
     *           RES_NAME(IR).EQ.'MVA'      ) 
     *        ICONN_TYPE(IR) = 38
              IF(IDELTA.GT.1) ICONN_TYPE(IR) = 10
C             gap
            ELSE IF(ITYPE.EQ.5.OR.ITYPE.EQ.6) THEN
              ICONN_TYPE(IR) = 4
              IF(IDELTA.GT.1) ICONN_TYPE(IR) = 10
C              gap
            ELSE IF(ITYPE.EQ.7.OR.ITYPE.EQ.8) THEN
              ICONN_TYPE(IR) = 11
            ENDIF
          ENDIF
        ENDIF
        IRSER_OLD       = IRES_SERIAL(IR)
        IRES_SERIAL(IR) = IRES_SERIAL(IR) + IADD
        RES_NUM_PDB(IR) = PNUM   
        IG_OLD = IG
        IC_OLD = IC
      ENDDO   
C ----
      IF(MOD_N.GT.0) THEN
        DO IM=1,MOD_N
         IC = MOD_ICHN(IM)
         MOD_ICHN(IM) = I_NCS(IC) 
        ENDDO
      ENDIF
      IF(LN_N.GT.0) THEN
        DO IL=1,LN_N
          IC = LN_1ICHN(IL)
          LN_1ICHN(IL) = I_NCS(IC) 
          IC = LN_2ICHN(IL)
          LN_2ICHN(IL) = I_NCS(IC) 
        ENDDO
      ENDIF
C ----
      N_GROUP = 0 
      IC_OLD  = 0

      IF(LIST.EQ.'T') THEN
        WRITE(*,*) '--new group definition --'
      ENDIF
      DO IR=1,N_RESIDUE
        IC     = I_CHAIN    (IR)
        PNUM   = RES_NUM_PDB(IR)
        NR     = NATM_RES   (IR)
        IAS    = IRATM_FIRST(IR)
        IAF    = IAS + NR - 1
        ITYPE  = IRES_TYPE  (IR)

        IF(IC.NE.IC_OLD) THEN
          N_GROUP               = N_GROUP + 1
          IRES_FIRST  (N_GROUP) = IR
          NRES_CHAIN  (N_GROUP) = 0          
          CHAIN_ID    (N_GROUP) = PNUM(8:11)
          NATM_CHAIN  (N_GROUP) = 0
          ITERM_S_TYPE(N_GROUP) = 1
          ITERM_F_TYPE(N_GROUP) = 1
          ICH_TYPE    (N_GROUP) = 1
          NATM_CHAIN(N_GROUP)   = 0
          IRES_START_TREE(N_GROUP) = IR 
          ICHAIN_GRP  (N_GROUP) = N_GROUP
          IATOM_FIRST (N_GROUP) = IAS 
          I_NCS       (N_GROUP) = 0
          NCS_FLAG    (N_GROUP) = '.'
          GROUP_ID    (N_GROUP) = PNUM(8:11)
        ENDIF
        NATM_CHAIN(N_GROUP)    = NATM_CHAIN(N_GROUP) + NR
        NRES_CHAIN(N_GROUP)    = NRES_CHAIN(N_GROUP) + 1
        IRES_END_TREE(N_GROUP) = IR 

        IF(NRES_CHAIN(N_GROUP).LE.1) THEN
          ICH_TYPE(N_GROUP) = 2
        ELSE
          ICH_TYPE    (N_GROUP) = 10
          IF(ITYPE.EQ.3.OR.ITYPE.EQ.4.OR.ITYPE.EQ.10) THEN
            ICH_TYPE    (N_GROUP) = 3
          ELSE IF(ITYPE.EQ.5.OR.ITYPE.EQ.6) THEN
            ICH_TYPE    (N_GROUP) = 5
          ELSE IF(ITYPE.EQ.7.OR.ITYPE.EQ.8) THEN
            ICH_TYPE    (N_GROUP) = 7
          ENDIF
        ENDIF
        IF(RES_NAME(IR).EQ.'HOH'.OR.RES_NAME(IR).EQ.'DOD'.OR.
     *     RES_NAME(IR).EQ.'DUM') THEN
          ICH_TYPE(N_GROUP)     = 9
        ENDIF
        IF(IC.NE.IC_OLD) THEN
          IF(LIST.EQ.'T') THEN
            WRITE(*,*) 'group:',N_GROUP,'<',GROUP_ID(N_GROUP),'>'
     *      ,ICH_TYPE(N_GROUP)
          ENDIF
        ENDIF

        IF(LIST.EQ.'T') THEN
          WRITE(*,*) '--IR:',IR,IC,'<',PNUM,'>',ITYPE
        ENDIF

        IC_OLD = IC

      ENDDO      
C ----
      RETURN
      END
