      subroutine local_tls_rest(sum_tmp,max_mat,max_vec,a_mat,vect,
     &            max_dist,n_target,n_object,nsym_dist,nw_uval)

      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'vitals.fh'
      include 'celsym.fh'
c
      real sum_tmp
      integer max_mat,max_vec
      real a_mat(*),vect(*)
      integer max_dist
      integer n_target(*),n_object(*),nsym_dist(4,*),nw_uval(*)
c
      integer maxrest
      integer, allocatable :: nrest_per_atom(:)
      integer, allocatable :: rest_per_atom(:,:)
      integer, allocatable :: symm_per_atom(:,:,:)
c
      real, allocatable :: tmat_loc(:,:)
      real, allocatable :: lmat_loc(:,:)
      real, allocatable :: smat_loc(:,:)
      real, allocatable :: u_estim(:,:)
c
      integer, allocatable :: lposv(:)
      integer, allocatable :: lposm(:)
c
      integer iposu1,iposu2,iposm,ian
      integer i,j,ia,ndist,im
c
      real wtt,delta
      real dfda(6),d2fda2(6,6),dadu(6)
      real u1v(6),u2v(6),u1(3,3),u2(3,3),u12(3,3)
c
      real trace_matmul_r
c
c
      allocate(nrest_per_atom(n_atom))
      call find_max_neighbours(maxrest,n_atom,nrest_per_atom,ndist,
     &     n_target,n_object)

      allocate(rest_per_atom(maxrest,n_atom))
      allocate(symm_per_atom(4,maxrest,n_atom))

      call find_all_neighours(maxrest,n_atom,nrest_per_atom,
     &     rest_per_atom,
     &     symm_per_atom,ndist,n_target,n_object,nsym_dist,
     &     maxsym,NumSymmetry,RealSymmMatrx)
c
      allocate(tmat_loc(6,n_atom))
      allocate(lmat_loc(6,n_atom))
      allocate(smat_loc(8,n_atom))
c
      ndist = ndis
      call local_tls_fit(tmat_loc,lmat_loc,smat_loc,ndist,
     &     n_target,n_object,nsym_dist)

      allocate(u_estim(6,n_atom))
      call local_tls2aniso(u_estim,tmat_loc,lmat_loc,smat_loc,maxrest,
     &     symm_per_atom,nrest_per_atom)

      allocate(lposv(n_atom))
      allocate(lposm(n_atom))
      call find_pos_of_u(maxatom,n_atom_mod,atom_ref_mod_flag,
     &     u_aniso_mod,lposv,lposm,1)
      im = 1
      sum_tmp = 0.0
      do ia=1,n_atom

         u1v = u_aniso_mod(1:6,ia,im)
         call aniso_vect2mat(u1v,u1)
         u2v = u_estim(1:6,ia)
         call aniso_vect2mat(u2v,u2)
         u12 = u1-u2
         delta = trace_matmul_r(3,u12,u12)
         sum_tmp = sum_tmp + 0.5*wtt*delta
         dfda(1:6) = u1v-u2v
         dfda(4:6) = 2.0*dfda(4:6)
         d2fda2(1:6,1:6) = 0.0
         do i=1,3
            d2fda2(1:3,1:3) = 1.0
            d2fda2(4:6,4:6) = 2.0
         enddo
         dadu(1:6) = 1.0
         dfda = wtt*dfda
         d2fda2 = wtt*d2fda2
         iposu1 = lposv(ia)
         iposu2 = iposu1+5
         iposm = lposm(ia)
         vect(iposu1:iposu2) = vect(iposu1:iposu2) + dfda(1:6)*dadu(1:6)
         do ian=1,6
            a_mat(iposm+ian-1) = a_mat(iposm+ian-1) + 
     &           d2fda2(ian,ian)*dadu(ian)*dadu(ian)
         enddo
      enddo

      deallocate(lposv)
      deallocate(lposm)
      deallocate(nrest_per_atom)
      deallocate(rest_per_atom)
      deallocate(symm_per_atom)
      deallocate(u_estim)
      deallocate(tmat_loc)
      deallocate(lmat_loc)
      deallocate(smat_loc)
      return
      end
c
      subroutine local_tls_fit(tmat_loc,lmat_loc,smat_loc,maxrest,
     &     symm_per_atom,nrest_per_atom)
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'celsym.fh'
c
c---  This routine estimates local tls parameters for each atom.
c---  The number of atoms should be sufficient for this estimate to be reliable
c---  
      real tmat_loc(20,n_atom),lmat_loc(20,n_atom),smat_loc(8,n_atom)
      integer maxrest
      integer nrest_per_atom(n_atom),rest_per_atom(maxrest,n_atom)
      integer symm_per_atom(4,maxrest,n_atom)

      real ro_unit(3,3),rfr_unit(3,3)
      real rsymm_ort(3,3,192)
      integer i,j,k,l,ia,ir,in,im,is,isym,ierror
      real xyz_this(3),xyz_ort(3),xyz_neighbour(3),xyz1(3),xyz2(3)
      real u2v(6),u2(3,3),tmp(3,3)
      real dfdu(6),d2fdu2(6,6)
      real d2fd2(6,20)
      real dudtls(6,20)
      real*8 :: toler=1.0d-7
      real*8 dfdtls(20),d2fdtls2(20,20),shft_tls(20)
      real :: nwork_space = 1000
      real*8 workspace(1000)
c
c---  body 
c---  body
      call find_ort_symm(cs_nsym,cs_m_cs(1:3,1:3,1:cs_nsym),
     &     cs_v_cs(1:3,1:cs_nsym),cs_cell,rsymm_ort(1:3,1:3,1:cs_nsym))
         
      d2fdu2(1:6,1:6) = 0.0
      do i=1,3
         d2fdu2(i,i)     = 1.0
         d2fdu2(i+3,i+3) = 2.0
      enddo      
      im = 1
      do ia=1,n_atom
c
c---Central atom
         xyz_ort(1:3) = 0.0
         call derivs_wrt_tls(xyz_ort,dudtls)
         dfdu = u_aniso_mod(1:6,ia,im)
         dfdu(4:6) = 2.0*dfdu(4:6)
         do i=1,20
            dfdtls(i) = sum(dfdu(1:6)*dudtls(1:6,i))
         enddo
         do l=1,20
            do j=1,6
               d2fd2(l,j) = sum(d2fdu2(1:6,j)*dudtls(1:6,l))
            enddo
         enddo
         do k=1,20
            do l=1,20
               d2fdtls2(k,l) = sum(d2fd2(l,1:6)*dudtls(1:6,k))
            enddo
         enddo
c
c---  Neighbouring atoms
         xyz_this = xyz_crd_mod(1:3,ia,im)

         do ir=1,nrest_per_atom(ia)
            in = rest_per_atom(ir,ia)
            xyz_neighbour(1:3) = xyz_crd_mod(1:3,in,im)

            isym = symm_per_atom(1,ir,ia)
            xyz1 = matmul(cs_ort_to_frac,xyz_neighbour)
            xyz2 = matmul(cs_m_cs(1:3,1:3,isym),xyz1)+
     &           real(cs_v_cs(1:3,isym))+real(symm_per_atom(2:4,ir,ia))
            xyz_neighbour = matmul(cs_frac_to_ort,xyz2)

            xyz_ort = xyz_neighbour(1:3)-xyz_this(1:3)
            call derivs_wrt_tls(xyz_ort,dudtls)
            u2v = u_aniso_mod(1:6,in,im)
            call aniso_vect2mat(u2v,u2)
            tmp = matmul(rsymm_ort(1:3,1:3,isym),u2)
            u2  = matmul(u2,transpose(rsymm_ort(1:3,1:3,isym)))
            call aniso_mat2vect(u2,u2v)
            dfdu(1:3) = u2v(1:3)
            dfdu(4:6) = 2.0*u2v(4:6)
            do i=1,20
               dfdtls(i) = dfdtls(i) + sum(dfdu(1:6)*dudtls(1:6,i))
            enddo
            do l=1,20
               do j=1,6
                  d2fd2(l,j) = sum(d2fdu2(1:6,j)*dudtls(1:6,j))
               enddo
            enddo
            do k=1,20
               do l=1,20
                  d2fdtls2(k,l) = d2fdtls2(k,l) + 
     &                 sum(d2fd2(l,1:6)*dudtls(1:6,k))
               enddo
            enddo
         enddo
         call deigen_filter_r(toler,d2fdtls2,20,20,dfdtls,shft_tls,
     &        workspace,nwork_space)
         tmat_loc(1:6,ia) = shft_tls(1:6)
         lmat_loc(1:6,ia) = shft_tls(7:12)
         smat_loc(1:8,ia) = shft_tls(13:20)
      enddo
c
      return
      end
