C
C     LIBCHECK
C     Copyright (C) 2000-2004 Alexei Vagin
C
C     This code is distributed under the terms and conditions of the
C     CCP4 licence agreement as `Part 2' (Annex 2) software.
C     A copy of the CCP4 licence can be obtained by writing to the
C     CCP4 Secretary, Daresbury Laboratory, Warrington WA4 4AD, UK.
C
C --- LIBCHECK.F ---
C -------------------------------------------------------
      INTEGER*4 IERR,MDOC
      CHARACTER LINE*256,MSG*1,MON*8,IND_FLAG*1,H_FLAG*1
      CHARACTER FILE_PDB*256,FILE_CIF*256,FILE_PDB_D*256
      CHARACTER FILE_CSD*256,FILE_L  *256,FILE_O    *256
      CHARACTER FILE_SMILE*256,FILE_SDF*256,FILE_MOL*256
      CHARACTER PROG_LIB_PATH*256,PROG_NAME*80,LIST*1,REF*1,COOR*1 
      CHARACTER LIBS_PATH*256,LIBS_NAME*256,LIBS_EXT*256,FILE_L2*256 
      CHARACTER NODIST*1,SRCH*1,LCOOR*1
c
c----  version report and all that
      character txt(2)*512
C ---
      INCLUDE 'libcheck_version.fh'
C ===========================
      M    = 0
      IERR = 0
      CALL GET_PATH(M,'CLIBD_MON',LINE,IERR)
C     CALL GET_PATH(M,'MAKECIF',LINE,IERR)
      CALL LENSTR_BL(LINE,LEN)
      IF(LEN.GT.0) THEN
C       PROG_LIB_PATH = LINE(1:LEN)//'/dic/'
        PROG_LIB_PATH = LINE(1:LEN)
      ELSE
        PROG_LIB_PATH = ' '
      ENDIF
C ---------------------------
      LIBS_PATH = ' '
      LIBS_NAME = ' '
      LIBS_EXT  = ' ' 
      PROG_NAME = 'libcheck'
      CALL SET_PATH_PROG_PARM(PROG_LIB_PATH,PROG_NAME
     *                         ,LIBS_PATH,LIBS_NAME,LIBS_EXT)
C ===========================
      IERR  = 0
      M     = 0
      IG    = 0
      CALL START_CCP4
      CALL START(IG,M,PROG_NAME)
C ---------------------------
      CALL MSGDOC(M,' ')
      CALL MSGDOC(M,VERSION)
      CALL MSGDOC(M,' ')
      CALL MSGDOC(M,' ')
      call getarg(0,txt(1))
      nargc = iargc()
      if(nargc.gt.0) then
         do i=1,nargc
           call getarg(i,txt(1))
           if(trim(txt(1)).eq.'-I'.or.trim(txt(1)).eq.'-i') then
              call finish
              stop
           endif
         enddo
      endif
C -------------------------------------------------------------
      CALL MSGDOC(M,
     *' Do you want to have FILE-DOCUMENT /libcheck.doc/ ? /<N>/Y/A :')
      CALL MSGDOC(M,'   N - means without DOC-file')
      CALL MSGDOC(M,'   Y - with new contents')
      CALL MSGDOC(M,
     *'   A - means to keep old contents and add new information')
      CALL MSGDOC(M,
     *'       with DOC-file program creates batch file: libcheck.bat')
      CALL DISPL_BL('_DOC:')
      READ(*,'(A)') LINE

      IBATCH = 0
      IF(LINE(1:4).EQ.'_DOC') THEN
        CALL LENSTR_BL(LINE,LEN)
        IF(LEN.GE.6) THEN
          DO I=6,LEN
            IF(LINE(I:I).NE.' ') THEN
              MSG=LINE(I:I)
              GO TO 10
            ENDIF
          ENDDO
        ENDIF
  10    CONTINUE
        IBATCH = 1
      ELSE
        MSG=LINE(1:1)
      ENDIF

      IF(MSG.EQ.'y') MSG = 'Y'
      IF(MSG.EQ.'a') MSG = 'A'
      IF(MSG.NE.'Y'.AND.MSG.NE.'A'.AND.MSG.NE.'#') MSG = 'N'

      IF(MSG.NE.'N'.OR.MSG.EQ.'#') THEN
        IF(MSG.EQ.'Y') MDOC = 999
        IF(MSG.EQ.'A') MDOC = 998
        IF(MSG.EQ.'#') MDOC = 997
        CALL START(0,MDOC,PROG_NAME)
      ELSE
        MDOC=0
      ENDIF
      IF(IBATCH.EQ.1) CALL SET_BATCH(IBATCH)
      CALL MSGDOC(M,' ')
C -------------------------------------------
      ANGLE = 0.0
      ITEST = 0
      CALL MSGDOC(M,' ')
      CALL SET_DEFAULT(' ')
      CALL SET_DEFAULT('      Keywords:')
      CALL SET_DEFAULT(' ')
      CALL SET_DEFAULT(
     *'FILE_L:   < >  - additional library, " " means without this file
     *')
      CALL SET_DEFAULT(
     *'MON:      < >  - give info about this monomer')
      CALL SET_DEFAULT(
     *'                 if = * , give list all monomers in the library')
      CALL SET_DEFAULT(
     *'FILE_PDB: < >  - input PDB_file  ," " means without this file')
      CALL SET_DEFAULT(
     *'FILE_SMILE: < >  - input SMILE_file  ," " means without this fil
     *e')
      CALL SET_DEFAULT(
     &'FILE_SDF:   < > - input SDF file, " " means without this file')
      CALL SET_DEFAULT(
     &'FILE_MOL:   < > - input MOL file, " " means without this file')
      CALL SET_DEFAULT(
     *'                   use keyword MON as compound_id')
c      CALL SET_DEFAULT(
c     *'FILE_DIC: < >  - input PDB_DICT_file ," " means without this file
c     *')
      CALL SET_DEFAULT(
     *'FILE_CIF: < >  - input CIFile    ," " means without this file')
      CALL SET_DEFAULT(
     *'FILE_CSD: < >  - input CSD CIFile," " means without this file')
      CALL SET_DEFAULT(
     *'HFLAG: <Y>/A/N - Y - hydrogen atoms where they are')
      CALL SET_DEFAULT(
     *'                 A - with all hydrogen atoms')
      CALL SET_DEFAULT(
     *'                 N - without hydrogen atoms')
      CALL SET_DEFAULT(
     *'IND:    <N>/Y  - Y - create index of mon_lib.cif')
      CALL SET_DEFAULT(
     *'                     output file: "new_mon_lib_ind.cif"')
      CALL SET_DEFAULT(
     *'FILE_O: <libcheck > - output files /library,coords,ps/, name with
     *out') 
      CALL SET_DEFAULT(
     *'                      extention')
      CALL SET_DEFAULT(
     *'FILE_L2:  < >  - additional library (FILE_L) will be added to thi
     *s library')
      CALL SET_DEFAULT(
     *'                 in this case program performs only adding')
      CALL SET_DEFAULT(
     *'ANGLE:   <0.0> - rotation angle for picture ( around X )')
      CALL SET_DEFAULT(
     *'LIST: <M>/S/L  - S short output, L - long, M - medium')
      CALL SET_DEFAULT(
     *'REF:  <Y>/S,N,0 - 0 no refinement of new monomer')
      CALL SET_DEFAULT(
     *'                  N only crd->ang and ang->crd')
      CALL SET_DEFAULT(
     *'                  S plus torsion ref, Y plus restr.ref')
      CALL MSGDOC(M,'#')
      CALL SET_DEFAULT(
     *'TEST:   <0>    - for program testing only')
C  ITEST: 1 only BOND, 2 only ANGLE, 3 only BOND and ANGLE, 4 only VDW and HB
C         5 only tors,  6 onli chir, 7 only plan, 8 whitout VDW and HB   
C         9 whitout tors,VDW and HB 
C  ITEST < 0 whitout VDW (REF=S)  
      CALL SET_DEFAULT(
     *'COOR: <N>/Y    - use Vobs from coords instead Videal')
      CALL SET_DEFAULT(
     *'LCOOR: <Y>/N   - Y use coords from lib description')
      CALL SET_DEFAULT(
     *'NODIST: <N>/Y  - Y not read the distributed library')
      CALL SET_DEFAULT(
     *'                 (only with FILE_L)')
      CALL SET_DEFAULT(
     *'SRCH: <N>/Y/0  - Y - global search, 0 - for MON from PDB_file')
      CALL SET_DEFAULT(
     *'                 (only with NODIST = N)')
C ---
      CALL MSGDOC(M,' ')
      CALL SET_DEFAULT('?')
C -------------------------------------------
      LINE='MON'
      CALL ASK(LINE)
      MON=LINE(1:8)
      CALL CORR_FILE_NAME(MON)
      IF(MON(1:1).EQ.',') MON = ' '
C ---
      LINE='HFLAG'
      CALL ASK(LINE)
      H_FLAG=LINE(1:1)
C ---
      LINE='IND'
      CALL ASK(LINE)
      IND_FLAG=LINE(1:1)
C ---
      LINE='FILE_O'
      CALL ASK(LINE)
      FILE_O=LINE
      CALL CORR_FILE_NAME(FILE_O)
C ---
      LINE='FILE_L2'
      CALL ASK(LINE)
      FILE_L2=LINE
      CALL CORR_FILE_NAME(FILE_L2)
C ---
      LINE='FILE_L'
      CALL ASK(LINE)
      FILE_L=LINE
      CALL CORR_FILE_NAME(FILE_L)
C ---
      LINE='FILE_PDB'
      CALL ASK(LINE)
      FILE_PDB=LINE
      CALL CORR_FILE_NAME(FILE_PDB)
C ---
      LINE='FILE_SMILE'
      CALL ASK(LINE)
      FILE_SMILE=LINE
      CALL CORR_FILE_NAME(FILE_SMILE)
C ---
      LINE = 'FILE_SDF'
      CALL ASK(LINE)
      FILE_SDF = LINE
      CALL CORR_FILE_NAME(FILE_SDF)
c
c-----
      LINE = 'FILE_MOL'
      CALL ASK(LINE)
      FILE_MOL = LINE
      CALL CORR_FILE_NAME(FILE_MOL)
c      LINE='FILE_DIC'
c      CALL ASK(LINE)
c      FILE_PDB_D=LINE
c      CALL CORR_FILE_NAME(FILE_PDB_D)
C ---
      LINE='FILE_CIF'
      CALL ASK(LINE)
      FILE_CIF=LINE
      CALL CORR_FILE_NAME(FILE_CIF)
C ---
      LINE='FILE_CSD'
      CALL ASK(LINE)
      FILE_CSD=LINE
      CALL CORR_FILE_NAME(FILE_CSD)
C ---
      LINE='ANGLE'
      CALL ASK(LINE)
      READ(LINE,*) ANGLE
C ---
      LIBS_PATH = ' '
      LIBS_NAME = ' '
      LIBS_EXT  = ' ' 
C ---
      LINE='LIST'
      CALL ASK(LINE)
      LIST=LINE(1:1)
C ---
      LINE='REF'
      CALL ASK(LINE)
      REF=LINE(1:1)
C ---
      LINE='TEST'
      CALL ASK(LINE)
      READ(LINE,*) ITEST
C ---
      LINE='COOR'
      CALL ASK(LINE)
      COOR=LINE(1:1)
C ---
      LINE='LCOOR'
      CALL ASK(LINE)
      LCOOR=LINE(1:1)
C ---
      LINE='NODIST'
      CALL ASK(LINE)
      NODIST=LINE(1:1)
C ---
      LINE='SRCH'
      CALL ASK(LINE)
      SRCH=LINE(1:1)
C ---------------------------
      IERR = 0
      CALL LIBCHECK(MDOC,LIST,MON,H_FLAG,FILE_L
     * ,FILE_SMILE,FILE_SDF,FILE_MOL
     * ,FILE_PDB,FILE_CIF,FILE_CSD,FILE_PDB_D,FILE_O,ANGLE
     * ,IND_FLAG,PROG_LIB_PATH,LIBS_PATH,LIBS_NAME,LIBS_EXT
     * ,FILE_L2,PROG_NAME,REF,ITEST,COOR,LCOOR,NODIST,SRCH,IERR)
      IF(IERR.NE.0) GO TO 500    
C ---------------------------
  500 CONTINUE
      CALL FINISH
      END
