      SUBROUTINE NCSR_EQUAVALENCES
C
C---Finds NCS equavlences using keyword defined in RCARD.
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'ncs_rest.fh'
      INCLUDE 'restr_files.fh'
      include 'weights.fh'
C
c---  locals
      integer max_chain_cur
      INTEGER INCS,IRES,ICH,JRS,IR_FIRST_C,IR_LAST_C,ISP,
     &        IA_FIRST_C,IA_LAST_C,IATOM1,IATOM,IN_CH,IATOM_F,
     &        IAT_F,JAT_F,IAA_F,IAA_L,IRS_C,IRS_F,
     &        INCS_UNIT,IFAIL,LL,IWEIGHT
C
      character jrsc*4
C
c--allocatable memory
      INTEGER, allocatable :: NCS_IAT(:,:)
      integer, allocatable :: ICODE_IAT(:)
      character, allocatable :: IRS_NCS(:)*4
      integer, allocatable :: IRSATM_F(:)
      integer, allocatable :: IRATM_NCS(:)
C
      INTEGER LENSTR
      CHARACTER LINE*128
      character asmgrp*4
C
c---body

c----If keywrods have been given using group keyword then sort out in a 
c----seperate subroutine 
      incs_unit = 0
      if(ncs_inst_option.eq.'G') then
         call ncsr_equiv_group
         return
      endif
c
      max_chain_cur = 0
      do  incs=1,number_ncsr
         max_chain_cur = max(max_chain_cur,ncs_chain_num(incs))
      enddo
      allocate(ncs_iat(max_chain_cur,n_atom))
      allocate(icode_iat(n_atom))
      allocate(irs_ncs(n_atom))
      allocate(irsatm_f(n_atom))
      allocate(iratm_ncs(n_atom))
c
      call find_unique_file_name(ncsr_file_name,'_NCS_R')
C
      DO   INCS = 1,NUMBER_NCSR
C
c---Loop over NCS restraints.
C
C---Initialisations
        DO     ICH = 1,NCS_N_CHAIN(INCS)
          DO    IATOM = 1,N_ATOM
            NCS_IAT(ICH,IATOM) = 0
            ICODE_IAT(IATOM)   = 0
          ENDDO
        ENDDO
        IRS_F = 0
        IATOM1 = 0
        DO   ICH = 1,N_GROUP
C
c---Loop over chains to find first chain in the ncs restraint
           call get_asm_group_id(asmgrp,ich)
cd           write(*,*)asmgrp,NCS_CHAINS(1,INCS)
cd           stop
           IF(asmgrp.EQ.NCS_CHAINS(1,INCS)) THEN
C
C----Loop over residues in this chain
            IR_FIRST_C = IRES_FIRST(ICH)
            IR_LAST_C  = IRES_FIRST(ICH)+NRES_CHAIN(ICH)-1
            DO  IRES = IR_FIRST_C,IR_LAST_C
C
C---Check if residue is in the list of ncs sapns
               DO   ISP=1,NCS_SPANS(INCS)
C
C----find residue number from input coordinates.
                 READ(RES_NUM_PDB(IRES)(3:6),*)JRS
                 IF(JRS.GE.NCS_IRES_FIRST(ISP,INCS).AND.
     &              JRS.LE.NCS_IRES_LAST(ISP,INCS)) THEN
C
c---This residue belongs to ISPs span of INCS restraint. Save it
                   IA_FIRST_C      = IRATM_FIRST(IRES)
                   IA_LAST_C       = IA_FIRST_C + NATM_RES(IRES)-1
                   IRS_F           = IRS_F + 1
                   IRS_NCS(IRS_F)  = res_num_pdb(ires)(3:7)
                   IRSATM_F(IRS_F) = IATOM1 + 1
                   IRATM_NCS(IRS_F) = NATM_RES(IRES)
                   DO   IATOM = IA_FIRST_C,IA_LAST_C
                     IATOM1    = IATOM1 + 1
                     NCS_IAT(1,IATOM1) = IATOM
                     ICODE_IAT(IATOM1) = NCS_ICODE(ISP,INCS)
                   ENDDO
                 ENDIF
               ENDDO
             ENDDO
           ENDIF
        ENDDO
        IATOM_F = IATOM1
C
C---Now go through all other residues and find atom equavalences for the first
C---set of atoms
        IF(IRS_F.LE.0) THEN
          CALL ERRWRT(-1,'Number of atoms in chain 1 is 0')
          GOTO 900
        ENDIF
        DO   IN_CH = 2,NCS_N_CHAIN(INCS)
           IATOM1 = 0
           DO   ICH = 1,N_GROUP
C     
c---Loop over chains to find first chain in the ncs restraint
cd            WRITE(*,*)ASM_CHAIN_ID(ICH),ASM_GROUP_ID(ICH)
              call get_asm_group_id(asmgrp,ich)
              IF(asmgrp.EQ.NCS_CHAINS(IN_CH,INCS)) THEN
C     
C----Loop over residues in this chain
                 IR_FIRST_C = IRES_FIRST(ICH)
                 IR_LAST_C  = IRES_FIRST(ICH)+NRES_CHAIN(ICH)-1
                 DO  IRES = IR_FIRST_C,IR_LAST_C
C     
C---Chekc if residue is in the list of ncs sapns
                    DO   ISP=1,NCS_SPANS(INCS)
C
C----find residue number from input coordinates.
                       READ(RES_NUM_PDB(IRES)(3:6),*)JRS
                       IF(JRS.GE.NCS_IRES_FIRST(ISP,INCS).AND.
     &                      JRS.LE.NCS_IRES_LAST(ISP,INCS)) THEN
C     
c---This residue belongs to ISPs span of INCS restraint. Save it
                          jrsc = res_num_pdb(ires)(3:7)
                          DO   IRS_C = 1,IRS_F
                             IF(JRSc.EQ.IRS_NCS(IRS_C)) THEN
                                IA_FIRST_C = IRATM_FIRST(IRES)
                                IA_LAST_C  = IA_FIRST_C + 
     &                               NATM_RES(IRES)-1
                                DO   IATOM = IA_FIRST_C,IA_LAST_C
C---If this atom is in the first set. Then make them equavalent
C
                                   IAA_F = IRSATM_F(IRS_C)
                                   IAA_L = IAA_F + IRATM_NCS(IRS_C)-1
                                   DO    IAT_F = IAA_F,IAA_L
                                      JAT_F = NCS_IAT(1,IAT_F)
                                      IF(RES_NAME(I_RESID(JAT_F)).EQ.
     &                                     RES_NAME(I_RESID(IATOM))) 
     &                                                         THEN
                                         IF(ATM_NAME(IATOM).EQ.
     &                                        ATM_NAME(JAT_F).AND.
     &                                        ID_ALT(IATOM).EQ.
     &                                        ID_ALT(JAT_F))       THEN
                                            NCS_IAT(IN_CH,IAT_F)=IATOM
                                            IATOM1    = IATOM1 + 1
                                            GOTO 100
                                         ENDIF
                                      ENDIF
                                   ENDDO
 100                               CONTINUE
                                ENDDO
                             ENDIF
                          ENDDO
                       ENDIF
                    ENDDO
                 ENDDO
              ENDIF
           ENDDO
c
c---If one of chains have no atoms then skip this NCS
c     d          WRITE(*,*)'Chain ',IN_CH,IATOM1
           IF(IATOM1.LE.0) THEN
              CALL ERRWRT(-1,'One of the chains is empty')
              GOTO 900
           ENDIF
        ENDDO
C
C---count number of the equivalent atoms
        IATOM1 = 0
        DO   IATOM=1,IATOM_F
           DO    ICH = 1,NCS_N_CHAIN(INCS)
C
c---If 0 atom skip it
              IF(NCS_IAT(ICH,IATOM).LE.0) GOTO 200
C
C---If 0 occupancy skip it
              IF(OCCUP(NCS_IAT(ICH,IATOM)).LE.0.0) GOTO 200
           ENDDO
           IATOM1 = IATOM1 + 1
 200       CONTINUE
        ENDDO
        IF(IATOM1.LE.0) THEN 
          CALL ERRWRT(-1,'Number of equivalent atoms is 0')
          GOTO 900
        ENDIF
C
C---Number of equivalents is 0. Skip this NCS
C
C---Write atoms to output file for further use. For example in the subroutine 
C---NCS_REF
C---If file has not been opened then open it
cd        WRITE(*,*)'Number of equivalent atoms ',IATOM1
        IF(INCS_UNIT.LE.0) then
           call open_unform_file(incs_unit,ncsr_file_name,ifail)
           write(incs_unit)number_ncsr
        endif
        WRITE(INCS_UNIT)IATOM1,ncs_n_chain(incs)
        DO   IATOM=1,IATOM_F
          DO    ICH = 1,NCS_N_CHAIN(INCS)
C
c---If 0 atom skip it
             IF(NCS_IAT(ICH,IATOM).LE.0) GOTO 300
             IF(OCCUP(NCS_IAT(ICH,IATOM)).LE.0.0) GOTO 300

C
C---If 0 occupancy skip it
c             IF(OCCUP(NCS_IAT(ICH,IATOM)).LE.0.0) GOTO 300
          ENDDO
          CALL NCS_CODE2WEIGHT(ATM_NAME(NCS_IAT(1,IATOM)),
     &         ICODE_IAT(IATOM),IWEIGHT)
          WRITE(INCS_UNIT)IWEIGHT,sigs(iweight),sigs(iweight+3),
     &         (NCS_IAT(IAT_F,IATOM),IAT_F=1,NCS_N_CHAIN(INCS))
 300      CONTINUE
       ENDDO 
       GOTO 910
 900   CONTINUE
       CALL ERRWRT(-1,' ')
       CALL ERRWRT(-1,' ')
       WRITE(LINE,'(A,I12)')'Problem with NCS restraints ',INCS
       CALL ERRWRT(-1,LINE)
       CALL ERRWRT(-1,'Check NCSR/NONX line in input file')
       CALL ERRWRT(1,'Problem with NCS')
 910   CONTINUE
      ENDDO
      CLOSE(UNIT=INCS_UNIT)
c
      deallocate(ncs_iat)
      deallocate(icode_iat)
      deallocate(irs_ncs)
      deallocate(irsatm_f)
      deallocate(iratm_ncs)

      RETURN
      END
c
      subroutine ncsr_equiv_group
      implicit none
      include 'ncs_rest.fh'
      include 'atom_com.fh'
      include 'restr_files.fh'
c
c---locals
      integer j,ia,ja,jat,incs,max_cur_chain
      integer iatom1,iatom_f,irs_s,irs_f
      integer ich,ie,ir,jr,ir_f,ir_l
      integer ia_f,ia_l,ja_f,ja_l
      integer l,inch,jrs
      integer incs_unit,ifail,ll
      character asmgrp*4,jrsc*4
c
c---allocatable memory
      integer, allocatable :: ncs_iat(:,:)
      character, allocatable :: irs_ncs(:)*4
      integer, allocatable :: irsfatm_f(:)
      integer, allocatable :: iratm_ncs(:)
      integer, allocatable :: res_ref_ncs(:)
c
c---Externals
      integer lenstr
      external lenstr
c
c---body

      call find_unique_file_name(ncsr_file_name,'_NCS_R')
      call open_unform_file(incs_unit,ncsr_file_name,ifail)
      write(incs_unit)number_ncsr
c
      max_cur_chain = 0
      do  incs=1,number_ncsr
         max_cur_chain = max(max_cur_chain,ncs_chain_num(incs))
      enddo
      allocate(ncs_iat(max_cur_chain,n_atom))
      allocate(irs_ncs(n_residue))
      allocate(irsfatm_f(n_atom))
      allocate(iratm_ncs(n_atom))
      allocate(res_ref_ncs(n_atom))
c
      do  incs=1,number_ncsr
c
c---  Find chain (segid) names for 1st element in the equivalents of 
c---  ncs groupps
         iatom1 = 0
         irs_f  = 0
         do  ie=1,ncs_equiv_num(incs)
            irs_s=irs_f + 1
            do  ich=1,n_group
               call get_asm_group_id(asmgrp,ich)
               if(asmgrp.eq.ncs_equiv_ch(1,ie,incs)) then
                  ir_f = ires_first(ich)
                  ir_l  = ir_f  + nres_chain(ich)-1
                  do  ir=ir_f,ir_l
                     read(res_num_pdb(ir)(3:6),*)jrs
                     if(jrs.ge.ncs_equiv_res(1,ie,incs).and.
     &                    jrs.le.ncs_equiv_res(2,ie,incs)) then
                        ia_f = iratm_first(ir)
                        ia_l  = ia_f + natm_res(ir)-1
                        irs_f = irs_f + 1
                        irs_ncs(irs_f) = res_num_pdb(ir)(3:7)
                        irsfatm_f(irs_f) = iatom1 + 1
                        iratm_ncs(irs_f) = natm_res(ir)
                        res_ref_ncs(irs_f) = ir
                        do  ia=ia_f,ia_l
                           iatom1 = iatom1+1
                           ncs_iat(1,iatom1)=ia
                        enddo
                     endif
                  enddo
                  goto 100
               endif
            enddo
 100        continue
            iatom_f = iatom1
            if(irs_f.ge.irs_s) then
               do  inch=2,ncs_chain_num(incs)
                  do  ich=1,n_group
                     call get_asm_group_id(asmgrp,ich)
                     if(asmgrp.eq.ncs_equiv_ch(inch,ie,incs)) then
                        ir_f = ires_first(ich)
                        ir_l  = ir_f + nres_chain(ich)-1
                        do jr=irs_s,irs_f
                           do ir=ir_f,ir_l
                              read(res_num_pdb(ir)(3:6),*)jrs
                              if(jrs.ge.ncs_equiv_res(1,ie,incs).and.
     &                             jrs.le.ncs_equiv_res(2,ie,incs)) 
     &                                                            then
                                 jrsc=res_num_pdb(ir)(3:7)
                                 if(jrsc.eq.irs_ncs(jr).and.
     &                                res_name(ir).eq.
     &                                res_name(res_ref_ncs(jr))) then
                                    ia_f = iratm_first(ir)
                                    ia_l = ia_f + natm_res(ir)-1
                                    ja_f = irsfatm_f(jr)
                                    ja_l = ja_f+iratm_ncs(jr)-1
                                    do ja=ja_f,ja_l
                                       jat=ncs_iat(1,ja)
                                       do  ia=ia_f,ia_l
                                          if(atm_name(ia).eq.
     &                                       atm_name(jat).and.
     &                                       id_alt(ia).eq.id_alt(jat)) 
     &                                                            then
                                             ncs_iat(inch,ja)=ia
                                             goto 200
                                          endif
                                       enddo
 200                                   continue
                                    enddo
                                    goto 220
                                 endif
                              endif
                           enddo
 220                       continue
                        enddo
                        goto 250
                     endif
                  enddo
 250              continue
               enddo
            endif
         enddo
         if(iatom_f.le.0) then
            call errwrt(-1,'Problem with ncs definitions')
            call errwrt(-1,'Number of equivalent atoms equal to 0') 
            call errwrt(1,'Definition of ncs for group '
     &           //ncs_ids(incs)//' is not correct')
         else
            iatom1 = 0
            do  ia=1,iatom_f
               do  j=1,ncs_chain_num(incs)
                  if(ncs_iat(j,ia).le.0) then
                     goto 300
                  endif
                  if(occup(ncs_iat(j,ia)).le.0.0) then
                     goto 300
                  endif
               enddo
               iatom1 = iatom1 + 1
 300           continue
            enddo
            write(incs_unit)iatom1,ncs_chain_num(incs)
            do  ia=1,iatom_f
               do  j=1,ncs_chain_num(incs)
                  if(ncs_iat(j,ia).le.0) goto 400
                  if(occup(ncs_iat(j,ia)).le.0.0) goto 400
               enddo
               write(incs_unit)ncs_icode(ie,incs),
     &              sigx_ncs(incs),sigb_ncs(incs),
     &              (ncs_iat(j,ia),j=1,ncs_chain_num(incs))
 400           continue
            enddo
         endif
      enddo
c
c---deallocate and close
      deallocate(ncs_iat)
      deallocate(irs_ncs)
      deallocate(irsfatm_f)
      deallocate(iratm_ncs)
      deallocate(res_ref_ncs)
      close(incs_unit)
c
c--Process last errors
      return
      end
C
      SUBROUTINE NCS_CODE2WEIGHT(ATOM_NAME,ICODE,IWEIGHT)
c
c---Converts NCS restratint codes to restraint weighting numbers.
C
      IMPLICIT NONE
      INTEGER ICODE,IWEIGHT
      CHARACTER ATOM_NAME*(*)
C
      CHARACTER SIDE_OR_MAIN*1
      IF(ICODE.LT.1) ICODE = 1
      IF(ICODE.GT.6) ICODE = 6
C
      IF(ICODE.EQ.1) THEN
        IWEIGHT = 1
      ELSEIF(ICODE.EQ.4) THEN
        IWEIGHT = 2
      ELSEIF(ICODE.EQ.6) THEN
        IWEIGHT = 3
      ELSE
C
C---Check if atom is main or side chain
        CALL CHECK_SIDE_OR_MAIN(ATOM_NAME,SIDE_OR_MAIN)
        IF(ICODE.EQ.2.AND.SIDE_OR_MAIN.EQ.'M') THEN
          IWEIGHT = 1
        ELSEIF(ICODE.EQ.2.AND.SIDE_OR_MAIN.NE.'M') THEN
          IWEIGHT = 2
        ELSEIF(ICODE.EQ.3.AND.SIDE_OR_MAIN.EQ.'M') THEN
          IWEIGHT = 1
        ELSEIF(ICODE.EQ.3.AND.SIDE_OR_MAIN.NE.'M') THEN
          IWEIGHT = 3
        ELSEIF(ICODE.EQ.5.AND.SIDE_OR_MAIN.EQ.'M') THEN
          IWEIGHT = 2
        ELSEIF(ICODE.EQ.5.AND.SIDE_OR_MAIN.NE.'M') THEN
          IWEIGHT = 3
        ENDIF
      ENDIF
      RETURN
      END
C
      SUBROUTINE CHECK_SIDE_OR_MAIN(ATOM_NAME,SIDE_OR_MAIN)
C
C---Checks if atom is side or main chain atom
      IMPLICIT NONE
      CHARACTER ATOM_NAME*(*),SIDE_OR_MAIN*(*)
C
      SIDE_OR_MAIN = 'S'
      IF(ATOM_NAME(1:4).EQ.'CA  '.OR.ATOM_NAME(1:4).EQ.'N   '.OR.
     &   ATOM_NAME(1:4).EQ.'C   '.OR.ATOM_NAME(1:4).EQ.'O   '.OR.
     &   ATOM_NAME(1:4).EQ.'H   '.OR.ATOM_NAME(1:4).EQ.'HA  ')
     &             SIDE_OR_MAIN='M'
      RETURN
      END
c
      subroutine ncs_local_define
      implicit none
      include 'atom_com.fh'
      include 'restr_files.fh'
c
c---  Using correspondence between atoms create a file of local similarity.
c--   Input file is file of ncs related atoms (there are ncs_loc number of 
c---  different groips. Each group has nchn number of chains related with 
c---  each other. The number of atoms related in group is ns. 
c---  Output file contains quadruple of atoms: i1,i2,i3,i4. distance between 
c---  i1 and i2 atoms should be similar to that between i3 and i4. 
c
      integer igr
      integer i,j,k,i1,i2,j1,ia,ja,ian,jan,ii,jj,is,il,in
      integer ifile_vdw,ifile_ncs,ifile_loc
      integer ierr
      integer ncs_loc,ivdw,nvdw,chn_pairs,n_ncs_loc
      integer ns,nchn
      integer isym(4),ia1(2),vdw_type
      real rs_vidl(3),sigb,dist1,dist2
      real xx1(3),xx2(3),yy1(3),yy2(3)
      real weight_b
c
c---  These should come from include files
      real dist_cut_ncs
c
c---  Allocatables
      integer max_per_atom
      integer, allocatable :: pairs_vdw(:,:)
      integer, allocatable :: nvdw_per_atom(:)
      integer, allocatable :: vdw_per_atom(:,:)
      integer, allocatable :: pairs_ncs(:)
      integer, allocatable :: pairs_ncs_loc(:,:)
      integer, allocatable :: chn_pairs_loc(:)
      integer, allocatable :: ncs_grps(:)
      integer, allocatable :: iat(:,:)
      real, allocatable :: sigx(:)
      real, allocatable :: sigx_loc(:)
c
      call open_unform_file(ifile_vdw,vdw_file,ierr)
      read(ifile_vdw)nvdw
      allocate(pairs_vdw(2,nvdw))
      ivdw = 0
      do i=1,nvdw
         read(ifile_vdw)ia1(1:2),rs_vidl(3),isym(1:4),vdw_type
         if(isym(1).eq.1.and.sum(abs(isym(2:4))).eq.0) then
            ivdw = ivdw+1
            pairs_vdw(1:2,ivdw) = ia1(1:2)
         endif
      enddo
      close(ifile_vdw)
      nvdw = ivdw
      allocate(nvdw_per_atom(n_atom))
      nvdw_per_atom(1:n_atom) = 0
      do i=1,nvdw
         i1 = pairs_vdw(1,i)
         i2 = pairs_vdw(2,i)
         if(i1.lt.i2) then
            nvdw_per_atom(i1) = nvdw_per_atom(i1) + 1
         else
            nvdw_per_atom(i2) = nvdw_per_atom(i2) + 1
         endif
      enddo
      max_per_atom = maxval(nvdw_per_atom(1:n_atom))
      allocate(vdw_per_atom(max_per_atom,n_atom))
      nvdw_per_atom(1:n_atom) = 0
      do i=1,nvdw
         i1 = pairs_vdw(1,i)
         i2 = pairs_vdw(2,i)
         if(i1.lt.i2) then
            nvdw_per_atom(i1) = nvdw_per_atom(i1) + 1
            vdw_per_atom(nvdw_per_atom(i1),i1) = i2
         else
            nvdw_per_atom(i2) = nvdw_per_atom(i2) + 1
            vdw_per_atom(nvdw_per_atom(i2),i2) = i1
         endif
      enddo
c     
      call open_unform_file(ifile_ncs,ifile_ncs,ierr)
      read(ifile_ncs)ncs_loc
      
      if(len_trim(ncs_simil_file).le.0) then
         call find_unique_file_name(ncs_simil_file,'.ncs_loc')
      endif
      call open_unform_file(ifile_loc,ncs_simil_file,ierr)
c
      allocate(pairs_ncs(n_atom))
      chn_pairs = 0
      n_ncs_loc = 0
      igr = 0
      do il=1,ncs_loc
         read(ifile_ncs)ns,nchn
         allocate(iat(ns,nchn))
         allocate(sigx(ns))
         do is=1,ns
            read(ifile_ncs)sigx(is),sigb,(iat(is,k),k=1,nchn),weight_b
         enddo
         do i=1,nchn-1
            do j=i+1,nchn
               igr = igr + 1
               chn_pairs = chn_pairs + 1
               pairs_ncs(1:n_atom) = 0
               do is=1,ns
                  pairs_ncs(iat(is,i)) = iat(is,j)
               enddo
               do ia=1,n_atom
                  if(pairs_ncs(ia).gt.0) then
                     ian = ia
                     jan = pairs_ncs(ia)
                     xx1(1:3) = xyz_crd(1:3,ian)
                     yy1(1:3) = xyz_crd(1:3,jan)
                     do in=1,nvdw_per_atom(ian)
                        ii = vdw_per_atom(in,ian)
                        if(pairs_ncs(ii).gt.0) then
                           jj = pairs_ncs(jj)
                           xx2(1:3) = xyz_crd(1:3,ii)
                           yy2(1:3) = xyz_crd(1:3,jj)
                           dist1 = sqrt(sum((xx1-xx2)**2))
                           dist2 = sqrt(sum((yy1-yy2)**2))
                           if(dist1.lt.dist_cut_ncs.and.
     &                          dist2.lt.dist_cut_ncs) then
                              n_ncs_loc = n_ncs_loc + 1
                              write(ifile_loc)ian,ii,jan,jj,chn_pairs,
     &                             sigx(is),igr
                           endif
                        endif
                     enddo
                  endif
               enddo
            enddo
         enddo
      enddo
      close(ifile_ncs)
      deallocate(iat)
      deallocate(sigx)
      deallocate(pairs_vdw)
      deallocate(nvdw_per_atom)
      deallocate(vdw_per_atom)
      deallocate(pairs_ncs)
c
c--   Now read and write again so that we the number of restraints 
c--   in the file also.
      allocate(pairs_ncs_loc(4,n_ncs_loc))
      allocate(chn_pairs_loc(n_ncs_loc))
      allocate(sigx_loc(n_ncs_loc))
      allocate(ncs_grps(n_ncs_loc))
      rewind(ifile_loc)
      do i=1,n_ncs_loc
         read(ifile_loc)pairs_ncs_loc(1:4,i),chn_pairs_loc(i),
     &        sigx_loc(i),ncs_grps(i)
      enddo
      rewind(ifile_loc)
      write(ifile_loc)igr,n_ncs_loc
      do i=1,n_ncs_loc
         write(ifile_loc)pairs_ncs_loc(1:4,i),chn_pairs_loc(i),
     &        sigx_loc(i),ncs_grps(i),1.0
      enddo
      deallocate(pairs_ncs_loc)
      deallocate(chn_pairs_loc)
      deallocate(sigx_loc)
      deallocate(ncs_grps)
      close(ifile_loc)
      return
      end
