      subroutine ncs_similarity(fvalue,max_mat,max_vec,a_mat,vect,
     &     max_dist,n_target,n_object,nsym_dist,nw_uval,
     &     nrest_per_atom,rest_per_atom)
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'celsym.fh'
      include 'vitals.fh'
      include 'monitor.fh'
      include 'weights.fh'
      include 'rharvest.fh'
      include 'restr_files.fh'
c
      integer max_mat,max_vec,max_dist
      real a_mat(*),vect(*)
      integer nrest_per_atom(*),rest_per_atom(n_atom,*)
      integer n_target(*),n_object(*),nw_uval(*),nsym_dist(4,*)
      real fvalue
c
      integer ir,igr

      integer ifile,ierr
      integer nrests,ngroups
      integer ia1(4),ia11(4),ia12(4)
      real    sigx,weight_b,wt
      real x1diff(3),x2diff(3),dfdx(3,4)
      real ncs_discard
      integer nrest_ncs_total
      real rms_ncs_total
      real sigma_ncs_total

      integer ip,ipos_mat,i,j,idist,iw_uval,imode
      real delta,delta2,dist1,dist2
      integer, allocatable ::  nrest_ncs(:)
      real, allocatable ::  rms_ncs(:)
      real, allocatable :: sigma_ncs(:)

      real small_bond
      data small_bond/0.0001/
c
c---- body
      fvalue = 0.0
      ncs_discard = 10.0
      if(len_trim(ncs_simil_file).le.0) return
      call open_unform_file(ifile,ncs_simil_file,ierr)

      read(ifile)ngroups,nrests
      if(nrests.le.0.or.ngroups.le.0) then
         close(ifile)
         return
      endif
      allocate(rms_ncs(ngroups))
      allocate(nrest_ncs(ngroups))
      allocate(sigma_ncs(ngroups))

      rms_ncs(1:ngroups) = 0.0
      nrest_ncs(1:ngroups) = 0
      sigma_ncs(1:ngroups) = 0.0

      do ir=1,nrests
         read(ifile)ia1(4),sigx,igr,weight_b
         if(minval(abs(atom_ref_flag(ia1(1:4)))).le.0) goto 10
         ia11(1:4) = atom_ref_flag(ia1(1:4))/10
         ia12(1:4) = atom_ref_flag(ia1(1:4))-10*ia11(1:4)
         if(abs(sum(ia12(1:4))).le.0) goto 10
         

         x1diff = xyz_crd(1:3,ia1(1))-xyz_crd(1:3,ia1(2))
         x2diff = xyz_crd(1:3,ia1(3))-xyz_crd(1:3,ia1(4))
c
c---Discard this pair if distances are too different???
         dist1 = sqrt(sum((x1diff**2)))
         dist2 = sqrt(sum((x2diff**2)))
            
         delta = dist1-dist2
         if(abs(delta).gt.ncs_discard*sigx) then
c
c---Report if necessary
            goto 10
         endif
         delta2 = delta**2
         wt = 1.0/sigx**2
         wt = wt*weight_b
c     
c---  Should the weight depend on distances. If so then be careful. 
c---  Function may be a bit more complicated
         dfdx(1:3,1) =  x1diff(1:3)/max(small_bond,dist1)
         dfdx(1:3,2) = -dfdx(1:3,1)
         dfdx(1:3,3) = -x2diff(1:3)/max(small_bond,dist2)
         dfdx(1:3,4) = -dfdx(1:3,3)         
         fvalue = fvalue + 0.5*wt*delta2
c---  
c---  increment grads
         do i=1,4
            ip = 3*(ia11(i)-1)
            vect(ip:ip+2) = wt*delta*dfdx(1:3,i)
         enddo
c     
c---  increment secders
         do i=1,4
            ipos_mat = 6*(ia11(i)-1)
            call incr_matr_diag(max_mat,ipos_mat,a_mat,wt,
     &           dfdx(1:3,i))
         enddo
         do i=1,3
            do j=i+1,4
               call find_restraint(max_dist,ndis,idist,ia1(i),ia1(j),
     &              nsym_dist,n_atom,nrest_per_atom,rest_per_atom,
     &              n_target,n_object,nsym_dist,nw_uval,iw_uval,imode)
               ipos_mat = nmpos+9*(idist-1)
               if(imode.eq.0) then
                  call incr_matr_nondiag(max_mat,ipos_mat,a_mat,wt,
     &                 dfdx(1:3,i),dfdx(1:3,j))
               else
                  call incr_matr_nondiag(max_mat,ipos_mat,a_mat,wt,
     &                 dfdx(1:3,j),dfdx(1:3,i))
               endif
            enddo
         enddo
         
c
c---And some stats
         rms_ncs(igr) = rms_ncs(igr) + delta2
         nrest_ncs(igr) = nrest_ncs(igr) + 1
         sigma_ncs(igr) = sigma_ncs(igr) + sigx
 10      continue
      enddo
c
c---Sort out ncs groups. What does it mean. Should we use one for all??
      do igr = 1,ngroups
         if(nrest_ncs(igr).gt.0) then
c            ch1 = ncs_chain_names(1,igr)
c            ch2 = ncs_chain_names(2,igr)
            hnrestr = hnrestr+1
            sigma_ncs(igr) = sigma_ncs(igr)/nrest_ncs(igr)
            hrestr_devitar(hnrestr) = sigma_ncs(igr)
            hrestr_dev(hnrestr) = sqrt(rms_ncs(igr)/nrest_ncs(igr))
            hrestr_num(hnrestr) = nrest_ncs(igr)
c            write(hnrestr_type(ig),'(a)')
c     &           'NCS: local between chains '//
c     &           ch1(1:2)//' and '//ch2(1:2)
         endif
      enddo
      nrest_ncs_total = sum(nrest_ncs(1:ngroups))
      rms_ncs_total = sum(rms_ncs(1:ngroups))
      sigma_ncs_total = sum(sigma_ncs(1:ngroups))
      if(nrest_ncs_total.gt.0) then
         rms_ncs_total = sqrt(rms_ncs_total/nrest_ncs_total)
         sigma_ncs_total = sigma_ncs_total/nrest_ncs_total
      endif
      deallocate(nrest_ncs)
      deallocate(rms_ncs)
      deallocate(sigma_ncs)

      close(ifile)
      return
      end
