module align

contains
  subroutine sequence_align_r(sequence1,sequence2,sim_table,align_out,         &
       pen1,pen2,align_score,ierr)
    implicit none
    !
    !---  Subroutine for alignment of two sequences
    integer ierr
    real pen1,pen2
    integer, intent(in) :: sequence1(:),sequence2(:)
    real, intent(in) ::  sim_table(:,:)
    real, intent(out) :: align_out(:,:)
    real align_score
    !
    integer ncases,nseq1,nseq2
    integer i,j,i1,j1,i2
    integer nalign,nlen_align,nlead,nlead1,ntrail,ntrail1
    !
    ierr = 0
    nseq1 = size(sequence1)
    nseq2 = size(sequence2)
    if(nseq1.eq.nseq2.and.nseq1.eq.1) then
       if(sequence1(1).eq.sequence2(1)) then 
          align_score = 1.0
       else
          align_score = 0.0
       endif
       return
    endif
    
    call  align_r(sequence1,sequence2,sim_table,nlen_align,align_out,pen1,pen2,ierr)
    if(ierr.gt.0) return
    !
    !---Convert alignment to some number
    !
    !---Remove leading and trailing zeros
    i=1
    nlead = 1
    do while(align_out(1,i).eq.0.and.i.le.nlen_align) 
       nlead = nlead + 1
       i = i +1 
    enddo
    nlead1 = 1
    i = 0
    do while(align_out(2,i).eq.0.and.i.le.nlen_align)
       nlead1 = nlead1 + 1
       i = i + 1
    enddo
    nlead = max(nlead,nlead1)
    i=nlen_align
    ntrail = nlen_align
    do while(align_out(1,i).eq.0.and.i.gt.1)
       ntrail = ntrail-1
       i = i - 1
    enddo
    i = nlen_align
    ntrail1 = nlen_align
    do while(align_out(2,i).eq.0.and.i.gt.1)
       ntrail1 = ntrail1-1
       i = i - 1
    enddo
    ntrail = min(ntrail,ntrail1)
    nalign = 0
    do i=nlead,ntrail
       if(align_out(1,i).gt.0.and.align_out(2,i).gt.0) then
          i1 = align_out(1,i)
          i2 = align_out(2,i)
          if(sequence1(i1).eq.sequence2(i2)) then
             nalign = nalign + 1
          endif
       endif
    enddo
    
    align_score = nalign/max(ntrail-nlead+1,min(nseq1,nseq2))
    
    return
  end subroutine sequence_align_r
  !
  !----
  subroutine align_r(sequence1,sequence2,sim_table,nlen_align,align_out,pen1,pen2,ierr)
    implicit none
    !
    !---  Subroutine for alignment of two sequences
    integer ierr
    integer nlen_align
    real pen1,pen2
    integer, intent(in) :: sequence1(:),sequence2(:)
    real, intent(in) :: sim_table(:,:)
    real, intent(out) :: align_out(:,:)
    !
    integer ncases,nseq1,nseq2
    
    integer i,j,i1,j1
    real, allocatable :: table1(:,:)
    
    !  data pen1/0.0/,pen2/0.0/
  
    nseq1 = size(sequence1)
    nseq2 = size(sequence2)
    ncases = size(sim_table(1,:))
    !
    ! body
    ierr = 0
    if(minval(sequence1).gt.0.and.maxval(sequence1).le.ncases.and.            &
         minval(sequence2).gt.0.and.maxval(sequence2).le.ncases) then
       allocate(table1(nseq1,nseq2))
       do i=1,nseq1
          i1 = sequence1(i)
          do j=1,nseq2
             j1 = sequence2(i)
             table1(i,j) = sim_table(i1,j1)
          enddo
       enddo
       !
       call align_real(pen1,pen2,table1,nlen_align,align_out,ierr)
       deallocate(table1)
    else
       ierr = 1
    endif
    return
  end subroutine align_r
!
  subroutine align_real(pen1,pen2,table1,nlen_align,align_out,ierr)
    implicit none
    integer ierr
    real pen1,pen2
    real, intent(in) :: table1(:,:)
    integer nlen_align
    real, intent(out) :: align_out(:,:)
    !
    integer nseq1,nseq2
    integer i,j,n1,nl
    real a,b,c
    real, allocatable :: f(:,:)
    integer, allocatable :: al1(:)
    integer, allocatable :: al2(:)
    !
    !---- 
    real eps
    
    !
    !---  Foward step
    nseq1 = size(table1(:,1)); nseq2 = size(table1(1,:))
    eps = 1.0e-7
    allocate(f(nseq1,nseq2))
    !
    do i=1,nseq1
       f(i,1) = i*pen1
    enddo
    do j=1,nseq2
       f(1,j) = j*pen1
    enddo
    !
    do i=2,nseq1
       do j=2,nseq2
          a = f(i-1,i-1) - table1(i-1,j-1)
          b = f(i-1,j) - pen1
          c = f(i,i-1) - pen1
          f(i,j) = min(a,min(b,c))
       enddo
    enddo
    !
    !---  Backward step
    n1 = nseq1 + nseq2
    allocate(al1(n1))
    allocate(al2(n1))
    !
    al1(n1) = nseq1
    al2(n1) = nseq2
    i = nseq1
    j = nseq2
    do while (i.gt.1.and.j.gt.1)
       if(abs(f(i,j)-f(i-1,j-1)-table1(i-1,j-1)).lt.eps) then
          n1 = n1 -1
          i = i - 1
          j = j - 1
          al1(n1) = i
          al2(n1) = j
       else if(abs(f(i,j)-f(i-1,j) - pen1).lt.eps) then
          n1 = n1 - 1
          i = i - 1
          al1(n1) = i
          al2(n1) = 0
       else if(abs(f(i,j)-f(i,j-1)-pen1).lt.eps) then
          n1 = n1 - 1
          j = j - 1
          al1(n1) = 0
          al2(n1) = j
       endif
    enddo
    do while(i.gt.1) 
       n1 = n1 - 1
       i = i - 1
       al1(n1) = i
       al2(n1) = 0
    enddo
    do while (j.gt.1) 
       n1 = n1 - 1
       j = j - 1
       al1(n1) = 0
       al2(n1) = j
    enddo
    !
    !---Remove zeros
    i = 1
    do while (al1(i).eq.0.and.al2(i).eq.0)
       i = i + 1
    enddo
    nl = n1-i+1
    align_out(1,1:nl) = al1(i:n1)
    align_out(2,1:nl) = al2(i:n1)
    nlen_align = n1-i+1
    !
    deallocate(al1)
    deallocate(al2)
    deallocate(f)
    return
  end subroutine align_real
end module align
