module ncs_simil

contains
  subroutine ncs_similarity(fvalue,nmpos,a_mat,vect,ndis,n_target,                           &
       n_object,nsym_dist,nw_uval,nrest_per_atom,rest_per_atom,n_atom,xyz_crd,               &
       atom_ref_flag,ncs_simil_file)
    implicit none
    !  include 'atom_com.fh'
    !  include 'models.fh'
    !  include 'celsym.fh'
    !  include 'vitals.fh'
    !  include 'monitor.fh'
    !  include 'weights.fh'
    !  include 'rharvest.fh'
    !  include 'restr_files.fh'
    
    integer ndis,nmpos
    integer n_atom
    real :: xyz_crd(3,n_atom)
    real :: atom_ref_flag(n_atom)
    real a_mat(*),vect(*)
    integer nrest_per_atom(n_atom),rest_per_atom(n_atom,*)
    integer n_target(ndis),n_object(ndis),nw_uval(ndis),nsym_dist(4,ndis)
    real fvalue
    !
    character(len=*) :: ncs_simil_file
    
    integer ir,igr
    
    integer ifile,ierr
    integer nrests,ngroups
    integer ia1(4),ia11(4),ia12(4)
    real    sigx,weight_b,wt
    real x1diff(3),x2diff(3),dfdx(3,4)
    real ncs_discard
    integer nrest_ncs_total
    real rms_ncs_total
    real sigma_ncs_total
    
    integer ip,ipos_mat,i,j,idist,iw_uval,imode
    real delta,delta2,dist1,dist2
    integer, allocatable ::  nrest_ncs(:)
    real,    allocatable ::  rms_ncs(:)
    real,    allocatable :: sigma_ncs(:)
    
    real :: small_bond = 0.0001
    !
    !---- body
    fvalue = 0.0
    ncs_discard = 10.0
    if(len_trim(ncs_simil_file).le.0) return
    call open_unform_file(ifile,ncs_simil_file,ierr)
    
    read(ifile)ngroups,nrests
    if(nrests.le.0.or.ngroups.le.0) then
       close(ifile)
       return
    endif
    allocate(rms_ncs(ngroups))
    allocate(nrest_ncs(ngroups))
    allocate(sigma_ncs(ngroups))
    
    rms_ncs(1:ngroups) = 0.0
    nrest_ncs(1:ngroups) = 0
    sigma_ncs(1:ngroups) = 0.0
    
    mainl: do ir=1,nrests
       read(ifile)ia1(4),sigx,igr,weight_b
       if(minval(abs(atom_ref_flag(ia1(1:4))))<=0) cycle mainl
       ia11(1:4) = atom_ref_flag(ia1(1:4))/10
       ia12(1:4) = atom_ref_flag(ia1(1:4))-10*ia11(1:4)
       if(abs(sum(ia12(1:4))) <= 0) cycle mainl
       
       
       x1diff = xyz_crd(1:3,ia1(1))-xyz_crd(1:3,ia1(2))
       x2diff = xyz_crd(1:3,ia1(3))-xyz_crd(1:3,ia1(4))
       !
       !---Discard this pair if distances are too different???
       dist1 = sqrt(sum((x1diff**2)))
       dist2 = sqrt(sum((x2diff**2)))
       
       delta = dist1-dist2
       if(abs(delta).gt.ncs_discard*sigx) then
        !
        !---Report if necessary
          cycle mainl
       endif
       delta2 = delta**2
       wt = 1.0/sigx**2
       wt = wt*weight_b
       ! 
       !  Should the weight depend on distances. If so then be careful. 
       !  Function may be a bit more complicated
       dfdx(1:3,1) =  x1diff(1:3)/max(small_bond,dist1)
       dfdx(1:3,2) = -dfdx(1:3,1)
       dfdx(1:3,3) = -x2diff(1:3)/max(small_bond,dist2)
       dfdx(1:3,4) = -dfdx(1:3,3)         
       fvalue = fvalue + 0.5*wt*delta2
       !---  
       !---  increment grads
       do i=1,4
          ip = 3*(ia11(i)-1)
          vect(ip:ip+2) = wt*delta*dfdx(1:3,i)
       enddo
       !     
       !---  increment secders
       do i=1,4
          ipos_mat = 6*(ia11(i)-1)
          call incr_matr_diag_r1(ipos_mat,a_mat,wt,dfdx(1:3,i))
       enddo
       do i=1,3
          do j=i+1,4      
             call find_restraint_r1(ndis,idist,ia1(i),ia1(j),              &
                  nsym_dist,n_atom,nrest_per_atom,rest_per_atom,          &
                  n_target,n_object,nsym_dist,nw_uval,iw_uval,imode)
             ipos_mat = nmpos+9*(idist-1)
             if(imode.eq.0) then
                call incr_matr_nondiag_r1(ipos_mat,a_mat,wt,dfdx(1:3,i),dfdx(1:3,j))
             else
                call incr_matr_nondiag_r(ipos_mat,a_mat,wt,dfdx(1:3,j),dfdx(1:3,i))
             endif
          enddo
       enddo
       
       !
       !---And some stats
       rms_ncs(igr) = rms_ncs(igr) + delta2
       nrest_ncs(igr) = nrest_ncs(igr) + 1
       sigma_ncs(igr) = sigma_ncs(igr) + sigx
    enddo mainl
    !
    !---Sort out ncs groups. What does it mean. Should we use one for all??
    !  do igr = 1,ngroups
    !     if(nrest_ncs(igr).gt.0) then
    !        hnrestr = hnrestr+1
    !        sigma_ncs(igr) = sigma_ncs(igr)/nrest_ncs(igr)
    !        hrestr_devitar(hnrestr) = sigma_ncs(igr)
    !        hrestr_dev(hnrestr) = sqrt(rms_ncs(igr)/nrest_ncs(igr))
    !        hrestr_num(hnrestr) = nrest_ncs(igr)
    !     endif
    !  enddo
    nrest_ncs_total = sum(nrest_ncs(1:ngroups))
    rms_ncs_total = sum(rms_ncs(1:ngroups))
    sigma_ncs_total = sum(sigma_ncs(1:ngroups))
    if(nrest_ncs_total.gt.0) then
       rms_ncs_total = sqrt(rms_ncs_total/nrest_ncs_total)
       sigma_ncs_total = sigma_ncs_total/nrest_ncs_total
    endif
    deallocate(nrest_ncs)
    deallocate(rms_ncs)
    deallocate(sigma_ncs)
    
    close(ifile)
    return
  end subroutine ncs_similarity
  
  subroutine ncs_local_define(n_atom,xyz_crd,vdw_file,ncs_simil_file)
    implicit none
    !      include 'atom_com.fh'
    !      include 'restr_files.fh'
    integer n_atom
    real xyz_crd(3,n_atom)
    character(len=*) :: vdw_file
    character(len=*) :: ncs_simil_file
    
    !
    !---  Using correspondence between atoms create a file of local similarity.
    !--   Input file is file of ncs related atoms (there are ncs_loc number of 
    !---  different groips. Each group has nchn number of chains related with 
    !---  each other. The number of atoms related in group is ns. 
    !---  Output file contains quadruple of atoms: i1,i2,i3,i4. distance between 
    !---  i1 and i2 atoms should be similar to that between i3 and i4. 
    !
    integer igr
    integer i,j,k,i1,i2,j1,ia,ja,ian,jan,ii,jj,is,il,in
    integer ifile_vdw,ifile_ncs,ifile_loc
    integer ierr
    integer ncs_loc,ivdw,nvdw,chn_pairs,n_ncs_loc
    integer ns,nchn
    integer isym(4),ia1(2),vdw_type
    real rs_vidl(3),sigb,dist1,dist2
    real xx1(3),xx2(3),yy1(3),yy2(3)
    real weight_b
    !
    !---  These should come from include files
    real dist_cut_ncs
    !
    !---  Allocatables
    integer max_per_atom
    integer, allocatable :: pairs_vdw(:,:)
    integer, allocatable :: nvdw_per_atom(:)
    integer, allocatable :: vdw_per_atom(:,:)
    integer, allocatable :: pairs_ncs(:)
    integer, allocatable :: pairs_ncs_loc(:,:)
    integer, allocatable :: chn_pairs_loc(:)
    integer, allocatable :: ncs_grps(:)
    integer, allocatable :: iat(:,:)
    real, allocatable :: sigx(:)
    real, allocatable :: sigx_loc(:)
    !
    call open_unform_file(ifile_vdw,vdw_file,ierr)
    read(ifile_vdw)nvdw
    allocate(pairs_vdw(2,nvdw))
    ivdw = 0
    do i=1,nvdw
       read(ifile_vdw)ia1(1:2),rs_vidl(3),isym(1:4),vdw_type
       if(isym(1).eq.1.and.sum(abs(isym(2:4))).eq.0) then
          ivdw = ivdw+1
          pairs_vdw(1:2,ivdw) = ia1(1:2)
       endif
    enddo
    close(ifile_vdw)
    nvdw = ivdw
    allocate(nvdw_per_atom(n_atom))
    nvdw_per_atom(1:n_atom) = 0
    do i=1,nvdw
       i1 = pairs_vdw(1,i)
       i2 = pairs_vdw(2,i)
       if(i1.lt.i2) then
          nvdw_per_atom(i1) = nvdw_per_atom(i1) + 1
       else
          nvdw_per_atom(i2) = nvdw_per_atom(i2) + 1
       endif
    enddo
    max_per_atom = maxval(nvdw_per_atom(1:n_atom))
    allocate(vdw_per_atom(max_per_atom,n_atom))
    nvdw_per_atom(1:n_atom) = 0
    do i=1,nvdw
       i1 = pairs_vdw(1,i)
       i2 = pairs_vdw(2,i)
       if(i1.lt.i2) then
          nvdw_per_atom(i1) = nvdw_per_atom(i1) + 1
          vdw_per_atom(nvdw_per_atom(i1),i1) = i2
       else
          nvdw_per_atom(i2) = nvdw_per_atom(i2) + 1
          vdw_per_atom(nvdw_per_atom(i2),i2) = i1
       endif
    enddo
    !     
    call open_unform_file(ifile_ncs,ifile_ncs,ierr)
    read(ifile_ncs)ncs_loc
    
    if(len_trim(ncs_simil_file).le.0) then
       call find_unique_file_name(ncs_simil_file,'.ncs_loc')
    endif
    call open_unform_file(ifile_loc,ncs_simil_file,ierr)
    !
    allocate(pairs_ncs(n_atom))
    chn_pairs = 0
    n_ncs_loc = 0
    igr = 0
    do il=1,ncs_loc
       read(ifile_ncs)ns,nchn
       allocate(iat(ns,nchn))
       allocate(sigx(ns))
       do is=1,ns
          read(ifile_ncs)sigx(is),sigb,(iat(is,k),k=1,nchn),weight_b
       enddo
       do i=1,nchn-1
          do j=i+1,nchn
             igr = igr + 1
             chn_pairs = chn_pairs + 1
             pairs_ncs(1:n_atom) = 0
             do is=1,ns
                pairs_ncs(iat(is,i)) = iat(is,j)
             enddo
             do ia=1,n_atom
                if(pairs_ncs(ia).gt.0) then
                   ian = ia
                   jan = pairs_ncs(ia)
                   xx1(1:3) = xyz_crd(1:3,ian)
                   yy1(1:3) = xyz_crd(1:3,jan)
                   do in=1,nvdw_per_atom(ian)
                      ii = vdw_per_atom(in,ian)
                      if(pairs_ncs(ii).gt.0) then
                         jj = pairs_ncs(jj)
                         xx2(1:3) = xyz_crd(1:3,ii)
                         yy2(1:3) = xyz_crd(1:3,jj)
                         dist1 = sqrt(sum((xx1-xx2)**2))
                         dist2 = sqrt(sum((yy1-yy2)**2))
                         if(dist1.lt.dist_cut_ncs.and.dist2.lt.dist_cut_ncs) then
                            n_ncs_loc = n_ncs_loc + 1
                            write(ifile_loc)ian,ii,jan,jj,chn_pairs,sigx(is),igr
                         endif
                      endif
                   enddo
                endif
             enddo
          enddo
       enddo
    enddo
    close(ifile_ncs)
    deallocate(iat)
    deallocate(sigx)
    deallocate(pairs_vdw)
    deallocate(nvdw_per_atom)
    deallocate(vdw_per_atom)
    deallocate(pairs_ncs)
    !
    !--   Now read and write again so that we the number of restraints 
    !--   in the file also.
    allocate(pairs_ncs_loc(4,n_ncs_loc))
    allocate(chn_pairs_loc(n_ncs_loc))
    allocate(sigx_loc(n_ncs_loc))
    allocate(ncs_grps(n_ncs_loc))
    rewind(ifile_loc)
    do i=1,n_ncs_loc
       read(ifile_loc)pairs_ncs_loc(1:4,i),chn_pairs_loc(i),sigx_loc(i),ncs_grps(i)
    enddo
    rewind(ifile_loc)
    write(ifile_loc)igr,n_ncs_loc
    do i=1,n_ncs_loc
       write(ifile_loc)pairs_ncs_loc(1:4,i),chn_pairs_loc(i),sigx_loc(i),ncs_grps(i),1.0
    enddo
    deallocate(pairs_ncs_loc)
    deallocate(chn_pairs_loc)
    deallocate(sigx_loc)
    deallocate(ncs_grps)
    close(ifile_loc)
    return
  end subroutine ncs_local_define
end module ncs_simil
