module local_tls

contains
  subroutine local_tls_rest(sum_tmp,a_mat,vect,n_target,n_object,nsym_dist,nw_uval,xyz_crd,u_aniso,occup,atom_ref_flag, & 
       nrest_per_atom,rest_per_atom,symm_per_atom,rot,tr,cell)

    implicit none

    
    real sum_tmp
    real, intent(in) :: cell(6)
    real, intent(in) :: rot(:,:,:)
    real, intent(in) :: tr(:,:)
    real, intent(in) :: xyz_crd(:,:),u_aniso(:,:),occup(:)
    integer, intent(in) :: atom_ref_flag(:)

    real, intent(inout) :: a_mat(:),vect(:)
    integer, intent(in) :: n_target(:),n_object(:),nsym_dist(:,:),nw_uval(:)

    integer maxrest
    integer, intent(in) :: nrest_per_atom(:)
    integer, intent(in) :: rest_per_atom(:,:)
    integer, intent(in) :: symm_per_atom(:,:,:)
    
    real, allocatable :: tmat_loc(:,:)
    real, allocatable :: lmat_loc(:,:)
    real, allocatable :: smat_loc(:,:)
    real, allocatable :: u_estim(:,:)

    integer, allocatable :: lposv(:)
    integer, allocatable :: lposm(:)

    integer iposu1,iposu2,iposm,ian
    integer i,j,ia,ndist,im,ia1
    
    real wtt,delta
    real dfda(6),d2fda2(6,6),dadu(6)
    real u1v(6),u2v(6),u1(3,3),u2(3,3),u12(3,3)
    
    real trace_matmul_r

    integer nsym,n_atom
    !
    !  Body
    n_atom = size(xyz_crd(1,:))
    nsym = size(rot(1,1,:))
    ndist = size(n_target(:))
    maxrest = maxval(nrest_per_atom(1:n_atom))
    !
    !   Allocate TLS. Each atom has its own TLS parameter
    allocate(tmat_loc(6,n_atom))
    allocate(lmat_loc(6,n_atom))
    allocate(smat_loc(8,n_atom))

    allocate(u_estim(6,n_atom))
    call local_tls2aniso(u_estim,tmat_loc,lmat_loc,smat_loc,maxrest,     &
         nrest_per_atom,rest_per_atom,symm_per_atom)

    allocate(lposv(n_atom))
    allocate(lposm(n_atom))
    call find_pos_of_u(n_atom,n_atom,atom_ref_flag(1:n_atom),u_aniso(1:6,1:n_atom),lposv,lposm,1)


    im = 1
    sum_tmp = 0.0
    wtt = 1.0/0.1**2
    ia1 = 0
    do ia=1,n_atom
       if(atom_ref_flag(ia).gt.0) then
          
          call local_tls_fit(tmat_loc,lmat_loc,smat_loc,ndist,maxrest,nrest_per_atom,rest_per_atom,symm_per_atom, &
               xyz_crd,u_aniso,occup,rot,tr,cell)
          ia1 = ia1 + 1
          u1v = u_aniso(1:6,ia)
          call aniso_vect2mat(u1v,u1)
          u2v = u_estim(1:6,ia)
          call aniso_vect2mat(u2v,u2)
          u12 = u1-u2
          !            write(*,*)'trace in'
          delta = trace_matmul_r(3,u12,u12)
          !            write(*,*)'trace out'
          sum_tmp = sum_tmp + 0.5*wtt*delta
          dfda(1:6) = u1v-u2v
          dfda(4:6) = 2.0*dfda(4:6)
          d2fda2(1:6,1:6) = 0.0
          do i=1,3
             d2fda2(i,i) = 1.0
             d2fda2(i+3,i+3) = 2.0
          enddo
          dadu(1:6) = -1.0
          dfda = wtt*dfda
          d2fda2 = wtt*d2fda2
          iposu1 = lposv(ia1)
          iposu2 = iposu1+5
          iposm = lposm(ia1)
          !            write(*,*)'Before vect',iposu1,iposu2,iposm
          vect(iposu1:iposu2) = vect(iposu1:iposu2) + dfda(1:6)*dadu(1:6)
          do ian=1,6
             a_mat(iposm+ian-1) = a_mat(iposm+ian-1) + d2fda2(ian,ian)*dadu(ian)*dadu(ian)
          enddo
       endif
    enddo

    deallocate(lposv)
    deallocate(lposm)
    deallocate(nrest_per_atom)
    deallocate(rest_per_atom)
    deallocate(symm_per_atom)
    deallocate(u_estim)
    deallocate(tmat_loc)
    deallocate(lmat_loc)
    deallocate(smat_loc)
    return
  end subroutine local_tls_rest
  !
  subroutine local_tls_fit(tmat_loc,lmat_loc,smat_loc,nrest_per_atom,rest_per_atom,  &
       symm_per_atom,xyz_crd,u_aniso,occup,atom_ref_flag,rot,tr,cell)
    implicit none

    !
    !---  This routine estimates local tls parameters for each atom.
    !---  The number of atoms should be sufficient for this estimate to be reliable
    !---  
    real, intent(in) :: rot(:,:,:),tr(:,:),cell(6)
    real, intent(in) :: xyz_crd(:,:),u_aniso(:,:),occup(:)
    real, intent(out) ::  tmat_loc(:,:),lmat_loc(:,:),smat_loc(:,:)
    integer, intent(in) :: atom_ref_flag(:)
    integer maxrest,ndist
    integer, intent(in) :: nrest_per_atom(:),rest_per_atom(:,:)
    integer, intent(in) ::  symm_per_atom(:,:,:)
    
    real ro_unit(3,3),rfr_unit(3,3)
    real rsymm_ort(3,3,192)
    integer i,j,k,l,ia,ir,in,im,is,isym,ierror
    real xyz_this(3),xyz_ort(3),xyz_neighbour(3),xyz1(3),xyz2(3)
    real u2v(6),u2(3,3),tmp(3,3)
    real dfdu(6),d2fdu2(6)
    real d2fd2(20,6)
    real dudtls(6,20)
    real*8 :: toler=1.0d-7
    real*8 dist,wtt
    real*8 dfdtls(20),d2fdtls2(20,20),shft_tls(20)
    real :: nwork_space = 1000
    real*8 workspace(1000)
    !
    integer nsym,n_atom
!
!---  body 
    nsym = size(rot(1,1,:))
    n_atom = size(xyz_crd(1,:))
    call find_ort_symm(nsym,rot(1:3,1:3,1:nsym),tr(1:3,1:nsym),cell,rsymm_ort(1:3,1:3,1:nsym))
    
    im = 1
    do ia=1,n_atom
       !
       !---Central atom
       if(atom_ref_flag(ia).gt.0) then
          xyz_ort(1:3) = 0.0
          call derivs_wrt_tlspars(xyz_ort,dudtls)
          dfdu = u_aniso(1:6,ia)
          dfdu(4:6) = 2.0*dfdu(4:6)
          d2fdu2(1:3) = 1.0
          d2fdu2(4:6) = 2.0
          
          dfdtls(1:20) = 0.0
          d2fdtls2(1:20,1:20) = 0.0
          do k=1,20
             do i=1,6
                dfdtls(k) = dfdtls(k) + dfdu(i)*dudtls(i,k) 
             enddo
          enddo
          
          do k=1,20
             do l=1,20
                do i=1,6
                   d2fdtls2(k,l) = d2fdtls2(k,l) + d2fdu2(i)*dudtls(i,k)*dudtls(i,l) 
                enddo
             enddo
          enddo

          !
          !---  Neighbouring atoms
          xyz_this = xyz_crd(1:3,ia)
          do ir=1,nrest_per_atom(ia)
             in = rest_per_atom(ir,ia)
             if(atom_ref_flag(in).gt.0) then
                xyz_neighbour(1:3) = xyz_crd(1:3,in)
                
                isym = symm_per_atom(ir,1,ia)
                if(isym.ne.1.or.sum(abs(symm_per_atom(ir,2:4,ia))).ne.0) cycle
                xyz1 = matmul(cs_ort_to_frac,xyz_neighbour)
                xyz2 = matmul(rot(1:3,1:3,isym),xyz1)+tr(1:3,isym)+real(symm_per_atom(ir,2:4,ia))
                xyz_neighbour = matmul(cs_frac_to_ort,xyz2)
                
                xyz_ort = xyz_neighbour(1:3)-xyz_this(1:3)
                dist = sqrt(sum(xyz_ort(1:3)**2))
                wtt = 1.0
               
                call derivs_wrt_tlspars(xyz_ort,dudtls)

                u2v = u_aniso(1:6,in)
                call aniso_vect2mat(u2v,u2)
                if(isym.gt.1) then
                   tmp = matmul(rsymm_ort(1:3,1:3,isym),u2)
                   u2  = matmul(tmp,transpose(rsymm_ort(1:3,1:3,isym)))
                endif
                
                call aniso_mat2vec(u2,u2v)
                dfdu(1:3) = u2v(1:3)
                dfdu(4:6) = 2.0*u2v(4:6)
                d2fdu2(1:3) = 1.0
                d2fdu2(4:6) = 2.0
                
                dfdu = wtt*dfdu
                d2fdu2 = wtt*d2fdu2
                do k=1,20
                   do i=1,6 
                      dfdtls(k) = dfdtls(k) + dfdu(i)*dudtls(i,k)
                   enddo
                enddo
                do k=1,20
                   do l=1,20
                      do i=1,6
                         d2fdtls2(k,l) = d2fdtls2(k,l) + d2fdu2(i)*dudtls(i,k)*dudtls(i,l)
                      enddo
                   enddo
                enddo
             endif
          enddo
          if(nrest_per_atom(ia).ge.1) then
             call deigen_filter_r(toler,d2fdtls2,20,20,dfdtls,shft_tls, workspace,nwork_space)
             tmat_loc(1:6,ia) = shft_tls(1:6)
             lmat_loc(1:6,ia) = shft_tls(7:12)
             smat_loc(1:8,ia) = shft_tls(13:20)
          else
             tmat_loc(1:6,ia) = u_aniso(1:6,ia)
             lmat_loc(1:6,ia) = 0.0
             smat_loc(1:8,ia) = 0.0
          endif
          write(*,*)'i:',ia,n_atom
          write(*,*)'n:',nrest_per_atom(ia)
          write(*,*)'u:',u_aniso(1:6,ia)
          write(*,*)'t:',tmat_loc(1:6,ia)
          write(*,*)'l:',lmat_loc(1:6,ia)
          write(*,*)'s:',smat_loc(1:8,ia)

          call make_l_positive_1(tmat_loc(1:6,ia),lmat_loc(1:6,ia),smat_loc(1:8,ia))
          write(*,*)'after '
          write(*,*)'i:',ia,n_atom
          write(*,*)'n:',nrest_per_atom(ia)
          write(*,*)'u:',u_aniso(1:6,ia)
          write(*,*)'t:',tmat_loc(1:6,ia)
          write(*,*)'l:',lmat_loc(1:6,ia)
          write(*,*)'s:',smat_loc(1:8,ia)
       endif
    enddo

    write(*,*)'After local_tls_fit'
    stop
    return
  end subroutine local_tls_fit

  subroutine  local_tls2aniso(u_estim,tmat_loc,lmat_loc,smat_loc,maxrest,nrest_per_atom,rest_per_atom,symm_per_atom,  &
       xyz_crd,u_aniso,occup,rot,tr,cell)
    implicit none

    real, intent(in) :: xyz_crd(:,:),u_aniso(:,:),occup(:)
    real, intent(in) :: rot(:,:,:),tr(:,:),cell(6)
    !
    !--Convert local tls info to individual U values.
    real, intent(out) :: u_estim(:,:)
    real, intent(in) ::  tmat_loc(:,:),lmat_loc(:,:),smat_loc(:,:)
    integer maxrest
    integer, intent(in) :: nrest_per_atom(:),rest_per_atom(:,:)
    integer, intent(in) :: symm_per_atom(:,:,:)
    !
    !---  locals
    real dist,wtt
    real rsymm_ort(3,3,192)
    integer ia,ia1,ir,im,is
    real xyz_this(3),xyz_ort(3),xyz1(3),xyz2(3)
    real utls_out(6),u1(3,3),u2(3,3)
!
    real, allocatable :: weight(:)
    !
    !
    integer nsym,n_atom

    nsym = size(rot(1,1,:))
    n_atom = size(xyz_crd(1,:))
    
    call find_ort_symm(nsym,rot(1:3,1:3,1:nsym),tr(1:3,1:nsym),cell,rsymm_ort(1:3,1:3,1:nsym))
    allocate(weight(n_atom))
    weight(1:n_atom) = 0.0
    do ia=1,n_atom
       u_estim(1:6,ia) = tmat_loc(1:6,ia)
       weight(ia) = 1.0
    enddo

    !
    !---Add influence of neighbouring atoms
    im = 1
    do ia=1,n_atom
       if(atom_ref_flag(ia).gt.0) then
          xyz_this(1:3)  = xyz_crd(1:3,ia)
          do ir=1,nrest_per_atom(ia)
             ia1 = rest_per_atom(ir,ia)
             is = symm_per_atom(ir,1,ia)
             xyz1 = xyz_crd(1:3,ia1)
             xyz2 = matmul(cs_ort_to_frac,xyz1)
             xyz1 = matmul(rot(1:3,1:3,is),xyz2)+tr(1:3,is)
             xyz2 = xyz1 + real(symm_per_atom(ir,2:4,ia))
             xyz1 = matmul(cs_frac_to_ort,xyz2)
             xyz_ort = xyz1-xyz_this
             dist = sqrt(sum(xyz_ort(1:3)**2))
             wtt = 1.0
             call tls2aniso_individual(tmat_loc(1:6,ia),lmat_loc(1:6,ia),smat_loc(1:8,ia),xyz_ort,utls_out)
             call aniso_vect2mat(utls_out,u1)
             u2 = matmul(transpose(rsymm_ort(1:3,1:3,is)),u1)
             u1 = matmul(u2,rsymm_ort(1:3,1:3,is))
             call aniso_mat2vec(u1,utls_out)
             u_estim(1:6,ia1) = u_estim(1:6,ia1) + wtt*utls_out(1:6)
             weight(ia1) = weight(ia1) + wtt
          enddo
       endif
    enddo
    !
    do ia=1,n_atom
       if(atom_ref_flag(ia).gt.0) then
          if(abs(weight(ia)).gt.0.0) then
             u_estim(1:6,ia) = u_estim(1:6,ia)/weight(ia)
          else
             u_estim(1:6,ia) = u_aniso(1:6,ia)
          endif
       endif
    enddo
    deallocate(weight)
    write(*,*)'End of tls2aniso'
    return
  end subroutine local_tls2aniso
end module local_tls
