      subroutine ncsr_equivalences
      use ncs_generate
      implicit none
      include 'atom_com.fh'
      include 'ncs_rest.fh'
      include 'weights.fh'
      include 'restr_files.fh'
c
c--   Find ncs relationship automatically. It uses dynamic alignment

      real pen1,pen2
      real ncs_level,align_score
      integer nlen_align
      integer maxdiff_res,ir1,ir2,nres1,nres2
      integer i,j,ierr
      real dlim
c
c---  body
      pen1 = 0.0
      pen2 = 0.0
c
c---keywords should be read here. We can make better decision here
      ncs_level = 0.80

      if(.not.ncsr_flag) return

      if(number_ncsr.le.0) then
c
c--   Generate ncs restraint relationship. It is going to be active if no 
c---  ncs relatioship has been defined
         call ncs_rest_generate(number_ncsr,ich_type(1:n_group),
     &        ires_first(1:n_group),nres_chain(1:n_group),
     &        iratm_first(1:n_residue),natm_res(1:n_residue),
     &        asm_group_id(1:n_group),xyz_crd(1:3,1:n_atom),
     &        occup(1:n_atom),res_num_pdb(1:n_residue),
     &        res_name_pdb(1:n_residue),atm_name(1:n_atom),sigs,
     &        ncsr_level,align_rms_level,align_iter_flag,ncsr_file_name)
      else
         call ncsr_equivalences1
      endif
c
c---  Add neighbours also
      if(number_ncsr.gt.0) then
c         call ncs_rest_add_neighbours()
         dlim = 3.5
         call add_waters2chains(dlim)
         dlim = 3.5
         if(ncsr_neigb_include.eq.'Y') then
            call ncs_rest_add_neighbours(dlim,xyz_crd(1:3,1:n_atom),
     &           occup(1:n_atom),belongs_chain(1:n_atom),
     &           belongs_shell(1:n_atom),
     &           i_resid(1:n_atom), 
     &           res_num_pdb(1:n_residue),res_name(1:n_residue),
     &           atm_name(1:n_atom),
     &           cs_m_cs(1:3,1:3,1:cs_nsym),cs_v_cs(1:3,1:cs_nsym),
     &           cs_cell,ncsr_file_name,all_contacts_file)
         endif
c         stop
         write(*,*)
         if(ncsr_use.eq.'S') then
            write(*,'(5x,a)')'The program will use local ncs restraints'
            write(*,'(5x,a)')'I.e. corresonding distances between '//
     &           'ncs related molecules will be restrained.'
            write(*,'(5x,a)')'Covalent bonds and angles will '//
     &           'not be included in these restraints.' 
         elseif(ncsr_use.eq.'H') then
            write(*,'(5x,a)')'The program will use global restraints'
            write(*,'(5x,a)')'I.e. ncs related molecules will be '//
     &           'superimposed and'
            write(*,'(5x,a)')'difference between atomic positions '//
     &           'will be minimised '
         endif
         write(*,*)'-----------------------------------------------'//
     &        '-----------------------------------------------'
         write(*,*)
      else
         ncsr_flag = .FALSE.
      endif
      return
      end


c
      SUBROUTINE NCSR_EQUiVALENCES1
C
C---Finds NCS equavlences using keyword defined in RCARD.
      IMPLICIT NONE
      INCLUDE 'atom_com.fh'
      INCLUDE 'pls_incl.fh'
      INCLUDE 'ncs_rest.fh'
      INCLUDE 'restr_files.fh'
      include 'weights.fh'
C
c---  locals
      integer max_chain_cur
      INTEGER INCS,IRES,ICH,JRS,IR_FIRST_C,IR_LAST_C,ISP,
     &        IA_FIRST_C,IA_LAST_C,IATOM1,IATOM,IN_CH,IATOM_F,
     &        IAT_F,JAT_F,IAA_F,IAA_L,IRS_C,IRS_F,
     &        INCS_UNIT,IFAIL,LL,IWEIGHT
C
      character jrsc*4
C
c--allocatable memory
      INTEGER, allocatable :: NCS_IAT(:,:)
      integer, allocatable :: ICODE_IAT(:)
      character, allocatable :: IRS_NCS(:)*4
      integer, allocatable :: IRSATM_F(:)
      integer, allocatable :: IRATM_NCS(:)
C
      INTEGER LENSTR
      CHARACTER LINE*128
      character asmgrp*4
C
c---body

c----If keywrods have been given using group keyword then sort out in a 
c----seperate subroutine 
      incs_unit = 0
      if(ncs_inst_option.eq.'G') then
         call ncsr_equiv_group
         return
      endif
c
      max_chain_cur = 0
      do  incs=1,number_ncsr
         max_chain_cur = max(max_chain_cur,ncs_chain_num(incs))
      enddo
      allocate(ncs_iat(max_chain_cur,n_atom))
      allocate(icode_iat(n_atom))
      allocate(irs_ncs(n_atom))
      allocate(irsatm_f(n_atom))
      allocate(iratm_ncs(n_atom))
c
      call find_unique_file_name(ncsr_file_name,'_NCS_R')
C
      DO   INCS = 1,NUMBER_NCSR
C
c---Loop over NCS restraints.
C
C---Initialisations
        DO     ICH = 1,NCS_N_CHAIN(INCS)
          DO    IATOM = 1,N_ATOM
            NCS_IAT(ICH,IATOM) = 0
            ICODE_IAT(IATOM)   = 0
          ENDDO
        ENDDO
        IRS_F = 0
        IATOM1 = 0
        DO   ICH = 1,N_GROUP
C
c---Loop over chains to find first chain in the ncs restraint
           call get_asm_group_id(asmgrp,ich)
cd           write(*,*)asmgrp,NCS_CHAINS(1,INCS)
cd           stop
           IF(asmgrp.EQ.NCS_CHAINS(1,INCS)) THEN
C
C----Loop over residues in this chain
            IR_FIRST_C = IRES_FIRST(ICH)
            IR_LAST_C  = IRES_FIRST(ICH)+NRES_CHAIN(ICH)-1
            DO  IRES = IR_FIRST_C,IR_LAST_C
C
C---Check if residue is in the list of ncs sapns
               DO   ISP=1,NCS_SPANS(INCS)
C
C----find residue number from input coordinates.
                 READ(RES_NUM_PDB(IRES)(3:6),*)JRS
                 IF(JRS.GE.NCS_IRES_FIRST(ISP,INCS).AND.
     &              JRS.LE.NCS_IRES_LAST(ISP,INCS)) THEN
C
c---This residue belongs to ISPs span of INCS restraint. Save it
                   IA_FIRST_C      = IRATM_FIRST(IRES)
                   IA_LAST_C       = IA_FIRST_C + NATM_RES(IRES)-1
                   IRS_F           = IRS_F + 1
                   IRS_NCS(IRS_F)  = res_num_pdb(ires)(3:7)
                   IRSATM_F(IRS_F) = IATOM1 + 1
                   IRATM_NCS(IRS_F) = NATM_RES(IRES)
                   DO   IATOM = IA_FIRST_C,IA_LAST_C
                     IATOM1    = IATOM1 + 1
                     NCS_IAT(1,IATOM1) = IATOM
                     ICODE_IAT(IATOM1) = NCS_ICODE(ISP,INCS)
                   ENDDO
                 ENDIF
               ENDDO
             ENDDO
           ENDIF
        ENDDO
        IATOM_F = IATOM1
C
C---Now go through all other residues and find atom equavalences for the first
C---set of atoms
        IF(IRS_F.LE.0) THEN
          CALL ERRWRT(-1,'Number of atoms in chain 1 is 0')
          GOTO 900
        ENDIF
        DO   IN_CH = 2,NCS_N_CHAIN(INCS)
           IATOM1 = 0
           DO   ICH = 1,N_GROUP
C     
c---Loop over chains to find first chain in the ncs restraint
cd            WRITE(*,*)ASM_CHAIN_ID(ICH),ASM_GROUP_ID(ICH)
              call get_asm_group_id(asmgrp,ich)
              IF(asmgrp.EQ.NCS_CHAINS(IN_CH,INCS)) THEN
C     
C----Loop over residues in this chain
                 IR_FIRST_C = IRES_FIRST(ICH)
                 IR_LAST_C  = IRES_FIRST(ICH)+NRES_CHAIN(ICH)-1
                 DO  IRES = IR_FIRST_C,IR_LAST_C
C     
C---Chekc if residue is in the list of ncs sapns
                    DO   ISP=1,NCS_SPANS(INCS)
C
C----find residue number from input coordinates.
                       READ(RES_NUM_PDB(IRES)(3:6),*)JRS
                       IF(JRS.GE.NCS_IRES_FIRST(ISP,INCS).AND.
     &                      JRS.LE.NCS_IRES_LAST(ISP,INCS)) THEN
C     
c---This residue belongs to ISPs span of INCS restraint. Save it
                          jrsc = res_num_pdb(ires)(3:7)
                          DO   IRS_C = 1,IRS_F
                             IF(JRSc.EQ.IRS_NCS(IRS_C)) THEN
                                IA_FIRST_C = IRATM_FIRST(IRES)
                                IA_LAST_C  = IA_FIRST_C + 
     &                               NATM_RES(IRES)-1
                                DO   IATOM = IA_FIRST_C,IA_LAST_C
C---If this atom is in the first set. Then make them equavalent
C
                                   IAA_F = IRSATM_F(IRS_C)
                                   IAA_L = IAA_F + IRATM_NCS(IRS_C)-1
                                   DO    IAT_F = IAA_F,IAA_L
                                      JAT_F = NCS_IAT(1,IAT_F)
                                      IF(RES_NAME(I_RESID(JAT_F)).EQ.
     &                                     RES_NAME(I_RESID(IATOM))) 
     &                                                         THEN
                                         IF(ATM_NAME(IATOM).EQ.
     &                                        ATM_NAME(JAT_F).AND.
     &                                        ID_ALT(IATOM).EQ.
     &                                        ID_ALT(JAT_F))       THEN
                                            NCS_IAT(IN_CH,IAT_F)=IATOM
                                            IATOM1    = IATOM1 + 1
                                            GOTO 100
                                         ENDIF
                                      ENDIF
                                   ENDDO
 100                               CONTINUE
                                ENDDO
                             ENDIF
                          ENDDO
                       ENDIF
                    ENDDO
                 ENDDO
              ENDIF
           ENDDO
c
c---If one of chains have no atoms then skip this NCS
c     d          WRITE(*,*)'Chain ',IN_CH,IATOM1
           IF(IATOM1.LE.0) THEN
              CALL ERRWRT(-1,'One of the chains is empty')
              GOTO 900
           ENDIF
        ENDDO
C
C---count number of the equivalent atoms
        IATOM1 = 0
        DO   IATOM=1,IATOM_F
           DO    ICH = 1,NCS_N_CHAIN(INCS)
C
c---If 0 atom skip it
              IF(NCS_IAT(ICH,IATOM).LE.0) GOTO 200
C
C---If 0 occupancy skip it
              IF(OCCUP(NCS_IAT(ICH,IATOM)).LE.0.0) GOTO 200
           ENDDO
           IATOM1 = IATOM1 + 1
 200       CONTINUE
        ENDDO
        IF(IATOM1.LE.0) THEN 
          CALL ERRWRT(-1,'Number of equivalent atoms is 0')
          GOTO 900
        ENDIF
C
C---Number of equivalents is 0. Skip this NCS
C
C---Write atoms to output file for further use. For example in the subroutine 
C---NCS_REF
C---If file has not been opened then open it
cd        WRITE(*,*)'Number of equivalent atoms ',IATOM1
        IF(INCS_UNIT.LE.0) then
           call open_unform_file(incs_unit,ncsr_file_name,ifail)
           write(incs_unit)number_ncsr
        endif
        WRITE(INCS_UNIT)IATOM1,ncs_n_chain(incs)
        DO   IATOM=1,IATOM_F
          DO    ICH = 1,NCS_N_CHAIN(INCS)
C
c---If 0 atom skip it
             IF(NCS_IAT(ICH,IATOM).LE.0) GOTO 300
             IF(OCCUP(NCS_IAT(ICH,IATOM)).LE.0.0) GOTO 300

C
C---If 0 occupancy skip it
c             IF(OCCUP(NCS_IAT(ICH,IATOM)).LE.0.0) GOTO 300
          ENDDO
          CALL NCS_CODE2WEIGHT(ATM_NAME(NCS_IAT(1,IATOM)),
     &         ICODE_IAT(IATOM),IWEIGHT)
          WRITE(INCS_UNIT)IWEIGHT,sigs(iweight),sigs(iweight+3),
     &         (NCS_IAT(IAT_F,IATOM),IAT_F=1,NCS_N_CHAIN(INCS)),1.0
 300      CONTINUE
       ENDDO 
       GOTO 910
 900   CONTINUE
       CALL ERRWRT(-1,' ')
       CALL ERRWRT(-1,' ')
       WRITE(LINE,'(A,I12)')'Problem with NCS restraints ',INCS
       CALL ERRWRT(-1,LINE)
       CALL ERRWRT(-1,'Check NCSR/NONX line in input file')
       CALL ERRWRT(1,'Problem with NCS')
 910   CONTINUE
      ENDDO
      CLOSE(UNIT=INCS_UNIT)
c
      deallocate(ncs_iat)
      deallocate(icode_iat)
      deallocate(irs_ncs)
      deallocate(irsatm_f)
      deallocate(iratm_ncs)

      RETURN
      END
c
      subroutine ncsr_equiv_group
      implicit none
      include 'ncs_rest.fh'
      include 'atom_com.fh'
      include 'restr_files.fh'
c
c---locals
      integer j,ia,ja,jat,incs,max_cur_chain
      integer iatom1,iatom_f,irs_s,irs_f
      integer ich,ie,ir,jr,ir_f,ir_l
      integer ia_f,ia_l,ja_f,ja_l
      integer l,inch,jrs
      integer incs_unit,ifail,ll
      character asmgrp*4,jrsc*4
c
c---allocatable memory
      integer, allocatable :: ncs_iat(:,:)
      character, allocatable :: irs_ncs(:)*4
      integer, allocatable :: irsfatm_f(:)
      integer, allocatable :: iratm_ncs(:)
      integer, allocatable :: res_ref_ncs(:)
c
c---Externals
      integer lenstr
      external lenstr
c
c---body

      call find_unique_file_name(ncsr_file_name,'_NCS_R')
      call open_unform_file(incs_unit,ncsr_file_name,ifail)
      write(incs_unit)number_ncsr
c
      max_cur_chain = 0
      do  incs=1,number_ncsr
         max_cur_chain = max(max_cur_chain,ncs_chain_num(incs))
      enddo
      allocate(ncs_iat(max_cur_chain,n_atom))
      allocate(irs_ncs(n_residue))
      allocate(irsfatm_f(n_atom))
      allocate(iratm_ncs(n_atom))
      allocate(res_ref_ncs(n_atom))
c
      do  incs=1,number_ncsr
c
c---  Find chain (segid) names for 1st element in the equivalents of 
c---  ncs groupps
         iatom1 = 0
         irs_f  = 0
         do  ie=1,ncs_equiv_num(incs)
            irs_s=irs_f + 1
            do  ich=1,n_group
               call get_asm_group_id(asmgrp,ich)
               if(asmgrp.eq.ncs_equiv_ch(1,ie,incs)) then
                  ir_f = ires_first(ich)
                  ir_l  = ir_f  + nres_chain(ich)-1
                  do  ir=ir_f,ir_l
                     read(res_num_pdb(ir)(3:6),*)jrs
                     if(jrs.ge.ncs_equiv_res(1,ie,incs).and.
     &                    jrs.le.ncs_equiv_res(2,ie,incs)) then
                        ia_f = iratm_first(ir)
                        ia_l  = ia_f + natm_res(ir)-1
                        irs_f = irs_f + 1
                        irs_ncs(irs_f) = res_num_pdb(ir)(3:7)
                        irsfatm_f(irs_f) = iatom1 + 1
                        iratm_ncs(irs_f) = natm_res(ir)
                        res_ref_ncs(irs_f) = ir
                        do  ia=ia_f,ia_l
                           iatom1 = iatom1+1
                           ncs_iat(1,iatom1)=ia
                        enddo
                     endif
                  enddo
                  goto 100
               endif
            enddo
 100        continue
            iatom_f = iatom1
            if(irs_f.ge.irs_s) then
               do  inch=2,ncs_chain_num(incs)
                  do  ich=1,n_group
                     call get_asm_group_id(asmgrp,ich)
                     if(asmgrp.eq.ncs_equiv_ch(inch,ie,incs)) then
                        ir_f = ires_first(ich)
                        ir_l  = ir_f + nres_chain(ich)-1
                        do jr=irs_s,irs_f
                           do ir=ir_f,ir_l
                              read(res_num_pdb(ir)(3:6),*)jrs
                              if(jrs.ge.ncs_equiv_res(1,ie,incs).and.
     &                             jrs.le.ncs_equiv_res(2,ie,incs)) 
     &                                                            then
                                 jrsc=res_num_pdb(ir)(3:7)
                                 if(jrsc.eq.irs_ncs(jr).and.
     &                                res_name(ir).eq.
     &                                res_name(res_ref_ncs(jr))) then
                                    ia_f = iratm_first(ir)
                                    ia_l = ia_f + natm_res(ir)-1
                                    ja_f = irsfatm_f(jr)
                                    ja_l = ja_f+iratm_ncs(jr)-1
                                    do ja=ja_f,ja_l
                                       jat=ncs_iat(1,ja)
                                       do  ia=ia_f,ia_l
                                          if(atm_name(ia).eq.
     &                                       atm_name(jat).and.
     &                                       id_alt(ia).eq.id_alt(jat)) 
     &                                                            then
                                             ncs_iat(inch,ja)=ia
                                             goto 200
                                          endif
                                       enddo
 200                                   continue
                                    enddo
                                    goto 220
                                 endif
                              endif
                           enddo
 220                       continue
                        enddo
                        goto 250
                     endif
                  enddo
 250              continue
               enddo
            endif
         enddo
         if(iatom_f.le.0) then
            call errwrt(-1,'Problem with ncs definitions')
            call errwrt(-1,'Number of equivalent atoms equal to 0') 
            call errwrt(1,'Definition of ncs for group '
     &           //ncs_ids(incs)//' is not correct')
         else
            iatom1 = 0
            do  ia=1,iatom_f
               do  j=1,ncs_chain_num(incs)
                  if(ncs_iat(j,ia).le.0) then
                     goto 300
                  endif
                  if(occup(ncs_iat(j,ia)).le.0.0) then
                     goto 300
                  endif
               enddo
               iatom1 = iatom1 + 1
 300           continue
            enddo
            write(incs_unit)iatom1,ncs_chain_num(incs)
            do  ia=1,iatom_f
               do  j=1,ncs_chain_num(incs)
                  if(ncs_iat(j,ia).le.0) goto 400
                  if(occup(ncs_iat(j,ia)).le.0.0) goto 400
               enddo
               write(incs_unit)ncs_icode(ie,incs),
     &              sigx_ncs(incs),sigb_ncs(incs),
     &              (ncs_iat(j,ia),j=1,ncs_chain_num(incs)),1.0
 400           continue
            enddo
         endif
      enddo
c
c---deallocate and close
      deallocate(ncs_iat)
      deallocate(irs_ncs)
      deallocate(irsfatm_f)
      deallocate(iratm_ncs)
      deallocate(res_ref_ncs)
      close(incs_unit)
c
c--Process last errors
      return
      end
C
      SUBROUTINE NCS_CODE2WEIGHT(ATOM_NAME,ICODE,IWEIGHT)
c
c---Converts NCS restratint codes to restraint weighting numbers.
C
      IMPLICIT NONE
      INTEGER ICODE,IWEIGHT
      CHARACTER ATOM_NAME*(*)
C
      CHARACTER SIDE_OR_MAIN*1
      IF(ICODE.LT.1) ICODE = 1
      IF(ICODE.GT.6) ICODE = 6
C
      IF(ICODE.EQ.1) THEN
        IWEIGHT = 1
      ELSEIF(ICODE.EQ.4) THEN
        IWEIGHT = 2
      ELSEIF(ICODE.EQ.6) THEN
        IWEIGHT = 3
      ELSE
C
C---Check if atom is main or side chain
        CALL CHECK_SIDE_OR_MAIN(ATOM_NAME,SIDE_OR_MAIN)
        IF(ICODE.EQ.2.AND.SIDE_OR_MAIN.EQ.'M') THEN
          IWEIGHT = 1
        ELSEIF(ICODE.EQ.2.AND.SIDE_OR_MAIN.NE.'M') THEN
          IWEIGHT = 2
        ELSEIF(ICODE.EQ.3.AND.SIDE_OR_MAIN.EQ.'M') THEN
          IWEIGHT = 1
        ELSEIF(ICODE.EQ.3.AND.SIDE_OR_MAIN.NE.'M') THEN
          IWEIGHT = 3
        ELSEIF(ICODE.EQ.5.AND.SIDE_OR_MAIN.EQ.'M') THEN
          IWEIGHT = 2
        ELSEIF(ICODE.EQ.5.AND.SIDE_OR_MAIN.NE.'M') THEN
          IWEIGHT = 3
        ENDIF
      ENDIF
      RETURN
      END
C
      SUBROUTINE CHECK_SIDE_OR_MAIN(ATOM_NAME,SIDE_OR_MAIN)
C
C---Checks if atom is side or main chain atom
      IMPLICIT NONE
      CHARACTER ATOM_NAME*(*),SIDE_OR_MAIN*(*)
C
      SIDE_OR_MAIN = 'S'
      IF(ATOM_NAME(1:4).EQ.'CA  '.OR.ATOM_NAME(1:4).EQ.'N   '.OR.
     &   ATOM_NAME(1:4).EQ.'C   '.OR.ATOM_NAME(1:4).EQ.'O   '.OR.
     &   ATOM_NAME(1:4).EQ.'H   '.OR.ATOM_NAME(1:4).EQ.'HA  ')
     &             SIDE_OR_MAIN='M'
      RETURN
      END
c

