      subroutine local_tls_rest(sum_tmp,max_mat,max_vec,a_mat,vect,
     &            max_dist,n_target,n_object,nsym_dist,nw_uval)

      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'vitals.fh'
      include 'celsym.fh'
c
      real sum_tmp
      integer max_mat,max_vec
      real a_mat(*),vect(*)
      integer max_dist
      integer n_target(*),n_object(*),nsym_dist(4,*),nw_uval(*)
c
      integer maxrest
      integer, allocatable :: nrest_per_atom(:)
      integer, allocatable :: rest_per_atom(:,:)
      integer, allocatable :: symm_per_atom(:,:,:)
c
      real, allocatable :: tmat_loc(:,:)
      real, allocatable :: lmat_loc(:,:)
      real, allocatable :: smat_loc(:,:)
      real, allocatable :: u_estim(:,:)
c
      integer, allocatable :: lposv(:)
      integer, allocatable :: lposm(:)
c
      integer iposu1,iposu2,iposm,ian
      integer i,j,ia,ndist,im,ia1
c
      real wtt,delta
      real dfda(6),d2fda2(6,6),dadu(6)
      real u1v(6),u2v(6),u1(3,3),u2(3,3),u12(3,3)
c
      real trace_matmul_r
c
c
      ndist = ndis
      allocate(nrest_per_atom(n_atom))
      call find_max_neighbours(maxrest,n_atom,nrest_per_atom,ndist,
     &     n_target,n_object)


      allocate(rest_per_atom(maxrest,n_atom))
      allocate(symm_per_atom(maxrest,4,n_atom))

      call find_all_neighours(maxrest,n_atom,nrest_per_atom,
     &     rest_per_atom,
     &     symm_per_atom,ndist,n_target,n_object,nsym_dist,
     &     maxsym,NumSymmetry,RealSymmMatrx)
c
      allocate(tmat_loc(6,n_atom))
      allocate(lmat_loc(6,n_atom))
      allocate(smat_loc(8,n_atom))
c
      ndist = ndis
      call local_tls_fit(tmat_loc,lmat_loc,smat_loc,ndist,
     &     maxrest,nrest_per_atom,rest_per_atom,symm_per_atom)
c
      allocate(u_estim(6,n_atom))
      call local_tls2aniso(u_estim,tmat_loc,lmat_loc,smat_loc,maxrest,
     &     nrest_per_atom,rest_per_atom,symm_per_atom)

      allocate(lposv(n_atom))
      allocate(lposm(n_atom))
      call find_pos_of_u(maxatom,n_atom_mod,atom_ref_mod_flag,
     &     u_aniso_mod,lposv,lposm,1)

c      stop
      im = 1
      sum_tmp = 0.0
      wtt = 1.0/0.1**2
      ia1 = 0
      do ia=1,n_atom_mod(im)
         if(atom_ref_mod_flag(ia,im).gt.0) then
            ia1 = ia1 + 1
c            write(*,*)ia,u_aniso_mod(1:6,ia,im),u_estim(1:6,ia)
            u1v = u_aniso_mod(1:6,ia,im)
            call aniso_vect2mat(u1v,u1)
            u2v = u_estim(1:6,ia)
            call aniso_vect2mat(u2v,u2)
            u12 = u1-u2
c            write(*,*)'trace in'
            delta = trace_matmul_r(3,u12,u12)
c            write(*,*)'trace out'
            sum_tmp = sum_tmp + 0.5*wtt*delta
            dfda(1:6) = u1v-u2v
            dfda(4:6) = 2.0*dfda(4:6)
            d2fda2(1:6,1:6) = 0.0
            do i=1,3
               d2fda2(i,i) = 1.0
               d2fda2(i+3,i+3) = 2.0
            enddo
            dadu(1:6) = -1.0
            dfda = wtt*dfda
            d2fda2 = wtt*d2fda2
            iposu1 = lposv(ia1)
            iposu2 = iposu1+5
            iposm = lposm(ia1)
c            write(*,*)'Before vect',iposu1,iposu2,iposm
            vect(iposu1:iposu2) = vect(iposu1:iposu2) + 
     &           dfda(1:6)*dadu(1:6)
c            write(*,*)iposu1,iposu2
            do ian=1,6
               a_mat(iposm+ian-1) = a_mat(iposm+ian-1) + 
     &              d2fda2(ian,ian)*dadu(ian)*dadu(ian)
            enddo
c            write(*,*)'End of loop',iposm
         endif
      enddo

      deallocate(lposv)
      deallocate(lposm)
      deallocate(nrest_per_atom)
      deallocate(rest_per_atom)
      deallocate(symm_per_atom)
      deallocate(u_estim)
      deallocate(tmat_loc)
      deallocate(lmat_loc)
      deallocate(smat_loc)
c      write(*,*)'End of local_tls'
      return
      end
c
      subroutine local_tls_fit(tmat_loc,lmat_loc,smat_loc,ndist,
     &      maxrest,nrest_per_atom,rest_per_atom,symm_per_atom)
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
      include 'celsym.fh'
c
c---  This routine estimates local tls parameters for each atom.
c---  The number of atoms should be sufficient for this estimate to be reliable
c---  
      real tmat_loc(6,n_atom),lmat_loc(6,n_atom),smat_loc(8,n_atom)
      integer maxrest,ndist
      integer nrest_per_atom(n_atom),rest_per_atom(maxrest,n_atom)
      integer symm_per_atom(maxrest,4,n_atom)

      real ro_unit(3,3),rfr_unit(3,3)
      real rsymm_ort(3,3,192)
      integer i,j,k,l,ia,ir,in,im,is,isym,ierror
      real xyz_this(3),xyz_ort(3),xyz_neighbour(3),xyz1(3),xyz2(3)
      real u2v(6),u2(3,3),tmp(3,3)
      real dfdu(6),d2fdu2(6)
      real d2fd2(20,6)
      real dudtls(6,20)
      real*8 :: toler=1.0d-7
      real*8 dist,wtt
      real*8 dfdtls(20),d2fdtls2(20,20),shft_tls(20)
      real :: nwork_space = 1000
      real*8 workspace(1000)
c
c---  body 
c---  body
      call find_ort_symm(cs_nsym,cs_m_cs(1:3,1:3,1:cs_nsym),
     &     cs_v_cs(1:3,1:cs_nsym),cs_cell,rsymm_ort(1:3,1:3,1:cs_nsym))
            
      im = 1
      do ia=1,n_atom
c
c---Central atom
         if(atom_ref_flag(ia).gt.0) then
            xyz_ort(1:3) = 0.0
            call derivs_wrt_tlspars(xyz_ort,dudtls)
            dfdu = u_aniso_mod(1:6,ia,im)
            dfdu(4:6) = 2.0*dfdu(4:6)
            d2fdu2(1:3) = 1.0
            d2fdu2(4:6) = 2.0
c
            dfdtls(1:20) = 0.0
            d2fdtls2(1:20,1:20) = 0.0
            do k=1,20
               do i=1,6
                  dfdtls(k) = dfdtls(k) + dfdu(i)*dudtls(i,k) 
               enddo
            enddo
            
            do k=1,20
               do l=1,20
                  do i=1,6
                     d2fdtls2(k,l) = d2fdtls2(k,l) + 
     &                    d2fdu2(i)*dudtls(i,k)*dudtls(i,l) 
                  enddo
               enddo
            enddo
c         do k=1,20
c            write(*,*)k,d2fdtls2(k,1:20)
c         enddo
c         stop
c
c---  Neighbouring atoms
            xyz_this = xyz_crd_mod(1:3,ia,im)
            do ir=1,nrest_per_atom(ia)
               in = rest_per_atom(ir,ia)
               if(atom_ref_flag(in).gt.0) then
                  xyz_neighbour(1:3) = xyz_crd_mod(1:3,in,im)

                  isym = symm_per_atom(ir,1,ia)
                  if(isym.ne.1.or.
     &                 sum(abs(symm_per_atom(ir,2:4,ia))).ne.0) goto 75
                  xyz1 = matmul(cs_ort_to_frac,xyz_neighbour)
                  xyz2 = matmul(cs_m_cs(1:3,1:3,isym),xyz1)+
     &                 cs_v_cs(1:3,isym)+real(symm_per_atom(ir,2:4,ia))
                  xyz_neighbour = matmul(cs_frac_to_ort,xyz2)

                  xyz_ort = xyz_neighbour(1:3)-xyz_this(1:3)
                  dist = sqrt(sum(xyz_ort(1:3)**2))
                  wtt = 1.0
c            if(dist.gt.2.0d0) wtt = 4.0d0/dist**2
c            write(*,*)dist,wtt
                  call derivs_wrt_tlspars(xyz_ort,dudtls)
c            if(isym.gt.1) then
c               write(*,*)'symm',symm_per_atom(ir,1:4,ia),
c     &              sqrt(sum(xyz_ort(1:3)**2))
c            endif
                  u2v = u_aniso_mod(1:6,in,im)
                  call aniso_vect2mat(u2v,u2)
                  if(isym.gt.1) then
                     tmp = matmul(rsymm_ort(1:3,1:3,isym),u2)
                     u2  = matmul(tmp,
     &                    transpose(rsymm_ort(1:3,1:3,isym)))
                  endif

                  call aniso_mat2vec(u2,u2v)
                  dfdu(1:3) = u2v(1:3)
                  dfdu(4:6) = 2.0*u2v(4:6)
                  d2fdu2(1:3) = 1.0
                  d2fdu2(4:6) = 2.0
               
                  dfdu = wtt*dfdu
                  d2fdu2 = wtt*d2fdu2
                  do k=1,20
                     do i=1,6 
                        dfdtls(k) = dfdtls(k) + dfdu(i)*dudtls(i,k)
                     enddo
                  enddo
                  do k=1,20
                     do l=1,20
                        do i=1,6
                           d2fdtls2(k,l) = d2fdtls2(k,l) + 
     &                          d2fdu2(i)*dudtls(i,k)*dudtls(i,l)
                        enddo
                     enddo
                  enddo
               endif
 75            continue
            enddo
            if(nrest_per_atom(ia).ge.1) then
               call deigen_filter_r(toler,d2fdtls2,20,20,dfdtls,
     &              shft_tls, workspace,nwork_space)
               tmat_loc(1:6,ia) = shft_tls(1:6)
               lmat_loc(1:6,ia) = shft_tls(7:12)
               smat_loc(1:8,ia) = shft_tls(13:20)
            else
               tmat_loc(1:6,ia) = u_aniso_mod(1:6,ia,im)
               lmat_loc(1:6,ia) = 0.0
               smat_loc(1:8,ia) = 0.0
            endif
            write(*,*)'i:',ia,n_atom
            write(*,*)'n:',nrest_per_atom(ia)
            write(*,*)'u:',u_aniso_mod(1:6,ia,im)
            write(*,*)'t:',tmat_loc(1:6,ia)
            write(*,*)'l:',lmat_loc(1:6,ia)
            write(*,*)'s:',smat_loc(1:8,ia)
c
            call make_l_positive_1(tmat_loc(1:6,ia),lmat_loc(1:6,ia),
     &           smat_loc(1:8,ia))
            write(*,*)'after '
            write(*,*)'i:',ia,n_atom
            write(*,*)'n:',nrest_per_atom(ia)
            write(*,*)'u:',u_aniso_mod(1:6,ia,im)
            write(*,*)'t:',tmat_loc(1:6,ia)
            write(*,*)'l:',lmat_loc(1:6,ia)
            write(*,*)'s:',smat_loc(1:8,ia)
         endif
      enddo
c
      write(*,*)'After local_tls_fit'
      stop
      return
      end
c
      subroutine  local_tls2aniso(u_estim,tmat_loc,lmat_loc,smat_loc,
     &     maxrest,nrest_per_atom,rest_per_atom,symm_per_atom)
      implicit none
      include 'atom_com.fh'
      include 'models.fh'
c
c--Convert local tls info to individual U values.
      real u_estim(6,n_atom)
      real tmat_loc(6,n_atom),lmat_loc(6,n_atom),smat_loc(8,n_atom)
      integer maxrest
      integer nrest_per_atom(n_atom),rest_per_atom(maxrest,n_atom)
      integer symm_per_atom(maxrest,4,n_atom)
c
c---  locals
      real dist,wtt
      real rsymm_ort(3,3,192)
      integer ia,ia1,ir,im,is
      real xyz_this(3),xyz_ort(3),xyz1(3),xyz2(3)
      real utls_out(6),u1(3,3),u2(3,3)
c
      real, allocatable :: weight(:)

      call find_ort_symm(cs_nsym,cs_m_cs(1:3,1:3,1:cs_nsym),
     &     cs_v_cs(1:3,1:cs_nsym),cs_cell,rsymm_ort(1:3,1:3,1:cs_nsym))
      allocate(weight(n_atom))
      weight(1:n_atom) = 0.0
      do ia=1,n_atom
         u_estim(1:6,ia) = tmat_loc(1:6,ia)
         weight(ia) = 1.0
      enddo
c      deallocate(weight)
c      return
c
c---Add influence of neighbouring atoms
      im = 1
      do ia=1,n_atom
         if(atom_ref_flag(ia).gt.0) then
         xyz_this(1:3)  = xyz_crd_mod(1:3,ia,im)
         do ir=1,nrest_per_atom(ia)
            ia1 = rest_per_atom(ir,ia)
            is = symm_per_atom(ir,1,ia)
            xyz1 = xyz_crd_mod(1:3,ia1,im)
            xyz2 = matmul(cs_ort_to_frac,xyz1)
            xyz1 = matmul(cs_m_cs(1:3,1:3,is),xyz2)+cs_v_cs(1:3,is)
            xyz2 = xyz1 + real(symm_per_atom(ir,2:4,ia))
            xyz1 = matmul(cs_frac_to_ort,xyz2)
            xyz_ort = xyz1-xyz_this
            dist = sqrt(sum(xyz_ort(1:3)**2))
            wtt = 1.0
c            if(dist.gt.2.0) wtt = 4.0/dist**2
            call tls2aniso_individual(tmat_loc(1:6,ia),lmat_loc(1:6,ia),
     &           smat_loc(1:8,ia),xyz_ort,utls_out)
            call aniso_vect2mat(utls_out,u1)
            u2 = matmul(transpose(rsymm_ort(1:3,1:3,is)),u1)
            u1 = matmul(u2,rsymm_ort(1:3,1:3,is))
            call aniso_mat2vec(u1,utls_out)
            u_estim(1:6,ia1) = u_estim(1:6,ia1) + wtt*utls_out(1:6)
            weight(ia1) = weight(ia1) + wtt
         enddo
         endif
      enddo
c
      do ia=1,n_atom
         if(atom_ref_flag(ia).gt.0) then
            if(abs(weight(ia)).gt.0.0) then
               u_estim(1:6,ia) = u_estim(1:6,ia)/weight(ia)
            else
               u_estim(1:6,ia) = u_aniso_mod(1:6,ia,im)
            endif
c            write(*,*)'tma:',1.0,tmat_loc(1:6,ia)
c            write(*,*)'uou:',weight(ia),u_estim(1:6,ia)
c            write(*,*)'uan:',1.0,u_aniso_mod(1:6,ia,im)
         endif
      enddo
      deallocate(weight)
      write(*,*)'End of tls2aniso'
c      stop
      return
      end
